/*
 *
 *    Copyright (c) 2022 Project CHIP Authors
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

// THIS FILE IS GENERATED BY ZAP

#pragma once

#if CONFIG_ENABLE_YAML_TESTS

#include <commands/tests/TestCommandBridge.h>
#include <lib/core/Optional.h>
#include <system/SystemClock.h>

#include <math.h> // For INFINITY

typedef void (^ResponseHandler)(id _Nullable value, NSError * _Nullable error);

class TestList : public Command {
public:
    TestList()
        : Command("list") {};
    CHIP_ERROR Run() override
    {
        printf("TestAccessControlCluster\n");
        printf("Test_TC_ACL_1_1\n");
        printf("Test_TC_ACL_2_1\n");
        printf("Test_TC_ACL_2_2\n");
        printf("Test_TC_BOOL_1_1\n");
        printf("Test_TC_BOOL_2_1\n");
        printf("Test_TC_ACT_1_1\n");
        printf("Test_TC_BIND_1_1\n");
        printf("Test_TC_CC_1_1\n");
        printf("Test_TC_CC_2_1\n");
        printf("Test_TC_CC_3_2\n");
        printf("Test_TC_CC_3_3\n");
        printf("Test_TC_CC_4_1\n");
        printf("Test_TC_CC_4_2\n");
        printf("Test_TC_CC_4_3\n");
        printf("Test_TC_CC_4_4\n");
        printf("Test_TC_CC_5_1\n");
        printf("Test_TC_CC_5_2\n");
        printf("Test_TC_CC_5_3\n");
        printf("Test_TC_CC_6_1\n");
        printf("Test_TC_CC_7_3\n");
        printf("Test_TC_CC_7_4\n");
        printf("Test_TC_OPCREDS_1_2\n");
        printf("Test_TC_BINFO_1_1\n");
        printf("Test_TC_CNET_1_3\n");
        printf("Test_TC_DESC_1_1\n");
        printf("Test_TC_DLOG_1_1\n");
        printf("Test_TC_DGETH_1_1\n");
        printf("Test_TC_DGETH_2_1\n");
        printf("Test_TC_DGETH_2_2\n");
        printf("Test_TC_FLW_1_1\n");
        printf("Test_TC_FLW_2_1\n");
        printf("Test_TC_FLABEL_1_1\n");
        printf("Test_TC_CGEN_1_1\n");
        printf("Test_TC_CGEN_2_1\n");
        printf("Test_TC_DGGEN_1_1\n");
        printf("Test_TC_DGGEN_2_1\n");
        printf("Test_TC_I_1_1\n");
        printf("Test_TC_I_2_1\n");
        printf("Test_TC_I_2_2\n");
        printf("Test_TC_I_2_3\n");
        printf("Test_TC_ILL_1_1\n");
        printf("Test_TC_ILL_2_1\n");
        printf("Test_TC_ILL_2_2\n");
        printf("Test_TC_LVL_1_1\n");
        printf("Test_TC_LVL_2_1\n");
        printf("Test_TC_LVL_2_2\n");
        printf("Test_TC_LVL_3_1\n");
        printf("Test_TC_LVL_4_1\n");
        printf("Test_TC_LVL_5_1\n");
        printf("Test_TC_LVL_6_1\n");
        printf("Test_TC_LCFG_1_1\n");
        printf("Test_TC_LUNIT_1_2\n");
        printf("Test_TC_LTIME_1_2\n");
        printf("Test_TC_LOWPOWER_1_1\n");
        printf("Test_TC_KEYPADINPUT_1_2\n");
        printf("Test_TC_APPLAUNCHER_1_3\n");
        printf("Test_TC_MEDIAINPUT_1_4\n");
        printf("Test_TC_WAKEONLAN_1_5\n");
        printf("Test_TC_CHANNEL_1_6\n");
        printf("Test_TC_MEDIAPLAYBACK_1_7\n");
        printf("Test_TC_AUDIOOUTPUT_1_8\n");
        printf("Test_TC_TGTNAV_1_9\n");
        printf("Test_TC_TGTNAV_8_2\n");
        printf("Test_TC_APBSC_1_10\n");
        printf("Test_TC_CONTENTLAUNCHER_1_11\n");
        printf("Test_TC_ALOGIN_1_12\n");
        printf("Test_TC_LOWPOWER_2_1\n");
        printf("Test_TC_KEYPADINPUT_3_2\n");
        printf("Test_TC_KEYPADINPUT_3_3\n");
        printf("Test_TC_APPLAUNCHER_3_5\n");
        printf("Test_TC_APPLAUNCHER_3_6\n");
        printf("Test_TC_MEDIAINPUT_3_10\n");
        printf("Test_TC_MEDIAINPUT_3_11\n");
        printf("Test_TC_MEDIAINPUT_3_12\n");
        printf("Test_TC_MEDIAINPUT_3_13\n");
        printf("Test_TC_CHANNEL_5_1\n");
        printf("Test_TC_CHANNEL_5_2\n");
        printf("Test_TC_CHANNEL_5_3\n");
        printf("Test_TC_MEDIAPLAYBACK_6_1\n");
        printf("Test_TC_MEDIAPLAYBACK_6_2\n");
        printf("Test_TC_MEDIAPLAYBACK_6_3\n");
        printf("Test_TC_MEDIAPLAYBACK_6_4\n");
        printf("Test_TC_AUDIOOUTPUT_7_1\n");
        printf("Test_TC_AUDIOOUTPUT_7_2\n");
        printf("Test_TC_TGTNAV_8_1\n");
        printf("Test_TC_APBSC_9_1\n");
        printf("Test_TC_CONTENTLAUNCHER_10_1\n");
        printf("Test_TC_MOD_1_1\n");
        printf("OTA_SuccessfulTransfer\n");
        printf("Test_TC_OCC_1_1\n");
        printf("Test_TC_OCC_2_1\n");
        printf("Test_TC_OO_1_1\n");
        printf("Test_TC_OO_2_1\n");
        printf("Test_TC_OO_2_2\n");
        printf("Test_TC_OO_2_4\n");
        printf("Test_TC_PS_1_1\n");
        printf("Test_TC_PS_2_1\n");
        printf("Test_TC_PRS_1_1\n");
        printf("Test_TC_PRS_2_1\n");
        printf("Test_TC_PRS_2_2\n");
        printf("Test_TC_PCC_1_1\n");
        printf("Test_TC_PCC_2_1\n");
        printf("Test_TC_PCC_2_2\n");
        printf("Test_TC_PCC_2_3\n");
        printf("Test_TC_PCC_2_4\n");
        printf("Test_TC_PSCFG_1_1\n");
        printf("Test_TC_PSCFG_2_1\n");
        printf("Test_TC_RH_1_1\n");
        printf("Test_TC_RH_2_1\n");
        printf("Test_TC_SWTCH_1_1\n");
        printf("Test_TC_TMP_1_1\n");
        printf("Test_TC_TMP_2_1\n");
        printf("Test_TC_TSTAT_1_1\n");
        printf("Test_TC_TSUIC_1_1\n");
        printf("Test_TC_TSUIC_2_1\n");
        printf("Test_TC_TSUIC_2_2\n");
        printf("Test_TC_DGTHREAD_1_1\n");
        printf("Test_TC_ULABEL_1_1\n");
        printf("Test_TC_ULABEL_2_1\n");
        printf("Test_TC_ULABEL_2_2\n");
        printf("Test_TC_ULABEL_2_3\n");
        printf("Test_TC_ULABEL_2_4\n");
        printf("Test_TC_DGWIFI_1_1\n");
        printf("Test_TC_DGWIFI_2_1\n");
        printf("Test_TC_DGWIFI_2_3\n");
        printf("Test_TC_WNCV_1_1\n");
        printf("Test_TC_WNCV_2_1\n");
        printf("Test_TC_WNCV_2_2\n");
        printf("Test_TC_WNCV_2_3\n");
        printf("Test_TC_WNCV_2_4\n");
        printf("Test_TC_WNCV_2_5\n");
        printf("Test_TC_WNCV_3_1\n");
        printf("Test_TC_WNCV_3_2\n");
        printf("Test_TC_WNCV_3_3\n");
        printf("Test_TC_WNCV_3_4\n");
        printf("Test_TC_WNCV_3_5\n");
        printf("Test_TC_WNCV_4_1\n");
        printf("Test_TC_WNCV_4_2\n");
        printf("Test_TC_WNCV_4_3\n");
        printf("Test_TC_WNCV_4_4\n");
        printf("Test_TC_WNCV_4_5\n");
        printf("TV_TargetNavigatorCluster\n");
        printf("TV_AudioOutputCluster\n");
        printf("TV_ApplicationLauncherCluster\n");
        printf("TV_KeypadInputCluster\n");
        printf("TV_AccountLoginCluster\n");
        printf("TV_WakeOnLanCluster\n");
        printf("TV_ApplicationBasicCluster\n");
        printf("TV_MediaPlaybackCluster\n");
        printf("TV_ChannelCluster\n");
        printf("TV_LowPowerCluster\n");
        printf("TV_ContentLauncherCluster\n");
        printf("TV_MediaInputCluster\n");
        printf("TestCASERecovery\n");
        printf("TestCluster\n");
        printf("TestConstraints\n");
        printf("TestDelayCommands\n");
        printf("TestLogCommands\n");
        printf("TestSaveAs\n");
        printf("TestConfigVariables\n");
        printf("TestDescriptorCluster\n");
        printf("TestBasicInformation\n");
        printf("TestFabricRemovalWhileSubscribed\n");
        printf("TestGeneralCommissioning\n");
        printf("TestIdentifyCluster\n");
        printf("TestOperationalCredentialsCluster\n");
        printf("TestModeSelectCluster\n");
        printf("TestSelfFabricRemoval\n");
        printf("TestSystemCommands\n");
        printf("TestBinding\n");
        printf("TestUserLabelCluster\n");
        printf("TestUserLabelClusterConstraints\n");
        printf("TestArmFailSafe\n");
        printf("TestFanControl\n");
        printf("TestAccessControlConstraints\n");
        printf("TestLevelControlWithOnOffDependency\n");
        printf("TestCommissioningWindow\n");
        printf("TestMultiAdmin\n");
        printf("Test_TC_DGSW_1_1\n");
        printf("TestSubscribe_OnOff\n");
        printf("DL_UsersAndCredentials\n");
        printf("DL_LockUnlock\n");
        printf("DL_Schedules\n");
        printf("Test_TC_DRLK_1_1\n");
        printf("Test_TC_DRLK_2_2\n");
        printf("Test_TC_DRLK_2_3\n");
        printf("Test_TC_DRLK_2_4\n");
        printf("Test_TC_DRLK_2_5\n");
        printf("Test_TC_DRLK_2_7\n");
        printf("Test_TC_DRLK_2_9\n");
        printf("TestGroupsCluster\n");
        printf("TestGroupKeyManagementCluster\n");
        printf("Test_TC_G_1_1\n");

        return CHIP_NO_ERROR;
    }
};

class ManualTestList : public Command {
public:
    ManualTestList()
        : Command("list-manual") {};
    CHIP_ERROR Run() override { return CHIP_NO_ERROR; }
};

class TestAccessControlCluster : public TestCommandBridge {
public:
    // NOLINTBEGIN(clang-analyzer-nullability.NullPassedToNonnull): Test constructor nullability not enforced
    TestAccessControlCluster()
        : TestCommandBridge("TestAccessControlCluster")
        , mTestIndex(0)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }
    // NOLINTEND(clang-analyzer-nullability.NullPassedToNonnull)

    ~TestAccessControlCluster() {}

    /////////// TestCommand Interface /////////
    void NextTest() override
    {
        CHIP_ERROR err = CHIP_NO_ERROR;

        if (0 == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Start: TestAccessControlCluster\n");
        }

        if (mTestCount == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Complete: TestAccessControlCluster\n");
            SetCommandExitStatus(CHIP_NO_ERROR);
            return;
        }

        Wait();

        // Ensure we increment mTestIndex before we start running the relevant
        // command.  That way if we lose the timeslice after we send the message
        // but before our function call returns, we won't end up with an
        // incorrect mTestIndex value observed when we get the response.
        switch (mTestIndex++) {
        case 0:
            ChipLogProgress(chipTool, " ***** Test Step 0 : Wait for commissionee\n");
            err = TestWaitForCommissionee_0();
            break;
        case 1:
            ChipLogProgress(chipTool, " ***** Test Step 1 : Write entries\n");
            err = TestWriteEntries_1();
            break;
        case 2:
            ChipLogProgress(chipTool, " ***** Test Step 2 : Verify\n");
            err = TestVerify_2();
            break;
        case 3:
            ChipLogProgress(chipTool, " ***** Test Step 3 : Write entries empty lists\n");
            err = TestWriteEntriesEmptyLists_3();
            break;
        case 4:
            ChipLogProgress(chipTool, " ***** Test Step 4 : Verify\n");
            err = TestVerify_4();
            break;
        case 5:
            ChipLogProgress(chipTool, " ***** Test Step 5 : Write entry invalid privilege\n");
            err = TestWriteEntryInvalidPrivilege_5();
            break;
        case 6:
            ChipLogProgress(chipTool, " ***** Test Step 6 : Verify\n");
            err = TestVerify_6();
            break;
        case 7:
            ChipLogProgress(chipTool, " ***** Test Step 7 : Write entry invalid auth mode\n");
            err = TestWriteEntryInvalidAuthMode_7();
            break;
        case 8:
            ChipLogProgress(chipTool, " ***** Test Step 8 : Verify\n");
            err = TestVerify_8();
            break;
        case 9:
            ChipLogProgress(chipTool, " ***** Test Step 9 : Write entry invalid subject\n");
            err = TestWriteEntryInvalidSubject_9();
            break;
        case 10:
            ChipLogProgress(chipTool, " ***** Test Step 10 : Verify\n");
            err = TestVerify_10();
            break;
        case 11:
            ChipLogProgress(chipTool, " ***** Test Step 11 : Write entry invalid target\n");
            err = TestWriteEntryInvalidTarget_11();
            break;
        case 12:
            ChipLogProgress(chipTool, " ***** Test Step 12 : Verify\n");
            err = TestVerify_12();
            break;
        case 13:
            ChipLogProgress(chipTool, " ***** Test Step 13 : Write entry too many subjects\n");
            err = TestWriteEntryTooManySubjects_13();
            break;
        case 14:
            ChipLogProgress(chipTool, " ***** Test Step 14 : Verify\n");
            err = TestVerify_14();
            break;
        case 15:
            ChipLogProgress(chipTool, " ***** Test Step 15 : Write entry too many targets\n");
            err = TestWriteEntryTooManyTargets_15();
            break;
        case 16:
            ChipLogProgress(chipTool, " ***** Test Step 16 : Verify\n");
            err = TestVerify_16();
            break;
        case 17:
            ChipLogProgress(chipTool, " ***** Test Step 17 : Write too many entries\n");
            err = TestWriteTooManyEntries_17();
            break;
        case 18:
            ChipLogProgress(chipTool, " ***** Test Step 18 : Verify\n");
            err = TestVerify_18();
            break;
        case 19:
            ChipLogProgress(chipTool, " ***** Test Step 19 : Restore ACL\n");
            err = TestRestoreAcl_19();
            break;
        case 20:
            ChipLogProgress(chipTool, " ***** Test Step 20 : Verify\n");
            err = TestVerify_20();
            break;
        case 21:
            ChipLogProgress(chipTool, " ***** Test Step 21 : Validate resource minima (SubjectsPerAccessControlEntry)\n");
            err = TestValidateResourceMinimaSubjectsPerAccessControlEntry_21();
            break;
        case 22:
            ChipLogProgress(chipTool, " ***** Test Step 22 : Validate resource minima (TargetsPerAccessControlEntry)\n");
            err = TestValidateResourceMinimaTargetsPerAccessControlEntry_22();
            break;
        case 23:
            ChipLogProgress(chipTool, " ***** Test Step 23 : Validate resource minima (AccessControlEntriesPerFabric)\n");
            err = TestValidateResourceMinimaAccessControlEntriesPerFabric_23();
            break;
        }

        if (CHIP_NO_ERROR != err) {
            ChipLogError(chipTool, " ***** Test Failure: %s\n", chip::ErrorStr(err));
            SetCommandExitStatus(err);
        }
    }

    void OnStatusUpdate(const chip::app::StatusIB & status) override
    {
        switch (mTestIndex - 1) {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), EMBER_ZCL_STATUS_CONSTRAINT_ERROR));
            break;
        case 6:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 7:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), EMBER_ZCL_STATUS_CONSTRAINT_ERROR));
            break;
        case 8:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 9:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), EMBER_ZCL_STATUS_CONSTRAINT_ERROR));
            break;
        case 10:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 11:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), EMBER_ZCL_STATUS_CONSTRAINT_ERROR));
            break;
        case 12:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 13:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), EMBER_ZCL_STATUS_FAILURE));
            break;
        case 14:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 15:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), EMBER_ZCL_STATUS_FAILURE));
            break;
        case 16:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 17:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), EMBER_ZCL_STATUS_RESOURCE_EXHAUSTED));
            break;
        case 18:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 19:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 20:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 21:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 22:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 23:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        }

        // Go on to the next test.
        ContinueOnChipMainThread(CHIP_NO_ERROR);
    }

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    std::atomic_uint16_t mTestIndex;
    const uint16_t mTestCount = 24;

    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    CHIP_ERROR TestWaitForCommissionee_0()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
        value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
        return WaitForCommissionee("alpha", value);
    }

    CHIP_ERROR TestWriteEntries_1()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterAccessControl alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        id aclArgument;
        {
            NSMutableArray * temp_0 = [[NSMutableArray alloc] init];
            temp_0[0] = [[MTRAccessControlClusterAccessControlEntry alloc] init];
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[0]).privilege = [NSNumber numberWithUnsignedChar:5U];
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[0]).authMode = [NSNumber numberWithUnsignedChar:2U];
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[0]).subjects = nil;
            {
                NSMutableArray * temp_3 = [[NSMutableArray alloc] init];
                temp_3[0] = [[MTRAccessControlClusterTarget alloc] init];
                ((MTRAccessControlClusterTarget *) temp_3[0]).cluster = nil;
                ((MTRAccessControlClusterTarget *) temp_3[0]).endpoint = [NSNumber numberWithUnsignedShort:0U];
                ((MTRAccessControlClusterTarget *) temp_3[0]).deviceType = nil;

                temp_3[1] = [[MTRAccessControlClusterTarget alloc] init];
                ((MTRAccessControlClusterTarget *) temp_3[1]).cluster = [NSNumber numberWithUnsignedInt:1UL];
                ((MTRAccessControlClusterTarget *) temp_3[1]).endpoint = nil;
                ((MTRAccessControlClusterTarget *) temp_3[1]).deviceType = nil;

                temp_3[2] = [[MTRAccessControlClusterTarget alloc] init];
                ((MTRAccessControlClusterTarget *) temp_3[2]).cluster = [NSNumber numberWithUnsignedInt:2UL];
                ((MTRAccessControlClusterTarget *) temp_3[2]).endpoint = [NSNumber numberWithUnsignedShort:3U];
                ((MTRAccessControlClusterTarget *) temp_3[2]).deviceType = nil;

                ((MTRAccessControlClusterAccessControlEntry *) temp_0[0]).targets = temp_3;
            }
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[0]).fabricIndex = [NSNumber numberWithUnsignedChar:0U];

            temp_0[1] = [[MTRAccessControlClusterAccessControlEntry alloc] init];
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[1]).privilege = [NSNumber numberWithUnsignedChar:1U];
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[1]).authMode = [NSNumber numberWithUnsignedChar:2U];
            {
                NSMutableArray * temp_3 = [[NSMutableArray alloc] init];
                temp_3[0] = [NSNumber numberWithUnsignedLongLong:4ULL];
                temp_3[1] = [NSNumber numberWithUnsignedLongLong:5ULL];
                temp_3[2] = [NSNumber numberWithUnsignedLongLong:6ULL];
                temp_3[3] = [NSNumber numberWithUnsignedLongLong:7ULL];
                ((MTRAccessControlClusterAccessControlEntry *) temp_0[1]).subjects = temp_3;
            }
            {
                NSMutableArray * temp_3 = [[NSMutableArray alloc] init];
                temp_3[0] = [[MTRAccessControlClusterTarget alloc] init];
                ((MTRAccessControlClusterTarget *) temp_3[0]).cluster = nil;
                ((MTRAccessControlClusterTarget *) temp_3[0]).endpoint = [NSNumber numberWithUnsignedShort:8U];
                ((MTRAccessControlClusterTarget *) temp_3[0]).deviceType = nil;

                temp_3[1] = [[MTRAccessControlClusterTarget alloc] init];
                ((MTRAccessControlClusterTarget *) temp_3[1]).cluster = [NSNumber numberWithUnsignedInt:9UL];
                ((MTRAccessControlClusterTarget *) temp_3[1]).endpoint = nil;
                ((MTRAccessControlClusterTarget *) temp_3[1]).deviceType = nil;

                temp_3[2] = [[MTRAccessControlClusterTarget alloc] init];
                ((MTRAccessControlClusterTarget *) temp_3[2]).cluster = [NSNumber numberWithUnsignedInt:10UL];
                ((MTRAccessControlClusterTarget *) temp_3[2]).endpoint = [NSNumber numberWithUnsignedShort:11U];
                ((MTRAccessControlClusterTarget *) temp_3[2]).deviceType = nil;

                ((MTRAccessControlClusterAccessControlEntry *) temp_0[1]).targets = temp_3;
            }
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[1]).fabricIndex = [NSNumber numberWithUnsignedChar:0U];

            temp_0[2] = [[MTRAccessControlClusterAccessControlEntry alloc] init];
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[2]).privilege = [NSNumber numberWithUnsignedChar:3U];
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[2]).authMode = [NSNumber numberWithUnsignedChar:3U];
            {
                NSMutableArray * temp_3 = [[NSMutableArray alloc] init];
                temp_3[0] = [NSNumber numberWithUnsignedLongLong:12ULL];
                temp_3[1] = [NSNumber numberWithUnsignedLongLong:13ULL];
                temp_3[2] = [NSNumber numberWithUnsignedLongLong:14ULL];
                temp_3[3] = [NSNumber numberWithUnsignedLongLong:15ULL];
                ((MTRAccessControlClusterAccessControlEntry *) temp_0[2]).subjects = temp_3;
            }
            {
                NSMutableArray * temp_3 = [[NSMutableArray alloc] init];
                temp_3[0] = [[MTRAccessControlClusterTarget alloc] init];
                ((MTRAccessControlClusterTarget *) temp_3[0]).cluster = nil;
                ((MTRAccessControlClusterTarget *) temp_3[0]).endpoint = [NSNumber numberWithUnsignedShort:16U];
                ((MTRAccessControlClusterTarget *) temp_3[0]).deviceType = nil;

                temp_3[1] = [[MTRAccessControlClusterTarget alloc] init];
                ((MTRAccessControlClusterTarget *) temp_3[1]).cluster = [NSNumber numberWithUnsignedInt:17UL];
                ((MTRAccessControlClusterTarget *) temp_3[1]).endpoint = nil;
                ((MTRAccessControlClusterTarget *) temp_3[1]).deviceType = nil;

                temp_3[2] = [[MTRAccessControlClusterTarget alloc] init];
                ((MTRAccessControlClusterTarget *) temp_3[2]).cluster = [NSNumber numberWithUnsignedInt:18UL];
                ((MTRAccessControlClusterTarget *) temp_3[2]).endpoint = [NSNumber numberWithUnsignedShort:19U];
                ((MTRAccessControlClusterTarget *) temp_3[2]).deviceType = nil;

                ((MTRAccessControlClusterAccessControlEntry *) temp_0[2]).targets = temp_3;
            }
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[2]).fabricIndex = [NSNumber numberWithUnsignedChar:0U];

            aclArgument = temp_0;
        }
        [cluster writeAttributeACLWithValue:aclArgument
                                 completion:^(NSError * _Nullable err) {
                                     NSLog(@"Write entries Error: %@", err);

                                     VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                                     NextTest();
                                 }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestVerify_2()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterAccessControl alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        __auto_type * params = [[MTRReadParams alloc] init];
        params.fabricFiltered = true;
        [cluster readAttributeACLWithParams:params
                                 completion:^(NSArray * _Nullable value, NSError * _Nullable err) {
                                     NSLog(@"Verify Error: %@", err);

                                     VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                                     {
                                         id actualValue = value;
                                         VerifyOrReturn(CheckValue("ACL", [actualValue count], static_cast<uint32_t>(3)));
                                         VerifyOrReturn(CheckValue("Privilege",
                                             ((MTRAccessControlClusterAccessControlEntry *) actualValue[0]).privilege, 5U));
                                         VerifyOrReturn(CheckValue("AuthMode",
                                             ((MTRAccessControlClusterAccessControlEntry *) actualValue[0]).authMode, 2U));
                                         VerifyOrReturn(CheckValueNull(
                                             "Subjects", ((MTRAccessControlClusterAccessControlEntry *) actualValue[0]).subjects));
                                         VerifyOrReturn(CheckValueNonNull(
                                             "Targets", ((MTRAccessControlClusterAccessControlEntry *) actualValue[0]).targets));
                                         VerifyOrReturn(CheckValue("Targets",
                                             [((MTRAccessControlClusterAccessControlEntry *) actualValue[0]).targets count],
                                             static_cast<uint32_t>(3)));
                                         VerifyOrReturn(CheckValueNull("Cluster",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[0])
                                                     .targets[0])
                                                 .cluster));
                                         VerifyOrReturn(CheckValueNonNull("Endpoint",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[0])
                                                     .targets[0])
                                                 .endpoint));
                                         VerifyOrReturn(CheckValue("Endpoint",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[0])
                                                     .targets[0])
                                                 .endpoint,
                                             0U));
                                         VerifyOrReturn(CheckValueNull("DeviceType",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[0])
                                                     .targets[0])
                                                 .deviceType));
                                         VerifyOrReturn(CheckValueNonNull("Cluster",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[0])
                                                     .targets[1])
                                                 .cluster));
                                         VerifyOrReturn(CheckValue("Cluster",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[0])
                                                     .targets[1])
                                                 .cluster,
                                             1UL));
                                         VerifyOrReturn(CheckValueNull("Endpoint",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[0])
                                                     .targets[1])
                                                 .endpoint));
                                         VerifyOrReturn(CheckValueNull("DeviceType",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[0])
                                                     .targets[1])
                                                 .deviceType));
                                         VerifyOrReturn(CheckValueNonNull("Cluster",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[0])
                                                     .targets[2])
                                                 .cluster));
                                         VerifyOrReturn(CheckValue("Cluster",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[0])
                                                     .targets[2])
                                                 .cluster,
                                             2UL));
                                         VerifyOrReturn(CheckValueNonNull("Endpoint",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[0])
                                                     .targets[2])
                                                 .endpoint));
                                         VerifyOrReturn(CheckValue("Endpoint",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[0])
                                                     .targets[2])
                                                 .endpoint,
                                             3U));
                                         VerifyOrReturn(CheckValueNull("DeviceType",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[0])
                                                     .targets[2])
                                                 .deviceType));
                                         VerifyOrReturn(CheckValue("FabricIndex",
                                             ((MTRAccessControlClusterAccessControlEntry *) actualValue[0]).fabricIndex, 1U));
                                         VerifyOrReturn(CheckValue("Privilege",
                                             ((MTRAccessControlClusterAccessControlEntry *) actualValue[1]).privilege, 1U));
                                         VerifyOrReturn(CheckValue("AuthMode",
                                             ((MTRAccessControlClusterAccessControlEntry *) actualValue[1]).authMode, 2U));
                                         VerifyOrReturn(CheckValueNonNull(
                                             "Subjects", ((MTRAccessControlClusterAccessControlEntry *) actualValue[1]).subjects));
                                         VerifyOrReturn(CheckValue("Subjects",
                                             [((MTRAccessControlClusterAccessControlEntry *) actualValue[1]).subjects count],
                                             static_cast<uint32_t>(4)));
                                         VerifyOrReturn(CheckValue(
                                             "", ((MTRAccessControlClusterAccessControlEntry *) actualValue[1]).subjects[0], 4ULL));
                                         VerifyOrReturn(CheckValue(
                                             "", ((MTRAccessControlClusterAccessControlEntry *) actualValue[1]).subjects[1], 5ULL));
                                         VerifyOrReturn(CheckValue(
                                             "", ((MTRAccessControlClusterAccessControlEntry *) actualValue[1]).subjects[2], 6ULL));
                                         VerifyOrReturn(CheckValue(
                                             "", ((MTRAccessControlClusterAccessControlEntry *) actualValue[1]).subjects[3], 7ULL));
                                         VerifyOrReturn(CheckValueNonNull(
                                             "Targets", ((MTRAccessControlClusterAccessControlEntry *) actualValue[1]).targets));
                                         VerifyOrReturn(CheckValue("Targets",
                                             [((MTRAccessControlClusterAccessControlEntry *) actualValue[1]).targets count],
                                             static_cast<uint32_t>(3)));
                                         VerifyOrReturn(CheckValueNull("Cluster",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[1])
                                                     .targets[0])
                                                 .cluster));
                                         VerifyOrReturn(CheckValueNonNull("Endpoint",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[1])
                                                     .targets[0])
                                                 .endpoint));
                                         VerifyOrReturn(CheckValue("Endpoint",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[1])
                                                     .targets[0])
                                                 .endpoint,
                                             8U));
                                         VerifyOrReturn(CheckValueNull("DeviceType",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[1])
                                                     .targets[0])
                                                 .deviceType));
                                         VerifyOrReturn(CheckValueNonNull("Cluster",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[1])
                                                     .targets[1])
                                                 .cluster));
                                         VerifyOrReturn(CheckValue("Cluster",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[1])
                                                     .targets[1])
                                                 .cluster,
                                             9UL));
                                         VerifyOrReturn(CheckValueNull("Endpoint",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[1])
                                                     .targets[1])
                                                 .endpoint));
                                         VerifyOrReturn(CheckValueNull("DeviceType",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[1])
                                                     .targets[1])
                                                 .deviceType));
                                         VerifyOrReturn(CheckValueNonNull("Cluster",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[1])
                                                     .targets[2])
                                                 .cluster));
                                         VerifyOrReturn(CheckValue("Cluster",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[1])
                                                     .targets[2])
                                                 .cluster,
                                             10UL));
                                         VerifyOrReturn(CheckValueNonNull("Endpoint",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[1])
                                                     .targets[2])
                                                 .endpoint));
                                         VerifyOrReturn(CheckValue("Endpoint",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[1])
                                                     .targets[2])
                                                 .endpoint,
                                             11U));
                                         VerifyOrReturn(CheckValueNull("DeviceType",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[1])
                                                     .targets[2])
                                                 .deviceType));
                                         VerifyOrReturn(CheckValue("FabricIndex",
                                             ((MTRAccessControlClusterAccessControlEntry *) actualValue[1]).fabricIndex, 1U));
                                         VerifyOrReturn(CheckValue("Privilege",
                                             ((MTRAccessControlClusterAccessControlEntry *) actualValue[2]).privilege, 3U));
                                         VerifyOrReturn(CheckValue("AuthMode",
                                             ((MTRAccessControlClusterAccessControlEntry *) actualValue[2]).authMode, 3U));
                                         VerifyOrReturn(CheckValueNonNull(
                                             "Subjects", ((MTRAccessControlClusterAccessControlEntry *) actualValue[2]).subjects));
                                         VerifyOrReturn(CheckValue("Subjects",
                                             [((MTRAccessControlClusterAccessControlEntry *) actualValue[2]).subjects count],
                                             static_cast<uint32_t>(4)));
                                         VerifyOrReturn(CheckValue("",
                                             ((MTRAccessControlClusterAccessControlEntry *) actualValue[2]).subjects[0], 12ULL));
                                         VerifyOrReturn(CheckValue("",
                                             ((MTRAccessControlClusterAccessControlEntry *) actualValue[2]).subjects[1], 13ULL));
                                         VerifyOrReturn(CheckValue("",
                                             ((MTRAccessControlClusterAccessControlEntry *) actualValue[2]).subjects[2], 14ULL));
                                         VerifyOrReturn(CheckValue("",
                                             ((MTRAccessControlClusterAccessControlEntry *) actualValue[2]).subjects[3], 15ULL));
                                         VerifyOrReturn(CheckValueNonNull(
                                             "Targets", ((MTRAccessControlClusterAccessControlEntry *) actualValue[2]).targets));
                                         VerifyOrReturn(CheckValue("Targets",
                                             [((MTRAccessControlClusterAccessControlEntry *) actualValue[2]).targets count],
                                             static_cast<uint32_t>(3)));
                                         VerifyOrReturn(CheckValueNull("Cluster",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[2])
                                                     .targets[0])
                                                 .cluster));
                                         VerifyOrReturn(CheckValueNonNull("Endpoint",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[2])
                                                     .targets[0])
                                                 .endpoint));
                                         VerifyOrReturn(CheckValue("Endpoint",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[2])
                                                     .targets[0])
                                                 .endpoint,
                                             16U));
                                         VerifyOrReturn(CheckValueNull("DeviceType",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[2])
                                                     .targets[0])
                                                 .deviceType));
                                         VerifyOrReturn(CheckValueNonNull("Cluster",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[2])
                                                     .targets[1])
                                                 .cluster));
                                         VerifyOrReturn(CheckValue("Cluster",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[2])
                                                     .targets[1])
                                                 .cluster,
                                             17UL));
                                         VerifyOrReturn(CheckValueNull("Endpoint",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[2])
                                                     .targets[1])
                                                 .endpoint));
                                         VerifyOrReturn(CheckValueNull("DeviceType",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[2])
                                                     .targets[1])
                                                 .deviceType));
                                         VerifyOrReturn(CheckValueNonNull("Cluster",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[2])
                                                     .targets[2])
                                                 .cluster));
                                         VerifyOrReturn(CheckValue("Cluster",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[2])
                                                     .targets[2])
                                                 .cluster,
                                             18UL));
                                         VerifyOrReturn(CheckValueNonNull("Endpoint",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[2])
                                                     .targets[2])
                                                 .endpoint));
                                         VerifyOrReturn(CheckValue("Endpoint",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[2])
                                                     .targets[2])
                                                 .endpoint,
                                             19U));
                                         VerifyOrReturn(CheckValueNull("DeviceType",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[2])
                                                     .targets[2])
                                                 .deviceType));
                                         VerifyOrReturn(CheckValue("FabricIndex",
                                             ((MTRAccessControlClusterAccessControlEntry *) actualValue[2]).fabricIndex, 1U));
                                     }

                                     NextTest();
                                 }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWriteEntriesEmptyLists_3()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterAccessControl alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        id aclArgument;
        {
            NSMutableArray * temp_0 = [[NSMutableArray alloc] init];
            temp_0[0] = [[MTRAccessControlClusterAccessControlEntry alloc] init];
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[0]).privilege = [NSNumber numberWithUnsignedChar:5U];
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[0]).authMode = [NSNumber numberWithUnsignedChar:2U];
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[0]).subjects = nil;
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[0]).targets = nil;
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[0]).fabricIndex = [NSNumber numberWithUnsignedChar:0U];

            temp_0[1] = [[MTRAccessControlClusterAccessControlEntry alloc] init];
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[1]).privilege = [NSNumber numberWithUnsignedChar:1U];
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[1]).authMode = [NSNumber numberWithUnsignedChar:2U];
            {
                NSMutableArray * temp_3 = [[NSMutableArray alloc] init];
                ((MTRAccessControlClusterAccessControlEntry *) temp_0[1]).subjects = temp_3;
            }
            {
                NSMutableArray * temp_3 = [[NSMutableArray alloc] init];
                ((MTRAccessControlClusterAccessControlEntry *) temp_0[1]).targets = temp_3;
            }
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[1]).fabricIndex = [NSNumber numberWithUnsignedChar:0U];

            aclArgument = temp_0;
        }
        [cluster writeAttributeACLWithValue:aclArgument
                                 completion:^(NSError * _Nullable err) {
                                     NSLog(@"Write entries empty lists Error: %@", err);

                                     VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                                     NextTest();
                                 }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestVerify_4()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterAccessControl alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        __auto_type * params = [[MTRReadParams alloc] init];
        params.fabricFiltered = true;
        [cluster readAttributeACLWithParams:params
                                 completion:^(NSArray * _Nullable value, NSError * _Nullable err) {
                                     NSLog(@"Verify Error: %@", err);

                                     VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                                     {
                                         id actualValue = value;
                                         VerifyOrReturn(CheckValue("ACL", [actualValue count], static_cast<uint32_t>(2)));
                                         VerifyOrReturn(CheckValue("Privilege",
                                             ((MTRAccessControlClusterAccessControlEntry *) actualValue[0]).privilege, 5U));
                                         VerifyOrReturn(CheckValue("AuthMode",
                                             ((MTRAccessControlClusterAccessControlEntry *) actualValue[0]).authMode, 2U));
                                         VerifyOrReturn(CheckValueNull(
                                             "Subjects", ((MTRAccessControlClusterAccessControlEntry *) actualValue[0]).subjects));
                                         VerifyOrReturn(CheckValueNull(
                                             "Targets", ((MTRAccessControlClusterAccessControlEntry *) actualValue[0]).targets));
                                         VerifyOrReturn(CheckValue("FabricIndex",
                                             ((MTRAccessControlClusterAccessControlEntry *) actualValue[0]).fabricIndex, 1U));
                                         VerifyOrReturn(CheckValue("Privilege",
                                             ((MTRAccessControlClusterAccessControlEntry *) actualValue[1]).privilege, 1U));
                                         VerifyOrReturn(CheckValue("AuthMode",
                                             ((MTRAccessControlClusterAccessControlEntry *) actualValue[1]).authMode, 2U));
                                         VerifyOrReturn(CheckValueNull(
                                             "Subjects", ((MTRAccessControlClusterAccessControlEntry *) actualValue[1]).subjects));
                                         VerifyOrReturn(CheckValueNull(
                                             "Targets", ((MTRAccessControlClusterAccessControlEntry *) actualValue[1]).targets));
                                         VerifyOrReturn(CheckValue("FabricIndex",
                                             ((MTRAccessControlClusterAccessControlEntry *) actualValue[1]).fabricIndex, 1U));
                                     }

                                     NextTest();
                                 }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWriteEntryInvalidPrivilege_5()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterAccessControl alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        id aclArgument;
        {
            NSMutableArray * temp_0 = [[NSMutableArray alloc] init];
            temp_0[0] = [[MTRAccessControlClusterAccessControlEntry alloc] init];
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[0]).privilege = [NSNumber numberWithUnsignedChar:5U];
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[0]).authMode = [NSNumber numberWithUnsignedChar:2U];
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[0]).subjects = nil;
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[0]).targets = nil;
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[0]).fabricIndex = [NSNumber numberWithUnsignedChar:0U];

            temp_0[1] = [[MTRAccessControlClusterAccessControlEntry alloc] init];
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[1]).privilege = [NSNumber numberWithUnsignedChar:5U];
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[1]).authMode = [NSNumber numberWithUnsignedChar:3U];
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[1]).subjects = nil;
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[1]).targets = nil;
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[1]).fabricIndex = [NSNumber numberWithUnsignedChar:0U];

            aclArgument = temp_0;
        }
        [cluster writeAttributeACLWithValue:aclArgument
                                 completion:^(NSError * _Nullable err) {
                                     NSLog(@"Write entry invalid privilege Error: %@", err);

                                     VerifyOrReturn(CheckValue("status",
                                         err ? ([err.domain isEqualToString:MTRInteractionErrorDomain] ? err.code
                                                                                                       : EMBER_ZCL_STATUS_FAILURE)
                                             : 0,
                                         EMBER_ZCL_STATUS_CONSTRAINT_ERROR));
                                     NextTest();
                                 }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestVerify_6()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterAccessControl alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        __auto_type * params = [[MTRReadParams alloc] init];
        params.fabricFiltered = true;
        [cluster readAttributeACLWithParams:params
                                 completion:^(NSArray * _Nullable value, NSError * _Nullable err) {
                                     NSLog(@"Verify Error: %@", err);

                                     VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                                     {
                                         id actualValue = value;
                                         VerifyOrReturn(CheckValue("ACL", [actualValue count], static_cast<uint32_t>(1)));
                                         VerifyOrReturn(CheckValue("Privilege",
                                             ((MTRAccessControlClusterAccessControlEntry *) actualValue[0]).privilege, 5U));
                                         VerifyOrReturn(CheckValue("AuthMode",
                                             ((MTRAccessControlClusterAccessControlEntry *) actualValue[0]).authMode, 2U));
                                         VerifyOrReturn(CheckValueNull(
                                             "Subjects", ((MTRAccessControlClusterAccessControlEntry *) actualValue[0]).subjects));
                                         VerifyOrReturn(CheckValueNull(
                                             "Targets", ((MTRAccessControlClusterAccessControlEntry *) actualValue[0]).targets));
                                         VerifyOrReturn(CheckValue("FabricIndex",
                                             ((MTRAccessControlClusterAccessControlEntry *) actualValue[0]).fabricIndex, 1U));
                                     }

                                     NextTest();
                                 }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWriteEntryInvalidAuthMode_7()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterAccessControl alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        id aclArgument;
        {
            NSMutableArray * temp_0 = [[NSMutableArray alloc] init];
            temp_0[0] = [[MTRAccessControlClusterAccessControlEntry alloc] init];
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[0]).privilege = [NSNumber numberWithUnsignedChar:5U];
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[0]).authMode = [NSNumber numberWithUnsignedChar:2U];
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[0]).subjects = nil;
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[0]).targets = nil;
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[0]).fabricIndex = [NSNumber numberWithUnsignedChar:0U];

            temp_0[1] = [[MTRAccessControlClusterAccessControlEntry alloc] init];
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[1]).privilege = [NSNumber numberWithUnsignedChar:1U];
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[1]).authMode = [NSNumber numberWithUnsignedChar:1U];
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[1]).subjects = nil;
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[1]).targets = nil;
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[1]).fabricIndex = [NSNumber numberWithUnsignedChar:0U];

            aclArgument = temp_0;
        }
        [cluster writeAttributeACLWithValue:aclArgument
                                 completion:^(NSError * _Nullable err) {
                                     NSLog(@"Write entry invalid auth mode Error: %@", err);

                                     VerifyOrReturn(CheckValue("status",
                                         err ? ([err.domain isEqualToString:MTRInteractionErrorDomain] ? err.code
                                                                                                       : EMBER_ZCL_STATUS_FAILURE)
                                             : 0,
                                         EMBER_ZCL_STATUS_CONSTRAINT_ERROR));
                                     NextTest();
                                 }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestVerify_8()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterAccessControl alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        __auto_type * params = [[MTRReadParams alloc] init];
        params.fabricFiltered = true;
        [cluster readAttributeACLWithParams:params
                                 completion:^(NSArray * _Nullable value, NSError * _Nullable err) {
                                     NSLog(@"Verify Error: %@", err);

                                     VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                                     {
                                         id actualValue = value;
                                         VerifyOrReturn(CheckValue("ACL", [actualValue count], static_cast<uint32_t>(1)));
                                         VerifyOrReturn(CheckValue("Privilege",
                                             ((MTRAccessControlClusterAccessControlEntry *) actualValue[0]).privilege, 5U));
                                         VerifyOrReturn(CheckValue("AuthMode",
                                             ((MTRAccessControlClusterAccessControlEntry *) actualValue[0]).authMode, 2U));
                                         VerifyOrReturn(CheckValueNull(
                                             "Subjects", ((MTRAccessControlClusterAccessControlEntry *) actualValue[0]).subjects));
                                         VerifyOrReturn(CheckValueNull(
                                             "Targets", ((MTRAccessControlClusterAccessControlEntry *) actualValue[0]).targets));
                                         VerifyOrReturn(CheckValue("FabricIndex",
                                             ((MTRAccessControlClusterAccessControlEntry *) actualValue[0]).fabricIndex, 1U));
                                     }

                                     NextTest();
                                 }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWriteEntryInvalidSubject_9()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterAccessControl alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        id aclArgument;
        {
            NSMutableArray * temp_0 = [[NSMutableArray alloc] init];
            temp_0[0] = [[MTRAccessControlClusterAccessControlEntry alloc] init];
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[0]).privilege = [NSNumber numberWithUnsignedChar:5U];
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[0]).authMode = [NSNumber numberWithUnsignedChar:2U];
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[0]).subjects = nil;
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[0]).targets = nil;
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[0]).fabricIndex = [NSNumber numberWithUnsignedChar:0U];

            temp_0[1] = [[MTRAccessControlClusterAccessControlEntry alloc] init];
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[1]).privilege = [NSNumber numberWithUnsignedChar:1U];
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[1]).authMode = [NSNumber numberWithUnsignedChar:2U];
            {
                NSMutableArray * temp_3 = [[NSMutableArray alloc] init];
                temp_3[0] = [NSNumber numberWithUnsignedLongLong:0ULL];
                ((MTRAccessControlClusterAccessControlEntry *) temp_0[1]).subjects = temp_3;
            }
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[1]).targets = nil;
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[1]).fabricIndex = [NSNumber numberWithUnsignedChar:0U];

            aclArgument = temp_0;
        }
        [cluster writeAttributeACLWithValue:aclArgument
                                 completion:^(NSError * _Nullable err) {
                                     NSLog(@"Write entry invalid subject Error: %@", err);

                                     VerifyOrReturn(CheckValue("status",
                                         err ? ([err.domain isEqualToString:MTRInteractionErrorDomain] ? err.code
                                                                                                       : EMBER_ZCL_STATUS_FAILURE)
                                             : 0,
                                         EMBER_ZCL_STATUS_CONSTRAINT_ERROR));
                                     NextTest();
                                 }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestVerify_10()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterAccessControl alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        __auto_type * params = [[MTRReadParams alloc] init];
        params.fabricFiltered = true;
        [cluster readAttributeACLWithParams:params
                                 completion:^(NSArray * _Nullable value, NSError * _Nullable err) {
                                     NSLog(@"Verify Error: %@", err);

                                     VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                                     {
                                         id actualValue = value;
                                         VerifyOrReturn(CheckValue("ACL", [actualValue count], static_cast<uint32_t>(1)));
                                         VerifyOrReturn(CheckValue("Privilege",
                                             ((MTRAccessControlClusterAccessControlEntry *) actualValue[0]).privilege, 5U));
                                         VerifyOrReturn(CheckValue("AuthMode",
                                             ((MTRAccessControlClusterAccessControlEntry *) actualValue[0]).authMode, 2U));
                                         VerifyOrReturn(CheckValueNull(
                                             "Subjects", ((MTRAccessControlClusterAccessControlEntry *) actualValue[0]).subjects));
                                         VerifyOrReturn(CheckValueNull(
                                             "Targets", ((MTRAccessControlClusterAccessControlEntry *) actualValue[0]).targets));
                                         VerifyOrReturn(CheckValue("FabricIndex",
                                             ((MTRAccessControlClusterAccessControlEntry *) actualValue[0]).fabricIndex, 1U));
                                     }

                                     NextTest();
                                 }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWriteEntryInvalidTarget_11()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterAccessControl alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        id aclArgument;
        {
            NSMutableArray * temp_0 = [[NSMutableArray alloc] init];
            temp_0[0] = [[MTRAccessControlClusterAccessControlEntry alloc] init];
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[0]).privilege = [NSNumber numberWithUnsignedChar:5U];
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[0]).authMode = [NSNumber numberWithUnsignedChar:2U];
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[0]).subjects = nil;
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[0]).targets = nil;
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[0]).fabricIndex = [NSNumber numberWithUnsignedChar:0U];

            temp_0[1] = [[MTRAccessControlClusterAccessControlEntry alloc] init];
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[1]).privilege = [NSNumber numberWithUnsignedChar:1U];
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[1]).authMode = [NSNumber numberWithUnsignedChar:2U];
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[1]).subjects = nil;
            {
                NSMutableArray * temp_3 = [[NSMutableArray alloc] init];
                temp_3[0] = [[MTRAccessControlClusterTarget alloc] init];
                ((MTRAccessControlClusterTarget *) temp_3[0]).cluster = nil;
                ((MTRAccessControlClusterTarget *) temp_3[0]).endpoint = nil;
                ((MTRAccessControlClusterTarget *) temp_3[0]).deviceType = nil;

                ((MTRAccessControlClusterAccessControlEntry *) temp_0[1]).targets = temp_3;
            }
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[1]).fabricIndex = [NSNumber numberWithUnsignedChar:0U];

            aclArgument = temp_0;
        }
        [cluster writeAttributeACLWithValue:aclArgument
                                 completion:^(NSError * _Nullable err) {
                                     NSLog(@"Write entry invalid target Error: %@", err);

                                     VerifyOrReturn(CheckValue("status",
                                         err ? ([err.domain isEqualToString:MTRInteractionErrorDomain] ? err.code
                                                                                                       : EMBER_ZCL_STATUS_FAILURE)
                                             : 0,
                                         EMBER_ZCL_STATUS_CONSTRAINT_ERROR));
                                     NextTest();
                                 }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestVerify_12()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterAccessControl alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        __auto_type * params = [[MTRReadParams alloc] init];
        params.fabricFiltered = true;
        [cluster readAttributeACLWithParams:params
                                 completion:^(NSArray * _Nullable value, NSError * _Nullable err) {
                                     NSLog(@"Verify Error: %@", err);

                                     VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                                     {
                                         id actualValue = value;
                                         VerifyOrReturn(CheckValue("ACL", [actualValue count], static_cast<uint32_t>(1)));
                                         VerifyOrReturn(CheckValue("Privilege",
                                             ((MTRAccessControlClusterAccessControlEntry *) actualValue[0]).privilege, 5U));
                                         VerifyOrReturn(CheckValue("AuthMode",
                                             ((MTRAccessControlClusterAccessControlEntry *) actualValue[0]).authMode, 2U));
                                         VerifyOrReturn(CheckValueNull(
                                             "Subjects", ((MTRAccessControlClusterAccessControlEntry *) actualValue[0]).subjects));
                                         VerifyOrReturn(CheckValueNull(
                                             "Targets", ((MTRAccessControlClusterAccessControlEntry *) actualValue[0]).targets));
                                         VerifyOrReturn(CheckValue("FabricIndex",
                                             ((MTRAccessControlClusterAccessControlEntry *) actualValue[0]).fabricIndex, 1U));
                                     }

                                     NextTest();
                                 }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWriteEntryTooManySubjects_13()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterAccessControl alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        id aclArgument;
        {
            NSMutableArray * temp_0 = [[NSMutableArray alloc] init];
            temp_0[0] = [[MTRAccessControlClusterAccessControlEntry alloc] init];
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[0]).privilege = [NSNumber numberWithUnsignedChar:5U];
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[0]).authMode = [NSNumber numberWithUnsignedChar:2U];
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[0]).subjects = nil;
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[0]).targets = nil;
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[0]).fabricIndex = [NSNumber numberWithUnsignedChar:0U];

            temp_0[1] = [[MTRAccessControlClusterAccessControlEntry alloc] init];
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[1]).privilege = [NSNumber numberWithUnsignedChar:1U];
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[1]).authMode = [NSNumber numberWithUnsignedChar:2U];
            {
                NSMutableArray * temp_3 = [[NSMutableArray alloc] init];
                temp_3[0] = [NSNumber numberWithUnsignedLongLong:1ULL];
                temp_3[1] = [NSNumber numberWithUnsignedLongLong:2ULL];
                temp_3[2] = [NSNumber numberWithUnsignedLongLong:3ULL];
                temp_3[3] = [NSNumber numberWithUnsignedLongLong:4ULL];
                temp_3[4] = [NSNumber numberWithUnsignedLongLong:5ULL];
                temp_3[5] = [NSNumber numberWithUnsignedLongLong:6ULL];
                temp_3[6] = [NSNumber numberWithUnsignedLongLong:7ULL];
                temp_3[7] = [NSNumber numberWithUnsignedLongLong:8ULL];
                temp_3[8] = [NSNumber numberWithUnsignedLongLong:9ULL];
                temp_3[9] = [NSNumber numberWithUnsignedLongLong:10ULL];
                temp_3[10] = [NSNumber numberWithUnsignedLongLong:11ULL];
                temp_3[11] = [NSNumber numberWithUnsignedLongLong:12ULL];
                temp_3[12] = [NSNumber numberWithUnsignedLongLong:13ULL];
                temp_3[13] = [NSNumber numberWithUnsignedLongLong:14ULL];
                temp_3[14] = [NSNumber numberWithUnsignedLongLong:15ULL];
                temp_3[15] = [NSNumber numberWithUnsignedLongLong:16ULL];
                temp_3[16] = [NSNumber numberWithUnsignedLongLong:17ULL];
                temp_3[17] = [NSNumber numberWithUnsignedLongLong:18ULL];
                temp_3[18] = [NSNumber numberWithUnsignedLongLong:19ULL];
                temp_3[19] = [NSNumber numberWithUnsignedLongLong:20ULL];
                ((MTRAccessControlClusterAccessControlEntry *) temp_0[1]).subjects = temp_3;
            }
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[1]).targets = nil;
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[1]).fabricIndex = [NSNumber numberWithUnsignedChar:0U];

            aclArgument = temp_0;
        }
        [cluster writeAttributeACLWithValue:aclArgument
                                 completion:^(NSError * _Nullable err) {
                                     NSLog(@"Write entry too many subjects Error: %@", err);

                                     VerifyOrReturn(CheckValue("status",
                                         err ? ([err.domain isEqualToString:MTRInteractionErrorDomain] ? err.code
                                                                                                       : EMBER_ZCL_STATUS_FAILURE)
                                             : 0,
                                         EMBER_ZCL_STATUS_FAILURE));
                                     NextTest();
                                 }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestVerify_14()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterAccessControl alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        __auto_type * params = [[MTRReadParams alloc] init];
        params.fabricFiltered = true;
        [cluster readAttributeACLWithParams:params
                                 completion:^(NSArray * _Nullable value, NSError * _Nullable err) {
                                     NSLog(@"Verify Error: %@", err);

                                     VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                                     {
                                         id actualValue = value;
                                         VerifyOrReturn(CheckValue("ACL", [actualValue count], static_cast<uint32_t>(1)));
                                         VerifyOrReturn(CheckValue("Privilege",
                                             ((MTRAccessControlClusterAccessControlEntry *) actualValue[0]).privilege, 5U));
                                         VerifyOrReturn(CheckValue("AuthMode",
                                             ((MTRAccessControlClusterAccessControlEntry *) actualValue[0]).authMode, 2U));
                                         VerifyOrReturn(CheckValueNull(
                                             "Subjects", ((MTRAccessControlClusterAccessControlEntry *) actualValue[0]).subjects));
                                         VerifyOrReturn(CheckValueNull(
                                             "Targets", ((MTRAccessControlClusterAccessControlEntry *) actualValue[0]).targets));
                                         VerifyOrReturn(CheckValue("FabricIndex",
                                             ((MTRAccessControlClusterAccessControlEntry *) actualValue[0]).fabricIndex, 1U));
                                     }

                                     NextTest();
                                 }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWriteEntryTooManyTargets_15()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterAccessControl alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        id aclArgument;
        {
            NSMutableArray * temp_0 = [[NSMutableArray alloc] init];
            temp_0[0] = [[MTRAccessControlClusterAccessControlEntry alloc] init];
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[0]).privilege = [NSNumber numberWithUnsignedChar:5U];
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[0]).authMode = [NSNumber numberWithUnsignedChar:2U];
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[0]).subjects = nil;
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[0]).targets = nil;
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[0]).fabricIndex = [NSNumber numberWithUnsignedChar:0U];

            temp_0[1] = [[MTRAccessControlClusterAccessControlEntry alloc] init];
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[1]).privilege = [NSNumber numberWithUnsignedChar:1U];
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[1]).authMode = [NSNumber numberWithUnsignedChar:2U];
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[1]).subjects = nil;
            {
                NSMutableArray * temp_3 = [[NSMutableArray alloc] init];
                temp_3[0] = [[MTRAccessControlClusterTarget alloc] init];
                ((MTRAccessControlClusterTarget *) temp_3[0]).cluster = nil;
                ((MTRAccessControlClusterTarget *) temp_3[0]).endpoint = [NSNumber numberWithUnsignedShort:1U];
                ((MTRAccessControlClusterTarget *) temp_3[0]).deviceType = nil;

                temp_3[1] = [[MTRAccessControlClusterTarget alloc] init];
                ((MTRAccessControlClusterTarget *) temp_3[1]).cluster = nil;
                ((MTRAccessControlClusterTarget *) temp_3[1]).endpoint = [NSNumber numberWithUnsignedShort:2U];
                ((MTRAccessControlClusterTarget *) temp_3[1]).deviceType = nil;

                temp_3[2] = [[MTRAccessControlClusterTarget alloc] init];
                ((MTRAccessControlClusterTarget *) temp_3[2]).cluster = nil;
                ((MTRAccessControlClusterTarget *) temp_3[2]).endpoint = [NSNumber numberWithUnsignedShort:3U];
                ((MTRAccessControlClusterTarget *) temp_3[2]).deviceType = nil;

                temp_3[3] = [[MTRAccessControlClusterTarget alloc] init];
                ((MTRAccessControlClusterTarget *) temp_3[3]).cluster = nil;
                ((MTRAccessControlClusterTarget *) temp_3[3]).endpoint = [NSNumber numberWithUnsignedShort:4U];
                ((MTRAccessControlClusterTarget *) temp_3[3]).deviceType = nil;

                temp_3[4] = [[MTRAccessControlClusterTarget alloc] init];
                ((MTRAccessControlClusterTarget *) temp_3[4]).cluster = nil;
                ((MTRAccessControlClusterTarget *) temp_3[4]).endpoint = [NSNumber numberWithUnsignedShort:5U];
                ((MTRAccessControlClusterTarget *) temp_3[4]).deviceType = nil;

                temp_3[5] = [[MTRAccessControlClusterTarget alloc] init];
                ((MTRAccessControlClusterTarget *) temp_3[5]).cluster = nil;
                ((MTRAccessControlClusterTarget *) temp_3[5]).endpoint = [NSNumber numberWithUnsignedShort:6U];
                ((MTRAccessControlClusterTarget *) temp_3[5]).deviceType = nil;

                temp_3[6] = [[MTRAccessControlClusterTarget alloc] init];
                ((MTRAccessControlClusterTarget *) temp_3[6]).cluster = nil;
                ((MTRAccessControlClusterTarget *) temp_3[6]).endpoint = [NSNumber numberWithUnsignedShort:7U];
                ((MTRAccessControlClusterTarget *) temp_3[6]).deviceType = nil;

                temp_3[7] = [[MTRAccessControlClusterTarget alloc] init];
                ((MTRAccessControlClusterTarget *) temp_3[7]).cluster = nil;
                ((MTRAccessControlClusterTarget *) temp_3[7]).endpoint = [NSNumber numberWithUnsignedShort:8U];
                ((MTRAccessControlClusterTarget *) temp_3[7]).deviceType = nil;

                temp_3[8] = [[MTRAccessControlClusterTarget alloc] init];
                ((MTRAccessControlClusterTarget *) temp_3[8]).cluster = nil;
                ((MTRAccessControlClusterTarget *) temp_3[8]).endpoint = [NSNumber numberWithUnsignedShort:9U];
                ((MTRAccessControlClusterTarget *) temp_3[8]).deviceType = nil;

                temp_3[9] = [[MTRAccessControlClusterTarget alloc] init];
                ((MTRAccessControlClusterTarget *) temp_3[9]).cluster = nil;
                ((MTRAccessControlClusterTarget *) temp_3[9]).endpoint = [NSNumber numberWithUnsignedShort:10U];
                ((MTRAccessControlClusterTarget *) temp_3[9]).deviceType = nil;

                temp_3[10] = [[MTRAccessControlClusterTarget alloc] init];
                ((MTRAccessControlClusterTarget *) temp_3[10]).cluster = nil;
                ((MTRAccessControlClusterTarget *) temp_3[10]).endpoint = [NSNumber numberWithUnsignedShort:11U];
                ((MTRAccessControlClusterTarget *) temp_3[10]).deviceType = nil;

                temp_3[11] = [[MTRAccessControlClusterTarget alloc] init];
                ((MTRAccessControlClusterTarget *) temp_3[11]).cluster = nil;
                ((MTRAccessControlClusterTarget *) temp_3[11]).endpoint = [NSNumber numberWithUnsignedShort:12U];
                ((MTRAccessControlClusterTarget *) temp_3[11]).deviceType = nil;

                temp_3[12] = [[MTRAccessControlClusterTarget alloc] init];
                ((MTRAccessControlClusterTarget *) temp_3[12]).cluster = nil;
                ((MTRAccessControlClusterTarget *) temp_3[12]).endpoint = [NSNumber numberWithUnsignedShort:13U];
                ((MTRAccessControlClusterTarget *) temp_3[12]).deviceType = nil;

                temp_3[13] = [[MTRAccessControlClusterTarget alloc] init];
                ((MTRAccessControlClusterTarget *) temp_3[13]).cluster = nil;
                ((MTRAccessControlClusterTarget *) temp_3[13]).endpoint = [NSNumber numberWithUnsignedShort:14U];
                ((MTRAccessControlClusterTarget *) temp_3[13]).deviceType = nil;

                temp_3[14] = [[MTRAccessControlClusterTarget alloc] init];
                ((MTRAccessControlClusterTarget *) temp_3[14]).cluster = nil;
                ((MTRAccessControlClusterTarget *) temp_3[14]).endpoint = [NSNumber numberWithUnsignedShort:15U];
                ((MTRAccessControlClusterTarget *) temp_3[14]).deviceType = nil;

                temp_3[15] = [[MTRAccessControlClusterTarget alloc] init];
                ((MTRAccessControlClusterTarget *) temp_3[15]).cluster = nil;
                ((MTRAccessControlClusterTarget *) temp_3[15]).endpoint = [NSNumber numberWithUnsignedShort:16U];
                ((MTRAccessControlClusterTarget *) temp_3[15]).deviceType = nil;

                temp_3[16] = [[MTRAccessControlClusterTarget alloc] init];
                ((MTRAccessControlClusterTarget *) temp_3[16]).cluster = nil;
                ((MTRAccessControlClusterTarget *) temp_3[16]).endpoint = [NSNumber numberWithUnsignedShort:17U];
                ((MTRAccessControlClusterTarget *) temp_3[16]).deviceType = nil;

                temp_3[17] = [[MTRAccessControlClusterTarget alloc] init];
                ((MTRAccessControlClusterTarget *) temp_3[17]).cluster = nil;
                ((MTRAccessControlClusterTarget *) temp_3[17]).endpoint = [NSNumber numberWithUnsignedShort:18U];
                ((MTRAccessControlClusterTarget *) temp_3[17]).deviceType = nil;

                temp_3[18] = [[MTRAccessControlClusterTarget alloc] init];
                ((MTRAccessControlClusterTarget *) temp_3[18]).cluster = nil;
                ((MTRAccessControlClusterTarget *) temp_3[18]).endpoint = [NSNumber numberWithUnsignedShort:19U];
                ((MTRAccessControlClusterTarget *) temp_3[18]).deviceType = nil;

                temp_3[19] = [[MTRAccessControlClusterTarget alloc] init];
                ((MTRAccessControlClusterTarget *) temp_3[19]).cluster = nil;
                ((MTRAccessControlClusterTarget *) temp_3[19]).endpoint = [NSNumber numberWithUnsignedShort:20U];
                ((MTRAccessControlClusterTarget *) temp_3[19]).deviceType = nil;

                ((MTRAccessControlClusterAccessControlEntry *) temp_0[1]).targets = temp_3;
            }
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[1]).fabricIndex = [NSNumber numberWithUnsignedChar:0U];

            aclArgument = temp_0;
        }
        [cluster writeAttributeACLWithValue:aclArgument
                                 completion:^(NSError * _Nullable err) {
                                     NSLog(@"Write entry too many targets Error: %@", err);

                                     VerifyOrReturn(CheckValue("status",
                                         err ? ([err.domain isEqualToString:MTRInteractionErrorDomain] ? err.code
                                                                                                       : EMBER_ZCL_STATUS_FAILURE)
                                             : 0,
                                         EMBER_ZCL_STATUS_FAILURE));
                                     NextTest();
                                 }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestVerify_16()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterAccessControl alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        __auto_type * params = [[MTRReadParams alloc] init];
        params.fabricFiltered = true;
        [cluster readAttributeACLWithParams:params
                                 completion:^(NSArray * _Nullable value, NSError * _Nullable err) {
                                     NSLog(@"Verify Error: %@", err);

                                     VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                                     {
                                         id actualValue = value;
                                         VerifyOrReturn(CheckValue("ACL", [actualValue count], static_cast<uint32_t>(1)));
                                         VerifyOrReturn(CheckValue("Privilege",
                                             ((MTRAccessControlClusterAccessControlEntry *) actualValue[0]).privilege, 5U));
                                         VerifyOrReturn(CheckValue("AuthMode",
                                             ((MTRAccessControlClusterAccessControlEntry *) actualValue[0]).authMode, 2U));
                                         VerifyOrReturn(CheckValueNull(
                                             "Subjects", ((MTRAccessControlClusterAccessControlEntry *) actualValue[0]).subjects));
                                         VerifyOrReturn(CheckValueNull(
                                             "Targets", ((MTRAccessControlClusterAccessControlEntry *) actualValue[0]).targets));
                                         VerifyOrReturn(CheckValue("FabricIndex",
                                             ((MTRAccessControlClusterAccessControlEntry *) actualValue[0]).fabricIndex, 1U));
                                     }

                                     NextTest();
                                 }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWriteTooManyEntries_17()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterAccessControl alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        id aclArgument;
        {
            NSMutableArray * temp_0 = [[NSMutableArray alloc] init];
            temp_0[0] = [[MTRAccessControlClusterAccessControlEntry alloc] init];
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[0]).privilege = [NSNumber numberWithUnsignedChar:5U];
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[0]).authMode = [NSNumber numberWithUnsignedChar:2U];
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[0]).subjects = nil;
            {
                NSMutableArray * temp_3 = [[NSMutableArray alloc] init];
                temp_3[0] = [[MTRAccessControlClusterTarget alloc] init];
                ((MTRAccessControlClusterTarget *) temp_3[0]).cluster = nil;
                ((MTRAccessControlClusterTarget *) temp_3[0]).endpoint = [NSNumber numberWithUnsignedShort:0U];
                ((MTRAccessControlClusterTarget *) temp_3[0]).deviceType = nil;

                temp_3[1] = [[MTRAccessControlClusterTarget alloc] init];
                ((MTRAccessControlClusterTarget *) temp_3[1]).cluster = [NSNumber numberWithUnsignedInt:1UL];
                ((MTRAccessControlClusterTarget *) temp_3[1]).endpoint = nil;
                ((MTRAccessControlClusterTarget *) temp_3[1]).deviceType = nil;

                temp_3[2] = [[MTRAccessControlClusterTarget alloc] init];
                ((MTRAccessControlClusterTarget *) temp_3[2]).cluster = [NSNumber numberWithUnsignedInt:2UL];
                ((MTRAccessControlClusterTarget *) temp_3[2]).endpoint = [NSNumber numberWithUnsignedShort:3U];
                ((MTRAccessControlClusterTarget *) temp_3[2]).deviceType = nil;

                ((MTRAccessControlClusterAccessControlEntry *) temp_0[0]).targets = temp_3;
            }
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[0]).fabricIndex = [NSNumber numberWithUnsignedChar:0U];

            temp_0[1] = [[MTRAccessControlClusterAccessControlEntry alloc] init];
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[1]).privilege = [NSNumber numberWithUnsignedChar:1U];
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[1]).authMode = [NSNumber numberWithUnsignedChar:2U];
            {
                NSMutableArray * temp_3 = [[NSMutableArray alloc] init];
                temp_3[0] = [NSNumber numberWithUnsignedLongLong:4ULL];
                temp_3[1] = [NSNumber numberWithUnsignedLongLong:5ULL];
                temp_3[2] = [NSNumber numberWithUnsignedLongLong:6ULL];
                temp_3[3] = [NSNumber numberWithUnsignedLongLong:7ULL];
                ((MTRAccessControlClusterAccessControlEntry *) temp_0[1]).subjects = temp_3;
            }
            {
                NSMutableArray * temp_3 = [[NSMutableArray alloc] init];
                temp_3[0] = [[MTRAccessControlClusterTarget alloc] init];
                ((MTRAccessControlClusterTarget *) temp_3[0]).cluster = nil;
                ((MTRAccessControlClusterTarget *) temp_3[0]).endpoint = [NSNumber numberWithUnsignedShort:8U];
                ((MTRAccessControlClusterTarget *) temp_3[0]).deviceType = nil;

                temp_3[1] = [[MTRAccessControlClusterTarget alloc] init];
                ((MTRAccessControlClusterTarget *) temp_3[1]).cluster = [NSNumber numberWithUnsignedInt:9UL];
                ((MTRAccessControlClusterTarget *) temp_3[1]).endpoint = nil;
                ((MTRAccessControlClusterTarget *) temp_3[1]).deviceType = nil;

                temp_3[2] = [[MTRAccessControlClusterTarget alloc] init];
                ((MTRAccessControlClusterTarget *) temp_3[2]).cluster = [NSNumber numberWithUnsignedInt:10UL];
                ((MTRAccessControlClusterTarget *) temp_3[2]).endpoint = [NSNumber numberWithUnsignedShort:11U];
                ((MTRAccessControlClusterTarget *) temp_3[2]).deviceType = nil;

                ((MTRAccessControlClusterAccessControlEntry *) temp_0[1]).targets = temp_3;
            }
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[1]).fabricIndex = [NSNumber numberWithUnsignedChar:0U];

            temp_0[2] = [[MTRAccessControlClusterAccessControlEntry alloc] init];
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[2]).privilege = [NSNumber numberWithUnsignedChar:3U];
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[2]).authMode = [NSNumber numberWithUnsignedChar:3U];
            {
                NSMutableArray * temp_3 = [[NSMutableArray alloc] init];
                temp_3[0] = [NSNumber numberWithUnsignedLongLong:12ULL];
                temp_3[1] = [NSNumber numberWithUnsignedLongLong:13ULL];
                temp_3[2] = [NSNumber numberWithUnsignedLongLong:14ULL];
                temp_3[3] = [NSNumber numberWithUnsignedLongLong:15ULL];
                ((MTRAccessControlClusterAccessControlEntry *) temp_0[2]).subjects = temp_3;
            }
            {
                NSMutableArray * temp_3 = [[NSMutableArray alloc] init];
                temp_3[0] = [[MTRAccessControlClusterTarget alloc] init];
                ((MTRAccessControlClusterTarget *) temp_3[0]).cluster = nil;
                ((MTRAccessControlClusterTarget *) temp_3[0]).endpoint = [NSNumber numberWithUnsignedShort:16U];
                ((MTRAccessControlClusterTarget *) temp_3[0]).deviceType = nil;

                temp_3[1] = [[MTRAccessControlClusterTarget alloc] init];
                ((MTRAccessControlClusterTarget *) temp_3[1]).cluster = [NSNumber numberWithUnsignedInt:17UL];
                ((MTRAccessControlClusterTarget *) temp_3[1]).endpoint = nil;
                ((MTRAccessControlClusterTarget *) temp_3[1]).deviceType = nil;

                temp_3[2] = [[MTRAccessControlClusterTarget alloc] init];
                ((MTRAccessControlClusterTarget *) temp_3[2]).cluster = [NSNumber numberWithUnsignedInt:18UL];
                ((MTRAccessControlClusterTarget *) temp_3[2]).endpoint = [NSNumber numberWithUnsignedShort:19U];
                ((MTRAccessControlClusterTarget *) temp_3[2]).deviceType = nil;

                ((MTRAccessControlClusterAccessControlEntry *) temp_0[2]).targets = temp_3;
            }
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[2]).fabricIndex = [NSNumber numberWithUnsignedChar:0U];

            temp_0[3] = [[MTRAccessControlClusterAccessControlEntry alloc] init];
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[3]).privilege = [NSNumber numberWithUnsignedChar:1U];
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[3]).authMode = [NSNumber numberWithUnsignedChar:2U];
            {
                NSMutableArray * temp_3 = [[NSMutableArray alloc] init];
                temp_3[0] = [NSNumber numberWithUnsignedLongLong:20ULL];
                temp_3[1] = [NSNumber numberWithUnsignedLongLong:21ULL];
                temp_3[2] = [NSNumber numberWithUnsignedLongLong:22ULL];
                temp_3[3] = [NSNumber numberWithUnsignedLongLong:23ULL];
                ((MTRAccessControlClusterAccessControlEntry *) temp_0[3]).subjects = temp_3;
            }
            {
                NSMutableArray * temp_3 = [[NSMutableArray alloc] init];
                temp_3[0] = [[MTRAccessControlClusterTarget alloc] init];
                ((MTRAccessControlClusterTarget *) temp_3[0]).cluster = nil;
                ((MTRAccessControlClusterTarget *) temp_3[0]).endpoint = [NSNumber numberWithUnsignedShort:24U];
                ((MTRAccessControlClusterTarget *) temp_3[0]).deviceType = nil;

                temp_3[1] = [[MTRAccessControlClusterTarget alloc] init];
                ((MTRAccessControlClusterTarget *) temp_3[1]).cluster = [NSNumber numberWithUnsignedInt:25UL];
                ((MTRAccessControlClusterTarget *) temp_3[1]).endpoint = nil;
                ((MTRAccessControlClusterTarget *) temp_3[1]).deviceType = nil;

                temp_3[2] = [[MTRAccessControlClusterTarget alloc] init];
                ((MTRAccessControlClusterTarget *) temp_3[2]).cluster = [NSNumber numberWithUnsignedInt:26UL];
                ((MTRAccessControlClusterTarget *) temp_3[2]).endpoint = [NSNumber numberWithUnsignedShort:27U];
                ((MTRAccessControlClusterTarget *) temp_3[2]).deviceType = nil;

                ((MTRAccessControlClusterAccessControlEntry *) temp_0[3]).targets = temp_3;
            }
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[3]).fabricIndex = [NSNumber numberWithUnsignedChar:0U];

            aclArgument = temp_0;
        }
        [cluster writeAttributeACLWithValue:aclArgument
                                 completion:^(NSError * _Nullable err) {
                                     NSLog(@"Write too many entries Error: %@", err);

                                     VerifyOrReturn(CheckValue("status",
                                         err ? ([err.domain isEqualToString:MTRInteractionErrorDomain] ? err.code
                                                                                                       : EMBER_ZCL_STATUS_FAILURE)
                                             : 0,
                                         EMBER_ZCL_STATUS_RESOURCE_EXHAUSTED));
                                     NextTest();
                                 }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestVerify_18()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterAccessControl alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        __auto_type * params = [[MTRReadParams alloc] init];
        params.fabricFiltered = true;
        [cluster readAttributeACLWithParams:params
                                 completion:^(NSArray * _Nullable value, NSError * _Nullable err) {
                                     NSLog(@"Verify Error: %@", err);

                                     VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                                     {
                                         id actualValue = value;
                                         VerifyOrReturn(CheckValue("ACL", [actualValue count], static_cast<uint32_t>(3)));
                                         VerifyOrReturn(CheckValue("Privilege",
                                             ((MTRAccessControlClusterAccessControlEntry *) actualValue[0]).privilege, 5U));
                                         VerifyOrReturn(CheckValue("AuthMode",
                                             ((MTRAccessControlClusterAccessControlEntry *) actualValue[0]).authMode, 2U));
                                         VerifyOrReturn(CheckValueNull(
                                             "Subjects", ((MTRAccessControlClusterAccessControlEntry *) actualValue[0]).subjects));
                                         VerifyOrReturn(CheckValueNonNull(
                                             "Targets", ((MTRAccessControlClusterAccessControlEntry *) actualValue[0]).targets));
                                         VerifyOrReturn(CheckValue("Targets",
                                             [((MTRAccessControlClusterAccessControlEntry *) actualValue[0]).targets count],
                                             static_cast<uint32_t>(3)));
                                         VerifyOrReturn(CheckValueNull("Cluster",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[0])
                                                     .targets[0])
                                                 .cluster));
                                         VerifyOrReturn(CheckValueNonNull("Endpoint",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[0])
                                                     .targets[0])
                                                 .endpoint));
                                         VerifyOrReturn(CheckValue("Endpoint",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[0])
                                                     .targets[0])
                                                 .endpoint,
                                             0U));
                                         VerifyOrReturn(CheckValueNull("DeviceType",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[0])
                                                     .targets[0])
                                                 .deviceType));
                                         VerifyOrReturn(CheckValueNonNull("Cluster",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[0])
                                                     .targets[1])
                                                 .cluster));
                                         VerifyOrReturn(CheckValue("Cluster",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[0])
                                                     .targets[1])
                                                 .cluster,
                                             1UL));
                                         VerifyOrReturn(CheckValueNull("Endpoint",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[0])
                                                     .targets[1])
                                                 .endpoint));
                                         VerifyOrReturn(CheckValueNull("DeviceType",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[0])
                                                     .targets[1])
                                                 .deviceType));
                                         VerifyOrReturn(CheckValueNonNull("Cluster",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[0])
                                                     .targets[2])
                                                 .cluster));
                                         VerifyOrReturn(CheckValue("Cluster",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[0])
                                                     .targets[2])
                                                 .cluster,
                                             2UL));
                                         VerifyOrReturn(CheckValueNonNull("Endpoint",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[0])
                                                     .targets[2])
                                                 .endpoint));
                                         VerifyOrReturn(CheckValue("Endpoint",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[0])
                                                     .targets[2])
                                                 .endpoint,
                                             3U));
                                         VerifyOrReturn(CheckValueNull("DeviceType",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[0])
                                                     .targets[2])
                                                 .deviceType));
                                         VerifyOrReturn(CheckValue("FabricIndex",
                                             ((MTRAccessControlClusterAccessControlEntry *) actualValue[0]).fabricIndex, 1U));
                                         VerifyOrReturn(CheckValue("Privilege",
                                             ((MTRAccessControlClusterAccessControlEntry *) actualValue[1]).privilege, 1U));
                                         VerifyOrReturn(CheckValue("AuthMode",
                                             ((MTRAccessControlClusterAccessControlEntry *) actualValue[1]).authMode, 2U));
                                         VerifyOrReturn(CheckValueNonNull(
                                             "Subjects", ((MTRAccessControlClusterAccessControlEntry *) actualValue[1]).subjects));
                                         VerifyOrReturn(CheckValue("Subjects",
                                             [((MTRAccessControlClusterAccessControlEntry *) actualValue[1]).subjects count],
                                             static_cast<uint32_t>(4)));
                                         VerifyOrReturn(CheckValue(
                                             "", ((MTRAccessControlClusterAccessControlEntry *) actualValue[1]).subjects[0], 4ULL));
                                         VerifyOrReturn(CheckValue(
                                             "", ((MTRAccessControlClusterAccessControlEntry *) actualValue[1]).subjects[1], 5ULL));
                                         VerifyOrReturn(CheckValue(
                                             "", ((MTRAccessControlClusterAccessControlEntry *) actualValue[1]).subjects[2], 6ULL));
                                         VerifyOrReturn(CheckValue(
                                             "", ((MTRAccessControlClusterAccessControlEntry *) actualValue[1]).subjects[3], 7ULL));
                                         VerifyOrReturn(CheckValueNonNull(
                                             "Targets", ((MTRAccessControlClusterAccessControlEntry *) actualValue[1]).targets));
                                         VerifyOrReturn(CheckValue("Targets",
                                             [((MTRAccessControlClusterAccessControlEntry *) actualValue[1]).targets count],
                                             static_cast<uint32_t>(3)));
                                         VerifyOrReturn(CheckValueNull("Cluster",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[1])
                                                     .targets[0])
                                                 .cluster));
                                         VerifyOrReturn(CheckValueNonNull("Endpoint",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[1])
                                                     .targets[0])
                                                 .endpoint));
                                         VerifyOrReturn(CheckValue("Endpoint",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[1])
                                                     .targets[0])
                                                 .endpoint,
                                             8U));
                                         VerifyOrReturn(CheckValueNull("DeviceType",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[1])
                                                     .targets[0])
                                                 .deviceType));
                                         VerifyOrReturn(CheckValueNonNull("Cluster",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[1])
                                                     .targets[1])
                                                 .cluster));
                                         VerifyOrReturn(CheckValue("Cluster",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[1])
                                                     .targets[1])
                                                 .cluster,
                                             9UL));
                                         VerifyOrReturn(CheckValueNull("Endpoint",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[1])
                                                     .targets[1])
                                                 .endpoint));
                                         VerifyOrReturn(CheckValueNull("DeviceType",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[1])
                                                     .targets[1])
                                                 .deviceType));
                                         VerifyOrReturn(CheckValueNonNull("Cluster",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[1])
                                                     .targets[2])
                                                 .cluster));
                                         VerifyOrReturn(CheckValue("Cluster",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[1])
                                                     .targets[2])
                                                 .cluster,
                                             10UL));
                                         VerifyOrReturn(CheckValueNonNull("Endpoint",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[1])
                                                     .targets[2])
                                                 .endpoint));
                                         VerifyOrReturn(CheckValue("Endpoint",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[1])
                                                     .targets[2])
                                                 .endpoint,
                                             11U));
                                         VerifyOrReturn(CheckValueNull("DeviceType",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[1])
                                                     .targets[2])
                                                 .deviceType));
                                         VerifyOrReturn(CheckValue("FabricIndex",
                                             ((MTRAccessControlClusterAccessControlEntry *) actualValue[1]).fabricIndex, 1U));
                                         VerifyOrReturn(CheckValue("Privilege",
                                             ((MTRAccessControlClusterAccessControlEntry *) actualValue[2]).privilege, 3U));
                                         VerifyOrReturn(CheckValue("AuthMode",
                                             ((MTRAccessControlClusterAccessControlEntry *) actualValue[2]).authMode, 3U));
                                         VerifyOrReturn(CheckValueNonNull(
                                             "Subjects", ((MTRAccessControlClusterAccessControlEntry *) actualValue[2]).subjects));
                                         VerifyOrReturn(CheckValue("Subjects",
                                             [((MTRAccessControlClusterAccessControlEntry *) actualValue[2]).subjects count],
                                             static_cast<uint32_t>(4)));
                                         VerifyOrReturn(CheckValue("",
                                             ((MTRAccessControlClusterAccessControlEntry *) actualValue[2]).subjects[0], 12ULL));
                                         VerifyOrReturn(CheckValue("",
                                             ((MTRAccessControlClusterAccessControlEntry *) actualValue[2]).subjects[1], 13ULL));
                                         VerifyOrReturn(CheckValue("",
                                             ((MTRAccessControlClusterAccessControlEntry *) actualValue[2]).subjects[2], 14ULL));
                                         VerifyOrReturn(CheckValue("",
                                             ((MTRAccessControlClusterAccessControlEntry *) actualValue[2]).subjects[3], 15ULL));
                                         VerifyOrReturn(CheckValueNonNull(
                                             "Targets", ((MTRAccessControlClusterAccessControlEntry *) actualValue[2]).targets));
                                         VerifyOrReturn(CheckValue("Targets",
                                             [((MTRAccessControlClusterAccessControlEntry *) actualValue[2]).targets count],
                                             static_cast<uint32_t>(3)));
                                         VerifyOrReturn(CheckValueNull("Cluster",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[2])
                                                     .targets[0])
                                                 .cluster));
                                         VerifyOrReturn(CheckValueNonNull("Endpoint",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[2])
                                                     .targets[0])
                                                 .endpoint));
                                         VerifyOrReturn(CheckValue("Endpoint",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[2])
                                                     .targets[0])
                                                 .endpoint,
                                             16U));
                                         VerifyOrReturn(CheckValueNull("DeviceType",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[2])
                                                     .targets[0])
                                                 .deviceType));
                                         VerifyOrReturn(CheckValueNonNull("Cluster",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[2])
                                                     .targets[1])
                                                 .cluster));
                                         VerifyOrReturn(CheckValue("Cluster",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[2])
                                                     .targets[1])
                                                 .cluster,
                                             17UL));
                                         VerifyOrReturn(CheckValueNull("Endpoint",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[2])
                                                     .targets[1])
                                                 .endpoint));
                                         VerifyOrReturn(CheckValueNull("DeviceType",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[2])
                                                     .targets[1])
                                                 .deviceType));
                                         VerifyOrReturn(CheckValueNonNull("Cluster",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[2])
                                                     .targets[2])
                                                 .cluster));
                                         VerifyOrReturn(CheckValue("Cluster",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[2])
                                                     .targets[2])
                                                 .cluster,
                                             18UL));
                                         VerifyOrReturn(CheckValueNonNull("Endpoint",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[2])
                                                     .targets[2])
                                                 .endpoint));
                                         VerifyOrReturn(CheckValue("Endpoint",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[2])
                                                     .targets[2])
                                                 .endpoint,
                                             19U));
                                         VerifyOrReturn(CheckValueNull("DeviceType",
                                             ((MTRAccessControlClusterTarget *) ((MTRAccessControlClusterAccessControlEntry *)
                                                                                     actualValue[2])
                                                     .targets[2])
                                                 .deviceType));
                                         VerifyOrReturn(CheckValue("FabricIndex",
                                             ((MTRAccessControlClusterAccessControlEntry *) actualValue[2]).fabricIndex, 1U));
                                     }

                                     NextTest();
                                 }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestRestoreAcl_19()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterAccessControl alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        id aclArgument;
        {
            NSMutableArray * temp_0 = [[NSMutableArray alloc] init];
            temp_0[0] = [[MTRAccessControlClusterAccessControlEntry alloc] init];
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[0]).privilege = [NSNumber numberWithUnsignedChar:5U];
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[0]).authMode = [NSNumber numberWithUnsignedChar:2U];
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[0]).subjects = nil;
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[0]).targets = nil;
            ((MTRAccessControlClusterAccessControlEntry *) temp_0[0]).fabricIndex = [NSNumber numberWithUnsignedChar:0U];

            aclArgument = temp_0;
        }
        [cluster writeAttributeACLWithValue:aclArgument
                                 completion:^(NSError * _Nullable err) {
                                     NSLog(@"Restore ACL Error: %@", err);

                                     VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                                     NextTest();
                                 }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestVerify_20()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterAccessControl alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        __auto_type * params = [[MTRReadParams alloc] init];
        params.fabricFiltered = true;
        [cluster readAttributeACLWithParams:params
                                 completion:^(NSArray * _Nullable value, NSError * _Nullable err) {
                                     NSLog(@"Verify Error: %@", err);

                                     VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                                     {
                                         id actualValue = value;
                                         VerifyOrReturn(CheckValue("ACL", [actualValue count], static_cast<uint32_t>(1)));
                                         VerifyOrReturn(CheckValue("Privilege",
                                             ((MTRAccessControlClusterAccessControlEntry *) actualValue[0]).privilege, 5U));
                                         VerifyOrReturn(CheckValue("AuthMode",
                                             ((MTRAccessControlClusterAccessControlEntry *) actualValue[0]).authMode, 2U));
                                         VerifyOrReturn(CheckValueNull(
                                             "Subjects", ((MTRAccessControlClusterAccessControlEntry *) actualValue[0]).subjects));
                                         VerifyOrReturn(CheckValueNull(
                                             "Targets", ((MTRAccessControlClusterAccessControlEntry *) actualValue[0]).targets));
                                         VerifyOrReturn(CheckValue("FabricIndex",
                                             ((MTRAccessControlClusterAccessControlEntry *) actualValue[0]).fabricIndex, 1U));
                                     }

                                     NextTest();
                                 }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestValidateResourceMinimaSubjectsPerAccessControlEntry_21()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterAccessControl alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeSubjectsPerAccessControlEntryWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Validate resource minima (SubjectsPerAccessControlEntry) Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("subjectsPerAccessControlEntry", [value unsignedShortValue], 4U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestValidateResourceMinimaTargetsPerAccessControlEntry_22()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterAccessControl alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeTargetsPerAccessControlEntryWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Validate resource minima (TargetsPerAccessControlEntry) Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("targetsPerAccessControlEntry", [value unsignedShortValue], 3U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestValidateResourceMinimaAccessControlEntriesPerFabric_23()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterAccessControl alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAccessControlEntriesPerFabricWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Validate resource minima (AccessControlEntriesPerFabric) Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("accessControlEntriesPerFabric", [value unsignedShortValue], 3U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }
};

class Test_TC_ACL_1_1 : public TestCommandBridge {
public:
    // NOLINTBEGIN(clang-analyzer-nullability.NullPassedToNonnull): Test constructor nullability not enforced
    Test_TC_ACL_1_1()
        : TestCommandBridge("Test_TC_ACL_1_1")
        , mTestIndex(0)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }
    // NOLINTEND(clang-analyzer-nullability.NullPassedToNonnull)

    ~Test_TC_ACL_1_1() {}

    /////////// TestCommand Interface /////////
    void NextTest() override
    {
        CHIP_ERROR err = CHIP_NO_ERROR;

        if (0 == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Start: Test_TC_ACL_1_1\n");
        }

        if (mTestCount == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Complete: Test_TC_ACL_1_1\n");
            SetCommandExitStatus(CHIP_NO_ERROR);
            return;
        }

        Wait();

        // Ensure we increment mTestIndex before we start running the relevant
        // command.  That way if we lose the timeslice after we send the message
        // but before our function call returns, we won't end up with an
        // incorrect mTestIndex value observed when we get the response.
        switch (mTestIndex++) {
        case 0:
            ChipLogProgress(chipTool, " ***** Test Step 0 : Wait for the commissioned device to be retrieved\n");
            err = TestWaitForTheCommissionedDeviceToBeRetrieved_0();
            break;
        case 1:
            ChipLogProgress(chipTool, " ***** Test Step 1 : TH reads ClusterRevision attribute from DUT\n");
            err = TestThReadsClusterRevisionAttributeFromDut_1();
            break;
        case 2:
            ChipLogProgress(chipTool, " ***** Test Step 2 : TH reads FeatureMap attribute from DUT\n");
            err = TestThReadsFeatureMapAttributeFromDut_2();
            break;
        case 3:
            ChipLogProgress(chipTool, " ***** Test Step 3 : TH reads AttributeList attribute from DUT\n");
            err = TestThReadsAttributeListAttributeFromDut_3();
            break;
        case 4:
            ChipLogProgress(chipTool, " ***** Test Step 4 : TH reads optional attribute (Extension) in AttributeList\n");
            if (ShouldSkip("ACL.S.A0001")) {
                NextTest();
                return;
            }
            err = TestThReadsOptionalAttributeExtensionInAttributeList_4();
            break;
        case 5:
            ChipLogProgress(chipTool, " ***** Test Step 5 : TH reads AcceptedCommandList attribute from DUT\n");
            err = TestThReadsAcceptedCommandListAttributeFromDut_5();
            break;
        case 6:
            ChipLogProgress(chipTool, " ***** Test Step 6 : TH reads GeneratedCommandList attribute from DUT\n");
            err = TestThReadsGeneratedCommandListAttributeFromDut_6();
            break;
        }

        if (CHIP_NO_ERROR != err) {
            ChipLogError(chipTool, " ***** Test Failure: %s\n", chip::ErrorStr(err));
            SetCommandExitStatus(err);
        }
    }

    void OnStatusUpdate(const chip::app::StatusIB & status) override
    {
        switch (mTestIndex - 1) {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 6:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        }

        // Go on to the next test.
        ContinueOnChipMainThread(CHIP_NO_ERROR);
    }

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    std::atomic_uint16_t mTestIndex;
    const uint16_t mTestCount = 7;

    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    CHIP_ERROR TestWaitForTheCommissionedDeviceToBeRetrieved_0()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
        value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
        return WaitForCommissionee("alpha", value);
    }

    CHIP_ERROR TestThReadsClusterRevisionAttributeFromDut_1()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterAccessControl alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeClusterRevisionWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads ClusterRevision attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("ClusterRevision", actualValue, 1U));
            }

            VerifyOrReturn(CheckConstraintType("clusterRevision", "int16u", "int16u"));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsFeatureMapAttributeFromDut_2()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterAccessControl alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeFeatureMapWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads FeatureMap attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("FeatureMap", actualValue, 0UL));
            }

            VerifyOrReturn(CheckConstraintType("featureMap", "bitmap32", "bitmap32"));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsAttributeListAttributeFromDut_3()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterAccessControl alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAttributeListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads AttributeList attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("attributeList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 0UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 2UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 3UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 4UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65528UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65529UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65531UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65532UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65533UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsOptionalAttributeExtensionInAttributeList_4()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterAccessControl alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAttributeListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads optional attribute (Extension) in AttributeList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("attributeList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 1UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsAcceptedCommandListAttributeFromDut_5()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterAccessControl alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAcceptedCommandListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads AcceptedCommandList attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("AcceptedCommandList", [actualValue count], static_cast<uint32_t>(0)));
            }

            VerifyOrReturn(CheckConstraintType("acceptedCommandList", "list", "list"));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsGeneratedCommandListAttributeFromDut_6()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterAccessControl alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeGeneratedCommandListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads GeneratedCommandList attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("GeneratedCommandList", [actualValue count], static_cast<uint32_t>(0)));
            }

            VerifyOrReturn(CheckConstraintType("generatedCommandList", "list", "list"));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }
};

class Test_TC_ACL_2_1 : public TestCommandBridge {
public:
    // NOLINTBEGIN(clang-analyzer-nullability.NullPassedToNonnull): Test constructor nullability not enforced
    Test_TC_ACL_2_1()
        : TestCommandBridge("Test_TC_ACL_2_1")
        , mTestIndex(0)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }
    // NOLINTEND(clang-analyzer-nullability.NullPassedToNonnull)

    ~Test_TC_ACL_2_1() {}

    /////////// TestCommand Interface /////////
    void NextTest() override
    {
        CHIP_ERROR err = CHIP_NO_ERROR;

        if (0 == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Start: Test_TC_ACL_2_1\n");
        }

        if (mTestCount == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Complete: Test_TC_ACL_2_1\n");
            SetCommandExitStatus(CHIP_NO_ERROR);
            return;
        }

        Wait();

        // Ensure we increment mTestIndex before we start running the relevant
        // command.  That way if we lose the timeslice after we send the message
        // but before our function call returns, we won't end up with an
        // incorrect mTestIndex value observed when we get the response.
        switch (mTestIndex++) {
        case 0:
            ChipLogProgress(chipTool, " ***** Test Step 0 : Wait for the commissioned device to be retrieved\n");
            err = TestWaitForTheCommissionedDeviceToBeRetrieved_0();
            break;
        case 1:
            ChipLogProgress(chipTool, " ***** Test Step 1 : TH reads SubjectsPerAccessControlEntry attribute from DUT\n");
            if (ShouldSkip("ACL.S.A0002")) {
                NextTest();
                return;
            }
            err = TestThReadsSubjectsPerAccessControlEntryAttributeFromDut_1();
            break;
        case 2:
            ChipLogProgress(chipTool, " ***** Test Step 2 : TH reads TargetsPerAccessControlEntry attribute from DUT\n");
            if (ShouldSkip("ACL.S.A0003")) {
                NextTest();
                return;
            }
            err = TestThReadsTargetsPerAccessControlEntryAttributeFromDut_2();
            break;
        case 3:
            ChipLogProgress(chipTool, " ***** Test Step 3 : TH reads AccessControlEntriesPerFabric attribute from DUT\n");
            if (ShouldSkip("ACL.S.A0002")) {
                NextTest();
                return;
            }
            err = TestThReadsAccessControlEntriesPerFabricAttributeFromDut_3();
            break;
        }

        if (CHIP_NO_ERROR != err) {
            ChipLogError(chipTool, " ***** Test Failure: %s\n", chip::ErrorStr(err));
            SetCommandExitStatus(err);
        }
    }

    void OnStatusUpdate(const chip::app::StatusIB & status) override
    {
        switch (mTestIndex - 1) {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        }

        // Go on to the next test.
        ContinueOnChipMainThread(CHIP_NO_ERROR);
    }

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    std::atomic_uint16_t mTestIndex;
    const uint16_t mTestCount = 4;

    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    CHIP_ERROR TestWaitForTheCommissionedDeviceToBeRetrieved_0()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
        value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
        return WaitForCommissionee("alpha", value);
    }

    CHIP_ERROR TestThReadsSubjectsPerAccessControlEntryAttributeFromDut_1()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterAccessControl alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeSubjectsPerAccessControlEntryWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads SubjectsPerAccessControlEntry attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("subjectsPerAccessControlEntry", "int16u", "int16u"));
            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("subjectsPerAccessControlEntry", [value unsignedShortValue], 4U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("subjectsPerAccessControlEntry", [value unsignedShortValue], 65535U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsTargetsPerAccessControlEntryAttributeFromDut_2()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterAccessControl alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeTargetsPerAccessControlEntryWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads TargetsPerAccessControlEntry attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("targetsPerAccessControlEntry", "int16u", "int16u"));
            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("targetsPerAccessControlEntry", [value unsignedShortValue], 3U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("targetsPerAccessControlEntry", [value unsignedShortValue], 65535U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsAccessControlEntriesPerFabricAttributeFromDut_3()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterAccessControl alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAccessControlEntriesPerFabricWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads AccessControlEntriesPerFabric attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("accessControlEntriesPerFabric", "int16u", "int16u"));
            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("accessControlEntriesPerFabric", [value unsignedShortValue], 3U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("accessControlEntriesPerFabric", [value unsignedShortValue], 65535U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }
};

class Test_TC_ACL_2_2 : public TestCommandBridge {
public:
    // NOLINTBEGIN(clang-analyzer-nullability.NullPassedToNonnull): Test constructor nullability not enforced
    Test_TC_ACL_2_2()
        : TestCommandBridge("Test_TC_ACL_2_2")
        , mTestIndex(0)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }
    // NOLINTEND(clang-analyzer-nullability.NullPassedToNonnull)

    ~Test_TC_ACL_2_2() {}

    /////////// TestCommand Interface /////////
    void NextTest() override
    {
        CHIP_ERROR err = CHIP_NO_ERROR;

        if (0 == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Start: Test_TC_ACL_2_2\n");
        }

        if (mTestCount == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Complete: Test_TC_ACL_2_2\n");
            SetCommandExitStatus(CHIP_NO_ERROR);
            return;
        }

        Wait();

        // Ensure we increment mTestIndex before we start running the relevant
        // command.  That way if we lose the timeslice after we send the message
        // but before our function call returns, we won't end up with an
        // incorrect mTestIndex value observed when we get the response.
        switch (mTestIndex++) {
        case 0:
            ChipLogProgress(chipTool, " ***** Test Step 0 : Wait for the commissioned device to be retrieved\n");
            err = TestWaitForTheCommissionedDeviceToBeRetrieved_0();
            break;
        case 1:
            ChipLogProgress(
                chipTool, " ***** Test Step 1 : TH1 reads DUT Descriptor cluster ServerList attribute from Endpoint 0\n");
            err = TestTh1ReadsDutDescriptorClusterServerListAttributeFromEndpoint0_1();
            break;
        case 2:
            ChipLogProgress(chipTool,
                " ***** Test Step 2 : TH1 reads DUT Descriptor cluster ServerList attribute from every Endpoint except 0\n");
            if (ShouldSkip("PICS_USER_PROMPT")) {
                NextTest();
                return;
            }
            err = TestTh1ReadsDutDescriptorClusterServerListAttributeFromEveryEndpointExcept0_2();
            break;
        }

        if (CHIP_NO_ERROR != err) {
            ChipLogError(chipTool, " ***** Test Failure: %s\n", chip::ErrorStr(err));
            SetCommandExitStatus(err);
        }
    }

    void OnStatusUpdate(const chip::app::StatusIB & status) override
    {
        switch (mTestIndex - 1) {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        }

        // Go on to the next test.
        ContinueOnChipMainThread(CHIP_NO_ERROR);
    }

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    std::atomic_uint16_t mTestIndex;
    const uint16_t mTestCount = 3;

    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    CHIP_ERROR TestWaitForTheCommissionedDeviceToBeRetrieved_0()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
        value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
        return WaitForCommissionee("alpha", value);
    }

    CHIP_ERROR TestTh1ReadsDutDescriptorClusterServerListAttributeFromEndpoint0_1()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterDescriptor alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeServerListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH1 reads DUT Descriptor cluster ServerList attribute from Endpoint 0 Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("serverList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("serverList", value, 31UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestTh1ReadsDutDescriptorClusterServerListAttributeFromEveryEndpointExcept0_2()
    {

        chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
        value.message
            = chip::Span<const char>("Factory Reset the DUT and enter 'y' after successgarbage: not in length on purpose", 49);
        value.expectedValue.Emplace();
        value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
        return UserPrompt("alpha", value);
    }
};

class Test_TC_BOOL_1_1 : public TestCommandBridge {
public:
    // NOLINTBEGIN(clang-analyzer-nullability.NullPassedToNonnull): Test constructor nullability not enforced
    Test_TC_BOOL_1_1()
        : TestCommandBridge("Test_TC_BOOL_1_1")
        , mTestIndex(0)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }
    // NOLINTEND(clang-analyzer-nullability.NullPassedToNonnull)

    ~Test_TC_BOOL_1_1() {}

    /////////// TestCommand Interface /////////
    void NextTest() override
    {
        CHIP_ERROR err = CHIP_NO_ERROR;

        if (0 == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Start: Test_TC_BOOL_1_1\n");
        }

        if (mTestCount == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Complete: Test_TC_BOOL_1_1\n");
            SetCommandExitStatus(CHIP_NO_ERROR);
            return;
        }

        Wait();

        // Ensure we increment mTestIndex before we start running the relevant
        // command.  That way if we lose the timeslice after we send the message
        // but before our function call returns, we won't end up with an
        // incorrect mTestIndex value observed when we get the response.
        switch (mTestIndex++) {
        case 0:
            ChipLogProgress(chipTool, " ***** Test Step 0 : Wait for the commissioned device to be retrieved\n");
            err = TestWaitForTheCommissionedDeviceToBeRetrieved_0();
            break;
        case 1:
            ChipLogProgress(chipTool, " ***** Test Step 1 : read the global attribute: ClusterRevision\n");
            err = TestReadTheGlobalAttributeClusterRevision_1();
            break;
        case 2:
            ChipLogProgress(chipTool, " ***** Test Step 2 : Read the global attribute: FeatureMap\n");
            err = TestReadTheGlobalAttributeFeatureMap_2();
            break;
        case 3:
            ChipLogProgress(chipTool, " ***** Test Step 3 : Read the global attribute: AttributeList\n");
            err = TestReadTheGlobalAttributeAttributeList_3();
            break;
        case 4:
            ChipLogProgress(chipTool, " ***** Test Step 4 : Read the global attribute: AcceptedCommandList\n");
            err = TestReadTheGlobalAttributeAcceptedCommandList_4();
            break;
        case 5:
            ChipLogProgress(chipTool, " ***** Test Step 5 : Read the global attribute: GeneratedCommandList\n");
            err = TestReadTheGlobalAttributeGeneratedCommandList_5();
            break;
        }

        if (CHIP_NO_ERROR != err) {
            ChipLogError(chipTool, " ***** Test Failure: %s\n", chip::ErrorStr(err));
            SetCommandExitStatus(err);
        }
    }

    void OnStatusUpdate(const chip::app::StatusIB & status) override
    {
        switch (mTestIndex - 1) {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        }

        // Go on to the next test.
        ContinueOnChipMainThread(CHIP_NO_ERROR);
    }

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    std::atomic_uint16_t mTestIndex;
    const uint16_t mTestCount = 6;

    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    CHIP_ERROR TestWaitForTheCommissionedDeviceToBeRetrieved_0()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
        value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
        return WaitForCommissionee("alpha", value);
    }

    CHIP_ERROR TestReadTheGlobalAttributeClusterRevision_1()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterBooleanState alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeClusterRevisionWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"read the global attribute: ClusterRevision Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("ClusterRevision", actualValue, 1U));
            }

            VerifyOrReturn(CheckConstraintType("clusterRevision", "int16u", "int16u"));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheGlobalAttributeFeatureMap_2()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterBooleanState alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeFeatureMapWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the global attribute: FeatureMap Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("FeatureMap", actualValue, 0UL));
            }

            VerifyOrReturn(CheckConstraintType("featureMap", "bitmap32", "bitmap32"));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheGlobalAttributeAttributeList_3()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterBooleanState alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAttributeListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the global attribute: AttributeList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("attributeList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 0UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65528UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65529UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65531UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65532UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65533UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheGlobalAttributeAcceptedCommandList_4()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterBooleanState alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAcceptedCommandListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the global attribute: AcceptedCommandList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("AcceptedCommandList", [actualValue count], static_cast<uint32_t>(0)));
            }

            VerifyOrReturn(CheckConstraintType("acceptedCommandList", "list", "list"));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheGlobalAttributeGeneratedCommandList_5()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterBooleanState alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeGeneratedCommandListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the global attribute: GeneratedCommandList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("GeneratedCommandList", [actualValue count], static_cast<uint32_t>(0)));
            }

            VerifyOrReturn(CheckConstraintType("generatedCommandList", "list", "list"));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }
};

class Test_TC_BOOL_2_1 : public TestCommandBridge {
public:
    // NOLINTBEGIN(clang-analyzer-nullability.NullPassedToNonnull): Test constructor nullability not enforced
    Test_TC_BOOL_2_1()
        : TestCommandBridge("Test_TC_BOOL_2_1")
        , mTestIndex(0)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }
    // NOLINTEND(clang-analyzer-nullability.NullPassedToNonnull)

    ~Test_TC_BOOL_2_1() {}

    /////////// TestCommand Interface /////////
    void NextTest() override
    {
        CHIP_ERROR err = CHIP_NO_ERROR;

        if (0 == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Start: Test_TC_BOOL_2_1\n");
        }

        if (mTestCount == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Complete: Test_TC_BOOL_2_1\n");
            SetCommandExitStatus(CHIP_NO_ERROR);
            return;
        }

        Wait();

        // Ensure we increment mTestIndex before we start running the relevant
        // command.  That way if we lose the timeslice after we send the message
        // but before our function call returns, we won't end up with an
        // incorrect mTestIndex value observed when we get the response.
        switch (mTestIndex++) {
        case 0:
            ChipLogProgress(chipTool, " ***** Test Step 0 : Wait for the commissioned device to be retrieved\n");
            err = TestWaitForTheCommissionedDeviceToBeRetrieved_0();
            break;
        case 1:
            ChipLogProgress(chipTool, " ***** Test Step 1 : Read mandatory non-global attribute: StateValue\n");
            if (ShouldSkip("BOOL.S.A0000")) {
                NextTest();
                return;
            }
            err = TestReadMandatoryNonGlobalAttributeStateValue_1();
            break;
        }

        if (CHIP_NO_ERROR != err) {
            ChipLogError(chipTool, " ***** Test Failure: %s\n", chip::ErrorStr(err));
            SetCommandExitStatus(err);
        }
    }

    void OnStatusUpdate(const chip::app::StatusIB & status) override
    {
        switch (mTestIndex - 1) {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        }

        // Go on to the next test.
        ContinueOnChipMainThread(CHIP_NO_ERROR);
    }

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    std::atomic_uint16_t mTestIndex;
    const uint16_t mTestCount = 2;

    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    CHIP_ERROR TestWaitForTheCommissionedDeviceToBeRetrieved_0()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
        value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
        return WaitForCommissionee("alpha", value);
    }

    CHIP_ERROR TestReadMandatoryNonGlobalAttributeStateValue_1()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterBooleanState alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeStateValueWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read mandatory non-global attribute: StateValue Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("stateValue", "boolean", "boolean"));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }
};

class Test_TC_ACT_1_1 : public TestCommandBridge {
public:
    // NOLINTBEGIN(clang-analyzer-nullability.NullPassedToNonnull): Test constructor nullability not enforced
    Test_TC_ACT_1_1()
        : TestCommandBridge("Test_TC_ACT_1_1")
        , mTestIndex(0)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }
    // NOLINTEND(clang-analyzer-nullability.NullPassedToNonnull)

    ~Test_TC_ACT_1_1() {}

    /////////// TestCommand Interface /////////
    void NextTest() override
    {
        CHIP_ERROR err = CHIP_NO_ERROR;

        if (0 == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Start: Test_TC_ACT_1_1\n");
        }

        if (mTestCount == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Complete: Test_TC_ACT_1_1\n");
            SetCommandExitStatus(CHIP_NO_ERROR);
            return;
        }

        Wait();

        // Ensure we increment mTestIndex before we start running the relevant
        // command.  That way if we lose the timeslice after we send the message
        // but before our function call returns, we won't end up with an
        // incorrect mTestIndex value observed when we get the response.
        switch (mTestIndex++) {
        case 0:
            ChipLogProgress(chipTool, " ***** Test Step 0 : Wait for the commissioned device to be retrieved\n");
            err = TestWaitForTheCommissionedDeviceToBeRetrieved_0();
            break;
        case 1:
            ChipLogProgress(chipTool, " ***** Test Step 1 : Read the global attribute: ClusterRevision\n");
            err = TestReadTheGlobalAttributeClusterRevision_1();
            break;
        case 2:
            ChipLogProgress(chipTool, " ***** Test Step 2 : Read the global attribute: FeatureMap\n");
            err = TestReadTheGlobalAttributeFeatureMap_2();
            break;
        case 3:
            ChipLogProgress(chipTool, " ***** Test Step 3 : Read the global attribute: AttributeList\n");
            err = TestReadTheGlobalAttributeAttributeList_3();
            break;
        case 4:
            ChipLogProgress(chipTool, " ***** Test Step 4 : Read the optional attribute(SetupURL) in AttributeList\n");
            if (ShouldSkip("ACT.S.A0002")) {
                NextTest();
                return;
            }
            err = TestReadTheOptionalAttributeSetupURLInAttributeList_4();
            break;
        case 5:
            ChipLogProgress(chipTool, " ***** Test Step 5 : Read the global attribute: AcceptedCommandList\n");
            err = TestReadTheGlobalAttributeAcceptedCommandList_5();
            break;
        case 6:
            ChipLogProgress(chipTool, " ***** Test Step 6 : Read the global attribute: GeneratedCommandList\n");
            err = TestReadTheGlobalAttributeGeneratedCommandList_6();
            break;
        }

        if (CHIP_NO_ERROR != err) {
            ChipLogError(chipTool, " ***** Test Failure: %s\n", chip::ErrorStr(err));
            SetCommandExitStatus(err);
        }
    }

    void OnStatusUpdate(const chip::app::StatusIB & status) override
    {
        switch (mTestIndex - 1) {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 6:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        }

        // Go on to the next test.
        ContinueOnChipMainThread(CHIP_NO_ERROR);
    }

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    std::atomic_uint16_t mTestIndex;
    const uint16_t mTestCount = 7;

    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    CHIP_ERROR TestWaitForTheCommissionedDeviceToBeRetrieved_0()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
        value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
        return WaitForCommissionee("alpha", value);
    }

    CHIP_ERROR TestReadTheGlobalAttributeClusterRevision_1()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterActions alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeClusterRevisionWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the global attribute: ClusterRevision Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("ClusterRevision", actualValue, 1U));
            }

            VerifyOrReturn(CheckConstraintType("clusterRevision", "int16u", "int16u"));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheGlobalAttributeFeatureMap_2()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterActions alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeFeatureMapWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the global attribute: FeatureMap Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("FeatureMap", actualValue, 0UL));
            }

            VerifyOrReturn(CheckConstraintType("featureMap", "bitmap32", "bitmap32"));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheGlobalAttributeAttributeList_3()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterActions alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAttributeListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the global attribute: AttributeList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("attributeList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 0UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 1UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65528UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65529UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65531UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65532UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65533UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheOptionalAttributeSetupURLInAttributeList_4()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterActions alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAttributeListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the optional attribute(SetupURL) in AttributeList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("attributeList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 2UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheGlobalAttributeAcceptedCommandList_5()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterActions alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAcceptedCommandListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the global attribute: AcceptedCommandList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("acceptedCommandList", "list", "list"));
            VerifyOrReturn(CheckConstraintMaxLength("acceptedCommandList", value, 11));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheGlobalAttributeGeneratedCommandList_6()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterActions alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeGeneratedCommandListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the global attribute: GeneratedCommandList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("GeneratedCommandList", [actualValue count], static_cast<uint32_t>(0)));
            }

            VerifyOrReturn(CheckConstraintType("generatedCommandList", "list", "list"));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }
};

class Test_TC_BIND_1_1 : public TestCommandBridge {
public:
    // NOLINTBEGIN(clang-analyzer-nullability.NullPassedToNonnull): Test constructor nullability not enforced
    Test_TC_BIND_1_1()
        : TestCommandBridge("Test_TC_BIND_1_1")
        , mTestIndex(0)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }
    // NOLINTEND(clang-analyzer-nullability.NullPassedToNonnull)

    ~Test_TC_BIND_1_1() {}

    /////////// TestCommand Interface /////////
    void NextTest() override
    {
        CHIP_ERROR err = CHIP_NO_ERROR;

        if (0 == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Start: Test_TC_BIND_1_1\n");
        }

        if (mTestCount == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Complete: Test_TC_BIND_1_1\n");
            SetCommandExitStatus(CHIP_NO_ERROR);
            return;
        }

        Wait();

        // Ensure we increment mTestIndex before we start running the relevant
        // command.  That way if we lose the timeslice after we send the message
        // but before our function call returns, we won't end up with an
        // incorrect mTestIndex value observed when we get the response.
        switch (mTestIndex++) {
        case 0:
            ChipLogProgress(chipTool, " ***** Test Step 0 : Wait for the commissioned device to be retrieved\n");
            err = TestWaitForTheCommissionedDeviceToBeRetrieved_0();
            break;
        case 1:
            ChipLogProgress(chipTool, " ***** Test Step 1 : TH reads the ClusterRevision from DUT\n");
            err = TestThReadsTheClusterRevisionFromDut_1();
            break;
        case 2:
            ChipLogProgress(chipTool, " ***** Test Step 2 : TH reads the FeatureMap from DUT\n");
            err = TestThReadsTheFeatureMapFromDut_2();
            break;
        case 3:
            ChipLogProgress(chipTool, " ***** Test Step 3 : TH reads AttributeList from DUT\n");
            err = TestThReadsAttributeListFromDut_3();
            break;
        case 4:
            ChipLogProgress(chipTool, " ***** Test Step 4 : TH reads AcceptedCommandList from DUT\n");
            err = TestThReadsAcceptedCommandListFromDut_4();
            break;
        case 5:
            ChipLogProgress(chipTool, " ***** Test Step 5 : TH reads GeneratedCommandList from DUT\n");
            err = TestThReadsGeneratedCommandListFromDut_5();
            break;
        }

        if (CHIP_NO_ERROR != err) {
            ChipLogError(chipTool, " ***** Test Failure: %s\n", chip::ErrorStr(err));
            SetCommandExitStatus(err);
        }
    }

    void OnStatusUpdate(const chip::app::StatusIB & status) override
    {
        switch (mTestIndex - 1) {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        }

        // Go on to the next test.
        ContinueOnChipMainThread(CHIP_NO_ERROR);
    }

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    std::atomic_uint16_t mTestIndex;
    const uint16_t mTestCount = 6;

    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    CHIP_ERROR TestWaitForTheCommissionedDeviceToBeRetrieved_0()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
        value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
        return WaitForCommissionee("alpha", value);
    }

    CHIP_ERROR TestThReadsTheClusterRevisionFromDut_1()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterBinding alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeClusterRevisionWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads the ClusterRevision from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("ClusterRevision", actualValue, 1U));
            }

            VerifyOrReturn(CheckConstraintType("clusterRevision", "int16u", "int16u"));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsTheFeatureMapFromDut_2()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterBinding alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeFeatureMapWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads the FeatureMap from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("FeatureMap", actualValue, 0UL));
            }

            VerifyOrReturn(CheckConstraintType("featureMap", "bitmap32", "bitmap32"));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsAttributeListFromDut_3()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterBinding alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAttributeListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads AttributeList from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("attributeList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 0UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65528UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65529UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65531UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65532UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65533UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsAcceptedCommandListFromDut_4()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterBinding alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAcceptedCommandListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads AcceptedCommandList from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("AcceptedCommandList", [actualValue count], static_cast<uint32_t>(0)));
            }

            VerifyOrReturn(CheckConstraintType("acceptedCommandList", "list", "list"));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsGeneratedCommandListFromDut_5()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterBinding alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeGeneratedCommandListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads GeneratedCommandList from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("GeneratedCommandList", [actualValue count], static_cast<uint32_t>(0)));
            }

            VerifyOrReturn(CheckConstraintType("generatedCommandList", "list", "list"));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }
};

class Test_TC_CC_1_1 : public TestCommandBridge {
public:
    // NOLINTBEGIN(clang-analyzer-nullability.NullPassedToNonnull): Test constructor nullability not enforced
    Test_TC_CC_1_1()
        : TestCommandBridge("Test_TC_CC_1_1")
        , mTestIndex(0)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }
    // NOLINTEND(clang-analyzer-nullability.NullPassedToNonnull)

    ~Test_TC_CC_1_1() {}

    /////////// TestCommand Interface /////////
    void NextTest() override
    {
        CHIP_ERROR err = CHIP_NO_ERROR;

        if (0 == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Start: Test_TC_CC_1_1\n");
        }

        if (mTestCount == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Complete: Test_TC_CC_1_1\n");
            SetCommandExitStatus(CHIP_NO_ERROR);
            return;
        }

        Wait();

        // Ensure we increment mTestIndex before we start running the relevant
        // command.  That way if we lose the timeslice after we send the message
        // but before our function call returns, we won't end up with an
        // incorrect mTestIndex value observed when we get the response.
        switch (mTestIndex++) {
        case 0:
            ChipLogProgress(chipTool, " ***** Test Step 0 : Wait for the commissioned device to be retrieved\n");
            err = TestWaitForTheCommissionedDeviceToBeRetrieved_0();
            break;
        case 1:
            ChipLogProgress(chipTool, " ***** Test Step 1 : read the global attribute: ClusterRevision\n");
            err = TestReadTheGlobalAttributeClusterRevision_1();
            break;
        case 2:
            ChipLogProgress(chipTool, " ***** Test Step 2 : Read the global attribute: FeatureMap\n");
            if (ShouldSkip("( !CC.S.F00 && !CC.S.F01 && !CC.S.F02 && !CC.S.F03 && !CC.S.F04 )")) {
                NextTest();
                return;
            }
            err = TestReadTheGlobalAttributeFeatureMap_2();
            break;
        case 3:
            ChipLogProgress(chipTool, " ***** Test Step 3 : Given CC.S.F00(HS) ensure featuremap has the correct bit set\n");
            if (ShouldSkip("CC.S.F00")) {
                NextTest();
                return;
            }
            err = TestGivenCcsf00hsEnsureFeaturemapHasTheCorrectBitSet_3();
            break;
        case 4:
            ChipLogProgress(chipTool, " ***** Test Step 4 : Given CC.S.F01(EHue) ensure featuremap has the correct bit set\n");
            if (ShouldSkip("CC.S.F01")) {
                NextTest();
                return;
            }
            err = TestGivenCCSF01EHueEnsureFeaturemapHasTheCorrectBitSet_4();
            break;
        case 5:
            ChipLogProgress(chipTool, " ***** Test Step 5 : Given CC.S.F02(CL) ensure featuremap has the correct bit set\n");
            if (ShouldSkip("CC.S.F02")) {
                NextTest();
                return;
            }
            err = TestGivenCcsf02clEnsureFeaturemapHasTheCorrectBitSet_5();
            break;
        case 6:
            ChipLogProgress(chipTool, " ***** Test Step 6 : Given CC.S.F03(XY) ensure featuremap has the correct bit set\n");
            if (ShouldSkip("CC.S.F03")) {
                NextTest();
                return;
            }
            err = TestGivenCcsf03xyEnsureFeaturemapHasTheCorrectBitSet_6();
            break;
        case 7:
            ChipLogProgress(chipTool, " ***** Test Step 7 : Given CC.S.F04(CT) ensure featuremap has the correct bit set\n");
            if (ShouldSkip("CC.S.F04")) {
                NextTest();
                return;
            }
            err = TestGivenCcsf04ctEnsureFeaturemapHasTheCorrectBitSet_7();
            break;
        case 8:
            ChipLogProgress(chipTool, " ***** Test Step 8 : Read the global attribute: AttributeList\n");
            err = TestReadTheGlobalAttributeAttributeList_8();
            break;
        case 9:
            ChipLogProgress(chipTool, " ***** Test Step 9 : Read the optional attribute(CurrentHue) in AttributeList\n");
            if (ShouldSkip("CC.S.A0000")) {
                NextTest();
                return;
            }
            err = TestReadTheOptionalAttributeCurrentHueInAttributeList_9();
            break;
        case 10:
            ChipLogProgress(chipTool, " ***** Test Step 10 : Read the optional attribute(CurrentSaturation) in AttributeList\n");
            if (ShouldSkip("CC.S.A0001")) {
                NextTest();
                return;
            }
            err = TestReadTheOptionalAttributeCurrentSaturationInAttributeList_10();
            break;
        case 11:
            ChipLogProgress(chipTool, " ***** Test Step 11 : Read the optional attribute(RemainingTime) in AttributeList\n");
            if (ShouldSkip("CC.S.A0002")) {
                NextTest();
                return;
            }
            err = TestReadTheOptionalAttributeRemainingTimeInAttributeList_11();
            break;
        case 12:
            ChipLogProgress(chipTool, " ***** Test Step 12 : Read the optional attribute(CurrentX) in AttributeList\n");
            if (ShouldSkip("CC.S.A0003")) {
                NextTest();
                return;
            }
            err = TestReadTheOptionalAttributeCurrentXInAttributeList_12();
            break;
        case 13:
            ChipLogProgress(chipTool, " ***** Test Step 13 : Read the optional attribute(CurrentY) in AttributeList\n");
            if (ShouldSkip("CC.S.A0004")) {
                NextTest();
                return;
            }
            err = TestReadTheOptionalAttributeCurrentYInAttributeList_13();
            break;
        case 14:
            ChipLogProgress(chipTool, " ***** Test Step 14 : Read the optional attribute(DriftCompensation) in AttributeList\n");
            if (ShouldSkip("CC.S.A0005")) {
                NextTest();
                return;
            }
            err = TestReadTheOptionalAttributeDriftCompensationInAttributeList_14();
            break;
        case 15:
            ChipLogProgress(chipTool, " ***** Test Step 15 : Read the optional attribute(CompensationText) in AttributeList\n");
            if (ShouldSkip("CC.S.A0006")) {
                NextTest();
                return;
            }
            err = TestReadTheOptionalAttributeCompensationTextInAttributeList_15();
            break;
        case 16:
            ChipLogProgress(
                chipTool, " ***** Test Step 16 : Read the optional attribute(ColorTemperatureMireds) in AttributeList\n");
            if (ShouldSkip("CC.S.A0007")) {
                NextTest();
                return;
            }
            err = TestReadTheOptionalAttributeColorTemperatureMiredsInAttributeList_16();
            break;
        case 17:
            ChipLogProgress(chipTool, " ***** Test Step 17 : Read the optional attribute(EnhancedCurrentHue) in AttributeList\n");
            if (ShouldSkip("CC.S.A4000")) {
                NextTest();
                return;
            }
            err = TestReadTheOptionalAttributeEnhancedCurrentHueInAttributeList_17();
            break;
        case 18:
            ChipLogProgress(chipTool, " ***** Test Step 18 : Read the optional attribute(ColorLoopActive) in AttributeList\n");
            if (ShouldSkip("CC.S.A4002")) {
                NextTest();
                return;
            }
            err = TestReadTheOptionalAttributeColorLoopActiveInAttributeList_18();
            break;
        case 19:
            ChipLogProgress(chipTool, " ***** Test Step 19 : Read the optional attribute(ColorLoopDirection) in AttributeList\n");
            if (ShouldSkip("CC.S.A4003")) {
                NextTest();
                return;
            }
            err = TestReadTheOptionalAttributeColorLoopDirectionInAttributeList_19();
            break;
        case 20:
            ChipLogProgress(chipTool, " ***** Test Step 20 : Read the optional attribute(ColorLoopTime) in AttributeList\n");
            if (ShouldSkip("CC.S.A4004")) {
                NextTest();
                return;
            }
            err = TestReadTheOptionalAttributeColorLoopTimeInAttributeList_20();
            break;
        case 21:
            ChipLogProgress(
                chipTool, " ***** Test Step 21 : Read the optional attribute(ColorLoopStartEnhancedHue) in AttributeList\n");
            if (ShouldSkip("CC.S.A4005")) {
                NextTest();
                return;
            }
            err = TestReadTheOptionalAttributeColorLoopStartEnhancedHueInAttributeList_21();
            break;
        case 22:
            ChipLogProgress(
                chipTool, " ***** Test Step 22 : Read the optional attribute(ColorLoopStoredEnhancedHue) in AttributeList\n");
            if (ShouldSkip("CC.S.A4006")) {
                NextTest();
                return;
            }
            err = TestReadTheOptionalAttributeColorLoopStoredEnhancedHueInAttributeList_22();
            break;
        case 23:
            ChipLogProgress(
                chipTool, " ***** Test Step 23 : Read the optional attribute(ColorTempPhysicalMinMireds) in AttributeList\n");
            if (ShouldSkip("CC.S.A400b")) {
                NextTest();
                return;
            }
            err = TestReadTheOptionalAttributeColorTempPhysicalMinMiredsInAttributeList_23();
            break;
        case 24:
            ChipLogProgress(
                chipTool, " ***** Test Step 24 : Read the optional attribute(ColorTempPhysicalMaxMireds) in AttributeList\n");
            if (ShouldSkip("CC.S.A400c")) {
                NextTest();
                return;
            }
            err = TestReadTheOptionalAttributeColorTempPhysicalMaxMiredsInAttributeList_24();
            break;
        case 25:
            ChipLogProgress(
                chipTool, " ***** Test Step 25 : Read the optional attribute(CoupleColorTempToLevelMinMireds) in AttributeList\n");
            if (ShouldSkip("CC.S.A400d")) {
                NextTest();
                return;
            }
            err = TestReadTheOptionalAttributeCoupleColorTempToLevelMinMiredsInAttributeList_25();
            break;
        case 26:
            ChipLogProgress(
                chipTool, " ***** Test Step 26 : Read the optional attribute(StartUpColorTemperatureMireds) in AttributeList\n");
            if (ShouldSkip("CC.S.A4010")) {
                NextTest();
                return;
            }
            err = TestReadTheOptionalAttributeStartUpColorTemperatureMiredsInAttributeList_26();
            break;
        case 27:
            ChipLogProgress(chipTool, " ***** Test Step 27 : Read the optional command(MoveToHue) in AcceptedCommandList\n");
            if (ShouldSkip("CC.S.C00.Rsp")) {
                NextTest();
                return;
            }
            err = TestReadTheOptionalCommandMoveToHueInAcceptedCommandList_27();
            break;
        case 28:
            ChipLogProgress(chipTool, " ***** Test Step 28 : Read the optional command(MoveHue) in AcceptedCommandList\n");
            if (ShouldSkip("CC.S.C01.Rsp")) {
                NextTest();
                return;
            }
            err = TestReadTheOptionalCommandMoveHueInAcceptedCommandList_28();
            break;
        case 29:
            ChipLogProgress(chipTool, " ***** Test Step 29 : Read the optional command(StepHue) in AcceptedCommandList\n");
            if (ShouldSkip("CC.S.C02.Rsp")) {
                NextTest();
                return;
            }
            err = TestReadTheOptionalCommandStepHueInAcceptedCommandList_29();
            break;
        case 30:
            ChipLogProgress(chipTool, " ***** Test Step 30 : Read the optional command(MoveToSaturation) in AcceptedCommandList\n");
            if (ShouldSkip("CC.S.C03.Rsp")) {
                NextTest();
                return;
            }
            err = TestReadTheOptionalCommandMoveToSaturationInAcceptedCommandList_30();
            break;
        case 31:
            ChipLogProgress(chipTool, " ***** Test Step 31 : Read the optional command(MoveSaturation) in AcceptedCommandList\n");
            if (ShouldSkip("CC.S.C04.Rsp")) {
                NextTest();
                return;
            }
            err = TestReadTheOptionalCommandMoveSaturationInAcceptedCommandList_31();
            break;
        case 32:
            ChipLogProgress(chipTool, " ***** Test Step 32 : Read the optional command(StepSaturation) in AcceptedCommandList\n");
            if (ShouldSkip("CC.S.C05.Rsp")) {
                NextTest();
                return;
            }
            err = TestReadTheOptionalCommandStepSaturationInAcceptedCommandList_32();
            break;
        case 33:
            ChipLogProgress(
                chipTool, " ***** Test Step 33 : Read the optional command(MoveToHueAndSaturation) in AcceptedCommandList\n");
            if (ShouldSkip("CC.S.C06.Rsp")) {
                NextTest();
                return;
            }
            err = TestReadTheOptionalCommandMoveToHueAndSaturationInAcceptedCommandList_33();
            break;
        case 34:
            ChipLogProgress(chipTool, " ***** Test Step 34 : Read the optional command(MoveToColor) in AcceptedCommandList\n");
            if (ShouldSkip("CC.S.C07.Rsp")) {
                NextTest();
                return;
            }
            err = TestReadTheOptionalCommandMoveToColorInAcceptedCommandList_34();
            break;
        case 35:
            ChipLogProgress(chipTool, " ***** Test Step 35 : Read the optional command(MoveColor) in AcceptedCommandList\n");
            if (ShouldSkip("CC.S.C08.Rsp")) {
                NextTest();
                return;
            }
            err = TestReadTheOptionalCommandMoveColorInAcceptedCommandList_35();
            break;
        case 36:
            ChipLogProgress(chipTool, " ***** Test Step 36 : Read the optional command(StepColor) in AcceptedCommandList\n");
            if (ShouldSkip("CC.S.C09.Rsp")) {
                NextTest();
                return;
            }
            err = TestReadTheOptionalCommandStepColorInAcceptedCommandList_36();
            break;
        case 37:
            ChipLogProgress(
                chipTool, " ***** Test Step 37 : Read the optional command(MoveToColorTemperature) in AcceptedCommandList\n");
            if (ShouldSkip("CC.S.C0a.Rsp")) {
                NextTest();
                return;
            }
            err = TestReadTheOptionalCommandMoveToColorTemperatureInAcceptedCommandList_37();
            break;
        case 38:
            ChipLogProgress(
                chipTool, " ***** Test Step 38 : Read the optional command(EnhancedMoveToHue) in AcceptedCommandList\n");
            if (ShouldSkip("CC.S.C40.Rsp")) {
                NextTest();
                return;
            }
            err = TestReadTheOptionalCommandEnhancedMoveToHueInAcceptedCommandList_38();
            break;
        case 39:
            ChipLogProgress(chipTool, " ***** Test Step 39 : Read the optional command(EnhancedMoveHue) in AcceptedCommandList\n");
            if (ShouldSkip("CC.S.C41.Rsp")) {
                NextTest();
                return;
            }
            err = TestReadTheOptionalCommandEnhancedMoveHueInAcceptedCommandList_39();
            break;
        case 40:
            ChipLogProgress(chipTool, " ***** Test Step 40 : Read the optional command(EnhancedStepHue) in AcceptedCommandList\n");
            if (ShouldSkip("CC.S.C42.Rsp")) {
                NextTest();
                return;
            }
            err = TestReadTheOptionalCommandEnhancedStepHueInAcceptedCommandList_40();
            break;
        case 41:
            ChipLogProgress(chipTool,
                " ***** Test Step 41 : Read the optional command(EnhancedMoveToHueAndSaturation) in AcceptedCommandList\n");
            if (ShouldSkip("CC.S.C43.Rsp")) {
                NextTest();
                return;
            }
            err = TestReadTheOptionalCommandEnhancedMoveToHueAndSaturationInAcceptedCommandList_41();
            break;
        case 42:
            ChipLogProgress(chipTool, " ***** Test Step 42 : Read the optional command(ColorLoopSet) in AcceptedCommandList\n");
            if (ShouldSkip("CC.S.C44.Rsp")) {
                NextTest();
                return;
            }
            err = TestReadTheOptionalCommandColorLoopSetInAcceptedCommandList_42();
            break;
        case 43:
            ChipLogProgress(chipTool, " ***** Test Step 43 : Read the optional command(StopMoveStep) in AcceptedCommandList\n");
            if (ShouldSkip("CC.S.C47.Rsp")) {
                NextTest();
                return;
            }
            err = TestReadTheOptionalCommandStopMoveStepInAcceptedCommandList_43();
            break;
        case 44:
            ChipLogProgress(
                chipTool, " ***** Test Step 44 : Read the optional command(MoveColorTemperature) in AcceptedCommandList\n");
            if (ShouldSkip("CC.S.C4b.Rsp")) {
                NextTest();
                return;
            }
            err = TestReadTheOptionalCommandMoveColorTemperatureInAcceptedCommandList_44();
            break;
        case 45:
            ChipLogProgress(
                chipTool, " ***** Test Step 45 : Read the optional command(StepColorTemperature) in AcceptedCommandList\n");
            if (ShouldSkip("CC.S.C4c.Rsp")) {
                NextTest();
                return;
            }
            err = TestReadTheOptionalCommandStepColorTemperatureInAcceptedCommandList_45();
            break;
        case 46:
            ChipLogProgress(chipTool, " ***** Test Step 46 : Read the global attribute: GeneratedCommandList\n");
            err = TestReadTheGlobalAttributeGeneratedCommandList_46();
            break;
        }

        if (CHIP_NO_ERROR != err) {
            ChipLogError(chipTool, " ***** Test Failure: %s\n", chip::ErrorStr(err));
            SetCommandExitStatus(err);
        }
    }

    void OnStatusUpdate(const chip::app::StatusIB & status) override
    {
        switch (mTestIndex - 1) {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 6:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 7:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 8:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 9:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 10:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 11:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 12:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 13:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 14:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 15:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 16:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 17:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 18:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 19:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 20:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 21:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 22:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 23:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 24:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 25:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 26:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 27:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 28:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 29:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 30:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 31:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 32:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 33:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 34:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 35:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 36:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 37:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 38:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 39:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 40:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 41:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 42:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 43:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 44:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 45:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 46:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        }

        // Go on to the next test.
        ContinueOnChipMainThread(CHIP_NO_ERROR);
    }

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    std::atomic_uint16_t mTestIndex;
    const uint16_t mTestCount = 47;

    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    CHIP_ERROR TestWaitForTheCommissionedDeviceToBeRetrieved_0()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
        value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
        return WaitForCommissionee("alpha", value);
    }

    CHIP_ERROR TestReadTheGlobalAttributeClusterRevision_1()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeClusterRevisionWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"read the global attribute: ClusterRevision Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("ClusterRevision", actualValue, 5U));
            }

            VerifyOrReturn(CheckConstraintType("clusterRevision", "int16u", "int16u"));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheGlobalAttributeFeatureMap_2()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeFeatureMapWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the global attribute: FeatureMap Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("FeatureMap", actualValue, 0UL));
            }

            VerifyOrReturn(CheckConstraintType("featureMap", "bitmap32", "bitmap32"));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestGivenCcsf00hsEnsureFeaturemapHasTheCorrectBitSet_3()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeFeatureMapWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Given CC.S.F00(HS) ensure featuremap has the correct bit set Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("featureMap", "bitmap32", "bitmap32"));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestGivenCCSF01EHueEnsureFeaturemapHasTheCorrectBitSet_4()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeFeatureMapWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Given CC.S.F01(EHue) ensure featuremap has the correct bit set Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("featureMap", "bitmap32", "bitmap32"));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestGivenCcsf02clEnsureFeaturemapHasTheCorrectBitSet_5()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeFeatureMapWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Given CC.S.F02(CL) ensure featuremap has the correct bit set Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("featureMap", "bitmap32", "bitmap32"));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestGivenCcsf03xyEnsureFeaturemapHasTheCorrectBitSet_6()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeFeatureMapWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Given CC.S.F03(XY) ensure featuremap has the correct bit set Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("featureMap", "bitmap32", "bitmap32"));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestGivenCcsf04ctEnsureFeaturemapHasTheCorrectBitSet_7()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeFeatureMapWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Given CC.S.F04(CT) ensure featuremap has the correct bit set Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("featureMap", "bitmap32", "bitmap32"));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheGlobalAttributeAttributeList_8()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAttributeListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the global attribute: AttributeList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("attributeList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 8UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 15UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 16385UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 16394UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65528UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65529UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65531UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65532UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65533UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheOptionalAttributeCurrentHueInAttributeList_9()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAttributeListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the optional attribute(CurrentHue) in AttributeList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("attributeList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 0UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheOptionalAttributeCurrentSaturationInAttributeList_10()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAttributeListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the optional attribute(CurrentSaturation) in AttributeList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("attributeList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 1UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheOptionalAttributeRemainingTimeInAttributeList_11()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAttributeListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the optional attribute(RemainingTime) in AttributeList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("attributeList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 2UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheOptionalAttributeCurrentXInAttributeList_12()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAttributeListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the optional attribute(CurrentX) in AttributeList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("attributeList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 3UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheOptionalAttributeCurrentYInAttributeList_13()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAttributeListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the optional attribute(CurrentY) in AttributeList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("attributeList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 4UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheOptionalAttributeDriftCompensationInAttributeList_14()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAttributeListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the optional attribute(DriftCompensation) in AttributeList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("attributeList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 5UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheOptionalAttributeCompensationTextInAttributeList_15()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAttributeListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the optional attribute(CompensationText) in AttributeList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("attributeList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 6UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheOptionalAttributeColorTemperatureMiredsInAttributeList_16()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAttributeListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the optional attribute(ColorTemperatureMireds) in AttributeList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("attributeList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 7UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheOptionalAttributeEnhancedCurrentHueInAttributeList_17()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAttributeListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the optional attribute(EnhancedCurrentHue) in AttributeList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("attributeList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 16384UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheOptionalAttributeColorLoopActiveInAttributeList_18()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAttributeListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the optional attribute(ColorLoopActive) in AttributeList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("attributeList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 16386UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheOptionalAttributeColorLoopDirectionInAttributeList_19()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAttributeListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the optional attribute(ColorLoopDirection) in AttributeList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("attributeList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 16387UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheOptionalAttributeColorLoopTimeInAttributeList_20()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAttributeListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the optional attribute(ColorLoopTime) in AttributeList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("attributeList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 16388UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheOptionalAttributeColorLoopStartEnhancedHueInAttributeList_21()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAttributeListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the optional attribute(ColorLoopStartEnhancedHue) in AttributeList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("attributeList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 16389UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheOptionalAttributeColorLoopStoredEnhancedHueInAttributeList_22()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAttributeListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the optional attribute(ColorLoopStoredEnhancedHue) in AttributeList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("attributeList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 16390UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheOptionalAttributeColorTempPhysicalMinMiredsInAttributeList_23()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAttributeListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the optional attribute(ColorTempPhysicalMinMireds) in AttributeList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("attributeList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 16395UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheOptionalAttributeColorTempPhysicalMaxMiredsInAttributeList_24()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAttributeListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the optional attribute(ColorTempPhysicalMaxMireds) in AttributeList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("attributeList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 16396UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheOptionalAttributeCoupleColorTempToLevelMinMiredsInAttributeList_25()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAttributeListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the optional attribute(CoupleColorTempToLevelMinMireds) in AttributeList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("attributeList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 16397UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheOptionalAttributeStartUpColorTemperatureMiredsInAttributeList_26()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAttributeListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the optional attribute(StartUpColorTemperatureMireds) in AttributeList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("attributeList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 16400UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheOptionalCommandMoveToHueInAcceptedCommandList_27()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAcceptedCommandListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the optional command(MoveToHue) in AcceptedCommandList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("acceptedCommandList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("acceptedCommandList", value, 0UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheOptionalCommandMoveHueInAcceptedCommandList_28()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAcceptedCommandListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the optional command(MoveHue) in AcceptedCommandList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("acceptedCommandList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("acceptedCommandList", value, 1UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheOptionalCommandStepHueInAcceptedCommandList_29()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAcceptedCommandListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the optional command(StepHue) in AcceptedCommandList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("acceptedCommandList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("acceptedCommandList", value, 2UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheOptionalCommandMoveToSaturationInAcceptedCommandList_30()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAcceptedCommandListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the optional command(MoveToSaturation) in AcceptedCommandList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("acceptedCommandList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("acceptedCommandList", value, 3UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheOptionalCommandMoveSaturationInAcceptedCommandList_31()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAcceptedCommandListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the optional command(MoveSaturation) in AcceptedCommandList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("acceptedCommandList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("acceptedCommandList", value, 4UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheOptionalCommandStepSaturationInAcceptedCommandList_32()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAcceptedCommandListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the optional command(StepSaturation) in AcceptedCommandList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("acceptedCommandList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("acceptedCommandList", value, 5UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheOptionalCommandMoveToHueAndSaturationInAcceptedCommandList_33()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAcceptedCommandListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the optional command(MoveToHueAndSaturation) in AcceptedCommandList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("acceptedCommandList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("acceptedCommandList", value, 6UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheOptionalCommandMoveToColorInAcceptedCommandList_34()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAcceptedCommandListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the optional command(MoveToColor) in AcceptedCommandList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("acceptedCommandList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("acceptedCommandList", value, 7UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheOptionalCommandMoveColorInAcceptedCommandList_35()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAcceptedCommandListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the optional command(MoveColor) in AcceptedCommandList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("acceptedCommandList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("acceptedCommandList", value, 8UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheOptionalCommandStepColorInAcceptedCommandList_36()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAcceptedCommandListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the optional command(StepColor) in AcceptedCommandList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("acceptedCommandList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("acceptedCommandList", value, 9UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheOptionalCommandMoveToColorTemperatureInAcceptedCommandList_37()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAcceptedCommandListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the optional command(MoveToColorTemperature) in AcceptedCommandList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("acceptedCommandList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("acceptedCommandList", value, 10UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheOptionalCommandEnhancedMoveToHueInAcceptedCommandList_38()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAcceptedCommandListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the optional command(EnhancedMoveToHue) in AcceptedCommandList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("acceptedCommandList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("acceptedCommandList", value, 64UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheOptionalCommandEnhancedMoveHueInAcceptedCommandList_39()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAcceptedCommandListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the optional command(EnhancedMoveHue) in AcceptedCommandList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("acceptedCommandList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("acceptedCommandList", value, 65UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheOptionalCommandEnhancedStepHueInAcceptedCommandList_40()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAcceptedCommandListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the optional command(EnhancedStepHue) in AcceptedCommandList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("acceptedCommandList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("acceptedCommandList", value, 66UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheOptionalCommandEnhancedMoveToHueAndSaturationInAcceptedCommandList_41()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAcceptedCommandListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the optional command(EnhancedMoveToHueAndSaturation) in AcceptedCommandList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("acceptedCommandList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("acceptedCommandList", value, 67UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheOptionalCommandColorLoopSetInAcceptedCommandList_42()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAcceptedCommandListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the optional command(ColorLoopSet) in AcceptedCommandList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("acceptedCommandList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("acceptedCommandList", value, 68UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheOptionalCommandStopMoveStepInAcceptedCommandList_43()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAcceptedCommandListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the optional command(StopMoveStep) in AcceptedCommandList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("acceptedCommandList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("acceptedCommandList", value, 71UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheOptionalCommandMoveColorTemperatureInAcceptedCommandList_44()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAcceptedCommandListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the optional command(MoveColorTemperature) in AcceptedCommandList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("acceptedCommandList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("acceptedCommandList", value, 75UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheOptionalCommandStepColorTemperatureInAcceptedCommandList_45()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAcceptedCommandListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the optional command(StepColorTemperature) in AcceptedCommandList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("acceptedCommandList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("acceptedCommandList", value, 76UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheGlobalAttributeGeneratedCommandList_46()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeGeneratedCommandListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the global attribute: GeneratedCommandList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("GeneratedCommandList", [actualValue count], static_cast<uint32_t>(0)));
            }

            VerifyOrReturn(CheckConstraintType("generatedCommandList", "list", "list"));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }
};

class Test_TC_CC_2_1 : public TestCommandBridge {
public:
    // NOLINTBEGIN(clang-analyzer-nullability.NullPassedToNonnull): Test constructor nullability not enforced
    Test_TC_CC_2_1()
        : TestCommandBridge("Test_TC_CC_2_1")
        , mTestIndex(0)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }
    // NOLINTEND(clang-analyzer-nullability.NullPassedToNonnull)

    ~Test_TC_CC_2_1() {}

    /////////// TestCommand Interface /////////
    void NextTest() override
    {
        CHIP_ERROR err = CHIP_NO_ERROR;

        if (0 == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Start: Test_TC_CC_2_1\n");
        }

        if (mTestCount == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Complete: Test_TC_CC_2_1\n");
            SetCommandExitStatus(CHIP_NO_ERROR);
            return;
        }

        Wait();

        // Ensure we increment mTestIndex before we start running the relevant
        // command.  That way if we lose the timeslice after we send the message
        // but before our function call returns, we won't end up with an
        // incorrect mTestIndex value observed when we get the response.
        switch (mTestIndex++) {
        case 0:
            ChipLogProgress(chipTool, " ***** Test Step 0 : Wait for the commissioned device to be retrieved\n");
            err = TestWaitForTheCommissionedDeviceToBeRetrieved_0();
            break;
        case 1:
            ChipLogProgress(chipTool, " ***** Test Step 1 : TH reads CurrentHue attribute from DUT\n");
            if (ShouldSkip("CC.S.A0000")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentHueAttributeFromDut_1();
            break;
        case 2:
            ChipLogProgress(chipTool, " ***** Test Step 2 : TH reads CurrentSaturation attribute from DUT\n");
            if (ShouldSkip("CC.S.A0001")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentSaturationAttributeFromDut_2();
            break;
        case 3:
            ChipLogProgress(chipTool, " ***** Test Step 3 : TH reads RemainingTime attribute from DUT\n");
            if (ShouldSkip("CC.S.A0002")) {
                NextTest();
                return;
            }
            err = TestThReadsRemainingTimeAttributeFromDut_3();
            break;
        case 4:
            ChipLogProgress(chipTool, " ***** Test Step 4 : TH reads CurrentX attribute from DUT\n");
            if (ShouldSkip("CC.S.A0003")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentXAttributeFromDut_4();
            break;
        case 5:
            ChipLogProgress(chipTool, " ***** Test Step 5 : TH reads CurrentY attribute from DUT\n");
            if (ShouldSkip("CC.S.A0004")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentYAttributeFromDut_5();
            break;
        case 6:
            ChipLogProgress(chipTool, " ***** Test Step 6 : TH reads DriftCompensation attribute from DUT\n");
            if (ShouldSkip("CC.S.A0005")) {
                NextTest();
                return;
            }
            err = TestThReadsDriftCompensationAttributeFromDut_6();
            break;
        case 7:
            ChipLogProgress(chipTool, " ***** Test Step 7 : TH reads CompensationText attribute from DUT\n");
            if (ShouldSkip("CC.S.A0005")) {
                NextTest();
                return;
            }
            err = TestThReadsCompensationTextAttributeFromDut_7();
            break;
        case 8:
            ChipLogProgress(chipTool, " ***** Test Step 8 : TH reads ColorTemperatureMireds attribute from DUT\n");
            if (ShouldSkip("CC.S.A0007")) {
                NextTest();
                return;
            }
            err = TestThReadsColorTemperatureMiredsAttributeFromDut_8();
            break;
        case 9:
            ChipLogProgress(chipTool, " ***** Test Step 9 : TH reads ColorMode attribute from DUT\n");
            if (ShouldSkip("CC.S.A0008")) {
                NextTest();
                return;
            }
            err = TestThReadsColorModeAttributeFromDut_9();
            break;
        case 10:
            ChipLogProgress(chipTool, " ***** Test Step 10 : TH reads Options attribute from DUT\n");
            if (ShouldSkip("CC.S.A000f")) {
                NextTest();
                return;
            }
            err = TestThReadsOptionsAttributeFromDut_10();
            break;
        case 11:
            ChipLogProgress(chipTool, " ***** Test Step 11 : TH reads EnhancedCurrentHue attribute from DUT\n");
            if (ShouldSkip("CC.S.A4000")) {
                NextTest();
                return;
            }
            err = TestThReadsEnhancedCurrentHueAttributeFromDut_11();
            break;
        case 12:
            ChipLogProgress(chipTool, " ***** Test Step 12 : TH reads EnhancedColorMode attribute from DUT\n");
            if (ShouldSkip("CC.S.F02")) {
                NextTest();
                return;
            }
            err = TestThReadsEnhancedColorModeAttributeFromDut_12();
            break;
        case 13:
            ChipLogProgress(chipTool, " ***** Test Step 13 : TH reads ColorLoopActive attribute from DUT\n");
            if (ShouldSkip("CC.S.A4002")) {
                NextTest();
                return;
            }
            err = TestThReadsColorLoopActiveAttributeFromDut_13();
            break;
        case 14:
            ChipLogProgress(chipTool, " ***** Test Step 14 : TH reads ColorLoopDirection attribute from DUT\n");
            if (ShouldSkip("CC.S.A4003")) {
                NextTest();
                return;
            }
            err = TestThReadsColorLoopDirectionAttributeFromDut_14();
            break;
        case 15:
            ChipLogProgress(chipTool, " ***** Test Step 15 : TH reads ColorLoopTime attribute from DUT\n");
            if (ShouldSkip("CC.S.A4004")) {
                NextTest();
                return;
            }
            err = TestThReadsColorLoopTimeAttributeFromDut_15();
            break;
        case 16:
            ChipLogProgress(chipTool, " ***** Test Step 16 : TH reads ColorLoopStartEnhancedHue attribute from DUT\n");
            if (ShouldSkip("CC.S.A4005")) {
                NextTest();
                return;
            }
            err = TestThReadsColorLoopStartEnhancedHueAttributeFromDut_16();
            break;
        case 17:
            ChipLogProgress(chipTool, " ***** Test Step 17 : TH reads ColorLoopStoredEnhancedHue attribute from DUT\n");
            if (ShouldSkip("CC.S.A4006")) {
                NextTest();
                return;
            }
            err = TestThReadsColorLoopStoredEnhancedHueAttributeFromDut_17();
            break;
        case 18:
            ChipLogProgress(
                chipTool, " ***** Test Step 18 : Saving for comparision in step 19 reads FeatureMap attribute from DUT\n");
            err = TestSavingForComparisionInStep19ReadsFeatureMapAttributeFromDut_18();
            break;
        case 19:
            ChipLogProgress(chipTool, " ***** Test Step 19 : TH reads ColorCapabilities attribute from DUT\n");
            if (ShouldSkip("CC.S.A400a")) {
                NextTest();
                return;
            }
            err = TestThReadsColorCapabilitiesAttributeFromDut_19();
            break;
        case 20:
            ChipLogProgress(chipTool, " ***** Test Step 20 : TH reads ColorTempPhysicalMinMireds attribute from DUT\n");
            if (ShouldSkip("CC.S.A400b")) {
                NextTest();
                return;
            }
            err = TestThReadsColorTempPhysicalMinMiredsAttributeFromDut_20();
            break;
        case 21:
            ChipLogProgress(chipTool, " ***** Test Step 21 : TH reads ColorTempPhysicalMaxMireds attribute from DUT\n");
            if (ShouldSkip("CC.S.A400c")) {
                NextTest();
                return;
            }
            err = TestThReadsColorTempPhysicalMaxMiredsAttributeFromDut_21();
            break;
        case 22:
            ChipLogProgress(chipTool, " ***** Test Step 22 : TH reads CoupleColorTempToLevelMinMireds attribute from DUT\n");
            if (ShouldSkip("CC.S.A400d")) {
                NextTest();
                return;
            }
            err = TestThReadsCoupleColorTempToLevelMinMiredsAttributeFromDut_22();
            break;
        case 23:
            ChipLogProgress(chipTool, " ***** Test Step 23 : TH reads StartUpColorTemperatureMireds attribute from DUT\n");
            if (ShouldSkip("CC.S.A4010")) {
                NextTest();
                return;
            }
            err = TestThReadsStartUpColorTemperatureMiredsAttributeFromDut_23();
            break;
        case 24:
            ChipLogProgress(chipTool, " ***** Test Step 24 : TH reads NumberOfPrimaries attribute from DUT\n");
            if (ShouldSkip("CC.S.A0010")) {
                NextTest();
                return;
            }
            err = TestThReadsNumberOfPrimariesAttributeFromDut_24();
            break;
        case 25:
            ChipLogProgress(chipTool,
                " ***** Test Step 25 : TH reads Primary1X attribute from DUT and Verify that the DUT response contains an uint16 "
                "[Min:0 Max:0xfeff] if NumberOfPrimaries is 1 or more\n");
            if (ShouldSkip("PICS_USER_PROMPT && CC.S.A0011")) {
                NextTest();
                return;
            }
            err = TestThReadsPrimary1XAttributeFromDutAndVerifyThatTheDutResponseContainsAnUint16Min0Max0xfeffIfNumberOfPrimariesIs1OrMore_25();
            break;
        case 26:
            ChipLogProgress(chipTool,
                " ***** Test Step 26 : TH reads Primary1Y attribute from DUT and Verify that the DUT response contains an uint16 "
                "[Min:0 Max:0xfeff] if NumberOfPrimaries is 1 or more\n");
            if (ShouldSkip("PICS_USER_PROMPT && CC.S.A0012")) {
                NextTest();
                return;
            }
            err = TestThReadsPrimary1YAttributeFromDutAndVerifyThatTheDutResponseContainsAnUint16Min0Max0xfeffIfNumberOfPrimariesIs1OrMore_26();
            break;
        case 27:
            ChipLogProgress(chipTool,
                " ***** Test Step 27 : TH reads Primary1Intensity attribute from DUT and Verify that the DUT response contains an "
                "uint8 if NumberOfPrimaries is 1 or more\n");
            if (ShouldSkip("PICS_USER_PROMPT && CC.S.A0013")) {
                NextTest();
                return;
            }
            err = TestThReadsPrimary1IntensityAttributeFromDutAndVerifyThatTheDutResponseContainsAnUint8IfNumberOfPrimariesIs1OrMore_27();
            break;
        case 28:
            ChipLogProgress(chipTool,
                " ***** Test Step 28 : TH reads Primary2X attribute from DUT and Verify that the DUT response contains an uint16 "
                "[Min:0 Max:0xfeff] if NumberOfPrimaries is 2 or more\n");
            if (ShouldSkip("PICS_USER_PROMPT && CC.S.A0015")) {
                NextTest();
                return;
            }
            err = TestThReadsPrimary2XAttributeFromDutAndVerifyThatTheDutResponseContainsAnUint16Min0Max0xfeffIfNumberOfPrimariesIs2OrMore_28();
            break;
        case 29:
            ChipLogProgress(chipTool,
                " ***** Test Step 29 : TH reads Primary2Y attribute from DUT and Verify that the DUT response contains an uint16 "
                "[Min:0 Max:0xfeff] if NumberOfPrimaries is 2 or more\n");
            if (ShouldSkip("PICS_USER_PROMPT && CC.S.A0016")) {
                NextTest();
                return;
            }
            err = TestThReadsPrimary2YAttributeFromDutAndVerifyThatTheDutResponseContainsAnUint16Min0Max0xfeffIfNumberOfPrimariesIs2OrMore_29();
            break;
        case 30:
            ChipLogProgress(chipTool,
                " ***** Test Step 30 : TH reads Primary2Intensity attribute from DUT and Verify that the DUT response contains an "
                "uint8 if NumberOfPrimaries is 2 or more\n");
            if (ShouldSkip("PICS_USER_PROMPT && CC.S.A0017")) {
                NextTest();
                return;
            }
            err = TestThReadsPrimary2IntensityAttributeFromDutAndVerifyThatTheDutResponseContainsAnUint8IfNumberOfPrimariesIs2OrMore_30();
            break;
        case 31:
            ChipLogProgress(chipTool,
                " ***** Test Step 31 : TH reads Primary3X attribute from DUT and Verify that the DUT response contains an uint16 "
                "[Min:0 Max:0xfeff] if NumberOfPrimaries is 3 or more\n");
            if (ShouldSkip("PICS_USER_PROMPT && CC.S.A0019")) {
                NextTest();
                return;
            }
            err = TestThReadsPrimary3XAttributeFromDutAndVerifyThatTheDutResponseContainsAnUint16Min0Max0xfeffIfNumberOfPrimariesIs3OrMore_31();
            break;
        case 32:
            ChipLogProgress(chipTool,
                " ***** Test Step 32 : TH reads Primary3Y attribute from DUT and Verify that the DUT response contains an uint16 "
                "[Min:0 Max:0xfeff] if NumberOfPrimaries is 3 or more\n");
            if (ShouldSkip("PICS_USER_PROMPT && CC.S.A001a")) {
                NextTest();
                return;
            }
            err = TestThReadsPrimary3YAttributeFromDutAndVerifyThatTheDutResponseContainsAnUint16Min0Max0xfeffIfNumberOfPrimariesIs3OrMore_32();
            break;
        case 33:
            ChipLogProgress(chipTool,
                " ***** Test Step 33 : TH reads Primary3Intensity attribute from DUT and Verify that the DUT response contains an "
                "uint8 if NumberOfPrimaries is 3 or more\n");
            if (ShouldSkip("PICS_USER_PROMPT && CC.S.A001b")) {
                NextTest();
                return;
            }
            err = TestThReadsPrimary3IntensityAttributeFromDutAndVerifyThatTheDutResponseContainsAnUint8IfNumberOfPrimariesIs3OrMore_33();
            break;
        case 34:
            ChipLogProgress(chipTool,
                " ***** Test Step 34 : TH reads Primary4X attribute from DUT Verify that the DUT response contains an uint16 "
                "[Min:0 Max:0xfeff] if NumberOfPrimaries is 4 or more\n");
            if (ShouldSkip("PICS_USER_PROMPT && CC.S.A0020")) {
                NextTest();
                return;
            }
            err = TestThReadsPrimary4XAttributeFromDutVerifyThatTheDutResponseContainsAnUint16Min0Max0xfeffIfNumberOfPrimariesIs4OrMore_34();
            break;
        case 35:
            ChipLogProgress(chipTool,
                " ***** Test Step 35 : TH reads Primary4Y attribute from DUT and Verify that the DUT response contains an uint16 "
                "[Min:0 Max:0xfeff] if NumberOfPrimaries is 4 or more\n");
            if (ShouldSkip("PICS_USER_PROMPT && CC.S.A0021")) {
                NextTest();
                return;
            }
            err = TestThReadsPrimary4YAttributeFromDutAndVerifyThatTheDutResponseContainsAnUint16Min0Max0xfeffIfNumberOfPrimariesIs4OrMore_35();
            break;
        case 36:
            ChipLogProgress(chipTool,
                " ***** Test Step 36 : TH reads Primary4Intensity attribute from DUT and Verify that the DUT response contains an "
                "uint8 if NumberOfPrimaries is 4 or more\n");
            if (ShouldSkip("PICS_USER_PROMPT && CC.S.A0022")) {
                NextTest();
                return;
            }
            err = TestThReadsPrimary4IntensityAttributeFromDutAndVerifyThatTheDutResponseContainsAnUint8IfNumberOfPrimariesIs4OrMore_36();
            break;
        case 37:
            ChipLogProgress(chipTool,
                " ***** Test Step 37 : TH reads Primary5X attribute from DUT and Verify that the DUT response contains an uint16 "
                "[Min:0 Max:0xfeff] if NumberOfPrimaries is 5 or more\n");
            if (ShouldSkip("PICS_USER_PROMPT && CC.S.A0024")) {
                NextTest();
                return;
            }
            err = TestThReadsPrimary5XAttributeFromDutAndVerifyThatTheDutResponseContainsAnUint16Min0Max0xfeffIfNumberOfPrimariesIs5OrMore_37();
            break;
        case 38:
            ChipLogProgress(chipTool,
                " ***** Test Step 38 : TH reads Primary5Y attribute from DUT and Verify that the DUT response contains an uint16 "
                "[Min:0 Max:0xfeff] if NumberOfPrimaries is 5 or more\n");
            if (ShouldSkip("PICS_USER_PROMPT && CC.S.A0025")) {
                NextTest();
                return;
            }
            err = TestThReadsPrimary5YAttributeFromDutAndVerifyThatTheDutResponseContainsAnUint16Min0Max0xfeffIfNumberOfPrimariesIs5OrMore_38();
            break;
        case 39:
            ChipLogProgress(chipTool,
                " ***** Test Step 39 : TH reads Primary5Intensity attribute from DUT and Verify that the DUT response contains an "
                "uint8 if NumberOfPrimaries is 5 or more\n");
            if (ShouldSkip("PICS_USER_PROMPT && CC.S.A0026")) {
                NextTest();
                return;
            }
            err = TestThReadsPrimary5IntensityAttributeFromDutAndVerifyThatTheDutResponseContainsAnUint8IfNumberOfPrimariesIs5OrMore_39();
            break;
        case 40:
            ChipLogProgress(chipTool,
                " ***** Test Step 40 : TH reads Primary6X attribute from DUT and Verify that the DUT response contains an uint16 "
                "[Min:0 Max:0xfeff] if NumberOfPrimaries is 6 or more\n");
            if (ShouldSkip("PICS_USER_PROMPT && CC.S.A0028")) {
                NextTest();
                return;
            }
            err = TestThReadsPrimary6XAttributeFromDutAndVerifyThatTheDutResponseContainsAnUint16Min0Max0xfeffIfNumberOfPrimariesIs6OrMore_40();
            break;
        case 41:
            ChipLogProgress(chipTool,
                " ***** Test Step 41 : TH reads Primary6Y attribute from DUT and Verify that the DUT response contains an uint16 "
                "[Min:0 Max:0xfeff] if NumberOfPrimaries is 6 or more\n");
            if (ShouldSkip("PICS_USER_PROMPT && CC.S.A0029")) {
                NextTest();
                return;
            }
            err = TestThReadsPrimary6YAttributeFromDutAndVerifyThatTheDutResponseContainsAnUint16Min0Max0xfeffIfNumberOfPrimariesIs6OrMore_41();
            break;
        case 42:
            ChipLogProgress(chipTool,
                " ***** Test Step 42 : TH reads Primary6Intensity attribute from DUT and Verify that the DUT response contains an "
                "uint8 if NumberOfPrimaries is 6 or more\n");
            if (ShouldSkip("PICS_USER_PROMPT && CC.S.A002a")) {
                NextTest();
                return;
            }
            err = TestThReadsPrimary6IntensityAttributeFromDutAndVerifyThatTheDutResponseContainsAnUint8IfNumberOfPrimariesIs6OrMore_42();
            break;
        case 43:
            ChipLogProgress(chipTool, " ***** Test Step 43 : TH reads WhitePointX attribute from DUT\n");
            if (ShouldSkip("CC.S.A0030")) {
                NextTest();
                return;
            }
            err = TestThReadsWhitePointXAttributeFromDut_43();
            break;
        case 44:
            ChipLogProgress(chipTool, " ***** Test Step 44 : TH reads WhitePointY attribute from DUT\n");
            if (ShouldSkip("CC.S.A0031")) {
                NextTest();
                return;
            }
            err = TestThReadsWhitePointYAttributeFromDut_44();
            break;
        case 45:
            ChipLogProgress(chipTool, " ***** Test Step 45 : TH reads ColorPointRX attribute from DUT\n");
            if (ShouldSkip("CC.S.A0032")) {
                NextTest();
                return;
            }
            err = TestThReadsColorPointRXAttributeFromDut_45();
            break;
        case 46:
            ChipLogProgress(chipTool, " ***** Test Step 46 : TH reads ColorPointRY attribute from DUT\n");
            if (ShouldSkip("CC.S.A0033")) {
                NextTest();
                return;
            }
            err = TestThReadsColorPointRYAttributeFromDut_46();
            break;
        case 47:
            ChipLogProgress(chipTool, " ***** Test Step 47 : TH reads ColorPointRIntensity attribute from DUT\n");
            if (ShouldSkip("CC.S.A0034")) {
                NextTest();
                return;
            }
            err = TestThReadsColorPointRIntensityAttributeFromDut_47();
            break;
        case 48:
            ChipLogProgress(chipTool, " ***** Test Step 48 : TH reads ColorPointGX attribute from DUT\n");
            if (ShouldSkip("CC.S.A0036")) {
                NextTest();
                return;
            }
            err = TestThReadsColorPointGXAttributeFromDut_48();
            break;
        case 49:
            ChipLogProgress(chipTool, " ***** Test Step 49 : TH reads ColorPointGY attribute from DUT\n");
            if (ShouldSkip("CC.S.A0037")) {
                NextTest();
                return;
            }
            err = TestThReadsColorPointGYAttributeFromDut_49();
            break;
        case 50:
            ChipLogProgress(chipTool, " ***** Test Step 50 : TH reads ColorPointGIntensity attribute from DUT\n");
            if (ShouldSkip("CC.S.A0038")) {
                NextTest();
                return;
            }
            err = TestThReadsColorPointGIntensityAttributeFromDut_50();
            break;
        case 51:
            ChipLogProgress(chipTool, " ***** Test Step 51 : TH reads ColorPointBX attribute from DUT\n");
            if (ShouldSkip("CC.S.A003a")) {
                NextTest();
                return;
            }
            err = TestThReadsColorPointBXAttributeFromDut_51();
            break;
        case 52:
            ChipLogProgress(chipTool, " ***** Test Step 52 : TH reads ColorPointBY attribute from DUT\n");
            if (ShouldSkip("CC.S.A003b")) {
                NextTest();
                return;
            }
            err = TestThReadsColorPointBYAttributeFromDut_52();
            break;
        case 53:
            ChipLogProgress(chipTool, " ***** Test Step 53 : TH reads ColorPointBIntensity attribute from DUT\n");
            if (ShouldSkip("CC.S.A003c")) {
                NextTest();
                return;
            }
            err = TestThReadsColorPointBIntensityAttributeFromDut_53();
            break;
        }

        if (CHIP_NO_ERROR != err) {
            ChipLogError(chipTool, " ***** Test Failure: %s\n", chip::ErrorStr(err));
            SetCommandExitStatus(err);
        }
    }

    void OnStatusUpdate(const chip::app::StatusIB & status) override
    {
        switch (mTestIndex - 1) {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 6:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 7:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 8:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 9:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 10:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 11:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 12:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 13:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 14:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 15:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 16:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 17:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 18:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 19:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 20:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 21:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 22:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 23:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 24:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 25:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 26:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 27:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 28:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 29:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 30:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 31:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 32:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 33:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 34:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 35:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 36:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 37:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 38:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 39:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 40:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 41:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 42:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 43:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 44:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 45:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 46:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 47:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 48:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 49:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 50:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 51:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 52:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 53:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        }

        // Go on to the next test.
        ContinueOnChipMainThread(CHIP_NO_ERROR);
    }

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    std::atomic_uint16_t mTestIndex;
    const uint16_t mTestCount = 54;

    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    CHIP_ERROR TestWaitForTheCommissionedDeviceToBeRetrieved_0()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
        value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
        return WaitForCommissionee("alpha", value);
    }

    CHIP_ERROR TestThReadsCurrentHueAttributeFromDut_1()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentHueWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentHue attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("currentHue", "int8u", "int8u"));
            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("currentHue", [value unsignedCharValue], 0U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("currentHue", [value unsignedCharValue], 254U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsCurrentSaturationAttributeFromDut_2()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentSaturationWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentSaturation attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("currentSaturation", "int8u", "int8u"));
            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("currentSaturation", [value unsignedCharValue], 0U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("currentSaturation", [value unsignedCharValue], 254U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsRemainingTimeAttributeFromDut_3()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeRemainingTimeWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads RemainingTime attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("remainingTime", "int16u", "int16u"));
            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("remainingTime", [value unsignedShortValue], 0U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("remainingTime", [value unsignedShortValue], 65534U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsCurrentXAttributeFromDut_4()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentXWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentX attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("currentX", "int16u", "int16u"));
            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("currentX", [value unsignedShortValue], 0U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("currentX", [value unsignedShortValue], 65279U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsCurrentYAttributeFromDut_5()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentYWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentY attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("currentY", "int16u", "int16u"));
            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("currentY", [value unsignedShortValue], 0U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("currentY", [value unsignedShortValue], 65279U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsDriftCompensationAttributeFromDut_6()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeDriftCompensationWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads DriftCompensation attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("driftCompensation", "enum8", "enum8"));
            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("driftCompensation", [value unsignedCharValue], 0U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("driftCompensation", [value unsignedCharValue], 4U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsCompensationTextAttributeFromDut_7()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCompensationTextWithCompletion:^(NSString * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CompensationText attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("compensationText", "char_string", "char_string"));
            VerifyOrReturn(CheckConstraintMaxLength("compensationText", value, 254));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsColorTemperatureMiredsAttributeFromDut_8()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeColorTemperatureMiredsWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads ColorTemperatureMireds attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("colorTemperatureMireds", "int16u", "int16u"));
            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("colorTemperatureMireds", [value unsignedShortValue], 0U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("colorTemperatureMireds", [value unsignedShortValue], 65279U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsColorModeAttributeFromDut_9()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeColorModeWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads ColorMode attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("colorMode", "enum8", "enum8"));
            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("colorMode", [value unsignedCharValue], 0U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("colorMode", [value unsignedCharValue], 2U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsOptionsAttributeFromDut_10()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeOptionsWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads Options attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("options", "bitmap8", "bitmap8"));
            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("options", [value unsignedCharValue], 0U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("options", [value unsignedCharValue], 4U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsEnhancedCurrentHueAttributeFromDut_11()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeEnhancedCurrentHueWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads EnhancedCurrentHue attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("enhancedCurrentHue", "int16u", "int16u"));
            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("enhancedCurrentHue", [value unsignedShortValue], 0U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("enhancedCurrentHue", [value unsignedShortValue], 65535U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsEnhancedColorModeAttributeFromDut_12()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeEnhancedColorModeWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads EnhancedColorMode attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("enhancedColorMode", "enum8", "enum8"));
            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("enhancedColorMode", [value unsignedCharValue], 0U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("enhancedColorMode", [value unsignedCharValue], 3U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsColorLoopActiveAttributeFromDut_13()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeColorLoopActiveWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads ColorLoopActive attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("colorLoopActive", "int8u", "int8u"));
            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("colorLoopActive", [value unsignedCharValue], 0U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("colorLoopActive", [value unsignedCharValue], 254U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsColorLoopDirectionAttributeFromDut_14()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeColorLoopDirectionWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads ColorLoopDirection attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("colorLoopDirection", "int8u", "int8u"));
            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("colorLoopDirection", [value unsignedCharValue], 0U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("colorLoopDirection", [value unsignedCharValue], 254U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsColorLoopTimeAttributeFromDut_15()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeColorLoopTimeWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads ColorLoopTime attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("colorLoopTime", "int16u", "int16u"));
            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("colorLoopTime", [value unsignedShortValue], 0U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("colorLoopTime", [value unsignedShortValue], 65534U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsColorLoopStartEnhancedHueAttributeFromDut_16()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeColorLoopStartEnhancedHueWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads ColorLoopStartEnhancedHue attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("colorLoopStartEnhancedHue", "int16u", "int16u"));
            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("colorLoopStartEnhancedHue", [value unsignedShortValue], 0U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("colorLoopStartEnhancedHue", [value unsignedShortValue], 65535U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsColorLoopStoredEnhancedHueAttributeFromDut_17()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeColorLoopStoredEnhancedHueWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads ColorLoopStoredEnhancedHue attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("colorLoopStoredEnhancedHue", "int16u", "int16u"));
            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("colorLoopStoredEnhancedHue", [value unsignedShortValue], 0U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("colorLoopStoredEnhancedHue", [value unsignedShortValue], 65535U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }
    NSNumber * _Nonnull FeatureMapValue;

    CHIP_ERROR TestSavingForComparisionInStep19ReadsFeatureMapAttributeFromDut_18()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeFeatureMapWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Saving for comparision in step 19 reads FeatureMap attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                FeatureMapValue = value;
            }

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsColorCapabilitiesAttributeFromDut_19()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeColorCapabilitiesWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads ColorCapabilities attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("ColorCapabilities", actualValue, FeatureMapValue));
            }

            VerifyOrReturn(CheckConstraintType("colorCapabilities", "bitmap16", "bitmap16"));
            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("colorCapabilities", [value unsignedShortValue], 0U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("colorCapabilities", [value unsignedShortValue], 31U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsColorTempPhysicalMinMiredsAttributeFromDut_20()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeColorTempPhysicalMinMiredsWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads ColorTempPhysicalMinMireds attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("colorTempPhysicalMinMireds", "int16u", "int16u"));
            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("colorTempPhysicalMinMireds", [value unsignedShortValue], 0U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("colorTempPhysicalMinMireds", [value unsignedShortValue], 65279U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsColorTempPhysicalMaxMiredsAttributeFromDut_21()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeColorTempPhysicalMaxMiredsWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads ColorTempPhysicalMaxMireds attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("colorTempPhysicalMaxMireds", "int16u", "int16u"));
            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("colorTempPhysicalMaxMireds", [value unsignedShortValue], 0U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("colorTempPhysicalMaxMireds", [value unsignedShortValue], 65279U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsCoupleColorTempToLevelMinMiredsAttributeFromDut_22()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCoupleColorTempToLevelMinMiredsWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CoupleColorTempToLevelMinMireds attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("coupleColorTempToLevelMinMireds", "int16u", "int16u"));
            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("coupleColorTempToLevelMinMireds", [value unsignedShortValue], 0U));
            VerifyOrReturn(
                CheckConstraintMaxValue<uint16_t>("coupleColorTempToLevelMinMireds", [value unsignedShortValue], 65279U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsStartUpColorTemperatureMiredsAttributeFromDut_23()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeStartUpColorTemperatureMiredsWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads StartUpColorTemperatureMireds attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            if (value != nil) {

                VerifyOrReturn(CheckConstraintType("startUpColorTemperatureMireds", "int16u", "int16u"));
                VerifyOrReturn(CheckConstraintMinValue<uint16_t>("startUpColorTemperatureMireds", [value unsignedShortValue], 0U));
                VerifyOrReturn(
                    CheckConstraintMaxValue<uint16_t>("startUpColorTemperatureMireds", [value unsignedShortValue], 65279U));
            }

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsNumberOfPrimariesAttributeFromDut_24()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeNumberOfPrimariesWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads NumberOfPrimaries attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            if (value != nil) {

                VerifyOrReturn(CheckConstraintType("numberOfPrimaries", "int8u", "int8u"));
                VerifyOrReturn(CheckConstraintMinValue<uint8_t>("numberOfPrimaries", [value unsignedCharValue], 0U));
                VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("numberOfPrimaries", [value unsignedCharValue], 6U));
            }

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR
    TestThReadsPrimary1XAttributeFromDutAndVerifyThatTheDutResponseContainsAnUint16Min0Max0xfeffIfNumberOfPrimariesIs1OrMore_25()
    {

        chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
        value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
        value.expectedValue.Emplace();
        value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
        return UserPrompt("alpha", value);
    }

    CHIP_ERROR
    TestThReadsPrimary1YAttributeFromDutAndVerifyThatTheDutResponseContainsAnUint16Min0Max0xfeffIfNumberOfPrimariesIs1OrMore_26()
    {

        chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
        value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
        value.expectedValue.Emplace();
        value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
        return UserPrompt("alpha", value);
    }

    CHIP_ERROR
    TestThReadsPrimary1IntensityAttributeFromDutAndVerifyThatTheDutResponseContainsAnUint8IfNumberOfPrimariesIs1OrMore_27()
    {

        chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
        value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
        value.expectedValue.Emplace();
        value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
        return UserPrompt("alpha", value);
    }

    CHIP_ERROR
    TestThReadsPrimary2XAttributeFromDutAndVerifyThatTheDutResponseContainsAnUint16Min0Max0xfeffIfNumberOfPrimariesIs2OrMore_28()
    {

        chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
        value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
        value.expectedValue.Emplace();
        value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
        return UserPrompt("alpha", value);
    }

    CHIP_ERROR
    TestThReadsPrimary2YAttributeFromDutAndVerifyThatTheDutResponseContainsAnUint16Min0Max0xfeffIfNumberOfPrimariesIs2OrMore_29()
    {

        chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
        value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
        value.expectedValue.Emplace();
        value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
        return UserPrompt("alpha", value);
    }

    CHIP_ERROR
    TestThReadsPrimary2IntensityAttributeFromDutAndVerifyThatTheDutResponseContainsAnUint8IfNumberOfPrimariesIs2OrMore_30()
    {

        chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
        value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
        value.expectedValue.Emplace();
        value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
        return UserPrompt("alpha", value);
    }

    CHIP_ERROR
    TestThReadsPrimary3XAttributeFromDutAndVerifyThatTheDutResponseContainsAnUint16Min0Max0xfeffIfNumberOfPrimariesIs3OrMore_31()
    {

        chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
        value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
        value.expectedValue.Emplace();
        value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
        return UserPrompt("alpha", value);
    }

    CHIP_ERROR
    TestThReadsPrimary3YAttributeFromDutAndVerifyThatTheDutResponseContainsAnUint16Min0Max0xfeffIfNumberOfPrimariesIs3OrMore_32()
    {

        chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
        value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
        value.expectedValue.Emplace();
        value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
        return UserPrompt("alpha", value);
    }

    CHIP_ERROR
    TestThReadsPrimary3IntensityAttributeFromDutAndVerifyThatTheDutResponseContainsAnUint8IfNumberOfPrimariesIs3OrMore_33()
    {

        chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
        value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
        value.expectedValue.Emplace();
        value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
        return UserPrompt("alpha", value);
    }

    CHIP_ERROR
    TestThReadsPrimary4XAttributeFromDutVerifyThatTheDutResponseContainsAnUint16Min0Max0xfeffIfNumberOfPrimariesIs4OrMore_34()
    {

        chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
        value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
        value.expectedValue.Emplace();
        value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
        return UserPrompt("alpha", value);
    }

    CHIP_ERROR
    TestThReadsPrimary4YAttributeFromDutAndVerifyThatTheDutResponseContainsAnUint16Min0Max0xfeffIfNumberOfPrimariesIs4OrMore_35()
    {

        chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
        value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
        value.expectedValue.Emplace();
        value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
        return UserPrompt("alpha", value);
    }

    CHIP_ERROR
    TestThReadsPrimary4IntensityAttributeFromDutAndVerifyThatTheDutResponseContainsAnUint8IfNumberOfPrimariesIs4OrMore_36()
    {

        chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
        value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
        value.expectedValue.Emplace();
        value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
        return UserPrompt("alpha", value);
    }

    CHIP_ERROR
    TestThReadsPrimary5XAttributeFromDutAndVerifyThatTheDutResponseContainsAnUint16Min0Max0xfeffIfNumberOfPrimariesIs5OrMore_37()
    {

        chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
        value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
        value.expectedValue.Emplace();
        value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
        return UserPrompt("alpha", value);
    }

    CHIP_ERROR
    TestThReadsPrimary5YAttributeFromDutAndVerifyThatTheDutResponseContainsAnUint16Min0Max0xfeffIfNumberOfPrimariesIs5OrMore_38()
    {

        chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
        value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
        value.expectedValue.Emplace();
        value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
        return UserPrompt("alpha", value);
    }

    CHIP_ERROR
    TestThReadsPrimary5IntensityAttributeFromDutAndVerifyThatTheDutResponseContainsAnUint8IfNumberOfPrimariesIs5OrMore_39()
    {

        chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
        value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
        value.expectedValue.Emplace();
        value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
        return UserPrompt("alpha", value);
    }

    CHIP_ERROR
    TestThReadsPrimary6XAttributeFromDutAndVerifyThatTheDutResponseContainsAnUint16Min0Max0xfeffIfNumberOfPrimariesIs6OrMore_40()
    {

        chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
        value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
        value.expectedValue.Emplace();
        value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
        return UserPrompt("alpha", value);
    }

    CHIP_ERROR
    TestThReadsPrimary6YAttributeFromDutAndVerifyThatTheDutResponseContainsAnUint16Min0Max0xfeffIfNumberOfPrimariesIs6OrMore_41()
    {

        chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
        value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
        value.expectedValue.Emplace();
        value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
        return UserPrompt("alpha", value);
    }

    CHIP_ERROR
    TestThReadsPrimary6IntensityAttributeFromDutAndVerifyThatTheDutResponseContainsAnUint8IfNumberOfPrimariesIs6OrMore_42()
    {

        chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
        value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
        value.expectedValue.Emplace();
        value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
        return UserPrompt("alpha", value);
    }

    CHIP_ERROR TestThReadsWhitePointXAttributeFromDut_43()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeWhitePointXWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads WhitePointX attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("whitePointX", "int16u", "int16u"));
            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("whitePointX", [value unsignedShortValue], 0U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("whitePointX", [value unsignedShortValue], 65279U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsWhitePointYAttributeFromDut_44()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeWhitePointYWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads WhitePointY attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("whitePointY", "int16u", "int16u"));
            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("whitePointY", [value unsignedShortValue], 0U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("whitePointY", [value unsignedShortValue], 65279U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsColorPointRXAttributeFromDut_45()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeColorPointRXWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads ColorPointRX attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("colorPointRX", "int16u", "int16u"));
            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("colorPointRX", [value unsignedShortValue], 0U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("colorPointRX", [value unsignedShortValue], 65279U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsColorPointRYAttributeFromDut_46()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeColorPointRYWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads ColorPointRY attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("colorPointRY", "int16u", "int16u"));
            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("colorPointRY", [value unsignedShortValue], 0U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("colorPointRY", [value unsignedShortValue], 65279U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsColorPointRIntensityAttributeFromDut_47()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeColorPointRIntensityWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads ColorPointRIntensity attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            if (value != nil) {

                VerifyOrReturn(CheckConstraintType("colorPointRIntensity", "int8u", "int8u"));
                VerifyOrReturn(CheckConstraintMinValue<uint8_t>("colorPointRIntensity", [value unsignedCharValue], 0U));
                VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("colorPointRIntensity", [value unsignedCharValue], 255U));
            }

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsColorPointGXAttributeFromDut_48()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeColorPointGXWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads ColorPointGX attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("colorPointGX", "int16u", "int16u"));
            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("colorPointGX", [value unsignedShortValue], 0U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("colorPointGX", [value unsignedShortValue], 65279U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsColorPointGYAttributeFromDut_49()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeColorPointGYWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads ColorPointGY attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("colorPointGY", "int16u", "int16u"));
            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("colorPointGY", [value unsignedShortValue], 0U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("colorPointGY", [value unsignedShortValue], 65279U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsColorPointGIntensityAttributeFromDut_50()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeColorPointGIntensityWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads ColorPointGIntensity attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            if (value != nil) {

                VerifyOrReturn(CheckConstraintType("colorPointGIntensity", "int8u", "int8u"));
                VerifyOrReturn(CheckConstraintMinValue<uint8_t>("colorPointGIntensity", [value unsignedCharValue], 0U));
                VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("colorPointGIntensity", [value unsignedCharValue], 255U));
            }

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsColorPointBXAttributeFromDut_51()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeColorPointBXWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads ColorPointBX attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("colorPointBX", "int16u", "int16u"));
            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("colorPointBX", [value unsignedShortValue], 0U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("colorPointBX", [value unsignedShortValue], 65279U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsColorPointBYAttributeFromDut_52()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeColorPointBYWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads ColorPointBY attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("colorPointBY", "int16u", "int16u"));
            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("colorPointBY", [value unsignedShortValue], 0U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("colorPointBY", [value unsignedShortValue], 65279U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsColorPointBIntensityAttributeFromDut_53()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeColorPointBIntensityWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads ColorPointBIntensity attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            if (value != nil) {

                VerifyOrReturn(CheckConstraintType("colorPointBIntensity", "int8u", "int8u"));
                VerifyOrReturn(CheckConstraintMinValue<uint8_t>("colorPointBIntensity", [value unsignedCharValue], 0U));
                VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("colorPointBIntensity", [value unsignedCharValue], 255U));
            }

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }
};

class Test_TC_CC_3_2 : public TestCommandBridge {
public:
    // NOLINTBEGIN(clang-analyzer-nullability.NullPassedToNonnull): Test constructor nullability not enforced
    Test_TC_CC_3_2()
        : TestCommandBridge("Test_TC_CC_3_2")
        , mTestIndex(0)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }
    // NOLINTEND(clang-analyzer-nullability.NullPassedToNonnull)

    ~Test_TC_CC_3_2() {}

    /////////// TestCommand Interface /////////
    void NextTest() override
    {
        CHIP_ERROR err = CHIP_NO_ERROR;

        if (0 == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Start: Test_TC_CC_3_2\n");
        }

        if (mTestCount == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Complete: Test_TC_CC_3_2\n");
            SetCommandExitStatus(CHIP_NO_ERROR);
            return;
        }

        Wait();

        // Ensure we increment mTestIndex before we start running the relevant
        // command.  That way if we lose the timeslice after we send the message
        // but before our function call returns, we won't end up with an
        // incorrect mTestIndex value observed when we get the response.
        switch (mTestIndex++) {
        case 0:
            ChipLogProgress(chipTool, " ***** Test Step 0 : Wait for the commissioned device to be retrieved\n");
            err = TestWaitForTheCommissionedDeviceToBeRetrieved_0();
            break;
        case 1:
            ChipLogProgress(chipTool, " ***** Test Step 1 : TH writes 0 to the Options attribute\n");
            if (ShouldSkip("CC.S.F00 && CC.S.A000f")) {
                NextTest();
                return;
            }
            err = TestThWrites0ToTheOptionsAttribute_1();
            break;
        case 2:
            ChipLogProgress(chipTool, " ***** Test Step 2 : TH sends On command to DUT\n");
            if (ShouldSkip("OO.S.C01.Rsp")) {
                NextTest();
                return;
            }
            err = TestThSendsOnCommandToDut_2();
            break;
        case 3:
            ChipLogProgress(chipTool,
                " ***** Test Step 3 : TH sends MoveToHue command to DUT with Hue=200, Direction=0x00 (shortest distance) and "
                "TransitionTime=0 (immediately)\n");
            if (ShouldSkip("CC.S.F00 && CC.S.C00.Rsp")) {
                NextTest();
                return;
            }
            err = TestThSendsMoveToHueCommandToDutWithHue200Direction0x00ShortestDistanceAndTransitionTime0Immediately_3();
            break;
        case 4:
            ChipLogProgress(chipTool, " ***** Test Step 4 : Wait 100ms\n");
            err = TestWait100ms_4();
            break;
        case 5:
            ChipLogProgress(
                chipTool, " ***** Test Step 5 : TH sends MoveHue command to DUT with MoveMode=0x01 (up) and Rate=5 (units/s)\n");
            if (ShouldSkip("CC.S.F00 && CC.S.C01.Rsp")) {
                NextTest();
                return;
            }
            err = TestThSendsMoveHueCommandToDutWithMoveMode0x01UpAndRate5UnitsS_5();
            break;
        case 6:
            ChipLogProgress(chipTool, " ***** Test Step 6 : Wait 10s\n");
            err = TestWait10s_6();
            break;
        case 7:
            ChipLogProgress(chipTool, " ***** Test Step 7 : TH reads CurrentHue attribute from DUT\n");
            if (ShouldSkip("CC.S.F00 && CC.S.A0000")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentHueAttributeFromDut_7();
            break;
        case 8:
            ChipLogProgress(chipTool, " ***** Test Step 8 : Wait 10s\n");
            err = TestWait10s_8();
            break;
        case 9:
            ChipLogProgress(chipTool, " ***** Test Step 9 : TH reads CurrentHue attribute from DUT\n");
            if (ShouldSkip("CC.S.F00 && CC.S.A0000")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentHueAttributeFromDut_9();
            break;
        case 10:
            ChipLogProgress(chipTool, " ***** Test Step 10 : Wait 10s\n");
            err = TestWait10s_10();
            break;
        case 11:
            ChipLogProgress(
                chipTool, " ***** Test Step 11 : TH sends MoveHue command to DUT with MoveMode=0x00 (stop) and Rate=5 (units/s)\n");
            if (ShouldSkip("CC.S.F00 && CC.S.C01.Rsp")) {
                NextTest();
                return;
            }
            err = TestThSendsMoveHueCommandToDutWithMoveMode0x00StopAndRate5UnitsS_11();
            break;
        case 12:
            ChipLogProgress(chipTool, " ***** Test Step 12 : TH reads CurrentHue attribute from DUT\n");
            if (ShouldSkip("CC.S.F00 && CC.S.A0000")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentHueAttributeFromDut_12();
            break;
        case 13:
            ChipLogProgress(chipTool, " ***** Test Step 13 : Wait 2s\n");
            err = TestWait2s_13();
            break;
        case 14:
            ChipLogProgress(chipTool, " ***** Test Step 14 : TH reads CurrentHue attribute from DUT\n");
            if (ShouldSkip("CC.S.F00 && CC.S.A0000")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentHueAttributeFromDut_14();
            break;
        case 15:
            ChipLogProgress(chipTool,
                " ***** Test Step 15 : TH sends MoveToHue command to DUT with Hue=60, Direction=0x00 (shortest distance) and "
                "TransitionTime=0 (immediately)\n");
            if (ShouldSkip("CC.S.F00 && CC.S.C00.Rsp")) {
                NextTest();
                return;
            }
            err = TestThSendsMoveToHueCommandToDutWithHue60Direction0x00ShortestDistanceAndTransitionTime0Immediately_15();
            break;
        case 16:
            ChipLogProgress(chipTool, " ***** Test Step 16 : Wait 100ms\n");
            err = TestWait100ms_16();
            break;
        case 17:
            ChipLogProgress(
                chipTool, " ***** Test Step 17 : TH sends MoveHue command to DUT with MoveMode=0x03 (down) and Rate=5 (units/s)\n");
            if (ShouldSkip("CC.S.F00 && CC.S.C01.Rsp")) {
                NextTest();
                return;
            }
            err = TestThSendsMoveHueCommandToDutWithMoveMode0x03DownAndRate5UnitsS_17();
            break;
        case 18:
            ChipLogProgress(chipTool, " ***** Test Step 18 : Wait 10s\n");
            err = TestWait10s_18();
            break;
        case 19:
            ChipLogProgress(chipTool, " ***** Test Step 19 : TH reads CurrentHue attribute from DUT\n");
            if (ShouldSkip("CC.S.F00 && CC.S.A0000")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentHueAttributeFromDut_19();
            break;
        case 20:
            ChipLogProgress(chipTool, " ***** Test Step 20 : Wait 10s\n");
            err = TestWait10s_20();
            break;
        case 21:
            ChipLogProgress(chipTool, " ***** Test Step 21 : TH reads CurrentHue attribute from DUT\n");
            if (ShouldSkip("CC.S.F00 && CC.S.A0000")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentHueAttributeFromDut_21();
            break;
        case 22:
            ChipLogProgress(chipTool, " ***** Test Step 22 : Wait 10s\n");
            err = TestWait10s_22();
            break;
        case 23:
            ChipLogProgress(
                chipTool, " ***** Test Step 23 : TH sends MoveHue command to DUT with MoveMode=0x00 (stop) and Rate=5 (units/s)\n");
            if (ShouldSkip("CC.S.F00 && CC.S.C01.Rsp")) {
                NextTest();
                return;
            }
            err = TestThSendsMoveHueCommandToDutWithMoveMode0x00StopAndRate5UnitsS_23();
            break;
        case 24:
            ChipLogProgress(chipTool, " ***** Test Step 24 : TH reads CurrentHue attribute from DUT\n");
            if (ShouldSkip("CC.S.F00 && CC.S.A0000")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentHueAttributeFromDut_24();
            break;
        case 25:
            ChipLogProgress(chipTool, " ***** Test Step 25 : Wait 2s\n");
            err = TestWait2s_25();
            break;
        case 26:
            ChipLogProgress(chipTool, " ***** Test Step 26 : TH reads CurrentHue attribute from DUT\n");
            if (ShouldSkip("CC.S.F00 && CC.S.A0000")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentHueAttributeFromDut_26();
            break;
        case 27:
            ChipLogProgress(chipTool, " ***** Test Step 27 : TH reads ColorMode attribute from DUT\n");
            if (ShouldSkip("CC.S.F00 && CC.S.A0008")) {
                NextTest();
                return;
            }
            err = TestThReadsColorModeAttributeFromDut_27();
            break;
        case 28:
            ChipLogProgress(chipTool, " ***** Test Step 28 : TH reads EnhancedColorMode attribute from DUT\n");
            if (ShouldSkip("CC.S.F00 && CC.S.A4001")) {
                NextTest();
                return;
            }
            err = TestThReadsEnhancedColorModeAttributeFromDut_28();
            break;
        case 29:
            ChipLogProgress(chipTool, " ***** Test Step 29 : Turn off light that we turned on\n");
            if (ShouldSkip("OO.S.C00.Rsp")) {
                NextTest();
                return;
            }
            err = TestTurnOffLightThatWeTurnedOn_29();
            break;
        case 30:
            ChipLogProgress(chipTool, " ***** Test Step 30 : Check on/off attribute value is false after off command\n");
            if (ShouldSkip("OO.S.A0000")) {
                NextTest();
                return;
            }
            err = TestCheckOnOffAttributeValueIsFalseAfterOffCommand_30();
            break;
        }

        if (CHIP_NO_ERROR != err) {
            ChipLogError(chipTool, " ***** Test Failure: %s\n", chip::ErrorStr(err));
            SetCommandExitStatus(err);
        }
    }

    void OnStatusUpdate(const chip::app::StatusIB & status) override
    {
        switch (mTestIndex - 1) {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 6:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 7:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 8:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 9:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 10:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 11:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 12:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 13:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 14:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 15:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 16:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 17:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 18:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 19:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 20:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 21:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 22:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 23:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 24:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 25:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 26:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 27:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 28:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 29:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 30:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        }

        // Go on to the next test.
        ContinueOnChipMainThread(CHIP_NO_ERROR);
    }

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    std::atomic_uint16_t mTestIndex;
    const uint16_t mTestCount = 31;

    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    CHIP_ERROR TestWaitForTheCommissionedDeviceToBeRetrieved_0()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
        value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
        return WaitForCommissionee("alpha", value);
    }

    CHIP_ERROR TestThWrites0ToTheOptionsAttribute_1()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        id optionsArgument;
        optionsArgument = [NSNumber numberWithUnsignedChar:0U];
        [cluster writeAttributeOptionsWithValue:optionsArgument
                                     completion:^(NSError * _Nullable err) {
                                         NSLog(@"TH writes 0 to the Options attribute Error: %@", err);

                                         VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                                         NextTest();
                                     }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThSendsOnCommandToDut_2()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterOnOff alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster onWithCompletion:^(NSError * _Nullable err) {
            NSLog(@"TH sends On command to DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThSendsMoveToHueCommandToDutWithHue200Direction0x00ShortestDistanceAndTransitionTime0Immediately_3()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        __auto_type * params = [[MTRColorControlClusterMoveToHueParams alloc] init];
        params.hue = [NSNumber numberWithUnsignedChar:200U];
        params.direction = [NSNumber numberWithUnsignedChar:0U];
        params.transitionTime = [NSNumber numberWithUnsignedShort:0U];
        params.optionsMask = [NSNumber numberWithUnsignedChar:0U];
        params.optionsOverride = [NSNumber numberWithUnsignedChar:0U];
        [cluster moveToHueWithParams:params
                          completion:^(NSError * _Nullable err) {
                              NSLog(@"TH sends MoveToHue command to DUT with Hue=200, Direction=0x00 (shortest distance) and "
                                    @"TransitionTime=0 (immediately) Error: %@",
                                  err);

                              VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                              NextTest();
                          }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait100ms_4()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 100UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThSendsMoveHueCommandToDutWithMoveMode0x01UpAndRate5UnitsS_5()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        __auto_type * params = [[MTRColorControlClusterMoveHueParams alloc] init];
        params.moveMode = [NSNumber numberWithUnsignedChar:1U];
        params.rate = [NSNumber numberWithUnsignedChar:5U];
        params.optionsMask = [NSNumber numberWithUnsignedChar:0U];
        params.optionsOverride = [NSNumber numberWithUnsignedChar:0U];
        [cluster moveHueWithParams:params
                        completion:^(NSError * _Nullable err) {
                            NSLog(@"TH sends MoveHue command to DUT with MoveMode=0x01 (up) and Rate=5 (units/s) Error: %@", err);

                            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                            NextTest();
                        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait10s_6()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 10000UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThReadsCurrentHueAttributeFromDut_7()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentHueWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentHue attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("currentHue", [value unsignedCharValue], 215U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("currentHue", [value unsignedCharValue], 255U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait10s_8()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 10000UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThReadsCurrentHueAttributeFromDut_9()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentHueWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentHue attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("currentHue", [value unsignedCharValue], 38U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("currentHue", [value unsignedCharValue], 52U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait10s_10()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 10000UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThSendsMoveHueCommandToDutWithMoveMode0x00StopAndRate5UnitsS_11()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        __auto_type * params = [[MTRColorControlClusterMoveHueParams alloc] init];
        params.moveMode = [NSNumber numberWithUnsignedChar:0U];
        params.rate = [NSNumber numberWithUnsignedChar:5U];
        params.optionsMask = [NSNumber numberWithUnsignedChar:0U];
        params.optionsOverride = [NSNumber numberWithUnsignedChar:0U];
        [cluster moveHueWithParams:params
                        completion:^(NSError * _Nullable err) {
                            NSLog(@"TH sends MoveHue command to DUT with MoveMode=0x00 (stop) and Rate=5 (units/s) Error: %@", err);

                            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                            NextTest();
                        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsCurrentHueAttributeFromDut_12()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentHueWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentHue attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("currentHue", [value unsignedCharValue], 80U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("currentHue", [value unsignedCharValue], 110U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait2s_13()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 2000UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThReadsCurrentHueAttributeFromDut_14()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentHueWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentHue attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("currentHue", [value unsignedCharValue], 80U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("currentHue", [value unsignedCharValue], 110U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThSendsMoveToHueCommandToDutWithHue60Direction0x00ShortestDistanceAndTransitionTime0Immediately_15()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        __auto_type * params = [[MTRColorControlClusterMoveToHueParams alloc] init];
        params.hue = [NSNumber numberWithUnsignedChar:60U];
        params.direction = [NSNumber numberWithUnsignedChar:0U];
        params.transitionTime = [NSNumber numberWithUnsignedShort:0U];
        params.optionsMask = [NSNumber numberWithUnsignedChar:0U];
        params.optionsOverride = [NSNumber numberWithUnsignedChar:0U];
        [cluster moveToHueWithParams:params
                          completion:^(NSError * _Nullable err) {
                              NSLog(@"TH sends MoveToHue command to DUT with Hue=60, Direction=0x00 (shortest distance) and "
                                    @"TransitionTime=0 (immediately) Error: %@",
                                  err);

                              VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                              NextTest();
                          }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait100ms_16()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 100UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThSendsMoveHueCommandToDutWithMoveMode0x03DownAndRate5UnitsS_17()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        __auto_type * params = [[MTRColorControlClusterMoveHueParams alloc] init];
        params.moveMode = [NSNumber numberWithUnsignedChar:3U];
        params.rate = [NSNumber numberWithUnsignedChar:5U];
        params.optionsMask = [NSNumber numberWithUnsignedChar:0U];
        params.optionsOverride = [NSNumber numberWithUnsignedChar:0U];
        [cluster moveHueWithParams:params
                        completion:^(NSError * _Nullable err) {
                            NSLog(@"TH sends MoveHue command to DUT with MoveMode=0x03 (down) and Rate=5 (units/s) Error: %@", err);

                            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                            NextTest();
                        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait10s_18()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 10000UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThReadsCurrentHueAttributeFromDut_19()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentHueWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentHue attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("currentHue", [value unsignedCharValue], 8U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("currentHue", [value unsignedCharValue], 12U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait10s_20()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 10000UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThReadsCurrentHueAttributeFromDut_21()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentHueWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentHue attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("currentHue", [value unsignedCharValue], 183U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("currentHue", [value unsignedCharValue], 247U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait10s_22()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 10000UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThSendsMoveHueCommandToDutWithMoveMode0x00StopAndRate5UnitsS_23()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        __auto_type * params = [[MTRColorControlClusterMoveHueParams alloc] init];
        params.moveMode = [NSNumber numberWithUnsignedChar:0U];
        params.rate = [NSNumber numberWithUnsignedChar:5U];
        params.optionsMask = [NSNumber numberWithUnsignedChar:0U];
        params.optionsOverride = [NSNumber numberWithUnsignedChar:0U];
        [cluster moveHueWithParams:params
                        completion:^(NSError * _Nullable err) {
                            NSLog(@"TH sends MoveHue command to DUT with MoveMode=0x00 (stop) and Rate=5 (units/s) Error: %@", err);

                            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                            NextTest();
                        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsCurrentHueAttributeFromDut_24()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentHueWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentHue attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("currentHue", [value unsignedCharValue], 140U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("currentHue", [value unsignedCharValue], 190U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait2s_25()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 2000UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThReadsCurrentHueAttributeFromDut_26()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentHueWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentHue attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("currentHue", [value unsignedCharValue], 140U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("currentHue", [value unsignedCharValue], 190U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsColorModeAttributeFromDut_27()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeColorModeWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads ColorMode attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("ColorMode", actualValue, 0U));
            }

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("colorMode", [value unsignedCharValue], 0U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("colorMode", [value unsignedCharValue], 2U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsEnhancedColorModeAttributeFromDut_28()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeEnhancedColorModeWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads EnhancedColorMode attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("EnhancedColorMode", actualValue, 0U));
            }

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("enhancedColorMode", [value unsignedCharValue], 0U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("enhancedColorMode", [value unsignedCharValue], 3U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestTurnOffLightThatWeTurnedOn_29()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterOnOff alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster offWithCompletion:^(NSError * _Nullable err) {
            NSLog(@"Turn off light that we turned on Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestCheckOnOffAttributeValueIsFalseAfterOffCommand_30()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterOnOff alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeOnOffWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Check on/off attribute value is false after off command Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("OnOff", actualValue, 0));
            }

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }
};

class Test_TC_CC_3_3 : public TestCommandBridge {
public:
    // NOLINTBEGIN(clang-analyzer-nullability.NullPassedToNonnull): Test constructor nullability not enforced
    Test_TC_CC_3_3()
        : TestCommandBridge("Test_TC_CC_3_3")
        , mTestIndex(0)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }
    // NOLINTEND(clang-analyzer-nullability.NullPassedToNonnull)

    ~Test_TC_CC_3_3() {}

    /////////// TestCommand Interface /////////
    void NextTest() override
    {
        CHIP_ERROR err = CHIP_NO_ERROR;

        if (0 == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Start: Test_TC_CC_3_3\n");
        }

        if (mTestCount == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Complete: Test_TC_CC_3_3\n");
            SetCommandExitStatus(CHIP_NO_ERROR);
            return;
        }

        Wait();

        // Ensure we increment mTestIndex before we start running the relevant
        // command.  That way if we lose the timeslice after we send the message
        // but before our function call returns, we won't end up with an
        // incorrect mTestIndex value observed when we get the response.
        switch (mTestIndex++) {
        case 0:
            ChipLogProgress(chipTool, " ***** Test Step 0 : Wait for the commissioned device to be retrieved\n");
            err = TestWaitForTheCommissionedDeviceToBeRetrieved_0();
            break;
        case 1:
            ChipLogProgress(chipTool, " ***** Test Step 1 : TH writes 0 to the Options attribute\n");
            if (ShouldSkip("CC.S.F00 && CC.S.A000f")) {
                NextTest();
                return;
            }
            err = TestThWrites0ToTheOptionsAttribute_1();
            break;
        case 2:
            ChipLogProgress(chipTool, " ***** Test Step 2 : TH sends On command to DUT\n");
            if (ShouldSkip("OO.S.C01.Rsp")) {
                NextTest();
                return;
            }
            err = TestThSendsOnCommandToDut_2();
            break;
        case 3:
            ChipLogProgress(chipTool,
                " ***** Test Step 3 : TH sends MoveToHue command to DUT with Hue=200, Direction=0x00 (shortest distance) and "
                "TransitionTime=0 (immediately)\n");
            if (ShouldSkip("CC.S.F00 && CC.S.C00.Rsp")) {
                NextTest();
                return;
            }
            err = TestThSendsMoveToHueCommandToDutWithHue200Direction0x00ShortestDistanceAndTransitionTime0Immediately_3();
            break;
        case 4:
            ChipLogProgress(chipTool, " ***** Test Step 4 : Wait 100ms\n");
            err = TestWait100ms_4();
            break;
        case 5:
            ChipLogProgress(chipTool,
                " ***** Test Step 5 : TH sends StepHue command to DUT with StepMode=0x01 (up), StepSize=60 and TransitionTime=200 "
                "(20s)\n");
            if (ShouldSkip("CC.S.F00 && CC.S.C02.Rsp")) {
                NextTest();
                return;
            }
            err = TestThSendsStepHueCommandToDutWithStepMode0x01UpStepSize60AndTransitionTime20020s_5();
            break;
        case 6:
            ChipLogProgress(chipTool, " ***** Test Step 6 : Wait 10s\n");
            err = TestWait10s_6();
            break;
        case 7:
            ChipLogProgress(chipTool, " ***** Test Step 7 : TH reads CurrentHue attribute from DUT\n");
            if (ShouldSkip("CC.S.F00 && CC.S.A0000")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentHueAttributeFromDut_7();
            break;
        case 8:
            ChipLogProgress(chipTool, " ***** Test Step 8 : Wait 10s\n");
            err = TestWait10s_8();
            break;
        case 9:
            ChipLogProgress(chipTool, " ***** Test Step 9 : TH reads CurrentHue attribute from DUT\n");
            if (ShouldSkip("CC.S.F00 && CC.S.A0000")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentHueAttributeFromDut_9();
            break;
        case 10:
            ChipLogProgress(chipTool, " ***** Test Step 10 : Wait 5s\n");
            err = TestWait5s_10();
            break;
        case 11:
            ChipLogProgress(chipTool, " ***** Test Step 11 : TH reads CurrentHue attribute from DUT\n");
            if (ShouldSkip("CC.S.F00 && CC.S.A0000")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentHueAttributeFromDut_11();
            break;
        case 12:
            ChipLogProgress(chipTool,
                " ***** Test Step 12 : TH sends MoveToHue command to DUT with Hue=50, Direction=0x00 (shortest distance) and "
                "TransitionTime=0 (immediately)\n");
            if (ShouldSkip("CC.S.F00 && CC.S.C00.Rsp")) {
                NextTest();
                return;
            }
            err = TestThSendsMoveToHueCommandToDutWithHue50Direction0x00ShortestDistanceAndTransitionTime0Immediately_12();
            break;
        case 13:
            ChipLogProgress(chipTool, " ***** Test Step 13 : Wait 100ms\n");
            err = TestWait100ms_13();
            break;
        case 14:
            ChipLogProgress(chipTool,
                " ***** Test Step 14 : TH sends StepHue command to DUT with StepMode=0x03 (down), StepSize=60 and "
                "TransitionTime=200 (20s)\n");
            if (ShouldSkip("CC.S.F00 && CC.S.C02.Rsp")) {
                NextTest();
                return;
            }
            err = TestThSendsStepHueCommandToDutWithStepMode0x03DownStepSize60AndTransitionTime20020s_14();
            break;
        case 15:
            ChipLogProgress(chipTool, " ***** Test Step 15 : Wait 10s\n");
            err = TestWait10s_15();
            break;
        case 16:
            ChipLogProgress(chipTool, " ***** Test Step 16 : TH reads CurrentHue attribute from DUT\n");
            if (ShouldSkip("CC.S.F00 && CC.S.A0000")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentHueAttributeFromDut_16();
            break;
        case 17:
            ChipLogProgress(chipTool, " ***** Test Step 17 : Wait 10s\n");
            err = TestWait10s_17();
            break;
        case 18:
            ChipLogProgress(chipTool, " ***** Test Step 18 : TH reads CurrentHue attribute from DUT\n");
            if (ShouldSkip("CC.S.F00 && CC.S.A0000")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentHueAttributeFromDut_18();
            break;
        case 19:
            ChipLogProgress(chipTool, " ***** Test Step 19 : Wait 5s\n");
            err = TestWait5s_19();
            break;
        case 20:
            ChipLogProgress(chipTool, " ***** Test Step 20 : TH reads CurrentHue attribute from DUT\n");
            if (ShouldSkip("CC.S.F00 && CC.S.A0000")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentHueAttributeFromDut_20();
            break;
        case 21:
            ChipLogProgress(chipTool, " ***** Test Step 21 : TH reads ColorMode attribute from DUT\n");
            if (ShouldSkip("CC.S.F00 && CC.S.A0008")) {
                NextTest();
                return;
            }
            err = TestThReadsColorModeAttributeFromDut_21();
            break;
        case 22:
            ChipLogProgress(chipTool, " ***** Test Step 22 : TH reads EnhancedColorMode attribute from DUT\n");
            if (ShouldSkip("CC.S.F00 && CC.S.A4001")) {
                NextTest();
                return;
            }
            err = TestThReadsEnhancedColorModeAttributeFromDut_22();
            break;
        case 23:
            ChipLogProgress(chipTool, " ***** Test Step 23 : Turn off light that we turned on\n");
            if (ShouldSkip("OO.S.C00.Rsp")) {
                NextTest();
                return;
            }
            err = TestTurnOffLightThatWeTurnedOn_23();
            break;
        case 24:
            ChipLogProgress(chipTool, " ***** Test Step 24 : Check on/off attribute value is false after off command\n");
            if (ShouldSkip("OO.S.A0000")) {
                NextTest();
                return;
            }
            err = TestCheckOnOffAttributeValueIsFalseAfterOffCommand_24();
            break;
        }

        if (CHIP_NO_ERROR != err) {
            ChipLogError(chipTool, " ***** Test Failure: %s\n", chip::ErrorStr(err));
            SetCommandExitStatus(err);
        }
    }

    void OnStatusUpdate(const chip::app::StatusIB & status) override
    {
        switch (mTestIndex - 1) {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 6:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 7:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 8:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 9:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 10:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 11:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 12:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 13:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 14:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 15:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 16:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 17:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 18:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 19:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 20:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 21:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 22:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 23:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 24:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        }

        // Go on to the next test.
        ContinueOnChipMainThread(CHIP_NO_ERROR);
    }

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    std::atomic_uint16_t mTestIndex;
    const uint16_t mTestCount = 25;

    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    CHIP_ERROR TestWaitForTheCommissionedDeviceToBeRetrieved_0()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
        value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
        return WaitForCommissionee("alpha", value);
    }

    CHIP_ERROR TestThWrites0ToTheOptionsAttribute_1()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        id optionsArgument;
        optionsArgument = [NSNumber numberWithUnsignedChar:0U];
        [cluster writeAttributeOptionsWithValue:optionsArgument
                                     completion:^(NSError * _Nullable err) {
                                         NSLog(@"TH writes 0 to the Options attribute Error: %@", err);

                                         VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                                         NextTest();
                                     }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThSendsOnCommandToDut_2()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterOnOff alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster onWithCompletion:^(NSError * _Nullable err) {
            NSLog(@"TH sends On command to DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThSendsMoveToHueCommandToDutWithHue200Direction0x00ShortestDistanceAndTransitionTime0Immediately_3()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        __auto_type * params = [[MTRColorControlClusterMoveToHueParams alloc] init];
        params.hue = [NSNumber numberWithUnsignedChar:200U];
        params.direction = [NSNumber numberWithUnsignedChar:0U];
        params.transitionTime = [NSNumber numberWithUnsignedShort:0U];
        params.optionsMask = [NSNumber numberWithUnsignedChar:0U];
        params.optionsOverride = [NSNumber numberWithUnsignedChar:0U];
        [cluster moveToHueWithParams:params
                          completion:^(NSError * _Nullable err) {
                              NSLog(@"TH sends MoveToHue command to DUT with Hue=200, Direction=0x00 (shortest distance) and "
                                    @"TransitionTime=0 (immediately) Error: %@",
                                  err);

                              VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                              NextTest();
                          }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait100ms_4()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 100UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThSendsStepHueCommandToDutWithStepMode0x01UpStepSize60AndTransitionTime20020s_5()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        __auto_type * params = [[MTRColorControlClusterStepHueParams alloc] init];
        params.stepMode = [NSNumber numberWithUnsignedChar:1U];
        params.stepSize = [NSNumber numberWithUnsignedChar:60U];
        params.transitionTime = [NSNumber numberWithUnsignedChar:200U];
        params.optionsMask = [NSNumber numberWithUnsignedChar:0U];
        params.optionsOverride = [NSNumber numberWithUnsignedChar:0U];
        [cluster stepHueWithParams:params
                        completion:^(NSError * _Nullable err) {
                            NSLog(@"TH sends StepHue command to DUT with StepMode=0x01 (up), StepSize=60 and TransitionTime=200 "
                                  @"(20s) Error: %@",
                                err);

                            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                            NextTest();
                        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait10s_6()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 10000UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThReadsCurrentHueAttributeFromDut_7()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentHueWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentHue attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("currentHue", [value unsignedCharValue], 195U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("currentHue", [value unsignedCharValue], 254U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait10s_8()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 10000UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThReadsCurrentHueAttributeFromDut_9()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentHueWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentHue attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("currentHue", [value unsignedCharValue], 4U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("currentHue", [value unsignedCharValue], 6U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait5s_10()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 5000UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThReadsCurrentHueAttributeFromDut_11()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentHueWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentHue attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("currentHue", [value unsignedCharValue], 4U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("currentHue", [value unsignedCharValue], 6U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThSendsMoveToHueCommandToDutWithHue50Direction0x00ShortestDistanceAndTransitionTime0Immediately_12()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        __auto_type * params = [[MTRColorControlClusterMoveToHueParams alloc] init];
        params.hue = [NSNumber numberWithUnsignedChar:50U];
        params.direction = [NSNumber numberWithUnsignedChar:0U];
        params.transitionTime = [NSNumber numberWithUnsignedShort:0U];
        params.optionsMask = [NSNumber numberWithUnsignedChar:0U];
        params.optionsOverride = [NSNumber numberWithUnsignedChar:0U];
        [cluster moveToHueWithParams:params
                          completion:^(NSError * _Nullable err) {
                              NSLog(@"TH sends MoveToHue command to DUT with Hue=50, Direction=0x00 (shortest distance) and "
                                    @"TransitionTime=0 (immediately) Error: %@",
                                  err);

                              VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                              NextTest();
                          }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait100ms_13()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 100UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThSendsStepHueCommandToDutWithStepMode0x03DownStepSize60AndTransitionTime20020s_14()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        __auto_type * params = [[MTRColorControlClusterStepHueParams alloc] init];
        params.stepMode = [NSNumber numberWithUnsignedChar:3U];
        params.stepSize = [NSNumber numberWithUnsignedChar:60U];
        params.transitionTime = [NSNumber numberWithUnsignedChar:200U];
        params.optionsMask = [NSNumber numberWithUnsignedChar:0U];
        params.optionsOverride = [NSNumber numberWithUnsignedChar:0U];
        [cluster stepHueWithParams:params
                        completion:^(NSError * _Nullable err) {
                            NSLog(@"TH sends StepHue command to DUT with StepMode=0x03 (down), StepSize=60 and TransitionTime=200 "
                                  @"(20s) Error: %@",
                                err);

                            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                            NextTest();
                        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait10s_15()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 10000UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThReadsCurrentHueAttributeFromDut_16()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentHueWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentHue attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("currentHue", [value unsignedCharValue], 17U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("currentHue", [value unsignedCharValue], 23U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait10s_17()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 10000UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThReadsCurrentHueAttributeFromDut_18()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentHueWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentHue attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("currentHue", [value unsignedCharValue], 208U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("currentHue", [value unsignedCharValue], 255U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait5s_19()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 5000UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThReadsCurrentHueAttributeFromDut_20()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentHueWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentHue attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("currentHue", [value unsignedCharValue], 208U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("currentHue", [value unsignedCharValue], 255U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsColorModeAttributeFromDut_21()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeColorModeWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads ColorMode attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("ColorMode", actualValue, 0U));
            }

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("colorMode", [value unsignedCharValue], 0U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("colorMode", [value unsignedCharValue], 2U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsEnhancedColorModeAttributeFromDut_22()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeEnhancedColorModeWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads EnhancedColorMode attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("EnhancedColorMode", actualValue, 0U));
            }

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("enhancedColorMode", [value unsignedCharValue], 0U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("enhancedColorMode", [value unsignedCharValue], 3U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestTurnOffLightThatWeTurnedOn_23()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterOnOff alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster offWithCompletion:^(NSError * _Nullable err) {
            NSLog(@"Turn off light that we turned on Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestCheckOnOffAttributeValueIsFalseAfterOffCommand_24()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterOnOff alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeOnOffWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Check on/off attribute value is false after off command Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("OnOff", actualValue, 0));
            }

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }
};

class Test_TC_CC_4_1 : public TestCommandBridge {
public:
    // NOLINTBEGIN(clang-analyzer-nullability.NullPassedToNonnull): Test constructor nullability not enforced
    Test_TC_CC_4_1()
        : TestCommandBridge("Test_TC_CC_4_1")
        , mTestIndex(0)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("SaturationConfigValue", 0, UINT8_MAX, &mSaturationConfigValue);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }
    // NOLINTEND(clang-analyzer-nullability.NullPassedToNonnull)

    ~Test_TC_CC_4_1() {}

    /////////// TestCommand Interface /////////
    void NextTest() override
    {
        CHIP_ERROR err = CHIP_NO_ERROR;

        if (0 == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Start: Test_TC_CC_4_1\n");
        }

        if (mTestCount == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Complete: Test_TC_CC_4_1\n");
            SetCommandExitStatus(CHIP_NO_ERROR);
            return;
        }

        Wait();

        // Ensure we increment mTestIndex before we start running the relevant
        // command.  That way if we lose the timeslice after we send the message
        // but before our function call returns, we won't end up with an
        // incorrect mTestIndex value observed when we get the response.
        switch (mTestIndex++) {
        case 0:
            ChipLogProgress(chipTool, " ***** Test Step 0 : Wait for the commissioned device to be retrieved\n");
            err = TestWaitForTheCommissionedDeviceToBeRetrieved_0();
            break;
        case 1:
            ChipLogProgress(chipTool, " ***** Test Step 1 : TH writes 0 to the Options attribute\n");
            if (ShouldSkip("CC.S.F00 && CC.S.A000f")) {
                NextTest();
                return;
            }
            err = TestThWrites0ToTheOptionsAttribute_1();
            break;
        case 2:
            ChipLogProgress(chipTool, " ***** Test Step 2 : TH sends On command to DUT\n");
            if (ShouldSkip("OO.S.C01.Rsp")) {
                NextTest();
                return;
            }
            err = TestThSendsOnCommandToDut_2();
            break;
        case 3:
            ChipLogProgress(chipTool,
                " ***** Test Step 3 : TH sends MoveToSaturation command to DUT with Saturation=60 and TransitionTime=0 "
                "(immediately)\n");
            if (ShouldSkip("CC.S.F00 && CC.S.C03.Rsp")) {
                NextTest();
                return;
            }
            err = TestThSendsMoveToSaturationCommandToDutWithSaturation60AndTransitionTime0Immediately_3();
            break;
        case 4:
            ChipLogProgress(chipTool, " ***** Test Step 4 : Wait 100ms\n");
            err = TestWait100ms_4();
            break;
        case 5:
            ChipLogProgress(chipTool,
                " ***** Test Step 5 : TH sends MoveToSaturation command to DUT with Saturation=120 and TransitionTime=300 (30s)\n");
            if (ShouldSkip("CC.S.F00 && CC.S.C03.Rsp")) {
                NextTest();
                return;
            }
            err = TestThSendsMoveToSaturationCommandToDutWithSaturation120AndTransitionTime30030s_5();
            break;
        case 6:
            ChipLogProgress(chipTool, " ***** Test Step 6 : Wait 10s\n");
            err = TestWait10s_6();
            break;
        case 7:
            ChipLogProgress(chipTool, " ***** Test Step 7 : TH reads CurrentSaturation attribute from DUT\n");
            if (ShouldSkip("CC.S.F00 && CC.S.A0001")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentSaturationAttributeFromDut_7();
            break;
        case 8:
            ChipLogProgress(chipTool, " ***** Test Step 8 : Wait 10s\n");
            err = TestWait10s_8();
            break;
        case 9:
            ChipLogProgress(chipTool, " ***** Test Step 9 : TH reads CurrentSaturation attribute from DUT\n");
            if (ShouldSkip("CC.S.F00 && CC.S.A0001")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentSaturationAttributeFromDut_9();
            break;
        case 10:
            ChipLogProgress(chipTool, " ***** Test Step 10 : Wait 10s\n");
            err = TestWait10s_10();
            break;
        case 11:
            ChipLogProgress(chipTool, " ***** Test Step 11 : TH reads CurrentSaturation attribute from DUT\n");
            if (ShouldSkip("CC.S.F00 && CC.S.A0001")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentSaturationAttributeFromDut_11();
            break;
        case 12:
            ChipLogProgress(chipTool, " ***** Test Step 12 : Wait 5s\n");
            err = TestWait5s_12();
            break;
        case 13:
            ChipLogProgress(chipTool, " ***** Test Step 13 : TH reads CurrentSaturation attribute from DUT\n");
            if (ShouldSkip("CC.S.F00 && CC.S.A0001")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentSaturationAttributeFromDut_13();
            break;
        case 14:
            ChipLogProgress(chipTool, " ***** Test Step 14 : TH reads ColorMode attribute from DUT\n");
            if (ShouldSkip("CC.S.F00 && CC.S.A0008")) {
                NextTest();
                return;
            }
            err = TestThReadsColorModeAttributeFromDut_14();
            break;
        case 15:
            ChipLogProgress(chipTool, " ***** Test Step 15 : TH reads EnhancedColorMode attribute from DUT\n");
            if (ShouldSkip("CC.S.F00 && CC.S.A4001")) {
                NextTest();
                return;
            }
            err = TestThReadsEnhancedColorModeAttributeFromDut_15();
            break;
        case 16:
            ChipLogProgress(chipTool, " ***** Test Step 16 : Turn off light that we turned on\n");
            if (ShouldSkip("OO.S.C00.Rsp")) {
                NextTest();
                return;
            }
            err = TestTurnOffLightThatWeTurnedOn_16();
            break;
        case 17:
            ChipLogProgress(chipTool, " ***** Test Step 17 : Check on/off attribute value is false after off command\n");
            if (ShouldSkip("OO.S.A0000")) {
                NextTest();
                return;
            }
            err = TestCheckOnOffAttributeValueIsFalseAfterOffCommand_17();
            break;
        }

        if (CHIP_NO_ERROR != err) {
            ChipLogError(chipTool, " ***** Test Failure: %s\n", chip::ErrorStr(err));
            SetCommandExitStatus(err);
        }
    }

    void OnStatusUpdate(const chip::app::StatusIB & status) override
    {
        switch (mTestIndex - 1) {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 6:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 7:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 8:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 9:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 10:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 11:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 12:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 13:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 14:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 15:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 16:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 17:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        }

        // Go on to the next test.
        ContinueOnChipMainThread(CHIP_NO_ERROR);
    }

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    std::atomic_uint16_t mTestIndex;
    const uint16_t mTestCount = 18;

    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint8_t> mSaturationConfigValue;
    chip::Optional<uint16_t> mTimeout;

    CHIP_ERROR TestWaitForTheCommissionedDeviceToBeRetrieved_0()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
        value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
        return WaitForCommissionee("alpha", value);
    }

    CHIP_ERROR TestThWrites0ToTheOptionsAttribute_1()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        id optionsArgument;
        optionsArgument = [NSNumber numberWithUnsignedChar:0U];
        [cluster writeAttributeOptionsWithValue:optionsArgument
                                     completion:^(NSError * _Nullable err) {
                                         NSLog(@"TH writes 0 to the Options attribute Error: %@", err);

                                         VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                                         NextTest();
                                     }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThSendsOnCommandToDut_2()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterOnOff alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster onWithCompletion:^(NSError * _Nullable err) {
            NSLog(@"TH sends On command to DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThSendsMoveToSaturationCommandToDutWithSaturation60AndTransitionTime0Immediately_3()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        __auto_type * params = [[MTRColorControlClusterMoveToSaturationParams alloc] init];
        params.saturation = [NSNumber numberWithUnsignedChar:60U];
        params.transitionTime = [NSNumber numberWithUnsignedShort:0U];
        params.optionsMask = [NSNumber numberWithUnsignedChar:0U];
        params.optionsOverride = [NSNumber numberWithUnsignedChar:0U];
        [cluster moveToSaturationWithParams:params
                                 completion:^(NSError * _Nullable err) {
                                     NSLog(@"TH sends MoveToSaturation command to DUT with Saturation=60 and TransitionTime=0 "
                                           @"(immediately) Error: %@",
                                         err);

                                     VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                                     NextTest();
                                 }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait100ms_4()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 100UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThSendsMoveToSaturationCommandToDutWithSaturation120AndTransitionTime30030s_5()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        __auto_type * params = [[MTRColorControlClusterMoveToSaturationParams alloc] init];
        params.saturation = [NSNumber numberWithUnsignedChar:120U];
        params.transitionTime = [NSNumber numberWithUnsignedShort:300U];
        params.optionsMask = [NSNumber numberWithUnsignedChar:0U];
        params.optionsOverride = [NSNumber numberWithUnsignedChar:0U];
        [cluster moveToSaturationWithParams:params
                                 completion:^(NSError * _Nullable err) {
                                     NSLog(@"TH sends MoveToSaturation command to DUT with Saturation=120 and TransitionTime=300 "
                                           @"(30s) Error: %@",
                                         err);

                                     VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                                     NextTest();
                                 }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait10s_6()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 10000UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThReadsCurrentSaturationAttributeFromDut_7()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentSaturationWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentSaturation attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("currentSaturation", [value unsignedCharValue], 68U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("currentSaturation", [value unsignedCharValue], 92U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait10s_8()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 10000UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThReadsCurrentSaturationAttributeFromDut_9()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentSaturationWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentSaturation attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("currentSaturation", [value unsignedCharValue], 80U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("currentSaturation", [value unsignedCharValue], 115U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait10s_10()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 10000UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThReadsCurrentSaturationAttributeFromDut_11()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentSaturationWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentSaturation attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("currentSaturation", [value unsignedCharValue], 102U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("currentSaturation", [value unsignedCharValue], 138U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait5s_12()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 5000UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThReadsCurrentSaturationAttributeFromDut_13()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentSaturationWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentSaturation attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("currentSaturation", [value unsignedCharValue], 102U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("currentSaturation", [value unsignedCharValue], 138U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsColorModeAttributeFromDut_14()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeColorModeWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads ColorMode attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("ColorMode", actualValue, 0U));
            }

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("colorMode", [value unsignedCharValue], 0U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("colorMode", [value unsignedCharValue], 2U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsEnhancedColorModeAttributeFromDut_15()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeEnhancedColorModeWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads EnhancedColorMode attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("EnhancedColorMode", actualValue, 0U));
            }

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("enhancedColorMode", [value unsignedCharValue], 0U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("enhancedColorMode", [value unsignedCharValue], 3U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestTurnOffLightThatWeTurnedOn_16()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterOnOff alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster offWithCompletion:^(NSError * _Nullable err) {
            NSLog(@"Turn off light that we turned on Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestCheckOnOffAttributeValueIsFalseAfterOffCommand_17()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterOnOff alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeOnOffWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Check on/off attribute value is false after off command Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("OnOff", actualValue, 0));
            }

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }
};

class Test_TC_CC_4_2 : public TestCommandBridge {
public:
    // NOLINTBEGIN(clang-analyzer-nullability.NullPassedToNonnull): Test constructor nullability not enforced
    Test_TC_CC_4_2()
        : TestCommandBridge("Test_TC_CC_4_2")
        , mTestIndex(0)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }
    // NOLINTEND(clang-analyzer-nullability.NullPassedToNonnull)

    ~Test_TC_CC_4_2() {}

    /////////// TestCommand Interface /////////
    void NextTest() override
    {
        CHIP_ERROR err = CHIP_NO_ERROR;

        if (0 == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Start: Test_TC_CC_4_2\n");
        }

        if (mTestCount == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Complete: Test_TC_CC_4_2\n");
            SetCommandExitStatus(CHIP_NO_ERROR);
            return;
        }

        Wait();

        // Ensure we increment mTestIndex before we start running the relevant
        // command.  That way if we lose the timeslice after we send the message
        // but before our function call returns, we won't end up with an
        // incorrect mTestIndex value observed when we get the response.
        switch (mTestIndex++) {
        case 0:
            ChipLogProgress(chipTool, " ***** Test Step 0 : Wait for the commissioned device to be retrieved\n");
            err = TestWaitForTheCommissionedDeviceToBeRetrieved_0();
            break;
        case 1:
            ChipLogProgress(chipTool, " ***** Test Step 1 : TH writes 0 to the Options attribute\n");
            if (ShouldSkip("CC.S.F00 && CC.S.A000f")) {
                NextTest();
                return;
            }
            err = TestThWrites0ToTheOptionsAttribute_1();
            break;
        case 2:
            ChipLogProgress(chipTool, " ***** Test Step 2 : TH sends On command to DUT\n");
            if (ShouldSkip("OO.S.C01.Rsp")) {
                NextTest();
                return;
            }
            err = TestThSendsOnCommandToDut_2();
            break;
        case 3:
            ChipLogProgress(chipTool,
                " ***** Test Step 3 : TH sends MoveToSaturation command to DUT with Saturation=150 and TransitionTime=0 "
                "(immediately)\n");
            if (ShouldSkip("CC.S.F00 && CC.S.C03.Rsp")) {
                NextTest();
                return;
            }
            err = TestThSendsMoveToSaturationCommandToDutWithSaturation150AndTransitionTime0Immediately_3();
            break;
        case 4:
            ChipLogProgress(chipTool, " ***** Test Step 4 : Wait 100ms\n");
            err = TestWait100ms_4();
            break;
        case 5:
            ChipLogProgress(chipTool,
                " ***** Test Step 5 : TH sends MoveSaturation command to DUT with MoveMode=0x01 (up) and Rate=5 (units/s)\n");
            if (ShouldSkip("CC.S.F00 && CC.S.C04.Rsp")) {
                NextTest();
                return;
            }
            err = TestThSendsMoveSaturationCommandToDutWithMoveMode0x01UpAndRate5UnitsS_5();
            break;
        case 6:
            ChipLogProgress(chipTool, " ***** Test Step 6 : Wait 10s\n");
            err = TestWait10s_6();
            break;
        case 7:
            ChipLogProgress(chipTool, " ***** Test Step 7 : TH reads CurrentSaturation attribute from DUT\n");
            if (ShouldSkip("CC.S.F00 && CC.S.A0001")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentSaturationAttributeFromDut_7();
            break;
        case 8:
            ChipLogProgress(chipTool, " ***** Test Step 8 : Wait 10s\n");
            err = TestWait10s_8();
            break;
        case 9:
            ChipLogProgress(chipTool, " ***** Test Step 9 : TH reads CurrentSaturation attribute from DUT\n");
            if (ShouldSkip("CC.S.F00 && CC.S.A0001")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentSaturationAttributeFromDut_9();
            break;
        case 10:
            ChipLogProgress(chipTool, " ***** Test Step 10 : Wait 5s\n");
            err = TestWait5s_10();
            break;
        case 11:
            ChipLogProgress(chipTool, " ***** Test Step 11 : TH reads CurrentSaturation attribute from DUT\n");
            if (ShouldSkip("CC.S.F00 && CC.S.A0001")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentSaturationAttributeFromDut_11();
            break;
        case 12:
            ChipLogProgress(chipTool,
                " ***** Test Step 12 : TH sends MoveToSaturation command to DUT with Saturation=120 and TransitionTime=0 "
                "(immediately)\n");
            if (ShouldSkip("CC.S.F00 && CC.S.C03.Rsp")) {
                NextTest();
                return;
            }
            err = TestThSendsMoveToSaturationCommandToDutWithSaturation120AndTransitionTime0Immediately_12();
            break;
        case 13:
            ChipLogProgress(chipTool, " ***** Test Step 13 : Wait 100ms\n");
            err = TestWait100ms_13();
            break;
        case 14:
            ChipLogProgress(chipTool,
                " ***** Test Step 14 : TH sends MoveSaturation command to DUT with MoveMode=0x03 (down) and Rate=5 (units/s)\n");
            if (ShouldSkip("CC.S.F00 && CC.S.C04.Rsp")) {
                NextTest();
                return;
            }
            err = TestThSendsMoveSaturationCommandToDutWithMoveMode0x03DownAndRate5UnitsS_14();
            break;
        case 15:
            ChipLogProgress(chipTool, " ***** Test Step 15 : Wait 10s\n");
            err = TestWait10s_15();
            break;
        case 16:
            ChipLogProgress(chipTool, " ***** Test Step 16 : TH reads CurrentSaturation attribute from DUT\n");
            if (ShouldSkip("CC.S.F00 && CC.S.A0001")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentSaturationAttributeFromDut_16();
            break;
        case 17:
            ChipLogProgress(chipTool, " ***** Test Step 17 : Wait 10s\n");
            err = TestWait10s_17();
            break;
        case 18:
            ChipLogProgress(chipTool, " ***** Test Step 18 : TH reads CurrentSaturation attribute from DUT\n");
            if (ShouldSkip("CC.S.F00 && CC.S.A0001")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentSaturationAttributeFromDut_18();
            break;
        case 19:
            ChipLogProgress(chipTool, " ***** Test Step 19 : Wait 10s\n");
            err = TestWait10s_19();
            break;
        case 20:
            ChipLogProgress(chipTool, " ***** Test Step 20 : TH reads CurrentSaturation attribute from DUT\n");
            if (ShouldSkip("CC.S.F00 && CC.S.A0001")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentSaturationAttributeFromDut_20();
            break;
        case 21:
            ChipLogProgress(chipTool,
                " ***** Test Step 21 : TH sends MoveToSaturation command to DUT with Saturation=150 and TransitionTime=0 "
                "(immediately)\n");
            if (ShouldSkip("CC.S.F00 && CC.S.C03.Rsp")) {
                NextTest();
                return;
            }
            err = TestThSendsMoveToSaturationCommandToDutWithSaturation150AndTransitionTime0Immediately_21();
            break;
        case 22:
            ChipLogProgress(chipTool, " ***** Test Step 22 : Wait 100ms\n");
            err = TestWait100ms_22();
            break;
        case 23:
            ChipLogProgress(chipTool,
                " ***** Test Step 23 : TH sends MoveSaturation command to DUT with MoveMode=0x01 (up) and Rate=5 (units/s)\n");
            if (ShouldSkip("CC.S.F00 && CC.S.C04.Rsp")) {
                NextTest();
                return;
            }
            err = TestThSendsMoveSaturationCommandToDutWithMoveMode0x01UpAndRate5UnitsS_23();
            break;
        case 24:
            ChipLogProgress(chipTool, " ***** Test Step 24 : Wait 10s\n");
            err = TestWait10s_24();
            break;
        case 25:
            ChipLogProgress(chipTool, " ***** Test Step 25 : TH reads CurrentSaturation attribute from DUT\n");
            if (ShouldSkip("CC.S.F00 && CC.S.A0001")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentSaturationAttributeFromDut_25();
            break;
        case 26:
            ChipLogProgress(chipTool,
                " ***** Test Step 26 : TH sends MoveSaturation command to DUT with MoveMode=0x00 (stop) and Rate=5 (units/s)\n");
            if (ShouldSkip("CC.S.F00 && CC.S.C04.Rsp")) {
                NextTest();
                return;
            }
            err = TestThSendsMoveSaturationCommandToDutWithMoveMode0x00StopAndRate5UnitsS_26();
            break;
        case 27:
            ChipLogProgress(chipTool, " ***** Test Step 27 : TH reads CurrentSaturation attribute from DUT\n");
            if (ShouldSkip("CC.S.F00 && CC.S.A0001")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentSaturationAttributeFromDut_27();
            break;
        case 28:
            ChipLogProgress(chipTool, " ***** Test Step 28 : Wait 2s\n");
            err = TestWait2s_28();
            break;
        case 29:
            ChipLogProgress(chipTool, " ***** Test Step 29 : TH reads CurrentSaturation attribute from DUT\n");
            if (ShouldSkip("CC.S.F00 && CC.S.A0001")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentSaturationAttributeFromDut_29();
            break;
        case 30:
            ChipLogProgress(chipTool, " ***** Test Step 30 : TH reads ColorMode attribute from DUT\n");
            if (ShouldSkip("CC.S.F00 && CC.S.A0008")) {
                NextTest();
                return;
            }
            err = TestThReadsColorModeAttributeFromDut_30();
            break;
        case 31:
            ChipLogProgress(chipTool, " ***** Test Step 31 : TH reads EnhancedColorMode attribute from DUT\n");
            if (ShouldSkip("CC.S.F00 && CC.S.A4001")) {
                NextTest();
                return;
            }
            err = TestThReadsEnhancedColorModeAttributeFromDut_31();
            break;
        case 32:
            ChipLogProgress(chipTool, " ***** Test Step 32 : Turn off light that we turned on\n");
            if (ShouldSkip("OO.S.C00.Rsp")) {
                NextTest();
                return;
            }
            err = TestTurnOffLightThatWeTurnedOn_32();
            break;
        case 33:
            ChipLogProgress(chipTool, " ***** Test Step 33 : Check on/off attribute value is false after off command\n");
            if (ShouldSkip("OO.S.A0000")) {
                NextTest();
                return;
            }
            err = TestCheckOnOffAttributeValueIsFalseAfterOffCommand_33();
            break;
        }

        if (CHIP_NO_ERROR != err) {
            ChipLogError(chipTool, " ***** Test Failure: %s\n", chip::ErrorStr(err));
            SetCommandExitStatus(err);
        }
    }

    void OnStatusUpdate(const chip::app::StatusIB & status) override
    {
        switch (mTestIndex - 1) {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 6:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 7:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 8:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 9:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 10:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 11:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 12:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 13:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 14:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 15:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 16:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 17:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 18:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 19:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 20:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 21:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 22:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 23:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 24:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 25:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 26:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 27:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 28:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 29:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 30:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 31:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 32:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 33:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        }

        // Go on to the next test.
        ContinueOnChipMainThread(CHIP_NO_ERROR);
    }

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    std::atomic_uint16_t mTestIndex;
    const uint16_t mTestCount = 34;

    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    CHIP_ERROR TestWaitForTheCommissionedDeviceToBeRetrieved_0()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
        value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
        return WaitForCommissionee("alpha", value);
    }

    CHIP_ERROR TestThWrites0ToTheOptionsAttribute_1()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        id optionsArgument;
        optionsArgument = [NSNumber numberWithUnsignedChar:0U];
        [cluster writeAttributeOptionsWithValue:optionsArgument
                                     completion:^(NSError * _Nullable err) {
                                         NSLog(@"TH writes 0 to the Options attribute Error: %@", err);

                                         VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                                         NextTest();
                                     }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThSendsOnCommandToDut_2()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterOnOff alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster onWithCompletion:^(NSError * _Nullable err) {
            NSLog(@"TH sends On command to DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThSendsMoveToSaturationCommandToDutWithSaturation150AndTransitionTime0Immediately_3()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        __auto_type * params = [[MTRColorControlClusterMoveToSaturationParams alloc] init];
        params.saturation = [NSNumber numberWithUnsignedChar:150U];
        params.transitionTime = [NSNumber numberWithUnsignedShort:0U];
        params.optionsMask = [NSNumber numberWithUnsignedChar:0U];
        params.optionsOverride = [NSNumber numberWithUnsignedChar:0U];
        [cluster moveToSaturationWithParams:params
                                 completion:^(NSError * _Nullable err) {
                                     NSLog(@"TH sends MoveToSaturation command to DUT with Saturation=150 and TransitionTime=0 "
                                           @"(immediately) Error: %@",
                                         err);

                                     VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                                     NextTest();
                                 }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait100ms_4()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 100UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThSendsMoveSaturationCommandToDutWithMoveMode0x01UpAndRate5UnitsS_5()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        __auto_type * params = [[MTRColorControlClusterMoveSaturationParams alloc] init];
        params.moveMode = [NSNumber numberWithUnsignedChar:1U];
        params.rate = [NSNumber numberWithUnsignedChar:5U];
        params.optionsMask = [NSNumber numberWithUnsignedChar:0U];
        params.optionsOverride = [NSNumber numberWithUnsignedChar:0U];
        [cluster
            moveSaturationWithParams:params
                          completion:^(NSError * _Nullable err) {
                              NSLog(
                                  @"TH sends MoveSaturation command to DUT with MoveMode=0x01 (up) and Rate=5 (units/s) Error: %@",
                                  err);

                              VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                              NextTest();
                          }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait10s_6()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 10000UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThReadsCurrentSaturationAttributeFromDut_7()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentSaturationWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentSaturation attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("currentSaturation", [value unsignedCharValue], 170U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("currentSaturation", [value unsignedCharValue], 230U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait10s_8()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 10000UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThReadsCurrentSaturationAttributeFromDut_9()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentSaturationWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentSaturation attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("currentSaturation", [value unsignedCharValue], 216U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("currentSaturation", [value unsignedCharValue], 254U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait5s_10()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 5000UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThReadsCurrentSaturationAttributeFromDut_11()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentSaturationWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentSaturation attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("currentSaturation", [value unsignedCharValue], 216U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("currentSaturation", [value unsignedCharValue], 254U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThSendsMoveToSaturationCommandToDutWithSaturation120AndTransitionTime0Immediately_12()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        __auto_type * params = [[MTRColorControlClusterMoveToSaturationParams alloc] init];
        params.saturation = [NSNumber numberWithUnsignedChar:120U];
        params.transitionTime = [NSNumber numberWithUnsignedShort:0U];
        params.optionsMask = [NSNumber numberWithUnsignedChar:0U];
        params.optionsOverride = [NSNumber numberWithUnsignedChar:0U];
        [cluster moveToSaturationWithParams:params
                                 completion:^(NSError * _Nullable err) {
                                     NSLog(@"TH sends MoveToSaturation command to DUT with Saturation=120 and TransitionTime=0 "
                                           @"(immediately) Error: %@",
                                         err);

                                     VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                                     NextTest();
                                 }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait100ms_13()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 100UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThSendsMoveSaturationCommandToDutWithMoveMode0x03DownAndRate5UnitsS_14()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        __auto_type * params = [[MTRColorControlClusterMoveSaturationParams alloc] init];
        params.moveMode = [NSNumber numberWithUnsignedChar:3U];
        params.rate = [NSNumber numberWithUnsignedChar:5U];
        params.optionsMask = [NSNumber numberWithUnsignedChar:0U];
        params.optionsOverride = [NSNumber numberWithUnsignedChar:0U];
        [cluster moveSaturationWithParams:params
                               completion:^(NSError * _Nullable err) {
                                   NSLog(@"TH sends MoveSaturation command to DUT with MoveMode=0x03 (down) and Rate=5 (units/s) "
                                         @"Error: %@",
                                       err);

                                   VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                                   NextTest();
                               }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait10s_15()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 10000UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThReadsCurrentSaturationAttributeFromDut_16()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentSaturationWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentSaturation attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("currentSaturation", [value unsignedCharValue], 59U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("currentSaturation", [value unsignedCharValue], 81U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait10s_17()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 10000UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThReadsCurrentSaturationAttributeFromDut_18()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentSaturationWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentSaturation attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("currentSaturation", [value unsignedCharValue], 17U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("currentSaturation", [value unsignedCharValue], 23U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait10s_19()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 10000UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThReadsCurrentSaturationAttributeFromDut_20()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentSaturationWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentSaturation attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("currentSaturation", [value unsignedCharValue], 0U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("currentSaturation", [value unsignedCharValue], 10U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThSendsMoveToSaturationCommandToDutWithSaturation150AndTransitionTime0Immediately_21()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        __auto_type * params = [[MTRColorControlClusterMoveToSaturationParams alloc] init];
        params.saturation = [NSNumber numberWithUnsignedChar:150U];
        params.transitionTime = [NSNumber numberWithUnsignedShort:0U];
        params.optionsMask = [NSNumber numberWithUnsignedChar:0U];
        params.optionsOverride = [NSNumber numberWithUnsignedChar:0U];
        [cluster moveToSaturationWithParams:params
                                 completion:^(NSError * _Nullable err) {
                                     NSLog(@"TH sends MoveToSaturation command to DUT with Saturation=150 and TransitionTime=0 "
                                           @"(immediately) Error: %@",
                                         err);

                                     VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                                     NextTest();
                                 }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait100ms_22()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 100UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThSendsMoveSaturationCommandToDutWithMoveMode0x01UpAndRate5UnitsS_23()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        __auto_type * params = [[MTRColorControlClusterMoveSaturationParams alloc] init];
        params.moveMode = [NSNumber numberWithUnsignedChar:1U];
        params.rate = [NSNumber numberWithUnsignedChar:5U];
        params.optionsMask = [NSNumber numberWithUnsignedChar:0U];
        params.optionsOverride = [NSNumber numberWithUnsignedChar:0U];
        [cluster
            moveSaturationWithParams:params
                          completion:^(NSError * _Nullable err) {
                              NSLog(
                                  @"TH sends MoveSaturation command to DUT with MoveMode=0x01 (up) and Rate=5 (units/s) Error: %@",
                                  err);

                              VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                              NextTest();
                          }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait10s_24()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 10000UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThReadsCurrentSaturationAttributeFromDut_25()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentSaturationWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentSaturation attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("currentSaturation", [value unsignedCharValue], 170U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("currentSaturation", [value unsignedCharValue], 230U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThSendsMoveSaturationCommandToDutWithMoveMode0x00StopAndRate5UnitsS_26()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        __auto_type * params = [[MTRColorControlClusterMoveSaturationParams alloc] init];
        params.moveMode = [NSNumber numberWithUnsignedChar:0U];
        params.rate = [NSNumber numberWithUnsignedChar:5U];
        params.optionsMask = [NSNumber numberWithUnsignedChar:0U];
        params.optionsOverride = [NSNumber numberWithUnsignedChar:0U];
        [cluster moveSaturationWithParams:params
                               completion:^(NSError * _Nullable err) {
                                   NSLog(@"TH sends MoveSaturation command to DUT with MoveMode=0x00 (stop) and Rate=5 (units/s) "
                                         @"Error: %@",
                                       err);

                                   VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                                   NextTest();
                               }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsCurrentSaturationAttributeFromDut_27()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentSaturationWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentSaturation attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("currentSaturation", [value unsignedCharValue], 170U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("currentSaturation", [value unsignedCharValue], 230U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait2s_28()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 2000UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThReadsCurrentSaturationAttributeFromDut_29()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentSaturationWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentSaturation attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("currentSaturation", [value unsignedCharValue], 170U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("currentSaturation", [value unsignedCharValue], 230U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsColorModeAttributeFromDut_30()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeColorModeWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads ColorMode attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("ColorMode", actualValue, 0U));
            }

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("colorMode", [value unsignedCharValue], 0U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("colorMode", [value unsignedCharValue], 2U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsEnhancedColorModeAttributeFromDut_31()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeEnhancedColorModeWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads EnhancedColorMode attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("EnhancedColorMode", actualValue, 0U));
            }

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("enhancedColorMode", [value unsignedCharValue], 0U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("enhancedColorMode", [value unsignedCharValue], 3U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestTurnOffLightThatWeTurnedOn_32()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterOnOff alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster offWithCompletion:^(NSError * _Nullable err) {
            NSLog(@"Turn off light that we turned on Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestCheckOnOffAttributeValueIsFalseAfterOffCommand_33()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterOnOff alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeOnOffWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Check on/off attribute value is false after off command Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("OnOff", actualValue, 0));
            }

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }
};

class Test_TC_CC_4_3 : public TestCommandBridge {
public:
    // NOLINTBEGIN(clang-analyzer-nullability.NullPassedToNonnull): Test constructor nullability not enforced
    Test_TC_CC_4_3()
        : TestCommandBridge("Test_TC_CC_4_3")
        , mTestIndex(0)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }
    // NOLINTEND(clang-analyzer-nullability.NullPassedToNonnull)

    ~Test_TC_CC_4_3() {}

    /////////// TestCommand Interface /////////
    void NextTest() override
    {
        CHIP_ERROR err = CHIP_NO_ERROR;

        if (0 == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Start: Test_TC_CC_4_3\n");
        }

        if (mTestCount == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Complete: Test_TC_CC_4_3\n");
            SetCommandExitStatus(CHIP_NO_ERROR);
            return;
        }

        Wait();

        // Ensure we increment mTestIndex before we start running the relevant
        // command.  That way if we lose the timeslice after we send the message
        // but before our function call returns, we won't end up with an
        // incorrect mTestIndex value observed when we get the response.
        switch (mTestIndex++) {
        case 0:
            ChipLogProgress(chipTool, " ***** Test Step 0 : Wait for the commissioned device to be retrieved\n");
            err = TestWaitForTheCommissionedDeviceToBeRetrieved_0();
            break;
        case 1:
            ChipLogProgress(chipTool, " ***** Test Step 1 : TH writes 0 to the Options attribute\n");
            if (ShouldSkip("CC.S.F00 && CC.S.A000f")) {
                NextTest();
                return;
            }
            err = TestThWrites0ToTheOptionsAttribute_1();
            break;
        case 2:
            ChipLogProgress(chipTool, " ***** Test Step 2 : TH sends On command to DUT\n");
            if (ShouldSkip("OO.S.C01.Rsp")) {
                NextTest();
                return;
            }
            err = TestThSendsOnCommandToDut_2();
            break;
        case 3:
            ChipLogProgress(chipTool,
                " ***** Test Step 3 : TH sends MoveToSaturation command to DUT with Saturation=200 and TransitionTime=0 "
                "(immediately)\n");
            if (ShouldSkip("CC.S.F00 && CC.S.C03.Rsp")) {
                NextTest();
                return;
            }
            err = TestThSendsMoveToSaturationCommandToDutWithSaturation200AndTransitionTime0Immediately_3();
            break;
        case 4:
            ChipLogProgress(chipTool, " ***** Test Step 4 : Wait 100ms\n");
            err = TestWait100ms_4();
            break;
        case 5:
            ChipLogProgress(chipTool,
                " ***** Test Step 5 : TH sends StepSaturation command to DUT with StepMode=0x01 (up), StepSize=40 and "
                "TransitionTime=200 (20s)\n");
            if (ShouldSkip("CC.S.F00 && CC.S.C05.Rsp")) {
                NextTest();
                return;
            }
            err = TestThSendsStepSaturationCommandToDutWithStepMode0x01UpStepSize40AndTransitionTime20020s_5();
            break;
        case 6:
            ChipLogProgress(chipTool, " ***** Test Step 6 : Wait 10s\n");
            err = TestWait10s_6();
            break;
        case 7:
            ChipLogProgress(chipTool, " ***** Test Step 7 : TH reads CurrentSaturation attribute from DUT\n");
            if (ShouldSkip("CC.S.F00 && CC.S.A0001")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentSaturationAttributeFromDut_7();
            break;
        case 8:
            ChipLogProgress(chipTool, " ***** Test Step 8 : Wait 10s\n");
            err = TestWait10s_8();
            break;
        case 9:
            ChipLogProgress(chipTool, " ***** Test Step 9 : TH reads CurrentSaturation attribute from DUT\n");
            if (ShouldSkip("CC.S.F00 && CC.S.A0001")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentSaturationAttributeFromDut_9();
            break;
        case 10:
            ChipLogProgress(chipTool, " ***** Test Step 10 : Wait 5s\n");
            err = TestWait5s_10();
            break;
        case 11:
            ChipLogProgress(chipTool, " ***** Test Step 11 : TH reads CurrentSaturation attribute from DUT\n");
            if (ShouldSkip("CC.S.F00 && CC.S.A0001")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentSaturationAttributeFromDut_11();
            break;
        case 12:
            ChipLogProgress(chipTool,
                " ***** Test Step 12 : TH sends StepSaturation command to DUT with StepMode=0x01 (up), StepSize=20 and "
                "TransitionTime=100 (10s)\n");
            if (ShouldSkip("CC.S.F00 && CC.S.C05.Rsp")) {
                NextTest();
                return;
            }
            err = TestThSendsStepSaturationCommandToDutWithStepMode0x01UpStepSize20AndTransitionTime10010s_12();
            break;
        case 13:
            ChipLogProgress(chipTool, " ***** Test Step 13 : Wait 10s\n");
            err = TestWait10s_13();
            break;
        case 14:
            ChipLogProgress(chipTool, " ***** Test Step 14 : TH reads CurrentSaturation attribute from DUT\n");
            if (ShouldSkip("CC.S.F00 && CC.S.A0001")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentSaturationAttributeFromDut_14();
            break;
        case 15:
            ChipLogProgress(chipTool,
                " ***** Test Step 15 : TH sends MoveToSaturation command to DUT with Saturation=50 and TransitionTime=0 "
                "(immediately)\n");
            if (ShouldSkip("CC.S.F00 && CC.S.C03.Rsp")) {
                NextTest();
                return;
            }
            err = TestThSendsMoveToSaturationCommandToDutWithSaturation50AndTransitionTime0Immediately_15();
            break;
        case 16:
            ChipLogProgress(chipTool, " ***** Test Step 16 : Wait 100ms\n");
            err = TestWait100ms_16();
            break;
        case 17:
            ChipLogProgress(chipTool,
                " ***** Test Step 17 : TH sends StepSaturation command to DUT with StepMode=0x03 (down), StepSize=40 and "
                "TransitionTime=200 (20s)\n");
            if (ShouldSkip("CC.S.F00 && CC.S.C05.Rsp")) {
                NextTest();
                return;
            }
            err = TestThSendsStepSaturationCommandToDutWithStepMode0x03DownStepSize40AndTransitionTime20020s_17();
            break;
        case 18:
            ChipLogProgress(chipTool, " ***** Test Step 18 : Wait 10s\n");
            err = TestWait10s_18();
            break;
        case 19:
            ChipLogProgress(chipTool, " ***** Test Step 19 : TH reads CurrentSaturation attribute from DUT\n");
            if (ShouldSkip("CC.S.F00 && CC.S.A0001")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentSaturationAttributeFromDut_19();
            break;
        case 20:
            ChipLogProgress(chipTool, " ***** Test Step 20 : Wait 10s\n");
            err = TestWait10s_20();
            break;
        case 21:
            ChipLogProgress(chipTool, " ***** Test Step 21 : TH reads CurrentSaturation attribute from DUT\n");
            if (ShouldSkip("CC.S.F00 && CC.S.A0001")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentSaturationAttributeFromDut_21();
            break;
        case 22:
            ChipLogProgress(chipTool, " ***** Test Step 22 : Wait 5s\n");
            err = TestWait5s_22();
            break;
        case 23:
            ChipLogProgress(chipTool, " ***** Test Step 23 : TH reads CurrentSaturation attribute from DUT\n");
            if (ShouldSkip("CC.S.F00 && CC.S.A0001")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentSaturationAttributeFromDut_23();
            break;
        case 24:
            ChipLogProgress(chipTool,
                " ***** Test Step 24 : TH sends StepSaturation command to DUT with StepMode=0x03 (down), StepSize=20 and "
                "TransitionTime=100 (10 s)\n");
            if (ShouldSkip("CC.S.F00 && CC.S.C05.Rsp")) {
                NextTest();
                return;
            }
            err = TestThSendsStepSaturationCommandToDutWithStepMode0x03DownStepSize20AndTransitionTime10010S_24();
            break;
        case 25:
            ChipLogProgress(chipTool, " ***** Test Step 25 : Wait 10s\n");
            err = TestWait10s_25();
            break;
        case 26:
            ChipLogProgress(chipTool, " ***** Test Step 26 : TH reads CurrentSaturation attribute from DUT\n");
            if (ShouldSkip("CC.S.F00 && CC.S.A0001")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentSaturationAttributeFromDut_26();
            break;
        case 27:
            ChipLogProgress(chipTool, " ***** Test Step 27 : TH reads ColorMode attribute from DUT\n");
            if (ShouldSkip("CC.S.F00 && CC.S.A0008")) {
                NextTest();
                return;
            }
            err = TestThReadsColorModeAttributeFromDut_27();
            break;
        case 28:
            ChipLogProgress(chipTool, " ***** Test Step 28 : TH reads EnhancedColorMode attribute from DUT\n");
            if (ShouldSkip("CC.S.F00 && CC.S.A4001")) {
                NextTest();
                return;
            }
            err = TestThReadsEnhancedColorModeAttributeFromDut_28();
            break;
        case 29:
            ChipLogProgress(chipTool, " ***** Test Step 29 : Turn off light that we turned on\n");
            if (ShouldSkip("OO.S.C00.Rsp")) {
                NextTest();
                return;
            }
            err = TestTurnOffLightThatWeTurnedOn_29();
            break;
        case 30:
            ChipLogProgress(chipTool, " ***** Test Step 30 : Check on/off attribute value is false after off command\n");
            if (ShouldSkip("OO.S.A0000")) {
                NextTest();
                return;
            }
            err = TestCheckOnOffAttributeValueIsFalseAfterOffCommand_30();
            break;
        }

        if (CHIP_NO_ERROR != err) {
            ChipLogError(chipTool, " ***** Test Failure: %s\n", chip::ErrorStr(err));
            SetCommandExitStatus(err);
        }
    }

    void OnStatusUpdate(const chip::app::StatusIB & status) override
    {
        switch (mTestIndex - 1) {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 6:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 7:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 8:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 9:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 10:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 11:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 12:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 13:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 14:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 15:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 16:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 17:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 18:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 19:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 20:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 21:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 22:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 23:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 24:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 25:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 26:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 27:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 28:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 29:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 30:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        }

        // Go on to the next test.
        ContinueOnChipMainThread(CHIP_NO_ERROR);
    }

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    std::atomic_uint16_t mTestIndex;
    const uint16_t mTestCount = 31;

    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    CHIP_ERROR TestWaitForTheCommissionedDeviceToBeRetrieved_0()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
        value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
        return WaitForCommissionee("alpha", value);
    }

    CHIP_ERROR TestThWrites0ToTheOptionsAttribute_1()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        id optionsArgument;
        optionsArgument = [NSNumber numberWithUnsignedChar:0U];
        [cluster writeAttributeOptionsWithValue:optionsArgument
                                     completion:^(NSError * _Nullable err) {
                                         NSLog(@"TH writes 0 to the Options attribute Error: %@", err);

                                         VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                                         NextTest();
                                     }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThSendsOnCommandToDut_2()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterOnOff alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster onWithCompletion:^(NSError * _Nullable err) {
            NSLog(@"TH sends On command to DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThSendsMoveToSaturationCommandToDutWithSaturation200AndTransitionTime0Immediately_3()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        __auto_type * params = [[MTRColorControlClusterMoveToSaturationParams alloc] init];
        params.saturation = [NSNumber numberWithUnsignedChar:200U];
        params.transitionTime = [NSNumber numberWithUnsignedShort:0U];
        params.optionsMask = [NSNumber numberWithUnsignedChar:0U];
        params.optionsOverride = [NSNumber numberWithUnsignedChar:0U];
        [cluster moveToSaturationWithParams:params
                                 completion:^(NSError * _Nullable err) {
                                     NSLog(@"TH sends MoveToSaturation command to DUT with Saturation=200 and TransitionTime=0 "
                                           @"(immediately) Error: %@",
                                         err);

                                     VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                                     NextTest();
                                 }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait100ms_4()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 100UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThSendsStepSaturationCommandToDutWithStepMode0x01UpStepSize40AndTransitionTime20020s_5()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        __auto_type * params = [[MTRColorControlClusterStepSaturationParams alloc] init];
        params.stepMode = [NSNumber numberWithUnsignedChar:1U];
        params.stepSize = [NSNumber numberWithUnsignedChar:40U];
        params.transitionTime = [NSNumber numberWithUnsignedChar:200U];
        params.optionsMask = [NSNumber numberWithUnsignedChar:0U];
        params.optionsOverride = [NSNumber numberWithUnsignedChar:0U];
        [cluster stepSaturationWithParams:params
                               completion:^(NSError * _Nullable err) {
                                   NSLog(@"TH sends StepSaturation command to DUT with StepMode=0x01 (up), StepSize=40 and "
                                         @"TransitionTime=200 (20s) Error: %@",
                                       err);

                                   VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                                   NextTest();
                               }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait10s_6()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 10000UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThReadsCurrentSaturationAttributeFromDut_7()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentSaturationWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentSaturation attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("currentSaturation", [value unsignedCharValue], 187U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("currentSaturation", [value unsignedCharValue], 253U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait10s_8()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 10000UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThReadsCurrentSaturationAttributeFromDut_9()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentSaturationWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentSaturation attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("currentSaturation", [value unsignedCharValue], 204U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("currentSaturation", [value unsignedCharValue], 254U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait5s_10()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 5000UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThReadsCurrentSaturationAttributeFromDut_11()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentSaturationWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentSaturation attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("currentSaturation", [value unsignedCharValue], 204U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("currentSaturation", [value unsignedCharValue], 254U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThSendsStepSaturationCommandToDutWithStepMode0x01UpStepSize20AndTransitionTime10010s_12()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        __auto_type * params = [[MTRColorControlClusterStepSaturationParams alloc] init];
        params.stepMode = [NSNumber numberWithUnsignedChar:1U];
        params.stepSize = [NSNumber numberWithUnsignedChar:20U];
        params.transitionTime = [NSNumber numberWithUnsignedChar:100U];
        params.optionsMask = [NSNumber numberWithUnsignedChar:0U];
        params.optionsOverride = [NSNumber numberWithUnsignedChar:0U];
        [cluster stepSaturationWithParams:params
                               completion:^(NSError * _Nullable err) {
                                   NSLog(@"TH sends StepSaturation command to DUT with StepMode=0x01 (up), StepSize=20 and "
                                         @"TransitionTime=100 (10s) Error: %@",
                                       err);

                                   VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                                   NextTest();
                               }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait10s_13()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 10000UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThReadsCurrentSaturationAttributeFromDut_14()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentSaturationWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentSaturation attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("currentSaturation", [value unsignedCharValue], 216U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("currentSaturation", [value unsignedCharValue], 254U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThSendsMoveToSaturationCommandToDutWithSaturation50AndTransitionTime0Immediately_15()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        __auto_type * params = [[MTRColorControlClusterMoveToSaturationParams alloc] init];
        params.saturation = [NSNumber numberWithUnsignedChar:50U];
        params.transitionTime = [NSNumber numberWithUnsignedShort:0U];
        params.optionsMask = [NSNumber numberWithUnsignedChar:0U];
        params.optionsOverride = [NSNumber numberWithUnsignedChar:0U];
        [cluster moveToSaturationWithParams:params
                                 completion:^(NSError * _Nullable err) {
                                     NSLog(@"TH sends MoveToSaturation command to DUT with Saturation=50 and TransitionTime=0 "
                                           @"(immediately) Error: %@",
                                         err);

                                     VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                                     NextTest();
                                 }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait100ms_16()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 100UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThSendsStepSaturationCommandToDutWithStepMode0x03DownStepSize40AndTransitionTime20020s_17()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        __auto_type * params = [[MTRColorControlClusterStepSaturationParams alloc] init];
        params.stepMode = [NSNumber numberWithUnsignedChar:3U];
        params.stepSize = [NSNumber numberWithUnsignedChar:40U];
        params.transitionTime = [NSNumber numberWithUnsignedChar:200U];
        params.optionsMask = [NSNumber numberWithUnsignedChar:0U];
        params.optionsOverride = [NSNumber numberWithUnsignedChar:0U];
        [cluster stepSaturationWithParams:params
                               completion:^(NSError * _Nullable err) {
                                   NSLog(@"TH sends StepSaturation command to DUT with StepMode=0x03 (down), StepSize=40 and "
                                         @"TransitionTime=200 (20s) Error: %@",
                                       err);

                                   VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                                   NextTest();
                               }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait10s_18()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 10000UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThReadsCurrentSaturationAttributeFromDut_19()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentSaturationWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentSaturation attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("currentSaturation", [value unsignedCharValue], 25U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("currentSaturation", [value unsignedCharValue], 35U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait10s_20()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 10000UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThReadsCurrentSaturationAttributeFromDut_21()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentSaturationWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentSaturation attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("currentSaturation", [value unsignedCharValue], 8U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("currentSaturation", [value unsignedCharValue], 12U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait5s_22()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 5000UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThReadsCurrentSaturationAttributeFromDut_23()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentSaturationWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentSaturation attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("currentSaturation", [value unsignedCharValue], 8U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("currentSaturation", [value unsignedCharValue], 12U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThSendsStepSaturationCommandToDutWithStepMode0x03DownStepSize20AndTransitionTime10010S_24()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        __auto_type * params = [[MTRColorControlClusterStepSaturationParams alloc] init];
        params.stepMode = [NSNumber numberWithUnsignedChar:3U];
        params.stepSize = [NSNumber numberWithUnsignedChar:20U];
        params.transitionTime = [NSNumber numberWithUnsignedChar:100U];
        params.optionsMask = [NSNumber numberWithUnsignedChar:0U];
        params.optionsOverride = [NSNumber numberWithUnsignedChar:0U];
        [cluster stepSaturationWithParams:params
                               completion:^(NSError * _Nullable err) {
                                   NSLog(@"TH sends StepSaturation command to DUT with StepMode=0x03 (down), StepSize=20 and "
                                         @"TransitionTime=100 (10 s) Error: %@",
                                       err);

                                   VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                                   NextTest();
                               }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait10s_25()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 10000UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThReadsCurrentSaturationAttributeFromDut_26()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentSaturationWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentSaturation attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("CurrentSaturation", actualValue, 0U));
            }

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsColorModeAttributeFromDut_27()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeColorModeWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads ColorMode attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("ColorMode", actualValue, 0U));
            }

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("colorMode", [value unsignedCharValue], 0U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("colorMode", [value unsignedCharValue], 2U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsEnhancedColorModeAttributeFromDut_28()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeEnhancedColorModeWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads EnhancedColorMode attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("EnhancedColorMode", actualValue, 0U));
            }

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("enhancedColorMode", [value unsignedCharValue], 0U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("enhancedColorMode", [value unsignedCharValue], 3U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestTurnOffLightThatWeTurnedOn_29()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterOnOff alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster offWithCompletion:^(NSError * _Nullable err) {
            NSLog(@"Turn off light that we turned on Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestCheckOnOffAttributeValueIsFalseAfterOffCommand_30()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterOnOff alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeOnOffWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Check on/off attribute value is false after off command Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("OnOff", actualValue, 0));
            }

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }
};

class Test_TC_CC_4_4 : public TestCommandBridge {
public:
    // NOLINTBEGIN(clang-analyzer-nullability.NullPassedToNonnull): Test constructor nullability not enforced
    Test_TC_CC_4_4()
        : TestCommandBridge("Test_TC_CC_4_4")
        , mTestIndex(0)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }
    // NOLINTEND(clang-analyzer-nullability.NullPassedToNonnull)

    ~Test_TC_CC_4_4() {}

    /////////// TestCommand Interface /////////
    void NextTest() override
    {
        CHIP_ERROR err = CHIP_NO_ERROR;

        if (0 == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Start: Test_TC_CC_4_4\n");
        }

        if (mTestCount == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Complete: Test_TC_CC_4_4\n");
            SetCommandExitStatus(CHIP_NO_ERROR);
            return;
        }

        Wait();

        // Ensure we increment mTestIndex before we start running the relevant
        // command.  That way if we lose the timeslice after we send the message
        // but before our function call returns, we won't end up with an
        // incorrect mTestIndex value observed when we get the response.
        switch (mTestIndex++) {
        case 0:
            ChipLogProgress(chipTool, " ***** Test Step 0 : Wait for the commissioned device to be retrieved\n");
            err = TestWaitForTheCommissionedDeviceToBeRetrieved_0();
            break;
        case 1:
            ChipLogProgress(chipTool, " ***** Test Step 1 : TH writes 0 to the Options attribute\n");
            if (ShouldSkip("CC.S.F00 && CC.S.A000f")) {
                NextTest();
                return;
            }
            err = TestThWrites0ToTheOptionsAttribute_1();
            break;
        case 2:
            ChipLogProgress(chipTool, " ***** Test Step 2 : TH sends On command to DUT\n");
            if (ShouldSkip("OO.S.C01.Rsp")) {
                NextTest();
                return;
            }
            err = TestThSendsOnCommandToDut_2();
            break;
        case 3:
            ChipLogProgress(chipTool,
                " ***** Test Step 3 : TH sends MoveToHueAndSaturation command to DUT with Hue=200, Saturation=50 and "
                "TransitionTime=0 (immediately)\n");
            if (ShouldSkip("CC.S.F00 && CC.S.C06.Rsp")) {
                NextTest();
                return;
            }
            err = TestThSendsMoveToHueAndSaturationCommandToDutWithHue200Saturation50AndTransitionTime0Immediately_3();
            break;
        case 4:
            ChipLogProgress(chipTool, " ***** Test Step 4 : Wait 100ms\n");
            err = TestWait100ms_4();
            break;
        case 5:
            ChipLogProgress(chipTool, " ***** Test Step 5 : TH reads CurrentHue attribute from DUT.\n");
            if (ShouldSkip("CC.S.F00 && CC.S.A0000 && CC.S.C06.Rsp")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentHueAttributeFromDut_5();
            break;
        case 6:
            ChipLogProgress(chipTool, " ***** Test Step 6 : TH reads CurrentSaturation attribute from DUT\n");
            if (ShouldSkip("CC.S.F00 && CC.S.A0001")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentSaturationAttributeFromDut_6();
            break;
        case 7:
            ChipLogProgress(chipTool,
                " ***** Test Step 7 : TH sends MoveToHueAndSaturation command to DUT with Hue=160, Saturation=80 and "
                "TransitionTime=200 (20s)\n");
            if (ShouldSkip("CC.S.F00 && CC.S.C06.Rsp")) {
                NextTest();
                return;
            }
            err = TestThSendsMoveToHueAndSaturationCommandToDutWithHue160Saturation80AndTransitionTime20020s_7();
            break;
        case 8:
            ChipLogProgress(chipTool, " ***** Test Step 8 : Wait 10s\n");
            err = TestWait10s_8();
            break;
        case 9:
            ChipLogProgress(chipTool, " ***** Test Step 9 : TH reads CurrentHue attribute from DUT\n");
            if (ShouldSkip("CC.S.F00 && CC.S.A0000")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentHueAttributeFromDut_9();
            break;
        case 10:
            ChipLogProgress(chipTool, " ***** Test Step 10 : TH reads CurrentSaturation attribute from DUT\n");
            if (ShouldSkip("CC.S.F00 && CC.S.A0001")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentSaturationAttributeFromDut_10();
            break;
        case 11:
            ChipLogProgress(chipTool, " ***** Test Step 11 : Wait 10s\n");
            err = TestWait10s_11();
            break;
        case 12:
            ChipLogProgress(chipTool, " ***** Test Step 12 : TH reads CurrentHue attribute from DUT\n");
            if (ShouldSkip("CC.S.F00 && CC.S.A0000")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentHueAttributeFromDut_12();
            break;
        case 13:
            ChipLogProgress(chipTool, " ***** Test Step 13 : TH reads CurrentSaturation attribute from DUT\n");
            if (ShouldSkip("CC.S.F00 && CC.S.A0001")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentSaturationAttributeFromDut_13();
            break;
        case 14:
            ChipLogProgress(chipTool, " ***** Test Step 14 : Wait 5s\n");
            err = TestWait5s_14();
            break;
        case 15:
            ChipLogProgress(chipTool, " ***** Test Step 15 : TH reads CurrentHue attribute from DUT\n");
            if (ShouldSkip("CC.S.F00 && CC.S.A0000")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentHueAttributeFromDut_15();
            break;
        case 16:
            ChipLogProgress(chipTool, " ***** Test Step 16 : TH reads CurrentSaturation attribute from DUT\n");
            if (ShouldSkip("CC.S.F00 && CC.S.A0001")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentSaturationAttributeFromDut_16();
            break;
        case 17:
            ChipLogProgress(chipTool, " ***** Test Step 17 : TH reads ColorMode attribute from DUT\n");
            if (ShouldSkip("CC.S.F00 && CC.S.A0008")) {
                NextTest();
                return;
            }
            err = TestThReadsColorModeAttributeFromDut_17();
            break;
        case 18:
            ChipLogProgress(chipTool, " ***** Test Step 18 : TH reads EnhancedColorMode attribute from DUT\n");
            if (ShouldSkip("CC.S.F00 && CC.S.A4001")) {
                NextTest();
                return;
            }
            err = TestThReadsEnhancedColorModeAttributeFromDut_18();
            break;
        case 19:
            ChipLogProgress(chipTool, " ***** Test Step 19 : Turn off light that we turned on\n");
            if (ShouldSkip("OO.S.C00.Rsp")) {
                NextTest();
                return;
            }
            err = TestTurnOffLightThatWeTurnedOn_19();
            break;
        case 20:
            ChipLogProgress(chipTool, " ***** Test Step 20 : Check on/off attribute value is false after off command\n");
            if (ShouldSkip("OO.S.A0000")) {
                NextTest();
                return;
            }
            err = TestCheckOnOffAttributeValueIsFalseAfterOffCommand_20();
            break;
        }

        if (CHIP_NO_ERROR != err) {
            ChipLogError(chipTool, " ***** Test Failure: %s\n", chip::ErrorStr(err));
            SetCommandExitStatus(err);
        }
    }

    void OnStatusUpdate(const chip::app::StatusIB & status) override
    {
        switch (mTestIndex - 1) {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 6:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 7:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 8:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 9:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 10:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 11:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 12:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 13:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 14:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 15:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 16:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 17:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 18:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 19:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 20:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        }

        // Go on to the next test.
        ContinueOnChipMainThread(CHIP_NO_ERROR);
    }

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    std::atomic_uint16_t mTestIndex;
    const uint16_t mTestCount = 21;

    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    CHIP_ERROR TestWaitForTheCommissionedDeviceToBeRetrieved_0()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
        value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
        return WaitForCommissionee("alpha", value);
    }

    CHIP_ERROR TestThWrites0ToTheOptionsAttribute_1()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        id optionsArgument;
        optionsArgument = [NSNumber numberWithUnsignedChar:0U];
        [cluster writeAttributeOptionsWithValue:optionsArgument
                                     completion:^(NSError * _Nullable err) {
                                         NSLog(@"TH writes 0 to the Options attribute Error: %@", err);

                                         VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                                         NextTest();
                                     }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThSendsOnCommandToDut_2()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterOnOff alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster onWithCompletion:^(NSError * _Nullable err) {
            NSLog(@"TH sends On command to DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThSendsMoveToHueAndSaturationCommandToDutWithHue200Saturation50AndTransitionTime0Immediately_3()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        __auto_type * params = [[MTRColorControlClusterMoveToHueAndSaturationParams alloc] init];
        params.hue = [NSNumber numberWithUnsignedChar:200U];
        params.saturation = [NSNumber numberWithUnsignedChar:50U];
        params.transitionTime = [NSNumber numberWithUnsignedShort:0U];
        params.optionsMask = [NSNumber numberWithUnsignedChar:0U];
        params.optionsOverride = [NSNumber numberWithUnsignedChar:0U];
        [cluster moveToHueAndSaturationWithParams:params
                                       completion:^(NSError * _Nullable err) {
                                           NSLog(@"TH sends MoveToHueAndSaturation command to DUT with Hue=200, Saturation=50 and "
                                                 @"TransitionTime=0 (immediately) Error: %@",
                                               err);

                                           VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                                           NextTest();
                                       }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait100ms_4()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 100UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThReadsCurrentHueAttributeFromDut_5()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentHueWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentHue attribute from DUT. Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("currentHue", [value unsignedCharValue], 170U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("currentHue", [value unsignedCharValue], 230U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsCurrentSaturationAttributeFromDut_6()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentSaturationWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentSaturation attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("currentSaturation", [value unsignedCharValue], 42U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("currentSaturation", [value unsignedCharValue], 58U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThSendsMoveToHueAndSaturationCommandToDutWithHue160Saturation80AndTransitionTime20020s_7()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        __auto_type * params = [[MTRColorControlClusterMoveToHueAndSaturationParams alloc] init];
        params.hue = [NSNumber numberWithUnsignedChar:160U];
        params.saturation = [NSNumber numberWithUnsignedChar:80U];
        params.transitionTime = [NSNumber numberWithUnsignedShort:200U];
        params.optionsMask = [NSNumber numberWithUnsignedChar:0U];
        params.optionsOverride = [NSNumber numberWithUnsignedChar:0U];
        [cluster moveToHueAndSaturationWithParams:params
                                       completion:^(NSError * _Nullable err) {
                                           NSLog(@"TH sends MoveToHueAndSaturation command to DUT with Hue=160, Saturation=80 and "
                                                 @"TransitionTime=200 (20s) Error: %@",
                                               err);

                                           VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                                           NextTest();
                                       }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait10s_8()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 10000UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThReadsCurrentHueAttributeFromDut_9()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentHueWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentHue attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("currentHue", [value unsignedCharValue], 160U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("currentHue", [value unsignedCharValue], 200U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsCurrentSaturationAttributeFromDut_10()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentSaturationWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentSaturation attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("currentSaturation", [value unsignedCharValue], 50U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("currentSaturation", [value unsignedCharValue], 80U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait10s_11()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 10000UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThReadsCurrentHueAttributeFromDut_12()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentHueWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentHue attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("currentHue", [value unsignedCharValue], 135U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("currentHue", [value unsignedCharValue], 185U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsCurrentSaturationAttributeFromDut_13()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentSaturationWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentSaturation attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("currentSaturation", "int8u", "int8u"));
            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("currentSaturation", [value unsignedCharValue], 68U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("currentSaturation", [value unsignedCharValue], 92U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait5s_14()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 5000UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThReadsCurrentHueAttributeFromDut_15()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentHueWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentHue attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("currentHue", [value unsignedCharValue], 135U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("currentHue", [value unsignedCharValue], 185U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsCurrentSaturationAttributeFromDut_16()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentSaturationWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentSaturation attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("currentSaturation", [value unsignedCharValue], 68U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("currentSaturation", [value unsignedCharValue], 92U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsColorModeAttributeFromDut_17()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeColorModeWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads ColorMode attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("ColorMode", actualValue, 0U));
            }

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("colorMode", [value unsignedCharValue], 0U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("colorMode", [value unsignedCharValue], 2U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsEnhancedColorModeAttributeFromDut_18()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeEnhancedColorModeWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads EnhancedColorMode attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("EnhancedColorMode", actualValue, 0U));
            }

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("enhancedColorMode", [value unsignedCharValue], 0U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("enhancedColorMode", [value unsignedCharValue], 3U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestTurnOffLightThatWeTurnedOn_19()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterOnOff alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster offWithCompletion:^(NSError * _Nullable err) {
            NSLog(@"Turn off light that we turned on Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestCheckOnOffAttributeValueIsFalseAfterOffCommand_20()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterOnOff alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeOnOffWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Check on/off attribute value is false after off command Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("OnOff", actualValue, 0));
            }

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }
};

class Test_TC_CC_5_1 : public TestCommandBridge {
public:
    // NOLINTBEGIN(clang-analyzer-nullability.NullPassedToNonnull): Test constructor nullability not enforced
    Test_TC_CC_5_1()
        : TestCommandBridge("Test_TC_CC_5_1")
        , mTestIndex(0)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }
    // NOLINTEND(clang-analyzer-nullability.NullPassedToNonnull)

    ~Test_TC_CC_5_1() {}

    /////////// TestCommand Interface /////////
    void NextTest() override
    {
        CHIP_ERROR err = CHIP_NO_ERROR;

        if (0 == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Start: Test_TC_CC_5_1\n");
        }

        if (mTestCount == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Complete: Test_TC_CC_5_1\n");
            SetCommandExitStatus(CHIP_NO_ERROR);
            return;
        }

        Wait();

        // Ensure we increment mTestIndex before we start running the relevant
        // command.  That way if we lose the timeslice after we send the message
        // but before our function call returns, we won't end up with an
        // incorrect mTestIndex value observed when we get the response.
        switch (mTestIndex++) {
        case 0:
            ChipLogProgress(chipTool, " ***** Test Step 0 : Wait for the commissioned device to be retrieved\n");
            err = TestWaitForTheCommissionedDeviceToBeRetrieved_0();
            break;
        case 1:
            ChipLogProgress(chipTool, " ***** Test Step 1 : TH writes 0 to the Options attribute\n");
            if (ShouldSkip("CC.S.F03 && CC.S.A000f")) {
                NextTest();
                return;
            }
            err = TestThWrites0ToTheOptionsAttribute_1();
            break;
        case 2:
            ChipLogProgress(chipTool, " ***** Test Step 2 : TH sends On command to DUT\n");
            if (ShouldSkip("OO.S.C01.Rsp")) {
                NextTest();
                return;
            }
            err = TestThSendsOnCommandToDut_2();
            break;
        case 3:
            ChipLogProgress(chipTool,
                " ***** Test Step 3 : TH sends MoveToColor command to DUT, with ColorX = 32768/0x8000 ColorY = 19660/0x4CCC "
                "TransitionTime = 0 (immediate)\n");
            if (ShouldSkip("CC.S.F03 && CC.S.C07.Rsp")) {
                NextTest();
                return;
            }
            err = TestThSendsMoveToColorCommandToDutWithColorX327680x8000ColorY196600x4CCCTransitionTime0Immediate_3();
            break;
        case 4:
            ChipLogProgress(chipTool, " ***** Test Step 4 : Wait 100ms\n");
            err = TestWait100ms_4();
            break;
        case 5:
            ChipLogProgress(chipTool, " ***** Test Step 5 : TH reads CurrentX attribute from DUT\n");
            if (ShouldSkip("CC.S.F03 && CC.S.A0003")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentXAttributeFromDut_5();
            break;
        case 6:
            ChipLogProgress(chipTool, " ***** Test Step 6 : TH reads CurrentY attribute from DUT\n");
            if (ShouldSkip("CC.S.F03 && CC.S.A0004")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentYAttributeFromDut_6();
            break;
        case 7:
            ChipLogProgress(chipTool,
                " ***** Test Step 7 : TH sends MoveToColor command to DUT, with ColorX = 13107/0x3333 ColorY = 13107/0x3333 "
                "TransitionTime = 200 (20s)\n");
            if (ShouldSkip("CC.S.F03 && CC.S.C07.Rsp")) {
                NextTest();
                return;
            }
            err = TestThSendsMoveToColorCommandToDutWithColorX131070x3333ColorY131070x3333TransitionTime20020s_7();
            break;
        case 8:
            ChipLogProgress(chipTool, " ***** Test Step 8 : Wait 10s\n");
            err = TestWait10s_8();
            break;
        case 9:
            ChipLogProgress(chipTool, " ***** Test Step 9 : TH reads CurrentX attribute from DUT\n");
            if (ShouldSkip("CC.S.F03 && CC.S.A0003 && CC.S.C07.Rsp")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentXAttributeFromDut_9();
            break;
        case 10:
            ChipLogProgress(chipTool, " ***** Test Step 10 : TH reads CurrentY attribute from DUT\n");
            if (ShouldSkip("CC.S.F03 && CC.S.A0004 && CC.S.C07.Rsp")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentYAttributeFromDut_10();
            break;
        case 11:
            ChipLogProgress(chipTool, " ***** Test Step 11 : Wait 10s\n");
            err = TestWait10s_11();
            break;
        case 12:
            ChipLogProgress(chipTool, " ***** Test Step 12 : TH reads CurrentX attribute from DUT\n");
            if (ShouldSkip("CC.S.F03 && CC.S.A0003 && CC.S.C07.Rsp")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentXAttributeFromDut_12();
            break;
        case 13:
            ChipLogProgress(chipTool, " ***** Test Step 13 : TH reads CurrentY attribute from DUT\n");
            if (ShouldSkip("CC.S.F03 && CC.S.A0004 && CC.S.C07.Rsp")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentYAttributeFromDut_13();
            break;
        case 14:
            ChipLogProgress(chipTool, " ***** Test Step 14 : Wait 5s\n");
            err = TestWait5s_14();
            break;
        case 15:
            ChipLogProgress(chipTool, " ***** Test Step 15 : TH reads CurrentX attribute from DUT\n");
            if (ShouldSkip("CC.S.F03 && CC.S.A0003 && CC.S.C07.Rsp")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentXAttributeFromDut_15();
            break;
        case 16:
            ChipLogProgress(chipTool, " ***** Test Step 16 : TH reads CurrentY attribute from DUT\n");
            if (ShouldSkip("CC.S.F03 && CC.S.A0004 && CC.S.C07.Rsp")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentYAttributeFromDut_16();
            break;
        case 17:
            ChipLogProgress(chipTool, " ***** Test Step 17 : TH writes 0 to the Options attribute\n");
            if (ShouldSkip("CC.S.A000f")) {
                NextTest();
                return;
            }
            err = TestThWrites0ToTheOptionsAttribute_17();
            break;
        case 18:
            ChipLogProgress(chipTool, " ***** Test Step 18 : TH read Options attribute\n");
            if (ShouldSkip("CC.S.A000f")) {
                NextTest();
                return;
            }
            err = TestThReadOptionsAttribute_18();
            break;
        case 19:
            ChipLogProgress(chipTool, " ***** Test Step 19 : TH sends On command to DUT\n");
            if (ShouldSkip("OO.S.C01.Rsp")) {
                NextTest();
                return;
            }
            err = TestThSendsOnCommandToDut_19();
            break;
        case 20:
            ChipLogProgress(chipTool,
                " ***** Test Step 20 : TH sends a MoveToColor command to the DUT with ColorX = 32768/0x8000 (x=0.5) (purple) "
                "ColorY = 19660/0x4CCC (y=0.3) TransitionTime = 0 (immediate)\n");
            if (ShouldSkip("CC.S.F03 && CC.S.C07.Rsp")) {
                NextTest();
                return;
            }
            err = TestThSendsAMoveToColorCommandToTheDutWithColorX327680x8000X05PurpleColorY196600x4CCCY03TransitionTime0Immediate_20();
            break;
        case 21:
            ChipLogProgress(chipTool, " ***** Test Step 21 : Wait 100ms\n");
            err = TestWait100ms_21();
            break;
        case 22:
            ChipLogProgress(chipTool, " ***** Test Step 22 : TH reads CurrentX attribute from DUT\n");
            if (ShouldSkip("CC.S.F03 && CC.S.A0003 && CC.S.C07.Rsp")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentXAttributeFromDut_22();
            break;
        case 23:
            ChipLogProgress(chipTool, " ***** Test Step 23 : TH reads CurrentY attribute from DUT\n");
            if (ShouldSkip("CC.S.F03 && CC.S.A0004 && CC.S.C07.Rsp")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentYAttributeFromDut_23();
            break;
        case 24:
            ChipLogProgress(chipTool, " ***** Test Step 24 : TH sends Off command to DUT\n");
            if (ShouldSkip("OO.S.C00.Rsp")) {
                NextTest();
                return;
            }
            err = TestThSendsOffCommandToDut_24();
            break;
        case 25:
            ChipLogProgress(chipTool,
                " ***** Test Step 25 : TH sends MoveToColor command to DUT, with ColorX = 13107/0x3333 ColorY = 13107/0x3333 "
                "TransitionTime = 0 (immediate)\n");
            if (ShouldSkip("CC.S.F03 && CC.S.C07.Rsp")) {
                NextTest();
                return;
            }
            err = TestThSendsMoveToColorCommandToDutWithColorX131070x3333ColorY131070x3333TransitionTime0Immediate_25();
            break;
        case 26:
            ChipLogProgress(chipTool, " ***** Test Step 26 : Wait 100ms\n");
            err = TestWait100ms_26();
            break;
        case 27:
            ChipLogProgress(chipTool, " ***** Test Step 27 : TH reads CurrentX attribute from DUT\n");
            if (ShouldSkip("CC.S.F03 && CC.S.A0003 && CC.S.C07.Rsp")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentXAttributeFromDut_27();
            break;
        case 28:
            ChipLogProgress(chipTool, " ***** Test Step 28 : TH reads CurrentY attribute from DUT\n");
            if (ShouldSkip("CC.S.F03 && CC.S.A0004 && CC.S.C07.Rsp")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentYAttributeFromDut_28();
            break;
        case 29:
            ChipLogProgress(chipTool,
                " ***** Test Step 29 : TH sends MoveToColor command to DUT, with ColorX = 13107/0x3333 ColorY = 32768/0x8000 "
                "TransitionTime = 0 (immediate)\n");
            if (ShouldSkip("CC.S.F03 && CC.S.C07.Rsp")) {
                NextTest();
                return;
            }
            err = TestThSendsMoveToColorCommandToDutWithColorX131070x3333ColorY327680x8000TransitionTime0Immediate_29();
            break;
        case 30:
            ChipLogProgress(chipTool, " ***** Test Step 30 : Wait 100ms\n");
            err = TestWait100ms_30();
            break;
        case 31:
            ChipLogProgress(chipTool, " ***** Test Step 31 : TH reads CurrentX attribute from DUT\n");
            if (ShouldSkip("CC.S.F03 && CC.S.A0003 && CC.S.C07.Rsp")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentXAttributeFromDut_31();
            break;
        case 32:
            ChipLogProgress(chipTool, " ***** Test Step 32 : TH reads CurrentY attribute from DUT\n");
            if (ShouldSkip("CC.S.F03 && CC.S.A0004 && CC.S.C07.Rsp")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentYAttributeFromDut_32();
            break;
        case 33:
            ChipLogProgress(chipTool,
                " ***** Test Step 33 : TH sends MoveToColor command to DUT, with ColorX = 26214/0x6666 ColorY = 32768/0x8000 "
                "TransitionTime = 0 (immediate)\n");
            if (ShouldSkip("CC.S.F03 && CC.S.C07.Rsp")) {
                NextTest();
                return;
            }
            err = TestThSendsMoveToColorCommandToDutWithColorX262140x6666ColorY327680x8000TransitionTime0Immediate_33();
            break;
        case 34:
            ChipLogProgress(chipTool, " ***** Test Step 34 : Wait 100ms\n");
            err = TestWait100ms_34();
            break;
        case 35:
            ChipLogProgress(chipTool, " ***** Test Step 35 : TH reads CurrentX attribute from DUT\n");
            if (ShouldSkip("CC.S.F03 && CC.S.A0003 && CC.S.C07.Rsp")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentXAttributeFromDut_35();
            break;
        case 36:
            ChipLogProgress(chipTool, " ***** Test Step 36 : TH reads CurrentY attribute from DUT\n");
            if (ShouldSkip("CC.S.F03 && CC.S.A0004 && CC.S.C07.Rsp")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentYAttributeFromDut_36();
            break;
        case 37:
            ChipLogProgress(chipTool, " ***** Test Step 37 : TH writes 1 to the Options attribute\n");
            if (ShouldSkip("CC.S.A000f")) {
                NextTest();
                return;
            }
            err = TestThWrites1ToTheOptionsAttribute_37();
            break;
        case 38:
            ChipLogProgress(chipTool, " ***** Test Step 38 : TH read Options attribute\n");
            if (ShouldSkip("CC.S.A000f")) {
                NextTest();
                return;
            }
            err = TestThReadOptionsAttribute_38();
            break;
        case 39:
            ChipLogProgress(chipTool, " ***** Test Step 39 : TH sends On command to DUT\n");
            if (ShouldSkip("OO.S.C01.Rsp")) {
                NextTest();
                return;
            }
            err = TestThSendsOnCommandToDut_39();
            break;
        case 40:
            ChipLogProgress(chipTool,
                " ***** Test Step 40 : TH sends MoveToColor command to DUT, with ColorX = 32768/0x8000 ColorY = 19660/0x4CCC "
                "TransitionTime = 0 (immediate)\n");
            if (ShouldSkip("CC.S.F03 && CC.S.C07.Rsp")) {
                NextTest();
                return;
            }
            err = TestThSendsMoveToColorCommandToDutWithColorX327680x8000ColorY196600x4CCCTransitionTime0Immediate_40();
            break;
        case 41:
            ChipLogProgress(chipTool, " ***** Test Step 41 : Wait 100ms\n");
            err = TestWait100ms_41();
            break;
        case 42:
            ChipLogProgress(chipTool, " ***** Test Step 42 : TH reads CurrentX attribute from DUT\n");
            if (ShouldSkip("CC.S.F03 && CC.S.A0003 && CC.S.C07.Rsp")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentXAttributeFromDut_42();
            break;
        case 43:
            ChipLogProgress(chipTool, " ***** Test Step 43 : TH reads CurrentY attribute from DUT\n");
            if (ShouldSkip("CC.S.F03 && CC.S.A0004 && CC.S.C07.Rsp")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentYAttributeFromDut_43();
            break;
        case 44:
            ChipLogProgress(chipTool, " ***** Test Step 44 : TH sends Off command to DUT\n");
            if (ShouldSkip("OO.S.C00.Rsp")) {
                NextTest();
                return;
            }
            err = TestThSendsOffCommandToDut_44();
            break;
        case 45:
            ChipLogProgress(chipTool,
                " ***** Test Step 45 : TH sends MoveToColor command to DUT, with ColorX = 13107/0x3333 ColorY = 13107/0x3333 "
                "TransitionTime = 0 (immediate)\n");
            if (ShouldSkip("CC.S.F03 && CC.S.C07.Rsp")) {
                NextTest();
                return;
            }
            err = TestThSendsMoveToColorCommandToDutWithColorX131070x3333ColorY131070x3333TransitionTime0Immediate_45();
            break;
        case 46:
            ChipLogProgress(chipTool, " ***** Test Step 46 : Wait 100ms\n");
            err = TestWait100ms_46();
            break;
        case 47:
            ChipLogProgress(chipTool, " ***** Test Step 47 : TH reads CurrentX attribute from DUT\n");
            if (ShouldSkip("CC.S.F03 && CC.S.A0003 && CC.S.C07.Rsp")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentXAttributeFromDut_47();
            break;
        case 48:
            ChipLogProgress(chipTool, " ***** Test Step 48 : TH reads CurrentY attribute from DUT\n");
            if (ShouldSkip("CC.S.F03 && CC.S.A0004 && CC.S.C07.Rsp")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentYAttributeFromDut_48();
            break;
        case 49:
            ChipLogProgress(chipTool,
                " ***** Test Step 49 : TH sends MoveToColor command to DUT, with ColorX = 13107/0x3333 ColorY = 32768/0x8000 "
                "TransitionTime = 0 (immediate)\n");
            if (ShouldSkip("CC.S.F03 && CC.S.C07.Rsp")) {
                NextTest();
                return;
            }
            err = TestThSendsMoveToColorCommandToDutWithColorX131070x3333ColorY327680x8000TransitionTime0Immediate_49();
            break;
        case 50:
            ChipLogProgress(chipTool, " ***** Test Step 50 : Wait 100ms\n");
            err = TestWait100ms_50();
            break;
        case 51:
            ChipLogProgress(chipTool, " ***** Test Step 51 : TH reads CurrentX attribute from DUT\n");
            if (ShouldSkip("CC.S.F03 && CC.S.A0003 && CC.S.C07.Rsp")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentXAttributeFromDut_51();
            break;
        case 52:
            ChipLogProgress(chipTool, " ***** Test Step 52 : TH reads CurrentY attribute from DUT\n");
            if (ShouldSkip("CC.S.F03 && CC.S.A0004 && CC.S.C07.Rsp")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentYAttributeFromDut_52();
            break;
        case 53:
            ChipLogProgress(chipTool,
                " ***** Test Step 53 : TH sends MoveToColor command to DUT, with ColorX = 26214/0x6666 ColorY = 32768/0x8000 "
                "TransitionTime = 0 (immediate)\n");
            if (ShouldSkip("CC.S.F03 && CC.S.C07.Rsp")) {
                NextTest();
                return;
            }
            err = TestThSendsMoveToColorCommandToDutWithColorX262140x6666ColorY327680x8000TransitionTime0Immediate_53();
            break;
        case 54:
            ChipLogProgress(chipTool, " ***** Test Step 54 : Wait 100ms\n");
            err = TestWait100ms_54();
            break;
        case 55:
            ChipLogProgress(chipTool, " ***** Test Step 55 : TH reads CurrentX attribute from DUT\n");
            if (ShouldSkip("CC.S.F03 && CC.S.A0003 && CC.S.C07.Rsp")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentXAttributeFromDut_55();
            break;
        case 56:
            ChipLogProgress(chipTool, " ***** Test Step 56 : TH reads CurrentY attribute from DUT\n");
            if (ShouldSkip("CC.S.F03 && CC.S.A0004 && CC.S.C07.Rsp")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentYAttributeFromDut_56();
            break;
        case 57:
            ChipLogProgress(chipTool, " ***** Test Step 57 : TH reads ColorMode attribute from DUT\n");
            if (ShouldSkip("CC.S.F03 && CC.S.A0008")) {
                NextTest();
                return;
            }
            err = TestThReadsColorModeAttributeFromDut_57();
            break;
        case 58:
            ChipLogProgress(chipTool, " ***** Test Step 58 : TH reads EnhancedColorMode attribute from DUT\n");
            if (ShouldSkip("CC.S.F03 && CC.S.A4001")) {
                NextTest();
                return;
            }
            err = TestThReadsEnhancedColorModeAttributeFromDut_58();
            break;
        }

        if (CHIP_NO_ERROR != err) {
            ChipLogError(chipTool, " ***** Test Failure: %s\n", chip::ErrorStr(err));
            SetCommandExitStatus(err);
        }
    }

    void OnStatusUpdate(const chip::app::StatusIB & status) override
    {
        switch (mTestIndex - 1) {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 6:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 7:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 8:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 9:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 10:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 11:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 12:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 13:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 14:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 15:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 16:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 17:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 18:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 19:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 20:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 21:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 22:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 23:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 24:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 25:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 26:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 27:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 28:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 29:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 30:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 31:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 32:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 33:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 34:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 35:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 36:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 37:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 38:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 39:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 40:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 41:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 42:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 43:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 44:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 45:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 46:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 47:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 48:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 49:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 50:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 51:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 52:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 53:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 54:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 55:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 56:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 57:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 58:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        }

        // Go on to the next test.
        ContinueOnChipMainThread(CHIP_NO_ERROR);
    }

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    std::atomic_uint16_t mTestIndex;
    const uint16_t mTestCount = 59;

    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    CHIP_ERROR TestWaitForTheCommissionedDeviceToBeRetrieved_0()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
        value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
        return WaitForCommissionee("alpha", value);
    }

    CHIP_ERROR TestThWrites0ToTheOptionsAttribute_1()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        id optionsArgument;
        optionsArgument = [NSNumber numberWithUnsignedChar:0U];
        [cluster writeAttributeOptionsWithValue:optionsArgument
                                     completion:^(NSError * _Nullable err) {
                                         NSLog(@"TH writes 0 to the Options attribute Error: %@", err);

                                         VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                                         NextTest();
                                     }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThSendsOnCommandToDut_2()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterOnOff alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster onWithCompletion:^(NSError * _Nullable err) {
            NSLog(@"TH sends On command to DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThSendsMoveToColorCommandToDutWithColorX327680x8000ColorY196600x4CCCTransitionTime0Immediate_3()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        __auto_type * params = [[MTRColorControlClusterMoveToColorParams alloc] init];
        params.colorX = [NSNumber numberWithUnsignedShort:32768U];
        params.colorY = [NSNumber numberWithUnsignedShort:19660U];
        params.transitionTime = [NSNumber numberWithUnsignedShort:0U];
        params.optionsMask = [NSNumber numberWithUnsignedChar:0U];
        params.optionsOverride = [NSNumber numberWithUnsignedChar:0U];
        [cluster moveToColorWithParams:params
                            completion:^(NSError * _Nullable err) {
                                NSLog(@"TH sends MoveToColor command to DUT, with ColorX = 32768/0x8000 ColorY = 19660/0x4CCC "
                                      @"TransitionTime = 0 (immediate) Error: %@",
                                    err);

                                VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                                NextTest();
                            }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait100ms_4()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 100UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThReadsCurrentXAttributeFromDut_5()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentXWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentX attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("currentX", [value unsignedShortValue], 27853U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("currentX", [value unsignedShortValue], 37683U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsCurrentYAttributeFromDut_6()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentYWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentY attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("currentY", [value unsignedShortValue], 16711U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("currentY", [value unsignedShortValue], 22609U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThSendsMoveToColorCommandToDutWithColorX131070x3333ColorY131070x3333TransitionTime20020s_7()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        __auto_type * params = [[MTRColorControlClusterMoveToColorParams alloc] init];
        params.colorX = [NSNumber numberWithUnsignedShort:13107U];
        params.colorY = [NSNumber numberWithUnsignedShort:13107U];
        params.transitionTime = [NSNumber numberWithUnsignedShort:200U];
        params.optionsMask = [NSNumber numberWithUnsignedChar:0U];
        params.optionsOverride = [NSNumber numberWithUnsignedChar:0U];
        [cluster moveToColorWithParams:params
                            completion:^(NSError * _Nullable err) {
                                NSLog(@"TH sends MoveToColor command to DUT, with ColorX = 13107/0x3333 ColorY = 13107/0x3333 "
                                      @"TransitionTime = 200 (20s) Error: %@",
                                    err);

                                VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                                NextTest();
                            }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait10s_8()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 10000UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThReadsCurrentXAttributeFromDut_9()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentXWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentX attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("currentX", [value unsignedShortValue], 13107U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("currentX", [value unsignedShortValue], 32768U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsCurrentYAttributeFromDut_10()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentYWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentY attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("currentY", [value unsignedShortValue], 13107U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("currentY", [value unsignedShortValue], 19660U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait10s_11()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 10000UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThReadsCurrentXAttributeFromDut_12()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentXWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentX attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("currentX", [value unsignedShortValue], 11141U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("currentX", [value unsignedShortValue], 15073U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsCurrentYAttributeFromDut_13()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentYWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentY attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("currentY", [value unsignedShortValue], 11141U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("currentY", [value unsignedShortValue], 15073U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait5s_14()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 5000UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThReadsCurrentXAttributeFromDut_15()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentXWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentX attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("currentX", [value unsignedShortValue], 11141U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("currentX", [value unsignedShortValue], 15073U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsCurrentYAttributeFromDut_16()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentYWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentY attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("currentY", [value unsignedShortValue], 11141U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("currentY", [value unsignedShortValue], 15073U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThWrites0ToTheOptionsAttribute_17()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        id optionsArgument;
        optionsArgument = [NSNumber numberWithUnsignedChar:0U];
        [cluster writeAttributeOptionsWithValue:optionsArgument
                                     completion:^(NSError * _Nullable err) {
                                         NSLog(@"TH writes 0 to the Options attribute Error: %@", err);

                                         VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                                         NextTest();
                                     }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadOptionsAttribute_18()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeOptionsWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH read Options attribute Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("Options", actualValue, 0U));
            }

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThSendsOnCommandToDut_19()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterOnOff alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster onWithCompletion:^(NSError * _Nullable err) {
            NSLog(@"TH sends On command to DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThSendsAMoveToColorCommandToTheDutWithColorX327680x8000X05PurpleColorY196600x4CCCY03TransitionTime0Immediate_20()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        __auto_type * params = [[MTRColorControlClusterMoveToColorParams alloc] init];
        params.colorX = [NSNumber numberWithUnsignedShort:32768U];
        params.colorY = [NSNumber numberWithUnsignedShort:19660U];
        params.transitionTime = [NSNumber numberWithUnsignedShort:0U];
        params.optionsMask = [NSNumber numberWithUnsignedChar:0U];
        params.optionsOverride = [NSNumber numberWithUnsignedChar:0U];
        [cluster moveToColorWithParams:params
                            completion:^(NSError * _Nullable err) {
                                NSLog(@"TH sends a MoveToColor command to the DUT with ColorX = 32768/0x8000 (x=0.5) (purple) "
                                      @"ColorY = 19660/0x4CCC (y=0.3) TransitionTime = 0 (immediate) Error: %@",
                                    err);

                                VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                                NextTest();
                            }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait100ms_21()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 100UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThReadsCurrentXAttributeFromDut_22()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentXWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentX attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("currentX", [value unsignedShortValue], 27853U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("currentX", [value unsignedShortValue], 37683U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsCurrentYAttributeFromDut_23()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentYWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentY attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("currentY", [value unsignedShortValue], 16711U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("currentY", [value unsignedShortValue], 22609U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThSendsOffCommandToDut_24()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterOnOff alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster offWithCompletion:^(NSError * _Nullable err) {
            NSLog(@"TH sends Off command to DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThSendsMoveToColorCommandToDutWithColorX131070x3333ColorY131070x3333TransitionTime0Immediate_25()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        __auto_type * params = [[MTRColorControlClusterMoveToColorParams alloc] init];
        params.colorX = [NSNumber numberWithUnsignedShort:13107U];
        params.colorY = [NSNumber numberWithUnsignedShort:13107U];
        params.transitionTime = [NSNumber numberWithUnsignedShort:0U];
        params.optionsMask = [NSNumber numberWithUnsignedChar:0U];
        params.optionsOverride = [NSNumber numberWithUnsignedChar:0U];
        [cluster moveToColorWithParams:params
                            completion:^(NSError * _Nullable err) {
                                NSLog(@"TH sends MoveToColor command to DUT, with ColorX = 13107/0x3333 ColorY = 13107/0x3333 "
                                      @"TransitionTime = 0 (immediate) Error: %@",
                                    err);

                                VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                                NextTest();
                            }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait100ms_26()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 100UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThReadsCurrentXAttributeFromDut_27()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentXWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentX attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("CurrentX", actualValue, 32768U));
            }

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsCurrentYAttributeFromDut_28()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentYWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentY attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("CurrentY", actualValue, 19660U));
            }

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThSendsMoveToColorCommandToDutWithColorX131070x3333ColorY327680x8000TransitionTime0Immediate_29()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        __auto_type * params = [[MTRColorControlClusterMoveToColorParams alloc] init];
        params.colorX = [NSNumber numberWithUnsignedShort:13107U];
        params.colorY = [NSNumber numberWithUnsignedShort:32768U];
        params.transitionTime = [NSNumber numberWithUnsignedShort:0U];
        params.optionsMask = [NSNumber numberWithUnsignedChar:1U];
        params.optionsOverride = [NSNumber numberWithUnsignedChar:0U];
        [cluster moveToColorWithParams:params
                            completion:^(NSError * _Nullable err) {
                                NSLog(@"TH sends MoveToColor command to DUT, with ColorX = 13107/0x3333 ColorY = 32768/0x8000 "
                                      @"TransitionTime = 0 (immediate) Error: %@",
                                    err);

                                VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                                NextTest();
                            }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait100ms_30()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 100UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThReadsCurrentXAttributeFromDut_31()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentXWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentX attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("CurrentX", actualValue, 32768U));
            }

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsCurrentYAttributeFromDut_32()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentYWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentY attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("CurrentY", actualValue, 19660U));
            }

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThSendsMoveToColorCommandToDutWithColorX262140x6666ColorY327680x8000TransitionTime0Immediate_33()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        __auto_type * params = [[MTRColorControlClusterMoveToColorParams alloc] init];
        params.colorX = [NSNumber numberWithUnsignedShort:26214U];
        params.colorY = [NSNumber numberWithUnsignedShort:32768U];
        params.transitionTime = [NSNumber numberWithUnsignedShort:0U];
        params.optionsMask = [NSNumber numberWithUnsignedChar:1U];
        params.optionsOverride = [NSNumber numberWithUnsignedChar:1U];
        [cluster moveToColorWithParams:params
                            completion:^(NSError * _Nullable err) {
                                NSLog(@"TH sends MoveToColor command to DUT, with ColorX = 26214/0x6666 ColorY = 32768/0x8000 "
                                      @"TransitionTime = 0 (immediate) Error: %@",
                                    err);

                                VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                                NextTest();
                            }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait100ms_34()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 100UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThReadsCurrentXAttributeFromDut_35()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentXWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentX attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("currentX", [value unsignedShortValue], 22282U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("currentX", [value unsignedShortValue], 30146U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsCurrentYAttributeFromDut_36()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentYWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentY attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("currentY", [value unsignedShortValue], 27853U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("currentY", [value unsignedShortValue], 37683U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThWrites1ToTheOptionsAttribute_37()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        id optionsArgument;
        optionsArgument = [NSNumber numberWithUnsignedChar:1U];
        [cluster writeAttributeOptionsWithValue:optionsArgument
                                     completion:^(NSError * _Nullable err) {
                                         NSLog(@"TH writes 1 to the Options attribute Error: %@", err);

                                         VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                                         NextTest();
                                     }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadOptionsAttribute_38()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeOptionsWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH read Options attribute Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("Options", actualValue, 1U));
            }

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThSendsOnCommandToDut_39()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterOnOff alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster onWithCompletion:^(NSError * _Nullable err) {
            NSLog(@"TH sends On command to DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThSendsMoveToColorCommandToDutWithColorX327680x8000ColorY196600x4CCCTransitionTime0Immediate_40()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        __auto_type * params = [[MTRColorControlClusterMoveToColorParams alloc] init];
        params.colorX = [NSNumber numberWithUnsignedShort:32768U];
        params.colorY = [NSNumber numberWithUnsignedShort:19660U];
        params.transitionTime = [NSNumber numberWithUnsignedShort:0U];
        params.optionsMask = [NSNumber numberWithUnsignedChar:0U];
        params.optionsOverride = [NSNumber numberWithUnsignedChar:0U];
        [cluster moveToColorWithParams:params
                            completion:^(NSError * _Nullable err) {
                                NSLog(@"TH sends MoveToColor command to DUT, with ColorX = 32768/0x8000 ColorY = 19660/0x4CCC "
                                      @"TransitionTime = 0 (immediate) Error: %@",
                                    err);

                                VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                                NextTest();
                            }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait100ms_41()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 100UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThReadsCurrentXAttributeFromDut_42()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentXWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentX attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("currentX", [value unsignedShortValue], 27853U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("currentX", [value unsignedShortValue], 37683U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsCurrentYAttributeFromDut_43()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentYWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentY attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("currentY", [value unsignedShortValue], 16711U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("currentY", [value unsignedShortValue], 22609U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThSendsOffCommandToDut_44()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterOnOff alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster offWithCompletion:^(NSError * _Nullable err) {
            NSLog(@"TH sends Off command to DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThSendsMoveToColorCommandToDutWithColorX131070x3333ColorY131070x3333TransitionTime0Immediate_45()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        __auto_type * params = [[MTRColorControlClusterMoveToColorParams alloc] init];
        params.colorX = [NSNumber numberWithUnsignedShort:13107U];
        params.colorY = [NSNumber numberWithUnsignedShort:13107U];
        params.transitionTime = [NSNumber numberWithUnsignedShort:0U];
        params.optionsMask = [NSNumber numberWithUnsignedChar:0U];
        params.optionsOverride = [NSNumber numberWithUnsignedChar:0U];
        [cluster moveToColorWithParams:params
                            completion:^(NSError * _Nullable err) {
                                NSLog(@"TH sends MoveToColor command to DUT, with ColorX = 13107/0x3333 ColorY = 13107/0x3333 "
                                      @"TransitionTime = 0 (immediate) Error: %@",
                                    err);

                                VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                                NextTest();
                            }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait100ms_46()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 100UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThReadsCurrentXAttributeFromDut_47()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentXWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentX attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("currentX", [value unsignedShortValue], 11141U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("currentX", [value unsignedShortValue], 15073U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsCurrentYAttributeFromDut_48()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentYWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentY attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("currentY", [value unsignedShortValue], 11141U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("currentY", [value unsignedShortValue], 15073U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThSendsMoveToColorCommandToDutWithColorX131070x3333ColorY327680x8000TransitionTime0Immediate_49()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        __auto_type * params = [[MTRColorControlClusterMoveToColorParams alloc] init];
        params.colorX = [NSNumber numberWithUnsignedShort:13107U];
        params.colorY = [NSNumber numberWithUnsignedShort:32768U];
        params.transitionTime = [NSNumber numberWithUnsignedShort:0U];
        params.optionsMask = [NSNumber numberWithUnsignedChar:1U];
        params.optionsOverride = [NSNumber numberWithUnsignedChar:0U];
        [cluster moveToColorWithParams:params
                            completion:^(NSError * _Nullable err) {
                                NSLog(@"TH sends MoveToColor command to DUT, with ColorX = 13107/0x3333 ColorY = 32768/0x8000 "
                                      @"TransitionTime = 0 (immediate) Error: %@",
                                    err);

                                VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                                NextTest();
                            }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait100ms_50()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 100UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThReadsCurrentXAttributeFromDut_51()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentXWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentX attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("CurrentX", actualValue, 13107U));
            }

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsCurrentYAttributeFromDut_52()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentYWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentY attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("CurrentY", actualValue, 13107U));
            }

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThSendsMoveToColorCommandToDutWithColorX262140x6666ColorY327680x8000TransitionTime0Immediate_53()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        __auto_type * params = [[MTRColorControlClusterMoveToColorParams alloc] init];
        params.colorX = [NSNumber numberWithUnsignedShort:26214U];
        params.colorY = [NSNumber numberWithUnsignedShort:32768U];
        params.transitionTime = [NSNumber numberWithUnsignedShort:0U];
        params.optionsMask = [NSNumber numberWithUnsignedChar:1U];
        params.optionsOverride = [NSNumber numberWithUnsignedChar:1U];
        [cluster moveToColorWithParams:params
                            completion:^(NSError * _Nullable err) {
                                NSLog(@"TH sends MoveToColor command to DUT, with ColorX = 26214/0x6666 ColorY = 32768/0x8000 "
                                      @"TransitionTime = 0 (immediate) Error: %@",
                                    err);

                                VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                                NextTest();
                            }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait100ms_54()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 100UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThReadsCurrentXAttributeFromDut_55()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentXWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentX attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("currentX", [value unsignedShortValue], 22282U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("currentX", [value unsignedShortValue], 30146U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsCurrentYAttributeFromDut_56()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentYWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentY attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("currentY", [value unsignedShortValue], 27853U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("currentY", [value unsignedShortValue], 37683U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsColorModeAttributeFromDut_57()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeColorModeWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads ColorMode attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("ColorMode", actualValue, 1U));
            }

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("colorMode", [value unsignedCharValue], 0U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("colorMode", [value unsignedCharValue], 2U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsEnhancedColorModeAttributeFromDut_58()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeEnhancedColorModeWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads EnhancedColorMode attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("EnhancedColorMode", actualValue, 1U));
            }

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("enhancedColorMode", [value unsignedCharValue], 0U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("enhancedColorMode", [value unsignedCharValue], 3U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }
};

class Test_TC_CC_5_2 : public TestCommandBridge {
public:
    // NOLINTBEGIN(clang-analyzer-nullability.NullPassedToNonnull): Test constructor nullability not enforced
    Test_TC_CC_5_2()
        : TestCommandBridge("Test_TC_CC_5_2")
        , mTestIndex(0)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }
    // NOLINTEND(clang-analyzer-nullability.NullPassedToNonnull)

    ~Test_TC_CC_5_2() {}

    /////////// TestCommand Interface /////////
    void NextTest() override
    {
        CHIP_ERROR err = CHIP_NO_ERROR;

        if (0 == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Start: Test_TC_CC_5_2\n");
        }

        if (mTestCount == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Complete: Test_TC_CC_5_2\n");
            SetCommandExitStatus(CHIP_NO_ERROR);
            return;
        }

        Wait();

        // Ensure we increment mTestIndex before we start running the relevant
        // command.  That way if we lose the timeslice after we send the message
        // but before our function call returns, we won't end up with an
        // incorrect mTestIndex value observed when we get the response.
        switch (mTestIndex++) {
        case 0:
            ChipLogProgress(chipTool, " ***** Test Step 0 : Wait for the commissioned device to be retrieved\n");
            err = TestWaitForTheCommissionedDeviceToBeRetrieved_0();
            break;
        case 1:
            ChipLogProgress(chipTool, " ***** Test Step 1 : TH writes 0 to the Options attribute\n");
            if (ShouldSkip("CC.S.F03 && CC.S.A000f")) {
                NextTest();
                return;
            }
            err = TestThWrites0ToTheOptionsAttribute_1();
            break;
        case 2:
            ChipLogProgress(chipTool, " ***** Test Step 2 : TH sends On command to DUT\n");
            if (ShouldSkip("OO.S.C01.Rsp")) {
                NextTest();
                return;
            }
            err = TestThSendsOnCommandToDut_2();
            break;
        case 3:
            ChipLogProgress(chipTool,
                " ***** Test Step 3 : TH sends MoveToColor command to DUT, with ColorX = 33000 ColorY = 26000 TransitionTime = 0 "
                "(immediate)\n");
            if (ShouldSkip("CC.S.F03 && CC.S.C07.Rsp")) {
                NextTest();
                return;
            }
            err = TestThSendsMoveToColorCommandToDutWithColorX33000ColorY26000TransitionTime0Immediate_3();
            break;
        case 4:
            ChipLogProgress(chipTool, " ***** Test Step 4 : Wait 100ms\n");
            err = TestWait100ms_4();
            break;
        case 5:
            ChipLogProgress(chipTool, " ***** Test Step 5 : TH sends MoveColor command to DUT\n");
            if (ShouldSkip("CC.S.F03 && CC.S.C08.Rsp")) {
                NextTest();
                return;
            }
            err = TestThSendsMoveColorCommandToDut_5();
            break;
        case 6:
            ChipLogProgress(chipTool, " ***** Test Step 6 : Wait 10s\n");
            err = TestWait10s_6();
            break;
        case 7:
            ChipLogProgress(chipTool, " ***** Test Step 7 : TH reads CurrentX attribute from DUT\n");
            if (ShouldSkip("CC.S.F03 && CC.S.A0003 && CC.S.C08.Rsp")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentXAttributeFromDut_7();
            break;
        case 8:
            ChipLogProgress(chipTool, " ***** Test Step 8 : TH reads CurrentY attribute from DUT\n");
            if (ShouldSkip("CC.S.F03 && CC.S.A0004 && CC.S.C08.Rsp")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentYAttributeFromDut_8();
            break;
        case 9:
            ChipLogProgress(chipTool, " ***** Test Step 9 : Wait 10s\n");
            err = TestWait10s_9();
            break;
        case 10:
            ChipLogProgress(chipTool, " ***** Test Step 10 : TH reads CurrentX attribute from DUT\n");
            if (ShouldSkip("CC.S.F03 && CC.S.A0003 && CC.S.C08.Rsp")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentXAttributeFromDut_10();
            break;
        case 11:
            ChipLogProgress(chipTool, " ***** Test Step 11 : TH reads CurrentY attribute from DUT\n");
            if (ShouldSkip("CC.S.F03 && CC.S.A0004 && CC.S.C08.Rsp")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentYAttributeFromDut_11();
            break;
        case 12:
            ChipLogProgress(chipTool, " ***** Test Step 12 : Wait 10s\n");
            err = TestWait10s_12();
            break;
        case 13:
            ChipLogProgress(chipTool, " ***** Test Step 13 : TH reads CurrentX attribute from DUT\n");
            if (ShouldSkip("CC.S.F03 && CC.S.A0003 && CC.S.C08.Rsp")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentXAttributeFromDut_13();
            break;
        case 14:
            ChipLogProgress(chipTool, " ***** Test Step 14 : TH reads CurrentY attribute from DUT\n");
            if (ShouldSkip("CC.S.F03 && CC.S.A0004 && CC.S.C08.Rsp")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentYAttributeFromDut_14();
            break;
        case 15:
            ChipLogProgress(chipTool, " ***** Test Step 15 : TH sends StopMoveStep command to DUT\n");
            if (ShouldSkip("CC.S.F03 && CC.S.C47.Rsp")) {
                NextTest();
                return;
            }
            err = TestThSendsStopMoveStepCommandToDut_15();
            break;
        case 16:
            ChipLogProgress(chipTool, " ***** Test Step 16 : TH reads CurrentX attribute from DUT\n");
            if (ShouldSkip("CC.S.F03 && CC.S.A0003 && CC.S.C08.Rsp")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentXAttributeFromDut_16();
            break;
        case 17:
            ChipLogProgress(chipTool, " ***** Test Step 17 : TH reads CurrentY attribute from DUT\n");
            if (ShouldSkip("CC.S.F03 && CC.S.A0004 && CC.S.C08.Rsp")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentYAttributeFromDut_17();
            break;
        case 18:
            ChipLogProgress(chipTool, " ***** Test Step 18 : TH reads ColorMode attribute from DUT\n");
            if (ShouldSkip("CC.S.F03 && CC.S.A0008")) {
                NextTest();
                return;
            }
            err = TestThReadsColorModeAttributeFromDut_18();
            break;
        case 19:
            ChipLogProgress(chipTool, " ***** Test Step 19 : TH reads EnhancedColorMode attribute from DUT\n");
            if (ShouldSkip("CC.S.F03 && CC.S.A4001")) {
                NextTest();
                return;
            }
            err = TestThReadsEnhancedColorModeAttributeFromDut_19();
            break;
        case 20:
            ChipLogProgress(chipTool, " ***** Test Step 20 : Turn off light that we turned on\n");
            if (ShouldSkip("OO.S.C00.Rsp")) {
                NextTest();
                return;
            }
            err = TestTurnOffLightThatWeTurnedOn_20();
            break;
        case 21:
            ChipLogProgress(chipTool, " ***** Test Step 21 : Check on/off attribute value is false after off command\n");
            if (ShouldSkip("OO.S.A0000")) {
                NextTest();
                return;
            }
            err = TestCheckOnOffAttributeValueIsFalseAfterOffCommand_21();
            break;
        }

        if (CHIP_NO_ERROR != err) {
            ChipLogError(chipTool, " ***** Test Failure: %s\n", chip::ErrorStr(err));
            SetCommandExitStatus(err);
        }
    }

    void OnStatusUpdate(const chip::app::StatusIB & status) override
    {
        switch (mTestIndex - 1) {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 6:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 7:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 8:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 9:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 10:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 11:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 12:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 13:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 14:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 15:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 16:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 17:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 18:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 19:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 20:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 21:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        }

        // Go on to the next test.
        ContinueOnChipMainThread(CHIP_NO_ERROR);
    }

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    std::atomic_uint16_t mTestIndex;
    const uint16_t mTestCount = 22;

    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    CHIP_ERROR TestWaitForTheCommissionedDeviceToBeRetrieved_0()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
        value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
        return WaitForCommissionee("alpha", value);
    }

    CHIP_ERROR TestThWrites0ToTheOptionsAttribute_1()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        id optionsArgument;
        optionsArgument = [NSNumber numberWithUnsignedChar:0U];
        [cluster writeAttributeOptionsWithValue:optionsArgument
                                     completion:^(NSError * _Nullable err) {
                                         NSLog(@"TH writes 0 to the Options attribute Error: %@", err);

                                         VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                                         NextTest();
                                     }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThSendsOnCommandToDut_2()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterOnOff alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster onWithCompletion:^(NSError * _Nullable err) {
            NSLog(@"TH sends On command to DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThSendsMoveToColorCommandToDutWithColorX33000ColorY26000TransitionTime0Immediate_3()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        __auto_type * params = [[MTRColorControlClusterMoveToColorParams alloc] init];
        params.colorX = [NSNumber numberWithUnsignedShort:33000U];
        params.colorY = [NSNumber numberWithUnsignedShort:26000U];
        params.transitionTime = [NSNumber numberWithUnsignedShort:0U];
        params.optionsMask = [NSNumber numberWithUnsignedChar:0U];
        params.optionsOverride = [NSNumber numberWithUnsignedChar:0U];
        [cluster moveToColorWithParams:params
                            completion:^(NSError * _Nullable err) {
                                NSLog(@"TH sends MoveToColor command to DUT, with ColorX = 33000 ColorY = 26000 TransitionTime = 0 "
                                      @"(immediate) Error: %@",
                                    err);

                                VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                                NextTest();
                            }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait100ms_4()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 100UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThSendsMoveColorCommandToDut_5()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        __auto_type * params = [[MTRColorControlClusterMoveColorParams alloc] init];
        params.rateX = [NSNumber numberWithShort:-100];
        params.rateY = [NSNumber numberWithShort:100];
        params.optionsMask = [NSNumber numberWithUnsignedChar:0U];
        params.optionsOverride = [NSNumber numberWithUnsignedChar:0U];
        [cluster moveColorWithParams:params
                          completion:^(NSError * _Nullable err) {
                              NSLog(@"TH sends MoveColor command to DUT Error: %@", err);

                              VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                              NextTest();
                          }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait10s_6()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 10000UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThReadsCurrentXAttributeFromDut_7()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentXWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentX attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("currentX", [value unsignedShortValue], 27200U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("currentX", [value unsignedShortValue], 36800U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsCurrentYAttributeFromDut_8()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentYWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentY attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("currentY", [value unsignedShortValue], 22900U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("currentY", [value unsignedShortValue], 31100U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait10s_9()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 10000UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThReadsCurrentXAttributeFromDut_10()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentXWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentX attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("currentX", [value unsignedShortValue], 26350U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("currentX", [value unsignedShortValue], 35650U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsCurrentYAttributeFromDut_11()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentYWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentY attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("currentY", [value unsignedShortValue], 23800U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("currentY", [value unsignedShortValue], 32200U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait10s_12()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 10000UL;
        return WaitForMs("alpha", value);
    }
    NSNumber * _Nonnull CurrentXValue;

    CHIP_ERROR TestThReadsCurrentXAttributeFromDut_13()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentXWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentX attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("currentX", [value unsignedShortValue], 25500U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("currentX", [value unsignedShortValue], 34500U));
            {
                CurrentXValue = value;
            }

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }
    NSNumber * _Nonnull CurrentYValue;

    CHIP_ERROR TestThReadsCurrentYAttributeFromDut_14()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentYWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentY attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("currentY", [value unsignedShortValue], 24650U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("currentY", [value unsignedShortValue], 33350U));
            {
                CurrentYValue = value;
            }

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThSendsStopMoveStepCommandToDut_15()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        __auto_type * params = [[MTRColorControlClusterStopMoveStepParams alloc] init];
        params.optionsMask = [NSNumber numberWithUnsignedChar:0U];
        params.optionsOverride = [NSNumber numberWithUnsignedChar:0U];
        [cluster stopMoveStepWithParams:params
                             completion:^(NSError * _Nullable err) {
                                 NSLog(@"TH sends StopMoveStep command to DUT Error: %@", err);

                                 VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                                 NextTest();
                             }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsCurrentXAttributeFromDut_16()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentXWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentX attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("currentX", [value unsignedShortValue], 25500U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("currentX", [value unsignedShortValue], 34500U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsCurrentYAttributeFromDut_17()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentYWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentY attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("currentY", [value unsignedShortValue], 24650U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("currentY", [value unsignedShortValue], 33350U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsColorModeAttributeFromDut_18()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeColorModeWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads ColorMode attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("ColorMode", actualValue, 1U));
            }

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("colorMode", [value unsignedCharValue], 0U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("colorMode", [value unsignedCharValue], 2U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsEnhancedColorModeAttributeFromDut_19()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeEnhancedColorModeWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads EnhancedColorMode attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("EnhancedColorMode", actualValue, 1U));
            }

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("enhancedColorMode", [value unsignedCharValue], 0U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("enhancedColorMode", [value unsignedCharValue], 3U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestTurnOffLightThatWeTurnedOn_20()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterOnOff alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster offWithCompletion:^(NSError * _Nullable err) {
            NSLog(@"Turn off light that we turned on Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestCheckOnOffAttributeValueIsFalseAfterOffCommand_21()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterOnOff alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeOnOffWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Check on/off attribute value is false after off command Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("OnOff", actualValue, 0));
            }

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }
};

class Test_TC_CC_5_3 : public TestCommandBridge {
public:
    // NOLINTBEGIN(clang-analyzer-nullability.NullPassedToNonnull): Test constructor nullability not enforced
    Test_TC_CC_5_3()
        : TestCommandBridge("Test_TC_CC_5_3")
        , mTestIndex(0)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }
    // NOLINTEND(clang-analyzer-nullability.NullPassedToNonnull)

    ~Test_TC_CC_5_3() {}

    /////////// TestCommand Interface /////////
    void NextTest() override
    {
        CHIP_ERROR err = CHIP_NO_ERROR;

        if (0 == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Start: Test_TC_CC_5_3\n");
        }

        if (mTestCount == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Complete: Test_TC_CC_5_3\n");
            SetCommandExitStatus(CHIP_NO_ERROR);
            return;
        }

        Wait();

        // Ensure we increment mTestIndex before we start running the relevant
        // command.  That way if we lose the timeslice after we send the message
        // but before our function call returns, we won't end up with an
        // incorrect mTestIndex value observed when we get the response.
        switch (mTestIndex++) {
        case 0:
            ChipLogProgress(chipTool, " ***** Test Step 0 : Wait for the commissioned device to be retrieved\n");
            err = TestWaitForTheCommissionedDeviceToBeRetrieved_0();
            break;
        case 1:
            ChipLogProgress(chipTool, " ***** Test Step 1 : TH writes 0 to the Options attribute\n");
            if (ShouldSkip("CC.S.F03 && CC.S.A000f")) {
                NextTest();
                return;
            }
            err = TestThWrites0ToTheOptionsAttribute_1();
            break;
        case 2:
            ChipLogProgress(chipTool, " ***** Test Step 2 : TH sends On command to DUT\n");
            if (ShouldSkip("OO.S.C01.Rsp")) {
                NextTest();
                return;
            }
            err = TestThSendsOnCommandToDut_2();
            break;
        case 3:
            ChipLogProgress(chipTool,
                " ***** Test Step 3 : TH sends MoveToColor command to DUT, with ColorX = 33000 ColorY = 20000 TransitionTime = 0 "
                "(immediate)\n");
            if (ShouldSkip("CC.S.F03 && CC.S.C07.Rsp")) {
                NextTest();
                return;
            }
            err = TestThSendsMoveToColorCommandToDutWithColorX33000ColorY20000TransitionTime0Immediate_3();
            break;
        case 4:
            ChipLogProgress(chipTool, " ***** Test Step 4 : Wait 100ms\n");
            err = TestWait100ms_4();
            break;
        case 5:
            ChipLogProgress(chipTool,
                " ***** Test Step 5 : TH sends StepColor command to DUT, with StepX = -20000, StepY = -6000, TransitionTime = 200 "
                "(20s)\n");
            if (ShouldSkip("CC.S.F03 && CC.S.C09.Rsp")) {
                NextTest();
                return;
            }
            err = TestThSendsStepColorCommandToDutWithStepX20000StepY6000TransitionTime20020s_5();
            break;
        case 6:
            ChipLogProgress(chipTool, " ***** Test Step 6 : Wait 10s\n");
            err = TestWait10s_6();
            break;
        case 7:
            ChipLogProgress(chipTool, " ***** Test Step 7 : TH reads CurrentX attribute from DUT\n");
            if (ShouldSkip("CC.S.F03 && CC.S.A0003 && CC.S.C08.Rsp")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentXAttributeFromDut_7();
            break;
        case 8:
            ChipLogProgress(chipTool, " ***** Test Step 8 : TH reads CurrentY attribute from DUT\n");
            if (ShouldSkip("CC.S.F03 && CC.S.A0004 && CC.S.C08.Rsp")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentYAttributeFromDut_8();
            break;
        case 9:
            ChipLogProgress(chipTool, " ***** Test Step 9 : Wait 10s\n");
            err = TestWait10s_9();
            break;
        case 10:
            ChipLogProgress(chipTool, " ***** Test Step 10 : TH reads CurrentX attribute from DUT\n");
            if (ShouldSkip("CC.S.F03 && CC.S.A0003 && CC.S.C08.Rsp")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentXAttributeFromDut_10();
            break;
        case 11:
            ChipLogProgress(chipTool, " ***** Test Step 11 : TH reads CurrentY attribute from DUT\n");
            if (ShouldSkip("CC.S.F03 && CC.S.A0004 && CC.S.C08.Rsp")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentYAttributeFromDut_11();
            break;
        case 12:
            ChipLogProgress(chipTool, " ***** Test Step 12 : Wait 5s\n");
            err = TestWait5s_12();
            break;
        case 13:
            ChipLogProgress(chipTool, " ***** Test Step 13 : TH reads CurrentX attribute from DUT\n");
            if (ShouldSkip("CC.S.F03 && CC.S.A0003 && CC.S.C08.Rsp")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentXAttributeFromDut_13();
            break;
        case 14:
            ChipLogProgress(chipTool, " ***** Test Step 14 : TH reads CurrentY attribute from DUT\n");
            if (ShouldSkip("CC.S.F03 && CC.S.A0004 && CC.S.C08.Rsp")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentYAttributeFromDut_14();
            break;
        case 15:
            ChipLogProgress(chipTool, " ***** Test Step 15 : TH reads ColorMode attribute from DUT\n");
            if (ShouldSkip("CC.S.F03 && CC.S.A0008")) {
                NextTest();
                return;
            }
            err = TestThReadsColorModeAttributeFromDut_15();
            break;
        case 16:
            ChipLogProgress(chipTool, " ***** Test Step 16 : TH reads EnhancedColorMode attribute from DUT\n");
            if (ShouldSkip("CC.S.F03 && CC.S.A4001")) {
                NextTest();
                return;
            }
            err = TestThReadsEnhancedColorModeAttributeFromDut_16();
            break;
        case 17:
            ChipLogProgress(chipTool, " ***** Test Step 17 : Turn off light that we turned on\n");
            if (ShouldSkip("OO.S.C00.Rsp")) {
                NextTest();
                return;
            }
            err = TestTurnOffLightThatWeTurnedOn_17();
            break;
        case 18:
            ChipLogProgress(chipTool, " ***** Test Step 18 : Check on/off attribute value is false after off command\n");
            if (ShouldSkip("OO.S.A0000")) {
                NextTest();
                return;
            }
            err = TestCheckOnOffAttributeValueIsFalseAfterOffCommand_18();
            break;
        }

        if (CHIP_NO_ERROR != err) {
            ChipLogError(chipTool, " ***** Test Failure: %s\n", chip::ErrorStr(err));
            SetCommandExitStatus(err);
        }
    }

    void OnStatusUpdate(const chip::app::StatusIB & status) override
    {
        switch (mTestIndex - 1) {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 6:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 7:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 8:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 9:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 10:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 11:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 12:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 13:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 14:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 15:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 16:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 17:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 18:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        }

        // Go on to the next test.
        ContinueOnChipMainThread(CHIP_NO_ERROR);
    }

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    std::atomic_uint16_t mTestIndex;
    const uint16_t mTestCount = 19;

    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    CHIP_ERROR TestWaitForTheCommissionedDeviceToBeRetrieved_0()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
        value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
        return WaitForCommissionee("alpha", value);
    }

    CHIP_ERROR TestThWrites0ToTheOptionsAttribute_1()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        id optionsArgument;
        optionsArgument = [NSNumber numberWithUnsignedChar:0U];
        [cluster writeAttributeOptionsWithValue:optionsArgument
                                     completion:^(NSError * _Nullable err) {
                                         NSLog(@"TH writes 0 to the Options attribute Error: %@", err);

                                         VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                                         NextTest();
                                     }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThSendsOnCommandToDut_2()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterOnOff alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster onWithCompletion:^(NSError * _Nullable err) {
            NSLog(@"TH sends On command to DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThSendsMoveToColorCommandToDutWithColorX33000ColorY20000TransitionTime0Immediate_3()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        __auto_type * params = [[MTRColorControlClusterMoveToColorParams alloc] init];
        params.colorX = [NSNumber numberWithUnsignedShort:33000U];
        params.colorY = [NSNumber numberWithUnsignedShort:20000U];
        params.transitionTime = [NSNumber numberWithUnsignedShort:0U];
        params.optionsMask = [NSNumber numberWithUnsignedChar:0U];
        params.optionsOverride = [NSNumber numberWithUnsignedChar:0U];
        [cluster moveToColorWithParams:params
                            completion:^(NSError * _Nullable err) {
                                NSLog(@"TH sends MoveToColor command to DUT, with ColorX = 33000 ColorY = 20000 TransitionTime = 0 "
                                      @"(immediate) Error: %@",
                                    err);

                                VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                                NextTest();
                            }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait100ms_4()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 100UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThSendsStepColorCommandToDutWithStepX20000StepY6000TransitionTime20020s_5()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        __auto_type * params = [[MTRColorControlClusterStepColorParams alloc] init];
        params.stepX = [NSNumber numberWithShort:-20000];
        params.stepY = [NSNumber numberWithShort:-6000];
        params.transitionTime = [NSNumber numberWithUnsignedShort:200U];
        params.optionsMask = [NSNumber numberWithUnsignedChar:0U];
        params.optionsOverride = [NSNumber numberWithUnsignedChar:0U];
        [cluster stepColorWithParams:params
                          completion:^(NSError * _Nullable err) {
                              NSLog(@"TH sends StepColor command to DUT, with StepX = -20000, StepY = -6000, TransitionTime = 200 "
                                    @"(20s) Error: %@",
                                  err);

                              VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                              NextTest();
                          }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait10s_6()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 10000UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThReadsCurrentXAttributeFromDut_7()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentXWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentX attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("currentX", [value unsignedShortValue], 13000U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("currentX", [value unsignedShortValue], 33000U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsCurrentYAttributeFromDut_8()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentYWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentY attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("currentY", [value unsignedShortValue], 14000U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("currentY", [value unsignedShortValue], 20000U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait10s_9()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 10000UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThReadsCurrentXAttributeFromDut_10()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentXWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentX attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("currentX", [value unsignedShortValue], 11050U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("currentX", [value unsignedShortValue], 14950U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsCurrentYAttributeFromDut_11()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentYWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentY attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("currentY", [value unsignedShortValue], 11900U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("currentY", [value unsignedShortValue], 16100U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait5s_12()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 5000UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThReadsCurrentXAttributeFromDut_13()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentXWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentX attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("currentX", [value unsignedShortValue], 11050U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("currentX", [value unsignedShortValue], 14950U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsCurrentYAttributeFromDut_14()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentYWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentY attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("currentY", [value unsignedShortValue], 11900U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("currentY", [value unsignedShortValue], 16100U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsColorModeAttributeFromDut_15()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeColorModeWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads ColorMode attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("ColorMode", actualValue, 1U));
            }

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("colorMode", [value unsignedCharValue], 0U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("colorMode", [value unsignedCharValue], 2U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsEnhancedColorModeAttributeFromDut_16()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeEnhancedColorModeWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads EnhancedColorMode attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("EnhancedColorMode", actualValue, 1U));
            }

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("enhancedColorMode", [value unsignedCharValue], 0U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("enhancedColorMode", [value unsignedCharValue], 3U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestTurnOffLightThatWeTurnedOn_17()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterOnOff alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster offWithCompletion:^(NSError * _Nullable err) {
            NSLog(@"Turn off light that we turned on Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestCheckOnOffAttributeValueIsFalseAfterOffCommand_18()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterOnOff alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeOnOffWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Check on/off attribute value is false after off command Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("OnOff", actualValue, 0));
            }

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }
};

class Test_TC_CC_6_1 : public TestCommandBridge {
public:
    // NOLINTBEGIN(clang-analyzer-nullability.NullPassedToNonnull): Test constructor nullability not enforced
    Test_TC_CC_6_1()
        : TestCommandBridge("Test_TC_CC_6_1")
        , mTestIndex(0)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }
    // NOLINTEND(clang-analyzer-nullability.NullPassedToNonnull)

    ~Test_TC_CC_6_1() {}

    /////////// TestCommand Interface /////////
    void NextTest() override
    {
        CHIP_ERROR err = CHIP_NO_ERROR;

        if (0 == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Start: Test_TC_CC_6_1\n");
        }

        if (mTestCount == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Complete: Test_TC_CC_6_1\n");
            SetCommandExitStatus(CHIP_NO_ERROR);
            return;
        }

        Wait();

        // Ensure we increment mTestIndex before we start running the relevant
        // command.  That way if we lose the timeslice after we send the message
        // but before our function call returns, we won't end up with an
        // incorrect mTestIndex value observed when we get the response.
        switch (mTestIndex++) {
        case 0:
            ChipLogProgress(chipTool, " ***** Test Step 0 : Wait for the commissioned device to be retrieved\n");
            err = TestWaitForTheCommissionedDeviceToBeRetrieved_0();
            break;
        case 1:
            ChipLogProgress(chipTool, " ***** Test Step 1 : TH writes 0 to the Options attribute\n");
            if (ShouldSkip("CC.S.F04 && CC.S.A000f")) {
                NextTest();
                return;
            }
            err = TestThWrites0ToTheOptionsAttribute_1();
            break;
        case 2:
            ChipLogProgress(chipTool, " ***** Test Step 2 : TH sends On command to DUT\n");
            if (ShouldSkip("OO.S.C01.Rsp")) {
                NextTest();
                return;
            }
            err = TestThSendsOnCommandToDut_2();
            break;
        case 3:
            ChipLogProgress(chipTool, " ***** Test Step 3 : TH reads ColorTempPhysicalMinMireds attribute from DUT\n");
            if (ShouldSkip("CC.S.F04 && CC.S.A400b")) {
                NextTest();
                return;
            }
            err = TestThReadsColorTempPhysicalMinMiredsAttributeFromDut_3();
            break;
        case 4:
            ChipLogProgress(chipTool, " ***** Test Step 4 : TH reads ColorTempPhysicalMaxMireds attribute from DUT.\n");
            if (ShouldSkip("CC.S.F04 && CC.S.A400c")) {
                NextTest();
                return;
            }
            err = TestThReadsColorTempPhysicalMaxMiredsAttributeFromDut_4();
            break;
        case 5:
            ChipLogProgress(chipTool, " ***** Test Step 5 : TH reads ColorTemperatureMireds attribute from DUT.\n");
            if (ShouldSkip("CC.S.F04 && CC.S.A0007")) {
                NextTest();
                return;
            }
            err = TestThReadsColorTemperatureMiredsAttributeFromDut_5();
            break;
        case 6:
            ChipLogProgress(chipTool,
                " ***** Test Step 6 : TH sends MoveToColorTemperature command to DUT with ColorTemperatureMireds=310 and "
                "TransitionTime=0 (immediately).\n");
            if (ShouldSkip("CC.S.F04 && CC.S.C0a.Rsp")) {
                NextTest();
                return;
            }
            err = TestThSendsMoveToColorTemperatureCommandToDutWithColorTemperatureMireds310AndTransitionTime0Immediately_6();
            break;
        case 7:
            ChipLogProgress(chipTool, " ***** Test Step 7 : Wait 100ms\n");
            err = TestWait100ms_7();
            break;
        case 8:
            ChipLogProgress(chipTool,
                " ***** Test Step 8 : TH sends MoveToColorTemperatur command to DUT with ColorTemperatureMireds=250 and "
                "TransitionTime=300 (30s).\n");
            if (ShouldSkip("CC.S.F04 && CC.S.C0a.Rsp")) {
                NextTest();
                return;
            }
            err = TestThSendsMoveToColorTemperaturCommandToDutWithColorTemperatureMireds250AndTransitionTime30030s_8();
            break;
        case 9:
            ChipLogProgress(chipTool, " ***** Test Step 9 : Wait 10s\n");
            err = TestWait10s_9();
            break;
        case 10:
            ChipLogProgress(chipTool, " ***** Test Step 10 : TH reads ColorTemperatureMireds attribute from DUT.\n");
            if (ShouldSkip("CC.S.F04 && CC.S.A0007 && CC.S.C0a.Rsp")) {
                NextTest();
                return;
            }
            err = TestThReadsColorTemperatureMiredsAttributeFromDut_10();
            break;
        case 11:
            ChipLogProgress(chipTool, " ***** Test Step 11 : Wait 10s\n");
            err = TestWait10s_11();
            break;
        case 12:
            ChipLogProgress(chipTool, " ***** Test Step 12 : TH reads ColorTemperatureMireds attribute from DUT.\n");
            if (ShouldSkip("CC.S.F04 && CC.S.A0007 && CC.S.C0a.Rsp")) {
                NextTest();
                return;
            }
            err = TestThReadsColorTemperatureMiredsAttributeFromDut_12();
            break;
        case 13:
            ChipLogProgress(chipTool, " ***** Test Step 13 : Wait 10s\n");
            err = TestWait10s_13();
            break;
        case 14:
            ChipLogProgress(chipTool, " ***** Test Step 14 : TH reads ColorTemperatureMireds attribute from DUT.\n");
            if (ShouldSkip("CC.S.F04 && CC.S.A0007 && CC.S.C0a.Rsp")) {
                NextTest();
                return;
            }
            err = TestThReadsColorTemperatureMiredsAttributeFromDut_14();
            break;
        case 15:
            ChipLogProgress(chipTool, " ***** Test Step 15 : Wait 5s\n");
            err = TestWait5s_15();
            break;
        case 16:
            ChipLogProgress(chipTool, " ***** Test Step 16 : TH reads ColorTemperatureMireds attribute from DUT.\n");
            if (ShouldSkip("CC.S.F04 && CC.S.A0007 && CC.S.C0a.Rsp")) {
                NextTest();
                return;
            }
            err = TestThReadsColorTemperatureMiredsAttributeFromDut_16();
            break;
        case 17:
            ChipLogProgress(chipTool, " ***** Test Step 17 : TH reads ColorMode attribute from DUT\n");
            if (ShouldSkip("CC.S.F04 && CC.S.A0008")) {
                NextTest();
                return;
            }
            err = TestThReadsColorModeAttributeFromDut_17();
            break;
        case 18:
            ChipLogProgress(chipTool, " ***** Test Step 18 : TH reads EnhancedColorMode attribute from DUT\n");
            if (ShouldSkip("CC.S.F04 && CC.S.A4001")) {
                NextTest();
                return;
            }
            err = TestThReadsEnhancedColorModeAttributeFromDut_18();
            break;
        case 19:
            ChipLogProgress(chipTool, " ***** Test Step 19 : Turn Off light that we turned on\n");
            if (ShouldSkip("OO.S.C00.Rsp")) {
                NextTest();
                return;
            }
            err = TestTurnOffLightThatWeTurnedOn_19();
            break;
        case 20:
            ChipLogProgress(chipTool, " ***** Test Step 20 : Check on/off attribute value is false after off command\n");
            if (ShouldSkip("OO.S.A0000")) {
                NextTest();
                return;
            }
            err = TestCheckOnOffAttributeValueIsFalseAfterOffCommand_20();
            break;
        }

        if (CHIP_NO_ERROR != err) {
            ChipLogError(chipTool, " ***** Test Failure: %s\n", chip::ErrorStr(err));
            SetCommandExitStatus(err);
        }
    }

    void OnStatusUpdate(const chip::app::StatusIB & status) override
    {
        switch (mTestIndex - 1) {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 6:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 7:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 8:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 9:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 10:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 11:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 12:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 13:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 14:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 15:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 16:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 17:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 18:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 19:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 20:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        }

        // Go on to the next test.
        ContinueOnChipMainThread(CHIP_NO_ERROR);
    }

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    std::atomic_uint16_t mTestIndex;
    const uint16_t mTestCount = 21;

    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    CHIP_ERROR TestWaitForTheCommissionedDeviceToBeRetrieved_0()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
        value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
        return WaitForCommissionee("alpha", value);
    }

    CHIP_ERROR TestThWrites0ToTheOptionsAttribute_1()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        id optionsArgument;
        optionsArgument = [NSNumber numberWithUnsignedChar:0U];
        [cluster writeAttributeOptionsWithValue:optionsArgument
                                     completion:^(NSError * _Nullable err) {
                                         NSLog(@"TH writes 0 to the Options attribute Error: %@", err);

                                         VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                                         NextTest();
                                     }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThSendsOnCommandToDut_2()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterOnOff alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster onWithCompletion:^(NSError * _Nullable err) {
            NSLog(@"TH sends On command to DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }
    NSNumber * _Nonnull ColorTempPhysicalMinMiredsValue;

    CHIP_ERROR TestThReadsColorTempPhysicalMinMiredsAttributeFromDut_3()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeColorTempPhysicalMinMiredsWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads ColorTempPhysicalMinMireds attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("colorTempPhysicalMinMireds", "int16u", "int16u"));
            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("colorTempPhysicalMinMireds", [value unsignedShortValue], 0U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("colorTempPhysicalMinMireds", [value unsignedShortValue], 65279U));
            {
                ColorTempPhysicalMinMiredsValue = value;
            }

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }
    NSNumber * _Nonnull ColorTempPhysicalMaxMiredsValue;

    CHIP_ERROR TestThReadsColorTempPhysicalMaxMiredsAttributeFromDut_4()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeColorTempPhysicalMaxMiredsWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads ColorTempPhysicalMaxMireds attribute from DUT. Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("colorTempPhysicalMaxMireds", "int16u", "int16u"));
            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("colorTempPhysicalMaxMireds", [value unsignedShortValue], 0U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("colorTempPhysicalMaxMireds", [value unsignedShortValue], 65279U));
            {
                ColorTempPhysicalMaxMiredsValue = value;
            }

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsColorTemperatureMiredsAttributeFromDut_5()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeColorTemperatureMiredsWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads ColorTemperatureMireds attribute from DUT. Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("colorTemperatureMireds", "int16u", "int16u"));
            VerifyOrReturn(CheckConstraintMinValue<uint16_t>(
                "colorTemperatureMireds", [value unsignedShortValue], ColorTempPhysicalMinMiredsValue));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>(
                "colorTemperatureMireds", [value unsignedShortValue], ColorTempPhysicalMaxMiredsValue));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThSendsMoveToColorTemperatureCommandToDutWithColorTemperatureMireds310AndTransitionTime0Immediately_6()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        __auto_type * params = [[MTRColorControlClusterMoveToColorTemperatureParams alloc] init];
        params.colorTemperature = [NSNumber numberWithUnsignedShort:310U];
        params.transitionTime = [NSNumber numberWithUnsignedShort:0U];
        params.optionsMask = [NSNumber numberWithUnsignedChar:0U];
        params.optionsOverride = [NSNumber numberWithUnsignedChar:0U];
        [cluster moveToColorTemperatureWithParams:params
                                       completion:^(NSError * _Nullable err) {
                                           NSLog(@"TH sends MoveToColorTemperature command to DUT with ColorTemperatureMireds=310 "
                                                 @"and TransitionTime=0 (immediately). Error: %@",
                                               err);

                                           VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                                           NextTest();
                                       }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait100ms_7()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 100UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThSendsMoveToColorTemperaturCommandToDutWithColorTemperatureMireds250AndTransitionTime30030s_8()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        __auto_type * params = [[MTRColorControlClusterMoveToColorTemperatureParams alloc] init];
        params.colorTemperature = [NSNumber numberWithUnsignedShort:250U];
        params.transitionTime = [NSNumber numberWithUnsignedShort:300U];
        params.optionsMask = [NSNumber numberWithUnsignedChar:0U];
        params.optionsOverride = [NSNumber numberWithUnsignedChar:0U];
        [cluster moveToColorTemperatureWithParams:params
                                       completion:^(NSError * _Nullable err) {
                                           NSLog(@"TH sends MoveToColorTemperatur command to DUT with ColorTemperatureMireds=250 "
                                                 @"and TransitionTime=300 (30s). Error: %@",
                                               err);

                                           VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                                           NextTest();
                                       }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait10s_9()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 10000UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThReadsColorTemperatureMiredsAttributeFromDut_10()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeColorTemperatureMiredsWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads ColorTemperatureMireds attribute from DUT. Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("colorTemperatureMireds", [value unsignedShortValue], 246U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("colorTemperatureMireds", [value unsignedShortValue], 334U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait10s_11()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 10000UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThReadsColorTemperatureMiredsAttributeFromDut_12()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeColorTemperatureMiredsWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads ColorTemperatureMireds attribute from DUT. Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("colorTemperatureMireds", [value unsignedShortValue], 230U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("colorTemperatureMireds", [value unsignedShortValue], 310U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait10s_13()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 10000UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThReadsColorTemperatureMiredsAttributeFromDut_14()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeColorTemperatureMiredsWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads ColorTemperatureMireds attribute from DUT. Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("colorTemperatureMireds", [value unsignedShortValue], 212U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("colorTemperatureMireds", [value unsignedShortValue], 288U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait5s_15()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 5000UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThReadsColorTemperatureMiredsAttributeFromDut_16()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeColorTemperatureMiredsWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads ColorTemperatureMireds attribute from DUT. Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("colorTemperatureMireds", [value unsignedShortValue], 212U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("colorTemperatureMireds", [value unsignedShortValue], 288U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsColorModeAttributeFromDut_17()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeColorModeWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads ColorMode attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("ColorMode", actualValue, 2U));
            }

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("colorMode", [value unsignedCharValue], 0U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("colorMode", [value unsignedCharValue], 2U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsEnhancedColorModeAttributeFromDut_18()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeEnhancedColorModeWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads EnhancedColorMode attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("EnhancedColorMode", actualValue, 2U));
            }

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("enhancedColorMode", [value unsignedCharValue], 0U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("enhancedColorMode", [value unsignedCharValue], 3U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestTurnOffLightThatWeTurnedOn_19()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterOnOff alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster offWithCompletion:^(NSError * _Nullable err) {
            NSLog(@"Turn Off light that we turned on Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestCheckOnOffAttributeValueIsFalseAfterOffCommand_20()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterOnOff alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeOnOffWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Check on/off attribute value is false after off command Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("OnOff", actualValue, 0));
            }

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }
};

class Test_TC_CC_7_3 : public TestCommandBridge {
public:
    // NOLINTBEGIN(clang-analyzer-nullability.NullPassedToNonnull): Test constructor nullability not enforced
    Test_TC_CC_7_3()
        : TestCommandBridge("Test_TC_CC_7_3")
        , mTestIndex(0)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }
    // NOLINTEND(clang-analyzer-nullability.NullPassedToNonnull)

    ~Test_TC_CC_7_3() {}

    /////////// TestCommand Interface /////////
    void NextTest() override
    {
        CHIP_ERROR err = CHIP_NO_ERROR;

        if (0 == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Start: Test_TC_CC_7_3\n");
        }

        if (mTestCount == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Complete: Test_TC_CC_7_3\n");
            SetCommandExitStatus(CHIP_NO_ERROR);
            return;
        }

        Wait();

        // Ensure we increment mTestIndex before we start running the relevant
        // command.  That way if we lose the timeslice after we send the message
        // but before our function call returns, we won't end up with an
        // incorrect mTestIndex value observed when we get the response.
        switch (mTestIndex++) {
        case 0:
            ChipLogProgress(chipTool, " ***** Test Step 0 : Wait for the commissioned device to be retrieved\n");
            err = TestWaitForTheCommissionedDeviceToBeRetrieved_0();
            break;
        case 1:
            ChipLogProgress(chipTool, " ***** Test Step 1 : TH writes 0 to the Options attribute\n");
            if (ShouldSkip("CC.S.F01 && CC.S.A000f")) {
                NextTest();
                return;
            }
            err = TestThWrites0ToTheOptionsAttribute_1();
            break;
        case 2:
            ChipLogProgress(chipTool, " ***** Test Step 2 : TH sends On command to DUT\n");
            if (ShouldSkip("OO.S.C01.Rsp")) {
                NextTest();
                return;
            }
            err = TestThSendsOnCommandToDut_2();
            break;
        case 3:
            ChipLogProgress(chipTool,
                " ***** Test Step 3 : TH sends EnhancedMoveToHue command to DUT with EnhancedHue=6000, Direction=0x00 (shortest "
                "distance) and TransitionTime=0 (immediately).\n");
            if (ShouldSkip("CC.S.F01 && CC.S.C40.Rsp")) {
                NextTest();
                return;
            }
            err = TestThSendsEnhancedMoveToHueCommandToDutWithEnhancedHue6000Direction0x00ShortestDistanceAndTransitionTime0Immediately_3();
            break;
        case 4:
            ChipLogProgress(chipTool, " ***** Test Step 4 : Wait 100ms\n");
            err = TestWait100ms_4();
            break;
        case 5:
            ChipLogProgress(chipTool,
                " ***** Test Step 5 : TH sends EnhancedStepHue command to DUT with StepMode=0x01 (up), StepSize=6000 and "
                "TransitionTime=300 (30s).\n");
            if (ShouldSkip("CC.S.F01 && CC.S.C42.Rsp")) {
                NextTest();
                return;
            }
            err = TestThSendsEnhancedStepHueCommandToDutWithStepMode0x01UpStepSize6000AndTransitionTime30030s_5();
            break;
        case 6:
            ChipLogProgress(chipTool, " ***** Test Step 6 : Wait 10s\n");
            err = TestWait10s_6();
            break;
        case 7:
            ChipLogProgress(chipTool, " ***** Test Step 7 : TH reads EnhancedCurrentHue attribute from DUT\n");
            if (ShouldSkip("CC.S.F01 && CC.S.A4000 && CC.S.C41.Rsp")) {
                NextTest();
                return;
            }
            err = TestThReadsEnhancedCurrentHueAttributeFromDut_7();
            break;
        case 8:
            ChipLogProgress(chipTool, " ***** Test Step 8 : Wait 10s\n");
            err = TestWait10s_8();
            break;
        case 9:
            ChipLogProgress(chipTool, " ***** Test Step 9 : TH reads EnhancedCurrentHue attribute from DUT\n");
            if (ShouldSkip("CC.S.F01 && CC.S.A4000 && CC.S.C41.Rsp")) {
                NextTest();
                return;
            }
            err = TestThReadsEnhancedCurrentHueAttributeFromDut_9();
            break;
        case 10:
            ChipLogProgress(chipTool, " ***** Test Step 10 : Wait 10s\n");
            err = TestWait10s_10();
            break;
        case 11:
            ChipLogProgress(chipTool, " ***** Test Step 11 : TH reads EnhancedCurrentHue attribute from DUT\n");
            if (ShouldSkip("CC.S.F01 && CC.S.A4000 && CC.S.C41.Rsp")) {
                NextTest();
                return;
            }
            err = TestThReadsEnhancedCurrentHueAttributeFromDut_11();
            break;
        case 12:
            ChipLogProgress(chipTool, " ***** Test Step 12 : Wait 5s\n");
            err = TestWait5s_12();
            break;
        case 13:
            ChipLogProgress(chipTool, " ***** Test Step 13 : TH reads EnhancedCurrentHue attribute from DUT\n");
            if (ShouldSkip("CC.S.F01 && CC.S.A4000 && CC.S.C41.Rsp")) {
                NextTest();
                return;
            }
            err = TestThReadsEnhancedCurrentHueAttributeFromDut_13();
            break;
        case 14:
            ChipLogProgress(chipTool,
                " ***** Test Step 14 : TH sends EnhancedMoveToHue command to DUT with EnhancedHue=12000, Direction=0x00 (shortest "
                "distance) and TransitionTime=0 (immediately).\n");
            if (ShouldSkip("CC.S.F01 && CC.S.C40.Rsp")) {
                NextTest();
                return;
            }
            err = TestThSendsEnhancedMoveToHueCommandToDutWithEnhancedHue12000Direction0x00ShortestDistanceAndTransitionTime0Immediately_14();
            break;
        case 15:
            ChipLogProgress(chipTool, " ***** Test Step 15 : Wait 100ms\n");
            err = TestWait100ms_15();
            break;
        case 16:
            ChipLogProgress(chipTool,
                " ***** Test Step 16 : TH sends EnhancedStepHue command to DUT with StepMode=0x03 (down), StepSize=6000 and "
                "TransitionTime=300 (30s)\n");
            if (ShouldSkip("CC.S.F01 && CC.S.C42.Rsp")) {
                NextTest();
                return;
            }
            err = TestThSendsEnhancedStepHueCommandToDutWithStepMode0x03DownStepSize6000AndTransitionTime30030s_16();
            break;
        case 17:
            ChipLogProgress(chipTool, " ***** Test Step 17 : Wait 10s\n");
            err = TestWait10s_17();
            break;
        case 18:
            ChipLogProgress(chipTool, " ***** Test Step 18 : TH reads EnhancedCurrentHue attribute from DUT\n");
            if (ShouldSkip("CC.S.F01 && CC.S.A4000 && CC.S.C41.Rsp")) {
                NextTest();
                return;
            }
            err = TestThReadsEnhancedCurrentHueAttributeFromDut_18();
            break;
        case 19:
            ChipLogProgress(chipTool, " ***** Test Step 19 : Wait 10s\n");
            err = TestWait10s_19();
            break;
        case 20:
            ChipLogProgress(chipTool, " ***** Test Step 20 : TH reads EnhancedCurrentHue attribute from DUT\n");
            if (ShouldSkip("CC.S.F01 && CC.S.A4000 && CC.S.C41.Rsp")) {
                NextTest();
                return;
            }
            err = TestThReadsEnhancedCurrentHueAttributeFromDut_20();
            break;
        case 21:
            ChipLogProgress(chipTool, " ***** Test Step 21 : Wait 10s\n");
            err = TestWait10s_21();
            break;
        case 22:
            ChipLogProgress(chipTool, " ***** Test Step 22 : TH reads EnhancedCurrentHue attribute from DUT\n");
            if (ShouldSkip("CC.S.F01 && CC.S.A4000 && CC.S.C41.Rsp")) {
                NextTest();
                return;
            }
            err = TestThReadsEnhancedCurrentHueAttributeFromDut_22();
            break;
        case 23:
            ChipLogProgress(chipTool, " ***** Test Step 23 : Wait 5s\n");
            err = TestWait5s_23();
            break;
        case 24:
            ChipLogProgress(chipTool, " ***** Test Step 24 : TH reads EnhancedCurrentHue attribute from DUT\n");
            if (ShouldSkip("CC.S.F01 && CC.S.A4000 && CC.S.C41.Rsp")) {
                NextTest();
                return;
            }
            err = TestThReadsEnhancedCurrentHueAttributeFromDut_24();
            break;
        case 25:
            ChipLogProgress(chipTool, " ***** Test Step 25 : TH reads ColorMode attribute from DUT\n");
            if (ShouldSkip("CC.S.F01 && CC.S.A0008")) {
                NextTest();
                return;
            }
            err = TestThReadsColorModeAttributeFromDut_25();
            break;
        case 26:
            ChipLogProgress(chipTool, " ***** Test Step 26 : TH reads EnhancedColorMode attribute from DUT\n");
            if (ShouldSkip("CC.S.F01 && CC.S.A4001")) {
                NextTest();
                return;
            }
            err = TestThReadsEnhancedColorModeAttributeFromDut_26();
            break;
        case 27:
            ChipLogProgress(chipTool, " ***** Test Step 27 : Turn Off light that we turned on\n");
            if (ShouldSkip("OO.S.C00.Rsp")) {
                NextTest();
                return;
            }
            err = TestTurnOffLightThatWeTurnedOn_27();
            break;
        case 28:
            ChipLogProgress(chipTool, " ***** Test Step 28 : Check on/off attribute value is false after off command\n");
            if (ShouldSkip("OO.S.A0000")) {
                NextTest();
                return;
            }
            err = TestCheckOnOffAttributeValueIsFalseAfterOffCommand_28();
            break;
        }

        if (CHIP_NO_ERROR != err) {
            ChipLogError(chipTool, " ***** Test Failure: %s\n", chip::ErrorStr(err));
            SetCommandExitStatus(err);
        }
    }

    void OnStatusUpdate(const chip::app::StatusIB & status) override
    {
        switch (mTestIndex - 1) {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 6:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 7:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 8:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 9:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 10:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 11:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 12:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 13:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 14:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 15:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 16:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 17:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 18:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 19:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 20:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 21:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 22:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 23:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 24:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 25:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 26:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 27:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 28:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        }

        // Go on to the next test.
        ContinueOnChipMainThread(CHIP_NO_ERROR);
    }

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    std::atomic_uint16_t mTestIndex;
    const uint16_t mTestCount = 29;

    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    CHIP_ERROR TestWaitForTheCommissionedDeviceToBeRetrieved_0()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
        value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
        return WaitForCommissionee("alpha", value);
    }

    CHIP_ERROR TestThWrites0ToTheOptionsAttribute_1()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        id optionsArgument;
        optionsArgument = [NSNumber numberWithUnsignedChar:0U];
        [cluster writeAttributeOptionsWithValue:optionsArgument
                                     completion:^(NSError * _Nullable err) {
                                         NSLog(@"TH writes 0 to the Options attribute Error: %@", err);

                                         VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                                         NextTest();
                                     }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThSendsOnCommandToDut_2()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterOnOff alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster onWithCompletion:^(NSError * _Nullable err) {
            NSLog(@"TH sends On command to DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR
    TestThSendsEnhancedMoveToHueCommandToDutWithEnhancedHue6000Direction0x00ShortestDistanceAndTransitionTime0Immediately_3()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        __auto_type * params = [[MTRColorControlClusterEnhancedMoveToHueParams alloc] init];
        params.enhancedHue = [NSNumber numberWithUnsignedShort:6000U];
        params.direction = [NSNumber numberWithUnsignedChar:0U];
        params.transitionTime = [NSNumber numberWithUnsignedShort:0U];
        params.optionsMask = [NSNumber numberWithUnsignedChar:0U];
        params.optionsOverride = [NSNumber numberWithUnsignedChar:0U];
        [cluster enhancedMoveToHueWithParams:params
                                  completion:^(NSError * _Nullable err) {
                                      NSLog(@"TH sends EnhancedMoveToHue command to DUT with EnhancedHue=6000, Direction=0x00 "
                                            @"(shortest distance) and TransitionTime=0 (immediately). Error: %@",
                                          err);

                                      VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                                      NextTest();
                                  }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait100ms_4()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 100UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThSendsEnhancedStepHueCommandToDutWithStepMode0x01UpStepSize6000AndTransitionTime30030s_5()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        __auto_type * params = [[MTRColorControlClusterEnhancedStepHueParams alloc] init];
        params.stepMode = [NSNumber numberWithUnsignedChar:1U];
        params.stepSize = [NSNumber numberWithUnsignedShort:6000U];
        params.transitionTime = [NSNumber numberWithUnsignedShort:300U];
        params.optionsMask = [NSNumber numberWithUnsignedChar:0U];
        params.optionsOverride = [NSNumber numberWithUnsignedChar:0U];
        [cluster enhancedStepHueWithParams:params
                                completion:^(NSError * _Nullable err) {
                                    NSLog(@"TH sends EnhancedStepHue command to DUT with StepMode=0x01 (up), StepSize=6000 and "
                                          @"TransitionTime=300 (30s). Error: %@",
                                        err);

                                    VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                                    NextTest();
                                }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait10s_6()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 10000UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThReadsEnhancedCurrentHueAttributeFromDut_7()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeEnhancedCurrentHueWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads EnhancedCurrentHue attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("enhancedCurrentHue", [value unsignedShortValue], 6800U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("enhancedCurrentHue", [value unsignedShortValue], 9200U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait10s_8()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 10000UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThReadsEnhancedCurrentHueAttributeFromDut_9()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeEnhancedCurrentHueWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads EnhancedCurrentHue attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("enhancedCurrentHue", [value unsignedShortValue], 8500U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("enhancedCurrentHue", [value unsignedShortValue], 11500U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait10s_10()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 10000UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThReadsEnhancedCurrentHueAttributeFromDut_11()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeEnhancedCurrentHueWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads EnhancedCurrentHue attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("enhancedCurrentHue", [value unsignedShortValue], 10200U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("enhancedCurrentHue", [value unsignedShortValue], 13800U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait5s_12()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 5000UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThReadsEnhancedCurrentHueAttributeFromDut_13()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeEnhancedCurrentHueWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads EnhancedCurrentHue attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("enhancedCurrentHue", [value unsignedShortValue], 10200U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("enhancedCurrentHue", [value unsignedShortValue], 13800U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR
    TestThSendsEnhancedMoveToHueCommandToDutWithEnhancedHue12000Direction0x00ShortestDistanceAndTransitionTime0Immediately_14()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        __auto_type * params = [[MTRColorControlClusterEnhancedMoveToHueParams alloc] init];
        params.enhancedHue = [NSNumber numberWithUnsignedShort:12000U];
        params.direction = [NSNumber numberWithUnsignedChar:0U];
        params.transitionTime = [NSNumber numberWithUnsignedShort:0U];
        params.optionsMask = [NSNumber numberWithUnsignedChar:0U];
        params.optionsOverride = [NSNumber numberWithUnsignedChar:0U];
        [cluster enhancedMoveToHueWithParams:params
                                  completion:^(NSError * _Nullable err) {
                                      NSLog(@"TH sends EnhancedMoveToHue command to DUT with EnhancedHue=12000, Direction=0x00 "
                                            @"(shortest distance) and TransitionTime=0 (immediately). Error: %@",
                                          err);

                                      VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                                      NextTest();
                                  }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait100ms_15()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 100UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThSendsEnhancedStepHueCommandToDutWithStepMode0x03DownStepSize6000AndTransitionTime30030s_16()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        __auto_type * params = [[MTRColorControlClusterEnhancedStepHueParams alloc] init];
        params.stepMode = [NSNumber numberWithUnsignedChar:3U];
        params.stepSize = [NSNumber numberWithUnsignedShort:6000U];
        params.transitionTime = [NSNumber numberWithUnsignedShort:300U];
        params.optionsMask = [NSNumber numberWithUnsignedChar:0U];
        params.optionsOverride = [NSNumber numberWithUnsignedChar:0U];
        [cluster enhancedStepHueWithParams:params
                                completion:^(NSError * _Nullable err) {
                                    NSLog(@"TH sends EnhancedStepHue command to DUT with StepMode=0x03 (down), StepSize=6000 and "
                                          @"TransitionTime=300 (30s) Error: %@",
                                        err);

                                    VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                                    NextTest();
                                }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait10s_17()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 10000UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThReadsEnhancedCurrentHueAttributeFromDut_18()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeEnhancedCurrentHueWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads EnhancedCurrentHue attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("enhancedCurrentHue", [value unsignedShortValue], 8500U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("enhancedCurrentHue", [value unsignedShortValue], 11500U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait10s_19()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 10000UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThReadsEnhancedCurrentHueAttributeFromDut_20()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeEnhancedCurrentHueWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads EnhancedCurrentHue attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("enhancedCurrentHue", [value unsignedShortValue], 6800U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("enhancedCurrentHue", [value unsignedShortValue], 9200U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait10s_21()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 10000UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThReadsEnhancedCurrentHueAttributeFromDut_22()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeEnhancedCurrentHueWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads EnhancedCurrentHue attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("enhancedCurrentHue", [value unsignedShortValue], 5100U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("enhancedCurrentHue", [value unsignedShortValue], 6900U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait5s_23()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 5000UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThReadsEnhancedCurrentHueAttributeFromDut_24()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeEnhancedCurrentHueWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads EnhancedCurrentHue attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("enhancedCurrentHue", [value unsignedShortValue], 5100U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("enhancedCurrentHue", [value unsignedShortValue], 6900U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsColorModeAttributeFromDut_25()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeColorModeWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads ColorMode attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("ColorMode", actualValue, 0U));
            }

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("colorMode", [value unsignedCharValue], 0U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("colorMode", [value unsignedCharValue], 2U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsEnhancedColorModeAttributeFromDut_26()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeEnhancedColorModeWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads EnhancedColorMode attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("EnhancedColorMode", actualValue, 3U));
            }

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("enhancedColorMode", [value unsignedCharValue], 0U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("enhancedColorMode", [value unsignedCharValue], 3U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestTurnOffLightThatWeTurnedOn_27()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterOnOff alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster offWithCompletion:^(NSError * _Nullable err) {
            NSLog(@"Turn Off light that we turned on Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestCheckOnOffAttributeValueIsFalseAfterOffCommand_28()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterOnOff alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeOnOffWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Check on/off attribute value is false after off command Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("OnOff", actualValue, 0));
            }

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }
};

class Test_TC_CC_7_4 : public TestCommandBridge {
public:
    // NOLINTBEGIN(clang-analyzer-nullability.NullPassedToNonnull): Test constructor nullability not enforced
    Test_TC_CC_7_4()
        : TestCommandBridge("Test_TC_CC_7_4")
        , mTestIndex(0)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }
    // NOLINTEND(clang-analyzer-nullability.NullPassedToNonnull)

    ~Test_TC_CC_7_4() {}

    /////////// TestCommand Interface /////////
    void NextTest() override
    {
        CHIP_ERROR err = CHIP_NO_ERROR;

        if (0 == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Start: Test_TC_CC_7_4\n");
        }

        if (mTestCount == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Complete: Test_TC_CC_7_4\n");
            SetCommandExitStatus(CHIP_NO_ERROR);
            return;
        }

        Wait();

        // Ensure we increment mTestIndex before we start running the relevant
        // command.  That way if we lose the timeslice after we send the message
        // but before our function call returns, we won't end up with an
        // incorrect mTestIndex value observed when we get the response.
        switch (mTestIndex++) {
        case 0:
            ChipLogProgress(chipTool, " ***** Test Step 0 : Wait for the commissioned device to be retrieved\n");
            err = TestWaitForTheCommissionedDeviceToBeRetrieved_0();
            break;
        case 1:
            ChipLogProgress(chipTool, " ***** Test Step 1 : TH writes 0 to the Options attribute\n");
            if (ShouldSkip("CC.S.F01 && CC.S.A000f")) {
                NextTest();
                return;
            }
            err = TestThWrites0ToTheOptionsAttribute_1();
            break;
        case 2:
            ChipLogProgress(chipTool, " ***** Test Step 2 : TH sends On command to DUT\n");
            if (ShouldSkip("OO.S.C01.Rsp")) {
                NextTest();
                return;
            }
            err = TestThSendsOnCommandToDut_2();
            break;
        case 3:
            ChipLogProgress(chipTool,
                " ***** Test Step 3 : TH sends EnhancedMoveToHueAndSaturation command to DUT with EnhancedHue=20000, Saturation=50 "
                "and TransitionTime=0 (immediately)\n");
            if (ShouldSkip("CC.S.F01 && CC.S.C43.Rsp")) {
                NextTest();
                return;
            }
            err = TestThSendsEnhancedMoveToHueAndSaturationCommandToDutWithEnhancedHue20000Saturation50AndTransitionTime0Immediately_3();
            break;
        case 4:
            ChipLogProgress(chipTool, " ***** Test Step 4 : Wait 100ms\n");
            err = TestWait100ms_4();
            break;
        case 5:
            ChipLogProgress(chipTool, " ***** Test Step 5 : TH reads EnhancedCurrentHue attribute from DUT\n");
            if (ShouldSkip("CC.S.F01 && CC.S.A4000")) {
                NextTest();
                return;
            }
            err = TestThReadsEnhancedCurrentHueAttributeFromDut_5();
            break;
        case 6:
            ChipLogProgress(chipTool, " ***** Test Step 6 : TH reads CurrentSaturation attribute from DUT\n");
            if (ShouldSkip("CC.S.F01 && CC.S.A0001")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentSaturationAttributeFromDut_6();
            break;
        case 7:
            ChipLogProgress(chipTool,
                " ***** Test Step 7 : TH sends EnhancedMoveToHueAndSaturation command to DUT with EnhancedHue=16000, Saturation=80 "
                "and TransitionTime=200 (20s)\n");
            if (ShouldSkip("CC.S.F01 && CC.S.C43.Rsp")) {
                NextTest();
                return;
            }
            err = TestThSendsEnhancedMoveToHueAndSaturationCommandToDutWithEnhancedHue16000Saturation80AndTransitionTime20020s_7();
            break;
        case 8:
            ChipLogProgress(chipTool, " ***** Test Step 8 : Wait 10s\n");
            err = TestWait10s_8();
            break;
        case 9:
            ChipLogProgress(chipTool, " ***** Test Step 9 : TH reads EnhancedCurrentHue attribute from DUT\n");
            if (ShouldSkip("CC.S.F01 && CC.S.A4000")) {
                NextTest();
                return;
            }
            err = TestThReadsEnhancedCurrentHueAttributeFromDut_9();
            break;
        case 10:
            ChipLogProgress(chipTool, " ***** Test Step 10 : TH reads CurrentSaturation attribute from DUT\n");
            if (ShouldSkip("CC.S.F01 && CC.S.A0001")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentSaturationAttributeFromDut_10();
            break;
        case 11:
            ChipLogProgress(chipTool, " ***** Test Step 11 : Wait 10s\n");
            err = TestWait10s_11();
            break;
        case 12:
            ChipLogProgress(chipTool, " ***** Test Step 12 : TH reads EnhancedCurrentHue attribute from DUT\n");
            if (ShouldSkip("CC.S.F01 && CC.S.A4000")) {
                NextTest();
                return;
            }
            err = TestThReadsEnhancedCurrentHueAttributeFromDut_12();
            break;
        case 13:
            ChipLogProgress(chipTool, " ***** Test Step 13 : TH reads CurrentSaturation attribute from DUT\n");
            if (ShouldSkip("CC.S.F01 && CC.S.A0001")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentSaturationAttributeFromDut_13();
            break;
        case 14:
            ChipLogProgress(chipTool, " ***** Test Step 14 : Wait 5s\n");
            err = TestWait5s_14();
            break;
        case 15:
            ChipLogProgress(chipTool, " ***** Test Step 15 : TH reads EnhancedCurrentHue attribute from DUT\n");
            if (ShouldSkip("CC.S.F01 && CC.S.A4000")) {
                NextTest();
                return;
            }
            err = TestThReadsEnhancedCurrentHueAttributeFromDut_15();
            break;
        case 16:
            ChipLogProgress(chipTool, " ***** Test Step 16 : TH reads CurrentSaturation attribute from DUT\n");
            if (ShouldSkip("CC.S.F01 && CC.S.A0001")) {
                NextTest();
                return;
            }
            err = TestThReadsCurrentSaturationAttributeFromDut_16();
            break;
        case 17:
            ChipLogProgress(chipTool, " ***** Test Step 17 : TH reads ColorMode attribute from DUT\n");
            if (ShouldSkip("CC.S.F01 && CC.S.A0008")) {
                NextTest();
                return;
            }
            err = TestThReadsColorModeAttributeFromDut_17();
            break;
        case 18:
            ChipLogProgress(chipTool, " ***** Test Step 18 : TH reads EnhancedColorMode attribute from DUT\n");
            if (ShouldSkip("CC.S.F01 && CC.S.A4001")) {
                NextTest();
                return;
            }
            err = TestThReadsEnhancedColorModeAttributeFromDut_18();
            break;
        case 19:
            ChipLogProgress(chipTool, " ***** Test Step 19 : Turn Off light that we turned on\n");
            if (ShouldSkip("OO.S.C00.Rsp")) {
                NextTest();
                return;
            }
            err = TestTurnOffLightThatWeTurnedOn_19();
            break;
        case 20:
            ChipLogProgress(chipTool, " ***** Test Step 20 : Check on/off attribute value is false after off command\n");
            if (ShouldSkip("OO.S.A0000")) {
                NextTest();
                return;
            }
            err = TestCheckOnOffAttributeValueIsFalseAfterOffCommand_20();
            break;
        }

        if (CHIP_NO_ERROR != err) {
            ChipLogError(chipTool, " ***** Test Failure: %s\n", chip::ErrorStr(err));
            SetCommandExitStatus(err);
        }
    }

    void OnStatusUpdate(const chip::app::StatusIB & status) override
    {
        switch (mTestIndex - 1) {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 6:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 7:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 8:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 9:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 10:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 11:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 12:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 13:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 14:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 15:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 16:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 17:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 18:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 19:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 20:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        }

        // Go on to the next test.
        ContinueOnChipMainThread(CHIP_NO_ERROR);
    }

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    std::atomic_uint16_t mTestIndex;
    const uint16_t mTestCount = 21;

    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    CHIP_ERROR TestWaitForTheCommissionedDeviceToBeRetrieved_0()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
        value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
        return WaitForCommissionee("alpha", value);
    }

    CHIP_ERROR TestThWrites0ToTheOptionsAttribute_1()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        id optionsArgument;
        optionsArgument = [NSNumber numberWithUnsignedChar:0U];
        [cluster writeAttributeOptionsWithValue:optionsArgument
                                     completion:^(NSError * _Nullable err) {
                                         NSLog(@"TH writes 0 to the Options attribute Error: %@", err);

                                         VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                                         NextTest();
                                     }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThSendsOnCommandToDut_2()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterOnOff alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster onWithCompletion:^(NSError * _Nullable err) {
            NSLog(@"TH sends On command to DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR
    TestThSendsEnhancedMoveToHueAndSaturationCommandToDutWithEnhancedHue20000Saturation50AndTransitionTime0Immediately_3()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        __auto_type * params = [[MTRColorControlClusterEnhancedMoveToHueAndSaturationParams alloc] init];
        params.enhancedHue = [NSNumber numberWithUnsignedShort:20000U];
        params.saturation = [NSNumber numberWithUnsignedChar:50U];
        params.transitionTime = [NSNumber numberWithUnsignedShort:0U];
        params.optionsMask = [NSNumber numberWithUnsignedChar:0U];
        params.optionsOverride = [NSNumber numberWithUnsignedChar:0U];
        [cluster
            enhancedMoveToHueAndSaturationWithParams:params
                                          completion:^(NSError * _Nullable err) {
                                              NSLog(
                                                  @"TH sends EnhancedMoveToHueAndSaturation command to DUT with EnhancedHue=20000, "
                                                  @"Saturation=50 and TransitionTime=0 (immediately) Error: %@",
                                                  err);

                                              VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                                              NextTest();
                                          }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait100ms_4()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 100UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThReadsEnhancedCurrentHueAttributeFromDut_5()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeEnhancedCurrentHueWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads EnhancedCurrentHue attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("enhancedCurrentHue", [value unsignedShortValue], 17000U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("enhancedCurrentHue", [value unsignedShortValue], 23000U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsCurrentSaturationAttributeFromDut_6()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentSaturationWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentSaturation attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("currentSaturation", [value unsignedCharValue], 42U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("currentSaturation", [value unsignedCharValue], 58U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThSendsEnhancedMoveToHueAndSaturationCommandToDutWithEnhancedHue16000Saturation80AndTransitionTime20020s_7()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        __auto_type * params = [[MTRColorControlClusterEnhancedMoveToHueAndSaturationParams alloc] init];
        params.enhancedHue = [NSNumber numberWithUnsignedShort:16000U];
        params.saturation = [NSNumber numberWithUnsignedChar:80U];
        params.transitionTime = [NSNumber numberWithUnsignedShort:200U];
        params.optionsMask = [NSNumber numberWithUnsignedChar:0U];
        params.optionsOverride = [NSNumber numberWithUnsignedChar:0U];
        [cluster enhancedMoveToHueAndSaturationWithParams:params
                                               completion:^(NSError * _Nullable err) {
                                                   NSLog(@"TH sends EnhancedMoveToHueAndSaturation command to DUT with "
                                                         @"EnhancedHue=16000, Saturation=80 and TransitionTime=200 (20s) Error: %@",
                                                       err);

                                                   VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                                                   NextTest();
                                               }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait10s_8()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 10000UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThReadsEnhancedCurrentHueAttributeFromDut_9()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeEnhancedCurrentHueWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads EnhancedCurrentHue attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("enhancedCurrentHue", "int16u", "int16u"));
            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("enhancedCurrentHue", [value unsignedShortValue], 16000U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("enhancedCurrentHue", [value unsignedShortValue], 20000U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsCurrentSaturationAttributeFromDut_10()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentSaturationWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentSaturation attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("currentSaturation", [value unsignedCharValue], 50U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("currentSaturation", [value unsignedCharValue], 80U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait10s_11()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 10000UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThReadsEnhancedCurrentHueAttributeFromDut_12()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeEnhancedCurrentHueWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads EnhancedCurrentHue attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("enhancedCurrentHue", "int16u", "int16u"));
            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("enhancedCurrentHue", [value unsignedShortValue], 13600U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("enhancedCurrentHue", [value unsignedShortValue], 18400U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsCurrentSaturationAttributeFromDut_13()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentSaturationWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentSaturation attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("currentSaturation", [value unsignedCharValue], 68U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("currentSaturation", [value unsignedCharValue], 92U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestWait5s_14()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
        value.ms = 5000UL;
        return WaitForMs("alpha", value);
    }

    CHIP_ERROR TestThReadsEnhancedCurrentHueAttributeFromDut_15()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeEnhancedCurrentHueWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads EnhancedCurrentHue attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("EnhancedCurrentHue", actualValue, 16000U));
            }

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsCurrentSaturationAttributeFromDut_16()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCurrentSaturationWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CurrentSaturation attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("CurrentSaturation", actualValue, 80U));
            }

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsColorModeAttributeFromDut_17()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeColorModeWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads ColorMode attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("ColorMode", actualValue, 0U));
            }

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("colorMode", [value unsignedCharValue], 0U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("colorMode", [value unsignedCharValue], 2U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsEnhancedColorModeAttributeFromDut_18()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterColorControl alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeEnhancedColorModeWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads EnhancedColorMode attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("EnhancedColorMode", actualValue, 3U));
            }

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("enhancedColorMode", [value unsignedCharValue], 0U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("enhancedColorMode", [value unsignedCharValue], 3U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestTurnOffLightThatWeTurnedOn_19()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterOnOff alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster offWithCompletion:^(NSError * _Nullable err) {
            NSLog(@"Turn Off light that we turned on Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestCheckOnOffAttributeValueIsFalseAfterOffCommand_20()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterOnOff alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeOnOffWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Check on/off attribute value is false after off command Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("OnOff", actualValue, 0));
            }

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }
};

class Test_TC_OPCREDS_1_2 : public TestCommandBridge {
public:
    // NOLINTBEGIN(clang-analyzer-nullability.NullPassedToNonnull): Test constructor nullability not enforced
    Test_TC_OPCREDS_1_2()
        : TestCommandBridge("Test_TC_OPCREDS_1_2")
        , mTestIndex(0)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }
    // NOLINTEND(clang-analyzer-nullability.NullPassedToNonnull)

    ~Test_TC_OPCREDS_1_2() {}

    /////////// TestCommand Interface /////////
    void NextTest() override
    {
        CHIP_ERROR err = CHIP_NO_ERROR;

        if (0 == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Start: Test_TC_OPCREDS_1_2\n");
        }

        if (mTestCount == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Complete: Test_TC_OPCREDS_1_2\n");
            SetCommandExitStatus(CHIP_NO_ERROR);
            return;
        }

        Wait();

        // Ensure we increment mTestIndex before we start running the relevant
        // command.  That way if we lose the timeslice after we send the message
        // but before our function call returns, we won't end up with an
        // incorrect mTestIndex value observed when we get the response.
        switch (mTestIndex++) {
        case 0:
            ChipLogProgress(chipTool, " ***** Test Step 0 : Wait for the commissioned device to be retrieved\n");
            err = TestWaitForTheCommissionedDeviceToBeRetrieved_0();
            break;
        case 1:
            ChipLogProgress(chipTool, " ***** Test Step 1 : TH reads the ClusterRevision from DUT\n");
            err = TestThReadsTheClusterRevisionFromDut_1();
            break;
        case 2:
            ChipLogProgress(chipTool, " ***** Test Step 2 : TH reads the FeatureMap from DUT\n");
            err = TestThReadsTheFeatureMapFromDut_2();
            break;
        case 3:
            ChipLogProgress(chipTool, " ***** Test Step 3 : TH reads AttributeList from DUT\n");
            err = TestThReadsAttributeListFromDut_3();
            break;
        case 4:
            ChipLogProgress(chipTool, " ***** Test Step 4 : TH reads AcceptedCommandList from DUT\n");
            err = TestThReadsAcceptedCommandListFromDut_4();
            break;
        case 5:
            ChipLogProgress(chipTool, " ***** Test Step 5 : TH reads GeneratedCommandList from DUT\n");
            err = TestThReadsGeneratedCommandListFromDut_5();
            break;
        }

        if (CHIP_NO_ERROR != err) {
            ChipLogError(chipTool, " ***** Test Failure: %s\n", chip::ErrorStr(err));
            SetCommandExitStatus(err);
        }
    }

    void OnStatusUpdate(const chip::app::StatusIB & status) override
    {
        switch (mTestIndex - 1) {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        }

        // Go on to the next test.
        ContinueOnChipMainThread(CHIP_NO_ERROR);
    }

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    std::atomic_uint16_t mTestIndex;
    const uint16_t mTestCount = 6;

    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    CHIP_ERROR TestWaitForTheCommissionedDeviceToBeRetrieved_0()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
        value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
        return WaitForCommissionee("alpha", value);
    }

    CHIP_ERROR TestThReadsTheClusterRevisionFromDut_1()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterOperationalCredentials alloc] initWithDevice:device
                                                                                    endpoint:@(0)
                                                                                       queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeClusterRevisionWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads the ClusterRevision from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("ClusterRevision", actualValue, 1U));
            }

            VerifyOrReturn(CheckConstraintType("clusterRevision", "int16u", "int16u"));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsTheFeatureMapFromDut_2()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterOperationalCredentials alloc] initWithDevice:device
                                                                                    endpoint:@(0)
                                                                                       queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeFeatureMapWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads the FeatureMap from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("FeatureMap", actualValue, 0UL));
            }

            VerifyOrReturn(CheckConstraintType("featureMap", "bitmap32", "bitmap32"));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsAttributeListFromDut_3()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterOperationalCredentials alloc] initWithDevice:device
                                                                                    endpoint:@(0)
                                                                                       queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAttributeListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads AttributeList from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("attributeList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65533UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65532UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65531UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65529UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65528UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 0UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 1UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 2UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 3UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 4UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 5UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsAcceptedCommandListFromDut_4()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterOperationalCredentials alloc] initWithDevice:device
                                                                                    endpoint:@(0)
                                                                                       queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAcceptedCommandListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads AcceptedCommandList from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("acceptedCommandList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("acceptedCommandList", value, 0UL));
            VerifyOrReturn(CheckConstraintContains("acceptedCommandList", value, 2UL));
            VerifyOrReturn(CheckConstraintContains("acceptedCommandList", value, 4UL));
            VerifyOrReturn(CheckConstraintContains("acceptedCommandList", value, 6UL));
            VerifyOrReturn(CheckConstraintContains("acceptedCommandList", value, 7UL));
            VerifyOrReturn(CheckConstraintContains("acceptedCommandList", value, 9UL));
            VerifyOrReturn(CheckConstraintContains("acceptedCommandList", value, 10UL));
            VerifyOrReturn(CheckConstraintContains("acceptedCommandList", value, 11UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsGeneratedCommandListFromDut_5()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterOperationalCredentials alloc] initWithDevice:device
                                                                                    endpoint:@(0)
                                                                                       queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeGeneratedCommandListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads GeneratedCommandList from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("generatedCommandList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("generatedCommandList", value, 1UL));
            VerifyOrReturn(CheckConstraintContains("generatedCommandList", value, 3UL));
            VerifyOrReturn(CheckConstraintContains("generatedCommandList", value, 5UL));
            VerifyOrReturn(CheckConstraintContains("generatedCommandList", value, 8UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }
};

class Test_TC_BINFO_1_1 : public TestCommandBridge {
public:
    // NOLINTBEGIN(clang-analyzer-nullability.NullPassedToNonnull): Test constructor nullability not enforced
    Test_TC_BINFO_1_1()
        : TestCommandBridge("Test_TC_BINFO_1_1")
        , mTestIndex(0)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }
    // NOLINTEND(clang-analyzer-nullability.NullPassedToNonnull)

    ~Test_TC_BINFO_1_1() {}

    /////////// TestCommand Interface /////////
    void NextTest() override
    {
        CHIP_ERROR err = CHIP_NO_ERROR;

        if (0 == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Start: Test_TC_BINFO_1_1\n");
        }

        if (mTestCount == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Complete: Test_TC_BINFO_1_1\n");
            SetCommandExitStatus(CHIP_NO_ERROR);
            return;
        }

        Wait();

        // Ensure we increment mTestIndex before we start running the relevant
        // command.  That way if we lose the timeslice after we send the message
        // but before our function call returns, we won't end up with an
        // incorrect mTestIndex value observed when we get the response.
        switch (mTestIndex++) {
        case 0:
            ChipLogProgress(chipTool, " ***** Test Step 0 : Wait for the commissioned device to be retrieved\n");
            err = TestWaitForTheCommissionedDeviceToBeRetrieved_0();
            break;
        case 1:
            ChipLogProgress(chipTool, " ***** Test Step 1 : TH reads the ClusterRevision from DUT\n");
            err = TestThReadsTheClusterRevisionFromDut_1();
            break;
        case 2:
            ChipLogProgress(chipTool, " ***** Test Step 2 : TH reads the FeatureMap from DUT\n");
            err = TestThReadsTheFeatureMapFromDut_2();
            break;
        case 3:
            ChipLogProgress(chipTool, " ***** Test Step 3 : TH reads AttributeList from DUT\n");
            err = TestThReadsAttributeListFromDut_3();
            break;
        case 4:
            ChipLogProgress(chipTool, " ***** Test Step 4 : TH reads optional attribute(ManufacturingDate) in attributeList\n");
            if (ShouldSkip("BINFO.S.A000b")) {
                NextTest();
                return;
            }
            err = TestThReadsOptionalAttributeManufacturingDateInAttributeList_4();
            break;
        case 5:
            ChipLogProgress(chipTool, " ***** Test Step 5 : TH reads optional attribute(PartNumber) in attributeList\n");
            if (ShouldSkip("BINFO.S.A000c")) {
                NextTest();
                return;
            }
            err = TestThReadsOptionalAttributePartNumberInAttributeList_5();
            break;
        case 6:
            ChipLogProgress(chipTool, " ***** Test Step 6 : TH reads optional attribute(ProductURL) in attributeList\n");
            if (ShouldSkip("BINFO.S.A000d")) {
                NextTest();
                return;
            }
            err = TestThReadsOptionalAttributeProductURLInAttributeList_6();
            break;
        case 7:
            ChipLogProgress(chipTool, " ***** Test Step 7 : TH reads optional attribute(ProductLabel) in attributeList\n");
            if (ShouldSkip("BINFO.S.A000e")) {
                NextTest();
                return;
            }
            err = TestThReadsOptionalAttributeProductLabelInAttributeList_7();
            break;
        case 8:
            ChipLogProgress(chipTool, " ***** Test Step 8 : TH reads optional attribute(SerialNumber) in attributeList\n");
            if (ShouldSkip("BINFO.S.A000f")) {
                NextTest();
                return;
            }
            err = TestThReadsOptionalAttributeSerialNumberInAttributeList_8();
            break;
        case 9:
            ChipLogProgress(chipTool, " ***** Test Step 9 : TH reads optional attribute(LocalConfigDisabled) in attributeList\n");
            if (ShouldSkip("BINFO.S.A0010")) {
                NextTest();
                return;
            }
            err = TestThReadsOptionalAttributeLocalConfigDisabledInAttributeList_9();
            break;
        case 10:
            ChipLogProgress(chipTool, " ***** Test Step 10 : TH reads optional attribute(Reachable) in attributeList\n");
            if (ShouldSkip("BINFO.S.A0011")) {
                NextTest();
                return;
            }
            err = TestThReadsOptionalAttributeReachableInAttributeList_10();
            break;
        case 11:
            ChipLogProgress(chipTool, " ***** Test Step 11 : TH reads optional attribute(UniqueID) in attributeList\n");
            if (ShouldSkip("BINFO.S.A0012")) {
                NextTest();
                return;
            }
            err = TestThReadsOptionalAttributeUniqueIDInAttributeList_11();
            break;
        case 12:
            ChipLogProgress(chipTool, " ***** Test Step 12 : TH1 reads AcceptedCommandList from DUT\n");
            err = TestTh1ReadsAcceptedCommandListFromDut_12();
            break;
        case 13:
            ChipLogProgress(chipTool, " ***** Test Step 13 : TH1 reads GeneratedCommandList from DUT\n");
            err = TestTh1ReadsGeneratedCommandListFromDut_13();
            break;
        }

        if (CHIP_NO_ERROR != err) {
            ChipLogError(chipTool, " ***** Test Failure: %s\n", chip::ErrorStr(err));
            SetCommandExitStatus(err);
        }
    }

    void OnStatusUpdate(const chip::app::StatusIB & status) override
    {
        switch (mTestIndex - 1) {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 6:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 7:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 8:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 9:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 10:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 11:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 12:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 13:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        }

        // Go on to the next test.
        ContinueOnChipMainThread(CHIP_NO_ERROR);
    }

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    std::atomic_uint16_t mTestIndex;
    const uint16_t mTestCount = 14;

    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    CHIP_ERROR TestWaitForTheCommissionedDeviceToBeRetrieved_0()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
        value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
        return WaitForCommissionee("alpha", value);
    }

    CHIP_ERROR TestThReadsTheClusterRevisionFromDut_1()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterBasic alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeClusterRevisionWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads the ClusterRevision from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("ClusterRevision", actualValue, 1U));
            }

            VerifyOrReturn(CheckConstraintType("clusterRevision", "int16u", "int16u"));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsTheFeatureMapFromDut_2()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterBasic alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeFeatureMapWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads the FeatureMap from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("FeatureMap", actualValue, 0UL));
            }

            VerifyOrReturn(CheckConstraintType("featureMap", "bitmap32", "bitmap32"));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsAttributeListFromDut_3()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterBasic alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAttributeListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads AttributeList from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("attributeList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 0UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 1UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 2UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 3UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 4UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 5UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 6UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 7UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 8UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 9UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 10UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 19UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65528UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65529UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65531UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65532UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65533UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsOptionalAttributeManufacturingDateInAttributeList_4()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterBasic alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAttributeListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads optional attribute(ManufacturingDate) in attributeList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("attributeList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 11UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsOptionalAttributePartNumberInAttributeList_5()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterBasic alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAttributeListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads optional attribute(PartNumber) in attributeList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("attributeList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 12UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsOptionalAttributeProductURLInAttributeList_6()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterBasic alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAttributeListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads optional attribute(ProductURL) in attributeList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("attributeList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 13UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsOptionalAttributeProductLabelInAttributeList_7()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterBasic alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAttributeListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads optional attribute(ProductLabel) in attributeList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("attributeList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 14UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsOptionalAttributeSerialNumberInAttributeList_8()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterBasic alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAttributeListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads optional attribute(SerialNumber) in attributeList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("attributeList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 15UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsOptionalAttributeLocalConfigDisabledInAttributeList_9()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterBasic alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAttributeListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads optional attribute(LocalConfigDisabled) in attributeList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("attributeList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 16UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsOptionalAttributeReachableInAttributeList_10()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterBasic alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAttributeListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads optional attribute(Reachable) in attributeList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("attributeList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 17UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsOptionalAttributeUniqueIDInAttributeList_11()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterBasic alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAttributeListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads optional attribute(UniqueID) in attributeList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("attributeList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 18UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestTh1ReadsAcceptedCommandListFromDut_12()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterBasic alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAcceptedCommandListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH1 reads AcceptedCommandList from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("AcceptedCommandList", [actualValue count], static_cast<uint32_t>(0)));
            }

            VerifyOrReturn(CheckConstraintType("acceptedCommandList", "list", "list"));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestTh1ReadsGeneratedCommandListFromDut_13()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterBasic alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeGeneratedCommandListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH1 reads GeneratedCommandList from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("GeneratedCommandList", [actualValue count], static_cast<uint32_t>(0)));
            }

            VerifyOrReturn(CheckConstraintType("generatedCommandList", "list", "list"));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }
};

class Test_TC_CNET_1_3 : public TestCommandBridge {
public:
    // NOLINTBEGIN(clang-analyzer-nullability.NullPassedToNonnull): Test constructor nullability not enforced
    Test_TC_CNET_1_3()
        : TestCommandBridge("Test_TC_CNET_1_3")
        , mTestIndex(0)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }
    // NOLINTEND(clang-analyzer-nullability.NullPassedToNonnull)

    ~Test_TC_CNET_1_3() {}

    /////////// TestCommand Interface /////////
    void NextTest() override
    {
        CHIP_ERROR err = CHIP_NO_ERROR;

        if (0 == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Start: Test_TC_CNET_1_3\n");
        }

        if (mTestCount == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Complete: Test_TC_CNET_1_3\n");
            SetCommandExitStatus(CHIP_NO_ERROR);
            return;
        }

        Wait();

        // Ensure we increment mTestIndex before we start running the relevant
        // command.  That way if we lose the timeslice after we send the message
        // but before our function call returns, we won't end up with an
        // incorrect mTestIndex value observed when we get the response.
        switch (mTestIndex++) {
        }

        if (CHIP_NO_ERROR != err) {
            ChipLogError(chipTool, " ***** Test Failure: %s\n", chip::ErrorStr(err));
            SetCommandExitStatus(err);
        }
    }

    void OnStatusUpdate(const chip::app::StatusIB & status) override
    {
        switch (mTestIndex - 1) {
        }

        // Go on to the next test.
        ContinueOnChipMainThread(CHIP_NO_ERROR);
    }

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    std::atomic_uint16_t mTestIndex;
    const uint16_t mTestCount = 0;

    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;
};

class Test_TC_DESC_1_1 : public TestCommandBridge {
public:
    // NOLINTBEGIN(clang-analyzer-nullability.NullPassedToNonnull): Test constructor nullability not enforced
    Test_TC_DESC_1_1()
        : TestCommandBridge("Test_TC_DESC_1_1")
        , mTestIndex(0)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }
    // NOLINTEND(clang-analyzer-nullability.NullPassedToNonnull)

    ~Test_TC_DESC_1_1() {}

    /////////// TestCommand Interface /////////
    void NextTest() override
    {
        CHIP_ERROR err = CHIP_NO_ERROR;

        if (0 == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Start: Test_TC_DESC_1_1\n");
        }

        if (mTestCount == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Complete: Test_TC_DESC_1_1\n");
            SetCommandExitStatus(CHIP_NO_ERROR);
            return;
        }

        Wait();

        // Ensure we increment mTestIndex before we start running the relevant
        // command.  That way if we lose the timeslice after we send the message
        // but before our function call returns, we won't end up with an
        // incorrect mTestIndex value observed when we get the response.
        switch (mTestIndex++) {
        case 0:
            ChipLogProgress(chipTool, " ***** Test Step 0 : Wait for the commissioned device to be retrieved\n");
            err = TestWaitForTheCommissionedDeviceToBeRetrieved_0();
            break;
        case 1:
            ChipLogProgress(chipTool, " ***** Test Step 1 : Read the global attribute: ClusterRevision\n");
            err = TestReadTheGlobalAttributeClusterRevision_1();
            break;
        case 2:
            ChipLogProgress(chipTool, " ***** Test Step 2 : Read the global attribute: FeatureMap\n");
            err = TestReadTheGlobalAttributeFeatureMap_2();
            break;
        case 3:
            ChipLogProgress(chipTool, " ***** Test Step 3 : Read the global attribute: AttributeList\n");
            err = TestReadTheGlobalAttributeAttributeList_3();
            break;
        case 4:
            ChipLogProgress(chipTool, " ***** Test Step 4 : Read the global attribute: AcceptedCommandList\n");
            err = TestReadTheGlobalAttributeAcceptedCommandList_4();
            break;
        case 5:
            ChipLogProgress(chipTool, " ***** Test Step 5 : Read the global attribute: GeneratedCommandList\n");
            err = TestReadTheGlobalAttributeGeneratedCommandList_5();
            break;
        }

        if (CHIP_NO_ERROR != err) {
            ChipLogError(chipTool, " ***** Test Failure: %s\n", chip::ErrorStr(err));
            SetCommandExitStatus(err);
        }
    }

    void OnStatusUpdate(const chip::app::StatusIB & status) override
    {
        switch (mTestIndex - 1) {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        }

        // Go on to the next test.
        ContinueOnChipMainThread(CHIP_NO_ERROR);
    }

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    std::atomic_uint16_t mTestIndex;
    const uint16_t mTestCount = 6;

    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    CHIP_ERROR TestWaitForTheCommissionedDeviceToBeRetrieved_0()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
        value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
        return WaitForCommissionee("alpha", value);
    }

    CHIP_ERROR TestReadTheGlobalAttributeClusterRevision_1()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterDescriptor alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeClusterRevisionWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the global attribute: ClusterRevision Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("ClusterRevision", actualValue, 1U));
            }

            VerifyOrReturn(CheckConstraintType("clusterRevision", "int16u", "int16u"));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheGlobalAttributeFeatureMap_2()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterDescriptor alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeFeatureMapWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the global attribute: FeatureMap Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("FeatureMap", actualValue, 0UL));
            }

            VerifyOrReturn(CheckConstraintType("featureMap", "bitmap32", "bitmap32"));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheGlobalAttributeAttributeList_3()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterDescriptor alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAttributeListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the global attribute: AttributeList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("attributeList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 0UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 1UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 2UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 3UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65528UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65529UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65531UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65532UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65533UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheGlobalAttributeAcceptedCommandList_4()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterDescriptor alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAcceptedCommandListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the global attribute: AcceptedCommandList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("AcceptedCommandList", [actualValue count], static_cast<uint32_t>(0)));
            }

            VerifyOrReturn(CheckConstraintType("acceptedCommandList", "list", "list"));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheGlobalAttributeGeneratedCommandList_5()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterDescriptor alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeGeneratedCommandListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the global attribute: GeneratedCommandList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("GeneratedCommandList", [actualValue count], static_cast<uint32_t>(0)));
            }

            VerifyOrReturn(CheckConstraintType("generatedCommandList", "list", "list"));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }
};

class Test_TC_DLOG_1_1 : public TestCommandBridge {
public:
    // NOLINTBEGIN(clang-analyzer-nullability.NullPassedToNonnull): Test constructor nullability not enforced
    Test_TC_DLOG_1_1()
        : TestCommandBridge("Test_TC_DLOG_1_1")
        , mTestIndex(0)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }
    // NOLINTEND(clang-analyzer-nullability.NullPassedToNonnull)

    ~Test_TC_DLOG_1_1() {}

    /////////// TestCommand Interface /////////
    void NextTest() override
    {
        CHIP_ERROR err = CHIP_NO_ERROR;

        if (0 == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Start: Test_TC_DLOG_1_1\n");
        }

        if (mTestCount == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Complete: Test_TC_DLOG_1_1\n");
            SetCommandExitStatus(CHIP_NO_ERROR);
            return;
        }

        Wait();

        // Ensure we increment mTestIndex before we start running the relevant
        // command.  That way if we lose the timeslice after we send the message
        // but before our function call returns, we won't end up with an
        // incorrect mTestIndex value observed when we get the response.
        switch (mTestIndex++) {
        case 0:
            ChipLogProgress(chipTool, " ***** Test Step 0 : Wait for the commissioned device to be retrieved\n");
            err = TestWaitForTheCommissionedDeviceToBeRetrieved_0();
            break;
        case 1:
            ChipLogProgress(chipTool, " ***** Test Step 1 : TH reads the ClusterRevision from DUT\n");
            err = TestThReadsTheClusterRevisionFromDut_1();
            break;
        case 2:
            ChipLogProgress(chipTool, " ***** Test Step 2 : TH reads the FeatureMap from DUT\n");
            err = TestThReadsTheFeatureMapFromDut_2();
            break;
        case 3:
            ChipLogProgress(chipTool, " ***** Test Step 3 : TH reads AttributeList from DUT\n");
            err = TestThReadsAttributeListFromDut_3();
            break;
        case 4:
            ChipLogProgress(chipTool, " ***** Test Step 4 : TH reads AcceptedCommandList from DUT\n");
            err = TestThReadsAcceptedCommandListFromDut_4();
            break;
        case 5:
            ChipLogProgress(chipTool, " ***** Test Step 5 : TH reads GeneratedCommandList from DUT\n");
            err = TestThReadsGeneratedCommandListFromDut_5();
            break;
        }

        if (CHIP_NO_ERROR != err) {
            ChipLogError(chipTool, " ***** Test Failure: %s\n", chip::ErrorStr(err));
            SetCommandExitStatus(err);
        }
    }

    void OnStatusUpdate(const chip::app::StatusIB & status) override
    {
        switch (mTestIndex - 1) {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        }

        // Go on to the next test.
        ContinueOnChipMainThread(CHIP_NO_ERROR);
    }

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    std::atomic_uint16_t mTestIndex;
    const uint16_t mTestCount = 6;

    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    CHIP_ERROR TestWaitForTheCommissionedDeviceToBeRetrieved_0()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
        value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
        return WaitForCommissionee("alpha", value);
    }

    CHIP_ERROR TestThReadsTheClusterRevisionFromDut_1()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterDiagnosticLogs alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeClusterRevisionWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads the ClusterRevision from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("ClusterRevision", actualValue, 1U));
            }

            VerifyOrReturn(CheckConstraintType("clusterRevision", "int16u", "int16u"));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsTheFeatureMapFromDut_2()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterDiagnosticLogs alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeFeatureMapWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads the FeatureMap from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("FeatureMap", actualValue, 0UL));
            }

            VerifyOrReturn(CheckConstraintType("featureMap", "bitmap32", "bitmap32"));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsAttributeListFromDut_3()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterDiagnosticLogs alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAttributeListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads AttributeList from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("attributeList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65528UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65529UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65531UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65532UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65533UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsAcceptedCommandListFromDut_4()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterDiagnosticLogs alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAcceptedCommandListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads AcceptedCommandList from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("AcceptedCommandList", [actualValue count], static_cast<uint32_t>(1)));
                VerifyOrReturn(CheckValue("", actualValue[0], 0UL));
            }

            VerifyOrReturn(CheckConstraintType("acceptedCommandList", "list", "list"));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsGeneratedCommandListFromDut_5()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterDiagnosticLogs alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeGeneratedCommandListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads GeneratedCommandList from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("GeneratedCommandList", [actualValue count], static_cast<uint32_t>(1)));
                VerifyOrReturn(CheckValue("", actualValue[0], 1UL));
            }

            VerifyOrReturn(CheckConstraintType("generatedCommandList", "list", "list"));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }
};

class Test_TC_DGETH_1_1 : public TestCommandBridge {
public:
    // NOLINTBEGIN(clang-analyzer-nullability.NullPassedToNonnull): Test constructor nullability not enforced
    Test_TC_DGETH_1_1()
        : TestCommandBridge("Test_TC_DGETH_1_1")
        , mTestIndex(0)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }
    // NOLINTEND(clang-analyzer-nullability.NullPassedToNonnull)

    ~Test_TC_DGETH_1_1() {}

    /////////// TestCommand Interface /////////
    void NextTest() override
    {
        CHIP_ERROR err = CHIP_NO_ERROR;

        if (0 == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Start: Test_TC_DGETH_1_1\n");
        }

        if (mTestCount == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Complete: Test_TC_DGETH_1_1\n");
            SetCommandExitStatus(CHIP_NO_ERROR);
            return;
        }

        Wait();

        // Ensure we increment mTestIndex before we start running the relevant
        // command.  That way if we lose the timeslice after we send the message
        // but before our function call returns, we won't end up with an
        // incorrect mTestIndex value observed when we get the response.
        switch (mTestIndex++) {
        case 0:
            ChipLogProgress(chipTool, " ***** Test Step 0 : Wait for the commissioned device to be retrieved\n");
            err = TestWaitForTheCommissionedDeviceToBeRetrieved_0();
            break;
        case 1:
            ChipLogProgress(chipTool, " ***** Test Step 1 : TH reads the ClusterRevision from DUT\n");
            err = TestThReadsTheClusterRevisionFromDut_1();
            break;
        case 2:
            ChipLogProgress(chipTool, " ***** Test Step 2 : TH reads the FeatureMap from DUT\n");
            if (ShouldSkip(" !DGETH.S.F00 && !DGETH.S.F01")) {
                NextTest();
                return;
            }
            err = TestThReadsTheFeatureMapFromDut_2();
            break;
        case 3:
            ChipLogProgress(chipTool, " ***** Test Step 3 : Given DGETH.S.F00 ensure featuremap has the correct bit set\n");
            if (ShouldSkip("DGETH.S.F00")) {
                NextTest();
                return;
            }
            err = TestGivenDgethsf00EnsureFeaturemapHasTheCorrectBitSet_3();
            break;
        case 4:
            ChipLogProgress(chipTool, " ***** Test Step 4 : Given DGETH.S.F01 ensure featuremap has the correct bit set\n");
            if (ShouldSkip("DGETH.S.F01")) {
                NextTest();
                return;
            }
            err = TestGivenDgethsf01EnsureFeaturemapHasTheCorrectBitSet_4();
            break;
        case 5:
            ChipLogProgress(chipTool, " ***** Test Step 5 : TH reads AttributeList from DUT\n");
            err = TestThReadsAttributeListFromDut_5();
            break;
        case 6:
            ChipLogProgress(chipTool, " ***** Test Step 6 : TH reads optional attribute(PHYRate) in AttributeList\n");
            if (ShouldSkip("DGETH.S.A0000")) {
                NextTest();
                return;
            }
            err = TestThReadsOptionalAttributePHYRateInAttributeList_6();
            break;
        case 7:
            ChipLogProgress(chipTool, " ***** Test Step 7 : TH reads optional attribute(FullDuplex) in AttributeList\n");
            if (ShouldSkip("DGETH.S.A0001")) {
                NextTest();
                return;
            }
            err = TestThReadsOptionalAttributeFullDuplexInAttributeList_7();
            break;
        case 8:
            ChipLogProgress(chipTool,
                " ***** Test Step 8 : TH reads optional attribute(PacketRxCount) and Feature dependent(DGETH.S.F00(PKTCNT)) in "
                "AttributeList\n");
            if (ShouldSkip("DGETH.S.A0002")) {
                NextTest();
                return;
            }
            err = TestThReadsOptionalAttributePacketRxCountAndFeatureDependentDGETHSF00PKTCNTInAttributeList_8();
            break;
        case 9:
            ChipLogProgress(chipTool,
                " ***** Test Step 9 : TH reads optional attribute(PacketRxCount) and Feature dependent(DGETH.S.F00(PKTCNT)) in "
                "AttributeList\n");
            if (ShouldSkip("DGETH.S.A0003")) {
                NextTest();
                return;
            }
            err = TestThReadsOptionalAttributePacketRxCountAndFeatureDependentDGETHSF00PKTCNTInAttributeList_9();
            break;
        case 10:
            ChipLogProgress(chipTool,
                " ***** Test Step 10 : TH reads optional attribute(PacketRxCount) and Feature dependent(DGETH.S.F01(ERRCNT)) in "
                "AttributeList\n");
            if (ShouldSkip("DGETH.S.A0004")) {
                NextTest();
                return;
            }
            err = TestThReadsOptionalAttributePacketRxCountAndFeatureDependentDGETHSF01ERRCNTInAttributeList_10();
            break;
        case 11:
            ChipLogProgress(chipTool,
                " ***** Test Step 11 : TH reads optional attribute(PacketRxCount) and Feature dependent(DGETH.S.F01(ERRCNT)) in "
                "AttributeList\n");
            if (ShouldSkip("DGETH.S.A0005")) {
                NextTest();
                return;
            }
            err = TestThReadsOptionalAttributePacketRxCountAndFeatureDependentDGETHSF01ERRCNTInAttributeList_11();
            break;
        case 12:
            ChipLogProgress(chipTool,
                " ***** Test Step 12 : TH reads optional attribute(PacketRxCount) and Feature dependent(DGETH.S.F01(ERRCNT)) in "
                "AttributeList\n");
            if (ShouldSkip("DGETH.S.A0006")) {
                NextTest();
                return;
            }
            err = TestThReadsOptionalAttributePacketRxCountAndFeatureDependentDGETHSF01ERRCNTInAttributeList_12();
            break;
        case 13:
            ChipLogProgress(chipTool, " ***** Test Step 13 : TH reads optional attribute(CarrierDetect) in AttributeList\n");
            if (ShouldSkip("DGETH.S.A0007")) {
                NextTest();
                return;
            }
            err = TestThReadsOptionalAttributeCarrierDetectInAttributeList_13();
            break;
        case 14:
            ChipLogProgress(chipTool, " ***** Test Step 14 : TH reads optional attribute(TimeSinceReset) in AttributeList\n");
            if (ShouldSkip("DGETH.S.A0008")) {
                NextTest();
                return;
            }
            err = TestThReadsOptionalAttributeTimeSinceResetInAttributeList_14();
            break;
        case 15:
            ChipLogProgress(chipTool, " ***** Test Step 15 : TH reads AcceptedCommandList from DUT\n");
            if (ShouldSkip("DGETH.S.F00 || DGETH.S.F01")) {
                NextTest();
                return;
            }
            err = TestThReadsAcceptedCommandListFromDut_15();
            break;
        case 16:
            ChipLogProgress(chipTool, " ***** Test Step 16 : TH reads AcceptedCommandList from DUT\n");
            if (ShouldSkip(" !DGETH.S.F00 && !DGETH.S.F01 ")) {
                NextTest();
                return;
            }
            err = TestThReadsAcceptedCommandListFromDut_16();
            break;
        case 17:
            ChipLogProgress(chipTool, " ***** Test Step 17 : TH reads GeneratedCommandList from DUT\n");
            err = TestThReadsGeneratedCommandListFromDut_17();
            break;
        }

        if (CHIP_NO_ERROR != err) {
            ChipLogError(chipTool, " ***** Test Failure: %s\n", chip::ErrorStr(err));
            SetCommandExitStatus(err);
        }
    }

    void OnStatusUpdate(const chip::app::StatusIB & status) override
    {
        switch (mTestIndex - 1) {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 6:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 7:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 8:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 9:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 10:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 11:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 12:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 13:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 14:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 15:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 16:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 17:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        }

        // Go on to the next test.
        ContinueOnChipMainThread(CHIP_NO_ERROR);
    }

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    std::atomic_uint16_t mTestIndex;
    const uint16_t mTestCount = 18;

    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    CHIP_ERROR TestWaitForTheCommissionedDeviceToBeRetrieved_0()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
        value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
        return WaitForCommissionee("alpha", value);
    }

    CHIP_ERROR TestThReadsTheClusterRevisionFromDut_1()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterEthernetNetworkDiagnostics alloc] initWithDevice:device
                                                                                        endpoint:@(0)
                                                                                           queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeClusterRevisionWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads the ClusterRevision from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("ClusterRevision", actualValue, 1U));
            }

            VerifyOrReturn(CheckConstraintType("clusterRevision", "int16u", "int16u"));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsTheFeatureMapFromDut_2()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterEthernetNetworkDiagnostics alloc] initWithDevice:device
                                                                                        endpoint:@(0)
                                                                                           queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeFeatureMapWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads the FeatureMap from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("FeatureMap", actualValue, 0UL));
            }

            VerifyOrReturn(CheckConstraintType("featureMap", "bitmap32", "bitmap32"));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestGivenDgethsf00EnsureFeaturemapHasTheCorrectBitSet_3()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterEthernetNetworkDiagnostics alloc] initWithDevice:device
                                                                                        endpoint:@(0)
                                                                                           queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeFeatureMapWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Given DGETH.S.F00 ensure featuremap has the correct bit set Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("featureMap", "bitmap32", "bitmap32"));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestGivenDgethsf01EnsureFeaturemapHasTheCorrectBitSet_4()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterEthernetNetworkDiagnostics alloc] initWithDevice:device
                                                                                        endpoint:@(0)
                                                                                           queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeFeatureMapWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Given DGETH.S.F01 ensure featuremap has the correct bit set Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("featureMap", "bitmap32", "bitmap32"));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsAttributeListFromDut_5()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterEthernetNetworkDiagnostics alloc] initWithDevice:device
                                                                                        endpoint:@(0)
                                                                                           queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAttributeListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads AttributeList from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("attributeList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65528UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65529UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65531UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65532UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65533UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsOptionalAttributePHYRateInAttributeList_6()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterEthernetNetworkDiagnostics alloc] initWithDevice:device
                                                                                        endpoint:@(0)
                                                                                           queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAttributeListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads optional attribute(PHYRate) in AttributeList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("attributeList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 0UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsOptionalAttributeFullDuplexInAttributeList_7()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterEthernetNetworkDiagnostics alloc] initWithDevice:device
                                                                                        endpoint:@(0)
                                                                                           queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAttributeListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads optional attribute(FullDuplex) in AttributeList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("attributeList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 1UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsOptionalAttributePacketRxCountAndFeatureDependentDGETHSF00PKTCNTInAttributeList_8()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterEthernetNetworkDiagnostics alloc] initWithDevice:device
                                                                                        endpoint:@(0)
                                                                                           queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAttributeListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(
                @"TH reads optional attribute(PacketRxCount) and Feature dependent(DGETH.S.F00(PKTCNT)) in AttributeList Error: %@",
                err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("attributeList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 2UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsOptionalAttributePacketRxCountAndFeatureDependentDGETHSF00PKTCNTInAttributeList_9()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterEthernetNetworkDiagnostics alloc] initWithDevice:device
                                                                                        endpoint:@(0)
                                                                                           queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAttributeListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(
                @"TH reads optional attribute(PacketRxCount) and Feature dependent(DGETH.S.F00(PKTCNT)) in AttributeList Error: %@",
                err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("attributeList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 3UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsOptionalAttributePacketRxCountAndFeatureDependentDGETHSF01ERRCNTInAttributeList_10()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterEthernetNetworkDiagnostics alloc] initWithDevice:device
                                                                                        endpoint:@(0)
                                                                                           queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAttributeListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(
                @"TH reads optional attribute(PacketRxCount) and Feature dependent(DGETH.S.F01(ERRCNT)) in AttributeList Error: %@",
                err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("attributeList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 4UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsOptionalAttributePacketRxCountAndFeatureDependentDGETHSF01ERRCNTInAttributeList_11()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterEthernetNetworkDiagnostics alloc] initWithDevice:device
                                                                                        endpoint:@(0)
                                                                                           queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAttributeListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(
                @"TH reads optional attribute(PacketRxCount) and Feature dependent(DGETH.S.F01(ERRCNT)) in AttributeList Error: %@",
                err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("attributeList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 5UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsOptionalAttributePacketRxCountAndFeatureDependentDGETHSF01ERRCNTInAttributeList_12()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterEthernetNetworkDiagnostics alloc] initWithDevice:device
                                                                                        endpoint:@(0)
                                                                                           queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAttributeListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(
                @"TH reads optional attribute(PacketRxCount) and Feature dependent(DGETH.S.F01(ERRCNT)) in AttributeList Error: %@",
                err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("attributeList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 6UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsOptionalAttributeCarrierDetectInAttributeList_13()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterEthernetNetworkDiagnostics alloc] initWithDevice:device
                                                                                        endpoint:@(0)
                                                                                           queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAttributeListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads optional attribute(CarrierDetect) in AttributeList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("attributeList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 7UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsOptionalAttributeTimeSinceResetInAttributeList_14()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterEthernetNetworkDiagnostics alloc] initWithDevice:device
                                                                                        endpoint:@(0)
                                                                                           queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAttributeListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads optional attribute(TimeSinceReset) in AttributeList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("attributeList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 8UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsAcceptedCommandListFromDut_15()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterEthernetNetworkDiagnostics alloc] initWithDevice:device
                                                                                        endpoint:@(0)
                                                                                           queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAcceptedCommandListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads AcceptedCommandList from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("acceptedCommandList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("acceptedCommandList", value, 0UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsAcceptedCommandListFromDut_16()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterEthernetNetworkDiagnostics alloc] initWithDevice:device
                                                                                        endpoint:@(0)
                                                                                           queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAcceptedCommandListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads AcceptedCommandList from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("AcceptedCommandList", [actualValue count], static_cast<uint32_t>(0)));
            }

            VerifyOrReturn(CheckConstraintType("acceptedCommandList", "list", "list"));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsGeneratedCommandListFromDut_17()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterEthernetNetworkDiagnostics alloc] initWithDevice:device
                                                                                        endpoint:@(0)
                                                                                           queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeGeneratedCommandListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads GeneratedCommandList from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("GeneratedCommandList", [actualValue count], static_cast<uint32_t>(0)));
            }

            VerifyOrReturn(CheckConstraintType("generatedCommandList", "list", "list"));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }
};

class Test_TC_DGETH_2_1 : public TestCommandBridge {
public:
    // NOLINTBEGIN(clang-analyzer-nullability.NullPassedToNonnull): Test constructor nullability not enforced
    Test_TC_DGETH_2_1()
        : TestCommandBridge("Test_TC_DGETH_2_1")
        , mTestIndex(0)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }
    // NOLINTEND(clang-analyzer-nullability.NullPassedToNonnull)

    ~Test_TC_DGETH_2_1() {}

    /////////// TestCommand Interface /////////
    void NextTest() override
    {
        CHIP_ERROR err = CHIP_NO_ERROR;

        if (0 == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Start: Test_TC_DGETH_2_1\n");
        }

        if (mTestCount == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Complete: Test_TC_DGETH_2_1\n");
            SetCommandExitStatus(CHIP_NO_ERROR);
            return;
        }

        Wait();

        // Ensure we increment mTestIndex before we start running the relevant
        // command.  That way if we lose the timeslice after we send the message
        // but before our function call returns, we won't end up with an
        // incorrect mTestIndex value observed when we get the response.
        switch (mTestIndex++) {
        case 0:
            ChipLogProgress(chipTool, " ***** Test Step 0 : Wait for the commissioned device to be retrieved\n");
            err = TestWaitForTheCommissionedDeviceToBeRetrieved_0();
            break;
        case 1:
            ChipLogProgress(chipTool, " ***** Test Step 1 : Read PHYRate attribute constraints\n");
            if (ShouldSkip("DGETH.S.A0000")) {
                NextTest();
                return;
            }
            err = TestReadPHYRateAttributeConstraints_1();
            break;
        case 2:
            ChipLogProgress(chipTool, " ***** Test Step 2 : Read FullDuplex attribute constraints\n");
            if (ShouldSkip("DGETH.S.A0001")) {
                NextTest();
                return;
            }
            err = TestReadFullDuplexAttributeConstraints_2();
            break;
        case 3:
            ChipLogProgress(chipTool, " ***** Test Step 3 : Read PacketRxCount attribute constraints\n");
            if (ShouldSkip("DGETH.S.A0002")) {
                NextTest();
                return;
            }
            err = TestReadPacketRxCountAttributeConstraints_3();
            break;
        case 4:
            ChipLogProgress(chipTool,
                " ***** Test Step 4 : Read PacketRxCount value from DUT and verify the number of packets received on ethernet "
                "network interface\n");
            if (ShouldSkip("PICS_USER_PROMPT && DGETH.S.A0002")) {
                NextTest();
                return;
            }
            err = TestReadPacketRxCountValueFromDutAndVerifyTheNumberOfPacketsReceivedOnEthernetNetworkInterface_4();
            break;
        case 5:
            ChipLogProgress(chipTool, " ***** Test Step 5 : Read PacketTxCount attribute constraints\n");
            if (ShouldSkip("DGETH.S.A0003")) {
                NextTest();
                return;
            }
            err = TestReadPacketTxCountAttributeConstraints_5();
            break;
        case 6:
            ChipLogProgress(chipTool,
                " ***** Test Step 6 : Read PacketTxCount value from DUT and verify the number of packets received on ethernet "
                "network interface\n");
            if (ShouldSkip("PICS_USER_PROMPT && DGETH.S.A0003")) {
                NextTest();
                return;
            }
            err = TestReadPacketTxCountValueFromDutAndVerifyTheNumberOfPacketsReceivedOnEthernetNetworkInterface_6();
            break;
        case 7:
            ChipLogProgress(chipTool, " ***** Test Step 7 : Read TxErrCount attribute constraints\n");
            if (ShouldSkip("DGETH.S.A0004")) {
                NextTest();
                return;
            }
            err = TestReadTxErrCountAttributeConstraints_7();
            break;
        case 8:
            ChipLogProgress(chipTool,
                " ***** Test Step 8 : Read TxErrCount value from DUT and verify value indicates the number of failed packet "
                "transmission on ethernet network interface\n");
            if (ShouldSkip("PICS_USER_PROMPT && DGETH.S.A0004")) {
                NextTest();
                return;
            }
            err = TestReadTxErrCountValueFromDutAndVerifyValueIndicatesTheNumberOfFailedPacketTransmissionOnEthernetNetworkInterface_8();
            break;
        case 9:
            ChipLogProgress(chipTool, " ***** Test Step 9 : Read CollisionCount attribute constraints\n");
            if (ShouldSkip("DGETH.S.A0005")) {
                NextTest();
                return;
            }
            err = TestReadCollisionCountAttributeConstraints_9();
            break;
        case 10:
            ChipLogProgress(chipTool,
                " ***** Test Step 10 : Read CollisionCount value from DUT and verify value indicates the number of collision "
                "occurred while transmitting packets on ethernet network interface\n");
            if (ShouldSkip("PICS_USER_PROMPT && DGETH.S.A0005")) {
                NextTest();
                return;
            }
            err = TestReadCollisionCountValueFromDutAndVerifyValueIndicatesTheNumberOfCollisionOccurredWhileTransmittingPacketsOnEthernetNetworkInterface_10();
            break;
        case 11:
            ChipLogProgress(chipTool, " ***** Test Step 11 : Read OverrunCount attribute constraints\n");
            if (ShouldSkip("DGETH.S.A0006")) {
                NextTest();
                return;
            }
            err = TestReadOverrunCountAttributeConstraints_11();
            break;
        case 12:
            ChipLogProgress(chipTool,
                " ***** Test Step 12 : Read OverrunCount value from DUT and verify value indicates the number of packets dropped "
                "due to lack of buffer memory on ethernet network interface\n");
            if (ShouldSkip("PICS_USER_PROMPT && DGETH.S.A0006")) {
                NextTest();
                return;
            }
            err = TestReadOverrunCountValueFromDutAndVerifyValueIndicatesTheNumberOfPacketsDroppedDueToLackOfBufferMemoryOnEthernetNetworkInterface_12();
            break;
        case 13:
            ChipLogProgress(chipTool, " ***** Test Step 13 : Read CarrierDetect attribute constraints\n");
            if (ShouldSkip("DGETH.S.A0007")) {
                NextTest();
                return;
            }
            err = TestReadCarrierDetectAttributeConstraints_13();
            break;
        case 14:
            ChipLogProgress(chipTool,
                " ***** Test Step 14 : Read CarrierDetect value from DUT and verify value indicates the presence of carrier detect "
                "control signal on ethernet network interface\n");
            if (ShouldSkip("PICS_USER_PROMPT && DGETH.S.A0007")) {
                NextTest();
                return;
            }
            err = TestReadCarrierDetectValueFromDutAndVerifyValueIndicatesThePresenceOfCarrierDetectControlSignalOnEthernetNetworkInterface_14();
            break;
        case 15:
            ChipLogProgress(chipTool, " ***** Test Step 15 : Read TimeSinceReset attribute constraints\n");
            if (ShouldSkip("DGETH.S.A0008")) {
                NextTest();
                return;
            }
            err = TestReadTimeSinceResetAttributeConstraints_15();
            break;
        case 16:
            ChipLogProgress(chipTool,
                " ***** Test Step 16 : Read TimeSinceReset value from DUT and verify the value indicates the duration of time, in "
                "minutes\n");
            if (ShouldSkip("PICS_USER_PROMPT && DGETH.S.A0008")) {
                NextTest();
                return;
            }
            err = TestReadTimeSinceResetValueFromDutAndVerifyTheValueIndicatesTheDurationOfTimeInMinutes_16();
            break;
        }

        if (CHIP_NO_ERROR != err) {
            ChipLogError(chipTool, " ***** Test Failure: %s\n", chip::ErrorStr(err));
            SetCommandExitStatus(err);
        }
    }

    void OnStatusUpdate(const chip::app::StatusIB & status) override
    {
        switch (mTestIndex - 1) {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 6:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 7:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 8:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 9:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 10:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 11:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 12:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 13:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 14:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 15:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 16:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        }

        // Go on to the next test.
        ContinueOnChipMainThread(CHIP_NO_ERROR);
    }

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    std::atomic_uint16_t mTestIndex;
    const uint16_t mTestCount = 17;

    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    CHIP_ERROR TestWaitForTheCommissionedDeviceToBeRetrieved_0()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
        value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
        return WaitForCommissionee("alpha", value);
    }

    CHIP_ERROR TestReadPHYRateAttributeConstraints_1()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterEthernetNetworkDiagnostics alloc] initWithDevice:device
                                                                                        endpoint:@(0)
                                                                                           queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributePHYRateWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read PHYRate attribute constraints Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            if (value != nil) {

                VerifyOrReturn(CheckConstraintType("PHYRate", "enum8", "enum8"));
                VerifyOrReturn(CheckConstraintMinValue<uint8_t>("PHYRate", [value unsignedCharValue], 0U));
                VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("PHYRate", [value unsignedCharValue], 9U));
            }

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadFullDuplexAttributeConstraints_2()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterEthernetNetworkDiagnostics alloc] initWithDevice:device
                                                                                        endpoint:@(0)
                                                                                           queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeFullDuplexWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read FullDuplex attribute constraints Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            if (value != nil) {

                VerifyOrReturn(CheckConstraintType("fullDuplex", "boolean", "boolean"));
            }

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadPacketRxCountAttributeConstraints_3()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterEthernetNetworkDiagnostics alloc] initWithDevice:device
                                                                                        endpoint:@(0)
                                                                                           queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributePacketRxCountWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read PacketRxCount attribute constraints Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("packetRxCount", "int64u", "int64u"));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadPacketRxCountValueFromDutAndVerifyTheNumberOfPacketsReceivedOnEthernetNetworkInterface_4()
    {

        chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
        value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
        value.expectedValue.Emplace();
        value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
        return UserPrompt("alpha", value);
    }

    CHIP_ERROR TestReadPacketTxCountAttributeConstraints_5()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterEthernetNetworkDiagnostics alloc] initWithDevice:device
                                                                                        endpoint:@(0)
                                                                                           queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributePacketTxCountWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read PacketTxCount attribute constraints Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("packetTxCount", "int64u", "int64u"));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadPacketTxCountValueFromDutAndVerifyTheNumberOfPacketsReceivedOnEthernetNetworkInterface_6()
    {

        chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
        value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
        value.expectedValue.Emplace();
        value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
        return UserPrompt("alpha", value);
    }

    CHIP_ERROR TestReadTxErrCountAttributeConstraints_7()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterEthernetNetworkDiagnostics alloc] initWithDevice:device
                                                                                        endpoint:@(0)
                                                                                           queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeTxErrCountWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read TxErrCount attribute constraints Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("txErrCount", "int64u", "int64u"));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR
    TestReadTxErrCountValueFromDutAndVerifyValueIndicatesTheNumberOfFailedPacketTransmissionOnEthernetNetworkInterface_8()
    {

        chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
        value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
        value.expectedValue.Emplace();
        value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
        return UserPrompt("alpha", value);
    }

    CHIP_ERROR TestReadCollisionCountAttributeConstraints_9()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterEthernetNetworkDiagnostics alloc] initWithDevice:device
                                                                                        endpoint:@(0)
                                                                                           queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCollisionCountWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read CollisionCount attribute constraints Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("collisionCount", "int64u", "int64u"));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR
    TestReadCollisionCountValueFromDutAndVerifyValueIndicatesTheNumberOfCollisionOccurredWhileTransmittingPacketsOnEthernetNetworkInterface_10()
    {

        chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
        value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
        value.expectedValue.Emplace();
        value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
        return UserPrompt("alpha", value);
    }

    CHIP_ERROR TestReadOverrunCountAttributeConstraints_11()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterEthernetNetworkDiagnostics alloc] initWithDevice:device
                                                                                        endpoint:@(0)
                                                                                           queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeOverrunCountWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read OverrunCount attribute constraints Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("overrunCount", "int64u", "int64u"));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR
    TestReadOverrunCountValueFromDutAndVerifyValueIndicatesTheNumberOfPacketsDroppedDueToLackOfBufferMemoryOnEthernetNetworkInterface_12()
    {

        chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
        value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
        value.expectedValue.Emplace();
        value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
        return UserPrompt("alpha", value);
    }

    CHIP_ERROR TestReadCarrierDetectAttributeConstraints_13()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterEthernetNetworkDiagnostics alloc] initWithDevice:device
                                                                                        endpoint:@(0)
                                                                                           queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCarrierDetectWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read CarrierDetect attribute constraints Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            if (value != nil) {

                VerifyOrReturn(CheckConstraintType("carrierDetect", "boolean", "boolean"));
            }

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR
    TestReadCarrierDetectValueFromDutAndVerifyValueIndicatesThePresenceOfCarrierDetectControlSignalOnEthernetNetworkInterface_14()
    {

        chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
        value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
        value.expectedValue.Emplace();
        value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
        return UserPrompt("alpha", value);
    }

    CHIP_ERROR TestReadTimeSinceResetAttributeConstraints_15()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterEthernetNetworkDiagnostics alloc] initWithDevice:device
                                                                                        endpoint:@(0)
                                                                                           queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeTimeSinceResetWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read TimeSinceReset attribute constraints Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("timeSinceReset", "int64u", "int64u"));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTimeSinceResetValueFromDutAndVerifyTheValueIndicatesTheDurationOfTimeInMinutes_16()
    {

        chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
        value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
        value.expectedValue.Emplace();
        value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
        return UserPrompt("alpha", value);
    }
};

class Test_TC_DGETH_2_2 : public TestCommandBridge {
public:
    // NOLINTBEGIN(clang-analyzer-nullability.NullPassedToNonnull): Test constructor nullability not enforced
    Test_TC_DGETH_2_2()
        : TestCommandBridge("Test_TC_DGETH_2_2")
        , mTestIndex(0)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }
    // NOLINTEND(clang-analyzer-nullability.NullPassedToNonnull)

    ~Test_TC_DGETH_2_2() {}

    /////////// TestCommand Interface /////////
    void NextTest() override
    {
        CHIP_ERROR err = CHIP_NO_ERROR;

        if (0 == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Start: Test_TC_DGETH_2_2\n");
        }

        if (mTestCount == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Complete: Test_TC_DGETH_2_2\n");
            SetCommandExitStatus(CHIP_NO_ERROR);
            return;
        }

        Wait();

        // Ensure we increment mTestIndex before we start running the relevant
        // command.  That way if we lose the timeslice after we send the message
        // but before our function call returns, we won't end up with an
        // incorrect mTestIndex value observed when we get the response.
        switch (mTestIndex++) {
        case 0:
            ChipLogProgress(chipTool, " ***** Test Step 0 : Wait for the commissioned device to be retrieved\n");
            err = TestWaitForTheCommissionedDeviceToBeRetrieved_0();
            break;
        case 1:
            ChipLogProgress(chipTool, " ***** Test Step 1 : TH reads PHYRate attribute from DUT\n");
            if (ShouldSkip("DGETH.S.A0000")) {
                NextTest();
                return;
            }
            err = TestThReadsPHYRateAttributeFromDut_1();
            break;
        case 2:
            ChipLogProgress(chipTool, " ***** Test Step 2 : TH reads PHYRate attribute from DUT\n");
            if (ShouldSkip("DGETH.S.A0000")) {
                NextTest();
                return;
            }
            err = TestThReadsPHYRateAttributeFromDut_2();
            break;
        case 3:
            ChipLogProgress(chipTool, " ***** Test Step 3 : TH reads PHYRate attribute from DUT\n");
            if (ShouldSkip("DGETH.S.A0000")) {
                NextTest();
                return;
            }
            err = TestThReadsPHYRateAttributeFromDut_3();
            break;
        case 4:
            ChipLogProgress(chipTool, " ***** Test Step 4 : TH reads PHYRate attribute from DUT\n");
            if (ShouldSkip("DGETH.S.A0000")) {
                NextTest();
                return;
            }
            err = TestThReadsPHYRateAttributeFromDut_4();
            break;
        case 5:
            ChipLogProgress(chipTool, " ***** Test Step 5 : TH reads PHYRate attribute from DUT\n");
            if (ShouldSkip("DGETH.S.A0000")) {
                NextTest();
                return;
            }
            err = TestThReadsPHYRateAttributeFromDut_5();
            break;
        case 6:
            ChipLogProgress(chipTool, " ***** Test Step 6 : TH reads PHYRate attribute from DUT\n");
            if (ShouldSkip("DGETH.S.A0000")) {
                NextTest();
                return;
            }
            err = TestThReadsPHYRateAttributeFromDut_6();
            break;
        case 7:
            ChipLogProgress(chipTool, " ***** Test Step 7 : TH reads PHYRate attribute from DUT\n");
            if (ShouldSkip("DGETH.S.A0000")) {
                NextTest();
                return;
            }
            err = TestThReadsPHYRateAttributeFromDut_7();
            break;
        case 8:
            ChipLogProgress(chipTool, " ***** Test Step 8 : TH reads PHYRate attribute from DUT\n");
            if (ShouldSkip("DGETH.S.A0000")) {
                NextTest();
                return;
            }
            err = TestThReadsPHYRateAttributeFromDut_8();
            break;
        case 9:
            ChipLogProgress(chipTool, " ***** Test Step 9 : TH reads PHYRate attribute from DUT\n");
            if (ShouldSkip("DGETH.S.A0000")) {
                NextTest();
                return;
            }
            err = TestThReadsPHYRateAttributeFromDut_9();
            break;
        case 10:
            ChipLogProgress(chipTool, " ***** Test Step 10 : TH reads PHYRate attribute from DUT\n");
            if (ShouldSkip("DGETH.S.A0000")) {
                NextTest();
                return;
            }
            err = TestThReadsPHYRateAttributeFromDut_10();
            break;
        case 11:
            ChipLogProgress(chipTool, " ***** Test Step 11 : TH reads PacketRxCount attribute value from DUT\n");
            if (ShouldSkip("DGETH.S.A0002")) {
                NextTest();
                return;
            }
            err = TestThReadsPacketRxCountAttributeValueFromDut_11();
            break;
        case 12:
            ChipLogProgress(chipTool, " ***** Test Step 12 : TH reads PacketTxCount attribute value from DUT\n");
            if (ShouldSkip("DGETH.S.A0003")) {
                NextTest();
                return;
            }
            err = TestThReadsPacketTxCountAttributeValueFromDut_12();
            break;
        case 13:
            ChipLogProgress(chipTool, " ***** Test Step 13 : TH reads TxErrCount attribute value from DUT\n");
            if (ShouldSkip("DGETH.S.A0004")) {
                NextTest();
                return;
            }
            err = TestThReadsTxErrCountAttributeValueFromDut_13();
            break;
        case 14:
            ChipLogProgress(chipTool, " ***** Test Step 14 : TH reads CollisionCount attribute value from DUT\n");
            if (ShouldSkip("DGETH.S.A0005")) {
                NextTest();
                return;
            }
            err = TestThReadsCollisionCountAttributeValueFromDut_14();
            break;
        case 15:
            ChipLogProgress(chipTool, " ***** Test Step 15 : TH reads OverrunCount attribute value from DUT\n");
            if (ShouldSkip("DGETH.S.A0006")) {
                NextTest();
                return;
            }
            err = TestThReadsOverrunCountAttributeValueFromDut_15();
            break;
        case 16:
            ChipLogProgress(chipTool, " ***** Test Step 16 : Sends ResetCounts command\n");
            if (ShouldSkip("DGETH.S.C00.Rsp")) {
                NextTest();
                return;
            }
            err = TestSendsResetCountsCommand_16();
            break;
        case 17:
            ChipLogProgress(chipTool, " ***** Test Step 17 : TH reads PacketRxCount attribute value from DUT\n");
            if (ShouldSkip("DGETH.S.A0002")) {
                NextTest();
                return;
            }
            err = TestThReadsPacketRxCountAttributeValueFromDut_17();
            break;
        case 18:
            ChipLogProgress(chipTool, " ***** Test Step 18 : TH reads PacketTxCount attribute value from DUT\n");
            if (ShouldSkip("DGETH.S.A0003")) {
                NextTest();
                return;
            }
            err = TestThReadsPacketTxCountAttributeValueFromDut_18();
            break;
        case 19:
            ChipLogProgress(chipTool, " ***** Test Step 19 : TH reads TxErrCount attribute value from DUT\n");
            if (ShouldSkip("DGETH.S.A0004")) {
                NextTest();
                return;
            }
            err = TestThReadsTxErrCountAttributeValueFromDut_19();
            break;
        case 20:
            ChipLogProgress(chipTool, " ***** Test Step 20 : TH reads CollisionCount attribute value from DUT\n");
            if (ShouldSkip("DGETH.S.A0005")) {
                NextTest();
                return;
            }
            err = TestThReadsCollisionCountAttributeValueFromDut_20();
            break;
        case 21:
            ChipLogProgress(chipTool, " ***** Test Step 21 : TH reads OverrunCount attribute value from DUT\n");
            if (ShouldSkip("DGETH.S.A0006")) {
                NextTest();
                return;
            }
            err = TestThReadsOverrunCountAttributeValueFromDut_21();
            break;
        }

        if (CHIP_NO_ERROR != err) {
            ChipLogError(chipTool, " ***** Test Failure: %s\n", chip::ErrorStr(err));
            SetCommandExitStatus(err);
        }
    }

    void OnStatusUpdate(const chip::app::StatusIB & status) override
    {
        switch (mTestIndex - 1) {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 6:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 7:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 8:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 9:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 10:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 11:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 12:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 13:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 14:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 15:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 16:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 17:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 18:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 19:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 20:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 21:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        }

        // Go on to the next test.
        ContinueOnChipMainThread(CHIP_NO_ERROR);
    }

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    std::atomic_uint16_t mTestIndex;
    const uint16_t mTestCount = 22;

    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    CHIP_ERROR TestWaitForTheCommissionedDeviceToBeRetrieved_0()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
        value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
        return WaitForCommissionee("alpha", value);
    }

    CHIP_ERROR TestThReadsPHYRateAttributeFromDut_1()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterEthernetNetworkDiagnostics alloc] initWithDevice:device
                                                                                        endpoint:@(0)
                                                                                           queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributePHYRateWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads PHYRate attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            if (value != nil) {

                VerifyOrReturn(CheckConstraintType("PHYRate", "enum8", "enum8"));
                VerifyOrReturn(CheckConstraintMinValue<uint8_t>("PHYRate", [value unsignedCharValue], 0U));
                VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("PHYRate", [value unsignedCharValue], 9U));
            }

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsPHYRateAttributeFromDut_2()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterEthernetNetworkDiagnostics alloc] initWithDevice:device
                                                                                        endpoint:@(0)
                                                                                           queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributePHYRateWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads PHYRate attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            if (value != nil) {

                VerifyOrReturn(CheckConstraintType("PHYRate", "enum8", "enum8"));
                VerifyOrReturn(CheckConstraintMinValue<uint8_t>("PHYRate", [value unsignedCharValue], 0U));
                VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("PHYRate", [value unsignedCharValue], 9U));
            }

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsPHYRateAttributeFromDut_3()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterEthernetNetworkDiagnostics alloc] initWithDevice:device
                                                                                        endpoint:@(0)
                                                                                           queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributePHYRateWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads PHYRate attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            if (value != nil) {

                VerifyOrReturn(CheckConstraintType("PHYRate", "enum8", "enum8"));
                VerifyOrReturn(CheckConstraintMinValue<uint8_t>("PHYRate", [value unsignedCharValue], 0U));
                VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("PHYRate", [value unsignedCharValue], 9U));
            }

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsPHYRateAttributeFromDut_4()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterEthernetNetworkDiagnostics alloc] initWithDevice:device
                                                                                        endpoint:@(0)
                                                                                           queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributePHYRateWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads PHYRate attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            if (value != nil) {

                VerifyOrReturn(CheckConstraintType("PHYRate", "enum8", "enum8"));
                VerifyOrReturn(CheckConstraintMinValue<uint8_t>("PHYRate", [value unsignedCharValue], 0U));
                VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("PHYRate", [value unsignedCharValue], 9U));
            }

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsPHYRateAttributeFromDut_5()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterEthernetNetworkDiagnostics alloc] initWithDevice:device
                                                                                        endpoint:@(0)
                                                                                           queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributePHYRateWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads PHYRate attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            if (value != nil) {

                VerifyOrReturn(CheckConstraintType("PHYRate", "enum8", "enum8"));
                VerifyOrReturn(CheckConstraintMinValue<uint8_t>("PHYRate", [value unsignedCharValue], 0U));
                VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("PHYRate", [value unsignedCharValue], 9U));
            }

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsPHYRateAttributeFromDut_6()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterEthernetNetworkDiagnostics alloc] initWithDevice:device
                                                                                        endpoint:@(0)
                                                                                           queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributePHYRateWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads PHYRate attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            if (value != nil) {

                VerifyOrReturn(CheckConstraintType("PHYRate", "enum8", "enum8"));
                VerifyOrReturn(CheckConstraintMinValue<uint8_t>("PHYRate", [value unsignedCharValue], 0U));
                VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("PHYRate", [value unsignedCharValue], 9U));
            }

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsPHYRateAttributeFromDut_7()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterEthernetNetworkDiagnostics alloc] initWithDevice:device
                                                                                        endpoint:@(0)
                                                                                           queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributePHYRateWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads PHYRate attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            if (value != nil) {

                VerifyOrReturn(CheckConstraintType("PHYRate", "enum8", "enum8"));
                VerifyOrReturn(CheckConstraintMinValue<uint8_t>("PHYRate", [value unsignedCharValue], 0U));
                VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("PHYRate", [value unsignedCharValue], 9U));
            }

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsPHYRateAttributeFromDut_8()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterEthernetNetworkDiagnostics alloc] initWithDevice:device
                                                                                        endpoint:@(0)
                                                                                           queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributePHYRateWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads PHYRate attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            if (value != nil) {

                VerifyOrReturn(CheckConstraintType("PHYRate", "enum8", "enum8"));
                VerifyOrReturn(CheckConstraintMinValue<uint8_t>("PHYRate", [value unsignedCharValue], 0U));
                VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("PHYRate", [value unsignedCharValue], 9U));
            }

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsPHYRateAttributeFromDut_9()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterEthernetNetworkDiagnostics alloc] initWithDevice:device
                                                                                        endpoint:@(0)
                                                                                           queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributePHYRateWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads PHYRate attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            if (value != nil) {

                VerifyOrReturn(CheckConstraintType("PHYRate", "enum8", "enum8"));
                VerifyOrReturn(CheckConstraintMinValue<uint8_t>("PHYRate", [value unsignedCharValue], 0U));
                VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("PHYRate", [value unsignedCharValue], 9U));
            }

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsPHYRateAttributeFromDut_10()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterEthernetNetworkDiagnostics alloc] initWithDevice:device
                                                                                        endpoint:@(0)
                                                                                           queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributePHYRateWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads PHYRate attribute from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            if (value != nil) {

                VerifyOrReturn(CheckConstraintType("PHYRate", "enum8", "enum8"));
                VerifyOrReturn(CheckConstraintMinValue<uint8_t>("PHYRate", [value unsignedCharValue], 0U));
                VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("PHYRate", [value unsignedCharValue], 9U));
            }

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }
    NSNumber * _Nonnull PacketRxCount;

    CHIP_ERROR TestThReadsPacketRxCountAttributeValueFromDut_11()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterEthernetNetworkDiagnostics alloc] initWithDevice:device
                                                                                        endpoint:@(0)
                                                                                           queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributePacketRxCountWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads PacketRxCount attribute value from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                PacketRxCount = value;
            }

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }
    NSNumber * _Nonnull PacketTxCount;

    CHIP_ERROR TestThReadsPacketTxCountAttributeValueFromDut_12()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterEthernetNetworkDiagnostics alloc] initWithDevice:device
                                                                                        endpoint:@(0)
                                                                                           queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributePacketTxCountWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads PacketTxCount attribute value from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                PacketTxCount = value;
            }

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }
    NSNumber * _Nonnull TxErrCount;

    CHIP_ERROR TestThReadsTxErrCountAttributeValueFromDut_13()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterEthernetNetworkDiagnostics alloc] initWithDevice:device
                                                                                        endpoint:@(0)
                                                                                           queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeTxErrCountWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads TxErrCount attribute value from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                TxErrCount = value;
            }

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }
    NSNumber * _Nonnull CollisionCount;

    CHIP_ERROR TestThReadsCollisionCountAttributeValueFromDut_14()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterEthernetNetworkDiagnostics alloc] initWithDevice:device
                                                                                        endpoint:@(0)
                                                                                           queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCollisionCountWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CollisionCount attribute value from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                CollisionCount = value;
            }

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }
    NSNumber * _Nonnull OverrunCount;

    CHIP_ERROR TestThReadsOverrunCountAttributeValueFromDut_15()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterEthernetNetworkDiagnostics alloc] initWithDevice:device
                                                                                        endpoint:@(0)
                                                                                           queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeOverrunCountWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads OverrunCount attribute value from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                OverrunCount = value;
            }

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestSendsResetCountsCommand_16()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterEthernetNetworkDiagnostics alloc] initWithDevice:device
                                                                                        endpoint:@(0)
                                                                                           queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster resetCountsWithCompletion:^(NSError * _Nullable err) {
            NSLog(@"Sends ResetCounts command Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsPacketRxCountAttributeValueFromDut_17()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterEthernetNetworkDiagnostics alloc] initWithDevice:device
                                                                                        endpoint:@(0)
                                                                                           queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributePacketRxCountWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads PacketRxCount attribute value from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMaxValue<uint64_t>("packetRxCount", [value unsignedLongLongValue], PacketRxCount));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsPacketTxCountAttributeValueFromDut_18()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterEthernetNetworkDiagnostics alloc] initWithDevice:device
                                                                                        endpoint:@(0)
                                                                                           queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributePacketTxCountWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads PacketTxCount attribute value from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMaxValue<uint64_t>("packetTxCount", [value unsignedLongLongValue], PacketTxCount));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsTxErrCountAttributeValueFromDut_19()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterEthernetNetworkDiagnostics alloc] initWithDevice:device
                                                                                        endpoint:@(0)
                                                                                           queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeTxErrCountWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads TxErrCount attribute value from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMaxValue<uint64_t>("txErrCount", [value unsignedLongLongValue], TxErrCount));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsCollisionCountAttributeValueFromDut_20()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterEthernetNetworkDiagnostics alloc] initWithDevice:device
                                                                                        endpoint:@(0)
                                                                                           queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeCollisionCountWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads CollisionCount attribute value from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMaxValue<uint64_t>("collisionCount", [value unsignedLongLongValue], CollisionCount));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsOverrunCountAttributeValueFromDut_21()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterEthernetNetworkDiagnostics alloc] initWithDevice:device
                                                                                        endpoint:@(0)
                                                                                           queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeOverrunCountWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads OverrunCount attribute value from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMaxValue<uint64_t>("overrunCount", [value unsignedLongLongValue], OverrunCount));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }
};

class Test_TC_FLW_1_1 : public TestCommandBridge {
public:
    // NOLINTBEGIN(clang-analyzer-nullability.NullPassedToNonnull): Test constructor nullability not enforced
    Test_TC_FLW_1_1()
        : TestCommandBridge("Test_TC_FLW_1_1")
        , mTestIndex(0)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }
    // NOLINTEND(clang-analyzer-nullability.NullPassedToNonnull)

    ~Test_TC_FLW_1_1() {}

    /////////// TestCommand Interface /////////
    void NextTest() override
    {
        CHIP_ERROR err = CHIP_NO_ERROR;

        if (0 == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Start: Test_TC_FLW_1_1\n");
        }

        if (mTestCount == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Complete: Test_TC_FLW_1_1\n");
            SetCommandExitStatus(CHIP_NO_ERROR);
            return;
        }

        Wait();

        // Ensure we increment mTestIndex before we start running the relevant
        // command.  That way if we lose the timeslice after we send the message
        // but before our function call returns, we won't end up with an
        // incorrect mTestIndex value observed when we get the response.
        switch (mTestIndex++) {
        case 0:
            ChipLogProgress(chipTool, " ***** Test Step 0 : Wait for the commissioned device to be retrieved\n");
            err = TestWaitForTheCommissionedDeviceToBeRetrieved_0();
            break;
        case 1:
            ChipLogProgress(chipTool, " ***** Test Step 1 : Read the global attribute: ClusterRevision\n");
            err = TestReadTheGlobalAttributeClusterRevision_1();
            break;
        case 2:
            ChipLogProgress(chipTool, " ***** Test Step 2 : Read the global attribute: FeatureMap\n");
            err = TestReadTheGlobalAttributeFeatureMap_2();
            break;
        case 3:
            ChipLogProgress(chipTool, " ***** Test Step 3 : Read the global attribute: AttributeList\n");
            err = TestReadTheGlobalAttributeAttributeList_3();
            break;
        case 4:
            ChipLogProgress(chipTool, " ***** Test Step 4 : Read the optional attribute(Tolerance) in AttributeList\n");
            if (ShouldSkip("FLW.S.A0003")) {
                NextTest();
                return;
            }
            err = TestReadTheOptionalAttributeToleranceInAttributeList_4();
            break;
        case 5:
            ChipLogProgress(chipTool, " ***** Test Step 5 : Read the global attribute: AcceptedCommandList\n");
            err = TestReadTheGlobalAttributeAcceptedCommandList_5();
            break;
        case 6:
            ChipLogProgress(chipTool, " ***** Test Step 6 : Read the global attribute: GeneratedCommandList\n");
            err = TestReadTheGlobalAttributeGeneratedCommandList_6();
            break;
        }

        if (CHIP_NO_ERROR != err) {
            ChipLogError(chipTool, " ***** Test Failure: %s\n", chip::ErrorStr(err));
            SetCommandExitStatus(err);
        }
    }

    void OnStatusUpdate(const chip::app::StatusIB & status) override
    {
        switch (mTestIndex - 1) {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 6:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        }

        // Go on to the next test.
        ContinueOnChipMainThread(CHIP_NO_ERROR);
    }

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    std::atomic_uint16_t mTestIndex;
    const uint16_t mTestCount = 7;

    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    CHIP_ERROR TestWaitForTheCommissionedDeviceToBeRetrieved_0()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
        value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
        return WaitForCommissionee("alpha", value);
    }

    CHIP_ERROR TestReadTheGlobalAttributeClusterRevision_1()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterFlowMeasurement alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeClusterRevisionWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the global attribute: ClusterRevision Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("ClusterRevision", actualValue, 3U));
            }

            VerifyOrReturn(CheckConstraintType("clusterRevision", "int16u", "int16u"));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheGlobalAttributeFeatureMap_2()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterFlowMeasurement alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeFeatureMapWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the global attribute: FeatureMap Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("FeatureMap", actualValue, 0UL));
            }

            VerifyOrReturn(CheckConstraintType("featureMap", "bitmap32", "bitmap32"));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheGlobalAttributeAttributeList_3()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterFlowMeasurement alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAttributeListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the global attribute: AttributeList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("attributeList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 0UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 1UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 2UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65528UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65529UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65531UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65532UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65533UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheOptionalAttributeToleranceInAttributeList_4()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterFlowMeasurement alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAttributeListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the optional attribute(Tolerance) in AttributeList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("attributeList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 3UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheGlobalAttributeAcceptedCommandList_5()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterFlowMeasurement alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAcceptedCommandListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the global attribute: AcceptedCommandList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("AcceptedCommandList", [actualValue count], static_cast<uint32_t>(0)));
            }

            VerifyOrReturn(CheckConstraintType("acceptedCommandList", "list", "list"));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheGlobalAttributeGeneratedCommandList_6()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterFlowMeasurement alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeGeneratedCommandListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the global attribute: GeneratedCommandList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("GeneratedCommandList", [actualValue count], static_cast<uint32_t>(0)));
            }

            VerifyOrReturn(CheckConstraintType("generatedCommandList", "list", "list"));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }
};

class Test_TC_FLW_2_1 : public TestCommandBridge {
public:
    // NOLINTBEGIN(clang-analyzer-nullability.NullPassedToNonnull): Test constructor nullability not enforced
    Test_TC_FLW_2_1()
        : TestCommandBridge("Test_TC_FLW_2_1")
        , mTestIndex(0)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }
    // NOLINTEND(clang-analyzer-nullability.NullPassedToNonnull)

    ~Test_TC_FLW_2_1() {}

    /////////// TestCommand Interface /////////
    void NextTest() override
    {
        CHIP_ERROR err = CHIP_NO_ERROR;

        if (0 == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Start: Test_TC_FLW_2_1\n");
        }

        if (mTestCount == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Complete: Test_TC_FLW_2_1\n");
            SetCommandExitStatus(CHIP_NO_ERROR);
            return;
        }

        Wait();

        // Ensure we increment mTestIndex before we start running the relevant
        // command.  That way if we lose the timeslice after we send the message
        // but before our function call returns, we won't end up with an
        // incorrect mTestIndex value observed when we get the response.
        switch (mTestIndex++) {
        case 0:
            ChipLogProgress(chipTool, " ***** Test Step 0 : Wait for the commissioned device to be retrieved\n");
            err = TestWaitForTheCommissionedDeviceToBeRetrieved_0();
            break;
        case 1:
            ChipLogProgress(chipTool, " ***** Test Step 1 : Read the mandatory attribute: MinMeasuredValue\n");
            if (ShouldSkip("FLW.S.A0001")) {
                NextTest();
                return;
            }
            err = TestReadTheMandatoryAttributeMinMeasuredValue_1();
            break;
        case 2:
            ChipLogProgress(chipTool, " ***** Test Step 2 : Read the mandatory attribute: MaxMeasuredValue\n");
            if (ShouldSkip("FLW.S.A0002")) {
                NextTest();
                return;
            }
            err = TestReadTheMandatoryAttributeMaxMeasuredValue_2();
            break;
        case 3:
            ChipLogProgress(chipTool, " ***** Test Step 3 : Read the mandatory attribute: MeasuredValue\n");
            if (ShouldSkip("FLW.S.A0000")) {
                NextTest();
                return;
            }
            err = TestReadTheMandatoryAttributeMeasuredValue_3();
            break;
        case 4:
            ChipLogProgress(chipTool, " ***** Test Step 4 : TH reads from the DUT the Tolerance attribute\n");
            if (ShouldSkip("FLW.S.A0003")) {
                NextTest();
                return;
            }
            err = TestThReadsFromTheDutTheToleranceAttribute_4();
            break;
        }

        if (CHIP_NO_ERROR != err) {
            ChipLogError(chipTool, " ***** Test Failure: %s\n", chip::ErrorStr(err));
            SetCommandExitStatus(err);
        }
    }

    void OnStatusUpdate(const chip::app::StatusIB & status) override
    {
        switch (mTestIndex - 1) {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        }

        // Go on to the next test.
        ContinueOnChipMainThread(CHIP_NO_ERROR);
    }

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    std::atomic_uint16_t mTestIndex;
    const uint16_t mTestCount = 5;

    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    CHIP_ERROR TestWaitForTheCommissionedDeviceToBeRetrieved_0()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
        value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
        return WaitForCommissionee("alpha", value);
    }

    CHIP_ERROR TestReadTheMandatoryAttributeMinMeasuredValue_1()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterFlowMeasurement alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeMinMeasuredValueWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the mandatory attribute: MinMeasuredValue Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            if (value != nil) {

                VerifyOrReturn(CheckConstraintType("minMeasuredValue", "int16u", "int16u"));
                VerifyOrReturn(CheckConstraintMinValue<uint16_t>("minMeasuredValue", [value unsignedShortValue], 0U));
                VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("minMeasuredValue", [value unsignedShortValue], 65533U));
            }

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheMandatoryAttributeMaxMeasuredValue_2()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterFlowMeasurement alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeMaxMeasuredValueWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the mandatory attribute: MaxMeasuredValue Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            if (value != nil) {

                VerifyOrReturn(CheckConstraintType("maxMeasuredValue", "int16u", "int16u"));
                VerifyOrReturn(CheckConstraintMinValue<uint16_t>("maxMeasuredValue", [value unsignedShortValue], 0U));
                VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("maxMeasuredValue", [value unsignedShortValue], 65534U));
            }

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheMandatoryAttributeMeasuredValue_3()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterFlowMeasurement alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeMeasuredValueWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the mandatory attribute: MeasuredValue Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            if (value != nil) {

                VerifyOrReturn(CheckConstraintType("measuredValue", "int16u", "int16u"));
                VerifyOrReturn(CheckConstraintMinValue<uint16_t>("measuredValue", [value unsignedShortValue], 0U));
                VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("measuredValue", [value unsignedShortValue], 65535U));
            }

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsFromTheDutTheToleranceAttribute_4()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterFlowMeasurement alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeToleranceWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads from the DUT the Tolerance attribute Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("tolerance", "int16u", "int16u"));
            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("tolerance", [value unsignedShortValue], 0U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("tolerance", [value unsignedShortValue], 2048U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }
};

class Test_TC_FLABEL_1_1 : public TestCommandBridge {
public:
    // NOLINTBEGIN(clang-analyzer-nullability.NullPassedToNonnull): Test constructor nullability not enforced
    Test_TC_FLABEL_1_1()
        : TestCommandBridge("Test_TC_FLABEL_1_1")
        , mTestIndex(0)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }
    // NOLINTEND(clang-analyzer-nullability.NullPassedToNonnull)

    ~Test_TC_FLABEL_1_1() {}

    /////////// TestCommand Interface /////////
    void NextTest() override
    {
        CHIP_ERROR err = CHIP_NO_ERROR;

        if (0 == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Start: Test_TC_FLABEL_1_1\n");
        }

        if (mTestCount == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Complete: Test_TC_FLABEL_1_1\n");
            SetCommandExitStatus(CHIP_NO_ERROR);
            return;
        }

        Wait();

        // Ensure we increment mTestIndex before we start running the relevant
        // command.  That way if we lose the timeslice after we send the message
        // but before our function call returns, we won't end up with an
        // incorrect mTestIndex value observed when we get the response.
        switch (mTestIndex++) {
        case 0:
            ChipLogProgress(chipTool, " ***** Test Step 0 : Wait for the commissioned device to be retrieved\n");
            err = TestWaitForTheCommissionedDeviceToBeRetrieved_0();
            break;
        case 1:
            ChipLogProgress(chipTool, " ***** Test Step 1 : TH reads the ClusterRevision from DUT\n");
            err = TestThReadsTheClusterRevisionFromDut_1();
            break;
        case 2:
            ChipLogProgress(chipTool, " ***** Test Step 2 : TH reads the FeatureMap from DUT\n");
            err = TestThReadsTheFeatureMapFromDut_2();
            break;
        case 3:
            ChipLogProgress(chipTool, " ***** Test Step 3 : TH reads AttributeList from DUT\n");
            err = TestThReadsAttributeListFromDut_3();
            break;
        case 4:
            ChipLogProgress(chipTool, " ***** Test Step 4 : TH reads AcceptedCommandList from DUT\n");
            err = TestThReadsAcceptedCommandListFromDut_4();
            break;
        case 5:
            ChipLogProgress(chipTool, " ***** Test Step 5 : TH reads GeneratedCommandList from DUT\n");
            err = TestThReadsGeneratedCommandListFromDut_5();
            break;
        }

        if (CHIP_NO_ERROR != err) {
            ChipLogError(chipTool, " ***** Test Failure: %s\n", chip::ErrorStr(err));
            SetCommandExitStatus(err);
        }
    }

    void OnStatusUpdate(const chip::app::StatusIB & status) override
    {
        switch (mTestIndex - 1) {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        }

        // Go on to the next test.
        ContinueOnChipMainThread(CHIP_NO_ERROR);
    }

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    std::atomic_uint16_t mTestIndex;
    const uint16_t mTestCount = 6;

    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    CHIP_ERROR TestWaitForTheCommissionedDeviceToBeRetrieved_0()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
        value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
        return WaitForCommissionee("alpha", value);
    }

    CHIP_ERROR TestThReadsTheClusterRevisionFromDut_1()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterFixedLabel alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeClusterRevisionWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads the ClusterRevision from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("ClusterRevision", actualValue, 1U));
            }

            VerifyOrReturn(CheckConstraintType("clusterRevision", "int16u", "int16u"));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsTheFeatureMapFromDut_2()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterFixedLabel alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeFeatureMapWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads the FeatureMap from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("FeatureMap", actualValue, 0UL));
            }

            VerifyOrReturn(CheckConstraintType("featureMap", "bitmap32", "bitmap32"));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsAttributeListFromDut_3()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterFixedLabel alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAttributeListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads AttributeList from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("attributeList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 0UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65528UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65529UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65531UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65532UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65533UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsAcceptedCommandListFromDut_4()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterFixedLabel alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAcceptedCommandListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads AcceptedCommandList from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("AcceptedCommandList", [actualValue count], static_cast<uint32_t>(0)));
            }

            VerifyOrReturn(CheckConstraintType("acceptedCommandList", "list", "list"));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsGeneratedCommandListFromDut_5()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterFixedLabel alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeGeneratedCommandListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads GeneratedCommandList from DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("GeneratedCommandList", [actualValue count], static_cast<uint32_t>(0)));
            }

            VerifyOrReturn(CheckConstraintType("generatedCommandList", "list", "list"));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }
};

class Test_TC_CGEN_1_1 : public TestCommandBridge {
public:
    // NOLINTBEGIN(clang-analyzer-nullability.NullPassedToNonnull): Test constructor nullability not enforced
    Test_TC_CGEN_1_1()
        : TestCommandBridge("Test_TC_CGEN_1_1")
        , mTestIndex(0)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }
    // NOLINTEND(clang-analyzer-nullability.NullPassedToNonnull)

    ~Test_TC_CGEN_1_1() {}

    /////////// TestCommand Interface /////////
    void NextTest() override
    {
        CHIP_ERROR err = CHIP_NO_ERROR;

        if (0 == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Start: Test_TC_CGEN_1_1\n");
        }

        if (mTestCount == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Complete: Test_TC_CGEN_1_1\n");
            SetCommandExitStatus(CHIP_NO_ERROR);
            return;
        }

        Wait();

        // Ensure we increment mTestIndex before we start running the relevant
        // command.  That way if we lose the timeslice after we send the message
        // but before our function call returns, we won't end up with an
        // incorrect mTestIndex value observed when we get the response.
        switch (mTestIndex++) {
        case 0:
            ChipLogProgress(chipTool, " ***** Test Step 0 : Wait for the commissioned device to be retrieved\n");
            err = TestWaitForTheCommissionedDeviceToBeRetrieved_0();
            break;
        case 1:
            ChipLogProgress(chipTool, " ***** Test Step 1 : Read the global attribute: ClusterRevision\n");
            err = TestReadTheGlobalAttributeClusterRevision_1();
            break;
        case 2:
            ChipLogProgress(chipTool, " ***** Test Step 2 : Read the global attribute: FeatureMap\n");
            err = TestReadTheGlobalAttributeFeatureMap_2();
            break;
        case 3:
            ChipLogProgress(chipTool, " ***** Test Step 3 : Read the global attribute: AttributeList\n");
            err = TestReadTheGlobalAttributeAttributeList_3();
            break;
        case 4:
            ChipLogProgress(chipTool, " ***** Test Step 4 : Read the global attribute: AcceptedCommandList\n");
            err = TestReadTheGlobalAttributeAcceptedCommandList_4();
            break;
        case 5:
            ChipLogProgress(chipTool, " ***** Test Step 5 : Read the global attribute: GeneratedCommandList\n");
            err = TestReadTheGlobalAttributeGeneratedCommandList_5();
            break;
        }

        if (CHIP_NO_ERROR != err) {
            ChipLogError(chipTool, " ***** Test Failure: %s\n", chip::ErrorStr(err));
            SetCommandExitStatus(err);
        }
    }

    void OnStatusUpdate(const chip::app::StatusIB & status) override
    {
        switch (mTestIndex - 1) {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        }

        // Go on to the next test.
        ContinueOnChipMainThread(CHIP_NO_ERROR);
    }

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    std::atomic_uint16_t mTestIndex;
    const uint16_t mTestCount = 6;

    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    CHIP_ERROR TestWaitForTheCommissionedDeviceToBeRetrieved_0()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
        value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
        return WaitForCommissionee("alpha", value);
    }

    CHIP_ERROR TestReadTheGlobalAttributeClusterRevision_1()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterGeneralCommissioning alloc] initWithDevice:device
                                                                                  endpoint:@(0)
                                                                                     queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeClusterRevisionWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the global attribute: ClusterRevision Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("ClusterRevision", actualValue, 1U));
            }

            VerifyOrReturn(CheckConstraintType("clusterRevision", "int16u", "int16u"));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheGlobalAttributeFeatureMap_2()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterGeneralCommissioning alloc] initWithDevice:device
                                                                                  endpoint:@(0)
                                                                                     queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeFeatureMapWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the global attribute: FeatureMap Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("FeatureMap", actualValue, 0UL));
            }

            VerifyOrReturn(CheckConstraintType("featureMap", "bitmap32", "bitmap32"));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheGlobalAttributeAttributeList_3()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterGeneralCommissioning alloc] initWithDevice:device
                                                                                  endpoint:@(0)
                                                                                     queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAttributeListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the global attribute: AttributeList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("attributeList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 0UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 1UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 2UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 3UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 4UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65528UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65529UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65531UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65532UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65533UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheGlobalAttributeAcceptedCommandList_4()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterGeneralCommissioning alloc] initWithDevice:device
                                                                                  endpoint:@(0)
                                                                                     queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAcceptedCommandListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the global attribute: AcceptedCommandList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("acceptedCommandList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("acceptedCommandList", value, 0UL));
            VerifyOrReturn(CheckConstraintContains("acceptedCommandList", value, 2UL));
            VerifyOrReturn(CheckConstraintContains("acceptedCommandList", value, 4UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheGlobalAttributeGeneratedCommandList_5()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterGeneralCommissioning alloc] initWithDevice:device
                                                                                  endpoint:@(0)
                                                                                     queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeGeneratedCommandListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the global attribute: GeneratedCommandList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("generatedCommandList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("generatedCommandList", value, 1UL));
            VerifyOrReturn(CheckConstraintContains("generatedCommandList", value, 3UL));
            VerifyOrReturn(CheckConstraintContains("generatedCommandList", value, 5UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }
};

class Test_TC_CGEN_2_1 : public TestCommandBridge {
public:
    // NOLINTBEGIN(clang-analyzer-nullability.NullPassedToNonnull): Test constructor nullability not enforced
    Test_TC_CGEN_2_1()
        : TestCommandBridge("Test_TC_CGEN_2_1")
        , mTestIndex(0)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }
    // NOLINTEND(clang-analyzer-nullability.NullPassedToNonnull)

    ~Test_TC_CGEN_2_1() {}

    /////////// TestCommand Interface /////////
    void NextTest() override
    {
        CHIP_ERROR err = CHIP_NO_ERROR;

        if (0 == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Start: Test_TC_CGEN_2_1\n");
        }

        if (mTestCount == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Complete: Test_TC_CGEN_2_1\n");
            SetCommandExitStatus(CHIP_NO_ERROR);
            return;
        }

        Wait();

        // Ensure we increment mTestIndex before we start running the relevant
        // command.  That way if we lose the timeslice after we send the message
        // but before our function call returns, we won't end up with an
        // incorrect mTestIndex value observed when we get the response.
        switch (mTestIndex++) {
        case 0:
            ChipLogProgress(chipTool, " ***** Test Step 0 : Wait for the commissioned device to be retrieved\n");
            err = TestWaitForTheCommissionedDeviceToBeRetrieved_0();
            break;
        case 1:
            ChipLogProgress(chipTool, " ***** Test Step 1 : TH1 reads the BreadCrumb Attribute from the DUT\n");
            if (ShouldSkip("CGEN.S.A0000")) {
                NextTest();
                return;
            }
            err = TestTh1ReadsTheBreadCrumbAttributeFromTheDut_1();
            break;
        case 2:
            ChipLogProgress(chipTool, " ***** Test Step 2 : TH1 writes the BreadCrumb attribute as 1 to the DUT\n");
            if (ShouldSkip("CGEN.S.A0000")) {
                NextTest();
                return;
            }
            err = TestTh1WritesTheBreadCrumbAttributeAs1ToTheDut_2();
            break;
        case 3:
            ChipLogProgress(chipTool, " ***** Test Step 3 : TH1 reads the BreadCrumb attribute from the DUT\n");
            if (ShouldSkip("CGEN.S.A0000")) {
                NextTest();
                return;
            }
            err = TestTh1ReadsTheBreadCrumbAttributeFromTheDut_3();
            break;
        case 4:
            ChipLogProgress(chipTool, " ***** Test Step 4 : TH1 reads the RegulatoryConfig attribute from the DUT\n");
            if (ShouldSkip("CGEN.S.A0002")) {
                NextTest();
                return;
            }
            err = TestTh1ReadsTheRegulatoryConfigAttributeFromTheDut_4();
            break;
        case 5:
            ChipLogProgress(chipTool, " ***** Test Step 5 : TH1 reads the LocationCapability attribute from the DUT\n");
            if (ShouldSkip("CGEN.S.A0003")) {
                NextTest();
                return;
            }
            err = TestTh1ReadsTheLocationCapabilityAttributeFromTheDut_5();
            break;
        case 6:
            ChipLogProgress(chipTool,
                " ***** Test Step 6 : TH1 reads BasicCommissioningInfo attribute from DUT and Verify that the "
                "BasicCommissioningInfo attribute has the following field: FailSafeExpiryLengthSeconds field value is within a "
                "duration range of 0 to 65535\n");
            if (ShouldSkip("CGEN.S.A0001")) {
                NextTest();
                return;
            }
            err = TestTh1ReadsBasicCommissioningInfoAttributeFromDutAndVerifyThatTheBasicCommissioningInfoAttributeHasTheFollowingFieldFailSafeExpiryLengthSecondsFieldValueIsWithinADurationRangeOf0To65535_6();
            break;
        case 7:
            ChipLogProgress(chipTool, " ***** Test Step 7 : TH1 reads SupportsConcurrentConnection attribute from the DUT\n");
            if (ShouldSkip("CGEN.S.A0004")) {
                NextTest();
                return;
            }
            err = TestTh1ReadsSupportsConcurrentConnectionAttributeFromTheDut_7();
            break;
        }

        if (CHIP_NO_ERROR != err) {
            ChipLogError(chipTool, " ***** Test Failure: %s\n", chip::ErrorStr(err));
            SetCommandExitStatus(err);
        }
    }

    void OnStatusUpdate(const chip::app::StatusIB & status) override
    {
        switch (mTestIndex - 1) {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 6:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 7:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        }

        // Go on to the next test.
        ContinueOnChipMainThread(CHIP_NO_ERROR);
    }

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    std::atomic_uint16_t mTestIndex;
    const uint16_t mTestCount = 8;

    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    CHIP_ERROR TestWaitForTheCommissionedDeviceToBeRetrieved_0()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
        value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
        return WaitForCommissionee("alpha", value);
    }

    CHIP_ERROR TestTh1ReadsTheBreadCrumbAttributeFromTheDut_1()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterGeneralCommissioning alloc] initWithDevice:device
                                                                                  endpoint:@(0)
                                                                                     queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeBreadcrumbWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH1 reads the BreadCrumb Attribute from the DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("breadcrumb", "int64u", "int64u"));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestTh1WritesTheBreadCrumbAttributeAs1ToTheDut_2()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterGeneralCommissioning alloc] initWithDevice:device
                                                                                  endpoint:@(0)
                                                                                     queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        id breadcrumbArgument;
        breadcrumbArgument = [NSNumber numberWithUnsignedLongLong:1ULL];
        [cluster writeAttributeBreadcrumbWithValue:breadcrumbArgument
                                        completion:^(NSError * _Nullable err) {
                                            NSLog(@"TH1 writes the BreadCrumb attribute as 1 to the DUT Error: %@", err);

                                            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

                                            NextTest();
                                        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestTh1ReadsTheBreadCrumbAttributeFromTheDut_3()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterGeneralCommissioning alloc] initWithDevice:device
                                                                                  endpoint:@(0)
                                                                                     queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeBreadcrumbWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH1 reads the BreadCrumb attribute from the DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("Breadcrumb", actualValue, 1ULL));
            }

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestTh1ReadsTheRegulatoryConfigAttributeFromTheDut_4()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterGeneralCommissioning alloc] initWithDevice:device
                                                                                  endpoint:@(0)
                                                                                     queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeRegulatoryConfigWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH1 reads the RegulatoryConfig attribute from the DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("regulatoryConfig", [value unsignedCharValue], 0U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("regulatoryConfig", [value unsignedCharValue], 2U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestTh1ReadsTheLocationCapabilityAttributeFromTheDut_5()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterGeneralCommissioning alloc] initWithDevice:device
                                                                                  endpoint:@(0)
                                                                                     queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeLocationCapabilityWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH1 reads the LocationCapability attribute from the DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("locationCapability", [value unsignedCharValue], 0U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("locationCapability", [value unsignedCharValue], 2U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR
    TestTh1ReadsBasicCommissioningInfoAttributeFromDutAndVerifyThatTheBasicCommissioningInfoAttributeHasTheFollowingFieldFailSafeExpiryLengthSecondsFieldValueIsWithinADurationRangeOf0To65535_6()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterGeneralCommissioning alloc] initWithDevice:device
                                                                                  endpoint:@(0)
                                                                                     queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeBasicCommissioningInfoWithCompletion:^(
            MTRGeneralCommissioningClusterBasicCommissioningInfo * _Nullable value, NSError * _Nullable err) {
            NSLog(
                @"TH1 reads BasicCommissioningInfo attribute from DUT and Verify that the BasicCommissioningInfo attribute has the "
                @"following field: FailSafeExpiryLengthSeconds field value is within a duration range of 0 to 65535 Error: %@",
                err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestTh1ReadsSupportsConcurrentConnectionAttributeFromTheDut_7()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterGeneralCommissioning alloc] initWithDevice:device
                                                                                  endpoint:@(0)
                                                                                     queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeSupportsConcurrentConnectionWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH1 reads SupportsConcurrentConnection attribute from the DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("supportsConcurrentConnection", "boolean", "boolean"));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }
};

class Test_TC_DGGEN_1_1 : public TestCommandBridge {
public:
    // NOLINTBEGIN(clang-analyzer-nullability.NullPassedToNonnull): Test constructor nullability not enforced
    Test_TC_DGGEN_1_1()
        : TestCommandBridge("Test_TC_DGGEN_1_1")
        , mTestIndex(0)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }
    // NOLINTEND(clang-analyzer-nullability.NullPassedToNonnull)

    ~Test_TC_DGGEN_1_1() {}

    /////////// TestCommand Interface /////////
    void NextTest() override
    {
        CHIP_ERROR err = CHIP_NO_ERROR;

        if (0 == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Start: Test_TC_DGGEN_1_1\n");
        }

        if (mTestCount == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Complete: Test_TC_DGGEN_1_1\n");
            SetCommandExitStatus(CHIP_NO_ERROR);
            return;
        }

        Wait();

        // Ensure we increment mTestIndex before we start running the relevant
        // command.  That way if we lose the timeslice after we send the message
        // but before our function call returns, we won't end up with an
        // incorrect mTestIndex value observed when we get the response.
        switch (mTestIndex++) {
        case 0:
            ChipLogProgress(chipTool, " ***** Test Step 0 : Wait for the commissioned device to be retrieved\n");
            err = TestWaitForTheCommissionedDeviceToBeRetrieved_0();
            break;
        case 1:
            ChipLogProgress(chipTool, " ***** Test Step 1 : Read the global attribute: ClusterRevision\n");
            err = TestReadTheGlobalAttributeClusterRevision_1();
            break;
        case 2:
            ChipLogProgress(chipTool, " ***** Test Step 2 : Read the global attribute: FeatureMap\n");
            err = TestReadTheGlobalAttributeFeatureMap_2();
            break;
        case 3:
            ChipLogProgress(chipTool, " ***** Test Step 3 : Read the global attribute: AttributeList\n");
            err = TestReadTheGlobalAttributeAttributeList_3();
            break;
        case 4:
            ChipLogProgress(chipTool, " ***** Test Step 4 : Read optional attribute(UpTime) in AttributeList\n");
            if (ShouldSkip("DGGEN.S.A0002")) {
                NextTest();
                return;
            }
            err = TestReadOptionalAttributeUpTimeInAttributeList_4();
            break;
        case 5:
            ChipLogProgress(chipTool, " ***** Test Step 5 : Read optional attribute(TotalOperationalHours) in AttributeList\n");
            if (ShouldSkip("DGGEN.S.A0003")) {
                NextTest();
                return;
            }
            err = TestReadOptionalAttributeTotalOperationalHoursInAttributeList_5();
            break;
        case 6:
            ChipLogProgress(chipTool, " ***** Test Step 6 : Read optional attribute(BootReason) in AttributeList\n");
            if (ShouldSkip("DGGEN.S.A0004")) {
                NextTest();
                return;
            }
            err = TestReadOptionalAttributeBootReasonInAttributeList_6();
            break;
        case 7:
            ChipLogProgress(chipTool, " ***** Test Step 7 : Read optional attribute(ActiveHardwareFaults) in AttributeList\n");
            if (ShouldSkip("DGGEN.S.A0005")) {
                NextTest();
                return;
            }
            err = TestReadOptionalAttributeActiveHardwareFaultsInAttributeList_7();
            break;
        case 8:
            ChipLogProgress(chipTool, " ***** Test Step 8 : Read optional attribute(ActiveRadioFaults) in AttributeList\n");
            if (ShouldSkip("DGGEN.S.A0006")) {
                NextTest();
                return;
            }
            err = TestReadOptionalAttributeActiveRadioFaultsInAttributeList_8();
            break;
        case 9:
            ChipLogProgress(chipTool, " ***** Test Step 9 : Read optional attribute(ActiveNetworkFaults) in AttributeList\n");
            if (ShouldSkip("DGGEN.S.A0007")) {
                NextTest();
                return;
            }
            err = TestReadOptionalAttributeActiveNetworkFaultsInAttributeList_9();
            break;
        case 10:
            ChipLogProgress(chipTool, " ***** Test Step 10 : Read the global attribute: AcceptedCommandList\n");
            err = TestReadTheGlobalAttributeAcceptedCommandList_10();
            break;
        case 11:
            ChipLogProgress(chipTool, " ***** Test Step 11 : Read the global attribute: GeneratedCommandList\n");
            err = TestReadTheGlobalAttributeGeneratedCommandList_11();
            break;
        }

        if (CHIP_NO_ERROR != err) {
            ChipLogError(chipTool, " ***** Test Failure: %s\n", chip::ErrorStr(err));
            SetCommandExitStatus(err);
        }
    }

    void OnStatusUpdate(const chip::app::StatusIB & status) override
    {
        switch (mTestIndex - 1) {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 6:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 7:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 8:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 9:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 10:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 11:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        }

        // Go on to the next test.
        ContinueOnChipMainThread(CHIP_NO_ERROR);
    }

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    std::atomic_uint16_t mTestIndex;
    const uint16_t mTestCount = 12;

    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    CHIP_ERROR TestWaitForTheCommissionedDeviceToBeRetrieved_0()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
        value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
        return WaitForCommissionee("alpha", value);
    }

    CHIP_ERROR TestReadTheGlobalAttributeClusterRevision_1()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterGeneralDiagnostics alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeClusterRevisionWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the global attribute: ClusterRevision Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("ClusterRevision", actualValue, 1U));
            }

            VerifyOrReturn(CheckConstraintType("clusterRevision", "int16u", "int16u"));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheGlobalAttributeFeatureMap_2()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterGeneralDiagnostics alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeFeatureMapWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the global attribute: FeatureMap Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("FeatureMap", actualValue, 0UL));
            }

            VerifyOrReturn(CheckConstraintType("featureMap", "bitmap32", "bitmap32"));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheGlobalAttributeAttributeList_3()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterGeneralDiagnostics alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAttributeListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the global attribute: AttributeList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("attributeList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 0UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 1UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 8UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65528UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65529UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65531UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65532UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65533UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadOptionalAttributeUpTimeInAttributeList_4()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterGeneralDiagnostics alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAttributeListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read optional attribute(UpTime) in AttributeList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("attributeList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 2UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadOptionalAttributeTotalOperationalHoursInAttributeList_5()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterGeneralDiagnostics alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAttributeListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read optional attribute(TotalOperationalHours) in AttributeList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("attributeList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 3UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadOptionalAttributeBootReasonInAttributeList_6()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterGeneralDiagnostics alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAttributeListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read optional attribute(BootReason) in AttributeList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("attributeList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 4UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadOptionalAttributeActiveHardwareFaultsInAttributeList_7()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterGeneralDiagnostics alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAttributeListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read optional attribute(ActiveHardwareFaults) in AttributeList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("attributeList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 5UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadOptionalAttributeActiveRadioFaultsInAttributeList_8()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterGeneralDiagnostics alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAttributeListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read optional attribute(ActiveRadioFaults) in AttributeList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("attributeList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 6UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadOptionalAttributeActiveNetworkFaultsInAttributeList_9()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterGeneralDiagnostics alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAttributeListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read optional attribute(ActiveNetworkFaults) in AttributeList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("attributeList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 7UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheGlobalAttributeAcceptedCommandList_10()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterGeneralDiagnostics alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAcceptedCommandListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the global attribute: AcceptedCommandList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("acceptedCommandList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("acceptedCommandList", value, 0UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheGlobalAttributeGeneratedCommandList_11()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterGeneralDiagnostics alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeGeneratedCommandListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the global attribute: GeneratedCommandList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("GeneratedCommandList", [actualValue count], static_cast<uint32_t>(0)));
            }

            VerifyOrReturn(CheckConstraintType("generatedCommandList", "list", "list"));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }
};

class Test_TC_DGGEN_2_1 : public TestCommandBridge {
public:
    // NOLINTBEGIN(clang-analyzer-nullability.NullPassedToNonnull): Test constructor nullability not enforced
    Test_TC_DGGEN_2_1()
        : TestCommandBridge("Test_TC_DGGEN_2_1")
        , mTestIndex(0)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }
    // NOLINTEND(clang-analyzer-nullability.NullPassedToNonnull)

    ~Test_TC_DGGEN_2_1() {}

    /////////// TestCommand Interface /////////
    void NextTest() override
    {
        CHIP_ERROR err = CHIP_NO_ERROR;

        if (0 == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Start: Test_TC_DGGEN_2_1\n");
        }

        if (mTestCount == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Complete: Test_TC_DGGEN_2_1\n");
            SetCommandExitStatus(CHIP_NO_ERROR);
            return;
        }

        Wait();

        // Ensure we increment mTestIndex before we start running the relevant
        // command.  That way if we lose the timeslice after we send the message
        // but before our function call returns, we won't end up with an
        // incorrect mTestIndex value observed when we get the response.
        switch (mTestIndex++) {
        case 0:
            ChipLogProgress(chipTool, " ***** Test Step 0 : Wait for the commissioned device to be retrieved\n");
            err = TestWaitForTheCommissionedDeviceToBeRetrieved_0();
            break;
        case 1:
            ChipLogProgress(chipTool, " ***** Test Step 1 : TH reads NetworkInterfaces structure attribute from DUT.\n");
            if (ShouldSkip("DGGEN.S.A0000")) {
                NextTest();
                return;
            }
            err = TestThReadsNetworkInterfacesStructureAttributeFromDut_1();
            break;
        case 2:
            ChipLogProgress(chipTool, " ***** Test Step 2 : TH reads a RebootCount attribute value from DUT.\n");
            if (ShouldSkip("DGGEN.S.A0001")) {
                NextTest();
                return;
            }
            err = TestThReadsARebootCountAttributeValueFromDut_2();
            break;
        case 3:
            ChipLogProgress(chipTool, " ***** Test Step 3 : Reboot target device\n");
            if (ShouldSkip("PICS_SDK_CI_ONLY")) {
                NextTest();
                return;
            }
            err = TestRebootTargetDevice_3();
            break;
        case 4:
            ChipLogProgress(chipTool, " ***** Test Step 4 : Reboot target device(DUT)\n");
            if (ShouldSkip("PICS_SKIP_SAMPLE_APP")) {
                NextTest();
                return;
            }
            err = TestRebootTargetDeviceDUT_4();
            break;
        case 5:
            ChipLogProgress(chipTool, " ***** Test Step 5 : Reboot target device\n");
            if (ShouldSkip("PICS_SDK_CI_ONLY")) {
                NextTest();
                return;
            }
            err = TestRebootTargetDevice_5();
            break;
        case 6:
            ChipLogProgress(chipTool, " ***** Test Step 6 : Reboot target device(DUT)\n");
            if (ShouldSkip("PICS_SKIP_SAMPLE_APP")) {
                NextTest();
                return;
            }
            err = TestRebootTargetDeviceDUT_6();
            break;
        case 7:
            ChipLogProgress(chipTool, " ***** Test Step 7 : Wait for the commissioned device to be retrieved\n");
            err = TestWaitForTheCommissionedDeviceToBeRetrieved_7();
            break;
        case 8:
            ChipLogProgress(chipTool,
                " ***** Test Step 8 : DUT reboots and TH reads a UpTime attribute value of DUT since some arbitrary start time of "
                "DUT rebooting.\n");
            if (ShouldSkip("DGGEN.S.A0002")) {
                NextTest();
                return;
            }
            err = TestDutRebootsAndThReadsAUpTimeAttributeValueOfDutSinceSomeArbitraryStartTimeOfDutRebooting_8();
            break;
        case 9:
            ChipLogProgress(chipTool, " ***** Test Step 9 : TH reads a TotalOperationalHours attribute value from DUT.\n");
            if (ShouldSkip("DGGEN.S.A0003")) {
                NextTest();
                return;
            }
            err = TestThReadsATotalOperationalHoursAttributeValueFromDut_9();
            break;
        case 10:
            ChipLogProgress(chipTool, " ***** Test Step 10 : Reboot target device\n");
            if (ShouldSkip("PICS_SDK_CI_ONLY")) {
                NextTest();
                return;
            }
            err = TestRebootTargetDevice_10();
            break;
        case 11:
            ChipLogProgress(chipTool, " ***** Test Step 11 : Reboot target device(DUT)\n");
            if (ShouldSkip("PICS_SKIP_SAMPLE_APP")) {
                NextTest();
                return;
            }
            err = TestRebootTargetDeviceDUT_11();
            break;
        case 12:
            ChipLogProgress(chipTool, " ***** Test Step 12 : Wait for the commissioned device to be retrieved\n");
            err = TestWaitForTheCommissionedDeviceToBeRetrieved_12();
            break;
        case 13:
            ChipLogProgress(chipTool, " ***** Test Step 13 : TH reads BootReason attribute value from DUT.\n");
            if (ShouldSkip("DGGEN.S.A0004")) {
                NextTest();
                return;
            }
            err = TestThReadsBootReasonAttributeValueFromDut_13();
            break;
        case 14:
            ChipLogProgress(chipTool, " ***** Test Step 14 : TH reads ActiveHardwareFaults attribute value from DUT.\n");
            if (ShouldSkip("PICS_USER_PROMPT && DGGEN.S.A0005")) {
                NextTest();
                return;
            }
            err = TestThReadsActiveHardwareFaultsAttributeValueFromDut_14();
            break;
        case 15:
            ChipLogProgress(chipTool, " ***** Test Step 15 : TH reads ActiveRadioFaults attribute value from DUT.\n");
            if (ShouldSkip("PICS_USER_PROMPT && DGGEN.S.A0006")) {
                NextTest();
                return;
            }
            err = TestThReadsActiveRadioFaultsAttributeValueFromDut_15();
            break;
        case 16:
            ChipLogProgress(chipTool, " ***** Test Step 16 : TH reads ActiveNetworkFaults attribute value from DUT.\n");
            if (ShouldSkip("PICS_USER_PROMPT && DGGEN.S.A0007")) {
                NextTest();
                return;
            }
            err = TestThReadsActiveNetworkFaultsAttributeValueFromDut_16();
            break;
        case 17:
            ChipLogProgress(chipTool, " ***** Test Step 17 : TH reads TestEventTriggersEnabled attribute value\n");
            if (ShouldSkip("PICS_USER_PROMPT && DGGEN.S.A0008")) {
                NextTest();
                return;
            }
            err = TestThReadsTestEventTriggersEnabledAttributeValue_17();
            break;
        }

        if (CHIP_NO_ERROR != err) {
            ChipLogError(chipTool, " ***** Test Failure: %s\n", chip::ErrorStr(err));
            SetCommandExitStatus(err);
        }
    }

    void OnStatusUpdate(const chip::app::StatusIB & status) override
    {
        switch (mTestIndex - 1) {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 6:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 7:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 8:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 9:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 10:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 11:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 12:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 13:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 14:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 15:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 16:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 17:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        }

        // Go on to the next test.
        ContinueOnChipMainThread(CHIP_NO_ERROR);
    }

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    std::atomic_uint16_t mTestIndex;
    const uint16_t mTestCount = 18;

    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    CHIP_ERROR TestWaitForTheCommissionedDeviceToBeRetrieved_0()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
        value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
        return WaitForCommissionee("alpha", value);
    }

    CHIP_ERROR TestThReadsNetworkInterfacesStructureAttributeFromDut_1()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterGeneralDiagnostics alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeNetworkInterfacesWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads NetworkInterfaces structure attribute from DUT. Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("networkInterfaces", "list", "list"));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsARebootCountAttributeValueFromDut_2()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterGeneralDiagnostics alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeRebootCountWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads a RebootCount attribute value from DUT. Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("rebootCount", "int16u", "int16u"));
            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("rebootCount", [value unsignedShortValue], 0U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("rebootCount", [value unsignedShortValue], 65535U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestRebootTargetDevice_3()
    {

        chip::app::Clusters::SystemCommands::Commands::Reboot::Type value;
        return Reboot("alpha", value);
    }

    CHIP_ERROR TestRebootTargetDeviceDUT_4()
    {

        chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
        value.message
            = chip::Span<const char>("Please reboot the DUT and enter 'y' after DUT startsgarbage: not in length on purpose", 52);
        value.expectedValue.Emplace();
        value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
        return UserPrompt("alpha", value);
    }

    CHIP_ERROR TestRebootTargetDevice_5()
    {

        chip::app::Clusters::SystemCommands::Commands::Reboot::Type value;
        return Reboot("alpha", value);
    }

    CHIP_ERROR TestRebootTargetDeviceDUT_6()
    {

        chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
        value.message
            = chip::Span<const char>("Please reboot the DUT and enter 'y' after DUT startsgarbage: not in length on purpose", 52);
        value.expectedValue.Emplace();
        value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
        return UserPrompt("alpha", value);
    }

    CHIP_ERROR TestWaitForTheCommissionedDeviceToBeRetrieved_7()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
        value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
        return WaitForCommissionee("alpha", value);
    }

    CHIP_ERROR TestDutRebootsAndThReadsAUpTimeAttributeValueOfDutSinceSomeArbitraryStartTimeOfDutRebooting_8()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterGeneralDiagnostics alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeUpTimeWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"DUT reboots and TH reads a UpTime attribute value of DUT since some arbitrary start time of DUT rebooting. "
                  @"Error: %@",
                err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("upTime", "int64u", "int64u"));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsATotalOperationalHoursAttributeValueFromDut_9()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterGeneralDiagnostics alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeTotalOperationalHoursWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads a TotalOperationalHours attribute value from DUT. Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("totalOperationalHours", "int32u", "int32u"));
            VerifyOrReturn(CheckConstraintMinValue<uint32_t>("totalOperationalHours", [value unsignedIntValue], 0UL));
            VerifyOrReturn(CheckConstraintMaxValue<uint32_t>("totalOperationalHours", [value unsignedIntValue], 4294967294UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestRebootTargetDevice_10()
    {

        chip::app::Clusters::SystemCommands::Commands::Reboot::Type value;
        return Reboot("alpha", value);
    }

    CHIP_ERROR TestRebootTargetDeviceDUT_11()
    {

        chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
        value.message
            = chip::Span<const char>("Please reboot the DUT and enter 'y' after DUT startsgarbage: not in length on purpose", 52);
        value.expectedValue.Emplace();
        value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
        return UserPrompt("alpha", value);
    }

    CHIP_ERROR TestWaitForTheCommissionedDeviceToBeRetrieved_12()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
        value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
        return WaitForCommissionee("alpha", value);
    }

    CHIP_ERROR TestThReadsBootReasonAttributeValueFromDut_13()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterGeneralDiagnostics alloc] initWithDevice:device endpoint:@(0) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeBootReasonsWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads BootReason attribute value from DUT. Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("bootReasons", [value unsignedCharValue], 0U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("bootReasons", [value unsignedCharValue], 6U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsActiveHardwareFaultsAttributeValueFromDut_14()
    {

        chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
        value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
        value.expectedValue.Emplace();
        value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
        return UserPrompt("alpha", value);
    }

    CHIP_ERROR TestThReadsActiveRadioFaultsAttributeValueFromDut_15()
    {

        chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
        value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
        value.expectedValue.Emplace();
        value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
        return UserPrompt("alpha", value);
    }

    CHIP_ERROR TestThReadsActiveNetworkFaultsAttributeValueFromDut_16()
    {

        chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
        value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
        value.expectedValue.Emplace();
        value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
        return UserPrompt("alpha", value);
    }

    CHIP_ERROR TestThReadsTestEventTriggersEnabledAttributeValue_17()
    {

        chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
        value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
        value.expectedValue.Emplace();
        value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
        return UserPrompt("alpha", value);
    }
};

class Test_TC_I_1_1 : public TestCommandBridge {
public:
    // NOLINTBEGIN(clang-analyzer-nullability.NullPassedToNonnull): Test constructor nullability not enforced
    Test_TC_I_1_1()
        : TestCommandBridge("Test_TC_I_1_1")
        , mTestIndex(0)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }
    // NOLINTEND(clang-analyzer-nullability.NullPassedToNonnull)

    ~Test_TC_I_1_1() {}

    /////////// TestCommand Interface /////////
    void NextTest() override
    {
        CHIP_ERROR err = CHIP_NO_ERROR;

        if (0 == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Start: Test_TC_I_1_1\n");
        }

        if (mTestCount == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Complete: Test_TC_I_1_1\n");
            SetCommandExitStatus(CHIP_NO_ERROR);
            return;
        }

        Wait();

        // Ensure we increment mTestIndex before we start running the relevant
        // command.  That way if we lose the timeslice after we send the message
        // but before our function call returns, we won't end up with an
        // incorrect mTestIndex value observed when we get the response.
        switch (mTestIndex++) {
        case 0:
            ChipLogProgress(chipTool, " ***** Test Step 0 : Wait for the commissioned device to be retrieved\n");
            err = TestWaitForTheCommissionedDeviceToBeRetrieved_0();
            break;
        case 1:
            ChipLogProgress(chipTool, " ***** Test Step 1 : TH reads the ClusterRevision attribute from the DUT\n");
            err = TestThReadsTheClusterRevisionAttributeFromTheDut_1();
            break;
        case 2:
            ChipLogProgress(chipTool, " ***** Test Step 2 : TH reads the FeatureMap attribute from the DUT\n");
            err = TestThReadsTheFeatureMapAttributeFromTheDut_2();
            break;
        case 3:
            ChipLogProgress(chipTool, " ***** Test Step 3 : Read the global attribute: AttributeList\n");
            err = TestReadTheGlobalAttributeAttributeList_3();
            break;
        case 4:
            ChipLogProgress(chipTool, " ***** Test Step 4 : Read the global attribute: AcceptedCommandList\n");
            err = TestReadTheGlobalAttributeAcceptedCommandList_4();
            break;
        case 5:
            ChipLogProgress(chipTool, " ***** Test Step 5 : Read the optional command(TriggerEffect) in AcceptedCommandList\n");
            if (ShouldSkip("I.S.C40.Rsp")) {
                NextTest();
                return;
            }
            err = TestReadTheOptionalCommandTriggerEffectInAcceptedCommandList_5();
            break;
        case 6:
            ChipLogProgress(chipTool, " ***** Test Step 6 : Read the global attribute: GeneratedCommandList\n");
            err = TestReadTheGlobalAttributeGeneratedCommandList_6();
            break;
        }

        if (CHIP_NO_ERROR != err) {
            ChipLogError(chipTool, " ***** Test Failure: %s\n", chip::ErrorStr(err));
            SetCommandExitStatus(err);
        }
    }

    void OnStatusUpdate(const chip::app::StatusIB & status) override
    {
        switch (mTestIndex - 1) {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 6:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        }

        // Go on to the next test.
        ContinueOnChipMainThread(CHIP_NO_ERROR);
    }

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    std::atomic_uint16_t mTestIndex;
    const uint16_t mTestCount = 7;

    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    CHIP_ERROR TestWaitForTheCommissionedDeviceToBeRetrieved_0()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
        value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
        return WaitForCommissionee("alpha", value);
    }

    CHIP_ERROR TestThReadsTheClusterRevisionAttributeFromTheDut_1()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterIdentify alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeClusterRevisionWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads the ClusterRevision attribute from the DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("ClusterRevision", actualValue, 4U));
            }

            VerifyOrReturn(CheckConstraintType("clusterRevision", "int16u", "int16u"));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsTheFeatureMapAttributeFromTheDut_2()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterIdentify alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeFeatureMapWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads the FeatureMap attribute from the DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("FeatureMap", actualValue, 0UL));
            }

            VerifyOrReturn(CheckConstraintType("featureMap", "bitmap32", "bitmap32"));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheGlobalAttributeAttributeList_3()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterIdentify alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAttributeListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the global attribute: AttributeList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("attributeList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 0UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 1UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65528UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65529UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65531UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65532UL));
            VerifyOrReturn(CheckConstraintContains("attributeList", value, 65533UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheGlobalAttributeAcceptedCommandList_4()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterIdentify alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAcceptedCommandListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the global attribute: AcceptedCommandList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("acceptedCommandList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("acceptedCommandList", value, 0UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheOptionalCommandTriggerEffectInAcceptedCommandList_5()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterIdentify alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeAcceptedCommandListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the optional command(TriggerEffect) in AcceptedCommandList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("acceptedCommandList", "list", "list"));
            VerifyOrReturn(CheckConstraintContains("acceptedCommandList", value, 64UL));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestReadTheGlobalAttributeGeneratedCommandList_6()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterIdentify alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeGeneratedCommandListWithCompletion:^(NSArray * _Nullable value, NSError * _Nullable err) {
            NSLog(@"Read the global attribute: GeneratedCommandList Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            {
                id actualValue = value;
                VerifyOrReturn(CheckValue("GeneratedCommandList", [actualValue count], static_cast<uint32_t>(0)));
            }

            VerifyOrReturn(CheckConstraintType("generatedCommandList", "list", "list"));
            NextTest();
        }];

        return CHIP_NO_ERROR;
    }
};

class Test_TC_I_2_1 : public TestCommandBridge {
public:
    // NOLINTBEGIN(clang-analyzer-nullability.NullPassedToNonnull): Test constructor nullability not enforced
    Test_TC_I_2_1()
        : TestCommandBridge("Test_TC_I_2_1")
        , mTestIndex(0)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }
    // NOLINTEND(clang-analyzer-nullability.NullPassedToNonnull)

    ~Test_TC_I_2_1() {}

    /////////// TestCommand Interface /////////
    void NextTest() override
    {
        CHIP_ERROR err = CHIP_NO_ERROR;

        if (0 == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Start: Test_TC_I_2_1\n");
        }

        if (mTestCount == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Complete: Test_TC_I_2_1\n");
            SetCommandExitStatus(CHIP_NO_ERROR);
            return;
        }

        Wait();

        // Ensure we increment mTestIndex before we start running the relevant
        // command.  That way if we lose the timeslice after we send the message
        // but before our function call returns, we won't end up with an
        // incorrect mTestIndex value observed when we get the response.
        switch (mTestIndex++) {
        case 0:
            ChipLogProgress(chipTool, " ***** Test Step 0 : Wait for the commissioned device to be retrieved\n");
            err = TestWaitForTheCommissionedDeviceToBeRetrieved_0();
            break;
        case 1:
            ChipLogProgress(chipTool, " ***** Test Step 1 : TH reads the IdentifyTime attribute from the DUT\n");
            err = TestThReadsTheIdentifyTimeAttributeFromTheDut_1();
            break;
        case 2:
            ChipLogProgress(chipTool, " ***** Test Step 2 : TH reads the IdentifyType attribute from the DUT\n");
            err = TestThReadsTheIdentifyTypeAttributeFromTheDut_2();
            break;
        }

        if (CHIP_NO_ERROR != err) {
            ChipLogError(chipTool, " ***** Test Failure: %s\n", chip::ErrorStr(err));
            SetCommandExitStatus(err);
        }
    }

    void OnStatusUpdate(const chip::app::StatusIB & status) override
    {
        switch (mTestIndex - 1) {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        }

        // Go on to the next test.
        ContinueOnChipMainThread(CHIP_NO_ERROR);
    }

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    std::atomic_uint16_t mTestIndex;
    const uint16_t mTestCount = 3;

    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    CHIP_ERROR TestWaitForTheCommissionedDeviceToBeRetrieved_0()
    {

        chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
        value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
        return WaitForCommissionee("alpha", value);
    }

    CHIP_ERROR TestThReadsTheIdentifyTimeAttributeFromTheDut_1()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterIdentify alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeIdentifyTimeWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads the IdentifyTime attribute from the DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("identifyTime", "int16u", "int16u"));
            VerifyOrReturn(CheckConstraintMinValue<uint16_t>("identifyTime", [value unsignedShortValue], 0U));
            VerifyOrReturn(CheckConstraintMaxValue<uint16_t>("identifyTime", [value unsignedShortValue], 65535U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }

    CHIP_ERROR TestThReadsTheIdentifyTypeAttributeFromTheDut_2()
    {

        MTRBaseDevice * device = GetDevice("alpha");
        __auto_type * cluster = [[MTRBaseClusterIdentify alloc] initWithDevice:device endpoint:@(1) queue:mCallbackQueue];
        VerifyOrReturnError(cluster != nil, CHIP_ERROR_INCORRECT_STATE);

        [cluster readAttributeIdentifyTypeWithCompletion:^(NSNumber * _Nullable value, NSError * _Nullable err) {
            NSLog(@"TH reads the IdentifyType attribute from the DUT Error: %@", err);

            VerifyOrReturn(CheckValue("status", err ? err.code : 0, 0));

            VerifyOrReturn(CheckConstraintType("identifyType", "enum8", "enum8"));
            VerifyOrReturn(CheckConstraintMinValue<uint8_t>("identifyType", [value unsignedCharValue], 0U));
            VerifyOrReturn(CheckConstraintMaxValue<uint8_t>("identifyType", [value unsignedCharValue], 5U));

            NextTest();
        }];

        return CHIP_NO_ERROR;
    }
};

class Test_TC_I_2_2 : public TestCommandBridge {
public:
    // NOLINTBEGIN(clang-analyzer-nullability.NullPassedToNonnull): Test constructor nullability not enforced
    Test_TC_I_2_2()
        : TestCommandBridge("Test_TC_I_2_2")
        , mTestIndex(0)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }
    // NOLINTEND(clang-analyzer-nullability.NullPassedToNonnull)

    ~Test_TC_I_2_2() {}

    /////////// TestCommand Interface /////////
    void NextTest() override
    {
        CHIP_ERROR err = CHIP_NO_ERROR;

        if (0 == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Start: Test_TC_I_2_2\n");
        }

        if (mTestCount == mTestIndex) {
            ChipLogProgress(chipTool, " **** Test Complete: Test_TC_I_2_2\n");
            SetCommandExitStatus(CHIP_NO_ERROR);
            return;
        }

        Wait();

        // Ensure we increment mTestIndex before we start running the relevant
        // command.  That way if we lose the timeslice after we send the message
        // but before our function call returns, we won't end up with an
        // incorrect mTestIndex value observed when we get the response.
        switch (mTestIndex++) {
        case 0:
            ChipLogProgress(chipTool, " ***** Test Step 0 : Wait for the commissioned device to be retrieved\n");
            err = TestWaitForTheCommissionedDeviceToBeRetrieved_0();
            break;
        case 1:
            ChipLogProgress(chipTool,
                " ***** Test Step 1 : TH sends Identify command to DUT, with the identify time field set to 0x003c (60s).\n");
            if (ShouldSkip("I.S.C00.Rsp")) {
                NextTest();
                return;
            }
            err = TestThSendsIdentifyCommandToDutWithTheIdentifyTimeFieldSetTo0x003c60s_1();
            break;
        case 2:
            ChipLogProgress(chipTool, " ***** Test Step 2 : TH reads immediately IdentifyTime attribute from DUT\n");
            if (ShouldSkip("I.S.A0000")) {
                NextTest();
                return;
            }
            err = TestThReadsImmediatelyIdentifyTimeAttributeFromDut_2();
            break;
        case 3:
            ChipLogProgress(chipTool, " ***** Test Step 3 : Wait 10000ms\n");
            err = TestWait10000ms_3();
            break;
        case 4:
            ChipLogProgress(chipTool, " ***** Test Step 4 : After 10 seconds, the TH reads IdentifyTime attribute from DUT\n");
            if (ShouldSkip("I.S.A0000")) {
                NextTest();
                return;
            }
            err = TestAfter10SecondsTheThReadsIdentifyTimeAttributeFromDut_4();
            break;
        case 5:
            ChipLogProgress(chipTool,
                " ***** Test Step 5 : TH sends IdentifyQuery command to DUT and Verify IdentifyQueryResponse command to TH,with "
                "the Timeout field set to a value in the range 0x0000 to 0x0032\n");
            if (ShouldSkip("PICS_USER_PROMPT && I.S.C01.Rsp && I.S.C00.Tx")) {
                NextTest();
                return;
            }
            err = TestThSendsIdentifyQueryCommandToDutAndVerifyIdentifyQueryResponseCommandToTHwithTheTimeoutFieldSetToAValueInTheRange0x0000To0x0032_5();
            break;
        case 6:
            ChipLogProgress(chipTool,
                " ***** Test Step 6 : TH sends Identify command to DUT, with the identify time field set to 0x0000 (stop "
                "identifying).\n");
            if (ShouldSkip("I.S.C00.Rsp")) {
                NextTest();
                return;
            }
            err = TestThSendsIdentifyCommandToDutWithTheIdentifyTimeFieldSetTo0x0000StopIdentifying_6();
            break;
        case 7:
            ChipLogProgress(chipTool, " ***** Test Step 7 : TH reads immediately IdentifyTime attribute from DUT\n");
            if (ShouldSkip("I.S.A0000")) {
                NextTest();
                return;
            }
            err = TestThReadsImmediatelyIdentifyTimeAttributeFromDut_7();
            break;
        case 8:
            ChipLogProgress(chipTool, " ***** Test Step 8 : TH writes a value of 0x000f (15s) to IdentifyTime attribute of DUT\n");
            if (ShouldSkip("I.S.A0000")) {
                NextTest();
                return;
            }
            err = TestThWritesAValueOf0x000f15sToIdentifyTimeAttributeOfDut_8();
            break;
        case 9:
            ChipLogProgress(chipTool, " ***** Test Step 9 : Wait 5000ms\n");
            err = TestWait5000ms_9();
            break;
        case 10:
            ChipLogProgress(chipTool, " ***** Test Step 10 : After 5 seconds, the TH reads IdentifyTime attribute from DUT\n");
            if (ShouldSkip("I.S.A0000")) {
                NextTest();
                return;
            }
            err = TestAfter5SecondsTheThReadsIdentifyTimeAttributeFromDut_10();
            break;
        }

        if (CHIP_NO_ERROR != err) {
            ChipLogError(chipTool, " ***** Test Failure: %s\n", chip::ErrorStr(err));
            SetCommandExitStatus(err);
        }
    }

    void OnStatusUpdate(const chip::app::StatusIB & status) override
    {
        switch (mTestIndex - 1) {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 6:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 7:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 8:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 9:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 10:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        }

        // Go on to the next test.
        ContinueOnChipMainThread(CHIP_NO_ERROR);
    }

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    std::atomic_uint16_t mTestIndex;
    const uint16