/*
 *
 *    Copyright (c) 2022 Project CHIP Authors
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

// THIS FILE IS GENERATED BY ZAP

// Prevent multiple inclusion
#pragma once

#include <app-common/zap-generated/ids/Clusters.h>
#include <app-common/zap-generated/ids/Commands.h>

#include <controller/CHIPCluster.h>
#include <lib/core/CHIPCallback.h>
#include <lib/support/Span.h>

namespace chip {
namespace Controller {

class DLL_EXPORT OnOffCluster : public ClusterBase
{
public:
    OnOffCluster(Messaging::ExchangeManager & exchangeManager, const SessionHandle & session, EndpointId endpoint) :
        ClusterBase(exchangeManager, session, app::Clusters::OnOff::Id, endpoint)
    {}
    ~OnOffCluster() {}
};

class DLL_EXPORT GeneralCommissioningCluster : public ClusterBase
{
public:
    GeneralCommissioningCluster(Messaging::ExchangeManager & exchangeManager, const SessionHandle & session, EndpointId endpoint) :
        ClusterBase(exchangeManager, session, app::Clusters::GeneralCommissioning::Id, endpoint)
    {}
    ~GeneralCommissioningCluster() {}
};

class DLL_EXPORT SwitchCluster : public ClusterBase
{
public:
    SwitchCluster(Messaging::ExchangeManager & exchangeManager, const SessionHandle & session, EndpointId endpoint) :
        ClusterBase(exchangeManager, session, app::Clusters::Switch::Id, endpoint)
    {}
    ~SwitchCluster() {}
};

class DLL_EXPORT OperationalCredentialsCluster : public ClusterBase
{
public:
    OperationalCredentialsCluster(Messaging::ExchangeManager & exchangeManager, const SessionHandle & session,
                                  EndpointId endpoint) :
        ClusterBase(exchangeManager, session, app::Clusters::OperationalCredentials::Id, endpoint)
    {}
    ~OperationalCredentialsCluster() {}
};

class DLL_EXPORT ModeSelectCluster : public ClusterBase
{
public:
    ModeSelectCluster(Messaging::ExchangeManager & exchangeManager, const SessionHandle & session, EndpointId endpoint) :
        ClusterBase(exchangeManager, session, app::Clusters::ModeSelect::Id, endpoint)
    {}
    ~ModeSelectCluster() {}
};

class DLL_EXPORT ThermostatUserInterfaceConfigurationCluster : public ClusterBase
{
public:
    ThermostatUserInterfaceConfigurationCluster(Messaging::ExchangeManager & exchangeManager, const SessionHandle & session,
                                                EndpointId endpoint) :
        ClusterBase(exchangeManager, session, app::Clusters::ThermostatUserInterfaceConfiguration::Id, endpoint)
    {}
    ~ThermostatUserInterfaceConfigurationCluster() {}
};

class DLL_EXPORT TemperatureMeasurementCluster : public ClusterBase
{
public:
    TemperatureMeasurementCluster(Messaging::ExchangeManager & exchangeManager, const SessionHandle & session,
                                  EndpointId endpoint) :
        ClusterBase(exchangeManager, session, app::Clusters::TemperatureMeasurement::Id, endpoint)
    {}
    ~TemperatureMeasurementCluster() {}
};

class DLL_EXPORT RelativeHumidityMeasurementCluster : public ClusterBase
{
public:
    RelativeHumidityMeasurementCluster(Messaging::ExchangeManager & exchangeManager, const SessionHandle & session,
                                       EndpointId endpoint) :
        ClusterBase(exchangeManager, session, app::Clusters::RelativeHumidityMeasurement::Id, endpoint)
    {}
    ~RelativeHumidityMeasurementCluster() {}
};

class DLL_EXPORT TargetNavigatorCluster : public ClusterBase
{
public:
    TargetNavigatorCluster(Messaging::ExchangeManager & exchangeManager, const SessionHandle & session, EndpointId endpoint) :
        ClusterBase(exchangeManager, session, app::Clusters::TargetNavigator::Id, endpoint)
    {}
    ~TargetNavigatorCluster() {}
};

class DLL_EXPORT KeypadInputCluster : public ClusterBase
{
public:
    KeypadInputCluster(Messaging::ExchangeManager & exchangeManager, const SessionHandle & session, EndpointId endpoint) :
        ClusterBase(exchangeManager, session, app::Clusters::KeypadInput::Id, endpoint)
    {}
    ~KeypadInputCluster() {}
};

class DLL_EXPORT ContentLauncherCluster : public ClusterBase
{
public:
    ContentLauncherCluster(Messaging::ExchangeManager & exchangeManager, const SessionHandle & session, EndpointId endpoint) :
        ClusterBase(exchangeManager, session, app::Clusters::ContentLauncher::Id, endpoint)
    {}
    ~ContentLauncherCluster() {}
};

class DLL_EXPORT ApplicationBasicCluster : public ClusterBase
{
public:
    ApplicationBasicCluster(Messaging::ExchangeManager & exchangeManager, const SessionHandle & session, EndpointId endpoint) :
        ClusterBase(exchangeManager, session, app::Clusters::ApplicationBasic::Id, endpoint)
    {}
    ~ApplicationBasicCluster() {}
};

} // namespace Controller
} // namespace chip
