/*
 *
 *    Copyright (c) 2022 Project CHIP Authors
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

// THIS FILE IS GENERATED BY ZAP

// Prevent multiple inclusion
#pragma once

#include <app-common/zap-generated/ids/Clusters.h>
#include <app-common/zap-generated/ids/Commands.h>

#include <controller/CHIPCluster.h>
#include <lib/core/CHIPCallback.h>
#include <lib/support/Span.h>

namespace chip {
namespace Controller {

class DLL_EXPORT OnOffCluster : public ClusterBase
{
public:
    OnOffCluster(Messaging::ExchangeManager & exchangeManager, const SessionHandle & session, EndpointId endpoint) :
        ClusterBase(exchangeManager, session, app::Clusters::OnOff::Id, endpoint)
    {}
    ~OnOffCluster() {}
};

class DLL_EXPORT LevelControlCluster : public ClusterBase
{
public:
    LevelControlCluster(Messaging::ExchangeManager & exchangeManager, const SessionHandle & session, EndpointId endpoint) :
        ClusterBase(exchangeManager, session, app::Clusters::LevelControl::Id, endpoint)
    {}
    ~LevelControlCluster() {}
};

class DLL_EXPORT DescriptorCluster : public ClusterBase
{
public:
    DescriptorCluster(Messaging::ExchangeManager & exchangeManager, const SessionHandle & session, EndpointId endpoint) :
        ClusterBase(exchangeManager, session, app::Clusters::Descriptor::Id, endpoint)
    {}
    ~DescriptorCluster() {}
};

class DLL_EXPORT ChannelCluster : public ClusterBase
{
public:
    ChannelCluster(Messaging::ExchangeManager & exchangeManager, const SessionHandle & session, EndpointId endpoint) :
        ClusterBase(exchangeManager, session, app::Clusters::Channel::Id, endpoint)
    {}
    ~ChannelCluster() {}
};

class DLL_EXPORT TargetNavigatorCluster : public ClusterBase
{
public:
    TargetNavigatorCluster(Messaging::ExchangeManager & exchangeManager, const SessionHandle & session, EndpointId endpoint) :
        ClusterBase(exchangeManager, session, app::Clusters::TargetNavigator::Id, endpoint)
    {}
    ~TargetNavigatorCluster() {}
};

class DLL_EXPORT MediaPlaybackCluster : public ClusterBase
{
public:
    MediaPlaybackCluster(Messaging::ExchangeManager & exchangeManager, const SessionHandle & session, EndpointId endpoint) :
        ClusterBase(exchangeManager, session, app::Clusters::MediaPlayback::Id, endpoint)
    {}
    ~MediaPlaybackCluster() {}
};

class DLL_EXPORT MediaInputCluster : public ClusterBase
{
public:
    MediaInputCluster(Messaging::ExchangeManager & exchangeManager, const SessionHandle & session, EndpointId endpoint) :
        ClusterBase(exchangeManager, session, app::Clusters::MediaInput::Id, endpoint)
    {}
    ~MediaInputCluster() {}
};

class DLL_EXPORT KeypadInputCluster : public ClusterBase
{
public:
    KeypadInputCluster(Messaging::ExchangeManager & exchangeManager, const SessionHandle & session, EndpointId endpoint) :
        ClusterBase(exchangeManager, session, app::Clusters::KeypadInput::Id, endpoint)
    {}
    ~KeypadInputCluster() {}
};

class DLL_EXPORT ContentLauncherCluster : public ClusterBase
{
public:
    ContentLauncherCluster(Messaging::ExchangeManager & exchangeManager, const SessionHandle & session, EndpointId endpoint) :
        ClusterBase(exchangeManager, session, app::Clusters::ContentLauncher::Id, endpoint)
    {}
    ~ContentLauncherCluster() {}
};

class DLL_EXPORT AudioOutputCluster : public ClusterBase
{
public:
    AudioOutputCluster(Messaging::ExchangeManager & exchangeManager, const SessionHandle & session, EndpointId endpoint) :
        ClusterBase(exchangeManager, session, app::Clusters::AudioOutput::Id, endpoint)
    {}
    ~AudioOutputCluster() {}
};

class DLL_EXPORT ApplicationLauncherCluster : public ClusterBase
{
public:
    ApplicationLauncherCluster(Messaging::ExchangeManager & exchangeManager, const SessionHandle & session, EndpointId endpoint) :
        ClusterBase(exchangeManager, session, app::Clusters::ApplicationLauncher::Id, endpoint)
    {}
    ~ApplicationLauncherCluster() {}
};

class DLL_EXPORT ApplicationBasicCluster : public ClusterBase
{
public:
    ApplicationBasicCluster(Messaging::ExchangeManager & exchangeManager, const SessionHandle & session, EndpointId endpoint) :
        ClusterBase(exchangeManager, session, app::Clusters::ApplicationBasic::Id, endpoint)
    {}
    ~ApplicationBasicCluster() {}
};

class DLL_EXPORT AccountLoginCluster : public ClusterBase
{
public:
    AccountLoginCluster(Messaging::ExchangeManager & exchangeManager, const SessionHandle & session, EndpointId endpoint) :
        ClusterBase(exchangeManager, session, app::Clusters::AccountLogin::Id, endpoint)
    {}
    ~AccountLoginCluster() {}
};

} // namespace Controller
} // namespace chip
