static const uint64_t in_cfft_noisy_16[32] = {
    0x3fa0a425a6ffe96e, 0x0,
    0x3fdf1a830e9af528, 0x0,
    0x3fe4158b45facc14, 0x0,
    0x3fde14d1926d13ca, 0x0,
    0x3fa2e3b9e69f18d5, 0x0,
    0xbfdd5fc75f234002, 0x0,
    0xbfe91c66e089d414, 0x0,
    0xbfddf2377417d0ad, 0x0,
    0x3fab4603137b6431, 0x0,
    0x3fdf7789bfc57a06, 0x0,
    0x3fe6bfb1a337fc22, 0x0,
    0x3fdd623e293820ef, 0x0,
    0x3f850f16268b93ff, 0x0,
    0xbfd9fe60f0b76df4, 0x0,
    0xbfe627a515cf7678, 0x0,
    0xbfe07f4d3848df29, 0x0
    };

static const uint64_t in_cifft_noisy_16[32] = {
    0x3faaf5ca04605d94, 0x0,
    0xbfa4111bdce087b0, 0x3fbec9b6fe7f17c2,
    0xbf860bbd7c76c670, 0xc015e257f8894558,
    0xbfbb41f7fa2c29b7, 0x3fb8942a4e5c4f1e,
    0x3fd15fd31fa4ae1a, 0xbfc55b4d4f143700,
    0x3faaa80a6464a1d3, 0xbfca5194be393fa4,
    0x3fb68420f9c828b9, 0x3fc47f47eb37eb00,
    0x3f85962eeb99390a, 0xbfb32db412574efb,
    0xbfb0562da9db08b6, 0x0,
    0x3f85962eeb9938f8, 0x3fb32db412574efe,
    0x3fb68420f9c828b2, 0xbfc47f47eb37eb00,
    0x3faaa80a6464a1ce, 0x3fca5194be393fa5,
    0x3fd15fd31fa4ae1a, 0x3fc55b4d4f143700,
    0xbfbb41f7fa2c29b6, 0xbfb8942a4e5c4f20,
    0xbf860bbd7c76c838, 0x4015e257f8894558,
    0xbfa4111bdce087ae, 0xbfbec9b6fe7f17c1
    };

static const uint64_t ref_cfft_noisy_16[32] = {
    0x3faaf5ca04605d94, 0x0,
    0xbfa4111bdce087b0, 0x3fbec9b6fe7f17c2,
    0xbf860bbd7c76c670, 0xc015e257f8894558,
    0xbfbb41f7fa2c29b7, 0x3fb8942a4e5c4f1e,
    0x3fd15fd31fa4ae1a, 0xbfc55b4d4f143700,
    0x3faaa80a6464a1d3, 0xbfca5194be393fa4,
    0x3fb68420f9c828b9, 0x3fc47f47eb37eb00,
    0x3f85962eeb99390a, 0xbfb32db412574efb,
    0xbfb0562da9db08b6, 0x0,
    0x3f85962eeb9938f8, 0x3fb32db412574efe,
    0x3fb68420f9c828b2, 0xbfc47f47eb37eb00,
    0x3faaa80a6464a1ce, 0x3fca5194be393fa5,
    0x3fd15fd31fa4ae1a, 0x3fc55b4d4f143700,
    0xbfbb41f7fa2c29b6, 0xbfb8942a4e5c4f20,
    0xbf860bbd7c76c838, 0x4015e257f8894558,
    0xbfa4111bdce087ae, 0xbfbec9b6fe7f17c1
    };

static const uint64_t in_cfft_noisy_32[64] = {
    0xbfb7727caba4a4e2, 0x0,
    0x3fde42d807df6889, 0x0,
    0x3fe657c04a4cad07, 0x0,
    0x3fdd019c822018ec, 0x0,
    0xbfac3b3073488e80, 0x0,
    0xbfdf2b33554e47f6, 0x0,
    0xbfe72853fd707711, 0x0,
    0xbfe0fd9dde8a95e8, 0x0,
    0xbfa0cc15be30b476, 0x0,
    0x3fdedfdc08fe061d, 0x0,
    0x3fe2d2eca96d84b4, 0x0,
    0x3fde485b3925d608, 0x0,
    0xbf8f221bf61eca51, 0x0,
    0xbfe2d8fb7e6754d9, 0x0,
    0xbfe38660bf43c549, 0x0,
    0xbfe0c6b92cd23b3b, 0x0,
    0xbfb306f202efa7e5, 0x0,
    0x3fe1b30b0bcd973d, 0x0,
    0x3fe4ce3920fa45d0, 0x0,
    0x3fdf271d28240f4c, 0x0,
    0x3fa43e6523ebbac6, 0x0,
    0xbfde9f48b2c03aac, 0x0,
    0xbfe4df565ec71471, 0x0,
    0xbfe0edb107dd04b5, 0x0,
    0xbf7d12cd2e975cae, 0x0,
    0x3fe0d8c627735bbc, 0x0,
    0x3fe73415587f4cd1, 0x0,
    0x3fdec781ebe7721d, 0x0,
    0xbf641386411e31b8, 0x0,
    0xbfdf941ec561b8e6, 0x0,
    0xbfe79b20de7447c0, 0x0,
    0xbfe1eaff635413f6, 0x0
    };

static const uint64_t in_cifft_noisy_32[64] = {
    0xbfe20e87bc32f84a, 0x0,
    0xbfc6c7673fc0df29, 0x3fd76c70a6eea912,
    0xbfc1ae3eec2aed60, 0xbfbe241878f594fb,
    0xbfc73705af2ed48b, 0xbfb3475e00775846,
    0xbfc210c649ec0db0, 0xc026417b075c8541,
    0x3fa5119061e1e5e2, 0xbfcc33b3c41c2bfa,
    0xbfaacb87d462ae78, 0xbf5af789c5441460,
    0xbfc01b210fbd8489, 0xbfa47718d1031716,
    0xbfc6a933a9995812, 0xbfce567995d5a538,
    0x3fb27d8fbb415eba, 0xbfb64b0fe40d2d34,
    0xbfd27e51738cee03, 0x3f709e1469d83620,
    0x3fcc69282eb9628f, 0x3fd74bbbc7acd810,
    0xbfca1c9abe2eda48, 0xbfd6d6c34f0334a0,
    0x3fb4b6ffd5287375, 0x3fd3b643684dbdb1,
    0xbf993551863c2408, 0xbfba9470e6c97d5a,
    0xbfb1b8e1671b01ac, 0xbfb67a9c46858a08,
    0xbfa36d44b89046e8, 0x0,
    0xbfb1b8e1671b01ae, 0x3fb67a9c46858a06,
    0xbf993551863c240c, 0x3fba9470e6c97d5b,
    0x3fb4b6ffd528737a, 0xbfd3b643684dbdb0,
    0xbfca1c9abe2eda50, 0x3fd6d6c34f0334a0,
    0x3fcc69282eb96290, 0xbfd74bbbc7acd80f,
    0xbfd27e51738cee03, 0xbf709e1469d83630,
    0x3fb27d8fbb415eb8, 0x3fb64b0fe40d2d35,
    0xbfc6a933a9995812, 0x3fce567995d5a538,
    0xbfc01b210fbd8489, 0x3fa47718d1031718,
    0xbfaacb87d462ae7a, 0x3f5af789c5441460,
    0x3fa5119061e1e5d4, 0x3fcc33b3c41c2bfc,
    0xbfc210c649ec0de8, 0x4026417b075c8541,
    0xbfc73705af2ed48c, 0x3fb3475e00775845,
    0xbfc1ae3eec2aed60, 0x3fbe241878f594fa,
    0xbfc6c7673fc0df28, 0xbfd76c70a6eea914
    };

static const uint64_t ref_cfft_noisy_32[64] = {
    0xbfe20e87bc32f84a, 0x0,
    0xbfc6c7673fc0df29, 0x3fd76c70a6eea912,
    0xbfc1ae3eec2aed60, 0xbfbe241878f594fb,
    0xbfc73705af2ed48b, 0xbfb3475e00775846,
    0xbfc210c649ec0db0, 0xc026417b075c8541,
    0x3fa5119061e1e5e2, 0xbfcc33b3c41c2bfa,
    0xbfaacb87d462ae78, 0xbf5af789c5441460,
    0xbfc01b210fbd8489, 0xbfa47718d1031716,
    0xbfc6a933a9995812, 0xbfce567995d5a538,
    0x3fb27d8fbb415eba, 0xbfb64b0fe40d2d34,
    0xbfd27e51738cee03, 0x3f709e1469d83620,
    0x3fcc69282eb9628f, 0x3fd74bbbc7acd810,
    0xbfca1c9abe2eda48, 0xbfd6d6c34f0334a0,
    0x3fb4b6ffd5287375, 0x3fd3b643684dbdb1,
    0xbf993551863c2408, 0xbfba9470e6c97d5a,
    0xbfb1b8e1671b01ac, 0xbfb67a9c46858a08,
    0xbfa36d44b89046e8, 0x0,
    0xbfb1b8e1671b01ae, 0x3fb67a9c46858a06,
    0xbf993551863c240c, 0x3fba9470e6c97d5b,
    0x3fb4b6ffd528737a, 0xbfd3b643684dbdb0,
    0xbfca1c9abe2eda50, 0x3fd6d6c34f0334a0,
    0x3fcc69282eb96290, 0xbfd74bbbc7acd80f,
    0xbfd27e51738cee03, 0xbf709e1469d83630,
    0x3fb27d8fbb415eb8, 0x3fb64b0fe40d2d35,
    0xbfc6a933a9995812, 0x3fce567995d5a538,
    0xbfc01b210fbd8489, 0x3fa47718d1031718,
    0xbfaacb87d462ae7a, 0x3f5af789c5441460,
    0x3fa5119061e1e5d4, 0x3fcc33b3c41c2bfc,
    0xbfc210c649ec0de8, 0x4026417b075c8541,
    0xbfc73705af2ed48c, 0x3fb3475e00775845,
    0xbfc1ae3eec2aed60, 0x3fbe241878f594fa,
    0xbfc6c7673fc0df28, 0xbfd76c70a6eea914
    };

static const uint64_t in_cfft_noisy_64[128] = {
    0xbfa8ba72755e557c, 0x0,
    0x3fdee87baa40e59e, 0x0,
    0x3fe71315059a5aa9, 0x0,
    0x3fdf4934a5b6a7c5, 0x0,
    0xbfa2bf0fcdc4d8f5, 0x0,
    0xbfd9d3bcdff218b1, 0x0,
    0xbfe525581eaf3527, 0x0,
    0xbfe22d5f0ca19349, 0x0,
    0xbf61c8e7d342963b, 0x0,
    0x3fe1c1f7d4bd7c6a, 0x0,
    0x3fe82f2816794859, 0x0,
    0x3fdd22540ed274aa, 0x0,
    0x3f68d5c09b189382, 0x0,
    0xbfdd78ee59d59b2e, 0x0,
    0xbfe924f5e4a7bb78, 0x0,
    0xbfdd24a761f26335, 0x0,
    0xbfa42b238ae1eeb4, 0x0,
    0x3fe17d4801eb7a23, 0x0,
    0x3fe7d0a452c91a59, 0x0,
    0x3fe0b26856663651, 0x0,
    0x3fa72730062eeb26, 0x0,
    0xbfe074abb87f2852, 0x0,
    0xbfe560657c274525, 0x0,
    0xbfe204b9a73dd4c2, 0x0,
    0xbf8b2ebfdcd8f2ab, 0x0,
    0x3fdff8f9e776fc0f, 0x0,
    0x3fe3183ae974aa02, 0x0,
    0x3fe3be8e835ab680, 0x0,
    0x3fa9971f6c8c1510, 0x0,
    0xbfdeebeea2a465e6, 0x0,
    0xbfe62f16d988ece5, 0x0,
    0xbfd9a11107421454, 0x0,
    0x3f695b44b19ca54f, 0x0,
    0x3fdbd1720c896a74, 0x0,
    0x3fe57f32d73f0dff, 0x0,
    0x3fdc41f98489c45e, 0x0,
    0x3f7f7b902963b93c, 0x0,
    0xbfdef3fc9c85852b, 0x0,
    0xbfe45bf8c87dabfa, 0x0,
    0xbfe12b4326211ae6, 0x0,
    0x3fa2e7e1c0f30827, 0x0,
    0x3fe2353321e2cfa7, 0x0,
    0x3fe70a906b646d7b, 0x0,
    0x3fda81ae298a945a, 0x0,
    0xbf5ac6edcf3fb3bb, 0x0,
    0xbfe142ae190fc689, 0x0,
    0xbfe641bba87dd9e0, 0x0,
    0xbfd9c8b8357eb704, 0x0,
    0x3f7b4eb98e8159e0, 0x0,
    0x3fde6b37f7f85bd4, 0x0,
    0x3fe82b039c7062bb, 0x0,
    0x3fe19df8f4223c57, 0x0,
    0xbf90fa9b0a8636db, 0x0,
    0xbfdeb90c70e30198, 0x0,
    0xbfe7965956717c2e, 0x0,
    0xbfe04132c9dd08a6, 0x0,
    0xbfadf45074aaa972, 0x0,
    0x3fdcd304a008fc3a, 0x0,
    0x3fe57f24e3129b91, 0x0,
    0x3fde4123be8c64dd, 0x0,
    0xbf91b3085459ba48, 0x0,
    0xbfe00711a80c9ab5, 0x0,
    0xbfe38001cd7c80ac, 0x0,
    0xbfe09df39b2d24d1, 0x0
    };

static const uint64_t in_cifft_noisy_64[128] = {
    0x3fccde69c1a5998e, 0x0,
    0xbfc6bb80e4fb2c4e, 0xbfc0152a8abea2a0,
    0xbfc06f281f601d1f, 0xbfc6342442da1efe,
    0x3f9513eae68e4110, 0xbfd2771fdf771142,
    0x3fcd0162253a93fb, 0xbfae672a7b9db87a,
    0x3fba36fb94a4ced6, 0xbfb9e933c90e3fcc,
    0xbfc8cc63dd5a1360, 0x3febdf7bd815ddaa,
    0x3fb7d4a15e7a8db6, 0xbfd5e265431774f8,
    0xbfc65c9465567801, 0xc0364a6fa5752cfc,
    0xbfd265667fbcb452, 0x3fc287706e88bbfc,
    0xbfc85a0bc5c05088, 0x3fb794ca00997106,
    0x3fad8f27a8008d72, 0x3fbc829dddf12d5c,
    0x3fb13c567e9b8964, 0x3fd66f80d7610185,
    0xbfd6bda7f8db3a86, 0xbfc001e3333b7681,
    0x3fdd0bb9f1ae7fb2, 0xbfc19a3570a2c35b,
    0xbfc6bc48dd178a3f, 0xbfc357ad3a6f31b6,
    0xbfcda7a577807822, 0xbfc1e1a3544dbff0,
    0xbfe249afe4163f20, 0xbfd6d3328b2c76a0,
    0xbfe25706bd357fda, 0x3fc1dc8565fd0ed0,
    0x3fa2d15df8b4ed50, 0xbfcef97adf86b78f,
    0xbfcf172a0ad11549, 0x3fe7d16b06a181e3,
    0x3fa194900a666340, 0xbfc8d0c15be2b0d7,
    0xbfa2767f22cf95de, 0xbfd59c479523e0b5,
    0x3fcc195ece678aac, 0x3fc65f2c197d13f2,
    0xbfbf709376b596e6, 0xbfa74309dd492700,
    0x3f9f3966fed7d29c, 0x3fc1601a0ea5d7e8,
    0x3fdc719afebd52fa, 0xbfce3cb34b965c4a,
    0xbfc9d7b18fc5bc0e, 0xbfe3ff505ba9c00b,
    0xbfcb79c0b4eb8aae, 0x3fc93264a79940c7,
    0x3fd7c36c44c35b5a, 0xbfcc412dde1a7308,
    0x3fbf9b89f98e6261, 0x3fd1d0c7b8d5f1f3,
    0xbf9189c53b86e020, 0xbfcbcf63a32cd2b4,
    0xbfb635a3d0659ba4, 0x0,
    0xbf9189c53b86e030, 0x3fcbcf63a32cd2ba,
    0x3fbf9b89f98e626a, 0xbfd1d0c7b8d5f1f4,
    0x3fd7c36c44c35b57, 0x3fcc412dde1a730b,
    0xbfcb79c0b4eb8aad, 0xbfc93264a79940c8,
    0xbfc9d7b18fc5bc11, 0x3fe3ff505ba9c00a,
    0x3fdc719afebd52f8, 0x3fce3cb34b965c56,
    0x3f9f3966fed7d29a, 0xbfc1601a0ea5d7e8,
    0xbfbf709376b59702, 0x3fa74309dd492700,
    0x3fcc195ece678aaf, 0xbfc65f2c197d13f0,
    0xbfa2767f22cf9606, 0x3fd59c479523e0b6,
    0x3fa194900a666332, 0x3fc8d0c15be2b0da,
    0xbfcf172a0ad11544, 0xbfe7d16b06a181e4,
    0x3fa2d15df8b4ed40, 0x3fcef97adf86b793,
    0xbfe25706bd357fd9, 0xbfc1dc8565fd0ed7,
    0xbfe249afe4163f21, 0x3fd6d3328b2c769f,
    0xbfcda7a577807822, 0x3fc1e1a3544dbff0,
    0xbfc6bc48dd178a41, 0x3fc357ad3a6f31b3,
    0x3fdd0bb9f1ae7fb4, 0x3fc19a3570a2c362,
    0xbfd6bda7f8db3a86, 0x3fc001e3333b767d,
    0x3fb13c567e9b8966, 0xbfd66f80d7610186,
    0x3fad8f27a8008d78, 0xbfbc829dddf12d56,
    0xbfc85a0bc5c0508c, 0xbfb794ca00997110,
    0xbfd265667fbcb452, 0xbfc287706e88bc00,
    0xbfc65c9465567873, 0x40364a6fa5752cfc,
    0x3fb7d4a15e7a8dad, 0x3fd5e265431774f8,
    0xbfc8cc63dd5a1359, 0xbfebdf7bd815ddac,
    0x3fba36fb94a4ced5, 0x3fb9e933c90e3fc8,
    0x3fcd0162253a93fa, 0x3fae672a7b9db884,
    0x3f9513eae68e4100, 0x3fd2771fdf771142,
    0xbfc06f281f601d1e, 0x3fc6342442da1f00,
    0xbfc6bb80e4fb2c50, 0x3fc0152a8abea29e
    };

static const uint64_t ref_cfft_noisy_64[128] = {
    0x3fccde69c1a5998e, 0x0,
    0xbfc6bb80e4fb2c4e, 0xbfc0152a8abea2a0,
    0xbfc06f281f601d1f, 0xbfc6342442da1efe,
    0x3f9513eae68e4110, 0xbfd2771fdf771142,
    0x3fcd0162253a93fb, 0xbfae672a7b9db87a,
    0x3fba36fb94a4ced6, 0xbfb9e933c90e3fcc,
    0xbfc8cc63dd5a1360, 0x3febdf7bd815ddaa,
    0x3fb7d4a15e7a8db6, 0xbfd5e265431774f8,
    0xbfc65c9465567801, 0xc0364a6fa5752cfc,
    0xbfd265667fbcb452, 0x3fc287706e88bbfc,
    0xbfc85a0bc5c05088, 0x3fb794ca00997106,
    0x3fad8f27a8008d72, 0x3fbc829dddf12d5c,
    0x3fb13c567e9b8964, 0x3fd66f80d7610185,
    0xbfd6bda7f8db3a86, 0xbfc001e3333b7681,
    0x3fdd0bb9f1ae7fb2, 0xbfc19a3570a2c35b,
    0xbfc6bc48dd178a3f, 0xbfc357ad3a6f31b6,
    0xbfcda7a577807822, 0xbfc1e1a3544dbff0,
    0xbfe249afe4163f20, 0xbfd6d3328b2c76a0,
    0xbfe25706bd357fda, 0x3fc1dc8565fd0ed0,
    0x3fa2d15df8b4ed50, 0xbfcef97adf86b78f,
    0xbfcf172a0ad11549, 0x3fe7d16b06a181e3,
    0x3fa194900a666340, 0xbfc8d0c15be2b0d7,
    0xbfa2767f22cf95de, 0xbfd59c479523e0b5,
    0x3fcc195ece678aac, 0x3fc65f2c197d13f2,
    0xbfbf709376b596e6, 0xbfa74309dd492700,
    0x3f9f3966fed7d29c, 0x3fc1601a0ea5d7e8,
    0x3fdc719afebd52fa, 0xbfce3cb34b965c4a,
    0xbfc9d7b18fc5bc0e, 0xbfe3ff505ba9c00b,
    0xbfcb79c0b4eb8aae, 0x3fc93264a79940c7,
    0x3fd7c36c44c35b5a, 0xbfcc412dde1a7308,
    0x3fbf9b89f98e6261, 0x3fd1d0c7b8d5f1f3,
    0xbf9189c53b86e020, 0xbfcbcf63a32cd2b4,
    0xbfb635a3d0659ba4, 0x0,
    0xbf9189c53b86e030, 0x3fcbcf63a32cd2ba,
    0x3fbf9b89f98e626a, 0xbfd1d0c7b8d5f1f4,
    0x3fd7c36c44c35b57, 0x3fcc412dde1a730b,
    0xbfcb79c0b4eb8aad, 0xbfc93264a79940c8,
    0xbfc9d7b18fc5bc11, 0x3fe3ff505ba9c00a,
    0x3fdc719afebd52f8, 0x3fce3cb34b965c56,
    0x3f9f3966fed7d29a, 0xbfc1601a0ea5d7e8,
    0xbfbf709376b59702, 0x3fa74309dd492700,
    0x3fcc195ece678aaf, 0xbfc65f2c197d13f0,
    0xbfa2767f22cf9606, 0x3fd59c479523e0b6,
    0x3fa194900a666332, 0x3fc8d0c15be2b0da,
    0xbfcf172a0ad11544, 0xbfe7d16b06a181e4,
    0x3fa2d15df8b4ed40, 0x3fcef97adf86b793,
    0xbfe25706bd357fd9, 0xbfc1dc8565fd0ed7,
    0xbfe249afe4163f21, 0x3fd6d3328b2c769f,
    0xbfcda7a577807822, 0x3fc1e1a3544dbff0,
    0xbfc6bc48dd178a41, 0x3fc357ad3a6f31b3,
    0x3fdd0bb9f1ae7fb4, 0x3fc19a3570a2c362,
    0xbfd6bda7f8db3a86, 0x3fc001e3333b767d,
    0x3fb13c567e9b8966, 0xbfd66f80d7610186,
    0x3fad8f27a8008d78, 0xbfbc829dddf12d56,
    0xbfc85a0bc5c0508c, 0xbfb794ca00997110,
    0xbfd265667fbcb452, 0xbfc287706e88bc00,
    0xbfc65c9465567873, 0x40364a6fa5752cfc,
    0x3fb7d4a15e7a8dad, 0x3fd5e265431774f8,
    0xbfc8cc63dd5a1359, 0xbfebdf7bd815ddac,
    0x3fba36fb94a4ced5, 0x3fb9e933c90e3fc8,
    0x3fcd0162253a93fa, 0x3fae672a7b9db884,
    0x3f9513eae68e4100, 0x3fd2771fdf771142,
    0xbfc06f281f601d1e, 0x3fc6342442da1f00,
    0xbfc6bb80e4fb2c50, 0x3fc0152a8abea29e
    };

static const uint64_t in_cfft_noisy_128[256] = {
    0xbfb7a6d1e151be34, 0x0,
    0x3fdd7e20bcba99f8, 0x0,
    0x3fe56e83948e3796, 0x0,
    0x3fdf8f73d6ec562b, 0x0,
    0x3f8a3a468293e7b1, 0x0,
    0xbfe168955bd5b74c, 0x0,
    0xbfe752f7871cd1fb, 0x0,
    0xbfe0b8671545bcf1, 0x0,
    0xbf865081f5e61cac, 0x0,
    0x3fe0bad7dbe6b151, 0x0,
    0x3fe417ed6410785e, 0x0,
    0x3fe097108d806fb0, 0x0,
    0xbf9ea6d0f714614d, 0x0,
    0xbfdc5059072560c7, 0x0,
    0xbfe57bcdf2d61259, 0x0,
    0xbfe1aa10e7a0e37b, 0x0,
    0xbf96082f251e2f9e, 0x0,
    0x3fe19d2c7400da94, 0x0,
    0x3fe6ac925eae8823, 0x0,
    0x3fdc97d40d4cdd48, 0x0,
    0x3fb0d16c1645c890, 0x0,
    0xbfdb88ff9b043bc9, 0x0,
    0xbfe72491664c67b6, 0x0,
    0xbfe0b577e42f393f, 0x0,
    0x3f85dcf2e5054c51, 0x0,
    0x3fe077b26867bd1f, 0x0,
    0x3fe66dfbc6b53701, 0x0,
    0x3fdd0c54efee10ad, 0x0,
    0x3fa44d0832febdc7, 0x0,
    0xbfde7e27f3ee7224, 0x0,
    0xbfe455dcad9eff5a, 0x0,
    0xbfdff345bfe68c99, 0x0,
    0x3fb14502cb7a613c, 0x0,
    0x3fdb0ae9cb702a72, 0x0,
    0x3fe5ed75f2cac982, 0x0,
    0x3fdbc79d28ad8d16, 0x0,
    0xbf80dcbe055f559a, 0x0,
    0xbfdeae2c9837d06c, 0x0,
    0xbfe2f79794571c5e, 0x0,
    0xbfdf8d79061697ce, 0x0,
    0x3fa66fc4bd54b916, 0x0,
    0x3fe00980a637e4fe, 0x0,
    0x3fe438c583b45ba1, 0x0,
    0x3fddf4fcbf2fe95c, 0x0,
    0x3f7f3f15db386582, 0x0,
    0xbfe13d55cbbc849a, 0x0,
    0xbfe4189e4e16315a, 0x0,
    0xbfdc801c9514b4d8, 0x0,
    0xbfa04f01a7fe148b, 0x0,
    0x3fe18cc256c47c64, 0x0,
    0x3fe6f5521e3fef7f, 0x0,
    0x3fe0ca6d2b9f107a, 0x0,
    0xbf8be89f184436cb, 0x0,
    0xbfe1977555a4ef8c, 0x0,
    0xbfe49f9fe4897b0e, 0x0,
    0xbfe04a38dc79a5a4, 0x0,
    0x3fa28bd24a3037aa, 0x0,
    0x3fda23bf2b13c96c, 0x0,
    0x3fe8113ed31d40a2, 0x0,
    0x3fdc1ed8c03246c2, 0x0,
    0xbfa38cd9e859c2eb, 0x0,
    0xbfdaf500114cb352, 0x0,
    0xbfe9396e13a7fd38, 0x0,
    0xbfe258439bb202ed, 0x0,
    0xbfb398e4e2b48c2b, 0x0,
    0x3fe176074e05ba1a, 0x0,
    0x3fe6d82e18a1b70c, 0x0,
    0x3fdd73b814534ad2, 0x0,
    0x3f6b623d26c1a581, 0x0,
    0xbfdeaf5139392593, 0x0,
    0xbfea1ed71fa794bb, 0x0,
    0xbfddc20609145e23, 0x0,
    0xbf87c5672665d219, 0x0,
    0x3fddf33456250fe3, 0x0,
    0x3fe54185e78a629c, 0x0,
    0x3fdf72193875994a, 0x0,
    0xbf90bcbff0a5fe83, 0x0,
    0xbfddb3575e930143, 0x0,
    0xbfe893add732ff5e, 0x0,
    0xbfe2b90423c7b1c8, 0x0,
    0x3fb65833981832e0, 0x0,
    0x3fdc11dbad0e9c90, 0x0,
    0x3fe9c5b0ea075a47, 0x0,
    0x3fde1ecca6a1afe2, 0x0,
    0xbf9e7ca7d860c2e3, 0x0,
    0xbfe003b7d62d7450, 0x0,
    0xbfe3d4860aa6502f, 0x0,
    0xbfe101b6a9c7fc37, 0x0,
    0x3faa5c8262d04773, 0x0,
    0x3fe2092bb5689178, 0x0,
    0x3fe80b8d52de64b7, 0x0,
    0x3fe0d8c0ec395053, 0x0,
    0xbf51c98df4875378, 0x0,
    0xbfe03607be9cf79d, 0x0,
    0xbfe771837e281819, 0x0,
    0xbfdf102183dca452, 0x0,
    0xbfa432ee1e64b874, 0x0,
    0x3fdc302596aceb04, 0x0,
    0x3fe5a0dfb0835bd4, 0x0,
    0x3fe1e19977d23895, 0x0,
    0x3f9d0d5b00b8f4e4, 0x0,
    0xbfe0ec62b9dcd312, 0x0,
    0xbfe552e26ac88e7a, 0x0,
    0xbfe130c888ceacc4, 0x0,
    0xbfa50fe04a6e7e93, 0x0,
    0x3fe02e0d09a236a1, 0x0,
    0x3fe70cb27ad8c1f1, 0x0,
    0x3fdef3f2392a2573, 0x0,
    0x3fb104530e6abd69, 0x0,
    0xbfda9d7dc9604ae2, 0x0,
    0xbfe5b5a6938e94e9, 0x0,
    0xbfe0e9281756ca3a, 0x0,
    0x3fa7ce6b3ac26d49, 0x0,
    0x3fe1047116792f2d, 0x0,
    0x3fe90551a7318f6a, 0x0,
    0x3fe1794a2bf9bc3e, 0x0,
    0xbf9fa0e536a6a2bd, 0x0,
    0xbfde3a106edefdd7, 0x0,
    0xbfe722c07ce7bc6a, 0x0,
    0xbfdd860ad301f750, 0x0,
    0xbf7a76adb309305b, 0x0,
    0x3fdb9d1a64aa99c3, 0x0,
    0x3fe5ccf008a8d934, 0x0,
    0x3fe0266e1519950a, 0x0,
    0x3fae2f9d9b205d3f, 0x0,
    0xbfdfad3c362e4cd9, 0x0,
    0xbfe68ddffa47a57f, 0x0,
    0xbfe1503bdccb2493, 0x0
    };

static const uint64_t in_cifft_noisy_128[256] = {
    0xbf9d349d16447120, 0x0,
    0x3fc9a22026eaf7b9, 0x3fb07241ee7015c4,
    0xbfeaf9239e29e73f, 0x3fd6bf8ea5b5fdce,
    0xbfa8bff8cf97958c, 0x3fc2e9d866bc2508,
    0xbfe971c5ba02edfa, 0x3fddbf276ca2ee2e,
    0xbfd67c69d5a3baae, 0xbfc6ed672bede970,
    0x3fbdef2c1e3600e8, 0xbfda20b7e2d83b79,
    0x3fc6be0add21b296, 0x3fd77cc8ac409fe0,
    0xbfb1057c47852a1c, 0xbfb3ebc634d9e0ec,
    0x3fb7015c269c4887, 0x3fc053d941d128f2,
    0x3fc1929dfbcdf077, 0x3fc7efae2f3b7ded,
    0xbfd65c30b716bcfc, 0x3fc8725134b9a010,
    0xbfe16d0eaf86064c, 0x3fb7cd23e199919e,
    0x3fe0f58b0340a0cf, 0x3fc327706c81e934,
    0x3fa2925febe22377, 0xbfd80c5d16654bec,
    0xbff1656a89d53614, 0x3fd782a31eb7f27e,
    0xbfdbff04b89db4ca, 0xc04666f601a95e0f,
    0x3fcf22d5b7fa5f42, 0xbfc294af1c1489ad,
    0xbfdfb04fd04258d3, 0xbfd71318558ba59f,
    0x3fc64fdc263a0871, 0x3fd2cc9bf53b521a,
    0xbfb9f88733d7581d, 0x3fcc7d9a7e5a7320,
    0xbfd38f7e30a8f0a4, 0xbfc3faea5737f3fc,
    0xbfe1b4ffcf30bc50, 0xbfdacf6138a28204,
    0xbfcf730689a29dd4, 0x3fc4268240d958d4,
    0xbfe12597e4471ca6, 0xbfe0f40eef24fdf1,
    0x3fafe3527eeb1fd8, 0x3fbf30a5d369f164,
    0xbfc75fe780ee60cc, 0xbfe45fcfa3829eed,
    0x3fdba0a8989a6fb4, 0x3fc153bf75f6ec79,
    0x3fbd301bf9563b4e, 0x3fe05598651b8a10,
    0xbfd2e39eecd7138c, 0x3fd0f787c3e7dbcb,
    0x3fe11a029511f5de, 0x3fd03db67718e679,
    0x3fd3b33d33f5cc7d, 0x3fb40192c5ebdb39,
    0xbfa4893ddf7efe10, 0xbfe14f1f1190a708,
    0xbfb8ee0d31a01dee, 0xbf9fe0903a9a2bc4,
    0xbfd6016d999c032f, 0xbfd4dabc85035a3c,
    0xbfa7182f7bfd94bc, 0x3feb43c57c651b8c,
    0x3fc2eb33253ba248, 0xbf960520aee52fa0,
    0xbfb8b137a1d9a6e0, 0x3fe423c34b0283ec,
    0xbfaba6fd6649d21c, 0xbfe8e37be1079cd4,
    0x3fbd86aba43addb0, 0xbfd822da12bd4534,
    0x3fb42fd830cc5eb8, 0x3fa5911bbc61e618,
    0xbfd483ee60fad8f2, 0x3fdc2cf1bd594855,
    0xbfd47317fd07312b, 0xbfdf391ce547fa6e,
    0xbfd20f679fae7055, 0x3fe12e47e6afb6b4,
    0x3fbdf41b09d37104, 0xbfa7ba3c74b0655a,
    0x3fe230f3f25c95ca, 0xbfe78ce91f5db423,
    0xbfcdf09a679cb51b, 0x3fe1c58edf791d3c,
    0x3fb39699852bd0da, 0xbfe134867bc5066e,
    0x3fcd8e1f59c36e08, 0x3f8f006353fa5000,
    0xbfdcb484ff322f43, 0xbfb345171e144fc6,
    0x3fc0a3013eef7da6, 0x3fc829f54e711512,
    0xbfdcda3882d6c48b, 0xbfc73a161f91ca70,
    0xbfe25179c97f6f85, 0x3fd3c3a052784fda,
    0xbfc68b8b950f691c, 0xbfe2d94b314da254,
    0xbfe323bf4cbbbd4a, 0x3fda83c1d433148e,
    0x3fd4081ed8d63d8a, 0xbfc975b4b511a738,
    0xbf7cd223ca3ed780, 0x3fd0663e83e5cad4,
    0x3fca2a29492c463c, 0xbfb4273ab25e6cac,
    0x3fca0e402671a575, 0xbfe3e169137ccfb5,
    0x3fd7ee69210861ee, 0x3fee1ffd0e2d7d00,
    0xbfc167f0c087a00c, 0xbfde7c40c4bab491,
    0x3fda72f8752f8850, 0xbfd2e30e1e1c065c,
    0xbfe5f5ad326eb1cb, 0xbfc018bd93bd3081,
    0xbfc82d9a66d70858, 0x3fc48e5d4970eb8c,
    0x3fe3aa062eac84c7, 0x0,
    0xbfc82d9a66d70853, 0xbfc48e5d4970eb8e,
    0xbfe5f5ad326eb1cd, 0x3fc018bd93bd3085,
    0x3fda72f8752f8850, 0x3fd2e30e1e1c065c,
    0xbfc167f0c087a00a, 0x3fde7c40c4bab490,
    0x3fd7ee69210861f4, 0xbfee1ffd0e2d7d00,
    0x3fca0e402671a570, 0x3fe3e169137ccfb6,
    0x3fca2a29492c463a, 0x3fb4273ab25e6cbe,
    0xbf7cd223ca3ed760, 0xbfd0663e83e5cad4,
    0x3fd4081ed8d63d89, 0x3fc975b4b511a73e,
    0xbfe323bf4cbbbd49, 0xbfda83c1d4331490,
    0xbfc68b8b950f691c, 0x3fe2d94b314da251,
    0xbfe25179c97f6f84, 0xbfd3c3a052784fdc,
    0xbfdcda3882d6c492, 0x3fc73a161f91ca70,
    0x3fc0a3013eef7da2, 0xbfc829f54e71150f,
    0xbfdcb484ff322f44, 0x3fb345171e144fba,
    0x3fcd8e1f59c36deb, 0xbf8f006353fa5000,
    0x3fb39699852bd0d5, 0x3fe134867bc5066e,
    0xbfcdf09a679cb516, 0xbfe1c58edf791d3b,
    0x3fe230f3f25c95ca, 0x3fe78ce91f5db423,
    0x3fbdf41b09d3710d, 0x3fa7ba3c74b06560,
    0xbfd20f679fae7056, 0xbfe12e47e6afb6b4,
    0xbfd47317fd073130, 0x3fdf391ce547fa6c,
    0xbfd483ee60fad8ec, 0xbfdc2cf1bd594858,
    0x3fb42fd830cc5eb8, 0xbfa5911bbc61e610,
    0x3fbd86aba43addb2, 0x3fd822da12bd4533,
    0xbfaba6fd6649d238, 0x3fe8e37be1079cd5,
    0xbfb8b137a1d9a6da, 0xbfe423c34b0283ee,
    0x3fc2eb33253ba249, 0x3f960520aee52fc0,
    0xbfa7182f7bfd9494, 0xbfeb43c57c651b8a,
    0xbfd6016d999c0331, 0x3fd4dabc85035a3b,
    0xbfb8ee0d31a01dec, 0x3f9fe0903a9a2bec,
    0xbfa4893ddf7efe10, 0x3fe14f1f1190a708,
    0x3fd3b33d33f5cc7c, 0xbfb40192c5ebdb27,
    0x3fe11a029511f5de, 0xbfd03db67718e678,
    0xbfd2e39eecd7138e, 0xbfd0f787c3e7dbd0,
    0x3fbd301bf9563b4f, 0xbfe05598651b8a10,
    0x3fdba0a8989a6fb4, 0xbfc153bf75f6ec73,
    0xbfc75fe780ee60cd, 0x3fe45fcfa3829eec,
    0x3fafe3527eeb1fd4, 0xbfbf30a5d369f166,
    0xbfe12597e4471ca7, 0x3fe0f40eef24fdf0,
    0xbfcf730689a29dd7, 0xbfc4268240d958d6,
    0xbfe1b4ffcf30bc51, 0x3fdacf6138a28204,
    0xbfd38f7e30a8f0a5, 0x3fc3faea5737f3fe,
    0xbfb9f88733d75824, 0xbfcc7d9a7e5a7320,
    0x3fc64fdc263a0876, 0xbfd2cc9bf53b521a,
    0xbfdfb04fd04258d2, 0x3fd71318558ba59c,
    0x3fcf22d5b7fa5f3b, 0x3fc294af1c1489ae,
    0xbfdbff04b89db53c, 0x404666f601a95e0f,
    0xbff1656a89d53613, 0xbfd782a31eb7f286,
    0x3fa2925febe2236a, 0x3fd80c5d16654bed,
    0x3fe0f58b0340a0d0, 0xbfc327706c81e936,
    0xbfe16d0eaf86064d, 0xbfb7cd23e199919e,
    0xbfd65c30b716bcf8, 0xbfc8725134b9a016,
    0x3fc1929dfbcdf077, 0xbfc7efae2f3b7deb,
    0x3fb7015c269c488d, 0xbfc053d941d128f4,
    0xbfb1057c47852a20, 0x3fb3ebc634d9e0ea,
    0x3fc6be0add21b298, 0xbfd77cc8ac409fdd,
    0x3fbdef2c1e3600da, 0x3fda20b7e2d83b7a,
    0xbfd67c69d5a3baaa, 0x3fc6ed672bede976,
    0xbfe971c5ba02edf9, 0xbfddbf276ca2ee2f,
    0xbfa8bff8cf979574, 0xbfc2e9d866bc2503,
    0xbfeaf9239e29e73d, 0xbfd6bf8ea5b5fdd4,
    0x3fc9a22026eaf7c0, 0xbfb07241ee7015bf
    };

static const uint64_t ref_cfft_noisy_128[256] = {
    0xbf9d349d16447120, 0x0,
    0x3fc9a22026eaf7b9, 0x3fb07241ee7015c4,
    0xbfeaf9239e29e73f, 0x3fd6bf8ea5b5fdce,
    0xbfa8bff8cf97958c, 0x3fc2e9d866bc2508,
    0xbfe971c5ba02edfa, 0x3fddbf276ca2ee2e,
    0xbfd67c69d5a3baae, 0xbfc6ed672bede970,
    0x3fbdef2c1e3600e8, 0xbfda20b7e2d83b79,
    0x3fc6be0add21b296, 0x3fd77cc8ac409fe0,
    0xbfb1057c47852a1c, 0xbfb3ebc634d9e0ec,
    0x3fb7015c269c4887, 0x3fc053d941d128f2,
    0x3fc1929dfbcdf077, 0x3fc7efae2f3b7ded,
    0xbfd65c30b716bcfc, 0x3fc8725134b9a010,
    0xbfe16d0eaf86064c, 0x3fb7cd23e199919e,
    0x3fe0f58b0340a0cf, 0x3fc327706c81e934,
    0x3fa2925febe22377, 0xbfd80c5d16654bec,
    0xbff1656a89d53614, 0x3fd782a31eb7f27e,
    0xbfdbff04b89db4ca, 0xc04666f601a95e0f,
    0x3fcf22d5b7fa5f42, 0xbfc294af1c1489ad,
    0xbfdfb04fd04258d3, 0xbfd71318558ba59f,
    0x3fc64fdc263a0871, 0x3fd2cc9bf53b521a,
    0xbfb9f88733d7581d, 0x3fcc7d9a7e5a7320,
    0xbfd38f7e30a8f0a4, 0xbfc3faea5737f3fc,
    0xbfe1b4ffcf30bc50, 0xbfdacf6138a28204,
    0xbfcf730689a29dd4, 0x3fc4268240d958d4,
    0xbfe12597e4471ca6, 0xbfe0f40eef24fdf1,
    0x3fafe3527eeb1fd8, 0x3fbf30a5d369f164,
    0xbfc75fe780ee60cc, 0xbfe45fcfa3829eed,
    0x3fdba0a8989a6fb4, 0x3fc153bf75f6ec79,
    0x3fbd301bf9563b4e, 0x3fe05598651b8a10,
    0xbfd2e39eecd7138c, 0x3fd0f787c3e7dbcb,
    0x3fe11a029511f5de, 0x3fd03db67718e679,
    0x3fd3b33d33f5cc7d, 0x3fb40192c5ebdb39,
    0xbfa4893ddf7efe10, 0xbfe14f1f1190a708,
    0xbfb8ee0d31a01dee, 0xbf9fe0903a9a2bc4,
    0xbfd6016d999c032f, 0xbfd4dabc85035a3c,
    0xbfa7182f7bfd94bc, 0x3feb43c57c651b8c,
    0x3fc2eb33253ba248, 0xbf960520aee52fa0,
    0xbfb8b137a1d9a6e0, 0x3fe423c34b0283ec,
    0xbfaba6fd6649d21c, 0xbfe8e37be1079cd4,
    0x3fbd86aba43addb0, 0xbfd822da12bd4534,
    0x3fb42fd830cc5eb8, 0x3fa5911bbc61e618,
    0xbfd483ee60fad8f2, 0x3fdc2cf1bd594855,
    0xbfd47317fd07312b, 0xbfdf391ce547fa6e,
    0xbfd20f679fae7055, 0x3fe12e47e6afb6b4,
    0x3fbdf41b09d37104, 0xbfa7ba3c74b0655a,
    0x3fe230f3f25c95ca, 0xbfe78ce91f5db423,
    0xbfcdf09a679cb51b, 0x3fe1c58edf791d3c,
    0x3fb39699852bd0da, 0xbfe134867bc5066e,
    0x3fcd8e1f59c36e08, 0x3f8f006353fa5000,
    0xbfdcb484ff322f43, 0xbfb345171e144fc6,
    0x3fc0a3013eef7da6, 0x3fc829f54e711512,
    0xbfdcda3882d6c48b, 0xbfc73a161f91ca70,
    0xbfe25179c97f6f85, 0x3fd3c3a052784fda,
    0xbfc68b8b950f691c, 0xbfe2d94b314da254,
    0xbfe323bf4cbbbd4a, 0x3fda83c1d433148e,
    0x3fd4081ed8d63d8a, 0xbfc975b4b511a738,
    0xbf7cd223ca3ed780, 0x3fd0663e83e5cad4,
    0x3fca2a29492c463c, 0xbfb4273ab25e6cac,
    0x3fca0e402671a575, 0xbfe3e169137ccfb5,
    0x3fd7ee69210861ee, 0x3fee1ffd0e2d7d00,
    0xbfc167f0c087a00c, 0xbfde7c40c4bab491,
    0x3fda72f8752f8850, 0xbfd2e30e1e1c065c,
    0xbfe5f5ad326eb1cb, 0xbfc018bd93bd3081,
    0xbfc82d9a66d70858, 0x3fc48e5d4970eb8c,
    0x3fe3aa062eac84c7, 0x0,
    0xbfc82d9a66d70853, 0xbfc48e5d4970eb8e,
    0xbfe5f5ad326eb1cd, 0x3fc018bd93bd3085,
    0x3fda72f8752f8850, 0x3fd2e30e1e1c065c,
    0xbfc167f0c087a00a, 0x3fde7c40c4bab490,
    0x3fd7ee69210861f4, 0xbfee1ffd0e2d7d00,
    0x3fca0e402671a570, 0x3fe3e169137ccfb6,
    0x3fca2a29492c463a, 0x3fb4273ab25e6cbe,
    0xbf7cd223ca3ed760, 0xbfd0663e83e5cad4,
    0x3fd4081ed8d63d89, 0x3fc975b4b511a73e,
    0xbfe323bf4cbbbd49, 0xbfda83c1d4331490,
    0xbfc68b8b950f691c, 0x3fe2d94b314da251,
    0xbfe25179c97f6f84, 0xbfd3c3a052784fdc,
    0xbfdcda3882d6c492, 0x3fc73a161f91ca70,
    0x3fc0a3013eef7da2, 0xbfc829f54e71150f,
    0xbfdcb484ff322f44, 0x3fb345171e144fba,
    0x3fcd8e1f59c36deb, 0xbf8f006353fa5000,
    0x3fb39699852bd0d5, 0x3fe134867bc5066e,
    0xbfcdf09a679cb516, 0xbfe1c58edf791d3b,
    0x3fe230f3f25c95ca, 0x3fe78ce91f5db423,
    0x3fbdf41b09d3710d, 0x3fa7ba3c74b06560,
    0xbfd20f679fae7056, 0xbfe12e47e6afb6b4,
    0xbfd47317fd073130, 0x3fdf391ce547fa6c,
    0xbfd483ee60fad8ec, 0xbfdc2cf1bd594858,
    0x3fb42fd830cc5eb8, 0xbfa5911bbc61e610,
    0x3fbd86aba43addb2, 0x3fd822da12bd4533,
    0xbfaba6fd6649d238, 0x3fe8e37be1079cd5,
    0xbfb8b137a1d9a6da, 0xbfe423c34b0283ee,
    0x3fc2eb33253ba249, 0x3f960520aee52fc0,
    0xbfa7182f7bfd9494, 0xbfeb43c57c651b8a,
    0xbfd6016d999c0331, 0x3fd4dabc85035a3b,
    0xbfb8ee0d31a01dec, 0x3f9fe0903a9a2bec,
    0xbfa4893ddf7efe10, 0x3fe14f1f1190a708,
    0x3fd3b33d33f5cc7c, 0xbfb40192c5ebdb27,
    0x3fe11a029511f5de, 0xbfd03db67718e678,
    0xbfd2e39eecd7138e, 0xbfd0f787c3e7dbd0,
    0x3fbd301bf9563b4f, 0xbfe05598651b8a10,
    0x3fdba0a8989a6fb4, 0xbfc153bf75f6ec73,
    0xbfc75fe780ee60cd, 0x3fe45fcfa3829eec,
    0x3fafe3527eeb1fd4, 0xbfbf30a5d369f166,
    0xbfe12597e4471ca7, 0x3fe0f40eef24fdf0,
    0xbfcf730689a29dd7, 0xbfc4268240d958d6,
    0xbfe1b4ffcf30bc51, 0x3fdacf6138a28204,
    0xbfd38f7e30a8f0a5, 0x3fc3faea5737f3fe,
    0xbfb9f88733d75824, 0xbfcc7d9a7e5a7320,
    0x3fc64fdc263a0876, 0xbfd2cc9bf53b521a,
    0xbfdfb04fd04258d2, 0x3fd71318558ba59c,
    0x3fcf22d5b7fa5f3b, 0x3fc294af1c1489ae,
    0xbfdbff04b89db53c, 0x404666f601a95e0f,
    0xbff1656a89d53613, 0xbfd782a31eb7f286,
    0x3fa2925febe2236a, 0x3fd80c5d16654bed,
    0x3fe0f58b0340a0d0, 0xbfc327706c81e936,
    0xbfe16d0eaf86064d, 0xbfb7cd23e199919e,
    0xbfd65c30b716bcf8, 0xbfc8725134b9a016,
    0x3fc1929dfbcdf077, 0xbfc7efae2f3b7deb,
    0x3fb7015c269c488d, 0xbfc053d941d128f4,
    0xbfb1057c47852a20, 0x3fb3ebc634d9e0ea,
    0x3fc6be0add21b298, 0xbfd77cc8ac409fdd,
    0x3fbdef2c1e3600da, 0x3fda20b7e2d83b7a,
    0xbfd67c69d5a3baaa, 0x3fc6ed672bede976,
    0xbfe971c5ba02edf9, 0xbfddbf276ca2ee2f,
    0xbfa8bff8cf979574, 0xbfc2e9d866bc2503,
    0xbfeaf9239e29e73d, 0xbfd6bf8ea5b5fdd4,
    0x3fc9a22026eaf7c0, 0xbfb07241ee7015bf
    };

static const uint64_t in_cfft_noisy_256[512] = {
    0x3fb20c88d3a95653, 0x0,
    0x3fd6499d0369b35e, 0x0,
    0x3fe56769a8876e32, 0x0,
    0x3fdebee175eecb43, 0x0,
    0xbfa7d3b943d6ea7e, 0x0,
    0xbfe1c8e92a93017c, 0x0,
    0xbfe7988c23bee6e0, 0x0,
    0xbfdc2ed7d901528b, 0x0,
    0x3f8e012b553f0cd2, 0x0,
    0x3fdaf22d5bb38d8b, 0x0,
    0x3fe7cb4065392837, 0x0,
    0x3fdaf14720f13766, 0x0,
    0xbfa2b611fa2e9a3a, 0x0,
    0xbfdb26f60e52fdb7, 0x0,
    0xbfe890a70d45222d, 0x0,
    0xbfdde665a1c574b3, 0x0,
    0x3fab4e4a75675026, 0x0,
    0x3fde3c5b5d43e750, 0x0,
    0x3fe406cf587f919a, 0x0,
    0x3fd9de19d334ae10, 0x0,
    0x3f95d9938f794fb3, 0x0,
    0xbfe03ec7c6ccfcf9, 0x0,
    0xbfe64651de4128ba, 0x0,
    0xbfde49dda97fd9b6, 0x0,
    0x3fa876968e848986, 0x0,
    0x3fde8dfba87aeb2a, 0x0,
    0x3fe4e8e4387b5041, 0x0,
    0x3fde72508d545b96, 0x0,
    0xbf9363e8bf4ed215, 0x0,
    0xbfdcb21f84f6b54e, 0x0,
    0xbfe60f33d5aa5ee7, 0x0,
    0xbfe07e8563589fa6, 0x0,
    0xbf96e5dd3fb2e8a2, 0x0,
    0x3fde5e152ce149d7, 0x0,
    0x3fe5e61a94644b3c, 0x0,
    0x3fde14b43f3799ed, 0x0,
    0x3f9b13a9eb3080c2, 0x0,
    0xbfe14467a1a95565, 0x0,
    0xbfe57ad7dc235145, 0x0,
    0xbfdc6d474a92909a, 0x0,
    0x3f9e535069423d00, 0x0,
    0x3fdd3328eab5c48a, 0x0,
    0x3fe56c3568537a0d, 0x0,
    0x3fdb66e43758e924, 0x0,
    0xbf96db00bccf805f, 0x0,
    0xbfe1b4e1fe74c8d6, 0x0,
    0xbfe6579f718e58c7, 0x0,
    0xbfdf0dcd6183f65b, 0x0,
    0xbf9dc418ae0a26f6, 0x0,
    0x3fdf2be3e5789689, 0x0,
    0x3fe3ecdc3e0244c2, 0x0,
    0x3fe0d74a7b9bd279, 0x0,
    0xbf96405bbf30bbd0, 0x0,
    0xbfdfdeefa82fd3d1, 0x0,
    0xbfe629fe5bca6b4d, 0x0,
    0xbfddcb0eaf3cb3c0, 0x0,
    0x3fb0b61088b2beee, 0x0,
    0x3fd95b4d5fc95dc0, 0x0,
    0x3fe635cc0d46ef89, 0x0,
    0x3fdd8a500cf56090, 0x0,
    0xbfa9de18bce9012a, 0x0,
    0xbfdbdbe103d7bbb0, 0x0,
    0xbfe2912ce1047c41, 0x0,
    0xbfdfc3f1c496ccf5, 0x0,
    0xbf67290958800463, 0x0,
    0x3fdc2fae7cc00448, 0x0,
    0x3fe698754c74209a, 0x0,
    0x3fe0a6997122545d, 0x0,
    0x3fa7809987c94ffd, 0x0,
    0xbfe1548b48a16503, 0x0,
    0xbfe56c04ba9c3532, 0x0,
    0xbfdac54724fdb925, 0x0,
    0xbfa1a079c9c45d5c, 0x0,
    0x3fdd422b5e442a52, 0x0,
    0x3fe6439c94846f76, 0x0,
    0x3fe0948da48dd4ea, 0x0,
    0x3fadddc2efc76d49, 0x0,
    0xbfdf86b2a4e85ae8, 0x0,
    0xbfe66bb031e3bed9, 0x0,
    0xbfde845cf6c57f6e, 0x0,
    0x3faa94b2c3aec756, 0x0,
    0x3fe0c005a598175f, 0x0,
    0x3fe8f86550f38269, 0x0,
    0x3fdbf415fb0f93f0, 0x0,
    0xbf91e33800791891, 0x0,
    0xbfde10532a17c3fa, 0x0,
    0xbfe5fef8bd828d98, 0x0,
    0xbfdfc96d91e86ad4, 0x0,
    0xbfacc889c05ce48f, 0x0,
    0x3fe1e86aacc385f2, 0x0,
    0x3fe74144334d9116, 0x0,
    0x3fe2a391d35a7581, 0x0,
    0x3fb728e9a65f71c9, 0x0,
    0xbfe1b5ddd5e7a7c4, 0x0,
    0xbfe76b8293f9f4b5, 0x0,
    0xbfda853ca8200902, 0x0,
    0x3fad813cf0fc577b, 0x0,
    0x3fe1a59b5b8e22a3, 0x0,
    0x3fe1c051e3d5a1b2, 0x0,
    0x3fe0b1f01c2ad693, 0x0,
    0xbfb2c7b05f5da949, 0x0,
    0xbfe18c1ecd540f04, 0x0,
    0xbfe8ab514e04945b, 0x0,
    0xbfdd9b99184b82b5, 0x0,
    0x3fa65dee589a5430, 0x0,
    0x3fdd64936ca9cd19, 0x0,
    0x3fe80d77b3191ea1, 0x0,
    0x3fe0acecebcb2c55, 0x0,
    0x3f6c317d11eab6af, 0x0,
    0xbfde08798dfff1b9, 0x0,
    0xbfe62f81c40c6fd4, 0x0,
    0xbfe0be3efb6cacc9, 0x0,
    0xbfae80da9f3c4fdc, 0x0,
    0x3fdb5a8d662a0f97, 0x0,
    0x3fe5004116468638, 0x0,
    0x3fe2fa4a9322239f, 0x0,
    0x3fa1e034ef9d7e54, 0x0,
    0xbfdeb57ce4003193, 0x0,
    0xbfe739b74bda979e, 0x0,
    0xbfddcb3aa6028b21, 0x0,
    0xbf79b40fbc2ad835, 0x0,
    0x3fe0d9e436bd9cda, 0x0,
    0x3fe62cfa45d1c251, 0x0,
    0x3fdf4647609802dc, 0x0,
    0xbf84b660bdd838ee, 0x0,
    0xbfe13a6f61ac6ba3, 0x0,
    0xbfe784fbf16c08d0, 0x0,
    0xbfe1106cef2cb3bf, 0x0,
    0xbf99550e2256c7a3, 0x0,
    0x3fdbe2ca3c3be5fd, 0x0,
    0x3fe4cbdc34754093, 0x0,
    0x3fe00c48f5feda6a, 0x0,
    0xbfb182bc84aacf56, 0x0,
    0xbfe1484eb7b021fb, 0x0,
    0xbfe3fb90e29b76ed, 0x0,
    0xbfe07c9cda010d0f, 0x0,
    0xbfaa2d7f2605d4b1, 0x0,
    0x3fe0c7fef19d57f3, 0x0,
    0x3fe53615f260e516, 0x0,
    0x3fdc5ae3c734c0ca, 0x0,
    0xbf87963bad604932, 0x0,
    0xbfdf01c504d7faa8, 0x0,
    0xbfe74540e3c63c21, 0x0,
    0xbfe245287bef73c2, 0x0,
    0x3f66684f9e6f9018, 0x0,
    0x3fda4cce135d65a8, 0x0,
    0x3fe829bc88a5b669, 0x0,
    0x3fdd595fdfbeebfa, 0x0,
    0xbfb6379fd6710d7a, 0x0,
    0xbfda483fce500957, 0x0,
    0xbfe721fd261a7949, 0x0,
    0xbfdec26ccfa3e151, 0x0,
    0xbf948fbe40c8ce3f, 0x0,
    0x3fe013b6eee4036b, 0x0,
    0x3fe5d79f91a432e2, 0x0,
    0x3fdf66b35d36c181, 0x0,
    0xbfa91fbcc2126f6b, 0x0,
    0xbfe1c0aa63edc2f4, 0x0,
    0xbfe99ba9f8f52a27, 0x0,
    0xbfe0f1bbf93242fa, 0x0,
    0xbfb5fb0801e2df23, 0x0,
    0x3fdd840babaa20ee, 0x0,
    0x3fe6cb55e65a8bf5, 0x0,
    0x3fdebf70e4c3187f, 0x0,
    0xbfa771107659316c, 0x0,
    0xbfe067daa95d852f, 0x0,
    0xbfe611fd570db505, 0x0,
    0xbfe224901c76326e, 0x0,
    0x3fac6bbc17a91048, 0x0,
    0x3fe044e2921c46f5, 0x0,
    0x3fe5f594d6aeba56, 0x0,
    0x3fdebdc1b60f4985, 0x0,
    0xbf79475fdc501987, 0x0,
    0xbfddad7545d1d7ff, 0x0,
    0xbfe58e926895298d, 0x0,
    0xbfd6fdfa5c932d32, 0x0,
    0x3f9d86889d6f9eed, 0x0,
    0x3fe0f2c9db34bcb0, 0x0,
    0x3fe6e85d56cb9075, 0x0,
    0x3fde09964764de43, 0x0,
    0xbfad673b256f6552, 0x0,
    0xbfe1cc9f79038224, 0x0,
    0xbfe81aa3d25ca635, 0x0,
    0xbfe1dfaa37a3acc0, 0x0,
    0xbfa6eb60e8dc5115, 0x0,
    0x3fe17148d961b73d, 0x0,
    0x3fe63bdc6f5fbccc, 0x0,
    0x3fdc4708b1c69730, 0x0,
    0x3fa19ad5997cb251, 0x0,
    0xbfded84f80238870, 0x0,
    0xbfe781ecf3a9cef6, 0x0,
    0xbfdccfa59dc36e7a, 0x0,
    0xbf9c4a20d477fb29, 0x0,
    0x3fe00a0f1bb1b5b0, 0x0,
    0x3fe6c5e964a3f584, 0x0,
    0x3fdee6e9027ee6e0, 0x0,
    0x3fa6ff73b2b4c1dd, 0x0,
    0xbfe2570145e76f42, 0x0,
    0xbfe563d4651b51b3, 0x0,
    0xbfdee3900adc8842, 0x0,
    0xbf9108aa5726d339, 0x0,
    0x3fe18812edb15ef0, 0x0,
    0x3fe4eb3830e633c6, 0x0,
    0x3fdcc454f1b61fc4, 0x0,
    0x3f8f7855f074d476, 0x0,
    0xbfdb1109f11ca19f, 0x0,
    0xbfe80c1f43d665d7, 0x0,
    0xbfe032fca0f15715, 0x0,
    0x3fb3a497db255bd4, 0x0,
    0x3fe0a1a624d76858, 0x0,
    0x3fe4a30126f8fd35, 0x0,
    0x3fdebd4c3380e788, 0x0,
    0x3fb0122609a843a7, 0x0,
    0xbfe21dea583f1efb, 0x0,
    0xbfe55e3dcd665753, 0x0,
    0xbfe0156ec2e61296, 0x0,
    0x3fa87188b79d0966, 0x0,
    0x3fde78e4ee6ab9cc, 0x0,
    0x3fe93bd776fd933d, 0x0,
    0x3fe17035d3affb64, 0x0,
    0xbf4e526c397d220d, 0x0,
    0xbfe21a1867acecd0, 0x0,
    0xbfe5a16e8433a1b2, 0x0,
    0xbfe1aea85ef98c7f, 0x0,
    0x3f9fff77f9d0ac4a, 0x0,
    0x3fddead82717794a, 0x0,
    0x3fe544470a5f0950, 0x0,
    0x3fdef3572a39d8c5, 0x0,
    0xbf6b79f15765d21c, 0x0,
    0xbfdf61e84ed3d168, 0x0,
    0xbfe61c9e25aadd6e, 0x0,
    0xbfdbee4747b4ed30, 0x0,
    0x3f984fe25124c140, 0x0,
    0x3fdb2b1a3029723c, 0x0,
    0x3fe69edd6073a601, 0x0,
    0x3fdd356df6fe21be, 0x0,
    0x3fb23d08c94af649, 0x0,
    0xbfe058e147d72bfb, 0x0,
    0xbfe64da073e41169, 0x0,
    0xbfe34b8a491789b9, 0x0,
    0xbfb052ffdc9cb2c5, 0x0,
    0x3fdddf371a02af4e, 0x0,
    0x3fe96d27b1b3115c, 0x0,
    0x3fdf1bd57c094678, 0x0,
    0x3fb31516a7d6a57b, 0x0,
    0xbfdf9972f2c56778, 0x0,
    0xbfe67a0601b54ae4, 0x0,
    0xbfde16090eb3f8f3, 0x0,
    0xbfab1d25cc66200d, 0x0,
    0x3fe0fa27652fb164, 0x0,
    0x3fe5fa3c02a349a4, 0x0,
    0x3fe0a79308b30440, 0x0,
    0xbf9d4103cbe96909, 0x0,
    0xbfdc7c32a4ffcc50, 0x0,
    0xbfe5b09de3865497, 0x0,
    0xbfda3d70cb88cc82, 0x0
    };

static const uint64_t in_cifft_noisy_256[512] = {
    0xbff2fd4224ea388e, 0x0,
    0x3fd6f77caa1b7c64, 0xbfdb1fb0d9807e00,
    0xbfecc1a003bc1914, 0x3ff48d449371aa02,
    0x3fe1cc51db8c5b30, 0xbfc26618d480b622,
    0x3fa8f414424ef20e, 0xbfb41030c322eb60,
    0xbfd4fd2be918b301, 0xbfb3eb101903e336,
    0x3fd5db30e197c801, 0x3fdbbda70b0028f4,
    0x3fcceb2b78e51072, 0x3fe4ccc28adaa431,
    0xbfdadb675a1f5ad4, 0x3fdcce3c61f24768,
    0x3fec574952bda1c0, 0xbfd2676726936072,
    0xbfe28a5f3ecce9cc, 0x3fe697a852bfa98b,
    0xbfd85fdec1bc1220, 0xbfc069e06d772f30,
    0x3fdb604881067ff3, 0xbfb52ef1c51400bc,
    0x3fa34f6a2cae23c0, 0x3ff2393d6d82f358,
    0xbfdbb06a0e0e06c6, 0xbfa8e49b247196a0,
    0x3fc05acfc63aaf79, 0xbfc004d8317374fe,
    0xbfe19b5f19db4f7d, 0x3fe26565b4dd4d7d,
    0x3fc66e7e736c07c1, 0xbfadac3e2d0ab078,
    0xbff32baf152a7c9e, 0xbfca2c175e3084f0,
    0x3ff8c26ba2f2de80, 0x3fd9be120335d4c6,
    0x3fe4d66001545a48, 0x3fa12073709099a8,
    0xbfa74d1027cdcfcc, 0x3fcb2b6600a7e63c,
    0x3ff1f22f778098fa, 0xbfa9a5ab8bcdebac,
    0xbfdc2ed0d957f240, 0x3feac88872330662,
    0xbfd4d1f33c481da7, 0x3fd6665249b5874e,
    0x3fd49e7fa87978bd, 0xbfc6d9b6343d43f4,
    0x3fd6ad369ed31c6e, 0x3fe533e50f611c90,
    0xbfbfc1f71ec785fc, 0x3fc9248bd1cc83ae,
    0xbfd38916828ab702, 0x3feb5f432b312eb2,
    0x3fd1ce714f6bcbca, 0x3fd21fd95c7ad5b8,
    0xbfeffa1ac0e2c285, 0x3fdfa38e8243567c,
    0xbfe2c03464ba5848, 0x3fe42c635faefcda,
    0x3fdbb422925829df, 0xc05637e03de1200e,
    0x3fe9dd97b7f22042, 0x3fe7c97880e84c68,
    0x3fd13a8ec47f59ca, 0xbfdd821324334ebe,
    0x3fc1ef224331cfcf, 0xbfeab85adb9b1fc8,
    0xbfc556a094c3415c, 0x3fcb8c6215d7e506,
    0x3fdef44a0d5c261c, 0xbfacfd5aee99a3e8,
    0x3fead3a9ca5d5960, 0xbff0f0fc2ffd8095,
    0xbfda1d7a532754f0, 0x3fb1e9a43d564302,
    0x3fe639406eb82138, 0xbfc7060451628475,
    0x3fb11a64041dfa24, 0x3fe422bdb36600f6,
    0x3fe07ae1aa9e6626, 0x3fef8736c6118f2b,
    0xbfe3b77ca0ce4ca0, 0x3fc5feda91f37f15,
    0xbfcb78f982b755c6, 0x3ff27de4f4119e37,
    0xbfac8413ecf2f5e4, 0x3fc62a0894c3eeb4,
    0xbfc1d24d80a4a544, 0xbfda6561ac0f6b79,
    0xbfc301fa2d0488f7, 0xbf8429f0c4af77a0,
    0xbfd7937dd8b75180, 0xbfc44c4dcf139a62,
    0xbfd58733186871c5, 0xbfa355572f0d39a0,
    0x3fc439675c1be175, 0x3fe31494fc55a6b8,
    0x3febb826bc389dbd, 0xbf7d3e8e29929e80,
    0xbff2b3bbc5b38763, 0xbfdb675a8e77df50,
    0x3fdd4d637fe0582f, 0x3fe3a82b2774074f,
    0x3fec93f333492e98, 0xbfd02fd096b5c542,
    0xbfd6e67605c0cd83, 0x3fb1fcba90db298a,
    0xbfdec724e4c2b1e4, 0x3fedb406c1f451b4,
    0xbfe18e4950e2c94e, 0x3fdee61cfce072aa,
    0xbfc924019890f154, 0x3fd7afde7bca7f64,
    0xbfd1db7426057361, 0x3fe194e62c97d24b,
    0x3fb78cbc110b3600, 0x3fd563bbb14ee4f8,
    0xbfb05df8339c145a, 0x3fed976938425b12,
    0x3fd6dc07fa8cd496, 0xbfcc728ba056a5fd,
    0xbfd2426cd25cb2e6, 0x3fc7550ae47544ec,
    0x3fd9788dc804fec7, 0x3fe7ccffa6192c00,
    0x3fefae0d56dc5a3f, 0x3fab2c1d1b43c05a,
    0xbfe16b0c569c0cbe, 0x3fdbd8fd4bc4ae1e,
    0xbfc51752a8dcff7e, 0xbfe9a0650da469c6,
    0xbfe9fade0b771d14, 0xbfadcfd788d9c5e8,
    0x3fe8b86084c89e01, 0x3fc8642f3ecc952b,
    0x3fcf10b2a256c1aa, 0x3fca6c8b94fe318a,
    0xbfcbe6e011faf21a, 0x3fe26544971178a4,
    0x3fc6a9e991fbad84, 0x3fe5e83dc7f19198,
    0xbfcdcc9e39bb0bd1, 0xbfd65bc04b9d1827,
    0x3fc8c9435f25b4fe, 0x3fe889caa508c1f1,
    0x3ff176c16d9cfc7e, 0xbfb93590220bde90,
    0x3fe32f0521f2c9df, 0x3fe864c5a2379117,
    0xbfd5fadd82ab0c04, 0x3ff2e41d38ff4320,
    0xbfcfd6d5b468016d, 0xbfc11a5000695bd3,
    0x3febbd6d5ab8f4cd, 0xbfeedcec720565ba,
    0x3feee0ba2a3da8ba, 0x3f9c1a53bc1aa9c8,
    0xbfdcbf319c1229cb, 0xbfe8aa65da9a854a,
    0x3fe65f9ce11e8368, 0x3fd790cf385aceee,
    0xbfd7ed684efe7fbd, 0x3fb089fd58f941fc,
    0x3fed5fccf5aef45a, 0xbfd446f25492238c,
    0xbfe1ce9d873dcf6a, 0xbfd28d316113587b,
    0x3fc2a8132009769e, 0x3fd93bc18c88f5ce,
    0x3fd5116a51aa5898, 0x3fb8238842bddff0,
    0xbfa78a84a7f398b0, 0xbfe467086234e5d1,
    0xbfd3e814e85a9201, 0x3fc11a491264baa4,
    0xbfbc9dd692c43e00, 0x3fa3685ffd3df630,
    0x3fd4db4be78c28e9, 0x3ff030771c8e4922,
    0xbfd9a49f7841a058, 0x3fd0f4ad037d64d6,
    0xbfc070fb6d69d349, 0x3fd5857a137e8318,
    0x3fc39119adc262fc, 0x3fe810dea087d5b7,
    0xbfa59599438793c8, 0x3fe523e12e1e4529,
    0xbfb5aeca60c5520c, 0x3fda6ca6fba29e00,
    0xbfb87c97b23f9c98, 0x3fd01bca4b2519a0,
    0x3fef2ac914d00331, 0x3fb27db01004d230,
    0xbfcff74b68c9f24c, 0x3ff1e6afd36b54db,
    0x3fc1c701125cc399, 0x3fc36d020d5f1cb8,
    0x3fe4e73e100e93be, 0xbfe627c4f88355fa,
    0xbfb6200b1a60cedc, 0xbfecb198fdae3139,
    0x3fead0a3ef866285, 0x3fe43deb63c15854,
    0x3fb50168783c8a86, 0xbfe08bbe81bbbe2c,
    0x3ff1bca47c42ec52, 0x3fb3346328c02188,
    0x3fe77fcf076fa062, 0xbfcafafe2b6fabc2,
    0xbfbf5a8ad465d60c, 0xbfea1d517ca44c7e,
    0xbfd05d5a93cf459e, 0x3feee901535bdb64,
    0xbfb1a5b3e9f60d18, 0xbfdcddbc661243c0,
    0x3fbc63db03e52040, 0xbfdfc73a8906752c,
    0x3fdb957538101c7e, 0x3fdfa5963e821526,
    0xbef18f0a86288000, 0x3fc554924933cc01,
    0xbfddf803fe066811, 0x3fdb259948418f28,
    0x3fef500628745eda, 0x3fc03788c8c7c953,
    0x3fdd481951234013, 0x3fef906038075dc5,
    0x3ff018d854ce2400, 0x3f9076046f824220,
    0xbfd5fe4649eda6be, 0x3fe1dd10015efa8c,
    0xbfef146c3c694dc4, 0x3fea6c0cdb6125a4,
    0x3fa36c8a2a8fdd98, 0xbfca6e214b459f5b,
    0xbfca0056b8614e40, 0x3fde485b79e35f1e,
    0x3fc4daa9f3435331, 0xbfb56f2851f25e84,
    0xbf59ff3b2e6d9300, 0x3f81bb5206dfef50,
    0xbfe50d191089c788, 0x3fd129eb5ee15df2,
    0xbf6eec5dcab734c0, 0x3fcb1c4200ec981d,
    0xbfe1d7131105d2fc, 0xbfeba8346eb6879d,
    0xbfcddacf378bddf0, 0xbfd3082e049478f4,
    0x3ff14a2203f25235, 0xbfc47b274c9d9a12,
    0x3fe07e87e4f2e9e4, 0x0,
    0x3ff14a2203f25234, 0x3fc47b274c9d9a24,
    0xbfcddacf378bddf0, 0x3fd3082e049478f6,
    0xbfe1d7131105d300, 0x3feba8346eb6879c,
    0xbf6eec5dcab734e0, 0xbfcb1c4200ec981c,
    0xbfe50d191089c788, 0xbfd129eb5ee15df8,
    0xbf59ff3b2e6d9400, 0xbf81bb5206dff030,
    0x3fc4daa9f3435332, 0x3fb56f2851f25e88,
    0xbfca0056b8614e38, 0xbfde485b79e35f24,
    0x3fa36c8a2a8fdd98, 0x3fca6e214b459f55,
    0xbfef146c3c694dc0, 0xbfea6c0cdb6125a5,
    0xbfd5fe4649eda6be, 0xbfe1dd10015efa8e,
    0x3ff018d854ce2400, 0xbf9076046f8241d0,
    0x3fdd481951234018, 0xbfef906038075dc4,
    0x3fef500628745ed9, 0xbfc03788c8c7c948,
    0xbfddf803fe066810, 0xbfdb259948418f2d,
    0xbef18f0a86288000, 0xbfc554924933cc03,
    0x3fdb957538101c7e, 0xbfdfa5963e821527,
    0x3fbc63db03e52028, 0x3fdfc73a8906752a,
    0xbfb1a5b3e9f60d20, 0x3fdcddbc661243ba,
    0xbfd05d5a93cf459d, 0xbfeee901535bdb68,
    0xbfbf5a8ad465d61a, 0x3fea1d517ca44c7f,
    0x3fe77fcf076fa062, 0x3fcafafe2b6fabc1,
    0x3ff1bca47c42ec52, 0xbfb3346328c02170,
    0x3fb50168783c8a8c, 0x3fe08bbe81bbbe2e,
    0x3fead0a3ef866286, 0xbfe43deb63c15851,
    0xbfb6200b1a60cee6, 0x3fecb198fdae313c,
    0x3fe4e73e100e93bc, 0x3fe627c4f88355fa,
    0x3fc1c701125cc399, 0xbfc36d020d5f1cb8,
    0xbfcff74b68c9f23d, 0xbff1e6afd36b54da,
    0x3fef2ac914d0032f, 0xbfb27db01004d236,
    0xbfb87c97b23f9ca0, 0xbfd01bca4b2519a2,
    0xbfb5aeca60c55284, 0xbfda6ca6fba29e00,
    0xbfa59599438793c8, 0xbfe523e12e1e4528,
    0x3fc39119adc26303, 0xbfe810dea087d5b7,
    0xbfc070fb6d69d349, 0xbfd5857a137e831c,
    0xbfd9a49f7841a056, 0xbfd0f4ad037d64d6,
    0x3fd4db4be78c28e8, 0xbff030771c8e4921,
    0xbfbc9dd692c43e10, 0xbfa3685ffd3df660,
    0xbfd3e814e85a9204, 0xbfc11a491264baa9,
    0xbfa78a84a7f398e0, 0x3fe467086234e5d1,
    0x3fd5116a51aa588f, 0xbfb8238842bddfec,
    0x3fc2a813200976ae, 0xbfd93bc18c88f5d2,
    0xbfe1ce9d873dcf6c, 0x3fd28d3161135876,
    0x3fed5fccf5aef45a, 0x3fd446f25492238d,
    0xbfd7ed684efe7fbe, 0xbfb089fd58f94208,
    0x3fe65f9ce11e8369, 0xbfd790cf385aceeb,
    0xbfdcbf319c1229d2, 0x3fe8aa65da9a8548,
    0x3feee0ba2a3da8ba, 0xbf9c1a53bc1aa9a0,
    0x3febbd6d5ab8f4ca, 0x3feedcec720565be,
    0xbfcfd6d5b468016b, 0x3fc11a5000695bd9,
    0xbfd5fadd82ab0bfe, 0xbff2e41d38ff4320,
    0x3fe32f0521f2c9e2, 0xbfe864c5a2379114,
    0x3ff176c16d9cfc7e, 0x3fb93590220bde98,
    0x3fc8c9435f25b500, 0xbfe889caa508c1ef,
    0xbfcdcc9e39bb0bce, 0x3fd65bc04b9d1826,
    0x3fc6a9e991fbad8b, 0xbfe5e83dc7f19198,
    0xbfcbe6e011faf21a, 0xbfe26544971178a7,
    0x3fcf10b2a256c1ac, 0xbfca6c8b94fe3193,
    0x3fe8b86084c89e04, 0xbfc8642f3ecc952d,
    0xbfe9fade0b771d14, 0x3fadcfd788d9c5dc,
    0xbfc51752a8dcff89, 0x3fe9a0650da469c4,
    0xbfe16b0c569c0cbd, 0xbfdbd8fd4bc4ae22,
    0x3fefae0d56dc5a3f, 0xbfab2c1d1b43c032,
    0x3fd9788dc804fec7, 0xbfe7ccffa6192c00,
    0xbfd2426cd25cb2ea, 0xbfc7550ae47544fc,
    0x3fd6dc07fa8cd491, 0x3fcc728ba056a607,
    0xbfb05df8339c1447, 0xbfed976938425b12,
    0x3fb78cbc110b35f8, 0xbfd563bbb14ee4f9,
    0xbfd1db742605735e, 0xbfe194e62c97d24a,
    0xbfc924019890f154, 0xbfd7afde7bca7f67,
    0xbfe18e4950e2c94c, 0xbfdee61cfce072a8,
    0xbfdec724e4c2b1e2, 0xbfedb406c1f451b4,
    0xbfd6e67605c0cd84, 0xbfb1fcba90db2994,
    0x3fec93f333492e98, 0x3fd02fd096b5c546,
    0x3fdd4d637fe0582e, 0xbfe3a82b2774074e,
    0xbff2b3bbc5b38762, 0x3fdb675a8e77df4e,
    0x3febb826bc389dbe, 0x3f7d3e8e2992a000,
    0x3fc439675c1be17f, 0xbfe31494fc55a6b7,
    0xbfd58733186871c6, 0x3fa355572f0d3980,
    0xbfd7937dd8b75180, 0x3fc44c4dcf139a61,
    0xbfc301fa2d0488fe, 0x3f8429f0c4af7720,
    0xbfc1d24d80a4a54a, 0x3fda6561ac0f6b78,
    0xbfac8413ecf2f5a8, 0xbfc62a0894c3eebe,
    0xbfcb78f982b755be, 0xbff27de4f4119e37,
    0xbfe3b77ca0ce4ca0, 0xbfc5feda91f37f22,
    0x3fe07ae1aa9e6626, 0xbfef8736c6118f29,
    0x3fb11a64041dfa30, 0xbfe422bdb36600f6,
    0x3fe639406eb82137, 0x3fc7060451628478,
    0xbfda1d7a532754ef, 0xbfb1e9a43d564328,
    0x3fead3a9ca5d595e, 0x3ff0f0fc2ffd8096,
    0x3fdef44a0d5c261d, 0x3facfd5aee99a410,
    0xbfc556a094c34159, 0xbfcb8c6215d7e507,
    0x3fc1ef224331cfcf, 0x3feab85adb9b1fc8,
    0x3fd13a8ec47f59c5, 0x3fdd821324334ebe,
    0x3fe9dd97b7f22042, 0xbfe7c97880e84c67,
    0x3fdbb422925828fd, 0x405637e03de1200e,
    0xbfe2c03464ba5846, 0xbfe42c635faefcde,
    0xbfeffa1ac0e2c287, 0xbfdfa38e82435680,
    0x3fd1ce714f6bcbce, 0xbfd21fd95c7ad5b5,
    0xbfd38916828ab6fe, 0xbfeb5f432b312eb2,
    0xbfbfc1f71ec785f4, 0xbfc9248bd1cc83b1,
    0x3fd6ad369ed31c6f, 0xbfe533e50f611c8f,
    0x3fd49e7fa87978ba, 0x3fc6d9b6343d43fa,
    0xbfd4d1f33c481da2, 0xbfd6665249b58750,
    0xbfdc2ed0d957f238, 0xbfeac88872330664,
    0x3ff1f22f778098f9, 0x3fa9a5ab8bcdebb8,
    0xbfa74d1027cdcfc7, 0xbfcb2b6600a7e636,
    0x3fe4d66001545a46, 0xbfa1207370909988,
    0x3ff8c26ba2f2de82, 0xbfd9be120335d4ba,
    0xbff32baf152a7c9e, 0x3fca2c175e3084e0,
    0x3fc66e7e736c07bf, 0x3fadac3e2d0ab07c,
    0xbfe19b5f19db4f7d, 0xbfe26565b4dd4d7e,
    0x3fc05acfc63aaf7e, 0x3fc004d8317374ff,
    0xbfdbb06a0e0e06c4, 0x3fa8e49b2471969c,
    0x3fa34f6a2cae2408, 0xbff2393d6d82f358,
    0x3fdb604881067ff0, 0x3fb52ef1c51400c0,
    0xbfd85fdec1bc1224, 0x3fc069e06d772f26,
    0xbfe28a5f3ecce9c8, 0xbfe697a852bfa98c,
    0x3fec574952bda1c2, 0x3fd2676726936078,
    0xbfdadb675a1f5ad0, 0xbfdcce3c61f24764,
    0x3fcceb2b78e5107d, 0xbfe4ccc28adaa430,
    0x3fd5db30e197c7ff, 0xbfdbbda70b0028ee,
    0xbfd4fd2be918b303, 0x3fb3eb101903e336,
    0x3fa8f414424ef20c, 0x3fb41030c322eb5e,
    0x3fe1cc51db8c5b30, 0x3fc26618d480b62c,
    0xbfecc1a003bc1912, 0xbff48d449371aa03,
    0x3fd6f77caa1b7c63, 0x3fdb1fb0d9807e03
    };

static const uint64_t ref_cfft_noisy_256[512] = {
    0xbff2fd4224ea388e, 0x0,
    0x3fd6f77caa1b7c64, 0xbfdb1fb0d9807e00,
    0xbfecc1a003bc1914, 0x3ff48d449371aa02,
    0x3fe1cc51db8c5b30, 0xbfc26618d480b622,
    0x3fa8f414424ef20e, 0xbfb41030c322eb60,
    0xbfd4fd2be918b301, 0xbfb3eb101903e336,
    0x3fd5db30e197c801, 0x3fdbbda70b0028f4,
    0x3fcceb2b78e51072, 0x3fe4ccc28adaa431,
    0xbfdadb675a1f5ad4, 0x3fdcce3c61f24768,
    0x3fec574952bda1c0, 0xbfd2676726936072,
    0xbfe28a5f3ecce9cc, 0x3fe697a852bfa98b,
    0xbfd85fdec1bc1220, 0xbfc069e06d772f30,
    0x3fdb604881067ff3, 0xbfb52ef1c51400bc,
    0x3fa34f6a2cae23c0, 0x3ff2393d6d82f358,
    0xbfdbb06a0e0e06c6, 0xbfa8e49b247196a0,
    0x3fc05acfc63aaf79, 0xbfc004d8317374fe,
    0xbfe19b5f19db4f7d, 0x3fe26565b4dd4d7d,
    0x3fc66e7e736c07c1, 0xbfadac3e2d0ab078,
    0xbff32baf152a7c9e, 0xbfca2c175e3084f0,
    0x3ff8c26ba2f2de80, 0x3fd9be120335d4c6,
    0x3fe4d66001545a48, 0x3fa12073709099a8,
    0xbfa74d1027cdcfcc, 0x3fcb2b6600a7e63c,
    0x3ff1f22f778098fa, 0xbfa9a5ab8bcdebac,
    0xbfdc2ed0d957f240, 0x3feac88872330662,
    0xbfd4d1f33c481da7, 0x3fd6665249b5874e,
    0x3fd49e7fa87978bd, 0xbfc6d9b6343d43f4,
    0x3fd6ad369ed31c6e, 0x3fe533e50f611c90,
    0xbfbfc1f71ec785fc, 0x3fc9248bd1cc83ae,
    0xbfd38916828ab702, 0x3feb5f432b312eb2,
    0x3fd1ce714f6bcbca, 0x3fd21fd95c7ad5b8,
    0xbfeffa1ac0e2c285, 0x3fdfa38e8243567c,
    0xbfe2c03464ba5848, 0x3fe42c635faefcda,
    0x3fdbb422925829df, 0xc05637e03de1200e,
    0x3fe9dd97b7f22042, 0x3fe7c97880e84c68,
    0x3fd13a8ec47f59ca, 0xbfdd821324334ebe,
    0x3fc1ef224331cfcf, 0xbfeab85adb9b1fc8,
    0xbfc556a094c3415c, 0x3fcb8c6215d7e506,
    0x3fdef44a0d5c261c, 0xbfacfd5aee99a3e8,
    0x3fead3a9ca5d5960, 0xbff0f0fc2ffd8095,
    0xbfda1d7a532754f0, 0x3fb1e9a43d564302,
    0x3fe639406eb82138, 0xbfc7060451628475,
    0x3fb11a64041dfa24, 0x3fe422bdb36600f6,
    0x3fe07ae1aa9e6626, 0x3fef8736c6118f2b,
    0xbfe3b77ca0ce4ca0, 0x3fc5feda91f37f15,
    0xbfcb78f982b755c6, 0x3ff27de4f4119e37,
    0xbfac8413ecf2f5e4, 0x3fc62a0894c3eeb4,
    0xbfc1d24d80a4a544, 0xbfda6561ac0f6b79,
    0xbfc301fa2d0488f7, 0xbf8429f0c4af77a0,
    0xbfd7937dd8b75180, 0xbfc44c4dcf139a62,
    0xbfd58733186871c5, 0xbfa355572f0d39a0,
    0x3fc439675c1be175, 0x3fe31494fc55a6b8,
    0x3febb826bc389dbd, 0xbf7d3e8e29929e80,
    0xbff2b3bbc5b38763, 0xbfdb675a8e77df50,
    0x3fdd4d637fe0582f, 0x3fe3a82b2774074f,
    0x3fec93f333492e98, 0xbfd02fd096b5c542,
    0xbfd6e67605c0cd83, 0x3fb1fcba90db298a,
    0xbfdec724e4c2b1e4, 0x3fedb406c1f451b4,
    0xbfe18e4950e2c94e, 0x3fdee61cfce072aa,
    0xbfc924019890f154, 0x3fd7afde7bca7f64,
    0xbfd1db7426057361, 0x3fe194e62c97d24b,
    0x3fb78cbc110b3600, 0x3fd563bbb14ee4f8,
    0xbfb05df8339c145a, 0x3fed976938425b12,
    0x3fd6dc07fa8cd496, 0xbfcc728ba056a5fd,
    0xbfd2426cd25cb2e6, 0x3fc7550ae47544ec,
    0x3fd9788dc804fec7, 0x3fe7ccffa6192c00,
    0x3fefae0d56dc5a3f, 0x3fab2c1d1b43c05a,
    0xbfe16b0c569c0cbe, 0x3fdbd8fd4bc4ae1e,
    0xbfc51752a8dcff7e, 0xbfe9a0650da469c6,
    0xbfe9fade0b771d14, 0xbfadcfd788d9c5e8,
    0x3fe8b86084c89e01, 0x3fc8642f3ecc952b,
    0x3fcf10b2a256c1aa, 0x3fca6c8b94fe318a,
    0xbfcbe6e011faf21a, 0x3fe26544971178a4,
    0x3fc6a9e991fbad84, 0x3fe5e83dc7f19198,
    0xbfcdcc9e39bb0bd1, 0xbfd65bc04b9d1827,
    0x3fc8c9435f25b4fe, 0x3fe889caa508c1f1,
    0x3ff176c16d9cfc7e, 0xbfb93590220bde90,
    0x3fe32f0521f2c9df, 0x3fe864c5a2379117,
    0xbfd5fadd82ab0c04, 0x3ff2e41d38ff4320,
    0xbfcfd6d5b468016d, 0xbfc11a5000695bd3,
    0x3febbd6d5ab8f4cd, 0xbfeedcec720565ba,
    0x3feee0ba2a3da8ba, 0x3f9c1a53bc1aa9c8,
    0xbfdcbf319c1229cb, 0xbfe8aa65da9a854a,
    0x3fe65f9ce11e8368, 0x3fd790cf385aceee,
    0xbfd7ed684efe7fbd, 0x3fb089fd58f941fc,
    0x3fed5fccf5aef45a, 0xbfd446f25492238c,
    0xbfe1ce9d873dcf6a, 0xbfd28d316113587b,
    0x3fc2a8132009769e, 0x3fd93bc18c88f5ce,
    0x3fd5116a51aa5898, 0x3fb8238842bddff0,
    0xbfa78a84a7f398b0, 0xbfe467086234e5d1,
    0xbfd3e814e85a9201, 0x3fc11a491264baa4,
    0xbfbc9dd692c43e00, 0x3fa3685ffd3df630,
    0x3fd4db4be78c28e9, 0x3ff030771c8e4922,
    0xbfd9a49f7841a058, 0x3fd0f4ad037d64d6,
    0xbfc070fb6d69d349, 0x3fd5857a137e8318,
    0x3fc39119adc262fc, 0x3fe810dea087d5b7,
    0xbfa59599438793c8, 0x3fe523e12e1e4529,
    0xbfb5aeca60c5520c, 0x3fda6ca6fba29e00,
    0xbfb87c97b23f9c98, 0x3fd01bca4b2519a0,
    0x3fef2ac914d00331, 0x3fb27db01004d230,
    0xbfcff74b68c9f24c, 0x3ff1e6afd36b54db,
    0x3fc1c701125cc399, 0x3fc36d020d5f1cb8,
    0x3fe4e73e100e93be, 0xbfe627c4f88355fa,
    0xbfb6200b1a60cedc, 0xbfecb198fdae3139,
    0x3fead0a3ef866285, 0x3fe43deb63c15854,
    0x3fb50168783c8a86, 0xbfe08bbe81bbbe2c,
    0x3ff1bca47c42ec52, 0x3fb3346328c02188,
    0x3fe77fcf076fa062, 0xbfcafafe2b6fabc2,
    0xbfbf5a8ad465d60c, 0xbfea1d517ca44c7e,
    0xbfd05d5a93cf459e, 0x3feee901535bdb64,
    0xbfb1a5b3e9f60d18, 0xbfdcddbc661243c0,
    0x3fbc63db03e52040, 0xbfdfc73a8906752c,
    0x3fdb957538101c7e, 0x3fdfa5963e821526,
    0xbef18f0a86288000, 0x3fc554924933cc01,
    0xbfddf803fe066811, 0x3fdb259948418f28,
    0x3fef500628745eda, 0x3fc03788c8c7c953,
    0x3fdd481951234013, 0x3fef906038075dc5,
    0x3ff018d854ce2400, 0x3f9076046f824220,
    0xbfd5fe4649eda6be, 0x3fe1dd10015efa8c,
    0xbfef146c3c694dc4, 0x3fea6c0cdb6125a4,
    0x3fa36c8a2a8fdd98, 0xbfca6e214b459f5b,
    0xbfca0056b8614e40, 0x3fde485b79e35f1e,
    0x3fc4daa9f3435331, 0xbfb56f2851f25e84,
    0xbf59ff3b2e6d9300, 0x3f81bb5206dfef50,
    0xbfe50d191089c788, 0x3fd129eb5ee15df2,
    0xbf6eec5dcab734c0, 0x3fcb1c4200ec981d,
    0xbfe1d7131105d2fc, 0xbfeba8346eb6879d,
    0xbfcddacf378bddf0, 0xbfd3082e049478f4,
    0x3ff14a2203f25235, 0xbfc47b274c9d9a12,
    0x3fe07e87e4f2e9e4, 0x0,
    0x3ff14a2203f25234, 0x3fc47b274c9d9a24,
    0xbfcddacf378bddf0, 0x3fd3082e049478f6,
    0xbfe1d7131105d300, 0x3feba8346eb6879c,
    0xbf6eec5dcab734e0, 0xbfcb1c4200ec981c,
    0xbfe50d191089c788, 0xbfd129eb5ee15df8,
    0xbf59ff3b2e6d9400, 0xbf81bb5206dff030,
    0x3fc4daa9f3435332, 0x3fb56f2851f25e88,
    0xbfca0056b8614e38, 0xbfde485b79e35f24,
    0x3fa36c8a2a8fdd98, 0x3fca6e214b459f55,
    0xbfef146c3c694dc0, 0xbfea6c0cdb6125a5,
    0xbfd5fe4649eda6be, 0xbfe1dd10015efa8e,
    0x3ff018d854ce2400, 0xbf9076046f8241d0,
    0x3fdd481951234018, 0xbfef906038075dc4,
    0x3fef500628745ed9, 0xbfc03788c8c7c948,
    0xbfddf803fe066810, 0xbfdb259948418f2d,
    0xbef18f0a86288000, 0xbfc554924933cc03,
    0x3fdb957538101c7e, 0xbfdfa5963e821527,
    0x3fbc63db03e52028, 0x3fdfc73a8906752a,
    0xbfb1a5b3e9f60d20, 0x3fdcddbc661243ba,
    0xbfd05d5a93cf459d, 0xbfeee901535bdb68,
    0xbfbf5a8ad465d61a, 0x3fea1d517ca44c7f,
    0x3fe77fcf076fa062, 0x3fcafafe2b6fabc1,
    0x3ff1bca47c42ec52, 0xbfb3346328c02170,
    0x3fb50168783c8a8c, 0x3fe08bbe81bbbe2e,
    0x3fead0a3ef866286, 0xbfe43deb63c15851,
    0xbfb6200b1a60cee6, 0x3fecb198fdae313c,
    0x3fe4e73e100e93bc, 0x3fe627c4f88355fa,
    0x3fc1c701125cc399, 0xbfc36d020d5f1cb8,
    0xbfcff74b68c9f23d, 0xbff1e6afd36b54da,
    0x3fef2ac914d0032f, 0xbfb27db01004d236,
    0xbfb87c97b23f9ca0, 0xbfd01bca4b2519a2,
    0xbfb5aeca60c55284, 0xbfda6ca6fba29e00,
    0xbfa59599438793c8, 0xbfe523e12e1e4528,
    0x3fc39119adc26303, 0xbfe810dea087d5b7,
    0xbfc070fb6d69d349, 0xbfd5857a137e831c,
    0xbfd9a49f7841a056, 0xbfd0f4ad037d64d6,
    0x3fd4db4be78c28e8, 0xbff030771c8e4921,
    0xbfbc9dd692c43e10, 0xbfa3685ffd3df660,
    0xbfd3e814e85a9204, 0xbfc11a491264baa9,
    0xbfa78a84a7f398e0, 0x3fe467086234e5d1,
    0x3fd5116a51aa588f, 0xbfb8238842bddfec,
    0x3fc2a813200976ae, 0xbfd93bc18c88f5d2,
    0xbfe1ce9d873dcf6c, 0x3fd28d3161135876,
    0x3fed5fccf5aef45a, 0x3fd446f25492238d,
    0xbfd7ed684efe7fbe, 0xbfb089fd58f94208,
    0x3fe65f9ce11e8369, 0xbfd790cf385aceeb,
    0xbfdcbf319c1229d2, 0x3fe8aa65da9a8548,
    0x3feee0ba2a3da8ba, 0xbf9c1a53bc1aa9a0,
    0x3febbd6d5ab8f4ca, 0x3feedcec720565be,
    0xbfcfd6d5b468016b, 0x3fc11a5000695bd9,
    0xbfd5fadd82ab0bfe, 0xbff2e41d38ff4320,
    0x3fe32f0521f2c9e2, 0xbfe864c5a2379114,
    0x3ff176c16d9cfc7e, 0x3fb93590220bde98,
    0x3fc8c9435f25b500, 0xbfe889caa508c1ef,
    0xbfcdcc9e39bb0bce, 0x3fd65bc04b9d1826,
    0x3fc6a9e991fbad8b, 0xbfe5e83dc7f19198,
    0xbfcbe6e011faf21a, 0xbfe26544971178a7,
    0x3fcf10b2a256c1ac, 0xbfca6c8b94fe3193,
    0x3fe8b86084c89e04, 0xbfc8642f3ecc952d,
    0xbfe9fade0b771d14, 0x3fadcfd788d9c5dc,
    0xbfc51752a8dcff89, 0x3fe9a0650da469c4,
    0xbfe16b0c569c0cbd, 0xbfdbd8fd4bc4ae22,
    0x3fefae0d56dc5a3f, 0xbfab2c1d1b43c032,
    0x3fd9788dc804fec7, 0xbfe7ccffa6192c00,
    0xbfd2426cd25cb2ea, 0xbfc7550ae47544fc,
    0x3fd6dc07fa8cd491, 0x3fcc728ba056a607,
    0xbfb05df8339c1447, 0xbfed976938425b12,
    0x3fb78cbc110b35f8, 0xbfd563bbb14ee4f9,
    0xbfd1db742605735e, 0xbfe194e62c97d24a,
    0xbfc924019890f154, 0xbfd7afde7bca7f67,
    0xbfe18e4950e2c94c, 0xbfdee61cfce072a8,
    0xbfdec724e4c2b1e2, 0xbfedb406c1f451b4,
    0xbfd6e67605c0cd84, 0xbfb1fcba90db2994,
    0x3fec93f333492e98, 0x3fd02fd096b5c546,
    0x3fdd4d637fe0582e, 0xbfe3a82b2774074e,
    0xbff2b3bbc5b38762, 0x3fdb675a8e77df4e,
    0x3febb826bc389dbe, 0x3f7d3e8e2992a000,
    0x3fc439675c1be17f, 0xbfe31494fc55a6b7,
    0xbfd58733186871c6, 0x3fa355572f0d3980,
    0xbfd7937dd8b75180, 0x3fc44c4dcf139a61,
    0xbfc301fa2d0488fe, 0x3f8429f0c4af7720,
    0xbfc1d24d80a4a54a, 0x3fda6561ac0f6b78,
    0xbfac8413ecf2f5a8, 0xbfc62a0894c3eebe,
    0xbfcb78f982b755be, 0xbff27de4f4119e37,
    0xbfe3b77ca0ce4ca0, 0xbfc5feda91f37f22,
    0x3fe07ae1aa9e6626, 0xbfef8736c6118f29,
    0x3fb11a64041dfa30, 0xbfe422bdb36600f6,
    0x3fe639406eb82137, 0x3fc7060451628478,
    0xbfda1d7a532754ef, 0xbfb1e9a43d564328,
    0x3fead3a9ca5d595e, 0x3ff0f0fc2ffd8096,
    0x3fdef44a0d5c261d, 0x3facfd5aee99a410,
    0xbfc556a094c34159, 0xbfcb8c6215d7e507,
    0x3fc1ef224331cfcf, 0x3feab85adb9b1fc8,
    0x3fd13a8ec47f59c5, 0x3fdd821324334ebe,
    0x3fe9dd97b7f22042, 0xbfe7c97880e84c67,
    0x3fdbb422925828fd, 0x405637e03de1200e,
    0xbfe2c03464ba5846, 0xbfe42c635faefcde,
    0xbfeffa1ac0e2c287, 0xbfdfa38e82435680,
    0x3fd1ce714f6bcbce, 0xbfd21fd95c7ad5b5,
    0xbfd38916828ab6fe, 0xbfeb5f432b312eb2,
    0xbfbfc1f71ec785f4, 0xbfc9248bd1cc83b1,
    0x3fd6ad369ed31c6f, 0xbfe533e50f611c8f,
    0x3fd49e7fa87978ba, 0x3fc6d9b6343d43fa,
    0xbfd4d1f33c481da2, 0xbfd6665249b58750,
    0xbfdc2ed0d957f238, 0xbfeac88872330664,
    0x3ff1f22f778098f9, 0x3fa9a5ab8bcdebb8,
    0xbfa74d1027cdcfc7, 0xbfcb2b6600a7e636,
    0x3fe4d66001545a46, 0xbfa1207370909988,
    0x3ff8c26ba2f2de82, 0xbfd9be120335d4ba,
    0xbff32baf152a7c9e, 0x3fca2c175e3084e0,
    0x3fc66e7e736c07bf, 0x3fadac3e2d0ab07c,
    0xbfe19b5f19db4f7d, 0xbfe26565b4dd4d7e,
    0x3fc05acfc63aaf7e, 0x3fc004d8317374ff,
    0xbfdbb06a0e0e06c4, 0x3fa8e49b2471969c,
    0x3fa34f6a2cae2408, 0xbff2393d6d82f358,
    0x3fdb604881067ff0, 0x3fb52ef1c51400c0,
    0xbfd85fdec1bc1224, 0x3fc069e06d772f26,
    0xbfe28a5f3ecce9c8, 0xbfe697a852bfa98c,
    0x3fec574952bda1c2, 0x3fd2676726936078,
    0xbfdadb675a1f5ad0, 0xbfdcce3c61f24764,
    0x3fcceb2b78e5107d, 0xbfe4ccc28adaa430,
    0x3fd5db30e197c7ff, 0xbfdbbda70b0028ee,
    0xbfd4fd2be918b303, 0x3fb3eb101903e336,
    0x3fa8f414424ef20c, 0x3fb41030c322eb5e,
    0x3fe1cc51db8c5b30, 0x3fc26618d480b62c,
    0xbfecc1a003bc1912, 0xbff48d449371aa03,
    0x3fd6f77caa1b7c63, 0x3fdb1fb0d9807e03
    };

static const uint64_t in_cfft_noisy_512[1024] = {
    0xbf685aa6997e7a65, 0x0,
    0x3fde54741ce71783, 0x0,
    0x3fe6371e397b46fd, 0x0,
    0x3fdc433c34caf034, 0x0,
    0x3faef43688c073db, 0x0,
    0xbfde473b41178f15, 0x0,
    0xbfe7bab83634f071, 0x0,
    0xbfe07504803e5bbc, 0x0,
    0xbf907092dd10161a, 0x0,
    0x3fe2de3b526190f6, 0x0,
    0x3fe9990e8f7ec58a, 0x0,
    0x3fdb4099c4baab31, 0x0,
    0x3fb636f26fd7b9b2, 0x0,
    0xbfd95c7777ddae98, 0x0,
    0xbfe789dfc550c175, 0x0,
    0xbfdd339cb1f2b87b, 0x0,
    0xbfab601de7b98d60, 0x0,
    0x3fdf28e92d84dcf2, 0x0,
    0x3fe6cd581caf7237, 0x0,
    0x3fdeddc233c567f6, 0x0,
    0x3f91c9f088d41c80, 0x0,
    0xbfe0f5a67b0dd6a4, 0x0,
    0xbfe9027af3a5ae06, 0x0,
    0xbfdd0ced8226cf00, 0x0,
    0xbf6752adb69b0572, 0x0,
    0x3fdb1f0a796bb3ae, 0x0,
    0x3fe6f830d98015b3, 0x0,
    0x3fde79988753ce15, 0x0,
    0x3fabeccd938c06da, 0x0,
    0xbfde1d6e8a6a54db, 0x0,
    0xbfe83b8bed9e7d14, 0x0,
    0xbfd721f736b48f76, 0x0,
    0xbf89c2b612630578, 0x0,
    0x3fe0c6955c5821a3, 0x0,
    0x3fe9614ce1d7f50f, 0x0,
    0x3fde4e3d7b09bcd8, 0x0,
    0x3fa37e5892dbc9a3, 0x0,
    0xbfe047a97e80ad57, 0x0,
    0xbfe6f1e1fa299f81, 0x0,
    0xbfdeebe264e0a3ea, 0x0,
    0xbfb237f4a43b2725, 0x0,
    0x3fdc24695aa946e2, 0x0,
    0x3fe84ba13ff8d71b, 0x0,
    0x3fdcbd27528ac8cb, 0x0,
    0xbfa397d7755c2c5e, 0x0,
    0xbfdcc4dd7636baae, 0x0,
    0xbfe4d9b2388b2fac, 0x0,
    0xbfe0d5095260fd2e, 0x0,
    0x3f933b295e116b4c, 0x0,
    0x3fe2be31442d1d08, 0x0,
    0x3fe6e939db00c19e, 0x0,
    0x3fd92f505c5e869e, 0x0,
    0xbfa783c5724ff34c, 0x0,
    0xbfdf92359b74a868, 0x0,
    0xbfe566a9cb0d2deb, 0x0,
    0xbfdf354e8a13e89d, 0x0,
    0x3f71962e1ae8596a, 0x0,
    0x3fe014811c4718af, 0x0,
    0x3fe54b45118250f2, 0x0,
    0x3fe028f0020cc7e0, 0x0,
    0xbf85f033d04de3d1, 0x0,
    0xbfe1c2959c38aba8, 0x0,
    0xbfe4e273bbdd23d5, 0x0,
    0xbfd93a18b0d75ff7, 0x0,
    0x3fa4fc7c91379ca6, 0x0,
    0x3fdfe4e2bb72b333, 0x0,
    0x3fe6aca35779ce3f, 0x0,
    0x3fe0c35516273501, 0x0,
    0x3f8a920bd891f180, 0x0,
    0xbfdc8a080bfa7c03, 0x0,
    0xbfe793cc54a64250, 0x0,
    0xbfdeb16bd450f817, 0x0,
    0xbfa6d568c5272229, 0x0,
    0x3fdcbf15cc88e0f0, 0x0,
    0x3fe6d877b8c9c793, 0x0,
    0x3fdfe12170168400, 0x0,
    0x3f92711cfda31101, 0x0,
    0xbfdfd6667871c6ce, 0x0,
    0xbfe59652ee463b3b, 0x0,
    0xbfe08bd7b450d714, 0x0,
    0x3f9f353dc7437b6e, 0x0,
    0x3fe0eb03cdcd68ce, 0x0,
    0x3fe61ee7fa2b1ecd, 0x0,
    0x3fe269e32fa7c7d2, 0x0,
    0x3fa8ea731beb7275, 0x0,
    0xbfdd7abe12b3f816, 0x0,
    0xbfe653042085cef0, 0x0,
    0xbfdff3a6fa875930, 0x0,
    0x3fb1b12d2577d1e8, 0x0,
    0x3fe0de114e47b447, 0x0,
    0x3fe566ed208bfce8, 0x0,
    0x3fdfc5c99a266550, 0x0,
    0xbfb0a4995e6a7f63, 0x0,
    0xbfe1996b66649b18, 0x0,
    0xbfe6029da0e337de, 0x0,
    0xbfde9d24771603fb, 0x0,
    0x3fa827cf0c4e6833, 0x0,
    0x3fdec77bf9fea3d0, 0x0,
    0x3fe636d4540394b0, 0x0,
    0x3fdf03af736ff0dd, 0x0,
    0x3f7a100f0ee64dcc, 0x0,
    0xbfde3e57b499eb99, 0x0,
    0xbfe86cb65f146013, 0x0,
    0xbfe07159cbe60430, 0x0,
    0xbf91e575a0c6cb7a, 0x0,
    0x3fdf0cb371bd9f58, 0x0,
    0x3fe6cd793080891e, 0x0,
    0x3fdb70c1218d2471, 0x0,
    0xbf9d9cc4ba7b949f, 0x0,
    0xbfe01f57bbe6d753, 0x0,
    0xbfe69155fceb4fc9, 0x0,
    0xbfde7aafbc56fcdf, 0x0,
    0x3fa19ced9c8ab0a8, 0x0,
    0x3fe06ae1def0586d, 0x0,
    0x3fe7335104cc62ae, 0x0,
    0x3fdcb4cc63bc2ebc, 0x0,
    0x3fa2f9212b657dc5, 0x0,
    0xbfdb55f3f0c98cdd, 0x0,
    0xbfe6ddd729533708, 0x0,
    0xbfe2076f4e5f3b5c, 0x0,
    0x3f8049898327d1ad, 0x0,
    0x3fe1444627643bf2, 0x0,
    0x3fe74425861a7bda, 0x0,
    0x3fdcb01fd7577516, 0x0,
    0xbfaa6c84e3f4e41d, 0x0,
    0xbfdf2adbf20c600c, 0x0,
    0xbfe35746a6978ec2, 0x0,
    0xbfe0c2e2c1393078, 0x0,
    0xbf80eb921792ec0c, 0x0,
    0x3fe203242c67e76f, 0x0,
    0x3fe5489288a9d3c4, 0x0,
    0x3fddfeec20f02af2, 0x0,
    0x3f6879017b8297cd, 0x0,
    0xbfe08b892b572016, 0x0,
    0xbfe482aa7ff85ba8, 0x0,
    0xbfe1d4d6138dce30, 0x0,
    0xbfb1a4358edccdc3, 0x0,
    0x3fe222051b425be2, 0x0,
    0x3fe6280a79f2b7fc, 0x0,
    0x3fe143749afd069d, 0x0,
    0x3f832bc43417f057, 0x0,
    0xbfda994777144d54, 0x0,
    0xbfe6e6e876328d4b, 0x0,
    0xbfdd2353de23599b, 0x0,
    0x3f8ed36318583bb9, 0x0,
    0x3fddf6c4228cb042, 0x0,
    0x3fe67e9e91763085, 0x0,
    0x3fe057995f5591c0, 0x0,
    0x3f7b170bb50c5966, 0x0,
    0xbfe08ec9abddc811, 0x0,
    0xbfe8b036152e5110, 0x0,
    0xbfe2af539ba7a8a7, 0x0,
    0xbf86aac302f53b2d, 0x0,
    0x3fde6959b487803b, 0x0,
    0x3fe65c1f40693774, 0x0,
    0x3fdd98b84de0ba99, 0x0,
    0x3fb2d0a3928db5e6, 0x0,
    0xbfdc222f08abacf6, 0x0,
    0xbfe84e7b275e5893, 0x0,
    0xbfdf792ae2f9252b, 0x0,
    0x3fb19fa49f518298, 0x0,
    0x3fe09f3556a060f9, 0x0,
    0x3fe55a14b6f1a3f3, 0x0,
    0x3fdbbe8a2af4d87c, 0x0,
    0xbf9a3ecfc659a2b2, 0x0,
    0xbfe3728a70f2446c, 0x0,
    0xbfe4c33d28f98411, 0x0,
    0xbfdf9a1600f0b373, 0x0,
    0x3fa20c9537fa909b, 0x0,
    0x3fde95cf138d994a, 0x0,
    0x3fe66f96ca8ced52, 0x0,
    0x3fe036b6111bd69e, 0x0,
    0xbfa6783b8cd6dc4f, 0x0,
    0xbfde593a0c94d800, 0x0,
    0xbfe51e8ffcfae262, 0x0,
    0xbfe109c8788dcd6f, 0x0,
    0xbfa04d0590c79b71, 0x0,
    0x3fdf9acec867e6a0, 0x0,
    0x3fe7b5b1aced93ba, 0x0,
    0x3fe02eb0bba837b9, 0x0,
    0xbfb65158a49d95a8, 0x0,
    0xbfdc53c8c4ce12ca, 0x0,
    0xbfe46b5a3df2a63d, 0x0,
    0xbfe07b26cd7c42d3, 0x0,
    0x3f89b277e3ff5d70, 0x0,
    0x3fe0eb930463933b, 0x0,
    0x3fe9497a0156ac76, 0x0,
    0x3fe0b119e8636181, 0x0,
    0x3f50d5b8a43d16ad, 0x0,
    0xbfe06c409409f4d8, 0x0,
    0xbfe4e8076c424100, 0x0,
    0xbfdf2869bbe74bb9, 0x0,
    0x3f8f0cfd1f6a0628, 0x0,
    0x3fe2305241126aea, 0x0,
    0x3fe7785cba18d39a, 0x0,
    0x3fe079b8640d401e, 0x0,
    0x3f7ec0733c0dd438, 0x0,
    0xbfd9fee61b984c8f, 0x0,
    0xbfe759be158ebb9e, 0x0,
    0xbfddfe635eee5b82, 0x0,
    0x3fa6c43352d88556, 0x0,
    0x3fe2601dd4da2506, 0x0,
    0x3fe5ef7d28e50813, 0x0,
    0x3fdfbe04269aab21, 0x0,
    0x3f9832c6403aabf5, 0x0,
    0xbfe176e17b1e2540, 0x0,
    0xbfe83f8704b32d6e, 0x0,
    0xbfe246b4d13eb0ac, 0x0,
    0xbf96cdc7bb3a049e, 0x0,
    0x3fdbcbba0943d1a2, 0x0,
    0x3fe4496e60e29353, 0x0,
    0x3fde8e580354bcad, 0x0,
    0x3fa78466476fe88e, 0x0,
    0xbfde70baae57cb01, 0x0,
    0xbfe6107ec4caf4d5, 0x0,
    0xbfdc1c9c0d94cf33, 0x0,
    0x3f8f9cd7cd588482, 0x0,
    0x3fe06b35daf1775a, 0x0,
    0x3fe719badc1e58ae, 0x0,
    0x3fe47f0df1446704, 0x0,
    0x3f800adc2e5006ca, 0x0,
    0xbfd944f77c97aa72, 0x0,
    0xbfe4bff1e88fb3a8, 0x0,
    0xbfe1073e9d8b9f7f, 0x0,
    0x3fae4a2d67c0b400, 0x0,
    0x3fdf3818f2e3cc1d, 0x0,
    0x3fe8eb0738061d6a, 0x0,
    0x3fe03030af2f5883, 0x0,
    0xbf58f32e3407bc38, 0x0,
    0xbfddd7b8cb558fdf, 0x0,
    0xbfe848275a3c589c, 0x0,
    0xbfe0f585c61fc4fa, 0x0,
    0x3fa2942e092ed21e, 0x0,
    0x3fe0ea2b47a56acd, 0x0,
    0x3fe90c5a67849c2e, 0x0,
    0x3fe045093d14478d, 0x0,
    0x3fb3ac5e6d14a5d2, 0x0,
    0xbfdd0726842c00e4, 0x0,
    0xbfe6e21791d5e93c, 0x0,
    0xbfda00dce6da7bbd, 0x0,
    0xbfa325cbc5d5e08a, 0x0,
    0x3fe0e770a79944c9, 0x0,
    0x3fe8a5f80a589d67, 0x0,
    0x3fdd578302e313e0, 0x0,
    0x3f9c0bb7f65385d8, 0x0,
    0xbfdf2ec4bfcbc632, 0x0,
    0xbfe60567eb07b34a, 0x0,
    0xbfe040c9568bee95, 0x0,
    0xbf91b7c60d4faf7f, 0x0,
    0x3fe08715030c19d3, 0x0,
    0x3fe65831699a5b7a, 0x0,
    0x3fdf5314f233f121, 0x0,
    0x3f87e70c62609e0c, 0x0,
    0xbfde20b038f9348a, 0x0,
    0xbfe5043e25c58dfd, 0x0,
    0xbfdec22a03cb3eb2, 0x0,
    0xbfa4adcbf9f4d562, 0x0,
    0x3fe0084af44f3911, 0x0,
    0x3fe8080490336b34, 0x0,
    0x3fe0109bce434ce5, 0x0,
    0xbf9af7b3d2412426, 0x0,
    0xbfe11f396d5de52b, 0x0,
    0xbfe5a9765170d441, 0x0,
    0xbfe19b77f6520264, 0x0,
    0x3fb5ef4164209aaf, 0x0,
    0x3fdf3a7335780ef4, 0x0,
    0x3fe59e6fb5061b2c, 0x0,
    0x3fdd244276610316, 0x0,
    0x3f95c417059f5f70, 0x0,
    0xbfdc66dd5517cbca, 0x0,
    0xbfe7c3372a735f04, 0x0,
    0xbfe03ff8f3d61247, 0x0,
    0x3f8edc8e0c89a350, 0x0,
    0x3fd95cc3673a4ea8, 0x0,
    0x3fe2a2ae5d22b682, 0x0,
    0x3fe02d48c73a1c9c, 0x0,
    0xbfb4ba71f5e51eaf, 0x0,
    0xbfdc55f04f96e1c5, 0x0,
    0xbfe5641c921f086c, 0x0,
    0xbfdf829bccaef327, 0x0,
    0x3fb065d2b190d883, 0x0,
    0x3fde72380bfef030, 0x0,
    0x3fe2df48a2427c7a, 0x0,
    0x3fe137ec2a46f55d, 0x0,
    0x3f50f0e5e05a5268, 0x0,
    0xbfdda0e6f8527474, 0x0,
    0xbfe4b491adda31fe, 0x0,
    0xbfdca26b7cd50d02, 0x0,
    0xbf9dacb327ebd607, 0x0,
    0x3fdefeec2534e804, 0x0,
    0x3fe6eb68fa545dbb, 0x0,
    0x3fde1badcc424cc0, 0x0,
    0xbf857acb72fc9637, 0x0,
    0xbfe0b829d9c0366b, 0x0,
    0xbfe59a3d4c6db38a, 0x0,
    0xbfdc67da7b81df13, 0x0,
    0xbf7b76fcdbe3a92d, 0x0,
    0x3fdcf3a2bfa52939, 0x0,
    0x3fe4799843e478b0, 0x0,
    0x3fe13a4ebc82c63b, 0x0,
    0xbf9e6823e15322c2, 0x0,
    0xbfe1175ee7dd1587, 0x0,
    0xbfe813964723f3ec, 0x0,
    0xbfdc45aaf17756ee, 0x0,
    0xbf72a5131f660583, 0x0,
    0x3fe38e222e1a5123, 0x0,
    0x3fe889cd12338469, 0x0,
    0x3fdf9667385509aa, 0x0,
    0x3fa5164a89221939, 0x0,
    0xbfe0d16ae6b417c3, 0x0,
    0xbfe51887676f0f29, 0x0,
    0xbfe026c35e8481c6, 0x0,
    0x3fa68dad72e3a276, 0x0,
    0x3fdcd7c6e01b7815, 0x0,
    0x3fe56d147855e2a3, 0x0,
    0x3fdb618efa7b5680, 0x0,
    0x3fa0d64df40c3b60, 0x0,
    0xbfda9b80077f9163, 0x0,
    0xbfe7443be8dc88a0, 0x0,
    0xbfe0dd0b5864dfa3, 0x0,
    0xbfb32f6f94cbe1e1, 0x0,
    0x3fdf39846c7ef77f, 0x0,
    0x3fe31c071cf83d92, 0x0,
    0x3fdf11f85520419f, 0x0,
    0x3fb984a614b0a8e1, 0x0,
    0xbfdd4a3c7a169583, 0x0,
    0xbfe6ed21f8e2c150, 0x0,
    0xbfdd130ab22d1780, 0x0,
    0x3f84f03d7ff18eba, 0x0,
    0x3fddcbf4da9a19e4, 0x0,
    0x3fe2c8a013f40085, 0x0,
    0x3fe0b3f4cdf71cff, 0x0,
    0x3fa4e1b2d41eda28, 0x0,
    0xbfe04fa9cdb21388, 0x0,
    0xbfe62d76f1cf503b, 0x0,
    0xbfe29e8c16ca9fc3, 0x0,
    0x3fb1400de6557d50, 0x0,
    0x3fdb47a9fed0a59e, 0x0,
    0x3fe87883853ad291, 0x0,
    0x3fdc6943fb1b5002, 0x0,
    0x3f8cb620550afe77, 0x0,
    0xbfdef070a5b6a990, 0x0,
    0xbfe7c3777e422b54, 0x0,
    0xbfe22d58025d27f6, 0x0,
    0x3fc0d625a8b7f714, 0x0,
    0x3fe01ca7ecf14111, 0x0,
    0x3fe613ce9e5cc1f7, 0x0,
    0x3fd9438737730b95, 0x0,
    0x3fa30c76bdd2bc42, 0x0,
    0xbfda8f3a3050c56b, 0x0,
    0xbfe918135c5050df, 0x0,
    0xbfded245403f272b, 0x0,
    0xbfb387b0994d5659, 0x0,
    0x3fdee8ff779f5308, 0x0,
    0x3fe6f0bd47f692b3, 0x0,
    0x3fe3c23dfcd9939a, 0x0,
    0x3fa67dc0320e5824, 0x0,
    0xbfe179e0edb6a617, 0x0,
    0xbfea052aae741374, 0x0,
    0xbfe0f777be8c74e4, 0x0,
    0x3fb2176bc3007415, 0x0,
    0x3fdbb5e6fd73bbc0, 0x0,
    0x3fe9835e7621d56a, 0x0,
    0x3fdb9cf9d9ecf065, 0x0,
    0xbf946d127e367d20, 0x0,
    0xbfe1cf1ac53b55c9, 0x0,
    0xbfe66ca1945acce9, 0x0,
    0xbfe2581cc3a04f18, 0x0,
    0xbf8e9598461cb363, 0x0,
    0x3fde7ffdd1181ef9, 0x0,
    0x3fe69dfb75716f5f, 0x0,
    0x3fe110ed8416e05d, 0x0,
    0x3fa4088b7854cf92, 0x0,
    0xbfdcaf69162b7895, 0x0,
    0xbfe675208e111c77, 0x0,
    0xbfdd5f382642fe53, 0x0,
    0xbf8ea819d6040081, 0x0,
    0x3fe169bb749803d0, 0x0,
    0x3fe7fba59792ef7c, 0x0,
    0x3fddf3990cc9289c, 0x0,
    0x3fb02d0ddffdec84, 0x0,
    0xbfe17c3505b71a35, 0x0,
    0xbfe75c70c51fab01, 0x0,
    0xbfe2ab4b7fa698ca, 0x0,
    0x3fa1fc888420b74c, 0x0,
    0x3fde9b7e57377b13, 0x0,
    0x3fe4b34893878f85, 0x0,
    0x3fe094f42b3edefb, 0x0,
    0xbfb6bd208dbe8bc7, 0x0,
    0xbfdefb3090b964b3, 0x0,
    0xbfe77569652f0918, 0x0,
    0xbfddb548927f2635, 0x0,
    0x3f82066ad8224010, 0x0,
    0x3fdbdd5608c4deaa, 0x0,
    0x3fe6f9bb9536b000, 0x0,
    0x3fdde9fda760f8ae, 0x0,
    0xbf2f3eaf2398aba1, 0x0,
    0xbfe083d5f19ddd5a, 0x0,
    0xbfe6466e192d1965, 0x0,
    0xbfdcd801be00e2ca, 0x0,
    0x3f44222404e04149, 0x0,
    0x3fe02ad2f329e5da, 0x0,
    0x3fe69c09cd86fb18, 0x0,
    0x3fd8ad5f4e56fa34, 0x0,
    0xbfadbcacce599137, 0x0,
    0xbfe156ebfb373223, 0x0,
    0xbfe58013cd3217f3, 0x0,
    0xbfe04f0b68427379, 0x0,
    0xbfa322c43da99716, 0x0,
    0x3fe31c3f763ebcc8, 0x0,
    0x3fe64447a50eaebb, 0x0,
    0x3fe285a2c86f39e9, 0x0,
    0xbfa9aaa358cfcf68, 0x0,
    0xbfdf0c0e57920d67, 0x0,
    0xbfe685fe799c57bd, 0x0,
    0xbfe01b5fc0c29567, 0x0,
    0xbf8bdff4d72a58ee, 0x0,
    0x3fe011a83bb3b8e2, 0x0,
    0x3fe3e04bde4b342c, 0x0,
    0x3fe00260ae4c8a08, 0x0,
    0x3fa52daa7b67a34e, 0x0,
    0xbfdd7b46b9f4c575, 0x0,
    0xbfe8d0343ab770cd, 0x0,
    0xbfe02457b853a19e, 0x0,
    0xbfb219b141776de6, 0x0,
    0x3fda3f31901abfa5, 0x0,
    0x3fe48634e6390fa8, 0x0,
    0x3fd9ed7cb98f4a98, 0x0,
    0xbf8af01264ced1a3, 0x0,
    0xbfe15ac888a8a96a, 0x0,
    0xbfe6e6b4c6cc8502, 0x0,
    0xbfe18d9bdebf918f, 0x0,
    0xbfa4e4402cedc71a, 0x0,
    0x3fdad429465d56ca, 0x0,
    0x3fe55b2697545d35, 0x0,
    0x3fde60a8405d8c4c, 0x0,
    0xbf7c41091ffbd525, 0x0,
    0xbfe116e42f3c8b1d, 0x0,
    0xbfe483347651b7cc, 0x0,
    0xbfdbfff7d664d090, 0x0,
    0x3fa410e6b462f324, 0x0,
    0x3fdcf701218c4394, 0x0,
    0x3fe5b53b87df9aed, 0x0,
    0x3fe2ea09c08af485, 0x0,
    0x3f9619f7bce621c8, 0x0,
    0xbfe00ab13658f018, 0x0,
    0xbfe7a1483c6bca34, 0x0,
    0xbfdb995f16639698, 0x0,
    0xbf71e372af001307, 0x0,
    0x3fde47fbcc97155d, 0x0,
    0x3fe6bc00dc7ec929, 0x0,
    0x3fdde93dc1601c11, 0x0,
    0x3f7af4fe989ae421, 0x0,
    0xbfdd79238d5a1925, 0x0,
    0xbfe457f7eec3f566, 0x0,
    0xbfdceea7f196e675, 0x0,
    0x3fae095b77f23ee0, 0x0,
    0x3fe0794568750c7d, 0x0,
    0x3fe58d7ff0558d2a, 0x0,
    0x3fdcafc862f3946a, 0x0,
    0x3f89ab53eb627798, 0x0,
    0xbfe0e4fcfbdba56f, 0x0,
    0xbfe6a17c30892cb2, 0x0,
    0xbfe16e9f244f6404, 0x0,
    0x3f82eadc52fc3bac, 0x0,
    0x3fe16a428a12ea95, 0x0,
    0x3fe721323acc7d6f, 0x0,
    0x3fe1931290c4359f, 0x0,
    0x3fb48699e7082cef, 0x0,
    0xbfd9d982148b5d36, 0x0,
    0xbfe39e4f5005e7e9, 0x0,
    0xbfe0f33089da639f, 0x0,
    0xbf8bc0cdbc8b3bea, 0x0,
    0x3fdf8b8cdbad66a0, 0x0,
    0x3fe6b2e042f4699c, 0x0,
    0x3fe0b71b0c19e0de, 0x0,
    0xbfa690a4ebdd378d, 0x0,
    0xbfe02cc35d00250f, 0x0,
    0xbfe721ea333e412a, 0x0,
    0xbfdfe3ada1e2fedd, 0x0,
    0x3f9fc1fbea73e82f, 0x0,
    0x3fdfe8842d0da6b5, 0x0,
    0x3fe7a668ccbf40a2, 0x0,
    0x3fdeb1c470c3649e, 0x0,
    0xbfb870f9480b2021, 0x0,
    0xbfdd93e77f4bc32b, 0x0,
    0xbfe5da61b1871cbe, 0x0,
    0xbfe18b2781314882, 0x0,
    0xbfbcc2bb581a4962, 0x0,
    0x3fdfb1db593ca861, 0x0,
    0x3fe4e468151cc34a, 0x0,
    0x3fe3a05a7ae95797, 0x0,
    0xbf9ab12a9d8d7cd8, 0x0,
    0xbfda3e7921dc8114, 0x0,
    0xbfe57b23a01eafe2, 0x0,
    0xbfda8626780f5995, 0x0,
    0x3fb2125cf286ddea, 0x0,
    0x3fe27e211ed7a26b, 0x0,
    0x3fe839bd9a4b6c69, 0x0,
    0x3fdfc63c7e53a760, 0x0,
    0xbfbbcc80b7809bfc, 0x0,
    0xbfdf061ab7a52dff, 0x0,
    0xbfe8c1912e1659b7, 0x0,
    0xbfdc3a29c8c4feab, 0x0,
    0xbf99e47908a532ee, 0x0,
    0x3fe09d9dc4b1c426, 0x0,
    0x3fe50675c789cd07, 0x0,
    0x3fde5b5a71e1dbf3, 0x0,
    0x3fa7f1343872c2fe, 0x0,
    0xbfe0c27fedd87eef, 0x0,
    0xbfe4fdad5d8a9282, 0x0,
    0xbfdd328f3b00fd97, 0x0
    };

static const uint64_t in_cifft_noisy_512[1024] = {
    0x3ff1b860aa8827bc, 0x0,
    0xbfc3823e39686e29, 0xbff752fdc523ec68,
    0x3ffbb276927f5c88, 0x3fe07fc3eab9f75b,
    0x3fd1b8135a598065, 0xbfdd9703f343934c,
    0xbfdb8588232544a1, 0x3ff801cbe79bb7b6,
    0xbfb7d6617bca3d20, 0x3fad48c10fc5be88,
    0xbfed75b1ba8ed3e4, 0x3fc69447c8191c50,
    0x3fd5b434b8e42ab8, 0xbff0946929057114,
    0x3fe7bc7ed88d819b, 0xbfb89f807992bb52,
    0x3fe178418b0d6624, 0xbff62b36d7c66238,
    0xbfd5682316cc9b1b, 0x3ff1d1c57ce9fe91,
    0x3fdfe550eb249abb, 0x3fed79a99cfdbd76,
    0xbfe1c7615c10140e, 0x3fc9e9b7239132cd,
    0xbfe2269038e5dd5c, 0x3fdb2013bbe679a7,
    0x3fda076703e23c5c, 0xbff631296000b8fb,
    0xbfadc564c268512d, 0x3fb29d587e3109b8,
    0x3fe33131889a74ee, 0x3ff327fa514b359d,
    0xbff507e071a4d878, 0xbfc8c94e1b07e57c,
    0xbfd2e2e4bd1804b4, 0xbf9b512ffe5fb888,
    0xbfe11e6ab2e5206a, 0xbfff76ce00c63089,
    0xbff4f30ccd7e9bb7, 0xbff668b141ef2311,
    0xbfda56648b1fd0f3, 0xbfdd77f2ba60d5d0,
    0x3fd27164c528f5fe, 0xbff973475ddf531e,
    0x3fd663eafa94bd91, 0x3ff501e67a247721,
    0xbff1f4dde7ebaefb, 0xbff6433bc49a8e05,
    0x3fa817009c21228a, 0x3fb2d919b56c6cc4,
    0x3ff0ffb089020384, 0xbfef1b39dd139ff8,
    0xbfe36dc12d97c5b2, 0x3fb4fa776aa8ece0,
    0xbfd5fdaca2565c95, 0x3ffd69e4263e1907,
    0xbfdb4093fe0f9147, 0xbfb3d7e762f4abcc,
    0x3ff16ec7b314045a, 0x3ff8d3a3b9334ee6,
    0x3fdc59dd47731f30, 0x3fe8564a31f8bc65,
    0x3fe09d4e2f8c0939, 0x3fd3e2f9d060869e,
    0x3ffc77482ef8c748, 0xbff3f8ff6df6f4c8,
    0xbfc75e28f3acba52, 0xbfd4ed7b13348dda,
    0x3feb236c87ce0a42, 0x3ff1161aa0bc21f1,
    0x3ffa1aebbe322de4, 0x3ff3f1d51c145855,
    0x3fb42063a7d70e3a, 0x3fc3299ebbd4ffa4,
    0xbfefa66d6e426c48, 0x3ffec1fee329557e,
    0xbfe4df048d731cc1, 0x3fe51699a4e6afa4,
    0xbfe33ae7fc783092, 0x3fec1386af95b68c,
    0xbfed05d6770358f1, 0x3fe130c19e506057,
    0xbfdb113d7cf27128, 0x3fd951e7f7db4534,
    0xbfe99b5e145aa7c1, 0xbfdfbbc1f2b9199b,
    0x3fd1b24df355d287, 0xbfea81dd6ed0ce14,
    0x3fe42a16f44ce7ae, 0x3fe6ded7f0f973dd,
    0x3fe935d647a800ae, 0x3f90220eaa85a880,
    0xbfd47dfc68baf352, 0x3fd6037bb2f3e04b,
    0x3fcd3e8ef422e1e5, 0xbfcf84cf7638799c,
    0xbfa44a5bdc2042c1, 0xbff856876ed4d54a,
    0x3fd253201a030bd0, 0x3fca8724e3678e13,
    0xbff0a9efe61af908, 0x3fcb9347fad8508c,
    0x3fd58c33805e128a, 0x3fca1687c3f00cf0,
    0xbfe55c572d5437ef, 0x3fbdbdc63826fe2a,
    0x3fc4a2b042b25628, 0xbffa7bf8d2218187,
    0x4000f84e2cb79d68, 0x3fdf137ccd6a5570,
    0xbfc82384392bc04c, 0xbfb8f576ee8b5260,
    0xbfb007b28b8029f0, 0xbfd1cfbbffdff40a,
    0xbf9e029a05b71990, 0x3fcaff7a82066b03,
    0x3fd36ff369aa95d0, 0xbfe982f78b215a86,
    0xbfef66938554e52e, 0xbfba5ab149ea06a0,
    0x3fe75b7c2b246898, 0xbfea0cc81f27cdbc,
    0xbfe0e751c795f3a4, 0x3fe3cdd9be73bd0f,
    0x3fe580472ee9fefb, 0x3fe00e29d53bcc8c,
    0xbfa9a203a1c7eba6, 0xc06661091e0bde98,
    0x3fc18c0d250748a0, 0xbfd8b8b16a614130,
    0x3fc3bdefd041e34a, 0x3fda5f45afb9410b,
    0xbff66fb9dfade9d0, 0xbfe9afa2b47907eb,
    0x3ff2fbae791674fa, 0xbff10709d00e3076,
    0x3fc5870671b873f4, 0x3ff417cdd0d45e39,
    0xbfbe9c057dfc2b64, 0x3fa1bf76b350b010,
    0xbfef6cc78a68ce69, 0xbfbbb01f198ab9d4,
    0x3fe2f7f24c0685f4, 0x3ff4ce72a0fbeb03,
    0x3fba82853f62b478, 0x3feeb3da8c0b31ca,
    0x3ff262bcaf44df10, 0x3fd91d052b8a2e32,
    0xbfe0da939f1c7f38, 0x3fdcf2f70335ebb3,
    0xbfc9b4fe49bca8e3, 0xbfc17ca95ace985b,
    0x3fd6a9ee427a5c2f, 0xbfc60fc5a6df42c5,
    0xbffd66967ef288f8, 0xbfdfe98063bfafa4,
    0x3fe40df1750c83d3, 0x3ff57002dcc25792,
    0xbfd164bffd7e467e, 0x3fe02076b0e85c5a,
    0x3fe116be552bab58, 0xbfa5b1bb27bd2e10,
    0x3fe1a45a9579b3c8, 0x3fec6f14ea1f227a,
    0xbfe0b8541dd07d2c, 0x3fe7c24aae5957fc,
    0xbfd1e63b4a08e469, 0xbfe5043f2ae436d0,
    0x3faf65601d7885c0, 0x3ff6814c43ce50e6,
    0xbfedc4f30036d4de, 0x3fe43707a2072c99,
    0xbff05c4b7e915d22, 0xbfdb97e7b3cafb15,
    0xbfcd092e4f6db927, 0xbfd21756954ae3e2,
    0x3f9a03a530ea8dc0, 0x3fa08becbb4751d8,
    0xbffc149cc1de0948, 0xbfd7c4bebb090d2e,
    0x3fa64f51f3c32c78, 0xbfdcd6e5f6d32a3c,
    0x3fe1894a3335b3f7, 0x3fedc061927a8848,
    0xbfebf36b3edadc28, 0xbfe0a1642fa4f378,
    0xbfd85bbfe16806b6, 0xbffbafcd089d52b6,
    0x3fd4086dbe2e08a7, 0x3fe9c291516ea8c8,
    0xbfb6f17f32c4230c, 0xbfc5e3ce06e4568f,
    0x3ffc1339a5851491, 0xbfd01779943ace8f,
    0x3fca4105380ca084, 0x3fbdd3d38b810278,
    0xbfd70829f35b42fc, 0xbfc9474379b4575f,
    0xbff2447662b1c215, 0x3fe1f2a4e59aeb12,
    0x3fecbf24a672c6e0, 0x3ff103a04d0fe9e8,
    0xbfe17628dff397dd, 0x3ff49c9bb7bede48,
    0xbfeb622638bd1088, 0x3fce78698819138d,
    0x3fe38c00b322a8d6, 0x3fd4aeaae88f10d0,
    0x3ff06756bdd3dca6, 0x3f905ed0633d4b98,
    0x3fd1317cadf5b630, 0x3fe0aec488eb4a10,
    0x3fd85c7cbc2a45ea, 0x3fdc5d335ff9e175,
    0xbfd02ee622a79780, 0x3f8a128152944b40,
    0xbfdc6971eeeadc03, 0x3fc287537103fc48,
    0x3fdf587641ba18c0, 0xbfdd260ff99466a2,
    0x3ff490af510a2934, 0x3fd921e996b7df0c,
    0x3fb0bc4da20c3a22, 0x3fe38dba3954bcfe,
    0x3febca9053abf584, 0x3fbb27c49f367e28,
    0x3fd4b0a711a5c384, 0x3fe91729d5156694,
    0x3feb0bc618703152, 0xbff3f159baa751fb,
    0xbfd0ae69feeac8ae, 0xbff541ae2a866068,
    0x3fbd0cd700fbf985, 0xbfd4d8c354011b90,
    0x3ff0330d1ab1efc2, 0xbf304f9717326800,
    0x3fdcc548ad85be8f, 0xbff7b434084fdc26,
    0xbfbe3e95555b402a, 0x3ff0bdc0badddaab,
    0x3fe0a27186140def, 0x3ff6f1b0fdea5566,
    0x3fdfaa767796159e, 0x3fe173d3d6ea1fff,
    0x3fe83b54043b3357, 0x3fe885185d7bd172,
    0xbfec00e32ee04360, 0xbff04e2e4d5bc21a,
    0x3fa5acf82c84ec98, 0xbfebb1a7f3598728,
    0xbfdd28b3726aaa7d, 0x3ff344abf9ee80f1,
    0x3fba88fcab1aec40, 0xbfe292e406de49d8,
    0x3fe2dfd20b0eaa57, 0xbff1ef69573a1370,
    0xbff6279adbbff800, 0x3fed36be70668543,
    0xbfd0e9484edd0d56, 0xbfdf55897050ea80,
    0x3fe121ab46b63b80, 0xbfdb2b994ea118af,
    0x3fb838f07447ddfc, 0xbfd4f1f8d69ce299,
    0xbfd46ff1b01f6c5a, 0xbfec48fa826f3a64,
    0x3ff155d0b319b07f, 0xbfb73ec5f5841e3c,
    0x3ff5ced2b7b1c4b6, 0x3fe885897319a8a1,
    0xbfdb2a865141102a, 0xc000d18c237c9237,
    0xbfe60cc41da4b318, 0x3fea6edc49ea4ee0,
    0x3f626bc7dfc83600, 0xbff3fde80da1215b,
    0xbfd0201de7ed670b, 0xbff95fa639f0548b,
    0xbfe07aa8406cd8fe, 0x3fd066928cc1c640,
    0x3fe59d1a63d4c974, 0x3fc0650438c9649c,
    0xc0027160b5989242, 0x3ff1147e5ed80e2c,
    0xbfe6e3dbe13289fe, 0x3fe1206917987f19,
    0x3fd75f96c8cc2c38, 0x3fe1412db0bcbc3c,
    0x3fb8bde3481859b0, 0x3ffed1fad6d84f8e,
    0xbfe469f746344e6c, 0xbfd2b61f6bf22dae,
    0x3ff1bf7942a016d4, 0xbfcbd8afce572cb8,
    0xbfb8842981c2dac2, 0xbfd0275e852d3c75,
    0xbfe4aa03166a2a1a, 0xbfe111609ef52be7,
    0x3fea825e1fa755a6, 0x3fe523c23937d13c,
    0xbfe5972ed85bd4ff, 0xbf92889ba92304d0,
    0xbfea43955ac8c90e, 0x3fe43d89bf3f7619,
    0x3fd9df3621a3463f, 0x3fd173c47486f841,
    0xbfb36cdc999df2e8, 0x3fdeeb4fe49da324,
    0xbfb091471f0a7040, 0xbfde372e5a536d74,
    0x3fe420b599a7e522, 0x3fee7c9636dffe92,
    0x3ff08c101086778a, 0x3fc81a2e08768520,
    0xbfcde1ce5480d67b, 0x3fd85a7c7ee2096e,
    0x3fd1e867deabfb56, 0xbfbdfca7078756ce,
    0xbfe5ee07f957e6d8, 0x3fd48d38e93863e2,
    0x3fc146912cd64fde, 0xbfc8680e1ebc1296,
    0xbfefcf97c89df701, 0x3feabee965c44ae6,
    0xbfb28745afb846e0, 0xbfb31b6ae3262ab0,
    0x3fe2c786a3838c64, 0x3fcf2a4db11e8b84,
    0xbfebefb5e2a9584c, 0xbfe2069fd201910f,
    0x3fc10c6f997bc95c, 0x3fdfa4f54ef4230b,
    0x3fc4f0d9a4327066, 0xbfe1012f20ad7596,
    0x3fda7c81f917f30f, 0xbfce03cf9b6ae5e6,
    0xbfe2196a00fb6f9d, 0x3fe569616f1f67be,
    0xbfe444542b12e83e, 0xbff0c06ae183da8a,
    0x3fe7c60f277f734a, 0xbfbdca890986d358,
    0x3fe37b8a99fa1f48, 0xbff2212a04637c4a,
    0xbfc8a29ba6e68d38, 0x3f87d684daf11540,
    0xbfc75d4dedbfa5d5, 0xbfdd45e16ad90a9d,
    0x3fc23891e7d88106, 0x3fd4b765a5f298f3,
    0xbfe9421fc62d3546, 0xbfe3a9e7ac15ea8e,
    0xbfecb6f0ac782773, 0x3fd50c64ae030ebe,
    0x3f98299b57da7b00, 0x3fe7eecad7d860bc,
    0x3fedbbc18bbb8f8c, 0x3fd84a4c63c7ad0c,
    0xbfbb708ebbf6fb42, 0xbfb797ba419013be,
    0xbfdd2205790b9672, 0xbff393c519a0ef44,
    0xbfe612c5542e2e02, 0x3fd998fadb5c069d,
    0x3fd54f01a57af3ab, 0xbfebada98e2d0426,
    0xbfdec2baf629b02e, 0xbfcdb4a4a7377278,
    0xbfecad171caa2d6e, 0xbfed093f7d983c3c,
    0xbfdaa980e01b8bef, 0x3fdc5f4466df07ac,
    0xbff95b2a8d213844, 0xbff58b1070f52f16,
    0xbfce548f33043370, 0xbfd631d9cf700518,
    0xbff6afd81c09081a, 0x3fc8f27652a7d986,
    0xbfeffe8f7cf6d3ee, 0x3fc676534a1ec6d1,
    0xbfe6a5cc7c913ffa, 0x3fe01c00e6c15e0c,
    0x3fc066237532b18a, 0x3febf0b5ec984380,
    0xbfed3ec04841f045, 0x3fe2ef6c1a412076,
    0x3fd377cb131fef2f, 0x3ff1bddfd8823f5f,
    0x3fed4b93fbf1cbca, 0x3ff22f8d80d084be,
    0xbfd276a64cbb41c6, 0x3ff7b9f21313748c,
    0x3fe4c50b0000ce21, 0x3fef61c88cda6302,
    0x3fe9750f30628a24, 0x3fc76d31c5a5cf3e,
    0x3fe48d8e9ccdad9c, 0x3fea69b78c887cca,
    0xbff2414bd6333ee6, 0xbff1cb27bd1f5e3e,
    0x3fdb82cef078d992, 0x3fefdccea8008c28,
    0xbff6443fbf0c01c2, 0xbfc0639565e8d000,
    0x3fe400530c4c9937, 0xbfd1241d366f4e85,
    0x3fae2bec299ee3a8, 0xbffee47c2f7256ec,
    0xbff767bac525a599, 0x3ff4408aaacf714c,
    0xbfaa5a9e35830e90, 0xbfc3ce76daa8d6d5,
    0x3f8d1fd5a258d87c, 0xbfba6d89b593d218,
    0x3fd6110fde4f5e8d, 0x3fba53165c940daf,
    0x3fd0c19ace07aca6, 0x3fdf7ee9bec6e11c,
    0x3fd5802d7e48001e, 0x3feba21b6d781b13,
    0xc00314fd96bc90a5, 0xbfed67af5beab509,
    0x3fbf14534528066c, 0xbff05af846960715,
    0x3ff41bcd84610ba4, 0xbfb4ea888c0136e4,
    0xbfb6e5c7d9ca8c5a, 0x3fd9b99f7cb61dfe,
    0x3fdf4ab52b744afc, 0xbfe645d687ecb177,
    0x3fc0117147ff331d, 0xbfe7af077627ce6f,
    0x3fcde631f14f4252, 0xbfefc0f0eb4c7f7c,
    0x3fe6b109563ec9af, 0xbfe894a29985a834,
    0x3fb30f8229534774, 0xbfdc7e33c46c2c87,
    0xbfe43a3b56b8b554, 0xbff0cf4fa47da409,
    0x3fec64021c884251, 0x3fccaf7d1f12e4d8,
    0x3fcba86b745544d4, 0x3fb7c6821cb5e154,
    0x3fd08e65020fcc26, 0xbfc37b14b072ab00,
    0xbfcae0d18a2858aa, 0x3fb81939c07213fd,
    0x3fe806de48909984, 0xbfdf6f717dc60bcb,
    0xbfd16a3d202991b8, 0x3ff3fec11e6f0658,
    0xbff5817a2e626836, 0xbfdd6c38a957cad3,
    0x3fe496f710b52654, 0x3fdc388727917564,
    0x3fff062b1e76699f, 0x3fd4cb7f3d4c71d0,
    0xbff209b95a36afdc, 0x3fdb60111b18c404,
    0x3fc57a1d9471cb9a, 0x3fdce44f78a3ebca,
    0x3fdb2cf84bf55187, 0xbff251d8e971e140,
    0x3fd9303ef7cae096, 0x3ff309d83353e1db,
    0xbff23ee695c7f28a, 0x3fb86b3a231349b0,
    0x3fdd71a2ef5f9774, 0xbff77872f09a97be,
    0x3febd6ec83b86b82, 0x3ff0036e604251df,
    0xbfd04913349de0b9, 0xbff4a46758e5e0f9,
    0x3ff4f6aa5dfe5c10, 0x3fbe53d2743c9a1c,
    0x3fc289275af35494, 0x3ff3ad76dee031cc,
    0xbfe6cd810336d3c2, 0x3f6c349c26c92700,
    0x3fb670a7da315571, 0xbff1c71caa232066,
    0x3fe5698f71fd8bfe, 0x3fe7d750ff556b4a,
    0x3fedb3eb6218083c, 0xbf93c20209d898c0,
    0x3ff5f1631c02f83e, 0x3fd1b89a7f55cb38,
    0xbf73a815c424a6c0, 0x3fdc92dad69a7908,
    0x3fdbe31e64429a7a, 0x3fe85df1b9f6005a,
    0x3fe81248ef9734af, 0xbfb6128e74c7fcc0,
    0x3fd893468a349b3e, 0xbfa3c8aad470d008,
    0xbfd78676a04043a4, 0x3feffa64b3c55e1b,
    0x3fdb8e8ec44daf25, 0x3fed8baf4fa87364,
    0xbff5f696da8d395b, 0x3feb345d1ac9e91b,
    0xbfcf42a424f03e32, 0xbfd65d8e7262f37a,
    0x3fcc1a9410646984, 0x3fdc6948288d36d4,
    0xbff0083fa46b9598, 0x3fde7cbfc825fd5e,
    0xbfe4d818446e28b7, 0xbfb4dfcf6b3799c0,
    0xbfa9169604c2ec90, 0x0,
    0xbfe4d818446e28b5, 0x3fb4dfcf6b3799b0,
    0xbff0083fa46b9598, 0xbfde7cbfc825fd6c,
    0x3fcc1a941064698e, 0xbfdc6948288d36d6,
    0xbfcf42a424f03e3a, 0x3fd65d8e7262f378,
    0xbff5f696da8d395a, 0xbfeb345d1ac9e922,
    0x3fdb8e8ec44daf31, 0xbfed8baf4fa87364,
    0xbfd78676a0404396, 0xbfeffa64b3c55e19,
    0x3fd893468a349b3a, 0x3fa3c8aad470d004,
    0x3fe81248ef9734b4, 0x3fb6128e74c7fcc8,
    0x3fdbe31e64429a8b, 0xbfe85df1b9f6005a,
    0xbf73a815c424a540, 0xbfdc92dad69a7903,
    0x3ff5f1631c02f83f, 0xbfd1b89a7f55cb28,
    0x3fedb3eb6218083c, 0x3f93c20209d89990,
    0x3fe5698f71fd8c04, 0xbfe7d750ff556b4a,
    0x3fb670a7da31554e, 0x3ff1c71caa232064,
    0xbfe6cd810336d3c0, 0xbf6c349c26c92a00,
    0x3fc289275af354a8, 0xbff3ad76dee031cc,
    0x3ff4f6aa5dfe5c0f, 0xbfbe53d2743c99fa,
    0xbfd04913349de0c6, 0x3ff4a46758e5e0f9,
    0x3febd6ec83b86b82, 0xbff0036e604251dd,
    0x3fdd71a2ef5f9769, 0x3ff77872f09a97be,
    0xbff23ee695c7f28e, 0xbfb86b3a231349e0,
    0x3fd9303ef7cae0a3, 0xbff309d83353e1d9,
    0x3fdb2cf84bf55184, 0x3ff251d8e971e141,
    0x3fc57a1d9471cba8, 0xbfdce44f78a3ebc3,
    0xbff209b95a36afdc, 0xbfdb60111b18c411,
    0x3fff062b1e76699f, 0xbfd4cb7f3d4c71c4,
    0x3fe496f710b52656, 0xbfdc388727917554,
    0xbff5817a2e626838, 0x3fdd6c38a957cac9,
    0xbfd16a3d202991b0, 0xbff3fec11e6f0658,
    0x3fe806de48909980, 0x3fdf6f717dc60bd6,
    0xbfcae0d18a2858a8, 0xbfb81939c07213fe,
    0x3fd08e65020fcc20, 0x3fc37b14b072ab0c,
    0x3fcba86b745544d2, 0xbfb7c6821cb5e156,
    0x3fec64021c884250, 0xbfccaf7d1f12e4c0,
    0xbfe43a3b56b8b558, 0x3ff0cf4fa47da407,
    0x3fb30f8229534752, 0x3fdc7e33c46c2c8a,
    0x3fe6b109563ec9ae, 0x3fe894a29985a837,
    0x3fcde631f14f423c, 0x3fefc0f0eb4c7f7c,
    0x3fc0117147ff3316, 0x3fe7af077627ce70,
    0x3fdf4ab52b744af6, 0x3fe645d687ecb17b,
    0xbfb6e5c7d9ca8c48, 0xbfd9b99f7cb61dfa,
    0x3ff41bcd84610ba1, 0x3fb4ea888c0136fc,
    0x3fbf145345280634, 0x3ff05af846960716,
    0xc00314fd96bc90a6, 0x3fed67af5beab4fb,
    0x3fd5802d7e480025, 0xbfeba21b6d781b10,
    0x3fd0c19ace07acaa, 0xbfdf7ee9bec6e11f,
    0x3fd6110fde4f5e8f, 0xbfba53165c940da3,
    0x3f8d1fd5a258d87c, 0x3fba6d89b593d218,
    0xbfaa5a9e35830ec4, 0x3fc3ce76daa8d6d7,
    0xbff767bac525a598, 0xbff4408aaacf7152,
    0x3fae2bec299ee358, 0x3ffee47c2f7256ee,
    0x3fe400530c4c9937, 0x3fd1241d366f4e90,
    0xbff6443fbf0c01c3, 0x3fc0639565e8cfe8,
    0x3fdb82cef078d98c, 0xbfefdccea8008c24,
    0xbff2414bd6333ee8, 0x3ff1cb27bd1f5e3c,
    0x3fe48d8e9ccdada5, 0xbfea69b78c887cc7,
    0x3fe9750f30628a24, 0xbfc76d31c5a5cf31,
    0x3fe4c50b0000ce21, 0xbfef61c88cda62fe,
    0xbfd276a64cbb41bb, 0xbff7b9f21313748c,
    0x3fed4b93fbf1cbcc, 0xbff22f8d80d084bb,
    0x3fd377cb131fef35, 0xbff1bddfd8823f5d,
    0xbfed3ec04841f049, 0xbfe2ef6c1a412078,
    0x3fc066237532b116, 0xbfebf0b5ec984380,
    0xbfe6a5cc7c913ff8, 0xbfe01c00e6c15e0a,
    0xbfeffe8f7cf6d3ee, 0xbfc676534a1ec6da,
    0xbff6afd81c09081c, 0xbfc8f27652a7d994,
    0xbfce548f33043364, 0x3fd631d9cf700512,
    0xbff95b2a8d213844, 0x3ff58b1070f52f13,
    0xbfdaa980e01b8bef, 0xbfdc5f4466df07b0,
    0xbfecad171caa2d73, 0x3fed093f7d983c38,
    0xbfdec2baf629b033, 0x3fcdb4a4a7377278,
    0x3fd54f01a57af3aa, 0x3febada98e2d0426,
    0xbfe612c5542e2dff, 0xbfd998fadb5c069a,
    0xbfdd2205790b967c, 0x3ff393c519a0ef42,
    0xbfbb708ebbf6fb56, 0x3fb797ba419013d6,
    0x3fedbbc18bbb8f92, 0xbfd84a4c63c7ad0a,
    0x3f98299b57da7b40, 0xbfe7eecad7d860ba,
    0xbfecb6f0ac78276f, 0xbfd50c64ae030ec6,
    0xbfe9421fc62d3549, 0x3fe3a9e7ac15ea8a,
    0x3fc23891e7d8810d, 0xbfd4b765a5f298f2,
    0xbfc75d4dedbfa5dd, 0x3fdd45e16ad90a9c,
    0xbfc8a29ba6e68d18, 0xbf87d684daf114e0,
    0x3fe37b8a99fa1f44, 0x3ff2212a04637c4c,
    0x3fe7c60f277f734a, 0x3fbdca890986d380,
    0xbfe444542b12e844, 0x3ff0c06ae183da89,
    0xbfe2196a00fb6f98, 0xbfe569616f1f67be,
    0x3fda7c81f917f310, 0x3fce03cf9b6ae5ec,
    0x3fc4f0d9a432705d, 0x3fe1012f20ad7598,
    0x3fc10c6f997bc95c, 0xbfdfa4f54ef4230a,
    0xbfebefb5e2a9584c, 0x3fe2069fd201910c,
    0x3fe2c786a3838c67, 0xbfcf2a4db11e8b7e,
    0xbfb28745afb846d8, 0x3fb31b6ae3262aa0,
    0xbfefcf97c89df6fd, 0xbfeabee965c44ae4,
    0x3fc146912cd64fd6, 0x3fc8680e1ebc1296,
    0xbfe5ee07f957e6d8, 0xbfd48d38e93863e2,
    0x3fd1e867deabfb54, 0x3fbdfca7078756d4,
    0xbfcde1ce5480d684, 0xbfd85a7c7ee20975,
    0x3ff08c101086778a, 0xbfc81a2e0876850d,
    0x3fe420b599a7e526, 0xbfee7c9636dffe92,
    0xbfb091471f0a705c, 0x3fde372e5a536d72,
    0xbfb36cdc999df2e8, 0xbfdeeb4fe49da326,
    0x3fd9df3621a34641, 0xbfd173c47486f842,
    0xbfea43955ac8c90e, 0xbfe43d89bf3f761a,
    0xbfe5972ed85bd4ff, 0x3f92889ba9230428,
    0x3fea825e1fa755a8, 0xbfe523c23937d136,
    0xbfe4aa03166a2a17, 0x3fe111609ef52be4,
    0xbfb8842981c2dad2, 0x3fd0275e852d3c7a,
    0x3ff1bf7942a016d7, 0x3fcbd8afce572cd8,
    0xbfe469f746344e70, 0x3fd2b61f6bf22dae,
    0x3fb8bde3481859e0, 0xbffed1fad6d84f91,
    0x3fd75f96c8cc2c40, 0xbfe1412db0bcbc3c,
    0xbfe6e3dbe13289f8, 0xbfe1206917987f19,
    0xc0027160b5989240, 0xbff1147e5ed80e2e,
    0x3fe59d1a63d4c976, 0xbfc0650438c96478,
    0xbfe07aa8406cd901, 0xbfd066928cc1c640,
    0xbfd0201de7ed6715, 0x3ff95fa639f05489,
    0x3f626bc7dfc83100, 0x3ff3fde80da1215c,
    0xbfe60cc41da4b310, 0xbfea6edc49ea4ee3,
    0xbfdb2a8651411032, 0x4000d18c237c9236,
    0x3ff5ced2b7b1c4b6, 0xbfe885897319a89c,
    0x3ff155d0b319b07e, 0x3fb73ec5f5841e56,
    0xbfd46ff1b01f6c5e, 0x3fec48fa826f3a62,
    0x3fb838f07447ddf0, 0x3fd4f1f8d69ce2a0,
    0x3fe121ab46b63b80, 0x3fdb2b994ea118b0,
    0xbfd0e9484edd0d57, 0x3fdf55897050ea84,
    0xbff6279adbbff7fc, 0xbfed36be70668548,
    0x3fe2dfd20b0eaa57, 0x3ff1ef69573a1370,
    0x3fba88fcab1aec30, 0x3fe292e406de49db,
    0xbfdd28b3726aaa74, 0xbff344abf9ee80f2,
    0x3fa5acf82c84ec44, 0x3febb1a7f3598728,
    0xbfec00e32ee04364, 0x3ff04e2e4d5bc219,
    0x3fe83b54043b3359, 0xbfe885185d7bd170,
    0x3fdfaa767796159c, 0xbfe173d3d6ea1ffe,
    0x3fe0a27186140df4, 0xbff6f1b0fdea5564,
    0xbfbe3e95555b402a, 0xbff0bdc0badddaaa,
    0x3fdcc548ad85be85, 0x3ff7b434084fdc28,
    0x3ff0330d1ab1efbf, 0x3f304f971732b000,
    0x3fbd0cd700fbf96c, 0x3fd4d8c354011b94,
    0xbfd0ae69feeac8b6, 0x3ff541ae2a866066,
    0x3feb0bc618703148, 0x3ff3f159baa751fa,
    0x3fd4b0a711a5c386, 0xbfe91729d5156693,
    0x3febca9053abf586, 0xbfbb27c49f367e08,
    0x3fb0bc4da20c3a42, 0xbfe38dba3954bcfe,
    0x3ff490af510a2932, 0xbfd921e996b7def8,
    0x3fdf587641ba18b8, 0x3fdd260ff99466a0,
    0xbfdc6971eeeadc09, 0xbfc287537103fc6c,
    0xbfd02ee622a79786, 0xbf8a128152944c60,
    0x3fd85c7cbc2a45ec, 0xbfdc5d335ff9e17c,
    0x3fd1317cadf5b62f, 0xbfe0aec488eb4a12,
    0x3ff06756bdd3dca6, 0xbf905ed0633d4b50,
    0x3fe38c00b322a8d6, 0xbfd4aeaae88f10d0,
    0xbfeb622638bd108a, 0xbfce786988191396,
    0xbfe17628dff397de, 0xbff49c9bb7bede49,
    0x3fecbf24a672c6e4, 0xbff103a04d0fe9e8,
    0xbff2447662b1c213, 0xbfe1f2a4e59aeb16,
    0xbfd70829f35b42fe, 0x3fc9474379b45764,
    0x3fca4105380ca075, 0xbfbdd3d38b810270,
    0x3ffc1339a5851492, 0x3fd01779943ace9e,
    0xbfb6f17f32c42308, 0x3fc5e3ce06e4568f,
    0x3fd4086dbe2e08a3, 0xbfe9c291516ea8c6,
    0xbfd85bbfe16806c6, 0x3ffbafcd089d52b5,
    0xbfebf36b3edadc2a, 0x3fe0a1642fa4f374,
    0x3fe1894a3335b3fc, 0xbfedc061927a8849,
    0x3fa64f51f3c32c40, 0x3fdcd6e5f6d32a42,
    0xbffc149cc1de094a, 0x3fd7c4bebb090d1f,
    0x3f9a03a530ea8dc4, 0xbfa08becbb47521c,
    0xbfcd092e4f6db926, 0x3fd21756954ae3e3,
    0xbff05c4b7e915d22, 0x3fdb97e7b3cafb01,
    0xbfedc4f30036d4de, 0xbfe43707a2072c9c,
    0x3faf65601d7885c8, 0xbff6814c43ce50e6,
    0xbfd1e63b4a08e471, 0x3fe5043f2ae436cc,
    0xbfe0b8541dd07d26, 0xbfe7c24aae5957fd,
    0x3fe1a45a9579b3cd, 0xbfec6f14ea1f2276,
    0x3fe116be552bab58, 0x3fa5b1bb27bd2e18,
    0xbfd164bffd7e467b, 0xbfe02076b0e85c5a,
    0x3fe40df1750c83d9, 0xbff57002dcc25792,
    0xbffd66967ef288f6, 0x3fdfe98063bfaf90,
    0x3fd6a9ee427a5c34, 0x3fc60fc5a6df42c7,
    0xbfc9b4fe49bca8e5, 0x3fc17ca95ace9857,
    0xbfe0da939f1c7f35, 0xbfdcf2f70335ebba,
    0x3ff262bcaf44df13, 0xbfd91d052b8a2e2b,
    0x3fba82853f62b4a4, 0xbfeeb3da8c0b31ca,
    0x3fe2f7f24c0685f5, 0xbff4ce72a0fbeb03,
    0xbfef6cc78a68ce6a, 0x3fbbb01f198ab9cc,
    0xbfbe9c057dfc2b64, 0xbfa1bf76b350b00c,
    0x3fc5870671b87400, 0xbff417cdd0d45e38,
    0x3ff2fbae791674f8, 0x3ff10709d00e307a,
    0xbff66fb9dfade9d0, 0x3fe9afa2b47907e4,
    0x3fc3bdefd041e34a, 0xbfda5f45afb94108,
    0x3fc18c0d250748a8, 0x3fd8b8b16a61412d,
    0xbfa9a203a1c7f9da, 0x406661091e0bde98,
    0x3fe580472ee9fefd, 0xbfe00e29d53bcc86,
    0xbfe0e751c795f3a0, 0xbfe3cdd9be73bd12,
    0x3fe75b7c2b246896, 0x3fea0cc81f27cdc0,
    0xbfef66938554e531, 0x3fba5ab149ea0668,
    0x3fd36ff369aa95ca, 0x3fe982f78b215a86,
    0xbf9e029a05b71950, 0xbfcaff7a82066afa,
    0xbfb007b28b8029ec, 0x3fd1cfbbffdff410,
    0xbfc82384392bc052, 0x3fb8f576ee8b5268,
    0x4000f84e2cb79d69, 0xbfdf137ccd6a5563,
    0x3fc4a2b042b25618, 0x3ffa7bf8d2218188,
    0xbfe55c572d5437ed, 0xbfbdbdc63826fe5c,
    0x3fd58c33805e128e, 0xbfca1687c3f00cec,
    0xbff0a9efe61af907, 0xbfcb9347fad85090,
    0x3fd253201a030bce, 0xbfca8724e3678e0d,
    0xbfa44a5bdc204301, 0x3ff856876ed4d54c,
    0x3fcd3e8ef422e1e9, 0x3fcf84cf7638799c,
    0xbfd47dfc68baf354, 0xbfd6037bb2f3e04c,
    0x3fe935d647a800b1, 0xbf90220eaa85a840,
    0x3fe42a16f44ce7ad, 0xbfe6ded7f0f973db,
    0x3fd1b24df355d27b, 0x3fea81dd6ed0ce12,
    0xbfe99b5e145aa7c3, 0x3fdfbbc1f2b9198f,
    0xbfdb113d7cf27126, 0xbfd951e7f7db4536,
    0xbfed05d6770358f2, 0xbfe130c19e506059,
    0xbfe33ae7fc783091, 0xbfec1386af95b68f,
    0xbfe4df048d731cbe, 0xbfe51699a4e6afa6,
    0xbfefa66d6e426c43, 0xbffec1fee3295580,
    0x3fb42063a7d70e24, 0xbfc3299ebbd4ffa2,
    0x3ffa1aebbe322de6, 0xbff3f1d51c145853,
    0x3feb236c87ce0a4b, 0xbff1161aa0bc21ef,
    0xbfc75e28f3acba60, 0x3fd4ed7b13348ddb,
    0x3ffc77482ef8c746, 0x3ff3f8ff6df6f4cc,
    0x3fe09d4e2f8c093a, 0xbfd3e2f9d060869d,
    0x3fdc59dd47731f2b, 0xbfe8564a31f8bc66,
    0x3ff16ec7b314045e, 0xbff8d3a3b9334ee4,
    0xbfdb4093fe0f9142, 0x3fb3d7e762f4abc4,
    0xbfd5fdaca2565c83, 0xbffd69e4263e1907,
    0xbfe36dc12d97c5b2, 0xbfb4fa776aa8ed08,
    0x3ff0ffb089020382, 0x3fef1b39dd139ffa,
    0x3fa817009c212264, 0xbfb2d919b56c6cd6,
    0xbff1f4dde7ebaefb, 0x3ff6433bc49a8e04,
    0x3fd663eafa94bd96, 0xbff501e67a24771f,
    0x3fd27164c528f5ed, 0x3ff973475ddf531f,
    0xbfda56648b1fd0f6, 0x3fdd77f2ba60d5d2,
    0xbff4f30ccd7e9bb9, 0x3ff668b141ef2311,
    0xbfe11e6ab2e52072, 0x3fff76ce00c63087,
    0xbfd2e2e4bd1804b8, 0x3f9b512ffe5fb810,
    0xbff507e071a4d878, 0x3fc8c94e1b07e570,
    0x3fe33131889a74f0, 0xbff327fa514b359a,
    0xbfadc564c2685106, 0xbfb29d587e3109c0,
    0x3fda076703e23c5d, 0x3ff631296000b8fb,
    0xbfe2269038e5dd60, 0xbfdb2013bbe679b6,
    0xbfe1c7615c10140b, 0xbfc9e9b7239132df,
    0x3fdfe550eb249ac1, 0xbfed79a99cfdbd74,
    0xbfd5682316cc9b0e, 0xbff1d1c57ce9fe94,
    0x3fe178418b0d661d, 0x3ff62b36d7c66238,
    0x3fe7bc7ed88d819b, 0x3fb89f807992bb54,
    0x3fd5b434b8e42ab8, 0x3ff0946929057113,
    0xbfed75b1ba8ed3e2, 0xbfc69447c8191c50,
    0xbfb7d6617bca3d10, 0xbfad48c10fc5be70,
    0xbfdb85882325449b, 0xbff801cbe79bb7b6,
    0x3fd1b8135a598058, 0x3fdd9703f3439350,
    0x3ffbb276927f5c8a, 0xbfe07fc3eab9f756,
    0xbfc3823e39686e41, 0x3ff752fdc523ec66
    };

static const uint64_t ref_cfft_noisy_512[1024] = {
    0x3ff1b860aa8827bc, 0x0,
    0xbfc3823e39686e29, 0xbff752fdc523ec68,
    0x3ffbb276927f5c88, 0x3fe07fc3eab9f75b,
    0x3fd1b8135a598065, 0xbfdd9703f343934c,
    0xbfdb8588232544a1, 0x3ff801cbe79bb7b6,
    0xbfb7d6617bca3d20, 0x3fad48c10fc5be88,
    0xbfed75b1ba8ed3e4, 0x3fc69447c8191c50,
    0x3fd5b434b8e42ab8, 0xbff0946929057114,
    0x3fe7bc7ed88d819b, 0xbfb89f807992bb52,
    0x3fe178418b0d6624, 0xbff62b36d7c66238,
    0xbfd5682316cc9b1b, 0x3ff1d1c57ce9fe91,
    0x3fdfe550eb249abb, 0x3fed79a99cfdbd76,
    0xbfe1c7615c10140e, 0x3fc9e9b7239132cd,
    0xbfe2269038e5dd5c, 0x3fdb2013bbe679a7,
    0x3fda076703e23c5c, 0xbff631296000b8fb,
    0xbfadc564c268512d, 0x3fb29d587e3109b8,
    0x3fe33131889a74ee, 0x3ff327fa514b359d,
    0xbff507e071a4d878, 0xbfc8c94e1b07e57c,
    0xbfd2e2e4bd1804b4, 0xbf9b512ffe5fb888,
    0xbfe11e6ab2e5206a, 0xbfff76ce00c63089,
    0xbff4f30ccd7e9bb7, 0xbff668b141ef2311,
    0xbfda56648b1fd0f3, 0xbfdd77f2ba60d5d0,
    0x3fd27164c528f5fe, 0xbff973475ddf531e,
    0x3fd663eafa94bd91, 0x3ff501e67a247721,
    0xbff1f4dde7ebaefb, 0xbff6433bc49a8e05,
    0x3fa817009c21228a, 0x3fb2d919b56c6cc4,
    0x3ff0ffb089020384, 0xbfef1b39dd139ff8,
    0xbfe36dc12d97c5b2, 0x3fb4fa776aa8ece0,
    0xbfd5fdaca2565c95, 0x3ffd69e4263e1907,
    0xbfdb4093fe0f9147, 0xbfb3d7e762f4abcc,
    0x3ff16ec7b314045a, 0x3ff8d3a3b9334ee6,
    0x3fdc59dd47731f30, 0x3fe8564a31f8bc65,
    0x3fe09d4e2f8c0939, 0x3fd3e2f9d060869e,
    0x3ffc77482ef8c748, 0xbff3f8ff6df6f4c8,
    0xbfc75e28f3acba52, 0xbfd4ed7b13348dda,
    0x3feb236c87ce0a42, 0x3ff1161aa0bc21f1,
    0x3ffa1aebbe322de4, 0x3ff3f1d51c145855,
    0x3fb42063a7d70e3a, 0x3fc3299ebbd4ffa4,
    0xbfefa66d6e426c48, 0x3ffec1fee329557e,
    0xbfe4df048d731cc1, 0x3fe51699a4e6afa4,
    0xbfe33ae7fc783092, 0x3fec1386af95b68c,
    0xbfed05d6770358f1, 0x3fe130c19e506057,
    0xbfdb113d7cf27128, 0x3fd951e7f7db4534,
    0xbfe99b5e145aa7c1, 0xbfdfbbc1f2b9199b,
    0x3fd1b24df355d287, 0xbfea81dd6ed0ce14,
    0x3fe42a16f44ce7ae, 0x3fe6ded7f0f973dd,
    0x3fe935d647a800ae, 0x3f90220eaa85a880,
    0xbfd47dfc68baf352, 0x3fd6037bb2f3e04b,
    0x3fcd3e8ef422e1e5, 0xbfcf84cf7638799c,
    0xbfa44a5bdc2042c1, 0xbff856876ed4d54a,
    0x3fd253201a030bd0, 0x3fca8724e3678e13,
    0xbff0a9efe61af908, 0x3fcb9347fad8508c,
    0x3fd58c33805e128a, 0x3fca1687c3f00cf0,
    0xbfe55c572d5437ef, 0x3fbdbdc63826fe2a,
    0x3fc4a2b042b25628, 0xbffa7bf8d2218187,
    0x4000f84e2cb79d68, 0x3fdf137ccd6a5570,
    0xbfc82384392bc04c, 0xbfb8f576ee8b5260,
    0xbfb007b28b8029f0, 0xbfd1cfbbffdff40a,
    0xbf9e029a05b71990, 0x3fcaff7a82066b03,
    0x3fd36ff369aa95d0, 0xbfe982f78b215a86,
    0xbfef66938554e52e, 0xbfba5ab149ea06a0,
    0x3fe75b7c2b246898, 0xbfea0cc81f27cdbc,
    0xbfe0e751c795f3a4, 0x3fe3cdd9be73bd0f,
    0x3fe580472ee9fefb, 0x3fe00e29d53bcc8c,
    0xbfa9a203a1c7eba6, 0xc06661091e0bde98,
    0x3fc18c0d250748a0, 0xbfd8b8b16a614130,
    0x3fc3bdefd041e34a, 0x3fda5f45afb9410b,
    0xbff66fb9dfade9d0, 0xbfe9afa2b47907eb,
    0x3ff2fbae791674fa, 0xbff10709d00e3076,
    0x3fc5870671b873f4, 0x3ff417cdd0d45e39,
    0xbfbe9c057dfc2b64, 0x3fa1bf76b350b010,
    0xbfef6cc78a68ce69, 0xbfbbb01f198ab9d4,
    0x3fe2f7f24c0685f4, 0x3ff4ce72a0fbeb03,
    0x3fba82853f62b478, 0x3feeb3da8c0b31ca,
    0x3ff262bcaf44df10, 0x3fd91d052b8a2e32,
    0xbfe0da939f1c7f38, 0x3fdcf2f70335ebb3,
    0xbfc9b4fe49bca8e3, 0xbfc17ca95ace985b,
    0x3fd6a9ee427a5c2f, 0xbfc60fc5a6df42c5,
    0xbffd66967ef288f8, 0xbfdfe98063bfafa4,
    0x3fe40df1750c83d3, 0x3ff57002dcc25792,
    0xbfd164bffd7e467e, 0x3fe02076b0e85c5a,
    0x3fe116be552bab58, 0xbfa5b1bb27bd2e10,
    0x3fe1a45a9579b3c8, 0x3fec6f14ea1f227a,
    0xbfe0b8541dd07d2c, 0x3fe7c24aae5957fc,
    0xbfd1e63b4a08e469, 0xbfe5043f2ae436d0,
    0x3faf65601d7885c0, 0x3ff6814c43ce50e6,
    0xbfedc4f30036d4de, 0x3fe43707a2072c99,
    0xbff05c4b7e915d22, 0xbfdb97e7b3cafb15,
    0xbfcd092e4f6db927, 0xbfd21756954ae3e2,
    0x3f9a03a530ea8dc0, 0x3fa08becbb4751d8,
    0xbffc149cc1de0948, 0xbfd7c4bebb090d2e,
    0x3fa64f51f3c32c78, 0xbfdcd6e5f6d32a3c,
    0x3fe1894a3335b3f7, 0x3fedc061927a8848,
    0xbfebf36b3edadc28, 0xbfe0a1642fa4f378,
    0xbfd85bbfe16806b6, 0xbffbafcd089d52b6,
    0x3fd4086dbe2e08a7, 0x3fe9c291516ea8c8,
    0xbfb6f17f32c4230c, 0xbfc5e3ce06e4568f,
    0x3ffc1339a5851491, 0xbfd01779943ace8f,
    0x3fca4105380ca084, 0x3fbdd3d38b810278,
    0xbfd70829f35b42fc, 0xbfc9474379b4575f,
    0xbff2447662b1c215, 0x3fe1f2a4e59aeb12,
    0x3fecbf24a672c6e0, 0x3ff103a04d0fe9e8,
    0xbfe17628dff397dd, 0x3ff49c9bb7bede48,
    0xbfeb622638bd1088, 0x3fce78698819138d,
    0x3fe38c00b322a8d6, 0x3fd4aeaae88f10d0,
    0x3ff06756bdd3dca6, 0x3f905ed0633d4b98,
    0x3fd1317cadf5b630, 0x3fe0aec488eb4a10,
    0x3fd85c7cbc2a45ea, 0x3fdc5d335ff9e175,
    0xbfd02ee622a79780, 0x3f8a128152944b40,
    0xbfdc6971eeeadc03, 0x3fc287537103fc48,
    0x3fdf587641ba18c0, 0xbfdd260ff99466a2,
    0x3ff490af510a2934, 0x3fd921e996b7df0c,
    0x3fb0bc4da20c3a22, 0x3fe38dba3954bcfe,
    0x3febca9053abf584, 0x3fbb27c49f367e28,
    0x3fd4b0a711a5c384, 0x3fe91729d5156694,
    0x3feb0bc618703152, 0xbff3f159baa751fb,
    0xbfd0ae69feeac8ae, 0xbff541ae2a866068,
    0x3fbd0cd700fbf985, 0xbfd4d8c354011b90,
    0x3ff0330d1ab1efc2, 0xbf304f9717326800,
    0x3fdcc548ad85be8f, 0xbff7b434084fdc26,
    0xbfbe3e95555b402a, 0x3ff0bdc0badddaab,
    0x3fe0a27186140def, 0x3ff6f1b0fdea5566,
    0x3fdfaa767796159e, 0x3fe173d3d6ea1fff,
    0x3fe83b54043b3357, 0x3fe885185d7bd172,
    0xbfec00e32ee04360, 0xbff04e2e4d5bc21a,
    0x3fa5acf82c84ec98, 0xbfebb1a7f3598728,
    0xbfdd28b3726aaa7d, 0x3ff344abf9ee80f1,
    0x3fba88fcab1aec40, 0xbfe292e406de49d8,
    0x3fe2dfd20b0eaa57, 0xbff1ef69573a1370,
    0xbff6279adbbff800, 0x3fed36be70668543,
    0xbfd0e9484edd0d56, 0xbfdf55897050ea80,
    0x3fe121ab46b63b80, 0xbfdb2b994ea118af,
    0x3fb838f07447ddfc, 0xbfd4f1f8d69ce299,
    0xbfd46ff1b01f6c5a, 0xbfec48fa826f3a64,
    0x3ff155d0b319b07f, 0xbfb73ec5f5841e3c,
    0x3ff5ced2b7b1c4b6, 0x3fe885897319a8a1,
    0xbfdb2a865141102a, 0xc000d18c237c9237,
    0xbfe60cc41da4b318, 0x3fea6edc49ea4ee0,
    0x3f626bc7dfc83600, 0xbff3fde80da1215b,
    0xbfd0201de7ed670b, 0xbff95fa639f0548b,
    0xbfe07aa8406cd8fe, 0x3fd066928cc1c640,
    0x3fe59d1a63d4c974, 0x3fc0650438c9649c,
    0xc0027160b5989242, 0x3ff1147e5ed80e2c,
    0xbfe6e3dbe13289fe, 0x3fe1206917987f19,
    0x3fd75f96c8cc2c38, 0x3fe1412db0bcbc3c,
    0x3fb8bde3481859b0, 0x3ffed1fad6d84f8e,
    0xbfe469f746344e6c, 0xbfd2b61f6bf22dae,
    0x3ff1bf7942a016d4, 0xbfcbd8afce572cb8,
    0xbfb8842981c2dac2, 0xbfd0275e852d3c75,
    0xbfe4aa03166a2a1a, 0xbfe111609ef52be7,
    0x3fea825e1fa755a6, 0x3fe523c23937d13c,
    0xbfe5972ed85bd4ff, 0xbf92889ba92304d0,
    0xbfea43955ac8c90e, 0x3fe43d89bf3f7619,
    0x3fd9df3621a3463f, 0x3fd173c47486f841,
    0xbfb36cdc999df2e8, 0x3fdeeb4fe49da324,
    0xbfb091471f0a7040, 0xbfde372e5a536d74,
    0x3fe420b599a7e522, 0x3fee7c9636dffe92,
    0x3ff08c101086778a, 0x3fc81a2e08768520,
    0xbfcde1ce5480d67b, 0x3fd85a7c7ee2096e,
    0x3fd1e867deabfb56, 0xbfbdfca7078756ce,
    0xbfe5ee07f957e6d8, 0x3fd48d38e93863e2,
    0x3fc146912cd64fde, 0xbfc8680e1ebc1296,
    0xbfefcf97c89df701, 0x3feabee965c44ae6,
    0xbfb28745afb846e0, 0xbfb31b6ae3262ab0,
    0x3fe2c786a3838c64, 0x3fcf2a4db11e8b84,
    0xbfebefb5e2a9584c, 0xbfe2069fd201910f,
    0x3fc10c6f997bc95c, 0x3fdfa4f54ef4230b,
    0x3fc4f0d9a4327066, 0xbfe1012f20ad7596,
    0x3fda7c81f917f30f, 0xbfce03cf9b6ae5e6,
    0xbfe2196a00fb6f9d, 0x3fe569616f1f67be,
    0xbfe444542b12e83e, 0xbff0c06ae183da8a,
    0x3fe7c60f277f734a, 0xbfbdca890986d358,
    0x3fe37b8a99fa1f48, 0xbff2212a04637c4a,
    0xbfc8a29ba6e68d38, 0x3f87d684daf11540,
    0xbfc75d4dedbfa5d5, 0xbfdd45e16ad90a9d,
    0x3fc23891e7d88106, 0x3fd4b765a5f298f3,
    0xbfe9421fc62d3546, 0xbfe3a9e7ac15ea8e,
    0xbfecb6f0ac782773, 0x3fd50c64ae030ebe,
    0x3f98299b57da7b00, 0x3fe7eecad7d860bc,
    0x3fedbbc18bbb8f8c, 0x3fd84a4c63c7ad0c,
    0xbfbb708ebbf6fb42, 0xbfb797ba419013be,
    0xbfdd2205790b9672, 0xbff393c519a0ef44,
    0xbfe612c5542e2e02, 0x3fd998fadb5c069d,
    0x3fd54f01a57af3ab, 0xbfebada98e2d0426,
    0xbfdec2baf629b02e, 0xbfcdb4a4a7377278,
    0xbfecad171caa2d6e, 0xbfed093f7d983c3c,
    0xbfdaa980e01b8bef, 0x3fdc5f4466df07ac,
    0xbff95b2a8d213844, 0xbff58b1070f52f16,
    0xbfce548f33043370, 0xbfd631d9cf700518,
    0xbff6afd81c09081a, 0x3fc8f27652a7d986,
    0xbfeffe8f7cf6d3ee, 0x3fc676534a1ec6d1,
    0xbfe6a5cc7c913ffa, 0x3fe01c00e6c15e0c,
    0x3fc066237532b18a, 0x3febf0b5ec984380,
    0xbfed3ec04841f045, 0x3fe2ef6c1a412076,
    0x3fd377cb131fef2f, 0x3ff1bddfd8823f5f,
    0x3fed4b93fbf1cbca, 0x3ff22f8d80d084be,
    0xbfd276a64cbb41c6, 0x3ff7b9f21313748c,
    0x3fe4c50b0000ce21, 0x3fef61c88cda6302,
    0x3fe9750f30628a24, 0x3fc76d31c5a5cf3e,
    0x3fe48d8e9ccdad9c, 0x3fea69b78c887cca,
    0xbff2414bd6333ee6, 0xbff1cb27bd1f5e3e,
    0x3fdb82cef078d992, 0x3fefdccea8008c28,
    0xbff6443fbf0c01c2, 0xbfc0639565e8d000,
    0x3fe400530c4c9937, 0xbfd1241d366f4e85,
    0x3fae2bec299ee3a8, 0xbffee47c2f7256ec,
    0xbff767bac525a599, 0x3ff4408aaacf714c,
    0xbfaa5a9e35830e90, 0xbfc3ce76daa8d6d5,
    0x3f8d1fd5a258d87c, 0xbfba6d89b593d218,
    0x3fd6110fde4f5e8d, 0x3fba53165c940daf,
    0x3fd0c19ace07aca6, 0x3fdf7ee9bec6e11c,
    0x3fd5802d7e48001e, 0x3feba21b6d781b13,
    0xc00314fd96bc90a5, 0xbfed67af5beab509,
    0x3fbf14534528066c, 0xbff05af846960715,
    0x3ff41bcd84610ba4, 0xbfb4ea888c0136e4,
    0xbfb6e5c7d9ca8c5a, 0x3fd9b99f7cb61dfe,
    0x3fdf4ab52b744afc, 0xbfe645d687ecb177,
    0x3fc0117147ff331d, 0xbfe7af077627ce6f,
    0x3fcde631f14f4252, 0xbfefc0f0eb4c7f7c,
    0x3fe6b109563ec9af, 0xbfe894a29985a834,
    0x3fb30f8229534774, 0xbfdc7e33c46c2c87,
    0xbfe43a3b56b8b554, 0xbff0cf4fa47da409,
    0x3fec64021c884251, 0x3fccaf7d1f12e4d8,
    0x3fcba86b745544d4, 0x3fb7c6821cb5e154,
    0x3fd08e65020fcc26, 0xbfc37b14b072ab00,
    0xbfcae0d18a2858aa, 0x3fb81939c07213fd,
    0x3fe806de48909984, 0xbfdf6f717dc60bcb,
    0xbfd16a3d202991b8, 0x3ff3fec11e6f0658,
    0xbff5817a2e626836, 0xbfdd6c38a957cad3,
    0x3fe496f710b52654, 0x3fdc388727917564,
    0x3fff062b1e76699f, 0x3fd4cb7f3d4c71d0,
    0xbff209b95a36afdc, 0x3fdb60111b18c404,
    0x3fc57a1d9471cb9a, 0x3fdce44f78a3ebca,
    0x3fdb2cf84bf55187, 0xbff251d8e971e140,
    0x3fd9303ef7cae096, 0x3ff309d83353e1db,
    0xbff23ee695c7f28a, 0x3fb86b3a231349b0,
    0x3fdd71a2ef5f9774, 0xbff77872f09a97be,
    0x3febd6ec83b86b82, 0x3ff0036e604251df,
    0xbfd04913349de0b9, 0xbff4a46758e5e0f9,
    0x3ff4f6aa5dfe5c10, 0x3fbe53d2743c9a1c,
    0x3fc289275af35494, 0x3ff3ad76dee031cc,
    0xbfe6cd810336d3c2, 0x3f6c349c26c92700,
    0x3fb670a7da315571, 0xbff1c71caa232066,
    0x3fe5698f71fd8bfe, 0x3fe7d750ff556b4a,
    0x3fedb3eb6218083c, 0xbf93c20209d898c0,
    0x3ff5f1631c02f83e, 0x3fd1b89a7f55cb38,
    0xbf73a815c424a6c0, 0x3fdc92dad69a7908,
    0x3fdbe31e64429a7a, 0x3fe85df1b9f6005a,
    0x3fe81248ef9734af, 0xbfb6128e74c7fcc0,
    0x3fd893468a349b3e, 0xbfa3c8aad470d008,
    0xbfd78676a04043a4, 0x3feffa64b3c55e1b,
    0x3fdb8e8ec44daf25, 0x3fed8baf4fa87364,
    0xbff5f696da8d395b, 0x3feb345d1ac9e91b,
    0xbfcf42a424f03e32, 0xbfd65d8e7262f37a,
    0x3fcc1a9410646984, 0x3fdc6948288d36d4,
    0xbff0083fa46b9598, 0x3fde7cbfc825fd5e,
    0xbfe4d818446e28b7, 0xbfb4dfcf6b3799c0,
    0xbfa9169604c2ec90, 0x0,
    0xbfe4d818446e28b5, 0x3fb4dfcf6b3799b0,
    0xbff0083fa46b9598, 0xbfde7cbfc825fd6c,
    0x3fcc1a941064698e, 0xbfdc6948288d36d6,
    0xbfcf42a424f03e3a, 0x3fd65d8e7262f378,
    0xbff5f696da8d395a, 0xbfeb345d1ac9e922,
    0x3fdb8e8ec44daf31, 0xbfed8baf4fa87364,
    0xbfd78676a0404396, 0xbfeffa64b3c55e19,
    0x3fd893468a349b3a, 0x3fa3c8aad470d004,
    0x3fe81248ef9734b4, 0x3fb6128e74c7fcc8,
    0x3fdbe31e64429a8b, 0xbfe85df1b9f6005a,
    0xbf73a815c424a540, 0xbfdc92dad69a7903,
    0x3ff5f1631c02f83f, 0xbfd1b89a7f55cb28,
    0x3fedb3eb6218083c, 0x3f93c20209d89990,
    0x3fe5698f71fd8c04, 0xbfe7d750ff556b4a,
    0x3fb670a7da31554e, 0x3ff1c71caa232064,
    0xbfe6cd810336d3c0, 0xbf6c349c26c92a00,
    0x3fc289275af354a8, 0xbff3ad76dee031cc,
    0x3ff4f6aa5dfe5c0f, 0xbfbe53d2743c99fa,
    0xbfd04913349de0c6, 0x3ff4a46758e5e0f9,
    0x3febd6ec83b86b82, 0xbff0036e604251dd,
    0x3fdd71a2ef5f9769, 0x3ff77872f09a97be,
    0xbff23ee695c7f28e, 0xbfb86b3a231349e0,
    0x3fd9303ef7cae0a3, 0xbff309d83353e1d9,
    0x3fdb2cf84bf55184, 0x3ff251d8e971e141,
    0x3fc57a1d9471cba8, 0xbfdce44f78a3ebc3,
    0xbff209b95a36afdc, 0xbfdb60111b18c411,
    0x3fff062b1e76699f, 0xbfd4cb7f3d4c71c4,
    0x3fe496f710b52656, 0xbfdc388727917554,
    0xbff5817a2e626838, 0x3fdd6c38a957cac9,
    0xbfd16a3d202991b0, 0xbff3fec11e6f0658,
    0x3fe806de48909980, 0x3fdf6f717dc60bd6,
    0xbfcae0d18a2858a8, 0xbfb81939c07213fe,
    0x3fd08e65020fcc20, 0x3fc37b14b072ab0c,
    0x3fcba86b745544d2, 0xbfb7c6821cb5e156,
    0x3fec64021c884250, 0xbfccaf7d1f12e4c0,
    0xbfe43a3b56b8b558, 0x3ff0cf4fa47da407,
    0x3fb30f8229534752, 0x3fdc7e33c46c2c8a,
    0x3fe6b109563ec9ae, 0x3fe894a29985a837,
    0x3fcde631f14f423c, 0x3fefc0f0eb4c7f7c,
    0x3fc0117147ff3316, 0x3fe7af077627ce70,
    0x3fdf4ab52b744af6, 0x3fe645d687ecb17b,
    0xbfb6e5c7d9ca8c48, 0xbfd9b99f7cb61dfa,
    0x3ff41bcd84610ba1, 0x3fb4ea888c0136fc,
    0x3fbf145345280634, 0x3ff05af846960716,
    0xc00314fd96bc90a6, 0x3fed67af5beab4fb,
    0x3fd5802d7e480025, 0xbfeba21b6d781b10,
    0x3fd0c19ace07acaa, 0xbfdf7ee9bec6e11f,
    0x3fd6110fde4f5e8f, 0xbfba53165c940da3,
    0x3f8d1fd5a258d87c, 0x3fba6d89b593d218,
    0xbfaa5a9e35830ec4, 0x3fc3ce76daa8d6d7,
    0xbff767bac525a598, 0xbff4408aaacf7152,
    0x3fae2bec299ee358, 0x3ffee47c2f7256ee,
    0x3fe400530c4c9937, 0x3fd1241d366f4e90,
    0xbff6443fbf0c01c3, 0x3fc0639565e8cfe8,
    0x3fdb82cef078d98c, 0xbfefdccea8008c24,
    0xbff2414bd6333ee8, 0x3ff1cb27bd1f5e3c,
    0x3fe48d8e9ccdada5, 0xbfea69b78c887cc7,
    0x3fe9750f30628a24, 0xbfc76d31c5a5cf31,
    0x3fe4c50b0000ce21, 0xbfef61c88cda62fe,
    0xbfd276a64cbb41bb, 0xbff7b9f21313748c,
    0x3fed4b93fbf1cbcc, 0xbff22f8d80d084bb,
    0x3fd377cb131fef35, 0xbff1bddfd8823f5d,
    0xbfed3ec04841f049, 0xbfe2ef6c1a412078,
    0x3fc066237532b116, 0xbfebf0b5ec984380,
    0xbfe6a5cc7c913ff8, 0xbfe01c00e6c15e0a,
    0xbfeffe8f7cf6d3ee, 0xbfc676534a1ec6da,
    0xbff6afd81c09081c, 0xbfc8f27652a7d994,
    0xbfce548f33043364, 0x3fd631d9cf700512,
    0xbff95b2a8d213844, 0x3ff58b1070f52f13,
    0xbfdaa980e01b8bef, 0xbfdc5f4466df07b0,
    0xbfecad171caa2d73, 0x3fed093f7d983c38,
    0xbfdec2baf629b033, 0x3fcdb4a4a7377278,
    0x3fd54f01a57af3aa, 0x3febada98e2d0426,
    0xbfe612c5542e2dff, 0xbfd998fadb5c069a,
    0xbfdd2205790b967c, 0x3ff393c519a0ef42,
    0xbfbb708ebbf6fb56, 0x3fb797ba419013d6,
    0x3fedbbc18bbb8f92, 0xbfd84a4c63c7ad0a,
    0x3f98299b57da7b40, 0xbfe7eecad7d860ba,
    0xbfecb6f0ac78276f, 0xbfd50c64ae030ec6,
    0xbfe9421fc62d3549, 0x3fe3a9e7ac15ea8a,
    0x3fc23891e7d8810d, 0xbfd4b765a5f298f2,
    0xbfc75d4dedbfa5dd, 0x3fdd45e16ad90a9c,
    0xbfc8a29ba6e68d18, 0xbf87d684daf114e0,
    0x3fe37b8a99fa1f44, 0x3ff2212a04637c4c,
    0x3fe7c60f277f734a, 0x3fbdca890986d380,
    0xbfe444542b12e844, 0x3ff0c06ae183da89,
    0xbfe2196a00fb6f98, 0xbfe569616f1f67be,
    0x3fda7c81f917f310, 0x3fce03cf9b6ae5ec,
    0x3fc4f0d9a432705d, 0x3fe1012f20ad7598,
    0x3fc10c6f997bc95c, 0xbfdfa4f54ef4230a,
    0xbfebefb5e2a9584c, 0x3fe2069fd201910c,
    0x3fe2c786a3838c67, 0xbfcf2a4db11e8b7e,
    0xbfb28745afb846d8, 0x3fb31b6ae3262aa0,
    0xbfefcf97c89df6fd, 0xbfeabee965c44ae4,
    0x3fc146912cd64fd6, 0x3fc8680e1ebc1296,
    0xbfe5ee07f957e6d8, 0xbfd48d38e93863e2,
    0x3fd1e867deabfb54, 0x3fbdfca7078756d4,
    0xbfcde1ce5480d684, 0xbfd85a7c7ee20975,
    0x3ff08c101086778a, 0xbfc81a2e0876850d,
    0x3fe420b599a7e526, 0xbfee7c9636dffe92,
    0xbfb091471f0a705c, 0x3fde372e5a536d72,
    0xbfb36cdc999df2e8, 0xbfdeeb4fe49da326,
    0x3fd9df3621a34641, 0xbfd173c47486f842,
    0xbfea43955ac8c90e, 0xbfe43d89bf3f761a,
    0xbfe5972ed85bd4ff, 0x3f92889ba9230428,
    0x3fea825e1fa755a8, 0xbfe523c23937d136,
    0xbfe4aa03166a2a17, 0x3fe111609ef52be4,
    0xbfb8842981c2dad2, 0x3fd0275e852d3c7a,
    0x3ff1bf7942a016d7, 0x3fcbd8afce572cd8,
    0xbfe469f746344e70, 0x3fd2b61f6bf22dae,
    0x3fb8bde3481859e0, 0xbffed1fad6d84f91,
    0x3fd75f96c8cc2c40, 0xbfe1412db0bcbc3c,
    0xbfe6e3dbe13289f8, 0xbfe1206917987f19,
    0xc0027160b5989240, 0xbff1147e5ed80e2e,
    0x3fe59d1a63d4c976, 0xbfc0650438c96478,
    0xbfe07aa8406cd901, 0xbfd066928cc1c640,
    0xbfd0201de7ed6715, 0x3ff95fa639f05489,
    0x3f626bc7dfc83100, 0x3ff3fde80da1215c,
    0xbfe60cc41da4b310, 0xbfea6edc49ea4ee3,
    0xbfdb2a8651411032, 0x4000d18c237c9236,
    0x3ff5ced2b7b1c4b6, 0xbfe885897319a89c,
    0x3ff155d0b319b07e, 0x3fb73ec5f5841e56,
    0xbfd46ff1b01f6c5e, 0x3fec48fa826f3a62,
    0x3fb838f07447ddf0, 0x3fd4f1f8d69ce2a0,
    0x3fe121ab46b63b80, 0x3fdb2b994ea118b0,
    0xbfd0e9484edd0d57, 0x3fdf55897050ea84,
    0xbff6279adbbff7fc, 0xbfed36be70668548,
    0x3fe2dfd20b0eaa57, 0x3ff1ef69573a1370,
    0x3fba88fcab1aec30, 0x3fe292e406de49db,
    0xbfdd28b3726aaa74, 0xbff344abf9ee80f2,
    0x3fa5acf82c84ec44, 0x3febb1a7f3598728,
    0xbfec00e32ee04364, 0x3ff04e2e4d5bc219,
    0x3fe83b54043b3359, 0xbfe885185d7bd170,
    0x3fdfaa767796159c, 0xbfe173d3d6ea1ffe,
    0x3fe0a27186140df4, 0xbff6f1b0fdea5564,
    0xbfbe3e95555b402a, 0xbff0bdc0badddaaa,
    0x3fdcc548ad85be85, 0x3ff7b434084fdc28,
    0x3ff0330d1ab1efbf, 0x3f304f971732b000,
    0x3fbd0cd700fbf96c, 0x3fd4d8c354011b94,
    0xbfd0ae69feeac8b6, 0x3ff541ae2a866066,
    0x3feb0bc618703148, 0x3ff3f159baa751fa,
    0x3fd4b0a711a5c386, 0xbfe91729d5156693,
    0x3febca9053abf586, 0xbfbb27c49f367e08,
    0x3fb0bc4da20c3a42, 0xbfe38dba3954bcfe,
    0x3ff490af510a2932, 0xbfd921e996b7def8,
    0x3fdf587641ba18b8, 0x3fdd260ff99466a0,
    0xbfdc6971eeeadc09, 0xbfc287537103fc6c,
    0xbfd02ee622a79786, 0xbf8a128152944c60,
    0x3fd85c7cbc2a45ec, 0xbfdc5d335ff9e17c,
    0x3fd1317cadf5b62f, 0xbfe0aec488eb4a12,
    0x3ff06756bdd3dca6, 0xbf905ed0633d4b50,
    0x3fe38c00b322a8d6, 0xbfd4aeaae88f10d0,
    0xbfeb622638bd108a, 0xbfce786988191396,
    0xbfe17628dff397de, 0xbff49c9bb7bede49,
    0x3fecbf24a672c6e4, 0xbff103a04d0fe9e8,
    0xbff2447662b1c213, 0xbfe1f2a4e59aeb16,
    0xbfd70829f35b42fe, 0x3fc9474379b45764,
    0x3fca4105380ca075, 0xbfbdd3d38b810270,
    0x3ffc1339a5851492, 0x3fd01779943ace9e,
    0xbfb6f17f32c42308, 0x3fc5e3ce06e4568f,
    0x3fd4086dbe2e08a3, 0xbfe9c291516ea8c6,
    0xbfd85bbfe16806c6, 0x3ffbafcd089d52b5,
    0xbfebf36b3edadc2a, 0x3fe0a1642fa4f374,
    0x3fe1894a3335b3fc, 0xbfedc061927a8849,
    0x3fa64f51f3c32c40, 0x3fdcd6e5f6d32a42,
    0xbffc149cc1de094a, 0x3fd7c4bebb090d1f,
    0x3f9a03a530ea8dc4, 0xbfa08becbb47521c,
    0xbfcd092e4f6db926, 0x3fd21756954ae3e3,
    0xbff05c4b7e915d22, 0x3fdb97e7b3cafb01,
    0xbfedc4f30036d4de, 0xbfe43707a2072c9c,
    0x3faf65601d7885c8, 0xbff6814c43ce50e6,
    0xbfd1e63b4a08e471, 0x3fe5043f2ae436cc,
    0xbfe0b8541dd07d26, 0xbfe7c24aae5957fd,
    0x3fe1a45a9579b3cd, 0xbfec6f14ea1f2276,
    0x3fe116be552bab58, 0x3fa5b1bb27bd2e18,
    0xbfd164bffd7e467b, 0xbfe02076b0e85c5a,
    0x3fe40df1750c83d9, 0xbff57002dcc25792,
    0xbffd66967ef288f6, 0x3fdfe98063bfaf90,
    0x3fd6a9ee427a5c34, 0x3fc60fc5a6df42c7,
    0xbfc9b4fe49bca8e5, 0x3fc17ca95ace9857,
    0xbfe0da939f1c7f35, 0xbfdcf2f70335ebba,
    0x3ff262bcaf44df13, 0xbfd91d052b8a2e2b,
    0x3fba82853f62b4a4, 0xbfeeb3da8c0b31ca,
    0x3fe2f7f24c0685f5, 0xbff4ce72a0fbeb03,
    0xbfef6cc78a68ce6a, 0x3fbbb01f198ab9cc,
    0xbfbe9c057dfc2b64, 0xbfa1bf76b350b00c,
    0x3fc5870671b87400, 0xbff417cdd0d45e38,
    0x3ff2fbae791674f8, 0x3ff10709d00e307a,
    0xbff66fb9dfade9d0, 0x3fe9afa2b47907e4,
    0x3fc3bdefd041e34a, 0xbfda5f45afb94108,
    0x3fc18c0d250748a8, 0x3fd8b8b16a61412d,
    0xbfa9a203a1c7f9da, 0x406661091e0bde98,
    0x3fe580472ee9fefd, 0xbfe00e29d53bcc86,
    0xbfe0e751c795f3a0, 0xbfe3cdd9be73bd12,
    0x3fe75b7c2b246896, 0x3fea0cc81f27cdc0,
    0xbfef66938554e531, 0x3fba5ab149ea0668,
    0x3fd36ff369aa95ca, 0x3fe982f78b215a86,
    0xbf9e029a05b71950, 0xbfcaff7a82066afa,
    0xbfb007b28b8029ec, 0x3fd1cfbbffdff410,
    0xbfc82384392bc052, 0x3fb8f576ee8b5268,
    0x4000f84e2cb79d69, 0xbfdf137ccd6a5563,
    0x3fc4a2b042b25618, 0x3ffa7bf8d2218188,
    0xbfe55c572d5437ed, 0xbfbdbdc63826fe5c,
    0x3fd58c33805e128e, 0xbfca1687c3f00cec,
    0xbff0a9efe61af907, 0xbfcb9347fad85090,
    0x3fd253201a030bce, 0xbfca8724e3678e0d,
    0xbfa44a5bdc204301, 0x3ff856876ed4d54c,
    0x3fcd3e8ef422e1e9, 0x3fcf84cf7638799c,
    0xbfd47dfc68baf354, 0xbfd6037bb2f3e04c,
    0x3fe935d647a800b1, 0xbf90220eaa85a840,
    0x3fe42a16f44ce7ad, 0xbfe6ded7f0f973db,
    0x3fd1b24df355d27b, 0x3fea81dd6ed0ce12,
    0xbfe99b5e145aa7c3, 0x3fdfbbc1f2b9198f,
    0xbfdb113d7cf27126, 0xbfd951e7f7db4536,
    0xbfed05d6770358f2, 0xbfe130c19e506059,
    0xbfe33ae7fc783091, 0xbfec1386af95b68f,
    0xbfe4df048d731cbe, 0xbfe51699a4e6afa6,
    0xbfefa66d6e426c43, 0xbffec1fee3295580,
    0x3fb42063a7d70e24, 0xbfc3299ebbd4ffa2,
    0x3ffa1aebbe322de6, 0xbff3f1d51c145853,
    0x3feb236c87ce0a4b, 0xbff1161aa0bc21ef,
    0xbfc75e28f3acba60, 0x3fd4ed7b13348ddb,
    0x3ffc77482ef8c746, 0x3ff3f8ff6df6f4cc,
    0x3fe09d4e2f8c093a, 0xbfd3e2f9d060869d,
    0x3fdc59dd47731f2b, 0xbfe8564a31f8bc66,
    0x3ff16ec7b314045e, 0xbff8d3a3b9334ee4,
    0xbfdb4093fe0f9142, 0x3fb3d7e762f4abc4,
    0xbfd5fdaca2565c83, 0xbffd69e4263e1907,
    0xbfe36dc12d97c5b2, 0xbfb4fa776aa8ed08,
    0x3ff0ffb089020382, 0x3fef1b39dd139ffa,
    0x3fa817009c212264, 0xbfb2d919b56c6cd6,
    0xbff1f4dde7ebaefb, 0x3ff6433bc49a8e04,
    0x3fd663eafa94bd96, 0xbff501e67a24771f,
    0x3fd27164c528f5ed, 0x3ff973475ddf531f,
    0xbfda56648b1fd0f6, 0x3fdd77f2ba60d5d2,
    0xbff4f30ccd7e9bb9, 0x3ff668b141ef2311,
    0xbfe11e6ab2e52072, 0x3fff76ce00c63087,
    0xbfd2e2e4bd1804b8, 0x3f9b512ffe5fb810,
    0xbff507e071a4d878, 0x3fc8c94e1b07e570,
    0x3fe33131889a74f0, 0xbff327fa514b359a,
    0xbfadc564c2685106, 0xbfb29d587e3109c0,
    0x3fda076703e23c5d, 0x3ff631296000b8fb,
    0xbfe2269038e5dd60, 0xbfdb2013bbe679b6,
    0xbfe1c7615c10140b, 0xbfc9e9b7239132df,
    0x3fdfe550eb249ac1, 0xbfed79a99cfdbd74,
    0xbfd5682316cc9b0e, 0xbff1d1c57ce9fe94,
    0x3fe178418b0d661d, 0x3ff62b36d7c66238,
    0x3fe7bc7ed88d819b, 0x3fb89f807992bb54,
    0x3fd5b434b8e42ab8, 0x3ff0946929057113,
    0xbfed75b1ba8ed3e2, 0xbfc69447c8191c50,
    0xbfb7d6617bca3d10, 0xbfad48c10fc5be70,
    0xbfdb85882325449b, 0xbff801cbe79bb7b6,
    0x3fd1b8135a598058, 0x3fdd9703f3439350,
    0x3ffbb276927f5c8a, 0xbfe07fc3eab9f756,
    0xbfc3823e39686e41, 0x3ff752fdc523ec66
    };

static const uint64_t in_cfft_noisy_1024[2048] = {
    0xbf4d16b75e40129c, 0x0,
    0x3fe26a3c9634f4b3, 0x0,
    0x3fe6884a5c47b005, 0x0,
    0x3fdb07f6b37fd63d, 0x0,
    0x3fb52162c4a2cd04, 0x0,
    0xbfe2d398f05aa2f1, 0x0,
    0xbfe4f4a1f554c552, 0x0,
    0xbfdc3ee3e4778302, 0x0,
    0xbf7e4edd42318a66, 0x0,
    0x3fdf1e67639efa63, 0x0,
    0x3fe759ffce1770a5, 0x0,
    0x3fe0329345625139, 0x0,
    0xbf8c8ef86c402f93, 0x0,
    0xbfdced0dc2627fbc, 0x0,
    0xbfe7406c4489359c, 0x0,
    0xbfde1a3e90eadfc5, 0x0,
    0x3fa3c7aeaea8fc32, 0x0,
    0x3fdc19a5bfff2035, 0x0,
    0x3fe88035bfa61b9e, 0x0,
    0x3fdc4e989468da72, 0x0,
    0xbfa020119426f6cd, 0x0,
    0xbfdfb4e89fc1989c, 0x0,
    0xbfe824fcb85899e0, 0x0,
    0xbfda1a16736b9879, 0x0,
    0x3f8e2731286f881e, 0x0,
    0x3fdacbe2e20f1d4c, 0x0,
    0x3fe43c64fd3722cc, 0x0,
    0x3fe04eb307b335de, 0x0,
    0xbf800b4c61caf077, 0x0,
    0xbfe0419fba962089, 0x0,
    0xbfe8e9b7e7d1a9d1, 0x0,
    0xbfdf91d4606a5ce0, 0x0,
    0x3f95906c17afbc1a, 0x0,
    0x3fdfe400c1fe9581, 0x0,
    0x3fe50afd608033f2, 0x0,
    0x3fe2238861c2df9a, 0x0,
    0x3fb43328712b94d4, 0x0,
    0xbfe174a8971937a1, 0x0,
    0xbfe61211eeafadd0, 0x0,
    0xbfdf4a4953e9ac99, 0x0,
    0x3faa6daa13e5a374, 0x0,
    0x3fe1bc6460bca4c0, 0x0,
    0x3fe7535979f5f959, 0x0,
    0x3fdecd72181d9611, 0x0,
    0x3fb22ed36f968b1a, 0x0,
    0xbfe289ddf54d6aad, 0x0,
    0xbfe63738b6d97463, 0x0,
    0xbfdee18f340430ea, 0x0,
    0xbfa0bd1b432d6dda, 0x0,
    0x3fdf3ef0773b84cb, 0x0,
    0x3fe46168a3f64183, 0x0,
    0x3fdd184cabafbf57, 0x0,
    0xbf8f5f148b743174, 0x0,
    0xbfe2c6885cb530a1, 0x0,
    0xbfe6f862c543d19a, 0x0,
    0xbfddde5023b16133, 0x0,
    0x3f7dd7e58732765a, 0x0,
    0x3fe02a58a96b26b7, 0x0,
    0x3fe7a1d0a85ada0f, 0x0,
    0x3fdba813a70d1158, 0x0,
    0xbfa5ea6f9e07dfbc, 0x0,
    0xbfdf7d0d07b30d87, 0x0,
    0xbfe62cad66d8948d, 0x0,
    0xbfe051064ae243bb, 0x0,
    0xbfb048cca122404e, 0x0,
    0x3fe07bea4d67317e, 0x0,
    0x3fe56c2ce261117d, 0x0,
    0x3fdf155d565fa2a2, 0x0,
    0xbf9aae197039aa31, 0x0,
    0xbfe0fe65fac65303, 0x0,
    0xbfe524177f45b9e4, 0x0,
    0xbfddd4ffceabc5cf, 0x0,
    0xbf9f51ac3ce41a5d, 0x0,
    0x3fe21bc2a4cc9d5d, 0x0,
    0x3fe9131b4f697a29, 0x0,
    0x3fe19008d7f69301, 0x0,
    0xbf944f82210704dc, 0x0,
    0xbfe011b4119cd94b, 0x0,
    0xbfe7391caf21013d, 0x0,
    0xbfd7d95cc14a7685, 0x0,
    0x3fb399a16738b698, 0x0,
    0x3fe16f0cd6254e54, 0x0,
    0x3fe5feffbbf0b3e8, 0x0,
    0x3fdec5764a1ef11d, 0x0,
    0x3fb80516e8d984b1, 0x0,
    0xbfe1bbb024c9191f, 0x0,
    0xbfe4e6ac57b8ee27, 0x0,
    0xbfe2197cc0038e5b, 0x0,
    0x3fa8b201bf83f633, 0x0,
    0x3fdfc6a30c4457a5, 0x0,
    0x3fe5594e0f0d5560, 0x0,
    0x3fe04a36bd358ee3, 0x0,
    0xbfa233d6c69c1bb7, 0x0,
    0xbfe15d9fcd5b71d9, 0x0,
    0xbfe7c1587551a22c, 0x0,
    0xbfe432cd9a5ee95f, 0x0,
    0xbf8b656c5d64299f, 0x0,
    0x3fde56258d7549fd, 0x0,
    0x3fe5c95a5df7d1a1, 0x0,
    0x3fdd270a32322bfb, 0x0,
    0xbfaca46f77817bfe, 0x0,
    0xbfe06ff116d31c9d, 0x0,
    0xbfe838603281eea6, 0x0,
    0xbfe0aacb6375b593, 0x0,
    0x3f6c6b30fb33d9f1, 0x0,
    0x3fddef5e58d3e33e, 0x0,
    0x3fe6d9ac67764c0f, 0x0,
    0x3fe180eafc2e3e4a, 0x0,
    0x3f8add9eeeabbca2, 0x0,
    0xbfe107fe7fabab19, 0x0,
    0xbfe9e2c4ec560c55, 0x0,
    0xbfe0c6139325fbbb, 0x0,
    0xbfb137bdd3b6c582, 0x0,
    0x3fde3931e3ecee9d, 0x0,
    0x3fe4da06a4aa83f3, 0x0,
    0x3fdf2f00f94f16b2, 0x0,
    0x3fad6e38e6b2f8dd, 0x0,
    0xbfde2f0bdd3eec76, 0x0,
    0xbfe5c5b2b32a65be, 0x0,
    0xbfe1daffece34e95, 0x0,
    0x3f8399b97e578982, 0x0,
    0x3fe104fd018ca081, 0x0,
    0x3fe8a9c44f5a641a, 0x0,
    0x3fe09c36e6f53f8e, 0x0,
    0x3fa846d28ce82981, 0x0,
    0xbfe069978fe0dab0, 0x0,
    0xbfe5aecae6524c2b, 0x0,
    0xbfdca75bed8a5ac8, 0x0,
    0xbfb1b83579107400, 0x0,
    0x3fe0ba93a0cba4ca, 0x0,
    0x3fe66eff71a61782, 0x0,
    0x3fdf9f08427e45fc, 0x0,
    0xbfba2ef385c501fc, 0x0,
    0xbfe1018170c7964c, 0x0,
    0xbfe415c95087c0f2, 0x0,
    0xbfe08cad83b6ff81, 0x0,
    0xbfa3fd2c0fe718fb, 0x0,
    0x3fe17357364e2761, 0x0,
    0x3fe968b65002af85, 0x0,
    0x3fdadef9f7c33aeb, 0x0,
    0x3fb02abf39106849, 0x0,
    0xbfdde9362660db81, 0x0,
    0xbfe6a3d70e50386c, 0x0,
    0xbfdf249b2340fb2e, 0x0,
    0xbfaaf637811a0eea, 0x0,
    0x3fdf2c66380f0f21, 0x0,
    0x3fe84799621d5322, 0x0,
    0x3fdfa3d93cda85e5, 0x0,
    0xbf9da6c7ff218e2f, 0x0,
    0xbfdd5c8364a2dc09, 0x0,
    0xbfe69a6ce5f0ca98, 0x0,
    0xbfdeb7022a2c92f6, 0x0,
    0x3f9d57e05cc44765, 0x0,
    0x3fe08ba175e6ccb8, 0x0,
    0x3fe933f80a63631c, 0x0,
    0x3fda097a6bb5ab76, 0x0,
    0x3fa9f928df1c37e5, 0x0,
    0xbfdda528a85372c9, 0x0,
    0xbfe77843b9aa8179, 0x0,
    0xbfe0b8c634bb908a, 0x0,
    0xbfa98395d7e814d6, 0x0,
    0x3fe13c3d291ff988, 0x0,
    0x3fe6d0d0f940dd7b, 0x0,
    0x3fdb65cb95b7a04b, 0x0,
    0x3fa3dfa940e2cbdf, 0x0,
    0xbfe11df432ec8902, 0x0,
    0xbfe650b3d9874799, 0x0,
    0xbfddb57d0d54e9ec, 0x0,
    0xbfb454b31c8feaba, 0x0,
    0x3fe19eb2b058507b, 0x0,
    0x3fe7b1874e590880, 0x0,
    0x3fe180f727e154b3, 0x0,
    0xbfa542616ef404fb, 0x0,
    0xbfe427daac878c3e, 0x0,
    0xbfe50e540bc7cb16, 0x0,
    0xbfe2efaada2185af, 0x0,
    0x3fa8c081ad10f62d, 0x0,
    0x3fdb74ac13a82236, 0x0,
    0x3fe9a9560126e8cd, 0x0,
    0x3fe1e36eba9d8504, 0x0,
    0x3f7462dac1d55514, 0x0,
    0xbfdac9813600805c, 0x0,
    0xbfe7227ed82d43b9, 0x0,
    0xbfda2669ff0c96c8, 0x0,
    0x3fb359da9bd82514, 0x0,
    0x3fe1c9da8fea5323, 0x0,
    0x3fe7e941d035ed85, 0x0,
    0x3fde308dd72e3972, 0x0,
    0xbf95363e7f2fd638, 0x0,
    0xbfe04fcaee9ac980, 0x0,
    0xbfe8d2d06fe828d0, 0x0,
    0xbfe33d71a151aac8, 0x0,
    0x3fa4cf17ffcfef4f, 0x0,
    0x3fe0176a68c24663, 0x0,
    0x3fe8f2882d793568, 0x0,
    0x3fdd357cbc74210f, 0x0,
    0xbf80a61847830dd7, 0x0,
    0xbfe0fb9cfb57bc76, 0x0,
    0xbfe764eef2878ec5, 0x0,
    0xbfe0f5bb86e2e369, 0x0,
    0x3f8bbd2772f3542b, 0x0,
    0x3fe1d2c152d3d60e, 0x0,
    0x3fe567d5b8179eaf, 0x0,
    0x3fdcf5ce32fbb397, 0x0,
    0xbf97ca4692b0ec5b, 0x0,
    0xbfe1bec0acc0725a, 0x0,
    0xbfe7159c89919802, 0x0,
    0xbfdefc46d85232a9, 0x0,
    0x3fa8d7be7cc637d8, 0x0,
    0x3fe06f054d946adc, 0x0,
    0x3fe79414814bf500, 0x0,
    0x3fe3aec212f1abc4, 0x0,
    0xbf6870c5ce42f553, 0x0,
    0xbfe0b8be528726bc, 0x0,
    0xbfe6e3b142d38178, 0x0,
    0xbfde2e42bd5b87e0, 0x0,
    0xbf921568c9964c06, 0x0,
    0x3fe093fad1f2b8df, 0x0,
    0x3fe60503d6dce607, 0x0,
    0x3fe0132606c2a474, 0x0,
    0xbf7d1440ae0c2692, 0x0,
    0xbfde492f8c984a1c, 0x0,
    0xbfe5d19363eefcbb, 0x0,
    0xbfe044af9ca0c145, 0x0,
    0x3fafac08ac98f28e, 0x0,
    0x3fdcc84749d29379, 0x0,
    0x3fe7e9e3f9ac963f, 0x0,
    0x3fe02d88f269c3fe, 0x0,
    0x3fa325dc869dcee4, 0x0,
    0xbfde97bddf666236, 0x0,
    0xbfe73db73622de04, 0x0,
    0xbfdd75618143c6b2, 0x0,
    0x3f505f2bb18f02a6, 0x0,
    0x3fddd6e40685b8e8, 0x0,
    0x3fe763b558f71ba7, 0x0,
    0x3fe116cc8f96646d, 0x0,
    0xbf7d325c2b6fb6d3, 0x0,
    0xbfe17b26358007f6, 0x0,
    0xbfe72bf93f605dfa, 0x0,
    0xbfde1d1069b06da2, 0x0,
    0x3fb9b50f268efa9b, 0x0,
    0x3fd6c6a21a14237c, 0x0,
    0x3fe95c10cf136e88, 0x0,
    0x3fe12afbcf0f7bd8, 0x0,
    0xbfab973e319ae429, 0x0,
    0xbfe1a333848dab83, 0x0,
    0xbfe5f116d4cd4d9a, 0x0,
    0xbfdb359d87338049, 0x0,
    0x3f57f5bf8d688240, 0x0,
    0x3fe093e78e00cee1, 0x0,
    0x3fe31b117dae8c48, 0x0,
    0x3fe2de6a5b064c24, 0x0,
    0xbfa78b7baa5cb6fa, 0x0,
    0xbfdbb1b25049d619, 0x0,
    0xbfe6d4a0c49ca0f2, 0x0,
    0xbfde2479e536307d, 0x0,
    0x3fb2dfe70c5bfd3b, 0x0,
    0x3fe2422ed74703ea, 0x0,
    0x3fe85df69c43533d, 0x0,
    0x3fdd3230a0d001f6, 0x0,
    0x3fa64eaadf8f1ade, 0x0,
    0xbfdd1922bad14c3e, 0x0,
    0xbfe527d46c26ccb6, 0x0,
    0xbfe053e56df7d149, 0x0,
    0x3f6f00f7af7bd184, 0x0,
    0x3fddec413b2c70f1, 0x0,
    0x3fe26fe3f2d85570, 0x0,
    0x3fdbe8a3ba3a160c, 0x0,
    0x3f70166fbcbbc8ae, 0x0,
    0xbfdc52acb64ccdda, 0x0,
    0xbfe5c50e822e7783, 0x0,
    0xbfe0602915cc493b, 0x0,
    0x3f96a5e9227d8c5d, 0x0,
    0x3fe2079a70a7646e, 0x0,
    0x3fe6c0bcf955400a, 0x0,
    0x3fd8a14f932d1e8c, 0x0,
    0x3fb3ae1432e5385a, 0x0,
    0xbfe05b56b1ab00b1, 0x0,
    0xbfe3dcf19203a81e, 0x0,
    0xbfe09a450666be19, 0x0,
    0xbfac325726894023, 0x0,
    0x3fdf64af19d5bb05, 0x0,
    0x3fe721d52ffdbe02, 0x0,
    0x3fdc5c8e0c174500, 0x0,
    0xbfa0cf1b60f55604, 0x0,
    0xbfe2ae5ad63c7fce, 0x0,
    0xbfe4014886ea3cd9, 0x0,
    0xbfd803c7ecc1e611, 0x0,
    0xbf991e63ebe1dfa3, 0x0,
    0x3fdbe8b99f75528a, 0x0,
    0x3fe5f8b6d0b6c664, 0x0,
    0x3fe0c2847bc02c18, 0x0,
    0x3f2d7c10d8b09129, 0x0,
    0xbfde5ab3578f41ac, 0x0,
    0xbfe75f68d34645cf, 0x0,
    0xbfe02c2369f207f7, 0x0,
    0x3fb6948f8ac60871, 0x0,
    0x3fdf1d54ad443b73, 0x0,
    0x3fe8d7da500dcab8, 0x0,
    0x3fdb90c6ec7b4f7a, 0x0,
    0x3fb56d8509e12a00, 0x0,
    0xbfdc44d3432c9f4a, 0x0,
    0xbfe3271b3cec1c59, 0x0,
    0xbfe0a94d0378f585, 0x0,
    0xbfb53b533badec74, 0x0,
    0x3fe054c3f5adc459, 0x0,
    0x3fe49d75cb0a690f, 0x0,
    0x3fe18675dc3bf88c, 0x0,
    0xbf9ea702aa4f523b, 0x0,
    0xbfdc34176208fbda, 0x0,
    0xbfe7ba3e9bdcb588, 0x0,
    0xbfe1b5e8bebaecd3, 0x0,
    0x3f9234b14053d0f6, 0x0,
    0x3fe0fc5931e72c1c, 0x0,
    0x3fe5e9b5111516fc, 0x0,
    0x3fdef54187cf00f8, 0x0,
    0xbf948f484f99cabc, 0x0,
    0xbfe011c9d02af8c0, 0x0,
    0xbfe76564ca3f69d8, 0x0,
    0xbfe13981c03119fc, 0x0,
    0xbfa99c6b09d5c833, 0x0,
    0x3fdf34ce9abf1c3c, 0x0,
    0x3fe68933b6f57092, 0x0,
    0x3fe07b52d4b16e01, 0x0,
    0xbf903bbd57c7b0a0, 0x0,
    0xbfe13e2d72d2868d, 0x0,
    0xbfe53aff9f1b640d, 0x0,
    0xbfe21eddaf45ef19, 0x0,
    0xbfb330b34e13359a, 0x0,
    0x3fda92b340b431a8, 0x0,
    0x3fe9194b82cd7b1c, 0x0,
    0x3fdbbdb6644bb4e8, 0x0,
    0xbf74b4819b9a2e17, 0x0,
    0xbfe1b5211ca5b5b4, 0x0,
    0xbfe7799c00d74be5, 0x0,
    0xbfdd828cc00d9598, 0x0,
    0x3f94837e1ea15a48, 0x0,
    0x3fde6919acded804, 0x0,
    0x3fe4e7deb8d298f7, 0x0,
    0x3fe11875ca68ac65, 0x0,
    0x3f97ad48ce2279c8, 0x0,
    0xbfdea43f4bcefc6c, 0x0,
    0xbfe5ba79872b4c46, 0x0,
    0xbfe08bfb91352009, 0x0,
    0x3facd523867cfb94, 0x0,
    0x3fe1c07e8c71707f, 0x0,
    0x3fe63009e6271ca1, 0x0,
    0x3fda777c51107314, 0x0,
    0x3f9baa72187e9892, 0x0,
    0xbfddbd2b71b7ba2e, 0x0,
    0xbfe722ccecbeddea, 0x0,
    0xbfdaf94818116a87, 0x0,
    0xbf51b26c9394d27a, 0x0,
    0x3fddc99760ef5760, 0x0,
    0x3fe7c3d6e493b6fa, 0x0,
    0x3fddf07b3958ab48, 0x0,
    0x3fa954e7f3e67015, 0x0,
    0xbfe2b2e52700aa40, 0x0,
    0xbfe608a861fb22a0, 0x0,
    0xbfe1677352dd4c15, 0x0,
    0xbfa6c2427c13a3e7, 0x0,
    0x3fde4e14e1e3f17c, 0x0,
    0x3fe6566015b5cc26, 0x0,
    0x3fe032235f9b67ca, 0x0,
    0x3faaca20b64dcd65, 0x0,
    0xbfde6c0ad41d08a9, 0x0,
    0xbfe78af9fe36c752, 0x0,
    0xbfd8b41fd6e8b258, 0x0,
    0xbfadeb9cc8765eaf, 0x0,
    0x3fe0a6f039d231ff, 0x0,
    0x3fe47cdccd260fce, 0x0,
    0x3fe1bd26bb31be58, 0x0,
    0x3f94b1be10c60426, 0x0,
    0xbfde231dfb186290, 0x0,
    0xbfe72af19867ca62, 0x0,
    0xbfe406bedcdcbb52, 0x0,
    0xbfb23c638dcc1598, 0x0,
    0x3fdf8e1c65c5787f, 0x0,
    0x3fe7392590f8f8d8, 0x0,
    0x3fe00fa40ec61bab, 0x0,
    0xbf9be51b18b16737, 0x0,
    0xbfe2053f1629f40b, 0x0,
    0xbfe6e5064ec8fb67, 0x0,
    0xbfe1eb316b097708, 0x0,
    0x3f7b7fa4d8a637af, 0x0,
    0x3fe0ca45a00f5f03, 0x0,
    0x3fe9d59575c3d1f2, 0x0,
    0x3fdfe323b2bf61cf, 0x0,
    0x3f64853de2a9fced, 0x0,
    0xbfe01c5663461995, 0x0,
    0xbfe5ffc4685c9b3d, 0x0,
    0xbfdd3972799b0482, 0x0,
    0xbf8c05185feb11e3, 0x0,
    0x3fde55ceba48718f, 0x0,
    0x3fe7096a798d7aa4, 0x0,
    0x3fe1227c712ab48d, 0x0,
    0x3f998bea15aadd2a, 0x0,
    0xbfe0c2ee24fe7c72, 0x0,
    0xbfe643f78107fef4, 0x0,
    0xbfe04630a077e257, 0x0,
    0x3fa83f27046de456, 0x0,
    0x3fdca30b2a28ae1a, 0x0,
    0x3fe40153446d4c36, 0x0,
    0x3fe021e9498e3425, 0x0,
    0x3f9bf75bfd49e682, 0x0,
    0xbfdf04d5173f734b, 0x0,
    0xbfe58b34101617c5, 0x0,
    0xbfdae14f08a3d288, 0x0,
    0x3fb2ffb4cb263b17, 0x0,
    0x3fdf3f30b706a84b, 0x0,
    0x3fe8f2d9fdd6935e, 0x0,
    0x3fe15bde00b4c61f, 0x0,
    0xbfb1f6fb50fe939f, 0x0,
    0xbfdc405279bdac10, 0x0,
    0xbfe83115bd3c1626, 0x0,
    0xbfde916e91649242, 0x0,
    0x3f68e88dccfe21da, 0x0,
    0x3fe2d6629efa5449, 0x0,
    0x3fe7700d2add5fd6, 0x0,
    0x3fdff1329348224d, 0x0,
    0x3f9208ad75a3158c, 0x0,
    0xbfe0de717b91a65c, 0x0,
    0xbfe5f07d68f18dce, 0x0,
    0xbfdd8b5f917e2522, 0x0,
    0x3fae2a2fef00a5df, 0x0,
    0x3fe0ce0d6ad18ca7, 0x0,
    0x3fe2edda20dc63f4, 0x0,
    0x3fe21c71e51a5a02, 0x0,
    0x3fa87ac98047dbfc, 0x0,
    0xbfdda493e06c8325, 0x0,
    0xbfe7ebf2ef10910f, 0x0,
    0xbfe143d715d5a80a, 0x0,
    0xbf9cded2d0b2b770, 0x0,
    0x3fe002fd7bdced9d, 0x0,
    0x3fe7e2dd2fd19515, 0x0,
    0x3fdb3bd42be959a7, 0x0,
    0xbf96747df6285baa, 0x0,
    0xbfe2c3f491e6c4ba, 0x0,
    0xbfe5be2e5fcfe6db, 0x0,
    0xbfde3146a34f82dc, 0x0,
    0xbf92dd5f1a7bb338, 0x0,
    0x3fdae70763d6f06f, 0x0,
    0x3fe6ad4d9975291c, 0x0,
    0x3fe0909472904bd8, 0x0,
    0xbfadb1ca9c30d02d, 0x0,
    0xbfe0de116ab210a6, 0x0,
    0xbfe469ea2da6c3ac, 0x0,
    0xbfddfb16523cb15e, 0x0,
    0xbf92c2e3a80660a6, 0x0,
    0x3fdff0237aef9f02, 0x0,
    0x3fe597f91cb48879, 0x0,
    0x3fdbf7d530ac42da, 0x0,
    0xbf8053fba5df00ea, 0x0,
    0xbfe1057c2e882945, 0x0,
    0xbfe42fcd867d220e, 0x0,
    0xbfdfd05099e40b94, 0x0,
    0xbfbc42ea2580016b, 0x0,
    0x3fe01834dae14063, 0x0,
    0x3fe7b2e8a778ad8a, 0x0,
    0x3fe273f3d2de7c8a, 0x0,
    0xbfa98d45c5156394, 0x0,
    0xbfe2bd3f934dafb0, 0x0,
    0xbfe6c3b1c3ddd0e6, 0x0,
    0xbfdc40e6eba2d5bf, 0x0,
    0xbfa36c21456ebd98, 0x0,
    0x3fde9f30d6d92e0e, 0x0,
    0x3fe79cc082381e33, 0x0,
    0x3fdc4afa84f07b8a, 0x0,
    0x3faca37598b3b934, 0x0,
    0xbfdf13fb2cbe5cc6, 0x0,
    0xbfe6d087aca61475, 0x0,
    0xbfe0639cb2313520, 0x0,
    0xbfb30e32b762dce8, 0x0,
    0x3fdcc14e8241a33f, 0x0,
    0x3fe5459c208587f5, 0x0,
    0x3fe0e89facefa6aa, 0x0,
    0x3fa9d57fa673235d, 0x0,
    0xbfe2e8156aa13af5, 0x0,
    0xbfe64fbb84679e87, 0x0,
    0xbfe0d24f7799a240, 0x0,
    0x3fba59de62772b51, 0x0,
    0x3fde8eaedb1348c7, 0x0,
    0x3fe51e14dc8b39a8, 0x0,
    0x3fe325b3a4d0d1ff, 0x0,
    0x3f9a88c51053111a, 0x0,
    0xbfde87b77a33f0a5, 0x0,
    0xbfe2456ed2985be0, 0x0,
    0xbfdedcd621ca78db, 0x0,
    0xbf8f2f51744e25d4, 0x0,
    0x3fe223df35ead1b7, 0x0,
    0x3fe7ff72a41c6b64, 0x0,
    0x3fe1358f3dd249fb, 0x0,
    0xbf86b61e60a95fa8, 0x0,
    0xbfdf864bf0385820, 0x0,
    0xbfe50e4dafc65f29, 0x0,
    0xbfdd7fdc0ea13790, 0x0,
    0xbfb0d4ede2c4ed4b, 0x0,
    0x3fdf9143f7ce8e08, 0x0,
    0x3fe537975f2d1648, 0x0,
    0x3fe05e653d48b2d6, 0x0,
    0x3fb87c0ee1acc137, 0x0,
    0xbfdcc56df3ac658f, 0x0,
    0xbfe91aac47c746be, 0x0,
    0xbfdb0d59b5a2ce61, 0x0,
    0x3f822b94070b18e6, 0x0,
    0x3fe34b70d3b87d55, 0x0,
    0x3fe6f2317ba67925, 0x0,
    0x3fe0f47bc74564bc, 0x0,
    0xbf82e2b8db98adf7, 0x0,
    0xbfdb1829db92460f, 0x0,
    0xbfe5100edbb75688, 0x0,
    0xbfde91f29be11dda, 0x0,
    0xbf99388764b9a522, 0x0,
    0x3fdefd55a52644a6, 0x0,
    0x3fe5dc940781d450, 0x0,
    0x3fe39a3d1eaee16e, 0x0,
    0x3fa28781547123fc, 0x0,
    0xbfdf3b40b53df2e7, 0x0,
    0xbfe896f8d36d9784, 0x0,
    0xbfe0aa795ede4913, 0x0,
    0x3f7567a4259cb4f7, 0x0,
    0x3fe31f9e48169cbe, 0x0,
    0x3fe88a72553ebab7, 0x0,
    0x3fe396bd496aabe5, 0x0,
    0x3fa44218418a957e, 0x0,
    0xbfe0ee1cd0883165, 0x0,
    0xbfe658ec00e14af7, 0x0,
    0xbfe3686914286ab1, 0x0,
    0xbfb266203afa7236, 0x0,
    0x3fdbba7ff5f0f85c, 0x0,
    0x3fe3b1a24425a4aa, 0x0,
    0x3fe02013f15d37a3, 0x0,
    0x3f8001838609ede9, 0x0,
    0xbfe01f04baef2bc7, 0x0,
    0xbfe83e3d32b6f2b2, 0x0,
    0xbfe0b1a7bd5437dc, 0x0,
    0x3f9095ba46ed3b3c, 0x0,
    0x3fde8e8e31bc0712, 0x0,
    0x3fe6c5f994482aec, 0x0,
    0x3fdd1716e60be7eb, 0x0,
    0x3fc04c113c4e64cf, 0x0,
    0xbfe0852c395483a9, 0x0,
    0xbfe8d5629737f6b1, 0x0,
    0xbfe21ba68f33fb9e, 0x0,
    0x3f908b58493074b8, 0x0,
    0x3fdceb53e29cd994, 0x0,
    0x3fe70cc06582f1cb, 0x0,
    0x3fddb14b9be9764a, 0x0,
    0x3f9364fc05191415, 0x0,
    0xbfe11a5b977ab8a3, 0x0,
    0xbfe6b8a46777b020, 0x0,
    0xbfde9d5fcb21149a, 0x0,
    0xbfae4c480fc15f0b, 0x0,
    0x3fe14e206368ad49, 0x0,
    0x3fe72695633572fd, 0x0,
    0x3fd929c11c5b704f, 0x0,
    0x3fa517334276e8d6, 0x0,
    0xbfe048a57d0b33bd, 0x0,
    0xbfe7dc49122d8ab7, 0x0,
    0xbfd6c209a5d7315e, 0x0,
    0xbfab294961348a97, 0x0,
    0x3fdb17ab97818da6, 0x0,
    0x3fe5f0551eb75244, 0x0,
    0x3fe10f66455160fc, 0x0,
    0xbf8af2d04c1f5724, 0x0,
    0xbfe1ec2b93d5a5d2, 0x0,
    0xbfe5cdc617ff54d1, 0x0,
    0xbfda35a80224241a, 0x0,
    0x3fb443048da28185, 0x0,
    0x3fdfac5cbb44e8e1, 0x0,
    0x3fe504770680df90, 0x0,
    0x3fe12860541905f3, 0x0,
    0xbf873a7a17477956, 0x0,
    0xbfe143324630b0c5, 0x0,
    0xbfe565bee9e65c0f, 0x0,
    0xbfe18c50df671272, 0x0,
    0xbfa8d220b9570378, 0x0,
    0x3fe19b23c67927f4, 0x0,
    0x3fe7d69521cbf593, 0x0,
    0x3fd7e330987e2368, 0x0,
    0x3fb9fe6eeb9897b0, 0x0,
    0xbfdd2baaa5ed5901, 0x0,
    0xbfe827098c64ffc3, 0x0,
    0xbfe0aa1c59f25278, 0x0,
    0x3f98e50465516a2c, 0x0,
    0x3fdcff85e145fdbc, 0x0,
    0x3fe4466810f4c4c3, 0x0,
    0x3fdd683062bfea0c, 0x0,
    0xbfb2c541c8ec038c, 0x0,
    0xbfdde87af9e419df, 0x0,
    0xbfe6f6c707a6b32e, 0x0,
    0xbfdb600c0520e8f1, 0x0,
    0xbf95197d1ca825f6, 0x0,
    0x3fdc9461a273c20a, 0x0,
    0x3fe55b13b55f1fa1, 0x0,
    0x3fdd06f5c70abc9a, 0x0,
    0xbfaa438d0ac7f9c0, 0x0,
    0xbfe0898299e1e412, 0x0,
    0xbfe77e2d38bbe6cd, 0x0,
    0xbfded27f9b1b2a39, 0x0,
    0xbfa88a9bea9b9544, 0x0,
    0x3fe01991c1fdf5d6, 0x0,
    0x3fe6ec6d4320f7d2, 0x0,
    0x3fe1534f71463807, 0x0,
    0x3fa1f587e72bf6c4, 0x0,
    0xbfe08bc9b926aaf6, 0x0,
    0xbfe8142ececc99fb, 0x0,
    0xbfe10ae3a32d2b97, 0x0,
    0x3f826d7b5e480b56, 0x0,
    0x3fdd4c4dc442a6b4, 0x0,
    0x3fe721130e5fec69, 0x0,
    0x3fddb97b245f1fa0, 0x0,
    0xbf9a4af782177dd3, 0x0,
    0xbfdc4b8f1b8ad3f7, 0x0,
    0xbfe39c0ee9f4c91f, 0x0,
    0xbfda0dfcde490aa7, 0x0,
    0xbf88d524ee7e3d80, 0x0,
    0x3fe07d47e0b69a38, 0x0,
    0x3fe4cc33b5982da4, 0x0,
    0x3fdf0b2d50906145, 0x0,
    0xbfa720d8b8d570e6, 0x0,
    0xbfe0b5790e6e67af, 0x0,
    0xbfe92265d3497fb2, 0x0,
    0xbfdc03b3d543cb20, 0x0,
    0xbfb4ae68ca94fb6e, 0x0,
    0x3fdd3de8a4014b2c, 0x0,
    0x3fe5a9b5ded542df, 0x0,
    0x3fdc8eca0c597dd8, 0x0,
    0xbf9aa6de691f5b7e, 0x0,
    0xbfdd227fd51c474c, 0x0,
    0xbfe6067ff0f68fbc, 0x0,
    0xbfdbb2313422df48, 0x0,
    0x3fb2b07dbed4635a, 0x0,
    0x3fe111692d8f174d, 0x0,
    0x3fe6f544008804ba, 0x0,
    0x3fe1f65078f73f04, 0x0,
    0xbfa105e801365d84, 0x0,
    0xbfda6b6ae3e2419e, 0x0,
    0xbfe8a0f33d0830ff, 0x0,
    0xbfdd537e998ab2b0, 0x0,
    0xbf95c9c4c6e5ebbe, 0x0,
    0x3fe0072d1c438e91, 0x0,
    0x3fe724852ae2a204, 0x0,
    0x3fde55f9237a7e13, 0x0,
    0xbfb198af55e3dfb7, 0x0,
    0xbfdb768124357ba0, 0x0,
    0xbfe4b234de36e7e3, 0x0,
    0xbfdefffe2a2c9ac6, 0x0,
    0xbfbc1ddee43d4780, 0x0,
    0x3fdffbd4de79f634, 0x0,
    0x3fe6b48f09838ea5, 0x0,
    0x3fdc54269d0343b2, 0x0,
    0x3faaa573aa630ab3, 0x0,
    0xbfe11bbb03637930, 0x0,
    0xbfe5f6111b1d5ca5, 0x0,
    0xbfd9dbd77d7559bf, 0x0,
    0xbf99e310527d8315, 0x0,
    0x3fe0feb23b740ef9, 0x0,
    0x3fe59075b6fe5a56, 0x0,
    0x3fdc5c1234fd5e3c, 0x0,
    0xbfa8124780ddb079, 0x0,
    0xbfdd657edf1244f5, 0x0,
    0xbfe569fca030974c, 0x0,
    0xbfdd3a6b8e97d05b, 0x0,
    0xbf743558331b86f0, 0x0,
    0x3fe00fd56c15c1ad, 0x0,
    0x3fe66253dadf0ed4, 0x0,
    0x3fe011a0d76d154e, 0x0,
    0x3fa318786dea957d, 0x0,
    0xbfdd12f38865560b, 0x0,
    0xbfe6a9efeee8a7b4, 0x0,
    0xbfe0c9b892956e55, 0x0,
    0x3fb3ec4636f21841, 0x0,
    0x3fe0e43159f9bd6d, 0x0,
    0x3fe538e3a9dbb791, 0x0,
    0x3fe0ae242f500835, 0x0,
    0x3f6220962ab66193, 0x0,
    0xbfe0466305821df7, 0x0,
    0xbfe5b6f65f8da252, 0x0,
    0xbfdeb353a770d468, 0x0,
    0xbfaa0eaa834c54a9, 0x0,
    0x3fe2908a31f01523, 0x0,
    0x3fe5d3c56a785b48, 0x0,
    0x3fe1e890d2956a4b, 0x0,
    0x3fb278108abbb14c, 0x0,
    0xbfe11b4e3ef56102, 0x0,
    0xbfe5a458f8e459d9, 0x0,
    0xbfdc9a08f8d58caf, 0x0,
    0x3f6e5b46b346c9a7, 0x0,
    0x3fe0c611c3c8629b, 0x0,
    0x3fe6a69fc44e017f, 0x0,
    0x3fe022ab229f27d9, 0x0,
    0x3f8971f9ed4b6a93, 0x0,
    0xbfdb65e9f89e2651, 0x0,
    0xbfe64a9072f22a55, 0x0,
    0xbfe0095fb1f424a0, 0x0,
    0x3f97489a0ede40b2, 0x0,
    0x3fe01ed8a82f2e0b, 0x0,
    0x3fe7b51836be056f, 0x0,
    0x3fd9a6f08add6ae5, 0x0,
    0x3f984b9557aac70c, 0x0,
    0xbfdd11fd76d2e018, 0x0,
    0xbfe5f381b0f2525f, 0x0,
    0xbfdfc34e1df80d13, 0x0,
    0x3f9482dbecc3c5cb, 0x0,
    0x3fe2a92107d2413f, 0x0,
    0x3fe70d91b5f758ad, 0x0,
    0x3fe2a2e8f19cb95c, 0x0,
    0xbf3014ea9d314059, 0x0,
    0xbfde797d36298cb9, 0x0,
    0xbfe5ac544ef59e4e, 0x0,
    0xbfdc95c2e04c5450, 0x0,
    0xbfa74208d4780316, 0x0,
    0x3fdd95a98d29fbc6, 0x0,
    0x3fe6dd11b8395075, 0x0,
    0x3fdcd6b15dbb0a5c, 0x0,
    0x3fb2c34266f06791, 0x0,
    0xbfe08ae6c20b2368, 0x0,
    0xbfea0ac79ea4c43b, 0x0,
    0xbfdf8abdb5b96e59, 0x0,
    0x3ef84e420a38816f, 0x0,
    0x3fe0fbbd538ba1bf, 0x0,
    0x3fe36c7e4bf7fff2, 0x0,
    0x3fe19c7feb6e6284, 0x0,
    0x3fb20b21dda592fd, 0x0,
    0xbfe01b56df1b7d79, 0x0,
    0xbfe7a13f4dd9a4e9, 0x0,
    0xbfdde8224ce069d0, 0x0,
    0xbfb145a94c4e48b7, 0x0,
    0x3fe07ef007a78225, 0x0,
    0x3fe928514a3262b4, 0x0,
    0x3fe07b06de3a664c, 0x0,
    0x3f5d4ea8d95dc013, 0x0,
    0xbfe15a5f07b455f3, 0x0,
    0xbfe51644094666f9, 0x0,
    0xbfd7b2e47e30a32c, 0x0,
    0x3f9e733a9a45c6d1, 0x0,
    0x3fe16dd73157df96, 0x0,
    0x3fe5d5741394c0c8, 0x0,
    0x3fdf8f6d472061a0, 0x0,
    0xbfa803daf60a4fea, 0x0,
    0xbfdd77a05a229f81, 0x0,
    0xbfe56a153dc2eacd, 0x0,
    0xbfdea528e1cb06fc, 0x0,
    0x3faf79ae7012d129, 0x0,
    0x3fe1c2d1d9f64e5e, 0x0,
    0x3fe439f4c5514406, 0x0,
    0x3fe12edf89485f8b, 0x0,
    0xbfb2f9c7264ebfaa, 0x0,
    0xbfdc2e056fd245e8, 0x0,
    0xbfe7490045524e1a, 0x0,
    0xbfe11226b69aebb2, 0x0,
    0x3f798970218e6ef2, 0x0,
    0x3fe0c8574357ff4a, 0x0,
    0x3fe68089d2e00fb6, 0x0,
    0x3fdfc30f9bc7f1a1, 0x0,
    0x3fb219e591c27dcb, 0x0,
    0xbfe12be8e26e9f19, 0x0,
    0xbfe6eebad2938ab8, 0x0,
    0xbfde48d88eda45b0, 0x0,
    0xbfa739c5b45a3dda, 0x0,
    0x3fe0b3ae3016e15f, 0x0,
    0x3fe7b4514e497c08, 0x0,
    0x3fe0337736858315, 0x0,
    0xbf4405625cc92446, 0x0,
    0xbfddcd81b0547a66, 0x0,
    0xbfe53f5e4611d924, 0x0,
    0xbfe0302c80c95943, 0x0,
    0xbf7283c197d4f6db, 0x0,
    0x3fdfa64e61be5183, 0x0,
    0x3fe622c07b5b4d08, 0x0,
    0x3fdf894c96f11e5c, 0x0,
    0x3f97cb79b38bf50c, 0x0,
    0xbfddab6372867c3e, 0x0,
    0xbfe675d4f317e606, 0x0,
    0xbfd7d28a5311585c, 0x0,
    0x3fa11f662c5a7f3b, 0x0,
    0x3fe27c53cb07b3c2, 0x0,
    0x3fe4c997c6ee2dfc, 0x0,
    0x3fdfe5a3a65ceefa, 0x0,
    0x3fa665b3cccd4603, 0x0,
    0xbfe0a8ae4f8ea501, 0x0,
    0xbfe6314f753de9a3, 0x0,
    0xbfd7abd1b4d90bdf, 0x0,
    0xbfb1bf96fbc0b3b4, 0x0,
    0x3fde28ba2cb74944, 0x0,
    0x3fe706dd8592e804, 0x0,
    0x3fe1fa97ccf9e48e, 0x0,
    0xbfb4d789b3a287b1, 0x0,
    0xbfdeced6d23f6274, 0x0,
    0xbfe66e210ba0bb5c, 0x0,
    0xbfdff3d56ca1a7df, 0x0,
    0x3f8d48432efe3f88, 0x0,
    0x3fdd0d0db54da131, 0x0,
    0x3fe529662f5755b5, 0x0,
    0x3fe0d51bc630c03e, 0x0,
    0x3fb0acc8690ae44d, 0x0,
    0xbfe0a0ef841b89d9, 0x0,
    0xbfe7d17e077b90dc, 0x0,
    0xbfdb044ed2f74d2b, 0x0,
    0xbf61e1e05785f809, 0x0,
    0x3fe25cb7cf9cae6c, 0x0,
    0x3fe8b9cfab9a24b1, 0x0,
    0x3fdb00ef44ada81e, 0x0,
    0xbfa13bc2e01f8da8, 0x0,
    0xbfdfa1b8e9bfa1fc, 0x0,
    0xbfe85e49f95ce040, 0x0,
    0xbfde832e95f638cd, 0x0,
    0x3fa5248c004f10dd, 0x0,
    0x3fe0cd641d2e0c0a, 0x0,
    0x3fe5ee709c4741de, 0x0,
    0x3fddedde06e607b6, 0x0,
    0x3f6a2ee8ce078959, 0x0,
    0xbfe09d1f5631aa9c, 0x0,
    0xbfe8bf843f5fa70f, 0x0,
    0xbfe3879bd4f3aa67, 0x0,
    0x3fa94c6e259be410, 0x0,
    0x3fdf89bdcf00ab72, 0x0,
    0x3fe8ec4c6a96f599, 0x0,
    0x3fe024cec8ec20d6, 0x0,
    0xbf91b254cfb529de, 0x0,
    0xbfe315c2ba9bb374, 0x0,
    0xbfe672e795042182, 0x0,
    0xbfdbfd8740f48b1f, 0x0,
    0x3f936047d368c24a, 0x0,
    0x3fdd0866c18a562e, 0x0,
    0x3fe55878af90c7be, 0x0,
    0x3fe17f881c0ec448, 0x0,
    0x3fb997760fe37362, 0x0,
    0xbfe27385a9fc516a, 0x0,
    0xbfe719cf0701bb72, 0x0,
    0xbfdf75bfce6ca3aa, 0x0,
    0x3f88fa5199dabab0, 0x0,
    0x3fd9d78d31f932b8, 0x0,
    0x3fe71d91527e2850, 0x0,
    0x3fe1066d9e7334e4, 0x0,
    0xbfa996175da6c6c9, 0x0,
    0xbfdd26cb97656389, 0x0,
    0xbfe8d4d116b02aff, 0x0,
    0xbfdfe7fe1b1a2bbd, 0x0,
    0x3fb777e574b1f5f4, 0x0,
    0x3fdb99463d9db273, 0x0,
    0x3fe5e632bf9355dc, 0x0,
    0x3fe0795111d6754b, 0x0,
    0xbf81b6902d7ccfab, 0x0,
    0xbfdfa1a6495856d1, 0x0,
    0xbfe6479f2a3696ed, 0x0,
    0xbfde4b50ab3e2871, 0x0,
    0x3fa8543e5bd46830, 0x0,
    0x3fe0b2ad5ec40ee5, 0x0,
    0x3fe91cdbe1365a20, 0x0,
    0x3fe08b502defea44, 0x0,
    0xbf7252d540e831e2, 0x0,
    0xbfda0b027acb09b5, 0x0,
    0xbfe30e45b7a11598, 0x0,
    0xbfe09be3159f6020, 0x0,
    0xbf801825308e08bf, 0x0,
    0x3fdb0984dd9de203, 0x0,
    0x3fe7121358b54a94, 0x0,
    0x3fdf8ea8bd3160af, 0x0,
    0x3f9e87d6a776e295, 0x0,
    0xbfdcbbfe898095f7, 0x0,
    0xbfe53666014c848e, 0x0,
    0xbfdcd59e4b3865b8, 0x0,
    0x3f991445d0475264, 0x0,
    0x3fe0110c58e72481, 0x0,
    0x3fe7e0d2d58009ba, 0x0,
    0x3fe04033276f8214, 0x0,
    0xbfa371daa86a773c, 0x0,
    0xbfe199cd60c01ba6, 0x0,
    0xbfe639187f9c0982, 0x0,
    0xbfdb2e831f53d4f4, 0x0,
    0x3faafbb1d3487f13, 0x0,
    0x3fe0254ef94647de, 0x0,
    0x3fe6fbc0c9638cb2, 0x0,
    0x3fd8d9d6c66d7e59, 0x0,
    0x3f910a19998828aa, 0x0,
    0xbfe1739dbd0ec881, 0x0,
    0xbfe56a273318f00f, 0x0,
    0xbfde76d9b98e8901, 0x0,
    0xbf55ad0357729df2, 0x0,
    0x3fe02cb19669ea77, 0x0,
    0x3fe557ee6d0b1257, 0x0,
    0x3fdf977977fec4fc, 0x0,
    0xbf959c68e7d49f35, 0x0,
    0xbfdec0ac44edc916, 0x0,
    0xbfe5e6921aab0f4d, 0x0,
    0xbfe05b1b8aaf2f15, 0x0,
    0x3f96d9a416561e1c, 0x0,
    0x3fde961bc3428099, 0x0,
    0x3fe7175cf3cbc1b6, 0x0,
    0x3fe0ddc9430f35bc, 0x0,
    0x3fa100bc1180b015, 0x0,
    0xbfde05298872a402, 0x0,
    0xbfe63456bba628a7, 0x0,
    0xbfd85a8795026fc6, 0x0,
    0x3f9e7d95dc4d9851, 0x0,
    0x3fe21ac4328b7fc6, 0x0,
    0x3fe78dbee2b80abc, 0x0,
    0x3fd9cbf7e6177160, 0x0,
    0xbfa35e5df993afdd, 0x0,
    0xbfdb936dc7be23fd, 0x0,
    0xbfe776232c1e4180, 0x0,
    0xbfde449a1302f884, 0x0,
    0xbfa04e53474adec5, 0x0,
    0x3fdcc6d2369ec90f, 0x0,
    0x3fe50ccca73c6d66, 0x0,
    0x3fe0d89a625a367e, 0x0,
    0xbfa543ec7e8cac15, 0x0,
    0xbfe05df99ec2d5ef, 0x0,
    0xbfe7407c635ee076, 0x0,
    0xbfe27957e03bd787, 0x0,
    0x3f93be22ddd5a2e4, 0x0,
    0x3fdead325f81bf37, 0x0,
    0x3fe66ec4747b206d, 0x0,
    0x3fdf7fd42e0b6bd9, 0x0,
    0x3f816195cee80a9a, 0x0,
    0xbfe055c8343e1bbd, 0x0,
    0xbfe675ba74a57057, 0x0,
    0xbfdc1eb013e70960, 0x0,
    0xbfb0e1413a44be97, 0x0,
    0x3fe001a58b8e1251, 0x0,
    0x3fe5b4a50b4ea143, 0x0,
    0x3fdec96614d52ff5, 0x0,
    0xbfb2ddd6410621be, 0x0,
    0xbfde444dc1f2a39a, 0x0,
    0xbfe66f4a49c414ab, 0x0,
    0xbfe1716010c20163, 0x0,
    0x3f9e9e8a3566d001, 0x0,
    0x3fe04e87d845a8a3, 0x0,
    0x3fe7538aff1b2b88, 0x0,
    0x3fda3235e80a10df, 0x0,
    0xbfb331b529dd94ac, 0x0,
    0xbfe10b46a31e1700, 0x0,
    0xbfe5e8b3a7a365ee, 0x0,
    0xbfdb6d02c92bc369, 0x0,
    0xbf943166e34a4023, 0x0,
    0x3fe0250249f04549, 0x0,
    0x3fe56ff538a3349f, 0x0,
    0x3fe40448f714a260, 0x0,
    0x3f9b5b117777b192, 0x0,
    0xbfe35f4217e3f238, 0x0,
    0xbfe7c3348318cf60, 0x0,
    0xbfde30b2e7b86374, 0x0,
    0x3f99e289b2bc0b85, 0x0,
    0x3fe087a114016dc2, 0x0,
    0x3fe64beaf027549c, 0x0,
    0x3fdf6ccefbbb63c6, 0x0,
    0x3f9e61308cd8ac72, 0x0,
    0xbfdf7f136c86265b, 0x0,
    0xbfe5fe2359221d31, 0x0,
    0xbfddfdbcda5f7f4d, 0x0,
    0x3fa9d3fe119a92c0, 0x0,
    0x3fe01f502f95cde4, 0x0,
    0x3fe57cb58643dbbf, 0x0,
    0x3fe028e66259a0c6, 0x0,
    0x3f6f5ef84363940b, 0x0,
    0xbfe1fe3627c07ade, 0x0,
    0xbfe63db79a730f41, 0x0,
    0xbfdf9dbc5fe1af86, 0x0,
    0xbfa12201af0704e6, 0x0,
    0x3fde06211ce6d2c9, 0x0,
    0x3fe6c2d3b438026b, 0x0,
    0x3fda03f9209c7969, 0x0,
    0x3f90c1bd1fc40ec8, 0x0,
    0xbfdcdd9ca7ea3462, 0x0,
    0xbfe60da6178f82d7, 0x0,
    0xbfe0d32dcb7b1f9b, 0x0,
    0x3f7e1013fb9f4ec7, 0x0,
    0x3fe07fd8829bc41c, 0x0,
    0x3fe53b808c4ef455, 0x0,
    0x3fdc146c69d6b0e5, 0x0,
    0x3fa6973f6cab6f44, 0x0,
    0xbfd8a151d6dfc528, 0x0,
    0xbfe823d1b5aafed2, 0x0,
    0xbfe35b39d9e2e1a1, 0x0,
    0xbfb35107c2fab5a6, 0x0,
    0x3fd7fe8c29678d1d, 0x0,
    0x3fe5c2b0b92e9ded, 0x0,
    0x3fdd873f2c5dac94, 0x0,
    0xbfa182811524b12f, 0x0,
    0xbfe0d262871116e8, 0x0,
    0xbfe7d1651c3f136d, 0x0,
    0xbfdceb288855e11f, 0x0,
    0xbfaa61e6bb28e158, 0x0,
    0x3fe24de39afb0fcd, 0x0,
    0x3fe6d6f860d1fb0c, 0x0,
    0x3fdceae08aecce00, 0x0,
    0x3fa44da4350c9d8f, 0x0,
    0xbfe308ff74d6b471, 0x0,
    0xbfe5bb01673d3a36, 0x0,
    0xbfe34e8875be0e88, 0x0,
    0xbfaaf477a4376eda, 0x0,
    0x3fdc7e1a736b0814, 0x0,
    0x3fe85b117b11bce2, 0x0,
    0x3fe177979b259001, 0x0,
    0x3fb0a8d2524fc506, 0x0,
    0xbfdfe1f3a44fb2be, 0x0,
    0xbfe7feeca9454403, 0x0,
    0xbfdcb0195f1c0b7a, 0x0,
    0xbf8b13015005b5d6, 0x0,
    0x3fdfcdc6f4e0ecf7, 0x0,
    0x3fe6ab21909eb668, 0x0,
    0x3fe0f156397b5448, 0x0,
    0x3fa57d6616cc49b1, 0x0,
    0xbfe289ccc5112afd, 0x0,
    0xbfe425e6b8b470b4, 0x0,
    0xbfdd9c22f4e8b7ac, 0x0,
    0x3fa83632aee9e3d8, 0x0,
    0x3fde34c14a789a5d, 0x0,
    0x3fe63e5f08c431ad, 0x0,
    0x3fd9494afb512c45, 0x0,
    0xbf9fb067b841863c, 0x0,
    0xbfdc5a037d80f90e, 0x0,
    0xbfe516d7af4ef816, 0x0,
    0xbfdd92d77efe85d1, 0x0,
    0x3fb1ffeee0942270, 0x0,
    0x3fdf85271895df4a, 0x0,
    0x3fe6bcd199091d95, 0x0,
    0x3fdfe54a24b302f7, 0x0,
    0xbfa1abe0bc9dfec3, 0x0,
    0xbfe1724ec43fd472, 0x0,
    0xbfe3802525676da8, 0x0,
    0xbfe0f46b59fa593b, 0x0
    };

static const uint64_t in_cifft_noisy_1024[2048] = {
    0x3ff92de7e36d859e, 0x0,
    0xbfea82fed3716bb2, 0x3fef1f478d668674,
    0xc000daeec11c5e51, 0xbfd42fa31eb0a387,
    0xbfd8f1a95ee05819, 0xbff13aafca665fb4,
    0x3ff296e6bb6e1f37, 0x3ff99adfcacc65e1,
    0x3f64534ec8384680, 0xbffd7806ca4ff692,
    0x3ffbc3c6708e4497, 0xbfeb48e891660b96,
    0x3fbb7b0bc7a13398, 0x3fd3cebb3a1d45aa,
    0x400198e1e38e1b3e, 0xbfc0da9818fe4a86,
    0xbff6c6a25c494351, 0xbfcba45b3a1d0de7,
    0x3f85fb57509c3800, 0x3fe9fb05092d9da9,
    0xbfe7e4f261dcb920, 0xbff8be348d0f49ac,
    0x4000ad4d03ec1a6c, 0x3ff6d94661d936ea,
    0x3ff72c73ed072470, 0xbfc1c26cbf1b1dce,
    0x3ff1d0afb2a30de8, 0x40033af0b208c025,
    0x3ff48b93a633d039, 0xbff47a83ee98a9a8,
    0x3fce9f5a7c6873b4, 0x3ff022a528419f6e,
    0x3fdcac163f7d7f67, 0xbfcd79da06ed5334,
    0x3fe851f5b38903d3, 0xbfdd666fe3d2a22e,
    0xc008d438ce350004, 0x3feafc7fb910a902,
    0xbff1e6255e2a24b3, 0x3fee5dd0b535fd65,
    0xbff9f4a68e97065c, 0xbfd2a30e5c427e4a,
    0xbfeb32f0a6a65560, 0x3fee0a64aa2e9fef,
    0x3fc9ca9593f1f1ec, 0x3ff4023da20bd6b8,
    0x4000549b72e2502d, 0xbfde93bc9faa8beb,
    0x3ff1b2dc01b216e4, 0x3fd363baa62eaf8e,
    0xbfd609751e00fe2e, 0x3ff2c7f9bf68a2f2,
    0x3ff0ca3b447ba091, 0x3fde631068add90c,
    0x3fe82c7c6f16ceec, 0xc00404067f8d405f,
    0x3ff09f0327769f52, 0xbffaa50b1bfb09e6,
    0xbfe2fa25558e5bb2, 0xbffaa6c0fd3825c6,
    0xbff4ea94117508bf, 0xbff215dcc732eca9,
    0x3ff3ce1282a84731, 0x3fa0e5c4ab0fb32c,
    0xbff4917c7e368840, 0x3ff95cbbc12332cf,
    0x3fda3b0b39616f02, 0xbff2a3270f7ecf9a,
    0xbff2bc72fa47c5b0, 0xbfe02c89ae6d6484,
    0x3fd314db927e8cbd, 0xbff2984d780c5998,
    0xbfdddfc0d61dec7e, 0xbf9b8637316b4240,
    0xbfda0f318755a632, 0x3fd65ebe5c7e2d88,
    0x3fea67a7f0bcebc0, 0x3fd360aec40b3a85,
    0x3ff22ff2867f7d1d, 0x3f9b13e5257caea0,
    0xbfe503609f2e05ab, 0xbfbddca0e824cc34,
    0x3fecee54f46534e2, 0x3fc13af7977ac6da,
    0xc006e7e436405060, 0x3ffbf342c20e43e6,
    0xbff62d9010869304, 0x3fc357a55c4ebc7f,
    0x3fec1460273207ba, 0xbff94039c2f5f408,
    0xbff7010866f6f3e6, 0xbfd5fa4f61a60769,
    0xbfc89f30dea6242a, 0x3ff99930af692474,
    0x3fdd0311e242989d, 0x3ff7cb2cc02c3bfe,
    0x3fb8733046da7cc8, 0x3fb7331f6b359358,
    0x3fe930aa5c30eb58, 0x3ff76c9d3f9e0222,
    0x3fee3a82ce8f3ff8, 0xbfe7965c3ea1fd56,
    0x3fd888b45d8527e8, 0xbfc2b54bfc4e7740,
    0x3ff38d3375226bc6, 0xbfef1a3c6568a40e,
    0xbffdb89764f7d73c, 0xbfefbe3c952a8cbe,
    0x4004da2396d78df4, 0x3ff39d1207bb6f22,
    0xbfe5226c22544013, 0x3fd87f9cc81e2bc2,
    0x3feaafd60cde35d1, 0xbfdff0c252efa5ec,
    0x3fea2101ba55c4cb, 0x3ff22724da5c9efe,
    0x3fc13d2b485281e0, 0x3fe8323c66265762,
    0xbfe35e582c2dfe5e, 0x3fa7a15ef9a1a860,
    0xbfb0def23c8cff30, 0x3f83a5d7a7155640,
    0xc00380b42ceeeb58, 0xbfdf08d884173aef,
    0xbf7110eb74a7c400, 0x3fab20b20ab6df90,
    0xc002e71424472b04, 0xbfd9f5df250fd1d8,
    0xbfe48e83eec865ec, 0xbfc62b9185bd5fcb,
    0xc00181f86d7ae061, 0x4004292c76dd0236,
    0x3ff0f862d3f477ac, 0x3fc2894f5350fa14,
    0x3fec276b3cedae80, 0xbfe1c583c98aeb04,
    0xbfd5fe3283eb2fe6, 0xc00495636ff0a75a,
    0xbfdf3ef9e321a372, 0xbff2e4c25e8aa778,
    0x3fa9232217d165e0, 0x3fca971bb0d64797,
    0x3fe877e5b959a43d, 0x3ff3dd41ed561b70,
    0x3ff0bca4c7cad4a6, 0xbfebbb8425f17f71,
    0xbfd1ea3a3c6391a0, 0x3fc3d8077be08b00,
    0x3fe9e54d2f2f0eed, 0xbfebc498dd09fee2,
    0xbfc5ae4dcbc23410, 0xbfd8134058a643e1,
    0xbff1a58ae0119216, 0xbfe05afa2cd6111e,
    0x4000bd5d354c96d4, 0x4000c90e71892834,
    0xbfce951adb8de180, 0xbf46170f234cc800,
    0xbfd012776ed4966b, 0xbff3f5bb44bbcb80,
    0xbfd4887911432c1a, 0x3fcc72f8d9d98510,
    0xbfd5dd186f3e4f28, 0x3fe6f73cdc87663c,
    0x3fefb53b6d480d2e, 0x3fd11df3993b91a6,
    0xbfeb6f2c5feceb89, 0x3feaeb650133a68c,
    0xbfcd29eb16f63154, 0x3fd989bd79dc90fa,
    0xbfd6646f7ef145dc, 0x3fe001c753623528,
    0xbfd78409f101d946, 0x3fc7bf6132ffb594,
    0x3fe796c4fd9300cd, 0x3ff25b94aa7d2080,
    0xbff5402d0054a25c, 0xbfd9f39f81b93552,
    0x3fec711372d3f8d2, 0xbfcdea963e332614,
    0xc000e20283102f9f, 0xbfeb4fa0735d90bf,
    0x3fa9fd4d8b5a5084, 0xbfec779b317fa40c,
    0xbff6ee879d959286, 0xbff7605212767ca5,
    0x3fe13c0a403114c1, 0xc00466cf67997890,
    0x3ff8e84bb082e39e, 0x3ff3be6087a01b34,
    0x3ff25433b44a9e7b, 0xbfe2e03b4bf69e28,
    0xbfe8adfb9b930018, 0x3fc90b16fd5d57bf,
    0xbfc53b1dadc0a5ca, 0xbfe2892d50e66903,
    0x3fed13aded83d074, 0xc006f30eb5646aec,
    0xbfd50d9b3eba348c, 0x3fe868e4535a7d47,
    0xbfe895e438c36f59, 0xbfefd8c85566f2c2,
    0x3ff1466d78ad6b9e, 0xbfe6d1c4a1c1bba5,
    0x3fee4070ea72462b, 0x3fddadfabec79516,
    0xbfd05f285fcbb684, 0xbff28deef3757322,
    0x3fe7b77f75958509, 0x3fb738f255b5fed6,
    0x3ffaac38007e369a, 0xbfd4be2addffb633,
    0x3fbfd5e940620fb0, 0x3fe2613e25badc59,
    0x3fed14f0e9bfef42, 0xbfea15deea65a162,
    0xbff31559b29ae768, 0x3fc13e1aa43a14bc,
    0x3ff24a06e1ca4262, 0x3ff0c904a4f072a0,
    0xbfe7edecc8318126, 0x3ff26540c213dd95,
    0xbfe89a8e6b23e9c7, 0xbfe1e80ec74c1afc,
    0x3fe39ed239e44c92, 0x3fc0ee454ebe5954,
    0x40026d2c9f0b2d93, 0xbfead873b4b21bd3,
    0x3fdf2dab2c51c6f4, 0x3ff5cd3d971e929a,
    0x3feb7fe7bd028022, 0x3fa124ac1e5eeea2,
    0x3fc48e48985ff928, 0xbfd1ad73eda6c438,
    0xbfa27663da35abc0, 0xbfff039f828347e7,
    0x3fd6bd4f965af76e, 0xbfc606caa14315da,
    0xbfc54dc188baea20, 0x3ffb46fd9f263647,
    0x3fd75ea6f6918dd6, 0x4005cc65752ac38c,
    0xbfdba56d11aea2d9, 0x3f96e440d7fecf00,
    0x3fac356693c57168, 0x3ff15d18a9518f68,
    0xbfed912d46eb8380, 0x3fc77989e1ddc53a,
    0x3ffb4357a302117d, 0x3ff5e70ee145586b,
    0xbfc509e56b47672c, 0x3fd1a972c42e02ed,
    0x40051270612dc0ce, 0xbff13a528ac8915c,
    0x3ff33ada0eeb6e00, 0xc0767d785499e3b0,
    0x3fc8ce9b511529a0, 0x3fb3002040002d20,
    0xbff43115bc4fca02, 0xbfd3a2dc8a6b34b8,
    0xbff8719f1e9c024b, 0x3ffa7843653f6e74,
    0x3fddacdf1d586994, 0x3f87f54c078bc780,
    0x400776c5825cb4c4, 0xbff0f3e389e45e96,
    0xc0002f17c79d55f9, 0xc00018ea1b890b99,
    0x3fed7c5e3e6c936a, 0x3fe88bb0abdf2b1f,
    0xbfd7b03c5ad3cc58, 0x3fd31980c3a3d09d,
    0x3fe3c668eb184e76, 0x3fd6bbdca8476120,
    0xbf7c3ccf49c46100, 0xbff6904cd8d89d8f,
    0x3ff4372e50f4f47c, 0x3fe3a7b4175e0d99,
    0x3fe9fc5f94728f3b, 0x3fef5b8590bdd2f5,
    0x3fe8748e596c4c47, 0xbfe08169c9e33c82,
    0xbfc51b263e469aa8, 0x3ffe773efc63b110,
    0x4006ff0a2e4bdc7d, 0x3ff4d1e0ec7340fe,
    0x3fe678303013f9f1, 0x3fec3aa826baee0a,
    0xbfe5fa3b699a0ef3, 0x3fd76c6a5a422de1,
    0xbfc5364e65769a7f, 0x3fef0120b96776d4,
    0xbfea1864e3acbbc8, 0xbfd061cb70d552a6,
    0xbfe9f9a1203ed892, 0x3ff27abf7afbba88,
    0x3ff59397b828d7dd, 0x3f74bf21a971b760,
    0xbfe921eb6d4e4039, 0xbfbcebb0a5f51814,
    0xbff27a4051553450, 0x3fec972ac7b50cad,
    0x3fb3e102cd581b8c, 0xbff14d32b1c83fcf,
    0x3fdc459cbe5c2ec6, 0xbfc2a8bc5f3c0770,
    0xbfee7ca7d6194ad6, 0xbfd1a374139f53d6,
    0xbff5ebf084a69972, 0xbffa370e07eddaa7,
    0x3fe0b39e4d5c9532, 0xbfd84a2036d6fa02,
    0x3fe19ef1bd921173, 0x3fd7f3ba0239eecc,
    0xbff1448afc38448e, 0xbfe08bc7411c1f24,
    0xbff13227cd94b467, 0x3fcb25263383b3e9,
    0x3fd8b748baeadf1c, 0xbfed4d9f2ba4ed60,
    0x3f8d6bf8f359cba0, 0x3fe0b9edd9b8c4ee,
    0xbfefaf0a3e9a1ae7, 0x3feb64c0b7071742,
    0x3facb000f8353e80, 0x3fcecfc0a4b5011a,
    0xbff9d2bc2462bee8, 0x3ff874e553da40c6,
    0xbfda13a11088a4a7, 0x3fd980516a84003d,
    0xbffec3d92e146883, 0x3fbe0d30fbd95c50,
    0x3ff667fa0a12ed8a, 0xbfe77ddf7fb953b3,
    0x3ff50bdd51138f24, 0xbfe5d567cfe67cec,
    0xbfc90c22ef0d0990, 0xbfbfc95e20304680,
    0x3ff8bf195a74cb76, 0x3fca9448fd4f4684,
    0xbff957307fe9026e, 0xbfdf603742226db0,
    0xbffcf3fa5674fb45, 0xbfd270a14343f6b9,
    0xbfd40e0eb9f5e668, 0xbff777e5fe283911,
    0x3fe2dac611fdc6ca, 0x3fd248cc16aaaacc,
    0x3ffaf51e5174ce74, 0xbfeb52fd57b048e6,
    0xbfb9f3b2fa8168c0, 0x3ff2134443829df7,
    0x3fd60220ef68e560, 0xc0014ebcc09637b6,
    0x3fc2f06e3c059100, 0x3ff9a898035c0b60,
    0x40005968f2ae1841, 0xbfce34256992fcac,
    0x3fd9df8ed55d2947, 0xbfe0f751d269078d,
    0x3fef6d9ac74e6805, 0xbfe80b961e316eb2,
    0x3ff15ea08709b8a7, 0xbfe1ae55a340ea80,
    0x3ff70ac5c6b0687a, 0x3f8cfb8de6e972e0,
    0x4000dbb02d84c5eb, 0xbfe414736f39fbac,
    0xbfe822e9c83269d4, 0x3fd77efb71220c04,
    0xbff04bf13b854a1d, 0x3fed6051817e2d66,
    0x3fc379d5198dfd18, 0xbfe752c22ea142d2,
    0xc0010ab1ea14998c, 0x3fb639d06bfb52bc,
    0x3fd69da853e80c4e, 0x3fee9cd995d12da2,
    0x3f83e48087bd9480, 0x3fe04e8e6ebe9178,
    0xc000398fae5c5dea, 0xbff6c98fdddc83d0,
    0x3ff076da4a0f9e86, 0xbfeea09126bf2a72,
    0x3ff18e0715b659cf, 0xbfe5877b802c9826,
    0x3fedb58195bf484c, 0x3fd87f1f357d4770,
    0x3feafdb9f92a7ed2, 0xbfb02da65d9e7930,
    0xbff0c06bab034230, 0x40010dd9625b7a54,
    0xbff5c0c624da9947, 0xc00c56298231f2ba,
    0xbfd8dd6845a81fe4, 0x3ff98c1f1c208d5a,
    0x3fea25fdda3dbf02, 0xbfeb0cf8f7574e24,
    0xbff1556c7a0f6ed4, 0x3febc15246a967f4,
    0x3fcf9da5feb07406, 0xc00074912b58daee,
    0xbfeaa8433c5b656c, 0xbfc665309df3f05c,
    0x400710fdc783c374, 0x3fdc4ba182f0b472,
    0xbfd4d8ceca5265e8, 0xbfe17120ad445868,
    0x3fc4ea3371470556, 0xbfdd29565055532c,
    0xbfd5c49c8a7a1c79, 0x3fd587166c701411,
    0x3ff0ffee1ede08fc, 0x3ff86efa061b8136,
    0xbfdc650091f30ec6, 0xbfe90c54439c03a6,
    0xbfe0cd6056997542, 0x3febb6d2abbc1899,
    0x3fd5a3bc71afd2d4, 0x4006bd35de480b84,
    0x3fc56d245f2a589c, 0xbff52bffd6d98fca,
    0xc0001cc7a2dcb948, 0xbfe999eda065e3a8,
    0xbff020b3ceaa393e, 0x3fdf71baf89279c0,
    0xbff77fea4b068053, 0x3fe07942e86a23ef,
    0x3fda856675e99227, 0xbff9898379dba678,
    0xbfe796ebc3021fcb, 0x3ff609936c2a122c,
    0x3ffa3dedf8244af0, 0x4003ae0681204361,
    0x3fe4f839cb6c9314, 0xbfef5fa361245574,
    0x3fe9656dc4e1a182, 0x3fe101ff8f3dd6ad,
    0x3ff49767a701f754, 0x40003be88a6f55f0,
    0xc000ddd6fb574c15, 0xbfd6becabaa2a1c6,
    0x3ffbada9b411ce2a, 0xbfe630412cbfa776,
    0x3fd63178bcb2112e, 0x3f835267b284dd80,
    0xbfe9db87d005571f, 0xc000f3c0437d8c18,
    0xbff26e9eea5680fa, 0x3ff55a65b3de1a74,
    0xbffda580632ef6eb, 0xbff9c9329046afcd,
    0xbff599f615f35425, 0x3ff97e9aa57350b8,
    0x40008234c7b27039, 0x3fd7b0dbbfa84494,
    0x4005151f518ca118, 0xbfc1901f0832535e,
    0xbff5041cea1c10e0, 0x3fbc18637dce6358,
    0xbff37ce549663dee, 0x3ff7592892d6f7f7,
    0xbfdcd703d18be462, 0xbfe98de1f7714759,
    0x3fe41bdc3e4fd0cc, 0xbfff3f775cd8c0da,
    0xbff1e7ef1d6aa059, 0x3fc2a991b8c3b4e1,
    0x3fe286dcc43b7f56, 0xbfd9d1c20564b212,
    0xbfd19ae7df5a0f3a, 0xbfddc5a0be51601a,
    0xc0003ad9cf8c3ed2, 0xc0121e3d52499abc,
    0xbfe4afd77e6c8ba7, 0xbfd9b971c652faf9,
    0x3ff5846d0ba43fbb, 0xbfe78a7ec5f4ef0a,
    0xbfd2bcab7fa7de44, 0xbff6c6753fb8839e,
    0x3fe646c2aa637af2, 0xbfdba199ad7178fc,
    0xbfed454ebc111e84, 0xbf8429940996b860,
    0xbfe7d66661fc10b2, 0x4005786512fc8c71,
    0x3fe5a9145999e146, 0x3fdeb29a30f5c9f6,
    0xbfd8146107dcde60, 0x3fe5705f7f03e996,
    0xbfad7b49bebb1000, 0x3fde46702bfcf95f,
    0xbfe644dc70c7440c, 0x3ff37b954a09a76c,
    0x3fa4260dc82b2c30, 0xbfbfc401ffdf07fc,
    0xbff98e61befae3ce, 0xbff99305f87698eb,
    0xbfec9eb8bac3ad87, 0x3feb1b90c7a8de72,
    0xbfea6de9cc3a7674, 0x3ff1c14cef402e1d,
    0x3fef888cfb4ae0e1, 0x3ffc5a941c422a07,
    0xbfe065d5f10d3f46, 0xbfe15914446eb346,
    0x3fefefe90fe96f9e, 0x3fe1817ed26109e3,
    0x3fd2778048cb8ad1, 0xbff08e8b3b2e6062,
    0x3fc2d326d1b620f0, 0x3ffa3822ba432c00,
    0xbfdb221f8ef1701b, 0x3fdd11714c381ea0,
    0xbfe8a7cba09564f6, 0x3fe2426420e464ce,
    0x3feb580a6d63f3dc, 0xbfe1ef05b4d210f3,
    0x3ff9439daeb84bc6, 0x3fd24892391e6d74,
    0x3fedbf15c5530eae, 0x3ff8c323f5332454,
    0x3fe266c78f6e7c1c, 0xc00038ed3a84ac18,
    0xbff04089a83361b4, 0x3fdd1fcfb589ddca,
    0xbff19a5dd7b173be, 0xbfe5501b3481f530,
    0x3fed731a2452feed, 0x3fe197ab9651498c,
    0x3ffd55a5158f40ea, 0xbfb411a1228efea8,
    0xbfcf7e780a15b08a, 0x3fa694bc91bb6d50,
    0xbfc2c105566186f0, 0xbfedb2631bd0bde2,
    0xbff5cdb403a4200d, 0xbfe134952b4a7e3c,
    0xbfebd2ff76b35367, 0xbfec7ef46d53f8e9,
    0x3fc2ecaa8b3cfcde, 0xbff3b4f77067b7b1,
    0xc0008e7d7f3cae4e, 0xbfe26748970a1279,
    0xbfe9958308bec801, 0x3ff8a2a42b6101f0,
    0xbffecbd751ae1a8b, 0x3fe6d06275744369,
    0x3fe9737b59a999df, 0xbff96a69a1b91831,
    0x3ff202fab9cbb9d2, 0xbff540fe4a12f916,
    0x3fb18f9f73ef4cf8, 0x3fe316d9d99da3dd,
    0xbff1ed8cacb8fa00, 0xbfc7cc846522414f,
    0x3fc0c094298cabd4, 0xbff3b31142a50ab0,
    0x3feaecdc22172c70, 0x3fd75cc34d1ae272,
    0xbff1548d8b42d19d, 0x3ff15b3f4f5d3fb6,
    0x401062f4500a96fe, 0x3ff1acbddc9132de,
    0xbfe2348952cff894, 0xbfeeb3690c103498,
    0xbfe85df2f9ed3d35, 0x3fc2c5867d999872,
    0xbfe25e40bce4bc58, 0xbfabff1c3c69cec0,
    0x3fe2ba9556b8320a, 0x3fe4ef0b276302a6,
    0xbfd820575273d86a, 0x3f8663976dc12a40,
    0xbff302ad81fc1aaf, 0xbff2cd4db0ef745c,
    0x3fc8911ba96f8cb0, 0xbff0273325f2748e,
    0xbf895dd1c08f89c0, 0x3fcf5f364fd73c07,
    0x3fdb5fd17b160850, 0x3fbd23e8fab4488a,
    0x3fe118c6dd4c949e, 0x3f679fe0b6ecb400,
    0x3fe078da3afa7869, 0xc001aeac440cb9de,
    0x3fe07d6a3100d472, 0x40016b2cdc06fa76,
    0x3fc2f47bfc51b9b0, 0xbfe7002b61232a20,
    0xbfae2b99ea18a320, 0x3fd46021565b3b90,
    0x3fef006bb5649b2f, 0xbfeb6f49a4ded926,
    0x3f9887b18f4168c0, 0x3fed4eea8019a0ec,
    0xbfc5157c3a23245a, 0xbfb4ea1bfc320a9c,
    0x400051adea3da9d0, 0xbffcd03de8d2cf6a,
    0x3ff5e5f895441e4b, 0x3ff9408d9f799b4e,
    0xbfe1c0d934bbf75c, 0xbfd7ed673c48f674,
    0xbfec8c5b16814d49, 0x40006cfa902b9c4b,
    0xbff350aaab5e714e, 0x3fd437aee97c849e,
    0x3fe7a399d7747d2a, 0x3fefb7beba9dce98,
    0xbfcf23e5bf8d8228, 0xbfe06a55cb0dc20a,
    0x3fe7fc66a77edae7, 0x3fd69447b09fb388,
    0xbffc40df88c2d02c, 0xbffce6651bec3195,
    0xbfec71aec38b4b93, 0xbff394fb410b4b88,
    0xbff1d44fbdd8f567, 0xbfe1599702dd560e,
    0xbfe4cd6510565bd0, 0x3fdf2fb3930e34a2,
    0x3fc8595f523b2ec8, 0xbfe1c9908dd49156,
    0xbfd83fbe064cae44, 0xbff2ea308efaee42,
    0x4002650a138e0d86, 0x3fff306e1ed32087,
    0xbfded408f7cfa350, 0x3fd95044b637d834,
    0xbfee0ccf8b14b01b, 0xbff4f44cb71229d3,
    0x3ff2dc905b50c476, 0x3fd47486d2cb9a4a,
    0xbfea512d3c24382a, 0xbfd86e2438858cff,
    0xbfc3413a48964754, 0x3fda36079aa150a8,
    0xbfd2f7d963717ad5, 0x3ff1b6fe9114c818,
    0xbfe69d8e0eda523b, 0xbff26cb2b602c6f3,
    0x3f71ee7a786fa640, 0xc0030dacef1f1e0d,
    0xbfc3347c44c2315f, 0xbfeedb8b9b8e1f8b,
    0x3fe64f212b02a4f1, 0xbfc9b05a3bc3e327,
    0xbffa636557826452, 0x3fa027b01c5cfea0,
    0xbfb1204701362b60, 0xbfe422a5b38a209b,
    0xbff19d84838c4fa2, 0xbff7f6dd420b2cb3,
    0xbfe5cd25c1861f4f, 0x3fd1dfb26534d720,
    0xbfcb6cef17d6ca30, 0x3fdf611971ab0f7d,
    0x3fd873c4f1e9723e, 0xc00115434cfafae8,
    0xbfefb898458fe78d, 0xbfcaa929fc2ac928,
    0x3fdddb7ca8449796, 0xbfed98b7501b8d48,
    0xbf4fec6ea0f9a800, 0x3fe3d4ceaccd5319,
    0xbff89a7abc997770, 0xbfd10d5aea595c70,
    0x3ff05981198aad16, 0x3fb378dd9f126600,
    0xbff3506ffcc8c4c1, 0xbffc59ca770b0300,
    0x3fe8d38ef5bfce07, 0x3fb5cb5e2ca0faf0,
    0xbff96d1de7431dc2, 0xbff9819c2668cce5,
    0x3fd7986ce555818a, 0xc00e800c1d4772b1,
    0x3ff2d62d8661215c, 0xbfd85d8fab8a023f,
    0x3fe9967c83011ae2, 0x3fe8da125cd7a340,
    0xbfc5b8e8e9956470, 0x3ffb17b6b9973901,
    0xbff2477a7394ae0c, 0xc000591169176b5b,
    0x3fe766b051661fa0, 0x3fddffe9e699f236,
    0xbfdeab0ebafa0b8e, 0x3fe79740e0755938,
    0x3fe0247727aeea18, 0xbff1ba910548672f,
    0xbfe216a2c930b2f0, 0x3fe2d1b3f4780c5d,
    0xbfd1563af85f1f50, 0xbffaa66b12b5fd3c,
    0x3fe1263bac85ecfe, 0x3fcbbe9f7ea6480d,
    0x40023379c6145244, 0xbfd4cfdf41d24012,
    0xbfe7d030612008f0, 0xbfc7f61f9f141334,
    0x3fe6f99eeef32aea, 0xbff7043f51b6af9c,
    0xbfff1656d1339e53, 0x3fc6743f15ea1c46,
    0xbfd40718ac78e62b, 0xc0056a2e06ec029a,
    0x3fb483f1e0e16d40, 0xbfff9cc086093b15,
    0xbfce8797d3efd1af, 0x3ff7b00876dfdb1c,
    0xbfeb2df803d67248, 0xc007df69ef8d5be9,
    0x3feaac57eeb454c6, 0xbfe40f0ddbae42ae,
    0xbfe734f58ed90291, 0xbffbe98a193ec599,
    0x3fbc8beff78539c0, 0xbfee43a0a5c2f2ba,
    0xbff1199c2f53c320, 0xbffcea2311b0568c,
    0xbfd4dd77e4130a3b, 0x3feb71d65712893d,
    0xbfe35bd9a46d0185, 0xbfd8e15a56f4779a,
    0x3fc811f81b668b88, 0xbfe78d8e1f6e1eac,
    0xbfedd72821012114, 0xbffdd6cbb8c43406,
    0xbfe11b60e4c4ff68, 0x3ff50e29d080e1a6,
    0x3fcf2a76fc1c6e68, 0x3fe720a98692c1af,
    0xbfe3792cd5c18e36, 0xbfac19d4d9ca03c0,
    0xc0009da539a11eef, 0xbfe0aeb704497bca,
    0xbff6407760a19526, 0x3ff47d9e498cc818,
    0xbfe6a3376c86a014, 0x3ff0f7475f3de700,
    0x3fe65cbadc5b9282, 0xbff80918046f2bb4,
    0x3fe5d6136ea2d32a, 0x3fc03697931b33c9,
    0x3ff5bc60386054cc, 0x3fe57d9b83d1cb3e,
    0xbfe3e7e30a06027f, 0xbfc8343307617b9b,
    0xbfc48a70ba8b3d94, 0xbfe381819028e6fe,
    0xbfe4692675d531a4, 0x3fc571fed2938b6c,
    0xbfdb85015a46dea2, 0x3fe39dd3748bf96a,
    0x3ffbd7d9e79308e8, 0x4002f794d9b08b12,
    0xbff09414578cc3c6, 0xbfe73fe892617790,
    0x3faa32c0661bc980, 0xbff073e43b735b2e,
    0xbff7e76ac2ac68d1, 0xbff8fb8dc3c3e826,
    0x3ff01e91b094a970, 0x3fe527a9cad66b2c,
    0xc00836ddd00f7ef2, 0x3fec0840111fbf00,
    0xbfd2749104a8f708, 0xbf92565b70ee34c0,
    0xbfe564b95917c336, 0x3fc462b08a8e5552,
    0xc0002d10fee2db6b, 0x3fd0f3e53c19cb02,
    0x3fd8d076094cbef0, 0xbfeb5fca6c09408a,
    0x3fd4afac2f5398c2, 0x3fdc565c18b42bb0,
    0xbfbb975315222ecc, 0xbfabc17732990aa8,
    0xbfe40b3bd7875242, 0x3ff0721bab1b79e8,
    0x3fd71d5d74a065ea, 0x3ff01968c756ac7e,
    0xbfa9fe36067a1e3c, 0x3fcbf8599e78906c,
    0x4004e670f1231a12, 0xbff0fc6d992514d7,
    0xbfe321b0056d58ac, 0xbff840a789b8efe1,
    0x3ff72987b227d8b0, 0xbf8304b73123c3d4,
    0x3fe1d675d0784adc, 0x3fc7caea4ac4576c,
    0xbff41ef8bbc8ab7c, 0xbffba13a1eaf35ee,
    0x3fe1d02cef38064a, 0xbfd00761ab5bdcb4,
    0x3ff436a3296ba8d4, 0xbf97d61e22985a10,
    0x3fd3be5751246a84, 0x3fa54071b89e0c00,
    0x3fed15192bde42ac, 0xbfe230bd499cac82,
    0x3fe50dd696c34fe8, 0x3ff135b4ebb4d8e8,
    0xc00117f7c5b65110, 0x3fd34f84474b9c07,
    0x3ff7a4f7e9cc71be, 0x3fc34ca45890554c,
    0x3fd84a25f032f594, 0xbfd6a9934c93771b,
    0x3fffc13351ad3f8c, 0xbfd4f92558e1a051,
    0xbff998b86e8524f4, 0xbfee79ff764eee5b,
    0xbff97c1d1339e8ca, 0xbffaf6b856578820,
    0xc003737a7de4798b, 0x3fc67c22001d62e0,
    0xbfe246598e71e514, 0x3ff96e36e98367c2,
    0xbfdf62e9fd4a4954, 0x3fa8d78d373cafa8,
    0x3fec4eda1ef17734, 0xbfe3fc292e95eb3a,
    0xbfc2e0a8aa42b6be, 0xbfe92c397c1255e1,
    0xbfeb2646836b47b5, 0xbfd8cfe321aeb282,
    0xbfa11ccdc31c1b30, 0x3fee978236c306c6,
    0xbfda206917e43032, 0x3fba8423d4e30c48,
    0xbfdd1adca61df168, 0xbfec5d6baf2671a3,
    0xbfbb614d3b9705f0, 0x3fe18d4599d23ea8,
    0xbfdbeebf14342ecf, 0xc00a4ab8e7e191ba,
    0xbff70b720fe8c43a, 0xbfb5313910015d54,
    0x3fb217dde46064d0, 0x3ff21a2a14ab2e20,
    0xbfe4537c93b60a7d, 0x3fcadbcebbcceba4,
    0x3ffbfa8f5e1e5bd2, 0x3ffcadbac923a438,
    0xbff0f9ceb72c7bb6, 0x3fe778bb2aa365cb,
    0xbfd123ad43133019, 0xbfcd12118e619350,
    0x3fde2a350c994d60, 0xbff7ab248ce4a006,
    0xbfd8a4b2ba555cc1, 0x3fd8e7a074ab1045,
    0x3fe2dac085382bd6, 0x3ffe5c4b80ad3c90,
    0xbfec5ce9bf2cb8fc, 0x3ff4fb1258a398be,
    0xbffcdbb219093cfa, 0xbfebcdf819b8660a,
    0xbfdb5deb57dc0174, 0xbf8bff9e9f87a080,
    0xbffad177c1639cdc, 0x3fbdf7c071a31266,
    0xc000da9320f9c547, 0x3ffe93b0457f4308,
    0xc000a97ebec5da84, 0xbfef3841835285fe,
    0x3fe9420443890274, 0x3ff189da7c95a835,
    0x3ff72f23366c7b75, 0x3feb6a5a17036af3,
    0xbfd08296d455e7a6, 0xbff69009b7b6c286,
    0xbfe467895b77756a, 0x3fe9bd2aa86ff4eb,
    0x3fe63f3e10507002, 0x3fe4bb994d01a52a,
    0xbff80a66eb5de22e, 0xbf922a132c8b7aa0,
    0xbfe75b9fd5586b93, 0xc0077cf97a58b682,
    0x3ff03789c09027c5, 0x3ff3a287077b9658,
    0x3ffec626e21aa5eb, 0xc00368b447ec5229,
    0xbff3cf5b603bf058, 0xbffccb86d82b14db,
    0x3feb59c98217c3c4, 0x3fea2da988cb94dd,
    0x3f9d98c4b94ccd20, 0xbfe4a8f526f68d9e,
    0x3ff362920c9c6713, 0x3fd09cf2466a47e0,
    0x3ffa1b3c18843656, 0x3fa2e4efba2c54d0,
    0x3fc7bb02eff20e08, 0x3fee1005ad2d147e,
    0xbff7ba3aaa6bc816, 0x3ffeb3399c2a8bf6,
    0x3ffade25b724c054, 0x4003e8fb3d0a0f18,
    0x400394cfb50ac2fa, 0x3ff6992170612628,
    0x3fc6a02490d0f336, 0xc008ae7dc0b53618,
    0xbfe4d21240f68cd7, 0xbfdb3b51a3f539f9,
    0xbfd7a004ccd67f56, 0x3fe1825bd1604992,
    0x3fed6cea988ca82c, 0x3fe5b311c21930c0,
    0x3ff1a00d5dae891e, 0x3fda9d20533d5672,
    0x3fb4c5bfb59ec110, 0x3ffb36c423bd529e,
    0x3ff53a0d90a3c7f1, 0x40094cc10d9d28ec,
    0x3fea31dab63abae9, 0xbfe49a8614d2be2b,
    0xbff5c0cd24abad66, 0xbffcbe3c6ea25672,
    0x3f9808a353508910, 0x3ff79c14af25b005,
    0xbfe1018604356b6a, 0x3fec2f18a2f73003,
    0x3fecbd0a999f96dc, 0xbfe9246cdca78fb9,
    0x3fe9b2ae2a16a463, 0x3fc0a04215f64ba1,
    0xbff09ab0aefc0df6, 0xbfedcda4bad325e3,
    0x3fd1d00044d29e00, 0x3fc20539d6a2c346,
    0x3fd62030f49bc434, 0xbfaf102b377ab2c0,
    0xbfec40f98f6a692c, 0xbfe3d16991b4d855,
    0x3fd3a10bc7b2c1b9, 0x3fd44eb9768ef44f,
    0xbfe481854f13cef2, 0xbff221616d401c8a,
    0xbff71252a4ee6e7a, 0xbf9ecb1a907f0910,
    0xbfd9d6442dc00113, 0x3ff7596f1261e3da,
    0x3fcd9f96eafcb2c0, 0xbff7a784a5ad2506,
    0xbfe0b21e06549402, 0x3fe04fcc420366c4,
    0x3fff0fba11750eb8, 0x3fde475b557ec594,
    0x3ff44d7af3f533e0, 0xbfcbc5c9398511c4,
    0xc002d85d6a8ecb72, 0xbfe175e82187dc48,
    0x3fef21d9fde8af10, 0xbfc570028c5baef9,
    0x3fd5cfd4c792b5c8, 0x3fc745da1d656e78,
    0x3fd816ebf0b8e03c, 0xbfe05f58d1963c15,
    0xbff1b400072bb3f2, 0x3feafacd01e2e96e,
    0x3fd759964aaca1c4, 0x3fc4b42b09d4f970,
    0xbf9504e7ea4ce980, 0x4001d9eef1ce2ea6,
    0x3fde18f02ced7b28, 0x3fe7bb9a93678302,
    0x3fe097fbbf465d72, 0xbfcf523e8f0b537c,
    0xbfe4a42aeb7f18dd, 0x3ff73d9942e7cdc4,
    0x3ff348e98694e6e9, 0xbfa8fb2946297670,
    0x3f9a58c363b23ff0, 0x3fea102a7ec49596,
    0x3ffd50bdc223077a, 0xc000f54c71114626,
    0xbfeaf5f0167d145e, 0xbffa80f8f663a673,
    0x3ff5ce3afa344661, 0x3ff60e4f75be62ce,
    0xbfb252ede037e558, 0xbf92012e533f4b08,
    0xbfd4c717a063fcb7, 0xbffcc8e8aa8bff2d,
    0xbfec6915785166da, 0xbf6f71840e833d00,
    0x3ff860b896106941, 0xbfe7d6b2980a32b4,
    0xbfd2d6ab872db368, 0x3fe851cd309c72b2,
    0x3fe267a335f7717b, 0xbfe153259154cc06,
    0xbfc15d3c3d2879f4, 0x3fcc90266c960f50,
    0x3ff7dbf236701fc3, 0xbfc357eef65ebbe8,
    0xbfed01c90f3282d4, 0xbfdcf8cb6952b568,
    0x3fe75cc88a4c1210, 0xbfb3f908ed0f4794,
    0xbffefab7e89dac0c, 0x3fa9a1e57020e2fe,
    0x3ff47a614421e29d, 0xbffda9f5da2eb810,
    0x3ffc880b739e63ce, 0xbfd87a625649a318,
    0x3fef432908b77fc8, 0xbfd2bc10ceeaff64,
    0x3fde73944069cd3f, 0x3fead44899f3e106,
    0xbfe0ef92d1c40cd0, 0xbfd8f27ea8c63993,
    0x3fdf79c69a00dea4, 0xbff42e51fc959ce4,
    0x4001ea1adebf4d40, 0x4003d2990218bb4e,
    0x3fd667f259db3e78, 0x0,
    0x4001ea1adebf4d42, 0xc003d2990218bb4b,
    0x3fdf79c69a00dea0, 0x3ff42e51fc959ce4,
    0xbfe0ef92d1c40cca, 0x3fd8f27ea8c63994,
    0x3fde73944069cd40, 0xbfead44899f3e106,
    0x3fef432908b77fc4, 0x3fd2bc10ceeaff6e,
    0x3ffc880b739e63cd, 0x3fd87a625649a31c,
    0x3ff47a614421e29a, 0x3ffda9f5da2eb812,
    0xbffefab7e89dac0c, 0xbfa9a1e57020e378,
    0x3fe75cc88a4c120e, 0x3fb3f908ed0f47a2,
    0xbfed01c90f3282d3, 0x3fdcf8cb6952b55e,
    0x3ff7dbf236701fc0, 0x3fc357eef65ebbf4,
    0xbfc15d3c3d2879e4, 0xbfcc90266c960f5c,
    0x3fe267a335f7716d, 0x3fe153259154cc06,
    0xbfd2d6ab872db362, 0xbfe851cd309c72ac,
    0x3ff860b89610693b, 0x3fe7d6b2980a32b8,
    0xbfec6915785166db, 0x3f6f71840e833f00,
    0xbfd4c717a063fcc5, 0x3ffcc8e8aa8bff2c,
    0xbfb252ede037e548, 0x3f92012e533f4b08,
    0x3ff5ce3afa344664, 0xbff60e4f75be62c7,
    0xbfeaf5f0167d1464, 0x3ffa80f8f663a676,
    0x3ffd50bdc2230774, 0x4000f54c71114627,
    0x3f9a58c363b24080, 0xbfea102a7ec49597,
    0x3ff348e98694e6e8, 0x3fa8fb29462976d0,
    0xbfe4a42aeb7f18d5, 0xbff73d9942e7cdc3,
    0x3fe097fbbf465d71, 0x3fcf523e8f0b5374,
    0x3fde18f02ced7b22, 0xbfe7bb9a93678307,
    0xbf9504e7ea4ce840, 0xc001d9eef1ce2ea6,
    0x3fd759964aaca1d5, 0xbfc4b42b09d4f970,
    0xbff1b400072bb3f2, 0xbfeafacd01e2e96d,
    0x3fd816ebf0b8e027, 0x3fe05f58d1963c1d,
    0x3fd5cfd4c792b5cc, 0xbfc745da1d656e70,
    0x3fef21d9fde8af0e, 0x3fc570028c5baf0d,
    0xc002d85d6a8ecb70, 0x3fe175e82187dc46,
    0x3ff44d7af3f533e0, 0x3fcbc5c9398511dc,
    0x3fff0fba11750eb8, 0xbfde475b557ec57c,
    0xbfe0b21e065493fe, 0xbfe04fcc420366c9,
    0x3fcd9f96eafcb294, 0x3ff7a784a5ad2503,
    0xbfd9d6442dc00104, 0xbff7596f1261e3d9,
    0xbff71252a4ee6e78, 0x3f9ecb1a907f07b0,
    0xbfe481854f13cef2, 0x3ff221616d401c8a,
    0x3fd3a10bc7b2c1bc, 0xbfd44eb9768ef445,
    0xbfec40f98f6a692c, 0x3fe3d16991b4d854,
    0x3fd62030f49bc42c, 0x3faf102b377ab300,
    0x3fd1d00044d29df6, 0xbfc20539d6a2c321,
    0xbff09ab0aefc0dfa, 0x3fedcda4bad325dd,
    0x3fe9b2ae2a16a460, 0xbfc0a04215f64b76,
    0x3fecbd0a999f96de, 0x3fe9246cdca78fb7,
    0xbfe1018604356b6a, 0xbfec2f18a2f73003,
    0x3f9808a3535089a0, 0xbff79c14af25b004,
    0xbff5c0cd24abad6a, 0x3ffcbe3c6ea25670,
    0x3fea31dab63abae4, 0x3fe49a8614d2be2a,
    0x3ff53a0d90a3c7f6, 0xc0094cc10d9d28eb,
    0x3fb4c5bfb59ec148, 0xbffb36c423bd529b,
    0x3ff1a00d5dae8920, 0xbfda9d20533d5661,
    0x3fed6cea988ca82b, 0xbfe5b311c21930c4,
    0xbfd7a004ccd67f52, 0xbfe1825bd1604993,
    0xbfe4d21240f68cd7, 0x3fdb3b51a3f539fc,
    0x3fc6a02490d0f304, 0x4008ae7dc0b53619,
    0x400394cfb50ac2fc, 0xbff6992170612623,
    0x3ffade25b724c057, 0xc003e8fb3d0a0f16,
    0xbff7ba3aaa6bc811, 0xbffeb3399c2a8bf8,
    0x3fc7bb02eff20e08, 0xbfee1005ad2d1480,
    0x3ffa1b3c18843656, 0xbfa2e4efba2c5490,
    0x3ff362920c9c6715, 0xbfd09cf2466a47e0,
    0x3f9d98c4b94ccbf0, 0x3fe4a8f526f68d9b,
    0x3feb59c98217c3c4, 0xbfea2da988cb94d2,
    0xbff3cf5b603bf05a, 0x3ffccb86d82b14d8,
    0x3ffec626e21aa5e8, 0x400368b447ec522c,
    0x3ff03789c09027c8, 0xbff3a287077b9657,
    0xbfe75b9fd5586b9b, 0x40077cf97a58b680,
    0xbff80a66eb5de231, 0x3f922a132c8b79c8,
    0x3fe63f3e10507009, 0xbfe4bb994d01a528,
    0xbfe467895b77756c, 0xbfe9bd2aa86ff4f1,
    0xbfd08296d455e7bc, 0x3ff69009b7b6c286,
    0x3ff72f23366c7b76, 0xbfeb6a5a17036af0,
    0x3fe9420443890276, 0xbff189da7c95a832,
    0xc000a97ebec5da84, 0x3fef3841835285f4,
    0xc000da9320f9c546, 0xbffe93b0457f430c,
    0xbffad177c1639cde, 0xbfbdf7c071a312c0,
    0xbfdb5deb57dc0177, 0x3f8bff9e9f87a040,
    0xbffcdbb219093cfc, 0x3febcdf819b86602,
    0xbfec5ce9bf2cb8f8, 0xbff4fb1258a398be,
    0x3fe2dac085382bda, 0xbffe5c4b80ad3c8c,
    0xbfd8a4b2ba555cc6, 0xbfd8e7a074ab1049,
    0x3fde2a350c994d4e, 0x3ff7ab248ce4a004,
    0xbfd123ad43133012, 0x3fcd12118e619332,
    0xbff0f9ceb72c7bb4, 0xbfe778bb2aa365c7,
    0x3ffbfa8f5e1e5bd2, 0xbffcadbac923a434,
    0xbfe4537c93b60a77, 0xbfcadbcebbccebb4,
    0x3fb217dde4606510, 0xbff21a2a14ab2e22,
    0xbff70b720fe8c43a, 0x3fb5313910015d68,
    0xbfdbeebf14342ef4, 0x400a4ab8e7e191bb,
    0xbfbb614d3b9705c0, 0xbfe18d4599d23eae,
    0xbfdd1adca61df172, 0x3fec5d6baf2671a2,
    0xbfda206917e43026, 0xbfba8423d4e30c38,
    0xbfa11ccdc31c1b60, 0xbfee978236c306c4,
    0xbfeb2646836b47b6, 0x3fd8cfe321aeb26c,
    0xbfc2e0a8aa42b6ca, 0x3fe92c397c1255e5,
    0x3fec4eda1ef17734, 0x3fe3fc292e95eb44,
    0xbfdf62e9fd4a494c, 0xbfa8d78d373cafe0,
    0xbfe246598e71e509, 0xbff96e36e98367bf,
    0xc003737a7de4798b, 0xbfc67c22001d62fc,
    0xbff97c1d1339e8ce, 0x3ffaf6b85657881e,
    0xbff998b86e8524f8, 0x3fee79ff764eee55,
    0x3fffc13351ad3f8a, 0x3fd4f92558e1a06a,
    0x3fd84a25f032f590, 0x3fd6a9934c937717,
    0x3ff7a4f7e9cc71c0, 0xbfc34ca45890552d,
    0xc00117f7c5b65112, 0xbfd34f84474b9c19,
    0x3fe50dd696c34fee, 0xbff135b4ebb4d8e4,
    0x3fed15192bde42a5, 0x3fe230bd499cac81,
    0x3fd3be5751246a7c, 0xbfa54071b89e0ba0,
    0x3ff436a3296ba8d4, 0x3f97d61e22985ac0,
    0x3fe1d02cef38064a, 0x3fd00761ab5bdcba,
    0xbff41ef8bbc8ab7e, 0x3ffba13a1eaf35ea,
    0x3fe1d675d0784ade, 0xbfc7caea4ac45774,
    0x3ff72987b227d8af, 0x3f8304b73123c578,
    0xbfe321b0056d58ad, 0x3ff840a789b8efe2,
    0x4004e670f1231a12, 0x3ff0fc6d992514df,
    0xbfa9fe36067a1e64, 0xbfcbf8599e789062,
    0x3fd71d5d74a065f8, 0xbff01968c756ac7b,
    0xbfe40b3bd787523d, 0xbff0721bab1b79e8,
    0xbfbb975315222ecc, 0x3fabc17732990a80,
    0x3fd4afac2f5398bb, 0xbfdc565c18b42bb6,
    0x3fd8d076094cbeec, 0x3feb5fca6c09408e,
    0xc0002d10fee2db6b, 0xbfd0f3e53c19cb04,
    0xbfe564b95917c33a, 0xbfc462b08a8e5572,
    0xbfd2749104a8f70c, 0x3f92565b70ee3480,
    0xc00836ddd00f7f00, 0xbfec0840111fbf00,
    0x3ff01e91b094a96f, 0xbfe527a9cad66b26,
    0xbff7e76ac2ac68d4, 0x3ff8fb8dc3c3e824,
    0x3faa32c0661bc980, 0x3ff073e43b735b32,
    0xbff09414578cc3c9, 0x3fe73fe892617785,
    0x3ffbd7d9e79308e8, 0xc002f794d9b08b11,
    0xbfdb85015a46dea0, 0xbfe39dd3748bf96c,
    0xbfe4692675d531a6, 0xbfc571fed2938b74,
    0xbfc48a70ba8b3da8, 0x3fe381819028e700,
    0xbfe3e7e30a060282, 0x3fc8343307617b85,
    0x3ff5bc60386054cd, 0xbfe57d9b83d1cb42,
    0x3fe5d6136ea2d328, 0xbfc03697931b33ad,
    0x3fe65cbadc5b9279, 0x3ff80918046f2bb6,
    0xbfe6a3376c86a017, 0xbff0f7475f3de701,
    0xbff6407760a19523, 0xbff47d9e498cc818,
    0xc0009da539a11eef, 0x3fe0aeb704497bc4,
    0xbfe3792cd5c18e33, 0x3fac19d4d9ca03c0,
    0x3fcf2a76fc1c6e79, 0xbfe720a98692c1ac,
    0xbfe11b60e4c4ff60, 0xbff50e29d080e1aa,
    0xbfedd72821012120, 0x3ffdd6cbb8c43406,
    0x3fc811f81b668b9a, 0x3fe78d8e1f6e1eb1,
    0xbfe35bd9a46d018a, 0x3fd8e15a56f477a0,
    0xbfd4dd77e4130a2e, 0xbfeb71d65712893a,
    0xbff1199c2f53c322, 0x3ffcea2311b0568a,
    0x3fbc8beff785399c, 0x3fee43a0a5c2f2ba,
    0xbfe734f58ed90299, 0x3ffbe98a193ec598,
    0x3feaac57eeb454c8, 0x3fe40f0ddbae42b5,
    0xbfeb2df803d67257, 0x4007df69ef8d5be8,
    0xbfce8797d3efd1a7, 0xbff7b00876dfdb1e,
    0x3fb483f1e0e16cf8, 0x3fff9cc086093b15,
    0xbfd40718ac78e63e, 0x40056a2e06ec0299,
    0xbfff1656d1339e51, 0xbfc6743f15ea1c63,
    0x3fe6f99eeef32ae4, 0x3ff7043f51b6af9c,
    0xbfe7d030612008ee, 0x3fc7f61f9f141318,
    0x40023379c6145244, 0x3fd4cfdf41d24028,
    0x3fe1263bac85ecff, 0xbfcbbe9f7ea64802,
    0xbfd1563af85f1f52, 0x3ffaa66b12b5fd3e,
    0xbfe216a2c930b2f0, 0xbfe2d1b3f4780c58,
    0x3fe0247727aeea1a, 0x3ff1ba9105486731,
    0xbfdeab0ebafa0b89, 0xbfe79740e0755941,
    0x3fe766b051661fa0, 0xbfddffe9e699f248,
    0xbff2477a7394ae12, 0x4000591169176b5a,
    0xbfc5b8e8e9956474, 0xbffb17b6b9973900,
    0x3fe9967c83011ae4, 0xbfe8da125cd7a33a,
    0x3ff2d62d8661215b, 0x3fd85d8fab8a023d,
    0x3fd7986ce555816e, 0x400e800c1d4772b0,
    0xbff96d1de7431dc7, 0x3ff9819c2668ccdf,
    0x3fe8d38ef5bfce08, 0xbfb5cb5e2ca0fabc,
    0xbff3506ffcc8c4c2, 0x3ffc59ca770b02ff,
    0x3ff05981198aad14, 0xbfb378dd9f1265c0,
    0xbff89a7abc997770, 0x3fd10d5aea595c62,
    0xbf4fec6ea0f99000, 0xbfe3d4ceaccd5319,
    0x3fdddb7ca844978d, 0x3fed98b7501b8d4d,
    0xbfefb898458fe78f, 0x3fcaa929fc2ac912,
    0x3fd873c4f1e97238, 0x400115434cfafae6,
    0xbfcb6cef17d6ca3c, 0xbfdf611971ab0f77,
    0xbfe5cd25c1861f4b, 0xbfd1dfb26534d724,
    0xbff19d84838c4fa5, 0x3ff7f6dd420b2cb1,
    0xbfb1204701362b70, 0x3fe422a5b38a209c,
    0xbffa636557826455, 0xbfa027b01c5cff20,
    0x3fe64f212b02a4f2, 0x3fc9b05a3bc3e31a,
    0xbfc3347c44c2315f, 0x3feedb8b9b8e1f86,
    0x3f71ee7a786f9f00, 0x40030dacef1f1e0c,
    0xbfe69d8e0eda5239, 0x3ff26cb2b602c6f2,
    0xbfd2f7d963717ad5, 0xbff1b6fe9114c817,
    0xbfc3413a4896475a, 0xbfda36079aa150ab,
    0xbfea512d3c243828, 0x3fd86e2438858d00,
    0x3ff2dc905b50c479, 0xbfd47486d2cb9a48,
    0xbfee0ccf8b14b01f, 0x3ff4f44cb71229d1,
    0xbfded408f7cfa351, 0xbfd95044b637d840,
    0x4002650a138e0d88, 0xbfff306e1ed32086,
    0xbfd83fbe064cae50, 0x3ff2ea308efaee42,
    0x3fc8595f523b2ece, 0x3fe1c9908dd49154,
    0xbfe4cd6510565bd2, 0xbfdf2fb3930e34a8,
    0xbff1d44fbdd8f567, 0x3fe1599702dd5607,
    0xbfec71aec38b4b97, 0x3ff394fb410b4b86,
    0xbffc40df88c2d02e, 0x3ffce6651bec3192,
    0x3fe7fc66a77edaea, 0xbfd69447b09fb390,
    0xbfcf23e5bf8d8226, 0x3fe06a55cb0dc208,
    0x3fe7a399d7747d31, 0xbfefb7beba9dce95,
    0xbff350aaab5e714e, 0xbfd437aee97c84a0,
    0xbfec8c5b16814d3c, 0xc0006cfa902b9c4e,
    0xbfe1c0d934bbf75c, 0x3fd7ed673c48f670,
    0x3ff5e5f895441e4c, 0xbff9408d9f799b4a,
    0x400051adea3da9ce, 0x3ffcd03de8d2cf6e,
    0xbfc5157c3a232476, 0x3fb4ea1bfc320a80,
    0x3f9887b18f416940, 0xbfed4eea8019a0e7,
    0x3fef006bb5649b2a, 0x3feb6f49a4ded92d,
    0xbfae2b99ea18a2d0, 0xbfd46021565b3b88,
    0x3fc2f47bfc51b9bc, 0x3fe7002b61232a1b,
    0x3fe07d6a3100d47c, 0xc0016b2cdc06fa75,
    0x3fe078da3afa7866, 0x4001aeac440cb9df,
    0x3fe118c6dd4c94a0, 0xbf679fe0b6ecb600,
    0x3fdb5fd17b16084a, 0xbfbd23e8fab44858,
    0xbf895dd1c08f8ac0, 0xbfcf5f364fd73c10,
    0x3fc8911ba96f8c95, 0x3ff0273325f2748f,
    0xbff302ad81fc1ab2, 0x3ff2cd4db0ef745c,
    0xbfd820575273d86a, 0xbf8663976dc12a00,
    0x3fe2ba9556b83206, 0xbfe4ef0b2763029e,
    0xbfe25e40bce4bc5c, 0x3fabff1c3c69ceb0,
    0xbfe85df2f9ed3d34, 0xbfc2c5867d999888,
    0xbfe2348952cff898, 0x3feeb3690c103494,
    0x401062f4500a96fe, 0xbff1acbddc9132d6,
    0xbff1548d8b42d198, 0xbff15b3f4f5d3fb9,
    0x3feaecdc22172c73, 0xbfd75cc34d1ae272,
    0x3fc0c094298cabaa, 0x3ff3b31142a50ab0,
    0xbff1ed8cacb8fa03, 0x3fc7cc846522414f,
    0x3fb18f9f73ef4cb4, 0xbfe316d9d99da3dd,
    0x3ff202fab9cbb9d0, 0x3ff540fe4a12f916,
    0x3fe9737b59a999d6, 0x3ff96a69a1b91832,
    0xbffecbd751ae1a88, 0xbfe6d06275744370,
    0xbfe9958308bec7fa, 0xbff8a2a42b6101f1,
    0xc0008e7d7f3cae4e, 0x3fe26748970a1277,
    0x3fc2ecaa8b3cfcde, 0x3ff3b4f77067b7b1,
    0xbfebd2ff76b3536c, 0x3fec7ef46d53f8e2,
    0xbff5cdb403a4200f, 0x3fe134952b4a7e3c,
    0xbfc2c105566186f0, 0x3fedb2631bd0bddf,
    0xbfcf7e780a15b074, 0xbfa694bc91bb6d48,
    0x3ffd55a5158f40ea, 0x3fb411a1228efea4,
    0x3fed731a2452fef4, 0xbfe197ab96514984,
    0xbff19a5dd7b173c2, 0x3fe5501b3481f52c,
    0xbff04089a83361b2, 0xbfdd1fcfb589ddd4,
    0x3fe266c78f6e7c17, 0x400038ed3a84ac18,
    0x3fedbf15c5530eb2, 0xbff8c323f5332453,
    0x3ff9439daeb84bc6, 0xbfd24892391e6d6c,
    0x3feb580a6d63f3de, 0x3fe1ef05b4d210f6,
    0xbfe8a7cba09564f0, 0xbfe2426420e464d3,
    0xbfdb221f8ef17023, 0xbfdd11714c381ea6,
    0x3fc2d326d1b620f0, 0xbffa3822ba432c00,
    0x3fd2778048cb8ac5, 0x3ff08e8b3b2e6062,
    0x3fefefe90fe96f9e, 0xbfe1817ed26109e2,
    0xbfe065d5f10d3f4e, 0x3fe15914446eb343,
    0x3fef888cfb4ae0e3, 0xbffc5a941c422a07,
    0xbfea6de9cc3a7670, 0xbff1c14cef402e20,
    0xbfec9eb8bac3ad88, 0xbfeb1b90c7a8de78,
    0xbff98e61befae3d0, 0x3ff99305f87698ea,
    0x3fa4260dc82b2c50, 0x3fbfc401ffdf07e0,
    0xbfe644dc70c74405, 0xbff37b954a09a76a,
    0xbfad7b49bebb0f90, 0xbfde46702bfcf95c,
    0xbfd8146107dcde5b, 0xbfe5705f7f03e997,
    0x3fe5a9145999e146, 0xbfdeb29a30f5c9f5,
    0xbfe7d66661fc10aa, 0xc005786512fc8c71,
    0xbfed454ebc111e81, 0x3f8429940996b840,
    0x3fe646c2aa637af2, 0x3fdba199ad717904,
    0xbfd2bcab7fa7de44, 0x3ff6c6753fb883a0,
    0x3ff5846d0ba43fba, 0x3fe78a7ec5f4ef0f,
    0xbfe4afd77e6c8ba2, 0x3fd9b971c652faf6,
    0xc0003ad9cf8c3ed8, 0x40121e3d52499abb,
    0xbfd19ae7df5a0f44, 0x3fddc5a0be516012,
    0x3fe286dcc43b7f51, 0x3fd9d1c20564b21a,
    0xbff1e7ef1d6aa05c, 0xbfc2a991b8c3b4e1,
    0x3fe41bdc3e4fd0c6, 0x3fff3f775cd8c0d8,
    0xbfdcd703d18be460, 0x3fe98de1f7714757,
    0xbff37ce549663deb, 0xbff7592892d6f7f8,
    0xbff5041cea1c10e0, 0xbfbc18637dce6378,
    0x4005151f518ca117, 0x3fc1901f08325380,
    0x40008234c7b27039, 0xbfd7b0dbbfa84489,
    0xbff599f615f3541f, 0xbff97e9aa57350b9,
    0xbffda580632ef6ef, 0x3ff9c9329046afc9,
    0xbff26e9eea5680f6, 0xbff55a65b3de1a7a,
    0xbfe9db87d0055723, 0x4000f3c0437d8c18,
    0x3fd63178bcb21128, 0xbf835267b284db00,
    0x3ffbada9b411ce26, 0x3fe630412cbfa77c,
    0xc000ddd6fb574c16, 0x3fd6becabaa2a1b2,
    0x3ff49767a701f759, 0xc0003be88a6f55ef,
    0x3fe9656dc4e1a181, 0xbfe101ff8f3dd6ac,
    0x3fe4f839cb6c9312, 0x3fef5fa361245578,
    0x3ffa3dedf8244af4, 0xc003ae0681204360,
    0xbfe796ebc3021fc3, 0xbff609936c2a122e,
    0x3fda856675e9921a, 0x3ff9898379dba677,
    0xbff77fea4b068051, 0xbfe07942e86a23f6,
    0xbff020b3ceaa393d, 0xbfdf71baf89279cf,
    0xc0001cc7a2dcb94a, 0x3fe999eda065e398,
    0x3fc56d245f2a5888, 0x3ff52bffd6d98fc6,
    0x3fd5a3bc71afd2e2, 0xc006bd35de480b84,
    0xbfe0cd605699753f, 0xbfebb6d2abbc1894,
    0xbfdc650091f30ec7, 0x3fe90c54439c03a7,
    0x3ff0ffee1ede0900, 0xbff86efa061b8134,
    0xbfd5c49c8a7a1c76, 0xbfd587166c701424,
    0x3fc4ea3371470568, 0x3fdd29565055532a,
    0xbfd4d8ceca5265e8, 0x3fe17120ad445866,
    0x400710fdc783c375, 0xbfdc4ba182f0b45a,
    0xbfeaa8433c5b6568, 0x3fc665309df3f048,
    0x3fcf9da5feb073de, 0x400074912b58daef,
    0xbff1556c7a0f6ed3, 0xbfebc15246a967f8,
    0x3fea25fdda3dbefe, 0x3feb0cf8f7574e2b,
    0xbfd8dd6845a81fd4, 0xbff98c1f1c208d5d,
    0xbff5c0c624da994c, 0x400c56298231f2b8,
    0xbff0c06bab03422e, 0xc0010dd9625b7a56,
    0x3feafdb9f92a7ecf, 0x3fb02da65d9e7980,
    0x3fedb58195bf4856, 0xbfd87f1f357d4763,
    0x3ff18e0715b659cc, 0x3fe5877b802c9828,
    0x3ff076da4a0f9e85, 0x3feea09126bf2a75,
    0xc000398fae5c5deb, 0x3ff6c98fdddc83cd,
    0x3f83e48087bd9520, 0xbfe04e8e6ebe9179,
    0x3fd69da853e80c58, 0xbfee9cd995d12da3,
    0xc0010ab1ea14998d, 0xbfb639d06bfb5312,
    0x3fc379d5198dfd04, 0x3fe752c22ea142d2,
    0xbff04bf13b854a1c, 0xbfed6051817e2d6b,
    0xbfe822e9c83269d3, 0xbfd77efb71220c14,
    0x4000dbb02d84c5ec, 0x3fe414736f39fbb2,
    0x3ff70ac5c6b06878, 0xbf8cfb8de6e97220,
    0x3ff15ea08709b8a8, 0x3fe1ae55a340ea88,
    0x3fef6d9ac74e67ff, 0x3fe80b961e316eb8,
    0x3fd9df8ed55d293e, 0x3fe0f751d269078e,
    0x40005968f2ae1840, 0x3fce34256992fcd4,
    0x3fc2f06e3c059124, 0xbff9a898035c0b60,
    0x3fd60220ef68e54a, 0x40014ebcc09637b6,
    0xbfb9f3b2fa8168b0, 0xbff2134443829df8,
    0x3ffaf51e5174ce72, 0x3feb52fd57b048ec,
    0x3fe2dac611fdc6cc, 0xbfd248cc16aaaabc,
    0xbfd40e0eb9f5e670, 0x3ff777e5fe28390e,
    0xbffcf3fa5674fb44, 0x3fd270a14343f6b5,
    0xbff957307fe90271, 0x3fdf603742226d9c,
    0x3ff8bf195a74cb76, 0xbfca9448fd4f4658,
    0xbfc90c22ef0d09a4, 0x3fbfc95e20304678,
    0x3ff50bdd51138f24, 0x3fe5d567cfe67cf1,
    0x3ff667fa0a12ed88, 0x3fe77ddf7fb953b6,
    0xbffec3d92e146886, 0xbfbe0d30fbd95c60,
    0xbfda13a11088a4b0, 0xbfd980516a84004e,
    0xbff9d2bc2462bee5, 0xbff874e553da40c8,
    0x3facb000f8353de8, 0xbfcecfc0a4b50115,
    0xbfefaf0a3e9a1ae0, 0xbfeb64c0b707174b,
    0x3f8d6bf8f359cc80, 0xbfe0b9edd9b8c4ef,
    0x3fd8b748baeadf15, 0x3fed4d9f2ba4ed60,
    0xbff13227cd94b465, 0xbfcb25263383b400,
    0xbff1448afc38448f, 0x3fe08bc7411c1f1e,
    0x3fe19ef1bd921174, 0xbfd7f3ba0239eed4,
    0x3fe0b39e4d5c952f, 0x3fd84a2036d6fa12,
    0xbff5ebf084a69978, 0x3ffa370e07eddaa6,
    0xbfee7ca7d6194ad4, 0x3fd1a374139f53d4,
    0x3fdc459cbe5c2ed2, 0x3fc2a8bc5f3c0770,
    0x3fb3e102cd581b90, 0x3ff14d32b1c83fcf,
    0xbff27a405155344e, 0xbfec972ac7b50cb9,
    0xbfe921eb6d4e4036, 0x3fbcebb0a5f517e8,
    0x3ff59397b828d7dc, 0xbf74bf21a971b740,
    0xbfe9f9a1203ed887, 0xbff27abf7afbba8b,
    0xbfea1864e3acbbce, 0x3fd061cb70d5529a,
    0xbfc5364e65769a7c, 0xbfef0120b96776d4,
    0xbfe5fa3b699a0ef2, 0xbfd76c6a5a422dea,
    0x3fe678303013f9f4, 0xbfec3aa826baee06,
    0x4006ff0a2e4bdc7f, 0xbff4d1e0ec7340fa,
    0xbfc51b263e469aa4, 0xbffe773efc63b110,
    0x3fe8748e596c4c4a, 0x3fe08169c9e33c8b,
    0x3fe9fc5f94728f3e, 0xbfef5b8590bdd2f8,
    0x3ff4372e50f4f47f, 0xbfe3a7b4175e0d93,
    0xbf7c3ccf49c46200, 0x3ff6904cd8d89d8f,
    0x3fe3c668eb184e7b, 0xbfd6bbdca847611c,
    0xbfd7b03c5ad3cc5a, 0xbfd31980c3a3d09c,
    0x3fed7c5e3e6c936c, 0xbfe88bb0abdf2b1d,
    0xc0002f17c79d55fa, 0x400018ea1b890b98,
    0x400776c5825cb4c4, 0x3ff0f3e389e45e9b,
    0x3fddacdf1d586996, 0xbf87f54c078bc5a0,
    0xbff8719f1e9c0244, 0xbffa7843653f6e7a,
    0xbff43115bc4fca01, 0x3fd3a2dc8a6b34ae,
    0x3fc8ce9b51152998, 0xbfb3002040002d40,
    0x3ff33ada0eeb6d1c, 0x40767d785499e3b0,
    0x40051270612dc0cb, 0x3ff13a528ac89160,
    0xbfc509e56b476726, 0xbfd1a972c42e02df,
    0x3ffb4357a302117e, 0xbff5e70ee1455868,
    0xbfed912d46eb837c, 0xbfc77989e1ddc53e,
    0x3fac356693c57170, 0xbff15d18a9518f6b,
    0xbfdba56d11aea2dd, 0xbf96e440d7fecef0,
    0x3fd75ea6f6918df0, 0xc005cc65752ac38c,
    0xbfc54dc188baea07, 0xbffb46fd9f263646,
    0x3fd6bd4f965af770, 0x3fc606caa14315d8,
    0xbfa27663da35ac20, 0x3fff039f828347e7,
    0x3fc48e48985ff920, 0x3fd1ad73eda6c434,
    0x3feb7fe7bd028025, 0xbfa124ac1e5eeeab,
    0x3fdf2dab2c51c700, 0xbff5cd3d971e929c,
    0x40026d2c9f0b2d92, 0x3fead873b4b21bdc,
    0x3fe39ed239e44c92, 0xbfc0ee454ebe5968,
    0xbfe89a8e6b23e9c8, 0x3fe1e80ec74c1afa,
    0xbfe7edecc831811e, 0xbff26540c213dd98,
    0x3ff24a06e1ca4266, 0xbff0c904a4f07299,
    0xbff31559b29ae76a, 0xbfc13e1aa43a14cc,
    0x3fed14f0e9bfef3a, 0x3fea15deea65a168,
    0x3fbfd5e940620fd8, 0xbfe2613e25badc58,
    0x3ffaac38007e3697, 0x3fd4be2addffb645,
    0x3fe7b77f75958505, 0xbfb738f255b5fe8c,
    0xbfd05f285fcbb692, 0x3ff28deef375731f,
    0x3fee4070ea724630, 0xbfddadfabec79508,
    0x3ff1466d78ad6b9a, 0x3fe6d1c4a1c1bba6,
    0xbfe895e438c36f60, 0x3fefd8c85566f2bb,
    0xbfd50d9b3eba3480, 0xbfe868e4535a7d46,
    0x3fed13aded83d06a, 0x4006f30eb5646aec,
    0xbfc53b1dadc0a5be, 0x3fe2892d50e668fd,
    0xbfe8adfb9b930015, 0xbfc90b16fd5d57c3,
    0x3ff25433b44a9e7a, 0x3fe2e03b4bf69e26,
    0x3ff8e84bb082e3a0, 0xbff3be6087a01b30,
    0x3fe13c0a403114b2, 0x400466cf67997891,
    0xbff6ee879d959287, 0x3ff7605212767ca0,
    0x3fa9fd4d8b5a5048, 0x3fec779b317fa410,
    0xc000e20283102fa0, 0x3feb4fa0735d90ba,
    0x3fec711372d3f8ce, 0x3fcdea963e33261c,
    0xbff5402d0054a25a, 0x3fd9f39f81b93550,
    0x3fe796c4fd9300d3, 0xbff25b94aa7d2080,
    0xbfd78409f101d948, 0xbfc7bf6132ffb5ac,
    0xbfd6646f7ef145d1, 0xbfe001c75362352a,
    0xbfcd29eb16f63140, 0xbfd989bd79dc90f6,
    0xbfeb6f2c5feceb88, 0xbfeaeb650133a68c,
    0x3fefb53b6d480d2a, 0xbfd11df3993b91b0,
    0xbfd5dd186f3e4f13, 0xbfe6f73cdc87663c,
    0xbfd4887911432c1a, 0xbfcc72f8d9d9850a,
    0xbfd012776ed4966c, 0x3ff3f5bb44bbcb7f,
    0xbfce951adb8de180, 0x3f46170f234cc500,
    0x4000bd5d354c96d5, 0xc000c90e71892832,
    0xbff1a58ae0119218, 0x3fe05afa2cd61118,
    0xbfc5ae4dcbc23412, 0x3fd8134058a643e3,
    0x3fe9e54d2f2f0ee6, 0x3febc498dd09fedf,
    0xbfd1ea3a3c6391a6, 0xbfc3d8077be08b0c,
    0x3ff0bca4c7cad4a5, 0x3febbb8425f17f79,
    0x3fe877e5b959a444, 0xbff3dd41ed561b6e,
    0x3fa9232217d16630, 0xbfca971bb0d64798,
    0xbfdf3ef9e321a37a, 0x3ff2e4c25e8aa774,
    0xbfd5fe3283eb2ffd, 0x400495636ff0a759,
    0x3fec276b3cedae76, 0x3fe1c583c98aeb05,
    0x3ff0f862d3f477b0, 0xbfc2894f5350f9f8,
    0xc00181f86d7ae05f, 0xc004292c76dd0239,
    0xbfe48e83eec865ef, 0x3fc62b9185bd5fce,
    0xc002e71424472b04, 0x3fd9f5df250fd1d4,
    0xbf7110eb74a7c400, 0xbfab20b20ab6df70,
    0xc00380b42ceeeb58, 0x3fdf08d884173ae4,
    0xbfb0def23c8cff28, 0xbf83a5d7a71557c0,
    0xbfe35e582c2dfe58, 0xbfa7a15ef9a1a860,
    0x3fc13d2b485281c0, 0xbfe8323c66265760,
    0x3fea2101ba55c4ce, 0xbff22724da5c9efc,
    0x3feaafd60cde35d1, 0x3fdff0c252efa5f3,
    0xbfe5226c22544011, 0xbfd87f9cc81e2bcb,
    0x4004da2396d78df4, 0xbff39d1207bb6f1c,
    0xbffdb89764f7d73e, 0x3fefbe3c952a8cb7,
    0x3ff38d3375226bc6, 0x3fef1a3c6568a411,
    0x3fd888b45d8527f4, 0x3fc2b54bfc4e7748,
    0x3fee3a82ce8f3ff3, 0x3fe7965c3ea1fd5d,
    0x3fe930aa5c30eb5f, 0xbff76c9d3f9e021e,
    0x3fb8733046da7ce4, 0xbfb7331f6b359360,
    0x3fdd0311e242989f, 0xbff7cb2cc02c3bfe,
    0xbfc89f30dea62418, 0xbff99930af692474,
    0xbff7010866f6f3e6, 0x3fd5fa4f61a60764,
    0x3fec1460273207b8, 0x3ff94039c2f5f40a,
    0xbff62d9010869306, 0xbfc357a55c4ebc9a,
    0xc006e7e43640505e, 0xbffbf342c20e43e8,
    0x3fecee54f46534e2, 0xbfc13af7977ac6c4,
    0xbfe503609f2e05ae, 0x3fbddca0e824cc14,
    0x3ff22ff2867f7d21, 0xbf9b13e5257cae20,
    0x3fea67a7f0bcebc3, 0xbfd360aec40b3a77,
    0xbfda0f318755a62b, 0xbfd65ebe5c7e2d8a,
    0xbfdddfc0d61dec7c, 0x3f9b8637316b4220,
    0x3fd314db927e8cb5, 0x3ff2984d780c599a,
    0xbff2bc72fa47c5b2, 0x3fe02c89ae6d6480,
    0x3fda3b0b39616efe, 0x3ff2a3270f7ecf9a,
    0xbff4917c7e36883d, 0xbff95cbbc12332d0,
    0x3ff3ce1282a84730, 0xbfa0e5c4ab0fb35c,
    0xbff4ea94117508c2, 0x3ff215dcc732ecab,
    0xbfe2fa25558e5bbb, 0x3ffaa6c0fd3825c0,
    0x3ff09f0327769f4e, 0x3ffaa50b1bfb09eb,
    0x3fe82c7c6f16ceee, 0x400404067f8d405f,
    0x3ff0ca3b447ba090, 0xbfde631068add90c,
    0xbfd609751e00fe2c, 0xbff2c7f9bf68a2f1,
    0x3ff1b2dc01b216e5, 0xbfd363baa62eaf80,
    0x4000549b72e2502d, 0x3fde93bc9faa8bfe,
    0x3fc9ca9593f1f1f8, 0xbff4023da20bd6ba,
    0xbfeb32f0a6a65554, 0xbfee0a64aa2e9fee,
    0xbff9f4a68e97065c, 0x3fd2a30e5c427e3a,
    0xbff1e6255e2a24b4, 0xbfee5dd0b535fd6a,
    0xc008d438ce350004, 0xbfeafc7fb910a917,
    0x3fe851f5b38903d4, 0x3fdd666fe3d2a242,
    0x3fdcac163f7d7f69, 0x3fcd79da06ed5338,
    0x3fce9f5a7c6873a8, 0xbff022a528419f6e,
    0x3ff48b93a633d037, 0x3ff47a83ee98a9aa,
    0x3ff1d0afb2a30dec, 0xc0033af0b208c024,
    0x3ff72c73ed072472, 0x3fc1c26cbf1b1dc2,
    0x4000ad4d03ec1a6d, 0xbff6d94661d936e7,
    0xbfe7e4f261dcb92a, 0x3ff8be348d0f49a9,
    0x3f85fb57509c3a20, 0xbfe9fb05092d9da4,
    0xbff6c6a25c494352, 0x3fcba45b3a1d0dca,
    0x400198e1e38e1b3e, 0x3fc0da9818fe4a98,
    0x3fbb7b0bc7a133b0, 0xbfd3cebb3a1d45a0,
    0x3ffbc3c6708e4496, 0x3feb48e891660ba2,
    0x3f64534ec8384280, 0x3ffd7806ca4ff68f,
    0x3ff296e6bb6e1f3a, 0xbff99adfcacc65e1,
    0xbfd8f1a95ee05828, 0x3ff13aafca665fb3,
    0xc000daeec11c5e54, 0x3fd42fa31eb0a382,
    0xbfea82fed3716baa, 0xbfef1f478d668677
    };

static const uint64_t ref_cfft_noisy_1024[2048] = {
    0x3ff92de7e36d859e, 0x0,
    0xbfea82fed3716bb2, 0x3fef1f478d668674,
    0xc000daeec11c5e51, 0xbfd42fa31eb0a387,
    0xbfd8f1a95ee05819, 0xbff13aafca665fb4,
    0x3ff296e6bb6e1f37, 0x3ff99adfcacc65e1,
    0x3f64534ec8384680, 0xbffd7806ca4ff692,
    0x3ffbc3c6708e4497, 0xbfeb48e891660b96,
    0x3fbb7b0bc7a13398, 0x3fd3cebb3a1d45aa,
    0x400198e1e38e1b3e, 0xbfc0da9818fe4a86,
    0xbff6c6a25c494351, 0xbfcba45b3a1d0de7,
    0x3f85fb57509c3800, 0x3fe9fb05092d9da9,
    0xbfe7e4f261dcb920, 0xbff8be348d0f49ac,
    0x4000ad4d03ec1a6c, 0x3ff6d94661d936ea,
    0x3ff72c73ed072470, 0xbfc1c26cbf1b1dce,
    0x3ff1d0afb2a30de8, 0x40033af0b208c025,
    0x3ff48b93a633d039, 0xbff47a83ee98a9a8,
    0x3fce9f5a7c6873b4, 0x3ff022a528419f6e,
    0x3fdcac163f7d7f67, 0xbfcd79da06ed5334,
    0x3fe851f5b38903d3, 0xbfdd666fe3d2a22e,
    0xc008d438ce350004, 0x3feafc7fb910a902,
    0xbff1e6255e2a24b3, 0x3fee5dd0b535fd65,
    0xbff9f4a68e97065c, 0xbfd2a30e5c427e4a,
    0xbfeb32f0a6a65560, 0x3fee0a64aa2e9fef,
    0x3fc9ca9593f1f1ec, 0x3ff4023da20bd6b8,
    0x4000549b72e2502d, 0xbfde93bc9faa8beb,
    0x3ff1b2dc01b216e4, 0x3fd363baa62eaf8e,
    0xbfd609751e00fe2e, 0x3ff2c7f9bf68a2f2,
    0x3ff0ca3b447ba091, 0x3fde631068add90c,
    0x3fe82c7c6f16ceec, 0xc00404067f8d405f,
    0x3ff09f0327769f52, 0xbffaa50b1bfb09e6,
    0xbfe2fa25558e5bb2, 0xbffaa6c0fd3825c6,
    0xbff4ea94117508bf, 0xbff215dcc732eca9,
    0x3ff3ce1282a84731, 0x3fa0e5c4ab0fb32c,
    0xbff4917c7e368840, 0x3ff95cbbc12332cf,
    0x3fda3b0b39616f02, 0xbff2a3270f7ecf9a,
    0xbff2bc72fa47c5b0, 0xbfe02c89ae6d6484,
    0x3fd314db927e8cbd, 0xbff2984d780c5998,
    0xbfdddfc0d61dec7e, 0xbf9b8637316b4240,
    0xbfda0f318755a632, 0x3fd65ebe5c7e2d88,
    0x3fea67a7f0bcebc0, 0x3fd360aec40b3a85,
    0x3ff22ff2867f7d1d, 0x3f9b13e5257caea0,
    0xbfe503609f2e05ab, 0xbfbddca0e824cc34,
    0x3fecee54f46534e2, 0x3fc13af7977ac6da,
    0xc006e7e436405060, 0x3ffbf342c20e43e6,
    0xbff62d9010869304, 0x3fc357a55c4ebc7f,
    0x3fec1460273207ba, 0xbff94039c2f5f408,
    0xbff7010866f6f3e6, 0xbfd5fa4f61a60769,
    0xbfc89f30dea6242a, 0x3ff99930af692474,
    0x3fdd0311e242989d, 0x3ff7cb2cc02c3bfe,
    0x3fb8733046da7cc8, 0x3fb7331f6b359358,
    0x3fe930aa5c30eb58, 0x3ff76c9d3f9e0222,
    0x3fee3a82ce8f3ff8, 0xbfe7965c3ea1fd56,
    0x3fd888b45d8527e8, 0xbfc2b54bfc4e7740,
    0x3ff38d3375226bc6, 0xbfef1a3c6568a40e,
    0xbffdb89764f7d73c, 0xbfefbe3c952a8cbe,
    0x4004da2396d78df4, 0x3ff39d1207bb6f22,
    0xbfe5226c22544013, 0x3fd87f9cc81e2bc2,
    0x3feaafd60cde35d1, 0xbfdff0c252efa5ec,
    0x3fea2101ba55c4cb, 0x3ff22724da5c9efe,
    0x3fc13d2b485281e0, 0x3fe8323c66265762,
    0xbfe35e582c2dfe5e, 0x3fa7a15ef9a1a860,
    0xbfb0def23c8cff30, 0x3f83a5d7a7155640,
    0xc00380b42ceeeb58, 0xbfdf08d884173aef,
    0xbf7110eb74a7c400, 0x3fab20b20ab6df90,
    0xc002e71424472b04, 0xbfd9f5df250fd1d8,
    0xbfe48e83eec865ec, 0xbfc62b9185bd5fcb,
    0xc00181f86d7ae061, 0x4004292c76dd0236,
    0x3ff0f862d3f477ac, 0x3fc2894f5350fa14,
    0x3fec276b3cedae80, 0xbfe1c583c98aeb04,
    0xbfd5fe3283eb2fe6, 0xc00495636ff0a75a,
    0xbfdf3ef9e321a372, 0xbff2e4c25e8aa778,
    0x3fa9232217d165e0, 0x3fca971bb0d64797,
    0x3fe877e5b959a43d, 0x3ff3dd41ed561b70,
    0x3ff0bca4c7cad4a6, 0xbfebbb8425f17f71,
    0xbfd1ea3a3c6391a0, 0x3fc3d8077be08b00,
    0x3fe9e54d2f2f0eed, 0xbfebc498dd09fee2,
    0xbfc5ae4dcbc23410, 0xbfd8134058a643e1,
    0xbff1a58ae0119216, 0xbfe05afa2cd6111e,
    0x4000bd5d354c96d4, 0x4000c90e71892834,
    0xbfce951adb8de180, 0xbf46170f234cc800,
    0xbfd012776ed4966b, 0xbff3f5bb44bbcb80,
    0xbfd4887911432c1a, 0x3fcc72f8d9d98510,
    0xbfd5dd186f3e4f28, 0x3fe6f73cdc87663c,
    0x3fefb53b6d480d2e, 0x3fd11df3993b91a6,
    0xbfeb6f2c5feceb89, 0x3feaeb650133a68c,
    0xbfcd29eb16f63154, 0x3fd989bd79dc90fa,
    0xbfd6646f7ef145dc, 0x3fe001c753623528,
    0xbfd78409f101d946, 0x3fc7bf6132ffb594,
    0x3fe796c4fd9300cd, 0x3ff25b94aa7d2080,
    0xbff5402d0054a25c, 0xbfd9f39f81b93552,
    0x3fec711372d3f8d2, 0xbfcdea963e332614,
    0xc000e20283102f9f, 0xbfeb4fa0735d90bf,
    0x3fa9fd4d8b5a5084, 0xbfec779b317fa40c,
    0xbff6ee879d959286, 0xbff7605212767ca5,
    0x3fe13c0a403114c1, 0xc00466cf67997890,
    0x3ff8e84bb082e39e, 0x3ff3be6087a01b34,
    0x3ff25433b44a9e7b, 0xbfe2e03b4bf69e28,
    0xbfe8adfb9b930018, 0x3fc90b16fd5d57bf,
    0xbfc53b1dadc0a5ca, 0xbfe2892d50e66903,
    0x3fed13aded83d074, 0xc006f30eb5646aec,
    0xbfd50d9b3eba348c, 0x3fe868e4535a7d47,
    0xbfe895e438c36f59, 0xbfefd8c85566f2c2,
    0x3ff1466d78ad6b9e, 0xbfe6d1c4a1c1bba5,
    0x3fee4070ea72462b, 0x3fddadfabec79516,
    0xbfd05f285fcbb684, 0xbff28deef3757322,
    0x3fe7b77f75958509, 0x3fb738f255b5fed6,
    0x3ffaac38007e369a, 0xbfd4be2addffb633,
    0x3fbfd5e940620fb0, 0x3fe2613e25badc59,
    0x3fed14f0e9bfef42, 0xbfea15deea65a162,
    0xbff31559b29ae768, 0x3fc13e1aa43a14bc,
    0x3ff24a06e1ca4262, 0x3ff0c904a4f072a0,
    0xbfe7edecc8318126, 0x3ff26540c213dd95,
    0xbfe89a8e6b23e9c7, 0xbfe1e80ec74c1afc,
    0x3fe39ed239e44c92, 0x3fc0ee454ebe5954,
    0x40026d2c9f0b2d93, 0xbfead873b4b21bd3,
    0x3fdf2dab2c51c6f4, 0x3ff5cd3d971e929a,
    0x3feb7fe7bd028022, 0x3fa124ac1e5eeea2,
    0x3fc48e48985ff928, 0xbfd1ad73eda6c438,
    0xbfa27663da35abc0, 0xbfff039f828347e7,
    0x3fd6bd4f965af76e, 0xbfc606caa14315da,
    0xbfc54dc188baea20, 0x3ffb46fd9f263647,
    0x3fd75ea6f6918dd6, 0x4005cc65752ac38c,
    0xbfdba56d11aea2d9, 0x3f96e440d7fecf00,
    0x3fac356693c57168, 0x3ff15d18a9518f68,
    0xbfed912d46eb8380, 0x3fc77989e1ddc53a,
    0x3ffb4357a302117d, 0x3ff5e70ee145586b,
    0xbfc509e56b47672c, 0x3fd1a972c42e02ed,
    0x40051270612dc0ce, 0xbff13a528ac8915c,
    0x3ff33ada0eeb6e00, 0xc0767d785499e3b0,
    0x3fc8ce9b511529a0, 0x3fb3002040002d20,
    0xbff43115bc4fca02, 0xbfd3a2dc8a6b34b8,
    0xbff8719f1e9c024b, 0x3ffa7843653f6e74,
    0x3fddacdf1d586994, 0x3f87f54c078bc780,
    0x400776c5825cb4c4, 0xbff0f3e389e45e96,
    0xc0002f17c79d55f9, 0xc00018ea1b890b99,
    0x3fed7c5e3e6c936a, 0x3fe88bb0abdf2b1f,
    0xbfd7b03c5ad3cc58, 0x3fd31980c3a3d09d,
    0x3fe3c668eb184e76, 0x3fd6bbdca8476120,
    0xbf7c3ccf49c46100, 0xbff6904cd8d89d8f,
    0x3ff4372e50f4f47c, 0x3fe3a7b4175e0d99,
    0x3fe9fc5f94728f3b, 0x3fef5b8590bdd2f5,
    0x3fe8748e596c4c47, 0xbfe08169c9e33c82,
    0xbfc51b263e469aa8, 0x3ffe773efc63b110,
    0x4006ff0a2e4bdc7d, 0x3ff4d1e0ec7340fe,
    0x3fe678303013f9f1, 0x3fec3aa826baee0a,
    0xbfe5fa3b699a0ef3, 0x3fd76c6a5a422de1,
    0xbfc5364e65769a7f, 0x3fef0120b96776d4,
    0xbfea1864e3acbbc8, 0xbfd061cb70d552a6,
    0xbfe9f9a1203ed892, 0x3ff27abf7afbba88,
    0x3ff59397b828d7dd, 0x3f74bf21a971b760,
    0xbfe921eb6d4e4039, 0xbfbcebb0a5f51814,
    0xbff27a4051553450, 0x3fec972ac7b50cad,
    0x3fb3e102cd581b8c, 0xbff14d32b1c83fcf,
    0x3fdc459cbe5c2ec6, 0xbfc2a8bc5f3c0770,
    0xbfee7ca7d6194ad6, 0xbfd1a374139f53d6,
    0xbff5ebf084a69972, 0xbffa370e07eddaa7,
    0x3fe0b39e4d5c9532, 0xbfd84a2036d6fa02,
    0x3fe19ef1bd921173, 0x3fd7f3ba0239eecc,
    0xbff1448afc38448e, 0xbfe08bc7411c1f24,
    0xbff13227cd94b467, 0x3fcb25263383b3e9,
    0x3fd8b748baeadf1c, 0xbfed4d9f2ba4ed60,
    0x3f8d6bf8f359cba0, 0x3fe0b9edd9b8c4ee,
    0xbfefaf0a3e9a1ae7, 0x3feb64c0b7071742,
    0x3facb000f8353e80, 0x3fcecfc0a4b5011a,
    0xbff9d2bc2462bee8, 0x3ff874e553da40c6,
    0xbfda13a11088a4a7, 0x3fd980516a84003d,
    0xbffec3d92e146883, 0x3fbe0d30fbd95c50,
    0x3ff667fa0a12ed8a, 0xbfe77ddf7fb953b3,
    0x3ff50bdd51138f24, 0xbfe5d567cfe67cec,
    0xbfc90c22ef0d0990, 0xbfbfc95e20304680,
    0x3ff8bf195a74cb76, 0x3fca9448fd4f4684,
    0xbff957307fe9026e, 0xbfdf603742226db0,
    0xbffcf3fa5674fb45, 0xbfd270a14343f6b9,
    0xbfd40e0eb9f5e668, 0xbff777e5fe283911,
    0x3fe2dac611fdc6ca, 0x3fd248cc16aaaacc,
    0x3ffaf51e5174ce74, 0xbfeb52fd57b048e6,
    0xbfb9f3b2fa8168c0, 0x3ff2134443829df7,
    0x3fd60220ef68e560, 0xc0014ebcc09637b6,
    0x3fc2f06e3c059100, 0x3ff9a898035c0b60,
    0x40005968f2ae1841, 0xbfce34256992fcac,
    0x3fd9df8ed55d2947, 0xbfe0f751d269078d,
    0x3fef6d9ac74e6805, 0xbfe80b961e316eb2,
    0x3ff15ea08709b8a7, 0xbfe1ae55a340ea80,
    0x3ff70ac5c6b0687a, 0x3f8cfb8de6e972e0,
    0x4000dbb02d84c5eb, 0xbfe414736f39fbac,
    0xbfe822e9c83269d4, 0x3fd77efb71220c04,
    0xbff04bf13b854a1d, 0x3fed6051817e2d66,
    0x3fc379d5198dfd18, 0xbfe752c22ea142d2,
    0xc0010ab1ea14998c, 0x3fb639d06bfb52bc,
    0x3fd69da853e80c4e, 0x3fee9cd995d12da2,
    0x3f83e48087bd9480, 0x3fe04e8e6ebe9178,
    0xc000398fae5c5dea, 0xbff6c98fdddc83d0,
    0x3ff076da4a0f9e86, 0xbfeea09126bf2a72,
    0x3ff18e0715b659cf, 0xbfe5877b802c9826,
    0x3fedb58195bf484c, 0x3fd87f1f357d4770,
    0x3feafdb9f92a7ed2, 0xbfb02da65d9e7930,
    0xbff0c06bab034230, 0x40010dd9625b7a54,
    0xbff5c0c624da9947, 0xc00c56298231f2ba,
    0xbfd8dd6845a81fe4, 0x3ff98c1f1c208d5a,
    0x3fea25fdda3dbf02, 0xbfeb0cf8f7574e24,
    0xbff1556c7a0f6ed4, 0x3febc15246a967f4,
    0x3fcf9da5feb07406, 0xc00074912b58daee,
    0xbfeaa8433c5b656c, 0xbfc665309df3f05c,
    0x400710fdc783c374, 0x3fdc4ba182f0b472,
    0xbfd4d8ceca5265e8, 0xbfe17120ad445868,
    0x3fc4ea3371470556, 0xbfdd29565055532c,
    0xbfd5c49c8a7a1c79, 0x3fd587166c701411,
    0x3ff0ffee1ede08fc, 0x3ff86efa061b8136,
    0xbfdc650091f30ec6, 0xbfe90c54439c03a6,
    0xbfe0cd6056997542, 0x3febb6d2abbc1899,
    0x3fd5a3bc71afd2d4, 0x4006bd35de480b84,
    0x3fc56d245f2a589c, 0xbff52bffd6d98fca,
    0xc0001cc7a2dcb948, 0xbfe999eda065e3a8,
    0xbff020b3ceaa393e, 0x3fdf71baf89279c0,
    0xbff77fea4b068053, 0x3fe07942e86a23ef,
    0x3fda856675e99227, 0xbff9898379dba678,
    0xbfe796ebc3021fcb, 0x3ff609936c2a122c,
    0x3ffa3dedf8244af0, 0x4003ae0681204361,
    0x3fe4f839cb6c9314, 0xbfef5fa361245574,
    0x3fe9656dc4e1a182, 0x3fe101ff8f3dd6ad,
    0x3ff49767a701f754, 0x40003be88a6f55f0,
    0xc000ddd6fb574c15, 0xbfd6becabaa2a1c6,
    0x3ffbada9b411ce2a, 0xbfe630412cbfa776,
    0x3fd63178bcb2112e, 0x3f835267b284dd80,
    0xbfe9db87d005571f, 0xc000f3c0437d8c18,
    0xbff26e9eea5680fa, 0x3ff55a65b3de1a74,
    0xbffda580632ef6eb, 0xbff9c9329046afcd,
    0xbff599f615f35425, 0x3ff97e9aa57350b8,
    0x40008234c7b27039, 0x3fd7b0dbbfa84494,
    0x4005151f518ca118, 0xbfc1901f0832535e,
    0xbff5041cea1c10e0, 0x3fbc18637dce6358,
    0xbff37ce549663dee, 0x3ff7592892d6f7f7,
    0xbfdcd703d18be462, 0xbfe98de1f7714759,
    0x3fe41bdc3e4fd0cc, 0xbfff3f775cd8c0da,
    0xbff1e7ef1d6aa059, 0x3fc2a991b8c3b4e1,
    0x3fe286dcc43b7f56, 0xbfd9d1c20564b212,
    0xbfd19ae7df5a0f3a, 0xbfddc5a0be51601a,
    0xc0003ad9cf8c3ed2, 0xc0121e3d52499abc,
    0xbfe4afd77e6c8ba7, 0xbfd9b971c652faf9,
    0x3ff5846d0ba43fbb, 0xbfe78a7ec5f4ef0a,
    0xbfd2bcab7fa7de44, 0xbff6c6753fb8839e,
    0x3fe646c2aa637af2, 0xbfdba199ad7178fc,
    0xbfed454ebc111e84, 0xbf8429940996b860,
    0xbfe7d66661fc10b2, 0x4005786512fc8c71,
    0x3fe5a9145999e146, 0x3fdeb29a30f5c9f6,
    0xbfd8146107dcde60, 0x3fe5705f7f03e996,
    0xbfad7b49bebb1000, 0x3fde46702bfcf95f,
    0xbfe644dc70c7440c, 0x3ff37b954a09a76c,
    0x3fa4260dc82b2c30, 0xbfbfc401ffdf07fc,
    0xbff98e61befae3ce, 0xbff99305f87698eb,
    0xbfec9eb8bac3ad87, 0x3feb1b90c7a8de72,
    0xbfea6de9cc3a7674, 0x3ff1c14cef402e1d,
    0x3fef888cfb4ae0e1, 0x3ffc5a941c422a07,
    0xbfe065d5f10d3f46, 0xbfe15914446eb346,
    0x3fefefe90fe96f9e, 0x3fe1817ed26109e3,
    0x3fd2778048cb8ad1, 0xbff08e8b3b2e6062,
    0x3fc2d326d1b620f0, 0x3ffa3822ba432c00,
    0xbfdb221f8ef1701b, 0x3fdd11714c381ea0,
    0xbfe8a7cba09564f6, 0x3fe2426420e464ce,
    0x3feb580a6d63f3dc, 0xbfe1ef05b4d210f3,
    0x3ff9439daeb84bc6, 0x3fd24892391e6d74,
    0x3fedbf15c5530eae, 0x3ff8c323f5332454,
    0x3fe266c78f6e7c1c, 0xc00038ed3a84ac18,
    0xbff04089a83361b4, 0x3fdd1fcfb589ddca,
    0xbff19a5dd7b173be, 0xbfe5501b3481f530,
    0x3fed731a2452feed, 0x3fe197ab9651498c,
    0x3ffd55a5158f40ea, 0xbfb411a1228efea8,
    0xbfcf7e780a15b08a, 0x3fa694bc91bb6d50,
    0xbfc2c105566186f0, 0xbfedb2631bd0bde2,
    0xbff5cdb403a4200d, 0xbfe134952b4a7e3c,
    0xbfebd2ff76b35367, 0xbfec7ef46d53f8e9,
    0x3fc2ecaa8b3cfcde, 0xbff3b4f77067b7b1,
    0xc0008e7d7f3cae4e, 0xbfe26748970a1279,
    0xbfe9958308bec801, 0x3ff8a2a42b6101f0,
    0xbffecbd751ae1a8b, 0x3fe6d06275744369,
    0x3fe9737b59a999df, 0xbff96a69a1b91831,
    0x3ff202fab9cbb9d2, 0xbff540fe4a12f916,
    0x3fb18f9f73ef4cf8, 0x3fe316d9d99da3dd,
    0xbff1ed8cacb8fa00, 0xbfc7cc846522414f,
    0x3fc0c094298cabd4, 0xbff3b31142a50ab0,
    0x3feaecdc22172c70, 0x3fd75cc34d1ae272,
    0xbff1548d8b42d19d, 0x3ff15b3f4f5d3fb6,
    0x401062f4500a96fe, 0x3ff1acbddc9132de,
    0xbfe2348952cff894, 0xbfeeb3690c103498,
    0xbfe85df2f9ed3d35, 0x3fc2c5867d999872,
    0xbfe25e40bce4bc58, 0xbfabff1c3c69cec0,
    0x3fe2ba9556b8320a, 0x3fe4ef0b276302a6,
    0xbfd820575273d86a, 0x3f8663976dc12a40,
    0xbff302ad81fc1aaf, 0xbff2cd4db0ef745c,
    0x3fc8911ba96f8cb0, 0xbff0273325f2748e,
    0xbf895dd1c08f89c0, 0x3fcf5f364fd73c07,
    0x3fdb5fd17b160850, 0x3fbd23e8fab4488a,
    0x3fe118c6dd4c949e, 0x3f679fe0b6ecb400,
    0x3fe078da3afa7869, 0xc001aeac440cb9de,
    0x3fe07d6a3100d472, 0x40016b2cdc06fa76,
    0x3fc2f47bfc51b9b0, 0xbfe7002b61232a20,
    0xbfae2b99ea18a320, 0x3fd46021565b3b90,
    0x3fef006bb5649b2f, 0xbfeb6f49a4ded926,
    0x3f9887b18f4168c0, 0x3fed4eea8019a0ec,
    0xbfc5157c3a23245a, 0xbfb4ea1bfc320a9c,
    0x400051adea3da9d0, 0xbffcd03de8d2cf6a,
    0x3ff5e5f895441e4b, 0x3ff9408d9f799b4e,
    0xbfe1c0d934bbf75c, 0xbfd7ed673c48f674,
    0xbfec8c5b16814d49, 0x40006cfa902b9c4b,
    0xbff350aaab5e714e, 0x3fd437aee97c849e,
    0x3fe7a399d7747d2a, 0x3fefb7beba9dce98,
    0xbfcf23e5bf8d8228, 0xbfe06a55cb0dc20a,
    0x3fe7fc66a77edae7, 0x3fd69447b09fb388,
    0xbffc40df88c2d02c, 0xbffce6651bec3195,
    0xbfec71aec38b4b93, 0xbff394fb410b4b88,
    0xbff1d44fbdd8f567, 0xbfe1599702dd560e,
    0xbfe4cd6510565bd0, 0x3fdf2fb3930e34a2,
    0x3fc8595f523b2ec8, 0xbfe1c9908dd49156,
    0xbfd83fbe064cae44, 0xbff2ea308efaee42,
    0x4002650a138e0d86, 0x3fff306e1ed32087,
    0xbfded408f7cfa350, 0x3fd95044b637d834,
    0xbfee0ccf8b14b01b, 0xbff4f44cb71229d3,
    0x3ff2dc905b50c476, 0x3fd47486d2cb9a4a,
    0xbfea512d3c24382a, 0xbfd86e2438858cff,
    0xbfc3413a48964754, 0x3fda36079aa150a8,
    0xbfd2f7d963717ad5, 0x3ff1b6fe9114c818,
    0xbfe69d8e0eda523b, 0xbff26cb2b602c6f3,
    0x3f71ee7a786fa640, 0xc0030dacef1f1e0d,
    0xbfc3347c44c2315f, 0xbfeedb8b9b8e1f8b,
    0x3fe64f212b02a4f1, 0xbfc9b05a3bc3e327,
    0xbffa636557826452, 0x3fa027b01c5cfea0,
    0xbfb1204701362b60, 0xbfe422a5b38a209b,
    0xbff19d84838c4fa2, 0xbff7f6dd420b2cb3,
    0xbfe5cd25c1861f4f, 0x3fd1dfb26534d720,
    0xbfcb6cef17d6ca30, 0x3fdf611971ab0f7d,
    0x3fd873c4f1e9723e, 0xc00115434cfafae8,
    0xbfefb898458fe78d, 0xbfcaa929fc2ac928,
    0x3fdddb7ca8449796, 0xbfed98b7501b8d48,
    0xbf4fec6ea0f9a800, 0x3fe3d4ceaccd5319,
    0xbff89a7abc997770, 0xbfd10d5aea595c70,
    0x3ff05981198aad16, 0x3fb378dd9f126600,
    0xbff3506ffcc8c4c1, 0xbffc59ca770b0300,
    0x3fe8d38ef5bfce07, 0x3fb5cb5e2ca0faf0,
    0xbff96d1de7431dc2, 0xbff9819c2668cce5,
    0x3fd7986ce555818a, 0xc00e800c1d4772b1,
    0x3ff2d62d8661215c, 0xbfd85d8fab8a023f,
    0x3fe9967c83011ae2, 0x3fe8da125cd7a340,
    0xbfc5b8e8e9956470, 0x3ffb17b6b9973901,
    0xbff2477a7394ae0c, 0xc000591169176b5b,
    0x3fe766b051661fa0, 0x3fddffe9e699f236,
    0xbfdeab0ebafa0b8e, 0x3fe79740e0755938,
    0x3fe0247727aeea18, 0xbff1ba910548672f,
    0xbfe216a2c930b2f0, 0x3fe2d1b3f4780c5d,
    0xbfd1563af85f1f50, 0xbffaa66b12b5fd3c,
    0x3fe1263bac85ecfe, 0x3fcbbe9f7ea6480d,
    0x40023379c6145244, 0xbfd4cfdf41d24012,
    0xbfe7d030612008f0, 0xbfc7f61f9f141334,
    0x3fe6f99eeef32aea, 0xbff7043f51b6af9c,
    0xbfff1656d1339e53, 0x3fc6743f15ea1c46,
    0xbfd40718ac78e62b, 0xc0056a2e06ec029a,
    0x3fb483f1e0e16d40, 0xbfff9cc086093b15,
    0xbfce8797d3efd1af, 0x3ff7b00876dfdb1c,
    0xbfeb2df803d67248, 0xc007df69ef8d5be9,
    0x3feaac57eeb454c6, 0xbfe40f0ddbae42ae,
    0xbfe734f58ed90291, 0xbffbe98a193ec599,
    0x3fbc8beff78539c0, 0xbfee43a0a5c2f2ba,
    0xbff1199c2f53c320, 0xbffcea2311b0568c,
    0xbfd4dd77e4130a3b, 0x3feb71d65712893d,
    0xbfe35bd9a46d0185, 0xbfd8e15a56f4779a,
    0x3fc811f81b668b88, 0xbfe78d8e1f6e1eac,
    0xbfedd72821012114, 0xbffdd6cbb8c43406,
    0xbfe11b60e4c4ff68, 0x3ff50e29d080e1a6,
    0x3fcf2a76fc1c6e68, 0x3fe720a98692c1af,
    0xbfe3792cd5c18e36, 0xbfac19d4d9ca03c0,
    0xc0009da539a11eef, 0xbfe0aeb704497bca,
    0xbff6407760a19526, 0x3ff47d9e498cc818,
    0xbfe6a3376c86a014, 0x3ff0f7475f3de700,
    0x3fe65cbadc5b9282, 0xbff80918046f2bb4,
    0x3fe5d6136ea2d32a, 0x3fc03697931b33c9,
    0x3ff5bc60386054cc, 0x3fe57d9b83d1cb3e,
    0xbfe3e7e30a06027f, 0xbfc8343307617b9b,
    0xbfc48a70ba8b3d94, 0xbfe381819028e6fe,
    0xbfe4692675d531a4, 0x3fc571fed2938b6c,
    0xbfdb85015a46dea2, 0x3fe39dd3748bf96a,
    0x3ffbd7d9e79308e8, 0x4002f794d9b08b12,
    0xbff09414578cc3c6, 0xbfe73fe892617790,
    0x3faa32c0661bc980, 0xbff073e43b735b2e,
    0xbff7e76ac2ac68d1, 0xbff8fb8dc3c3e826,
    0x3ff01e91b094a970, 0x3fe527a9cad66b2c,
    0xc00836ddd00f7ef2, 0x3fec0840111fbf00,
    0xbfd2749104a8f708, 0xbf92565b70ee34c0,
    0xbfe564b95917c336, 0x3fc462b08a8e5552,
    0xc0002d10fee2db6b, 0x3fd0f3e53c19cb02,
    0x3fd8d076094cbef0, 0xbfeb5fca6c09408a,
    0x3fd4afac2f5398c2, 0x3fdc565c18b42bb0,
    0xbfbb975315222ecc, 0xbfabc17732990aa8,
    0xbfe40b3bd7875242, 0x3ff0721bab1b79e8,
    0x3fd71d5d74a065ea, 0x3ff01968c756ac7e,
    0xbfa9fe36067a1e3c, 0x3fcbf8599e78906c,
    0x4004e670f1231a12, 0xbff0fc6d992514d7,
    0xbfe321b0056d58ac, 0xbff840a789b8efe1,
    0x3ff72987b227d8b0, 0xbf8304b73123c3d4,
    0x3fe1d675d0784adc, 0x3fc7caea4ac4576c,
    0xbff41ef8bbc8ab7c, 0xbffba13a1eaf35ee,
    0x3fe1d02cef38064a, 0xbfd00761ab5bdcb4,
    0x3ff436a3296ba8d4, 0xbf97d61e22985a10,
    0x3fd3be5751246a84, 0x3fa54071b89e0c00,
    0x3fed15192bde42ac, 0xbfe230bd499cac82,
    0x3fe50dd696c34fe8, 0x3ff135b4ebb4d8e8,
    0xc00117f7c5b65110, 0x3fd34f84474b9c07,
    0x3ff7a4f7e9cc71be, 0x3fc34ca45890554c,
    0x3fd84a25f032f594, 0xbfd6a9934c93771b,
    0x3fffc13351ad3f8c, 0xbfd4f92558e1a051,
    0xbff998b86e8524f4, 0xbfee79ff764eee5b,
    0xbff97c1d1339e8ca, 0xbffaf6b856578820,
    0xc003737a7de4798b, 0x3fc67c22001d62e0,
    0xbfe246598e71e514, 0x3ff96e36e98367c2,
    0xbfdf62e9fd4a4954, 0x3fa8d78d373cafa8,
    0x3fec4eda1ef17734, 0xbfe3fc292e95eb3a,
    0xbfc2e0a8aa42b6be, 0xbfe92c397c1255e1,
    0xbfeb2646836b47b5, 0xbfd8cfe321aeb282,
    0xbfa11ccdc31c1b30, 0x3fee978236c306c6,
    0xbfda206917e43032, 0x3fba8423d4e30c48,
    0xbfdd1adca61df168, 0xbfec5d6baf2671a3,
    0xbfbb614d3b9705f0, 0x3fe18d4599d23ea8,
    0xbfdbeebf14342ecf, 0xc00a4ab8e7e191ba,
    0xbff70b720fe8c43a, 0xbfb5313910015d54,
    0x3fb217dde46064d0, 0x3ff21a2a14ab2e20,
    0xbfe4537c93b60a7d, 0x3fcadbcebbcceba4,
    0x3ffbfa8f5e1e5bd2, 0x3ffcadbac923a438,
    0xbff0f9ceb72c7bb6, 0x3fe778bb2aa365cb,
    0xbfd123ad43133019, 0xbfcd12118e619350,
    0x3fde2a350c994d60, 0xbff7ab248ce4a006,
    0xbfd8a4b2ba555cc1, 0x3fd8e7a074ab1045,
    0x3fe2dac085382bd6, 0x3ffe5c4b80ad3c90,
    0xbfec5ce9bf2cb8fc, 0x3ff4fb1258a398be,
    0xbffcdbb219093cfa, 0xbfebcdf819b8660a,
    0xbfdb5deb57dc0174, 0xbf8bff9e9f87a080,
    0xbffad177c1639cdc, 0x3fbdf7c071a31266,
    0xc000da9320f9c547, 0x3ffe93b0457f4308,
    0xc000a97ebec5da84, 0xbfef3841835285fe,
    0x3fe9420443890274, 0x3ff189da7c95a835,
    0x3ff72f23366c7b75, 0x3feb6a5a17036af3,
    0xbfd08296d455e7a6, 0xbff69009b7b6c286,
    0xbfe467895b77756a, 0x3fe9bd2aa86ff4eb,
    0x3fe63f3e10507002, 0x3fe4bb994d01a52a,
    0xbff80a66eb5de22e, 0xbf922a132c8b7aa0,
    0xbfe75b9fd5586b93, 0xc0077cf97a58b682,
    0x3ff03789c09027c5, 0x3ff3a287077b9658,
    0x3ffec626e21aa5eb, 0xc00368b447ec5229,
    0xbff3cf5b603bf058, 0xbffccb86d82b14db,
    0x3feb59c98217c3c4, 0x3fea2da988cb94dd,
    0x3f9d98c4b94ccd20, 0xbfe4a8f526f68d9e,
    0x3ff362920c9c6713, 0x3fd09cf2466a47e0,
    0x3ffa1b3c18843656, 0x3fa2e4efba2c54d0,
    0x3fc7bb02eff20e08, 0x3fee1005ad2d147e,
    0xbff7ba3aaa6bc816, 0x3ffeb3399c2a8bf6,
    0x3ffade25b724c054, 0x4003e8fb3d0a0f18,
    0x400394cfb50ac2fa, 0x3ff6992170612628,
    0x3fc6a02490d0f336, 0xc008ae7dc0b53618,
    0xbfe4d21240f68cd7, 0xbfdb3b51a3f539f9,
    0xbfd7a004ccd67f56, 0x3fe1825bd1604992,
    0x3fed6cea988ca82c, 0x3fe5b311c21930c0,
    0x3ff1a00d5dae891e, 0x3fda9d20533d5672,
    0x3fb4c5bfb59ec110, 0x3ffb36c423bd529e,
    0x3ff53a0d90a3c7f1, 0x40094cc10d9d28ec,
    0x3fea31dab63abae9, 0xbfe49a8614d2be2b,
    0xbff5c0cd24abad66, 0xbffcbe3c6ea25672,
    0x3f9808a353508910, 0x3ff79c14af25b005,
    0xbfe1018604356b6a, 0x3fec2f18a2f73003,
    0x3fecbd0a999f96dc, 0xbfe9246cdca78fb9,
    0x3fe9b2ae2a16a463, 0x3fc0a04215f64ba1,
    0xbff09ab0aefc0df6, 0xbfedcda4bad325e3,
    0x3fd1d00044d29e00, 0x3fc20539d6a2c346,
    0x3fd62030f49bc434, 0xbfaf102b377ab2c0,
    0xbfec40f98f6a692c, 0xbfe3d16991b4d855,
    0x3fd3a10bc7b2c1b9, 0x3fd44eb9768ef44f,
    0xbfe481854f13cef2, 0xbff221616d401c8a,
    0xbff71252a4ee6e7a, 0xbf9ecb1a907f0910,
    0xbfd9d6442dc00113, 0x3ff7596f1261e3da,
    0x3fcd9f96eafcb2c0, 0xbff7a784a5ad2506,
    0xbfe0b21e06549402, 0x3fe04fcc420366c4,
    0x3fff0fba11750eb8, 0x3fde475b557ec594,
    0x3ff44d7af3f533e0, 0xbfcbc5c9398511c4,
    0xc002d85d6a8ecb72, 0xbfe175e82187dc48,
    0x3fef21d9fde8af10, 0xbfc570028c5baef9,
    0x3fd5cfd4c792b5c8, 0x3fc745da1d656e78,
    0x3fd816ebf0b8e03c, 0xbfe05f58d1963c15,
    0xbff1b400072bb3f2, 0x3feafacd01e2e96e,
    0x3fd759964aaca1c4, 0x3fc4b42b09d4f970,
    0xbf9504e7ea4ce980, 0x4001d9eef1ce2ea6,
    0x3fde18f02ced7b28, 0x3fe7bb9a93678302,
    0x3fe097fbbf465d72, 0xbfcf523e8f0b537c,
    0xbfe4a42aeb7f18dd, 0x3ff73d9942e7cdc4,
    0x3ff348e98694e6e9, 0xbfa8fb2946297670,
    0x3f9a58c363b23ff0, 0x3fea102a7ec49596,
    0x3ffd50bdc223077a, 0xc000f54c71114626,
    0xbfeaf5f0167d145e, 0xbffa80f8f663a673,
    0x3ff5ce3afa344661, 0x3ff60e4f75be62ce,
    0xbfb252ede037e558, 0xbf92012e533f4b08,
    0xbfd4c717a063fcb7, 0xbffcc8e8aa8bff2d,
    0xbfec6915785166da, 0xbf6f71840e833d00,
    0x3ff860b896106941, 0xbfe7d6b2980a32b4,
    0xbfd2d6ab872db368, 0x3fe851cd309c72b2,
    0x3fe267a335f7717b, 0xbfe153259154cc06,
    0xbfc15d3c3d2879f4, 0x3fcc90266c960f50,
    0x3ff7dbf236701fc3, 0xbfc357eef65ebbe8,
    0xbfed01c90f3282d4, 0xbfdcf8cb6952b568,
    0x3fe75cc88a4c1210, 0xbfb3f908ed0f4794,
    0xbffefab7e89dac0c, 0x3fa9a1e57020e2fe,
    0x3ff47a614421e29d, 0xbffda9f5da2eb810,
    0x3ffc880b739e63ce, 0xbfd87a625649a318,
    0x3fef432908b77fc8, 0xbfd2bc10ceeaff64,
    0x3fde73944069cd3f, 0x3fead44899f3e106,
    0xbfe0ef92d1c40cd0, 0xbfd8f27ea8c63993,
    0x3fdf79c69a00dea4, 0xbff42e51fc959ce4,
    0x4001ea1adebf4d40, 0x4003d2990218bb4e,
    0x3fd667f259db3e78, 0x0,
    0x4001ea1adebf4d42, 0xc003d2990218bb4b,
    0x3fdf79c69a00dea0, 0x3ff42e51fc959ce4,
    0xbfe0ef92d1c40cca, 0x3fd8f27ea8c63994,
    0x3fde73944069cd40, 0xbfead44899f3e106,
    0x3fef432908b77fc4, 0x3fd2bc10ceeaff6e,
    0x3ffc880b739e63cd, 0x3fd87a625649a31c,
    0x3ff47a614421e29a, 0x3ffda9f5da2eb812,
    0xbffefab7e89dac0c, 0xbfa9a1e57020e378,
    0x3fe75cc88a4c120e, 0x3fb3f908ed0f47a2,
    0xbfed01c90f3282d3, 0x3fdcf8cb6952b55e,
    0x3ff7dbf236701fc0, 0x3fc357eef65ebbf4,
    0xbfc15d3c3d2879e4, 0xbfcc90266c960f5c,
    0x3fe267a335f7716d, 0x3fe153259154cc06,
    0xbfd2d6ab872db362, 0xbfe851cd309c72ac,
    0x3ff860b89610693b, 0x3fe7d6b2980a32b8,
    0xbfec6915785166db, 0x3f6f71840e833f00,
    0xbfd4c717a063fcc5, 0x3ffcc8e8aa8bff2c,
    0xbfb252ede037e548, 0x3f92012e533f4b08,
    0x3ff5ce3afa344664, 0xbff60e4f75be62c7,
    0xbfeaf5f0167d1464, 0x3ffa80f8f663a676,
    0x3ffd50bdc2230774, 0x4000f54c71114627,
    0x3f9a58c363b24080, 0xbfea102a7ec49597,
    0x3ff348e98694e6e8, 0x3fa8fb29462976d0,
    0xbfe4a42aeb7f18d5, 0xbff73d9942e7cdc3,
    0x3fe097fbbf465d71, 0x3fcf523e8f0b5374,
    0x3fde18f02ced7b22, 0xbfe7bb9a93678307,
    0xbf9504e7ea4ce840, 0xc001d9eef1ce2ea6,
    0x3fd759964aaca1d5, 0xbfc4b42b09d4f970,
    0xbff1b400072bb3f2, 0xbfeafacd01e2e96d,
    0x3fd816ebf0b8e027, 0x3fe05f58d1963c1d,
    0x3fd5cfd4c792b5cc, 0xbfc745da1d656e70,
    0x3fef21d9fde8af0e, 0x3fc570028c5baf0d,
    0xc002d85d6a8ecb70, 0x3fe175e82187dc46,
    0x3ff44d7af3f533e0, 0x3fcbc5c9398511dc,
    0x3fff0fba11750eb8, 0xbfde475b557ec57c,
    0xbfe0b21e065493fe, 0xbfe04fcc420366c9,
    0x3fcd9f96eafcb294, 0x3ff7a784a5ad2503,
    0xbfd9d6442dc00104, 0xbff7596f1261e3d9,
    0xbff71252a4ee6e78, 0x3f9ecb1a907f07b0,
    0xbfe481854f13cef2, 0x3ff221616d401c8a,
    0x3fd3a10bc7b2c1bc, 0xbfd44eb9768ef445,
    0xbfec40f98f6a692c, 0x3fe3d16991b4d854,
    0x3fd62030f49bc42c, 0x3faf102b377ab300,
    0x3fd1d00044d29df6, 0xbfc20539d6a2c321,
    0xbff09ab0aefc0dfa, 0x3fedcda4bad325dd,
    0x3fe9b2ae2a16a460, 0xbfc0a04215f64b76,
    0x3fecbd0a999f96de, 0x3fe9246cdca78fb7,
    0xbfe1018604356b6a, 0xbfec2f18a2f73003,
    0x3f9808a3535089a0, 0xbff79c14af25b004,
    0xbff5c0cd24abad6a, 0x3ffcbe3c6ea25670,
    0x3fea31dab63abae4, 0x3fe49a8614d2be2a,
    0x3ff53a0d90a3c7f6, 0xc0094cc10d9d28eb,
    0x3fb4c5bfb59ec148, 0xbffb36c423bd529b,
    0x3ff1a00d5dae8920, 0xbfda9d20533d5661,
    0x3fed6cea988ca82b, 0xbfe5b311c21930c4,
    0xbfd7a004ccd67f52, 0xbfe1825bd1604993,
    0xbfe4d21240f68cd7, 0x3fdb3b51a3f539fc,
    0x3fc6a02490d0f304, 0x4008ae7dc0b53619,
    0x400394cfb50ac2fc, 0xbff6992170612623,
    0x3ffade25b724c057, 0xc003e8fb3d0a0f16,
    0xbff7ba3aaa6bc811, 0xbffeb3399c2a8bf8,
    0x3fc7bb02eff20e08, 0xbfee1005ad2d1480,
    0x3ffa1b3c18843656, 0xbfa2e4efba2c5490,
    0x3ff362920c9c6715, 0xbfd09cf2466a47e0,
    0x3f9d98c4b94ccbf0, 0x3fe4a8f526f68d9b,
    0x3feb59c98217c3c4, 0xbfea2da988cb94d2,
    0xbff3cf5b603bf05a, 0x3ffccb86d82b14d8,
    0x3ffec626e21aa5e8, 0x400368b447ec522c,
    0x3ff03789c09027c8, 0xbff3a287077b9657,
    0xbfe75b9fd5586b9b, 0x40077cf97a58b680,
    0xbff80a66eb5de231, 0x3f922a132c8b79c8,
    0x3fe63f3e10507009, 0xbfe4bb994d01a528,
    0xbfe467895b77756c, 0xbfe9bd2aa86ff4f1,
    0xbfd08296d455e7bc, 0x3ff69009b7b6c286,
    0x3ff72f23366c7b76, 0xbfeb6a5a17036af0,
    0x3fe9420443890276, 0xbff189da7c95a832,
    0xc000a97ebec5da84, 0x3fef3841835285f4,
    0xc000da9320f9c546, 0xbffe93b0457f430c,
    0xbffad177c1639cde, 0xbfbdf7c071a312c0,
    0xbfdb5deb57dc0177, 0x3f8bff9e9f87a040,
    0xbffcdbb219093cfc, 0x3febcdf819b86602,
    0xbfec5ce9bf2cb8f8, 0xbff4fb1258a398be,
    0x3fe2dac085382bda, 0xbffe5c4b80ad3c8c,
    0xbfd8a4b2ba555cc6, 0xbfd8e7a074ab1049,
    0x3fde2a350c994d4e, 0x3ff7ab248ce4a004,
    0xbfd123ad43133012, 0x3fcd12118e619332,
    0xbff0f9ceb72c7bb4, 0xbfe778bb2aa365c7,
    0x3ffbfa8f5e1e5bd2, 0xbffcadbac923a434,
    0xbfe4537c93b60a77, 0xbfcadbcebbccebb4,
    0x3fb217dde4606510, 0xbff21a2a14ab2e22,
    0xbff70b720fe8c43a, 0x3fb5313910015d68,
    0xbfdbeebf14342ef4, 0x400a4ab8e7e191bb,
    0xbfbb614d3b9705c0, 0xbfe18d4599d23eae,
    0xbfdd1adca61df172, 0x3fec5d6baf2671a2,
    0xbfda206917e43026, 0xbfba8423d4e30c38,
    0xbfa11ccdc31c1b60, 0xbfee978236c306c4,
    0xbfeb2646836b47b6, 0x3fd8cfe321aeb26c,
    0xbfc2e0a8aa42b6ca, 0x3fe92c397c1255e5,
    0x3fec4eda1ef17734, 0x3fe3fc292e95eb44,
    0xbfdf62e9fd4a494c, 0xbfa8d78d373cafe0,
    0xbfe246598e71e509, 0xbff96e36e98367bf,
    0xc003737a7de4798b, 0xbfc67c22001d62fc,
    0xbff97c1d1339e8ce, 0x3ffaf6b85657881e,
    0xbff998b86e8524f8, 0x3fee79ff764eee55,
    0x3fffc13351ad3f8a, 0x3fd4f92558e1a06a,
    0x3fd84a25f032f590, 0x3fd6a9934c937717,
    0x3ff7a4f7e9cc71c0, 0xbfc34ca45890552d,
    0xc00117f7c5b65112, 0xbfd34f84474b9c19,
    0x3fe50dd696c34fee, 0xbff135b4ebb4d8e4,
    0x3fed15192bde42a5, 0x3fe230bd499cac81,
    0x3fd3be5751246a7c, 0xbfa54071b89e0ba0,
    0x3ff436a3296ba8d4, 0x3f97d61e22985ac0,
    0x3fe1d02cef38064a, 0x3fd00761ab5bdcba,
    0xbff41ef8bbc8ab7e, 0x3ffba13a1eaf35ea,
    0x3fe1d675d0784ade, 0xbfc7caea4ac45774,
    0x3ff72987b227d8af, 0x3f8304b73123c578,
    0xbfe321b0056d58ad, 0x3ff840a789b8efe2,
    0x4004e670f1231a12, 0x3ff0fc6d992514df,
    0xbfa9fe36067a1e64, 0xbfcbf8599e789062,
    0x3fd71d5d74a065f8, 0xbff01968c756ac7b,
    0xbfe40b3bd787523d, 0xbff0721bab1b79e8,
    0xbfbb975315222ecc, 0x3fabc17732990a80,
    0x3fd4afac2f5398bb, 0xbfdc565c18b42bb6,
    0x3fd8d076094cbeec, 0x3feb5fca6c09408e,
    0xc0002d10fee2db6b, 0xbfd0f3e53c19cb04,
    0xbfe564b95917c33a, 0xbfc462b08a8e5572,
    0xbfd2749104a8f70c, 0x3f92565b70ee3480,
    0xc00836ddd00f7f00, 0xbfec0840111fbf00,
    0x3ff01e91b094a96f, 0xbfe527a9cad66b26,
    0xbff7e76ac2ac68d4, 0x3ff8fb8dc3c3e824,
    0x3faa32c0661bc980, 0x3ff073e43b735b32,
    0xbff09414578cc3c9, 0x3fe73fe892617785,
    0x3ffbd7d9e79308e8, 0xc002f794d9b08b11,
    0xbfdb85015a46dea0, 0xbfe39dd3748bf96c,
    0xbfe4692675d531a6, 0xbfc571fed2938b74,
    0xbfc48a70ba8b3da8, 0x3fe381819028e700,
    0xbfe3e7e30a060282, 0x3fc8343307617b85,
    0x3ff5bc60386054cd, 0xbfe57d9b83d1cb42,
    0x3fe5d6136ea2d328, 0xbfc03697931b33ad,
    0x3fe65cbadc5b9279, 0x3ff80918046f2bb6,
    0xbfe6a3376c86a017, 0xbff0f7475f3de701,
    0xbff6407760a19523, 0xbff47d9e498cc818,
    0xc0009da539a11eef, 0x3fe0aeb704497bc4,
    0xbfe3792cd5c18e33, 0x3fac19d4d9ca03c0,
    0x3fcf2a76fc1c6e79, 0xbfe720a98692c1ac,
    0xbfe11b60e4c4ff60, 0xbff50e29d080e1aa,
    0xbfedd72821012120, 0x3ffdd6cbb8c43406,
    0x3fc811f81b668b9a, 0x3fe78d8e1f6e1eb1,
    0xbfe35bd9a46d018a, 0x3fd8e15a56f477a0,
    0xbfd4dd77e4130a2e, 0xbfeb71d65712893a,
    0xbff1199c2f53c322, 0x3ffcea2311b0568a,
    0x3fbc8beff785399c, 0x3fee43a0a5c2f2ba,
    0xbfe734f58ed90299, 0x3ffbe98a193ec598,
    0x3feaac57eeb454c8, 0x3fe40f0ddbae42b5,
    0xbfeb2df803d67257, 0x4007df69ef8d5be8,
    0xbfce8797d3efd1a7, 0xbff7b00876dfdb1e,
    0x3fb483f1e0e16cf8, 0x3fff9cc086093b15,
    0xbfd40718ac78e63e, 0x40056a2e06ec0299,
    0xbfff1656d1339e51, 0xbfc6743f15ea1c63,
    0x3fe6f99eeef32ae4, 0x3ff7043f51b6af9c,
    0xbfe7d030612008ee, 0x3fc7f61f9f141318,
    0x40023379c6145244, 0x3fd4cfdf41d24028,
    0x3fe1263bac85ecff, 0xbfcbbe9f7ea64802,
    0xbfd1563af85f1f52, 0x3ffaa66b12b5fd3e,
    0xbfe216a2c930b2f0, 0xbfe2d1b3f4780c58,
    0x3fe0247727aeea1a, 0x3ff1ba9105486731,
    0xbfdeab0ebafa0b89, 0xbfe79740e0755941,
    0x3fe766b051661fa0, 0xbfddffe9e699f248,
    0xbff2477a7394ae12, 0x4000591169176b5a,
    0xbfc5b8e8e9956474, 0xbffb17b6b9973900,
    0x3fe9967c83011ae4, 0xbfe8da125cd7a33a,
    0x3ff2d62d8661215b, 0x3fd85d8fab8a023d,
    0x3fd7986ce555816e, 0x400e800c1d4772b0,
    0xbff96d1de7431dc7, 0x3ff9819c2668ccdf,
    0x3fe8d38ef5bfce08, 0xbfb5cb5e2ca0fabc,
    0xbff3506ffcc8c4c2, 0x3ffc59ca770b02ff,
    0x3ff05981198aad14, 0xbfb378dd9f1265c0,
    0xbff89a7abc997770, 0x3fd10d5aea595c62,
    0xbf4fec6ea0f99000, 0xbfe3d4ceaccd5319,
    0x3fdddb7ca844978d, 0x3fed98b7501b8d4d,
    0xbfefb898458fe78f, 0x3fcaa929fc2ac912,
    0x3fd873c4f1e97238, 0x400115434cfafae6,
    0xbfcb6cef17d6ca3c, 0xbfdf611971ab0f77,
    0xbfe5cd25c1861f4b, 0xbfd1dfb26534d724,
    0xbff19d84838c4fa5, 0x3ff7f6dd420b2cb1,
    0xbfb1204701362b70, 0x3fe422a5b38a209c,
    0xbffa636557826455, 0xbfa027b01c5cff20,
    0x3fe64f212b02a4f2, 0x3fc9b05a3bc3e31a,
    0xbfc3347c44c2315f, 0x3feedb8b9b8e1f86,
    0x3f71ee7a786f9f00, 0x40030dacef1f1e0c,
    0xbfe69d8e0eda5239, 0x3ff26cb2b602c6f2,
    0xbfd2f7d963717ad5, 0xbff1b6fe9114c817,
    0xbfc3413a4896475a, 0xbfda36079aa150ab,
    0xbfea512d3c243828, 0x3fd86e2438858d00,
    0x3ff2dc905b50c479, 0xbfd47486d2cb9a48,
    0xbfee0ccf8b14b01f, 0x3ff4f44cb71229d1,
    0xbfded408f7cfa351, 0xbfd95044b637d840,
    0x4002650a138e0d88, 0xbfff306e1ed32086,
    0xbfd83fbe064cae50, 0x3ff2ea308efaee42,
    0x3fc8595f523b2ece, 0x3fe1c9908dd49154,
    0xbfe4cd6510565bd2, 0xbfdf2fb3930e34a8,
    0xbff1d44fbdd8f567, 0x3fe1599702dd5607,
    0xbfec71aec38b4b97, 0x3ff394fb410b4b86,
    0xbffc40df88c2d02e, 0x3ffce6651bec3192,
    0x3fe7fc66a77edaea, 0xbfd69447b09fb390,
    0xbfcf23e5bf8d8226, 0x3fe06a55cb0dc208,
    0x3fe7a399d7747d31, 0xbfefb7beba9dce95,
    0xbff350aaab5e714e, 0xbfd437aee97c84a0,
    0xbfec8c5b16814d3c, 0xc0006cfa902b9c4e,
    0xbfe1c0d934bbf75c, 0x3fd7ed673c48f670,
    0x3ff5e5f895441e4c, 0xbff9408d9f799b4a,
    0x400051adea3da9ce, 0x3ffcd03de8d2cf6e,
    0xbfc5157c3a232476, 0x3fb4ea1bfc320a80,
    0x3f9887b18f416940, 0xbfed4eea8019a0e7,
    0x3fef006bb5649b2a, 0x3feb6f49a4ded92d,
    0xbfae2b99ea18a2d0, 0xbfd46021565b3b88,
    0x3fc2f47bfc51b9bc, 0x3fe7002b61232a1b,
    0x3fe07d6a3100d47c, 0xc0016b2cdc06fa75,
    0x3fe078da3afa7866, 0x4001aeac440cb9df,
    0x3fe118c6dd4c94a0, 0xbf679fe0b6ecb600,
    0x3fdb5fd17b16084a, 0xbfbd23e8fab44858,
    0xbf895dd1c08f8ac0, 0xbfcf5f364fd73c10,
    0x3fc8911ba96f8c95, 0x3ff0273325f2748f,
    0xbff302ad81fc1ab2, 0x3ff2cd4db0ef745c,
    0xbfd820575273d86a, 0xbf8663976dc12a00,
    0x3fe2ba9556b83206, 0xbfe4ef0b2763029e,
    0xbfe25e40bce4bc5c, 0x3fabff1c3c69ceb0,
    0xbfe85df2f9ed3d34, 0xbfc2c5867d999888,
    0xbfe2348952cff898, 0x3feeb3690c103494,
    0x401062f4500a96fe, 0xbff1acbddc9132d6,
    0xbff1548d8b42d198, 0xbff15b3f4f5d3fb9,
    0x3feaecdc22172c73, 0xbfd75cc34d1ae272,
    0x3fc0c094298cabaa, 0x3ff3b31142a50ab0,
    0xbff1ed8cacb8fa03, 0x3fc7cc846522414f,
    0x3fb18f9f73ef4cb4, 0xbfe316d9d99da3dd,
    0x3ff202fab9cbb9d0, 0x3ff540fe4a12f916,
    0x3fe9737b59a999d6, 0x3ff96a69a1b91832,
    0xbffecbd751ae1a88, 0xbfe6d06275744370,
    0xbfe9958308bec7fa, 0xbff8a2a42b6101f1,
    0xc0008e7d7f3cae4e, 0x3fe26748970a1277,
    0x3fc2ecaa8b3cfcde, 0x3ff3b4f77067b7b1,
    0xbfebd2ff76b3536c, 0x3fec7ef46d53f8e2,
    0xbff5cdb403a4200f, 0x3fe134952b4a7e3c,
    0xbfc2c105566186f0, 0x3fedb2631bd0bddf,
    0xbfcf7e780a15b074, 0xbfa694bc91bb6d48,
    0x3ffd55a5158f40ea, 0x3fb411a1228efea4,
    0x3fed731a2452fef4, 0xbfe197ab96514984,
    0xbff19a5dd7b173c2, 0x3fe5501b3481f52c,
    0xbff04089a83361b2, 0xbfdd1fcfb589ddd4,
    0x3fe266c78f6e7c17, 0x400038ed3a84ac18,
    0x3fedbf15c5530eb2, 0xbff8c323f5332453,
    0x3ff9439daeb84bc6, 0xbfd24892391e6d6c,
    0x3feb580a6d63f3de, 0x3fe1ef05b4d210f6,
    0xbfe8a7cba09564f0, 0xbfe2426420e464d3,
    0xbfdb221f8ef17023, 0xbfdd11714c381ea6,
    0x3fc2d326d1b620f0, 0xbffa3822ba432c00,
    0x3fd2778048cb8ac5, 0x3ff08e8b3b2e6062,
    0x3fefefe90fe96f9e, 0xbfe1817ed26109e2,
    0xbfe065d5f10d3f4e, 0x3fe15914446eb343,
    0x3fef888cfb4ae0e3, 0xbffc5a941c422a07,
    0xbfea6de9cc3a7670, 0xbff1c14cef402e20,
    0xbfec9eb8bac3ad88, 0xbfeb1b90c7a8de78,
    0xbff98e61befae3d0, 0x3ff99305f87698ea,
    0x3fa4260dc82b2c50, 0x3fbfc401ffdf07e0,
    0xbfe644dc70c74405, 0xbff37b954a09a76a,
    0xbfad7b49bebb0f90, 0xbfde46702bfcf95c,
    0xbfd8146107dcde5b, 0xbfe5705f7f03e997,
    0x3fe5a9145999e146, 0xbfdeb29a30f5c9f5,
    0xbfe7d66661fc10aa, 0xc005786512fc8c71,
    0xbfed454ebc111e81, 0x3f8429940996b840,
    0x3fe646c2aa637af2, 0x3fdba199ad717904,
    0xbfd2bcab7fa7de44, 0x3ff6c6753fb883a0,
    0x3ff5846d0ba43fba, 0x3fe78a7ec5f4ef0f,
    0xbfe4afd77e6c8ba2, 0x3fd9b971c652faf6,
    0xc0003ad9cf8c3ed8, 0x40121e3d52499abb,
    0xbfd19ae7df5a0f44, 0x3fddc5a0be516012,
    0x3fe286dcc43b7f51, 0x3fd9d1c20564b21a,
    0xbff1e7ef1d6aa05c, 0xbfc2a991b8c3b4e1,
    0x3fe41bdc3e4fd0c6, 0x3fff3f775cd8c0d8,
    0xbfdcd703d18be460, 0x3fe98de1f7714757,
    0xbff37ce549663deb, 0xbff7592892d6f7f8,
    0xbff5041cea1c10e0, 0xbfbc18637dce6378,
    0x4005151f518ca117, 0x3fc1901f08325380,
    0x40008234c7b27039, 0xbfd7b0dbbfa84489,
    0xbff599f615f3541f, 0xbff97e9aa57350b9,
    0xbffda580632ef6ef, 0x3ff9c9329046afc9,
    0xbff26e9eea5680f6, 0xbff55a65b3de1a7a,
    0xbfe9db87d0055723, 0x4000f3c0437d8c18,
    0x3fd63178bcb21128, 0xbf835267b284db00,
    0x3ffbada9b411ce26, 0x3fe630412cbfa77c,
    0xc000ddd6fb574c16, 0x3fd6becabaa2a1b2,
    0x3ff49767a701f759, 0xc0003be88a6f55ef,
    0x3fe9656dc4e1a181, 0xbfe101ff8f3dd6ac,
    0x3fe4f839cb6c9312, 0x3fef5fa361245578,
    0x3ffa3dedf8244af4, 0xc003ae0681204360,
    0xbfe796ebc3021fc3, 0xbff609936c2a122e,
    0x3fda856675e9921a, 0x3ff9898379dba677,
    0xbff77fea4b068051, 0xbfe07942e86a23f6,
    0xbff020b3ceaa393d, 0xbfdf71baf89279cf,
    0xc0001cc7a2dcb94a, 0x3fe999eda065e398,
    0x3fc56d245f2a5888, 0x3ff52bffd6d98fc6,
    0x3fd5a3bc71afd2e2, 0xc006bd35de480b84,
    0xbfe0cd605699753f, 0xbfebb6d2abbc1894,
    0xbfdc650091f30ec7, 0x3fe90c54439c03a7,
    0x3ff0ffee1ede0900, 0xbff86efa061b8134,
    0xbfd5c49c8a7a1c76, 0xbfd587166c701424,
    0x3fc4ea3371470568, 0x3fdd29565055532a,
    0xbfd4d8ceca5265e8, 0x3fe17120ad445866,
    0x400710fdc783c375, 0xbfdc4ba182f0b45a,
    0xbfeaa8433c5b6568, 0x3fc665309df3f048,
    0x3fcf9da5feb073de, 0x400074912b58daef,
    0xbff1556c7a0f6ed3, 0xbfebc15246a967f8,
    0x3fea25fdda3dbefe, 0x3feb0cf8f7574e2b,
    0xbfd8dd6845a81fd4, 0xbff98c1f1c208d5d,
    0xbff5c0c624da994c, 0x400c56298231f2b8,
    0xbff0c06bab03422e, 0xc0010dd9625b7a56,
    0x3feafdb9f92a7ecf, 0x3fb02da65d9e7980,
    0x3fedb58195bf4856, 0xbfd87f1f357d4763,
    0x3ff18e0715b659cc, 0x3fe5877b802c9828,
    0x3ff076da4a0f9e85, 0x3feea09126bf2a75,
    0xc000398fae5c5deb, 0x3ff6c98fdddc83cd,
    0x3f83e48087bd9520, 0xbfe04e8e6ebe9179,
    0x3fd69da853e80c58, 0xbfee9cd995d12da3,
    0xc0010ab1ea14998d, 0xbfb639d06bfb5312,
    0x3fc379d5198dfd04, 0x3fe752c22ea142d2,
    0xbff04bf13b854a1c, 0xbfed6051817e2d6b,
    0xbfe822e9c83269d3, 0xbfd77efb71220c14,
    0x4000dbb02d84c5ec, 0x3fe414736f39fbb2,
    0x3ff70ac5c6b06878, 0xbf8cfb8de6e97220,
    0x3ff15ea08709b8a8, 0x3fe1ae55a340ea88,
    0x3fef6d9ac74e67ff, 0x3fe80b961e316eb8,
    0x3fd9df8ed55d293e, 0x3fe0f751d269078e,
    0x40005968f2ae1840, 0x3fce34256992fcd4,
    0x3fc2f06e3c059124, 0xbff9a898035c0b60,
    0x3fd60220ef68e54a, 0x40014ebcc09637b6,
    0xbfb9f3b2fa8168b0, 0xbff2134443829df8,
    0x3ffaf51e5174ce72, 0x3feb52fd57b048ec,
    0x3fe2dac611fdc6cc, 0xbfd248cc16aaaabc,
    0xbfd40e0eb9f5e670, 0x3ff777e5fe28390e,
    0xbffcf3fa5674fb44, 0x3fd270a14343f6b5,
    0xbff957307fe90271, 0x3fdf603742226d9c,
    0x3ff8bf195a74cb76, 0xbfca9448fd4f4658,
    0xbfc90c22ef0d09a4, 0x3fbfc95e20304678,
    0x3ff50bdd51138f24, 0x3fe5d567cfe67cf1,
    0x3ff667fa0a12ed88, 0x3fe77ddf7fb953b6,
    0xbffec3d92e146886, 0xbfbe0d30fbd95c60,
    0xbfda13a11088a4b0, 0xbfd980516a84004e,
    0xbff9d2bc2462bee5, 0xbff874e553da40c8,
    0x3facb000f8353de8, 0xbfcecfc0a4b50115,
    0xbfefaf0a3e9a1ae0, 0xbfeb64c0b707174b,
    0x3f8d6bf8f359cc80, 0xbfe0b9edd9b8c4ef,
    0x3fd8b748baeadf15, 0x3fed4d9f2ba4ed60,
    0xbff13227cd94b465, 0xbfcb25263383b400,
    0xbff1448afc38448f, 0x3fe08bc7411c1f1e,
    0x3fe19ef1bd921174, 0xbfd7f3ba0239eed4,
    0x3fe0b39e4d5c952f, 0x3fd84a2036d6fa12,
    0xbff5ebf084a69978, 0x3ffa370e07eddaa6,
    0xbfee7ca7d6194ad4, 0x3fd1a374139f53d4,
    0x3fdc459cbe5c2ed2, 0x3fc2a8bc5f3c0770,
    0x3fb3e102cd581b90, 0x3ff14d32b1c83fcf,
    0xbff27a405155344e, 0xbfec972ac7b50cb9,
    0xbfe921eb6d4e4036, 0x3fbcebb0a5f517e8,
    0x3ff59397b828d7dc, 0xbf74bf21a971b740,
    0xbfe9f9a1203ed887, 0xbff27abf7afbba8b,
    0xbfea1864e3acbbce, 0x3fd061cb70d5529a,
    0xbfc5364e65769a7c, 0xbfef0120b96776d4,
    0xbfe5fa3b699a0ef2, 0xbfd76c6a5a422dea,
    0x3fe678303013f9f4, 0xbfec3aa826baee06,
    0x4006ff0a2e4bdc7f, 0xbff4d1e0ec7340fa,
    0xbfc51b263e469aa4, 0xbffe773efc63b110,
    0x3fe8748e596c4c4a, 0x3fe08169c9e33c8b,
    0x3fe9fc5f94728f3e, 0xbfef5b8590bdd2f8,
    0x3ff4372e50f4f47f, 0xbfe3a7b4175e0d93,
    0xbf7c3ccf49c46200, 0x3ff6904cd8d89d8f,
    0x3fe3c668eb184e7b, 0xbfd6bbdca847611c,
    0xbfd7b03c5ad3cc5a, 0xbfd31980c3a3d09c,
    0x3fed7c5e3e6c936c, 0xbfe88bb0abdf2b1d,
    0xc0002f17c79d55fa, 0x400018ea1b890b98,
    0x400776c5825cb4c4, 0x3ff0f3e389e45e9b,
    0x3fddacdf1d586996, 0xbf87f54c078bc5a0,
    0xbff8719f1e9c0244, 0xbffa7843653f6e7a,
    0xbff43115bc4fca01, 0x3fd3a2dc8a6b34ae,
    0x3fc8ce9b51152998, 0xbfb3002040002d40,
    0x3ff33ada0eeb6d1c, 0x40767d785499e3b0,
    0x40051270612dc0cb, 0x3ff13a528ac89160,
    0xbfc509e56b476726, 0xbfd1a972c42e02df,
    0x3ffb4357a302117e, 0xbff5e70ee1455868,
    0xbfed912d46eb837c, 0xbfc77989e1ddc53e,
    0x3fac356693c57170, 0xbff15d18a9518f6b,
    0xbfdba56d11aea2dd, 0xbf96e440d7fecef0,
    0x3fd75ea6f6918df0, 0xc005cc65752ac38c,
    0xbfc54dc188baea07, 0xbffb46fd9f263646,
    0x3fd6bd4f965af770, 0x3fc606caa14315d8,
    0xbfa27663da35ac20, 0x3fff039f828347e7,
    0x3fc48e48985ff920, 0x3fd1ad73eda6c434,
    0x3feb7fe7bd028025, 0xbfa124ac1e5eeeab,
    0x3fdf2dab2c51c700, 0xbff5cd3d971e929c,
    0x40026d2c9f0b2d92, 0x3fead873b4b21bdc,
    0x3fe39ed239e44c92, 0xbfc0ee454ebe5968,
    0xbfe89a8e6b23e9c8, 0x3fe1e80ec74c1afa,
    0xbfe7edecc831811e, 0xbff26540c213dd98,
    0x3ff24a06e1ca4266, 0xbff0c904a4f07299,
    0xbff31559b29ae76a, 0xbfc13e1aa43a14cc,
    0x3fed14f0e9bfef3a, 0x3fea15deea65a168,
    0x3fbfd5e940620fd8, 0xbfe2613e25badc58,
    0x3ffaac38007e3697, 0x3fd4be2addffb645,
    0x3fe7b77f75958505, 0xbfb738f255b5fe8c,
    0xbfd05f285fcbb692, 0x3ff28deef375731f,
    0x3fee4070ea724630, 0xbfddadfabec79508,
    0x3ff1466d78ad6b9a, 0x3fe6d1c4a1c1bba6,
    0xbfe895e438c36f60, 0x3fefd8c85566f2bb,
    0xbfd50d9b3eba3480, 0xbfe868e4535a7d46,
    0x3fed13aded83d06a, 0x4006f30eb5646aec,
    0xbfc53b1dadc0a5be, 0x3fe2892d50e668fd,
    0xbfe8adfb9b930015, 0xbfc90b16fd5d57c3,
    0x3ff25433b44a9e7a, 0x3fe2e03b4bf69e26,
    0x3ff8e84bb082e3a0, 0xbff3be6087a01b30,
    0x3fe13c0a403114b2, 0x400466cf67997891,
    0xbff6ee879d959287, 0x3ff7605212767ca0,
    0x3fa9fd4d8b5a5048, 0x3fec779b317fa410,
    0xc000e20283102fa0, 0x3feb4fa0735d90ba,
    0x3fec711372d3f8ce, 0x3fcdea963e33261c,
    0xbff5402d0054a25a, 0x3fd9f39f81b93550,
    0x3fe796c4fd9300d3, 0xbff25b94aa7d2080,
    0xbfd78409f101d948, 0xbfc7bf6132ffb5ac,
    0xbfd6646f7ef145d1, 0xbfe001c75362352a,
    0xbfcd29eb16f63140, 0xbfd989bd79dc90f6,
    0xbfeb6f2c5feceb88, 0xbfeaeb650133a68c,
    0x3fefb53b6d480d2a, 0xbfd11df3993b91b0,
    0xbfd5dd186f3e4f13, 0xbfe6f73cdc87663c,
    0xbfd4887911432c1a, 0xbfcc72f8d9d9850a,
    0xbfd012776ed4966c, 0x3ff3f5bb44bbcb7f,
    0xbfce951adb8de180, 0x3f46170f234cc500,
    0x4000bd5d354c96d5, 0xc000c90e71892832,
    0xbff1a58ae0119218, 0x3fe05afa2cd61118,
    0xbfc5ae4dcbc23412, 0x3fd8134058a643e3,
    0x3fe9e54d2f2f0ee6, 0x3febc498dd09fedf,
    0xbfd1ea3a3c6391a6, 0xbfc3d8077be08b0c,
    0x3ff0bca4c7cad4a5, 0x3febbb8425f17f79,
    0x3fe877e5b959a444, 0xbff3dd41ed561b6e,
    0x3fa9232217d16630, 0xbfca971bb0d64798,
    0xbfdf3ef9e321a37a, 0x3ff2e4c25e8aa774,
    0xbfd5fe3283eb2ffd, 0x400495636ff0a759,
    0x3fec276b3cedae76, 0x3fe1c583c98aeb05,
    0x3ff0f862d3f477b0, 0xbfc2894f5350f9f8,
    0xc00181f86d7ae05f, 0xc004292c76dd0239,
    0xbfe48e83eec865ef, 0x3fc62b9185bd5fce,
    0xc002e71424472b04, 0x3fd9f5df250fd1d4,
    0xbf7110eb74a7c400, 0xbfab20b20ab6df70,
    0xc00380b42ceeeb58, 0x3fdf08d884173ae4,
    0xbfb0def23c8cff28, 0xbf83a5d7a71557c0,
    0xbfe35e582c2dfe58, 0xbfa7a15ef9a1a860,
    0x3fc13d2b485281c0, 0xbfe8323c66265760,
    0x3fea2101ba55c4ce, 0xbff22724da5c9efc,
    0x3feaafd60cde35d1, 0x3fdff0c252efa5f3,
    0xbfe5226c22544011, 0xbfd87f9cc81e2bcb,
    0x4004da2396d78df4, 0xbff39d1207bb6f1c,
    0xbffdb89764f7d73e, 0x3fefbe3c952a8cb7,
    0x3ff38d3375226bc6, 0x3fef1a3c6568a411,
    0x3fd888b45d8527f4, 0x3fc2b54bfc4e7748,
    0x3fee3a82ce8f3ff3, 0x3fe7965c3ea1fd5d,
    0x3fe930aa5c30eb5f, 0xbff76c9d3f9e021e,
    0x3fb8733046da7ce4, 0xbfb7331f6b359360,
    0x3fdd0311e242989f, 0xbff7cb2cc02c3bfe,
    0xbfc89f30dea62418, 0xbff99930af692474,
    0xbff7010866f6f3e6, 0x3fd5fa4f61a60764,
    0x3fec1460273207b8, 0x3ff94039c2f5f40a,
    0xbff62d9010869306, 0xbfc357a55c4ebc9a,
    0xc006e7e43640505e, 0xbffbf342c20e43e8,
    0x3fecee54f46534e2, 0xbfc13af7977ac6c4,
    0xbfe503609f2e05ae, 0x3fbddca0e824cc14,
    0x3ff22ff2867f7d21, 0xbf9b13e5257cae20,
    0x3fea67a7f0bcebc3, 0xbfd360aec40b3a77,
    0xbfda0f318755a62b, 0xbfd65ebe5c7e2d8a,
    0xbfdddfc0d61dec7c, 0x3f9b8637316b4220,
    0x3fd314db927e8cb5, 0x3ff2984d780c599a,
    0xbff2bc72fa47c5b2, 0x3fe02c89ae6d6480,
    0x3fda3b0b39616efe, 0x3ff2a3270f7ecf9a,
    0xbff4917c7e36883d, 0xbff95cbbc12332d0,
    0x3ff3ce1282a84730, 0xbfa0e5c4ab0fb35c,
    0xbff4ea94117508c2, 0x3ff215dcc732ecab,
    0xbfe2fa25558e5bbb, 0x3ffaa6c0fd3825c0,
    0x3ff09f0327769f4e, 0x3ffaa50b1bfb09eb,
    0x3fe82c7c6f16ceee, 0x400404067f8d405f,
    0x3ff0ca3b447ba090, 0xbfde631068add90c,
    0xbfd609751e00fe2c, 0xbff2c7f9bf68a2f1,
    0x3ff1b2dc01b216e5, 0xbfd363baa62eaf80,
    0x4000549b72e2502d, 0x3fde93bc9faa8bfe,
    0x3fc9ca9593f1f1f8, 0xbff4023da20bd6ba,
    0xbfeb32f0a6a65554, 0xbfee0a64aa2e9fee,
    0xbff9f4a68e97065c, 0x3fd2a30e5c427e3a,
    0xbff1e6255e2a24b4, 0xbfee5dd0b535fd6a,
    0xc008d438ce350004, 0xbfeafc7fb910a917,
    0x3fe851f5b38903d4, 0x3fdd666fe3d2a242,
    0x3fdcac163f7d7f69, 0x3fcd79da06ed5338,
    0x3fce9f5a7c6873a8, 0xbff022a528419f6e,
    0x3ff48b93a633d037, 0x3ff47a83ee98a9aa,
    0x3ff1d0afb2a30dec, 0xc0033af0b208c024,
    0x3ff72c73ed072472, 0x3fc1c26cbf1b1dc2,
    0x4000ad4d03ec1a6d, 0xbff6d94661d936e7,
    0xbfe7e4f261dcb92a, 0x3ff8be348d0f49a9,
    0x3f85fb57509c3a20, 0xbfe9fb05092d9da4,
    0xbff6c6a25c494352, 0x3fcba45b3a1d0dca,
    0x400198e1e38e1b3e, 0x3fc0da9818fe4a98,
    0x3fbb7b0bc7a133b0, 0xbfd3cebb3a1d45a0,
    0x3ffbc3c6708e4496, 0x3feb48e891660ba2,
    0x3f64534ec8384280, 0x3ffd7806ca4ff68f,
    0x3ff296e6bb6e1f3a, 0xbff99adfcacc65e1,
    0xbfd8f1a95ee05828, 0x3ff13aafca665fb3,
    0xc000daeec11c5e54, 0x3fd42fa31eb0a382,
    0xbfea82fed3716baa, 0xbfef1f478d668677
    };

static const uint64_t in_cfft_noisy_2048[4096] = {
    0xbfa278cab7fab10f, 0x0,
    0x3fe0947fb524e79a, 0x0,
    0x3fe67eb4b4883cf2, 0x0,
    0x3fddfa1669a503bb, 0x0,
    0xbfb39a02aa8458f2, 0x0,
    0xbfdd4b27fe7bbe1e, 0x0,
    0xbfe71500997fa070, 0x0,
    0xbfdce377126b4094, 0x0,
    0xbf9591571a65c747, 0x0,
    0x3fe3b636996f0644, 0x0,
    0x3fe5f8d360a4dd68, 0x0,
    0x3fddeb72d9aa3413, 0x0,
    0x3fa23872742032ea, 0x0,
    0xbfde129e5472d752, 0x0,
    0xbfe6adf8afaff824, 0x0,
    0xbfe01e947a739aa9, 0x0,
    0xbfaa87df9acf7890, 0x0,
    0x3fd822ca46315b5e, 0x0,
    0x3fe5a49e7faac35f, 0x0,
    0x3fdf59e5f967d7e9, 0x0,
    0x3fa629aa854a14c3, 0x0,
    0xbfe02c0af7e91018, 0x0,
    0xbfe701263e5fc16b, 0x0,
    0xbfe02608fa157812, 0x0,
    0xbfc08ae6006362d2, 0x0,
    0x3fe146e138d0093e, 0x0,
    0x3fe97fe72c6290cc, 0x0,
    0x3fe0133d44fb66e9, 0x0,
    0x3faf861a260a1375, 0x0,
    0xbfde94e4d6f8ddb8, 0x0,
    0xbfe58332f5add071, 0x0,
    0xbfdd866e02847b85, 0x0,
    0x3f931d76023ba2e4, 0x0,
    0x3fddd8ba6eef2a73, 0x0,
    0x3fdf6827fa68c3e2, 0x0,
    0x3fe139d71107f047, 0x0,
    0x3f9aa29c933fdf10, 0x0,
    0xbfd945114eb30018, 0x0,
    0xbfe6ffbbaddfdb1d, 0x0,
    0xbfdfb813b08b3683, 0x0,
    0xbfad18d9d45f7794, 0x0,
    0x3fe09fa39bd27a31, 0x0,
    0x3fe2cf360f16a4e3, 0x0,
    0x3fde59a90ee8e99f, 0x0,
    0x3fa9c470a5e88d7b, 0x0,
    0xbfddec86591e4843, 0x0,
    0xbfe77257ff1632ea, 0x0,
    0xbfdd0b70670c65eb, 0x0,
    0xbfaaafc7fbc40e68, 0x0,
    0x3fe153be663ffc30, 0x0,
    0x3fe68d673ead4913, 0x0,
    0x3fdd57f1177a116f, 0x0,
    0xbf9ed95c722bfa41, 0x0,
    0xbfe1ae51bd6731d4, 0x0,
    0xbfe54035c99cf061, 0x0,
    0xbfe0a4999fcd5c4e, 0x0,
    0x3fa35a9836d92c38, 0x0,
    0x3fe06854333e6311, 0x0,
    0x3fe746a0c4d8ebd5, 0x0,
    0x3fdd62020cbb70b2, 0x0,
    0xbf9867ffaa34a2e7, 0x0,
    0xbfe1d259c9096b09, 0x0,
    0xbfe59071cd465394, 0x0,
    0xbfdfe3bcc47e6e04, 0x0,
    0x3fa97b6b61524b5b, 0x0,
    0x3fe1adc698e97bda, 0x0,
    0x3fe5089eeffae22c, 0x0,
    0x3fe147fc18d00295, 0x0,
    0xbfad769f4f305c09, 0x0,
    0xbfe1b3638cb89422, 0x0,
    0xbfe6f635a68c91a4, 0x0,
    0xbfdbf743e62f3444, 0x0,
    0x3fab01f3b2fa0bec, 0x0,
    0x3fda30753da5fc72, 0x0,
    0x3fe57e6e6a2415bc, 0x0,
    0x3fe032b052d86f92, 0x0,
    0xbf54cdaeef576357, 0x0,
    0xbfde9ac85e870c87, 0x0,
    0xbfe7209a5900ca22, 0x0,
    0xbfdb08fa9af978d6, 0x0,
    0xbfa20bd423f4bcf0, 0x0,
    0x3fe07341c94e3032, 0x0,
    0x3fe540ef4d6c42ce, 0x0,
    0x3fdceea3bd28bfbe, 0x0,
    0xbf9cf0fa547a78f3, 0x0,
    0xbfe1c9a9819d36ab, 0x0,
    0xbfe71f558f66e3dc, 0x0,
    0xbfdfb37140e184ae, 0x0,
    0xbf9ad84cc43f06f3, 0x0,
    0x3fe2ae12b72b00d0, 0x0,
    0x3fe645ae9a0faa55, 0x0,
    0x3fdd6bd3e3f64575, 0x0,
    0x3fb3f9f12d9b7a88, 0x0,
    0xbfe1247833f50cbf, 0x0,
    0xbfe7341d52f24dac, 0x0,
    0xbfe0abd05756b3d5, 0x0,
    0x3f9454ad57ad3a3c, 0x0,
    0x3fdfa5440ca84514, 0x0,
    0x3fe4bf5a01d5e42b, 0x0,
    0x3fdb809c14745aac, 0x0,
    0xbfa4f435b394d67c, 0x0,
    0xbfdfa304d7dd7e0d, 0x0,
    0xbfe7a112dedb8716, 0x0,
    0xbfdeeda2bc4ab481, 0x0,
    0xbfb222cec659cff7, 0x0,
    0x3fdca1072a3edb0b, 0x0,
    0x3fe5e7a94555899b, 0x0,
    0x3fe1d00b7379ec59, 0x0,
    0xbf9ab97db8bd7c0d, 0x0,
    0xbfdc1881023b5334, 0x0,
    0xbfe57a6f99733268, 0x0,
    0xbfe0196d17a7bb3c, 0x0,
    0x3f77dc937b3f94fe, 0x0,
    0x3fdc0973f67321b0, 0x0,
    0x3fe7a1a7d1e2a81a, 0x0,
    0x3fe22787f0d2b33c, 0x0,
    0xbf981b6623e89f1c, 0x0,
    0xbfe0c14d40b25bc9, 0x0,
    0xbfead051403a43c3, 0x0,
    0xbfe1f20573e0af42, 0x0,
    0x3fb0f45385e032a7, 0x0,
    0x3fe1f475c04c7614, 0x0,
    0x3fe2eca23e45e123, 0x0,
    0x3fdd505f6b66b9b1, 0x0,
    0x3fa0213faea2c8cc, 0x0,
    0xbfdd3e9015aa1f69, 0x0,
    0xbfe8f9c27c5d36f9, 0x0,
    0xbfe281221a22a94b, 0x0,
    0xbfa3cd8ab5d7b8a7, 0x0,
    0x3fe1b6be4da5c434, 0x0,
    0x3fe7af63915ebace, 0x0,
    0x3fe14dcb65ad65a2, 0x0,
    0xbf85cfec3dbffaa9, 0x0,
    0xbfe1befd71f94d6e, 0x0,
    0xbfe770c36b11b73f, 0x0,
    0xbfe14d40d2ee4042, 0x0,
    0x3faa796c992895c6, 0x0,
    0x3fdf8c2fd6544da7, 0x0,
    0x3fe7f8310a5e5607, 0x0,
    0x3fe00cc24e1d94cf, 0x0,
    0x3fa29b813a258c2c, 0x0,
    0xbfdf216a4bf30b80, 0x0,
    0xbfe6970040e2217a, 0x0,
    0xbfdfd77c2e07253c, 0x0,
    0x3f97076f7e5de7e8, 0x0,
    0x3fe0dba592217e2f, 0x0,
    0x3fe942664efcab1d, 0x0,
    0x3fde5d8c9c8052a3, 0x0,
    0xbf82d4c7efce62c5, 0x0,
    0xbfe26f22640845f8, 0x0,
    0xbfe8f71ff1ef1ea9, 0x0,
    0xbfdabab5808cd5e5, 0x0,
    0xbf97da31b927c7b3, 0x0,
    0x3fda8e074aad2aaf, 0x0,
    0x3fe7639cd57d7f9d, 0x0,
    0x3fe2943fb99ab0b7, 0x0,
    0x3fc1179eb39e5512, 0x0,
    0xbfe152a0a38cee1c, 0x0,
    0xbfe88aa5d38d9553, 0x0,
    0xbfe13709f1e1e3c8, 0x0,
    0x3fb4f9f8c340a1c0, 0x0,
    0x3fdce62282ecaeab, 0x0,
    0x3fe7d45f9714368e, 0x0,
    0x3fe2400aff178575, 0x0,
    0x3f95e0782f6213d7, 0x0,
    0xbfdfdd874cc7585d, 0x0,
    0xbfe6b8a47a9647b0, 0x0,
    0xbfdf2a936486c732, 0x0,
    0x3f96d76adee46018, 0x0,
    0x3fe08c55c1386eeb, 0x0,
    0x3fe63d051249f5e5, 0x0,
    0x3fdc2c690be46461, 0x0,
    0xbfaa15332922e522, 0x0,
    0xbfe0fc3c56800546, 0x0,
    0xbfe69cc094c2a5e5, 0x0,
    0xbfe1a3f2a82a1ee2, 0x0,
    0xbf9eb1b934b609a6, 0x0,
    0x3fdf23ffdb2b1404, 0x0,
    0x3fe8d13ee9867f94, 0x0,
    0x3fdc39d031d54274, 0x0,
    0x3fa3fcd38e6b8402, 0x0,
    0xbfdccf22f9b471a6, 0x0,
    0xbfe4f323be56ec0c, 0x0,
    0xbfe2063d69d65210, 0x0,
    0xbf6b95213dc4b93a, 0x0,
    0x3fdfb6f6addbc84d, 0x0,
    0x3fe842ab96bc5eca, 0x0,
    0x3fdc4f039647d6b2, 0x0,
    0xbfa83c7dea866bca, 0x0,
    0xbfe258b4bd089fb7, 0x0,
    0xbfe614e5e8676b04, 0x0,
    0xbfdfec01e4f45f2b, 0x0,
    0xbf6df6cd534e7aff, 0x0,
    0x3fe063a88e2fb9c9, 0x0,
    0x3fe6c5150a246d48, 0x0,
    0x3fdf5b22db835c5c, 0x0,
    0xbf908ea889cf8afa, 0x0,
    0xbfe10e0a4797e94f, 0x0,
    0xbfe4a81b535d72bd, 0x0,
    0xbfdf19c4977fd309, 0x0,
    0x3f9470c71d663b32, 0x0,
    0x3fe114fa3d531726, 0x0,
    0x3fe51afbfc233d2c, 0x0,
    0x3fe10ff3409d91ad, 0x0,
    0x3fb03289b575229f, 0x0,
    0xbfe0c486b870cbff, 0x0,
    0xbfe4efa996d1cb08, 0x0,
    0xbfdc8eb22921b2e7, 0x0,
    0x3faa7128aa4cdc2f, 0x0,
    0x3fe1074b30bf91b9, 0x0,
    0x3fe7d82c2b9f6017, 0x0,
    0x3fe17b3127e231d6, 0x0,
    0x3fa50393c0810b0c, 0x0,
    0xbfde13534590aa0c, 0x0,
    0xbfe4cc6f7db710af, 0x0,
    0xbfe0c2c7b9eca2c7, 0x0,
    0x3fa18a013a688c6e, 0x0,
    0x3fde36a4a526d6a4, 0x0,
    0x3fe4a4158aa6776e, 0x0,
    0x3fdfa01d223f41bc, 0x0,
    0xbfa36c4152de2e0e, 0x0,
    0xbfdeae3b2dafcb3b, 0x0,
    0xbfe9fc5732bf3146, 0x0,
    0xbfdd4d7cf1d22115, 0x0,
    0x3f6808d30547cccf, 0x0,
    0x3fdf1bfc8083b4da, 0x0,
    0x3fe6c71c608cf173, 0x0,
    0x3fdc92a4581a4091, 0x0,
    0xbf9d35e40bdfa0e9, 0x0,
    0xbfd9e4680620afc3, 0x0,
    0xbfe561ab6cfff9ed, 0x0,
    0xbfe02baf080505c9, 0x0,
    0xbfa6abc995a0d9cd, 0x0,
    0x3fe16d7dd5dd9bbd, 0x0,
    0x3fe4611d24f8a2ef, 0x0,
    0x3fddb0cf7f3a7807, 0x0,
    0xbf74f807ffe6e4a5, 0x0,
    0xbfda0316947fd97d, 0x0,
    0xbfe5267074e99ca9, 0x0,
    0xbfe2b0b74d99d62e, 0x0,
    0xbf73a27189e7cb3b, 0x0,
    0x3fe12ce6ea3642b3, 0x0,
    0x3fe529a1eb032910, 0x0,
    0x3fe106ea1106e874, 0x0,
    0xbf950a98199530df, 0x0,
    0xbfdc8466f47b005a, 0x0,
    0xbfe6c18dcc478822, 0x0,
    0xbfe2030d5bf557e1, 0x0,
    0x3f9acf3763f624d9, 0x0,
    0x3fdf1870b34aefaf, 0x0,
    0x3fe62f53619f7a78, 0x0,
    0x3fe2214661b93983, 0x0,
    0x3fa103a5663c6e78, 0x0,
    0xbfdca297e4c8f4e8, 0x0,
    0xbfe739799853ad3d, 0x0,
    0xbfde3f4cf86c7054, 0x0,
    0x3f84fb367a71c014, 0x0,
    0x3fdf3a1e34d04f87, 0x0,
    0x3fe769164e6d1d07, 0x0,
    0x3fe0d160753f3a29, 0x0,
    0x3f75753ec1896eba, 0x0,
    0xbfdc801c249f6ca0, 0x0,
    0xbfe5cf365a2354ea, 0x0,
    0xbfdf53bd16718bb8, 0x0,
    0x3f8794bfc3fe97cf, 0x0,
    0x3fdb94f55902349f, 0x0,
    0x3fe3d9f8165c0588, 0x0,
    0x3fe04e02312da6e4, 0x0,
    0x3f89670569a3c84a, 0x0,
    0xbfdecf6b8553f737, 0x0,
    0xbfe3bb8020527718, 0x0,
    0xbfdd9256d3ce458e, 0x0,
    0xbfa3428c27b2779e, 0x0,
    0x3fdfafd2bf806bc7, 0x0,
    0x3fe933da40d3d6c2, 0x0,
    0x3fe1a8e15706a8a4, 0x0,
    0xbfaab18dbc128704, 0x0,
    0xbfddd5f9a85a71a3, 0x0,
    0xbfe6903737b18910, 0x0,
    0xbfde27f9cde8c1d6, 0x0,
    0x3f9f2495b1493717, 0x0,
    0x3fe0561ee2854915, 0x0,
    0x3fe80c71d13ba668, 0x0,
    0x3fdfbd78fafa5041, 0x0,
    0xbfbb07b392d79b63, 0x0,
    0xbfdde6d01dfdd7ad, 0x0,
    0xbfe624af9656005d, 0x0,
    0xbfe14bab9499afb8, 0x0,
    0x3f987a9f4394bf7c, 0x0,
    0x3fde7bc4c65261e9, 0x0,
    0x3fe397b4515883d8, 0x0,
    0x3fe095763390b89e, 0x0,
    0x3f94bdc563b87d4e, 0x0,
    0xbfe021348d527258, 0x0,
    0xbfe635722f012db3, 0x0,
    0xbfe00cec23f4083e, 0x0,
    0xbfb193643d462452, 0x0,
    0x3fdcd02a37458b94, 0x0,
    0x3fe4dd627d3a56cc, 0x0,
    0x3fe05f5ad91b2e44, 0x0,
    0xbf96122b8ebe6094, 0x0,
    0xbfe2dbe7f1928e88, 0x0,
    0xbfe5c8a8608257ef, 0x0,
    0xbfdc2285d026580e, 0x0,
    0x3fadac3d13a61e43, 0x0,
    0x3fdded3358cba2ef, 0x0,
    0x3fe684aa03d0d218, 0x0,
    0x3fd7e6c7aa580ada, 0x0,
    0x3fb3b716b3a355e2, 0x0,
    0xbfdb090008a3d6de, 0x0,
    0xbfe7070b07612da2, 0x0,
    0xbfdffb884bbcd7f4, 0x0,
    0xbfa6fcfc2d3be016, 0x0,
    0x3fe08a7bb5a80b3d, 0x0,
    0x3fe7f6b1792847b9, 0x0,
    0x3fe13fa3cc550bf6, 0x0,
    0xbfb03259b2490111, 0x0,
    0xbfe14d3e33b489df, 0x0,
    0xbfe60c3373be978f, 0x0,
    0xbfde35d57bce0412, 0x0,
    0x3faab0e3cc57a286, 0x0,
    0x3fde21886cae7e74, 0x0,
    0x3fe658ab1c479458, 0x0,
    0x3fe15948bd4552c4, 0x0,
    0x3fa6af964f18ab9e, 0x0,
    0xbfe04832aefd3449, 0x0,
    0xbfe6ddb6032c0570, 0x0,
    0xbfdfd4eb603d1a7d, 0x0,
    0x3fb0a56dfc432f5f, 0x0,
    0x3fdcfb1f5ce1619b, 0x0,
    0x3fe69cdfa7ec8319, 0x0,
    0x3fe2a010ca6474e1, 0x0,
    0x3f800ef72e5c2c37, 0x0,
    0xbfe280a2bab20853, 0x0,
    0xbfe5873f158ee352, 0x0,
    0xbfda266c0d8e7bf1, 0x0,
    0xbfad4d4b43889a0c, 0x0,
    0x3fdeb7c44f3c40d2, 0x0,
    0x3fe4592f960a3c03, 0x0,
    0x3fe1b6fb1ac61934, 0x0,
    0xbfb24f33160a6491, 0x0,
    0xbfe05881d8c4bb2e, 0x0,
    0xbfe630a1098aca70, 0x0,
    0xbfe0df00b3c95b21, 0x0,
    0xbfa42f17b7292b34, 0x0,
    0x3fe0ed7f20ee4bd6, 0x0,
    0x3fe3ad40f8c7a10e, 0x0,
    0x3fe0e37e951e1897, 0x0,
    0x3f390efe51dd4301, 0x0,
    0xbfe0c33945567aa9, 0x0,
    0xbfe3f3df042fa3d0, 0x0,
    0xbfdf9c059c79f8c0, 0x0,
    0x3fa39d3c3322640e, 0x0,
    0x3fdd087ae29977da, 0x0,
    0x3fe46434b2b4acfc, 0x0,
    0x3fe2e579c011577a, 0x0,
    0x3f958ac45d9e3dcd, 0x0,
    0xbfe0ff52fe7a559d, 0x0,
    0xbfe6ec35195064b5, 0x0,
    0xbfe2ebeb1d082613, 0x0,
    0x3f8656ccdbec0489, 0x0,
    0x3fe19b9035d5a9b9, 0x0,
    0x3fe53a5ec0d624bb, 0x0,
    0x3fdd29e5889b2bee, 0x0,
    0xbfa8403023ab01ce, 0x0,
    0xbfe029d6acd585e1, 0x0,
    0xbfe9263633f6a186, 0x0,
    0xbfdfa54ee4d6f8e9, 0x0,
    0x3f9706f2522d94bc, 0x0,
    0x3fdffab0d505f95a, 0x0,
    0x3fe6e1155ac82851, 0x0,
    0x3fe1c2b5df65b2b5, 0x0,
    0x3fbebba2091db21c, 0x0,
    0xbfe157a930bdb948, 0x0,
    0xbfe619950d4d92d6, 0x0,
    0xbfe286ef67e32200, 0x0,
    0x3f921622b7b43985, 0x0,
    0x3fddd316aa0c8887, 0x0,
    0x3fe848cd6d27ada6, 0x0,
    0x3fdf86c0c539a173, 0x0,
    0xbfa53acbcd01d042, 0x0,
    0xbfde2fcca28d4b30, 0x0,
    0xbfe65b9a3f9c4e57, 0x0,
    0xbfddd7d991381c9d, 0x0,
    0x3fad8e3135ab6052, 0x0,
    0x3fdd426cdf42c022, 0x0,
    0x3fe72e249c178914, 0x0,
    0x3fdfa5393719d8dc, 0x0,
    0x3fa1a22dd65d2d55, 0x0,
    0xbfdb9df989253901, 0x0,
    0xbfe5de4e8aac56d6, 0x0,
    0xbfd8f47b6c7a1f38, 0x0,
    0x3f91eb232f436773, 0x0,
    0x3fdbf6c902abebac, 0x0,
    0x3fe4201ac84ff324, 0x0,
    0x3fdf24292baf4840, 0x0,
    0xbf79cc212ee965e5, 0x0,
    0xbfdd74f0f5f1019e, 0x0,
    0xbfe683ba5aebdf58, 0x0,
    0xbfe3cd961f7bab87, 0x0,
    0x3f82b14dcb15b657, 0x0,
    0x3fe0026b1ac9c86b, 0x0,
    0x3fe991259443170c, 0x0,
    0x3fe18a82a58f4149, 0x0,
    0x3fac67f43763d9f8, 0x0,
    0xbfe0db14761eebcf, 0x0,
    0xbfe8d3ee364665bd, 0x0,
    0xbfe23cb1e36b5f53, 0x0,
    0x3faf7ac207b4d103, 0x0,
    0x3fdd8d3f6e97af83, 0x0,
    0x3fe76dbe641f2ca0, 0x0,
    0x3fe02d2902948767, 0x0,
    0xbfab154d4a84de58, 0x0,
    0xbfdc1915a7d0eeab, 0x0,
    0xbfe5857234dc770e, 0x0,
    0xbfe209158b35a5e6, 0x0,
    0x3f902561743037d8, 0x0,
    0x3fdcfc9bdea8b150, 0x0,
    0x3fe6a1430e3626a0, 0x0,
    0x3fe265295d5039c6, 0x0,
    0xbfa2b7bc8faab6da, 0x0,
    0xbfde2c9b7d612337, 0x0,
    0xbfe87693c7b9e787, 0x0,
    0xbfe312f22b0233e4, 0x0,
    0xbfb4bb01c2ae3d04, 0x0,
    0x3fe005b73a5b633d, 0x0,
    0x3fe56a76e868840e, 0x0,
    0x3fe09811d0b27aae, 0x0,
    0x3f66846a255d427d, 0x0,
    0xbfe09b970bb6fd6b, 0x0,
    0xbfe73214054d7dc3, 0x0,
    0xbfdb29e36c7f66b1, 0x0,
    0x3fb3049180c6cf75, 0x0,
    0x3fe3040c1caab15f, 0x0,
    0x3fe56970f8cb9642, 0x0,
    0x3fe18a50a3a8d61c, 0x0,
    0x3fbef4381b55e57d, 0x0,
    0xbfdf5bee3528bf9f, 0x0,
    0xbfea000bd867078c, 0x0,
    0xbfe18ce8b027a408, 0x0,
    0x3f86227f7fa9d44f, 0x0,
    0x3fe3a47d4dffe8e8, 0x0,
    0x3fe4d34008b70319, 0x0,
    0x3fe00dfe031cb462, 0x0,
    0x3f9c1a8f94bf034c, 0x0,
    0xbfe05ab71171b2e7, 0x0,
    0xbfe5f910e924e373, 0x0,
    0xbfe235cb83a7bd19, 0x0,
    0xbfb106c819b5f1ac, 0x0,
    0x3fde0a210fa33996, 0x0,
    0x3fe5cebc9be06065, 0x0,
    0x3fe01cc8f83a4d32, 0x0,
    0x3fbc56e2f67f562e, 0x0,
    0xbfdfd4723f0c4a96, 0x0,
    0xbfe5f7046c39eb39, 0x0,
    0xbfd849842fc535a8, 0x0,
    0x3f93bf717fed5c19, 0x0,
    0x3fe1de23ee89f8e6, 0x0,
    0x3fe50b015d4a133e, 0x0,
    0x3fe0b0638d43cd43, 0x0,
    0xbf82566436fc54a1, 0x0,
    0xbfe127673f2ce23d, 0x0,
    0xbfe617a8622009b5, 0x0,
    0xbfe1e84843374d6d, 0x0,
    0x3fb5bec7ba1f264a, 0x0,
    0x3fe24aeb15b025ce, 0x0,
    0x3fe71d78e663d4e3, 0x0,
    0x3fe1859acf67ebea, 0x0,
    0x3fb173cdb6c63b5f, 0x0,
    0xbfdf79a14caa444e, 0x0,
    0xbfe6be7d91fca631, 0x0,
    0xbfe216f01ac0e3fe, 0x0,
    0x3f965e2676de3a80, 0x0,
    0x3fddd7c9e2ae83c2, 0x0,
    0x3fe450b1d19a4483, 0x0,
    0x3fe11718d7dd366a, 0x0,
    0xbf9cd45f9d4aea14, 0x0,
    0xbfdad5e3c226263f, 0x0,
    0xbfe6e3ee9c42d7b7, 0x0,
    0xbfdd0acd48cb85b6, 0x0,
    0xbf886e466a8f3a1e, 0x0,
    0x3fdca1943854883a, 0x0,
    0x3fe6ed8b903526a7, 0x0,
    0x3fdb43fae5f76fd7, 0x0,
    0x3f9c2c1b152d3f76, 0x0,
    0xbfdb0e262e8ef517, 0x0,
    0xbfe4cce1f88e902b, 0x0,
    0xbfe05636c4145c6e, 0x0,
    0x3fb18b73eba9b64d, 0x0,
    0x3fdc5106378e4b87, 0x0,
    0x3fe957a4260bedf6, 0x0,
    0x3fe079b66f415df8, 0x0,
    0x3f97be279e7fd31e, 0x0,
    0xbfe095e3c11c29d7, 0x0,
    0xbfe7ec0f947864fb, 0x0,
    0xbfe2e92116b8d611, 0x0,
    0xbfab79f6985d0308, 0x0,
    0x3fdbf4667c8d188e, 0x0,
    0x3fe8aa9fa7d72f51, 0x0,
    0x3fe07cc955eaa9f9, 0x0,
    0xbfa5ec3932012e6b, 0x0,
    0xbfddab43084f5834, 0x0,
    0xbfe51c75664dd10b, 0x0,
    0xbfe276fa18b302dd, 0x0,
    0x3f8c6fdd7cadd187, 0x0,
    0x3fe2db43eb11313b, 0x0,
    0x3fe54a22271e8dbd, 0x0,
    0x3fe1702f35c968df, 0x0,
    0xbfacbcc557487ad4, 0x0,
    0xbfda549caeceffa2, 0x0,
    0xbfe662ce2c2570db, 0x0,
    0xbfe2452c499f98b2, 0x0,
    0xbf9ed99ac308cd35, 0x0,
    0x3fdba2b9cbf096a2, 0x0,
    0x3fe422a4044d8b7f, 0x0,
    0x3fdcfa0a52829446, 0x0,
    0xbfa2bb5b3d7213cd, 0x0,
    0xbfe00d7800278494, 0x0,
    0xbfe6ed821fde990c, 0x0,
    0xbfdaaeeb641fa1d9, 0x0,
    0x3f8e5e03e1b626a8, 0x0,
    0x3fe0ae0c680521ed, 0x0,
    0x3fe6c9ef7f83c887, 0x0,
    0x3fe0e7708b0dfe89, 0x0,
    0xbf9dbceaa14d3ffc, 0x0,
    0xbfe0af6db996c66d, 0x0,
    0xbfe767448ff0f1d2, 0x0,
    0xbfdf9ac818d293aa, 0x0,
    0x3fa9c21f9b2f42f3, 0x0,
    0x3fe0191d26f4cc53, 0x0,
    0x3fe57ae4bb84ab26, 0x0,
    0x3fd853dd18080f4d, 0x0,
    0x3fa54fd075e16867, 0x0,
    0xbfde1bd90a135f3c, 0x0,
    0xbfe6860311abec2d, 0x0,
    0xbfde8911b3165278, 0x0,
    0xbf91412fc3a4723c, 0x0,
    0x3fd8b7bb2df90dba, 0x0,
    0x3fe6ea6a25d6e6c7, 0x0,
    0x3fe1a4cda37d720b, 0x0,
    0xbf876a9542366115, 0x0,
    0xbfdbb8d6705e7058, 0x0,
    0xbfe745aa9db8f69d, 0x0,
    0xbfe1c846fae14ff3, 0x0,
    0xbf84ac13231b096c, 0x0,
    0x3fe029a7e54fe1ec, 0x0,
    0x3fe4002da7035130, 0x0,
    0x3fe0cec0884700d5, 0x0,
    0xbfb60beeec1132d2, 0x0,
    0xbfe1094606ef5a7e, 0x0,
    0xbfe380ff721b57ad, 0x0,
    0xbfe09bec6387e936, 0x0,
    0xbfaf4dd38e2326bc, 0x0,
    0x3fe16846d9f6babb, 0x0,
    0x3fe55f688f14b9c0, 0x0,
    0x3fe26926cb92d330, 0x0,
    0xbf839a25d1d9cdf1, 0x0,
    0xbfe16fd7c52cf460, 0x0,
    0xbfe77c1a7ed64480, 0x0,
    0xbfe0899123ff33fc, 0x0,
    0xbf989d5dc7f597c4, 0x0,
    0x3fe14163dc9887ee, 0x0,
    0x3fe3b3b460054566, 0x0,
    0x3fdf8612fc2461b2, 0x0,
    0xbf90674386efab73, 0x0,
    0xbfdbcfb30d35501d, 0x0,
    0xbfe7ad42e194f721, 0x0,
    0xbfe1b79e534cd68c, 0x0,
    0xbf7d0ac22972753c, 0x0,
    0x3fe06311649f9800, 0x0,
    0x3fe70352f2223be4, 0x0,
    0x3fdde95233630905, 0x0,
    0xbfa30deb1ce1a454, 0x0,
    0xbfdcfdf88ab7cd29, 0x0,
    0xbfe6b4f3652618c1, 0x0,
    0xbfdd3bd4af1f2a80, 0x0,
    0xbf93750bdda4e302, 0x0,
    0x3fe13ec13cd3afed, 0x0,
    0x3fe7b58b0e678f79, 0x0,
    0x3fe0af927939de94, 0x0,
    0xbfa7c6b3cd207485, 0x0,
    0xbfe01391af894dad, 0x0,
    0xbfe8ac890824558c, 0x0,
    0xbfe0a81f2559aba8, 0x0,
    0xbf70a67c032011b0, 0x0,
    0x3fe0c1890b4664c9, 0x0,
    0x3fe3ed0b615f5365, 0x0,
    0x3fe131e6bc28373e, 0x0,
    0xbf96c79f646bdcd7, 0x0,
    0xbfe0878b4c941f9f, 0x0,
    0xbfe62b3dbcf57163, 0x0,
    0xbfdeecd6148084e3, 0x0,
    0xbfb2cd052802f413, 0x0,
    0x3fe1c15c9fe7a42e, 0x0,
    0x3fe3946ec37576ea, 0x0,
    0x3fe101d8c4944bec, 0x0,
    0xbfb3e95b0ad8f89e, 0x0,
    0xbfe014d241c54c82, 0x0,
    0xbfe635dbcf4726c2, 0x0,
    0xbfdf986621c403c5, 0x0,
    0x3f9c4ef86bc9aeb1, 0x0,
    0x3fe1ff77f2735044, 0x0,
    0x3fe642c3f6368e26, 0x0,
    0x3fe0478010333baf, 0x0,
    0x3f8e3fbb463f5fc3, 0x0,
    0xbfe10036920b1cdf, 0x0,
    0xbfe7828c7e7f05f6, 0x0,
    0xbfe1f1d4d1b8716b, 0x0,
    0xbfa1423e4eb2254c, 0x0,
    0x3fdfa1707af39519, 0x0,
    0x3fe84b80f85717e2, 0x0,
    0x3fe1722525d16aab, 0x0,
    0xbf8fd26349ea530b, 0x0,
    0xbfde27905e3b2f21, 0x0,
    0xbfe6099f759f272f, 0x0,
    0xbfdf69b769badf4e, 0x0,
    0x3f8418cc30b8199f, 0x0,
    0x3fe1b530f0a5798e, 0x0,
    0x3fe57aee45dcf8bc, 0x0,
    0x3fdfb4649d9b10cc, 0x0,
    0x3fbcf6c7e91f9845, 0x0,
    0xbfdd413188167a10, 0x0,
    0xbfe5e0a48889bb54, 0x0,
    0xbfe129885fb2868a, 0x0,
    0xbfb108fbbbc09c11, 0x0,
    0x3fe3bc680e586ec6, 0x0,
    0x3fe66b5f28f46cd5, 0x0,
    0x3fd5a297607b5f9e, 0x0,
    0x3fab41c13f815074, 0x0,
    0xbfe043ae63476838, 0x0,
    0xbfe45561cfb7c6f6, 0x0,
    0xbfdc51ad801c5897, 0x0,
    0xbf98a1cad061cbf6, 0x0,
    0x3fdbe00954ae5fe2, 0x0,
    0x3fe831e317c6c177, 0x0,
    0x3fe13958c09196b9, 0x0,
    0x3fa44af55eab6967, 0x0,
    0xbfdeced19fbe1378, 0x0,
    0xbfe56f4eb27556cf, 0x0,
    0xbfdfa72b2b261982, 0x0,
    0xbf849904904a9d53, 0x0,
    0x3fd6912e3c558fb8, 0x0,
    0x3fe3f20dc67487e5, 0x0,
    0x3fe0ccca04302d26, 0x0,
    0x3f91717033693c16, 0x0,
    0xbfdd8ef72c11a2f6, 0x0,
    0xbfe52d069a855658, 0x0,
    0xbfe08f574c7261bc, 0x0,
    0x3fbaceb836cb393c, 0x0,
    0x3fde40958141e245, 0x0,
    0x3fe9110bc0d1bc26, 0x0,
    0x3fdd5b441e38c345, 0x0,
    0xbf885e999f90983a, 0x0,
    0xbfdf40098f35fe63, 0x0,
    0xbfe65e896b6a8bba, 0x0,
    0xbfe10566ab239f25, 0x0,
    0xbf723d50aa2b8512, 0x0,
    0x3fe17260cf0720e8, 0x0,
    0x3fe46595958ddea5, 0x0,
    0x3fdd1a24b2fd9f94, 0x0,
    0x3f8d2cb7592726c6, 0x0,
    0xbfdfffccc5e26bc0, 0x0,
    0xbfe878b8e2dee7bf, 0x0,
    0xbfdcba06bbb716d2, 0x0,
    0xbfae0e774038df73, 0x0,
    0x3fdddd4984358f7f, 0x0,
    0x3fe71b26e57a7a53, 0x0,
    0x3fe16c9bd3154a8a, 0x0,
    0x3f3bbbafc4666c8b, 0x0,
    0xbfde6ef5b537c52f, 0x0,
    0xbfe68d1c25d4c3f4, 0x0,
    0xbfe120ee5bc5e2ad, 0x0,
    0xbfa7c667bcead7ad, 0x0,
    0x3fdfd0a224d93223, 0x0,
    0x3fe81fec5e51bcaa, 0x0,
    0x3fe29d488f6bc2e3, 0x0,
    0xbfb75a128e3ae9e5, 0x0,
    0xbfde90e4a0097464, 0x0,
    0xbfe3961870e9e3a2, 0x0,
    0xbfe26a73e73e5b86, 0x0,
    0x3fa117680cc8df7c, 0x0,
    0x3fdffe6e6124fef3, 0x0,
    0x3fe70c470cf51155, 0x0,
    0x3fdd1e89576cf54a, 0x0,
    0x3f912983a025eb51, 0x0,
    0xbfdb9bd775b64bdb, 0x0,
    0xbfe56b35f9135fa5, 0x0,
    0xbfe033943511d3c2, 0x0,
    0x3faef720f26be9db, 0x0,
    0x3fdc8e1213f42502, 0x0,
    0x3fe4d79a05f98018, 0x0,
    0x3fdfd922c7365fb7, 0x0,
    0x3fb8dee977e4b181, 0x0,
    0xbfe0aed8c09178b5, 0x0,
    0xbfe54f14766f4cd5, 0x0,
    0xbfe1400136d09eb4, 0x0,
    0x3fb39c97688a0889, 0x0,
    0x3fdf361a71cc3346, 0x0,
    0x3fe6d076a8cbf329, 0x0,
    0x3fda1a090fa9763b, 0x0,
    0xbf981d76c68b9de5, 0x0,
    0xbfdf0f2cc7f991c0, 0x0,
    0xbfe7d9200e5b6bd2, 0x0,
    0xbfdf3a56d47e15b0, 0x0,
    0x3fb9a11d608fb255, 0x0,
    0x3fde97f71dabbf1e, 0x0,
    0x3fe669a018341c1c, 0x0,
    0x3fe0ed4d818b2078, 0x0,
    0x3fa39100316f7a80, 0x0,
    0xbfde184aff57fd15, 0x0,
    0xbfe78e1ab8f64565, 0x0,
    0xbfdc484b8ebc37df, 0x0,
    0x3fa292015a3a9cbc, 0x0,
    0x3fe02db6e07629f1, 0x0,
    0x3fe86b0d1cf5cf13, 0x0,
    0x3fe069772eac6faf, 0x0,
    0xbf90f34592c6c798, 0x0,
    0xbfe073dc5eb8dfc3, 0x0,
    0xbfe6276b49728001, 0x0,
    0xbfded732643b0914, 0x0,
    0xbf8a58a712489fb8, 0x0,
    0x3fdebae4ba1533ec, 0x0,
    0x3fe6b0358e40c8de, 0x0,
    0x3fdf44fd3838af51, 0x0,
    0xbfa4656db074e7b2, 0x0,
    0xbfd9c40e7bd750ee, 0x0,
    0xbfe87004170f6c0f, 0x0,
    0xbfe167fe3974356b, 0x0,
    0xbf704d4ac174b073, 0x0,
    0x3fe15fcf3da475fd, 0x0,
    0x3fe651c123d51a93, 0x0,
    0x3fde65556ecf79dd, 0x0,
    0xbf79d024ce8bcdbd, 0x0,
    0xbfdf06527ddaa29b, 0x0,
    0xbfe619c393f08a85, 0x0,
    0xbfde21a355bd1202, 0x0,
    0x3f8a92eac27aba92, 0x0,
    0x3fe0956480bdfcca, 0x0,
    0x3fe5b5ab2f53098b, 0x0,
    0x3fdc903672eca5c3, 0x0,
    0x3fb0dbf6d61ac19a, 0x0,
    0xbfe0d23af3611836, 0x0,
    0xbfe4363589c08fad, 0x0,
    0xbfe0a6c1e215eb7d, 0x0,
    0x3f8c7eef07dbe181, 0x0,
    0x3fde8bdc4452102f, 0x0,
    0x3fe58b9e38e15342, 0x0,
    0x3fdc28fc9ccd1bb4, 0x0,
    0xbf8d9384ebd1a7f4, 0x0,
    0xbfdace0b446dd604, 0x0,
    0xbfe49b12623c0026, 0x0,
    0xbfdde01ba28a8423, 0x0,
    0xbfaf432a2d9e73da, 0x0,
    0x3fdfb0ee813876a4, 0x0,
    0x3fe7652e76260c3c, 0x0,
    0x3fdfad767ef2a062, 0x0,
    0x3f7142aa2ae55ccf, 0x0,
    0xbfd91db8beca8bcd, 0x0,
    0xbfe4cbba6e0c6d16, 0x0,
    0xbfda672ebc7cbb44, 0x0,
    0xbfab246eacfa0a72, 0x0,
    0x3fddf525aab5a67c, 0x0,
    0x3fe7c143757514a4, 0x0,
    0x3fdd3245083db447, 0x0,
    0xbf9911d4f4fcefe9, 0x0,
    0xbfe21ded07b1cbac, 0x0,
    0xbfe71690b779a91c, 0x0,
    0xbfe1df47e26f1468, 0x0,
    0xbf7f63426d3176cc, 0x0,
    0x3fe1cb5198c6d8f4, 0x0,
    0x3fe5934868a8cacc, 0x0,
    0x3fdf07b1fa7a8c6b, 0x0,
    0xbfb39df7265223a3, 0x0,
    0xbfded1e69357e807, 0x0,
    0xbfe71c41ee82b18a, 0x0,
    0xbfd757a0299aa08e, 0x0,
    0xbf954aeddea94e36, 0x0,
    0x3fe19f9065bb3f42, 0x0,
    0x3fe31267ebba56d8, 0x0,
    0x3fe0c2430bfa624a, 0x0,
    0xbfa0b29c4d4a99a3, 0x0,
    0xbfddd571b6a11bce, 0x0,
    0xbfe71219c2ed3d39, 0x0,
    0xbfe0bd13b77c6c22, 0x0,
    0xbf910a60496470bf, 0x0,
    0x3fe1d960462e4cd0, 0x0,
    0x3fe42671fe8ef3fa, 0x0,
    0x3fdf83faa4702014, 0x0,
    0xbf9c210f70ea64f6, 0x0,
    0xbfe01f44022bf4ef, 0x0,
    0xbfe9708bfb81b13b, 0x0,
    0xbfdfd9deebc18694, 0x0,
    0xbf785bff887a75dd, 0x0,
    0x3fdebbb648444480, 0x0,
    0x3fe6abab83780be1, 0x0,
    0x3fdd1b6381c2502b, 0x0,
    0x3fb2b3016977eb3d, 0x0,
    0xbfddc8292b447200, 0x0,
    0xbfe46b1c7fe9fb41, 0x0,
    0xbfe0690690e8d40a, 0x0,
    0xbfba409691d6dc9c, 0x0,
    0x3fda96b81539cf53, 0x0,
    0x3fe5a8080f2bba2b, 0x0,
    0x3fdf52ec8ef5a9ec, 0x0,
    0x3fb08bd68af7f9f4, 0x0,
    0xbfe0bf912c4cf2d1, 0x0,
    0xbfe572404bf980f6, 0x0,
    0xbfddabc34e42912d, 0x0,
    0xbfb2cf9e59eddc44, 0x0,
    0x3fdfa29bf0646bde, 0x0,
    0x3fe6b50c3e117bde, 0x0,
    0x3fdfc4c82a855e3d, 0x0,
    0xbfba6fa2afeeef74, 0x0,
    0xbfdf639781d31d8c, 0x0,
    0xbfe95b4bc522c57f, 0x0,
    0xbfe3313c64f89f12, 0x0,
    0x3fad17447d30690d, 0x0,
    0x3fdbc90d79b26f88, 0x0,
    0x3fe3ddeed72e6d6c, 0x0,
    0x3fe116f82f5ae2be, 0x0,
    0x3f9fa39d1edc3b57, 0x0,
    0xbfe029b1cab48ed8, 0x0,
    0xbfe5533aa7d326f0, 0x0,
    0xbfe0e25559229555, 0x0,
    0x3faaef945a8ea7e4, 0x0,
    0x3fe3e0ef474d9062, 0x0,
    0x3fe564acd78feca3, 0x0,
    0x3fdbdf8a0bdecbf4, 0x0,
    0xbf80bb9405d89986, 0x0,
    0xbfdc9eca6618df3e, 0x0,
    0xbfe5e1cf651d0f05, 0x0,
    0xbfde30d94e5e991b, 0x0,
    0xbfb8ab8e47664664, 0x0,
    0x3fda87cc13638a6d, 0x0,
    0x3fe738d1e784a28c, 0x0,
    0x3fdc5ff83450ff9b, 0x0,
    0xbf86b36f24145e25, 0x0,
    0xbfdd52ee389b94d6, 0x0,
    0xbfe52919af1fddf5, 0x0,
    0xbfdca70f3b4ebd28, 0x0,
    0xbf8983bda578a97c, 0x0,
    0x3fe03393f0a30bb3, 0x0,
    0x3fe592bb87992f32, 0x0,
    0x3fdcad7de0297c4b, 0x0,
    0xbfa65d8580753602, 0x0,
    0xbfe1617b406e9216, 0x0,
    0xbfe590ee5073e594, 0x0,
    0xbfe039f6d68b0222, 0x0,
    0xbfa771857847e2ba, 0x0,
    0x3fe025cf1f25f16d, 0x0,
    0x3fe5f9d3d0cbfcfa, 0x0,
    0x3fdeb4fded9feadb, 0x0,
    0xbf8d0575551d8959, 0x0,
    0xbfe04808954fc114, 0x0,
    0xbfe77861faec4687, 0x0,
    0xbfdd5975671c3868, 0x0,
    0xbf923c1d990e4f23, 0x0,
    0x3fe18302bef523eb, 0x0,
    0x3fe79f8dee6f52fc, 0x0,
    0x3fde1c0849ad0830, 0x0,
    0x3fb4d1d5080e8222, 0x0,
    0xbfde5467a9bde13e, 0x0,
    0xbfe77d6a86ee55df, 0x0,
    0xbfe2446754eb4715, 0x0,
    0x3fa341158e568174, 0x0,
    0x3fdeecbcb83f44c1, 0x0,
    0x3fe65306897224bb, 0x0,
    0x3fe238c957924232, 0x0,
    0xbf822fb4922aa215, 0x0,
    0xbfdbc7527093ae9e, 0x0,
    0xbfe32f1e700c2e2f, 0x0,
    0xbfddced91ecd715b, 0x0,
    0x3fa45020a7838fb5, 0x0,
    0x3fe4d9eafb3992b4, 0x0,
    0x3fe38987b790c7cb, 0x0,
    0x3fe0eee279e0cc14, 0x0,
    0x3fb1989341e936ec, 0x0,
    0xbfdf387f732c2e1b, 0x0,
    0xbfe5c883d4b35602, 0x0,
    0xbfe157fc08994da1, 0x0,
    0x3fa80f87c5072fd7, 0x0,
    0x3fde1b33ab2d136f, 0x0,
    0x3fe87f802dbd5c4f, 0x0,
    0x3fe19aea3ba27ea0, 0x0,
    0xbfb10b8436cadba7, 0x0,
    0xbfe12565608b9214, 0x0,
    0xbfe53ce707c00273, 0x0,
    0xbfde7c432e0c1526, 0x0,
    0x3f9d7c1ac58fe749, 0x0,
    0x3fe1116d1e43fbab, 0x0,
    0x3fe3e909beb9f30c, 0x0,
    0x3fddf4ed9922fd1a, 0x0,
    0x3faab670433087f8, 0x0,
    0xbfe153c8ffb2027a, 0x0,
    0xbfe6053ef7893986, 0x0,
    0xbfdb4b7e2a1a63c0, 0x0,
    0xbf303ab1e1b901f1, 0x0,
    0x3fdf06dc5f021114, 0x0,
    0x3fe5df67d6a01f08, 0x0,
    0x3fe28fbc13dd2418, 0x0,
    0xbfa20b6646c7fcb3, 0x0,
    0xbfe19696815a63b6, 0x0,
    0xbfe895ddfc413ab7, 0x0,
    0xbfdf8e62e26d0fef, 0x0,
    0x3f8de97696103962, 0x0,
    0x3fe08bd76034c4e2, 0x0,
    0x3fe448fbab05720a, 0x0,
    0x3fe2e166931b0e9f, 0x0,
    0xbf70044598e2f80f, 0x0,
    0xbfe25cc0302d3953, 0x0,
    0xbfe7fdcdf065d4f8, 0x0,
    0xbfde5310c4004443, 0x0,
    0xbfbdfd4f611efa17, 0x0,
    0x3fe1b3d98557c047, 0x0,
    0x3fe7aa45a6910248, 0x0,
    0x3fe296befa4e64b3, 0x0,
    0xbfb625cc1988a850, 0x0,
    0xbfe0c5e8e3d3b5a4, 0x0,
    0xbfe7fe746ae1e04e, 0x0,
    0xbfde0bf5aebf7fb6, 0x0,
    0xbfbf6828d040bd9c, 0x0,
    0x3fdce9f0fc5a8a73, 0x0,
    0x3fe928551d068073, 0x0,
    0x3fe0bad612c2cce3, 0x0,
    0x3fb4588800ebf815, 0x0,
    0xbfe0e35426007554, 0x0,
    0xbfe769d04ed0db0a, 0x0,
    0xbfddf59013e1ad90, 0x0,
    0x3fa83956efe680ad, 0x0,
    0x3fe208f606e76840, 0x0,
    0x3fe810036f697028, 0x0,
    0x3fdf8e4d150af4b3, 0x0,
    0xbfb84ed152d11e1a, 0x0,
    0xbfde7739b5580e50, 0x0,
    0xbfe767e14f6fd074, 0x0,
    0xbfe0a03674be5a79, 0x0,
    0xbf995d5b365c5382, 0x0,
    0x3fdcd311de8cdc0a, 0x0,
    0x3fe5ee77a0c794c3, 0x0,
    0x3fdf3de117c2bf4e, 0x0,
    0x3fb732748b1b1ac8, 0x0,
    0xbfe0af8441db0ec6, 0x0,
    0xbfe72b6e50229d76, 0x0,
    0xbfdfb54a864bd961, 0x0,
    0xbfa28d84df7f2808, 0x0,
    0x3fe1570462846331, 0x0,
    0x3fe6fee2c74cb7d9, 0x0,
    0x3fdd4834b6b60cae, 0x0,
    0x3f813ddd08ca9b1a, 0x0,
    0xbfde58a69095fc9b, 0x0,
    0xbfe6c68629cc0468, 0x0,
    0xbfe047f2a4f3b83e, 0x0,
    0x3f9009a588bc7558, 0x0,
    0x3fdd7a67ab9252d2, 0x0,
    0x3fe43481aa6c7b58, 0x0,
    0x3fe0f35b4391e841, 0x0,
    0x3f972e75d7a71e8c, 0x0,
    0xbfe253fd24b55541, 0x0,
    0xbfe9fb33eee466d2, 0x0,
    0xbfde2958ea17c5cf, 0x0,
    0x3fa402b4a2dc64c4, 0x0,
    0x3fdee410406f3bd1, 0x0,
    0x3fe8244a909622f5, 0x0,
    0x3fe0653f6e97ed1a, 0x0,
    0x3fb2646ac37425da, 0x0,
    0xbfdd9787dcdc204b, 0x0,
    0xbfe772e6251d3807, 0x0,
    0xbfde8a01ba8b6d41, 0x0,
    0x3f7ff27f8ca8f192, 0x0,
    0x3fe012629667704d, 0x0,
    0x3fe7aa71bb89c7ca, 0x0,
    0x3fdec7f5e1fbcc38, 0x0,
    0x3fa9678e1bd12422, 0x0,
    0xbfdd79035fd50993, 0x0,
    0xbfe6106c8ec8e127, 0x0,
    0xbfdbe493b455ebfc, 0x0,
    0x3fc027926db9856f, 0x0,
    0x3fdf07fb0d19bb16, 0x0,
    0x3fe5ce16d49e123c, 0x0,
    0x3fe0297aba3e93e7, 0x0,
    0xbf9fcbd9b9c085d9, 0x0,
    0xbfe275b40e65069d, 0x0,
    0xbfe44e3a1b54c182, 0x0,
    0xbfdbabc1f6f9b4f6, 0x0,
    0x3faaaa3338bfd089, 0x0,
    0x3fdf737a4da56039, 0x0,
    0x3fe607674eec744c, 0x0,
    0x3fe1ae1536f83a22, 0x0,
    0xbf7e97279c43e678, 0x0,
    0xbfe04e31bfdda73c, 0x0,
    0xbfe6f2ecb5aa61e5, 0x0,
    0xbfde61a2dad3864f, 0x0,
    0xbf79cebd00ee61be, 0x0,
    0x3fdf57722976daab, 0x0,
    0x3fe57be3d9291e21, 0x0,
    0x3fdb2ef76db18f87, 0x0,
    0xbfb438cdf04fa1c5, 0x0,
    0xbfdd712c27149114, 0x0,
    0xbfe5d8f547b9c838, 0x0,
    0xbfe09886d404ac49, 0x0,
    0x3fa7a2b261b39d1f, 0x0,
    0x3fd6b106179aa530, 0x0,
    0x3fe4ff44a4236382, 0x0,
    0x3fe01e6d344fc7a1, 0x0,
    0x3faf92bdcdadada4, 0x0,
    0xbfe205f8ae39092c, 0x0,
    0xbfe4781347ae7899, 0x0,
    0xbfe04239d33c17d9, 0x0,
    0xbfa8af17090db73a, 0x0,
    0x3fe1f677604136cd, 0x0,
    0x3fe5e9510a1d7184, 0x0,
    0x3fe13b8a639ce3c6, 0x0,
    0xbf80cfe2fdb29094, 0x0,
    0xbfdb84fa4be88a6d, 0x0,
    0xbfe95a475fdc3751, 0x0,
    0xbfe086d1d79d49aa, 0x0,
    0xbfa83d99547374c5, 0x0,
    0x3fe0922ba4cd77c3, 0x0,
    0x3fe5a9ca2b95eb3a, 0x0,
    0x3fdf3c135be533df, 0x0,
    0x3fb2f47663b5d80a, 0x0,
    0xbfe02fdadac23753, 0x0,
    0xbfe775f6b511f0ad, 0x0,
    0xbfddbbccb781ec64, 0x0,
    0x3f8db0d63303952a, 0x0,
    0x3fdbd2454d2fe5c6, 0x0,
    0x3fe5b568fcdbbbcb, 0x0,
    0x3fe3816e7b699fe2, 0x0,
    0xbfa3258e4456b1ce, 0x0,
    0xbfe0a8a55f68da3b, 0x0,
    0xbfe6c2959c4994aa, 0x0,
    0xbfe0159a86f59575, 0x0,
    0xbfa2e91112d26b6d, 0x0,
    0x3fddd7d8980478ea, 0x0,
    0x3fe4f70467a8e134, 0x0,
    0x3fe0a462a585a12f, 0x0,
    0xbf97151fa78a35cd, 0x0,
    0xbfdf0e2c4e1af151, 0x0,
    0xbfe5a3bd4167d478, 0x0,
    0xbfe15a95306079b4, 0x0,
    0xbf52a98b56ce0dc0, 0x0,
    0x3fe285a31e49af99, 0x0,
    0x3fe6d48171bcbf15, 0x0,
    0x3fe0ddc0b3420bae, 0x0,
    0xbfa0f74c8342d532, 0x0,
    0xbfddc68cc0c950a1, 0x0,
    0xbfe5b0517bbedb88, 0x0,
    0xbfda5d959e70d698, 0x0,
    0x3fc1067cc5a313d0, 0x0,
    0x3fdf8ec63436565e, 0x0,
    0x3fe5b139543d68c9, 0x0,
    0x3fe201e24eaa10f4, 0x0,
    0x3f79dc07558a6ea2, 0x0,
    0xbfdfc430d7e27c69, 0x0,
    0xbfe3f61c8fd3d54b, 0x0,
    0xbfda24138a11c80f, 0x0,
    0x3f9043ecbdeaa692, 0x0,
    0x3fddfea32a8e4ce5, 0x0,
    0x3fe5e8690b94e6f1, 0x0,
    0x3fdbebe6d2d51856, 0x0,
    0xbfa5e5be8b8a3b4a, 0x0,
    0xbfdecbbe5059d7b6, 0x0,
    0xbfe452a18bf4501d, 0x0,
    0xbfe1608a4e34888b, 0x0,
    0x3f69ab7e9b79ef88, 0x0,
    0x3fe0e433a025ed2c, 0x0,
    0x3fe71aa81d87b1ff, 0x0,
    0x3fe12e1b75684717, 0x0,
    0x3f9a7a67077a0987, 0x0,
    0xbfdef1e26b998a6b, 0x0,
    0xbfe4da8a84161645, 0x0,
    0xbfe08e0ad94fd0c9, 0x0,
    0xbfa6777c1b9a4c25, 0x0,
    0x3fe1a31bd58d4964, 0x0,
    0x3fe9cfdef6e67509, 0x0,
    0x3fe1ff40912f5942, 0x0,
    0x3fabb4eaa300ce67, 0x0,
    0xbfde27d6971b9514, 0x0,
    0xbfe62bfb0375521d, 0x0,
    0xbfdf52b1ae61ff7b, 0x0,
    0x3f6f7e8e9897d6aa, 0x0,
    0x3fdc86f32a4886ba, 0x0,
    0x3fe7957eaedd6f92, 0x0,
    0x3fdba3af1bfc1987, 0x0,
    0xbfac681c272af1e8, 0x0,
    0xbfdc6d13c6e4117e, 0x0,
    0xbfe6c38d204f0d57, 0x0,
    0xbfe2a7fb48c93301, 0x0,
    0x3f7d6bb02b9af27d, 0x0,
    0x3fdef2ee2192cd19, 0x0,
    0x3fe6b804594cb672, 0x0,
    0x3fe1a220de95a00d, 0x0,
    0x3fa92db041f805ec, 0x0,
    0xbfe0ad257f734730, 0x0,
    0xbfe83af4a030f61a, 0x0,
    0xbfdec6aa3bb979ff, 0x0,
    0x3f8d1fd6dac676c3, 0x0,
    0x3fdc5a3274622873, 0x0,
    0x3fe6007a450b3aa9, 0x0,
    0x3fdf4c7f9b98efca, 0x0,
    0x3fb44d19a0ff4145, 0x0,
    0xbfe020f314c8f65a, 0x0,
    0xbfe5b7dd2e1026e2, 0x0,
    0xbfe130b08efda231, 0x0,
    0x3fa0f3c771572567, 0x0,
    0x3fddf5a6f4d564ae, 0x0,
    0x3fe4e64eab7b3ea3, 0x0,
    0x3fdc471cc4a3f333, 0x0,
    0x3f807c4bb9878b85, 0x0,
    0xbfe18cc11ac9e5be, 0x0,
    0xbfe87c274134b0a3, 0x0,
    0xbfdfb3d447577f9c, 0x0,
    0x3fa5108afa0d47c3, 0x0,
    0x3fe34e1cf0bd473a, 0x0,
    0x3fe6a67d08b41dad, 0x0,
    0x3fdd6e596bd4baca, 0x0,
    0xbf93d9aa34b37f41, 0x0,
    0xbfe22289afa5f555, 0x0,
    0xbfe56e5f2823501d, 0x0,
    0xbfe0dd6dac396fc6, 0x0,
    0xbf8d7f61908c2c04, 0x0,
    0x3fda83f3ae60f923, 0x0,
    0x3fe5ce2833b7040e, 0x0,
    0x3fdc02ee5ae53d71, 0x0,
    0xbfa6720e0fcf8101, 0x0,
    0xbfde93a26bc1854a, 0x0,
    0xbfe547a25ffd8c42, 0x0,
    0xbfe197375b2eb3f7, 0x0,
    0xbfa481213bb31b8f, 0x0,
    0x3fe19d3e2c055892, 0x0,
    0x3fe6de191538f42c, 0x0,
    0x3fdead243812447e, 0x0,
    0xbfa3249cade6c2f4, 0x0,
    0xbfe01059aa4e45b6, 0x0,
    0xbfe4e4c9ed751ef9, 0x0,
    0xbfe0b7de94853bd4, 0x0,
    0xbfa48ecb0972af8b, 0x0,
    0x3fe260aa5dc528b8, 0x0,
    0x3fe92867e9c8c306, 0x0,
    0x3fdf10e7cfd4e211, 0x0,
    0x3f956bfbc9867860, 0x0,
    0xbfe0881b4c089067, 0x0,
    0xbfe6d06eecca2f78, 0x0,
    0xbfddfb732b8392cc, 0x0,
    0x3f92a44f527ba825, 0x0,
    0x3fdb8afd51787e8a, 0x0,
    0x3fe5fc815fb399ed, 0x0,
    0x3fdf8a973e538504, 0x0,
    0x3f9de2b1ce5e5c27, 0x0,
    0xbfe12ea071f9acda, 0x0,
    0xbfe7a2390f3bcbaa, 0x0,
    0xbfe0c04d20e1d1be, 0x0,
    0xbf7ccd4e43410e0f, 0x0,
    0x3fe03e6f6fab544c, 0x0,
    0x3fe60a4053aeda3c, 0x0,
    0x3fe01207aab8c0df, 0x0,
    0x3fa3e62d6470bce2, 0x0,
    0xbfe1951e1bf5d4fa, 0x0,
    0xbfe6944c3243115a, 0x0,
    0xbfe18d9b4ff2764a, 0x0,
    0xbfb0bd3f48174832, 0x0,
    0x3fe0aa751e35059d, 0x0,
    0x3fe8ae928454360f, 0x0,
    0x3fd9865825f11b08, 0x0,
    0x3fa35010c717fafe, 0x0,
    0xbfdf0c58d96e919c, 0x0,
    0xbfe46bc0ab7c80ce, 0x0,
    0xbfe1ca401587c958, 0x0,
    0xbf970c46e347ce15, 0x0,
    0x3fdd1dfe538eb734, 0x0,
    0x3fe60f9cb1afcfa7, 0x0,
    0x3fdeb8ee9674849f, 0x0,
    0x3f9d72caf7c2ba60, 0x0,
    0xbfe12946fdf39655, 0x0,
    0xbfe7cc549fc0f0f9, 0x0,
    0xbfe257c66b999f05, 0x0,
    0xbfb19a36cf14c7de, 0x0,
    0x3fe29f860655a303, 0x0,
    0x3fe6bdae3da43b2a, 0x0,
    0x3fe0eea50c00fca4, 0x0,
    0x3f771c80bdb0d725, 0x0,
    0xbfe0f1d47f829e57, 0x0,
    0xbfe69dbc78855245, 0x0,
    0xbfdcf17655938c15, 0x0,
    0x3f981cb8959b6f8a, 0x0,
    0x3fdd0b9a07ab14b4, 0x0,
    0x3fe5970461d1f201, 0x0,
    0x3fdaa1c54e782e13, 0x0,
    0xbf9fd285a2fcb416, 0x0,
    0xbfe10b0f02ec1b92, 0x0,
    0xbfe7b171d81968e4, 0x0,
    0xbfdebb057c23e827, 0x0,
    0x3fa5558aaa7660da, 0x0,
    0x3fe1acfd2a7d4812, 0x0,
    0x3fe4aa5a47fee8fd, 0x0,
    0x3fdaf78961cf7afe, 0x0,
    0x3fb0c88cd18879a2, 0x0,
    0xbfe189282094098a, 0x0,
    0xbfe8e6055f7d5b29, 0x0,
    0xbfe28f1f9ed4f9fa, 0x0,
    0xbf80259d6d6b41b1, 0x0,
    0x3fe0ddb7994ba59b, 0x0,
    0x3fe3df401c4f8998, 0x0,
    0x3fdbe557933e5ae9, 0x0,
    0x3f6bb46f7d06841f, 0x0,
    0xbfde69c44331de25, 0x0,
    0xbfe8792a34a9a4d0, 0x0,
    0xbfe24a5f2b7de792, 0x0,
    0xbf920ade5da052e9, 0x0,
    0x3fdc968748332d84, 0x0,
    0x3fe3c6438b2e1f86, 0x0,
    0x3fe12799febda964, 0x0,
    0xbf9213641ff872cc, 0x0,
    0xbfe13b0d654f6895, 0x0,
    0xbfe65aa721d555a0, 0x0,
    0xbfe35faa1770a754, 0x0,
    0x3fa729ba837e4f3f, 0x0,
    0x3fddbca153f17404, 0x0,
    0x3fe3e5add7f9a6eb, 0x0,
    0x3fdce602b903ecb4, 0x0,
    0xbfbbce311b65f2ae, 0x0,
    0xbfe00e74ed6f39e5, 0x0,
    0xbfe667ebe7674819, 0x0,
    0xbfdb338726352383, 0x0,
    0x3fabf4ba84142a7c, 0x0,
    0x3fdf67c6f7a609d3, 0x0,
    0x3fe6c855dc8c59ca, 0x0,
    0x3fde52444808d7be, 0x0,
    0x3f84b375960e60a4, 0x0,
    0xbfde1f5d8eee4bf9, 0x0,
    0xbfe65ed0929a5f4a, 0x0,
    0xbfe14d89e145298e, 0x0,
    0x3f61144bdedd8ac9, 0x0,
    0x3fe080ffc239d72c, 0x0,
    0x3fe76afdcf9a333b, 0x0,
    0x3fdc4c179032ed89, 0x0,
    0xbf88c7d7d4c46d04, 0x0,
    0xbfde4778bced8879, 0x0,
    0xbfe79553fcb91ffc, 0x0,
    0xbfdbec85ce1f94c2, 0x0,
    0xbf92a1f9fe9f8a45, 0x0,
    0x3fdf7229dd045f72, 0x0,
    0x3fe82a21a19c0713, 0x0,
    0x3fe09a615d4159b3, 0x0,
    0xbfab74199e3346b5, 0x0,
    0xbfd879e5dd9c0a76, 0x0,
    0xbfe58910846ea1f4, 0x0,
    0xbfdcb6ab3b0fe8fe, 0x0,
    0xbf7840f187d380d5, 0x0,
    0x3fddf6eae2340539, 0x0,
    0x3fe74f8bbf6e30cf, 0x0,
    0x3fe53022ea945b75, 0x0,
    0x3fb5716ac3932495, 0x0,
    0xbfdf9b3ce25c2e5f, 0x0,
    0xbfe51e9f6b9ab79d, 0x0,
    0xbfdf679aac511e6a, 0x0,
    0xbfa3123f6e314b64, 0x0,
    0x3fdf7792060000d8, 0x0,
    0x3fe661e9f358827d, 0x0,
    0x3fe1ac8ba9f558cc, 0x0,
    0xbf9d91a93b7cb5b3, 0x0,
    0xbfe07307048f0bac, 0x0,
    0xbfe4a338a9b28ad3, 0x0,
    0xbfdd3520c2dc5bd2, 0x0,
    0xbfa147ff83599e8d, 0x0,
    0x3fe119bc3022875b, 0x0,
    0x3fe72fa0a50fc284, 0x0,
    0x3fdd577c0a913cc9, 0x0,
    0xbfa4065aca038c27, 0x0,
    0xbfe34a95b41621c8, 0x0,
    0xbfe3bcddf822ebb0, 0x0,
    0xbfdc44610f805f55, 0x0,
    0xbf89f39eaa48c46d, 0x0,
    0x3fe10ec469348037, 0x0,
    0x3fe7dd4ea9731cfe, 0x0,
    0x3fde35cc2e17ba9a, 0x0,
    0x3fbaa4c9f358f243, 0x0,
    0xbfe0ea8f6a184e8b, 0x0,
    0xbfe7037379bb30ed, 0x0,
    0xbfdf573ffaa18ac4, 0x0,
    0xbf968b522c925bca, 0x0,
    0x3fdebddeb9c94a5e, 0x0,
    0x3fe775b213238685, 0x0,
    0x3fdf40c387c0bb65, 0x0,
    0xbf59dd447f66d08c, 0x0,
    0xbfda62d1913bb11d, 0x0,
    0xbfe5707aad94ce68, 0x0,
    0xbfd64139c6434f28, 0x0,
    0xbfa3824773e9fe04, 0x0,
    0x3fdf65e8c86816c5, 0x0,
    0x3fe4199991e6acb4, 0x0,
    0x3fda7e7821959386, 0x0,
    0x3f802d70e302796b, 0x0,
    0xbfdcdb838e18136c, 0x0,
    0xbfe43cb069526420, 0x0,
    0xbfdedbfc417d56bd, 0x0,
    0xbfa76310fab420e0, 0x0,
    0x3fdd02baba588df8, 0x0,
    0x3fe2a6f01f075de4, 0x0,
    0x3fdde2e2d8d2f003, 0x0,
    0xbfba719028e111f0, 0x0,
    0xbfdf78b519ae002a, 0x0,
    0xbfe4d0751e6e617b, 0x0,
    0xbfe1148486cb96f4, 0x0,
    0xbfa47b54e92327ef, 0x0,
    0x3fde284ea56a41cf, 0x0,
    0x3fe593821101aae3, 0x0,
    0x3fe2257dfda7e4b5, 0x0,
    0xbfb09fae04f18682, 0x0,
    0xbfdf337e5747f814, 0x0,
    0xbfe6cb87c3d685b4, 0x0,
    0xbfddc4bdf9aedaf5, 0x0,
    0x3f94a28b005e8a00, 0x0,
    0x3fd929f0c01edc89, 0x0,
    0x3fe585550081243b, 0x0,
    0x3fe1c8cc88ec8010, 0x0,
    0x3f9af223ef38cbe0, 0x0,
    0xbfe092c115285830, 0x0,
    0xbfe714103fcfdee3, 0x0,
    0xbfdea871b2bc6c47, 0x0,
    0xbfb366430ebef1a5, 0x0,
    0x3fe044f71c97226f, 0x0,
    0x3fe5bcc1a59f6fd1, 0x0,
    0x3fdbb0feca6e80c6, 0x0,
    0xbf7e12b728c5f658, 0x0,
    0xbfdd894c9f9ce159, 0x0,
    0xbfe6bf1af85846a7, 0x0,
    0xbfe0fa1ef8a7683c, 0x0,
    0x3fa0fb8274595b93, 0x0,
    0x3fe0e555f9f17c91, 0x0,
    0x3fe7fdb5f69c8399, 0x0,
    0x3fe231519b05eaba, 0x0,
    0xbfb59ca376011d7c, 0x0,
    0xbfe23ada0455212a, 0x0,
    0xbfe64a49bfaade23, 0x0,
    0xbfde692e9d6e36cf, 0x0,
    0xbf7fed87796921e3, 0x0,
    0x3fe0ff3bb184f714, 0x0,
    0x3fe8c352bcfe072c, 0x0,
    0x3fdd952828609bbc, 0x0,
    0x3fa2dd7cb4527e80, 0x0,
    0xbfe17d106bc7823a, 0x0,
    0xbfe456bfc49ce79d, 0x0,
    0xbfdae6cd6d4618c9, 0x0,
    0x3fb456727678f45d, 0x0,
    0x3fd704c3c2a8ac3e, 0x0,
    0x3fe6bf57c45cb0f3, 0x0,
    0x3fdef5ead501c00c, 0x0,
    0x3fb68de3e146a58a, 0x0,
    0xbfe111c740c6653a, 0x0,
    0xbfe801e265695377, 0x0,
    0xbfdee6a8381f51ee, 0x0,
    0xbfc018e8cca08c5a, 0x0,
    0x3fdc8f457b3dd718, 0x0,
    0x3fe6dd3f06949282, 0x0,
    0x3fe11405b7dd6630, 0x0,
    0xbfaad5cf08daea2c, 0x0,
    0xbfe0540f803f2016, 0x0,
    0xbfe54c1c4d466ca1, 0x0,
    0xbfdff69c42fd523d, 0x0,
    0x3fb159bf1018b927, 0x0,
    0x3fd9c48313651254, 0x0,
    0x3fe6af1d708d38ed, 0x0,
    0x3fe168d1e70d2253, 0x0,
    0xbf4e62a2c83bc8f4, 0x0,
    0xbfdbf36c5fe1923d, 0x0,
    0xbfe63048bb9c1ba6, 0x0,
    0xbfe1dc88d06cd46f, 0x0,
    0x3f92e10e01c158fe, 0x0,
    0x3fdead9c874283c6, 0x0,
    0x3fe4c02642eb5bc6, 0x0,
    0x3fe14c97b0ddfe8d, 0x0,
    0x3f60b08755c9a279, 0x0,
    0xbfe05a3ef9e76fd5, 0x0,
    0xbfe481f01ace015f, 0x0,
    0xbfde2b5be59070f1, 0x0,
    0x3f849e49561e9079, 0x0,
    0x3fd8ee8fc2129358, 0x0,
    0x3fe802c01cd1db75, 0x0,
    0x3fdeeb7dfd320864, 0x0,
    0xbf507c72dc5ba5ec, 0x0,
    0xbfe01bef8ecc4e05, 0x0,
    0xbfe4da34ed91d454, 0x0,
    0xbfdda4cfc9d2e5d1, 0x0,
    0x3f85943d7bc4b017, 0x0,
    0x3fdca9296ebc0505, 0x0,
    0x3fe71f24d97ec2f6, 0x0,
    0x3fe2f978b663ddff, 0x0,
    0xbf8cdfe3372fe5e9, 0x0,
    0xbfdf45c6957ed226, 0x0,
    0xbfe5d9aff0c5b6ec, 0x0,
    0xbfdd3630ddf86ff4, 0x0,
    0x3f9ac05a3f606c2e, 0x0,
    0x3fe19bfda8a5b3bf, 0x0,
    0x3fe8c060f6bd4a7a, 0x0,
    0x3fdc0886b343f724, 0x0,
    0xbfaa0ec409065ede, 0x0,
    0xbfdfcc9148f18343, 0x0,
    0xbfe8e058118bf56c, 0x0,
    0xbfe0d2ac149153fe, 0x0,
    0x3fac300738e729e6, 0x0,
    0x3fe06c9a9c8cf0d3, 0x0,
    0x3fe4eaaec8cf2772, 0x0,
    0x3fdefcb931276e65, 0x0,
    0xbf82e30a4678b5ab, 0x0,
    0xbfdb49518ac0439e, 0x0,
    0xbfe80b806d56ac13, 0x0,
    0xbfdec653516919b4, 0x0,
    0xbf88cfc011163d8d, 0x0,
    0x3fdea561899fe951, 0x0,
    0x3fe31e96deada192, 0x0,
    0x3fe02d0b0061f565, 0x0,
    0x3f7f2d8d2864d04a, 0x0,
    0xbfdd306fdf43391c, 0x0,
    0xbfe4349c5044adce, 0x0,
    0xbfd84bc0315582f0, 0x0,
    0x3f87c1d2a08feed0, 0x0,
    0x3fe0b4e32bcf720b, 0x0,
    0x3fe4037bb14387e3, 0x0,
    0x3fdceba6b23f7f1d, 0x0,
    0x3fa1b9f05ecb8585, 0x0,
    0xbfe0d5582aaaf723, 0x0,
    0xbfe4f786c184663a, 0x0,
    0xbfdbc8be2aafc501, 0x0,
    0x3fa26dadd8cfe846, 0x0,
    0x3fe0bbbe17d76095, 0x0,
    0x3fe74767d206aab9, 0x0,
    0x3fdb9c5cae4da2b5, 0x0,
    0xbf50f9ffce94ab1b, 0x0,
    0xbfe0b07c00538512, 0x0,
    0xbfe5f348273204c7, 0x0,
    0xbfdea270bd054363, 0x0,
    0x3fa89414e0f8722f, 0x0,
    0x3fe10362c83900fa, 0x0,
    0x3fe422ee06dc81d2, 0x0,
    0x3fdd80d9af6fc0e0, 0x0,
    0xbfa3a27d12e013f8, 0x0,
    0xbfdf69c74164ba07, 0x0,
    0xbfe54d7028e9b7a2, 0x0,
    0xbfe1159685b9b91c, 0x0,
    0x3f8554faf3dd99f1, 0x0,
    0x3fde0f08eab7e595, 0x0,
    0x3fe650f483251c46, 0x0,
    0x3fd898bcdf587455, 0x0,
    0x3fae83cbf8f3b131, 0x0,
    0xbfdc21a8f88fa584, 0x0,
    0xbfe6147950ce60cc, 0x0,
    0xbfe086db2930e602, 0x0,
    0xbf9c235765eb8387, 0x0,
    0x3fdbd9e8798382a9, 0x0,
    0x3fe5de841cb05895, 0x0,
    0x3fde9ad82d6fff53, 0x0,
    0xbf8b3f37c6d2d727, 0x0,
    0xbfe1e63e0e2ec0ec, 0x0,
    0xbfe617f0b43bac2a, 0x0,
    0xbfe006c90e35753c, 0x0,
    0xbfa65b6b8f2cf8ca, 0x0,
    0x3fdbf6fdefcb129d, 0x0,
    0x3fe6bd3747571edd, 0x0,
    0x3fdecd1c03eb79c9, 0x0,
    0x3fb27c55bdd7f7e0, 0x0,
    0xbfdcced5dc863d23, 0x0,
    0xbfe6ed649c5311be, 0x0,
    0xbfdde1b1f61cbefe, 0x0,
    0x3f9634e0654e7927, 0x0,
    0x3fe2ee39424985d5, 0x0,
    0x3fe5641ceac7b5ca, 0x0,
    0x3fe174eee40eb367, 0x0,
    0x3f68988269a72c71, 0x0,
    0xbfddae650d96ce2a, 0x0,
    0xbfe77856bbc530e3, 0x0,
    0xbfe09f2aba4695eb, 0x0,
    0x3f8de402399ac501, 0x0,
    0x3fdf611aefb6da34, 0x0,
    0x3fe73321ce1017d9, 0x0,
    0x3fe1939688c13847, 0x0,
    0x3fc0e79efb5691aa, 0x0,
    0xbfdfe31d2c3264ce, 0x0,
    0xbfe5526423b85dca, 0x0,
    0xbfdd4e4a8dcb82eb, 0x0,
    0x3f957fd516e0cc68, 0x0,
    0x3fe099e961bd2835, 0x0,
    0x3fea447d17d482c8, 0x0,
    0x3fdf7bacd331e19a, 0x0,
    0x3f77a070803ef951, 0x0,
    0xbfe041c0cb4c4667, 0x0,
    0xbfe4c51794343e46, 0x0,
    0xbfe0384c8bf18da9, 0x0,
    0x3fa45ce3a73a1eeb, 0x0,
    0x3fe00418a0b89f71, 0x0,
    0x3fe44b9d9eac53a7, 0x0,
    0x3fddcc8771a9e6a0, 0x0,
    0xbfab9ae1c6bf5c72, 0x0,
    0xbfdf95cae6d47e17, 0x0,
    0xbfe36bdad9629565, 0x0,
    0xbfdf4e599dea10ee, 0x0,
    0x3fb4b72975f6d5d0, 0x0,
    0x3fe039ab9faa9330, 0x0,
    0x3fe5e55bb44483d0, 0x0,
    0x3fdbf045aa008be5, 0x0,
    0xbf70d75f2466b4aa, 0x0,
    0xbfdc5e28bf4cbded, 0x0,
    0xbfe4a8cdab45714d, 0x0,
    0xbfdf908c302eab91, 0x0,
    0xbfa27578241ab5db, 0x0,
    0x3fe1811bb2f04be8, 0x0,
    0x3fe64ca654b579e4, 0x0,
    0x3fe043435b396cc6, 0x0,
    0x3f810c8658688d77, 0x0,
    0xbfdd6ea80ed73eb2, 0x0,
    0xbfe49b230b49e167, 0x0,
    0xbfde4bafaa990224, 0x0,
    0xbfae003d2561d6e7, 0x0,
    0x3fde7e2537de349a, 0x0,
    0x3fe5710c38ba6720, 0x0,
    0x3fe4844f91135ad9, 0x0,
    0xbf7334f3d2b03a64, 0x0,
    0xbfe0d382c0830681, 0x0,
    0xbfe6e49498c70cb0, 0x0,
    0xbfe0b15dbec7389d, 0x0,
    0x3f97896a54694f99, 0x0,
    0x3fdd7b009690fa27, 0x0,
    0x3fe74b3ef69ae6bf, 0x0,
    0x3fe0134ff9d779d4, 0x0,
    0xbfab0b7362e91b5f, 0x0,
    0xbfdc02426416d0bc, 0x0,
    0xbfe6bc5d7a47e037, 0x0,
    0xbfdf472f95faa78b, 0x0,
    0xbfb0ce442af852a7, 0x0,
    0x3fddec4636736a5a, 0x0,
    0x3fe6fd7a236940d8, 0x0,
    0x3fde700daf1c33ce, 0x0,
    0xbfa4e03f531fbcff, 0x0,
    0xbfdc546bce521014, 0x0,
    0xbfe75f876bdd6919, 0x0,
    0xbfe2da2b7268157f, 0x0,
    0xbf96401faac210b3, 0x0,
    0x3fe0e457442c893d, 0x0,
    0x3fe40e9751a47ee8, 0x0,
    0x3fdf6ddcb8201ecc, 0x0,
    0x3fae515ebbe5da50, 0x0,
    0xbfddb4492e423515, 0x0,
    0xbfe48b6e961ba73e, 0x0,
    0xbfe0c7800240ae21, 0x0,
    0x3fbbc68972976549, 0x0,
    0x3fe050bd8a678378, 0x0,
    0x3fe6b559ce7dcdf8, 0x0,
    0x3fe06726baa70b14, 0x0,
    0x3f909508c64ca1cf, 0x0,
    0xbfe01d76c8b25e52, 0x0,
    0xbfe715333939639f, 0x0,
    0xbfddfe585025a2ff, 0x0,
    0xbfb4b5207bb21097, 0x0,
    0x3fe03ee206c6d38c, 0x0,
    0x3fe41387675a9140, 0x0,
    0x3fdeb306d8235c1b, 0x0,
    0xbf5dbb5074ce6e1f, 0x0,
    0xbfded16d5277b482, 0x0,
    0xbfe609858aef1ba7, 0x0,
    0xbfe16d01449bfdc2, 0x0,
    0xbfa1b89e729baba9, 0x0,
    0x3fe10c4ffb267efb, 0x0,
    0x3fe59ed366f1eea4, 0x0,
    0x3fdcbc83bf151de9, 0x0,
    0xbfadc4827127cfff, 0x0,
    0xbfdc3e5dcbdf532b, 0x0,
    0xbfe71d6aae03f721, 0x0,
    0xbfdf75a5f9122812, 0x0,
    0xbfa9de338638d3b1, 0x0,
    0x3fdece7fc924afa0, 0x0,
    0x3fe6a06c8f3cf444, 0x0,
    0x3fddfef7d898d346, 0x0,
    0x3fad929a2bbdbccc, 0x0,
    0xbfe08ad4f84638f7, 0x0,
    0xbfe555c73d97ed04, 0x0,
    0xbfe18f43de09f990, 0x0,
    0xbfa6a5384215a5af, 0x0,
    0x3fdfa9c39ace162c, 0x0,
    0x3fe52f79b2e5f675, 0x0,
    0x3fe1b6b3ea11c9ac, 0x0,
    0x3fac161b8a0d7f1a, 0x0,
    0xbfe014c8e48e6d09, 0x0,
    0xbfe57532c45e283e, 0x0,
    0xbfe307f82779e218, 0x0,
    0x3f8edaa8fbc5c104, 0x0,
    0x3fe065100b4c45cb, 0x0,
    0x3fe345d00d0b6d31, 0x0,
    0x3fdf373ac39ceffe, 0x0,
    0x3fa73a9fb6f9f049, 0x0,
    0xbfe0830649d15ce7, 0x0,
    0xbfe86d1add34b012, 0x0,
    0xbfe271f5ba0fec12, 0x0,
    0xbfb77587dd703888, 0x0,
    0x3fe19e6e09a07fcc, 0x0,
    0x3fe88ae4c747e398, 0x0,
    0x3fe164b6cfb70aa0, 0x0,
    0x3f901628afb39163, 0x0,
    0xbfdf13676bdc516d, 0x0,
    0xbfe528182a0fb6e1, 0x0,
    0xbfe21ec918f8317f, 0x0,
    0xbf9e2039e5e879c1, 0x0,
    0x3fdf36a7aea65d71, 0x0,
    0x3fe692e67d802f24, 0x0,
    0x3fdf573af484df24, 0x0,
    0xbfa412f0dc72c609, 0x0,
    0xbfe076d2722838b1, 0x0,
    0xbfe6b0d9ca75f576, 0x0,
    0xbfdeac7903d2150d, 0x0,
    0x3f87a0fb8ad4ca2a, 0x0,
    0x3fe175345761eb25, 0x0,
    0x3fe541e3ae5ff16e, 0x0,
    0x3fe0c124296001ed, 0x0,
    0xbf6e21e83e7b39a5, 0x0,
    0xbfe1518abd7e8e66, 0x0,
    0xbfe61e20e8577f6d, 0x0,
    0xbfdf5f1228816a52, 0x0,
    0x3fa4326589aeb63c, 0x0,
    0x3fe09bf2cf3c668a, 0x0,
    0x3fe78979f5903393, 0x0,
    0x3fdffd195ba47156, 0x0,
    0xbf8f7210d626d390, 0x0,
    0xbfdf2f03ad8f5897, 0x0,
    0xbfe782b4688012dc, 0x0,
    0xbfdd9d26e57ec552, 0x0,
    0xbfa66a2057d8ac93, 0x0,
    0x3fe0bd92771e4269, 0x0,
    0x3fe3abbdaf57460f, 0x0,
    0x3fe1d989373dab17, 0x0,
    0xbfa32de2679fb4a4, 0x0,
    0xbfde6fcb26eda819, 0x0,
    0xbfe31de951b52396, 0x0,
    0xbfe0597fa579dfeb, 0x0,
    0xbfaa6cc8129902ab, 0x0,
    0x3fdec7ffaa7329f4, 0x0,
    0x3fe701971064dd10, 0x0,
    0x3fe0d9fd152ccb25, 0x0,
    0x3fb79e0149eb74c6, 0x0,
    0xbfd8479d61952bdb, 0x0,
    0xbfe524d3f75e87d4, 0x0,
    0xbfde42ef675fa0d6, 0x0,
    0x3f6154f418f21245, 0x0,
    0x3fe172049dcd139e, 0x0,
    0x3fe5bce823f34999, 0x0,
    0x3fddf5f6c8e6fcba, 0x0,
    0xbf920cc2979e3f05, 0x0,
    0xbfdd237b1e33eddd, 0x0,
    0xbfe50859eb789517, 0x0,
    0xbfe1b93bc8502969, 0x0,
    0xbfa4e10b176806c6, 0x0,
    0x3fe01918513010bc, 0x0,
    0x3fe6278696f0b2ec, 0x0,
    0x3fe00a59c41823f9, 0x0,
    0x3fb5755385211182, 0x0,
    0xbfdf8a84d901407f, 0x0,
    0xbfe5ba49c7e66a2a, 0x0,
    0xbfe0c7b4034dac1e, 0x0,
    0x3f51b0e28cb52abf, 0x0,
    0x3fe33b1621c516e0, 0x0,
    0x3fe56fcfe7c8be02, 0x0,
    0x3fde892d36c6117d, 0x0,
    0x3fb0c2206d662be4, 0x0,
    0xbfe088722b172245, 0x0,
    0xbfe6c0fbdad327f9, 0x0,
    0xbfe0e82bbbc5d95d, 0x0,
    0xbf8fa94b166e1294, 0x0,
    0x3fe069add8341fc0, 0x0,
    0x3fe4494765d5c3a6, 0x0,
    0x3fdc2dbfd9818c1d, 0x0,
    0xbfb42e5adcf61994, 0x0,
    0xbfde40bed8c93b0f, 0x0,
    0xbfe64e8abd1dea86, 0x0,
    0xbfda881dd4ed74b9, 0x0,
    0x3fba9edc52b9c875, 0x0,
    0x3fdffcf100410341, 0x0,
    0x3fe8164c82b94d60, 0x0,
    0x3fdbf883816e66ef, 0x0,
    0xbf7902d9fdebb77e, 0x0,
    0xbfddd7f3f3cfbaee, 0x0,
    0xbfe5d584d560f1a5, 0x0,
    0xbfdd3e0fb7fc1e47, 0x0,
    0x3f72cd5618ef7d4d, 0x0,
    0x3fdd93fa0fbf6930, 0x0,
    0x3fe46af28151517c, 0x0,
    0x3fe0680b65d5ad5d, 0x0,
    0x3f96e38bd2aca2a5, 0x0,
    0xbfe268fe3f4fd51e, 0x0,
    0xbfe4a34162c9ba6b, 0x0,
    0xbfdc44495d4df47c, 0x0,
    0xbfae3e830ecf2f63, 0x0,
    0x3fded16ad0ac2461, 0x0,
    0x3fe599c13f56a416, 0x0,
    0x3fdec8a99d304cf5, 0x0,
    0x3fb6a9ffe61c2d0f, 0x0,
    0xbfe26713c4094e8c, 0x0,
    0xbfe50152a3ed00a3, 0x0,
    0xbfde2c38aec41df4, 0x0,
    0xbfbd50b78d9aef3f, 0x0,
    0x3fdd6691ab2a2427, 0x0,
    0x3fe481f99b2ae528, 0x0,
    0x3fde9686c513ed25, 0x0,
    0x3f9c090dde509a7c, 0x0,
    0xbfe272c4c9124766, 0x0,
    0xbfe691dd4df13b7a, 0x0,
    0xbfe2c1dcd8b962b5, 0x0,
    0xbfb3b8dd5ac2fc59, 0x0,
    0x3fe1d0b7eefbff6a, 0x0,
    0x3fe69abf0afaca5f, 0x0,
    0x3fe0d0d83bdd0043, 0x0,
    0x3fb1c9b59ebf053f, 0x0,
    0xbfdc59af584bc4de, 0x0,
    0xbfe6fce840e147cb, 0x0,
    0xbfdd027800308b88, 0x0,
    0xbfa6ffca695d02c5, 0x0,
    0x3fdac152c64890bc, 0x0,
    0x3fe6f3ec4f57b9ad, 0x0,
    0x3fe0f5b66c348cfb, 0x0,
    0x3f97634cb6f5bb90, 0x0,
    0xbfe05f716e085511, 0x0,
    0xbfe6b871d845c792, 0x0,
    0xbfe310ffcae7326a, 0x0,
    0x3f95f8eb037ec103, 0x0,
    0x3fe0514387649ce8, 0x0,
    0x3fe6ab55c7a0765d, 0x0,
    0x3fd74b378faa9b6c, 0x0,
    0xbfb02f8b15a4ce79, 0x0,
    0xbfdbe72eb0a70301, 0x0,
    0xbfe726b92e361790, 0x0,
    0xbfe0cb442c91c487, 0x0,
    0xbfbf0430597724e8, 0x0,
    0x3fe09777785c9f6f, 0x0,
    0x3fe82d14205f12df, 0x0,
    0x3fdef546a4e623ff, 0x0,
    0xbfb9ff006f7ddddf, 0x0,
    0xbfdb1e5c34fcedf7, 0x0,
    0xbfe1c7016f8b45f3, 0x0,
    0xbfe075a9b3623836, 0x0,
    0x3faa00684d09e920, 0x0,
    0x3fe017ed58f3595b, 0x0,
    0x3fe756a91470e5d2, 0x0,
    0x3fdf361229a60c5d, 0x0,
    0xbfac9ce16168172e, 0x0,
    0xbfddcdddab495cf8, 0x0,
    0xbfe774de3488e352, 0x0,
    0xbfdfe24b7b5af1c6, 0x0,
    0xbf9ed15b7213656a, 0x0,
    0x3fe03194be37234a, 0x0,
    0x3fe7bfbaab58b562, 0x0,
    0x3fe1a427eddd5fbf, 0x0,
    0x3fa1c93bf0aadba5, 0x0,
    0xbfe0def60f903fc4, 0x0,
    0xbfe98f63836354fe, 0x0,
    0xbfdee854271663a9, 0x0,
    0xbf90cddf4c2c7f54, 0x0,
    0x3fe05188c3d3f32d, 0x0,
    0x3fe5567a67e2958e, 0x0,
    0x3fdf28a957fac5a4, 0x0,
    0xbfabedfa1568f2a4, 0x0,
    0xbfe294a36d2334e9, 0x0,
    0xbfe3787b524bcee7, 0x0,
    0xbfe0fea86780f3b0, 0x0,
    0x3fb628a26bac07bc, 0x0,
    0x3fde54d569d43e11, 0x0,
    0x3fe3ea695ddbb048, 0x0,
    0x3fe094ccba139eb9, 0x0,
    0x3fa63829a4dca7ab, 0x0,
    0xbfe288656efe8f81, 0x0,
    0xbfe55ffe9452192c, 0x0,
    0xbfe025604627106c, 0x0,
    0x3f9dba7af3a593d2, 0x0,
    0x3fe0cb85dd66ed81, 0x0,
    0x3fe3ce88b4a6d12c, 0x0,
    0x3fe230e387790bfa, 0x0,
    0x3fa11e6e819e1740, 0x0,
    0xbfe0e425f89c5519, 0x0,
    0xbfe4b1de87c2fdb2, 0x0,
    0xbfdc9848aeb6fced, 0x0,
    0x3fa3f19901de750c, 0x0,
    0x3fdba388f517b33a, 0x0,
    0x3fe36b6ae8272dc9, 0x0,
    0x3fe2270ca63e785e, 0x0,
    0xbf95284bc4e0a9e9, 0x0,
    0xbfdccb33ee97afec, 0x0,
    0xbfe86001e0618877, 0x0,
    0xbfdfcce349382103, 0x0,
    0x3f90b6624aea4d7f, 0x0,
    0x3fdf05d81a37342c, 0x0,
    0x3fe2bea708f9211b, 0x0,
    0x3fe16e74a09d00ff, 0x0,
    0xbf7c7e1878907fa0, 0x0,
    0xbfe051d950c060a4, 0x0,
    0xbfe72153b2168fdd, 0x0,
    0xbfe075d2bc182cb8, 0x0,
    0xbf9abebde7c017a2, 0x0,
    0x3fdcb184849114f6, 0x0,
    0x3fe50cd57387b209, 0x0,
    0x3fe05d660c9a0d7f, 0x0,
    0xbfa18b79a7e1fa5d, 0x0,
    0xbfdabcdc6e7a914a, 0x0,
    0xbfe6f03428b94ca5, 0x0,
    0xbfdfb6b9763a6f3b, 0x0,
    0x3f8668d516319cad, 0x0,
    0x3fdefdf862bdb8f1, 0x0,
    0x3fe4836ee5e2918f, 0x0,
    0x3fe24e40fc538c50, 0x0,
    0x3fa84308da570c0f, 0x0,
    0xbfe1f7af4b50f07d, 0x0,
    0xbfe709806eabf9fe, 0x0,
    0xbfdd4352e1d2ecaa, 0x0,
    0x3fa062f2ec1b85be, 0x0,
    0x3fe0adbca31c1117, 0x0,
    0x3fe560fbd7c2b481, 0x0,
    0x3fe0867dea0969df, 0x0,
    0x3f9d4c5fe44e951c, 0x0,
    0xbfe0a0f59a04bd62, 0x0,
    0xbfe75add66ecfeba, 0x0,
    0xbfddba09bcbce1c0, 0x0,
    0x3fabf2ea2e5c0926, 0x0,
    0x3fe27150163b82b4, 0x0,
    0x3fe6557b59acfcaa, 0x0,
    0x3fe2bd653f47ac5e, 0x0,
    0x3fbeb761e21127fc, 0x0,
    0xbfe18bdd13a20157, 0x0,
    0xbfe8148359670d09, 0x0,
    0xbfe05c91d4cc1dc6, 0x0,
    0x3f92fe3061d58547, 0x0,
    0x3fe2bcdc6f36dd9a, 0x0,
    0x3fe6f1901c722bb8, 0x0,
    0x3fdcf1ff67e163a3, 0x0,
    0xbfa507ac61d0a147, 0x0,
    0xbfe12861818e8509, 0x0,
    0xbfe496035604bb50, 0x0,
    0xbfe06dc1a93a4260, 0x0,
    0x3fa6f7bcd0c0afba, 0x0,
    0x3fe09048650ffbef, 0x0,
    0x3fe531d5dce6aed2, 0x0,
    0x3fe35f95392d8802, 0x0,
    0xbfa3a0fe924e7385, 0x0,
    0xbfe06f99dd9b2f7d, 0x0,
    0xbfe6cdba36c3b4b6, 0x0,
    0xbfdde5b6b87b7fdc, 0x0,
    0xbf8bab4af8a01693, 0x0,
    0x3fe37340689e13e2, 0x0,
    0x3fe7530257b2aa42, 0x0,
    0x3fde0326f35d10d6, 0x0,
    0x3fa3a5498373c5ab, 0x0,
    0xbfdd846d87487b2e, 0x0,
    0xbfea0fa607090084, 0x0,
    0xbfdc816238086fca, 0x0,
    0x3fb60b1fb95a1931, 0x0,
    0x3fe0f7d138da3e6f, 0x0,
    0x3fe664e2f66339ac, 0x0,
    0x3fde575b97da2586, 0x0,
    0xbfb145e3bfaa3099, 0x0,
    0xbfdf0cda0fe35bb7, 0x0,
    0xbfe7a10d4fbd8865, 0x0,
    0xbfdf327d3c1671d5, 0x0,
    0x3fbbd2767c83e381, 0x0,
    0x3fdc5e2c8513f135, 0x0,
    0x3fe7cd1877250970, 0x0,
    0x3fdbf65a91c174f4, 0x0,
    0x3f907d44bdae82c4, 0x0,
    0xbfda2b8d61c1acef, 0x0,
    0xbfe69754744db2b3, 0x0,
    0xbfde0ebaf65e6dd9, 0x0,
    0x3fb0f3701bb5cd80, 0x0,
    0x3fe1bd232933c8c5, 0x0,
    0x3fe6305ded9e958b, 0x0,
    0x3fdd2e7d9d0a934f, 0x0,
    0xbf962e817ec0b6ea, 0x0,
    0xbfde549789355941, 0x0,
    0xbfe63c52c9dcd574, 0x0,
    0xbfddcdfbff4837ca, 0x0,
    0x3f848b612013ec5b, 0x0,
    0x3fdd5428851ca0fd, 0x0,
    0x3fe7450a097ca1c5, 0x0,
    0x3fdec89b93652b07, 0x0,
    0x3f75f8056a177977, 0x0,
    0xbfde3efcc58184e0, 0x0,
    0xbfe6540a8e3ff74e, 0x0,
    0xbfdb8fdcafe3887e, 0x0,
    0x3f91931c0012a7f9, 0x0,
    0x3fe0c3cc5a7a1639, 0x0,
    0x3fe5eb958339dbe9, 0x0,
    0x3fe08ca7f894d64b, 0x0,
    0x3fa1269ca524d73b, 0x0,
    0xbfe0a2a5eaafb6c5, 0x0,
    0xbfe3e7dc9a186586, 0x0,
    0xbfe17327f3d5f894, 0x0,
    0xbf9b71e92f2ced52, 0x0,
    0x3fe031a6f740252e, 0x0,
    0x3fe71288b8e2e775, 0x0,
    0x3fddf773a9adda22, 0x0,
    0xbf9a085598e1b765, 0x0,
    0xbfe19bc3ec6660c3, 0x0,
    0xbfe69a9bebaf98d9, 0x0,
    0xbfdf675095206e77, 0x0,
    0x3fb2e4a4bc1925f6, 0x0,
    0x3fe216fbfafa7355, 0x0,
    0x3fe620f1cf34cffe, 0x0,
    0x3fdd23ff94e35bd0, 0x0,
    0x3f883e4b99a6c24e, 0x0,
    0xbfe18be607b98d17, 0x0,
    0xbfe466eab672b57f, 0x0,
    0xbfde3f0974db48c6, 0x0,
    0xbfb9d4a4dd8e99d9, 0x0,
    0x3fdd98c0baa29ca1, 0x0,
    0x3fe6aebbd0633f6a, 0x0,
    0x3fe03ae5399d648f, 0x0,
    0xbfa2db108bd2ec7b, 0x0,
    0xbfda234324e9f0f3, 0x0,
    0xbfe6aa440aa2b8ba, 0x0,
    0xbfdbccb10170bc68, 0x0,
    0x3f8e0008c0122a60, 0x0,
    0x3fe04d8b0a8ed6b9, 0x0,
    0x3fe62f878add0928, 0x0,
    0x3fdd93b3782aa7af, 0x0,
    0xbf7977d26f167534, 0x0,
    0xbfde5b9039d3bce1, 0x0,
    0xbfe634f38f4ef1a1, 0x0,
    0xbfe0fbafdbcec1e4, 0x0,
    0xbfb56f30ec074f5b, 0x0,
    0x3fdd759c5037e42e, 0x0,
    0x3fe93decaae9a649, 0x0,
    0x3fdd984e48989804, 0x0,
    0x3fabb60d082beba1, 0x0,
    0xbfe143f10112762b, 0x0,
    0xbfe4ea23520a706d, 0x0,
    0xbfddb02da69ae1d5, 0x0,
    0xbf986a7054ec0ac6, 0x0,
    0x3fda83622f711c2d, 0x0,
    0x3fe8f5433f2788e6, 0x0,
    0x3fe15c8b99a607ad, 0x0,
    0xbfa1a60a97894d96, 0x0,
    0xbfdfe946a564f35b, 0x0,
    0xbfe4bb460818c814, 0x0,
    0xbfe01b6bd1f1d772, 0x0,
    0xbfb33e24de929c3f, 0x0,
    0x3fdb4dc16b7742eb, 0x0,
    0x3fe6752ee8a72a98, 0x0,
    0x3fdbccfc1dcee6fa, 0x0,
    0x3fb6bb1d2afcbb28, 0x0,
    0xbfe0770f9ca336c1, 0x0,
    0xbfe572509423bad3, 0x0,
    0xbfe1f6d736b1bc27, 0x0,
    0x3fb1e1b88e30010a, 0x0,
    0x3fdf6bc70bffd780, 0x0,
    0x3fe54b39e724d5bd, 0x0,
    0x3fde080ba54ee111, 0x0,
    0xbf51b98166acd81e, 0x0,
    0xbfdd2b2b1176e990, 0x0,
    0xbfe54549feae13a4, 0x0,
    0xbfe0237171286717, 0x0,
    0xbfbe40f1bb903804, 0x0,
    0x3fe0ad21b922ca06, 0x0,
    0x3fe5e5fae976061b, 0x0,
    0x3fdbd16fca6b6238, 0x0,
    0x3fad594b103dd722, 0x0,
    0xbfdac23a659e0f27, 0x0,
    0xbfe41a6f1c28aba6, 0x0,
    0xbfe048117072bae9, 0x0,
    0xbfa95382971e278e, 0x0,
    0x3fdf617577b39231, 0x0,
    0x3fe6b174a62f9f58, 0x0,
    0x3fe04595e97d8fa2, 0x0,
    0x3f9aff4294dd7b1f, 0x0,
    0xbfdffc436dd20785, 0x0,
    0xbfe5ac7f10003c4c, 0x0,
    0xbfe20cf601955210, 0x0,
    0xbf9f954ab5ae7dcc, 0x0,
    0x3fde00ff9020b2f5, 0x0,
    0x3fe71182e95d659b, 0x0,
    0x3fdffe65665fe7b7, 0x0,
    0xbfc170a74772eb10, 0x0,
    0xbfe0e43f740ff4d7, 0x0,
    0xbfe3754917d1cc21, 0x0,
    0xbfe3ca2d0e5bb299, 0x0,
    0x3fbb203b6036de2c, 0x0,
    0x3fdb1630e8f4fe12, 0x0,
    0x3fe5cfe4e99ad102, 0x0,
    0x3fe06af741e74ed6, 0x0,
    0xbfa90a93fd0d8d1d, 0x0,
    0xbfdc82beef87c482, 0x0,
    0xbfe5a686b70c0bc4, 0x0,
    0xbfdf3ac58036e57e, 0x0,
    0x3fc02f90d31911d9, 0x0,
    0x3fe046db64d84d2e, 0x0,
    0x3fe673b178fae8be, 0x0,
    0x3fdef8fb6d9736d0, 0x0,
    0xbf9eb0bf395b8a92, 0x0,
    0xbfdf5ea6c8c74192, 0x0,
    0xbfe666716f4f8447, 0x0,
    0xbfddf2adbdd1551e, 0x0,
    0x3fa4b9e063793a9b, 0x0,
    0x3fe041565bd9e26c, 0x0,
    0x3fe7cf94beeefd36, 0x0,
    0x3fded7ee86cd6508, 0x0,
    0x3fa832a26c006b40, 0x0,
    0xbfe1e96686279685, 0x0,
    0xbfe5960ff3f76c2a, 0x0,
    0xbfe04e9eb7803240, 0x0,
    0x3f8d48ac7717afb3, 0x0,
    0x3fde11a1e0cafe2c, 0x0,
    0x3fe3eec274111a7b, 0x0,
    0x3fe02b97121762e9, 0x0,
    0x3f59a48da3a1e5eb, 0x0,
    0xbfdf0c9984f54559, 0x0,
    0xbfe72613b9dc6466, 0x0,
    0xbfd83a1b49aa3894, 0x0,
    0xbf9f7be23b008604, 0x0,
    0x3fdc15ce530e968f, 0x0,
    0x3fe4f10117f20626, 0x0,
    0x3fdbc3b71bc6cc2a, 0x0,
    0x3fb324b7e9f8a633, 0x0,
    0xbfe034ae70e65459, 0x0,
    0xbfe6d4bdf09273c7, 0x0,
    0xbfe124216d96c397, 0x0,
    0x3f968f957d63ac1b, 0x0,
    0x3fdfd86e1c62ec9c, 0x0,
    0x3fe78d94a9184f75, 0x0,
    0x3fe2d7a90f7782b2, 0x0,
    0x3f86a447581b509d, 0x0,
    0xbfe1963b2b2e504b, 0x0,
    0xbfe7b599e4ebe1b9, 0x0,
    0xbfde8d08a75852d0, 0x0,
    0xbfb07ebf46cd3743, 0x0,
    0x3fdf651117d3f4d2, 0x0,
    0x3fe5d1ccac84acaa, 0x0,
    0x3fdc4117410f74ef, 0x0,
    0x3f70651543fbb362, 0x0,
    0xbfe10a26032c1ea4, 0x0,
    0xbfe803ba7a14d320, 0x0,
    0xbfdd9434dcbccf71, 0x0,
    0xbf89df25a79f4a01, 0x0,
    0x3fdbf0bc8836900a, 0x0,
    0x3fe6baef4e118d53, 0x0,
    0x3fe0de6ae9fae812, 0x0,
    0x3f8e7dcc32973bf8, 0x0,
    0xbfde4ad355ddb689, 0x0,
    0xbfe4874ac6f5b996, 0x0,
    0xbfda9c7c8611ec4b, 0x0,
    0xbf8ce2c5ee81512e, 0x0,
    0x3fdc848f1cbfffee, 0x0,
    0x3fe88d43bf382ad0, 0x0,
    0x3fde7fe4c51f0572, 0x0,
    0x3f99041a09b7d26e, 0x0,
    0xbfe13b226cba06c5, 0x0,
    0xbfe80fffcab3c82c, 0x0,
    0xbfdeb7542ff761d7, 0x0
    };

static const uint64_t in_cifft_noisy_2048[4096] = {
    0x3fab0667ea63d9a0, 0x0,
    0x3fd1a1e3e4be0ff5, 0x3fb71ddb3c79e188,
    0xbfefaa3877d737da, 0x3fe598fc4ba3c24a,
    0xbfe7e6857b0d9963, 0xbfe87cb9b7ca31c6,
    0xbfd73590c05d331c, 0x400427513e5ef838,
    0xc009fc5bc8cb6ed3, 0x3fe8f5336e6e1d5a,
    0x3feaab07751eec7a, 0x3fd533df19f6eff5,
    0xc0020ad2d063117c, 0xbfe7f44595a35676,
    0x3fe629e38f190220, 0x3fef0969585a66ca,
    0x3ffad0eda14837a7, 0x3fdf7e92fc4015c6,
    0x400613c19ee02914, 0xc00f21c030f929f6,
    0x3ff390abe9290e78, 0x400981bc36445060,
    0xbfeb9ae4edb826d1, 0x3fab136a46ab7180,
    0xbfe3239f4201afa8, 0x3ff1de57ffa14496,
    0x3fa1c007ccc26030, 0xbff5b2f5e5069eec,
    0x3fd5b6855050a801, 0xbffbb51bff7732f6,
    0xbfab455502c69240, 0x400bfa74f904fbd1,
    0xbff8f935ff080dc3, 0xbff74a3124482daf,
    0xbfc734a6f14a3648, 0xc005ec1c346671fa,
    0x3fe70605098af7be, 0x3ff4d87e13924b0a,
    0xbfffb134ac8a1b46, 0xc002c348637c2310,
    0x4002546c566895c2, 0x4003a095ec899fe4,
    0xc004362302515ed4, 0xbfe2b343ca7af20a,
    0x3ff5cbec53ded73a, 0x3ff405d45594aa6d,
    0xc005fd2c3157892d, 0xbff5d7e8a1063174,
    0x3fe3f63a38e3ad48, 0xbfd25903e6ea1fb6,
    0x3ffccdb481f780d0, 0x3ff1c88fcb293802,
    0xbfd224bee7df1ce7, 0xbfb5fe8bcfaba704,
    0x3fc19810c1fa7fe8, 0xbffb9e93deb2cac4,
    0x3fedec5758a295e3, 0x3ffe1853295d655a,
    0x3fad9b49a8e91290, 0x3fea247433657a76,
    0x3febd35ab23f65ce, 0xbfe9f691be2032ea,
    0x3fe839cec18adc18, 0xbff54e236f330b98,
    0x3ff7c0a0b343941f, 0xc002ad9721dc769c,
    0xc002937a3e89e99e, 0xbff5a5bbb07b0030,
    0xbfdcd4951085cb62, 0x3fe79dd387dc3848,
    0x3fdaff8b21232b38, 0x3feafe69312f076a,
    0x3fc0e4cf0f1a4d8c, 0x4003f260cdc08a04,
    0x3ffb332a33646f9b, 0x3fd43efda14d9a40,
    0x3f80a43ac76c8d80, 0x3fda7d94e91edcd4,
    0x400309d0ae39c9a4, 0xbfe668249462f128,
    0xc0011af4c7efde74, 0x3fec7cbf1c22dc3e,
    0x3fd2a2c8fabc3166, 0xbff6bcb1cbf737f4,
    0x3ff3007f4c6392ca, 0xbfe8ee44567e4638,
    0xbfe4abec04b9acd4, 0x3feb21fd0c5ecfa6,
    0xbfa74d051fa420d0, 0xbffab532c9e3e56a,
    0x3ff07aac3a8ec396, 0x400bdc0fa9e02c7b,
    0xbfeb44e313591f1e, 0x3fd7ba5ef648b170,
    0xbffef7746bf16471, 0x3fe70587f0a08a47,
    0x3fee62e257314cf2, 0x3fa9a029bbf36a50,
    0x3fcfb7c54e2ef753, 0x3ff9d076e7aedaa6,
    0xbfde97b6a990c067, 0x3fb301d1d1321a20,
    0x3fe78a4592911e15, 0xbfd04a7f93baac0d,
    0x3fb221246b2dc3c4, 0xbfe6637991ff0eb4,
    0xbfaa056c684910a0, 0x3ff7997c377567d4,
    0xbffd1336570d1f6f, 0xbff117457a47b937,
    0xbffcf628e198719b, 0x3ff87d89bdffbbca,
    0x3ff63b1fb9ccf31e, 0x3ff3459bf4ab3099,
    0xbff355e0c2ca12fb, 0xbfee95b0e50bc52e,
    0x3ffe1c205496763e, 0xbff16241400ce109,
    0x3ff13430695c3773, 0xbff3532b30c70ee5,
    0x400602740152b75b, 0xbfda44d68ac65d7f,
    0xbfeb5506558e6ed4, 0x3ffa2095cf4bb61c,
    0xbff64e5dc707944c, 0xbfdc0fa57dc25912,
    0xbfe6dc4a5ab95df0, 0xbffca0d8a9b193ff,
    0x3fed079149ef8a3a, 0xbfd1eb64a0b5842a,
    0x3fef72b9e48c852a, 0x3ff6fb233462ca2a,
    0x3ffcf52564179636, 0xbfee9dfb6929417e,
    0xbfebf46a28ba0fe4, 0x3ffa793ff22a8c36,
    0x3ffc2daea60678a4, 0x3f9d1daf4fac3860,
    0x3fa6868705e5a590, 0x400647ee3b8e0766,
    0x3fc21738b5b8a71c, 0xbffd4320edc71cb8,
    0x400210c83f1f62e0, 0x3f93753362cf1200,
    0xbfdb1979d829d552, 0x3fe5a640e34360e4,
    0x3fdb8c2f79db80bc, 0x3ffcb23b538a05fe,
    0x3ff0053a3eeb0d91, 0x3fff7feaf5e0d186,
    0xbfeca4cf15ba45ff, 0xbfad18d529a02cc0,
    0xbfeea7a01f647976, 0xc0026710d01462a2,
    0x3fe1ea3621bb7d47, 0x3feb141ba4b93555,
    0xbfeb4823cf3179bc, 0x3ff0e7ad8ab45e40,
    0x3ff0afcc77d0d398, 0xbfd91663d9997802,
    0xbfcafe088bbea8ef, 0x3fa896c3b66364a8,
    0xbff25cb3d1c7872a, 0xbff470b0c1f2a236,
    0xc011cdae691ee316, 0xbffebd7e503bf00c,
    0xbfe0241ba149f48a, 0x3ff3bf68270034a2,
    0xbff3a974ee2f6a51, 0xbfccd4ff2f86d7e4,
    0xbfbfe6416ead3388, 0x3ff5a513bab042d1,
    0xbfb28cc0d36a29fc, 0x3fc10e55202a5fa0,
    0xbfe76630bd1d4a2a, 0x3ff88c29d4e63e4f,
    0x40045c2c0cd00bb8, 0xbfe16fdf624a3013,
    0x400a087f923deb1e, 0xc0058e70c237bd94,
    0xc00505f301ee5af0, 0x3fe8e45dfd6a9883,
    0xbfb6f292b765595c, 0xbfe3ba3ad00a68a8,
    0xbffb9ff4e88027b5, 0x3fd4ca1c0fbaa95c,
    0xbfce9f6b2c0437c6, 0xbff62e39e342ce3e,
    0xbfdc98032bf4dea2, 0x3fd20d3fafe1042c,
    0xc00aca0d80570f3d, 0xc008bb7050a541a0,
    0x3fda0e27b9ee5688, 0x3fe9bab37b7feb5b,
    0x3fe728042b64fb97, 0xbff5fefab832dd44,
    0x3fc3bff64bdb62f0, 0x3ffa510fc8a12923,
    0x3fd40368d4dfd970, 0xbfc3795cdfec1ae0,
    0xbffe7108edcab12b, 0xbfca912df09b4800,
    0xc0057cb01d728d01, 0xbfe44c364cfab8e6,
    0xc0000a534a180190, 0x3ff033ddd6289512,
    0xbfd4851bdf2ec2cc, 0xbff88fd56c029602,
    0x3fe71c12a56822cb, 0x3ff45a6169c45d5e,
    0xbff63bc625d56448, 0x3ff0c5319c16f3c1,
    0xc00e4b194e5008f9, 0xc004e247b6473136,
    0xbff01c598c7faae2, 0xbff29fbc40c7521c,
    0xbfde4a10adb0bb74, 0x3fef2065f7efd61b,
    0x3ffdf25ed88f7ea5, 0x3ffb165402eb70ec,
    0xc003461de256e343, 0xbfcdf031078e1da8,
    0xc004f15568c73a2a, 0x3fee51fb363c7aff,
    0x3fc89f0bf231f1a8, 0xbff289403170e94e,
    0x3fec613988b5e029, 0xbffaff23c0d6c288,
    0xbfe9a102c9001bf2, 0xc00401d7c6f2ab37,
    0xbff3f5cd6c33a784, 0x3ff4f1bc7b399360,
    0xbfc70dc336a75462, 0xbfe8721a9745bf26,
    0xbfe5567d02d12794, 0xc00b94dbdb6a8302,
    0x3fd1ce394bf5845c, 0xbfeb28f40930ac79,
    0xc001c081644b467a, 0xbff0bded14d0ba14,
    0xc00245070f87526b, 0x3ffee30fbb8d45a9,
    0x4009e867dc593320, 0x3fc27892d70137c0,
    0xc0001d38534a32b6, 0x3ff1a53669dd47ba,
    0xc004495aa3e38364, 0x3fcd812a15d35c68,
    0xbfeb1d3b2ace8836, 0x3ffcacf0c2045b3a,
    0x3ff61cf1a60228d2, 0x400e8ac97c1b9d87,
    0x3ff0b8494dda2544, 0x3fd87d6d817b9db8,
    0xc00a51198dae5a7a, 0xbfb83e8b50345214,
    0xbff2f93bd90782f9, 0xbff516b50b48c390,
    0x3fe936b9d8ca33f6, 0xc0012a6e064adcd1,
    0xc004afc05faec744, 0x3fce26efaae863fe,
    0x3ff9380bfcd71964, 0x3ff6c30f1b84090e,
    0x3feb4003f67edd8a, 0xbff0087085aa1172,
    0x3ffb0ab2f9197d38, 0x3f94c17af06bfbc0,
    0xbfcd6ea2396871ac, 0xbfe6cd5bf5d91f29,
    0x3ff386e8eef53ad8, 0xbfb3d4c543f70950,
    0x40037bab81fce327, 0xbfa442ac08005988,
    0xbffb2a246eb0345f, 0x3fefa5f417ffb6d9,
    0x3fe07266263c0578, 0xbffdb5469e21d0e2,
    0xc00133f971cc443b, 0xbfe29278029f87e1,
    0xbff9467b12e9f774, 0x3ff6beb4c5ffda14,
    0x3ff23db602edeeae, 0xbfc7de24430462a4,
    0xbfccdddb7f111320, 0x3fd2cb426f1f9bd8,
    0x3fb4a9e1723fe9f4, 0x3fe0759ccec36073,
    0xbfe703c159c8aec0, 0x3ff0a20624d18af7,
    0x3febcd43d77e37e3, 0x3fe5955f49312257,
    0xbff03b4805860b04, 0x3f79555f8c563880,
    0x3fc0db329ebf652a, 0xbff4e7a17653b24f,
    0x4004ba150c515f94, 0xbff47acf9766b555,
    0xbfcc840e835fc966, 0xbfd656a844f6f16e,
    0x3fd936823feb830c, 0x3fea5a9ead5640e4,
    0xbfe3563d8819c575, 0x400400d28df6aca2,
    0x3fbffdf985bd79d4, 0xbfd8a2457883a55b,
    0x3ff6ad40188280c6, 0x3ff0ce28ff1004e9,
    0xbfe1591f88eee6c8, 0xbfe1f5368db5abae,
    0x3fce0d28a2313658, 0x3ff90944a5d50e68,
    0x3fd7c4c60583e4ad, 0x3ff3864fffc7f032,
    0x4003393e1147695f, 0xbfdf4b3a175ef3b0,
    0xbf8f60445994b280, 0x3ff800dc2c1c0fb4,
    0x3fc485345f071e00, 0xbff3240067240cf4,
    0xbffd1f4a6753c876, 0x3faa942f396eeb60,
    0x40104d4ad8774026, 0xbffe1fef24e8198e,
    0x3fcd79d5fbf2f1e0, 0x3fe2b118c3bf6260,
    0x3fe15ddc0f1cdd00, 0xbfd4352fa1b340b8,
    0xbffb7c6cebbf8619, 0x4000e97288291f16,
    0xc0047e419f0a2424, 0x3fe997d2a93d26fa,
    0x3ff463fa5e323ab8, 0x3fe9a01f0aa8cff0,
    0xbfe7c056b67471f8, 0xbfffecefe14bb759,
    0xc00129cc4111906c, 0x3fde4b35c84ac0d2,
    0xbfd2b973346c1110, 0x3ffe9213f73f861c,
    0x3ff3f4416d18446f, 0xbfe00d53e22e3a9a,
    0xbf846d3194905980, 0x3fe2f390fa98c8d0,
    0xc006ad1d01e7223b, 0xbffa4be46d0af6f3,
    0xbfb95d96496c5fd0, 0xbff10e053ff64237,
    0x3fed9e0c3c4c8a9a, 0xbffcbba670d7ebcb,
    0xbffdbdecabf7a535, 0x3fcb2a4e69036dd6,
    0x3ffd9aa4ffafc0ea, 0xbffd8121246479a0,
    0xbffbe4b82c536f8d, 0x3fddf37dfd98c8b3,
    0xbfe48fdca90cbcfe, 0xbffc1b7d58a5c566,
    0x3fe3bea5bcff86ee, 0x4010a472dbb92297,
    0x40042f8a4da3bb0c, 0xbff68bda0aaa9d28,
    0xbff243d4da38e2d9, 0x3fd01c8d5f8f88ca,
    0xbff1e14dfe9fbcb2, 0x3fef513443c10e73,
    0x3fe838735c6fbe3a, 0xbffcf1486c6aed40,
    0x40074f7b75c7bfb8, 0xbfe5028a7931477d,
    0xbfecc890111a813c, 0xc000cb914ebc5068,
    0xbff8e109c24d23b0, 0x3fe20c70bb2c27cf,
    0x3ff97b2dab0417d1, 0x3ff15b7e6dfd18ab,
    0x3ff19dd78fe14ba9, 0xc000e77ebdaaba68,
    0x4000acc75125dfb8, 0xc00a0946ea11a4d9,
    0xbfa91e50dd52134c, 0xbfc2d673d0f9a738,
    0xc00f7db9db26c24e, 0x3ff1443b2bb146b8,
    0x3ffbb22d036d6490, 0x3f8223465f676040,
    0x3fedf6bdd4010cdc, 0x3fce38697fc2a460,
    0xbff253f5b1e7c8aa, 0xbfec09d8f5c652a2,
    0x3feed18c4ab3c39a, 0xbfc0858e06bd0314,
    0x3fd94da0d40764a3, 0x400ee894d3ab53bb,
    0x3ff597e88d972139, 0xbfe1ae9c8ca19e43,
    0xbfe1df3a8bfc5404, 0xbfc0422b7dc147e0,
    0xbfce8984d023c3b4, 0x3fe533c599f5af21,
    0x3fc3f9e3fa1b9be0, 0x3ff432fcb5dff038,
    0xc0051ccd5fc9db47, 0x4002501eb3016954,
    0x3ffd9941789ae998, 0xbfefd79f29facfac,
    0x40084c40c8f6b451, 0x3ffb3b78bc6646f5,
    0xbfe360a4c340e779, 0x3ff38f053d64bcad,
    0x3ffb2ac066c23ee3, 0xc001a973d60d1e6c,
    0xc002ca5c8f72c5e1, 0x3ffe63642ba866c8,
    0xbfe18e081cf810c0, 0x3ff80f2861b8bd36,
    0x3fe8b4c1c3894f4f, 0x3feaeccee41e8ba6,
    0x3ffd3fada454a134, 0x3fc5187ab3a721b0,
    0x3fec3d011facd0c8, 0x3fe27fceeb62cf82,
    0x3fb7206362ba0758, 0x3fe118b4bbf55168,
    0x3ff0ea46f1da6f19, 0xbff47b2bf9ae6c52,
    0xbfdf4f493e22ef38, 0x3ff3f69a47e2fb47,
    0x3ff9dc27e4266b52, 0x3fcb4b199b117146,
    0x3fd89081d55f62fc, 0xbff2dd62a22a4eb6,
    0x3f8577f11abaa480, 0x3fee591e9dc10487,
    0x3fdca5759f4fa37c, 0xbfe2f23e0b7ccdf7,
    0x3ffeed27851cd343, 0x3fe0fa9a8152846e,
    0xbffde1a26a1add7c, 0x3fe47bac3a5d285f,
    0x3ffe8948605b3369, 0x3feac4a0d0d7c597,
    0x4003b6aa097c96e3, 0xc010b6d5e65c2878,
    0x3ff17906b5cba5bb, 0x3ff93186f852e752,
    0x3fe986a9138bfa14, 0x3ffd0a0e5bf0ed04,
    0x3ffc2b2c7b92db8a, 0xc00151a578c0e828,
    0xbfe838e529e37354, 0x3fe6164120def89a,
    0x40007f6831d81ab8, 0xc00271f35facb3c7,
    0x3fb4f258920201d8, 0xbff8dfd9646f55df,
    0x4006f3d8b3627e49, 0xbfed97e13053dcf4,
    0x3f88f01af0989980, 0x3fca85ca9c32898e,
    0x3fe97c0e8661ce62, 0x3fdde3d7aa92ef5a,
    0xbffc600ec6844a21, 0x3fe2a5f99021ca28,
    0xbfd2c870de880ddb, 0xbff7826a23cb0d3a,
    0x3fc865ede0e9c1e4, 0x4000fde17c24d0d6,
    0xbfcb915790f1b638, 0xbfb0ed2df566d378,
    0xbfe073582b16b67a, 0xbff959844fb176ab,
    0xbfe0cbabeb6c4472, 0x3ff7b1f615afa2cf,
    0xbff66b95f9cbf558, 0xc00c996483216159,
    0xbfe35fe1ff2ce451, 0xbff7769b8269da88,
    0xbff12f2589adeb20, 0xbfaf5c1e22e8e7f0,
    0xc003ad51007a736b, 0xbfdc53f1afc2dcf0,
    0xbfd62c756c442c20, 0xc0027146c6295a3d,
    0xc005dbfe4783c5b1, 0xbff6b9961274a788,
    0xbfd9ab2aa494c7ab, 0xbfd7985ae4bc9008,
    0x3fd96b5618c90ede, 0xc003942694973510,
    0xbff7e71e6c24f0b8, 0x3f9d25db2bc8af40,
    0xbffe8a6e7b1d1518, 0xbfbc61c5167118f8,
    0xbfe1e74d77333595, 0x40087b3a19c0165a,
    0x4005619dad723b56, 0x3ff30a04d646eb12,
    0x3fe620f7d0fc13f9, 0x400b23b69a42408e,
    0xbfa661978edd76c0, 0x3fec7790abf20782,
    0xbfdd98bac67b6b74, 0xbff645930f0bbeb7,
    0x3fdaf7aee5862a56, 0x40012e68151a5f60,
    0x4001dffe1c59d122, 0xbff2305251c9ecb6,
    0x3ffe0b5daab47d73, 0xbfe6d36a603fd801,
    0xbfffce465c8de65c, 0xc086621cae230b0c,
    0xc0037795f9b41d28, 0x3fd0d046a8a8d7d2,
    0x3ff28d411e6d45c2, 0xbfe11d2ed6a5cc2e,
    0x3febdb18039a3ced, 0x4006be1c9e04e8ea,
    0xc0042bf02d4d3905, 0xbfe0c9e2258e3697,
    0xc00857776ae9ea0b, 0xbfe04d7f1ac64b83,
    0xbff59269fe687cb6, 0x3ff42a588150bf92,
    0xbff4d81b3e3859af, 0xbfc5d91ed4e1dbf8,
    0xbf8e85b15555e000, 0x3ffe472f06ae94ce,
    0x3ff5a9c01a3c7aab, 0xc00db1d7ba1a5793,
    0x40069ab52a27ec14, 0x3ff21c8cc14acac1,
    0x3ffbca576de963e0, 0x3fdb5620013aa179,
    0x3fe7b5472a6b229e, 0x3fcb872aee0d88c0,
    0x3ffb047d29fcddb7, 0x3fd534d11505cdbe,
    0xbfdff2fdc04d03f6, 0xbfdf6e3fa65813aa,
    0xbfeacb3fcf8aa0fc, 0xbff2a5275c3d18c6,
    0xc0082bfc51d24796, 0x40076144e7e59ab4,
    0xc003e2ac85392f15, 0x3ff6acd585349947,
    0xc00a7f4f09771832, 0xc0004a90943d9a8b,
    0x3fe467e1fd28862d, 0xbf9f7f3628d6a500,
    0x3fec04a2059f41c2, 0x3fe357b3912b2542,
    0x3fe990c8497caaab, 0x3fd03bff2242f14c,
    0x3ff7b75e6c044dd2, 0x3ff1fe1147ca628a,
    0x3fef0d14e994e6f1, 0x4003e2439e70150a,
    0xbfe17adbf18a2260, 0xbfe761ad9f75fd9a,
    0xc004942284f6ded8, 0xbfb3006ffd27c7bc,
    0x3fde4300811466f3, 0xbff9a33f62b7faa8,
    0x400337acb3aec66e, 0x3ffffc968070014c,
    0x3ffd389dac704687, 0xc011793afe53305a,
    0x4013b6fc15c4479e, 0x3fee286cbf9c225c,
    0xbff1ee541f8767b6, 0x3ffb3011ee3b2cba,
    0x3fb3345fef43cff0, 0xbfeb61388bcd3ece,
    0x400bf10a2ba0ad0c, 0xc00d17481c7e8afe,
    0x40031a84b5f992c4, 0x3ff3a3e46a63233a,
    0xbff97c936aefde8a, 0xbfb718020fde5900,
    0xbfd33a2f95721c2c, 0x3ff943a78b7a8115,
    0xbffa6ab45a1bac2a, 0xc0045183301f2de1,
    0x4010c9e7b229f01a, 0xbff472569ba88658,
    0x3fc1ebe080c0c7bc, 0x3feeac53e5d6750e,
    0x3fc6582c70baab88, 0x4003641c4040b8f1,
    0x3fe921aa030acdca, 0xc006f3c5080f6730,
    0xc009e206bfb8aa7a, 0x4003dd7aca3a9930,
    0x3ff07fa3e0039d16, 0xbfe061e84bd179c2,
    0x400557fc3183a12d, 0x3fe62c46c611ff38,
    0x3ff8cd0d5d165d7a, 0x3ffd463edfd09021,
    0xbfe9351abd5427e5, 0x3fd3b58e16287266,
    0xc00e125934a5988a, 0x3ff52ce03c3dcdac,
    0xbfe4704bcf0c5a38, 0xbfb8d54081c94498,
    0x3fd9b7e3e25d8ed8, 0xbfb9a45ce4dbbe04,
    0xbffa9ff8701e2d94, 0xbfee78d0e6c3d8f9,
    0xbfa14288a51a5538, 0xc0004ff0b604e358,
    0xbff8dca0151e4574, 0xbff3520648731adc,
    0xbff362f8fc302a68, 0x3ff2eb74e95ccbb2,
    0xbfe36ce9d3468b04, 0xbfe34144fbdeb834,
    0xbff5b3e98cb29aa9, 0xbfe957fced062f38,
    0x4006b02ee2babb22, 0x3ff5da182ec26ce6,
    0xbfe1e4b1e5e12635, 0xbfb02cc96a702e20,
    0x3fed4fa5211c9c9e, 0x3fb38473a0d81bc0,
    0xbfee7df494405d0f, 0x40021df316b881d5,
    0xbf99d2d7f2d00ae0, 0x3fcbb5bb080de0f4,
    0x3fe93f7e8d7f5798, 0x3fffd5cb45bc95de,
    0xbff5ca4a71bf60fe, 0xbfd60f646633a35e,
    0x3fd3b0ab7cf2740b, 0x3fc03854840b202e,
    0x3ffc60d1b968ae28, 0xbff189bed5f8f87b,
    0x400102cbb5454045, 0x3ffec057e6945f46,
    0xbfd05c8569ff6666, 0xbffa89d7b0a2b4f2,
    0x4005f0a610869852, 0xbff5b0a44c842290,
    0xbffac4b8faf3700d, 0xbff3fcd2b4920236,
    0xc009b8ab885cad00, 0x3fcfbd5c96986f16,
    0x3ff2aea1c007e934, 0xbfeeedcb36e9839b,
    0x4005be48b8122140, 0xbfebcd4b733025d5,
    0xbff7a796b0b511cf, 0xbfe123473b423d12,
    0x3ff622bf9db44523, 0xbfd0c646647d5f44,
    0xbfc7e0ae4f92a4f8, 0xbffd75654ec75842,
    0x3ff17c1061215fdc, 0xbfe367be0de2a419,
    0x3fab4cbd947e8178, 0xc00f7a6aacec0304,
    0xbfec334e62ce2437, 0xc00975d84cdab7d3,
    0xbffa2e3e0df79728, 0xbfe5acf0debf8d35,
    0x3fe4b4e244c8f60a, 0xbff08474e21864c4,
    0xbff4e162fc24f757, 0x3fca125d759c7584,
    0x3f9ddb88acfc38c0, 0xbffe1b384eb72ef4,
    0x400730c9a6a381b2, 0xbff6543d09063291,
    0x3fe0cc5cb18a029c, 0xbfec4fca35449481,
    0x3fe118cf8d4490b0, 0xc001c6425cb669c0,
    0x3ffbf10c3073f430, 0x400a28e6259f5b3c,
    0x40031508fe4987d4, 0xbfd0983845e149e2,
    0x4006a043663d210c, 0xbffa1bcef2bd4255,
    0xbff522281326ed86, 0x3fe8713ee900103c,
    0x3fb65bd145d26c3c, 0xc000454d08f767f2,
    0xbff3e8cd1fbf7a80, 0xbff1d8e64eedfb11,
    0x3ffbd9c9b65596fc, 0xbfed16614af1c77e,
    0xbfe851a3b5f9ad68, 0xc01326d27b15cd6e,
    0xbff12402b824169e, 0xbf4c811460152000,
    0xbffda69e66fa0fd8, 0x3ff3e0de98e4cad0,
    0x3fdd97fa4d78dbfa, 0x3fa9ffe459539050,
    0x3fe7f18e9a3dfa5d, 0x3fdfed6f46b8e680,
    0xbfe9af21fcdbfbf6, 0xbff010a0b86c2220,
    0x3fffb9a7810fef42, 0xbfeb8710d042c2b2,
    0xc00de447908fb19d, 0x3f8424635955f620,
    0xbff0f20cfa89a35f, 0x3fe800bf37564d25,
    0xc0027db2a9fdb81a, 0x3feab5dd036143c6,
    0x400b73762cccf972, 0xbffcfc9489605863,
    0x3fc8843c1714e2a8, 0xbfe9496ab4198aca,
    0xbff1691c8063a8ed, 0xbff57c612011c132,
    0x3fce0f76b39d8727, 0xbfd15e797ece57c0,
    0xbfff71b28db77262, 0x3ffcea0eee2f6899,
    0x400131cc1804a6b2, 0x3fdb602382619cc1,
    0xbff5511fb65726fa, 0x3ff9322d0ad673e9,
    0xbffd17f3606fa636, 0x4000e30556c47160,
    0x3ff7921b99c8e2dc, 0xc0011bd586e5dc8e,
    0x3fb07d3ee57fe430, 0x3f8bde2c253b8600,
    0xbfb480aade3a5a90, 0x3fe5b51baeed96fe,
    0xbff822a69c7130e2, 0xbff3d4bd0540d798,
    0xbff93067daae886e, 0x3ffe4137567f9e78,
    0xbff9e7bcd722239a, 0x400b78303725e7fd,
    0xc0066b81d0a7ebd7, 0x3fed1e60b4f7bfac,
    0x3fc26aa661e18b18, 0x3fecd60bfa274cd7,
    0xbfdf9a12815ae898, 0xbfb854924840e514,
    0xbff4805a4fade0cc, 0xc008f9873458b173,
    0x3ff1f78ef78132ce, 0x40025ea046d424da,
    0x3ff5ee906e8f0698, 0xbfe6b44f7a016241,
    0x3fff77ce3352b431, 0x3ff78ee54a56f4be,
    0xbff7f6176133751f, 0x3fed6271caee426a,
    0x3fe19cdea924f260, 0x3ffa8b0e2570519f,
    0x3ff6ec2705709d9c, 0xbffa4e7adfa2049b,
    0x3ff01025bb5eade6, 0xbfe468ed593b05e8,
    0xbff9e698fcaef568, 0xbff8d83891065d3a,
    0x3fd2cdc43eef2072, 0x3ff6c84bcd9e2b1a,
    0xbffca29f3b7b51ab, 0x3fcff5eadb03d6f8,
    0xbfe382429b5fffb7, 0x3fe57f52204e0d84,
    0xbfcaec617e956fec, 0xc00b7f5e7dbb66ab,
    0xbfd519c76ac6d1b7, 0xbff0ae1ac76595a9,
    0x3fdc8a9cb6edcf48, 0xbff006e6a4af786f,
    0xc009e482052bfff7, 0x4000b061f4f95de4,
    0x4001af84e3344ab5, 0x400a96b0363e700e,
    0x3ff09f36e51128eb, 0xbff6ac338a4c7c8d,
    0x400fb5b25aae477a, 0xbfd77a3a0ce26b14,
    0x3ff6f4b55e891160, 0xbff4d0c0cebf047d,
    0xbfa0ca21ed51a8f0, 0x3ff530afa24f6d94,
    0x3ff82e7898247d9a, 0x3fd28da9db480ffa,
    0x3fe7d786c108edd8, 0x40020b6b45f759a4,
    0x3ff955e30928f4f0, 0xbfeb36265fc57d42,
    0xbff6b4063fb21846, 0x3fd2f4a32764c7a8,
    0x3fca541da11c9409, 0xbfe1f3ee3e6591e4,
    0xbff20fdcb69aa59d, 0xc011234ec3a7af1f,
    0xbff7ca2157a8a7c3, 0x3fe38daf6dbb0f82,
    0xbfe07a3952a9a779, 0x3fff05502ec0d672,
    0x3ff69fa2017f02d8, 0xbfc210fcf7c89ecc,
    0x4002d2746595384e, 0xbfc843250895cd64,
    0x3fd19b367546ff22, 0x3ff4029fe777122d,
    0x3fe3b7b37b493d76, 0x3fbfe34e0d24154e,
    0x3fff33e955cedcf2, 0x3fd046b5a2570710,
    0xbf855bc3d02a7d00, 0x3fc731f773b6ba10,
    0x3f90b8ab37908f20, 0x3ffa4b622a818ecd,
    0x3ffa07b8e7ddb6f0, 0xc005d7e06f60ffe0,
    0x3fe56462d3ef1926, 0xc0144cf2d5f65334,
    0x3ff1d858b38b2112, 0x3fe80c3f7ad48a19,
    0x3ff4d5c3b594ca22, 0xc00089cf559bd64e,
    0x3fe400b0a22ac75b, 0xbffbc59446ce08a6,
    0xc006cf3510a23ae7, 0xbff764c1912d4c97,
    0xbffc177dbef329cb, 0x3fe9016d48be7c0e,
    0x3fe557e0686cae0c, 0x3ff284fb1500b4ee,
    0xbfd727d9e7c6f3da, 0xbfeb95c4c3cf5ff0,
    0x400904b59774bbb6, 0x3fca70d30e0861e0,
    0xbffd9ac24aed8090, 0x3ffeec5a83d44f84,
    0xbfe2b0fb1346d26d, 0x3fc911181bdede70,
    0xbfc90d29b0ea06a0, 0x3ffcea1f5083a02b,
    0x40039cb2e688ed98, 0xbfbe8ed06935d0c4,
    0x3fdd3d0aeb4a27d4, 0x3fb30cb0d4009218,
    0x3ff5e084c83be079, 0x3fd288fb3b21b414,
    0xbff0cf7662b74d6a, 0x40040d44fadf01ac,
    0x3fb0db2a567dae40, 0xc00572417b907b3d,
    0xbff391cb65e3a320, 0x3ffc66ee080d8083,
    0xbff64d3daf149b10, 0xbfe467a91ef2d0c5,
    0xbff4e60445c2a796, 0xbffa3cb99c163312,
    0xbfd7e12c6c38e65c, 0x3facbf5d2b1023b0,
    0x4000f0493b02e0be, 0x3fb917930bbb0248,
    0xbfddd6a23f855530, 0xc0056925c09f7690,
    0xc0020401cc7d1d78, 0x3fe719a988750516,
    0xbfeeeb95e0bb177d, 0x3ff2f5068e19c6e7,
    0xbfe421375c045628, 0xbfe5e38b30866f67,
    0x3ff9473127ef152a, 0x3fe1972501c88693,
    0xbfd3b52f1a3c7294, 0x3ffb360c421d3c56,
    0x3ff56d653e3810d6, 0x3ff9deaf1d2f98a0,
    0xc00148c0bc82b3de, 0xbfdba6357c5c22ee,
    0xbff8b72f27a36a3c, 0x3fd6f2ae4f25131a,
    0x400cc07edb6db22a, 0x3fc3604ccf8c202a,
    0xbfe1fba4bc78e3c8, 0x3ff69b96e7ebce76,
    0xbffc2aef6341228c, 0x3fae912ae2dceee0,
    0x3fe356a95f5f6436, 0x3ff1d89c086ab040,
    0x3ff39caabe11f41f, 0x3fee07dff0af6036,
    0xbff874f5311e1894, 0xc00817b5a2642c44,
    0xbff93534632d3304, 0xbfd857b12ed21ede,
    0x3ff681fe383054a6, 0xbffbc1fd7809dffc,
    0x4016e05b76882a48, 0xbfe5916719f59e64,
    0x3fcbfcc9f52ad500, 0x3fd5bb29cdcce126,
    0x3fe26e7e8073a2fa, 0xbff36c3fc06bd450,
    0xbfefb134826ad56c, 0x3fe41c44930f8f6f,
    0xbffc6e05ab11c8d1, 0x4003a543dfad928c,
    0x3ffc005b53314878, 0xbfd4409994e8bc74,
    0x3fd590c9b08e28c2, 0x3ff6ddedc49df1a1,
    0x3ff1c66c8e30ea4a, 0x3ff1f158ef2f1711,
    0x3fa74779cb080280, 0x3fe0f5610babef88,
    0x400ee355707a6d80, 0x3fff0f93fd3db7b4,
    0x3fec699ac69bd6df, 0x3fff23298da49593,
    0x3fc458dfbdde99d8, 0x3fec5ec65307fbd7,
    0x400f43ec91accde5, 0xbfaa37a1b7800db0,
    0xc00685d9f76af322, 0xbff417bf1b9631f7,
    0x400a638c1b461dde, 0x3fe49dbd345a451b,
    0x40009b18a9b32fcb, 0xbffd8e6dc32c98c4,
    0xc002f9b80e3aec0d, 0xc01323c83e589ed6,
    0xbfee4aba1764a50e, 0xc003dae423e715fa,
    0xbff5a64e2ac6e604, 0xc00f51f01a7746c6,
    0x3fe06dbb7d27a35f, 0x3fc52193502955da,
    0xbfed77c2bcfad2e6, 0xbfdbe050f9e0ca63,
    0x3fead0d65a4f5d3c, 0x3fff0bc0e62195b6,
    0xbfd4439ffccc0274, 0xbfde1256237f7322,
    0x3ff213c3924a0692, 0x3ff2ab72846d0a97,
    0xbfdaa09e917d7e18, 0x3ff21081caed5b63,
    0x4000ce41a764a65a, 0xc001b0e43319a676,
    0x3ff90654293300c3, 0x3fe0983acc0e1248,
    0x3ff4b4079583ed4b, 0x3fe720e332f43d89,
    0xbff04b77c353ac99, 0x3ff0f03f087a4179,
    0xc00b4b5053fa9861, 0xc0010d5015b78da7,
    0xbfff1b70a78689cb, 0x3fbfdc1ce9a2fe6c,
    0xbff13b166a74c7f4, 0x3fd31c0248164e6e,
    0xbfe50f212952adb1, 0x3fe4ef9940529cbe,
    0x3fe644081f9c2cdd, 0x40028cd881d3e409,
    0xbfa19ad11524c000, 0x4002818c0348182a,
    0xc001669348aba292, 0xbfd70b98c1ae366b,
    0x3fc0ca38807cbcf0, 0xbff49b36013977d3,
    0xbff60a9cae40c6f7, 0xc0086629975a90fa,
    0x3ff9f752933f1c31, 0x3fed2e72287ebe0e,
    0x3f9da21ce57b2a40, 0x3febb877969b1722,
    0x3fdfbb214057f800, 0xbff8287094b1e3ec,
    0xbfee6f5b20c6eff6, 0x3ffb99be46fd9b9d,
    0xbfe22205ae106978, 0xbff3fa13daa6f53a,
    0x3ff06c89c6cb11ae, 0x3fe4c2c2ab0f2c88,
    0x3ff395178eeba088, 0x3f95c71b41483c00,
    0x400716dbbaea0d7a, 0xc006bfabb229b9d2,
    0xbfd62796039ad356, 0x3fefc04c2f9d5f49,
    0x3f9295fd551cd5d8, 0x3ff7158f66ba897c,
    0xc00015eedff1a4d8, 0x3fba7dbc7ef84af4,
    0xbff5c19814d499e4, 0xbfd74f1f355cd9b3,
    0x3fd7ded66915af18, 0xbfe4398da7f88d7c,
    0x3fde63d07f2f0bc4, 0xbfe4c2a61b35d876,
    0x400a739255b54481, 0xc00b4a92e58f94e7,
    0x40074955c5a2d907, 0x3fe42b5989c7621d,
    0xbfed6e4671a2f13e, 0xbfb86dc107ca3188,
    0xbff32726ae7007f2, 0x400592b352746e91,
    0x3fe917488e83f092, 0x401848e0eb1e0ab4,
    0xc007cb369a7c89f4, 0x3fe7a4d6d61547aa,
    0x40080cc39df58e2e, 0xbff4a3bcd736bea9,
    0xbff7e07f1104e8ea, 0xbfd9cb34686e7042,
    0xbff1c8cdc462ce12, 0x3fff676e307bb5b7,
    0x3ff47ceecb9eb1c6, 0x3ff0f736a9122abb,
    0x3ffbba867d318c4d, 0xbfe141c581257d00,
    0x3fcdc579074c086c, 0xbff05e3663f8816a,
    0x3ff71413ee3d0a91, 0x3ffdee24ff153f1e,
    0xbff65c6dfedf8b14, 0xbfe06be8b14b8dcb,
    0xc000643aa263ba39, 0xbfe8887aac7e1fe4,
    0x40012fcb1ef5a93e, 0xc000d0b78e1c3dcf,
    0xbff06873b80dfa0e, 0x3fcad7c6feba0820,
    0x3ffebfb092aa7e2d, 0xc001975516f75c66,
    0x3fd8e48a97602fdc, 0x3ff58250826eed98,
    0x3fedd030831fa9e5, 0xbff20dd6469ba450,
    0x3fe8841c1eab89e4, 0x3fe9b73042827f84,
    0xc004e3c5032f3bf0, 0x3ffbdf8a8a201964,
    0xbff51f021e03530c, 0x400074c06860c9ba,
    0xbff413ba8a13d4b4, 0x3ff3d3e10b00d0f9,
    0x3ff457afede5f6c3, 0x3fe90b4249ec7668,
    0x3fc621261484ae2a, 0x3fe2ebf525a3f9f6,
    0xbff78799387eb0de, 0x3fdbc5a3e9239cf8,
    0x3ff2dba833cb998c, 0xbf7b6472bffc6d00,
    0xc0080a32baa5fe3e, 0x40081f99a5a15967,
    0xc002d1f5cb12bf24, 0xc00e53ab6ee66d2c,
    0xc0029ea33295ee28, 0xbfff209b3eba836c,
    0xbff0f959c3f430ba, 0xc00778a656117bce,
    0xbfee6401ffed48aa, 0x3fd6f88204902db6,
    0x3fad97eac98c29b0, 0x40075d585eb4cbea,
    0xc00274505992451e, 0xbff74d295ec34047,
    0xc00ced17a3158c81, 0x3ffc8c088cfcc798,
    0x3ff2f1a3bc48dced, 0xbff3b147c35fc330,
    0xbfe2388aa3df92ef, 0x3fda9f93df3941ac,
    0x400130d18119f55b, 0xbfe36645dbfea346,
    0xc0022085ef34d2a3, 0x3fe264ba76b48537,
    0xbfe7be60afd25ad6, 0x3fe2fec7c036f094,
    0xc001838faaa602bc, 0x3fe0bf8f72e80fa0,
    0x40120ecbe5987581, 0xbfe8da2f128ef03a,
    0xbfc6110443722f90, 0xbfff82175ddba2de,
    0xbfd227f5443fb33b, 0xbfce626ba69d288c,
    0xbfe2f352f1f016ff, 0xbff16e288d6db0bb,
    0xbff19d4bdf0505e7, 0xbfe39a42dd1bc658,
    0xc0066506bcb5cec6, 0x3ff0c116036ed750,
    0xbfd3e97982837437, 0x400030bdd4144e98,
    0x3ff58d8c2228a8d2, 0x3ff91e75aba3d504,
    0xc00132534fe5c918, 0xbffc29235efc08e5,
    0x40041e3b6aaf5783, 0xbfe93b8f75110df0,
    0x3ff282bb85865896, 0xbfde6140e8c15e24,
    0x3ff1d10512660147, 0xbfe13a8cd43c4384,
    0x3fa2eed1ecf40c80, 0xbfc306a105985c60,
    0xbfd602a92d9b7c08, 0xbff93ab7a63e3809,
    0xbff45df97ca853f6, 0x400343ec4129c5d5,
    0xbfdbe26cf91ee4e8, 0xbfe77daa8d3af5b3,
    0xbfc6d3baccc251c8, 0xbff279ae06b9bd59,
    0x3fac0bd7954c8900, 0x40046e16a1820cba,
    0x3fe764f738c53bae, 0x3fef6e28714b8ccd,
    0xbff6e31646128c62, 0xc002e796fc792c6b,
    0x3fed2a6b1d0f4b24, 0x3fe63726b7d195f1,
    0xbff2eab1e787e2c3, 0xc005191d3a464e84,
    0xbffc4a2f6268350d, 0x40005f6bf094e020,
    0xbfed4dbf18936ada, 0x3ffc9eb3ff071841,
    0x3ff003233d0dcd44, 0xbfe976ce3968e2be,
    0x3fe6eee4a7e7d67a, 0xbffa59870075a818,
    0xbff09847036b3085, 0x3fea14d834996146,
    0xbff778bcf01abd7a, 0xbff5b447e7d619f1,
    0xbff292a86c1b400a, 0xc00864bd8d9782d2,
    0x4009900008b28964, 0x3ff89d9e5b410046,
    0xbfd817bb6a9197b0, 0x400560db3473b222,
    0xbfea4e3f7a790aaf, 0xc0027be296b5caf5,
    0x4001afca18092fb2, 0x3ffa7fb1ad2e1f22,
    0x3feaca5c34d0f110, 0xc00101097841cad6,
    0x3fdf4e6d57c697fa, 0xbffb23b5f7dd20d3,
    0xbf91fe7266714350, 0xbfeaa7bfa0808393,
    0x3ff54bda0258fccd, 0x3fd55dc0d5573cb1,
    0xbfe7e38503b5b66a, 0xbff71e3abef49e32,
    0xbfd65065a7d038e4, 0xbfe45cad42ad0edb,
    0xbffddd67142cd490, 0xbff6446d3b7481fe,
    0xbfcb1451e7c301e4, 0xc0010501525e1e07,
    0xc0011615e1839965, 0xbfec650d02aebf7f,
    0xc006dd0d158320c8, 0x3ffbc76a788ff87b,
    0xbfd90625f1fa601e, 0x3fd6c2f13f7696a4,
    0xc0012394436dc7b9, 0xbfc20abf1d5fd6b0,
    0xbfd177dfff040fae, 0x3fb2367cc8d7d960,
    0xbfd72d2d49bb18f2, 0xbfee2dfa8f6943c3,
    0xc00168017bc3b067, 0xbff3508306d2cd6b,
    0x3fefd310fac86f07, 0x3ff78d44c86bffd6,
    0xbfe0e6bb8659c27e, 0xbfe3ce34f6d969aa,
    0x3fd768711b1b1eae, 0x3ffd452a165f2aa1,
    0xbfffb2e04509dfb4, 0x3ffcedd5b696fa93,
    0x400645dedff4ca08, 0xbf8db6c832064280,
    0xbff37baaba0e2166, 0xbff42b97f40b0980,
    0xbfe7d5a11310e4d5, 0x4005a9a00ebe60f8,
    0xc00acff017db9a8b, 0xbff44758b85cae4e,
    0x3fe53c0928f9b1e4, 0xbff3612f9955847a,
    0xc001c60612e86065, 0xbfef11bb43dae11c,
    0x3fea6e82530e652b, 0x3feb0e769e0c1756,
    0xc00489ea5031e3c7, 0xbff6807502d83255,
    0x400340d7795f671a, 0x3fe18e484d697d1b,
    0x3fdcaf55ab015aa0, 0xbffef8ba165dc75b,
    0x3fb4b8265c4257b4, 0x3fe6e5dc02739411,
    0x3fc1172c335fe200, 0xbfcadce0c684ee20,
    0x40018f03bee2fbb7, 0xbfe029309414949a,
    0xc0090cfca0766502, 0x3fe6528428520a7c,
    0xbfe29e7806506dd3, 0x400284f1b84788ce,
    0x3fb416123098c7d8, 0x3fe6c51c6b6e81f3,
    0x3ff624b4a654168d, 0x3ff7e37412568a94,
    0x3ff7e5312385a364, 0xbff5da51ad3b6455,
    0x3fc49cf2c080cb68, 0xbfeaa8df341af3f2,
    0xbffb4a2456d8fd25, 0x40023a9c19d8d168,
    0xc00558d477403c2a, 0x400280aa7f8d435f,
    0x3fedb78b3f7d97de, 0xbfe4437dbf88b8bc,
    0xbff350c0481ed79b, 0xbfdb9657f972ecae,
    0xbfe81ede88103ffc, 0xbfa2697ae6f53330,
    0xbfe3f00dd20341ea, 0xbfe2bd271373b54e,
    0xbfeb7c1e45d51b06, 0x3fdcab54a48d7b6a,
    0xbff3de0201e7ec5a, 0x3fd19068b8931fe6,
    0x3ff3bb6f9d8e4a12, 0x3ffb24da8f3efa3a,
    0x3fdb4c309c22fdf8, 0x3fef5a4e4c2ac2b0,
    0x3fdbc9038ff75f3c, 0xc008e09bd90cc3ae,
    0x3fc66450fe61aec8, 0xbff06fe6762d63ca,
    0xbfe2844e401db330, 0x3f8f7894205b2300,
    0x3ff085decdc95dd0, 0x3fe903fef786cede,
    0x3ff65364a5714ede, 0x3ff7fba8022e4cfb,
    0xbfe82841bafbba68, 0x3fe199c73d233d85,
    0x3fe82efa47c8e63e, 0xbfe97eff5c471e35,
    0x3ff00365fda41240, 0xbfe77d8873919052,
    0x3fe8f70fdc9237bf, 0x3ff6ab6b2d155aee,
    0x4004e27ea7603980, 0x3fe4615a4f021198,
    0x3ff00bad0c7895a2, 0x3fd8bade9778cade,
    0x3fe1434125f44f24, 0x3fdb2616eb88051c,
    0x3febc7d95ded924e, 0x3fdb3f5ba296d2ed,
    0x3fda0485a1c1d4b5, 0x400678aa84ec00ec,
    0xbfe992db85fd7934, 0x3fddd84a930029e4,
    0xbff22a8d9ada5adc, 0x3ff5992f27098c9c,
    0xbff22c3849416abc, 0xbfcaf1e7ebb311a4,
    0xbfe1b23a8f5ed262, 0x3ff09a3448cc5062,
    0x400c35ce985e9aa9, 0xbff8b06a53c7de32,
    0xbfef59c465543a3b, 0xc000831cce427932,
    0x4018fc992c24b60c, 0xbff0d831b088be3c,
    0x3fbf88377e83cd98, 0x3fe03a9f64da63e5,
    0x3fdd670b8453b0cc, 0x3ff989d28d1fe2e8,
    0x3fe327d7c0288370, 0xbfdfc6ade66add2c,
    0xbfdd094ec9ee3d72, 0x400a34fe501db972,
    0xbfcc8ae2a162cb54, 0xbff24f078c0f564f,
    0x3ffb5035a717a0ac, 0x3fd49fcda289377e,
    0x400457cf161b39e4, 0x400101739dd0375b,
    0xbfdf0661a28b2d4c, 0xc00072a8523028a5,
    0xbfe04dc88a0706fd, 0x40049b64b8b89f32,
    0x3ff62fd8717c653d, 0xbfefbc6027dd9c96,
    0xbff7506e3744d588, 0xbfdbc9f830b07d7a,
    0xbfe3aa1312d706f0, 0x3ff72fcf68585a9e,
    0x3ff23cafe65aec43, 0x3ff8b01ead8dd308,
    0xbfdebd85c13398f9, 0xbfd25ff35db8dab8,
    0xbff9d1390d2cb2b3, 0xbfe958f5ca82f3ce,
    0x3ff629303816406e, 0xbfdfdf9ac252cfa8,
    0x3ff1f4449b10e05a, 0xbff18af9bea39496,
    0x40029dc92d5894c2, 0x3fd6afb6572c60fc,
    0xbfe1be085a3cf7e0, 0x4004cda50694f190,
    0xbfe79ebfe2f9ecfd, 0xbfba82102cfb7828,
    0x3ffed2e19dc73271, 0x3ff2c0ad8e589526,
    0xc00b318186f4a83f, 0xbfd5abaf6bf730ac,
    0x3ff0396d23db3a06, 0xbff9ac20c576f6fe,
    0xbff8a34dd41125e1, 0x3fe36c634f53df67,
    0x3fe0d7538c56aa84, 0xbfb6296b22414cf0,
    0xbffb9743be70b050, 0xbff3a9f32f6f0b92,
    0xbfffe26f77c307ac, 0xbfeec9f65e633de2,
    0xbfc0d420e2044ef2, 0x4007a0bc40474a17,
    0xbffe261eec2ff144, 0xbff6d9717d54988c,
    0x3ff23921b8e0bb6d, 0xbfc115ca0f828b58,
    0xbfbbf8d2eca0cd6c, 0xc00424a3a9c4f1e8,
    0xbff3387e10dd6322, 0x400ec7d4c74ba0f4,
    0xbfd2f3c90f5c3b9c, 0xbfe4720fdfb91dfc,
    0xc0096f39f7abdf7e, 0x3fa63daf33dbc800,
    0x3febe6a2bd0e6c3a, 0x3fe20d59e330a3b9,
    0xbfe68a452bcb1132, 0xc0027f121aef25ca,
    0x3ff3c68b92f35536, 0x3fec073f2420f350,
    0xbff9e2edb55866b0, 0xbff4f4dbea7cd2cc,
    0x3fe50be6efa661da, 0x3fd46a180bb11464,
    0x3fef0a3e14144916, 0xbfcaf1efd6e016a8,
    0xbffdf16849c9c9ac, 0x3fe7af3ddf7d3066,
    0xc009870c704b1149, 0x3ffd1d9167b2d0b0,
    0x3fe3ca1aec9ef9c6, 0x3ffcfa77009a7dae,
    0xbfdc770da16937b1, 0xbfc6b0efdc45f30c,
    0x3ffd47769743519c, 0xbff8346379ca28a8,
    0x3ffd76ec340b1802, 0xbff7667bbb6e86da,
    0x3ff94de9bee5b8c3, 0x4006206aa6d90529,
    0x3fc44a6b003e619a, 0xbffcda5eafe75584,
    0x3fc4a2fcf882f930, 0x3ff8683819e36686,
    0x400228a750cdbcb2, 0xbfb838b09a6091e8,
    0xbfd6fedb2fd77514, 0x3fe1dcfc4ce0b513,
    0x3feb2ce0252249c4, 0x3ffb9c67d1661466,
    0x3ff0df6d222413c8, 0xbfe195520515a570,
    0xc0053e4e9f999819, 0xbffc7f3cd63c693e,
    0xbfe73e2be1c8c758, 0x3ff3ce66f2b148d4,
    0xbff3f57b2cf60fc8, 0xbffec368ff307f66,
    0x3ff72736e3e84e71, 0x3fdf09526675bd50,
    0xbfe53eb2a4aa9bb3, 0x3fdc8f166d556934,
    0x400b38116e5d5a61, 0x3fee29d19b609e6a,
    0x3febd784eb6181c0, 0xc009e6fa9ddf98ac,
    0xbff21315d656cc3e, 0x3fbe52923fa71e98,
    0x3fd1ccfd9601f406, 0x3fdb86f0c0013190,
    0x3ff23947d39d018e, 0xbff052d500760b9e,
    0xbff34a0d320c4086, 0x3fec88e60a81cf5a,
    0xbff4c2be5057b01a, 0x3fe2c8eb0d821ce3,
    0x400e1f99b9329575, 0xc005df8634e941f6,
    0x3ff78d1670995eca, 0xbff1778c8d5c9271,
    0xbfd4b034fce982bc, 0x3ff76c0d739c1f3a,
    0x4000a386e819caf0, 0x40006f11f8aaa904,
    0x3fd9484ce812cf37, 0x3ff73b29fac4efe2,
    0xbfc5483735bd43f8, 0xc00a17db6cf3f7a2,
    0x400065d17fe358b6, 0x3ff78b39acd60a21,
    0xbfafb9f92df293c8, 0xbfc46e802f9e4f60,
    0x3fdce64283b952a0, 0xbff5f89aca4d14a8,
    0x3fd1118a26dd88f6, 0xbfe6992741b405d0,
    0xc00da77d3aa1cc4a, 0xbfea3dfe2bd73c72,
    0xbffe7ad202b9ddf8, 0x400d9b980aee39d4,
    0x3fe9f78135859014, 0xbff4a7da064aeb91,
    0x3fca48eaeb46d918, 0xbfe768f36231568e,
    0xbffb5ddeee8d847f, 0x4005c04f44d208b6,
    0xbff85eaf992c8266, 0xbfe320282b97e5cc,
    0xbfe8ad4236fa1394, 0xbfedae08b72a79a4,
    0xc003a9e22ea28e6e, 0xbfbc5ca912b26a60,
    0xbfd76ee1316ed9d1, 0xbfefa8f731733d5d,
    0x3ff49dd6fbe700a9, 0x401111713a51ba08,
    0xbf9c2bc1a4781280, 0xc00481f0c673dec4,
    0x3feac531122a55b2, 0xbfe3170fb1f352d2,
    0x40029ed73c954e9f, 0xbfed544c1ff656dc,
    0x3ffb6302d1386d04, 0xc00460818ced306c,
    0x40038f2f3e946bab, 0xbff2e4bccf47cb1b,
    0xbfdc51c20e138810, 0x40035e7800a694cc,
    0x3fecf07da35646c2, 0x3fe8abb28aa84f83,
    0x3fc1d0a823669c62, 0x3fa913e86730afb0,
    0xc002dc87781fb672, 0xbff70fe189e5a55c,
    0x3fc2812cfa4f61b4, 0xbffde6770e3b852c,
    0xc00067a126d4f92d, 0x3fdebbfa5e439822,
    0x3fb1436a076cb178, 0x40023981175af679,
    0x400b788e80f8c9bb, 0x3fd83a3b99f5b027,
    0x3ff8037afda9ffb6, 0xbfa476360015a718,
    0xbff16687475aed66, 0xbffc9bb13360bf0e,
    0x3fa90d8f5cd615e0, 0x3ffc20351c46de3f,
    0x3ffa9d6c00024732, 0x400050cb090c3e51,
    0x3fe6060e054c1852, 0x3ff8e7706510773e,
    0x3fe4af6ec58dec0d, 0x4002e33952270482,
    0xc001512aa8e8552e, 0x3fcd09dac3987b30,
    0xc004ff4b53e19403, 0x400140bd2243cdf0,
    0xbff419839d429d62, 0xbfeba7969e3db09a,
    0x400a616177c704bc, 0x3fdb0d22f9742716,
    0x3fb0723acebf8298, 0xbff5b338ad583d32,
    0xbffba5d3fe69d600, 0x3ff45f84a433f398,
    0x3ffe57a5a388c7d8, 0x400144173570830c,
    0xc004a49fc4e0100a, 0x3fd0a38e1e435aa7,
    0xbffbbf7f7c7104d6, 0xbff1657f57023b69,
    0xbff45074bf7a947c, 0xbfed1ea6c2ca65b4,
    0x400747716a156ba4, 0xbfec6d2645ef1280,
    0xbfe7dff06e383e28, 0xbff7b989894b70d7,
    0x3fc491e4c2522b80, 0x3fe7c69d5eddb65c,
    0xbffddb0646d01907, 0xbff293d034a74f32,
    0x3fc91223fbc0ef28, 0xbffbe8343a41ca88,
    0xbfec96a7bbe75d18, 0x3ff6f278b5efa062,
    0xc0030c2aecd8e3f6, 0x400781c3a859ee2f,
    0xbfd0a6abdba2a1d0, 0x3ff9f913a140d57c,
    0x3fcb4cfd263ee700, 0xc010adc59b3a7c40,
    0x3fea2cdde839167d, 0xbfffeca7c8fe3866,
    0xbfef198795806dbd, 0x3fdbbcf3981f95d8,
    0xbff022849536695c, 0x40098f7da8eee7da,
    0xbff14570920d1e58, 0x3fec342b3a0b14e7,
    0xc0014d63d0fffba4, 0xbfd72bed967534a5,
    0x3fe30d364cd7a22f, 0x3fdf1d10cb2c5958,
    0xbff81a6c48b4c459, 0xbff6666651de4f04,
    0x3fc920e7f0b74d88, 0x3fcda19a8a6cbba0,
    0x3ffbba8bd62f6e46, 0x3ff7ea56e9a6e540,
    0xbfeaf851b46f6ef2, 0x3fe7890183564b74,
    0xbffe0b8f954dbf4c, 0x400789e13d562ec0,
    0x3f5ede7e7bf83000, 0x3fd9acbca0e68cd3,
    0xc00caa9459fc8f91, 0x4004a7dce9ac8220,
    0xc009b66ab24264aa, 0x3fb8154cb84d3fd0,
    0x3ff5eafc70923f80, 0x400be81f2221d006,
    0xbfd33399e8b3c90e, 0x3ff5bec62c8baac3,
    0x3fd1de786e138fc8, 0xbfe13fddce7d72bc,
    0xbfd4fb783b9a60b2, 0xc004bf50f0c9fc5d,
    0xc005f89bc7d1a151, 0xbfff31b6eb740c2a,
    0x3fd3867d9ef54d87, 0x400473af2eecdc70,
    0xbfe4d3f256e003c4, 0x3f97041271df12e0,
    0xbfd4d9a978d3946f, 0xbffc4ac77b56d5d2,
    0xbfd31fd5a62c1750, 0xbfd5aeff3c61dad0,
    0xbff939122599af86, 0xbfe652efdbaa681c,
    0x3ff91904e4093353, 0x3ffad424e654ad69,
    0xc0002e1d8d6e64ac, 0xbfd48eaf92f2bc07,
    0x3ff71bb363b1ba32, 0xbff15ebee223a724,
    0x3fce2d9528f8a9d6, 0x3ff3281f7a9082a3,
    0x3fe0c4200b8c1392, 0xbfda9eef2889eb36,
    0x400ca4de41f7bc34, 0xc002afc3bb069089,
    0x40060bae5f02ea1f, 0x3fcd608f2ac94db4,
    0x400095c67e25bfd8, 0x400878096c4074b0,
    0x3feebf8c746576af, 0x4003e999332dc392,
    0xbfd51e8072a0e7f0, 0x400dcf7c22b2c641,
    0xbfddf6e428c28940, 0x3fe3922cd98b394d,
    0xbff4d9ce7b988a39, 0xc0035bba4a0bb8fa,
    0x3fddd54d017e7e6c, 0xbfd25addd9bea46a,
    0x3fd2ad6ee510b06e, 0x3fe9350a1d4f0970,
    0x3ff73051d454cf2f, 0x3fe70b687d609562,
    0x3ff2f8cdec2cc272, 0xbfa0b4bc6bb17ca0,
    0xbffd6688c90fe7c7, 0xbff10cb01b2f4203,
    0xbff782d7b7b62e11, 0xbff1da81c8f4cf5a,
    0xc000159995adbddb, 0x4000339dc3c5e20e,
    0x3fdc2a8b10b5748b, 0xbfc57e986a8b2d87,
    0xbfe5a3a0f0251b26, 0xbfbf28424759e7f0,
    0xc012da791a910386, 0x3fd3f1d5f388afe8,
    0x3ffe30d97ff65e0a, 0x3ffdbec1361c0733,
    0xbff1b9b830e9c3a2, 0xbff206d538b3ea6f,
    0xbfd4c04a28f61dbc, 0xbff350fb5ce19d0f,
    0xbfd90242a386bff0, 0x3fe3583ef4e5a39a,
    0xbfbed419ffa153f8, 0x3fca6e101b24c334,
    0xbff12c6736448e30, 0xc00740cadcdd8f38,
    0xbffb99e8efb667e3, 0xbff0035acfe3d90b,
    0x3ffad0ab205e2e3b, 0x3fe243df4257443d,
    0x3ff9a33fe9a3c0a5, 0x40000343b2be15a4,
    0xbff1c5ea8f08e1bd, 0x3ff2e2d02e3ad890,
    0x4001f00fd777d30b, 0x3fea3c64510961e8,
    0x40082e457b525474, 0xc001a569573954d5,
    0x3ff1e5044e7703a5, 0xbfdc78a583f785fc,
    0x400c02fcde5228a6, 0x3fe259de94385484,
    0x3feb26e2b678b224, 0xbff60cb709d2471b,
    0xc00043ace589ba18, 0x3ff0f1fe6e27f7a2,
    0xbfdd19dbc9acf6fc, 0xbfeafc83f1309c8e,
    0x3fe3f42a7e5e48a6, 0x3ff2a937b76490d6,
    0xbfb10c9e6b3db142, 0xbffb1b7217e85488,
    0x3ff1201c2d3ee102, 0xc00199fdd604f2bc,
    0xbff22d8f5ff45f98, 0x400448358e83f812,
    0xbffa4668420523e1, 0x3fb1a8678e6975b8,
    0xbfe664ca5f20b14a, 0xbfef686c984eae46,
    0xbfec45ecfa5a701c, 0xbfdaaf5bb1a99f26,
    0xc004f4e1fa369d56, 0xbfff6dc1ba1d9403,
    0xc001d1e31f834d12, 0x4004205471f1ee82,
    0xbff2e88b40afd370, 0xbfd376d4f05ba614,
    0x3fdccf74a6e8973e, 0xbfc3525c8bc6280d,
    0x3fe6efcf5f17e0b4, 0x3fdc17264eb58579,
    0xbfeba48195b5aabb, 0xbfdc8e550ab648b4,
    0x3fb752d14cb7d854, 0xc00be5b91b7c9802,
    0xbffd096da95a4a4e, 0x3fc90f2c619eb023,
    0xbff62f6264222894, 0xbfa8fac2ef72e400,
    0xbfea8aeda7ce85bd, 0xbff358969c1a135e,
    0x3fd93def1aa7a694, 0x40016e2b37b3574c,
    0xbfec2155728f91b0, 0x3fe00b8c6d5819fe,
    0xbfeda63ed8737353, 0xbfcfdaece77b7480,
    0xbfd614014a5c5354, 0xbff0a0d452ae833a,
    0x3ff661d27f2d3990, 0xbfe1e972a964f412,
    0x3ff4ad29a19f562a, 0x3ff607c65095c2ad,
    0xbfe222a2c4ec7dae, 0x3ff720c81d9c6a1a,
    0x3fff412478d185ed, 0xbff373964a2048e2,
    0xbfb85fc12966c960, 0x3fe245ca81373880,
    0xbfddbabb8767832c, 0x3fff6cabd84fd1b2,
    0x3fcd3d22b1aa450c, 0xbfd50e797f8a04ba,
    0x3fd495a57e82b8a4, 0xbfe87bd55cac597d,
    0x3fffffc3343f16d9, 0x3fc584b60769ecb0,
    0xbfe72ddae1be877c, 0x3fe9bb9f77012226,
    0xc00902a2c504ef88, 0x3ff68fdc55637328,
    0x3ff0e33b3cdc734a, 0xbfc921c5874f69da,
    0x3fe12ac60848a938, 0xbfdea42162230650,
    0xbfff83fca9ccd91a, 0x3ff98ffa10d43768,
    0xbff0bac3e47f737f, 0x3fe63f9f3a1e0251,
    0xbfffbc217f295d13, 0x3ff87584e97a16b8,
    0x3ff720873f89a588, 0x3ff1603b982eb49d,
    0x3fe092855133a079, 0x3fed95ee61aeb66e,
    0xbfe465aff93aef44, 0xbfd14308a8a808e5,
    0x3ff131064ca45909, 0xbff381534f8f20c4,
    0x3fdb9ce52ad6e3ee, 0x3fe9246d94f8f44a,
    0x3fc8012a84ba2c42, 0x3fdf0561d16d9c37,
    0x3fec5c50cbd44e9e, 0x40099288b39a4903,
    0xbfd5f654a794fe4a, 0x3ffbb87bd2f9d617,
    0x3fe1ec42be5d6a17, 0x3ff983f667728752,
    0xc005ce4a80f1f041, 0xbff14366a1a2b341,
    0xbff80908beccee3f, 0x3ff926d0f3f72963,
    0xbfe83024a398be4d, 0xc002c1169b7a04c7,
    0x3ff8fc1e39242d5e, 0xbff3363c2acf888c,
    0x400d0c3d87af11f5, 0xbfefd29ab3ecf3be,
    0xbfeb6ede9db3d79e, 0x3fdcd97d72e748d2,
    0xbfee0f5737ebd296, 0xbfef9ec04a52adc4,
    0xbfb52720bb9b0a2c, 0xc00253beb2677704,
    0x3ff4a3f30138d95d, 0xbff4ea7dcb281b4d,
    0x3ff934e75f107505, 0x3fd732d86193e988,
    0xbfced48bde8e34a0, 0x3ff410572ab1739d,
    0x3fe6ccd3dbe97946, 0xbffba9d5395f1cb7,
    0xc000893a4a1a9f1f, 0xbfe3e203ff0c820a,
    0x3ff6042f5cbe19e2, 0x3fb9723c62941110,
    0xbfb008730fd06910, 0xbfff01265beb072e,
    0x3fe01f0a4c504e86, 0xbfe16a465af0dbaa,
    0xbfece8fb41a24417, 0xbffb659fbf8c5dc2,
    0xbfd3cf54f0726d76, 0xbfc385d44218c838,
    0x4009199b2ebb0145, 0xbfec07ed05cfebdc,
    0xbff03b7d5c4cb885, 0x4000f2d7e5dd6167,
    0x3fec988e46c70fda, 0xc01059dd7af06ea0,
    0xbfdc2b3c04541a3e, 0xbfdd81ff0511a698,
    0xc0023c03576c4208, 0x3fea85f86c519334,
    0x3feb6e9855457079, 0xbff5170f9b9b65f5,
    0xbfd68798fe7c5430, 0xc0039b47a501a8c6,
    0xbff9f7c3871c14b2, 0x3fa371143a22e940,
    0xbfc999a1047ce830, 0xc0019f180aeb33c2,
    0x4002c90b97e4cd26, 0xbfe820a4982c5a3f,
    0x3ff846aa6e6e45f8, 0x3fd1ea7d34c080e4,
    0xbfacbb0556ee16d0, 0x3fd94bd690e114c4,
    0x3fcb246e51658d7c, 0x3ff5e7de60b825f0,
    0x3ff7e3a137991a8c, 0x3fc8a261f0e98da0,
    0x40017fb9b184e93c, 0xc001966541bfbd09,
    0x40025e1c21dff328, 0x3fee710c28cf96d0,
    0xbfbd2c738991fb20, 0x3fe1ef997cd9918c,
    0x3fe4a0e795fcdf72, 0x3fed39520dafae67,
    0x3fe49efaf720c092, 0x3ffbb20f96acec94,
    0xbfe3ac6bf3bc1ef5, 0x3ff0ce6b86dd736e,
    0x3ff2ddbc8061f34b, 0x3fecd88ba137a764,
    0xbfe9a2992454ff44, 0x3ff2b0a3b40dde56,
    0xbfebcad88f15a0f4, 0xbff7b441a64963ef,
    0x3ff5527da941b557, 0x3fe30b80bcdeec5c,
    0x4000613dd2758a83, 0xbffe74841bde6b7a,
    0xc010ed37fe57d8c2, 0x4001049dd08c088b,
    0xbfe96783a7db12bf, 0xc001ee0b623bf51c,
    0xbfecc6d39e21bfa4, 0xbfe33a51fd30a7ee,
    0x4001112ac99bab1f, 0xbff3f5a2809fbc6a,
    0xc00504e32490d7a8, 0xc0027ce15222d9d6,
    0x3fd93f4b20e83b92, 0x3fb7356a03921e10,
    0xbff78d05d76164a3, 0x3ff44f8677921057,
    0xc001630adb28447c, 0xbff69ace97c8a79c,
    0xbfb8cbd4dfdc3b90, 0x3feaa264fa53a07a,
    0xbfe7d0ce3ce19358, 0xbfd32de78db3952c,
    0x3fff31cdc6642f07, 0x3fef234b77a32535,
    0x3fd503d07bd45f44, 0x4007109dde33d582,
    0xbfea4b682b4250f4, 0xbff609a90bb5bb0e,
    0xbffe153ae83733f6, 0xbfdbe3a68bfbef10,
    0xbffcbbc158c9ebac, 0x40003a7dc4168314,
    0x4005f4b7fc1f0ddc, 0xbfea6fa965a7c30a,
    0xbfef0475e37532e1, 0xc00be796e8886f24,
    0x3ff6c18b6c85d7e6, 0xbffb16a9765f38fc,
    0xbfd89661842028d4, 0xc00095ae2a4dad4c,
    0xbff74877c91dd18b, 0xbf8ada0e5105b380,
    0xbff3b54388012242, 0xbfe023ed3dfbd03c,
    0x3ffc19b5e330c83c, 0xbff07e983f6955b7,
    0x3fd198a715a7f516, 0x3fe4c353f593fe68,
    0x3fe80fd1a8be6788, 0xbff16ccbfecec8f4,
    0x3fc1c1670d16cac8, 0xbff73fba28638047,
    0x3fed6b335085618f, 0x4001064bfbc72c0c,
    0xbf9501cda6016ba0, 0xbfeaa05d17d45017,
    0x3ff22be48ed9d14d, 0x3ff1eb9110ed9b4f,
    0x4000fbf4c88632d8, 0xbfef2bdc58227644,
    0x3fd72f7c0985e474, 0xc00021d7163ec975,
    0xbffa22cae77adbff, 0xbff085269546da31,
    0x3ff024afa4cefa80, 0x4001d5e05ccebd9c,
    0xbff384f7325a089e, 0x3fb3ae7aef0a08d8,
    0x3fdc04854dcd9d99, 0xbfc02dbd44b59980,
    0x3ff73ea50c95958b, 0xbfff0a60a8a5b913,
    0xbffb6b010567fe30, 0xbfd11ed9cccd17a6,
    0x3fea622b846c85c2, 0xbff610773d263ee5,
    0x3fec0ef01b2a61ff, 0xc0055ec40a3eacac,
    0x3ff404e6f1b8760e, 0xbff3f4227e6f414b,
    0x3fe4a611f8dc66f9, 0xbfc0b072f4afcf14,
    0xbff9b1f1ac6143e0, 0xbfe4da08b4f0eed6,
    0xbfcc3bde5e393a40, 0x3fe0dce0235be74d,
    0xbfd1a48080c5bfec, 0xbff67a406bf67722,
    0xbffa56a84217a7d3, 0x3fe9b305ef35d62c,
    0xbfff25507a46afc4, 0xc005f2dbf8151059,
    0x3fbbd45c15a00e70, 0xbffb948d0f00b49a,
    0xbfa98d8be451b040, 0xbff7c6ab6ce7f3e2,
    0xbfe9c80d38506285, 0xc00120272f85af38,
    0x3feb44f74fa5703b, 0x3fefda4c372a94b8,
    0xbfefda810fa56c4a, 0xbfd15acd0f005758,
    0xbfd2986b5eb70fe4, 0xc00cb29156877ab1,
    0xc0008cbcc6e9b3e6, 0x3fe99cedf4756c04,
    0x3fe71c5a73d511e8, 0x40058e75f4da0382,
    0x3fe5ce650bdd3c35, 0x3fe3b19afa7a8d78,
    0xbffd406209ff5dc2, 0x3ff18ede66174abc,
    0xc00392dad643b644, 0x3fe1582bc7a1dbf3,
    0xbff4bd85ed0507a0, 0x40061acea82ef2fc,
    0xbfd0c96697904938, 0x3fd85e24381b6018,
    0xbff4981dde8c0061, 0xbfea2bade50f9e66,
    0x3ff5ddd465988090, 0xbfe5c98d9b8a4d26,
    0xbff53c3094ef0ee2, 0x3fd9eab9fbb4438c,
    0xbfefe32b15bdff57, 0x400103d0d4c4c632,
    0x3feb02dda79b5a84, 0xbffa67ca670c354e,
    0xbfd0daa4593d7f64, 0xbfdd04dfa9ed2c22,
    0x3fc1a2acaa3c71ec, 0x40002842a7d1e544,
    0xbfece582c20938f2, 0xc011236e0721a4b9,
    0x3ff39247125752fb, 0xc00526905ed66779,
    0x3fd5e375d024b8df, 0x40047bb805627b63,
    0x3ffd9000f9f1a1b5, 0xbfe7b007dd05acb0,
    0xbfe99c29a05a6ab2, 0x400088c791d3451d,
    0x400000e5874461ec, 0x4001572f2a70e98e,
    0x3fd3632b47502823, 0xbff207e60480255c,
    0xbff0a9279b6d8428, 0x3ff528d0dd0a51d2,
    0x3ff9a91383c8d8cb, 0xbff22c271887d248,
    0xbfcd4c9ebecce7fc, 0xbfdaddf4110ea2be,
    0xbff0a806f71098d1, 0xbfaed4088fa4cd50,
    0x3ff3cc49e3b0d4f8, 0x3fde16ebab7ad269,
    0x400115a71bf25160, 0x3fec8fc2ee45c88e,
    0xbfe7844b12ffb018, 0xbffa27a4c35fc10a,
    0xbff37dcbe77714cb, 0xbfee2c979504a24f,
    0x3ff2c3c293a7d97c, 0x3fed85bd0a4ff1dc,
    0xbfa185235c389fc0, 0xbff44becfb72a4a7,
    0x4005746dfab8050c, 0xbfe211b787b9e656,
    0xbfd999821844ac08, 0x3fdd6342b176c4a4,
    0xbff55c9c34ba63da, 0xc009083fc8896a7c,
    0xc004725fb3901363, 0xbfe1050032b66048,
    0x3fee5642ca66b9be, 0x40077d20a2187e7b,
    0xc004096e2759a8ea, 0x3fa91c35e7f98780,
    0x3fe2c31350894360, 0xbf9bc8418424f820,
    0xbff2d7a625aa5f12, 0xbfd2b61db3a5585c,
    0x3fe76dad87f3d8be, 0x4006ed1b8a54edca,
    0x4005a7746c0bf4e2, 0xc00060e81e8b858e,
    0xbfdceaae0b119e6f, 0xbfe0c84ded28056c,
    0xbffdf5f9ef799d83, 0x3fcfd6b22f7de520,
    0x3fe257ea482744ae, 0xbff984fe4de35b60,
    0xc0121c2f0c8e44c9, 0xc00c0cfba9fa6c3b,
    0xc00044140f6875f4, 0xc0013c94b56de842,
    0x3fe3147ca3bd3bf2, 0x3fe4810a6df20dec,
    0xbff193e16ec38c97, 0xc00a264c3886cde0,
    0x3fb70720cab518f8, 0x3fb1d82287218760,
    0x3fd30362846eaa6e, 0xbff64611553bdd06,
    0x3ff0b3d2230c77c9, 0x3ffb2d58fc730b0f,
    0x3fc07fba2a01b3a5, 0xbff39d64bdb81503,
    0xbff71f57e2184a33, 0x0,
    0x3fc07fba2a01b3b2, 0x3ff39d64bdb81506,
    0x3ff0b3d2230c77cb, 0xbffb2d58fc730b0d,
    0x3fd30362846eaa62, 0x3ff64611553bdd0d,
    0x3fb70720cab518f0, 0xbfb1d82287218730,
    0xbff193e16ec38ca2, 0x400a264c3886cde2,
    0x3fe3147ca3bd3bea, 0xbfe4810a6df20de6,
    0xc00044140f6875f8, 0x40013c94b56de83e,
    0xc0121c2f0c8e44ca, 0x400c0cfba9fa6c3a,
    0x3fe257ea482744aa, 0x3ff984fe4de35b5a,
    0xbffdf5f9ef799d84, 0xbfcfd6b22f7de560,
    0xbfdceaae0b119e68, 0x3fe0c84ded28056a,
    0x4005a7746c0bf4e0, 0x400060e81e8b858f,
    0x3fe76dad87f3d8c2, 0xc006ed1b8a54edcb,
    0xbff2d7a625aa5f10, 0x3fd2b61db3a5585e,
    0x3fe2c31350894368, 0x3f9bc8418424f900,
    0xc004096e2759a8ea, 0xbfa91c35e7f98780,
    0x3fee5642ca66b9ca, 0xc0077d20a2187e7a,
    0xc004725fb3901366, 0x3fe1050032b6603c,
    0xbff55c9c34ba63e1, 0x4009083fc8896a7b,
    0xbfd999821844ac12, 0xbfdd6342b176c4b4,
    0x4005746dfab8050e, 0x3fe211b787b9e666,
    0xbfa185235c38a000, 0x3ff44becfb72a4a8,
    0x3ff2c3c293a7d982, 0xbfed85bd0a4ff1d6,
    0xbff37dcbe77714ce, 0x3fee2c979504a250,
    0xbfe7844b12ffb018, 0x3ffa27a4c35fc108,
    0x400115a71bf25160, 0xbfec8fc2ee45c883,
    0x3ff3cc49e3b0d4fa, 0xbfde16ebab7ad24d,
    0xbff0a806f71098cf, 0x3faed4088fa4cd70,
    0xbfcd4c9ebecce814, 0x3fdaddf4110ea2ca,
    0x3ff9a91383c8d8ca, 0x3ff22c271887d249,
    0xbff0a9279b6d8425, 0xbff528d0dd0a51d5,
    0x3fd3632b47502827, 0x3ff207e604802558,
    0x400000e5874461ee, 0xc001572f2a70e98a,
    0xbfe99c29a05a6aa6, 0xc00088c791d3451c,
    0x3ffd9000f9f1a1b8, 0x3fe7b007dd05acbe,
    0x3fd5e375d024b8fa, 0xc0047bb805627b60,
    0x3ff39247125752f4, 0x400526905ed6677a,
    0xbfece582c20938fa, 0x4011236e0721a4b7,
    0x3fc1a2acaa3c7238, 0xc0002842a7d1e544,
    0xbfd0daa4593d7f58, 0x3fdd04dfa9ed2c21,
    0x3feb02dda79b5a70, 0x3ffa67ca670c3555,
    0xbfefe32b15bdff51, 0xc00103d0d4c4c632,
    0xbff53c3094ef0ee6, 0xbfd9eab9fbb4438f,
    0x3ff5ddd46598808c, 0x3fe5c98d9b8a4d32,
    0xbff4981dde8c0064, 0x3fea2bade50f9e5c,
    0xbfd0c9669790493c, 0xbfd85e24381b6018,
    0xbff4bd85ed050799, 0xc0061acea82ef2fc,
    0xc00392dad643b643, 0xbfe1582bc7a1dbed,
    0xbffd406209ff5dc7, 0xbff18ede66174ac0,
    0x3fe5ce650bdd3c3d, 0xbfe3b19afa7a8d77,
    0x3fe71c5a73d511f0, 0xc0058e75f4da037f,
    0xc0008cbcc6e9b3e5, 0xbfe99cedf4756c10,
    0xbfd2986b5eb70ff9, 0x400cb29156877ab1,
    0xbfefda810fa56c40, 0x3fd15acd0f00574a,
    0x3feb44f74fa57042, 0xbfefda4c372a94b6,
    0xbfe9c80d38506292, 0x400120272f85af39,
    0xbfa98d8be451b0f0, 0x3ff7c6ab6ce7f3eb,
    0x3fbbd45c15a00e50, 0x3ffb948d0f00b499,
    0xbfff25507a46afce, 0x4005f2dbf815105a,
    0xbffa56a84217a7d1, 0xbfe9b305ef35d62e,
    0xbfd1a48080c5c000, 0x3ff67a406bf67722,
    0xbfcc3bde5e393a00, 0xbfe0dce0235be754,
    0xbff9b1f1ac6143e4, 0x3fe4da08b4f0eed7,
    0x3fe4a611f8dc66f8, 0x3fc0b072f4afcf08,
    0x3ff404e6f1b87609, 0x3ff3f4227e6f4152,
    0x3fec0ef01b2a61f6, 0x40055ec40a3eacad,
    0x3fea622b846c85bc, 0x3ff610773d263ee9,
    0xbffb6b010567fe32, 0x3fd11ed9cccd179e,
    0x3ff73ea50c959588, 0x3fff0a60a8a5b914,
    0x3fdc04854dcd9da6, 0x3fc02dbd44b59978,
    0xbff384f7325a089e, 0xbfb3ae7aef0a0920,
    0x3ff024afa4cefa85, 0xc001d5e05ccebd9b,
    0xbffa22cae77adc02, 0x3ff085269546da2c,
    0x3fd72f7c0985e470, 0x400021d7163ec974,
    0x4000fbf4c88632d4, 0x3fef2bdc5822764f,
    0x3ff22be48ed9d14c, 0xbff1eb9110ed9b4b,
    0xbf9501cda6016cc0, 0x3feaa05d17d4501a,
    0x3fed6b3350856199, 0xc001064bfbc72c0d,
    0x3fc1c1670d16cac2, 0x3ff73fba28638046,
    0x3fe80fd1a8be6784, 0x3ff16ccbfecec8f0,
    0x3fd198a715a7f50c, 0xbfe4c353f593fe74,
    0x3ffc19b5e330c838, 0x3ff07e983f6955b8,
    0xbff3b54388012242, 0x3fe023ed3dfbd038,
    0xbff74877c91dd18f, 0x3f8ada0e5105b240,
    0xbfd89661842028f4, 0x400095ae2a4dad4a,
    0x3ff6c18b6c85d7e0, 0x3ffb16a9765f38fb,
    0xbfef0475e37532f0, 0x400be796e8886f24,
    0x4005f4b7fc1f0dda, 0x3fea6fa965a7c312,
    0xbffcbbc158c9eba9, 0xc0003a7dc4168317,
    0xbffe153ae83733f7, 0x3fdbe3a68bfbeef4,
    0xbfea4b682b425102, 0x3ff609a90bb5bb0a,
    0x3fd503d07bd45f5d, 0xc007109dde33d582,
    0x3fff31cdc6642f05, 0xbfef234b77a3252c,
    0xbfe7d0ce3ce1934c, 0x3fd32de78db39530,
    0xbfb8cbd4dfdc3b88, 0xbfeaa264fa53a082,
    0xc001630adb28447d, 0x3ff69ace97c8a799,
    0xbff78d05d76164a4, 0xbff44f8677921058,
    0x3fd93f4b20e83baa, 0xbfb7356a03921de8,
    0xc00504e32490d7ab, 0x40027ce15222d9d2,
    0x4001112ac99bab1f, 0x3ff3f5a2809fbc70,
    0xbfecc6d39e21bfae, 0x3fe33a51fd30a7e4,
    0xbfe96783a7db12c4, 0x4001ee0b623bf51c,
    0xc010ed37fe57d8c0, 0xc001049dd08c088d,
    0x4000613dd2758a82, 0x3ffe74841bde6b7e,
    0x3ff5527da941b558, 0xbfe30b80bcdeec58,
    0xbfebcad88f15a0f7, 0x3ff7b441a64963ed,
    0xbfe9a2992454ff4c, 0xbff2b0a3b40dde5c,
    0x3ff2ddbc8061f34a, 0xbfecd88ba137a75f,
    0xbfe3ac6bf3bc1ef6, 0xbff0ce6b86dd7372,
    0x3fe49efaf720c09e, 0xbffbb20f96acec94,
    0x3fe4a0e795fcdf7c, 0xbfed39520dafae64,
    0xbfbd2c738991fb00, 0xbfe1ef997cd99187,
    0x40025e1c21dff324, 0xbfee710c28cf96cc,
    0x40017fb9b184e93b, 0x4001966541bfbd0e,
    0x3ff7e3a137991a8b, 0xbfc8a261f0e98d90,
    0x3fcb246e51658d74, 0xbff5e7de60b825ec,
    0xbfacbb0556ee16d8, 0xbfd94bd690e114cc,
    0x3ff846aa6e6e45fa, 0xbfd1ea7d34c080e0,
    0x4002c90b97e4cd24, 0x3fe820a4982c5a43,
    0xbfc999a1047ce848, 0x40019f180aeb33c2,
    0xbff9f7c3871c14b2, 0xbfa371143a22e9a0,
    0xbfd68798fe7c543c, 0x40039b47a501a8c4,
    0x3feb6e9855457072, 0x3ff5170f9b9b65fa,
    0xc0023c03576c4208, 0xbfea85f86c51933e,
    0xbfdc2b3c04541a4b, 0x3fdd81ff0511a686,
    0x3fec988e46c70fcf, 0x401059dd7af06ea1,
    0xbff03b7d5c4cb87e, 0xc000f2d7e5dd616a,
    0x4009199b2ebb0144, 0x3fec07ed05cfebe0,
    0xbfd3cf54f0726d6b, 0x3fc385d44218c824,
    0xbfece8fb41a2441c, 0x3ffb659fbf8c5dbc,
    0x3fe01f0a4c504e8e, 0x3fe16a465af0dbae,
    0xbfb008730fd06938, 0x3fff01265beb072e,
    0x3ff6042f5cbe19e3, 0xbfb9723c629410f8,
    0xc000893a4a1a9f1f, 0x3fe3e203ff0c81f6,
    0x3fe6ccd3dbe97941, 0x3ffba9d5395f1cba,
    0xbfced48bde8e3492, 0xbff410572ab1739f,
    0x3ff934e75f107502, 0xbfd732d86193e981,
    0x3ff4a3f30138d959, 0x3ff4ea7dcb281b4d,
    0xbfb52720bb9b0aa2, 0x400253beb2677701,
    0xbfee0f5737ebd294, 0x3fef9ec04a52adbd,
    0xbfeb6ede9db3d7a0, 0xbfdcd97d72e748ec,
    0x400d0c3d87af11f5, 0x3fefd29ab3ecf3c9,
    0x3ff8fc1e39242d5a, 0x3ff3363c2acf888e,
    0xbfe83024a398be54, 0x4002c1169b7a04c5,
    0xbff80908beccee3e, 0xbff926d0f3f72965,
    0xc005ce4a80f1f043, 0x3ff14366a1a2b33e,
    0x3fe1ec42be5d6a30, 0xbff983f667728758,
    0xbfd5f654a794fe41, 0xbffbb87bd2f9d617,
    0x3fec5c50cbd44eb0, 0xc0099288b39a4902,
    0x3fc8012a84ba2c46, 0xbfdf0561d16d9c4c,
    0x3fdb9ce52ad6e3f8, 0xbfe9246d94f8f44a,
    0x3ff131064ca4590a, 0x3ff381534f8f20c5,
    0xbfe465aff93aef48, 0x3fd14308a8a808d5,
    0x3fe092855133a077, 0xbfed95ee61aeb66e,
    0x3ff720873f89a588, 0xbff1603b982eb49b,
    0xbfffbc217f295d11, 0xbff87584e97a16ba,
    0xbff0bac3e47f737f, 0xbfe63f9f3a1e024d,
    0xbfff83fca9ccd916, 0xbff98ffa10d4376c,
    0x3fe12ac60848a933, 0x3fdea4216223064e,
    0x3ff0e33b3cdc7346, 0x3fc921c5874f69e6,
    0xc00902a2c504ef85, 0xbff68fdc55637333,
    0xbfe72ddae1be8774, 0xbfe9bb9f77012227,
    0x3fffffc3343f16d8, 0xbfc584b60769ec90,
    0x3fd495a57e82b8ac, 0x3fe87bd55cac597c,
    0x3fcd3d22b1aa4518, 0x3fd50e797f8a04c2,
    0xbfddbabb876782f4, 0xbfff6cabd84fd1b5,
    0xbfb85fc12966c960, 0xbfe245ca81373884,
    0x3fff412478d185e8, 0x3ff373964a2048e9,
    0xbfe222a2c4ec7da4, 0xbff720c81d9c6a14,
    0x3ff4ad29a19f562c, 0xbff607c65095c2a8,
    0x3ff661d27f2d3993, 0x3fe1e972a964f418,
    0xbfd614014a5c5364, 0x3ff0a0d452ae8338,
    0xbfeda63ed8737350, 0x3fcfdaece77b7478,
    0xbfec2155728f91b0, 0xbfe00b8c6d581a08,
    0x3fd93def1aa7a6b0, 0xc0016e2b37b3574a,
    0xbfea8aeda7ce85c2, 0x3ff358969c1a135b,
    0xbff62f626422289e, 0x3fa8fac2ef72e440,
    0xbffd096da95a4a4f, 0xbfc90f2c619eb01e,
    0x3fb752d14cb7d7ac, 0x400be5b91b7c9801,
    0xbfeba48195b5aab6, 0x3fdc8e550ab648b4,
    0x3fe6efcf5f17e0bb, 0xbfdc17264eb5856b,
    0x3fdccf74a6e8974b, 0x3fc3525c8bc62824,
    0xbff2e88b40afd36e, 0x3fd376d4f05ba612,
    0xc001d1e31f834d10, 0xc004205471f1ee84,
    0xc004f4e1fa369d5a, 0x3fff6dc1ba1d93fe,
    0xbfec45ecfa5a7020, 0x3fdaaf5bb1a99f1c,
    0xbfe664ca5f20b14d, 0x3fef686c984eae41,
    0xbffa4668420523df, 0xbfb1a8678e6975f0,
    0xbff22d8f5ff45f91, 0xc00448358e83f814,
    0x3ff1201c2d3ee100, 0x400199fdd604f2bb,
    0xbfb10c9e6b3db146, 0x3ffb1b7217e85489,
    0x3fe3f42a7e5e48aa, 0xbff2a937b76490d8,
    0xbfdd19dbc9acf6f6, 0x3feafc83f1309c92,
    0xc00043ace589ba16, 0xbff0f1fe6e27f7a8,
    0x3feb26e2b678b226, 0x3ff60cb709d2471b,
    0x400c02fcde5228a8, 0xbfe259de9438547d,
    0x3ff1e5044e7703a7, 0x3fdc78a583f78608,
    0x40082e457b525474, 0x4001a569573954d7,
    0x4001f00fd777d30d, 0xbfea3c64510961e0,
    0xbff1c5ea8f08e1be, 0xbff2e2d02e3ad892,
    0x3ff9a33fe9a3c0ac, 0xc0000343b2be15a3,
    0x3ffad0ab205e2e3e, 0xbfe243df4257443c,
    0xbffb99e8efb667e8, 0x3ff0035acfe3d906,
    0xbff12c6736448e36, 0x400740cadcdd8f38,
    0xbfbed419ffa153b6, 0xbfca6e101b24c328,
    0xbfd90242a386bfe4, 0xbfe3583ef4e5a3a0,
    0xbfd4c04a28f61dc8, 0x3ff350fb5ce19d10,
    0xbff1b9b830e9c3a2, 0x3ff206d538b3ea6e,
    0x3ffe30d97ff65e10, 0xbffdbec1361c072f,
    0xc012da791a910387, 0xbfd3f1d5f388b020,
    0xbfe5a3a0f0251b28, 0x3fbf28424759e81c,
    0x3fdc2a8b10b57490, 0x3fc57e986a8b2d7e,
    0xc000159995adbdd6, 0xc000339dc3c5e210,
    0xbff782d7b7b62e11, 0x3ff1da81c8f4cf59,
    0xbffd6688c90fe7d0, 0x3ff10cb01b2f41fd,
    0x3ff2f8cdec2cc276, 0x3fa0b4bc6bb17d10,
    0x3ff73051d454cf34, 0xbfe70b687d609561,
    0x3fd2ad6ee510b08c, 0xbfe9350a1d4f0971,
    0x3fddd54d017e7e64, 0x3fd25addd9bea464,
    0xbff4d9ce7b988a3e, 0x40035bba4a0bb8f8,
    0xbfddf6e428c2893c, 0xbfe3922cd98b394d,
    0xbfd51e8072a0e7d8, 0xc00dcf7c22b2c644,
    0x3feebf8c746576be, 0xc003e999332dc393,
    0x400095c67e25bfdb, 0xc00878096c4074b0,
    0x40060bae5f02ea1f, 0xbfcd608f2ac94d70,
    0x400ca4de41f7bc33, 0x4002afc3bb06908c,
    0x3fe0c4200b8c138a, 0x3fda9eef2889eb36,
    0x3fce2d9528f8a9fc, 0xbff3281f7a9082a9,
    0x3ff71bb363b1ba32, 0x3ff15ebee223a72a,
    0xc0002e1d8d6e64aa, 0x3fd48eaf92f2bc05,
    0x3ff91904e4093353, 0xbffad424e654ad62,
    0xbff939122599af87, 0x3fe652efdbaa6814,
    0xbfd31fd5a62c175b, 0x3fd5aeff3c61dad6,
    0xbfd4d9a978d3947a, 0x3ffc4ac77b56d5d2,
    0xbfe4d3f256e003c8, 0xbf97041271df1340,
    0x3fd3867d9ef54da3, 0xc00473af2eecdc6f,
    0xc005f89bc7d1a154, 0x3fff31b6eb740c25,
    0xbfd4fb783b9a60c0, 0x4004bf50f0c9fc5f,
    0x3fd1de786e138fca, 0x3fe13fddce7d72b7,
    0xbfd33399e8b3c916, 0xbff5bec62c8baac4,
    0x3ff5eafc70923f86, 0xc00be81f2221d004,
    0xc009b66ab24264aa, 0xbfb8154cb84d4020,
    0xc00caa9459fc8f8f, 0xc004a7dce9ac8224,
    0x3f5ede7e7bf82700, 0xbfd9acbca0e68cd4,
    0xbffe0b8f954dbf48, 0xc00789e13d562ec0,
    0xbfeaf851b46f6ef0, 0xbfe7890183564b7c,
    0x3ffbba8bd62f6e46, 0xbff7ea56e9a6e536,
    0x3fc920e7f0b74d94, 0xbfcda19a8a6cbba8,
    0xbff81a6c48b4c45f, 0x3ff6666651de4f02,
    0x3fe30d364cd7a237, 0xbfdf1d10cb2c595c,
    0xc0014d63d0fffba5, 0x3fd72bed96753484,
    0xbff14570920d1e57, 0xbfec342b3a0b14ea,
    0xbff0228495366952, 0xc0098f7da8eee7da,
    0xbfef198795806dbc, 0xbfdbbcf3981f95d2,
    0x3fea2cdde8391672, 0x3fffeca7c8fe3868,
    0x3fcb4cfd263ee520, 0x4010adc59b3a7c40,
    0xbfd0a6abdba2a1c0, 0xbff9f913a140d57c,
    0xc0030c2aecd8e3f6, 0xc00781c3a859ee30,
    0xbfec96a7bbe75d13, 0xbff6f278b5efa060,
    0x3fc91223fbc0ef10, 0x3ffbe8343a41ca88,
    0xbffddb0646d0190a, 0x3ff293d034a74f32,
    0x3fc491e4c2522b94, 0xbfe7c69d5eddb65c,
    0xbfe7dff06e383e2e, 0x3ff7b989894b70d3,
    0x400747716a156ba4, 0x3fec6d2645ef128c,
    0xbff45074bf7a9481, 0x3fed1ea6c2ca65a4,
    0xbffbbf7f7c7104d7, 0x3ff1657f57023b67,
    0xc004a49fc4e01008, 0xbfd0a38e1e435ad1,
    0x3ffe57a5a388c7db, 0xc00144173570830b,
    0xbffba5d3fe69d5fd, 0xbff45f84a433f39c,
    0x3fb0723acebf8288, 0x3ff5b338ad583d36,
    0x400a616177c704bf, 0xbfdb0d22f97426f4,
    0xbff419839d429d63, 0x3feba7969e3db090,
    0xc004ff4b53e193ff, 0xc00140bd2243cdf1,
    0xc001512aa8e8552e, 0xbfcd09dac3987b3c,
    0x3fe4af6ec58dec11, 0xc002e33952270480,
    0x3fe6060e054c1858, 0xbff8e77065107739,
    0x3ffa9d6c00024736, 0xc00050cb090c3e4e,
    0x3fa90d8f5cd61670, 0xbffc20351c46de3e,
    0xbff16687475aed69, 0x3ffc9bb13360bf08,
    0x3ff8037afda9ffb4, 0x3fa476360015a778,
    0x400b788e80f8c9bc, 0xbfd83a3b99f5afff,
    0x3fb1436a076cb1c4, 0xc0023981175af677,
    0xc00067a126d4f92c, 0xbfdebbfa5e439830,
    0x3fc2812cfa4f6188, 0x3ffde6770e3b8528,
    0xc002dc87781fb672, 0x3ff70fe189e5a55a,
    0x3fc1d0a823669c4c, 0xbfa913e86730af40,
    0x3fecf07da35646c8, 0xbfe8abb28aa84f7c,
    0xbfdc51c20e1387f4, 0xc0035e7800a694ce,
    0x40038f2f3e946ba8, 0x3ff2e4bccf47cb24,
    0x3ffb6302d1386d02, 0x400460818ced3070,
    0x40029ed73c954e9e, 0x3fed544c1ff656ee,
    0x3feac531122a55ab, 0x3fe3170fb1f352d0,
    0xbf9c2bc1a4781480, 0x400481f0c673dec5,
    0x3ff49dd6fbe700b6, 0xc01111713a51ba08,
    0xbfd76ee1316ed9de, 0x3fefa8f731733d58,
    0xc003a9e22ea28e70, 0x3fbc5ca912b26a30,
    0xbfe8ad4236fa1396, 0x3fedae08b72a79a9,
    0xbff85eaf992c8268, 0x3fe320282b97e5c6,
    0xbffb5ddeee8d8476, 0xc005c04f44d208b6,
    0x3fca48eaeb46d938, 0x3fe768f36231568e,
    0x3fe9f7813585900d, 0x3ff4a7da064aeb96,
    0xbffe7ad202b9ddec, 0xc00d9b980aee39d4,
    0xc00da77d3aa1cc4a, 0x3fea3dfe2bd73c63,
    0x3fd1118a26dd88fe, 0x3fe6992741b405ca,
    0x3fdce64283b95288, 0x3ff5f89aca4d14ae,
    0xbfafb9f92df29338, 0x3fc46e802f9e4f64,
    0x400065d17fe358b8, 0xbff78b39acd60a1c,
    0xbfc5483735bd440c, 0x400a17db6cf3f7a1,
    0x3fd9484ce812cf38, 0xbff73b29fac4efde,
    0x4000a386e819caf1, 0xc0006f11f8aaa902,
    0xbfd4b034fce982b0, 0xbff76c0d739c1f3c,
    0x3ff78d1670995ecc, 0x3ff1778c8d5c9273,
    0x400e1f99b9329570, 0x4005df8634e941fa,
    0xbff4c2be5057b01c, 0xbfe2c8eb0d821ce5,
    0xbff34a0d320c4086, 0xbfec88e60a81cf63,
    0x3ff23947d39d018d, 0x3ff052d500760b9e,
    0x3fd1ccfd9601f3fe, 0xbfdb86f0c0013184,
    0xbff21315d656cc39, 0xbfbe52923fa71f14,
    0x3febd784eb6181b0, 0x4009e6fa9ddf98ac,
    0x400b38116e5d5a63, 0xbfee29d19b609e64,
    0xbfe53eb2a4aa9bb7, 0xbfdc8f166d556948,
    0x3ff72736e3e84e71, 0xbfdf09526675bd3a,
    0xbff3f57b2cf60fcf, 0x3ffec368ff307f66,
    0xbfe73e2be1c8c756, 0xbff3ce66f2b148d5,
    0xc0053e4e9f99981c, 0x3ffc7f3cd63c6934,
    0x3ff0df6d222413c7, 0x3fe195520515a573,
    0x3feb2ce0252249d2, 0xbffb9c67d1661469,
    0xbfd6fedb2fd774fc, 0xbfe1dcfc4ce0b512,
    0x400228a750cdbcb0, 0x3fb838b09a609258,
    0x3fc4a2fcf882f92c, 0xbff8683819e36688,
    0x3fc44a6b003e616a, 0x3ffcda5eafe75584,
    0x3ff94de9bee5b8c6, 0xc006206aa6d90529,
    0x3ffd76ec340b17fc, 0x3ff7667bbb6e86e0,
    0x3ffd477697435197, 0x3ff8346379ca28a8,
    0xbfdc770da16937c1, 0x3fc6b0efdc45f2ec,
    0x3fe3ca1aec9ef9ce, 0xbffcfa77009a7dac,
    0xc009870c704b1146, 0xbffd1d9167b2d0b7,
    0xbffdf16849c9c9a8, 0xbfe7af3ddf7d3073,
    0x3fef0a3e14144914, 0x3fcaf1efd6e016b8,
    0x3fe50be6efa661e1, 0xbfd46a180bb11460,
    0xbff9e2edb55866af, 0x3ff4f4dbea7cd2c8,
    0x3ff3c68b92f35537, 0xbfec073f2420f34e,
    0xbfe68a452bcb1143, 0x40027f121aef25c8,
    0x3febe6a2bd0e6c34, 0xbfe20d59e330a3b2,
    0xc0096f39f7abdf7e, 0xbfa63daf33dbc920,
    0xbfd2f3c90f5c3ba2, 0x3fe4720fdfb91df4,
    0xbff3387e10dd6319, 0xc00ec7d4c74ba0f5,
    0xbfbbf8d2eca0cdac, 0x400424a3a9c4f1e8,
    0x3ff23921b8e0bb70, 0x3fc115ca0f828b7c,
    0xbffe261eec2ff142, 0x3ff6d9717d549888,
    0xbfc0d420e2044ec4, 0xc007a0bc40474a18,
    0xbfffe26f77c307ad, 0x3feec9f65e633dde,
    0xbffb9743be70b054, 0x3ff3a9f32f6f0b8b,
    0x3fe0d7538c56aa84, 0x3fb6296b22414ce4,
    0xbff8a34dd41125d9, 0xbfe36c634f53df6f,
    0x3ff0396d23db3a04, 0x3ff9ac20c576f6fd,
    0xc00b318186f4a840, 0x3fd5abaf6bf73084,
    0x3ffed2e19dc73271, 0xbff2c0ad8e58951f,
    0xbfe79ebfe2f9ecf4, 0x3fba82102cfb77e8,
    0xbfe1be085a3cf7d7, 0xc004cda50694f190,
    0x40029dc92d5894c3, 0xbfd6afb6572c60ec,
    0x3ff1f4449b10e05b, 0x3ff18af9bea39494,
    0x3ff6293038164072, 0x3fdfdf9ac252cfc4,
    0xbff9d1390d2cb2b6, 0x3fe958f5ca82f3ca,
    0xbfdebd85c13398f4, 0x3fd25ff35db8dab4,
    0x3ff23cafe65aec47, 0xbff8b01ead8dd307,
    0xbfe3aa1312d706e4, 0xbff72fcf68585aa5,
    0xbff7506e3744d586, 0x3fdbc9f830b07d76,
    0x3ff62fd8717c653a, 0x3fefbc6027dd9ca0,
    0xbfe04dc88a0706f0, 0xc0049b64b8b89f35,
    0xbfdf0661a28b2d48, 0x400072a8523028a5,
    0x400457cf161b39e6, 0xc00101739dd03756,
    0x3ffb5035a717a0b0, 0xbfd49fcda289375d,
    0xbfcc8ae2a162cb70, 0x3ff24f078c0f5652,
    0xbfdd094ec9ee3d4a, 0xc00a34fe501db972,
    0x3fe327d7c028836d, 0x3fdfc6ade66add22,
    0x3fdd670b8453b0ec, 0xbff989d28d1fe2ea,
    0x3fbf88377e83cdb0, 0xbfe03a9f64da63e2,
    0x4018fc992c24b60d, 0x3ff0d831b088be4d,
    0xbfef59c465543a47, 0x4000831cce427930,
    0x400c35ce985e9aa5, 0x3ff8b06a53c7de3a,
    0xbfe1b23a8f5ed25c, 0xbff09a3448cc5066,
    0xbff22c3849416abe, 0x3fcaf1e7ebb31190,
    0xbff22a8d9ada5add, 0xbff5992f27098c9b,
    0xbfe992db85fd792d, 0xbfddd84a930029e9,
    0x3fda0485a1c1d4ca, 0xc00678aa84ec00ed,
    0x3febc7d95ded9248, 0xbfdb3f5ba296d2cc,
    0x3fe1434125f44f30, 0xbfdb2616eb88051c,
    0x3ff00bad0c78959a, 0xbfd8bade9778cad0,
    0x4004e27ea760397f, 0xbfe4615a4f021196,
    0x3fe8f70fdc9237c6, 0xbff6ab6b2d155aef,
    0x3ff00365fda41240, 0x3fe77d8873919052,
    0x3fe82efa47c8e635, 0x3fe97eff5c471e3e,
    0xbfe82841bafbba63, 0xbfe199c73d233d83,
    0x3ff65364a5714edc, 0xbff7fba8022e4cf6,
    0x3ff085decdc95dcf, 0xbfe903fef786ced9,
    0xbfe2844e401db337, 0xbf8f7894205b22e0,
    0x3fc66450fe61aebc, 0x3ff06fe6762d63cc,
    0x3fdbc9038ff75f24, 0x4008e09bd90cc3b1,
    0x3fdb4c309c22fe04, 0xbfef5a4e4c2ac2b0,
    0x3ff3bb6f9d8e4a15, 0xbffb24da8f3efa35,
    0xbff3de0201e7ec56, 0xbfd19068b8931fe6,
    0xbfeb7c1e45d51b11, 0xbfdcab54a48d7b6a,
    0xbfe3f00dd20341ec, 0x3fe2bd271373b546,
    0xbfe81ede88104005, 0x3fa2697ae6f53220,
    0xbff350c0481ed79f, 0x3fdb9657f972eca8,
    0x3fedb78b3f7d97d5, 0x3fe4437dbf88b8c1,
    0xc00558d477403c27, 0xc00280aa7f8d4361,
    0xbffb4a2456d8fd20, 0xc0023a9c19d8d168,
    0x3fc49cf2c080cb64, 0x3feaa8df341af3f6,
    0x3ff7e5312385a363, 0x3ff5da51ad3b645a,
    0x3ff624b4a6541690, 0xbff7e37412568a8e,
    0x3fb416123098c7c8, 0xbfe6c51c6b6e81f0,
    0xbfe29e7806506dbf, 0xc00284f1b84788cf,
    0xc0090cfca0766501, 0xbfe6528428520a82,
    0x40018f03bee2fbb6, 0x3fe02930941494a0,
    0x3fc1172c335fe1f8, 0x3fcadce0c684ee24,
    0x3fb4b8265c4257ba, 0xbfe6e5dc02739408,
    0x3fdcaf55ab015a78, 0x3ffef8ba165dc760,
    0x400340d7795f6718, 0xbfe18e484d697d10,
    0xc00489ea5031e3c7, 0x3ff6807502d8324e,
    0x3fea6e82530e652e, 0xbfeb0e769e0c1752,
    0xc001c60612e86064, 0x3fef11bb43dae114,
    0x3fe53c0928f9b1de, 0x3ff3612f9955847a,
    0xc00acff017db9a8a, 0x3ff44758b85cae48,
    0xbfe7d5a11310e4c9, 0xc005a9a00ebe60fa,
    0xbff37baaba0e2170, 0x3ff42b97f40b0982,
    0x400645dedff4ca08, 0x3f8db6c832064480,
    0xbfffb2e04509dfae, 0xbffcedd5b696fa92,
    0x3fd768711b1b1ebb, 0xbffd452a165f2a98,
    0xbfe0e6bb8659c276, 0x3fe3ce34f6d969a9,
    0x3fefd310fac86f12, 0xbff78d44c86bffd4,
    0xc00168017bc3b06a, 0x3ff3508306d2cd69,
    0xbfd72d2d49bb18fc, 0x3fee2dfa8f6943c4,
    0xbfd177dfff040fbe, 0xbfb2367cc8d7d940,
    0xc0012394436dc7ba, 0x3fc20abf1d5fd670,
    0xbfd90625f1fa6012, 0xbfd6c2f13f7696a6,
    0xc006dd0d158320c4, 0xbffbc76a788ff87e,
    0xc0011615e1839963, 0x3fec650d02aebf74,
    0xbfcb1451e7c301e8, 0x40010501525e1e06,
    0xbffddd67142cd48e, 0x3ff6446d3b7481fe,
    0xbfd65065a7d038ec, 0x3fe45cad42ad0ed2,
    0xbfe7e38503b5b676, 0x3ff71e3abef49e32,
    0x3ff54bda0258fcce, 0xbfd55dc0d5573c90,
    0xbf91fe7266714430, 0x3feaa7bfa0808394,
    0x3fdf4e6d57c697f4, 0x3ffb23b5f7dd20d5,
    0x3feaca5c34d0f109, 0x400101097841cad6,
    0x4001afca18092fb2, 0xbffa7fb1ad2e1f1e,
    0xbfea4e3f7a790abc, 0x40027be296b5caf4,
    0xbfd817bb6a9197a0, 0xc00560db3473b223,
    0x4009900008b28966, 0xbff89d9e5b410040,
    0xbff292a86c1b400f, 0x400864bd8d9782d2,
    0xbff778bcf01abd7a, 0x3ff5b447e7d619ea,
    0xbff09847036b3083, 0xbfea14d834996148,
    0x3fe6eee4a7e7d671, 0x3ffa59870075a81a,
    0x3ff003233d0dcd42, 0x3fe976ce3968e2c6,
    0xbfed4dbf18936acc, 0xbffc9eb3ff071845,
    0xbffc4a2f6268350a, 0xc0005f6bf094e021,
    0xbff2eab1e787e2c7, 0x4005191d3a464e84,
    0x3fed2a6b1d0f4b25, 0xbfe63726b7d195f6,
    0xbff6e31646128c6d, 0x4002e796fc792c6a,
    0x3fe764f738c53ba4, 0xbfef6e28714b8ccd,
    0x3fac0bd7954c8a60, 0xc0046e16a1820cb8,
    0xbfc6d3baccc251c8, 0x3ff279ae06b9bd5a,
    0xbfdbe26cf91ee4fe, 0x3fe77daa8d3af5a8,
    0xbff45df97ca853f6, 0xc00343ec4129c5d5,
    0xbfd602a92d9b7c20, 0x3ff93ab7a63e3807,
    0x3fa2eed1ecf40c60, 0x3fc306a105985c60,
    0x3ff1d10512660144, 0x3fe13a8cd43c438c,
    0x3ff282bb85865893, 0x3fde6140e8c15e2b,
    0x40041e3b6aaf5781, 0x3fe93b8f75110dff,
    0xc00132534fe5c91a, 0x3ffc29235efc08e2,
    0x3ff58d8c2228a8d2, 0xbff91e75aba3d505,
    0xbfd3e97982837418, 0xc00030bdd4144e9a,
    0xc0066506bcb5cec6, 0xbff0c116036ed75c,
    0xbff19d4bdf0505e7, 0x3fe39a42dd1bc652,
    0xbfe2f352f1f0170a, 0x3ff16e288d6db0b8,
    0xbfd227f5443fb334, 0x3fce626ba69d28ae,
    0xbfc6110443722fb0, 0x3fff82175ddba2e2,
    0x40120ecbe5987581, 0x3fe8da2f128ef03e,
    0xc001838faaa602ba, 0xbfe0bf8f72e80fa7,
    0xbfe7be60afd25ad3, 0xbfe2fec7c036f096,
    0xc0022085ef34d2a1, 0xbfe264ba76b48543,
    0x400130d18119f55a, 0x3fe36645dbfea34f,
    0xbfe2388aa3df92e8, 0xbfda9f93df3941b3,
    0x3ff2f1a3bc48dce8, 0x3ff3b147c35fc32d,
    0xc00ced17a3158c82, 0xbffc8c088cfcc7a0,
    0xc002745059924520, 0x3ff74d295ec34045,
    0x3fad97eac98c2a40, 0xc0075d585eb4cbec,
    0xbfee6401ffed48aa, 0xbfd6f88204902dae,
    0xbff0f959c3f430c1, 0x400778a656117bcc,
    0xc0029ea33295ee2b, 0x3fff209b3eba8368,
    0xc002d1f5cb12bf28, 0x400e53ab6ee66d26,
    0xc0080a32baa5fe3e, 0xc0081f99a5a1596a,
    0x3ff2dba833cb998c, 0x3f7b6472bffc7000,
    0xbff78799387eb0de, 0xbfdbc5a3e9239cf6,
    0x3fc621261484ae37, 0xbfe2ebf525a3f9f3,
    0x3ff457afede5f6c9, 0xbfe90b4249ec765c,
    0xbff413ba8a13d4b4, 0xbff3d3e10b00d0fb,
    0xbff51f021e03530c, 0xc00074c06860c9bb,
    0xc004e3c5032f3bf0, 0xbffbdf8a8a20196d,
    0x3fe8841c1eab89ec, 0xbfe9b73042827f8c,
    0x3fedd030831fa9f0, 0x3ff20dd6469ba452,
    0x3fd8e48a97602fe0, 0xbff58250826eed9a,
    0x3ffebfb092aa7e2a, 0x4001975516f75c69,
    0xbff06873b80dfa0f, 0xbfcad7c6feba0840,
    0x40012fcb1ef5a93c, 0x4000d0b78e1c3dd2,
    0xc000643aa263ba3a, 0x3fe8887aac7e1fe6,
    0xbff65c6dfedf8b12, 0x3fe06be8b14b8dc3,
    0x3ff71413ee3d0a96, 0xbffdee24ff153f1d,
    0x3fcdc579074c084c, 0x3ff05e3663f88169,
    0x3ffbba867d318c4d, 0x3fe141c581257d00,
    0x3ff47ceecb9eb1c8, 0xbff0f736a9122ab8,
    0xbff1c8cdc462ce0d, 0xbfff676e307bb5ba,
    0xbff7e07f1104e8f0, 0x3fd9cb34686e702a,
    0x40080cc39df58e2d, 0x3ff4a3bcd736beac,
    0xc007cb369a7c89f2, 0xbfe7a4d6d61547b7,
    0x3fe917488e83f0a8, 0xc01848e0eb1e0ab5,
    0xbff32726ae7007e7, 0xc00592b352746e96,
    0xbfed6e4671a2f146, 0x3fb86dc107ca3178,
    0x40074955c5a2d909, 0xbfe42b5989c76208,
    0x400a739255b5447d, 0x400b4a92e58f94eb,
    0x3fde63d07f2f0bd0, 0x3fe4c2a61b35d874,
    0x3fd7ded66915af16, 0x3fe4398da7f88d75,
    0xbff5c19814d499e4, 0x3fd74f1f355cd9a0,
    0xc00015eedff1a4d6, 0xbfba7dbc7ef84b14,
    0x3f9295fd551cd6b0, 0xbff7158f66ba897b,
    0xbfd62796039ad352, 0xbfefc04c2f9d5f40,
    0x400716dbbaea0d76, 0x4006bfabb229b9d6,
    0x3ff395178eeba088, 0xbf95c71b41483c00,
    0x3ff06c89c6cb11af, 0xbfe4c2c2ab0f2c80,
    0xbfe22205ae10697a, 0x3ff3fa13daa6f53c,
    0xbfee6f5b20c6efef, 0xbffb99be46fd9ba1,
    0x3fdfbb214057f7f8, 0x3ff8287094b1e3ec,
    0x3f9da21ce57b2a60, 0xbfebb877969b1726,
    0x3ff9f752933f1c34, 0xbfed2e72287ebe02,
    0xbff60a9cae40c6fe, 0x40086629975a90f8,
    0x3fc0ca38807cbcd8, 0x3ff49b36013977d0,
    0xc001669348aba292, 0x3fd70b98c1ae3642,
    0xbfa19ad11524bfc0, 0xc002818c0348182a,
    0x3fe644081f9c2ceb, 0xc0028cd881d3e40a,
    0xbfe50f212952adaa, 0xbfe4ef9940529cba,
    0xbff13b166a74c7f3, 0xbfd31c0248164e79,
    0xbfff1b70a78689c5, 0xbfbfdc1ce9a2fea8,
    0xc00b4b5053fa9864, 0x40010d5015b78da3,
    0xbff04b77c353ac98, 0xbff0f03f087a417c,
    0x3ff4b4079583ed54, 0xbfe720e332f43d88,
    0x3ff90654293300c1, 0xbfe0983acc0e123c,
    0x4000ce41a764a65a, 0x4001b0e43319a67a,
    0xbfdaa09e917d7df7, 0xbff21081caed5b60,
    0x3ff213c3924a0698, 0xbff2ab72846d0a8c,
    0xbfd4439ffccc027c, 0x3fde1256237f7324,
    0x3fead0d65a4f5d3c, 0xbfff0bc0e62195b8,
    0xbfed77c2bcfad2e4, 0x3fdbe050f9e0ca54,
    0x3fe06dbb7d27a35e, 0xbfc5219350295600,
    0xbff5a64e2ac6e60e, 0x400f51f01a7746c2,
    0xbfee4aba1764a514, 0x4003dae423e715f6,
    0xc002f9b80e3aec13, 0x401323c83e589ed6,
    0x40009b18a9b32fcb, 0x3ffd8e6dc32c98ca,
    0x400a638c1b461ddc, 0xbfe49dbd345a450a,
    0xc00685d9f76af322, 0x3ff417bf1b9631f3,
    0x400f43ec91accde6, 0x3faa37a1b7800e90,
    0x3fc458dfbdde99ec, 0xbfec5ec65307fbdc,
    0x3fec699ac69bd6f2, 0xbfff23298da49594,
    0x400ee355707a6d84, 0xbfff0f93fd3db7af,
    0x3fa74779cb0802c0, 0xbfe0f5610babef86,
    0x3ff1c66c8e30ea4f, 0xbff1f158ef2f170b,
    0x3fd590c9b08e28d2, 0xbff6ddedc49df1a1,
    0x3ffc005b53314877, 0x3fd4409994e8bc7a,
    0xbffc6e05ab11c8cf, 0xc003a543dfad928e,
    0xbfefb134826ad55b, 0xbfe41c44930f8f7a,
    0x3fe26e7e8073a2f8, 0x3ff36c3fc06bd450,
    0x3fcbfcc9f52ad510, 0xbfd5bb29cdcce120,
    0x4016e05b76882a47, 0x3fe5916719f59e7c,
    0x3ff681fe383054a0, 0x3ffbc1fd7809dffa,
    0xbff93534632d3305, 0x3fd857b12ed21ed8,
    0xbff874f5311e1898, 0x400817b5a2642c42,
    0x3ff39caabe11f422, 0xbfee07dff0af6036,
    0x3fe356a95f5f6440, 0xbff1d89c086ab03e,
    0xbffc2aef6341228d, 0xbfae912ae2dcefe8,
    0xbfe1fba4bc78e3c0, 0xbff69b96e7ebce78,
    0x400cc07edb6db228, 0xbfc3604ccf8c1ffc,
    0xbff8b72f27a36a3e, 0xbfd6f2ae4f251312,
    0xc00148c0bc82b3df, 0x3fdba6357c5c22ee,
    0x3ff56d653e3810dc, 0xbff9deaf1d2f989e,
    0xbfd3b52f1a3c7280, 0xbffb360c421d3c55,
    0x3ff9473127ef152a, 0xbfe1972501c88686,
    0xbfe421375c04562b, 0x3fe5e38b30866f66,
    0xbfeeeb95e0bb1775, 0xbff2f5068e19c6e8,
    0xc0020401cc7d1d7a, 0xbfe719a98875051f,
    0xbfddd6a23f855556, 0x40056925c09f7690,
    0x4000f0493b02e0bd, 0xbfb917930bbb0220,
    0xbfd7e12c6c38e660, 0xbfacbf5d2b1023b8,
    0xbff4e60445c2a79a, 0x3ffa3cb99c16330b,
    0xbff64d3daf149b10, 0x3fe467a91ef2d0be,
    0xbff391cb65e3a31c, 0xbffc66ee080d8089,
    0x3fb0db2a567dae00, 0x400572417b907b3e,
    0xbff0cf7662b74d67, 0xc0040d44fadf01ac,
    0x3ff5e084c83be076, 0xbfd288fb3b21b417,
    0x3fdd3d0aeb4a27db, 0xbfb30cb0d40091f8,
    0x40039cb2e688ed99, 0x3fbe8ed06935d110,
    0xbfc90d29b0ea066c, 0xbffcea1f5083a02d,
    0xbfe2b0fb1346d26d, 0xbfc911181bdede78,
    0xbffd9ac24aed808d, 0xbffeec5a83d44f86,
    0x400904b59774bbb4, 0xbfca70d30e086168,
    0xbfd727d9e7c6f3db, 0x3feb95c4c3cf5ff7,
    0x3fe557e0686cae12, 0xbff284fb1500b4f0,
    0xbffc177dbef329ca, 0xbfe9016d48be7c12,
    0xc006cf3510a23aea, 0x3ff764c1912d4c8e,
    0x3fe400b0a22ac753, 0x3ffbc59446ce08a4,
    0x3ff4d5c3b594ca20, 0x400089cf559bd650,
    0x3ff1d858b38b211d, 0xbfe80c3f7ad48a14,
    0x3fe56462d3ef1914, 0x40144cf2d5f65336,
    0x3ffa07b8e7ddb6eb, 0x4005d7e06f60ffe0,
    0x3f90b8ab37908fc0, 0xbffa4b622a818ecc,
    0xbf855bc3d02a7d80, 0xbfc731f773b6ba10,
    0x3fff33e955cedcf3, 0xbfd046b5a257070e,
    0x3fe3b7b37b493d7a, 0xbfbfe34e0d241532,
    0x3fd19b367546ff18, 0xbff4029fe777122e,
    0x4002d27465953850, 0x3fc843250895cd90,
    0x3ff69fa2017f02d5, 0x3fc210fcf7c89ee5,
    0xbfe07a3952a9a773, 0xbfff05502ec0d670,
    0xbff7ca2157a8a7c6, 0xbfe38daf6dbb0f85,
    0xbff20fdcb69aa5a3, 0x4011234ec3a7af1f,
    0x3fca541da11c9407, 0x3fe1f3ee3e6591e0,
    0xbff6b4063fb21847, 0xbfd2f4a32764c7b6,
    0x3ff955e30928f4f0, 0x3feb36265fc57d52,
    0x3fe7d786c108eddd, 0xc0020b6b45f759a2,
    0x3ff82e7898247d9e, 0xbfd28da9db480ff4,
    0xbfa0ca21ed51a920, 0xbff530afa24f6d96,
    0x3ff6f4b55e89115b, 0x3ff4d0c0cebf047e,
    0x400fb5b25aae477a, 0x3fd77a3a0ce26b24,
    0x3ff09f36e51128ea, 0x3ff6ac338a4c7c8e,
    0x4001af84e3344ab8, 0xc00a96b0363e700a,
    0xc009e482052bfff3, 0xc000b061f4f95de6,
    0x3fdc8a9cb6edcf49, 0x3ff006e6a4af786f,
    0xbfd519c76ac6d1c0, 0x3ff0ae1ac76595a9,
    0xbfcaec617e95702a, 0x400b7f5e7dbb66ac,
    0xbfe382429b5fffb0, 0xbfe57f52204e0d7e,
    0xbffca29f3b7b51ac, 0xbfcff5eadb03d704,
    0x3fd2cdc43eef2080, 0xbff6c84bcd9e2b18,
    0xbff9e698fcaef56b, 0x3ff8d83891065d3c,
    0x3ff01025bb5eade6, 0x3fe468ed593b05f4,
    0x3ff6ec2705709d98, 0x3ffa4e7adfa2049c,
    0x3fe19cdea924f260, 0xbffa8b0e2570519c,
    0xbff7f6176133751c, 0xbfed6271caee4277,
    0x3fff77ce3352b431, 0xbff78ee54a56f4be,
    0x3ff5ee906e8f0696, 0x3fe6b44f7a016246,
    0x3ff1f78ef78132cc, 0xc0025ea046d424d8,
    0xbff4805a4fade0d0, 0x4008f9873458b170,
    0xbfdf9a12815ae892, 0x3fb854924840e54c,
    0x3fc26aa661e18b20, 0xbfecd60bfa274cd4,
    0xc0066b81d0a7ebd6, 0xbfed1e60b4f7bfb5,
    0xbff9e7bcd7222392, 0xc00b78303725e7fc,
    0xbff93067daae8867, 0xbffe4137567f9e79,
    0xbff822a69c7130e4, 0x3ff3d4bd0540d798,
    0xbfb480aade3a5ac0, 0xbfe5b51baeed96f4,
    0x3fb07d3ee57fe420, 0xbf8bde2c253b85c0,
    0x3ff7921b99c8e2d5, 0x40011bd586e5dc91,
    0xbffd17f3606fa631, 0xc000e30556c47162,
    0xbff5511fb65726fc, 0xbff9322d0ad673ea,
    0x400131cc1804a6b1, 0xbfdb602382619caf,
    0xbfff71b28db77261, 0xbffcea0eee2f68a1,
    0x3fce0f76b39d8711, 0x3fd15e797ece57c0,
    0xbff1691c8063a8f0, 0x3ff57c612011c12c,
    0x3fc8843c1714e2a8, 0x3fe9496ab4198ac9,
    0x400b73762cccf973, 0x3ffcfc948960586d,
    0xc0027db2a9fdb81a, 0xbfeab5dd036143cd,
    0xbff0f20cfa89a35f, 0xbfe800bf37564d21,
    0xc00de447908fb19d, 0xbf8424635955f980,
    0x3fffb9a7810fef40, 0x3feb8710d042c2bc,
    0xbfe9af21fcdbfbf5, 0x3ff010a0b86c221f,
    0x3fe7f18e9a3dfa68, 0xbfdfed6f46b8e678,
    0x3fdd97fa4d78dc02, 0xbfa9ffe459539050,
    0xbffda69e66fa0fd5, 0xbff3e0de98e4cad5,
    0xbff12402b824169e, 0x3f4c811460150000,
    0xbfe851a3b5f9ad7d, 0x401326d27b15cd6e,
    0x3ffbd9c9b65596ff, 0x3fed16614af1c798,
    0xbff3e8cd1fbf7a84, 0x3ff1d8e64eedfb0e,
    0x3fb65bd145d26bf0, 0x4000454d08f767f0,
    0xbff522281326ed85, 0xbfe8713ee900103a,
    0x4006a043663d210b, 0x3ffa1bcef2bd425c,
    0x40031508fe4987d4, 0x3fd0983845e14a00,
    0x3ffbf10c3073f435, 0xc00a28e6259f5b3a,
    0x3fe118cf8d44909e, 0x4001c6425cb669c2,
    0x3fe0cc5cb18a0299, 0x3fec4fca35449488,
    0x400730c9a6a381af, 0x3ff6543d09063298,
    0x3f9ddb88acfc36b0, 0x3ffe1b384eb72ef4,
    0xbff4e162fc24f757, 0xbfca125d759c7594,
    0x3fe4b4e244c8f600, 0x3ff08474e21864c6,
    0xbffa2e3e0df7972c, 0x3fe5acf0debf8d27,
    0xbfec334e62ce2446, 0x400975d84cdab7d3,
    0x3fab4cbd947e8098, 0x400f7a6aacec0300,
    0x3ff17c1061215fdc, 0x3fe367be0de2a41c,
    0xbfc7e0ae4f92a500, 0x3ffd75654ec75844,
    0x3ff622bf9db44527, 0x3fd0c646647d5f4a,
    0xbff7a796b0b511ca, 0x3fe123473b423d04,
    0x4005be48b8122141, 0x3febcd4b733025dc,
    0x3ff2aea1c007e932, 0x3feeedcb36e983a4,
    0xc009b8ab885cacff, 0xbfcfbd5c96986f4a,
    0xbffac4b8faf3700c, 0x3ff3fcd2b4920234,
    0x4005f0a610869850, 0x3ff5b0a44c842291,
    0xbfd05c8569ff6686, 0x3ffa89d7b0a2b4e9,
    0x400102cbb5454043, 0xbffec057e6945f43,
    0x3ffc60d1b968ae28, 0x3ff189bed5f8f87f,
    0x3fd3b0ab7cf27400, 0xbfc03854840b2024,
    0xbff5ca4a71bf60fe, 0x3fd60f646633a34c,
    0x3fe93f7e8d7f57a5, 0xbfffd5cb45bc95da,
    0xbf99d2d7f2d009e0, 0xbfcbb5bb080de0f8,
    0xbfee7df494405d11, 0xc0021df316b881d4,
    0x3fed4fa5211c9ca4, 0xbfb38473a0d81b90,
    0xbfe1e4b1e5e12630, 0x3fb02cc96a702e00,
    0x4006b02ee2babb22, 0xbff5da182ec26cde,
    0xbff5b3e98cb29aae, 0x3fe957fced062f35,
    0xbfe36ce9d3468b10, 0x3fe34144fbdeb825,
    0xbff362f8fc302a65, 0xbff2eb74e95ccbb1,
    0xbff8dca0151e4575, 0x3ff3520648731ad7,
    0xbfa14288a51a55f8, 0x40004ff0b604e358,
    0xbffa9ff8701e2d98, 0x3fee78d0e6c3d8f7,
    0x3fd9b7e3e25d8ec4, 0x3fb9a45ce4dbbdf0,
    0xbfe4704bcf0c5a3e, 0x3fb8d54081c94458,
    0xc00e125934a59888, 0xbff52ce03c3dcdb7,
    0xbfe9351abd5427e0, 0xbfd3b58e16287271,
    0x3ff8cd0d5d165d7b, 0xbffd463edfd0901f,
    0x400557fc3183a130, 0xbfe62c46c611ff3a,
    0x3ff07fa3e0039d16, 0x3fe061e84bd179c6,
    0xc009e206bfb8aa75, 0xc003dd7aca3a9932,
    0x3fe921aa030acdb9, 0x4006f3c5080f672f,
    0x3fc6582c70baabca, 0xc003641c4040b8ef,
    0x3fc1ebe080c0c7f8, 0xbfeeac53e5d67514,
    0x4010c9e7b229f01a, 0x3ff472569ba88661,
    0xbffa6ab45a1bac2f, 0x40045183301f2de0,
    0xbfd33a2f95721c20, 0xbff943a78b7a8116,
    0xbff97c936aefde8c, 0x3fb718020fde58d0,
    0x40031a84b5f992c5, 0xbff3a3e46a632335,
    0x400bf10a2ba0ad0c, 0x400d17481c7e8b00,
    0x3fb3345fef43d02c, 0x3feb61388bcd3ed1,
    0xbff1ee541f8767ac, 0xbffb3011ee3b2cbc,
    0x4013b6fc15c4479e, 0xbfee286cbf9c2234,
    0x3ffd389dac704680, 0x4011793afe53305b,
    0x400337acb3aec66f, 0xbffffc968070014a,
    0x3fde4300811466d8, 0x3ff9a33f62b7faaa,
    0xc004942284f6ded9, 0x3fb3006ffd27c794,
    0xbfe17adbf18a225c, 0x3fe761ad9f75fd9a,
    0x3fef0d14e994e6f4, 0xc003e2439e701507,
    0x3ff7b75e6c044dd5, 0xbff1fe1147ca6285,
    0x3fe990c8497caa9c, 0xbfd03bff2242f148,
    0x3fec04a2059f41c6, 0xbfe357b3912b2540,
    0x3fe467e1fd288627, 0x3f9f7f3628d6a500,
    0xc00a7f4f09771832, 0x40004a90943d9a87,
    0xc003e2ac85392f15, 0xbff6acd58534994b,
    0xc0082bfc51d24795, 0xc0076144e7e59ab8,
    0xbfeacb3fcf8aa108, 0x3ff2a5275c3d18c6,
    0xbfdff2fdc04d03fe, 0x3fdf6e3fa658139b,
    0x3ffb047d29fcddb8, 0xbfd534d11505cda8,
    0x3fe7b5472a6b2299, 0xbfcb872aee0d88a4,
    0x3ffbca576de963dc, 0xbfdb5620013aa177,
    0x40069ab52a27ec17, 0xbff21c8cc14acabb,
    0x3ff5a9c01a3c7aa2, 0x400db1d7ba1a5793,
    0xbf8e85b15555de80, 0xbffe472f06ae94d0,
    0xbff4d81b3e3859b0, 0x3fc5d91ed4e1dbc0,
    0xbff59269fe687cb6, 0xbff42a588150bf96,
    0xc00857776ae9ea0e, 0x3fe04d7f1ac64b77,
    0xc0042bf02d4d3904, 0x3fe0c9e2258e3688,
    0x3febdb18039a3cf2, 0xc006be1c9e04e8e9,
    0x3ff28d411e6d45bf, 0x3fe11d2ed6a5cc30,
    0xc0037795f9b41d28, 0xbfd0d046a8a8d7ee,
    0xbfffce465c8de820, 0x4086621cae230b0c,
    0x3ffe0b5daab47d72, 0x3fe6d36a603fd804,
    0x4001dffe1c59d123, 0x3ff2305251c9ecbc,
    0x3fdaf7aee5862a6e, 0xc0012e68151a5f60,
    0xbfdd98bac67b6b82, 0x3ff645930f0bbeb4,
    0xbfa661978edd76a0, 0xbfec7790abf20782,
    0x3fe620f7d0fc1401, 0xc00b23b69a42408d,
    0x4005619dad723b58, 0xbff30a04d646eb0c,
    0xbfe1e74d77333586, 0xc0087b3a19c0165a,
    0xbffe8a6e7b1d151a, 0x3fbc61c5167118c8,
    0xbff7e71e6c24f0b7, 0xbf9d25db2bc8af30,
    0x3fd96b5618c90ec8, 0x4003942694973510,
    0xbfd9ab2aa494c7b8, 0x3fd7985ae4bc8ffd,
    0xc005dbfe4783c5b3, 0x3ff6b9961274a784,
    0xbfd62c756c442c30, 0x40027146c6295a3c,
    0xc003ad51007a736c, 0x3fdc53f1afc2dcd0,
    0xbff12f2589adeb1e, 0x3faf5c1e22e8e720,
    0xbfe35fe1ff2ce458, 0x3ff7769b8269da86,
    0xbff66b95f9cbf55e, 0x400c996483216157,
    0xbfe0cbabeb6c446c, 0xbff7b1f615afa2ce,
    0xbfe073582b16b680, 0x3ff959844fb176ac,
    0xbfcb915790f1b618, 0x3fb0ed2df566d390,
    0x3fc865ede0e9c1ea, 0xc000fde17c24d0d7,
    0xbfd2c870de880dc4, 0x3ff7826a23cb0d34,
    0xbffc600ec6844a22, 0xbfe2a5f99021ca2c,
    0x3fe97c0e8661ce62, 0xbfdde3d7aa92ef54,
    0x3f88f01af0989a80, 0xbfca85ca9c328982,
    0x4006f3d8b3627e47, 0x3fed97e13053dd00,
    0x3fb4f258920201cc, 0x3ff8dfd9646f55dd,
    0x40007f6831d81ab4, 0x400271f35facb3cb,
    0xbfe838e529e37346, 0xbfe6164120def89d,
    0x3ffc2b2c7b92db86, 0x400151a578c0e829,
    0x3fe986a9138bfa1e, 0xbffd0a0e5bf0ed00,
    0x3ff17906b5cba5ba, 0xbff93186f852e753,
    0x4003b6aa097c96e2, 0x4010b6d5e65c2877,
    0x3ffe8948605b336a, 0xbfeac4a0d0d7c591,
    0xbffde1a26a1add7f, 0xbfe47bac3a5d286e,
    0x3ffeed27851cd33d, 0xbfe0fa9a8152846b,
    0x3fdca5759f4fa36e, 0x3fe2f23e0b7ccdfc,
    0x3f8577f11abaa880, 0xbfee591e9dc10486,
    0x3fd89081d55f62f8, 0x3ff2dd62a22a4eb7,
    0x3ff9dc27e4266b51, 0xbfcb4b199b117128,
    0xbfdf4f493e22ef27, 0xbff3f69a47e2fb48,
    0x3ff0ea46f1da6f12, 0x3ff47b2bf9ae6c54,
    0x3fb7206362ba07c4, 0xbfe118b4bbf5516e,
    0x3fec3d011facd0ca, 0xbfe27fceeb62cf80,
    0x3ffd3fada454a135, 0xbfc5187ab3a72190,
    0x3fe8b4c1c3894f51, 0xbfeaeccee41e8ba2,
    0xbfe18e081cf810b8, 0xbff80f2861b8bd39,
    0xc002ca5c8f72c5de, 0xbffe63642ba866c9,
    0x3ffb2ac066c23edc, 0x4001a973d60d1e6e,
    0xbfe360a4c340e779, 0xbff38f053d64bcae,
    0x40084c40c8f6b450, 0xbffb3b78bc6646f3,
    0x3ffd9941789ae995, 0x3fefd79f29facfb6,
    0xc0051ccd5fc9db44, 0xc002501eb3016957,
    0x3fc3f9e3fa1b9bf8, 0xbff432fcb5dff038,
    0xbfce8984d023c3b0, 0xbfe533c599f5af25,
    0xbfe1df3a8bfc5404, 0x3fc0422b7dc147d2,
    0x3ff597e88d972138, 0x3fe1ae9c8ca19e43,
    0x3fd94da0d40764af, 0xc00ee894d3ab53ba,
    0x3feed18c4ab3c3a0, 0x3fc0858e06bd0339,
    0xbff253f5b1e7c8ae, 0x3fec09d8f5c6529a,
    0x3fedf6bdd4010cd8, 0xbfce38697fc2a44e,
    0x3ffbb22d036d648d, 0xbf8223465f675f60,
    0xc00f7db9db26c24e, 0xbff1443b2bb146ba,
    0xbfa91e50dd521344, 0x3fc2d673d0f9a714,
    0x4000acc75125dfb5, 0x400a0946ea11a4dc,
    0x3ff19dd78fe14ba4, 0x4000e77ebdaaba68,
    0x3ff97b2dab0417cf, 0xbff15b7e6dfd18a6,
    0xbff8e109c24d23ad, 0xbfe20c70bb2c27cc,
    0xbfecc890111a8142, 0x4000cb914ebc5066,
    0x40074f7b75c7bfb6, 0x3fe5028a79314782,
    0x3fe838735c6fbe32, 0x3ffcf1486c6aed44,
    0xbff1e14dfe9fbcb2, 0xbfef513443c10e7c,
    0xbff243d4da38e2d6, 0xbfd01c8d5f8f88c8,
    0x40042f8a4da3bb09, 0x3ff68bda0aaa9d22,
    0x3fe3bea5bcff86fd, 0xc010a472dbb92297,
    0xbfe48fdca90cbd10, 0x3ffc1b7d58a5c560,
    0xbffbe4b82c536f86, 0xbfddf37dfd98c8c8,
    0x3ffd9aa4ffafc0e4, 0x3ffd8121246479a0,
    0xbffdbdecabf7a534, 0xbfcb2a4e69036df4,
    0x3fed9e0c3c4c8a9e, 0x3ffcbba670d7ebcd,
    0xbfb95d96496c5fd4, 0x3ff10e053ff64239,
    0xc006ad1d01e7223e, 0x3ffa4be46d0af6ea,
    0xbf846d3194905b00, 0xbfe2f390fa98c8cd,
    0x3ff3f4416d184472, 0x3fe00d53e22e3aa4,
    0xbfd2b973346c10e6, 0xbffe9213f73f8619,
    0xc00129cc41119068, 0xbfde4b35c84ac0e2,
    0xbfe7c056b6747202, 0x3fffecefe14bb756,
    0x3ff463fa5e323aba, 0xbfe9a01f0aa8cfee,
    0xc0047e419f0a2420, 0xbfe997d2a93d26fc,
    0xbffb7c6cebbf8618, 0xc000e97288291f19,
    0x3fe15ddc0f1cdd00, 0x3fd4352fa1b340b6,
    0x3fcd79d5fbf2f1d8, 0xbfe2b118c3bf6264,
    0x40104d4ad8774026, 0x3ffe1fef24e81993,
    0xbffd1f4a6753c870, 0xbfaa942f396eeb90,
    0x3fc485345f071e08, 0x3ff3240067240cf5,
    0xbf8f60445994afe0, 0xbff800dc2c1c0fb6,
    0x4003393e1147695f, 0x3fdf4b3a175ef3ba,
    0x3fd7c4c60583e4b5, 0xbff3864fffc7f032,
    0x3fce0d28a2313658, 0xbff90944a5d50e68,
    0xbfe1591f88eee6c9, 0x3fe1f5368db5abb2,
    0x3ff6ad40188280ca, 0xbff0ce28ff1004ed,
    0x3fbffdf985bd7a10, 0x3fd8a2457883a567,
    0xbfe3563d8819c577, 0xc00400d28df6aca2,
    0x3fd936823feb831a, 0xbfea5a9ead5640e2,
    0xbfcc840e835fc96a, 0x3fd656a844f6f169,
    0x4004ba150c515f92, 0x3ff47acf9766b55a,
    0x3fc0db329ebf650b, 0x3ff4e7a17653b253,
    0xbff03b4805860b02, 0xbf79555f8c563d80,
    0x3febcd43d77e37e4, 0xbfe5955f49312258,
    0xbfe703c159c8aeb2, 0xbff0a20624d18af1,
    0x3fb4a9e1723fe9f8, 0xbfe0759ccec3606d,
    0xbfccdddb7f111324, 0xbfd2cb426f1f9bd0,
    0x3ff23db602edeeae, 0x3fc7de24430462ba,
    0xbff9467b12e9f771, 0xbff6beb4c5ffda16,
    0xc00133f971cc443c, 0x3fe29278029f87d8,
    0x3fe07266263c056a, 0x3ffdb5469e21d0e9,
    0xbffb2a246eb0345d, 0xbfefa5f417ffb6e2,
    0x40037bab81fce328, 0x3fa442ac08005a3c,
    0x3ff386e8eef53ad7, 0x3fb3d4c543f709b0,
    0xbfcd6ea2396871c6, 0x3fe6cd5bf5d91f26,
    0x3ffb0ab2f9197d38, 0xbf94c17af06bfae0,
    0x3feb4003f67edd84, 0x3ff0087085aa1175,
    0x3ff9380bfcd71963, 0xbff6c30f1b840908,
    0xc004afc05faec746, 0xbfce26efaae86406,
    0x3fe936b9d8ca33ef, 0x40012a6e064adcd2,
    0xbff2f93bd90782fe, 0x3ff516b50b48c38f,
    0xc00a51198dae5a7b, 0x3fb83e8b50345204,
    0x3ff0b8494dda2541, 0xbfd87d6d817b9db8,
    0x3ff61cf1a60228d7, 0xc00e8ac97c1b9d84,
    0xbfeb1d3b2ace8829, 0xbffcacf0c2045b3e,
    0xc004495aa3e38364, 0xbfcd812a15d35c9e,
    0xc0001d38534a32b4, 0xbff1a53669dd47bf,
    0x4009e867dc59331f, 0xbfc27892d70137a0,
    0xc00245070f87526a, 0xbffee30fbb8d45ae,
    0xc001c081644b467b, 0x3ff0bded14d0ba10,
    0x3fd1ce394bf58444, 0x3feb28f40930ac77,
    0xbfe5567d02d127a5, 0x400b94dbdb6a8300,
    0xbfc70dc336a7547c, 0x3fe8721a9745bf24,
    0xbff3f5cd6c33a780, 0xbff4f1bc7b399364,
    0xbfe9a102c9001bf9, 0x400401d7c6f2ab36,
    0x3fec613988b5e026, 0x3ffaff23c0d6c287,
    0x3fc89f0bf231f198, 0x3ff289403170e950,
    0xc004f15568c73a29, 0xbfee51fb363c7b04,
    0xc003461de256e344, 0x3fcdf031078e1d74,
    0x3ffdf25ed88f7ea9, 0xbffb165402eb70ec,
    0xbfde4a10adb0bb66, 0xbfef2065f7efd61d,
    0xbff01c598c7faae1, 0x3ff29fbc40c75218,
    0xc00e4b194e5008fb, 0x4004e247b6473130,
    0xbff63bc625d5644a, 0xbff0c5319c16f3c1,
    0x3fe71c12a56822ca, 0xbff45a6169c45d63,
    0xbfd4851bdf2ec2d6, 0x3ff88fd56c029602,
    0xc0000a534a180191, 0xbff033ddd6289516,
    0xc0057cb01d728d02, 0x3fe44c364cfab8de,
    0xbffe7108edcab12c, 0x3fca912df09b47c2,
    0x3fd40368d4dfd970, 0x3fc3795cdfec1aec,
    0x3fc3bff64bdb6328, 0xbffa510fc8a12928,
    0x3fe728042b64fb93, 0x3ff5fefab832dd44,
    0x3fda0e27b9ee5684, 0xbfe9bab37b7feb5a,
    0xc00aca0d80570f40, 0x4008bb7050a5419e,
    0xbfdc98032bf4de90, 0xbfd20d3fafe1041c,
    0xbfce9f6b2c0437fa, 0x3ff62e39e342ce3f,
    0xbffb9ff4e88027b5, 0xbfd4ca1c0fbaa96e,
    0xbfb6f292b765595e, 0x3fe3ba3ad00a68aa,
    0xc00505f301ee5aed, 0xbfe8e45dfd6a988b,
    0x400a087f923deb1b, 0x40058e70c237bd98,
    0x40045c2c0cd00bb6, 0x3fe16fdf624a301d,
    0xbfe76630bd1d4a28, 0xbff88c29d4e63e55,
    0xbfb28cc0d36a29f8, 0xbfc10e55202a5fa0,
    0xbfbfe6416ead3370, 0xbff5a513bab042d2,
    0xbff3a974ee2f6a4d, 0x3fccd4ff2f86d7e4,
    0xbfe0241ba149f488, 0xbff3bf68270034a1,
    0xc011cdae691ee318, 0x3ffebd7e503beffe,
    0xbff25cb3d1c78730, 0x3ff470b0c1f2a239,
    0xbfcafe088bbea8e5, 0xbfa896c3b6636508,
    0x3ff0afcc77d0d398, 0x3fd91663d9997812,
    0xbfeb4823cf3179b0, 0xbff0e7ad8ab45e41,
    0x3fe1ea3621bb7d4b, 0xbfeb141ba4b9355b,
    0xbfeea7a01f64797f, 0x40026710d01462a0,
    0xbfeca4cf15ba45fa, 0x3fad18d529a02c60,
    0x3ff0053a3eeb0d98, 0xbfff7feaf5e0d186,
    0x3fdb8c2f79db80c4, 0xbffcb23b538a05fa,
    0xbfdb1979d829d544, 0xbfe5a640e34360da,
    0x400210c83f1f62e0, 0xbf93753362cf1140,
    0x3fc21738b5b8a71c, 0x3ffd4320edc71cb6,
    0x3fa6868705e5a658, 0xc00647ee3b8e0765,
    0x3ffc2daea60678a9, 0xbf9d1daf4fac3740,
    0xbfebf46a28ba0fe4, 0xbffa793ff22a8c34,
    0x3ffcf52564179639, 0x3fee9dfb6929418a,
    0x3fef72b9e48c8529, 0xbff6fb233462ca21,
    0x3fed079149ef8a34, 0x3fd1eb64a0b58424,
    0xbfe6dc4a5ab95df5, 0x3ffca0d8a9b193fc,
    0xbff64e5dc707944c, 0x3fdc0fa57dc258ed,
    0xbfeb5506558e6ed0, 0xbffa2095cf4bb628,
    0x400602740152b75e, 0x3fda44d68ac65d84,
    0x3ff13430695c3771, 0x3ff3532b30c70ee6,
    0x3ffe1c205496763c, 0x3ff16241400ce112,
    0xbff355e0c2ca12fe, 0x3fee95b0e50bc530,
    0x3ff63b1fb9ccf31f, 0xbff3459bf4ab309a,
    0xbffcf628e1987198, 0xbff87d89bdffbbcc,
    0xbffd1336570d1f74, 0x3ff117457a47b932,
    0xbfaa056c68490fd8, 0xbff7997c377567d0,
    0x3fb221246b2dc3f2, 0x3fe6637991ff0eac,
    0x3fe78a4592911e14, 0x3fd04a7f93baac28,
    0xbfde97b6a990c05d, 0xbfb301d1d1321a40,
    0x3fcfb7c54e2ef76c, 0xbff9d076e7aedaa8,
    0x3fee62e257314ce9, 0xbfa9a029bbf36930,
    0xbffef7746bf1646f, 0xbfe70587f0a08a4d,
    0xbfeb44e313591f14, 0xbfd7ba5ef648b16c,
    0x3ff07aac3a8ec39a, 0xc00bdc0fa9e02c7b,
    0xbfa74d051fa42180, 0x3ffab532c9e3e569,
    0xbfe4abec04b9acd3, 0xbfeb21fd0c5ecfaa,
    0x3ff3007f4c6392c6, 0x3fe8ee44567e4636,
    0x3fd2a2c8fabc3162, 0x3ff6bcb1cbf737f7,
    0xc0011af4c7efde71, 0xbfec7cbf1c22dc40,
    0x400309d0ae39c9a2, 0x3fe668249462f12b,
    0x3f80a43ac76c8fc0, 0xbfda7d94e91edcd4,
    0x3ffb332a33646f9f, 0xbfd43efda14d9a10,
    0x3fc0e4cf0f1a4dd8, 0xc003f260cdc08a03,
    0x3fdaff8b21232b41, 0xbfeafe69312f0769,
    0xbfdcd4951085cb5c, 0xbfe79dd387dc3848,
    0xc002937a3e89e99e, 0x3ff5a5bbb07b002a,
    0x3ff7c0a0b3439415, 0x4002ad9721dc769c,
    0x3fe839cec18adc12, 0x3ff54e236f330b9e,
    0x3febd35ab23f65ca, 0x3fe9f691be2032eb,
    0x3fad9b49a8e91220, 0xbfea247433657a78,
    0x3fedec5758a295f9, 0xbffe1853295d6558,
    0x3fc19810c1fa7fce, 0x3ffb9e93deb2cac6,
    0xbfd224bee7df1d02, 0x3fb5fe8bcfaba704,
    0x3ffccdb481f780d2, 0xbff1c88fcb2937fb,
    0x3fe3f63a38e3ad40, 0x3fd25903e6ea1fbe,
    0xc005fd2c3157892c, 0x3ff5d7e8a106316e,
    0x3ff5cbec53ded740, 0xbff405d45594aa6a,
    0xc004362302515ed5, 0x3fe2b343ca7af200,
    0x4002546c566895c2, 0xc003a095ec899fe2,
    0xbfffb134ac8a1b50, 0x4002c348637c230e,
    0x3fe70605098af7cd, 0xbff4d87e13924b07,
    0xbfc734a6f14a3670, 0x4005ec1c346671fa,
    0xbff8f935ff080dc5, 0x3ff74a3124482dae,
    0xbfab455502c691e0, 0xc00bfa74f904fbd2,
    0x3fd5b6855050a7f7, 0x3ffbb51bff7732f8,
    0x3fa1c007ccc25fb0, 0x3ff5b2f5e5069eed,
    0xbfe3239f4201afae, 0xbff1de57ffa1449b,
    0xbfeb9ae4edb826da, 0xbfab136a46ab71e0,
    0x3ff390abe9290e7e, 0xc00981bc3644505f,
    0x400613c19ee0290e, 0x400f21c030f929f8,
    0x3ffad0eda14837a7, 0xbfdf7e92fc4015a8,
    0x3fe629e38f190220, 0xbfef0969585a66c4,
    0xc0020ad2d063117e, 0x3fe7f44595a35671,
    0x3feaab07751eec7e, 0xbfd533df19f6eff0,
    0xc009fc5bc8cb6ed2, 0xbfe8f5336e6e1d5a,
    0xbfd73590c05d3316, 0xc00427513e5ef83a,
    0xbfe7e6857b0d996f, 0x3fe87cb9b7ca31db,
    0xbfefaa3877d737c7, 0xbfe598fc4ba3c252,
    0x3fd1a1e3e4be0fe4, 0xbfb71ddb3c79e1a0
    };

static const uint64_t ref_cfft_noisy_2048[4096] = {
    0x3fab0667ea63d9a0, 0x0,
    0x3fd1a1e3e4be0ff5, 0x3fb71ddb3c79e188,
    0xbfefaa3877d737da, 0x3fe598fc4ba3c24a,
    0xbfe7e6857b0d9963, 0xbfe87cb9b7ca31c6,
    0xbfd73590c05d331c, 0x400427513e5ef838,
    0xc009fc5bc8cb6ed3, 0x3fe8f5336e6e1d5a,
    0x3feaab07751eec7a, 0x3fd533df19f6eff5,
    0xc0020ad2d063117c, 0xbfe7f44595a35676,
    0x3fe629e38f190220, 0x3fef0969585a66ca,
    0x3ffad0eda14837a7, 0x3fdf7e92fc4015c6,
    0x400613c19ee02914, 0xc00f21c030f929f6,
    0x3ff390abe9290e78, 0x400981bc36445060,
    0xbfeb9ae4edb826d1, 0x3fab136a46ab7180,
    0xbfe3239f4201afa8, 0x3ff1de57ffa14496,
    0x3fa1c007ccc26030, 0xbff5b2f5e5069eec,
    0x3fd5b6855050a801, 0xbffbb51bff7732f6,
    0xbfab455502c69240, 0x400bfa74f904fbd1,
    0xbff8f935ff080dc3, 0xbff74a3124482daf,
    0xbfc734a6f14a3648, 0xc005ec1c346671fa,
    0x3fe70605098af7be, 0x3ff4d87e13924b0a,
    0xbfffb134ac8a1b46, 0xc002c348637c2310,
    0x4002546c566895c2, 0x4003a095ec899fe4,
    0xc004362302515ed4, 0xbfe2b343ca7af20a,
    0x3ff5cbec53ded73a, 0x3ff405d45594aa6d,
    0xc005fd2c3157892d, 0xbff5d7e8a1063174,
    0x3fe3f63a38e3ad48, 0xbfd25903e6ea1fb6,
    0x3ffccdb481f780d0, 0x3ff1c88fcb293802,
    0xbfd224bee7df1ce7, 0xbfb5fe8bcfaba704,
    0x3fc19810c1fa7fe8, 0xbffb9e93deb2cac4,
    0x3fedec5758a295e3, 0x3ffe1853295d655a,
    0x3fad9b49a8e91290, 0x3fea247433657a76,
    0x3febd35ab23f65ce, 0xbfe9f691be2032ea,
    0x3fe839cec18adc18, 0xbff54e236f330b98,
    0x3ff7c0a0b343941f, 0xc002ad9721dc769c,
    0xc002937a3e89e99e, 0xbff5a5bbb07b0030,
    0xbfdcd4951085cb62, 0x3fe79dd387dc3848,
    0x3fdaff8b21232b38, 0x3feafe69312f076a,
    0x3fc0e4cf0f1a4d8c, 0x4003f260cdc08a04,
    0x3ffb332a33646f9b, 0x3fd43efda14d9a40,
    0x3f80a43ac76c8d80, 0x3fda7d94e91edcd4,
    0x400309d0ae39c9a4, 0xbfe668249462f128,
    0xc0011af4c7efde74, 0x3fec7cbf1c22dc3e,
    0x3fd2a2c8fabc3166, 0xbff6bcb1cbf737f4,
    0x3ff3007f4c6392ca, 0xbfe8ee44567e4638,
    0xbfe4abec04b9acd4, 0x3feb21fd0c5ecfa6,
    0xbfa74d051fa420d0, 0xbffab532c9e3e56a,
    0x3ff07aac3a8ec396, 0x400bdc0fa9e02c7b,
    0xbfeb44e313591f1e, 0x3fd7ba5ef648b170,
    0xbffef7746bf16471, 0x3fe70587f0a08a47,
    0x3fee62e257314cf2, 0x3fa9a029bbf36a50,
    0x3fcfb7c54e2ef753, 0x3ff9d076e7aedaa6,
    0xbfde97b6a990c067, 0x3fb301d1d1321a20,
    0x3fe78a4592911e15, 0xbfd04a7f93baac0d,
    0x3fb221246b2dc3c4, 0xbfe6637991ff0eb4,
    0xbfaa056c684910a0, 0x3ff7997c377567d4,
    0xbffd1336570d1f6f, 0xbff117457a47b937,
    0xbffcf628e198719b, 0x3ff87d89bdffbbca,
    0x3ff63b1fb9ccf31e, 0x3ff3459bf4ab3099,
    0xbff355e0c2ca12fb, 0xbfee95b0e50bc52e,
    0x3ffe1c205496763e, 0xbff16241400ce109,
    0x3ff13430695c3773, 0xbff3532b30c70ee5,
    0x400602740152b75b, 0xbfda44d68ac65d7f,
    0xbfeb5506558e6ed4, 0x3ffa2095cf4bb61c,
    0xbff64e5dc707944c, 0xbfdc0fa57dc25912,
    0xbfe6dc4a5ab95df0, 0xbffca0d8a9b193ff,
    0x3fed079149ef8a3a, 0xbfd1eb64a0b5842a,
    0x3fef72b9e48c852a, 0x3ff6fb233462ca2a,
    0x3ffcf52564179636, 0xbfee9dfb6929417e,
    0xbfebf46a28ba0fe4, 0x3ffa793ff22a8c36,
    0x3ffc2daea60678a4, 0x3f9d1daf4fac3860,
    0x3fa6868705e5a590, 0x400647ee3b8e0766,
    0x3fc21738b5b8a71c, 0xbffd4320edc71cb8,
    0x400210c83f1f62e0, 0x3f93753362cf1200,
    0xbfdb1979d829d552, 0x3fe5a640e34360e4,
    0x3fdb8c2f79db80bc, 0x3ffcb23b538a05fe,
    0x3ff0053a3eeb0d91, 0x3fff7feaf5e0d186,
    0xbfeca4cf15ba45ff, 0xbfad18d529a02cc0,
    0xbfeea7a01f647976, 0xc0026710d01462a2,
    0x3fe1ea3621bb7d47, 0x3feb141ba4b93555,
    0xbfeb4823cf3179bc, 0x3ff0e7ad8ab45e40,
    0x3ff0afcc77d0d398, 0xbfd91663d9997802,
    0xbfcafe088bbea8ef, 0x3fa896c3b66364a8,
    0xbff25cb3d1c7872a, 0xbff470b0c1f2a236,
    0xc011cdae691ee316, 0xbffebd7e503bf00c,
    0xbfe0241ba149f48a, 0x3ff3bf68270034a2,
    0xbff3a974ee2f6a51, 0xbfccd4ff2f86d7e4,
    0xbfbfe6416ead3388, 0x3ff5a513bab042d1,
    0xbfb28cc0d36a29fc, 0x3fc10e55202a5fa0,
    0xbfe76630bd1d4a2a, 0x3ff88c29d4e63e4f,
    0x40045c2c0cd00bb8, 0xbfe16fdf624a3013,
    0x400a087f923deb1e, 0xc0058e70c237bd94,
    0xc00505f301ee5af0, 0x3fe8e45dfd6a9883,
    0xbfb6f292b765595c, 0xbfe3ba3ad00a68a8,
    0xbffb9ff4e88027b5, 0x3fd4ca1c0fbaa95c,
    0xbfce9f6b2c0437c6, 0xbff62e39e342ce3e,
    0xbfdc98032bf4dea2, 0x3fd20d3fafe1042c,
    0xc00aca0d80570f3d, 0xc008bb7050a541a0,
    0x3fda0e27b9ee5688, 0x3fe9bab37b7feb5b,
    0x3fe728042b64fb97, 0xbff5fefab832dd44,
    0x3fc3bff64bdb62f0, 0x3ffa510fc8a12923,
    0x3fd40368d4dfd970, 0xbfc3795cdfec1ae0,
    0xbffe7108edcab12b, 0xbfca912df09b4800,
    0xc0057cb01d728d01, 0xbfe44c364cfab8e6,
    0xc0000a534a180190, 0x3ff033ddd6289512,
    0xbfd4851bdf2ec2cc, 0xbff88fd56c029602,
    0x3fe71c12a56822cb, 0x3ff45a6169c45d5e,
    0xbff63bc625d56448, 0x3ff0c5319c16f3c1,
    0xc00e4b194e5008f9, 0xc004e247b6473136,
    0xbff01c598c7faae2, 0xbff29fbc40c7521c,
    0xbfde4a10adb0bb74, 0x3fef2065f7efd61b,
    0x3ffdf25ed88f7ea5, 0x3ffb165402eb70ec,
    0xc003461de256e343, 0xbfcdf031078e1da8,
    0xc004f15568c73a2a, 0x3fee51fb363c7aff,
    0x3fc89f0bf231f1a8, 0xbff289403170e94e,
    0x3fec613988b5e029, 0xbffaff23c0d6c288,
    0xbfe9a102c9001bf2, 0xc00401d7c6f2ab37,
    0xbff3f5cd6c33a784, 0x3ff4f1bc7b399360,
    0xbfc70dc336a75462, 0xbfe8721a9745bf26,
    0xbfe5567d02d12794, 0xc00b94dbdb6a8302,
    0x3fd1ce394bf5845c, 0xbfeb28f40930ac79,
    0xc001c081644b467a, 0xbff0bded14d0ba14,
    0xc00245070f87526b, 0x3ffee30fbb8d45a9,
    0x4009e867dc593320, 0x3fc27892d70137c0,
    0xc0001d38534a32b6, 0x3ff1a53669dd47ba,
    0xc004495aa3e38364, 0x3fcd812a15d35c68,
    0xbfeb1d3b2ace8836, 0x3ffcacf0c2045b3a,
    0x3ff61cf1a60228d2, 0x400e8ac97c1b9d87,
    0x3ff0b8494dda2544, 0x3fd87d6d817b9db8,
    0xc00a51198dae5a7a, 0xbfb83e8b50345214,
    0xbff2f93bd90782f9, 0xbff516b50b48c390,
    0x3fe936b9d8ca33f6, 0xc0012a6e064adcd1,
    0xc004afc05faec744, 0x3fce26efaae863fe,
    0x3ff9380bfcd71964, 0x3ff6c30f1b84090e,
    0x3feb4003f67edd8a, 0xbff0087085aa1172,
    0x3ffb0ab2f9197d38, 0x3f94c17af06bfbc0,
    0xbfcd6ea2396871ac, 0xbfe6cd5bf5d91f29,
    0x3ff386e8eef53ad8, 0xbfb3d4c543f70950,
    0x40037bab81fce327, 0xbfa442ac08005988,
    0xbffb2a246eb0345f, 0x3fefa5f417ffb6d9,
    0x3fe07266263c0578, 0xbffdb5469e21d0e2,
    0xc00133f971cc443b, 0xbfe29278029f87e1,
    0xbff9467b12e9f774, 0x3ff6beb4c5ffda14,
    0x3ff23db602edeeae, 0xbfc7de24430462a4,
    0xbfccdddb7f111320, 0x3fd2cb426f1f9bd8,
    0x3fb4a9e1723fe9f4, 0x3fe0759ccec36073,
    0xbfe703c159c8aec0, 0x3ff0a20624d18af7,
    0x3febcd43d77e37e3, 0x3fe5955f49312257,
    0xbff03b4805860b04, 0x3f79555f8c563880,
    0x3fc0db329ebf652a, 0xbff4e7a17653b24f,
    0x4004ba150c515f94, 0xbff47acf9766b555,
    0xbfcc840e835fc966, 0xbfd656a844f6f16e,
    0x3fd936823feb830c, 0x3fea5a9ead5640e4,
    0xbfe3563d8819c575, 0x400400d28df6aca2,
    0x3fbffdf985bd79d4, 0xbfd8a2457883a55b,
    0x3ff6ad40188280c6, 0x3ff0ce28ff1004e9,
    0xbfe1591f88eee6c8, 0xbfe1f5368db5abae,
    0x3fce0d28a2313658, 0x3ff90944a5d50e68,
    0x3fd7c4c60583e4ad, 0x3ff3864fffc7f032,
    0x4003393e1147695f, 0xbfdf4b3a175ef3b0,
    0xbf8f60445994b280, 0x3ff800dc2c1c0fb4,
    0x3fc485345f071e00, 0xbff3240067240cf4,
    0xbffd1f4a6753c876, 0x3faa942f396eeb60,
    0x40104d4ad8774026, 0xbffe1fef24e8198e,
    0x3fcd79d5fbf2f1e0, 0x3fe2b118c3bf6260,
    0x3fe15ddc0f1cdd00, 0xbfd4352fa1b340b8,
    0xbffb7c6cebbf8619, 0x4000e97288291f16,
    0xc0047e419f0a2424, 0x3fe997d2a93d26fa,
    0x3ff463fa5e323ab8, 0x3fe9a01f0aa8cff0,
    0xbfe7c056b67471f8, 0xbfffecefe14bb759,
    0xc00129cc4111906c, 0x3fde4b35c84ac0d2,
    0xbfd2b973346c1110, 0x3ffe9213f73f861c,
    0x3ff3f4416d18446f, 0xbfe00d53e22e3a9a,
    0xbf846d3194905980, 0x3fe2f390fa98c8d0,
    0xc006ad1d01e7223b, 0xbffa4be46d0af6f3,
    0xbfb95d96496c5fd0, 0xbff10e053ff64237,
    0x3fed9e0c3c4c8a9a, 0xbffcbba670d7ebcb,
    0xbffdbdecabf7a535, 0x3fcb2a4e69036dd6,
    0x3ffd9aa4ffafc0ea, 0xbffd8121246479a0,
    0xbffbe4b82c536f8d, 0x3fddf37dfd98c8b3,
    0xbfe48fdca90cbcfe, 0xbffc1b7d58a5c566,
    0x3fe3bea5bcff86ee, 0x4010a472dbb92297,
    0x40042f8a4da3bb0c, 0xbff68bda0aaa9d28,
    0xbff243d4da38e2d9, 0x3fd01c8d5f8f88ca,
    0xbff1e14dfe9fbcb2, 0x3fef513443c10e73,
    0x3fe838735c6fbe3a, 0xbffcf1486c6aed40,
    0x40074f7b75c7bfb8, 0xbfe5028a7931477d,
    0xbfecc890111a813c, 0xc000cb914ebc5068,
    0xbff8e109c24d23b0, 0x3fe20c70bb2c27cf,
    0x3ff97b2dab0417d1, 0x3ff15b7e6dfd18ab,
    0x3ff19dd78fe14ba9, 0xc000e77ebdaaba68,
    0x4000acc75125dfb8, 0xc00a0946ea11a4d9,
    0xbfa91e50dd52134c, 0xbfc2d673d0f9a738,
    0xc00f7db9db26c24e, 0x3ff1443b2bb146b8,
    0x3ffbb22d036d6490, 0x3f8223465f676040,
    0x3fedf6bdd4010cdc, 0x3fce38697fc2a460,
    0xbff253f5b1e7c8aa, 0xbfec09d8f5c652a2,
    0x3feed18c4ab3c39a, 0xbfc0858e06bd0314,
    0x3fd94da0d40764a3, 0x400ee894d3ab53bb,
    0x3ff597e88d972139, 0xbfe1ae9c8ca19e43,
    0xbfe1df3a8bfc5404, 0xbfc0422b7dc147e0,
    0xbfce8984d023c3b4, 0x3fe533c599f5af21,
    0x3fc3f9e3fa1b9be0, 0x3ff432fcb5dff038,
    0xc0051ccd5fc9db47, 0x4002501eb3016954,
    0x3ffd9941789ae998, 0xbfefd79f29facfac,
    0x40084c40c8f6b451, 0x3ffb3b78bc6646f5,
    0xbfe360a4c340e779, 0x3ff38f053d64bcad,
    0x3ffb2ac066c23ee3, 0xc001a973d60d1e6c,
    0xc002ca5c8f72c5e1, 0x3ffe63642ba866c8,
    0xbfe18e081cf810c0, 0x3ff80f2861b8bd36,
    0x3fe8b4c1c3894f4f, 0x3feaeccee41e8ba6,
    0x3ffd3fada454a134, 0x3fc5187ab3a721b0,
    0x3fec3d011facd0c8, 0x3fe27fceeb62cf82,
    0x3fb7206362ba0758, 0x3fe118b4bbf55168,
    0x3ff0ea46f1da6f19, 0xbff47b2bf9ae6c52,
    0xbfdf4f493e22ef38, 0x3ff3f69a47e2fb47,
    0x3ff9dc27e4266b52, 0x3fcb4b199b117146,
    0x3fd89081d55f62fc, 0xbff2dd62a22a4eb6,
    0x3f8577f11abaa480, 0x3fee591e9dc10487,
    0x3fdca5759f4fa37c, 0xbfe2f23e0b7ccdf7,
    0x3ffeed27851cd343, 0x3fe0fa9a8152846e,
    0xbffde1a26a1add7c, 0x3fe47bac3a5d285f,
    0x3ffe8948605b3369, 0x3feac4a0d0d7c597,
    0x4003b6aa097c96e3, 0xc010b6d5e65c2878,
    0x3ff17906b5cba5bb, 0x3ff93186f852e752,
    0x3fe986a9138bfa14, 0x3ffd0a0e5bf0ed04,
    0x3ffc2b2c7b92db8a, 0xc00151a578c0e828,
    0xbfe838e529e37354, 0x3fe6164120def89a,
    0x40007f6831d81ab8, 0xc00271f35facb3c7,
    0x3fb4f258920201d8, 0xbff8dfd9646f55df,
    0x4006f3d8b3627e49, 0xbfed97e13053dcf4,
    0x3f88f01af0989980, 0x3fca85ca9c32898e,
    0x3fe97c0e8661ce62, 0x3fdde3d7aa92ef5a,
    0xbffc600ec6844a21, 0x3fe2a5f99021ca28,
    0xbfd2c870de880ddb, 0xbff7826a23cb0d3a,
    0x3fc865ede0e9c1e4, 0x4000fde17c24d0d6,
    0xbfcb915790f1b638, 0xbfb0ed2df566d378,
    0xbfe073582b16b67a, 0xbff959844fb176ab,
    0xbfe0cbabeb6c4472, 0x3ff7b1f615afa2cf,
    0xbff66b95f9cbf558, 0xc00c996483216159,
    0xbfe35fe1ff2ce451, 0xbff7769b8269da88,
    0xbff12f2589adeb20, 0xbfaf5c1e22e8e7f0,
    0xc003ad51007a736b, 0xbfdc53f1afc2dcf0,
    0xbfd62c756c442c20, 0xc0027146c6295a3d,
    0xc005dbfe4783c5b1, 0xbff6b9961274a788,
    0xbfd9ab2aa494c7ab, 0xbfd7985ae4bc9008,
    0x3fd96b5618c90ede, 0xc003942694973510,
    0xbff7e71e6c24f0b8, 0x3f9d25db2bc8af40,
    0xbffe8a6e7b1d1518, 0xbfbc61c5167118f8,
    0xbfe1e74d77333595, 0x40087b3a19c0165a,
    0x4005619dad723b56, 0x3ff30a04d646eb12,
    0x3fe620f7d0fc13f9, 0x400b23b69a42408e,
    0xbfa661978edd76c0, 0x3fec7790abf20782,
    0xbfdd98bac67b6b74, 0xbff645930f0bbeb7,
    0x3fdaf7aee5862a56, 0x40012e68151a5f60,
    0x4001dffe1c59d122, 0xbff2305251c9ecb6,
    0x3ffe0b5daab47d73, 0xbfe6d36a603fd801,
    0xbfffce465c8de65c, 0xc086621cae230b0c,
    0xc0037795f9b41d28, 0x3fd0d046a8a8d7d2,
    0x3ff28d411e6d45c2, 0xbfe11d2ed6a5cc2e,
    0x3febdb18039a3ced, 0x4006be1c9e04e8ea,
    0xc0042bf02d4d3905, 0xbfe0c9e2258e3697,
    0xc00857776ae9ea0b, 0xbfe04d7f1ac64b83,
    0xbff59269fe687cb6, 0x3ff42a588150bf92,
    0xbff4d81b3e3859af, 0xbfc5d91ed4e1dbf8,
    0xbf8e85b15555e000, 0x3ffe472f06ae94ce,
    0x3ff5a9c01a3c7aab, 0xc00db1d7ba1a5793,
    0x40069ab52a27ec14, 0x3ff21c8cc14acac1,
    0x3ffbca576de963e0, 0x3fdb5620013aa179,
    0x3fe7b5472a6b229e, 0x3fcb872aee0d88c0,
    0x3ffb047d29fcddb7, 0x3fd534d11505cdbe,
    0xbfdff2fdc04d03f6, 0xbfdf6e3fa65813aa,
    0xbfeacb3fcf8aa0fc, 0xbff2a5275c3d18c6,
    0xc0082bfc51d24796, 0x40076144e7e59ab4,
    0xc003e2ac85392f15, 0x3ff6acd585349947,
    0xc00a7f4f09771832, 0xc0004a90943d9a8b,
    0x3fe467e1fd28862d, 0xbf9f7f3628d6a500,
    0x3fec04a2059f41c2, 0x3fe357b3912b2542,
    0x3fe990c8497caaab, 0x3fd03bff2242f14c,
    0x3ff7b75e6c044dd2, 0x3ff1fe1147ca628a,
    0x3fef0d14e994e6f1, 0x4003e2439e70150a,
    0xbfe17adbf18a2260, 0xbfe761ad9f75fd9a,
    0xc004942284f6ded8, 0xbfb3006ffd27c7bc,
    0x3fde4300811466f3, 0xbff9a33f62b7faa8,
    0x400337acb3aec66e, 0x3ffffc968070014c,
    0x3ffd389dac704687, 0xc011793afe53305a,
    0x4013b6fc15c4479e, 0x3fee286cbf9c225c,
    0xbff1ee541f8767b6, 0x3ffb3011ee3b2cba,
    0x3fb3345fef43cff0, 0xbfeb61388bcd3ece,
    0x400bf10a2ba0ad0c, 0xc00d17481c7e8afe,
    0x40031a84b5f992c4, 0x3ff3a3e46a63233a,
    0xbff97c936aefde8a, 0xbfb718020fde5900,
    0xbfd33a2f95721c2c, 0x3ff943a78b7a8115,
    0xbffa6ab45a1bac2a, 0xc0045183301f2de1,
    0x4010c9e7b229f01a, 0xbff472569ba88658,
    0x3fc1ebe080c0c7bc, 0x3feeac53e5d6750e,
    0x3fc6582c70baab88, 0x4003641c4040b8f1,
    0x3fe921aa030acdca, 0xc006f3c5080f6730,
    0xc009e206bfb8aa7a, 0x4003dd7aca3a9930,
    0x3ff07fa3e0039d16, 0xbfe061e84bd179c2,
    0x400557fc3183a12d, 0x3fe62c46c611ff38,
    0x3ff8cd0d5d165d7a, 0x3ffd463edfd09021,
    0xbfe9351abd5427e5, 0x3fd3b58e16287266,
    0xc00e125934a5988a, 0x3ff52ce03c3dcdac,
    0xbfe4704bcf0c5a38, 0xbfb8d54081c94498,
    0x3fd9b7e3e25d8ed8, 0xbfb9a45ce4dbbe04,
    0xbffa9ff8701e2d94, 0xbfee78d0e6c3d8f9,
    0xbfa14288a51a5538, 0xc0004ff0b604e358,
    0xbff8dca0151e4574, 0xbff3520648731adc,
    0xbff362f8fc302a68, 0x3ff2eb74e95ccbb2,
    0xbfe36ce9d3468b04, 0xbfe34144fbdeb834,
    0xbff5b3e98cb29aa9, 0xbfe957fced062f38,
    0x4006b02ee2babb22, 0x3ff5da182ec26ce6,
    0xbfe1e4b1e5e12635, 0xbfb02cc96a702e20,
    0x3fed4fa5211c9c9e, 0x3fb38473a0d81bc0,
    0xbfee7df494405d0f, 0x40021df316b881d5,
    0xbf99d2d7f2d00ae0, 0x3fcbb5bb080de0f4,
    0x3fe93f7e8d7f5798, 0x3fffd5cb45bc95de,
    0xbff5ca4a71bf60fe, 0xbfd60f646633a35e,
    0x3fd3b0ab7cf2740b, 0x3fc03854840b202e,
    0x3ffc60d1b968ae28, 0xbff189bed5f8f87b,
    0x400102cbb5454045, 0x3ffec057e6945f46,
    0xbfd05c8569ff6666, 0xbffa89d7b0a2b4f2,
    0x4005f0a610869852, 0xbff5b0a44c842290,
    0xbffac4b8faf3700d, 0xbff3fcd2b4920236,
    0xc009b8ab885cad00, 0x3fcfbd5c96986f16,
    0x3ff2aea1c007e934, 0xbfeeedcb36e9839b,
    0x4005be48b8122140, 0xbfebcd4b733025d5,
    0xbff7a796b0b511cf, 0xbfe123473b423d12,
    0x3ff622bf9db44523, 0xbfd0c646647d5f44,
    0xbfc7e0ae4f92a4f8, 0xbffd75654ec75842,
    0x3ff17c1061215fdc, 0xbfe367be0de2a419,
    0x3fab4cbd947e8178, 0xc00f7a6aacec0304,
    0xbfec334e62ce2437, 0xc00975d84cdab7d3,
    0xbffa2e3e0df79728, 0xbfe5acf0debf8d35,
    0x3fe4b4e244c8f60a, 0xbff08474e21864c4,
    0xbff4e162fc24f757, 0x3fca125d759c7584,
    0x3f9ddb88acfc38c0, 0xbffe1b384eb72ef4,
    0x400730c9a6a381b2, 0xbff6543d09063291,
    0x3fe0cc5cb18a029c, 0xbfec4fca35449481,
    0x3fe118cf8d4490b0, 0xc001c6425cb669c0,
    0x3ffbf10c3073f430, 0x400a28e6259f5b3c,
    0x40031508fe4987d4, 0xbfd0983845e149e2,
    0x4006a043663d210c, 0xbffa1bcef2bd4255,
    0xbff522281326ed86, 0x3fe8713ee900103c,
    0x3fb65bd145d26c3c, 0xc000454d08f767f2,
    0xbff3e8cd1fbf7a80, 0xbff1d8e64eedfb11,
    0x3ffbd9c9b65596fc, 0xbfed16614af1c77e,
    0xbfe851a3b5f9ad68, 0xc01326d27b15cd6e,
    0xbff12402b824169e, 0xbf4c811460152000,
    0xbffda69e66fa0fd8, 0x3ff3e0de98e4cad0,
    0x3fdd97fa4d78dbfa, 0x3fa9ffe459539050,
    0x3fe7f18e9a3dfa5d, 0x3fdfed6f46b8e680,
    0xbfe9af21fcdbfbf6, 0xbff010a0b86c2220,
    0x3fffb9a7810fef42, 0xbfeb8710d042c2b2,
    0xc00de447908fb19d, 0x3f8424635955f620,
    0xbff0f20cfa89a35f, 0x3fe800bf37564d25,
    0xc0027db2a9fdb81a, 0x3feab5dd036143c6,
    0x400b73762cccf972, 0xbffcfc9489605863,
    0x3fc8843c1714e2a8, 0xbfe9496ab4198aca,
    0xbff1691c8063a8ed, 0xbff57c612011c132,
    0x3fce0f76b39d8727, 0xbfd15e797ece57c0,
    0xbfff71b28db77262, 0x3ffcea0eee2f6899,
    0x400131cc1804a6b2, 0x3fdb602382619cc1,
    0xbff5511fb65726fa, 0x3ff9322d0ad673e9,
    0xbffd17f3606fa636, 0x4000e30556c47160,
    0x3ff7921b99c8e2dc, 0xc0011bd586e5dc8e,
    0x3fb07d3ee57fe430, 0x3f8bde2c253b8600,
    0xbfb480aade3a5a90, 0x3fe5b51baeed96fe,
    0xbff822a69c7130e2, 0xbff3d4bd0540d798,
    0xbff93067daae886e, 0x3ffe4137567f9e78,
    0xbff9e7bcd722239a, 0x400b78303725e7fd,
    0xc0066b81d0a7ebd7, 0x3fed1e60b4f7bfac,
    0x3fc26aa661e18b18, 0x3fecd60bfa274cd7,
    0xbfdf9a12815ae898, 0xbfb854924840e514,
    0xbff4805a4fade0cc, 0xc008f9873458b173,
    0x3ff1f78ef78132ce, 0x40025ea046d424da,
    0x3ff5ee906e8f0698, 0xbfe6b44f7a016241,
    0x3fff77ce3352b431, 0x3ff78ee54a56f4be,
    0xbff7f6176133751f, 0x3fed6271caee426a,
    0x3fe19cdea924f260, 0x3ffa8b0e2570519f,
    0x3ff6ec2705709d9c, 0xbffa4e7adfa2049b,
    0x3ff01025bb5eade6, 0xbfe468ed593b05e8,
    0xbff9e698fcaef568, 0xbff8d83891065d3a,
    0x3fd2cdc43eef2072, 0x3ff6c84bcd9e2b1a,
    0xbffca29f3b7b51ab, 0x3fcff5eadb03d6f8,
    0xbfe382429b5fffb7, 0x3fe57f52204e0d84,
    0xbfcaec617e956fec, 0xc00b7f5e7dbb66ab,
    0xbfd519c76ac6d1b7, 0xbff0ae1ac76595a9,
    0x3fdc8a9cb6edcf48, 0xbff006e6a4af786f,
    0xc009e482052bfff7, 0x4000b061f4f95de4,
    0x4001af84e3344ab5, 0x400a96b0363e700e,
    0x3ff09f36e51128eb, 0xbff6ac338a4c7c8d,
    0x400fb5b25aae477a, 0xbfd77a3a0ce26b14,
    0x3ff6f4b55e891160, 0xbff4d0c0cebf047d,
    0xbfa0ca21ed51a8f0, 0x3ff530afa24f6d94,
    0x3ff82e7898247d9a, 0x3fd28da9db480ffa,
    0x3fe7d786c108edd8, 0x40020b6b45f759a4,
    0x3ff955e30928f4f0, 0xbfeb36265fc57d42,
    0xbff6b4063fb21846, 0x3fd2f4a32764c7a8,
    0x3fca541da11c9409, 0xbfe1f3ee3e6591e4,
    0xbff20fdcb69aa59d, 0xc011234ec3a7af1f,
    0xbff7ca2157a8a7c3, 0x3fe38daf6dbb0f82,
    0xbfe07a3952a9a779, 0x3fff05502ec0d672,
    0x3ff69fa2017f02d8, 0xbfc210fcf7c89ecc,
    0x4002d2746595384e, 0xbfc843250895cd64,
    0x3fd19b367546ff22, 0x3ff4029fe777122d,
    0x3fe3b7b37b493d76, 0x3fbfe34e0d24154e,
    0x3fff33e955cedcf2, 0x3fd046b5a2570710,
    0xbf855bc3d02a7d00, 0x3fc731f773b6ba10,
    0x3f90b8ab37908f20, 0x3ffa4b622a818ecd,
    0x3ffa07b8e7ddb6f0, 0xc005d7e06f60ffe0,
    0x3fe56462d3ef1926, 0xc0144cf2d5f65334,
    0x3ff1d858b38b2112, 0x3fe80c3f7ad48a19,
    0x3ff4d5c3b594ca22, 0xc00089cf559bd64e,
    0x3fe400b0a22ac75b, 0xbffbc59446ce08a6,
    0xc006cf3510a23ae7, 0xbff764c1912d4c97,
    0xbffc177dbef329cb, 0x3fe9016d48be7c0e,
    0x3fe557e0686cae0c, 0x3ff284fb1500b4ee,
    0xbfd727d9e7c6f3da, 0xbfeb95c4c3cf5ff0,
    0x400904b59774bbb6, 0x3fca70d30e0861e0,
    0xbffd9ac24aed8090, 0x3ffeec5a83d44f84,
    0xbfe2b0fb1346d26d, 0x3fc911181bdede70,
    0xbfc90d29b0ea06a0, 0x3ffcea1f5083a02b,
    0x40039cb2e688ed98, 0xbfbe8ed06935d0c4,
    0x3fdd3d0aeb4a27d4, 0x3fb30cb0d4009218,
    0x3ff5e084c83be079, 0x3fd288fb3b21b414,
    0xbff0cf7662b74d6a, 0x40040d44fadf01ac,
    0x3fb0db2a567dae40, 0xc00572417b907b3d,
    0xbff391cb65e3a320, 0x3ffc66ee080d8083,
    0xbff64d3daf149b10, 0xbfe467a91ef2d0c5,
    0xbff4e60445c2a796, 0xbffa3cb99c163312,
    0xbfd7e12c6c38e65c, 0x3facbf5d2b1023b0,
    0x4000f0493b02e0be, 0x3fb917930bbb0248,
    0xbfddd6a23f855530, 0xc0056925c09f7690,
    0xc0020401cc7d1d78, 0x3fe719a988750516,
    0xbfeeeb95e0bb177d, 0x3ff2f5068e19c6e7,
    0xbfe421375c045628, 0xbfe5e38b30866f67,
    0x3ff9473127ef152a, 0x3fe1972501c88693,
    0xbfd3b52f1a3c7294, 0x3ffb360c421d3c56,
    0x3ff56d653e3810d6, 0x3ff9deaf1d2f98a0,
    0xc00148c0bc82b3de, 0xbfdba6357c5c22ee,
    0xbff8b72f27a36a3c, 0x3fd6f2ae4f25131a,
    0x400cc07edb6db22a, 0x3fc3604ccf8c202a,
    0xbfe1fba4bc78e3c8, 0x3ff69b96e7ebce76,
    0xbffc2aef6341228c, 0x3fae912ae2dceee0,
    0x3fe356a95f5f6436, 0x3ff1d89c086ab040,
    0x3ff39caabe11f41f, 0x3fee07dff0af6036,
    0xbff874f5311e1894, 0xc00817b5a2642c44,
    0xbff93534632d3304, 0xbfd857b12ed21ede,
    0x3ff681fe383054a6, 0xbffbc1fd7809dffc,
    0x4016e05b76882a48, 0xbfe5916719f59e64,
    0x3fcbfcc9f52ad500, 0x3fd5bb29cdcce126,
    0x3fe26e7e8073a2fa, 0xbff36c3fc06bd450,
    0xbfefb134826ad56c, 0x3fe41c44930f8f6f,
    0xbffc6e05ab11c8d1, 0x4003a543dfad928c,
    0x3ffc005b53314878, 0xbfd4409994e8bc74,
    0x3fd590c9b08e28c2, 0x3ff6ddedc49df1a1,
    0x3ff1c66c8e30ea4a, 0x3ff1f158ef2f1711,
    0x3fa74779cb080280, 0x3fe0f5610babef88,
    0x400ee355707a6d80, 0x3fff0f93fd3db7b4,
    0x3fec699ac69bd6df, 0x3fff23298da49593,
    0x3fc458dfbdde99d8, 0x3fec5ec65307fbd7,
    0x400f43ec91accde5, 0xbfaa37a1b7800db0,
    0xc00685d9f76af322, 0xbff417bf1b9631f7,
    0x400a638c1b461dde, 0x3fe49dbd345a451b,
    0x40009b18a9b32fcb, 0xbffd8e6dc32c98c4,
    0xc002f9b80e3aec0d, 0xc01323c83e589ed6,
    0xbfee4aba1764a50e, 0xc003dae423e715fa,
    0xbff5a64e2ac6e604, 0xc00f51f01a7746c6,
    0x3fe06dbb7d27a35f, 0x3fc52193502955da,
    0xbfed77c2bcfad2e6, 0xbfdbe050f9e0ca63,
    0x3fead0d65a4f5d3c, 0x3fff0bc0e62195b6,
    0xbfd4439ffccc0274, 0xbfde1256237f7322,
    0x3ff213c3924a0692, 0x3ff2ab72846d0a97,
    0xbfdaa09e917d7e18, 0x3ff21081caed5b63,
    0x4000ce41a764a65a, 0xc001b0e43319a676,
    0x3ff90654293300c3, 0x3fe0983acc0e1248,
    0x3ff4b4079583ed4b, 0x3fe720e332f43d89,
    0xbff04b77c353ac99, 0x3ff0f03f087a4179,
    0xc00b4b5053fa9861, 0xc0010d5015b78da7,
    0xbfff1b70a78689cb, 0x3fbfdc1ce9a2fe6c,
    0xbff13b166a74c7f4, 0x3fd31c0248164e6e,
    0xbfe50f212952adb1, 0x3fe4ef9940529cbe,
    0x3fe644081f9c2cdd, 0x40028cd881d3e409,
    0xbfa19ad11524c000, 0x4002818c0348182a,
    0xc001669348aba292, 0xbfd70b98c1ae366b,
    0x3fc0ca38807cbcf0, 0xbff49b36013977d3,
    0xbff60a9cae40c6f7, 0xc0086629975a90fa,
    0x3ff9f752933f1c31, 0x3fed2e72287ebe0e,
    0x3f9da21ce57b2a40, 0x3febb877969b1722,
    0x3fdfbb214057f800, 0xbff8287094b1e3ec,
    0xbfee6f5b20c6eff6, 0x3ffb99be46fd9b9d,
    0xbfe22205ae106978, 0xbff3fa13daa6f53a,
    0x3ff06c89c6cb11ae, 0x3fe4c2c2ab0f2c88,
    0x3ff395178eeba088, 0x3f95c71b41483c00,
    0x400716dbbaea0d7a, 0xc006bfabb229b9d2,
    0xbfd62796039ad356, 0x3fefc04c2f9d5f49,
    0x3f9295fd551cd5d8, 0x3ff7158f66ba897c,
    0xc00015eedff1a4d8, 0x3fba7dbc7ef84af4,
    0xbff5c19814d499e4, 0xbfd74f1f355cd9b3,
    0x3fd7ded66915af18, 0xbfe4398da7f88d7c,
    0x3fde63d07f2f0bc4, 0xbfe4c2a61b35d876,
    0x400a739255b54481, 0xc00b4a92e58f94e7,
    0x40074955c5a2d907, 0x3fe42b5989c7621d,
    0xbfed6e4671a2f13e, 0xbfb86dc107ca3188,
    0xbff32726ae7007f2, 0x400592b352746e91,
    0x3fe917488e83f092, 0x401848e0eb1e0ab4,
    0xc007cb369a7c89f4, 0x3fe7a4d6d61547aa,
    0x40080cc39df58e2e, 0xbff4a3bcd736bea9,
    0xbff7e07f1104e8ea, 0xbfd9cb34686e7042,
    0xbff1c8cdc462ce12, 0x3fff676e307bb5b7,
    0x3ff47ceecb9eb1c6, 0x3ff0f736a9122abb,
    0x3ffbba867d318c4d, 0xbfe141c581257d00,
    0x3fcdc579074c086c, 0xbff05e3663f8816a,
    0x3ff71413ee3d0a91, 0x3ffdee24ff153f1e,
    0xbff65c6dfedf8b14, 0xbfe06be8b14b8dcb,
    0xc000643aa263ba39, 0xbfe8887aac7e1fe4,
    0x40012fcb1ef5a93e, 0xc000d0b78e1c3dcf,
    0xbff06873b80dfa0e, 0x3fcad7c6feba0820,
    0x3ffebfb092aa7e2d, 0xc001975516f75c66,
    0x3fd8e48a97602fdc, 0x3ff58250826eed98,
    0x3fedd030831fa9e5, 0xbff20dd6469ba450,
    0x3fe8841c1eab89e4, 0x3fe9b73042827f84,
    0xc004e3c5032f3bf0, 0x3ffbdf8a8a201964,
    0xbff51f021e03530c, 0x400074c06860c9ba,
    0xbff413ba8a13d4b4, 0x3ff3d3e10b00d0f9,
    0x3ff457afede5f6c3, 0x3fe90b4249ec7668,
    0x3fc621261484ae2a, 0x3fe2ebf525a3f9f6,
    0xbff78799387eb0de, 0x3fdbc5a3e9239cf8,
    0x3ff2dba833cb998c, 0xbf7b6472bffc6d00,
    0xc0080a32baa5fe3e, 0x40081f99a5a15967,
    0xc002d1f5cb12bf24, 0xc00e53ab6ee66d2c,
    0xc0029ea33295ee28, 0xbfff209b3eba836c,
    0xbff0f959c3f430ba, 0xc00778a656117bce,
    0xbfee6401ffed48aa, 0x3fd6f88204902db6,
    0x3fad97eac98c29b0, 0x40075d585eb4cbea,
    0xc00274505992451e, 0xbff74d295ec34047,
    0xc00ced17a3158c81, 0x3ffc8c088cfcc798,
    0x3ff2f1a3bc48dced, 0xbff3b147c35fc330,
    0xbfe2388aa3df92ef, 0x3fda9f93df3941ac,
    0x400130d18119f55b, 0xbfe36645dbfea346,
    0xc0022085ef34d2a3, 0x3fe264ba76b48537,
    0xbfe7be60afd25ad6, 0x3fe2fec7c036f094,
    0xc001838faaa602bc, 0x3fe0bf8f72e80fa0,
    0x40120ecbe5987581, 0xbfe8da2f128ef03a,
    0xbfc6110443722f90, 0xbfff82175ddba2de,
    0xbfd227f5443fb33b, 0xbfce626ba69d288c,
    0xbfe2f352f1f016ff, 0xbff16e288d6db0bb,
    0xbff19d4bdf0505e7, 0xbfe39a42dd1bc658,
    0xc0066506bcb5cec6, 0x3ff0c116036ed750,
    0xbfd3e97982837437, 0x400030bdd4144e98,
    0x3ff58d8c2228a8d2, 0x3ff91e75aba3d504,
    0xc00132534fe5c918, 0xbffc29235efc08e5,
    0x40041e3b6aaf5783, 0xbfe93b8f75110df0,
    0x3ff282bb85865896, 0xbfde6140e8c15e24,
    0x3ff1d10512660147, 0xbfe13a8cd43c4384,
    0x3fa2eed1ecf40c80, 0xbfc306a105985c60,
    0xbfd602a92d9b7c08, 0xbff93ab7a63e3809,
    0xbff45df97ca853f6, 0x400343ec4129c5d5,
    0xbfdbe26cf91ee4e8, 0xbfe77daa8d3af5b3,
    0xbfc6d3baccc251c8, 0xbff279ae06b9bd59,
    0x3fac0bd7954c8900, 0x40046e16a1820cba,
    0x3fe764f738c53bae, 0x3fef6e28714b8ccd,
    0xbff6e31646128c62, 0xc002e796fc792c6b,
    0x3fed2a6b1d0f4b24, 0x3fe63726b7d195f1,
    0xbff2eab1e787e2c3, 0xc005191d3a464e84,
    0xbffc4a2f6268350d, 0x40005f6bf094e020,
    0xbfed4dbf18936ada, 0x3ffc9eb3ff071841,
    0x3ff003233d0dcd44, 0xbfe976ce3968e2be,
    0x3fe6eee4a7e7d67a, 0xbffa59870075a818,
    0xbff09847036b3085, 0x3fea14d834996146,
    0xbff778bcf01abd7a, 0xbff5b447e7d619f1,
    0xbff292a86c1b400a, 0xc00864bd8d9782d2,
    0x4009900008b28964, 0x3ff89d9e5b410046,
    0xbfd817bb6a9197b0, 0x400560db3473b222,
    0xbfea4e3f7a790aaf, 0xc0027be296b5caf5,
    0x4001afca18092fb2, 0x3ffa7fb1ad2e1f22,
    0x3feaca5c34d0f110, 0xc00101097841cad6,
    0x3fdf4e6d57c697fa, 0xbffb23b5f7dd20d3,
    0xbf91fe7266714350, 0xbfeaa7bfa0808393,
    0x3ff54bda0258fccd, 0x3fd55dc0d5573cb1,
    0xbfe7e38503b5b66a, 0xbff71e3abef49e32,
    0xbfd65065a7d038e4, 0xbfe45cad42ad0edb,
    0xbffddd67142cd490, 0xbff6446d3b7481fe,
    0xbfcb1451e7c301e4, 0xc0010501525e1e07,
    0xc0011615e1839965, 0xbfec650d02aebf7f,
    0xc006dd0d158320c8, 0x3ffbc76a788ff87b,
    0xbfd90625f1fa601e, 0x3fd6c2f13f7696a4,
    0xc0012394436dc7b9, 0xbfc20abf1d5fd6b0,
    0xbfd177dfff040fae, 0x3fb2367cc8d7d960,
    0xbfd72d2d49bb18f2, 0xbfee2dfa8f6943c3,
    0xc00168017bc3b067, 0xbff3508306d2cd6b,
    0x3fefd310fac86f07, 0x3ff78d44c86bffd6,
    0xbfe0e6bb8659c27e, 0xbfe3ce34f6d969aa,
    0x3fd768711b1b1eae, 0x3ffd452a165f2aa1,
    0xbfffb2e04509dfb4, 0x3ffcedd5b696fa93,
    0x400645dedff4ca08, 0xbf8db6c832064280,
    0xbff37baaba0e2166, 0xbff42b97f40b0980,
    0xbfe7d5a11310e4d5, 0x4005a9a00ebe60f8,
    0xc00acff017db9a8b, 0xbff44758b85cae4e,
    0x3fe53c0928f9b1e4, 0xbff3612f9955847a,
    0xc001c60612e86065, 0xbfef11bb43dae11c,
    0x3fea6e82530e652b, 0x3feb0e769e0c1756,
    0xc00489ea5031e3c7, 0xbff6807502d83255,
    0x400340d7795f671a, 0x3fe18e484d697d1b,
    0x3fdcaf55ab015aa0, 0xbffef8ba165dc75b,
    0x3fb4b8265c4257b4, 0x3fe6e5dc02739411,
    0x3fc1172c335fe200, 0xbfcadce0c684ee20,
    0x40018f03bee2fbb7, 0xbfe029309414949a,
    0xc0090cfca0766502, 0x3fe6528428520a7c,
    0xbfe29e7806506dd3, 0x400284f1b84788ce,
    0x3fb416123098c7d8, 0x3fe6c51c6b6e81f3,
    0x3ff624b4a654168d, 0x3ff7e37412568a94,
    0x3ff7e5312385a364, 0xbff5da51ad3b6455,
    0x3fc49cf2c080cb68, 0xbfeaa8df341af3f2,
    0xbffb4a2456d8fd25, 0x40023a9c19d8d168,
    0xc00558d477403c2a, 0x400280aa7f8d435f,
    0x3fedb78b3f7d97de, 0xbfe4437dbf88b8bc,
    0xbff350c0481ed79b, 0xbfdb9657f972ecae,
    0xbfe81ede88103ffc, 0xbfa2697ae6f53330,
    0xbfe3f00dd20341ea, 0xbfe2bd271373b54e,
    0xbfeb7c1e45d51b06, 0x3fdcab54a48d7b6a,
    0xbff3de0201e7ec5a, 0x3fd19068b8931fe6,
    0x3ff3bb6f9d8e4a12, 0x3ffb24da8f3efa3a,
    0x3fdb4c309c22fdf8, 0x3fef5a4e4c2ac2b0,
    0x3fdbc9038ff75f3c, 0xc008e09bd90cc3ae,
    0x3fc66450fe61aec8, 0xbff06fe6762d63ca,
    0xbfe2844e401db330, 0x3f8f7894205b2300,
    0x3ff085decdc95dd0, 0x3fe903fef786cede,
    0x3ff65364a5714ede, 0x3ff7fba8022e4cfb,
    0xbfe82841bafbba68, 0x3fe199c73d233d85,
    0x3fe82efa47c8e63e, 0xbfe97eff5c471e35,
    0x3ff00365fda41240, 0xbfe77d8873919052,
    0x3fe8f70fdc9237bf, 0x3ff6ab6b2d155aee,
    0x4004e27ea7603980, 0x3fe4615a4f021198,
    0x3ff00bad0c7895a2, 0x3fd8bade9778cade,
    0x3fe1434125f44f24, 0x3fdb2616eb88051c,
    0x3febc7d95ded924e, 0x3fdb3f5ba296d2ed,
    0x3fda0485a1c1d4b5, 0x400678aa84ec00ec,
    0xbfe992db85fd7934, 0x3fddd84a930029e4,
    0xbff22a8d9ada5adc, 0x3ff5992f27098c9c,
    0xbff22c3849416abc, 0xbfcaf1e7ebb311a4,
    0xbfe1b23a8f5ed262, 0x3ff09a3448cc5062,
    0x400c35ce985e9aa9, 0xbff8b06a53c7de32,
    0xbfef59c465543a3b, 0xc000831cce427932,
    0x4018fc992c24b60c, 0xbff0d831b088be3c,
    0x3fbf88377e83cd98, 0x3fe03a9f64da63e5,
    0x3fdd670b8453b0cc, 0x3ff989d28d1fe2e8,
    0x3fe327d7c0288370, 0xbfdfc6ade66add2c,
    0xbfdd094ec9ee3d72, 0x400a34fe501db972,
    0xbfcc8ae2a162cb54, 0xbff24f078c0f564f,
    0x3ffb5035a717a0ac, 0x3fd49fcda289377e,
    0x400457cf161b39e4, 0x400101739dd0375b,
    0xbfdf0661a28b2d4c, 0xc00072a8523028a5,
    0xbfe04dc88a0706fd, 0x40049b64b8b89f32,
    0x3ff62fd8717c653d, 0xbfefbc6027dd9c96,
    0xbff7506e3744d588, 0xbfdbc9f830b07d7a,
    0xbfe3aa1312d706f0, 0x3ff72fcf68585a9e,
    0x3ff23cafe65aec43, 0x3ff8b01ead8dd308,
    0xbfdebd85c13398f9, 0xbfd25ff35db8dab8,
    0xbff9d1390d2cb2b3, 0xbfe958f5ca82f3ce,
    0x3ff629303816406e, 0xbfdfdf9ac252cfa8,
    0x3ff1f4449b10e05a, 0xbff18af9bea39496,
    0x40029dc92d5894c2, 0x3fd6afb6572c60fc,
    0xbfe1be085a3cf7e0, 0x4004cda50694f190,
    0xbfe79ebfe2f9ecfd, 0xbfba82102cfb7828,
    0x3ffed2e19dc73271, 0x3ff2c0ad8e589526,
    0xc00b318186f4a83f, 0xbfd5abaf6bf730ac,
    0x3ff0396d23db3a06, 0xbff9ac20c576f6fe,
    0xbff8a34dd41125e1, 0x3fe36c634f53df67,
    0x3fe0d7538c56aa84, 0xbfb6296b22414cf0,
    0xbffb9743be70b050, 0xbff3a9f32f6f0b92,
    0xbfffe26f77c307ac, 0xbfeec9f65e633de2,
    0xbfc0d420e2044ef2, 0x4007a0bc40474a17,
    0xbffe261eec2ff144, 0xbff6d9717d54988c,
    0x3ff23921b8e0bb6d, 0xbfc115ca0f828b58,
    0xbfbbf8d2eca0cd6c, 0xc00424a3a9c4f1e8,
    0xbff3387e10dd6322, 0x400ec7d4c74ba0f4,
    0xbfd2f3c90f5c3b9c, 0xbfe4720fdfb91dfc,
    0xc0096f39f7abdf7e, 0x3fa63daf33dbc800,
    0x3febe6a2bd0e6c3a, 0x3fe20d59e330a3b9,
    0xbfe68a452bcb1132, 0xc0027f121aef25ca,
    0x3ff3c68b92f35536, 0x3fec073f2420f350,
    0xbff9e2edb55866b0, 0xbff4f4dbea7cd2cc,
    0x3fe50be6efa661da, 0x3fd46a180bb11464,
    0x3fef0a3e14144916, 0xbfcaf1efd6e016a8,
    0xbffdf16849c9c9ac, 0x3fe7af3ddf7d3066,
    0xc009870c704b1149, 0x3ffd1d9167b2d0b0,
    0x3fe3ca1aec9ef9c6, 0x3ffcfa77009a7dae,
    0xbfdc770da16937b1, 0xbfc6b0efdc45f30c,
    0x3ffd47769743519c, 0xbff8346379ca28a8,
    0x3ffd76ec340b1802, 0xbff7667bbb6e86da,
    0x3ff94de9bee5b8c3, 0x4006206aa6d90529,
    0x3fc44a6b003e619a, 0xbffcda5eafe75584,
    0x3fc4a2fcf882f930, 0x3ff8683819e36686,
    0x400228a750cdbcb2, 0xbfb838b09a6091e8,
    0xbfd6fedb2fd77514, 0x3fe1dcfc4ce0b513,
    0x3feb2ce0252249c4, 0x3ffb9c67d1661466,
    0x3ff0df6d222413c8, 0xbfe195520515a570,
    0xc0053e4e9f999819, 0xbffc7f3cd63c693e,
    0xbfe73e2be1c8c758, 0x3ff3ce66f2b148d4,
    0xbff3f57b2cf60fc8, 0xbffec368ff307f66,
    0x3ff72736e3e84e71, 0x3fdf09526675bd50,
    0xbfe53eb2a4aa9bb3, 0x3fdc8f166d556934,
    0x400b38116e5d5a61, 0x3fee29d19b609e6a,
    0x3febd784eb6181c0, 0xc009e6fa9ddf98ac,
    0xbff21315d656cc3e, 0x3fbe52923fa71e98,
    0x3fd1ccfd9601f406, 0x3fdb86f0c0013190,
    0x3ff23947d39d018e, 0xbff052d500760b9e,
    0xbff34a0d320c4086, 0x3fec88e60a81cf5a,
    0xbff4c2be5057b01a, 0x3fe2c8eb0d821ce3,
    0x400e1f99b9329575, 0xc005df8634e941f6,
    0x3ff78d1670995eca, 0xbff1778c8d5c9271,
    0xbfd4b034fce982bc, 0x3ff76c0d739c1f3a,
    0x4000a386e819caf0, 0x40006f11f8aaa904,
    0x3fd9484ce812cf37, 0x3ff73b29fac4efe2,
    0xbfc5483735bd43f8, 0xc00a17db6cf3f7a2,
    0x400065d17fe358b6, 0x3ff78b39acd60a21,
    0xbfafb9f92df293c8, 0xbfc46e802f9e4f60,
    0x3fdce64283b952a0, 0xbff5f89aca4d14a8,
    0x3fd1118a26dd88f6, 0xbfe6992741b405d0,
    0xc00da77d3aa1cc4a, 0xbfea3dfe2bd73c72,
    0xbffe7ad202b9ddf8, 0x400d9b980aee39d4,
    0x3fe9f78135859014, 0xbff4a7da064aeb91,
    0x3fca48eaeb46d918, 0xbfe768f36231568e,
    0xbffb5ddeee8d847f, 0x4005c04f44d208b6,
    0xbff85eaf992c8266, 0xbfe320282b97e5cc,
    0xbfe8ad4236fa1394, 0xbfedae08b72a79a4,
    0xc003a9e22ea28e6e, 0xbfbc5ca912b26a60,
    0xbfd76ee1316ed9d1, 0xbfefa8f731733d5d,
    0x3ff49dd6fbe700a9, 0x401111713a51ba08,
    0xbf9c2bc1a4781280, 0xc00481f0c673dec4,
    0x3feac531122a55b2, 0xbfe3170fb1f352d2,
    0x40029ed73c954e9f, 0xbfed544c1ff656dc,
    0x3ffb6302d1386d04, 0xc00460818ced306c,
    0x40038f2f3e946bab, 0xbff2e4bccf47cb1b,
    0xbfdc51c20e138810, 0x40035e7800a694cc,
    0x3fecf07da35646c2, 0x3fe8abb28aa84f83,
    0x3fc1d0a823669c62, 0x3fa913e86730afb0,
    0xc002dc87781fb672, 0xbff70fe189e5a55c,
    0x3fc2812cfa4f61b4, 0xbffde6770e3b852c,
    0xc00067a126d4f92d, 0x3fdebbfa5e439822,
    0x3fb1436a076cb178, 0x40023981175af679,
    0x400b788e80f8c9bb, 0x3fd83a3b99f5b027,
    0x3ff8037afda9ffb6, 0xbfa476360015a718,
    0xbff16687475aed66, 0xbffc9bb13360bf0e,
    0x3fa90d8f5cd615e0, 0x3ffc20351c46de3f,
    0x3ffa9d6c00024732, 0x400050cb090c3e51,
    0x3fe6060e054c1852, 0x3ff8e7706510773e,
    0x3fe4af6ec58dec0d, 0x4002e33952270482,
    0xc001512aa8e8552e, 0x3fcd09dac3987b30,
    0xc004ff4b53e19403, 0x400140bd2243cdf0,
    0xbff419839d429d62, 0xbfeba7969e3db09a,
    0x400a616177c704bc, 0x3fdb0d22f9742716,
    0x3fb0723acebf8298, 0xbff5b338ad583d32,
    0xbffba5d3fe69d600, 0x3ff45f84a433f398,
    0x3ffe57a5a388c7d8, 0x400144173570830c,
    0xc004a49fc4e0100a, 0x3fd0a38e1e435aa7,
    0xbffbbf7f7c7104d6, 0xbff1657f57023b69,
    0xbff45074bf7a947c, 0xbfed1ea6c2ca65b4,
    0x400747716a156ba4, 0xbfec6d2645ef1280,
    0xbfe7dff06e383e28, 0xbff7b989894b70d7,
    0x3fc491e4c2522b80, 0x3fe7c69d5eddb65c,
    0xbffddb0646d01907, 0xbff293d034a74f32,
    0x3fc91223fbc0ef28, 0xbffbe8343a41ca88,
    0xbfec96a7bbe75d18, 0x3ff6f278b5efa062,
    0xc0030c2aecd8e3f6, 0x400781c3a859ee2f,
    0xbfd0a6abdba2a1d0, 0x3ff9f913a140d57c,
    0x3fcb4cfd263ee700, 0xc010adc59b3a7c40,
    0x3fea2cdde839167d, 0xbfffeca7c8fe3866,
    0xbfef198795806dbd, 0x3fdbbcf3981f95d8,
    0xbff022849536695c, 0x40098f7da8eee7da,
    0xbff14570920d1e58, 0x3fec342b3a0b14e7,
    0xc0014d63d0fffba4, 0xbfd72bed967534a5,
    0x3fe30d364cd7a22f, 0x3fdf1d10cb2c5958,
    0xbff81a6c48b4c459, 0xbff6666651de4f04,
    0x3fc920e7f0b74d88, 0x3fcda19a8a6cbba0,
    0x3ffbba8bd62f6e46, 0x3ff7ea56e9a6e540,
    0xbfeaf851b46f6ef2, 0x3fe7890183564b74,
    0xbffe0b8f954dbf4c, 0x400789e13d562ec0,
    0x3f5ede7e7bf83000, 0x3fd9acbca0e68cd3,
    0xc00caa9459fc8f91, 0x4004a7dce9ac8220,
    0xc009b66ab24264aa, 0x3fb8154cb84d3fd0,
    0x3ff5eafc70923f80, 0x400be81f2221d006,
    0xbfd33399e8b3c90e, 0x3ff5bec62c8baac3,
    0x3fd1de786e138fc8, 0xbfe13fddce7d72bc,
    0xbfd4fb783b9a60b2, 0xc004bf50f0c9fc5d,
    0xc005f89bc7d1a151, 0xbfff31b6eb740c2a,
    0x3fd3867d9ef54d87, 0x400473af2eecdc70,
    0xbfe4d3f256e003c4, 0x3f97041271df12e0,
    0xbfd4d9a978d3946f, 0xbffc4ac77b56d5d2,
    0xbfd31fd5a62c1750, 0xbfd5aeff3c61dad0,
    0xbff939122599af86, 0xbfe652efdbaa681c,
    0x3ff91904e4093353, 0x3ffad424e654ad69,
    0xc0002e1d8d6e64ac, 0xbfd48eaf92f2bc07,
    0x3ff71bb363b1ba32, 0xbff15ebee223a724,
    0x3fce2d9528f8a9d6, 0x3ff3281f7a9082a3,
    0x3fe0c4200b8c1392, 0xbfda9eef2889eb36,
    0x400ca4de41f7bc34, 0xc002afc3bb069089,
    0x40060bae5f02ea1f, 0x3fcd608f2ac94db4,
    0x400095c67e25bfd8, 0x400878096c4074b0,
    0x3feebf8c746576af, 0x4003e999332dc392,
    0xbfd51e8072a0e7f0, 0x400dcf7c22b2c641,
    0xbfddf6e428c28940, 0x3fe3922cd98b394d,
    0xbff4d9ce7b988a39, 0xc0035bba4a0bb8fa,
    0x3fddd54d017e7e6c, 0xbfd25addd9bea46a,
    0x3fd2ad6ee510b06e, 0x3fe9350a1d4f0970,
    0x3ff73051d454cf2f, 0x3fe70b687d609562,
    0x3ff2f8cdec2cc272, 0xbfa0b4bc6bb17ca0,
    0xbffd6688c90fe7c7, 0xbff10cb01b2f4203,
    0xbff782d7b7b62e11, 0xbff1da81c8f4cf5a,
    0xc000159995adbddb, 0x4000339dc3c5e20e,
    0x3fdc2a8b10b5748b, 0xbfc57e986a8b2d87,
    0xbfe5a3a0f0251b26, 0xbfbf28424759e7f0,
    0xc012da791a910386, 0x3fd3f1d5f388afe8,
    0x3ffe30d97ff65e0a, 0x3ffdbec1361c0733,
    0xbff1b9b830e9c3a2, 0xbff206d538b3ea6f,
    0xbfd4c04a28f61dbc, 0xbff350fb5ce19d0f,
    0xbfd90242a386bff0, 0x3fe3583ef4e5a39a,
    0xbfbed419ffa153f8, 0x3fca6e101b24c334,
    0xbff12c6736448e30, 0xc00740cadcdd8f38,
    0xbffb99e8efb667e3, 0xbff0035acfe3d90b,
    0x3ffad0ab205e2e3b, 0x3fe243df4257443d,
    0x3ff9a33fe9a3c0a5, 0x40000343b2be15a4,
    0xbff1c5ea8f08e1bd, 0x3ff2e2d02e3ad890,
    0x4001f00fd777d30b, 0x3fea3c64510961e8,
    0x40082e457b525474, 0xc001a569573954d5,
    0x3ff1e5044e7703a5, 0xbfdc78a583f785fc,
    0x400c02fcde5228a6, 0x3fe259de94385484,
    0x3feb26e2b678b224, 0xbff60cb709d2471b,
    0xc00043ace589ba18, 0x3ff0f1fe6e27f7a2,
    0xbfdd19dbc9acf6fc, 0xbfeafc83f1309c8e,
    0x3fe3f42a7e5e48a6, 0x3ff2a937b76490d6,
    0xbfb10c9e6b3db142, 0xbffb1b7217e85488,
    0x3ff1201c2d3ee102, 0xc00199fdd604f2bc,
    0xbff22d8f5ff45f98, 0x400448358e83f812,
    0xbffa4668420523e1, 0x3fb1a8678e6975b8,
    0xbfe664ca5f20b14a, 0xbfef686c984eae46,
    0xbfec45ecfa5a701c, 0xbfdaaf5bb1a99f26,
    0xc004f4e1fa369d56, 0xbfff6dc1ba1d9403,
    0xc001d1e31f834d12, 0x4004205471f1ee82,
    0xbff2e88b40afd370, 0xbfd376d4f05ba614,
    0x3fdccf74a6e8973e, 0xbfc3525c8bc6280d,
    0x3fe6efcf5f17e0b4, 0x3fdc17264eb58579,
    0xbfeba48195b5aabb, 0xbfdc8e550ab648b4,
    0x3fb752d14cb7d854, 0xc00be5b91b7c9802,
    0xbffd096da95a4a4e, 0x3fc90f2c619eb023,
    0xbff62f6264222894, 0xbfa8fac2ef72e400,
    0xbfea8aeda7ce85bd, 0xbff358969c1a135e,
    0x3fd93def1aa7a694, 0x40016e2b37b3574c,
    0xbfec2155728f91b0, 0x3fe00b8c6d5819fe,
    0xbfeda63ed8737353, 0xbfcfdaece77b7480,
    0xbfd614014a5c5354, 0xbff0a0d452ae833a,
    0x3ff661d27f2d3990, 0xbfe1e972a964f412,
    0x3ff4ad29a19f562a, 0x3ff607c65095c2ad,
    0xbfe222a2c4ec7dae, 0x3ff720c81d9c6a1a,
    0x3fff412478d185ed, 0xbff373964a2048e2,
    0xbfb85fc12966c960, 0x3fe245ca81373880,
    0xbfddbabb8767832c, 0x3fff6cabd84fd1b2,
    0x3fcd3d22b1aa450c, 0xbfd50e797f8a04ba,
    0x3fd495a57e82b8a4, 0xbfe87bd55cac597d,
    0x3fffffc3343f16d9, 0x3fc584b60769ecb0,
    0xbfe72ddae1be877c, 0x3fe9bb9f77012226,
    0xc00902a2c504ef88, 0x3ff68fdc55637328,
    0x3ff0e33b3cdc734a, 0xbfc921c5874f69da,
    0x3fe12ac60848a938, 0xbfdea42162230650,
    0xbfff83fca9ccd91a, 0x3ff98ffa10d43768,
    0xbff0bac3e47f737f, 0x3fe63f9f3a1e0251,
    0xbfffbc217f295d13, 0x3ff87584e97a16b8,
    0x3ff720873f89a588, 0x3ff1603b982eb49d,
    0x3fe092855133a079, 0x3fed95ee61aeb66e,
    0xbfe465aff93aef44, 0xbfd14308a8a808e5,
    0x3ff131064ca45909, 0xbff381534f8f20c4,
    0x3fdb9ce52ad6e3ee, 0x3fe9246d94f8f44a,
    0x3fc8012a84ba2c42, 0x3fdf0561d16d9c37,
    0x3fec5c50cbd44e9e, 0x40099288b39a4903,
    0xbfd5f654a794fe4a, 0x3ffbb87bd2f9d617,
    0x3fe1ec42be5d6a17, 0x3ff983f667728752,
    0xc005ce4a80f1f041, 0xbff14366a1a2b341,
    0xbff80908beccee3f, 0x3ff926d0f3f72963,
    0xbfe83024a398be4d, 0xc002c1169b7a04c7,
    0x3ff8fc1e39242d5e, 0xbff3363c2acf888c,
    0x400d0c3d87af11f5, 0xbfefd29ab3ecf3be,
    0xbfeb6ede9db3d79e, 0x3fdcd97d72e748d2,
    0xbfee0f5737ebd296, 0xbfef9ec04a52adc4,
    0xbfb52720bb9b0a2c, 0xc00253beb2677704,
    0x3ff4a3f30138d95d, 0xbff4ea7dcb281b4d,
    0x3ff934e75f107505, 0x3fd732d86193e988,
    0xbfced48bde8e34a0, 0x3ff410572ab1739d,
    0x3fe6ccd3dbe97946, 0xbffba9d5395f1cb7,
    0xc000893a4a1a9f1f, 0xbfe3e203ff0c820a,
    0x3ff6042f5cbe19e2, 0x3fb9723c62941110,
    0xbfb008730fd06910, 0xbfff01265beb072e,
    0x3fe01f0a4c504e86, 0xbfe16a465af0dbaa,
    0xbfece8fb41a24417, 0xbffb659fbf8c5dc2,
    0xbfd3cf54f0726d76, 0xbfc385d44218c838,
    0x4009199b2ebb0145, 0xbfec07ed05cfebdc,
    0xbff03b7d5c4cb885, 0x4000f2d7e5dd6167,
    0x3fec988e46c70fda, 0xc01059dd7af06ea0,
    0xbfdc2b3c04541a3e, 0xbfdd81ff0511a698,
    0xc0023c03576c4208, 0x3fea85f86c519334,
    0x3feb6e9855457079, 0xbff5170f9b9b65f5,
    0xbfd68798fe7c5430, 0xc0039b47a501a8c6,
    0xbff9f7c3871c14b2, 0x3fa371143a22e940,
    0xbfc999a1047ce830, 0xc0019f180aeb33c2,
    0x4002c90b97e4cd26, 0xbfe820a4982c5a3f,
    0x3ff846aa6e6e45f8, 0x3fd1ea7d34c080e4,
    0xbfacbb0556ee16d0, 0x3fd94bd690e114c4,
    0x3fcb246e51658d7c, 0x3ff5e7de60b825f0,
    0x3ff7e3a137991a8c, 0x3fc8a261f0e98da0,
    0x40017fb9b184e93c, 0xc001966541bfbd09,
    0x40025e1c21dff328, 0x3fee710c28cf96d0,
    0xbfbd2c738991fb20, 0x3fe1ef997cd9918c,
    0x3fe4a0e795fcdf72, 0x3fed39520dafae67,
    0x3fe49efaf720c092, 0x3ffbb20f96acec94,
    0xbfe3ac6bf3bc1ef5, 0x3ff0ce6b86dd736e,
    0x3ff2ddbc8061f34b, 0x3fecd88ba137a764,
    0xbfe9a2992454ff44, 0x3ff2b0a3b40dde56,
    0xbfebcad88f15a0f4, 0xbff7b441a64963ef,
    0x3ff5527da941b557, 0x3fe30b80bcdeec5c,
    0x4000613dd2758a83, 0xbffe74841bde6b7a,
    0xc010ed37fe57d8c2, 0x4001049dd08c088b,
    0xbfe96783a7db12bf, 0xc001ee0b623bf51c,
    0xbfecc6d39e21bfa4, 0xbfe33a51fd30a7ee,
    0x4001112ac99bab1f, 0xbff3f5a2809fbc6a,
    0xc00504e32490d7a8, 0xc0027ce15222d9d6,
    0x3fd93f4b20e83b92, 0x3fb7356a03921e10,
    0xbff78d05d76164a3, 0x3ff44f8677921057,
    0xc001630adb28447c, 0xbff69ace97c8a79c,
    0xbfb8cbd4dfdc3b90, 0x3feaa264fa53a07a,
    0xbfe7d0ce3ce19358, 0xbfd32de78db3952c,
    0x3fff31cdc6642f07, 0x3fef234b77a32535,
    0x3fd503d07bd45f44, 0x4007109dde33d582,
    0xbfea4b682b4250f4, 0xbff609a90bb5bb0e,
    0xbffe153ae83733f6, 0xbfdbe3a68bfbef10,
    0xbffcbbc158c9ebac, 0x40003a7dc4168314,
    0x4005f4b7fc1f0ddc, 0xbfea6fa965a7c30a,
    0xbfef0475e37532e1, 0xc00be796e8886f24,
    0x3ff6c18b6c85d7e6, 0xbffb16a9765f38fc,
    0xbfd89661842028d4, 0xc00095ae2a4dad4c,
    0xbff74877c91dd18b, 0xbf8ada0e5105b380,
    0xbff3b54388012242, 0xbfe023ed3dfbd03c,
    0x3ffc19b5e330c83c, 0xbff07e983f6955b7,
    0x3fd198a715a7f516, 0x3fe4c353f593fe68,
    0x3fe80fd1a8be6788, 0xbff16ccbfecec8f4,
    0x3fc1c1670d16cac8, 0xbff73fba28638047,
    0x3fed6b335085618f, 0x4001064bfbc72c0c,
    0xbf9501cda6016ba0, 0xbfeaa05d17d45017,
    0x3ff22be48ed9d14d, 0x3ff1eb9110ed9b4f,
    0x4000fbf4c88632d8, 0xbfef2bdc58227644,
    0x3fd72f7c0985e474, 0xc00021d7163ec975,
    0xbffa22cae77adbff, 0xbff085269546da31,
    0x3ff024afa4cefa80, 0x4001d5e05ccebd9c,
    0xbff384f7325a089e, 0x3fb3ae7aef0a08d8,
    0x3fdc04854dcd9d99, 0xbfc02dbd44b59980,
    0x3ff73ea50c95958b, 0xbfff0a60a8a5b913,
    0xbffb6b010567fe30, 0xbfd11ed9cccd17a6,
    0x3fea622b846c85c2, 0xbff610773d263ee5,
    0x3fec0ef01b2a61ff, 0xc0055ec40a3eacac,
    0x3ff404e6f1b8760e, 0xbff3f4227e6f414b,
    0x3fe4a611f8dc66f9, 0xbfc0b072f4afcf14,
    0xbff9b1f1ac6143e0, 0xbfe4da08b4f0eed6,
    0xbfcc3bde5e393a40, 0x3fe0dce0235be74d,
    0xbfd1a48080c5bfec, 0xbff67a406bf67722,
    0xbffa56a84217a7d3, 0x3fe9b305ef35d62c,
    0xbfff25507a46afc4, 0xc005f2dbf8151059,
    0x3fbbd45c15a00e70, 0xbffb948d0f00b49a,
    0xbfa98d8be451b040, 0xbff7c6ab6ce7f3e2,
    0xbfe9c80d38506285, 0xc00120272f85af38,
    0x3feb44f74fa5703b, 0x3fefda4c372a94b8,
    0xbfefda810fa56c4a, 0xbfd15acd0f005758,
    0xbfd2986b5eb70fe4, 0xc00cb29156877ab1,
    0xc0008cbcc6e9b3e6, 0x3fe99cedf4756c04,
    0x3fe71c5a73d511e8, 0x40058e75f4da0382,
    0x3fe5ce650bdd3c35, 0x3fe3b19afa7a8d78,
    0xbffd406209ff5dc2, 0x3ff18ede66174abc,
    0xc00392dad643b644, 0x3fe1582bc7a1dbf3,
    0xbff4bd85ed0507a0, 0x40061acea82ef2fc,
    0xbfd0c96697904938, 0x3fd85e24381b6018,
    0xbff4981dde8c0061, 0xbfea2bade50f9e66,
    0x3ff5ddd465988090, 0xbfe5c98d9b8a4d26,
    0xbff53c3094ef0ee2, 0x3fd9eab9fbb4438c,
    0xbfefe32b15bdff57, 0x400103d0d4c4c632,
    0x3feb02dda79b5a84, 0xbffa67ca670c354e,
    0xbfd0daa4593d7f64, 0xbfdd04dfa9ed2c22,
    0x3fc1a2acaa3c71ec, 0x40002842a7d1e544,
    0xbfece582c20938f2, 0xc011236e0721a4b9,
    0x3ff39247125752fb, 0xc00526905ed66779,
    0x3fd5e375d024b8df, 0x40047bb805627b63,
    0x3ffd9000f9f1a1b5, 0xbfe7b007dd05acb0,
    0xbfe99c29a05a6ab2, 0x400088c791d3451d,
    0x400000e5874461ec, 0x4001572f2a70e98e,
    0x3fd3632b47502823, 0xbff207e60480255c,
    0xbff0a9279b6d8428, 0x3ff528d0dd0a51d2,
    0x3ff9a91383c8d8cb, 0xbff22c271887d248,
    0xbfcd4c9ebecce7fc, 0xbfdaddf4110ea2be,
    0xbff0a806f71098d1, 0xbfaed4088fa4cd50,
    0x3ff3cc49e3b0d4f8, 0x3fde16ebab7ad269,
    0x400115a71bf25160, 0x3fec8fc2ee45c88e,
    0xbfe7844b12ffb018, 0xbffa27a4c35fc10a,
    0xbff37dcbe77714cb, 0xbfee2c979504a24f,
    0x3ff2c3c293a7d97c, 0x3fed85bd0a4ff1dc,
    0xbfa185235c389fc0, 0xbff44becfb72a4a7,
    0x4005746dfab8050c, 0xbfe211b787b9e656,
    0xbfd999821844ac08, 0x3fdd6342b176c4a4,
    0xbff55c9c34ba63da, 0xc009083fc8896a7c,
    0xc004725fb3901363, 0xbfe1050032b66048,
    0x3fee5642ca66b9be, 0x40077d20a2187e7b,
    0xc004096e2759a8ea, 0x3fa91c35e7f98780,
    0x3fe2c31350894360, 0xbf9bc8418424f820,
    0xbff2d7a625aa5f12, 0xbfd2b61db3a5585c,
    0x3fe76dad87f3d8be, 0x4006ed1b8a54edca,
    0x4005a7746c0bf4e2, 0xc00060e81e8b858e,
    0xbfdceaae0b119e6f, 0xbfe0c84ded28056c,
    0xbffdf5f9ef799d83, 0x3fcfd6b22f7de520,
    0x3fe257ea482744ae, 0xbff984fe4de35b60,
    0xc0121c2f0c8e44c9, 0xc00c0cfba9fa6c3b,
    0xc00044140f6875f4, 0xc0013c94b56de842,
    0x3fe3147ca3bd3bf2, 0x3fe4810a6df20dec,
    0xbff193e16ec38c97, 0xc00a264c3886cde0,
    0x3fb70720cab518f8, 0x3fb1d82287218760,
    0x3fd30362846eaa6e, 0xbff64611553bdd06,
    0x3ff0b3d2230c77c9, 0x3ffb2d58fc730b0f,
    0x3fc07fba2a01b3a5, 0xbff39d64bdb81503,
    0xbff71f57e2184a33, 0x0,
    0x3fc07fba2a01b3b2, 0x3ff39d64bdb81506,
    0x3ff0b3d2230c77cb, 0xbffb2d58fc730b0d,
    0x3fd30362846eaa62, 0x3ff64611553bdd0d,
    0x3fb70720cab518f0, 0xbfb1d82287218730,
    0xbff193e16ec38ca2, 0x400a264c3886cde2,
    0x3fe3147ca3bd3bea, 0xbfe4810a6df20de6,
    0xc00044140f6875f8, 0x40013c94b56de83e,
    0xc0121c2f0c8e44ca, 0x400c0cfba9fa6c3a,
    0x3fe257ea482744aa, 0x3ff984fe4de35b5a,
    0xbffdf5f9ef799d84, 0xbfcfd6b22f7de560,
    0xbfdceaae0b119e68, 0x3fe0c84ded28056a,
    0x4005a7746c0bf4e0, 0x400060e81e8b858f,
    0x3fe76dad87f3d8c2, 0xc006ed1b8a54edcb,
    0xbff2d7a625aa5f10, 0x3fd2b61db3a5585e,
    0x3fe2c31350894368, 0x3f9bc8418424f900,
    0xc004096e2759a8ea, 0xbfa91c35e7f98780,
    0x3fee5642ca66b9ca, 0xc0077d20a2187e7a,
    0xc004725fb3901366, 0x3fe1050032b6603c,
    0xbff55c9c34ba63e1, 0x4009083fc8896a7b,
    0xbfd999821844ac12, 0xbfdd6342b176c4b4,
    0x4005746dfab8050e, 0x3fe211b787b9e666,
    0xbfa185235c38a000, 0x3ff44becfb72a4a8,
    0x3ff2c3c293a7d982, 0xbfed85bd0a4ff1d6,
    0xbff37dcbe77714ce, 0x3fee2c979504a250,
    0xbfe7844b12ffb018, 0x3ffa27a4c35fc108,
    0x400115a71bf25160, 0xbfec8fc2ee45c883,
    0x3ff3cc49e3b0d4fa, 0xbfde16ebab7ad24d,
    0xbff0a806f71098cf, 0x3faed4088fa4cd70,
    0xbfcd4c9ebecce814, 0x3fdaddf4110ea2ca,
    0x3ff9a91383c8d8ca, 0x3ff22c271887d249,
    0xbff0a9279b6d8425, 0xbff528d0dd0a51d5,
    0x3fd3632b47502827, 0x3ff207e604802558,
    0x400000e5874461ee, 0xc001572f2a70e98a,
    0xbfe99c29a05a6aa6, 0xc00088c791d3451c,
    0x3ffd9000f9f1a1b8, 0x3fe7b007dd05acbe,
    0x3fd5e375d024b8fa, 0xc0047bb805627b60,
    0x3ff39247125752f4, 0x400526905ed6677a,
    0xbfece582c20938fa, 0x4011236e0721a4b7,
    0x3fc1a2acaa3c7238, 0xc0002842a7d1e544,
    0xbfd0daa4593d7f58, 0x3fdd04dfa9ed2c21,
    0x3feb02dda79b5a70, 0x3ffa67ca670c3555,
    0xbfefe32b15bdff51, 0xc00103d0d4c4c632,
    0xbff53c3094ef0ee6, 0xbfd9eab9fbb4438f,
    0x3ff5ddd46598808c, 0x3fe5c98d9b8a4d32,
    0xbff4981dde8c0064, 0x3fea2bade50f9e5c,
    0xbfd0c9669790493c, 0xbfd85e24381b6018,
    0xbff4bd85ed050799, 0xc0061acea82ef2fc,
    0xc00392dad643b643, 0xbfe1582bc7a1dbed,
    0xbffd406209ff5dc7, 0xbff18ede66174ac0,
    0x3fe5ce650bdd3c3d, 0xbfe3b19afa7a8d77,
    0x3fe71c5a73d511f0, 0xc0058e75f4da037f,
    0xc0008cbcc6e9b3e5, 0xbfe99cedf4756c10,
    0xbfd2986b5eb70ff9, 0x400cb29156877ab1,
    0xbfefda810fa56c40, 0x3fd15acd0f00574a,
    0x3feb44f74fa57042, 0xbfefda4c372a94b6,
    0xbfe9c80d38506292, 0x400120272f85af39,
    0xbfa98d8be451b0f0, 0x3ff7c6ab6ce7f3eb,
    0x3fbbd45c15a00e50, 0x3ffb948d0f00b499,
    0xbfff25507a46afce, 0x4005f2dbf815105a,
    0xbffa56a84217a7d1, 0xbfe9b305ef35d62e,
    0xbfd1a48080c5c000, 0x3ff67a406bf67722,
    0xbfcc3bde5e393a00, 0xbfe0dce0235be754,
    0xbff9b1f1ac6143e4, 0x3fe4da08b4f0eed7,
    0x3fe4a611f8dc66f8, 0x3fc0b072f4afcf08,
    0x3ff404e6f1b87609, 0x3ff3f4227e6f4152,
    0x3fec0ef01b2a61f6, 0x40055ec40a3eacad,
    0x3fea622b846c85bc, 0x3ff610773d263ee9,
    0xbffb6b010567fe32, 0x3fd11ed9cccd179e,
    0x3ff73ea50c959588, 0x3fff0a60a8a5b914,
    0x3fdc04854dcd9da6, 0x3fc02dbd44b59978,
    0xbff384f7325a089e, 0xbfb3ae7aef0a0920,
    0x3ff024afa4cefa85, 0xc001d5e05ccebd9b,
    0xbffa22cae77adc02, 0x3ff085269546da2c,
    0x3fd72f7c0985e470, 0x400021d7163ec974,
    0x4000fbf4c88632d4, 0x3fef2bdc5822764f,
    0x3ff22be48ed9d14c, 0xbff1eb9110ed9b4b,
    0xbf9501cda6016cc0, 0x3feaa05d17d4501a,
    0x3fed6b3350856199, 0xc001064bfbc72c0d,
    0x3fc1c1670d16cac2, 0x3ff73fba28638046,
    0x3fe80fd1a8be6784, 0x3ff16ccbfecec8f0,
    0x3fd198a715a7f50c, 0xbfe4c353f593fe74,
    0x3ffc19b5e330c838, 0x3ff07e983f6955b8,
    0xbff3b54388012242, 0x3fe023ed3dfbd038,
    0xbff74877c91dd18f, 0x3f8ada0e5105b240,
    0xbfd89661842028f4, 0x400095ae2a4dad4a,
    0x3ff6c18b6c85d7e0, 0x3ffb16a9765f38fb,
    0xbfef0475e37532f0, 0x400be796e8886f24,
    0x4005f4b7fc1f0dda, 0x3fea6fa965a7c312,
    0xbffcbbc158c9eba9, 0xc0003a7dc4168317,
    0xbffe153ae83733f7, 0x3fdbe3a68bfbeef4,
    0xbfea4b682b425102, 0x3ff609a90bb5bb0a,
    0x3fd503d07bd45f5d, 0xc007109dde33d582,
    0x3fff31cdc6642f05, 0xbfef234b77a3252c,
    0xbfe7d0ce3ce1934c, 0x3fd32de78db39530,
    0xbfb8cbd4dfdc3b88, 0xbfeaa264fa53a082,
    0xc001630adb28447d, 0x3ff69ace97c8a799,
    0xbff78d05d76164a4, 0xbff44f8677921058,
    0x3fd93f4b20e83baa, 0xbfb7356a03921de8,
    0xc00504e32490d7ab, 0x40027ce15222d9d2,
    0x4001112ac99bab1f, 0x3ff3f5a2809fbc70,
    0xbfecc6d39e21bfae, 0x3fe33a51fd30a7e4,
    0xbfe96783a7db12c4, 0x4001ee0b623bf51c,
    0xc010ed37fe57d8c0, 0xc001049dd08c088d,
    0x4000613dd2758a82, 0x3ffe74841bde6b7e,
    0x3ff5527da941b558, 0xbfe30b80bcdeec58,
    0xbfebcad88f15a0f7, 0x3ff7b441a64963ed,
    0xbfe9a2992454ff4c, 0xbff2b0a3b40dde5c,
    0x3ff2ddbc8061f34a, 0xbfecd88ba137a75f,
    0xbfe3ac6bf3bc1ef6, 0xbff0ce6b86dd7372,
    0x3fe49efaf720c09e, 0xbffbb20f96acec94,
    0x3fe4a0e795fcdf7c, 0xbfed39520dafae64,
    0xbfbd2c738991fb00, 0xbfe1ef997cd99187,
    0x40025e1c21dff324, 0xbfee710c28cf96cc,
    0x40017fb9b184e93b, 0x4001966541bfbd0e,
    0x3ff7e3a137991a8b, 0xbfc8a261f0e98d90,
    0x3fcb246e51658d74, 0xbff5e7de60b825ec,
    0xbfacbb0556ee16d8, 0xbfd94bd690e114cc,
    0x3ff846aa6e6e45fa, 0xbfd1ea7d34c080e0,
    0x4002c90b97e4cd24, 0x3fe820a4982c5a43,
    0xbfc999a1047ce848, 0x40019f180aeb33c2,
    0xbff9f7c3871c14b2, 0xbfa371143a22e9a0,
    0xbfd68798fe7c543c, 0x40039b47a501a8c4,
    0x3feb6e9855457072, 0x3ff5170f9b9b65fa,
    0xc0023c03576c4208, 0xbfea85f86c51933e,
    0xbfdc2b3c04541a4b, 0x3fdd81ff0511a686,
    0x3fec988e46c70fcf, 0x401059dd7af06ea1,
    0xbff03b7d5c4cb87e, 0xc000f2d7e5dd616a,
    0x4009199b2ebb0144, 0x3fec07ed05cfebe0,
    0xbfd3cf54f0726d6b, 0x3fc385d44218c824,
    0xbfece8fb41a2441c, 0x3ffb659fbf8c5dbc,
    0x3fe01f0a4c504e8e, 0x3fe16a465af0dbae,
    0xbfb008730fd06938, 0x3fff01265beb072e,
    0x3ff6042f5cbe19e3, 0xbfb9723c629410f8,
    0xc000893a4a1a9f1f, 0x3fe3e203ff0c81f6,
    0x3fe6ccd3dbe97941, 0x3ffba9d5395f1cba,
    0xbfced48bde8e3492, 0xbff410572ab1739f,
    0x3ff934e75f107502, 0xbfd732d86193e981,
    0x3ff4a3f30138d959, 0x3ff4ea7dcb281b4d,
    0xbfb52720bb9b0aa2, 0x400253beb2677701,
    0xbfee0f5737ebd294, 0x3fef9ec04a52adbd,
    0xbfeb6ede9db3d7a0, 0xbfdcd97d72e748ec,
    0x400d0c3d87af11f5, 0x3fefd29ab3ecf3c9,
    0x3ff8fc1e39242d5a, 0x3ff3363c2acf888e,
    0xbfe83024a398be54, 0x4002c1169b7a04c5,
    0xbff80908beccee3e, 0xbff926d0f3f72965,
    0xc005ce4a80f1f043, 0x3ff14366a1a2b33e,
    0x3fe1ec42be5d6a30, 0xbff983f667728758,
    0xbfd5f654a794fe41, 0xbffbb87bd2f9d617,
    0x3fec5c50cbd44eb0, 0xc0099288b39a4902,
    0x3fc8012a84ba2c46, 0xbfdf0561d16d9c4c,
    0x3fdb9ce52ad6e3f8, 0xbfe9246d94f8f44a,
    0x3ff131064ca4590a, 0x3ff381534f8f20c5,
    0xbfe465aff93aef48, 0x3fd14308a8a808d5,
    0x3fe092855133a077, 0xbfed95ee61aeb66e,
    0x3ff720873f89a588, 0xbff1603b982eb49b,
    0xbfffbc217f295d11, 0xbff87584e97a16ba,
    0xbff0bac3e47f737f, 0xbfe63f9f3a1e024d,
    0xbfff83fca9ccd916, 0xbff98ffa10d4376c,
    0x3fe12ac60848a933, 0x3fdea4216223064e,
    0x3ff0e33b3cdc7346, 0x3fc921c5874f69e6,
    0xc00902a2c504ef85, 0xbff68fdc55637333,
    0xbfe72ddae1be8774, 0xbfe9bb9f77012227,
    0x3fffffc3343f16d8, 0xbfc584b60769ec90,
    0x3fd495a57e82b8ac, 0x3fe87bd55cac597c,
    0x3fcd3d22b1aa4518, 0x3fd50e797f8a04c2,
    0xbfddbabb876782f4, 0xbfff6cabd84fd1b5,
    0xbfb85fc12966c960, 0xbfe245ca81373884,
    0x3fff412478d185e8, 0x3ff373964a2048e9,
    0xbfe222a2c4ec7da4, 0xbff720c81d9c6a14,
    0x3ff4ad29a19f562c, 0xbff607c65095c2a8,
    0x3ff661d27f2d3993, 0x3fe1e972a964f418,
    0xbfd614014a5c5364, 0x3ff0a0d452ae8338,
    0xbfeda63ed8737350, 0x3fcfdaece77b7478,
    0xbfec2155728f91b0, 0xbfe00b8c6d581a08,
    0x3fd93def1aa7a6b0, 0xc0016e2b37b3574a,
    0xbfea8aeda7ce85c2, 0x3ff358969c1a135b,
    0xbff62f626422289e, 0x3fa8fac2ef72e440,
    0xbffd096da95a4a4f, 0xbfc90f2c619eb01e,
    0x3fb752d14cb7d7ac, 0x400be5b91b7c9801,
    0xbfeba48195b5aab6, 0x3fdc8e550ab648b4,
    0x3fe6efcf5f17e0bb, 0xbfdc17264eb5856b,
    0x3fdccf74a6e8974b, 0x3fc3525c8bc62824,
    0xbff2e88b40afd36e, 0x3fd376d4f05ba612,
    0xc001d1e31f834d10, 0xc004205471f1ee84,
    0xc004f4e1fa369d5a, 0x3fff6dc1ba1d93fe,
    0xbfec45ecfa5a7020, 0x3fdaaf5bb1a99f1c,
    0xbfe664ca5f20b14d, 0x3fef686c984eae41,
    0xbffa4668420523df, 0xbfb1a8678e6975f0,
    0xbff22d8f5ff45f91, 0xc00448358e83f814,
    0x3ff1201c2d3ee100, 0x400199fdd604f2bb,
    0xbfb10c9e6b3db146, 0x3ffb1b7217e85489,
    0x3fe3f42a7e5e48aa, 0xbff2a937b76490d8,
    0xbfdd19dbc9acf6f6, 0x3feafc83f1309c92,
    0xc00043ace589ba16, 0xbff0f1fe6e27f7a8,
    0x3feb26e2b678b226, 0x3ff60cb709d2471b,
    0x400c02fcde5228a8, 0xbfe259de9438547d,
    0x3ff1e5044e7703a7, 0x3fdc78a583f78608,
    0x40082e457b525474, 0x4001a569573954d7,
    0x4001f00fd777d30d, 0xbfea3c64510961e0,
    0xbff1c5ea8f08e1be, 0xbff2e2d02e3ad892,
    0x3ff9a33fe9a3c0ac, 0xc0000343b2be15a3,
    0x3ffad0ab205e2e3e, 0xbfe243df4257443c,
    0xbffb99e8efb667e8, 0x3ff0035acfe3d906,
    0xbff12c6736448e36, 0x400740cadcdd8f38,
    0xbfbed419ffa153b6, 0xbfca6e101b24c328,
    0xbfd90242a386bfe4, 0xbfe3583ef4e5a3a0,
    0xbfd4c04a28f61dc8, 0x3ff350fb5ce19d10,
    0xbff1b9b830e9c3a2, 0x3ff206d538b3ea6e,
    0x3ffe30d97ff65e10, 0xbffdbec1361c072f,
    0xc012da791a910387, 0xbfd3f1d5f388b020,
    0xbfe5a3a0f0251b28, 0x3fbf28424759e81c,
    0x3fdc2a8b10b57490, 0x3fc57e986a8b2d7e,
    0xc000159995adbdd6, 0xc000339dc3c5e210,
    0xbff782d7b7b62e11, 0x3ff1da81c8f4cf59,
    0xbffd6688c90fe7d0, 0x3ff10cb01b2f41fd,
    0x3ff2f8cdec2cc276, 0x3fa0b4bc6bb17d10,
    0x3ff73051d454cf34, 0xbfe70b687d609561,
    0x3fd2ad6ee510b08c, 0xbfe9350a1d4f0971,
    0x3fddd54d017e7e64, 0x3fd25addd9bea464,
    0xbff4d9ce7b988a3e, 0x40035bba4a0bb8f8,
    0xbfddf6e428c2893c, 0xbfe3922cd98b394d,
    0xbfd51e8072a0e7d8, 0xc00dcf7c22b2c644,
    0x3feebf8c746576be, 0xc003e999332dc393,
    0x400095c67e25bfdb, 0xc00878096c4074b0,
    0x40060bae5f02ea1f, 0xbfcd608f2ac94d70,
    0x400ca4de41f7bc33, 0x4002afc3bb06908c,
    0x3fe0c4200b8c138a, 0x3fda9eef2889eb36,
    0x3fce2d9528f8a9fc, 0xbff3281f7a9082a9,
    0x3ff71bb363b1ba32, 0x3ff15ebee223a72a,
    0xc0002e1d8d6e64aa, 0x3fd48eaf92f2bc05,
    0x3ff91904e4093353, 0xbffad424e654ad62,
    0xbff939122599af87, 0x3fe652efdbaa6814,
    0xbfd31fd5a62c175b, 0x3fd5aeff3c61dad6,
    0xbfd4d9a978d3947a, 0x3ffc4ac77b56d5d2,
    0xbfe4d3f256e003c8, 0xbf97041271df1340,
    0x3fd3867d9ef54da3, 0xc00473af2eecdc6f,
    0xc005f89bc7d1a154, 0x3fff31b6eb740c25,
    0xbfd4fb783b9a60c0, 0x4004bf50f0c9fc5f,
    0x3fd1de786e138fca, 0x3fe13fddce7d72b7,
    0xbfd33399e8b3c916, 0xbff5bec62c8baac4,
    0x3ff5eafc70923f86, 0xc00be81f2221d004,
    0xc009b66ab24264aa, 0xbfb8154cb84d4020,
    0xc00caa9459fc8f8f, 0xc004a7dce9ac8224,
    0x3f5ede7e7bf82700, 0xbfd9acbca0e68cd4,
    0xbffe0b8f954dbf48, 0xc00789e13d562ec0,
    0xbfeaf851b46f6ef0, 0xbfe7890183564b7c,
    0x3ffbba8bd62f6e46, 0xbff7ea56e9a6e536,
    0x3fc920e7f0b74d94, 0xbfcda19a8a6cbba8,
    0xbff81a6c48b4c45f, 0x3ff6666651de4f02,
    0x3fe30d364cd7a237, 0xbfdf1d10cb2c595c,
    0xc0014d63d0fffba5, 0x3fd72bed96753484,
    0xbff14570920d1e57, 0xbfec342b3a0b14ea,
    0xbff0228495366952, 0xc0098f7da8eee7da,
    0xbfef198795806dbc, 0xbfdbbcf3981f95d2,
    0x3fea2cdde8391672, 0x3fffeca7c8fe3868,
    0x3fcb4cfd263ee520, 0x4010adc59b3a7c40,
    0xbfd0a6abdba2a1c0, 0xbff9f913a140d57c,
    0xc0030c2aecd8e3f6, 0xc00781c3a859ee30,
    0xbfec96a7bbe75d13, 0xbff6f278b5efa060,
    0x3fc91223fbc0ef10, 0x3ffbe8343a41ca88,
    0xbffddb0646d0190a, 0x3ff293d034a74f32,
    0x3fc491e4c2522b94, 0xbfe7c69d5eddb65c,
    0xbfe7dff06e383e2e, 0x3ff7b989894b70d3,
    0x400747716a156ba4, 0x3fec6d2645ef128c,
    0xbff45074bf7a9481, 0x3fed1ea6c2ca65a4,
    0xbffbbf7f7c7104d7, 0x3ff1657f57023b67,
    0xc004a49fc4e01008, 0xbfd0a38e1e435ad1,
    0x3ffe57a5a388c7db, 0xc00144173570830b,
    0xbffba5d3fe69d5fd, 0xbff45f84a433f39c,
    0x3fb0723acebf8288, 0x3ff5b338ad583d36,
    0x400a616177c704bf, 0xbfdb0d22f97426f4,
    0xbff419839d429d63, 0x3feba7969e3db090,
    0xc004ff4b53e193ff, 0xc00140bd2243cdf1,
    0xc001512aa8e8552e, 0xbfcd09dac3987b3c,
    0x3fe4af6ec58dec11, 0xc002e33952270480,
    0x3fe6060e054c1858, 0xbff8e77065107739,
    0x3ffa9d6c00024736, 0xc00050cb090c3e4e,
    0x3fa90d8f5cd61670, 0xbffc20351c46de3e,
    0xbff16687475aed69, 0x3ffc9bb13360bf08,
    0x3ff8037afda9ffb4, 0x3fa476360015a778,
    0x400b788e80f8c9bc, 0xbfd83a3b99f5afff,
    0x3fb1436a076cb1c4, 0xc0023981175af677,
    0xc00067a126d4f92c, 0xbfdebbfa5e439830,
    0x3fc2812cfa4f6188, 0x3ffde6770e3b8528,
    0xc002dc87781fb672, 0x3ff70fe189e5a55a,
    0x3fc1d0a823669c4c, 0xbfa913e86730af40,
    0x3fecf07da35646c8, 0xbfe8abb28aa84f7c,
    0xbfdc51c20e1387f4, 0xc0035e7800a694ce,
    0x40038f2f3e946ba8, 0x3ff2e4bccf47cb24,
    0x3ffb6302d1386d02, 0x400460818ced3070,
    0x40029ed73c954e9e, 0x3fed544c1ff656ee,
    0x3feac531122a55ab, 0x3fe3170fb1f352d0,
    0xbf9c2bc1a4781480, 0x400481f0c673dec5,
    0x3ff49dd6fbe700b6, 0xc01111713a51ba08,
    0xbfd76ee1316ed9de, 0x3fefa8f731733d58,
    0xc003a9e22ea28e70, 0x3fbc5ca912b26a30,
    0xbfe8ad4236fa1396, 0x3fedae08b72a79a9,
    0xbff85eaf992c8268, 0x3fe320282b97e5c6,
    0xbffb5ddeee8d8476, 0xc005c04f44d208b6,
    0x3fca48eaeb46d938, 0x3fe768f36231568e,
    0x3fe9f7813585900d, 0x3ff4a7da064aeb96,
    0xbffe7ad202b9ddec, 0xc00d9b980aee39d4,
    0xc00da77d3aa1cc4a, 0x3fea3dfe2bd73c63,
    0x3fd1118a26dd88fe, 0x3fe6992741b405ca,
    0x3fdce64283b95288, 0x3ff5f89aca4d14ae,
    0xbfafb9f92df29338, 0x3fc46e802f9e4f64,
    0x400065d17fe358b8, 0xbff78b39acd60a1c,
    0xbfc5483735bd440c, 0x400a17db6cf3f7a1,
    0x3fd9484ce812cf38, 0xbff73b29fac4efde,
    0x4000a386e819caf1, 0xc0006f11f8aaa902,
    0xbfd4b034fce982b0, 0xbff76c0d739c1f3c,
    0x3ff78d1670995ecc, 0x3ff1778c8d5c9273,
    0x400e1f99b9329570, 0x4005df8634e941fa,
    0xbff4c2be5057b01c, 0xbfe2c8eb0d821ce5,
    0xbff34a0d320c4086, 0xbfec88e60a81cf63,
    0x3ff23947d39d018d, 0x3ff052d500760b9e,
    0x3fd1ccfd9601f3fe, 0xbfdb86f0c0013184,
    0xbff21315d656cc39, 0xbfbe52923fa71f14,
    0x3febd784eb6181b0, 0x4009e6fa9ddf98ac,
    0x400b38116e5d5a63, 0xbfee29d19b609e64,
    0xbfe53eb2a4aa9bb7, 0xbfdc8f166d556948,
    0x3ff72736e3e84e71, 0xbfdf09526675bd3a,
    0xbff3f57b2cf60fcf, 0x3ffec368ff307f66,
    0xbfe73e2be1c8c756, 0xbff3ce66f2b148d5,
    0xc0053e4e9f99981c, 0x3ffc7f3cd63c6934,
    0x3ff0df6d222413c7, 0x3fe195520515a573,
    0x3feb2ce0252249d2, 0xbffb9c67d1661469,
    0xbfd6fedb2fd774fc, 0xbfe1dcfc4ce0b512,
    0x400228a750cdbcb0, 0x3fb838b09a609258,
    0x3fc4a2fcf882f92c, 0xbff8683819e36688,
    0x3fc44a6b003e616a, 0x3ffcda5eafe75584,
    0x3ff94de9bee5b8c6, 0xc006206aa6d90529,
    0x3ffd76ec340b17fc, 0x3ff7667bbb6e86e0,
    0x3ffd477697435197, 0x3ff8346379ca28a8,
    0xbfdc770da16937c1, 0x3fc6b0efdc45f2ec,
    0x3fe3ca1aec9ef9ce, 0xbffcfa77009a7dac,
    0xc009870c704b1146, 0xbffd1d9167b2d0b7,
    0xbffdf16849c9c9a8, 0xbfe7af3ddf7d3073,
    0x3fef0a3e14144914, 0x3fcaf1efd6e016b8,
    0x3fe50be6efa661e1, 0xbfd46a180bb11460,
    0xbff9e2edb55866af, 0x3ff4f4dbea7cd2c8,
    0x3ff3c68b92f35537, 0xbfec073f2420f34e,
    0xbfe68a452bcb1143, 0x40027f121aef25c8,
    0x3febe6a2bd0e6c34, 0xbfe20d59e330a3b2,
    0xc0096f39f7abdf7e, 0xbfa63daf33dbc920,
    0xbfd2f3c90f5c3ba2, 0x3fe4720fdfb91df4,
    0xbff3387e10dd6319, 0xc00ec7d4c74ba0f5,
    0xbfbbf8d2eca0cdac, 0x400424a3a9c4f1e8,
    0x3ff23921b8e0bb70, 0x3fc115ca0f828b7c,
    0xbffe261eec2ff142, 0x3ff6d9717d549888,
    0xbfc0d420e2044ec4, 0xc007a0bc40474a18,
    0xbfffe26f77c307ad, 0x3feec9f65e633dde,
    0xbffb9743be70b054, 0x3ff3a9f32f6f0b8b,
    0x3fe0d7538c56aa84, 0x3fb6296b22414ce4,
    0xbff8a34dd41125d9, 0xbfe36c634f53df6f,
    0x3ff0396d23db3a04, 0x3ff9ac20c576f6fd,
    0xc00b318186f4a840, 0x3fd5abaf6bf73084,
    0x3ffed2e19dc73271, 0xbff2c0ad8e58951f,
    0xbfe79ebfe2f9ecf4, 0x3fba82102cfb77e8,
    0xbfe1be085a3cf7d7, 0xc004cda50694f190,
    0x40029dc92d5894c3, 0xbfd6afb6572c60ec,
    0x3ff1f4449b10e05b, 0x3ff18af9bea39494,
    0x3ff6293038164072, 0x3fdfdf9ac252cfc4,
    0xbff9d1390d2cb2b6, 0x3fe958f5ca82f3ca,
    0xbfdebd85c13398f4, 0x3fd25ff35db8dab4,
    0x3ff23cafe65aec47, 0xbff8b01ead8dd307,
    0xbfe3aa1312d706e4, 0xbff72fcf68585aa5,
    0xbff7506e3744d586, 0x3fdbc9f830b07d76,
    0x3ff62fd8717c653a, 0x3fefbc6027dd9ca0,
    0xbfe04dc88a0706f0, 0xc0049b64b8b89f35,
    0xbfdf0661a28b2d48, 0x400072a8523028a5,
    0x400457cf161b39e6, 0xc00101739dd03756,
    0x3ffb5035a717a0b0, 0xbfd49fcda289375d,
    0xbfcc8ae2a162cb70, 0x3ff24f078c0f5652,
    0xbfdd094ec9ee3d4a, 0xc00a34fe501db972,
    0x3fe327d7c028836d, 0x3fdfc6ade66add22,
    0x3fdd670b8453b0ec, 0xbff989d28d1fe2ea,
    0x3fbf88377e83cdb0, 0xbfe03a9f64da63e2,
    0x4018fc992c24b60d, 0x3ff0d831b088be4d,
    0xbfef59c465543a47, 0x4000831cce427930,
    0x400c35ce985e9aa5, 0x3ff8b06a53c7de3a,
    0xbfe1b23a8f5ed25c, 0xbff09a3448cc5066,
    0xbff22c3849416abe, 0x3fcaf1e7ebb31190,
    0xbff22a8d9ada5add, 0xbff5992f27098c9b,
    0xbfe992db85fd792d, 0xbfddd84a930029e9,
    0x3fda0485a1c1d4ca, 0xc00678aa84ec00ed,
    0x3febc7d95ded9248, 0xbfdb3f5ba296d2cc,
    0x3fe1434125f44f30, 0xbfdb2616eb88051c,
    0x3ff00bad0c78959a, 0xbfd8bade9778cad0,
    0x4004e27ea760397f, 0xbfe4615a4f021196,
    0x3fe8f70fdc9237c6, 0xbff6ab6b2d155aef,
    0x3ff00365fda41240, 0x3fe77d8873919052,
    0x3fe82efa47c8e635, 0x3fe97eff5c471e3e,
    0xbfe82841bafbba63, 0xbfe199c73d233d83,
    0x3ff65364a5714edc, 0xbff7fba8022e4cf6,
    0x3ff085decdc95dcf, 0xbfe903fef786ced9,
    0xbfe2844e401db337, 0xbf8f7894205b22e0,
    0x3fc66450fe61aebc, 0x3ff06fe6762d63cc,
    0x3fdbc9038ff75f24, 0x4008e09bd90cc3b1,
    0x3fdb4c309c22fe04, 0xbfef5a4e4c2ac2b0,
    0x3ff3bb6f9d8e4a15, 0xbffb24da8f3efa35,
    0xbff3de0201e7ec56, 0xbfd19068b8931fe6,
    0xbfeb7c1e45d51b11, 0xbfdcab54a48d7b6a,
    0xbfe3f00dd20341ec, 0x3fe2bd271373b546,
    0xbfe81ede88104005, 0x3fa2697ae6f53220,
    0xbff350c0481ed79f, 0x3fdb9657f972eca8,
    0x3fedb78b3f7d97d5, 0x3fe4437dbf88b8c1,
    0xc00558d477403c27, 0xc00280aa7f8d4361,
    0xbffb4a2456d8fd20, 0xc0023a9c19d8d168,
    0x3fc49cf2c080cb64, 0x3feaa8df341af3f6,
    0x3ff7e5312385a363, 0x3ff5da51ad3b645a,
    0x3ff624b4a6541690, 0xbff7e37412568a8e,
    0x3fb416123098c7c8, 0xbfe6c51c6b6e81f0,
    0xbfe29e7806506dbf, 0xc00284f1b84788cf,
    0xc0090cfca0766501, 0xbfe6528428520a82,
    0x40018f03bee2fbb6, 0x3fe02930941494a0,
    0x3fc1172c335fe1f8, 0x3fcadce0c684ee24,
    0x3fb4b8265c4257ba, 0xbfe6e5dc02739408,
    0x3fdcaf55ab015a78, 0x3ffef8ba165dc760,
    0x400340d7795f6718, 0xbfe18e484d697d10,
    0xc00489ea5031e3c7, 0x3ff6807502d8324e,
    0x3fea6e82530e652e, 0xbfeb0e769e0c1752,
    0xc001c60612e86064, 0x3fef11bb43dae114,
    0x3fe53c0928f9b1de, 0x3ff3612f9955847a,
    0xc00acff017db9a8a, 0x3ff44758b85cae48,
    0xbfe7d5a11310e4c9, 0xc005a9a00ebe60fa,
    0xbff37baaba0e2170, 0x3ff42b97f40b0982,
    0x400645dedff4ca08, 0x3f8db6c832064480,
    0xbfffb2e04509dfae, 0xbffcedd5b696fa92,
    0x3fd768711b1b1ebb, 0xbffd452a165f2a98,
    0xbfe0e6bb8659c276, 0x3fe3ce34f6d969a9,
    0x3fefd310fac86f12, 0xbff78d44c86bffd4,
    0xc00168017bc3b06a, 0x3ff3508306d2cd69,
    0xbfd72d2d49bb18fc, 0x3fee2dfa8f6943c4,
    0xbfd177dfff040fbe, 0xbfb2367cc8d7d940,
    0xc0012394436dc7ba, 0x3fc20abf1d5fd670,
    0xbfd90625f1fa6012, 0xbfd6c2f13f7696a6,
    0xc006dd0d158320c4, 0xbffbc76a788ff87e,
    0xc0011615e1839963, 0x3fec650d02aebf74,
    0xbfcb1451e7c301e8, 0x40010501525e1e06,
    0xbffddd67142cd48e, 0x3ff6446d3b7481fe,
    0xbfd65065a7d038ec, 0x3fe45cad42ad0ed2,
    0xbfe7e38503b5b676, 0x3ff71e3abef49e32,
    0x3ff54bda0258fcce, 0xbfd55dc0d5573c90,
    0xbf91fe7266714430, 0x3feaa7bfa0808394,
    0x3fdf4e6d57c697f4, 0x3ffb23b5f7dd20d5,
    0x3feaca5c34d0f109, 0x400101097841cad6,
    0x4001afca18092fb2, 0xbffa7fb1ad2e1f1e,
    0xbfea4e3f7a790abc, 0x40027be296b5caf4,
    0xbfd817bb6a9197a0, 0xc00560db3473b223,
    0x4009900008b28966, 0xbff89d9e5b410040,
    0xbff292a86c1b400f, 0x400864bd8d9782d2,
    0xbff778bcf01abd7a, 0x3ff5b447e7d619ea,
    0xbff09847036b3083, 0xbfea14d834996148,
    0x3fe6eee4a7e7d671, 0x3ffa59870075a81a,
    0x3ff003233d0dcd42, 0x3fe976ce3968e2c6,
    0xbfed4dbf18936acc, 0xbffc9eb3ff071845,
    0xbffc4a2f6268350a, 0xc0005f6bf094e021,
    0xbff2eab1e787e2c7, 0x4005191d3a464e84,
    0x3fed2a6b1d0f4b25, 0xbfe63726b7d195f6,
    0xbff6e31646128c6d, 0x4002e796fc792c6a,
    0x3fe764f738c53ba4, 0xbfef6e28714b8ccd,
    0x3fac0bd7954c8a60, 0xc0046e16a1820cb8,
    0xbfc6d3baccc251c8, 0x3ff279ae06b9bd5a,
    0xbfdbe26cf91ee4fe, 0x3fe77daa8d3af5a8,
    0xbff45df97ca853f6, 0xc00343ec4129c5d5,
    0xbfd602a92d9b7c20, 0x3ff93ab7a63e3807,
    0x3fa2eed1ecf40c60, 0x3fc306a105985c60,
    0x3ff1d10512660144, 0x3fe13a8cd43c438c,
    0x3ff282bb85865893, 0x3fde6140e8c15e2b,
    0x40041e3b6aaf5781, 0x3fe93b8f75110dff,
    0xc00132534fe5c91a, 0x3ffc29235efc08e2,
    0x3ff58d8c2228a8d2, 0xbff91e75aba3d505,
    0xbfd3e97982837418, 0xc00030bdd4144e9a,
    0xc0066506bcb5cec6, 0xbff0c116036ed75c,
    0xbff19d4bdf0505e7, 0x3fe39a42dd1bc652,
    0xbfe2f352f1f0170a, 0x3ff16e288d6db0b8,
    0xbfd227f5443fb334, 0x3fce626ba69d28ae,
    0xbfc6110443722fb0, 0x3fff82175ddba2e2,
    0x40120ecbe5987581, 0x3fe8da2f128ef03e,
    0xc001838faaa602ba, 0xbfe0bf8f72e80fa7,
    0xbfe7be60afd25ad3, 0xbfe2fec7c036f096,
    0xc0022085ef34d2a1, 0xbfe264ba76b48543,
    0x400130d18119f55a, 0x3fe36645dbfea34f,
    0xbfe2388aa3df92e8, 0xbfda9f93df3941b3,
    0x3ff2f1a3bc48dce8, 0x3ff3b147c35fc32d,
    0xc00ced17a3158c82, 0xbffc8c088cfcc7a0,
    0xc002745059924520, 0x3ff74d295ec34045,
    0x3fad97eac98c2a40, 0xc0075d585eb4cbec,
    0xbfee6401ffed48aa, 0xbfd6f88204902dae,
    0xbff0f959c3f430c1, 0x400778a656117bcc,
    0xc0029ea33295ee2b, 0x3fff209b3eba8368,
    0xc002d1f5cb12bf28, 0x400e53ab6ee66d26,
    0xc0080a32baa5fe3e, 0xc0081f99a5a1596a,
    0x3ff2dba833cb998c, 0x3f7b6472bffc7000,
    0xbff78799387eb0de, 0xbfdbc5a3e9239cf6,
    0x3fc621261484ae37, 0xbfe2ebf525a3f9f3,
    0x3ff457afede5f6c9, 0xbfe90b4249ec765c,
    0xbff413ba8a13d4b4, 0xbff3d3e10b00d0fb,
    0xbff51f021e03530c, 0xc00074c06860c9bb,
    0xc004e3c5032f3bf0, 0xbffbdf8a8a20196d,
    0x3fe8841c1eab89ec, 0xbfe9b73042827f8c,
    0x3fedd030831fa9f0, 0x3ff20dd6469ba452,
    0x3fd8e48a97602fe0, 0xbff58250826eed9a,
    0x3ffebfb092aa7e2a, 0x4001975516f75c69,
    0xbff06873b80dfa0f, 0xbfcad7c6feba0840,
    0x40012fcb1ef5a93c, 0x4000d0b78e1c3dd2,
    0xc000643aa263ba3a, 0x3fe8887aac7e1fe6,
    0xbff65c6dfedf8b12, 0x3fe06be8b14b8dc3,
    0x3ff71413ee3d0a96, 0xbffdee24ff153f1d,
    0x3fcdc579074c084c, 0x3ff05e3663f88169,
    0x3ffbba867d318c4d, 0x3fe141c581257d00,
    0x3ff47ceecb9eb1c8, 0xbff0f736a9122ab8,
    0xbff1c8cdc462ce0d, 0xbfff676e307bb5ba,
    0xbff7e07f1104e8f0, 0x3fd9cb34686e702a,
    0x40080cc39df58e2d, 0x3ff4a3bcd736beac,
    0xc007cb369a7c89f2, 0xbfe7a4d6d61547b7,
    0x3fe917488e83f0a8, 0xc01848e0eb1e0ab5,
    0xbff32726ae7007e7, 0xc00592b352746e96,
    0xbfed6e4671a2f146, 0x3fb86dc107ca3178,
    0x40074955c5a2d909, 0xbfe42b5989c76208,
    0x400a739255b5447d, 0x400b4a92e58f94eb,
    0x3fde63d07f2f0bd0, 0x3fe4c2a61b35d874,
    0x3fd7ded66915af16, 0x3fe4398da7f88d75,
    0xbff5c19814d499e4, 0x3fd74f1f355cd9a0,
    0xc00015eedff1a4d6, 0xbfba7dbc7ef84b14,
    0x3f9295fd551cd6b0, 0xbff7158f66ba897b,
    0xbfd62796039ad352, 0xbfefc04c2f9d5f40,
    0x400716dbbaea0d76, 0x4006bfabb229b9d6,
    0x3ff395178eeba088, 0xbf95c71b41483c00,
    0x3ff06c89c6cb11af, 0xbfe4c2c2ab0f2c80,
    0xbfe22205ae10697a, 0x3ff3fa13daa6f53c,
    0xbfee6f5b20c6efef, 0xbffb99be46fd9ba1,
    0x3fdfbb214057f7f8, 0x3ff8287094b1e3ec,
    0x3f9da21ce57b2a60, 0xbfebb877969b1726,
    0x3ff9f752933f1c34, 0xbfed2e72287ebe02,
    0xbff60a9cae40c6fe, 0x40086629975a90f8,
    0x3fc0ca38807cbcd8, 0x3ff49b36013977d0,
    0xc001669348aba292, 0x3fd70b98c1ae3642,
    0xbfa19ad11524bfc0, 0xc002818c0348182a,
    0x3fe644081f9c2ceb, 0xc0028cd881d3e40a,
    0xbfe50f212952adaa, 0xbfe4ef9940529cba,
    0xbff13b166a74c7f3, 0xbfd31c0248164e79,
    0xbfff1b70a78689c5, 0xbfbfdc1ce9a2fea8,
    0xc00b4b5053fa9864, 0x40010d5015b78da3,
    0xbff04b77c353ac98, 0xbff0f03f087a417c,
    0x3ff4b4079583ed54, 0xbfe720e332f43d88,
    0x3ff90654293300c1, 0xbfe0983acc0e123c,
    0x4000ce41a764a65a, 0x4001b0e43319a67a,
    0xbfdaa09e917d7df7, 0xbff21081caed5b60,
    0x3ff213c3924a0698, 0xbff2ab72846d0a8c,
    0xbfd4439ffccc027c, 0x3fde1256237f7324,
    0x3fead0d65a4f5d3c, 0xbfff0bc0e62195b8,
    0xbfed77c2bcfad2e4, 0x3fdbe050f9e0ca54,
    0x3fe06dbb7d27a35e, 0xbfc5219350295600,
    0xbff5a64e2ac6e60e, 0x400f51f01a7746c2,
    0xbfee4aba1764a514, 0x4003dae423e715f6,
    0xc002f9b80e3aec13, 0x401323c83e589ed6,
    0x40009b18a9b32fcb, 0x3ffd8e6dc32c98ca,
    0x400a638c1b461ddc, 0xbfe49dbd345a450a,
    0xc00685d9f76af322, 0x3ff417bf1b9631f3,
    0x400f43ec91accde6, 0x3faa37a1b7800e90,
    0x3fc458dfbdde99ec, 0xbfec5ec65307fbdc,
    0x3fec699ac69bd6f2, 0xbfff23298da49594,
    0x400ee355707a6d84, 0xbfff0f93fd3db7af,
    0x3fa74779cb0802c0, 0xbfe0f5610babef86,
    0x3ff1c66c8e30ea4f, 0xbff1f158ef2f170b,
    0x3fd590c9b08e28d2, 0xbff6ddedc49df1a1,
    0x3ffc005b53314877, 0x3fd4409994e8bc7a,
    0xbffc6e05ab11c8cf, 0xc003a543dfad928e,
    0xbfefb134826ad55b, 0xbfe41c44930f8f7a,
    0x3fe26e7e8073a2f8, 0x3ff36c3fc06bd450,
    0x3fcbfcc9f52ad510, 0xbfd5bb29cdcce120,
    0x4016e05b76882a47, 0x3fe5916719f59e7c,
    0x3ff681fe383054a0, 0x3ffbc1fd7809dffa,
    0xbff93534632d3305, 0x3fd857b12ed21ed8,
    0xbff874f5311e1898, 0x400817b5a2642c42,
    0x3ff39caabe11f422, 0xbfee07dff0af6036,
    0x3fe356a95f5f6440, 0xbff1d89c086ab03e,
    0xbffc2aef6341228d, 0xbfae912ae2dcefe8,
    0xbfe1fba4bc78e3c0, 0xbff69b96e7ebce78,
    0x400cc07edb6db228, 0xbfc3604ccf8c1ffc,
    0xbff8b72f27a36a3e, 0xbfd6f2ae4f251312,
    0xc00148c0bc82b3df, 0x3fdba6357c5c22ee,
    0x3ff56d653e3810dc, 0xbff9deaf1d2f989e,
    0xbfd3b52f1a3c7280, 0xbffb360c421d3c55,
    0x3ff9473127ef152a, 0xbfe1972501c88686,
    0xbfe421375c04562b, 0x3fe5e38b30866f66,
    0xbfeeeb95e0bb1775, 0xbff2f5068e19c6e8,
    0xc0020401cc7d1d7a, 0xbfe719a98875051f,
    0xbfddd6a23f855556, 0x40056925c09f7690,
    0x4000f0493b02e0bd, 0xbfb917930bbb0220,
    0xbfd7e12c6c38e660, 0xbfacbf5d2b1023b8,
    0xbff4e60445c2a79a, 0x3ffa3cb99c16330b,
    0xbff64d3daf149b10, 0x3fe467a91ef2d0be,
    0xbff391cb65e3a31c, 0xbffc66ee080d8089,
    0x3fb0db2a567dae00, 0x400572417b907b3e,
    0xbff0cf7662b74d67, 0xc0040d44fadf01ac,
    0x3ff5e084c83be076, 0xbfd288fb3b21b417,
    0x3fdd3d0aeb4a27db, 0xbfb30cb0d40091f8,
    0x40039cb2e688ed99, 0x3fbe8ed06935d110,
    0xbfc90d29b0ea066c, 0xbffcea1f5083a02d,
    0xbfe2b0fb1346d26d, 0xbfc911181bdede78,
    0xbffd9ac24aed808d, 0xbffeec5a83d44f86,
    0x400904b59774bbb4, 0xbfca70d30e086168,
    0xbfd727d9e7c6f3db, 0x3feb95c4c3cf5ff7,
    0x3fe557e0686cae12, 0xbff284fb1500b4f0,
    0xbffc177dbef329ca, 0xbfe9016d48be7c12,
    0xc006cf3510a23aea, 0x3ff764c1912d4c8e,
    0x3fe400b0a22ac753, 0x3ffbc59446ce08a4,
    0x3ff4d5c3b594ca20, 0x400089cf559bd650,
    0x3ff1d858b38b211d, 0xbfe80c3f7ad48a14,
    0x3fe56462d3ef1914, 0x40144cf2d5f65336,
    0x3ffa07b8e7ddb6eb, 0x4005d7e06f60ffe0,
    0x3f90b8ab37908fc0, 0xbffa4b622a818ecc,
    0xbf855bc3d02a7d80, 0xbfc731f773b6ba10,
    0x3fff33e955cedcf3, 0xbfd046b5a257070e,
    0x3fe3b7b37b493d7a, 0xbfbfe34e0d241532,
    0x3fd19b367546ff18, 0xbff4029fe777122e,
    0x4002d27465953850, 0x3fc843250895cd90,
    0x3ff69fa2017f02d5, 0x3fc210fcf7c89ee5,
    0xbfe07a3952a9a773, 0xbfff05502ec0d670,
    0xbff7ca2157a8a7c6, 0xbfe38daf6dbb0f85,
    0xbff20fdcb69aa5a3, 0x4011234ec3a7af1f,
    0x3fca541da11c9407, 0x3fe1f3ee3e6591e0,
    0xbff6b4063fb21847, 0xbfd2f4a32764c7b6,
    0x3ff955e30928f4f0, 0x3feb36265fc57d52,
    0x3fe7d786c108eddd, 0xc0020b6b45f759a2,
    0x3ff82e7898247d9e, 0xbfd28da9db480ff4,
    0xbfa0ca21ed51a920, 0xbff530afa24f6d96,
    0x3ff6f4b55e89115b, 0x3ff4d0c0cebf047e,
    0x400fb5b25aae477a, 0x3fd77a3a0ce26b24,
    0x3ff09f36e51128ea, 0x3ff6ac338a4c7c8e,
    0x4001af84e3344ab8, 0xc00a96b0363e700a,
    0xc009e482052bfff3, 0xc000b061f4f95de6,
    0x3fdc8a9cb6edcf49, 0x3ff006e6a4af786f,
    0xbfd519c76ac6d1c0, 0x3ff0ae1ac76595a9,
    0xbfcaec617e95702a, 0x400b7f5e7dbb66ac,
    0xbfe382429b5fffb0, 0xbfe57f52204e0d7e,
    0xbffca29f3b7b51ac, 0xbfcff5eadb03d704,
    0x3fd2cdc43eef2080, 0xbff6c84bcd9e2b18,
    0xbff9e698fcaef56b, 0x3ff8d83891065d3c,
    0x3ff01025bb5eade6, 0x3fe468ed593b05f4,
    0x3ff6ec2705709d98, 0x3ffa4e7adfa2049c,
    0x3fe19cdea924f260, 0xbffa8b0e2570519c,
    0xbff7f6176133751c, 0xbfed6271caee4277,
    0x3fff77ce3352b431, 0xbff78ee54a56f4be,
    0x3ff5ee906e8f0696, 0x3fe6b44f7a016246,
    0x3ff1f78ef78132cc, 0xc0025ea046d424d8,
    0xbff4805a4fade0d0, 0x4008f9873458b170,
    0xbfdf9a12815ae892, 0x3fb854924840e54c,
    0x3fc26aa661e18b20, 0xbfecd60bfa274cd4,
    0xc0066b81d0a7ebd6, 0xbfed1e60b4f7bfb5,
    0xbff9e7bcd7222392, 0xc00b78303725e7fc,
    0xbff93067daae8867, 0xbffe4137567f9e79,
    0xbff822a69c7130e4, 0x3ff3d4bd0540d798,
    0xbfb480aade3a5ac0, 0xbfe5b51baeed96f4,
    0x3fb07d3ee57fe420, 0xbf8bde2c253b85c0,
    0x3ff7921b99c8e2d5, 0x40011bd586e5dc91,
    0xbffd17f3606fa631, 0xc000e30556c47162,
    0xbff5511fb65726fc, 0xbff9322d0ad673ea,
    0x400131cc1804a6b1, 0xbfdb602382619caf,
    0xbfff71b28db77261, 0xbffcea0eee2f68a1,
    0x3fce0f76b39d8711, 0x3fd15e797ece57c0,
    0xbff1691c8063a8f0, 0x3ff57c612011c12c,
    0x3fc8843c1714e2a8, 0x3fe9496ab4198ac9,
    0x400b73762cccf973, 0x3ffcfc948960586d,
    0xc0027db2a9fdb81a, 0xbfeab5dd036143cd,
    0xbff0f20cfa89a35f, 0xbfe800bf37564d21,
    0xc00de447908fb19d, 0xbf8424635955f980,
    0x3fffb9a7810fef40, 0x3feb8710d042c2bc,
    0xbfe9af21fcdbfbf5, 0x3ff010a0b86c221f,
    0x3fe7f18e9a3dfa68, 0xbfdfed6f46b8e678,
    0x3fdd97fa4d78dc02, 0xbfa9ffe459539050,
    0xbffda69e66fa0fd5, 0xbff3e0de98e4cad5,
    0xbff12402b824169e, 0x3f4c811460150000,
    0xbfe851a3b5f9ad7d, 0x401326d27b15cd6e,
    0x3ffbd9c9b65596ff, 0x3fed16614af1c798,
    0xbff3e8cd1fbf7a84, 0x3ff1d8e64eedfb0e,
    0x3fb65bd145d26bf0, 0x4000454d08f767f0,
    0xbff522281326ed85, 0xbfe8713ee900103a,
    0x4006a043663d210b, 0x3ffa1bcef2bd425c,
    0x40031508fe4987d4, 0x3fd0983845e14a00,
    0x3ffbf10c3073f435, 0xc00a28e6259f5b3a,
    0x3fe118cf8d44909e, 0x4001c6425cb669c2,
    0x3fe0cc5cb18a0299, 0x3fec4fca35449488,
    0x400730c9a6a381af, 0x3ff6543d09063298,
    0x3f9ddb88acfc36b0, 0x3ffe1b384eb72ef4,
    0xbff4e162fc24f757, 0xbfca125d759c7594,
    0x3fe4b4e244c8f600, 0x3ff08474e21864c6,
    0xbffa2e3e0df7972c, 0x3fe5acf0debf8d27,
    0xbfec334e62ce2446, 0x400975d84cdab7d3,
    0x3fab4cbd947e8098, 0x400f7a6aacec0300,
    0x3ff17c1061215fdc, 0x3fe367be0de2a41c,
    0xbfc7e0ae4f92a500, 0x3ffd75654ec75844,
    0x3ff622bf9db44527, 0x3fd0c646647d5f4a,
    0xbff7a796b0b511ca, 0x3fe123473b423d04,
    0x4005be48b8122141, 0x3febcd4b733025dc,
    0x3ff2aea1c007e932, 0x3feeedcb36e983a4,
    0xc009b8ab885cacff, 0xbfcfbd5c96986f4a,
    0xbffac4b8faf3700c, 0x3ff3fcd2b4920234,
    0x4005f0a610869850, 0x3ff5b0a44c842291,
    0xbfd05c8569ff6686, 0x3ffa89d7b0a2b4e9,
    0x400102cbb5454043, 0xbffec057e6945f43,
    0x3ffc60d1b968ae28, 0x3ff189bed5f8f87f,
    0x3fd3b0ab7cf27400, 0xbfc03854840b2024,
    0xbff5ca4a71bf60fe, 0x3fd60f646633a34c,
    0x3fe93f7e8d7f57a5, 0xbfffd5cb45bc95da,
    0xbf99d2d7f2d009e0, 0xbfcbb5bb080de0f8,
    0xbfee7df494405d11, 0xc0021df316b881d4,
    0x3fed4fa5211c9ca4, 0xbfb38473a0d81b90,
    0xbfe1e4b1e5e12630, 0x3fb02cc96a702e00,
    0x4006b02ee2babb22, 0xbff5da182ec26cde,
    0xbff5b3e98cb29aae, 0x3fe957fced062f35,
    0xbfe36ce9d3468b10, 0x3fe34144fbdeb825,
    0xbff362f8fc302a65, 0xbff2eb74e95ccbb1,
    0xbff8dca0151e4575, 0x3ff3520648731ad7,
    0xbfa14288a51a55f8, 0x40004ff0b604e358,
    0xbffa9ff8701e2d98, 0x3fee78d0e6c3d8f7,
    0x3fd9b7e3e25d8ec4, 0x3fb9a45ce4dbbdf0,
    0xbfe4704bcf0c5a3e, 0x3fb8d54081c94458,
    0xc00e125934a59888, 0xbff52ce03c3dcdb7,
    0xbfe9351abd5427e0, 0xbfd3b58e16287271,
    0x3ff8cd0d5d165d7b, 0xbffd463edfd0901f,
    0x400557fc3183a130, 0xbfe62c46c611ff3a,
    0x3ff07fa3e0039d16, 0x3fe061e84bd179c6,
    0xc009e206bfb8aa75, 0xc003dd7aca3a9932,
    0x3fe921aa030acdb9, 0x4006f3c5080f672f,
    0x3fc6582c70baabca, 0xc003641c4040b8ef,
    0x3fc1ebe080c0c7f8, 0xbfeeac53e5d67514,
    0x4010c9e7b229f01a, 0x3ff472569ba88661,
    0xbffa6ab45a1bac2f, 0x40045183301f2de0,
    0xbfd33a2f95721c20, 0xbff943a78b7a8116,
    0xbff97c936aefde8c, 0x3fb718020fde58d0,
    0x40031a84b5f992c5, 0xbff3a3e46a632335,
    0x400bf10a2ba0ad0c, 0x400d17481c7e8b00,
    0x3fb3345fef43d02c, 0x3feb61388bcd3ed1,
    0xbff1ee541f8767ac, 0xbffb3011ee3b2cbc,
    0x4013b6fc15c4479e, 0xbfee286cbf9c2234,
    0x3ffd389dac704680, 0x4011793afe53305b,
    0x400337acb3aec66f, 0xbffffc968070014a,
    0x3fde4300811466d8, 0x3ff9a33f62b7faaa,
    0xc004942284f6ded9, 0x3fb3006ffd27c794,
    0xbfe17adbf18a225c, 0x3fe761ad9f75fd9a,
    0x3fef0d14e994e6f4, 0xc003e2439e701507,
    0x3ff7b75e6c044dd5, 0xbff1fe1147ca6285,
    0x3fe990c8497caa9c, 0xbfd03bff2242f148,
    0x3fec04a2059f41c6, 0xbfe357b3912b2540,
    0x3fe467e1fd288627, 0x3f9f7f3628d6a500,
    0xc00a7f4f09771832, 0x40004a90943d9a87,
    0xc003e2ac85392f15, 0xbff6acd58534994b,
    0xc0082bfc51d24795, 0xc0076144e7e59ab8,
    0xbfeacb3fcf8aa108, 0x3ff2a5275c3d18c6,
    0xbfdff2fdc04d03fe, 0x3fdf6e3fa658139b,
    0x3ffb047d29fcddb8, 0xbfd534d11505cda8,
    0x3fe7b5472a6b2299, 0xbfcb872aee0d88a4,
    0x3ffbca576de963dc, 0xbfdb5620013aa177,
    0x40069ab52a27ec17, 0xbff21c8cc14acabb,
    0x3ff5a9c01a3c7aa2, 0x400db1d7ba1a5793,
    0xbf8e85b15555de80, 0xbffe472f06ae94d0,
    0xbff4d81b3e3859b0, 0x3fc5d91ed4e1dbc0,
    0xbff59269fe687cb6, 0xbff42a588150bf96,
    0xc00857776ae9ea0e, 0x3fe04d7f1ac64b77,
    0xc0042bf02d4d3904, 0x3fe0c9e2258e3688,
    0x3febdb18039a3cf2, 0xc006be1c9e04e8e9,
    0x3ff28d411e6d45bf, 0x3fe11d2ed6a5cc30,
    0xc0037795f9b41d28, 0xbfd0d046a8a8d7ee,
    0xbfffce465c8de820, 0x4086621cae230b0c,
    0x3ffe0b5daab47d72, 0x3fe6d36a603fd804,
    0x4001dffe1c59d123, 0x3ff2305251c9ecbc,
    0x3fdaf7aee5862a6e, 0xc0012e68151a5f60,
    0xbfdd98bac67b6b82, 0x3ff645930f0bbeb4,
    0xbfa661978edd76a0, 0xbfec7790abf20782,
    0x3fe620f7d0fc1401, 0xc00b23b69a42408d,
    0x4005619dad723b58, 0xbff30a04d646eb0c,
    0xbfe1e74d77333586, 0xc0087b3a19c0165a,
    0xbffe8a6e7b1d151a, 0x3fbc61c5167118c8,
    0xbff7e71e6c24f0b7, 0xbf9d25db2bc8af30,
    0x3fd96b5618c90ec8, 0x4003942694973510,
    0xbfd9ab2aa494c7b8, 0x3fd7985ae4bc8ffd,
    0xc005dbfe4783c5b3, 0x3ff6b9961274a784,
    0xbfd62c756c442c30, 0x40027146c6295a3c,
    0xc003ad51007a736c, 0x3fdc53f1afc2dcd0,
    0xbff12f2589adeb1e, 0x3faf5c1e22e8e720,
    0xbfe35fe1ff2ce458, 0x3ff7769b8269da86,
    0xbff66b95f9cbf55e, 0x400c996483216157,
    0xbfe0cbabeb6c446c, 0xbff7b1f615afa2ce,
    0xbfe073582b16b680, 0x3ff959844fb176ac,
    0xbfcb915790f1b618, 0x3fb0ed2df566d390,
    0x3fc865ede0e9c1ea, 0xc000fde17c24d0d7,
    0xbfd2c870de880dc4, 0x3ff7826a23cb0d34,
    0xbffc600ec6844a22, 0xbfe2a5f99021ca2c,
    0x3fe97c0e8661ce62, 0xbfdde3d7aa92ef54,
    0x3f88f01af0989a80, 0xbfca85ca9c328982,
    0x4006f3d8b3627e47, 0x3fed97e13053dd00,
    0x3fb4f258920201cc, 0x3ff8dfd9646f55dd,
    0x40007f6831d81ab4, 0x400271f35facb3cb,
    0xbfe838e529e37346, 0xbfe6164120def89d,
    0x3ffc2b2c7b92db86, 0x400151a578c0e829,
    0x3fe986a9138bfa1e, 0xbffd0a0e5bf0ed00,
    0x3ff17906b5cba5ba, 0xbff93186f852e753,
    0x4003b6aa097c96e2, 0x4010b6d5e65c2877,
    0x3ffe8948605b336a, 0xbfeac4a0d0d7c591,
    0xbffde1a26a1add7f, 0xbfe47bac3a5d286e,
    0x3ffeed27851cd33d, 0xbfe0fa9a8152846b,
    0x3fdca5759f4fa36e, 0x3fe2f23e0b7ccdfc,
    0x3f8577f11abaa880, 0xbfee591e9dc10486,
    0x3fd89081d55f62f8, 0x3ff2dd62a22a4eb7,
    0x3ff9dc27e4266b51, 0xbfcb4b199b117128,
    0xbfdf4f493e22ef27, 0xbff3f69a47e2fb48,
    0x3ff0ea46f1da6f12, 0x3ff47b2bf9ae6c54,
    0x3fb7206362ba07c4, 0xbfe118b4bbf5516e,
    0x3fec3d011facd0ca, 0xbfe27fceeb62cf80,
    0x3ffd3fada454a135, 0xbfc5187ab3a72190,
    0x3fe8b4c1c3894f51, 0xbfeaeccee41e8ba2,
    0xbfe18e081cf810b8, 0xbff80f2861b8bd39,
    0xc002ca5c8f72c5de, 0xbffe63642ba866c9,
    0x3ffb2ac066c23edc, 0x4001a973d60d1e6e,
    0xbfe360a4c340e779, 0xbff38f053d64bcae,
    0x40084c40c8f6b450, 0xbffb3b78bc6646f3,
    0x3ffd9941789ae995, 0x3fefd79f29facfb6,
    0xc0051ccd5fc9db44, 0xc002501eb3016957,
    0x3fc3f9e3fa1b9bf8, 0xbff432fcb5dff038,
    0xbfce8984d023c3b0, 0xbfe533c599f5af25,
    0xbfe1df3a8bfc5404, 0x3fc0422b7dc147d2,
    0x3ff597e88d972138, 0x3fe1ae9c8ca19e43,
    0x3fd94da0d40764af, 0xc00ee894d3ab53ba,
    0x3feed18c4ab3c3a0, 0x3fc0858e06bd0339,
    0xbff253f5b1e7c8ae, 0x3fec09d8f5c6529a,
    0x3fedf6bdd4010cd8, 0xbfce38697fc2a44e,
    0x3ffbb22d036d648d, 0xbf8223465f675f60,
    0xc00f7db9db26c24e, 0xbff1443b2bb146ba,
    0xbfa91e50dd521344, 0x3fc2d673d0f9a714,
    0x4000acc75125dfb5, 0x400a0946ea11a4dc,
    0x3ff19dd78fe14ba4, 0x4000e77ebdaaba68,
    0x3ff97b2dab0417cf, 0xbff15b7e6dfd18a6,
    0xbff8e109c24d23ad, 0xbfe20c70bb2c27cc,
    0xbfecc890111a8142, 0x4000cb914ebc5066,
    0x40074f7b75c7bfb6, 0x3fe5028a79314782,
    0x3fe838735c6fbe32, 0x3ffcf1486c6aed44,
    0xbff1e14dfe9fbcb2, 0xbfef513443c10e7c,
    0xbff243d4da38e2d6, 0xbfd01c8d5f8f88c8,
    0x40042f8a4da3bb09, 0x3ff68bda0aaa9d22,
    0x3fe3bea5bcff86fd, 0xc010a472dbb92297,
    0xbfe48fdca90cbd10, 0x3ffc1b7d58a5c560,
    0xbffbe4b82c536f86, 0xbfddf37dfd98c8c8,
    0x3ffd9aa4ffafc0e4, 0x3ffd8121246479a0,
    0xbffdbdecabf7a534, 0xbfcb2a4e69036df4,
    0x3fed9e0c3c4c8a9e, 0x3ffcbba670d7ebcd,
    0xbfb95d96496c5fd4, 0x3ff10e053ff64239,
    0xc006ad1d01e7223e, 0x3ffa4be46d0af6ea,
    0xbf846d3194905b00, 0xbfe2f390fa98c8cd,
    0x3ff3f4416d184472, 0x3fe00d53e22e3aa4,
    0xbfd2b973346c10e6, 0xbffe9213f73f8619,
    0xc00129cc41119068, 0xbfde4b35c84ac0e2,
    0xbfe7c056b6747202, 0x3fffecefe14bb756,
    0x3ff463fa5e323aba, 0xbfe9a01f0aa8cfee,
    0xc0047e419f0a2420, 0xbfe997d2a93d26fc,
    0xbffb7c6cebbf8618, 0xc000e97288291f19,
    0x3fe15ddc0f1cdd00, 0x3fd4352fa1b340b6,
    0x3fcd79d5fbf2f1d8, 0xbfe2b118c3bf6264,
    0x40104d4ad8774026, 0x3ffe1fef24e81993,
    0xbffd1f4a6753c870, 0xbfaa942f396eeb90,
    0x3fc485345f071e08, 0x3ff3240067240cf5,
    0xbf8f60445994afe0, 0xbff800dc2c1c0fb6,
    0x4003393e1147695f, 0x3fdf4b3a175ef3ba,
    0x3fd7c4c60583e4b5, 0xbff3864fffc7f032,
    0x3fce0d28a2313658, 0xbff90944a5d50e68,
    0xbfe1591f88eee6c9, 0x3fe1f5368db5abb2,
    0x3ff6ad40188280ca, 0xbff0ce28ff1004ed,
    0x3fbffdf985bd7a10, 0x3fd8a2457883a567,
    0xbfe3563d8819c577, 0xc00400d28df6aca2,
    0x3fd936823feb831a, 0xbfea5a9ead5640e2,
    0xbfcc840e835fc96a, 0x3fd656a844f6f169,
    0x4004ba150c515f92, 0x3ff47acf9766b55a,
    0x3fc0db329ebf650b, 0x3ff4e7a17653b253,
    0xbff03b4805860b02, 0xbf79555f8c563d80,
    0x3febcd43d77e37e4, 0xbfe5955f49312258,
    0xbfe703c159c8aeb2, 0xbff0a20624d18af1,
    0x3fb4a9e1723fe9f8, 0xbfe0759ccec3606d,
    0xbfccdddb7f111324, 0xbfd2cb426f1f9bd0,
    0x3ff23db602edeeae, 0x3fc7de24430462ba,
    0xbff9467b12e9f771, 0xbff6beb4c5ffda16,
    0xc00133f971cc443c, 0x3fe29278029f87d8,
    0x3fe07266263c056a, 0x3ffdb5469e21d0e9,
    0xbffb2a246eb0345d, 0xbfefa5f417ffb6e2,
    0x40037bab81fce328, 0x3fa442ac08005a3c,
    0x3ff386e8eef53ad7, 0x3fb3d4c543f709b0,
    0xbfcd6ea2396871c6, 0x3fe6cd5bf5d91f26,
    0x3ffb0ab2f9197d38, 0xbf94c17af06bfae0,
    0x3feb4003f67edd84, 0x3ff0087085aa1175,
    0x3ff9380bfcd71963, 0xbff6c30f1b840908,
    0xc004afc05faec746, 0xbfce26efaae86406,
    0x3fe936b9d8ca33ef, 0x40012a6e064adcd2,
    0xbff2f93bd90782fe, 0x3ff516b50b48c38f,
    0xc00a51198dae5a7b, 0x3fb83e8b50345204,
    0x3ff0b8494dda2541, 0xbfd87d6d817b9db8,
    0x3ff61cf1a60228d7, 0xc00e8ac97c1b9d84,
    0xbfeb1d3b2ace8829, 0xbffcacf0c2045b3e,
    0xc004495aa3e38364, 0xbfcd812a15d35c9e,
    0xc0001d38534a32b4, 0xbff1a53669dd47bf,
    0x4009e867dc59331f, 0xbfc27892d70137a0,
    0xc00245070f87526a, 0xbffee30fbb8d45ae,
    0xc001c081644b467b, 0x3ff0bded14d0ba10,
    0x3fd1ce394bf58444, 0x3feb28f40930ac77,
    0xbfe5567d02d127a5, 0x400b94dbdb6a8300,
    0xbfc70dc336a7547c, 0x3fe8721a9745bf24,
    0xbff3f5cd6c33a780, 0xbff4f1bc7b399364,
    0xbfe9a102c9001bf9, 0x400401d7c6f2ab36,
    0x3fec613988b5e026, 0x3ffaff23c0d6c287,
    0x3fc89f0bf231f198, 0x3ff289403170e950,
    0xc004f15568c73a29, 0xbfee51fb363c7b04,
    0xc003461de256e344, 0x3fcdf031078e1d74,
    0x3ffdf25ed88f7ea9, 0xbffb165402eb70ec,
    0xbfde4a10adb0bb66, 0xbfef2065f7efd61d,
    0xbff01c598c7faae1, 0x3ff29fbc40c75218,
    0xc00e4b194e5008fb, 0x4004e247b6473130,
    0xbff63bc625d5644a, 0xbff0c5319c16f3c1,
    0x3fe71c12a56822ca, 0xbff45a6169c45d63,
    0xbfd4851bdf2ec2d6, 0x3ff88fd56c029602,
    0xc0000a534a180191, 0xbff033ddd6289516,
    0xc0057cb01d728d02, 0x3fe44c364cfab8de,
    0xbffe7108edcab12c, 0x3fca912df09b47c2,
    0x3fd40368d4dfd970, 0x3fc3795cdfec1aec,
    0x3fc3bff64bdb6328, 0xbffa510fc8a12928,
    0x3fe728042b64fb93, 0x3ff5fefab832dd44,
    0x3fda0e27b9ee5684, 0xbfe9bab37b7feb5a,
    0xc00aca0d80570f40, 0x4008bb7050a5419e,
    0xbfdc98032bf4de90, 0xbfd20d3fafe1041c,
    0xbfce9f6b2c0437fa, 0x3ff62e39e342ce3f,
    0xbffb9ff4e88027b5, 0xbfd4ca1c0fbaa96e,
    0xbfb6f292b765595e, 0x3fe3ba3ad00a68aa,
    0xc00505f301ee5aed, 0xbfe8e45dfd6a988b,
    0x400a087f923deb1b, 0x40058e70c237bd98,
    0x40045c2c0cd00bb6, 0x3fe16fdf624a301d,
    0xbfe76630bd1d4a28, 0xbff88c29d4e63e55,
    0xbfb28cc0d36a29f8, 0xbfc10e55202a5fa0,
    0xbfbfe6416ead3370, 0xbff5a513bab042d2,
    0xbff3a974ee2f6a4d, 0x3fccd4ff2f86d7e4,
    0xbfe0241ba149f488, 0xbff3bf68270034a1,
    0xc011cdae691ee318, 0x3ffebd7e503beffe,
    0xbff25cb3d1c78730, 0x3ff470b0c1f2a239,
    0xbfcafe088bbea8e5, 0xbfa896c3b6636508,
    0x3ff0afcc77d0d398, 0x3fd91663d9997812,
    0xbfeb4823cf3179b0, 0xbff0e7ad8ab45e41,
    0x3fe1ea3621bb7d4b, 0xbfeb141ba4b9355b,
    0xbfeea7a01f64797f, 0x40026710d01462a0,
    0xbfeca4cf15ba45fa, 0x3fad18d529a02c60,
    0x3ff0053a3eeb0d98, 0xbfff7feaf5e0d186,
    0x3fdb8c2f79db80c4, 0xbffcb23b538a05fa,
    0xbfdb1979d829d544, 0xbfe5a640e34360da,
    0x400210c83f1f62e0, 0xbf93753362cf1140,
    0x3fc21738b5b8a71c, 0x3ffd4320edc71cb6,
    0x3fa6868705e5a658, 0xc00647ee3b8e0765,
    0x3ffc2daea60678a9, 0xbf9d1daf4fac3740,
    0xbfebf46a28ba0fe4, 0xbffa793ff22a8c34,
    0x3ffcf52564179639, 0x3fee9dfb6929418a,
    0x3fef72b9e48c8529, 0xbff6fb233462ca21,
    0x3fed079149ef8a34, 0x3fd1eb64a0b58424,
    0xbfe6dc4a5ab95df5, 0x3ffca0d8a9b193fc,
    0xbff64e5dc707944c, 0x3fdc0fa57dc258ed,
    0xbfeb5506558e6ed0, 0xbffa2095cf4bb628,
    0x400602740152b75e, 0x3fda44d68ac65d84,
    0x3ff13430695c3771, 0x3ff3532b30c70ee6,
    0x3ffe1c205496763c, 0x3ff16241400ce112,
    0xbff355e0c2ca12fe, 0x3fee95b0e50bc530,
    0x3ff63b1fb9ccf31f, 0xbff3459bf4ab309a,
    0xbffcf628e1987198, 0xbff87d89bdffbbcc,
    0xbffd1336570d1f74, 0x3ff117457a47b932,
    0xbfaa056c68490fd8, 0xbff7997c377567d0,
    0x3fb221246b2dc3f2, 0x3fe6637991ff0eac,
    0x3fe78a4592911e14, 0x3fd04a7f93baac28,
    0xbfde97b6a990c05d, 0xbfb301d1d1321a40,
    0x3fcfb7c54e2ef76c, 0xbff9d076e7aedaa8,
    0x3fee62e257314ce9, 0xbfa9a029bbf36930,
    0xbffef7746bf1646f, 0xbfe70587f0a08a4d,
    0xbfeb44e313591f14, 0xbfd7ba5ef648b16c,
    0x3ff07aac3a8ec39a, 0xc00bdc0fa9e02c7b,
    0xbfa74d051fa42180, 0x3ffab532c9e3e569,
    0xbfe4abec04b9acd3, 0xbfeb21fd0c5ecfaa,
    0x3ff3007f4c6392c6, 0x3fe8ee44567e4636,
    0x3fd2a2c8fabc3162, 0x3ff6bcb1cbf737f7,
    0xc0011af4c7efde71, 0xbfec7cbf1c22dc40,
    0x400309d0ae39c9a2, 0x3fe668249462f12b,
    0x3f80a43ac76c8fc0, 0xbfda7d94e91edcd4,
    0x3ffb332a33646f9f, 0xbfd43efda14d9a10,
    0x3fc0e4cf0f1a4dd8, 0xc003f260cdc08a03,
    0x3fdaff8b21232b41, 0xbfeafe69312f0769,
    0xbfdcd4951085cb5c, 0xbfe79dd387dc3848,
    0xc002937a3e89e99e, 0x3ff5a5bbb07b002a,
    0x3ff7c0a0b3439415, 0x4002ad9721dc769c,
    0x3fe839cec18adc12, 0x3ff54e236f330b9e,
    0x3febd35ab23f65ca, 0x3fe9f691be2032eb,
    0x3fad9b49a8e91220, 0xbfea247433657a78,
    0x3fedec5758a295f9, 0xbffe1853295d6558,
    0x3fc19810c1fa7fce, 0x3ffb9e93deb2cac6,
    0xbfd224bee7df1d02, 0x3fb5fe8bcfaba704,
    0x3ffccdb481f780d2, 0xbff1c88fcb2937fb,
    0x3fe3f63a38e3ad40, 0x3fd25903e6ea1fbe,
    0xc005fd2c3157892c, 0x3ff5d7e8a106316e,
    0x3ff5cbec53ded740, 0xbff405d45594aa6a,
    0xc004362302515ed5, 0x3fe2b343ca7af200,
    0x4002546c566895c2, 0xc003a095ec899fe2,
    0xbfffb134ac8a1b50, 0x4002c348637c230e,
    0x3fe70605098af7cd, 0xbff4d87e13924b07,
    0xbfc734a6f14a3670, 0x4005ec1c346671fa,
    0xbff8f935ff080dc5, 0x3ff74a3124482dae,
    0xbfab455502c691e0, 0xc00bfa74f904fbd2,
    0x3fd5b6855050a7f7, 0x3ffbb51bff7732f8,
    0x3fa1c007ccc25fb0, 0x3ff5b2f5e5069eed,
    0xbfe3239f4201afae, 0xbff1de57ffa1449b,
    0xbfeb9ae4edb826da, 0xbfab136a46ab71e0,
    0x3ff390abe9290e7e, 0xc00981bc3644505f,
    0x400613c19ee0290e, 0x400f21c030f929f8,
    0x3ffad0eda14837a7, 0xbfdf7e92fc4015a8,
    0x3fe629e38f190220, 0xbfef0969585a66c4,
    0xc0020ad2d063117e, 0x3fe7f44595a35671,
    0x3feaab07751eec7e, 0xbfd533df19f6eff0,
    0xc009fc5bc8cb6ed2, 0xbfe8f5336e6e1d5a,
    0xbfd73590c05d3316, 0xc00427513e5ef83a,
    0xbfe7e6857b0d996f, 0x3fe87cb9b7ca31db,
    0xbfefaa3877d737c7, 0xbfe598fc4ba3c252,
    0x3fd1a1e3e4be0fe4, 0xbfb71ddb3c79e1a0
    };

static const uint64_t in_cfft_noisy_4096[8192] = {
    0xbfa16737c10e70f9, 0x0,
    0x3fe0d611cf699e7f, 0x0,
    0x3fe6379e9581f3ea, 0x0,
    0x3fdccf3d6f8a8a53, 0x0,
    0x3f9ac16e24dbab85, 0x0,
    0xbfe14c792b03107e, 0x0,
    0xbfe6bb6cf964a41d, 0x0,
    0xbfe2cd2d308d8c75, 0x0,
    0xbfb8a871f217bf95, 0x0,
    0x3fdf46a6ca033221, 0x0,
    0x3fe65eb00e261bc0, 0x0,
    0x3fdf788482e37f49, 0x0,
    0x3f874bad312e42f2, 0x0,
    0xbfe049989a969713, 0x0,
    0xbfe29166bafd4591, 0x0,
    0xbfe305d4e441dd06, 0x0,
    0x3f82e1f680efde33, 0x0,
    0x3fe12807667f16fc, 0x0,
    0x3fe5c55ce03458b3, 0x0,
    0x3fe1fc3a75d19512, 0x0,
    0xbf8d715549287078, 0x0,
    0xbfdd8454287e38ca, 0x0,
    0xbfe71efb1d0425fc, 0x0,
    0xbfe0cf6289f18fec, 0x0,
    0xbfa3753b73fa7fb2, 0x0,
    0x3fdf6d56d96eb9d1, 0x0,
    0x3fe73910287a83de, 0x0,
    0x3fe0da9ea6fce1a4, 0x0,
    0x3fa8d20c170de3f2, 0x0,
    0xbfdf23f4ba82535f, 0x0,
    0xbfe69397f72c814f, 0x0,
    0xbfe00ac70d3546a9, 0x0,
    0x3fbd5284b6654f2c, 0x0,
    0x3fe0418cab237906, 0x0,
    0x3fe4cf0281fe8a22, 0x0,
    0x3fe1f959506270fb, 0x0,
    0xbfa3452b36d78351, 0x0,
    0xbfdf2de49b5d9253, 0x0,
    0xbfe62db4d8eeb203, 0x0,
    0xbfddb44f6507ceb9, 0x0,
    0x3f56d505d5861eda, 0x0,
    0x3fdd6e03b497afde, 0x0,
    0x3fe2ceb067d0cd38, 0x0,
    0x3fdb055b3ce79d0b, 0x0,
    0x3fa0f88c9585ce9c, 0x0,
    0xbfe13bfdab02d0cc, 0x0,
    0xbfe4f4e1ce857f7a, 0x0,
    0xbfdfca37bbe5375f, 0x0,
    0xbfb4e376a7ef5009, 0x0,
    0x3fe137a6dae12e94, 0x0,
    0x3fe5bd62cf89e753, 0x0,
    0x3fdf843d19e57ace, 0x0,
    0xbf8152b5e6c9dd62, 0x0,
    0xbfe1e533c72f1604, 0x0,
    0xbfe6eecf69baac0c, 0x0,
    0xbfde8f0f67baa1e6, 0x0,
    0x3fb4c5c2e49df786, 0x0,
    0x3fdea44e25ab470d, 0x0,
    0x3fe6c5d2da3ce073, 0x0,
    0x3fdf35c7cf76116b, 0x0,
    0xbf9e0a055aa721d3, 0x0,
    0xbfdbd7eb00c3c8b0, 0x0,
    0xbfe7e200390d898c, 0x0,
    0xbfe0a6eab2b55b27, 0x0,
    0xbf8d0fec5a11f994, 0x0,
    0x3fe0ddda2083798d, 0x0,
    0x3fe717e18e8f1bb4, 0x0,
    0x3fe24a8e30121fb0, 0x0,
    0xbfa5056d966f474f, 0x0,
    0xbfe08f4cdbd4f466, 0x0,
    0xbfe633696aa435d7, 0x0,
    0xbfe174036e3927db, 0x0,
    0x3f84a73aa1588e13, 0x0,
    0x3fe00c0f3919c992, 0x0,
    0x3fe7e2f35d7d24ec, 0x0,
    0x3fdec219a71bf34d, 0x0,
    0xbfc389ee711ffb30, 0x0,
    0xbfe0a0bc2a910325, 0x0,
    0xbfe762bd06d41509, 0x0,
    0xbfdf8774811e8960, 0x0,
    0xbfa1a20b00a47316, 0x0,
    0x3fe0ed712652258f, 0x0,
    0x3fe724cae2a58766, 0x0,
    0x3fe102346b32fef4, 0x0,
    0x3f983ea8f4d9bfea, 0x0,
    0xbfe130cee15f447d, 0x0,
    0xbfe7823c76caacea, 0x0,
    0xbfdef6aacba8f177, 0x0,
    0xbfbe90b8ca9d345d, 0x0,
    0x3fe05c05957b549e, 0x0,
    0x3fe68dcc8599f3f3, 0x0,
    0x3fe313fa37e35fa0, 0x0,
    0xbfb3a44b80ee5097, 0x0,
    0xbfdcd20bcf7a4a86, 0x0,
    0xbfe5804080dfcbfe, 0x0,
    0xbfe04cb64a37cf19, 0x0,
    0xbfac0f642899e1c3, 0x0,
    0x3fdcf2910ac83cc6, 0x0,
    0x3fe461cf08601ed0, 0x0,
    0x3fdc6dcc4ea5ca00, 0x0,
    0xbf899c28467f1900, 0x0,
    0xbfda74d671f9c113, 0x0,
    0xbfe69e1272bf737c, 0x0,
    0xbfddd03ff6295e80, 0x0,
    0xbf91d2139ac45374, 0x0,
    0x3fdf3605ebe8b19a, 0x0,
    0x3fe5eb4938db11d3, 0x0,
    0x3fdb93ca87c05b34, 0x0,
    0x3f9d1b78f344383d, 0x0,
    0xbfdf53d50dc455aa, 0x0,
    0xbfe82ab4f5f7f8ea, 0x0,
    0xbfe12b099879055d, 0x0,
    0x3f908afcea6ea543, 0x0,
    0x3fd9e88e33ea9118, 0x0,
    0x3fe824158f20e658, 0x0,
    0x3fe10b23e09173e2, 0x0,
    0xbfbbdd64f712bbdd, 0x0,
    0xbfddbde798c07d82, 0x0,
    0xbfe54d39d1d63977, 0x0,
    0xbfe1dc65fda40dd5, 0x0,
    0xbfb7ccb9e63d7251, 0x0,
    0x3fddbc07482dbe39, 0x0,
    0x3fe4d0b852be5500, 0x0,
    0x3fe17a4dd80dab9f, 0x0,
    0xbf96e3adab036f2a, 0x0,
    0xbfdb5263182b1075, 0x0,
    0xbfe594e328cd8131, 0x0,
    0xbfe0cc0a6bd48314, 0x0,
    0x3f9b2c712237aa4e, 0x0,
    0x3fe23fc72f1a5c94, 0x0,
    0x3fe62223b7a62c2a, 0x0,
    0x3fdf3db7fe04911e, 0x0,
    0xbf87ecb1159980c7, 0x0,
    0xbfdcf2899ab92420, 0x0,
    0xbfe670dabcdf5e0b, 0x0,
    0xbfd9b44cbf0b4d04, 0x0,
    0x3faab35f1de68d15, 0x0,
    0x3fdc081fe06e6f65, 0x0,
    0x3fe87fb1498c0fcc, 0x0,
    0x3fda20885253d277, 0x0,
    0xbf9099464012022a, 0x0,
    0xbfe24a4188c0cbe0, 0x0,
    0xbfe644ab2e11c07a, 0x0,
    0xbfde5113117ff73b, 0x0,
    0xbf42facaaf9fd993, 0x0,
    0x3fe02c0c3a52f549, 0x0,
    0x3fe7a218c4783911, 0x0,
    0x3fdedd22dacdaab1, 0x0,
    0x3fa8c3bda0deb8fa, 0x0,
    0xbfd7e9e8350b0d52, 0x0,
    0xbfe82ee6f43af112, 0x0,
    0xbfdf0584524af66c, 0x0,
    0xbfaa84be8b4eea77, 0x0,
    0x3fe32d12a3d09177, 0x0,
    0x3fe5b6ba7f8e3c59, 0x0,
    0x3fe12af4caae6468, 0x0,
    0xbf8b10c25f554fe4, 0x0,
    0xbfe09c731dd128bf, 0x0,
    0xbfe5a94461bdeae6, 0x0,
    0xbfdcbec5f9112625, 0x0,
    0xbfa7405855d16a26, 0x0,
    0x3fe11bcfd0240e97, 0x0,
    0x3fe8fe4a63a5b181, 0x0,
    0x3fde52324424f745, 0x0,
    0xbf934d070da6149b, 0x0,
    0xbfde571ea932df6f, 0x0,
    0xbfe49f2c0f2593c7, 0x0,
    0xbfdab87cfac69ab6, 0x0,
    0xbfb265ceaa4e216f, 0x0,
    0x3fdd5a575d14ec83, 0x0,
    0x3fe5075e67266328, 0x0,
    0x3fe12f2f96d917f6, 0x0,
    0xbf8a041e35a939a5, 0x0,
    0xbfdb13ad6b326360, 0x0,
    0xbfe58f1dfb70311f, 0x0,
    0xbfe085b5211d1400, 0x0,
    0x3fc27fb7a55132a5, 0x0,
    0x3fdd415b1e8657ab, 0x0,
    0x3fe2e01ab5be5438, 0x0,
    0x3fe28b8576de18ef, 0x0,
    0xbf67ec7b3bdc0ab2, 0x0,
    0xbfe0bd07ef8f3282, 0x0,
    0xbfe7f7d1997380b9, 0x0,
    0xbfdaded193278f2b, 0x0,
    0x3fa050e3126990ea, 0x0,
    0x3fdcc108b32c9c37, 0x0,
    0x3fe7a0997379d45c, 0x0,
    0x3fe03abf8ce34416, 0x0,
    0xbfa164389af39232, 0x0,
    0xbfdf213610009fc8, 0x0,
    0xbfe3376262820415, 0x0,
    0xbfdf4ac14895ecee, 0x0,
    0xbfb43dbd98055040, 0x0,
    0x3fdd67537c50d71c, 0x0,
    0x3fe56e4f422f2361, 0x0,
    0x3fe047203b7f73f9, 0x0,
    0xbfa531116671bd43, 0x0,
    0xbfdeba16f830c7f2, 0x0,
    0xbfe5e6bb75a2ed16, 0x0,
    0xbfd94f60d8574ebc, 0x0,
    0xbfb06007ec3023f3, 0x0,
    0x3fd9e734b2cb0a33, 0x0,
    0x3fe778d32b50fd4d, 0x0,
    0x3fddd04d33a6f092, 0x0,
    0xbfa5f2f8cabecef7, 0x0,
    0xbfda158531501a10, 0x0,
    0xbfe837e61ddc6e74, 0x0,
    0xbfe03196ee4109ef, 0x0,
    0x3fac84781d3e09f9, 0x0,
    0x3fdf0611ac1a1e49, 0x0,
    0x3fe83bd1a97f0d5a, 0x0,
    0x3fdc192d75fd3ea4, 0x0,
    0x3f8e13dacdc2524e, 0x0,
    0xbfde3785f52fbc40, 0x0,
    0xbfe5fc1af5634ac6, 0x0,
    0xbfddef2ceec324c2, 0x0,
    0x3f8a2d02c418a08f, 0x0,
    0x3fdb062ad555192f, 0x0,
    0x3fe660d88df3466a, 0x0,
    0x3fe0db5d0696e266, 0x0,
    0x3f70c4445b0645d5, 0x0,
    0xbfe08a47d7fab377, 0x0,
    0xbfe319ef0de393ea, 0x0,
    0xbfdc22d18b78b4c2, 0x0,
    0x3fa7ecf4784eab85, 0x0,
    0x3fe1ab48d1bc269d, 0x0,
    0x3fe884173a52bb51, 0x0,
    0x3fe127b13ea36d78, 0x0,
    0xbf9fa49a91bae5c6, 0x0,
    0xbfe03f1d501c4c6c, 0x0,
    0xbfe712ef7228f95b, 0x0,
    0xbfddbef5f6770bde, 0x0,
    0xbfbb362651911e7f, 0x0,
    0x3fe03740548b8f6d, 0x0,
    0x3fe5fc7c39d53242, 0x0,
    0x3fe098a8ba695bbd, 0x0,
    0xbf368169cc76f367, 0x0,
    0xbfdbf120efc48679, 0x0,
    0xbfe6ddc3f2369f02, 0x0,
    0xbfe00829a31f309b, 0x0,
    0xbf909b1b1b178f00, 0x0,
    0x3fdce6ee21e33229, 0x0,
    0x3fe436f47bbe487f, 0x0,
    0x3fde19878859b3a5, 0x0,
    0x3f7b43b5ed26f087, 0x0,
    0xbfdba1bcd59ca5f9, 0x0,
    0xbfe5f23c306b4645, 0x0,
    0xbfdf180bf8ff64ac, 0x0,
    0xbf8909a47bb5a5d8, 0x0,
    0x3fdee9f5fd2b4921, 0x0,
    0x3fe579262de0834b, 0x0,
    0x3fde42d117a25cf0, 0x0,
    0xbfa75390339f2dda, 0x0,
    0xbfe01004f401549a, 0x0,
    0xbfe7b44eff9c514d, 0x0,
    0xbfde75e8c6af61d7, 0x0,
    0x3fbd684a837526f7, 0x0,
    0x3fdcb623e213949b, 0x0,
    0x3fe43e23f575c7ac, 0x0,
    0x3fdfc0dd2615e3e0, 0x0,
    0x3fa017593c55cbd9, 0x0,
    0xbfe060f130b85359, 0x0,
    0xbfe794352e571814, 0x0,
    0xbfe27216333c5711, 0x0,
    0xbf708080d23baade, 0x0,
    0x3fdc92f212101726, 0x0,
    0x3fe59a3f3e8bd536, 0x0,
    0x3fe04afb0cf9c5e7, 0x0,
    0xbfb1d97bbe5fde4a, 0x0,
    0xbfdb8255fd8484c1, 0x0,
    0xbfe56689aa9ba3c5, 0x0,
    0xbfde417f8e58e809, 0x0,
    0x3fac40d04e70d272, 0x0,
    0x3fdce6df3d6dad07, 0x0,
    0x3fe51a4fb51bff73, 0x0,
    0x3fd90486c13ecc98, 0x0,
    0x3f97b3a314b209e9, 0x0,
    0xbfdf3413d5e4ed23, 0x0,
    0xbfe997929abd6f3f, 0x0,
    0xbfde9ab9881a8a68, 0x0,
    0xbfb561cea10c6e9b, 0x0,
    0x3fda9d48fe8bb0db, 0x0,
    0x3fe65cb679453a4b, 0x0,
    0x3fe138e759644be1, 0x0,
    0xbf9a7420b70b6df6, 0x0,
    0xbfe006f8d103f423, 0x0,
    0xbfe40daa62931cb3, 0x0,
    0xbfdec6ff6e7a6db4, 0x0,
    0x3f718428fbc8b19a, 0x0,
    0x3fe14363d04e62ae, 0x0,
    0x3fe61b1561541370, 0x0,
    0x3fe012f2f6a4b76b, 0x0,
    0xbfbdbbb1c0bc6aef, 0x0,
    0xbfde023a71865f47, 0x0,
    0xbfe620dce6ee4910, 0x0,
    0xbfe180304a16e924, 0x0,
    0x3f97bc22a2f19f77, 0x0,
    0x3fdee997e156f2f2, 0x0,
    0x3fe5224eb3b9e608, 0x0,
    0x3fdf268afb42f05c, 0x0,
    0x3fa39fea175b2b9a, 0x0,
    0xbfdf9b850b8fe527, 0x0,
    0xbfe423eecf9177ee, 0x0,
    0xbfde5984a44e1a39, 0x0,
    0x3f6a4384da837e35, 0x0,
    0x3fe06c56cf67281b, 0x0,
    0x3fe61350e2fc3b64, 0x0,
    0x3fdd3a2d367015bf, 0x0,
    0x3f6142113ee08b84, 0x0,
    0xbfe0a99063b98633, 0x0,
    0xbfe61a317bd6414e, 0x0,
    0xbfdf336b5d401ec1, 0x0,
    0x3fbb539998afc55c, 0x0,
    0x3fd9f496a8e7086f, 0x0,
    0x3fe7a32fa825f030, 0x0,
    0x3fdd26fb30f4b5a1, 0x0,
    0x3faea72157fecc1f, 0x0,
    0xbfde0b1a889963b8, 0x0,
    0xbfe2213a63f48e02, 0x0,
    0xbfe12f15ac8aa3d2, 0x0,
    0xbfa7a0ada8379602, 0x0,
    0x3fe03b073fb36ba2, 0x0,
    0x3fe561a7ccd8802a, 0x0,
    0x3fe25b486d253feb, 0x0,
    0x3fa4ef0944eef748, 0x0,
    0xbfdcb12d58395e60, 0x0,
    0xbfe6da8132868b08, 0x0,
    0xbfe072c81521b656, 0x0,
    0xbf728ce04e3b0888, 0x0,
    0x3fdf18b42308e165, 0x0,
    0x3fe7a4c4806921f2, 0x0,
    0x3fde95eddd6eade3, 0x0,
    0x3fae546b2b5f6dac, 0x0,
    0xbfe1906e63b9ccee, 0x0,
    0xbfe4d8504dbfc439, 0x0,
    0xbfddf33c95c51a8c, 0x0,
    0x3f302317b761ca45, 0x0,
    0x3fda33d8755f1bd5, 0x0,
    0x3fe8c3a8a336bc8f, 0x0,
    0x3fdebd4cb74a2bb0, 0x0,
    0x3fb7b12e75724ec6, 0x0,
    0xbfdbfaea3f6dfd2c, 0x0,
    0xbfe77dd3732cbdec, 0x0,
    0xbfde6408a9ef3f8a, 0x0,
    0x3f7de9ae4207f8bd, 0x0,
    0x3fdbb7acde80b989, 0x0,
    0x3fe6296dcff9afca, 0x0,
    0x3fde4f1b25d613e7, 0x0,
    0x3fa5b888a7ecec4b, 0x0,
    0xbfe232d882b4404d, 0x0,
    0xbfe6e1684130439f, 0x0,
    0xbfdd252ae133d965, 0x0,
    0x3fa96f36b4f54e7f, 0x0,
    0x3fdb09b5e7961bf0, 0x0,
    0x3fe5ceb34931fcc1, 0x0,
    0x3fe21b6bcb4abd0c, 0x0,
    0x3fa090e9d967f887, 0x0,
    0xbfd8faca46541fa9, 0x0,
    0xbfe3e84f6cff8b98, 0x0,
    0xbfe02ee4ede70990, 0x0,
    0xbfb757d29297db9d, 0x0,
    0x3fe02f4930d56961, 0x0,
    0x3fe6dfbf8bbcffff, 0x0,
    0x3fde484f5d04c3a6, 0x0,
    0x3fb2faec310a9a1f, 0x0,
    0xbfdecf516a106239, 0x0,
    0xbfe4e8b5c175ee16, 0x0,
    0xbfe0ccb47e6cc5bd, 0x0,
    0xbfaa1c1be74cf62f, 0x0,
    0x3fdcb786ab60b6aa, 0x0,
    0x3fe6d1629bebe98c, 0x0,
    0x3fdc144270280e3e, 0x0,
    0xbfa4c5567e0e5106, 0x0,
    0xbfe16f5679f94a89, 0x0,
    0xbfe8d91e5ade0d56, 0x0,
    0xbfdf84b16e219aa1, 0x0,
    0x3f96c863cb84e8d2, 0x0,
    0x3fdc36754dd8dea2, 0x0,
    0x3fe8fb190bcac256, 0x0,
    0x3fdd951bac791d9f, 0x0,
    0x3fc06314ddd06ff0, 0x0,
    0xbfe17dd465ecf9a3, 0x0,
    0xbfe8d8943f601f32, 0x0,
    0xbfdf2ae100d06528, 0x0,
    0x3fa98f7121549ef6, 0x0,
    0x3fdf03ba6ed69d4a, 0x0,
    0x3fe608266cc360fd, 0x0,
    0x3fe2cd2c6057cd1e, 0x0,
    0x3f9122049e4f3ea6, 0x0,
    0xbfdd811a10a6565e, 0x0,
    0xbfe7809099287c4b, 0x0,
    0xbfdebea8df815499, 0x0,
    0xbfa226707b559b58, 0x0,
    0x3fe029f382c9538b, 0x0,
    0x3fe851c90990c0f4, 0x0,
    0x3fe1f4168e032235, 0x0,
    0x3f776e5b9191c472, 0x0,
    0xbfd8e81b9711f12b, 0x0,
    0xbfe719e336e143f4, 0x0,
    0xbfde70aa71402e9b, 0x0,
    0xbfb7af2a8b9b7bdb, 0x0,
    0x3fe00fc7c9c666ef, 0x0,
    0x3fe6ec28d66d37fe, 0x0,
    0x3fdc438d9e80ba44, 0x0,
    0x3f836e7c0d2d503b, 0x0,
    0xbfe159987d7910dd, 0x0,
    0xbfe5e67375b4af57, 0x0,
    0xbfda79ff29be6516, 0x0,
    0x3f58da53c2f2b7e0, 0x0,
    0x3fdb0b4c5dc00a26, 0x0,
    0x3fe80c302d2a1a25, 0x0,
    0x3fdfd8540b464fb2, 0x0,
    0x3fa1d3a17200ffdb, 0x0,
    0xbfe289ba3d184a05, 0x0,
    0xbfe4764f2828a335, 0x0,
    0xbfdfabb8bedb373c, 0x0,
    0xbfc2d6b1edd2b15f, 0x0,
    0x3fe0744687b6aa96, 0x0,
    0x3fe911b056ed49df, 0x0,
    0x3fde82b26f837567, 0x0,
    0x3f9815f16a876982, 0x0,
    0xbfe01ecff0ea896c, 0x0,
    0xbfe77632a2080bda, 0x0,
    0xbfe26182f987d158, 0x0,
    0x3f262f5a83624df0, 0x0,
    0x3fdde978e817420e, 0x0,
    0x3fe6d68479059b60, 0x0,
    0x3fdd5d9ac03944fa, 0x0,
    0x3fb3ddbd3cc428ab, 0x0,
    0xbfe141167096350e, 0x0,
    0xbfe2c7a79aff2a32, 0x0,
    0xbfe21a80aa3545e9, 0x0,
    0xbfb6a612c1c66f40, 0x0,
    0x3fe2001bf78140f6, 0x0,
    0x3fe5477a07af6084, 0x0,
    0x3fe17795fd634639, 0x0,
    0xbfb849004ddf9b4c, 0x0,
    0xbfdd5b7525fb48ee, 0x0,
    0xbfe72bc5f975a015, 0x0,
    0xbfdd6aa93399451e, 0x0,
    0xbf88437fc174a602, 0x0,
    0x3fe01f1fe288751a, 0x0,
    0x3fe6e3294ddfeeca, 0x0,
    0x3fdd165e9878306b, 0x0,
    0xbfb9578a97808912, 0x0,
    0xbfe0726975a9c50b, 0x0,
    0xbfe621429d2ab12c, 0x0,
    0xbfe03b8e0c11e407, 0x0,
    0x3f86a69a8e8309f4, 0x0,
    0x3fe26f00acce26c8, 0x0,
    0x3fe61bb5a5cab8b6, 0x0,
    0x3fe27ae45ba19e0e, 0x0,
    0x3fa65ec404afad0f, 0x0,
    0xbfdc4c9d18f8c56f, 0x0,
    0xbfe4d64f49c9ad30, 0x0,
    0xbfdd324629991eb6, 0x0,
    0xbf8a765e34ea5cfd, 0x0,
    0x3fdd1d3b0239bbab, 0x0,
    0x3fe599fb3a054893, 0x0,
    0x3fde0ecce7dea0fa, 0x0,
    0x3fa0d4e03269d18b, 0x0,
    0xbfe0bfed31875d9c, 0x0,
    0xbfe7fe152ec6615b, 0x0,
    0xbfe1426c18955123, 0x0,
    0x3fa286f76d01cfb3, 0x0,
    0x3fe04eab934896a7, 0x0,
    0x3fe42848c654d71c, 0x0,
    0x3fe12cc44ad6cb45, 0x0,
    0x3f893f296e4a4f43, 0x0,
    0xbfddda8ec41a20d2, 0x0,
    0xbfe820789caf68d4, 0x0,
    0xbfda8acbb40fbaf3, 0x0,
    0xbfb1b3526bda6386, 0x0,
    0x3fe0dd37a96d1816, 0x0,
    0x3fe5d597d6096c22, 0x0,
    0x3fe121d647c346c7, 0x0,
    0x3f85861d9f1229bb, 0x0,
    0xbfdb67090b5ba651, 0x0,
    0xbfeaa63d90165c80, 0x0,
    0xbfe01c5015c49246, 0x0,
    0x3fb1876fd18593ed, 0x0,
    0x3fdf3df29442212c, 0x0,
    0x3fe8bbac9e721175, 0x0,
    0x3fe021c0bbce46db, 0x0,
    0x3fa1dd4539969273, 0x0,
    0xbfd944502b707dce, 0x0,
    0xbfe5ffdb04cc551e, 0x0,
    0xbfe30f53154fa91f, 0x0,
    0xbfa333a41420709e, 0x0,
    0x3fde3535120128d3, 0x0,
    0x3fe7acfe7dc2ef2e, 0x0,
    0x3fe1db0ddc4e7653, 0x0,
    0xbfa891f59d3a901b, 0x0,
    0xbfdfcb0268569113, 0x0,
    0xbfe51e6814ae3101, 0x0,
    0xbfe0b52bc5f50f64, 0x0,
    0xbfaa46072be61b8e, 0x0,
    0x3fdf89aa4db04b1b, 0x0,
    0x3fe6e964cb14ee6f, 0x0,
    0x3fdf13d2a84f7389, 0x0,
    0x3f9b0462770248da, 0x0,
    0xbfde523506eb08c2, 0x0,
    0xbfe617e5b8f0d680, 0x0,
    0xbfe26277b868dd52, 0x0,
    0xbf8b18775dd1f763, 0x0,
    0x3fddbc103495d1f0, 0x0,
    0x3fe71781608e4b4c, 0x0,
    0x3fe24891acbba81a, 0x0,
    0xbf93a493d5e6ca2e, 0x0,
    0xbfe1516135447cdb, 0x0,
    0xbfe3e6ddd3853bdb, 0x0,
    0xbfe2812f4a51d2aa, 0x0,
    0x3f66d4d3b9cf9f3a, 0x0,
    0x3fe035585107db4f, 0x0,
    0x3fe88dc151ac43fa, 0x0,
    0x3fdc5e49fdf66c32, 0x0,
    0xbfab04d3caf51765, 0x0,
    0xbfde5536dfd51305, 0x0,
    0xbfe9ccab46fad727, 0x0,
    0xbfe0ac73feb321f9, 0x0,
    0xbfb79d7653d9aa4e, 0x0,
    0x3fe020ceccc7b336, 0x0,
    0x3fe6166522a340d9, 0x0,
    0x3fdb98b127587350, 0x0,
    0x3fa72491b5651f98, 0x0,
    0xbfddf2b63a395f4d, 0x0,
    0xbfe67ec222a40f93, 0x0,
    0xbfdc9c8fe4410b50, 0x0,
    0x3fb841c4a62be45d, 0x0,
    0x3fda7420c017472a, 0x0,
    0x3fe39fbe4559ee23, 0x0,
    0x3fdea4adb552fd7a, 0x0,
    0x3fa7dcc152d3c189, 0x0,
    0xbfe1f0812410a94c, 0x0,
    0xbfe8d38c7b95a0b0, 0x0,
    0xbfe17d0ea371fb25, 0x0,
    0xbfb221fbc3483dd1, 0x0,
    0x3fdf6e51756687da, 0x0,
    0x3fe6229d15ebf775, 0x0,
    0x3fdea4833b6a7a68, 0x0,
    0xbf99c5868f60e2f5, 0x0,
    0xbfdc8d810f4071c1, 0x0,
    0xbfe776a1005c9079, 0x0,
    0xbfdee6155adc48e3, 0x0,
    0xbfb23dde1363cecf, 0x0,
    0x3fe02b444b9b540a, 0x0,
    0x3fe74a65919eed9d, 0x0,
    0x3fe11a9536ed2446, 0x0,
    0xbf6037d319b50ff9, 0x0,
    0xbfe0354d2a1c9292, 0x0,
    0xbfe8872fd209ff97, 0x0,
    0xbfdd5586a87fcbc1, 0x0,
    0x3f652d861af05f9e, 0x0,
    0x3fe157269a62d704, 0x0,
    0x3fe597620d5f9b19, 0x0,
    0x3fdc83f9429a6776, 0x0,
    0xbfa26a15e6d2682d, 0x0,
    0xbfdbb010f2c4ca16, 0x0,
    0xbfe2df0d2186d1ac, 0x0,
    0xbfdf4fae092d3e86, 0x0,
    0xbfbce1625de0c400, 0x0,
    0x3fdb0ed2efe627f1, 0x0,
    0x3fe677f529af5402, 0x0,
    0x3fdc710563f66486, 0x0,
    0xbfb224273858d176, 0x0,
    0xbfe096c927fad375, 0x0,
    0xbfe34cb0fdb489b0, 0x0,
    0xbfe00859c379b547, 0x0,
    0xbfad69183dde875b, 0x0,
    0x3fe0221086206aa6, 0x0,
    0x3fe908669065ec1e, 0x0,
    0x3fd9de0709d8cbfa, 0x0,
    0xbf9837dd3a9b0ecd, 0x0,
    0xbfd8b56363b6990f, 0x0,
    0xbfe5e0a952da4609, 0x0,
    0xbfe1b8aff207901f, 0x0,
    0xbf842a0fdf25787e, 0x0,
    0x3fdf55f155648fbd, 0x0,
    0x3fe628ae56bdb3da, 0x0,
    0x3fdf9d746eb81cd2, 0x0,
    0xbfa114f58d9b3dc0, 0x0,
    0xbfe0e2e6cf2742c2, 0x0,
    0xbfe5c7de2e7294af, 0x0,
    0xbfe00cce75f4e58c, 0x0,
    0xbf9a67a8f9bac441, 0x0,
    0x3fe1579f77472c09, 0x0,
    0x3fe52d6b41a25a74, 0x0,
    0x3fe0521bcd3afbf0, 0x0,
    0x3fa002bd11c6d4b5, 0x0,
    0xbfe079e06e13be75, 0x0,
    0xbfe2f4fd593dc971, 0x0,
    0xbfe247247f6569a6, 0x0,
    0x3f985b250236d2d0, 0x0,
    0x3fe0893c8aec3016, 0x0,
    0x3fe73781ee7fe036, 0x0,
    0x3fe12223ec0655b8, 0x0,
    0x3fa27ce7d6de17f4, 0x0,
    0xbfe27d2700021496, 0x0,
    0xbfe61dc927d24c9c, 0x0,
    0xbfe0ddf0963101ce, 0x0,
    0x3f1d82f8763e1e5b, 0x0,
    0x3fe0241eef11f125, 0x0,
    0x3fe665911d8bb452, 0x0,
    0x3fddabaec8e8d429, 0x0,
    0x3fb0968bbb316cbb, 0x0,
    0xbfe0382aac99bf55, 0x0,
    0xbfe50bad1fc4aef4, 0x0,
    0xbfdd0d92191e8ba6, 0x0,
    0xbf990e0f2d062d57, 0x0,
    0x3fd6fd11caa887f8, 0x0,
    0x3fe63198d516fb4f, 0x0,
    0x3fe055ca91bb25ed, 0x0,
    0x3f8cd20a850b1d88, 0x0,
    0xbfe1528e8b66ea13, 0x0,
    0xbfe5ad63c6f0dc81, 0x0,
    0xbfe1e00bfe938632, 0x0,
    0xbf9494f9eddfe0a5, 0x0,
    0x3fddb42fb7de50fa, 0x0,
    0x3fe432dd95772ffe, 0x0,
    0x3fdcf2b6c54d4e7a, 0x0,
    0x3fb0a3ff72a9ce10, 0x0,
    0xbfe093a2f5fe5ef8, 0x0,
    0xbfe7ecf4f79ab2c5, 0x0,
    0xbfdfa2eedf3bad4b, 0x0,
    0x3fb47806d0b79824, 0x0,
    0x3fdd9f1809a4bde9, 0x0,
    0x3fe3f29069f21648, 0x0,
    0x3fdfc1992d332457, 0x0,
    0x3fbb94c643aabd9c, 0x0,
    0xbfdc8f3436f53f4d, 0x0,
    0xbfe466b76fc3cdb7, 0x0,
    0xbfde5c049c1030e2, 0x0,
    0xbf928712f05f26c3, 0x0,
    0x3fda4d480a736575, 0x0,
    0x3fe7d98da1d34792, 0x0,
    0x3fe0dfab9c2a2765, 0x0,
    0x3f940a589537b1a3, 0x0,
    0xbfe22e3850d3a6dc, 0x0,
    0xbfe735dda7df289e, 0x0,
    0xbfd9ad7f1340c2cc, 0x0,
    0x3f83eace3b74b22c, 0x0,
    0x3fdad041d5b46dea, 0x0,
    0x3fe6d9705da18874, 0x0,
    0x3fe1569144fe08fd, 0x0,
    0x3f6d462b05438d66, 0x0,
    0xbfe1aff1a962e125, 0x0,
    0xbfe743dbcf59cf60, 0x0,
    0xbfdfc57d12629b8f, 0x0,
    0xbf843746fcede86b, 0x0,
    0x3fdc839efad57fba, 0x0,
    0x3fe4ea51593325cb, 0x0,
    0x3fdf6cd24de1ac1b, 0x0,
    0x3fb88503f99ff789, 0x0,
    0xbfdd0b73f0713c7a, 0x0,
    0xbfe56364066b741f, 0x0,
    0xbfdf646e22ab5c8c, 0x0,
    0xbfa51f616f29152e, 0x0,
    0x3fdb07278907a646, 0x0,
    0x3fe3094928566d26, 0x0,
    0x3fdfe80bbb1bfe91, 0x0,
    0xbfa083374c2e089d, 0x0,
    0xbfdec8448a2d7a88, 0x0,
    0xbfe6c09ede440ee1, 0x0,
    0xbfda449d34ec936f, 0x0,
    0xbf7848e781b203e7, 0x0,
    0x3fe0cafd041b060f, 0x0,
    0x3fe6554a5b2b724e, 0x0,
    0x3fe31e27c73651d6, 0x0,
    0x3f8d22c8b549b31b, 0x0,
    0xbfdcbbd0b4c28cca, 0x0,
    0xbfe70ce252ecdae2, 0x0,
    0xbfe04acf6587c71a, 0x0,
    0x3f971928bfff93b2, 0x0,
    0x3fdd662a66a8124c, 0x0,
    0x3fe7702ddc76b3aa, 0x0,
    0x3fe02996a91db3ba, 0x0,
    0xbfc0947e232df48f, 0x0,
    0xbfda740b386c7c55, 0x0,
    0xbfe5a5b5ad7df89d, 0x0,
    0xbfdf4d9c574d5ac8, 0x0,
    0xbfa0d05897f00baa, 0x0,
    0x3fdf058ef51c0083, 0x0,
    0x3fe76d7d6d2e53db, 0x0,
    0x3fe049c0f50975db, 0x0,
    0x3fa5099f1755456b, 0x0,
    0xbfe0b68f4b0c9aa2, 0x0,
    0xbfe66950a2b8f170, 0x0,
    0xbfe1d345c923e0a5, 0x0,
    0xbf95bf9721f249be, 0x0,
    0x3fdea160006756aa, 0x0,
    0x3fe8802e3c6b00e2, 0x0,
    0x3fde720e6b4d4fc6, 0x0,
    0xbfc414712cb7612a, 0x0,
    0xbfdede2f8a296185, 0x0,
    0xbfe753cc68cdc783, 0x0,
    0xbfdc12cdccf1159c, 0x0,
    0xbfa4595fd6f2d804, 0x0,
    0x3fde4f0a01186614, 0x0,
    0x3fe8624d1ff6decd, 0x0,
    0x3fde9f2623dc0616, 0x0,
    0xbf4317b4de0dc850, 0x0,
    0xbfe0fafa104827cb, 0x0,
    0xbfe6b90aae324ca1, 0x0,
    0xbfe07f614ebf2dc7, 0x0,
    0x3fb752f0d0b78173, 0x0,
    0x3fdf16ba4dcfe5c2, 0x0,
    0x3fe4f7a798347a70, 0x0,
    0x3fdd1e3bd3d604dd, 0x0,
    0x3fb6b3c1675060e4, 0x0,
    0xbfde555f73e11aa5, 0x0,
    0xbfe678c2064590bf, 0x0,
    0xbfdba13b308575cf, 0x0,
    0x3f9176c91d0d8d07, 0x0,
    0x3fe395b2bd676a24, 0x0,
    0x3fe39f2ecf25cf40, 0x0,
    0x3fe0da7b9e493998, 0x0,
    0x3f9bf4b43ba22ed5, 0x0,
    0xbfdd7c51b9fa0740, 0x0,
    0xbfe792e1e5905a9f, 0x0,
    0xbfde6d542afa5049, 0x0,
    0xbfa54e8fd5b7a0d6, 0x0,
    0x3fe129337f76bd0a, 0x0,
    0x3fe7ef218f419137, 0x0,
    0x3fdff7ffc1ec4536, 0x0,
    0x3f65183fe4c83b40, 0x0,
    0xbfdd2703bf239412, 0x0,
    0xbfe8eec18ec17d44, 0x0,
    0xbfdd4fd559a9599f, 0x0,
    0xbfaea82f4891573c, 0x0,
    0x3fe045f0efd0d31f, 0x0,
    0x3fe79f895a42ec83, 0x0,
    0x3fe0126cab0992d0, 0x0,
    0xbf89eb500ab44414, 0x0,
    0xbfdf5f3d75c27b8f, 0x0,
    0xbfe51553cc5d2c45, 0x0,
    0xbfe1175b8880f933, 0x0,
    0xbf900330b52bef21, 0x0,
    0x3fdd278b618bcd66, 0x0,
    0x3fe6a14d2ab25baf, 0x0,
    0x3fd988a91d81797b, 0x0,
    0x3f7b9be3e8487442, 0x0,
    0xbfe3749107c3b4ea, 0x0,
    0xbfe424a544ff3a66, 0x0,
    0xbfdadb1e6efa3b60, 0x0,
    0xbf934f9fd1006e92, 0x0,
    0x3fdf9da228dea357, 0x0,
    0x3fe7170117f54a63, 0x0,
    0x3fdf4f770e04dba3, 0x0,
    0xbfa79f9106e40962, 0x0,
    0xbfe0486fb83f034a, 0x0,
    0xbfea06bc6d776db7, 0x0,
    0xbfe1e81a0744aa7e, 0x0,
    0xbf9c2377272d45d6, 0x0,
    0x3fde9741d83a97da, 0x0,
    0x3fe8404531293965, 0x0,
    0x3fe0acef5dd1fc9b, 0x0,
    0xbf6c8e43de5564b7, 0x0,
    0xbfdac6a15f4c8056, 0x0,
    0xbfe6befe26475b0a, 0x0,
    0xbfdc7b168e0fb2ec, 0x0,
    0xbfa115664860e29d, 0x0,
    0x3fe01370992250e7, 0x0,
    0x3fe97db232d97377, 0x0,
    0x3fe36d07c85881e8, 0x0,
    0xbf73d7431c81e405, 0x0,
    0xbfdf3d2d91772e1c, 0x0,
    0xbfe578b3238fe622, 0x0,
    0xbfe033b00c417b43, 0x0,
    0x3fa303b97dc950e8, 0x0,
    0x3fd7280799192c12, 0x0,
    0x3fe92679ed952920, 0x0,
    0x3fe0207a65897b34, 0x0,
    0xbfad774d54d4ef44, 0x0,
    0xbfe222bb17be2674, 0x0,
    0xbfe585084a8e4096, 0x0,
    0xbfe1d3e892aca584, 0x0,
    0xbf7225430c746d5f, 0x0,
    0x3fe16bd6ba93cf3f, 0x0,
    0x3fe3b327052490da, 0x0,
    0x3fe0029fd69b1e48, 0x0,
    0x3f696513e6cdcded, 0x0,
    0xbfde3057bb7d55b4, 0x0,
    0xbfe686f6904d60e4, 0x0,
    0xbfde01b95b30da49, 0x0,
    0xbfbbe3bc298b43cd, 0x0,
    0x3fe173d21abd9fa7, 0x0,
    0x3fe3c65a601e27d4, 0x0,
    0x3fdeba438337c51b, 0x0,
    0xbf71aef6209a9c69, 0x0,
    0xbfdbae441ef72240, 0x0,
    0xbfe657e2798abbc7, 0x0,
    0xbfe147ad225c5afd, 0x0,
    0x3faa0f9c25dab760, 0x0,
    0x3fdc3dc4e6a29ce6, 0x0,
    0x3fe8f8bc7e43152c, 0x0,
    0x3fddc09de790b892, 0x0,
    0x3f9663dd05f285b0, 0x0,
    0xbfe084f0ac2d2834, 0x0,
    0xbfe7097839c4ab62, 0x0,
    0xbfe1ed60fb34792b, 0x0,
    0xbfaba45db9737e88, 0x0,
    0x3fe0ac279cb1c18c, 0x0,
    0x3fe5f50d0ec9cffb, 0x0,
    0x3fda54be9cc04b97, 0x0,
    0x3fb28646485520b6, 0x0,
    0xbfde1737a0a41f3a, 0x0,
    0xbfe31441121515a2, 0x0,
    0xbfdcfc9f57c0eca1, 0x0,
    0xbf98ce2ba664aaec, 0x0,
    0x3fe010b74ccee22a, 0x0,
    0x3fe5e503a0c8e08a, 0x0,
    0x3fe1d4828ee94706, 0x0,
    0xbfad1c23c71cdc76, 0x0,
    0xbfdf837173bb130e, 0x0,
    0xbfe8ab473c074580, 0x0,
    0xbfdf6cc174a61c1e, 0x0,
    0xbfb8f5b8dc32512e, 0x0,
    0x3fe2082c022eadf6, 0x0,
    0x3fe683f408a569e4, 0x0,
    0x3fe1a59de71ff304, 0x0,
    0xbf94ff77f2a9381d, 0x0,
    0xbfe25fd5147424ed, 0x0,
    0xbfe8a1d9ecdd5639, 0x0,
    0xbfe0d5536becffba, 0x0,
    0xbf8c5b1b2e4f3d8b, 0x0,
    0x3fdc05e1f5136b40, 0x0,
    0x3fe5dff5fe9aa2af, 0x0,
    0x3fe14303b9bb7606, 0x0,
    0x3fab14dea1be74b9, 0x0,
    0xbfe29798de27caf4, 0x0,
    0xbfe778aca5a7dfe1, 0x0,
    0xbfdbe75f6b3c4043, 0x0,
    0x3fa7284dfcd450b5, 0x0,
    0x3fda96399eee0970, 0x0,
    0x3fe61f4dbd5ad461, 0x0,
    0x3fde955452b73d58, 0x0,
    0xbf9495c3b8ce330a, 0x0,
    0xbfe0c54f28d2f388, 0x0,
    0xbfe74dea9caa8738, 0x0,
    0xbfe2782dcbd26572, 0x0,
    0x3f8049ea67525871, 0x0,
    0x3fe0f188688d0c6c, 0x0,
    0x3fe6a8b6c5a6cfc7, 0x0,
    0x3fdbe20e88aad1f8, 0x0,
    0xbf9842ffa0ac7cec, 0x0,
    0xbfe084a26f298c43, 0x0,
    0xbfe7de0e8a02bb6e, 0x0,
    0xbfde1535d04f50cc, 0x0,
    0xbf9c29bb819c2d3f, 0x0,
    0x3fdfb9a7d22c095b, 0x0,
    0x3fe79317e27c5a74, 0x0,
    0x3fdfb0bbb7277ab9, 0x0,
    0x3f74dc9410b1a57c, 0x0,
    0xbfe1413b0eb76a51, 0x0,
    0xbfe6627f44c6d102, 0x0,
    0xbfe0c9b85f653164, 0x0,
    0xbfbf4efd73d7ec82, 0x0,
    0x3fdb759f34a6ca78, 0x0,
    0x3fe6d002dbb9c35f, 0x0,
    0x3fe1b747601745ae, 0x0,
    0x3fb0322d8ef7e6aa, 0x0,
    0xbfe12c851260814b, 0x0,
    0xbfe6486ad0929159, 0x0,
    0xbfe1b2f9ff390091, 0x0,
    0x3fa0eee51c1d4ce7, 0x0,
    0x3fdd923984364f2f, 0x0,
    0x3fe71e21374728f2, 0x0,
    0x3fdc9d88ef96d85a, 0x0,
    0x3fbc913813f85da4, 0x0,
    0xbfdf481419ec70d6, 0x0,
    0xbfe507422655ae28, 0x0,
    0xbfde62da05372e48, 0x0,
    0xbf92144d59b80cbd, 0x0,
    0x3fdc04e2f0f33ed2, 0x0,
    0x3fe85112776c410d, 0x0,
    0x3fe1c22dbb1c305e, 0x0,
    0xbfa3f0bfb967d042, 0x0,
    0xbfe36a937afb4aaf, 0x0,
    0xbfe71db636c7f9aa, 0x0,
    0xbfde3296ddb85be1, 0x0,
    0xbf9ad63e04cf0f1f, 0x0,
    0x3fdc6338c3f32a49, 0x0,
    0x3fe5dba91b8205fe, 0x0,
    0x3fdc6eac691286ff, 0x0,
    0xbfb109db10bd8d77, 0x0,
    0xbfe0398b8244810e, 0x0,
    0xbfe77a7e68703c3e, 0x0,
    0xbfe295cfca70f876, 0x0,
    0xbfb1e321f37158cb, 0x0,
    0x3fe12286f2b0433c, 0x0,
    0x3fe6be8e332685c2, 0x0,
    0x3fda31493312fa76, 0x0,
    0x3fb28f0689d7dd1d, 0x0,
    0xbfe0095c0e041605, 0x0,
    0xbfe8c06ca53259e1, 0x0,
    0xbfe16cf14d3b79a7, 0x0,
    0xbf6be6289c915d7d, 0x0,
    0x3fdb51d24442a950, 0x0,
    0x3fe4dd0548139e7d, 0x0,
    0x3fdbe4116bb621ee, 0x0,
    0xbf982a4024420449, 0x0,
    0xbfe0e01f97346990, 0x0,
    0xbfe67339e01e3b07, 0x0,
    0xbfde9f8086f47a4b, 0x0,
    0xbfc09d3b99f3371c, 0x0,
    0x3fdce158d933dc50, 0x0,
    0x3fe58c6d756c4339, 0x0,
    0x3fe0625811cd84ba, 0x0,
    0x3fa963ef189bbc85, 0x0,
    0xbfdf09bb88b19171, 0x0,
    0xbfe6dc8f930d1e8e, 0x0,
    0xbfe1c9af994847e0, 0x0,
    0x3f85b5b7bf999000, 0x0,
    0x3fe219f34f00ced0, 0x0,
    0x3fe51f475da89e7a, 0x0,
    0x3fdc62678d0e0cc8, 0x0,
    0xbf93950f04a9e556, 0x0,
    0xbfdf1073d38df21c, 0x0,
    0xbfe9f130e92c31e0, 0x0,
    0xbfe25c96ee711f16, 0x0,
    0xbf92c5667c1aaad4, 0x0,
    0x3fe124f09cf1a619, 0x0,
    0x3fe859ba7e9bd76a, 0x0,
    0x3fdd380217101416, 0x0,
    0xbf9ad2cca773fdcb, 0x0,
    0xbfdfd3f08b65f3b5, 0x0,
    0xbfe57c33841ebee4, 0x0,
    0xbfe13c65f7e0ba5c, 0x0,
    0xbfb104c5b143399d, 0x0,
    0x3fe0da44d4a2a3f7, 0x0,
    0x3fe784a9b532864a, 0x0,
    0x3fdefa0aeb246c83, 0x0,
    0xbfa50206d1580782, 0x0,
    0xbfdceb7bd1d1fa70, 0x0,
    0xbfe474b5fe24d034, 0x0,
    0xbfde64790895449c, 0x0,
    0x3fa8f66d9d154455, 0x0,
    0x3fdb509eec7972d2, 0x0,
    0x3fe5b1eed5b8a984, 0x0,
    0x3fe021017294a7a7, 0x0,
    0x3fa8ce4a8d6c2725, 0x0,
    0xbfde70637a830ea5, 0x0,
    0xbfe4cd3ac5798a80, 0x0,
    0xbfe165d6d4574434, 0x0,
    0xbfa1831d89c14ede, 0x0,
    0x3fdd733c75b034c0, 0x0,
    0x3fe540361db47fdb, 0x0,
    0x3fded5fbac88c7c0, 0x0,
    0x3fa24feb66565bc1, 0x0,
    0xbfe0cb3f7397069f, 0x0,
    0xbfe5d5d492c89b0a, 0x0,
    0xbfdcfd577668b700, 0x0,
    0x3f95f94bb879ac67, 0x0,
    0x3fdbeff897cf1d18, 0x0,
    0x3fe56d8d51d194c6, 0x0,
    0x3fdde77dc004b9de, 0x0,
    0x3f9459aa6221d4c8, 0x0,
    0xbfe0845714d7360a, 0x0,
    0xbfe58ca82144c8f5, 0x0,
    0xbfdfaba3c51ae250, 0x0,
    0xbfb419c76d7bdb72, 0x0,
    0x3fe17b037d98f74e, 0x0,
    0x3fe553455a71277d, 0x0,
    0x3fe0baaaf5c29137, 0x0,
    0x3f98df68703b6dd9, 0x0,
    0xbfe09b4b3bfd12cf, 0x0,
    0xbfe7f3f3ca294dd0, 0x0,
    0xbfe250671a9319ec, 0x0,
    0xbf98c4be4d47eae7, 0x0,
    0x3fdd8fa5cdef261e, 0x0,
    0x3fe49259265b2248, 0x0,
    0x3fe28710e1897245, 0x0,
    0x3fb34cc74ba6c8ab, 0x0,
    0xbfe0b4e152669d6a, 0x0,
    0xbfe29a85f4fdf373, 0x0,
    0xbfdeb57978773023, 0x0,
    0xbfa13e36e8a309c8, 0x0,
    0x3fe1c0476f38c23e, 0x0,
    0x3fea668417576ccc, 0x0,
    0x3fe089ac7a924ba5, 0x0,
    0x3fa549b0b31a1e40, 0x0,
    0xbfe0a58c8c9e9e11, 0x0,
    0xbfe6cdb7af712d32, 0x0,
    0xbfe198d2bcab5912, 0x0,
    0xbfa12cebb03af149, 0x0,
    0x3fdcf913cd8fd66c, 0x0,
    0x3fe71b66d86e1a43, 0x0,
    0x3fde2209cf3ec507, 0x0,
    0xbf72e5a07275a810, 0x0,
    0xbfe12425a1236268, 0x0,
    0xbfe95f2afe4258ee, 0x0,
    0xbfe1b65c6a54b470, 0x0,
    0xbfa8ad370367ae9f, 0x0,
    0x3fe070bb8ac95f57, 0x0,
    0x3fe49becff0032cf, 0x0,
    0x3fe01f8e1e40168a, 0x0,
    0xbf3deb74937ea945, 0x0,
    0xbfdb89ce3e1ef4f0, 0x0,
    0xbfe4ccdbd503d416, 0x0,
    0xbfe147dfa376e13f, 0x0,
    0x3fb55d33e7ba6987, 0x0,
    0x3fe01ddbc766dd73, 0x0,
    0x3fe9634981ff02b0, 0x0,
    0x3fdf85665864200e, 0x0,
    0x3f9b8fdfcb4908e1, 0x0,
    0xbfde58a216662fc7, 0x0,
    0xbfe6b145d9951ff5, 0x0,
    0xbfe13a255855875e, 0x0,
    0x3face7913457a693, 0x0,
    0x3fde54df346e4a16, 0x0,
    0x3fe5b0a63b9f82db, 0x0,
    0x3fdcd227269739a1, 0x0,
    0xbfac1299a6595c36, 0x0,
    0xbfdb3d1815bad253, 0x0,
    0xbfe639f089718c79, 0x0,
    0xbfe045e078bffddb, 0x0,
    0x3fa55dba7bd694e0, 0x0,
    0x3fe12068eb59b452, 0x0,
    0x3fe84d7eb57df73a, 0x0,
    0x3fdbfd8a4300e926, 0x0,
    0xbfa98d0e8d5d0ea3, 0x0,
    0xbfdfb8f33475d6d0, 0x0,
    0xbfe689881a5c4174, 0x0,
    0xbfdf5fcb02db5e3e, 0x0,
    0x3faa7668d227c84d, 0x0,
    0x3fe24aa63aff4a6c, 0x0,
    0x3fe620c9f20118a6, 0x0,
    0x3fe07b60b6ad2cfb, 0x0,
    0xbfb16b6bce6ef111, 0x0,
    0xbfe1e42113dda396, 0x0,
    0xbfe26993cdfd4f26, 0x0,
    0xbfdf829fc419047b, 0x0,
    0x3fa7ceb02c8beee9, 0x0,
    0x3fde3ba577bbd07a, 0x0,
    0x3fe70faa91f78872, 0x0,
    0x3fded01acc60a185, 0x0,
    0xbfa0b52769b9d320, 0x0,
    0xbfdc8523340f1326, 0x0,
    0xbfe8f0260ca18a78, 0x0,
    0xbfe1b8ce718f109c, 0x0,
    0x3f6c5fb59a44b991, 0x0,
    0x3fdc518c308f2693, 0x0,
    0x3fe74fbe6da210a4, 0x0,
    0x3fde838ce4fc6cb6, 0x0,
    0x3f71b7d1b78135bf, 0x0,
    0xbfe0e791258e5cf1, 0x0,
    0xbfe5407c921c75f0, 0x0,
    0xbfdd1ea1e91b4562, 0x0,
    0xbfb33f2c371b0b6a, 0x0,
    0x3fd8f2a5de9ee2ea, 0x0,
    0x3fe77bf9184c2539, 0x0,
    0x3fdfa58839893863, 0x0,
    0xbf37ea6656ab3be6, 0x0,
    0xbfe19bcf53a7d674, 0x0,
    0xbfe57d2fea956436, 0x0,
    0xbfdd637e178d659e, 0x0,
    0xbf9de3a84dafb225, 0x0,
    0x3fdfb22d6155c819, 0x0,
    0x3fe6c6f29e5d2879, 0x0,
    0x3fdec29270462b57, 0x0,
    0x3fc30b876e43ded5, 0x0,
    0xbfe475e0d33f399b, 0x0,
    0xbfe7f233828649f9, 0x0,
    0xbfe0394602fdbbcd, 0x0,
    0xbf9d03d3dbe73de7, 0x0,
    0x3fe1a11975fc91e3, 0x0,
    0x3fe7c00a1199de37, 0x0,
    0x3fdf343e6ada2653, 0x0,
    0xbf7017342f98955b, 0x0,
    0xbfdbbb939b9e9100, 0x0,
    0xbfe66a9006bffae2, 0x0,
    0xbfe201a492c414d7, 0x0,
    0x3f50290d68eaec95, 0x0,
    0x3fe2e5211cbaead3, 0x0,
    0x3fea06d810db322c, 0x0,
    0x3fe209a8ecafb9c3, 0x0,
    0x3fad32dac70f12a7, 0x0,
    0xbfdddfa669df1530, 0x0,
    0xbfe56762558382a9, 0x0,
    0xbfdf15eba44081ea, 0x0,
    0x3f922b29cfb81cea, 0x0,
    0x3fdc37f8c01ba4f2, 0x0,
    0x3fe851c963ae3bdb, 0x0,
    0x3fe041cf63e2741a, 0x0,
    0x3fb30d493ff1b14c, 0x0,
    0xbfdf472af4823c7c, 0x0,
    0xbfe7d86ef52dc104, 0x0,
    0xbfe0071bec66121e, 0x0,
    0xbfaa065dcb3a00ac, 0x0,
    0x3fdfbaed681d9e96, 0x0,
    0x3fe5f91a5d21d4e4, 0x0,
    0x3fde58493c4ec719, 0x0,
    0xbfb75b81f7b94041, 0x0,
    0xbfe09a122402b82f, 0x0,
    0xbfe44a87c2b0270d, 0x0,
    0xbfdba4a2512dba8a, 0x0,
    0x3fa46b52d07c2256, 0x0,
    0x3fdf657fa0eb7bff, 0x0,
    0x3fe5b180c3ce16e2, 0x0,
    0x3fdfc52e4e827774, 0x0,
    0xbfa27bd481f00646, 0x0,
    0xbfe09ea500f58ab7, 0x0,
    0xbfe52488cb838bd3, 0x0,
    0xbfd9ed100a10d3a6, 0x0,
    0xbfa18a848e4c40b7, 0x0,
    0x3fdea0f56bd8d920, 0x0,
    0x3fe82c7e6d4e8c8f, 0x0,
    0x3fe1564f5eb45592, 0x0,
    0x3f97052b99cfc704, 0x0,
    0xbfdd97a4b345b111, 0x0,
    0xbfe4887eac561617, 0x0,
    0xbfe08b6c0a790f3e, 0x0,
    0x3fb1668cea3f8718, 0x0,
    0x3fdd037afdeed608, 0x0,
    0x3fe7f15c52c02741, 0x0,
    0x3fdc2c5976989b4f, 0x0,
    0x3f905789527a8c8c, 0x0,
    0xbfe322a1226b8422, 0x0,
    0xbfe5d54d9b7dae56, 0x0,
    0xbfdeb63377fd9e42, 0x0,
    0x3f9446ba6b61e190, 0x0,
    0x3fe3748661c97a5c, 0x0,
    0x3fe5f22b314e3c01, 0x0,
    0x3fdd71bc96e99321, 0x0,
    0xbf4b8dd206c81d34, 0x0,
    0xbfe05fb9fbd7d374, 0x0,
    0xbfe69f1872d2db26, 0x0,
    0xbfda3554f7491ec7, 0x0,
    0xbf9cf06cae71210b, 0x0,
    0x3fde835a8fe9bb14, 0x0,
    0x3fe4d05695d1261a, 0x0,
    0x3fdf93638c5e6f75, 0x0,
    0xbfa8552988b369c8, 0x0,
    0xbfe0ee11cb02b200, 0x0,
    0xbfea9a4987706dbe, 0x0,
    0xbfdd85238d7f41b3, 0x0,
    0xbf840139a2a7bb51, 0x0,
    0x3fe12fc5e0c7167e, 0x0,
    0x3fe61ff3a825107a, 0x0,
    0x3fdec4c2da2bcf4b, 0x0,
    0x3fa11acfaa4b5987, 0x0,
    0xbfe0dbfcfe656de5, 0x0,
    0xbfe663b7b21f1c7e, 0x0,
    0xbfdfa21b6b70e492, 0x0,
    0xbfa9c55a229cd521, 0x0,
    0x3fde851212eeb951, 0x0,
    0x3fe839e7ecab6e72, 0x0,
    0x3fe07118611840d6, 0x0,
    0x3fb6b781c1c48830, 0x0,
    0xbfde74c481d612bf, 0x0,
    0xbfe59d8cc236fba0, 0x0,
    0xbfe115d10a79711c, 0x0,
    0x3f953a69fa0f1503, 0x0,
    0x3fdec5df40e66aa3, 0x0,
    0x3fe54d3a7a5aeebd, 0x0,
    0x3fdc00e5f8f0ca49, 0x0,
    0x3fa9f48188f732bb, 0x0,
    0xbfda9dce05e8dcfb, 0x0,
    0xbfe45c831ce396f4, 0x0,
    0xbfde37323390892d, 0x0,
    0xbf94f80f4cdf41e1, 0x0,
    0x3fdfbd2fc6579949, 0x0,
    0x3fe54a218a145293, 0x0,
    0x3fdc5fe1548ac378, 0x0,
    0x3f8fae5462167cb2, 0x0,
    0xbfdcfbe7b1335a81, 0x0,
    0xbfe70ae5a0a3ce47, 0x0,
    0xbfe1961b4d70861c, 0x0,
    0xbf9074377707670c, 0x0,
    0x3fe2671fe4d0108e, 0x0,
    0x3fe5870704ce754f, 0x0,
    0x3fe0c4b1dbf5dce6, 0x0,
    0x3fba0ab9ba47fdaf, 0x0,
    0xbfde8c5a5823d638, 0x0,
    0xbfe6204ca73d7458, 0x0,
    0xbfe1816b6c2482f0, 0x0,
    0x3fa856945a7c428d, 0x0,
    0x3fdd59cd485c92c9, 0x0,
    0x3fe5ec28f9c078b4, 0x0,
    0x3fe0bb513c89fb3a, 0x0,
    0x3fa979108f26d4db, 0x0,
    0xbfe10c70ad53067b, 0x0,
    0xbfe67a0efbb613e6, 0x0,
    0xbfdf01ecb49c5e60, 0x0,
    0x3f98c64e45c42d89, 0x0,
    0x3fdb995744ed6d66, 0x0,
    0x3fe5e78cffe79ab7, 0x0,
    0x3fe19583eab1e15d, 0x0,
    0x3fb01b70e59a856a, 0x0,
    0xbfe29e9f0a69a81a, 0x0,
    0xbfe83bb3f95232c4, 0x0,
    0xbfd982fe310eb353, 0x0,
    0xbfb21b11aa6713c3, 0x0,
    0x3fe1361afe10f721, 0x0,
    0x3fe4441d5bcb9847, 0x0,
    0x3fdc7c244355acb1, 0x0,
    0x3f7bcc3b6ae3a57a, 0x0,
    0xbfdcb59b6394de88, 0x0,
    0xbfe698ed148d57a4, 0x0,
    0xbfe14e0a986c58f0, 0x0,
    0xbf93cc29ca94fd4a, 0x0,
    0x3fe1c64e8beabee8, 0x0,
    0x3fe7979dd58389bb, 0x0,
    0x3fddeb9a21045a0a, 0x0,
    0x3facc4d7bb698a08, 0x0,
    0xbfe0b052712e3023, 0x0,
    0xbfe374043fbbfc04, 0x0,
    0xbfe322a90638a346, 0x0,
    0x3fae6509719e720c, 0x0,
    0x3fdbe68c514b4fd1, 0x0,
    0x3fe83e69d3f4ea51, 0x0,
    0x3fde7493287792ec, 0x0,
    0x3f9fa33a1e839c35, 0x0,
    0xbfe297a5b1672f51, 0x0,
    0xbfe6b561f94763f7, 0x0,
    0xbfde6664c30d57b1, 0x0,
    0x3f90d5d5d48830b7, 0x0,
    0x3fe29603b9d59ae7, 0x0,
    0x3fe3cfaa72779420, 0x0,
    0x3fdf363a5332e35a, 0x0,
    0xbfb3a1a922ae1612, 0x0,
    0xbfde105e646c277d, 0x0,
    0xbfe77366b2e31eaa, 0x0,
    0xbfe1e9f6af62bc64, 0x0,
    0x3f9b571bdd0fe549, 0x0,
    0x3fdd55c915ac4eb4, 0x0,
    0x3fe7069dc9437c1e, 0x0,
    0x3fdeed129b63b6d3, 0x0,
    0x3f927085670ae943, 0x0,
    0xbfe059036fbad7f4, 0x0,
    0xbfe5bffc6448b29b, 0x0,
    0xbfdcf31ff3034d62, 0x0,
    0xbfa004ee426710b4, 0x0,
    0x3fddd245d8bc10e1, 0x0,
    0x3fe58f7aa45588f5, 0x0,
    0x3fe157d64cdf2764, 0x0,
    0xbf7dbf4c7d5eda4f, 0x0,
    0xbfdeb71c85974ef5, 0x0,
    0xbfe795b676d9d511, 0x0,
    0xbfe2e307890d98d3, 0x0,
    0xbfb199613786121b, 0x0,
    0x3fdd57a862f46564, 0x0,
    0x3fe656c5236474e7, 0x0,
    0x3fde48babb5256df, 0x0,
    0xbfa2fcfaa3a65a7e, 0x0,
    0xbfe27d21e5f9b95d, 0x0,
    0xbfe89f8b16f1ade6, 0x0,
    0xbfe14ddde115da1f, 0x0,
    0xbfa0c6b15b3c33c3, 0x0,
    0x3fdda79e3ae73d77, 0x0,
    0x3fe2f47e02fa0a9a, 0x0,
    0x3fe21ebdb04b5733, 0x0,
    0xbf669241b841b52d, 0x0,
    0xbfdef909ebe5e888, 0x0,
    0xbfe6f31d05effdf9, 0x0,
    0xbfe0d92c5e3f2315, 0x0,
    0xbf71d9c84e7a5d0f, 0x0,
    0x3fde3f53842b9b40, 0x0,
    0x3fe9979fc42733be, 0x0,
    0x3fdef7933dd37b7e, 0x0,
    0xbfb5f5d0b2d7dad3, 0x0,
    0xbfe0b25a92c0ca6d, 0x0,
    0xbfe7b0ba847b7add, 0x0,
    0xbfe1a486ced581f7, 0x0,
    0x3f8e08d53bacc7fb, 0x0,
    0x3fda788a88f50f92, 0x0,
    0x3fe48a612d09d55b, 0x0,
    0x3fe0d3dfe3326ef5, 0x0,
    0xbf56bc1efb8a0a90, 0x0,
    0xbfe02918b6daff24, 0x0,
    0xbfe6d8c06502cb8b, 0x0,
    0xbfdfb8bc1cce644c, 0x0,
    0x3f72e92c943098b5, 0x0,
    0x3fdef00307744674, 0x0,
    0x3fe4a0527b0c76bb, 0x0,
    0x3fde4ae938351562, 0x0,
    0x3faf0d6a9af88c12, 0x0,
    0xbfdd706aebe0e80b, 0x0,
    0xbfe50acf9ad8c0eb, 0x0,
    0xbfdea61e850c1e71, 0x0,
    0xbf760823ed791544, 0x0,
    0x3fdd843e85a19de2, 0x0,
    0x3fe59a508a2c2e8a, 0x0,
    0x3fe07a3e69f66b3c, 0x0,
    0x3f6150c9e15cb28f, 0x0,
    0xbfe284843f0509c0, 0x0,
    0xbfe46263947349ca, 0x0,
    0xbfdde7eddbcf4195, 0x0,
    0x3fa0eff0102278e1, 0x0,
    0x3fdf8b93a17a94db, 0x0,
    0x3fe71d7af9345524, 0x0,
    0x3fdec73c4900c1e3, 0x0,
    0xbfb2b4aadc250016, 0x0,
    0xbfdd1f1429094d2d, 0x0,
    0xbfe6520c5e4b671b, 0x0,
    0xbfdccab787cd4b8f, 0x0,
    0x3fa2228f89b59627, 0x0,
    0x3fe1125b1fd7bc1a, 0x0,
    0x3fe87d2212644da8, 0x0,
    0x3fe219aa54363057, 0x0,
    0x3fa0d5daa32bdeb0, 0x0,
    0xbfe0634e63320105, 0x0,
    0xbfe608930bee236e, 0x0,
    0xbfdedfd8e8989969, 0x0,
    0x3fa1c305e669503d, 0x0,
    0x3fdd208d281022c0, 0x0,
    0x3fe71cf230634722, 0x0,
    0x3fdf30440a2fe252, 0x0,
    0xbf831fa3047f7a56, 0x0,
    0xbfe1dbce06f371de, 0x0,
    0xbfe6d78cac260d92, 0x0,
    0xbfde93cbb859e327, 0x0,
    0xbfa70a61ca184e52, 0x0,
    0x3fde39b61a491471, 0x0,
    0x3fe759b84e79ade3, 0x0,
    0x3fddfb5aa65a6f60, 0x0,
    0xbf99155211523441, 0x0,
    0xbfdd9f81b28f5b98, 0x0,
    0xbfe7e9505c16fbc6, 0x0,
    0xbfe0218ece8609b9, 0x0,
    0x3f462acd687fa36d, 0x0,
    0x3fdf3662a1e90b4e, 0x0,
    0x3fe7ab2b4bc7572f, 0x0,
    0x3fdb93c1f6bd3dbe, 0x0,
    0xbf74ab930eb69a3f, 0x0,
    0xbfdf7c6fcc94f6c3, 0x0,
    0xbfe714935204ddf9, 0x0,
    0xbfda0bbf516cf7ad, 0x0,
    0xbf89ee22f70cac44, 0x0,
    0x3fe20bbac661d9d3, 0x0,
    0x3fe652cef25f3522, 0x0,
    0x3fe1389540893aa1, 0x0,
    0x3fa00169c9e3c1ec, 0x0,
    0xbfe0dff408cd4616, 0x0,
    0xbfe55f615d3db495, 0x0,
    0xbfdc6cdca85d7bbc, 0x0,
    0xbf603d587fe7bed9, 0x0,
    0x3fdd1d05dfb3cb63, 0x0,
    0x3fe816b0d65565a2, 0x0,
    0x3fd8d4cf5c51b9ba, 0x0,
    0x3f94b7bac323ab64, 0x0,
    0xbfd9bea251eeb025, 0x0,
    0xbfe76011900f344c, 0x0,
    0xbfdfc98bd7056e4a, 0x0,
    0x3f92af92736a4311, 0x0,
    0x3fdf9ebfac1afad3, 0x0,
    0x3fe89f91350c145f, 0x0,
    0x3fe19a36675197ea, 0x0,
    0xbf87aac4c474a0da, 0x0,
    0xbfdd3c13f9be81d0, 0x0,
    0xbfe5e80d17902c82, 0x0,
    0xbfe17308ae1c64d7, 0x0,
    0x3fb2c1953c24ec8d, 0x0,
    0x3fe122955c700530, 0x0,
    0x3fe4313f58cdf843, 0x0,
    0x3fe0a731013f91d9, 0x0,
    0x3fa05ef5a503d7cb, 0x0,
    0xbfe094a438a25084, 0x0,
    0xbfe893a83956ea96, 0x0,
    0xbfe11802056acedf, 0x0,
    0x3f919366b23b855d, 0x0,
    0x3fdff64b53a9a5f3, 0x0,
    0x3fe52f95b4352bc5, 0x0,
    0x3fdc68dafd52f336, 0x0,
    0x3fa6f59b5d06fdd4, 0x0,
    0xbfdf40d27e6bc01b, 0x0,
    0xbfe6d6b0c1c55db4, 0x0,
    0xbfe050d88f2adcf1, 0x0,
    0x3fa1b737c15ad869, 0x0,
    0x3fe1a799b5a8f756, 0x0,
    0x3fe428363a7be976, 0x0,
    0x3fdbf9826ba6edc1, 0x0,
    0xbfa957ca622f9001, 0x0,
    0xbfe0e8a16b1f6abf, 0x0,
    0xbfe591bec8c5a0b4, 0x0,
    0xbfe101ec8459c2d6, 0x0,
    0x3fa77af2b3313da7, 0x0,
    0x3fde7ebcc5f16c76, 0x0,
    0x3fe4260155cde1ca, 0x0,
    0x3fe32b063a1ef20b, 0x0,
    0x3f72032d5a3634d8, 0x0,
    0xbfdfd795a4fa8060, 0x0,
    0xbfe5eae1116e4702, 0x0,
    0xbfd950d882a36f90, 0x0,
    0xbfa9d3c8acda0838, 0x0,
    0x3fe020fbc55f02c9, 0x0,
    0x3fe4d8b5eae22bff, 0x0,
    0x3fde65289be55c0f, 0x0,
    0x3fb312288ffdb8ea, 0x0,
    0xbfe199ffe18c5503, 0x0,
    0xbfe4b168cd14eeb7, 0x0,
    0xbfdf061cbfcea7b2, 0x0,
    0x3f8425e225da56f6, 0x0,
    0x3fdd43d8a66ce730, 0x0,
    0x3fe585f4211a30f9, 0x0,
    0x3fde2ceb334eb202, 0x0,
    0xbf9d7833af3ee569, 0x0,
    0xbfe175034d984d0d, 0x0,
    0xbfe5a88a162ab9d2, 0x0,
    0xbfe0902251e7585f, 0x0,
    0xbfb8f4eb733cd931, 0x0,
    0x3fe06882985dc471, 0x0,
    0x3fe9aeb9ab2360a9, 0x0,
    0x3fe1446ae316eb83, 0x0,
    0xbf92e03234ceb67d, 0x0,
    0xbfe1a4178ee36bf9, 0x0,
    0xbfe8027b1d17d48f, 0x0,
    0xbfddceb8d85bf9c2, 0x0,
    0x3fb178008d6a73f5, 0x0,
    0x3fe0cae626244dfa, 0x0,
    0x3fe5c6ec786587b7, 0x0,
    0x3fe29e26bfed974f, 0x0,
    0x3fa5970d7f97c734, 0x0,
    0xbfdeb85c635cad44, 0x0,
    0xbfe3fb4944d4bab7, 0x0,
    0xbfe09db5ba5aafc0, 0x0,
    0xbf5f72c2f496e70d, 0x0,
    0x3fe26593e3317ec8, 0x0,
    0x3fe6da96bf00333c, 0x0,
    0x3fdd475ca80f8ad6, 0x0,
    0xbf8b862590a085be, 0x0,
    0xbfe0bedfd7b9baad, 0x0,
    0xbfe5b9031b61fb61, 0x0,
    0xbfdb7a6e5df6c6db, 0x0,
    0x3fa7bf667cebdcb2, 0x0,
    0x3fdbc59e6b1d63c2, 0x0,
    0x3fe41b9924cf4325, 0x0,
    0x3fdf2d7f8ac42d5c, 0x0,
    0xbfaec931d081ae2e, 0x0,
    0xbfded9ec56cf44c7, 0x0,
    0xbfe4edc29853dcdd, 0x0,
    0xbfe1f002a51d8f66, 0x0,
    0xbf7521d8fc1579ca, 0x0,
    0x3fe0842ee9f01552, 0x0,
    0x3fe74e0c39c02f32, 0x0,
    0x3fda0f63acbf498f, 0x0,
    0xbfc1edc5658c087f, 0x0,
    0xbfde6faa4ecab249, 0x0,
    0xbfe56059c567dfd8, 0x0,
    0xbfe3185eb47e5471, 0x0,
    0x3fb865de49c63869, 0x0,
    0x3fdc48db62f3daba, 0x0,
    0x3fe5208755683d26, 0x0,
    0x3fe036d464010c61, 0x0,
    0xbfa5e1815768eebb, 0x0,
    0xbfde728daeabf33b, 0x0,
    0xbfe6dedc6f596042, 0x0,
    0xbfe014893f6432f2, 0x0,
    0xbf9924ea3abd0973, 0x0,
    0x3fe28325e75aa18b, 0x0,
    0x3fe3d6f1495cad03, 0x0,
    0x3fe13af5385dd151, 0x0,
    0x3f94d6d06e8cf268, 0x0,
    0xbfdf33531bf199c2, 0x0,
    0xbfe62d0badfe117f, 0x0,
    0xbfe088c4be8c4458, 0x0,
    0xbfaebea506c3626f, 0x0,
    0x3fd9ecba80b0e546, 0x0,
    0x3fe9a77b04d86e02, 0x0,
    0x3fdc0356fb628f12, 0x0,
    0x3f850274da572b51, 0x0,
    0xbfdeda6850c092e8, 0x0,
    0xbfe4dbf449f1f1a9, 0x0,
    0xbfd9d8dbf0b4d231, 0x0,
    0x3fa7e4ccd106fc31, 0x0,
    0x3fe12098667e7562, 0x0,
    0x3fe731381c4ad573, 0x0,
    0x3fdeb530b71513e4, 0x0,
    0x3f8a146186a28dc9, 0x0,
    0xbfe03d5ae02e1133, 0x0,
    0xbfe55393869b46f2, 0x0,
    0xbfe0755ae9483371, 0x0,
    0xbfb32a8e864658b7, 0x0,
    0x3fdec4a448aa6e58, 0x0,
    0x3fe471d6e4d00f9c, 0x0,
    0x3fdee85a250f6ab2, 0x0,
    0xbf9891bb9775fd50, 0x0,
    0xbfdd7f9b881af11a, 0x0,
    0xbfe5023dd8489a4c, 0x0,
    0xbfdbc0cbcd4f2d58, 0x0,
    0xbfa8ede74f6588a7, 0x0,
    0x3fdf516fe00aed4b, 0x0,
    0x3fe898cb1a9fcd4c, 0x0,
    0x3fdaa53658a2670e, 0x0,
    0x3fb0c7ec80cb2b44, 0x0,
    0xbfdefa43b6dad98a, 0x0,
    0xbfe80d49069642d5, 0x0,
    0xbfddacf33311c50f, 0x0,
    0x3f9291d185940cf9, 0x0,
    0x3fdf94879965a8cc, 0x0,
    0x3fe772a5d6c95180, 0x0,
    0x3fdde04d5d27be90, 0x0,
    0xbfaf4b46e987a44a, 0x0,
    0xbfde325d1c93b3b9, 0x0,
    0xbfe9cf4bf8740ee1, 0x0,
    0xbfda7dfef14aa4fd, 0x0,
    0xbfa19f31602bc6d8, 0x0,
    0x3fe10118653332e3, 0x0,
    0x3fe4af33d84b22c5, 0x0,
    0x3fdef78aa031aeee, 0x0,
    0xbf7bd53425c0b290, 0x0,
    0xbfe0bdd18ca64b84, 0x0,
    0xbfe6dc7f4cfd0154, 0x0,
    0xbfdf4778673b649d, 0x0,
    0xbfbbc01cb6258dda, 0x0,
    0x3fd9cb52632ce919, 0x0,
    0x3fe61e9fe01520b0, 0x0,
    0x3fdf24b49c0c3167, 0x0,
    0x3f95b2c75e6cb5aa, 0x0,
    0xbfd8d3f849d90fbb, 0x0,
    0xbfe69b81466dfe8c, 0x0,
    0xbfe0af2467245c3f, 0x0,
    0x3f945737d7337831, 0x0,
    0x3fdb16d2a4c17e8a, 0x0,
    0x3fe536ccdf5fe5a8, 0x0,
    0x3fdfabc1d214b94f, 0x0,
    0xbfa7e59d44afa641, 0x0,
    0xbfdd67fbb3bd2dae, 0x0,
    0xbfe79ea363d9b982, 0x0,
    0xbfe07acb7c61e791, 0x0,
    0xbfa20f93ea4033d9, 0x0,
    0x3fdfc8d7058d4ecd, 0x0,
    0x3fe7f5fdf4ecb226, 0x0,
    0x3fe08273e7f70999, 0x0,
    0x3fa50d02badd77a9, 0x0,
    0xbfe01b9b6556071e, 0x0,
    0xbfe5b83a81cdb81a, 0x0,
    0xbfdecc22363b0726, 0x0,
    0x3fb02115fb3ca1e7, 0x0,
    0x3fe0a629d9e0abb5, 0x0,
    0x3fe6bfedd032f668, 0x0,
    0x3fdf5353db70c726, 0x0,
    0xbfb33eda0aa4a509, 0x0,
    0xbfe07630e441d68d, 0x0,
    0xbfe35da675feea9e, 0x0,
    0xbfd8eb42e59688c0, 0x0,
    0xbfa58c62801123b7, 0x0,
    0x3fde2a1fff6f3752, 0x0,
    0x3fe87d237570c02f, 0x0,
    0x3fe219130e6d549f, 0x0,
    0x3f879e15e700b681, 0x0,
    0xbfe21ee9fede0b0a, 0x0,
    0xbfe650d1fdd84f25, 0x0,
    0xbfe33181d50f13f8, 0x0,
    0xbf9a4d20675904ee, 0x0,
    0x3fe157a55120e931, 0x0,
    0x3fe6ef05ac2fe947, 0x0,
    0x3fdcd1dd84c5b850, 0x0,
    0x3fb71d5aac4c8695, 0x0,
    0xbfde2c7cad7aca6a, 0x0,
    0xbfe6f9a3a33044bd, 0x0,
    0xbfe0217407ece6ed, 0x0,
    0xbf9d7f1fc2ba231f, 0x0,
    0x3fddee9b3a61e90a, 0x0,
    0x3fe5a4bd39caf55b, 0x0,
    0x3fe1001a0a587b06, 0x0,
    0xbf969c188f577478, 0x0,
    0xbfe107da3d12e6d2, 0x0,
    0xbfe65c25d1a2f2da, 0x0,
    0xbfd911d28d74637c, 0x0,
    0xbfa2d902911eee13, 0x0,
    0x3fe0ef7deacc5575, 0x0,
    0x3fe634e457e42c5b, 0x0,
    0x3fe1ead6c130a23a, 0x0,
    0xbf93ac8c2abf4375, 0x0,
    0xbfddc543e3b08e28, 0x0,
    0xbfe536400460aae6, 0x0,
    0xbfd9fcf6d4555f3a, 0x0,
    0xbfb880367b237896, 0x0,
    0x3fdeb1d58e2543d9, 0x0,
    0x3fe585daedac55fb, 0x0,
    0x3fe26cf8def9eeb4, 0x0,
    0xbf9d3f1fd97a47e9, 0x0,
    0xbfe16496a3763ebe, 0x0,
    0xbfe3403996a63a6b, 0x0,
    0xbfddab04375ed486, 0x0,
    0x3fa0e47fa9a87b2f, 0x0,
    0x3fda367b26177564, 0x0,
    0x3fe66e4f8b339fee, 0x0,
    0x3fdea6fad741b708, 0x0,
    0x3f9a78fd24411409, 0x0,
    0xbfe0d2f7b1170216, 0x0,
    0xbfe750c85ea4fd81, 0x0,
    0xbfe109c373e813a9, 0x0,
    0x3fa2f473dbc42f4d, 0x0,
    0x3fdf383895ef396c, 0x0,
    0x3fe9e26dab5d0cd5, 0x0,
    0x3fdfe9c78819fac6, 0x0,
    0xbf91bd7e81aaec46, 0x0,
    0xbfe040b56969bf7e, 0x0,
    0xbfe775b29428d55c, 0x0,
    0xbfe021a249ad3dac, 0x0,
    0xbfab5f7be9ad5d34, 0x0,
    0x3fdb5e9c40c2e5e9, 0x0,
    0x3fe6efc4453eee21, 0x0,
    0x3fe0a3db456fba91, 0x0,
    0xbf72cbd051acc6ba, 0x0,
    0xbfdbcd0cfc85a52b, 0x0,
    0xbfe5bc9d6bd64454, 0x0,
    0xbfdeb42fecbb7316, 0x0,
    0xbfa63a6902110475, 0x0,
    0x3fdaabc08e679caa, 0x0,
    0x3fe6f0856ba0e143, 0x0,
    0x3fe1bd2724cc4dd7, 0x0,
    0xbfa068c7deb2975f, 0x0,
    0xbfdd1225aec87f43, 0x0,
    0xbfe80cf1097384ad, 0x0,
    0xbfdf7479403e9d9d, 0x0,
    0xbfa725063f194652, 0x0,
    0x3fe05fa4d6ba76f1, 0x0,
    0x3fe5b63d24382024, 0x0,
    0x3fe027885ca9538f, 0x0,
    0x3f90a75c8968a6f9, 0x0,
    0xbfdbcf0105be8954, 0x0,
    0xbfe3f925b79943d1, 0x0,
    0xbfdd8e8d2d6627e8, 0x0,
    0x3fa71d01a27e5778, 0x0,
    0x3fdc4491019f5986, 0x0,
    0x3fe3549950eb4546, 0x0,
    0x3fdb4c1ad0447e47, 0x0,
    0x3f726a43abb9d446, 0x0,
    0xbfe2ff93f0ce0450, 0x0,
    0xbfe5b22cd59ed2ca, 0x0,
    0xbfe168b150680d9f, 0x0,
    0xbfab1c3398c11a0f, 0x0,
    0x3fe1bfd3677fd988, 0x0,
    0x3fe7bd25ab05a832, 0x0,
    0x3fdd88fc49accd12, 0x0,
    0xbfb0e83ab6c8e4ee, 0x0,
    0xbfde5e7de5f257af, 0x0,
    0xbfe767e45e900026, 0x0,
    0xbfdfe08b1b7249d2, 0x0,
    0x3fbae709cab71793, 0x0,
    0x3fdf9145b75f2e40, 0x0,
    0x3fe9ffa61c8c437c, 0x0,
    0x3fe11afd94ace3fc, 0x0,
    0x3f8da035441638a4, 0x0,
    0xbfde423ca5b0418d, 0x0,
    0xbfe4ef736047e393, 0x0,
    0xbfe15212445d6068, 0x0,
    0x3f7af71363658945, 0x0,
    0x3fe0072fc28548b4, 0x0,
    0x3fe780ed399af7da, 0x0,
    0x3fe1fae286b0dae6, 0x0,
    0x3fa5149cc68ac50b, 0x0,
    0xbfe039cd20963442, 0x0,
    0xbfe75484aee0a154, 0x0,
    0xbfdfd9462511d60d, 0x0,
    0x3f77e8c16e336905, 0x0,
    0x3fdd7a8891238176, 0x0,
    0x3fe8a93878c4d7ab, 0x0,
    0x3fdf62c8cbc413db, 0x0,
    0x3fb126812ea01a05, 0x0,
    0xbfe321e42218820f, 0x0,
    0xbfe5dd284c225304, 0x0,
    0xbfdebfc7514489ff, 0x0,
    0xbf9ca854dbdd83d4, 0x0,
    0x3fe2225a1f5c3bfe, 0x0,
    0x3fe583c8655f34f7, 0x0,
    0x3fe152b55ae13599, 0x0,
    0x3f88d3e4108e47a4, 0x0,
    0xbfdecd711cca9cb3, 0x0,
    0xbfe4eccf91df0997, 0x0,
    0xbfe0d73466ecc660, 0x0,
    0xbf98e252926eea2d, 0x0,
    0x3fe0c2f5b0c0ea14, 0x0,
    0x3fe44106f393e1d6, 0x0,
    0x3fdf34c775c1e9da, 0x0,
    0x3f8f9a4d4c628110, 0x0,
    0xbfe007c2301ebacb, 0x0,
    0xbfe4f85425ff6544, 0x0,
    0xbfe26d12fd431919, 0x0,
    0xbfce4c88c4a2f605, 0x0,
    0x3fe1df2a81afbaf8, 0x0,
    0x3fe3bed9af6180d6, 0x0,
    0x3fe11e233dd3990f, 0x0,
    0x3fbfbba6ec39a679, 0x0,
    0xbfe122d38e253ae8, 0x0,
    0xbfe3ff99089e1079, 0x0,
    0xbfe1af079b6ed57c, 0x0,
    0xbf857716094fcc12, 0x0,
    0x3fdaf1e8600ad428, 0x0,
    0x3fe5d3390ff3154d, 0x0,
    0x3fde386b55b2d692, 0x0,
    0xbf98fb250aaace25, 0x0,
    0xbfdd1b87c024fb87, 0x0,
    0xbfe7a57057170d09, 0x0,
    0xbfdb4058301c00ac, 0x0,
    0x3fadfdd6afce4106, 0x0,
    0x3fe2390f1ef7144e, 0x0,
    0x3fe525462931c37d, 0x0,
    0x3fe080b6fe8e9db1, 0x0,
    0xbfb704653eb7875e, 0x0,
    0xbfde4afc02738f17, 0x0,
    0xbfe62b53ce379928, 0x0,
    0xbfd5e3a58fc7b3b8, 0x0,
    0xbf959ac5f3700bd6, 0x0,
    0x3fdc4920c97fae94, 0x0,
    0x3fe5a0c88d4b2363, 0x0,
    0x3fddb861e371f145, 0x0,
    0xbf692a80415c4195, 0x0,
    0xbfe03ebcb42c499f, 0x0,
    0xbfe51b75d0bb73c1, 0x0,
    0xbfdffc150399695a, 0x0,
    0x3fa6904ab531d5b5, 0x0,
    0x3fdeece62b043e9b, 0x0,
    0x3fe5a29865a0b958, 0x0,
    0x3fe0dcc71983409a, 0x0,
    0xbf76890a405d5437, 0x0,
    0xbfdfe0a74881384e, 0x0,
    0xbfe6b9638bbc9a30, 0x0,
    0xbfde817de74f3e09, 0x0,
    0xbfa0a6f04f3db7e3, 0x0,
    0x3fde2d0fb3c19d38, 0x0,
    0x3fe6ee91339ce6fe, 0x0,
    0x3fe22f66d135a4a7, 0x0,
    0xbf938c35cb50fd5b, 0x0,
    0xbfde55e3f6341951, 0x0,
    0xbfe582a61854a192, 0x0,
    0xbfe0e08a2666e803, 0x0,
    0xbf9fcca6525323a8, 0x0,
    0x3fdfbbe08758e6e9, 0x0,
    0x3fe45260a21f1dbf, 0x0,
    0x3fe0debb9c2e42a7, 0x0,
    0xbf72a372d4f8d71a, 0x0,
    0xbfded6a758ca8afb, 0x0,
    0xbfe67676f9ed8f2b, 0x0,
    0xbfd9370b72ca232a, 0x0,
    0xbfa92ded20533cb7, 0x0,
    0x3fdf4d47e2e98621, 0x0,
    0x3fe7bcce888bdc64, 0x0,
    0x3fe077283e1bc6ff, 0x0,
    0xbf83caa1cb347800, 0x0,
    0xbfde00546b32d7a3, 0x0,
    0xbfe5cfca9f67a2d0, 0x0,
    0xbfde9a35cc65949f, 0x0,
    0xbfae13092aa3ac43, 0x0,
    0x3fdedd2cb6180d5f, 0x0,
    0x3fe7f474bd961a3a, 0x0,
    0x3fdd642ccde2714c, 0x0,
    0xbfbdb87aae197d66, 0x0,
    0xbfda3019327e4cfc, 0x0,
    0xbfe67b308f27a3eb, 0x0,
    0xbfe000c2662e10fd, 0x0,
    0xbfaef2c29dc9b95e, 0x0,
    0x3fdc3aeb6625ef4d, 0x0,
    0x3fe2cecd4504737f, 0x0,
    0x3fe17eba890fce64, 0x0,
    0xbfb8596cb475c4f9, 0x0,
    0xbfe1a5c5de199cad, 0x0,
    0xbfe6c6b50de712ed, 0x0,
    0xbfe292ae2d6226e5, 0x0,
    0xbfa9ab16f5b338c7, 0x0,
    0x3fdd17181d048de5, 0x0,
    0x3fe4e27c4f5c414e, 0x0,
    0x3fdf1b10164c18a5, 0x0,
    0x3f586dda62d18ccd, 0x0,
    0xbfdef459617264c7, 0x0,
    0xbfe4ceef1c38c6a3, 0x0,
    0xbfe0fee7fa38880d, 0x0,
    0x3facc9648a746a08, 0x0,
    0x3fdc3a37d6a82a1e, 0x0,
    0x3fe9d5fdfae4af9e, 0x0,
    0x3fdcf9c5cf6d9b05, 0x0,
    0xbf9942222c223cef, 0x0,
    0xbfdd9d0ed883884f, 0x0,
    0xbfe65866ddaec2db, 0x0,
    0xbfe004f187b554ab, 0x0,
    0xbf9596a8942d33dd, 0x0,
    0x3fe1c5eb3b003b68, 0x0,
    0x3fe7d3a10a1c8e70, 0x0,
    0x3fe09d0c923a2e99, 0x0,
    0xbfa657b4e582152a, 0x0,
    0xbfdf4969d747a994, 0x0,
    0xbfe5871e84fb277b, 0x0,
    0xbfe24b9d4f70d5ed, 0x0,
    0x3fae66abee4490ec, 0x0,
    0x3fe10be021dbe2d1, 0x0,
    0x3feab4df943a28bc, 0x0,
    0x3fdd1545632f1dda, 0x0,
    0xbfaa53418e47dc4f, 0x0,
    0xbfddf67c6a55d12a, 0x0,
    0xbfe6745c1ae04a24, 0x0,
    0xbfdceeeb5927777a, 0x0,
    0x3fa53fc066834a71, 0x0,
    0x3fddd4934f9684b2, 0x0,
    0x3fe6e3d99285d34b, 0x0,
    0x3fdcfa25c08b7826, 0x0,
    0xbfa5aa440055e34c, 0x0,
    0xbfdbc2b7d5c10c4f, 0x0,
    0xbfe5fb1b9271d308, 0x0,
    0xbfe0de8791be6c71, 0x0,
    0xbfa48fcfb1f2a834, 0x0,
    0x3fdc2f93f81d9182, 0x0,
    0x3fe7482edc0bdfe4, 0x0,
    0x3fe0cf6a87ce5994, 0x0,
    0x3f9261d10e86e2f6, 0x0,
    0xbfdb9943cfb0a2d2, 0x0,
    0xbfe8f13f394a23b6, 0x0,
    0xbfdbffa957532ca6, 0x0,
    0xbfbad03ff21b8f4f, 0x0,
    0x3fdf051c072a4d55, 0x0,
    0x3fe3fb5e0f3580cc, 0x0,
    0x3fdf18098f243588, 0x0,
    0x3fb4853117f11978, 0x0,
    0xbfd79ec8ca42bdaa, 0x0,
    0xbfe71f0183477e14, 0x0,
    0xbfe057a8441476de, 0x0,
    0xbfa07255e6c500ee, 0x0,
    0x3fdbdcc4ff8320af, 0x0,
    0x3fe3fd2732333d25, 0x0,
    0x3fdae198b36e43f6, 0x0,
    0x3fa428db7a8be1c2, 0x0,
    0xbfde6434d3874c75, 0x0,
    0xbfe5e6ebbbdf1332, 0x0,
    0xbfdcb1949fe79a5c, 0x0,
    0x3fb3ad02b5b8158f, 0x0,
    0x3fe086d98d4a729f, 0x0,
    0x3fe51ce5912d484e, 0x0,
    0x3fe262731ee5d5a2, 0x0,
    0x3f97e7adf939896b, 0x0,
    0xbfdebb73118fe91c, 0x0,
    0xbfe6f96a2b148233, 0x0,
    0xbfdd5dfe9f0c0512, 0x0,
    0xbf8556b28cb7b56f, 0x0,
    0x3fda6d69cda2d712, 0x0,
    0x3fe4ebbdaa67ff4b, 0x0,
    0x3fe27d9a620e1e73, 0x0,
    0x3f9bf46ce1f0bad8, 0x0,
    0xbfe046c58b90dca0, 0x0,
    0xbfe66820e3097ca1, 0x0,
    0xbfe2d07e27f5ebbd, 0x0,
    0xbfaa2cb6b7d7ef69, 0x0,
    0x3fdbce7c837259b6, 0x0,
    0x3fe7780a9c3a2149, 0x0,
    0x3fe2bf4a6fb17c7e, 0x0,
    0xbf94efd9115b389a, 0x0,
    0xbfda3cbd3648c87e, 0x0,
    0xbfe97b1527eb4579, 0x0,
    0xbfdcf7ddbf829cb2, 0x0,
    0x3fa9ece58622aac7, 0x0,
    0x3fdc4b79c81b0777, 0x0,
    0x3fe602fca2e17a31, 0x0,
    0x3fdf1d00f1ea3185, 0x0,
    0x3fa50275d3c87c13, 0x0,
    0xbfda4f1a361140da, 0x0,
    0xbfe7e4193ca0fbe9, 0x0,
    0xbfdce85830a676f6, 0x0,
    0x3fa635b830aa6219, 0x0,
    0x3fe27f56afd73fd5, 0x0,
    0x3fe578ee378ca328, 0x0,
    0x3fe162fecdfa480d, 0x0,
    0xbfa12279663a7900, 0x0,
    0xbfdbcb9afe0c21da, 0x0,
    0xbfe58bceb5bafe2a, 0x0,
    0xbfe102280ae324e3, 0x0,
    0xbf876fd7cb682a04, 0x0,
    0x3fdf3f5b8978e54c, 0x0,
    0x3fe699f94748c672, 0x0,
    0x3fddd5ed574a1fce, 0x0,
    0x3f7eea4fe59858cb, 0x0,
    0xbfe1c781ba57a6ef, 0x0,
    0xbfe4b7ce215fdbd4, 0x0,
    0xbfda6b3d86378228, 0x0,
    0x3f972efbdd4a5c48, 0x0,
    0x3fdfe1e58582c2a3, 0x0,
    0x3fe4831c23086c64, 0x0,
    0x3fdd966846649d45, 0x0,
    0x3fa0e63ec1f354fb, 0x0,
    0xbfe143f3aac4e3a2, 0x0,
    0xbfe6fcaad02a09b5, 0x0,
    0xbfe05c5fe61970d6, 0x0,
    0xbfa243859993bc05, 0x0,
    0x3fdceb71f40644b4, 0x0,
    0x3fe7218721075ccb, 0x0,
    0x3fe083cdd2d5e3d6, 0x0,
    0x3fb800d07a9dffc0, 0x0,
    0xbfdf2ed64ea40348, 0x0,
    0xbfe6927c4f089136, 0x0,
    0xbfdda95e6c2272b4, 0x0,
    0xbf889263fc0d6910, 0x0,
    0x3fe0bc5a0751c03d, 0x0,
    0x3fe83e64a56236cc, 0x0,
    0x3fe0f11c0ec97679, 0x0,
    0x3fae1c727f7fb90a, 0x0,
    0xbfdff3b614a1f273, 0x0,
    0xbfe68b14c19715af, 0x0,
    0xbfe0fae272083723, 0x0,
    0xbf8cadb542541ace, 0x0,
    0x3fdc83c5e526f740, 0x0,
    0x3fe5764132886b76, 0x0,
    0x3fdda07f5cebf7e7, 0x0,
    0xbf64bfb212404e1d, 0x0,
    0xbfe0e2385f2d54e2, 0x0,
    0xbfe71e48bf4e710b, 0x0,
    0xbfdc61d08d7cd088, 0x0,
    0xbf8242fefe3966eb, 0x0,
    0x3fdcf80c88c8c16a, 0x0,
    0x3fe5b44bbdb8090f, 0x0,
    0x3fdd66a22e734b96, 0x0,
    0xbf85b848ed0514cf, 0x0,
    0xbfe3bb64f8b28066, 0x0,
    0xbfe5e76ea4a152f2, 0x0,
    0xbfdc8ea77d8758f8, 0x0,
    0xbfab64a77327a3ee, 0x0,
    0x3fdc9a18a1662229, 0x0,
    0x3fe6e250e6ae1419, 0x0,
    0x3fe0ca2b8397cb08, 0x0,
    0x3fb0d72e2a8b0d35, 0x0,
    0xbfdff6c4bbb95412, 0x0,
    0xbfe691826ca627d1, 0x0,
    0xbfdd8e66bcac5a65, 0x0,
    0x3f94bb31ffa76b71, 0x0,
    0x3fe204ac0caf51ed, 0x0,
    0x3fe51b5972268609, 0x0,
    0x3fde531e9568be10, 0x0,
    0xbfb06d6d20f93ba6, 0x0,
    0xbfe0871dac6dae14, 0x0,
    0xbfe700e3e0cb81ba, 0x0,
    0xbfe04b14920372bf, 0x0,
    0x3fbc02551bf48985, 0x0,
    0x3fe0e8fb4160b69d, 0x0,
    0x3fe633089ce154ae, 0x0,
    0x3fdf891b2ce98a3c, 0x0,
    0xbf9d542dca66717f, 0x0,
    0xbfe0d04db03891c0, 0x0,
    0xbfe7849310a629c8, 0x0,
    0xbfde0faa8f18f6af, 0x0,
    0x3f9d64f19ca3916f, 0x0,
    0x3fdd66f34795fdca, 0x0,
    0x3fe43a7d9419af8e, 0x0,
    0x3fde583062aa0b5b, 0x0,
    0x3fb9589986d2ab7c, 0x0,
    0xbfdef538d14d289a, 0x0,
    0xbfe618f8fdc3052b, 0x0,
    0xbfe0d925b04e7414, 0x0,
    0xbfb1a39b46c5ade5, 0x0,
    0x3fdea3ff9555f427, 0x0,
    0x3fe579e47fdeee50, 0x0,
    0x3fdc8fc131d1a1cd, 0x0,
    0xbfb74619bd326cf4, 0x0,
    0xbfe0e684a9e51bdc, 0x0,
    0xbfe674478ca05802, 0x0,
    0xbfe13726ea5ad5cb, 0x0,
    0xbfa7f2d67bd33d5e, 0x0,
    0x3fe0f6eebc16449a, 0x0,
    0x3fe59d973fe8ad91, 0x0,
    0x3fd98967faed4875, 0x0,
    0x3f954db819fad44f, 0x0,
    0xbfe0ef4c1bf72b10, 0x0,
    0xbfe70b1ea5a66a90, 0x0,
    0xbfdc32fc84304f66, 0x0,
    0xbfa7b2987553783a, 0x0,
    0x3fdc1c160acd1f3f, 0x0,
    0x3fe68fdaa87fd174, 0x0,
    0x3fe20e283ad1ed2f, 0x0,
    0x3f5254c240d2af50, 0x0,
    0xbfe0023cb0d48128, 0x0,
    0xbfe47107c9bbc58e, 0x0,
    0xbfde08b004c6d3f0, 0x0,
    0xbf9c7d8b3b1a7fef, 0x0,
    0x3fdad6359264fba4, 0x0,
    0x3fe72ba4e787ef3e, 0x0,
    0x3fdf94d8ccd990a6, 0x0,
    0xbf9c8c8159fb4a41, 0x0,
    0xbfe0277d07289676, 0x0,
    0xbfe6364d5339e5c1, 0x0,
    0xbfe107356fd4f7ed, 0x0,
    0xbfac6948c546d02a, 0x0,
    0x3fe0c97419a398b6, 0x0,
    0x3fe63d9cba92ed94, 0x0,
    0x3fde7a03f8bb1ec5, 0x0,
    0x3f857a84950d6491, 0x0,
    0xbfe2cb64dddb2a30, 0x0,
    0xbfe6ff011cd02dc5, 0x0,
    0xbfe06810b3170699, 0x0,
    0x3fb42f241f5435e8, 0x0,
    0x3fe01744f45a8943, 0x0,
    0x3fe5ea012bfd98b8, 0x0,
    0x3fe0ae3a329310b8, 0x0,
    0xbf68f7e7fdf21eea, 0x0,
    0xbfe003014beae16b, 0x0,
    0xbfe84e2ce57c8db3, 0x0,
    0xbfe070b061da08a7, 0x0,
    0x3fa824744c4f4a9a, 0x0,
    0x3fe097a3b0c8bc8e, 0x0,
    0x3fe60dbebb90ba3c, 0x0,
    0x3fdb07d6a9e15e01, 0x0,
    0xbfae507bc484ce4b, 0x0,
    0xbfe150d6e4f76982, 0x0,
    0xbfe85118eb8f0723, 0x0,
    0xbfde35377ff7e4c6, 0x0,
    0x3fa29df9a39f4757, 0x0,
    0x3fe1a4a522aef22e, 0x0,
    0x3fe7d731f6a47091, 0x0,
    0x3fdcbaed7c2ec7d1, 0x0,
    0xbf9002f1770cd3f8, 0x0,
    0xbfdc5aba76817440, 0x0,
    0xbfe6f4be0a6d15cf, 0x0,
    0xbfdf791c4cd69542, 0x0,
    0xbfb5567a9fc36e3a, 0x0,
    0x3fdd13727a5a24b0, 0x0,
    0x3fe4ca4bb55bb535, 0x0,
    0x3fe20c56376283a8, 0x0,
    0x3fa5c0aff8f4f45c, 0x0,
    0xbfe1855712e5af35, 0x0,
    0xbfe62dbd2be3b2bc, 0x0,
    0xbfe01c7ced8624ac, 0x0,
    0x3fb73d7614edd09c, 0x0,
    0x3fdf891e0fea2223, 0x0,
    0x3fe6c79a5ecbe911, 0x0,
    0x3fe00b508cc03b04, 0x0,
    0xbf98b65daa21ee54, 0x0,
    0xbfdfebd86e29001a, 0x0,
    0xbfe69c7d30981c9d, 0x0,
    0xbfdc0e0719cf4903, 0x0,
    0xbf932cd7da067b02, 0x0,
    0x3fe16be053960913, 0x0,
    0x3fe5d8021a84dd36, 0x0,
    0x3fe0feec656366d0, 0x0,
    0x3f9b76c2d7d2d96b, 0x0,
    0xbfd91ce03b0fbb44, 0x0,
    0xbfe506600fd25f73, 0x0,
    0xbfde684da6f5941d, 0x0,
    0xbf7020480ffd4bdc, 0x0,
    0x3fda699fd2655041, 0x0,
    0x3fe7936d153a70ff, 0x0,
    0x3fd8574e86b94aaa, 0x0,
    0x3f86bbab95449959, 0x0,
    0xbfdc449c8d36051c, 0x0,
    0xbfe82c3289215b4a, 0x0,
    0xbfdeb109c07ed1bc, 0x0,
    0x3fa0ebd53d8e35cc, 0x0,
    0x3fdb641d870484e0, 0x0,
    0x3fe76706251a8019, 0x0,
    0x3fe11fa3ef6c4d70, 0x0,
    0xbfa7845f1e05ee6c, 0x0,
    0xbfe0fd4b8fba6cc1, 0x0,
    0xbfe75769a3e6f120, 0x0,
    0xbfe1269401c524cb, 0x0,
    0x3fbcdcc3c96c9835, 0x0,
    0x3fded3ae8953f2c1, 0x0,
    0x3fe5655482e6de28, 0x0,
    0x3fde2ee4bd93dcb4, 0x0,
    0x3fad96c3cfd1c748, 0x0,
    0xbfe12a14c5dbcc1f, 0x0,
    0xbfe5fc73dbd64941, 0x0,
    0xbfe2be83200f2a68, 0x0,
    0x3faa4d39c66e53a5, 0x0,
    0x3fdd080c8f3e885c, 0x0,
    0x3fe547388fcfe564, 0x0,
    0x3fddf44c4d76062d, 0x0,
    0xbfa171c86ee2776e, 0x0,
    0xbfdc4fe374661949, 0x0,
    0xbfe52fb5c635bf9f, 0x0,
    0xbfdfe8bf1031e7b9, 0x0,
    0x3fa395de386168e1, 0x0,
    0x3fe0e7e31f467bf7, 0x0,
    0x3fe6efcd381198c7, 0x0,
    0x3fe1f4dc9d9b1568, 0x0,
    0x3fa17e6d81e326a7, 0x0,
    0xbfd90b0140096d02, 0x0,
    0xbfe657b5250ab18b, 0x0,
    0xbfdd88de1540dd8b, 0x0,
    0xbfa11cfa7b4a0477, 0x0,
    0x3fe0b4995ec4426e, 0x0,
    0x3fe7342bfec875bc, 0x0,
    0x3fe306178cbe29da, 0x0,
    0x3fb3fff41c9ed8d9, 0x0,
    0xbfde29b4c81f682f, 0x0,
    0xbfe9ee930aa352e3, 0x0,
    0xbfe056798239e09f, 0x0,
    0xbfb10677eae359d5, 0x0,
    0x3fe0df9de79ae222, 0x0,
    0x3fe6bfa05ffb9bbe, 0x0,
    0x3fdc6d7a0ae5a008, 0x0,
    0x3f99427b82f560df, 0x0,
    0xbfe1984b6c9e2ba2, 0x0,
    0xbfe6550a8c63e762, 0x0,
    0xbfded57fe04809d8, 0x0,
    0xbfc1287bff631e96, 0x0,
    0x3fddaf72d142df87, 0x0,
    0x3fe3dc7b4343cfd4, 0x0,
    0x3fdb5354718d695a, 0x0,
    0x3fb964763f07f16c, 0x0,
    0xbfdeacf4304c1690, 0x0,
    0xbfe6f5897bfbb1df, 0x0,
    0xbfe292ae25a9de77, 0x0,
    0xbfa06faccca5de53, 0x0,
    0x3fdb8faad356dab6, 0x0,
    0x3fe899575308d2cc, 0x0,
    0x3fe1da0de87cf24f, 0x0,
    0xbfc0ec2535a85ac7, 0x0,
    0xbfdc84f749bddd75, 0x0,
    0xbfe6a087d69dce6d, 0x0,
    0xbfda3722a5d476b6, 0x0,
    0xbf77fce9413be5b6, 0x0,
    0x3fdfb452d90ab30b, 0x0,
    0x3fe4f892dfede68f, 0x0,
    0x3fdfc87ef644426d, 0x0,
    0xbfb2c4a8fb176c58, 0x0,
    0xbfe340baa571398e, 0x0,
    0xbfe60472cdc19247, 0x0,
    0xbfe0029a468b68e5, 0x0,
    0xbfabc7ca929cf33b, 0x0,
    0x3fd8f4f310a4c9c2, 0x0,
    0x3fe6cc23b5a8b3a8, 0x0,
    0x3fe053736c7f7492, 0x0,
    0xbf5686d4c1e196be, 0x0,
    0xbfdcaf6753a2930d, 0x0,
    0xbfe6a74b3a9d88e4, 0x0,
    0xbfdce3b0c018cb41, 0x0,
    0xbf748d7f31a9f520, 0x0,
    0x3fe0799ed9bc8592, 0x0,
    0x3fe5595b09ad48fc, 0x0,
    0x3fde323998c7831d, 0x0,
    0x3fb8278d0b8dcd77, 0x0,
    0xbfdbbed161caee86, 0x0,
    0xbfe714dc000cfeba, 0x0,
    0xbfe020f72584bdcc, 0x0,
    0xbf81c9aef984774b, 0x0,
    0x3fe099f6d72073d1, 0x0,
    0x3fea94c1d44e7702, 0x0,
    0x3fda412a6bb2994e, 0x0,
    0x3f9b3dd7df83a7aa, 0x0,
    0xbfe122b50da78909, 0x0,
    0xbfe6410fffc5cea0, 0x0,
    0xbfe015c228e527f6, 0x0,
    0xbf91d98476cf8c0b, 0x0,
    0x3fe099383d34d202, 0x0,
    0x3fe6e2df4f224d1a, 0x0,
    0x3fe0e6bf1cfc0624, 0x0,
    0x3f9e43bc1476db23, 0x0,
    0xbfe06dda4ac06f18, 0x0,
    0xbfe5a2894117f0bc, 0x0,
    0xbfe064ae95680042, 0x0,
    0x3f892ec010527bac, 0x0,
    0x3fe04890941fbe20, 0x0,
    0x3fe5d2eabc275e41, 0x0,
    0x3fdd21af883cd122, 0x0,
    0xbfb17072663aac13, 0x0,
    0xbfdd07217f8e0b83, 0x0,
    0xbfe7baef0844337f, 0x0,
    0xbfe18ffe5a00f19d, 0x0,
    0x3fb24b21957cbbd2, 0x0,
    0x3fe103cd5f4ae707, 0x0,
    0x3fe566bebe2e67cf, 0x0,
    0x3fdf9dc943ccf6d7, 0x0,
    0xbfc1f26804a3af66, 0x0,
    0xbfdc453c78118b47, 0x0,
    0xbfe418b7821fd165, 0x0,
    0xbfdf2cf1e3ea436a, 0x0,
    0xbf80c048b330ed90, 0x0,
    0x3fda023ba36c2da8, 0x0,
    0x3fe8095791ec5607, 0x0,
    0x3fe1dad2192ba9f8, 0x0,
    0x3f9b2d89ece9e288, 0x0,
    0xbfe0227167b363fc, 0x0,
    0xbfe57f03f3001127, 0x0,
    0xbfdd3ca8f1ce644e, 0x0,
    0xbf58a3a3bb832a1e, 0x0,
    0x3fdf9fe60587675c, 0x0,
    0x3fe80cecd749a688, 0x0,
    0x3fe013168ba2b376, 0x0,
    0x3f7d6de07272775d, 0x0,
    0xbfd9871cb7e14bbe, 0x0,
    0xbfe6792d4869e059, 0x0,
    0xbfdd3cfbe79ecfd8, 0x0,
    0xbfb60dff6b0c156e, 0x0,
    0x3fdf02f2175d8853, 0x0,
    0x3fe4e4b7aabd4840, 0x0,
    0x3fe29b7c9e5537ba, 0x0,
    0x3fa7680c57a62561, 0x0,
    0xbfdcd9b673f59428, 0x0,
    0xbfe5d1ab43313fb1, 0x0,
    0xbfd9a3dcad9f8cdb, 0x0,
    0xbfabe583e5fffb59, 0x0,
    0x3fdd8f8d00677b80, 0x0,
    0x3fe8000ed8788483, 0x0,
    0x3fe1a43d177ee3c0, 0x0,
    0x3f924ee856aea06e, 0x0,
    0xbfe096630cbae0e0, 0x0,
    0xbfe52af50f545b24, 0x0,
    0xbfd9a0c521d88b18, 0x0,
    0xbf89d4e52b16fac0, 0x0,
    0x3fe0f054993518f0, 0x0,
    0x3fe60c3ae14a36ac, 0x0,
    0x3fddccab5c0d00c2, 0x0,
    0x3f71792666d6019a, 0x0,
    0xbfe0d00d070b7189, 0x0,
    0xbfe9109e1745ff39, 0x0,
    0xbfe0229b40a492e8, 0x0,
    0x3f9ac14cae186c7b, 0x0,
    0x3fe26816d69d5dc8, 0x0,
    0x3fe7a4ee7067e634, 0x0,
    0x3fe138e16b5a31b5, 0x0,
    0x3fb5c7afc62f7373, 0x0,
    0xbfdc5f9ae6d4ae22, 0x0,
    0xbfe6693b3400160a, 0x0,
    0xbfe1f090e59cde59, 0x0,
    0xbfa8834026848d31, 0x0,
    0x3fde031c17328561, 0x0,
    0x3fe76ea66a2d01c7, 0x0,
    0x3fdfa0ec70d91943, 0x0,
    0x3f9456ad18f738b6, 0x0,
    0xbfdb89b056ccff34, 0x0,
    0xbfe88924cf2974f6, 0x0,
    0xbfdc26d9c82cf487, 0x0,
    0xbfa483b95b0d301f, 0x0,
    0x3fdd369afaf46891, 0x0,
    0x3fe791897f445e4b, 0x0,
    0x3fe0efc8534d8cdb, 0x0,
    0x3f597cea8a381e9e, 0x0,
    0xbfe0a4d5edff321d, 0x0,
    0xbfe6a9e1ded9f60f, 0x0,
    0xbfe153ef4032e832, 0x0,
    0xbfa1d7db939b3332, 0x0,
    0x3fdd1f88d49d7244, 0x0,
    0x3fe60d8c357693a1, 0x0,
    0x3fdfe1579da8bac0, 0x0,
    0xbf80caa169d3a29d, 0x0,
    0xbfdf7f8bab82e619, 0x0,
    0xbfe5f9e8be73f89e, 0x0,
    0xbfdd7373ef0c1720, 0x0,
    0x3fb79d27b512dc98, 0x0,
    0x3fe112f1893fd331, 0x0,
    0x3fe791a4fa5dfaf9, 0x0,
    0x3fdfe006cd662b42, 0x0,
    0x3fa85dc6b9b246b9, 0x0,
    0xbfe0fd663c7da000, 0x0,
    0xbfe67c0139714c0e, 0x0,
    0xbfe1b651d509b1d5, 0x0,
    0x3f902033d1a4b15b, 0x0,
    0x3fde8b99c107cc47, 0x0,
    0x3fe778a2f93fa572, 0x0,
    0x3fe12b87fadb40b3, 0x0,
    0x3f8c9bd47bf205f4, 0x0,
    0xbfe1f261b2df8f21, 0x0,
    0xbfe5fb09b7e57f3f, 0x0,
    0xbfdf2476c200ce3b, 0x0,
    0x3f8b073c14b943a7, 0x0,
    0x3fde38f9ee45591e, 0x0,
    0x3fe73dac005c02c0, 0x0,
    0x3fe08bbffc7f2844, 0x0,
    0xbf8d22bb3fe8d4c9, 0x0,
    0xbfe000fefc58c0df, 0x0,
    0xbfe96e2d37c77049, 0x0,
    0xbfdd0b83309ff309, 0x0,
    0xbfb2ebc08a7fbe99, 0x0,
    0x3fe1c8e85a60ae30, 0x0,
    0x3fe7a772295d2e7f, 0x0,
    0x3fda2b9f41eca7d2, 0x0,
    0x3f97a36d89771819, 0x0,
    0xbfe13c4902472095, 0x0,
    0xbfe7385c0407bd6a, 0x0,
    0xbfe228bf190f4f25, 0x0,
    0xbfaad26e825e413b, 0x0,
    0x3fe0108cda683597, 0x0,
    0x3fe583cd4b56ce2e, 0x0,
    0x3fd8fdfc9c97012a, 0x0,
    0x3f82314b4a95e847, 0x0,
    0xbfe01f18ff3f2999, 0x0,
    0xbfe4ad636b513e63, 0x0,
    0xbfdefa80fca441bb, 0x0,
    0x3eee0b25dd4fb049, 0x0,
    0x3fe0b88293dc2dde, 0x0,
    0x3fe4731a71402a91, 0x0,
    0x3fde6b0ab6cf97c9, 0x0,
    0x3fa3a29666cb09b5, 0x0,
    0xbfda3a77dd9e0ac1, 0x0,
    0xbfe491bc828d3fd5, 0x0,
    0xbfdcb404100cd730, 0x0,
    0xbf8e4a347b0195fb, 0x0,
    0x3fddc5913ef4fbde, 0x0,
    0x3fe3629aaf0741b1, 0x0,
    0x3fde97e3647e4793, 0x0,
    0xbfabab198bb30686, 0x0,
    0xbfdddcf0e2422978, 0x0,
    0xbfe50a4b9471e5b2, 0x0,
    0xbfddd9b9414f8b53, 0x0,
    0x3f865d200b3fdf5f, 0x0,
    0x3fe0d6e79edf6674, 0x0,
    0x3fe6032a3d072ceb, 0x0,
    0x3fde34b208701cf2, 0x0,
    0xbfa3c61794988c8a, 0x0,
    0xbfe2822fc889e895, 0x0,
    0xbfe80827ec5e16bc, 0x0,
    0xbfdfeda548b94712, 0x0,
    0xbf8d2f6760da0ac7, 0x0,
    0x3fe08e3b54cf09f5, 0x0,
    0x3fe9abb539354f23, 0x0,
    0x3fde60d8c6bd5a62, 0x0,
    0xbf9eac18924f0db6, 0x0,
    0xbfe000bbb5f080c2, 0x0,
    0xbfe600e05cc65080, 0x0,
    0xbfdbe25e20dc9a86, 0x0,
    0xbfb1dff0d49d5913, 0x0,
    0x3fd9fd6107b2b842, 0x0,
    0x3fe45cd94640add3, 0x0,
    0x3fdd9d7a54e64687, 0x0,
    0x3f9a36c1f0bec9a8, 0x0,
    0xbfe244107ea70efc, 0x0,
    0xbfe76dd13cce9450, 0x0,
    0xbfde0d605825fe5f, 0x0,
    0xbfb3afdbb69d8c65, 0x0,
    0x3fe074da2b296e5c, 0x0,
    0x3fe85050c08863c7, 0x0,
    0x3fde0b6b5cd707bd, 0x0,
    0x3fa7df54fe8bc16b, 0x0,
    0xbfe0d0dea3123a78, 0x0,
    0xbfe66bdded3eacd4, 0x0,
    0xbfddc4b3d4e0a0bb, 0x0,
    0xbfb0688093024e44, 0x0,
    0x3fdd93ed1533da13, 0x0,
    0x3fe5a36d3a361da0, 0x0,
    0x3fe02d39f32fc344, 0x0,
    0x3fb362519791c3d2, 0x0,
    0xbfd80cf2b81e8fdc, 0x0,
    0xbfe3b83bcd4da228, 0x0,
    0xbfe28d4727fb0099, 0x0,
    0xbfaaf1dd47ca2b36, 0x0,
    0x3fda6129c282eb78, 0x0,
    0x3fe61f3e30e948ff, 0x0,
    0x3fde19712fd3d42a, 0x0,
    0x3fb46805ec11403d, 0x0,
    0xbfde3e726648f772, 0x0,
    0xbfe48b550d1bc857, 0x0,
    0xbfdefda0eeaa5387, 0x0,
    0xbfb735eb7f7a41ad, 0x0,
    0x3fd8f2d818bfd92f, 0x0,
    0x3fe6688f22e65492, 0x0,
    0x3fe029e221cd455f, 0x0,
    0xbf867090a84977b9, 0x0,
    0xbfe208c3522acf8d, 0x0,
    0xbfe84c929be59e66, 0x0,
    0xbfdfa24af2ef1534, 0x0,
    0x3f9fe677f1ad0cb7, 0x0,
    0x3fe22ea99a0761c1, 0x0,
    0x3fe5498ef10c0b13, 0x0,
    0x3fdfeb2872a69795, 0x0,
    0xbfb3a5a41ef0ed31, 0x0,
    0xbfdfe61c5ab2571c, 0x0,
    0xbfe56c9f3a0a7cc7, 0x0,
    0xbfe0dd5ab36eef35, 0x0,
    0x3f7613a372354327, 0x0,
    0x3fde0ac0e7224832, 0x0,
    0x3fe5700aa5c8632f, 0x0,
    0x3fe1182da1985aab, 0x0,
    0xbfa45cc57b77bc33, 0x0,
    0xbfe2fa6e5deb8e3e, 0x0,
    0xbfe5e1b7563e436c, 0x0,
    0xbfdeb514a891afc9, 0x0,
    0xbf8a72adee709c65, 0x0,
    0x3fdf4aa6469da892, 0x0,
    0x3fe8b7b989024759, 0x0,
    0x3fe0a689a5d4072c, 0x0,
    0xbfba3b6f896609a5, 0x0,
    0xbfe070a93c4869b6, 0x0,
    0xbfe405ecf3293fa4, 0x0,
    0xbfe039a44a1224c5, 0x0,
    0xbfa9311dc3d74f40, 0x0,
    0x3fe08324784e3c05, 0x0,
    0x3fe33d005f86fb3d, 0x0,
    0x3fe0c8aa5a916a90, 0x0,
    0xbf67d8a1696afd99, 0x0,
    0xbfe13024f04e62ce, 0x0,
    0xbfe56535b0216a94, 0x0,
    0xbfddb1b133a69be9, 0x0,
    0x3f9fdf9b010b1c56, 0x0,
    0x3fdd6396c2c7e158, 0x0,
    0x3fe4437813413ba8, 0x0,
    0x3fe195e80b40dacb, 0x0,
    0x3f368a65d9499a71, 0x0,
    0xbfdcc1b610e90522, 0x0,
    0xbfe65a90d020392b, 0x0,
    0xbfe02b35123ffb4c, 0x0,
    0x3f8aef0c138fc3eb, 0x0,
    0x3fdf8d0212914b35, 0x0,
    0x3fe7d49d1abafea1, 0x0,
    0x3fdda8f599802d49, 0x0,
    0xbfa2096ebc98cb91, 0x0,
    0xbfdcdb788c414de7, 0x0,
    0xbfe2e50163c6b7dc, 0x0,
    0xbfdbc46e3bc76e5b, 0x0,
    0xbf941bf7af039712, 0x0,
    0x3fdf5c5533554c48, 0x0,
    0x3fe6e480cc35f5f6, 0x0,
    0x3fdf3c59c00c951b, 0x0,
    0xbf81ce247ee5d422, 0x0,
    0xbfdcfab6bc7f559b, 0x0,
    0xbfe54a906e81cd95, 0x0,
    0xbfe0bf15fecf3548, 0x0,
    0x3fab1cde640ca664, 0x0,
    0x3fdf1732bd0187e1, 0x0,
    0x3fe2abbed3549bd8, 0x0,
    0x3fe089412fb1b32b, 0x0,
    0xbf664275a20e24bc, 0x0,
    0xbfe0de252c0a5a74, 0x0,
    0xbfe4423e3d3102ff, 0x0,
    0xbfdee04ab9b2e102, 0x0,
    0xbfb094d3e1a4ca92, 0x0,
    0x3fdd902f5aeb6905, 0x0,
    0x3fe790679e41000d, 0x0,
    0x3fe0246717c89656, 0x0,
    0x3f979fc5ba025102, 0x0,
    0xbfddad144f560e3f, 0x0,
    0xbfe6f591f8762dcf, 0x0,
    0xbfde3c9db3c045b3, 0x0,
    0xbf83ae7bc8aaf8fd, 0x0,
    0x3fe24cd2681a922f, 0x0,
    0x3fe76bb276d6697a, 0x0,
    0x3fdf169c1c93aa24, 0x0,
    0x3f84faf439bf0e91, 0x0,
    0xbfdca246d78914f7, 0x0,
    0xbfe5e8e9cd86f9cc, 0x0,
    0xbfdfa45af2e3be84, 0x0,
    0x3fa69eee6715d452, 0x0,
    0x3fdeec04778f9ea1, 0x0,
    0x3fe4ed2bdba0bba4, 0x0,
    0x3fe07a3de8cf345f, 0x0,
    0xbfb03783bb0aad0b, 0x0,
    0xbfe15bc786d647d7, 0x0,
    0xbfe6b2640823b801, 0x0,
    0xbfdc47f6da046796, 0x0,
    0x3fb29622958c8e2e, 0x0,
    0x3fde5f9dda288800, 0x0,
    0x3fe6f9f85c4c4e54, 0x0,
    0x3fe02f0d9ab2e2d1, 0x0,
    0xbfb531e856bfb8dd, 0x0,
    0xbfdf8105397d56fe, 0x0,
    0xbfe4ed59f8f48b2a, 0x0,
    0xbfe1a65ce609df0a, 0x0,
    0xbf9e2f733cd9d355, 0x0,
    0x3fe21f11a70d978c, 0x0,
    0x3fe555773f29d975, 0x0,
    0x3fdb8e732cf9a772, 0x0,
    0x3fa6de43740ee3b7, 0x0,
    0xbfde5c178fe2c0b3, 0x0,
    0xbfe53ad1ed5837d0, 0x0,
    0xbfe15e7046ef594e, 0x0,
    0x3fa4f2a480878f3e, 0x0,
    0x3fe06602bfc2fedc, 0x0,
    0x3fe7f4d15b5d1bf7, 0x0,
    0x3fe14a43d9cc54f8, 0x0,
    0x3fb562f5bedc905a, 0x0,
    0xbfdfc7f4c4f435ff, 0x0,
    0xbfe817e0ab760ab7, 0x0,
    0xbfe037defc61443a, 0x0,
    0x3fc2ce276c57920f, 0x0,
    0x3fdb6034632bc682, 0x0,
    0x3fe5c88b6d98c48d, 0x0,
    0x3fe029c99b2c08a9, 0x0,
    0xbfb1506f5a044847, 0x0,
    0xbfe0b85dcbb28e09, 0x0,
    0xbfe7338eb9d8b146, 0x0,
    0xbfe0574c3ed5762f, 0x0,
    0x3fa156143e459403, 0x0,
    0x3fe00ed288f5556b, 0x0,
    0x3fe6b213c3b090d7, 0x0,
    0x3fe0947e4e4bfa75, 0x0,
    0x3f89e4efb5ce4076, 0x0,
    0xbfdf787db7340cb6, 0x0,
    0xbfe66dc4ab2a4cb8, 0x0,
    0xbfddb700b0e96534, 0x0,
    0x3f68fa0c0958c83f, 0x0,
    0x3fe079c25e16d44c, 0x0,
    0x3fe5d9332e143ebb, 0x0,
    0x3fe42df1f9d372d5, 0x0,
    0x3fa2534b5ff101d5, 0x0,
    0xbfde2a499624dcd8, 0x0,
    0xbfe5f61578939aaf, 0x0,
    0xbfdb843f07583c9d, 0x0,
    0xbfbb914b6f4b5348, 0x0,
    0x3fdfe7f4b3f35d43, 0x0,
    0x3fe5e393ae4a29a5, 0x0,
    0x3fdf730384f4c7d1, 0x0,
    0x3f93e738b4dbb9ca, 0x0,
    0xbfddea9509c6a887, 0x0,
    0xbfe1fa8ab98323ef, 0x0,
    0xbfe07752941694d3, 0x0,
    0x3f89a4e01f7c0a5a, 0x0,
    0x3fdb24623b21857d, 0x0,
    0x3fe1c3752030b252, 0x0,
    0x3fe1054fe13f0ece, 0x0,
    0xbf9454472aa5ecc6, 0x0,
    0xbfe1238630de6588, 0x0,
    0xbfe66f2081385a96, 0x0,
    0xbfdcac4d9d3e3080, 0x0,
    0xbf92d46bd743ac14, 0x0,
    0x3fdbfd636936d01c, 0x0,
    0x3fe76a18a3ee0371, 0x0,
    0x3fe0e364bb0337a3, 0x0,
    0xbf80462bb7bfc36a, 0x0,
    0xbfe1bd9a91845aea, 0x0,
    0xbfe70669b3957adb, 0x0,
    0xbfe02842ee73178e, 0x0,
    0xbf490bec25e1b295, 0x0,
    0x3fe29908eeebf9c4, 0x0,
    0x3fe95578a7106e3c, 0x0,
    0x3fe2b1a29d09219f, 0x0,
    0x3f6f8905631bbce1, 0x0,
    0xbfde755991d2fc0a, 0x0,
    0xbfe3ea8c74ff41c0, 0x0,
    0xbfdda8dde1a9fba2, 0x0,
    0x3fb26a3153a53ec7, 0x0,
    0x3fe02e112ba60cba, 0x0,
    0x3fe7f9063e444d23, 0x0,
    0x3fe231d0ac5478cf, 0x0,
    0x3fba59b28d15de43, 0x0,
    0xbfdf7e52190c9285, 0x0,
    0xbfe80c38ec2ab7e6, 0x0,
    0xbfe0d0573c20c609, 0x0,
    0xbf62157d9a7bfbb9, 0x0,
    0x3fe20832b6948cd6, 0x0,
    0x3fe684069116d05d, 0x0,
    0x3fe1a84eeaf8b36e, 0x0,
    0x3fb27e74e145aaef, 0x0,
    0xbfe067d26e8ef231, 0x0,
    0xbfe3880162c89f74, 0x0,
    0xbfe1b57190683077, 0x0,
    0x3fa10f9bc69c1300, 0x0,
    0x3fe0470e6c0efc49, 0x0,
    0x3fe348c1ca1c4c97, 0x0,
    0x3fdfcd347f2e586e, 0x0,
    0xbfa242237ee93f9f, 0x0,
    0xbfe14c1e22579059, 0x0,
    0xbfe608b423b507c4, 0x0,
    0xbfe093f3a537cd17, 0x0,
    0x3fb194b134a2a854, 0x0,
    0x3fe0b6df3df45a6a, 0x0,
    0x3fe70ac8a442ba67, 0x0,
    0x3fe03dad96b066c9, 0x0,
    0x3fa6ee0a5bfe9685, 0x0,
    0xbfdb73980491769b, 0x0,
    0xbfe8a967e7b577af, 0x0,
    0xbfdf1c6e5f550570, 0x0,
    0x3fb5c6d32c202650, 0x0,
    0x3fdef78c02f7d951, 0x0,
    0x3fe71e05f15a501e, 0x0,
    0x3fdaffba0f97278b, 0x0,
    0xbf6584837dc36ae1, 0x0,
    0xbfddad738dcbeaeb, 0x0,
    0xbfe7319a3bcd1950, 0x0,
    0xbfe0b85f0fa60e9d, 0x0,
    0xbfa07aed6a73c32c, 0x0,
    0x3fd61f11427a2262, 0x0,
    0x3fe8898522fe99a8, 0x0,
    0x3fdec0974a414eb3, 0x0,
    0x3fa3e3393c9c81bc, 0x0,
    0xbfdd105b2c69c96e, 0x0,
    0xbfe73128ee094e0c, 0x0,
    0xbfe108b885106a27, 0x0,
    0x3fa32507f59339d9, 0x0,
    0x3fdecf4e305b76e9, 0x0,
    0x3fe3a5bc589911ee, 0x0,
    0x3fe1a84988ae94a6, 0x0,
    0x3f98ab1d575cbe32, 0x0,
    0xbfde6393b077a85c, 0x0,
    0xbfe517629cee09c5, 0x0,
    0xbfe13907e0348c98, 0x0,
    0x3f5168ea6372a23b, 0x0,
    0x3fde2a65b558e1af, 0x0,
    0x3fe846cca9da2783, 0x0,
    0x3fd89eacc49dcb7a, 0x0,
    0x3f9ecad963756ed0, 0x0,
    0xbfdce6428370be93, 0x0,
    0xbfe59f6b93099782, 0x0,
    0xbfdee8ca2d449d92, 0x0,
    0x3fb0079bed7df5bf, 0x0,
    0x3fe3690eb01278a7, 0x0,
    0x3fe757de549c0eb8, 0x0,
    0x3fe0f61d3475d97a, 0x0,
    0xbfa457d668ee6c66, 0x0,
    0xbfdd0dba8069b9b8, 0x0,
    0xbfe5fdc0f0c7ddbc, 0x0,
    0xbfe197d81b239f2b, 0x0,
    0xbf8ba2f73223790c, 0x0,
    0x3fe147bf4d82a818, 0x0,
    0x3fe6f44109438898, 0x0,
    0x3fdf958f96be7683, 0x0,
    0xbfa87c01253a1475, 0x0,
    0xbfdc1d6bb2364cec, 0x0,
    0xbfe5510790dbf971, 0x0,
    0xbfe1243e3f00478f, 0x0,
    0x3f8269465cb79606, 0x0,
    0x3fdd7eb2dba792ba, 0x0,
    0x3fe54dff591d7054, 0x0,
    0x3fdb3c9ce276c590, 0x0,
    0xbfae4770ee1d27fd, 0x0,
    0xbfde214768e47315, 0x0,
    0xbfe67b982089a009, 0x0,
    0xbfe093b63428bb0c, 0x0,
    0xbfb872f72026bca6, 0x0,
    0x3fe0be04fc8ae49d, 0x0,
    0x3fe4e560f14b8b93, 0x0,
    0x3fdda1f6dba73f0e, 0x0,
    0x3fa68a82e35ea511, 0x0,
    0xbfdb85a960e54c08, 0x0,
    0xbfe55e649f2d8c3a, 0x0,
    0xbfe2a7f263da69c9, 0x0,
    0xbf9b209a7ff475cd, 0x0,
    0x3fe08fb017bbd7c1, 0x0,
    0x3fe64638c1762361, 0x0,
    0x3fdf2caa83f44304, 0x0,
    0xbf2c8dbb5cf095fb, 0x0,
    0xbfe1e328de956958, 0x0,
    0xbfe31ce4b4fb68f2, 0x0,
    0xbfe21ef678627e52, 0x0,
    0xbf21e5bff25bf7e7, 0x0,
    0x3fdb5a223a27ce6f, 0x0,
    0x3fe598d7347029b7, 0x0,
    0x3fdde5dea2234e2d, 0x0,
    0xbf79969f0e42b7e8, 0x0,
    0xbfdee97e80d74332, 0x0,
    0xbfe5dcf081b38b29, 0x0,
    0xbfdd90e21b3045a4, 0x0,
    0x3fc62b46cc8ccdaf, 0x0,
    0x3fe18f5e4c43d628, 0x0,
    0x3fe9503ddb72c05d, 0x0,
    0x3fe37973234e5f8a, 0x0,
    0xbf8fb0e1a783beed, 0x0,
    0xbfe251ef393c7bee, 0x0,
    0xbfe3994484415bc9, 0x0,
    0xbfdde60c1435ac47, 0x0,
    0xbf818711c9056576, 0x0,
    0x3fdd75e1fc8557e9, 0x0,
    0x3fe6be2a269f640e, 0x0,
    0x3fe15a1e3566bda7, 0x0,
    0x3fa31f9f65fac4a4, 0x0,
    0xbfe164d7546ce0d1, 0x0,
    0xbfe4196a91b1314f, 0x0,
    0xbfe10bb6ccc44b98, 0x0,
    0xbf931b2543d5bc96, 0x0,
    0x3fde5253522ffe34, 0x0,
    0x3fe7b797f4a067e9, 0x0,
    0x3fd704f9c9d4c262, 0x0,
    0xbfa5e267650abe01, 0x0,
    0xbfe0ed4435ac78b5, 0x0,
    0xbfe78347683436bc, 0x0,
    0xbfddd7d683346c7c, 0x0,
    0x3fb0972fb5fcdbaa, 0x0,
    0x3fe1436a59cc186b, 0x0,
    0x3fe47694ee9f64a5, 0x0,
    0x3fe101d9dd3c3c1d, 0x0,
    0xbf8b338366c6e714, 0x0,
    0xbfdc9477be3e6e86, 0x0,
    0xbfe7b3c6c35d9f84, 0x0,
    0xbfde69a1ff64d990, 0x0,
    0xbf8a2a3a56d4e637, 0x0,
    0x3fddabdac40e289a, 0x0,
    0x3fe63a9f9a5e8b73, 0x0,
    0x3fe05d32944dae6f, 0x0,
    0x3f80bf073c8220b2, 0x0,
    0xbfda6ebce33fb2bd, 0x0,
    0xbfe64ca34a89b2bc, 0x0,
    0xbfe20d95622831c5, 0x0,
    0x3fac79222046541a, 0x0,
    0x3fe1b107d923a1bf, 0x0,
    0x3fe68d404e231b41, 0x0,
    0x3fe0ca2517d19276, 0x0,
    0x3f92d4a4cba17931, 0x0,
    0xbfe0246b8543ab26, 0x0,
    0xbfe65336c36bb569, 0x0,
    0xbfdd038680a21494, 0x0,
    0xbfa33edc3b698e0f, 0x0,
    0x3fdf757f36e682cc, 0x0,
    0x3fe68c1c6e3191a3, 0x0,
    0x3fe085197cba1521, 0x0,
    0xbf8d2a87461210c5, 0x0,
    0xbfe3981fe6f2bc2a, 0x0,
    0xbfe56238808f3242, 0x0,
    0xbfddc42efb7138db, 0x0,
    0xbf93ed09ffd0839c, 0x0,
    0x3fe0326013906bd7, 0x0,
    0x3fe31778d0e68156, 0x0,
    0x3fde4ddfca86f8dd, 0x0,
    0x3fb1e1e1de3e9363, 0x0,
    0xbfe0e5ec9814fad7, 0x0,
    0xbfe7fe6b846bf0b7, 0x0,
    0xbfde45c24756dc0b, 0x0,
    0x3fb8719b184f6cc4, 0x0,
    0x3fe22f883dd4ade6, 0x0,
    0x3fe75d8682ac66f6, 0x0,
    0x3fdcc6a13d33ee0f, 0x0,
    0x3fc5f0738baddcc4, 0x0,
    0xbfe01f3ce86a6307, 0x0,
    0xbfe5ef6ee92478e7, 0x0,
    0xbfdc89ab0d77d73c, 0x0,
    0x3f90798ff48ab724, 0x0,
    0x3fdcc528ddae8b7f, 0x0,
    0x3fe662118f31802a, 0x0,
    0x3fe17467e801b194, 0x0,
    0x3f98bf084dfc39c7, 0x0,
    0xbfdec1cd501834da, 0x0,
    0xbfe6e9c9dfc90273, 0x0,
    0xbfe2301703751b92, 0x0,
    0x3fb66a863aa7c47b, 0x0,
    0x3fddcfe55e7f0253, 0x0,
    0x3fea043b47a3be6e, 0x0,
    0x3fde3ccc897a5068, 0x0,
    0x3fbbabaa0afdfd16, 0x0,
    0xbfdec61f117a4990, 0x0,
    0xbfe90126d514c73f, 0x0,
    0xbfe1e5f3833d2d17, 0x0,
    0xbfb133b6568dca73, 0x0,
    0x3fe09b34f3993a95, 0x0,
    0x3fe467ec13cc1a76, 0x0,
    0x3fdce7591e022947, 0x0,
    0x3f9e4192df9af570, 0x0,
    0xbfe0010348ee9878, 0x0,
    0xbfe7c80c6be8407a, 0x0,
    0xbfdc2a44c697c3cb, 0x0,
    0x3fa58b1ba297e8f1, 0x0,
    0x3fdae7026e00e4f1, 0x0,
    0x3fe9ec31a9a7045a, 0x0,
    0x3fdf9b8f72c7f466, 0x0,
    0xbfac7093ae2de204, 0x0,
    0xbfdef06b2e068090, 0x0,
    0xbfe81c331ea8fac9, 0x0,
    0xbfd9fe25e7d0e4f6, 0x0,
    0x3f6aff70d92b98b4, 0x0,
    0x3fdf721c4b0c6ddb, 0x0,
    0x3fe75c6e68d6d9c3, 0x0,
    0x3fdcff8380ab35ab, 0x0,
    0xbf655d87723879cc, 0x0,
    0xbfe2acaf82c2d596, 0x0,
    0xbfe80eb1049ec09e, 0x0,
    0xbfdc0d82ce1ed3c0, 0x0,
    0xbf73230fecd83a84, 0x0,
    0x3fddb0b37506fc2d, 0x0,
    0x3fe5767d95f0a262, 0x0,
    0x3fe0b0de878e7010, 0x0,
    0xbfb01bb6d538e933, 0x0,
    0xbfe048466a1e6d21, 0x0,
    0xbfe96636095feade, 0x0,
    0xbfe12b1996b1f400, 0x0,
    0x3f93353ac391fa2f, 0x0,
    0x3fe1981bf4f5e70a, 0x0,
    0x3fe6fd475b449064, 0x0,
    0x3fdfa0362d94627c, 0x0,
    0x3fbfa465a5e2897c, 0x0,
    0xbfe14bdadaf28547, 0x0,
    0xbfe665585b5267be, 0x0,
    0xbfdf53e4fae38839, 0x0,
    0xbf8bd9183a15b8d5, 0x0,
    0x3fe134f98720e55f, 0x0,
    0x3fe6e6e312e61f47, 0x0,
    0x3fdba7eb1434ed64, 0x0,
    0x3f98fd3c25e7b535, 0x0,
    0xbfe2bec9dc2417fb, 0x0,
    0xbfe6959aa9e35706, 0x0,
    0xbfe125241c2ce80f, 0x0,
    0xbf9b9aa609411753, 0x0,
    0x3fdd3ba718ef1eb4, 0x0,
    0x3fe83bbaf8da17ac, 0x0,
    0x3fdb1b5d46507bc1, 0x0,
    0xbf966add151ffc95, 0x0,
    0xbfe0376b6b7625f7, 0x0,
    0xbfe74115c5b1e9e0, 0x0,
    0xbfe0a81a491c7967, 0x0,
    0x3f971029665b0e0c, 0x0,
    0x3fdfd5dc91d01af9, 0x0,
    0x3fe952bec923ee8a, 0x0,
    0x3fe1e599a7218538, 0x0,
    0xbfa73e865ddebd2d, 0x0,
    0xbfe02239ad8159dc, 0x0,
    0xbfead1d1655a061b, 0x0,
    0xbfe06962847e9b96, 0x0,
    0x3f995d39e0bf934a, 0x0,
    0x3fe260e8239b9ca8, 0x0,
    0x3fea021944c392ee, 0x0,
    0x3fe2d4447b9f75f2, 0x0,
    0xbf9412e1fe36ff74, 0x0,
    0xbfde286a3fa9b266, 0x0,
    0xbfe6eb135c104ccc, 0x0,
    0xbfdfbb23ebe1ef80, 0x0,
    0xbfa82eab467bdd16, 0x0,
    0x3fe03aad42ebf896, 0x0,
    0x3fe7139d4eb0ad97, 0x0,
    0x3fe102debee64f21, 0x0,
    0xbf94d95720630852, 0x0,
    0xbfe1611f5720a75d, 0x0,
    0xbfe39bece5fb75de, 0x0,
    0xbfde5493cc91ede7, 0x0,
    0x3f94f475f5c49009, 0x0,
    0x3fdbe475269c0880, 0x0,
    0x3fe691f10c9668b2, 0x0,
    0x3fddd7423c67b489, 0x0,
    0xbf6d0d32a4684bbe, 0x0,
    0xbfe3367b58309d4b, 0x0,
    0xbfe64f801b843d70, 0x0,
    0xbfe0e396c9761294, 0x0,
    0xbfa7461ab40d2a04, 0x0,
    0x3fdf561c75321afb, 0x0,
    0x3fe77a077bef6e40, 0x0,
    0x3fdfc1512a71cf61, 0x0,
    0xbf94c76712f54bc5, 0x0,
    0xbfe2706a9726a134, 0x0,
    0xbfe3bf43bd4f3804, 0x0,
    0xbfe082c1fa7d6430, 0x0,
    0xbfb1352601c6ef1d, 0x0,
    0x3fe0fa31c53a7ef4, 0x0,
    0x3fe913fb7768fc15, 0x0,
    0x3fdba4f7d732ae16, 0x0,
    0xbf8118ab24584d3d, 0x0,
    0xbfda66feea695abe, 0x0,
    0xbfe52a688a9693d9, 0x0,
    0xbfdb2e4f4725c029, 0x0,
    0xbf9cbd2068e9cad5, 0x0,
    0x3fdfcf4ef912f14b, 0x0,
    0x3fe7fe564153bc3c, 0x0,
    0x3fe0ae79abdedc09, 0x0,
    0xbfad27194f7d80e1, 0x0,
    0xbfdc58d51de01ed6, 0x0,
    0xbfe6ada7dcc2af65, 0x0,
    0xbfdad2c3da0662e4, 0x0,
    0xbfa1a67b4987f372, 0x0,
    0x3fe1159e833b8458, 0x0,
    0x3fe65931daa7f517, 0x0,
    0x3fe287231fae06f5, 0x0,
    0xbfb2360aa43bb0fe, 0x0,
    0xbfe1a3f96ad842c6, 0x0,
    0xbfe5167ab85a6561, 0x0,
    0xbfe3444a208e62d9, 0x0,
    0x3f9d1ea0ab4f664c, 0x0,
    0x3fe02cd02c3f7656, 0x0,
    0x3fe782280d4b5eac, 0x0,
    0x3fdeb88826f42f0f, 0x0,
    0xbf8d1200c1979ed3, 0x0,
    0xbfd830d825506106, 0x0,
    0xbfe7033d791e748e, 0x0,
    0xbfd99b22e0cf2cbc, 0x0,
    0xbfb1732dcfae3bae, 0x0,
    0x3fdb60777a76d3fa, 0x0,
    0x3fe5115b995b2f41, 0x0,
    0x3fdf3eba97293227, 0x0,
    0xbf8bee2ab24504fd, 0x0,
    0xbfdfe9a9bad4216a, 0x0,
    0xbfe65878fa2b8c3b, 0x0,
    0xbfe18a2fa5876478, 0x0,
    0xbfaf0b8a59253ac6, 0x0,
    0x3fe14a861ebc411d, 0x0,
    0x3fe74133f46da52d, 0x0,
    0x3fdeae6414f2d1ab, 0x0,
    0x3fb190e45f6d9f10, 0x0,
    0xbfdd75bcdb2b7233, 0x0,
    0xbfe7b752f8100d8b, 0x0,
    0xbfe11b332235d176, 0x0,
    0xbfb0352229206184, 0x0,
    0x3fe16190db9b61c2, 0x0,
    0x3fe73ced43804bb9, 0x0,
    0x3fdff5be196bdf04, 0x0,
    0x3fb5a9ba665c1d94, 0x0,
    0xbfdd95422daee0ca, 0x0,
    0xbfe822f187efe403, 0x0,
    0xbfde2ba6f135b242, 0x0,
    0x3fb2bf0105ebc27f, 0x0,
    0x3fe00aef02f5e542, 0x0,
    0x3fe5f27438816da2, 0x0,
    0x3fe2e4462b66c82e, 0x0,
    0xbf4a239cf5a0218e, 0x0,
    0xbfe1640561fdda3c, 0x0,
    0xbfe6d473c736837a, 0x0,
    0xbfdf04f0f54f4739, 0x0,
    0xbf9925f3911327cd, 0x0,
    0x3fe0a3a93b56061e, 0x0,
    0x3fe83b4ebc50f765, 0x0,
    0x3fe2fc23a481bcbf, 0x0,
    0xbf869e33cd6e0784, 0x0,
    0xbfde233253a8af32, 0x0,
    0xbfe316d84f4be107, 0x0,
    0xbfdf9c8c4e2bfe50, 0x0,
    0x3f56455a8d72a972, 0x0,
    0x3fdd24ed716b865a, 0x0,
    0x3fe4927493dead20, 0x0,
    0x3fdc950d96b8531c, 0x0,
    0xbfb7f8ae2aaa95a9, 0x0,
    0xbfdfcea625d09555, 0x0,
    0xbfe75f1d1a67d191, 0x0,
    0xbfe0c1cd20a388e4, 0x0,
    0x3fa50bf206c7d72b, 0x0,
    0x3fe152e6d3d8e814, 0x0,
    0x3fe300b8b105e5d4, 0x0,
    0x3fe162d434ad7b6d, 0x0,
    0xbfacb35c01fb6e72, 0x0,
    0xbfe1819472eafd1e, 0x0,
    0xbfe5505b9e2ee144, 0x0,
    0xbfdd7ed4ef7e2d7e, 0x0,
    0x3f9f86d69f2f22e7, 0x0,
    0x3fd91c6896692321, 0x0,
    0x3fe602ec2ecbc9ff, 0x0,
    0x3fe06f8bdc5574d8, 0x0,
    0x3f65b20b8eb4e9f8, 0x0,
    0xbfdfb83915097d81, 0x0,
    0xbfe5be0edde3ba0a, 0x0,
    0xbfdd30044cfaba85, 0x0,
    0xbf910e2295e0b56d, 0x0,
    0x3fe008ce42652493, 0x0,
    0x3fe5db260fb4079f, 0x0,
    0x3fdab5f47c673d35, 0x0,
    0xbf944122a788ff20, 0x0,
    0xbfe060a706dc15bc, 0x0,
    0xbfe73bd1bde91762, 0x0,
    0xbfe01380e2d6e698, 0x0,
    0xbf82a885ce95950f, 0x0,
    0x3fdefc498d26e425, 0x0,
    0x3fe43519e9952b92, 0x0,
    0x3fe005060f59339f, 0x0,
    0x3f967ff265c5b387, 0x0,
    0xbfe20a25bc8be789, 0x0,
    0xbfe73a866433c159, 0x0,
    0xbfda3d3516dded8c, 0x0,
    0xbf67f872695fa15a, 0x0,
    0x3fe10ff1b8080398, 0x0,
    0x3fe6725071497dc9, 0x0,
    0x3fe16856bc64360a, 0x0,
    0xbf8700ac6216c8a3, 0x0,
    0xbfdc946f2fa59c8e, 0x0,
    0xbfe7a1df5fade41e, 0x0,
    0xbfdbb0e65db47ce3, 0x0,
    0xbfa2c364bda3d973, 0x0,
    0x3fdfa268c870cfe3, 0x0,
    0x3fe882e305d83a82, 0x0,
    0x3fe18a5acebb18cf, 0x0,
    0x3fb480e79c6c3454, 0x0,
    0xbfdd959a2fdc498c, 0x0,
    0xbfe55d96015526b0, 0x0,
    0xbfddf60c9d8fbd5f, 0x0,
    0xbfb19ff745727325, 0x0,
    0x3fde5b7e497f5597, 0x0,
    0x3fe7c5d77831e8b8, 0x0,
    0x3fde30a0bb9c678c, 0x0,
    0xbf6750cb93c7e13f, 0x0,
    0xbfe2296c1d9c2796, 0x0,
    0xbfe7911077a3539a, 0x0,
    0xbfdd8d3aae771118, 0x0,
    0x3faa8af4f71c6fd9, 0x0,
    0x3fdec45e715a74f6, 0x0,
    0x3fe767405ae9b20e, 0x0,
    0x3fdce3c815804b2e, 0x0,
    0xbfa751e52b14da1b, 0x0,
    0xbfe1d3044c71c35d, 0x0,
    0xbfe553636ded0c40, 0x0,
    0xbfe01f9678385c02, 0x0,
    0x3f96f77ef7da27c7, 0x0,
    0x3fe0748e612b7013, 0x0,
    0x3fe4d5d393d7b4ee, 0x0,
    0x3fe1b7bf7259c8cb, 0x0,
    0x3f8df87496770eaf, 0x0,
    0xbfe198746909046f, 0x0,
    0xbfe5dc9ff2db9b36, 0x0,
    0xbfdf12218acee594, 0x0,
    0x3fad9b4633535365, 0x0,
    0x3fdf1b042b2dc8c1, 0x0,
    0x3fe59f7d541a2856, 0x0,
    0x3fddd654c5d6d382, 0x0,
    0x3f78e3080d3cae31, 0x0,
    0xbfe03b398ee2e518, 0x0,
    0xbfe513e0ef346a6c, 0x0,
    0xbfe14f504d2778e7, 0x0,
    0xbf8abeee1a48833c, 0x0,
    0x3fe074b3fb3de229, 0x0,
    0x3fe3eeb47fcafeb0, 0x0,
    0x3fe31c888475c4a5, 0x0,
    0x3f63f21829f70e05, 0x0,
    0xbfdc6af7d54ea2dd, 0x0,
    0xbfe6fc2d0ab87be1, 0x0,
    0xbfe04a9ef252c400, 0x0,
    0x3fb9a7635b87daec, 0x0,
    0x3fdfc695a03b4f03, 0x0,
    0x3fe5177c50ca13fd, 0x0,
    0x3fdce2da0bb7f064, 0x0,
    0x3f7a1b7b7f6b5e7a, 0x0,
    0xbfe0db340d5ac15f, 0x0,
    0xbfe6d478fe41745a, 0x0,
    0xbfde050aab1406a1, 0x0,
    0xbfac81b24a0cef0a, 0x0,
    0x3fe08102f282dcd0, 0x0,
    0x3fe6dc180408f2cb, 0x0,
    0x3fe2f1bb65f73047, 0x0,
    0xbfaed5e4a3c87971, 0x0,
    0xbfdecc3413b13461, 0x0,
    0xbfe699e81ee47f20, 0x0,
    0xbfe02b59d808a7eb, 0x0,
    0x3fa5d99e5380b50f, 0x0,
    0x3fdffafc0c8c185a, 0x0,
    0x3fe7aa9a0401acc2, 0x0,
    0x3fdf8762b001069c, 0x0,
    0x3fb5c08629f70e59, 0x0,
    0xbfe0fd89704b9ce0, 0x0,
    0xbfe74cbaef5f3c04, 0x0,
    0xbfe28bdc022074ac, 0x0,
    0x3fb0982f3ca8a516, 0x0,
    0x3fd9e43999e8c670, 0x0,
    0x3fe5d50700c7f516, 0x0,
    0x3fdc73e839456999, 0x0,
    0xbf81521c8fcc10ac, 0x0,
    0xbfddfba1da5ddef0, 0x0,
    0xbfe8ba8cf14a3eb5, 0x0,
    0xbfdd81159c81c689, 0x0,
    0x3fb30b841c81f94e, 0x0,
    0x3fe162a3d85b9f8a, 0x0,
    0x3fe668d67296dffd, 0x0,
    0x3fe18440f7c4dd72, 0x0,
    0xbf602f2facef054e, 0x0,
    0xbfe0c5278aa2bfbc, 0x0,
    0xbfea6a10a223301d, 0x0,
    0xbfe0f13ffa935d75, 0x0,
    0xbf9f8c596b27bac3, 0x0,
    0x3fdee9f0e2817e6b, 0x0,
    0x3fe8abff3cfd12b3, 0x0,
    0x3fe00d0234269e7d, 0x0,
    0xbf9021d6e90ef730, 0x0,
    0xbfdb6e33dde5dd08, 0x0,
    0xbfe67f51e07b32eb, 0x0,
    0xbfdf50c138118e78, 0x0,
    0x3f8413928f319b15, 0x0,
    0x3fdca14b608de6be, 0x0,
    0x3fe6507ee13ed5e0, 0x0,
    0x3fe2384a63f8a615, 0x0,
    0xbfb51237706e6347, 0x0,
    0xbfdc31047843733c, 0x0,
    0xbfe7fa0d53c6f2fe, 0x0,
    0xbfe32208743bfe48, 0x0,
    0xbf92530ff90bf958, 0x0,
    0x3fe030145e0e7337, 0x0,
    0x3fe60ace621f9ea8, 0x0,
    0x3fdf643c7701575e, 0x0,
    0xbf972870d3944e02, 0x0,
    0xbfdfdaf7b5b10b7c, 0x0,
    0xbfe355a38d21b005, 0x0,
    0xbfdf9c59e5d48857, 0x0,
    0x3f92e3f9aa337046, 0x0,
    0x3fdc4aa45ab5570b, 0x0,
    0x3fe7b5ab9e26024d, 0x0,
    0x3fdf35017ff00d6d, 0x0,
    0x3fb4d7ba4b595e8b, 0x0,
    0xbfe1865d625390d7, 0x0,
    0xbfe5c669daeeb480, 0x0,
    0xbfde3c8e093072b2, 0x0,
    0xbfa600dea29a7ff9, 0x0,
    0x3fe05f919ba0b689, 0x0,
    0x3fe6cb10656e8d0c, 0x0,
    0x3fde044ae3c7b53c, 0x0,
    0x3fb44318ac787920, 0x0,
    0xbfde879d89dbda1c, 0x0,
    0xbfe61de7262b0df3, 0x0,
    0xbfdf60f6d7bc1905, 0x0,
    0x3fa522081b246cb6, 0x0,
    0x3fe3f37d21110c0c, 0x0,
    0x3fe5b1c7ff63c572, 0x0,
    0x3fdae7b870d9a790, 0x0,
    0x3fa01529abea4ede, 0x0,
    0xbfdff9e33445e4a0, 0x0,
    0xbfe5c5cf8a804e70, 0x0,
    0xbfde432420bd412a, 0x0,
    0xbf9193fd0767028b, 0x0,
    0x3fdc310d04b9d5e7, 0x0,
    0x3fe7f2eefb331f87, 0x0,
    0x3fda8c57568c4be1, 0x0,
    0xbf94cdd88259b1d9, 0x0,
    0xbfe0b0e35637e56d, 0x0,
    0xbfe5f4bd20811e6f, 0x0,
    0xbfde962a2ae6193d, 0x0,
    0xbfa7143941d9552d, 0x0,
    0x3fe0b0c24bbc4aac, 0x0,
    0x3fe76b0a9e30dae4, 0x0,
    0x3fe0601f6d00ec5f, 0x0,
    0xbfa54b8fd534ba52, 0x0,
    0xbfe104089a07d153, 0x0,
    0xbfe668ea738ca652, 0x0,
    0xbfdbfade183652a0, 0x0,
    0x3fa87d33dbb098b4, 0x0,
    0x3fdd4d4dd3298b64, 0x0,
    0x3fe51e7fde630be2, 0x0,
    0x3fdc3797310c783d, 0x0,
    0x3fb0885a5f11b836, 0x0,
    0xbfdfa8c46f38575d, 0x0,
    0xbfe410fd477b6c33, 0x0,
    0xbfde1b10b1338829, 0x0,
    0x3f99789dc5aac98c, 0x0,
    0x3fe29b4464e12259, 0x0,
    0x3fe4e351f0660cf4, 0x0,
    0x3fda1433a21cb511, 0x0,
    0xbfa6c5f2e626f9fc, 0x0,
    0xbfe206a4686d603f, 0x0,
    0xbfe442f538d19bc1, 0x0,
    0xbfe0bcadff7c5931, 0x0,
    0x3fb7db649151d492, 0x0,
    0x3fdfb9d6be8acc90, 0x0,
    0x3fe715aa01bcf8b7, 0x0,
    0x3fdbd27318b6668c, 0x0,
    0x3f83c449df72a06f, 0x0,
    0xbfe0e3855debbd3e, 0x0,
    0xbfe49fda7e92df21, 0x0,
    0xbfe0673e49217310, 0x0,
    0x3f8865660c605fbc, 0x0,
    0x3fe055c423e491de, 0x0,
    0x3fe7d6d36211d71b, 0x0,
    0x3fe25501b652546c, 0x0,
    0xbfb2b2bc2196bd16, 0x0,
    0xbfe218169a6a7f5c, 0x0,
    0xbfe7e3c43563cd5f, 0x0,
    0xbfe20c3cfef97d5c, 0x0,
    0x3fc4bbf7f5ff5c7b, 0x0,
    0x3fe30d0ccdf6de62, 0x0,
    0x3fe791a0b5bf63b8, 0x0,
    0x3fde3882550b3d46, 0x0,
    0xbf96f9212cb69612, 0x0,
    0xbfdde3fe90f9f7ef, 0x0,
    0xbfe8a2f993c89836, 0x0,
    0xbfdfddd6a176256a, 0x0,
    0xbf7f178564c73c00, 0x0,
    0x3fdfb21eebdf73a7, 0x0,
    0x3fe5d806432a4ba6, 0x0,
    0x3fe1aaaf36224c2f, 0x0,
    0xbf7420f0f488cc9c, 0x0,
    0xbfe157b2399c52ec, 0x0,
    0xbfe4226ebf896a3e, 0x0,
    0xbfdf4416fb0af197, 0x0,
    0x3f95fe6f68be67ae, 0x0,
    0x3fe04214d5ceba71, 0x0,
    0x3fe4d1507644fd86, 0x0,
    0x3fe0531c78dd4996, 0x0,
    0xbf8b7fcbe498977d, 0x0,
    0xbfe07bd99cf5f219, 0x0,
    0xbfe5b8f0fe85ac71, 0x0,
    0xbfde480d14b41910, 0x0,
    0xbf6b288c9fbaf8e8, 0x0,
    0x3fe0924e62ed240f, 0x0,
    0x3fe640ccaeae54c9, 0x0,
    0x3fde172b870c4e99, 0x0,
    0x3fa1a8d93e30cb98, 0x0,
    0xbfe029dde3676e69, 0x0,
    0xbfe5c8c7919b2393, 0x0,
    0xbfda8e89cb6eb1f4, 0x0,
    0xbfa4d8c067a84715, 0x0,
    0x3fdf7b5de16f6dcc, 0x0,
    0x3fe2fb6b2b63afa4, 0x0,
    0x3fe2df7300609a05, 0x0,
    0x3f92b33732022497, 0x0,
    0xbfe08c855669a13d, 0x0,
    0xbfe8065376b04035, 0x0,
    0xbfd72b9f13ac6c3a, 0x0,
    0xbf9bf5a521c831da, 0x0,
    0x3fe1fe6b5134447a, 0x0,
    0x3fe63bee7f08a7ad, 0x0,
    0x3fd6abb5d4a88fad, 0x0,
    0xbf319e44a4c3483b, 0x0,
    0xbfdd47cb22b8b9e2, 0x0,
    0xbfe6224baf006055, 0x0,
    0xbfe15da26a8eec51, 0x0,
    0xbfc023bc4eaf3d39, 0x0,
    0x3fde52dd7ae109e5, 0x0,
    0x3fe892d8fba7a3f7, 0x0,
    0x3fdcfbaf1e8fafae, 0x0,
    0x3fb510f426ceb833, 0x0,
    0xbfd991c03f263b48, 0x0,
    0xbfe63a145faf1a40, 0x0,
    0xbfda9510c64543bb, 0x0,
    0xbfb5e529ae267ea3, 0x0,
    0x3fe01b79266fdf21, 0x0,
    0x3fe4161645ab447c, 0x0,
    0x3fdf51c250a17aea, 0x0,
    0x3fbf1e2104e63cc7, 0x0,
    0xbfe0b302bc9f4a10, 0x0,
    0xbfe581fd3aff5429, 0x0,
    0xbfd5d394370bb8bc, 0x0,
    0x3f91df5a508d32fc, 0x0,
    0x3fe1a5a64998f490, 0x0,
    0x3fe475b29b1abe4e, 0x0,
    0x3fdf528aee3795f7, 0x0,
    0xbf83407f8cf4a536, 0x0,
    0xbfe17d9c71736ea9, 0x0,
    0xbfe3e3a603d42bc6, 0x0,
    0xbfdedd42851c0975, 0x0,
    0xbfa99d2b40c4ccfb, 0x0,
    0x3fdfbb58ebe20d3d, 0x0,
    0x3fe47d943897fcd5, 0x0,
    0x3fe050ac1e022858, 0x0,
    0x3f7f56a8ac97d216, 0x0,
    0xbfdd7d8213ebcb9a, 0x0,
    0xbfe72645c8251964, 0x0,
    0xbfe2760b0d3ea44a, 0x0,
    0x3fb3fccdbacaafc0, 0x0,
    0x3fdfed007621430a, 0x0,
    0x3fe4a82d484e3be1, 0x0,
    0x3fda8bfd0c9ba9c8, 0x0,
    0xbf8551d8f38fc533, 0x0,
    0xbfde325f7d6687ab, 0x0,
    0xbfe678dc890b3300, 0x0,
    0xbfe4770bb5a11c58, 0x0,
    0xbfa46ca9f0adaf63, 0x0,
    0x3fdf48ac34bc11ee, 0x0,
    0x3fe479df31d2c32c, 0x0,
    0x3fdd5e7ea44cf1cc, 0x0,
    0xbfb2543c64ffcac6, 0x0,
    0xbfdda8350f1852e9, 0x0,
    0xbfe54e0f007fc602, 0x0,
    0xbfdc455ddb37ef4b, 0x0,
    0xbfb63bc443be2663, 0x0,
    0x3fe100ee7e6cc273, 0x0,
    0x3fe54a2ac4f3cb6c, 0x0,
    0x3fdf2a8644d4de85, 0x0,
    0x3fb5637e3b4c47ca, 0x0,
    0xbfde16c2fdafe758, 0x0,
    0xbfe8038f66e74330, 0x0,
    0xbfe2594492864a19, 0x0,
    0xbf9d649da6f3d799, 0x0,
    0x3fe06361b84612a3, 0x0,
    0x3fe6e414f511fa20, 0x0,
    0x3fe2c748e8ba919f, 0x0,
    0xbf834ca7bd7e8175, 0x0,
    0xbfdb61c4afaa1130, 0x0,
    0xbfe634b797c5b4e7, 0x0,
    0xbfdb7b7418c55716, 0x0,
    0xbfaab1ce7277362f, 0x0,
    0x3fe0076094c7d0a1, 0x0,
    0x3fe6e2d9d90a37f2, 0x0,
    0x3fdfe8c9d752380e, 0x0,
    0x3fae4a530b9ec45e, 0x0,
    0xbfe23a0256d20a06, 0x0,
    0xbfe8ee986e0749f8, 0x0,
    0xbfe0160069f3a6cc, 0x0,
    0xbfa2f62a183f921d, 0x0,
    0x3fe010ab0fd0bd70, 0x0,
    0x3fe59e51d5bf4fa2, 0x0,
    0x3fdfd57209aa1ff0, 0x0,
    0x3fb38cf60a1f86e3, 0x0,
    0xbfe153050cbcd101, 0x0,
    0xbfe716eb6fe0ad08, 0x0,
    0xbfdedfdafb03834b, 0x0,
    0xbfad321424b61592, 0x0,
    0x3fdd63313399979a, 0x0,
    0x3fe7288024758077, 0x0,
    0x3fe3269aafae4a50, 0x0,
    0xbf9b65ee18e2b3b5, 0x0,
    0xbfde8ffa54f4540f, 0x0,
    0xbfe59f8143c882fe, 0x0,
    0xbfe1f33e37eae157, 0x0,
    0xbf8a23be4cffe76b, 0x0,
    0x3fe0e2bce0967243, 0x0,
    0x3fe8c3349f97aa39, 0x0,
    0x3fdc7546d1ebfdba, 0x0,
    0x3fb1a1dd0896aa75, 0x0,
    0xbfe0be8db3e47d0f, 0x0,
    0xbfe54482efe89edf, 0x0,
    0xbfe078b0e5ac5c80, 0x0,
    0x3fb32ce34beacb2e, 0x0,
    0x3fdc720db6e6e4ea, 0x0,
    0x3fe61ed2669c151b, 0x0,
    0x3fe006f1d4f10aec, 0x0,
    0x3f828680f2a53202, 0x0,
    0xbfdef870b4c85533, 0x0,
    0xbfe4ee37ebd3be9e, 0x0,
    0xbfe171c785a65943, 0x0,
    0x3f941342c1d822d1, 0x0,
    0x3fdc46bdff61fc00, 0x0,
    0x3fe84bd73044e9f4, 0x0,
    0x3fdeecaf00961cb3, 0x0,
    0xbfb737b5a3d3755c, 0x0,
    0xbfdb8aa8e1df49ae, 0x0,
    0xbfe571b564ae0c8c, 0x0,
    0xbfdc08c9fbf4759f, 0x0,
    0x3f9ca230b5122b26, 0x0,
    0x3fe0f65d56333e44, 0x0,
    0x3fe47710ab108dce, 0x0,
    0x3fdd2de762e97ee4, 0x0,
    0xbfb2de41c9f27834, 0x0,
    0xbfe307ce63dd017c, 0x0,
    0xbfe4f33c1194127b, 0x0,
    0xbfddbf878b2f4e4a, 0x0,
    0x3fb73f4c5594f39b, 0x0,
    0x3fdfec12d10fdd91, 0x0,
    0x3fe6b3dd6f497dea, 0x0,
    0x3fe0c1cd92ddc102, 0x0,
    0x3f86302033b94d59, 0x0,
    0xbfe022e9985af08d, 0x0,
    0xbfe742b20e166194, 0x0,
    0xbfe0d8a223fe3634, 0x0,
    0xbfb4577ac6d1b41d, 0x0,
    0x3fdee4a3fc9f7458, 0x0,
    0x3fe7e6192af6d50e, 0x0,
    0x3fdeeae6986c880a, 0x0,
    0xbf65de1bbf1d3b19, 0x0,
    0xbfe138344a9f4e87, 0x0,
    0xbfe63b1e0de81e03, 0x0,
    0xbfe1532630969d8f, 0x0,
    0xbfa73bfa22d5394f, 0x0,
    0x3fd94e8dda30d496, 0x0,
    0x3fe640002fa0c0c1, 0x0,
    0x3fe079e93a40af98, 0x0,
    0xbfa283504a4bd3e1, 0x0,
    0xbfdb64c7951ac0e4, 0x0,
    0xbfe558a991bd17cc, 0x0,
    0xbfd98fd8ecc9f858, 0x0,
    0xbf85224e05503dd3, 0x0,
    0x3fe004b16482261e, 0x0,
    0x3fe645abd5b685ed, 0x0,
    0x3fdd5a37aff79a0d, 0x0,
    0x3fa1465c089c63f2, 0x0,
    0xbfe27ff86eb93722, 0x0,
    0xbfe6bfbd7ed9b41d, 0x0,
    0xbfe2c6cdff3331b9, 0x0,
    0xbfb1c4f7c7c21c85, 0x0,
    0x3fde4c623633a69f, 0x0,
    0x3fe6eef6a9f946c3, 0x0,
    0x3fe084aa5c3b485e, 0x0,
    0x3f91c2fe339a1cb3, 0x0,
    0xbfdcffe06561ac5c, 0x0,
    0xbfe6a953555299c2, 0x0,
    0xbfdc48929083c3f0, 0x0,
    0x3fb60b97c102b0fc, 0x0,
    0x3fdd23e995596abf, 0x0,
    0x3fe7b7db8362e8da, 0x0,
    0x3fe1830c81dd2f4d, 0x0,
    0x3fa45323799c6fe3, 0x0,
    0xbfddd867bd635b39, 0x0,
    0xbfe76e7a95333943, 0x0,
    0xbfdfc9e265c3e372, 0x0,
    0x3fa1cc3ffad8ba24, 0x0,
    0x3fdfa5de5c96ff55, 0x0,
    0x3fe59a6e18c6a1ea, 0x0,
    0x3fdcca8568a7875a, 0x0,
    0x3fa4f3ab2396ad70, 0x0,
    0xbfe04f0385442118, 0x0,
    0xbfe5568accf83194, 0x0,
    0xbfdebd252e235384, 0x0,
    0xbfa465936cbc7605, 0x0,
    0x3fdf94e138581790, 0x0,
    0x3fe5a892875e2808, 0x0,
    0x3fde0a3ab995b8a0, 0x0,
    0x3faa2b6931316c91, 0x0,
    0xbfd692d13b0345bc, 0x0,
    0xbfe760a1672c81be, 0x0,
    0xbfe0b0205a708856, 0x0,
    0x3f94d8bc757f22a3, 0x0,
    0x3fe088b637a09d81, 0x0,
    0x3fe4f88fdc0edbd2, 0x0,
    0x3fdf26c370f97ca0, 0x0,
    0x3f9d671c5e0a50ba, 0x0,
    0xbfe0107db3234527, 0x0,
    0xbfe4fee0820ec588, 0x0,
    0xbfe1bced31d5a3c3, 0x0,
    0xbf8b5f71d9920aad, 0x0,
    0x3fe0d979b5f342cf, 0x0,
    0x3fe5b9f3fd6b5cf6, 0x0,
    0x3fe0d182da0612fe, 0x0,
    0xbfbcd06d28f96e86, 0x0,
    0xbfe09ebb5a276bfd, 0x0,
    0xbfe81f37739a7146, 0x0,
    0xbfe1141c6da1d169, 0x0,
    0xbfa3b7b0f9c02a90, 0x0,
    0x3fdf9960278c06af, 0x0,
    0x3fe677ba9e7d87db, 0x0,
    0x3fe1e4f16b154edd, 0x0,
    0xbf9f4758d63d5b03, 0x0,
    0xbfda7aeb2a1516aa, 0x0,
    0xbfe79b44332281d4, 0x0,
    0xbfe18715eea2e346, 0x0,
    0x3f9ad01cfbb94697, 0x0,
    0x3fe30958e9ab0bc0, 0x0,
    0x3fe3e00088ae5dbe, 0x0,
    0x3fdbb302381b837d, 0x0,
    0x3f918668fcbec56d, 0x0,
    0xbfdff86c5d7121d1, 0x0,
    0xbfe5dd764aa288cf, 0x0,
    0xbfda7fda198e8769, 0x0,
    0x3fa587115417c6de, 0x0,
    0x3fdccd329c0eb9f0, 0x0,
    0x3fe6709c82334e6d, 0x0,
    0x3fe0350b078b846c, 0x0,
    0x3f99f45b64b67613, 0x0,
    0xbfe2907c6a25fa34, 0x0,
    0xbfe66652875a9a59, 0x0,
    0xbfe08b0078744b5c, 0x0,
    0xbfa2174bcfcdcab7, 0x0,
    0x3fd77187957c44e9, 0x0,
    0x3fe65244194f7533, 0x0,
    0x3fe05250f0a315f2, 0x0,
    0xbf5e7220cc440dd1, 0x0,
    0xbfdec63fc0916405, 0x0,
    0xbfe9e176e8e9b83e, 0x0,
    0xbfe0f2de12f1bb8d, 0x0,
    0x3f90afc9528a5bce, 0x0,
    0x3fe05585c168016e, 0x0,
    0x3fe331641f07671d, 0x0,
    0x3fe23ac557d5df3e, 0x0,
    0xbfb25e312778f548, 0x0,
    0xbfe1553f233a088e, 0x0,
    0xbfe3accf35c8de36, 0x0,
    0xbfe164a438f3fc7a, 0x0,
    0x3f800c67dee194e6, 0x0,
    0x3fe0b10f0ac2d871, 0x0,
    0x3fe7a47e79d57fbd, 0x0,
    0x3fe00dd1406415f5, 0x0,
    0x3f556cbffa811d87, 0x0,
    0xbfdedb9f58721957, 0x0,
    0xbfe56b8e0f81a909, 0x0,
    0xbfda92d0566072f7, 0x0,
    0x3fa743329f4bbe8a, 0x0,
    0x3fdcc4d6268eac0a, 0x0,
    0x3fe5d989b006779c, 0x0,
    0x3fe0a0d057b7911d, 0x0,
    0xbf8c26611f09e948, 0x0,
    0xbfe0e3331b9b86ba, 0x0,
    0xbfe58c502b1c1483, 0x0,
    0xbfdbdebc446cb8f5, 0x0,
    0x3fb6f0a0d8ef8f8d, 0x0,
    0x3fde0fbe9703bc3c, 0x0,
    0x3fe4cacddb23b9a7, 0x0,
    0x3fdd60eedddda658, 0x0,
    0xbf87ca64c286d598, 0x0,
    0xbfde40d50e023ce5, 0x0,
    0xbfe899fba6224c03, 0x0,
    0xbfde70dd63d5a8eb, 0x0,
    0x3f9aeddf518fb57c, 0x0,
    0x3fddce19d7df32b3, 0x0,
    0x3fe4b7b952f56d79, 0x0,
    0x3fe1adae2101db8b, 0x0,
    0xbf79e52e90d11cdb, 0x0,
    0xbfdffee06f1faa9f, 0x0,
    0xbfe7398d53f91a8c, 0x0,
    0xbfe023aaefe389d5, 0x0,
    0xbfc00fe960ef2634, 0x0,
    0x3fe05b46b1fa4cdd, 0x0,
    0x3fe60c38bba896b5, 0x0,
    0x3fe0ed23d1ae680d, 0x0,
    0x3fa955dfcb61ced3, 0x0,
    0xbfdf60bffc2e3327, 0x0,
    0xbfe35601df8faf29, 0x0,
    0xbfdffa5ed651e5eb, 0x0,
    0xbf9786f57ab45a36, 0x0,
    0x3fddff0ff9b920aa, 0x0,
    0x3fe6b60743b60499, 0x0,
    0x3fe0b4d7dec58ac9, 0x0,
    0x3fb813eb4c9c3d3d, 0x0,
    0xbfdc130962d15115, 0x0,
    0xbfe6e63600cead9e, 0x0,
    0xbfdfc36ce23bc72f, 0x0,
    0xbf896c9c687e3eb7, 0x0,
    0x3fdbda26aa7c20e1, 0x0,
    0x3fea8bb658b8da26, 0x0,
    0x3fe3177b26e68ed0, 0x0,
    0xbfb2471bb609db91, 0x0,
    0xbfdb2d7638ab3018, 0x0,
    0xbfe41f9f64a796d1, 0x0,
    0xbfde5ea8cffc0d72, 0x0,
    0x3fb59d644caf1cc6, 0x0,
    0x3fdaa1d837b51aa4, 0x0,
    0x3fe53d7a98202275, 0x0,
    0x3fdfcf855e5af1f3, 0x0,
    0x3f9e614258b5cc47, 0x0,
    0xbfe0230c6d0ed7e1, 0x0,
    0xbfe8f97945c87637, 0x0,
    0xbfdf06a2d6d4ce78, 0x0,
    0xbf87fcd32321fc5e, 0x0,
    0x3fdfd7a56e91dafa, 0x0,
    0x3fea59c95b5787fd, 0x0,
    0x3fded0a25ec25e26, 0x0,
    0x3f52f40e73c2b476, 0x0,
    0xbfdd9f56c744cd74, 0x0,
    0xbfe4e7907718af71, 0x0,
    0xbfdf7ff7df4ce6e5, 0x0,
    0xbfba0578be0e517f, 0x0,
    0x3fe1f4afe90fc382, 0x0,
    0x3fe7baf717182b8d, 0x0,
    0x3fe19cdeb8949a0d, 0x0,
    0x3f6ac75febe4d5a7, 0x0,
    0xbfdaa76478e5df53, 0x0,
    0xbfe6a2cbb2e2ebec, 0x0,
    0xbfdecc03954a8ab4, 0x0,
    0xbfa3f4bde6ee1e9c, 0x0,
    0x3fe03d82729d7afb, 0x0,
    0x3fe795e7cad9b583, 0x0,
    0x3fdd8c4ecaecf08a, 0x0,
    0xbfa226e5f6d3f891, 0x0,
    0xbfe0c77d9a2d39e5, 0x0,
    0xbfe49f12234d284c, 0x0,
    0xbfdaf3b00bf31ea5, 0x0,
    0xbf8ad3d1e7dd1360, 0x0,
    0x3fe062b2eea39aac, 0x0,
    0x3fe55c2d1f898761, 0x0,
    0x3fdcffac90eeb98b, 0x0,
    0x3fa370e5586b9bc5, 0x0,
    0xbfe230da6391b4f5, 0x0,
    0xbfe7b6af588c95f5, 0x0,
    0xbfda20bce951f198, 0x0,
    0x3f9875bb178201b6, 0x0,
    0x3fdbf7a51161dcd9, 0x0,
    0x3fe65edf663e76cd, 0x0,
    0x3fdce2ef007dbbc6, 0x0,
    0xbfa3eff7bbfe6028, 0x0,
    0xbfe26e693b7075b0, 0x0,
    0xbfe8688ab8ba3b3c, 0x0,
    0xbfe13a02d5e7c93b, 0x0,
    0xbf906b1dbafdde8d, 0x0,
    0x3fdd032025382d74, 0x0,
    0x3fe8a62994af90e0, 0x0,
    0x3fdf3861b4863680, 0x0,
    0x3fc3235b4ecd8932, 0x0,
    0xbfdffee7ec13ec32, 0x0,
    0xbfe8b3a1b472b1fa, 0x0,
    0xbfe152390e229dad, 0x0,
    0xbfc09b35c0e14e0d, 0x0,
    0x3fe160aaa5e06f4b, 0x0,
    0x3fe61e36d5fc5ea8, 0x0,
    0x3fe1744e0c8e3ce6, 0x0,
    0x3fb0201d6c44266c, 0x0,
    0xbfe0a9f6040341fa, 0x0,
    0xbfe86ed34b2a02d2, 0x0,
    0xbfe187c531041a28, 0x0,
    0xbfa66e9982792855, 0x0,
    0x3fe0cc00365f75b8, 0x0,
    0x3fe657d25105101f, 0x0,
    0x3fdec03a48681912, 0x0,
    0xbfa9e5226fc95cf1, 0x0,
    0xbfdf0e37eb1b22fc, 0x0,
    0xbfe4fdf9cf84cd5a, 0x0,
    0xbfe032cdc2b0ae6d, 0x0,
    0x3f8e52c1922d50f0, 0x0,
    0x3fe18176b1bedfb8, 0x0,
    0x3fe710de9e76c9c0, 0x0,
    0x3fe00ad24b70a5d9, 0x0,
    0xbfa7916cbcf6237f, 0x0,
    0xbfdca3904a8aecaf, 0x0,
    0xbfe8330706df71b0, 0x0,
    0xbfdd760c455e0671, 0x0,
    0xbf82d61fa3402e43, 0x0,
    0x3fe1252689830b00, 0x0,
    0x3fe4ce9c9743f217, 0x0,
    0x3fdbe0c144f60856, 0x0,
    0xbf818ac2d03333cc, 0x0,
    0xbfe04d6301000b52, 0x0,
    0xbfe62b4eb6788779, 0x0,
    0xbfdfba1c5e00890b, 0x0,
    0x3fb044317f1d1e11, 0x0,
    0x3fdfbae19e1e13f9, 0x0,
    0x3fe6584962a491c6, 0x0,
    0x3fe024c0174a2ebd, 0x0,
    0xbf8e43476924cd43, 0x0,
    0xbfdec169d1083b10, 0x0,
    0xbfe541f0eb828b2e, 0x0,
    0xbfe0e0795032e938, 0x0,
    0x3fa09bebb5205e91, 0x0,
    0x3fdec51dd7f9e0c2, 0x0,
    0x3fe5f780fe00ff0e, 0x0,
    0x3fe15592ee548a2e, 0x0,
    0x3fb32bc61fbc13aa, 0x0,
    0xbfd98b577a541529, 0x0,
    0xbfe67570d6af9c72, 0x0,
    0xbfe0269ce679c988, 0x0,
    0xbfa4b47268260c32, 0x0,
    0x3fe01dda6387fb57, 0x0,
    0x3fe62bdc985e465f, 0x0,
    0x3fe1cb8fbb2457c3, 0x0,
    0xbfa4984214af0013, 0x0,
    0xbfdff433969a3f26, 0x0,
    0xbfe615a8ee089950, 0x0,
    0xbfe20c4a79b14371, 0x0,
    0xbfb26416c68afc83, 0x0,
    0x3fdfa820d2be0174, 0x0,
    0x3fe771670f81316e, 0x0,
    0x3fda8464bdf1f2ee, 0x0,
    0xbf85cf81e0c1647c, 0x0,
    0xbfdb34f19fc3ca71, 0x0,
    0xbfe7943bede6f42e, 0x0,
    0xbfe184ec6f8b2388, 0x0,
    0xbfa95b830b5a96cc, 0x0,
    0x3fdcab2f36523eaa, 0x0,
    0x3fe4251b80bbe14e, 0x0,
    0x3fe302981fa9cd79, 0x0,
    0xbf7c876589c278af, 0x0,
    0xbfe03c8cc502febc, 0x0,
    0xbfe5e0c30fd08381, 0x0,
    0xbfdf003aa30939e5, 0x0,
    0xbfc02c6f27cfa3c1, 0x0,
    0x3fdf91778ebdf4f4, 0x0,
    0x3fe4b41743322506, 0x0,
    0x3fe05e03bea4279f, 0x0,
    0x3fb6a6b3ef8c8094, 0x0,
    0xbfe042b93d9574b7, 0x0,
    0xbfe68385295683d1, 0x0,
    0xbfdd4df4410c3e2a, 0x0,
    0x3faa02bab236491b, 0x0,
    0x3fe0b31664ecb137, 0x0,
    0x3fe7ce40ec85bbe1, 0x0,
    0x3fdaf4ba4a62a4e8, 0x0,
    0x3fa818f97913ec46, 0x0,
    0xbfdf3eb89bd5fa99, 0x0,
    0xbfe5da158eda479d, 0x0,
    0xbfe1a28f9caccec1, 0x0,
    0x3f834071041dde65, 0x0,
    0x3fe25a597b07c48e, 0x0,
    0x3fe33e12d94676fa, 0x0,
    0x3fe0298ed48aa0fb, 0x0,
    0xbfa4788280c74521, 0x0,
    0xbfe0d06dee82c094, 0x0,
    0xbfe68ee9b59d0999, 0x0,
    0xbfdf53bd71986df1, 0x0,
    0xbf85147de910d6b1, 0x0,
    0x3fe051ed3c314c60, 0x0,
    0x3fe76f2671a8a9b0, 0x0,
    0x3fdf5c33bfa1bda5, 0x0,
    0xbfa652fc4fd69346, 0x0,
    0xbfe04870c882b031, 0x0,
    0xbfe74d998c6f466a, 0x0,
    0xbfe159f3b0460c2d, 0x0,
    0xbf8e7cf0c33c109c, 0x0,
    0x3fe0e5cdb9f8e2e7, 0x0,
    0x3fe5cffa6a2e20a9, 0x0,
    0x3fdf03ff0f973927, 0x0,
    0x3f7c0069bf4243fb, 0x0,
    0xbfe055474aabb303, 0x0,
    0xbfe4f9ca2afd006e, 0x0,
    0xbfe037b172e4f789, 0x0,
    0xbfb0d9bf05f6ca27, 0x0,
    0x3fdae47957dd1328, 0x0,
    0x3fe66a311e4896f2, 0x0,
    0x3fdb492411b15abf, 0x0,
    0x3f7b09ee8556313e, 0x0,
    0xbfdf076b5406fe5e, 0x0,
    0xbfe2b2323dfcc556, 0x0,
    0xbfdc7762583f124a, 0x0,
    0xbf4df80634687e92, 0x0,
    0x3fe03fcb956f038a, 0x0,
    0x3fe5fc2b321bfd66, 0x0,
    0x3fdf1af12ea9a3c9, 0x0,
    0x3f910b438713e50d, 0x0,
    0xbfe1f127a669d630, 0x0,
    0xbfe73df448785f8a, 0x0,
    0xbfe02ee3d7dc3fd7, 0x0,
    0x3fa75b380267aab2, 0x0,
    0x3fd9e481be2e5739, 0x0,
    0x3fe8f78bfa261004, 0x0,
    0x3fd9246761e8e504, 0x0,
    0x3fbe868be0e85c31, 0x0,
    0xbfde18e70e3d6ff2, 0x0,
    0xbfe560784a4d8230, 0x0,
    0xbfdfa7eaee82467b, 0x0,
    0xbfb1c616c14dab96, 0x0,
    0x3fe0250216db22a9, 0x0,
    0x3fe62e523f40dac4, 0x0,
    0x3fe171dd3eff0b06, 0x0,
    0xbfb70315fe4db497, 0x0,
    0xbfe36140ffd6beb4, 0x0,
    0xbfe54892cc0f168e, 0x0,
    0xbfe164ec8402163d, 0x0,
    0xbf954ba4003ddd81, 0x0,
    0x3fdfb31ae75abf11, 0x0,
    0x3fe6fce676b58676, 0x0,
    0x3fdd985da0e11024, 0x0,
    0x3f81f744357667f7, 0x0,
    0xbfdf1f172070e813, 0x0,
    0xbfe4562e0f9b4974, 0x0,
    0xbfe00185f8c000c1, 0x0,
    0x3fa601fe5b54346a, 0x0,
    0x3fe0a83637679323, 0x0,
    0x3fe71ee4db787b86, 0x0,
    0x3fe001e85fe9c9c1, 0x0,
    0xbf82527e9dfa2246, 0x0,
    0xbfe002ea5e7c8996, 0x0,
    0xbfe6246e7eee28ee, 0x0,
    0xbfe02fb4028f59c1, 0x0,
    0x3fb1ab6a61238c46, 0x0,
    0x3fdf567dcf2c0f0a, 0x0,
    0x3fe6d78c9a1eacab, 0x0,
    0x3fddd44c40343f1a, 0x0,
    0xbf97e7ccd35115bb, 0x0,
    0xbfe0f844ad7292c2, 0x0,
    0xbfe5775201907ac7, 0x0,
    0xbfe1084735ece8db, 0x0,
    0x3fb0d24a55ea7409, 0x0,
    0x3fddc18ec4ceb49e, 0x0,
    0x3fe5e6eff780a9d5, 0x0,
    0x3fe09451903f8066, 0x0,
    0xbf98483ed5cfbf2f, 0x0,
    0xbfe1aa29f7633bf4, 0x0,
    0xbfe84a577e11beae, 0x0,
    0xbfe10055393989a7, 0x0,
    0x3f86325b5bbbb003, 0x0,
    0x3fe075264bee4d0e, 0x0,
    0x3fe5921cba455b89, 0x0,
    0x3fe04730b42f8d14, 0x0,
    0x3f896b0ee76d5560, 0x0,
    0xbfdce412e6d97e80, 0x0,
    0xbfe84494c1862ed8, 0x0,
    0xbfdad0145eaa5c31, 0x0,
    0x3fb82b686db734e0, 0x0,
    0x3fe1ea99aceaa44c, 0x0,
    0x3fe7b938ad474cc9, 0x0,
    0x3fe04dd4528e01ea, 0x0,
    0x3fb09de86d83c748, 0x0,
    0xbfe0934d865b08a2, 0x0,
    0xbfe6e564a09a0260, 0x0,
    0xbfe0c9db753911b6, 0x0,
    0xbfb1c2a43e9b89e3, 0x0,
    0x3fde55d0d4fae3c2, 0x0,
    0x3fe75cc3025ec688, 0x0,
    0x3fe1733dfb8c859d, 0x0,
    0x3fa2aca7d290cfdb, 0x0,
    0xbfde963d8a73ac44, 0x0,
    0xbfe50e2cf36a54cf, 0x0,
    0xbfe1f5cda1e3a104, 0x0,
    0x3fb04a698254c4b8, 0x0,
    0x3fe12a49835578da, 0x0,
    0x3fe6f9c5451f2948, 0x0,
    0x3fd60df3ee686980, 0x0,
    0x3f97a0f3630b3b76, 0x0,
    0xbfdbd71ffbb17044, 0x0,
    0xbfe40f5d3cc82ee9, 0x0,
    0xbfe18e51a4e606bd, 0x0,
    0xbf810b2f1585f660, 0x0,
    0x3fe0bc20cc6d897a, 0x0,
    0x3fe470744b38d003, 0x0,
    0x3fdf2c67528a71c3, 0x0,
    0x3fb3a6a0d79d55ba, 0x0,
    0xbfe02b7429596d53, 0x0,
    0xbfe6167d0ee85b6e, 0x0,
    0xbfde4465be261796, 0x0,
    0xbf86c7cdb1ebd303, 0x0,
    0x3fe0a31941df5363, 0x0,
    0x3fe6d7401e4209b5, 0x0,
    0x3fe17282bb616b12, 0x0,
    0x3f9a4871b5e8bea8, 0x0,
    0xbfdbfbcd0ccc544a, 0x0,
    0xbfe656b9af6ec970, 0x0,
    0xbfdc218f1c622243, 0x0,
    0x3fb56c9475a1c0b9, 0x0,
    0x3fe1c1b2be6d396a, 0x0,
    0x3fe4b0d3e04f44e6, 0x0,
    0x3fd9c8656e19f859, 0x0,
    0x3f726cecd2fdc895, 0x0,
    0xbfe1e2e4058a759b, 0x0,
    0xbfe66702a4ef799d, 0x0,
    0xbfe270852f67bf9e, 0x0,
    0xbf97e2349fc1d52e, 0x0,
    0x3fdcbb58fb08e79f, 0x0,
    0x3fea4f2f5a82b92b, 0x0,
    0x3fddef8d9ab57829, 0x0,
    0xbf81b29a10fea340, 0x0,
    0xbfe0cc5fc65b4e4a, 0x0,
    0xbfe9acd4ce7b8f6f, 0x0,
    0xbfdcdd4455ce8453, 0x0,
    0xbfa0c7dd53b36048, 0x0,
    0x3fdccbec616d71cd, 0x0,
    0x3fe5740a386f6450, 0x0,
    0x3fdaf29e26327454, 0x0,
    0x3f9c15b9c43326d2, 0x0,
    0xbfdf66753ff99ab2, 0x0,
    0xbfe82449b1fd47c8, 0x0,
    0xbfdea3433d086734, 0x0,
    0x3f6feb7f04717c4d, 0x0,
    0x3fdebc7e86539ef2, 0x0,
    0x3fe65afef22f0d02, 0x0,
    0x3fe37101a1f3d7b5, 0x0,
    0x3fac236ca522ba7f, 0x0,
    0xbfe3a0a7cf8aaad2, 0x0,
    0xbfe6c2c2932c8f13, 0x0,
    0xbfe0852cb8c09b5b, 0x0,
    0xbf9e0cafbd99fafa, 0x0,
    0x3fe155207a7cb1ae, 0x0,
    0x3fe4fdaae289a298, 0x0,
    0x3fe197434fca9a9f, 0x0,
    0x3fa7bd029c5a2538, 0x0,
    0xbfe135520c6bccdd, 0x0,
    0xbfe5ddb53d0cb0d3, 0x0,
    0xbfdbf59f976e7e60, 0x0,
    0x3f7de626d124f77f, 0x0,
    0x3fe0f41b898fe644, 0x0,
    0x3fe63bb524ae93b2, 0x0,
    0x3fe13ec5d51370ec, 0x0,
    0x3f9ac70288cadb73, 0x0,
    0xbfdddfe5113b894b, 0x0,
    0xbfe5b1c3e3c8734f, 0x0,
    0xbfd944bcc8d7baf9, 0x0,
    0xbfaa8e4cdd3593ff, 0x0,
    0x3fe06680f91ae556, 0x0,
    0x3fe64fe6a6a90510, 0x0,
    0x3fdfed7c64ffbb94, 0x0,
    0xbf61143ce7d02494, 0x0,
    0xbfdb8112aa6b40d0, 0x0,
    0xbfe64411ee32b144, 0x0,
    0xbfe4ce2278d826db, 0x0,
    0xbf925b049cec44d8, 0x0,
    0x3fdd1a21d24e8708, 0x0,
    0x3fe6cda51d1ae9e9, 0x0,
    0x3fe1737a8a852bb3, 0x0,
    0x3f881b45f5bd042c, 0x0,
    0xbfdc414124d005de, 0x0,
    0xbfe49bca050bb1c4, 0x0,
    0xbfda37427367f6a0, 0x0,
    0x3f91e54552b6f5a9, 0x0,
    0x3fe12bc8eac7e5aa, 0x0,
    0x3fe5c3a7f1f3eb24, 0x0,
    0x3fe05c3694f34415, 0x0,
    0xbf8cf3bc5f92e9bf, 0x0,
    0xbfe0bc3dca0e6881, 0x0,
    0xbfe6d00702d78529, 0x0,
    0xbfdf9836c8980a81, 0x0,
    0xbfa6de4cce433031, 0x0,
    0x3fd9c217fb7a47ae, 0x0,
    0x3fe6bacd399c5319, 0x0,
    0x3fdef84201fdc0be, 0x0,
    0xbf653610e81d439a, 0x0,
    0xbfdc0f8439dc9140, 0x0,
    0xbfe726a26c758a58, 0x0,
    0xbfde98ed255746ac, 0x0,
    0xbf9b60a6258bbdbd, 0x0,
    0x3fdbd3442c7c650d, 0x0,
    0x3fead1801c1b03a5, 0x0,
    0x3fe1172b9b5e2d02, 0x0,
    0xbf9edbf2ce113865, 0x0,
    0xbfddf7b6b6c9310e, 0x0,
    0xbfe5fee221f39470, 0x0,
    0xbfdfe4d0db43d1c5, 0x0,
    0x3fab2553b21dac93, 0x0,
    0x3fdbf47336a43160, 0x0,
    0x3fe5c3ab2ed5b111, 0x0,
    0x3fde72eebd155293, 0x0,
    0xbfb6d0df7f6081ff, 0x0,
    0xbfe0ceb8abfad8e4, 0x0,
    0xbfe79a503a259aac, 0x0,
    0xbfdf22d12c055f36, 0x0,
    0x3fa6767a12aeab6e, 0x0,
    0x3fe1a01a6f439b7f, 0x0,
    0x3fe87fe1c9d63cc6, 0x0,
    0x3fe086144caa0285, 0x0,
    0x3f92ade830a3b094, 0x0,
    0xbfdb6f1ea5f87822, 0x0,
    0xbfe6ac4516e2d545, 0x0,
    0xbfe1bf8fe76c358c, 0x0,
    0xbfa3bbc15e3b9e38, 0x0,
    0x3fdf5b226a3cc62f, 0x0,
    0x3fe3d4eed36e2c96, 0x0,
    0x3fdc76d05895cfe3, 0x0,
    0x3fb730fce35d89de, 0x0,
    0xbfe0bb730c04f669, 0x0,
    0xbfe7a401e481eea4, 0x0,
    0xbfe06cd60799b09d, 0x0,
    0x3fa6d09bfadd776d, 0x0,
    0x3fddd12c7a677ee1, 0x0,
    0x3fe6de50e1d77be1, 0x0,
    0x3fdcd20d9546e045, 0x0,
    0x3fb6ed57e74668db, 0x0,
    0xbfde6130d12e9340, 0x0,
    0xbfe5c68f352d7922, 0x0,
    0xbfe070ae5b85b1ec, 0x0,
    0xbfb2dd1032361c05, 0x0,
    0x3fdd9323a528cb28, 0x0,
    0x3fe6e590cdf3ae40, 0x0,
    0x3fda6d5fa3d0f600, 0x0,
    0xbf8a4a49b2e45682, 0x0,
    0xbfe1a46f96f25c57, 0x0,
    0xbfe43cbf4510e5be, 0x0,
    0xbfded0fd51e5eb0c, 0x0,
    0x3fa033ad21aa5c92, 0x0,
    0x3fdd78833e572325, 0x0,
    0x3fe4964bfef2ba98, 0x0,
    0x3fdc14fc56791707, 0x0,
    0x3faf87146501efe4, 0x0,
    0xbfe099c33aeb92d4, 0x0,
    0xbfe97902dc56cceb, 0x0,
    0xbfe06267b66aca74, 0x0,
    0x3f9d72563d4b0fec, 0x0,
    0x3fdf0e84c7a1cbc2, 0x0,
    0x3fe62137b502b559, 0x0,
    0x3fe01c6dd4c15433, 0x0,
    0xbfb249e99d6adf3a, 0x0,
    0xbfdfcf347c314bc7, 0x0,
    0xbfe69ce6f7088920, 0x0,
    0xbfde3641c1937807, 0x0,
    0x3f96220513774e99, 0x0,
    0x3fe24d69560d7acc, 0x0,
    0x3fe7cd99b71be115, 0x0,
    0x3fdd71d47ff73761, 0x0,
    0x3fa23229681fc4a9, 0x0,
    0xbfe0d8aada04ce23, 0x0,
    0xbfe692ee387dd8a8, 0x0,
    0xbfe011525d0aa126, 0x0,
    0xbfa623a0fdaf0105, 0x0,
    0x3fdbd9df7e934bf6, 0x0,
    0x3fe4ab420c7d3b9f, 0x0,
    0x3fdaee5e1611772d, 0x0,
    0xbfa2083403eeb94c, 0x0,
    0xbfe1094c17a31ae2, 0x0,
    0xbfe6c7753693d4c1, 0x0,
    0xbfd9ee39605c45ec, 0x0,
    0x3f835de9107b1a57, 0x0,
    0x3fe0372df688638b, 0x0,
    0x3fe6f38dc76ad3c0, 0x0,
    0x3fdcd07fc44abac6, 0x0,
    0x3fb0216757de8521, 0x0,
    0xbfe00b7be82e4e6c, 0x0,
    0xbfe6be38a9da7fdb, 0x0,
    0xbfe0ad6d706d546f, 0x0,
    0x3f9b11b64ef758a1, 0x0,
    0x3fdda5223f22212b, 0x0,
    0x3fe625000f35da6c, 0x0,
    0x3fe0deb2e36b7b13, 0x0,
    0xbfb4f9468211c3ee, 0x0,
    0xbfe13964ac887975, 0x0,
    0xbfe6f13c37813884, 0x0,
    0xbfdf4db9feedb31b, 0x0,
    0xbfaf19fc2d4e8097, 0x0,
    0x3fdcd003d0eb6e0e, 0x0,
    0x3fe69d739c5b3605, 0x0,
    0x3fdca397b971c98e, 0x0,
    0xbf950a407eccdd7b, 0x0,
    0xbfdddfc4885fcfdb, 0x0,
    0xbfe6ab1c35230821, 0x0,
    0xbfdd3f0546049184, 0x0,
    0x3fa448d580842145, 0x0,
    0x3fde3e4bb2cc2e32, 0x0,
    0x3fe68424dc301893, 0x0,
    0x3fdac33f2803cf21, 0x0,
    0x3fab4243ab65f9ac, 0x0,
    0xbfe061c4e0e779a2, 0x0,
    0xbfe7e272b33558b8, 0x0,
    0xbfe04e807c27e94a, 0x0,
    0xbf9bcdfb7c899e82, 0x0,
    0x3fe06c8da371fd94, 0x0,
    0x3fe92ce888585596, 0x0,
    0x3fdb2f48a1fe58e5, 0x0,
    0x3fa03b8eb27d4584, 0x0,
    0xbfe22c5e79e2f2d2, 0x0,
    0xbfe55c88c7c3a0d2, 0x0,
    0xbfe2c4e20639e186, 0x0,
    0x3fafbea490ee29bd, 0x0,
    0x3fdf345e3aeaa527, 0x0,
    0x3fe51a7a29010228, 0x0,
    0x3fe0abeb8323118f, 0x0,
    0xbf8fb9276168791f, 0x0,
    0xbfdbf10ef405d75b, 0x0,
    0xbfe9097e9e08bfde, 0x0,
    0xbfe119c9d1114ea9, 0x0,
    0x3f76514ae5d853e1, 0x0,
    0x3fe1cdd3d48e6cdd, 0x0,
    0x3fe68db7bdc0a179, 0x0,
    0x3fdc5bd663dd0e52, 0x0,
    0xbf9e2973bb7e4aec, 0x0,
    0xbfe0117c12752dce, 0x0,
    0xbfe65de1977cf835, 0x0,
    0xbfda423e411677f2, 0x0,
    0xbfab78978edeb3fc, 0x0,
    0x3fdd89473fd927f9, 0x0,
    0x3fe7ae304b09a43b, 0x0,
    0x3fe1658e245eb232, 0x0,
    0xbfa6bfeee58b865a, 0x0,
    0xbfe117442e4f70cc, 0x0,
    0xbfe46544bd26f8e4, 0x0,
    0xbfe1f4211189d732, 0x0,
    0x3fb5f0a1bf531a33, 0x0,
    0x3fe26d7fd99af811, 0x0,
    0x3fe7e0482af2e001, 0x0,
    0x3fdccdc7e83e8329, 0x0,
    0x3f92225de0761f4c, 0x0,
    0xbfe108ba46185e62, 0x0,
    0xbfe5760aed583922, 0x0,
    0xbfe13e458f511e61, 0x0,
    0xbfa4e30edaa498dd, 0x0,
    0x3fe2b8226e2511c4, 0x0,
    0x3fe899849eb0b1c7, 0x0,
    0x3fdcf6316cbf3910, 0x0,
    0xbf8632ef4e72f996, 0x0,
    0xbfe3b43ab88ceeb2, 0x0,
    0xbfe612ca1e2e730e, 0x0,
    0xbfe0225df066ee5a, 0x0,
    0xbfaf1922619c16e3, 0x0,
    0x3fe20fd525752327, 0x0,
    0x3fe32cce31c2c620, 0x0,
    0x3fe124b373b41d22, 0x0,
    0xbf9ee4f117da4b44, 0x0,
    0xbfdf25b0be716c63, 0x0,
    0xbfe64d8763fe6633, 0x0,
    0xbfdcb68e152df8b6, 0x0,
    0xbfb3b82d768dd035, 0x0,
    0x3fe179610c5fb989, 0x0,
    0x3fe56f608b0740f5, 0x0,
    0x3fde8c1863f78455, 0x0,
    0xbfb2cc3135725ff4, 0x0,
    0xbfdc575228cb6d1e, 0x0,
    0xbfe3c3540bd2f92e, 0x0,
    0xbfda008943db8271, 0x0,
    0x3f785eec956f75f6, 0x0,
    0x3fde42aa1e059f1e, 0x0,
    0x3fe7cb175c5af4b8, 0x0,
    0x3fdfe63db25a1034, 0x0,
    0xbfa97a5a756cf564, 0x0,
    0xbfdfcd47918af3a9, 0x0,
    0xbfe6d2ffc746241b, 0x0,
    0xbfde55221c208d85, 0x0,
    0x3f822f8bfb816b2d, 0x0,
    0x3fe0522f9edec64b, 0x0,
    0x3fe62420fc2a1205, 0x0,
    0x3fda0d898bc46bfb, 0x0,
    0xbfa35222c091561c, 0x0,
    0xbfe2626b80223414, 0x0,
    0xbfe5380fa6699f0d, 0x0,
    0xbfdca97d371165f4, 0x0,
    0xbf8ccd3ae6c8bb6d, 0x0,
    0x3fdd5d5b1deda31c, 0x0,
    0x3fe626fcb5169832, 0x0,
    0x3fdffe81a042b7c5, 0x0,
    0x3f7ceb8a62c408e4, 0x0,
    0xbfd8813ad4ec5539, 0x0,
    0xbfe6dd0f347d85b5, 0x0,
    0xbfe1fbf6b1e6f943, 0x0,
    0xbfa561eb4a59577a, 0x0,
    0x3fd99ab3ffe190b5, 0x0,
    0x3fe63ff30d0f881a, 0x0,
    0x3fdc93332b3af1b5, 0x0,
    0x3f92733a3b3b8c4f, 0x0,
    0xbfde1064267e9562, 0x0,
    0xbfe5789382d3332d, 0x0,
    0xbfe02f26758c7ecb, 0x0,
    0xbf8fff82bdb4afff, 0x0,
    0x3fe099f658abb7d3, 0x0,
    0x3fe6dc0fef840fc0, 0x0,
    0x3fdd261253a0d662, 0x0,
    0xbfab4b4d6151ac5d, 0x0,
    0xbfe117f2455ae306, 0x0,
    0xbfe69832ce241e00, 0x0,
    0xbfe361a46975f191, 0x0,
    0xbfa9efe7262bbdae, 0x0,
    0x3fda9fe8f6702785, 0x0,
    0x3fe5a568111b75b6, 0x0,
    0x3fe062a101757a64, 0x0,
    0xbf6666b383614090, 0x0,
    0xbfe14c8f20132b38, 0x0,
    0xbfe56b5c8e044922, 0x0,
    0xbfdf7a9f48cd36fa, 0x0,
    0xbfad33c13be1651e, 0x0,
    0x3fe10ed720ce28fe, 0x0,
    0x3fe63dc84025d691, 0x0,
    0x3fd8b03fe21bcb7a, 0x0,
    0xbf99688243881214, 0x0,
    0xbfe0251f6edc5efa, 0x0,
    0xbfe6a2731bbb5dac, 0x0,
    0xbfe05fb2f9ba3809, 0x0,
    0xbf54ccb2543c949e, 0x0,
    0x3fdf9dcdeed5be1a, 0x0,
    0x3fe7ddb4a0207fd0, 0x0,
    0x3fde67b87717eadc, 0x0,
    0x3fa084ca0793759a, 0x0,
    0xbfdffd5ebb9aca78, 0x0,
    0xbfe27c8838eb446f, 0x0,
    0xbfe1bed5eb591bae, 0x0,
    0x3f503b0ba9406be8, 0x0,
    0x3fe3bec8c75e66aa, 0x0,
    0x3fe8aa4bd011035c, 0x0,
    0x3fde70dd85d9b3b0, 0x0,
    0xbfae104b19160f8d, 0x0,
    0xbfe121fb906fd7e6, 0x0,
    0xbfe967ed75c5b795, 0x0,
    0xbfddafb27b326246, 0x0,
    0xbfb0ea14938b2c6a, 0x0,
    0x3fdd9b86fd22df02, 0x0,
    0x3fe5675d41e70141, 0x0,
    0x3fde433d8652614a, 0x0,
    0xbfb20b6f5cf77a5e, 0x0,
    0xbfe00d0777071366, 0x0,
    0xbfe595278e390fe1, 0x0,
    0xbfe22fbaacbe0ec3, 0x0,
    0xbf7eddb2a931a037, 0x0,
    0x3fdfa4dee003460b, 0x0,
    0x3fe48949d49bf595, 0x0,
    0x3fdfe0fa5d92cb19, 0x0,
    0x3fac89ca0278f8fb, 0x0,
    0xbfdcec3a100a88b1, 0x0,
    0xbfe60e68830be277, 0x0,
    0xbfe0df64c2a0f651, 0x0,
    0xbf9137403ba1d6ed, 0x0,
    0x3fdb1ed97e5e34a5, 0x0,
    0x3fe565541b7d70c5, 0x0,
    0x3fe012cf388c7666, 0x0,
    0x3fbdea891dc7ec0a, 0x0,
    0xbfdc55f2ec69abcd, 0x0,
    0xbfe5a9e729f9c61d, 0x0,
    0xbfd9c9b97aea1621, 0x0,
    0xbfade623c6432c1d, 0x0,
    0x3fddf7e31be564e6, 0x0,
    0x3fe4e264a7872cde, 0x0,
    0x3fe27a5ebb9db93a, 0x0,
    0xbfb443ec796f21b1, 0x0,
    0xbfdfeff7134a6046, 0x0,
    0xbfe4f4d26c70fc52, 0x0,
    0xbfde0f41298553ff, 0x0,
    0x3f8e09d828265d4f, 0x0,
    0x3fe180156350c948, 0x0,
    0x3fe808994a3f0f23, 0x0,
    0x3fdf5c1166eff8bf, 0x0,
    0x3f742d4ce6366252, 0x0,
    0xbfe1a191e6fa610b, 0x0,
    0xbfe89507d94db855, 0x0,
    0xbfddbb4576d57c52, 0x0
    };

static const uint64_t in_cifft_noisy_4096[8192] = {
    0xc00ada05db8ecc9e, 0x0,
    0xc006a1903c67d7c0, 0x400b901cafc705ff,
    0xbfe0a84a0db6bb0a, 0xbff358360c005e2a,
    0x3ffaaa37eb686be0, 0xbfed04f1d3dc3e40,
    0xc007f1de29fb936a, 0xc004b423a087d05a,
    0xbff6a9923068a897, 0xbff97cb6c2ff438f,
    0xc00525ff8ec1db23, 0x3fd0972b464b1cb0,
    0xbfde019e83458ce8, 0xbfebe7e26cd694da,
    0x3ff86e96d1b9de20, 0xc0046f09757d79aa,
    0xc00e6eebb57f15b2, 0xbfd5b55fd0ad6388,
    0xbfebb919e5f42b89, 0xbfea1ed645854b97,
    0x40054f4cb2ee20c9, 0x400a2bbe9ca4d958,
    0x400b1b02c8987466, 0xc010d041c874d5a9,
    0x3ff1b79f361f42a2, 0x3fb391effef54f24,
    0xc012777ef521054c, 0x3fe6c66fd53ce579,
    0x3fd3c34c67c31f7c, 0x400b3fe39a93f251,
    0xc00221b8ef5e3a80, 0xbfe6a925742f8daa,
    0xbff21632dd8dc072, 0x3ff0c9c1680dde08,
    0x3fe3b946b6763084, 0x3ff4b1b25d3bab1e,
    0xbfea85301f7619e8, 0xc00583a260efce52,
    0x3fff4dc7c348efed, 0x40055b3b77c6dbd7,
    0x3feb224f45ba1831, 0x3fe6fdea5caa6e66,
    0x3fff6c00e2a1802b, 0xbfc4c7972061c060,
    0xbff25e4e5f33450c, 0xc0064d8f2552c9d0,
    0x40017c20d9f03d65, 0x4003147b7e83e8bc,
    0x400c91e76575ea28, 0xc01004442d8284e6,
    0x40101665cab474cc, 0x3fed88502f726abd,
    0xbfe884a035c45bf7, 0xbffeb3d5a846aeae,
    0x3ffd87cb94ce14e0, 0xc0023930d9fe687b,
    0x3ff31c54e4d50b70, 0xc0055b34833cb5f4,
    0xbfcbf94f28da5608, 0xbfd7d5d94a468aa8,
    0x3ff41266dd35052d, 0xbfee9e3eeae431fc,
    0x3fe73d56f1c24014, 0x3fff57c9050c920a,
    0xc0065017e8448b24, 0x4005f6cbb9364166,
    0x3ffee25a10af403d, 0x400acd2596a0f27d,
    0xbfe01d9588a4ed41, 0xc004b7dff1219644,
    0xbfe61c92debedc40, 0xbff348a8f2a93a54,
    0x3fd27b194896da7e, 0x3fc8fe622d479bc8,
    0x400714999595f500, 0xbffe854790399199,
    0x3fb55ef77f7fd3d0, 0x3fec4e2f1e343e65,
    0xc0003f5be65a8f14, 0x3ff8a137ce3f59e6,
    0xbfdb797fd2bd0758, 0x3fdb8a2049509f60,
    0x3fd494f85d2e6d44, 0xbffa477344657a73,
    0x3fea19eed58c1e50, 0xbfe89e1cfbe35b74,
    0xbfa2a94df0c65910, 0x400585f64e41fe1e,
    0xc005a649dc88b323, 0x3fd0aab8e0423d1a,
    0xc00af94cb8c9689d, 0xbfdaebd89dbabe17,
    0xc0055950a6325ce6, 0x4006cec1d22cebb7,
    0xbfd3bab104e637d8, 0x3fe5835efedfbe8a,
    0xbff47e73c5dc46e6, 0x3fb4450a300705c0,
    0x3ff22998a35366ea, 0x3ffa734923ecf650,
    0x3fc19fed702dd5f8, 0xbfe306ae2bed9906,
    0x400b06c87be07f50, 0x3ff01f8364d8b724,
    0x401212651ab79ec3, 0x3fd0046224943df8,
    0xc0064d092737435e, 0xbfc774991f1ed678,
    0xbff268558ce83e38, 0x3ff2bd8aa081be16,
    0xbfde12463e5da010, 0xbff21ad7a75c389c,
    0x3feadf7c1e850ea0, 0x3fe66e695ac5db34,
    0x3ffd016bf066f5ae, 0xc00da3e5faed69cb,
    0xc005f99b6a69bbda, 0x3fe34dc28d46f571,
    0xbfea6869a1d48996, 0x4000c3cc7e25e281,
    0xbff5400031be02ce, 0xbffb486bdb12a172,
    0x4000d40c65697d8d, 0xc002744d80601e3d,
    0xc0048296915c02ed, 0xbfcac6c6cde7bcac,
    0x400aa061c9c32347, 0xbfbf9ce6ed0ae780,
    0xbfec4f8a72f1d87f, 0xbff006f4f1cd0b5e,
    0xbffe21244ce7391c, 0x3fee739ed63f9048,
    0x4004cfcbd7bc2483, 0x4008886d979b7144,
    0xc018170930d5f952, 0xbff511d1e4b4b17e,
    0xbff91d1e890078da, 0x3fcefea70c7a8584,
    0x400e420acc04d88a, 0x3faef16261c18f80,
    0xc00cba2e8a70fe96, 0x3fd67f068ecd1f8e,
    0x3fe0c42b9df6d89e, 0xc0088ea854cff52e,
    0x3ff85340bc330f7e, 0x3fe4fe1d840ea18d,
    0x3fe49b3e9f492216, 0xbffb78e133ef69b6,
    0x400328a776b8bcf0, 0x400585b56f9d4583,
    0x3fc495cb241c762c, 0xc002a64793942d96,
    0x3fee1bf14e77405d, 0xbfeb376a4b1be886,
    0xc003fac79b59ba8d, 0xbfe0c8e461cbad5a,
    0xbfe7fe11567070ed, 0x4005e07f7f427c7e,
    0x3ff7a99774428809, 0x3ff566a6a6c62100,
    0x3ffac0a970d14d18, 0x4007dfd6cee7f4a1,
    0xc013d55fbf93efd7, 0xc0110c4fa3d35ac4,
    0x40091b09c1ed98c7, 0x4002c4c63a2b3c80,
    0xc00261dbaa3f608b, 0x4002d897d3334a1a,
    0x3feeb65ec522d858, 0x3fd933feda9bf323,
    0xbff464b7ef2538a3, 0xc0049cd89364dfef,
    0xbff76741785b883d, 0x3fe53278fb7a8564,
    0x3ff1675489940138, 0x3fc94df69b62adc8,
    0x3fb449e7dc53d400, 0x400e8b09e49fd89a,
    0x3feae7f2cb24d396, 0x40079acce85984bc,
    0xbfff3d57c3bc623f, 0x4015d4fb17677b12,
    0x400898a007850720, 0xbff60ce4a63304f1,
    0x3fca959d60f06e54, 0xbfff4bd0d58db406,
    0xc005bbd8950da918, 0x3ff906a905312300,
    0xbff32e34ef2e2a2a, 0x400051b65ca6bce3,
    0x3fc38adac9644470, 0xbff29f7d17b52112,
    0x3ffd429c8e81d2b6, 0x3ffd369d16b8dd95,
    0xc00119a6db0b9879, 0xbff99e0539a9fc0a,
    0xbfe0aca4d8a16be9, 0x3fca9ec8f24cf66c,
    0xc006f3c509a2bdec, 0xbfd3d360eba2a0a8,
    0xc00758b15fd94a26, 0x400176fa55cfe73d,
    0x3ff562fc2ead1296, 0x400139898086f3c4,
    0xc009d2ac85c7beea, 0x4008e8486d47d159,
    0xbfd0caa6d1553fc4, 0xbff219a0e58a4aad,
    0x3ffc798b080e9050, 0xc017b5af7f4add3a,
    0xc0074e15fc1070be, 0x401b7b0a8416904b,
    0xbffbaf1a18b82e6a, 0x3fdff6235a1c9ce4,
    0xc0039a2fef64c232, 0x3fe9043bf7584c38,
    0xc00e71e3ab1ac6f0, 0x4001f4377581ce3a,
    0x3ff710936ee41b0d, 0xc00b7dea643edb3d,
    0x4007d2f07d73c645, 0xbfc4a27fe8bef0c0,
    0xbfe1fa1ea69f0fda, 0x4000685dc1913f76,
    0x3fffe9970df9bfee, 0x4015e17bfcbee668,
    0xbffe163614251f30, 0x3fe5ae4a262c2e24,
    0xc001b7b377c6d93e, 0x400888d95736025d,
    0xc0023993c60fd50d, 0xbff0c52e01d1927c,
    0xc0043ad540cb7248, 0x4010234a1db10abc,
    0x3ffeaa29cdf081b8, 0xc00f4486fa56a8dd,
    0x3fe2dd6b39f9c9a3, 0xbfe271cb29968b4e,
    0xc00f5fb2f5d48b98, 0xbfe341d9d480ce76,
    0xbff46b2273b05c9c, 0x400d0ef40d5712f4,
    0xbfe01414a89a9360, 0x4002eb16781f0b68,
    0xbfc98c60e1083906, 0x3fdc21a362805e26,
    0x3fb60fcee2b74490, 0x3fee15fc32908ec9,
    0xbffca9bdc194953d, 0x40130444a0e411ae,
    0xbfe15b0776c90bef, 0x3fffc55346697a60,
    0xc0011c153e610280, 0xbfe8fc4737cce8e8,
    0x3fec46fbc7c6eebc, 0xc00f9739a51fcf96,
    0x3ff569391917becc, 0xbfb7551b1aa95cd0,
    0x3fb0ad66baca8910, 0xbff34c5a3c17239e,
    0x3fe54d28ed25edea, 0xc005b3ae78920628,
    0xc011707ca2566f17, 0x3fda6b9773609810,
    0x40089d0334444434, 0xc001a0efe9a27bd4,
    0xbff342a20a4d799d, 0x4004a12d79c04088,
    0xbff34ca3372619ec, 0xbff0254389815214,
    0x40134a206c381510, 0xc0044e2e5df3597a,
    0xbfe7366c6d947db6, 0x4003d4ee617a197f,
    0xc010da54ee8c093a, 0xc015d4fe86cc583e,
    0x400eb20c90427f2c, 0xbff57b14a1abe210,
    0x3fcde4882a539ba8, 0xc0057c7470cbd980,
    0xbff09d6290e6f2e0, 0xbff6615dd5248f79,
    0x3ff57c9cb36dc932, 0x3fc442e80ca3f540,
    0x4000b32ef97af6f0, 0xbfb25f1038a4e780,
    0xbfcdc89b7a4f3cc8, 0x3ff8b0be8f24f36c,
    0x3fef247f10d3fcca, 0x3fd3bb8d209db414,
    0x3fecac3b97363ef4, 0x3ff8d67b8283db02,
    0x3f97ab573a2d18c0, 0xbfec5d32e5a6bdf8,
    0x3fe5d2b2f1bfa6ef, 0xbfd53a709faa0b9a,
    0x3fed990e9cb274cc, 0xbffa600dfc18c752,
    0xbfc510d37533d5d6, 0x4003684d7743b029,
    0x400ee37288fea35e, 0xbff1573c40aa8ad1,
    0xbff2d521c0e6bcc8, 0x3fe095dd52a80473,
    0x3fe1154226cd1ef2, 0x3fc63ee85d50d846,
    0xc00c4f27dd02ee34, 0x4005190e75a6b92e,
    0xbfbd1f93907c2d68, 0x3fea293398d7c550,
    0x3fe71e5389b562b1, 0xbff8e28b06290f2e,
    0x400865cfcd9f1b62, 0xc00212e16f70eb9e,
    0xbff57ffa50a26448, 0xbff2ca1dfe7d7fc6,
    0xbff50e0efafba145, 0x3fff2c6f8d10873a,
    0x3ffed5cec9a041ec, 0x3fdfe59187d51e08,
    0x3ff1d7f9f4d073f0, 0xc00bf5a065c7da8a,
    0xbffff76994602c47, 0x3ffce79f21d1c274,
    0x4017d1d3c9da9270, 0xbfd68562fc8a6c58,
    0xbfc8d651586d1648, 0xbfe0c258e4918538,
    0xc003d58ffb8a1d51, 0xbff08ab2ccb9d808,
    0xbff43c68d741e69e, 0xbfe9ece15a072a72,
    0x3ff13622e83cd2e8, 0x4000d8acb828c44a,
    0x3ff4674b595e7500, 0xbff6330a65e82818,
    0xc00b45ed9535b8fa, 0x3f8513297e953480,
    0xbfa6716316c23300, 0x4009a57928524f01,
    0x3fa0c83f077dc440, 0xbfefe81d4bd171b7,
    0x3ff48df5f20e4394, 0xbffe7e7988b9879e,
    0x3fdbdaa3db77a5a5, 0xc00155408e75ff0a,
    0xc009df948c2274be, 0xc003e192ef6d3e88,
    0xbff45b4ab46f2964, 0x3feaca7eed9712ae,
    0xbffd9428d27106ba, 0x3ff6d995228a2901,
    0x3fe231cdee7967ff, 0xc001cdee2953eeba,
    0xbfbe24c7b4cd2c10, 0x401143970dc6155d,
    0x3ff155efa90a7bee, 0x3ffcb9eb52102dc2,
    0x400d229d295945b6, 0x400092dd570b3711,
    0xbff04b24605c7ba9, 0x3f68941b8e789800,
    0xbff4c85643a39e6c, 0x40165ff1ef852648,
    0x3ff8abb723b784d3, 0xc00b6bcfdfe28962,
    0x40035c1b6a2727d6, 0x4001381fd583d028,
    0xbfe31d221cb95190, 0xbfe74cb78cce5b57,
    0xbfcc20d4efcc83fc, 0x3fff6c1a3ddce4e0,
    0xbff97ff4b9268f0a, 0x3fa2cba1c9768b40,
    0x40075957b79a24d4, 0x400446d17f8a4eec,
    0x3ffa4d02df81028a, 0x40043cce6b000f28,
    0xc002536f9cb5e0dc, 0xbff13925d0cd1270,
    0xc0064c461c4ade8b, 0x4000be43b0968e42,
    0xc00a9b5e6a523c64, 0x400bd9eff45fc756,
    0x4008eae9b8d90e5a, 0xbfd65ee0a22ef8a4,
    0x3fd342d1a3b8569a, 0xbfff12182425dc00,
    0xc00dbc5bdd6456bb, 0x4001f27a8b39b6a2,
    0xbfe9186b45e8f3d6, 0xc004521f33a27d11,
    0xbf9f655f1f162650, 0x3fdc282df2c9cb30,
    0x3faf297a5d9aae80, 0xc005466054e3332c,
    0x4000914f865da3f9, 0xc0118920eb7f416c,
    0x3ff8315f8c838e4a, 0x4009900e232011ba,
    0x3ffa29fab7c953f3, 0x40060014b45f1bd6,
    0x3fed00903aef4bd6, 0x3fe6f77dc0efdda9,
    0x3ff582a7d9904ef2, 0x3fd97eaae0dfe14c,
    0xc00ad62dc706c3aa, 0xbfd425f4e9a51e22,
    0xbff42029dd34ef23, 0x3fdf2262b7e3429c,
    0xc0078e43a65d70ee, 0x3fff38a25b01b866,
    0xc0014dbd72faa607, 0x3ffa6d5dd1cb5037,
    0xbfff5909432fbc5f, 0x3fa50bc485c20aa0,
    0x3fe08586f78cd690, 0x40008cc2daf75915,
    0xbfd170821accdf74, 0xc00c0e45dd45aa04,
    0xc005416af26099fe, 0x3ff938d6c8bf60b2,
    0xc01312cd5fb42d1a, 0xbfc656614f41ff00,
    0x3fa90fc7514eb550, 0xbff6e62dbf0c6575,
    0x3fd17b981a1389e4, 0x3fef2229a5f9f970,
    0x40013e58b3ea190a, 0x4010cbaac646a557,
    0x3ff6d2535dc3167d, 0x3ff9a4d6e6186375,
    0x3fe246b844588a63, 0x3ff3d8d420f60150,
    0x3fe5c7293815dd1e, 0x3fb5cea3210e7560,
    0x3fca0b59bdc1f540, 0xc00e16016cab8bee,
    0x3fddab266bc783e8, 0x3fea0aa8eb683730,
    0x3ff3293bf5c19acc, 0x4009aae2a5d8d0c4,
    0xc00544aaff5bb365, 0xbff5cebde63e216a,
    0xbfdd08b14c046de0, 0xc000c0ed043fda46,
    0xc004da65d3cd012c, 0x3ffa20a00bd9db93,
    0x3fe4c929b2eb9786, 0x3ffe38a037126a64,
    0x3ffabee05eb778de, 0x3ffbb07717abc286,
    0x3fe19f115878b368, 0xbfe0cbc3e4e767f0,
    0x40037814ba734e68, 0x3f5893cede09e400,
    0xbfd6c12278680822, 0x3fe10ab582f6a86e,
    0x3fd75afe261531ec, 0xbffac2b9bdb6e850,
    0x3fea8ae38da8b634, 0x3fc718b86d2b6a8c,
    0xc000b8cc4eb47fab, 0x3fe02cbc8de8fdcb,
    0x3fb963dc507e7c40, 0x3ff50eed791014e1,
    0xc0033f727d14b9c2, 0x3ffdf4096c7dc9b4,
    0xbf856ad75baa9780, 0xbfe2fee6d2306987,
    0xc002ee0d305ae740, 0x3fff41491d5324b0,
    0xc006e7d0fe40bcf4, 0xbff3e45d04e0c9fa,
    0xbfce397a1d7a7070, 0xc00f89d780cf8563,
    0x3ffbde638a8f5c04, 0xc0053536ed13a03f,
    0x40086c69cb14220e, 0xbff27815d25eeacc,
    0x4014bd40ca6634fa, 0x3fd787f6cfbc6f90,
    0x400382861797880c, 0x3ffe5b28af20ef89,
    0x401174130a2e1de2, 0x40013886729a8572,
    0x3ff0edaec9868248, 0x3ff9d370f36cc2b2,
    0xc007837237b32ec2, 0xbffe2002c5ae3398,
    0x40007425bff897a7, 0x4002f50756c04e0e,
    0xbfd4fd21f182da54, 0x3fd5020125a919fb,
    0xc00a8f81204da6f0, 0x3ff208ffd2cd1836,
    0x3ff25e2994f87087, 0xc013e9fd65d749c6,
    0xbff5a91534307d1d, 0xbfda2e1d8e4a33e8,
    0x3fda205108265158, 0x3ff2cd7010816c02,
    0x400a3e90f776265d, 0x3ff96eba3e881bec,
    0xbffeeef5d0d7dbfa, 0xc005a2edefa883c5,
    0x4006072dd3d9f63d, 0xbfe1c2460698e39a,
    0x400987d6b33ec3d0, 0x3fe7cc75dd5a5ef4,
    0x3fe632d4fc7b3b08, 0xbff3edd26227f674,
    0x40115c4058d0a323, 0x3fed52e1fbb837f4,
    0x400f63ac68726f08, 0x3fefd9996bd00fae,
    0x400a5665149c3963, 0xc007851c3d1fe800,
    0x3fd5b17fbd2f8c4d, 0xc00ed0ebe9a8ef54,
    0x3ffaa8aaa94adcbf, 0x400db96b387fa904,
    0xbfe43d612952f199, 0x3ff5d80e7a93b2ce,
    0xbfdb4d8cced35dec, 0x40104b78a050e870,
    0xbff2d375fec62d4d, 0xc0001add489cccc4,
    0x3fee82b92a063f80, 0x3fdd832c97b91cb4,
    0x3fb083ecff18f5e0, 0x3ff9c4ab9f0b24cc,
    0xc01932bfae2afdb5, 0xbfd661a7705295ac,
    0xc00ee154a1a426e6, 0x3ff9fac2c1af3873,
    0x3ff61714630353fb, 0x3ff49774e2810cb2,
    0x400e2661b4ee0ef4, 0x400d7a05c44c1991,
    0x3ffefd038fb80c9d, 0x4003c86d9ae79a14,
    0x3fd13513fd36bed4, 0xbfe91f50fbd67c4c,
    0x3fe81560acbb8dd0, 0x3ff88265534a9965,
    0x3fb145ac2d7a4de8, 0x3fe619b06d4105c0,
    0x3fdafda65410474b, 0xc009810b27f2beb9,
    0xbff8fb97f14a95e0, 0x3ffa43301fa7ece0,
    0x3fff637e0f5f0d17, 0xbff3c87d638250c2,
    0xc00460210516627d, 0x400433f7f8497961,
    0xbfe5fa152ffd0ce0, 0x400edc4b4423e58c,
    0x3ff1210290983662, 0xbfd7b49413c6f5a0,
    0xbff8b9953841a651, 0x3fe6722805c4a958,
    0xbfc018e36fdad8b0, 0xbffbaecce77a2848,
    0xc010804a05b83229, 0xbfccbf74b51894f0,
    0x3fd3806540b6f458, 0xc007af8403ebebd0,
    0xc00fcea59ee8477f, 0x400c93e753151576,
    0xbff430f0ccc1b63e, 0xc00ca68d5afcaf67,
    0x3fffecdf1891c9c4, 0x3fbd45beecac7678,
    0x40089ffaf0d82916, 0x3ff671d6b7dbc453,
    0xbfe0c30c7e2e90c2, 0x3fdc4d968b068542,
    0x4003f6c32f3f4814, 0xc0074276711e5c9e,
    0xbfdeab590407deec, 0xbff8af4b853a05d9,
    0xc0146917bed300a3, 0xc00dbbd176e9b426,
    0x3ff1f9babd06bf1d, 0x3fdbec1c338d1e8f,
    0xbfc7953077b01bbc, 0x40007a9a6bf77c2e,
    0xc006e97e7627bb43, 0xbffe3d510570ec2b,
    0x3ff4dddb45053f63, 0xbfc98b6915cddf6c,
    0xbfd096c4106b0e2e, 0xbfe73620c85e73d8,
    0xbff083eba55bdfc8, 0x400badf35fccfd0c,
    0xbfb04ae53a485d60, 0xbfd617ec18109952,
    0x3fe53a8d8b54571b, 0xbfda281be61e6d3c,
    0x3ff3e2ac063a1485, 0xbff06ce0c929d07a,
    0x40019fbe5a27d97c, 0x3ff21806386e160f,
    0x3fd6ae4574fd3808, 0xc001f8f933b6f42e,
    0x3fee967c7b73628e, 0xbff25d86bd513d8e,
    0xc0045dbbf1118b1a, 0x3fed3801f7c2fcc7,
    0x3ff161c4429f0b7f, 0xbff771e24cf0181c,
    0x3ffb572488ec83e2, 0xbfcae67480d2e850,
    0xbff3f615b41eee31, 0xc00175b59029193a,
    0xbff672a9979abc06, 0x3ff8c2c1e4920a6c,
    0x4012970709eaf494, 0xbfcec7668947bd80,
    0x4006c6d541ea241e, 0x40019ef3ee33a74e,
    0xc00948fe4ac992f0, 0x3fee150ffd53fca7,
    0x4001aac6d88f5424, 0xc007d186e42e8e1a,
    0x400163c392fc2102, 0x400a5f7234e25064,
    0x3ffe067df256cd38, 0xbfd56d3807e8388c,
    0xc0132100c2fc1474, 0xbffebc43439a4b8e,
    0xc008c0a500d5d954, 0xbfde7256bc35bc60,
    0xbfd7334389913243, 0xc0023fd1402c8474,
    0xbff768bd50902f20, 0xbff19d2adb1e73bc,
    0x3ff75cb43afed7bc, 0xbfeb0e2b9b2b162a,
    0x3ff0193a2a1f8b1a, 0xc0165f4b53e5dadf,
    0x3ff5aeff64aeabb8, 0x40166cbef49a8288,
    0xc0068d8592e06dc4, 0x4001298279c76875,
    0xbfff314570f6e35a, 0x401c43f667cb5032,
    0xbff26eb1b435ae24, 0x3fef6e7bbeef97ae,
    0xc004a21e9c6228e6, 0xc002c061c8463c9a,
    0x3ff040048edb5b92, 0xbfefa80b38f76cc4,
    0xc003a3c08eaca314, 0x3fec10febc7b8d72,
    0xbff79413bd969c1c, 0xc0118ce764e98de0,
    0x3ff06d5854182de0, 0x400467c6bbe21984,
    0x3fbca838cbbbace0, 0xc00d437e15f5fed2,
    0x3fedf771399ae087, 0x3fecd890c79f3ee6,
    0x400eae9903517f21, 0xc0077de9b802e612,
    0xbfe59fcdeb84e92e, 0x3fc65ac63dd9d1a0,
    0xbffcf49f3acb8ed9, 0x3ff4aedc898f0a7c,
    0x3ffcae02e0a319c4, 0xbfeb319bd368c19d,
    0xbffb65945b7d0312, 0xc00f5218ef53607e,
    0xc00585ae0fda3589, 0x3ff196284dc0db6c,
    0xbfebf110d405b678, 0x3fb874eb51d93a50,
    0xc00461582c324158, 0x3ff55c5299765346,
    0xc005afd77186fb68, 0x4006569ef49e7db8,
    0xc01cc983103bef82, 0xc0168b87e27645e4,
    0x3ffcb3709c7442f7, 0xbfe1027889a40206,
    0xbfe7a1de064b875c, 0x400c9a00a486b9d3,
    0xbfd960fb093f9a78, 0x400579a8936af0bf,
    0xbfbc307a1c5c3220, 0xbff233628887f62e,
    0x4004fa4b8b8603e3, 0xbff5edc9af040e44,
    0xbff510985b91afbf, 0xc00d457b73ec156c,
    0x3ffa0fc5111db991, 0x4000cf717ee37f59,
    0x3ff5c8def951af18, 0x400443cfb41c5d4c,
    0xbfe2a7ece143ff56, 0xbfeebcbf1ba848d4,
    0x401512718f65c33e, 0xc003b142cd53da4e,
    0x3fea5264739d20ac, 0xbfe2483b01cedaea,
    0x4001837c36350450, 0xc009268290ff8f5a,
    0xc004ca7ae5e1a742, 0x3fcc8cd169be09b8,
    0xbfcc5d44b630610e, 0x3ff1b886a9994dd5,
    0x40045a21edd91474, 0xbff6114ef81a26f1,
    0x3fe4bb764baf912e, 0xbfc9f07caaca8bd0,
    0x3ff538d4c7c7cec9, 0xbff100ee79ec1538,
    0xbffa43d237aba7da, 0x3ff7104c2095e5be,
    0xbfae923612b4b590, 0xbff9c6951ff16003,
    0xbfddbf8fda2e7e92, 0xbff50cc80f81a666,
    0x40118f59528c76fa, 0x3fe56114f5027145,
    0xbfe2a6ee626bc0de, 0xbff4fb2300401558,
    0x4006f2769779ba21, 0xbfef90333dcaa032,
    0x3fe424baf72ba55c, 0xbfce7bae9c6821ac,
    0xbffb066a9371c228, 0xbff5aaad6bf45e36,
    0xbfe5fd7e4e9bac36, 0xbfe0a421afe8f70d,
    0xbff3cc3b9dbd025f, 0xbff2412e4903a508,
    0x3fe1de3a61f62d05, 0xc00dddf3c644cc06,
    0x3ff787b3659ee5ef, 0x3fe60ea0010adffc,
    0xbfee7aa68385a9fd, 0xc007e012500c9410,
    0xbffed74d9efdbaa3, 0xbfff8ffdadf187d6,
    0x3fef5647ed6da744, 0xbff77aee1cc0eda6,
    0x3ff216755b9667fc, 0x40019a9932435ef2,
    0xc01e0869e000ace0, 0xc0036538bf8f725c,
    0x3ff4cc0ccf104322, 0xbff11f4ccb29c6ca,
    0xc00b678d88a0b55a, 0x4004db708accaed2,
    0xc000b676501e6304, 0x3ff5cf09bc5899d0,
    0xc0099c610cf85cb6, 0x40112e1f53912812,
    0x400cb42b52eb98d9, 0x3fcdf0feba322610,
    0xbff27562e3422df0, 0xbfea4243310610f0,
    0xbfff077bdf40ec9a, 0xc00846065bc2281b,
    0xbfe02558c9d6d660, 0xbff04bafa49bbdde,
    0xc00816f72bf3cc44, 0x4000a40692ca09bb,
    0xc00b569b53235507, 0xc00ab2958d3717c3,
    0xc013d86639f5d05c, 0xc00f49f78e37a23a,
    0xbfe2d39ac8d9d81e, 0x3ffe58793b62e59e,
    0xbfa805c31bfb3a38, 0xc000c06786ed0bbe,
    0x3fe7126ce18bf2f0, 0x4002b621114be153,
    0x4002a7ba133df790, 0xbfe8464943a38764,
    0x4015304ce2378334, 0xc008fcc2a3ca0088,
    0xbfd500ced242f376, 0xbfd8f15678719d84,
    0xbfff2525854a84a8, 0x3ffc0cbfeb72382b,
    0xbfc30fac231e81e0, 0x40013392ffd3a754,
    0x400351a03f409254, 0xc00aee6729daa78a,
    0x4003d53f51f04be8, 0xc00f01110f270cb0,
    0x3ff2f5b15cc53d16, 0xbfb04e7a70b2a9d8,
    0x4005efe18d21816c, 0x400625e3ab091012,
    0x3ffc802d75a4a2df, 0x40131f5476797328,
    0xbfd745baac75daea, 0xc00faaeab7342ff4,
    0xbfd444a58350c632, 0xc01410f6a460f74f,
    0x3febfa5a2db11d18, 0x3ff5a917d9f69098,
    0x4000a410987099ad, 0xc01e15a0a5eb8024,
    0x40060450a350950d, 0xbfda759feea4ac60,
    0xc00aec64c1f04fb7, 0x3ffd1db85af74fc3,
    0xbff265f5cec8b314, 0xbfff1e74141b45fc,
    0xbff05c98c207de14, 0x3ff6ccf51a5416b8,
    0xc004f5fc71d49034, 0xc01305bcba58ae96,
    0x3fee543059b8e7e1, 0x4003babe8d4026d2,
    0x3fd4c18221cf2590, 0x3fb184d0c821e3c8,
    0xc0139d2bd1d00bee, 0x400078d228b9a0fb,
    0x400f1a732fd96704, 0x3fc0948f8908f650,
    0xbfe564270f4575b2, 0xbfd92e54a9eb2c20,
    0x3ff0a45992346476, 0x3fd0602474e0aadc,
    0xc00cca00ec70cf09, 0xc00570bc5b5e1ff8,
    0xbff986bfd16be2ad, 0xbff9842ee0869abd,
    0x400787b200071c21, 0x3ff3b1b1653f4654,
    0xbff39d96cb473947, 0xbfb5f6e2c39128e8,
    0x3fb20bcc6346a018, 0x3fce6f3ed18afab0,
    0xc003b554018fc64f, 0xc010f5902c34ed1a,
    0x3fda50f337e6df45, 0xc018bbac0b652bfe,
    0x4012da56652b134f, 0xbfc9301004fb9a50,
    0x401838f5395db66c, 0x3fcd791d54e40e9c,
    0xc0116885c305654c, 0xbffdbecea85b0802,
    0x401531cb819f042e, 0x40092585225d6b1a,
    0xbfe4748210e3ed6c, 0xbfe3c3a8260a6f16,
    0xbfa8f22d26cc88e0, 0xbfe76e454bc3e7e1,
    0xbfb56aa70c9cb6d8, 0x3fcbff6bb9050f1c,
    0xbfd9b05d07317034, 0xc00ece112f035cba,
    0x400713e860e403ac, 0x4010e7d6fd4fcf21,
    0x3fee0a0b1d551608, 0xbffd86272c649f78,
    0x400382b2f78fb892, 0x3fe3091f1975199b,
    0x3fe1ee78b1001fff, 0x3ffdab260a0093d0,
    0x4016b848363f8597, 0xbfd398041fb2b7e4,
    0xc007a88cddead8f8, 0xc003bfdb0e32966c,
    0x3ff149101ab58230, 0xc00b05da19002d10,
    0x3fd329e99c1c3112, 0x3ff21b7bd784e8f0,
    0x40004fd6014307b2, 0x3ff1e0e94d91e137,
    0x400ce896356c6e28, 0xbfe79db602068920,
    0xc0059386ee3e5176, 0x4001972d598050a0,
    0x4013ba52f2759e90, 0xbfef0e74b61b5d03,
    0xbff7172eb4c1b863, 0xbfd184e8f10e0a1c,
    0x400223bc4eced592, 0x3fe7abdd8bab8421,
    0x3fbb72ae501768e0, 0xbfa5a4668b08cec0,
    0x400ec7d9f4a58aeb, 0x3ff40bac22fc8bf8,
    0x4002163c1d0ba588, 0x4002932df46a1fe7,
    0x3ff7aa4c2dacdcc1, 0x3fd94ed03c7674be,
    0x3fd48ca43836cdd0, 0x4010569cd8519a50,
    0xc007daea678c94d3, 0xc017e2ec0b579ef3,
    0xbfd53edc8a4f9648, 0xbfb543949c284a34,
    0x4007520f20063036, 0xc00875738e1f4a5c,
    0x3feebcafcfac4c20, 0xc00c1e5827fcfc7f,
    0x40120eb2b60b84a4, 0x3fe80b62efd84862,
    0xbff756a5c9f56719, 0xbff67715be989c9c,
    0x401114e2729f5bcb, 0x4009edc52e62e88c,
    0x400220d1a7597094, 0xc011eab947799dc2,
    0x400f7f6b404d2e08, 0xbff3e3f4b43bc5a0,
    0xc005b1eb592e1166, 0x3fdf4ad0f5b304fc,
    0xbffae439faa4f375, 0xbff77cb39389f18e,
    0x3fc583a312b17098, 0x3ff729fdc6551fa3,
    0xc0048ca6c03d9645, 0xc016d788452946db,
    0xc003802135422f5b, 0xbff1c4414098ebf8,
    0x3fff4c3a7853b902, 0x3feebdd73fa3e81f,
    0xc00173c4d2b78842, 0xbfe436a5ab95ca7b,
    0xc00422748020565c, 0xbffc1838a8e58b3a,
    0x400303af85ac93b0, 0x3ff63e7557c84a27,
    0x400863c522b50148, 0x4006a89753df3572,
    0xc003fbe8eb5bf5f0, 0xbfd1fbd2532e25d4,
    0xc00eb310f6e863eb, 0xc0044f1ba8212c70,
    0x3ff3120df4787b36, 0x3ff3127edd538bc8,
    0x4000a14fe8853fcc, 0xbff3ad1cfeb98c4f,
    0xc00d7e5aa3bedf9d, 0x3fee11a637a7ac04,
    0xc00996b0110dafa0, 0x40018731c34539f0,
    0xbfea8228afc0b5bc, 0xc00187e6a2e8dfaf,
    0x4004ec28b5ee2fc0, 0x3ffd34531b00432a,
    0x3fccb82d0115ac70, 0x3fe9e2758aca3f09,
    0xbffe64d75ed937d6, 0xbffa28642743d319,
    0x3fc762b984bf8012, 0x3fe185f2bf5ce1c2,
    0xc003dc498b4236bc, 0x3fed0f5f6dc2eb91,
    0xbffa86fadf12eae5, 0x401033b0902e2ea5,
    0xc000940b3ce262e7, 0xbfef8e0581a87afc,
    0x3fe6442302706ff2, 0x3fd73bb4b02b2b58,
    0x400536bb4ef8d328, 0xbffd35bf733ee595,
    0xbff0f7442566040a, 0x3fe99dabb46a9f76,
    0xc0020f86fb73ca34, 0x3fe2331dab1ab146,
    0x3fee2fb7884d88c8, 0xbff6c09b6146855f,
    0x3ff245959d6eb99a, 0x4001019598c1528a,
    0xbffb18c878e34ce6, 0xbfd93d3082f97076,
    0xbffc09c8a9509318, 0xbff48980e18786ab,
    0x4004a26ef1ecc99d, 0xbfe6db287c73e4ca,
    0x3ff493be9fae43af, 0x3fe59cdb71a3a39b,
    0x40008c5cb7ee988f, 0x4004215e91b43522,
    0x3fdd2aa433b31102, 0xbfeed3813acdd236,
    0x4010ab0b641a2da9, 0x401082d1d7136abc,
    0xc0079faf6b004892, 0x3ffa91da96c45f1c,
    0xbfd677c74515b300, 0xbff6246c1e19771a,
    0xc002cb094baccc26, 0x3ff6fd4083265498,
    0xc004fb8dff907b06, 0x3fe0436e8ca190a8,
    0x400a3e5e2f08ed10, 0xbffb26a9b1206c94,
    0x400354f90c57b27b, 0xbfe3db3f1b5dd688,
    0xbff9ab71aa7d5225, 0xc0112fd495366a84,
    0xbfff21f27d4286d7, 0xbff0e6b1944b97e2,
    0xbfb30c5ea6ecfa80, 0xbfff0ae7344def08,
    0xc007d39597144be9, 0x40047f8aed5d8d35,
    0x3ff3ce0c8c5603b4, 0xc003824c5a0df242,
    0x3fd432b88e428efe, 0x3fb8cfa376b60700,
    0xbfeaf2e6e18c6466, 0xbff62e4cf62c5e40,
    0x3ff82c5cf1ea2ece, 0xbff7742baf0389a6,
    0xbf970620ebe336c0, 0x3ffccc15a301499f,
    0xbff667c113066c9c, 0xc0052da18cbbc66e,
    0xc01919eab419ae94, 0xc09661fb2a20188e,
    0xbfb7b3da970dd930, 0x40053a28139331ea,
    0xbff82c5c80063059, 0x4010d98778d5a7f4,
    0x4019ba2497b495d5, 0x3fde08d7b8f7c726,
    0x401490ab34dce535, 0x3fcf83a37414f884,
    0xbffb3aead398314c, 0x400d10274783c08d,
    0x3fcf578594d94b4c, 0xbff65e9d3bca9bbc,
    0x3ff8a424cabb2b08, 0xc001474b4a174436,
    0x3fd0116fa94e654c, 0xbfd7e41921cd13ec,
    0x3fb1609cc3621c60, 0xc002ebe086c20e82,
    0xc00d1e70a94247d7, 0xbfe0237564a10bcf,
    0xc00a951e599655a7, 0xbfe5bd69f9af866d,
    0xbfd6275bf0fddeee, 0x3ff30f79fbdcf4c1,
    0xc0105c9e3012824c, 0x3fe1401da0e60660,
    0xc010caa47d741ab4, 0x40156ece9d480f10,
    0x3fe39a7a5e10f233, 0xc00ecaea6c795df2,
    0x40009d6d1e11b09c, 0xbfe34baa62461281,
    0xbfbe48b3a52d5fa8, 0x3fefbba3fd1361c8,
    0xc00859f443c1c59a, 0xbfa9761e152e4120,
    0xbfd81e60032befe2, 0xc006630a4660c58d,
    0xbfe08370d1977846, 0xc003958a28460bb2,
    0xbfd81ad424841da0, 0x3fd488f5d214f0dc,
    0x3fd086d2dacdf680, 0x3ff8bcd59f0e44c2,
    0xbff6024fa203b872, 0xbfeae14d9e4bddd4,
    0xbfedcbb16b5913f5, 0xc010903859f42b2c,
    0xbfccb93a9fe517f6, 0x40047ef3d3b91fff,
    0xc0047e30072bad8b, 0x3fe0df4b86f92ebd,
    0xbfe1e809b11a6d4a, 0xbfcb20c12c6811cc,
    0x3ffb2f929ac4fb04, 0xbff255a7bd6918fa,
    0x4015a77c2f4de325, 0xbff1a480f359c40d,
    0xbfbdc13c66a27fa0, 0xbfe27e9866d049e7,
    0x3fee57bcf42efd6e, 0xbfe35b39c6833db8,
    0xc0058198b429af75, 0x3ff01bc5b5fe135f,
    0xbfb1ad5c032fa698, 0xc01a65bb4bc37df4,
    0x3ffce58e739df186, 0x3ff2db4a74840f6d,
    0x3fdbbaa2be458740, 0x3fb49c3a0a8529a0,
    0xbff8be7a0fb0669a, 0x401a33cbb284aa52,
    0x3ff9377be59688c6, 0xc0034eabd15c7517,
    0xc00542a0d64b4782, 0x3ffceab106dc55eb,
    0xbfe82379553e5a0a, 0x3feb1532cee7a29d,
    0x400cd9cf4a1af2ad, 0x3fffd43aede8f65a,
    0xbfe597d376ab2876, 0x3fc7c6b87f4ae758,
    0xc002dea269d9546c, 0xbfe9f329105eaece,
    0xc0064e0a31e58abe, 0x401139baecb97608,
    0x3fe464b0b4abf03f, 0x3ff52afafe8a3015,
    0xbfdaf48f04f9b0f0, 0x400087d2a23ec691,
    0xc0117dfb68c7ad5c, 0xbff40b0c968a12bf,
    0x3fe6ff0618bd5b40, 0x3fdb886301e9c6b8,
    0xbfce803889e6bd80, 0x400023e4a5a68245,
    0xbfe202b31792c968, 0xc015c45a1234bfca,
    0xbff7917477aa6421, 0xbfde8864be906086,
    0xbff0860213141d40, 0x40033ab3f37f2692,
    0xbff1dec04d653a33, 0x3ff4fa7e0464d7f9,
    0x3fffdb802a878e78, 0xbfe47e9f456718c6,
    0xbfd28bad68b3eb2c, 0xc00169b18a5f1f6c,
    0xc0064c20b4eb2917, 0x3ff310a69a4b9922,
    0xc00eacca18b1f93e, 0xc01cb3f76653546e,
    0x400ad23d0da8e9a2, 0xbfd2c0f24de2998d,
    0x3ff89ffa4c606de5, 0xc013d16b6713d48c,
    0xbfd939c35ece0f02, 0xbfd009e6eae38a90,
    0x3ffb78fd4fd05d1f, 0x3ff9a5b1fcb87afa,
    0xc00676d9d4808bb2, 0x3fd429bf434c12d8,
    0xc003c19b256268ed, 0xc002a68d84faa5ec,
    0xbff2e17d051a1f61, 0xbffe62cb769316b6,
    0x400b851b8e03a9a8, 0xbfc346f5e7517b98,
    0xbfb497e5d56a4c00, 0xbffab09d92be774a,
    0xbfa072afc3310780, 0xbfe82091616dac54,
    0xbff7808e0b27128e, 0xbff74924e2850aaa,
    0xbfab0ad357fe2a70, 0x401109b336d3cea9,
    0xc00102fbb3dc7ef0, 0xbff956897c2eb7dc,
    0xc0055a966aa89952, 0xc00c6ee47ac4be18,
    0x4002d3fb410b5312, 0xbff38d250906350c,
    0x3ff7b7f05fbe55fb, 0xbff196c9c60c0ac2,
    0x3ff0db4947efb29d, 0xbfe6761cd52536a7,
    0xbfd77e5414c6eca8, 0x40026f31f0e6b73a,
    0x400d2409afeee854, 0xc00a1fd2d4f45082,
    0xc005d134fd85d4d1, 0x3fe262c11105bd18,
    0xc005d93b595e0024, 0xc0011236c61cb786,
    0x400e0f87663b7e21, 0x4008cf46d487bbf0,
    0xc00c4dde13192e21, 0x3ff6767b9af4792c,
    0x40034659308c3b38, 0x3ffd1ec3d07f32e7,
    0xc002cc41cfd288f9, 0x3ffdedc47c776012,
    0xbff5120b37719834, 0x40016d7966af0ae1,
    0x3ffda61c26da16e4, 0xbff7a186901cfdc0,
    0x40139d9db6fdac2c, 0x3fbb8b29700adfe0,
    0xc00e44a8d51efb3e, 0xc0055ea42df96198,
    0xbff827c2531ad155, 0x3ff4a78f0ac8e48e,
    0x3ff4b9f2b0dd8a65, 0x4007054b9bda16ac,
    0x3fc3b04ab3783508, 0xbff52a7f41e5f02f,
    0x3ff1c6a5aa96a4fd, 0x3fe973270d2e9c3a,
    0x3fd0fd182bee47ed, 0x3fe3e5cdb5045f32,
    0xc00862979db84e4a, 0x3f98bf393e98c200,
    0x3ff8c2de9ee370b9, 0x3ff8271673eb44c2,
    0x4004c839c9b59ca0, 0x3fe2677715c07446,
    0x401049facb9376fd, 0x400472696ef65a7f,
    0x40051058768fe01e, 0xbfa0949a665c5160,
    0x3fecd42f7d72d704, 0x3fff1d50657b3db0,
    0xbff5931979854942, 0xbff82d32c1d9a8ce,
    0xbff762ca65a370c3, 0xc009906b61aa3420,
    0x3fcd5520740794dc, 0xc000c722821ff2f7,
    0x4001cd157737471a, 0xc00349a9a4593260,
    0x3ff6035956b1047a, 0x401c0feaf4116c78,
    0x3fcb0a024d0070a8, 0xc01119e8fbdb51b0,
    0xbfe7a0de9a1d8da3, 0x40081cfaa76d42b2,
    0x3fd62873dcf92058, 0xbfd4d6be6cd91b74,
    0x3fb1de3a0ec7c590, 0xc0019a58e285c3c8,
    0x3fe442a63321706e, 0x3ff1b1cd8eebe63a,
    0x400ae2e006e0ed53, 0xbfd4db7bcf74da48,
    0xbfe5e3c216dd74be, 0x3ffe33ab06c3ff02,
    0xbfeb159791d5b967, 0xbfe2e2ccbf12aa75,
    0x4000ec7d34d33ed2, 0x40008b0945c1b947,
    0x400203e9b78bc467, 0xbffcb56fe3a2c08c,
    0x3ffdae5f809541e2, 0xc00a2c80a270b938,
    0x3ffbc302f40718df, 0x3fcbc7fda98b0570,
    0xc0026dc4175ecb25, 0xbfc38aa9b087578c,
    0xbfe2506c6dd1c8ea, 0x3fe8e6ff003d8427,
    0x3fde3e87aff26c4e, 0x3ff89399cd17614b,
    0x3ff23ab1716c00de, 0x3ff796e7c92ca78e,
    0x3ffba046dbbd5e02, 0x3fdded7512b574a2,
    0xbff67ead6423be1c, 0x3fd6426624816890,
    0x400629f709693a12, 0xbff090966fd5eb91,
    0x400c2c8debe3e848, 0xbff20bce91e84d6c,
    0x3fe0dd613923414f, 0xbfd0084eccf2f88c,
    0x3fc35f6f869d79b0, 0x40085187d1c455d4,
    0x40136b17faa6bdea, 0xc0021c5152c0e684,
    0xc003983c809fc8de, 0x3ff044974ab72da3,
    0x4001d122743f6690, 0x3fe9fa395c0309a8,
    0x3ff6492eb5306836, 0xbfc8c5faa8a85a48,
    0x4011d0d17a60d1dc, 0x400733af9e920521,
    0x3ff3f775b6c55b84, 0xc00ba640aaa54f76,
    0xc004b30aa456d6a8, 0x4008ddbaf7325f48,
    0x3fcf4c74fd86f272, 0xbfb9f960496e2920,
    0x4000fd6b353199b4, 0xbfb175557d5b6b48,
    0x3ff425f7229d2291, 0x3fde659463802f58,
    0x4009aa5763466636, 0x3fefd99bc70170e7,
    0xbffc9c37b5485f00, 0xc005a107949e13ea,
    0x3fe3df4066f7a180, 0x3ff999e51e2ad412,
    0xc001b4e31d0d7bf3, 0xbfe2b19db127bf1e,
    0x3fe8a124903b90e2, 0x401106fef3776c67,
    0xbfe57a034c9a89a9, 0x3fe01f7b8461713d,
    0xbff06780104a54eb, 0x4007d167b60dfc48,
    0xc000003e90a48554, 0xbfe8064042af8670,
    0x3fc851e4c324b8e2, 0x40082894841b6891,
    0xc00b558d43462d83, 0xc0100665b20ccba2,
    0xc012078810f0c20c, 0xbfee77a1aae63f6c,
    0x4001ec4959cdaca9, 0xbff734c14c07d420,
    0x3fe05cd9a6bfa968, 0xbfefeb8270cf5a4a,
    0xbff163a6d9840083, 0x400167cd34058338,
    0x3ff222c585d0ff11, 0xbffc4c7f0aba4031,
    0x4006816af5793e83, 0x3ff12b11af621060,
    0x3fe8ed0d2b332722, 0x400d9c8ea07c709b,
    0xbfa2ef928de43010, 0xc00ac12608231380,
    0x3ffc090fdc2af9b4, 0x3ff7880703df86c3,
    0xbfe01defba4f7336, 0x3ff05d3026f424f5,
    0x40048649fbc7384a, 0xbff1674f4f1b3776,
    0xbffd29d1934c2836, 0x3ffb7bca61b26e47,
    0x3fceb132bd9a0188, 0xbfe494ac7c1faae2,
    0xc001ff86435e32dc, 0xbff38c9c835dbbdf,
    0x400e5333e19b73da, 0xc00028a91e073dc7,
    0xbff61eb000207da4, 0xbffd88c416ca5c8a,
    0x3fcd53bb45796168, 0xbff819a53b18f41a,
    0xbff8f3d896b202fc, 0xc00bd4dbeb24ae0f,
    0xbfdd2a8d07cc9290, 0x3ff31bd663bc4024,
    0x3ff2a6d52e5de21e, 0xbfc17c50d593a18c,
    0x3ff8e1082bd4eec8, 0x4007488e336b376f,
    0x3ff2e7edd59c407a, 0xbffff0db58eed508,
    0xc0106fd42fcc827a, 0xc0024e5b577d7cdd,
    0xc0035ced523a36fe, 0xbff2ab07901370d6,
    0x400389d1a6c0c9e6, 0x4004997ef046dc1c,
    0xbff06baea649da22, 0x3fe9ac27ae194326,
    0xbfe12943e71dca52, 0x400be39f077b3b3b,
    0xc003b0c63797eaf2, 0x3fe66d85213eea14,
    0x3ffb6b4b7b5f8662, 0xbfb5f6a357fe1d78,
    0xbfc3528018a72a58, 0xbff116e601cdd05e,
    0x3fe00521c881c440, 0xbfe3408dd4af7752,
    0xbfc6b4fc8ed199a4, 0x400032ec4d0679bd,
    0xbfc1786e3ff7200a, 0xc0129b88afd4dc34,
    0x400cae825b38cbd0, 0x40008ef9166f3be4,
    0xbfec2978ded053ff, 0x3ff5f6f82863f7a4,
    0x3fe05cc6f460117d, 0x3fb51f3bd06515b0,
    0xc0046e868990efe8, 0xbfdceb333ea1d29a,
    0xc0076cf12f1e68cb, 0xbfe2c34b8519a210,
    0xbffcb50e7e8f8c01, 0x3fcbf5fdc706c1a0,
    0x3fc45f2d18114ef0, 0x3fe8c8ad1ce0dc37,
    0x40006ef39be31b14, 0xbffad51c51265122,
    0x3fe71c7cc31b5885, 0xc0001905ddc14447,
    0xbffe5052573daea0, 0xc013f2c60f844754,
    0xbff81e47c076c8bb, 0x3ff2dcd7287dbf8e,
    0xc000956b26554096, 0xc00c71ee9672f8ed,
    0xbfd7908c5103e1c8, 0xbfc051f050628294,
    0xbff53daad39f0dce, 0xbfd5fd87d687d648,
    0x40029ede5f9fd71e, 0x3ffcb6dcd43567dd,
    0xc00c6d86e8e5476c, 0xbfe2ae3b5497778a,
    0xc0037db65d1feb7c, 0x40120fd8f227d99e,
    0xbffb16f24d5ab8b9, 0xbff7bcecb604aa06,
    0x3fdd769535bf5270, 0x4008141fd25555f4,
    0xbff1cf54a8a31038, 0xc0065e2df08a33e5,
    0x3fc21fd71e749f10, 0x3fe20d97e26ad5b6,
    0x40017d95204005b0, 0x3ff8798283ba3f70,
    0x3ff0dc4b3cf58776, 0xc00332abb5bbc0aa,
    0x4003a31242f72006, 0x3ffb65460cbe793a,
    0xbfe11a7148d8ed37, 0xbfe8daf1fab7f8de,
    0x3f91521dbd2c6a40, 0xbfedfba0fb51697e,
    0x40066ca5b97487b7, 0x40105a66d48c151b,
    0xc0003ba4ce933589, 0x40039a33e71ec4f2,
    0xc004c800baf37c3e, 0x3ff77d7601b82ede,
    0xbffa47eb41c1c664, 0xbfe96db2f0015bdd,
    0x4003b9fd6a831b2a, 0xbfe9b9e806dc857d,
    0x3fe02ff77a630db8, 0x400d2631dd40867c,
    0x3ffde0f3ee34fb70, 0x4011cfa450b31af0,
    0x3ff2ed1bd97005b4, 0xbfc435bb40752508,
    0x4014cdb110b0dc35, 0x3ff8ef22a3a604c4,
    0x40109c8d4501d043, 0x3fed1440b654189b,
    0x3fe809741b37e5a5, 0x4007c08e045732e8,
    0x3ff02f97b6472ab6, 0xc0010c45b112b6ca,
    0xbff58d5410203b48, 0x3ff50bc6c1fd426d,
    0x3ff28c9da84b3e75, 0xbfbff74feff8df00,
    0xc0093f4f00954098, 0xbff2a8e3ac86138e,
    0xbfe4573739f50802, 0xbfd770a40baff4e0,
    0x4011bb00c5a3ada3, 0x40041812136f5028,
    0x3ff5dd7f32b22c7c, 0x40009122b503cc47,
    0xbfea6c30a16fc568, 0x40079d4ea2291696,
    0xbfdd675b9b4bce4c, 0x3ffbe6ea427847f6,
    0x400ec1f1c1199dd6, 0x40155561010f0c6a,
    0x3ff05d8dbb4ca41e, 0x3fe2cae7208d5598,
    0xbff3ca4f18a87adc, 0xc009a5ef746e1610,
    0xc0084f3ee0b09ad4, 0xbffa53a954885afc,
    0xbfc64f7ba9d2d303, 0x3fe263f3a80ce87c,
    0xbff3ba65e84dd374, 0xc0056cef34109cd1,
    0xbff160930206399b, 0xbfcb0ceb39ab1eda,
    0xbfddc43fdb8a4bdb, 0xbfd9ba0a92def8d0,
    0x400f61357aab6e2d, 0xbffd148b8eda28ba,
    0xbfc13eae5158c790, 0x3fe73e3d4bc70c58,
    0x400a32bc1ce65e66, 0xc003cfdc88da7664,
    0xc008326b24711172, 0x3fddfd993e435c92,
    0xc00c7df25a3453b9, 0xc00093caade9c8fe,
    0x3fff859d62fce350, 0x40066969b7da1587,
    0x3fe2b0c65c819280, 0xbff96a72ace9ce30,
    0xbfd347d339ed92a6, 0xbff922a69b2da5a2,
    0x3ffe109bcc31c4ec, 0xc00318d488321273,
    0xc00864c1ca7c0d04, 0x3fe80d8a4ef7a6cb,
    0x3fc381de83efdf50, 0x3ff9ca8c2cc87338,
    0xbffd5f1aeaf83ffa, 0x3fed787a36c22e0a,
    0x3fba769aaddba3c0, 0xc00640592ad70d9c,
    0x3ffa2fa886423bb1, 0x3fea033888bd49c4,
    0x3febf3d60da11848, 0xbffa8c6e4fbeb1f4,
    0xbff15597b19d6561, 0x3ffb59361b101580,
    0x3ff9d2ef0108cdf4, 0xbfefcdc6924b8693,
    0xc00df08213f46557, 0x400253c2c748910d,
    0xc004f1aed3f8d04d, 0xc00d6909843837e0,
    0x3fe70957ab445cac, 0x3ff7302fc5847573,
    0x3ffbfa64cb76f90c, 0xbffd341fe862cde2,
    0x3ff8510f99466a51, 0xbff46b93b07783a2,
    0xc00050b31d10b3c2, 0xbff094cf003a1e1c,
    0x3fe1e172206b4660, 0x3ffd5228508a7106,
    0x40067cf1f1e32898, 0xbff20c2db7bbe9e0,
    0x3ff01c88ecbd92da, 0x3fe9986c033d0dc4,
    0x3ffd76e646b8e904, 0xbff26442755f3c7c,
    0xbff90d31621d4c97, 0xbfcd6325f712096c,
    0x3ffcc13efad69d68, 0x40126b4dfcc95c80,
    0x3ff61edb216983be, 0xbffc94300fb5ff1f,
    0xbffc518ffd956f45, 0xbfba8028bd407b24,
    0xc00bbcbd522e42d6, 0xbff1d91e6a45c0d0,
    0xbfe7366d31ad748d, 0xc009b0e83e882952,
    0xbfc3c40e42631390, 0xbff56923c41ba453,
    0x3fe012d2820b8d7e, 0x400c377b28141f3a,
    0x3fe6886f97866905, 0x3ff6ff944aecb9a0,
    0xbff6d1439c00d69e, 0xc000d573ff2986f4,
    0xbfe7fdca9b1d9227, 0xbff5d2374825b8ad,
    0xc004749e8f26675e, 0x3ffd040addb814c6,
    0xbfce533db6e46d78, 0x4008cc2fea798124,
    0x3fe5e11177a950de, 0x3fc43888d3c420fc,
    0x3fad890381f01d50, 0x3fe6483f245625dd,
    0x4002df53bbb167ab, 0x4010183d06f53280,
    0x3ff292ff1f4dc5b7, 0xc011af89e04072dd,
    0xbfe7777a04fce1cc, 0xbfef374ffa4e8180,
    0x3fe8408b5a20584c, 0xbfe544f6da169f20,
    0xbff7cbacc1a5f20d, 0xc0081cabd3e3a8ab,
    0xc00e401ba4b22f8e, 0x400393ca4841a415,
    0xbfe68eb361a0e1d2, 0xbfe2e9fdcb21eec4,
    0x4005aa2315311536, 0x3ff6091dbfaecae8,
    0x3fe5a298cbf9b09d, 0xc001771f570cec2f,
    0x3fe40ad11f8987fb, 0xbfd725a6f2f83c5c,
    0x400109590d366827, 0xc004e234cfeaa7b4,
    0x400624c4127e2c70, 0x3ff92c38cfd7e38b,
    0xc0096a4296ba3efa, 0x400f4fb316eea17d,
    0xbfa20a0540ff88b0, 0xc01071e0185378b6,
    0x3f90cc503bb7f7c0, 0x4005150f03aeab33,
    0x400aa0ad5b455b44, 0x40044f60d8c17254,
    0x40163a04f3fb7a15, 0x3ff279154929601a,
    0x4002eabd95a409ae, 0xc00b1a9a8acc9e50,
    0x400e444d02873ee5, 0x4004ef3fa8a9520e,
    0x3ff04c2f65466c5b, 0x3fb8468af544bc50,
    0xbfe29371d796c474, 0x3f982f1ee104d960,
    0xbff201568eef3b9a, 0x40059234d4568b2d,
    0xc00d1362d2836bcf, 0x3fedb77b61665264,
    0xbfa7357c61f0cc58, 0x3ffe8d08364f5a51,
    0x3ffa8cb61d105a7b, 0x3fc5ef1fa6617eb0,
    0xc0105d12c3834b7e, 0x3fbb9bfa747a0504,
    0xc014717763d3c931, 0x4001766a354d2524,
    0xbffc5e2b8146d2b4, 0xc01c3c94174b66b0,
    0xbffd0155e4e75781, 0xbfc25a63a9473fd0,
    0x40029acc4c9d14ac, 0x400473467551505d,
    0x4007622d4f90b93e, 0x3fef70344e3983a6,
    0xc00d374867a2a70e, 0xbff6985312de3a10,
    0x40056962d8b8d2e6, 0x3fe9266e16361337,
    0x3ff8c05964f04684, 0xbfcc3f2b4f61df1d,
    0xbffd75232d2965e1, 0x3fb5c1f68e182b18,
    0x40015a576d398ced, 0x3fd8ce21554ca7a0,
    0xbfe5a85f22b06424, 0xbfe3b72376efd6e1,
    0x40134180144d6c02, 0xc007ff42182d8a8a,
    0xbfbcd33903d5d85b, 0x3ff1c1c61d5254f2,
    0xbffe6dec3ff8f5ac, 0xbff5af7bc1021b37,
    0x4003a34f767816ef, 0xc006fbc531abc87e,
    0x3ff148cd39dbf03b, 0x40028360973ff25d,
    0x40045548cf3600a4, 0xbfc2fef7cae26788,
    0x3feefa591696c6f8, 0x3ffaf9d395094399,
    0x3fdff40c6e57e3a0, 0xc008ed42d152939c,
    0x3ff34a3a4d66292e, 0xbff4c2c2e3c3cf30,
    0x400475d3afc551f8, 0x400f7262c3296a0c,
    0xbfcd1b4e0f6e3618, 0x3ff52d506ce4eb33,
    0xbfe3df3f13b486bd, 0xbfee92f398e2d38b,
    0x3fefba223b6f5d29, 0x3fccc4afcce18186,
    0x3ffe0d3fb49f4f60, 0xbffa0a62d546d3a1,
    0xc00186ddabe9b36b, 0x400071aea6cda1b6,
    0xc00fb9159a2caf88, 0x401348211fe19ac7,
    0x3fe9e8a5b422d833, 0xbff366a1693577e5,
    0x3ff01cc9b3dc8d55, 0xbff88b2dd040f8d5,
    0x40004b98bd1ffa50, 0xc005cd6cde41b18c,
    0xc01507cc8527f928, 0x3ff33df3075d90b2,
    0xc0075d86ecbb6245, 0xbfe91ded5b1280c2,
    0xc006ee390b59d526, 0xbfa5c6d766d6e300,
    0x3fd885629256e440, 0xc010a5900cd45cce,
    0xbfe4d3fdfeba4d60, 0xbffb028eecee4771,
    0x4012225a6c04b88b, 0x3fc7998c227b265c,
    0xbfeaf8ece18e578a, 0xc00e0266aa03126e,
    0x3fdd95dd87de8efc, 0x3fe9aa7abdc85a96,
    0x3fe4723bafd0e942, 0x4008614bbe86a144,
    0xbff0b4b8a8421539, 0xbfdab82072934e50,
    0x3fd4032447ba21f4, 0x3ffba0ac4342a829,
    0xc000649b847b9dc6, 0x400aa10fd73fe227,
    0x3fe8f382020f5500, 0x3ffd525e02170529,
    0xbfca792efd966500, 0xbffdf35607f24dcc,
    0xbff9f1415f8ad3e6, 0xbfefb751292e98c0,
    0xbffb24ff332c2684, 0xc00ea66ab74581bb,
    0x3fd987f39a043990, 0x40065c43d0387570,
    0x3ff4fc644c2a96e3, 0x400a4bac0fdc4eff,
    0x3fffef98d342031b, 0x3fe3b21c72fb0f08,
    0xc007e37d9ea66601, 0x3ffd11aef9d2d184,
    0x3fe5f9f672c180d4, 0x40112178eab97f92,
    0xbfd44857435ab520, 0xbff7bd866c04ea8e,
    0x4001e31cab7299c7, 0xc014b361f0c44047,
    0xbff7a4db0540d58a, 0xbff769252e32d99c,
    0x400bf23939069f0d, 0x400f7290b638813c,
    0xbfe845857ddb72b9, 0x3fdd1e06230056ac,
    0x400203e989388e92, 0xc00b6a3b30e9fc2c,
    0xbfef656341f8205e, 0xc0015052ab685919,
    0x3f72600241071a00, 0x3fd27d97f9470ec0,
    0xbfe2ba91d19aae8a, 0x3ff99120b5c628a7,
    0x3fe43ad4f5e80810, 0xbffc6be1c57bb04a,
    0xbff85561f61447ee, 0x3ff36de1970d55d4,
    0x3fae209a319d1440, 0xbffa40862eeb06f9,
    0xc007877b9aaf9a34, 0xc0091deeeebaa83e,
    0xc0023d28f777d93f, 0x400aa7e206b9ee04,
    0x3ff2f745002df0ce, 0x40073d67565ed2b4,
    0x3fd7e2957ddda67c, 0xbfea027152e61c03,
    0xc00b8e96d5357cce, 0xbfc067e4555b746a,
    0xbfd8f1b4368093c8, 0xc0088d3b2d803f7a,
    0x4017675df9a0c918, 0x3ff2c72bb04f9203,
    0xc003be764c9fe73d, 0x3ff355cbbdd38497,
    0x400e1a0a4d7b8c0f, 0xbfff8fbe52a68ec8,
    0xbfe20030908b1592, 0x4007b67e4b0a093e,
    0x4008f0605bd46a6e, 0x3ff81dcc0a1e185c,
    0x3ffaf33f5024e0b8, 0x4007e314ea682b5c,
    0x401e3ca8f6833bdc, 0xc00b181e84f56727,
    0xbfccd416f179bfe0, 0xbff4500d27997241,
    0x3fdf9b806ed4cff8, 0xbffa528c85a9e216,
    0x3fea1b3d0f8acaae, 0x3ffe2baaa302496b,
    0xbff9793762c3d809, 0xc000f8c34878b95f,
    0x400848886e7b4af5, 0xbfd7b26180a2047c,
    0x3ff96a608ea89e86, 0x40026069677219d6,
    0xbfff6014e97859aa, 0x3fd16f0ad26ee1c4,
    0xbfe22aa307bd6eb8, 0xbff77ae080deb970,
    0xbff012098ce4ae94, 0xbfd054bbdfbe1c45,
    0x3fff449775e01654, 0x3ffa23d808125126,
    0x3ff957a085989495, 0x3ff2316d54a67084,
    0x3ff0978a15016d34, 0xc01267d7100c3d7c,
    0x3fb96df32a2417c8, 0x3ff97f6cfb435fb6,
    0x3ff7afd4ef8666e4, 0xbffd83b170e44bfd,
    0xc005892039e6fe8e, 0x4001a4a5eca54057,
    0x3fee1e4e5d9a06bc, 0x3fbb3f938a5ad110,
    0x4005da0fbb8d7228, 0x3ff700afe20c3fb6,
    0x40127b81fbe6fe79, 0x40001913b8f9fc83,
    0x3fd73ad2c860dfb0, 0x401284ff7e3545ef,
    0xbff576e892ce72b8, 0x3fc666811fe158a8,
    0xbfba13649181cec8, 0x3fe7407f7f5c832e,
    0x4011dbd8953a6654, 0xbff7e21f825683ad,
    0xbff1ef3328b94bb0, 0x3fdfee3862f912dd,
    0x40026a6f1058a503, 0xbfed91511e9d8af0,
    0xbffc153f0c30420e, 0xc00154b8db8a376f,
    0x4002e1d6c12f2c2f, 0xbfdc5c8b54c79728,
    0xbff1787a84478a28, 0xbfc4191ba49b2ab0,
    0xc007691c05f6465a, 0xbfcb455ff9323508,
    0x3fff6b68072ae8a9, 0x3ff285feb8c8a301,
    0xbfd77a40cf9bb578, 0xbfefcd8d9854e387,
    0x4000385b85b2e59e, 0x4007f6b672210bae,
    0xc002fbdc4a14be42, 0xbff678a2b772f12c,
    0xbff9e392cb6b4cfe, 0xbfe4b61716fb2fe8,
    0x4000cb592c6f6d2e, 0xbff5632432d20f6d,
    0x3fe3866075e2e2a0, 0xc006e194af86213f,
    0xc00afe4f830e1baa, 0xc007dc3368ba0fee,
    0xc010091ef26fa9b8, 0x400b614c6d1a7ebe,
    0xc000433ca4f8e3c4, 0x400d6a12e25c8fe1,
    0xbfe00678260aff84, 0x3fe62648ae3342b8,
    0x3fe5b88837f48936, 0xbff564457664fd12,
    0xbfd755fca92b911c, 0xbff7b860fd1b5576,
    0x3fff8e08f67f4022, 0x3fff181b0cafc88d,
    0xbfdd3d9367e105f4, 0x3ff35ff88f7e22da,
    0x3fff8579262002fa, 0x400b6bf6694075d9,
    0x400abc8c85789f45, 0xbff7d1f88d357478,
    0xc0114be3a6f53768, 0xbfed442305bd6ea8,
    0xbffba5c9159125c7, 0xc018c6c860b7d07a,
    0x400afda24dcfc7aa, 0xbfd68fc2ff4c9b50,
    0x40118102d4e86ef0, 0x400821a4cfac849a,
    0x3fa1941e074a9780, 0x400014cea4c92500,
    0x3ff69074b5c71c45, 0x4005fc29286e6cb6,
    0x3f8554bf50346000, 0xbfe28bc163123f33,
    0x4005f4d5f76a6d88, 0xbfe5ee0487aa437c,
    0xbfe29577e21bcd86, 0x3fd6a6ad64d47238,
    0xc007cc95eb28333c, 0xbfee3572096e6d78,
    0x3febf7da7a995a70, 0xbff7f30ebcbb7340,
    0x400fac93f627f3b3, 0xbfd997c2570d0604,
    0xc001d7650b986c7d, 0x3fe2ff8957cc3d0c,
    0x3ffcc1a63da7457e, 0xbfe439408273b6c7,
    0x3fdd560ddf5e6b90, 0xbfe8e0f9192be27e,
    0xbfe98c93b4319db8, 0xbff16afbe3f66052,
    0xbfea9acbeb60289c, 0xc0123b65225cea34,
    0x4002b351e995ac90, 0x400037b86763f615,
    0xbff260b8b40f526c, 0xbfe92c906731542c,
    0x3feebbf1eee59761, 0xc00075fb7ff1a7b8,
    0xbfc685f05a3b5b5c, 0xbfe82396674ce06c,
    0xc00b602e8f867184, 0x3ffa35ee78b63c48,
    0x3fd04223fcff6756, 0x400e0522a6bed3ea,
    0x400fc20b81dd46fe, 0x3fe2cd3e059b8248,
    0x3febaaa9b821b426, 0xc007f4fa0da3325b,
    0xbffb0eff52923a41, 0xc00a9e0f1f9fae31,
    0xc0012f9896f5c227, 0x3ff5ed5abf2bab76,
    0xc00d05f1b6e8ecb0, 0xc001baa770d64ea1,
    0x400df043fb2de9b2, 0x3fd8427bc4eb3de0,
    0xbfdcc093ff6ecfd8, 0xbfeed321f2a656ac,
    0x4016c6e31c5fec48, 0xbfe88a3bddce98a9,
    0xbff4fdd66d2c0067, 0xbfe1b1ac3c32ab58,
    0x3fcd020868d316e8, 0xbff6c4f3ff2af40f,
    0xc007a33126222c56, 0xbfe1b66d01165696,
    0x400d3b1775a8060e, 0xbff7cc2709ec3ad0,
    0xc00cef0ac7e5ab36, 0xc0011b53baaa2e59,
    0xc00ed0221ef5bc2a, 0x3fc835e650e06698,
    0xc0052da62290baae, 0x3ff94b4864dac0d0,
    0x3ffefab2dd9b9a7e, 0xbff0dee7227b6169,
    0xbff502f4a4efe1d1, 0xc002080d33c1c92a,
    0x3ff92e3d478845a7, 0x3f76087e998f4580,
    0xbfbae1e9d6dd9cb8, 0xc002c476bdaf87e4,
    0xbfeac539f8c4a2a6, 0xc0030992fe9f0a07,
    0x3ffc218a0cf98eaa, 0xc0096faacb761bf4,
    0x3fe6faca6b7c9d6a, 0x3ffad3c12dae3d18,
    0x4001c4bf2265defd, 0x401b1cb919f4341e,
    0x3ffaa3148a688060, 0x40005d048d30cdf1,
    0x3fdac2a1ccad6634, 0xbfe2876ce8c439c8,
    0xbfffdee37812df64, 0xbfffaf2431558a08,
    0x3feec4be66c894a4, 0xbfe02ad28fb5702a,
    0x3ff4f593a5c69248, 0xbff5771731d2aca7,
    0x3fd531fd7503ca70, 0x4002d36335166f6a,
    0xbfe9221701ab4814, 0xbff338a01938ab97,
    0xbfeef934507cbcad, 0x4014fe64d2b9c231,
    0xbfddb5b2277d67e0, 0x3fcfc9349ec82bd0,
    0x3ff5bc34515f181e, 0x3faba1fcb31934c0,
    0x3fd9735153bd0b84, 0x3fff416ef60fe20d,
    0xbffdd359f2acc9b0, 0x3fe95f917d33204e,
    0xbfdff51db7db9a70, 0x4004fbd8c0d39eae,
    0x3fe57433002dc2d0, 0x3fd83f37b9062b64,
    0x3ff5092fb1d9a589, 0xc004bfe652895938,
    0x3ffc4039c1a55309, 0xbff1940f36cfac94,
    0xbff14fe638890f40, 0xbffa7d8e69f6c392,
    0x3ff2c18c9da33b53, 0x3fc2f315925d341c,
    0xbffb28ce6a2e2384, 0x3ffed6ba01d0adc1,
    0xc007cc24b74ec56c, 0xc00576a9c8bb3b0f,
    0x4003d9c263e772bf, 0x4011afd26ae7762a,
    0xc0020b2539d008b6, 0x40068180538fdf24,
    0x3fec5a8099931478, 0xc011289cc564b5a0,
    0xbffbf22cf5843da6, 0xbff3398156b81cb2,
    0x3f788c4afe620800, 0xc000e42ad114c5ec,
    0x3ffd40a3f6cc2b5a, 0x3ff58e64e4c05dda,
    0x3fe78835eb9327c0, 0x400f802a53f15892,
    0xbffdc991022e3948, 0x4004724e2ccb40aa,
    0x401f13e197e2e0d5, 0x3fd365633749458c,
    0x3ff079502cf0b23f, 0x3fd948f29d525158,
    0xc00e182ecf6da4fc, 0xbffe83233bc2308a,
    0x400998092d69deaf, 0x3ffe46f3d1c8cd51,
    0x3fb7cd577c479040, 0x3ff2fee42b9c8776,
    0x3ff10a337b538f0f, 0x3ffa6ebeffc33a9b,
    0x3fe6ad47c3666e2c, 0xbfe297c3b25f886a,
    0x3fe6fddc420371b2, 0x3ffd6a37e5a6e704,
    0x3fe749474078d256, 0x3ffd25a3d2abe212,
    0xc006677d6b8a1942, 0xc007af660e661a43,
    0xbfde8cd71cbd7428, 0xc00e27badae73364,
    0xbfff4c294962ae7a, 0x4010b2013f690458,
    0xc0005045bdc376f6, 0xc0060eeb8cd51b15,
    0xc007fc0584c27049, 0x3fea8bf163fe9d7c,
    0x3fc28b6132a37f58, 0xbfe38f1f6c6382ce,
    0xc0055380a7bb29bb, 0xbff1095f301fda80,
    0xc0020c3a4285d6d9, 0xbfec5129c0f4b7d0,
    0xbffdb556521540bb, 0xc00e20fa73639cdf,
    0xc00dd50bc095a99e, 0x40057d6c5c840680,
    0xbfdb27f342ec0f4a, 0x3fb02f584ee85350,
    0xbff28f292e53cb06, 0x3fded120e237a026,
    0x3feb28894331876c, 0x3fd25b1a02157676,
    0x3fe743bcb12ef634, 0xbfe8233e46392f34,
    0xc006e0b578144686, 0xbff428ad07eb0309,
    0x3ff8b54a56794ce9, 0x400ac7348503ba42,
    0xbffefb57395bf7ee, 0xc005d444f3c240f0,
    0xbfe934ab14b1e1c2, 0xc0073b0171ab9a20,
    0x3fd363bc53c54b6c, 0xc0020a46ac47b25a,
    0xbffa9526347d5b98, 0xbfdfb3c48d72e73e,
    0x400a374261311ea6, 0xbfc0148d33ce9528,
    0x3fbf89023ec82c20, 0x4006cb2cc55b1e78,
    0x3ff61abc649b9fdf, 0x4000a945aad05356,
    0x4004346c7fbf8908, 0xc004d51e5ba0dbf5,
    0x3fe03eba079744fe, 0x3fdbfa3018e493b2,
    0xbfef09bff6da8ee6, 0xc00b34bc476abc8e,
    0x40007077730fa08b, 0xc000841bc7af8e69,
    0x3ff3bc0f983a0056, 0x4001dde601101813,
    0xc01403cbfcfb2112, 0x3ff03dde57d5d7e4,
    0x401281c37ee62718, 0xbff086c8248fc9c3,
    0xbfca7f7ef96fdb00, 0xbfe3a458257f73f7,
    0x4003a867bc3fbc59, 0xc0022a5f20875c28,
    0x3ff0732be35733ae, 0x3ff91ff2e9f8116c,
    0x401039dde8ebec28, 0x401be4168ff0c23f,
    0x3fcb47a1d642c218, 0x3fdd10ccb5df31fc,
    0xc000260679c878be, 0x3fffce7b6afcf99e,
    0x401324bdefb9fa6b, 0xc004bd7f74203d13,
    0xc0078fc291c8b2c3, 0xc007741db040dbaa,
    0xbfe99de69c170514, 0xbff3e65b519eee18,
    0x3ff370e5f5e98528, 0xbfc07e6f3910c4c0,
    0xc010c6e1259834d2, 0x3fcb534e0a530b80,
    0x4001d9f00aad31a5, 0xc00859235ecb9f58,
    0x40085d60c34e93b4, 0x3fbd9c16172d9620,
    0x4010f4785d04db50, 0x3fa0985dd8299d60,
    0x3f936bc91f4bfe20, 0xbfe304206cef3257,
    0x3fe22771e304cc3c, 0xc00e9afbaa037904,
    0xc00df53d237ee114, 0xbff51b0f9e0dfcba,
    0xc00ee785b67c8b95, 0x40193835ec5c2b61,
    0x3fdf62e5779b1c30, 0x3fc8679d6043e590,
    0xbfcba3d5986a6e18, 0xbff2232a4e839dbb,
    0xc00459d3e4bfe4ce, 0xbfbc83ffa0664870,
    0xc005ee489fea39c0, 0xbfc9574515fa2300,
    0xc00cb03d8b812375, 0x3ffaf22ef5381848,
    0xbffefe3cfeb55a00, 0x40027cc108693ef6,
    0x4006458f28dfcc02, 0x3ffbfb75fa02d8e0,
    0x3ff6c906ea0ce739, 0xc01068bed425610f,
    0x3fcc1e1224e1b5c8, 0x3ff87df794582ad2,
    0x3fc395bbf108ecd0, 0xbfed4b3cc3d91b62,
    0xbfface6628297b8b, 0xc004d14bc803d5d8,
    0xbfb6ed8048a6f2d0, 0x4009ac426150446d,
    0xbffd7948004f9e0b, 0x400026459c214abc,
    0x40020bf97fee8a69, 0x3fb7773478f4dc20,
    0xbfe2d1ffe7d2ff0e, 0x3ffe810ae590c8fd,
    0xbffca2178b8662a9, 0xc00d8e5fe05a4efa,
    0x3ff5b0ca1fd9e87e, 0xbfd9828a20a68d1a,
    0xbff641a1504fc86f, 0x3fdc516a3272f59a,
    0xc00343a9bfc20ee1, 0xbff8ea5137e1d1a0,
    0xc0107cfd3988959a, 0xbff2f98f5f9f96cc,
    0xc005b683d2b29b71, 0x4011c759ca69a95c,
    0x3f86450959fc0240, 0x4005b3a4049817e6,
    0xbfdb458018abe8f4, 0x400d2bcc81dd83f9,
    0xbff96496cf523bd6, 0x3fe8cf1a8a64f7bd,
    0x40090208e2a22042, 0x4000294dda7754ba,
    0xc011b6ba0d6e395a, 0xc00e1d537210068e,
    0x3fdb415b805ab4fc, 0xbff60600c90b9c78,
    0xbfc6577d5d6fa7d0, 0xbff95ead8c3379ea,
    0xc00587bb1644bee4, 0x3fc75d61fa049910,
    0x3ff94c31d8c6805c, 0x40040d2daa8cac5e,
    0xbff27e35c7bc5c4a, 0x3ff2a711a78842ae,
    0x3fe5c7fb03f309b4, 0x3ffe3d8063a08f7b,
    0xc00203156b393e1e, 0xbff53def958b4ed5,
    0xbfd86dd287fc455e, 0x3ff71ef1c49c9fe4,
    0xc00554f596c456fa, 0xbfe8a6211e2900f7,
    0x3feb90beb6260733, 0x3fcd83f11696288a,
    0xbff2a75bebddbccd, 0x4003ab48acb6f96f,
    0xbfd75c5926cd7756, 0x3ff7941f6fb35634,
    0x3ff39c54680fb9c4, 0xc00362e38727ff33,
    0xbff331ec56694808, 0xc0100c0ea9b6b7ab,
    0x3ffcd43697af1349, 0xbfe05917e3fc425c,
    0x3fd3e1acab215628, 0x40078c4e7799fba0,
    0xc00748d71e01c64f, 0xbfd47a6df7186522,
    0xbffe160e3022998e, 0xbfe04ebdf4251c46,
    0xbfeaa75d1ff7fc9e, 0x400015e416c51d82,
    0xbfee329760cbdae6, 0x3ff8be8c72b59a93,
    0xbffe341b4d750082, 0xbffbd72b4510de40,
    0xbff55b57f71ca6d0, 0x4000b31edbebd3b6,
    0x3fe45ef25d342c3c, 0xc0049bfe78065380,
    0xc003d211a74304f6, 0xc00591067fe04b77,
    0xc011e46ac7e225ab, 0x3ff9b31cb4df9f5b,
    0xbfca57cca8a81068, 0x401327e02fe0a126,
    0xbff1a49fccde9227, 0xbff518d21f4c9d3e,
    0xbff1f9527c417961, 0xbff4176327fb56f8,
    0x3feab19aaaff2642, 0xbfff3d81de3a342e,
    0x3ff78a15383edd2f, 0xbfe934e755956108,
    0x40008d7004bfac26, 0xc000284eaefeb6d7,
    0x3fe725f89674138a, 0xbff6f434de1a8a5c,
    0x400a6b694a42189e, 0x4008b6658150a931,
    0x3feb703b4198fb6a, 0x3f917c4d47349280,
    0x3ff847b57d737389, 0xc0031f71d9f9abec,
    0xbff71dc3c526d604, 0xbff16c9d43cbf8d6,
    0xc006968e527655d6, 0xbff2cb5f89e10b1b,
    0x3fc7b643a42eb2e0, 0x3ff735226c9067fc,
    0xc0184101b90b1a7c, 0x3ff4ef3a371f3d8a,
    0xc00172ff91bc06b2, 0x3ff08949d500b914,
    0x3ffebae8f91c649c, 0xbff30befb0e0705e,
    0xbff4a97511ad4a6f, 0xbff2a5a4ef3ac078,
    0xbfe8990fc59db175, 0x3ff0e85f6afd4737,
    0x3ff823a501828562, 0x40015d0d43cde7fe,
    0x3fe8410a43ebf24e, 0x4000aa1a1a3e2f54,
    0x3feeccdae0e9d3d6, 0x400fc21b1a41550e,
    0xbffbdea27221db2c, 0xbffe05d285130038,
    0xbfdf6e4890621070, 0x3ffc95d0d9549311,
    0xbfdb5eb5a0912dc8, 0x3ff73abf5102efa8,
    0xbfe3903c659dd8e1, 0x3fca6bd9842f1230,
    0x3fe4073d105b7422, 0x3ff0cef6863e0376,
    0xbfe10902081ed6a0, 0xbff2ea0b79d87752,
    0xbfee38599593b001, 0xbf9984bf868c3640,
    0x40058926f4d5e512, 0xc00401e7aff403c3,
    0x401b98f5dffbed9b, 0xbfabae75fa7c7c40,
    0xc0056cb69ce7b0ea, 0xc00ab95713331d52,
    0x3fefc300e685bfbb, 0xbff0299987f1972a,
    0x3ff6921f41980436, 0xc0001c9f340544f2,
    0xc0037ebb9b4a9c41, 0xbfef27f6e27e79c2,
    0x400f41f1dc702576, 0xbfed42406dca07df,
    0xbfe79838b05ec6ce, 0xbff18c19fa4c0295,
    0xc002858e4ddfeae6, 0x3fbc643d0e3c30a0,
    0xbfe0049b1ee8cd6e, 0xbffb1c3851fbff08,
    0xc009e726b7515f3a, 0x400b7d096a0fbb86,
    0xbfe560078b5246ad, 0xbfe77f410dab043c,
    0x3fd5ae078a6483da, 0x3fec41dfb6d73466,
    0x3ff36949da7ab247, 0x3ff5ca5b12f2e2ca,
    0x40132d4abb038b75, 0x4005042d1f7442ea,
    0xbfe372e2acf980e8, 0xbfb3c32d4a70c3d0,
    0x3fd2061cf1775f64, 0xbff6013dbf2ad297,
    0x3fc4662a33376290, 0x3fda88aeef6cecd2,
    0xbfe975366cb3e9ec, 0xbfc580c4ca6c70b0,
    0xbffe16811f9a44ad, 0xbff3d370899bd5c5,
    0xbff32fc29c9a0540, 0xc002edda96e451c3,
    0x40007260d48257a0, 0xbfe3fbc7ba9d528c,
    0xbfb8e2da64d82b60, 0xbff766a6497d3eb6,
    0x4006ef609c44f3bf, 0xbfc5406547e44c60,
    0x400035c47b9806c5, 0x4011953cc72b1528,
    0xc00b3fb30cda30d8, 0xbffbb158e21caffe,
    0xc010a6df89d9103c, 0xc009ad63fec2e732,
    0x4016f37bccb56d6c, 0xbfe3d96a321a687c,
    0xc011e058bb464180, 0x3fe0bd3edd774b64,
    0xbfef2b7005a5c48f, 0x4003d3b5245d2155,
    0xc00303e0f06b31c7, 0xc001f8e48ca347fe,
    0x40109d17ff9f8168, 0x3fe0a24e86a0f1c6,
    0xbfcd4f5c3eace370, 0x3fff7410fc227639,
    0x400bb4c2b4be802d, 0xc0005d70418367ff,
    0x3f407cd4dcc36c00, 0xbffd18464f324c72,
    0x3ff1c6d1921d7598, 0x3fb1f2cb0b10aea8,
    0x3fdaf7c3c3074cd6, 0x3fc36488aea7e620,
    0x3ff1cc34e55d471a, 0x3fff50419c3f104e,
    0x400f8e5afda708a8, 0xc004eb76a1220f49,
    0x400256cb16ac2fa9, 0xc005079e514a90b6,
    0x3ff67fa07d60b8c6, 0xc010b9abc8f45592,
    0xbfe54d506723c9c2, 0x40050e1d3abec080,
    0x3fece140a0dac398, 0x4004dd0d6db71dde,
    0x40109d6925a8e756, 0xbfe1e6c5856a7754,
    0x40128d90fa8395ae, 0x3fa1b795e7795cc0,
    0x3ffb6b0c55f4d6dc, 0x400525e5551eb692,
    0x40051522aeaaad5f, 0x3fe42bad28785484,
    0xbffe94e496022c73, 0xc01e85b7aa50fb12,
    0xbfd25400a421ba64, 0xbfe27b8a9be2ea6e,
    0xc01a4aa98a00f0f0, 0xc00baa2aad4690cd,
    0xbfdfd07b8c39f1bc, 0xc009490e9bb47856,
    0xbfffafa3ebfd66ae, 0x40111a21a0391b16,
    0xbfba7d0da9a83f88, 0xc00bf260c342b258,
    0xbfc1bad7837b84e4, 0xc00cd93f720d4ca5,
    0xc0038d86ad15e33c, 0x3ff0dadb78c5e2f2,
    0x3ff99742045f15fb, 0x3ffa6da21e33e87d,
    0x3fed19ed596af1f5, 0xbff8422e0416c978,
    0xbfdc58bc32f42310, 0xbfe9e310b67d93c4,
    0xc00b4be2bb8789d2, 0x40124814c3b39e58,
    0xc00f999c01d0eef6, 0xbfee74f2537efcdc,
    0x40171d13879cf17b, 0xbf69126af3754000,
    0x4006fd6b8a8dd765, 0x3fd99753d02c33a0,
    0x3fffd1affcbc5566, 0x3fde761ef5122fa4,
    0xc010b5b200999274, 0x400c06c2050c077a,
    0xc002b23cbeeea10e, 0x3fe838578b229304,
    0x40049b1b07fef22c, 0x4000c34f22edd953,
    0xbfefefbc08fe5ea0, 0x3fdfca826f016328,
    0x401204d32bfb490d, 0xbffe68620846ffb0,
    0xc0056d52e28c193f, 0x400ebef7aaf33c60,
    0x3fe5dd3ad999c67e, 0xbfeb5d883fa6a864,
    0x4016bae93896cb76, 0xbfee77c3aa55930c,
    0x40027d383d669870, 0x40107a42690d0f3b,
    0x3fbf1bcccff79d60, 0x3fea9cc7356bcaaa,
    0x3ffe11b90072109e, 0xbffc640832f30646,
    0x400179cd376d3e3f, 0x3ffb6c0d0fadfb24,
    0x400cdbf59ed30e55, 0xc00199082a4b14d8,
    0x3ffa68bff8afa685, 0xbff7c9159b4cdd29,
    0xbff1434998771d7f, 0xbff32d66947246e5,
    0xc000d2ee4b8cba1e, 0xc000e4d341e8c0f4,
    0xbfeb9c34080d64f8, 0x3ff27fa19b96d866,
    0xbff7f161bc758eff, 0xbfeb955c266392d8,
    0xc00d5f3644af70a9, 0xc00a5ec82641f96d,
    0xbfe08698706e1a3e, 0x3fcdddc7744400c8,
    0xbfc7ace2c632e6a6, 0x3fefb6da00a70b38,
    0x3ffc1a5b74c95312, 0xc002a445b11411b2,
    0x401270465ce6a3ca, 0x40038474cd7e2f83,
    0x400c7b7a7f66fafc, 0x40051b4ffbdff810,
    0xc00025c04d7bbea4, 0xbff54d7cfd3ad0b2,
    0x3fb69d3bce563e30, 0x3fd89d7b5e31a89c,
    0xbff2d2ed3f92a059, 0xbf8cce5e1bb60780,
    0x4000701b875bb364, 0x400122ae28cc8e2f,
    0xbfe2b99fe3ed5bd8, 0x4007a67fa5e0a51e,
    0x3fee36482992225b, 0xbfe0182ecf899dd8,
    0x401022dc652c9966, 0x3fffc28370dd773a,
    0x4009779683aa1581, 0xbf97642f8eeb0500,
    0x3fe66620319d0f30, 0x3ffd528fa49d01f2,
    0xbff13359ea66632f, 0xbff15e5d259dd0d3,
    0xc00fabd376ba7760, 0xbffdf1af849a294c,
    0x3fd7de0f8773f4a6, 0x3fbe3325b92364d0,
    0xbfe886560efb6350, 0xbff74699d9e554cc,
    0xc00da1398261e400, 0x4005bb9227543b1b,
    0xc0097ce33189bfa6, 0x3ff1d9889c6d47e4,
    0xbfa09981e8d95c00, 0x3fff481af71a9a5c,
    0x3ff237e03e299124, 0xc00c2f1db46ce5e4,
    0xbff55102f8e031ab, 0xbff06f285f8ce82b,
    0x400e1cbb56f9a4f6, 0x3ff04de816a39ee0,
    0x401008f5a5cc7ac0, 0x4002565c6b9a9045,
    0x3ff4cca8a48f75fd, 0xbfffce350ae245dc,
    0xbff871576c39af82, 0x3fee7a4f705e2900,
    0x3fd35a02a53ed400, 0x40053dc93b031feb,
    0x3ffb33d7a727b38c, 0x3fd3b5a8aea8c4fc,
    0xbff0aaeb52c4d9f6, 0xbfd794c487d27b98,
    0xbff6ebc32ebe8d4f, 0x3ff98a5c831ff57b,
    0xc0028604b69adef9, 0x3ffaa116d2b15c65,
    0xbff56245b2cfe37b, 0x4010ee61d3786822,
    0x4007315a0bdba7a0, 0xbff111ad1a69925b,
    0xbfe1edc6a22506a0, 0xbff2e56c2523241a,
    0x3fd06c0ef83c9880, 0x3f92d762437399c0,
    0x401863ee28b1960b, 0x3fe9735422517566,
    0xbfef0973b4181258, 0x400e588a16afa236,
    0xbfd52432a007a532, 0xc004cef0c703d725,
    0xbfe0b59432a25fad, 0xbff331a61c7c82ac,
    0xbfed77d31715cfbb, 0xbff50064a2486eac,
    0x3fee47d48fd10bb4, 0x3fd04df76fe6c721,
    0x3fb286bb053a4cb0, 0x3ffac99ddc0d4198,
    0xc0011c7069b4ead9, 0x40017d45f3a34f33,
    0xbfd24416ee7fa320, 0x3ff3814d9a2bf346,
    0xc0040c490784c9de, 0xbff58dd3ed65c13a,
    0xbfced56dc8e093fc, 0xbfe5053e572b4e6c,
    0x3ff7340fa2fb4d17, 0x3ff38b899fa74b1b,
    0x4001600bdc70c820, 0x40085350a730ab52,
    0x3fd188c7ca165774, 0x400e62f96795035c,
    0xbfd12c584f221e30, 0x3fed6bd5c1831e06,
    0x3ff4c7d058fd67f9, 0x3fb23ecf6baa19c0,
    0x3fc3d169ab12bb34, 0xbffc90ecb1147bfc,
    0xbfda8b520bf7f40e, 0xbfeb4d38db8d3406,
    0x40055026e7ca1bd9, 0xbffaa1d6116a0e0a,
    0xc000561882b4f706, 0x3ff3d5b1bbbd8211,
    0x3f43a951f44eb800, 0x3fe42d611bdc90c6,
    0xc0010b8c5a1cd710, 0xc015d5d83629f499,
    0xc00bc60837985e86, 0x3fbfd45139f85600,
    0x3fe71dcddd901dd3, 0xc00c74164bf07103,
    0xbfeb204f009f44ec, 0xc010a30c925d27a6,
    0xc0077bf3a12362fd, 0x3ffe7d2e9f5c5aaa,
    0x400f798149641af7, 0xbfa04c841d6b7b70,
    0x3ffd570da311030c, 0x3f7a0d2950357500,
    0x3fce352ba58f1018, 0xc0009241d45fe3d6,
    0x3fd1bd1d8494ad30, 0xbfd287594aadf95b,
    0xbff98cc71d8252ad, 0x3f3984bccb7f6000,
    0xc007a4b0aa23202c, 0x3fd7d46d7dc8a4ec,
    0x3fe3e7c0ccfb5d86, 0xbfea2de3e80b9bc2,
    0x40051465b338a38c, 0x3fefc08da6a25b26,
    0xbfd6afb92514df94, 0x3ff85f3320cf47df,
    0x4015f23f4687dbd5, 0x3ff80b165a6185aa,
    0xc000db153165b15c, 0xbfe40abc0ce396cb,
    0xbff567367a659284, 0xbff9edf9dc3bb1ce,
    0xbfbae89bf8077732, 0xbff134e099aebe75,
    0xc0065c3cb6bdab14, 0x3fca8b23a049ea68,
    0x3ffeaa86770479f2, 0xc000342834868adc,
    0x3fe2553c68be8466, 0xc00819dd0f4351d4,
    0xbfeee225060720d8, 0xbff868c3905eac94,
    0x4010dd3f346bd9d0, 0xbfe45436ea24b74a,
    0xbff7e616bc22eb42, 0xbff51ea2723f8aaa,
    0x4001f57922f19cfe, 0xbffa382e81a9e75c,
    0xbfe5703d91865f44, 0x401054a3a4117ddc,
    0xbffc6c1d682571cf, 0xbfe338565583e56a,
    0x3fed757b0d2e68d4, 0xbffe3b0bfc2865c8,
    0xbfde7bf394d503ce, 0xc00d0510ae87e1b5,
    0x3fc21ddaf4786568, 0xbfedae7fa37c6718,
    0x3ff88acd99961fd2, 0x400a5e1ea1be1c97,
    0x3fef428dc33a5de6, 0x400fdb4eb768ae5e,
    0x3fe6aade5f06c38c, 0x3ff890797795db7e,
    0xbfc16a8eec92a470, 0x4011afdde79ae650,
    0x400e5c31795557d4, 0xbfe73f98236ac098,
    0x3fe821185dd53d6c, 0x3ff34a793d20c3e8,
    0x4005eaa97c4830ce, 0xbfd557f4a95748e4,
    0x4004423311e2265a, 0x3ffcf1cfe82e95e0,
    0x3ff9710f3ab9db75, 0xbfff57e32353d6f2,
    0x3fd50a72b9e724aa, 0x40129124e7a024a6,
    0xc009e6392954aba4, 0x3fe8125a57d636b3,
    0x3ff758e775370cc0, 0x40044d1825620e93,
    0x3ffb3058e9353e61, 0x3fefda361c4bee54,
    0x3fe56c213988709a, 0x4005e92be9e56a10,
    0x400350f7ecd171ef, 0xbfd8a0a6e6e13810,
    0xbfd08608eb7ec77c, 0xbff27685eb92227b,
    0x3fbd570884c4bd70, 0xbfe2a3c6228cf968,
    0xc0041134bcc904ba, 0x4004396f90603e43,
    0xbff1fba016d6429c, 0x3ff7f84fb5c7033e,
    0xc0092b1ad03a07ea, 0xbfffb892f7805153,
    0xbff087be716081e3, 0xc00632d85318f5f0,
    0xbff57ca7a556ae29, 0x400dbfd63f369763,
    0xc0099c6e775b38d3, 0xc003f260d0c306cb,
    0x4000f0fa0f578b4e, 0xbff0e70e23105223,
    0x3ff052761367abe1, 0xbfdecc1f7b54510c,
    0xbfe9b9ca8dbe9e22, 0xc008f7ab0df21f7e,
    0xc0048045a7a0a38a, 0xbfe826bcbc5fb994,
    0xbfeafa7c96bc410f, 0x40094a28f77ee666,
    0xc011a73b4e9dd637, 0x3ff796e7f5cdcfdb,
    0xbff057b1d4448c54, 0x3fd78087768c83ec,
    0x40153d9416e1adde, 0x3fe32f70104405e0,
    0xbfe37399bb71835d, 0xbffba493ff981d6d,
    0xc00640879a49eae7, 0x400f4a7a7f68f1ab,
    0xbfaa9225b52f2340, 0xbff0da5fcc51edd0,
    0x3fb3135c26b32140, 0xbfe8810006414ee2,
    0xc0056eb6bdcdead5, 0xc00cf7db999bde39,
    0xc001d8f168f38c19, 0x3fca1faeee0b42b8,
    0x3fd58e2c33f1b9ac, 0x40117183f84f1401,
    0xbfe4ac6a1e7d05eb, 0x3ff6ea12832ba974,
    0xbff236c75388ffb6, 0x3ff962c41fee574e,
    0x3fc5ed72aa0bf2ba, 0xc002c1e5d8150d6a,
    0x3f81da0b3ff4b600, 0xbfd4db8ce60a7864,
    0xc0029485307d307a, 0xbff516bf4a41f134,
    0xbfeda4787ca86b90, 0x40012fedfe5a2e8f,
    0xc004fe6cc6034819, 0x3fe30f5270a9c24e,
    0xbff40e75386dda6b, 0xbfe8e7aff416f558,
    0xbfe35e3c939ee460, 0xbff7bd4dc5930c0c,
    0xbfe7d0e9a30ed827, 0x3fd51ceb87f8ab62,
    0xbfd4c327fcc93dfc, 0x4009246480cdaff3,
    0xbfd382fc8dac4e9a, 0x3fb1397854d66660,
    0xbffa86a56795e28d, 0xbfe6c480bacb396a,
    0xc00f313d7fbcc752, 0x400df779f8f9ea67,
    0xbffce2fafa1b235c, 0xc011cffcaa933650,
    0x3fdd1b34a0222754, 0xbffb1d24b5948396,
    0x3f7fca3df0ae1b00, 0x4007682732f2d10f,
    0x400787a2405660c6, 0xbff0d862abf7292a,
    0x3fd6ac4b47818ce7, 0xbff97382cfebeb58,
    0xbfe8b1bac6140d8c, 0xbfc47037bce94710,
    0x3fda96dd1ff2f100, 0xc00e559cd66eb350,
    0xc0098c04d35743d9, 0x3ff795608bd2be98,
    0xbff20eea9e8ec7b8, 0x3ff479d855b26366,
    0xbff7fb12839e339b, 0xc014ef6e70923d4a,
    0x3ff2f1c97e055e99, 0x3ffa4c5bc4992816,
    0x3ff2b8592286655a, 0xbfef51fe72a2d79c,
    0xbff5b5157954c070, 0x4001dd1f45321726,
    0xc0068026798a071d, 0x3fa611392c7f36c0,
    0xc00dd0df9d20459a, 0xbfd796ed7fa84a42,
    0xbff8734b072d7d48, 0x3fe080e9f4b63622,
    0x3fee9438b8f59d24, 0xc004c8cc8b305518,
    0xbfb689dee3c83638, 0x4001c1857ac542a8,
    0x3fe2fd48bab5138a, 0x400028ee50b5a79c,
    0xc0050b9cc16acbc7, 0xbfb6e56e88e75d90,
    0x3ff9653e3907558f, 0x3fed50cd3685dcb1,
    0xbff06850788444ba, 0xbff197f9984acba0,
    0xbfff487940d555ac, 0x3ff47a1e0d133718,
    0xc012a90ed8f70beb, 0xbffc6f1a6907426a,
    0xbfc379bc49e63a18, 0x4000653291346454,
    0xbfd80c1da303667f, 0xc00187ff2fe67619,
    0xc005440726bbddd9, 0x3ff20392587711c0,
    0x3fea477502a22986, 0x4008f382be4244d8,
    0x400f233aaecbd84d, 0xc0080e10999fc7d2,
    0x3ff6095ee03e8605, 0x4000016bbd8334b4,
    0x4010b32fcc60f530, 0x4011e6c605336aff,
    0xbfe1c3ccbfe7429c, 0x40016a9b4c1997e2,
    0x3ffa98798dde57ad, 0x40169fcec0f3298a,
    0x400be3c3943853c1, 0x3ffb03f6ec0e846a,
    0x3ffd3af208da0326, 0xc00315bbc933ad2f,
    0xc0034e9cf16c8a28, 0xbfe9a01445051834,
    0x4003c8b2d43aeb6b, 0x4006ab18c55ce4a8,
    0xc0071f4f877724f4, 0x3fddd4d1e011f630,
    0xbfe825f90e3ce048, 0xbff1af8dcb2ba466,
    0x3fec67a64e50ddbc, 0x3fe570bf89a3220f,
    0x40004ffc57da198e, 0xc010a7349a792407,
    0x3ff5915414f73f79, 0xbffcf8c5d97478fc,
    0x3fce3252ab4fd8d0, 0x4000a60d3476a931,
    0xc003e93af0d044b9, 0x3ff23942f5e538e6,
    0x3fd19b168a569d94, 0x4011b49c4391168d,
    0x3fa9e34b55579f80, 0xc0067b7b4f5b1963,
    0x3ffda4df9dcab512, 0xc0069eddc0a4c518,
    0xbfec1673be869286, 0xbfe77977d2a6614c,
    0xbf86350394ed4900, 0xc001bda467922fd4,
    0xc01385af8eeaa2b4, 0x3ff297e0beef6058,
    0xc007208eddd4a8c6, 0xbfe594c4761aef82,
    0x3ff1620f9cc0b31c, 0xbffda7d747a328a6,
    0xc009dd04526115fb, 0x3fe3f7e07b3b30af,
    0x3fd9665833824504, 0x3ff323ab51877023,
    0x40057ad38f84c8bd, 0x40062649b9de54ce,
    0x3feca54bc81c8927, 0x40019ca8229c0a7a,
    0x4016416e9f08eda6, 0xbff36990ad6ebc8e,
    0x3fe11856aa651ab4, 0x3ff33540c8ae46e1,
    0x400c85edfd3869e4, 0xbfdae110248e31a7,
    0x3fe81378f684c1c6, 0x3fe23f9ed24aa378,
    0x4006328090b9d464, 0x4002333fa5a5aa76,
    0xc00b4aa24aed85b1, 0xc0065518e1573ff2,
    0x3fe4903ae918a665, 0xbffcc6240e5f4014,
    0xbff96ba1de1eefc0, 0xc00a9936062d130f,
    0xbffc2110abd93340, 0xc00174a5792a89e8,
    0x40104bd88c2c9303, 0xbffe43daac6ac4d7,
    0x3ff40981b9895ee8, 0x4003148b63f6bafb,
    0x3ffe2a5e8306315f, 0xc00adeef63f2b01a,
    0x3ff09f442f96d0fa, 0xbfe6da989b22fbf5,
    0xc0006dd46b13d056, 0xbfe6b846ed3583e8,
    0x400189be7a3d2e16, 0xbfcaf04c59f2b768,
    0x3fff53136c33dc3f, 0x4011c3132d2095ac,
    0xc00649129688e980, 0x3fde445f2569ee38,
    0x3ff2d036d31e15ec, 0xbfe8dd14c7819133,
    0xbfe2c72c0f4fdd93, 0xbfb731816ff1c870,
    0xbfee56dfc7283d6c, 0x3fff43d8fd7dd203,
    0xbfffa6b76347fa3a, 0xbffa0af2d51ad34a,
    0x3ffce8624b7af6f7, 0xc0008b02f4444669,
    0xc0024a347e86aad5, 0x40065d28ed2ae23c,
    0x3ff354f0b3020d4c, 0xc000913b05ca0c17,
    0xbfd6cabe7d7bf168, 0xc00555719614eef6,
    0x4003516d1a78f62b, 0x3fed79d3a829df84,
    0xbfbb59fb50c9fc90, 0xc01159fcb37b72ae,
    0xbfbe605f4e375228, 0xbff508ad23e1e555,
    0xc01096feb060054f, 0xbffaa67d040a9c24,
    0xc0026f48b434bec8, 0xbffca86772c17a6b,
    0xbff4ec15feb6d4e1, 0x400a9f44f548e034,
    0xc002bf8a4f996f6e, 0x3ff35ce3f95643b9,
    0xbff9aa55af1671fe, 0x40044b8d35db394b,
    0x4002aee5a936f122, 0xc00671114acd58fc,
    0xbfe9d87d565432c6, 0x4004e761ecaeb9b6,
    0x3fec21e77f0601bb, 0x4008fb30aae622ad,
    0xc00ae90b7d2cb140, 0xbff4424f3366236a,
    0x3febf0eec91f32ec, 0x4003730ba21406b6,
    0xc0099fc8538b65bf, 0x400b7ab1060757b1,
    0xc0021a54d94c8eaf, 0xbfb653ac6b3bc020,
    0x3fee3817ad3a6bf6, 0x3fb9b126c86b76e0,
    0xbfd868bc907c8d60, 0x4002cb4b04452bd4,
    0x3fec6432c090cb4c, 0x3fe50475fa1d7dc4,
    0x400b05314332b5b4, 0x3fce09e86efc5ce8,
    0xc0096c63a3ec35e6, 0x40034fb36aebffd3,
    0x4000116a1364f987, 0xc00436948b9c521e,
    0x3fe67e29c48d5764, 0x400f61e0e055f00c,
    0x3fde9378431e51c0, 0x3fedf5be3104d4a8,
    0xbffd1a03bd26e307, 0x3fd426d17741785e,
    0x3fe2d7ad6d7847a7, 0xbff5042986354feb,
    0xbff397b95cc52106, 0x400d0a22c3259e3d,
    0xc00e235c8d9d0fc8, 0xc00383e2d6a2eeb1,
    0x3fe9fec01b017ea8, 0x3fcf68fbdb90d034,
    0x3fe4c1855eddd5ac, 0xc00b5323c8a1054c,
    0xbff346d970bd875b, 0xbfed660d66335664,
    0xc00645430162e7cf, 0xc001f0a608a7a885,
    0xc005c4f02cef4d01, 0x3ffdd50d4b336248,
    0x400556bc67bf6fc0, 0xbfe60b061b9f3dfd,
    0x3fd2bf53c48b48fa, 0xc007cf172cb6870e,
    0x3ffe2b2952e85fc1, 0x3fe84da28f77ff80,
    0x40118eeab284a0f2, 0xbfe982e510388b26,
    0xbfd291eeafe7b730, 0x3fef9b391cbb202c,
    0xc014f19d93ef83ca, 0xbff94e4a57564906,
    0x40034760e9182870, 0xc004e8b6b824bcb0,
    0x3ff345f066094660, 0x3ffe3bbc53993f33,
    0xbfd2446e61defd9e, 0x4004f0f029589c1c,
    0xc000e607ae23dcd1, 0xc011a5f545865853,
    0xbfd834b85a9afb48, 0x3fe253be4a03aab5,
    0x40147c7fadcf00db, 0x400f5b4ec03686bd,
    0x40086f6ad65bd1be, 0xbff830c7fcc08abf,
    0xc012610077e41eaa, 0xc0033b4b5ba2078b,
    0x3ff9003af5a456bf, 0x3fe621fdde738256,
    0x400182f59a6546d1, 0x3fffe7ba9b01be30,
    0x3fd9ec97cc10a20d, 0x4011b20d464ad092,
    0x40067932de90b8ee, 0x400c781154998282,
    0x3ffddeb93806ed9c, 0xc001f18c66aefd2a,
    0xc009be7aaa2c45a6, 0x4001dd90e0f3ebbf,
    0x400b98da7eb5d54c, 0xc0089ba06b296225,
    0xc012a72d33b5a0e0, 0x3ffda9eddd8ff535,
    0xbfb5fffbb9f04650, 0xbfe46b3c871e93d4,
    0x3fe49c97a2e6b94c, 0x4003041501a6038b,
    0x3fdae80531eb70ea, 0x3ffd5c1dfaf3a95a,
    0xbffcace9db85321d, 0xbfee1c05dd5bba24,
    0xc013afc050d7c082, 0xbff133e3679775d2,
    0x3ff7278a6769d6d1, 0x3fe0067411b62c50,
    0x3faafc20482933e0, 0xbfa00807e55485d0,
    0xbfee047c714f5df2, 0xc00028898cea4808,
    0x4011cf8bc01cb294, 0xc0040a628a369d47,
    0x3fb40fcc534915c0, 0xbfeef2299a467dfe,
    0x3ffb23cc4db70be3, 0xbfd2edc10d20e80a,
    0x3ff55f74083c2cae, 0x3ff706313e291142,
    0xbffdd95b8c03eb83, 0xbff0bf866422ded7,
    0xbff35fff8fe6693f, 0xbff0d2b6073f0900,
    0xbfc7989b67b392d8, 0xbfc38294fa56a358,
    0xbfe7707706a2ff8f, 0x3fa00c2362806178,
    0x3fe1c848f0a6be70, 0xbff249faf556ea3c,
    0x3fd0aa5f1f5a461e, 0x400b1ea04e964547,
    0xbfe4680ae09c9871, 0xc00907f935b020c7,
    0xbfa52fbf33fcc750, 0x40079ce4d1c3f091,
    0x3fe780e487567f14, 0x4002cf9883494678,
    0xbfe24abe0d1a7d0e, 0xc0062fe6a2dc7786,
    0x4016edd3c582a0db, 0x3fe012e4ddc3df22,
    0x3ff1fe13a3566c7a, 0xbffa451d72e90b1a,
    0xc00072a1dc681781, 0x3fec5b0087481eb0,
    0xbfe3e88b122e8288, 0xbff81f8a5ee78f56,
    0xbff4e80277a04e22, 0xbff1cec799999696,
    0xbff04a06ab33ae62, 0xbffe8801cde850f0,
    0x3fe94158f26a411a, 0x3ff949f8fb4cf3e9,
    0xc005e1291117affa, 0x3fce8142364b1ab0,
    0xbffad274d98d7cae, 0xc00c415906c178d3,
    0x4003fd4bb9b86ae0, 0xbfc84d74fc8b0cf0,
    0xbfe423b50e3c2b54, 0x3ff4768306c7a9c8,
    0x3fe00c854b33ceff, 0xbfdcbdb468ec8640,
    0xbfd5ac3b02d129d0, 0x3ff8666f83395b08,
    0xbfd26be1ee94fb60, 0x3fce5dbb5e22c64c,
    0x3ff0edaab568588b, 0x40041943faf05052,
    0xc0026b3d768f855c, 0x3fd0cffa30c6bda8,
    0xc009ae03265a07ec, 0x3fcf75ebb569b000,
    0x3fe15c4abe80e4ba, 0x3fe1d51954bc009c,
    0x3ffd4f5e436ee14e, 0x3fe1754c995cc696,
    0x400239c76513ee05, 0xc008f65634cbdb0d,
    0xc00409f1a5a6957c, 0xbfee85d67c14109e,
    0x3fff512b3db492f4, 0xc0128ad8b1399a8e,
    0x3ffad18d3691adac, 0x3ff40aaacefce8b0,
    0xbff4c501d99fcec5, 0xc0125ea28f2d790e,
    0xbfb33b3756153ec4, 0xbffc34be0d21b682,
    0xc00e793a396a2287, 0xc0061e9f049320ef,
    0x3fec3bac548bf545, 0xc01d34f4167fe8a6,
    0x3fee08595bc7f3f5, 0x400b6cfbb2640c39,
    0x400cf375883db8be, 0x3fde6eb4ec61e066,
    0xc0015bb7feec0928, 0x3fd48e1095c32910,
    0x3ff92cc5072fbe46, 0xc0072b03fe3870c7,
    0xc004a396b4dd31a9, 0x3fefb6d402994fe0,
    0x3ffcb602e30bdaf2, 0x3ffdb2d8d22eacfe,
    0x4000525f1bb5c540, 0xc013bcd16604b3e5,
    0xc0017b5ae20b238d, 0x3fcf856c3a77c0b0,
    0x3ff46701859a8054, 0x3fb9983f852354c0,
    0xbfee311faf1c641a, 0x3ff42c25d41a3119,
    0xc0154479f4f9dc0c, 0xc00da4d749cd5faa,
    0xc016a872d0000c88, 0x400130d178f48472,
    0x3fec4535aed08d6d, 0x3fc5fe5e6b4ce750,
    0xbfd5b0ec83e734c5, 0x3fd099bdfaee80bc,
    0x3ff59b67060d68e6, 0x3fec4bcd106b475c,
    0x400d20b5b52005c2, 0xc002b3932ddfb65d,
    0xc016923930b2f250, 0xc002089008357820,
    0xbff8f8daaa597e64, 0xc00301442950b870,
    0x400962a31d8e060e, 0xc010ec8f4496b536,
    0xc0012829cddba3b7, 0x4004ddab03455e9a,
    0xbfc09795726fbbc8, 0x4008992f5dc37087,
    0xc0037dd8a8c07251, 0x4000b46e64c391d3,
    0x3fc5106ae4f7c332, 0xbfd67aac69f2d736,
    0x3fde89fe46c054f2, 0x3ff389b08d8b4462,
    0xc013fec12ebe8ae4, 0x3f9a341100e54cb0,
    0x3fe0cd072973b232, 0xc00860ef93947bea,
    0x4007c392dceb99f8, 0xc0082c3df5f03e94,
    0x3ff50be95968a9c3, 0x3fe22a8ab7f38bad,
    0xc0072ec6b70b47ff, 0x3fde5c22d70148aa,
    0x3ff3a7188f9664c5, 0xbfd86af1b42735fc,
    0x4004d629daf82492, 0xbfb410e9f697fb58,
    0x3ffcf4d5e43fa605, 0x40046d3cf9dbaa8c,
    0xbff42db362c2c84b, 0x3fee61a90d14feae,
    0x400ec9cc543cfba3, 0xbff85970bbe9a09e,
    0x40041284ab1cbac8, 0x40001767998c98ad,
    0xbff6b8216a2477d0, 0x3ff8b8e3dd2702c9,
    0xbff3fcdf7ffa98ee, 0xbf65b37fcb19eb00,
    0xbffb338dc6813642, 0x4003256e35224c76,
    0xbfdf89d58933ffe4, 0xc019b8ed558181fa,
    0xbfeab7a1d49df785, 0xc000ed4765a110a8,
    0xbffa2ea7ec6938e4, 0x4001dbcda70118b4,
    0xc00b38061040a300, 0x3fbc3504e73a9258,
    0xbff17cef14a9f0ad, 0x4002f9508b20975b,
    0x3fe59251bc58a17c, 0xc0111cefe1f4250e,
    0xbfc6b977b05399d8, 0x400120d4cfc9b920,
    0xc0039b670d8fb3ed, 0xbfdcedbfae01e71c,
    0xc00199b577de8c25, 0xbff3b2b523817e33,
    0xbfe0cebaa5ad314e, 0xbfdb4b383d25992a,
    0xbff3bd79783fcaf8, 0x40194828cd241b5c,
    0xbff365dacd4dbb16, 0x40114cd3fe6454e2,
    0xc000f1e32db8ee08, 0xbff14eeaa9f8b026,
    0xbfff76f3537366ec, 0x401302c853288746,
    0x3fe5efbfc02e2e65, 0xc0097c8c7660cda8,
    0x3fc0fe9df36b6aac, 0x3fd43967c6f2a788,
    0x400a554416c6d926, 0xbfe76195942fff16,
    0x3fafd55fafe11c60, 0xbffe6b3064abee7a,
    0x400583f7155db6c8, 0xc014865c4a7437dd,
    0x4008540a1e4825b4, 0xbfcaa0dfe9843704,
    0xc007f0c1ed5da1dc, 0x3fbb0392e4dd8bd2,
    0xbfb947ddaad03e00, 0x3feab442a90090ca,
    0xc004c710138f91cb, 0xbfd98f13c5a962dc,
    0xbfe9fb5bed9a8e04, 0x3fb1e0c473a14638,
    0xbff03b512fc20e00, 0xc0032499c88fe685,
    0x3febaa40044d30fe, 0x3fc5bf1178ca8920,
    0xc00302e96fa1f92a, 0xc0057c1d2f7c6a5a,
    0x3ff8eafcfdc96117, 0xc0128e6421306a89,
    0xbff274c37327d46c, 0x3ff9e729efd0e1e4,
    0x3feaa7d7a532e4d5, 0x40076b881e6ce598,
    0xc0028d8f1dfae50a, 0x3fe5ac44dcb5b003,
    0xbfd83f036dcb71f2, 0x3fcae8a8973cb2dc,
    0xbff9ccb747e0ed8d, 0xc00e4ef6801f29c0,
    0xbffb6a5eca1d28c2, 0x400cba4b219be8aa,
    0x3fe36e2c8c88de0a, 0x3fde1ff632d8a956,
    0xbffa1c0a61704326, 0x3ff13eef433a3e8d,
    0xc00364f178e3f0c4, 0xbfba110ac40664fc,
    0xbfe148be195b47f8, 0xc00dd16939f0be8c,
    0xbfe23736292d9f1c, 0x40118df716bed3aa,
    0x3ffb6ad2ac82df24, 0xc001195bf0523284,
    0xc0080f73c4403ab8, 0x400249cabdc1122c,
    0xbfccc54732dd90d2, 0x3fc49bc5ca8213c0,
    0xbfecd1eca8ec1b34, 0x4008b088050c3a61,
    0xbfef7e5b5057787b, 0xbfff7a018f42f31e,
    0xc0091ce7db16014d, 0x3ffa2ed7466ac4d1,
    0x400b76e812e1bd6d, 0xc005491131477ce7,
    0x3fef61f37ba9cc71, 0x401308eb3886395c,
    0xc01663ac7671c48b, 0xc00ab96a4437f4bc,
    0xbfe2e079605a5344, 0x3ff25d3875779932,
    0xbff8cc996260aee3, 0xc013321718b33e00,
    0x3fdc291d7b521100, 0xc011423b29306886,
    0xbfc4096ebf9346c0, 0x3ff539e9313a1d3d,
    0xbffe699c88f687b7, 0xbfd029fb541c36e2,
    0x3fcd9708be56ebcc, 0x4001c2ae1c2dde5d,
    0x3ff62c406670d566, 0x3fe7449f8e1f48dc,
    0xbfa4d62d37e629e0, 0xc00350d8b4cc8fff,
    0x3fe3c86ed2d125f6, 0x3fc94a64dda20520,
    0xc006be87b07a59fd, 0xbff94b0d7f87751a,
    0x40020a69cc204e1e, 0x4005ada939cdd089,
    0x3fd6564a7f0b6c96, 0x4004728a3df749e7,
    0xc0119ac3220c869e, 0x4007903163130783,
    0x3ff02870cfefd876, 0x3fc42798a9680070,
    0x3feaa064afd59e28, 0x3ffb1fbbc5929818,
    0xbfc41077dc518094, 0xbfe8906ce6d2eca8,
    0xbff35e039745680a, 0x40118f831e46302c,
    0x3ffb36309d5b1041, 0x3fd5f083177d997d,
    0x3fd2ab0ad2b01dc4, 0xbfe47e0159400380,
    0xc008f7476e5cedf6, 0x3ff959f122a4ba7d,
    0xc0067f950e6c27e4, 0x400b668d290501c9,
    0xc00bd5bd64e016ab, 0x3fe65d9fc475847d,
    0x3ff491565515be56, 0xbfe1f151cccfbfe3,
    0xbff3a9399bc7b1ac, 0xbfb1c1ddf974e9b0,
    0xbfc84e8393021180, 0x4009256706da46e5,
    0x4012538e7282abf8, 0xbf76e570437e5200,
    0xbfe050541564a34a, 0x3ff2c87c83bb5bb8,
    0x3feb29fa3db71850, 0xbfff146c1b03e5fc,
    0x3ffdd1de4f387adf, 0xbffe6d8294dacf79,
    0x400fbeceef5cba50, 0xbfd5aa291de703b8,
    0xbfebd0cb888ad634, 0x3ff1a770f08a09b7,
    0xbff21e7722499bc3, 0xbfda57395b8ffd28,
    0xbfff4821ef83763c, 0x3ff45f428bb8b5f8,
    0x40106384bce3cfde, 0x3ff1c931f3dd315c,
    0xbfebc9891b0a8f54, 0xbff93bbf638f4c0c,
    0xc002f03291fc783d, 0xbfec6033971fa292,
    0xc0036179200b02c7, 0x40076f500e85cf6f,
    0xbfb0d97196343510, 0x3ff0e92fcc59a856,
    0x3ff6c18b3f567aaa, 0x3fe8a0e216346c9a,
    0x3ff66c65aaceb6e4, 0x3ff57860aa175c20,
    0xbff25edc931af12b, 0x3fcb1d3d6c46f848,
    0x400b582fced506f1, 0xbff4b81b3eb465ac,
    0x3fd3d43031513e3a, 0xbfe59cc945dabf1c,
    0xc002314f53d26aaa, 0x3fbf9076f290ffe0,
    0x3fd998c872137b28, 0xbfecbf6b2876bf54,
    0xbfef57df9e5dc4fa, 0x3fe5b22cb88318ea,
    0x4001a323e2ed38f3, 0x3fd680670b1daa98,
    0xc007a40cd69d4d5c, 0xbffe08e1f8ca1d51,
    0x3fbece5b4853efb0, 0x3ff3641d37ba565b,
    0xbfe1abbfd1574db3, 0xbff3e89706076fc3,
    0x3ff56662fe805cf4, 0xbffd58f471c68a6f,
    0xbff1b244646cd1c4, 0x3fd605623ef7b8dc,
    0x4005ee2488eb1c84, 0x40050e1a5a8ba00f,
    0xbffa1bd083056940, 0x400e263f7906ffc2,
    0xbff665c640da2386, 0x3ff4c757ee49a524,
    0x3ff8fea2164b84ae, 0x400a84b5c635d01d,
    0xc00183a045b087d6, 0x3ffdeac3e22299db,
    0xc00692730ffcecac, 0xbffd91a738022f38,
    0xbff99cc3a5b4418f, 0x3ff86326d01194e6,
    0x3fef9afdbf741db8, 0xbffe3534f6a3bf8f,
    0x400682e2bd76c47c, 0x4003686ed5f9cba9,
    0xc00669a76e76779b, 0x4010bf16ab24bee7,
    0x3fe00e7760e3c818, 0xbf987829f10dd1d0,
    0xbfe9b2f7366feb7c, 0x400976f96f8881f2,
    0xbfda757adffe6b73, 0xc012940b9b1ad368,
    0xc003b5e3c7c0e584, 0x3ff0accaba8fcdac,
    0xbfacbfc1818b8490, 0x3fde0fe045ae9828,
    0xbffb252b028fe596, 0xbfee88b92323ffae,
    0x3fe1075b45a83ee0, 0x3ff48ee9bdf4db8b,
    0x40052d33e4c78d2a, 0xbfe2626c97113a28,
    0x3fdf89930ee56f24, 0xc003dabe85a5733a,
    0x3fe2cda845cbbffb, 0xc0033282c7b229e2,
    0xbfebdbca4e587958, 0xbff18729b9f8e938,
    0x400088928017d537, 0xbff884c966c7b438,
    0x4005ad713fadda07, 0xbfefd096fd217412,
    0xbffb110f33f7759b, 0xc00055977cd98d5e,
    0xbff44cbf7e327921, 0xbfee0d8db5a2ba1e,
    0xbfef79b393d03366, 0x3ffabf91e4f6bec8,
    0x3ffec030e9bf8ff6, 0x3fd0d9b7384cd464,
    0x3ff760997c62de4f, 0x3ffbf85450aa0229,
    0x4008f9a1e3435704, 0x4004bfd001fd822b,
    0x3ff01306ac028922, 0x4004b1c0c0c360fc,
    0xc00e8fcdd72e3fd0, 0x4008063a70be00ea,
    0xbfea5a8876314a8e, 0xbfe8d9226d59060c,
    0x40016dad81f71192, 0x4003cb97f7c1e920,
    0xbfda8ed457dad20e, 0x3ff6db91f501ad3c,
    0xbfe1941aaf785c7f, 0xbfebc01597941714,
    0x4004b845ae564fad, 0x400c92c2b5a21b72,
    0xbfe1dd79a5a45698, 0xbfbc1da528a84008,
    0xbfc4f3a08d6a42d0, 0x3ffbf5b53787bfca,
    0x3fec3bd75946c8af, 0x3fed339bfc383b5f,
    0xbff34b76e61f1b92, 0xbff5525093f62c3c,
    0xc0154e70bb9ec914, 0xc004249941ba4098,
    0x4004a4aed0946070, 0xbfe5c75e332c7d4c,
    0xc0115df863daceaf, 0x3fe6112735d53bb4,
    0xbff0611d3fce968a, 0xbff7a383139ed7aa,
    0xc002fc9402d47b04, 0x3fee6408f7318e5c,
    0xbfe0593db251fc6c, 0x400adbd8973ae520,
    0xc00a5810d43fc065, 0xbfeabb403744d92d,
    0x3ff0a696527d0182, 0x400f9020244e4293,
    0xbfd3c98a3d896de8, 0x3feda7434bec4d2d,
    0x3ff900f913ffe67b, 0x3fe143a9f806eb3e,
    0x3ffdb62c951a4aaa, 0x400e0302e367ec62,
    0xbfed99d8063c9bd8, 0x4003bda9b5031ac9,
    0xc00835fd879fa8bc, 0x40032fc180f4f788,
    0xbffe4f50faa31f8b, 0x3fd0b163499cd958,
    0x3fea225d27dbe9a0, 0xc00df763a6a90d98,
    0xc00f7c69f700a15a, 0x400c60845cc01563,
    0xbfe7040b04710a9c, 0x4015ecd0082189e6,
    0xbfed54c6fd82978c, 0x4003ac35eb970723,
    0x3fd3833f929a6858, 0x3fecdf4b501516e8,
    0x40068b32b4b7ebca, 0x3fe98ab6e9649419,
    0x3ff1fb48ffaee7c7, 0xbfc90f0db4ea5780,
    0x400279bf1313b866, 0x3ff14b454b7c2bf8,
    0xbfedacbf4a1fa7ca, 0x4015398b7d45396c,
    0xc00228b9c9e19b12, 0xbfdfefff05fb0eb6,
    0xbffa67b8df715692, 0xbfa72ca34ee1a45c,
    0x4011366a03400771, 0x4008aa09979a35e4,
    0xc000262f5ea147d1, 0xc00f13e97ec767ee,
    0xbff9e1a8c2595672, 0x3fff98c86a9bba2b,
    0xbff57293fd9fe992, 0x3ff82a1ca3551734,
    0xbfe0392c1cdfb202, 0xc01562915231c797,
    0x401369e132b311e8, 0x3fc999a5f2b64d3c,
    0xc0039b47c41b4264, 0xbfed8282cc9695ce,
    0xbfb28c24c6aa7dd4, 0x3fedac5022e75ac8,
    0x400233812847934b, 0xbff57f839b84bb9a,
    0x4000dbb9b6979186, 0x3ffd6e40244957d3,
    0x40065e750bba813c, 0xbfdcd55c74a2e7cf,
    0x3fe5ca6c4852de10, 0x3fe4ef664d5d06f2,
    0x3fe721c51607411a, 0xc00442db2330ce83,
    0xbfe0ddecfdf292d8, 0xc003eba5ff8537ab,
    0x40189c3a6f38d874, 0xbfe8dcef0db7b460,
    0x4008f9bc1bcb3fe0, 0x3ffb94d7c3dcbd18,
    0xc000ee17ba50e8ec, 0x3f9db3c01d52e420,
    0x3ff090a8b20c7eb6, 0xbfb0aab43efb6e7c,
    0x3fe1aa5e8ee490a4, 0x400ed791f84eec92,
    0xc0079db1fca3e092, 0xbff5e26d9f5f9ef9,
    0x3ff44b7a764c3f3c, 0xc0128c7407bf4f2a,
    0xc0039f8336e79613, 0xbfff49ea600e46e4,
    0xbfe734590e568683, 0xbfa9b7f767e80f90,
    0xbff4c05590fec0fb, 0x3fd11d7e9df765fc,
    0xbff0737a00a6a794, 0x3ff2b258fe0cfe91,
    0x4007c52257452d75, 0xc00edd8f4686cf1c,
    0xc00156adc8a30c08, 0x400e3eb459c73ff5,
    0xc0024992cf90918c, 0x40144dd5006c26ca,
    0xbfed99af6a5b50b2, 0xc00b09d2f3c5a4d1,
    0xbfe699ba9dc6d86e, 0xc0093972cd5bce75,
    0xc002f2331d601f94, 0xc00074e87b11b071,
    0x3fb5c468b2031ec0, 0xc002f01954f2e250,
    0xc011a330acb295bf, 0xbffc2211402e705d,
    0x3fd22c430b23c558, 0xbff88f8bb3137eac,
    0xc00b3cd4dbf4351e, 0xc00239a13a1347b4,
    0x3fff3e6d4be41622, 0x40085b8c8af82748,
    0xbfffeb214fd71b36, 0x3fca709d46c66f20,
    0x40109ceddf5faf30, 0x3fe638c66c00e868,
    0xbfdfc2e53e979654, 0xbfef92a02f8ccdfc,
    0xbff0f12380ae376a, 0x3ff794a75b730204,
    0x401626507030330e, 0x3fcc45ec154c1f52,
    0x4000f3a16ff7d9e2, 0xbfe9ff55b754cf62,
    0xbfe87f55f57b2172, 0xc002db31a6f8d3e5,
    0x3fc193d82dfd0de0, 0xc00788478e8dac6c,
    0xbff99325796eed87, 0xbfd4b34f5faaa5fb,
    0xc0011b7d836cbd31, 0xc016bb121bff6bf7,
    0xc01b52934c2a2988, 0xbfe048cc172bb2c1,
    0x401166990e4be567, 0x40065c72f397e67a,
    0xbff24387778bd44f, 0xc005aa4053bc47be,
    0x3ffffd946354054c, 0xc00a88f161694cfa,
    0x4007e490b1e12def, 0xbffd8208120ac558,
    0x3ff370e35aaf2153, 0x3fe02bf5eac367fc,
    0xc0131f1c8713a18c, 0xbfe51ba2517a647e,
    0xbfa438fccdd695e0, 0xbff99f1a757be5c3,
    0x3ff01930101e54fc, 0xc0034e907d2388a4,
    0xc00007551d1cedc9, 0x3fe1e4ed709db0df,
    0xc0136d64af90aced, 0xbfefeba281b46e60,
    0x3fe4350d4bc50140, 0xbff6b8c19065d0a6,
    0x400228b61a8e97da, 0x40068f0e4edecba1,
    0x400d9a640e9f4c08, 0x3ff3ea33d85f10c8,
    0x40160ae771c3b0c8, 0xbff4f0b1398baa90,
    0xbff5a29be7181596, 0x400b294d470bde62,
    0xc00b668c745b95de, 0x3ff00d0383e4cf48,
    0xc002afb79d838ede, 0xbfe3b938ad95f080,
    0x3feecc23b7c3556d, 0x4003a639ccad5e7b,
    0x4010cdd25cbfa64f, 0xbff83e62b8268bcd,
    0x3fa2eaf9e4dd85e0, 0xbfd34cfa5f838acc,
    0x3fb66395657388b8, 0xbfee3672a58c34b2,
    0xc0016385e92806c0, 0xc005c375026f5fbd,
    0xc001c78f9c646112, 0x4001231f741614fc,
    0x3fdaa7c5c704ce14, 0xbffd9dfbec7abd4a,
    0xbff7aec436b03335, 0xbffb7a716ac6aeab,
    0xbfdeb052b4979e34, 0xc0081e86069f14fc,
    0xc00d37190c2c847c, 0x3fea04b9c6f062f0,
    0x4005622b42e72474, 0x40072c55df7bff7b,
    0xbff28da735dd6375, 0xc00625091ba53d62,
    0x401384651851050e, 0x3fe50c5727af09eb,
    0x40027a779664190c, 0x4000a610d362d5f3,
    0x400986a2ca113ef4, 0xc0033e3169bceab8,
    0xc011207c539ba020, 0xbff3cc405cde62fe,
    0xbff341efd043fb3a, 0x3fd653522e2496a0,
    0xbfed0bd8fdf385e6, 0xbfe934aaea87ecf9,
    0xbfed6d2be7138262, 0xc005ae9075c48b53,
    0xc004f3019c82da25, 0x401108e3667aeeb3,
    0xbffb9bcbfb565529, 0xbff64a4bd12bd898,
    0xbff7c9ce5aa4749d, 0x3fef5714d4c88e38,
    0x400045a952c6637d, 0xc00571e29ccc9972,
    0x3fd443a99e611424, 0x4012af84cd093326,
    0xbfc248d2c586c870, 0x3ff3c326c2347f3e,
    0xc00acee1557870cc, 0xbff605e2f26b5870,
    0x4004f74c9ba364d7, 0xbfec9595649f5efc,
    0x3f7b287b363ea200, 0xbff077e8ccbfad20,
    0xc00ab638541a6755, 0xbff5309bd768a702,
    0x3fc33d712465ccdc, 0x3ffe50ede2fb82fb,
    0x3fe409a17529a6e6, 0xc00234b5389828fa,
    0x40010842eb853ac9, 0x4004d7d3ed120353,
    0xbfe7668c3224d56f, 0x3ffade23a106d110,
    0xbff91e4130ed4e48, 0xc0017c11a8e52c4a,
    0x3fe778d1a2efae9a, 0xc003b567d3f2e346,
    0xc00e3b7b8ec5e946, 0xbfde70f1407e60ac,
    0xbff5f75c399cbce8, 0x3fc786e5a4622708,
    0xbfe95e8517e7eb6d, 0xbfe690438fc7fa02,
    0xbfd00ac144659934, 0x3fe5be7513044ed9,
    0xc00dc42e3be4803d, 0x3fddbaddaa13ad40,
    0x3fa16ffed7e30370, 0xc00426e5dfc6244a,
    0x400e7829f2258b91, 0xc01028d6a1d3a984,
    0x3fe5818239784930, 0x3fd384da675a7698,
    0xc001b02d5fd84c09, 0xbfde15980e684862,
    0x3fef30f84da2cd6d, 0xc001af6ee8a6fcbb,
    0xc018521fd133791a, 0x401014de2c47b194,
    0xc001870a1e8951b7, 0x3fd25b167711d98c,
    0xbfe0df9ce9aeb2dc, 0xbfff0bd40cb25ad7,
    0xbfee6826de7da3bd, 0xbfb025dffb3d0e90,
    0x4012b024c2a270c2, 0xbff536f031f732ef,
    0xbfc49fcb6c758800, 0x3ffa84c6150e27a8,
    0x3fbf271b4e5798c0, 0x3ffae0a6b014288e,
    0xbfcc7df549332504, 0xbfe4da80701597b8,
    0xbff928415b8d4070, 0x40023e5c501b6264,
    0x3fe2f6042f6eef86, 0x3ff8862182043f2c,
    0x3fec3ca4fec1e5f0, 0xc0115c1e5385f1e8,
    0xc002a9cc37996828, 0xbfd07c7c64c44a50,
    0x3febabf3b18f012c, 0x3ff7df77a3e7fd21,
    0x3fe07d9020dd908c, 0xbf80ba3423210100,
    0xc0032b57ef2810a7, 0xbfc5a714f2a965ae,
    0x400a6c81b232e68f, 0xbff82a351c51f603,
    0xbfc1b962bb2a8544, 0x3fef1f8c7001efab,
    0xc00b4227b003ca22, 0xbfe3f5146e1b82ee,
    0x4006f2a8efced862, 0xc004e1b32b9743cb,
    0x4012d7ea92e4b154, 0xbffc63c8b91b7e57,
    0x400809cd4c5d7733, 0xbff88ebf753c42df,
    0x3ff07fe94c50e5f0, 0xbfe9175e771b99d8,
    0xc0021c7c15679876, 0xbff16d0d4bc1c6ba,
    0xbffb1821ec4d047c, 0x4000749bcd3a2d80,
    0xbff737afe107f4cf, 0xc009daf0775320ec,
    0xc007f8ea2dbfca0d, 0x4012c4180d400f27,
    0x3ff57193ad2e37d8, 0xbffd80354636e485,
    0xbfefb90f7d624c30, 0xbfe44425c7ea98c0,
    0xbf84cb78d93e7380, 0xbfdc84de3b94527c,
    0x400845f9fd556bc8, 0x3fee2e8b88cbfb01,
    0x400958242d4996e5, 0xbfe3b83a809c59ed,
    0xbff190c2be4a71c1, 0xbfeea1a2a609874e,
    0xc00557ef76a26dec, 0x400e7ce78d9fe955,
    0x40014a2382ef4bf8, 0x4000374d2f480752,
    0xbff29e63df104a50, 0xbfed32d70b612abb,
    0x40123f695f4f30d6, 0x400b87e8a5913985,
    0xbfce60534b0a4834, 0xbfe870a869b85e38,
    0x3fffffe62b62c11d, 0x3ff395f631e588a6,
    0x3ff9708549126b3e, 0xbfbb39ab2f1788d8,
    0x3fe27f0a283831e0, 0xbfd818bfab35daf4,
    0x3feefe6a77742b43, 0xc00ce2a166e27a54,
    0xbfe3a356961dd8ce, 0xc000c28d0792f1b5,
    0x400c4b66681046fe, 0x400b33bb41877ed5,
    0x4008d0cf96d7c0f5, 0xbffd7ae45526ffde,
    0x3ff0d794105ace76, 0x4001a83256a238d6,
    0x40091775926f5462, 0x3ff76e9092a55b8c,
    0x40124a0b5df3b8d8, 0xbfef52e67a7bea42,
    0xbfe8a5d4717c1d20, 0xc00e18ef38f21e0d,
    0xc012123ac9e46ec2, 0xbfe70bc223264419,
    0x3fe43384d6d7041c, 0x40112b7be63434e7,
    0x3fc60b5c1a867848, 0x400010cdf9af31de,
    0xbfe2c4bc52a79fec, 0xbff2297ea0979e84,
    0xbffb82b506dea399, 0xc00486fba854e97f,
    0xc002da6c066e8c34, 0x3ff13c36dafe3e97,
    0x3fcf32a1a1af5924, 0x4001c27780d46105,
    0x3ff8ab0e0d91f3ac, 0x40106c32ce0c0b49,
    0xc0057a96a8e31ec4, 0x401a95f3011787e8,
    0x3ff8749a72d8bd85, 0xc0145e664a17322a,
    0xc008f2e4ec8ce1be, 0xc00b40bf3f6b2b68,
    0xc006765f0d462fd2, 0x400c443013f32e24,
    0x400305176a8e8a4a, 0x400d591849c3167c,
    0xc00e30d159a3bf66, 0xbff3c5cb51535610,
    0xbff7465927f57776, 0xc00f7adf88b967ba,
    0xbffd3f13230e5f41, 0xbfe70239541fa5e2,
    0xbfdd7e4f1e8a6cd8, 0x3ff8a08250b65c64,
    0xc0021bfb5c15d63a, 0x4000f6f7f3671c0a,
    0xbfd246b887dbcc2c, 0x3feaec18bf9d968b,
    0x4014f052ced95b6e, 0x400320f12e6e6252,
    0xc003bd582aac168a, 0xc005254e457d3554,
    0xc0031fca2c61cf84, 0x3ff0e696de8e230c,
    0x4000889358fe6224, 0x4008845deadfc1b0,
    0x401307efd1a1fb26, 0x3ffffcd5841e79cc,
    0x400e0dd48adddafe, 0xbffa40213df2a124,
    0x40099e5bd4243d2c, 0xc00aafe3b1187f83,
    0xbfe424d00bcf8930, 0x40058cc093250f10,
    0x40116af2458b780a, 0xbfef2b9c4141d6fd,
    0xbfd6f0bcc062f9bc, 0x4000ea59bb7e838a,
    0x4003c6da1e2c3cc3, 0x400e42a242c587e5,
    0xc0077162e3a8a091, 0x40127eafdfaa5638,
    0xbfd9652e99d016a4, 0x3ff9ec14705a2871,
    0xbfd09c2258953928, 0x401050dbc5fd7a13,
    0x3fd74b4e63ab76a4, 0xc00482bcdf828b19,
    0xbfed63e7535b0b79, 0xbffea5888cf8d0ad,
    0x3ff5641440ed704a, 0xc0026c2507dcbf2d,
    0xc014bdfeaf31ec56, 0xc0037eabd73aec4e,
    0xc0001a852f8dfe05, 0xbfe9fca33803de5f,
    0xc00059c396389153, 0x3feebadfe450d6b4,
    0xc0121ff3b98f190d, 0x3fc8c53a07d99a4c,
    0xbfeaff3fc5cf8db2, 0x4006c43bed7d4666,
    0xbfc2aa7a1f214790, 0x3ff1715351f6f74e,
    0xc0026c99aede8fa2, 0x4001783ac0c5f4b8,
    0xbffb60244d18e284, 0xc0098e5e81e8fac2,
    0x3feae9a6be6c2771, 0xc0009ea392c94908,
    0x4006c8552eaaab1c, 0x3fdf889b5ce69b41,
    0x40005021120036a1, 0xbfe1969ff2e67fe6,
    0x3ff9c2963bc1e24a, 0x3fdc43acb03199fc,
    0xbfedd366657ff898, 0x3fffeb5d31fa991e,
    0xbfda2a6d3c5a9598, 0xbff3772107aa368a,
    0xbfeefea7c4bc58f6, 0x400041b37070b7c5,
    0xbff22c965a3f9a01, 0xbffb24c3fc2396a8,
    0x3ffe91ab47dbac1e, 0x3ff3bf927c10bab9,
    0x40172967e3697102, 0xbfdca130ac65a972,
    0xc003d0f6b5e0a2e6, 0xc000037c339fd621,
    0xbff6ee892037eb02, 0xbff146ae9535b3e2,
    0x3ffdf1f6df06c9ad, 0x3fd2bd45f5fe1c71,
    0xc00843ded63269da, 0x400cb248cfe78f54,
    0xbffa252ec08346a5, 0xbfcfb63716cec8d0,
    0x400a7cbdb96c247a, 0xbff8cc6950ab8106,
    0x400c2abb115405e8, 0x40160cfaff8c05e1,
    0xc0048356c99334b9, 0x3ff89e776e95f2a2,
    0xbfb43fb7a2d060f4, 0x401060a732c528f1,
    0x40035d6cd41e3880, 0x3ffc0e47a2d944c8,
    0x3ff8b6d7ae57de96, 0xbfe1cc0384e04608,
    0xc0006550f714c1ef, 0xc003445f1af7f12b,
    0x3fe2c8deaa778642, 0x3fd404f46d4cf3e8,
    0x3fd334cbf2b512fe, 0xbff729d1c38d07b2,
    0xc00716e27dd31438, 0x3ff330a6a2c44182,
    0x3ff5b68e6f06e67a, 0x3fc2e401ab365018,
    0xc00c55f946320948, 0x3ff3f46f80f77bec,
    0x4003719cdd565f5c, 0xc002904c4dd2ee20,
    0xbfc8f44bc113ce84, 0xbff52c0a21c48b3c,
    0xc008388f9e90668c, 0x40063af1088b44c9,
    0x40146bcc3ac1bc12, 0x3fd4aacb696338f8,
    0xbfb4ce1b6169cfd0, 0x400b4fd44cacf7b9,
    0xbfe33fdd500dc46a, 0xbfcaf3f11be69da2,
    0x40012b190fccbf77, 0xc0103df2ca0d365e,
    0xbfbf7ad9e3fdbc70, 0x3fe5934ac29988ba,
    0x3ffba77275f00342, 0xbfe0e6d40165b972,
    0xbfbb40345cade1e0, 0x400285ae67bd001b,
    0xbfe9d46d2373e945, 0xbfa6ee04c472ce80,
    0xbff7818743d89177, 0xbfe801be4236495a,
    0x400c0b5a8636ce22, 0xbff5c11d4e1081e5,
    0x3fe773631cd60bab, 0x3fcd679afe241de0,
    0xbfc74c5f8a811727, 0xbfff61341f4bdaa9,
    0xbfeea5a1f89055c6, 0xbff53ea1f7bf9df4,
    0xbfd5e7a01a9324dc, 0xbffee57a05d96f2b,
    0x3ffae03a9c6bbbe0, 0xbff62516062bc42e,
    0x3fe3d8c69c943b28, 0x4007fa1974b1b3fe,
    0xc009ae6eb66f6736, 0x3feacd7210f618a0,
    0x3ff9041aff41e578, 0xbff5028edffcb8fe,
    0xbff4f6a6be1a5915, 0x40105b466f8932f7,
    0x4008973707590ff4, 0xbfe02ea11d6f462e,
    0x3fef07abdef22ae1, 0xbff8883c954883e6,
    0x3fea1f833ec5be94, 0xbfc217bc2da09058,
    0xc00ce314079aa5dd, 0xbfe2c2c394c75284,
    0x3ffdacc92fe6f1e1, 0x4002b9c6f42f81c6,
    0xc00bb92db9a5eca2, 0x401947296b1ff73a,
    0x3ff22e6e0965ce4e, 0x40007b242fb2ffda,
    0xbff0ba13da78bd39, 0x400e3df55c3bba30,
    0x3fd14dbed74e6794, 0x3ffa6b4d88060268,
    0x3fd234bb20c0c8f4, 0x4002b06ec1188d0c,
    0xc005a42e069a7241, 0xbfe96f14308b21dc,
    0x3feae8d525b77927, 0xc0079fb8c8ecf6f2,
    0xc00fd03ee8ab9a44, 0xbff192c976750ec7,
    0x3ffc74407bad6a0d, 0x400ad57cdff0d367,
    0x3fdcc51eb3766ddc, 0xbfe64ca8a9c94924,
    0x3fe675589db08958, 0x3ff537897c04879a,
    0x3fe72628b0d7bd2a, 0xbffe00fd964fd7dc,
    0xc0025b476ec324b3, 0x3fe6ffcf44948909,
    0xc002086e2818eb1c, 0xbfec5bf23b1f394e,
    0xbffdbc611d107c16, 0x3ff052dabfad0d0c,
    0x4004927f660b82ca, 0x400430244bddcd86,
    0xbfa44e9135dd8470, 0xbfc066c556b20c2c,
    0xbff0b9db1e13f298, 0x3fdc258a71c0d22d,
    0x3ff0a12fe8882148, 0xc002886b13ef9b54,
    0x3fee565c41581e13, 0x40008c0e7d66609a,
    0xbfea16d0e43adb3a, 0x3fd4354f3d1449fc,
    0xc0025f165b35bc7a, 0xc005eeea575d8576,
    0x3ff5779a77f5267b, 0xc0051a5c57e0d35a,
    0x401333c231460930, 0xc00875c1c6076045,
    0x3ff708b69ad3589c, 0xbfffacdfd90a053d,
    0xbfc1a84058aa4742, 0x3ff77577019fd9ae,
    0xc00874a34d184ba4, 0x3feae4e06944a787,
    0xbfc4ff8e31ccebd0, 0x40012418fd738bf8,
    0x4004c724c899fb5f, 0x4010f0537291d8af,
    0x3fb1f9a829c2a180, 0x3fffc0fb5776d904,
    0x3fe07c5851f88cf4, 0xbfc19b0fa493614e,
    0x3ffa6dd59f15d4dd, 0xc0187e76819bf17a,
    0x3ffdbeb9f7d25e3c, 0xbfd9d362a3d80dd8,
    0xbfeadad75da286bf, 0xbffcc8bee2a0f4b3,
    0x3fd70b16ec3fbf50, 0xbff824e4f8aa0d1b,
    0x400142cf34a34902, 0xbfed2d103cc25c46,
    0xc00db29ba1eb1527, 0xbfe4f3338db950ba,
    0xc0057b616ce6132f, 0xc009fdde5c1c8236,
    0xc0053303fd3f09fa, 0x3fd9b0037e655724,
    0xbfeea55f6079b426, 0xbff605b201f002bc,
    0x3fe6416ffa84ff2d, 0xc0144271e1832bab,
    0xc00786989b2e7b9a, 0x3ff515871cdbb7a7,
    0x3ff03ca89610e334, 0x3fdc0a5f6d815abc,
    0x40085bb07d074562, 0x0,
    0x3ff03ca89610e332, 0xbfdc0a5f6d815ab8,
    0xc00786989b2e7b98, 0xbff515871cdbb7b6,
    0x3fe6416ffa84ff13, 0x40144271e1832bac,
    0xbfeea55f6079b438, 0x3ff605b201f002b8,
    0xc0053303fd3f09f6, 0xbfd9b0037e65573c,
    0xc0057b616ce61331, 0x4009fdde5c1c8232,
    0xc00db29ba1eb152b, 0x3fe4f3338db950a2,
    0x400142cf34a34903, 0x3fed2d103cc25c40,
    0x3fd70b16ec3fbf40, 0x3ff824e4f8aa0d20,
    0xbfeadad75da286cf, 0x3ffcc8bee2a0f4b8,
    0x3ffdbeb9f7d25e45, 0x3fd9d362a3d80de0,
    0x3ffa6dd59f15d4d9, 0x40187e76819bf179,
    0x3fe07c5851f88ce7, 0x3fc19b0fa4936156,
    0x3fb1f9a829c2a180, 0xbfffc0fb5776d908,
    0x4004c724c899fb64, 0xc010f0537291d8b1,
    0xbfc4ff8e31ccebc8, 0xc0012418fd738bfa,
    0xc00874a34d184ba3, 0xbfeae4e06944a793,
    0xbfc1a84058aa472e, 0xbff77577019fd9ae,
    0x3ff708b69ad3589c, 0x3fffacdfd90a0538,
    0x401333c231460930, 0x400875c1c6076049,
    0x3ff5779a77f52674, 0x40051a5c57e0d35c,
    0xc0025f165b35bc7c, 0x4005eeea575d8574,
    0xbfea16d0e43adb3a, 0xbfd4354f3d1449f4,
    0x3fee565c41581e1c, 0xc0008c0e7d66609a,
    0x3ff0a12fe8882147, 0x4002886b13ef9b57,
    0xbff0b9db1e13f298, 0xbfdc258a71c0d226,
    0xbfa44e9135dd84b0, 0x3fc066c556b20c14,
    0x4004927f660b82cc, 0xc00430244bddcd85,
    0xbffdbc611d107c10, 0xbff052dabfad0d13,
    0xc002086e2818eb1c, 0x3fec5bf23b1f3938,
    0xc0025b476ec324b2, 0xbfe6ffcf44948914,
    0x3fe72628b0d7bd28, 0x3ffe00fd964fd7da,
    0x3fe675589db0895e, 0xbff537897c048798,
    0x3fdcc51eb3766dec, 0x3fe64ca8a9c94924,
    0x3ffc74407bad6a14, 0xc00ad57cdff0d364,
    0xc00fd03ee8ab9a48, 0x3ff192c976750ebc,
    0x3feae8d525b77927, 0x40079fb8c8ecf6f4,
    0xc005a42e069a7240, 0x3fe96f14308b21d6,
    0x3fd234bb20c0c904, 0xc002b06ec1188d0c,
    0x3fd14dbed74e6794, 0xbffa6b4d8806026c,
    0xbff0ba13da78bd34, 0xc00e3df55c3bba30,
    0x3ff22e6e0965ce59, 0xc0007b242fb2ffda,
    0xc00bb92db9a5ec9c, 0xc01947296b1ff73a,
    0x3ffdacc92fe6f1ea, 0xc002b9c6f42f81c2,
    0xc00ce314079aa5dd, 0x3fe2c2c394c7526b,
    0x3fea1f833ec5be94, 0x3fc217bc2da0905e,
    0x3fef07abdef22ad7, 0x3ff8883c954883ee,
    0x4008973707590ff6, 0x3fe02ea11d6f4634,
    0xbff4f6a6be1a590e, 0xc0105b466f8932f9,
    0x3ff9041aff41e57a, 0x3ff5028edffcb8fc,
    0xc009ae6eb66f6734, 0xbfeacd7210f618a8,
    0x3fe3d8c69c943b2c, 0xc007fa1974b1b400,
    0x3ffae03a9c6bbbe5, 0x3ff62516062bc42e,
    0xbfd5e7a01a9324e4, 0x3ffee57a05d96f29,
    0xbfeea5a1f89055c7, 0x3ff53ea1f7bf9df4,
    0xbfc74c5f8a811740, 0x3fff61341f4bdaa6,
    0x3fe773631cd60bac, 0xbfcd679afe241dea,
    0x400c0b5a8636ce23, 0x3ff5c11d4e1081f2,
    0xbff7818743d89170, 0x3fe801be42364953,
    0xbfe9d46d2373e942, 0x3fa6ee04c472ce40,
    0xbfbb40345cade168, 0xc00285ae67bd0019,
    0x3ffba77275f00342, 0x3fe0e6d40165b978,
    0xbfbf7ad9e3fdbc60, 0xbfe5934ac29988c3,
    0x40012b190fccbf73, 0x40103df2ca0d365e,
    0xbfe33fdd500dc475, 0x3fcaf3f11be69dc4,
    0xbfb4ce1b6169cf70, 0xc00b4fd44cacf7b8,
    0x40146bcc3ac1bc12, 0xbfd4aacb696338d4,
    0xc008388f9e906688, 0xc0063af1088b44c9,
    0xbfc8f44bc113ce94, 0x3ff52c0a21c48b3e,
    0x4003719cdd565f5a, 0x4002904c4dd2ee21,
    0xc00c55f94632094a, 0xbff3f46f80f77be6,
    0x3ff5b68e6f06e67b, 0xbfc2e401ab364fe8,
    0xc00716e27dd31437, 0xbff330a6a2c44188,
    0x3fd334cbf2b512d1, 0x3ff729d1c38d07b2,
    0x3fe2c8deaa778642, 0xbfd404f46d4cf3e8,
    0xc0006550f714c1ef, 0x4003445f1af7f128,
    0x3ff8b6d7ae57de92, 0x3fe1cc0384e0460c,
    0x40035d6cd41e3883, 0xbffc0e47a2d944c1,
    0xbfb43fb7a2d060b8, 0xc01060a732c528f2,
    0xc0048356c99334b8, 0xbff89e776e95f2aa,
    0x400c2abb115405f0, 0xc0160cfaff8c05e0,
    0x400a7cbdb96c247b, 0x3ff8cc6950ab8110,
    0xbffa252ec08346aa, 0x3fcfb63716cec898,
    0xc00843ded63269d5, 0xc00cb248cfe78f56,
    0x3ffdf1f6df06c9a8, 0xbfd2bd45f5fe1c61,
    0xbff6ee892037eb0d, 0x3ff146ae9535b3e2,
    0xc003d0f6b5e0a2e2, 0x4000037c339fd623,
    0x40172967e3697102, 0x3fdca130ac65a9a4,
    0x3ffe91ab47dbac29, 0xbff3bf927c10baad,
    0xbff22c965a3f99ff, 0x3ffb24c3fc2396a5,
    0xbfeefea7c4bc58ea, 0xc00041b37070b7c4,
    0xbfda2a6d3c5a959c, 0x3ff3772107aa3689,
    0xbfedd366657ff895, 0xbfffeb5d31fa991e,
    0x3ff9c2963bc1e249, 0xbfdc43acb03199f0,
    0x400050211200369f, 0x3fe1969ff2e67ffd,
    0x4006c8552eaaab1c, 0xbfdf889b5ce69b38,
    0x3feae9a6be6c2777, 0x40009ea392c94908,
    0xbffb60244d18e28c, 0x40098e5e81e8fac1,
    0xc0026c99aede8fa4, 0xc001783ac0c5f4b7,
    0xbfc2aa7a1f214758, 0xbff1715351f6f74d,
    0xbfeaff3fc5cf8da6, 0xc006c43bed7d4663,
    0xc0121ff3b98f190e, 0xbfc8c53a07d99a98,
    0xc00059c396389154, 0xbfeebadfe450d6c4,
    0xc0001a852f8dfe06, 0x3fe9fca33803de52,
    0xc014bdfeaf31ec5a, 0x40037eabd73aec49,
    0x3ff5641440ed704c, 0x40026c2507dcbf32,
    0xbfed63e7535b0b74, 0x3ffea5888cf8d0ad,
    0x3fd74b4e63ab769c, 0x400482bcdf828b17,
    0xbfd09c2258953900, 0xc01050dbc5fd7a15,
    0xbfd9652e99d01694, 0xbff9ec14705a287e,
    0xc0077162e3a8a08b, 0xc0127eafdfaa5639,
    0x4003c6da1e2c3cc4, 0xc00e42a242c587e2,
    0xbfd6f0bcc062f9a6, 0xc000ea59bb7e8389,
    0x40116af2458b780a, 0x3fef2b9c4141d71c,
    0xbfe424d00bcf8915, 0xc0058cc093250f13,
    0x40099e5bd4243d2b, 0x400aafe3b1187f88,
    0x400e0dd48adddafc, 0x3ffa40213df2a136,
    0x401307efd1a1fb26, 0xbffffcd5841e79ba,
    0x4000889358fe6226, 0xc008845deadfc1b0,
    0xc0031fca2c61cf84, 0xbff0e696de8e230d,
    0xc003bd582aac1689, 0x4005254e457d3550,
    0x4014f052ced95b6e, 0xc00320f12e6e624c,
    0xbfd246b887dbcc0d, 0xbfeaec18bf9d9699,
    0xc0021bfb5c15d638, 0xc000f6f7f3671c0f,
    0xbfdd7e4f1e8a6cbc, 0xbff8a08250b65c58,
    0xbffd3f13230e5f48, 0x3fe70239541fa5e1,
    0xbff7465927f5777c, 0x400f7adf88b967b6,
    0xc00e30d159a3bf65, 0x3ff3c5cb51535607,
    0x400305176a8e8a4f, 0xc00d591849c3167c,
    0xc006765f0d462fce, 0xc00c443013f32e27,
    0xc008f2e4ec8ce1c2, 0x400b40bf3f6b2b64,
    0x3ff8749a72d8bd78, 0x40145e664a173229,
    0xc0057a96a8e31ebc, 0xc01a95f3011787ea,
    0x3ff8ab0e0d91f3af, 0xc0106c32ce0c0b46,
    0x3fcf32a1a1af5950, 0xc001c27780d46104,
    0xc002da6c066e8c33, 0xbff13c36dafe3e97,
    0xbffb82b506dea39d, 0x400486fba854e981,
    0xbfe2c4bc52a79ffc, 0x3ff2297ea0979e80,
    0x3fc60b5c1a867860, 0xc00010cdf9af31e0,
    0x3fe43384d6d7042a, 0xc0112b7be63434e4,
    0xc012123ac9e46ec4, 0x3fe70bc2232643f2,
    0xbfe8a5d4717c1d2c, 0x400e18ef38f21e08,
    0x40124a0b5df3b8d6, 0x3fef52e67a7bea54,
    0x40091775926f5466, 0xbff76e9092a55b90,
    0x3ff0d794105ace7b, 0xc001a83256a238d4,
    0x4008d0cf96d7c0f3, 0x3ffd7ae45526ffe4,
    0x400c4b6668104702, 0xc00b33bb41877ed4,
    0xbfe3a356961dd8cd, 0x4000c28d0792f1b4,
    0x3feefe6a77742b28, 0x400ce2a166e27a53,
    0x3fe27f0a283831d8, 0x3fd818bfab35db08,
    0x3ff9708549126b3d, 0x3fbb39ab2f178950,
    0x3fffffe62b62c122, 0xbff395f631e588a0,
    0xbfce60534b0a4852, 0x3fe870a869b85e38,
    0x40123f695f4f30d6, 0xc00b87e8a5913980,
    0xbff29e63df104a54, 0x3fed32d70b612ab6,
    0x40014a2382ef4bfb, 0xc000374d2f48074d,
    0xc00557ef76a26de6, 0xc00e7ce78d9fe956,
    0xbff190c2be4a71c0, 0x3feea1a2a609874c,
    0x400958242d4996e4, 0x3fe3b83a809c59fd,
    0x400845f9fd556bc6, 0xbfee2e8b88cbfafc,
    0xbf84cb78d93e7600, 0x3fdc84de3b945274,
    0xbfefb90f7d624c3a, 0x3fe44425c7ea98c0,
    0x3ff57193ad2e37d2, 0x3ffd80354636e47c,
    0xc007f8ea2dbfca0c, 0xc012c4180d400f2b,
    0xbff737afe107f4da, 0x4009daf0775320ee,
    0xbffb1821ec4d047c, 0xc000749bcd3a2d80,
    0xc0021c7c1567987a, 0x3ff16d0d4bc1c6af,
    0x3ff07fe94c50e5ee, 0x3fe9175e771b99e0,
    0x400809cd4c5d7732, 0x3ff88ebf753c42e4,
    0x4012d7ea92e4b154, 0x3ffc63c8b91b7e6e,
    0x4006f2a8efced85d, 0x4004e1b32b9743d0,
    0xc00b4227b003ca22, 0x3fe3f5146e1b82d9,
    0xbfc1b962bb2a854e, 0xbfef1f8c7001efb6,
    0x400a6c81b232e68a, 0x3ff82a351c51f60e,
    0xc0032b57ef2810a6, 0x3fc5a714f2a9658a,
    0x3fe07d9020dd9094, 0x3f80ba342320ff00,
    0x3febabf3b18f012f, 0xbff7df77a3e7fd24,
    0xc002a9cc37996828, 0x3fd07c7c64c44a30,
    0x3fec3ca4fec1e5e4, 0x40115c1e5385f1ea,
    0x3fe2f6042f6eef9a, 0xbff8862182043f26,
    0xbff928415b8d406f, 0xc0023e5c501b6266,
    0xbfcc7df5493324e0, 0x3fe4da80701597bc,
    0x3fbf271b4e579870, 0xbffae0a6b0142889,
    0xbfc49fcb6c7587d0, 0xbffa84c6150e27ad,
    0x4012b024c2a270c0, 0x3ff536f031f732f8,
    0xbfee6826de7da3b7, 0x3fb025dffb3d0e60,
    0xbfe0df9ce9aeb2ef, 0x3fff0bd40cb25ad6,
    0xc001870a1e8951b8, 0xbfd25b167711d99c,
    0xc018521fd133791a, 0xc01014de2c47b198,
    0x3fef30f84da2cd63, 0x4001af6ee8a6fcbe,
    0xc001b02d5fd84c09, 0x3fde15980e684862,
    0x3fe581823978492e, 0xbfd384da675a7690,
    0x400e7829f2258b8e, 0x401028d6a1d3a986,
    0x3fa16ffed7e30270, 0x400426e5dfc6244e,
    0xc00dc42e3be4803d, 0xbfddbaddaa13ad7c,
    0xbfd00ac14465992b, 0xbfe5be7513044ee0,
    0xbfe95e8517e7eb76, 0x3fe690438fc7fa04,
    0xbff5f75c399cbcee, 0xbfc786e5a4622738,
    0xc00e3b7b8ec5e947, 0x3fde70f1407e6088,
    0x3fe778d1a2efae8c, 0x4003b567d3f2e348,
    0xbff91e4130ed4e4d, 0x40017c11a8e52c46,
    0xbfe7668c3224d562, 0xbffade23a106d114,
    0x40010842eb853aca, 0xc004d7d3ed120352,
    0x3fe409a17529a6de, 0x400234b5389828fc,
    0x3fc33d712465cd20, 0xbffe50ede2fb82f9,
    0xc00ab638541a6752, 0x3ff5309bd768a6fe,
    0x3f7b287b363ea200, 0x3ff077e8ccbfad1d,
    0x4004f74c9ba364d7, 0x3fec9595649f5f06,
    0xc00acee1557870cc, 0x3ff605e2f26b5868,
    0xbfc248d2c586c858, 0xbff3c326c2347f40,
    0x3fd443a99e61145c, 0xc012af84cd093326,
    0x400045a952c6637c, 0x400571e29ccc9974,
    0xbff7c9ce5aa47498, 0xbfef5714d4c88e4e,
    0xbffb9bcbfb56552b, 0x3ff64a4bd12bd88e,
    0xc004f3019c82da1e, 0xc01108e3667aeeb5,
    0xbfed6d2be7138262, 0x4005ae9075c48b52,
    0xbfed0bd8fdf385df, 0x3fe934aaea87ecf8,
    0xbff341efd043fb3d, 0xbfd653522e249694,
    0xc011207c539ba020, 0x3ff3cc405cde62f9,
    0x400986a2ca113ef4, 0x40033e3169bceab9,
    0x40027a7796641911, 0xc000a610d362d5ec,
    0x401384651851050c, 0xbfe50c5727af09d8,
    0xbff28da735dd637c, 0x400625091ba53d62,
    0x4005622b42e72474, 0xc0072c55df7bff7a,
    0xc00d37190c2c847a, 0xbfea04b9c6f06300,
    0xbfdeb052b4979e58, 0x40081e86069f14fb,
    0xbff7aec436b03338, 0x3ffb7a716ac6aea8,
    0x3fdaa7c5c704ce0c, 0x3ffd9dfbec7abd47,
    0xc001c78f9c646110, 0xc001231f741614fe,
    0xc0016385e92806c0, 0x4005c375026f5fba,
    0x3fb66395657388f4, 0x3fee3672a58c34a9,
    0x3fa2eaf9e4dd8640, 0x3fd34cfa5f838ade,
    0x4010cdd25cbfa64f, 0x3ff83e62b8268bd7,
    0x3feecc23b7c35580, 0xc003a639ccad5e7a,
    0xc002afb79d838ede, 0x3fe3b938ad95f077,
    0xc00b668c745b95de, 0xbff00d0383e4cf4c,
    0xbff5a29be7181591, 0xc00b294d470bde61,
    0x40160ae771c3b0c6, 0x3ff4f0b1398baaa2,
    0x400d9a640e9f4c0c, 0xbff3ea33d85f10c4,
    0x400228b61a8e97dc, 0xc0068f0e4edecba0,
    0x3fe4350d4bc50140, 0x3ff6b8c19065d0a2,
    0xc0136d64af90acec, 0x3fefeba281b46e3e,
    0xc00007551d1cedc5, 0xbfe1e4ed709db0e9,
    0x3ff01930101e54f8, 0x40034e907d2388a1,
    0xbfa438fccdd69680, 0x3ff99f1a757be5c4,
    0xc0131f1c8713a18c, 0x3fe51ba2517a6460,
    0x3ff370e35aaf2151, 0xbfe02bf5eac367ee,
    0x4007e490b1e12df0, 0x3ffd8208120ac560,
    0x3ffffd946354054b, 0x400a88f161694cfc,
    0xbff24387778bd457, 0x4005aa4053bc47bb,
    0x401166990e4be568, 0xc0065c72f397e673,
    0xc01b52934c2a2988, 0x3fe048cc172bb2a8,
    0xc0011b7d836cbd39, 0x4016bb121bff6bf8,
    0xbff99325796eed86, 0x3fd4b34f5faaa5c9,
    0x3fc193d82dfd0da8, 0x400788478e8dac6b,
    0xbfe87f55f57b2176, 0x4002db31a6f8d3e4,
    0x4000f3a16ff7d9e2, 0x3fe9ff55b754cf68,
    0x401626507030330e, 0xbfcc45ec154c1ee8,
    0xbff0f12380ae3772, 0xbff794a75b730207,
    0xbfdfc2e53e97965b, 0x3fef92a02f8ccdf2,
    0x40109ceddf5faf31, 0xbfe638c66c00e84e,
    0xbfffeb214fd71b36, 0xbfca709d46c66f50,
    0x3fff3e6d4be41627, 0xc0085b8c8af82747,
    0xc00b3cd4dbf43522, 0x400239a13a1347b2,
    0x3fd22c430b23c560, 0x3ff88f8bb3137ead,
    0xc011a330acb295be, 0x3ffc2211402e7052,
    0x3fb5c468b2031dc0, 0x4002f01954f2e250,
    0xc002f2331d601f96, 0x400074e87b11b070,
    0xbfe699ba9dc6d87e, 0x40093972cd5bce71,
    0xbfed99af6a5b50ae, 0x400b09d2f3c5a4cf,
    0xc0024992cf909186, 0xc0144dd5006c26cc,
    0xc00156adc8a30c06, 0xc00e3eb459c73ff5,
    0x4007c52257452d73, 0x400edd8f4686cf20,
    0xbff0737a00a6a78a, 0xbff2b258fe0cfe94,
    0xbff4c05590fec0f9, 0xbfd11d7e9df76620,
    0xbfe734590e568687, 0x3fa9b7f767e80e50,
    0xc0039f8336e79610, 0x3fff49ea600e46da,
    0x3ff44b7a764c3f32, 0x40128c7407bf4f2a,
    0xc0079db1fca3e094, 0x3ff5e26d9f5f9ef1,
    0x3fe1aa5e8ee490a8, 0xc00ed791f84eec94,
    0x3ff090a8b20c7eb5, 0x3fb0aab43efb6e34,
    0xc000ee17ba50e8eb, 0xbf9db3c01d52e500,
    0x4008f9bc1bcb3fe4, 0xbffb94d7c3dcbd14,
    0x40189c3a6f38d874, 0x3fe8dcef0db7b478,
    0xbfe0ddecfdf292ec, 0x4003eba5ff8537ac,
    0x3fe721c516074114, 0x400442db2330ce85,
    0x3fe5ca6c4852de17, 0xbfe4ef664d5d06e7,
    0x40065e750bba813e, 0x3fdcd55c74a2e7df,
    0x4000dbb9b6979188, 0xbffd6e40244957cc,
    0x400233812847934a, 0x3ff57f839b84bba0,
    0xbfb28c24c6aa7d90, 0xbfedac5022e75aca,
    0xc0039b47c41b4262, 0x3fed8282cc9695c8,
    0x401369e132b311e7, 0xbfc999a5f2b64cce,
    0xbfe0392c1cdfb21d, 0x401562915231c795,
    0xbff57293fd9fe992, 0xbff82a1ca3551739,
    0xbff9e1a8c259566b, 0xbfff98c86a9bba2e,
    0xc000262f5ea147d4, 0x400f13e97ec767ea,
    0x4011366a03400773, 0xc008aa09979a35e0,
    0xbffa67b8df715696, 0x3fa72ca34ee1a404,
    0xc00228b9c9e19b15, 0x3fdfefff05fb0e9c,
    0xbfedacbf4a1fa7b2, 0xc015398b7d45396c,
    0x400279bf1313b866, 0xbff14b454b7c2bfb,
    0x3ff1fb48ffaee7c2, 0x3fc90f0db4ea5798,
    0x40068b32b4b7ebca, 0xbfe98ab6e964940a,
    0x3fd3833f929a6874, 0xbfecdf4b501516e5,
    0xbfed54c6fd82978a, 0xc003ac35eb970725,
    0xbfe7040b04710a83, 0xc015ecd0082189e6,
    0xc00f7c69f700a158, 0xc00c60845cc01568,
    0x3fea225d27dbe98c, 0x400df763a6a90d98,
    0xbffe4f50faa31f86, 0xbfd0b163499cd974,
    0xc00835fd879fa8ba, 0xc0032fc180f4f786,
    0xbfed99d8063c9bce, 0xc003bda9b5031acd,
    0x3ffdb62c951a4ab8, 0xc00e0302e367ec62,
    0x3ff900f913ffe67b, 0xbfe143a9f806eb44,
    0xbfd3c98a3d896df6, 0xbfeda7434bec4d32,
    0x3ff0a696527d0191, 0xc00f9020244e4291,
    0xc00a5810d43fc06a, 0x3feabb403744d928,
    0xbfe0593db251fc54, 0xc00adbd8973ae520,
    0xc002fc9402d47b02, 0xbfee6408f7318e5b,
    0xbff0611d3fce968c, 0x3ff7a383139ed7a7,
    0xc0115df863daceae, 0xbfe6112735d53bc8,
    0x4004a4aed094606c, 0x3fe5c75e332c7d64,
    0xc0154e70bb9ec916, 0x4004249941ba4097,
    0xbff34b76e61f1b90, 0x3ff5525093f62c38,
    0x3fec3bd75946c8c0, 0xbfed339bfc383b58,
    0xbfc4f3a08d6a42a0, 0xbffbf5b53787bfcc,
    0xbfe1dd79a5a45696, 0x3fbc1da528a8404c,
    0x4004b845ae564fb4, 0xc00c92c2b5a21b70,
    0xbfe1941aaf785c75, 0x3febc01597941714,
    0xbfda8ed457dad1fa, 0xbff6db91f501ad3d,
    0x40016dad81f71195, 0xc003cb97f7c1e91e,
    0xbfea5a8876314a93, 0x3fe8d9226d59060c,
    0xc00e8fcdd72e3fcb, 0xc008063a70be00ee,
    0x3ff01306ac028927, 0xc004b1c0c0c360fc,
    0x4008f9a1e3435708, 0xc004bfd001fd822a,
    0x3ff760997c62de56, 0xbffbf85450aa0226,
    0x3ffec030e9bf8ff4, 0xbfd0d9b7384cd44c,
    0xbfef79b393d03361, 0xbffabf91e4f6becc,
    0xbff44cbf7e327924, 0x3fee0d8db5a2ba1e,
    0xbffb110f33f77598, 0x400055977cd98d5d,
    0x4005ad713fadda04, 0x3fefd096fd21741a,
    0x400088928017d533, 0x3ff884c966c7b434,
    0xbfebdbca4e587966, 0x3ff18729b9f8e937,
    0x3fe2cda845cbbff4, 0x40033282c7b229e3,
    0x3fdf89930ee56f08, 0x4003dabe85a5733d,
    0x40052d33e4c78d29, 0x3fe2626c97113a31,
    0x3fe1075b45a83edc, 0xbff48ee9bdf4db88,
    0xbffb252b028fe59f, 0x3fee88b92323ffae,
    0xbfacbfc1818b84e0, 0xbfde0fe045ae9816,
    0xc003b5e3c7c0e57d, 0xbff0accaba8fcdb5,
    0xbfda757adffe6bb8, 0x4012940b9b1ad366,
    0xbfe9b2f7366feb84, 0xc00976f96f8881f4,
    0x3fe00e7760e3c808, 0x3f987829f10dd280,
    0xc00669a76e767794, 0xc010bf16ab24bee9,
    0x400682e2bd76c47e, 0xc003686ed5f9cba4,
    0x3fef9afdbf741dbc, 0x3ffe3534f6a3bf93,
    0xbff99cc3a5b44190, 0xbff86326d01194ed,
    0xc00692730ffcecac, 0x3ffd91a738022f30,
    0xc00183a045b087d2, 0xbffdeac3e22299dc,
    0x3ff8fea2164b84ba, 0xc00a84b5c635d019,
    0xbff665c640da237c, 0xbff4c757ee49a529,
    0xbffa1bd083056938, 0xc00e263f7906ffc5,
    0x4005ee2488eb1c85, 0xc0050e1a5a8ba010,
    0xbff1b244646cd1bf, 0xbfd605623ef7b8d5,
    0x3ff56662fe805cf2, 0x3ffd58f471c68a73,
    0xbfe1abbfd1574dae, 0x3ff3e89706076fc2,
    0x3fbece5b4853ef60, 0xbff3641d37ba565a,
    0xc007a40cd69d4d62, 0x3ffe08e1f8ca1d4a,
    0x4001a323e2ed38ef, 0xbfd680670b1daab0,
    0xbfef57df9e5dc4ef, 0xbfe5b22cb88318f8,
    0x3fd998c872137b24, 0x3fecbf6b2876bf60,
    0xc002314f53d26aad, 0xbfbf9076f2910050,
    0x3fd3d43031513e14, 0x3fe59cc945dabf17,
    0x400b582fced506f3, 0x3ff4b81b3eb465ae,
    0xbff25edc931af12c, 0xbfcb1d3d6c46f858,
    0x3ff66c65aaceb6e8, 0xbff57860aa175c18,
    0x3ff6c18b3f567aac, 0xbfe8a0e216346c9c,
    0xbfb0d97196343480, 0xbff0e92fcc59a858,
    0xc0036179200b02c6, 0xc0076f500e85cf70,
    0xc002f03291fc783e, 0x3fec6033971fa294,
    0xbfebc9891b0a8f5c, 0x3ff93bbf638f4c09,
    0x40106384bce3cfdf, 0xbff1c931f3dd314d,
    0xbfff4821ef837634, 0xbff45f428bb8b602,
    0xbff21e7722499bbe, 0x3fda57395b8ffd26,
    0xbfebd0cb888ad62e, 0xbff1a770f08a09ba,
    0x400fbeceef5cba51, 0x3fd5aa291de703d0,
    0x3ffdd1de4f387ad2, 0x3ffe6d8294dacf74,
    0x3feb29fa3db71862, 0x3fff146c1b03e5fa,
    0xbfe050541564a34a, 0xbff2c87c83bb5bb6,
    0x4012538e7282abf8, 0x3f76e570437e5e00,
    0xbfc84e8393021138, 0xc009256706da46e5,
    0xbff3a9399bc7b1b0, 0x3fb1c1ddf974e990,
    0x3ff491565515be5a, 0x3fe1f151cccfbfe0,
    0xc00bd5bd64e016aa, 0xbfe65d9fc475848a,
    0xc0067f950e6c27e2, 0xc00b668d290501c8,
    0xc008f7476e5cedf6, 0xbff959f122a4ba8c,
    0x3fd2ab0ad2b01dac, 0x3fe47e015940037a,
    0x3ffb36309d5b1040, 0xbfd5f083177d9956,
    0xbff35e0397456800, 0xc0118f831e46302d,
    0xbfc41077dc518078, 0x3fe8906ce6d2ecb4,
    0x3feaa064afd59e27, 0xbffb1fbbc5929818,
    0x3ff02870cfefd876, 0xbfc42798a96800a0,
    0xc0119ac3220c869b, 0xc007903163130788,
    0x3fd6564a7f0b6ca8, 0xc004728a3df749e7,
    0x40020a69cc204e23, 0xc005ada939cdd08c,
    0xc006be87b07a5a01, 0x3ff94b0d7f877517,
    0x3fe3c86ed2d125f9, 0xbfc94a64dda20504,
    0xbfa4d62d37e62b00, 0x400350d8b4cc9002,
    0x3ff62c406670d564, 0xbfe7449f8e1f48dc,
    0x3fcd9708be56ec44, 0xc001c2ae1c2dde5a,
    0xbffe699c88f687b8, 0x3fd029fb541c36c6,
    0xbfc4096ebf9346b0, 0xbff539e9313a1d36,
    0x3fdc291d7b5210c0, 0x4011423b29306886,
    0xbff8cc996260aeeb, 0x4013321718b33e01,
    0xbfe2e079605a532c, 0xbff25d3875779937,
    0xc01663ac7671c48e, 0x400ab96a4437f4b4,
    0x3fef61f37ba9cc92, 0xc01308eb3886395d,
    0x400b76e812e1bd6b, 0x4005491131477cea,
    0xc0091ce7db160148, 0xbffa2ed7466ac4d8,
    0xbfef7e5b5057787f, 0x3fff7a018f42f31a,
    0xbfecd1eca8ec1b38, 0xc008b088050c3a5f,
    0xbfccc54732dd90c2, 0xbfc49bc5ca8213c0,
    0xc0080f73c4403aaf, 0xc00249cabdc1122b,
    0x3ffb6ad2ac82df1e, 0x4001195bf0523285,
    0xbfe23736292d9efe, 0xc0118df716bed3ac,
    0xbfe148be195b4804, 0x400dd16939f0be8e,
    0xc00364f178e3f0c8, 0x3fba110ac40664f0,
    0xbffa1c0a6170431d, 0xbff13eef433a3e8e,
    0x3fe36e2c8c88de1d, 0xbfde1ff632d8a952,
    0xbffb6a5eca1d28b7, 0xc00cba4b219be8ac,
    0xbff9ccb747e0ed93, 0x400e4ef6801f29c2,
    0xbfd83f036dcb71f0, 0xbfcae8a8973cb2f0,
    0xc0028d8f1dfae508, 0xbfe5ac44dcb5b001,
    0x3feaa7d7a532e4e1, 0xc0076b881e6ce594,
    0xbff274c37327d46c, 0xbff9e729efd0e1e9,
    0x3ff8eafcfdc96110, 0x40128e6421306a8a,
    0xc00302e96fa1f92d, 0x40057c1d2f7c6a56,
    0x3febaa40044d3103, 0xbfc5bf1178ca8942,
    0xbff03b512fc20e00, 0x40032499c88fe684,
    0xbfe9fb5bed9a8e0e, 0xbfb1e0c473a14624,
    0xc004c710138f91ce, 0x3fd98f13c5a962cc,
    0xbfb947ddaad03de0, 0xbfeab442a90090c7,
    0xc007f0c1ed5da1da, 0xbfbb0392e4dd8c1e,
    0x4008540a1e4825b6, 0x3fcaa0dfe984374c,
    0x400583f7155db6c1, 0x4014865c4a7437de,
    0x3fafd55fafe11c00, 0x3ffe6b3064abee82,
    0x400a554416c6d928, 0x3fe76195942fff34,
    0x3fc0fe9df36b6ab8, 0xbfd43967c6f2a78a,
    0x3fe5efbfc02e2e4a, 0x40097c8c7660cda4,
    0xbfff76f3537366ea, 0xc01302c853288747,
    0xc000f1e32db8ee08, 0x3ff14eeaa9f8b021,
    0xbff365dacd4dbb08, 0xc0114cd3fe6454e4,
    0xbff3bd79783fcaea, 0xc0194828cd241b5e,
    0xbfe0cebaa5ad315e, 0x3fdb4b383d259915,
    0xc00199b577de8c24, 0x3ff3b2b523817e30,
    0xc0039b670d8fb3ec, 0x3fdcedbfae01e6fc,
    0xbfc6b977b05399e0, 0xc00120d4cfc9b91e,
    0x3fe59251bc58a16e, 0x40111cefe1f4250e,
    0xbff17cef14a9f0a7, 0xc002f9508b20975a,
    0xc00b38061040a300, 0xbfbc3504e73a92d8,
    0xbffa2ea7ec6938e7, 0xc001dbcda70118b6,
    0xbfeab7a1d49df78c, 0x4000ed4765a110a6,
    0xbfdf89d58934001e, 0x4019b8ed558181fa,
    0xbffb338dc6813640, 0xc003256e35224c79,
    0xbff3fcdf7ffa98ea, 0x3f65b37fcb19e500,
    0xbff6b8216a2477c7, 0xbff8b8e3dd2702c4,
    0x40041284ab1cbacc, 0xc0001767998c98a7,
    0x400ec9cc543cfba2, 0x3ff85970bbe9a0ab,
    0xbff42db362c2c84b, 0xbfee61a90d14feb2,
    0x3ffcf4d5e43fa602, 0xc0046d3cf9dbaa84,
    0x4004d629daf82494, 0x3fb410e9f697fbd8,
    0x3ff3a7188f9664c4, 0x3fd86af1b42735f4,
    0xc0072ec6b70b47fd, 0xbfde5c22d70148b7,
    0x3ff50be95968a9c5, 0xbfe22a8ab7f38ba8,
    0x4007c392dceb99f7, 0x40082c3df5f03e9b,
    0x3fe0cd072973b220, 0x400860ef93947be9,
    0xc013fec12ebe8ae4, 0xbf9a341100e54fa0,
    0x3fde89fe46c05506, 0xbff389b08d8b446b,
    0x3fc5106ae4f7c372, 0x3fd67aac69f2d74d,
    0xc0037dd8a8c07250, 0xc000b46e64c391d4,
    0xbfc09795726fbb98, 0xc008992f5dc3708a,
    0xc0012829cddba3b7, 0xc004ddab03455e9b,
    0x400962a31d8e060a, 0x4010ec8f4496b538,
    0xbff8f8daaa597e69, 0x400301442950b86e,
    0xc016923930b2f252, 0x400208900835781e,
    0x400d20b5b52005c0, 0x4002b3932ddfb660,
    0x3ff59b67060d68e4, 0xbfec4bcd106b474e,
    0xbfd5b0ec83e734c2, 0xbfd099bdfaee80ac,
    0x3fec4535aed08d7c, 0xbfc5fe5e6b4ce74b,
    0xc016a872d0000c87, 0xc00130d178f48476,
    0xc0154479f4f9dc10, 0x400da4d749cd5fa6,
    0xbfee311faf1c640e, 0xbff42c25d41a3118,
    0x3ff46701859a805a, 0xbfb9983f85235440,
    0xc0017b5ae20b238c, 0xbfcf856c3a77c0b8,
    0x4000525f1bb5c53a, 0x4013bcd16604b3e4,
    0x3ffcb602e30bdaf0, 0xbffdb2d8d22eacfe,
    0xc004a396b4dd31a2, 0xbfefb6d402994ff5,
    0x3ff92cc5072fbe3b, 0x40072b03fe3870cc,
    0xc0015bb7feec092a, 0xbfd48e1095c32921,
    0x400cf375883db8c0, 0xbfde6eb4ec61e050,
    0x3fee08595bc7f409, 0xc00b6cfbb2640c38,
    0x3fec3bac548bf532, 0x401d34f4167fe8a8,
    0xc00e793a396a228a, 0x40061e9f049320ec,
    0xbfb33b3756153f10, 0x3ffc34be0d21b684,
    0xbff4c501d99fceca, 0x40125ea28f2d790e,
    0x3ffad18d3691adb4, 0xbff40aaacefce8b4,
    0x3fff512b3db492ec, 0x40128ad8b1399a8f,
    0xc00409f1a5a6957c, 0x3fee85d67c14109f,
    0x400239c76513ee05, 0x4008f65634cbdb11,
    0x3ffd4f5e436ee151, 0xbfe1754c995cc692,
    0x3fe15c4abe80e4bf, 0xbfe1d51954bc0090,
    0xc009ae03265a0828, 0xbfcf75ebb569b000,
    0xc0026b3d768f855c, 0xbfd0cffa30c6bdb0,
    0x3ff0edaab5685891, 0xc0041943faf05053,
    0xbfd26be1ee94fb50, 0xbfce5dbb5e22c650,
    0xbfd5ac3b02d129c0, 0xbff8666f83395b02,
    0x3fe00c854b33cef5, 0x3fdcbdb468ec8658,
    0xbfe423b50e3c2b5b, 0xbff4768306c7a9d4,
    0x4003fd4bb9b86ae0, 0x3fc84d74fc8b0d38,
    0xbffad274d98d7caf, 0x400c415906c178d2,
    0xc005e1291117affc, 0xbfce8142364b1af0,
    0x3fe94158f26a411c, 0xbff949f8fb4cf3e6,
    0xbff04a06ab33ae5e, 0x3ffe8801cde850ee,
    0xbff4e80277a04e1c, 0x3ff1cec799999691,
    0xbfe3e88b122e8286, 0x3ff81f8a5ee78f52,
    0xc00072a1dc681783, 0xbfec5b0087481ec0,
    0x3ff1fe13a3566c7c, 0x3ffa451d72e90b1b,
    0x4016edd3c582a0db, 0xbfe012e4ddc3df0d,
    0xbfe24abe0d1a7d17, 0x40062fe6a2dc7788,
    0x3fe780e487567f22, 0xc002cf9883494676,
    0xbfa52fbf33fcc750, 0xc0079ce4d1c3f093,
    0xbfe4680ae09c987a, 0x400907f935b020c6,
    0x3fd0aa5f1f5a4644, 0xc00b1ea04e964548,
    0x3fe1c848f0a6be70, 0x3ff249faf556ea46,
    0xbfe7707706a2ff8c, 0xbfa00c23628061e8,
    0xbfc7989b67b392dc, 0x3fc38294fa56a358,
    0xbff35fff8fe66941, 0x3ff0d2b6073f0906,
    0xbffdd95b8c03eb82, 0x3ff0bf866422ded8,
    0x3ff55f74083c2cb1, 0xbff706313e29113e,
    0x3ffb23cc4db70be4, 0x3fd2edc10d20e823,
    0x3fb40fcc53491580, 0x3feef2299a467df2,
    0x4011cf8bc01cb292, 0x40040a628a369d4a,
    0xbfee047c714f5e02, 0x400028898cea4806,
    0x3faafc20482933c0, 0x3fa00807e5548540,
    0x3ff7278a6769d6d4, 0xbfe0067411b62c50,
    0xc013afc050d7c082, 0x3ff133e3679775c3,
    0xbffcace9db853220, 0x3fee1c05dd5bba1c,
    0x3fdae80531eb7110, 0xbffd5c1dfaf3a958,
    0x3fe49c97a2e6b948, 0xc003041501a6038d,
    0xbfb5fffbb9f04610, 0x3fe46b3c871e93ca,
    0xc012a72d33b5a0e1, 0xbffda9eddd8ff53e,
    0x400b98da7eb5d549, 0x40089ba06b296225,
    0xc009be7aaa2c45a4, 0xc001dd90e0f3ebc8,
    0x3ffddeb93806ed99, 0x4001f18c66aefd30,
    0x40067932de90b8f2, 0xc00c78115499827c,
    0x3fd9ec97cc10a232, 0xc011b20d464ad093,
    0x400182f59a6546d5, 0xbfffe7ba9b01be2d,
    0x3ff9003af5a456c2, 0xbfe621fdde73824e,
    0xc012610077e41eac, 0x40033b4b5ba20785,
    0x40086f6ad65bd1bc, 0x3ff830c7fcc08ac0,
    0x40147c7fadcf00df, 0xc00f5b4ec03686b5,
    0xbfd834b85a9afb24, 0xbfe253be4a03aab9,
    0xc000e607ae23dcd6, 0x4011a5f545865852,
    0xbfd2446e61defd90, 0xc004f0f029589c1a,
    0x3ff345f06609466e, 0xbffe3bbc53993f35,
    0x40034760e918286c, 0x4004e8b6b824bcb2,
    0xc014f19d93ef83ca, 0x3ff94e4a575648f8,
    0xbfd291eeafe7b72c, 0xbfef9b391cbb202c,
    0x40118eeab284a0f1, 0x3fe982e510388b42,
    0x3ffe2b2952e85fc1, 0xbfe84da28f77ff70,
    0x3fd2bf53c48b48ee, 0x4007cf172cb6870c,
    0x400556bc67bf6fc0, 0x3fe60b061b9f3e04,
    0xc005c4f02cef4cfe, 0xbffdd50d4b336252,
    0xc00645430162e7cf, 0x4001f0a608a7a884,
    0xbff346d970bd875d, 0x3fed660d6633565c,
    0x3fe4c1855eddd5ae, 0x400b5323c8a1054a,
    0x3fe9fec01b017eb0, 0xbfcf68fbdb90d020,
    0xc00e235c8d9d0fca, 0x400383e2d6a2eeac,
    0xbff397b95cc520fa, 0xc00d0a22c3259e3b,
    0x3fe2d7ad6d7847ab, 0x3ff5042986354fef,
    0xbffd1a03bd26e309, 0xbfd426d177417868,
    0x3fde9378431e51cc, 0xbfedf5be3104d4b0,
    0x3fe67e29c48d577c, 0xc00f61e0e055f00c,
    0x4000116a1364f987, 0x400436948b9c521f,
    0xc0096c63a3ec35e4, 0xc0034fb36aebffd4,
    0x400b05314332b5b4, 0xbfce09e86efc5cb0,
    0x3fec6432c090cb56, 0xbfe50475fa1d7dba,
    0xbfd868bc907c8d60, 0xc002cb4b04452bd2,
    0x3fee3817ad3a6bf3, 0xbfb9b126c86b76c0,
    0xc0021a54d94c8eaf, 0x3fb653ac6b3bbfa0,
    0xc0099fc8538b65bb, 0xc00b7ab1060757b2,
    0x3febf0eec91f32f1, 0xc003730ba21406b4,
    0xc00ae90b7d2cb13f, 0x3ff4424f33662360,
    0x3fec21e77f0601d7, 0xc008fb30aae622a9,
    0xbfe9d87d565432c8, 0xc004e761ecaeb9b8,
    0x4002aee5a936f123, 0x400671114acd58ff,
    0xbff9aa55af1671f7, 0xc0044b8d35db3948,
    0xc002bf8a4f996f6d, 0xbff35ce3f95643c0,
    0xbff4ec15feb6d4db, 0xc00a9f44f548e036,
    0xc0026f48b434becc, 0x3ffca86772c17a6b,
    0xc01096feb060054f, 0x3ffaa67d040a9c15,
    0xbfbe605f4e37522b, 0x3ff508ad23e1e555,
    0xbfbb59fb50c9fd80, 0x401159fcb37b72b0,
    0x4003516d1a78f62a, 0xbfed79d3a829df73,
    0xbfd6cabe7d7bf160, 0x400555719614eef8,
    0x3ff354f0b3020d48, 0x4000913b05ca0c19,
    0xc0024a347e86aad0, 0xc0065d28ed2ae244,
    0x3ffce8624b7af6f2, 0x40008b02f444466c,
    0xbfffa6b76347fa3e, 0x3ffa0af2d51ad33e,
    0xbfee56dfc7283d62, 0xbfff43d8fd7dd1fc,
    0xbfe2c72c0f4fdd8d, 0x3fb731816ff1c860,
    0x3ff2d036d31e15eb, 0x3fe8dd14c7819134,
    0xc00649129688e97d, 0xbfde445f2569ee58,
    0x3fff53136c33dc45, 0xc011c3132d2095ac,
    0x400189be7a3d2e17, 0x3fcaf04c59f2b7b8,
    0xc0006dd46b13d057, 0x3fe6b846ed3583da,
    0x3ff09f442f96d0fd, 0x3fe6da989b22fc05,
    0x3ffe2a5e8306315d, 0x400adeef63f2b01f,
    0x3ff40981b9895eea, 0xc003148b63f6bafb,
    0x40104bd88c2c9303, 0x3ffe43daac6ac4e4,
    0xbffc2110abd93340, 0x400174a5792a89e7,
    0xbff96ba1de1eefd0, 0x400a9936062d130d,
    0x3fe4903ae918a65b, 0x3ffcc6240e5f4014,
    0xc00b4aa24aed85b7, 0x40065518e1573fee,
    0x4006328090b9d468, 0xc002333fa5a5aa77,
    0x3fe81378f684c1c8, 0xbfe23f9ed24aa37e,
    0x400c85edfd3869e8, 0x3fdae110248e31c2,
    0x3fe11856aa651abf, 0xbff33540c8ae46df,
    0x4016416e9f08eda6, 0x3ff36990ad6ebc96,
    0x3feca54bc81c8924, 0xc0019ca8229c0a78,
    0x40057ad38f84c8be, 0xc0062649b9de54cc,
    0x3fd966583382452c, 0xbff323ab5187701f,
    0xc009dd04526115fa, 0xbfe3f7e07b3b30ce,
    0x3ff1620f9cc0b310, 0x3ffda7d747a328a9,
    0xc007208eddd4a8c7, 0x3fe594c4761aef6e,
    0xc01385af8eeaa2b4, 0xbff297e0beef6064,
    0xbf86350394ed4780, 0x4001bda467922fd2,
    0xbfec1673be869299, 0x3fe77977d2a66138,
    0x3ffda4df9dcab50e, 0x40069eddc0a4c518,
    0x3fa9e34b55579f80, 0x40067b7b4f5b1963,
    0x3fd19b168a569dc1, 0xc011b49c4391168c,
    0xc003e93af0d044ba, 0xbff23942f5e538e8,
    0x3fce3252ab4fd8fe, 0xc000a60d3476a933,
    0x3ff5915414f73f79, 0x3ffcf8c5d97478fc,
    0x40004ffc57da198a, 0x4010a7349a79240a,
    0x3fec67a64e50ddb8, 0xbfe570bf89a3220d,
    0xbfe825f90e3ce044, 0x3ff1af8dcb2ba468,
    0xc0071f4f877724f4, 0xbfddd4d1e011f64e,
    0x4003c8b2d43aeb6f, 0xc006ab18c55ce4a6,
    0xc0034e9cf16c8a24, 0x3fe9a01445051828,
    0x3ffd3af208da0326, 0x400315bbc933ad32,
    0x400be3c3943853c2, 0xbffb03f6ec0e8464,
    0x3ffa98798dde57bc, 0xc0169fcec0f3298c,
    0xbfe1c3ccbfe74290, 0xc0016a9b4c1997e3,
    0x4010b32fcc60f532, 0xc011e6c605336afc,
    0x3ff6095ee03e8607, 0xc000016bbd8334b2,
    0x400f233aaecbd847, 0x40080e10999fc7da,
    0x3fea477502a2299a, 0xc008f382be4244d4,
    0xc005440726bbddda, 0xbff20392587711c0,
    0xbfd80c1da3036693, 0x400187ff2fe6761a,
    0xbfc379bc49e63a00, 0xc000653291346458,
    0xc012a90ed8f70bed, 0x3ffc6f1a69074262,
    0xbfff487940d555aa, 0xbff47a1e0d133719,
    0xbff06850788444be, 0x3ff197f9984acb99,
    0x3ff9653e3907558f, 0xbfed50cd3685dcb0,
    0xc0050b9cc16acbc6, 0x3fb6e56e88e75cc8,
    0x3fe2fd48bab5138c, 0xc00028ee50b5a796,
    0xbfb689dee3c83608, 0xc001c1857ac542aa,
    0x3fee9438b8f59d10, 0x4004c8cc8b30551a,
    0xbff8734b072d7d44, 0xbfe080e9f4b63633,
    0xc00dd0df9d20459a, 0x3fd796ed7fa84a18,
    0xc0068026798a071a, 0xbfa611392c7f3740,
    0xbff5b5157954c064, 0xc001dd1f45321723,
    0x3ff2b85922866554, 0x3fef51fe72a2d7a0,
    0x3ff2f1c97e055e9e, 0xbffa4c5bc4992816,
    0xbff7fb12839e33a6, 0x4014ef6e70923d48,
    0xbff20eea9e8ec7b2, 0xbff479d855b26368,
    0xc0098c04d35743db, 0xbff795608bd2bea3,
    0x3fda96dd1ff2f0ac, 0x400e559cd66eb355,
    0xbfe8b1bac6140d92, 0x3fc47037bce94718,
    0x3fd6ac4b47818ce2, 0x3ff97382cfebeb65,
    0x400787a2405660c4, 0x3ff0d862abf7293a,
    0x3f7fca3df0ae2500, 0xc007682732f2d111,
    0x3fdd1b34a0222742, 0x3ffb1d24b594839a,
    0xbffce2fafa1b236d, 0x4011cffcaa93364e,
    0xc00f313d7fbcc74c, 0xc00df779f8f9ea6c,
    0xbffa86a56795e28a, 0x3fe6c480bacb3963,
    0xbfd382fc8dac4e8f, 0xbfb1397854d66660,
    0xbfd4c327fcc93df0, 0xc009246480cdaff4,
    0xbfe7d0e9a30ed817, 0xbfd51ceb87f8ab78,
    0xbfe35e3c939ee459, 0x3ff7bd4dc5930c0b,
    0xbff40e75386dda6b, 0x3fe8e7aff416f55b,
    0xc004fe6cc6034817, 0xbfe30f5270a9c254,
    0xbfeda4787ca86b7e, 0xc0012fedfe5a2e92,
    0xc0029485307d3079, 0x3ff516bf4a41f130,
    0x3f81da0b3ff4b780, 0x3fd4db8ce60a7868,
    0x3fc5ed72aa0bf294, 0x4002c1e5d8150d6d,
    0xbff236c75388ffb4, 0xbff962c41fee574c,
    0xbfe4ac6a1e7d05ea, 0xbff6ea12832ba974,
    0x3fd58e2c33f1b9d8, 0xc0117183f84f1403,
    0xc001d8f168f38c19, 0xbfca1faeee0b42fc,
    0xc0056eb6bdcdeadd, 0x400cf7db999bde36,
    0x3fb3135c26b32120, 0x3fe8810006414eee,
    0xbfaa9225b52f2300, 0x3ff0da5fcc51edd2,
    0xc00640879a49eae2, 0xc00f4a7a7f68f1ac,
    0xbfe37399bb71835a, 0x3ffba493ff981d68,
    0x40153d9416e1addf, 0xbfe32f70104405b6,
    0xbff057b1d4448c50, 0xbfd78087768c83f8,
    0xc011a73b4e9dd636, 0xbff796e7f5cdcfe3,
    0xbfeafa7c96bc4103, 0xc0094a28f77ee668,
    0xc0048045a7a0a387, 0x3fe826bcbc5fb98a,
    0xbfe9b9ca8dbe9e1e, 0x4008f7ab0df21f81,
    0x3ff052761367abe6, 0x3fdecc1f7b545124,
    0x4000f0fa0f578b4a, 0x3ff0e70e23105225,
    0xc0099c6e775b38d9, 0x4003f260d0c306ca,
    0xbff57ca7a556ae1e, 0xc00dbfd63f369762,
    0xbff087be716081e1, 0x400632d85318f5ef,
    0xc0092b1ad03a07e8, 0x3fffb892f7805146,
    0xbff1fba016d64294, 0xbff7f84fb5c70342,
    0xc0041134bcc904b8, 0xc004396f90603e46,
    0x3fbd570884c4bda0, 0x3fe2a3c6228cf974,
    0xbfd08608eb7ec760, 0x3ff27685eb92227d,
    0x400350f7ecd171ee, 0x3fd8a0a6e6e13810,
    0x3fe56c21398870a2, 0xc005e92be9e56a10,
    0x3ffb3058e9353e5a, 0xbfefda361c4bee3a,
    0x3ff758e775370cc2, 0xc0044d1825620e92,
    0xc009e6392954aba2, 0xbfe8125a57d636be,
    0x3fd50a72b9e724cb, 0xc0129124e7a024a5,
    0x3ff9710f3ab9db6c, 0x3fff57e32353d6f6,
    0x4004423311e2265e, 0xbffcf1cfe82e95e6,
    0x4005eaa97c4830cd, 0x3fd557f4a95748f4,
    0x3fe821185dd53d78, 0xbff34a793d20c3e1,
    0x400e5c31795557d2, 0x3fe73f98236ac09e,
    0xbfc16a8eec92a3f8, 0xc011afdde79ae650,
    0x3fe6aade5f06c39e, 0xbff890797795db7a,
    0x3fef428dc33a5dfc, 0xc00fdb4eb768ae5e,
    0x3ff88acd99961fd8, 0xc00a5e1ea1be1c96,
    0x3fc21ddaf4786568, 0x3fedae7fa37c6720,
    0xbfde7bf394d503f2, 0x400d0510ae87e1b5,
    0x3fed757b0d2e68e0, 0x3ffe3b0bfc2865c6,
    0xbffc6c1d682571cb, 0x3fe338565583e566,
    0xbfe5703d91865f2a, 0xc01054a3a4117ddc,
    0x4001f57922f19cfb, 0x3ffa382e81a9e75c,
    0xbff7e616bc22eb44, 0x3ff51ea2723f8aa8,
    0x4010dd3f346bd9ce, 0x3fe45436ea24b762,
    0xbfeee225060720c6, 0x3ff868c3905eac9e,
    0x3fe2553c68be845c, 0x400819dd0f4351d6,
    0x3ffeaa86770479f4, 0x4000342834868adf,
    0xc0065c3cb6bdab15, 0xbfca8b23a049eaa4,
    0xbfbae89bf807776e, 0x3ff134e099aebe76,
    0xbff567367a659284, 0x3ff9edf9dc3bb1ca,
    0xc000db153165b15c, 0x3fe40abc0ce396c7,
    0x4015f23f4687dbd6, 0xbff80b165a618598,
    0xbfd6afb92514df80, 0xbff85f3320cf47e1,
    0x40051465b338a38c, 0xbfefc08da6a25b23,
    0x3fe3e7c0ccfb5d86, 0x3fea2de3e80b9bc6,
    0xc007a4b0aa23202e, 0xbfd7d46d7dc8a4e8,
    0xbff98cc71d8252a9, 0xbf3984bccb7fa000,
    0x3fd1bd1d8494ad2e, 0x3fd287594aadf956,
    0x3fce352ba58f0ff0, 0x40009241d45fe3d7,
    0x3ffd570da311030e, 0xbf7a0d2950357300,
    0x400f798149641af5, 0x3fa04c841d6b7c80,
    0xc0077bf3a12362fc, 0xbffe7d2e9f5c5aaa,
    0xbfeb204f009f44f2, 0x4010a30c925d27a6,
    0x3fe71dcddd901dd2, 0x400c74164bf07102,
    0xc00bc60837985e88, 0xbfbfd45139f85680,
    0xc0010b8c5a1cd718, 0x4015d5d83629f498,
    0x3f43a951f44ec000, 0xbfe42d611bdc90c4,
    0xc000561882b4f706, 0xbff3d5b1bbbd820a,
    0x40055026e7ca1bda, 0x3ffaa1d6116a0e16,
    0xbfda8b520bf7f410, 0x3feb4d38db8d3402,
    0x3fc3d169ab12bb4c, 0x3ffc90ecb1147bfb,
    0x3ff4c7d058fd67f9, 0xbfb23ecf6baa1944,
    0xbfd12c584f221e2c, 0xbfed6bd5c1831df8,
    0x3fd188c7ca16578e, 0xc00e62f96795035a,
    0x4001600bdc70c825, 0xc0085350a730ab50,
    0x3ff7340fa2fb4d15, 0xbff38b899fa74b17,
    0xbfced56dc8e093fc, 0x3fe5053e572b4e74,
    0xc0040c490784c9e2, 0x3ff58dd3ed65c133,
    0xbfd24416ee7fa312, 0xbff3814d9a2bf34b,
    0xc0011c7069b4ead8, 0xc0017d45f3a34f37,
    0x3fb286bb053a4d10, 0xbffac99ddc0d4191,
    0x3fee47d48fd10bbe, 0xbfd04df76fe6c722,
    0xbfed77d31715cfc5, 0x3ff50064a2486eae,
    0xbfe0b59432a25fb4, 0x3ff331a61c7c82a9,
    0xbfd52432a007a53c, 0x4004cef0c703d723,
    0xbfef0973b4181242, 0xc00e588a16afa236,
    0x401863ee28b1960c, 0xbfe9735422517556,
    0x3fd06c0ef83c9880, 0xbf92d76243739980,
    0xbfe1edc6a225069e, 0x3ff2e56c25232412,
    0x4007315a0bdba7a0, 0x3ff111ad1a699266,
    0xbff56245b2cfe374, 0xc010ee61d3786822,
    0xc0028604b69adef7, 0xbffaa116d2b15c6e,
    0xbff6ebc32ebe8d46, 0xbff98a5c831ff580,
    0xbff0aaeb52c4d9f2, 0x3fd794c487d27b8c,
    0x3ffb33d7a727b38c, 0xbfd3b5a8aea8c4ec,
    0x3fd35a02a53ed400, 0xc0053dc93b031feb,
    0xbff871576c39af7e, 0xbfee7a4f705e2906,
    0x3ff4cca8a48f75fb, 0x3fffce350ae245e6,
    0x401008f5a5cc7ac2, 0xc002565c6b9a9044,
    0x400e1cbb56f9a4f6, 0xbff04de816a39ed0,
    0xbff55102f8e031a9, 0x3ff06f285f8ce828,
    0x3ff237e03e29911e, 0x400c2f1db46ce5e2,
    0xbfa09981e8d95ba0, 0xbfff481af71a9a63,
    0xc0097ce33189bfa7, 0xbff1d9889c6d47ec,
    0xc00da1398261e3f9, 0xc005bb9227543b1f,
    0xbfe886560efb6354, 0x3ff74699d9e554ca,
    0x3fd7de0f8773f4a5, 0xbfbe3325b92364d0,
    0xc00fabd376ba7762, 0x3ffdf1af849a2946,
    0xbff13359ea666332, 0x3ff15e5d259dd0d4,
    0x3fe66620319d0f48, 0xbffd528fa49d01f0,
    0x4009779683aa1580, 0x3f97642f8eeb0880,
    0x401022dc652c9967, 0xbfffc28370dd7732,
    0x3fee36482992225e, 0x3fe0182ecf899dcc,
    0xbfe2b99fe3ed5bcc, 0xc007a67fa5e0a520,
    0x4000701b875bb366, 0xc00122ae28cc8e2e,
    0xbff2d2ed3f92a05b, 0x3f8cce5e1bb606c0,
    0x3fb69d3bce563e38, 0xbfd89d7b5e31a892,
    0xc00025c04d7bbea4, 0x3ff54d7cfd3ad0aa,
    0x400c7b7a7f66fafd, 0xc0051b4ffbdff80d,
    0x401270465ce6a3ca, 0xc0038474cd7e2f7c,
    0x3ffc1a5b74c9530f, 0x4002a445b11411b8,
    0xbfc7ace2c632e69a, 0xbfefb6da00a70b34,
    0xbfe08698706e1a3f, 0xbfcdddc7744400f8,
    0xc00d5f3644af70ad, 0x400a5ec82641f96a,
    0xbff7f161bc758f05, 0x3feb955c266392d1,
    0xbfeb9c34080d64f5, 0xbff27fa19b96d869,
    0xc000d2ee4b8cba1e, 0x4000e4d341e8c0f4,
    0xbff1434998771d80, 0x3ff32d66947246e4,
    0x3ffa68bff8afa684, 0x3ff7c9159b4cdd2c,
    0x400cdbf59ed30e54, 0x400199082a4b14dc,
    0x400179cd376d3e40, 0xbffb6c0d0fadfb21,
    0x3ffe11b90072109e, 0x3ffc640832f3064a,
    0x3fbf1bcccff79d68, 0xbfea9cc7356bcaa2,
    0x40027d383d669874, 0xc0107a42690d0f38,
    0x4016bae93896cb76, 0x3fee77c3aa559320,
    0x3fe5dd3ad999c672, 0x3feb5d883fa6a86a,
    0xc0056d52e28c193c, 0xc00ebef7aaf33c64,
    0x401204d32bfb490c, 0x3ffe68620846ffbd,
    0xbfefefbc08fe5e9a, 0xbfdfca826f016320,
    0x40049b1b07fef232, 0xc000c34f22edd94e,
    0xc002b23cbeeea10f, 0xbfe838578b229316,
    0xc010b5b200999273, 0xc00c06c2050c077e,
    0x3fffd1affcbc556a, 0xbfde761ef5122fa4,
    0x4006fd6b8a8dd766, 0xbfd99753d02c337c,
    0x40171d13879cf17d, 0x3f69126af3755900,
    0xc00f999c01d0eef6, 0x3fee74f2537efcda,
    0xc00b4be2bb8789d0, 0xc0124814c3b39e59,
    0xbfdc58bc32f42314, 0x3fe9e310b67d93ce,
    0x3fed19ed596af1e6, 0x3ff8422e0416c988,
    0x3ff99742045f15fe, 0xbffa6da21e33e871,
    0xc0038d86ad15e33a, 0xbff0dadb78c5e2ee,
    0xbfc1bad7837b8538, 0x400cd93f720d4ca6,
    0xbfba7d0da9a84040, 0x400bf260c342b25a,
    0xbfffafa3ebfd66a2, 0xc0111a21a0391b17,
    0xbfdfd07b8c39f1e0, 0x4009490e9bb4785b,
    0xc01a4aa98a00f0f1, 0x400baa2aad4690c8,
    0xbfd25400a421ba44, 0x3fe27b8a9be2ea5c,
    0xbffe94e496022c81, 0x401e85b7aa50fb13,
    0x40051522aeaaad5f, 0xbfe42bad28785478,
    0x3ffb6b0c55f4d6f2, 0xc00525e5551eb692,
    0x40128d90fa8395ae, 0xbfa1b795e7795bc0,
    0x40109d6925a8e757, 0x3fe1e6c5856a7768,
    0x3fece140a0dac390, 0xc004dd0d6db71dda,
    0xbfe54d506723c9b4, 0xc0050e1d3abec080,
    0x3ff67fa07d60b8ba, 0x4010b9abc8f45593,
    0x400256cb16ac2fa6, 0x4005079e514a90b6,
    0x400f8e5afda708a4, 0x4004eb76a1220f4b,
    0x3ff1cc34e55d4720, 0xbfff50419c3f104a,
    0x3fdaf7c3c3074ccc, 0xbfc36488aea7e658,
    0x3ff1c6d1921d7596, 0xbfb1f2cb0b10ae10,
    0x3f407cd4dcc35400, 0x3ffd18464f324c70,
    0x400bb4c2b4be802a, 0x40005d7041836804,
    0xbfcd4f5c3eace398, 0xbfff7410fc227635,
    0x40109d17ff9f816a, 0xbfe0a24e86a0f1a6,
    0xc00303e0f06b31ca, 0x4001f8e48ca347fc,
    0xbfef2b7005a5c48a, 0xc003d3b5245d2153,
    0xc011e058bb464182, 0xbfe0bd3edd774b82,
    0x4016f37bccb56d6c, 0x3fe3d96a321a689e,
    0xc010a6df89d9103c, 0x4009ad63fec2e72e,
    0xc00b3fb30cda30d9, 0x3ffbb158e21caffb,
    0x400035c47b9806cf, 0xc011953cc72b1528,
    0x4006ef609c44f3c0, 0x3fc5406547e44ca0,
    0xbfb8e2da64d82b70, 0x3ff766a6497d3eb6,
    0x40007260d482579d, 0x3fe3fbc7ba9d528e,
    0xbff32fc29c9a054e, 0x4002edda96e451c9,
    0xbffe16811f9a44b4, 0x3ff3d370899bd5bf,
    0xbfe975366cb3e9e4, 0x3fc580c4ca6c70ac,
    0x3fc4662a333762a6, 0xbfda88aeef6cecc4,
    0x3fd2061cf1775f5c, 0x3ff6013dbf2ad294,
    0xbfe372e2acf980e4, 0x3fb3c32d4a70c3f0,
    0x40132d4abb038b74, 0xc005042d1f7442e4,
    0x3ff36949da7ab244, 0xbff5ca5b12f2e2c5,
    0x3fd5ae078a6483e9, 0xbfec41dfb6d73467,
    0xbfe560078b5246b3, 0x3fe77f410dab0436,
    0xc009e726b7515f36, 0xc00b7d096a0fbb89,
    0xbfe0049b1ee8cd76, 0x3ffb1c3851fbff0e,
    0xc002858e4ddfeae5, 0xbfbc643d0e3c30e0,
    0xbfe79838b05ec6e3, 0x3ff18c19fa4c0292,
    0x400f41f1dc702576, 0x3fed42406dca07ea,
    0xc0037ebb9b4a9c42, 0x3fef27f6e27e79ac,
    0x3ff6921f4198042e, 0x40001c9f340544f4,
    0x3fefc300e685bfb1, 0x3ff0299987f1972e,
    0xc0056cb69ce7b0ee, 0x400ab95713331d51,
    0x401b98f5dffbed9b, 0x3fabae75fa7c7e80,
    0x40058926f4d5e50c, 0x400401e7aff403c6,
    0xbfee38599593b00b, 0x3f9984bf868c3540,
    0xbfe10902081ed6aa, 0x3ff2ea0b79d87753,
    0x3fe4073d105b7428, 0xbff0cef6863e0377,
    0xbfe3903c659dd8f3, 0xbfca6bd9842f1270,
    0xbfdb5eb5a0912dd0, 0xbff73abf5102efb1,
    0xbfdf6e489062107a, 0xbffc95d0d9549312,
    0xbffbdea27221db30, 0x3ffe05d285130032,
    0x3feeccdae0e9d3f2, 0xc00fc21b1a41550e,
    0x3fe8410a43ebf252, 0xc000aa1a1a3e2f55,
    0x3ff823a501828568, 0xc0015d0d43cde7fb,
    0xbfe8990fc59db179, 0xbff0e85f6afd4738,
    0xbff4a97511ad4a74, 0x3ff2a5a4ef3ac074,
    0x3ffebae8f91c649e, 0x3ff30befb0e0706c,
    0xc00172ff91bc06b2, 0xbff08949d500b91b,
    0xc0184101b90b1a7c, 0xbff4ef3a371f3d96,
    0x3fc7b643a42eb2f8, 0xbff735226c9067fb,
    0xc006968e527655d9, 0x3ff2cb5f89e10b0f,
    0xbff71dc3c526d60c, 0x3ff16c9d43cbf8d6,
    0x3ff847b57d737382, 0x40031f71d9f9abee,
    0x3feb703b4198fb6e, 0xbf917c4d47349120,
    0x400a6b694a4218a2, 0xc008b6658150a92f,
    0x3fe725f89674138c, 0x3ff6f434de1a8a63,
    0x40008d7004bfac22, 0x4000284eaefeb6d9,
    0x3ff78a15383edd2a, 0x3fe934e7559560fc,
    0x3feab19aaaff263c, 0x3fff3d81de3a342e,
    0xbff1f9527c417960, 0x3ff4176327fb56f8,
    0xbff1a49fccde922b, 0x3ff518d21f4c9d30,
    0xbfca57cca8a81008, 0xc01327e02fe0a125,
    0xc011e46ac7e225ac, 0xbff9b31cb4df9f6c,
    0xc003d211a74304f6, 0x400591067fe04b74,
    0x3fe45ef25d342c3a, 0x40049bfe78065382,
    0xbff55b57f71ca6d0, 0xc000b31edbebd3b9,
    0xbffe341b4d750087, 0x3ffbd72b4510de3e,
    0xbfee329760cbdae2, 0xbff8be8c72b59a9e,
    0xbfeaa75d1ff7fca2, 0xc00015e416c51d82,
    0xbffe160e30229992, 0x3fe04ebdf4251c51,
    0xc00748d71e01c651, 0x3fd47a6df71864ec,
    0x3fd3e1acab215646, 0xc0078c4e7799fba1,
    0x3ffcd43697af1342, 0x3fe05917e3fc4265,
    0xbff331ec5669480d, 0x40100c0ea9b6b7aa,
    0x3ff39c54680fb9bc, 0x400362e38727ff33,
    0xbfd75c5926cd7768, 0xbff7941f6fb35637,
    0xbff2a75bebddbccb, 0xc003ab48acb6f971,
    0x3feb90beb6260730, 0xbfcd83f116962880,
    0xc00554f596c456fc, 0x3fe8a6211e2900ea,
    0xbfd86dd287fc4546, 0xbff71ef1c49c9fe6,
    0xc00203156b393e24, 0x3ff53def958b4ed8,
    0x3fe5c7fb03f309bd, 0xbffe3d8063a08f7c,
    0xbff27e35c7bc5c4d, 0xbff2a711a78842b5,
    0x3ff94c31d8c6805b, 0xc0040d2daa8cac5f,
    0xc00587bb1644bee6, 0xbfc75d61fa049960,
    0xbfc6577d5d6fa7f0, 0x3ff95ead8c3379e6,
    0x3fdb415b805ab4f0, 0x3ff60600c90b9c7d,
    0xc011b6ba0d6e395b, 0x400e1d537210068c,
    0x40090208e2a22042, 0xc000294dda7754b5,
    0xbff96496cf523bda, 0xbfe8cf1a8a64f7cb,
    0xbfdb458018abe8d7, 0xc00d2bcc81dd83fa,
    0x3f86450959fc0000, 0xc005b3a4049817e4,
    0xc005b683d2b29b6e, 0xc011c759ca69a95d,
    0xc0107cfd3988959a, 0x3ff2f98f5f9f96c2,
    0xc00343a9bfc20ee6, 0x3ff8ea5137e1d1a1,
    0xbff641a1504fc86b, 0xbfdc516a3272f59c,
    0x3ff5b0ca1fd9e87c, 0x3fd9828a20a68d12,
    0xbffca2178b8662aa, 0x400d8e5fe05a4ef8,
    0xbfe2d1ffe7d2ff0a, 0xbffe810ae590c904,
    0x40020bf97fee8a6a, 0xbfb7773478f4dbf8,
    0xbffd7948004f9e0a, 0xc00026459c214ac0,
    0xbfb6ed8048a6f250, 0xc009ac4261504471,
    0xbfface6628297b90, 0x4004d14bc803d5d4,
    0x3fc395bbf108ecc2, 0x3fed4b3cc3d91b6c,
    0x3fcc1e1224e1b5d0, 0xbff87df794582ad2,
    0x3ff6c906ea0ce730, 0x401068bed425610e,
    0x4006458f28dfcc02, 0xbffbfb75fa02d8da,
    0xbffefe3cfeb559fe, 0xc0027cc108693ef8,
    0xc00cb03d8b812375, 0xbffaf22ef5381857,
    0xc005ee489fea39c2, 0x3fc9574515fa22e8,
    0xc00459d3e4bfe4ca, 0x3fbc83ffa0664830,
    0xbfcba3d5986a6e00, 0x3ff2232a4e839dc1,
    0x3fdf62e5779b1c3a, 0xbfc8679d6043e560,
    0xc00ee785b67c8b8c, 0xc0193835ec5c2b62,
    0xc00df53d237ee119, 0x3ff51b0f9e0dfcb3,
    0x3fe22771e304cc30, 0x400e9afbaa037906,
    0x3f936bc91f4bfda0, 0x3fe304206cef3256,
    0x4010f4785d04db50, 0xbfa0985dd8299b60,
    0x40085d60c34e93b6, 0xbfbd9c16172d9600,
    0x4001d9f00aad31a1, 0x400859235ecb9f5c,
    0xc010c6e1259834d3, 0xbfcb534e0a530bcc,
    0x3ff370e5f5e98526, 0x3fc07e6f3910c4d0,
    0xbfe99de69c17051e, 0x3ff3e65b519eee14,
    0xc0078fc291c8b2c6, 0x4007741db040dba8,
    0x401324bdefb9fa6c, 0x4004bd7f74203d17,
    0xc000260679c878bb, 0xbfffce7b6afcf9a7,
    0x3fcb47a1d642c1f0, 0xbfdd10ccb5df320c,
    0x401039dde8ebec2b, 0xc01be4168ff0c23c,
    0x3ff0732be35733aa, 0xbff91ff2e9f81168,
    0x4003a867bc3fbc58, 0x40022a5f20875c2a,
    0xbfca7f7ef96fdad4, 0x3fe3a458257f73f4,
    0x401281c37ee62717, 0x3ff086c8248fc9cc,
    0xc01403cbfcfb2111, 0xbff03dde57d5d7ef,
    0x3ff3bc0f983a005c, 0xc001dde601101814,
    0x40007077730fa08a, 0x4000841bc7af8e6b,
    0xbfef09bff6da8ee8, 0x400b34bc476abc8f,
    0x3fe03eba07974504, 0xbfdbfa3018e4939c,
    0x4004346c7fbf8906, 0x4004d51e5ba0dbf9,
    0x3ff61abc649b9fe7, 0xc000a945aad05354,
    0x3fbf89023ec82ce0, 0xc006cb2cc55b1e7a,
    0x400a374261311ea4, 0x3fc0148d33ce9534,
    0xbffa9526347d5b99, 0x3fdfb3c48d72e730,
    0x3fd363bc53c54b5c, 0x40020a46ac47b25b,
    0xbfe934ab14b1e1d4, 0x40073b0171ab9a20,
    0xbffefb57395bf7f2, 0x4005d444f3c240ed,
    0x3ff8b54a56794ce9, 0xc00ac7348503ba43,
    0xc006e0b578144685, 0x3ff428ad07eb0302,
    0x3fe743bcb12ef62e, 0x3fe8233e46392f3c,
    0x3feb288943318788, 0xbfd25b1a02157672,
    0xbff28f292e53cafe, 0xbfded120e237a028,
    0xbfdb27f342ec0f44, 0xbfb02f584ee853e0,
    0xc00dd50bc095a99e, 0xc0057d6c5c840680,
    0xbffdb556521540c8, 0x400e20fa73639cdc,
    0xc0020c3a4285d6de, 0x3fec5129c0f4b7d1,
    0xc0055380a7bb29be, 0x3ff1095f301fda7e,
    0x3fc28b6132a37f70, 0x3fe38f1f6c6382d2,
    0xc007fc0584c2704c, 0xbfea8bf163fe9d7a,
    0xc0005045bdc376f8, 0x40060eeb8cd51b12,
    0xbfff4c294962ae70, 0xc010b2013f690457,
    0xbfde8cd71cbd7464, 0x400e27badae73364,
    0xc006677d6b8a1944, 0x4007af660e661a3c,
    0x3fe749474078d268, 0xbffd25a3d2abe210,
    0x3fe6fddc420371b8, 0xbffd6a37e5a6e703,
    0x3fe6ad47c3666e24, 0x3fe297c3b25f8874,
    0x3ff10a337b538f13, 0xbffa6ebeffc33a98,
    0x3fb7cd577c4790c0, 0xbff2fee42b9c8776,
    0x400998092d69deb6, 0xbffe46f3d1c8cd4c,
    0xc00e182ecf6da4fe, 0x3ffe83233bc23084,
    0x3ff079502cf0b242, 0xbfd948f29d525168,
    0x401f13e197e2e0d6, 0xbfd3656337494538,
    0xbffdc991022e394a, 0xc004724e2ccb40aa,
    0x3fe78835eb9327c8, 0xc00f802a53f1588e,
    0x3ffd40a3f6cc2b5a, 0xbff58e64e4c05dd4,
    0x3f788c4afe61fe00, 0x4000e42ad114c5ee,
    0xbffbf22cf5843da6, 0x3ff3398156b81cae,
    0x3fec5a809993146c, 0x4011289cc564b5a1,
    0xc0020b2539d008b2, 0xc0068180538fdf26,
    0x4003d9c263e772c2, 0xc011afd26ae77628,
    0xc007cc24b74ec56d, 0x400576a9c8bb3b09,
    0xbffb28ce6a2e2382, 0xbffed6ba01d0adc4,
    0x3ff2c18c9da33b56, 0xbfc2f315925d340c,
    0xbff14fe638890f42, 0x3ffa7d8e69f6c392,
    0x3ffc4039c1a55309, 0x3ff1940f36cfac98,
    0x3ff5092fb1d9a583, 0x4004bfe652895938,
    0x3fe57433002dc2d2, 0xbfd83f37b9062b64,
    0xbfdff51db7db9a58, 0xc004fbd8c0d39eac,
    0xbffdd359f2acc9b4, 0xbfe95f917d332059,
    0x3fd9735153bd0b88, 0xbfff416ef60fe208,
    0x3ff5bc34515f1820, 0xbfaba1fcb31934c0,
    0xbfddb5b2277d67d8, 0xbfcfc9349ec82ba0,
    0xbfeef934507cbc8c, 0xc014fe64d2b9c232,
    0xbfe9221701ab481a, 0x3ff338a01938ab91,
    0x3fd531fd7503ca74, 0xc002d36335166f68,
    0x3ff4f593a5c69247, 0x3ff5771731d2acb0,
    0x3feec4be66c8949c, 0x3fe02ad28fb57028,
    0xbfffdee37812df68, 0x3fffaf2431558a05,
    0x3fdac2a1ccad664c, 0x3fe2876ce8c439c8,
    0x3ffaa3148a688067, 0xc0005d048d30cdea,
    0x4001c4bf2265df08, 0xc01b1cb919f4341e,
    0x3fe6faca6b7c9d6b, 0xbffad3c12dae3d17,
    0x3ffc218a0cf98ea3, 0x40096faacb761bf4,
    0xbfeac539f8c4a2b4, 0x40030992fe9f0a09,
    0xbfbae1e9d6dd9db0, 0x4002c476bdaf87e6,
    0x3ff92e3d478845a4, 0xbf76087e998f4400,
    0xbff502f4a4efe1d9, 0x4002080d33c1c928,
    0x3ffefab2dd9b9a7f, 0x3ff0dee7227b616b,
    0xc0052da62290baab, 0xbff94b4864dac0cc,
    0xc00ed0221ef5bc26, 0xbfc835e650e0670c,
    0xc00cef0ac7e5ab37, 0x40011b53baaa2e57,
    0x400d3b1775a8060b, 0x3ff7cc2709ec3ad4,
    0xc007a33126222c55, 0x3fe1b66d0116568c,
    0x3fcd020868d316ec, 0x3ff6c4f3ff2af410,
    0xbff4fdd66d2c005e, 0x3fe1b1ac3c32ab54,
    0x4016c6e31c5fec48, 0x3fe88a3bddce98c7,
    0xbfdcc093ff6ecfd0, 0x3feed321f2a656ae,
    0x400df043fb2de9b3, 0xbfd8427bc4eb3dd0,
    0xc00d05f1b6e8ecae, 0x4001baa770d64e9c,
    0xc0012f9896f5c225, 0xbff5ed5abf2bab72,
    0xbffb0eff52923a49, 0x400a9e0f1f9fae2d,
    0x3febaaa9b821b413, 0x4007f4fa0da3325e,
    0x400fc20b81dd46ff, 0xbfe2cd3e059b823b,
    0x3fd04223fcff6780, 0xc00e0522a6bed3e6,
    0xc00b602e8f867182, 0xbffa35ee78b63c4f,
    0xbfc685f05a3b5b74, 0x3fe82396674ce06c,
    0x3feebbf1eee59764, 0x400075fb7ff1a7b8,
    0xbff260b8b40f526a, 0x3fe92c9067315426,
    0x4002b351e995ac96, 0xc00037b86763f611,
    0xbfea9acbeb6028a3, 0x40123b65225cea34,
    0xbfe98c93b4319db7, 0x3ff16afbe3f6604e,
    0x3fdd560ddf5e6b80, 0x3fe8e0f9192be286,
    0x3ffcc1a63da74585, 0x3fe439408273b6e2,
    0xc001d7650b986c7a, 0xbfe2ff8957cc3d12,
    0x400fac93f627f3b3, 0x3fd997c2570d063e,
    0x3febf7da7a995a53, 0x3ff7f30ebcbb7341,
    0xc007cc95eb28333e, 0x3fee3572096e6d66,
    0xbfe29577e21bcd86, 0xbfd6a6ad64d47230,
    0x4005f4d5f76a6d87, 0x3fe5ee0487aa4388,
    0x3f8554bf50345dc0, 0x3fe28bc163123f22,
    0x3ff69074b5c71c48, 0xc005fc29286e6cb4,
    0x3fa1941e074a9780, 0xc00014cea4c92501,
    0x40118102d4e86ef1, 0xc00821a4cfac8492,
    0x400afda24dcfc7a8, 0x3fd68fc2ff4c9b78,
    0xbffba5c9159125d1, 0x4018c6c860b7d078,
    0xc0114be3a6f53768, 0x3fed442305bd6e91,
    0x400abc8c85789f44, 0x3ff7d1f88d35747e,
    0x3fff8579262002fb, 0xc00b6bf6694075d6,
    0xbfdd3d9367e10600, 0xbff35ff88f7e22da,
    0x3fff8e08f67f401d, 0xbfff181b0cafc88c,
    0xbfd755fca92b912c, 0x3ff7b860fd1b5576,
    0x3fe5b88837f4892a, 0x3ff564457664fd13,
    0xbfe00678260aff7e, 0xbfe62648ae3342c1,
    0xc000433ca4f8e3c3, 0xc00d6a12e25c8fe5,
    0xc010091ef26fa9b5, 0xc00b614c6d1a7ec0,
    0xc00afe4f830e1bb0, 0x4007dc3368ba0fea,
    0x3fe3866075e2e298, 0x4006e194af86213f,
    0x4000cb592c6f6d2e, 0x3ff5632432d20f70,
    0xbff9e392cb6b4cfc, 0x3fe4b61716fb2fe7,
    0xc002fbdc4a14be46, 0x3ff678a2b772f128,
    0x4000385b85b2e5a1, 0xc007f6b672210bac,
    0xbfd77a40cf9bb582, 0x3fefcd8d9854e386,
    0x3fff6b68072ae8b1, 0xbff285feb8c8a2ff,
    0xc007691c05f64658, 0x3fcb455ff93234d8,
    0xbff1787a84478a2c, 0x3fc4191ba49b2ac4,
    0x4002e1d6c12f2c2e, 0x3fdc5c8b54c7973c,
    0xbffc153f0c304216, 0x400154b8db8a376e,
    0x40026a6f1058a4fe, 0x3fed91511e9d8afc,
    0xbff1ef3328b94baf, 0xbfdfee3862f912ca,
    0x4011dbd8953a6653, 0x3ff7e21f825683ae,
    0xbfba13649181cf18, 0xbfe7407f7f5c8332,
    0xbff576e892ce72bc, 0xbfc666811fe158f0,
    0x3fd73ad2c860dfd0, 0xc01284ff7e3545ee,
    0x40127b81fbe6fe7b, 0xc0001913b8f9fc7a,
    0x4005da0fbb8d722c, 0xbff700afe20c3fae,
    0x3fee1e4e5d9a06c0, 0xbfbb3f938a5ad150,
    0xc005892039e6fe89, 0xc001a4a5eca54058,
    0x3ff7afd4ef8666db, 0x3ffd83b170e44c04,
    0x3fb96df32a24176c, 0xbff97f6cfb435fab,
    0x3ff0978a15016d24, 0x401267d7100c3d7e,
    0x3ff957a08598949b, 0xbff2316d54a67080,
    0x3fff449775e01658, 0xbffa23d808125123,
    0xbff012098ce4ae98, 0x3fd054bbdfbe1c51,
    0xbfe22aa307bd6ebf, 0x3ff77ae080deb96d,
    0xbfff6014e97859a9, 0xbfd16f0ad26ee1d0,
    0x3ff96a608ea89e89, 0xc0026069677219d8,
    0x400848886e7b4af6, 0x3fd7b26180a20484,
    0xbff9793762c3d811, 0x4000f8c34878b95e,
    0x3fea1b3d0f8acaba, 0xbffe2baaa3024968,
    0x3fdf9b806ed4cfe8, 0x3ffa528c85a9e218,
    0xbfccd416f179c018, 0x3ff4500d27997241,
    0x401e3ca8f6833bda, 0x400b181e84f5672b,
    0x3ffaf33f5024e0c0, 0xc007e314ea682b5d,
    0x4008f0605bd46a6c, 0xbff81dcc0a1e1852,
    0xbfe20030908b1578, 0xc007b67e4b0a0940,
    0x400e1a0a4d7b8c0d, 0x3fff8fbe52a68ece,
    0xc003be764c9fe73c, 0xbff355cbbdd38498,
    0x4017675df9a0c918, 0xbff2c72bb04f91f3,
    0xbfd8f1b4368093f0, 0x40088d3b2d803f7a,
    0xc00b8e96d5357ccf, 0x3fc067e4555b741e,
    0x3fd7e2957ddda676, 0x3fea027152e61c04,
    0x3ff2f745002df0d4, 0xc0073d67565ed2b4,
    0xc0023d28f777d938, 0xc00aa7e206b9ee0a,
    0xc007877b9aaf9a37, 0x40091deeeebaa83a,
    0x3fae209a319d1400, 0x3ffa40862eeb06fd,
    0xbff85561f61447f2, 0xbff36de1970d55d8,
    0x3fe43ad4f5e8080a, 0x3ffc6be1c57bb04c,
    0xbfe2ba91d19aae8d, 0xbff99120b5c628a2,
    0x3f72600241071e80, 0xbfd27d97f9470ee2,
    0xbfef656341f8205a, 0x40015052ab685919,
    0x400203e989388e8f, 0x400b6a3b30e9fc2e,
    0xbfe845857ddb72cc, 0xbfdd1e06230056a8,
    0x400bf23939069f0e, 0xc00f7290b638813a,
    0xbff7a4db0540d58a, 0x3ff769252e32d998,
    0x4001e31cab7299c3, 0x4014b361f0c44046,
    0xbfd44857435ab518, 0x3ff7bd866c04ea84,
    0x3fe5f9f672c180ec, 0xc0112178eab97f94,
    0xc007e37d9ea66601, 0xbffd11aef9d2d188,
    0x3fffef98d3420313, 0xbfe3b21c72fb0f10,
    0x3ff4fc644c2a96ef, 0xc00a4bac0fdc4efe,
    0x3fd987f39a0439a8, 0xc0065c43d0387571,
    0xbffb24ff332c268b, 0x400ea66ab74581b6,
    0xbff9f1415f8ad3e8, 0x3fefb751292e98ba,
    0xbfca792efd96652c, 0x3ffdf35607f24dd1,
    0x3fe8f382020f5501, 0xbffd525e02170522,
    0xc000649b847b9dc6, 0xc00aa10fd73fe22b,
    0x3fd4032447ba220c, 0xbffba0ac4342a827,
    0xbff0b4b8a842153c, 0x3fdab82072934e3a,
    0x3fe4723bafd0e958, 0xc008614bbe86a147,
    0x3fdd95dd87de8f10, 0xbfe9aa7abdc85a9c,
    0xbfeaf8ece18e5798, 0x400e0266aa031269,
    0x4012225a6c04b88d, 0xbfc7998c227b2610,
    0xbfe4d3fdfeba4d64, 0x3ffb028eecee4770,
    0x3fd885629256e41e, 0x4010a5900cd45ccf,
    0xc006ee390b59d51f, 0x3fa5c6d766d6e260,
    0xc0075d86ecbb6246, 0x3fe91ded5b1280b4,
    0xc01507cc8527f928, 0xbff33df3075d90ba,
    0x40004b98bd1ffa50, 0x4005cd6cde41b18e,
    0x3ff01cc9b3dc8d54, 0x3ff88b2dd040f8da,
    0x3fe9e8a5b422d82f, 0x3ff366a1693577e8,
    0xc00fb9159a2caf7e, 0xc01348211fe19aca,
    0xc00186ddabe9b369, 0xc00071aea6cda1b8,
    0x3ffe0d3fb49f4f65, 0x3ffa0a62d546d3a3,
    0x3fefba223b6f5d22, 0xbfccc4afcce1816a,
    0xbfe3df3f13b486bc, 0x3fee92f398e2d395,
    0xbfcd1b4e0f6e35f0, 0xbff52d506ce4eb36,
    0x400475d3afc551ff, 0xc00f7262c3296a08,
    0x3ff34a3a4d66292d, 0x3ff4c2c2e3c3cf33,
    0x3fdff40c6e57e374, 0x4008ed42d15293a0,
    0x3feefa591696c6f4, 0xbffaf9d395094397,
    0x40045548cf3600a7, 0x3fc2fef7cae267c0,
    0x3ff148cd39dbf043, 0xc0028360973ff25a,
    0x4003a34f767816ed, 0x4006fbc531abc883,
    0xbffe6dec3ff8f5ad, 0x3ff5af7bc1021b33,
    0xbfbcd33903d5d814, 0xbff1c1c61d5254f4,
    0x40134180144d6c00, 0x4007ff42182d8a8a,
    0xbfe5a85f22b0641e, 0x3fe3b72376efd6e1,
    0x40015a576d398cec, 0xbfd8ce21554ca794,
    0xbffd75232d2965e1, 0xbfb5c1f68e182b98,
    0x3ff8c05964f04687, 0x3fcc3f2b4f61df3f,
    0x40056962d8b8d2e6, 0xbfe9266e16361336,
    0xc00d374867a2a710, 0x3ff6985312de3a0a,
    0x4007622d4f90b93e, 0xbfef70344e3983a6,
    0x40029acc4c9d14ab, 0xc00473467551505d,
    0xbffd0155e4e75781, 0x3fc25a63a9473fb4,
    0xbffc5e2b8146d2be, 0x401c3c94174b66af,
    0xc014717763d3c930, 0xc001766a354d2525,
    0xc0105d12c3834b7c, 0xbfbb9bfa747a0630,
    0x3ffa8cb61d105a7b, 0xbfc5ef1fa6617e90,
    0xbfa7357c61f0cca0, 0xbffe8d08364f5a55,
    0xc00d1362d2836bcc, 0xbfedb77b6166526f,
    0xbff201568eef3b98, 0xc0059234d4568b2b,
    0xbfe29371d796c472, 0xbf982f1ee104d900,
    0x3ff04c2f65466c5e, 0xbfb8468af544bc60,
    0x400e444d02873eea, 0xc004ef3fa8a95208,
    0x4002eabd95a409a8, 0x400b1a9a8acc9e54,
    0x40163a04f3fb7a15, 0xbff2791549296010,
    0x400aa0ad5b455b43, 0xc0044f60d8c17253,
    0x3f90cc503bb7f840, 0xc005150f03aeab30,
    0xbfa20a0540ff8a40, 0x401071e0185378b5,
    0xc0096a4296ba3ef6, 0xc00f4fb316eea183,
    0x400624c4127e2c74, 0xbff92c38cfd7e385,
    0x400109590d366821, 0x4004e234cfeaa7b7,
    0x3fe40ad11f8987fa, 0x3fd725a6f2f83c4c,
    0x3fe5a298cbf9b095, 0x4001771f570cec2f,
    0x4005aa2315311532, 0xbff6091dbfaecae2,
    0xbfe68eb361a0e1cc, 0x3fe2e9fdcb21eec6,
    0xc00e401ba4b22f86, 0xc00393ca4841a419,
    0xbff7cbacc1a5f217, 0x40081cabd3e3a8a8,
    0x3fe8408b5a205850, 0x3fe544f6da169f24,
    0xbfe7777a04fce1d0, 0x3fef374ffa4e8182,
    0x3ff292ff1f4dc5a4, 0x4011af89e04072dd,
    0x4002df53bbb167b0, 0xc010183d06f5327f,
    0x3fad890381f01d30, 0xbfe6483f245625e0,
    0x3fe5e11177a950e0, 0xbfc43888d3c4210e,
    0xbfce533db6e46d68, 0xc008cc2fea798124,
    0xc004749e8f26675d, 0xbffd040addb814c6,
    0xbfe7fdca9b1d9226, 0x3ff5d2374825b8ae,
    0xbff6d1439c00d6a0, 0x4000d573ff2986f7,
    0x3fe6886f97866919, 0xbff6ff944aecb99e,
    0x3fe012d2820b8d82, 0xc00c377b28141f36,
    0xbfc3c40e42631398, 0x3ff56923c41ba44f,
    0xbfe7366d31ad7496, 0x4009b0e83e882950,
    0xc00bbcbd522e42d8, 0x3ff1d91e6a45c0cd,
    0xbffc518ffd956f47, 0x3fba8028bd407a90,
    0x3ff61edb216983bc, 0x3ffc94300fb5ff24,
    0x3ffcc13efad69d76, 0xc0126b4dfcc95c7e,
    0xbff90d31621d4c9e, 0x3fcd6325f7120960,
    0x3ffd76e646b8e8fc, 0x3ff26442755f3c7f,
    0x3ff01c88ecbd92db, 0xbfe9986c033d0dc4,
    0x40067cf1f1e32898, 0x3ff20c2db7bbe9ec,
    0x3fe1e172206b466a, 0xbffd5228508a7106,
    0xc00050b31d10b3c2, 0x3ff094cf003a1e1a,
    0x3ff8510f99466a50, 0x3ff46b93b07783a7,
    0x3ffbfa64cb76f906, 0x3ffd341fe862cde4,
    0x3fe70957ab445cb4, 0xbff7302fc584756e,
    0xc004f1aed3f8d052, 0x400d6909843837e0,
    0xc00df08213f46554, 0xc00253c2c7489110,
    0x3ff9d2ef0108cdf2, 0x3fefcdc6924b869e,
    0xbff15597b19d6559, 0xbffb59361b101580,
    0x3febf3d60da1184c, 0x3ffa8c6e4fbeb1f5,
    0x3ffa2fa886423baf, 0xbfea033888bd49b2,
    0x3fba769aaddba370, 0x400640592ad70d9c,
    0xbffd5f1aeaf83ff9, 0xbfed787a36c22e12,
    0x3fc381de83efdfa0, 0xbff9ca8c2cc87336,
    0xc00864c1ca7c0d04, 0xbfe80d8a4ef7a6d5,
    0x3ffe109bcc31c4e6, 0x400318d488321273,
    0xbfd347d339ed92b6, 0x3ff922a69b2da59f,
    0x3fe2b0c65c81927a, 0x3ff96a72ace9ce35,
    0x3fff859d62fce352, 0xc0066969b7da1584,
    0xc00c7df25a3453bc, 0x400093caade9c8f8,
    0xc008326b24711172, 0xbfddfd993e435cbe,
    0x400a32bc1ce65e64, 0x4003cfdc88da766a,
    0xbfc13eae5158c764, 0xbfe73e3d4bc70c5b,
    0x400f61357aab6e2c, 0x3ffd148b8eda28be,
    0xbfddc43fdb8a4bf5, 0x3fd9ba0a92def8d8,
    0xbff1609302063999, 0x3fcb0ceb39ab1ef8,
    0xbff3ba65e84dd376, 0x40056cef34109cd0,
    0xbfc64f7ba9d2d325, 0xbfe263f3a80ce874,
    0xc0084f3ee0b09ad4, 0x3ffa53a954885af4,
    0xbff3ca4f18a87ae2, 0x4009a5ef746e160f,
    0x3ff05d8dbb4ca41b, 0xbfe2cae7208d5598,
    0x400ec1f1c1199dd9, 0xc0155561010f0c68,
    0xbfdd675b9b4bce38, 0xbffbe6ea427847f2,
    0xbfea6c30a16fc560, 0xc0079d4ea2291697,
    0x3ff5dd7f32b22c80, 0xc0009122b503cc45,
    0x4011bb00c5a3ada3, 0xc0041812136f5026,
    0xbfe4573739f507fa, 0x3fd770a40baff4ea,
    0xc0093f4f0095409e, 0x3ff2a8e3ac86138a,
    0x3ff28c9da84b3e72, 0x3fbff74feff8df40,
    0xbff58d5410203b45, 0xbff50bc6c1fd426e,
    0x3ff02f97b6472ab8, 0x40010c45b112b6c9,
    0x3fe809741b37e5a6, 0xc007c08e045732e7,
    0x40109c8d4501d044, 0xbfed1440b6541898,
    0x4014cdb110b0dc36, 0xbff8ef22a3a604bc,
    0x3ff2ed1bd97005b3, 0x3fc435bb4075251a,
    0x3ffde0f3ee34fb7d, 0xc011cfa450b31aef,
    0x3fe02ff77a630dc0, 0xc00d2631dd40867d,
    0x4003b9fd6a831b29, 0x3fe9b9e806dc8585,
    0xbffa47eb41c1c664, 0x3fe96db2f0015be2,
    0xc004c800baf37c3c, 0xbff77d7601b82ee4,
    0xc0003ba4ce933586, 0xc0039a33e71ec4f1,
    0x40066ca5b97487bb, 0xc0105a66d48c1519,
    0x3f91521dbd2c6c00, 0x3fedfba0fb516971,
    0xbfe11a7148d8ed3c, 0x3fe8daf1fab7f8de,
    0x4003a31242f72006, 0xbffb65460cbe7937,
    0x3ff0dc4b3cf58772, 0x400332abb5bbc0ad,
    0x40017d95204005b3, 0xbff8798283ba3f6b,
    0x3fc21fd71e749f20, 0xbfe20d97e26ad5ae,
    0xbff1cf54a8a3103e, 0x40065e2df08a33e6,
    0x3fdd769535bf5270, 0xc008141fd25555f4,
    0xbffb16f24d5ab8bc, 0x3ff7bcecb604a9ff,
    0xc0037db65d1feb73, 0xc0120fd8f227d99e,
    0xc00c6d86e8e5476b, 0x3fe2ae3b54977782,
    0x40029ede5f9fd71e, 0xbffcb6dcd43567d9,
    0xbff53daad39f0dca, 0x3fd5fd87d687d658,
    0xbfd7908c5103e1c2, 0x3fc051f0506282b8,
    0xc000956b2655409a, 0x400c71ee9672f8ed,
    0xbff81e47c076c8ba, 0xbff2dcd7287dbf94,
    0xbffe5052573daeaa, 0x4013f2c60f844754,
    0x3fe71c7cc31b5874, 0x40001905ddc14446,
    0x40006ef39be31b12, 0x3ffad51c51265127,
    0x3fc45f2d18114ec8, 0xbfe8c8ad1ce0dc3f,
    0xbffcb50e7e8f8bfc, 0xbfcbf5fdc706c1b0,
    0xc0076cf12f1e68cd, 0x3fe2c34b8519a1fe,
    0xc0046e868990efe8, 0x3fdceb333ea1d28c,
    0x3fe05cc6f460117c, 0xbfb51f3bd06515c0,
    0xbfec2978ded05401, 0xbff5f6f82863f7a2,
    0x400cae825b38cbd4, 0xc0008ef9166f3bdd,
    0xbfc1786e3ff7201c, 0x40129b88afd4dc34,
    0xbfc6b4fc8ed199b8, 0xc00032ec4d0679c0,
    0x3fe00521c881c43a, 0x3fe3408dd4af7754,
    0xbfc3528018a72a7c, 0x3ff116e601cdd05e,
    0x3ffb6b4b7b5f8661, 0x3fb5f6a357fe1de0,
    0xc003b0c63797eaf4, 0xbfe66d85213eea24,
    0xbfe12943e71dca40, 0xc00be39f077b3b3d,
    0xbff06baea649da1c, 0xbfe9ac27ae194320,
    0x400389d1a6c0c9e7, 0xc004997ef046dc1d,
    0xc0035ced523a3702, 0x3ff2ab07901370cb,
    0xc0106fd42fcc827b, 0x40024e5b577d7cd9,
    0x3ff2e7edd59c4078, 0x3ffff0db58eed50e,
    0x3ff8e1082bd4eed5, 0xc007488e336b376f,
    0x3ff2a6d52e5de221, 0x3fc17c50d593a1ac,
    0xbfdd2a8d07cc9286, 0xbff31bd663bc4024,
    0xbff8f3d896b2030c, 0x400bd4dbeb24ae0e,
    0x3fcd53bb45796170, 0x3ff819a53b18f41e,
    0xbff61eb000207dac, 0x3ffd88c416ca5c86,
    0x400e5333e19b73d8, 0x400028a91e073dcc,
    0xc001ff86435e32df, 0x3ff38c9c835dbbe1,
    0x3fceb132bd9a0168, 0x3fe494ac7c1faade,
    0xbffd29d1934c2829, 0xbffb7bca61b26e48,
    0x40048649fbc7384d, 0x3ff1674f4f1b3779,
    0xbfe01defba4f7336, 0xbff05d3026f424fa,
    0x3ffc090fdc2af9b6, 0xbff7880703df86c4,
    0xbfa2ef928de430d0, 0x400ac12608231382,
    0x3fe8ed0d2b332730, 0xc00d9c8ea07c709b,
    0x4006816af5793e82, 0xbff12b11af621054,
    0x3ff222c585d0ff10, 0x3ffc4c7f0aba4036,
    0xbff163a6d984007a, 0xc00167cd34058338,
    0x3fe05cd9a6bfa966, 0x3fefeb8270cf5a58,
    0x4001ec4959cdaca7, 0x3ff734c14c07d42c,
    0xc012078810f0c20d, 0x3fee77a1aae63f56,
    0xc00b558d43462d89, 0x40100665b20ccba1,
    0x3fc851e4c324b8f8, 0xc0082894841b6896,
    0xc000003e90a48558, 0x3fe8064042af8670,
    0xbff06780104a54e6, 0xc007d167b60dfc4b,
    0xbfe57a034c9a89a0, 0xbfe01f7b8461713d,
    0x3fe8a124903b90fa, 0xc01106fef3776c68,
    0xc001b4e31d0d7bf1, 0x3fe2b19db127bf16,
    0x3fe3df4066f7a190, 0xbff999e51e2ad40c,
    0xbffc9c37b5485f02, 0x4005a107949e13e7,
    0x4009aa5763466635, 0xbfefd99bc70170d3,
    0x3ff425f7229d2291, 0xbfde659463802f4c,
    0x4000fd6b353199b0, 0x3fb175557d5b6c20,
    0x3fcf4c74fd86f258, 0x3fb9f960496e2980,
    0xc004b30aa456d6a5, 0xc008ddbaf7325f4f,
    0x3ff3f775b6c55b75, 0x400ba640aaa54f7a,
    0x4011d0d17a60d1dd, 0xc00733af9e92051f,
    0x3ff6492eb5306836, 0x3fc8c5faa8a85a68,
    0x4001d122743f6690, 0xbfe9fa395c030990,
    0xc003983c809fc8dd, 0xbff044974ab72da8,
    0x40136b17faa6bde8, 0x40021c5152c0e688,
    0x3fc35f6f869d79c8, 0xc0085187d1c455d4,
    0x3fe0dd6139234144, 0x3fd0084eccf2f888,
    0x400c2c8debe3e845, 0x3ff20bce91e84d76,
    0x400629f709693a14, 0x3ff090966fd5eb95,
    0xbff67ead6423be1e, 0xbfd6426624816890,
    0x3ffba046dbbd5e00, 0xbfdded7512b57474,
    0x3ff23ab1716c00e0, 0xbff796e7c92ca788,
    0x3fde3e87aff26c54, 0xbff89399cd17614b,
    0xbfe2506c6dd1c8e8, 0xbfe8e6ff003d8428,
    0xc0026dc4175ecb24, 0x3fc38aa9b0875778,
    0x3ffbc302f40718d8, 0xbfcbc7fda98b0518,
    0x3ffdae5f809541d2, 0x400a2c80a270b93a,
    0x400203e9b78bc463, 0x3ffcb56fe3a2c08e,
    0x4000ec7d34d33ed1, 0xc0008b0945c1b941,
    0xbfeb159791d5b967, 0x3fe2e2ccbf12aa71,
    0xbfe5e3c216dd74c0, 0xbffe33ab06c3ff09,
    0x400ae2e006e0ed58, 0x3fd4db7bcf74da58,
    0x3fe442a633217076, 0xbff1b1cd8eebe634,
    0x3fb1de3a0ec7c4d0, 0x40019a58e285c3c7,
    0x3fd62873dcf92060, 0x3fd4d6be6cd91b80,
    0xbfe7a0de9a1d8d9f, 0xc0081cfaa76d42b4,
    0x3fcb0a024d007068, 0x401119e8fbdb51b0,
    0x3ff6035956b10495, 0xc01c0feaf4116c78,
    0x4001cd1577374713, 0x400349a9a4593261,
    0x3fcd55207407949c, 0x4000c722821ff2f8,
    0xbff762ca65a370ce, 0x4009906b61aa3418,
    0xbff5931979854946, 0x3ff82d32c1d9a8ca,
    0x3fecd42f7d72d70e, 0xbfff1d50657b3db6,
    0x40051058768fe01b, 0x3fa0949a665c52c0,
    0x401049facb9376fd, 0xc00472696ef65a7d,
    0x4004c839c9b59ca1, 0xbfe2677715c07434,
    0x3ff8c2de9ee370c0, 0xbff8271673eb44c2,
    0xc00862979db84e4a, 0xbf98bf393e98c200,
    0x3fd0fd182bee47e6, 0xbfe3e5cdb5045f36,
    0x3ff1c6a5aa96a500, 0xbfe973270d2e9c28,
    0x3fc3b04ab3783508, 0x3ff52a7f41e5f02d,
    0x3ff4b9f2b0dd8a67, 0xc007054b9bda16ac,
    0xbff827c2531ad158, 0xbff4a78f0ac8e48f,
    0xc00e44a8d51efb45, 0x40055ea42df96197,
    0x40139d9db6fdac2a, 0xbfbb8b29700adf70,
    0x3ffda61c26da16dd, 0x3ff7a186901cfdc7,
    0xbff5120b3771982c, 0xc0016d7966af0ae3,
    0xc002cc41cfd288f4, 0xbffdedc47c776014,
    0x40034659308c3b3b, 0xbffd1ec3d07f32e4,
    0xc00c4dde13192e1d, 0xbff6767b9af47932,
    0x400e0f87663b7e21, 0xc008cf46d487bbeb,
    0xc005d93b595e0024, 0x40011236c61cb780,
    0xc005d134fd85d4d4, 0xbfe262c11105bd30,
    0x400d2409afeee851, 0x400a1fd2d4f45086,
    0xbfd77e5414c6ec94, 0xc0026f31f0e6b73a,
    0x3ff0db4947efb2a3, 0x3fe6761cd52536a9,
    0x3ff7b7f05fbe55f4, 0x3ff196c9c60c0ac3,
    0x4002d3fb410b530e, 0x3ff38d2509063514,
    0xc0055a966aa89953, 0x400c6ee47ac4be1c,
    0xc00102fbb3dc7ef1, 0x3ff956897c2eb7d8,
    0xbfab0ad357fe2a30, 0xc01109b336d3cea9,
    0xbff7808e0b271292, 0x3ff74924e2850aa6,
    0xbfa072afc3310720, 0x3fe82091616dac58,
    0xbfb497e5d56a4c60, 0x3ffab09d92be7752,
    0x400b851b8e03a9a9, 0x3fc346f5e7517bb8,
    0xbff2e17d051a1f61, 0x3ffe62cb769316ba,
    0xc003c19b256268f1, 0x4002a68d84faa5e9,
    0xc00676d9d4808baf, 0xbfd429bf434c12f8,
    0x3ffb78fd4fd05d1c, 0xbff9a5b1fcb87afa,
    0xbfd939c35ece0f22, 0x3fd009e6eae38a8c,
    0x3ff89ffa4c606dd9, 0x4013d16b6713d48c,
    0x400ad23d0da8e9a0, 0x3fd2c0f24de2999b,
    0xc00eacca18b1f946, 0x401cb3f76653546c,
    0xc0064c20b4eb2914, 0xbff310a69a4b9926,
    0xbfd28bad68b3eb58, 0x400169b18a5f1f68,
    0x3fffdb802a878e76, 0x3fe47e9f456718ce,
    0xbff1dec04d653a30, 0xbff4fa7e0464d7ff,
    0xbff0860213141d3a, 0xc0033ab3f37f2696,
    0xbff7917477aa6422, 0x3fde8864be906072,
    0xbfe202b31792c978, 0x4015c45a1234bfca,
    0xbfce803889e6bd58, 0xc00023e4a5a68246,
    0x3fe6ff0618bd5b3a, 0xbfdb886301e9c6aa,
    0xc0117dfb68c7ad5c, 0x3ff40b0c968a12b7,
    0xbfdaf48f04f9b0c8, 0xc00087d2a23ec694,
    0x3fe464b0b4abf042, 0xbff52afafe8a300e,
    0xc0064e0a31e58ab8, 0xc01139baecb97609,
    0xc002dea269d9546a, 0x3fe9f329105eaec6,
    0xbfe597d376ab2874, 0xbfc7c6b87f4ae730,
    0x400cd9cf4a1af2ae, 0xbfffd43aede8f656,
    0xbfe82379553e5a0c, 0xbfeb1532cee7a282,
    0xc00542a0d64b4780, 0xbffceab106dc55f2,
    0x3ff9377be59688c2, 0x40034eabd15c7519,
    0xbff8be7a0fb0668a, 0xc01a33cbb284aa52,
    0x3fdbbaa2be45873c, 0xbfb49c3a0a852960,
    0x3ffce58e739df18a, 0xbff2db4a74840f6a,
    0xbfb1ad5c032fa790, 0x401a65bb4bc37df3,
    0xc0058198b429af76, 0xbff01bc5b5fe1362,
    0x3fee57bcf42efd6a, 0x3fe35b39c6833db5,
    0xbfbdc13c66a27fe0, 0x3fe27e9866d049e4,
    0x4015a77c2f4de324, 0x3ff1a480f359c419,
    0x3ffb2f929ac4fb03, 0x3ff255a7bd691900,
    0xbfe1e809b11a6d50, 0x3fcb20c12c6811e8,
    0xc0047e30072bad8f, 0xbfe0df4b86f92eca,
    0xbfccb93a9fe51828, 0xc0047ef3d3b92001,
    0xbfedcbb16b591404, 0x4010903859f42b2b,
    0xbff6024fa203b87a, 0x3feae14d9e4bddca,
    0x3fd086d2dacdf66f, 0xbff8bcd59f0e44c0,
    0xbfd81ad424841daa, 0xbfd488f5d214f0f0,
    0xbfe08370d197784f, 0x4003958a28460bb1,
    0xbfd81e60032beff2, 0x4006630a4660c58f,
    0xc00859f443c1c599, 0x3fa9761e152e4060,
    0xbfbe48b3a52d602c, 0xbfefbba3fd1361ce,
    0x40009d6d1e11b0a0, 0x3fe34baa6246128a,
    0x3fe39a7a5e10f215, 0x400ecaea6c795df1,
    0xc010caa47d741ab2, 0xc0156ece9d480f12,
    0xc0105c9e3012824d, 0xbfe1401da0e60664,
    0xbfd6275bf0fddef8, 0xbff30f79fbdcf4be,
    0xc00a951e599655ab, 0x3fe5bd69f9af865f,
    0xc00d1e70a94247da, 0x3fe0237564a10bc6,
    0x3fb1609cc3621c10, 0x4002ebe086c20e82,
    0x3fd0116fa94e6554, 0x3fd7e41921cd13d8,
    0x3ff8a424cabb2b05, 0x4001474b4a174437,
    0x3fcf578594d94b20, 0x3ff65e9d3bca9bc0,
    0xbffb3aead3983144, 0xc00d10274783c08e,
    0x401490ab34dce537, 0xbfcf83a37414f81c,
    0x4019ba2497b495d4, 0xbfde08d7b8f7c6f4,
    0xbff82c5c8006304d, 0xc010d98778d5a7f6,
    0xbfb7b3da970dd900, 0xc0053a28139331eb,
    0xc01919eab419af76, 0x409661fb2a20188e,
    0xbff667c113066cab, 0x40052da18cbbc66b,
    0xbf970620ebe33400, 0xbffccc15a3014997,
    0x3ff82c5cf1ea2ec5, 0x3ff7742baf0389a6,
    0xbfeaf2e6e18c6475, 0x3ff62e4cf62c5e3d,
    0x3fd432b88e428f10, 0xbfb8cfa376b60780,
    0x3ff3ce0c8c5603ac, 0x4003824c5a0df244,
    0xc007d39597144be6, 0xc0047f8aed5d8d36,
    0xbfb30c5ea6ecfa84, 0x3fff0ae7344def04,
    0xbfff21f27d4286da, 0x3ff0e6b1944b97d8,
    0xbff9ab71aa7d522e, 0x40112fd495366a82,
    0x400354f90c57b279, 0x3fe3db3f1b5dd694,
    0x400a3e5e2f08ed0e, 0x3ffb26a9b1206c9c,
    0xc004fb8dff907b02, 0xbfe0436e8ca190b4,
    0xc002cb094baccc25, 0xbff6fd40832654a2,
    0xbfd677c74515b308, 0x3ff6246c1e19771a,
    0xc0079faf6b00488f, 0xbffa91da96c45f1e,
    0x4010ab0b641a2dac, 0xc01082d1d7136abb,
    0x3fdd2aa433b31110, 0x3feed3813acdd23e,
    0x40008c5cb7ee9892, 0xc004215e91b4351f,
    0x3ff493be9fae43ad, 0xbfe59cdb71a3a38e,
    0x4004a26ef1ecc99b, 0x3fe6db287c73e4e0,
    0xbffc09c8a950931a, 0x3ff48980e18786ac,
    0xbffb18c878e34ce6, 0x3fd93d3082f9706a,
    0x3ff245959d6eb9a3, 0xc001019598c15286,
    0x3fee2fb7884d88c4, 0x3ff6c09b61468566,
    0xc0020f86fb73ca32, 0xbfe2331dab1ab14c,
    0xbff0f7442566040c, 0xbfe99dabb46a9f6e,
    0x400536bb4ef8d326, 0x3ffd35bf733ee599,
    0x3fe6442302706fee, 0xbfd73bb4b02b2b58,
    0xc000940b3ce262e5, 0x3fef8e0581a87ae0,
    0xbffa86fadf12ead8, 0xc01033b0902e2ea6,
    0xc003dc498b4236bb, 0xbfed0f5f6dc2eb95,
    0x3fc762b984bf7ff2, 0xbfe185f2bf5ce1c1,
    0xbffe64d75ed937d6, 0x3ffa28642743d31a,
    0x3fccb82d0115ac80, 0xbfe9e2758aca3f0a,
    0x4004ec28b5ee2fbe, 0xbffd34531b004324,
    0xbfea8228afc0b5c6, 0x400187e6a2e8dfb0,
    0xc00996b0110daf9a, 0xc0018731c34539f5,
    0xc00d7e5aa3bedf9d, 0xbfee11a637a7ac0f,
    0x4000a14fe8853fcc, 0x3ff3ad1cfeb98c53,
    0x3ff3120df4787b3a, 0xbff3127edd538bca,
    0xc00eb310f6e863ee, 0x40044f1ba8212c6c,
    0xc003fbe8eb5bf5f0, 0x3fd1fbd2532e25c4,
    0x400863c522b50147, 0xc006a89753df3571,
    0x400303af85ac93b0, 0xbff63e7557c84a1c,
    0xc00422748020565a, 0x3ffc1838a8e58b39,
    0xc00173c4d2b78841, 0x3fe436a5ab95ca71,
    0x3fff4c3a7853b904, 0xbfeebdd73fa3e81a,
    0xc003802135422f5e, 0x3ff1c4414098ebf6,
    0xc0048ca6c03d964a, 0x4016d788452946da,
    0x3fc583a312b170bc, 0xbff729fdc6551fa4,
    0xbffae439faa4f37c, 0x3ff77cb39389f18e,
    0xc005b1eb592e1166, 0xbfdf4ad0f5b30502,
    0x400f7f6b404d2e09, 0x3ff3e3f4b43bc5a5,
    0x400220d1a7597092, 0x4011eab947799dc2,
    0x401114e2729f5bcd, 0xc009edc52e62e886,
    0xbff756a5c9f56718, 0x3ff67715be989c97,
    0x40120eb2b60b84a4, 0xbfe80b62efd8484b,
    0x3feebcafcfac4c19, 0x400c1e5827fcfc80,
    0x4007520f20063033, 0x400875738e1f4a5d,
    0xbfd53edc8a4f9662, 0x3fb543949c284a54,
    0xc007daea678c94da, 0x4017e2ec0b579ef2,
    0x3fd48ca43836cdfe, 0xc010569cd8519a52,
    0x3ff7aa4c2dacdcc4, 0xbfd94ed03c7674c0,
    0x4002163c1d0ba58a, 0xc002932df46a1fe4,
    0x400ec7d9f4a58aee, 0xbff40bac22fc8bf4,
    0x3fbb72ae501768c0, 0x3fa5a4668b08ce80,
    0x400223bc4eced590, 0xbfe7abdd8bab8417,
    0xbff7172eb4c1b863, 0x3fd184e8f10e0a1e,
    0x4013ba52f2759e8e, 0x3fef0e74b61b5d0e,
    0xc0059386ee3e5175, 0xc001972d598050a2,
    0x400ce896356c6e27, 0x3fe79db602068920,
    0x40004fd6014307b6, 0xbff1e0e94d91e12e,
    0x3fd329e99c1c310d, 0xbff21b7bd784e8ee,
    0x3ff149101ab5822e, 0x400b05da19002d0e,
    0xc007a88cddead8fc, 0x4003bfdb0e32966a,
    0x4016b848363f8597, 0x3fd398041fb2b80a,
    0x3fe1ee78b1002019, 0xbffdab260a0093d9,
    0x400382b2f78fb892, 0xbfe3091f19751985,
    0x3fee0a0b1d55160b, 0x3ffd86272c649f7a,
    0x400713e860e403b2, 0xc010e7d6fd4fcf20,
    0xbfd9b05d07317058, 0x400ece112f035cba,
    0xbfb56aa70c9cb690, 0xbfcbff6bb9050edc,
    0xbfa8f22d26cc89c0, 0x3fe76e454bc3e7e0,
    0xbfe4748210e3ed68, 0x3fe3c3a8260a6f0c,
    0x401531cb819f042d, 0xc0092585225d6b14,
    0xc0116885c305654e, 0x3ffdbecea85b07fe,
    0x401838f5395db66d, 0xbfcd791d54e40e48,
    0x4012da56652b1350, 0x3fc9301004fb9a90,
    0x3fda50f337e6def7, 0x4018bbac0b652bfe,
    0xc003b554018fc653, 0x4010f5902c34ed19,
    0x3fb20bcc6346a018, 0xbfce6f3ed18afab0,
    0xbff39d96cb473946, 0x3fb5f6e2c3912910,
    0x400787b200071c25, 0xbff3b1b1653f464a,
    0xbff986bfd16be2ac, 0x3ff9842ee0869abe,
    0xc00cca00ec70cf0a, 0x400570bc5b5e1ff4,
    0x3ff0a45992346476, 0xbfd0602474e0aada,
    0xbfe564270f4575ba, 0x3fd92e54a9eb2c38,
    0x400f1a732fd96706, 0xbfc0948f8908f640,
    0xc0139d2bd1d00bee, 0xc00078d228b9a0ff,
    0x3fd4c18221cf258c, 0xbfb184d0c821e338,
    0x3fee543059b8e7df, 0xc003babe8d4026d3,
    0xc004f5fc71d49035, 0x401305bcba58ae96,
    0xbff05c98c207de15, 0xbff6ccf51a5416ba,
    0xbff265f5cec8b31b, 0x3fff1e74141b45f0,
    0xc00aec64c1f04fb9, 0xbffd1db85af74fc4,
    0x40060450a350950a, 0x3fda759feea4ac88,
    0x4000a410987099a6, 0x401e15a0a5eb8024,
    0x3febfa5a2db11d24, 0xbff5a917d9f69096,
    0xbfd444a58350c637, 0x401410f6a460f74e,
    0xbfd745baac75db10, 0x400faaeab7342ff2,
    0x3ffc802d75a4a2ea, 0xc0131f5476797329,
    0x4005efe18d21816d, 0xc00625e3ab091011,
    0x3ff2f5b15cc53d11, 0x3fb04e7a70b2aa54,
    0x4003d53f51f04be8, 0x400f01110f270cb6,
    0x400351a03f40924e, 0x400aee6729daa78a,
    0xbfc30fac231e81c8, 0xc0013392ffd3a751,
    0xbfff2525854a84a6, 0xbffc0cbfeb723830,
    0xbfd500ced242f378, 0x3fd8f15678719d82,
    0x4015304ce2378331, 0x4008fcc2a3ca008a,
    0x4002a7ba133df790, 0x3fe8464943a3877c,
    0x3fe7126ce18bf2f4, 0xc002b621114be155,
    0xbfa805c31bfb3b58, 0x4000c06786ed0bc1,
    0xbfe2d39ac8d9d81a, 0xbffe58793b62e5a4,
    0xc013d86639f5d05e, 0x400f49f78e37a236,
    0xc00b569b53235506, 0x400ab2958d3717bf,
    0xc00816f72bf3cc41, 0xc000a40692ca09c2,
    0xbfe02558c9d6d654, 0x3ff04bafa49bbdde,
    0xbfff077bdf40eca8, 0x400846065bc2281a,
    0xbff27562e3422df2, 0x3fea4243310610ec,
    0x400cb42b52eb98d9, 0xbfcdf0feba3225b0,
    0xc0099c610cf85cb7, 0xc0112e1f53912815,
    0xc000b676501e6301, 0xbff5cf09bc5899d6,
    0xc00b678d88a0b55c, 0xc004db708accaed5,
    0x3ff4cc0ccf10431c, 0x3ff11f4ccb29c6ce,
    0xc01e0869e000ace1, 0x40036538bf8f7250,
    0x3ff216755b966801, 0xc0019a9932435eee,
    0x3fef5647ed6da74c, 0x3ff77aee1cc0edac,
    0xbffed74d9efdbaac, 0x3fff8ffdadf187cc,
    0xbfee7aa68385aa12, 0x4007e012500c940f,
    0x3ff787b3659ee5f4, 0xbfe60ea0010ae000,
    0x3fe1de3a61f62cf2, 0x400dddf3c644cc08,
    0xbff3cc3b9dbd026a, 0x3ff2412e4903a504,
    0xbfe5fd7e4e9bac36, 0x3fe0a421afe8f70e,
    0xbffb066a9371c231, 0x3ff5aaad6bf45e29,
    0x3fe424baf72ba561, 0x3fce7bae9c6821d8,
    0x4006f2769779ba1e, 0x3fef90333dcaa03e,
    0xbfe2a6ee626bc0e7, 0x3ff4fb2300401559,
    0x40118f59528c76fa, 0xbfe56114f502712f,
    0xbfddbf8fda2e7ea8, 0x3ff50cc80f81a664,
    0xbfae923612b4b630, 0x3ff9c6951ff15ffe,
    0xbffa43d237aba7d2, 0xbff7104c2095e5c6,
    0x3ff538d4c7c7cec4, 0x3ff100ee79ec1535,
    0x3fe4bb764baf9136, 0x3fc9f07caaca8c10,
    0x40045a21edd91470, 0x3ff6114ef81a26fc,
    0xbfcc5d44b6306152, 0xbff1b886a9994dd3,
    0xc004ca7ae5e1a744, 0xbfcc8cd169be09f0,
    0x4001837c36350449, 0x4009268290ff8f5a,
    0x3fea5264739d20ae, 0x3fe2483b01cedae2,
    0x401512718f65c33e, 0x4003b142cd53da50,
    0xbfe2a7ece143ff5e, 0x3feebcbf1ba848c8,
    0x3ff5c8def951af19, 0xc00443cfb41c5d4a,
    0x3ffa0fc5111db996, 0xc000cf717ee37f5b,
    0xbff510985b91afbe, 0x400d457b73ec156a,
    0x4004fa4b8b8603de, 0x3ff5edc9af040e51,
    0xbfbc307a1c5c3280, 0x3ff233628887f62c,
    0xbfd960fb093f9a5c, 0xc00579a8936af0c0,
    0xbfe7a1de064b8755, 0xc00c9a00a486b9d4,
    0x3ffcb3709c7442f6, 0x3fe1027889a4020d,
    0xc01cc983103bef84, 0x40168b87e27645e0,
    0xc005afd77186fb63, 0xc006569ef49e7dbc,
    0xc00461582c32415a, 0xbff55c529976534b,
    0xbfebf110d405b67e, 0xbfb874eb51d93a90,
    0xc00585ae0fda3586, 0xbff196284dc0db78,
    0xbffb65945b7d0316, 0x400f5218ef536082,
    0x3ffcae02e0a319c5, 0x3feb319bd368c1a6,
    0xbffcf49f3acb8ed8, 0xbff4aedc898f0a7e,
    0xbfe59fcdeb84e927, 0xbfc65ac63dd9d1a8,
    0x400eae9903517f20, 0x40077de9b802e616,
    0x3fedf771399ae096, 0xbfecd890c79f3eea,
    0x3fbca838cbbbacd0, 0x400d437e15f5fed4,
    0x3ff06d5854182dea, 0xc00467c6bbe21981,
    0xbff79413bd969c20, 0x40118ce764e98de0,
    0xc003a3c08eaca30d, 0xbfec10febc7b8d78,
    0x3ff040048edb5b8b, 0x3fefa80b38f76cc3,
    0xc004a21e9c6228e5, 0x4002c061c8463c95,
    0xbff26eb1b435ae1e, 0xbfef6e7bbeef97b5,
    0xbfff314570f6e354, 0xc01c43f667cb5033,
    0xc0068d8592e06dc0, 0xc001298279c76878,
    0x3ff5aeff64aeabca, 0xc0166cbef49a8288,
    0x3ff0193a2a1f8b13, 0x40165f4b53e5dae0,
    0x3ff75cb43afed7ba, 0x3feb0e2b9b2b162c,
    0xbff768bd50902f24, 0x3ff19d2adb1e73b8,
    0xbfd7334389913260, 0x40023fd1402c8474,
    0xc008c0a500d5d957, 0x3fde7256bc35bc32,
    0xc0132100c2fc1474, 0x3ffebc43439a4b82,
    0x3ffe067df256cd34, 0x3fd56d3807e83896,
    0x400163c392fc2106, 0xc00a5f7234e25064,
    0x4001aac6d88f5421, 0x4007d186e42e8e16,
    0xc00948fe4ac992ee, 0xbfee150ffd53fcab,
    0x4006c6d541ea2422, 0xc0019ef3ee33a74e,
    0x4012970709eaf494, 0x3fcec7668947bdd0,
    0xbff672a9979abc06, 0xbff8c2c1e4920a70,
    0xbff3f615b41eee3b, 0x400175b590291939,
    0x3ffb572488ec83e2, 0x3fcae67480d2e8d0,
    0x3ff161c4429f0b7a, 0x3ff771e24cf01826,
    0xc0045dbbf1118b15, 0xbfed3801f7c2fcda,
    0x3fee967c7b736290, 0x3ff25d86bd513d90,
    0x3fd6ae4574fd37ec, 0x4001f8f933b6f42f,
    0x40019fbe5a27d97a, 0xbff21806386e1604,
    0x3ff3e2ac063a1483, 0x3ff06ce0c929d07a,
    0x3fe53a8d8b545713, 0x3fda281be61e6d32,
    0xbfb04ae53a485de0, 0x3fd617ec18109952,
    0xbff083eba55bdfc4, 0xc00badf35fccfd0e,
    0xbfd096c4106b0e26, 0x3fe73620c85e73de,
    0x3ff4dddb45053f62, 0x3fc98b6915cddf88,
    0xc006e97e7627bb45, 0x3ffe3d510570ec28,
    0xbfc7953077b01ba8, 0xc0007a9a6bf77c2a,
    0x3ff1f9babd06bf1c, 0xbfdbec1c338d1eae,
    0xc0146917bed300a4, 0x400dbbd176e9b41e,
    0xbfdeab590407deff, 0x3ff8af4b853a05d8,
    0x4003f6c32f3f480d, 0x40074276711e5ca1,
    0xbfe0c30c7e2e90bf, 0xbfdc4d968b06856c,
    0x40089ffaf0d82914, 0xbff671d6b7dbc454,
    0x3fffecdf1891c9c0, 0xbfbd45beecac7650,
    0xbff430f0ccc1b64b, 0x400ca68d5afcaf63,
    0xc00fcea59ee8477c, 0xc00c93e75315157d,
    0x3fd3806540b6f438, 0x4007af8403ebebce,
    0xc010804a05b8322a, 0x3fccbf74b51894a0,
    0xbfc018e36fdad89c, 0x3ffbaecce77a2846,
    0xbff8b9953841a64c, 0xbfe6722805c4a956,
    0x3ff1210290983664, 0x3fd7b49413c6f59c,
    0xbfe5fa152ffd0cce, 0xc00edc4b4423e58c,
    0xc00460210516627a, 0xc00433f7f8497968,
    0x3fff637e0f5f0d22, 0x3ff3c87d638250c8,
    0xbff8fb97f14a95da, 0xbffa43301fa7ece8,
    0x3fdafda654104721, 0x4009810b27f2beba,
    0x3fb145ac2d7a4e58, 0xbfe619b06d4105c6,
    0x3fe81560acbb8dd4, 0xbff88265534a9964,
    0x3fd13513fd36bec4, 0x3fe91f50fbd67c4c,
    0x3ffefd038fb80ca3, 0xc003c86d9ae79a15,
    0x400e2661b4ee0ef8, 0xc00d7a05c44c1989,
    0x3ff6171463035401, 0xbff49774e2810cae,
    0xc00ee154a1a426e2, 0xbff9fac2c1af387b,
    0xc01932bfae2afdb7, 0x3fd661a77052955c,
    0x3fb083ecff18f540, 0xbff9c4ab9f0b24d1,
    0x3fee82b92a063f8e, 0xbfdd832c97b91cb8,
    0xbff2d375fec62d54, 0x40001add489cccc6,
    0xbfdb4d8cced35dce, 0xc0104b78a050e872,
    0xbfe43d612952f183, 0xbff5d80e7a93b2cf,
    0x3ffaa8aaa94adcc6, 0xc00db96b387fa8fc,
    0x3fd5b17fbd2f8c3c, 0x400ed0ebe9a8ef55,
    0x400a5665149c395f, 0x4007851c3d1fe802,
    0x400f63ac68726f0d, 0xbfefd9996bd00f9c,
    0x40115c4058d0a323, 0xbfed52e1fbb837da,
    0x3fe632d4fc7b3b06, 0x3ff3edd26227f674,
    0x400987d6b33ec3d0, 0xbfe7cc75dd5a5ee6,
    0x4006072dd3d9f63a, 0x3fe1c2460698e3b2,
    0xbffeeef5d0d7dbfa, 0x4005a2edefa883c2,
    0x400a3e90f776265d, 0xbff96eba3e881bee,
    0x3fda20510826517c, 0xbff2cd7010816bfe,
    0xbff5a91534307d21, 0x3fda2e1d8e4a33dc,
    0x3ff25e2994f8707c, 0x4013e9fd65d749c7,
    0xc00a8f81204da6ed, 0xbff208ffd2cd1844,
    0xbfd4fd21f182da54, 0xbfd5020125a91a08,
    0x40007425bff897ac, 0xc002f50756c04e0c,
    0xc007837237b32ec4, 0x3ffe2002c5ae3391,
    0x3ff0edaec9868248, 0xbff9d370f36cc2b8,
    0x401174130a2e1de2, 0xc0013886729a856c,
    0x400382861797880e, 0xbffe5b28af20ef82,
    0x4014bd40ca6634fa, 0xbfd787f6cfbc6f4e,
    0x40086c69cb14220a, 0x3ff27815d25eead2,
    0x3ffbde638a8f5bf4, 0x40053536ed13a040,
    0xbfce397a1d7a70d0, 0x400f89d780cf8564,
    0xc006e7d0fe40bcf1, 0x3ff3e45d04e0c9f0,
    0xc002ee0d305ae738, 0xbfff41491d5324b8,
    0xbf856ad75baa9600, 0x3fe2fee6d2306986,
    0xc0033f727d14b9c1, 0xbffdf4096c7dc9ba,
    0x3fb963dc507e7c40, 0xbff50eed791014df,
    0xc000b8cc4eb47fac, 0xbfe02cbc8de8fdd4,
    0x3fea8ae38da8b633, 0xbfc718b86d2b6a90,
    0x3fd75afe261531ce, 0x3ffac2b9bdb6e852,
    0xbfd6c1227868081c, 0xbfe10ab582f6a876,
    0x40037814ba734e6c, 0xbf5893cede09ea00,
    0x3fe19f115878b35a, 0x3fe0cbc3e4e767da,
    0x3ffabee05eb778dd, 0xbffbb07717abc27c,
    0x3fe4c929b2eb978e, 0xbffe38a037126a64,
    0xc004da65d3cd0128, 0xbffa20a00bd9db9a,
    0xbfdd08b14c046dfd, 0x4000c0ed043fda44,
    0xc00544aaff5bb369, 0x3ff5cebde63e2162,
    0x3ff3293bf5c19ace, 0xc009aae2a5d8d0c3,
    0x3fddab266bc783f4, 0xbfea0aa8eb683726,
    0x3fca0b59bdc1f4c0, 0x400e16016cab8bef,
    0x3fe5c7293815dd1b, 0xbfb5cea3210e75b0,
    0x3fe246b844588a62, 0xbff3d8d420f6014c,
    0x3ff6d2535dc31681, 0xbff9a4d6e6186376,
    0x40013e58b3ea190d, 0xc010cbaac646a555,
    0x3fd17b981a1389f4, 0xbfef2229a5f9f975,
    0x3fa90fc7514eb4a0, 0x3ff6e62dbf0c6574,
    0xc01312cd5fb42d1a, 0x3fc656614f41feb8,
    0xc005416af2609a00, 0xbff938d6c8bf60b6,
    0xbfd170821accdfa4, 0x400c0e45dd45aa07,
    0x3fe08586f78cd69a, 0xc0008cc2daf75915,
    0xbfff5909432fbc62, 0xbfa50bc485c20ac0,
    0xc0014dbd72faa607, 0xbffa6d5dd1cb503c,
    0xc0078e43a65d70ef, 0xbfff38a25b01b86e,
    0xbff42029dd34ef24, 0xbfdf2262b7e342bc,
    0xc00ad62dc706c3a8, 0x3fd425f4e9a51e1c,
    0x3ff582a7d9904ef6, 0xbfd97eaae0dfe138,
    0x3fed00903aef4bdb, 0xbfe6f77dc0efddac,
    0x3ffa29fab7c953fc, 0xc0060014b45f1bd4,
    0x3ff8315f8c838e53, 0xc009900e232011ba,
    0x4000914f865da3f2, 0x40118920eb7f416f,
    0x3faf297a5d9aade0, 0x4005466054e3332e,
    0xbf9f655f1f162720, 0xbfdc282df2c9cb14,
    0xbfe9186b45e8f3e6, 0x4004521f33a27d10,
    0xc00dbc5bdd6456b7, 0xc001f27a8b39b6a8,
    0x3fd342d1a3b8565a, 0x3fff12182425dc03,
    0x4008eae9b8d90e57, 0x3fd65ee0a22ef8bc,
    0xc00a9b5e6a523c62, 0xc00bd9eff45fc758,
    0xc0064c461c4ade89, 0xc000be43b0968e48,
    0xc002536f9cb5e0e0, 0x3ff13925d0cd126c,
    0x3ffa4d02df810288, 0xc0043cce6b000f26,
    0x40075957b79a24d3, 0xc00446d17f8a4ee8,
    0xbff97ff4b9268f14, 0xbfa2cba1c9768ae0,
    0xbfcc20d4efcc83e4, 0xbfff6c1a3ddce4df,
    0xbfe31d221cb951a4, 0x3fe74cb78cce5b56,
    0x40035c1b6a2727da, 0xc001381fd583d025,
    0x3ff8abb723b784ca, 0x400b6bcfdfe28961,
    0xbff4c85643a39e60, 0xc0165ff1ef85264a,
    0xbff04b24605c7ba8, 0xbf68941b8e789e00,
    0x400d229d295945ba, 0xc00092dd570b3713,
    0x3ff155efa90a7bec, 0xbffcb9eb52102dbe,
    0xbfbe24c7b4cd2bf0, 0xc01143970dc6155c,
    0x3fe231cdee7967f0, 0x4001cdee2953eeb8,
    0xbffd9428d27106b6, 0xbff6d995228a2904,
    0xbff45b4ab46f2962, 0xbfeaca7eed9712ac,
    0xc009df948c2274c3, 0x4003e192ef6d3e80,
    0x3fdbdaa3db77a59e, 0x400155408e75ff0d,
    0x3ff48df5f20e438f, 0x3ffe7e7988b987a7,
    0x3fa0c83f077dc3e0, 0x3fefe81d4bd171b4,
    0xbfa6716316c233c0, 0xc009a57928524f00,
    0xc00b45ed9535b8fb, 0xbf8513297e953880,
    0x3ff4674b595e74fc, 0x3ff6330a65e82818,
    0x3ff13622e83cd2ed, 0xc000d8acb828c448,
    0xbff43c68d741e69a, 0x3fe9ece15a072a80,
    0xc003d58ffb8a1d54, 0x3ff08ab2ccb9d7fc,
    0xbfc8d651586d1650, 0x3fe0c258e4918548,
    0x4017d1d3c9da926f, 0x3fd68562fc8a6ca4,
    0xbffff76994602c48, 0xbffce79f21d1c278,
    0x3ff1d7f9f4d073e9, 0x400bf5a065c7da8a,
    0x3ffed5cec9a041f0, 0xbfdfe59187d51e06,
    0xbff50e0efafba13e, 0xbfff2c6f8d10873e,
    0xbff57ffa50a2644b, 0x3ff2ca1dfe7d7fbf,
    0x400865cfcd9f1b5e, 0x400212e16f70eba1,
    0x3fe71e5389b562aa, 0x3ff8e28b06290f31,
    0xbfbd1f93907c2de0, 0xbfea293398d7c54d,
    0xc00c4f27dd02ee34, 0xc005190e75a6b935,
    0x3fe1154226cd1ef1, 0xbfc63ee85d50d866,
    0xbff2d521c0e6bcc7, 0xbfe095dd52a80477,
    0x400ee37288fea35d, 0x3ff1573c40aa8ad4,
    0xbfc510d37533d5ae, 0xc003684d7743b02a,
    0x3fed990e9cb274b3, 0x3ffa600dfc18c755,
    0x3fe5d2b2f1bfa6ee, 0x3fd53a709faa0b8e,
    0x3f97ab573a2d1740, 0x3fec5d32e5a6bdfc,
    0x3fecac3b97363f04, 0xbff8d67b8283db04,
    0x3fef247f10d3fcc0, 0xbfd3bb8d209db440,
    0xbfcdc89b7a4f3c70, 0xbff8b0be8f24f364,
    0x4000b32ef97af6f2, 0x3fb25f1038a4e770,
    0x3ff57c9cb36dc930, 0xbfc442e80ca3f4f0,
    0xbff09d6290e6f2e0, 0x3ff6615dd5248f74,
    0x3fcde4882a539b9a, 0x40057c7470cbd982,
    0x400eb20c90427f2a, 0x3ff57b14a1abe213,
    0xc010da54ee8c093e, 0x4015d4fe86cc583c,
    0xbfe7366c6d947dae, 0xc003d4ee617a1981,
    0x40134a206c38150f, 0x40044e2e5df35980,
    0xbff34ca3372619e6, 0x3ff0254389815214,
    0xbff342a20a4d7992, 0xc004a12d79c0408a,
    0x40089d0334444430, 0x4001a0efe9a27bd7,
    0xc011707ca2566f18, 0xbfda6b9773609828,
    0x3fe54d28ed25edda, 0x4005b3ae78920628,
    0x3fb0ad66baca88f0, 0x3ff34c5a3c17239d,
    0x3ff569391917bece, 0x3fb7551b1aa95cd0,
    0x3fec46fbc7c6eeb8, 0x400f9739a51fcf9c,
    0xc0011c153e610282, 0x3fe8fc4737cce8da,
    0xbfe15b0776c90bee, 0xbfffc55346697a63,
    0xbffca9bdc194952e, 0xc0130444a0e411b1,
    0x3fb60fcee2b74470, 0xbfee15fc32908eca,
    0xbfc98c60e1083918, 0xbfdc21a362805e3a,
    0xbfe01414a89a9350, 0xc002eb16781f0b6a,
    0xbff46b2273b05c99, 0xc00d0ef40d5712f6,
    0xc00f5fb2f5d48b98, 0x3fe341d9d480ce65,
    0x3fe2dd6b39f9c99e, 0x3fe271cb29968b42,
    0x3ffeaa29cdf081a8, 0x400f4486fa56a8e2,
    0xc0043ad540cb7242, 0xc010234a1db10abe,
    0xc0023993c60fd50c, 0x3ff0c52e01d19276,
    0xc001b7b377c6d93a, 0xc00888d957360262,
    0xbffe163614251f2f, 0xbfe5ae4a262c2e37,
    0x3fffe9970df9bff9, 0xc015e17bfcbee669,
    0xbfe1fa1ea69f0fd3, 0xc000685dc1913f75,
    0x4007d2f07d73c643, 0x3fc4a27fe8bef0c0,
    0x3ff710936ee41b05, 0x400b7dea643edb42,
    0xc00e71e3ab1ac6ef, 0xc001f4377581ce40,
    0xc0039a2fef64c234, 0xbfe9043bf7584c48,
    0xbffbaf1a18b82e6c, 0xbfdff6235a1c9d14,
    0xc0074e15fc1070b3, 0xc01b7b0a8416904c,
    0x3ffc798b080e903a, 0x4017b5af7f4add39,
    0xbfd0caa6d1553fd0, 0x3ff219a0e58a4aae,
    0xc009d2ac85c7bee9, 0xc008e8486d47d15f,
    0x3ff562fc2ead129d, 0xc00139898086f3c1,
    0xc00758b15fd94a24, 0xc00176fa55cfe73e,
    0xc006f3c509a2bdef, 0x3fd3d360eba2a089,
    0xbfe0aca4d8a16bd8, 0xbfca9ec8f24cf69c,
    0xc00119a6db0b987d, 0x3ff99e0539a9fc08,
    0x3ffd429c8e81d2ba, 0xbffd369d16b8dd8c,
    0x3fc38adac9644468, 0x3ff29f7d17b52113,
    0xbff32e34ef2e2a26, 0xc00051b65ca6bce8,
    0xc005bbd8950da913, 0xbff906a905312301,
    0x3fca959d60f06e30, 0x3fff4bd0d58db400,
    0x400898a00785071f, 0x3ff60ce4a63304f6,
    0xbfff3d57c3bc6233, 0xc015d4fb17677b12,
    0x3feae7f2cb24d3a6, 0xc0079acce85984b8,
    0x3fb449e7dc53d520, 0xc00e8b09e49fd89a,
    0x3ff1675489940138, 0xbfc94df69b62addc,
    0xbff76741785b883a, 0xbfe53278fb7a8570,
    0xbff464b7ef2538a6, 0x40049cd89364dfef,
    0x3feeb65ec522d85a, 0xbfd933feda9bf317,
    0xc00261dbaa3f6088, 0xc002d897d3334a1c,
    0x40091b09c1ed98ca, 0xc002c4c63a2b3c7b,
    0xc013d55fbf93efd9, 0x40110c4fa3d35ac0,
    0x3ffac0a970d14d27, 0xc007dfd6cee7f49e,
    0x3ff7a9977442880a, 0xbff566a6a6c620fa,
    0xbfe7fe11567070d8, 0xc005e07f7f427c82,
    0xc003fac79b59ba8c, 0x3fe0c8e461cbad4b,
    0x3fee1bf14e774064, 0x3feb376a4b1be882,
    0x3fc495cb241c7600, 0x4002a64793942d97,
    0x400328a776b8bcf4, 0xc00585b56f9d457f,
    0x3fe49b3e9f492218, 0x3ffb78e133ef69ba,
    0x3ff85340bc330f88, 0xbfe4fe1d840ea17c,
    0x3fe0c42b9df6d89f, 0x40088ea854cff530,
    0xc00cba2e8a70fe98, 0xbfd67f068ecd1fae,
    0x400e420acc04d88a, 0xbfaef16261c18e00,
    0xbff91d1e890078da, 0xbfcefea70c7a858c,
    0xc018170930d5f952, 0x3ff511d1e4b4b172,
    0x4004cfcbd7bc2486, 0xc008886d979b7140,
    0xbffe21244ce7391c, 0xbfee739ed63f9054,
    0xbfec4f8a72f1d88e, 0x3ff006f4f1cd0b5f,
    0x400aa061c9c32345, 0x3fbf9ce6ed0ae760,
    0xc0048296915c02ee, 0x3fcac6c6cde7bc78,
    0x4000d40c65697d8a, 0x4002744d80601e42,
    0xbff5400031be02d1, 0x3ffb486bdb12a179,
    0xbfea6869a1d48991, 0xc000c3cc7e25e284,
    0xc005f99b6a69bbd8, 0xbfe34dc28d46f586,
    0x3ffd016bf066f5ad, 0x400da3e5faed69cc,
    0x3feadf7c1e850ea5, 0xbfe66e695ac5db33,
    0xbfde12463e5da004, 0x3ff21ad7a75c3899,
    0xbff268558ce83e35, 0xbff2bd8aa081be1c,
    0xc0064d092737435e, 0x3fc774991f1ed668,
    0x401212651ab79ec2, 0xbfd0046224943dbe,
    0x400b06c87be07f52, 0xbff01f8364d8b71b,
    0x3fc19fed702dd608, 0x3fe306ae2bed9912,
    0x3ff22998a35366ec, 0xbffa734923ecf652,
    0xbff47e73c5dc46eb, 0xbfb4450a300705c0,
    0xbfd3bab104e637cc, 0xbfe5835efedfbe8a,
    0xc0055950a6325ce0, 0xc006cec1d22cebb7,
    0xc00af94cb8c9689d, 0x3fdaebd89dbabdec,
    0xc005a649dc88b323, 0xbfd0aab8e0423d40,
    0xbfa2a94df0c658e0, 0xc00585f64e41fe1e,
    0x3fea19eed58c1e48, 0x3fe89e1cfbe35b78,
    0x3fd494f85d2e6d47, 0x3ffa477344657a73,
    0xbfdb797fd2bd0737, 0xbfdb8a2049509f60,
    0xc0003f5be65a8f12, 0xbff8a137ce3f59ea,
    0x3fb55ef77f7fd430, 0xbfec4e2f1e343e66,
    0x400714999595f501, 0x3ffe8547903991a2,
    0x3fd27b194896da72, 0xbfc8fe622d479ba8,
    0xbfe61c92debedc3e, 0x3ff348a8f2a93a51,
    0xbfe01d9588a4ed3e, 0x4004b7dff1219645,
    0x3ffee25a10af4045, 0xc00acd2596a0f27f,
    0xc0065017e8448b20, 0xc005f6cbb9364165,
    0x3fe73d56f1c24016, 0xbfff57c9050c9206,
    0x3ff41266dd35052c, 0x3fee9e3eeae43211,
    0xbfcbf94f28da55e8, 0x3fd7d5d94a468aac,
    0x3ff31c54e4d50b6a, 0x40055b34833cb5f8,
    0x3ffd87cb94ce14db, 0x40023930d9fe687a,
    0xbfe884a035c45bff, 0x3ffeb3d5a846aeb0,
    0x40101665cab474cc, 0xbfed88502f726a9a,
    0x400c91e76575ea24, 0x401004442d8284e8,
    0x40017c20d9f03d66, 0xc003147b7e83e8ba,
    0xbff25e4e5f334512, 0x40064d8f2552c9d0,
    0x3fff6c00e2a18027, 0x3fc4c7972061c0a0,
    0x3feb224f45ba1822, 0xbfe6fdea5caa6e60,
    0x3fff4dc7c348effa, 0xc0055b3b77c6dbd3,
    0xbfea85301f761a00, 0x400583a260efce54,
    0x3fe3b946b6763090, 0xbff4b1b25d3bab1c,
    0xbff21632dd8dc070, 0xbff0c9c1680dde04,
    0xc00221b8ef5e3a81, 0x3fe6a925742f8da0,
    0x3fd3c34c67c31f88, 0xc00b3fe39a93f250,
    0xc012777ef521054e, 0xbfe6c66fd53ce588,
    0x3ff1b79f361f42a8, 0xbfb391effef54eed,
    0x400b1b02c8987460, 0x4010d041c874d5aa,
    0x40054f4cb2ee20d2, 0xc00a2bbe9ca4d954,
    0xbfebb919e5f42b99, 0x3fea1ed645854b92,
    0xc00e6eebb57f15b4, 0x3fd5b55fd0ad636c,
    0x3ff86e96d1b9de17, 0x40046f09757d79ae,
    0xbfde019e83458cf8, 0x3febe7e26cd694e2,
    0xc00525ff8ec1db21, 0xbfd0972b464b1cbc,
    0xbff6a9923068a899, 0x3ff97cb6c2ff438f,
    0xc007f1de29fb936c, 0x4004b423a087d056,
    0x3ffaaa37eb686be0, 0x3fed04f1d3dc3e48,
    0xbfe0a84a0db6bb12, 0x3ff358360c005e2f,
    0xc006a1903c67d7be, 0xc00b901cafc70602
    };

static const uint64_t ref_cfft_noisy_4096[8192] = {
    0xc00ada05db8ecc9e, 0x0,
    0xc006a1903c67d7c0, 0x400b901cafc705ff,
    0xbfe0a84a0db6bb0a, 0xbff358360c005e2a,
    0x3ffaaa37eb686be0, 0xbfed04f1d3dc3e40,
    0xc007f1de29fb936a, 0xc004b423a087d05a,
    0xbff6a9923068a897, 0xbff97cb6c2ff438f,
    0xc00525ff8ec1db23, 0x3fd0972b464b1cb0,
    0xbfde019e83458ce8, 0xbfebe7e26cd694da,
    0x3ff86e96d1b9de20, 0xc0046f09757d79aa,
    0xc00e6eebb57f15b2, 0xbfd5b55fd0ad6388,
    0xbfebb919e5f42b89, 0xbfea1ed645854b97,
    0x40054f4cb2ee20c9, 0x400a2bbe9ca4d958,
    0x400b1b02c8987466, 0xc010d041c874d5a9,
    0x3ff1b79f361f42a2, 0x3fb391effef54f24,
    0xc012777ef521054c, 0x3fe6c66fd53ce579,
    0x3fd3c34c67c31f7c, 0x400b3fe39a93f251,
    0xc00221b8ef5e3a80, 0xbfe6a925742f8daa,
    0xbff21632dd8dc072, 0x3ff0c9c1680dde08,
    0x3fe3b946b6763084, 0x3ff4b1b25d3bab1e,
    0xbfea85301f7619e8, 0xc00583a260efce52,
    0x3fff4dc7c348efed, 0x40055b3b77c6dbd7,
    0x3feb224f45ba1831, 0x3fe6fdea5caa6e66,
    0x3fff6c00e2a1802b, 0xbfc4c7972061c060,
    0xbff25e4e5f33450c, 0xc0064d8f2552c9d0,
    0x40017c20d9f03d65, 0x4003147b7e83e8bc,
    0x400c91e76575ea28, 0xc01004442d8284e6,
    0x40101665cab474cc, 0x3fed88502f726abd,
    0xbfe884a035c45bf7, 0xbffeb3d5a846aeae,
    0x3ffd87cb94ce14e0, 0xc0023930d9fe687b,
    0x3ff31c54e4d50b70, 0xc0055b34833cb5f4,
    0xbfcbf94f28da5608, 0xbfd7d5d94a468aa8,
    0x3ff41266dd35052d, 0xbfee9e3eeae431fc,
    0x3fe73d56f1c24014, 0x3fff57c9050c920a,
    0xc0065017e8448b24, 0x4005f6cbb9364166,
    0x3ffee25a10af403d, 0x400acd2596a0f27d,
    0xbfe01d9588a4ed41, 0xc004b7dff1219644,
    0xbfe61c92debedc40, 0xbff348a8f2a93a54,
    0x3fd27b194896da7e, 0x3fc8fe622d479bc8,
    0x400714999595f500, 0xbffe854790399199,
    0x3fb55ef77f7fd3d0, 0x3fec4e2f1e343e65,
    0xc0003f5be65a8f14, 0x3ff8a137ce3f59e6,
    0xbfdb797fd2bd0758, 0x3fdb8a2049509f60,
    0x3fd494f85d2e6d44, 0xbffa477344657a73,
    0x3fea19eed58c1e50, 0xbfe89e1cfbe35b74,
    0xbfa2a94df0c65910, 0x400585f64e41fe1e,
    0xc005a649dc88b323, 0x3fd0aab8e0423d1a,
    0xc00af94cb8c9689d, 0xbfdaebd89dbabe17,
    0xc0055950a6325ce6, 0x4006cec1d22cebb7,
    0xbfd3bab104e637d8, 0x3fe5835efedfbe8a,
    0xbff47e73c5dc46e6, 0x3fb4450a300705c0,
    0x3ff22998a35366ea, 0x3ffa734923ecf650,
    0x3fc19fed702dd5f8, 0xbfe306ae2bed9906,
    0x400b06c87be07f50, 0x3ff01f8364d8b724,
    0x401212651ab79ec3, 0x3fd0046224943df8,
    0xc0064d092737435e, 0xbfc774991f1ed678,
    0xbff268558ce83e38, 0x3ff2bd8aa081be16,
    0xbfde12463e5da010, 0xbff21ad7a75c389c,
    0x3feadf7c1e850ea0, 0x3fe66e695ac5db34,
    0x3ffd016bf066f5ae, 0xc00da3e5faed69cb,
    0xc005f99b6a69bbda, 0x3fe34dc28d46f571,
    0xbfea6869a1d48996, 0x4000c3cc7e25e281,
    0xbff5400031be02ce, 0xbffb486bdb12a172,
    0x4000d40c65697d8d, 0xc002744d80601e3d,
    0xc0048296915c02ed, 0xbfcac6c6cde7bcac,
    0x400aa061c9c32347, 0xbfbf9ce6ed0ae780,
    0xbfec4f8a72f1d87f, 0xbff006f4f1cd0b5e,
    0xbffe21244ce7391c, 0x3fee739ed63f9048,
    0x4004cfcbd7bc2483, 0x4008886d979b7144,
    0xc018170930d5f952, 0xbff511d1e4b4b17e,
    0xbff91d1e890078da, 0x3fcefea70c7a8584,
    0x400e420acc04d88a, 0x3faef16261c18f80,
    0xc00cba2e8a70fe96, 0x3fd67f068ecd1f8e,
    0x3fe0c42b9df6d89e, 0xc0088ea854cff52e,
    0x3ff85340bc330f7e, 0x3fe4fe1d840ea18d,
    0x3fe49b3e9f492216, 0xbffb78e133ef69b6,
    0x400328a776b8bcf0, 0x400585b56f9d4583,
    0x3fc495cb241c762c, 0xc002a64793942d96,
    0x3fee1bf14e77405d, 0xbfeb376a4b1be886,
    0xc003fac79b59ba8d, 0xbfe0c8e461cbad5a,
    0xbfe7fe11567070ed, 0x4005e07f7f427c7e,
    0x3ff7a99774428809, 0x3ff566a6a6c62100,
    0x3ffac0a970d14d18, 0x4007dfd6cee7f4a1,
    0xc013d55fbf93efd7, 0xc0110c4fa3d35ac4,
    0x40091b09c1ed98c7, 0x4002c4c63a2b3c80,
    0xc00261dbaa3f608b, 0x4002d897d3334a1a,
    0x3feeb65ec522d858, 0x3fd933feda9bf323,
    0xbff464b7ef2538a3, 0xc0049cd89364dfef,
    0xbff76741785b883d, 0x3fe53278fb7a8564,
    0x3ff1675489940138, 0x3fc94df69b62adc8,
    0x3fb449e7dc53d400, 0x400e8b09e49fd89a,
    0x3feae7f2cb24d396, 0x40079acce85984bc,
    0xbfff3d57c3bc623f, 0x4015d4fb17677b12,
    0x400898a007850720, 0xbff60ce4a63304f1,
    0x3fca959d60f06e54, 0xbfff4bd0d58db406,
    0xc005bbd8950da918, 0x3ff906a905312300,
    0xbff32e34ef2e2a2a, 0x400051b65ca6bce3,
    0x3fc38adac9644470, 0xbff29f7d17b52112,
    0x3ffd429c8e81d2b6, 0x3ffd369d16b8dd95,
    0xc00119a6db0b9879, 0xbff99e0539a9fc0a,
    0xbfe0aca4d8a16be9, 0x3fca9ec8f24cf66c,
    0xc006f3c509a2bdec, 0xbfd3d360eba2a0a8,
    0xc00758b15fd94a26, 0x400176fa55cfe73d,
    0x3ff562fc2ead1296, 0x400139898086f3c4,
    0xc009d2ac85c7beea, 0x4008e8486d47d159,
    0xbfd0caa6d1553fc4, 0xbff219a0e58a4aad,
    0x3ffc798b080e9050, 0xc017b5af7f4add3a,
    0xc0074e15fc1070be, 0x401b7b0a8416904b,
    0xbffbaf1a18b82e6a, 0x3fdff6235a1c9ce4,
    0xc0039a2fef64c232, 0x3fe9043bf7584c38,
    0xc00e71e3ab1ac6f0, 0x4001f4377581ce3a,
    0x3ff710936ee41b0d, 0xc00b7dea643edb3d,
    0x4007d2f07d73c645, 0xbfc4a27fe8bef0c0,
    0xbfe1fa1ea69f0fda, 0x4000685dc1913f76,
    0x3fffe9970df9bfee, 0x4015e17bfcbee668,
    0xbffe163614251f30, 0x3fe5ae4a262c2e24,
    0xc001b7b377c6d93e, 0x400888d95736025d,
    0xc0023993c60fd50d, 0xbff0c52e01d1927c,
    0xc0043ad540cb7248, 0x4010234a1db10abc,
    0x3ffeaa29cdf081b8, 0xc00f4486fa56a8dd,
    0x3fe2dd6b39f9c9a3, 0xbfe271cb29968b4e,
    0xc00f5fb2f5d48b98, 0xbfe341d9d480ce76,
    0xbff46b2273b05c9c, 0x400d0ef40d5712f4,
    0xbfe01414a89a9360, 0x4002eb16781f0b68,
    0xbfc98c60e1083906, 0x3fdc21a362805e26,
    0x3fb60fcee2b74490, 0x3fee15fc32908ec9,
    0xbffca9bdc194953d, 0x40130444a0e411ae,
    0xbfe15b0776c90bef, 0x3fffc55346697a60,
    0xc0011c153e610280, 0xbfe8fc4737cce8e8,
    0x3fec46fbc7c6eebc, 0xc00f9739a51fcf96,
    0x3ff569391917becc, 0xbfb7551b1aa95cd0,
    0x3fb0ad66baca8910, 0xbff34c5a3c17239e,
    0x3fe54d28ed25edea, 0xc005b3ae78920628,
    0xc011707ca2566f17, 0x3fda6b9773609810,
    0x40089d0334444434, 0xc001a0efe9a27bd4,
    0xbff342a20a4d799d, 0x4004a12d79c04088,
    0xbff34ca3372619ec, 0xbff0254389815214,
    0x40134a206c381510, 0xc0044e2e5df3597a,
    0xbfe7366c6d947db6, 0x4003d4ee617a197f,
    0xc010da54ee8c093a, 0xc015d4fe86cc583e,
    0x400eb20c90427f2c, 0xbff57b14a1abe210,
    0x3fcde4882a539ba8, 0xc0057c7470cbd980,
    0xbff09d6290e6f2e0, 0xbff6615dd5248f79,
    0x3ff57c9cb36dc932, 0x3fc442e80ca3f540,
    0x4000b32ef97af6f0, 0xbfb25f1038a4e780,
    0xbfcdc89b7a4f3cc8, 0x3ff8b0be8f24f36c,
    0x3fef247f10d3fcca, 0x3fd3bb8d209db414,
    0x3fecac3b97363ef4, 0x3ff8d67b8283db02,
    0x3f97ab573a2d18c0, 0xbfec5d32e5a6bdf8,
    0x3fe5d2b2f1bfa6ef, 0xbfd53a709faa0b9a,
    0x3fed990e9cb274cc, 0xbffa600dfc18c752,
    0xbfc510d37533d5d6, 0x4003684d7743b029,
    0x400ee37288fea35e, 0xbff1573c40aa8ad1,
    0xbff2d521c0e6bcc8, 0x3fe095dd52a80473,
    0x3fe1154226cd1ef2, 0x3fc63ee85d50d846,
    0xc00c4f27dd02ee34, 0x4005190e75a6b92e,
    0xbfbd1f93907c2d68, 0x3fea293398d7c550,
    0x3fe71e5389b562b1, 0xbff8e28b06290f2e,
    0x400865cfcd9f1b62, 0xc00212e16f70eb9e,
    0xbff57ffa50a26448, 0xbff2ca1dfe7d7fc6,
    0xbff50e0efafba145, 0x3fff2c6f8d10873a,
    0x3ffed5cec9a041ec, 0x3fdfe59187d51e08,
    0x3ff1d7f9f4d073f0, 0xc00bf5a065c7da8a,
    0xbffff76994602c47, 0x3ffce79f21d1c274,
    0x4017d1d3c9da9270, 0xbfd68562fc8a6c58,
    0xbfc8d651586d1648, 0xbfe0c258e4918538,
    0xc003d58ffb8a1d51, 0xbff08ab2ccb9d808,
    0xbff43c68d741e69e, 0xbfe9ece15a072a72,
    0x3ff13622e83cd2e8, 0x4000d8acb828c44a,
    0x3ff4674b595e7500, 0xbff6330a65e82818,
    0xc00b45ed9535b8fa, 0x3f8513297e953480,
    0xbfa6716316c23300, 0x4009a57928524f01,
    0x3fa0c83f077dc440, 0xbfefe81d4bd171b7,
    0x3ff48df5f20e4394, 0xbffe7e7988b9879e,
    0x3fdbdaa3db77a5a5, 0xc00155408e75ff0a,
    0xc009df948c2274be, 0xc003e192ef6d3e88,
    0xbff45b4ab46f2964, 0x3feaca7eed9712ae,
    0xbffd9428d27106ba, 0x3ff6d995228a2901,
    0x3fe231cdee7967ff, 0xc001cdee2953eeba,
    0xbfbe24c7b4cd2c10, 0x401143970dc6155d,
    0x3ff155efa90a7bee, 0x3ffcb9eb52102dc2,
    0x400d229d295945b6, 0x400092dd570b3711,
    0xbff04b24605c7ba9, 0x3f68941b8e789800,
    0xbff4c85643a39e6c, 0x40165ff1ef852648,
    0x3ff8abb723b784d3, 0xc00b6bcfdfe28962,
    0x40035c1b6a2727d6, 0x4001381fd583d028,
    0xbfe31d221cb95190, 0xbfe74cb78cce5b57,
    0xbfcc20d4efcc83fc, 0x3fff6c1a3ddce4e0,
    0xbff97ff4b9268f0a, 0x3fa2cba1c9768b40,
    0x40075957b79a24d4, 0x400446d17f8a4eec,
    0x3ffa4d02df81028a, 0x40043cce6b000f28,
    0xc002536f9cb5e0dc, 0xbff13925d0cd1270,
    0xc0064c461c4ade8b, 0x4000be43b0968e42,
    0xc00a9b5e6a523c64, 0x400bd9eff45fc756,
    0x4008eae9b8d90e5a, 0xbfd65ee0a22ef8a4,
    0x3fd342d1a3b8569a, 0xbfff12182425dc00,
    0xc00dbc5bdd6456bb, 0x4001f27a8b39b6a2,
    0xbfe9186b45e8f3d6, 0xc004521f33a27d11,
    0xbf9f655f1f162650, 0x3fdc282df2c9cb30,
    0x3faf297a5d9aae80, 0xc005466054e3332c,
    0x4000914f865da3f9, 0xc0118920eb7f416c,
    0x3ff8315f8c838e4a, 0x4009900e232011ba,
    0x3ffa29fab7c953f3, 0x40060014b45f1bd6,
    0x3fed00903aef4bd6, 0x3fe6f77dc0efdda9,
    0x3ff582a7d9904ef2, 0x3fd97eaae0dfe14c,
    0xc00ad62dc706c3aa, 0xbfd425f4e9a51e22,
    0xbff42029dd34ef23, 0x3fdf2262b7e3429c,
    0xc0078e43a65d70ee, 0x3fff38a25b01b866,
    0xc0014dbd72faa607, 0x3ffa6d5dd1cb5037,
    0xbfff5909432fbc5f, 0x3fa50bc485c20aa0,
    0x3fe08586f78cd690, 0x40008cc2daf75915,
    0xbfd170821accdf74, 0xc00c0e45dd45aa04,
    0xc005416af26099fe, 0x3ff938d6c8bf60b2,
    0xc01312cd5fb42d1a, 0xbfc656614f41ff00,
    0x3fa90fc7514eb550, 0xbff6e62dbf0c6575,
    0x3fd17b981a1389e4, 0x3fef2229a5f9f970,
    0x40013e58b3ea190a, 0x4010cbaac646a557,
    0x3ff6d2535dc3167d, 0x3ff9a4d6e6186375,
    0x3fe246b844588a63, 0x3ff3d8d420f60150,
    0x3fe5c7293815dd1e, 0x3fb5cea3210e7560,
    0x3fca0b59bdc1f540, 0xc00e16016cab8bee,
    0x3fddab266bc783e8, 0x3fea0aa8eb683730,
    0x3ff3293bf5c19acc, 0x4009aae2a5d8d0c4,
    0xc00544aaff5bb365, 0xbff5cebde63e216a,
    0xbfdd08b14c046de0, 0xc000c0ed043fda46,
    0xc004da65d3cd012c, 0x3ffa20a00bd9db93,
    0x3fe4c929b2eb9786, 0x3ffe38a037126a64,
    0x3ffabee05eb778de, 0x3ffbb07717abc286,
    0x3fe19f115878b368, 0xbfe0cbc3e4e767f0,
    0x40037814ba734e68, 0x3f5893cede09e400,
    0xbfd6c12278680822, 0x3fe10ab582f6a86e,
    0x3fd75afe261531ec, 0xbffac2b9bdb6e850,
    0x3fea8ae38da8b634, 0x3fc718b86d2b6a8c,
    0xc000b8cc4eb47fab, 0x3fe02cbc8de8fdcb,
    0x3fb963dc507e7c40, 0x3ff50eed791014e1,
    0xc0033f727d14b9c2, 0x3ffdf4096c7dc9b4,
    0xbf856ad75baa9780, 0xbfe2fee6d2306987,
    0xc002ee0d305ae740, 0x3fff41491d5324b0,
    0xc006e7d0fe40bcf4, 0xbff3e45d04e0c9fa,
    0xbfce397a1d7a7070, 0xc00f89d780cf8563,
    0x3ffbde638a8f5c04, 0xc0053536ed13a03f,
    0x40086c69cb14220e, 0xbff27815d25eeacc,
    0x4014bd40ca6634fa, 0x3fd787f6cfbc6f90,
    0x400382861797880c, 0x3ffe5b28af20ef89,
    0x401174130a2e1de2, 0x40013886729a8572,
    0x3ff0edaec9868248, 0x3ff9d370f36cc2b2,
    0xc007837237b32ec2, 0xbffe2002c5ae3398,
    0x40007425bff897a7, 0x4002f50756c04e0e,
    0xbfd4fd21f182da54, 0x3fd5020125a919fb,
    0xc00a8f81204da6f0, 0x3ff208ffd2cd1836,
    0x3ff25e2994f87087, 0xc013e9fd65d749c6,
    0xbff5a91534307d1d, 0xbfda2e1d8e4a33e8,
    0x3fda205108265158, 0x3ff2cd7010816c02,
    0x400a3e90f776265d, 0x3ff96eba3e881bec,
    0xbffeeef5d0d7dbfa, 0xc005a2edefa883c5,
    0x4006072dd3d9f63d, 0xbfe1c2460698e39a,
    0x400987d6b33ec3d0, 0x3fe7cc75dd5a5ef4,
    0x3fe632d4fc7b3b08, 0xbff3edd26227f674,
    0x40115c4058d0a323, 0x3fed52e1fbb837f4,
    0x400f63ac68726f08, 0x3fefd9996bd00fae,
    0x400a5665149c3963, 0xc007851c3d1fe800,
    0x3fd5b17fbd2f8c4d, 0xc00ed0ebe9a8ef54,
    0x3ffaa8aaa94adcbf, 0x400db96b387fa904,
    0xbfe43d612952f199, 0x3ff5d80e7a93b2ce,
    0xbfdb4d8cced35dec, 0x40104b78a050e870,
    0xbff2d375fec62d4d, 0xc0001add489cccc4,
    0x3fee82b92a063f80, 0x3fdd832c97b91cb4,
    0x3fb083ecff18f5e0, 0x3ff9c4ab9f0b24cc,
    0xc01932bfae2afdb5, 0xbfd661a7705295ac,
    0xc00ee154a1a426e6, 0x3ff9fac2c1af3873,
    0x3ff61714630353fb, 0x3ff49774e2810cb2,
    0x400e2661b4ee0ef4, 0x400d7a05c44c1991,
    0x3ffefd038fb80c9d, 0x4003c86d9ae79a14,
    0x3fd13513fd36bed4, 0xbfe91f50fbd67c4c,
    0x3fe81560acbb8dd0, 0x3ff88265534a9965,
    0x3fb145ac2d7a4de8, 0x3fe619b06d4105c0,
    0x3fdafda65410474b, 0xc009810b27f2beb9,
    0xbff8fb97f14a95e0, 0x3ffa43301fa7ece0,
    0x3fff637e0f5f0d17, 0xbff3c87d638250c2,
    0xc00460210516627d, 0x400433f7f8497961,
    0xbfe5fa152ffd0ce0, 0x400edc4b4423e58c,
    0x3ff1210290983662, 0xbfd7b49413c6f5a0,
    0xbff8b9953841a651, 0x3fe6722805c4a958,
    0xbfc018e36fdad8b0, 0xbffbaecce77a2848,
    0xc010804a05b83229, 0xbfccbf74b51894f0,
    0x3fd3806540b6f458, 0xc007af8403ebebd0,
    0xc00fcea59ee8477f, 0x400c93e753151576,
    0xbff430f0ccc1b63e, 0xc00ca68d5afcaf67,
    0x3fffecdf1891c9c4, 0x3fbd45beecac7678,
    0x40089ffaf0d82916, 0x3ff671d6b7dbc453,
    0xbfe0c30c7e2e90c2, 0x3fdc4d968b068542,
    0x4003f6c32f3f4814, 0xc0074276711e5c9e,
    0xbfdeab590407deec, 0xbff8af4b853a05d9,
    0xc0146917bed300a3, 0xc00dbbd176e9b426,
    0x3ff1f9babd06bf1d, 0x3fdbec1c338d1e8f,
    0xbfc7953077b01bbc, 0x40007a9a6bf77c2e,
    0xc006e97e7627bb43, 0xbffe3d510570ec2b,
    0x3ff4dddb45053f63, 0xbfc98b6915cddf6c,
    0xbfd096c4106b0e2e, 0xbfe73620c85e73d8,
    0xbff083eba55bdfc8, 0x400badf35fccfd0c,
    0xbfb04ae53a485d60, 0xbfd617ec18109952,
    0x3fe53a8d8b54571b, 0xbfda281be61e6d3c,
    0x3ff3e2ac063a1485, 0xbff06ce0c929d07a,
    0x40019fbe5a27d97c, 0x3ff21806386e160f,
    0x3fd6ae4574fd3808, 0xc001f8f933b6f42e,
    0x3fee967c7b73628e, 0xbff25d86bd513d8e,
    0xc0045dbbf1118b1a, 0x3fed3801f7c2fcc7,
    0x3ff161c4429f0b7f, 0xbff771e24cf0181c,
    0x3ffb572488ec83e2, 0xbfcae67480d2e850,
    0xbff3f615b41eee31, 0xc00175b59029193a,
    0xbff672a9979abc06, 0x3ff8c2c1e4920a6c,
    0x4012970709eaf494, 0xbfcec7668947bd80,
    0x4006c6d541ea241e, 0x40019ef3ee33a74e,
    0xc00948fe4ac992f0, 0x3fee150ffd53fca7,
    0x4001aac6d88f5424, 0xc007d186e42e8e1a,
    0x400163c392fc2102, 0x400a5f7234e25064,
    0x3ffe067df256cd38, 0xbfd56d3807e8388c,
    0xc0132100c2fc1474, 0xbffebc43439a4b8e,
    0xc008c0a500d5d954, 0xbfde7256bc35bc60,
    0xbfd7334389913243, 0xc0023fd1402c8474,
    0xbff768bd50902f20, 0xbff19d2adb1e73bc,
    0x3ff75cb43afed7bc, 0xbfeb0e2b9b2b162a,
    0x3ff0193a2a1f8b1a, 0xc0165f4b53e5dadf,
    0x3ff5aeff64aeabb8, 0x40166cbef49a8288,
    0xc0068d8592e06dc4, 0x4001298279c76875,
    0xbfff314570f6e35a, 0x401c43f667cb5032,
    0xbff26eb1b435ae24, 0x3fef6e7bbeef97ae,
    0xc004a21e9c6228e6, 0xc002c061c8463c9a,
    0x3ff040048edb5b92, 0xbfefa80b38f76cc4,
    0xc003a3c08eaca314, 0x3fec10febc7b8d72,
    0xbff79413bd969c1c, 0xc0118ce764e98de0,
    0x3ff06d5854182de0, 0x400467c6bbe21984,
    0x3fbca838cbbbace0, 0xc00d437e15f5fed2,
    0x3fedf771399ae087, 0x3fecd890c79f3ee6,
    0x400eae9903517f21, 0xc0077de9b802e612,
    0xbfe59fcdeb84e92e, 0x3fc65ac63dd9d1a0,
    0xbffcf49f3acb8ed9, 0x3ff4aedc898f0a7c,
    0x3ffcae02e0a319c4, 0xbfeb319bd368c19d,
    0xbffb65945b7d0312, 0xc00f5218ef53607e,
    0xc00585ae0fda3589, 0x3ff196284dc0db6c,
    0xbfebf110d405b678, 0x3fb874eb51d93a50,
    0xc00461582c324158, 0x3ff55c5299765346,
    0xc005afd77186fb68, 0x4006569ef49e7db8,
    0xc01cc983103bef82, 0xc0168b87e27645e4,
    0x3ffcb3709c7442f7, 0xbfe1027889a40206,
    0xbfe7a1de064b875c, 0x400c9a00a486b9d3,
    0xbfd960fb093f9a78, 0x400579a8936af0bf,
    0xbfbc307a1c5c3220, 0xbff233628887f62e,
    0x4004fa4b8b8603e3, 0xbff5edc9af040e44,
    0xbff510985b91afbf, 0xc00d457b73ec156c,
    0x3ffa0fc5111db991, 0x4000cf717ee37f59,
    0x3ff5c8def951af18, 0x400443cfb41c5d4c,
    0xbfe2a7ece143ff56, 0xbfeebcbf1ba848d4,
    0x401512718f65c33e, 0xc003b142cd53da4e,
    0x3fea5264739d20ac, 0xbfe2483b01cedaea,
    0x4001837c36350450, 0xc009268290ff8f5a,
    0xc004ca7ae5e1a742, 0x3fcc8cd169be09b8,
    0xbfcc5d44b630610e, 0x3ff1b886a9994dd5,
    0x40045a21edd91474, 0xbff6114ef81a26f1,
    0x3fe4bb764baf912e, 0xbfc9f07caaca8bd0,
    0x3ff538d4c7c7cec9, 0xbff100ee79ec1538,
    0xbffa43d237aba7da, 0x3ff7104c2095e5be,
    0xbfae923612b4b590, 0xbff9c6951ff16003,
    0xbfddbf8fda2e7e92, 0xbff50cc80f81a666,
    0x40118f59528c76fa, 0x3fe56114f5027145,
    0xbfe2a6ee626bc0de, 0xbff4fb2300401558,
    0x4006f2769779ba21, 0xbfef90333dcaa032,
    0x3fe424baf72ba55c, 0xbfce7bae9c6821ac,
    0xbffb066a9371c228, 0xbff5aaad6bf45e36,
    0xbfe5fd7e4e9bac36, 0xbfe0a421afe8f70d,
    0xbff3cc3b9dbd025f, 0xbff2412e4903a508,
    0x3fe1de3a61f62d05, 0xc00dddf3c644cc06,
    0x3ff787b3659ee5ef, 0x3fe60ea0010adffc,
    0xbfee7aa68385a9fd, 0xc007e012500c9410,
    0xbffed74d9efdbaa3, 0xbfff8ffdadf187d6,
    0x3fef5647ed6da744, 0xbff77aee1cc0eda6,
    0x3ff216755b9667fc, 0x40019a9932435ef2,
    0xc01e0869e000ace0, 0xc0036538bf8f725c,
    0x3ff4cc0ccf104322, 0xbff11f4ccb29c6ca,
    0xc00b678d88a0b55a, 0x4004db708accaed2,
    0xc000b676501e6304, 0x3ff5cf09bc5899d0,
    0xc0099c610cf85cb6, 0x40112e1f53912812,
    0x400cb42b52eb98d9, 0x3fcdf0feba322610,
    0xbff27562e3422df0, 0xbfea4243310610f0,
    0xbfff077bdf40ec9a, 0xc00846065bc2281b,
    0xbfe02558c9d6d660, 0xbff04bafa49bbdde,
    0xc00816f72bf3cc44, 0x4000a40692ca09bb,
    0xc00b569b53235507, 0xc00ab2958d3717c3,
    0xc013d86639f5d05c, 0xc00f49f78e37a23a,
    0xbfe2d39ac8d9d81e, 0x3ffe58793b62e59e,
    0xbfa805c31bfb3a38, 0xc000c06786ed0bbe,
    0x3fe7126ce18bf2f0, 0x4002b621114be153,
    0x4002a7ba133df790, 0xbfe8464943a38764,
    0x4015304ce2378334, 0xc008fcc2a3ca0088,
    0xbfd500ced242f376, 0xbfd8f15678719d84,
    0xbfff2525854a84a8, 0x3ffc0cbfeb72382b,
    0xbfc30fac231e81e0, 0x40013392ffd3a754,
    0x400351a03f409254, 0xc00aee6729daa78a,
    0x4003d53f51f04be8, 0xc00f01110f270cb0,
    0x3ff2f5b15cc53d16, 0xbfb04e7a70b2a9d8,
    0x4005efe18d21816c, 0x400625e3ab091012,
    0x3ffc802d75a4a2df, 0x40131f5476797328,
    0xbfd745baac75daea, 0xc00faaeab7342ff4,
    0xbfd444a58350c632, 0xc01410f6a460f74f,
    0x3febfa5a2db11d18, 0x3ff5a917d9f69098,
    0x4000a410987099ad, 0xc01e15a0a5eb8024,
    0x40060450a350950d, 0xbfda759feea4ac60,
    0xc00aec64c1f04fb7, 0x3ffd1db85af74fc3,
    0xbff265f5cec8b314, 0xbfff1e74141b45fc,
    0xbff05c98c207de14, 0x3ff6ccf51a5416b8,
    0xc004f5fc71d49034, 0xc01305bcba58ae96,
    0x3fee543059b8e7e1, 0x4003babe8d4026d2,
    0x3fd4c18221cf2590, 0x3fb184d0c821e3c8,
    0xc0139d2bd1d00bee, 0x400078d228b9a0fb,
    0x400f1a732fd96704, 0x3fc0948f8908f650,
    0xbfe564270f4575b2, 0xbfd92e54a9eb2c20,
    0x3ff0a45992346476, 0x3fd0602474e0aadc,
    0xc00cca00ec70cf09, 0xc00570bc5b5e1ff8,
    0xbff986bfd16be2ad, 0xbff9842ee0869abd,
    0x400787b200071c21, 0x3ff3b1b1653f4654,
    0xbff39d96cb473947, 0xbfb5f6e2c39128e8,
    0x3fb20bcc6346a018, 0x3fce6f3ed18afab0,
    0xc003b554018fc64f, 0xc010f5902c34ed1a,
    0x3fda50f337e6df45, 0xc018bbac0b652bfe,
    0x4012da56652b134f, 0xbfc9301004fb9a50,
    0x401838f5395db66c, 0x3fcd791d54e40e9c,
    0xc0116885c305654c, 0xbffdbecea85b0802,
    0x401531cb819f042e, 0x40092585225d6b1a,
    0xbfe4748210e3ed6c, 0xbfe3c3a8260a6f16,
    0xbfa8f22d26cc88e0, 0xbfe76e454bc3e7e1,
    0xbfb56aa70c9cb6d8, 0x3fcbff6bb9050f1c,
    0xbfd9b05d07317034, 0xc00ece112f035cba,
    0x400713e860e403ac, 0x4010e7d6fd4fcf21,
    0x3fee0a0b1d551608, 0xbffd86272c649f78,
    0x400382b2f78fb892, 0x3fe3091f1975199b,
    0x3fe1ee78b1001fff, 0x3ffdab260a0093d0,
    0x4016b848363f8597, 0xbfd398041fb2b7e4,
    0xc007a88cddead8f8, 0xc003bfdb0e32966c,
    0x3ff149101ab58230, 0xc00b05da19002d10,
    0x3fd329e99c1c3112, 0x3ff21b7bd784e8f0,
    0x40004fd6014307b2, 0x3ff1e0e94d91e137,
    0x400ce896356c6e28, 0xbfe79db602068920,
    0xc0059386ee3e5176, 0x4001972d598050a0,
    0x4013ba52f2759e90, 0xbfef0e74b61b5d03,
    0xbff7172eb4c1b863, 0xbfd184e8f10e0a1c,
    0x400223bc4eced592, 0x3fe7abdd8bab8421,
    0x3fbb72ae501768e0, 0xbfa5a4668b08cec0,
    0x400ec7d9f4a58aeb, 0x3ff40bac22fc8bf8,
    0x4002163c1d0ba588, 0x4002932df46a1fe7,
    0x3ff7aa4c2dacdcc1, 0x3fd94ed03c7674be,
    0x3fd48ca43836cdd0, 0x4010569cd8519a50,
    0xc007daea678c94d3, 0xc017e2ec0b579ef3,
    0xbfd53edc8a4f9648, 0xbfb543949c284a34,
    0x4007520f20063036, 0xc00875738e1f4a5c,
    0x3feebcafcfac4c20, 0xc00c1e5827fcfc7f,
    0x40120eb2b60b84a4, 0x3fe80b62efd84862,
    0xbff756a5c9f56719, 0xbff67715be989c9c,
    0x401114e2729f5bcb, 0x4009edc52e62e88c,
    0x400220d1a7597094, 0xc011eab947799dc2,
    0x400f7f6b404d2e08, 0xbff3e3f4b43bc5a0,
    0xc005b1eb592e1166, 0x3fdf4ad0f5b304fc,
    0xbffae439faa4f375, 0xbff77cb39389f18e,
    0x3fc583a312b17098, 0x3ff729fdc6551fa3,
    0xc0048ca6c03d9645, 0xc016d788452946db,
    0xc003802135422f5b, 0xbff1c4414098ebf8,
    0x3fff4c3a7853b902, 0x3feebdd73fa3e81f,
    0xc00173c4d2b78842, 0xbfe436a5ab95ca7b,
    0xc00422748020565c, 0xbffc1838a8e58b3a,
    0x400303af85ac93b0, 0x3ff63e7557c84a27,
    0x400863c522b50148, 0x4006a89753df3572,
    0xc003fbe8eb5bf5f0, 0xbfd1fbd2532e25d4,
    0xc00eb310f6e863eb, 0xc0044f1ba8212c70,
    0x3ff3120df4787b36, 0x3ff3127edd538bc8,
    0x4000a14fe8853fcc, 0xbff3ad1cfeb98c4f,
    0xc00d7e5aa3bedf9d, 0x3fee11a637a7ac04,
    0xc00996b0110dafa0, 0x40018731c34539f0,
    0xbfea8228afc0b5bc, 0xc00187e6a2e8dfaf,
    0x4004ec28b5ee2fc0, 0x3ffd34531b00432a,
    0x3fccb82d0115ac70, 0x3fe9e2758aca3f09,
    0xbffe64d75ed937d6, 0xbffa28642743d319,
    0x3fc762b984bf8012, 0x3fe185f2bf5ce1c2,
    0xc003dc498b4236bc, 0x3fed0f5f6dc2eb91,
    0xbffa86fadf12eae5, 0x401033b0902e2ea5,
    0xc000940b3ce262e7, 0xbfef8e0581a87afc,
    0x3fe6442302706ff2, 0x3fd73bb4b02b2b58,
    0x400536bb4ef8d328, 0xbffd35bf733ee595,
    0xbff0f7442566040a, 0x3fe99dabb46a9f76,
    0xc0020f86fb73ca34, 0x3fe2331dab1ab146,
    0x3fee2fb7884d88c8, 0xbff6c09b6146855f,
    0x3ff245959d6eb99a, 0x4001019598c1528a,
    0xbffb18c878e34ce6, 0xbfd93d3082f97076,
    0xbffc09c8a9509318, 0xbff48980e18786ab,
    0x4004a26ef1ecc99d, 0xbfe6db287c73e4ca,
    0x3ff493be9fae43af, 0x3fe59cdb71a3a39b,
    0x40008c5cb7ee988f, 0x4004215e91b43522,
    0x3fdd2aa433b31102, 0xbfeed3813acdd236,
    0x4010ab0b641a2da9, 0x401082d1d7136abc,
    0xc0079faf6b004892, 0x3ffa91da96c45f1c,
    0xbfd677c74515b300, 0xbff6246c1e19771a,
    0xc002cb094baccc26, 0x3ff6fd4083265498,
    0xc004fb8dff907b06, 0x3fe0436e8ca190a8,
    0x400a3e5e2f08ed10, 0xbffb26a9b1206c94,
    0x400354f90c57b27b, 0xbfe3db3f1b5dd688,
    0xbff9ab71aa7d5225, 0xc0112fd495366a84,
    0xbfff21f27d4286d7, 0xbff0e6b1944b97e2,
    0xbfb30c5ea6ecfa80, 0xbfff0ae7344def08,
    0xc007d39597144be9, 0x40047f8aed5d8d35,
    0x3ff3ce0c8c5603b4, 0xc003824c5a0df242,
    0x3fd432b88e428efe, 0x3fb8cfa376b60700,
    0xbfeaf2e6e18c6466, 0xbff62e4cf62c5e40,
    0x3ff82c5cf1ea2ece, 0xbff7742baf0389a6,
    0xbf970620ebe336c0, 0x3ffccc15a301499f,
    0xbff667c113066c9c, 0xc0052da18cbbc66e,
    0xc01919eab419ae94, 0xc09661fb2a20188e,
    0xbfb7b3da970dd930, 0x40053a28139331ea,
    0xbff82c5c80063059, 0x4010d98778d5a7f4,
    0x4019ba2497b495d5, 0x3fde08d7b8f7c726,
    0x401490ab34dce535, 0x3fcf83a37414f884,
    0xbffb3aead398314c, 0x400d10274783c08d,
    0x3fcf578594d94b4c, 0xbff65e9d3bca9bbc,
    0x3ff8a424cabb2b08, 0xc001474b4a174436,
    0x3fd0116fa94e654c, 0xbfd7e41921cd13ec,
    0x3fb1609cc3621c60, 0xc002ebe086c20e82,
    0xc00d1e70a94247d7, 0xbfe0237564a10bcf,
    0xc00a951e599655a7, 0xbfe5bd69f9af866d,
    0xbfd6275bf0fddeee, 0x3ff30f79fbdcf4c1,
    0xc0105c9e3012824c, 0x3fe1401da0e60660,
    0xc010caa47d741ab4, 0x40156ece9d480f10,
    0x3fe39a7a5e10f233, 0xc00ecaea6c795df2,
    0x40009d6d1e11b09c, 0xbfe34baa62461281,
    0xbfbe48b3a52d5fa8, 0x3fefbba3fd1361c8,
    0xc00859f443c1c59a, 0xbfa9761e152e4120,
    0xbfd81e60032befe2, 0xc006630a4660c58d,
    0xbfe08370d1977846, 0xc003958a28460bb2,
    0xbfd81ad424841da0, 0x3fd488f5d214f0dc,
    0x3fd086d2dacdf680, 0x3ff8bcd59f0e44c2,
    0xbff6024fa203b872, 0xbfeae14d9e4bddd4,
    0xbfedcbb16b5913f5, 0xc010903859f42b2c,
    0xbfccb93a9fe517f6, 0x40047ef3d3b91fff,
    0xc0047e30072bad8b, 0x3fe0df4b86f92ebd,
    0xbfe1e809b11a6d4a, 0xbfcb20c12c6811cc,
    0x3ffb2f929ac4fb04, 0xbff255a7bd6918fa,
    0x4015a77c2f4de325, 0xbff1a480f359c40d,
    0xbfbdc13c66a27fa0, 0xbfe27e9866d049e7,
    0x3fee57bcf42efd6e, 0xbfe35b39c6833db8,
    0xc0058198b429af75, 0x3ff01bc5b5fe135f,
    0xbfb1ad5c032fa698, 0xc01a65bb4bc37df4,
    0x3ffce58e739df186, 0x3ff2db4a74840f6d,
    0x3fdbbaa2be458740, 0x3fb49c3a0a8529a0,
    0xbff8be7a0fb0669a, 0x401a33cbb284aa52,
    0x3ff9377be59688c6, 0xc0034eabd15c7517,
    0xc00542a0d64b4782, 0x3ffceab106dc55eb,
    0xbfe82379553e5a0a, 0x3feb1532cee7a29d,
    0x400cd9cf4a1af2ad, 0x3fffd43aede8f65a,
    0xbfe597d376ab2876, 0x3fc7c6b87f4ae758,
    0xc002dea269d9546c, 0xbfe9f329105eaece,
    0xc0064e0a31e58abe, 0x401139baecb97608,
    0x3fe464b0b4abf03f, 0x3ff52afafe8a3015,
    0xbfdaf48f04f9b0f0, 0x400087d2a23ec691,
    0xc0117dfb68c7ad5c, 0xbff40b0c968a12bf,
    0x3fe6ff0618bd5b40, 0x3fdb886301e9c6b8,
    0xbfce803889e6bd80, 0x400023e4a5a68245,
    0xbfe202b31792c968, 0xc015c45a1234bfca,
    0xbff7917477aa6421, 0xbfde8864be906086,
    0xbff0860213141d40, 0x40033ab3f37f2692,
    0xbff1dec04d653a33, 0x3ff4fa7e0464d7f9,
    0x3fffdb802a878e78, 0xbfe47e9f456718c6,
    0xbfd28bad68b3eb2c, 0xc00169b18a5f1f6c,
    0xc0064c20b4eb2917, 0x3ff310a69a4b9922,
    0xc00eacca18b1f93e, 0xc01cb3f76653546e,
    0x400ad23d0da8e9a2, 0xbfd2c0f24de2998d,
    0x3ff89ffa4c606de5, 0xc013d16b6713d48c,
    0xbfd939c35ece0f02, 0xbfd009e6eae38a90,
    0x3ffb78fd4fd05d1f, 0x3ff9a5b1fcb87afa,
    0xc00676d9d4808bb2, 0x3fd429bf434c12d8,
    0xc003c19b256268ed, 0xc002a68d84faa5ec,
    0xbff2e17d051a1f61, 0xbffe62cb769316b6,
    0x400b851b8e03a9a8, 0xbfc346f5e7517b98,
    0xbfb497e5d56a4c00, 0xbffab09d92be774a,
    0xbfa072afc3310780, 0xbfe82091616dac54,
    0xbff7808e0b27128e, 0xbff74924e2850aaa,
    0xbfab0ad357fe2a70, 0x401109b336d3cea9,
    0xc00102fbb3dc7ef0, 0xbff956897c2eb7dc,
    0xc0055a966aa89952, 0xc00c6ee47ac4be18,
    0x4002d3fb410b5312, 0xbff38d250906350c,
    0x3ff7b7f05fbe55fb, 0xbff196c9c60c0ac2,
    0x3ff0db4947efb29d, 0xbfe6761cd52536a7,
    0xbfd77e5414c6eca8, 0x40026f31f0e6b73a,
    0x400d2409afeee854, 0xc00a1fd2d4f45082,
    0xc005d134fd85d4d1, 0x3fe262c11105bd18,
    0xc005d93b595e0024, 0xc0011236c61cb786,
    0x400e0f87663b7e21, 0x4008cf46d487bbf0,
    0xc00c4dde13192e21, 0x3ff6767b9af4792c,
    0x40034659308c3b38, 0x3ffd1ec3d07f32e7,
    0xc002cc41cfd288f9, 0x3ffdedc47c776012,
    0xbff5120b37719834, 0x40016d7966af0ae1,
    0x3ffda61c26da16e4, 0xbff7a186901cfdc0,
    0x40139d9db6fdac2c, 0x3fbb8b29700adfe0,
    0xc00e44a8d51efb3e, 0xc0055ea42df96198,
    0xbff827c2531ad155, 0x3ff4a78f0ac8e48e,
    0x3ff4b9f2b0dd8a65, 0x4007054b9bda16ac,
    0x3fc3b04ab3783508, 0xbff52a7f41e5f02f,
    0x3ff1c6a5aa96a4fd, 0x3fe973270d2e9c3a,
    0x3fd0fd182bee47ed, 0x3fe3e5cdb5045f32,
    0xc00862979db84e4a, 0x3f98bf393e98c200,
    0x3ff8c2de9ee370b9, 0x3ff8271673eb44c2,
    0x4004c839c9b59ca0, 0x3fe2677715c07446,
    0x401049facb9376fd, 0x400472696ef65a7f,
    0x40051058768fe01e, 0xbfa0949a665c5160,
    0x3fecd42f7d72d704, 0x3fff1d50657b3db0,
    0xbff5931979854942, 0xbff82d32c1d9a8ce,
    0xbff762ca65a370c3, 0xc009906b61aa3420,
    0x3fcd5520740794dc, 0xc000c722821ff2f7,
    0x4001cd157737471a, 0xc00349a9a4593260,
    0x3ff6035956b1047a, 0x401c0feaf4116c78,
    0x3fcb0a024d0070a8, 0xc01119e8fbdb51b0,
    0xbfe7a0de9a1d8da3, 0x40081cfaa76d42b2,
    0x3fd62873dcf92058, 0xbfd4d6be6cd91b74,
    0x3fb1de3a0ec7c590, 0xc0019a58e285c3c8,
    0x3fe442a63321706e, 0x3ff1b1cd8eebe63a,
    0x400ae2e006e0ed53, 0xbfd4db7bcf74da48,
    0xbfe5e3c216dd74be, 0x3ffe33ab06c3ff02,
    0xbfeb159791d5b967, 0xbfe2e2ccbf12aa75,
    0x4000ec7d34d33ed2, 0x40008b0945c1b947,
    0x400203e9b78bc467, 0xbffcb56fe3a2c08c,
    0x3ffdae5f809541e2, 0xc00a2c80a270b938,
    0x3ffbc302f40718df, 0x3fcbc7fda98b0570,
    0xc0026dc4175ecb25, 0xbfc38aa9b087578c,
    0xbfe2506c6dd1c8ea, 0x3fe8e6ff003d8427,
    0x3fde3e87aff26c4e, 0x3ff89399cd17614b,
    0x3ff23ab1716c00de, 0x3ff796e7c92ca78e,
    0x3ffba046dbbd5e02, 0x3fdded7512b574a2,
    0xbff67ead6423be1c, 0x3fd6426624816890,
    0x400629f709693a12, 0xbff090966fd5eb91,
    0x400c2c8debe3e848, 0xbff20bce91e84d6c,
    0x3fe0dd613923414f, 0xbfd0084eccf2f88c,
    0x3fc35f6f869d79b0, 0x40085187d1c455d4,
    0x40136b17faa6bdea, 0xc0021c5152c0e684,
    0xc003983c809fc8de, 0x3ff044974ab72da3,
    0x4001d122743f6690, 0x3fe9fa395c0309a8,
    0x3ff6492eb5306836, 0xbfc8c5faa8a85a48,
    0x4011d0d17a60d1dc, 0x400733af9e920521,
    0x3ff3f775b6c55b84, 0xc00ba640aaa54f76,
    0xc004b30aa456d6a8, 0x4008ddbaf7325f48,
    0x3fcf4c74fd86f272, 0xbfb9f960496e2920,
    0x4000fd6b353199b4, 0xbfb175557d5b6b48,
    0x3ff425f7229d2291, 0x3fde659463802f58,
    0x4009aa5763466636, 0x3fefd99bc70170e7,
    0xbffc9c37b5485f00, 0xc005a107949e13ea,
    0x3fe3df4066f7a180, 0x3ff999e51e2ad412,
    0xc001b4e31d0d7bf3, 0xbfe2b19db127bf1e,
    0x3fe8a124903b90e2, 0x401106fef3776c67,
    0xbfe57a034c9a89a9, 0x3fe01f7b8461713d,
    0xbff06780104a54eb, 0x4007d167b60dfc48,
    0xc000003e90a48554, 0xbfe8064042af8670,
    0x3fc851e4c324b8e2, 0x40082894841b6891,
    0xc00b558d43462d83, 0xc0100665b20ccba2,
    0xc012078810f0c20c, 0xbfee77a1aae63f6c,
    0x4001ec4959cdaca9, 0xbff734c14c07d420,
    0x3fe05cd9a6bfa968, 0xbfefeb8270cf5a4a,
    0xbff163a6d9840083, 0x400167cd34058338,
    0x3ff222c585d0ff11, 0xbffc4c7f0aba4031,
    0x4006816af5793e83, 0x3ff12b11af621060,
    0x3fe8ed0d2b332722, 0x400d9c8ea07c709b,
    0xbfa2ef928de43010, 0xc00ac12608231380,
    0x3ffc090fdc2af9b4, 0x3ff7880703df86c3,
    0xbfe01defba4f7336, 0x3ff05d3026f424f5,
    0x40048649fbc7384a, 0xbff1674f4f1b3776,
    0xbffd29d1934c2836, 0x3ffb7bca61b26e47,
    0x3fceb132bd9a0188, 0xbfe494ac7c1faae2,
    0xc001ff86435e32dc, 0xbff38c9c835dbbdf,
    0x400e5333e19b73da, 0xc00028a91e073dc7,
    0xbff61eb000207da4, 0xbffd88c416ca5c8a,
    0x3fcd53bb45796168, 0xbff819a53b18f41a,
    0xbff8f3d896b202fc, 0xc00bd4dbeb24ae0f,
    0xbfdd2a8d07cc9290, 0x3ff31bd663bc4024,
    0x3ff2a6d52e5de21e, 0xbfc17c50d593a18c,
    0x3ff8e1082bd4eec8, 0x4007488e336b376f,
    0x3ff2e7edd59c407a, 0xbffff0db58eed508,
    0xc0106fd42fcc827a, 0xc0024e5b577d7cdd,
    0xc0035ced523a36fe, 0xbff2ab07901370d6,
    0x400389d1a6c0c9e6, 0x4004997ef046dc1c,
    0xbff06baea649da22, 0x3fe9ac27ae194326,
    0xbfe12943e71dca52, 0x400be39f077b3b3b,
    0xc003b0c63797eaf2, 0x3fe66d85213eea14,
    0x3ffb6b4b7b5f8662, 0xbfb5f6a357fe1d78,
    0xbfc3528018a72a58, 0xbff116e601cdd05e,
    0x3fe00521c881c440, 0xbfe3408dd4af7752,
    0xbfc6b4fc8ed199a4, 0x400032ec4d0679bd,
    0xbfc1786e3ff7200a, 0xc0129b88afd4dc34,
    0x400cae825b38cbd0, 0x40008ef9166f3be4,
    0xbfec2978ded053ff, 0x3ff5f6f82863f7a4,
    0x3fe05cc6f460117d, 0x3fb51f3bd06515b0,
    0xc0046e868990efe8, 0xbfdceb333ea1d29a,
    0xc0076cf12f1e68cb, 0xbfe2c34b8519a210,
    0xbffcb50e7e8f8c01, 0x3fcbf5fdc706c1a0,
    0x3fc45f2d18114ef0, 0x3fe8c8ad1ce0dc37,
    0x40006ef39be31b14, 0xbffad51c51265122,
    0x3fe71c7cc31b5885, 0xc0001905ddc14447,
    0xbffe5052573daea0, 0xc013f2c60f844754,
    0xbff81e47c076c8bb, 0x3ff2dcd7287dbf8e,
    0xc000956b26554096, 0xc00c71ee9672f8ed,
    0xbfd7908c5103e1c8, 0xbfc051f050628294,
    0xbff53daad39f0dce, 0xbfd5fd87d687d648,
    0x40029ede5f9fd71e, 0x3ffcb6dcd43567dd,
    0xc00c6d86e8e5476c, 0xbfe2ae3b5497778a,
    0xc0037db65d1feb7c, 0x40120fd8f227d99e,
    0xbffb16f24d5ab8b9, 0xbff7bcecb604aa06,
    0x3fdd769535bf5270, 0x4008141fd25555f4,
    0xbff1cf54a8a31038, 0xc0065e2df08a33e5,
    0x3fc21fd71e749f10, 0x3fe20d97e26ad5b6,
    0x40017d95204005b0, 0x3ff8798283ba3f70,
    0x3ff0dc4b3cf58776, 0xc00332abb5bbc0aa,
    0x4003a31242f72006, 0x3ffb65460cbe793a,
    0xbfe11a7148d8ed37, 0xbfe8daf1fab7f8de,
    0x3f91521dbd2c6a40, 0xbfedfba0fb51697e,
    0x40066ca5b97487b7, 0x40105a66d48c151b,
    0xc0003ba4ce933589, 0x40039a33e71ec4f2,
    0xc004c800baf37c3e, 0x3ff77d7601b82ede,
    0xbffa47eb41c1c664, 0xbfe96db2f0015bdd,
    0x4003b9fd6a831b2a, 0xbfe9b9e806dc857d,
    0x3fe02ff77a630db8, 0x400d2631dd40867c,
    0x3ffde0f3ee34fb70, 0x4011cfa450b31af0,
    0x3ff2ed1bd97005b4, 0xbfc435bb40752508,
    0x4014cdb110b0dc35, 0x3ff8ef22a3a604c4,
    0x40109c8d4501d043, 0x3fed1440b654189b,
    0x3fe809741b37e5a5, 0x4007c08e045732e8,
    0x3ff02f97b6472ab6, 0xc0010c45b112b6ca,
    0xbff58d5410203b48, 0x3ff50bc6c1fd426d,
    0x3ff28c9da84b3e75, 0xbfbff74feff8df00,
    0xc0093f4f00954098, 0xbff2a8e3ac86138e,
    0xbfe4573739f50802, 0xbfd770a40baff4e0,
    0x4011bb00c5a3ada3, 0x40041812136f5028,
    0x3ff5dd7f32b22c7c, 0x40009122b503cc47,
    0xbfea6c30a16fc568, 0x40079d4ea2291696,
    0xbfdd675b9b4bce4c, 0x3ffbe6ea427847f6,
    0x400ec1f1c1199dd6, 0x40155561010f0c6a,
    0x3ff05d8dbb4ca41e, 0x3fe2cae7208d5598,
    0xbff3ca4f18a87adc, 0xc009a5ef746e1610,
    0xc0084f3ee0b09ad4, 0xbffa53a954885afc,
    0xbfc64f7ba9d2d303, 0x3fe263f3a80ce87c,
    0xbff3ba65e84dd374, 0xc0056cef34109cd1,
    0xbff160930206399b, 0xbfcb0ceb39ab1eda,
    0xbfddc43fdb8a4bdb, 0xbfd9ba0a92def8d0,
    0x400f61357aab6e2d, 0xbffd148b8eda28ba,
    0xbfc13eae5158c790, 0x3fe73e3d4bc70c58,
    0x400a32bc1ce65e66, 0xc003cfdc88da7664,
    0xc008326b24711172, 0x3fddfd993e435c92,
    0xc00c7df25a3453b9, 0xc00093caade9c8fe,
    0x3fff859d62fce350, 0x40066969b7da1587,
    0x3fe2b0c65c819280, 0xbff96a72ace9ce30,
    0xbfd347d339ed92a6, 0xbff922a69b2da5a2,
    0x3ffe109bcc31c4ec, 0xc00318d488321273,
    0xc00864c1ca7c0d04, 0x3fe80d8a4ef7a6cb,
    0x3fc381de83efdf50, 0x3ff9ca8c2cc87338,
    0xbffd5f1aeaf83ffa, 0x3fed787a36c22e0a,
    0x3fba769aaddba3c0, 0xc00640592ad70d9c,
    0x3ffa2fa886423bb1, 0x3fea033888bd49c4,
    0x3febf3d60da11848, 0xbffa8c6e4fbeb1f4,
    0xbff15597b19d6561, 0x3ffb59361b101580,
    0x3ff9d2ef0108cdf4, 0xbfefcdc6924b8693,
    0xc00df08213f46557, 0x400253c2c748910d,
    0xc004f1aed3f8d04d, 0xc00d6909843837e0,
    0x3fe70957ab445cac, 0x3ff7302fc5847573,
    0x3ffbfa64cb76f90c, 0xbffd341fe862cde2,
    0x3ff8510f99466a51, 0xbff46b93b07783a2,
    0xc00050b31d10b3c2, 0xbff094cf003a1e1c,
    0x3fe1e172206b4660, 0x3ffd5228508a7106,
    0x40067cf1f1e32898, 0xbff20c2db7bbe9e0,
    0x3ff01c88ecbd92da, 0x3fe9986c033d0dc4,
    0x3ffd76e646b8e904, 0xbff26442755f3c7c,
    0xbff90d31621d4c97, 0xbfcd6325f712096c,
    0x3ffcc13efad69d68, 0x40126b4dfcc95c80,
    0x3ff61edb216983be, 0xbffc94300fb5ff1f,
    0xbffc518ffd956f45, 0xbfba8028bd407b24,
    0xc00bbcbd522e42d6, 0xbff1d91e6a45c0d0,
    0xbfe7366d31ad748d, 0xc009b0e83e882952,
    0xbfc3c40e42631390, 0xbff56923c41ba453,
    0x3fe012d2820b8d7e, 0x400c377b28141f3a,
    0x3fe6886f97866905, 0x3ff6ff944aecb9a0,
    0xbff6d1439c00d69e, 0xc000d573ff2986f4,
    0xbfe7fdca9b1d9227, 0xbff5d2374825b8ad,
    0xc004749e8f26675e, 0x3ffd040addb814c6,
    0xbfce533db6e46d78, 0x4008cc2fea798124,
    0x3fe5e11177a950de, 0x3fc43888d3c420fc,
    0x3fad890381f01d50, 0x3fe6483f245625dd,
    0x4002df53bbb167ab, 0x4010183d06f53280,
    0x3ff292ff1f4dc5b7, 0xc011af89e04072dd,
    0xbfe7777a04fce1cc, 0xbfef374ffa4e8180,
    0x3fe8408b5a20584c, 0xbfe544f6da169f20,
    0xbff7cbacc1a5f20d, 0xc0081cabd3e3a8ab,
    0xc00e401ba4b22f8e, 0x400393ca4841a415,
    0xbfe68eb361a0e1d2, 0xbfe2e9fdcb21eec4,
    0x4005aa2315311536, 0x3ff6091dbfaecae8,
    0x3fe5a298cbf9b09d, 0xc001771f570cec2f,
    0x3fe40ad11f8987fb, 0xbfd725a6f2f83c5c,
    0x400109590d366827, 0xc004e234cfeaa7b4,
    0x400624c4127e2c70, 0x3ff92c38cfd7e38b,
    0xc0096a4296ba3efa, 0x400f4fb316eea17d,
    0xbfa20a0540ff88b0, 0xc01071e0185378b6,
    0x3f90cc503bb7f7c0, 0x4005150f03aeab33,
    0x400aa0ad5b455b44, 0x40044f60d8c17254,
    0x40163a04f3fb7a15, 0x3ff279154929601a,
    0x4002eabd95a409ae, 0xc00b1a9a8acc9e50,
    0x400e444d02873ee5, 0x4004ef3fa8a9520e,
    0x3ff04c2f65466c5b, 0x3fb8468af544bc50,
    0xbfe29371d796c474, 0x3f982f1ee104d960,
    0xbff201568eef3b9a, 0x40059234d4568b2d,
    0xc00d1362d2836bcf, 0x3fedb77b61665264,
    0xbfa7357c61f0cc58, 0x3ffe8d08364f5a51,
    0x3ffa8cb61d105a7b, 0x3fc5ef1fa6617eb0,
    0xc0105d12c3834b7e, 0x3fbb9bfa747a0504,
    0xc014717763d3c931, 0x4001766a354d2524,
    0xbffc5e2b8146d2b4, 0xc01c3c94174b66b0,
    0xbffd0155e4e75781, 0xbfc25a63a9473fd0,
    0x40029acc4c9d14ac, 0x400473467551505d,
    0x4007622d4f90b93e, 0x3fef70344e3983a6,
    0xc00d374867a2a70e, 0xbff6985312de3a10,
    0x40056962d8b8d2e6, 0x3fe9266e16361337,
    0x3ff8c05964f04684, 0xbfcc3f2b4f61df1d,
    0xbffd75232d2965e1, 0x3fb5c1f68e182b18,
    0x40015a576d398ced, 0x3fd8ce21554ca7a0,
    0xbfe5a85f22b06424, 0xbfe3b72376efd6e1,
    0x40134180144d6c02, 0xc007ff42182d8a8a,
    0xbfbcd33903d5d85b, 0x3ff1c1c61d5254f2,
    0xbffe6dec3ff8f5ac, 0xbff5af7bc1021b37,
    0x4003a34f767816ef, 0xc006fbc531abc87e,
    0x3ff148cd39dbf03b, 0x40028360973ff25d,
    0x40045548cf3600a4, 0xbfc2fef7cae26788,
    0x3feefa591696c6f8, 0x3ffaf9d395094399,
    0x3fdff40c6e57e3a0, 0xc008ed42d152939c,
    0x3ff34a3a4d66292e, 0xbff4c2c2e3c3cf30,
    0x400475d3afc551f8, 0x400f7262c3296a0c,
    0xbfcd1b4e0f6e3618, 0x3ff52d506ce4eb33,
    0xbfe3df3f13b486bd, 0xbfee92f398e2d38b,
    0x3fefba223b6f5d29, 0x3fccc4afcce18186,
    0x3ffe0d3fb49f4f60, 0xbffa0a62d546d3a1,
    0xc00186ddabe9b36b, 0x400071aea6cda1b6,
    0xc00fb9159a2caf88, 0x401348211fe19ac7,
    0x3fe9e8a5b422d833, 0xbff366a1693577e5,
    0x3ff01cc9b3dc8d55, 0xbff88b2dd040f8d5,
    0x40004b98bd1ffa50, 0xc005cd6cde41b18c,
    0xc01507cc8527f928, 0x3ff33df3075d90b2,
    0xc0075d86ecbb6245, 0xbfe91ded5b1280c2,
    0xc006ee390b59d526, 0xbfa5c6d766d6e300,
    0x3fd885629256e440, 0xc010a5900cd45cce,
    0xbfe4d3fdfeba4d60, 0xbffb028eecee4771,
    0x4012225a6c04b88b, 0x3fc7998c227b265c,
    0xbfeaf8ece18e578a, 0xc00e0266aa03126e,
    0x3fdd95dd87de8efc, 0x3fe9aa7abdc85a96,
    0x3fe4723bafd0e942, 0x4008614bbe86a144,
    0xbff0b4b8a8421539, 0xbfdab82072934e50,
    0x3fd4032447ba21f4, 0x3ffba0ac4342a829,
    0xc000649b847b9dc6, 0x400aa10fd73fe227,
    0x3fe8f382020f5500, 0x3ffd525e02170529,
    0xbfca792efd966500, 0xbffdf35607f24dcc,
    0xbff9f1415f8ad3e6, 0xbfefb751292e98c0,
    0xbffb24ff332c2684, 0xc00ea66ab74581bb,
    0x3fd987f39a043990, 0x40065c43d0387570,
    0x3ff4fc644c2a96e3, 0x400a4bac0fdc4eff,
    0x3fffef98d342031b, 0x3fe3b21c72fb0f08,
    0xc007e37d9ea66601, 0x3ffd11aef9d2d184,
    0x3fe5f9f672c180d4, 0x40112178eab97f92,
    0xbfd44857435ab520, 0xbff7bd866c04ea8e,
    0x4001e31cab7299c7, 0xc014b361f0c44047,
    0xbff7a4db0540d58a, 0xbff769252e32d99c,
    0x400bf23939069f0d, 0x400f7290b638813c,
    0xbfe845857ddb72b9, 0x3fdd1e06230056ac,
    0x400203e989388e92, 0xc00b6a3b30e9fc2c,
    0xbfef656341f8205e, 0xc0015052ab685919,
    0x3f72600241071a00, 0x3fd27d97f9470ec0,
    0xbfe2ba91d19aae8a, 0x3ff99120b5c628a7,
    0x3fe43ad4f5e80810, 0xbffc6be1c57bb04a,
    0xbff85561f61447ee, 0x3ff36de1970d55d4,
    0x3fae209a319d1440, 0xbffa40862eeb06f9,
    0xc007877b9aaf9a34, 0xc0091deeeebaa83e,
    0xc0023d28f777d93f, 0x400aa7e206b9ee04,
    0x3ff2f745002df0ce, 0x40073d67565ed2b4,
    0x3fd7e2957ddda67c, 0xbfea027152e61c03,
    0xc00b8e96d5357cce, 0xbfc067e4555b746a,
    0xbfd8f1b4368093c8, 0xc0088d3b2d803f7a,
    0x4017675df9a0c918, 0x3ff2c72bb04f9203,
    0xc003be764c9fe73d, 0x3ff355cbbdd38497,
    0x400e1a0a4d7b8c0f, 0xbfff8fbe52a68ec8,
    0xbfe20030908b1592, 0x4007b67e4b0a093e,
    0x4008f0605bd46a6e, 0x3ff81dcc0a1e185c,
    0x3ffaf33f5024e0b8, 0x4007e314ea682b5c,
    0x401e3ca8f6833bdc, 0xc00b181e84f56727,
    0xbfccd416f179bfe0, 0xbff4500d27997241,
    0x3fdf9b806ed4cff8, 0xbffa528c85a9e216,
    0x3fea1b3d0f8acaae, 0x3ffe2baaa302496b,
    0xbff9793762c3d809, 0xc000f8c34878b95f,
    0x400848886e7b4af5, 0xbfd7b26180a2047c,
    0x3ff96a608ea89e86, 0x40026069677219d6,
    0xbfff6014e97859aa, 0x3fd16f0ad26ee1c4,
    0xbfe22aa307bd6eb8, 0xbff77ae080deb970,
    0xbff012098ce4ae94, 0xbfd054bbdfbe1c45,
    0x3fff449775e01654, 0x3ffa23d808125126,
    0x3ff957a085989495, 0x3ff2316d54a67084,
    0x3ff0978a15016d34, 0xc01267d7100c3d7c,
    0x3fb96df32a2417c8, 0x3ff97f6cfb435fb6,
    0x3ff7afd4ef8666e4, 0xbffd83b170e44bfd,
    0xc005892039e6fe8e, 0x4001a4a5eca54057,
    0x3fee1e4e5d9a06bc, 0x3fbb3f938a5ad110,
    0x4005da0fbb8d7228, 0x3ff700afe20c3fb6,
    0x40127b81fbe6fe79, 0x40001913b8f9fc83,
    0x3fd73ad2c860dfb0, 0x401284ff7e3545ef,
    0xbff576e892ce72b8, 0x3fc666811fe158a8,
    0xbfba13649181cec8, 0x3fe7407f7f5c832e,
    0x4011dbd8953a6654, 0xbff7e21f825683ad,
    0xbff1ef3328b94bb0, 0x3fdfee3862f912dd,
    0x40026a6f1058a503, 0xbfed91511e9d8af0,
    0xbffc153f0c30420e, 0xc00154b8db8a376f,
    0x4002e1d6c12f2c2f, 0xbfdc5c8b54c79728,
    0xbff1787a84478a28, 0xbfc4191ba49b2ab0,
    0xc007691c05f6465a, 0xbfcb455ff9323508,
    0x3fff6b68072ae8a9, 0x3ff285feb8c8a301,
    0xbfd77a40cf9bb578, 0xbfefcd8d9854e387,
    0x4000385b85b2e59e, 0x4007f6b672210bae,
    0xc002fbdc4a14be42, 0xbff678a2b772f12c,
    0xbff9e392cb6b4cfe, 0xbfe4b61716fb2fe8,
    0x4000cb592c6f6d2e, 0xbff5632432d20f6d,
    0x3fe3866075e2e2a0, 0xc006e194af86213f,
    0xc00afe4f830e1baa, 0xc007dc3368ba0fee,
    0xc010091ef26fa9b8, 0x400b614c6d1a7ebe,
    0xc000433ca4f8e3c4, 0x400d6a12e25c8fe1,
    0xbfe00678260aff84, 0x3fe62648ae3342b8,
    0x3fe5b88837f48936, 0xbff564457664fd12,
    0xbfd755fca92b911c, 0xbff7b860fd1b5576,
    0x3fff8e08f67f4022, 0x3fff181b0cafc88d,
    0xbfdd3d9367e105f4, 0x3ff35ff88f7e22da,
    0x3fff8579262002fa, 0x400b6bf6694075d9,
    0x400abc8c85789f45, 0xbff7d1f88d357478,
    0xc0114be3a6f53768, 0xbfed442305bd6ea8,
    0xbffba5c9159125c7, 0xc018c6c860b7d07a,
    0x400afda24dcfc7aa, 0xbfd68fc2ff4c9b50,
    0x40118102d4e86ef0, 0x400821a4cfac849a,
    0x3fa1941e074a9780, 0x400014cea4c92500,
    0x3ff69074b5c71c45, 0x4005fc29286e6cb6,
    0x3f8554bf50346000, 0xbfe28bc163123f33,
    0x4005f4d5f76a6d88, 0xbfe5ee0487aa437c,
    0xbfe29577e21bcd86, 0x3fd6a6ad64d47238,
    0xc007cc95eb28333c, 0xbfee3572096e6d78,
    0x3febf7da7a995a70, 0xbff7f30ebcbb7340,
    0x400fac93f627f3b3, 0xbfd997c2570d0604,
    0xc001d7650b986c7d, 0x3fe2ff8957cc3d0c,
    0x3ffcc1a63da7457e, 0xbfe439408273b6c7,
    0x3fdd560ddf5e6b90, 0xbfe8e0f9192be27e,
    0xbfe98c93b4319db8, 0xbff16afbe3f66052,
    0xbfea9acbeb60289c, 0xc0123b65225cea34,
    0x4002b351e995ac90, 0x400037b86763f615,
    0xbff260b8b40f526c, 0xbfe92c906731542c,
    0x3feebbf1eee59761, 0xc00075fb7ff1a7b8,
    0xbfc685f05a3b5b5c, 0xbfe82396674ce06c,
    0xc00b602e8f867184, 0x3ffa35ee78b63c48,
    0x3fd04223fcff6756, 0x400e0522a6bed3ea,
    0x400fc20b81dd46fe, 0x3fe2cd3e059b8248,
    0x3febaaa9b821b426, 0xc007f4fa0da3325b,
    0xbffb0eff52923a41, 0xc00a9e0f1f9fae31,
    0xc0012f9896f5c227, 0x3ff5ed5abf2bab76,
    0xc00d05f1b6e8ecb0, 0xc001baa770d64ea1,
    0x400df043fb2de9b2, 0x3fd8427bc4eb3de0,
    0xbfdcc093ff6ecfd8, 0xbfeed321f2a656ac,
    0x4016c6e31c5fec48, 0xbfe88a3bddce98a9,
    0xbff4fdd66d2c0067, 0xbfe1b1ac3c32ab58,
    0x3fcd020868d316e8, 0xbff6c4f3ff2af40f,
    0xc007a33126222c56, 0xbfe1b66d01165696,
    0x400d3b1775a8060e, 0xbff7cc2709ec3ad0,
    0xc00cef0ac7e5ab36, 0xc0011b53baaa2e59,
    0xc00ed0221ef5bc2a, 0x3fc835e650e06698,
    0xc0052da62290baae, 0x3ff94b4864dac0d0,
    0x3ffefab2dd9b9a7e, 0xbff0dee7227b6169,
    0xbff502f4a4efe1d1, 0xc002080d33c1c92a,
    0x3ff92e3d478845a7, 0x3f76087e998f4580,
    0xbfbae1e9d6dd9cb8, 0xc002c476bdaf87e4,
    0xbfeac539f8c4a2a6, 0xc0030992fe9f0a07,
    0x3ffc218a0cf98eaa, 0xc0096faacb761bf4,
    0x3fe6faca6b7c9d6a, 0x3ffad3c12dae3d18,
    0x4001c4bf2265defd, 0x401b1cb919f4341e,
    0x3ffaa3148a688060, 0x40005d048d30cdf1,
    0x3fdac2a1ccad6634, 0xbfe2876ce8c439c8,
    0xbfffdee37812df64, 0xbfffaf2431558a08,
    0x3feec4be66c894a4, 0xbfe02ad28fb5702a,
    0x3ff4f593a5c69248, 0xbff5771731d2aca7,
    0x3fd531fd7503ca70, 0x4002d36335166f6a,
    0xbfe9221701ab4814, 0xbff338a01938ab97,
    0xbfeef934507cbcad, 0x4014fe64d2b9c231,
    0xbfddb5b2277d67e0, 0x3fcfc9349ec82bd0,
    0x3ff5bc34515f181e, 0x3faba1fcb31934c0,
    0x3fd9735153bd0b84, 0x3fff416ef60fe20d,
    0xbffdd359f2acc9b0, 0x3fe95f917d33204e,
    0xbfdff51db7db9a70, 0x4004fbd8c0d39eae,
    0x3fe57433002dc2d0, 0x3fd83f37b9062b64,
    0x3ff5092fb1d9a589, 0xc004bfe652895938,
    0x3ffc4039c1a55309, 0xbff1940f36cfac94,
    0xbff14fe638890f40, 0xbffa7d8e69f6c392,
    0x3ff2c18c9da33b53, 0x3fc2f315925d341c,
    0xbffb28ce6a2e2384, 0x3ffed6ba01d0adc1,
    0xc007cc24b74ec56c, 0xc00576a9c8bb3b0f,
    0x4003d9c263e772bf, 0x4011afd26ae7762a,
    0xc0020b2539d008b6, 0x40068180538fdf24,
    0x3fec5a8099931478, 0xc011289cc564b5a0,
    0xbffbf22cf5843da6, 0xbff3398156b81cb2,
    0x3f788c4afe620800, 0xc000e42ad114c5ec,
    0x3ffd40a3f6cc2b5a, 0x3ff58e64e4c05dda,
    0x3fe78835eb9327c0, 0x400f802a53f15892,
    0xbffdc991022e3948, 0x4004724e2ccb40aa,
    0x401f13e197e2e0d5, 0x3fd365633749458c,
    0x3ff079502cf0b23f, 0x3fd948f29d525158,
    0xc00e182ecf6da4fc, 0xbffe83233bc2308a,
    0x400998092d69deaf, 0x3ffe46f3d1c8cd51,
    0x3fb7cd577c479040, 0x3ff2fee42b9c8776,
    0x3ff10a337b538f0f, 0x3ffa6ebeffc33a9b,
    0x3fe6ad47c3666e2c, 0xbfe297c3b25f886a,
    0x3fe6fddc420371b2, 0x3ffd6a37e5a6e704,
    0x3fe749474078d256, 0x3ffd25a3d2abe212,
    0xc006677d6b8a1942, 0xc007af660e661a43,
    0xbfde8cd71cbd7428, 0xc00e27badae73364,
    0xbfff4c294962ae7a, 0x4010b2013f690458,
    0xc0005045bdc376f6, 0xc0060eeb8cd51b15,
    0xc007fc0584c27049, 0x3fea8bf163fe9d7c,
    0x3fc28b6132a37f58, 0xbfe38f1f6c6382ce,
    0xc0055380a7bb29bb, 0xbff1095f301fda80,
    0xc0020c3a4285d6d9, 0xbfec5129c0f4b7d0,
    0xbffdb556521540bb, 0xc00e20fa73639cdf,
    0xc00dd50bc095a99e, 0x40057d6c5c840680,
    0xbfdb27f342ec0f4a, 0x3fb02f584ee85350,
    0xbff28f292e53cb06, 0x3fded120e237a026,
    0x3feb28894331876c, 0x3fd25b1a02157676,
    0x3fe743bcb12ef634, 0xbfe8233e46392f34,
    0xc006e0b578144686, 0xbff428ad07eb0309,
    0x3ff8b54a56794ce9, 0x400ac7348503ba42,
    0xbffefb57395bf7ee, 0xc005d444f3c240f0,
    0xbfe934ab14b1e1c2, 0xc0073b0171ab9a20,
    0x3fd363bc53c54b6c, 0xc0020a46ac47b25a,
    0xbffa9526347d5b98, 0xbfdfb3c48d72e73e,
    0x400a374261311ea6, 0xbfc0148d33ce9528,
    0x3fbf89023ec82c20, 0x4006cb2cc55b1e78,
    0x3ff61abc649b9fdf, 0x4000a945aad05356,
    0x4004346c7fbf8908, 0xc004d51e5ba0dbf5,
    0x3fe03eba079744fe, 0x3fdbfa3018e493b2,
    0xbfef09bff6da8ee6, 0xc00b34bc476abc8e,
    0x40007077730fa08b, 0xc000841bc7af8e69,
    0x3ff3bc0f983a0056, 0x4001dde601101813,
    0xc01403cbfcfb2112, 0x3ff03dde57d5d7e4,
    0x401281c37ee62718, 0xbff086c8248fc9c3,
    0xbfca7f7ef96fdb00, 0xbfe3a458257f73f7,
    0x4003a867bc3fbc59, 0xc0022a5f20875c28,
    0x3ff0732be35733ae, 0x3ff91ff2e9f8116c,
    0x401039dde8ebec28, 0x401be4168ff0c23f,
    0x3fcb47a1d642c218, 0x3fdd10ccb5df31fc,
    0xc000260679c878be, 0x3fffce7b6afcf99e,
    0x401324bdefb9fa6b, 0xc004bd7f74203d13,
    0xc0078fc291c8b2c3, 0xc007741db040dbaa,
    0xbfe99de69c170514, 0xbff3e65b519eee18,
    0x3ff370e5f5e98528, 0xbfc07e6f3910c4c0,
    0xc010c6e1259834d2, 0x3fcb534e0a530b80,
    0x4001d9f00aad31a5, 0xc00859235ecb9f58,
    0x40085d60c34e93b4, 0x3fbd9c16172d9620,
    0x4010f4785d04db50, 0x3fa0985dd8299d60,
    0x3f936bc91f4bfe20, 0xbfe304206cef3257,
    0x3fe22771e304cc3c, 0xc00e9afbaa037904,
    0xc00df53d237ee114, 0xbff51b0f9e0dfcba,
    0xc00ee785b67c8b95, 0x40193835ec5c2b61,
    0x3fdf62e5779b1c30, 0x3fc8679d6043e590,
    0xbfcba3d5986a6e18, 0xbff2232a4e839dbb,
    0xc00459d3e4bfe4ce, 0xbfbc83ffa0664870,
    0xc005ee489fea39c0, 0xbfc9574515fa2300,
    0xc00cb03d8b812375, 0x3ffaf22ef5381848,
    0xbffefe3cfeb55a00, 0x40027cc108693ef6,
    0x4006458f28dfcc02, 0x3ffbfb75fa02d8e0,
    0x3ff6c906ea0ce739, 0xc01068bed425610f,
    0x3fcc1e1224e1b5c8, 0x3ff87df794582ad2,
    0x3fc395bbf108ecd0, 0xbfed4b3cc3d91b62,
    0xbfface6628297b8b, 0xc004d14bc803d5d8,
    0xbfb6ed8048a6f2d0, 0x4009ac426150446d,
    0xbffd7948004f9e0b, 0x400026459c214abc,
    0x40020bf97fee8a69, 0x3fb7773478f4dc20,
    0xbfe2d1ffe7d2ff0e, 0x3ffe810ae590c8fd,
    0xbffca2178b8662a9, 0xc00d8e5fe05a4efa,
    0x3ff5b0ca1fd9e87e, 0xbfd9828a20a68d1a,
    0xbff641a1504fc86f, 0x3fdc516a3272f59a,
    0xc00343a9bfc20ee1, 0xbff8ea5137e1d1a0,
    0xc0107cfd3988959a, 0xbff2f98f5f9f96cc,
    0xc005b683d2b29b71, 0x4011c759ca69a95c,
    0x3f86450959fc0240, 0x4005b3a4049817e6,
    0xbfdb458018abe8f4, 0x400d2bcc81dd83f9,
    0xbff96496cf523bd6, 0x3fe8cf1a8a64f7bd,
    0x40090208e2a22042, 0x4000294dda7754ba,
    0xc011b6ba0d6e395a, 0xc00e1d537210068e,
    0x3fdb415b805ab4fc, 0xbff60600c90b9c78,
    0xbfc6577d5d6fa7d0, 0xbff95ead8c3379ea,
    0xc00587bb1644bee4, 0x3fc75d61fa049910,
    0x3ff94c31d8c6805c, 0x40040d2daa8cac5e,
    0xbff27e35c7bc5c4a, 0x3ff2a711a78842ae,
    0x3fe5c7fb03f309b4, 0x3ffe3d8063a08f7b,
    0xc00203156b393e1e, 0xbff53def958b4ed5,
    0xbfd86dd287fc455e, 0x3ff71ef1c49c9fe4,
    0xc00554f596c456fa, 0xbfe8a6211e2900f7,
    0x3feb90beb6260733, 0x3fcd83f11696288a,
    0xbff2a75bebddbccd, 0x4003ab48acb6f96f,
    0xbfd75c5926cd7756, 0x3ff7941f6fb35634,
    0x3ff39c54680fb9c4, 0xc00362e38727ff33,
    0xbff331ec56694808, 0xc0100c0ea9b6b7ab,
    0x3ffcd43697af1349, 0xbfe05917e3fc425c,
    0x3fd3e1acab215628, 0x40078c4e7799fba0,
    0xc00748d71e01c64f, 0xbfd47a6df7186522,
    0xbffe160e3022998e, 0xbfe04ebdf4251c46,
    0xbfeaa75d1ff7fc9e, 0x400015e416c51d82,
    0xbfee329760cbdae6, 0x3ff8be8c72b59a93,
    0xbffe341b4d750082, 0xbffbd72b4510de40,
    0xbff55b57f71ca6d0, 0x4000b31edbebd3b6,
    0x3fe45ef25d342c3c, 0xc0049bfe78065380,
    0xc003d211a74304f6, 0xc00591067fe04b77,
    0xc011e46ac7e225ab, 0x3ff9b31cb4df9f5b,
    0xbfca57cca8a81068, 0x401327e02fe0a126,
    0xbff1a49fccde9227, 0xbff518d21f4c9d3e,
    0xbff1f9527c417961, 0xbff4176327fb56f8,
    0x3feab19aaaff2642, 0xbfff3d81de3a342e,
    0x3ff78a15383edd2f, 0xbfe934e755956108,
    0x40008d7004bfac26, 0xc000284eaefeb6d7,
    0x3fe725f89674138a, 0xbff6f434de1a8a5c,
    0x400a6b694a42189e, 0x4008b6658150a931,
    0x3feb703b4198fb6a, 0x3f917c4d47349280,
    0x3ff847b57d737389, 0xc0031f71d9f9abec,
    0xbff71dc3c526d604, 0xbff16c9d43cbf8d6,
    0xc006968e527655d6, 0xbff2cb5f89e10b1b,
    0x3fc7b643a42eb2e0, 0x3ff735226c9067fc,
    0xc0184101b90b1a7c, 0x3ff4ef3a371f3d8a,
    0xc00172ff91bc06b2, 0x3ff08949d500b914,
    0x3ffebae8f91c649c, 0xbff30befb0e0705e,
    0xbff4a97511ad4a6f, 0xbff2a5a4ef3ac078,
    0xbfe8990fc59db175, 0x3ff0e85f6afd4737,
    0x3ff823a501828562, 0x40015d0d43cde7fe,
    0x3fe8410a43ebf24e, 0x4000aa1a1a3e2f54,
    0x3feeccdae0e9d3d6, 0x400fc21b1a41550e,
    0xbffbdea27221db2c, 0xbffe05d285130038,
    0xbfdf6e4890621070, 0x3ffc95d0d9549311,
    0xbfdb5eb5a0912dc8, 0x3ff73abf5102efa8,
    0xbfe3903c659dd8e1, 0x3fca6bd9842f1230,
    0x3fe4073d105b7422, 0x3ff0cef6863e0376,
    0xbfe10902081ed6a0, 0xbff2ea0b79d87752,
    0xbfee38599593b001, 0xbf9984bf868c3640,
    0x40058926f4d5e512, 0xc00401e7aff403c3,
    0x401b98f5dffbed9b, 0xbfabae75fa7c7c40,
    0xc0056cb69ce7b0ea, 0xc00ab95713331d52,
    0x3fefc300e685bfbb, 0xbff0299987f1972a,
    0x3ff6921f41980436, 0xc0001c9f340544f2,
    0xc0037ebb9b4a9c41, 0xbfef27f6e27e79c2,
    0x400f41f1dc702576, 0xbfed42406dca07df,
    0xbfe79838b05ec6ce, 0xbff18c19fa4c0295,
    0xc002858e4ddfeae6, 0x3fbc643d0e3c30a0,
    0xbfe0049b1ee8cd6e, 0xbffb1c3851fbff08,
    0xc009e726b7515f3a, 0x400b7d096a0fbb86,
    0xbfe560078b5246ad, 0xbfe77f410dab043c,
    0x3fd5ae078a6483da, 0x3fec41dfb6d73466,
    0x3ff36949da7ab247, 0x3ff5ca5b12f2e2ca,
    0x40132d4abb038b75, 0x4005042d1f7442ea,
    0xbfe372e2acf980e8, 0xbfb3c32d4a70c3d0,
    0x3fd2061cf1775f64, 0xbff6013dbf2ad297,
    0x3fc4662a33376290, 0x3fda88aeef6cecd2,
    0xbfe975366cb3e9ec, 0xbfc580c4ca6c70b0,
    0xbffe16811f9a44ad, 0xbff3d370899bd5c5,
    0xbff32fc29c9a0540, 0xc002edda96e451c3,
    0x40007260d48257a0, 0xbfe3fbc7ba9d528c,
    0xbfb8e2da64d82b60, 0xbff766a6497d3eb6,
    0x4006ef609c44f3bf, 0xbfc5406547e44c60,
    0x400035c47b9806c5, 0x4011953cc72b1528,
    0xc00b3fb30cda30d8, 0xbffbb158e21caffe,
    0xc010a6df89d9103c, 0xc009ad63fec2e732,
    0x4016f37bccb56d6c, 0xbfe3d96a321a687c,
    0xc011e058bb464180, 0x3fe0bd3edd774b64,
    0xbfef2b7005a5c48f, 0x4003d3b5245d2155,
    0xc00303e0f06b31c7, 0xc001f8e48ca347fe,
    0x40109d17ff9f8168, 0x3fe0a24e86a0f1c6,
    0xbfcd4f5c3eace370, 0x3fff7410fc227639,
    0x400bb4c2b4be802d, 0xc0005d70418367ff,
    0x3f407cd4dcc36c00, 0xbffd18464f324c72,
    0x3ff1c6d1921d7598, 0x3fb1f2cb0b10aea8,
    0x3fdaf7c3c3074cd6, 0x3fc36488aea7e620,
    0x3ff1cc34e55d471a, 0x3fff50419c3f104e,
    0x400f8e5afda708a8, 0xc004eb76a1220f49,
    0x400256cb16ac2fa9, 0xc005079e514a90b6,
    0x3ff67fa07d60b8c6, 0xc010b9abc8f45592,
    0xbfe54d506723c9c2, 0x40050e1d3abec080,
    0x3fece140a0dac398, 0x4004dd0d6db71dde,
    0x40109d6925a8e756, 0xbfe1e6c5856a7754,
    0x40128d90fa8395ae, 0x3fa1b795e7795cc0,
    0x3ffb6b0c55f4d6dc, 0x400525e5551eb692,
    0x40051522aeaaad5f, 0x3fe42bad28785484,
    0xbffe94e496022c73, 0xc01e85b7aa50fb12,
    0xbfd25400a421ba64, 0xbfe27b8a9be2ea6e,
    0xc01a4aa98a00f0f0, 0xc00baa2aad4690cd,
    0xbfdfd07b8c39f1bc, 0xc009490e9bb47856,
    0xbfffafa3ebfd66ae, 0x40111a21a0391b16,
    0xbfba7d0da9a83f88, 0xc00bf260c342b258,
    0xbfc1bad7837b84e4, 0xc00cd93f720d4ca5,
    0xc0038d86ad15e33c, 0x3ff0dadb78c5e2f2,
    0x3ff99742045f15fb, 0x3ffa6da21e33e87d,
    0x3fed19ed596af1f5, 0xbff8422e0416c978,
    0xbfdc58bc32f42310, 0xbfe9e310b67d93c4,
    0xc00b4be2bb8789d2, 0x40124814c3b39e58,
    0xc00f999c01d0eef6, 0xbfee74f2537efcdc,
    0x40171d13879cf17b, 0xbf69126af3754000,
    0x4006fd6b8a8dd765, 0x3fd99753d02c33a0,
    0x3fffd1affcbc5566, 0x3fde761ef5122fa4,
    0xc010b5b200999274, 0x400c06c2050c077a,
    0xc002b23cbeeea10e, 0x3fe838578b229304,
    0x40049b1b07fef22c, 0x4000c34f22edd953,
    0xbfefefbc08fe5ea0, 0x3fdfca826f016328,
    0x401204d32bfb490d, 0xbffe68620846ffb0,
    0xc0056d52e28c193f, 0x400ebef7aaf33c60,
    0x3fe5dd3ad999c67e, 0xbfeb5d883fa6a864,
    0x4016bae93896cb76, 0xbfee77c3aa55930c,
    0x40027d383d669870, 0x40107a42690d0f3b,
    0x3fbf1bcccff79d60, 0x3fea9cc7356bcaaa,
    0x3ffe11b90072109e, 0xbffc640832f30646,
    0x400179cd376d3e3f, 0x3ffb6c0d0fadfb24,
    0x400cdbf59ed30e55, 0xc00199082a4b14d8,
    0x3ffa68bff8afa685, 0xbff7c9159b4cdd29,
    0xbff1434998771d7f, 0xbff32d66947246e5,
    0xc000d2ee4b8cba1e, 0xc000e4d341e8c0f4,
    0xbfeb9c34080d64f8, 0x3ff27fa19b96d866,
    0xbff7f161bc758eff, 0xbfeb955c266392d8,
    0xc00d5f3644af70a9, 0xc00a5ec82641f96d,
    0xbfe08698706e1a3e, 0x3fcdddc7744400c8,
    0xbfc7ace2c632e6a6, 0x3fefb6da00a70b38,
    0x3ffc1a5b74c95312, 0xc002a445b11411b2,
    0x401270465ce6a3ca, 0x40038474cd7e2f83,
    0x400c7b7a7f66fafc, 0x40051b4ffbdff810,
    0xc00025c04d7bbea4, 0xbff54d7cfd3ad0b2,
    0x3fb69d3bce563e30, 0x3fd89d7b5e31a89c,
    0xbff2d2ed3f92a059, 0xbf8cce5e1bb60780,
    0x4000701b875bb364, 0x400122ae28cc8e2f,
    0xbfe2b99fe3ed5bd8, 0x4007a67fa5e0a51e,
    0x3fee36482992225b, 0xbfe0182ecf899dd8,
    0x401022dc652c9966, 0x3fffc28370dd773a,
    0x4009779683aa1581, 0xbf97642f8eeb0500,
    0x3fe66620319d0f30, 0x3ffd528fa49d01f2,
    0xbff13359ea66632f, 0xbff15e5d259dd0d3,
    0xc00fabd376ba7760, 0xbffdf1af849a294c,
    0x3fd7de0f8773f4a6, 0x3fbe3325b92364d0,
    0xbfe886560efb6350, 0xbff74699d9e554cc,
    0xc00da1398261e400, 0x4005bb9227543b1b,
    0xc0097ce33189bfa6, 0x3ff1d9889c6d47e4,
    0xbfa09981e8d95c00, 0x3fff481af71a9a5c,
    0x3ff237e03e299124, 0xc00c2f1db46ce5e4,
    0xbff55102f8e031ab, 0xbff06f285f8ce82b,
    0x400e1cbb56f9a4f6, 0x3ff04de816a39ee0,
    0x401008f5a5cc7ac0, 0x4002565c6b9a9045,
    0x3ff4cca8a48f75fd, 0xbfffce350ae245dc,
    0xbff871576c39af82, 0x3fee7a4f705e2900,
    0x3fd35a02a53ed400, 0x40053dc93b031feb,
    0x3ffb33d7a727b38c, 0x3fd3b5a8aea8c4fc,
    0xbff0aaeb52c4d9f6, 0xbfd794c487d27b98,
    0xbff6ebc32ebe8d4f, 0x3ff98a5c831ff57b,
    0xc0028604b69adef9, 0x3ffaa116d2b15c65,
    0xbff56245b2cfe37b, 0x4010ee61d3786822,
    0x4007315a0bdba7a0, 0xbff111ad1a69925b,
    0xbfe1edc6a22506a0, 0xbff2e56c2523241a,
    0x3fd06c0ef83c9880, 0x3f92d762437399c0,
    0x401863ee28b1960b, 0x3fe9735422517566,
    0xbfef0973b4181258, 0x400e588a16afa236,
    0xbfd52432a007a532, 0xc004cef0c703d725,
    0xbfe0b59432a25fad, 0xbff331a61c7c82ac,
    0xbfed77d31715cfbb, 0xbff50064a2486eac,
    0x3fee47d48fd10bb4, 0x3fd04df76fe6c721,
    0x3fb286bb053a4cb0, 0x3ffac99ddc0d4198,
    0xc0011c7069b4ead9, 0x40017d45f3a34f33,
    0xbfd24416ee7fa320, 0x3ff3814d9a2bf346,
    0xc0040c490784c9de, 0xbff58dd3ed65c13a,
    0xbfced56dc8e093fc, 0xbfe5053e572b4e6c,
    0x3ff7340fa2fb4d17, 0x3ff38b899fa74b1b,
    0x4001600bdc70c820, 0x40085350a730ab52,
    0x3fd188c7ca165774, 0x400e62f96795035c,
    0xbfd12c584f221e30, 0x3fed6bd5c1831e06,
    0x3ff4c7d058fd67f9, 0x3fb23ecf6baa19c0,
    0x3fc3d169ab12bb34, 0xbffc90ecb1147bfc,
    0xbfda8b520bf7f40e, 0xbfeb4d38db8d3406,
    0x40055026e7ca1bd9, 0xbffaa1d6116a0e0a,
    0xc000561882b4f706, 0x3ff3d5b1bbbd8211,
    0x3f43a951f44eb800, 0x3fe42d611bdc90c6,
    0xc0010b8c5a1cd710, 0xc015d5d83629f499,
    0xc00bc60837985e86, 0x3fbfd45139f85600,
    0x3fe71dcddd901dd3, 0xc00c74164bf07103,
    0xbfeb204f009f44ec, 0xc010a30c925d27a6,
    0xc0077bf3a12362fd, 0x3ffe7d2e9f5c5aaa,
    0x400f798149641af7, 0xbfa04c841d6b7b70,
    0x3ffd570da311030c, 0x3f7a0d2950357500,
    0x3fce352ba58f1018, 0xc0009241d45fe3d6,
    0x3fd1bd1d8494ad30, 0xbfd287594aadf95b,
    0xbff98cc71d8252ad, 0x3f3984bccb7f6000,
    0xc007a4b0aa23202c, 0x3fd7d46d7dc8a4ec,
    0x3fe3e7c0ccfb5d86, 0xbfea2de3e80b9bc2,
    0x40051465b338a38c, 0x3fefc08da6a25b26,
    0xbfd6afb92514df94, 0x3ff85f3320cf47df,
    0x4015f23f4687dbd5, 0x3ff80b165a6185aa,
    0xc000db153165b15c, 0xbfe40abc0ce396cb,
    0xbff567367a659284, 0xbff9edf9dc3bb1ce,
    0xbfbae89bf8077732, 0xbff134e099aebe75,
    0xc0065c3cb6bdab14, 0x3fca8b23a049ea68,
    0x3ffeaa86770479f2, 0xc000342834868adc,
    0x3fe2553c68be8466, 0xc00819dd0f4351d4,
    0xbfeee225060720d8, 0xbff868c3905eac94,
    0x4010dd3f346bd9d0, 0xbfe45436ea24b74a,
    0xbff7e616bc22eb42, 0xbff51ea2723f8aaa,
    0x4001f57922f19cfe, 0xbffa382e81a9e75c,
    0xbfe5703d91865f44, 0x401054a3a4117ddc,
    0xbffc6c1d682571cf, 0xbfe338565583e56a,
    0x3fed757b0d2e68d4, 0xbffe3b0bfc2865c8,
    0xbfde7bf394d503ce, 0xc00d0510ae87e1b5,
    0x3fc21ddaf4786568, 0xbfedae7fa37c6718,
    0x3ff88acd99961fd2, 0x400a5e1ea1be1c97,
    0x3fef428dc33a5de6, 0x400fdb4eb768ae5e,
    0x3fe6aade5f06c38c, 0x3ff890797795db7e,
    0xbfc16a8eec92a470, 0x4011afdde79ae650,
    0x400e5c31795557d4, 0xbfe73f98236ac098,
    0x3fe821185dd53d6c, 0x3ff34a793d20c3e8,
    0x4005eaa97c4830ce, 0xbfd557f4a95748e4,
    0x4004423311e2265a, 0x3ffcf1cfe82e95e0,
    0x3ff9710f3ab9db75, 0xbfff57e32353d6f2,
    0x3fd50a72b9e724aa, 0x40129124e7a024a6,
    0xc009e6392954aba4, 0x3fe8125a57d636b3,
    0x3ff758e775370cc0, 0x40044d1825620e93,
    0x3ffb3058e9353e61, 0x3fefda361c4bee54,
    0x3fe56c213988709a, 0x4005e92be9e56a10,
    0x400350f7ecd171ef, 0xbfd8a0a6e6e13810,
    0xbfd08608eb7ec77c, 0xbff27685eb92227b,
    0x3fbd570884c4bd70, 0xbfe2a3c6228cf968,
    0xc0041134bcc904ba, 0x4004396f90603e43,
    0xbff1fba016d6429c, 0x3ff7f84fb5c7033e,
    0xc0092b1ad03a07ea, 0xbfffb892f7805153,
    0xbff087be716081e3, 0xc00632d85318f5f0,
    0xbff57ca7a556ae29, 0x400dbfd63f369763,
    0xc0099c6e775b38d3, 0xc003f260d0c306cb,
    0x4000f0fa0f578b4e, 0xbff0e70e23105223,
    0x3ff052761367abe1, 0xbfdecc1f7b54510c,
    0xbfe9b9ca8dbe9e22, 0xc008f7ab0df21f7e,
    0xc0048045a7a0a38a, 0xbfe826bcbc5fb994,
    0xbfeafa7c96bc410f, 0x40094a28f77ee666,
    0xc011a73b4e9dd637, 0x3ff796e7f5cdcfdb,
    0xbff057b1d4448c54, 0x3fd78087768c83ec,
    0x40153d9416e1adde, 0x3fe32f70104405e0,
    0xbfe37399bb71835d, 0xbffba493ff981d6d,
    0xc00640879a49eae7, 0x400f4a7a7f68f1ab,
    0xbfaa9225b52f2340, 0xbff0da5fcc51edd0,
    0x3fb3135c26b32140, 0xbfe8810006414ee2,
    0xc0056eb6bdcdead5, 0xc00cf7db999bde39,
    0xc001d8f168f38c19, 0x3fca1faeee0b42b8,
    0x3fd58e2c33f1b9ac, 0x40117183f84f1401,
    0xbfe4ac6a1e7d05eb, 0x3ff6ea12832ba974,
    0xbff236c75388ffb6, 0x3ff962c41fee574e,
    0x3fc5ed72aa0bf2ba, 0xc002c1e5d8150d6a,
    0x3f81da0b3ff4b600, 0xbfd4db8ce60a7864,
    0xc0029485307d307a, 0xbff516bf4a41f134,
    0xbfeda4787ca86b90, 0x40012fedfe5a2e8f,
    0xc004fe6cc6034819, 0x3fe30f5270a9c24e,
    0xbff40e75386dda6b, 0xbfe8e7aff416f558,
    0xbfe35e3c939ee460, 0xbff7bd4dc5930c0c,
    0xbfe7d0e9a30ed827, 0x3fd51ceb87f8ab62,
    0xbfd4c327fcc93dfc, 0x4009246480cdaff3,
    0xbfd382fc8dac4e9a, 0x3fb1397854d66660,
    0xbffa86a56795e28d, 0xbfe6c480bacb396a,
    0xc00f313d7fbcc752, 0x400df779f8f9ea67,
    0xbffce2fafa1b235c, 0xc011cffcaa933650,
    0x3fdd1b34a0222754, 0xbffb1d24b5948396,
    0x3f7fca3df0ae1b00, 0x4007682732f2d10f,
    0x400787a2405660c6, 0xbff0d862abf7292a,
    0x3fd6ac4b47818ce7, 0xbff97382cfebeb58,
    0xbfe8b1bac6140d8c, 0xbfc47037bce94710,
    0x3fda96dd1ff2f100, 0xc00e559cd66eb350,
    0xc0098c04d35743d9, 0x3ff795608bd2be98,
    0xbff20eea9e8ec7b8, 0x3ff479d855b26366,
    0xbff7fb12839e339b, 0xc014ef6e70923d4a,
    0x3ff2f1c97e055e99, 0x3ffa4c5bc4992816,
    0x3ff2b8592286655a, 0xbfef51fe72a2d79c,
    0xbff5b5157954c070, 0x4001dd1f45321726,
    0xc0068026798a071d, 0x3fa611392c7f36c0,
    0xc00dd0df9d20459a, 0xbfd796ed7fa84a42,
    0xbff8734b072d7d48, 0x3fe080e9f4b63622,
    0x3fee9438b8f59d24, 0xc004c8cc8b305518,
    0xbfb689dee3c83638, 0x4001c1857ac542a8,
    0x3fe2fd48bab5138a, 0x400028ee50b5a79c,
    0xc0050b9cc16acbc7, 0xbfb6e56e88e75d90,
    0x3ff9653e3907558f, 0x3fed50cd3685dcb1,
    0xbff06850788444ba, 0xbff197f9984acba0,
    0xbfff487940d555ac, 0x3ff47a1e0d133718,
    0xc012a90ed8f70beb, 0xbffc6f1a6907426a,
    0xbfc379bc49e63a18, 0x4000653291346454,
    0xbfd80c1da303667f, 0xc00187ff2fe67619,
    0xc005440726bbddd9, 0x3ff20392587711c0,
    0x3fea477502a22986, 0x4008f382be4244d8,
    0x400f233aaecbd84d, 0xc0080e10999fc7d2,
    0x3ff6095ee03e8605, 0x4000016bbd8334b4,
    0x4010b32fcc60f530, 0x4011e6c605336aff,
    0xbfe1c3ccbfe7429c, 0x40016a9b4c1997e2,
    0x3ffa98798dde57ad, 0x40169fcec0f3298a,
    0x400be3c3943853c1, 0x3ffb03f6ec0e846a,
    0x3ffd3af208da0326, 0xc00315bbc933ad2f,
    0xc0034e9cf16c8a28, 0xbfe9a01445051834,
    0x4003c8b2d43aeb6b, 0x4006ab18c55ce4a8,
    0xc0071f4f877724f4, 0x3fddd4d1e011f630,
    0xbfe825f90e3ce048, 0xbff1af8dcb2ba466,
    0x3fec67a64e50ddbc, 0x3fe570bf89a3220f,
    0x40004ffc57da198e, 0xc010a7349a792407,
    0x3ff5915414f73f79, 0xbffcf8c5d97478fc,
    0x3fce3252ab4fd8d0, 0x4000a60d3476a931,
    0xc003e93af0d044b9, 0x3ff23942f5e538e6,
    0x3fd19b168a569d94, 0x4011b49c4391168d,
    0x3fa9e34b55579f80, 0xc0067b7b4f5b1963,
    0x3ffda4df9dcab512, 0xc0069eddc0a4c518,
    0xbfec1673be869286, 0xbfe77977d2a6614c,
    0xbf86350394ed4900, 0xc001bda467922fd4,
    0xc01385af8eeaa2b4, 0x3ff297e0beef6058,
    0xc007208eddd4a8c6, 0xbfe594c4761aef82,
    0x3ff1620f9cc0b31c, 0xbffda7d747a328a6,
    0xc009dd04526115fb, 0x3fe3f7e07b3b30af,
    0x3fd9665833824504, 0x3ff323ab51877023,
    0x40057ad38f84c8bd, 0x40062649b9de54ce,
    0x3feca54bc81c8927, 0x40019ca8229c0a7a,
    0x4016416e9f08eda6, 0xbff36990ad6ebc8e,
    0x3fe11856aa651ab4, 0x3ff33540c8ae46e1,
    0x400c85edfd3869e4, 0xbfdae110248e31a7,
    0x3fe81378f684c1c6, 0x3fe23f9ed24aa378,
    0x4006328090b9d464, 0x4002333fa5a5aa76,
    0xc00b4aa24aed85b1, 0xc0065518e1573ff2,
    0x3fe4903ae918a665, 0xbffcc6240e5f4014,
    0xbff96ba1de1eefc0, 0xc00a9936062d130f,
    0xbffc2110abd93340, 0xc00174a5792a89e8,
    0x40104bd88c2c9303, 0xbffe43daac6ac4d7,
    0x3ff40981b9895ee8, 0x4003148b63f6bafb,
    0x3ffe2a5e8306315f, 0xc00adeef63f2b01a,
    0x3ff09f442f96d0fa, 0xbfe6da989b22fbf5,
    0xc0006dd46b13d056, 0xbfe6b846ed3583e8,
    0x400189be7a3d2e16, 0xbfcaf04c59f2b768,
    0x3fff53136c33dc3f, 0x4011c3132d2095ac,
    0xc00649129688e980, 0x3fde445f2569ee38,
    0x3ff2d036d31e15ec, 0xbfe8dd14c7819133,
    0xbfe2c72c0f4fdd93, 0xbfb731816ff1c870,
    0xbfee56dfc7283d6c, 0x3fff43d8fd7dd203,
    0xbfffa6b76347fa3a, 0xbffa0af2d51ad34a,
    0x3ffce8624b7af6f7, 0xc0008b02f4444669,
    0xc0024a347e86aad5, 0x40065d28ed2ae23c,
    0x3ff354f0b3020d4c, 0xc000913b05ca0c17,
    0xbfd6cabe7d7bf168, 0xc00555719614eef6,
    0x4003516d1a78f62b, 0x3fed79d3a829df84,
    0xbfbb59fb50c9fc90, 0xc01159fcb37b72ae,
    0xbfbe605f4e375228, 0xbff508ad23e1e555,
    0xc01096feb060054f, 0xbffaa67d040a9c24,
    0xc0026f48b434bec8, 0xbffca86772c17a6b,
    0xbff4ec15feb6d4e1, 0x400a9f44f548e034,
    0xc002bf8a4f996f6e, 0x3ff35ce3f95643b9,
    0xbff9aa55af1671fe, 0x40044b8d35db394b,
    0x4002aee5a936f122, 0xc00671114acd58fc,
    0xbfe9d87d565432c6, 0x4004e761ecaeb9b6,
    0x3fec21e77f0601bb, 0x4008fb30aae622ad,
    0xc00ae90b7d2cb140, 0xbff4424f3366236a,
    0x3febf0eec91f32ec, 0x4003730ba21406b6,
    0xc0099fc8538b65bf, 0x400b7ab1060757b1,
    0xc0021a54d94c8eaf, 0xbfb653ac6b3bc020,
    0x3fee3817ad3a6bf6, 0x3fb9b126c86b76e0,
    0xbfd868bc907c8d60, 0x4002cb4b04452bd4,
    0x3fec6432c090cb4c, 0x3fe50475fa1d7dc4,
    0x400b05314332b5b4, 0x3fce09e86efc5ce8,
    0xc0096c63a3ec35e6, 0x40034fb36aebffd3,
    0x4000116a1364f987, 0xc00436948b9c521e,
    0x3fe67e29c48d5764, 0x400f61e0e055f00c,
    0x3fde9378431e51c0, 0x3fedf5be3104d4a8,
    0xbffd1a03bd26e307, 0x3fd426d17741785e,
    0x3fe2d7ad6d7847a7, 0xbff5042986354feb,
    0xbff397b95cc52106, 0x400d0a22c3259e3d,
    0xc00e235c8d9d0fc8, 0xc00383e2d6a2eeb1,
    0x3fe9fec01b017ea8, 0x3fcf68fbdb90d034,
    0x3fe4c1855eddd5ac, 0xc00b5323c8a1054c,
    0xbff346d970bd875b, 0xbfed660d66335664,
    0xc00645430162e7cf, 0xc001f0a608a7a885,
    0xc005c4f02cef4d01, 0x3ffdd50d4b336248,
    0x400556bc67bf6fc0, 0xbfe60b061b9f3dfd,
    0x3fd2bf53c48b48fa, 0xc007cf172cb6870e,
    0x3ffe2b2952e85fc1, 0x3fe84da28f77ff80,
    0x40118eeab284a0f2, 0xbfe982e510388b26,
    0xbfd291eeafe7b730, 0x3fef9b391cbb202c,
    0xc014f19d93ef83ca, 0xbff94e4a57564906,
    0x40034760e9182870, 0xc004e8b6b824bcb0,
    0x3ff345f066094660, 0x3ffe3bbc53993f33,
    0xbfd2446e61defd9e, 0x4004f0f029589c1c,
    0xc000e607ae23dcd1, 0xc011a5f545865853,
    0xbfd834b85a9afb48, 0x3fe253be4a03aab5,
    0x40147c7fadcf00db, 0x400f5b4ec03686bd,
    0x40086f6ad65bd1be, 0xbff830c7fcc08abf,
    0xc012610077e41eaa, 0xc0033b4b5ba2078b,
    0x3ff9003af5a456bf, 0x3fe621fdde738256,
    0x400182f59a6546d1, 0x3fffe7ba9b01be30,
    0x3fd9ec97cc10a20d, 0x4011b20d464ad092,
    0x40067932de90b8ee, 0x400c781154998282,
    0x3ffddeb93806ed9c, 0xc001f18c66aefd2a,
    0xc009be7aaa2c45a6, 0x4001dd90e0f3ebbf,
    0x400b98da7eb5d54c, 0xc0089ba06b296225,
    0xc012a72d33b5a0e0, 0x3ffda9eddd8ff535,
    0xbfb5fffbb9f04650, 0xbfe46b3c871e93d4,
    0x3fe49c97a2e6b94c, 0x4003041501a6038b,
    0x3fdae80531eb70ea, 0x3ffd5c1dfaf3a95a,
    0xbffcace9db85321d, 0xbfee1c05dd5bba24,
    0xc013afc050d7c082, 0xbff133e3679775d2,
    0x3ff7278a6769d6d1, 0x3fe0067411b62c50,
    0x3faafc20482933e0, 0xbfa00807e55485d0,
    0xbfee047c714f5df2, 0xc00028898cea4808,
    0x4011cf8bc01cb294, 0xc0040a628a369d47,
    0x3fb40fcc534915c0, 0xbfeef2299a467dfe,
    0x3ffb23cc4db70be3, 0xbfd2edc10d20e80a,
    0x3ff55f74083c2cae, 0x3ff706313e291142,
    0xbffdd95b8c03eb83, 0xbff0bf866422ded7,
    0xbff35fff8fe6693f, 0xbff0d2b6073f0900,
    0xbfc7989b67b392d8, 0xbfc38294fa56a358,
    0xbfe7707706a2ff8f, 0x3fa00c2362806178,
    0x3fe1c848f0a6be70, 0xbff249faf556ea3c,
    0x3fd0aa5f1f5a461e, 0x400b1ea04e964547,
    0xbfe4680ae09c9871, 0xc00907f935b020c7,
    0xbfa52fbf33fcc750, 0x40079ce4d1c3f091,
    0x3fe780e487567f14, 0x4002cf9883494678,
    0xbfe24abe0d1a7d0e, 0xc0062fe6a2dc7786,
    0x4016edd3c582a0db, 0x3fe012e4ddc3df22,
    0x3ff1fe13a3566c7a, 0xbffa451d72e90b1a,
    0xc00072a1dc681781, 0x3fec5b0087481eb0,
    0xbfe3e88b122e8288, 0xbff81f8a5ee78f56,
    0xbff4e80277a04e22, 0xbff1cec799999696,
    0xbff04a06ab33ae62, 0xbffe8801cde850f0,
    0x3fe94158f26a411a, 0x3ff949f8fb4cf3e9,
    0xc005e1291117affa, 0x3fce8142364b1ab0,
    0xbffad274d98d7cae, 0xc00c415906c178d3,
    0x4003fd4bb9b86ae0, 0xbfc84d74fc8b0cf0,
    0xbfe423b50e3c2b54, 0x3ff4768306c7a9c8,
    0x3fe00c854b33ceff, 0xbfdcbdb468ec8640,
    0xbfd5ac3b02d129d0, 0x3ff8666f83395b08,
    0xbfd26be1ee94fb60, 0x3fce5dbb5e22c64c,
    0x3ff0edaab568588b, 0x40041943faf05052,
    0xc0026b3d768f855c, 0x3fd0cffa30c6bda8,
    0xc009ae03265a07ec, 0x3fcf75ebb569b000,
    0x3fe15c4abe80e4ba, 0x3fe1d51954bc009c,
    0x3ffd4f5e436ee14e, 0x3fe1754c995cc696,
    0x400239c76513ee05, 0xc008f65634cbdb0d,
    0xc00409f1a5a6957c, 0xbfee85d67c14109e,
    0x3fff512b3db492f4, 0xc0128ad8b1399a8e,
    0x3ffad18d3691adac, 0x3ff40aaacefce8b0,
    0xbff4c501d99fcec5, 0xc0125ea28f2d790e,
    0xbfb33b3756153ec4, 0xbffc34be0d21b682,
    0xc00e793a396a2287, 0xc0061e9f049320ef,
    0x3fec3bac548bf545, 0xc01d34f4167fe8a6,
    0x3fee08595bc7f3f5, 0x400b6cfbb2640c39,
    0x400cf375883db8be, 0x3fde6eb4ec61e066,
    0xc0015bb7feec0928, 0x3fd48e1095c32910,
    0x3ff92cc5072fbe46, 0xc0072b03fe3870c7,
    0xc004a396b4dd31a9, 0x3fefb6d402994fe0,
    0x3ffcb602e30bdaf2, 0x3ffdb2d8d22eacfe,
    0x4000525f1bb5c540, 0xc013bcd16604b3e5,
    0xc0017b5ae20b238d, 0x3fcf856c3a77c0b0,
    0x3ff46701859a8054, 0x3fb9983f852354c0,
    0xbfee311faf1c641a, 0x3ff42c25d41a3119,
    0xc0154479f4f9dc0c, 0xc00da4d749cd5faa,
    0xc016a872d0000c88, 0x400130d178f48472,
    0x3fec4535aed08d6d, 0x3fc5fe5e6b4ce750,
    0xbfd5b0ec83e734c5, 0x3fd099bdfaee80bc,
    0x3ff59b67060d68e6, 0x3fec4bcd106b475c,
    0x400d20b5b52005c2, 0xc002b3932ddfb65d,
    0xc016923930b2f250, 0xc002089008357820,
    0xbff8f8daaa597e64, 0xc00301442950b870,
    0x400962a31d8e060e, 0xc010ec8f4496b536,
    0xc0012829cddba3b7, 0x4004ddab03455e9a,
    0xbfc09795726fbbc8, 0x4008992f5dc37087,
    0xc0037dd8a8c07251, 0x4000b46e64c391d3,
    0x3fc5106ae4f7c332, 0xbfd67aac69f2d736,
    0x3fde89fe46c054f2, 0x3ff389b08d8b4462,
    0xc013fec12ebe8ae4, 0x3f9a341100e54cb0,
    0x3fe0cd072973b232, 0xc00860ef93947bea,
    0x4007c392dceb99f8, 0xc0082c3df5f03e94,
    0x3ff50be95968a9c3, 0x3fe22a8ab7f38bad,
    0xc0072ec6b70b47ff, 0x3fde5c22d70148aa,
    0x3ff3a7188f9664c5, 0xbfd86af1b42735fc,
    0x4004d629daf82492, 0xbfb410e9f697fb58,
    0x3ffcf4d5e43fa605, 0x40046d3cf9dbaa8c,
    0xbff42db362c2c84b, 0x3fee61a90d14feae,
    0x400ec9cc543cfba3, 0xbff85970bbe9a09e,
    0x40041284ab1cbac8, 0x40001767998c98ad,
    0xbff6b8216a2477d0, 0x3ff8b8e3dd2702c9,
    0xbff3fcdf7ffa98ee, 0xbf65b37fcb19eb00,
    0xbffb338dc6813642, 0x4003256e35224c76,
    0xbfdf89d58933ffe4, 0xc019b8ed558181fa,
    0xbfeab7a1d49df785, 0xc000ed4765a110a8,
    0xbffa2ea7ec6938e4, 0x4001dbcda70118b4,
    0xc00b38061040a300, 0x3fbc3504e73a9258,
    0xbff17cef14a9f0ad, 0x4002f9508b20975b,
    0x3fe59251bc58a17c, 0xc0111cefe1f4250e,
    0xbfc6b977b05399d8, 0x400120d4cfc9b920,
    0xc0039b670d8fb3ed, 0xbfdcedbfae01e71c,
    0xc00199b577de8c25, 0xbff3b2b523817e33,
    0xbfe0cebaa5ad314e, 0xbfdb4b383d25992a,
    0xbff3bd79783fcaf8, 0x40194828cd241b5c,
    0xbff365dacd4dbb16, 0x40114cd3fe6454e2,
    0xc000f1e32db8ee08, 0xbff14eeaa9f8b026,
    0xbfff76f3537366ec, 0x401302c853288746,
    0x3fe5efbfc02e2e65, 0xc0097c8c7660cda8,
    0x3fc0fe9df36b6aac, 0x3fd43967c6f2a788,
    0x400a554416c6d926, 0xbfe76195942fff16,
    0x3fafd55fafe11c60, 0xbffe6b3064abee7a,
    0x400583f7155db6c8, 0xc014865c4a7437dd,
    0x4008540a1e4825b4, 0xbfcaa0dfe9843704,
    0xc007f0c1ed5da1dc, 0x3fbb0392e4dd8bd2,
    0xbfb947ddaad03e00, 0x3feab442a90090ca,
    0xc004c710138f91cb, 0xbfd98f13c5a962dc,
    0xbfe9fb5bed9a8e04, 0x3fb1e0c473a14638,
    0xbff03b512fc20e00, 0xc0032499c88fe685,
    0x3febaa40044d30fe, 0x3fc5bf1178ca8920,
    0xc00302e96fa1f92a, 0xc0057c1d2f7c6a5a,
    0x3ff8eafcfdc96117, 0xc0128e6421306a89,
    0xbff274c37327d46c, 0x3ff9e729efd0e1e4,
    0x3feaa7d7a532e4d5, 0x40076b881e6ce598,
    0xc0028d8f1dfae50a, 0x3fe5ac44dcb5b003,
    0xbfd83f036dcb71f2, 0x3fcae8a8973cb2dc,
    0xbff9ccb747e0ed8d, 0xc00e4ef6801f29c0,
    0xbffb6a5eca1d28c2, 0x400cba4b219be8aa,
    0x3fe36e2c8c88de0a, 0x3fde1ff632d8a956,
    0xbffa1c0a61704326, 0x3ff13eef433a3e8d,
    0xc00364f178e3f0c4, 0xbfba110ac40664fc,
    0xbfe148be195b47f8, 0xc00dd16939f0be8c,
    0xbfe23736292d9f1c, 0x40118df716bed3aa,
    0x3ffb6ad2ac82df24, 0xc001195bf0523284,
    0xc0080f73c4403ab8, 0x400249cabdc1122c,
    0xbfccc54732dd90d2, 0x3fc49bc5ca8213c0,
    0xbfecd1eca8ec1b34, 0x4008b088050c3a61,
    0xbfef7e5b5057787b, 0xbfff7a018f42f31e,
    0xc0091ce7db16014d, 0x3ffa2ed7466ac4d1,
    0x400b76e812e1bd6d, 0xc005491131477ce7,
    0x3fef61f37ba9cc71, 0x401308eb3886395c,
    0xc01663ac7671c48b, 0xc00ab96a4437f4bc,
    0xbfe2e079605a5344, 0x3ff25d3875779932,
    0xbff8cc996260aee3, 0xc013321718b33e00,
    0x3fdc291d7b521100, 0xc011423b29306886,
    0xbfc4096ebf9346c0, 0x3ff539e9313a1d3d,
    0xbffe699c88f687b7, 0xbfd029fb541c36e2,
    0x3fcd9708be56ebcc, 0x4001c2ae1c2dde5d,
    0x3ff62c406670d566, 0x3fe7449f8e1f48dc,
    0xbfa4d62d37e629e0, 0xc00350d8b4cc8fff,
    0x3fe3c86ed2d125f6, 0x3fc94a64dda20520,
    0xc006be87b07a59fd, 0xbff94b0d7f87751a,
    0x40020a69cc204e1e, 0x4005ada939cdd089,
    0x3fd6564a7f0b6c96, 0x4004728a3df749e7,
    0xc0119ac3220c869e, 0x4007903163130783,
    0x3ff02870cfefd876, 0x3fc42798a9680070,
    0x3feaa064afd59e28, 0x3ffb1fbbc5929818,
    0xbfc41077dc518094, 0xbfe8906ce6d2eca8,
    0xbff35e039745680a, 0x40118f831e46302c,
    0x3ffb36309d5b1041, 0x3fd5f083177d997d,
    0x3fd2ab0ad2b01dc4, 0xbfe47e0159400380,
    0xc008f7476e5cedf6, 0x3ff959f122a4ba7d,
    0xc0067f950e6c27e4, 0x400b668d290501c9,
    0xc00bd5bd64e016ab, 0x3fe65d9fc475847d,
    0x3ff491565515be56, 0xbfe1f151cccfbfe3,
    0xbff3a9399bc7b1ac, 0xbfb1c1ddf974e9b0,
    0xbfc84e8393021180, 0x4009256706da46e5,
    0x4012538e7282abf8, 0xbf76e570437e5200,
    0xbfe050541564a34a, 0x3ff2c87c83bb5bb8,
    0x3feb29fa3db71850, 0xbfff146c1b03e5fc,
    0x3ffdd1de4f387adf, 0xbffe6d8294dacf79,
    0x400fbeceef5cba50, 0xbfd5aa291de703b8,
    0xbfebd0cb888ad634, 0x3ff1a770f08a09b7,
    0xbff21e7722499bc3, 0xbfda57395b8ffd28,
    0xbfff4821ef83763c, 0x3ff45f428bb8b5f8,
    0x40106384bce3cfde, 0x3ff1c931f3dd315c,
    0xbfebc9891b0a8f54, 0xbff93bbf638f4c0c,
    0xc002f03291fc783d, 0xbfec6033971fa292,
    0xc0036179200b02c7, 0x40076f500e85cf6f,
    0xbfb0d97196343510, 0x3ff0e92fcc59a856,
    0x3ff6c18b3f567aaa, 0x3fe8a0e216346c9a,
    0x3ff66c65aaceb6e4, 0x3ff57860aa175c20,
    0xbff25edc931af12b, 0x3fcb1d3d6c46f848,
    0x400b582fced506f1, 0xbff4b81b3eb465ac,
    0x3fd3d43031513e3a, 0xbfe59cc945dabf1c,
    0xc002314f53d26aaa, 0x3fbf9076f290ffe0,
    0x3fd998c872137b28, 0xbfecbf6b2876bf54,
    0xbfef57df9e5dc4fa, 0x3fe5b22cb88318ea,
    0x4001a323e2ed38f3, 0x3fd680670b1daa98,
    0xc007a40cd69d4d5c, 0xbffe08e1f8ca1d51,
    0x3fbece5b4853efb0, 0x3ff3641d37ba565b,
    0xbfe1abbfd1574db3, 0xbff3e89706076fc3,
    0x3ff56662fe805cf4, 0xbffd58f471c68a6f,
    0xbff1b244646cd1c4, 0x3fd605623ef7b8dc,
    0x4005ee2488eb1c84, 0x40050e1a5a8ba00f,
    0xbffa1bd083056940, 0x400e263f7906ffc2,
    0xbff665c640da2386, 0x3ff4c757ee49a524,
    0x3ff8fea2164b84ae, 0x400a84b5c635d01d,
    0xc00183a045b087d6, 0x3ffdeac3e22299db,
    0xc00692730ffcecac, 0xbffd91a738022f38,
    0xbff99cc3a5b4418f, 0x3ff86326d01194e6,
    0x3fef9afdbf741db8, 0xbffe3534f6a3bf8f,
    0x400682e2bd76c47c, 0x4003686ed5f9cba9,
    0xc00669a76e76779b, 0x4010bf16ab24bee7,
    0x3fe00e7760e3c818, 0xbf987829f10dd1d0,
    0xbfe9b2f7366feb7c, 0x400976f96f8881f2,
    0xbfda757adffe6b73, 0xc012940b9b1ad368,
    0xc003b5e3c7c0e584, 0x3ff0accaba8fcdac,
    0xbfacbfc1818b8490, 0x3fde0fe045ae9828,
    0xbffb252b028fe596, 0xbfee88b92323ffae,
    0x3fe1075b45a83ee0, 0x3ff48ee9bdf4db8b,
    0x40052d33e4c78d2a, 0xbfe2626c97113a28,
    0x3fdf89930ee56f24, 0xc003dabe85a5733a,
    0x3fe2cda845cbbffb, 0xc0033282c7b229e2,
    0xbfebdbca4e587958, 0xbff18729b9f8e938,
    0x400088928017d537, 0xbff884c966c7b438,
    0x4005ad713fadda07, 0xbfefd096fd217412,
    0xbffb110f33f7759b, 0xc00055977cd98d5e,
    0xbff44cbf7e327921, 0xbfee0d8db5a2ba1e,
    0xbfef79b393d03366, 0x3ffabf91e4f6bec8,
    0x3ffec030e9bf8ff6, 0x3fd0d9b7384cd464,
    0x3ff760997c62de4f, 0x3ffbf85450aa0229,
    0x4008f9a1e3435704, 0x4004bfd001fd822b,
    0x3ff01306ac028922, 0x4004b1c0c0c360fc,
    0xc00e8fcdd72e3fd0, 0x4008063a70be00ea,
    0xbfea5a8876314a8e, 0xbfe8d9226d59060c,
    0x40016dad81f71192, 0x4003cb97f7c1e920,
    0xbfda8ed457dad20e, 0x3ff6db91f501ad3c,
    0xbfe1941aaf785c7f, 0xbfebc01597941714,
    0x4004b845ae564fad, 0x400c92c2b5a21b72,
    0xbfe1dd79a5a45698, 0xbfbc1da528a84008,
    0xbfc4f3a08d6a42d0, 0x3ffbf5b53787bfca,
    0x3fec3bd75946c8af, 0x3fed339bfc383b5f,
    0xbff34b76e61f1b92, 0xbff5525093f62c3c,
    0xc0154e70bb9ec914, 0xc004249941ba4098,
    0x4004a4aed0946070, 0xbfe5c75e332c7d4c,
    0xc0115df863daceaf, 0x3fe6112735d53bb4,
    0xbff0611d3fce968a, 0xbff7a383139ed7aa,
    0xc002fc9402d47b04, 0x3fee6408f7318e5c,
    0xbfe0593db251fc6c, 0x400adbd8973ae520,
    0xc00a5810d43fc065, 0xbfeabb403744d92d,
    0x3ff0a696527d0182, 0x400f9020244e4293,
    0xbfd3c98a3d896de8, 0x3feda7434bec4d2d,
    0x3ff900f913ffe67b, 0x3fe143a9f806eb3e,
    0x3ffdb62c951a4aaa, 0x400e0302e367ec62,
    0xbfed99d8063c9bd8, 0x4003bda9b5031ac9,
    0xc00835fd879fa8bc, 0x40032fc180f4f788,
    0xbffe4f50faa31f8b, 0x3fd0b163499cd958,
    0x3fea225d27dbe9a0, 0xc00df763a6a90d98,
    0xc00f7c69f700a15a, 0x400c60845cc01563,
    0xbfe7040b04710a9c, 0x4015ecd0082189e6,
    0xbfed54c6fd82978c, 0x4003ac35eb970723,
    0x3fd3833f929a6858, 0x3fecdf4b501516e8,
    0x40068b32b4b7ebca, 0x3fe98ab6e9649419,
    0x3ff1fb48ffaee7c7, 0xbfc90f0db4ea5780,
    0x400279bf1313b866, 0x3ff14b454b7c2bf8,
    0xbfedacbf4a1fa7ca, 0x4015398b7d45396c,
    0xc00228b9c9e19b12, 0xbfdfefff05fb0eb6,
    0xbffa67b8df715692, 0xbfa72ca34ee1a45c,
    0x4011366a03400771, 0x4008aa09979a35e4,
    0xc000262f5ea147d1, 0xc00f13e97ec767ee,
    0xbff9e1a8c2595672, 0x3fff98c86a9bba2b,
    0xbff57293fd9fe992, 0x3ff82a1ca3551734,
    0xbfe0392c1cdfb202, 0xc01562915231c797,
    0x401369e132b311e8, 0x3fc999a5f2b64d3c,
    0xc0039b47c41b4264, 0xbfed8282cc9695ce,
    0xbfb28c24c6aa7dd4, 0x3fedac5022e75ac8,
    0x400233812847934b, 0xbff57f839b84bb9a,
    0x4000dbb9b6979186, 0x3ffd6e40244957d3,
    0x40065e750bba813c, 0xbfdcd55c74a2e7cf,
    0x3fe5ca6c4852de10, 0x3fe4ef664d5d06f2,
    0x3fe721c51607411a, 0xc00442db2330ce83,
    0xbfe0ddecfdf292d8, 0xc003eba5ff8537ab,
    0x40189c3a6f38d874, 0xbfe8dcef0db7b460,
    0x4008f9bc1bcb3fe0, 0x3ffb94d7c3dcbd18,
    0xc000ee17ba50e8ec, 0x3f9db3c01d52e420,
    0x3ff090a8b20c7eb6, 0xbfb0aab43efb6e7c,
    0x3fe1aa5e8ee490a4, 0x400ed791f84eec92,
    0xc0079db1fca3e092, 0xbff5e26d9f5f9ef9,
    0x3ff44b7a764c3f3c, 0xc0128c7407bf4f2a,
    0xc0039f8336e79613, 0xbfff49ea600e46e4,
    0xbfe734590e568683, 0xbfa9b7f767e80f90,
    0xbff4c05590fec0fb, 0x3fd11d7e9df765fc,
    0xbff0737a00a6a794, 0x3ff2b258fe0cfe91,
    0x4007c52257452d75, 0xc00edd8f4686cf1c,
    0xc00156adc8a30c08, 0x400e3eb459c73ff5,
    0xc0024992cf90918c, 0x40144dd5006c26ca,
    0xbfed99af6a5b50b2, 0xc00b09d2f3c5a4d1,
    0xbfe699ba9dc6d86e, 0xc0093972cd5bce75,
    0xc002f2331d601f94, 0xc00074e87b11b071,
    0x3fb5c468b2031ec0, 0xc002f01954f2e250,
    0xc011a330acb295bf, 0xbffc2211402e705d,
    0x3fd22c430b23c558, 0xbff88f8bb3137eac,
    0xc00b3cd4dbf4351e, 0xc00239a13a1347b4,
    0x3fff3e6d4be41622, 0x40085b8c8af82748,
    0xbfffeb214fd71b36, 0x3fca709d46c66f20,
    0x40109ceddf5faf30, 0x3fe638c66c00e868,
    0xbfdfc2e53e979654, 0xbfef92a02f8ccdfc,
    0xbff0f12380ae376a, 0x3ff794a75b730204,
    0x401626507030330e, 0x3fcc45ec154c1f52,
    0x4000f3a16ff7d9e2, 0xbfe9ff55b754cf62,
    0xbfe87f55f57b2172, 0xc002db31a6f8d3e5,
    0x3fc193d82dfd0de0, 0xc00788478e8dac6c,
    0xbff99325796eed87, 0xbfd4b34f5faaa5fb,
    0xc0011b7d836cbd31, 0xc016bb121bff6bf7,
    0xc01b52934c2a2988, 0xbfe048cc172bb2c1,
    0x401166990e4be567, 0x40065c72f397e67a,
    0xbff24387778bd44f, 0xc005aa4053bc47be,
    0x3ffffd946354054c, 0xc00a88f161694cfa,
    0x4007e490b1e12def, 0xbffd8208120ac558,
    0x3ff370e35aaf2153, 0x3fe02bf5eac367fc,
    0xc0131f1c8713a18c, 0xbfe51ba2517a647e,
    0xbfa438fccdd695e0, 0xbff99f1a757be5c3,
    0x3ff01930101e54fc, 0xc0034e907d2388a4,
    0xc00007551d1cedc9, 0x3fe1e4ed709db0df,
    0xc0136d64af90aced, 0xbfefeba281b46e60,
    0x3fe4350d4bc50140, 0xbff6b8c19065d0a6,
    0x400228b61a8e97da, 0x40068f0e4edecba1,
    0x400d9a640e9f4c08, 0x3ff3ea33d85f10c8,
    0x40160ae771c3b0c8, 0xbff4f0b1398baa90,
    0xbff5a29be7181596, 0x400b294d470bde62,
    0xc00b668c745b95de, 0x3ff00d0383e4cf48,
    0xc002afb79d838ede, 0xbfe3b938ad95f080,
    0x3feecc23b7c3556d, 0x4003a639ccad5e7b,
    0x4010cdd25cbfa64f, 0xbff83e62b8268bcd,
    0x3fa2eaf9e4dd85e0, 0xbfd34cfa5f838acc,
    0x3fb66395657388b8, 0xbfee3672a58c34b2,
    0xc0016385e92806c0, 0xc005c375026f5fbd,
    0xc001c78f9c646112, 0x4001231f741614fc,
    0x3fdaa7c5c704ce14, 0xbffd9dfbec7abd4a,
    0xbff7aec436b03335, 0xbffb7a716ac6aeab,
    0xbfdeb052b4979e34, 0xc0081e86069f14fc,
    0xc00d37190c2c847c, 0x3fea04b9c6f062f0,
    0x4005622b42e72474, 0x40072c55df7bff7b,
    0xbff28da735dd6375, 0xc00625091ba53d62,
    0x401384651851050e, 0x3fe50c5727af09eb,
    0x40027a779664190c, 0x4000a610d362d5f3,
    0x400986a2ca113ef4, 0xc0033e3169bceab8,
    0xc011207c539ba020, 0xbff3cc405cde62fe,
    0xbff341efd043fb3a, 0x3fd653522e2496a0,
    0xbfed0bd8fdf385e6, 0xbfe934aaea87ecf9,
    0xbfed6d2be7138262, 0xc005ae9075c48b53,
    0xc004f3019c82da25, 0x401108e3667aeeb3,
    0xbffb9bcbfb565529, 0xbff64a4bd12bd898,
    0xbff7c9ce5aa4749d, 0x3fef5714d4c88e38,
    0x400045a952c6637d, 0xc00571e29ccc9972,
    0x3fd443a99e611424, 0x4012af84cd093326,
    0xbfc248d2c586c870, 0x3ff3c326c2347f3e,
    0xc00acee1557870cc, 0xbff605e2f26b5870,
    0x4004f74c9ba364d7, 0xbfec9595649f5efc,
    0x3f7b287b363ea200, 0xbff077e8ccbfad20,
    0xc00ab638541a6755, 0xbff5309bd768a702,
    0x3fc33d712465ccdc, 0x3ffe50ede2fb82fb,
    0x3fe409a17529a6e6, 0xc00234b5389828fa,
    0x40010842eb853ac9, 0x4004d7d3ed120353,
    0xbfe7668c3224d56f, 0x3ffade23a106d110,
    0xbff91e4130ed4e48, 0xc0017c11a8e52c4a,
    0x3fe778d1a2efae9a, 0xc003b567d3f2e346,
    0xc00e3b7b8ec5e946, 0xbfde70f1407e60ac,
    0xbff5f75c399cbce8, 0x3fc786e5a4622708,
    0xbfe95e8517e7eb6d, 0xbfe690438fc7fa02,
    0xbfd00ac144659934, 0x3fe5be7513044ed9,
    0xc00dc42e3be4803d, 0x3fddbaddaa13ad40,
    0x3fa16ffed7e30370, 0xc00426e5dfc6244a,
    0x400e7829f2258b91, 0xc01028d6a1d3a984,
    0x3fe5818239784930, 0x3fd384da675a7698,
    0xc001b02d5fd84c09, 0xbfde15980e684862,
    0x3fef30f84da2cd6d, 0xc001af6ee8a6fcbb,
    0xc018521fd133791a, 0x401014de2c47b194,
    0xc001870a1e8951b7, 0x3fd25b167711d98c,
    0xbfe0df9ce9aeb2dc, 0xbfff0bd40cb25ad7,
    0xbfee6826de7da3bd, 0xbfb025dffb3d0e90,
    0x4012b024c2a270c2, 0xbff536f031f732ef,
    0xbfc49fcb6c758800, 0x3ffa84c6150e27a8,
    0x3fbf271b4e5798c0, 0x3ffae0a6b014288e,
    0xbfcc7df549332504, 0xbfe4da80701597b8,
    0xbff928415b8d4070, 0x40023e5c501b6264,
    0x3fe2f6042f6eef86, 0x3ff8862182043f2c,
    0x3fec3ca4fec1e5f0, 0xc0115c1e5385f1e8,
    0xc002a9cc37996828, 0xbfd07c7c64c44a50,
    0x3febabf3b18f012c, 0x3ff7df77a3e7fd21,
    0x3fe07d9020dd908c, 0xbf80ba3423210100,
    0xc0032b57ef2810a7, 0xbfc5a714f2a965ae,
    0x400a6c81b232e68f, 0xbff82a351c51f603,
    0xbfc1b962bb2a8544, 0x3fef1f8c7001efab,
    0xc00b4227b003ca22, 0xbfe3f5146e1b82ee,
    0x4006f2a8efced862, 0xc004e1b32b9743cb,
    0x4012d7ea92e4b154, 0xbffc63c8b91b7e57,
    0x400809cd4c5d7733, 0xbff88ebf753c42df,
    0x3ff07fe94c50e5f0, 0xbfe9175e771b99d8,
    0xc0021c7c15679876, 0xbff16d0d4bc1c6ba,
    0xbffb1821ec4d047c, 0x4000749bcd3a2d80,
    0xbff737afe107f4cf, 0xc009daf0775320ec,
    0xc007f8ea2dbfca0d, 0x4012c4180d400f27,
    0x3ff57193ad2e37d8, 0xbffd80354636e485,
    0xbfefb90f7d624c30, 0xbfe44425c7ea98c0,
    0xbf84cb78d93e7380, 0xbfdc84de3b94527c,
    0x400845f9fd556bc8, 0x3fee2e8b88cbfb01,
    0x400958242d4996e5, 0xbfe3b83a809c59ed,
    0xbff190c2be4a71c1, 0xbfeea1a2a609874e,
    0xc00557ef76a26dec, 0x400e7ce78d9fe955,
    0x40014a2382ef4bf8, 0x4000374d2f480752,
    0xbff29e63df104a50, 0xbfed32d70b612abb,
    0x40123f695f4f30d6, 0x400b87e8a5913985,
    0xbfce60534b0a4834, 0xbfe870a869b85e38,
    0x3fffffe62b62c11d, 0x3ff395f631e588a6,
    0x3ff9708549126b3e, 0xbfbb39ab2f1788d8,
    0x3fe27f0a283831e0, 0xbfd818bfab35daf4,
    0x3feefe6a77742b43, 0xc00ce2a166e27a54,
    0xbfe3a356961dd8ce, 0xc000c28d0792f1b5,
    0x400c4b66681046fe, 0x400b33bb41877ed5,
    0x4008d0cf96d7c0f5, 0xbffd7ae45526ffde,
    0x3ff0d794105ace76, 0x4001a83256a238d6,
    0x40091775926f5462, 0x3ff76e9092a55b8c,
    0x40124a0b5df3b8d8, 0xbfef52e67a7bea42,
    0xbfe8a5d4717c1d20, 0xc00e18ef38f21e0d,
    0xc012123ac9e46ec2, 0xbfe70bc223264419,
    0x3fe43384d6d7041c, 0x40112b7be63434e7,
    0x3fc60b5c1a867848, 0x400010cdf9af31de,
    0xbfe2c4bc52a79fec, 0xbff2297ea0979e84,
    0xbffb82b506dea399, 0xc00486fba854e97f,
    0xc002da6c066e8c34, 0x3ff13c36dafe3e97,
    0x3fcf32a1a1af5924, 0x4001c27780d46105,
    0x3ff8ab0e0d91f3ac, 0x40106c32ce0c0b49,
    0xc0057a96a8e31ec4, 0x401a95f3011787e8,
    0x3ff8749a72d8bd85, 0xc0145e664a17322a,
    0xc008f2e4ec8ce1be, 0xc00b40bf3f6b2b68,
    0xc006765f0d462fd2, 0x400c443013f32e24,
    0x400305176a8e8a4a, 0x400d591849c3167c,
    0xc00e30d159a3bf66, 0xbff3c5cb51535610,
    0xbff7465927f57776, 0xc00f7adf88b967ba,
    0xbffd3f13230e5f41, 0xbfe70239541fa5e2,
    0xbfdd7e4f1e8a6cd8, 0x3ff8a08250b65c64,
    0xc0021bfb5c15d63a, 0x4000f6f7f3671c0a,
    0xbfd246b887dbcc2c, 0x3feaec18bf9d968b,
    0x4014f052ced95b6e, 0x400320f12e6e6252,
    0xc003bd582aac168a, 0xc005254e457d3554,
    0xc0031fca2c61cf84, 0x3ff0e696de8e230c,
    0x4000889358fe6224, 0x4008845deadfc1b0,
    0x401307efd1a1fb26, 0x3ffffcd5841e79cc,
    0x400e0dd48adddafe, 0xbffa40213df2a124,
    0x40099e5bd4243d2c, 0xc00aafe3b1187f83,
    0xbfe424d00bcf8930, 0x40058cc093250f10,
    0x40116af2458b780a, 0xbfef2b9c4141d6fd,
    0xbfd6f0bcc062f9bc, 0x4000ea59bb7e838a,
    0x4003c6da1e2c3cc3, 0x400e42a242c587e5,
    0xc0077162e3a8a091, 0x40127eafdfaa5638,
    0xbfd9652e99d016a4, 0x3ff9ec14705a2871,
    0xbfd09c2258953928, 0x401050dbc5fd7a13,
    0x3fd74b4e63ab76a4, 0xc00482bcdf828b19,
    0xbfed63e7535b0b79, 0xbffea5888cf8d0ad,
    0x3ff5641440ed704a, 0xc0026c2507dcbf2d,
    0xc014bdfeaf31ec56, 0xc0037eabd73aec4e,
    0xc0001a852f8dfe05, 0xbfe9fca33803de5f,
    0xc00059c396389153, 0x3feebadfe450d6b4,
    0xc0121ff3b98f190d, 0x3fc8c53a07d99a4c,
    0xbfeaff3fc5cf8db2, 0x4006c43bed7d4666,
    0xbfc2aa7a1f214790, 0x3ff1715351f6f74e,
    0xc0026c99aede8fa2, 0x4001783ac0c5f4b8,
    0xbffb60244d18e284, 0xc0098e5e81e8fac2,
    0x3feae9a6be6c2771, 0xc0009ea392c94908,
    0x4006c8552eaaab1c, 0x3fdf889b5ce69b41,
    0x40005021120036a1, 0xbfe1969ff2e67fe6,
    0x3ff9c2963bc1e24a, 0x3fdc43acb03199fc,
    0xbfedd366657ff898, 0x3fffeb5d31fa991e,
    0xbfda2a6d3c5a9598, 0xbff3772107aa368a,
    0xbfeefea7c4bc58f6, 0x400041b37070b7c5,
    0xbff22c965a3f9a01, 0xbffb24c3fc2396a8,
    0x3ffe91ab47dbac1e, 0x3ff3bf927c10bab9,
    0x40172967e3697102, 0xbfdca130ac65a972,
    0xc003d0f6b5e0a2e6, 0xc000037c339fd621,
    0xbff6ee892037eb02, 0xbff146ae9535b3e2,
    0x3ffdf1f6df06c9ad, 0x3fd2bd45f5fe1c71,
    0xc00843ded63269da, 0x400cb248cfe78f54,
    0xbffa252ec08346a5, 0xbfcfb63716cec8d0,
    0x400a7cbdb96c247a, 0xbff8cc6950ab8106,
    0x400c2abb115405e8, 0x40160cfaff8c05e1,
    0xc0048356c99334b9, 0x3ff89e776e95f2a2,
    0xbfb43fb7a2d060f4, 0x401060a732c528f1,
    0x40035d6cd41e3880, 0x3ffc0e47a2d944c8,
    0x3ff8b6d7ae57de96, 0xbfe1cc0384e04608,
    0xc0006550f714c1ef, 0xc003445f1af7f12b,
    0x3fe2c8deaa778642, 0x3fd404f46d4cf3e8,
    0x3fd334cbf2b512fe, 0xbff729d1c38d07b2,
    0xc00716e27dd31438, 0x3ff330a6a2c44182,
    0x3ff5b68e6f06e67a, 0x3fc2e401ab365018,
    0xc00c55f946320948, 0x3ff3f46f80f77bec,
    0x4003719cdd565f5c, 0xc002904c4dd2ee20,
    0xbfc8f44bc113ce84, 0xbff52c0a21c48b3c,
    0xc008388f9e90668c, 0x40063af1088b44c9,
    0x40146bcc3ac1bc12, 0x3fd4aacb696338f8,
    0xbfb4ce1b6169cfd0, 0x400b4fd44cacf7b9,
    0xbfe33fdd500dc46a, 0xbfcaf3f11be69da2,
    0x40012b190fccbf77, 0xc0103df2ca0d365e,
    0xbfbf7ad9e3fdbc70, 0x3fe5934ac29988ba,
    0x3ffba77275f00342, 0xbfe0e6d40165b972,
    0xbfbb40345cade1e0, 0x400285ae67bd001b,
    0xbfe9d46d2373e945, 0xbfa6ee04c472ce80,
    0xbff7818743d89177, 0xbfe801be4236495a,
    0x400c0b5a8636ce22, 0xbff5c11d4e1081e5,
    0x3fe773631cd60bab, 0x3fcd679afe241de0,
    0xbfc74c5f8a811727, 0xbfff61341f4bdaa9,
    0xbfeea5a1f89055c6, 0xbff53ea1f7bf9df4,
    0xbfd5e7a01a9324dc, 0xbffee57a05d96f2b,
    0x3ffae03a9c6bbbe0, 0xbff62516062bc42e,
    0x3fe3d8c69c943b28, 0x4007fa1974b1b3fe,
    0xc009ae6eb66f6736, 0x3feacd7210f618a0,
    0x3ff9041aff41e578, 0xbff5028edffcb8fe,
    0xbff4f6a6be1a5915, 0x40105b466f8932f7,
    0x4008973707590ff4, 0xbfe02ea11d6f462e,
    0x3fef07abdef22ae1, 0xbff8883c954883e6,
    0x3fea1f833ec5be94, 0xbfc217bc2da09058,
    0xc00ce314079aa5dd, 0xbfe2c2c394c75284,
    0x3ffdacc92fe6f1e1, 0x4002b9c6f42f81c6,
    0xc00bb92db9a5eca2, 0x401947296b1ff73a,
    0x3ff22e6e0965ce4e, 0x40007b242fb2ffda,
    0xbff0ba13da78bd39, 0x400e3df55c3bba30,
    0x3fd14dbed74e6794, 0x3ffa6b4d88060268,
    0x3fd234bb20c0c8f4, 0x4002b06ec1188d0c,
    0xc005a42e069a7241, 0xbfe96f14308b21dc,
    0x3feae8d525b77927, 0xc0079fb8c8ecf6f2,
    0xc00fd03ee8ab9a44, 0xbff192c976750ec7,
    0x3ffc74407bad6a0d, 0x400ad57cdff0d367,
    0x3fdcc51eb3766ddc, 0xbfe64ca8a9c94924,
    0x3fe675589db08958, 0x3ff537897c04879a,
    0x3fe72628b0d7bd2a, 0xbffe00fd964fd7dc,
    0xc0025b476ec324b3, 0x3fe6ffcf44948909,
    0xc002086e2818eb1c, 0xbfec5bf23b1f394e,
    0xbffdbc611d107c16, 0x3ff052dabfad0d0c,
    0x4004927f660b82ca, 0x400430244bddcd86,
    0xbfa44e9135dd8470, 0xbfc066c556b20c2c,
    0xbff0b9db1e13f298, 0x3fdc258a71c0d22d,
    0x3ff0a12fe8882148, 0xc002886b13ef9b54,
    0x3fee565c41581e13, 0x40008c0e7d66609a,
    0xbfea16d0e43adb3a, 0x3fd4354f3d1449fc,
    0xc0025f165b35bc7a, 0xc005eeea575d8576,
    0x3ff5779a77f5267b, 0xc0051a5c57e0d35a,
    0x401333c231460930, 0xc00875c1c6076045,
    0x3ff708b69ad3589c, 0xbfffacdfd90a053d,
    0xbfc1a84058aa4742, 0x3ff77577019fd9ae,
    0xc00874a34d184ba4, 0x3feae4e06944a787,
    0xbfc4ff8e31ccebd0, 0x40012418fd738bf8,
    0x4004c724c899fb5f, 0x4010f0537291d8af,
    0x3fb1f9a829c2a180, 0x3fffc0fb5776d904,
    0x3fe07c5851f88cf4, 0xbfc19b0fa493614e,
    0x3ffa6dd59f15d4dd, 0xc0187e76819bf17a,
    0x3ffdbeb9f7d25e3c, 0xbfd9d362a3d80dd8,
    0xbfeadad75da286bf, 0xbffcc8bee2a0f4b3,
    0x3fd70b16ec3fbf50, 0xbff824e4f8aa0d1b,
    0x400142cf34a34902, 0xbfed2d103cc25c46,
    0xc00db29ba1eb1527, 0xbfe4f3338db950ba,
    0xc0057b616ce6132f, 0xc009fdde5c1c8236,
    0xc0053303fd3f09fa, 0x3fd9b0037e655724,
    0xbfeea55f6079b426, 0xbff605b201f002bc,
    0x3fe6416ffa84ff2d, 0xc0144271e1832bab,
    0xc00786989b2e7b9a, 0x3ff515871cdbb7a7,
    0x3ff03ca89610e334, 0x3fdc0a5f6d815abc,
    0x40085bb07d074562, 0x0,
    0x3ff03ca89610e332, 0xbfdc0a5f6d815ab8,
    0xc00786989b2e7b98, 0xbff515871cdbb7b6,
    0x3fe6416ffa84ff13, 0x40144271e1832bac,
    0xbfeea55f6079b438, 0x3ff605b201f002b8,
    0xc0053303fd3f09f6, 0xbfd9b0037e65573c,
    0xc0057b616ce61331, 0x4009fdde5c1c8232,
    0xc00db29ba1eb152b, 0x3fe4f3338db950a2,
    0x400142cf34a34903, 0x3fed2d103cc25c40,
    0x3fd70b16ec3fbf40, 0x3ff824e4f8aa0d20,
    0xbfeadad75da286cf, 0x3ffcc8bee2a0f4b8,
    0x3ffdbeb9f7d25e45, 0x3fd9d362a3d80de0,
    0x3ffa6dd59f15d4d9, 0x40187e76819bf179,
    0x3fe07c5851f88ce7, 0x3fc19b0fa4936156,
    0x3fb1f9a829c2a180, 0xbfffc0fb5776d908,
    0x4004c724c899fb64, 0xc010f0537291d8b1,
    0xbfc4ff8e31ccebc8, 0xc0012418fd738bfa,
    0xc00874a34d184ba3, 0xbfeae4e06944a793,
    0xbfc1a84058aa472e, 0xbff77577019fd9ae,
    0x3ff708b69ad3589c, 0x3fffacdfd90a0538,
    0x401333c231460930, 0x400875c1c6076049,
    0x3ff5779a77f52674, 0x40051a5c57e0d35c,
    0xc0025f165b35bc7c, 0x4005eeea575d8574,
    0xbfea16d0e43adb3a, 0xbfd4354f3d1449f4,
    0x3fee565c41581e1c, 0xc0008c0e7d66609a,
    0x3ff0a12fe8882147, 0x4002886b13ef9b57,
    0xbff0b9db1e13f298, 0xbfdc258a71c0d226,
    0xbfa44e9135dd84b0, 0x3fc066c556b20c14,
    0x4004927f660b82cc, 0xc00430244bddcd85,
    0xbffdbc611d107c10, 0xbff052dabfad0d13,
    0xc002086e2818eb1c, 0x3fec5bf23b1f3938,
    0xc0025b476ec324b2, 0xbfe6ffcf44948914,
    0x3fe72628b0d7bd28, 0x3ffe00fd964fd7da,
    0x3fe675589db0895e, 0xbff537897c048798,
    0x3fdcc51eb3766dec, 0x3fe64ca8a9c94924,
    0x3ffc74407bad6a14, 0xc00ad57cdff0d364,
    0xc00fd03ee8ab9a48, 0x3ff192c976750ebc,
    0x3feae8d525b77927, 0x40079fb8c8ecf6f4,
    0xc005a42e069a7240, 0x3fe96f14308b21d6,
    0x3fd234bb20c0c904, 0xc002b06ec1188d0c,
    0x3fd14dbed74e6794, 0xbffa6b4d8806026c,
    0xbff0ba13da78bd34, 0xc00e3df55c3bba30,
    0x3ff22e6e0965ce59, 0xc0007b242fb2ffda,
    0xc00bb92db9a5ec9c, 0xc01947296b1ff73a,
    0x3ffdacc92fe6f1ea, 0xc002b9c6f42f81c2,
    0xc00ce314079aa5dd, 0x3fe2c2c394c7526b,
    0x3fea1f833ec5be94, 0x3fc217bc2da0905e,
    0x3fef07abdef22ad7, 0x3ff8883c954883ee,
    0x4008973707590ff6, 0x3fe02ea11d6f4634,
    0xbff4f6a6be1a590e, 0xc0105b466f8932f9,
    0x3ff9041aff41e57a, 0x3ff5028edffcb8fc,
    0xc009ae6eb66f6734, 0xbfeacd7210f618a8,
    0x3fe3d8c69c943b2c, 0xc007fa1974b1b400,
    0x3ffae03a9c6bbbe5, 0x3ff62516062bc42e,
    0xbfd5e7a01a9324e4, 0x3ffee57a05d96f29,
    0xbfeea5a1f89055c7, 0x3ff53ea1f7bf9df4,
    0xbfc74c5f8a811740, 0x3fff61341f4bdaa6,
    0x3fe773631cd60bac, 0xbfcd679afe241dea,
    0x400c0b5a8636ce23, 0x3ff5c11d4e1081f2,
    0xbff7818743d89170, 0x3fe801be42364953,
    0xbfe9d46d2373e942, 0x3fa6ee04c472ce40,
    0xbfbb40345cade168, 0xc00285ae67bd0019,
    0x3ffba77275f00342, 0x3fe0e6d40165b978,
    0xbfbf7ad9e3fdbc60, 0xbfe5934ac29988c3,
    0x40012b190fccbf73, 0x40103df2ca0d365e,
    0xbfe33fdd500dc475, 0x3fcaf3f11be69dc4,
    0xbfb4ce1b6169cf70, 0xc00b4fd44cacf7b8,
    0x40146bcc3ac1bc12, 0xbfd4aacb696338d4,
    0xc008388f9e906688, 0xc0063af1088b44c9,
    0xbfc8f44bc113ce94, 0x3ff52c0a21c48b3e,
    0x4003719cdd565f5a, 0x4002904c4dd2ee21,
    0xc00c55f94632094a, 0xbff3f46f80f77be6,
    0x3ff5b68e6f06e67b, 0xbfc2e401ab364fe8,
    0xc00716e27dd31437, 0xbff330a6a2c44188,
    0x3fd334cbf2b512d1, 0x3ff729d1c38d07b2,
    0x3fe2c8deaa778642, 0xbfd404f46d4cf3e8,
    0xc0006550f714c1ef, 0x4003445f1af7f128,
    0x3ff8b6d7ae57de92, 0x3fe1cc0384e0460c,
    0x40035d6cd41e3883, 0xbffc0e47a2d944c1,
    0xbfb43fb7a2d060b8, 0xc01060a732c528f2,
    0xc0048356c99334b8, 0xbff89e776e95f2aa,
    0x400c2abb115405f0, 0xc0160cfaff8c05e0,
    0x400a7cbdb96c247b, 0x3ff8cc6950ab8110,
    0xbffa252ec08346aa, 0x3fcfb63716cec898,
    0xc00843ded63269d5, 0xc00cb248cfe78f56,
    0x3ffdf1f6df06c9a8, 0xbfd2bd45f5fe1c61,
    0xbff6ee892037eb0d, 0x3ff146ae9535b3e2,
    0xc003d0f6b5e0a2e2, 0x4000037c339fd623,
    0x40172967e3697102, 0x3fdca130ac65a9a4,
    0x3ffe91ab47dbac29, 0xbff3bf927c10baad,
    0xbff22c965a3f99ff, 0x3ffb24c3fc2396a5,
    0xbfeefea7c4bc58ea, 0xc00041b37070b7c4,
    0xbfda2a6d3c5a959c, 0x3ff3772107aa3689,
    0xbfedd366657ff895, 0xbfffeb5d31fa991e,
    0x3ff9c2963bc1e249, 0xbfdc43acb03199f0,
    0x400050211200369f, 0x3fe1969ff2e67ffd,
    0x4006c8552eaaab1c, 0xbfdf889b5ce69b38,
    0x3feae9a6be6c2777, 0x40009ea392c94908,
    0xbffb60244d18e28c, 0x40098e5e81e8fac1,
    0xc0026c99aede8fa4, 0xc001783ac0c5f4b7,
    0xbfc2aa7a1f214758, 0xbff1715351f6f74d,
    0xbfeaff3fc5cf8da6, 0xc006c43bed7d4663,
    0xc0121ff3b98f190e, 0xbfc8c53a07d99a98,
    0xc00059c396389154, 0xbfeebadfe450d6c4,
    0xc0001a852f8dfe06, 0x3fe9fca33803de52,
    0xc014bdfeaf31ec5a, 0x40037eabd73aec49,
    0x3ff5641440ed704c, 0x40026c2507dcbf32,
    0xbfed63e7535b0b74, 0x3ffea5888cf8d0ad,
    0x3fd74b4e63ab769c, 0x400482bcdf828b17,
    0xbfd09c2258953900, 0xc01050dbc5fd7a15,
    0xbfd9652e99d01694, 0xbff9ec14705a287e,
    0xc0077162e3a8a08b, 0xc0127eafdfaa5639,
    0x4003c6da1e2c3cc4, 0xc00e42a242c587e2,
    0xbfd6f0bcc062f9a6, 0xc000ea59bb7e8389,
    0x40116af2458b780a, 0x3fef2b9c4141d71c,
    0xbfe424d00bcf8915, 0xc0058cc093250f13,
    0x40099e5bd4243d2b, 0x400aafe3b1187f88,
    0x400e0dd48adddafc, 0x3ffa40213df2a136,
    0x401307efd1a1fb26, 0xbffffcd5841e79ba,
    0x4000889358fe6226, 0xc008845deadfc1b0,
    0xc0031fca2c61cf84, 0xbff0e696de8e230d,
    0xc003bd582aac1689, 0x4005254e457d3550,
    0x4014f052ced95b6e, 0xc00320f12e6e624c,
    0xbfd246b887dbcc0d, 0xbfeaec18bf9d9699,
    0xc0021bfb5c15d638, 0xc000f6f7f3671c0f,
    0xbfdd7e4f1e8a6cbc, 0xbff8a08250b65c58,
    0xbffd3f13230e5f48, 0x3fe70239541fa5e1,
    0xbff7465927f5777c, 0x400f7adf88b967b6,
    0xc00e30d159a3bf65, 0x3ff3c5cb51535607,
    0x400305176a8e8a4f, 0xc00d591849c3167c,
    0xc006765f0d462fce, 0xc00c443013f32e27,
    0xc008f2e4ec8ce1c2, 0x400b40bf3f6b2b64,
    0x3ff8749a72d8bd78, 0x40145e664a173229,
    0xc0057a96a8e31ebc, 0xc01a95f3011787ea,
    0x3ff8ab0e0d91f3af, 0xc0106c32ce0c0b46,
    0x3fcf32a1a1af5950, 0xc001c27780d46104,
    0xc002da6c066e8c33, 0xbff13c36dafe3e97,
    0xbffb82b506dea39d, 0x400486fba854e981,
    0xbfe2c4bc52a79ffc, 0x3ff2297ea0979e80,
    0x3fc60b5c1a867860, 0xc00010cdf9af31e0,
    0x3fe43384d6d7042a, 0xc0112b7be63434e4,
    0xc012123ac9e46ec4, 0x3fe70bc2232643f2,
    0xbfe8a5d4717c1d2c, 0x400e18ef38f21e08,
    0x40124a0b5df3b8d6, 0x3fef52e67a7bea54,
    0x40091775926f5466, 0xbff76e9092a55b90,
    0x3ff0d794105ace7b, 0xc001a83256a238d4,
    0x4008d0cf96d7c0f3, 0x3ffd7ae45526ffe4,
    0x400c4b6668104702, 0xc00b33bb41877ed4,
    0xbfe3a356961dd8cd, 0x4000c28d0792f1b4,
    0x3feefe6a77742b28, 0x400ce2a166e27a53,
    0x3fe27f0a283831d8, 0x3fd818bfab35db08,
    0x3ff9708549126b3d, 0x3fbb39ab2f178950,
    0x3fffffe62b62c122, 0xbff395f631e588a0,
    0xbfce60534b0a4852, 0x3fe870a869b85e38,
    0x40123f695f4f30d6, 0xc00b87e8a5913980,
    0xbff29e63df104a54, 0x3fed32d70b612ab6,
    0x40014a2382ef4bfb, 0xc000374d2f48074d,
    0xc00557ef76a26de6, 0xc00e7ce78d9fe956,
    0xbff190c2be4a71c0, 0x3feea1a2a609874c,
    0x400958242d4996e4, 0x3fe3b83a809c59fd,
    0x400845f9fd556bc6, 0xbfee2e8b88cbfafc,
    0xbf84cb78d93e7600, 0x3fdc84de3b945274,
    0xbfefb90f7d624c3a, 0x3fe44425c7ea98c0,
    0x3ff57193ad2e37d2, 0x3ffd80354636e47c,
    0xc007f8ea2dbfca0c, 0xc012c4180d400f2b,
    0xbff737afe107f4da, 0x4009daf0775320ee,
    0xbffb1821ec4d047c, 0xc000749bcd3a2d80,
    0xc0021c7c1567987a, 0x3ff16d0d4bc1c6af,
    0x3ff07fe94c50e5ee, 0x3fe9175e771b99e0,
    0x400809cd4c5d7732, 0x3ff88ebf753c42e4,
    0x4012d7ea92e4b154, 0x3ffc63c8b91b7e6e,
    0x4006f2a8efced85d, 0x4004e1b32b9743d0,
    0xc00b4227b003ca22, 0x3fe3f5146e1b82d9,
    0xbfc1b962bb2a854e, 0xbfef1f8c7001efb6,
    0x400a6c81b232e68a, 0x3ff82a351c51f60e,
    0xc0032b57ef2810a6, 0x3fc5a714f2a9658a,
    0x3fe07d9020dd9094, 0x3f80ba342320ff00,
    0x3febabf3b18f012f, 0xbff7df77a3e7fd24,
    0xc002a9cc37996828, 0x3fd07c7c64c44a30,
    0x3fec3ca4fec1e5e4, 0x40115c1e5385f1ea,
    0x3fe2f6042f6eef9a, 0xbff8862182043f26,
    0xbff928415b8d406f, 0xc0023e5c501b6266,
    0xbfcc7df5493324e0, 0x3fe4da80701597bc,
    0x3fbf271b4e579870, 0xbffae0a6b0142889,
    0xbfc49fcb6c7587d0, 0xbffa84c6150e27ad,
    0x4012b024c2a270c0, 0x3ff536f031f732f8,
    0xbfee6826de7da3b7, 0x3fb025dffb3d0e60,
    0xbfe0df9ce9aeb2ef, 0x3fff0bd40cb25ad6,
    0xc001870a1e8951b8, 0xbfd25b167711d99c,
    0xc018521fd133791a, 0xc01014de2c47b198,
    0x3fef30f84da2cd63, 0x4001af6ee8a6fcbe,
    0xc001b02d5fd84c09, 0x3fde15980e684862,
    0x3fe581823978492e, 0xbfd384da675a7690,
    0x400e7829f2258b8e, 0x401028d6a1d3a986,
    0x3fa16ffed7e30270, 0x400426e5dfc6244e,
    0xc00dc42e3be4803d, 0xbfddbaddaa13ad7c,
    0xbfd00ac14465992b, 0xbfe5be7513044ee0,
    0xbfe95e8517e7eb76, 0x3fe690438fc7fa04,
    0xbff5f75c399cbcee, 0xbfc786e5a4622738,
    0xc00e3b7b8ec5e947, 0x3fde70f1407e6088,
    0x3fe778d1a2efae8c, 0x4003b567d3f2e348,
    0xbff91e4130ed4e4d, 0x40017c11a8e52c46,
    0xbfe7668c3224d562, 0xbffade23a106d114,
    0x40010842eb853aca, 0xc004d7d3ed120352,
    0x3fe409a17529a6de, 0x400234b5389828fc,
    0x3fc33d712465cd20, 0xbffe50ede2fb82f9,
    0xc00ab638541a6752, 0x3ff5309bd768a6fe,
    0x3f7b287b363ea200, 0x3ff077e8ccbfad1d,
    0x4004f74c9ba364d7, 0x3fec9595649f5f06,
    0xc00acee1557870cc, 0x3ff605e2f26b5868,
    0xbfc248d2c586c858, 0xbff3c326c2347f40,
    0x3fd443a99e61145c, 0xc012af84cd093326,
    0x400045a952c6637c, 0x400571e29ccc9974,
    0xbff7c9ce5aa47498, 0xbfef5714d4c88e4e,
    0xbffb9bcbfb56552b, 0x3ff64a4bd12bd88e,
    0xc004f3019c82da1e, 0xc01108e3667aeeb5,
    0xbfed6d2be7138262, 0x4005ae9075c48b52,
    0xbfed0bd8fdf385df, 0x3fe934aaea87ecf8,
    0xbff341efd043fb3d, 0xbfd653522e249694,
    0xc011207c539ba020, 0x3ff3cc405cde62f9,
    0x400986a2ca113ef4, 0x40033e3169bceab9,
    0x40027a7796641911, 0xc000a610d362d5ec,
    0x401384651851050c, 0xbfe50c5727af09d8,
    0xbff28da735dd637c, 0x400625091ba53d62,
    0x4005622b42e72474, 0xc0072c55df7bff7a,
    0xc00d37190c2c847a, 0xbfea04b9c6f06300,
    0xbfdeb052b4979e58, 0x40081e86069f14fb,
    0xbff7aec436b03338, 0x3ffb7a716ac6aea8,
    0x3fdaa7c5c704ce0c, 0x3ffd9dfbec7abd47,
    0xc001c78f9c646110, 0xc001231f741614fe,
    0xc0016385e92806c0, 0x4005c375026f5fba,
    0x3fb66395657388f4, 0x3fee3672a58c34a9,
    0x3fa2eaf9e4dd8640, 0x3fd34cfa5f838ade,
    0x4010cdd25cbfa64f, 0x3ff83e62b8268bd7,
    0x3feecc23b7c35580, 0xc003a639ccad5e7a,
    0xc002afb79d838ede, 0x3fe3b938ad95f077,
    0xc00b668c745b95de, 0xbff00d0383e4cf4c,
    0xbff5a29be7181591, 0xc00b294d470bde61,
    0x40160ae771c3b0c6, 0x3ff4f0b1398baaa2,
    0x400d9a640e9f4c0c, 0xbff3ea33d85f10c4,
    0x400228b61a8e97dc, 0xc0068f0e4edecba0,
    0x3fe4350d4bc50140, 0x3ff6b8c19065d0a2,
    0xc0136d64af90acec, 0x3fefeba281b46e3e,
    0xc00007551d1cedc5, 0xbfe1e4ed709db0e9,
    0x3ff01930101e54f8, 0x40034e907d2388a1,
    0xbfa438fccdd69680, 0x3ff99f1a757be5c4,
    0xc0131f1c8713a18c, 0x3fe51ba2517a6460,
    0x3ff370e35aaf2151, 0xbfe02bf5eac367ee,
    0x4007e490b1e12df0, 0x3ffd8208120ac560,
    0x3ffffd946354054b, 0x400a88f161694cfc,
    0xbff24387778bd457, 0x4005aa4053bc47bb,
    0x401166990e4be568, 0xc0065c72f397e673,
    0xc01b52934c2a2988, 0x3fe048cc172bb2a8,
    0xc0011b7d836cbd39, 0x4016bb121bff6bf8,
    0xbff99325796eed86, 0x3fd4b34f5faaa5c9,
    0x3fc193d82dfd0da8, 0x400788478e8dac6b,
    0xbfe87f55f57b2176, 0x4002db31a6f8d3e4,
    0x4000f3a16ff7d9e2, 0x3fe9ff55b754cf68,
    0x401626507030330e, 0xbfcc45ec154c1ee8,
    0xbff0f12380ae3772, 0xbff794a75b730207,
    0xbfdfc2e53e97965b, 0x3fef92a02f8ccdf2,
    0x40109ceddf5faf31, 0xbfe638c66c00e84e,
    0xbfffeb214fd71b36, 0xbfca709d46c66f50,
    0x3fff3e6d4be41627, 0xc0085b8c8af82747,
    0xc00b3cd4dbf43522, 0x400239a13a1347b2,
    0x3fd22c430b23c560, 0x3ff88f8bb3137ead,
    0xc011a330acb295be, 0x3ffc2211402e7052,
    0x3fb5c468b2031dc0, 0x4002f01954f2e250,
    0xc002f2331d601f96, 0x400074e87b11b070,
    0xbfe699ba9dc6d87e, 0x40093972cd5bce71,
    0xbfed99af6a5b50ae, 0x400b09d2f3c5a4cf,
    0xc0024992cf909186, 0xc0144dd5006c26cc,
    0xc00156adc8a30c06, 0xc00e3eb459c73ff5,
    0x4007c52257452d73, 0x400edd8f4686cf20,
    0xbff0737a00a6a78a, 0xbff2b258fe0cfe94,
    0xbff4c05590fec0f9, 0xbfd11d7e9df76620,
    0xbfe734590e568687, 0x3fa9b7f767e80e50,
    0xc0039f8336e79610, 0x3fff49ea600e46da,
    0x3ff44b7a764c3f32, 0x40128c7407bf4f2a,
    0xc0079db1fca3e094, 0x3ff5e26d9f5f9ef1,
    0x3fe1aa5e8ee490a8, 0xc00ed791f84eec94,
    0x3ff090a8b20c7eb5, 0x3fb0aab43efb6e34,
    0xc000ee17ba50e8eb, 0xbf9db3c01d52e500,
    0x4008f9bc1bcb3fe4, 0xbffb94d7c3dcbd14,
    0x40189c3a6f38d874, 0x3fe8dcef0db7b478,
    0xbfe0ddecfdf292ec, 0x4003eba5ff8537ac,
    0x3fe721c516074114, 0x400442db2330ce85,
    0x3fe5ca6c4852de17, 0xbfe4ef664d5d06e7,
    0x40065e750bba813e, 0x3fdcd55c74a2e7df,
    0x4000dbb9b6979188, 0xbffd6e40244957cc,
    0x400233812847934a, 0x3ff57f839b84bba0,
    0xbfb28c24c6aa7d90, 0xbfedac5022e75aca,
    0xc0039b47c41b4262, 0x3fed8282cc9695c8,
    0x401369e132b311e7, 0xbfc999a5f2b64cce,
    0xbfe0392c1cdfb21d, 0x401562915231c795,
    0xbff57293fd9fe992, 0xbff82a1ca3551739,
    0xbff9e1a8c259566b, 0xbfff98c86a9bba2e,
    0xc000262f5ea147d4, 0x400f13e97ec767ea,
    0x4011366a03400773, 0xc008aa09979a35e0,
    0xbffa67b8df715696, 0x3fa72ca34ee1a404,
    0xc00228b9c9e19b15, 0x3fdfefff05fb0e9c,
    0xbfedacbf4a1fa7b2, 0xc015398b7d45396c,
    0x400279bf1313b866, 0xbff14b454b7c2bfb,
    0x3ff1fb48ffaee7c2, 0x3fc90f0db4ea5798,
    0x40068b32b4b7ebca, 0xbfe98ab6e964940a,
    0x3fd3833f929a6874, 0xbfecdf4b501516e5,
    0xbfed54c6fd82978a, 0xc003ac35eb970725,
    0xbfe7040b04710a83, 0xc015ecd0082189e6,
    0xc00f7c69f700a158, 0xc00c60845cc01568,
    0x3fea225d27dbe98c, 0x400df763a6a90d98,
    0xbffe4f50faa31f86, 0xbfd0b163499cd974,
    0xc00835fd879fa8ba, 0xc0032fc180f4f786,
    0xbfed99d8063c9bce, 0xc003bda9b5031acd,
    0x3ffdb62c951a4ab8, 0xc00e0302e367ec62,
    0x3ff900f913ffe67b, 0xbfe143a9f806eb44,
    0xbfd3c98a3d896df6, 0xbfeda7434bec4d32,
    0x3ff0a696527d0191, 0xc00f9020244e4291,
    0xc00a5810d43fc06a, 0x3feabb403744d928,
    0xbfe0593db251fc54, 0xc00adbd8973ae520,
    0xc002fc9402d47b02, 0xbfee6408f7318e5b,
    0xbff0611d3fce968c, 0x3ff7a383139ed7a7,
    0xc0115df863daceae, 0xbfe6112735d53bc8,
    0x4004a4aed094606c, 0x3fe5c75e332c7d64,
    0xc0154e70bb9ec916, 0x4004249941ba4097,
    0xbff34b76e61f1b90, 0x3ff5525093f62c38,
    0x3fec3bd75946c8c0, 0xbfed339bfc383b58,
    0xbfc4f3a08d6a42a0, 0xbffbf5b53787bfcc,
    0xbfe1dd79a5a45696, 0x3fbc1da528a8404c,
    0x4004b845ae564fb4, 0xc00c92c2b5a21b70,
    0xbfe1941aaf785c75, 0x3febc01597941714,
    0xbfda8ed457dad1fa, 0xbff6db91f501ad3d,
    0x40016dad81f71195, 0xc003cb97f7c1e91e,
    0xbfea5a8876314a93, 0x3fe8d9226d59060c,
    0xc00e8fcdd72e3fcb, 0xc008063a70be00ee,
    0x3ff01306ac028927, 0xc004b1c0c0c360fc,
    0x4008f9a1e3435708, 0xc004bfd001fd822a,
    0x3ff760997c62de56, 0xbffbf85450aa0226,
    0x3ffec030e9bf8ff4, 0xbfd0d9b7384cd44c,
    0xbfef79b393d03361, 0xbffabf91e4f6becc,
    0xbff44cbf7e327924, 0x3fee0d8db5a2ba1e,
    0xbffb110f33f77598, 0x400055977cd98d5d,
    0x4005ad713fadda04, 0x3fefd096fd21741a,
    0x400088928017d533, 0x3ff884c966c7b434,
    0xbfebdbca4e587966, 0x3ff18729b9f8e937,
    0x3fe2cda845cbbff4, 0x40033282c7b229e3,
    0x3fdf89930ee56f08, 0x4003dabe85a5733d,
    0x40052d33e4c78d29, 0x3fe2626c97113a31,
    0x3fe1075b45a83edc, 0xbff48ee9bdf4db88,
    0xbffb252b028fe59f, 0x3fee88b92323ffae,
    0xbfacbfc1818b84e0, 0xbfde0fe045ae9816,
    0xc003b5e3c7c0e57d, 0xbff0accaba8fcdb5,
    0xbfda757adffe6bb8, 0x4012940b9b1ad366,
    0xbfe9b2f7366feb84, 0xc00976f96f8881f4,
    0x3fe00e7760e3c808, 0x3f987829f10dd280,
    0xc00669a76e767794, 0xc010bf16ab24bee9,
    0x400682e2bd76c47e, 0xc003686ed5f9cba4,
    0x3fef9afdbf741dbc, 0x3ffe3534f6a3bf93,
    0xbff99cc3a5b44190, 0xbff86326d01194ed,
    0xc00692730ffcecac, 0x3ffd91a738022f30,
    0xc00183a045b087d2, 0xbffdeac3e22299dc,
    0x3ff8fea2164b84ba, 0xc00a84b5c635d019,
    0xbff665c640da237c, 0xbff4c757ee49a529,
    0xbffa1bd083056938, 0xc00e263f7906ffc5,
    0x4005ee2488eb1c85, 0xc0050e1a5a8ba010,
    0xbff1b244646cd1bf, 0xbfd605623ef7b8d5,
    0x3ff56662fe805cf2, 0x3ffd58f471c68a73,
    0xbfe1abbfd1574dae, 0x3ff3e89706076fc2,
    0x3fbece5b4853ef60, 0xbff3641d37ba565a,
    0xc007a40cd69d4d62, 0x3ffe08e1f8ca1d4a,
    0x4001a323e2ed38ef, 0xbfd680670b1daab0,
    0xbfef57df9e5dc4ef, 0xbfe5b22cb88318f8,
    0x3fd998c872137b24, 0x3fecbf6b2876bf60,
    0xc002314f53d26aad, 0xbfbf9076f2910050,
    0x3fd3d43031513e14, 0x3fe59cc945dabf17,
    0x400b582fced506f3, 0x3ff4b81b3eb465ae,
    0xbff25edc931af12c, 0xbfcb1d3d6c46f858,
    0x3ff66c65aaceb6e8, 0xbff57860aa175c18,
    0x3ff6c18b3f567aac, 0xbfe8a0e216346c9c,
    0xbfb0d97196343480, 0xbff0e92fcc59a858,
    0xc0036179200b02c6, 0xc0076f500e85cf70,
    0xc002f03291fc783e, 0x3fec6033971fa294,
    0xbfebc9891b0a8f5c, 0x3ff93bbf638f4c09,
    0x40106384bce3cfdf, 0xbff1c931f3dd314d,
    0xbfff4821ef837634, 0xbff45f428bb8b602,
    0xbff21e7722499bbe, 0x3fda57395b8ffd26,
    0xbfebd0cb888ad62e, 0xbff1a770f08a09ba,
    0x400fbeceef5cba51, 0x3fd5aa291de703d0,
    0x3ffdd1de4f387ad2, 0x3ffe6d8294dacf74,
    0x3feb29fa3db71862, 0x3fff146c1b03e5fa,
    0xbfe050541564a34a, 0xbff2c87c83bb5bb6,
    0x4012538e7282abf8, 0x3f76e570437e5e00,
    0xbfc84e8393021138, 0xc009256706da46e5,
    0xbff3a9399bc7b1b0, 0x3fb1c1ddf974e990,
    0x3ff491565515be5a, 0x3fe1f151cccfbfe0,
    0xc00bd5bd64e016aa, 0xbfe65d9fc475848a,
    0xc0067f950e6c27e2, 0xc00b668d290501c8,
    0xc008f7476e5cedf6, 0xbff959f122a4ba8c,
    0x3fd2ab0ad2b01dac, 0x3fe47e015940037a,
    0x3ffb36309d5b1040, 0xbfd5f083177d9956,
    0xbff35e0397456800, 0xc0118f831e46302d,
    0xbfc41077dc518078, 0x3fe8906ce6d2ecb4,
    0x3feaa064afd59e27, 0xbffb1fbbc5929818,
    0x3ff02870cfefd876, 0xbfc42798a96800a0,
    0xc0119ac3220c869b, 0xc007903163130788,
    0x3fd6564a7f0b6ca8, 0xc004728a3df749e7,
    0x40020a69cc204e23, 0xc005ada939cdd08c,
    0xc006be87b07a5a01, 0x3ff94b0d7f877517,
    0x3fe3c86ed2d125f9, 0xbfc94a64dda20504,
    0xbfa4d62d37e62b00, 0x400350d8b4cc9002,
    0x3ff62c406670d564, 0xbfe7449f8e1f48dc,
    0x3fcd9708be56ec44, 0xc001c2ae1c2dde5a,
    0xbffe699c88f687b8, 0x3fd029fb541c36c6,
    0xbfc4096ebf9346b0, 0xbff539e9313a1d36,
    0x3fdc291d7b5210c0, 0x4011423b29306886,
    0xbff8cc996260aeeb, 0x4013321718b33e01,
    0xbfe2e079605a532c, 0xbff25d3875779937,
    0xc01663ac7671c48e, 0x400ab96a4437f4b4,
    0x3fef61f37ba9cc92, 0xc01308eb3886395d,
    0x400b76e812e1bd6b, 0x4005491131477cea,
    0xc0091ce7db160148, 0xbffa2ed7466ac4d8,
    0xbfef7e5b5057787f, 0x3fff7a018f42f31a,
    0xbfecd1eca8ec1b38, 0xc008b088050c3a5f,
    0xbfccc54732dd90c2, 0xbfc49bc5ca8213c0,
    0xc0080f73c4403aaf, 0xc00249cabdc1122b,
    0x3ffb6ad2ac82df1e, 0x4001195bf0523285,
    0xbfe23736292d9efe, 0xc0118df716bed3ac,
    0xbfe148be195b4804, 0x400dd16939f0be8e,
    0xc00364f178e3f0c8, 0x3fba110ac40664f0,
    0xbffa1c0a6170431d, 0xbff13eef433a3e8e,
    0x3fe36e2c8c88de1d, 0xbfde1ff632d8a952,
    0xbffb6a5eca1d28b7, 0xc00cba4b219be8ac,
    0xbff9ccb747e0ed93, 0x400e4ef6801f29c2,
    0xbfd83f036dcb71f0, 0xbfcae8a8973cb2f0,
    0xc0028d8f1dfae508, 0xbfe5ac44dcb5b001,
    0x3feaa7d7a532e4e1, 0xc0076b881e6ce594,
    0xbff274c37327d46c, 0xbff9e729efd0e1e9,
    0x3ff8eafcfdc96110, 0x40128e6421306a8a,
    0xc00302e96fa1f92d, 0x40057c1d2f7c6a56,
    0x3febaa40044d3103, 0xbfc5bf1178ca8942,
    0xbff03b512fc20e00, 0x40032499c88fe684,
    0xbfe9fb5bed9a8e0e, 0xbfb1e0c473a14624,
    0xc004c710138f91ce, 0x3fd98f13c5a962cc,
    0xbfb947ddaad03de0, 0xbfeab442a90090c7,
    0xc007f0c1ed5da1da, 0xbfbb0392e4dd8c1e,
    0x4008540a1e4825b6, 0x3fcaa0dfe984374c,
    0x400583f7155db6c1, 0x4014865c4a7437de,
    0x3fafd55fafe11c00, 0x3ffe6b3064abee82,
    0x400a554416c6d928, 0x3fe76195942fff34,
    0x3fc0fe9df36b6ab8, 0xbfd43967c6f2a78a,
    0x3fe5efbfc02e2e4a, 0x40097c8c7660cda4,
    0xbfff76f3537366ea, 0xc01302c853288747,
    0xc000f1e32db8ee08, 0x3ff14eeaa9f8b021,
    0xbff365dacd4dbb08, 0xc0114cd3fe6454e4,
    0xbff3bd79783fcaea, 0xc0194828cd241b5e,
    0xbfe0cebaa5ad315e, 0x3fdb4b383d259915,
    0xc00199b577de8c24, 0x3ff3b2b523817e30,
    0xc0039b670d8fb3ec, 0x3fdcedbfae01e6fc,
    0xbfc6b977b05399e0, 0xc00120d4cfc9b91e,
    0x3fe59251bc58a16e, 0x40111cefe1f4250e,
    0xbff17cef14a9f0a7, 0xc002f9508b20975a,
    0xc00b38061040a300, 0xbfbc3504e73a92d8,
    0xbffa2ea7ec6938e7, 0xc001dbcda70118b6,
    0xbfeab7a1d49df78c, 0x4000ed4765a110a6,
    0xbfdf89d58934001e, 0x4019b8ed558181fa,
    0xbffb338dc6813640, 0xc003256e35224c79,
    0xbff3fcdf7ffa98ea, 0x3f65b37fcb19e500,
    0xbff6b8216a2477c7, 0xbff8b8e3dd2702c4,
    0x40041284ab1cbacc, 0xc0001767998c98a7,
    0x400ec9cc543cfba2, 0x3ff85970bbe9a0ab,
    0xbff42db362c2c84b, 0xbfee61a90d14feb2,
    0x3ffcf4d5e43fa602, 0xc0046d3cf9dbaa84,
    0x4004d629daf82494, 0x3fb410e9f697fbd8,
    0x3ff3a7188f9664c4, 0x3fd86af1b42735f4,
    0xc0072ec6b70b47fd, 0xbfde5c22d70148b7,
    0x3ff50be95968a9c5, 0xbfe22a8ab7f38ba8,
    0x4007c392dceb99f7, 0x40082c3df5f03e9b,
    0x3fe0cd072973b220, 0x400860ef93947be9,
    0xc013fec12ebe8ae4, 0xbf9a341100e54fa0,
    0x3fde89fe46c05506, 0xbff389b08d8b446b,
    0x3fc5106ae4f7c372, 0x3fd67aac69f2d74d,
    0xc0037dd8a8c07250, 0xc000b46e64c391d4,
    0xbfc09795726fbb98, 0xc008992f5dc3708a,
    0xc0012829cddba3b7, 0xc004ddab03455e9b,
    0x400962a31d8e060a, 0x4010ec8f4496b538,
    0xbff8f8daaa597e69, 0x400301442950b86e,
    0xc016923930b2f252, 0x400208900835781e,
    0x400d20b5b52005c0, 0x4002b3932ddfb660,
    0x3ff59b67060d68e4, 0xbfec4bcd106b474e,
    0xbfd5b0ec83e734c2, 0xbfd099bdfaee80ac,
    0x3fec4535aed08d7c, 0xbfc5fe5e6b4ce74b,
    0xc016a872d0000c87, 0xc00130d178f48476,
    0xc0154479f4f9dc10, 0x400da4d749cd5fa6,
    0xbfee311faf1c640e, 0xbff42c25d41a3118,
    0x3ff46701859a805a, 0xbfb9983f85235440,
    0xc0017b5ae20b238c, 0xbfcf856c3a77c0b8,
    0x4000525f1bb5c53a, 0x4013bcd16604b3e4,
    0x3ffcb602e30bdaf0, 0xbffdb2d8d22eacfe,
    0xc004a396b4dd31a2, 0xbfefb6d402994ff5,
    0x3ff92cc5072fbe3b, 0x40072b03fe3870cc,
    0xc0015bb7feec092a, 0xbfd48e1095c32921,
    0x400cf375883db8c0, 0xbfde6eb4ec61e050,
    0x3fee08595bc7f409, 0xc00b6cfbb2640c38,
    0x3fec3bac548bf532, 0x401d34f4167fe8a8,
    0xc00e793a396a228a, 0x40061e9f049320ec,
    0xbfb33b3756153f10, 0x3ffc34be0d21b684,
    0xbff4c501d99fceca, 0x40125ea28f2d790e,
    0x3ffad18d3691adb4, 0xbff40aaacefce8b4,
    0x3fff512b3db492ec, 0x40128ad8b1399a8f,
    0xc00409f1a5a6957c, 0x3fee85d67c14109f,
    0x400239c76513ee05, 0x4008f65634cbdb11,
    0x3ffd4f5e436ee151, 0xbfe1754c995cc692,
    0x3fe15c4abe80e4bf, 0xbfe1d51954bc0090,
    0xc009ae03265a0828, 0xbfcf75ebb569b000,
    0xc0026b3d768f855c, 0xbfd0cffa30c6bdb0,
    0x3ff0edaab5685891, 0xc0041943faf05053,
    0xbfd26be1ee94fb50, 0xbfce5dbb5e22c650,
    0xbfd5ac3b02d129c0, 0xbff8666f83395b02,
    0x3fe00c854b33cef5, 0x3fdcbdb468ec8658,
    0xbfe423b50e3c2b5b, 0xbff4768306c7a9d4,
    0x4003fd4bb9b86ae0, 0x3fc84d74fc8b0d38,
    0xbffad274d98d7caf, 0x400c415906c178d2,
    0xc005e1291117affc, 0xbfce8142364b1af0,
    0x3fe94158f26a411c, 0xbff949f8fb4cf3e6,
    0xbff04a06ab33ae5e, 0x3ffe8801cde850ee,
    0xbff4e80277a04e1c, 0x3ff1cec799999691,
    0xbfe3e88b122e8286, 0x3ff81f8a5ee78f52,
    0xc00072a1dc681783, 0xbfec5b0087481ec0,
    0x3ff1fe13a3566c7c, 0x3ffa451d72e90b1b,
    0x4016edd3c582a0db, 0xbfe012e4ddc3df0d,
    0xbfe24abe0d1a7d17, 0x40062fe6a2dc7788,
    0x3fe780e487567f22, 0xc002cf9883494676,
    0xbfa52fbf33fcc750, 0xc0079ce4d1c3f093,
    0xbfe4680ae09c987a, 0x400907f935b020c6,
    0x3fd0aa5f1f5a4644, 0xc00b1ea04e964548,
    0x3fe1c848f0a6be70, 0x3ff249faf556ea46,
    0xbfe7707706a2ff8c, 0xbfa00c23628061e8,
    0xbfc7989b67b392dc, 0x3fc38294fa56a358,
    0xbff35fff8fe66941, 0x3ff0d2b6073f0906,
    0xbffdd95b8c03eb82, 0x3ff0bf866422ded8,
    0x3ff55f74083c2cb1, 0xbff706313e29113e,
    0x3ffb23cc4db70be4, 0x3fd2edc10d20e823,
    0x3fb40fcc53491580, 0x3feef2299a467df2,
    0x4011cf8bc01cb292, 0x40040a628a369d4a,
    0xbfee047c714f5e02, 0x400028898cea4806,
    0x3faafc20482933c0, 0x3fa00807e5548540,
    0x3ff7278a6769d6d4, 0xbfe0067411b62c50,
    0xc013afc050d7c082, 0x3ff133e3679775c3,
    0xbffcace9db853220, 0x3fee1c05dd5bba1c,
    0x3fdae80531eb7110, 0xbffd5c1dfaf3a958,
    0x3fe49c97a2e6b948, 0xc003041501a6038d,
    0xbfb5fffbb9f04610, 0x3fe46b3c871e93ca,
    0xc012a72d33b5a0e1, 0xbffda9eddd8ff53e,
    0x400b98da7eb5d549, 0x40089ba06b296225,
    0xc009be7aaa2c45a4, 0xc001dd90e0f3ebc8,
    0x3ffddeb93806ed99, 0x4001f18c66aefd30,
    0x40067932de90b8f2, 0xc00c78115499827c,
    0x3fd9ec97cc10a232, 0xc011b20d464ad093,
    0x400182f59a6546d5, 0xbfffe7ba9b01be2d,
    0x3ff9003af5a456c2, 0xbfe621fdde73824e,
    0xc012610077e41eac, 0x40033b4b5ba20785,
    0x40086f6ad65bd1bc, 0x3ff830c7fcc08ac0,
    0x40147c7fadcf00df, 0xc00f5b4ec03686b5,
    0xbfd834b85a9afb24, 0xbfe253be4a03aab9,
    0xc000e607ae23dcd6, 0x4011a5f545865852,
    0xbfd2446e61defd90, 0xc004f0f029589c1a,
    0x3ff345f06609466e, 0xbffe3bbc53993f35,
    0x40034760e918286c, 0x4004e8b6b824bcb2,
    0xc014f19d93ef83ca, 0x3ff94e4a575648f8,
    0xbfd291eeafe7b72c, 0xbfef9b391cbb202c,
    0x40118eeab284a0f1, 0x3fe982e510388b42,
    0x3ffe2b2952e85fc1, 0xbfe84da28f77ff70,
    0x3fd2bf53c48b48ee, 0x4007cf172cb6870c,
    0x400556bc67bf6fc0, 0x3fe60b061b9f3e04,
    0xc005c4f02cef4cfe, 0xbffdd50d4b336252,
    0xc00645430162e7cf, 0x4001f0a608a7a884,
    0xbff346d970bd875d, 0x3fed660d6633565c,
    0x3fe4c1855eddd5ae, 0x400b5323c8a1054a,
    0x3fe9fec01b017eb0, 0xbfcf68fbdb90d020,
    0xc00e235c8d9d0fca, 0x400383e2d6a2eeac,
    0xbff397b95cc520fa, 0xc00d0a22c3259e3b,
    0x3fe2d7ad6d7847ab, 0x3ff5042986354fef,
    0xbffd1a03bd26e309, 0xbfd426d177417868,
    0x3fde9378431e51cc, 0xbfedf5be3104d4b0,
    0x3fe67e29c48d577c, 0xc00f61e0e055f00c,
    0x4000116a1364f987, 0x400436948b9c521f,
    0xc0096c63a3ec35e4, 0xc0034fb36aebffd4,
    0x400b05314332b5b4, 0xbfce09e86efc5cb0,
    0x3fec6432c090cb56, 0xbfe50475fa1d7dba,
    0xbfd868bc907c8d60, 0xc002cb4b04452bd2,
    0x3fee3817ad3a6bf3, 0xbfb9b126c86b76c0,
    0xc0021a54d94c8eaf, 0x3fb653ac6b3bbfa0,
    0xc0099fc8538b65bb, 0xc00b7ab1060757b2,
    0x3febf0eec91f32f1, 0xc003730ba21406b4,
    0xc00ae90b7d2cb13f, 0x3ff4424f33662360,
    0x3fec21e77f0601d7, 0xc008fb30aae622a9,
    0xbfe9d87d565432c8, 0xc004e761ecaeb9b8,
    0x4002aee5a936f123, 0x400671114acd58ff,
    0xbff9aa55af1671f7, 0xc0044b8d35db3948,
    0xc002bf8a4f996f6d, 0xbff35ce3f95643c0,
    0xbff4ec15feb6d4db, 0xc00a9f44f548e036,
    0xc0026f48b434becc, 0x3ffca86772c17a6b,
    0xc01096feb060054f, 0x3ffaa67d040a9c15,
    0xbfbe605f4e37522b, 0x3ff508ad23e1e555,
    0xbfbb59fb50c9fd80, 0x401159fcb37b72b0,
    0x4003516d1a78f62a, 0xbfed79d3a829df73,
    0xbfd6cabe7d7bf160, 0x400555719614eef8,
    0x3ff354f0b3020d48, 0x4000913b05ca0c19,
    0xc0024a347e86aad0, 0xc0065d28ed2ae244,
    0x3ffce8624b7af6f2, 0x40008b02f444466c,
    0xbfffa6b76347fa3e, 0x3ffa0af2d51ad33e,
    0xbfee56dfc7283d62, 0xbfff43d8fd7dd1fc,
    0xbfe2c72c0f4fdd8d, 0x3fb731816ff1c860,
    0x3ff2d036d31e15eb, 0x3fe8dd14c7819134,
    0xc00649129688e97d, 0xbfde445f2569ee58,
    0x3fff53136c33dc45, 0xc011c3132d2095ac,
    0x400189be7a3d2e17, 0x3fcaf04c59f2b7b8,
    0xc0006dd46b13d057, 0x3fe6b846ed3583da,
    0x3ff09f442f96d0fd, 0x3fe6da989b22fc05,
    0x3ffe2a5e8306315d, 0x400adeef63f2b01f,
    0x3ff40981b9895eea, 0xc003148b63f6bafb,
    0x40104bd88c2c9303, 0x3ffe43daac6ac4e4,
    0xbffc2110abd93340, 0x400174a5792a89e7,
    0xbff96ba1de1eefd0, 0x400a9936062d130d,
    0x3fe4903ae918a65b, 0x3ffcc6240e5f4014,
    0xc00b4aa24aed85b7, 0x40065518e1573fee,
    0x4006328090b9d468, 0xc002333fa5a5aa77,
    0x3fe81378f684c1c8, 0xbfe23f9ed24aa37e,
    0x400c85edfd3869e8, 0x3fdae110248e31c2,
    0x3fe11856aa651abf, 0xbff33540c8ae46df,
    0x4016416e9f08eda6, 0x3ff36990ad6ebc96,
    0x3feca54bc81c8924, 0xc0019ca8229c0a78,
    0x40057ad38f84c8be, 0xc0062649b9de54cc,
    0x3fd966583382452c, 0xbff323ab5187701f,
    0xc009dd04526115fa, 0xbfe3f7e07b3b30ce,
    0x3ff1620f9cc0b310, 0x3ffda7d747a328a9,
    0xc007208eddd4a8c7, 0x3fe594c4761aef6e,
    0xc01385af8eeaa2b4, 0xbff297e0beef6064,
    0xbf86350394ed4780, 0x4001bda467922fd2,
    0xbfec1673be869299, 0x3fe77977d2a66138,
    0x3ffda4df9dcab50e, 0x40069eddc0a4c518,
    0x3fa9e34b55579f80, 0x40067b7b4f5b1963,
    0x3fd19b168a569dc1, 0xc011b49c4391168c,
    0xc003e93af0d044ba, 0xbff23942f5e538e8,
    0x3fce3252ab4fd8fe, 0xc000a60d3476a933,
    0x3ff5915414f73f79, 0x3ffcf8c5d97478fc,
    0x40004ffc57da198a, 0x4010a7349a79240a,
    0x3fec67a64e50ddb8, 0xbfe570bf89a3220d,
    0xbfe825f90e3ce044, 0x3ff1af8dcb2ba468,
    0xc0071f4f877724f4, 0xbfddd4d1e011f64e,
    0x4003c8b2d43aeb6f, 0xc006ab18c55ce4a6,
    0xc0034e9cf16c8a24, 0x3fe9a01445051828,
    0x3ffd3af208da0326, 0x400315bbc933ad32,
    0x400be3c3943853c2, 0xbffb03f6ec0e8464,
    0x3ffa98798dde57bc, 0xc0169fcec0f3298c,
    0xbfe1c3ccbfe74290, 0xc0016a9b4c1997e3,
    0x4010b32fcc60f532, 0xc011e6c605336afc,
    0x3ff6095ee03e8607, 0xc000016bbd8334b2,
    0x400f233aaecbd847, 0x40080e10999fc7da,
    0x3fea477502a2299a, 0xc008f382be4244d4,
    0xc005440726bbddda, 0xbff20392587711c0,
    0xbfd80c1da3036693, 0x400187ff2fe6761a,
    0xbfc379bc49e63a00, 0xc000653291346458,
    0xc012a90ed8f70bed, 0x3ffc6f1a69074262,
    0xbfff487940d555aa, 0xbff47a1e0d133719,
    0xbff06850788444be, 0x3ff197f9984acb99,
    0x3ff9653e3907558f, 0xbfed50cd3685dcb0,
    0xc0050b9cc16acbc6, 0x3fb6e56e88e75cc8,
    0x3fe2fd48bab5138c, 0xc00028ee50b5a796,
    0xbfb689dee3c83608, 0xc001c1857ac542aa,
    0x3fee9438b8f59d10, 0x4004c8cc8b30551a,
    0xbff8734b072d7d44, 0xbfe080e9f4b63633,
    0xc00dd0df9d20459a, 0x3fd796ed7fa84a18,
    0xc0068026798a071a, 0xbfa611392c7f3740,
    0xbff5b5157954c064, 0xc001dd1f45321723,
    0x3ff2b85922866554, 0x3fef51fe72a2d7a0,
    0x3ff2f1c97e055e9e, 0xbffa4c5bc4992816,
    0xbff7fb12839e33a6, 0x4014ef6e70923d48,
    0xbff20eea9e8ec7b2, 0xbff479d855b26368,
    0xc0098c04d35743db, 0xbff795608bd2bea3,
    0x3fda96dd1ff2f0ac, 0x400e559cd66eb355,
    0xbfe8b1bac6140d92, 0x3fc47037bce94718,
    0x3fd6ac4b47818ce2, 0x3ff97382cfebeb65,
    0x400787a2405660c4, 0x3ff0d862abf7293a,
    0x3f7fca3df0ae2500, 0xc007682732f2d111,
    0x3fdd1b34a0222742, 0x3ffb1d24b594839a,
    0xbffce2fafa1b236d, 0x4011cffcaa93364e,
    0xc00f313d7fbcc74c, 0xc00df779f8f9ea6c,
    0xbffa86a56795e28a, 0x3fe6c480bacb3963,
    0xbfd382fc8dac4e8f, 0xbfb1397854d66660,
    0xbfd4c327fcc93df0, 0xc009246480cdaff4,
    0xbfe7d0e9a30ed817, 0xbfd51ceb87f8ab78,
    0xbfe35e3c939ee459, 0x3ff7bd4dc5930c0b,
    0xbff40e75386dda6b, 0x3fe8e7aff416f55b,
    0xc004fe6cc6034817, 0xbfe30f5270a9c254,
    0xbfeda4787ca86b7e, 0xc0012fedfe5a2e92,
    0xc0029485307d3079, 0x3ff516bf4a41f130,
    0x3f81da0b3ff4b780, 0x3fd4db8ce60a7868,
    0x3fc5ed72aa0bf294, 0x4002c1e5d8150d6d,
    0xbff236c75388ffb4, 0xbff962c41fee574c,
    0xbfe4ac6a1e7d05ea, 0xbff6ea12832ba974,
    0x3fd58e2c33f1b9d8, 0xc0117183f84f1403,
    0xc001d8f168f38c19, 0xbfca1faeee0b42fc,
    0xc0056eb6bdcdeadd, 0x400cf7db999bde36,
    0x3fb3135c26b32120, 0x3fe8810006414eee,
    0xbfaa9225b52f2300, 0x3ff0da5fcc51edd2,
    0xc00640879a49eae2, 0xc00f4a7a7f68f1ac,
    0xbfe37399bb71835a, 0x3ffba493ff981d68,
    0x40153d9416e1addf, 0xbfe32f70104405b6,
    0xbff057b1d4448c50, 0xbfd78087768c83f8,
    0xc011a73b4e9dd636, 0xbff796e7f5cdcfe3,
    0xbfeafa7c96bc4103, 0xc0094a28f77ee668,
    0xc0048045a7a0a387, 0x3fe826bcbc5fb98a,
    0xbfe9b9ca8dbe9e1e, 0x4008f7ab0df21f81,
    0x3ff052761367abe6, 0x3fdecc1f7b545124,
    0x4000f0fa0f578b4a, 0x3ff0e70e23105225,
    0xc0099c6e775b38d9, 0x4003f260d0c306ca,
    0xbff57ca7a556ae1e, 0xc00dbfd63f369762,
    0xbff087be716081e1, 0x400632d85318f5ef,
    0xc0092b1ad03a07e8, 0x3fffb892f7805146,
    0xbff1fba016d64294, 0xbff7f84fb5c70342,
    0xc0041134bcc904b8, 0xc004396f90603e46,
    0x3fbd570884c4bda0, 0x3fe2a3c6228cf974,
    0xbfd08608eb7ec760, 0x3ff27685eb92227d,
    0x400350f7ecd171ee, 0x3fd8a0a6e6e13810,
    0x3fe56c21398870a2, 0xc005e92be9e56a10,
    0x3ffb3058e9353e5a, 0xbfefda361c4bee3a,
    0x3ff758e775370cc2, 0xc0044d1825620e92,
    0xc009e6392954aba2, 0xbfe8125a57d636be,
    0x3fd50a72b9e724cb, 0xc0129124e7a024a5,
    0x3ff9710f3ab9db6c, 0x3fff57e32353d6f6,
    0x4004423311e2265e, 0xbffcf1cfe82e95e6,
    0x4005eaa97c4830cd, 0x3fd557f4a95748f4,
    0x3fe821185dd53d78, 0xbff34a793d20c3e1,
    0x400e5c31795557d2, 0x3fe73f98236ac09e,
    0xbfc16a8eec92a3f8, 0xc011afdde79ae650,
    0x3fe6aade5f06c39e, 0xbff890797795db7a,
    0x3fef428dc33a5dfc, 0xc00fdb4eb768ae5e,
    0x3ff88acd99961fd8, 0xc00a5e1ea1be1c96,
    0x3fc21ddaf4786568, 0x3fedae7fa37c6720,
    0xbfde7bf394d503f2, 0x400d0510ae87e1b5,
    0x3fed757b0d2e68e0, 0x3ffe3b0bfc2865c6,
    0xbffc6c1d682571cb, 0x3fe338565583e566,
    0xbfe5703d91865f2a, 0xc01054a3a4117ddc,
    0x4001f57922f19cfb, 0x3ffa382e81a9e75c,
    0xbff7e616bc22eb44, 0x3ff51ea2723f8aa8,
    0x4010dd3f346bd9ce, 0x3fe45436ea24b762,
    0xbfeee225060720c6, 0x3ff868c3905eac9e,
    0x3fe2553c68be845c, 0x400819dd0f4351d6,
    0x3ffeaa86770479f4, 0x4000342834868adf,
    0xc0065c3cb6bdab15, 0xbfca8b23a049eaa4,
    0xbfbae89bf807776e, 0x3ff134e099aebe76,
    0xbff567367a659284, 0x3ff9edf9dc3bb1ca,
    0xc000db153165b15c, 0x3fe40abc0ce396c7,
    0x4015f23f4687dbd6, 0xbff80b165a618598,
    0xbfd6afb92514df80, 0xbff85f3320cf47e1,
    0x40051465b338a38c, 0xbfefc08da6a25b23,
    0x3fe3e7c0ccfb5d86, 0x3fea2de3e80b9bc6,
    0xc007a4b0aa23202e, 0xbfd7d46d7dc8a4e8,
    0xbff98cc71d8252a9, 0xbf3984bccb7fa000,
    0x3fd1bd1d8494ad2e, 0x3fd287594aadf956,
    0x3fce352ba58f0ff0, 0x40009241d45fe3d7,
    0x3ffd570da311030e, 0xbf7a0d2950357300,
    0x400f798149641af5, 0x3fa04c841d6b7c80,
    0xc0077bf3a12362fc, 0xbffe7d2e9f5c5aaa,
    0xbfeb204f009f44f2, 0x4010a30c925d27a6,
    0x3fe71dcddd901dd2, 0x400c74164bf07102,
    0xc00bc60837985e88, 0xbfbfd45139f85680,
    0xc0010b8c5a1cd718, 0x4015d5d83629f498,
    0x3f43a951f44ec000, 0xbfe42d611bdc90c4,
    0xc000561882b4f706, 0xbff3d5b1bbbd820a,
    0x40055026e7ca1bda, 0x3ffaa1d6116a0e16,
    0xbfda8b520bf7f410, 0x3feb4d38db8d3402,
    0x3fc3d169ab12bb4c, 0x3ffc90ecb1147bfb,
    0x3ff4c7d058fd67f9, 0xbfb23ecf6baa1944,
    0xbfd12c584f221e2c, 0xbfed6bd5c1831df8,
    0x3fd188c7ca16578e, 0xc00e62f96795035a,
    0x4001600bdc70c825, 0xc0085350a730ab50,
    0x3ff7340fa2fb4d15, 0xbff38b899fa74b17,
    0xbfced56dc8e093fc, 0x3fe5053e572b4e74,
    0xc0040c490784c9e2, 0x3ff58dd3ed65c133,
    0xbfd24416ee7fa312, 0xbff3814d9a2bf34b,
    0xc0011c7069b4ead8, 0xc0017d45f3a34f37,
    0x3fb286bb053a4d10, 0xbffac99ddc0d4191,
    0x3fee47d48fd10bbe, 0xbfd04df76fe6c722,
    0xbfed77d31715cfc5, 0x3ff50064a2486eae,
    0xbfe0b59432a25fb4, 0x3ff331a61c7c82a9,
    0xbfd52432a007a53c, 0x4004cef0c703d723,
    0xbfef0973b4181242, 0xc00e588a16afa236,
    0x401863ee28b1960c, 0xbfe9735422517556,
    0x3fd06c0ef83c9880, 0xbf92d76243739980,
    0xbfe1edc6a225069e, 0x3ff2e56c25232412,
    0x4007315a0bdba7a0, 0x3ff111ad1a699266,
    0xbff56245b2cfe374, 0xc010ee61d3786822,
    0xc0028604b69adef7, 0xbffaa116d2b15c6e,
    0xbff6ebc32ebe8d46, 0xbff98a5c831ff580,
    0xbff0aaeb52c4d9f2, 0x3fd794c487d27b8c,
    0x3ffb33d7a727b38c, 0xbfd3b5a8aea8c4ec,
    0x3fd35a02a53ed400, 0xc0053dc93b031feb,
    0xbff871576c39af7e, 0xbfee7a4f705e2906,
    0x3ff4cca8a48f75fb, 0x3fffce350ae245e6,
    0x401008f5a5cc7ac2, 0xc002565c6b9a9044,
    0x400e1cbb56f9a4f6, 0xbff04de816a39ed0,
    0xbff55102f8e031a9, 0x3ff06f285f8ce828,
    0x3ff237e03e29911e, 0x400c2f1db46ce5e2,
    0xbfa09981e8d95ba0, 0xbfff481af71a9a63,
    0xc0097ce33189bfa7, 0xbff1d9889c6d47ec,
    0xc00da1398261e3f9, 0xc005bb9227543b1f,
    0xbfe886560efb6354, 0x3ff74699d9e554ca,
    0x3fd7de0f8773f4a5, 0xbfbe3325b92364d0,
    0xc00fabd376ba7762, 0x3ffdf1af849a2946,
    0xbff13359ea666332, 0x3ff15e5d259dd0d4,
    0x3fe66620319d0f48, 0xbffd528fa49d01f0,
    0x4009779683aa1580, 0x3f97642f8eeb0880,
    0x401022dc652c9967, 0xbfffc28370dd7732,
    0x3fee36482992225e, 0x3fe0182ecf899dcc,
    0xbfe2b99fe3ed5bcc, 0xc007a67fa5e0a520,
    0x4000701b875bb366, 0xc00122ae28cc8e2e,
    0xbff2d2ed3f92a05b, 0x3f8cce5e1bb606c0,
    0x3fb69d3bce563e38, 0xbfd89d7b5e31a892,
    0xc00025c04d7bbea4, 0x3ff54d7cfd3ad0aa,
    0x400c7b7a7f66fafd, 0xc0051b4ffbdff80d,
    0x401270465ce6a3ca, 0xc0038474cd7e2f7c,
    0x3ffc1a5b74c9530f, 0x4002a445b11411b8,
    0xbfc7ace2c632e69a, 0xbfefb6da00a70b34,
    0xbfe08698706e1a3f, 0xbfcdddc7744400f8,
    0xc00d5f3644af70ad, 0x400a5ec82641f96a,
    0xbff7f161bc758f05, 0x3feb955c266392d1,
    0xbfeb9c34080d64f5, 0xbff27fa19b96d869,
    0xc000d2ee4b8cba1e, 0x4000e4d341e8c0f4,
    0xbff1434998771d80, 0x3ff32d66947246e4,
    0x3ffa68bff8afa684, 0x3ff7c9159b4cdd2c,
    0x400cdbf59ed30e54, 0x400199082a4b14dc,
    0x400179cd376d3e40, 0xbffb6c0d0fadfb21,
    0x3ffe11b90072109e, 0x3ffc640832f3064a,
    0x3fbf1bcccff79d68, 0xbfea9cc7356bcaa2,
    0x40027d383d669874, 0xc0107a42690d0f38,
    0x4016bae93896cb76, 0x3fee77c3aa559320,
    0x3fe5dd3ad999c672, 0x3feb5d883fa6a86a,
    0xc0056d52e28c193c, 0xc00ebef7aaf33c64,
    0x401204d32bfb490c, 0x3ffe68620846ffbd,
    0xbfefefbc08fe5e9a, 0xbfdfca826f016320,
    0x40049b1b07fef232, 0xc000c34f22edd94e,
    0xc002b23cbeeea10f, 0xbfe838578b229316,
    0xc010b5b200999273, 0xc00c06c2050c077e,
    0x3fffd1affcbc556a, 0xbfde761ef5122fa4,
    0x4006fd6b8a8dd766, 0xbfd99753d02c337c,
    0x40171d13879cf17d, 0x3f69126af3755900,
    0xc00f999c01d0eef6, 0x3fee74f2537efcda,
    0xc00b4be2bb8789d0, 0xc0124814c3b39e59,
    0xbfdc58bc32f42314, 0x3fe9e310b67d93ce,
    0x3fed19ed596af1e6, 0x3ff8422e0416c988,
    0x3ff99742045f15fe, 0xbffa6da21e33e871,
    0xc0038d86ad15e33a, 0xbff0dadb78c5e2ee,
    0xbfc1bad7837b8538, 0x400cd93f720d4ca6,
    0xbfba7d0da9a84040, 0x400bf260c342b25a,
    0xbfffafa3ebfd66a2, 0xc0111a21a0391b17,
    0xbfdfd07b8c39f1e0, 0x4009490e9bb4785b,
    0xc01a4aa98a00f0f1, 0x400baa2aad4690c8,
    0xbfd25400a421ba44, 0x3fe27b8a9be2ea5c,
    0xbffe94e496022c81, 0x401e85b7aa50fb13,
    0x40051522aeaaad5f, 0xbfe42bad28785478,
    0x3ffb6b0c55f4d6f2, 0xc00525e5551eb692,
    0x40128d90fa8395ae, 0xbfa1b795e7795bc0,
    0x40109d6925a8e757, 0x3fe1e6c5856a7768,
    0x3fece140a0dac390, 0xc004dd0d6db71dda,
    0xbfe54d506723c9b4, 0xc0050e1d3abec080,
    0x3ff67fa07d60b8ba, 0x4010b9abc8f45593,
    0x400256cb16ac2fa6, 0x4005079e514a90b6,
    0x400f8e5afda708a4, 0x4004eb76a1220f4b,
    0x3ff1cc34e55d4720, 0xbfff50419c3f104a,
    0x3fdaf7c3c3074ccc, 0xbfc36488aea7e658,
    0x3ff1c6d1921d7596, 0xbfb1f2cb0b10ae10,
    0x3f407cd4dcc35400, 0x3ffd18464f324c70,
    0x400bb4c2b4be802a, 0x40005d7041836804,
    0xbfcd4f5c3eace398, 0xbfff7410fc227635,
    0x40109d17ff9f816a, 0xbfe0a24e86a0f1a6,
    0xc00303e0f06b31ca, 0x4001f8e48ca347fc,
    0xbfef2b7005a5c48a, 0xc003d3b5245d2153,
    0xc011e058bb464182, 0xbfe0bd3edd774b82,
    0x4016f37bccb56d6c, 0x3fe3d96a321a689e,
    0xc010a6df89d9103c, 0x4009ad63fec2e72e,
    0xc00b3fb30cda30d9, 0x3ffbb158e21caffb,
    0x400035c47b9806cf, 0xc011953cc72b1528,
    0x4006ef609c44f3c0, 0x3fc5406547e44ca0,
    0xbfb8e2da64d82b70, 0x3ff766a6497d3eb6,
    0x40007260d482579d, 0x3fe3fbc7ba9d528e,
    0xbff32fc29c9a054e, 0x4002edda96e451c9,
    0xbffe16811f9a44b4, 0x3ff3d370899bd5bf,
    0xbfe975366cb3e9e4, 0x3fc580c4ca6c70ac,
    0x3fc4662a333762a6, 0xbfda88aeef6cecc4,
    0x3fd2061cf1775f5c, 0x3ff6013dbf2ad294,
    0xbfe372e2acf980e4, 0x3fb3c32d4a70c3f0,
    0x40132d4abb038b74, 0xc005042d1f7442e4,
    0x3ff36949da7ab244, 0xbff5ca5b12f2e2c5,
    0x3fd5ae078a6483e9, 0xbfec41dfb6d73467,
    0xbfe560078b5246b3, 0x3fe77f410dab0436,
    0xc009e726b7515f36, 0xc00b7d096a0fbb89,
    0xbfe0049b1ee8cd76, 0x3ffb1c3851fbff0e,
    0xc002858e4ddfeae5, 0xbfbc643d0e3c30e0,
    0xbfe79838b05ec6e3, 0x3ff18c19fa4c0292,
    0x400f41f1dc702576, 0x3fed42406dca07ea,
    0xc0037ebb9b4a9c42, 0x3fef27f6e27e79ac,
    0x3ff6921f4198042e, 0x40001c9f340544f4,
    0x3fefc300e685bfb1, 0x3ff0299987f1972e,
    0xc0056cb69ce7b0ee, 0x400ab95713331d51,
    0x401b98f5dffbed9b, 0x3fabae75fa7c7e80,
    0x40058926f4d5e50c, 0x400401e7aff403c6,
    0xbfee38599593b00b, 0x3f9984bf868c3540,
    0xbfe10902081ed6aa, 0x3ff2ea0b79d87753,
    0x3fe4073d105b7428, 0xbff0cef6863e0377,
    0xbfe3903c659dd8f3, 0xbfca6bd9842f1270,
    0xbfdb5eb5a0912dd0, 0xbff73abf5102efb1,
    0xbfdf6e489062107a, 0xbffc95d0d9549312,
    0xbffbdea27221db30, 0x3ffe05d285130032,
    0x3feeccdae0e9d3f2, 0xc00fc21b1a41550e,
    0x3fe8410a43ebf252, 0xc000aa1a1a3e2f55,
    0x3ff823a501828568, 0xc0015d0d43cde7fb,
    0xbfe8990fc59db179, 0xbff0e85f6afd4738,
    0xbff4a97511ad4a74, 0x3ff2a5a4ef3ac074,
    0x3ffebae8f91c649e, 0x3ff30befb0e0706c,
    0xc00172ff91bc06b2, 0xbff08949d500b91b,
    0xc0184101b90b1a7c, 0xbff4ef3a371f3d96,
    0x3fc7b643a42eb2f8, 0xbff735226c9067fb,
    0xc006968e527655d9, 0x3ff2cb5f89e10b0f,
    0xbff71dc3c526d60c, 0x3ff16c9d43cbf8d6,
    0x3ff847b57d737382, 0x40031f71d9f9abee,
    0x3feb703b4198fb6e, 0xbf917c4d47349120,
    0x400a6b694a4218a2, 0xc008b6658150a92f,
    0x3fe725f89674138c, 0x3ff6f434de1a8a63,
    0x40008d7004bfac22, 0x4000284eaefeb6d9,
    0x3ff78a15383edd2a, 0x3fe934e7559560fc,
    0x3feab19aaaff263c, 0x3fff3d81de3a342e,
    0xbff1f9527c417960, 0x3ff4176327fb56f8,
    0xbff1a49fccde922b, 0x3ff518d21f4c9d30,
    0xbfca57cca8a81008, 0xc01327e02fe0a125,
    0xc011e46ac7e225ac, 0xbff9b31cb4df9f6c,
    0xc003d211a74304f6, 0x400591067fe04b74,
    0x3fe45ef25d342c3a, 0x40049bfe78065382,
    0xbff55b57f71ca6d0, 0xc000b31edbebd3b9,
    0xbffe341b4d750087, 0x3ffbd72b4510de3e,
    0xbfee329760cbdae2, 0xbff8be8c72b59a9e,
    0xbfeaa75d1ff7fca2, 0xc00015e416c51d82,
    0xbffe160e30229992, 0x3fe04ebdf4251c51,
    0xc00748d71e01c651, 0x3fd47a6df71864ec,
    0x3fd3e1acab215646, 0xc0078c4e7799fba1,
    0x3ffcd43697af1342, 0x3fe05917e3fc4265,
    0xbff331ec5669480d, 0x40100c0ea9b6b7aa,
    0x3ff39c54680fb9bc, 0x400362e38727ff33,
    0xbfd75c5926cd7768, 0xbff7941f6fb35637,
    0xbff2a75bebddbccb, 0xc003ab48acb6f971,
    0x3feb90beb6260730, 0xbfcd83f116962880,
    0xc00554f596c456fc, 0x3fe8a6211e2900ea,
    0xbfd86dd287fc4546, 0xbff71ef1c49c9fe6,
    0xc00203156b393e24, 0x3ff53def958b4ed8,
    0x3fe5c7fb03f309bd, 0xbffe3d8063a08f7c,
    0xbff27e35c7bc5c4d, 0xbff2a711a78842b5,
    0x3ff94c31d8c6805b, 0xc0040d2daa8cac5f,
    0xc00587bb1644bee6, 0xbfc75d61fa049960,
    0xbfc6577d5d6fa7f0, 0x3ff95ead8c3379e6,
    0x3fdb415b805ab4f0, 0x3ff60600c90b9c7d,
    0xc011b6ba0d6e395b, 0x400e1d537210068c,
    0x40090208e2a22042, 0xc000294dda7754b5,
    0xbff96496cf523bda, 0xbfe8cf1a8a64f7cb,
    0xbfdb458018abe8d7, 0xc00d2bcc81dd83fa,
    0x3f86450959fc0000, 0xc005b3a4049817e4,
    0xc005b683d2b29b6e, 0xc011c759ca69a95d,
    0xc0107cfd3988959a, 0x3ff2f98f5f9f96c2,
    0xc00343a9bfc20ee6, 0x3ff8ea5137e1d1a1,
    0xbff641a1504fc86b, 0xbfdc516a3272f59c,
    0x3ff5b0ca1fd9e87c, 0x3fd9828a20a68d12,
    0xbffca2178b8662aa, 0x400d8e5fe05a4ef8,
    0xbfe2d1ffe7d2ff0a, 0xbffe810ae590c904,
    0x40020bf97fee8a6a, 0xbfb7773478f4dbf8,
    0xbffd7948004f9e0a, 0xc00026459c214ac0,
    0xbfb6ed8048a6f250, 0xc009ac4261504471,
    0xbfface6628297b90, 0x4004d14bc803d5d4,
    0x3fc395bbf108ecc2, 0x3fed4b3cc3d91b6c,
    0x3fcc1e1224e1b5d0, 0xbff87df794582ad2,
    0x3ff6c906ea0ce730, 0x401068bed425610e,
    0x4006458f28dfcc02, 0xbffbfb75fa02d8da,
    0xbffefe3cfeb559fe, 0xc0027cc108693ef8,
    0xc00cb03d8b812375, 0xbffaf22ef5381857,
    0xc005ee489fea39c2, 0x3fc9574515fa22e8,
    0xc00459d3e4bfe4ca, 0x3fbc83ffa0664830,
    0xbfcba3d5986a6e00, 0x3ff2232a4e839dc1,
    0x3fdf62e5779b1c3a, 0xbfc8679d6043e560,
    0xc00ee785b67c8b8c, 0xc0193835ec5c2b62,
    0xc00df53d237ee119, 0x3ff51b0f9e0dfcb3,
    0x3fe22771e304cc30, 0x400e9afbaa037906,
    0x3f936bc91f4bfda0, 0x3fe304206cef3256,
    0x4010f4785d04db50, 0xbfa0985dd8299b60,
    0x40085d60c34e93b6, 0xbfbd9c16172d9600,
    0x4001d9f00aad31a1, 0x400859235ecb9f5c,
    0xc010c6e1259834d3, 0xbfcb534e0a530bcc,
    0x3ff370e5f5e98526, 0x3fc07e6f3910c4d0,
    0xbfe99de69c17051e, 0x3ff3e65b519eee14,
    0xc0078fc291c8b2c6, 0x4007741db040dba8,
    0x401324bdefb9fa6c, 0x4004bd7f74203d17,
    0xc000260679c878bb, 0xbfffce7b6afcf9a7,
    0x3fcb47a1d642c1f0, 0xbfdd10ccb5df320c,
    0x401039dde8ebec2b, 0xc01be4168ff0c23c,
    0x3ff0732be35733aa, 0xbff91ff2e9f81168,
    0x4003a867bc3fbc58, 0x40022a5f20875c2a,
    0xbfca7f7ef96fdad4, 0x3fe3a458257f73f4,
    0x401281c37ee62717, 0x3ff086c8248fc9cc,
    0xc01403cbfcfb2111, 0xbff03dde57d5d7ef,
    0x3ff3bc0f983a005c, 0xc001dde601101814,
    0x40007077730fa08a, 0x4000841bc7af8e6b,
    0xbfef09bff6da8ee8, 0x400b34bc476abc8f,
    0x3fe03eba07974504, 0xbfdbfa3018e4939c,
    0x4004346c7fbf8906, 0x4004d51e5ba0dbf9,
    0x3ff61abc649b9fe7, 0xc000a945aad05354,
    0x3fbf89023ec82ce0, 0xc006cb2cc55b1e7a,
    0x400a374261311ea4, 0x3fc0148d33ce9534,
    0xbffa9526347d5b99, 0x3fdfb3c48d72e730,
    0x3fd363bc53c54b5c, 0x40020a46ac47b25b,
    0xbfe934ab14b1e1d4, 0x40073b0171ab9a20,
    0xbffefb57395bf7f2, 0x4005d444f3c240ed,
    0x3ff8b54a56794ce9, 0xc00ac7348503ba43,
    0xc006e0b578144685, 0x3ff428ad07eb0302,
    0x3fe743bcb12ef62e, 0x3fe8233e46392f3c,
    0x3feb288943318788, 0xbfd25b1a02157672,
    0xbff28f292e53cafe, 0xbfded120e237a028,
    0xbfdb27f342ec0f44, 0xbfb02f584ee853e0,
    0xc00dd50bc095a99e, 0xc0057d6c5c840680,
    0xbffdb556521540c8, 0x400e20fa73639cdc,
    0xc0020c3a4285d6de, 0x3fec5129c0f4b7d1,
    0xc0055380a7bb29be, 0x3ff1095f301fda7e,
    0x3fc28b6132a37f70, 0x3fe38f1f6c6382d2,
    0xc007fc0584c2704c, 0xbfea8bf163fe9d7a,
    0xc0005045bdc376f8, 0x40060eeb8cd51b12,
    0xbfff4c294962ae70, 0xc010b2013f690457,
    0xbfde8cd71cbd7464, 0x400e27badae73364,
    0xc006677d6b8a1944, 0x4007af660e661a3c,
    0x3fe749474078d268, 0xbffd25a3d2abe210,
    0x3fe6fddc420371b8, 0xbffd6a37e5a6e703,
    0x3fe6ad47c3666e24, 0x3fe297c3b25f8874,
    0x3ff10a337b538f13, 0xbffa6ebeffc33a98,
    0x3fb7cd577c4790c0, 0xbff2fee42b9c8776,
    0x400998092d69deb6, 0xbffe46f3d1c8cd4c,
    0xc00e182ecf6da4fe, 0x3ffe83233bc23084,
    0x3ff079502cf0b242, 0xbfd948f29d525168,
    0x401f13e197e2e0d6, 0xbfd3656337494538,
    0xbffdc991022e394a, 0xc004724e2ccb40aa,
    0x3fe78835eb9327c8, 0xc00f802a53f1588e,
    0x3ffd40a3f6cc2b5a, 0xbff58e64e4c05dd4,
    0x3f788c4afe61fe00, 0x4000e42ad114c5ee,
    0xbffbf22cf5843da6, 0x3ff3398156b81cae,
    0x3fec5a809993146c, 0x4011289cc564b5a1,
    0xc0020b2539d008b2, 0xc0068180538fdf26,
    0x4003d9c263e772c2, 0xc011afd26ae77628,
    0xc007cc24b74ec56d, 0x400576a9c8bb3b09,
    0xbffb28ce6a2e2382, 0xbffed6ba01d0adc4,
    0x3ff2c18c9da33b56, 0xbfc2f315925d340c,
    0xbff14fe638890f42, 0x3ffa7d8e69f6c392,
    0x3ffc4039c1a55309, 0x3ff1940f36cfac98,
    0x3ff5092fb1d9a583, 0x4004bfe652895938,
    0x3fe57433002dc2d2, 0xbfd83f37b9062b64,
    0xbfdff51db7db9a58, 0xc004fbd8c0d39eac,
    0xbffdd359f2acc9b4, 0xbfe95f917d332059,
    0x3fd9735153bd0b88, 0xbfff416ef60fe208,
    0x3ff5bc34515f1820, 0xbfaba1fcb31934c0,
    0xbfddb5b2277d67d8, 0xbfcfc9349ec82ba0,
    0xbfeef934507cbc8c, 0xc014fe64d2b9c232,
    0xbfe9221701ab481a, 0x3ff338a01938ab91,
    0x3fd531fd7503ca74, 0xc002d36335166f68,
    0x3ff4f593a5c69247, 0x3ff5771731d2acb0,
    0x3feec4be66c8949c, 0x3fe02ad28fb57028,
    0xbfffdee37812df68, 0x3fffaf2431558a05,
    0x3fdac2a1ccad664c, 0x3fe2876ce8c439c8,
    0x3ffaa3148a688067, 0xc0005d048d30cdea,
    0x4001c4bf2265df08, 0xc01b1cb919f4341e,
    0x3fe6faca6b7c9d6b, 0xbffad3c12dae3d17,
    0x3ffc218a0cf98ea3, 0x40096faacb761bf4,
    0xbfeac539f8c4a2b4, 0x40030992fe9f0a09,
    0xbfbae1e9d6dd9db0, 0x4002c476bdaf87e6,
    0x3ff92e3d478845a4, 0xbf76087e998f4400,
    0xbff502f4a4efe1d9, 0x4002080d33c1c928,
    0x3ffefab2dd9b9a7f, 0x3ff0dee7227b616b,
    0xc0052da62290baab, 0xbff94b4864dac0cc,
    0xc00ed0221ef5bc26, 0xbfc835e650e0670c,
    0xc00cef0ac7e5ab37, 0x40011b53baaa2e57,
    0x400d3b1775a8060b, 0x3ff7cc2709ec3ad4,
    0xc007a33126222c55, 0x3fe1b66d0116568c,
    0x3fcd020868d316ec, 0x3ff6c4f3ff2af410,
    0xbff4fdd66d2c005e, 0x3fe1b1ac3c32ab54,
    0x4016c6e31c5fec48, 0x3fe88a3bddce98c7,
    0xbfdcc093ff6ecfd0, 0x3feed321f2a656ae,
    0x400df043fb2de9b3, 0xbfd8427bc4eb3dd0,
    0xc00d05f1b6e8ecae, 0x4001baa770d64e9c,
    0xc0012f9896f5c225, 0xbff5ed5abf2bab72,
    0xbffb0eff52923a49, 0x400a9e0f1f9fae2d,
    0x3febaaa9b821b413, 0x4007f4fa0da3325e,
    0x400fc20b81dd46ff, 0xbfe2cd3e059b823b,
    0x3fd04223fcff6780, 0xc00e0522a6bed3e6,
    0xc00b602e8f867182, 0xbffa35ee78b63c4f,
    0xbfc685f05a3b5b74, 0x3fe82396674ce06c,
    0x3feebbf1eee59764, 0x400075fb7ff1a7b8,
    0xbff260b8b40f526a, 0x3fe92c9067315426,
    0x4002b351e995ac96, 0xc00037b86763f611,
    0xbfea9acbeb6028a3, 0x40123b65225cea34,
    0xbfe98c93b4319db7, 0x3ff16afbe3f6604e,
    0x3fdd560ddf5e6b80, 0x3fe8e0f9192be286,
    0x3ffcc1a63da74585, 0x3fe439408273b6e2,
    0xc001d7650b986c7a, 0xbfe2ff8957cc3d12,
    0x400fac93f627f3b3, 0x3fd997c2570d063e,
    0x3febf7da7a995a53, 0x3ff7f30ebcbb7341,
    0xc007cc95eb28333e, 0x3fee3572096e6d66,
    0xbfe29577e21bcd86, 0xbfd6a6ad64d47230,
    0x4005f4d5f76a6d87, 0x3fe5ee0487aa4388,
    0x3f8554bf50345dc0, 0x3fe28bc163123f22,
    0x3ff69074b5c71c48, 0xc005fc29286e6cb4,
    0x3fa1941e074a9780, 0xc00014cea4c92501,
    0x40118102d4e86ef1, 0xc00821a4cfac8492,
    0x400afda24dcfc7a8, 0x3fd68fc2ff4c9b78,
    0xbffba5c9159125d1, 0x4018c6c860b7d078,
    0xc0114be3a6f53768, 0x3fed442305bd6e91,
    0x400abc8c85789f44, 0x3ff7d1f88d35747e,
    0x3fff8579262002fb, 0xc00b6bf6694075d6,
    0xbfdd3d9367e10600, 0xbff35ff88f7e22da,
    0x3fff8e08f67f401d, 0xbfff181b0cafc88c,
    0xbfd755fca92b912c, 0x3ff7b860fd1b5576,
    0x3fe5b88837f4892a, 0x3ff564457664fd13,
    0xbfe00678260aff7e, 0xbfe62648ae3342c1,
    0xc000433ca4f8e3c3, 0xc00d6a12e25c8fe5,
    0xc010091ef26fa9b5, 0xc00b614c6d1a7ec0,
    0xc00afe4f830e1bb0, 0x4007dc3368ba0fea,
    0x3fe3866075e2e298, 0x4006e194af86213f,
    0x4000cb592c6f6d2e, 0x3ff5632432d20f70,
    0xbff9e392cb6b4cfc, 0x3fe4b61716fb2fe7,
    0xc002fbdc4a14be46, 0x3ff678a2b772f128,
    0x4000385b85b2e5a1, 0xc007f6b672210bac,
    0xbfd77a40cf9bb582, 0x3fefcd8d9854e386,
    0x3fff6b68072ae8b1, 0xbff285feb8c8a2ff,
    0xc007691c05f64658, 0x3fcb455ff93234d8,
    0xbff1787a84478a2c, 0x3fc4191ba49b2ac4,
    0x4002e1d6c12f2c2e, 0x3fdc5c8b54c7973c,
    0xbffc153f0c304216, 0x400154b8db8a376e,
    0x40026a6f1058a4fe, 0x3fed91511e9d8afc,
    0xbff1ef3328b94baf, 0xbfdfee3862f912ca,
    0x4011dbd8953a6653, 0x3ff7e21f825683ae,
    0xbfba13649181cf18, 0xbfe7407f7f5c8332,
    0xbff576e892ce72bc, 0xbfc666811fe158f0,
    0x3fd73ad2c860dfd0, 0xc01284ff7e3545ee,
    0x40127b81fbe6fe7b, 0xc0001913b8f9fc7a,
    0x4005da0fbb8d722c, 0xbff700afe20c3fae,
    0x3fee1e4e5d9a06c0, 0xbfbb3f938a5ad150,
    0xc005892039e6fe89, 0xc001a4a5eca54058,
    0x3ff7afd4ef8666db, 0x3ffd83b170e44c04,
    0x3fb96df32a24176c, 0xbff97f6cfb435fab,
    0x3ff0978a15016d24, 0x401267d7100c3d7e,
    0x3ff957a08598949b, 0xbff2316d54a67080,
    0x3fff449775e01658, 0xbffa23d808125123,
    0xbff012098ce4ae98, 0x3fd054bbdfbe1c51,
    0xbfe22aa307bd6ebf, 0x3ff77ae080deb96d,
    0xbfff6014e97859a9, 0xbfd16f0ad26ee1d0,
    0x3ff96a608ea89e89, 0xc0026069677219d8,
    0x400848886e7b4af6, 0x3fd7b26180a20484,
    0xbff9793762c3d811, 0x4000f8c34878b95e,
    0x3fea1b3d0f8acaba, 0xbffe2baaa3024968,
    0x3fdf9b806ed4cfe8, 0x3ffa528c85a9e218,
    0xbfccd416f179c018, 0x3ff4500d27997241,
    0x401e3ca8f6833bda, 0x400b181e84f5672b,
    0x3ffaf33f5024e0c0, 0xc007e314ea682b5d,
    0x4008f0605bd46a6c, 0xbff81dcc0a1e1852,
    0xbfe20030908b1578, 0xc007b67e4b0a0940,
    0x400e1a0a4d7b8c0d, 0x3fff8fbe52a68ece,
    0xc003be764c9fe73c, 0xbff355cbbdd38498,
    0x4017675df9a0c918, 0xbff2c72bb04f91f3,
    0xbfd8f1b4368093f0, 0x40088d3b2d803f7a,
    0xc00b8e96d5357ccf, 0x3fc067e4555b741e,
    0x3fd7e2957ddda676, 0x3fea027152e61c04,
    0x3ff2f745002df0d4, 0xc0073d67565ed2b4,
    0xc0023d28f777d938, 0xc00aa7e206b9ee0a,
    0xc007877b9aaf9a37, 0x40091deeeebaa83a,
    0x3fae209a319d1400, 0x3ffa40862eeb06fd,
    0xbff85561f61447f2, 0xbff36de1970d55d8,
    0x3fe43ad4f5e8080a, 0x3ffc6be1c57bb04c,
    0xbfe2ba91d19aae8d, 0xbff99120b5c628a2,
    0x3f72600241071e80, 0xbfd27d97f9470ee2,
    0xbfef656341f8205a, 0x40015052ab685919,
    0x400203e989388e8f, 0x400b6a3b30e9fc2e,
    0xbfe845857ddb72cc, 0xbfdd1e06230056a8,
    0x400bf23939069f0e, 0xc00f7290b638813a,
    0xbff7a4db0540d58a, 0x3ff769252e32d998,
    0x4001e31cab7299c3, 0x4014b361f0c44046,
    0xbfd44857435ab518, 0x3ff7bd866c04ea84,
    0x3fe5f9f672c180ec, 0xc0112178eab97f94,
    0xc007e37d9ea66601, 0xbffd11aef9d2d188,
    0x3fffef98d3420313, 0xbfe3b21c72fb0f10,
    0x3ff4fc644c2a96ef, 0xc00a4bac0fdc4efe,
    0x3fd987f39a0439a8, 0xc0065c43d0387571,
    0xbffb24ff332c268b, 0x400ea66ab74581b6,
    0xbff9f1415f8ad3e8, 0x3fefb751292e98ba,
    0xbfca792efd96652c, 0x3ffdf35607f24dd1,
    0x3fe8f382020f5501, 0xbffd525e02170522,
    0xc000649b847b9dc6, 0xc00aa10fd73fe22b,
    0x3fd4032447ba220c, 0xbffba0ac4342a827,
    0xbff0b4b8a842153c, 0x3fdab82072934e3a,
    0x3fe4723bafd0e958, 0xc008614bbe86a147,
    0x3fdd95dd87de8f10, 0xbfe9aa7abdc85a9c,
    0xbfeaf8ece18e5798, 0x400e0266aa031269,
    0x4012225a6c04b88d, 0xbfc7998c227b2610,
    0xbfe4d3fdfeba4d64, 0x3ffb028eecee4770,
    0x3fd885629256e41e, 0x4010a5900cd45ccf,
    0xc006ee390b59d51f, 0x3fa5c6d766d6e260,
    0xc0075d86ecbb6246, 0x3fe91ded5b1280b4,
    0xc01507cc8527f928, 0xbff33df3075d90ba,
    0x40004b98bd1ffa50, 0x4005cd6cde41b18e,
    0x3ff01cc9b3dc8d54, 0x3ff88b2dd040f8da,
    0x3fe9e8a5b422d82f, 0x3ff366a1693577e8,
    0xc00fb9159a2caf7e, 0xc01348211fe19aca,
    0xc00186ddabe9b369, 0xc00071aea6cda1b8,
    0x3ffe0d3fb49f4f65, 0x3ffa0a62d546d3a3,
    0x3fefba223b6f5d22, 0xbfccc4afcce1816a,
    0xbfe3df3f13b486bc, 0x3fee92f398e2d395,
    0xbfcd1b4e0f6e35f0, 0xbff52d506ce4eb36,
    0x400475d3afc551ff, 0xc00f7262c3296a08,
    0x3ff34a3a4d66292d, 0x3ff4c2c2e3c3cf33,
    0x3fdff40c6e57e374, 0x4008ed42d15293a0,
    0x3feefa591696c6f4, 0xbffaf9d395094397,
    0x40045548cf3600a7, 0x3fc2fef7cae267c0,
    0x3ff148cd39dbf043, 0xc0028360973ff25a,
    0x4003a34f767816ed, 0x4006fbc531abc883,
    0xbffe6dec3ff8f5ad, 0x3ff5af7bc1021b33,
    0xbfbcd33903d5d814, 0xbff1c1c61d5254f4,
    0x40134180144d6c00, 0x4007ff42182d8a8a,
    0xbfe5a85f22b0641e, 0x3fe3b72376efd6e1,
    0x40015a576d398cec, 0xbfd8ce21554ca794,
    0xbffd75232d2965e1, 0xbfb5c1f68e182b98,
    0x3ff8c05964f04687, 0x3fcc3f2b4f61df3f,
    0x40056962d8b8d2e6, 0xbfe9266e16361336,
    0xc00d374867a2a710, 0x3ff6985312de3a0a,
    0x4007622d4f90b93e, 0xbfef70344e3983a6,
    0x40029acc4c9d14ab, 0xc00473467551505d,
    0xbffd0155e4e75781, 0x3fc25a63a9473fb4,
    0xbffc5e2b8146d2be, 0x401c3c94174b66af,
    0xc014717763d3c930, 0xc001766a354d2525,
    0xc0105d12c3834b7c, 0xbfbb9bfa747a0630,
    0x3ffa8cb61d105a7b, 0xbfc5ef1fa6617e90,
    0xbfa7357c61f0cca0, 0xbffe8d08364f5a55,
    0xc00d1362d2836bcc, 0xbfedb77b6166526f,
    0xbff201568eef3b98, 0xc0059234d4568b2b,
    0xbfe29371d796c472, 0xbf982f1ee104d900,
    0x3ff04c2f65466c5e, 0xbfb8468af544bc60,
    0x400e444d02873eea, 0xc004ef3fa8a95208,
    0x4002eabd95a409a8, 0x400b1a9a8acc9e54,
    0x40163a04f3fb7a15, 0xbff2791549296010,
    0x400aa0ad5b455b43, 0xc0044f60d8c17253,
    0x3f90cc503bb7f840, 0xc005150f03aeab30,
    0xbfa20a0540ff8a40, 0x401071e0185378b5,
    0xc0096a4296ba3ef6, 0xc00f4fb316eea183,
    0x400624c4127e2c74, 0xbff92c38cfd7e385,
    0x400109590d366821, 0x4004e234cfeaa7b7,
    0x3fe40ad11f8987fa, 0x3fd725a6f2f83c4c,
    0x3fe5a298cbf9b095, 0x4001771f570cec2f,
    0x4005aa2315311532, 0xbff6091dbfaecae2,
    0xbfe68eb361a0e1cc, 0x3fe2e9fdcb21eec6,
    0xc00e401ba4b22f86, 0xc00393ca4841a419,
    0xbff7cbacc1a5f217, 0x40081cabd3e3a8a8,
    0x3fe8408b5a205850, 0x3fe544f6da169f24,
    0xbfe7777a04fce1d0, 0x3fef374ffa4e8182,
    0x3ff292ff1f4dc5a4, 0x4011af89e04072dd,
    0x4002df53bbb167b0, 0xc010183d06f5327f,
    0x3fad890381f01d30, 0xbfe6483f245625e0,
    0x3fe5e11177a950e0, 0xbfc43888d3c4210e,
    0xbfce533db6e46d68, 0xc008cc2fea798124,
    0xc004749e8f26675d, 0xbffd040addb814c6,
    0xbfe7fdca9b1d9226, 0x3ff5d2374825b8ae,
    0xbff6d1439c00d6a0, 0x4000d573ff2986f7,
    0x3fe6886f97866919, 0xbff6ff944aecb99e,
    0x3fe012d2820b8d82, 0xc00c377b28141f36,
    0xbfc3c40e42631398, 0x3ff56923c41ba44f,
    0xbfe7366d31ad7496, 0x4009b0e83e882950,
    0xc00bbcbd522e42d8, 0x3ff1d91e6a45c0cd,
    0xbffc518ffd956f47, 0x3fba8028bd407a90,
    0x3ff61edb216983bc, 0x3ffc94300fb5ff24,
    0x3ffcc13efad69d76, 0xc0126b4dfcc95c7e,
    0xbff90d31621d4c9e, 0x3fcd6325f7120960,
    0x3ffd76e646b8e8fc, 0x3ff26442755f3c7f,
    0x3ff01c88ecbd92db, 0xbfe9986c033d0dc4,
    0x40067cf1f1e32898, 0x3ff20c2db7bbe9ec,
    0x3fe1e172206b466a, 0xbffd5228508a7106,
    0xc00050b31d10b3c2, 0x3ff094cf003a1e1a,
    0x3ff8510f99466a50, 0x3ff46b93b07783a7,
    0x3ffbfa64cb76f906, 0x3ffd341fe862cde4,
    0x3fe70957ab445cb4, 0xbff7302fc584756e,
    0xc004f1aed3f8d052, 0x400d6909843837e0,
    0xc00df08213f46554, 0xc00253c2c7489110,
    0x3ff9d2ef0108cdf2, 0x3fefcdc6924b869e,
    0xbff15597b19d6559, 0xbffb59361b101580,
    0x3febf3d60da1184c, 0x3ffa8c6e4fbeb1f5,
    0x3ffa2fa886423baf, 0xbfea033888bd49b2,
    0x3fba769aaddba370, 0x400640592ad70d9c,
    0xbffd5f1aeaf83ff9, 0xbfed787a36c22e12,
    0x3fc381de83efdfa0, 0xbff9ca8c2cc87336,
    0xc00864c1ca7c0d04, 0xbfe80d8a4ef7a6d5,
    0x3ffe109bcc31c4e6, 0x400318d488321273,
    0xbfd347d339ed92b6, 0x3ff922a69b2da59f,
    0x3fe2b0c65c81927a, 0x3ff96a72ace9ce35,
    0x3fff859d62fce352, 0xc0066969b7da1584,
    0xc00c7df25a3453bc, 0x400093caade9c8f8,
    0xc008326b24711172, 0xbfddfd993e435cbe,
    0x400a32bc1ce65e64, 0x4003cfdc88da766a,
    0xbfc13eae5158c764, 0xbfe73e3d4bc70c5b,
    0x400f61357aab6e2c, 0x3ffd148b8eda28be,
    0xbfddc43fdb8a4bf5, 0x3fd9ba0a92def8d8,
    0xbff1609302063999, 0x3fcb0ceb39ab1ef8,
    0xbff3ba65e84dd376, 0x40056cef34109cd0,
    0xbfc64f7ba9d2d325, 0xbfe263f3a80ce874,
    0xc0084f3ee0b09ad4, 0x3ffa53a954885af4,
    0xbff3ca4f18a87ae2, 0x4009a5ef746e160f,
    0x3ff05d8dbb4ca41b, 0xbfe2cae7208d5598,
    0x400ec1f1c1199dd9, 0xc0155561010f0c68,
    0xbfdd675b9b4bce38, 0xbffbe6ea427847f2,
    0xbfea6c30a16fc560, 0xc0079d4ea2291697,
    0x3ff5dd7f32b22c80, 0xc0009122b503cc45,
    0x4011bb00c5a3ada3, 0xc0041812136f5026,
    0xbfe4573739f507fa, 0x3fd770a40baff4ea,
    0xc0093f4f0095409e, 0x3ff2a8e3ac86138a,
    0x3ff28c9da84b3e72, 0x3fbff74feff8df40,
    0xbff58d5410203b45, 0xbff50bc6c1fd426e,
    0x3ff02f97b6472ab8, 0x40010c45b112b6c9,
    0x3fe809741b37e5a6, 0xc007c08e045732e7,
    0x40109c8d4501d044, 0xbfed1440b6541898,
    0x4014cdb110b0dc36, 0xbff8ef22a3a604bc,
    0x3ff2ed1bd97005b3, 0x3fc435bb4075251a,
    0x3ffde0f3ee34fb7d, 0xc011cfa450b31aef,
    0x3fe02ff77a630dc0, 0xc00d2631dd40867d,
    0x4003b9fd6a831b29, 0x3fe9b9e806dc8585,
    0xbffa47eb41c1c664, 0x3fe96db2f0015be2,
    0xc004c800baf37c3c, 0xbff77d7601b82ee4,
    0xc0003ba4ce933586, 0xc0039a33e71ec4f1,
    0x40066ca5b97487bb, 0xc0105a66d48c1519,
    0x3f91521dbd2c6c00, 0x3fedfba0fb516971,
    0xbfe11a7148d8ed3c, 0x3fe8daf1fab7f8de,
    0x4003a31242f72006, 0xbffb65460cbe7937,
    0x3ff0dc4b3cf58772, 0x400332abb5bbc0ad,
    0x40017d95204005b3, 0xbff8798283ba3f6b,
    0x3fc21fd71e749f20, 0xbfe20d97e26ad5ae,
    0xbff1cf54a8a3103e, 0x40065e2df08a33e6,
    0x3fdd769535bf5270, 0xc008141fd25555f4,
    0xbffb16f24d5ab8bc, 0x3ff7bcecb604a9ff,
    0xc0037db65d1feb73, 0xc0120fd8f227d99e,
    0xc00c6d86e8e5476b, 0x3fe2ae3b54977782,
    0x40029ede5f9fd71e, 0xbffcb6dcd43567d9,
    0xbff53daad39f0dca, 0x3fd5fd87d687d658,
    0xbfd7908c5103e1c2, 0x3fc051f0506282b8,
    0xc000956b2655409a, 0x400c71ee9672f8ed,
    0xbff81e47c076c8ba, 0xbff2dcd7287dbf94,
    0xbffe5052573daeaa, 0x4013f2c60f844754,
    0x3fe71c7cc31b5874, 0x40001905ddc14446,
    0x40006ef39be31b12, 0x3ffad51c51265127,
    0x3fc45f2d18114ec8, 0xbfe8c8ad1ce0dc3f,
    0xbffcb50e7e8f8bfc, 0xbfcbf5fdc706c1b0,
    0xc0076cf12f1e68cd, 0x3fe2c34b8519a1fe,
    0xc0046e868990efe8, 0x3fdceb333ea1d28c,
    0x3fe05cc6f460117c, 0xbfb51f3bd06515c0,
    0xbfec2978ded05401, 0xbff5f6f82863f7a2,
    0x400cae825b38cbd4, 0xc0008ef9166f3bdd,
    0xbfc1786e3ff7201c, 0x40129b88afd4dc34,
    0xbfc6b4fc8ed199b8, 0xc00032ec4d0679c0,
    0x3fe00521c881c43a, 0x3fe3408dd4af7754,
    0xbfc3528018a72a7c, 0x3ff116e601cdd05e,
    0x3ffb6b4b7b5f8661, 0x3fb5f6a357fe1de0,
    0xc003b0c63797eaf4, 0xbfe66d85213eea24,
    0xbfe12943e71dca40, 0xc00be39f077b3b3d,
    0xbff06baea649da1c, 0xbfe9ac27ae194320,
    0x400389d1a6c0c9e7, 0xc004997ef046dc1d,
    0xc0035ced523a3702, 0x3ff2ab07901370cb,
    0xc0106fd42fcc827b, 0x40024e5b577d7cd9,
    0x3ff2e7edd59c4078, 0x3ffff0db58eed50e,
    0x3ff8e1082bd4eed5, 0xc007488e336b376f,
    0x3ff2a6d52e5de221, 0x3fc17c50d593a1ac,
    0xbfdd2a8d07cc9286, 0xbff31bd663bc4024,
    0xbff8f3d896b2030c, 0x400bd4dbeb24ae0e,
    0x3fcd53bb45796170, 0x3ff819a53b18f41e,
    0xbff61eb000207dac, 0x3ffd88c416ca5c86,
    0x400e5333e19b73d8, 0x400028a91e073dcc,
    0xc001ff86435e32df, 0x3ff38c9c835dbbe1,
    0x3fceb132bd9a0168, 0x3fe494ac7c1faade,
    0xbffd29d1934c2829, 0xbffb7bca61b26e48,
    0x40048649fbc7384d, 0x3ff1674f4f1b3779,
    0xbfe01defba4f7336, 0xbff05d3026f424fa,
    0x3ffc090fdc2af9b6, 0xbff7880703df86c4,
    0xbfa2ef928de430d0, 0x400ac12608231382,
    0x3fe8ed0d2b332730, 0xc00d9c8ea07c709b,
    0x4006816af5793e82, 0xbff12b11af621054,
    0x3ff222c585d0ff10, 0x3ffc4c7f0aba4036,
    0xbff163a6d984007a, 0xc00167cd34058338,
    0x3fe05cd9a6bfa966, 0x3fefeb8270cf5a58,
    0x4001ec4959cdaca7, 0x3ff734c14c07d42c,
    0xc012078810f0c20d, 0x3fee77a1aae63f56,
    0xc00b558d43462d89, 0x40100665b20ccba1,
    0x3fc851e4c324b8f8, 0xc0082894841b6896,
    0xc000003e90a48558, 0x3fe8064042af8670,
    0xbff06780104a54e6, 0xc007d167b60dfc4b,
    0xbfe57a034c9a89a0, 0xbfe01f7b8461713d,
    0x3fe8a124903b90fa, 0xc01106fef3776c68,
    0xc001b4e31d0d7bf1, 0x3fe2b19db127bf16,
    0x3fe3df4066f7a190, 0xbff999e51e2ad40c,
    0xbffc9c37b5485f02, 0x4005a107949e13e7,
    0x4009aa5763466635, 0xbfefd99bc70170d3,
    0x3ff425f7229d2291, 0xbfde659463802f4c,
    0x4000fd6b353199b0, 0x3fb175557d5b6c20,
    0x3fcf4c74fd86f258, 0x3fb9f960496e2980,
    0xc004b30aa456d6a5, 0xc008ddbaf7325f4f,
    0x3ff3f775b6c55b75, 0x400ba640aaa54f7a,
    0x4011d0d17a60d1dd, 0xc00733af9e92051f,
    0x3ff6492eb5306836, 0x3fc8c5faa8a85a68,
    0x4001d122743f6690, 0xbfe9fa395c030990,
    0xc003983c809fc8dd, 0xbff044974ab72da8,
    0x40136b17faa6bde8, 0x40021c5152c0e688,
    0x3fc35f6f869d79c8, 0xc0085187d1c455d4,
    0x3fe0dd6139234144, 0x3fd0084eccf2f888,
    0x400c2c8debe3e845, 0x3ff20bce91e84d76,
    0x400629f709693a14, 0x3ff090966fd5eb95,
    0xbff67ead6423be1e, 0xbfd6426624816890,
    0x3ffba046dbbd5e00, 0xbfdded7512b57474,
    0x3ff23ab1716c00e0, 0xbff796e7c92ca788,
    0x3fde3e87aff26c54, 0xbff89399cd17614b,
    0xbfe2506c6dd1c8e8, 0xbfe8e6ff003d8428,
    0xc0026dc4175ecb24, 0x3fc38aa9b0875778,
    0x3ffbc302f40718d8, 0xbfcbc7fda98b0518,
    0x3ffdae5f809541d2, 0x400a2c80a270b93a,
    0x400203e9b78bc463, 0x3ffcb56fe3a2c08e,
    0x4000ec7d34d33ed1, 0xc0008b0945c1b941,
    0xbfeb159791d5b967, 0x3fe2e2ccbf12aa71,
    0xbfe5e3c216dd74c0, 0xbffe33ab06c3ff09,
    0x400ae2e006e0ed58, 0x3fd4db7bcf74da58,
    0x3fe442a633217076, 0xbff1b1cd8eebe634,
    0x3fb1de3a0ec7c4d0, 0x40019a58e285c3c7,
    0x3fd62873dcf92060, 0x3fd4d6be6cd91b80,
    0xbfe7a0de9a1d8d9f, 0xc0081cfaa76d42b4,
    0x3fcb0a024d007068, 0x401119e8fbdb51b0,
    0x3ff6035956b10495, 0xc01c0feaf4116c78,
    0x4001cd1577374713, 0x400349a9a4593261,
    0x3fcd55207407949c, 0x4000c722821ff2f8,
    0xbff762ca65a370ce, 0x4009906b61aa3418,
    0xbff5931979854946, 0x3ff82d32c1d9a8ca,
    0x3fecd42f7d72d70e, 0xbfff1d50657b3db6,
    0x40051058768fe01b, 0x3fa0949a665c52c0,
    0x401049facb9376fd, 0xc00472696ef65a7d,
    0x4004c839c9b59ca1, 0xbfe2677715c07434,
    0x3ff8c2de9ee370c0, 0xbff8271673eb44c2,
    0xc00862979db84e4a, 0xbf98bf393e98c200,
    0x3fd0fd182bee47e6, 0xbfe3e5cdb5045f36,
    0x3ff1c6a5aa96a500, 0xbfe973270d2e9c28,
    0x3fc3b04ab3783508, 0x3ff52a7f41e5f02d,
    0x3ff4b9f2b0dd8a67, 0xc007054b9bda16ac,
    0xbff827c2531ad158, 0xbff4a78f0ac8e48f,
    0xc00e44a8d51efb45, 0x40055ea42df96197,
    0x40139d9db6fdac2a, 0xbfbb8b29700adf70,
    0x3ffda61c26da16dd, 0x3ff7a186901cfdc7,
    0xbff5120b3771982c, 0xc0016d7966af0ae3,
    0xc002cc41cfd288f4, 0xbffdedc47c776014,
    0x40034659308c3b3b, 0xbffd1ec3d07f32e4,
    0xc00c4dde13192e1d, 0xbff6767b9af47932,
    0x400e0f87663b7e21, 0xc008cf46d487bbeb,
    0xc005d93b595e0024, 0x40011236c61cb780,
    0xc005d134fd85d4d4, 0xbfe262c11105bd30,
    0x400d2409afeee851, 0x400a1fd2d4f45086,
    0xbfd77e5414c6ec94, 0xc0026f31f0e6b73a,
    0x3ff0db4947efb2a3, 0x3fe6761cd52536a9,
    0x3ff7b7f05fbe55f4, 0x3ff196c9c60c0ac3,
    0x4002d3fb410b530e, 0x3ff38d2509063514,
    0xc0055a966aa89953, 0x400c6ee47ac4be1c,
    0xc00102fbb3dc7ef1, 0x3ff956897c2eb7d8,
    0xbfab0ad357fe2a30, 0xc01109b336d3cea9,
    0xbff7808e0b271292, 0x3ff74924e2850aa6,
    0xbfa072afc3310720, 0x3fe82091616dac58,
    0xbfb497e5d56a4c60, 0x3ffab09d92be7752,
    0x400b851b8e03a9a9, 0x3fc346f5e7517bb8,
    0xbff2e17d051a1f61, 0x3ffe62cb769316ba,
    0xc003c19b256268f1, 0x4002a68d84faa5e9,
    0xc00676d9d4808baf, 0xbfd429bf434c12f8,
    0x3ffb78fd4fd05d1c, 0xbff9a5b1fcb87afa,
    0xbfd939c35ece0f22, 0x3fd009e6eae38a8c,
    0x3ff89ffa4c606dd9, 0x4013d16b6713d48c,
    0x400ad23d0da8e9a0, 0x3fd2c0f24de2999b,
    0xc00eacca18b1f946, 0x401cb3f76653546c,
    0xc0064c20b4eb2914, 0xbff310a69a4b9926,
    0xbfd28bad68b3eb58, 0x400169b18a5f1f68,
    0x3fffdb802a878e76, 0x3fe47e9f456718ce,
    0xbff1dec04d653a30, 0xbff4fa7e0464d7ff,
    0xbff0860213141d3a, 0xc0033ab3f37f2696,
    0xbff7917477aa6422, 0x3fde8864be906072,
    0xbfe202b31792c978, 0x4015c45a1234bfca,
    0xbfce803889e6bd58, 0xc00023e4a5a68246,
    0x3fe6ff0618bd5b3a, 0xbfdb886301e9c6aa,
    0xc0117dfb68c7ad5c, 0x3ff40b0c968a12b7,
    0xbfdaf48f04f9b0c8, 0xc00087d2a23ec694,
    0x3fe464b0b4abf042, 0xbff52afafe8a300e,
    0xc0064e0a31e58ab8, 0xc01139baecb97609,
    0xc002dea269d9546a, 0x3fe9f329105eaec6,
    0xbfe597d376ab2874, 0xbfc7c6b87f4ae730,
    0x400cd9cf4a1af2ae, 0xbfffd43aede8f656,
    0xbfe82379553e5a0c, 0xbfeb1532cee7a282,
    0xc00542a0d64b4780, 0xbffceab106dc55f2,
    0x3ff9377be59688c2, 0x40034eabd15c7519,
    0xbff8be7a0fb0668a, 0xc01a33cbb284aa52,
    0x3fdbbaa2be45873c, 0xbfb49c3a0a852960,
    0x3ffce58e739df18a, 0xbff2db4a74840f6a,
    0xbfb1ad5c032fa790, 0x401a65bb4bc37df3,
    0xc0058198b429af76, 0xbff01bc5b5fe1362,
    0x3fee57bcf42efd6a, 0x3fe35b39c6833db5,
    0xbfbdc13c66a27fe0, 0x3fe27e9866d049e4,
    0x4015a77c2f4de324, 0x3ff1a480f359c419,
    0x3ffb2f929ac4fb03, 0x3ff255a7bd691900,
    0xbfe1e809b11a6d50, 0x3fcb20c12c6811e8,
    0xc0047e30072bad8f, 0xbfe0df4b86f92eca,
    0xbfccb93a9fe51828, 0xc0047ef3d3b92001,
    0xbfedcbb16b591404, 0x4010903859f42b2b,
    0xbff6024fa203b87a, 0x3feae14d9e4bddca,
    0x3fd086d2dacdf66f, 0xbff8bcd59f0e44c0,
    0xbfd81ad424841daa, 0xbfd488f5d214f0f0,
    0xbfe08370d197784f, 0x4003958a28460bb1,
    0xbfd81e60032beff2, 0x4006630a4660c58f,
    0xc00859f443c1c599, 0x3fa9761e152e4060,
    0xbfbe48b3a52d602c, 0xbfefbba3fd1361ce,
    0x40009d6d1e11b0a0, 0x3fe34baa6246128a,
    0x3fe39a7a5e10f215, 0x400ecaea6c795df1,
    0xc010caa47d741ab2, 0xc0156ece9d480f12,
    0xc0105c9e3012824d, 0xbfe1401da0e60664,
    0xbfd6275bf0fddef8, 0xbff30f79fbdcf4be,
    0xc00a951e599655ab, 0x3fe5bd69f9af865f,
    0xc00d1e70a94247da, 0x3fe0237564a10bc6,
    0x3fb1609cc3621c10, 0x4002ebe086c20e82,
    0x3fd0116fa94e6554, 0x3fd7e41921cd13d8,
    0x3ff8a424cabb2b05, 0x4001474b4a174437,
    0x3fcf578594d94b20, 0x3ff65e9d3bca9bc0,
    0xbffb3aead3983144, 0xc00d10274783c08e,
    0x401490ab34dce537, 0xbfcf83a37414f81c,
    0x4019ba2497b495d4, 0xbfde08d7b8f7c6f4,
    0xbff82c5c8006304d, 0xc010d98778d5a7f6,
    0xbfb7b3da970dd900, 0xc0053a28139331eb,
    0xc01919eab419af76, 0x409661fb2a20188e,
    0xbff667c113066cab, 0x40052da18cbbc66b,
    0xbf970620ebe33400, 0xbffccc15a3014997,
    0x3ff82c5cf1ea2ec5, 0x3ff7742baf0389a6,
    0xbfeaf2e6e18c6475, 0x3ff62e4cf62c5e3d,
    0x3fd432b88e428f10, 0xbfb8cfa376b60780,
    0x3ff3ce0c8c5603ac, 0x4003824c5a0df244,
    0xc007d39597144be6, 0xc0047f8aed5d8d36,
    0xbfb30c5ea6ecfa84, 0x3fff0ae7344def04,
    0xbfff21f27d4286da, 0x3ff0e6b1944b97d8,
    0xbff9ab71aa7d522e, 0x40112fd495366a82,
    0x400354f90c57b279, 0x3fe3db3f1b5dd694,
    0x400a3e5e2f08ed0e, 0x3ffb26a9b1206c9c,
    0xc004fb8dff907b02, 0xbfe0436e8ca190b4,
    0xc002cb094baccc25, 0xbff6fd40832654a2,
    0xbfd677c74515b308, 0x3ff6246c1e19771a,
    0xc0079faf6b00488f, 0xbffa91da96c45f1e,
    0x4010ab0b641a2dac, 0xc01082d1d7136abb,
    0x3fdd2aa433b31110, 0x3feed3813acdd23e,
    0x40008c5cb7ee9892, 0xc004215e91b4351f,
    0x3ff493be9fae43ad, 0xbfe59cdb71a3a38e,
    0x4004a26ef1ecc99b, 0x3fe6db287c73e4e0,
    0xbffc09c8a950931a, 0x3ff48980e18786ac,
    0xbffb18c878e34ce6, 0x3fd93d3082f9706a,
    0x3ff245959d6eb9a3, 0xc001019598c15286,
    0x3fee2fb7884d88c4, 0x3ff6c09b61468566,
    0xc0020f86fb73ca32, 0xbfe2331dab1ab14c,
    0xbff0f7442566040c, 0xbfe99dabb46a9f6e,
    0x400536bb4ef8d326, 0x3ffd35bf733ee599,
    0x3fe6442302706fee, 0xbfd73bb4b02b2b58,
    0xc000940b3ce262e5, 0x3fef8e0581a87ae0,
    0xbffa86fadf12ead8, 0xc01033b0902e2ea6,
    0xc003dc498b4236bb, 0xbfed0f5f6dc2eb95,
    0x3fc762b984bf7ff2, 0xbfe185f2bf5ce1c1,
    0xbffe64d75ed937d6, 0x3ffa28642743d31a,
    0x3fccb82d0115ac80, 0xbfe9e2758aca3f0a,
    0x4004ec28b5ee2fbe, 0xbffd34531b004324,
    0xbfea8228afc0b5c6, 0x400187e6a2e8dfb0,
    0xc00996b0110daf9a, 0xc0018731c34539f5,
    0xc00d7e5aa3bedf9d, 0xbfee11a637a7ac0f,
    0x4000a14fe8853fcc, 0x3ff3ad1cfeb98c53,
    0x3ff3120df4787b3a, 0xbff3127edd538bca,
    0xc00eb310f6e863ee, 0x40044f1ba8212c6c,
    0xc003fbe8eb5bf5f0, 0x3fd1fbd2532e25c4,
    0x400863c522b50147, 0xc006a89753df3571,
    0x400303af85ac93b0, 0xbff63e7557c84a1c,
    0xc00422748020565a, 0x3ffc1838a8e58b39,
    0xc00173c4d2b78841, 0x3fe436a5ab95ca71,
    0x3fff4c3a7853b904, 0xbfeebdd73fa3e81a,
    0xc003802135422f5e, 0x3ff1c4414098ebf6,
    0xc0048ca6c03d964a, 0x4016d788452946da,
    0x3fc583a312b170bc, 0xbff729fdc6551fa4,
    0xbffae439faa4f37c, 0x3ff77cb39389f18e,
    0xc005b1eb592e1166, 0xbfdf4ad0f5b30502,
    0x400f7f6b404d2e09, 0x3ff3e3f4b43bc5a5,
    0x400220d1a7597092, 0x4011eab947799dc2,
    0x401114e2729f5bcd, 0xc009edc52e62e886,
    0xbff756a5c9f56718, 0x3ff67715be989c97,
    0x40120eb2b60b84a4, 0xbfe80b62efd8484b,
    0x3feebcafcfac4c19, 0x400c1e5827fcfc80,
    0x4007520f20063033, 0x400875738e1f4a5d,
    0xbfd53edc8a4f9662, 0x3fb543949c284a54,
    0xc007daea678c94da, 0x4017e2ec0b579ef2,
    0x3fd48ca43836cdfe, 0xc010569cd8519a52,
    0x3ff7aa4c2dacdcc4, 0xbfd94ed03c7674c0,
    0x4002163c1d0ba58a, 0xc002932df46a1fe4,
    0x400ec7d9f4a58aee, 0xbff40bac22fc8bf4,
    0x3fbb72ae501768c0, 0x3fa5a4668b08ce80,
    0x400223bc4eced590, 0xbfe7abdd8bab8417,
    0xbff7172eb4c1b863, 0x3fd184e8f10e0a1e,
    0x4013ba52f2759e8e, 0x3fef0e74b61b5d0e,
    0xc0059386ee3e5175, 0xc001972d598050a2,
    0x400ce896356c6e27, 0x3fe79db602068920,
    0x40004fd6014307b6, 0xbff1e0e94d91e12e,
    0x3fd329e99c1c310d, 0xbff21b7bd784e8ee,
    0x3ff149101ab5822e, 0x400b05da19002d0e,
    0xc007a88cddead8fc, 0x4003bfdb0e32966a,
    0x4016b848363f8597, 0x3fd398041fb2b80a,
    0x3fe1ee78b1002019, 0xbffdab260a0093d9,
    0x400382b2f78fb892, 0xbfe3091f19751985,
    0x3fee0a0b1d55160b, 0x3ffd86272c649f7a,
    0x400713e860e403b2, 0xc010e7d6fd4fcf20,
    0xbfd9b05d07317058, 0x400ece112f035cba,
    0xbfb56aa70c9cb690, 0xbfcbff6bb9050edc,
    0xbfa8f22d26cc89c0, 0x3fe76e454bc3e7e0,
    0xbfe4748210e3ed68, 0x3fe3c3a8260a6f0c,
    0x401531cb819f042d, 0xc0092585225d6b14,
    0xc0116885c305654e, 0x3ffdbecea85b07fe,
    0x401838f5395db66d, 0xbfcd791d54e40e48,
    0x4012da56652b1350, 0x3fc9301004fb9a90,
    0x3fda50f337e6def7, 0x4018bbac0b652bfe,
    0xc003b554018fc653, 0x4010f5902c34ed19,
    0x3fb20bcc6346a018, 0xbfce6f3ed18afab0,
    0xbff39d96cb473946, 0x3fb5f6e2c3912910,
    0x400787b200071c25, 0xbff3b1b1653f464a,
    0xbff986bfd16be2ac, 0x3ff9842ee0869abe,
    0xc00cca00ec70cf0a, 0x400570bc5b5e1ff4,
    0x3ff0a45992346476, 0xbfd0602474e0aada,
    0xbfe564270f4575ba, 0x3fd92e54a9eb2c38,
    0x400f1a732fd96706, 0xbfc0948f8908f640,
    0xc0139d2bd1d00bee, 0xc00078d228b9a0ff,
    0x3fd4c18221cf258c, 0xbfb184d0c821e338,
    0x3fee543059b8e7df, 0xc003babe8d4026d3,
    0xc004f5fc71d49035, 0x401305bcba58ae96,
    0xbff05c98c207de15, 0xbff6ccf51a5416ba,
    0xbff265f5cec8b31b, 0x3fff1e74141b45f0,
    0xc00aec64c1f04fb9, 0xbffd1db85af74fc4,
    0x40060450a350950a, 0x3fda759feea4ac88,
    0x4000a410987099a6, 0x401e15a0a5eb8024,
    0x3febfa5a2db11d24, 0xbff5a917d9f69096,
    0xbfd444a58350c637, 0x401410f6a460f74e,
    0xbfd745baac75db10, 0x400faaeab7342ff2,
    0x3ffc802d75a4a2ea, 0xc0131f5476797329,
    0x4005efe18d21816d, 0xc00625e3ab091011,
    0x3ff2f5b15cc53d11, 0x3fb04e7a70b2aa54,
    0x4003d53f51f04be8, 0x400f01110f270cb6,
    0x400351a03f40924e, 0x400aee6729daa78a,
    0xbfc30fac231e81c8, 0xc0013392ffd3a751,
    0xbfff2525854a84a6, 0xbffc0cbfeb723830,
    0xbfd500ced242f378, 0x3fd8f15678719d82,
    0x4015304ce2378331, 0x4008fcc2a3ca008a,
    0x4002a7ba133df790, 0x3fe8464943a3877c,
    0x3fe7126ce18bf2f4, 0xc002b621114be155,
    0xbfa805c31bfb3b58, 0x4000c06786ed0bc1,
    0xbfe2d39ac8d9d81a, 0xbffe58793b62e5a4,
    0xc013d86639f5d05e, 0x400f49f78e37a236,
    0xc00b569b53235506, 0x400ab2958d3717bf,
    0xc00816f72bf3cc41, 0xc000a40692ca09c2,
    0xbfe02558c9d6d654, 0x3ff04bafa49bbdde,
    0xbfff077bdf40eca8, 0x400846065bc2281a,
    0xbff27562e3422df2, 0x3fea4243310610ec,
    0x400cb42b52eb98d9, 0xbfcdf0feba3225b0,
    0xc0099c610cf85cb7, 0xc0112e1f53912815,
    0xc000b676501e6301, 0xbff5cf09bc5899d6,
    0xc00b678d88a0b55c, 0xc004db708accaed5,
    0x3ff4cc0ccf10431c, 0x3ff11f4ccb29c6ce,
    0xc01e0869e000ace1, 0x40036538bf8f7250,
    0x3ff216755b966801, 0xc0019a9932435eee,
    0x3fef5647ed6da74c, 0x3ff77aee1cc0edac,
    0xbffed74d9efdbaac, 0x3fff8ffdadf187cc,
    0xbfee7aa68385aa12, 0x4007e012500c940f,
    0x3ff787b3659ee5f4, 0xbfe60ea0010ae000,
    0x3fe1de3a61f62cf2, 0x400dddf3c644cc08,
    0xbff3cc3b9dbd026a, 0x3ff2412e4903a504,
    0xbfe5fd7e4e9bac36, 0x3fe0a421afe8f70e,
    0xbffb066a9371c231, 0x3ff5aaad6bf45e29,
    0x3fe424baf72ba561, 0x3fce7bae9c6821d8,
    0x4006f2769779ba1e, 0x3fef90333dcaa03e,
    0xbfe2a6ee626bc0e7, 0x3ff4fb2300401559,
    0x40118f59528c76fa, 0xbfe56114f502712f,
    0xbfddbf8fda2e7ea8, 0x3ff50cc80f81a664,
    0xbfae923612b4b630, 0x3ff9c6951ff15ffe,
    0xbffa43d237aba7d2, 0xbff7104c2095e5c6,
    0x3ff538d4c7c7cec4, 0x3ff100ee79ec1535,
    0x3fe4bb764baf9136, 0x3fc9f07caaca8c10,
    0x40045a21edd91470, 0x3ff6114ef81a26fc,
    0xbfcc5d44b6306152, 0xbff1b886a9994dd3,
    0xc004ca7ae5e1a744, 0xbfcc8cd169be09f0,
    0x4001837c36350449, 0x4009268290ff8f5a,
    0x3fea5264739d20ae, 0x3fe2483b01cedae2,
    0x401512718f65c33e, 0x4003b142cd53da50,
    0xbfe2a7ece143ff5e, 0x3feebcbf1ba848c8,
    0x3ff5c8def951af19, 0xc00443cfb41c5d4a,
    0x3ffa0fc5111db996, 0xc000cf717ee37f5b,
    0xbff510985b91afbe, 0x400d457b73ec156a,
    0x4004fa4b8b8603de, 0x3ff5edc9af040e51,
    0xbfbc307a1c5c3280, 0x3ff233628887f62c,
    0xbfd960fb093f9a5c, 0xc00579a8936af0c0,
    0xbfe7a1de064b8755, 0xc00c9a00a486b9d4,
    0x3ffcb3709c7442f6, 0x3fe1027889a4020d,
    0xc01cc983103bef84, 0x40168b87e27645e0,
    0xc005afd77186fb63, 0xc006569ef49e7dbc,
    0xc00461582c32415a, 0xbff55c529976534b,
    0xbfebf110d405b67e, 0xbfb874eb51d93a90,
    0xc00585ae0fda3586, 0xbff196284dc0db78,
    0xbffb65945b7d0316, 0x400f5218ef536082,
    0x3ffcae02e0a319c5, 0x3feb319bd368c1a6,
    0xbffcf49f3acb8ed8, 0xbff4aedc898f0a7e,
    0xbfe59fcdeb84e927, 0xbfc65ac63dd9d1a8,
    0x400eae9903517f20, 0x40077de9b802e616,
    0x3fedf771399ae096, 0xbfecd890c79f3eea,
    0x3fbca838cbbbacd0, 0x400d437e15f5fed4,
    0x3ff06d5854182dea, 0xc00467c6bbe21981,
    0xbff79413bd969c20, 0x40118ce764e98de0,
    0xc003a3c08eaca30d, 0xbfec10febc7b8d78,
    0x3ff040048edb5b8b, 0x3fefa80b38f76cc3,
    0xc004a21e9c6228e5, 0x4002c061c8463c95,
    0xbff26eb1b435ae1e, 0xbfef6e7bbeef97b5,
    0xbfff314570f6e354, 0xc01c43f667cb5033,
    0xc0068d8592e06dc0, 0xc001298279c76878,
    0x3ff5aeff64aeabca, 0xc0166cbef49a8288,
    0x3ff0193a2a1f8b13, 0x40165f4b53e5dae0,
    0x3ff75cb43afed7ba, 0x3feb0e2b9b2b162c,
    0xbff768bd50902f24, 0x3ff19d2adb1e73b8,
    0xbfd7334389913260, 0x40023fd1402c8474,
    0xc008c0a500d5d957, 0x3fde7256bc35bc32,
    0xc0132100c2fc1474, 0x3ffebc43439a4b82,
    0x3ffe067df256cd34, 0x3fd56d3807e83896,
    0x400163c392fc2106, 0xc00a5f7234e25064,
    0x4001aac6d88f5421, 0x4007d186e42e8e16,
    0xc00948fe4ac992ee, 0xbfee150ffd53fcab,
    0x4006c6d541ea2422, 0xc0019ef3ee33a74e,
    0x4012970709eaf494, 0x3fcec7668947bdd0,
    0xbff672a9979abc06, 0xbff8c2c1e4920a70,
    0xbff3f615b41eee3b, 0x400175b590291939,
    0x3ffb572488ec83e2, 0x3fcae67480d2e8d0,
    0x3ff161c4429f0b7a, 0x3ff771e24cf01826,
    0xc0045dbbf1118b15, 0xbfed3801f7c2fcda,
    0x3fee967c7b736290, 0x3ff25d86bd513d90,
    0x3fd6ae4574fd37ec, 0x4001f8f933b6f42f,
    0x40019fbe5a27d97a, 0xbff21806386e1604,
    0x3ff3e2ac063a1483, 0x3ff06ce0c929d07a,
    0x3fe53a8d8b545713, 0x3fda281be61e6d32,
    0xbfb04ae53a485de0, 0x3fd617ec18109952,
    0xbff083eba55bdfc4, 0xc00badf35fccfd0e,
    0xbfd096c4106b0e26, 0x3fe73620c85e73de,
    0x3ff4dddb45053f62, 0x3fc98b6915cddf88,
    0xc006e97e7627bb45, 0x3ffe3d510570ec28,
    0xbfc7953077b01ba8, 0xc0007a9a6bf77c2a,
    0x3ff1f9babd06bf1c, 0xbfdbec1c338d1eae,
    0xc0146917bed300a4, 0x400dbbd176e9b41e,
    0xbfdeab590407deff, 0x3ff8af4b853a05d8,
    0x4003f6c32f3f480d, 0x40074276711e5ca1,
    0xbfe0c30c7e2e90bf, 0xbfdc4d968b06856c,
    0x40089ffaf0d82914, 0xbff671d6b7dbc454,
    0x3fffecdf1891c9c0, 0xbfbd45beecac7650,
    0xbff430f0ccc1b64b, 0x400ca68d5afcaf63,
    0xc00fcea59ee8477c, 0xc00c93e75315157d,
    0x3fd3806540b6f438, 0x4007af8403ebebce,
    0xc010804a05b8322a, 0x3fccbf74b51894a0,
    0xbfc018e36fdad89c, 0x3ffbaecce77a2846,
    0xbff8b9953841a64c, 0xbfe6722805c4a956,
    0x3ff1210290983664, 0x3fd7b49413c6f59c,
    0xbfe5fa152ffd0cce, 0xc00edc4b4423e58c,
    0xc00460210516627a, 0xc00433f7f8497968,
    0x3fff637e0f5f0d22, 0x3ff3c87d638250c8,
    0xbff8fb97f14a95da, 0xbffa43301fa7ece8,
    0x3fdafda654104721, 0x4009810b27f2beba,
    0x3fb145ac2d7a4e58, 0xbfe619b06d4105c6,
    0x3fe81560acbb8dd4, 0xbff88265534a9964,
    0x3fd13513fd36bec4, 0x3fe91f50fbd67c4c,
    0x3ffefd038fb80ca3, 0xc003c86d9ae79a15,
    0x400e2661b4ee0ef8, 0xc00d7a05c44c1989,
    0x3ff6171463035401, 0xbff49774e2810cae,
    0xc00ee154a1a426e2, 0xbff9fac2c1af387b,
    0xc01932bfae2afdb7, 0x3fd661a77052955c,
    0x3fb083ecff18f540, 0xbff9c4ab9f0b24d1,
    0x3fee82b92a063f8e, 0xbfdd832c97b91cb8,
    0xbff2d375fec62d54, 0x40001add489cccc6,
    0xbfdb4d8cced35dce, 0xc0104b78a050e872,
    0xbfe43d612952f183, 0xbff5d80e7a93b2cf,
    0x3ffaa8aaa94adcc6, 0xc00db96b387fa8fc,
    0x3fd5b17fbd2f8c3c, 0x400ed0ebe9a8ef55,
    0x400a5665149c395f, 0x4007851c3d1fe802,
    0x400f63ac68726f0d, 0xbfefd9996bd00f9c,
    0x40115c4058d0a323, 0xbfed52e1fbb837da,
    0x3fe632d4fc7b3b06, 0x3ff3edd26227f674,
    0x400987d6b33ec3d0, 0xbfe7cc75dd5a5ee6,
    0x4006072dd3d9f63a, 0x3fe1c2460698e3b2,
    0xbffeeef5d0d7dbfa, 0x4005a2edefa883c2,
    0x400a3e90f776265d, 0xbff96eba3e881bee,
    0x3fda20510826517c, 0xbff2cd7010816bfe,
    0xbff5a91534307d21, 0x3fda2e1d8e4a33dc,
    0x3ff25e2994f8707c, 0x4013e9fd65d749c7,
    0xc00a8f81204da6ed, 0xbff208ffd2cd1844,
    0xbfd4fd21f182da54, 0xbfd5020125a91a08,
    0x40007425bff897ac, 0xc002f50756c04e0c,
    0xc007837237b32ec4, 0x3ffe2002c5ae3391,
    0x3ff0edaec9868248, 0xbff9d370f36cc2b8,
    0x401174130a2e1de2, 0xc0013886729a856c,
    0x400382861797880e, 0xbffe5b28af20ef82,
    0x4014bd40ca6634fa, 0xbfd787f6cfbc6f4e,
    0x40086c69cb14220a, 0x3ff27815d25eead2,
    0x3ffbde638a8f5bf4, 0x40053536ed13a040,
    0xbfce397a1d7a70d0, 0x400f89d780cf8564,
    0xc006e7d0fe40bcf1, 0x3ff3e45d04e0c9f0,
    0xc002ee0d305ae738, 0xbfff41491d5324b8,
    0xbf856ad75baa9600, 0x3fe2fee6d2306986,
    0xc0033f727d14b9c1, 0xbffdf4096c7dc9ba,
    0x3fb963dc507e7c40, 0xbff50eed791014df,
    0xc000b8cc4eb47fac, 0xbfe02cbc8de8fdd4,
    0x3fea8ae38da8b633, 0xbfc718b86d2b6a90,
    0x3fd75afe261531ce, 0x3ffac2b9bdb6e852,
    0xbfd6c1227868081c, 0xbfe10ab582f6a876,
    0x40037814ba734e6c, 0xbf5893cede09ea00,
    0x3fe19f115878b35a, 0x3fe0cbc3e4e767da,
    0x3ffabee05eb778dd, 0xbffbb07717abc27c,
    0x3fe4c929b2eb978e, 0xbffe38a037126a64,
    0xc004da65d3cd0128, 0xbffa20a00bd9db9a,
    0xbfdd08b14c046dfd, 0x4000c0ed043fda44,
    0xc00544aaff5bb369, 0x3ff5cebde63e2162,
    0x3ff3293bf5c19ace, 0xc009aae2a5d8d0c3,
    0x3fddab266bc783f4, 0xbfea0aa8eb683726,
    0x3fca0b59bdc1f4c0, 0x400e16016cab8bef,
    0x3fe5c7293815dd1b, 0xbfb5cea3210e75b0,
    0x3fe246b844588a62, 0xbff3d8d420f6014c,
    0x3ff6d2535dc31681, 0xbff9a4d6e6186376,
    0x40013e58b3ea190d, 0xc010cbaac646a555,
    0x3fd17b981a1389f4, 0xbfef2229a5f9f975,
    0x3fa90fc7514eb4a0, 0x3ff6e62dbf0c6574,
    0xc01312cd5fb42d1a, 0x3fc656614f41feb8,
    0xc005416af2609a00, 0xbff938d6c8bf60b6,
    0xbfd170821accdfa4, 0x400c0e45dd45aa07,
    0x3fe08586f78cd69a, 0xc0008cc2daf75915,
    0xbfff5909432fbc62, 0xbfa50bc485c20ac0,
    0xc0014dbd72faa607, 0xbffa6d5dd1cb503c,
    0xc0078e43a65d70ef, 0xbfff38a25b01b86e,
    0xbff42029dd34ef24, 0xbfdf2262b7e342bc,
    0xc00ad62dc706c3a8, 0x3fd425f4e9a51e1c,
    0x3ff582a7d9904ef6, 0xbfd97eaae0dfe138,
    0x3fed00903aef4bdb, 0xbfe6f77dc0efddac,
    0x3ffa29fab7c953fc, 0xc0060014b45f1bd4,
    0x3ff8315f8c838e53, 0xc009900e232011ba,
    0x4000914f865da3f2, 0x40118920eb7f416f,
    0x3faf297a5d9aade0, 0x4005466054e3332e,
    0xbf9f655f1f162720, 0xbfdc282df2c9cb14,
    0xbfe9186b45e8f3e6, 0x4004521f33a27d10,
    0xc00dbc5bdd6456b7, 0xc001f27a8b39b6a8,
    0x3fd342d1a3b8565a, 0x3fff12182425dc03,
    0x4008eae9b8d90e57, 0x3fd65ee0a22ef8bc,
    0xc00a9b5e6a523c62, 0xc00bd9eff45fc758,
    0xc0064c461c4ade89, 0xc000be43b0968e48,
    0xc002536f9cb5e0e0, 0x3ff13925d0cd126c,
    0x3ffa4d02df810288, 0xc0043cce6b000f26,
    0x40075957b79a24d3, 0xc00446d17f8a4ee8,
    0xbff97ff4b9268f14, 0xbfa2cba1c9768ae0,
    0xbfcc20d4efcc83e4, 0xbfff6c1a3ddce4df,
    0xbfe31d221cb951a4, 0x3fe74cb78cce5b56,
    0x40035c1b6a2727da, 0xc001381fd583d025,
    0x3ff8abb723b784ca, 0x400b6bcfdfe28961,
    0xbff4c85643a39e60, 0xc0165ff1ef85264a,
    0xbff04b24605c7ba8, 0xbf68941b8e789e00,
    0x400d229d295945ba, 0xc00092dd570b3713,
    0x3ff155efa90a7bec, 0xbffcb9eb52102dbe,
    0xbfbe24c7b4cd2bf0, 0xc01143970dc6155c,
    0x3fe231cdee7967f0, 0x4001cdee2953eeb8,
    0xbffd9428d27106b6, 0xbff6d995228a2904,
    0xbff45b4ab46f2962, 0xbfeaca7eed9712ac,
    0xc009df948c2274c3, 0x4003e192ef6d3e80,
    0x3fdbdaa3db77a59e, 0x400155408e75ff0d,
    0x3ff48df5f20e438f, 0x3ffe7e7988b987a7,
    0x3fa0c83f077dc3e0, 0x3fefe81d4bd171b4,
    0xbfa6716316c233c0, 0xc009a57928524f00,
    0xc00b45ed9535b8fb, 0xbf8513297e953880,
    0x3ff4674b595e74fc, 0x3ff6330a65e82818,
    0x3ff13622e83cd2ed, 0xc000d8acb828c448,
    0xbff43c68d741e69a, 0x3fe9ece15a072a80,
    0xc003d58ffb8a1d54, 0x3ff08ab2ccb9d7fc,
    0xbfc8d651586d1650, 0x3fe0c258e4918548,
    0x4017d1d3c9da926f, 0x3fd68562fc8a6ca4,
    0xbffff76994602c48, 0xbffce79f21d1c278,
    0x3ff1d7f9f4d073e9, 0x400bf5a065c7da8a,
    0x3ffed5cec9a041f0, 0xbfdfe59187d51e06,
    0xbff50e0efafba13e, 0xbfff2c6f8d10873e,
    0xbff57ffa50a2644b, 0x3ff2ca1dfe7d7fbf,
    0x400865cfcd9f1b5e, 0x400212e16f70eba1,
    0x3fe71e5389b562aa, 0x3ff8e28b06290f31,
    0xbfbd1f93907c2de0, 0xbfea293398d7c54d,
    0xc00c4f27dd02ee34, 0xc005190e75a6b935,
    0x3fe1154226cd1ef1, 0xbfc63ee85d50d866,
    0xbff2d521c0e6bcc7, 0xbfe095dd52a80477,
    0x400ee37288fea35d, 0x3ff1573c40aa8ad4,
    0xbfc510d37533d5ae, 0xc003684d7743b02a,
    0x3fed990e9cb274b3, 0x3ffa600dfc18c755,
    0x3fe5d2b2f1bfa6ee, 0x3fd53a709faa0b8e,
    0x3f97ab573a2d1740, 0x3fec5d32e5a6bdfc,
    0x3fecac3b97363f04, 0xbff8d67b8283db04,
    0x3fef247f10d3fcc0, 0xbfd3bb8d209db440,
    0xbfcdc89b7a4f3c70, 0xbff8b0be8f24f364,
    0x4000b32ef97af6f2, 0x3fb25f1038a4e770,
    0x3ff57c9cb36dc930, 0xbfc442e80ca3f4f0,
    0xbff09d6290e6f2e0, 0x3ff6615dd5248f74,
    0x3fcde4882a539b9a, 0x40057c7470cbd982,
    0x400eb20c90427f2a, 0x3ff57b14a1abe213,
    0xc010da54ee8c093e, 0x4015d4fe86cc583c,
    0xbfe7366c6d947dae, 0xc003d4ee617a1981,
    0x40134a206c38150f, 0x40044e2e5df35980,
    0xbff34ca3372619e6, 0x3ff0254389815214,
    0xbff342a20a4d7992, 0xc004a12d79c0408a,
    0x40089d0334444430, 0x4001a0efe9a27bd7,
    0xc011707ca2566f18, 0xbfda6b9773609828,
    0x3fe54d28ed25edda, 0x4005b3ae78920628,
    0x3fb0ad66baca88f0, 0x3ff34c5a3c17239d,
    0x3ff569391917bece, 0x3fb7551b1aa95cd0,
    0x3fec46fbc7c6eeb8, 0x400f9739a51fcf9c,
    0xc0011c153e610282, 0x3fe8fc4737cce8da,
    0xbfe15b0776c90bee, 0xbfffc55346697a63,
    0xbffca9bdc194952e, 0xc0130444a0e411b1,
    0x3fb60fcee2b74470, 0xbfee15fc32908eca,
    0xbfc98c60e1083918, 0xbfdc21a362805e3a,
    0xbfe01414a89a9350, 0xc002eb16781f0b6a,
    0xbff46b2273b05c99, 0xc00d0ef40d5712f6,
    0xc00f5fb2f5d48b98, 0x3fe341d9d480ce65,
    0x3fe2dd6b39f9c99e, 0x3fe271cb29968b42,
    0x3ffeaa29cdf081a8, 0x400f4486fa56a8e2,
    0xc0043ad540cb7242, 0xc010234a1db10abe,
    0xc0023993c60fd50c, 0x3ff0c52e01d19276,
    0xc001b7b377c6d93a, 0xc00888d957360262,
    0xbffe163614251f2f, 0xbfe5ae4a262c2e37,
    0x3fffe9970df9bff9, 0xc015e17bfcbee669,
    0xbfe1fa1ea69f0fd3, 0xc000685dc1913f75,
    0x4007d2f07d73c643, 0x3fc4a27fe8bef0c0,
    0x3ff710936ee41b05, 0x400b7dea643edb42,
    0xc00e71e3ab1ac6ef, 0xc001f4377581ce40,
    0xc0039a2fef64c234, 0xbfe9043bf7584c48,
    0xbffbaf1a18b82e6c, 0xbfdff6235a1c9d14,
    0xc0074e15fc1070b3, 0xc01b7b0a8416904c,
    0x3ffc798b080e903a, 0x4017b5af7f4add39,
    0xbfd0caa6d1553fd0, 0x3ff219a0e58a4aae,
    0xc009d2ac85c7bee9, 0xc008e8486d47d15f,
    0x3ff562fc2ead129d, 0xc00139898086f3c1,
    0xc00758b15fd94a24, 0xc00176fa55cfe73e,
    0xc006f3c509a2bdef, 0x3fd3d360eba2a089,
    0xbfe0aca4d8a16bd8, 0xbfca9ec8f24cf69c,
    0xc00119a6db0b987d, 0x3ff99e0539a9fc08,
    0x3ffd429c8e81d2ba, 0xbffd369d16b8dd8c,
    0x3fc38adac9644468, 0x3ff29f7d17b52113,
    0xbff32e34ef2e2a26, 0xc00051b65ca6bce8,
    0xc005bbd8950da913, 0xbff906a905312301,
    0x3fca959d60f06e30, 0x3fff4bd0d58db400,
    0x400898a00785071f, 0x3ff60ce4a63304f6,
    0xbfff3d57c3bc6233, 0xc015d4fb17677b12,
    0x3feae7f2cb24d3a6, 0xc0079acce85984b8,
    0x3fb449e7dc53d520, 0xc00e8b09e49fd89a,
    0x3ff1675489940138, 0xbfc94df69b62addc,
    0xbff76741785b883a, 0xbfe53278fb7a8570,
    0xbff464b7ef2538a6, 0x40049cd89364dfef,
    0x3feeb65ec522d85a, 0xbfd933feda9bf317,
    0xc00261dbaa3f6088, 0xc002d897d3334a1c,
    0x40091b09c1ed98ca, 0xc002c4c63a2b3c7b,
    0xc013d55fbf93efd9, 0x40110c4fa3d35ac0,
    0x3ffac0a970d14d27, 0xc007dfd6cee7f49e,
    0x3ff7a9977442880a, 0xbff566a6a6c620fa,
    0xbfe7fe11567070d8, 0xc005e07f7f427c82,
    0xc003fac79b59ba8c, 0x3fe0c8e461cbad4b,
    0x3fee1bf14e774064, 0x3feb376a4b1be882,
    0x3fc495cb241c7600, 0x4002a64793942d97,
    0x400328a776b8bcf4, 0xc00585b56f9d457f,
    0x3fe49b3e9f492218, 0x3ffb78e133ef69ba,
    0x3ff85340bc330f88, 0xbfe4fe1d840ea17c,
    0x3fe0c42b9df6d89f, 0x40088ea854cff530,
    0xc00cba2e8a70fe98, 0xbfd67f068ecd1fae,
    0x400e420acc04d88a, 0xbfaef16261c18e00,
    0xbff91d1e890078da, 0xbfcefea70c7a858c,
    0xc018170930d5f952, 0x3ff511d1e4b4b172,
    0x4004cfcbd7bc2486, 0xc008886d979b7140,
    0xbffe21244ce7391c, 0xbfee739ed63f9054,
    0xbfec4f8a72f1d88e, 0x3ff006f4f1cd0b5f,
    0x400aa061c9c32345, 0x3fbf9ce6ed0ae760,
    0xc0048296915c02ee, 0x3fcac6c6cde7bc78,
    0x4000d40c65697d8a, 0x4002744d80601e42,
    0xbff5400031be02d1, 0x3ffb486bdb12a179,
    0xbfea6869a1d48991, 0xc000c3cc7e25e284,
    0xc005f99b6a69bbd8, 0xbfe34dc28d46f586,
    0x3ffd016bf066f5ad, 0x400da3e5faed69cc,
    0x3feadf7c1e850ea5, 0xbfe66e695ac5db33,
    0xbfde12463e5da004, 0x3ff21ad7a75c3899,
    0xbff268558ce83e35, 0xbff2bd8aa081be1c,
    0xc0064d092737435e, 0x3fc774991f1ed668,
    0x401212651ab79ec2, 0xbfd0046224943dbe,
    0x400b06c87be07f52, 0xbff01f8364d8b71b,
    0x3fc19fed702dd608, 0x3fe306ae2bed9912,
    0x3ff22998a35366ec, 0xbffa734923ecf652,
    0xbff47e73c5dc46eb, 0xbfb4450a300705c0,
    0xbfd3bab104e637cc, 0xbfe5835efedfbe8a,
    0xc0055950a6325ce0, 0xc006cec1d22cebb7,
    0xc00af94cb8c9689d, 0x3fdaebd89dbabdec,
    0xc005a649dc88b323, 0xbfd0aab8e0423d40,
    0xbfa2a94df0c658e0, 0xc00585f64e41fe1e,
    0x3fea19eed58c1e48, 0x3fe89e1cfbe35b78,
    0x3fd494f85d2e6d47, 0x3ffa477344657a73,
    0xbfdb797fd2bd0737, 0xbfdb8a2049509f60,
    0xc0003f5be65a8f12, 0xbff8a137ce3f59ea,
    0x3fb55ef77f7fd430, 0xbfec4e2f1e343e66,
    0x400714999595f501, 0x3ffe8547903991a2,
    0x3fd27b194896da72, 0xbfc8fe622d479ba8,
    0xbfe61c92debedc3e, 0x3ff348a8f2a93a51,
    0xbfe01d9588a4ed3e, 0x4004b7dff1219645,
    0x3ffee25a10af4045, 0xc00acd2596a0f27f,
    0xc0065017e8448b20, 0xc005f6cbb9364165,
    0x3fe73d56f1c24016, 0xbfff57c9050c9206,
    0x3ff41266dd35052c, 0x3fee9e3eeae43211,
    0xbfcbf94f28da55e8, 0x3fd7d5d94a468aac,
    0x3ff31c54e4d50b6a, 0x40055b34833cb5f8,
    0x3ffd87cb94ce14db, 0x40023930d9fe687a,
    0xbfe884a035c45bff, 0x3ffeb3d5a846aeb0,
    0x40101665cab474cc, 0xbfed88502f726a9a,
    0x400c91e76575ea24, 0x401004442d8284e8,
    0x40017c20d9f03d66, 0xc003147b7e83e8ba,
    0xbff25e4e5f334512, 0x40064d8f2552c9d0,
    0x3fff6c00e2a18027, 0x3fc4c7972061c0a0,
    0x3feb224f45ba1822, 0xbfe6fdea5caa6e60,
    0x3fff4dc7c348effa, 0xc0055b3b77c6dbd3,
    0xbfea85301f761a00, 0x400583a260efce54,
    0x3fe3b946b6763090, 0xbff4b1b25d3bab1c,
    0xbff21632dd8dc070, 0xbff0c9c1680dde04,
    0xc00221b8ef5e3a81, 0x3fe6a925742f8da0,
    0x3fd3c34c67c31f88, 0xc00b3fe39a93f250,
    0xc012777ef521054e, 0xbfe6c66fd53ce588,
    0x3ff1b79f361f42a8, 0xbfb391effef54eed,
    0x400b1b02c8987460, 0x4010d041c874d5aa,
    0x40054f4cb2ee20d2, 0xc00a2bbe9ca4d954,
    0xbfebb919e5f42b99, 0x3fea1ed645854b92,
    0xc00e6eebb57f15b4, 0x3fd5b55fd0ad636c,
    0x3ff86e96d1b9de17, 0x40046f09757d79ae,
    0xbfde019e83458cf8, 0x3febe7e26cd694e2,
    0xc00525ff8ec1db21, 0xbfd0972b464b1cbc,
    0xbff6a9923068a899, 0x3ff97cb6c2ff438f,
    0xc007f1de29fb936c, 0x4004b423a087d056,
    0x3ffaaa37eb686be0, 0x3fed04f1d3dc3e48,
    0xbfe0a84a0db6bb12, 0x3ff358360c005e2f,
    0xc006a1903c67d7be, 0xc00b901cafc70602
    };

static const uint64_t in_cfft_step_16[32] = {
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0
    };

static const uint64_t in_cifft_step_16[32] = {
    0x401ccccccccccccd, 0x0,
    0xbfecccccccccccce, 0x4012193232087380,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff58d16655168be,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe33e58f33f2d65,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fc6ea2a16b312d0,
    0x0, 0x0,
    0xbfecccccccccccce, 0xbfc6ea2a16b312d0,
    0x0, 0x0,
    0xbfecccccccccccce, 0xbfe33e58f33f2d67,
    0x0, 0x0,
    0xbfeccccccccccccc, 0xbff58d16655168be,
    0x0, 0x0,
    0xbfecccccccccccca, 0xc012193232087380
    };

static const uint64_t ref_cfft_step_16[32] = {
    0x401ccccccccccccd, 0x0,
    0xbfecccccccccccce, 0x4012193232087380,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff58d16655168be,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe33e58f33f2d65,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fc6ea2a16b312d0,
    0x0, 0x0,
    0xbfecccccccccccce, 0xbfc6ea2a16b312d0,
    0x0, 0x0,
    0xbfecccccccccccce, 0xbfe33e58f33f2d67,
    0x0, 0x0,
    0xbfeccccccccccccc, 0xbff58d16655168be,
    0x0, 0x0,
    0xbfecccccccccccca, 0xc012193232087380
    };

static const uint64_t in_cfft_step_32[64] = {
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0
    };

static const uint64_t in_cifft_step_32[64] = {
    0x402ccccccccccccd, 0x0,
    0xbfecccccccccccd2, 0x40224694b6d1e46c,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x4007bc3751b89a62,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ffaf0c4f1b61206,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3ff18be432937075,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3fe7a2b359cd5779,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fdec9aff9db926e,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fd1790763398d14,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3fb6b14264b87580,
    0x0, 0x0,
    0xbfeccccccccccccc, 0xbfb6b14264b875c0,
    0x0, 0x0,
    0xbfecccccccccccce, 0xbfd1790763398d10,
    0x0, 0x0,
    0xbfeccccccccccccb, 0xbfdec9aff9db9280,
    0x0, 0x0,
    0xbfecccccccccccca, 0xbfe7a2b359cd5782,
    0x0, 0x0,
    0xbfecccccccccccc5, 0xbff18be432937070,
    0x0, 0x0,
    0xbfeccccccccccccc, 0xbffaf0c4f1b61204,
    0x0, 0x0,
    0xbfecccccccccccc7, 0xc007bc3751b89a60,
    0x0, 0x0,
    0xbfecccccccccccc0, 0xc0224694b6d1e46b
    };

static const uint64_t ref_cfft_step_32[64] = {
    0x402ccccccccccccd, 0x0,
    0xbfecccccccccccd2, 0x40224694b6d1e46c,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x4007bc3751b89a62,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ffaf0c4f1b61206,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3ff18be432937075,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3fe7a2b359cd5779,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fdec9aff9db926e,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fd1790763398d14,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3fb6b14264b87580,
    0x0, 0x0,
    0xbfeccccccccccccc, 0xbfb6b14264b875c0,
    0x0, 0x0,
    0xbfecccccccccccce, 0xbfd1790763398d10,
    0x0, 0x0,
    0xbfeccccccccccccb, 0xbfdec9aff9db9280,
    0x0, 0x0,
    0xbfecccccccccccca, 0xbfe7a2b359cd5782,
    0x0, 0x0,
    0xbfecccccccccccc5, 0xbff18be432937070,
    0x0, 0x0,
    0xbfeccccccccccccc, 0xbffaf0c4f1b61204,
    0x0, 0x0,
    0xbfecccccccccccc7, 0xc007bc3751b89a60,
    0x0, 0x0,
    0xbfecccccccccccc0, 0xc0224694b6d1e46b
    };

static const uint64_t in_cfft_step_64[128] = {
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0
    };

static const uint64_t in_cifft_step_64[128] = {
    0x403ccccccccccccd, 0x0,
    0xbfecccccccccccd4, 0x403251e65569b233,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x401844ec2b5fac28,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x400cbe7785552992,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x40041f661e754926,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3ffe723ce98fc58d,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3ff80663076302d6,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3ff36a88f5ef7ae7,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fefc6a199472fb2,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fea1a5100191248,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe55c0a88a568ba,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fe1431614ea7329,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fdb3e263f09b848,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fd49c0f5f0ec59c,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3fccdb2939f178d8,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fc1169b34e238d0,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x3fa6a33d2f9b8f00,
    0x0, 0x0,
    0xbfeccccccccccccc, 0xbfa6a33d2f9b9000,
    0x0, 0x0,
    0xbfecccccccccccd2, 0xbfc1169b34e238d0,
    0x0, 0x0,
    0xbfecccccccccccc9, 0xbfccdb2939f178d8,
    0x0, 0x0,
    0xbfeccccccccccccc, 0xbfd49c0f5f0ec5bc,
    0x0, 0x0,
    0xbfecccccccccccd1, 0xbfdb3e263f09b844,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xbfe1431614ea7331,
    0x0, 0x0,
    0xbfecccccccccccc9, 0xbfe55c0a88a568be,
    0x0, 0x0,
    0xbfecccccccccccd2, 0xbfea1a5100191242,
    0x0, 0x0,
    0xbfeccccccccccccc, 0xbfefc6a199472fa8,
    0x0, 0x0,
    0xbfecccccccccccc8, 0xbff36a88f5ef7ae9,
    0x0, 0x0,
    0xbfeccccccccccccc, 0xbff80663076302d4,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xbffe723ce98fc588,
    0x0, 0x0,
    0xbfecccccccccccc9, 0xc0041f661e754926,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xc00cbe7785552994,
    0x0, 0x0,
    0xbfecccccccccccc8, 0xc01844ec2b5fac26,
    0x0, 0x0,
    0xbfecccccccccccac, 0xc03251e65569b234
    };

static const uint64_t ref_cfft_step_64[128] = {
    0x403ccccccccccccd, 0x0,
    0xbfecccccccccccd4, 0x403251e65569b233,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x401844ec2b5fac28,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x400cbe7785552992,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x40041f661e754926,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3ffe723ce98fc58d,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3ff80663076302d6,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3ff36a88f5ef7ae7,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fefc6a199472fb2,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fea1a5100191248,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe55c0a88a568ba,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fe1431614ea7329,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fdb3e263f09b848,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fd49c0f5f0ec59c,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3fccdb2939f178d8,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fc1169b34e238d0,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x3fa6a33d2f9b8f00,
    0x0, 0x0,
    0xbfeccccccccccccc, 0xbfa6a33d2f9b9000,
    0x0, 0x0,
    0xbfecccccccccccd2, 0xbfc1169b34e238d0,
    0x0, 0x0,
    0xbfecccccccccccc9, 0xbfccdb2939f178d8,
    0x0, 0x0,
    0xbfeccccccccccccc, 0xbfd49c0f5f0ec5bc,
    0x0, 0x0,
    0xbfecccccccccccd1, 0xbfdb3e263f09b844,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xbfe1431614ea7331,
    0x0, 0x0,
    0xbfecccccccccccc9, 0xbfe55c0a88a568be,
    0x0, 0x0,
    0xbfecccccccccccd2, 0xbfea1a5100191242,
    0x0, 0x0,
    0xbfeccccccccccccc, 0xbfefc6a199472fa8,
    0x0, 0x0,
    0xbfecccccccccccc8, 0xbff36a88f5ef7ae9,
    0x0, 0x0,
    0xbfeccccccccccccc, 0xbff80663076302d4,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xbffe723ce98fc588,
    0x0, 0x0,
    0xbfecccccccccccc9, 0xc0041f661e754926,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xc00cbe7785552994,
    0x0, 0x0,
    0xbfecccccccccccc8, 0xc01844ec2b5fac26,
    0x0, 0x0,
    0xbfecccccccccccac, 0xc03251e65569b234
    };

static const uint64_t in_cfft_step_128[256] = {
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0
    };

static const uint64_t in_cifft_step_128[256] = {
    0x404ccccccccccccd, 0x0,
    0xbfeccccccccccce0, 0x404254ba4d4dccca,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x402866e9c69d778d,
    0x0, 0x0,
    0xbfecccccccccccda, 0x401d3022a95b27ca,
    0x0, 0x0,
    0xbfecccccccccccde, 0x4014bf4fc9bb14bc,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x401008123832cdbc,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x400a04780e45d71c,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x4005cb722f4c178b,
    0x0, 0x0,
    0xbfecccccccccccda, 0x4002aa50fa649f4a,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x40003e314c63f4cd,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3ffc9b9e74f48760,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ff96b67f3ac7610,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x3ff6bd76358b76c6,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3ff472492bef49cd,
    0x0, 0x0,
    0xbfecccccccccccd9, 0x3ff273af5fdf55b7,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3ff0b18fe45133f2,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fee3fe4ddc206a0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3feb6b7d37ce94c0,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe8d7d22e314b7c,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3fe679ca22c5ef00,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fe44882f8cfcdf0,
    0x0, 0x0,
    0xbfecccccccccccd9, 0x3fe23cc62c0d3535,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fe050a3bd8405b9,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fdcfe4fb13c7a82,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fd9884662bb5d1e,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd638016e083b76,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fd30749cae4e540,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fcfe1506e2d4490,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fc9de786d5d5ec8,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc3fd3568b97280,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fbc6ac9017f8e00,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fb0fecd9ee5b280,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3f969fbf20d4b800,
    0x0, 0x0,
    0xbfecccccccccccce, 0xbf969fbf20d4b400,
    0x0, 0x0,
    0xbfecccccccccccce, 0xbfb0fecd9ee5b280,
    0x0, 0x0,
    0xbfecccccccccccd2, 0xbfbc6ac9017f8dc0,
    0x0, 0x0,
    0xbfecccccccccccd6, 0xbfc3fd3568b97230,
    0x0, 0x0,
    0xbfecccccccccccd8, 0xbfc9de786d5d5ec0,
    0x0, 0x0,
    0xbfeccccccccccccf, 0xbfcfe1506e2d44b8,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xbfd30749cae4e528,
    0x0, 0x0,
    0xbfecccccccccccd6, 0xbfd638016e083b72,
    0x0, 0x0,
    0xbfecccccccccccc9, 0xbfd9884662bb5d72,
    0x0, 0x0,
    0xbfecccccccccccca, 0xbfdcfe4fb13c7a90,
    0x0, 0x0,
    0xbfecccccccccccd0, 0xbfe050a3bd8405c8,
    0x0, 0x0,
    0xbfecccccccccccc7, 0xbfe23cc62c0d3558,
    0x0, 0x0,
    0xbfecccccccccccc3, 0xbfe44882f8cfcdf6,
    0x0, 0x0,
    0xbfecccccccccccc5, 0xbfe679ca22c5ef0e,
    0x0, 0x0,
    0xbfecccccccccccc5, 0xbfe8d7d22e314b74,
    0x0, 0x0,
    0xbfeccccccccccce8, 0xbfeb6b7d37ce94c0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xbfee3fe4ddc206a0,
    0x0, 0x0,
    0xbfecccccccccccce, 0xbff0b18fe45133ee,
    0x0, 0x0,
    0xbfecccccccccccbc, 0xbff273af5fdf55b4,
    0x0, 0x0,
    0xbfecccccccccccce, 0xbff472492bef49cc,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xbff6bd76358b76c0,
    0x0, 0x0,
    0xbfeccccccccccccf, 0xbff96b67f3ac760e,
    0x0, 0x0,
    0xbfecccccccccccd0, 0xbffc9b9e74f4875a,
    0x0, 0x0,
    0xbfecccccccccccd1, 0xc0003e314c63f4cf,
    0x0, 0x0,
    0xbfecccccccccccce, 0xc002aa50fa649f45,
    0x0, 0x0,
    0xbfecccccccccccca, 0xc005cb722f4c178e,
    0x0, 0x0,
    0xbfeccccccccccccc, 0xc00a04780e45d71f,
    0x0, 0x0,
    0xbfecccccccccccd4, 0xc01008123832cdbe,
    0x0, 0x0,
    0xbfecccccccccccbe, 0xc014bf4fc9bb14b8,
    0x0, 0x0,
    0xbfecccccccccccc3, 0xc01d3022a95b27c8,
    0x0, 0x0,
    0xbfecccccccccccb1, 0xc02866e9c69d778c,
    0x0, 0x0,
    0xbfeccccccccccc80, 0xc04254ba4d4dccc9
    };

static const uint64_t ref_cfft_step_128[256] = {
    0x404ccccccccccccd, 0x0,
    0xbfeccccccccccce0, 0x404254ba4d4dccca,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x402866e9c69d778d,
    0x0, 0x0,
    0xbfecccccccccccda, 0x401d3022a95b27ca,
    0x0, 0x0,
    0xbfecccccccccccde, 0x4014bf4fc9bb14bc,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x401008123832cdbc,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x400a04780e45d71c,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x4005cb722f4c178b,
    0x0, 0x0,
    0xbfecccccccccccda, 0x4002aa50fa649f4a,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x40003e314c63f4cd,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3ffc9b9e74f48760,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ff96b67f3ac7610,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x3ff6bd76358b76c6,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3ff472492bef49cd,
    0x0, 0x0,
    0xbfecccccccccccd9, 0x3ff273af5fdf55b7,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3ff0b18fe45133f2,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fee3fe4ddc206a0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3feb6b7d37ce94c0,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe8d7d22e314b7c,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3fe679ca22c5ef00,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fe44882f8cfcdf0,
    0x0, 0x0,
    0xbfecccccccccccd9, 0x3fe23cc62c0d3535,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fe050a3bd8405b9,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fdcfe4fb13c7a82,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fd9884662bb5d1e,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd638016e083b76,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fd30749cae4e540,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fcfe1506e2d4490,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fc9de786d5d5ec8,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc3fd3568b97280,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fbc6ac9017f8e00,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fb0fecd9ee5b280,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3f969fbf20d4b800,
    0x0, 0x0,
    0xbfecccccccccccce, 0xbf969fbf20d4b400,
    0x0, 0x0,
    0xbfecccccccccccce, 0xbfb0fecd9ee5b280,
    0x0, 0x0,
    0xbfecccccccccccd2, 0xbfbc6ac9017f8dc0,
    0x0, 0x0,
    0xbfecccccccccccd6, 0xbfc3fd3568b97230,
    0x0, 0x0,
    0xbfecccccccccccd8, 0xbfc9de786d5d5ec0,
    0x0, 0x0,
    0xbfeccccccccccccf, 0xbfcfe1506e2d44b8,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xbfd30749cae4e528,
    0x0, 0x0,
    0xbfecccccccccccd6, 0xbfd638016e083b72,
    0x0, 0x0,
    0xbfecccccccccccc9, 0xbfd9884662bb5d72,
    0x0, 0x0,
    0xbfecccccccccccca, 0xbfdcfe4fb13c7a90,
    0x0, 0x0,
    0xbfecccccccccccd0, 0xbfe050a3bd8405c8,
    0x0, 0x0,
    0xbfecccccccccccc7, 0xbfe23cc62c0d3558,
    0x0, 0x0,
    0xbfecccccccccccc3, 0xbfe44882f8cfcdf6,
    0x0, 0x0,
    0xbfecccccccccccc5, 0xbfe679ca22c5ef0e,
    0x0, 0x0,
    0xbfecccccccccccc5, 0xbfe8d7d22e314b74,
    0x0, 0x0,
    0xbfeccccccccccce8, 0xbfeb6b7d37ce94c0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xbfee3fe4ddc206a0,
    0x0, 0x0,
    0xbfecccccccccccce, 0xbff0b18fe45133ee,
    0x0, 0x0,
    0xbfecccccccccccbc, 0xbff273af5fdf55b4,
    0x0, 0x0,
    0xbfecccccccccccce, 0xbff472492bef49cc,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xbff6bd76358b76c0,
    0x0, 0x0,
    0xbfeccccccccccccf, 0xbff96b67f3ac760e,
    0x0, 0x0,
    0xbfecccccccccccd0, 0xbffc9b9e74f4875a,
    0x0, 0x0,
    0xbfecccccccccccd1, 0xc0003e314c63f4cf,
    0x0, 0x0,
    0xbfecccccccccccce, 0xc002aa50fa649f45,
    0x0, 0x0,
    0xbfecccccccccccca, 0xc005cb722f4c178e,
    0x0, 0x0,
    0xbfeccccccccccccc, 0xc00a04780e45d71f,
    0x0, 0x0,
    0xbfecccccccccccd4, 0xc01008123832cdbe,
    0x0, 0x0,
    0xbfecccccccccccbe, 0xc014bf4fc9bb14b8,
    0x0, 0x0,
    0xbfecccccccccccc3, 0xc01d3022a95b27c8,
    0x0, 0x0,
    0xbfecccccccccccb1, 0xc02866e9c69d778c,
    0x0, 0x0,
    0xbfeccccccccccc80, 0xc04254ba4d4dccc9
    };

static const uint64_t in_cfft_step_256[512] = {
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0
    };

static const uint64_t in_cifft_step_256[512] = {
    0x405ccccccccccccd, 0x0,
    0xbfeccccccccccce0, 0x4052556f444c538a,
    0x0, 0x0,
    0xbfeccccccccccce1, 0x40386f6639ecffb8,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x402d4c71fd1460af,
    0x0, 0x0,
    0xbfecccccccccccdc, 0x4024e6fe4f285982,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x40203b2c44fd1a24,
    0x0, 0x0,
    0xbfecccccccccccdc, 0x401a81a322d4ff2e,
    0x0, 0x0,
    0xbfecccccccccccd7, 0x40165fbb942eb8f3,
    0x0, 0x0,
    0xbfecccccccccccee, 0x401355e79ffbb104,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x4011014bfa560d2a,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x400e5159adcb89e8,
    0x0, 0x0,
    0xbfecccccccccccca, 0x400b5137b880c652,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x4008d3fad768aefc,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x4006ba35789a9a02,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x4004edc99aa463d0,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x40035eb2dfdfdf44,
    0x0, 0x0,
    0xbfecccccccccccf7, 0x4002010ecbb5f916,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x4000cbdc2f4a60fc,
    0x0, 0x0,
    0xbfeccccccccccce9, 0x3fff7050fec91ede,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3ffd8102fa1da67b,
    0x0, 0x0,
    0xbfecccccccccccdb, 0x3ffbc1255464e0b9,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ffa29bf2b66d23c,
    0x0, 0x0,
    0xbfecccccccccccdb, 0x3ff8b5233638a610,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff75ea6114c1dfd,
    0x0, 0x0,
    0xbfecccccccccccdb, 0x3ff622675b951998,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ff4fd284472249f,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ff3ec2bd9ce6eab,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff2ed1e8317f200,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3ff1fe02d5773624,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3ff11d2270f55b1b,
    0x0, 0x0,
    0xbfeccccccccccce1, 0x3ff04901f171b52e,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x3fef00ae7d262624,
    0x0, 0x0,
    0xbfecccccccccccdc, 0x3fed8403679a1b50,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fec1a07758cd00f,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3feac0fb156cb964,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fe97751a28386f0,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fe83baa2d8dfd0e,
    0x0, 0x0,
    0xbfecccccccccccda, 0x3fe70cc9743fbcde,
    0x0, 0x0,
    0xbfecccccccccccba, 0x3fe5e994cf1941ae,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe4d10de8b7f83a,
    0x0, 0x0,
    0xbfecccccccccccb2, 0x3fe3c24f1adc0dea,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fe2bc88546ed5c0,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x3fe1befc715bc16c,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fe0c8fef169409d,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x3fdfb3e3fd667410,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fdde2896e544b16,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3fdc1ce35d5eddb4,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x3fda61fb425f4da8,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3fd8b0ec9b18b514,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd708e2e6a7ade8,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3fd56917dc755ab0,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fd3d0d1d62870b4,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fd23f62655a8190,
    0x0, 0x0,
    0xbfecccccccccccd7, 0x3fd0b4250ee9c1a4,
    0x0, 0x0,
    0xbfecccccccccccbf, 0x3fce5cfc4d450420,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x3fcb5bb38d7028b8,
    0x0, 0x0,
    0xbfecccccccccccdb, 0x3fc86355be430b70,
    0x0, 0x0,
    0xbfecccccccccccd7, 0x3fc572d4b2e23710,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x3fc2892c9c542cc0,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fbf4ac523ca03a0,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3fb98d06652633c0,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3fb3d742b6a264c0,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fac4f53b938e500,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3fa0f8e69f105400,
    0x0, 0x0,
    0xbfecccccccccccdc, 0x3f869edfd0d7f000,
    0x0, 0x0,
    0xbfecccccccccccce, 0xbf869edfd0d80000,
    0x0, 0x0,
    0xbfecccccccccccc5, 0xbfa0f8e69f105400,
    0x0, 0x0,
    0xbfecccccccccccd9, 0xbfac4f53b938e600,
    0x0, 0x0,
    0xbfecccccccccccc4, 0xbfb3d742b6a26480,
    0x0, 0x0,
    0xbfecccccccccccd0, 0xbfb98d0665263400,
    0x0, 0x0,
    0xbfecccccccccccc8, 0xbfbf4ac523ca0300,
    0x0, 0x0,
    0xbfecccccccccccd7, 0xbfc2892c9c542ce0,
    0x0, 0x0,
    0xbfecccccccccccee, 0xbfc572d4b2e237b0,
    0x0, 0x0,
    0xbfecccccccccccc6, 0xbfc86355be430b50,
    0x0, 0x0,
    0xbfecccccccccccc6, 0xbfcb5bb38d702880,
    0x0, 0x0,
    0xbfeccccccccccccc, 0xbfce5cfc4d450480,
    0x0, 0x0,
    0xbfeccccccccccce1, 0xbfd0b4250ee9c1d0,
    0x0, 0x0,
    0xbfecccccccccccc4, 0xbfd23f62655a81d0,
    0x0, 0x0,
    0xbfeccccccccccce0, 0xbfd3d0d1d62870a0,
    0x0, 0x0,
    0xbfecccccccccccd3, 0xbfd56917dc755ac4,
    0x0, 0x0,
    0xbfecccccccccccdd, 0xbfd708e2e6a7ae64,
    0x0, 0x0,
    0xbfecccccccccccc9, 0xbfd8b0ec9b18b530,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xbfda61fb425f4d96,
    0x0, 0x0,
    0xbfecccccccccccc3, 0xbfdc1ce35d5edde4,
    0x0, 0x0,
    0xbfecccccccccccbb, 0xbfdde2896e544b3c,
    0x0, 0x0,
    0xbfecccccccccccd6, 0xbfdfb3e3fd6673ee,
    0x0, 0x0,
    0xbfecccccccccccd1, 0xbfe0c8fef16940a9,
    0x0, 0x0,
    0xbfecccccccccccca, 0xbfe1befc715bc176,
    0x0, 0x0,
    0xbfecccccccccccb3, 0xbfe2bc88546ed5cb,
    0x0, 0x0,
    0xbfeccccccccccccf, 0xbfe3c24f1adc0dc6,
    0x0, 0x0,
    0xbfecccccccccccd8, 0xbfe4d10de8b7f82a,
    0x0, 0x0,
    0xbfecccccccccccc8, 0xbfe5e994cf1941b7,
    0x0, 0x0,
    0xbfeccccccccccce3, 0xbfe70cc9743fbcb8,
    0x0, 0x0,
    0xbfecccccccccccc3, 0xbfe83baa2d8dfd16,
    0x0, 0x0,
    0xbfeccccccccccce1, 0xbfe97751a28386fc,
    0x0, 0x0,
    0xbfecccccccccccd8, 0xbfeac0fb156cb964,
    0x0, 0x0,
    0xbfecccccccccccdc, 0xbfec1a07758cd050,
    0x0, 0x0,
    0xbfecccccccccccd1, 0xbfed8403679a1b8f,
    0x0, 0x0,
    0xbfecccccccccccd1, 0xbfef00ae7d262614,
    0x0, 0x0,
    0xbfecccccccccccd0, 0xbff04901f171b530,
    0x0, 0x0,
    0xbfecccccccccccd8, 0xbff11d2270f55b1f,
    0x0, 0x0,
    0xbfecccccccccccd2, 0xbff1fe02d577361d,
    0x0, 0x0,
    0xbfecccccccccccc6, 0xbff2ed1e8317f207,
    0x0, 0x0,
    0xbfeccccccccccccb, 0xbff3ec2bd9ce6eb1,
    0x0, 0x0,
    0xbfecccccccccccba, 0xbff4fd28447224a7,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xbff622675b95198c,
    0x0, 0x0,
    0xbfeccccccccccccf, 0xbff75ea6114c1e02,
    0x0, 0x0,
    0xbfecccccccccccc2, 0xbff8b5233638a612,
    0x0, 0x0,
    0xbfecccccccccccca, 0xbffa29bf2b66d240,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xbffbc1255464e0ba,
    0x0, 0x0,
    0xbfecccccccccccdb, 0xbffd8102fa1da679,
    0x0, 0x0,
    0xbfecccccccccccd2, 0xbfff7050fec91eda,
    0x0, 0x0,
    0xbfecccccccccccb9, 0xc000cbdc2f4a60fc,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xc002010ecbb5f913,
    0x0, 0x0,
    0xbfecccccccccccbd, 0xc0035eb2dfdfdf46,
    0x0, 0x0,
    0xbfecccccccccccc7, 0xc004edc99aa463ce,
    0x0, 0x0,
    0xbfeccccccccccccc, 0xc006ba35789a9a05,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xc008d3fad768aef6,
    0x0, 0x0,
    0xbfecccccccccccc9, 0xc00b5137b880c650,
    0x0, 0x0,
    0xbfeccccccccccccc, 0xc00e5159adcb89ea,
    0x0, 0x0,
    0xbfecccccccccccdf, 0xc011014bfa560d2a,
    0x0, 0x0,
    0xbfecccccccccccbf, 0xc01355e79ffbb0fc,
    0x0, 0x0,
    0xbfecccccccccccbc, 0xc0165fbb942eb8f4,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xc01a81a322d4ff2c,
    0x0, 0x0,
    0xbfecccccccccccb9, 0xc0203b2c44fd1a24,
    0x0, 0x0,
    0xbfecccccccccccb9, 0xc024e6fe4f285982,
    0x0, 0x0,
    0xbfeccccccccccca1, 0xc02d4c71fd1460af,
    0x0, 0x0,
    0xbfeccccccccccc9c, 0xc0386f6639ecffb6,
    0x0, 0x0,
    0xbfeccccccccccc1c, 0xc052556f444c538a
    };

static const uint64_t ref_cfft_step_256[512] = {
    0x405ccccccccccccd, 0x0,
    0xbfeccccccccccce0, 0x4052556f444c538a,
    0x0, 0x0,
    0xbfeccccccccccce1, 0x40386f6639ecffb8,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x402d4c71fd1460af,
    0x0, 0x0,
    0xbfecccccccccccdc, 0x4024e6fe4f285982,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x40203b2c44fd1a24,
    0x0, 0x0,
    0xbfecccccccccccdc, 0x401a81a322d4ff2e,
    0x0, 0x0,
    0xbfecccccccccccd7, 0x40165fbb942eb8f3,
    0x0, 0x0,
    0xbfecccccccccccee, 0x401355e79ffbb104,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x4011014bfa560d2a,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x400e5159adcb89e8,
    0x0, 0x0,
    0xbfecccccccccccca, 0x400b5137b880c652,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x4008d3fad768aefc,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x4006ba35789a9a02,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x4004edc99aa463d0,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x40035eb2dfdfdf44,
    0x0, 0x0,
    0xbfecccccccccccf7, 0x4002010ecbb5f916,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x4000cbdc2f4a60fc,
    0x0, 0x0,
    0xbfeccccccccccce9, 0x3fff7050fec91ede,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3ffd8102fa1da67b,
    0x0, 0x0,
    0xbfecccccccccccdb, 0x3ffbc1255464e0b9,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ffa29bf2b66d23c,
    0x0, 0x0,
    0xbfecccccccccccdb, 0x3ff8b5233638a610,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff75ea6114c1dfd,
    0x0, 0x0,
    0xbfecccccccccccdb, 0x3ff622675b951998,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ff4fd284472249f,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ff3ec2bd9ce6eab,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff2ed1e8317f200,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3ff1fe02d5773624,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3ff11d2270f55b1b,
    0x0, 0x0,
    0xbfeccccccccccce1, 0x3ff04901f171b52e,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x3fef00ae7d262624,
    0x0, 0x0,
    0xbfecccccccccccdc, 0x3fed8403679a1b50,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fec1a07758cd00f,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3feac0fb156cb964,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fe97751a28386f0,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fe83baa2d8dfd0e,
    0x0, 0x0,
    0xbfecccccccccccda, 0x3fe70cc9743fbcde,
    0x0, 0x0,
    0xbfecccccccccccba, 0x3fe5e994cf1941ae,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe4d10de8b7f83a,
    0x0, 0x0,
    0xbfecccccccccccb2, 0x3fe3c24f1adc0dea,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fe2bc88546ed5c0,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x3fe1befc715bc16c,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fe0c8fef169409d,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x3fdfb3e3fd667410,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fdde2896e544b16,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3fdc1ce35d5eddb4,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x3fda61fb425f4da8,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3fd8b0ec9b18b514,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd708e2e6a7ade8,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3fd56917dc755ab0,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fd3d0d1d62870b4,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fd23f62655a8190,
    0x0, 0x0,
    0xbfecccccccccccd7, 0x3fd0b4250ee9c1a4,
    0x0, 0x0,
    0xbfecccccccccccbf, 0x3fce5cfc4d450420,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x3fcb5bb38d7028b8,
    0x0, 0x0,
    0xbfecccccccccccdb, 0x3fc86355be430b70,
    0x0, 0x0,
    0xbfecccccccccccd7, 0x3fc572d4b2e23710,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x3fc2892c9c542cc0,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fbf4ac523ca03a0,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3fb98d06652633c0,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3fb3d742b6a264c0,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fac4f53b938e500,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3fa0f8e69f105400,
    0x0, 0x0,
    0xbfecccccccccccdc, 0x3f869edfd0d7f000,
    0x0, 0x0,
    0xbfecccccccccccce, 0xbf869edfd0d80000,
    0x0, 0x0,
    0xbfecccccccccccc5, 0xbfa0f8e69f105400,
    0x0, 0x0,
    0xbfecccccccccccd9, 0xbfac4f53b938e600,
    0x0, 0x0,
    0xbfecccccccccccc4, 0xbfb3d742b6a26480,
    0x0, 0x0,
    0xbfecccccccccccd0, 0xbfb98d0665263400,
    0x0, 0x0,
    0xbfecccccccccccc8, 0xbfbf4ac523ca0300,
    0x0, 0x0,
    0xbfecccccccccccd7, 0xbfc2892c9c542ce0,
    0x0, 0x0,
    0xbfecccccccccccee, 0xbfc572d4b2e237b0,
    0x0, 0x0,
    0xbfecccccccccccc6, 0xbfc86355be430b50,
    0x0, 0x0,
    0xbfecccccccccccc6, 0xbfcb5bb38d702880,
    0x0, 0x0,
    0xbfeccccccccccccc, 0xbfce5cfc4d450480,
    0x0, 0x0,
    0xbfeccccccccccce1, 0xbfd0b4250ee9c1d0,
    0x0, 0x0,
    0xbfecccccccccccc4, 0xbfd23f62655a81d0,
    0x0, 0x0,
    0xbfeccccccccccce0, 0xbfd3d0d1d62870a0,
    0x0, 0x0,
    0xbfecccccccccccd3, 0xbfd56917dc755ac4,
    0x0, 0x0,
    0xbfecccccccccccdd, 0xbfd708e2e6a7ae64,
    0x0, 0x0,
    0xbfecccccccccccc9, 0xbfd8b0ec9b18b530,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xbfda61fb425f4d96,
    0x0, 0x0,
    0xbfecccccccccccc3, 0xbfdc1ce35d5edde4,
    0x0, 0x0,
    0xbfecccccccccccbb, 0xbfdde2896e544b3c,
    0x0, 0x0,
    0xbfecccccccccccd6, 0xbfdfb3e3fd6673ee,
    0x0, 0x0,
    0xbfecccccccccccd1, 0xbfe0c8fef16940a9,
    0x0, 0x0,
    0xbfecccccccccccca, 0xbfe1befc715bc176,
    0x0, 0x0,
    0xbfecccccccccccb3, 0xbfe2bc88546ed5cb,
    0x0, 0x0,
    0xbfeccccccccccccf, 0xbfe3c24f1adc0dc6,
    0x0, 0x0,
    0xbfecccccccccccd8, 0xbfe4d10de8b7f82a,
    0x0, 0x0,
    0xbfecccccccccccc8, 0xbfe5e994cf1941b7,
    0x0, 0x0,
    0xbfeccccccccccce3, 0xbfe70cc9743fbcb8,
    0x0, 0x0,
    0xbfecccccccccccc3, 0xbfe83baa2d8dfd16,
    0x0, 0x0,
    0xbfeccccccccccce1, 0xbfe97751a28386fc,
    0x0, 0x0,
    0xbfecccccccccccd8, 0xbfeac0fb156cb964,
    0x0, 0x0,
    0xbfecccccccccccdc, 0xbfec1a07758cd050,
    0x0, 0x0,
    0xbfecccccccccccd1, 0xbfed8403679a1b8f,
    0x0, 0x0,
    0xbfecccccccccccd1, 0xbfef00ae7d262614,
    0x0, 0x0,
    0xbfecccccccccccd0, 0xbff04901f171b530,
    0x0, 0x0,
    0xbfecccccccccccd8, 0xbff11d2270f55b1f,
    0x0, 0x0,
    0xbfecccccccccccd2, 0xbff1fe02d577361d,
    0x0, 0x0,
    0xbfecccccccccccc6, 0xbff2ed1e8317f207,
    0x0, 0x0,
    0xbfeccccccccccccb, 0xbff3ec2bd9ce6eb1,
    0x0, 0x0,
    0xbfecccccccccccba, 0xbff4fd28447224a7,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xbff622675b95198c,
    0x0, 0x0,
    0xbfeccccccccccccf, 0xbff75ea6114c1e02,
    0x0, 0x0,
    0xbfecccccccccccc2, 0xbff8b5233638a612,
    0x0, 0x0,
    0xbfecccccccccccca, 0xbffa29bf2b66d240,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xbffbc1255464e0ba,
    0x0, 0x0,
    0xbfecccccccccccdb, 0xbffd8102fa1da679,
    0x0, 0x0,
    0xbfecccccccccccd2, 0xbfff7050fec91eda,
    0x0, 0x0,
    0xbfecccccccccccb9, 0xc000cbdc2f4a60fc,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xc002010ecbb5f913,
    0x0, 0x0,
    0xbfecccccccccccbd, 0xc0035eb2dfdfdf46,
    0x0, 0x0,
    0xbfecccccccccccc7, 0xc004edc99aa463ce,
    0x0, 0x0,
    0xbfeccccccccccccc, 0xc006ba35789a9a05,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xc008d3fad768aef6,
    0x0, 0x0,
    0xbfecccccccccccc9, 0xc00b5137b880c650,
    0x0, 0x0,
    0xbfeccccccccccccc, 0xc00e5159adcb89ea,
    0x0, 0x0,
    0xbfecccccccccccdf, 0xc011014bfa560d2a,
    0x0, 0x0,
    0xbfecccccccccccbf, 0xc01355e79ffbb0fc,
    0x0, 0x0,
    0xbfecccccccccccbc, 0xc0165fbb942eb8f4,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xc01a81a322d4ff2c,
    0x0, 0x0,
    0xbfecccccccccccb9, 0xc0203b2c44fd1a24,
    0x0, 0x0,
    0xbfecccccccccccb9, 0xc024e6fe4f285982,
    0x0, 0x0,
    0xbfeccccccccccca1, 0xc02d4c71fd1460af,
    0x0, 0x0,
    0xbfeccccccccccc9c, 0xc0386f6639ecffb6,
    0x0, 0x0,
    0xbfeccccccccccc1c, 0xc052556f444c538a
    };

static const uint64_t in_cfft_step_512[1024] = {
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
 