static const q15_t in_cfft_noisy_16[32] = {
    0x0429, 0x0000, 0x3E35, 0x0000, 0x5056, 0x0000, 0x3C2A, 0x0000,
    0x04B9, 0x0000, 0xC540, 0x0000, 0x9B8E, 0x0000, 0xC41C, 0x0000,
    0x06D2, 0x0000, 0x3EEF, 0x0000, 0x5AFF, 0x0000, 0x3AC4, 0x0000,
    0x0151, 0x0000, 0xCC03, 0x0000, 0xA761, 0x0000, 0xBE03, 0x0000
    };

static const q15_t in_cifft_noisy_16[32] = {
    0x006C, 0x0000, 0xFFB0, 0x00F6, 0xFFEA, 0xD43B, 0xFF26, 0x00C5,
    0x022C, 0xFEAA, 0x006B, 0xFE5B, 0x00B4, 0x0148, 0x0016, 0xFF67,
    0xFF7D, 0x0000, 0x0016, 0x0099, 0x00B4, 0xFEB8, 0x006B, 0x01A5,
    0x022C, 0x0156, 0xFF26, 0xFF3B, 0xFFEA, 0x2BC5, 0xFFB0, 0xFF0A
    };

static const q15_t ref_cfft_noisy_16[32] = {
    0x006C, 0x0000, 0xFFB0, 0x00F6, 0xFFEA, 0xD43B, 0xFF26, 0x00C5,
    0x022C, 0xFEAA, 0x006B, 0xFE5B, 0x00B4, 0x0148, 0x0016, 0xFF67,
    0xFF7D, 0x0000, 0x0016, 0x0099, 0x00B4, 0xFEB8, 0x006B, 0x01A5,
    0x022C, 0x0156, 0xFF26, 0xFF3B, 0xFFEA, 0x2BC5, 0xFFB0, 0xFF0A
    };

static const q15_t in_cfft_noisy_32[64] = {
    0xF447, 0x0000, 0x3C86, 0x0000, 0x595F, 0x0000, 0x3A03, 0x0000,
    0xF8F1, 0x0000, 0xC1AA, 0x0000, 0xA35F, 0x0000, 0xBC0A, 0x0000,
    0xFBCD, 0x0000, 0x3DC0, 0x0000, 0x4B4C, 0x0000, 0x3C91, 0x0000,
    0xFE0E, 0x0000, 0xB49C, 0x0000, 0xB1E6, 0x0000, 0xBCE5, 0x0000,
    0xF67D, 0x0000, 0x46CC, 0x0000, 0x5339, 0x0000, 0x3E4E, 0x0000,
    0x0510, 0x0000, 0xC2C1, 0x0000, 0xAC83, 0x0000, 0xBC49, 0x0000,
    0xFF17, 0x0000, 0x4363, 0x0000, 0x5CD0, 0x0000, 0x3D8F, 0x0000,
    0xFFB0, 0x0000, 0xC0D8, 0x0000, 0xA193, 0x0000, 0xB854, 0x0000
    };

static const q15_t in_cifft_noisy_32[64] = {
    0xFDBE, 0x0000, 0xFF4A, 0x0177, 0xFF73, 0xFF87, 0xFF46, 0xFFB3,
    0xFF6F, 0xD37D, 0x002A, 0xFF1E, 0xFFCA, 0xFFFE, 0xFF7F, 0xFFD7,
    0xFF4B, 0xFF0D, 0x004A, 0xFFA7, 0xFED8, 0x0004, 0x00E3, 0x0175,
    0xFF2F, 0xFE93, 0x0053, 0x013B, 0xFFE7, 0xFF96, 0xFFB9, 0xFFA6,
    0xFFD9, 0x0000, 0xFFB9, 0x005A, 0xFFE7, 0x006A, 0x0053, 0xFEC5,
    0xFF2F, 0x016D, 0x00E3, 0xFE8B, 0xFED8, 0xFFFC, 0x004A, 0x0059,
    0xFF4B, 0x00F3, 0xFF7F, 0x0029, 0xFFCA, 0x0002, 0x002A, 0x00E2,
    0xFF6F, 0x2C83, 0xFF46, 0x004D, 0xFF73, 0x0079, 0xFF4A, 0xFE89
    };

static const q15_t ref_cfft_noisy_32[64] = {
    0xFDBE, 0x0000, 0xFF4A, 0x0177, 0xFF73, 0xFF87, 0xFF46, 0xFFB3,
    0xFF6F, 0xD37D, 0x002A, 0xFF1E, 0xFFCA, 0xFFFE, 0xFF7F, 0xFFD7,
    0xFF4B, 0xFF0D, 0x004A, 0xFFA7, 0xFED8, 0x0004, 0x00E3, 0x0175,
    0xFF2F, 0xFE93, 0x0053, 0x013B, 0xFFE7, 0xFF96, 0xFFB9, 0xFFA6,
    0xFFD9, 0x0000, 0xFFB9, 0x005A, 0xFFE7, 0x006A, 0x0053, 0xFEC5,
    0xFF2F, 0x016D, 0x00E3, 0xFE8B, 0xFED8, 0xFFFC, 0x004A, 0x0059,
    0xFF4B, 0x00F3, 0xFF7F, 0x0029, 0xFFCA, 0x0002, 0x002A, 0x00E2,
    0xFF6F, 0x2C83, 0xFF46, 0x004D, 0xFF73, 0x0079, 0xFF4A, 0xFE89
    };

static const q15_t in_cfft_noisy_64[128] = {
    0xF9D1, 0x0000, 0x3DD1, 0x0000, 0x5C4C, 0x0000, 0x3E92, 0x0000,
    0xFB50, 0x0000, 0xCC59, 0x0000, 0xAB6B, 0x0000, 0xB74B, 0x0000,
    0xFFB9, 0x0000, 0x4708, 0x0000, 0x60BD, 0x0000, 0x3A45, 0x0000,
    0x0063, 0x0000, 0xC50E, 0x0000, 0x9B6C, 0x0000, 0xC5B7, 0x0000,
    0xFAF5, 0x0000, 0x45F5, 0x0000, 0x5F43, 0x0000, 0x42CA, 0x0000,
    0x05CA, 0x0000, 0xBE2D, 0x0000, 0xAA7E, 0x0000, 0xB7ED, 0x0000,
    0xFE4D, 0x0000, 0x3FF2, 0x0000, 0x4C61, 0x0000, 0x4EFA, 0x0000,
    0x0666, 0x0000, 0xC228, 0x0000, 0xA744, 0x0000, 0xCCBE, 0x0000,
    0x0065, 0x0000, 0x37A3, 0x0000, 0x55FD, 0x0000, 0x3884, 0x0000,
    0x00FC, 0x0000, 0xC218, 0x0000, 0xAE90, 0x0000, 0xBB53, 0x0000,
    0x04BA, 0x0000, 0x48D5, 0x0000, 0x5C2A, 0x0000, 0x3503, 0x0000,
    0xFFCA, 0x0000, 0xBAF5, 0x0000, 0xA6F9, 0x0000, 0xCC6F, 0x0000,
    0x00DA, 0x0000, 0x3CD6, 0x0000, 0x60AC, 0x0000, 0x4678, 0x0000,
    0xFDE1, 0x0000, 0xC28E, 0x0000, 0xA1A7, 0x0000, 0xBEFB, 0x0000,
    0xF883, 0x0000, 0x39A6, 0x0000, 0x55FD, 0x0000, 0x3C82, 0x0000,
    0xFDCA, 0x0000, 0xBFE4, 0x0000, 0xB200, 0x0000, 0xBD88, 0x0000
    };

static const q15_t in_cifft_noisy_64[128] = {
    0x0073, 0x0000, 0xFFA5, 0xFFC0, 0xFFBE, 0xFFA7, 0x000B, 0xFF6C,
    0x0074, 0xFFE2, 0x0034, 0xFFCC, 0xFF9D, 0x01BE, 0x0030, 0xFF51,
    0xFFA7, 0xD36B, 0xFF6D, 0x004A, 0xFF9F, 0x002F, 0x001E, 0x0039,
    0x0022, 0x00B3, 0xFF4A, 0xFFC0, 0x00E8, 0xFFBA, 0xFFA5, 0xFFB3,
    0xFF89, 0xFFB8, 0xFEDB, 0xFF49, 0xFEDB, 0x0047, 0x0013, 0xFF84,
    0xFF84, 0x017D, 0x0012, 0xFF9D, 0xFFEE, 0xFF53, 0x0070, 0x0059,
    0xFFC1, 0xFFE9, 0x0010, 0x0046, 0x00E4, 0xFF87, 0xFF99, 0xFEC0,
    0xFF92, 0x0065, 0x00BE, 0xFF8F, 0x003F, 0x008F, 0xFFF7, 0xFF91,
    0xFFD4, 0x0000, 0xFFF7, 0x006F, 0x003F, 0xFF71, 0x00BE, 0x0071,
    0xFF92, 0xFF9B, 0xFF99, 0x0140, 0x00E4, 0x0079, 0x0010, 0xFFBA,
    0xFFC1, 0x0017, 0x0070, 0xFFA7, 0xFFEE, 0x00AD, 0x0012, 0x0063,
    0xFF84, 0xFE83, 0x0013, 0x007C, 0xFEDB, 0xFFB9, 0xFEDB, 0x00B7,
    0xFF89, 0x0048, 0xFFA5, 0x004D, 0x00E8, 0x0046, 0xFF4A, 0x0040,
    0x0022, 0xFF4D, 0x001E, 0xFFC7, 0xFF9F, 0xFFD1, 0xFF6D, 0xFFB6,
    0xFFA7, 0x2C95, 0x0030, 0x00AF, 0xFF9D, 0xFE42, 0x0034, 0x0034,
    0x0074, 0x001E, 0x000B, 0x0094, 0xFFBE, 0x0059, 0xFFA5, 0x0040
    };

static const q15_t ref_cfft_noisy_64[128] = {
    0x0073, 0x0000, 0xFFA5, 0xFFC0, 0xFFBE, 0xFFA7, 0x000B, 0xFF6C,
    0x0074, 0xFFE2, 0x0034, 0xFFCC, 0xFF9D, 0x01BE, 0x0030, 0xFF51,
    0xFFA7, 0xD36B, 0xFF6D, 0x004A, 0xFF9F, 0x002F, 0x001E, 0x0039,
    0x0022, 0x00B3, 0xFF4A, 0xFFC0, 0x00E8, 0xFFBA, 0xFFA5, 0xFFB3,
    0xFF89, 0xFFB8, 0xFEDB, 0xFF49, 0xFEDB, 0x0047, 0x0013, 0xFF84,
    0xFF84, 0x017D, 0x0012, 0xFF9D, 0xFFEE, 0xFF53, 0x0070, 0x0059,
    0xFFC1, 0xFFE9, 0x0010, 0x0046, 0x00E4, 0xFF87, 0xFF99, 0xFEC0,
    0xFF92, 0x0065, 0x00BE, 0xFF8F, 0x003F, 0x008F, 0xFFF7, 0xFF91,
    0xFFD4, 0x0000, 0xFFF7, 0x006F, 0x003F, 0xFF71, 0x00BE, 0x0071,
    0xFF92, 0xFF9B, 0xFF99, 0x0140, 0x00E4, 0x0079, 0x0010, 0xFFBA,
    0xFFC1, 0x0017, 0x0070, 0xFFA7, 0xFFEE, 0x00AD, 0x0012, 0x0063,
    0xFF84, 0xFE83, 0x0013, 0x007C, 0xFEDB, 0xFFB9, 0xFEDB, 0x00B7,
    0xFF89, 0x0048, 0xFFA5, 0x004D, 0x00E8, 0x0046, 0xFF4A, 0x0040,
    0x0022, 0xFF4D, 0x001E, 0xFFC7, 0xFF9F, 0xFFD1, 0xFF6D, 0xFFB6,
    0xFFA7, 0x2C95, 0x0030, 0x00AF, 0xFF9D, 0xFE42, 0x0034, 0x0034,
    0x0074, 0x001E, 0x000B, 0x0094, 0xFFBE, 0x0059, 0xFFA5, 0x0040
    };

static const q15_t in_cfft_noisy_128[256] = {
    0xF42D, 0x0000, 0x3AFC, 0x0000, 0x55BA, 0x0000, 0x3F1F, 0x0000,
    0x01A4, 0x0000, 0xBA5E, 0x0000, 0xA2B4, 0x0000, 0xBD1E, 0x0000,
    0xFE9B, 0x0000, 0x42EB, 0x0000, 0x5060, 0x0000, 0x425C, 0x0000,
    0xFC2B, 0x0000, 0xC75F, 0x0000, 0xAA11, 0x0000, 0xB958, 0x0000,
    0xFD3F, 0x0000, 0x4675, 0x0000, 0x5AB2, 0x0000, 0x3930, 0x0000,
    0x0869, 0x0000, 0xC8EE, 0x0000, 0xA36E, 0x0000, 0xBD2A, 0x0000,
    0x015E, 0x0000, 0x41DF, 0x0000, 0x59B8, 0x0000, 0x3A19, 0x0000,
    0x0513, 0x0000, 0xC304, 0x0000, 0xAEA9, 0x0000, 0xC019, 0x0000,
    0x08A3, 0x0000, 0x3616, 0x0000, 0x57B6, 0x0000, 0x378F, 0x0000,
    0xFEF2, 0x0000, 0xC2A4, 0x0000, 0xB422, 0x0000, 0xC0E5, 0x0000,
    0x059C, 0x0000, 0x4026, 0x0000, 0x50E3, 0x0000, 0x3BEA, 0x0000,
    0x00FA, 0x0000, 0xBB0B, 0x0000, 0xAF9E, 0x0000, 0xC700, 0x0000,
    0xFBEC, 0x0000, 0x4633, 0x0000, 0x5BD5, 0x0000, 0x432A, 0x0000,
    0xFE41, 0x0000, 0xB9A2, 0x0000, 0xAD82, 0x0000, 0xBED7, 0x0000,
    0x04A3, 0x0000, 0x3447, 0x0000, 0x6045, 0x0000, 0x383E, 0x0000,
    0xFB1D, 0x0000, 0xCA16, 0x0000, 0x9B1A, 0x0000, 0xB69F, 0x0000,
    0xF634, 0x0000, 0x45D8, 0x0000, 0x5B61, 0x0000, 0x3AE7, 0x0000,
    0x006E, 0x0000, 0xC2A1, 0x0000, 0x9785, 0x0000, 0xC47C, 0x0000,
    0xFE84, 0x0000, 0x3BE6, 0x0000, 0x5506, 0x0000, 0x3EE4, 0x0000,
    0xFDE8, 0x0000, 0xC499, 0x0000, 0x9DB1, 0x0000, 0xB51C, 0x0000,
    0x0B2C, 0x0000, 0x3824, 0x0000, 0x6717, 0x0000, 0x3C3E, 0x0000,
    0xFC30, 0x0000, 0xBFF1, 0x0000, 0xB0AE, 0x0000, 0xBBF9, 0x0000,
    0x0697, 0x0000, 0x4825, 0x0000, 0x602E, 0x0000, 0x4363, 0x0000,
    0xFFDC, 0x0000, 0xBF28, 0x0000, 0xA23A, 0x0000, 0xC1E0, 0x0000,
    0xFAF3, 0x0000, 0x3860, 0x0000, 0x5683, 0x0000, 0x4786, 0x0000,
    0x03A2, 0x0000, 0xBC4E, 0x0000, 0xAAB4, 0x0000, 0xBB3D, 0x0000,
    0xFABC, 0x0000, 0x40B8, 0x0000, 0x5C33, 0x0000, 0x3DE8, 0x0000,
    0x0882, 0x0000, 0xCAC5, 0x0000, 0xA929, 0x0000, 0xBC5B, 0x0000,
    0x05F4, 0x0000, 0x4412, 0x0000, 0x6415, 0x0000, 0x45E5, 0x0000,
    0xFC0C, 0x0000, 0xC38C, 0x0000, 0xA375, 0x0000, 0xC4F4, 0x0000,
    0xFF2C, 0x0000, 0x373A, 0x0000, 0x5734, 0x0000, 0x409A, 0x0000,
    0x078C, 0x0000, 0xC0A6, 0x0000, 0xA5C9, 0x0000, 0xBABF, 0x0000
    };

static const q15_t in_cifft_noisy_128[256] = {
    0xFFF9, 0x0000, 0x0033, 0x0010, 0xFF28, 0x005B, 0xFFF4, 0x0026,
    0xFF34, 0x0077, 0xFFA6, 0xFFD2, 0x001E, 0xFF97, 0x002D, 0x005E,
    0xFFEF, 0xFFEC, 0x0017, 0x0021, 0x0023, 0x0030, 0xFFA7, 0x0031,
    0xFF75, 0x0018, 0x0088, 0x0026, 0x0009, 0xFFA0, 0xFEEA, 0x005E,
    0xFF90, 0xD332, 0x003E, 0xFFDB, 0xFF81, 0xFFA4, 0x002D, 0x004B,
    0xFFE6, 0x0039, 0xFFB2, 0xFFD8, 0xFF72, 0xFF95, 0xFFC1, 0x0028,
    0xFF77, 0xFF78, 0x0010, 0x001F, 0xFFD1, 0xFF5D, 0x006F, 0x0023,
    0x001D, 0x0083, 0xFFB4, 0x0044, 0x0089, 0x0041, 0x004F, 0x0014,
    0xFFF6, 0xFF76, 0xFFE7, 0xFFF8, 0xFFA8, 0xFFAD, 0xFFF4, 0x00DA,
    0x0026, 0xFFFA, 0xFFE7, 0x00A1, 0xFFF2, 0xFF39, 0x001E, 0xFF9F,
    0x0014, 0x000B, 0xFFAE, 0x0071, 0xFFAE, 0xFF83, 0xFFB8, 0x0089,
    0x001E, 0xFFF4, 0x0092, 0xFF44, 0xFFC4, 0x008E, 0x0014, 0xFF76,
    0x003B, 0x0004, 0xFF8D, 0xFFED, 0x0021, 0x0030, 0xFF8D, 0xFFD2,
    0xFF6D, 0x004F, 0xFFD3, 0xFF69, 0xFF67, 0x006A, 0x0050, 0xFFCD,
    0xFFFE, 0x0042, 0x0034, 0xFFEC, 0x0034, 0xFF61, 0x0060, 0x00F1,
    0xFFDD, 0xFF86, 0x006A, 0xFFB4, 0xFF50, 0xFFE0, 0xFFD0, 0x0029,
    0x009D, 0x0000, 0xFFD0, 0xFFD7, 0xFF50, 0x0020, 0x006A, 0x004C,
    0xFFDD, 0x007A, 0x0060, 0xFF0F, 0x0034, 0x009F, 0x0034, 0x0014,
    0xFFFE, 0xFFBE, 0x0050, 0x0033, 0xFF67, 0xFF96, 0xFFD3, 0x0097,
    0xFF6D, 0xFFB1, 0xFF8D, 0x002E, 0x0021, 0xFFD0, 0xFF8D, 0x0013,
    0x003B, 0xFFFC, 0x0014, 0x008A, 0xFFC4, 0xFF72, 0x0092, 0x00BC,
    0x001E, 0x000C, 0xFFB8, 0xFF77, 0xFFAE, 0x007D, 0xFFAE, 0xFF8F,
    0x0014, 0xFFF5, 0x001E, 0x0061, 0xFFF2, 0x00C7, 0xFFE7, 0xFF5F,
    0x0026, 0x0006, 0xFFF4, 0xFF26, 0xFFA8, 0x0053, 0xFFE7, 0x0008,
    0xFFF6, 0x008A, 0x004F, 0xFFEC, 0x0089, 0xFFBF, 0xFFB4, 0xFFBC,
    0x001D, 0xFF7D, 0x006F, 0xFFDD, 0xFFD1, 0x00A3, 0x0010, 0xFFE1,
    0xFF77, 0x0088, 0xFFC1, 0xFFD8, 0xFF72, 0x006B, 0xFFB2, 0x0028,
    0xFFE6, 0xFFC7, 0x002D, 0xFFB5, 0xFF81, 0x005C, 0x003E, 0x0025,
    0xFF90, 0x2CCE, 0xFEEA, 0xFFA2, 0x0009, 0x0060, 0x0088, 0xFFDA,
    0xFF75, 0xFFE8, 0xFFA7, 0xFFCF, 0x0023, 0xFFD0, 0x0017, 0xFFDF,
    0xFFEF, 0x0014, 0x002D, 0xFFA2, 0x001E, 0x0069, 0xFFA6, 0x002E,
    0xFF34, 0xFF89, 0xFFF4, 0xFFDA, 0xFF28, 0xFFA5, 0x0033, 0xFFF0
    };

static const q15_t ref_cfft_noisy_128[256] = {
    0xFFF9, 0x0000, 0x0033, 0x0010, 0xFF28, 0x005B, 0xFFF4, 0x0026,
    0xFF34, 0x0077, 0xFFA6, 0xFFD2, 0x001E, 0xFF97, 0x002D, 0x005E,
    0xFFEF, 0xFFEC, 0x0017, 0x0021, 0x0023, 0x0030, 0xFFA7, 0x0031,
    0xFF75, 0x0018, 0x0088, 0x0026, 0x0009, 0xFFA0, 0xFEEA, 0x005E,
    0xFF90, 0xD332, 0x003E, 0xFFDB, 0xFF81, 0xFFA4, 0x002D, 0x004B,
    0xFFE6, 0x0039, 0xFFB2, 0xFFD8, 0xFF72, 0xFF95, 0xFFC1, 0x0028,
    0xFF77, 0xFF78, 0x0010, 0x001F, 0xFFD1, 0xFF5D, 0x006F, 0x0023,
    0x001D, 0x0083, 0xFFB4, 0x0044, 0x0089, 0x0041, 0x004F, 0x0014,
    0xFFF6, 0xFF76, 0xFFE7, 0xFFF8, 0xFFA8, 0xFFAD, 0xFFF4, 0x00DA,
    0x0026, 0xFFFA, 0xFFE7, 0x00A1, 0xFFF2, 0xFF39, 0x001E, 0xFF9F,
    0x0014, 0x000B, 0xFFAE, 0x0071, 0xFFAE, 0xFF83, 0xFFB8, 0x0089,
    0x001E, 0xFFF4, 0x0092, 0xFF44, 0xFFC4, 0x008E, 0x0014, 0xFF76,
    0x003B, 0x0004, 0xFF8D, 0xFFED, 0x0021, 0x0030, 0xFF8D, 0xFFD2,
    0xFF6D, 0x004F, 0xFFD3, 0xFF69, 0xFF67, 0x006A, 0x0050, 0xFFCD,
    0xFFFE, 0x0042, 0x0034, 0xFFEC, 0x0034, 0xFF61, 0x0060, 0x00F1,
    0xFFDD, 0xFF86, 0x006A, 0xFFB4, 0xFF50, 0xFFE0, 0xFFD0, 0x0029,
    0x009D, 0x0000, 0xFFD0, 0xFFD7, 0xFF50, 0x0020, 0x006A, 0x004C,
    0xFFDD, 0x007A, 0x0060, 0xFF0F, 0x0034, 0x009F, 0x0034, 0x0014,
    0xFFFE, 0xFFBE, 0x0050, 0x0033, 0xFF67, 0xFF96, 0xFFD3, 0x0097,
    0xFF6D, 0xFFB1, 0xFF8D, 0x002E, 0x0021, 0xFFD0, 0xFF8D, 0x0013,
    0x003B, 0xFFFC, 0x0014, 0x008A, 0xFFC4, 0xFF72, 0x0092, 0x00BC,
    0x001E, 0x000C, 0xFFB8, 0xFF77, 0xFFAE, 0x007D, 0xFFAE, 0xFF8F,
    0x0014, 0xFFF5, 0x001E, 0x0061, 0xFFF2, 0x00C7, 0xFFE7, 0xFF5F,
    0x0026, 0x0006, 0xFFF4, 0xFF26, 0xFFA8, 0x0053, 0xFFE7, 0x0008,
    0xFFF6, 0x008A, 0x004F, 0xFFEC, 0x0089, 0xFFBF, 0xFFB4, 0xFFBC,
    0x001D, 0xFF7D, 0x006F, 0xFFDD, 0xFFD1, 0x00A3, 0x0010, 0xFFE1,
    0xFF77, 0x0088, 0xFFC1, 0xFFD8, 0xFF72, 0x006B, 0xFFB2, 0x0028,
    0xFFE6, 0xFFC7, 0x002D, 0xFFB5, 0xFF81, 0x005C, 0x003E, 0x0025,
    0xFF90, 0x2CCE, 0xFEEA, 0xFFA2, 0x0009, 0x0060, 0x0088, 0xFFDA,
    0xFF75, 0xFFE8, 0xFFA7, 0xFFCF, 0x0023, 0xFFD0, 0x0017, 0xFFDF,
    0xFFEF, 0x0014, 0x002D, 0xFFA2, 0x001E, 0x0069, 0xFFA6, 0x002E,
    0xFF34, 0xFF89, 0xFFF4, 0xFFDA, 0xFF28, 0xFFA5, 0x0033, 0xFFF0
    };

static const q15_t in_cfft_noisy_256[512] = {
    0x0906, 0x0000, 0x2C93, 0x0000, 0x559E, 0x0000, 0x3D7E, 0x0000,
    0xFA0B, 0x0000, 0xB8DC, 0x0000, 0xA19E, 0x0000, 0xC7A2, 0x0000,
    0x01E0, 0x0000, 0x35E4, 0x0000, 0x5F2D, 0x0000, 0x35E3, 0x0000,
    0xFB52, 0x0000, 0xC9B2, 0x0000, 0x9DBD, 0x0000, 0xC433, 0x0000,
    0x06D4, 0x0000, 0x3C79, 0x0000, 0x501B, 0x0000, 0x33BC, 0x0000,
    0x02BB, 0x0000, 0xBF05, 0x0000, 0xA6E7, 0x0000, 0xC36C, 0x0000,
    0x061E, 0x0000, 0x3D1C, 0x0000, 0x53A4, 0x0000, 0x3CE5, 0x0000,
    0xFD94, 0x0000, 0xC69C, 0x0000, 0xA7C3, 0x0000, 0xBE06, 0x0000,
    0xFD23, 0x0000, 0x3CBC, 0x0000, 0x5798, 0x0000, 0x3C29, 0x0000,
    0x0362, 0x0000, 0xBAEE, 0x0000, 0xAA15, 0x0000, 0xC725, 0x0000,
    0x03CA, 0x0000, 0x3A66, 0x0000, 0x55B1, 0x0000, 0x36CE, 0x0000,
    0xFD25, 0x0000, 0xB92C, 0x0000, 0xA6A2, 0x0000, 0xC1E4, 0x0000,
    0xFC47, 0x0000, 0x3E58, 0x0000, 0x4FB3, 0x0000, 0x435D, 0x0000,
    0xFD38, 0x0000, 0xC042, 0x0000, 0xA758, 0x0000, 0xC46A, 0x0000,
    0x085B, 0x0000, 0x32B7, 0x0000, 0x58D7, 0x0000, 0x3B15, 0x0000,
    0xF988, 0x0000, 0xC848, 0x0000, 0xB5BB, 0x0000, 0xC078, 0x0000,
    0xFFA3, 0x0000, 0x385F, 0x0000, 0x5A62, 0x0000, 0x429A, 0x0000,
    0x05E0, 0x0000, 0xBAAE, 0x0000, 0xAA50, 0x0000, 0xCA75, 0x0000,
    0xFB98, 0x0000, 0x3A84, 0x0000, 0x590E, 0x0000, 0x4252, 0x0000,
    0x0777, 0x0000, 0xC0F3, 0x0000, 0xA651, 0x0000, 0xC2F7, 0x0000,
    0x06A5, 0x0000, 0x4300, 0x0000, 0x63E2, 0x0000, 0x37E8, 0x0000,
    0xFDC4, 0x0000, 0xC3DF, 0x0000, 0xA804, 0x0000, 0xC06D, 0x0000,
    0xF8CE, 0x0000, 0x47A2, 0x0000, 0x5D05, 0x0000, 0x4A8E, 0x0000,
    0x0B94, 0x0000, 0xB929, 0x0000, 0xA252, 0x0000, 0xCAF6, 0x0000,
    0x0760, 0x0000, 0x4696, 0x0000, 0x4701, 0x0000, 0x42C8, 0x0000,
    0xF69C, 0x0000, 0xB9D0, 0x0000, 0x9D53, 0x0000, 0xC4C9, 0x0000,
    0x0597, 0x0000, 0x3AC9, 0x0000, 0x6036, 0x0000, 0x42B4, 0x0000,
    0x0071, 0x0000, 0xC3EF, 0x0000, 0xA742, 0x0000, 0xBD07, 0x0000,
    0xF860, 0x0000, 0x36B5, 0x0000, 0x5401, 0x0000, 0x4BE9, 0x0000,
    0x0478, 0x0000, 0xC295, 0x0000, 0xA319, 0x0000, 0xC46A, 0x0000,
    0xFF32, 0x0000, 0x4368, 0x0000, 0x58B4, 0x0000, 0x3E8D, 0x0000,
    0xFEB5, 0x0000, 0xBB16, 0x0000, 0xA1EC, 0x0000, 0xBBBE, 0x0000,
    0xFCD5, 0x0000, 0x37C6, 0x0000, 0x532F, 0x0000, 0x4031, 0x0000,
    0xF73F, 0x0000, 0xBADF, 0x0000, 0xB012, 0x0000, 0xBE0E, 0x0000,
    0xF975, 0x0000, 0x4320, 0x0000, 0x54D8, 0x0000, 0x38B6, 0x0000,
    0xFE87, 0x0000, 0xC1FC, 0x0000, 0xA2EB, 0x0000, 0xB6EB, 0x0000,
    0x005A, 0x0000, 0x349A, 0x0000, 0x60A7, 0x0000, 0x3AB3, 0x0000,
    0xF4E4, 0x0000, 0xCB70, 0x0000, 0xA378, 0x0000, 0xC27B, 0x0000,
    0xFD6E, 0x0000, 0x404F, 0x0000, 0x575E, 0x0000, 0x3ECD, 0x0000,
    0xF9B8, 0x0000, 0xB8FD, 0x0000, 0x9991, 0x0000, 0xBC39, 0x0000,
    0xF502, 0x0000, 0x3B08, 0x0000, 0x5B2D, 0x0000, 0x3D7F, 0x0000,
    0xFA24, 0x0000, 0xBE61, 0x0000, 0xA7B8, 0x0000, 0xB76E, 0x0000,
    0x071B, 0x0000, 0x4114, 0x0000, 0x57D6, 0x0000, 0x3D7C, 0x0000,
    0xFF36, 0x0000, 0xC4A5, 0x0000, 0xA9C6, 0x0000, 0xD204, 0x0000,
    0x03B1, 0x0000, 0x43CB, 0x0000, 0x5BA1, 0x0000, 0x3C13, 0x0000,
    0xF8A6, 0x0000, 0xB8CE, 0x0000, 0x9F95, 0x0000, 0xB881, 0x0000,
    0xFA45, 0x0000, 0x45C5, 0x0000, 0x58EF, 0x0000, 0x388E, 0x0000,
    0x0467, 0x0000, 0xC24F, 0x0000, 0xA1F8, 0x0000, 0xC661, 0x0000,
    0xFC77, 0x0000, 0x4028, 0x0000, 0x5B18, 0x0000, 0x3DCE, 0x0000,
    0x05C0, 0x0000, 0xB6A4, 0x0000, 0xAA71, 0x0000, 0xC239, 0x0000,
    0xFDDF, 0x0000, 0x4620, 0x0000, 0x53AD, 0x0000, 0x3989, 0x0000,
    0x01F8, 0x0000, 0xC9DE, 0x0000, 0x9FD0, 0x0000, 0xBF34, 0x0000,
    0x09D2, 0x0000, 0x4287, 0x0000, 0x528C, 0x0000, 0x3D7B, 0x0000,
    0x0809, 0x0000, 0xB788, 0x0000, 0xAA87, 0x0000, 0xBFAA, 0x0000,
    0x061C, 0x0000, 0x3CF2, 0x0000, 0x64EF, 0x0000, 0x45C1, 0x0000,
    0xFFE2, 0x0000, 0xB798, 0x0000, 0xA97A, 0x0000, 0xB945, 0x0000,
    0x0400, 0x0000, 0x3BD6, 0x0000, 0x5511, 0x0000, 0x3DE7, 0x0000,
    0xFF92, 0x0000, 0xC13C, 0x0000, 0xA78E, 0x0000, 0xC823, 0x0000,
    0x030A, 0x0000, 0x3656, 0x0000, 0x5A7B, 0x0000, 0x3A6B, 0x0000,
    0x091F, 0x0000, 0xBE9C, 0x0000, 0xA6C9, 0x0000, 0xB2D2, 0x0000,
    0xF7D7, 0x0000, 0x3BBE, 0x0000, 0x65B5, 0x0000, 0x3E38, 0x0000,
    0x098B, 0x0000, 0xC0CD, 0x0000, 0xA618, 0x0000, 0xC3D4, 0x0000,
    0xF939, 0x0000, 0x43E9, 0x0000, 0x57E9, 0x0000, 0x429E, 0x0000,
    0xFC58, 0x0000, 0xC708, 0x0000, 0xA93E, 0x0000, 0xCB85, 0x0000
    };

static const q15_t in_cifft_noisy_256[512] = {
    0xFF68, 0x0000, 0x002E, 0xFFCA, 0xFF8D, 0x00A4, 0x0047, 0xFFEE,
    0x0006, 0xFFF6, 0xFFD6, 0xFFF6, 0x002C, 0x0037, 0x001D, 0x0053,
    0xFFCA, 0x003A, 0x0071, 0xFFDB, 0xFFB6, 0x005A, 0xFFCF, 0xFFF0,
    0x0037, 0xFFF5, 0x0005, 0x0092, 0xFFC9, 0xFFFA, 0x0010, 0xFFF0,
    0xFFBA, 0x004A, 0x0016, 0xFFF9, 0xFF67, 0xFFE6, 0x00C6, 0x0033,
    0x0053, 0x0004, 0xFFFA, 0x001B, 0x0090, 0xFFFA, 0xFFC8, 0x006B,
    0xFFD6, 0x002D, 0x0029, 0xFFE9, 0x002D, 0x0055, 0xFFF0, 0x0019,
    0xFFD9, 0x006D, 0x0024, 0x0024, 0xFF80, 0x003F, 0xFFB5, 0x0051,
    0x0037, 0xD390, 0x0067, 0x005F, 0x0022, 0xFFC5, 0x0012, 0xFF95,
    0xFFEB, 0x001C, 0x003E, 0xFFF9, 0x006B, 0xFF78, 0xFFCC, 0x0009,
    0x0059, 0xFFE9, 0x0009, 0x0051, 0x0042, 0x007E, 0xFFB1, 0x0016,
    0xFFE5, 0x0094, 0xFFF9, 0x0016, 0xFFEE, 0xFFCB, 0xFFED, 0xFFFF,
    0xFFD1, 0xFFEC, 0xFFD5, 0xFFFB, 0x0014, 0x004C, 0x006F, 0xFFFF,
    0xFF6A, 0xFFC9, 0x003B, 0x004F, 0x0072, 0xFFE0, 0xFFD2, 0x0009,
    0xFFC2, 0x0077, 0xFFBA, 0x003E, 0xFFE7, 0x002F, 0xFFDC, 0x0046,
    0x000C, 0x002B, 0xFFF8, 0x0076, 0x002E, 0xFFE4, 0xFFDB, 0x0017,
    0x0033, 0x005F, 0x007F, 0x0007, 0xFFBA, 0x0038, 0xFFEB, 0xFF99,
    0xFF98, 0xFFF9, 0x0063, 0x0018, 0x001F, 0x001A, 0xFFE4, 0x004A,
    0x0017, 0x0058, 0xFFE2, 0xFFD3, 0x0019, 0x0062, 0x008C, 0xFFF3,
    0x004D, 0x0062, 0xFFD4, 0x0097, 0xFFE0, 0xFFEF, 0x006F, 0xFF85,
    0x007C, 0x0004, 0xFFC7, 0xFF9D, 0x0059, 0x002F, 0xFFD0, 0x0008,
    0x0075, 0xFFD7, 0xFFB9, 0xFFDB, 0x0013, 0x0032, 0x002A, 0x000C,
    0xFFFA, 0xFFAE, 0xFFD8, 0x0011, 0xFFF2, 0x0005, 0x002A, 0x0082,
    0xFFCD, 0x0022, 0xFFF0, 0x002B, 0x0014, 0x0060, 0xFFFB, 0x0055,
    0xFFF5, 0x0035, 0xFFF4, 0x0020, 0x007D, 0x0009, 0xFFE0, 0x008F,
    0x0012, 0x0013, 0x0054, 0xFFA7, 0xFFF5, 0xFF8D, 0x006B, 0x0051,
    0x000B, 0xFFBE, 0x008E, 0x000A, 0x005E, 0xFFE5, 0xFFF0, 0xFF98,
    0xFFDF, 0x007C, 0xFFF7, 0xFFC6, 0x000E, 0xFFC0, 0x0037, 0x003F,
    0x0000, 0x0015, 0xFFC4, 0x0036, 0x007D, 0x0010, 0x003B, 0x007E,
    0x0081, 0x0002, 0xFFD4, 0x0047, 0xFF84, 0x006A, 0x0005, 0xFFE6,
    0xFFE6, 0x003D, 0x0015, 0xFFF5, 0x0000, 0x0001, 0xFFAC, 0x0022,
    0x0000, 0x001B, 0xFFB9, 0xFF91, 0xFFE2, 0xFFDA, 0x008A, 0xFFEC,
    0x0042, 0x0000, 0x008A, 0x0014, 0xFFE2, 0x0026, 0xFFB9, 0x006F,
    0x0000, 0xFFE5, 0xFFAC, 0xFFDE, 0x0000, 0xFFFF, 0x0015, 0x000B,
    0xFFE6, 0xFFC3, 0x0005, 0x001A, 0xFF84, 0xFF96, 0xFFD4, 0xFFB9,
    0x0081, 0xFFFE, 0x003B, 0xFF82, 0x007D, 0xFFF0, 0xFFC4, 0xFFCA,
    0x0000, 0xFFEB, 0x0037, 0xFFC1, 0x000E, 0x0040, 0xFFF7, 0x003A,
    0xFFDF, 0xFF84, 0xFFF0, 0x0068, 0x005E, 0x001B, 0x008E, 0xFFF6,
    0x000B, 0x0042, 0x006B, 0xFFAF, 0xFFF5, 0x0073, 0x0054, 0x0059,
    0x0012, 0xFFED, 0xFFE0, 0xFF71, 0x007D, 0xFFF7, 0xFFF4, 0xFFE0,
    0xFFF5, 0xFFCB, 0xFFFB, 0xFFAB, 0x0014, 0xFFA0, 0xFFF0, 0xFFD5,
    0xFFCD, 0xFFDE, 0x002A, 0xFF7E, 0xFFF2, 0xFFFB, 0xFFD8, 0xFFEF,
    0xFFFA, 0x0052, 0x002A, 0xFFF4, 0x0013, 0xFFCE, 0xFFB9, 0x0025,
    0x0075, 0x0029, 0xFFD0, 0xFFF8, 0x0059, 0xFFD1, 0xFFC7, 0x0063,
    0x007C, 0xFFFC, 0x006F, 0x007B, 0xFFE0, 0x0011, 0xFFD4, 0xFF69,
    0x004D, 0xFF9E, 0x008C, 0x000D, 0x0019, 0xFF9E, 0xFFE2, 0x002D,
    0x0017, 0xFFA8, 0xFFE4, 0xFFB6, 0x001F, 0xFFE6, 0x0063, 0xFFE8,
    0xFF98, 0x0007, 0xFFEB, 0x0067, 0xFFBA, 0xFFC8, 0x007F, 0xFFF9,
    0x0033, 0xFFA1, 0xFFDB, 0xFFE9, 0x002E, 0x001C, 0xFFF8, 0xFF8A,
    0x000C, 0xFFD5, 0xFFDC, 0xFFBA, 0xFFE7, 0xFFD1, 0xFFBA, 0xFFC2,
    0xFFC2, 0xFF89, 0xFFD2, 0xFFF7, 0x0072, 0x0020, 0x003B, 0xFFB1,
    0xFF6A, 0x0037, 0x006F, 0x0001, 0x0014, 0xFFB4, 0xFFD5, 0x0005,
    0xFFD1, 0x0014, 0xFFED, 0x0001, 0xFFEE, 0x0035, 0xFFF9, 0xFFEA,
    0xFFE5, 0xFF6C, 0xFFB1, 0xFFEA, 0x0042, 0xFF82, 0x0009, 0xFFAF,
    0x0059, 0x0017, 0xFFCC, 0xFFF7, 0x006B, 0x0088, 0x003E, 0x0007,
    0xFFEB, 0xFFE4, 0x0012, 0x006B, 0x0022, 0x003B, 0x0067, 0xFFA1,
    0x0037, 0x2C70, 0xFFB5, 0xFFAF, 0xFF80, 0xFFC1, 0x0024, 0xFFDC,
    0xFFD9, 0xFF93, 0xFFF0, 0xFFE7, 0x002D, 0xFFAB, 0x0029, 0x0017,
    0xFFD6, 0xFFD3, 0xFFC8, 0xFF95, 0x0090, 0x0006, 0xFFFA, 0xFFE5,
    0x0053, 0xFFFC, 0x00C6, 0xFFCD, 0xFF67, 0x001A, 0x0016, 0x0007,
    0xFFBA, 0xFFB6, 0x0010, 0x0010, 0xFFC9, 0x0006, 0x0005, 0xFF6E,
    0x0037, 0x000B, 0xFFCF, 0x0010, 0xFFB6, 0xFFA6, 0x0071, 0x0025,
    0xFFCA, 0xFFC6, 0x001D, 0xFFAD, 0x002C, 0xFFC9, 0xFFD6, 0x000A,
    0x0006, 0x000A, 0x0047, 0x0012, 0xFF8D, 0xFF5C, 0x002E, 0x0036
    };

static const q15_t ref_cfft_noisy_256[512] = {
    0xFF68, 0x0000, 0x002E, 0xFFCA, 0xFF8D, 0x00A4, 0x0047, 0xFFEE,
    0x0006, 0xFFF6, 0xFFD6, 0xFFF6, 0x002C, 0x0037, 0x001D, 0x0053,
    0xFFCA, 0x003A, 0x0071, 0xFFDB, 0xFFB6, 0x005A, 0xFFCF, 0xFFF0,
    0x0037, 0xFFF5, 0x0005, 0x0092, 0xFFC9, 0xFFFA, 0x0010, 0xFFF0,
    0xFFBA, 0x004A, 0x0016, 0xFFF9, 0xFF67, 0xFFE6, 0x00C6, 0x0033,
    0x0053, 0x0004, 0xFFFA, 0x001B, 0x0090, 0xFFFA, 0xFFC8, 0x006B,
    0xFFD6, 0x002D, 0x0029, 0xFFE9, 0x002D, 0x0055, 0xFFF0, 0x0019,
    0xFFD9, 0x006D, 0x0024, 0x0024, 0xFF80, 0x003F, 0xFFB5, 0x0051,
    0x0037, 0xD390, 0x0067, 0x005F, 0x0022, 0xFFC5, 0x0012, 0xFF95,
    0xFFEB, 0x001C, 0x003E, 0xFFF9, 0x006B, 0xFF78, 0xFFCC, 0x0009,
    0x0059, 0xFFE9, 0x0009, 0x0051, 0x0042, 0x007E, 0xFFB1, 0x0016,
    0xFFE5, 0x0094, 0xFFF9, 0x0016, 0xFFEE, 0xFFCB, 0xFFED, 0xFFFF,
    0xFFD1, 0xFFEC, 0xFFD5, 0xFFFB, 0x0014, 0x004C, 0x006F, 0xFFFF,
    0xFF6A, 0xFFC9, 0x003B, 0x004F, 0x0072, 0xFFE0, 0xFFD2, 0x0009,
    0xFFC2, 0x0077, 0xFFBA, 0x003E, 0xFFE7, 0x002F, 0xFFDC, 0x0046,
    0x000C, 0x002B, 0xFFF8, 0x0076, 0x002E, 0xFFE4, 0xFFDB, 0x0017,
    0x0033, 0x005F, 0x007F, 0x0007, 0xFFBA, 0x0038, 0xFFEB, 0xFF99,
    0xFF98, 0xFFF9, 0x0063, 0x0018, 0x001F, 0x001A, 0xFFE4, 0x004A,
    0x0017, 0x0058, 0xFFE2, 0xFFD3, 0x0019, 0x0062, 0x008C, 0xFFF3,
    0x004D, 0x0062, 0xFFD4, 0x0097, 0xFFE0, 0xFFEF, 0x006F, 0xFF85,
    0x007C, 0x0004, 0xFFC7, 0xFF9D, 0x0059, 0x002F, 0xFFD0, 0x0008,
    0x0075, 0xFFD7, 0xFFB9, 0xFFDB, 0x0013, 0x0032, 0x002A, 0x000C,
    0xFFFA, 0xFFAE, 0xFFD8, 0x0011, 0xFFF2, 0x0005, 0x002A, 0x0082,
    0xFFCD, 0x0022, 0xFFF0, 0x002B, 0x0014, 0x0060, 0xFFFB, 0x0055,
    0xFFF5, 0x0035, 0xFFF4, 0x0020, 0x007D, 0x0009, 0xFFE0, 0x008F,
    0x0012, 0x0013, 0x0054, 0xFFA7, 0xFFF5, 0xFF8D, 0x006B, 0x0051,
    0x000B, 0xFFBE, 0x008E, 0x000A, 0x005E, 0xFFE5, 0xFFF0, 0xFF98,
    0xFFDF, 0x007C, 0xFFF7, 0xFFC6, 0x000E, 0xFFC0, 0x0037, 0x003F,
    0x0000, 0x0015, 0xFFC4, 0x0036, 0x007D, 0x0010, 0x003B, 0x007E,
    0x0081, 0x0002, 0xFFD4, 0x0047, 0xFF84, 0x006A, 0x0005, 0xFFE6,
    0xFFE6, 0x003D, 0x0015, 0xFFF5, 0x0000, 0x0001, 0xFFAC, 0x0022,
    0x0000, 0x001B, 0xFFB9, 0xFF91, 0xFFE2, 0xFFDA, 0x008A, 0xFFEC,
    0x0042, 0x0000, 0x008A, 0x0014, 0xFFE2, 0x0026, 0xFFB9, 0x006F,
    0x0000, 0xFFE5, 0xFFAC, 0xFFDE, 0x0000, 0xFFFF, 0x0015, 0x000B,
    0xFFE6, 0xFFC3, 0x0005, 0x001A, 0xFF84, 0xFF96, 0xFFD4, 0xFFB9,
    0x0081, 0xFFFE, 0x003B, 0xFF82, 0x007D, 0xFFF0, 0xFFC4, 0xFFCA,
    0x0000, 0xFFEB, 0x0037, 0xFFC1, 0x000E, 0x0040, 0xFFF7, 0x003A,
    0xFFDF, 0xFF84, 0xFFF0, 0x0068, 0x005E, 0x001B, 0x008E, 0xFFF6,
    0x000B, 0x0042, 0x006B, 0xFFAF, 0xFFF5, 0x0073, 0x0054, 0x0059,
    0x0012, 0xFFED, 0xFFE0, 0xFF71, 0x007D, 0xFFF7, 0xFFF4, 0xFFE0,
    0xFFF5, 0xFFCB, 0xFFFB, 0xFFAB, 0x0014, 0xFFA0, 0xFFF0, 0xFFD5,
    0xFFCD, 0xFFDE, 0x002A, 0xFF7E, 0xFFF2, 0xFFFB, 0xFFD8, 0xFFEF,
    0xFFFA, 0x0052, 0x002A, 0xFFF4, 0x0013, 0xFFCE, 0xFFB9, 0x0025,
    0x0075, 0x0029, 0xFFD0, 0xFFF8, 0x0059, 0xFFD1, 0xFFC7, 0x0063,
    0x007C, 0xFFFC, 0x006F, 0x007B, 0xFFE0, 0x0011, 0xFFD4, 0xFF69,
    0x004D, 0xFF9E, 0x008C, 0x000D, 0x0019, 0xFF9E, 0xFFE2, 0x002D,
    0x0017, 0xFFA8, 0xFFE4, 0xFFB6, 0x001F, 0xFFE6, 0x0063, 0xFFE8,
    0xFF98, 0x0007, 0xFFEB, 0x0067, 0xFFBA, 0xFFC8, 0x007F, 0xFFF9,
    0x0033, 0xFFA1, 0xFFDB, 0xFFE9, 0x002E, 0x001C, 0xFFF8, 0xFF8A,
    0x000C, 0xFFD5, 0xFFDC, 0xFFBA, 0xFFE7, 0xFFD1, 0xFFBA, 0xFFC2,
    0xFFC2, 0xFF89, 0xFFD2, 0xFFF7, 0x0072, 0x0020, 0x003B, 0xFFB1,
    0xFF6A, 0x0037, 0x006F, 0x0001, 0x0014, 0xFFB4, 0xFFD5, 0x0005,
    0xFFD1, 0x0014, 0xFFED, 0x0001, 0xFFEE, 0x0035, 0xFFF9, 0xFFEA,
    0xFFE5, 0xFF6C, 0xFFB1, 0xFFEA, 0x0042, 0xFF82, 0x0009, 0xFFAF,
    0x0059, 0x0017, 0xFFCC, 0xFFF7, 0x006B, 0x0088, 0x003E, 0x0007,
    0xFFEB, 0xFFE4, 0x0012, 0x006B, 0x0022, 0x003B, 0x0067, 0xFFA1,
    0x0037, 0x2C70, 0xFFB5, 0xFFAF, 0xFF80, 0xFFC1, 0x0024, 0xFFDC,
    0xFFD9, 0xFF93, 0xFFF0, 0xFFE7, 0x002D, 0xFFAB, 0x0029, 0x0017,
    0xFFD6, 0xFFD3, 0xFFC8, 0xFF95, 0x0090, 0x0006, 0xFFFA, 0xFFE5,
    0x0053, 0xFFFC, 0x00C6, 0xFFCD, 0xFF67, 0x001A, 0x0016, 0x0007,
    0xFFBA, 0xFFB6, 0x0010, 0x0010, 0xFFC9, 0x0006, 0x0005, 0xFF6E,
    0x0037, 0x000B, 0xFFCF, 0x0010, 0xFFB6, 0xFFA6, 0x0071, 0x0025,
    0xFFCA, 0xFFC6, 0x001D, 0xFFAD, 0x002C, 0xFFC9, 0xFFD6, 0x000A,
    0x0006, 0x000A, 0x0047, 0x0012, 0xFF8D, 0xFF5C, 0x002E, 0x0036
    };

static const q15_t in_cfft_noisy_512[1024] = {
    0xFF9F, 0x0000, 0x3CA9, 0x0000, 0x58DC, 0x0000, 0x3886, 0x0000,
    0x07BD, 0x0000, 0xC372, 0x0000, 0xA115, 0x0000, 0xBE2C, 0x0000,
    0xFDF2, 0x0000, 0x4B79, 0x0000, 0x6664, 0x0000, 0x3681, 0x0000,
    0x0B1B, 0x0000, 0xCD47, 0x0000, 0xA1D9, 0x0000, 0xC599, 0x0000,
    0xF928, 0x0000, 0x3E52, 0x0000, 0x5B35, 0x0000, 0x3DBC, 0x0000,
    0x0239, 0x0000, 0xBC29, 0x0000, 0x9BF6, 0x0000, 0xC5E6, 0x0000,
    0xFFA3, 0x0000, 0x363E, 0x0000, 0x5BE1, 0x0000, 0x3CF3, 0x0000,
    0x06FB, 0x0000, 0xC3C5, 0x0000, 0x9F12, 0x0000, 0xD1BC, 0x0000,
    0xFE64, 0x0000, 0x431A, 0x0000, 0x6585, 0x0000, 0x3C9C, 0x0000,
    0x04E0, 0x0000, 0xBEE1, 0x0000, 0xA438, 0x0000, 0xC228, 0x0000,
    0xF6E4, 0x0000, 0x3849, 0x0000, 0x612F, 0x0000, 0x397A, 0x0000,
    0xFB1A, 0x0000, 0xC676, 0x0000, 0xAC99, 0x0000, 0xBCAC, 0x0000,
    0x0267, 0x0000, 0x4AF9, 0x0000, 0x5BA5, 0x0000, 0x325F, 0x0000,
    0xFA1F, 0x0000, 0xC0DC, 0x0000, 0xAA65, 0x0000, 0xC195, 0x0000,
    0x008D, 0x0000, 0x4052, 0x0000, 0x552D, 0x0000, 0x40A4, 0x0000,
    0xFEA1, 0x0000, 0xB8F6, 0x0000, 0xAC76, 0x0000, 0xCD8C, 0x0000,
    0x053F, 0x0000, 0x3FCA, 0x0000, 0x5AB3, 0x0000, 0x430D, 0x0000,
    0x01A9, 0x0000, 0xC6EC, 0x0000, 0xA1B1, 0x0000, 0xC29D, 0x0000,
    0xFA4B, 0x0000, 0x397E, 0x0000, 0x5B62, 0x0000, 0x3FC2, 0x0000,
    0x024E, 0x0000, 0xC053, 0x0000, 0xA9A7, 0x0000, 0xBDD1, 0x0000,
    0x03E7, 0x0000, 0x43AC, 0x0000, 0x587C, 0x0000, 0x49A8, 0x0000,
    0x063B, 0x0000, 0xC50B, 0x0000, 0xA6B4, 0x0000, 0xC019, 0x0000,
    0x08D9, 0x0000, 0x4378, 0x0000, 0x559C, 0x0000, 0x3F8C, 0x0000,
    0xF7AE, 0x0000, 0xB99A, 0x0000, 0xA7F6, 0x0000, 0xC2C6, 0x0000,
    0x060A, 0x0000, 0x3D8F, 0x0000, 0x58DB, 0x0000, 0x3E07, 0x0000,
    0x00D1, 0x0000, 0xC383, 0x0000, 0x9E4D, 0x0000, 0xBE3B, 0x0000,
    0xFDC3, 0x0000, 0x3E19, 0x0000, 0x5B36, 0x0000, 0x36E2, 0x0000,
    0xFC4C, 0x0000, 0xBF83, 0x0000, 0xA5BB, 0x0000, 0xC30B, 0x0000,
    0x0467, 0x0000, 0x41AC, 0x0000, 0x5CCD, 0x0000, 0x396A, 0x0000,
    0x04BE, 0x0000, 0xC954, 0x0000, 0xA489, 0x0000, 0xB7E2, 0x0000,
    0x0105, 0x0000, 0x4511, 0x0000, 0x5D11, 0x0000, 0x3960, 0x0000,
    0xF965, 0x0000, 0xC1AA, 0x0000, 0xB2A3, 0x0000, 0xBCF4, 0x0000,
    0xFEF1, 0x0000, 0x480D, 0x0000, 0x5522, 0x0000, 0x3BFE, 0x0000,
    0x0062, 0x0000, 0xBDD2, 0x0000, 0xADF5, 0x0000, 0xB8AD, 0x0000,
    0xF72E, 0x0000, 0x4888, 0x0000, 0x58A0, 0x0000, 0x450E, 0x0000,
    0x0133, 0x0000, 0xCACD, 0x0000, 0xA464, 0x0000, 0xC5B9, 0x0000,
    0x01ED, 0x0000, 0x3BEE, 0x0000, 0x59FA, 0x0000, 0x415E, 0x0000,
    0x00D9, 0x0000, 0xBDC5, 0x0000, 0x9D3F, 0x0000, 0xB543, 0x0000,
    0xFE95, 0x0000, 0x3CD3, 0x0000, 0x5970, 0x0000, 0x3B31, 0x0000,
    0x0968, 0x0000, 0xC7BC, 0x0000, 0x9EC6, 0x0000, 0xC10E, 0x0000,
    0x08D0, 0x0000, 0x427D, 0x0000, 0x5568, 0x0000, 0x377D, 0x0000,
    0xFCB8, 0x0000, 0xB236, 0x0000, 0xACF3, 0x0000, 0xC0CC, 0x0000,
    0x0483, 0x0000, 0x3D2C, 0x0000, 0x59BE, 0x0000, 0x40DB, 0x0000,
    0xFA62, 0x0000, 0xC34E, 0x0000, 0xAB86, 0x0000, 0xBBD9, 0x0000,
    0xFBED, 0x0000, 0x3F36, 0x0000, 0x5ED7, 0x0000, 0x40BB, 0x0000,
    0xF4D7, 0x0000, 0xC758, 0x0000, 0xAE53, 0x0000, 0xBE13, 0x0000,
    0x019B, 0x0000, 0x43AE, 0x0000, 0x6526, 0x0000, 0x42C4, 0x0000,
    0x0022, 0x0000, 0xBE4F, 0x0000, 0xAC60, 0x0000, 0xC1AF, 0x0000,
    0x01F1, 0x0000, 0x48C1, 0x0000, 0x5DE1, 0x0000, 0x41E7, 0x0000,
    0x00F6, 0x0000, 0xCC02, 0x0000, 0xA299, 0x0000, 0xC403, 0x0000,
    0x05B1, 0x0000, 0x4980, 0x0000, 0x57BE, 0x0000, 0x3F7C, 0x0000,
    0x0306, 0x0000, 0xBA24, 0x0000, 0x9F02, 0x0000, 0xB6E5, 0x0000,
    0xFD26, 0x0000, 0x3797, 0x0000, 0x5126, 0x0000, 0x3D1D, 0x0000,
    0x05E1, 0x0000, 0xC31F, 0x0000, 0xA7BE, 0x0000, 0xC7C7, 0x0000,
    0x01FA, 0x0000, 0x41AD, 0x0000, 0x5C67, 0x0000, 0x51FC, 0x0000,
    0x0101, 0x0000, 0xCD76, 0x0000, 0xAD00, 0x0000, 0xBBE3, 0x0000,
    0x0793, 0x0000, 0x3E70, 0x0000, 0x63AC, 0x0000, 0x40C1, 0x0000,
    0xFFCE, 0x0000, 0xC451, 0x0000, 0x9EDF, 0x0000, 0xBC2A, 0x0000,
    0x04A5, 0x0000, 0x43A9, 0x0000, 0x6431, 0x0000, 0x4114, 0x0000,
    0x09D6, 0x0000, 0xC5F2, 0x0000, 0xA478, 0x0000, 0xCBFE, 0x0000,
    0xFB37, 0x0000, 0x439E, 0x0000, 0x6298, 0x0000, 0x3AAF, 0x0000,
    0x0381, 0x0000, 0xC1A2, 0x0000, 0xA7EA, 0x0000, 0xBEFD, 0x0000,
    0xFDC9, 0x0000, 0x421C, 0x0000, 0x5961, 0x0000, 0x3EA6, 0x0000,
    0x017E, 0x0000, 0xC3BF, 0x0000, 0xABEF, 0x0000, 0xC27C, 0x0000,
    0xFAD5, 0x0000, 0x4021, 0x0000, 0x6020, 0x0000, 0x4042, 0x0000,
    0xFCA1, 0x0000, 0xBB83, 0x0000, 0xA95A, 0x0000, 0xB992, 0x0000,
    0x0AF8, 0x0000, 0x3E75, 0x0000, 0x567A, 0x0000, 0x3A49, 0x0000,
    0x02B9, 0x0000, 0xC732, 0x0000, 0xA0F3, 0x0000, 0xBF00, 0x0000,
    0x01EE, 0x0000, 0x32BA, 0x0000, 0x4A8B, 0x0000, 0x40B5, 0x0000,
    0xF5A3, 0x0000, 0xC754, 0x0000, 0xAA70, 0x0000, 0xC0FB, 0x0000,
    0x0833, 0x0000, 0x3CE4, 0x0000, 0x4B7D, 0x0000, 0x44E0, 0x0000,
    0x0022, 0x0000, 0xC4BE, 0x0000, 0xAD2E, 0x0000, 0xC6BB, 0x0000,
    0xFC4A, 0x0000, 0x3DFE, 0x0000, 0x5BAE, 0x0000, 0x3C37, 0x0000,
    0xFEA8, 0x0000, 0xBD1F, 0x0000, 0xA997, 0x0000, 0xC730, 0x0000,
    0xFF24, 0x0000, 0x39E7, 0x0000, 0x51E6, 0x0000, 0x44E9, 0x0000,
    0xFC33, 0x0000, 0xBBA3, 0x0000, 0x9FB2, 0x0000, 0xC775, 0x0000,
    0xFF6B, 0x0000, 0x4E39, 0x0000, 0x6227, 0x0000, 0x3F2D, 0x0000,
    0x0546, 0x0000, 0xBCBA, 0x0000, 0xAB9E, 0x0000, 0xBF65, 0x0000,
    0x05A3, 0x0000, 0x39B0, 0x0000, 0x55B4, 0x0000, 0x36C3, 0x0000,
    0x0436, 0x0000, 0xCAC9, 0x0000, 0xA2EF, 0x0000, 0xBC8C, 0x0000,
    0xF668, 0x0000, 0x3E73, 0x0000, 0x4C70, 0x0000, 0x3E24, 0x0000,
    0x0CC2, 0x0000, 0xC56C, 0x0000, 0xA44B, 0x0000, 0xC5DA, 0x0000,
    0x014F, 0x0000, 0x3B98, 0x0000, 0x4B23, 0x0000, 0x42D0, 0x0000,
    0x0538, 0x0000, 0xBEC1, 0x0000, 0xA74A, 0x0000, 0xB586, 0x0000,
    0x08A0, 0x0000, 0x368F, 0x0000, 0x61E2, 0x0000, 0x38D3, 0x0000,
    0x01CB, 0x0000, 0xC21F, 0x0000, 0xA0F2, 0x0000, 0xB74B, 0x0000,
    0x10D6, 0x0000, 0x4073, 0x0000, 0x584F, 0x0000, 0x3287, 0x0000,
    0x04C3, 0x0000, 0xCAE2, 0x0000, 0x9BA0, 0x0000, 0xC25B, 0x0000,
    0xF63C, 0x0000, 0x3DD2, 0x0000, 0x5BC3, 0x0000, 0x4F09, 0x0000,
    0x059F, 0x0000, 0xBA18, 0x0000, 0x97EB, 0x0000, 0xBC22, 0x0000,
    0x090C, 0x0000, 0x376C, 0x0000, 0x660D, 0x0000, 0x373A, 0x0000,
    0xFD72, 0x0000, 0xB8C4, 0x0000, 0xA64D, 0x0000, 0xB6A0, 0x0000,
    0xFE17, 0x0000, 0x3D00, 0x0000, 0x5A78, 0x0000, 0x4444, 0x0000,
    0x0502, 0x0000, 0xC6A1, 0x0000, 0xA62B, 0x0000, 0xC542, 0x0000,
    0xFE15, 0x0000, 0x45A7, 0x0000, 0x5FEF, 0x0000, 0x3BE7, 0x0000,
    0x0817, 0x0000, 0xBA0F, 0x0000, 0xA28E, 0x0000, 0xB553, 0x0000,
    0x047F, 0x0000, 0x3D37, 0x0000, 0x52CD, 0x0000, 0x4254, 0x0000,
    0xF4A1, 0x0000, 0xC20A, 0x0000, 0xA22A, 0x0000, 0xC495, 0x0000,
    0x0120, 0x0000, 0x37BB, 0x0000, 0x5BE7, 0x0000, 0x3BD4, 0x0000,
    0xFFF8, 0x0000, 0xBDF1, 0x0000, 0xA6E6, 0x0000, 0xC650, 0x0000,
    0x0014, 0x0000, 0x40AB, 0x0000, 0x5A70, 0x0000, 0x315B, 0x0000,
    0xF891, 0x0000, 0xBAA4, 0x0000, 0xAA00, 0x0000, 0xBEC4, 0x0000,
    0xFB37, 0x0000, 0x4C71, 0x0000, 0x5911, 0x0000, 0x4A17, 0x0000,
    0xF995, 0x0000, 0xC1E8, 0x0000, 0xA5E8, 0x0000, 0xBF93, 0x0000,
    0xFE42, 0x0000, 0x4047, 0x0000, 0x4F81, 0x0000, 0x400A, 0x0000,
    0x054B, 0x0000, 0xC509, 0x0000, 0x9CBF, 0x0000, 0xBF6F, 0x0000,
    0xF6F3, 0x0000, 0x347E, 0x0000, 0x5219, 0x0000, 0x33DB, 0x0000,
    0xFE51, 0x0000, 0xBA95, 0x0000, 0xA465, 0x0000, 0xB9CA, 0x0000,
    0xFAC7, 0x0000, 0x35A8, 0x0000, 0x556D, 0x0000, 0x3CC1, 0x0000,
    0xFF1E, 0x0000, 0xBBA4, 0x0000, 0xADF3, 0x0000, 0xC800, 0x0000,
    0x0504, 0x0000, 0x39EE, 0x0000, 0x56D5, 0x0000, 0x4BA8, 0x0000,
    0x02C3, 0x0000, 0xBFD5, 0x0000, 0xA17B, 0x0000, 0xC8CD, 0x0000,
    0xFF71, 0x0000, 0x3C90, 0x0000, 0x5AF0, 0x0000, 0x3BD2, 0x0000,
    0x00D8, 0x0000, 0xC50E, 0x0000, 0xAEA0, 0x0000, 0xC623, 0x0000,
    0x0782, 0x0000, 0x41E5, 0x0000, 0x5636, 0x0000, 0x3960, 0x0000,
    0x019B, 0x0000, 0xBC6C, 0x0000, 0xA57A, 0x0000, 0xBA46, 0x0000,
    0x012F, 0x0000, 0x45A9, 0x0000, 0x5C85, 0x0000, 0x464C, 0x0000,
    0x0A43, 0x0000, 0xCC4D, 0x0000, 0xB187, 0x0000, 0xBC33, 0x0000,
    0xFE44, 0x0000, 0x3F17, 0x0000, 0x5ACC, 0x0000, 0x42DC, 0x0000,
    0xFA5C, 0x0000, 0xBF4D, 0x0000, 0xA378, 0x0000, 0xC039, 0x0000,
    0x03F8, 0x0000, 0x3FD1, 0x0000, 0x5E9A, 0x0000, 0x3D64, 0x0000,
    0xF3C8, 0x0000, 0xC4D8, 0x0000, 0xA896, 0x0000, 0xB9D3, 0x0000,
    0xF19F, 0x0000, 0x3F64, 0x0000, 0x5392, 0x0000, 0x4E81, 0x0000,
    0xFCAA, 0x0000, 0xCB83, 0x0000, 0xAA13, 0x0000, 0xCAF4, 0x0000,
    0x0909, 0x0000, 0x49F9, 0x0000, 0x60E7, 0x0000, 0x3F8C, 0x0000,
    0xF21A, 0x0000, 0xC1F4, 0x0000, 0x9CFA, 0x0000, 0xC78C, 0x0000,
    0xFCC3, 0x0000, 0x4276, 0x0000, 0x541A, 0x0000, 0x3CB7, 0x0000,
    0x05FC, 0x0000, 0xBCF6, 0x0000, 0xAC09, 0x0000, 0xC59B, 0x0000
    };

static const q15_t in_cifft_noisy_512[1024] = {
    0x0047, 0x0000, 0xFFF6, 0xFFA3, 0x006F, 0x0021, 0x0012, 0xFFE2,
    0xFFE4, 0x0060, 0xFFFA, 0x0004, 0xFFC5, 0x000B, 0x0016, 0xFFBE,
    0x002F, 0xFFFA, 0x0023, 0xFFA7, 0xFFEB, 0x0047, 0x0020, 0x003B,
    0xFFDC, 0x000D, 0xFFDC, 0x001B, 0x001A, 0xFFA7, 0xFFFC, 0x0005,
    0x0026, 0x004D, 0xFFAC, 0xFFF4, 0xFFED, 0xFFFE, 0xFFDE, 0xFF82,
    0xFFAC, 0xFFA6, 0xFFE6, 0xFFE3, 0x0012, 0xFF9A, 0x0016, 0x0054,
    0xFFB8, 0xFFA7, 0x0003, 0x0005, 0x0044, 0xFFC2, 0xFFD9, 0x0005,
    0xFFEA, 0x0076, 0xFFE5, 0xFFFB, 0x0046, 0x0063, 0x001C, 0x0031,
    0x0021, 0x0014, 0x0072, 0xFFB0, 0xFFF4, 0xFFEB, 0x0036, 0x0044,
    0x0068, 0x0050, 0x0005, 0x000A, 0xFFC1, 0x007B, 0xFFD6, 0x002A,
    0xFFDA, 0x0038, 0xFFC6, 0x0022, 0xFFE5, 0x0019, 0xFFCD, 0xFFE0,
    0x0012, 0xFFCB, 0x0028, 0x002E, 0x0032, 0x0001, 0xFFEC, 0x0016,
    0x000F, 0xFFF0, 0xFFFD, 0xFF9F, 0x0012, 0x000D, 0xFFBD, 0x000E,
    0x0016, 0x000D, 0xFFD5, 0x0007, 0x000A, 0xFF96, 0x0088, 0x001F,
    0xFFF4, 0xFFFA, 0xFFFC, 0xFFEE, 0xFFFE, 0x000D, 0x0013, 0xFFCD,
    0xFFC1, 0xFFF9, 0x002F, 0xFFCC, 0xFFDE, 0x0028, 0x002B, 0x0020,
    0xFFFD, 0xD33E, 0x0009, 0xFFE7, 0x000A, 0x001A, 0xFFA6, 0xFFCD,
    0x004C, 0xFFBC, 0x000B, 0x0050, 0xFFF8, 0x0002, 0xFFC1, 0xFFF9,
    0x0026, 0x0053, 0x0007, 0x003D, 0x004A, 0x0019, 0xFFDE, 0x001D,
    0xFFF3, 0xFFF7, 0x0017, 0xFFF5, 0xFF8A, 0xFFE0, 0x0028, 0x0056,
    0xFFEF, 0x0020, 0x0022, 0xFFFD, 0x0023, 0x0039, 0xFFDF, 0x0030,
    0xFFEE, 0xFFD6, 0x0004, 0x005A, 0xFFC4, 0x0028, 0xFFBF, 0xFFE4,
    0xFFF1, 0xFFEE, 0x0002, 0x0002, 0xFF90, 0xFFE8, 0x0003, 0xFFE3,
    0x0023, 0x003C, 0xFFC8, 0xFFDF, 0xFFE8, 0xFF91, 0x0014, 0x0034,
    0xFFFA, 0xFFF5, 0x0070, 0xFFF0, 0x000D, 0x0007, 0xFFE9, 0xFFF3,
    0xFFB7, 0x0024, 0x0039, 0x0044, 0xFFDD, 0x0052, 0xFFC9, 0x000F,
    0x0027, 0x0015, 0x0042, 0x0001, 0x0011, 0x0021, 0x0018, 0x001C,
    0xFFF0, 0x0001, 0xFFE4, 0x0009, 0x001F, 0xFFE3, 0x0052, 0x0019,
    0x0004, 0x0027, 0x0038, 0x0007, 0x0015, 0x0032, 0x0036, 0xFFB0,
    0xFFEF, 0xFFAB, 0x0007, 0xFFEB, 0x0041, 0x0000, 0x001D, 0xFFA1,
    0xFFF8, 0x0043, 0x0021, 0x005C, 0x0020, 0x0023, 0x0030, 0x0031,
    0xFFC8, 0xFFBF, 0x0003, 0xFFC9, 0xFFE3, 0x004D, 0x0007, 0xFFDB,
    0x0026, 0xFFB8, 0xFFA7, 0x003A, 0xFFEF, 0xFFE1, 0x0022, 0xFFE5,
    0x0006, 0xFFEB, 0xFFEC, 0xFFC7, 0x0045, 0xFFFA, 0x0057, 0x0031,
    0xFFE5, 0xFF79, 0xFFD4, 0x0035, 0x0000, 0xFFB0, 0xFFF0, 0xFF9B,
    0xFFDF, 0x0010, 0x002B, 0x0008, 0xFF6C, 0x0044, 0xFFD2, 0x0022,
    0x0017, 0x0023, 0x0006, 0x007B, 0xFFD7, 0xFFED, 0x0047, 0xFFF2,
    0xFFFA, 0xFFF0, 0xFFD7, 0xFFDE, 0x0035, 0x002A, 0xFFD5, 0xFFFF,
    0xFFCB, 0x0028, 0x001A, 0x0011, 0xFFFB, 0x001F, 0xFFFC, 0xFFE2,
    0x0028, 0x003D, 0x0042, 0x000C, 0xFFF1, 0x0018, 0x0012, 0xFFF9,
    0xFFD4, 0x0015, 0x0009, 0xFFF4, 0xFFC0, 0x0035, 0xFFFB, 0xFFFB,
    0x0026, 0x0010, 0xFFC8, 0xFFDC, 0x0009, 0x0020, 0x000A, 0xFFDE,
    0x001A, 0xFFF1, 0xFFDC, 0x002B, 0xFFD7, 0xFFBD, 0x0030, 0xFFF9,
    0x0027, 0xFFB7, 0xFFF4, 0x0001, 0xFFF4, 0xFFE3, 0x0009, 0x0015,
    0xFFCD, 0xFFD9, 0xFFC7, 0x0015, 0x0002, 0x0030, 0x003B, 0x0018,
    0xFFF9, 0xFFFA, 0xFFE3, 0xFFB2, 0xFFD4, 0x001A, 0x0015, 0xFFC9,
    0xFFE1, 0xFFF1, 0xFFC7, 0xFFC6, 0xFFE5, 0x001C, 0xFF9B, 0xFFAA,
    0xFFF1, 0xFFEA, 0xFFA5, 0x000C, 0xFFC0, 0x000B, 0xFFD3, 0x0020,
    0x0008, 0x0038, 0xFFC6, 0x0026, 0x0013, 0x0047, 0x003B, 0x0049,
    0xFFEE, 0x005F, 0x002A, 0x003F, 0x0033, 0x000C, 0x0029, 0x0035,
    0xFFB7, 0xFFB9, 0x001C, 0x0040, 0xFFA7, 0xFFF8, 0x0028, 0xFFEF,
    0x0004, 0xFF84, 0xFFA2, 0x0051, 0xFFFD, 0xFFF6, 0x0001, 0xFFF9,
    0x0016, 0x0007, 0x0011, 0x001F, 0x0016, 0x0037, 0xFF67, 0xFFC5,
    0x0008, 0xFFBF, 0x0050, 0xFFFB, 0xFFFA, 0x001A, 0x001F, 0xFFD3,
    0x0008, 0xFFD1, 0x000F, 0xFFC0, 0x002D, 0xFFCF, 0x0005, 0xFFE4,
    0xFFD8, 0xFFBD, 0x0039, 0x000E, 0x000E, 0x0006, 0x0011, 0xFFF6,
    0xFFF3, 0x0006, 0x0030, 0xFFE1, 0xFFEF, 0x0050, 0xFFAA, 0xFFE3,
    0x0029, 0x001C, 0x007C, 0x0015, 0xFFB8, 0x001B, 0x000B, 0x001D,
    0x001B, 0xFFB7, 0x0019, 0x004C, 0xFFB7, 0x0006, 0x001D, 0xFFA2,
    0x0038, 0x0040, 0xFFF0, 0xFFAD, 0x0054, 0x0008, 0x0009, 0x004F,
    0xFFD2, 0x0000, 0x0006, 0xFFB9, 0x002B, 0x0030, 0x003B, 0xFFFF,
    0x0058, 0x0012, 0x0000, 0x001D, 0x001C, 0x0031, 0x0030, 0xFFFA,
    0x0019, 0xFFFE, 0xFFE8, 0x0040, 0x001C, 0x003B, 0xFFA8, 0x0036,
    0xFFF0, 0xFFEA, 0x000E, 0x001C, 0xFFC0, 0x001E, 0xFFD6, 0xFFFB,
    0xFFFD, 0x0000, 0xFFD6, 0x0005, 0xFFC0, 0xFFE2, 0x000E, 0xFFE4,
    0xFFF0, 0x0016, 0xFFA8, 0xFFCA, 0x001C, 0xFFC5, 0xFFE8, 0xFFC0,
    0x0019, 0x0002, 0x0030, 0x0006, 0x001C, 0xFFCF, 0x0000, 0xFFE3,
    0x0058, 0xFFEE, 0x003B, 0x0001, 0x002B, 0xFFD0, 0x0006, 0x0047,
    0xFFD2, 0x0000, 0x0009, 0xFFB1, 0x0054, 0xFFF8, 0xFFF0, 0x0053,
    0x0038, 0xFFC0, 0x001D, 0x005E, 0xFFB7, 0xFFFA, 0x0019, 0xFFB4,
    0x001B, 0x0049, 0x000B, 0xFFE3, 0xFFB8, 0xFFE5, 0x007C, 0xFFEB,
    0x0029, 0xFFE4, 0xFFAA, 0x001D, 0xFFEF, 0xFFB0, 0x0030, 0x001F,
    0xFFF3, 0xFFFA, 0x0011, 0x000A, 0x000E, 0xFFFA, 0x0039, 0xFFF2,
    0xFFD8, 0x0043, 0x0005, 0x001C, 0x002D, 0x0031, 0x000F, 0x0040,
    0x0008, 0x002F, 0x001F, 0x002D, 0xFFFA, 0xFFE6, 0x0050, 0x0005,
    0x0008, 0x0041, 0xFF67, 0x003B, 0x0016, 0xFFC9, 0x0011, 0xFFE1,
    0x0016, 0xFFF9, 0x0001, 0x0007, 0xFFFD, 0x000A, 0xFFA2, 0xFFAF,
    0x0004, 0x007C, 0x0028, 0x0011, 0xFFA7, 0x0008, 0x001C, 0xFFC0,
    0xFFB7, 0x0047, 0x0029, 0xFFCB, 0x0033, 0xFFF4, 0x002A, 0xFFC1,
    0xFFEE, 0xFFA1, 0x003B, 0xFFB7, 0x0013, 0xFFB9, 0xFFC6, 0xFFDA,
    0x0008, 0xFFC8, 0xFFD3, 0xFFE0, 0xFFC0, 0xFFF5, 0xFFA5, 0xFFF4,
    0xFFF1, 0x0016, 0xFF9B, 0x0056, 0xFFE5, 0xFFE4, 0xFFC7, 0x003A,
    0xFFE1, 0x000F, 0x0015, 0x0037, 0xFFD4, 0xFFE6, 0xFFE3, 0x004E,
    0xFFF9, 0x0006, 0x003B, 0xFFE8, 0x0002, 0xFFD0, 0xFFC7, 0xFFEB,
    0xFFCD, 0x0027, 0x0009, 0xFFEB, 0xFFF4, 0x001D, 0xFFF4, 0xFFFF,
    0x0027, 0x0049, 0x0030, 0x0007, 0xFFD7, 0x0043, 0xFFDC, 0xFFD5,
    0x001A, 0x000F, 0x000A, 0x0022, 0x0009, 0xFFE0, 0xFFC8, 0x0024,
    0x0026, 0xFFF0, 0xFFFB, 0x0005, 0xFFC0, 0xFFCB, 0x0009, 0x000C,
    0xFFD4, 0xFFEB, 0x0012, 0x0007, 0xFFF1, 0xFFE8, 0x0042, 0xFFF4,
    0x0028, 0xFFC3, 0xFFFC, 0x001E, 0xFFFB, 0xFFE1, 0x001A, 0xFFEF,
    0xFFCB, 0xFFD8, 0xFFD5, 0x0001, 0x0035, 0xFFD6, 0xFFD7, 0x0022,
    0xFFFA, 0x0010, 0x0047, 0x000E, 0xFFD7, 0x0013, 0x0006, 0xFF85,
    0x0017, 0xFFDD, 0xFFD2, 0xFFDE, 0xFF6C, 0xFFBC, 0x002B, 0xFFF8,
    0xFFDF, 0xFFF0, 0xFFF0, 0x0065, 0x0000, 0x0050, 0xFFD4, 0xFFCB,
    0xFFE5, 0x0087, 0x0057, 0xFFCF, 0x0045, 0x0006, 0xFFEC, 0x0039,
    0x0006, 0x0015, 0x0022, 0x001B, 0xFFEF, 0x001F, 0xFFA7, 0xFFC6,
    0x0026, 0x0048, 0x0007, 0x0025, 0xFFE3, 0xFFB3, 0x0003, 0x0037,
    0xFFC8, 0x0041, 0x0030, 0xFFCF, 0x0020, 0xFFDD, 0x0021, 0xFFA4,
    0xFFF8, 0xFFBD, 0x001D, 0x005F, 0x0041, 0x0000, 0x0007, 0x0015,
    0xFFEF, 0x0055, 0x0036, 0x0050, 0x0015, 0xFFCE, 0x0038, 0xFFF9,
    0x0004, 0xFFD9, 0x0052, 0xFFE7, 0x001F, 0x001D, 0xFFE4, 0xFFF7,
    0xFFF0, 0xFFFF, 0x0018, 0xFFE4, 0x0011, 0xFFDF, 0x0042, 0xFFFF,
    0x0027, 0xFFEB, 0xFFC9, 0xFFF1, 0xFFDD, 0xFFAE, 0x0039, 0xFFBC,
    0xFFB7, 0xFFDC, 0xFFE9, 0x000D, 0x000D, 0xFFF9, 0x0070, 0x0010,
    0xFFFA, 0x000B, 0x0014, 0xFFCC, 0xFFE8, 0x006F, 0xFFC8, 0x0021,
    0x0023, 0xFFC4, 0x0003, 0x001D, 0xFF90, 0x0018, 0x0002, 0xFFFE,
    0xFFF1, 0x0012, 0xFFBF, 0x001C, 0xFFC4, 0xFFD8, 0x0004, 0xFFA6,
    0xFFEE, 0x002A, 0xFFDF, 0xFFD0, 0x0023, 0xFFC7, 0x0022, 0x0003,
    0xFFEF, 0xFFE0, 0x0028, 0xFFAA, 0xFF8A, 0x0020, 0x0017, 0x000B,
    0xFFF3, 0x0009, 0xFFDE, 0xFFE3, 0x004A, 0xFFE7, 0x0007, 0xFFC3,
    0x0026, 0xFFAD, 0xFFC1, 0x0007, 0xFFF8, 0xFFFE, 0x000B, 0xFFB0,
    0x004C, 0x0044, 0xFFA6, 0x0033, 0x000A, 0xFFE6, 0x0009, 0x0019,
    0xFFFD, 0x2CC2, 0x002B, 0xFFE0, 0xFFDE, 0xFFD8, 0x002F, 0x0034,
    0xFFC1, 0x0007, 0x0013, 0x0033, 0xFFFE, 0xFFF3, 0xFFFC, 0x0012,
    0xFFF4, 0x0006, 0x0088, 0xFFE1, 0x000A, 0x006A, 0xFFD5, 0xFFF9,
    0x0016, 0xFFF3, 0xFFBD, 0xFFF2, 0x0012, 0xFFF3, 0xFFFD, 0x0061,
    0x000F, 0x0010, 0xFFEC, 0xFFEA, 0x0032, 0xFFFF, 0x0028, 0xFFD2,
    0x0012, 0x0035, 0xFFCD, 0x0020, 0xFFE5, 0xFFE7, 0xFFC6, 0xFFDE,
    0xFFDA, 0xFFC8, 0xFFD6, 0xFFD6, 0xFFC1, 0xFF85, 0x0005, 0xFFF6,
    0x0068, 0xFFB0, 0x0036, 0xFFBC, 0xFFF4, 0x0015, 0x0072, 0x0050,
    0x0021, 0xFFEC, 0x001C, 0xFFCF, 0x0046, 0xFF9D, 0xFFE5, 0x0005,
    0xFFEA, 0xFF8A, 0xFFD9, 0xFFFB, 0x0044, 0x003E, 0x0003, 0xFFFB,
    0xFFB8, 0x0059, 0x0016, 0xFFAC, 0x0012, 0x0066, 0xFFE6, 0x001D,
    0xFFAC, 0x005A, 0xFFDE, 0x007E, 0xFFED, 0x0002, 0xFFAC, 0x000C,
    0x0026, 0xFFB3, 0xFFFC, 0xFFFB, 0x001A, 0x0059, 0xFFDC, 0xFFE5,
    0xFFDC, 0xFFF3, 0x0020, 0xFFC5, 0xFFEB, 0xFFB9, 0x0023, 0x0059,
    0x002F, 0x0006, 0x0016, 0x0042, 0xFFC5, 0xFFF5, 0xFFFA, 0xFFFC,
    0xFFE4, 0xFFA0, 0x0012, 0x001E, 0x006F, 0xFFDF, 0xFFF6, 0x005D
    };

static const q15_t ref_cfft_noisy_512[1024] = {
    0x0047, 0x0000, 0xFFF6, 0xFFA3, 0x006F, 0x0021, 0x0012, 0xFFE2,
    0xFFE4, 0x0060, 0xFFFA, 0x0004, 0xFFC5, 0x000B, 0x0016, 0xFFBE,
    0x002F, 0xFFFA, 0x0023, 0xFFA7, 0xFFEB, 0x0047, 0x0020, 0x003B,
    0xFFDC, 0x000D, 0xFFDC, 0x001B, 0x001A, 0xFFA7, 0xFFFC, 0x0005,
    0x0026, 0x004D, 0xFFAC, 0xFFF4, 0xFFED, 0xFFFE, 0xFFDE, 0xFF82,
    0xFFAC, 0xFFA6, 0xFFE6, 0xFFE3, 0x0012, 0xFF9A, 0x0016, 0x0054,
    0xFFB8, 0xFFA7, 0x0003, 0x0005, 0x0044, 0xFFC2, 0xFFD9, 0x0005,
    0xFFEA, 0x0076, 0xFFE5, 0xFFFB, 0x0046, 0x0063, 0x001C, 0x0031,
    0x0021, 0x0014, 0x0072, 0xFFB0, 0xFFF4, 0xFFEB, 0x0036, 0x0044,
    0x0068, 0x0050, 0x0005, 0x000A, 0xFFC1, 0x007B, 0xFFD6, 0x002A,
    0xFFDA, 0x0038, 0xFFC6, 0x0022, 0xFFE5, 0x0019, 0xFFCD, 0xFFE0,
    0x0012, 0xFFCB, 0x0028, 0x002E, 0x0032, 0x0001, 0xFFEC, 0x0016,
    0x000F, 0xFFF0, 0xFFFD, 0xFF9F, 0x0012, 0x000D, 0xFFBD, 0x000E,
    0x0016, 0x000D, 0xFFD5, 0x0007, 0x000A, 0xFF96, 0x0088, 0x001F,
    0xFFF4, 0xFFFA, 0xFFFC, 0xFFEE, 0xFFFE, 0x000D, 0x0013, 0xFFCD,
    0xFFC1, 0xFFF9, 0x002F, 0xFFCC, 0xFFDE, 0x0028, 0x002B, 0x0020,
    0xFFFD, 0xD33E, 0x0009, 0xFFE7, 0x000A, 0x001A, 0xFFA6, 0xFFCD,
    0x004C, 0xFFBC, 0x000B, 0x0050, 0xFFF8, 0x0002, 0xFFC1, 0xFFF9,
    0x0026, 0x0053, 0x0007, 0x003D, 0x004A, 0x0019, 0xFFDE, 0x001D,
    0xFFF3, 0xFFF7, 0x0017, 0xFFF5, 0xFF8A, 0xFFE0, 0x0028, 0x0056,
    0xFFEF, 0x0020, 0x0022, 0xFFFD, 0x0023, 0x0039, 0xFFDF, 0x0030,
    0xFFEE, 0xFFD6, 0x0004, 0x005A, 0xFFC4, 0x0028, 0xFFBF, 0xFFE4,
    0xFFF1, 0xFFEE, 0x0002, 0x0002, 0xFF90, 0xFFE8, 0x0003, 0xFFE3,
    0x0023, 0x003C, 0xFFC8, 0xFFDF, 0xFFE8, 0xFF91, 0x0014, 0x0034,
    0xFFFA, 0xFFF5, 0x0070, 0xFFF0, 0x000D, 0x0007, 0xFFE9, 0xFFF3,
    0xFFB7, 0x0024, 0x0039, 0x0044, 0xFFDD, 0x0052, 0xFFC9, 0x000F,
    0x0027, 0x0015, 0x0042, 0x0001, 0x0011, 0x0021, 0x0018, 0x001C,
    0xFFF0, 0x0001, 0xFFE4, 0x0009, 0x001F, 0xFFE3, 0x0052, 0x0019,
    0x0004, 0x0027, 0x0038, 0x0007, 0x0015, 0x0032, 0x0036, 0xFFB0,
    0xFFEF, 0xFFAB, 0x0007, 0xFFEB, 0x0041, 0x0000, 0x001D, 0xFFA1,
    0xFFF8, 0x0043, 0x0021, 0x005C, 0x0020, 0x0023, 0x0030, 0x0031,
    0xFFC8, 0xFFBF, 0x0003, 0xFFC9, 0xFFE3, 0x004D, 0x0007, 0xFFDB,
    0x0026, 0xFFB8, 0xFFA7, 0x003A, 0xFFEF, 0xFFE1, 0x0022, 0xFFE5,
    0x0006, 0xFFEB, 0xFFEC, 0xFFC7, 0x0045, 0xFFFA, 0x0057, 0x0031,
    0xFFE5, 0xFF79, 0xFFD4, 0x0035, 0x0000, 0xFFB0, 0xFFF0, 0xFF9B,
    0xFFDF, 0x0010, 0x002B, 0x0008, 0xFF6C, 0x0044, 0xFFD2, 0x0022,
    0x0017, 0x0023, 0x0006, 0x007B, 0xFFD7, 0xFFED, 0x0047, 0xFFF2,
    0xFFFA, 0xFFF0, 0xFFD7, 0xFFDE, 0x0035, 0x002A, 0xFFD5, 0xFFFF,
    0xFFCB, 0x0028, 0x001A, 0x0011, 0xFFFB, 0x001F, 0xFFFC, 0xFFE2,
    0x0028, 0x003D, 0x0042, 0x000C, 0xFFF1, 0x0018, 0x0012, 0xFFF9,
    0xFFD4, 0x0015, 0x0009, 0xFFF4, 0xFFC0, 0x0035, 0xFFFB, 0xFFFB,
    0x0026, 0x0010, 0xFFC8, 0xFFDC, 0x0009, 0x0020, 0x000A, 0xFFDE,
    0x001A, 0xFFF1, 0xFFDC, 0x002B, 0xFFD7, 0xFFBD, 0x0030, 0xFFF9,
    0x0027, 0xFFB7, 0xFFF4, 0x0001, 0xFFF4, 0xFFE3, 0x0009, 0x0015,
    0xFFCD, 0xFFD9, 0xFFC7, 0x0015, 0x0002, 0x0030, 0x003B, 0x0018,
    0xFFF9, 0xFFFA, 0xFFE3, 0xFFB2, 0xFFD4, 0x001A, 0x0015, 0xFFC9,
    0xFFE1, 0xFFF1, 0xFFC7, 0xFFC6, 0xFFE5, 0x001C, 0xFF9B, 0xFFAA,
    0xFFF1, 0xFFEA, 0xFFA5, 0x000C, 0xFFC0, 0x000B, 0xFFD3, 0x0020,
    0x0008, 0x0038, 0xFFC6, 0x0026, 0x0013, 0x0047, 0x003B, 0x0049,
    0xFFEE, 0x005F, 0x002A, 0x003F, 0x0033, 0x000C, 0x0029, 0x0035,
    0xFFB7, 0xFFB9, 0x001C, 0x0040, 0xFFA7, 0xFFF8, 0x0028, 0xFFEF,
    0x0004, 0xFF84, 0xFFA2, 0x0051, 0xFFFD, 0xFFF6, 0x0001, 0xFFF9,
    0x0016, 0x0007, 0x0011, 0x001F, 0x0016, 0x0037, 0xFF67, 0xFFC5,
    0x0008, 0xFFBF, 0x0050, 0xFFFB, 0xFFFA, 0x001A, 0x001F, 0xFFD3,
    0x0008, 0xFFD1, 0x000F, 0xFFC0, 0x002D, 0xFFCF, 0x0005, 0xFFE4,
    0xFFD8, 0xFFBD, 0x0039, 0x000E, 0x000E, 0x0006, 0x0011, 0xFFF6,
    0xFFF3, 0x0006, 0x0030, 0xFFE1, 0xFFEF, 0x0050, 0xFFAA, 0xFFE3,
    0x0029, 0x001C, 0x007C, 0x0015, 0xFFB8, 0x001B, 0x000B, 0x001D,
    0x001B, 0xFFB7, 0x0019, 0x004C, 0xFFB7, 0x0006, 0x001D, 0xFFA2,
    0x0038, 0x0040, 0xFFF0, 0xFFAD, 0x0054, 0x0008, 0x0009, 0x004F,
    0xFFD2, 0x0000, 0x0006, 0xFFB9, 0x002B, 0x0030, 0x003B, 0xFFFF,
    0x0058, 0x0012, 0x0000, 0x001D, 0x001C, 0x0031, 0x0030, 0xFFFA,
    0x0019, 0xFFFE, 0xFFE8, 0x0040, 0x001C, 0x003B, 0xFFA8, 0x0036,
    0xFFF0, 0xFFEA, 0x000E, 0x001C, 0xFFC0, 0x001E, 0xFFD6, 0xFFFB,
    0xFFFD, 0x0000, 0xFFD6, 0x0005, 0xFFC0, 0xFFE2, 0x000E, 0xFFE4,
    0xFFF0, 0x0016, 0xFFA8, 0xFFCA, 0x001C, 0xFFC5, 0xFFE8, 0xFFC0,
    0x0019, 0x0002, 0x0030, 0x0006, 0x001C, 0xFFCF, 0x0000, 0xFFE3,
    0x0058, 0xFFEE, 0x003B, 0x0001, 0x002B, 0xFFD0, 0x0006, 0x0047,
    0xFFD2, 0x0000, 0x0009, 0xFFB1, 0x0054, 0xFFF8, 0xFFF0, 0x0053,
    0x0038, 0xFFC0, 0x001D, 0x005E, 0xFFB7, 0xFFFA, 0x0019, 0xFFB4,
    0x001B, 0x0049, 0x000B, 0xFFE3, 0xFFB8, 0xFFE5, 0x007C, 0xFFEB,
    0x0029, 0xFFE4, 0xFFAA, 0x001D, 0xFFEF, 0xFFB0, 0x0030, 0x001F,
    0xFFF3, 0xFFFA, 0x0011, 0x000A, 0x000E, 0xFFFA, 0x0039, 0xFFF2,
    0xFFD8, 0x0043, 0x0005, 0x001C, 0x002D, 0x0031, 0x000F, 0x0040,
    0x0008, 0x002F, 0x001F, 0x002D, 0xFFFA, 0xFFE6, 0x0050, 0x0005,
    0x0008, 0x0041, 0xFF67, 0x003B, 0x0016, 0xFFC9, 0x0011, 0xFFE1,
    0x0016, 0xFFF9, 0x0001, 0x0007, 0xFFFD, 0x000A, 0xFFA2, 0xFFAF,
    0x0004, 0x007C, 0x0028, 0x0011, 0xFFA7, 0x0008, 0x001C, 0xFFC0,
    0xFFB7, 0x0047, 0x0029, 0xFFCB, 0x0033, 0xFFF4, 0x002A, 0xFFC1,
    0xFFEE, 0xFFA1, 0x003B, 0xFFB7, 0x0013, 0xFFB9, 0xFFC6, 0xFFDA,
    0x0008, 0xFFC8, 0xFFD3, 0xFFE0, 0xFFC0, 0xFFF5, 0xFFA5, 0xFFF4,
    0xFFF1, 0x0016, 0xFF9B, 0x0056, 0xFFE5, 0xFFE4, 0xFFC7, 0x003A,
    0xFFE1, 0x000F, 0x0015, 0x0037, 0xFFD4, 0xFFE6, 0xFFE3, 0x004E,
    0xFFF9, 0x0006, 0x003B, 0xFFE8, 0x0002, 0xFFD0, 0xFFC7, 0xFFEB,
    0xFFCD, 0x0027, 0x0009, 0xFFEB, 0xFFF4, 0x001D, 0xFFF4, 0xFFFF,
    0x0027, 0x0049, 0x0030, 0x0007, 0xFFD7, 0x0043, 0xFFDC, 0xFFD5,
    0x001A, 0x000F, 0x000A, 0x0022, 0x0009, 0xFFE0, 0xFFC8, 0x0024,
    0x0026, 0xFFF0, 0xFFFB, 0x0005, 0xFFC0, 0xFFCB, 0x0009, 0x000C,
    0xFFD4, 0xFFEB, 0x0012, 0x0007, 0xFFF1, 0xFFE8, 0x0042, 0xFFF4,
    0x0028, 0xFFC3, 0xFFFC, 0x001E, 0xFFFB, 0xFFE1, 0x001A, 0xFFEF,
    0xFFCB, 0xFFD8, 0xFFD5, 0x0001, 0x0035, 0xFFD6, 0xFFD7, 0x0022,
    0xFFFA, 0x0010, 0x0047, 0x000E, 0xFFD7, 0x0013, 0x0006, 0xFF85,
    0x0017, 0xFFDD, 0xFFD2, 0xFFDE, 0xFF6C, 0xFFBC, 0x002B, 0xFFF8,
    0xFFDF, 0xFFF0, 0xFFF0, 0x0065, 0x0000, 0x0050, 0xFFD4, 0xFFCB,
    0xFFE5, 0x0087, 0x0057, 0xFFCF, 0x0045, 0x0006, 0xFFEC, 0x0039,
    0x0006, 0x0015, 0x0022, 0x001B, 0xFFEF, 0x001F, 0xFFA7, 0xFFC6,
    0x0026, 0x0048, 0x0007, 0x0025, 0xFFE3, 0xFFB3, 0x0003, 0x0037,
    0xFFC8, 0x0041, 0x0030, 0xFFCF, 0x0020, 0xFFDD, 0x0021, 0xFFA4,
    0xFFF8, 0xFFBD, 0x001D, 0x005F, 0x0041, 0x0000, 0x0007, 0x0015,
    0xFFEF, 0x0055, 0x0036, 0x0050, 0x0015, 0xFFCE, 0x0038, 0xFFF9,
    0x0004, 0xFFD9, 0x0052, 0xFFE7, 0x001F, 0x001D, 0xFFE4, 0xFFF7,
    0xFFF0, 0xFFFF, 0x0018, 0xFFE4, 0x0011, 0xFFDF, 0x0042, 0xFFFF,
    0x0027, 0xFFEB, 0xFFC9, 0xFFF1, 0xFFDD, 0xFFAE, 0x0039, 0xFFBC,
    0xFFB7, 0xFFDC, 0xFFE9, 0x000D, 0x000D, 0xFFF9, 0x0070, 0x0010,
    0xFFFA, 0x000B, 0x0014, 0xFFCC, 0xFFE8, 0x006F, 0xFFC8, 0x0021,
    0x0023, 0xFFC4, 0x0003, 0x001D, 0xFF90, 0x0018, 0x0002, 0xFFFE,
    0xFFF1, 0x0012, 0xFFBF, 0x001C, 0xFFC4, 0xFFD8, 0x0004, 0xFFA6,
    0xFFEE, 0x002A, 0xFFDF, 0xFFD0, 0x0023, 0xFFC7, 0x0022, 0x0003,
    0xFFEF, 0xFFE0, 0x0028, 0xFFAA, 0xFF8A, 0x0020, 0x0017, 0x000B,
    0xFFF3, 0x0009, 0xFFDE, 0xFFE3, 0x004A, 0xFFE7, 0x0007, 0xFFC3,
    0x0026, 0xFFAD, 0xFFC1, 0x0007, 0xFFF8, 0xFFFE, 0x000B, 0xFFB0,
    0x004C, 0x0044, 0xFFA6, 0x0033, 0x000A, 0xFFE6, 0x0009, 0x0019,
    0xFFFD, 0x2CC2, 0x002B, 0xFFE0, 0xFFDE, 0xFFD8, 0x002F, 0x0034,
    0xFFC1, 0x0007, 0x0013, 0x0033, 0xFFFE, 0xFFF3, 0xFFFC, 0x0012,
    0xFFF4, 0x0006, 0x0088, 0xFFE1, 0x000A, 0x006A, 0xFFD5, 0xFFF9,
    0x0016, 0xFFF3, 0xFFBD, 0xFFF2, 0x0012, 0xFFF3, 0xFFFD, 0x0061,
    0x000F, 0x0010, 0xFFEC, 0xFFEA, 0x0032, 0xFFFF, 0x0028, 0xFFD2,
    0x0012, 0x0035, 0xFFCD, 0x0020, 0xFFE5, 0xFFE7, 0xFFC6, 0xFFDE,
    0xFFDA, 0xFFC8, 0xFFD6, 0xFFD6, 0xFFC1, 0xFF85, 0x0005, 0xFFF6,
    0x0068, 0xFFB0, 0x0036, 0xFFBC, 0xFFF4, 0x0015, 0x0072, 0x0050,
    0x0021, 0xFFEC, 0x001C, 0xFFCF, 0x0046, 0xFF9D, 0xFFE5, 0x0005,
    0xFFEA, 0xFF8A, 0xFFD9, 0xFFFB, 0x0044, 0x003E, 0x0003, 0xFFFB,
    0xFFB8, 0x0059, 0x0016, 0xFFAC, 0x0012, 0x0066, 0xFFE6, 0x001D,
    0xFFAC, 0x005A, 0xFFDE, 0x007E, 0xFFED, 0x0002, 0xFFAC, 0x000C,
    0x0026, 0xFFB3, 0xFFFC, 0xFFFB, 0x001A, 0x0059, 0xFFDC, 0xFFE5,
    0xFFDC, 0xFFF3, 0x0020, 0xFFC5, 0xFFEB, 0xFFB9, 0x0023, 0x0059,
    0x002F, 0x0006, 0x0016, 0x0042, 0xFFC5, 0xFFF5, 0xFFFA, 0xFFFC,
    0xFFE4, 0xFFA0, 0x0012, 0x001E, 0x006F, 0xFFDF, 0xFFF6, 0x005D
    };

static const q15_t in_cfft_noisy_1024[2048] = {
    0xFFE3, 0x0000, 0x49A9, 0x0000, 0x5A21, 0x0000, 0x3610, 0x0000,
    0x0A91, 0x0000, 0xB4B2, 0x0000, 0xAC2D, 0x0000, 0xC782, 0x0000,
    0xFF0E, 0x0000, 0x3E3D, 0x0000, 0x5D68, 0x0000, 0x40CA, 0x0000,
    0xFE37, 0x0000, 0xC626, 0x0000, 0xA2FE, 0x0000, 0xC3CC, 0x0000,
    0x04F2, 0x0000, 0x3833, 0x0000, 0x6201, 0x0000, 0x389D, 0x0000,
    0xFBF8, 0x0000, 0xC096, 0x0000, 0x9F6C, 0x0000, 0xCBCC, 0x0000,
    0x01E2, 0x0000, 0x3598, 0x0000, 0x50F2, 0x0000, 0x413B, 0x0000,
    0xFEFF, 0x0000, 0xBEFA, 0x0000, 0x9C59, 0x0000, 0xC0DC, 0x0000,
    0x02B2, 0x0000, 0x3FC8, 0x0000, 0x542C, 0x0000, 0x488E, 0x0000,
    0x0A1A, 0x0000, 0xBA2D, 0x0000, 0xA7B8, 0x0000, 0xC16B, 0x0000,
    0x069B, 0x0000, 0x46F2, 0x0000, 0x5D4D, 0x0000, 0x3D9B, 0x0000,
    0x0917, 0x0000, 0xB5D9, 0x0000, 0xA723, 0x0000, 0xC23D, 0x0000,
    0xFBD1, 0x0000, 0x3E7E, 0x0000, 0x5186, 0x0000, 0x3A31, 0x0000,
    0xFE0A, 0x0000, 0xB4E6, 0x0000, 0xA41E, 0x0000, 0xC443, 0x0000,
    0x00EF, 0x0000, 0x40A9, 0x0000, 0x5E87, 0x0000, 0x3750, 0x0000,
    0xFA85, 0x0000, 0xC106, 0x0000, 0xA74D, 0x0000, 0xBEBC, 0x0000,
    0xF7DC, 0x0000, 0x41F0, 0x0000, 0x55B1, 0x0000, 0x3E2B, 0x0000,
    0xFCAA, 0x0000, 0xBC06, 0x0000, 0xAB70, 0x0000, 0xC456, 0x0000,
    0xFC16, 0x0000, 0x486F, 0x0000, 0x644C, 0x0000, 0x4640, 0x0000,
    0xFD76, 0x0000, 0xBFB9, 0x0000, 0xA31C, 0x0000, 0xD04D, 0x0000,
    0x09CD, 0x0000, 0x45BC, 0x0000, 0x57FC, 0x0000, 0x3D8B, 0x0000,
    0x0C03, 0x0000, 0xB911, 0x0000, 0xAC65, 0x0000, 0xB79A, 0x0000,
    0x062D, 0x0000, 0x3F8D, 0x0000, 0x5565, 0x0000, 0x4129, 0x0000,
    0xFB73, 0x0000, 0xBA8A, 0x0000, 0xA0FB, 0x0000, 0xAF35, 0x0000,
    0xFE4A, 0x0000, 0x3CAC, 0x0000, 0x5725, 0x0000, 0x3A4E, 0x0000,
    0xF8D7, 0x0000, 0xBE40, 0x0000, 0x9F1E, 0x0000, 0xBD55, 0x0000,
    0x0072, 0x0000, 0x3BDF, 0x0000, 0x5B67, 0x0000, 0x4604, 0x0000,
    0x01AE, 0x0000, 0xBBE0, 0x0000, 0x9875, 0x0000, 0xBCE8, 0x0000,
    0xF764, 0x0000, 0x3C72, 0x0000, 0x5368, 0x0000, 0x3E5E, 0x0000,
    0x075C, 0x0000, 0xC3A2, 0x0000, 0xA8E9, 0x0000, 0xB894, 0x0000,
    0x013A, 0x0000, 0x4414, 0x0000, 0x62A7, 0x0000, 0x4271, 0x0000,
    0x0612, 0x0000, 0xBE5A, 0x0000, 0xA945, 0x0000, 0xC6B1, 0x0000,
    0xF724, 0x0000, 0x42EA, 0x0000, 0x59BC, 0x0000, 0x3F3E, 0x0000,
    0xF2E9, 0x0000, 0xBBFA, 0x0000, 0xAFA9, 0x0000, 0xBDCD, 0x0000,
    0xFB01, 0x0000, 0x45CD, 0x0000, 0x65A3, 0x0000, 0x35BE, 0x0000,
    0x0815, 0x0000, 0xC42E, 0x0000, 0xA571, 0x0000, 0xC1B7, 0x0000,
    0xF942, 0x0000, 0x3E59, 0x0000, 0x611E, 0x0000, 0x3F48, 0x0000,
    0xFC4B, 0x0000, 0xC547, 0x0000, 0xA596, 0x0000, 0xC292, 0x0000,
    0x03AB, 0x0000, 0x422F, 0x0000, 0x64D0, 0x0000, 0x3413, 0x0000,
    0x067E, 0x0000, 0xC4B6, 0x0000, 0xA21F, 0x0000, 0xBD1D, 0x0000,
    0xF99F, 0x0000, 0x44F1, 0x0000, 0x5B43, 0x0000, 0x36CC, 0x0000,
    0x04F8, 0x0000, 0xBB88, 0x0000, 0xA6BD, 0x0000, 0xC495, 0x0000,
    0xF5D6, 0x0000, 0x467B, 0x0000, 0x5EC6, 0x0000, 0x4604, 0x0000,
    0xFAAF, 0x0000, 0xAF61, 0x0000, 0xABC7, 0x0000, 0xB441, 0x0000,
    0x0630, 0x0000, 0x36E9, 0x0000, 0x66A5, 0x0000, 0x478E, 0x0000,
    0x00A3, 0x0000, 0xCA6D, 0x0000, 0xA376, 0x0000, 0xCBB3, 0x0000,
    0x09AD, 0x0000, 0x4727, 0x0000, 0x5FA5, 0x0000, 0x3C61, 0x0000,
    0xFD59, 0x0000, 0xBEC1, 0x0000, 0x9CB5, 0x0000, 0xB30A, 0x0000,
    0x0534, 0x0000, 0x405E, 0x0000, 0x63CA, 0x0000, 0x3A6B, 0x0000,
    0xFEF6, 0x0000, 0xBC12, 0x0000, 0xA26C, 0x0000, 0xBC29, 0x0000,
    0x01BC, 0x0000, 0x474B, 0x0000, 0x559F, 0x0000, 0x39EC, 0x0000,
    0xFD07, 0x0000, 0xB905, 0x0000, 0xA3AA, 0x0000, 0xC207, 0x0000,
    0x0636, 0x0000, 0x41BC, 0x0000, 0x5E50, 0x0000, 0x4EBB, 0x0000,
    0xFF9E, 0x0000, 0xBD1D, 0x0000, 0xA471, 0x0000, 0xC3A3, 0x0000,
    0xFDBD, 0x0000, 0x4250, 0x0000, 0x5814, 0x0000, 0x404D, 0x0000,
    0xFF17, 0x0000, 0xC36E, 0x0000, 0xA8BA, 0x0000, 0xBEED, 0x0000,
    0x07EB, 0x0000, 0x3991, 0x0000, 0x5FA8, 0x0000, 0x40B6, 0x0000,
    0x04C9, 0x0000, 0xC2D1, 0x0000, 0xA309, 0x0000, 0xC515, 0x0000,
    0x0021, 0x0000, 0x3BAE, 0x0000, 0x5D8F, 0x0000, 0x445B, 0x0000,
    0xFF16, 0x0000, 0xBA13, 0x0000, 0xA350, 0x0000, 0xC3C6, 0x0000,
    0x0CDB, 0x0000, 0x2D8D, 0x0000, 0x6570, 0x0000, 0x44AC, 0x0000,
    0xF91A, 0x0000, 0xB973, 0x0000, 0xA83C, 0x0000, 0xC995, 0x0000,
    0x0030, 0x0000, 0x4250, 0x0000, 0x4C6C, 0x0000, 0x4B7A, 0x0000,
    0xFA1D, 0x0000, 0xC89D, 0x0000, 0xA4AD, 0x0000, 0xC3B7, 0x0000,
    0x0970, 0x0000, 0x4909, 0x0000, 0x6178, 0x0000, 0x3A64, 0x0000,
    0x0594, 0x0000, 0xC5CE, 0x0000, 0xAB61, 0x0000, 0xBEB0, 0x0000,
    0x007C, 0x0000, 0x3BD9, 0x0000, 0x49C0, 0x0000, 0x37D1, 0x0000,
    0x0081, 0x0000, 0xC75B, 0x0000, 0xA8EC, 0x0000, 0xBE7F, 0x0000,
    0x02D5, 0x0000, 0x481E, 0x0000, 0x5B03, 0x0000, 0x3143, 0x0000,
    0x09D7, 0x0000, 0xBE93, 0x0000, 0xB08C, 0x0000, 0xBD97, 0x0000,
    0xF8F3, 0x0000, 0x3EC9, 0x0000, 0x5C87, 0x0000, 0x38B9, 0x0000,
    0xFBCC, 0x0000, 0xB547, 0x0000, 0xAFFB, 0x0000, 0xCFF8, 0x0000,
    0xFCDC, 0x0000, 0x37D1, 0x0000, 0x57E3, 0x0000, 0x430A, 0x0000,
    0x0007, 0x0000, 0xC34B, 0x0000, 0xA282, 0x0000, 0xBF4F, 0x0000,
    0x0B4A, 0x0000, 0x3E3B, 0x0000, 0x635F, 0x0000, 0x3722, 0x0000,
    0x0AB7, 0x0000, 0xC776, 0x0000, 0xB364, 0x0000, 0xBD5B, 0x0000,
    0xF562, 0x0000, 0x4153, 0x0000, 0x5276, 0x0000, 0x461A, 0x0000,
    0xFC2B, 0x0000, 0xC798, 0x0000, 0xA117, 0x0000, 0xB928, 0x0000,
    0x0247, 0x0000, 0x43F1, 0x0000, 0x57A7, 0x0000, 0x3DEB, 0x0000,
    0xFD6E, 0x0000, 0xBFB9, 0x0000, 0xA26A, 0x0000, 0xBB1A, 0x0000,
    0xF999, 0x0000, 0x3E6A, 0x0000, 0x5A25, 0x0000, 0x41ED, 0x0000,
    0xFDF9, 0x0000, 0xBB07, 0x0000, 0xAB14, 0x0000, 0xB785, 0x0000,
    0xF668, 0x0000, 0x3525, 0x0000, 0x6465, 0x0000, 0x377B, 0x0000,
    0xFF5A, 0x0000, 0xB92B, 0x0000, 0xA21A, 0x0000, 0xC4FB, 0x0000,
    0x0290, 0x0000, 0x3CD2, 0x0000, 0x539F, 0x0000, 0x4462, 0x0000,
    0x02F6, 0x0000, 0xC2B8, 0x0000, 0xA916, 0x0000, 0xBDD0, 0x0000,
    0x0735, 0x0000, 0x4702, 0x0000, 0x58C0, 0x0000, 0x34EF, 0x0000,
    0x0375, 0x0000, 0xC486, 0x0000, 0xA375, 0x0000, 0xCA0D, 0x0000,
    0xFFDD, 0x0000, 0x3B93, 0x0000, 0x5F0F, 0x0000, 0x3BE1, 0x0000,
    0x0655, 0x0000, 0xB534, 0x0000, 0xA7DD, 0x0000, 0xBA62, 0x0000,
    0xFA4F, 0x0000, 0x3C9C, 0x0000, 0x595A, 0x0000, 0x40C9, 0x0000,
    0x06B3, 0x0000, 0xC328, 0x0000, 0xA1D4, 0x0000, 0xCE98, 0x0000,
    0xF885, 0x0000, 0x429C, 0x0000, 0x51F3, 0x0000, 0x46F5, 0x0000,
    0x0296, 0x0000, 0xC3BA, 0x0000, 0xA354, 0x0000, 0xAFE5, 0x0000,
    0xF6E2, 0x0000, 0x3F1C, 0x0000, 0x5CE5, 0x0000, 0x403F, 0x0000,
    0xFC83, 0x0000, 0xB7EB, 0x0000, 0xA46C, 0x0000, 0xB853, 0x0000,
    0x00DC, 0x0000, 0x4329, 0x0000, 0x6756, 0x0000, 0x3FC6, 0x0000,
    0x0052, 0x0000, 0xBF8F, 0x0000, 0xA801, 0x0000, 0xC58D, 0x0000,
    0xFE40, 0x0000, 0x3CAC, 0x0000, 0x5C26, 0x0000, 0x448A, 0x0000,
    0x0331, 0x0000, 0xBCF4, 0x0000, 0xA6F0, 0x0000, 0xBEE7, 0x0000,
    0x0610, 0x0000, 0x3946, 0x0000, 0x5005, 0x0000, 0x4088, 0x0000,
    0x037F, 0x0000, 0xC1F6, 0x0000, 0xA9D3, 0x0000, 0xCA3D, 0x0000,
    0x0980, 0x0000, 0x3E7E, 0x0000, 0x63CB, 0x0000, 0x456F, 0x0000,
    0xF705, 0x0000, 0xC77F, 0x0000, 0x9F3C, 0x0000, 0xC2DD, 0x0000,
    0x0064, 0x0000, 0x4B5A, 0x0000, 0x5DC0, 0x0000, 0x3FE2, 0x0000,
    0x0241, 0x0000, 0xBC86, 0x0000, 0xA83E, 0x0000, 0xC4E9, 0x0000,
    0x078B, 0x0000, 0x4338, 0x0000, 0x4BB7, 0x0000, 0x4872, 0x0000,
    0x061F, 0x0000, 0xC4B7, 0x0000, 0xA050, 0x0000, 0xBAF1, 0x0000,
    0xFC64, 0x0000, 0x400C, 0x0000, 0x5F8B, 0x0000, 0x3678, 0x0000,
    0xFD31, 0x0000, 0xB4F0, 0x0000, 0xA907, 0x0000, 0xC39D, 0x0000,
    0xFDA4, 0x0000, 0x35CE, 0x0000, 0x5AB5, 0x0000, 0x4242, 0x0000,
    0xF894, 0x0000, 0xBC88, 0x0000, 0xAE58, 0x0000, 0xC40A, 0x0000,
    0xFDA8, 0x0000, 0x3FE0, 0x0000, 0x5660, 0x0000, 0x37F0, 0x0000,
    0xFEFB, 0x0000, 0xBBEA, 0x0000, 0xAF41, 0x0000, 0xC05F, 0x0000,
    0xF1DF, 0x0000, 0x4061, 0x0000, 0x5ECC, 0x0000, 0x49D0, 0x0000,
    0xF99D, 0x0000, 0xB50B, 0x0000, 0xA4F1, 0x0000, 0xC77E, 0x0000,
    0xFB25, 0x0000, 0x3D3E, 0x0000, 0x5E73, 0x0000, 0x3896, 0x0000,
    0x0729, 0x0000, 0xC1D8, 0x0000, 0xA4BE, 0x0000, 0xBE72, 0x0000,
    0xF679, 0x0000, 0x3983, 0x0000, 0x5516, 0x0000, 0x43A2, 0x0000,
    0x0675, 0x0000, 0xB460, 0x0000, 0xA6C1, 0x0000, 0xBCB7, 0x0000,
    0x0D2D, 0x0000, 0x3D1D, 0x0000, 0x5478, 0x0000, 0x4C97, 0x0000,
    0x0351, 0x0000, 0xC2F1, 0x0000, 0xB6EA, 0x0000, 0xC246, 0x0000,
    0xFE0D, 0x0000, 0x488F, 0x0000, 0x5FFE, 0x0000, 0x44D6, 0x0000,
    0xFE95, 0x0000, 0xC0F3, 0x0000, 0xABC7, 0x0000, 0xC500, 0x0000,
    0xF796, 0x0000, 0x3F23, 0x0000, 0x54DE, 0x0000, 0x417A, 0x0000,
    0x0C3E, 0x0000, 0xC675, 0x0000, 0x9B95, 0x0000, 0xC9E5, 0x0000,
    0x0123, 0x0000, 0x4D2E, 0x0000, 0x5BC9, 0x0000, 0x43D2, 0x0000,
    0xFED2, 0x0000, 0xC9D0, 0x0000, 0xABC0, 0x0000, 0xC2DC, 0x0000,
    0xFCD9, 0x0000, 0x3DFB, 0x0000, 0x5772, 0x0000, 0x4E69, 0x0000,
    0x04A2, 0x0000, 0xC189, 0x0000, 0x9DA4, 0x0000, 0xBD56, 0x0000,
    0x00AB, 0x0000, 0x4C7E, 0x0000, 0x622A, 0x0000, 0x4E5B, 0x0000,
    0x0511, 0x0000, 0xBC48, 0x0000, 0xA69C, 0x0000, 0xB25E, 0x0000,
    0xF6CD, 0x0000, 0x3775, 0x0000, 0x4EC7, 0x0000, 0x4080, 0x0000,
    0x0100, 0x0000, 0xBF84, 0x0000, 0x9F07, 0x0000, 0xBD39, 0x0000,
    0x0213, 0x0000, 0x3D1D, 0x0000, 0x5B18, 0x0000, 0x3A2E, 0x0000,
    0x104C, 0x0000, 0xBDEB, 0x0000, 0x9CAA, 0x0000, 0xB791, 0x0000,
    0x0211, 0x0000, 0x39D7, 0x0000, 0x5C33, 0x0000, 0x3B63, 0x0000,
    0x026D, 0x0000, 0xBB97, 0x0000, 0xA51D, 0x0000, 0xC2C5, 0x0000,
    0xF86D, 0x0000, 0x4539, 0x0000, 0x5C9A, 0x0000, 0x3254, 0x0000,
    0x0546, 0x0000, 0xBEDD, 0x0000, 0xA08F, 0x0000, 0xD27C, 0x0000,
    0xF936, 0x0000, 0x362F, 0x0000, 0x57C1, 0x0000, 0x443E, 0x0000,
    0xFE51, 0x0000, 0xB84F, 0x0000, 0xA8C9, 0x0000, 0xCB95, 0x0000,
    0x0A22, 0x0000, 0x3F59, 0x0000, 0x5412, 0x0000, 0x44A2, 0x0000,
    0xFE8C, 0x0000, 0xBAF3, 0x0000, 0xAA69, 0x0000, 0xB9CF, 0x0000,
    0xF9CB, 0x0000, 0x466D, 0x0000, 0x5F5A, 0x0000, 0x2FC6, 0x0000,
    0x0CFF, 0x0000, 0xC5A9, 0x0000, 0x9F64, 0x0000, 0xBD58, 0x0000,
    0x031D, 0x0000, 0x39FF, 0x0000, 0x511A, 0x0000, 0x3AD0, 0x0000,
    0xF69D, 0x0000, 0xC42F, 0x0000, 0xA425, 0x0000, 0xC940, 0x0000,
    0xFD5D, 0x0000, 0x3929, 0x0000, 0x556C, 0x0000, 0x3A0E, 0x0000,
    0xF96F, 0x0000, 0xBDDA, 0x0000, 0xA207, 0x0000, 0xC25B, 0x0000,
    0xF9DD, 0x0000, 0x4066, 0x0000, 0x5BB2, 0x0000, 0x454D, 0x0000,
    0x047D, 0x0000, 0xBDD1, 0x0000, 0x9FAF, 0x0000, 0xBBD4, 0x0000,
    0x0127, 0x0000, 0x3A99, 0x0000, 0x5C84, 0x0000, 0x3B73, 0x0000,
    0xFCB7, 0x0000, 0xC769, 0x0000, 0xB190, 0x0000, 0xCBE4, 0x0000,
    0xFE73, 0x0000, 0x41F5, 0x0000, 0x5331, 0x0000, 0x3E16, 0x0000,
    0xFA38, 0x0000, 0xBD2A, 0x0000, 0x9B76, 0x0000, 0xC7F9, 0x0000,
    0xF5A9, 0x0000, 0x3A7C, 0x0000, 0x56A7, 0x0000, 0x391E, 0x0000,
    0xFCAB, 0x0000, 0xC5BB, 0x0000, 0xA7E6, 0x0000, 0xC89C, 0x0000,
    0x0958, 0x0000, 0x4446, 0x0000, 0x5BD5, 0x0000, 0x47D9, 0x0000,
    0xFBBF, 0x0000, 0xCB29, 0x0000, 0x9D7C, 0x0000, 0xC559, 0x0000,
    0xFD47, 0x0000, 0x401D, 0x0000, 0x5C92, 0x0000, 0x3CAC, 0x0000,
    0xF734, 0x0000, 0xC913, 0x0000, 0xAD37, 0x0000, 0xC200, 0x0000,
    0xF1F1, 0x0000, 0x3FF8, 0x0000, 0x5AD2, 0x0000, 0x38A8, 0x0000,
    0x06A9, 0x0000, 0xBB91, 0x0000, 0xA828, 0x0000, 0xCC48, 0x0000,
    0xFCC4, 0x0000, 0x43FB, 0x0000, 0x5642, 0x0000, 0x38B8, 0x0000,
    0xF9FB, 0x0000, 0xC535, 0x0000, 0xAA58, 0x0000, 0xC58B, 0x0000,
    0xFF5E, 0x0000, 0x403F, 0x0000, 0x5989, 0x0000, 0x4047, 0x0000,
    0x04C6, 0x0000, 0xC5DA, 0x0000, 0xA558, 0x0000, 0xBCD9, 0x0000,
    0x09F6, 0x0000, 0x4391, 0x0000, 0x54E4, 0x0000, 0x42B9, 0x0000,
    0x0049, 0x0000, 0xBEE6, 0x0000, 0xA924, 0x0000, 0xC299, 0x0000,
    0xF97C, 0x0000, 0x4A42, 0x0000, 0x574F, 0x0000, 0x47A2, 0x0000,
    0x093C, 0x0000, 0xBB93, 0x0000, 0xA96F, 0x0000, 0xC6CC, 0x0000,
    0x0079, 0x0000, 0x4318, 0x0000, 0x5A9A, 0x0000, 0x408B, 0x0000,
    0x0197, 0x0000, 0xC934, 0x0000, 0xA6D6, 0x0000, 0xBFDB, 0x0000,
    0x02E9, 0x0000, 0x407B, 0x0000, 0x5ED4, 0x0000, 0x334E, 0x0000,
    0x0309, 0x0000, 0xC5DC, 0x0000, 0xA832, 0x0000, 0xC079, 0x0000,
    0x0290, 0x0000, 0x4AA5, 0x0000, 0x5C36, 0x0000, 0x4A8C, 0x0000,
    0xFFF8, 0x0000, 0xC30D, 0x0000, 0xA94F, 0x0000, 0xC6D4, 0x0000,
    0xFA2F, 0x0000, 0x3B2B, 0x0000, 0x5B74, 0x0000, 0x39AD, 0x0000,
    0x0962, 0x0000, 0xBDD4, 0x0000, 0x97D5, 0x0000, 0xC0EB, 0x0000,
    0x0001, 0x0000, 0x43EF, 0x0000, 0x4DB2, 0x0000, 0x4672, 0x0000,
    0x0906, 0x0000, 0xBF93, 0x0000, 0xA17B, 0x0000, 0xC430, 0x0000,
    0xF75D, 0x0000, 0x41FC, 0x0000, 0x64A1, 0x0000, 0x41EC, 0x0000,
    0x003B, 0x0000, 0xBA97, 0x0000, 0xABA7, 0x0000, 0xD09A, 0x0000,
    0x03CE, 0x0000, 0x45B7, 0x0000, 0x5756, 0x0000, 0x3F1F, 0x0000,
    0xF9FF, 0x0000, 0xC511, 0x0000, 0xAA58, 0x0000, 0xC2B6, 0x0000,
    0x07DE, 0x0000, 0x470B, 0x0000, 0x50E8, 0x0000, 0x44BB, 0x0000,
    0xF683, 0x0000, 0xC7A4, 0x0000, 0xA2DC, 0x0000, 0xBBB7, 0x0000,
    0x00CC, 0x0000, 0x4321, 0x0000, 0x5A02, 0x0000, 0x3F86, 0x0000,
    0x090D, 0x0000, 0xBB50, 0x0000, 0xA445, 0x0000, 0xC36E, 0x0000,
    0xFA32, 0x0000, 0x42CF, 0x0000, 0x5ED1, 0x0000, 0x40CE, 0x0000,
    0xFFEC, 0x0000, 0xC465, 0x0000, 0xAB03, 0x0000, 0xBF3F, 0x0000,
    0xFF6C, 0x0000, 0x3F4D, 0x0000, 0x588B, 0x0000, 0x3F13, 0x0000,
    0x02F9, 0x0000, 0xC4A9, 0x0000, 0xA629, 0x0000, 0xD05B, 0x0000,
    0x0448, 0x0000, 0x49F1, 0x0000, 0x5326, 0x0000, 0x3FCB, 0x0000,
    0x0599, 0x0000, 0xBD5D, 0x0000, 0xA73B, 0x0000, 0xD0A8, 0x0000,
    0xF720, 0x0000, 0x3C51, 0x0000, 0x5C1B, 0x0000, 0x47EA, 0x0000,
    0xF594, 0x0000, 0xC262, 0x0000, 0xA647, 0x0000, 0xC018, 0x0000,
    0x01D5, 0x0000, 0x3A1A, 0x0000, 0x54A6, 0x0000, 0x4354, 0x0000,
    0x0856, 0x0000, 0xBD7C, 0x0000, 0xA0BA, 0x0000, 0xC9F7, 0x0000,
    0xFFB8, 0x0000, 0x4973, 0x0000, 0x62E7, 0x0000, 0x3602, 0x0000,
    0xFBB1, 0x0000, 0xC0BD, 0x0000, 0x9E87, 0x0000, 0xC2FA, 0x0000,
    0x0549, 0x0000, 0x4336, 0x0000, 0x57BA, 0x0000, 0x3BDC, 0x0000,
    0x0069, 0x0000, 0xBD8C, 0x0000, 0x9D02, 0x0000, 0xB1E2, 0x0000,
    0x0653, 0x0000, 0x3F13, 0x0000, 0x63B1, 0x0000, 0x4093, 0x0000,
    0xFDCA, 0x0000, 0xB3A9, 0x0000, 0xA634, 0x0000, 0xC805, 0x0000,
    0x026C, 0x0000, 0x3A11, 0x0000, 0x5562, 0x0000, 0x45FE, 0x0000,
    0x0CCC, 0x0000, 0xB632, 0x0000, 0xA399, 0x0000, 0xC115, 0x0000,
    0x0190, 0x0000, 0x33AF, 0x0000, 0x5C76, 0x0000, 0x441A, 0x0000,
    0xF99A, 0x0000, 0xC5B2, 0x0000, 0x9CAD, 0x0000, 0xC030, 0x0000,
    0x0BBC, 0x0000, 0x3733, 0x0000, 0x5799, 0x0000, 0x41E5, 0x0000,
    0xFEE5, 0x0000, 0xC0BD, 0x0000, 0xA6E2, 0x0000, 0xC369, 0x0000,
    0x0615, 0x0000, 0x42CB, 0x0000, 0x6473, 0x0000, 0x422D, 0x0000,
    0xFF6D, 0x0000, 0xCBEA, 0x0000, 0xB3C7, 0x0000, 0xBD90, 0x0000,
    0xFEFE, 0x0000, 0x3613, 0x0000, 0x5C48, 0x0000, 0x3F1D, 0x0000,
    0x03D1, 0x0000, 0xC688, 0x0000, 0xAB26, 0x0000, 0xC655, 0x0000,
    0x0323, 0x0000, 0x4044, 0x0000, 0x5F83, 0x0000, 0x4101, 0x0000,
    0xFB24, 0x0000, 0xB999, 0x0000, 0xA71C, 0x0000, 0xC9A3, 0x0000,
    0x06BF, 0x0000, 0x4095, 0x0000, 0x5BEF, 0x0000, 0x31B4, 0x0000,
    0x0221, 0x0000, 0xBA32, 0x0000, 0xAA57, 0x0000, 0xC312, 0x0000,
    0xFFD5, 0x0000, 0x40B3, 0x0000, 0x5560, 0x0000, 0x3F2F, 0x0000,
    0xFD4C, 0x0000, 0xC27F, 0x0000, 0xA866, 0x0000, 0xBE94, 0x0000,
    0x02DB, 0x0000, 0x3D2C, 0x0000, 0x5C5D, 0x0000, 0x4377, 0x0000,
    0x0440, 0x0000, 0xC3F6, 0x0000, 0xA72F, 0x0000, 0xCF4B, 0x0000,
    0x03D0, 0x0000, 0x486B, 0x0000, 0x5E37, 0x0000, 0x3398, 0x0000,
    0xFB28, 0x0000, 0xC8D9, 0x0000, 0xA227, 0x0000, 0xC377, 0x0000,
    0xFBEC, 0x0000, 0x398E, 0x0000, 0x5433, 0x0000, 0x4362, 0x0000,
    0xFAAF, 0x0000, 0xBE88, 0x0000, 0xA2FE, 0x0000, 0xB61B, 0x0000,
    0x0278, 0x0000, 0x3D5A, 0x0000, 0x59BB, 0x0000, 0x3F00, 0x0000,
    0x0116, 0x0000, 0xBEA9, 0x0000, 0xA629, 0x0000, 0xC7C3, 0x0000,
    0xF78F, 0x0000, 0x4007, 0x0000, 0x56D3, 0x0000, 0x3D93, 0x0000,
    0xF691, 0x0000, 0xC377, 0x0000, 0xA643, 0x0000, 0xBA3A, 0x0000,
    0x03D4, 0x0000, 0x413A, 0x0000, 0x5D4E, 0x0000, 0x3464, 0x0000,
    0xF667, 0x0000, 0xBBD3, 0x0000, 0xA85D, 0x0000, 0xC926, 0x0000,
    0xFD7A, 0x0000, 0x4094, 0x0000, 0x55C0, 0x0000, 0x5011, 0x0000,
    0x036B, 0x0000, 0xB283, 0x0000, 0xA0F3, 0x0000, 0xC39F, 0x0000,
    0x033C, 0x0000, 0x421F, 0x0000, 0x5930, 0x0000, 0x3EDA, 0x0000,
    0x03CC, 0x0000, 0xC102, 0x0000, 0xA807, 0x0000, 0xC405, 0x0000,
    0x0675, 0x0000, 0x407D, 0x0000, 0x55F3, 0x0000, 0x40A4, 0x0000,
    0x007D, 0x0000, 0xB807, 0x0000, 0xA709, 0x0000, 0xC0C5, 0x0000,
    0xFBB7, 0x0000, 0x3C0C, 0x0000, 0x5B0B, 0x0000, 0x3408, 0x0000,
    0x0218, 0x0000, 0xC645, 0x0000, 0xA7C9, 0x0000, 0xBCB3, 0x0000,
    0x00F1, 0x0000, 0x41FF, 0x0000, 0x54EE, 0x0000, 0x3829, 0x0000,
    0x05A6, 0x0000, 0xCEBD, 0x0000, 0x9F71, 0x0000, 0xB293, 0x0000,
    0xF657, 0x0000, 0x2FFD, 0x0000, 0x570B, 0x0000, 0x3B0E, 0x0000,
    0xFB9F, 0x0000, 0xBCB6, 0x0000, 0xA0BA, 0x0000, 0xC62A, 0x0000,
    0xF968, 0x0000, 0x4938, 0x0000, 0x5B5C, 0x0000, 0x39D6, 0x0000,
    0x0513, 0x0000, 0xB3DC, 0x0000, 0xA914, 0x0000, 0xB2C6, 0x0000,
    0xF943, 0x0000, 0x38FC, 0x0000, 0x616C, 0x0000, 0x45DE, 0x0000,
    0x0854, 0x0000, 0xC03C, 0x0000, 0xA004, 0x0000, 0xC6A0, 0x0000,
    0xFE4F, 0x0000, 0x3F9C, 0x0000, 0x5AAD, 0x0000, 0x43C5, 0x0000,
    0x055F, 0x0000, 0xB5D9, 0x0000, 0xAF68, 0x0000, 0xC4C8, 0x0000,
    0x060E, 0x0000, 0x3C6A, 0x0000, 0x58F9, 0x0000, 0x3293, 0x0000,
    0xFC0A, 0x0000, 0xC74C, 0x0000, 0xABA5, 0x0000, 0xC4DA, 0x0000,
    0x0900, 0x0000, 0x3F0A, 0x0000, 0x5AF3, 0x0000, 0x3FCB, 0x0000,
    0xFB95, 0x0000, 0xBA37, 0x0000, 0xB1FF, 0x0000, 0xBC2E, 0x0000
    };

static const q15_t in_cifft_noisy_1024[2048] = {
    0x0032, 0x0000, 0xFFE5, 0x001F, 0xFFBD, 0xFFF6, 0xFFF4, 0xFFDE,
    0x0025, 0x0033, 0x0000, 0xFFC5, 0x0038, 0xFFE5, 0x0003, 0x000A,
    0x0046, 0xFFFC, 0xFFD2, 0xFFF9, 0x0000, 0x001A, 0xFFE8, 0xFFCF,
    0x0043, 0x002E, 0x002E, 0xFFFC, 0x0024, 0x004D, 0x0029, 0xFFD7,
    0x0008, 0x0020, 0x000E, 0xFFF9, 0x0018, 0xFFF1, 0xFF9D, 0x001B,
    0xFFDC, 0x001E, 0xFFCC, 0xFFF7, 0xFFE5, 0x001E, 0x0006, 0x0028,
    0x0041, 0xFFF1, 0x0023, 0x000A, 0xFFF5, 0x0026, 0x0022, 0x000F,
    0x0018, 0xFFB0, 0x0021, 0xFFCB, 0xFFED, 0xFFCB, 0xFFD6, 0xFFDC,
    0x0028, 0x0001, 0xFFD7, 0x0033, 0x000D, 0xFFDB, 0xFFDB, 0xFFF0,
    0x000A, 0xFFDB, 0xFFF1, 0xFFFF, 0xFFF3, 0x000B, 0x001A, 0x000A,
    0x0024, 0x0001, 0xFFEB, 0xFFFC, 0x001D, 0x0004, 0xFFA4, 0x0038,
    0xFFD4, 0x0005, 0x001C, 0xFFCD, 0xFFD2, 0xFFF5, 0xFFFA, 0x0033,
    0x000F, 0x0030, 0x0003, 0x0003, 0x0019, 0x002F, 0x001E, 0xFFE8,
    0x000C, 0xFFFB, 0x0027, 0xFFE1, 0xFFC5, 0xFFE0, 0x0053, 0x0027,
    0xFFEB, 0x000C, 0x001B, 0xFFF0, 0x001A, 0x0024, 0x0004, 0x0018,
    0xFFED, 0x0001, 0xFFFE, 0x0000, 0xFFB2, 0xFFF0, 0x0000, 0x0002,
    0xFFB4, 0xFFF3, 0xFFEB, 0xFFFA, 0xFFBA, 0x0051, 0x0022, 0x0005,
    0x001C, 0xFFEE, 0xFFF5, 0xFFAE, 0xFFF0, 0xFFDA, 0x0002, 0x0007,
    0x0018, 0x0028, 0x0021, 0xFFE4, 0xFFF7, 0x0005, 0x001A, 0xFFE4,
    0xFFFB, 0xFFF4, 0xFFDD, 0xFFF0, 0x0043, 0x0043, 0xFFF8, 0x0000,
    0xFFF8, 0xFFD8, 0xFFF6, 0x0007, 0xFFF5, 0x0017, 0x0020, 0x0009,
    0xFFE5, 0x001B, 0xFFF9, 0x000D, 0xFFF5, 0x0010, 0xFFF4, 0x0006,
    0x0018, 0x0025, 0xFFD5, 0xFFF3, 0x001C, 0xFFF9, 0xFFBC, 0xFFE5,
    0x0002, 0xFFE4, 0xFFD2, 0xFFD1, 0x0011, 0xFFAE, 0x0032, 0x0027,
    0x0025, 0xFFED, 0xFFE7, 0x0006, 0xFFFB, 0xFFED, 0x001D, 0xFFA4,
    0xFFF5, 0x0018, 0xFFE7, 0xFFE0, 0x0023, 0xFFE9, 0x001E, 0x000F,
    0xFFF8, 0xFFDB, 0x0018, 0x0003, 0x0035, 0xFFF6, 0x0004, 0x0012,
    0x001D, 0xFFE6, 0xFFDA, 0x0004, 0x0025, 0x0022, 0xFFE8, 0x0025,
    0xFFE7, 0xFFEE, 0x0014, 0x0004, 0x004A, 0xFFE5, 0x0010, 0x002C,
    0x001B, 0x0001, 0x0005, 0xFFF7, 0xFFFF, 0xFFC2, 0x000B, 0xFFFA,
    0xFFFB, 0x0037, 0x000C, 0x0057, 0xFFF2, 0x0001, 0x0002, 0x0023,
    0xFFE2, 0x0006, 0x0037, 0x002C, 0xFFFB, 0x0009, 0x0054, 0xFFDE,
    0x0026, 0xD305, 0x0006, 0x0002, 0xFFD8, 0xFFF6, 0xFFCF, 0x0035,
    0x000F, 0x0000, 0x005E, 0xFFDE, 0xFFBF, 0xFFC0, 0x001D, 0x0019,
    0xFFF4, 0x000A, 0x0014, 0x000B, 0x0000, 0xFFD3, 0x0028, 0x0014,
    0x001A, 0x001F, 0x0018, 0xFFEF, 0xFFFB, 0x003D, 0x005C, 0x002A,
    0x0016, 0x001C, 0xFFEA, 0x000C, 0xFFFB, 0x001F, 0xFFE6, 0xFFF8,
    0xFFE6, 0x0025, 0x002B, 0x0000, 0xFFE7, 0xFFFC, 0xFFDB, 0x001D,
    0x0002, 0xFFDD, 0x000E, 0xFFFB, 0xFFE2, 0xFFF7, 0xFFD4, 0xFFCC,
    0x0011, 0xFFF4, 0x0012, 0x000C, 0xFFDD, 0xFFEF, 0xFFDE, 0x0007,
    0x000C, 0xFFE3, 0x0000, 0x0011, 0xFFE0, 0x001B, 0x0002, 0x0008,
    0xFFCC, 0x0031, 0xFFF3, 0x000D, 0xFFC2, 0x0004, 0x002D, 0xFFE9,
    0x002A, 0xFFEA, 0xFFFA, 0xFFFC, 0x0031, 0x0007, 0xFFCD, 0xFFF0,
    0xFFC6, 0xFFF7, 0xFFF6, 0xFFD1, 0x0013, 0x0009, 0x0036, 0xFFE5,
    0xFFFD, 0x0024, 0x000B, 0xFFBB, 0x0005, 0x0033, 0x0041, 0xFFF8,
    0x000D, 0xFFEF, 0x001F, 0xFFE8, 0x0023, 0xFFEE, 0x002E, 0x0000,
    0x0043, 0xFFEC, 0xFFE8, 0x000C, 0xFFDF, 0x001D, 0x0005, 0xFFE9,
    0xFFBC, 0x0003, 0x000B, 0x001F, 0x0000, 0x0010, 0xFFBF, 0xFFD2,
    0x0021, 0xFFE1, 0x0023, 0xFFEA, 0x001E, 0x000C, 0x001B, 0xFFFE,
    0xFFDE, 0x0044, 0xFFD4, 0xFF8F, 0xFFF4, 0x0033, 0x001A, 0xFFE5,
    0xFFDD, 0x001C, 0x0008, 0xFFBE, 0xFFE5, 0xFFFA, 0x005C, 0x000E,
    0xFFF6, 0xFFEF, 0x0005, 0xFFF1, 0xFFF5, 0x000B, 0x0022, 0x0031,
    0xFFF2, 0xFFE7, 0xFFEF, 0x001C, 0x000B, 0x005B, 0x0005, 0xFFD6,
    0xFFC0, 0xFFE6, 0xFFE0, 0x0010, 0xFFD1, 0x0010, 0x000D, 0xFFCD,
    0xFFE8, 0x002C, 0x0034, 0x004F, 0x0015, 0xFFE1, 0x0019, 0x0011,
    0x0029, 0x0041, 0xFFBD, 0xFFF5, 0x0037, 0xFFEA, 0x000B, 0x0000,
    0xFFE6, 0xFFBC, 0xFFDB, 0x002B, 0xFFC5, 0xFFCC, 0xFFD5, 0x0033,
    0x0042, 0x000C, 0x0054, 0xFFFC, 0xFFD6, 0x0004, 0xFFD9, 0x002F,
    0xFFF2, 0xFFE6, 0x0014, 0xFFC2, 0xFFDC, 0x0005, 0x0013, 0xFFF3,
    0xFFF7, 0xFFF1, 0xFFBF, 0xFF6F, 0xFFEB, 0xFFF3, 0x002B, 0xFFE8,
    0xFFF7, 0xFFD2, 0x0016, 0xFFF2, 0xFFE3, 0x0000, 0xFFE8, 0x0056,
    0x0016, 0x000F, 0xFFF4, 0x0015, 0xFFFE, 0x000F, 0xFFEA, 0x0027,
    0x0001, 0xFFFC, 0xFFCD, 0xFFCD, 0xFFE3, 0x001B, 0xFFE6, 0x0024,
    0x0020, 0x0039, 0xFFF0, 0xFFEF, 0x0020, 0x0012, 0x0009, 0xFFDF,
    0x0005, 0x0034, 0xFFF2, 0x000F, 0xFFE7, 0x0012, 0x001B, 0xFFEE,
    0x0033, 0x0009, 0x001E, 0x0032, 0x0012, 0xFFBF, 0xFFDF, 0x000F,
    0xFFDD, 0xFFEB, 0x001D, 0x0012, 0x003B, 0xFFFD, 0xFFF8, 0x0001,
    0xFFFB, 0xFFE2, 0xFFD4, 0xFFEF, 0xFFE4, 0xFFE4, 0x0005, 0xFFD9,
    0xFFBE, 0xFFEE, 0xFFE6, 0x0031, 0xFFC2, 0x0017, 0x0019, 0xFFCD,
    0x0024, 0xFFD5, 0x0002, 0x0013, 0xFFDC, 0xFFFA, 0x0004, 0xFFD9,
    0x001B, 0x000C, 0xFFDD, 0x0023, 0x0083, 0x0023, 0xFFEE, 0xFFE1,
    0xFFE8, 0x0005, 0xFFEE, 0xFFFE, 0x0013, 0x0015, 0xFFF4, 0x0000,
    0xFFDA, 0xFFDA, 0x0006, 0xFFE0, 0x0000, 0x0008, 0x000E, 0x0004,
    0x0011, 0x0000, 0x0010, 0xFFB9, 0x0010, 0x0046, 0x0005, 0xFFE9,
    0xFFFE, 0x000A, 0x001F, 0xFFE5, 0x0001, 0x001D, 0xFFFB, 0xFFFD,
    0x0041, 0xFFC6, 0x002C, 0x0033, 0xFFEE, 0xFFF4, 0xFFE3, 0x0042,
    0xFFD9, 0x000A, 0x0018, 0x0020, 0xFFF8, 0xFFF0, 0x0018, 0x000B,
    0xFFC7, 0xFFC6, 0xFFE4, 0xFFD9, 0xFFDC, 0xFFEF, 0xFFEB, 0x0010,
    0x0006, 0xFFEE, 0xFFF4, 0xFFDA, 0x004A, 0x003E, 0xFFF1, 0x000D,
    0xFFE2, 0xFFD6, 0x0026, 0x000A, 0xFFE6, 0xFFF4, 0xFFFB, 0x000D,
    0xFFF7, 0x0023, 0xFFE9, 0xFFDB, 0x0000, 0xFFB4, 0xFFFB, 0xFFE1,
    0x0016, 0xFFFA, 0xFFCB, 0x0001, 0xFFFE, 0xFFEC, 0xFFDD, 0xFFD0,
    0xFFEA, 0x0009, 0xFFF9, 0x0010, 0x000C, 0xFFBC, 0xFFE0, 0xFFF9,
    0x000F, 0xFFE2, 0x0000, 0x0014, 0xFFCF, 0xFFF7, 0x0021, 0x0002,
    0xFFD9, 0xFFC7, 0x0019, 0x0003, 0xFFCD, 0xFFCD, 0x000C, 0xFF86,
    0x0026, 0xFFF4, 0x001A, 0x0019, 0xFFFB, 0x0036, 0xFFDB, 0xFFBF,
    0x0017, 0x000F, 0xFFF1, 0x0018, 0x0010, 0xFFDD, 0xFFEE, 0x0013,
    0xFFF7, 0xFFCB, 0x0011, 0x0007, 0x0049, 0xFFF6, 0xFFE8, 0xFFFA,
    0x0017, 0xFFD2, 0xFFC2, 0x0006, 0xFFF6, 0xFFAA, 0x0003, 0xFFC1,
    0xFFF8, 0x002F, 0xFFE5, 0xFFA1, 0x001B, 0xFFEC, 0xFFE9, 0xFFC8,
    0x0004, 0xFFE2, 0xFFDE, 0xFFC6, 0xFFF6, 0x001B, 0xFFED, 0xFFF4,
    0x0006, 0xFFE8, 0xFFE2, 0xFFC4, 0xFFEF, 0x002A, 0x0008, 0x0017,
    0xFFED, 0xFFFE, 0xFFBE, 0xFFEF, 0xFFD3, 0x0029, 0xFFE9, 0x0022,
    0x0016, 0xFFD0, 0x0016, 0x0004, 0x002B, 0x0015, 0xFFEC, 0xFFFA,
    0xFFFB, 0xFFEC, 0xFFEC, 0x0005, 0xFFF2, 0x0014, 0x0038, 0x004C,
    0xFFDF, 0xFFE9, 0x0002, 0xFFDF, 0xFFD0, 0xFFCE, 0x0020, 0x0015,
    0xFF9F, 0x001C, 0xFFF7, 0xFFFF, 0xFFEB, 0x0005, 0xFFBF, 0x0008,
    0x000C, 0xFFE5, 0x000A, 0x000E, 0xFFFD, 0xFFFE, 0xFFEC, 0x0021,
    0x000C, 0x0020, 0xFFFE, 0x0007, 0x0054, 0xFFDE, 0xFFED, 0xFFCF,
    0x002E, 0x0000, 0x0012, 0x0006, 0xFFD8, 0xFFC9, 0x0012, 0xFFF8,
    0x0028, 0xFFFF, 0x000A, 0x0001, 0x001D, 0xFFEE, 0x0015, 0x0022,
    0xFFBC, 0x000A, 0x002F, 0x0005, 0x000C, 0xFFF5, 0x0040, 0xFFF6,
    0xFFCD, 0xFFE2, 0xFFCD, 0xFFCA, 0xFFB2, 0x0006, 0xFFEE, 0x0033,
    0xFFF0, 0x0002, 0x001C, 0xFFEC, 0xFFFB, 0xFFE7, 0xFFE5, 0xFFF4,
    0xFFFF, 0x001F, 0xFFF3, 0x0003, 0xFFF1, 0xFFE4, 0xFFFD, 0x0012,
    0xFFF2, 0xFF97, 0xFFD2, 0xFFFD, 0x0002, 0x0024, 0xFFEC, 0x0007,
    0x0038, 0x0039, 0xFFDE, 0x0017, 0xFFF7, 0xFFF9, 0x000F, 0xFFD1,
    0xFFF4, 0x000C, 0x0013, 0x003D, 0xFFE4, 0x002A, 0xFFC6, 0xFFE4,
    0xFFF2, 0x0000, 0xFFCA, 0x0004, 0xFFBD, 0x003D, 0xFFBD, 0xFFE1,
    0x0019, 0x0023, 0x002E, 0x001B, 0xFFF8, 0xFFD3, 0xFFEC, 0x001A,
    0x0016, 0x0015, 0xFFD0, 0xFFFF, 0xFFE9, 0xFFA2, 0x0020, 0x0027,
    0x003E, 0xFFB2, 0xFFD8, 0xFFC6, 0x001B, 0x001A, 0x0001, 0xFFEB,
    0x0027, 0x0008, 0x0034, 0x0001, 0x0006, 0x001E, 0xFFD1, 0x003D,
    0x0036, 0x0050, 0x004E, 0x002D, 0x0006, 0xFF9D, 0xFFEB, 0xFFF2,
    0xFFF4, 0x0012, 0x001D, 0x0016, 0x0023, 0x000D, 0x0003, 0x0036,
    0x002A, 0x0065, 0x001A, 0xFFEB, 0xFFD4, 0xFFC7, 0x0001, 0x002F,
    0xFFEF, 0x001C, 0x001D, 0xFFE7, 0x001A, 0x0004, 0xFFDF, 0xFFE2,
    0x0009, 0x0005, 0x000B, 0xFFFE, 0xFFE4, 0xFFEC, 0x000A, 0x000A,
    0xFFEB, 0xFFDC, 0xFFD2, 0xFFFF, 0xFFF3, 0x002F, 0x0007, 0xFFD1,
    0xFFEF, 0x0010, 0x003E, 0x000F, 0x0029, 0xFFF9, 0xFFB5, 0xFFEF,
    0x001F, 0xFFFB, 0x000B, 0x0006, 0x000C, 0xFFF0, 0xFFDD, 0x001B,
    0x000C, 0x0005, 0xFFFF, 0x0047, 0x000F, 0x0018, 0x0011, 0xFFF8,
    0xFFEB, 0x002E, 0x0027, 0xFFFE, 0x0001, 0x001A, 0x003B, 0xFFBC,
    0xFFE5, 0xFFCB, 0x002C, 0x002C, 0xFFFE, 0xFFFF, 0xFFF6, 0xFFC6,
    0xFFE4, 0x0000, 0x0031, 0xFFE8, 0xFFF7, 0x0018, 0x0012, 0xFFEF,
    0xFFFC, 0x0007, 0x0030, 0xFFFB, 0xFFE3, 0xFFF2, 0x0017, 0xFFFE,
    0xFFC2, 0x0002, 0x0029, 0xFFC5, 0x0039, 0xFFF4, 0x001F, 0xFFF7,
    0x000F, 0x001B, 0xFFEF, 0xFFF4, 0x0010, 0xFFD8, 0x0048, 0x004F,
    0x000B, 0x0000, 0x0048, 0xFFB1, 0x0010, 0x0028, 0xFFEF, 0x000C,
    0x000F, 0xFFE5, 0x001F, 0x0009, 0x0039, 0x000C, 0x0029, 0x003B,
    0xFFC2, 0xFFFE, 0x0017, 0x0002, 0xFFE3, 0x000E, 0x0030, 0x0005,
    0xFFFC, 0xFFF9, 0x0012, 0x0011, 0xFFF7, 0xFFE8, 0x0031, 0x0018,
    0xFFE4, 0x0000, 0xFFF6, 0x003A, 0xFFFE, 0x0001, 0x002C, 0xFFD4,
    0xFFE5, 0x0035, 0x003B, 0x0044, 0x0001, 0xFFE6, 0x0027, 0x0002,
    0xFFEB, 0xFFD2, 0x0011, 0x0008, 0x000F, 0xFFE8, 0xFFFF, 0xFFB9,
    0x000C, 0xFFFB, 0xFFDD, 0xFFE5, 0x000C, 0x0010, 0x000B, 0xFFFA,
    0x001F, 0x0005, 0xFFB5, 0x0011, 0x0029, 0x0007, 0x003E, 0xFFF1,
    0xFFEF, 0xFFF0, 0x0007, 0x002F, 0xFFF3, 0xFFD1, 0xFFD2, 0x0001,
    0xFFEB, 0x0024, 0x000A, 0xFFF6, 0xFFE4, 0x0014, 0x000B, 0x0002,
    0x0009, 0xFFFB, 0xFFDF, 0x001E, 0x001A, 0xFFFC, 0x001D, 0x0019,
    0xFFEF, 0xFFE4, 0x0001, 0xFFD1, 0xFFD4, 0x0039, 0x001A, 0x0015,
    0x002A, 0xFF9B, 0x0003, 0xFFCA, 0x0023, 0xFFF3, 0x001D, 0xFFEA,
    0xFFF4, 0xFFEE, 0xFFEB, 0x000E, 0x0006, 0x0063, 0x004E, 0xFFD3,
    0x0036, 0xFFB0, 0xFFD1, 0xFFC3, 0x0006, 0xFFE2, 0x0034, 0xFFFF,
    0x0027, 0xFFF8, 0x0001, 0x0015, 0x001B, 0xFFE6, 0xFFD8, 0x003A,
    0x003E, 0x004E, 0x0020, 0xFFD9, 0xFFE9, 0x005E, 0xFFD0, 0x0001,
    0x0016, 0xFFEB, 0xFFEC, 0xFFE6, 0xFFF8, 0x002D, 0x002E, 0xFFE5,
    0x0019, 0xFFDD, 0xFFBD, 0x001F, 0xFFBD, 0xFFC3, 0xFFCA, 0xFFFC,
    0xFFF2, 0x0000, 0xFFC6, 0x001C, 0xFFE4, 0xFFD6, 0x0013, 0xFFC3,
    0xFFF4, 0xFFF4, 0x000F, 0x002F, 0xFFF7, 0x0007, 0xFFDE, 0xFFE9,
    0x0038, 0xFFC7, 0xFFEC, 0xFFF9, 0x0002, 0xFFDC, 0xFFD2, 0x0003,
    0xFFF2, 0x0069, 0xFFFD, 0xFFEE, 0xFFF1, 0x001C, 0xFFF3, 0xFFFD,
    0xFFFF, 0xFFE1, 0xFFE5, 0x000C, 0xFFFB, 0x0019, 0x001C, 0x0014,
    0xFFF0, 0xFFFE, 0xFFEE, 0xFFCD, 0xFFB2, 0xFFFA, 0xFFCD, 0x0036,
    0xFFCD, 0x001E, 0x0040, 0x000A, 0x000C, 0x000B, 0x002F, 0xFFFB,
    0xFFBC, 0xFFF6, 0x0015, 0xFFDE, 0x001D, 0x0012, 0x000A, 0xFFFF,
    0x0028, 0x0001, 0x0012, 0x0008, 0xFFD8, 0x0037, 0x0012, 0xFFFA,
    0x002E, 0x0000, 0xFFED, 0x0031, 0x0054, 0x0022, 0xFFFE, 0xFFF9,
    0x000C, 0xFFE0, 0xFFEC, 0xFFDF, 0xFFFD, 0x0002, 0x000A, 0xFFF2,
    0x000C, 0x001B, 0xFFBF, 0xFFF8, 0xFFEB, 0xFFFB, 0xFFF7, 0x0001,
    0xFF9F, 0xFFE4, 0x0020, 0xFFEB, 0xFFD0, 0x0032, 0x0002, 0x0021,
    0xFFDF, 0x0017, 0x0038, 0xFFB4, 0xFFF2, 0xFFEC, 0xFFEC, 0xFFFB,
    0xFFFB, 0x0014, 0xFFEC, 0x0006, 0x002B, 0xFFEB, 0x0016, 0xFFFC,
    0x0016, 0x0030, 0xFFE9, 0xFFDE, 0xFFD3, 0xFFD7, 0xFFBE, 0x0011,
    0xFFED, 0x0002, 0x0008, 0xFFE9, 0xFFEF, 0xFFD6, 0xFFE2, 0x003C,
    0x0006, 0x0018, 0xFFED, 0x000C, 0xFFF6, 0xFFE5, 0xFFDE, 0x003A,
    0x0004, 0x001E, 0xFFE9, 0x0038, 0x001B, 0x0014, 0xFFE5, 0x005F,
    0xFFF8, 0xFFD1, 0x0003, 0x003F, 0xFFF6, 0x0056, 0xFFC2, 0xFFFA,
    0x0017, 0x002E, 0xFFE8, 0x0006, 0x0049, 0x000A, 0x0011, 0xFFF9,
    0xFFF7, 0x0035, 0xFFEE, 0xFFED, 0x0010, 0x0023, 0xFFF1, 0xFFE8,
    0x0017, 0xFFF1, 0xFFDB, 0x0041, 0xFFFB, 0xFFCA, 0x001A, 0xFFE7,
    0x0026, 0x000C, 0x000C, 0x007A, 0xFFCD, 0x0033, 0x0019, 0xFFFD,
    0xFFD9, 0x0039, 0x0021, 0xFFFE, 0xFFCF, 0x0009, 0x0000, 0xFFEC,
    0x000F, 0x001E, 0xFFE0, 0x0007, 0x000C, 0x0044, 0xFFF9, 0xFFF0,
    0xFFEA, 0xFFF7, 0xFFDD, 0x0030, 0xFFFE, 0x0014, 0xFFCB, 0xFFFF,
    0x0016, 0x0006, 0xFFFB, 0x001F, 0x0000, 0x004C, 0xFFE9, 0x0025,
    0xFFF7, 0xFFDD, 0xFFFB, 0xFFF3, 0xFFE6, 0x000C, 0x0026, 0xFFF6,
    0xFFE2, 0x002A, 0xFFF1, 0xFFF3, 0x004A, 0xFFC2, 0xFFF4, 0x0026,
    0x0006, 0x0012, 0xFFEB, 0xFFF0, 0xFFDC, 0x0011, 0xFFE4, 0x0027,
    0xFFC7, 0x003A, 0x0018, 0xFFF5, 0xFFF8, 0x0010, 0x0018, 0xFFE0,
    0xFFD9, 0xFFF6, 0xFFE3, 0xFFBE, 0xFFEE, 0x000C, 0x002C, 0xFFCD,
    0x0041, 0x003A, 0xFFFB, 0x0003, 0x0001, 0xFFE3, 0x001F, 0x001B,
    0xFFFE, 0xFFF6, 0x0005, 0x0017, 0x0010, 0xFFBA, 0x0010, 0x0047,
    0x0011, 0x0000, 0x000E, 0xFFFC, 0x0000, 0xFFF8, 0x0006, 0x0020,
    0xFFDA, 0x0026, 0xFFF4, 0x0000, 0x0013, 0xFFEB, 0xFFEE, 0x0002,
    0xFFE8, 0xFFFB, 0xFFEE, 0x001F, 0x0083, 0xFFDD, 0xFFDD, 0xFFDD,
    0x001B, 0xFFF4, 0x0004, 0x0027, 0xFFDC, 0x0006, 0x0002, 0xFFED,
    0x0024, 0x002B, 0x0019, 0x0033, 0xFFC2, 0xFFE9, 0xFFE6, 0xFFCF,
    0xFFBE, 0x0012, 0x0005, 0x0027, 0xFFE4, 0x001C, 0xFFD4, 0x0011,
    0xFFFB, 0x001E, 0xFFF8, 0xFFFF, 0x003B, 0x0003, 0x001D, 0xFFEE,
    0xFFDD, 0x0015, 0xFFDF, 0xFFF1, 0x0012, 0x0041, 0x001E, 0xFFCE,
    0x0033, 0xFFF7, 0x001B, 0x0012, 0xFFE7, 0xFFEE, 0xFFF2, 0xFFF1,
    0x0005, 0xFFCC, 0x0009, 0x0021, 0x0020, 0xFFEE, 0xFFF0, 0x0011,
    0x0020, 0xFFC7, 0xFFE6, 0xFFDC, 0xFFE3, 0xFFE5, 0xFFCD, 0x0033,
    0x0001, 0x0004, 0xFFEA, 0xFFD9, 0xFFFE, 0xFFF1, 0xFFF4, 0xFFEB,
    0x0016, 0xFFF1, 0xFFE8, 0xFFAA, 0xFFE3, 0x0000, 0x0016, 0x000E,
    0xFFF7, 0x002E, 0x002B, 0x0018, 0xFFEB, 0x000D, 0xFFBF, 0x0091,
    0xFFF7, 0x000F, 0x0013, 0x000D, 0xFFDC, 0xFFFB, 0x0014, 0x003E,
    0xFFF2, 0x001A, 0xFFD9, 0xFFD1, 0xFFD6, 0xFFFC, 0x0054, 0x0004,
    0x0042, 0xFFF4, 0xFFD5, 0xFFCD, 0xFFC5, 0x0034, 0xFFDB, 0xFFD5,
    0xFFE6, 0x0044, 0x000B, 0x0000, 0x0037, 0x0016, 0xFFBD, 0x000B,
    0x0029, 0xFFBF, 0x0019, 0xFFEF, 0x0015, 0x001F, 0x0034, 0xFFB1,
    0xFFE8, 0xFFD4, 0x000D, 0x0033, 0xFFD1, 0xFFF0, 0xFFE0, 0xFFF0,
    0xFFC0, 0x001A, 0x0005, 0x002A, 0x000B, 0xFFA5, 0xFFEF, 0xFFE4,
    0xFFF2, 0x0019, 0x0022, 0xFFCF, 0xFFF5, 0xFFF5, 0x0005, 0x000F,
    0xFFF6, 0x0011, 0x005C, 0xFFF2, 0xFFE5, 0x0006, 0x0008, 0x0042,
    0xFFDD, 0xFFE4, 0x001A, 0x001B, 0xFFF4, 0xFFCD, 0xFFD4, 0x0071,
    0xFFDE, 0xFFBC, 0x001B, 0x0002, 0x001E, 0xFFF4, 0x0023, 0x0016,
    0x0021, 0x001F, 0xFFBF, 0x002E, 0x0000, 0xFFF0, 0x000B, 0xFFE1,
    0xFFBC, 0xFFFD, 0x0005, 0x0017, 0xFFDF, 0xFFE3, 0xFFE8, 0xFFF4,
    0x0043, 0x0014, 0x002E, 0x0000, 0x0023, 0x0012, 0x001F, 0x0018,
    0x000D, 0x0011, 0x0041, 0x0008, 0x0005, 0xFFCD, 0x000B, 0x0045,
    0xFFFD, 0xFFDC, 0x0036, 0x001B, 0x0013, 0xFFF7, 0xFFF6, 0x002F,
    0xFFC6, 0x0009, 0xFFCD, 0x0010, 0x0031, 0xFFF9, 0xFFFA, 0x0004,
    0x002A, 0x0016, 0x002D, 0x0017, 0xFFC2, 0xFFFC, 0xFFF3, 0xFFF3,
    0xFFCC, 0xFFCF, 0x0002, 0xFFF8, 0xFFE0, 0xFFE5, 0x0000, 0xFFEF,
    0x000C, 0x001D, 0xFFDE, 0xFFF9, 0xFFDD, 0x0011, 0x0012, 0xFFF4,
    0x0011, 0x000C, 0xFFD4, 0x0034, 0xFFE2, 0x0009, 0x000E, 0x0005,
    0x0002, 0x0023, 0xFFDB, 0xFFE3, 0xFFE7, 0x0004, 0x002B, 0x0000,
    0xFFE6, 0xFFDB, 0xFFE6, 0x0008, 0xFFFB, 0xFFE1, 0xFFEA, 0xFFF4,
    0x0016, 0xFFE4, 0x005C, 0xFFD6, 0xFFFB, 0xFFC3, 0x0018, 0x0011,
    0x001A, 0xFFE1, 0x0028, 0xFFEC, 0x0000, 0x002D, 0x0014, 0xFFF5,
    0xFFF4, 0xFFF6, 0x001D, 0xFFE7, 0xFFBF, 0x0040, 0x005E, 0x0022,
    0x000F, 0x0000, 0xFFCF, 0xFFCB, 0xFFD8, 0x000A, 0x0006, 0xFFFE,
    0x0026, 0x2CFB, 0x0054, 0x0022, 0xFFFB, 0xFFF7, 0x0037, 0xFFD4,
    0xFFE2, 0xFFFA, 0x0002, 0xFFDD, 0xFFF2, 0xFFFF, 0x000C, 0xFFA9,
    0xFFFB, 0xFFC9, 0x000B, 0x0006, 0xFFFF, 0x003E, 0x0005, 0x0009,
    0x001B, 0xFFFF, 0x0010, 0xFFD4, 0x004A, 0x001B, 0x0014, 0xFFFC,
    0xFFE7, 0x0012, 0xFFE8, 0xFFDB, 0x0025, 0xFFDE, 0xFFDA, 0xFFFC,
    0x001D, 0x001A, 0x0004, 0xFFEE, 0x0035, 0x000A, 0x0018, 0xFFFD,
    0xFFF8, 0x0025, 0x001E, 0xFFF1, 0x0023, 0x0017, 0xFFE7, 0x0020,
    0xFFF5, 0xFFE8, 0x001D, 0x005C, 0xFFFB, 0x0013, 0xFFE7, 0xFFFA,
    0x0025, 0x0013, 0x0032, 0xFFD9, 0x0011, 0x0052, 0xFFD2, 0x002F,
    0x0002, 0x001C, 0xFFBC, 0x001B, 0x001C, 0x0007, 0xFFD5, 0x000D,
    0x0018, 0xFFDB, 0xFFF4, 0xFFFA, 0xFFF5, 0xFFF0, 0xFFF9, 0xFFF3,
    0xFFE5, 0xFFE5, 0x0020, 0xFFF7, 0xFFF5, 0xFFE9, 0xFFF6, 0xFFF9,
    0xFFF8, 0x0028, 0xFFF8, 0x0000, 0x0043, 0xFFBD, 0xFFDD, 0x0010,
    0xFFFB, 0x000C, 0x001A, 0x001C, 0xFFF7, 0xFFFB, 0x0021, 0x001C,
    0x0018, 0xFFD8, 0x0002, 0xFFF9, 0xFFF0, 0x0026, 0xFFF5, 0x0052,
    0x001C, 0x0012, 0x0022, 0xFFFB, 0xFFBA, 0xFFAF, 0xFFEB, 0x0006,
    0xFFB4, 0x000D, 0x0000, 0xFFFE, 0xFFB2, 0x0010, 0xFFFE, 0x0000,
    0xFFED, 0xFFFF, 0x0004, 0xFFE8, 0x001A, 0xFFDC, 0x001B, 0x0010,
    0xFFEB, 0xFFF4, 0x0053, 0xFFD9, 0xFFC5, 0x0020, 0x0027, 0x001F,
    0x000C, 0x0005, 0x001E, 0x0018, 0x0019, 0xFFD1, 0x0003, 0xFFFD,
    0x000F, 0xFFD0, 0xFFFA, 0xFFCD, 0xFFD2, 0x000B, 0x001C, 0x0033,
    0xFFD4, 0xFFFB, 0xFFA4, 0xFFC8, 0x001D, 0xFFFC, 0xFFEB, 0x0004,
    0x0024, 0xFFFF, 0x001A, 0xFFF6, 0xFFF3, 0xFFF5, 0xFFF1, 0x0001,
    0x000A, 0x0025, 0xFFDB, 0x0010, 0x000D, 0x0025, 0xFFD7, 0xFFCD,
    0x0028, 0xFFFF, 0xFFD6, 0x0024, 0xFFED, 0x0035, 0x0021, 0x0035,
    0x0018, 0x0050, 0x0022, 0xFFF1, 0xFFF5, 0xFFDA, 0x0023, 0xFFF6,
    0x0041, 0x000F, 0x0006, 0xFFD8, 0xFFE5, 0xFFE2, 0xFFCC, 0x0009,
    0xFFDC, 0xFFE2, 0xFF9D, 0xFFE5, 0x0018, 0x000F, 0x000E, 0x0007,
    0x0008, 0xFFE0, 0x0029, 0x0029, 0x0024, 0xFFB3, 0x002E, 0x0004,
    0x0043, 0xFFD2, 0xFFE8, 0x0031, 0x0000, 0xFFE6, 0xFFD2, 0x0007,
    0x0046, 0x0004, 0x0003, 0xFFF6, 0x0038, 0x001B, 0x0000, 0x003B,
    0x0025, 0xFFCD, 0xFFF4, 0x0022, 0xFFBD, 0x000A, 0xFFE5, 0xFFE1
    };

static const q15_t ref_cfft_noisy_1024[2048] = {
    0x0032, 0x0000, 0xFFE5, 0x001F, 0xFFBD, 0xFFF6, 0xFFF4, 0xFFDE,
    0x0025, 0x0033, 0x0000, 0xFFC5, 0x0038, 0xFFE5, 0x0003, 0x000A,
    0x0046, 0xFFFC, 0xFFD2, 0xFFF9, 0x0000, 0x001A, 0xFFE8, 0xFFCF,
    0x0043, 0x002E, 0x002E, 0xFFFC, 0x0024, 0x004D, 0x0029, 0xFFD7,
    0x0008, 0x0020, 0x000E, 0xFFF9, 0x0018, 0xFFF1, 0xFF9D, 0x001B,
    0xFFDC, 0x001E, 0xFFCC, 0xFFF7, 0xFFE5, 0x001E, 0x0006, 0x0028,
    0x0041, 0xFFF1, 0x0023, 0x000A, 0xFFF5, 0x0026, 0x0022, 0x000F,
    0x0018, 0xFFB0, 0x0021, 0xFFCB, 0xFFED, 0xFFCB, 0xFFD6, 0xFFDC,
    0x0028, 0x0001, 0xFFD7, 0x0033, 0x000D, 0xFFDB, 0xFFDB, 0xFFF0,
    0x000A, 0xFFDB, 0xFFF1, 0xFFFF, 0xFFF3, 0x000B, 0x001A, 0x000A,
    0x0024, 0x0001, 0xFFEB, 0xFFFC, 0x001D, 0x0004, 0xFFA4, 0x0038,
    0xFFD4, 0x0005, 0x001C, 0xFFCD, 0xFFD2, 0xFFF5, 0xFFFA, 0x0033,
    0x000F, 0x0030, 0x0003, 0x0003, 0x0019, 0x002F, 0x001E, 0xFFE8,
    0x000C, 0xFFFB, 0x0027, 0xFFE1, 0xFFC5, 0xFFE0, 0x0053, 0x0027,
    0xFFEB, 0x000C, 0x001B, 0xFFF0, 0x001A, 0x0024, 0x0004, 0x0018,
    0xFFED, 0x0001, 0xFFFE, 0x0000, 0xFFB2, 0xFFF0, 0x0000, 0x0002,
    0xFFB4, 0xFFF3, 0xFFEB, 0xFFFA, 0xFFBA, 0x0051, 0x0022, 0x0005,
    0x001C, 0xFFEE, 0xFFF5, 0xFFAE, 0xFFF0, 0xFFDA, 0x0002, 0x0007,
    0x0018, 0x0028, 0x0021, 0xFFE4, 0xFFF7, 0x0005, 0x001A, 0xFFE4,
    0xFFFB, 0xFFF4, 0xFFDD, 0xFFF0, 0x0043, 0x0043, 0xFFF8, 0x0000,
    0xFFF8, 0xFFD8, 0xFFF6, 0x0007, 0xFFF5, 0x0017, 0x0020, 0x0009,
    0xFFE5, 0x001B, 0xFFF9, 0x000D, 0xFFF5, 0x0010, 0xFFF4, 0x0006,
    0x0018, 0x0025, 0xFFD5, 0xFFF3, 0x001C, 0xFFF9, 0xFFBC, 0xFFE5,
    0x0002, 0xFFE4, 0xFFD2, 0xFFD1, 0x0011, 0xFFAE, 0x0032, 0x0027,
    0x0025, 0xFFED, 0xFFE7, 0x0006, 0xFFFB, 0xFFED, 0x001D, 0xFFA4,
    0xFFF5, 0x0018, 0xFFE7, 0xFFE0, 0x0023, 0xFFE9, 0x001E, 0x000F,
    0xFFF8, 0xFFDB, 0x0018, 0x0003, 0x0035, 0xFFF6, 0x0004, 0x0012,
    0x001D, 0xFFE6, 0xFFDA, 0x0004, 0x0025, 0x0022, 0xFFE8, 0x0025,
    0xFFE7, 0xFFEE, 0x0014, 0x0004, 0x004A, 0xFFE5, 0x0010, 0x002C,
    0x001B, 0x0001, 0x0005, 0xFFF7, 0xFFFF, 0xFFC2, 0x000B, 0xFFFA,
    0xFFFB, 0x0037, 0x000C, 0x0057, 0xFFF2, 0x0001, 0x0002, 0x0023,
    0xFFE2, 0x0006, 0x0037, 0x002C, 0xFFFB, 0x0009, 0x0054, 0xFFDE,
    0x0026, 0xD305, 0x0006, 0x0002, 0xFFD8, 0xFFF6, 0xFFCF, 0x0035,
    0x000F, 0x0000, 0x005E, 0xFFDE, 0xFFBF, 0xFFC0, 0x001D, 0x0019,
    0xFFF4, 0x000A, 0x0014, 0x000B, 0x0000, 0xFFD3, 0x0028, 0x0014,
    0x001A, 0x001F, 0x0018, 0xFFEF, 0xFFFB, 0x003D, 0x005C, 0x002A,
    0x0016, 0x001C, 0xFFEA, 0x000C, 0xFFFB, 0x001F, 0xFFE6, 0xFFF8,
    0xFFE6, 0x0025, 0x002B, 0x0000, 0xFFE7, 0xFFFC, 0xFFDB, 0x001D,
    0x0002, 0xFFDD, 0x000E, 0xFFFB, 0xFFE2, 0xFFF7, 0xFFD4, 0xFFCC,
    0x0011, 0xFFF4, 0x0012, 0x000C, 0xFFDD, 0xFFEF, 0xFFDE, 0x0007,
    0x000C, 0xFFE3, 0x0000, 0x0011, 0xFFE0, 0x001B, 0x0002, 0x0008,
    0xFFCC, 0x0031, 0xFFF3, 0x000D, 0xFFC2, 0x0004, 0x002D, 0xFFE9,
    0x002A, 0xFFEA, 0xFFFA, 0xFFFC, 0x0031, 0x0007, 0xFFCD, 0xFFF0,
    0xFFC6, 0xFFF7, 0xFFF6, 0xFFD1, 0x0013, 0x0009, 0x0036, 0xFFE5,
    0xFFFD, 0x0024, 0x000B, 0xFFBB, 0x0005, 0x0033, 0x0041, 0xFFF8,
    0x000D, 0xFFEF, 0x001F, 0xFFE8, 0x0023, 0xFFEE, 0x002E, 0x0000,
    0x0043, 0xFFEC, 0xFFE8, 0x000C, 0xFFDF, 0x001D, 0x0005, 0xFFE9,
    0xFFBC, 0x0003, 0x000B, 0x001F, 0x0000, 0x0010, 0xFFBF, 0xFFD2,
    0x0021, 0xFFE1, 0x0023, 0xFFEA, 0x001E, 0x000C, 0x001B, 0xFFFE,
    0xFFDE, 0x0044, 0xFFD4, 0xFF8F, 0xFFF4, 0x0033, 0x001A, 0xFFE5,
    0xFFDD, 0x001C, 0x0008, 0xFFBE, 0xFFE5, 0xFFFA, 0x005C, 0x000E,
    0xFFF6, 0xFFEF, 0x0005, 0xFFF1, 0xFFF5, 0x000B, 0x0022, 0x0031,
    0xFFF2, 0xFFE7, 0xFFEF, 0x001C, 0x000B, 0x005B, 0x0005, 0xFFD6,
    0xFFC0, 0xFFE6, 0xFFE0, 0x0010, 0xFFD1, 0x0010, 0x000D, 0xFFCD,
    0xFFE8, 0x002C, 0x0034, 0x004F, 0x0015, 0xFFE1, 0x0019, 0x0011,
    0x0029, 0x0041, 0xFFBD, 0xFFF5, 0x0037, 0xFFEA, 0x000B, 0x0000,
    0xFFE6, 0xFFBC, 0xFFDB, 0x002B, 0xFFC5, 0xFFCC, 0xFFD5, 0x0033,
    0x0042, 0x000C, 0x0054, 0xFFFC, 0xFFD6, 0x0004, 0xFFD9, 0x002F,
    0xFFF2, 0xFFE6, 0x0014, 0xFFC2, 0xFFDC, 0x0005, 0x0013, 0xFFF3,
    0xFFF7, 0xFFF1, 0xFFBF, 0xFF6F, 0xFFEB, 0xFFF3, 0x002B, 0xFFE8,
    0xFFF7, 0xFFD2, 0x0016, 0xFFF2, 0xFFE3, 0x0000, 0xFFE8, 0x0056,
    0x0016, 0x000F, 0xFFF4, 0x0015, 0xFFFE, 0x000F, 0xFFEA, 0x0027,
    0x0001, 0xFFFC, 0xFFCD, 0xFFCD, 0xFFE3, 0x001B, 0xFFE6, 0x0024,
    0x0020, 0x0039, 0xFFF0, 0xFFEF, 0x0020, 0x0012, 0x0009, 0xFFDF,
    0x0005, 0x0034, 0xFFF2, 0x000F, 0xFFE7, 0x0012, 0x001B, 0xFFEE,
    0x0033, 0x0009, 0x001E, 0x0032, 0x0012, 0xFFBF, 0xFFDF, 0x000F,
    0xFFDD, 0xFFEB, 0x001D, 0x0012, 0x003B, 0xFFFD, 0xFFF8, 0x0001,
    0xFFFB, 0xFFE2, 0xFFD4, 0xFFEF, 0xFFE4, 0xFFE4, 0x0005, 0xFFD9,
    0xFFBE, 0xFFEE, 0xFFE6, 0x0031, 0xFFC2, 0x0017, 0x0019, 0xFFCD,
    0x0024, 0xFFD5, 0x0002, 0x0013, 0xFFDC, 0xFFFA, 0x0004, 0xFFD9,
    0x001B, 0x000C, 0xFFDD, 0x0023, 0x0083, 0x0023, 0xFFEE, 0xFFE1,
    0xFFE8, 0x0005, 0xFFEE, 0xFFFE, 0x0013, 0x0015, 0xFFF4, 0x0000,
    0xFFDA, 0xFFDA, 0x0006, 0xFFE0, 0x0000, 0x0008, 0x000E, 0x0004,
    0x0011, 0x0000, 0x0010, 0xFFB9, 0x0010, 0x0046, 0x0005, 0xFFE9,
    0xFFFE, 0x000A, 0x001F, 0xFFE5, 0x0001, 0x001D, 0xFFFB, 0xFFFD,
    0x0041, 0xFFC6, 0x002C, 0x0033, 0xFFEE, 0xFFF4, 0xFFE3, 0x0042,
    0xFFD9, 0x000A, 0x0018, 0x0020, 0xFFF8, 0xFFF0, 0x0018, 0x000B,
    0xFFC7, 0xFFC6, 0xFFE4, 0xFFD9, 0xFFDC, 0xFFEF, 0xFFEB, 0x0010,
    0x0006, 0xFFEE, 0xFFF4, 0xFFDA, 0x004A, 0x003E, 0xFFF1, 0x000D,
    0xFFE2, 0xFFD6, 0x0026, 0x000A, 0xFFE6, 0xFFF4, 0xFFFB, 0x000D,
    0xFFF7, 0x0023, 0xFFE9, 0xFFDB, 0x0000, 0xFFB4, 0xFFFB, 0xFFE1,
    0x0016, 0xFFFA, 0xFFCB, 0x0001, 0xFFFE, 0xFFEC, 0xFFDD, 0xFFD0,
    0xFFEA, 0x0009, 0xFFF9, 0x0010, 0x000C, 0xFFBC, 0xFFE0, 0xFFF9,
    0x000F, 0xFFE2, 0x0000, 0x0014, 0xFFCF, 0xFFF7, 0x0021, 0x0002,
    0xFFD9, 0xFFC7, 0x0019, 0x0003, 0xFFCD, 0xFFCD, 0x000C, 0xFF86,
    0x0026, 0xFFF4, 0x001A, 0x0019, 0xFFFB, 0x0036, 0xFFDB, 0xFFBF,
    0x0017, 0x000F, 0xFFF1, 0x0018, 0x0010, 0xFFDD, 0xFFEE, 0x0013,
    0xFFF7, 0xFFCB, 0x0011, 0x0007, 0x0049, 0xFFF6, 0xFFE8, 0xFFFA,
    0x0017, 0xFFD2, 0xFFC2, 0x0006, 0xFFF6, 0xFFAA, 0x0003, 0xFFC1,
    0xFFF8, 0x002F, 0xFFE5, 0xFFA1, 0x001B, 0xFFEC, 0xFFE9, 0xFFC8,
    0x0004, 0xFFE2, 0xFFDE, 0xFFC6, 0xFFF6, 0x001B, 0xFFED, 0xFFF4,
    0x0006, 0xFFE8, 0xFFE2, 0xFFC4, 0xFFEF, 0x002A, 0x0008, 0x0017,
    0xFFED, 0xFFFE, 0xFFBE, 0xFFEF, 0xFFD3, 0x0029, 0xFFE9, 0x0022,
    0x0016, 0xFFD0, 0x0016, 0x0004, 0x002B, 0x0015, 0xFFEC, 0xFFFA,
    0xFFFB, 0xFFEC, 0xFFEC, 0x0005, 0xFFF2, 0x0014, 0x0038, 0x004C,
    0xFFDF, 0xFFE9, 0x0002, 0xFFDF, 0xFFD0, 0xFFCE, 0x0020, 0x0015,
    0xFF9F, 0x001C, 0xFFF7, 0xFFFF, 0xFFEB, 0x0005, 0xFFBF, 0x0008,
    0x000C, 0xFFE5, 0x000A, 0x000E, 0xFFFD, 0xFFFE, 0xFFEC, 0x0021,
    0x000C, 0x0020, 0xFFFE, 0x0007, 0x0054, 0xFFDE, 0xFFED, 0xFFCF,
    0x002E, 0x0000, 0x0012, 0x0006, 0xFFD8, 0xFFC9, 0x0012, 0xFFF8,
    0x0028, 0xFFFF, 0x000A, 0x0001, 0x001D, 0xFFEE, 0x0015, 0x0022,
    0xFFBC, 0x000A, 0x002F, 0x0005, 0x000C, 0xFFF5, 0x0040, 0xFFF6,
    0xFFCD, 0xFFE2, 0xFFCD, 0xFFCA, 0xFFB2, 0x0006, 0xFFEE, 0x0033,
    0xFFF0, 0x0002, 0x001C, 0xFFEC, 0xFFFB, 0xFFE7, 0xFFE5, 0xFFF4,
    0xFFFF, 0x001F, 0xFFF3, 0x0003, 0xFFF1, 0xFFE4, 0xFFFD, 0x0012,
    0xFFF2, 0xFF97, 0xFFD2, 0xFFFD, 0x0002, 0x0024, 0xFFEC, 0x0007,
    0x0038, 0x0039, 0xFFDE, 0x0017, 0xFFF7, 0xFFF9, 0x000F, 0xFFD1,
    0xFFF4, 0x000C, 0x0013, 0x003D, 0xFFE4, 0x002A, 0xFFC6, 0xFFE4,
    0xFFF2, 0x0000, 0xFFCA, 0x0004, 0xFFBD, 0x003D, 0xFFBD, 0xFFE1,
    0x0019, 0x0023, 0x002E, 0x001B, 0xFFF8, 0xFFD3, 0xFFEC, 0x001A,
    0x0016, 0x0015, 0xFFD0, 0xFFFF, 0xFFE9, 0xFFA2, 0x0020, 0x0027,
    0x003E, 0xFFB2, 0xFFD8, 0xFFC6, 0x001B, 0x001A, 0x0001, 0xFFEB,
    0x0027, 0x0008, 0x0034, 0x0001, 0x0006, 0x001E, 0xFFD1, 0x003D,
    0x0036, 0x0050, 0x004E, 0x002D, 0x0006, 0xFF9D, 0xFFEB, 0xFFF2,
    0xFFF4, 0x0012, 0x001D, 0x0016, 0x0023, 0x000D, 0x0003, 0x0036,
    0x002A, 0x0065, 0x001A, 0xFFEB, 0xFFD4, 0xFFC7, 0x0001, 0x002F,
    0xFFEF, 0x001C, 0x001D, 0xFFE7, 0x001A, 0x0004, 0xFFDF, 0xFFE2,
    0x0009, 0x0005, 0x000B, 0xFFFE, 0xFFE4, 0xFFEC, 0x000A, 0x000A,
    0xFFEB, 0xFFDC, 0xFFD2, 0xFFFF, 0xFFF3, 0x002F, 0x0007, 0xFFD1,
    0xFFEF, 0x0010, 0x003E, 0x000F, 0x0029, 0xFFF9, 0xFFB5, 0xFFEF,
    0x001F, 0xFFFB, 0x000B, 0x0006, 0x000C, 0xFFF0, 0xFFDD, 0x001B,
    0x000C, 0x0005, 0xFFFF, 0x0047, 0x000F, 0x0018, 0x0011, 0xFFF8,
    0xFFEB, 0x002E, 0x0027, 0xFFFE, 0x0001, 0x001A, 0x003B, 0xFFBC,
    0xFFE5, 0xFFCB, 0x002C, 0x002C, 0xFFFE, 0xFFFF, 0xFFF6, 0xFFC6,
    0xFFE4, 0x0000, 0x0031, 0xFFE8, 0xFFF7, 0x0018, 0x0012, 0xFFEF,
    0xFFFC, 0x0007, 0x0030, 0xFFFB, 0xFFE3, 0xFFF2, 0x0017, 0xFFFE,
    0xFFC2, 0x0002, 0x0029, 0xFFC5, 0x0039, 0xFFF4, 0x001F, 0xFFF7,
    0x000F, 0x001B, 0xFFEF, 0xFFF4, 0x0010, 0xFFD8, 0x0048, 0x004F,
    0x000B, 0x0000, 0x0048, 0xFFB1, 0x0010, 0x0028, 0xFFEF, 0x000C,
    0x000F, 0xFFE5, 0x001F, 0x0009, 0x0039, 0x000C, 0x0029, 0x003B,
    0xFFC2, 0xFFFE, 0x0017, 0x0002, 0xFFE3, 0x000E, 0x0030, 0x0005,
    0xFFFC, 0xFFF9, 0x0012, 0x0011, 0xFFF7, 0xFFE8, 0x0031, 0x0018,
    0xFFE4, 0x0000, 0xFFF6, 0x003A, 0xFFFE, 0x0001, 0x002C, 0xFFD4,
    0xFFE5, 0x0035, 0x003B, 0x0044, 0x0001, 0xFFE6, 0x0027, 0x0002,
    0xFFEB, 0xFFD2, 0x0011, 0x0008, 0x000F, 0xFFE8, 0xFFFF, 0xFFB9,
    0x000C, 0xFFFB, 0xFFDD, 0xFFE5, 0x000C, 0x0010, 0x000B, 0xFFFA,
    0x001F, 0x0005, 0xFFB5, 0x0011, 0x0029, 0x0007, 0x003E, 0xFFF1,
    0xFFEF, 0xFFF0, 0x0007, 0x002F, 0xFFF3, 0xFFD1, 0xFFD2, 0x0001,
    0xFFEB, 0x0024, 0x000A, 0xFFF6, 0xFFE4, 0x0014, 0x000B, 0x0002,
    0x0009, 0xFFFB, 0xFFDF, 0x001E, 0x001A, 0xFFFC, 0x001D, 0x0019,
    0xFFEF, 0xFFE4, 0x0001, 0xFFD1, 0xFFD4, 0x0039, 0x001A, 0x0015,
    0x002A, 0xFF9B, 0x0003, 0xFFCA, 0x0023, 0xFFF3, 0x001D, 0xFFEA,
    0xFFF4, 0xFFEE, 0xFFEB, 0x000E, 0x0006, 0x0063, 0x004E, 0xFFD3,
    0x0036, 0xFFB0, 0xFFD1, 0xFFC3, 0x0006, 0xFFE2, 0x0034, 0xFFFF,
    0x0027, 0xFFF8, 0x0001, 0x0015, 0x001B, 0xFFE6, 0xFFD8, 0x003A,
    0x003E, 0x004E, 0x0020, 0xFFD9, 0xFFE9, 0x005E, 0xFFD0, 0x0001,
    0x0016, 0xFFEB, 0xFFEC, 0xFFE6, 0xFFF8, 0x002D, 0x002E, 0xFFE5,
    0x0019, 0xFFDD, 0xFFBD, 0x001F, 0xFFBD, 0xFFC3, 0xFFCA, 0xFFFC,
    0xFFF2, 0x0000, 0xFFC6, 0x001C, 0xFFE4, 0xFFD6, 0x0013, 0xFFC3,
    0xFFF4, 0xFFF4, 0x000F, 0x002F, 0xFFF7, 0x0007, 0xFFDE, 0xFFE9,
    0x0038, 0xFFC7, 0xFFEC, 0xFFF9, 0x0002, 0xFFDC, 0xFFD2, 0x0003,
    0xFFF2, 0x0069, 0xFFFD, 0xFFEE, 0xFFF1, 0x001C, 0xFFF3, 0xFFFD,
    0xFFFF, 0xFFE1, 0xFFE5, 0x000C, 0xFFFB, 0x0019, 0x001C, 0x0014,
    0xFFF0, 0xFFFE, 0xFFEE, 0xFFCD, 0xFFB2, 0xFFFA, 0xFFCD, 0x0036,
    0xFFCD, 0x001E, 0x0040, 0x000A, 0x000C, 0x000B, 0x002F, 0xFFFB,
    0xFFBC, 0xFFF6, 0x0015, 0xFFDE, 0x001D, 0x0012, 0x000A, 0xFFFF,
    0x0028, 0x0001, 0x0012, 0x0008, 0xFFD8, 0x0037, 0x0012, 0xFFFA,
    0x002E, 0x0000, 0xFFED, 0x0031, 0x0054, 0x0022, 0xFFFE, 0xFFF9,
    0x000C, 0xFFE0, 0xFFEC, 0xFFDF, 0xFFFD, 0x0002, 0x000A, 0xFFF2,
    0x000C, 0x001B, 0xFFBF, 0xFFF8, 0xFFEB, 0xFFFB, 0xFFF7, 0x0001,
    0xFF9F, 0xFFE4, 0x0020, 0xFFEB, 0xFFD0, 0x0032, 0x0002, 0x0021,
    0xFFDF, 0x0017, 0x0038, 0xFFB4, 0xFFF2, 0xFFEC, 0xFFEC, 0xFFFB,
    0xFFFB, 0x0014, 0xFFEC, 0x0006, 0x002B, 0xFFEB, 0x0016, 0xFFFC,
    0x0016, 0x0030, 0xFFE9, 0xFFDE, 0xFFD3, 0xFFD7, 0xFFBE, 0x0011,
    0xFFED, 0x0002, 0x0008, 0xFFE9, 0xFFEF, 0xFFD6, 0xFFE2, 0x003C,
    0x0006, 0x0018, 0xFFED, 0x000C, 0xFFF6, 0xFFE5, 0xFFDE, 0x003A,
    0x0004, 0x001E, 0xFFE9, 0x0038, 0x001B, 0x0014, 0xFFE5, 0x005F,
    0xFFF8, 0xFFD1, 0x0003, 0x003F, 0xFFF6, 0x0056, 0xFFC2, 0xFFFA,
    0x0017, 0x002E, 0xFFE8, 0x0006, 0x0049, 0x000A, 0x0011, 0xFFF9,
    0xFFF7, 0x0035, 0xFFEE, 0xFFED, 0x0010, 0x0023, 0xFFF1, 0xFFE8,
    0x0017, 0xFFF1, 0xFFDB, 0x0041, 0xFFFB, 0xFFCA, 0x001A, 0xFFE7,
    0x0026, 0x000C, 0x000C, 0x007A, 0xFFCD, 0x0033, 0x0019, 0xFFFD,
    0xFFD9, 0x0039, 0x0021, 0xFFFE, 0xFFCF, 0x0009, 0x0000, 0xFFEC,
    0x000F, 0x001E, 0xFFE0, 0x0007, 0x000C, 0x0044, 0xFFF9, 0xFFF0,
    0xFFEA, 0xFFF7, 0xFFDD, 0x0030, 0xFFFE, 0x0014, 0xFFCB, 0xFFFF,
    0x0016, 0x0006, 0xFFFB, 0x001F, 0x0000, 0x004C, 0xFFE9, 0x0025,
    0xFFF7, 0xFFDD, 0xFFFB, 0xFFF3, 0xFFE6, 0x000C, 0x0026, 0xFFF6,
    0xFFE2, 0x002A, 0xFFF1, 0xFFF3, 0x004A, 0xFFC2, 0xFFF4, 0x0026,
    0x0006, 0x0012, 0xFFEB, 0xFFF0, 0xFFDC, 0x0011, 0xFFE4, 0x0027,
    0xFFC7, 0x003A, 0x0018, 0xFFF5, 0xFFF8, 0x0010, 0x0018, 0xFFE0,
    0xFFD9, 0xFFF6, 0xFFE3, 0xFFBE, 0xFFEE, 0x000C, 0x002C, 0xFFCD,
    0x0041, 0x003A, 0xFFFB, 0x0003, 0x0001, 0xFFE3, 0x001F, 0x001B,
    0xFFFE, 0xFFF6, 0x0005, 0x0017, 0x0010, 0xFFBA, 0x0010, 0x0047,
    0x0011, 0x0000, 0x000E, 0xFFFC, 0x0000, 0xFFF8, 0x0006, 0x0020,
    0xFFDA, 0x0026, 0xFFF4, 0x0000, 0x0013, 0xFFEB, 0xFFEE, 0x0002,
    0xFFE8, 0xFFFB, 0xFFEE, 0x001F, 0x0083, 0xFFDD, 0xFFDD, 0xFFDD,
    0x001B, 0xFFF4, 0x0004, 0x0027, 0xFFDC, 0x0006, 0x0002, 0xFFED,
    0x0024, 0x002B, 0x0019, 0x0033, 0xFFC2, 0xFFE9, 0xFFE6, 0xFFCF,
    0xFFBE, 0x0012, 0x0005, 0x0027, 0xFFE4, 0x001C, 0xFFD4, 0x0011,
    0xFFFB, 0x001E, 0xFFF8, 0xFFFF, 0x003B, 0x0003, 0x001D, 0xFFEE,
    0xFFDD, 0x0015, 0xFFDF, 0xFFF1, 0x0012, 0x0041, 0x001E, 0xFFCE,
    0x0033, 0xFFF7, 0x001B, 0x0012, 0xFFE7, 0xFFEE, 0xFFF2, 0xFFF1,
    0x0005, 0xFFCC, 0x0009, 0x0021, 0x0020, 0xFFEE, 0xFFF0, 0x0011,
    0x0020, 0xFFC7, 0xFFE6, 0xFFDC, 0xFFE3, 0xFFE5, 0xFFCD, 0x0033,
    0x0001, 0x0004, 0xFFEA, 0xFFD9, 0xFFFE, 0xFFF1, 0xFFF4, 0xFFEB,
    0x0016, 0xFFF1, 0xFFE8, 0xFFAA, 0xFFE3, 0x0000, 0x0016, 0x000E,
    0xFFF7, 0x002E, 0x002B, 0x0018, 0xFFEB, 0x000D, 0xFFBF, 0x0091,
    0xFFF7, 0x000F, 0x0013, 0x000D, 0xFFDC, 0xFFFB, 0x0014, 0x003E,
    0xFFF2, 0x001A, 0xFFD9, 0xFFD1, 0xFFD6, 0xFFFC, 0x0054, 0x0004,
    0x0042, 0xFFF4, 0xFFD5, 0xFFCD, 0xFFC5, 0x0034, 0xFFDB, 0xFFD5,
    0xFFE6, 0x0044, 0x000B, 0x0000, 0x0037, 0x0016, 0xFFBD, 0x000B,
    0x0029, 0xFFBF, 0x0019, 0xFFEF, 0x0015, 0x001F, 0x0034, 0xFFB1,
    0xFFE8, 0xFFD4, 0x000D, 0x0033, 0xFFD1, 0xFFF0, 0xFFE0, 0xFFF0,
    0xFFC0, 0x001A, 0x0005, 0x002A, 0x000B, 0xFFA5, 0xFFEF, 0xFFE4,
    0xFFF2, 0x0019, 0x0022, 0xFFCF, 0xFFF5, 0xFFF5, 0x0005, 0x000F,
    0xFFF6, 0x0011, 0x005C, 0xFFF2, 0xFFE5, 0x0006, 0x0008, 0x0042,
    0xFFDD, 0xFFE4, 0x001A, 0x001B, 0xFFF4, 0xFFCD, 0xFFD4, 0x0071,
    0xFFDE, 0xFFBC, 0x001B, 0x0002, 0x001E, 0xFFF4, 0x0023, 0x0016,
    0x0021, 0x001F, 0xFFBF, 0x002E, 0x0000, 0xFFF0, 0x000B, 0xFFE1,
    0xFFBC, 0xFFFD, 0x0005, 0x0017, 0xFFDF, 0xFFE3, 0xFFE8, 0xFFF4,
    0x0043, 0x0014, 0x002E, 0x0000, 0x0023, 0x0012, 0x001F, 0x0018,
    0x000D, 0x0011, 0x0041, 0x0008, 0x0005, 0xFFCD, 0x000B, 0x0045,
    0xFFFD, 0xFFDC, 0x0036, 0x001B, 0x0013, 0xFFF7, 0xFFF6, 0x002F,
    0xFFC6, 0x0009, 0xFFCD, 0x0010, 0x0031, 0xFFF9, 0xFFFA, 0x0004,
    0x002A, 0x0016, 0x002D, 0x0017, 0xFFC2, 0xFFFC, 0xFFF3, 0xFFF3,
    0xFFCC, 0xFFCF, 0x0002, 0xFFF8, 0xFFE0, 0xFFE5, 0x0000, 0xFFEF,
    0x000C, 0x001D, 0xFFDE, 0xFFF9, 0xFFDD, 0x0011, 0x0012, 0xFFF4,
    0x0011, 0x000C, 0xFFD4, 0x0034, 0xFFE2, 0x0009, 0x000E, 0x0005,
    0x0002, 0x0023, 0xFFDB, 0xFFE3, 0xFFE7, 0x0004, 0x002B, 0x0000,
    0xFFE6, 0xFFDB, 0xFFE6, 0x0008, 0xFFFB, 0xFFE1, 0xFFEA, 0xFFF4,
    0x0016, 0xFFE4, 0x005C, 0xFFD6, 0xFFFB, 0xFFC3, 0x0018, 0x0011,
    0x001A, 0xFFE1, 0x0028, 0xFFEC, 0x0000, 0x002D, 0x0014, 0xFFF5,
    0xFFF4, 0xFFF6, 0x001D, 0xFFE7, 0xFFBF, 0x0040, 0x005E, 0x0022,
    0x000F, 0x0000, 0xFFCF, 0xFFCB, 0xFFD8, 0x000A, 0x0006, 0xFFFE,
    0x0026, 0x2CFB, 0x0054, 0x0022, 0xFFFB, 0xFFF7, 0x0037, 0xFFD4,
    0xFFE2, 0xFFFA, 0x0002, 0xFFDD, 0xFFF2, 0xFFFF, 0x000C, 0xFFA9,
    0xFFFB, 0xFFC9, 0x000B, 0x0006, 0xFFFF, 0x003E, 0x0005, 0x0009,
    0x001B, 0xFFFF, 0x0010, 0xFFD4, 0x004A, 0x001B, 0x0014, 0xFFFC,
    0xFFE7, 0x0012, 0xFFE8, 0xFFDB, 0x0025, 0xFFDE, 0xFFDA, 0xFFFC,
    0x001D, 0x001A, 0x0004, 0xFFEE, 0x0035, 0x000A, 0x0018, 0xFFFD,
    0xFFF8, 0x0025, 0x001E, 0xFFF1, 0x0023, 0x0017, 0xFFE7, 0x0020,
    0xFFF5, 0xFFE8, 0x001D, 0x005C, 0xFFFB, 0x0013, 0xFFE7, 0xFFFA,
    0x0025, 0x0013, 0x0032, 0xFFD9, 0x0011, 0x0052, 0xFFD2, 0x002F,
    0x0002, 0x001C, 0xFFBC, 0x001B, 0x001C, 0x0007, 0xFFD5, 0x000D,
    0x0018, 0xFFDB, 0xFFF4, 0xFFFA, 0xFFF5, 0xFFF0, 0xFFF9, 0xFFF3,
    0xFFE5, 0xFFE5, 0x0020, 0xFFF7, 0xFFF5, 0xFFE9, 0xFFF6, 0xFFF9,
    0xFFF8, 0x0028, 0xFFF8, 0x0000, 0x0043, 0xFFBD, 0xFFDD, 0x0010,
    0xFFFB, 0x000C, 0x001A, 0x001C, 0xFFF7, 0xFFFB, 0x0021, 0x001C,
    0x0018, 0xFFD8, 0x0002, 0xFFF9, 0xFFF0, 0x0026, 0xFFF5, 0x0052,
    0x001C, 0x0012, 0x0022, 0xFFFB, 0xFFBA, 0xFFAF, 0xFFEB, 0x0006,
    0xFFB4, 0x000D, 0x0000, 0xFFFE, 0xFFB2, 0x0010, 0xFFFE, 0x0000,
    0xFFED, 0xFFFF, 0x0004, 0xFFE8, 0x001A, 0xFFDC, 0x001B, 0x0010,
    0xFFEB, 0xFFF4, 0x0053, 0xFFD9, 0xFFC5, 0x0020, 0x0027, 0x001F,
    0x000C, 0x0005, 0x001E, 0x0018, 0x0019, 0xFFD1, 0x0003, 0xFFFD,
    0x000F, 0xFFD0, 0xFFFA, 0xFFCD, 0xFFD2, 0x000B, 0x001C, 0x0033,
    0xFFD4, 0xFFFB, 0xFFA4, 0xFFC8, 0x001D, 0xFFFC, 0xFFEB, 0x0004,
    0x0024, 0xFFFF, 0x001A, 0xFFF6, 0xFFF3, 0xFFF5, 0xFFF1, 0x0001,
    0x000A, 0x0025, 0xFFDB, 0x0010, 0x000D, 0x0025, 0xFFD7, 0xFFCD,
    0x0028, 0xFFFF, 0xFFD6, 0x0024, 0xFFED, 0x0035, 0x0021, 0x0035,
    0x0018, 0x0050, 0x0022, 0xFFF1, 0xFFF5, 0xFFDA, 0x0023, 0xFFF6,
    0x0041, 0x000F, 0x0006, 0xFFD8, 0xFFE5, 0xFFE2, 0xFFCC, 0x0009,
    0xFFDC, 0xFFE2, 0xFF9D, 0xFFE5, 0x0018, 0x000F, 0x000E, 0x0007,
    0x0008, 0xFFE0, 0x0029, 0x0029, 0x0024, 0xFFB3, 0x002E, 0x0004,
    0x0043, 0xFFD2, 0xFFE8, 0x0031, 0x0000, 0xFFE6, 0xFFD2, 0x0007,
    0x0046, 0x0004, 0x0003, 0xFFF6, 0x0038, 0x001B, 0x0000, 0x003B,
    0x0025, 0xFFCD, 0xFFF4, 0x0022, 0xFFBD, 0x000A, 0xFFE5, 0xFFE1
    };

static const q15_t in_cfft_noisy_2048[4096] = {
    0xFB62, 0x0000, 0x4252, 0x0000, 0x59FB, 0x0000, 0x3BF4, 0x0000,
    0xF633, 0x0000, 0xC56A, 0x0000, 0xA3AC, 0x0000, 0xC639, 0x0000,
    0xFD4E, 0x0000, 0x4ED9, 0x0000, 0x57E3, 0x0000, 0x3BD7, 0x0000,
    0x048E, 0x0000, 0xC3DB, 0x0000, 0xA548, 0x0000, 0xBF86, 0x0000,
    0xF95E, 0x0000, 0x3046, 0x0000, 0x5692, 0x0000, 0x3EB4, 0x0000,
    0x058A, 0x0000, 0xBF50, 0x0000, 0xA3FB, 0x0000, 0xBF68, 0x0000,
    0xEF75, 0x0000, 0x451C, 0x0000, 0x6600, 0x0000, 0x404D, 0x0000,
    0x07E2, 0x0000, 0xC2D6, 0x0000, 0xA9F3, 0x0000, 0xC4F3, 0x0000,
    0x0264, 0x0000, 0x3BB1, 0x0000, 0x3ED0, 0x0000, 0x44E7, 0x0000,
    0x0354, 0x0000, 0xCD76, 0x0000, 0xA401, 0x0000, 0xC090, 0x0000,
    0xF8BA, 0x0000, 0x427F, 0x0000, 0x4B3D, 0x0000, 0x3CB3, 0x0000,
    0x0671, 0x0000, 0xC427, 0x0000, 0xA237, 0x0000, 0xC5E9, 0x0000,
    0xF954, 0x0000, 0x454F, 0x0000, 0x5A36, 0x0000, 0x3AB0, 0x0000,
    0xFC25, 0x0000, 0xB947, 0x0000, 0xAAFF, 0x0000, 0xBD6E, 0x0000,
    0x04D7, 0x0000, 0x41A1, 0x0000, 0x5D1B, 0x0000, 0x3AC4, 0x0000,
    0xFCF3, 0x0000, 0xB8B7, 0x0000, 0xA9BE, 0x0000, 0xC039, 0x0000,
    0x065F, 0x0000, 0x46B7, 0x0000, 0x5422, 0x0000, 0x4520, 0x0000,
    0xF8A2, 0x0000, 0xB932, 0x0000, 0xA427, 0x0000, 0xC811, 0x0000,
    0x06C0, 0x0000, 0x3461, 0x0000, 0x55FA, 0x0000, 0x40CB, 0x0000,
    0xFFD6, 0x0000, 0xC2CA, 0x0000, 0xA37E, 0x0000, 0xC9EE, 0x0000,
    0xFB7D, 0x0000, 0x41CD, 0x0000, 0x5504, 0x0000, 0x39DD, 0x0000,
    0xFC62, 0x0000, 0xB8D9, 0x0000, 0xA383, 0x0000, 0xC099, 0x0000,
    0xFCA5, 0x0000, 0x4AB8, 0x0000, 0x5917, 0x0000, 0x3AD8, 0x0000,
    0x09FD, 0x0000, 0xBB6E, 0x0000, 0xA330, 0x0000, 0xBD51, 0x0000,
    0x028B, 0x0000, 0x3F4B, 0x0000, 0x52FD, 0x0000, 0x3701, 0x0000,
    0xFAC3, 0x0000, 0xC0BA, 0x0000, 0xA17C, 0x0000, 0xC225, 0x0000,
    0xF6EF, 0x0000, 0x3942, 0x0000, 0x579F, 0x0000, 0x4740, 0x0000,
    0xFCA9, 0x0000, 0xC7CF, 0x0000, 0xAA16, 0x0000, 0xBF9A, 0x0000,
    0x00BF, 0x0000, 0x3813, 0x0000, 0x5E87, 0x0000, 0x489E, 0x0000,
    0xFCFD, 0x0000, 0xBCFB, 0x0000, 0x94BF, 0x0000, 0xB838, 0x0000,
    0x087A, 0x0000, 0x47D2, 0x0000, 0x4BB3, 0x0000, 0x3AA1, 0x0000,
    0x0408, 0x0000, 0xC583, 0x0000, 0x9C19, 0x0000, 0xB5FB, 0x0000,
    0xFB0D, 0x0000, 0x46DB, 0x0000, 0x5EBE, 0x0000, 0x4537, 0x0000,
    0xFEA3, 0x0000, 0xB904, 0x0000, 0xA23D, 0x0000, 0xBACB, 0x0000,
    0x069E, 0x0000, 0x3F18, 0x0000, 0x5FE1, 0x0000, 0x4033, 0x0000,
    0x04A7, 0x0000, 0xC1BD, 0x0000, 0xA5A4, 0x0000, 0xC051, 0x0000,
    0x02E1, 0x0000, 0x436F, 0x0000, 0x650A, 0x0000, 0x3CBB, 0x0000,
    0xFED3, 0x0000, 0xB643, 0x0000, 0x9C24, 0x0000, 0xCA8B, 0x0000,
    0xFD05, 0x0000, 0x351C, 0x0000, 0x5D8E, 0x0000, 0x4A51, 0x0000,
    0x1118, 0x0000, 0xBAB5, 0x0000, 0x9DD5, 0x0000, 0xBB24, 0x0000,
    0x0A7D, 0x0000, 0x39CC, 0x0000, 0x5F51, 0x0000, 0x4900, 0x0000,
    0x02BC, 0x0000, 0xC045, 0x0000, 0xA51D, 0x0000, 0xC1AB, 0x0000,
    0x02DB, 0x0000, 0x4231, 0x0000, 0x58F4, 0x0000, 0x3859, 0x0000,
    0xF97B, 0x0000, 0xBC0F, 0x0000, 0xA58D, 0x0000, 0xB970, 0x0000,
    0xFC2A, 0x0000, 0x3E48, 0x0000, 0x6345, 0x0000, 0x3874, 0x0000,
    0x04FF, 0x0000, 0xC662, 0x0000, 0xAC33, 0x0000, 0xB7E7, 0x0000,
    0xFF92, 0x0000, 0x3F6E, 0x0000, 0x610B, 0x0000, 0x389E, 0x0000,
    0xF9F1, 0x0000, 0xB69D, 0x0000, 0xA7AC, 0x0000, 0xC028, 0x0000,
    0xFF88, 0x0000, 0x418F, 0x0000, 0x5B14, 0x0000, 0x3EB6, 0x0000,
    0xFDEE, 0x0000, 0xBBC8, 0x0000, 0xAD60, 0x0000, 0xC1CC, 0x0000,
    0x028E, 0x0000, 0x4454, 0x0000, 0x546C, 0x0000, 0x4440, 0x0000,
    0x0819, 0x0000, 0xBCEE, 0x0000, 0xAC41, 0x0000, 0xC6E3, 0x0000,
    0x069C, 0x0000, 0x441D, 0x0000, 0x5F61, 0x0000, 0x45ED, 0x0000,
    0x0541, 0x0000, 0xC3D9, 0x0000, 0xACCE, 0x0000, 0xBCF5, 0x0000,
    0x0463, 0x0000, 0x3C6D, 0x0000, 0x5290, 0x0000, 0x3F40, 0x0000,
    0xFB25, 0x0000, 0xC2A4, 0x0000, 0x980F, 0x0000, 0xC565, 0x0000,
    0x0060, 0x0000, 0x3E38, 0x0000, 0x5B1C, 0x0000, 0x3925, 0x0000,
    0xFC59, 0x0000, 0xCC37, 0x0000, 0xAA79, 0x0000, 0xBF51, 0x0000,
    0xFA55, 0x0000, 0x45B6, 0x0000, 0x5184, 0x0000, 0x3B62, 0x0000,
    0xFF58, 0x0000, 0xCBFA, 0x0000, 0xAB66, 0x0000, 0xB53D, 0x0000,
    0xFF63, 0x0000, 0x44B4, 0x0000, 0x54A7, 0x0000, 0x441C, 0x0000,
    0xFD5F, 0x0000, 0xC6F7, 0x0000, 0xA4FA, 0x0000, 0xB7F4, 0x0000,
    0x035A, 0x0000, 0x3E31, 0x0000, 0x58BD, 0x0000, 0x4885, 0x0000,
    0x0441, 0x0000, 0xC6BB, 0x0000, 0xA31A, 0x0000, 0xC381, 0x0000,
    0x0150, 0x0000, 0x3E74, 0x0000, 0x5DA4, 0x0000, 0x4346, 0x0000,
    0x00AC, 0x0000, 0xC700, 0x0000, 0xA8C3, 0x0000, 0xC159, 0x0000,
    0x0179, 0x0000, 0x372A, 0x0000, 0x4F68, 0x0000, 0x4138, 0x0000,
    0x0196, 0x0000, 0xC261, 0x0000, 0xB112, 0x0000, 0xC4DB, 0x0000,
    0xFB2F, 0x0000, 0x3F60, 0x0000, 0x64CF, 0x0000, 0x46A4, 0x0000,
    0xF954, 0x0000, 0xC454, 0x0000, 0xA5BF, 0x0000, 0xC3B0, 0x0000,
    0x03E5, 0x0000, 0x4158, 0x0000, 0x6032, 0x0000, 0x3F7B, 0x0000,
    0xF27C, 0x0000, 0xC432, 0x0000, 0xA76D, 0x0000, 0xBAD1, 0x0000,
    0x030F, 0x0000, 0x3CF8, 0x0000, 0x4E5F, 0x0000, 0x4256, 0x0000,
    0x0298, 0x0000, 0xBF7B, 0x0000, 0xA72A, 0x0000, 0xBFCC, 0x0000,
    0xF736, 0x0000, 0x39A0, 0x0000, 0x5376, 0x0000, 0x417D, 0x0000,
    0xFD3E, 0x0000, 0xB490, 0x0000, 0xA8DD, 0x0000, 0xC7BB, 0x0000,
    0x076B, 0x0000, 0x3BDA, 0x0000, 0x5A13, 0x0000, 0x2FCE, 0x0000,
    0x09DC, 0x0000, 0xC9EE, 0x0000, 0xA3E4, 0x0000, 0xC009, 0x0000,
    0xFA41, 0x0000, 0x422A, 0x0000, 0x5FDB, 0x0000, 0x44FF, 0x0000,
    0xF7E7, 0x0000, 0xBACB, 0x0000, 0xA7CF, 0x0000, 0xC394, 0x0000,
    0x06AC, 0x0000, 0x3C43, 0x0000, 0x5963, 0x0000, 0x4565, 0x0000,
    0x05AC, 0x0000, 0xBEDF, 0x0000, 0xA489, 0x0000, 0xC056, 0x0000,
    0x0853, 0x0000, 0x39F6, 0x0000, 0x5A73, 0x0000, 0x4A80, 0x0000,
    0x0101, 0x0000, 0xB5FD, 0x0000, 0xA9E3, 0x0000, 0xCBB3, 0x0000,
    0xF8AD, 0x0000, 0x3D70, 0x0000, 0x5165, 0x0000, 0x46DC, 0x0000,
    0xF6D8, 0x0000, 0xBE9E, 0x0000, 0xA73D, 0x0000, 0xBC84, 0x0000,
    0xFAF4, 0x0000, 0x43B6, 0x0000, 0x4EB5, 0x0000, 0x438E, 0x0000,
    0x000D, 0x0000, 0xBCF3, 0x0000, 0xB031, 0x0000, 0xC0C8, 0x0000,
    0x04E7, 0x0000, 0x3A11, 0x0000, 0x5191, 0x0000, 0x4B96, 0x0000,
    0x02B1, 0x0000, 0xBC03, 0x0000, 0xA44F, 0x0000, 0xB450, 0x0000,
    0x0165, 0x0000, 0x466E, 0x0000, 0x54E9, 0x0000, 0x3A54, 0x0000,
    0xF9F0, 0x0000, 0xBF59, 0x0000, 0x9B67, 0x0000, 0xC0B5, 0x0000,
    0x02E1, 0x0000, 0x3FF5, 0x0000, 0x5B84, 0x0000, 0x470B, 0x0000,
    0x0F5E, 0x0000, 0xBAA1, 0x0000, 0xA79A, 0x0000, 0xB5E4, 0x0000,
    0x0243, 0x0000, 0x3BA6, 0x0000, 0x6123, 0x0000, 0x3F0E, 0x0000,
    0xFAB1, 0x0000, 0xC3A0, 0x0000, 0xA692, 0x0000, 0xC450, 0x0000,
    0x0764, 0x0000, 0x3A85, 0x0000, 0x5CB9, 0x0000, 0x3F4A, 0x0000,
    0x0469, 0x0000, 0xC8C4, 0x0000, 0xA887, 0x0000, 0xCE17, 0x0000,
    0x023D, 0x0000, 0x37EE, 0x0000, 0x5080, 0x0000, 0x3E48, 0x0000,
    0xFF32, 0x0000, 0xC516, 0x0000, 0xA5F1, 0x0000, 0xB0CA, 0x0000,
    0x012B, 0x0000, 0x400A, 0x0000, 0x6645, 0x0000, 0x462A, 0x0000,
    0x071A, 0x0000, 0xBC94, 0x0000, 0x9CB0, 0x0000, 0xB70D, 0x0000,
    0x07DF, 0x0000, 0x3B1A, 0x0000, 0x5DB7, 0x0000, 0x40B5, 0x0000,
    0xF93B, 0x0000, 0xC7CE, 0x0000, 0xA9EA, 0x0000, 0xB7DC, 0x0000,
    0x0205, 0x0000, 0x39F9, 0x0000, 0x5A85, 0x0000, 0x4995, 0x0000,
    0xFB52, 0x0000, 0xC3A7, 0x0000, 0x9E26, 0x0000, 0xB3B4, 0x0000,
    0xF5A2, 0x0000, 0x4017, 0x0000, 0x55AA, 0x0000, 0x4260, 0x0000,
    0x005A, 0x0000, 0xBD92, 0x0000, 0xA338, 0x0000, 0xC9AC, 0x0000,
    0x0982, 0x0000, 0x4C10, 0x0000, 0x55A6, 0x0000, 0x4629, 0x0000,
    0x0F7A, 0x0000, 0xC148, 0x0000, 0x9800, 0x0000, 0xB9CC, 0x0000,
    0x0162, 0x0000, 0x4E92, 0x0000, 0x534D, 0x0000, 0x4038, 0x0000,
    0x0383, 0x0000, 0xBE95, 0x0000, 0xA81C, 0x0000, 0xB729, 0x0000,
    0xF77D, 0x0000, 0x3C14, 0x0000, 0x573B, 0x0000, 0x4073, 0x0000,
    0x0E2B, 0x0000, 0xC057, 0x0000, 0xA824, 0x0000, 0xCF6D, 0x0000,
    0x0278, 0x0000, 0x4779, 0x0000, 0x542C, 0x0000, 0x42C2, 0x0000,
    0xFEDB, 0x0000, 0xBB62, 0x0000, 0xA7A1, 0x0000, 0xB85F, 0x0000,
    0x0ADF, 0x0000, 0x492C, 0x0000, 0x5C76, 0x0000, 0x4616, 0x0000,
    0x08BA, 0x0000, 0xC10D, 0x0000, 0xA506, 0x0000, 0xB7A4, 0x0000,
    0x02CC, 0x0000, 0x3BB0, 0x0000, 0x5143, 0x0000, 0x445C, 0x0000,
    0xFC65, 0x0000, 0xCA54, 0x0000, 0xA470, 0x0000, 0xC5EA, 0x0000,
    0xFE79, 0x0000, 0x3943, 0x0000, 0x5BB6, 0x0000, 0x3688, 0x0000,
    0x0386, 0x0000, 0xC9E4, 0x0000, 0xACCC, 0x0000, 0xBEA7, 0x0000,
    0x08C6, 0x0000, 0x38A2, 0x0000, 0x655F, 0x0000, 0x41E7, 0x0000,
    0x02F8, 0x0000, 0xBDA8, 0x0000, 0xA050, 0x0000, 0xB45B, 0x0000,
    0xF922, 0x0000, 0x37E9, 0x0000, 0x62AA, 0x0000, 0x41F3, 0x0000,
    0xFA85, 0x0000, 0xC4A9, 0x0000, 0xAB8E, 0x0000, 0xB624, 0x0000,
    0x01C7, 0x0000, 0x4B6D, 0x0000, 0x5529, 0x0000, 0x45C1, 0x0000,
    0xF8D1, 0x0000, 0xCB57, 0x0000, 0xA675, 0x0000, 0xB6EB, 0x0000,
    0xFC25, 0x0000, 0x3745, 0x0000, 0x508B, 0x0000, 0x39F4, 0x0000,
    0xFB51, 0x0000, 0xBFCA, 0x0000, 0xA44A, 0x0000, 0xCAA2, 0x0000,
    0x01E6, 0x0000, 0x42B8, 0x0000, 0x5B28, 0x0000, 0x439E, 0x0000,
    0xFC48, 0x0000, 0xBD42, 0x0000, 0xA263, 0x0000, 0xC0CA, 0x0000,
    0x0671, 0x0000, 0x4064, 0x0000, 0x55EC, 0x0000, 0x30A8, 0x0000,
    0x0554, 0x0000, 0xC3C8, 0x0000, 0xA5E8, 0x0000, 0xC2EE, 0x0000,
    0xFDD8, 0x0000, 0x316F, 0x0000, 0x5BAA, 0x0000, 0x4693, 0x0000,
    0xFE89, 0x0000, 0xC88E, 0x0000, 0xA2E9, 0x0000, 0xB8DF, 0x0000,
    0xFEB5, 0x0000, 0x40A7, 0x0000, 0x5001, 0x0000, 0x433B, 0x0000,
    0xF4FA, 0x0000, 0xBBDB, 0x0000, 0xB1FC, 0x0000, 0xBD90, 0x0000,
    0xF82D, 0x0000, 0x45A1, 0x0000, 0x557E, 0x0000, 0x49A5, 0x0000,
    0xFEC6, 0x0000, 0xBA41, 0x0000, 0xA210, 0x0000, 0xBDDA, 0x0000,
    0xFCEC, 0x0000, 0x4506, 0x0000, 0x4ECF, 0x0000, 0x3F0C, 0x0000,
    0xFDF3, 0x0000, 0xC861, 0x0000, 0xA14B, 0x0000, 0xB922, 0x0000,
    0xFF18, 0x0000, 0x418C, 0x0000, 0x5C0D, 0x0000, 0x3BD3, 0x0000,
    0xFB3D, 0x0000, 0xC604, 0x0000, 0xA52C, 0x0000, 0xC588, 0x0000,
    0xFD91, 0x0000, 0x44FB, 0x0000, 0x5ED6, 0x0000, 0x42BE, 0x0000,
    0xFA0E, 0x0000, 0xBFB2, 0x0000, 0x9D4E, 0x0000, 0xBD60, 0x0000,
    0xFF7B, 0x0000, 0x4306, 0x0000, 0x4FB4, 0x0000, 0x44C8, 0x0000,
    0xFD27, 0x0000, 0xBDE2, 0x0000, 0xA753, 0x0000, 0xC226, 0x0000,
    0xF699, 0x0000, 0x4705, 0x0000, 0x4E52, 0x0000, 0x4407, 0x0000,
    0xF60B, 0x0000, 0xBFAD, 0x0000, 0xA729, 0x0000, 0xC0CF, 0x0000,
    0x038A, 0x0000, 0x47FE, 0x0000, 0x590B, 0x0000, 0x411E, 0x0000,
    0x01E4, 0x0000, 0xBBFF, 0x0000, 0xA1F6, 0x0000, 0xB839, 0x0000,
    0xFBAF, 0x0000, 0x3F43, 0x0000, 0x612E, 0x0000, 0x45C9, 0x0000,
    0xFE03, 0x0000, 0xC3B1, 0x0000, 0xA7DA, 0x0000, 0xC12D, 0x0000,
    0x0142, 0x0000, 0x46D5, 0x0000, 0x55EC, 0x0000, 0x3F69, 0x0000,
    0x0E7B, 0x0000, 0xC57E, 0x0000, 0xA87D, 0x0000, 0xBB5A, 0x0000,
    0xF77C, 0x0000, 0x4EF2, 0x0000, 0x59AD, 0x0000, 0x2B45, 0x0000,
    0x06D0, 0x0000, 0xBEF1, 0x0000, 0xAEAA, 0x0000, 0xC75D, 0x0000,
    0xFCEC, 0x0000, 0x37C0, 0x0000, 0x60C8, 0x0000, 0x44E5, 0x0000,
    0x0513, 0x0000, 0xC262, 0x0000, 0xAA43, 0x0000, 0xC0B2, 0x0000,
    0xFEB6, 0x0000, 0x2D22, 0x0000, 0x4FC8, 0x0000, 0x4333, 0x0000,
    0x022E, 0x0000, 0xC4E2, 0x0000, 0xAB4C, 0x0000, 0xBDC3, 0x0000,
    0x0D67, 0x0000, 0x3C81, 0x0000, 0x6444, 0x0000, 0x3AB7, 0x0000,
    0xFE7A, 0x0000, 0xC180, 0x0000, 0xA686, 0x0000, 0xBBEA, 0x0000,
    0xFF6E, 0x0000, 0x45CA, 0x0000, 0x5196, 0x0000, 0x3A34, 0x0000,
    0x01D3, 0x0000, 0xC000, 0x0000, 0x9E1D, 0x0000, 0xC68C, 0x0000,
    0xF87C, 0x0000, 0x3BBB, 0x0000, 0x5C6D, 0x0000, 0x45B2, 0x0000,
    0x000E, 0x0000, 0xC322, 0x0000, 0xA5CC, 0x0000, 0xBB7C, 0x0000,
    0xFA0E, 0x0000, 0x3FA1, 0x0000, 0x6080, 0x0000, 0x4A75, 0x0000,
    0xF453, 0x0000, 0xC2DE, 0x0000, 0xB1A8, 0x0000, 0xB656, 0x0000,
    0x0446, 0x0000, 0x3FFD, 0x0000, 0x5C31, 0x0000, 0x3A3D, 0x0000,
    0x0225, 0x0000, 0xC8C8, 0x0000, 0xAA53, 0x0000, 0xBF32, 0x0000,
    0x07BE, 0x0000, 0x391C, 0x0000, 0x535E, 0x0000, 0x3FB2, 0x0000,
    0x0C6F, 0x0000, 0xBD45, 0x0000, 0xAAC4, 0x0000, 0xBB00, 0x0000,
    0x09CE, 0x0000, 0x3E6C, 0x0000, 0x5B42, 0x0000, 0x3434, 0x0000,
    0xFCFC, 0x0000, 0xC1E2, 0x0000, 0xA09B, 0x0000, 0xC18B, 0x0000,
    0x0CD1, 0x0000, 0x3D30, 0x0000, 0x59A7, 0x0000, 0x43B5, 0x0000,
    0x04E4, 0x0000, 0xC3CF, 0x0000, 0xA1C8, 0x0000, 0xC76F, 0x0000,
    0x04A5, 0x0000, 0x40B7, 0x0000, 0x61AC, 0x0000, 0x41A6, 0x0000,
    0xFDE2, 0x0000, 0xBE31, 0x0000, 0xA762, 0x0000, 0xC252, 0x0000,
    0xFE5A, 0x0000, 0x3D76, 0x0000, 0x5AC1, 0x0000, 0x3E8A, 0x0000,
    0xFAE7, 0x0000, 0xCC78, 0x0000, 0x9E40, 0x0000, 0xBA60, 0x0000,
    0xFF7E, 0x0000, 0x457F, 0x0000, 0x5947, 0x0000, 0x3CCB, 0x0000,
    0xFF31, 0x0000, 0xC1F3, 0x0000, 0xA799, 0x0000, 0xC3BD, 0x0000,
    0x01A9, 0x0000, 0x4256, 0x0000, 0x56D7, 0x0000, 0x3920, 0x0000,
    0x086E, 0x0000, 0xBCB7, 0x0000, 0xAF27, 0x0000, 0xBD65, 0x0000,
    0x01C8, 0x0000, 0x3D18, 0x0000, 0x562E, 0x0000, 0x3852, 0x0000,
    0xFE27, 0x0000, 0xCA64, 0x0000, 0xAD94, 0x0000, 0xC440, 0x0000,
    0xF82F, 0x0000, 0x3F62, 0x0000, 0x5D95, 0x0000, 0x3F5B, 0x0000,
    0x008A, 0x0000, 0xCDC5, 0x0000, 0xACD1, 0x0000, 0xCB32, 0x0000,
    0xF937, 0x0000, 0x3BEA, 0x0000, 0x5F05, 0x0000, 0x3A65, 0x0000,
    0xFCDE, 0x0000, 0xB788, 0x0000, 0xA3A6, 0x0000, 0xB883, 0x0000,
    0xFF05, 0x0000, 0x472D, 0x0000, 0x564D, 0x0000, 0x3E0F, 0x0000,
    0xF631, 0x0000, 0xC25C, 0x0000, 0xA38F, 0x0000, 0xD151, 0x0000,
    0xFD57, 0x0000, 0x467E, 0x0000, 0x4C4A, 0x0000, 0x4309, 0x0000,
    0xFBD3, 0x0000, 0xC455, 0x0000, 0xA3B8, 0x0000, 0xBD0C, 0x0000,
    0xFDDF, 0x0000, 0x4766, 0x0000, 0x509A, 0x0000, 0x3F08, 0x0000,
    0xFC7C, 0x0000, 0xBF83, 0x0000, 0x9A3E, 0x0000, 0xC04C, 0x0000,
    0xFF3D, 0x0000, 0x3D77, 0x0000, 0x5AAF, 0x0000, 0x3A37, 0x0000,
    0x095A, 0x0000, 0xC470, 0x0000, 0xAE54, 0x0000, 0xBE5C, 0x0000,
    0xF2E0, 0x0000, 0x352D, 0x0000, 0x56A0, 0x0000, 0x3EA6, 0x0000,
    0x0846, 0x0000, 0xBD02, 0x0000, 0xAA37, 0x0000, 0xC4A8, 0x0000,
    0xF698, 0x0000, 0x3F45, 0x0000, 0x5AD4, 0x0000, 0x3F8A, 0x0000,
    0xF2C8, 0x0000, 0xC139, 0x0000, 0x9A93, 0x0000, 0xB33B, 0x0000,
    0x0746, 0x0000, 0x3792, 0x0000, 0x4F78, 0x0000, 0x445C, 0x0000,
    0x03F4, 0x0000, 0xBF59, 0x0000, 0xAAB3, 0x0000, 0xBC77, 0x0000,
    0x06BC, 0x0000, 0x4F84, 0x0000, 0x5593, 0x0000, 0x37BF, 0x0000,
    0xFEF4, 0x0000, 0xC6C2, 0x0000, 0xA879, 0x0000, 0xC39E, 0x0000,
    0xF3AA, 0x0000, 0x3510, 0x0000, 0x5CE3, 0x0000, 0x38C0, 0x0000,
    0xFE95, 0x0000, 0xC55A, 0x0000, 0xAB5C, 0x0000, 0xC6B2, 0x0000,
    0xFE68, 0x0000, 0x40CE, 0x0000, 0x564B, 0x0000, 0x395B, 0x0000,
    0xFA69, 0x0000, 0xBA7A, 0x0000, 0xA9BC, 0x0000, 0xBF18, 0x0000,
    0xFA24, 0x0000, 0x4097, 0x0000, 0x57E7, 0x0000, 0x3D6A, 0x0000,
    0xFE30, 0x0000, 0xBEE0, 0x0000, 0xA21E, 0x0000, 0xC54D, 0x0000,
    0xFDB8, 0x0000, 0x460C, 0x0000, 0x5E7E, 0x0000, 0x3C38, 0x0000,
    0x0A69, 0x0000, 0xC357, 0x0000, 0xA20A, 0x0000, 0xB6EE, 0x0000,
    0x04D0, 0x0000, 0x3DD9, 0x0000, 0x594C, 0x0000, 0x48E3, 0x0000,
    0xFEDD, 0x0000, 0xC871, 0x0000, 0xB344, 0x0000, 0xC462, 0x0000,
    0x0514, 0x0000, 0x5368, 0x0000, 0x4E26, 0x0000, 0x43BC, 0x0000,
    0x08CC, 0x0000, 0xC18F, 0x0000, 0xA8DE, 0x0000, 0xBAA0, 0x0000,
    0x0604, 0x0000, 0x3C36, 0x0000, 0x61FE, 0x0000, 0x466C, 0x0000,
    0xF77A, 0x0000, 0xBB6A, 0x0000, 0xAB0C, 0x0000, 0xC307, 0x0000,
    0x03B0, 0x0000, 0x4446, 0x0000, 0x4FA4, 0x0000, 0x3BEA, 0x0000,
    0x06AE, 0x0000, 0xBAB1, 0x0000, 0xA7EB, 0x0000, 0xC969, 0x0000,
    0xFFF8, 0x0000, 0x3E0E, 0x0000, 0x577E, 0x0000, 0x4A3F, 0x0000,
    0xFB7D, 0x0000, 0xB9A6, 0x0000, 0x9DA9, 0x0000, 0xC0E3, 0x0000,
    0x01DF, 0x0000, 0x422F, 0x0000, 0x5124, 0x0000, 0x4B86, 0x0000,
    0xFF80, 0x0000, 0xB68D, 0x0000, 0xA009, 0x0000, 0xC35A, 0x0000,
    0xF101, 0x0000, 0x46CF, 0x0000, 0x5EA9, 0x0000, 0x4A5B, 0x0000,
    0xF4ED, 0x0000, 0xBCE8, 0x0000, 0xA006, 0x0000, 0xC3E8, 0x0000,
    0xF04C, 0x0000, 0x39D4, 0x0000, 0x64A1, 0x0000, 0x42EB, 0x0000,
    0x0A2C, 0x0000, 0xBC73, 0x0000, 0xA259, 0x0000, 0xC415, 0x0000,
    0x060E, 0x0000, 0x4824, 0x0000, 0x6040, 0x0000, 0x3F1D, 0x0000,
    0xF3D9, 0x0000, 0xC312, 0x0000, 0xA260, 0x0000, 0xBD7F, 0x0000,
    0xFCD4, 0x0000, 0x39A6, 0x0000, 0x57BA, 0x0000, 0x3E7C, 0x0000,
    0x0B99, 0x0000, 0xBD42, 0x0000, 0xA352, 0x0000, 0xC095, 0x0000,
    0xFB5D, 0x0000, 0x455C, 0x0000, 0x5BFC, 0x0000, 0x3A90, 0x0000,
    0x0114, 0x0000, 0xC34F, 0x0000, 0xA4E6, 0x0000, 0xBEE0, 0x0000,
    0x0201, 0x0000, 0x3AF5, 0x0000, 0x50D2, 0x0000, 0x43CD, 0x0000,
    0x02E6, 0x0000, 0xB6B0, 0x0000, 0x9813, 0x0000, 0xC3AD, 0x0000,
    0x0501, 0x0000, 0x3DC8, 0x0000, 0x6091, 0x0000, 0x4195, 0x0000,
    0x0932, 0x0000, 0xC4D1, 0x0000, 0xA234, 0x0000, 0xC2EC, 0x0000,
    0x0100, 0x0000, 0x404A, 0x0000, 0x5EAA, 0x0000, 0x3D90, 0x0000,
    0x065A, 0x0000, 0xC50E, 0x0000, 0xA7BE, 0x0000, 0xC837, 0x0000,
    0x1028, 0x0000, 0x3E10, 0x0000, 0x5738, 0x0000, 0x40A6, 0x0000,
    0xFC07, 0x0000, 0xB629, 0x0000, 0xAEC7, 0x0000, 0xC8A8, 0x0000,
    0x06AB, 0x0000, 0x3EE7, 0x0000, 0x581E, 0x0000, 0x46B8, 0x0000,
    0xFF0B, 0x0000, 0xBEC7, 0x0000, 0xA434, 0x0000, 0xC33D, 0x0000,
    0xFF32, 0x0000, 0x3EAF, 0x0000, 0x55F0, 0x0000, 0x365E, 0x0000,
    0xF5E4, 0x0000, 0xC51E, 0x0000, 0xA89C, 0x0000, 0xBD9E, 0x0000,
    0x05E9, 0x0000, 0x2D62, 0x0000, 0x53FD, 0x0000, 0x407A, 0x0000,
    0x07E5, 0x0000, 0xB7E8, 0x0000, 0xAE20, 0x0000, 0xBEF7, 0x0000,
    0xF9D4, 0x0000, 0x47DA, 0x0000, 0x57A5, 0x0000, 0x44EE, 0x0000,
    0xFEF3, 0x0000, 0xC8F6, 0x0000, 0x9A97, 0x0000, 0xBDE5, 0x0000,
    0xF9F1, 0x0000, 0x4249, 0x0000, 0x56A7, 0x0000, 0x3E78, 0x0000,
    0x097A, 0x0000, 0xBF41, 0x0000, 0xA228, 0x0000, 0xC488, 0x0000,
    0x01DB, 0x0000, 0x37A5, 0x0000, 0x56D6, 0x0000, 0x4E06, 0x0000,
    0xFB37, 0x0000, 0xBD5D, 0x0000, 0xA4F6, 0x0000, 0xBFAA, 0x0000,
    0xFB46, 0x0000, 0x3BB0, 0x0000, 0x53DC, 0x0000, 0x4292, 0x0000,
    0xFD1D, 0x0000, 0xC1E4, 0x0000, 0xA971, 0x0000, 0xBA96, 0x0000,
    0xFFDB, 0x0000, 0x4A17, 0x0000, 0x5B52, 0x0000, 0x4377, 0x0000,
    0xFBC2, 0x0000, 0xC473, 0x0000, 0xA93F, 0x0000, 0xCB45, 0x0000,
    0x1106, 0x0000, 0x3F1E, 0x0000, 0x56C5, 0x0000, 0x4808, 0x0000,
    0x00CF, 0x0000, 0xC078, 0x0000, 0xB028, 0x0000, 0xCBB8, 0x0000,
    0x0208, 0x0000, 0x3BFD, 0x0000, 0x57A2, 0x0000, 0x37D8, 0x0000,
    0xFA87, 0x0000, 0xC269, 0x0000, 0xAEB5, 0x0000, 0xBA7E, 0x0000,
    0x0067, 0x0000, 0x4391, 0x0000, 0x5C6B, 0x0000, 0x44B8, 0x0000,
    0x034F, 0x0000, 0xC21C, 0x0000, 0xAC96, 0x0000, 0xBDC8, 0x0000,
    0xFA62, 0x0000, 0x468C, 0x0000, 0x673F, 0x0000, 0x47FD, 0x0000,
    0x06ED, 0x0000, 0xC3B0, 0x0000, 0xA750, 0x0000, 0xC15B, 0x0000,
    0x007E, 0x0000, 0x390E, 0x0000, 0x5E56, 0x0000, 0x3747, 0x0000,
    0xF8E6, 0x0000, 0xC726, 0x0000, 0xA4F2, 0x0000, 0xB560, 0x0000,
    0x00EB, 0x0000, 0x3DE6, 0x0000, 0x5AE0, 0x0000, 0x4689, 0x0000,
    0x064B, 0x0000, 0xBD4B, 0x0000, 0x9F14, 0x0000, 0xC273, 0x0000,
    0x01D2, 0x0000, 0x38B4, 0x0000, 0x5802, 0x0000, 0x3E99, 0x0000,
    0x0A27, 0x0000, 0xBF7C, 0x0000, 0xA921, 0x0000, 0xBB3D, 0x0000,
    0x043D, 0x0000, 0x3BEB, 0x0000, 0x5399, 0x0000, 0x388E, 0x0000,
    0x0108, 0x0000, 0xB9CD, 0x0000, 0x9E0F, 0x0000, 0xC098, 0x0000,
    0x0544, 0x0000, 0x4D38, 0x0000, 0x5A9A, 0x0000, 0x3ADD, 0x0000,
    0xFD85, 0x0000, 0xB776, 0x0000, 0xAA47, 0x0000, 0xBC8A, 0x0000,
    0xFE28, 0x0000, 0x3508, 0x0000, 0x5739, 0x0000, 0x3806, 0x0000,
    0xFA63, 0x0000, 0xC2D9, 0x0000, 0xAAE1, 0x0000, 0xB9A3, 0x0000,
    0xFAE0, 0x0000, 0x4675, 0x0000, 0x5B78, 0x0000, 0x3D5A, 0x0000,
    0xFB37, 0x0000, 0xBFBF, 0x0000, 0xAC6D, 0x0000, 0xBD21, 0x0000,
    0xFADC, 0x0000, 0x4983, 0x0000, 0x64A2, 0x0000, 0x3E22, 0x0000,
    0x02AD, 0x0000, 0xBDE0, 0x0000, 0xA4BE, 0x0000, 0xC409, 0x0000,
    0x0255, 0x0000, 0x3716, 0x0000, 0x57F2, 0x0000, 0x3F15, 0x0000,
    0x03BC, 0x0000, 0xBB45, 0x0000, 0xA177, 0x0000, 0xBCFF, 0x0000,
    0xFF1A, 0x0000, 0x40FA, 0x0000, 0x5829, 0x0000, 0x4048, 0x0000,
    0x04FA, 0x0000, 0xB9AC, 0x0000, 0xA5AF, 0x0000, 0xB9CA, 0x0000,
    0xF7A1, 0x0000, 0x42AA, 0x0000, 0x62BA, 0x0000, 0x330D, 0x0000,
    0x04D4, 0x0000, 0xC1E7, 0x0000, 0xAE51, 0x0000, 0xB8D7, 0x0000,
    0xFD1E, 0x0000, 0x3A3C, 0x0000, 0x583E, 0x0000, 0x3D72, 0x0000,
    0x03AE, 0x0000, 0xBB5B, 0x0000, 0xA0CF, 0x0000, 0xB6A1, 0x0000,
    0xF733, 0x0000, 0x4A7E, 0x0000, 0x5AF7, 0x0000, 0x43BB, 0x0000,
    0x00B9, 0x0000, 0xBC39, 0x0000, 0xA589, 0x0000, 0xC61D, 0x0000,
    0x0304, 0x0000, 0x3A17, 0x0000, 0x565C, 0x0000, 0x3544, 0x0000,
    0xFC06, 0x0000, 0xBBD4, 0x0000, 0xA13A, 0x0000, 0xC28A, 0x0000,
    0x0555, 0x0000, 0x46B4, 0x0000, 0x52A9, 0x0000, 0x35EF, 0x0000,
    0x0864, 0x0000, 0xB9DB, 0x0000, 0x9C68, 0x0000, 0xB5C4, 0x0000,
    0xFEFE, 0x0000, 0x4377, 0x0000, 0x4F7D, 0x0000, 0x37CB, 0x0000,
    0x006F, 0x0000, 0xC32C, 0x0000, 0x9E1B, 0x0000, 0xB6D7, 0x0000,
    0xFDBF, 0x0000, 0x392D, 0x0000, 0x4F19, 0x0000, 0x449E, 0x0000,
    0xFDBE, 0x0000, 0xBB14, 0x0000, 0xA695, 0x0000, 0xB281, 0x0000,
    0x05CA, 0x0000, 0x3B79, 0x0000, 0x4F97, 0x0000, 0x39CC, 0x0000,
    0xF219, 0x0000, 0xBFC6, 0x0000, 0xA660, 0x0000, 0xC999, 0x0000,
    0x06FD, 0x0000, 0x3ED0, 0x0000, 0x5B21, 0x0000, 0x3CA5, 0x0000,
    0x014B, 0x0000, 0xC3C1, 0x0000, 0xA685, 0x0000, 0xBACA, 0x0000,
    0x0044, 0x0000, 0x4204, 0x0000, 0x5DAC, 0x0000, 0x3898, 0x0000,
    0xFE74, 0x0000, 0xC371, 0x0000, 0xA1AB, 0x0000, 0xC827, 0x0000,
    0xFDAC, 0x0000, 0x3EE4, 0x0000, 0x60A9, 0x0000, 0x426A, 0x0000,
    0xF923, 0x0000, 0xCF0C, 0x0000, 0xA9DC, 0x0000, 0xC693, 0x0000,
    0xFF3E, 0x0000, 0x3BEE, 0x0000, 0x5D3E, 0x0000, 0x54C1, 0x0000,
    0x0AB9, 0x0000, 0xC0CA, 0x0000, 0xAB86, 0x0000, 0xC131, 0x0000,
    0xFB3B, 0x0000, 0x3EEF, 0x0000, 0x5988, 0x0000, 0x46B2, 0x0000,
    0xFC4E, 0x0000, 0xBE34, 0x0000, 0xAD73, 0x0000, 0xC596, 0x0000,
    0xFBAE, 0x0000, 0x4467, 0x0000, 0x5CBF, 0x0000, 0x3AAF, 0x0000,
    0xFAFE, 0x0000, 0xB2D6, 0x0000, 0xB10D, 0x0000, 0xC777, 0x0000,
    0xFE61, 0x0000, 0x443B, 0x0000, 0x5F75, 0x0000, 0x3C6C, 0x0000,
    0x0D52, 0x0000, 0xBC56, 0x0000, 0xA3F2, 0x0000, 0xC152, 0x0000,
    0xFD2F, 0x0000, 0x3D7C, 0x0000, 0x5DD7, 0x0000, 0x3E82, 0x0000,
    0xFFCC, 0x0000, 0xCB3A, 0x0000, 0xAA3E, 0x0000, 0xD37E, 0x0000,
    0xFB1F, 0x0000, 0x3ECC, 0x0000, 0x5066, 0x0000, 0x34FD, 0x0000,
    0x0103, 0x0000, 0xC649, 0x0000, 0xAF0D, 0x0000, 0xC248, 0x0000,
    0xFA27, 0x0000, 0x3A05, 0x0000, 0x4A9C, 0x0000, 0x3BC6, 0x0000,
    0xF2C7, 0x0000, 0xC10F, 0x0000, 0xACBE, 0x0000, 0xBBAE, 0x0000,
    0xFAE1, 0x0000, 0x3C51, 0x0000, 0x564E, 0x0000, 0x4896, 0x0000,
    0xF7B0, 0x0000, 0xC199, 0x0000, 0xA4D2, 0x0000, 0xC477, 0x0000,
    0x0294, 0x0000, 0x3254, 0x0000, 0x5615, 0x0000, 0x4723, 0x0000,
    0x035E, 0x0000, 0xBDB5, 0x0000, 0xA3B0, 0x0000, 0xC2AF, 0x0000,
    0xF64D, 0x0000, 0x4114, 0x0000, 0x56F3, 0x0000, 0x3762, 0x0000,
    0xFF0F, 0x0000, 0xC4ED, 0x0000, 0xA504, 0x0000, 0xBC18, 0x0000,
    0x043F, 0x0000, 0x4395, 0x0000, 0x5FF7, 0x0000, 0x48C5, 0x0000,
    0xF532, 0x0000, 0xB715, 0x0000, 0xA6D7, 0x0000, 0xC32E, 0x0000,
    0xFF01, 0x0000, 0x43FD, 0x0000, 0x630D, 0x0000, 0x3B2A, 0x0000,
    0x04B7, 0x0000, 0xBA0C, 0x0000, 0xAEA5, 0x0000, 0xCA32, 0x0000,
    0x0A2B, 0x0000, 0x2E0A, 0x0000, 0x5AFD, 0x0000, 0x3DEC, 0x0000,
    0x0B47, 0x0000, 0xBBB9, 0x0000, 0x9FF8, 0x0000, 0xC233, 0x0000,
    0xEFE7, 0x0000, 0x391F, 0x0000, 0x5B75, 0x0000, 0x4450, 0x0000,
    0xF94B, 0x0000, 0xBEB0, 0x0000, 0xAAD0, 0x0000, 0xC013, 0x0000,
    0x08AD, 0x0000, 0x3389, 0x0000, 0x5ABC, 0x0000, 0x45A3, 0x0000,
    0xFFE2, 0x0000, 0xC819, 0x0000, 0xA73F, 0x0000, 0xB88E, 0x0000,
    0x025C, 0x0000, 0x3D5B, 0x0000, 0x5301, 0x0000, 0x4532, 0x0000,
    0x0043, 0x0000, 0xBE97, 0x0000, 0xADF8, 0x0000, 0xC3A9, 0x0000,
    0x014A, 0x0000, 0x31DD, 0x0000, 0x600B, 0x0000, 0x3DD7, 0x0000,
    0xFFDF, 0x0000, 0xBF90, 0x0000, 0xAC97, 0x0000, 0xC4B6, 0x0000,
    0x0159, 0x0000, 0x3952, 0x0000, 0x5C7D, 0x0000, 0x4BE6, 0x0000,
    0xFE32, 0x0000, 0xC174, 0x0000, 0xA899, 0x0000, 0xC594, 0x0000,
    0x0358, 0x0000, 0x4670, 0x0000, 0x6302, 0x0000, 0x3811, 0x0000,
    0xF97C, 0x0000, 0xC067, 0x0000, 0x9C7F, 0x0000, 0xBCB5, 0x0000,
    0x070C, 0x0000, 0x41B2, 0x0000, 0x53AB, 0x0000, 0x3DF9, 0x0000,
    0xFED2, 0x0000, 0xC96D, 0x0000, 0x9FD2, 0x0000, 0xC273, 0x0000,
    0xFE73, 0x0000, 0x3D4B, 0x0000, 0x4C7A, 0x0000, 0x40B4, 0x0000,
    0x00F9, 0x0000, 0xC59F, 0x0000, 0xAF2E, 0x0000, 0xCF68, 0x0000,
    0x017C, 0x0000, 0x42D4, 0x0000, 0x500E, 0x0000, 0x39D7, 0x0000,
    0x046E, 0x0000, 0xBCAB, 0x0000, 0xAC22, 0x0000, 0xC86F, 0x0000,
    0x049B, 0x0000, 0x42EF, 0x0000, 0x5D1E, 0x0000, 0x3739, 0x0000,
    0xFFDE, 0x0000, 0xBD3E, 0x0000, 0xA833, 0x0000, 0xC2BB, 0x0000,
    0x0625, 0x0000, 0x440E, 0x0000, 0x508C, 0x0000, 0x3B02, 0x0000,
    0xFB17, 0x0000, 0xC12C, 0x0000, 0xAACA, 0x0000, 0xBBAA, 0x0000,
    0x0155, 0x0000, 0x3C1E, 0x0000, 0x5944, 0x0000, 0x3131, 0x0000,
    0x07A1, 0x0000, 0xC7BD, 0x0000, 0xA7AE, 0x0000, 0xBDE5, 0x0000,
    0xFC7C, 0x0000, 0x37B4, 0x0000, 0x577A, 0x0000, 0x3D36, 0x0000,
    0xFE4C, 0x0000, 0xB867, 0x0000, 0xA7A0, 0x0000, 0xBFE5, 0x0000,
    0xFA69, 0x0000, 0x37EE, 0x0000, 0x5AF5, 0x0000, 0x3D9A, 0x0000,
    0x093E, 0x0000, 0xC662, 0x0000, 0xA44A, 0x0000, 0xC43D, 0x0000,
    0x02C7, 0x0000, 0x4BB9, 0x0000, 0x5590, 0x0000, 0x45D4, 0x0000,
    0x0062, 0x0000, 0xC4A3, 0x0000, 0xA21F, 0x0000, 0xBD83, 0x0000,
    0x01DE, 0x0000, 0x3EC2, 0x0000, 0x5CCD, 0x0000, 0x464E, 0x0000,
    0x10E8, 0x0000, 0xC03A, 0x0000, 0xAAB6, 0x0000, 0xC563, 0x0000,
    0x02B0, 0x0000, 0x4268, 0x0000, 0x6912, 0x0000, 0x3EF7, 0x0000,
    0x00BD, 0x0000, 0xBEF9, 0x0000, 0xACEC, 0x0000, 0xBF1F, 0x0000,
    0x0517, 0x0000, 0x4010, 0x0000, 0x512E, 0x0000, 0x3B99, 0x0000,
    0xF919, 0x0000, 0xC0D4, 0x0000, 0xB251, 0x0000, 0xC163, 0x0000,
    0x0A5C, 0x0000, 0x40E7, 0x0000, 0x5795, 0x0000, 0x37E1, 0x0000,
    0xFF79, 0x0000, 0xC744, 0x0000, 0xAD5D, 0x0000, 0xC0DF, 0x0000,
    0xFB63, 0x0000, 0x4604, 0x0000, 0x5933, 0x0000, 0x410D, 0x0000,
    0x0111, 0x0000, 0xC523, 0x0000, 0xAD93, 0x0000, 0xC369, 0x0000,
    0xF880, 0x0000, 0x3CFC, 0x0000, 0x55C4, 0x0000, 0x5211, 0x0000,
    0xFF66, 0x0000, 0xBCB2, 0x0000, 0xA46E, 0x0000, 0xBD3B, 0x0000,
    0x02F1, 0x0000, 0x3AF6, 0x0000, 0x5D2D, 0x0000, 0x404D, 0x0000,
    0xF93D, 0x0000, 0xC7FB, 0x0000, 0xA50F, 0x0000, 0xC172, 0x0000,
    0xF799, 0x0000, 0x3BD9, 0x0000, 0x5BF6, 0x0000, 0x3CE0, 0x0000,
    0xFAC8, 0x0000, 0xC757, 0x0000, 0xA282, 0x0000, 0xB497, 0x0000,
    0xFD38, 0x0000, 0x4391, 0x0000, 0x503A, 0x0000, 0x3EDC, 0x0000,
    0x0794, 0x0000, 0xC497, 0x0000, 0xADD2, 0x0000, 0xBCE2, 0x0000,
    0x0DE3, 0x0000, 0x4143, 0x0000, 0x5AD5, 0x0000, 0x419D, 0x0000,
    0x0213, 0x0000, 0xBF8A, 0x0000, 0xA3AB, 0x0000, 0xC403, 0x0000,
    0xF5A5, 0x0000, 0x40FC, 0x0000, 0x504E, 0x0000, 0x3D66, 0x0000,
    0xFFC5, 0x0000, 0xC25D, 0x0000, 0xA7DA, 0x0000, 0xBA4C, 0x0000,
    0xFB92, 0x0000, 0x4431, 0x0000, 0x567B, 0x0000, 0x3979, 0x0000,
    0xF88F, 0x0000, 0xC783, 0x0000, 0xA38A, 0x0000, 0xC115, 0x0000,
    0xF988, 0x0000, 0x3D9D, 0x0000, 0x5A82, 0x0000, 0x3BFE, 0x0000,
    0x0765, 0x0000, 0xBDD5, 0x0000, 0xAAA9, 0x0000, 0xB9C3, 0x0000,
    0xFA57, 0x0000, 0x3F54, 0x0000, 0x54BE, 0x0000, 0x46DB, 0x0000,
    0x0706, 0x0000, 0xBFAD, 0x0000, 0xAA2B, 0x0000, 0xB3E0, 0x0000,
    0x01EE, 0x0000, 0x4194, 0x0000, 0x4D17, 0x0000, 0x3E6E, 0x0000,
    0x05CF, 0x0000, 0xBDF4, 0x0000, 0x9E4C, 0x0000, 0xB638, 0x0000,
    0xF445, 0x0000, 0x467A, 0x0000, 0x622C, 0x0000, 0x4593, 0x0000,
    0x0203, 0x0000, 0xC1D9, 0x0000, 0xAB60, 0x0000, 0xB785, 0x0000,
    0xFC3C, 0x0000, 0x3E6D, 0x0000, 0x5A4C, 0x0000, 0x3EAE, 0x0000,
    0xFAFB, 0x0000, 0xBE25, 0x0000, 0xA53D, 0x0000, 0xC2A7, 0x0000,
    0x017A, 0x0000, 0x45D5, 0x0000, 0x5508, 0x0000, 0x4305, 0x0000,
    0xFF87, 0x0000, 0xBABA, 0x0000, 0xA787, 0x0000, 0xC142, 0x0000,
    0x050D, 0x0000, 0x4270, 0x0000, 0x5E26, 0x0000, 0x3FFA, 0x0000,
    0xFE09, 0x0000, 0xC1A2, 0x0000, 0xA1F5, 0x0000, 0xC4C6, 0x0000,
    0xFA65, 0x0000, 0x42F6, 0x0000, 0x4EAF, 0x0000, 0x4766, 0x0000,
    0xFB35, 0x0000, 0xC320, 0x0000, 0xB388, 0x0000, 0xBE9A, 0x0000,
    0xF965, 0x0000, 0x3D90, 0x0000, 0x5C06, 0x0000, 0x4368, 0x0000,
    0x0BCF, 0x0000, 0xCF71, 0x0000, 0xAB6D, 0x0000, 0xC37A, 0x0000,
    0x0045, 0x0000, 0x45C8, 0x0000, 0x56F4, 0x0000, 0x3BEC, 0x0000,
    0xFDBE, 0x0000, 0xC5B9, 0x0000, 0xABDF, 0x0000, 0xB91B, 0x0000,
    0xFAC8, 0x0000, 0x4064, 0x0000, 0x589E, 0x0000, 0x4029, 0x0000,
    0x0ABB, 0x0000, 0xC0EB, 0x0000, 0xA917, 0x0000, 0xBCE1, 0x0000,
    0x0023, 0x0000, 0x4CEC, 0x0000, 0x55BF, 0x0000, 0x3D12, 0x0000,
    0x0861, 0x0000, 0xBDDE, 0x0000, 0xA4FC, 0x0000, 0xBC5F, 0x0000,
    0xFE05, 0x0000, 0x41A7, 0x0000, 0x5125, 0x0000, 0x385B, 0x0000,
    0xF5E9, 0x0000, 0xC37F, 0x0000, 0xA6C6, 0x0000, 0xCAF0, 0x0000,
    0x0D4F, 0x0000, 0x3FFA, 0x0000, 0x6059, 0x0000, 0x37F1, 0x0000,
    0xFF38, 0x0000, 0xC450, 0x0000, 0xA8AA, 0x0000, 0xC584, 0x0000,
    0x0096, 0x0000, 0x3B28, 0x0000, 0x51AC, 0x0000, 0x41A0, 0x0000,
    0x02DC, 0x0000, 0xB65C, 0x0000, 0xAD73, 0x0000, 0xC777, 0x0000,
    0xF870, 0x0000, 0x3DA3, 0x0000, 0x5667, 0x0000, 0x3D91, 0x0000,
    0x0B55, 0x0000, 0xB664, 0x0000, 0xABFB, 0x0000, 0xC3A8, 0x0000,
    0xF158, 0x0000, 0x3ACD, 0x0000, 0x5208, 0x0000, 0x3D2D, 0x0000,
    0x0381, 0x0000, 0xB635, 0x0000, 0xA5B9, 0x0000, 0xB4F9, 0x0000,
    0xF624, 0x0000, 0x4743, 0x0000, 0x5A6B, 0x0000, 0x4343, 0x0000,
    0x08E5, 0x0000, 0xC74D, 0x0000, 0xA40C, 0x0000, 0xC5FB, 0x0000,
    0xFA40, 0x0000, 0x3583, 0x0000, 0x5BD0, 0x0000, 0x43D7, 0x0000,
    0x02EC, 0x0000, 0xBE82, 0x0000, 0xA51E, 0x0000, 0xB3BC, 0x0000,
    0x02BF, 0x0000, 0x4145, 0x0000, 0x5AAD, 0x0000, 0x2E96, 0x0000,
    0xF7E8, 0x0000, 0xC832, 0x0000, 0xA365, 0x0000, 0xBCD3, 0x0000,
    0xF07E, 0x0000, 0x425E, 0x0000, 0x60B4, 0x0000, 0x3DEB, 0x0000,
    0xF300, 0x0000, 0xC9C3, 0x0000, 0xB8E4, 0x0000, 0xBE29, 0x0000,
    0x0680, 0x0000, 0x4060, 0x0000, 0x5D5B, 0x0000, 0x3E6C, 0x0000,
    0xF8D9, 0x0000, 0xC464, 0x0000, 0xA22D, 0x0000, 0xC03B, 0x0000,
    0xFC26, 0x0000, 0x40C6, 0x0000, 0x5EFF, 0x0000, 0x4691, 0x0000,
    0x0472, 0x0000, 0xBC84, 0x0000, 0x99C2, 0x0000, 0xC22F, 0x0000,
    0xFDE6, 0x0000, 0x4146, 0x0000, 0x555A, 0x0000, 0x3E51, 0x0000,
    0xF905, 0x0000, 0xB5AD, 0x0000, 0xB21E, 0x0000, 0xBC05, 0x0000,
    0x0B14, 0x0000, 0x3CAA, 0x0000, 0x4FAA, 0x0000, 0x4253, 0x0000,
    0x058E, 0x0000, 0xB5DE, 0x0000, 0xAA80, 0x0000, 0xBF6A, 0x0000,
    0x03B7, 0x0000, 0x432E, 0x0000, 0x4F3A, 0x0000, 0x48C4, 0x0000,
    0x0448, 0x0000, 0xBC6F, 0x0000, 0xAD39, 0x0000, 0xC6CF, 0x0000,
    0x04FC, 0x0000, 0x3747, 0x0000, 0x4DAE, 0x0000, 0x489C, 0x0000,
    0xFD5B, 0x0000, 0xC66A, 0x0000, 0x9E80, 0x0000, 0xC066, 0x0000,
    0x0217, 0x0000, 0x3E0C, 0x0000, 0x4AFB, 0x0000, 0x45BA, 0x0000,
    0xFF1C, 0x0000, 0xBEB9, 0x0000, 0xA37B, 0x0000, 0xBE29, 0x0000,
    0xFCA8, 0x0000, 0x3963, 0x0000, 0x5433, 0x0000, 0x4176, 0x0000,
    0xFB9D, 0x0000, 0xCA86, 0x0000, 0xA43F, 0x0000, 0xC093, 0x0000,
    0x0167, 0x0000, 0x3DFC, 0x0000, 0x520E, 0x0000, 0x4939, 0x0000,
    0x0611, 0x0000, 0xB821, 0x0000, 0xA3DA, 0x0000, 0xC579, 0x0000,
    0x0419, 0x0000, 0x42B7, 0x0000, 0x5584, 0x0000, 0x421A, 0x0000,
    0x03AA, 0x0000, 0xBD7C, 0x0000, 0xA295, 0x0000, 0xC48C, 0x0000,
    0x06FD, 0x0000, 0x49C5, 0x0000, 0x5956, 0x0000, 0x4AF6, 0x0000,
    0x0F5C, 0x0000, 0xB9D1, 0x0000, 0x9FAE, 0x0000, 0xBE8E, 0x0000,
    0x0260, 0x0000, 0x4AF3, 0x0000, 0x5BC6, 0x0000, 0x39E4, 0x0000,
    0xFABE, 0x0000, 0xBB5E, 0x0000, 0xADA8, 0x0000, 0xBE49, 0x0000,
    0x05BE, 0x0000, 0x4241, 0x0000, 0x54C7, 0x0000, 0x4D7E, 0x0000,
    0xFB18, 0x0000, 0xBE42, 0x0000, 0xA4C9, 0x0000, 0xC435, 0x0000,
    0xFE45, 0x0000, 0x4DCD, 0x0000, 0x5D4C, 0x0000, 0x3C06, 0x0000,
    0x04E9, 0x0000, 0xC4F7, 0x0000, 0x97C1, 0x0000, 0xC6FD, 0x0000,
    0x0B06, 0x0000, 0x43DF, 0x0000, 0x5994, 0x0000, 0x3CAF, 0x0000,
    0xF75D, 0x0000, 0xC1E6, 0x0000, 0xA17C, 0x0000, 0xC19B, 0x0000,
    0x0DE9, 0x0000, 0x38BC, 0x0000, 0x5F34, 0x0000, 0x37ED, 0x0000,
    0x0210, 0x0000, 0xCBA9, 0x0000, 0xA5A3, 0x0000, 0xC3E3, 0x0000,
    0x087A, 0x0000, 0x46F5, 0x0000, 0x58C1, 0x0000, 0x3A5D, 0x0000,
    0xFD3A, 0x0000, 0xC357, 0x0000, 0xA70F, 0x0000, 0xC464, 0x0000,
    0x0149, 0x0000, 0x3AA8, 0x0000, 0x5D14, 0x0000, 0x3D91, 0x0000,
    0x00B0, 0x0000, 0xC382, 0x0000, 0xA6B0, 0x0000, 0xC8E0, 0x0000,
    0x0232, 0x0000, 0x430F, 0x0000, 0x57AE, 0x0000, 0x4233, 0x0000,
    0x044A, 0x0000, 0xBD75, 0x0000, 0xB061, 0x0000, 0xBA33, 0x0000,
    0xFC92, 0x0000, 0x40C7, 0x0000, 0x5C4A, 0x0000, 0x3BEF, 0x0000,
    0xFCBF, 0x0000, 0xB991, 0x0000, 0xA596, 0x0000, 0xC131, 0x0000,
    0x0972, 0x0000, 0x485C, 0x0000, 0x5884, 0x0000, 0x3A48, 0x0000,
    0x0184, 0x0000, 0xB9D0, 0x0000, 0xAE64, 0x0000, 0xC382, 0x0000,
    0xF316, 0x0000, 0x3B32, 0x0000, 0x5ABB, 0x0000, 0x40EC, 0x0000,
    0xFB49, 0x0000, 0xCBB9, 0x0000, 0xA557, 0x0000, 0xC867, 0x0000,
    0x01E0, 0x0000, 0x4136, 0x0000, 0x58BE, 0x0000, 0x3B27, 0x0000,
    0xFF34, 0x0000, 0xC349, 0x0000, 0xA72C, 0x0000, 0xBC11, 0x0000,
    0xF548, 0x0000, 0x3AEB, 0x0000, 0x64F8, 0x0000, 0x3B31, 0x0000,
    0x06EE, 0x0000, 0xBAF0, 0x0000, 0xAC57, 0x0000, 0xC4A0, 0x0000,
    0xFCF3, 0x0000, 0x3507, 0x0000, 0x63D5, 0x0000, 0x4572, 0x0000,
    0xFB96, 0x0000, 0xC02D, 0x0000, 0xAD13, 0x0000, 0xBF92, 0x0000,
    0xF661, 0x0000, 0x369C, 0x0000, 0x59D5, 0x0000, 0x379A, 0x0000,
    0x0B5E, 0x0000, 0xBE24, 0x0000, 0xAA37, 0x0000, 0xB825, 0x0000,
    0x08F1, 0x0000, 0x3ED8, 0x0000, 0x552D, 0x0000, 0x3C10, 0x0000,
    0xFFDD, 0x0000, 0xC5AA, 0x0000, 0xAAEB, 0x0000, 0xBF72, 0x0000,
    0xF0E0, 0x0000, 0x42B5, 0x0000, 0x5798, 0x0000, 0x37A3, 0x0000,
    0x0756, 0x0000, 0xCA7C, 0x0000, 0xAF96, 0x0000, 0xBEE0, 0x0000,
    0xF9AB, 0x0000, 0x3EC3, 0x0000, 0x5AC6, 0x0000, 0x4116, 0x0000,
    0x0360, 0x0000, 0xC007, 0x0000, 0xA94E, 0x0000, 0xB7CC, 0x0000,
    0xFC0D, 0x0000, 0x3C02, 0x0000, 0x5C46, 0x0000, 0x3FFD, 0x0000,
    0xEE8F, 0x0000, 0xBC6F, 0x0000, 0xB22B, 0x0000, 0xB0D7, 0x0000,
    0x0D90, 0x0000, 0x362C, 0x0000, 0x5740, 0x0000, 0x41AC, 0x0000,
    0xF9BD, 0x0000, 0xC6FB, 0x0000, 0xA966, 0x0000, 0xC18A, 0x0000,
    0x1030, 0x0000, 0x411B, 0x0000, 0x59CF, 0x0000, 0x3DF2, 0x0000,
    0xFC2A, 0x0000, 0xC143, 0x0000, 0xA666, 0x0000, 0xC41B, 0x0000,
    0x052E, 0x0000, 0x4105, 0x0000, 0x5F3E, 0x0000, 0x3DB0, 0x0000,
    0x060D, 0x0000, 0xB85A, 0x0000, 0xA9A8, 0x0000, 0xBEC6, 0x0000,
    0x01D5, 0x0000, 0x3C23, 0x0000, 0x4FBB, 0x0000, 0x40AE, 0x0000,
    0x0033, 0x0000, 0xC1E7, 0x0000, 0xA368, 0x0000, 0xCF8C, 0x0000,
    0xFC11, 0x0000, 0x382C, 0x0000, 0x53C4, 0x0000, 0x3787, 0x0000,
    0x0992, 0x0000, 0xBF2D, 0x0000, 0xA4AD, 0x0000, 0xBB6F, 0x0000,
    0x02D2, 0x0000, 0x3FB1, 0x0000, 0x5E36, 0x0000, 0x4B5F, 0x0000,
    0x016A, 0x0000, 0xB9A7, 0x0000, 0xA12A, 0x0000, 0xC2E6, 0x0000,
    0xF7C1, 0x0000, 0x3ECA, 0x0000, 0x5747, 0x0000, 0x3882, 0x0000,
    0x0083, 0x0000, 0xBBD7, 0x0000, 0x9FF1, 0x0000, 0xC4D8, 0x0000,
    0xFE62, 0x0000, 0x37E1, 0x0000, 0x5AEC, 0x0000, 0x437A, 0x0000,
    0x01E8, 0x0000, 0xC36A, 0x0000, 0xADE3, 0x0000, 0xCAC7, 0x0000,
    0xFE32, 0x0000, 0x3909, 0x0000, 0x6235, 0x0000, 0x3D00, 0x0000,
    0x0321, 0x0000, 0xBB13, 0x0000, 0x9FC0, 0x0000, 0xC291, 0x0000
    };

static const q15_t in_cifft_noisy_2048[4096] = {
    0x0001, 0x0000, 0x0004, 0x0001, 0xFFF0, 0x000B, 0xFFF4, 0xFFF4,
    0xFFFA, 0x0028, 0xFFCC, 0x000C, 0x000D, 0x0005, 0xFFDC, 0xFFF4,
    0x000B, 0x0010, 0x001B, 0x0008, 0x002C, 0xFFC2, 0x0014, 0x0033,
    0xFFF2, 0x0001, 0xFFF6, 0x0012, 0x0001, 0xFFEA, 0x0005, 0xFFE4,
    0xFFFF, 0x0038, 0xFFE7, 0xFFE9, 0xFFFD, 0xFFD4, 0x000C, 0x0015,
    0xFFE0, 0xFFDA, 0x0025, 0x0027, 0xFFD8, 0xFFF7, 0x0016, 0x0014,
    0xFFD4, 0xFFEA, 0x000A, 0xFFFB, 0x001D, 0x0012, 0xFFFB, 0xFFFF,
    0x0002, 0xFFE4, 0x000F, 0x001E, 0x0001, 0x000D, 0x000E, 0xFFF3,
    0x000C, 0xFFEB, 0x0018, 0xFFDB, 0xFFDB, 0xFFEA, 0xFFF9, 0x000C,
    0x0007, 0x000D, 0x0002, 0x0028, 0x001B, 0x0005, 0x0000, 0x0007,
    0x0026, 0xFFF5, 0xFFDE, 0x000E, 0x0005, 0xFFE9, 0x0013, 0xFFF4,
    0xFFF6, 0x000E, 0xFFFF, 0xFFE5, 0x0010, 0x0038, 0xFFF2, 0x0006,
    0xFFE1, 0x000C, 0x000F, 0x0001, 0x0004, 0x001A, 0xFFF8, 0x0001,
    0x000C, 0xFFFC, 0x0001, 0xFFF5, 0xFFFF, 0x0018, 0xFFE3, 0xFFEF,
    0xFFE3, 0x0018, 0x0016, 0x0013, 0xFFED, 0xFFF1, 0x001E, 0xFFEF,
    0x0011, 0xFFED, 0x002C, 0xFFF9, 0xFFF2, 0x001A, 0xFFEA, 0xFFF9,
    0xFFF5, 0xFFE3, 0x000F, 0xFFFC, 0x0010, 0x0017, 0x001D, 0xFFF1,
    0xFFF2, 0x001A, 0x001C, 0x0000, 0x0001, 0x002D, 0x0002, 0xFFE3,
    0x0024, 0x0000, 0xFFF9, 0x000B, 0x0007, 0x001D, 0x0010, 0x001F,
    0xFFF2, 0xFFFF, 0xFFF1, 0xFFDB, 0x0009, 0x000E, 0xFFF2, 0x0011,
    0x0011, 0xFFFA, 0xFFFD, 0x0001, 0xFFEE, 0xFFEC, 0xFFB9, 0xFFE1,
    0xFFF8, 0x0014, 0xFFEC, 0xFFFC, 0xFFFE, 0x0016, 0xFFFF, 0x0002,
    0xFFF4, 0x0019, 0x0029, 0xFFF7, 0x0034, 0xFFD5, 0xFFD6, 0x000C,
    0xFFFF, 0xFFF6, 0xFFE4, 0x0005, 0xFFFC, 0xFFEA, 0xFFF9, 0x0005,
    0xFFCA, 0xFFCF, 0x0007, 0x000D, 0x000C, 0xFFEA, 0x0002, 0x001A,
    0x0005, 0xFFFE, 0xFFE2, 0xFFFD, 0xFFD5, 0xFFF6, 0xFFE0, 0x0010,
    0xFFFB, 0xFFE7, 0x000C, 0x0014, 0xFFEA, 0x0011, 0xFFC3, 0xFFD6,
    0xFFF0, 0xFFED, 0xFFF8, 0x0010, 0x001E, 0x001B, 0xFFD9, 0xFFFC,
    0xFFD6, 0x000F, 0x0003, 0xFFED, 0x000E, 0xFFE5, 0xFFF3, 0xFFD8,
    0xFFEC, 0x0015, 0xFFFD, 0xFFF4, 0xFFF5, 0xFFC9, 0x0004, 0xFFF2,
    0xFFDC, 0xFFEF, 0xFFDB, 0x001F, 0x0034, 0x0002, 0xFFE0, 0x0012,
    0xFFD7, 0x0004, 0xFFF2, 0x001D, 0x0016, 0x003D, 0x0011, 0x0006,
    0xFFCB, 0xFFFE, 0xFFED, 0xFFEB, 0x000D, 0xFFDE, 0xFFD7, 0x0004,
    0x0019, 0x0017, 0x000E, 0xFFF0, 0x001B, 0x0000, 0xFFFC, 0xFFF5,
    0x0014, 0xFFFF, 0x0027, 0xFFFF, 0xFFE5, 0x0010, 0x0008, 0xFFE2,
    0xFFDE, 0xFFF7, 0xFFE7, 0x0017, 0x0012, 0xFFFD, 0xFFFC, 0x0005,
    0x0001, 0x0008, 0xFFF4, 0x0011, 0x000E, 0x000B, 0xFFF0, 0x0000,
    0x0002, 0xFFEB, 0x0029, 0xFFEC, 0xFFFC, 0xFFFA, 0x0006, 0x000D,
    0xFFF6, 0x0028, 0x0002, 0xFFFA, 0x0017, 0x0011, 0xFFF7, 0xFFF7,
    0x0004, 0x0019, 0x0006, 0x0014, 0x0026, 0xFFF8, 0x0000, 0x0018,
    0x0003, 0xFFED, 0xFFE3, 0x0001, 0x0041, 0xFFE2, 0x0004, 0x0009,
    0x0009, 0xFFFB, 0xFFE5, 0x0022, 0xFFD7, 0x000D, 0x0014, 0x000D,
    0xFFF4, 0xFFE0, 0xFFDE, 0x0008, 0xFFFB, 0x001F, 0x0014, 0xFFF8,
    0x0000, 0x0009, 0xFFD3, 0xFFE6, 0xFFFE, 0xFFEF, 0x000F, 0xFFE3,
    0xFFE2, 0x0003, 0x001E, 0xFFE2, 0xFFE4, 0x0007, 0xFFF6, 0xFFE4,
    0x000A, 0x0043, 0x0028, 0xFFE9, 0xFFEE, 0x0004, 0xFFEE, 0x0010,
    0x000C, 0xFFE3, 0x002F, 0xFFF5, 0xFFF2, 0xFFDE, 0xFFE7, 0x0009,
    0x0019, 0x0011, 0x0012, 0xFFDE, 0x0021, 0xFFCC, 0xFFFF, 0xFFFE,
    0xFFC1, 0x0011, 0x001C, 0x0000, 0x000F, 0x0004, 0xFFEE, 0xFFF2,
    0x000F, 0xFFFE, 0x0006, 0x003E, 0x0016, 0xFFF7, 0xFFF7, 0xFFFE,
    0xFFFC, 0x000B, 0x0002, 0x0014, 0xFFD6, 0x0025, 0x001E, 0xFFF0,
    0x0031, 0x001B, 0xFFF6, 0x0014, 0x001B, 0xFFDD, 0xFFDA, 0x001E,
    0xFFF7, 0x0018, 0x000C, 0x000D, 0x001D, 0x0003, 0x000E, 0x0009,
    0x0001, 0x0009, 0x0011, 0xFFEC, 0xFFF8, 0x0014, 0x001A, 0x0003,
    0x0006, 0xFFED, 0x0000, 0x000F, 0x0007, 0xFFF7, 0x001F, 0x0008,
    0xFFE2, 0x000A, 0x001F, 0x000D, 0x0027, 0xFFBD, 0x0011, 0x0019,
    0x000D, 0x001D, 0x001C, 0xFFDD, 0xFFF4, 0x000B, 0x0021, 0xFFDB,
    0x0001, 0xFFE7, 0x002E, 0xFFF1, 0x0000, 0x0003, 0x000D, 0x0007,
    0xFFE4, 0x0009, 0xFFFB, 0xFFE8, 0x0003, 0x0022, 0xFFFD, 0xFFFF,
    0xFFF8, 0xFFE7, 0xFFF8, 0x0018, 0xFFEA, 0xFFC7, 0xFFF6, 0xFFE9,
    0xFFEF, 0xFFFF, 0xFFD9, 0xFFF9, 0xFFFA, 0xFFDB, 0xFFD4, 0xFFE9,
    0xFFFA, 0xFFFA, 0x0006, 0xFFD9, 0xFFE8, 0x0000, 0xFFE1, 0xFFFE,
    0xFFF7, 0x0031, 0x002B, 0x0013, 0x000B, 0x0036, 0xFFFF, 0x000E,
    0xFFF9, 0xFFEA, 0x0007, 0x0022, 0x0024, 0xFFEE, 0x001E, 0xFFF5,
    0xFFE0, 0xD33C, 0xFFD9, 0x0004, 0x0013, 0xFFF7, 0x000E, 0x002D,
    0xFFD8, 0xFFF8, 0xFFCF, 0xFFF8, 0xFFEA, 0x0014, 0xFFEB, 0xFFFD,
    0x0000, 0x001E, 0x0016, 0xFFC5, 0x002D, 0x0012, 0x001C, 0x0007,
    0x000C, 0x0003, 0x001B, 0x0005, 0xFFF8, 0xFFF8, 0xFFF3, 0xFFED,
    0xFFD0, 0x002F, 0xFFD8, 0x0017, 0xFFCB, 0xFFDF, 0x000A, 0x0000,
    0x000E, 0x000A, 0x000D, 0x0004, 0x0018, 0x0012, 0x0010, 0x0028,
    0xFFF7, 0xFFF4, 0xFFD7, 0xFFFF, 0x0008, 0xFFE6, 0x0026, 0x0020,
    0x001D, 0xFFBA, 0x004F, 0x000F, 0xFFEE, 0x001B, 0x0001, 0xFFF2,
    0x0038, 0xFFC6, 0x0026, 0x0014, 0xFFE7, 0xFFFF, 0xFFFB, 0x0019,
    0xFFE6, 0xFFD7, 0x0043, 0xFFEC, 0x0002, 0x000F, 0x0003, 0x0027,
    0x000D, 0xFFD2, 0xFFCC, 0x0028, 0x0010, 0xFFF8, 0x002B, 0x000B,
    0x0019, 0x001D, 0xFFF3, 0x0005, 0xFFC4, 0x0015, 0xFFF6, 0xFFFE,
    0x0006, 0xFFFE, 0xFFE5, 0xFFF1, 0xFFFF, 0xFFDF, 0xFFE7, 0xFFED,
    0xFFED, 0x0013, 0xFFF6, 0xFFF6, 0xFFEA, 0xFFF3, 0x002D, 0x0016,
    0xFFF7, 0xFFFF, 0x000F, 0x0001, 0xFFF1, 0x0024, 0x0000, 0x0003,
    0x000D, 0x0020, 0xFFEA, 0xFFFA, 0x0005, 0x0002, 0x001C, 0xFFEE,
    0x0022, 0x001F, 0xFFFC, 0xFFE5, 0x002C, 0xFFEA, 0xFFE5, 0xFFEC,
    0xFFCD, 0x0004, 0x0013, 0xFFF1, 0x002B, 0xFFF2, 0xFFE8, 0xFFF7,
    0x0016, 0xFFFC, 0xFFFD, 0xFFE3, 0x0011, 0xFFF6, 0x0001, 0xFFC1,
    0xFFF2, 0xFFCD, 0xFFE6, 0xFFF5, 0x000A, 0xFFEF, 0xFFEB, 0x0003,
    0x0000, 0xFFE2, 0x002E, 0xFFEA, 0x0008, 0xFFF2, 0x0009, 0xFFDC,
    0x001C, 0x0034, 0x0026, 0xFFFC, 0x002D, 0xFFE6, 0xFFEB, 0x000C,
    0x0001, 0xFFDF, 0xFFEC, 0xFFEE, 0x001C, 0xFFF1, 0xFFF4, 0xFFB3,
    0xFFEF, 0x0000, 0xFFE2, 0x0014, 0x0007, 0x0001, 0x000C, 0x0008,
    0xFFF3, 0xFFF0, 0x0020, 0xFFF2, 0xFFC4, 0x0000, 0xFFEF, 0x000C,
    0xFFDB, 0x000D, 0x0037, 0xFFE3, 0x0003, 0xFFF3, 0xFFEF, 0xFFEB,
    0x0004, 0xFFFC, 0xFFE1, 0x001D, 0x0022, 0x0007, 0xFFEB, 0x0019,
    0xFFE3, 0x0022, 0x0018, 0xFFDE, 0x0001, 0x0000, 0xFFFF, 0x000B,
    0xFFE8, 0xFFEC, 0xFFE7, 0x001E, 0xFFE6, 0x0037, 0xFFD3, 0x000F,
    0x0002, 0x000E, 0xFFF8, 0xFFFE, 0xFFEB, 0xFFCE, 0x0012, 0x0025,
    0x0016, 0xFFF5, 0x001F, 0x0018, 0xFFE8, 0x000F, 0x0009, 0x001B,
    0x0017, 0xFFE6, 0x0010, 0xFFF6, 0xFFE6, 0xFFE7, 0x0005, 0x0017,
    0xFFE3, 0x0004, 0xFFF6, 0x000B, 0xFFFD, 0xFFC9, 0xFFFB, 0xFFEF,
    0x0007, 0xFFF0, 0xFFCC, 0x0021, 0x0023, 0x0035, 0x0011, 0xFFE9,
    0x003F, 0xFFFA, 0x0017, 0xFFEB, 0xFFFF, 0x0015, 0x0018, 0x0005,
    0x000C, 0x0024, 0x0019, 0xFFF2, 0xFFE9, 0x0005, 0x0003, 0xFFF7,
    0xFFEE, 0xFFBB, 0xFFE8, 0x000A, 0xFFF8, 0x001F, 0x0017, 0xFFFE,
    0x0026, 0xFFFD, 0x0004, 0x0014, 0x000A, 0x0002, 0x001F, 0x0004,
    0x0000, 0x0003, 0x0000, 0x001A, 0x001A, 0xFFD4, 0x000B, 0xFFAF,
    0x0012, 0x000C, 0x0015, 0xFFDF, 0x000A, 0xFFE4, 0xFFD2, 0xFFE9,
    0xFFE4, 0x000D, 0x000B, 0x0013, 0xFFFA, 0xFFF2, 0x0032, 0x0003,
    0xFFE2, 0x001F, 0xFFF7, 0x0003, 0xFFFD, 0x001D, 0x0027, 0xFFFE,
    0x0007, 0x0001, 0x0016, 0x0005, 0xFFEF, 0x0028, 0x0001, 0xFFD5,
    0xFFEC, 0x001C, 0xFFEA, 0xFFF6, 0xFFEB, 0xFFE6, 0xFFFA, 0x0001,
    0x0022, 0x0002, 0xFFF9, 0xFFD5, 0xFFDC, 0x000C, 0xFFF1, 0x0013,
    0xFFF6, 0xFFF5, 0x0019, 0x0009, 0xFFFB, 0x001B, 0x0015, 0x001A,
    0xFFDD, 0xFFF9, 0xFFE7, 0x0006, 0x003A, 0x0002, 0xFFF7, 0x0017,
    0xFFE4, 0x0001, 0x000A, 0x0012, 0x0014, 0x000F, 0xFFE8, 0xFFD0,
    0xFFE7, 0xFFFA, 0x0017, 0xFFE4, 0x005C, 0xFFF5, 0x0003, 0x0005,
    0x0009, 0xFFED, 0xFFF0, 0x000A, 0xFFE4, 0x0027, 0x001C, 0xFFFB,
    0x0005, 0x0017, 0x0012, 0x0012, 0x0001, 0x0008, 0x003E, 0x001F,
    0x000E, 0x001F, 0x0003, 0x000E, 0x003F, 0xFFFF, 0xFFD3, 0xFFEC,
    0x0035, 0x000A, 0x0021, 0xFFE2, 0xFFDA, 0xFFB3, 0xFFF1, 0xFFD8,
    0xFFEA, 0xFFC1, 0x0008, 0x0003, 0xFFF1, 0xFFF9, 0x000D, 0x001F,
    0xFFFB, 0xFFF8, 0x0012, 0x0013, 0xFFF9, 0x0012, 0x0022, 0xFFDD,
    0x0019, 0x0008, 0x0015, 0x000C, 0xFFF0, 0x0011, 0xFFC9, 0xFFDE,
    0xFFE1, 0x0002, 0xFFEF, 0x0005, 0xFFF5, 0x000A, 0x000B, 0x0025,
    0xFFFF, 0x0025, 0xFFDD, 0xFFFA, 0x0002, 0xFFEB, 0xFFEA, 0xFFCF,
    0x001A, 0x000F, 0x0000, 0x000E, 0x0008, 0xFFE8, 0xFFF1, 0x001C,
    0xFFF7, 0xFFEC, 0x0010, 0x000A, 0x0014, 0x0000, 0x002E, 0xFFD3,
    0xFFFA, 0x0010, 0x0000, 0x0017, 0xFFE0, 0x0002, 0xFFEA, 0xFFFA,
    0x0006, 0xFFF6, 0x0008, 0xFFF6, 0x0035, 0xFFC9, 0x002F, 0x000A,
    0xFFF1, 0xFFFE, 0xFFED, 0x002B, 0x000D, 0x0061, 0xFFD0, 0x000C,
    0x0030, 0xFFEB, 0xFFE8, 0xFFFA, 0xFFEE, 0x001F, 0x0014, 0x0011,
    0x001C, 0xFFF7, 0x0004, 0xFFF0, 0x0017, 0x001E, 0xFFEA, 0xFFF8,
    0xFFDF, 0xFFF4, 0x0022, 0xFFDE, 0xFFF0, 0x0003, 0x001F, 0xFFDD,
    0x0006, 0x0016, 0x000F, 0xFFEE, 0x000C, 0x000D, 0xFFD6, 0x001C,
    0xFFEB, 0x0021, 0xFFEC, 0x0014, 0x0014, 0x000D, 0x0003, 0x0009,
    0xFFE8, 0x0007, 0x0013, 0x0000, 0xFFD0, 0x0030, 0xFFDA, 0xFFC3,
    0xFFDB, 0xFFE1, 0xFFEF, 0xFFD1, 0xFFF1, 0x0006, 0x0001, 0x002F,
    0xFFDB, 0xFFE9, 0xFFC6, 0x001D, 0x0013, 0xFFEC, 0xFFF7, 0x0007,
    0x0022, 0xFFF6, 0xFFDC, 0x0009, 0xFFF4, 0x0009, 0xFFDD, 0x0008,
    0x0048, 0xFFF4, 0xFFFD, 0xFFE0, 0xFFFB, 0xFFFC, 0xFFF7, 0xFFEF,
    0xFFEE, 0xFFF6, 0xFFD3, 0x0011, 0xFFFB, 0x0020, 0x0016, 0x0019,
    0xFFDE, 0xFFE4, 0x0028, 0xFFF3, 0x0013, 0xFFF8, 0x0012, 0xFFF7,
    0x0001, 0xFFFE, 0xFFFA, 0xFFE7, 0xFFEC, 0x0027, 0xFFF9, 0xFFF4,
    0xFFFD, 0xFFEE, 0x0001, 0x0029, 0x000C, 0x0010, 0xFFE9, 0xFFDA,
    0x000F, 0x000B, 0xFFED, 0xFFD6, 0xFFE4, 0x0021, 0xFFF1, 0x001D,
    0x0010, 0xFFF3, 0x000B, 0xFFE6, 0xFFEF, 0x000D, 0xFFE9, 0xFFEA,
    0xFFED, 0xFFCF, 0x0033, 0x0019, 0xFFFA, 0x002B, 0xFFF3, 0xFFDB,
    0x0023, 0x001A, 0x000D, 0xFFDE, 0x0008, 0xFFE5, 0x0000, 0xFFF3,
    0x0015, 0x0005, 0xFFF4, 0xFFE9, 0xFFFA, 0xFFF6, 0xFFE2, 0xFFEA,
    0xFFFD, 0xFFDE, 0xFFDE, 0xFFF2, 0xFFD2, 0x001C, 0xFFFA, 0x0006,
    0xFFDE, 0xFFFE, 0xFFFC, 0x0001, 0xFFFA, 0xFFF1, 0xFFDD, 0xFFED,
    0x0010, 0x0018, 0xFFF8, 0xFFF6, 0x0006, 0x001D, 0xFFE0, 0x001D,
    0x002D, 0x0000, 0xFFED, 0xFFEC, 0xFFF4, 0x002B, 0xFFCA, 0xFFEC,
    0x000B, 0xFFED, 0xFFDC, 0xFFF0, 0x000D, 0x000E, 0xFFD7, 0xFFE9,
    0x0027, 0x0009, 0x0007, 0xFFE1, 0x0001, 0x000B, 0x0002, 0xFFFD,
    0x0023, 0xFFF8, 0xFFCE, 0x000B, 0xFFF7, 0x0025, 0x0001, 0x000B,
    0x0016, 0x0018, 0x0018, 0xFFEA, 0x0003, 0xFFF3, 0xFFE5, 0x0024,
    0xFFD5, 0x0025, 0x000F, 0xFFF6, 0xFFED, 0xFFF9, 0xFFF4, 0xFFFF,
    0xFFF6, 0xFFF7, 0xFFF2, 0x0007, 0xFFEC, 0x0004, 0x0014, 0x001B,
    0x0007, 0x0010, 0x0007, 0xFFCE, 0x0003, 0xFFF0, 0xFFF7, 0x0000,
    0x0011, 0x000D, 0x0016, 0x0018, 0xFFF4, 0x0009, 0x000C, 0xFFF3,
    0x0010, 0xFFF4, 0x000C, 0x0017, 0x002A, 0x000A, 0x0010, 0x0006,
    0x0009, 0x0007, 0x000E, 0x0007, 0x0007, 0x002D, 0xFFF3, 0x0007,
    0xFFEE, 0x0016, 0xFFEE, 0xFFFD, 0xFFF7, 0x0011, 0x0038, 0xFFE7,
    0xFFF0, 0xFFDF, 0x0064, 0xFFEF, 0x0002, 0x0008, 0x0007, 0x001A,
    0x000A, 0xFFF8, 0xFFF9, 0x0034, 0xFFFC, 0xFFEE, 0x001B, 0x0005,
    0x0029, 0x0022, 0xFFF8, 0xFFDF, 0xFFF8, 0x0029, 0x0016, 0xFFF0,
    0xFFE9, 0xFFF9, 0xFFF6, 0x0017, 0x0012, 0x0019, 0xFFF8, 0xFFFB,
    0xFFE6, 0xFFF3, 0x0016, 0xFFF8, 0x0012, 0xFFEE, 0x0025, 0x0006,
    0xFFF7, 0x002A, 0xFFF4, 0xFFFE, 0x001F, 0x0013, 0xFFCA, 0xFFFB,
    0x0010, 0xFFE6, 0xFFE7, 0x000A, 0x0008, 0xFFFF, 0xFFE4, 0xFFEC,
    0xFFE0, 0xFFF1, 0xFFFE, 0x002F, 0xFFE2, 0xFFE9, 0x0012, 0xFFFE,
    0xFFFE, 0xFFD8, 0xFFED, 0x003E, 0xFFFB, 0xFFF6, 0xFFCD, 0x0001,
    0x000E, 0x0009, 0xFFF5, 0xFFDB, 0x0014, 0x000E, 0xFFE6, 0xFFEB,
    0x000B, 0x0005, 0x0010, 0xFFFD, 0xFFE2, 0x000C, 0xFFCD, 0x001D,
    0x000A, 0x001D, 0xFFF9, 0xFFFD, 0x001D, 0xFFE8, 0x001D, 0xFFE9,
    0x0019, 0x002C, 0x0003, 0xFFE3, 0x0003, 0x0018, 0x0024, 0xFFFE,
    0xFFFA, 0x0009, 0x000E, 0x001C, 0x0011, 0xFFF7, 0xFFD6, 0xFFE4,
    0xFFF4, 0x0014, 0xFFEC, 0xFFE1, 0x0017, 0x0008, 0xFFF5, 0x0007,
    0x0036, 0x000F, 0x000E, 0xFFCC, 0xFFEE, 0x0002, 0x0004, 0x0007,
    0x0012, 0xFFF0, 0xFFED, 0x000E, 0xFFEB, 0x0009, 0x003C, 0xFFD4,
    0x0018, 0xFFEF, 0xFFFB, 0x0017, 0x0021, 0x0021, 0x0006, 0x0017,
    0xFFFD, 0xFFCC, 0x0021, 0x0018, 0xFFFF, 0xFFFD, 0x0007, 0xFFEA,
    0x0004, 0xFFF5, 0xFFC5, 0xFFF3, 0xFFE2, 0x003B, 0x000D, 0xFFEB,
    0x0003, 0xFFF4, 0xFFE5, 0x002C, 0xFFE8, 0xFFF6, 0xFFF4, 0xFFF1,
    0xFFD9, 0xFFFE, 0xFFFA, 0xFFF0, 0x0015, 0x0044, 0x0000, 0xFFD7,
    0x000D, 0xFFF6, 0x0025, 0xFFF1, 0x001B, 0xFFD7, 0x0027, 0xFFED,
    0xFFF9, 0x0027, 0x000E, 0x000C, 0x0002, 0x0001, 0xFFDA, 0xFFE9,
    0x0002, 0xFFE2, 0xFFDF, 0x0008, 0x0001, 0x0024, 0x0037, 0x0006,
    0x0018, 0xFFFF, 0xFFEF, 0xFFE3, 0x0001, 0x001C, 0x001B, 0x0021,
    0x000B, 0x0019, 0x000A, 0x0026, 0xFFDD, 0x0004, 0xFFD6, 0x0023,
    0xFFEC, 0xFFF2, 0x0035, 0x0007, 0x0001, 0xFFEA, 0xFFE4, 0x0014,
    0x001E, 0x0023, 0xFFD7, 0x0004, 0xFFE4, 0xFFEF, 0xFFEC, 0xFFF1,
    0x002F, 0xFFF2, 0xFFF4, 0xFFE8, 0x0003, 0x000C, 0xFFE2, 0xFFED,
    0x0003, 0xFFE4, 0xFFF2, 0x0017, 0xFFDA, 0x002F, 0xFFFC, 0x001A,
    0x0003, 0xFFBD, 0x000D, 0xFFE0, 0xFFF0, 0x0007, 0xFFF0, 0x0033,
    0xFFEF, 0x000E, 0xFFDD, 0xFFFA, 0x000A, 0x0008, 0xFFE8, 0xFFEA,
    0x0003, 0x0004, 0x001C, 0x0018, 0xFFF3, 0x000C, 0xFFE2, 0x002F,
    0x0000, 0x0006, 0xFFC7, 0x0029, 0xFFCD, 0x0002, 0x0016, 0x0038,
    0xFFFB, 0x0016, 0x0004, 0xFFF7, 0xFFFB, 0xFFD7, 0xFFD4, 0xFFE1,
    0x0005, 0x0029, 0xFFF6, 0x0000, 0xFFFB, 0xFFE4, 0xFFFB, 0xFFFB,
    0xFFE7, 0xFFF5, 0x0019, 0x001B, 0xFFE0, 0xFFFB, 0x0017, 0xFFEF,
    0x0004, 0x0013, 0x0008, 0xFFF9, 0x0039, 0xFFDB, 0x002C, 0x0004,
    0x0021, 0x0031, 0x000F, 0x0028, 0xFFFB, 0x003C, 0xFFF9, 0x000A,
    0xFFEB, 0xFFD9, 0x0007, 0xFFFB, 0x0005, 0x000D, 0x0017, 0x000C,
    0x0013, 0xFFFF, 0xFFE3, 0xFFEF, 0xFFE8, 0xFFEE, 0xFFE0, 0x0020,
    0x0007, 0xFFFD, 0xFFF5, 0xFFFE, 0xFFB5, 0x0005, 0x001E, 0x001E,
    0xFFEE, 0xFFEE, 0xFFFB, 0xFFED, 0xFFFA, 0x000A, 0xFFFE, 0x0003,
    0xFFEF, 0xFFD1, 0xFFE4, 0xFFF0, 0x001B, 0x0009, 0x001A, 0x0020,
    0xFFEE, 0x0013, 0x0024, 0x000D, 0x0030, 0xFFDD, 0x0012, 0xFFF9,
    0x0038, 0x0009, 0x000E, 0xFFEA, 0xFFDF, 0x0011, 0xFFF9, 0xFFF3,
    0x000A, 0x0013, 0xFFFF, 0xFFE5, 0x0011, 0xFFDD, 0xFFEE, 0x0029,
    0xFFE6, 0x0001, 0xFFF5, 0xFFF0, 0xFFF2, 0xFFF9, 0xFFD6, 0xFFE1,
    0xFFDC, 0x0028, 0xFFED, 0xFFFB, 0x0007, 0xFFFE, 0x000B, 0x0007,
    0xFFF2, 0xFFF9, 0x0001, 0xFFC8, 0xFFE3, 0x0003, 0xFFEA, 0xFFFF,
    0xFFF3, 0xFFED, 0x0006, 0x0023, 0xFFF2, 0x0008, 0xFFF1, 0xFFFC,
    0xFFFA, 0xFFEF, 0x0016, 0xFFF7, 0x0015, 0x0016, 0xFFF7, 0x0017,
    0x001F, 0xFFED, 0xFFFE, 0x0009, 0xFFF9, 0x001F, 0x0004, 0xFFFB,
    0x0005, 0xFFF4, 0x0020, 0x0003, 0xFFF4, 0x000D, 0xFFCE, 0x0017,
    0x0011, 0xFFFD, 0x0009, 0xFFF8, 0xFFE0, 0x001A, 0xFFEF, 0x000B,
    0xFFE0, 0x0018, 0x0017, 0x0011, 0x0008, 0x000F, 0xFFF6, 0xFFFC,
    0x0011, 0xFFEC, 0x0007, 0x000D, 0x0003, 0x0008, 0x000E, 0x0033,
    0xFFFB, 0x001C, 0x0009, 0x001A, 0xFFD4, 0xFFEF, 0xFFE8, 0x0019,
    0xFFF4, 0xFFDA, 0x0019, 0xFFED, 0x003A, 0xFFF0, 0xFFF2, 0x0007,
    0xFFF1, 0xFFF0, 0xFFFF, 0xFFDB, 0x0015, 0xFFEB, 0x0019, 0x0006,
    0xFFFC, 0x0014, 0x000B, 0xFFE4, 0xFFDF, 0xFFF6, 0x0016, 0x0002,
    0xFFFF, 0xFFE1, 0x0008, 0xFFF7, 0xFFF2, 0xFFE5, 0xFFFB, 0xFFFE,
    0x0032, 0xFFF2, 0xFFF0, 0x0022, 0x000E, 0xFFBF, 0xFFF9, 0xFFF9,
    0xFFDC, 0x000D, 0x000E, 0xFFEB, 0xFFFA, 0xFFD9, 0xFFE6, 0x0001,
    0xFFFD, 0xFFDD, 0x0026, 0xFFF4, 0x0018, 0x0004, 0xFFFF, 0x0006,
    0x0003, 0x0016, 0x0018, 0x0003, 0x0023, 0xFFDD, 0x0025, 0x000F,
    0xFFFE, 0x0009, 0x000A, 0x000F, 0x000A, 0x001C, 0xFFF6, 0x0011,
    0x0013, 0x000E, 0xFFF3, 0x0013, 0xFFF2, 0xFFE8, 0x0015, 0x000A,
    0x0021, 0xFFE2, 0xFFBC, 0x0022, 0xFFF3, 0xFFDC, 0xFFF2, 0xFFF6,
    0x0022, 0xFFEC, 0xFFD6, 0xFFDB, 0x0006, 0x0001, 0xFFE8, 0x0014,
    0xFFDD, 0xFFE9, 0xFFFE, 0x000D, 0xFFF4, 0xFFFB, 0x001F, 0x0010,
    0x0005, 0x002E, 0xFFF3, 0xFFEA, 0xFFE2, 0xFFF9, 0xFFE3, 0x0020,
    0x002C, 0xFFF3, 0xFFF0, 0xFFC8, 0x0017, 0xFFE5, 0xFFFA, 0xFFDF,
    0xFFE9, 0x0000, 0xFFEC, 0xFFF8, 0x001C, 0xFFF0, 0x0004, 0x000A,
    0x000C, 0xFFEF, 0x0002, 0xFFE9, 0x000F, 0x0022, 0x0000, 0xFFF3,
    0x0012, 0x0012, 0x0022, 0xFFF0, 0x0006, 0xFFE0, 0xFFE6, 0xFFEF,
    0x0010, 0x0024, 0xFFEC, 0x0001, 0x0007, 0xFFFE, 0x0017, 0xFFE1,
    0xFFE5, 0xFFFC, 0x000D, 0xFFEA, 0x000E, 0xFFD5, 0x0014, 0xFFEC,
    0x000A, 0xFFFE, 0xFFE6, 0xFFF6, 0xFFFC, 0x0008, 0xFFFC, 0xFFEA,
    0xFFE6, 0x000D, 0xFFE1, 0xFFD4, 0x0002, 0xFFE4, 0xFFFF, 0xFFE8,
    0xFFF3, 0xFFDE, 0x000E, 0x0010, 0xFFF0, 0xFFFC, 0xFFFB, 0xFFC7,
    0xFFDF, 0x000D, 0x000C, 0x002B, 0x000B, 0x000A, 0xFFE3, 0x0012,
    0xFFD9, 0x0009, 0xFFEB, 0x002C, 0xFFFC, 0x0006, 0xFFEB, 0xFFF3,
    0x0016, 0xFFF5, 0xFFEB, 0x0006, 0xFFF0, 0x0022, 0x000E, 0xFFE6,
    0xFFFC, 0xFFF9, 0x0002, 0x0020, 0xFFF2, 0xFFBB, 0x0014, 0xFFD6,
    0x0005, 0x0029, 0x001E, 0xFFF4, 0xFFF3, 0x0021, 0x0020, 0x0023,
    0x0005, 0xFFEE, 0xFFEF, 0x0015, 0x001A, 0xFFEE, 0xFFFC, 0xFFF9,
    0xFFEF, 0xFFFF, 0x0014, 0x0008, 0x0022, 0x000E, 0xFFF4, 0xFFE6,
    0xFFED, 0xFFF1, 0x0013, 0x000F, 0xFFFF, 0xFFEC, 0x002B, 0xFFF7,
    0xFFFA, 0x0007, 0xFFEB, 0xFFCE, 0xFFD7, 0xFFF7, 0x000F, 0x002F,
    0xFFD8, 0x0001, 0x0009, 0x0000, 0xFFED, 0xFFFB, 0x000C, 0x002E,
    0x002B, 0xFFDF, 0xFFF9, 0xFFF8, 0xFFE2, 0x0004, 0x0009, 0xFFE6,
    0xFFB8, 0xFFC8, 0xFFDF, 0xFFDE, 0x000A, 0x000A, 0xFFEE, 0xFFCC,
    0x0001, 0x0001, 0x0005, 0xFFEA, 0x0011, 0x001B, 0x0002, 0xFFEC,
    0xFFE9, 0x0000, 0x0002, 0x0014, 0x0011, 0xFFE5, 0x0005, 0x0016,
    0x0001, 0xFFFF, 0xFFEE, 0x0034, 0x000A, 0xFFF6, 0xFFDF, 0x0022,
    0xFFB8, 0x0038, 0x0009, 0x001A, 0xFFE2, 0xFFFC, 0xFFF9, 0x0008,
    0x002B, 0x0021, 0x000C, 0xFFD2, 0xFFED, 0x0005, 0x0009, 0x0000,
    0xFFD8, 0xFFFF, 0x000F, 0xFFD1, 0xFFD7, 0x0009, 0xFFEB, 0x0032,
    0xFFFA, 0xFFF9, 0x002B, 0x0009, 0xFFFF, 0x0014, 0x0013, 0xFFF1,
    0xFFED, 0x000F, 0xFFF4, 0x001A, 0x0022, 0xFFF2, 0x0014, 0xFFF8,
    0xFFEF, 0x0001, 0xFFFC, 0x0007, 0x001A, 0x0012, 0xFFEF, 0xFFEB,
    0x0005, 0x0012, 0x0020, 0xFFDD, 0xFFF3, 0xFFDF, 0x001E, 0x000C,
    0x0005, 0xFFD7, 0x0014, 0x002A, 0xFFF2, 0x0045, 0x0002, 0xFFE0,
    0xFFFC, 0x0007, 0x000E, 0x001A, 0xFFF0, 0xFFDE, 0xFFEB, 0xFFFA,
    0x0016, 0x000B, 0xFFEB, 0x000D, 0xFFFC, 0xFFFA, 0xFFEB, 0xFFD4,
    0xFFD9, 0xFFF7, 0xFFE3, 0xFFEE, 0x000B, 0xFFF6, 0x000C, 0xFFD5,
    0xFFDF, 0xFFF3, 0xFFFB, 0x0039, 0xFFF0, 0x0004, 0x000E, 0xFFF0,
    0xFFF3, 0x0022, 0xFFFF, 0x0018, 0x0002, 0x001C, 0xFFE1, 0x002C,
    0xFFE6, 0xFFF3, 0xFFFC, 0x0016, 0xFFFC, 0xFFF8, 0xFFE6, 0x000A,
    0x000A, 0x0002, 0x0014, 0x0014, 0x000E, 0x002B, 0x000D, 0x0016,
    0xFFE5, 0x0004, 0x0017, 0x001F, 0x0007, 0x0002, 0xFFEC, 0xFFFF,
    0x0010, 0xFFDC, 0xFFE6, 0x0011, 0x0006, 0x0020, 0x0022, 0x0010,
    0x0012, 0xFFEE, 0x0000, 0x000D, 0x000F, 0xFFDE, 0x0002, 0x0017,
    0x000C, 0x0011, 0x0004, 0xFFF6, 0x001C, 0x0010, 0xFFEC, 0x0008,
    0xFFE9, 0x0000, 0xFFFA, 0x0021, 0x0017, 0x001B, 0xFFF0, 0x0038,
    0x002C, 0x000D, 0xFFE3, 0xFFE0, 0xFFE2, 0x0007, 0xFFF3, 0x0016,
    0x0005, 0xFFD2, 0x001F, 0xFFF0, 0xFFF4, 0x0005, 0xFFFE, 0xFFF3,
    0xFFDD, 0x0017, 0xFFE8, 0xFFEC, 0x0006, 0xFFFF, 0xFFD6, 0x0025,
    0x0022, 0x0014, 0xFFF2, 0x000A, 0xFFF3, 0x0024, 0xFFBC, 0xFFDE,
    0x0021, 0x001E, 0x0015, 0xFFF6, 0xFFF2, 0x0018, 0xFFF3, 0xFFED,
    0x0013, 0xFFF2, 0xFFF6, 0xFFEF, 0x000A, 0xFFE4, 0x000A, 0xFFF1,
    0xFFFE, 0xFFF7, 0x0025, 0xFFF1, 0x0023, 0x0023, 0x0018, 0xFFFD,
    0x0003, 0xFFEA, 0xFFFF, 0xFFFA, 0x0018, 0xFFFC, 0x0026, 0x000C,
    0xFFFD, 0x0023, 0xFFE6, 0xFFFF, 0xFFFA, 0x0027, 0x000E, 0x0015,
    0xFFDC, 0xFFF3, 0xFFF9, 0x0007, 0x000E, 0x0041, 0xFFF0, 0xFFDE,
    0x0032, 0x000E, 0xFFFB, 0x0002, 0xFFF2, 0x001B, 0x0008, 0x0009,
    0xFFFF, 0x001F, 0x0016, 0xFFFE, 0xFFDF, 0x000A, 0x000B, 0x001C,
    0xFFFC, 0xFFEC, 0x0019, 0xFFFA, 0x0015, 0x0015, 0xFFFF, 0x0025,
    0xFFF1, 0x0010, 0xFFF2, 0xFFF9, 0x003A, 0x0010, 0x0019, 0x0013,
    0xFFF4, 0x0026, 0xFFE8, 0xFFE7, 0xFFD4, 0x0011, 0x0009, 0xFFE6,
    0xFFFB, 0xFFE4, 0x000E, 0xFFCD, 0x0003, 0xFFF8, 0x0007, 0xFFF3,
    0x0011, 0x0014, 0xFFF6, 0x0004, 0x0008, 0xFFF1, 0x0017, 0xFFEF,
    0xFFE0, 0xFFE8, 0xFFEF, 0xFFF5, 0xFFE0, 0xFFE6, 0x0009, 0x0008,
    0x0011, 0x0003, 0xFFCE, 0xFFE9, 0xFFF4, 0xFFF3, 0x0020, 0xFFFD,
    0x0005, 0x000C, 0x0004, 0x0005, 0xFFF9, 0xFFE1, 0xFFFE, 0xFFF7,
    0x001F, 0x0013, 0xFFF7, 0xFFE9, 0x0015, 0xFFEA, 0x0016, 0x0009,
    0xFFFA, 0x0011, 0xFFF1, 0x0004, 0xFFF2, 0xFFF8, 0x0006, 0xFFDD,
    0xFFF3, 0x0013, 0xFFEA, 0x0001, 0xFFE3, 0xFFFD, 0x0001, 0x0038,
    0xFFF2, 0x0007, 0x000B, 0xFFF9, 0x0007, 0x0002, 0xFFED, 0x0005,
    0xFFDC, 0xFFD8, 0xFFD6, 0x001F, 0xFFF2, 0x0007, 0xFFF5, 0x0010,
    0xFFE6, 0xFFFF, 0xFFEE, 0xFFD7, 0x0011, 0x0023, 0xFFFF, 0x001B,
    0x000A, 0xFFED, 0xFFF9, 0x000D, 0xFFDF, 0xFFEF, 0x000E, 0x0016,
    0x0038, 0xFFF7, 0x0012, 0x0007, 0x0030, 0x0023, 0x0024, 0xFFF3,
    0xFFEE, 0xFFED, 0x001A, 0xFFE0, 0x001B, 0xFFF7, 0xFFE4, 0x0010,
    0xFFEF, 0x002F, 0xFFFE, 0xFFFD, 0xFFFA, 0xFFF6, 0xFFFB, 0x0013,
    0xFFEE, 0x0012, 0x001E, 0xFFE2, 0xFFB5, 0xFFFB, 0xFFF5, 0x0002,
    0x0007, 0x0003, 0xFFE0, 0xFFE0, 0xFFE8, 0x0012, 0xFFE3, 0x0011,
    0x0013, 0x0001, 0x0017, 0xFFF4, 0x0005, 0xFFF3, 0x0007, 0x0005,
    0xFFEB, 0x0027, 0xFFF9, 0xFFF6, 0xFFFB, 0xFFC4, 0x000F, 0xFFD8,
    0x0021, 0xFFCF, 0x002C, 0xFFFC, 0x0039, 0x0025, 0x0008, 0x0007,
    0x0004, 0xFFED, 0x0017, 0x0011, 0xFFE0, 0x0005, 0x0019, 0xFFE5,
    0xFFE7, 0x000B, 0xFFFB, 0x0005, 0xFFFB, 0x001C, 0xFFF6, 0x0000,
    0x0005, 0xFFD7, 0xFFD4, 0x001F, 0xFFFB, 0x0029, 0x0004, 0x0009,
    0xFFFB, 0xFFEA, 0x0016, 0xFFC8, 0xFFCD, 0xFFFE, 0xFFC7, 0xFFD7,
    0x0000, 0xFFFA, 0xFFE2, 0xFFD1, 0xFFF3, 0xFFF4, 0x001C, 0xFFE8,
    0x0003, 0xFFFC, 0xFFE8, 0x0016, 0x000A, 0xFFF8, 0xFFDD, 0x0006,
    0xFFEF, 0xFFF2, 0xFFF0, 0xFFCD, 0xFFF0, 0xFFF9, 0x000D, 0x0020,
    0x0003, 0x0043, 0xFFFC, 0xFFE6, 0xFFDA, 0xFFD1, 0xFFF2, 0xFFE9,
    0x0003, 0x001C, 0xFFE2, 0x0013, 0x0003, 0xFFF4, 0xFFF4, 0x0018,
    0x002F, 0x000E, 0xFFEC, 0x000F, 0xFFE4, 0x0011, 0xFFD7, 0xFFFC,
    0x001E, 0xFFDD, 0xFFE4, 0xFFEC, 0x0001, 0x0016, 0x0035, 0xFFF9,
    0xFFEC, 0x000E, 0xFFD6, 0xFFDD, 0xFFDD, 0xFFFC, 0x000A, 0xFFDA,
    0x000B, 0xFFE7, 0x001B, 0xFFDF, 0x0001, 0xFFE4, 0xFFEF, 0x001D,
    0x0018, 0x0001, 0x0037, 0xFFFA, 0x0001, 0xFFDC, 0xFFDF, 0xFFF8,
    0x0002, 0x001E, 0xFFDA, 0x0017, 0x0002, 0xFFFF, 0x000E, 0xFFF4,
    0xFFF9, 0xFFD9, 0x0027, 0x0013, 0x001B, 0x0029, 0x0025, 0x000F,
    0x000D, 0x000A, 0x0000, 0x0029, 0x0015, 0xFFBC, 0xFFFA, 0x0010,
    0xFFD9, 0x0002, 0xFFF4, 0x000F, 0xFFE8, 0x000A, 0xFFE5, 0xFFD4,
    0x0003, 0x000C, 0x000D, 0x0015, 0xFFE2, 0xFFC5, 0xFFC5, 0x000D,
    0x0004, 0x000B, 0x0007, 0x0016, 0xFFFF, 0x0003, 0x0021, 0xFFE8,
    0xFFFD, 0x0034, 0x0006, 0xFFE9, 0x0021, 0xFFDF, 0xFFFB, 0xFFE9,
    0x0018, 0x0011, 0x003C, 0x002C, 0xFFEB, 0xFFF7, 0xFFED, 0xFFF2,
    0x0012, 0x0010, 0x0004, 0xFFF9, 0xFFEE, 0xFFFE, 0x000E, 0x0034,
    0x0036, 0xFFF1, 0xFFF5, 0xFFF9, 0x0017, 0xFFF8, 0xFFEC, 0x001F,
    0xFFF4, 0xFFEC, 0xFFD6, 0x001C, 0x0011, 0x0009, 0x000E, 0xFFE4,
    0xFFFA, 0xFFF7, 0x0024, 0x0002, 0x0003, 0xFFE8, 0x0003, 0x001D,
    0x0019, 0xFFD4, 0x001D, 0x0017, 0x001D, 0x0018, 0xFFF9, 0x0003,
    0x000A, 0xFFE3, 0xFFCD, 0xFFE3, 0xFFE2, 0xFFF4, 0x0010, 0x0003,
    0x000B, 0xFFFB, 0xFFE6, 0x0015, 0x0014, 0xFFF2, 0xFFF5, 0x0025,
    0x000E, 0xFFF7, 0xFFCD, 0xFFFF, 0xFFFB, 0x000A, 0xFFED, 0xFFC2,
    0xFFFE, 0x0028, 0x0012, 0x0002, 0xFFE2, 0x0017, 0xFFFE, 0xFFD1,
    0xFFE0, 0x000F, 0xFFE4, 0x0014, 0x0008, 0x0001, 0xFFE7, 0xFFF6,
    0x0010, 0x001A, 0xFFCA, 0x0005, 0x001F, 0xFFED, 0xFFF4, 0x0002,
    0xFFF7, 0xFFD6, 0x0025, 0xFFFA, 0x0012, 0x0012, 0x0016, 0x0008,
    0xFFE6, 0x000D, 0xFFF8, 0x0005, 0x0012, 0xFFE7, 0xFFF6, 0xFFE9,
    0xFFE9, 0x0007, 0x0016, 0x0010, 0xFFF8, 0xFFD7, 0xFFF8, 0x0021,
    0x0029, 0xFFDE, 0x001B, 0xFFFB, 0xFFFC, 0x0012, 0xFFF9, 0xFFCC,
    0x000A, 0x0008, 0x0007, 0xFFE6, 0x0002, 0xFFF8, 0x0064, 0x0011,
    0xFFF0, 0x0021, 0x0038, 0x0019, 0xFFF7, 0xFFEF, 0xFFEE, 0x0003,
    0xFFEE, 0xFFEA, 0xFFF3, 0xFFF9, 0x0007, 0xFFD3, 0x000E, 0xFFF9,
    0x0009, 0xFFF9, 0x0010, 0xFFFA, 0x002A, 0xFFF6, 0x000C, 0xFFE9,
    0x0010, 0x000C, 0x000C, 0x000D, 0xFFF4, 0xFFF7, 0x0016, 0xFFE8,
    0x0011, 0xFFF3, 0xFFF7, 0x0000, 0x0003, 0x0010, 0x0007, 0x0032,
    0x0007, 0xFFF0, 0x0014, 0xFFE5, 0xFFEC, 0xFFFC, 0xFFF2, 0xFFF9,
    0xFFF6, 0x0009, 0xFFF4, 0x0001, 0xFFED, 0x0007, 0x000F, 0x000A,
    0xFFD5, 0xFFDB, 0xFFE5, 0xFFDC, 0x0003, 0x000D, 0x0018, 0x0016,
    0x0016, 0xFFE8, 0x0001, 0xFFF5, 0xFFF7, 0xFFDB, 0xFFCE, 0xFFF5,
    0x0023, 0x0008, 0x0002, 0x0003, 0x0001, 0xFFF5, 0x0007, 0x001F,
    0x0027, 0xFFF7, 0xFFD7, 0x0017, 0x000D, 0xFFF2, 0xFFDC, 0x0010,
    0x000B, 0x0013, 0xFFCA, 0x0014, 0xFFF4, 0xFFD5, 0xFFED, 0x0014,
    0x002D, 0x0000, 0xFFE0, 0xFFE3, 0x0006, 0xFFE3, 0xFFF8, 0x000A,
    0x0010, 0xFFE8, 0xFFDD, 0x0013, 0xFFFA, 0x000F, 0xFFFC, 0xFFFF,
    0xFFDE, 0x0002, 0xFFFA, 0xFFFA, 0xFFD2, 0xFFE4, 0xFFDE, 0x000E,
    0xFFFD, 0x0022, 0xFFE2, 0x0016, 0xFFFA, 0x000A, 0xFFF4, 0x0017,
    0x0015, 0xFFFB, 0x0000, 0x000D, 0x0008, 0x001B, 0x000D, 0x0022,
    0x0023, 0xFFE6, 0xFFF3, 0x0025, 0xFFFA, 0xFFD5, 0x0033, 0xFFE7,
    0xFFED, 0x0031, 0xFFE9, 0x0016, 0xFFEF, 0xFFF3, 0x000B, 0x001A,
    0x0010, 0x000D, 0xFFF1, 0xFFE3, 0xFFE4, 0xFFDF, 0xFFED, 0x002A,
    0x000F, 0xFFF5, 0xFFE9, 0x0026, 0x000C, 0xFFF0, 0x0001, 0xFFD7,
    0xFFFD, 0x0012, 0xFFF9, 0x000C, 0xFFEC, 0xFFD9, 0xFFFA, 0x0019,
    0x0001, 0x0002, 0x0012, 0x0009, 0x0013, 0x0008, 0x0028, 0x000D,
    0xFFDE, 0x001C, 0x0016, 0xFFE7, 0xFFFB, 0xFFE0, 0xFFD3, 0xFFEF,
    0xFFEE, 0x000A, 0xFFF7, 0x0011, 0xFFFB, 0x0004, 0xFFFD, 0x0020,
    0x0048, 0x000C, 0xFFDD, 0xFFF8, 0xFFF4, 0xFFF7, 0xFFDC, 0xFFF7,
    0x0022, 0x000A, 0xFFF7, 0xFFF9, 0x0013, 0x0014, 0xFFC6, 0xFFE3,
    0xFFDB, 0x0017, 0x0001, 0xFFD1, 0xFFF1, 0xFFFA, 0xFFEF, 0x002F,
    0xFFDB, 0x001F, 0xFFDA, 0x003D, 0xFFD0, 0xFFD0, 0x0013, 0x0000,
    0xFFE8, 0xFFF9, 0x0003, 0xFFF7, 0x0014, 0xFFF3, 0xFFEC, 0xFFEC,
    0xFFEB, 0xFFDF, 0xFFD6, 0xFFE4, 0x000C, 0xFFF3, 0x000F, 0x0012,
    0x0006, 0xFFEA, 0x001F, 0x0023, 0xFFF0, 0xFFFD, 0x0022, 0x0022,
    0xFFDF, 0x000C, 0xFFEA, 0x0008, 0x0017, 0xFFE2, 0x0004, 0x0010,
    0x001C, 0x0009, 0x0014, 0xFFEF, 0xFFEE, 0xFFE1, 0xFFE8, 0x0006,
    0x0030, 0x0015, 0xFFD0, 0xFFF4, 0x000D, 0xFF9F, 0xFFED, 0xFFD5,
    0xFFF1, 0x0002, 0x002F, 0xFFF6, 0x0035, 0x0037, 0x0008, 0x000A,
    0x0006, 0x000A, 0xFFEA, 0x0006, 0xFFE0, 0xFFFE, 0x0000, 0xFFE9,
    0xFFFA, 0xFFF0, 0x002E, 0x002D, 0x0014, 0x0000, 0x0010, 0xFFF6,
    0xFFF7, 0x0014, 0xFFF1, 0xFFE4, 0x0008, 0x0018, 0x0000, 0xFFF2,
    0x001A, 0xFFF1, 0xFFEA, 0x0031, 0x0002, 0x0015, 0xFFDD, 0x0006,
    0xFFFF, 0xFFDB, 0x000B, 0xFFDB, 0xFFF5, 0xFFF6, 0xFFEF, 0xFFFB,
    0xFFE1, 0xFFFE, 0xFFC9, 0x0022, 0xFFF0, 0xFFEF, 0x0015, 0xFFF4,
    0x0019, 0xFFF8, 0x0022, 0x0023, 0xFFF9, 0xFFEE, 0x0012, 0xFFED,
    0xFFFB, 0x0008, 0x000D, 0xFFE1, 0xFFF1, 0x0007, 0x0008, 0xFFFD,
    0xFFEA, 0x003F, 0xFFF1, 0x0028, 0xFFDA, 0x004D, 0x0021, 0x001E,
    0x0035, 0xFFF6, 0xFFD3, 0x0014, 0x003F, 0x0001, 0x0003, 0xFFF2,
    0x000E, 0xFFE1, 0x003E, 0xFFE1, 0x0001, 0xFFF8, 0x0012, 0xFFEE,
    0x0005, 0xFFE9, 0x001C, 0x0005, 0xFFE4, 0xFFD9, 0xFFF0, 0xFFF6,
    0x0009, 0x0013, 0x0003, 0xFFFB, 0x005C, 0x000B, 0x0017, 0x001C,
    0xFFE7, 0x0006, 0xFFE8, 0x0030, 0x0014, 0xFFF1, 0x000A, 0xFFEE,
    0xFFE4, 0xFFFF, 0xFFF7, 0xFFE9, 0x003A, 0xFFFE, 0xFFE7, 0xFFFA,
    0xFFDD, 0x0007, 0x0015, 0xFFE6, 0xFFFB, 0xFFE5, 0x0019, 0xFFF7,
    0xFFF6, 0x000B, 0xFFF1, 0xFFED, 0xFFDC, 0xFFF4, 0xFFF9, 0x002B,
    0x0022, 0xFFFE, 0xFFFA, 0xFFFF, 0xFFEB, 0x001A, 0xFFEA, 0x000A,
    0xFFEC, 0xFFE4, 0x0001, 0x002B, 0xFFEF, 0xFFD8, 0x0016, 0xFFFB,
    0x0007, 0xFFFF, 0x0027, 0x0002, 0xFFFD, 0xFFE3, 0xFFF7, 0xFFFD,
    0xFFE2, 0xFFE1, 0x0032, 0xFFFD, 0xFFFA, 0x000E, 0x000B, 0xFFED,
    0xFFE4, 0xFFF3, 0xFFD2, 0x0017, 0x000A, 0x001C, 0x0015, 0x0021,
    0x0012, 0xFFF4, 0x000B, 0x0051, 0x001A, 0x002C, 0x0000, 0xFFE6,
    0x0000, 0xFFFD, 0x001F, 0xFFFC, 0x000A, 0xFFFE, 0x0004, 0xFFEC,
    0x0026, 0x0003, 0x0017, 0x0002, 0xFFF8, 0xFFE1, 0xFFE8, 0xFFF6,
    0xFFEE, 0x0045, 0x0003, 0x0009, 0xFFE9, 0xFFFB, 0x0019, 0x000E,
    0x000C, 0xFFDC, 0x0018, 0xFFFB, 0xFFFF, 0xFFEB, 0x0017, 0x0015,
    0x003F, 0x0006, 0x0011, 0x0017, 0x0023, 0xFFCB, 0xFFCC, 0xFFDF,
    0x0007, 0x0010, 0xFFFB, 0x0011, 0xFFFD, 0x0037, 0xFFF6, 0xFFF5,
    0xFFE3, 0xFFFC, 0x0005, 0xFFE9, 0xFFE6, 0x0019, 0x0010, 0x000A,
    0x0017, 0x001A, 0x0009, 0xFFE5, 0xFFE8, 0xFFF1, 0x001F, 0xFFE8,
    0x0016, 0x000B, 0x0012, 0xFFDB, 0xFFEB, 0x0032, 0xFFF8, 0x0002,
    0x0002, 0xFFF2, 0xFFD3, 0xFFF1, 0xFFE6, 0xFFC9, 0xFFE7, 0xFFE2,
    0xFFE8, 0x0014, 0xFFFF, 0xFFF5, 0x0001, 0x0000, 0x0018, 0x0022,
    0xFFE3, 0xFFDE, 0xFFEB, 0xFFE7, 0x0022, 0xFFF9, 0xFFE1, 0xFFE3,
    0x0004, 0x0004, 0xFFEF, 0x0015, 0x0003, 0x000D, 0x0037, 0x001D,
    0xFFDB, 0xFFF3, 0xFFEF, 0xFFF4, 0xFFC4, 0x0000, 0x0020, 0x000E,
    0xFFF3, 0x0010, 0x000C, 0xFFF8, 0x0007, 0xFFFF, 0xFFE2, 0xFFEC,
    0xFFEF, 0x0000, 0xFFF4, 0x004D, 0x001C, 0x000F, 0xFFEC, 0x0012,
    0x0001, 0x0021, 0xFFEB, 0xFFF4, 0x002D, 0x001A, 0x0026, 0x0004,
    0x001C, 0xFFCC, 0x0009, 0x0024, 0x0008, 0x000E, 0x002E, 0x0016,
    0x0000, 0x001E, 0xFFEB, 0xFFFD, 0x000A, 0x0011, 0xFFE6, 0x000B,
    0xFFF2, 0x0033, 0x0001, 0x003F, 0x0011, 0x000A, 0xFFFD, 0x001D,
    0x0016, 0x0004, 0xFFE8, 0x0009, 0x002B, 0x000E, 0x0013, 0x000F,
    0xFFCD, 0xFFFC, 0xFFE5, 0x0014, 0x002C, 0x0016, 0xFFFC, 0x001B,
    0x0022, 0xFFE1, 0x001C, 0x0012, 0x0005, 0xFFFE, 0xFFEA, 0x0006,
    0x000D, 0xFFE0, 0x0000, 0xFFFD, 0xFFF1, 0xFFDC, 0x000F, 0xFFFF,
    0xFFF7, 0x0001, 0x002D, 0xFFEA, 0xFFEA, 0x000D, 0xFFF6, 0x000A,
    0xFFED, 0xFFED, 0xFFE7, 0x0013, 0xFFFF, 0x0021, 0xFFE5, 0x000F,
    0x0006, 0x0002, 0xFFF6, 0x0002, 0xFFC4, 0xFFEB, 0xFFF3, 0xFFFB,
    0x0019, 0xFFE3, 0x002B, 0xFFF5, 0x0010, 0x0008, 0xFFCC, 0xFFD8,
    0x000D, 0x002E, 0x0003, 0xFFD9, 0x0002, 0xFFF1, 0x0043, 0x0014,
    0xFFE6, 0x0029, 0xFFFB, 0xFFE7, 0xFFE7, 0x0001, 0x0026, 0xFFEC,
    0x0038, 0x003A, 0x0001, 0x000E, 0xFFEE, 0xFFE5, 0x004F, 0xFFF1,
    0x001D, 0x0046, 0x0026, 0xFFE0, 0x0008, 0x001A, 0xFFD7, 0x0001,
    0xFFF7, 0x000C, 0x0010, 0xFFD8, 0x0018, 0xFFEE, 0x000D, 0xFFFC,
    0x000E, 0xFFF6, 0x000A, 0x0000, 0xFFCB, 0x0021, 0xFFD8, 0xFFE9,
    0xFFD0, 0xFFD1, 0xFFF3, 0x0013, 0xFFF8, 0x0008, 0x001B, 0xFFFB,
    0x000C, 0xFFFD, 0x001C, 0xFFF9, 0x002D, 0xFFEE, 0x0016, 0x003B,
    0x0000, 0xFFE2, 0xFFEB, 0x0003, 0xFFEA, 0xFFEC, 0xFFCF, 0x0008,
    0xFFD8, 0x0008, 0x000E, 0xFFD3, 0x0013, 0x0009, 0xFFD9, 0xFFFC,
    0xFFE0, 0x2CC4, 0x001E, 0x000B, 0x0024, 0x0012, 0x0007, 0xFFDE,
    0xFFF9, 0x0016, 0xFFFF, 0xFFF2, 0x000B, 0xFFCA, 0x002B, 0xFFED,
    0xFFF7, 0xFFCF, 0xFFE1, 0x0002, 0xFFE8, 0x0000, 0x0006, 0x0027,
    0xFFFA, 0x0006, 0xFFD4, 0x0017, 0xFFFA, 0x0025, 0xFFD9, 0x0007,
    0xFFEF, 0x0001, 0xFFF6, 0x0017, 0xFFEA, 0x0039, 0xFFF8, 0xFFE8,
    0xFFF8, 0x0019, 0xFFFD, 0x0001, 0x0003, 0xFFDE, 0xFFFB, 0x0018,
    0xFFE4, 0xFFF7, 0x000D, 0xFFF9, 0x0000, 0xFFFD, 0x002E, 0x000F,
    0x0001, 0x0019, 0x0021, 0x0025, 0xFFF4, 0xFFF5, 0x001C, 0x0023,
    0x000D, 0xFFE3, 0x0011, 0xFFE7, 0x0027, 0x0043, 0x001F, 0xFFF3,
    0xFFE2, 0xFFF6, 0x001F, 0xFFF8, 0x0007, 0x0009, 0x0000, 0xFFF1,
    0x0006, 0x0013, 0x001A, 0xFFFD, 0xFFF8, 0xFFEC, 0x0011, 0x0014,
    0x0001, 0xFFF7, 0x000E, 0xFFF7, 0x001D, 0xFFFD, 0x000C, 0xFFF3,
    0xFFF7, 0xFFE8, 0xFFDA, 0xFFE2, 0x001B, 0x0023, 0xFFF6, 0xFFEC,
    0x0031, 0xFFE5, 0x001E, 0x0010, 0xFFD6, 0xFFDB, 0x0002, 0xFFEC,
    0xFFFC, 0xFFF5, 0xFFF7, 0x0002, 0x0016, 0x0009, 0x0006, 0xFFC2,
    0x000F, 0x0002, 0xFFEE, 0x000E, 0x000F, 0xFFFC, 0x001C, 0x0000,
    0xFFC1, 0xFFEF, 0xFFFF, 0x0002, 0x0021, 0x0034, 0x0012, 0x0022,
    0x0019, 0xFFEF, 0xFFE7, 0xFFF7, 0xFFF2, 0x0022, 0x002F, 0x000B,
    0x000C, 0x001D, 0xFFEE, 0xFFF0, 0xFFEE, 0xFFFC, 0x0028, 0x0017,
    0x000A, 0xFFBD, 0xFFF6, 0x001C, 0xFFE4, 0xFFF9, 0x001E, 0x001E,
    0xFFE2, 0xFFFD, 0x000F, 0x001D, 0xFFFE, 0x0011, 0xFFD3, 0x001A,
    0x0000, 0xFFF7, 0x0014, 0x0008, 0xFFFB, 0xFFE1, 0xFFDE, 0xFFF8,
    0xFFF4, 0x0020, 0x0014, 0xFFF3, 0xFFD7, 0xFFF3, 0xFFE5, 0xFFDE,
    0x0009, 0x0005, 0x0004, 0xFFF7, 0x0041, 0x001E, 0xFFE3, 0xFFFF,
    0x0003, 0x0013, 0x0000, 0xFFE8, 0x0026, 0x0008, 0x0006, 0xFFEC,
    0x0004, 0xFFE7, 0xFFF7, 0x0009, 0x0017, 0xFFEF, 0x0002, 0x0006,
    0xFFF6, 0xFFD8, 0x0006, 0xFFF3, 0xFFFC, 0x0006, 0x0029, 0x0014,
    0x0002, 0x0015, 0xFFF0, 0x0000, 0x000E, 0xFFF5, 0xFFF4, 0xFFEF,
    0x0001, 0xFFF8, 0xFFFC, 0xFFFB, 0x0012, 0x0003, 0xFFE7, 0xFFE9,
    0xFFDE, 0x0009, 0x0008, 0x001E, 0xFFE5, 0xFFF0, 0x0027, 0x0001,
    0x0014, 0x0001, 0xFFFC, 0x000B, 0x001B, 0x0000, 0x000E, 0x0010,
    0x0019, 0xFFE9, 0xFFD7, 0xFFFC, 0x000D, 0x0022, 0xFFED, 0x0015,
    0xFFCB, 0x0002, 0x0011, 0xFFFA, 0x0016, 0xFFC3, 0xFFF2, 0xFFE3,
    0xFFD7, 0xFFFC, 0xFFE0, 0xFFEE, 0x0034, 0xFFFE, 0xFFDB, 0xFFE1,
    0xFFDC, 0x0011, 0x0004, 0x000E, 0xFFF5, 0x0037, 0xFFFD, 0x000C,
    0xFFEC, 0xFFEB, 0xFFF3, 0x0028, 0x000E, 0x001B, 0x0003, 0x0013,
    0xFFD6, 0xFFF1, 0xFFD9, 0x0004, 0x001E, 0xFFE5, 0xFFF8, 0xFFF0,
    0xFFF0, 0x0013, 0xFFC3, 0x002A, 0xFFEA, 0xFFEF, 0x000C, 0xFFEC,
    0xFFFB, 0x0019, 0xFFE0, 0xFFF0, 0xFFD5, 0x000A, 0xFFE2, 0x0003,
    0x0005, 0x0002, 0x0002, 0xFFE6, 0x000C, 0x0016, 0x0007, 0xFFF3,
    0xFFCA, 0x0031, 0xFFF9, 0xFFFB, 0xFFFC, 0x0016, 0xFFE4, 0xFFFB,
    0xFFFF, 0x000A, 0xFFD6, 0xFFF4, 0x0034, 0x002B, 0x0029, 0x0009,
    0xFFF4, 0xFFE7, 0xFFFF, 0xFFFE, 0xFFFE, 0xFFEA, 0xFFEC, 0x0004,
    0xFFF8, 0xFFEC, 0xFFB9, 0x001F, 0xFFEE, 0x0014, 0xFFFD, 0xFFFF,
    0x0011, 0x0006, 0xFFF2, 0xFFEF, 0x0009, 0xFFF2, 0xFFF1, 0x0025,
    0xFFF2, 0x0001, 0x0010, 0xFFE1, 0x0007, 0xFFE3, 0xFFF9, 0xFFF5,
    0x0024, 0x0000, 0x0002, 0x001D, 0x0001, 0xFFD3, 0x001C, 0x0000,
    0xFFF2, 0xFFE6, 0x001D, 0x000F, 0x0010, 0xFFE9, 0x000F, 0x0004,
    0xFFF5, 0x001D, 0xFFEA, 0x0007, 0xFFF2, 0xFFE6, 0x002C, 0x0007,
    0x0011, 0x0013, 0x001E, 0x0011, 0xFFED, 0x000F, 0x0016, 0xFFED,
    0xFFE3, 0xFFE8, 0xFFE3, 0x0011, 0xFFFF, 0xFFE8, 0x0001, 0x000B,
    0x000C, 0x0004, 0xFFF8, 0xFFFF, 0x0004, 0xFFE6, 0x000F, 0xFFFF,
    0xFFE1, 0xFFF4, 0xFFF2, 0xFFFA, 0x0010, 0xFFC8, 0xFFFF, 0x001B,
    0xFFF6, 0xFFF2, 0x0013, 0x000C, 0x0005, 0x0017, 0xFFDE, 0xFFF2,
    0x0026, 0x000B, 0x0000, 0xFFF9, 0x001B, 0xFFFB, 0x0002, 0xFFD8,
    0x0007, 0xFFF3, 0xFFF9, 0xFFF4, 0xFFDB, 0x0016, 0x0018, 0x0025,
    0x000C, 0x0015, 0x000E, 0x000D, 0x0001, 0xFFF3, 0x000F, 0xFFE2,
    0x0002, 0x001C, 0xFFFB, 0x0001, 0x001D, 0xFFEE, 0x000A, 0x0005,
    0xFFD4, 0x0016, 0x0016, 0xFFEC, 0xFFD8, 0x0009, 0x0025, 0xFFD9,
    0xFFE0, 0x0026, 0x000C, 0xFFEB, 0xFFFD, 0x002C, 0xFFE7, 0x0017,
    0xFFFF, 0xFFC8, 0x0005, 0x001C, 0x0001, 0x0016, 0xFFF6, 0xFFEE,
    0xFFF2, 0xFFFF, 0x0014, 0xFFCD, 0x002C, 0x003E, 0x001B, 0xFFF8,
    0x000B, 0xFFF0, 0xFFDC, 0x000C, 0x000D, 0xFFFB, 0xFFCC, 0xFFF4,
    0xFFFA, 0xFFD8, 0xFFF4, 0x000C, 0xFFF0, 0xFFF5, 0x0004, 0xFFFF
    };

static const q15_t ref_cfft_noisy_2048[4096] = {
    0x0001, 0x0000, 0x0004, 0x0001, 0xFFF0, 0x000B, 0xFFF4, 0xFFF4,
    0xFFFA, 0x0028, 0xFFCC, 0x000C, 0x000D, 0x0005, 0xFFDC, 0xFFF4,
    0x000B, 0x0010, 0x001B, 0x0008, 0x002C, 0xFFC2, 0x0014, 0x0033,
    0xFFF2, 0x0001, 0xFFF6, 0x0012, 0x0001, 0xFFEA, 0x0005, 0xFFE4,
    0xFFFF, 0x0038, 0xFFE7, 0xFFE9, 0xFFFD, 0xFFD4, 0x000C, 0x0015,
    0xFFE0, 0xFFDA, 0x0025, 0x0027, 0xFFD8, 0xFFF7, 0x0016, 0x0014,
    0xFFD4, 0xFFEA, 0x000A, 0xFFFB, 0x001D, 0x0012, 0xFFFB, 0xFFFF,
    0x0002, 0xFFE4, 0x000F, 0x001E, 0x0001, 0x000D, 0x000E, 0xFFF3,
    0x000C, 0xFFEB, 0x0018, 0xFFDB, 0xFFDB, 0xFFEA, 0xFFF9, 0x000C,
    0x0007, 0x000D, 0x0002, 0x0028, 0x001B, 0x0005, 0x0000, 0x0007,
    0x0026, 0xFFF5, 0xFFDE, 0x000E, 0x0005, 0xFFE9, 0x0013, 0xFFF4,
    0xFFF6, 0x000E, 0xFFFF, 0xFFE5, 0x0010, 0x0038, 0xFFF2, 0x0006,
    0xFFE1, 0x000C, 0x000F, 0x0001, 0x0004, 0x001A, 0xFFF8, 0x0001,
    0x000C, 0xFFFC, 0x0001, 0xFFF5, 0xFFFF, 0x0018, 0xFFE3, 0xFFEF,
    0xFFE3, 0x0018, 0x0016, 0x0013, 0xFFED, 0xFFF1, 0x001E, 0xFFEF,
    0x0011, 0xFFED, 0x002C, 0xFFF9, 0xFFF2, 0x001A, 0xFFEA, 0xFFF9,
    0xFFF5, 0xFFE3, 0x000F, 0xFFFC, 0x0010, 0x0017, 0x001D, 0xFFF1,
    0xFFF2, 0x001A, 0x001C, 0x0000, 0x0001, 0x002D, 0x0002, 0xFFE3,
    0x0024, 0x0000, 0xFFF9, 0x000B, 0x0007, 0x001D, 0x0010, 0x001F,
    0xFFF2, 0xFFFF, 0xFFF1, 0xFFDB, 0x0009, 0x000E, 0xFFF2, 0x0011,
    0x0011, 0xFFFA, 0xFFFD, 0x0001, 0xFFEE, 0xFFEC, 0xFFB9, 0xFFE1,
    0xFFF8, 0x0014, 0xFFEC, 0xFFFC, 0xFFFE, 0x0016, 0xFFFF, 0x0002,
    0xFFF4, 0x0019, 0x0029, 0xFFF7, 0x0034, 0xFFD5, 0xFFD6, 0x000C,
    0xFFFF, 0xFFF6, 0xFFE4, 0x0005, 0xFFFC, 0xFFEA, 0xFFF9, 0x0005,
    0xFFCA, 0xFFCF, 0x0007, 0x000D, 0x000C, 0xFFEA, 0x0002, 0x001A,
    0x0005, 0xFFFE, 0xFFE2, 0xFFFD, 0xFFD5, 0xFFF6, 0xFFE0, 0x0010,
    0xFFFB, 0xFFE7, 0x000C, 0x0014, 0xFFEA, 0x0011, 0xFFC3, 0xFFD6,
    0xFFF0, 0xFFED, 0xFFF8, 0x0010, 0x001E, 0x001B, 0xFFD9, 0xFFFC,
    0xFFD6, 0x000F, 0x0003, 0xFFED, 0x000E, 0xFFE5, 0xFFF3, 0xFFD8,
    0xFFEC, 0x0015, 0xFFFD, 0xFFF4, 0xFFF5, 0xFFC9, 0x0004, 0xFFF2,
    0xFFDC, 0xFFEF, 0xFFDB, 0x001F, 0x0034, 0x0002, 0xFFE0, 0x0012,
    0xFFD7, 0x0004, 0xFFF2, 0x001D, 0x0016, 0x003D, 0x0011, 0x0006,
    0xFFCB, 0xFFFE, 0xFFED, 0xFFEB, 0x000D, 0xFFDE, 0xFFD7, 0x0004,
    0x0019, 0x0017, 0x000E, 0xFFF0, 0x001B, 0x0000, 0xFFFC, 0xFFF5,
    0x0014, 0xFFFF, 0x0027, 0xFFFF, 0xFFE5, 0x0010, 0x0008, 0xFFE2,
    0xFFDE, 0xFFF7, 0xFFE7, 0x0017, 0x0012, 0xFFFD, 0xFFFC, 0x0005,
    0x0001, 0x0008, 0xFFF4, 0x0011, 0x000E, 0x000B, 0xFFF0, 0x0000,
    0x0002, 0xFFEB, 0x0029, 0xFFEC, 0xFFFC, 0xFFFA, 0x0006, 0x000D,
    0xFFF6, 0x0028, 0x0002, 0xFFFA, 0x0017, 0x0011, 0xFFF7, 0xFFF7,
    0x0004, 0x0019, 0x0006, 0x0014, 0x0026, 0xFFF8, 0x0000, 0x0018,
    0x0003, 0xFFED, 0xFFE3, 0x0001, 0x0041, 0xFFE2, 0x0004, 0x0009,
    0x0009, 0xFFFB, 0xFFE5, 0x0022, 0xFFD7, 0x000D, 0x0014, 0x000D,
    0xFFF4, 0xFFE0, 0xFFDE, 0x0008, 0xFFFB, 0x001F, 0x0014, 0xFFF8,
    0x0000, 0x0009, 0xFFD3, 0xFFE6, 0xFFFE, 0xFFEF, 0x000F, 0xFFE3,
    0xFFE2, 0x0003, 0x001E, 0xFFE2, 0xFFE4, 0x0007, 0xFFF6, 0xFFE4,
    0x000A, 0x0043, 0x0028, 0xFFE9, 0xFFEE, 0x0004, 0xFFEE, 0x0010,
    0x000C, 0xFFE3, 0x002F, 0xFFF5, 0xFFF2, 0xFFDE, 0xFFE7, 0x0009,
    0x0019, 0x0011, 0x0012, 0xFFDE, 0x0021, 0xFFCC, 0xFFFF, 0xFFFE,
    0xFFC1, 0x0011, 0x001C, 0x0000, 0x000F, 0x0004, 0xFFEE, 0xFFF2,
    0x000F, 0xFFFE, 0x0006, 0x003E, 0x0016, 0xFFF7, 0xFFF7, 0xFFFE,
    0xFFFC, 0x000B, 0x0002, 0x0014, 0xFFD6, 0x0025, 0x001E, 0xFFF0,
    0x0031, 0x001B, 0xFFF6, 0x0014, 0x001B, 0xFFDD, 0xFFDA, 0x001E,
    0xFFF7, 0x0018, 0x000C, 0x000D, 0x001D, 0x0003, 0x000E, 0x0009,
    0x0001, 0x0009, 0x0011, 0xFFEC, 0xFFF8, 0x0014, 0x001A, 0x0003,
    0x0006, 0xFFED, 0x0000, 0x000F, 0x0007, 0xFFF7, 0x001F, 0x0008,
    0xFFE2, 0x000A, 0x001F, 0x000D, 0x0027, 0xFFBD, 0x0011, 0x0019,
    0x000D, 0x001D, 0x001C, 0xFFDD, 0xFFF4, 0x000B, 0x0021, 0xFFDB,
    0x0001, 0xFFE7, 0x002E, 0xFFF1, 0x0000, 0x0003, 0x000D, 0x0007,
    0xFFE4, 0x0009, 0xFFFB, 0xFFE8, 0x0003, 0x0022, 0xFFFD, 0xFFFF,
    0xFFF8, 0xFFE7, 0xFFF8, 0x0018, 0xFFEA, 0xFFC7, 0xFFF6, 0xFFE9,
    0xFFEF, 0xFFFF, 0xFFD9, 0xFFF9, 0xFFFA, 0xFFDB, 0xFFD4, 0xFFE9,
    0xFFFA, 0xFFFA, 0x0006, 0xFFD9, 0xFFE8, 0x0000, 0xFFE1, 0xFFFE,
    0xFFF7, 0x0031, 0x002B, 0x0013, 0x000B, 0x0036, 0xFFFF, 0x000E,
    0xFFF9, 0xFFEA, 0x0007, 0x0022, 0x0024, 0xFFEE, 0x001E, 0xFFF5,
    0xFFE0, 0xD33C, 0xFFD9, 0x0004, 0x0013, 0xFFF7, 0x000E, 0x002D,
    0xFFD8, 0xFFF8, 0xFFCF, 0xFFF8, 0xFFEA, 0x0014, 0xFFEB, 0xFFFD,
    0x0000, 0x001E, 0x0016, 0xFFC5, 0x002D, 0x0012, 0x001C, 0x0007,
    0x000C, 0x0003, 0x001B, 0x0005, 0xFFF8, 0xFFF8, 0xFFF3, 0xFFED,
    0xFFD0, 0x002F, 0xFFD8, 0x0017, 0xFFCB, 0xFFDF, 0x000A, 0x0000,
    0x000E, 0x000A, 0x000D, 0x0004, 0x0018, 0x0012, 0x0010, 0x0028,
    0xFFF7, 0xFFF4, 0xFFD7, 0xFFFF, 0x0008, 0xFFE6, 0x0026, 0x0020,
    0x001D, 0xFFBA, 0x004F, 0x000F, 0xFFEE, 0x001B, 0x0001, 0xFFF2,
    0x0038, 0xFFC6, 0x0026, 0x0014, 0xFFE7, 0xFFFF, 0xFFFB, 0x0019,
    0xFFE6, 0xFFD7, 0x0043, 0xFFEC, 0x0002, 0x000F, 0x0003, 0x0027,
    0x000D, 0xFFD2, 0xFFCC, 0x0028, 0x0010, 0xFFF8, 0x002B, 0x000B,
    0x0019, 0x001D, 0xFFF3, 0x0005, 0xFFC4, 0x0015, 0xFFF6, 0xFFFE,
    0x0006, 0xFFFE, 0xFFE5, 0xFFF1, 0xFFFF, 0xFFDF, 0xFFE7, 0xFFED,
    0xFFED, 0x0013, 0xFFF6, 0xFFF6, 0xFFEA, 0xFFF3, 0x002D, 0x0016,
    0xFFF7, 0xFFFF, 0x000F, 0x0001, 0xFFF1, 0x0024, 0x0000, 0x0003,
    0x000D, 0x0020, 0xFFEA, 0xFFFA, 0x0005, 0x0002, 0x001C, 0xFFEE,
    0x0022, 0x001F, 0xFFFC, 0xFFE5, 0x002C, 0xFFEA, 0xFFE5, 0xFFEC,
    0xFFCD, 0x0004, 0x0013, 0xFFF1, 0x002B, 0xFFF2, 0xFFE8, 0xFFF7,
    0x0016, 0xFFFC, 0xFFFD, 0xFFE3, 0x0011, 0xFFF6, 0x0001, 0xFFC1,
    0xFFF2, 0xFFCD, 0xFFE6, 0xFFF5, 0x000A, 0xFFEF, 0xFFEB, 0x0003,
    0x0000, 0xFFE2, 0x002E, 0xFFEA, 0x0008, 0xFFF2, 0x0009, 0xFFDC,
    0x001C, 0x0034, 0x0026, 0xFFFC, 0x002D, 0xFFE6, 0xFFEB, 0x000C,
    0x0001, 0xFFDF, 0xFFEC, 0xFFEE, 0x001C, 0xFFF1, 0xFFF4, 0xFFB3,
    0xFFEF, 0x0000, 0xFFE2, 0x0014, 0x0007, 0x0001, 0x000C, 0x0008,
    0xFFF3, 0xFFF0, 0x0020, 0xFFF2, 0xFFC4, 0x0000, 0xFFEF, 0x000C,
    0xFFDB, 0x000D, 0x0037, 0xFFE3, 0x0003, 0xFFF3, 0xFFEF, 0xFFEB,
    0x0004, 0xFFFC, 0xFFE1, 0x001D, 0x0022, 0x0007, 0xFFEB, 0x0019,
    0xFFE3, 0x0022, 0x0018, 0xFFDE, 0x0001, 0x0000, 0xFFFF, 0x000B,
    0xFFE8, 0xFFEC, 0xFFE7, 0x001E, 0xFFE6, 0x0037, 0xFFD3, 0x000F,
    0x0002, 0x000E, 0xFFF8, 0xFFFE, 0xFFEB, 0xFFCE, 0x0012, 0x0025,
    0x0016, 0xFFF5, 0x001F, 0x0018, 0xFFE8, 0x000F, 0x0009, 0x001B,
    0x0017, 0xFFE6, 0x0010, 0xFFF6, 0xFFE6, 0xFFE7, 0x0005, 0x0017,
    0xFFE3, 0x0004, 0xFFF6, 0x000B, 0xFFFD, 0xFFC9, 0xFFFB, 0xFFEF,
    0x0007, 0xFFF0, 0xFFCC, 0x0021, 0x0023, 0x0035, 0x0011, 0xFFE9,
    0x003F, 0xFFFA, 0x0017, 0xFFEB, 0xFFFF, 0x0015, 0x0018, 0x0005,
    0x000C, 0x0024, 0x0019, 0xFFF2, 0xFFE9, 0x0005, 0x0003, 0xFFF7,
    0xFFEE, 0xFFBB, 0xFFE8, 0x000A, 0xFFF8, 0x001F, 0x0017, 0xFFFE,
    0x0026, 0xFFFD, 0x0004, 0x0014, 0x000A, 0x0002, 0x001F, 0x0004,
    0x0000, 0x0003, 0x0000, 0x001A, 0x001A, 0xFFD4, 0x000B, 0xFFAF,
    0x0012, 0x000C, 0x0015, 0xFFDF, 0x000A, 0xFFE4, 0xFFD2, 0xFFE9,
    0xFFE4, 0x000D, 0x000B, 0x0013, 0xFFFA, 0xFFF2, 0x0032, 0x0003,
    0xFFE2, 0x001F, 0xFFF7, 0x0003, 0xFFFD, 0x001D, 0x0027, 0xFFFE,
    0x0007, 0x0001, 0x0016, 0x0005, 0xFFEF, 0x0028, 0x0001, 0xFFD5,
    0xFFEC, 0x001C, 0xFFEA, 0xFFF6, 0xFFEB, 0xFFE6, 0xFFFA, 0x0001,
    0x0022, 0x0002, 0xFFF9, 0xFFD5, 0xFFDC, 0x000C, 0xFFF1, 0x0013,
    0xFFF6, 0xFFF5, 0x0019, 0x0009, 0xFFFB, 0x001B, 0x0015, 0x001A,
    0xFFDD, 0xFFF9, 0xFFE7, 0x0006, 0x003A, 0x0002, 0xFFF7, 0x0017,
    0xFFE4, 0x0001, 0x000A, 0x0012, 0x0014, 0x000F, 0xFFE8, 0xFFD0,
    0xFFE7, 0xFFFA, 0x0017, 0xFFE4, 0x005C, 0xFFF5, 0x0003, 0x0005,
    0x0009, 0xFFED, 0xFFF0, 0x000A, 0xFFE4, 0x0027, 0x001C, 0xFFFB,
    0x0005, 0x0017, 0x0012, 0x0012, 0x0001, 0x0008, 0x003E, 0x001F,
    0x000E, 0x001F, 0x0003, 0x000E, 0x003F, 0xFFFF, 0xFFD3, 0xFFEC,
    0x0035, 0x000A, 0x0021, 0xFFE2, 0xFFDA, 0xFFB3, 0xFFF1, 0xFFD8,
    0xFFEA, 0xFFC1, 0x0008, 0x0003, 0xFFF1, 0xFFF9, 0x000D, 0x001F,
    0xFFFB, 0xFFF8, 0x0012, 0x0013, 0xFFF9, 0x0012, 0x0022, 0xFFDD,
    0x0019, 0x0008, 0x0015, 0x000C, 0xFFF0, 0x0011, 0xFFC9, 0xFFDE,
    0xFFE1, 0x0002, 0xFFEF, 0x0005, 0xFFF5, 0x000A, 0x000B, 0x0025,
    0xFFFF, 0x0025, 0xFFDD, 0xFFFA, 0x0002, 0xFFEB, 0xFFEA, 0xFFCF,
    0x001A, 0x000F, 0x0000, 0x000E, 0x0008, 0xFFE8, 0xFFF1, 0x001C,
    0xFFF7, 0xFFEC, 0x0010, 0x000A, 0x0014, 0x0000, 0x002E, 0xFFD3,
    0xFFFA, 0x0010, 0x0000, 0x0017, 0xFFE0, 0x0002, 0xFFEA, 0xFFFA,
    0x0006, 0xFFF6, 0x0008, 0xFFF6, 0x0035, 0xFFC9, 0x002F, 0x000A,
    0xFFF1, 0xFFFE, 0xFFED, 0x002B, 0x000D, 0x0061, 0xFFD0, 0x000C,
    0x0030, 0xFFEB, 0xFFE8, 0xFFFA, 0xFFEE, 0x001F, 0x0014, 0x0011,
    0x001C, 0xFFF7, 0x0004, 0xFFF0, 0x0017, 0x001E, 0xFFEA, 0xFFF8,
    0xFFDF, 0xFFF4, 0x0022, 0xFFDE, 0xFFF0, 0x0003, 0x001F, 0xFFDD,
    0x0006, 0x0016, 0x000F, 0xFFEE, 0x000C, 0x000D, 0xFFD6, 0x001C,
    0xFFEB, 0x0021, 0xFFEC, 0x0014, 0x0014, 0x000D, 0x0003, 0x0009,
    0xFFE8, 0x0007, 0x0013, 0x0000, 0xFFD0, 0x0030, 0xFFDA, 0xFFC3,
    0xFFDB, 0xFFE1, 0xFFEF, 0xFFD1, 0xFFF1, 0x0006, 0x0001, 0x002F,
    0xFFDB, 0xFFE9, 0xFFC6, 0x001D, 0x0013, 0xFFEC, 0xFFF7, 0x0007,
    0x0022, 0xFFF6, 0xFFDC, 0x0009, 0xFFF4, 0x0009, 0xFFDD, 0x0008,
    0x0048, 0xFFF4, 0xFFFD, 0xFFE0, 0xFFFB, 0xFFFC, 0xFFF7, 0xFFEF,
    0xFFEE, 0xFFF6, 0xFFD3, 0x0011, 0xFFFB, 0x0020, 0x0016, 0x0019,
    0xFFDE, 0xFFE4, 0x0028, 0xFFF3, 0x0013, 0xFFF8, 0x0012, 0xFFF7,
    0x0001, 0xFFFE, 0xFFFA, 0xFFE7, 0xFFEC, 0x0027, 0xFFF9, 0xFFF4,
    0xFFFD, 0xFFEE, 0x0001, 0x0029, 0x000C, 0x0010, 0xFFE9, 0xFFDA,
    0x000F, 0x000B, 0xFFED, 0xFFD6, 0xFFE4, 0x0021, 0xFFF1, 0x001D,
    0x0010, 0xFFF3, 0x000B, 0xFFE6, 0xFFEF, 0x000D, 0xFFE9, 0xFFEA,
    0xFFED, 0xFFCF, 0x0033, 0x0019, 0xFFFA, 0x002B, 0xFFF3, 0xFFDB,
    0x0023, 0x001A, 0x000D, 0xFFDE, 0x0008, 0xFFE5, 0x0000, 0xFFF3,
    0x0015, 0x0005, 0xFFF4, 0xFFE9, 0xFFFA, 0xFFF6, 0xFFE2, 0xFFEA,
    0xFFFD, 0xFFDE, 0xFFDE, 0xFFF2, 0xFFD2, 0x001C, 0xFFFA, 0x0006,
    0xFFDE, 0xFFFE, 0xFFFC, 0x0001, 0xFFFA, 0xFFF1, 0xFFDD, 0xFFED,
    0x0010, 0x0018, 0xFFF8, 0xFFF6, 0x0006, 0x001D, 0xFFE0, 0x001D,
    0x002D, 0x0000, 0xFFED, 0xFFEC, 0xFFF4, 0x002B, 0xFFCA, 0xFFEC,
    0x000B, 0xFFED, 0xFFDC, 0xFFF0, 0x000D, 0x000E, 0xFFD7, 0xFFE9,
    0x0027, 0x0009, 0x0007, 0xFFE1, 0x0001, 0x000B, 0x0002, 0xFFFD,
    0x0023, 0xFFF8, 0xFFCE, 0x000B, 0xFFF7, 0x0025, 0x0001, 0x000B,
    0x0016, 0x0018, 0x0018, 0xFFEA, 0x0003, 0xFFF3, 0xFFE5, 0x0024,
    0xFFD5, 0x0025, 0x000F, 0xFFF6, 0xFFED, 0xFFF9, 0xFFF4, 0xFFFF,
    0xFFF6, 0xFFF7, 0xFFF2, 0x0007, 0xFFEC, 0x0004, 0x0014, 0x001B,
    0x0007, 0x0010, 0x0007, 0xFFCE, 0x0003, 0xFFF0, 0xFFF7, 0x0000,
    0x0011, 0x000D, 0x0016, 0x0018, 0xFFF4, 0x0009, 0x000C, 0xFFF3,
    0x0010, 0xFFF4, 0x000C, 0x0017, 0x002A, 0x000A, 0x0010, 0x0006,
    0x0009, 0x0007, 0x000E, 0x0007, 0x0007, 0x002D, 0xFFF3, 0x0007,
    0xFFEE, 0x0016, 0xFFEE, 0xFFFD, 0xFFF7, 0x0011, 0x0038, 0xFFE7,
    0xFFF0, 0xFFDF, 0x0064, 0xFFEF, 0x0002, 0x0008, 0x0007, 0x001A,
    0x000A, 0xFFF8, 0xFFF9, 0x0034, 0xFFFC, 0xFFEE, 0x001B, 0x0005,
    0x0029, 0x0022, 0xFFF8, 0xFFDF, 0xFFF8, 0x0029, 0x0016, 0xFFF0,
    0xFFE9, 0xFFF9, 0xFFF6, 0x0017, 0x0012, 0x0019, 0xFFF8, 0xFFFB,
    0xFFE6, 0xFFF3, 0x0016, 0xFFF8, 0x0012, 0xFFEE, 0x0025, 0x0006,
    0xFFF7, 0x002A, 0xFFF4, 0xFFFE, 0x001F, 0x0013, 0xFFCA, 0xFFFB,
    0x0010, 0xFFE6, 0xFFE7, 0x000A, 0x0008, 0xFFFF, 0xFFE4, 0xFFEC,
    0xFFE0, 0xFFF1, 0xFFFE, 0x002F, 0xFFE2, 0xFFE9, 0x0012, 0xFFFE,
    0xFFFE, 0xFFD8, 0xFFED, 0x003E, 0xFFFB, 0xFFF6, 0xFFCD, 0x0001,
    0x000E, 0x0009, 0xFFF5, 0xFFDB, 0x0014, 0x000E, 0xFFE6, 0xFFEB,
    0x000B, 0x0005, 0x0010, 0xFFFD, 0xFFE2, 0x000C, 0xFFCD, 0x001D,
    0x000A, 0x001D, 0xFFF9, 0xFFFD, 0x001D, 0xFFE8, 0x001D, 0xFFE9,
    0x0019, 0x002C, 0x0003, 0xFFE3, 0x0003, 0x0018, 0x0024, 0xFFFE,
    0xFFFA, 0x0009, 0x000E, 0x001C, 0x0011, 0xFFF7, 0xFFD6, 0xFFE4,
    0xFFF4, 0x0014, 0xFFEC, 0xFFE1, 0x0017, 0x0008, 0xFFF5, 0x0007,
    0x0036, 0x000F, 0x000E, 0xFFCC, 0xFFEE, 0x0002, 0x0004, 0x0007,
    0x0012, 0xFFF0, 0xFFED, 0x000E, 0xFFEB, 0x0009, 0x003C, 0xFFD4,
    0x0018, 0xFFEF, 0xFFFB, 0x0017, 0x0021, 0x0021, 0x0006, 0x0017,
    0xFFFD, 0xFFCC, 0x0021, 0x0018, 0xFFFF, 0xFFFD, 0x0007, 0xFFEA,
    0x0004, 0xFFF5, 0xFFC5, 0xFFF3, 0xFFE2, 0x003B, 0x000D, 0xFFEB,
    0x0003, 0xFFF4, 0xFFE5, 0x002C, 0xFFE8, 0xFFF6, 0xFFF4, 0xFFF1,
    0xFFD9, 0xFFFE, 0xFFFA, 0xFFF0, 0x0015, 0x0044, 0x0000, 0xFFD7,
    0x000D, 0xFFF6, 0x0025, 0xFFF1, 0x001B, 0xFFD7, 0x0027, 0xFFED,
    0xFFF9, 0x0027, 0x000E, 0x000C, 0x0002, 0x0001, 0xFFDA, 0xFFE9,
    0x0002, 0xFFE2, 0xFFDF, 0x0008, 0x0001, 0x0024, 0x0037, 0x0006,
    0x0018, 0xFFFF, 0xFFEF, 0xFFE3, 0x0001, 0x001C, 0x001B, 0x0021,
    0x000B, 0x0019, 0x000A, 0x0026, 0xFFDD, 0x0004, 0xFFD6, 0x0023,
    0xFFEC, 0xFFF2, 0x0035, 0x0007, 0x0001, 0xFFEA, 0xFFE4, 0x0014,
    0x001E, 0x0023, 0xFFD7, 0x0004, 0xFFE4, 0xFFEF, 0xFFEC, 0xFFF1,
    0x002F, 0xFFF2, 0xFFF4, 0xFFE8, 0x0003, 0x000C, 0xFFE2, 0xFFED,
    0x0003, 0xFFE4, 0xFFF2, 0x0017, 0xFFDA, 0x002F, 0xFFFC, 0x001A,
    0x0003, 0xFFBD, 0x000D, 0xFFE0, 0xFFF0, 0x0007, 0xFFF0, 0x0033,
    0xFFEF, 0x000E, 0xFFDD, 0xFFFA, 0x000A, 0x0008, 0xFFE8, 0xFFEA,
    0x0003, 0x0004, 0x001C, 0x0018, 0xFFF3, 0x000C, 0xFFE2, 0x002F,
    0x0000, 0x0006, 0xFFC7, 0x0029, 0xFFCD, 0x0002, 0x0016, 0x0038,
    0xFFFB, 0x0016, 0x0004, 0xFFF7, 0xFFFB, 0xFFD7, 0xFFD4, 0xFFE1,
    0x0005, 0x0029, 0xFFF6, 0x0000, 0xFFFB, 0xFFE4, 0xFFFB, 0xFFFB,
    0xFFE7, 0xFFF5, 0x0019, 0x001B, 0xFFE0, 0xFFFB, 0x0017, 0xFFEF,
    0x0004, 0x0013, 0x0008, 0xFFF9, 0x0039, 0xFFDB, 0x002C, 0x0004,
    0x0021, 0x0031, 0x000F, 0x0028, 0xFFFB, 0x003C, 0xFFF9, 0x000A,
    0xFFEB, 0xFFD9, 0x0007, 0xFFFB, 0x0005, 0x000D, 0x0017, 0x000C,
    0x0013, 0xFFFF, 0xFFE3, 0xFFEF, 0xFFE8, 0xFFEE, 0xFFE0, 0x0020,
    0x0007, 0xFFFD, 0xFFF5, 0xFFFE, 0xFFB5, 0x0005, 0x001E, 0x001E,
    0xFFEE, 0xFFEE, 0xFFFB, 0xFFED, 0xFFFA, 0x000A, 0xFFFE, 0x0003,
    0xFFEF, 0xFFD1, 0xFFE4, 0xFFF0, 0x001B, 0x0009, 0x001A, 0x0020,
    0xFFEE, 0x0013, 0x0024, 0x000D, 0x0030, 0xFFDD, 0x0012, 0xFFF9,
    0x0038, 0x0009, 0x000E, 0xFFEA, 0xFFDF, 0x0011, 0xFFF9, 0xFFF3,
    0x000A, 0x0013, 0xFFFF, 0xFFE5, 0x0011, 0xFFDD, 0xFFEE, 0x0029,
    0xFFE6, 0x0001, 0xFFF5, 0xFFF0, 0xFFF2, 0xFFF9, 0xFFD6, 0xFFE1,
    0xFFDC, 0x0028, 0xFFED, 0xFFFB, 0x0007, 0xFFFE, 0x000B, 0x0007,
    0xFFF2, 0xFFF9, 0x0001, 0xFFC8, 0xFFE3, 0x0003, 0xFFEA, 0xFFFF,
    0xFFF3, 0xFFED, 0x0006, 0x0023, 0xFFF2, 0x0008, 0xFFF1, 0xFFFC,
    0xFFFA, 0xFFEF, 0x0016, 0xFFF7, 0x0015, 0x0016, 0xFFF7, 0x0017,
    0x001F, 0xFFED, 0xFFFE, 0x0009, 0xFFF9, 0x001F, 0x0004, 0xFFFB,
    0x0005, 0xFFF4, 0x0020, 0x0003, 0xFFF4, 0x000D, 0xFFCE, 0x0017,
    0x0011, 0xFFFD, 0x0009, 0xFFF8, 0xFFE0, 0x001A, 0xFFEF, 0x000B,
    0xFFE0, 0x0018, 0x0017, 0x0011, 0x0008, 0x000F, 0xFFF6, 0xFFFC,
    0x0011, 0xFFEC, 0x0007, 0x000D, 0x0003, 0x0008, 0x000E, 0x0033,
    0xFFFB, 0x001C, 0x0009, 0x001A, 0xFFD4, 0xFFEF, 0xFFE8, 0x0019,
    0xFFF4, 0xFFDA, 0x0019, 0xFFED, 0x003A, 0xFFF0, 0xFFF2, 0x0007,
    0xFFF1, 0xFFF0, 0xFFFF, 0xFFDB, 0x0015, 0xFFEB, 0x0019, 0x0006,
    0xFFFC, 0x0014, 0x000B, 0xFFE4, 0xFFDF, 0xFFF6, 0x0016, 0x0002,
    0xFFFF, 0xFFE1, 0x0008, 0xFFF7, 0xFFF2, 0xFFE5, 0xFFFB, 0xFFFE,
    0x0032, 0xFFF2, 0xFFF0, 0x0022, 0x000E, 0xFFBF, 0xFFF9, 0xFFF9,
    0xFFDC, 0x000D, 0x000E, 0xFFEB, 0xFFFA, 0xFFD9, 0xFFE6, 0x0001,
    0xFFFD, 0xFFDD, 0x0026, 0xFFF4, 0x0018, 0x0004, 0xFFFF, 0x0006,
    0x0003, 0x0016, 0x0018, 0x0003, 0x0023, 0xFFDD, 0x0025, 0x000F,
    0xFFFE, 0x0009, 0x000A, 0x000F, 0x000A, 0x001C, 0xFFF6, 0x0011,
    0x0013, 0x000E, 0xFFF3, 0x0013, 0xFFF2, 0xFFE8, 0x0015, 0x000A,
    0x0021, 0xFFE2, 0xFFBC, 0x0022, 0xFFF3, 0xFFDC, 0xFFF2, 0xFFF6,
    0x0022, 0xFFEC, 0xFFD6, 0xFFDB, 0x0006, 0x0001, 0xFFE8, 0x0014,
    0xFFDD, 0xFFE9, 0xFFFE, 0x000D, 0xFFF4, 0xFFFB, 0x001F, 0x0010,
    0x0005, 0x002E, 0xFFF3, 0xFFEA, 0xFFE2, 0xFFF9, 0xFFE3, 0x0020,
    0x002C, 0xFFF3, 0xFFF0, 0xFFC8, 0x0017, 0xFFE5, 0xFFFA, 0xFFDF,
    0xFFE9, 0x0000, 0xFFEC, 0xFFF8, 0x001C, 0xFFF0, 0x0004, 0x000A,
    0x000C, 0xFFEF, 0x0002, 0xFFE9, 0x000F, 0x0022, 0x0000, 0xFFF3,
    0x0012, 0x0012, 0x0022, 0xFFF0, 0x0006, 0xFFE0, 0xFFE6, 0xFFEF,
    0x0010, 0x0024, 0xFFEC, 0x0001, 0x0007, 0xFFFE, 0x0017, 0xFFE1,
    0xFFE5, 0xFFFC, 0x000D, 0xFFEA, 0x000E, 0xFFD5, 0x0014, 0xFFEC,
    0x000A, 0xFFFE, 0xFFE6, 0xFFF6, 0xFFFC, 0x0008, 0xFFFC, 0xFFEA,
    0xFFE6, 0x000D, 0xFFE1, 0xFFD4, 0x0002, 0xFFE4, 0xFFFF, 0xFFE8,
    0xFFF3, 0xFFDE, 0x000E, 0x0010, 0xFFF0, 0xFFFC, 0xFFFB, 0xFFC7,
    0xFFDF, 0x000D, 0x000C, 0x002B, 0x000B, 0x000A, 0xFFE3, 0x0012,
    0xFFD9, 0x0009, 0xFFEB, 0x002C, 0xFFFC, 0x0006, 0xFFEB, 0xFFF3,
    0x0016, 0xFFF5, 0xFFEB, 0x0006, 0xFFF0, 0x0022, 0x000E, 0xFFE6,
    0xFFFC, 0xFFF9, 0x0002, 0x0020, 0xFFF2, 0xFFBB, 0x0014, 0xFFD6,
    0x0005, 0x0029, 0x001E, 0xFFF4, 0xFFF3, 0x0021, 0x0020, 0x0023,
    0x0005, 0xFFEE, 0xFFEF, 0x0015, 0x001A, 0xFFEE, 0xFFFC, 0xFFF9,
    0xFFEF, 0xFFFF, 0x0014, 0x0008, 0x0022, 0x000E, 0xFFF4, 0xFFE6,
    0xFFED, 0xFFF1, 0x0013, 0x000F, 0xFFFF, 0xFFEC, 0x002B, 0xFFF7,
    0xFFFA, 0x0007, 0xFFEB, 0xFFCE, 0xFFD7, 0xFFF7, 0x000F, 0x002F,
    0xFFD8, 0x0001, 0x0009, 0x0000, 0xFFED, 0xFFFB, 0x000C, 0x002E,
    0x002B, 0xFFDF, 0xFFF9, 0xFFF8, 0xFFE2, 0x0004, 0x0009, 0xFFE6,
    0xFFB8, 0xFFC8, 0xFFDF, 0xFFDE, 0x000A, 0x000A, 0xFFEE, 0xFFCC,
    0x0001, 0x0001, 0x0005, 0xFFEA, 0x0011, 0x001B, 0x0002, 0xFFEC,
    0xFFE9, 0x0000, 0x0002, 0x0014, 0x0011, 0xFFE5, 0x0005, 0x0016,
    0x0001, 0xFFFF, 0xFFEE, 0x0034, 0x000A, 0xFFF6, 0xFFDF, 0x0022,
    0xFFB8, 0x0038, 0x0009, 0x001A, 0xFFE2, 0xFFFC, 0xFFF9, 0x0008,
    0x002B, 0x0021, 0x000C, 0xFFD2, 0xFFED, 0x0005, 0x0009, 0x0000,
    0xFFD8, 0xFFFF, 0x000F, 0xFFD1, 0xFFD7, 0x0009, 0xFFEB, 0x0032,
    0xFFFA, 0xFFF9, 0x002B, 0x0009, 0xFFFF, 0x0014, 0x0013, 0xFFF1,
    0xFFED, 0x000F, 0xFFF4, 0x001A, 0x0022, 0xFFF2, 0x0014, 0xFFF8,
    0xFFEF, 0x0001, 0xFFFC, 0x0007, 0x001A, 0x0012, 0xFFEF, 0xFFEB,
    0x0005, 0x0012, 0x0020, 0xFFDD, 0xFFF3, 0xFFDF, 0x001E, 0x000C,
    0x0005, 0xFFD7, 0x0014, 0x002A, 0xFFF2, 0x0045, 0x0002, 0xFFE0,
    0xFFFC, 0x0007, 0x000E, 0x001A, 0xFFF0, 0xFFDE, 0xFFEB, 0xFFFA,
    0x0016, 0x000B, 0xFFEB, 0x000D, 0xFFFC, 0xFFFA, 0xFFEB, 0xFFD4,
    0xFFD9, 0xFFF7, 0xFFE3, 0xFFEE, 0x000B, 0xFFF6, 0x000C, 0xFFD5,
    0xFFDF, 0xFFF3, 0xFFFB, 0x0039, 0xFFF0, 0x0004, 0x000E, 0xFFF0,
    0xFFF3, 0x0022, 0xFFFF, 0x0018, 0x0002, 0x001C, 0xFFE1, 0x002C,
    0xFFE6, 0xFFF3, 0xFFFC, 0x0016, 0xFFFC, 0xFFF8, 0xFFE6, 0x000A,
    0x000A, 0x0002, 0x0014, 0x0014, 0x000E, 0x002B, 0x000D, 0x0016,
    0xFFE5, 0x0004, 0x0017, 0x001F, 0x0007, 0x0002, 0xFFEC, 0xFFFF,
    0x0010, 0xFFDC, 0xFFE6, 0x0011, 0x0006, 0x0020, 0x0022, 0x0010,
    0x0012, 0xFFEE, 0x0000, 0x000D, 0x000F, 0xFFDE, 0x0002, 0x0017,
    0x000C, 0x0011, 0x0004, 0xFFF6, 0x001C, 0x0010, 0xFFEC, 0x0008,
    0xFFE9, 0x0000, 0xFFFA, 0x0021, 0x0017, 0x001B, 0xFFF0, 0x0038,
    0x002C, 0x000D, 0xFFE3, 0xFFE0, 0xFFE2, 0x0007, 0xFFF3, 0x0016,
    0x0005, 0xFFD2, 0x001F, 0xFFF0, 0xFFF4, 0x0005, 0xFFFE, 0xFFF3,
    0xFFDD, 0x0017, 0xFFE8, 0xFFEC, 0x0006, 0xFFFF, 0xFFD6, 0x0025,
    0x0022, 0x0014, 0xFFF2, 0x000A, 0xFFF3, 0x0024, 0xFFBC, 0xFFDE,
    0x0021, 0x001E, 0x0015, 0xFFF6, 0xFFF2, 0x0018, 0xFFF3, 0xFFED,
    0x0013, 0xFFF2, 0xFFF6, 0xFFEF, 0x000A, 0xFFE4, 0x000A, 0xFFF1,
    0xFFFE, 0xFFF7, 0x0025, 0xFFF1, 0x0023, 0x0023, 0x0018, 0xFFFD,
    0x0003, 0xFFEA, 0xFFFF, 0xFFFA, 0x0018, 0xFFFC, 0x0026, 0x000C,
    0xFFFD, 0x0023, 0xFFE6, 0xFFFF, 0xFFFA, 0x0027, 0x000E, 0x0015,
    0xFFDC, 0xFFF3, 0xFFF9, 0x0007, 0x000E, 0x0041, 0xFFF0, 0xFFDE,
    0x0032, 0x000E, 0xFFFB, 0x0002, 0xFFF2, 0x001B, 0x0008, 0x0009,
    0xFFFF, 0x001F, 0x0016, 0xFFFE, 0xFFDF, 0x000A, 0x000B, 0x001C,
    0xFFFC, 0xFFEC, 0x0019, 0xFFFA, 0x0015, 0x0015, 0xFFFF, 0x0025,
    0xFFF1, 0x0010, 0xFFF2, 0xFFF9, 0x003A, 0x0010, 0x0019, 0x0013,
    0xFFF4, 0x0026, 0xFFE8, 0xFFE7, 0xFFD4, 0x0011, 0x0009, 0xFFE6,
    0xFFFB, 0xFFE4, 0x000E, 0xFFCD, 0x0003, 0xFFF8, 0x0007, 0xFFF3,
    0x0011, 0x0014, 0xFFF6, 0x0004, 0x0008, 0xFFF1, 0x0017, 0xFFEF,
    0xFFE0, 0xFFE8, 0xFFEF, 0xFFF5, 0xFFE0, 0xFFE6, 0x0009, 0x0008,
    0x0011, 0x0003, 0xFFCE, 0xFFE9, 0xFFF4, 0xFFF3, 0x0020, 0xFFFD,
    0x0005, 0x000C, 0x0004, 0x0005, 0xFFF9, 0xFFE1, 0xFFFE, 0xFFF7,
    0x001F, 0x0013, 0xFFF7, 0xFFE9, 0x0015, 0xFFEA, 0x0016, 0x0009,
    0xFFFA, 0x0011, 0xFFF1, 0x0004, 0xFFF2, 0xFFF8, 0x0006, 0xFFDD,
    0xFFF3, 0x0013, 0xFFEA, 0x0001, 0xFFE3, 0xFFFD, 0x0001, 0x0038,
    0xFFF2, 0x0007, 0x000B, 0xFFF9, 0x0007, 0x0002, 0xFFED, 0x0005,
    0xFFDC, 0xFFD8, 0xFFD6, 0x001F, 0xFFF2, 0x0007, 0xFFF5, 0x0010,
    0xFFE6, 0xFFFF, 0xFFEE, 0xFFD7, 0x0011, 0x0023, 0xFFFF, 0x001B,
    0x000A, 0xFFED, 0xFFF9, 0x000D, 0xFFDF, 0xFFEF, 0x000E, 0x0016,
    0x0038, 0xFFF7, 0x0012, 0x0007, 0x0030, 0x0023, 0x0024, 0xFFF3,
    0xFFEE, 0xFFED, 0x001A, 0xFFE0, 0x001B, 0xFFF7, 0xFFE4, 0x0010,
    0xFFEF, 0x002F, 0xFFFE, 0xFFFD, 0xFFFA, 0xFFF6, 0xFFFB, 0x0013,
    0xFFEE, 0x0012, 0x001E, 0xFFE2, 0xFFB5, 0xFFFB, 0xFFF5, 0x0002,
    0x0007, 0x0003, 0xFFE0, 0xFFE0, 0xFFE8, 0x0012, 0xFFE3, 0x0011,
    0x0013, 0x0001, 0x0017, 0xFFF4, 0x0005, 0xFFF3, 0x0007, 0x0005,
    0xFFEB, 0x0027, 0xFFF9, 0xFFF6, 0xFFFB, 0xFFC4, 0x000F, 0xFFD8,
    0x0021, 0xFFCF, 0x002C, 0xFFFC, 0x0039, 0x0025, 0x0008, 0x0007,
    0x0004, 0xFFED, 0x0017, 0x0011, 0xFFE0, 0x0005, 0x0019, 0xFFE5,
    0xFFE7, 0x000B, 0xFFFB, 0x0005, 0xFFFB, 0x001C, 0xFFF6, 0x0000,
    0x0005, 0xFFD7, 0xFFD4, 0x001F, 0xFFFB, 0x0029, 0x0004, 0x0009,
    0xFFFB, 0xFFEA, 0x0016, 0xFFC8, 0xFFCD, 0xFFFE, 0xFFC7, 0xFFD7,
    0x0000, 0xFFFA, 0xFFE2, 0xFFD1, 0xFFF3, 0xFFF4, 0x001C, 0xFFE8,
    0x0003, 0xFFFC, 0xFFE8, 0x0016, 0x000A, 0xFFF8, 0xFFDD, 0x0006,
    0xFFEF, 0xFFF2, 0xFFF0, 0xFFCD, 0xFFF0, 0xFFF9, 0x000D, 0x0020,
    0x0003, 0x0043, 0xFFFC, 0xFFE6, 0xFFDA, 0xFFD1, 0xFFF2, 0xFFE9,
    0x0003, 0x001C, 0xFFE2, 0x0013, 0x0003, 0xFFF4, 0xFFF4, 0x0018,
    0x002F, 0x000E, 0xFFEC, 0x000F, 0xFFE4, 0x0011, 0xFFD7, 0xFFFC,
    0x001E, 0xFFDD, 0xFFE4, 0xFFEC, 0x0001, 0x0016, 0x0035, 0xFFF9,
    0xFFEC, 0x000E, 0xFFD6, 0xFFDD, 0xFFDD, 0xFFFC, 0x000A, 0xFFDA,
    0x000B, 0xFFE7, 0x001B, 0xFFDF, 0x0001, 0xFFE4, 0xFFEF, 0x001D,
    0x0018, 0x0001, 0x0037, 0xFFFA, 0x0001, 0xFFDC, 0xFFDF, 0xFFF8,
    0x0002, 0x001E, 0xFFDA, 0x0017, 0x0002, 0xFFFF, 0x000E, 0xFFF4,
    0xFFF9, 0xFFD9, 0x0027, 0x0013, 0x001B, 0x0029, 0x0025, 0x000F,
    0x000D, 0x000A, 0x0000, 0x0029, 0x0015, 0xFFBC, 0xFFFA, 0x0010,
    0xFFD9, 0x0002, 0xFFF4, 0x000F, 0xFFE8, 0x000A, 0xFFE5, 0xFFD4,
    0x0003, 0x000C, 0x000D, 0x0015, 0xFFE2, 0xFFC5, 0xFFC5, 0x000D,
    0x0004, 0x000B, 0x0007, 0x0016, 0xFFFF, 0x0003, 0x0021, 0xFFE8,
    0xFFFD, 0x0034, 0x0006, 0xFFE9, 0x0021, 0xFFDF, 0xFFFB, 0xFFE9,
    0x0018, 0x0011, 0x003C, 0x002C, 0xFFEB, 0xFFF7, 0xFFED, 0xFFF2,
    0x0012, 0x0010, 0x0004, 0xFFF9, 0xFFEE, 0xFFFE, 0x000E, 0x0034,
    0x0036, 0xFFF1, 0xFFF5, 0xFFF9, 0x0017, 0xFFF8, 0xFFEC, 0x001F,
    0xFFF4, 0xFFEC, 0xFFD6, 0x001C, 0x0011, 0x0009, 0x000E, 0xFFE4,
    0xFFFA, 0xFFF7, 0x0024, 0x0002, 0x0003, 0xFFE8, 0x0003, 0x001D,
    0x0019, 0xFFD4, 0x001D, 0x0017, 0x001D, 0x0018, 0xFFF9, 0x0003,
    0x000A, 0xFFE3, 0xFFCD, 0xFFE3, 0xFFE2, 0xFFF4, 0x0010, 0x0003,
    0x000B, 0xFFFB, 0xFFE6, 0x0015, 0x0014, 0xFFF2, 0xFFF5, 0x0025,
    0x000E, 0xFFF7, 0xFFCD, 0xFFFF, 0xFFFB, 0x000A, 0xFFED, 0xFFC2,
    0xFFFE, 0x0028, 0x0012, 0x0002, 0xFFE2, 0x0017, 0xFFFE, 0xFFD1,
    0xFFE0, 0x000F, 0xFFE4, 0x0014, 0x0008, 0x0001, 0xFFE7, 0xFFF6,
    0x0010, 0x001A, 0xFFCA, 0x0005, 0x001F, 0xFFED, 0xFFF4, 0x0002,
    0xFFF7, 0xFFD6, 0x0025, 0xFFFA, 0x0012, 0x0012, 0x0016, 0x0008,
    0xFFE6, 0x000D, 0xFFF8, 0x0005, 0x0012, 0xFFE7, 0xFFF6, 0xFFE9,
    0xFFE9, 0x0007, 0x0016, 0x0010, 0xFFF8, 0xFFD7, 0xFFF8, 0x0021,
    0x0029, 0xFFDE, 0x001B, 0xFFFB, 0xFFFC, 0x0012, 0xFFF9, 0xFFCC,
    0x000A, 0x0008, 0x0007, 0xFFE6, 0x0002, 0xFFF8, 0x0064, 0x0011,
    0xFFF0, 0x0021, 0x0038, 0x0019, 0xFFF7, 0xFFEF, 0xFFEE, 0x0003,
    0xFFEE, 0xFFEA, 0xFFF3, 0xFFF9, 0x0007, 0xFFD3, 0x000E, 0xFFF9,
    0x0009, 0xFFF9, 0x0010, 0xFFFA, 0x002A, 0xFFF6, 0x000C, 0xFFE9,
    0x0010, 0x000C, 0x000C, 0x000D, 0xFFF4, 0xFFF7, 0x0016, 0xFFE8,
    0x0011, 0xFFF3, 0xFFF7, 0x0000, 0x0003, 0x0010, 0x0007, 0x0032,
    0x0007, 0xFFF0, 0x0014, 0xFFE5, 0xFFEC, 0xFFFC, 0xFFF2, 0xFFF9,
    0xFFF6, 0x0009, 0xFFF4, 0x0001, 0xFFED, 0x0007, 0x000F, 0x000A,
    0xFFD5, 0xFFDB, 0xFFE5, 0xFFDC, 0x0003, 0x000D, 0x0018, 0x0016,
    0x0016, 0xFFE8, 0x0001, 0xFFF5, 0xFFF7, 0xFFDB, 0xFFCE, 0xFFF5,
    0x0023, 0x0008, 0x0002, 0x0003, 0x0001, 0xFFF5, 0x0007, 0x001F,
    0x0027, 0xFFF7, 0xFFD7, 0x0017, 0x000D, 0xFFF2, 0xFFDC, 0x0010,
    0x000B, 0x0013, 0xFFCA, 0x0014, 0xFFF4, 0xFFD5, 0xFFED, 0x0014,
    0x002D, 0x0000, 0xFFE0, 0xFFE3, 0x0006, 0xFFE3, 0xFFF8, 0x000A,
    0x0010, 0xFFE8, 0xFFDD, 0x0013, 0xFFFA, 0x000F, 0xFFFC, 0xFFFF,
    0xFFDE, 0x0002, 0xFFFA, 0xFFFA, 0xFFD2, 0xFFE4, 0xFFDE, 0x000E,
    0xFFFD, 0x0022, 0xFFE2, 0x0016, 0xFFFA, 0x000A, 0xFFF4, 0x0017,
    0x0015, 0xFFFB, 0x0000, 0x000D, 0x0008, 0x001B, 0x000D, 0x0022,
    0x0023, 0xFFE6, 0xFFF3, 0x0025, 0xFFFA, 0xFFD5, 0x0033, 0xFFE7,
    0xFFED, 0x0031, 0xFFE9, 0x0016, 0xFFEF, 0xFFF3, 0x000B, 0x001A,
    0x0010, 0x000D, 0xFFF1, 0xFFE3, 0xFFE4, 0xFFDF, 0xFFED, 0x002A,
    0x000F, 0xFFF5, 0xFFE9, 0x0026, 0x000C, 0xFFF0, 0x0001, 0xFFD7,
    0xFFFD, 0x0012, 0xFFF9, 0x000C, 0xFFEC, 0xFFD9, 0xFFFA, 0x0019,
    0x0001, 0x0002, 0x0012, 0x0009, 0x0013, 0x0008, 0x0028, 0x000D,
    0xFFDE, 0x001C, 0x0016, 0xFFE7, 0xFFFB, 0xFFE0, 0xFFD3, 0xFFEF,
    0xFFEE, 0x000A, 0xFFF7, 0x0011, 0xFFFB, 0x0004, 0xFFFD, 0x0020,
    0x0048, 0x000C, 0xFFDD, 0xFFF8, 0xFFF4, 0xFFF7, 0xFFDC, 0xFFF7,
    0x0022, 0x000A, 0xFFF7, 0xFFF9, 0x0013, 0x0014, 0xFFC6, 0xFFE3,
    0xFFDB, 0x0017, 0x0001, 0xFFD1, 0xFFF1, 0xFFFA, 0xFFEF, 0x002F,
    0xFFDB, 0x001F, 0xFFDA, 0x003D, 0xFFD0, 0xFFD0, 0x0013, 0x0000,
    0xFFE8, 0xFFF9, 0x0003, 0xFFF7, 0x0014, 0xFFF3, 0xFFEC, 0xFFEC,
    0xFFEB, 0xFFDF, 0xFFD6, 0xFFE4, 0x000C, 0xFFF3, 0x000F, 0x0012,
    0x0006, 0xFFEA, 0x001F, 0x0023, 0xFFF0, 0xFFFD, 0x0022, 0x0022,
    0xFFDF, 0x000C, 0xFFEA, 0x0008, 0x0017, 0xFFE2, 0x0004, 0x0010,
    0x001C, 0x0009, 0x0014, 0xFFEF, 0xFFEE, 0xFFE1, 0xFFE8, 0x0006,
    0x0030, 0x0015, 0xFFD0, 0xFFF4, 0x000D, 0xFF9F, 0xFFED, 0xFFD5,
    0xFFF1, 0x0002, 0x002F, 0xFFF6, 0x0035, 0x0037, 0x0008, 0x000A,
    0x0006, 0x000A, 0xFFEA, 0x0006, 0xFFE0, 0xFFFE, 0x0000, 0xFFE9,
    0xFFFA, 0xFFF0, 0x002E, 0x002D, 0x0014, 0x0000, 0x0010, 0xFFF6,
    0xFFF7, 0x0014, 0xFFF1, 0xFFE4, 0x0008, 0x0018, 0x0000, 0xFFF2,
    0x001A, 0xFFF1, 0xFFEA, 0x0031, 0x0002, 0x0015, 0xFFDD, 0x0006,
    0xFFFF, 0xFFDB, 0x000B, 0xFFDB, 0xFFF5, 0xFFF6, 0xFFEF, 0xFFFB,
    0xFFE1, 0xFFFE, 0xFFC9, 0x0022, 0xFFF0, 0xFFEF, 0x0015, 0xFFF4,
    0x0019, 0xFFF8, 0x0022, 0x0023, 0xFFF9, 0xFFEE, 0x0012, 0xFFED,
    0xFFFB, 0x0008, 0x000D, 0xFFE1, 0xFFF1, 0x0007, 0x0008, 0xFFFD,
    0xFFEA, 0x003F, 0xFFF1, 0x0028, 0xFFDA, 0x004D, 0x0021, 0x001E,
    0x0035, 0xFFF6, 0xFFD3, 0x0014, 0x003F, 0x0001, 0x0003, 0xFFF2,
    0x000E, 0xFFE1, 0x003E, 0xFFE1, 0x0001, 0xFFF8, 0x0012, 0xFFEE,
    0x0005, 0xFFE9, 0x001C, 0x0005, 0xFFE4, 0xFFD9, 0xFFF0, 0xFFF6,
    0x0009, 0x0013, 0x0003, 0xFFFB, 0x005C, 0x000B, 0x0017, 0x001C,
    0xFFE7, 0x0006, 0xFFE8, 0x0030, 0x0014, 0xFFF1, 0x000A, 0xFFEE,
    0xFFE4, 0xFFFF, 0xFFF7, 0xFFE9, 0x003A, 0xFFFE, 0xFFE7, 0xFFFA,
    0xFFDD, 0x0007, 0x0015, 0xFFE6, 0xFFFB, 0xFFE5, 0x0019, 0xFFF7,
    0xFFF6, 0x000B, 0xFFF1, 0xFFED, 0xFFDC, 0xFFF4, 0xFFF9, 0x002B,
    0x0022, 0xFFFE, 0xFFFA, 0xFFFF, 0xFFEB, 0x001A, 0xFFEA, 0x000A,
    0xFFEC, 0xFFE4, 0x0001, 0x002B, 0xFFEF, 0xFFD8, 0x0016, 0xFFFB,
    0x0007, 0xFFFF, 0x0027, 0x0002, 0xFFFD, 0xFFE3, 0xFFF7, 0xFFFD,
    0xFFE2, 0xFFE1, 0x0032, 0xFFFD, 0xFFFA, 0x000E, 0x000B, 0xFFED,
    0xFFE4, 0xFFF3, 0xFFD2, 0x0017, 0x000A, 0x001C, 0x0015, 0x0021,
    0x0012, 0xFFF4, 0x000B, 0x0051, 0x001A, 0x002C, 0x0000, 0xFFE6,
    0x0000, 0xFFFD, 0x001F, 0xFFFC, 0x000A, 0xFFFE, 0x0004, 0xFFEC,
    0x0026, 0x0003, 0x0017, 0x0002, 0xFFF8, 0xFFE1, 0xFFE8, 0xFFF6,
    0xFFEE, 0x0045, 0x0003, 0x0009, 0xFFE9, 0xFFFB, 0x0019, 0x000E,
    0x000C, 0xFFDC, 0x0018, 0xFFFB, 0xFFFF, 0xFFEB, 0x0017, 0x0015,
    0x003F, 0x0006, 0x0011, 0x0017, 0x0023, 0xFFCB, 0xFFCC, 0xFFDF,
    0x0007, 0x0010, 0xFFFB, 0x0011, 0xFFFD, 0x0037, 0xFFF6, 0xFFF5,
    0xFFE3, 0xFFFC, 0x0005, 0xFFE9, 0xFFE6, 0x0019, 0x0010, 0x000A,
    0x0017, 0x001A, 0x0009, 0xFFE5, 0xFFE8, 0xFFF1, 0x001F, 0xFFE8,
    0x0016, 0x000B, 0x0012, 0xFFDB, 0xFFEB, 0x0032, 0xFFF8, 0x0002,
    0x0002, 0xFFF2, 0xFFD3, 0xFFF1, 0xFFE6, 0xFFC9, 0xFFE7, 0xFFE2,
    0xFFE8, 0x0014, 0xFFFF, 0xFFF5, 0x0001, 0x0000, 0x0018, 0x0022,
    0xFFE3, 0xFFDE, 0xFFEB, 0xFFE7, 0x0022, 0xFFF9, 0xFFE1, 0xFFE3,
    0x0004, 0x0004, 0xFFEF, 0x0015, 0x0003, 0x000D, 0x0037, 0x001D,
    0xFFDB, 0xFFF3, 0xFFEF, 0xFFF4, 0xFFC4, 0x0000, 0x0020, 0x000E,
    0xFFF3, 0x0010, 0x000C, 0xFFF8, 0x0007, 0xFFFF, 0xFFE2, 0xFFEC,
    0xFFEF, 0x0000, 0xFFF4, 0x004D, 0x001C, 0x000F, 0xFFEC, 0x0012,
    0x0001, 0x0021, 0xFFEB, 0xFFF4, 0x002D, 0x001A, 0x0026, 0x0004,
    0x001C, 0xFFCC, 0x0009, 0x0024, 0x0008, 0x000E, 0x002E, 0x0016,
    0x0000, 0x001E, 0xFFEB, 0xFFFD, 0x000A, 0x0011, 0xFFE6, 0x000B,
    0xFFF2, 0x0033, 0x0001, 0x003F, 0x0011, 0x000A, 0xFFFD, 0x001D,
    0x0016, 0x0004, 0xFFE8, 0x0009, 0x002B, 0x000E, 0x0013, 0x000F,
    0xFFCD, 0xFFFC, 0xFFE5, 0x0014, 0x002C, 0x0016, 0xFFFC, 0x001B,
    0x0022, 0xFFE1, 0x001C, 0x0012, 0x0005, 0xFFFE, 0xFFEA, 0x0006,
    0x000D, 0xFFE0, 0x0000, 0xFFFD, 0xFFF1, 0xFFDC, 0x000F, 0xFFFF,
    0xFFF7, 0x0001, 0x002D, 0xFFEA, 0xFFEA, 0x000D, 0xFFF6, 0x000A,
    0xFFED, 0xFFED, 0xFFE7, 0x0013, 0xFFFF, 0x0021, 0xFFE5, 0x000F,
    0x0006, 0x0002, 0xFFF6, 0x0002, 0xFFC4, 0xFFEB, 0xFFF3, 0xFFFB,
    0x0019, 0xFFE3, 0x002B, 0xFFF5, 0x0010, 0x0008, 0xFFCC, 0xFFD8,
    0x000D, 0x002E, 0x0003, 0xFFD9, 0x0002, 0xFFF1, 0x0043, 0x0014,
    0xFFE6, 0x0029, 0xFFFB, 0xFFE7, 0xFFE7, 0x0001, 0x0026, 0xFFEC,
    0x0038, 0x003A, 0x0001, 0x000E, 0xFFEE, 0xFFE5, 0x004F, 0xFFF1,
    0x001D, 0x0046, 0x0026, 0xFFE0, 0x0008, 0x001A, 0xFFD7, 0x0001,
    0xFFF7, 0x000C, 0x0010, 0xFFD8, 0x0018, 0xFFEE, 0x000D, 0xFFFC,
    0x000E, 0xFFF6, 0x000A, 0x0000, 0xFFCB, 0x0021, 0xFFD8, 0xFFE9,
    0xFFD0, 0xFFD1, 0xFFF3, 0x0013, 0xFFF8, 0x0008, 0x001B, 0xFFFB,
    0x000C, 0xFFFD, 0x001C, 0xFFF9, 0x002D, 0xFFEE, 0x0016, 0x003B,
    0x0000, 0xFFE2, 0xFFEB, 0x0003, 0xFFEA, 0xFFEC, 0xFFCF, 0x0008,
    0xFFD8, 0x0008, 0x000E, 0xFFD3, 0x0013, 0x0009, 0xFFD9, 0xFFFC,
    0xFFE0, 0x2CC4, 0x001E, 0x000B, 0x0024, 0x0012, 0x0007, 0xFFDE,
    0xFFF9, 0x0016, 0xFFFF, 0xFFF2, 0x000B, 0xFFCA, 0x002B, 0xFFED,
    0xFFF7, 0xFFCF, 0xFFE1, 0x0002, 0xFFE8, 0x0000, 0x0006, 0x0027,
    0xFFFA, 0x0006, 0xFFD4, 0x0017, 0xFFFA, 0x0025, 0xFFD9, 0x0007,
    0xFFEF, 0x0001, 0xFFF6, 0x0017, 0xFFEA, 0x0039, 0xFFF8, 0xFFE8,
    0xFFF8, 0x0019, 0xFFFD, 0x0001, 0x0003, 0xFFDE, 0xFFFB, 0x0018,
    0xFFE4, 0xFFF7, 0x000D, 0xFFF9, 0x0000, 0xFFFD, 0x002E, 0x000F,
    0x0001, 0x0019, 0x0021, 0x0025, 0xFFF4, 0xFFF5, 0x001C, 0x0023,
    0x000D, 0xFFE3, 0x0011, 0xFFE7, 0x0027, 0x0043, 0x001F, 0xFFF3,
    0xFFE2, 0xFFF6, 0x001F, 0xFFF8, 0x0007, 0x0009, 0x0000, 0xFFF1,
    0x0006, 0x0013, 0x001A, 0xFFFD, 0xFFF8, 0xFFEC, 0x0011, 0x0014,
    0x0001, 0xFFF7, 0x000E, 0xFFF7, 0x001D, 0xFFFD, 0x000C, 0xFFF3,
    0xFFF7, 0xFFE8, 0xFFDA, 0xFFE2, 0x001B, 0x0023, 0xFFF6, 0xFFEC,
    0x0031, 0xFFE5, 0x001E, 0x0010, 0xFFD6, 0xFFDB, 0x0002, 0xFFEC,
    0xFFFC, 0xFFF5, 0xFFF7, 0x0002, 0x0016, 0x0009, 0x0006, 0xFFC2,
    0x000F, 0x0002, 0xFFEE, 0x000E, 0x000F, 0xFFFC, 0x001C, 0x0000,
    0xFFC1, 0xFFEF, 0xFFFF, 0x0002, 0x0021, 0x0034, 0x0012, 0x0022,
    0x0019, 0xFFEF, 0xFFE7, 0xFFF7, 0xFFF2, 0x0022, 0x002F, 0x000B,
    0x000C, 0x001D, 0xFFEE, 0xFFF0, 0xFFEE, 0xFFFC, 0x0028, 0x0017,
    0x000A, 0xFFBD, 0xFFF6, 0x001C, 0xFFE4, 0xFFF9, 0x001E, 0x001E,
    0xFFE2, 0xFFFD, 0x000F, 0x001D, 0xFFFE, 0x0011, 0xFFD3, 0x001A,
    0x0000, 0xFFF7, 0x0014, 0x0008, 0xFFFB, 0xFFE1, 0xFFDE, 0xFFF8,
    0xFFF4, 0x0020, 0x0014, 0xFFF3, 0xFFD7, 0xFFF3, 0xFFE5, 0xFFDE,
    0x0009, 0x0005, 0x0004, 0xFFF7, 0x0041, 0x001E, 0xFFE3, 0xFFFF,
    0x0003, 0x0013, 0x0000, 0xFFE8, 0x0026, 0x0008, 0x0006, 0xFFEC,
    0x0004, 0xFFE7, 0xFFF7, 0x0009, 0x0017, 0xFFEF, 0x0002, 0x0006,
    0xFFF6, 0xFFD8, 0x0006, 0xFFF3, 0xFFFC, 0x0006, 0x0029, 0x0014,
    0x0002, 0x0015, 0xFFF0, 0x0000, 0x000E, 0xFFF5, 0xFFF4, 0xFFEF,
    0x0001, 0xFFF8, 0xFFFC, 0xFFFB, 0x0012, 0x0003, 0xFFE7, 0xFFE9,
    0xFFDE, 0x0009, 0x0008, 0x001E, 0xFFE5, 0xFFF0, 0x0027, 0x0001,
    0x0014, 0x0001, 0xFFFC, 0x000B, 0x001B, 0x0000, 0x000E, 0x0010,
    0x0019, 0xFFE9, 0xFFD7, 0xFFFC, 0x000D, 0x0022, 0xFFED, 0x0015,
    0xFFCB, 0x0002, 0x0011, 0xFFFA, 0x0016, 0xFFC3, 0xFFF2, 0xFFE3,
    0xFFD7, 0xFFFC, 0xFFE0, 0xFFEE, 0x0034, 0xFFFE, 0xFFDB, 0xFFE1,
    0xFFDC, 0x0011, 0x0004, 0x000E, 0xFFF5, 0x0037, 0xFFFD, 0x000C,
    0xFFEC, 0xFFEB, 0xFFF3, 0x0028, 0x000E, 0x001B, 0x0003, 0x0013,
    0xFFD6, 0xFFF1, 0xFFD9, 0x0004, 0x001E, 0xFFE5, 0xFFF8, 0xFFF0,
    0xFFF0, 0x0013, 0xFFC3, 0x002A, 0xFFEA, 0xFFEF, 0x000C, 0xFFEC,
    0xFFFB, 0x0019, 0xFFE0, 0xFFF0, 0xFFD5, 0x000A, 0xFFE2, 0x0003,
    0x0005, 0x0002, 0x0002, 0xFFE6, 0x000C, 0x0016, 0x0007, 0xFFF3,
    0xFFCA, 0x0031, 0xFFF9, 0xFFFB, 0xFFFC, 0x0016, 0xFFE4, 0xFFFB,
    0xFFFF, 0x000A, 0xFFD6, 0xFFF4, 0x0034, 0x002B, 0x0029, 0x0009,
    0xFFF4, 0xFFE7, 0xFFFF, 0xFFFE, 0xFFFE, 0xFFEA, 0xFFEC, 0x0004,
    0xFFF8, 0xFFEC, 0xFFB9, 0x001F, 0xFFEE, 0x0014, 0xFFFD, 0xFFFF,
    0x0011, 0x0006, 0xFFF2, 0xFFEF, 0x0009, 0xFFF2, 0xFFF1, 0x0025,
    0xFFF2, 0x0001, 0x0010, 0xFFE1, 0x0007, 0xFFE3, 0xFFF9, 0xFFF5,
    0x0024, 0x0000, 0x0002, 0x001D, 0x0001, 0xFFD3, 0x001C, 0x0000,
    0xFFF2, 0xFFE6, 0x001D, 0x000F, 0x0010, 0xFFE9, 0x000F, 0x0004,
    0xFFF5, 0x001D, 0xFFEA, 0x0007, 0xFFF2, 0xFFE6, 0x002C, 0x0007,
    0x0011, 0x0013, 0x001E, 0x0011, 0xFFED, 0x000F, 0x0016, 0xFFED,
    0xFFE3, 0xFFE8, 0xFFE3, 0x0011, 0xFFFF, 0xFFE8, 0x0001, 0x000B,
    0x000C, 0x0004, 0xFFF8, 0xFFFF, 0x0004, 0xFFE6, 0x000F, 0xFFFF,
    0xFFE1, 0xFFF4, 0xFFF2, 0xFFFA, 0x0010, 0xFFC8, 0xFFFF, 0x001B,
    0xFFF6, 0xFFF2, 0x0013, 0x000C, 0x0005, 0x0017, 0xFFDE, 0xFFF2,
    0x0026, 0x000B, 0x0000, 0xFFF9, 0x001B, 0xFFFB, 0x0002, 0xFFD8,
    0x0007, 0xFFF3, 0xFFF9, 0xFFF4, 0xFFDB, 0x0016, 0x0018, 0x0025,
    0x000C, 0x0015, 0x000E, 0x000D, 0x0001, 0xFFF3, 0x000F, 0xFFE2,
    0x0002, 0x001C, 0xFFFB, 0x0001, 0x001D, 0xFFEE, 0x000A, 0x0005,
    0xFFD4, 0x0016, 0x0016, 0xFFEC, 0xFFD8, 0x0009, 0x0025, 0xFFD9,
    0xFFE0, 0x0026, 0x000C, 0xFFEB, 0xFFFD, 0x002C, 0xFFE7, 0x0017,
    0xFFFF, 0xFFC8, 0x0005, 0x001C, 0x0001, 0x0016, 0xFFF6, 0xFFEE,
    0xFFF2, 0xFFFF, 0x0014, 0xFFCD, 0x002C, 0x003E, 0x001B, 0xFFF8,
    0x000B, 0xFFF0, 0xFFDC, 0x000C, 0x000D, 0xFFFB, 0xFFCC, 0xFFF4,
    0xFFFA, 0xFFD8, 0xFFF4, 0x000C, 0xFFF0, 0xFFF5, 0x0004, 0xFFFF
    };

static const q15_t in_cfft_noisy_4096[8192] = {
    0xFBA6, 0x0000, 0x4358, 0x0000, 0x58DE, 0x0000, 0x399E, 0x0000,
    0x0358, 0x0000, 0xBACE, 0x0000, 0xA512, 0x0000, 0xB4CB, 0x0000,
    0xF3AC, 0x0000, 0x3E8D, 0x0000, 0x597B, 0x0000, 0x3EF1, 0x0000,
    0x0175, 0x0000, 0xBEDA, 0x0000, 0xB5BA, 0x0000, 0xB3E9, 0x0000,
    0x012E, 0x0000, 0x44A0, 0x0000, 0x5715, 0x0000, 0x47F1, 0x0000,
    0xFE29, 0x0000, 0xC4F7, 0x0000, 0xA384, 0x0000, 0xBCC2, 0x0000,
    0xFB23, 0x0000, 0x3EDB, 0x0000, 0x5CE4, 0x0000, 0x436A, 0x0000,
    0x0635, 0x0000, 0xC1B8, 0x0000, 0xA5B2, 0x0000, 0xBFD5, 0x0000,
    0x0EA9, 0x0000, 0x4106, 0x0000, 0x533C, 0x0000, 0x47E5, 0x0000,
    0xFB2F, 0x0000, 0xC1A4, 0x0000, 0xA749, 0x0000, 0xC497, 0x0000,
    0x002E, 0x0000, 0x3ADC, 0x0000, 0x4B3B, 0x0000, 0x360B, 0x0000,
    0x043E, 0x0000, 0xBB10, 0x0000, 0xAC2C, 0x0000, 0xC06C, 0x0000,
    0xF58E, 0x0000, 0x44DF, 0x0000, 0x56F6, 0x0000, 0x3F08, 0x0000,
    0xFEEB, 0x0000, 0xB86B, 0x0000, 0xA445, 0x0000, 0xC2E2, 0x0000,
    0x0A63, 0x0000, 0x3D49, 0x0000, 0x5B17, 0x0000, 0x3E6C, 0x0000,
    0xFC3F, 0x0000, 0xC850, 0x0000, 0xA078, 0x0000, 0xBD64, 0x0000,
    0xFE2F, 0x0000, 0x4377, 0x0000, 0x5C60, 0x0000, 0x492A, 0x0000,
    0xFABF, 0x0000, 0xBDC3, 0x0000, 0xA732, 0x0000, 0xBA30, 0x0000,
    0x014A, 0x0000, 0x4030, 0x0000, 0x5F8C, 0x0000, 0x3D84, 0x0000,
    0xEC76, 0x0000, 0xBD7D, 0x0000, 0xA275, 0x0000, 0xC0F1, 0x0000,
    0xFB97, 0x0000, 0x43B6, 0x0000, 0x5C93, 0x0000, 0x4409, 0x0000,
    0x0308, 0x0000, 0xBB3D, 0x0000, 0xA1F7, 0x0000, 0xC213, 0x0000,
    0xF0B8, 0x0000, 0x4170, 0x0000, 0x5A37, 0x0000, 0x4C50, 0x0000,
    0xF62E, 0x0000, 0xC65C, 0x0000, 0xA9FF, 0x0000, 0xBECD, 0x0000,
    0xF8FC, 0x0000, 0x39E5, 0x0000, 0x5187, 0x0000, 0x38DC, 0x0000,
    0xFE66, 0x0000, 0xCB16, 0x0000, 0xA588, 0x0000, 0xC460, 0x0000,
    0xFDC6, 0x0000, 0x3E6C, 0x0000, 0x57AD, 0x0000, 0x3728, 0x0000,
    0x03A3, 0x0000, 0xC158, 0x0000, 0x9F55, 0x0000, 0xBB54, 0x0000,
    0x0211, 0x0000, 0x33D1, 0x0000, 0x6090, 0x0000, 0x442D, 0x0000,
    0xF211, 0x0000, 0xC484, 0x0000, 0xAACB, 0x0000, 0xB88E, 0x0000,
    0xF41A, 0x0000, 0x3B78, 0x0000, 0x5343, 0x0000, 0x45E9, 0x0000,
    0xFD24, 0x0000, 0xC95B, 0x0000, 0xA9AC, 0x0000, 0xBCD0, 0x0000,
    0x0366, 0x0000, 0x48FF, 0x0000, 0x5889, 0x0000, 0x3E7B, 0x0000,
    0xFE81, 0x0000, 0xC61B, 0x0000, 0xA63D, 0x0000, 0xCC97, 0x0000,
    0x06AD, 0x0000, 0x3810, 0x0000, 0x61FF, 0x0000, 0x3441, 0x0000,
    0xFDED, 0x0000, 0xB6D7, 0x0000, 0xA6ED, 0x0000, 0xC35E, 0x0000,
    0xFFED, 0x0000, 0x40B0, 0x0000, 0x5E88, 0x0000, 0x3DBA, 0x0000,
    0x0631, 0x0000, 0xD02C, 0x0000, 0x9F44, 0x0000, 0xC1F5, 0x0000,
    0xF95F, 0x0000, 0x4CB4, 0x0000, 0x56DB, 0x0000, 0x44AC, 0x0000,
    0xFE4F, 0x0000, 0xBD8E, 0x0000, 0xA95B, 0x0000, 0xC682, 0x0000,
    0xFA30, 0x0000, 0x446F, 0x0000, 0x63F9, 0x0000, 0x3CA4, 0x0000,
    0xFD96, 0x0000, 0xC352, 0x0000, 0xAD83, 0x0000, 0xCA8F, 0x0000,
    0xF6CD, 0x0000, 0x3AB5, 0x0000, 0x541D, 0x0000, 0x44BD, 0x0000,
    0xFE60, 0x0000, 0xC9D9, 0x0000, 0xA9C4, 0x0000, 0xBDE9, 0x0000,
    0x1280, 0x0000, 0x3A83, 0x0000, 0x4B80, 0x0000, 0x4A2E, 0x0000,
    0xFFA0, 0x0000, 0xBD0C, 0x0000, 0xA021, 0x0000, 0xCA42, 0x0000,
    0x0414, 0x0000, 0x3982, 0x0000, 0x5E82, 0x0000, 0x40EB, 0x0000,
    0xFBA7, 0x0000, 0xC1BE, 0x0000, 0xB322, 0x0000, 0xC16A, 0x0000,
    0xF5E1, 0x0000, 0x3ACF, 0x0000, 0x55B9, 0x0000, 0x411D, 0x0000,
    0xFAB4, 0x0000, 0xC28C, 0x0000, 0xA865, 0x0000, 0xCD61, 0x0000,
    0xF7D0, 0x0000, 0x33CE, 0x0000, 0x5DE3, 0x0000, 0x3BA1, 0x0000,
    0xFA83, 0x0000, 0xCBD5, 0x0000, 0x9F20, 0x0000, 0xBF3A, 0x0000,
    0x0721, 0x0000, 0x3E0C, 0x0000, 0x60EF, 0x0000, 0x3832, 0x0000,
    0x01E1, 0x0000, 0xC391, 0x0000, 0xA810, 0x0000, 0xC422, 0x0000,
    0x01A3, 0x0000, 0x360C, 0x0000, 0x5983, 0x0000, 0x436D, 0x0000,
    0x0086, 0x0000, 0xBDD7, 0x0000, 0xB398, 0x0000, 0xC7BA, 0x0000,
    0x05FB, 0x0000, 0x46AD, 0x0000, 0x6210, 0x0000, 0x449F, 0x0000,
    0xFC0B, 0x0000, 0xBF04, 0x0000, 0xA3B4, 0x0000, 0xC482, 0x0000,
    0xF265, 0x0000, 0x40DD, 0x0000, 0x57F2, 0x0000, 0x4263, 0x0000,
    0xFFF5, 0x0000, 0xC81E, 0x0000, 0xA489, 0x0000, 0xBFDF, 0x0000,
    0xFDED, 0x0000, 0x39CE, 0x0000, 0x50DC, 0x0000, 0x3C33, 0x0000,
    0x00DA, 0x0000, 0xC8BD, 0x0000, 0xA837, 0x0000, 0xC1D0, 0x0000,
    0xFE6F, 0x0000, 0x3DD4, 0x0000, 0x55E5, 0x0000, 0x3C86, 0x0000,
    0xFA2B, 0x0000, 0xBFC0, 0x0000, 0xA12F, 0x0000, 0xC314, 0x0000,
    0x0EB4, 0x0000, 0x396C, 0x0000, 0x50F9, 0x0000, 0x3F82, 0x0000,
    0x0406, 0x0000, 0xBE7C, 0x0000, 0xA1AF, 0x0000, 0xB638, 0x0000,
    0xFF7C, 0x0000, 0x3926, 0x0000, 0x5669, 0x0000, 0x412C, 0x0000,
    0xF713, 0x0000, 0xC8FB, 0x0000, 0xAA66, 0x0000, 0xC37D, 0x0000,
    0x0710, 0x0000, 0x39CE, 0x0000, 0x5469, 0x0000, 0x3209, 0x0000,
    0x02F6, 0x0000, 0xC198, 0x0000, 0x99A2, 0x0000, 0xC2CB, 0x0000,
    0xF54F, 0x0000, 0x353B, 0x0000, 0x5973, 0x0000, 0x44E4, 0x0000,
    0xFCB1, 0x0000, 0xBFE4, 0x0000, 0xAFC9, 0x0000, 0xC272, 0x0000,
    0x008C, 0x0000, 0x450E, 0x0000, 0x586C, 0x0000, 0x404C, 0x0000,
    0xF122, 0x0000, 0xC3FC, 0x0000, 0xA77D, 0x0000, 0xB9FF, 0x0000,
    0x02F8, 0x0000, 0x3DD3, 0x0000, 0x5489, 0x0000, 0x3E4D, 0x0000,
    0x04E8, 0x0000, 0xC0C9, 0x0000, 0xAF70, 0x0000, 0xC34D, 0x0000,
    0x0069, 0x0000, 0x41B1, 0x0000, 0x584D, 0x0000, 0x3A74, 0x0000,
    0x0045, 0x0000, 0xBD5A, 0x0000, 0xA797, 0x0000, 0xC199, 0x0000,
    0x0DAA, 0x0000, 0x33E9, 0x0000, 0x5E8D, 0x0000, 0x3A4E, 0x0000,
    0x07AA, 0x0000, 0xC3EA, 0x0000, 0xB77B, 0x0000, 0xBB44, 0x0000,
    0xFA18, 0x0000, 0x40EC, 0x0000, 0x5587, 0x0000, 0x496D, 0x0000,
    0x053C, 0x0000, 0xC69E, 0x0000, 0xA496, 0x0000, 0xBE35, 0x0000,
    0xFF6C, 0x0000, 0x3E31, 0x0000, 0x5E93, 0x0000, 0x3D2C, 0x0000,
    0x0795, 0x0000, 0xB9BE, 0x0000, 0xAC9F, 0x0000, 0xC41A, 0x0000,
    0x0008, 0x0000, 0x3468, 0x0000, 0x630F, 0x0000, 0x3D7B, 0x0000,
    0x0BD9, 0x0000, 0xC80A, 0x0000, 0xA209, 0x0000, 0xC338, 0x0000,
    0x00EF, 0x0000, 0x376F, 0x0000, 0x58A6, 0x0000, 0x3C9E, 0x0000,
    0x056E, 0x0000, 0xB735, 0x0000, 0xA47A, 0x0000, 0xC5B6, 0x0000,
    0x065C, 0x0000, 0x3613, 0x0000, 0x573B, 0x0000, 0x486E, 0x0000,
    0x0424, 0x0000, 0xCE0A, 0x0000, 0xB05F, 0x0000, 0xBF44, 0x0000,
    0xF454, 0x0000, 0x40BD, 0x0000, 0x5B7F, 0x0000, 0x3C91, 0x0000,
    0x097D, 0x0000, 0xC261, 0x0000, 0xAC5D, 0x0000, 0xBCCD, 0x0000,
    0xF979, 0x0000, 0x396F, 0x0000, 0x5B46, 0x0000, 0x3829, 0x0000,
    0xFACF, 0x0000, 0xBA43, 0x0000, 0x9C9C, 0x0000, 0xC0F7, 0x0000,
    0x02D9, 0x0000, 0x386D, 0x0000, 0x63EC, 0x0000, 0x3B2A, 0x0000,
    0x1063, 0x0000, 0xBA09, 0x0000, 0x9C9E, 0x0000, 0xC1AA, 0x0000,
    0x0664, 0x0000, 0x3E07, 0x0000, 0x5821, 0x0000, 0x4B35, 0x0000,
    0x0224, 0x0000, 0xC4FE, 0x0000, 0xA1FE, 0x0000, 0xC283, 0x0000,
    0xFB76, 0x0000, 0x40A8, 0x0000, 0x6147, 0x0000, 0x47D0, 0x0000,
    0x00BB, 0x0000, 0xCE30, 0x0000, 0xA398, 0x0000, 0xC31F, 0x0000,
    0xF428, 0x0000, 0x403F, 0x0000, 0x5BB1, 0x0000, 0x3887, 0x0000,
    0x0137, 0x0000, 0xBA9A, 0x0000, 0xA866, 0x0000, 0xCB0C, 0x0000,
    0x0032, 0x0000, 0x3617, 0x0000, 0x6031, 0x0000, 0x3FB1, 0x0000,
    0x0475, 0x0000, 0xB5D9, 0x0000, 0xAE27, 0x0000, 0xC0A9, 0x0000,
    0xED29, 0x0000, 0x41D1, 0x0000, 0x6447, 0x0000, 0x3D05, 0x0000,
    0x0303, 0x0000, 0xBF85, 0x0000, 0xA227, 0x0000, 0xB67A, 0x0000,
    0x0006, 0x0000, 0x3BD3, 0x0000, 0x5B5A, 0x0000, 0x3ABB, 0x0000,
    0x09EF, 0x0000, 0xBAFC, 0x0000, 0xB4E1, 0x0000, 0xB796, 0x0000,
    0xF4AD, 0x0000, 0x4800, 0x0000, 0x551E, 0x0000, 0x45DE, 0x0000,
    0xF3DB, 0x0000, 0xC549, 0x0000, 0xA351, 0x0000, 0xC52B, 0x0000,
    0xFE7C, 0x0000, 0x407C, 0x0000, 0x5B8D, 0x0000, 0x3A2D, 0x0000,
    0xF354, 0x0000, 0xBE36, 0x0000, 0xA77B, 0x0000, 0xBF12, 0x0000,
    0x016A, 0x0000, 0x49BC, 0x0000, 0x586F, 0x0000, 0x49EC, 0x0000,
    0x0598, 0x0000, 0xC767, 0x0000, 0xACA7, 0x0000, 0xC59B, 0x0000,
    0xFE59, 0x0000, 0x3A3A, 0x0000, 0x5668, 0x0000, 0x3C1E, 0x0000,
    0x0435, 0x0000, 0xBD00, 0x0000, 0xA008, 0x0000, 0xBAF6, 0x0000,
    0x04A2, 0x0000, 0x413B, 0x0000, 0x50A1, 0x0000, 0x44B3, 0x0000,
    0x0194, 0x0000, 0xC44B, 0x0000, 0x9F7E, 0x0000, 0xCAEA, 0x0000,
    0xF726, 0x0000, 0x4375, 0x0000, 0x5756, 0x0000, 0x4487, 0x0000,
    0x0158, 0x0000, 0xC932, 0x0000, 0x9567, 0x0000, 0xBF8F, 0x0000,
    0x08C4, 0x0000, 0x3E7C, 0x0000, 0x62EF, 0x0000, 0x4087, 0x0000,
    0x0477, 0x0000, 0xCD77, 0x0000, 0xA801, 0x0000, 0xB3C3, 0x0000,
    0xFB33, 0x0000, 0x3C6A, 0x0000, 0x5EB4, 0x0000, 0x476C, 0x0000,
    0xF9DC, 0x0000, 0xC06A, 0x0000, 0xAB86, 0x0000, 0xBD2B, 0x0000,
    0xF96E, 0x0000, 0x3F13, 0x0000, 0x5BA6, 0x0000, 0x3E28, 0x0000,
    0x0361, 0x0000, 0xC35C, 0x0000, 0xA7A0, 0x0000, 0xB676, 0x0000,
    0xFE4E, 0x0000, 0x3B78, 0x0000, 0x5C5E, 0x0000, 0x4922, 0x0000,
    0xFD8B, 0x0000, 0xBABA, 0x0000, 0xB065, 0x0000, 0xB5FB, 0x0000,
    0x005B, 0x0000, 0x40D5, 0x0000, 0x6237, 0x0000, 0x38BD, 0x0000,
    0xF93F, 0x0000, 0xC356, 0x0000, 0x98CD, 0x0000, 0xBD4E, 0x0000,
    0xF431, 0x0000, 0x4083, 0x0000, 0x585A, 0x0000, 0x3731, 0x0000,
    0x05C9, 0x0000, 0xC41B, 0x0000, 0xA605, 0x0000, 0xC6C7, 0x0000,
    0x0C21, 0x0000, 0x34E8, 0x0000, 0x4E7F, 0x0000, 0x3D49, 0x0000,
    0x05F7, 0x0000, 0xB83E, 0x0000, 0x9CB2, 0x0000, 0xBA0C, 0x0000,
    0xF6EF, 0x0000, 0x3EDD, 0x0000, 0x588A, 0x0000, 0x3D49, 0x0000,
    0xFCC7, 0x0000, 0xC6E5, 0x0000, 0xA225, 0x0000, 0xC234, 0x0000,
    0xF6E1, 0x0000, 0x40AD, 0x0000, 0x5D2A, 0x0000, 0x446A, 0x0000,
    0xFFBF, 0x0000, 0xBF2B, 0x0000, 0x9DE3, 0x0000, 0xC555, 0x0000,
    0x0055, 0x0000, 0x455D, 0x0000, 0x565E, 0x0000, 0x3908, 0x0000,
    0xFB65, 0x0000, 0xC8A0, 0x0000, 0xB484, 0x0000, 0xC161, 0x0000,
    0xF18F, 0x0000, 0x361E, 0x0000, 0x59E0, 0x0000, 0x38E2, 0x0000,
    0xF6EE, 0x0000, 0xBDA5, 0x0000, 0xB2CD, 0x0000, 0xBFDF, 0x0000,
    0xF8A6, 0x0000, 0x4088, 0x0000, 0x6422, 0x0000, 0x33BC, 0x0000,
    0xFCF9, 0x0000, 0xCE95, 0x0000, 0xA87D, 0x0000, 0xB91D, 0x0000,
    0xFEBD, 0x0000, 0x3EAC, 0x0000, 0x58A3, 0x0000, 0x3F3B, 0x0000,
    0xFBBB, 0x0000, 0xBC74, 0x0000, 0xA8E1, 0x0000, 0xBFCD, 0x0000,
    0xFCB3, 0x0000, 0x455E, 0x0000, 0x54B6, 0x0000, 0x4148, 0x0000,
    0x0401, 0x0000, 0xBE18, 0x0000, 0xB42C, 0x0000, 0xB6E3, 0x0000,
    0x030B, 0x0000, 0x4225, 0x0000, 0x5CDE, 0x0000, 0x4489, 0x0000,
    0x049F, 0x0000, 0xB60B, 0x0000, 0xA789, 0x0000, 0xBC88, 0x0000,
    0x0004, 0x0000, 0x4090, 0x0000, 0x5996, 0x0000, 0x3B57, 0x0000,
    0x084B, 0x0000, 0xBF1F, 0x0000, 0xABD1, 0x0000, 0xC5E5, 0x0000,
    0xFCDE, 0x0000, 0x2DFA, 0x0000, 0x58C6, 0x0000, 0x4157, 0x0000,
    0x01CD, 0x0000, 0xBAB6, 0x0000, 0xA94A, 0x0000, 0xB880, 0x0000,
    0xFD6D, 0x0000, 0x3B68, 0x0000, 0x50CB, 0x0000, 0x39E5, 0x0000,
    0x0852, 0x0000, 0xBDB1, 0x0000, 0xA04C, 0x0000, 0xC0BA, 0x0000,
    0x0A3C, 0x0000, 0x3B3E, 0x0000, 0x4FCA, 0x0000, 0x3F83, 0x0000,
    0x0DCA, 0x0000, 0xC6E2, 0x0000, 0xAE65, 0x0000, 0xC348, 0x0000,
    0xFDAF, 0x0000, 0x349B, 0x0000, 0x5F66, 0x0000, 0x437F, 0x0000,
    0x0281, 0x0000, 0xB747, 0x0000, 0xA329, 0x0000, 0xCCA5, 0x0000,
    0x013F, 0x0000, 0x35A1, 0x0000, 0x5B66, 0x0000, 0x455A, 0x0000,
    0x0075, 0x0000, 0xB940, 0x0000, 0xA2F1, 0x0000, 0xC075, 0x0000,
    0xFEBD, 0x0000, 0x3907, 0x0000, 0x53A9, 0x0000, 0x3EDA, 0x0000,
    0x0C43, 0x0000, 0xC5E9, 0x0000, 0xAA72, 0x0000, 0xC137, 0x0000,
    0xFAB8, 0x0000, 0x360E, 0x0000, 0x4C25, 0x0000, 0x3FD0, 0x0000,
    0xFBDF, 0x0000, 0xC26F, 0x0000, 0xA4FE, 0x0000, 0xCB77, 0x0000,
    0xFF3E, 0x0000, 0x432C, 0x0000, 0x5955, 0x0000, 0x4C79, 0x0000,
    0x01D2, 0x0000, 0xC688, 0x0000, 0xA3CC, 0x0000, 0xBED5, 0x0000,
    0x02E3, 0x0000, 0x3ACC, 0x0000, 0x5DC1, 0x0000, 0x40A6, 0x0000,
    0xEF6C, 0x0000, 0xCB18, 0x0000, 0xA969, 0x0000, 0xC165, 0x0000,
    0xFBCC, 0x0000, 0x3E0B, 0x0000, 0x5DB6, 0x0000, 0x4127, 0x0000,
    0x0542, 0x0000, 0xBD26, 0x0000, 0xA65B, 0x0000, 0xB8B3, 0x0000,
    0xFD48, 0x0000, 0x3D43, 0x0000, 0x6201, 0x0000, 0x3CE4, 0x0000,
    0xEBEC, 0x0000, 0xC244, 0x0000, 0xA2B1, 0x0000, 0xC7DA, 0x0000,
    0xFAEA, 0x0000, 0x3C9E, 0x0000, 0x6189, 0x0000, 0x3D3E, 0x0000,
    0xFFED, 0x0000, 0xBC14, 0x0000, 0xA51C, 0x0000, 0xBE02, 0x0000,
    0x0BA9, 0x0000, 0x3E2D, 0x0000, 0x53DF, 0x0000, 0x3A3C, 0x0000,
    0x0B5A, 0x0000, 0xC355, 0x0000, 0xA61D, 0x0000, 0xC8BE, 0x0000,
    0x022F, 0x0000, 0x4E57, 0x0000, 0x4E7D, 0x0000, 0x436A, 0x0000,
    0x037F, 0x0000, 0xC507, 0x0000, 0xA1B4, 0x0000, 0xC325, 0x0000,
    0xFAAC, 0x0000, 0x44A5, 0x0000, 0x5FBD, 0x0000, 0x3FF0, 0x0000,
    0x0054, 0x0000, 0xC5B2, 0x0000, 0x9C45, 0x0000, 0xC560, 0x0000,
    0xF856, 0x0000, 0x4118, 0x0000, 0x5E7E, 0x0000, 0x404A, 0x0000,
    0xFE61, 0x0000, 0xC142, 0x0000, 0xABAB, 0x0000, 0xBBA3, 0x0000,
    0xFE00, 0x0000, 0x3A4F, 0x0000, 0x5A85, 0x0000, 0x3311, 0x0000,
    0x00DD, 0x0000, 0xB22E, 0x0000, 0xAF6D, 0x0000, 0xCA4A, 0x0000,
    0xFD96, 0x0000, 0x3F3B, 0x0000, 0x5C5C, 0x0000, 0x3E9F, 0x0000,
    0xFA18, 0x0000, 0xBEDE, 0x0000, 0x97E5, 0x0000, 0xB860, 0x0000,
    0xFC7C, 0x0000, 0x3D2F, 0x0000, 0x6101, 0x0000, 0x42B4, 0x0000,
    0xFF8E, 0x0000, 0xCA73, 0x0000, 0xA504, 0x0000, 0xC70A, 0x0000,
    0xFBBB, 0x0000, 0x404E, 0x0000, 0x65F7, 0x0000, 0x4DB4, 0x0000,
    0xFF61, 0x0000, 0xC186, 0x0000, 0xAA1D, 0x0000, 0xBF31, 0x0000,
    0x04C1, 0x0000, 0x2E50, 0x0000, 0x649A, 0x0000, 0x4082, 0x0000,
    0xF8A2, 0x0000, 0xB775, 0x0000, 0xA9EC, 0x0000, 0xB8B0, 0x0000,
    0xFF6F, 0x0000, 0x45AF, 0x0000, 0x4ECD, 0x0000, 0x400A, 0x0000,
    0x0066, 0x0000, 0xC39F, 0x0000, 0xA5E4, 0x0000, 0xC3FD, 0x0000,
    0xF20E, 0x0000, 0x45CF, 0x0000, 0x4F19, 0x0000, 0x3D75, 0x0000,
    0xFF73, 0x0000, 0xC8A3, 0x0000, 0xA6A0, 0x0000, 0xBAE1, 0x0000,
    0x0684, 0x0000, 0x387C, 0x0000, 0x63E3, 0x0000, 0x3B81, 0x0000,
    0x02CC, 0x0000, 0xBDEC, 0x0000, 0xA3DA, 0x0000, 0xB84A, 0x0000,
    0xF917, 0x0000, 0x42B1, 0x0000, 0x57D4, 0x0000, 0x34A9, 0x0000,
    0x0943, 0x0000, 0xC3D2, 0x0000, 0xB3AF, 0x0000, 0xC607, 0x0000,
    0xFCE6, 0x0000, 0x4043, 0x0000, 0x5794, 0x0000, 0x4752, 0x0000,
    0xF8B9, 0x0000, 0xC0F9, 0x0000, 0x9D53, 0x0000, 0xC126, 0x0000,
    0xF385, 0x0000, 0x4821, 0x0000, 0x5A10, 0x0000, 0x4696, 0x0000,
    0xFD60, 0x0000, 0xB681, 0x0000, 0x9D79, 0x0000, 0xBCAB, 0x0000,
    0xFE3A, 0x0000, 0x380C, 0x0000, 0x5780, 0x0000, 0x450C, 0x0000,
    0x06C5, 0x0000, 0xB5A2, 0x0000, 0xA21D, 0x0000, 0xC831, 0x0000,
    0x05CA, 0x0000, 0x352C, 0x0000, 0x587D, 0x0000, 0x3D2B, 0x0000,
    0xFD6D, 0x0000, 0xBCEB, 0x0000, 0xA2C8, 0x0000, 0xB61F, 0x0000,
    0x0105, 0x0000, 0x43C6, 0x0000, 0x5AA3, 0x0000, 0x37C4, 0x0000,
    0xFCF8, 0x0000, 0xBDED, 0x0000, 0xA088, 0x0000, 0xC3D6, 0x0000,
    0xFC7B, 0x0000, 0x3F73, 0x0000, 0x5E4C, 0x0000, 0x3F61, 0x0000,
    0x00A7, 0x0000, 0xBAFB, 0x0000, 0xA676, 0x0000, 0xBCD9, 0x0000,
    0xF059, 0x0000, 0x36EB, 0x0000, 0x5B40, 0x0000, 0x46DD, 0x0000,
    0x0819, 0x0000, 0xBB4E, 0x0000, 0xA6DE, 0x0000, 0xB934, 0x0000,
    0x043C, 0x0000, 0x3B24, 0x0000, 0x5C79, 0x0000, 0x393B, 0x0000,
    0x0E49, 0x0000, 0xC170, 0x0000, 0xABE3, 0x0000, 0xC33A, 0x0000,
    0xFDBD, 0x0000, 0x380A, 0x0000, 0x6144, 0x0000, 0x4709, 0x0000,
    0xFB04, 0x0000, 0xB256, 0x0000, 0xA389, 0x0000, 0xC39B, 0x0000,
    0xFCA5, 0x0000, 0x38C6, 0x0000, 0x576F, 0x0000, 0x38DD, 0x0000,
    0xF77B, 0x0000, 0xBF1A, 0x0000, 0xA216, 0x0000, 0xB5A9, 0x0000,
    0xF70E, 0x0000, 0x448A, 0x0000, 0x5AFA, 0x0000, 0x3463, 0x0000,
    0x0948, 0x0000, 0xBFDB, 0x0000, 0x9CFE, 0x0000, 0xBA4C, 0x0000,
    0xFF90, 0x0000, 0x36A4, 0x0000, 0x5374, 0x0000, 0x37C8, 0x0000,
    0xFCFB, 0x0000, 0xBC80, 0x0000, 0xA633, 0x0000, 0xC2C1, 0x0000,
    0xEF63, 0x0000, 0x39C3, 0x0000, 0x5632, 0x0000, 0x4189, 0x0000,
    0x0659, 0x0000, 0xC1ED, 0x0000, 0xA48E, 0x0000, 0xB8D9, 0x0000,
    0x015B, 0x0000, 0x4868, 0x0000, 0x547D, 0x0000, 0x38C5, 0x0000,
    0xFD8D, 0x0000, 0xC1DF, 0x0000, 0x983B, 0x0000, 0xB68E, 0x0000,
    0xFDA7, 0x0000, 0x4494, 0x0000, 0x6167, 0x0000, 0x3A70, 0x0000,
    0xFCA6, 0x0000, 0xC058, 0x0000, 0xAA0F, 0x0000, 0xBB0E, 0x0000,
    0xF77E, 0x0000, 0x4369, 0x0000, 0x5E13, 0x0000, 0x3DF4, 0x0000,
    0xFABF, 0x0000, 0xC629, 0x0000, 0xAE2D, 0x0000, 0xC337, 0x0000,
    0x063E, 0x0000, 0x36A1, 0x0000, 0x56C8, 0x0000, 0x4084, 0x0000,
    0x0634, 0x0000, 0xC31F, 0x0000, 0xACCB, 0x0000, 0xBA69, 0x0000,
    0xFB9F, 0x0000, 0x3AE6, 0x0000, 0x5501, 0x0000, 0x3DAC, 0x0000,
    0x0494, 0x0000, 0xBCD3, 0x0000, 0xA8A9, 0x0000, 0xC605, 0x0000,
    0x02BF, 0x0000, 0x37E0, 0x0000, 0x55B6, 0x0000, 0x3BCF, 0x0000,
    0x028B, 0x0000, 0xBDEF, 0x0000, 0xA9CD, 0x0000, 0xC0A9, 0x0000,
    0xF5F3, 0x0000, 0x45EC, 0x0000, 0x554D, 0x0000, 0x42EB, 0x0000,
    0x031C, 0x0000, 0xBD93, 0x0000, 0xA030, 0x0000, 0xB6BE, 0x0000,
    0xFCE7, 0x0000, 0x3B1F, 0x0000, 0x5249, 0x0000, 0x4A1C, 0x0000,
    0x09A6, 0x0000, 0xBD2C, 0x0000, 0xB596, 0x0000, 0xC295, 0x0000,
    0xFBB0, 0x0000, 0x4701, 0x0000, 0x699A, 0x0000, 0x4227, 0x0000,
    0x0552, 0x0000, 0xBD6A, 0x0000, 0xA4C9, 0x0000, 0xB99D, 0x0000,
    0xFBB5, 0x0000, 0x39F2, 0x0000, 0x5C6E, 0x0000, 0x3C44, 0x0000,
    0xFF69, 0x0000, 0xBB6F, 0x0000, 0x9A83, 0x0000, 0xB927, 0x0000,
    0xF9D5, 0x0000, 0x41C3, 0x0000, 0x5270, 0x0000, 0x407E, 0x0000,
    0xFFF1, 0x0000, 0xC8EC, 0x0000, 0xACCD, 0x0000, 0xBAE1, 0x0000,
    0x0AAF, 0x0000, 0x4077, 0x0000, 0x658D, 0x0000, 0x3F0B, 0x0000,
    0x0372, 0x0000, 0xC34F, 0x0000, 0xA53B, 0x0000, 0xBB17, 0x0000,
    0x073A, 0x0000, 0x3CAA, 0x0000, 0x56C3, 0x0000, 0x39A4, 0x0000,
    0xF8FB, 0x0000, 0xC986, 0x0000, 0xA718, 0x0000, 0xBEE8, 0x0000,
    0x0557, 0x0000, 0x4482, 0x0000, 0x6136, 0x0000, 0x37FB, 0x0000,
    0xF99D, 0x0000, 0xC08E, 0x0000, 0xA5DA, 0x0000, 0xC140, 0x0000,
    0x069E, 0x0000, 0x492B, 0x0000, 0x5883, 0x0000, 0x41EE, 0x0000,
    0xF74A, 0x0000, 0xB86F, 0x0000, 0xB65A, 0x0000, 0xC0FB, 0x0000,
    0x05F4, 0x0000, 0x3C77, 0x0000, 0x5C3F, 0x0000, 0x3DA0, 0x0000,
    0xFBD3, 0x0000, 0xC6F6, 0x0000, 0x9C3F, 0x0000, 0xB91D, 0x0000,
    0x0071, 0x0000, 0x38A3, 0x0000, 0x5D3F, 0x0000, 0x3D07, 0x0000,
    0x008E, 0x0000, 0xBC62, 0x0000, 0xAAFE, 0x0000, 0xC5C3, 0x0000,
    0xF660, 0x0000, 0x31E5, 0x0000, 0x5DF0, 0x0000, 0x3F4B, 0x0000,
    0xFFF4, 0x0000, 0xB991, 0x0000, 0xAA0B, 0x0000, 0xC539, 0x0000,
    0xFC44, 0x0000, 0x3F64, 0x0000, 0x5B1C, 0x0000, 0x3D85, 0x0000,
    0x130C, 0x0000, 0xAE28, 0x0000, 0xA037, 0x0000, 0xBF1B, 0x0000,
    0xFC60, 0x0000, 0x4684, 0x0000, 0x5F00, 0x0000, 0x3E68, 0x0000,
    0xFF7F, 0x0000, 0xC889, 0x0000, 0xA656, 0x0000, 0xB7F9, 0x0000,
    0x0020, 0x0000, 0x4B95, 0x0000, 0x681B, 0x0000, 0x4827, 0x0000,
    0x074D, 0x0000, 0xC441, 0x0000, 0xAA62, 0x0000, 0xC1D4, 0x0000,
    0x0245, 0x0000, 0x3870, 0x0000, 0x6147, 0x0000, 0x4107, 0x0000,
    0x0987, 0x0000, 0xC172, 0x0000, 0xA09E, 0x0000, 0xBFE4, 0x0000,
    0xF97E, 0x0000, 0x3F76, 0x0000, 0x57E4, 0x0000, 0x3CB1, 0x0000,
    0xF452, 0x0000, 0xBD98, 0x0000, 0xAED6, 0x0000, 0xC8B7, 0x0000,
    0x051B, 0x0000, 0x3ECB, 0x0000, 0x56C6, 0x0000, 0x3F8A, 0x0000,
    0xFB61, 0x0000, 0xBD85, 0x0000, 0xAB6E, 0x0000, 0xCC26, 0x0000,
    0xFB9D, 0x0000, 0x3D42, 0x0000, 0x60B2, 0x0000, 0x4559, 0x0000,
    0x02E1, 0x0000, 0xC4D1, 0x0000, 0xADDE, 0x0000, 0xBDD2, 0x0000,
    0x08B3, 0x0000, 0x3A07, 0x0000, 0x5FC5, 0x0000, 0x3859, 0x0000,
    0x020B, 0x0000, 0xB375, 0x0000, 0xA8AB, 0x0000, 0xC294, 0x0000,
    0x0289, 0x0000, 0x4DD2, 0x0000, 0x57C9, 0x0000, 0x3AE3, 0x0000,
    0xFFE4, 0x0000, 0xBE81, 0x0000, 0xA584, 0x0000, 0xCB95, 0x0000,
    0xFC62, 0x0000, 0x3D07, 0x0000, 0x5341, 0x0000, 0x3F27, 0x0000,
    0xF9EB, 0x0000, 0xBC48, 0x0000, 0x9597, 0x0000, 0xC4F6, 0x0000,
    0xFEC0, 0x0000, 0x44BF, 0x0000, 0x5880, 0x0000, 0x3D8A, 0x0000,
    0x0447, 0x0000, 0xBC90, 0x0000, 0xA671, 0x0000, 0xC0BC, 0x0000,
    0xF98F, 0x0000, 0x3D0A, 0x0000, 0x60E8, 0x0000, 0x41C4, 0x0000,
    0x0B5C, 0x0000, 0xC316, 0x0000, 0xA98A, 0x0000, 0xBBA9, 0x0000,
    0x02A7, 0x0000, 0x3D8C, 0x0000, 0x5535, 0x0000, 0x3802, 0x0000,
    0x067D, 0x0000, 0xCAC4, 0x0000, 0xAE8E, 0x0000, 0xC392, 0x0000,
    0xFD61, 0x0000, 0x3F7A, 0x0000, 0x5529, 0x0000, 0x38C0, 0x0000,
    0x01FB, 0x0000, 0xC608, 0x0000, 0xA3D4, 0x0000, 0xB9A8, 0x0000,
    0xFDF1, 0x0000, 0x499C, 0x0000, 0x561C, 0x0000, 0x4313, 0x0000,
    0x0D05, 0x0000, 0xC2E7, 0x0000, 0xA77F, 0x0000, 0xB9FA, 0x0000,
    0x0616, 0x0000, 0x3AB4, 0x0000, 0x57B1, 0x0000, 0x42ED, 0x0000,
    0x065E, 0x0000, 0xBBCE, 0x0000, 0xA618, 0x0000, 0xC1FC, 0x0000,
    0x0319, 0x0000, 0x3733, 0x0000, 0x579E, 0x0000, 0x4656, 0x0000,
    0x080E, 0x0000, 0xB586, 0x0000, 0x9F11, 0x0000, 0xCCFA, 0x0000,
    0xF6F2, 0x0000, 0x44D8, 0x0000, 0x5110, 0x0000, 0x38F8, 0x0000,
    0x00DE, 0x0000, 0xC695, 0x0000, 0xA59C, 0x0000, 0xBAC8, 0x0000,
    0xFD86, 0x0000, 0x4719, 0x0000, 0x5E5E, 0x0000, 0x3BD7, 0x0000,
    0x0731, 0x0000, 0xBD3F, 0x0000, 0xB230, 0x0000, 0xB375, 0x0000,
    0x0799, 0x0000, 0x37CD, 0x0000, 0x60FA, 0x0000, 0x3CE9, 0x0000,
    0x03F4, 0x0000, 0xB5A1, 0x0000, 0xA52A, 0x0000, 0xC333, 0x0000,
    0x021B, 0x0000, 0x4A58, 0x0000, 0x4F3F, 0x0000, 0x3E6C, 0x0000,
    0xF62F, 0x0000, 0xC3DF, 0x0000, 0xA232, 0x0000, 0xB858, 0x0000,
    0x036B, 0x0000, 0x3AAC, 0x0000, 0x5C1A, 0x0000, 0x3DDA, 0x0000,
    0x024E, 0x0000, 0xBE9C, 0x0000, 0xA900, 0x0000, 0xC61A, 0x0000,
    0xFBFF, 0x0000, 0x3BA5, 0x0000, 0x563E, 0x0000, 0x455F, 0x0000,
    0xFF12, 0x0000, 0xC292, 0x0000, 0xA1A9, 0x0000, 0xB474, 0x0000,
    0xF733, 0x0000, 0x3AAF, 0x0000, 0x595B, 0x0000, 0x3C91, 0x0000,
    0xFB41, 0x0000, 0xB60B, 0x0000, 0x9D82, 0x0000, 0xBAC9, 0x0000,
    0xFBCE, 0x0000, 0x3B4F, 0x0000, 0x4BD2, 0x0000, 0x487B, 0x0000,
    0xFFA6, 0x0000, 0xC20E, 0x0000, 0xA434, 0x0000, 0xBC9B, 0x0000,
    0xFF71, 0x0000, 0x3C7F, 0x0000, 0x665E, 0x0000, 0x3DEF, 0x0000,
    0xF505, 0x0000, 0xBD37, 0x0000, 0xA13D, 0x0000, 0xB96E, 0x0000,
    0x01E1, 0x0000, 0x34F1, 0x0000, 0x522A, 0x0000, 0x434F, 0x0000,
    0xFFD3, 0x0000, 0xBF5C, 0x0000, 0xA49D, 0x0000, 0xC08F, 0x0000,
    0x0097, 0x0000, 0x3DE0, 0x0000, 0x5281, 0x0000, 0x3C96, 0x0000,
    0x07C3, 0x0000, 0xC51F, 0x0000, 0xABD5, 0x0000, 0xC2B4, 0x0000,
    0xFF50, 0x0000, 0x3B08, 0x0000, 0x5669, 0x0000, 0x41E9, 0x0000,
    0x0045, 0x0000, 0xB5EE, 0x0000, 0xAE76, 0x0000, 0xC430, 0x0000,
    0x043C, 0x0000, 0x3F17, 0x0000, 0x5C76, 0x0000, 0x3D8E, 0x0000,
    0xF6A6, 0x0000, 0xC5C2, 0x0000, 0xA6B8, 0x0000, 0xC66B, 0x0000,
    0x0489, 0x0000, 0x4449, 0x0000, 0x61F5, 0x0000, 0x4867, 0x0000,
    0x0435, 0x0000, 0xBE73, 0x0000, 0xA7DE, 0x0000, 0xC240, 0x0000,
    0x0471, 0x0000, 0x3A41, 0x0000, 0x5C74, 0x0000, 0x3E61, 0x0000,
    0xFECE, 0x0000, 0xB891, 0x0000, 0xA4A2, 0x0000, 0xC2D8, 0x0000,
    0xFA3D, 0x0000, 0x3C73, 0x0000, 0x5D67, 0x0000, 0x3BF7, 0x0000,
    0xFCDD, 0x0000, 0xC4C1, 0x0000, 0xA05B, 0x0000, 0xBF7A, 0x0000,
    0x0016, 0x0000, 0x3E6D, 0x0000, 0x5EAD, 0x0000, 0x3728, 0x0000,
    0xFF5B, 0x0000, 0xC107, 0x0000, 0xA3AE, 0x0000, 0xCBE9, 0x0000,
    0xFE61, 0x0000, 0x482F, 0x0000, 0x594B, 0x0000, 0x44E2, 0x0000,
    0x0400, 0x0000, 0xBC80, 0x0000, 0xAA82, 0x0000, 0xC726, 0x0000,
    0xFFBF, 0x0000, 0x3A3A, 0x0000, 0x605B, 0x0000, 0x31AA, 0x0000,
    0x0297, 0x0000, 0xCC83, 0x0000, 0xA280, 0x0000, 0xC06D, 0x0000,
    0x0256, 0x0000, 0x3F3D, 0x0000, 0x627E, 0x0000, 0x4669, 0x0000,
    0xFE85, 0x0000, 0xC588, 0x0000, 0xA860, 0x0000, 0xBA34, 0x0000,
    0x0961, 0x0000, 0x448A, 0x0000, 0x50C5, 0x0000, 0x429D, 0x0000,
    0x0418, 0x0000, 0xBDAD, 0x0000, 0x9DB1, 0x0000, 0xBBA0, 0x0000,
    0x0232, 0x0000, 0x3FED, 0x0000, 0x54BE, 0x0000, 0x38D2, 0x0000,
    0x05BD, 0x0000, 0xC17E, 0x0000, 0xA4A5, 0x0000, 0xBEBD, 0x0000,
    0x046E, 0x0000, 0x469E, 0x0000, 0x50A1, 0x0000, 0x37F3, 0x0000,
    0xF9AA, 0x0000, 0xBC5D, 0x0000, 0xA9B9, 0x0000, 0xBBF8, 0x0000,
    0x05DF, 0x0000, 0x3CFD, 0x0000, 0x5098, 0x0000, 0x4CAC, 0x0000,
    0x0090, 0x0000, 0xC051, 0x0000, 0xA854, 0x0000, 0xCD5E, 0x0000,
    0xF98B, 0x0000, 0x4084, 0x0000, 0x5363, 0x0000, 0x3CCA, 0x0000,
    0x0989, 0x0000, 0xB998, 0x0000, 0xAD3A, 0x0000, 0xC1F4, 0x0000,
    0x0142, 0x0000, 0x3A88, 0x0000, 0x5618, 0x0000, 0x3C5A, 0x0000,
    0xFC51, 0x0000, 0xBA2C, 0x0000, 0xA95E, 0x0000, 0xBDBF, 0x0000,
    0xF386, 0x0000, 0x41A2, 0x0000, 0x66BB, 0x0000, 0x4512, 0x0000,
    0xFDA4, 0x0000, 0xB970, 0x0000, 0x9FF6, 0x0000, 0xC463, 0x0000,
    0x08BC, 0x0000, 0x432C, 0x0000, 0x571C, 0x0000, 0x4A79, 0x0000,
    0x0566, 0x0000, 0xC28F, 0x0000, 0xB013, 0x0000, 0xBD89, 0x0000,
    0xFFC1, 0x0000, 0x4996, 0x0000, 0x5B6A, 0x0000, 0x3A8F, 0x0000,
    0xFE48, 0x0000, 0xBD05, 0x0000, 0xA91C, 0x0000, 0xC90B, 0x0000,
    0x05F0, 0x0000, 0x378B, 0x0000, 0x506E, 0x0000, 0x3E5B, 0x0000,
    0xF84E, 0x0000, 0xC24C, 0x0000, 0xAC49, 0x0000, 0xB840, 0x0000,
    0xFF57, 0x0000, 0x4211, 0x0000, 0x5D38, 0x0000, 0x341F, 0x0000,
    0xEE12, 0x0000, 0xC321, 0x0000, 0xAA7F, 0x0000, 0xB39F, 0x0000,
    0x0C33, 0x0000, 0x3892, 0x0000, 0x5482, 0x0000, 0x40DB, 0x0000,
    0xFA88, 0x0000, 0xC31B, 0x0000, 0xA485, 0x0000, 0xBFAE, 0x0000,
    0xFCDB, 0x0000, 0x4A0D, 0x0000, 0x4F5C, 0x0000, 0x44EC, 0x0000,
    0x029B, 0x0000, 0xC199, 0x0000, 0xA74C, 0x0000, 0xBDDD, 0x0000,
    0xF850, 0x0000, 0x33D9, 0x0000, 0x669E, 0x0000, 0x3807, 0x0000,
    0x0150, 0x0000, 0xC24B, 0x0000, 0xAC90, 0x0000, 0xCC4E, 0x0000,
    0x05F9, 0x0000, 0x4482, 0x0000, 0x5CC5, 0x0000, 0x3D6A, 0x0000,
    0x01A1, 0x0000, 0xBF0B, 0x0000, 0xAAB2, 0x0000, 0xBE2B, 0x0000,
    0xF66B, 0x0000, 0x3D89, 0x0000, 0x51C7, 0x0000, 0x3DD1, 0x0000,
    0xFCEE, 0x0000, 0xC501, 0x0000, 0xABF7, 0x0000, 0xC87E, 0x0000,
    0xF9C5, 0x0000, 0x3EA3, 0x0000, 0x6263, 0x0000, 0x354A, 0x0000,
    0x0864, 0x0000, 0xC20B, 0x0000, 0x9FCB, 0x0000, 0xC4A6, 0x0000,
    0x0252, 0x0000, 0x3F29, 0x0000, 0x5DCB, 0x0000, 0x3BC1, 0x0000,
    0xF82D, 0x0000, 0xC39B, 0x0000, 0x98C3, 0x0000, 0xCB04, 0x0000,
    0xFB98, 0x0000, 0x4404, 0x0000, 0x52BD, 0x0000, 0x3DEF, 0x0000,
    0xFF21, 0x0000, 0xBD09, 0x0000, 0xA48E, 0x0000, 0xC171, 0x0000,
    0xF220, 0x0000, 0x3397, 0x0000, 0x587A, 0x0000, 0x3E49, 0x0000,
    0x02B6, 0x0000, 0xCE58, 0x0000, 0xA592, 0x0000, 0xBD43, 0x0000,
    0x028B, 0x0000, 0x362E, 0x0000, 0x54DB, 0x0000, 0x3F58, 0x0000,
    0xFA07, 0x0000, 0xC530, 0x0000, 0xA185, 0x0000, 0xBE15, 0x0000,
    0xFB7C, 0x0000, 0x3F92, 0x0000, 0x5FD8, 0x0000, 0x420A, 0x0000,
    0x0543, 0x0000, 0xBF92, 0x0000, 0xA91F, 0x0000, 0xC268, 0x0000,
    0x0811, 0x0000, 0x4299, 0x0000, 0x5B00, 0x0000, 0x3EA7, 0x0000,
    0xF661, 0x0000, 0xBE27, 0x0000, 0xB289, 0x0000, 0xCE29, 0x0000,
    0xFA9D, 0x0000, 0x3C54, 0x0000, 0x61F5, 0x0000, 0x4864, 0x0000,
    0x017A, 0x0000, 0xB784, 0x0000, 0xA6BD, 0x0000, 0xB33A, 0x0000,
    0xFCB6, 0x0000, 0x455F, 0x0000, 0x5BBC, 0x0000, 0x39A4, 0x0000,
    0x0B8F, 0x0000, 0xC3A7, 0x0000, 0xA419, 0x0000, 0xBF7A, 0x0000,
    0xFC50, 0x0000, 0x3BDD, 0x0000, 0x5693, 0x0000, 0x4400, 0x0000,
    0xFD2C, 0x0000, 0xBBE1, 0x0000, 0xA68F, 0x0000, 0xCDDC, 0x0000,
    0xFB4A, 0x0000, 0x43BE, 0x0000, 0x58D4, 0x0000, 0x47AB, 0x0000,
    0xFD8A, 0x0000, 0xC475, 0x0000, 0xAB27, 0x0000, 0xCC06, 0x0000,
    0xF3C0, 0x0000, 0x3D64, 0x0000, 0x5617, 0x0000, 0x49B4, 0x0000,
    0xFC58, 0x0000, 0xBA6E, 0x0000, 0xB2FF, 0x0000, 0xC4AA, 0x0000,
    0x0439, 0x0000, 0x346D, 0x0000, 0x59B9, 0x0000, 0x3D4E, 0x0000,
    0x034F, 0x0000, 0xBCB4, 0x0000, 0xA2BD, 0x0000, 0xBBD9, 0x0000,
    0x04BD, 0x0000, 0x3E70, 0x0000, 0x678A, 0x0000, 0x3FD4, 0x0000,
    0xFDC8, 0x0000, 0xBEFD, 0x0000, 0xA229, 0x0000, 0xBF79, 0x0000,
    0xF928, 0x0000, 0x36BD, 0x0000, 0x5BBF, 0x0000, 0x428F, 0x0000,
    0xFF6A, 0x0000, 0xC866, 0x0000, 0xA90E, 0x0000, 0xC298, 0x0000,
    0xFA71, 0x0000, 0x3558, 0x0000, 0x5BC2, 0x0000, 0x46F5, 0x0000,
    0xFBE6, 0x0000, 0xC5DC, 0x0000, 0x9FCC, 0x0000, 0xC117, 0x0000,
    0xFA37, 0x0000, 0x417F, 0x0000, 0x56D9, 0x0000, 0x409E, 0x0000,
    0x0215, 0x0000, 0xC862, 0x0000, 0xB01B, 0x0000, 0xC4E3, 0x0000,
    0x05C7, 0x0000, 0x3889, 0x0000, 0x4D52, 0x0000, 0x3698, 0x0000,
    0x0093, 0x0000, 0xB402, 0x0000, 0xA937, 0x0000, 0xBA5D, 0x0000,
    0xF939, 0x0000, 0x46FF, 0x0000, 0x5EF5, 0x0000, 0x3B12, 0x0000,
    0xF78C, 0x0000, 0xC343, 0x0000, 0xA260, 0x0000, 0xC03F, 0x0000,
    0x0D74, 0x0000, 0x3F23, 0x0000, 0x67FF, 0x0000, 0x446C, 0x0000,
    0x01DA, 0x0000, 0xC37C, 0x0000, 0xAC42, 0x0000, 0xBAB8, 0x0000,
    0x00D8, 0x0000, 0x401D, 0x0000, 0x5E04, 0x0000, 0x47EC, 0x0000,
    0x0545, 0x0000, 0xBF19, 0x0000, 0xA2AE, 0x0000, 0xC04D, 0x0000,
    0x00BF, 0x0000, 0x3AF5, 0x0000, 0x62A5, 0x0000, 0x3EC6, 0x0000,
    0x0893, 0x0000, 0xB378, 0x0000, 0xA88B, 0x0000, 0xC280, 0x0000,
    0xFC6B, 0x0000, 0x4889, 0x0000, 0x560F, 0x0000, 0x454B, 0x0000,
    0x018D, 0x0000, 0xC265, 0x0000, 0xAC4D, 0x0000, 0xBCA3, 0x0000,
    0xFCE4, 0x0000, 0x430C, 0x0000, 0x5104, 0x0000, 0x3E6A, 0x0000,
    0x01FA, 0x0000, 0xBFE1, 0x0000, 0xAC1F, 0x0000, 0xB64C, 0x0000,
    0xE1B3, 0x0000, 0x477D, 0x0000, 0x4EFB, 0x0000, 0x4479, 0x0000,
    0x0FDE, 0x0000, 0xBB75, 0x0000, 0xB002, 0x0000, 0xB944, 0x0000,
    0xFEA9, 0x0000, 0x35E4, 0x0000, 0x574D, 0x0000, 0x3C71, 0x0000,
    0xFCE1, 0x0000, 0xC5C9, 0x0000, 0xA16A, 0x0000, 0xC97F, 0x0000,
    0x077F, 0x0000, 0x48E4, 0x0000, 0x5495, 0x0000, 0x4203, 0x0000,
    0xF47E, 0x0000, 0xC36A, 0x0000, 0xA753, 0x0000, 0xD439, 0x0000,
    0xFD4D, 0x0000, 0x3892, 0x0000, 0x5683, 0x0000, 0x3B71, 0x0000,
    0xFF9B, 0x0000, 0xBF05, 0x0000, 0xAB92, 0x0000, 0xC008, 0x0000,
    0x05A4, 0x0000, 0x3DDA, 0x0000, 0x568A, 0x0000, 0x4373, 0x0000,
    0xFF4C, 0x0000, 0xC03F, 0x0000, 0xA51A, 0x0000, 0xC2FD, 0x0000,
    0xFBD6, 0x0000, 0x3C5A, 0x0000, 0x5BBA, 0x0000, 0x48BE, 0x0000,
    0xFD8E, 0x0000, 0xC354, 0x0000, 0xA9F5, 0x0000, 0xBC7E, 0x0000,
    0xFC06, 0x0000, 0x3F78, 0x0000, 0x514A, 0x0000, 0x437B, 0x0000,
    0xFF6B, 0x0000, 0xC253, 0x0000, 0xA626, 0x0000, 0xCD92, 0x0000,
    0xF9B5, 0x0000, 0x3E9B, 0x0000, 0x5EF3, 0x0000, 0x41DD, 0x0000,
    0xFEC3, 0x0000, 0xC3FF, 0x0000, 0xA8C1, 0x0000, 0xC2CC, 0x0000,
    0xF87B, 0x0000, 0x3DBA, 0x0000, 0x5FD2, 0x0000, 0x3AC8, 0x0000,
    0xF124, 0x0000, 0xCBA0, 0x0000, 0xA613, 0x0000, 0xBFFD, 0x0000,
    0xF843, 0x0000, 0x3876, 0x0000, 0x4B3B, 0x0000, 0x45FB, 0x0000,
    0xF3D3, 0x0000, 0xB969, 0x0000, 0xA4E5, 0x0000, 0xB5B5, 0x0000,
    0xF995, 0x0000, 0x3A2E, 0x0000, 0x538A, 0x0000, 0x3E36, 0x0000,
    0x0031, 0x0000, 0xC217, 0x0000, 0xACC4, 0x0000, 0xBC04, 0x0000,
    0x0732, 0x0000, 0x3874, 0x0000, 0x6758, 0x0000, 0x39F4, 0x0000,
    0xFCD8, 0x0000, 0xC4C6, 0x0000, 0xA69E, 0x0000, 0xBFEC, 0x0000,
    0xFD4D, 0x0000, 0x4718, 0x0000, 0x5F4F, 0x0000, 0x4274, 0x0000,
    0xFA6A, 0x0000, 0xC16D, 0x0000, 0xA9E4, 0x0000, 0xB6D2, 0x0000,
    0x079A, 0x0000, 0x4430, 0x0000, 0x6AD3, 0x0000, 0x3A2B, 0x0000,
    0xF96B, 0x0000, 0xC413, 0x0000, 0xA62F, 0x0000, 0xC622, 0x0000,
    0x0550, 0x0000, 0x3BA9, 0x0000, 0x5B8F, 0x0000, 0x39F4, 0x0000,
    0xFA95, 0x0000, 0xC87B, 0x0000, 0xA814, 0x0000, 0xBC86, 0x0000,
    0xFADC, 0x0000, 0x385F, 0x0000, 0x5D21, 0x0000, 0x433E, 0x0000,
    0x024C, 0x0000, 0xC8CD, 0x0000, 0x9C3B, 0x0000, 0xC801, 0x0000,
    0xF298, 0x0000, 0x3E0A, 0x0000, 0x4FED, 0x0000, 0x3E30, 0x0000,
    0x0A43, 0x0000, 0xD0C2, 0x0000, 0xA384, 0x0000, 0xBEA1, 0x0000,
    0xFBE3, 0x0000, 0x37BA, 0x0000, 0x4FF5, 0x0000, 0x35C3, 0x0000,
    0x050A, 0x0000, 0xC338, 0x0000, 0xA864, 0x0000, 0xC69D, 0x0000,
    0x09D7, 0x0000, 0x421B, 0x0000, 0x5474, 0x0000, 0x498A, 0x0000,
    0x02FD, 0x0000, 0xC289, 0x0000, 0xA41A, 0x0000, 0xC544, 0x0000,
    0xFEAB, 0x0000, 0x34DB, 0x0000, 0x53AF, 0x0000, 0x49F6, 0x0000,
    0x037F, 0x0000, 0xBEE5, 0x0000, 0xA65F, 0x0000, 0xB4BE, 0x0000,
    0xF975, 0x0000, 0x379D, 0x0000, 0x5DE0, 0x0000, 0x4AFD, 0x0000,
    0xFD62, 0x0000, 0xCB87, 0x0000, 0x9A14, 0x0000, 0xC610, 0x0000,
    0x067B, 0x0000, 0x3897, 0x0000, 0x580C, 0x0000, 0x3E3A, 0x0000,
    0x0541, 0x0000, 0xCB62, 0x0000, 0xA070, 0x0000, 0xC62F, 0x0000,
    0x058D, 0x0000, 0x49FD, 0x0000, 0x55E4, 0x0000, 0x458C, 0x0000,
    0xFBB7, 0x0000, 0xC869, 0x0000, 0xA9D1, 0x0000, 0xBBF7, 0x0000,
    0xFE89, 0x0000, 0x3E7F, 0x0000, 0x5A68, 0x0000, 0x3BAC, 0x0000,
    0x00F7, 0x0000, 0xB8E2, 0x0000, 0xAD21, 0x0000, 0xCB2A, 0x0000,
    0x02E6, 0x0000, 0x3FC4, 0x0000, 0x520C, 0x0000, 0x3B2D, 0x0000,
    0x043A, 0x0000, 0xBAF0, 0x0000, 0xA40D, 0x0000, 0xBE8F, 0x0000,
    0xFB6F, 0x0000, 0x39D7, 0x0000, 0x5C86, 0x0000, 0x420F, 0x0000,
    0x0C00, 0x0000, 0xC1A2, 0x0000, 0xA5B6, 0x0000, 0xC4AD, 0x0000,
    0xFE77, 0x0000, 0x42F1, 0x0000, 0x60FA, 0x0000, 0x43C4, 0x0000,
    0x0787, 0x0000, 0xC019, 0x0000, 0xA5D4, 0x0000, 0xBC14, 0x0000,
    0xFE35, 0x0000, 0x3908, 0x0000, 0x55D9, 0x0000, 0x3B41, 0x0000,
    0xFFAD, 0x0000, 0xBC77, 0x0000, 0xA387, 0x0000, 0xC73C, 0x0000,
    0xFEDC, 0x0000, 0x39F0, 0x0000, 0x56D1, 0x0000, 0x3ACD, 0x0000,
    0xFEA4, 0x0000, 0xB112, 0x0000, 0xA862, 0x0000, 0xC6E3, 0x0000,
    0xF927, 0x0000, 0x3934, 0x0000, 0x5B89, 0x0000, 0x4329, 0x0000,
    0x086C, 0x0000, 0xC012, 0x0000, 0xA5BA, 0x0000, 0xC4E3, 0x0000,
    0x0297, 0x0000, 0x4813, 0x0000, 0x546D, 0x0000, 0x3CA6, 0x0000,
    0xF7C9, 0x0000, 0xBDE4, 0x0000, 0xA3FC, 0x0000, 0xBED4, 0x0000,
    0x0E01, 0x0000, 0x43A4, 0x0000, 0x58CC, 0x0000, 0x3F12, 0x0000,
    0xFC55, 0x0000, 0xBCBF, 0x0000, 0xA1EE, 0x0000, 0xC3E1, 0x0000,
    0x03AD, 0x0000, 0x3ACE, 0x0000, 0x50EA, 0x0000, 0x3CB0, 0x0000,
    0x0CAC, 0x0000, 0xC216, 0x0000, 0xA79C, 0x0000, 0xBC9B, 0x0000,
    0xF72E, 0x0000, 0x3D48, 0x0000, 0x55E8, 0x0000, 0x3920, 0x0000,
    0xF45D, 0x0000, 0xBC66, 0x0000, 0xA62F, 0x0000, 0xBB23, 0x0000,
    0xFA03, 0x0000, 0x43DC, 0x0000, 0x5676, 0x0000, 0x3313, 0x0000,
    0x02AA, 0x0000, 0xBC43, 0x0000, 0xA3D4, 0x0000, 0xC79A, 0x0000,
    0xFA13, 0x0000, 0x3838, 0x0000, 0x5A3F, 0x0000, 0x4839, 0x0000,
    0x0025, 0x0000, 0xBFF7, 0x0000, 0xAE3C, 0x0000, 0xC3EF, 0x0000,
    0xFC70, 0x0000, 0x35AC, 0x0000, 0x5CAF, 0x0000, 0x3F2A, 0x0000,
    0xFC6E, 0x0000, 0xBF62, 0x0000, 0xA727, 0x0000, 0xBBE3, 0x0000,
    0xF8E6, 0x0000, 0x4326, 0x0000, 0x58F6, 0x0000, 0x3CF4, 0x0000,
    0x0158, 0x0000, 0xB4D2, 0x0000, 0xA404, 0x0000, 0xBE60, 0x0000,
    0x0A18, 0x0000, 0x405D, 0x0000, 0x57A8, 0x0000, 0x42B9, 0x0000,
    0xFF9C, 0x0000, 0xBFF4, 0x0000, 0x9EC7, 0x0000, 0xBE3D, 0x0000,
    0x0609, 0x0000, 0x425F, 0x0000, 0x5837, 0x0000, 0x3610, 0x0000,
    0xF86C, 0x0000, 0xBABD, 0x0000, 0x9EBC, 0x0000, 0xC396, 0x0000,
    0x04A7, 0x0000, 0x4693, 0x0000, 0x5F5D, 0x0000, 0x3976, 0x0000,
    0xFE00, 0x0000, 0xC74B, 0x0000, 0xA42D, 0x0000, 0xC10E, 0x0000,
    0xF555, 0x0000, 0x3A27, 0x0000, 0x5329, 0x0000, 0x4831, 0x0000,
    0x0570, 0x0000, 0xB9EB, 0x0000, 0xA749, 0x0000, 0xBF8E, 0x0000,
    0x0B9F, 0x0000, 0x3F12, 0x0000, 0x5B1E, 0x0000, 0x402D, 0x0000,
    0xFCE9, 0x0000, 0xC028, 0x0000, 0xA58E, 0x0000, 0xC7E4, 0x0000,
    0xFD9A, 0x0000, 0x45B0, 0x0000, 0x5760, 0x0000, 0x43FC, 0x0000,
    0x036F, 0x0000, 0xCDC6, 0x0000, 0xABE6, 0x0000, 0xC32F, 0x0000,
    0xFF7F, 0x0000, 0x34D3, 0x0000, 0x5E4E, 0x0000, 0x30AF, 0x0000,
    0x016C, 0x0000, 0xC777, 0x0000, 0x9F4F, 0x0000, 0xC29E, 0x0000,
    0x043B, 0x0000, 0x36C8, 0x0000, 0x5D9C, 0x0000, 0x447F, 0x0000,
    0xFA1F, 0x0000, 0xBC0B, 0x0000, 0xA2A2, 0x0000, 0xBB66, 0x0000,
    0x0E6E, 0x0000, 0x3DA7, 0x0000, 0x5595, 0x0000, 0x3C5E, 0x0000,
    0x0766, 0x0000, 0xBB58, 0x0000, 0xA80E, 0x0000, 0xB506, 0x0000,
    0x0693, 0x0000, 0x3A10, 0x0000, 0x551D, 0x0000, 0x3BE9, 0x0000,
    0xFBA4, 0x0000, 0xC760, 0x0000, 0xAB41, 0x0000, 0xC02F, 0x0000,
    0x04E5, 0x0000, 0x43A0, 0x0000, 0x5BBF, 0x0000, 0x47D3, 0x0000,
    0x0460, 0x0000, 0xCDEA, 0x0000, 0xA6A1, 0x0000, 0xC4EE, 0x0000,
    0xFBB9, 0x0000, 0x42D2, 0x0000, 0x5CD1, 0x0000, 0x4C18, 0x0000,
    0x0A00, 0x0000, 0xC3AD, 0x0000, 0x9846, 0x0000, 0xBEA6, 0x0000,
    0xF77D, 0x0000, 0x437E, 0x0000, 0x5AFF, 0x0000, 0x38DB, 0x0000,
    0x0328, 0x0000, 0xB99F, 0x0000, 0xA6AC, 0x0000, 0xC255, 0x0000,
    0xEED8, 0x0000, 0x3B5F, 0x0000, 0x4F72, 0x0000, 0x36A7, 0x0000,
    0x0CB2, 0x0000, 0xC2A6, 0x0000, 0xA42A, 0x0000, 0xB5B5, 0x0000,
    0xFBE4, 0x0000, 0x371F, 0x0000, 0x6265, 0x0000, 0x4768, 0x0000,
    0xEF14, 0x0000, 0xC6F6, 0x0000, 0xA57E, 0x0000, 0xCB92, 0x0000,
    0xFF40, 0x0000, 0x3F69, 0x0000, 0x53E2, 0x0000, 0x3F91, 0x0000,
    0xF69E, 0x0000, 0xB2FD, 0x0000, 0xA7EE, 0x0000, 0xBFF6, 0x0000,
    0xF90E, 0x0000, 0x31EA, 0x0000, 0x5B31, 0x0000, 0x414E, 0x0000,
    0xFFD3, 0x0000, 0xC6A1, 0x0000, 0xA563, 0x0000, 0xC639, 0x0000,
    0xFF5C, 0x0000, 0x41E6, 0x0000, 0x5565, 0x0000, 0x3C64, 0x0000,
    0x0C14, 0x0000, 0xC882, 0x0000, 0xA3AD, 0x0000, 0xBF7C, 0x0000,
    0xFEE3, 0x0000, 0x4268, 0x0000, 0x6A53, 0x0000, 0x3482, 0x0000,
    0x0368, 0x0000, 0xBB75, 0x0000, 0xA6FC, 0x0000, 0xBFA9, 0x0000,
    0xFDC5, 0x0000, 0x4265, 0x0000, 0x5B8B, 0x0000, 0x439B, 0x0000,
    0x03C8, 0x0000, 0xBE49, 0x0000, 0xA976, 0x0000, 0xBE6D, 0x0000,
    0x0193, 0x0000, 0x4122, 0x0000, 0x574C, 0x0000, 0x3A43, 0x0000,
    0xF748, 0x0000, 0xC5F2, 0x0000, 0xA114, 0x0000, 0xB9C0, 0x0000,
    0x0926, 0x0000, 0x440F, 0x0000, 0x559B, 0x0000, 0x3F3C, 0x0000,
    0xEE0E, 0x0000, 0xC776, 0x0000, 0xAF9D, 0x0000, 0xC1A6, 0x0000,
    0xFEF4, 0x0000, 0x3404, 0x0000, 0x6025, 0x0000, 0x476B, 0x0000,
    0x0366, 0x0000, 0xBF76, 0x0000, 0xAA04, 0x0000, 0xC587, 0x0000,
    0xFFCF, 0x0000, 0x3F40, 0x0000, 0x6034, 0x0000, 0x404C, 0x0000,
    0x00EB, 0x0000, 0xCCF2, 0x0000, 0xA61B, 0x0000, 0xC586, 0x0000,
    0xF4F9, 0x0000, 0x3E06, 0x0000, 0x5393, 0x0000, 0x4A6E, 0x0000,
    0x05DA, 0x0000, 0xC64D, 0x0000, 0xA8B9, 0x0000, 0xCCB8, 0x0000,
    0xF907, 0x0000, 0x3B1F, 0x0000, 0x6000, 0x0000, 0x4691, 0x0000,
    0x024A, 0x0000, 0xBDA6, 0x0000, 0xAB54, 0x0000, 0xCCBE, 0x0000,
    0xFE63, 0x0000, 0x43C1, 0x0000, 0x5831, 0x0000, 0x3B99, 0x0000,
    0x008C, 0x0000, 0xBCC0, 0x0000, 0x9BBE, 0x0000, 0xBF76, 0x0000,
    0x0358, 0x0000, 0x49A0, 0x0000, 0x5E94, 0x0000, 0x44E4, 0x0000,
    0x0AE4, 0x0000, 0xC741, 0x0000, 0xA65B, 0x0000, 0xB83E, 0x0000,
    0xF9DF, 0x0000, 0x3C06, 0x0000, 0x5DBB, 0x0000, 0x3F42, 0x0000,
    0x028B, 0x0000, 0xC8ED, 0x0000, 0x9DDB, 0x0000, 0xC7B2, 0x0000,
    0xFADF, 0x0000, 0x3A6D, 0x0000, 0x5E46, 0x0000, 0x43BF, 0x0000,
    0x0033, 0x0000, 0xBD6D, 0x0000, 0xA558, 0x0000, 0xBAB0, 0x0000,
    0xFB8A, 0x0000, 0x3A3F, 0x0000, 0x5836, 0x0000, 0x3FC3, 0x0000,
    0xFEF3, 0x0000, 0xC101, 0x0000, 0xA818, 0x0000, 0xC519, 0x0000,
    0x0BCF, 0x0000, 0x444C, 0x0000, 0x5E47, 0x0000, 0x3FC0, 0x0000,
    0x0617, 0x0000, 0xBC0A, 0x0000, 0xA610, 0x0000, 0xB927, 0x0000,
    0x0204, 0x0000, 0x3D17, 0x0000, 0x5DE3, 0x0000, 0x44AE, 0x0000,
    0x01CA, 0x0000, 0xB836, 0x0000, 0xA814, 0x0000, 0xC1B7, 0x0000,
    0x01B0, 0x0000, 0x3C72, 0x0000, 0x5CF7, 0x0000, 0x422F, 0x0000,
    0xFE2E, 0x0000, 0xBFFC, 0x0000, 0x9A47, 0x0000, 0xC5E9, 0x0000,
    0xF68A, 0x0000, 0x4724, 0x0000, 0x5E9E, 0x0000, 0x3457, 0x0000,
    0x02F4, 0x0000, 0xBB0F, 0x0000, 0xA31F, 0x0000, 0xB75D, 0x0000,
    0xF94B, 0x0000, 0x4042, 0x0000, 0x560F, 0x0000, 0x31FC, 0x0000,
    0x0123, 0x0000, 0xBF84, 0x0000, 0xAD4A, 0x0000, 0xC20B, 0x0000,
    0x0000, 0x0000, 0x42E2, 0x0000, 0x51CC, 0x0000, 0x3CD6, 0x0000,
    0x04E9, 0x0000, 0xCB8B, 0x0000, 0xADB9, 0x0000, 0xC698, 0x0000,
    0xFE1B, 0x0000, 0x3B8B, 0x0000, 0x4D8A, 0x0000, 0x3D30, 0x0000,
    0xF915, 0x0000, 0xC446, 0x0000, 0xABD7, 0x0000, 0xC44D, 0x0000,
    0x0166, 0x0000, 0x435C, 0x0000, 0x580D, 0x0000, 0x3C69, 0x0000,
    0xFB0E, 0x0000, 0xB5F7, 0x0000, 0x9FDF, 0x0000, 0xC025, 0x0000,
    0xFE2D, 0x0000, 0x4239, 0x0000, 0x66AF, 0x0000, 0x3CC2, 0x0000,
    0xFC2A, 0x0000, 0xBFFD, 0x0000, 0xA7FC, 0x0000, 0xC83B, 0x0000,
    0xF710, 0x0000, 0x33FB, 0x0000, 0x5173, 0x0000, 0x3B3B, 0x0000,
    0x0347, 0x0000, 0xB6F0, 0x0000, 0xA249, 0x0000, 0xC3E5, 0x0000,
    0xF628, 0x0000, 0x41D3, 0x0000, 0x6141, 0x0000, 0x3C17, 0x0000,
    0x05F8, 0x0000, 0xBCBD, 0x0000, 0xA651, 0x0000, 0xC477, 0x0000,
    0xF7CC, 0x0000, 0x3B28, 0x0000, 0x568E, 0x0000, 0x40B5, 0x0000,
    0x09B1, 0x0000, 0xCFE6, 0x0000, 0xB11F, 0x0000, 0xB5CB, 0x0000,
    0xF944, 0x0000, 0x34C2, 0x0000, 0x587D, 0x0000, 0x3C33, 0x0000,
    0x0A34, 0x0000, 0xC383, 0x0000, 0xADD3, 0x0000, 0xC205, 0x0000,
    0xF465, 0x0000, 0x31E6, 0x0000, 0x59A2, 0x0000, 0x40A8, 0x0000,
    0xFE99, 0x0000, 0xB7DD, 0x0000, 0x9ECE, 0x0000, 0xC0BB, 0x0000,
    0x03FD, 0x0000, 0x48BB, 0x0000, 0x5526, 0x0000, 0x3FD6, 0x0000,
    0xF62D, 0x0000, 0xC034, 0x0000, 0xAA4E, 0x0000, 0xBC8B, 0x0000,
    0x00B1, 0x0000, 0x3C16, 0x0000, 0x55C0, 0x0000, 0x4461, 0x0000,
    0xFAE9, 0x0000, 0xB416, 0x0000, 0xA879, 0x0000, 0xC296, 0x0000,
    0xFE59, 0x0000, 0x3E95, 0x0000, 0x62DF, 0x0000, 0x429A, 0x0000,
    0xF2E2, 0x0000, 0xBE3D, 0x0000, 0xAFE8, 0x0000, 0xBF19, 0x0000,
    0xF9B4, 0x0000, 0x420D, 0x0000, 0x4CF4, 0x0000, 0x4323, 0x0000,
    0xFFA1, 0x0000, 0xBB3F, 0x0000, 0xAA6B, 0x0000, 0xC49D, 0x0000,
    0x03FC, 0x0000, 0x3AC7, 0x0000, 0x510E, 0x0000, 0x4658, 0x0000,
    0x000B, 0x0000, 0xC67D, 0x0000, 0xA696, 0x0000, 0xBF53, 0x0000,
    0x01AF, 0x0000, 0x3F1A, 0x0000, 0x5F52, 0x0000, 0x3B52, 0x0000,
    0xFB7E, 0x0000, 0xC649, 0x0000, 0xB46C, 0x0000, 0xC877, 0x0000,
    0xFD7D, 0x0000, 0x3EB9, 0x0000, 0x5B92, 0x0000, 0x3E79, 0x0000,
    0xFEE3, 0x0000, 0xC60B, 0x0000, 0xAAD6, 0x0000, 0xBD04, 0x0000,
    0x06C7, 0x0000, 0x3E2E, 0x0000, 0x4AAF, 0x0000, 0x4225, 0x0000,
    0xFFA7, 0x0000, 0xBC87, 0x0000, 0xAEF7, 0x0000, 0xC23F, 0x0000,
    0xF7B6, 0x0000, 0x3B20, 0x0000, 0x5E42, 0x0000, 0x4092, 0x0000,
    0x02F4, 0x0000, 0xC4A6, 0x0000, 0xA42A, 0x0000, 0xC387, 0x0000,
    0xFEC5, 0x0000, 0x4933, 0x0000, 0x5DAF, 0x0000, 0x3E2D, 0x0000,
    0x0150, 0x0000, 0xC6BB, 0x0000, 0xA85C, 0x0000, 0xC0B7, 0x0000,
    0x05A8, 0x0000, 0x3DD8, 0x0000, 0x53B5, 0x0000, 0x41E9, 0x0000,
    0xF7E4, 0x0000, 0xBA91, 0x0000, 0xA536, 0x0000, 0xC770, 0x0000,
    0x094B, 0x0000, 0x3CBF, 0x0000, 0x5BE8, 0x0000, 0x40BC, 0x0000,
    0xF567, 0x0000, 0xC0FE, 0x0000, 0xAC4B, 0x0000, 0xB967, 0x0000,
    0xFC3A, 0x0000, 0x487C, 0x0000, 0x5556, 0x0000, 0x371D, 0x0000,
    0x05B8, 0x0000, 0xC348, 0x0000, 0xAB15, 0x0000, 0xBA86, 0x0000,
    0x053D, 0x0000, 0x4198, 0x0000, 0x5FD3, 0x0000, 0x4529, 0x0000,
    0x0AB1, 0x0000, 0xC070, 0x0000, 0x9FA0, 0x0000, 0xBF21, 0x0000,
    0x12CE, 0x0000, 0x36C0, 0x0000, 0x5722, 0x0000, 0x40A7, 0x0000,
    0xF758, 0x0000, 0xBD1F, 0x0000, 0xA332, 0x0000, 0xBEA3, 0x0000,
    0x0456, 0x0000, 0x403B, 0x0000, 0x5AC8, 0x0000, 0x4252, 0x0000,
    0x019E, 0x0000, 0xC10F, 0x0000, 0xA649, 0x0000, 0xC492, 0x0000,
    0x0064, 0x0000, 0x41E7, 0x0000, 0x5765, 0x0000, 0x50B8, 0x0000,
    0x0495, 0x0000, 0xC3AB, 0x0000, 0xA828, 0x0000, 0xC8F8, 0x0000,
    0xF237, 0x0000, 0x3FD0, 0x0000, 0x578E, 0x0000, 0x3EE6, 0x0000,
    0x027D, 0x0000, 0xC42B, 0x0000, 0xB816, 0x0000, 0xBE23, 0x0000,
    0x019A, 0x0000, 0x3649, 0x0000, 0x470E, 0x0000, 0x4415, 0x0000,
    0xFD75, 0x0000, 0xBB72, 0x0000, 0xA643, 0x0000, 0xC6A7, 0x0000,
    0xFDA5, 0x0000, 0x37FB, 0x0000, 0x5DA8, 0x0000, 0x438E, 0x0000,
    0xFEFC, 0x0000, 0xB90A, 0x0000, 0xA3E6, 0x0000, 0xBF5F, 0x0000,
    0xFFE7, 0x0000, 0x4A64, 0x0000, 0x6556, 0x0000, 0x4AC7, 0x0000,
    0x007E, 0x0000, 0xC315, 0x0000, 0xB056, 0x0000, 0xC4AE, 0x0000,
    0x0935, 0x0000, 0x40B8, 0x0000, 0x5FE4, 0x0000, 0x48C7, 0x0000,
    0x0D2D, 0x0000, 0xC103, 0x0000, 0x9FCF, 0x0000, 0xBCBF, 0x0000,
    0xFFB8, 0x0000, 0x4821, 0x0000, 0x5A10, 0x0000, 0x46A1, 0x0000,
    0x093F, 0x0000, 0xBE61, 0x0000, 0xB1E0, 0x0000, 0xB92A, 0x0000,
    0x0444, 0x0000, 0x411C, 0x0000, 0x4D23, 0x0000, 0x3F9A, 0x0000,
    0xFB6F, 0x0000, 0xBAD0, 0x0000, 0xA7DD, 0x0000, 0xBDB0, 0x0000,
    0x08CA, 0x0000, 0x42DB, 0x0000, 0x5C2B, 0x0000, 0x40F7, 0x0000,
    0x05BC, 0x0000, 0xC919, 0x0000, 0x9D5A, 0x0000, 0xC1C7, 0x0000,
    0x0AE3, 0x0000, 0x3DEF, 0x0000, 0x5C78, 0x0000, 0x35FF, 0x0000,
    0xFFAA, 0x0000, 0xC4A5, 0x0000, 0xA33A, 0x0000, 0xBD1F, 0x0000,
    0xFBE1, 0x0000, 0x2C3E, 0x0000, 0x6226, 0x0000, 0x3D81, 0x0000,
    0x04F9, 0x0000, 0xC5DF, 0x0000, 0xA33B, 0x0000, 0xBBDD, 0x0000,
    0x04C9, 0x0000, 0x3D9F, 0x0000, 0x4E97, 0x0000, 0x46A1, 0x0000,
    0x0315, 0x0000, 0xC339, 0x0000, 0xABA2, 0x0000, 0xBB1C, 0x0000,
    0x0023, 0x0000, 0x3C55, 0x0000, 0x611B, 0x0000, 0x313D, 0x0000,
    0x03D9, 0x0000, 0xC633, 0x0000, 0xA982, 0x0000, 0xC22E, 0x0000,
    0x0804, 0x0000, 0x4DA4, 0x0000, 0x5D5F, 0x0000, 0x43D8, 0x0000,
    0xFAEA, 0x0000, 0xC5E5, 0x0000, 0xA809, 0x0000, 0xB9A1, 0x0000,
    0xFE46, 0x0000, 0x451F, 0x0000, 0x5BD1, 0x0000, 0x3F2B, 0x0000,
    0xF9E1, 0x0000, 0xC7C5, 0x0000, 0xAABC, 0x0000, 0xBB6F, 0x0000,
    0x0127, 0x0000, 0x3AFD, 0x0000, 0x5538, 0x0000, 0x3679, 0x0000,
    0xF86E, 0x0000, 0xC3BD, 0x0000, 0xA612, 0x0000, 0xBDB1, 0x0000,
    0xF3C7, 0x0000, 0x42F8, 0x0000, 0x5396, 0x0000, 0x3B44, 0x0000,
    0x05A3, 0x0000, 0xC8F5, 0x0000, 0xAA86, 0x0000, 0xB560, 0x0000,
    0xFC9C, 0x0000, 0x423F, 0x0000, 0x5919, 0x0000, 0x3E59, 0x0000,
    0xFFF9, 0x0000, 0xB873, 0x0000, 0xB38C, 0x0000, 0xB784, 0x0000,
    0xFFFC, 0x0000, 0x36B4, 0x0000, 0x5663, 0x0000, 0x3BCC, 0x0000,
    0xFF33, 0x0000, 0xC22D, 0x0000, 0xA88C, 0x0000, 0xC4DE, 0x0000,
    0x162B, 0x0000, 0x463D, 0x0000, 0x6541, 0x0000, 0x4DE6, 0x0000,
    0xFE05, 0x0000, 0xB6B8, 0x0000, 0xB19B, 0x0000, 0xC434, 0x0000,
    0xFEE8, 0x0000, 0x3AEC, 0x0000, 0x5AF9, 0x0000, 0x4568, 0x0000,
    0x04C8, 0x0000, 0xBA6D, 0x0000, 0xAF9A, 0x0000, 0xBBD1, 0x0000,
    0xFD9D, 0x0000, 0x3CA5, 0x0000, 0x5EDE, 0x0000, 0x2E0A, 0x0000,
    0xFA87, 0x0000, 0xBC4B, 0x0000, 0xA1F3, 0x0000, 0xC450, 0x0000,
    0x084C, 0x0000, 0x450E, 0x0000, 0x51DA, 0x0000, 0x4407, 0x0000,
    0xFE4D, 0x0000, 0xC6D7, 0x0000, 0xA131, 0x0000, 0xC32D, 0x0000,
    0xFE5D, 0x0000, 0x3B58, 0x0000, 0x58EA, 0x0000, 0x4175, 0x0000,
    0x010C, 0x0000, 0xCB23, 0x0000, 0xA6CD, 0x0000, 0xB7CA, 0x0000,
    0x071E, 0x0000, 0x46C4, 0x0000, 0x5A35, 0x0000, 0x4329, 0x0000,
    0x025B, 0x0000, 0xBF6E, 0x0000, 0xA6B3, 0x0000, 0xC5F9, 0x0000,
    0xFB30, 0x0000, 0x3EEB, 0x0000, 0x5A30, 0x0000, 0x4214, 0x0000,
    0xFE2D, 0x0000, 0xB1A0, 0x0000, 0xAA77, 0x0000, 0xC478, 0x0000,
    0xFD82, 0x0000, 0x40CA, 0x0000, 0x4C5E, 0x0000, 0x3C9C, 0x0000,
    0x08F1, 0x0000, 0xBC68, 0x0000, 0xA006, 0x0000, 0xC374, 0x0000,
    0x0C39, 0x0000, 0x48BE, 0x0000, 0x5D76, 0x0000, 0x398D, 0x0000,
    0x15F0, 0x0000, 0xBF83, 0x0000, 0xA842, 0x0000, 0xC6ED, 0x0000,
    0x020F, 0x0000, 0x398A, 0x0000, 0x5988, 0x0000, 0x45D2, 0x0000,
    0x0318, 0x0000, 0xC27C, 0x0000, 0xA459, 0x0000, 0xB740, 0x0000,
    0x0B35, 0x0000, 0x3BA0, 0x0000, 0x6811, 0x0000, 0x3C7A, 0x0000,
    0x0DD6, 0x0000, 0xC274, 0x0000, 0x9BFB, 0x0000, 0xB868, 0x0000,
    0xF766, 0x0000, 0x426D, 0x0000, 0x51A0, 0x0000, 0x39CF, 0x0000,
    0x03C8, 0x0000, 0xBFFC, 0x0000, 0xA0E0, 0x0000, 0xC7AB, 0x0000,
    0x0563, 0x0000, 0x35CE, 0x0000, 0x67B1, 0x0000, 0x3F37, 0x0000,
    0xF8E4, 0x0000, 0xC21F, 0x0000, 0x9F8F, 0x0000, 0xCC04, 0x0000,
    0x006C, 0x0000, 0x3EE4, 0x0000, 0x5D72, 0x0000, 0x39FF, 0x0000,
    0xFFAB, 0x0000, 0xB54D, 0x0000, 0x9FC5, 0x0000, 0xC7E5, 0x0000,
    0xFF67, 0x0000, 0x3B61, 0x0000, 0x55DA, 0x0000, 0x42C3, 0x0000,
    0xF7F2, 0x0000, 0xBEDF, 0x0000, 0x9A67, 0x0000, 0xBB54, 0x0000,
    0x0267, 0x0000, 0x4660, 0x0000, 0x5BF5, 0x0000, 0x3F40, 0x0000,
    0x0FD2, 0x0000, 0xBAD1, 0x0000, 0xA66B, 0x0000, 0xC158, 0x0000,
    0xFE42, 0x0000, 0x44D4, 0x0000, 0x5B9C, 0x0000, 0x3750, 0x0000,
    0x0320, 0x0000, 0xB505, 0x0000, 0xA5AA, 0x0000, 0xBB6B, 0x0000,
    0xFC8D, 0x0000, 0x3A77, 0x0000, 0x60EF, 0x0000, 0x3637, 0x0000,
    0xFD33, 0x0000, 0xBF22, 0x0000, 0xA2FC, 0x0000, 0xBD60, 0x0000,
    0x02E2, 0x0000, 0x3FAC, 0x0000, 0x654B, 0x0000, 0x4796, 0x0000,
    0xFA30, 0x0000, 0xBF77, 0x0000, 0x94B9, 0x0000, 0xBE5A, 0x0000,
    0x032C, 0x0000, 0x4984, 0x0000, 0x6808, 0x0000, 0x4B51, 0x0000,
    0xFD7E, 0x0000, 0xC3AF, 0x0000, 0xA454, 0x0000, 0xC08A, 0x0000,
    0xF9F4, 0x0000, 0x40EB, 0x0000, 0x5C4E, 0x0000, 0x440B, 0x0000,
    0xFD65, 0x0000, 0xBA7C, 0x0000, 0xB190, 0x0000, 0xC357, 0x0000,
    0x029F, 0x0000, 0x37C9, 0x0000, 0x5A48, 0x0000, 0x3BAF, 0x0000,
    0xFF8C, 0x0000, 0xB326, 0x0000, 0xA6C2, 0x0000, 0xBC72, 0x0000,
    0xFA2E, 0x0000, 0x3EAC, 0x0000, 0x5DE8, 0x0000, 0x3F83, 0x0000,
    0xFD67, 0x0000, 0xB63E, 0x0000, 0xB103, 0x0000, 0xBDF5, 0x0000,
    0xF765, 0x0000, 0x43E9, 0x0000, 0x6450, 0x0000, 0x374A, 0x0000,
    0xFEEE, 0x0000, 0xCB32, 0x0000, 0xAB56, 0x0000, 0xC9A3, 0x0000,
    0xFC68, 0x0000, 0x3F9F, 0x0000, 0x5FF9, 0x0000, 0x42BA, 0x0000,
    0xF8B6, 0x0000, 0xC74E, 0x0000, 0xA549, 0x0000, 0xCA5A, 0x0000,
    0xFB96, 0x0000, 0x4456, 0x0000, 0x5965, 0x0000, 0x4A1D, 0x0000,
    0xF6E5, 0x0000, 0xB970, 0x0000, 0xABA6, 0x0000, 0xB2EF, 0x0000,
    0x03A4, 0x0000, 0x40B3, 0x0000, 0x5E09, 0x0000, 0x3D71, 0x0000,
    0xFE2F, 0x0000, 0xCF9E, 0x0000, 0xA3F3, 0x0000, 0xCCCA, 0x0000,
    0xF746, 0x0000, 0x36C1, 0x0000, 0x5445, 0x0000, 0x3E7D, 0x0000,
    0xFE41, 0x0000, 0xC02D, 0x0000, 0xA69E, 0x0000, 0xB9D7, 0x0000,
    0xF83D, 0x0000, 0x452A, 0x0000, 0x5D05, 0x0000, 0x3D5D, 0x0000,
    0x08C8, 0x0000, 0xC515, 0x0000, 0xA123, 0x0000, 0xBB93, 0x0000,
    0xF7E5, 0x0000, 0x4586, 0x0000, 0x5CF4, 0x0000, 0x3FEB, 0x0000,
    0x0AD5, 0x0000, 0xC4D5, 0x0000, 0x9F74, 0x0000, 0xC3A9, 0x0000,
    0x0960, 0x0000, 0x402C, 0x0000, 0x57CA, 0x0000, 0x4B91, 0x0000,
    0xFFE6, 0x0000, 0xBA70, 0x0000, 0xA4AE, 0x0000, 0xC1F6, 0x0000,
    0xFCDB, 0x0000, 0x428F, 0x0000, 0x60ED, 0x0000, 0x4BF1, 0x0000,
    0xFE96, 0x0000, 0xC3BA, 0x0000, 0xB3A5, 0x0000, 0xC0C7, 0x0000,
    0x002D, 0x0000, 0x3A4A, 0x0000, 0x524A, 0x0000, 0x392A, 0x0000,
    0xF404, 0x0000, 0xC063, 0x0000, 0xA284, 0x0000, 0xBCF9, 0x0000,
    0x0543, 0x0000, 0x454C, 0x0000, 0x4C03, 0x0000, 0x458B, 0x0000,
    0xF8D3, 0x0000, 0xB9FA, 0x0000, 0xAABF, 0x0000, 0xC502, 0x0000,
    0x03F1, 0x0000, 0x3239, 0x0000, 0x580C, 0x0000, 0x41BE, 0x0000,
    0x0057, 0x0000, 0xC090, 0x0000, 0xA908, 0x0000, 0xC5A0, 0x0000,
    0xFDDE, 0x0000, 0x4023, 0x0000, 0x576D, 0x0000, 0x356C, 0x0000,
    0xFD78, 0x0000, 0xBE7D, 0x0000, 0xA311, 0x0000, 0xBFB2, 0x0000,
    0xFED5, 0x0000, 0x3DF9, 0x0000, 0x50D4, 0x0000, 0x4014, 0x0000,
    0x02D0, 0x0000, 0xB7D7, 0x0000, 0xA316, 0x0000, 0xCB86, 0x0000,
    0xFFA0, 0x0000, 0x4440, 0x0000, 0x59C9, 0x0000, 0x45A1, 0x0000,
    0xFE90, 0x0000, 0xC6D7, 0x0000, 0xA179, 0x0000, 0xC89E, 0x0000,
    0xFB4F, 0x0000, 0x3F45, 0x0000, 0x620C, 0x0000, 0x4629, 0x0000,
    0x0A40, 0x0000, 0xC4D5, 0x0000, 0xAA8A, 0x0000, 0xC414, 0x0000,
    0xF730, 0x0000, 0x3CB7, 0x0000, 0x5F17, 0x0000, 0x3C61, 0x0000,
    0xFFA3, 0x0000, 0xB75A, 0x0000, 0xA1BC, 0x0000, 0xC4E6, 0x0000,
    0x06A3, 0x0000, 0x3D89, 0x0000, 0x5D9D, 0x0000, 0x39C8, 0x0000,
    0xFA2C, 0x0000, 0xB8B4, 0x0000, 0xAAB2, 0x0000, 0xBF82, 0x0000,
    0x02DF, 0x0000, 0x41D2, 0x0000, 0x5357, 0x0000, 0x46DF, 0x0000,
    0x01E0, 0x0000, 0xB99E, 0x0000, 0xA88E, 0x0000, 0xC1DC, 0x0000,
    0x0767, 0x0000, 0x3E36, 0x0000, 0x567E, 0x0000, 0x3BAD, 0x0000,
    0x00C7, 0x0000, 0xBF13, 0x0000, 0xABB0, 0x0000, 0xBAC3, 0x0000,
    0xFE54, 0x0000, 0x41D3, 0x0000, 0x4FBB, 0x0000, 0x4C72, 0x0000,
    0x0050, 0x0000, 0xC72A, 0x0000, 0xA40F, 0x0000, 0xBED6, 0x0000,
    0x0CD4, 0x0000, 0x3F8D, 0x0000, 0x545E, 0x0000, 0x39C6, 0x0000,
    0x00D1, 0x0000, 0xBC93, 0x0000, 0xA4AE, 0x0000, 0xC3F6, 0x0000,
    0xF8E0, 0x0000, 0x4204, 0x0000, 0x5B70, 0x0000, 0x4BC7, 0x0000,
    0xF84B, 0x0000, 0xC268, 0x0000, 0xA598, 0x0000, 0xBF53, 0x0000,
    0x0576, 0x0000, 0x3FF6, 0x0000, 0x5EAA, 0x0000, 0x3F0F, 0x0000,
    0x0AE0, 0x0000, 0xBC0A, 0x0000, 0xA2CD, 0x0000, 0xB5D1, 0x0000,
    0x084C, 0x0000, 0x33C8, 0x0000, 0x5754, 0x0000, 0x38E8, 0x0000,
    0xFEEB, 0x0000, 0xC409, 0x0000, 0x9D16, 0x0000, 0xC4FE, 0x0000,
    0x0986, 0x0000, 0x458B, 0x0000, 0x59A3, 0x0000, 0x4611, 0x0000,
    0xFFBF, 0x0000, 0xBCEB, 0x0000, 0x9658, 0x0000, 0xBC3B, 0x0000,
    0xFC0E, 0x0000, 0x3DD4, 0x0000, 0x62B0, 0x0000, 0x4034, 0x0000,
    0xFDFC, 0x0000, 0xC924, 0x0000, 0xA603, 0x0000, 0xC15E, 0x0000,
    0x0141, 0x0000, 0x3943, 0x0000, 0x5942, 0x0000, 0x48E1, 0x0000,
    0xF577, 0x0000, 0xC79E, 0x0000, 0xA018, 0x0000, 0xB378, 0x0000,
    0xFDB6, 0x0000, 0x40C0, 0x0000, 0x582B, 0x0000, 0x3EC8, 0x0000,
    0xFD1B, 0x0000, 0xC04A, 0x0000, 0xB2A9, 0x0000, 0xC0C7, 0x0000,
    0x025C, 0x0000, 0x3895, 0x0000, 0x5ED7, 0x0000, 0x3E6A, 0x0000,
    0x0A6C, 0x0000, 0xB9E7, 0x0000, 0xA8E6, 0x0000, 0xC387, 0x0000,
    0xFA80, 0x0000, 0x417E, 0x0000, 0x5B2C, 0x0000, 0x3C09, 0x0000,
    0x0A22, 0x0000, 0xC2F1, 0x0000, 0xA788, 0x0000, 0xC13E, 0x0000,
    0x0549, 0x0000, 0x4FCE, 0x0000, 0x56C7, 0x0000, 0x35CF, 0x0000,
    0x0405, 0x0000, 0xC00C, 0x0000, 0xA8E9, 0x0000, 0xC37A, 0x0000,
    0xFDCE, 0x0000, 0x3862, 0x0000, 0x5FCC, 0x0000, 0x3519, 0x0000,
    0xFD66, 0x0000, 0xBD3C, 0x0000, 0xA82D, 0x0000, 0xC2D4, 0x0000,
    0xFA3B, 0x0000, 0x42C3, 0x0000, 0x5DAC, 0x0000, 0x4180, 0x0000,
    0xFAAD, 0x0000, 0xBBF0, 0x0000, 0xA65C, 0x0000, 0xC80A, 0x0000,
    0x061F, 0x0000, 0x3A9B, 0x0000, 0x547A, 0x0000, 0x386F, 0x0000,
    0x0844, 0x0000, 0xC0AE, 0x0000, 0xAFBC, 0x0000, 0xC3CA, 0x0000,
    0x032F, 0x0000, 0x4A6D, 0x0000, 0x538D, 0x0000, 0x3428, 0x0000,
    0xFA4F, 0x0000, 0xB7E5, 0x0000, 0xAEF4, 0x0000, 0xBD0D, 0x0000,
    0x0BEE, 0x0000, 0x3F74, 0x0000, 0x5C57, 0x0000, 0x37A5, 0x0000,
    0x013C, 0x0000, 0xBC72, 0x0000, 0xAD81, 0x0000, 0xBE63, 0x0000,
    0x0186, 0x0000, 0x4157, 0x0000, 0x5F5B, 0x0000, 0x4954, 0x0000,
    0xF6A7, 0x0000, 0xB7A0, 0x0000, 0xA071, 0x0000, 0xB7CF, 0x0000,
    0x14BC, 0x0000, 0x4C34, 0x0000, 0x5E47, 0x0000, 0x3C71, 0x0000,
    0xFD21, 0x0000, 0xC438, 0x0000, 0x9D74, 0x0000, 0xC044, 0x0000,
    0xFF07, 0x0000, 0x3F64, 0x0000, 0x5760, 0x0000, 0x46AB, 0x0000,
    0xFF5F, 0x0000, 0xBAA1, 0x0000, 0xAF76, 0x0000, 0xC178, 0x0000,
    0x02C0, 0x0000, 0x4108, 0x0000, 0x5345, 0x0000, 0x414C, 0x0000,
    0xFE48, 0x0000, 0xBE11, 0x0000, 0xA91C, 0x0000, 0xC370, 0x0000,
    0xFF93, 0x0000, 0x4249, 0x0000, 0x5903, 0x0000, 0x3C2E, 0x0000,
    0x046A, 0x0000, 0xBF59, 0x0000, 0xA8DD, 0x0000, 0xCAE3, 0x0000,
    0xFACA, 0x0000, 0x3EF7, 0x0000, 0x4BEE, 0x0000, 0x4B7E, 0x0000,
    0x0256, 0x0000, 0xBDCE, 0x0000, 0x9FE7, 0x0000, 0xD1A9, 0x0000,
    0xFC81, 0x0000, 0x47FA, 0x0000, 0x58F0, 0x0000, 0x2D57, 0x0000,
    0xFFF7, 0x0000, 0xC570, 0x0000, 0xA777, 0x0000, 0xBA89, 0x0000,
    0xEFDC, 0x0000, 0x3CA6, 0x0000, 0x624B, 0x0000, 0x39F7, 0x0000,
    0x0A88, 0x0000, 0xCCDC, 0x0000, 0xA718, 0x0000, 0xCAD6, 0x0000,
    0xF50D, 0x0000, 0x406E, 0x0000, 0x5058, 0x0000, 0x3EA4, 0x0000,
    0x0F8F, 0x0000, 0xBD34, 0x0000, 0xA9F8, 0x0000, 0xD459, 0x0000,
    0x023C, 0x0000, 0x4697, 0x0000, 0x51D7, 0x0000, 0x3EA5, 0x0000,
    0xFECC, 0x0000, 0xBA0A, 0x0000, 0xB071, 0x0000, 0xC245, 0x0000,
    0xF999, 0x0000, 0x3F77, 0x0000, 0x51F6, 0x0000, 0x4143, 0x0000,
    0x00FB, 0x0000, 0xC505, 0x0000, 0xA367, 0x0000, 0xB628, 0x0000,
    0x09FE, 0x0000, 0x3FDA, 0x0000, 0x52A1, 0x0000, 0x3518, 0x0000,
    0xFEAB, 0x0000, 0xC39B, 0x0000, 0xA61D, 0x0000, 0xAE24, 0x0000,
    0xFAE5, 0x0000, 0x3E91, 0x0000, 0x51E7, 0x0000, 0x3ABD, 0x0000,
    0xF6D6, 0x0000, 0xC4B0, 0x0000, 0xAAC8, 0x0000, 0xC775, 0x0000,
    0xF4E2, 0x0000, 0x4404, 0x0000, 0x5529, 0x0000, 0x3E55, 0x0000,
    0x0AB2, 0x0000, 0xC3D2, 0x0000, 0x9FF2, 0x0000, 0xB69B, 0x0000,
    0xFC53, 0x0000, 0x418E, 0x0000, 0x5B90, 0x0000, 0x4B1D, 0x0000,
    0xFECB, 0x0000, 0xC93C, 0x0000, 0xA72D, 0x0000, 0xC909, 0x0000,
    0xF954, 0x0000, 0x401E, 0x0000, 0x5B8B, 0x0000, 0x3FD2, 0x0000,
    0x0793, 0x0000, 0xB718, 0x0000, 0x9C46, 0x0000, 0xBFA8, 0x0000,
    0xFB42, 0x0000, 0x4043, 0x0000, 0x5679, 0x0000, 0x3FAB, 0x0000,
    0x09C6, 0x0000, 0xBAB4, 0x0000, 0xA3A4, 0x0000, 0xC240, 0x0000,
    0xF8B3, 0x0000, 0x3AC6, 0x0000, 0x5CA2, 0x0000, 0x4C9A, 0x0000,
    0xFC93, 0x0000, 0xC2E0, 0x0000, 0xA982, 0x0000, 0xB833, 0x0000,
    0xFE5E, 0x0000, 0x438B, 0x0000, 0x630D, 0x0000, 0x38EB, 0x0000,
    0x08D1, 0x0000, 0xBD06, 0x0000, 0xAAEE, 0x0000, 0xBE1D, 0x0000,
    0x0996, 0x0000, 0x38E4, 0x0000, 0x587B, 0x0000, 0x401C, 0x0000,
    0x0128, 0x0000, 0xC20F, 0x0000, 0xAC47, 0x0000, 0xBA39, 0x0000,
    0x0282, 0x0000, 0x388D, 0x0000, 0x612F, 0x0000, 0x3DD9, 0x0000,
    0xF464, 0x0000, 0xC8EB, 0x0000, 0xAA39, 0x0000, 0xC7EE, 0x0000,
    0x0394, 0x0000, 0x43D9, 0x0000, 0x51DC, 0x0000, 0x3A5C, 0x0000,
    0xF691, 0x0000, 0xB3E1, 0x0000, 0xAC33, 0x0000, 0xC481, 0x0000,
    0x0BA0, 0x0000, 0x3FD8, 0x0000, 0x5ACF, 0x0000, 0x4307, 0x0000,
    0x0163, 0x0000, 0xBF74, 0x0000, 0xA2F5, 0x0000, 0xBC9D, 0x0000,
    0xF5D4, 0x0000, 0x3DC9, 0x0000, 0x5F98, 0x0000, 0x3DD6, 0x0000,
    0xFFA9, 0x0000, 0xBB1F, 0x0000, 0xA714, 0x0000, 0xBAB3, 0x0000,
    0xFA31, 0x0000, 0x329D, 0x0000, 0x5900, 0x0000, 0x41E8, 0x0000,
    0xFB5F, 0x0000, 0xC936, 0x0000, 0xAA9D, 0x0000, 0xCCE0, 0x0000,
    0xFEAE, 0x0000, 0x4013, 0x0000, 0x5917, 0x0000, 0x3AB4, 0x0000,
    0x0452, 0x0000, 0xB600, 0x0000, 0xA501, 0x0000, 0xB4E5, 0x0000,
    0xF71E, 0x0000, 0x3C99, 0x0000, 0x5BBC, 0x0000, 0x4213, 0x0000,
    0x0238, 0x0000, 0xC600, 0x0000, 0xA55B, 0x0000, 0xC76F, 0x0000,
    0x0B06, 0x0000, 0x3A48, 0x0000, 0x5EDF, 0x0000, 0x460C, 0x0000,
    0x0515, 0x0000, 0xC44F, 0x0000, 0xA246, 0x0000, 0xC06C, 0x0000,
    0x0473, 0x0000, 0x3F4C, 0x0000, 0x566A, 0x0000, 0x3995, 0x0000,
    0x053D, 0x0000, 0xBEC4, 0x0000, 0xAAA6, 0x0000, 0xC286, 0x0000,
    0xFAE7, 0x0000, 0x3F2A, 0x0000, 0x56A2, 0x0000, 0x3C14, 0x0000,
    0x068B, 0x0000, 0xD2DA, 0x0000, 0xA27D, 0x0000, 0xBD3F, 0x0000,
    0x029B, 0x0000, 0x4223, 0x0000, 0x53E2, 0x0000, 0x3E4E, 0x0000,
    0x03AD, 0x0000, 0xBFBE, 0x0000, 0xAC04, 0x0000, 0xB90C, 0x0000,
    0xFE4A, 0x0000, 0x4366, 0x0000, 0x56E8, 0x0000, 0x4346, 0x0000,
    0xF198, 0x0000, 0xBD85, 0x0000, 0x9F83, 0x0000, 0xBBB0, 0x0000,
    0xFB12, 0x0000, 0x3F33, 0x0000, 0x59DF, 0x0000, 0x4794, 0x0000,
    0xFC17, 0x0000, 0xCB0A, 0x0000, 0xA193, 0x0000, 0xB9E4, 0x0000,
    0x035A, 0x0000, 0x4C25, 0x0000, 0x4F80, 0x0000, 0x3766, 0x0000,
    0x0231, 0x0000, 0xC00F, 0x0000, 0xA88A, 0x0000, 0xCB00, 0x0000,
    0x0562, 0x0000, 0x399A, 0x0000, 0x59C2, 0x0000, 0x40D4, 0x0000,
    0x033F, 0x0000, 0xB5BE, 0x0000, 0xA667, 0x0000, 0xBDD4, 0x0000,
    0xFB7A, 0x0000, 0x2EE3, 0x0000, 0x5949, 0x0000, 0x4149, 0x0000,
    0xFFC3, 0x0000, 0xC274, 0x0000, 0x987A, 0x0000, 0xBC35, 0x0000,
    0x0216, 0x0000, 0x4156, 0x0000, 0x4CC6, 0x0000, 0x48EB, 0x0000,
    0xF6D1, 0x0000, 0xBAAB, 0x0000, 0xB14D, 0x0000, 0xBA6D, 0x0000,
    0x0101, 0x0000, 0x42C4, 0x0000, 0x5E92, 0x0000, 0x4037, 0x0000,
    0x002B, 0x0000, 0xC249, 0x0000, 0xAA52, 0x0000, 0xCADA, 0x0000,
    0x05D1, 0x0000, 0x398A, 0x0000, 0x5766, 0x0000, 0x4283, 0x0000,
    0xFE3E, 0x0000, 0xBC73, 0x0000, 0xA9CF, 0x0000, 0xC843, 0x0000,
    0x0B78, 0x0000, 0x3C1F, 0x0000, 0x532B, 0x0000, 0x3AC2, 0x0000,
    0xFE83, 0x0000, 0xC37E, 0x0000, 0x9D98, 0x0000, 0xC31E, 0x0000,
    0x035E, 0x0000, 0x3B9C, 0x0000, 0x52DF, 0x0000, 0x46B7, 0x0000,
    0xFF31, 0x0000, 0xC002, 0x0000, 0xA31A, 0x0000, 0xBF71, 0x0000,
    0xEFF0, 0x0000, 0x416D, 0x0000, 0x5831, 0x0000, 0x43B5, 0x0000,
    0x0655, 0x0000, 0xC13F, 0x0000, 0xB2A8, 0x0000, 0xC00B, 0x0000,
    0xFD0F, 0x0000, 0x3BFE, 0x0000, 0x5AD8, 0x0000, 0x42D3, 0x0000,
    0x0C0A, 0x0000, 0xC7DA, 0x0000, 0xA467, 0x0000, 0xC079, 0x0000,
    0xFE69, 0x0000, 0x37B4, 0x0000, 0x6A2F, 0x0000, 0x4C5E, 0x0000,
    0xF6DC, 0x0000, 0xC9A5, 0x0000, 0xAF82, 0x0000, 0xC343, 0x0000,
    0x0ACF, 0x0000, 0x3544, 0x0000, 0x54F6, 0x0000, 0x3F9F, 0x0000,
    0x03CC, 0x0000, 0xBF74, 0x0000, 0x9C1A, 0x0000, 0xC1F3, 0x0000,
    0xFE80, 0x0000, 0x3FAF, 0x0000, 0x6967, 0x0000, 0x3DA1, 0x0000,
    0x0026, 0x0000, 0xC4C1, 0x0000, 0xAC62, 0x0000, 0xC100, 0x0000,
    0xF2FD, 0x0000, 0x47D3, 0x0000, 0x5EEC, 0x0000, 0x4673, 0x0000,
    0x006B, 0x0000, 0xCAB1, 0x0000, 0xA575, 0x0000, 0xC268, 0x0000,
    0xFB03, 0x0000, 0x40F6, 0x0000, 0x5E58, 0x0000, 0x3B19, 0x0000,
    0xFB76, 0x0000, 0xBCE2, 0x0000, 0xAD84, 0x0000, 0xCA19, 0x0000,
    0xFE53, 0x0000, 0x418B, 0x0000, 0x5571, 0x0000, 0x39FF, 0x0000,
    0x04DC, 0x0000, 0xB73D, 0x0000, 0xA125, 0x0000, 0xCBBF, 0x0000,
    0x030F, 0x0000, 0x37EF, 0x0000, 0x597B, 0x0000, 0x39C6, 0x0000,
    0xFB04, 0x0000, 0xB646, 0x0000, 0x9E5E, 0x0000, 0xBB18, 0x0000,
    0xFDF3, 0x0000, 0x3A06, 0x0000, 0x6299, 0x0000, 0x3E71, 0x0000,
    0x1323, 0x0000, 0xC002, 0x0000, 0x9D31, 0x0000, 0xBAB7, 0x0000,
    0xEF65, 0x0000, 0x4583, 0x0000, 0x5879, 0x0000, 0x45D1, 0x0000,
    0x0810, 0x0000, 0xBD58, 0x0000, 0x9E45, 0x0000, 0xB9E1, 0x0000,
    0xFA64, 0x0000, 0x4330, 0x0000, 0x595F, 0x0000, 0x3D80, 0x0000,
    0xF987, 0x0000, 0xC1E4, 0x0000, 0xAC08, 0x0000, 0xBF35, 0x0000,
    0x01E5, 0x0000, 0x4606, 0x0000, 0x5C43, 0x0000, 0x402B, 0x0000,
    0xFA1C, 0x0000, 0xC6B9, 0x0000, 0x9F34, 0x0000, 0xC514, 0x0000,
    0xFED3, 0x0000, 0x4495, 0x0000, 0x533A, 0x0000, 0x37C2, 0x0000,
    0xFEE7, 0x0000, 0xBECA, 0x0000, 0xA753, 0x0000, 0xC08C, 0x0000,
    0x0822, 0x0000, 0x3F76, 0x0000, 0x5961, 0x0000, 0x4093, 0x0000,
    0xFE1C, 0x0000, 0xC27D, 0x0000, 0xAAF8, 0x0000, 0xBC7E, 0x0000,
    0x0427, 0x0000, 0x3D8A, 0x0000, 0x57DE, 0x0000, 0x4556, 0x0000,
    0x0996, 0x0000, 0xCCE9, 0x0000, 0xA62A, 0x0000, 0xBF66, 0x0000,
    0xFAD3, 0x0000, 0x4077, 0x0000, 0x58AF, 0x0000, 0x472E, 0x0000,
    0xFADA, 0x0000, 0xC018, 0x0000, 0xA7A9, 0x0000, 0xB7CF, 0x0000,
    0xF6CE, 0x0000, 0x3F50, 0x0000, 0x5DC6, 0x0000, 0x3509, 0x0000,
    0xFEA3, 0x0000, 0xC996, 0x0000, 0xA1AF, 0x0000, 0xB9EC, 0x0000,
    0xF9A9, 0x0000, 0x3956, 0x0000, 0x5094, 0x0000, 0x4C0A, 0x0000,
    0xFF1C, 0x0000, 0xBF0E, 0x0000, 0xA87D, 0x0000, 0xC200, 0x0000,
    0xEFD4, 0x0000, 0x3F23, 0x0000, 0x52D0, 0x0000, 0x4178, 0x0000,
    0x0B53, 0x0000, 0xBEF5, 0x0000, 0xA5F2, 0x0000, 0xC564, 0x0000,
    0x0681, 0x0000, 0x42CC, 0x0000, 0x5F39, 0x0000, 0x35E9, 0x0000,
    0x0606, 0x0000, 0xC183, 0x0000, 0xA898, 0x0000, 0xB976, 0x0000,
    0x0134, 0x0000, 0x4969, 0x0000, 0x4CF8, 0x0000, 0x40A6, 0x0000,
    0xFAE2, 0x0000, 0xBCBE, 0x0000, 0xA5C4, 0x0000, 0xC159, 0x0000,
    0xFEAF, 0x0000, 0x4148, 0x0000, 0x5DBD, 0x0000, 0x3EB8, 0x0000,
    0xFA6B, 0x0000, 0xBEDE, 0x0000, 0xA2CA, 0x0000, 0xBA98, 0x0000,
    0xFE18, 0x0000, 0x4397, 0x0000, 0x5740, 0x0000, 0x3E08, 0x0000,
    0x00E0, 0x0000, 0xBEAB, 0x0000, 0xAC19, 0x0000, 0xBF21, 0x0000,
    0xF793, 0x0000, 0x35C9, 0x0000, 0x59A9, 0x0000, 0x3692, 0x0000,
    0x00D8, 0x0000, 0xC1F1, 0x0000, 0xB537, 0x0000, 0xC711, 0x0000,
    0xFFE2, 0x0000, 0x40FF, 0x0000, 0x57F1, 0x0000, 0x3E36, 0x0000,
    0x0221, 0x0000, 0xB83B, 0x0000, 0xA308, 0x0000, 0xBF44, 0x0000,
    0x05D7, 0x0000, 0x33C9, 0x0000, 0x63DE, 0x0000, 0x3249, 0x0000,
    0x0F43, 0x0000, 0xC3CE, 0x0000, 0xAA7E, 0x0000, 0xC0B0, 0x0000,
    0xF71D, 0x0000, 0x4094, 0x0000, 0x58B9, 0x0000, 0x45C7, 0x0000,
    0xF47E, 0x0000, 0xB27B, 0x0000, 0xAADE, 0x0000, 0xBA6C, 0x0000,
    0xFD57, 0x0000, 0x3F66, 0x0000, 0x5BF4, 0x0000, 0x3B31, 0x0000,
    0x011F, 0x0000, 0xC1C2, 0x0000, 0xAEA7, 0x0000, 0xBFFA, 0x0000,
    0x0580, 0x0000, 0x42A1, 0x0000, 0x5C7C, 0x0000, 0x4008, 0x0000,
    0xFEDB, 0x0000, 0xBFF4, 0x0000, 0xA76E, 0x0000, 0xBF41, 0x0000,
    0x08D6, 0x0000, 0x3EAD, 0x0000, 0x5B5E, 0x0000, 0x3BA9, 0x0000,
    0xFD03, 0x0000, 0xBC1F, 0x0000, 0xAA23, 0x0000, 0xBBDF, 0x0000,
    0x0869, 0x0000, 0x3B83, 0x0000, 0x579C, 0x0000, 0x4251, 0x0000,
    0xFCF7, 0x0000, 0xB957, 0x0000, 0x9ED7, 0x0000, 0xBBFF, 0x0000,
    0x0163, 0x0000, 0x41D5, 0x0000, 0x5648, 0x0000, 0x411D, 0x0000,
    0x0197, 0x0000, 0xC638, 0x0000, 0x9EEE, 0x0000, 0xCA60, 0x0000,
    0x0C16, 0x0000, 0x47AA, 0x0000, 0x5EE5, 0x0000, 0x4137, 0x0000,
    0x084F, 0x0000, 0xBDB3, 0x0000, 0xA46A, 0x0000, 0xBCD9, 0x0000,
    0xF71F, 0x0000, 0x3CAC, 0x0000, 0x5D73, 0x0000, 0x45CD, 0x0000,
    0x04AB, 0x0000, 0xC2D4, 0x0000, 0xABC7, 0x0000, 0xB829, 0x0000,
    0x0825, 0x0000, 0x44A9, 0x0000, 0x5BE7, 0x0000, 0x2C1C, 0x0000,
    0x02F4, 0x0000, 0xC852, 0x0000, 0xAFC3, 0x0000, 0xB9C7, 0x0000,
    0xFEEF, 0x0000, 0x42F1, 0x0000, 0x51C2, 0x0000, 0x3E59, 0x0000,
    0x09D3, 0x0000, 0xBF52, 0x0000, 0xA7A6, 0x0000, 0xC377, 0x0000,
    0xFE94, 0x0000, 0x428C, 0x0000, 0x5B5D, 0x0000, 0x45CA, 0x0000,
    0x0349, 0x0000, 0xC808, 0x0000, 0xA6A5, 0x0000, 0xC7BD, 0x0000,
    0x0AB6, 0x0000, 0x4707, 0x0000, 0x52C3, 0x0000, 0x3391, 0x0000,
    0x0093, 0x0000, 0xB874, 0x0000, 0xA664, 0x0000, 0xB63E, 0x0000,
    0xFD04, 0x0000, 0x3977, 0x0000, 0x693D, 0x0000, 0x3BDF, 0x0000,
    0xFEE5, 0x0000, 0xBCCF, 0x0000, 0x994D, 0x0000, 0xC645, 0x0000,
    0xFBCE, 0x0000, 0x3998, 0x0000, 0x55D0, 0x0000, 0x35E5, 0x0000,
    0x0383, 0x0000, 0xC133, 0x0000, 0x9F6F, 0x0000, 0xC2B9, 0x0000,
    0x0080, 0x0000, 0x3D79, 0x0000, 0x596C, 0x0000, 0x4DC4, 0x0000,
    0x0709, 0x0000, 0xB17D, 0x0000, 0xA4F5, 0x0000, 0xBDEB, 0x0000,
    0xFC3E, 0x0000, 0x4555, 0x0000, 0x53F7, 0x0000, 0x465D, 0x0000,
    0x05EF, 0x0000, 0xBB2B, 0x0000, 0xA889, 0x0000, 0xC815, 0x0000,
    0x00EF, 0x0000, 0x43D0, 0x0000, 0x58EF, 0x0000, 0x44FB, 0x0000,
    0x0359, 0x0000, 0xC440, 0x0000, 0xA939, 0x0000, 0xCD77, 0x0000,
    0xF95C, 0x0000, 0x419A, 0x0000, 0x5940, 0x0000, 0x3FDB, 0x0000,
    0xFFBC, 0x0000, 0xC8FE, 0x0000, 0xA6F0, 0x0000, 0xACC7, 0x0000,
    0xFDB5, 0x0000, 0x3A34, 0x0000, 0x5B37, 0x0000, 0x45CE, 0x0000,
    0x0182, 0x0000, 0xC77D, 0x0000, 0xAD91, 0x0000, 0xCB91, 0x0000,
    0x023D, 0x0000, 0x44AF, 0x0000, 0x570F, 0x0000, 0x4171, 0x0000,
    0xFE31, 0x0000, 0xBD0F, 0x0000, 0xA4C0, 0x0000, 0xC0D0, 0x0000,
    0xFA48, 0x0000, 0x3384, 0x0000, 0x5AEB, 0x0000, 0x3DF1, 0x0000,
    0xFFAB, 0x0000, 0xC7E1, 0x0000, 0xA365, 0x0000, 0xC2CE, 0x0000,
    0xFC94, 0x0000, 0x37A7, 0x0000, 0x6B46, 0x0000, 0x445D, 0x0000,
    0xFC25, 0x0000, 0xC411, 0x0000, 0xA804, 0x0000, 0xC036, 0x0000,
    0x06C9, 0x0000, 0x37E9, 0x0000, 0x570F, 0x0000, 0x3CE6, 0x0000,
    0xF498, 0x0000, 0xBCC5, 0x0000, 0xA197, 0x0000, 0xC1BA, 0x0000,
    0x059E, 0x0000, 0x4680, 0x0000, 0x6200, 0x0000, 0x4218, 0x0000,
    0x0256, 0x0000, 0xC922, 0x0000, 0xA54F, 0x0000, 0xB902, 0x0000,
    0xFB11, 0x0000, 0x3EB6, 0x0000, 0x4F54, 0x0000, 0x38EE, 0x0000,
    0x0B98, 0x0000, 0xBD12, 0x0000, 0xA170, 0x0000, 0xBE4D, 0x0000,
    0x05B4, 0x0000, 0x3BA2, 0x0000, 0x5B79, 0x0000, 0x39A4, 0x0000,
    0x0B77, 0x0000, 0xC33E, 0x0000, 0xA8E6, 0x0000, 0xBE3D, 0x0000,
    0xF691, 0x0000, 0x3B26, 0x0000, 0x5B96, 0x0000, 0x34DB, 0x0000,
    0xFE5B, 0x0000, 0xB96E, 0x0000, 0xAF0D, 0x0000, 0xC25E, 0x0000,
    0x040D, 0x0000, 0x3AF1, 0x0000, 0x5259, 0x0000, 0x382A, 0x0000,
    0x07E2, 0x0000, 0xBD99, 0x0000, 0x9A1C, 0x0000, 0xBE76, 0x0000,
    0x03AE, 0x0000, 0x3E1D, 0x0000, 0x5885, 0x0000, 0x4072, 0x0000,
    0xF6DB, 0x0000, 0xC062, 0x0000, 0xA58C, 0x0000, 0xC393, 0x0000,
    0x02C4, 0x0000, 0x4936, 0x0000, 0x5F36, 0x0000, 0x3AE4, 0x0000,
    0x048D, 0x0000, 0xBC9D, 0x0000, 0xA5B4, 0x0000, 0xBFBB, 0x0000,
    0xFA77, 0x0000, 0x37B4, 0x0000, 0x52AD, 0x0000, 0x35DD, 0x0000,
    0xFB7E, 0x0000, 0xBBDB, 0x0000, 0xA4E2, 0x0000, 0xCC24, 0x0000,
    0x0136, 0x0000, 0x40DD, 0x0000, 0x5BCE, 0x0000, 0x39A1, 0x0000,
    0x0811, 0x0000, 0xBFD2, 0x0000, 0xA507, 0x0000, 0xBD4A, 0x0000,
    0x0362, 0x0000, 0x3B4A, 0x0000, 0x5894, 0x0000, 0x437B, 0x0000,
    0xF583, 0x0000, 0xBB1A, 0x0000, 0xA43B, 0x0000, 0xC165, 0x0000,
    0xF83A, 0x0000, 0x39A0, 0x0000, 0x5A76, 0x0000, 0x3947, 0x0000,
    0xFD5F, 0x0000, 0xC440, 0x0000, 0xA554, 0x0000, 0xC582, 0x0000,
    0x0512, 0x0000, 0x3C7D, 0x0000, 0x5A11, 0x0000, 0x3586, 0x0000,
    0x06D1, 0x0000, 0xBE79, 0x0000, 0xA076, 0x0000, 0xBEC6, 0x0000,
    0xFC86, 0x0000, 0x41B2, 0x0000, 0x64B4, 0x0000, 0x365F, 0x0000,
    0x040F, 0x0000, 0xB74F, 0x0000, 0xAA8E, 0x0000, 0xB4EC, 0x0000,
    0x07F0, 0x0000, 0x3E69, 0x0000, 0x546A, 0x0000, 0x42B0, 0x0000,
    0xFE04, 0x0000, 0xC81E, 0x0000, 0x9BDA, 0x0000, 0xBB99, 0x0000,
    0x00B3, 0x0000, 0x4737, 0x0000, 0x5A37, 0x0000, 0x38B8, 0x0000,
    0xFC3B, 0x0000, 0xBFBA, 0x0000, 0xA688, 0x0000, 0xCB7C, 0x0000,
    0xF922, 0x0000, 0x3B13, 0x0000, 0x5EB9, 0x0000, 0x4596, 0x0000,
    0xFA50, 0x0000, 0xBBA3, 0x0000, 0xAE6B, 0x0000, 0xB82F, 0x0000,
    0x0AF8, 0x0000, 0x49B6, 0x0000, 0x5F81, 0x0000, 0x399C, 0x0000,
    0x0244, 0x0000, 0xBBDD, 0x0000, 0xAA28, 0x0000, 0xBB07, 0x0000,
    0xFAC7, 0x0000, 0x4AE1, 0x0000, 0x6266, 0x0000, 0x39EC, 0x0000,
    0xFE9D, 0x0000, 0xB12F, 0x0000, 0xA7B5, 0x0000, 0xBF77, 0x0000,
    0xF83A, 0x0000, 0x483F, 0x0000, 0x4CB3, 0x0000, 0x4493, 0x0000,
    0xFC23, 0x0000, 0xC1B5, 0x0000, 0xA6CA, 0x0000, 0xC693, 0x0000,
    0xF624, 0x0000, 0x45E6, 0x0000, 0x55BE, 0x0000, 0x3D18, 0x0000,
    0xF69A, 0x0000, 0xC751, 0x0000, 0xB0F3, 0x0000, 0xCBFF, 0x0000,
    0x00C3, 0x0000, 0x3C85, 0x0000, 0x5F2C, 0x0000, 0x3FCC, 0x0000,
    0xF9A1, 0x0000, 0xC065, 0x0000, 0xA4B4, 0x0000, 0xC356, 0x0000,
    0x0123, 0x0000, 0x4149, 0x0000, 0x5891, 0x0000, 0x341B, 0x0000,
    0xFB2B, 0x0000, 0xB676, 0x0000, 0xAB20, 0x0000, 0xC6AD, 0x0000,
    0xFE33, 0x0000, 0x3ABB, 0x0000, 0x589C, 0x0000, 0x3FFD, 0x0000,
    0x00E7, 0x0000, 0xCEFE, 0x0000, 0xA48C, 0x0000, 0xB810, 0x0000,
    0xFAA8, 0x0000, 0x3335, 0x0000, 0x5900, 0x0000, 0x3926, 0x0000,
    0x024E, 0x0000, 0xC3DF, 0x0000, 0xAA1E, 0x0000, 0xBF43, 0x0000,
    0xFE00, 0x0000, 0x4268, 0x0000, 0x5B70, 0x0000, 0x3A4C, 0x0000,
    0xF92D, 0x0000, 0xBBA0, 0x0000, 0xA59F, 0x0000, 0xB279, 0x0000,
    0xF984, 0x0000, 0x3540, 0x0000, 0x5696, 0x0000, 0x418B, 0x0000,
    0xFFA6, 0x0000, 0xBACE, 0x0000, 0xAA53, 0x0000, 0xC10B, 0x0000,
    0xF8B3, 0x0000, 0x443B, 0x0000, 0x58F7, 0x0000, 0x3160, 0x0000,
    0xFCD3, 0x0000, 0xBF6C, 0x0000, 0xA576, 0x0000, 0xBE81, 0x0000,
    0xFFD6, 0x0000, 0x3F3C, 0x0000, 0x5F77, 0x0000, 0x3CCF, 0x0000,
    0x0421, 0x0000, 0xC005, 0x0000, 0xB60E, 0x0000, 0xB905, 0x0000,
    0x0020, 0x0000, 0x4EFB, 0x0000, 0x62A9, 0x0000, 0x3CE2, 0x0000,
    0xF87C, 0x0000, 0xBB78, 0x0000, 0x9A60, 0x0000, 0xC4A1, 0x0000,
    0xF78B, 0x0000, 0x3B37, 0x0000, 0x559D, 0x0000, 0x3C86, 0x0000,
    0xF6FA, 0x0000, 0xBFCC, 0x0000, 0xA9AB, 0x0000, 0xB741, 0x0000,
    0xFF09, 0x0000, 0x3F4A, 0x0000, 0x5225, 0x0000, 0x3FC2, 0x0000,
    0x0722, 0x0000, 0xC628, 0x0000, 0xA7C6, 0x0000, 0xBC82, 0x0000,
    0xFDD9, 0x0000, 0x363E, 0x0000, 0x5595, 0x0000, 0x404B, 0x0000,
    0x0EF5, 0x0000, 0xC754, 0x0000, 0xA958, 0x0000, 0xCC6D, 0x0000,
    0xF886, 0x0000, 0x3BF0, 0x0000, 0x538A, 0x0000, 0x49E9, 0x0000,
    0xF5DE, 0x0000, 0xC020, 0x0000, 0xAC2D, 0x0000, 0xC3E1, 0x0000,
    0x01E1, 0x0000, 0x4600, 0x0000, 0x6022, 0x0000, 0x3EB8, 0x0000,
    0x00A1, 0x0000, 0xB97A, 0x0000, 0x9DAC, 0x0000, 0xC489, 0x0000
    };

static const q15_t in_cifft_noisy_4096[8192] = {
    0xFFE5, 0x0000, 0xFFE9, 0x001C, 0xFFFC, 0xFFF6, 0x000D, 0xFFF9,
    0xFFE8, 0xFFEB, 0xFFF5, 0xFFF3, 0xFFEB, 0x0002, 0xFFFC, 0xFFF9,
    0x000C, 0xFFEC, 0xFFE2, 0xFFFD, 0xFFF9, 0xFFF9, 0x0015, 0x001A,
    0x001B, 0xFFDE, 0x0009, 0x0001, 0xFFDB, 0x0006, 0x0002, 0x001B,
    0xFFEE, 0xFFFA, 0xFFF7, 0x0008, 0x0005, 0x000A, 0xFFF9, 0xFFEA,
    0x0010, 0x0015, 0x0007, 0x0006, 0x0010, 0xFFFF, 0xFFF7, 0xFFEA,
    0x0011, 0x0013, 0x001D, 0xFFE0, 0x0020, 0x0007, 0xFFFA, 0xFFF1,
    0x000F, 0xFFEE, 0x000A, 0xFFEB, 0xFFFE, 0xFFFD, 0x000A, 0xFFF8,
    0x0006, 0x0010, 0xFFEA, 0x0016, 0x000F, 0x001B, 0xFFFC, 0xFFEB,
    0xFFFA, 0xFFF6, 0x0002, 0x0002, 0x0017, 0xFFF1, 0x0001, 0x0007,
    0xFFF0, 0x000C, 0xFFFD, 0x0003, 0x0003, 0xFFF3, 0x0007, 0xFFFA,
    0x0000, 0x0016, 0xFFEA, 0x0002, 0xFFE5, 0xFFFD, 0xFFEB, 0x0017,
    0xFFFE, 0x0005, 0xFFF6, 0x0001, 0x0009, 0x000D, 0x0001, 0xFFFB,
    0x001B, 0x0008, 0x0024, 0x0002, 0xFFEA, 0xFFFF, 0xFFF7, 0x0009,
    0xFFFC, 0xFFF7, 0x0007, 0x0006, 0x000F, 0xFFE2, 0xFFEA, 0x0005,
    0xFFF9, 0x0011, 0xFFF5, 0xFFF2, 0x0011, 0xFFEE, 0xFFEB, 0xFFFE,
    0x001B, 0xFFFF, 0xFFF9, 0xFFF8, 0xFFF1, 0x0008, 0x0015, 0x0019,
    0xFFD0, 0xFFF5, 0xFFF3, 0x0002, 0x001E, 0x0000, 0xFFE3, 0x0003,
    0x0004, 0xFFE7, 0x000C, 0x0005, 0x0005, 0xFFF2, 0x0013, 0x0016,
    0x0001, 0xFFED, 0x0008, 0xFFF9, 0xFFEC, 0xFFFC, 0xFFFA, 0x0016,
    0x000C, 0x000B, 0x000D, 0x0018, 0xFFD8, 0xFFDE, 0x0019, 0x0013,
    0xFFEE, 0x0013, 0x0008, 0x0003, 0xFFF6, 0xFFEB, 0xFFF4, 0x0005,
    0x0009, 0x0002, 0x0001, 0x001F, 0x0007, 0x0018, 0xFFF0, 0x002C,
    0x0019, 0xFFF5, 0x0002, 0xFFF0, 0xFFEA, 0x000D, 0xFFF6, 0x0010,
    0x0001, 0xFFF7, 0x000F, 0x000F, 0xFFEF, 0xFFF3, 0xFFFC, 0x0002,
    0xFFE9, 0xFFFE, 0xFFE9, 0x0011, 0x000B, 0x0011, 0xFFE6, 0x0019,
    0xFFFE, 0xFFF7, 0x000E, 0xFFD1, 0xFFE9, 0x0037, 0xFFF2, 0x0004,
    0xFFEC, 0x0006, 0xFFE2, 0x0012, 0x000C, 0xFFE5, 0x0018, 0xFFFF,
    0xFFFC, 0x0010, 0x0010, 0x002C, 0xFFF1, 0x0005, 0xFFEE, 0x0019,
    0xFFEE, 0xFFF8, 0xFFEC, 0x0020, 0x000F, 0xFFE1, 0x0005, 0xFFFB,
    0xFFE1, 0xFFFB, 0xFFF6, 0x001D, 0xFFFC, 0x0013, 0xFFFE, 0x0004,
    0x0001, 0x0008, 0xFFF2, 0x0026, 0xFFFC, 0x0010, 0xFFEF, 0xFFFA,
    0x0007, 0xFFE0, 0x000B, 0xFFFF, 0x0001, 0xFFF6, 0x0005, 0xFFEA,
    0xFFDD, 0x0003, 0x0019, 0xFFEE, 0xFFF6, 0x0015, 0xFFF6, 0xFFF8,
    0x0027, 0xFFEC, 0xFFFA, 0x0014, 0xFFDE, 0xFFD4, 0x001F, 0xFFF5,
    0x0002, 0xFFEB, 0xFFF8, 0xFFF5, 0x000B, 0x0001, 0x0011, 0xFFFF,
    0xFFFE, 0x000C, 0x0008, 0x0002, 0x0007, 0x000C, 0x0000, 0xFFF9,
    0x0005, 0xFFFD, 0x0007, 0xFFF3, 0xFFFF, 0x0013, 0x001F, 0xFFF7,
    0xFFF7, 0x0004, 0x0004, 0x0001, 0xFFE4, 0x0015, 0xFFFF, 0x0007,
    0x0006, 0xFFF4, 0x0018, 0xFFEE, 0xFFF5, 0xFFF7, 0xFFF5, 0x0010,
    0x000F, 0x0004, 0x0009, 0xFFE4, 0xFFF0, 0x000E, 0x0030, 0xFFFD,
    0xFFFE, 0xFFFC, 0xFFEC, 0xFFF8, 0xFFF6, 0xFFFA, 0x0009, 0x0011,
    0x000A, 0xFFF5, 0xFFE5, 0x0000, 0x0000, 0x001A, 0x0000, 0xFFF8,
    0x000A, 0xFFF1, 0x0003, 0xFFEF, 0xFFE6, 0xFFEC, 0xFFF6, 0x0007,
    0xFFF1, 0x000B, 0x0005, 0xFFEE, 0xFFFF, 0x0023, 0x0009, 0x000E,
    0x001D, 0x0011, 0xFFF8, 0x0000, 0xFFF6, 0x002D, 0x000C, 0xFFE5,
    0x0013, 0x0011, 0xFFFB, 0xFFFA, 0xFFFE, 0x0010, 0xFFF3, 0x0000,
    0x0017, 0x0014, 0x000D, 0x0014, 0xFFEE, 0xFFF7, 0xFFEA, 0x0011,
    0xFFE5, 0x001C, 0x0019, 0xFFFD, 0x0002, 0xFFF0, 0xFFE2, 0x0012,
    0xFFFA, 0xFFEC, 0x0000, 0x0004, 0x0000, 0xFFEB, 0x0011, 0xFFDD,
    0x000C, 0x001A, 0x000D, 0x0016, 0x0007, 0x0006, 0x000B, 0x0003,
    0xFFE5, 0xFFFD, 0xFFF6, 0x0004, 0xFFE8, 0x0010, 0xFFEF, 0x000D,
    0xFFF0, 0x0000, 0x0004, 0x0011, 0xFFFE, 0xFFE4, 0xFFEB, 0x000D,
    0xFFDA, 0xFFFF, 0x0000, 0xFFF5, 0x0002, 0x0008, 0x0011, 0x0022,
    0x000B, 0x000D, 0x0005, 0x000A, 0x0005, 0x0001, 0x0002, 0xFFE2,
    0x0004, 0x0007, 0x000A, 0x001A, 0xFFEB, 0xFFF5, 0xFFFC, 0xFFEF,
    0xFFEB, 0x000D, 0x0005, 0x000F, 0x000D, 0x000E, 0x0004, 0xFFFC,
    0x0013, 0x0000, 0xFFFD, 0x0004, 0x0003, 0xFFF3, 0x0007, 0x0001,
    0xFFEF, 0x0004, 0x0001, 0x000B, 0xFFED, 0x000F, 0x0000, 0xFFFB,
    0xFFED, 0x0010, 0xFFE9, 0xFFF6, 0xFFFE, 0xFFE0, 0x000E, 0xFFEB,
    0x0018, 0xFFF7, 0x0029, 0x0003, 0x0014, 0x000F, 0x0023, 0x0011,
    0x0008, 0x000D, 0xFFE8, 0xFFF1, 0x0010, 0x0013, 0xFFFD, 0x0003,
    0xFFE5, 0x0009, 0x0009, 0xFFD8, 0xFFF5, 0xFFFD, 0x0003, 0x0009,
    0x001A, 0x000D, 0xFFF1, 0xFFEA, 0x0016, 0xFFFC, 0x001A, 0x0006,
    0x0006, 0xFFF6, 0x0023, 0x0007, 0x001F, 0x0008, 0x001A, 0xFFE8,
    0x0003, 0xFFE1, 0x000D, 0x001E, 0xFFFB, 0x000B, 0xFFFD, 0x0021,
    0xFFF7, 0xFFF0, 0x0008, 0x0004, 0x0001, 0x000D, 0xFFCE, 0xFFFD,
    0xFFE1, 0x000D, 0x000B, 0x000A, 0x001E, 0x001D, 0x000F, 0x0014,
    0x0002, 0xFFFA, 0x0006, 0x000C, 0x0001, 0x0006, 0x0003, 0xFFE6,
    0xFFF4, 0x000D, 0x0010, 0xFFF6, 0xFFEC, 0x0014, 0xFFFB, 0x001F,
    0x0009, 0xFFFD, 0xFFF4, 0x0006, 0xFFFF, 0xFFF2, 0xFFDF, 0xFFFE,
    0x0002, 0xFFE8, 0xFFE0, 0x001D, 0xFFF6, 0xFFE3, 0x0010, 0x0001,
    0x0019, 0x000B, 0xFFFC, 0x0004, 0x0014, 0xFFE9, 0xFFFC, 0xFFF4,
    0xFFD7, 0xFFE2, 0x0009, 0x0003, 0xFFFF, 0x0010, 0xFFE9, 0xFFF1,
    0x000A, 0xFFFE, 0xFFFE, 0xFFFA, 0xFFF8, 0x001C, 0xFFFF, 0xFFFD,
    0x0005, 0xFFFD, 0x000A, 0xFFF8, 0x0012, 0x0009, 0x0003, 0xFFEE,
    0x0008, 0xFFF7, 0xFFEC, 0x0007, 0x0009, 0xFFF4, 0x000E, 0xFFFE,
    0xFFF6, 0xFFEF, 0xFFF5, 0x000C, 0x0025, 0xFFFE, 0x0017, 0x0012,
    0xFFE7, 0x0008, 0x0012, 0xFFE8, 0x0011, 0x001A, 0x000F, 0xFFFD,
    0xFFDA, 0xFFF1, 0xFFE7, 0xFFFC, 0xFFFD, 0xFFEE, 0xFFF4, 0xFFF7,
    0x000C, 0xFFF9, 0x0008, 0xFFD3, 0x000B, 0x002D, 0xFFE9, 0x0011,
    0xFFF0, 0x0039, 0xFFF7, 0x0008, 0xFFEB, 0xFFED, 0x0008, 0xFFF8,
    0xFFEC, 0x0007, 0xFFF4, 0xFFDD, 0x0008, 0x0014, 0x0001, 0xFFE3,
    0x0007, 0x0007, 0x001F, 0xFFE9, 0xFFFB, 0x0001, 0xFFF2, 0x000A,
    0x000E, 0xFFF9, 0xFFF2, 0xFFE1, 0xFFEA, 0x0009, 0xFFF9, 0x0001,
    0xFFEC, 0x000B, 0xFFEA, 0x0016, 0xFFC6, 0xFFD3, 0x000E, 0xFFFC,
    0xFFFA, 0x001D, 0xFFFD, 0x0015, 0xFFFF, 0xFFF7, 0x0015, 0xFFF5,
    0xFFF5, 0xFFE3, 0x000D, 0x0011, 0x000B, 0x0014, 0xFFFB, 0xFFF8,
    0x002A, 0xFFEC, 0x0007, 0xFFFB, 0x0012, 0xFFE7, 0xFFEB, 0x0002,
    0xFFFE, 0x0009, 0x0014, 0xFFF5, 0x0005, 0xFFFE, 0x000B, 0xFFF7,
    0xFFF3, 0x000C, 0x0000, 0xFFF3, 0xFFFC, 0xFFF5, 0x0023, 0x0005,
    0xFFFB, 0xFFF6, 0x0017, 0xFFF8, 0x0005, 0xFFFE, 0xFFF2, 0xFFF5,
    0xFFFB, 0xFFFC, 0xFFF6, 0xFFF7, 0x0004, 0xFFE2, 0x000C, 0x0006,
    0xFFF8, 0xFFE8, 0xFFF1, 0xFFF0, 0x0008, 0xFFF4, 0x0009, 0x0012,
    0xFFC4, 0xFFED, 0x000A, 0xFFF7, 0xFFE5, 0x0015, 0xFFEF, 0x000B,
    0xFFE6, 0x0022, 0x001D, 0x0002, 0xFFF7, 0xFFF9, 0xFFF0, 0xFFE8,
    0xFFFC, 0xFFF8, 0xFFE8, 0x0011, 0xFFE5, 0xFFE5, 0xFFD8, 0xFFE1,
    0xFFFB, 0x000F, 0x0000, 0xFFEF, 0x0006, 0x0013, 0x0013, 0xFFFA,
    0x002A, 0xFFE7, 0xFFFD, 0xFFFD, 0xFFF0, 0x000E, 0xFFFF, 0x0011,
    0x0013, 0xFFE5, 0x0014, 0xFFE1, 0x0009, 0xFFFF, 0x0016, 0x0016,
    0x000E, 0x0026, 0xFFFD, 0xFFE0, 0xFFFD, 0xFFD8, 0x0007, 0x000B,
    0x0011, 0xFFC4, 0x0016, 0xFFFD, 0xFFE5, 0x000F, 0xFFF7, 0xFFF0,
    0xFFF8, 0x000B, 0xFFEB, 0xFFDA, 0x0008, 0x0014, 0x0003, 0x0001,
    0xFFD9, 0x0010, 0x001F, 0x0001, 0xFFFB, 0xFFFD, 0x0008, 0x0002,
    0xFFE3, 0xFFEB, 0xFFF3, 0xFFF3, 0x0018, 0x000A, 0xFFF6, 0xFFFF,
    0x0001, 0x0002, 0xFFEC, 0xFFDE, 0x0003, 0xFFCF, 0x0026, 0xFFFE,
    0x0030, 0x0002, 0xFFDD, 0xFFF1, 0x002A, 0x0019, 0xFFFB, 0xFFFB,
    0x0000, 0xFFFA, 0xFFFF, 0x0002, 0xFFFD, 0xFFE1, 0x0017, 0x0022,
    0x0008, 0xFFF1, 0x0014, 0x0005, 0x0004, 0x000F, 0x002D, 0xFFFE,
    0xFFE8, 0xFFEC, 0x0009, 0xFFE5, 0x0002, 0x0009, 0x0010, 0x0009,
    0x001D, 0xFFFA, 0xFFEA, 0x0012, 0x0027, 0xFFF8, 0xFFF4, 0xFFFE,
    0x0012, 0x0006, 0x0001, 0x0000, 0x001F, 0x000A, 0x0012, 0x0013,
    0x000C, 0x0003, 0x0003, 0x0021, 0xFFE8, 0xFFD0, 0xFFFD, 0xFFFF,
    0x0017, 0xFFE8, 0x0008, 0xFFE4, 0x0024, 0x0006, 0xFFF4, 0xFFF5,
    0x0022, 0x001A, 0x0012, 0xFFDC, 0x001F, 0xFFF6, 0xFFEA, 0x0004,
    0xFFF3, 0xFFF4, 0x0001, 0x000C, 0xFFEB, 0xFFD2, 0xFFEC, 0xFFF7,
    0x0010, 0x0008, 0xFFEF, 0xFFFB, 0xFFEC, 0xFFF2, 0x0013, 0x000B,
    0x0018, 0x0017, 0xFFEC, 0xFFFE, 0xFFE1, 0xFFEC, 0x000A, 0x000A,
    0x0011, 0xFFF6, 0xFFE3, 0x0008, 0xFFE6, 0x0012, 0xFFF9, 0xFFEE,
    0x0015, 0x000F, 0x0002, 0x0006, 0xFFF1, 0xFFF3, 0x0001, 0x0004,
    0xFFEC, 0x0007, 0xFFF3, 0x0020, 0xFFEF, 0xFFF8, 0x0006, 0x0003,
    0x0015, 0xFFF1, 0xFFF8, 0x0006, 0xFFEE, 0x0005, 0x0008, 0xFFF5,
    0x0009, 0x0011, 0xFFF2, 0xFFFD, 0xFFF2, 0xFFF6, 0x0015, 0xFFFA,
    0x000A, 0x0005, 0x0011, 0x0014, 0x0004, 0xFFF8, 0x0021, 0x0021,
    0xFFE8, 0x000D, 0xFFFD, 0xFFF5, 0xFFED, 0x000B, 0xFFEB, 0x0004,
    0x001A, 0xFFF2, 0x0013, 0xFFFB, 0xFFF3, 0xFFDE, 0xFFF0, 0xFFF8,
    0xFFFF, 0xFFF0, 0xFFE8, 0x0014, 0x000A, 0xFFEC, 0x0003, 0x0001,
    0xFFF9, 0xFFF5, 0x000C, 0xFFF4, 0x0000, 0x000E, 0xFFF5, 0xFFEB,
    0xFFCE, 0xD33C, 0xFFFF, 0x0015, 0xFFF4, 0x0022, 0x0033, 0x0004,
    0x0029, 0x0002, 0xFFF2, 0x001D, 0x0002, 0xFFF5, 0x000C, 0xFFEF,
    0x0002, 0xFFFD, 0x0001, 0xFFED, 0xFFE3, 0xFFFC, 0xFFE5, 0xFFFB,
    0xFFFD, 0x000A, 0xFFDF, 0x0004, 0xFFDE, 0x002B, 0x0005, 0xFFE1,
    0x0011, 0xFFFB, 0xFFFF, 0x0008, 0xFFE8, 0x0000, 0xFFFD, 0xFFEA,
    0xFFFC, 0xFFEC, 0xFFFD, 0x0003, 0x0002, 0x000C, 0xFFF5, 0xFFF9,
    0xFFF9, 0xFFDF, 0xFFFE, 0x0014, 0xFFEC, 0x0004, 0xFFFC, 0xFFFE,
    0x000E, 0xFFF7, 0x002B, 0xFFF7, 0xFFFF, 0xFFFB, 0x0008, 0xFFFB,
    0xFFEA, 0x0008, 0xFFFF, 0xFFCB, 0x000E, 0x0009, 0x0003, 0x0001,
    0xFFF4, 0x0034, 0x000D, 0xFFED, 0xFFEB, 0x000E, 0xFFFA, 0x0007,
    0x001D, 0x0010, 0xFFFB, 0x0001, 0xFFED, 0xFFFA, 0xFFEA, 0x0022,
    0x0005, 0x000B, 0xFFFD, 0x0011, 0xFFDD, 0xFFF6, 0x0006, 0x0003,
    0xFFFE, 0x0010, 0xFFFB, 0xFFD4, 0xFFF4, 0xFFFC, 0xFFF8, 0x0013,
    0xFFF7, 0x000A, 0x0010, 0xFFFB, 0xFFFE, 0xFFEF, 0xFFEA, 0x000A,
    0xFFE1, 0xFFC7, 0x001B, 0xFFFE, 0x000C, 0xFFD8, 0xFFFD, 0xFFFE,
    0x000E, 0x000D, 0xFFEA, 0x0003, 0xFFEC, 0xFFED, 0xFFF7, 0xFFF1,
    0x001C, 0xFFFF, 0xFFFF, 0xFFF3, 0x0000, 0xFFFA, 0xFFF4, 0xFFF4,
    0x0000, 0x0022, 0xFFEF, 0xFFF3, 0xFFEB, 0xFFE4, 0x0013, 0xFFF6,
    0x000C, 0xFFF7, 0x0008, 0xFFFA, 0xFFFD, 0x0012, 0x001D, 0xFFE6,
    0xFFEA, 0x0005, 0xFFEA, 0xFFEF, 0x001E, 0x0019, 0xFFE4, 0x000B,
    0x0013, 0x000F, 0xFFED, 0x000F, 0xFFF5, 0x0011, 0x000F, 0xFFF4,
    0x0027, 0x0001, 0xFFE2, 0xFFEB, 0xFFF4, 0x000A, 0x000A, 0x0017,
    0x0001, 0xFFF5, 0x0009, 0x0006, 0x0002, 0x0005, 0xFFE8, 0x0000,
    0x000C, 0x000C, 0x0015, 0x0005, 0x0021, 0x0014, 0x0015, 0x0000,
    0x0007, 0x0010, 0xFFF5, 0xFFF4, 0xFFF4, 0xFFE6, 0x0002, 0xFFEF,
    0x0012, 0xFFED, 0x000B, 0x0038, 0x0002, 0xFFDE, 0xFFFA, 0x0018,
    0x0003, 0xFFFD, 0x0001, 0xFFEE, 0x0005, 0x0009, 0x001B, 0xFFFD,
    0xFFFB, 0x000F, 0xFFF9, 0xFFFB, 0x0011, 0x0011, 0x0012, 0xFFF2,
    0x000F, 0xFFE6, 0x000E, 0x0002, 0xFFEE, 0xFFFF, 0xFFFB, 0x0006,
    0x0004, 0x000C, 0x0009, 0x000C, 0x000E, 0x0004, 0xFFF5, 0x0003,
    0x0016, 0xFFF8, 0x001C, 0xFFF7, 0x0004, 0xFFFE, 0x0001, 0x0018,
    0x0027, 0xFFEE, 0xFFEC, 0x0008, 0x0012, 0x0006, 0x000B, 0xFFFE,
    0x0024, 0x0017, 0x000A, 0xFFE4, 0xFFEB, 0x0019, 0x0002, 0xFFFF,
    0x0011, 0xFFFF, 0x000A, 0x0004, 0x001A, 0x0008, 0xFFF2, 0xFFEA,
    0x0005, 0x000D, 0xFFEE, 0xFFFB, 0x0006, 0x0022, 0xFFFB, 0x0004,
    0xFFF8, 0x0018, 0xFFF0, 0xFFFA, 0x0002, 0x0018, 0xFFE5, 0xFFE0,
    0xFFDC, 0xFFF8, 0x0012, 0xFFF4, 0x0004, 0xFFF8, 0xFFF7, 0x0011,
    0x0009, 0xFFF2, 0x0017, 0x0009, 0x0006, 0x001E, 0x0000, 0xFFE5,
    0x000E, 0x000C, 0xFFFC, 0x0008, 0x0015, 0xFFF7, 0xFFF1, 0x000E,
    0x0002, 0xFFFB, 0xFFEE, 0xFFF6, 0x001E, 0xFFF0, 0xFFF5, 0xFFF1,
    0x0002, 0xFFF4, 0xFFF4, 0xFFE4, 0xFFFC, 0x000A, 0x0009, 0xFFFF,
    0x000C, 0x0017, 0x0009, 0xFFF0, 0xFFDF, 0xFFEE, 0xFFED, 0xFFF7,
    0x0014, 0x0015, 0xFFF8, 0x0006, 0xFFFC, 0x001C, 0xFFEC, 0x0006,
    0x000E, 0xFFFF, 0xFFFF, 0xFFF7, 0x0004, 0xFFFB, 0xFFFF, 0x0010,
    0xFFFF, 0xFFDB, 0x001D, 0x0011, 0xFFF9, 0x000B, 0x0004, 0x0001,
    0xFFEC, 0xFFFC, 0xFFE9, 0xFFFB, 0xFFF2, 0x0002, 0x0001, 0x0006,
    0x0010, 0xFFF3, 0x0006, 0xFFF0, 0xFFF1, 0xFFD8, 0xFFF4, 0x0009,
    0xFFEF, 0xFFE4, 0xFFFD, 0xFFFF, 0xFFF5, 0xFFFD, 0x0013, 0x000E,
    0xFFE4, 0xFFFB, 0xFFED, 0x0024, 0xFFF2, 0xFFF4, 0x0004, 0x0018,
    0xFFF7, 0xFFEA, 0x0001, 0x0005, 0x0011, 0x000C, 0x0008, 0xFFED,
    0x0014, 0x000E, 0xFFFC, 0xFFFA, 0x0000, 0xFFF9, 0x0016, 0x0021,
    0xFFF0, 0x0014, 0xFFEB, 0x000C, 0xFFF3, 0xFFFA, 0x0014, 0xFFFA,
    0x0004, 0x001D, 0x000F, 0x0024, 0x0009, 0xFFFF, 0x002A, 0x000C,
    0x0021, 0x0007, 0x0006, 0x0018, 0x0008, 0xFFEF, 0xFFF5, 0x000B,
    0x0009, 0xFFFF, 0xFFE7, 0xFFF7, 0xFFFB, 0xFFFD, 0x0023, 0x0014,
    0x000B, 0x0011, 0xFFF9, 0x0018, 0xFFFC, 0x000E, 0x001F, 0x002B,
    0x0008, 0x0005, 0xFFF6, 0xFFE6, 0xFFE8, 0xFFF3, 0xFFFF, 0x0005,
    0xFFF6, 0xFFEB, 0xFFF7, 0xFFFE, 0xFFFC, 0xFFFD, 0x001F, 0xFFF1,
    0xFFFF, 0x0006, 0x001A, 0xFFEC, 0xFFE8, 0x0004, 0xFFE4, 0xFFEF,
    0x0010, 0x0016, 0x0005, 0xFFF3, 0xFFFE, 0xFFF3, 0x000F, 0xFFED,
    0xFFE8, 0x0006, 0x0001, 0x000D, 0xFFF1, 0x0007, 0x0001, 0xFFEA,
    0x000D, 0x0007, 0x0007, 0xFFF3, 0xFFF7, 0x000E, 0x000D, 0xFFF8,
    0xFFE2, 0x0012, 0xFFEB, 0xFFE3, 0x0006, 0x000C, 0x000E, 0xFFF1,
    0x000C, 0xFFF6, 0xFFF0, 0xFFF8, 0x0004, 0x000F, 0x0016, 0xFFF7,
    0x0008, 0x0006, 0x000F, 0xFFF7, 0xFFF3, 0xFFFE, 0x000E, 0x0025,
    0x000B, 0xFFF2, 0xFFF2, 0xFFFF, 0xFFE4, 0xFFF7, 0xFFFA, 0xFFE6,
    0xFFFF, 0xFFF5, 0x0004, 0x001C, 0x0006, 0x000B, 0xFFF5, 0xFFEF,
    0xFFFA, 0xFFF5, 0xFFEC, 0x000F, 0xFFFE, 0x0019, 0x0005, 0x0001,
    0x0000, 0x0006, 0x0013, 0x0020, 0x0009, 0xFFDD, 0xFFFA, 0xFFF8,
    0x0006, 0xFFFB, 0xFFF4, 0xFFE8, 0xFFE2, 0x0014, 0xFFFA, 0xFFFB,
    0x0016, 0x000B, 0x0005, 0xFFEF, 0x0005, 0xFFFD, 0x0011, 0xFFEB,
    0x0016, 0x000D, 0xFFE7, 0x001F, 0x0000, 0xFFDF, 0x0000, 0x0015,
    0x001B, 0x0014, 0x002C, 0x0009, 0x0013, 0xFFE5, 0x001E, 0x0015,
    0x0008, 0x0001, 0xFFFB, 0x0000, 0xFFF7, 0x0016, 0xFFE3, 0x0007,
    0x0000, 0x000F, 0x000D, 0x0001, 0xFFDF, 0x0001, 0xFFD7, 0x0011,
    0xFFF2, 0xFFC8, 0xFFF1, 0xFFFF, 0x0013, 0x0014, 0x0017, 0x0008,
    0xFFE3, 0xFFF5, 0x0015, 0x0006, 0x000C, 0xFFFE, 0xFFF1, 0x0001,
    0x0011, 0x0003, 0xFFFB, 0xFFFB, 0x0027, 0xFFE8, 0xFFFF, 0x0009,
    0xFFF1, 0xFFF5, 0x0014, 0xFFE9, 0x0009, 0x0013, 0x0014, 0xFFFF,
    0x0008, 0x000D, 0x0004, 0xFFE7, 0x000A, 0xFFF6, 0x0014, 0x001F,
    0xFFFE, 0x000B, 0xFFFB, 0xFFF8, 0x0008, 0x0002, 0x000F, 0xFFF3,
    0xFFEE, 0x0010, 0xFFE0, 0x0027, 0x0006, 0xFFF6, 0x0008, 0xFFF4,
    0x0010, 0xFFEA, 0xFFD6, 0x000A, 0xFFE9, 0xFFFA, 0xFFE9, 0x0000,
    0x0003, 0xFFDF, 0xFFFB, 0xFFF2, 0x0024, 0x0001, 0xFFF9, 0xFFE2,
    0x0004, 0x0006, 0x0005, 0x0018, 0xFFF8, 0xFFFD, 0x0003, 0x000E,
    0xFFF0, 0x001B, 0x0006, 0x000F, 0xFFFE, 0xFFF1, 0xFFF3, 0xFFF8,
    0xFFF2, 0xFFE1, 0x0003, 0x0016, 0x000A, 0x001A, 0x0010, 0x0005,
    0xFFE8, 0x000F, 0x0005, 0x0022, 0xFFFD, 0xFFF4, 0x0012, 0xFFD7,
    0xFFF4, 0xFFF4, 0x001C, 0x001F, 0xFFFA, 0x0004, 0x0012, 0xFFE5,
    0xFFF8, 0xFFEF, 0x0000, 0x0002, 0xFFFB, 0x000D, 0x0005, 0xFFF2,
    0xFFF4, 0x000A, 0x0000, 0xFFF3, 0xFFE8, 0xFFE7, 0xFFEE, 0x001B,
    0x0009, 0x0017, 0x0003, 0xFFF9, 0xFFE4, 0xFFFF, 0xFFFD, 0xFFE7,
    0x002F, 0x0009, 0xFFEC, 0x000A, 0x001E, 0xFFF0, 0xFFFB, 0x0018,
    0x0019, 0x000C, 0x000D, 0x0018, 0x003C, 0xFFE5, 0xFFFE, 0xFFF6,
    0x0004, 0xFFF3, 0x0007, 0x000F, 0xFFF3, 0xFFEF, 0x0018, 0xFFFD,
    0x000D, 0x0012, 0xFFF0, 0x0002, 0xFFFB, 0xFFF4, 0xFFF8, 0xFFFE,
    0x0010, 0x000D, 0x000D, 0x0009, 0x0008, 0xFFDB, 0x0001, 0x000D,
    0x000C, 0xFFF1, 0xFFEA, 0x0012, 0x0008, 0x0001, 0x0016, 0x000C,
    0x0025, 0x0010, 0x0003, 0x0025, 0xFFF5, 0x0001, 0xFFFF, 0x0006,
    0x0024, 0xFFF4, 0xFFF7, 0x0004, 0x0012, 0xFFF9, 0xFFF2, 0xFFEF,
    0x0013, 0xFFFC, 0xFFF7, 0xFFFF, 0xFFE9, 0xFFFE, 0x0010, 0x0009,
    0xFFFD, 0xFFF8, 0x0010, 0x0018, 0xFFED, 0xFFF5, 0xFFF3, 0xFFFB,
    0x0011, 0xFFF5, 0x0005, 0xFFE9, 0xFFE5, 0xFFE8, 0xFFE0, 0x001B,
    0xFFF0, 0x001D, 0xFFFC, 0x0006, 0x0005, 0xFFF5, 0xFFFD, 0xFFF4,
    0x0010, 0x0010, 0xFFFC, 0x000A, 0x0010, 0x001B, 0x001B, 0xFFF4,
    0xFFDD, 0xFFF9, 0xFFF2, 0xFFCE, 0x001B, 0xFFFD, 0x0023, 0x0018,
    0x0000, 0x0010, 0x000B, 0x0016, 0x0000, 0xFFFB, 0x0016, 0xFFFB,
    0xFFFB, 0x0003, 0xFFE8, 0xFFF8, 0x0007, 0xFFF4, 0x0020, 0xFFFD,
    0xFFEE, 0x0005, 0x000E, 0xFFFB, 0x0004, 0xFFFA, 0xFFFA, 0xFFF7,
    0xFFF9, 0xFFDC, 0x0013, 0x0010, 0xFFF7, 0xFFFA, 0x0008, 0xFFF0,
    0xFFFF, 0xFFFA, 0xFFE5, 0x000D, 0x0002, 0x001E, 0x0020, 0x0005,
    0x0007, 0xFFE8, 0xFFF2, 0xFFE5, 0xFFEF, 0x000B, 0xFFE3, 0xFFEE,
    0x001E, 0x0003, 0xFFFC, 0xFFF8, 0x002E, 0xFFFA, 0xFFF6, 0xFFFC,
    0x0002, 0xFFF5, 0xFFE8, 0xFFFC, 0x001D, 0xFFF4, 0xFFE3, 0xFFEF,
    0xFFE1, 0x0002, 0xFFEB, 0x000D, 0x000F, 0xFFF8, 0xFFF5, 0xFFEE,
    0x000D, 0x0000, 0xFFFF, 0xFFED, 0xFFF9, 0xFFED, 0x000E, 0xFFE7,
    0x0006, 0x000D, 0x0012, 0x0036, 0x000D, 0x0010, 0x0003, 0xFFFB,
    0xFFF0, 0xFFF0, 0x0008, 0xFFFC, 0x000A, 0xFFF5, 0x0003, 0x0013,
    0xFFFA, 0xFFF6, 0xFFF8, 0x002A, 0xFFFC, 0x0002, 0x000B, 0x0000,
    0x0003, 0x0010, 0xFFF1, 0x0006, 0xFFFC, 0x0015, 0x0005, 0x0003,
    0x000B, 0xFFEB, 0x000E, 0xFFF7, 0xFFF7, 0xFFF3, 0x0009, 0x0001,
    0xFFF2, 0x000F, 0xFFE8, 0xFFEB, 0x0014, 0x0023, 0xFFEE, 0x0017,
    0x0007, 0xFFDE, 0xFFF2, 0xFFF6, 0x0000, 0xFFEF, 0x000F, 0x000B,
    0x0006, 0x0020, 0xFFF1, 0x0014, 0x003E, 0x0002, 0x0008, 0x0003,
    0xFFE2, 0xFFF1, 0x001A, 0x000F, 0x0001, 0x0009, 0x0009, 0x000D,
    0x0006, 0xFFFB, 0x0006, 0x000F, 0x0006, 0x000F, 0xFFEA, 0xFFE8,
    0xFFFC, 0xFFE2, 0xFFF0, 0x0021, 0xFFF0, 0xFFEA, 0xFFE8, 0x0007,
    0x0001, 0xFFFB, 0xFFEB, 0xFFF7, 0xFFEE, 0xFFF9, 0xFFF1, 0xFFE2,
    0xFFE2, 0x0015, 0xFFFD, 0x0001, 0xFFF7, 0x0004, 0x0007, 0x0002,
    0x0006, 0xFFFA, 0xFFE9, 0xFFF6, 0x000C, 0x001B, 0xFFF1, 0xFFEA,
    0xFFFA, 0xFFE9, 0x0002, 0xFFEE, 0xFFF3, 0xFFFC, 0x001A, 0xFFFF,
    0x0001, 0x0017, 0x000B, 0x0011, 0x0014, 0xFFEB, 0x0004, 0x0003,
    0xFFF8, 0xFFE5, 0x0010, 0xFFEF, 0x000A, 0x0012, 0xFFD8, 0x0008,
    0x0025, 0xFFF8, 0xFFFE, 0xFFFB, 0x0014, 0xFFEE, 0x0008, 0x000D,
    0x0020, 0x0038, 0x0002, 0x0004, 0xFFF0, 0x0010, 0x0026, 0xFFEB,
    0xFFE8, 0xFFE9, 0xFFFA, 0xFFF6, 0x000A, 0xFFFF, 0xFFDE, 0x0002,
    0x0012, 0xFFE8, 0x0018, 0x0001, 0x0022, 0x0000, 0x0000, 0xFFFB,
    0x0005, 0xFFE1, 0xFFE2, 0xFFF5, 0xFFE1, 0x0032, 0x0004, 0x0002,
    0xFFFE, 0xFFF7, 0xFFEC, 0xFFFF, 0xFFEA, 0xFFFE, 0xFFE3, 0x000D,
    0xFFF1, 0x0012, 0x0016, 0x000E, 0x000B, 0xFFDF, 0x0002, 0x000C,
    0x0001, 0xFFF9, 0xFFF3, 0xFFEB, 0xFFFF, 0x001A, 0xFFF1, 0x0010,
    0x0012, 0x0001, 0xFFFB, 0x000F, 0xFFF2, 0xFFE2, 0x000B, 0xFFFD,
    0xFFF5, 0x0004, 0xFFED, 0xFFF4, 0xFFDF, 0xFFF7, 0xFFEA, 0x0024,
    0x0000, 0x0016, 0xFFFD, 0x001D, 0xFFF3, 0x0006, 0x0019, 0x0010,
    0xFFDD, 0xFFE2, 0x0003, 0xFFF5, 0xFFFF, 0xFFF3, 0xFFEA, 0x0001,
    0x000D, 0x0014, 0xFFF7, 0x0009, 0x0005, 0x000F, 0xFFEE, 0xFFF5,
    0xFFFD, 0x000C, 0xFFEB, 0xFFFA, 0x0007, 0x0002, 0xFFF7, 0x0014,
    0xFFFD, 0x000C, 0x000A, 0xFFED, 0xFFF6, 0xFFE0, 0x000E, 0xFFFC,
    0x0002, 0x0018, 0xFFE9, 0xFFFD, 0xFFF1, 0xFFFC, 0xFFF9, 0x0010,
    0xFFF8, 0x000C, 0xFFF1, 0xFFF2, 0xFFF5, 0x0011, 0x0005, 0xFFEB,
    0xFFEC, 0xFFEA, 0xFFDC, 0x000D, 0xFFFE, 0x0026, 0xFFF7, 0xFFF5,
    0xFFF7, 0xFFF6, 0x0007, 0xFFF0, 0x000C, 0xFFFA, 0x0011, 0xFFF0,
    0x0006, 0xFFF5, 0x001A, 0x0019, 0x0007, 0x0000, 0x000C, 0xFFED,
    0xFFF4, 0xFFF7, 0xFFE9, 0xFFF7, 0x0001, 0x000C, 0xFFCF, 0x000A,
    0xFFEF, 0x0008, 0x000F, 0xFFF6, 0xFFF6, 0xFFF7, 0xFFFA, 0x0008,
    0x000C, 0x0011, 0x0006, 0x0011, 0x0008, 0x0020, 0xFFF2, 0xFFF1,
    0xFFFC, 0x000E, 0xFFFD, 0x000C, 0xFFFB, 0x0002, 0x0005, 0x0008,
    0xFFFC, 0xFFF7, 0xFFF8, 0x0000, 0x0016, 0xFFEC, 0x0037, 0x0000,
    0xFFEB, 0xFFE5, 0x0008, 0xFFF8, 0x000B, 0xFFF0, 0xFFED, 0xFFF8,
    0x001F, 0xFFF9, 0xFFFA, 0xFFF7, 0xFFED, 0x0001, 0xFFFC, 0xFFF2,
    0xFFE6, 0x001B, 0xFFFB, 0xFFFA, 0x0003, 0x0007, 0x000A, 0x000B,
    0x0026, 0x0015, 0xFFFB, 0xFFFF, 0x0002, 0xFFF5, 0x0001, 0x0003,
    0xFFFA, 0xFFFF, 0xFFF1, 0xFFF6, 0xFFF6, 0xFFED, 0x0010, 0xFFFB,
    0xFFFF, 0xFFF4, 0x0017, 0xFFFF, 0x0010, 0x0023, 0xFFE5, 0xFFF2,
    0xFFDF, 0xFFE6, 0x002E, 0xFFFB, 0xFFDC, 0x0004, 0xFFF8, 0x0014,
    0xFFED, 0xFFEE, 0x0021, 0x0004, 0xFFFE, 0x0010, 0x001C, 0xFFF0,
    0x0000, 0xFFF1, 0x0009, 0x0001, 0x0003, 0x0001, 0x0009, 0x0010,
    0x0020, 0xFFEB, 0x0012, 0xFFEB, 0x000B, 0xFFDF, 0xFFFB, 0x0015,
    0x0007, 0x0015, 0x0021, 0xFFFC, 0x0025, 0x0000, 0x000E, 0x0015,
    0x0015, 0x0005, 0xFFF1, 0xFFC3, 0xFFFE, 0xFFFB, 0xFFCB, 0xFFE4,
    0xFFFC, 0xFFE7, 0xFFF0, 0x0022, 0xFFFF, 0xFFE4, 0xFFFF, 0xFFE3,
    0xFFEC, 0x0008, 0x000D, 0x000D, 0x0007, 0xFFF4, 0xFFFC, 0xFFFA,
    0xFFE5, 0x0025, 0xFFE0, 0xFFF8, 0x002E, 0x0000, 0x0017, 0x0003,
    0x0010, 0x0004, 0xFFDF, 0x001C, 0xFFED, 0x0006, 0x0015, 0x0011,
    0xFFF8, 0x0004, 0x0024, 0xFFF1, 0xFFEB, 0x001F, 0x0005, 0xFFF9,
    0x002D, 0xFFF8, 0x0012, 0x0021, 0x0001, 0x0007, 0x000F, 0xFFF2,
    0x0011, 0x000E, 0x001D, 0xFFEE, 0x000D, 0xFFF4, 0xFFF7, 0xFFF6,
    0xFFEF, 0xFFEF, 0xFFF9, 0x0009, 0xFFF4, 0xFFF9, 0xFFE3, 0xFFE6,
    0xFFFC, 0x0002, 0xFFFF, 0x0008, 0x000E, 0xFFED, 0x0025, 0x0014,
    0x001C, 0x0015, 0xFFF0, 0xFFF5, 0x0001, 0x0003, 0xFFF7, 0x0000,
    0x0010, 0x0011, 0xFFFB, 0x0018, 0x0008, 0xFFFC, 0x0020, 0x0010,
    0x0019, 0x0000, 0x0006, 0x000F, 0xFFF7, 0xFFF7, 0xFFE0, 0xFFF1,
    0x0003, 0x0001, 0xFFFA, 0xFFF4, 0xFFE2, 0x0016, 0xFFE7, 0x0009,
    0x0000, 0x0010, 0x0009, 0xFFE4, 0xFFF5, 0xFFF8, 0x001E, 0x0008,
    0x0020, 0x0012, 0x000A, 0xFFF0, 0xFFF4, 0x0008, 0x0002, 0x0015,
    0x000E, 0x0002, 0xFFF8, 0xFFFD, 0xFFF5, 0x000D, 0xFFED, 0x000D,
    0xFFF5, 0x0022, 0x0017, 0xFFF7, 0xFFFC, 0xFFF7, 0x0002, 0x0000,
    0x0031, 0x0006, 0xFFF8, 0x001E, 0xFFFD, 0xFFEB, 0xFFFC, 0xFFF6,
    0xFFF9, 0xFFF5, 0x0008, 0x0002, 0x0001, 0x000D, 0xFFEF, 0x0011,
    0xFFFE, 0x000A, 0xFFEC, 0xFFF5, 0xFFFE, 0xFFFB, 0x000C, 0x000A,
    0x0011, 0x0018, 0x0002, 0x001E, 0xFFFE, 0x0007, 0x000A, 0x0001,
    0x0001, 0xFFF2, 0xFFFD, 0xFFF9, 0x0015, 0xFFF3, 0xFFF0, 0x000A,
    0x0000, 0x0005, 0xFFEF, 0xFFD4, 0xFFE4, 0x0001, 0x0006, 0xFFE4,
    0xFFF9, 0xFFDF, 0xFFE9, 0x000F, 0x001F, 0x0000, 0x000F, 0x0000,
    0x0002, 0xFFEF, 0x0002, 0xFFFE, 0xFFF3, 0x0000, 0xFFE8, 0x0003,
    0x0005, 0xFFF9, 0x0015, 0x0008, 0xFFFD, 0x000C, 0x002C, 0x000C,
    0xFFEF, 0xFFFB, 0xFFF5, 0xFFF3, 0xFFFF, 0xFFF7, 0xFFEA, 0x0002,
    0x000F, 0xFFF0, 0x0005, 0xFFE8, 0xFFF8, 0xFFF4, 0x0022, 0xFFFB,
    0xFFF4, 0xFFF5, 0x0012, 0xFFF3, 0xFFFB, 0x0021, 0xFFF2, 0xFFFB,
    0x0007, 0xFFF1, 0xFFFC, 0xFFE3, 0x0001, 0xFFF9, 0x000C, 0x001A,
    0x0008, 0x0020, 0x0006, 0x000C, 0xFFFF, 0x0023, 0x001E, 0xFFFA,
    0x0006, 0x000A, 0x0016, 0xFFFD, 0x0014, 0x000E, 0x000D, 0xFFF0,
    0x0003, 0x0025, 0xFFE6, 0x0006, 0x000C, 0x0014, 0x000E, 0x0008,
    0x0005, 0x0016, 0x0013, 0xFFFD, 0xFFFE, 0xFFF7, 0x0001, 0xFFFB,
    0xFFEC, 0x0014, 0xFFF7, 0x000C, 0xFFE7, 0xFFF0, 0xFFF8, 0xFFEA,
    0xFFF5, 0x001E, 0xFFE6, 0xFFEC, 0x0011, 0xFFF8, 0x0008, 0xFFFC,
    0xFFFA, 0xFFE7, 0xFFEB, 0xFFFA, 0xFFF9, 0x0019, 0xFFDD, 0x000C,
    0xFFF8, 0x0003, 0x002A, 0x0005, 0xFFFB, 0xFFF2, 0xFFEA, 0x001F,
    0x0000, 0xFFF8, 0x0001, 0xFFFA, 0xFFEB, 0xFFE3, 0xFFEE, 0x0002,
    0x0003, 0x0023, 0xFFFB, 0x000B, 0xFFF7, 0x000D, 0x0001, 0xFFED,
    0x0000, 0xFFFD, 0xFFED, 0xFFF5, 0xFFF9, 0x0011, 0xFFEB, 0x0005,
    0xFFF6, 0xFFFA, 0xFFFB, 0xFFF4, 0xFFFA, 0x0003, 0xFFFD, 0x0019,
    0xFFFE, 0x0001, 0xFFF3, 0xFFFA, 0xFFE1, 0x001E, 0xFFF2, 0xFFDC,
    0x0004, 0xFFF2, 0x0000, 0x0017, 0x0018, 0xFFF8, 0x0003, 0xFFF3,
    0xFFFA, 0xFFFF, 0x0003, 0xFFE2, 0xFFE6, 0x000C, 0xFFF7, 0x000A,
    0xFFF4, 0xFFD6, 0x0009, 0x000D, 0x0009, 0xFFF8, 0xFFF5, 0x0012,
    0xFFE9, 0x0000, 0xFFE2, 0xFFFD, 0xFFF4, 0x0004, 0x0008, 0xFFEB,
    0xFFFF, 0x0012, 0x0005, 0x0010, 0xFFEB, 0xFFFF, 0x000D, 0x0007,
    0xFFF8, 0xFFF7, 0xFFF0, 0x000A, 0xFFDB, 0xFFF2, 0xFFFF, 0x0010,
    0xFFFD, 0xFFEE, 0xFFEB, 0x0009, 0x0007, 0x0019, 0x001F, 0xFFE8,
    0x000B, 0x0010, 0x0021, 0x0024, 0xFFFC, 0x0011, 0x000D, 0x002D,
    0x001C, 0x000E, 0x000F, 0xFFED, 0xFFED, 0xFFFA, 0x0014, 0x0017,
    0xFFE9, 0x0004, 0xFFFA, 0xFFF7, 0x0007, 0x0005, 0x0010, 0xFFDF,
    0x000B, 0xFFF2, 0x0002, 0x0011, 0xFFEC, 0x0009, 0x0002, 0x0023,
    0x0000, 0xFFEA, 0x000F, 0xFFE9, 0xFFF9, 0xFFFA, 0x0000, 0xFFEE,
    0xFFD9, 0x0009, 0xFFE9, 0xFFFB, 0x0009, 0xFFF1, 0xFFE6, 0x0005,
    0x0003, 0x000A, 0x0015, 0x0016, 0x0007, 0x0012, 0x002D, 0xFFF6,
    0x0004, 0x000A, 0x001D, 0xFFFD, 0x0006, 0x0005, 0x0016, 0x0012,
    0xFFE5, 0xFFEA, 0x0005, 0xFFF2, 0xFFF3, 0xFFE5, 0xFFF2, 0xFFEF,
    0x0021, 0xFFF1, 0x000A, 0x0013, 0x000F, 0xFFE5, 0x0008, 0xFFFA,
    0xFFF0, 0xFFFA, 0x0012, 0xFFFE, 0x0010, 0x0024, 0xFFEA, 0x0004,
    0x0009, 0xFFFA, 0xFFFB, 0xFFFF, 0xFFF8, 0x0010, 0xFFF0, 0xFFF3,
    0x000E, 0xFFEF, 0xFFEE, 0x0016, 0x000A, 0xFFEF, 0xFFFD, 0xFFEB,
    0x0013, 0x0007, 0xFFFF, 0xFFDD, 0xFFFF, 0xFFF5, 0xFFDF, 0xFFF3,
    0xFFEE, 0xFFF2, 0xFFF6, 0x001B, 0xFFED, 0x000A, 0xFFF3, 0x0014,
    0x0013, 0xFFEA, 0xFFFA, 0x0015, 0x0007, 0x0019, 0xFFE5, 0xFFF6,
    0x0007, 0x0013, 0xFFE6, 0x001B, 0xFFEE, 0xFFFF, 0x0008, 0x0001,
    0xFFFD, 0x0013, 0x0007, 0x0005, 0x001B, 0x0002, 0xFFE7, 0x0013,
    0x0010, 0xFFEC, 0x0006, 0x001F, 0x0004, 0x0007, 0xFFF1, 0x0003,
    0x0005, 0xFFF5, 0xFFF6, 0x001D, 0xFFE2, 0xFFEC, 0x0006, 0x0002,
    0x0005, 0xFFE5, 0xFFF6, 0xFFF9, 0xFFEA, 0xFFEE, 0xFFEA, 0x000F,
    0x0015, 0xFFFA, 0x0002, 0xFFE8, 0x000F, 0x0006, 0x0023, 0xFFFA,
    0xFFFE, 0x0008, 0xFFD6, 0xFFF3, 0x0013, 0xFFEB, 0x000A, 0x000F,
    0xFFFE, 0x0015, 0xFFEF, 0xFFDD, 0xFFFD, 0x0005, 0x0029, 0x001F,
    0x0018, 0xFFF4, 0xFFDB, 0xFFED, 0x000D, 0x0006, 0x0012, 0x0010,
    0x0003, 0x0023, 0x0016, 0x001C, 0x000F, 0xFFEE, 0xFFE6, 0x0012,
    0x001C, 0xFFE7, 0xFFDB, 0x000F, 0xFFFF, 0xFFFB, 0x0005, 0x0013,
    0x0003, 0x000F, 0xFFF2, 0xFFF8, 0xFFD9, 0xFFF7, 0x000C, 0x0004,
    0x0000, 0x0000, 0xFFF8, 0xFFF0, 0x0024, 0xFFEC, 0x0001, 0xFFF8,
    0x000E, 0xFFFE, 0x000B, 0x000C, 0xFFF1, 0xFFF8, 0xFFF6, 0xFFF8,
    0xFFFF, 0xFFFF, 0xFFFA, 0x0000, 0x0004, 0xFFF7, 0x0002, 0x001B,
    0xFFFB, 0xFFE7, 0x0000, 0x0018, 0x0006, 0x0013, 0xFFFB, 0xFFEA,
    0x002E, 0x0004, 0x0009, 0xFFF3, 0xFFF0, 0x0007, 0xFFFB, 0xFFF4,
    0xFFF6, 0xFFF7, 0xFFF8, 0xFFF1, 0x0006, 0x000D, 0xFFEA, 0x0002,
    0xFFF3, 0xFFE4, 0x0014, 0xFFFE, 0xFFFB, 0x000A, 0x0004, 0xFFFC,
    0xFFFD, 0x000C, 0xFFFE, 0x0002, 0x0008, 0x0014, 0xFFEE, 0x0002,
    0xFFE6, 0x0002, 0x0004, 0x0004, 0x000F, 0x0004, 0x0012, 0xFFE7,
    0xFFEC, 0xFFF8, 0x0010, 0xFFDB, 0x000D, 0x000A, 0xFFF6, 0xFFDB,
    0xFFFF, 0xFFF2, 0xFFE2, 0xFFEA, 0x0007, 0xFFC6, 0x0008, 0x001B,
    0x001D, 0x0004, 0xFFEF, 0x0003, 0x000D, 0xFFE9, 0xFFEB, 0x0008,
    0x000E, 0x000F, 0x0010, 0xFFD9, 0xFFEF, 0x0002, 0x000A, 0x0001,
    0xFFF8, 0x000A, 0xFFD5, 0xFFE2, 0xFFD3, 0x0011, 0x0007, 0x0001,
    0xFFFD, 0x0002, 0x000B, 0x0007, 0x001D, 0xFFED, 0xFFD3, 0xFFEE,
    0xFFF4, 0xFFED, 0x0019, 0xFFDE, 0xFFEF, 0x0015, 0xFFFF, 0x0019,
    0xFFED, 0x0011, 0x0001, 0xFFFD, 0x0004, 0x000A, 0xFFD8, 0x0000,
    0x0004, 0xFFE8, 0x0018, 0xFFE8, 0x000B, 0x0005, 0xFFE9, 0x0004,
    0x000A, 0xFFFD, 0x0015, 0xFFFF, 0x000E, 0x0014, 0xFFF6, 0x0008,
    0x001F, 0xFFF4, 0x0014, 0x0010, 0xFFF5, 0x000C, 0xFFF6, 0x0000,
    0xFFF2, 0x0013, 0xFFFC, 0xFFCD, 0xFFF9, 0xFFEF, 0xFFF3, 0x0012,
    0xFFE5, 0x0001, 0xFFF7, 0x0013, 0x0005, 0xFFDE, 0xFFFF, 0x0011,
    0xFFEC, 0xFFFC, 0xFFEE, 0xFFF6, 0xFFFC, 0xFFFD, 0xFFF6, 0x0033,
    0xFFF6, 0x0023, 0xFFEF, 0xFFF7, 0xFFF0, 0x0026, 0x0005, 0xFFE7,
    0x0001, 0x0003, 0x001A, 0xFFFA, 0x0000, 0xFFF1, 0x0016, 0xFFD7,
    0x0018, 0xFFFE, 0xFFE8, 0x0001, 0xFFFF, 0x0007, 0xFFEB, 0xFFFD,
    0xFFFA, 0x0001, 0xFFF8, 0xFFED, 0x0007, 0x0001, 0xFFED, 0xFFEB,
    0x000C, 0xFFDB, 0xFFF7, 0x000D, 0x0007, 0x0017, 0xFFED, 0x0005,
    0xFFFD, 0x0002, 0xFFF3, 0xFFE2, 0xFFF2, 0x001D, 0x0005, 0x0004,
    0xFFF3, 0x0009, 0xFFED, 0xFFFF, 0xFFFC, 0xFFE2, 0xFFFB, 0x0023,
    0x000E, 0xFFEF, 0xFFE8, 0x0012, 0xFFFE, 0x0001, 0xFFF9, 0x0019,
    0xFFF8, 0xFFF0, 0xFFE7, 0x000D, 0x001B, 0xFFEB, 0x0008, 0x0026,
    0xFFD3, 0xFFE5, 0xFFFB, 0x0009, 0xFFF4, 0xFFDA, 0x0004, 0xFFDD,
    0xFFFF, 0x000B, 0xFFF1, 0xFFFE, 0x0002, 0x0012, 0x000B, 0x0006,
    0x0000, 0xFFED, 0x0005, 0x0002, 0xFFE9, 0xFFF3, 0x0012, 0x0016,
    0x0003, 0x0014, 0xFFDD, 0x0018, 0x0008, 0x0001, 0x0007, 0x000E,
    0xFFFF, 0xFFFA, 0xFFF6, 0x0023, 0x000E, 0x0003, 0x0002, 0xFFFB,
    0xFFE7, 0x000D, 0xFFEA, 0x001B, 0xFFE4, 0x0006, 0x000A, 0xFFFC,
    0xFFF6, 0xFFFF, 0xFFFE, 0x0019, 0x0025, 0x0000, 0xFFFC, 0x0009,
    0x0007, 0xFFF0, 0x000F, 0xFFF1, 0x0020, 0xFFFD, 0xFFF9, 0x0009,
    0xFFF7, 0xFFFD, 0xFFF0, 0x000A, 0x0021, 0x0009, 0xFFF9, 0xFFF3,
    0xFFED, 0xFFF9, 0xFFED, 0x0017, 0xFFFF, 0x0008, 0x000B, 0x0006,
    0x000B, 0x000B, 0xFFF7, 0x0002, 0x001B, 0xFFF6, 0x0002, 0xFFFB,
    0xFFEE, 0x0001, 0x0003, 0xFFF9, 0xFFF8, 0x0005, 0x0012, 0x0003,
    0xFFE8, 0xFFF1, 0x0001, 0x000A, 0xFFFC, 0xFFF6, 0x000B, 0xFFF1,
    0xFFF7, 0x0003, 0x0016, 0x0015, 0xFFF3, 0x001E, 0xFFF5, 0x000A,
    0x000C, 0x001B, 0xFFEE, 0x000F, 0xFFE9, 0xFFF1, 0xFFF3, 0x000C,
    0x0008, 0xFFF1, 0x0017, 0x0013, 0xFFEA, 0x0021, 0x0004, 0x0000,
    0xFFFA, 0x0019, 0xFFFD, 0xFFDB, 0xFFEC, 0x0008, 0x0000, 0x0004,
    0xFFF2, 0xFFF8, 0x0004, 0x000A, 0x0015, 0xFFFB, 0x0004, 0xFFEC,
    0x0005, 0xFFED, 0xFFF9, 0xFFF7, 0x0011, 0xFFF4, 0x0016, 0xFFF8,
    0xFFF2, 0xFFF0, 0xFFF6, 0xFFF8, 0xFFF8, 0x000D, 0x000F, 0x0002,
    0x000C, 0x000E, 0x0019, 0x0015, 0x0008, 0x0015, 0xFFE1, 0x0018,
    0xFFF9, 0xFFFA, 0x0011, 0x0014, 0xFFFD, 0x000B, 0xFFFC, 0xFFF9,
    0x0015, 0x001D, 0xFFFC, 0xFFFF, 0xFFFF, 0x000E, 0x0007, 0x0007,
    0xFFF6, 0xFFF5, 0xFFD5, 0xFFEC, 0x0015, 0xFFFB, 0xFFDD, 0x0006,
    0xFFF8, 0xFFF4, 0xFFED, 0x0008, 0xFFFC, 0x001B, 0xFFE6, 0xFFF9,
    0x0008, 0x0020, 0xFFFE, 0x0007, 0x000D, 0x0004, 0x000F, 0x001E,
    0xFFF9, 0x0014, 0xFFE8, 0x0013, 0xFFF1, 0x0002, 0x0007, 0xFFE2,
    0xFFE1, 0x001C, 0xFFFA, 0x002C, 0xFFF9, 0x0014, 0x0002, 0x0007,
    0x0017, 0x0006, 0x0009, 0xFFFE, 0x0012, 0x0009, 0xFFF9, 0x002A,
    0xFFEE, 0xFFFC, 0xFFF3, 0x0000, 0x0022, 0x0019, 0xFFF0, 0xFFE1,
    0xFFF3, 0x0010, 0xFFF5, 0x000C, 0xFFFC, 0xFFD5, 0x0027, 0x0002,
    0xFFEC, 0xFFF9, 0xFFFF, 0x0007, 0x0012, 0xFFF5, 0x0011, 0x000F,
    0x0016, 0xFFFC, 0x0005, 0x0005, 0x0006, 0xFFEC, 0xFFFC, 0xFFEC,
    0x0031, 0xFFFA, 0x0019, 0x000E, 0xFFEF, 0x0000, 0x0008, 0xFFFF,
    0x0004, 0x001F, 0xFFE8, 0xFFF5, 0x000A, 0xFFDB, 0xFFEC, 0xFFF0,
    0xFFFA, 0x0000, 0xFFF6, 0x0002, 0xFFF8, 0x0009, 0x0018, 0xFFE1,
    0xFFEF, 0x001E, 0xFFEE, 0x0029, 0xFFF9, 0xFFE5, 0xFFFA, 0xFFE7,
    0xFFED, 0xFFF0, 0x0001, 0xFFED, 0xFFDD, 0xFFF2, 0x0002, 0xFFF4,
    0xFFE5, 0xFFEE, 0x0010, 0x0018, 0xFFF0, 0x0002, 0x0021, 0x0006,
    0xFFFC, 0xFFF8, 0xFFF8, 0x000C, 0x002C, 0x0002, 0x0011, 0xFFFA,
    0xFFFA, 0xFFED, 0x0001, 0xFFE8, 0xFFF3, 0xFFFD, 0xFFEF, 0xFFD3,
    0xFFC9, 0xFFFC, 0x0023, 0x0016, 0xFFF7, 0xFFEA, 0x0010, 0xFFE5,
    0x0018, 0xFFF1, 0x000A, 0x0004, 0xFFDA, 0xFFFB, 0x0000, 0xFFF3,
    0x0008, 0xFFED, 0xFFF0, 0x0004, 0xFFD9, 0xFFF8, 0x0005, 0xFFF5,
    0x0012, 0x0017, 0x001E, 0x000A, 0x002C, 0xFFF6, 0xFFF5, 0x001B,
    0xFFE5, 0x0008, 0xFFED, 0xFFFB, 0x0008, 0x0014, 0x0022, 0xFFF4,
    0x0000, 0xFFFE, 0x0001, 0xFFF8, 0xFFEF, 0xFFEA, 0xFFEE, 0x0011,
    0x0003, 0xFFF1, 0xFFF4, 0xFFF2, 0xFFFC, 0xFFE8, 0xFFE3, 0x0007,
    0x0015, 0x0017, 0xFFF7, 0xFFEA, 0x0027, 0x0005, 0x0012, 0x0011,
    0x001A, 0xFFED, 0xFFDE, 0xFFF6, 0xFFF6, 0x0003, 0xFFF9, 0xFFFA,
    0xFFF9, 0xFFEA, 0xFFEB, 0x0022, 0xFFF2, 0xFFF5, 0xFFF4, 0x0008,
    0x0010, 0xFFEB, 0x0003, 0x0025, 0xFFFF, 0x000A, 0xFFE5, 0xFFF5,
    0x0015, 0xFFF9, 0x0000, 0xFFF8, 0xFFE5, 0xFFF5, 0x0001, 0x000F,
    0x0005, 0xFFEE, 0x0011, 0x0015, 0xFFFA, 0x000D, 0xFFF3, 0xFFEF,
    0x0006, 0xFFEC, 0xFFE2, 0xFFFC, 0xFFF5, 0x0001, 0xFFFA, 0xFFFA,
    0xFFFE, 0x0005, 0xFFE2, 0x0004, 0x0000, 0xFFEC, 0x001E, 0xFFE0,
    0x0005, 0x0002, 0xFFEE, 0xFFFC, 0x0008, 0xFFEE, 0xFFCF, 0x0020,
    0xFFEE, 0x0002, 0xFFFC, 0xFFF0, 0xFFF8, 0xFFFF, 0x0025, 0xFFF5,
    0xFFFF, 0x000D, 0x0001, 0x000D, 0xFFFE, 0xFFFB, 0xFFF3, 0x0012,
    0x0005, 0x000C, 0x0007, 0xFFDD, 0xFFED, 0xFFFE, 0x0007, 0x000C,
    0x0004, 0x0000, 0xFFED, 0xFFFF, 0x001A, 0xFFF4, 0xFFFF, 0x0008,
    0xFFE5, 0xFFFB, 0x0017, 0xFFEB, 0x0026, 0xFFF2, 0x0018, 0xFFF4,
    0x0008, 0xFFFA, 0xFFEE, 0xFFF7, 0xFFF2, 0x0010, 0xFFF4, 0xFFE6,
    0xFFE8, 0x0026, 0x000B, 0xFFF1, 0xFFF8, 0xFFFB, 0x0000, 0xFFFC,
    0x0018, 0x0008, 0x0019, 0xFFFB, 0xFFF7, 0xFFF8, 0xFFEB, 0x001E,
    0x0011, 0x0010, 0xFFF7, 0xFFF9, 0x0024, 0x001C, 0xFFFE, 0xFFFA,
    0x0010, 0x000A, 0x000D, 0xFFFF, 0x0005, 0xFFFD, 0x0008, 0xFFE3,
    0xFFFB, 0xFFEF, 0x001C, 0x001B, 0x0019, 0xFFF1, 0x0008, 0x0012,
    0x0019, 0x000C, 0x0025, 0xFFF8, 0xFFFA, 0xFFE2, 0xFFDC, 0xFFFA,
    0x0005, 0x0022, 0x0001, 0x0010, 0xFFFB, 0xFFF7, 0xFFF2, 0xFFEB,
    0xFFED, 0x0009, 0x0002, 0x0012, 0x000C, 0x0021, 0xFFEB, 0x0035,
    0x000C, 0xFFD7, 0xFFE7, 0xFFE5, 0xFFEA, 0x001C, 0x0013, 0x001D,
    0xFFE2, 0xFFF6, 0xFFF4, 0xFFE1, 0xFFF1, 0xFFFA, 0xFFFC, 0x000C,
    0xFFEE, 0x0011, 0xFFFE, 0x0007, 0x002A, 0x0013, 0xFFEC, 0xFFEB,
    0xFFED, 0x0008, 0x0011, 0x0019, 0x0026, 0x0010, 0x001E, 0xFFF3,
    0x001A, 0xFFE5, 0xFFFB, 0x0016, 0x0023, 0xFFF8, 0xFFFD, 0x0011,
    0x0014, 0x001E, 0xFFE9, 0x0025, 0xFFFD, 0x000D, 0xFFFE, 0x0021,
    0x0003, 0xFFEB, 0xFFF9, 0xFFF1, 0x000B, 0xFFEE, 0xFFD7, 0xFFED,
    0xFFF0, 0xFFFA, 0xFFF0, 0x0008, 0xFFDC, 0x0002, 0xFFF9, 0x0017,
    0xFFFF, 0x0009, 0xFFEE, 0x0011, 0xFFF2, 0xFFE6, 0x0007, 0xFFEF,
    0x0017, 0x0004, 0x0010, 0xFFFC, 0x000D, 0x0004, 0xFFF9, 0x0010,
    0xFFFD, 0xFFF6, 0xFFF8, 0x0010, 0xFFF7, 0xFFF2, 0x000F, 0x000A,
    0x002E, 0xFFFC, 0xFFEC, 0xFFF0, 0xFFF5, 0xFFF7, 0x000F, 0x0002,
    0xFFE8, 0x001D, 0xFFF3, 0xFFFE, 0x001A, 0xFFF4, 0x001C, 0x002C,
    0xFFEB, 0x000C, 0xFFFF, 0x0021, 0x0013, 0x000E, 0x000C, 0xFFFC,
    0xFFF0, 0xFFED, 0x0005, 0x0003, 0x0002, 0xFFF4, 0xFFE9, 0x000A,
    0x000B, 0x0001, 0xFFE4, 0x000A, 0x0013, 0xFFED, 0xFFFE, 0xFFF5,
    0xFFE8, 0x0016, 0x0029, 0x0003, 0xFFFF, 0x001B, 0xFFFB, 0xFFFE,
    0x0011, 0xFFE0, 0xFFFF, 0x0005, 0x000E, 0xFFFC, 0xFFFF, 0x0013,
    0xFFFA, 0x0000, 0xFFF4, 0xFFFA, 0x001C, 0xFFF5, 0x0006, 0x0002,
    0xFFFF, 0xFFF0, 0xFFF8, 0xFFF5, 0xFFFD, 0xFFF1, 0x000D, 0xFFF5,
    0x0005, 0x0018, 0xFFE6, 0x0007, 0x000D, 0xFFF5, 0xFFF6, 0x0021,
    0x0019, 0xFFFC, 0x0008, 0xFFF4, 0x0007, 0xFFFF, 0xFFE3, 0xFFFB,
    0x000F, 0x0013, 0xFFE4, 0x0033, 0x0009, 0x0010, 0xFFF8, 0x001E,
    0x0002, 0x000D, 0x0002, 0x0013, 0xFFEA, 0xFFFA, 0x0007, 0xFFE8,
    0xFFE0, 0xFFF7, 0x000E, 0x001B, 0x0004, 0xFFFA, 0x0006, 0x000B,
    0x0006, 0xFFF1, 0xFFEE, 0x0006, 0xFFEE, 0xFFF9, 0xFFF1, 0x0008,
    0x0015, 0x0014, 0x0000, 0xFFFF, 0xFFF8, 0x0004, 0x0008, 0xFFED,
    0x0008, 0x0011, 0xFFF9, 0x0003, 0xFFEE, 0xFFEA, 0x000B, 0xFFEB,
    0x0026, 0xFFE8, 0x000C, 0xFFF0, 0xFFFF, 0x000C, 0xFFE8, 0x0007,
    0xFFFF, 0x0011, 0x0015, 0x0022, 0x0001, 0x0010, 0x0004, 0xFFFF,
    0x000D, 0xFFCF, 0x000F, 0xFFFD, 0xFFF9, 0xFFF2, 0x0003, 0xFFF4,
    0x0011, 0xFFF9, 0xFFE2, 0xFFFB, 0xFFEB, 0xFFE6, 0xFFEB, 0x0003,
    0xFFF8, 0xFFF5, 0x0006, 0xFFD7, 0xFFE8, 0x000B, 0x0008, 0x0004,
    0x0018, 0x0000, 0x0008, 0xFFFC, 0xFFE8, 0xFFF5, 0x0006, 0x0029,
    0xFFF8, 0x000B, 0xFFEB, 0xFFFD, 0xFFEB, 0x001A, 0xFFE2, 0x0005,
    0x0011, 0x0007, 0x0003, 0x000C, 0xFFF9, 0x000E, 0x000F, 0x0003,
    0x000D, 0x0031, 0x0004, 0x0001, 0x0001, 0xFFF0, 0x0015, 0xFFDE,
    0xFFFF, 0xFFEF, 0xFFE8, 0xFFF9, 0xFFFF, 0xFFF4, 0x000C, 0x0010,
    0x0026, 0x0018, 0x000B, 0x0015, 0xFFEE, 0x0016, 0xFFF9, 0xFFFD,
    0x0008, 0xFFEF, 0x0008, 0x0013, 0xFFF8, 0xFFFC, 0x0000, 0x0001,
    0x0015, 0xFFEC, 0xFFF1, 0xFFF8, 0xFFEE, 0x0007, 0xFFEE, 0xFFFA,
    0x0006, 0x000F, 0x0006, 0xFFF5, 0x0004, 0x0006, 0x000E, 0xFFE5,
    0xFFE0, 0x0009, 0x0007, 0x0018, 0xFFEA, 0x0006, 0x0002, 0xFFED,
    0x0002, 0xFFF3, 0xFFF8, 0xFFE2, 0x0009, 0xFFF0, 0xFFE4, 0xFFCD,
    0x000F, 0xFFED, 0xFFE3, 0x0005, 0x0007, 0x0001, 0x0008, 0x000C,
    0x0019, 0x0004, 0xFFF6, 0xFFDF, 0x000D, 0x000B, 0xFFE6, 0xFFF9,
    0x0005, 0xFFE8, 0x000D, 0x000B, 0xFFFD, 0x000F, 0xFFF8, 0x000B,
    0xFFFF, 0x0010, 0x0006, 0xFFFE, 0x001C, 0x000B, 0xFFF4, 0x0006,
    0xFFFA, 0x0000, 0xFFFF, 0xFFED, 0x000E, 0x0004, 0xFFFF, 0xFFFB,
    0x0011, 0x0020, 0xFFFB, 0x0002, 0xFFFF, 0xFFE5, 0x0029, 0xFFFD,
    0xFFE8, 0xFFEA, 0xFFFE, 0x000B, 0x0013, 0x0013, 0xFFE4, 0xFFF6,
    0x000B, 0xFFFF, 0xFFE9, 0xFFF6, 0x0002, 0x000C, 0x0005, 0xFFFD,
    0xFFF0, 0x0013, 0x000C, 0x0004, 0x0013, 0xFFF2, 0xFFFF, 0xFFDF,
    0xFFEB, 0xFFF4, 0x001C, 0xFFD4, 0x001A, 0x000C, 0xFFF3, 0x0002,
    0xFFE8, 0xFFE3, 0x000F, 0xFFFE, 0xFFF5, 0x0009, 0xFFEC, 0x0010,
    0x002E, 0x0004, 0x000F, 0xFFF6, 0xFFF7, 0x000E, 0xFFF8, 0xFFF0,
    0xFFFD, 0x000A, 0xFFF9, 0xFFF0, 0x000D, 0xFFFC, 0x0010, 0x0004,
    0x0017, 0xFFFC, 0x0007, 0x0011, 0xFFF2, 0x001A, 0xFFEE, 0xFFEF,
    0xFFFF, 0xFFF7, 0xFFF9, 0xFFE9, 0xFFDC, 0xFFFE, 0xFFF0, 0xFFF8,
    0xFFF0, 0x0006, 0xFFD7, 0x0013, 0x000B, 0x0012, 0xFFF9, 0x000F,
    0x0003, 0x0015, 0xFFFE, 0xFFDF, 0xFFFD, 0xFFF3, 0xFFE9, 0xFFDB,
    0x0014, 0xFFE2, 0xFFFD, 0xFFEF, 0x0023, 0x0008, 0xFFFB, 0xFFEA,
    0x001A, 0x001B, 0x001E, 0x000D, 0x0026, 0xFFF0, 0x0011, 0xFFE7,
    0xFFED, 0xFFF8, 0xFFEC, 0x0015, 0x002A, 0xFFED, 0xFFFE, 0xFFF9,
    0xFFEE, 0xFFEF, 0xFFFC, 0xFFF4, 0xFFF1, 0x0006, 0xFFF4, 0x001F,
    0xFFE2, 0x000A, 0x0013, 0xFFE3, 0xFFEA, 0xFFE4, 0xFFE7, 0x001B,
    0x000C, 0x0029, 0xFFEB, 0xFFCB, 0x000C, 0xFFDF, 0x0002, 0xFFEE,
    0xFFED, 0xFFF7, 0xFFF2, 0x0015, 0xFFFB, 0x0009, 0x0001, 0xFFF0,
    0x0005, 0xFFDE, 0xFFDC, 0x0006, 0xFFFA, 0x001E, 0x0025, 0x0008,
    0x0019, 0xFFF4, 0x0008, 0xFFEE, 0x0019, 0x000F, 0x001C, 0xFFE5,
    0xFFFB, 0x0011, 0x0008, 0x001D, 0x0005, 0x0003, 0x000D, 0x0001,
    0x0010, 0xFFF6, 0xFFFE, 0x0006, 0x0024, 0xFFE4, 0xFFF7, 0x0007,
    0x0011, 0xFFF0, 0xFFEB, 0xFFE2, 0xFFF7, 0x0008, 0x0019, 0x0005,
    0x0018, 0xFFF8, 0x0000, 0x0004, 0xFFF8, 0x0005, 0x000B, 0x000F,
    0xFFE8, 0xFFDA, 0xFFF4, 0x001A, 0xFFF2, 0xFFF0, 0xFFEE, 0x0009,
    0x0008, 0x0006, 0x0018, 0x000C, 0x0026, 0x000E, 0x0017, 0x0015,
    0xFFE5, 0x0005, 0xFFFF, 0xFFF8, 0x001A, 0x000C, 0xFFED, 0x0001,
    0x0004, 0x0000, 0x0007, 0xFFF4, 0xFFED, 0x0002, 0x0007, 0x0023,
    0x0005, 0xFFF4, 0xFFF3, 0xFFEE, 0xFFFE, 0x0005, 0x0001, 0xFFF3,
    0xFFFF, 0xFFF3, 0x0025, 0x000B, 0xFFF8, 0x0001, 0xFFFC, 0x0010,
    0xFFEE, 0xFFFE, 0xFFCF, 0xFFE0, 0x0008, 0x0012, 0xFFEE, 0x0004,
    0x0005, 0xFFFE, 0x001E, 0x0020, 0x0000, 0x0014, 0xFFE2, 0xFFFC,
    0xFFFE, 0xFFFB, 0xFFFA, 0x0006, 0xFFF5, 0xFFFF, 0xFFE2, 0x0004,
    0x0006, 0x0014, 0xFFF3, 0x0011, 0xFFFA, 0xFFF3, 0x0011, 0xFFEB,
    0x0005, 0x0012, 0x0001, 0xFFF1, 0xFFE5, 0x000B, 0x0000, 0x0008,
    0x0015, 0x0007, 0xFFE5, 0x000B, 0xFFFF, 0xFFF6, 0x0003, 0xFFDB,
    0x0010, 0x0015, 0xFFF4, 0xFFF8, 0xFFF2, 0x000B, 0xFFEB, 0xFFDE,
    0xFFF9, 0x0016, 0xFFF9, 0x0006, 0xFFF6, 0xFFFD, 0xFFDE, 0x000A,
    0x001A, 0x0013, 0x0012, 0xFFEF, 0x0027, 0xFFFB, 0xFFF7, 0x0016,
    0x0015, 0xFFE9, 0xFFE3, 0xFFF9, 0xFFFC, 0x0018, 0xFFF4, 0x000E,
    0x0003, 0x000F, 0xFFEE, 0xFFEF, 0xFFEF, 0x0016, 0x0001, 0x0008,
    0x0000, 0x0002, 0x0022, 0x000C, 0x0008, 0xFFEC, 0xFFED, 0x0005,
    0xFFE5, 0xFFF8, 0xFFF5, 0xFFE5, 0x002C, 0x000A, 0x001E, 0xFFF6,
    0x0012, 0xFFE9, 0x0005, 0x000B, 0xFFD9, 0x0008, 0xFFF0, 0xFFFC,
    0x0008, 0x0013, 0x0000, 0x000D, 0xFFDA, 0x0005, 0x000A, 0xFFFC,
    0x0018, 0x000F, 0x0010, 0x001B, 0xFFF7, 0x0016, 0x0023, 0xFFEA,
    0xFFC9, 0x0004, 0xFFEF, 0x002D, 0xFFF3, 0x0003, 0x0001, 0x0018,
    0xFFFA, 0x0013, 0x0011, 0x0006, 0x002C, 0xFFFE, 0xFFF8, 0xFFF4,
    0xFFFC, 0x0008, 0x0021, 0xFFFA, 0xFFF0, 0xFFFE, 0x0010, 0xFFE8,
    0xFFE5, 0x0012, 0x0002, 0x000C, 0xFFDD, 0x000E, 0x0001, 0x0013,
    0xFFED, 0x0010, 0xFFFA, 0x0019, 0xFFF9, 0x001B, 0xFFEE, 0xFFD7,
    0xFFEF, 0xFFE2, 0x0018, 0x001F, 0xFFF8, 0xFFF7, 0xFFF6, 0xFFFE,
    0xFFFA, 0x0000, 0xFFEC, 0x0010, 0x000A, 0x0025, 0xFFE8, 0x000B,
    0x0004, 0xFFE1, 0x0008, 0x0001, 0xFFEF, 0x0000, 0x0019, 0xFFF2,
    0x0031, 0x0006, 0xFFFC, 0x0014, 0x0006, 0x0014, 0x0005, 0xFFFB,
    0x0016, 0x0004, 0x0011, 0xFFF1, 0x0012, 0x000B, 0xFFFF, 0xFFF9,
    0xFFEC, 0x0007, 0x0027, 0xFFFE, 0xFFFC, 0x002B, 0xFFF5, 0xFFF4,
    0xFFF3, 0xFFF0, 0xFFF0, 0x001F, 0x0022, 0xFFE7, 0xFFF3, 0x0000,
    0xFFEE, 0x0004, 0xFFF9, 0xFFD6, 0x0012, 0xFFF7, 0x0009, 0x0002,
    0x0017, 0xFFFA, 0x0002, 0xFFF9, 0xFFF9, 0xFFEC, 0xFFFA, 0xFFD4,
    0xFFE1, 0xFFE4, 0x0007, 0x001E, 0xFFF1, 0xFFFE, 0xFFE8, 0xFFED,
    0xFFF9, 0xFFEC, 0x000F, 0xFFE2, 0x000D, 0xFFFC, 0xFFFE, 0xFFF9,
    0x0008, 0xFFE0, 0xFFE6, 0x0007, 0xFFFC, 0xFFE5, 0xFFED, 0xFFF8,
    0xFFF8, 0x000C, 0xFFDD, 0xFFFA, 0x0015, 0x0005, 0xFFD5, 0x0014,
    0xFFF6, 0x000B, 0x0007, 0xFFF9, 0xFFFF, 0xFFF2, 0xFFFC, 0x0001,
    0x0015, 0xFFE3, 0xFFFC, 0x0007, 0xFFFD, 0xFFF5, 0x0011, 0xFFEC,
    0xFFF9, 0x0006, 0xFFE1, 0xFFE8, 0x0008, 0xFFEB, 0x0019, 0xFFEB,
    0x000C, 0xFFF2, 0x000F, 0xFFFE, 0xFFF8, 0xFFF3, 0xFFF6, 0x0008,
    0xFFF2, 0x0010, 0x0016, 0x0008, 0x0011, 0x000C, 0xFFF9, 0x0009,
    0x0005, 0x0013, 0x0004, 0x0014, 0x0015, 0x0005, 0x0004, 0xFFF6,
    0xFFF2, 0x0008, 0x0000, 0xFFFC, 0xFFEC, 0xFFF8, 0xFFFD, 0x0025,
    0xFFFA, 0xFFE7, 0x0004, 0x0000, 0xFFEA, 0xFFDF, 0x0017, 0xFFED,
    0x0008, 0x000F, 0xFFF3, 0xFFF4, 0xFFE9, 0x000F, 0xFFEE, 0xFFF1,
    0x000C, 0xFFE5, 0xFFF5, 0xFFF6, 0xFFF3, 0xFFE2, 0x0016, 0xFFEB,
    0xFFF7, 0xFFFD, 0x000B, 0x000F, 0xFFFC, 0x000A, 0x0001, 0xFFF6,
    0xFFE8, 0x000F, 0x0012, 0xFFFD, 0xFFF8, 0xFFFB, 0x0003, 0x0007,
    0xFFEE, 0xFFFF, 0x0002, 0x0005, 0x001B, 0x000A, 0xFFF7, 0xFFFE,
    0x000B, 0xFFF5, 0x000B, 0xFFFA, 0xFFFF, 0xFFF8, 0xFFED, 0xFFE9,
    0xFFED, 0x0007, 0xFFF9, 0x000D, 0x0021, 0xFFF7, 0xFFF0, 0xFFF6,
    0xFFF7, 0x0003, 0xFFF9, 0xFFF7, 0x0020, 0x0003, 0x000F, 0x000F,
    0x0007, 0x0010, 0xFFFC, 0xFFF7, 0x0025, 0x0000, 0xFFFE, 0xFFE7,
    0xFFF6, 0x0001, 0x000A, 0x0004, 0xFFE4, 0xFFFA, 0xFFEA, 0xFFE5,
    0xFFE7, 0xFFF3, 0x0002, 0x0005, 0x000E, 0xFFFD, 0xFFF6, 0xFFDD,
    0xFFFF, 0x0006, 0x0007, 0xFFF2, 0x0008, 0xFFFF, 0xFFDD, 0xFFE8,
    0x0003, 0xFFEC, 0x0012, 0xFFEA, 0xFFE9, 0x000D, 0x0005, 0xFFFE,
    0x0000, 0x0013, 0x000B, 0xFFFA, 0x0002, 0xFFEE, 0xFFF1, 0x0002,
    0xFFFF, 0xFFF5, 0x0004, 0x0023, 0xFFF4, 0x0026, 0xFFFB, 0xFFF7,
    0xFFD3, 0x001B, 0x0008, 0xFFDA, 0x001B, 0x0015, 0xFFE7, 0xFFF3,
    0xFFF8, 0x0010, 0xFFF9, 0xFFE7, 0xFFFE, 0xFFFF, 0xFFE8, 0xFFEE,
    0x000E, 0x0011, 0xFFFB, 0xFFDD, 0xFFFC, 0x001E, 0xFFED, 0x0001,
    0xFFF3, 0xFFF7, 0x0005, 0xFFFC, 0xFFF2, 0xFFE3, 0xFFF3, 0x001E,
    0xFFFD, 0xFFFE, 0xFFED, 0xFFFB, 0x0007, 0xFFE9, 0xFFF7, 0xFFF3,
    0x000C, 0x0025, 0xFFED, 0x0015, 0x0007, 0xFFFF, 0xFFF8, 0x0013,
    0xFFFA, 0xFFFF, 0xFFEB, 0x0003, 0xFFFF, 0xFFF9, 0xFFE8, 0xFFFF,
    0x0018, 0x0002, 0x0016, 0x0029, 0x0000, 0x000F, 0x001A, 0x0006,
    0x0001, 0xFFFD, 0x0005, 0x0019, 0xFFF0, 0xFFDA, 0xFFEF, 0x0009,
    0xFFF6, 0xFFDD, 0xFFF6, 0xFFCD, 0xFFFC, 0x0003, 0xFFEE, 0x000A,
    0xFFEC, 0x0004, 0xFFFF, 0xFFEF, 0x0005, 0x0022, 0xFFF7, 0xFFED,
    0xFFE5, 0xFFFF, 0xFFF3, 0xFFEE, 0xFFF9, 0x0011, 0xFFFC, 0x0033,
    0xFFF2, 0xFFED, 0xFFF6, 0x0000, 0xFFF5, 0xFFF4, 0x0014, 0xFFF0,
    0x001F, 0x000C, 0xFFF6, 0xFFF8, 0x000E, 0xFFEC, 0x0015, 0x0001,
    0x000A, 0x0003, 0xFFE9, 0xFFFC, 0x000B, 0xFFFB, 0x0018, 0x0018,
    0x0004, 0x0018, 0xFFD8, 0x0000, 0x0004, 0xFFF6, 0x0001, 0x0003,
    0xFFED, 0xFFEF, 0xFFFF, 0xFFE7, 0xFFEF, 0xFFEB, 0x0019, 0x0022,
    0xFFF4, 0x0013, 0xFFD3, 0x0012, 0x001D, 0x0013, 0x000B, 0xFFF9,
    0xFFFD, 0xFFFE, 0x0007, 0xFFFF, 0xFFD3, 0xFFEF, 0xFFD5, 0x001E,
    0xFFF8, 0xFFF6, 0x000A, 0xFFFF, 0xFFEF, 0xFFFE, 0x0010, 0x0027,
    0x000E, 0xFFF1, 0xFFEB, 0xFFF8, 0x000D, 0x0017, 0xFFEF, 0xFFFD,
    0x001D, 0xFFFC, 0x0008, 0xFFE5, 0x0007, 0x003A, 0xFFE2, 0x0016,
    0xFFFF, 0x000E, 0xFFF6, 0x0025, 0x000D, 0xFFF6, 0x0010, 0x0025,
    0xFFEC, 0x0008, 0x0012, 0x0019, 0x000F, 0xFFFC, 0x0004, 0xFFFC,
    0xFFE6, 0xFFFE, 0xFFEE, 0xFFFE, 0x0008, 0xFFEC, 0xFFFE, 0xFFFE,
    0xFFFD, 0xFFF4, 0x0004, 0x0004, 0xFFFB, 0xFFF6, 0x0014, 0x0002,
    0xFFF3, 0x001C, 0xFFEA, 0xFFFE, 0x0006, 0xFFF3, 0xFFF8, 0x000F,
    0xFFF6, 0x0009, 0xFFFB, 0x000C, 0xFFF0, 0xFFF9, 0x0009, 0x000D,
    0x002E, 0xFFFC, 0xFFFB, 0x0016, 0x0006, 0xFFED, 0x0000, 0xFFE8,
    0xFFFB, 0x0019, 0x0002, 0xFFE5, 0x0004, 0x0009, 0xFFFA, 0x0000,
    0xFFFF, 0x0001, 0xFFF6, 0x0008, 0xFFF1, 0x0008, 0x000B, 0xFFF4,
    0x000E, 0x0002, 0x0001, 0x0008, 0x0024, 0x0014, 0xFFF8, 0x0010,
    0x0000, 0x0000, 0x000C, 0xFFFC, 0xFFD9, 0x0009, 0xFFF2, 0x0008,
    0x0003, 0xFFF1, 0x0005, 0xFFED, 0xFFFF, 0x0005, 0xFFDB, 0xFFF1,
    0x001C, 0x0019, 0xFFE6, 0xFFEE, 0x000F, 0x0012, 0x0016, 0xFFE4,
    0x0003, 0xFFDD, 0x0012, 0xFFF0, 0x000D, 0xFFFA, 0xFFDB, 0x0013,
    0x0018, 0x000C, 0x0029, 0xFFE1, 0xFFFD, 0xFFFB, 0xFFEF, 0x0023,
    0xFFFE, 0xFFEB, 0x000A, 0xFFF1, 0x0013, 0x0015, 0xFFD6, 0x000D,
    0xFFFE, 0xFFF8, 0x0023, 0x0006, 0x000F, 0xFFFA, 0x0002, 0x0018,
    0x0015, 0x0006, 0xFFEA, 0xFFF1, 0xFFEA, 0x0012, 0xFFF6, 0x0007,
    0x0005, 0x001B, 0x0006, 0xFFFE, 0xFFE2, 0x0014, 0xFFF6, 0xFFE3,
    0x0005, 0x000B, 0xFFF1, 0xFFFD, 0x0004, 0xFFF9, 0x0006, 0xFFE1,
    0x0010, 0x0014, 0xFFE7, 0xFFED, 0x001B, 0xFFFE, 0x0007, 0xFFFB,
    0xFFFD, 0xFFED, 0x0008, 0xFFFF, 0xFFEE, 0x0001, 0xFFE6, 0xFFE5,
    0x0007, 0xFFED, 0xFFE5, 0x000A, 0x0007, 0xFFE7, 0xFFFA, 0xFFEB,
    0x0013, 0x0016, 0xFFF3, 0xFFEC, 0xFFED, 0xFFF6, 0xFFF6, 0xFFE5,
    0xFFEE, 0x000E, 0xFFDF, 0x000D, 0xFFFF, 0x000B, 0xFFFF, 0x0023,
    0x0013, 0xFFF9, 0xFFFD, 0x0015, 0x000A, 0x0011, 0xFFEE, 0xFFEA,
    0x000E, 0x0011, 0xFFF0, 0x000D, 0xFFF8, 0xFFF0, 0xFFFB, 0x0001,
    0x0009, 0x0006, 0xFFEA, 0xFFFC, 0x0010, 0xFFDC, 0x0012, 0x0002,
    0xFFF0, 0x0006, 0x0008, 0x0006, 0x000F, 0x001B, 0x000A, 0xFFED,
    0x0021, 0x000F, 0xFFF2, 0x0011, 0xFFF3, 0x001B, 0x0005, 0x000E,
    0xFFE5, 0x0016, 0x0016, 0xFFEE, 0x0006, 0xFFFB, 0x001D, 0x0003,
    0x0004, 0xFFF6, 0x002D, 0x000A, 0x0007, 0xFFEE, 0x0015, 0xFFEA,
    0x0003, 0xFFF6, 0xFFE6, 0xFFFB, 0x0009, 0x000F, 0xFFE9, 0x0005,
    0xFFD9, 0xFFF7, 0x0000, 0x0012, 0xFFF9, 0x0006, 0x000F, 0x0017,
    0x0000, 0x0016, 0x0002, 0xFFDD, 0xFFEC, 0xFFF7, 0x0002, 0xFFEF,
    0x000B, 0x000E, 0x0010, 0x0021, 0x0007, 0xFFFB, 0xFFFA, 0x0009,
    0xFFE9, 0xFFFC, 0x0014, 0xFFE9, 0xFFED, 0x0006, 0x000F, 0x0013,
    0x001C, 0xFFF2, 0x000D, 0xFFD3, 0xFFFC, 0xFFEF, 0x0021, 0xFFDC,
    0x000B, 0xFFF0, 0x001F, 0x0018, 0x0007, 0xFFE7, 0xFFEB, 0xFFF7,
    0xFFFD, 0x0012, 0xFFFF, 0xFFF0, 0xFFDB, 0x000E, 0xFFF0, 0xFFF6,
    0xFFF8, 0x0009, 0x000D, 0xFFF9, 0xFFEB, 0x0001, 0x0005, 0xFFF0,
    0xFFFF, 0xFFEE, 0x0008, 0x0015, 0xFFF4, 0xFFFC, 0xFFE2, 0x0003,
    0xFFE9, 0x0000, 0xFFF5, 0xFFEE, 0x0009, 0x0008, 0x0009, 0xFFF3,
    0xFFF4, 0x002A, 0xFFF7, 0xFFF6, 0xFFE6, 0xFFF4, 0x0003, 0x001E,
    0xFFFA, 0x0001, 0x0003, 0x000D, 0x0018, 0x0008, 0x0000, 0xFFE9,
    0x0004, 0x000E, 0xFFF2, 0x0024, 0xFFE1, 0xFFE2, 0xFFF3, 0x0006,
    0xFFFE, 0xFFFF, 0xFFFD, 0xFFE7, 0xFFFA, 0xFFFD, 0xFFFB, 0x000C,
    0xFFF6, 0x0006, 0xFFEB, 0xFFFB, 0xFFF9, 0xFFEF, 0xFFED, 0x000B,
    0x0000, 0x0003, 0x0001, 0x0013, 0xFFF7, 0xFFF3, 0xFFFB, 0xFFF5,
    0x0003, 0xFFDD, 0xFFEE, 0xFFFE, 0xFFEB, 0x001D, 0x0001, 0x0006,
    0x0000, 0x0008, 0xFFEA, 0xFFE1, 0xFFFB, 0x000E, 0x002A, 0xFFFB,
    0xFFF8, 0xFFFD, 0xFFDD, 0xFFF4, 0xFFF9, 0xFFE7, 0xFFEB, 0x0006,
    0xFFFA, 0x0019, 0x0008, 0x0004, 0x0011, 0x0008, 0xFFE6, 0x0014,
    0xFFF5, 0xFFE2, 0xFFF8, 0x0016, 0xFFE7, 0x0010, 0xFFF7, 0xFFF4,
    0xFFEC, 0xFFEC, 0x0001, 0x0005, 0xFFFE, 0x0009, 0x0013, 0x0003,
    0x0005, 0xFFEA, 0x000E, 0xFFF8, 0x000C, 0xFFEC, 0xFFE6, 0xFFFA,
    0x0003, 0xFFDB, 0x000D, 0x0010, 0x0014, 0xFFF2, 0x0016, 0x0003,
    0x0006, 0xFFF6, 0x001E, 0x0006, 0xFFFF, 0xFFDD, 0x0006, 0xFFF4,
    0x0008, 0xFFE0, 0x000C, 0xFFE6, 0x0001, 0x0007, 0xFFFC, 0x001D,
    0x0007, 0x000F, 0xFFF2, 0x0005, 0xFFFB, 0xFFDF, 0x0012, 0x000D,
    0xFFF4, 0x000B, 0x0022, 0x0005, 0xFFF8, 0x000C, 0x0005, 0x0018,
    0x000F, 0x0010, 0xFFEA, 0xFFFE, 0xFFFF, 0x0009, 0xFFF5, 0x000D,
    0xFFEF, 0x0005, 0x002C, 0xFFF4, 0xFFFD, 0xFFF4, 0x0015, 0xFFF8,
    0x0005, 0x0007, 0xFFE8, 0xFFFD, 0xFFF3, 0x0000, 0x0002, 0x0002,
    0x0002, 0x0011, 0x000F, 0x0000, 0x001F, 0x0000, 0xFFE9, 0xFFF1,
    0xFFF9, 0x0021, 0x0006, 0x001C, 0xFFE4, 0xFFFF, 0xFFEF, 0x002C,
    0x0000, 0xFFFB, 0xFFF0, 0xFFF6, 0x0015, 0x000D, 0xFFFD, 0x0007,
    0x0001, 0x000E, 0x000A, 0xFFFF, 0xFFFE, 0xFFF9, 0x0002, 0xFFE2,
    0x0011, 0xFFE8, 0x000C, 0xFFF6, 0xFFFE, 0x0005, 0xFFEC, 0x000B,
    0xFFFE, 0xFFF6, 0xFFEF, 0xFFEF, 0x0001, 0xFFF3, 0x0008, 0xFFFE,
    0xFFF9, 0x000B, 0xFFFC, 0x000A, 0xFFFD, 0x0015, 0xFFF8, 0xFFE2,
    0x0031, 0xFFFA, 0x0002, 0x0000, 0xFFFC, 0x0009, 0x0017, 0x0009,
    0xFFF5, 0xFFDE, 0xFFED, 0xFFF3, 0xFFF5, 0xFFF3, 0xFFF8, 0x0003,
    0x000E, 0xFFFE, 0x0002, 0xFFEB, 0xFFF4, 0xFFF8, 0x000A, 0x0010,
    0x0020, 0xFFEE, 0x001E, 0xFFF8, 0xFFF5, 0x0008, 0x0009, 0x001C,
    0x0000, 0xFFF0, 0xFFE7, 0xFFF7, 0xFFE2, 0xFFEA, 0xFFFA, 0x000C,
    0x0003, 0xFFFF, 0xFFE0, 0x000F, 0xFFF7, 0x0009, 0x0006, 0xFFF1,
    0x0019, 0x0000, 0x0020, 0xFFF0, 0x0008, 0x0004, 0xFFFB, 0xFFE8,
    0x0010, 0xFFEF, 0xFFF7, 0x0000, 0x0001, 0xFFFD, 0xFFF0, 0x000B,
    0x001C, 0xFFEB, 0x0025, 0xFFEC, 0x000E, 0x0013, 0xFFFF, 0xFFF8,
    0xFFFC, 0xFFFE, 0xFFE3, 0x001A, 0xFFF4, 0x0007, 0xFFF9, 0xFFF7,
    0xFFEF, 0x0011, 0xFFF7, 0x000A, 0x000D, 0x000C, 0x001D, 0x0012,
    0x0011, 0xFFF2, 0x000F, 0x000E, 0x0001, 0xFFF9, 0x0012, 0xFFDF,
    0x002D, 0x0008, 0x0005, 0x0007, 0xFFEB, 0xFFE1, 0x0024, 0x000F,
    0xFFF8, 0xFFFC, 0x0015, 0xFFEF, 0xFFED, 0xFFFA, 0xFFDF, 0xFFE4,
    0x0010, 0xFFFC, 0x0017, 0xFFFD, 0x002E, 0x0000, 0xFFE0, 0x0008,
    0xFFE5, 0xFFDB, 0xFFFC, 0x0006, 0x0007, 0x000C, 0x000D, 0xFFF3,
    0xFFEC, 0xFFF8, 0xFFFF, 0x001D, 0xFFFF, 0x001C, 0xFFF0, 0xFFDE,
    0xFFFC, 0x0019, 0xFFCB, 0x001C, 0xFFFE, 0x0005, 0xFFF1, 0x003D,
    0x0015, 0xFFFB, 0x000E, 0xFFEB, 0x0025, 0x0000, 0x0021, 0x0004,
    0x0007, 0xFFEB, 0xFFFB, 0xFFEB, 0x000B, 0x0021, 0x0012, 0x0015,
    0x0020, 0x0015, 0x0009, 0xFFF0, 0x0003, 0xFFFF, 0x0009, 0xFFFF,
    0x0000, 0x000F, 0x001C, 0x0010, 0xFFFE, 0xFFF0, 0x0021, 0xFFFC,
    0xFFED, 0x0012, 0xFFF8, 0xFFEC, 0xFFDC, 0xFFFC, 0x002E, 0x0005,
    0xFFDF, 0x001A, 0xFFE5, 0x000E, 0x0010, 0xFFDD, 0x0017, 0x0001,
    0xFFFF, 0x000C, 0x0010, 0x0005, 0xFFF6, 0x0013, 0xFFF1, 0x000A,
    0xFFFA, 0x0001, 0x0001, 0xFFFD, 0x0002, 0x000B, 0xFFFB, 0x0001,
    0x0026, 0xFFEB, 0x000A, 0xFFF5, 0x0003, 0xFFF9, 0xFFFB, 0x0006,
    0xFFE6, 0xFFE5, 0xFFFC, 0x000E, 0xFFED, 0xFFFF, 0xFFFA, 0x0009,
    0x001F, 0x0007, 0xFFED, 0x0008, 0x000B, 0x0010, 0x0008, 0x0008,
    0xFFEB, 0x001B, 0x0037, 0x0000, 0x0016, 0x0014, 0xFFF8, 0x0000,
    0xFFFC, 0x0009, 0x0005, 0xFFF8, 0xFFFB, 0xFFFE, 0xFFFD, 0xFFF4,
    0xFFFC, 0xFFF2, 0xFFF2, 0x000F, 0x0008, 0xFFE0, 0x0006, 0xFFEF,
    0x000C, 0xFFEF, 0xFFFA, 0xFFF8, 0xFFF6, 0x0009, 0x000F, 0x000A,
    0xFFEF, 0xFFF8, 0xFFCF, 0xFFF6, 0x0001, 0xFFF4, 0xFFE9, 0x0009,
    0xFFF4, 0x0009, 0x000C, 0x0013, 0x0007, 0x0000, 0x001A, 0xFFE7,
    0x0006, 0x000B, 0x0011, 0x0010, 0x000C, 0x0006, 0x0007, 0x0010,
    0xFFF7, 0x000A, 0xFFF7, 0x000B, 0xFFFE, 0xFFDA, 0xFFDC, 0xFFF3,
    0xFFEC, 0x0016, 0x0005, 0x0015, 0xFFF5, 0xFFEF, 0xFFF1, 0x000E,
    0xFFF8, 0xFFF4, 0xFFF9, 0xFFF0, 0xFFF1, 0x0004, 0xFFE9, 0x0003,
    0x0002, 0xFFE8, 0x000E, 0x0004, 0xFFF6, 0x0020, 0x000A, 0x0013,
    0xFFFD, 0xFFF4, 0xFFF7, 0xFFEC, 0x0007, 0xFFFE, 0xFFEB, 0x0006,
    0xFFFD, 0xFFF4, 0xFFEE, 0x000B, 0x0005, 0xFFF1, 0xFFF7, 0xFFF7,
    0x000D, 0xFFEC, 0xFFEA, 0xFFFF, 0xFFFF, 0x000D, 0x0003, 0x000B,
    0xFFDD, 0x001E, 0x0019, 0xFFF0, 0xFFF3, 0xFFFA, 0xFFFD, 0xFFE3,
    0x0000, 0xFFEA, 0xFFEA, 0xFFDC, 0xFFDF, 0x0009, 0xFFED, 0x000C,
    0xFFF5, 0xFFFC, 0x000B, 0x0003, 0xFFF2, 0x001E, 0xFFFB, 0xFFF1,
    0x0012, 0xFFFF, 0xFFF1, 0xFFF0, 0xFFFF, 0xFFE6, 0xFFF3, 0x0015,
    0x0001, 0x0007, 0x0002, 0xFFF4, 0x000B, 0x0021, 0x0016, 0xFFF2,
    0xFFF1, 0xFFEE, 0xFFE3, 0xFFF3, 0xFFEA, 0x0002, 0xFFEC, 0x0001,
    0xFFFE, 0x0009, 0x0004, 0xFFFE, 0xFFE1, 0xFFCE, 0xFFE2, 0x000B,
    0x0005, 0x001F, 0x0000, 0x0005, 0x0022, 0x0000, 0x0018, 0xFFFF,
    0x0012, 0x0018, 0xFFDE, 0xFFFE, 0x000A, 0x0001, 0xFFFA, 0x000A,
    0xFFE8, 0x0017, 0x0026, 0x0015, 0xFFF0, 0xFFF0, 0x0002, 0xFFFC,
    0x0020, 0xFFC8, 0x0008, 0xFFF3, 0x0014, 0x0012, 0xFFFE, 0x0005,
    0x0025, 0x0008, 0xFFD8, 0xFFF8, 0x000A, 0xFFEE, 0x0010, 0x0011,
    0xFFF8, 0x001B, 0x0004, 0xFFFD, 0x0014, 0x0015, 0x000B, 0xFFEF,
    0x0001, 0xFFE9, 0x001A, 0x0001, 0xFFF3, 0x0004, 0x0002, 0x0012,
    0xFFFA, 0x0017, 0xFFF1, 0x0016, 0x000C, 0xFFE5, 0xFFE9, 0x000A,
    0x0006, 0x0006, 0x0007, 0xFFFE, 0xFFF7, 0xFFFC, 0xFFFD, 0xFFFF,
    0xFFE2, 0xFFEB, 0xFFF1, 0x001E, 0xFFEE, 0x0007, 0xFFEB, 0x0009,
    0x0001, 0x0005, 0xFFE8, 0xFFF9, 0xFFF0, 0x0016, 0xFFF0, 0xFFDF,
    0xFFFC, 0x001E, 0xFFEA, 0x0018, 0x0006, 0xFFF1, 0x0006, 0xFFF1,
    0x0006, 0x0005, 0x0009, 0xFFF3, 0x0001, 0xFFF7, 0x001A, 0xFFF1,
    0xFFE2, 0x000F, 0x0008, 0xFFFD, 0x003E, 0xFFFE, 0xFFF1, 0xFFEC,
    0x0006, 0xFFE0, 0x000F, 0xFFF5, 0x0000, 0x0011, 0xFFF2, 0x000A,
    0x0007, 0x0022, 0xFFEE, 0xFFE9, 0x0014, 0xFFDD, 0xFFE8, 0x0015,
    0xFFF2, 0xFFF1, 0x0009, 0xFFFF, 0xFFF7, 0x000D, 0x000E, 0x0009,
    0x000B, 0x0015, 0x0005, 0xFFFD, 0xFFFC, 0xFFEB, 0xFFF1, 0xFFFA,
    0x0003, 0xFFF0, 0x000B, 0x0000, 0xFFFC, 0xFFFE, 0xFFF8, 0xFFD6,
    0xFFFA, 0x000A, 0x0003, 0xFFED, 0x000A, 0x000B, 0x0008, 0x0004,
    0xFFF0, 0x0010, 0x0003, 0x0005, 0x000D, 0xFFF0, 0x0012, 0xFFCA,
    0x0006, 0xFFF3, 0x000E, 0x0019, 0xFFF9, 0x0013, 0xFFFF, 0x0013,
    0x000D, 0x0000, 0xFFF5, 0x0012, 0x000F, 0x0008, 0xFFEB, 0xFFF3,
    0xFFE1, 0xFFFE, 0xFFE3, 0x0011, 0x001D, 0x000C, 0xFFE8, 0x0004,
    0x0002, 0x000B, 0xFFF6, 0x0004, 0x002E, 0x0006, 0xFFFC, 0x0008,
    0x001E, 0xFFFD, 0xFFE3, 0x0012, 0xFFEF, 0xFFF5, 0xFFF2, 0x001B,
    0x0007, 0x0018, 0x0020, 0xFFFB, 0x0002, 0xFFE2, 0xFFE5, 0xFFF3,
    0xFFFF, 0x0006, 0x0008, 0x0010, 0xFFF7, 0x0006, 0x0013, 0xFFF0,
    0xFFF9, 0x0024, 0xFFFA, 0x0009, 0x0004, 0x0006, 0x000E, 0x0005,
    0xFFEE, 0xFFFB, 0x0020, 0x0003, 0x0007, 0x000C, 0xFFE8, 0x0008,
    0xFFFB, 0xFFFD, 0x0016, 0x0005, 0x0000, 0x0005, 0x000B, 0xFFEA,
    0x0000, 0xFFF0, 0x0023, 0xFFE8, 0x001B, 0x0003, 0xFFF2, 0x0032,
    0xFFDD, 0x0007, 0x001B, 0x000C, 0x0010, 0xFFE5, 0xFFFC, 0xFFF6,
    0x0010, 0xFFF0, 0xFFFD, 0x000C, 0x0005, 0x000B, 0xFFFC, 0xFFFA,
    0xFFF0, 0xFFE3, 0xFFE0, 0xFFE5, 0xFFE5, 0x0018, 0x0005, 0x0017,
    0x0011, 0x000B, 0xFFF3, 0x0005, 0xFFED, 0x000B, 0x0010, 0xFFE8,
    0xFFFD, 0x0008, 0x0010, 0xFFF7, 0xFFE9, 0x0002, 0xFFF7, 0x0001,
    0x0013, 0x0004, 0xFFF2, 0x0011, 0x0012, 0x0007, 0xFFF7, 0xFFFC,
    0x0024, 0x000C, 0xFFFF, 0xFFFA, 0xFFF5, 0xFFFF, 0x0003, 0xFFDB,
    0x0025, 0xFFF0, 0x0016, 0xFFF4, 0x0008, 0xFFFF, 0xFFEA, 0xFFEE,
    0x000C, 0x000F, 0x0001, 0xFFF3, 0x0008, 0x0025, 0x000D, 0xFFF7,
    0x0010, 0xFFF3, 0xFFF8, 0x0002, 0xFFFB, 0x000C, 0xFFF0, 0xFFFE,
    0x000D, 0xFFEE, 0x0018, 0x0003, 0xFFF3, 0x0011, 0x0007, 0xFFF1,
    0x0004, 0x000D, 0xFFFE, 0x000A, 0x003C, 0x001B, 0x000D, 0xFFE8,
    0x0019, 0xFFF4, 0xFFFB, 0xFFE8, 0x001E, 0x0010, 0xFFEC, 0xFFF6,
    0x002F, 0xFFF7, 0xFFFD, 0x0019, 0xFFE4, 0x0001, 0x0003, 0x0007,
    0x0009, 0xFFE9, 0xFFEE, 0xFFE5, 0xFFE8, 0x0019, 0x0000, 0x000D,
    0xFFF4, 0xFFF6, 0x0005, 0x000E, 0xFFFB, 0xFFF3, 0x0000, 0xFFFE,
    0xFFF8, 0x0011, 0x0012, 0x001B, 0xFFFA, 0xFFFC, 0x001C, 0xFFE1,
    0xFFF4, 0x000C, 0x0012, 0x0029, 0xFFFD, 0x000C, 0x0005, 0xFFDE,
    0xFFE8, 0xFFF1, 0x0010, 0xFFFB, 0x000A, 0xFFE6, 0x0003, 0xFFEA,
    0xFFF2, 0x001F, 0xFFF3, 0x0008, 0xFFFE, 0x000F, 0x0006, 0xFFF1,
    0xFFF0, 0xFFE5, 0x0003, 0xFFF2, 0xFFF8, 0x0003, 0x0005, 0xFFE8,
    0x0004, 0xFFFA, 0xFFF9, 0x001E, 0x0024, 0xFFFF, 0xFFFB, 0x000E,
    0x0003, 0x0021, 0xFFE9, 0x0000, 0xFFE9, 0x0006, 0xFFD6, 0xFFF6,
    0x0010, 0x0016, 0x0008, 0x000C, 0x0006, 0x000A, 0xFFE0, 0xFFD9,
    0xFFEE, 0xFFF0, 0x000F, 0x000D, 0x0008, 0xFFFE, 0xFFFB, 0x0008,
    0xFFFE, 0xFFF5, 0x0014, 0xFFE1, 0x000A, 0x000A, 0x0004, 0x0019,
    0x0008, 0xFFF3, 0x0014, 0x0001, 0x0009, 0xFFED, 0x0014, 0x0017,
    0xFFF1, 0x000B, 0xFFFF, 0xFFF7, 0x0027, 0x0018, 0xFFFB, 0x0005,
    0x0011, 0xFFFD, 0xFFF1, 0xFFFF, 0x000C, 0x0002, 0x0015, 0xFFFA,
    0xFFE3, 0x000B, 0x0017, 0xFFF8, 0x0013, 0xFFEC, 0xFFF1, 0x0001,
    0xFFF2, 0x0038, 0xFFD7, 0xFFEF, 0xFFDF, 0xFFFF, 0x000D, 0xFFFF,
    0x0000, 0xFFF1, 0xFFE3, 0xFFF9, 0xFFF7, 0xFFEA, 0xFFFB, 0x0000,
    0x0008, 0xFFFF, 0x001E, 0xFFEB, 0x0013, 0x001B, 0x002C, 0xFFF7,
    0x001B, 0xFFEC, 0x0000, 0xFFEB, 0x0000, 0x0021, 0xFFE7, 0xFFE1,
    0x0016, 0xFFF3, 0x0011, 0x0015, 0x0005, 0x0003, 0x0005, 0x0011,
    0x0016, 0xFFF5, 0xFFFA, 0x0005, 0xFFE2, 0xFFEC, 0xFFF4, 0x0018,
    0x0006, 0x0005, 0xFFFA, 0x0008, 0x0009, 0x0023, 0x0013, 0xFFE0,
    0x0000, 0xFFFA, 0x0005, 0xFFFF, 0xFFFE, 0xFFE7, 0xFFEC, 0xFFF1,
    0xFFFA, 0x000B, 0xFFF5, 0x0011, 0x0006, 0xFFF5, 0x0004, 0xFFE4,
    0xFFFF, 0x000B, 0xFFFA, 0x001A, 0xFFE4, 0x0009, 0xFFF2, 0x0001,
    0x000B, 0x000E, 0x000E, 0xFFDB, 0xFFF3, 0x0002, 0x000F, 0x0009,
    0x0008, 0xFFFA, 0x0016, 0x0009, 0x0004, 0xFFF1, 0xFFF0, 0x0008,
    0x000C, 0x000A, 0x000E, 0x000F, 0x0006, 0xFFF4, 0xFFEB, 0x001D,
    0xFFE2, 0xFFEE, 0x000D, 0x0008, 0xFFF7, 0xFFF2, 0x0007, 0x000D,
    0x000D, 0xFFF9, 0x0001, 0x0016, 0xFFF1, 0xFFF9, 0x0001, 0xFFF3,
    0xFFE8, 0xFFFA, 0x000F, 0x0013, 0xFFFE, 0x000D, 0x0005, 0x000D,
    0x0010, 0xFFEA, 0xFFE4, 0x0011, 0xFFE8, 0xFFFC, 0x001A, 0x0014,
    0xFFFF, 0xFFFA, 0x001F, 0x000F, 0xFFFC, 0x0003, 0xFFF7, 0x0002,
    0xFFF6, 0x0015, 0xFFFF, 0xFFFB, 0xFFE8, 0x000D, 0xFFF6, 0x001A,
    0x0008, 0xFFFB, 0x001F, 0xFFD5, 0xFFFC, 0xFFF2, 0xFFF9, 0xFFE8,
    0x000B, 0xFFEF, 0x0023, 0xFFEC, 0xFFFB, 0x0003, 0xFFE7, 0x0009,
    0x0009, 0x0001, 0xFFF5, 0xFFF5, 0x0008, 0x0011, 0x0006, 0xFFE8,
    0x0021, 0xFFF9, 0x002A, 0xFFF4, 0x0009, 0x0001, 0x000F, 0xFFDC,
    0x0004, 0xFFE3, 0x0014, 0x0006, 0xFFF3, 0x0006, 0xFFEB, 0xFFF4,
    0xFFF0, 0xFFEC, 0x0016, 0xFFDF, 0x0000, 0x0007, 0xFFFC, 0x0006,
    0x0014, 0xFFF2, 0x0008, 0x0013, 0x0011, 0xFFF4, 0x0001, 0xFFFB,
    0xFFF7, 0x0016, 0x0004, 0xFFE8, 0xFFF2, 0x000C, 0xFFED, 0xFFDC,
    0xFFE4, 0x0005, 0x0013, 0xFFF2, 0xFFF5, 0x0003, 0xFFFD, 0x0001,
    0xFFEF, 0x001C, 0xFFF4, 0xFFF7, 0xFFF1, 0x0028, 0x0006, 0x0010,
    0x0010, 0x000D, 0x0001, 0xFFFA, 0xFFF2, 0xFFFE, 0xFFE9, 0x0005,
    0xFFEC, 0x0004, 0x0004, 0xFFFF, 0xFFF9, 0xFFF5, 0x001D, 0xFFEF,
    0xFFFF, 0x0025, 0xFFFF, 0xFFF0, 0x0004, 0x0005, 0xFFFF, 0x0009,
    0x000E, 0x0001, 0xFFEC, 0xFFFA, 0xFFFC, 0xFFE4, 0xFFF8, 0xFFFA,
    0x0014, 0xFFEB, 0xFFED, 0x0009, 0xFFDF, 0x0012, 0x0009, 0x0010,
    0x000C, 0xFFE9, 0x0009, 0x0001, 0xFFFC, 0xFFF6, 0xFFF4, 0x001C,
    0x0002, 0x000C, 0xFFF5, 0x000F, 0x001E, 0x0010, 0xFFEE, 0x000A,
    0x0002, 0x0005, 0xFFF1, 0xFFF2, 0x0015, 0x0009, 0xFFFC, 0xFFF8,
    0x000E, 0xFFF4, 0x0000, 0x001B, 0x0006, 0xFFE2, 0x0017, 0xFFF7,
    0x0009, 0x000E, 0xFFF7, 0xFFEF, 0x0004, 0x0008, 0x0012, 0x000C,
    0xFFDC, 0x0008, 0xFFE5, 0x0020, 0x0002, 0xFFE8, 0xFFF0, 0x0006,
    0xFFF8, 0xFFE8, 0xFFFB, 0xFFFC, 0x0006, 0xFFDE, 0xFFEE, 0x0005,
    0x0005, 0xFFF3, 0xFFF2, 0x0016, 0x001A, 0xFFF8, 0x000A, 0xFFFC,
    0x0011, 0x0001, 0x0002, 0x0001, 0xFFEB, 0xFFE7, 0x000A, 0x001C,
    0x0024, 0xFFE9, 0x000B, 0x0002, 0x0012, 0xFFFA, 0xFFEC, 0xFFF8,
    0x0027, 0x0012, 0x0001, 0xFFE8, 0x0004, 0x0002, 0x001C, 0x0009,
    0x0016, 0x0008, 0xFFF5, 0xFFFD, 0x000E, 0xFFFC, 0x0009, 0xFFF4,
    0x0004, 0xFFF4, 0xFFFB, 0xFFFA, 0xFFEE, 0x0001, 0x000E, 0xFFFE,
    0x000F, 0x001A, 0x0012, 0x000E, 0x0011, 0xFFEF, 0xFFF9, 0x0005,
    0xFFFB, 0xFFF1, 0x001B, 0x0003, 0x0005, 0xFFF7, 0x0001, 0x0012,
    0x0003, 0x0003, 0xFFFA, 0xFFE8, 0x0002, 0x0022, 0x000B, 0xFFC8,
    0x0012, 0x0013, 0x0002, 0x0011, 0xFFF4, 0x001A, 0xFFF5, 0x000C,
    0x0007, 0xFFF0, 0x0015, 0x0000, 0x0021, 0xFFEC, 0x0015, 0xFFFB,
    0x000C, 0xFFF4, 0xFFE8, 0x0000, 0x0002, 0xFFFB, 0x0009, 0xFFFA,
    0x0001, 0x000B, 0x000A, 0xFFE9, 0xFFF4, 0xFFF6, 0xFFE2, 0x0015,
    0x0027, 0xFFFF, 0x000F, 0x000C, 0xFFF5, 0xFFEF, 0xFFED, 0xFFF1,
    0x0013, 0xFFF1, 0xFFE4, 0xFFF5, 0x001E, 0xFFE7, 0xFFEA, 0x0011,
    0xFFEA, 0xFFFB, 0x001D, 0x001A, 0xFFFD, 0xFFEE, 0x0008, 0x0006,
    0x000C, 0x0009, 0x0013, 0x000A, 0xFFEB, 0x001C, 0xFFEF, 0x000D,
    0x0000, 0xFFDE, 0xFFF4, 0x000C, 0x0000, 0x0006, 0xFFFF, 0x000D,
    0x001C, 0x0001, 0xFFF7, 0x000F, 0xFFEC, 0x0013, 0xFFEA, 0xFFFD,
    0x000E, 0xFFF3, 0xFFFD, 0x0002, 0x000C, 0x0028, 0x001B, 0x0002,
    0xFFE1, 0x0039, 0xFFEA, 0xFFF6, 0xFFFE, 0x0011, 0x0010, 0x0005,
    0xFFF7, 0xFFF6, 0xFFF8, 0xFFED, 0xFFF4, 0x0004, 0xFFFB, 0x002C,
    0xFFFE, 0xFFF0, 0x0006, 0xFFFD, 0xFFDD, 0x000A, 0xFFFD, 0xFFEF,
    0x0005, 0xFFF5, 0xFFEA, 0xFFDE, 0xFFED, 0x0006, 0xFFFB, 0xFFFF,
    0x001D, 0xFFF0, 0xFFFA, 0xFFF9, 0xFFEB, 0xFFF2, 0x000D, 0x0013,
    0xFFF4, 0xFFCC, 0x0003, 0xFFFF, 0x000E, 0xFFF7, 0xFFFF, 0x0035,
    0xFFEA, 0xFFF8, 0x0008, 0x0005, 0xFFFF, 0x0005, 0x002B, 0x0009,
    0x000E, 0x0009, 0xFFFC, 0x0002, 0xFFEC, 0xFFFC, 0xFFFE, 0xFFEC,
    0xFFF9, 0x0021, 0xFFF5, 0x0007, 0x0002, 0xFFF4, 0xFFFD, 0xFFFD,
    0xFFFC, 0x0014, 0xFFFD, 0x0016, 0xFFE8, 0x0000, 0xFFFF, 0xFFF8,
    0x0011, 0x0005, 0x0005, 0x001F, 0xFFDE, 0xFFD5, 0xFFDF, 0xFFFC,
    0xFFFD, 0xFFF6, 0xFFE5, 0x0005, 0xFFE3, 0x0004, 0x0001, 0x0013,
    0x0002, 0x0003, 0x000C, 0x0011, 0x0002, 0x000B, 0xFFF2, 0xFFE3,
    0x0029, 0xFFFE, 0x0033, 0xFFFC, 0xFFF4, 0xFFDE, 0xFFFF, 0xFFEB,
    0xFFCE, 0x2CC4, 0xFFF5, 0x0015, 0x0000, 0xFFF2, 0x000C, 0x000C,
    0xFFF9, 0x000B, 0x0003, 0xFFFF, 0x000A, 0x0014, 0xFFE8, 0xFFEC,
    0xFFFF, 0x0010, 0xFFF0, 0x0008, 0xFFF3, 0x0022, 0x0013, 0x0005,
    0x001A, 0x000E, 0xFFEB, 0xFFFC, 0xFFED, 0xFFF5, 0xFFFD, 0x000B,
    0xFFE8, 0xFFF3, 0x0021, 0xFFDF, 0x0004, 0x0008, 0x0011, 0xFFEC,
    0x000A, 0xFFFB, 0x0015, 0x0006, 0xFFF2, 0x000A, 0xFFF2, 0x0003,
    0x0009, 0xFFEF, 0x0008, 0x000B, 0xFFEE, 0xFFFB, 0xFFF8, 0xFFFA,
    0x0015, 0x000F, 0x0006, 0xFFFD, 0xFFEF, 0x0008, 0xFFF3, 0xFFE0,
    0xFFEC, 0xFFF9, 0x0001, 0xFFFC, 0xFFF1, 0x000D, 0x0002, 0xFFFA,
    0x0015, 0xFFF1, 0xFFF9, 0x0012, 0xFFE6, 0xFFEE, 0xFFE3, 0xFFF8,
    0x0011, 0x000A, 0x000A, 0xFFF6, 0xFFE1, 0x0014, 0xFFEC, 0x0002,
    0x0018, 0xFFE9, 0x0013, 0xFFF5, 0xFFEC, 0x000E, 0xFFEF, 0x0005,
    0x0010, 0xFFF8, 0xFFEC, 0x0009, 0xFFEB, 0x002E, 0x0001, 0xFFF4,
    0xFFF3, 0x000C, 0xFFEA, 0xFFFC, 0x001F, 0x000A, 0x0012, 0x0024,
    0x0022, 0xFFE6, 0xFFF4, 0x000B, 0x0024, 0xFFFA, 0x0008, 0x001C,
    0x0017, 0x0018, 0xFFFD, 0x0001, 0xFFE8, 0x0030, 0x0003, 0xFFDF,
    0x000C, 0xFFFD, 0x0012, 0xFFED, 0x001F, 0xFFF6, 0x0001, 0x0000,
    0x0012, 0xFFFA, 0xFFF4, 0x0002, 0x0027, 0x0008, 0xFFEA, 0xFFEE,
    0x001D, 0x0006, 0x0010, 0xFFF7, 0x0002, 0xFFF7, 0x0009, 0x001B,
    0xFFE8, 0x0014, 0x002D, 0x0002, 0x0004, 0xFFF1, 0x0014, 0xFFFB,
    0x0008, 0x000F, 0x0017, 0xFFDE, 0xFFFD, 0x001F, 0xFFFF, 0xFFFE,
    0x0000, 0x0006, 0xFFFB, 0x0005, 0x002A, 0xFFE7, 0xFFDD, 0x000F,
    0x0030, 0xFFFE, 0x0026, 0x0002, 0x0003, 0x0031, 0xFFEC, 0x0022,
    0x0001, 0xFFFE, 0xFFF6, 0x0001, 0x0018, 0xFFF6, 0xFFF3, 0x000D,
    0xFFE3, 0x0015, 0x0008, 0xFFFE, 0xFFFB, 0x0003, 0x001F, 0xFFFF,
    0xFFD9, 0xFFF0, 0x0003, 0xFFFF, 0x0008, 0xFFEC, 0xFFEB, 0x0026,
    0xFFF8, 0xFFF5, 0xFFF7, 0x0010, 0xFFE5, 0xFFF1, 0x0016, 0x0003,
    0x0011, 0x003C, 0x0007, 0xFFF5, 0xFFFD, 0x0028, 0xFFFD, 0x0020,
    0x000E, 0xFFDA, 0x0016, 0xFFEA, 0x0009, 0x0001, 0x0014, 0x001F,
    0x0013, 0x001B, 0xFFFF, 0xFFEF, 0xFFF0, 0xFFF2, 0xFFFD, 0x0003,
    0x002A, 0x0019, 0x0013, 0x0006, 0x0006, 0xFFED, 0x0000, 0x0011,
    0xFFFB, 0xFFF1, 0xFFD8, 0x001F, 0xFFE5, 0x001B, 0xFFE8, 0xFFEF,
    0xFFFC, 0x0008, 0xFFF0, 0x0018, 0xFFF7, 0x0007, 0x001D, 0xFFFE,
    0xFFE6, 0xFFDE, 0xFFEF, 0xFFF5, 0xFFE5, 0xFFEB, 0x000A, 0x0009,
    0xFFC4, 0x0013, 0x0009, 0xFFEE, 0x0008, 0x000C, 0xFFF1, 0x0010,
    0xFFF8, 0x0018, 0x000C, 0xFFFA, 0x0004, 0x001E, 0xFFF6, 0x0009,
    0xFFFB, 0x0004, 0xFFF2, 0x000B, 0x0005, 0x0002, 0x0017, 0x0008,
    0xFFFB, 0x000A, 0x0023, 0xFFFB, 0xFFFC, 0x000B, 0x0000, 0x000D,
    0xFFF3, 0xFFF4, 0x000B, 0x0009, 0x0005, 0x0002, 0x0014, 0x000B,
    0xFFFE, 0xFFF7, 0xFFEB, 0xFFFE, 0x0012, 0x0019, 0x0007, 0x0005,
    0x002A, 0x0014, 0xFFFB, 0x0008, 0x000B, 0xFFEC, 0x000D, 0xFFEF,
    0xFFF5, 0x001D, 0x0015, 0x000B, 0xFFFF, 0x0009, 0xFFFD, 0xFFEB,
    0xFFFA, 0xFFE3, 0x000E, 0x0004, 0xFFC6, 0x002D, 0xFFEA, 0xFFEA,
    0xFFEC, 0xFFF5, 0xFFF9, 0xFFFF, 0xFFEA, 0xFFF7, 0xFFF2, 0x001F,
    0x000E, 0x0007, 0xFFF2, 0xFFF6, 0xFFFB, 0xFFFF, 0x001F, 0x0017,
    0x0007, 0xFFF9, 0x0001, 0x001D, 0x0008, 0xFFEC, 0xFFF4, 0x0023,
    0xFFEC, 0xFFF9, 0x0008, 0x0008, 0xFFEB, 0x0013, 0xFFF7, 0xFFF8,
    0xFFF0, 0xFFC7, 0xFFE9, 0xFFEF, 0x000B, 0xFFD3, 0x0008, 0x002D,
    0x000C, 0x0007, 0xFFF4, 0x0009, 0xFFFD, 0x0012, 0xFFE7, 0x0004,
    0xFFDA, 0x000F, 0x000F, 0x0003, 0x0011, 0xFFE6, 0x0012, 0x0018,
    0xFFE7, 0xFFF8, 0x0017, 0xFFEE, 0x0025, 0x0002, 0xFFF5, 0xFFF4,
    0xFFF6, 0x0011, 0x000E, 0x0002, 0x0009, 0x000C, 0xFFEC, 0xFFF9,
    0x0008, 0x0009, 0x0003, 0x0012, 0x0012, 0xFFF7, 0x000A, 0x0008,
    0x0005, 0x0003, 0xFFFF, 0x0003, 0xFFF8, 0xFFE4, 0xFFFE, 0x0006,
    0x000A, 0x0002, 0xFFE9, 0x000F, 0xFFFF, 0xFFF0, 0x0009, 0xFFFD,
    0xFFD7, 0x001E, 0xFFFC, 0x000C, 0x0014, 0x0017, 0xFFFC, 0xFFFC,
    0x0019, 0xFFF5, 0x0010, 0xFFFF, 0xFFF6, 0x001D, 0xFFE0, 0xFFE3,
    0x0002, 0x0018, 0xFFDF, 0x0002, 0xFFFF, 0x000E, 0xFFF4, 0xFFFA,
    0x0009, 0x0003, 0xFFFB, 0xFFE1, 0xFFEC, 0xFFEC, 0x0010, 0x000A,
    0xFFF4, 0xFFF3, 0x0003, 0x001A, 0x0001, 0xFFFA, 0x0006, 0xFFF4,
    0x0002, 0x0006, 0x000F, 0xFFEC, 0x001E, 0xFFE3, 0x000B, 0xFFF6,
    0xFFE1, 0xFFF3, 0xFFCE, 0x0003, 0x0001, 0xFFF3, 0x0008, 0xFFFC,
    0xFFF7, 0x0010, 0xFFFD, 0xFFDF, 0xFFFB, 0xFFF5, 0x000D, 0xFFE2,
    0x0003, 0x001F, 0x001A, 0x0018, 0x001F, 0xFFF8, 0x0023, 0xFFF9,
    0x0006, 0x000A, 0x001A, 0xFFFA, 0x0016, 0x0004, 0xFFF1, 0x0016,
    0x001A, 0xFFF3, 0x0003, 0xFFF7, 0xFFF5, 0x0003, 0x0009, 0x0028,
    0xFFE5, 0xFFF7, 0xFFFD, 0xFFFD, 0x0010, 0xFFED, 0xFFE8, 0x000F,
    0x0008, 0xFFF3, 0x0023, 0xFFEF, 0x0014, 0xFFF1, 0x0029, 0xFFFD,
    0x0018, 0x0009, 0x000E, 0x0015, 0xFFFE, 0x0020, 0xFFE9, 0x000A,
    0xFFED, 0xFFF0, 0x0000, 0x0005, 0xFFED, 0xFFF1, 0x0001, 0xFFF5,
    0xFFEF, 0xFFFC, 0x0007, 0xFFFF, 0x0003, 0x000D, 0xFFFD, 0xFFFC,
    0x0013, 0x0000, 0x0004, 0x0004, 0x000D, 0xFFF2, 0x0005, 0xFFF1,
    0xFFEB, 0xFFF3, 0xFFFC, 0x0011, 0xFFEB, 0x000B, 0x000A, 0xFFE6,
    0x0004, 0xFFF9, 0x0002, 0x001E, 0x0005, 0xFFFF, 0x0005, 0xFFF6,
    0x000B, 0xFFF3, 0x0011, 0xFFDE, 0x0002, 0xFFF8, 0x0000, 0x000B,
    0xFFDA, 0x0001, 0xFFEB, 0xFFF3, 0xFFFE, 0x001C, 0x0004, 0xFFEF,
    0xFFF0, 0x0000, 0xFFEF, 0xFFF3, 0xFFE8, 0xFFF0, 0xFFF6, 0xFFFC,
    0xFFE5, 0x0003, 0x000B, 0xFFFD, 0x0007, 0xFFFA, 0x000D, 0xFFEA,
    0x000C, 0xFFE6, 0x0011, 0x0023, 0x0000, 0x0015, 0x0000, 0xFFFC,
    0xFFFA, 0x0014, 0xFFE2, 0xFFEE, 0x0002, 0x0010, 0x0019, 0x0003,
    0xFFE5, 0xFFE4, 0xFFEA, 0xFFEF, 0xFFEE, 0x0009, 0x000D, 0xFFEC,
    0x0017, 0xFFEC, 0xFFF3, 0x0000, 0xFFFE, 0xFFF0, 0xFFFB, 0x0006,
    0x0013, 0xFFEF, 0x000C, 0x001B, 0xFFF6, 0xFFD3, 0xFFF8, 0x0000,
    0x001D, 0xFFEF, 0x0009, 0xFFF2, 0xFFFF, 0xFFDD, 0x0005, 0x0012,
    0xFFF1, 0xFFF5, 0xFFF6, 0xFFF9, 0xFFE6, 0x0014, 0x0003, 0x0011,
    0x000A, 0x000F, 0x0000, 0x0008, 0x0000, 0xFFE6, 0xFFE5, 0x0000,
    0x000A, 0x000B, 0x0009, 0xFFEF, 0xFFF6, 0x0006, 0xFFEC, 0x0008,
    0xFFFE, 0x0004, 0x0030, 0x0003, 0xFFF0, 0xFFF2, 0x0009, 0x001C,
    0x000F, 0xFFFC, 0xFFF5, 0xFFF0, 0xFFF5, 0x0009, 0x0018, 0x0012,
    0x0006, 0x000C, 0xFFFF, 0xFFF9, 0xFFE4, 0xFFEB, 0x0004, 0xFFFF,
    0xFFF7, 0xFFFC, 0x001F, 0x0009, 0xFFFF, 0xFFED, 0x0007, 0x000D,
    0x0005, 0x0003, 0x0000, 0x0007, 0x0007, 0xFFF4, 0x0008, 0xFFFE,
    0xFFFE, 0xFFF4, 0x0011, 0x0001, 0x000B, 0xFFFF, 0xFFF8, 0x000B,
    0x0002, 0x0015, 0x001F, 0x000B, 0xFFDE, 0x002C, 0xFFFA, 0xFFEC,
    0x0027, 0x0014, 0xFFF6, 0x0008, 0xFFF6, 0xFFEB, 0x0019, 0x0012,
    0xFFDD, 0xFFFD, 0x0005, 0x0016, 0x0001, 0x000A, 0x000B, 0x0001,
    0x0007, 0x0020, 0xFFEF, 0x0006, 0xFFFC, 0xFFF0, 0xFFF2, 0xFFDA,
    0x0001, 0xFFF8, 0xFFFE, 0xFFFC, 0xFFFC, 0xFFED, 0xFFF6, 0xFFE3,
    0xFFE1, 0x0005, 0x0005, 0x0005, 0x000F, 0x001F, 0xFFEC, 0xFFE0,
    0xFFEE, 0x0008, 0xFFEE, 0xFFE7, 0xFFF1, 0xFFFB, 0x0010, 0xFFD4,
    0xFFFC, 0xFFF0, 0x0018, 0x0001, 0x000C, 0x001B, 0xFFE2, 0xFFEE,
    0xFFEC, 0xFFFA, 0xFFF2, 0xFFFC, 0xFFE9, 0xFFC9, 0x000E, 0x002F,
    0xFFFE, 0x0009, 0xFFE6, 0xFFE7, 0x000B, 0xFFEF, 0xFFE9, 0xFFEF,
    0xFFE9, 0x0002, 0xFFFC, 0xFFFE, 0xFFEF, 0x000D, 0x000F, 0xFFF1,
    0x0001, 0x0009, 0xFFF6, 0xFFF0, 0xFFEA, 0xFFF3, 0x0002, 0x0010,
    0x0019, 0x000B, 0xFFF0, 0xFFD4, 0x0007, 0xFFE8, 0x0001, 0xFFE1,
    0x0009, 0xFFFE, 0xFFF4, 0xFFFB, 0xFFF6, 0x0015, 0x0008, 0xFFFD,
    0xFFEE, 0xFFED, 0x0019, 0xFFED, 0xFFD8, 0x0022, 0x000D, 0xFFE8,
    0x000C, 0xFFF5, 0xFFFA, 0xFFEA, 0xFFEC, 0x0004, 0x0008, 0x0007,
    0x0001, 0x0013, 0x0013, 0xFFEA, 0x0005, 0x000E, 0x000C, 0xFFFB,
    0x0004, 0x0019, 0xFFE3, 0xFFFD, 0x001E, 0x0000, 0xFFF3, 0xFFFE,
    0xFFD0, 0x000B, 0x0015, 0xFFE7, 0xFFF1, 0xFFF8, 0xFFF9, 0x0008,
    0x001B, 0x0001, 0xFFEB, 0x0002, 0x0011, 0x0012, 0xFFF5, 0x000E,
    0xFFF9, 0xFFEF, 0xFFEA, 0xFFFB, 0x000F, 0x001E, 0x0007, 0xFFFA,
    0xFFFC, 0x0009, 0xFFF7, 0xFFF7, 0xFFEA, 0x0001, 0x0024, 0xFFFE,
    0x001B, 0xFFF8, 0x0001, 0x0005, 0x0009, 0xFFF3, 0xFFF6, 0xFFFF,
    0xFFFE, 0xFFFB, 0xFFEB, 0xFFE9, 0xFFE5, 0x0003, 0xFFEA, 0xFFFE,
    0x0000, 0xFFEA, 0x0007, 0x0006, 0x0003, 0x000D, 0xFFFD, 0xFFFD,
    0xFFF0, 0xFFF4, 0x0001, 0xFFF9, 0x0017, 0x000F, 0x0002, 0xFFFE,
    0xFFFA, 0x000A, 0xFFFC, 0x0015, 0x000F, 0xFFE5, 0xFFEA, 0xFFEA,
    0x0006, 0xFFF0, 0x000A, 0x0008, 0xFFFE, 0x0003, 0x000A, 0x0015,
    0x000F, 0x0012, 0xFFFA, 0x000F, 0x0020, 0xFFF9, 0x001D, 0x0020,
    0x0011, 0xFFED, 0xFFF7, 0x0016, 0x0010, 0x0001, 0x0007, 0xFFFA,
    0x0010, 0xFFEB, 0xFFF9, 0x0016, 0x0005, 0xFFF6, 0xFFF7, 0xFFF8,
    0xFFEE, 0x0006, 0x0002, 0xFFE5, 0xFFDB, 0xFFFA, 0x0009, 0xFFFF,
    0x001B, 0x0022, 0x0015, 0xFFE6, 0xFFF9, 0x0007, 0xFFE2, 0x0003,
    0x000C, 0x0014, 0xFFFC, 0x0007, 0xFFEB, 0xFFFE, 0xFFF5, 0x000D,
    0xFFE8, 0x0015, 0x000D, 0x0007, 0xFFFC, 0x000A, 0xFFE9, 0xFFE4
    };

static const q15_t ref_cfft_noisy_4096[8192] = {
    0xFFE5, 0x0000, 0xFFE9, 0x001C, 0xFFFC, 0xFFF6, 0x000D, 0xFFF9,
    0xFFE8, 0xFFEB, 0xFFF5, 0xFFF3, 0xFFEB, 0x0002, 0xFFFC, 0xFFF9,
    0x000C, 0xFFEC, 0xFFE2, 0xFFFD, 0xFFF9, 0xFFF9, 0x0015, 0x001A,
    0x001B, 0xFFDE, 0x0009, 0x0001, 0xFFDB, 0x0006, 0x0002, 0x001B,
    0xFFEE, 0xFFFA, 0xFFF7, 0x0008, 0x0005, 0x000A, 0xFFF9, 0xFFEA,
    0x0010, 0x0015, 0x0007, 0x0006, 0x0010, 0xFFFF, 0xFFF7, 0xFFEA,
    0x0011, 0x0013, 0x001D, 0xFFE0, 0x0020, 0x0007, 0xFFFA, 0xFFF1,
    0x000F, 0xFFEE, 0x000A, 0xFFEB, 0xFFFE, 0xFFFD, 0x000A, 0xFFF8,
    0x0006, 0x0010, 0xFFEA, 0x0016, 0x000F, 0x001B, 0xFFFC, 0xFFEB,
    0xFFFA, 0xFFF6, 0x0002, 0x0002, 0x0017, 0xFFF1, 0x0001, 0x0007,
    0xFFF0, 0x000C, 0xFFFD, 0x0003, 0x0003, 0xFFF3, 0x0007, 0xFFFA,
    0x0000, 0x0016, 0xFFEA, 0x0002, 0xFFE5, 0xFFFD, 0xFFEB, 0x0017,
    0xFFFE, 0x0005, 0xFFF6, 0x0001, 0x0009, 0x000D, 0x0001, 0xFFFB,
    0x001B, 0x0008, 0x0024, 0x0002, 0xFFEA, 0xFFFF, 0xFFF7, 0x0009,
    0xFFFC, 0xFFF7, 0x0007, 0x0006, 0x000F, 0xFFE2, 0xFFEA, 0x0005,
    0xFFF9, 0x0011, 0xFFF5, 0xFFF2, 0x0011, 0xFFEE, 0xFFEB, 0xFFFE,
    0x001B, 0xFFFF, 0xFFF9, 0xFFF8, 0xFFF1, 0x0008, 0x0015, 0x0019,
    0xFFD0, 0xFFF5, 0xFFF3, 0x0002, 0x001E, 0x0000, 0xFFE3, 0x0003,
    0x0004, 0xFFE7, 0x000C, 0x0005, 0x0005, 0xFFF2, 0x0013, 0x0016,
    0x0001, 0xFFED, 0x0008, 0xFFF9, 0xFFEC, 0xFFFC, 0xFFFA, 0x0016,
    0x000C, 0x000B, 0x000D, 0x0018, 0xFFD8, 0xFFDE, 0x0019, 0x0013,
    0xFFEE, 0x0013, 0x0008, 0x0003, 0xFFF6, 0xFFEB, 0xFFF4, 0x0005,
    0x0009, 0x0002, 0x0001, 0x001F, 0x0007, 0x0018, 0xFFF0, 0x002C,
    0x0019, 0xFFF5, 0x0002, 0xFFF0, 0xFFEA, 0x000D, 0xFFF6, 0x0010,
    0x0001, 0xFFF7, 0x000F, 0x000F, 0xFFEF, 0xFFF3, 0xFFFC, 0x0002,
    0xFFE9, 0xFFFE, 0xFFE9, 0x0011, 0x000B, 0x0011, 0xFFE6, 0x0019,
    0xFFFE, 0xFFF7, 0x000E, 0xFFD1, 0xFFE9, 0x0037, 0xFFF2, 0x0004,
    0xFFEC, 0x0006, 0xFFE2, 0x0012, 0x000C, 0xFFE5, 0x0018, 0xFFFF,
    0xFFFC, 0x0010, 0x0010, 0x002C, 0xFFF1, 0x0005, 0xFFEE, 0x0019,
    0xFFEE, 0xFFF8, 0xFFEC, 0x0020, 0x000F, 0xFFE1, 0x0005, 0xFFFB,
    0xFFE1, 0xFFFB, 0xFFF6, 0x001D, 0xFFFC, 0x0013, 0xFFFE, 0x0004,
    0x0001, 0x0008, 0xFFF2, 0x0026, 0xFFFC, 0x0010, 0xFFEF, 0xFFFA,
    0x0007, 0xFFE0, 0x000B, 0xFFFF, 0x0001, 0xFFF6, 0x0005, 0xFFEA,
    0xFFDD, 0x0003, 0x0019, 0xFFEE, 0xFFF6, 0x0015, 0xFFF6, 0xFFF8,
    0x0027, 0xFFEC, 0xFFFA, 0x0014, 0xFFDE, 0xFFD4, 0x001F, 0xFFF5,
    0x0002, 0xFFEB, 0xFFF8, 0xFFF5, 0x000B, 0x0001, 0x0011, 0xFFFF,
    0xFFFE, 0x000C, 0x0008, 0x0002, 0x0007, 0x000C, 0x0000, 0xFFF9,
    0x0005, 0xFFFD, 0x0007, 0xFFF3, 0xFFFF, 0x0013, 0x001F, 0xFFF7,
    0xFFF7, 0x0004, 0x0004, 0x0001, 0xFFE4, 0x0015, 0xFFFF, 0x0007,
    0x0006, 0xFFF4, 0x0018, 0xFFEE, 0xFFF5, 0xFFF7, 0xFFF5, 0x0010,
    0x000F, 0x0004, 0x0009, 0xFFE4, 0xFFF0, 0x000E, 0x0030, 0xFFFD,
    0xFFFE, 0xFFFC, 0xFFEC, 0xFFF8, 0xFFF6, 0xFFFA, 0x0009, 0x0011,
    0x000A, 0xFFF5, 0xFFE5, 0x0000, 0x0000, 0x001A, 0x0000, 0xFFF8,
    0x000A, 0xFFF1, 0x0003, 0xFFEF, 0xFFE6, 0xFFEC, 0xFFF6, 0x0007,
    0xFFF1, 0x000B, 0x0005, 0xFFEE, 0xFFFF, 0x0023, 0x0009, 0x000E,
    0x001D, 0x0011, 0xFFF8, 0x0000, 0xFFF6, 0x002D, 0x000C, 0xFFE5,
    0x0013, 0x0011, 0xFFFB, 0xFFFA, 0xFFFE, 0x0010, 0xFFF3, 0x0000,
    0x0017, 0x0014, 0x000D, 0x0014, 0xFFEE, 0xFFF7, 0xFFEA, 0x0011,
    0xFFE5, 0x001C, 0x0019, 0xFFFD, 0x0002, 0xFFF0, 0xFFE2, 0x0012,
    0xFFFA, 0xFFEC, 0x0000, 0x0004, 0x0000, 0xFFEB, 0x0011, 0xFFDD,
    0x000C, 0x001A, 0x000D, 0x0016, 0x0007, 0x0006, 0x000B, 0x0003,
    0xFFE5, 0xFFFD, 0xFFF6, 0x0004, 0xFFE8, 0x0010, 0xFFEF, 0x000D,
    0xFFF0, 0x0000, 0x0004, 0x0011, 0xFFFE, 0xFFE4, 0xFFEB, 0x000D,
    0xFFDA, 0xFFFF, 0x0000, 0xFFF5, 0x0002, 0x0008, 0x0011, 0x0022,
    0x000B, 0x000D, 0x0005, 0x000A, 0x0005, 0x0001, 0x0002, 0xFFE2,
    0x0004, 0x0007, 0x000A, 0x001A, 0xFFEB, 0xFFF5, 0xFFFC, 0xFFEF,
    0xFFEB, 0x000D, 0x0005, 0x000F, 0x000D, 0x000E, 0x0004, 0xFFFC,
    0x0013, 0x0000, 0xFFFD, 0x0004, 0x0003, 0xFFF3, 0x0007, 0x0001,
    0xFFEF, 0x0004, 0x0001, 0x000B, 0xFFED, 0x000F, 0x0000, 0xFFFB,
    0xFFED, 0x0010, 0xFFE9, 0xFFF6, 0xFFFE, 0xFFE0, 0x000E, 0xFFEB,
    0x0018, 0xFFF7, 0x0029, 0x0003, 0x0014, 0x000F, 0x0023, 0x0011,
    0x0008, 0x000D, 0xFFE8, 0xFFF1, 0x0010, 0x0013, 0xFFFD, 0x0003,
    0xFFE5, 0x0009, 0x0009, 0xFFD8, 0xFFF5, 0xFFFD, 0x0003, 0x0009,
    0x001A, 0x000D, 0xFFF1, 0xFFEA, 0x0016, 0xFFFC, 0x001A, 0x0006,
    0x0006, 0xFFF6, 0x0023, 0x0007, 0x001F, 0x0008, 0x001A, 0xFFE8,
    0x0003, 0xFFE1, 0x000D, 0x001E, 0xFFFB, 0x000B, 0xFFFD, 0x0021,
    0xFFF7, 0xFFF0, 0x0008, 0x0004, 0x0001, 0x000D, 0xFFCE, 0xFFFD,
    0xFFE1, 0x000D, 0x000B, 0x000A, 0x001E, 0x001D, 0x000F, 0x0014,
    0x0002, 0xFFFA, 0x0006, 0x000C, 0x0001, 0x0006, 0x0003, 0xFFE6,
    0xFFF4, 0x000D, 0x0010, 0xFFF6, 0xFFEC, 0x0014, 0xFFFB, 0x001F,
    0x0009, 0xFFFD, 0xFFF4, 0x0006, 0xFFFF, 0xFFF2, 0xFFDF, 0xFFFE,
    0x0002, 0xFFE8, 0xFFE0, 0x001D, 0xFFF6, 0xFFE3, 0x0010, 0x0001,
    0x0019, 0x000B, 0xFFFC, 0x0004, 0x0014, 0xFFE9, 0xFFFC, 0xFFF4,
    0xFFD7, 0xFFE2, 0x0009, 0x0003, 0xFFFF, 0x0010, 0xFFE9, 0xFFF1,
    0x000A, 0xFFFE, 0xFFFE, 0xFFFA, 0xFFF8, 0x001C, 0xFFFF, 0xFFFD,
    0x0005, 0xFFFD, 0x000A, 0xFFF8, 0x0012, 0x0009, 0x0003, 0xFFEE,
    0x0008, 0xFFF7, 0xFFEC, 0x0007, 0x0009, 0xFFF4, 0x000E, 0xFFFE,
    0xFFF6, 0xFFEF, 0xFFF5, 0x000C, 0x0025, 0xFFFE, 0x0017, 0x0012,
    0xFFE7, 0x0008, 0x0012, 0xFFE8, 0x0011, 0x001A, 0x000F, 0xFFFD,
    0xFFDA, 0xFFF1, 0xFFE7, 0xFFFC, 0xFFFD, 0xFFEE, 0xFFF4, 0xFFF7,
    0x000C, 0xFFF9, 0x0008, 0xFFD3, 0x000B, 0x002D, 0xFFE9, 0x0011,
    0xFFF0, 0x0039, 0xFFF7, 0x0008, 0xFFEB, 0xFFED, 0x0008, 0xFFF8,
    0xFFEC, 0x0007, 0xFFF4, 0xFFDD, 0x0008, 0x0014, 0x0001, 0xFFE3,
    0x0007, 0x0007, 0x001F, 0xFFE9, 0xFFFB, 0x0001, 0xFFF2, 0x000A,
    0x000E, 0xFFF9, 0xFFF2, 0xFFE1, 0xFFEA, 0x0009, 0xFFF9, 0x0001,
    0xFFEC, 0x000B, 0xFFEA, 0x0016, 0xFFC6, 0xFFD3, 0x000E, 0xFFFC,
    0xFFFA, 0x001D, 0xFFFD, 0x0015, 0xFFFF, 0xFFF7, 0x0015, 0xFFF5,
    0xFFF5, 0xFFE3, 0x000D, 0x0011, 0x000B, 0x0014, 0xFFFB, 0xFFF8,
    0x002A, 0xFFEC, 0x0007, 0xFFFB, 0x0012, 0xFFE7, 0xFFEB, 0x0002,
    0xFFFE, 0x0009, 0x0014, 0xFFF5, 0x0005, 0xFFFE, 0x000B, 0xFFF7,
    0xFFF3, 0x000C, 0x0000, 0xFFF3, 0xFFFC, 0xFFF5, 0x0023, 0x0005,
    0xFFFB, 0xFFF6, 0x0017, 0xFFF8, 0x0005, 0xFFFE, 0xFFF2, 0xFFF5,
    0xFFFB, 0xFFFC, 0xFFF6, 0xFFF7, 0x0004, 0xFFE2, 0x000C, 0x0006,
    0xFFF8, 0xFFE8, 0xFFF1, 0xFFF0, 0x0008, 0xFFF4, 0x0009, 0x0012,
    0xFFC4, 0xFFED, 0x000A, 0xFFF7, 0xFFE5, 0x0015, 0xFFEF, 0x000B,
    0xFFE6, 0x0022, 0x001D, 0x0002, 0xFFF7, 0xFFF9, 0xFFF0, 0xFFE8,
    0xFFFC, 0xFFF8, 0xFFE8, 0x0011, 0xFFE5, 0xFFE5, 0xFFD8, 0xFFE1,
    0xFFFB, 0x000F, 0x0000, 0xFFEF, 0x0006, 0x0013, 0x0013, 0xFFFA,
    0x002A, 0xFFE7, 0xFFFD, 0xFFFD, 0xFFF0, 0x000E, 0xFFFF, 0x0011,
    0x0013, 0xFFE5, 0x0014, 0xFFE1, 0x0009, 0xFFFF, 0x0016, 0x0016,
    0x000E, 0x0026, 0xFFFD, 0xFFE0, 0xFFFD, 0xFFD8, 0x0007, 0x000B,
    0x0011, 0xFFC4, 0x0016, 0xFFFD, 0xFFE5, 0x000F, 0xFFF7, 0xFFF0,
    0xFFF8, 0x000B, 0xFFEB, 0xFFDA, 0x0008, 0x0014, 0x0003, 0x0001,
    0xFFD9, 0x0010, 0x001F, 0x0001, 0xFFFB, 0xFFFD, 0x0008, 0x0002,
    0xFFE3, 0xFFEB, 0xFFF3, 0xFFF3, 0x0018, 0x000A, 0xFFF6, 0xFFFF,
    0x0001, 0x0002, 0xFFEC, 0xFFDE, 0x0003, 0xFFCF, 0x0026, 0xFFFE,
    0x0030, 0x0002, 0xFFDD, 0xFFF1, 0x002A, 0x0019, 0xFFFB, 0xFFFB,
    0x0000, 0xFFFA, 0xFFFF, 0x0002, 0xFFFD, 0xFFE1, 0x0017, 0x0022,
    0x0008, 0xFFF1, 0x0014, 0x0005, 0x0004, 0x000F, 0x002D, 0xFFFE,
    0xFFE8, 0xFFEC, 0x0009, 0xFFE5, 0x0002, 0x0009, 0x0010, 0x0009,
    0x001D, 0xFFFA, 0xFFEA, 0x0012, 0x0027, 0xFFF8, 0xFFF4, 0xFFFE,
    0x0012, 0x0006, 0x0001, 0x0000, 0x001F, 0x000A, 0x0012, 0x0013,
    0x000C, 0x0003, 0x0003, 0x0021, 0xFFE8, 0xFFD0, 0xFFFD, 0xFFFF,
    0x0017, 0xFFE8, 0x0008, 0xFFE4, 0x0024, 0x0006, 0xFFF4, 0xFFF5,
    0x0022, 0x001A, 0x0012, 0xFFDC, 0x001F, 0xFFF6, 0xFFEA, 0x0004,
    0xFFF3, 0xFFF4, 0x0001, 0x000C, 0xFFEB, 0xFFD2, 0xFFEC, 0xFFF7,
    0x0010, 0x0008, 0xFFEF, 0xFFFB, 0xFFEC, 0xFFF2, 0x0013, 0x000B,
    0x0018, 0x0017, 0xFFEC, 0xFFFE, 0xFFE1, 0xFFEC, 0x000A, 0x000A,
    0x0011, 0xFFF6, 0xFFE3, 0x0008, 0xFFE6, 0x0012, 0xFFF9, 0xFFEE,
    0x0015, 0x000F, 0x0002, 0x0006, 0xFFF1, 0xFFF3, 0x0001, 0x0004,
    0xFFEC, 0x0007, 0xFFF3, 0x0020, 0xFFEF, 0xFFF8, 0x0006, 0x0003,
    0x0015, 0xFFF1, 0xFFF8, 0x0006, 0xFFEE, 0x0005, 0x0008, 0xFFF5,
    0x0009, 0x0011, 0xFFF2, 0xFFFD, 0xFFF2, 0xFFF6, 0x0015, 0xFFFA,
    0x000A, 0x0005, 0x0011, 0x0014, 0x0004, 0xFFF8, 0x0021, 0x0021,
    0xFFE8, 0x000D, 0xFFFD, 0xFFF5, 0xFFED, 0x000B, 0xFFEB, 0x0004,
    0x001A, 0xFFF2, 0x0013, 0xFFFB, 0xFFF3, 0xFFDE, 0xFFF0, 0xFFF8,
    0xFFFF, 0xFFF0, 0xFFE8, 0x0014, 0x000A, 0xFFEC, 0x0003, 0x0001,
    0xFFF9, 0xFFF5, 0x000C, 0xFFF4, 0x0000, 0x000E, 0xFFF5, 0xFFEB,
    0xFFCE, 0xD33C, 0xFFFF, 0x0015, 0xFFF4, 0x0022, 0x0033, 0x0004,
    0x0029, 0x0002, 0xFFF2, 0x001D, 0x0002, 0xFFF5, 0x000C, 0xFFEF,
    0x0002, 0xFFFD, 0x0001, 0xFFED, 0xFFE3, 0xFFFC, 0xFFE5, 0xFFFB,
    0xFFFD, 0x000A, 0xFFDF, 0x0004, 0xFFDE, 0x002B, 0x0005, 0xFFE1,
    0x0011, 0xFFFB, 0xFFFF, 0x0008, 0xFFE8, 0x0000, 0xFFFD, 0xFFEA,
    0xFFFC, 0xFFEC, 0xFFFD, 0x0003, 0x0002, 0x000C, 0xFFF5, 0xFFF9,
    0xFFF9, 0xFFDF, 0xFFFE, 0x0014, 0xFFEC, 0x0004, 0xFFFC, 0xFFFE,
    0x000E, 0xFFF7, 0x002B, 0xFFF7, 0xFFFF, 0xFFFB, 0x0008, 0xFFFB,
    0xFFEA, 0x0008, 0xFFFF, 0xFFCB, 0x000E, 0x0009, 0x0003, 0x0001,
    0xFFF4, 0x0034, 0x000D, 0xFFED, 0xFFEB, 0x000E, 0xFFFA, 0x0007,
    0x001D, 0x0010, 0xFFFB, 0x0001, 0xFFED, 0xFFFA, 0xFFEA, 0x0022,
    0x0005, 0x000B, 0xFFFD, 0x0011, 0xFFDD, 0xFFF6, 0x0006, 0x0003,
    0xFFFE, 0x0010, 0xFFFB, 0xFFD4, 0xFFF4, 0xFFFC, 0xFFF8, 0x0013,
    0xFFF7, 0x000A, 0x0010, 0xFFFB, 0xFFFE, 0xFFEF, 0xFFEA, 0x000A,
    0xFFE1, 0xFFC7, 0x001B, 0xFFFE, 0x000C, 0xFFD8, 0xFFFD, 0xFFFE,
    0x000E, 0x000D, 0xFFEA, 0x0003, 0xFFEC, 0xFFED, 0xFFF7, 0xFFF1,
    0x001C, 0xFFFF, 0xFFFF, 0xFFF3, 0x0000, 0xFFFA, 0xFFF4, 0xFFF4,
    0x0000, 0x0022, 0xFFEF, 0xFFF3, 0xFFEB, 0xFFE4, 0x0013, 0xFFF6,
    0x000C, 0xFFF7, 0x0008, 0xFFFA, 0xFFFD, 0x0012, 0x001D, 0xFFE6,
    0xFFEA, 0x0005, 0xFFEA, 0xFFEF, 0x001E, 0x0019, 0xFFE4, 0x000B,
    0x0013, 0x000F, 0xFFED, 0x000F, 0xFFF5, 0x0011, 0x000F, 0xFFF4,
    0x0027, 0x0001, 0xFFE2, 0xFFEB, 0xFFF4, 0x000A, 0x000A, 0x0017,
    0x0001, 0xFFF5, 0x0009, 0x0006, 0x0002, 0x0005, 0xFFE8, 0x0000,
    0x000C, 0x000C, 0x0015, 0x0005, 0x0021, 0x0014, 0x0015, 0x0000,
    0x0007, 0x0010, 0xFFF5, 0xFFF4, 0xFFF4, 0xFFE6, 0x0002, 0xFFEF,
    0x0012, 0xFFED, 0x000B, 0x0038, 0x0002, 0xFFDE, 0xFFFA, 0x0018,
    0x0003, 0xFFFD, 0x0001, 0xFFEE, 0x0005, 0x0009, 0x001B, 0xFFFD,
    0xFFFB, 0x000F, 0xFFF9, 0xFFFB, 0x0011, 0x0011, 0x0012, 0xFFF2,
    0x000F, 0xFFE6, 0x000E, 0x0002, 0xFFEE, 0xFFFF, 0xFFFB, 0x0006,
    0x0004, 0x000C, 0x0009, 0x000C, 0x000E, 0x0004, 0xFFF5, 0x0003,
    0x0016, 0xFFF8, 0x001C, 0xFFF7, 0x0004, 0xFFFE, 0x0001, 0x0018,
    0x0027, 0xFFEE, 0xFFEC, 0x0008, 0x0012, 0x0006, 0x000B, 0xFFFE,
    0x0024, 0x0017, 0x000A, 0xFFE4, 0xFFEB, 0x0019, 0x0002, 0xFFFF,
    0x0011, 0xFFFF, 0x000A, 0x0004, 0x001A, 0x0008, 0xFFF2, 0xFFEA,
    0x0005, 0x000D, 0xFFEE, 0xFFFB, 0x0006, 0x0022, 0xFFFB, 0x0004,
    0xFFF8, 0x0018, 0xFFF0, 0xFFFA, 0x0002, 0x0018, 0xFFE5, 0xFFE0,
    0xFFDC, 0xFFF8, 0x0012, 0xFFF4, 0x0004, 0xFFF8, 0xFFF7, 0x0011,
    0x0009, 0xFFF2, 0x0017, 0x0009, 0x0006, 0x001E, 0x0000, 0xFFE5,
    0x000E, 0x000C, 0xFFFC, 0x0008, 0x0015, 0xFFF7, 0xFFF1, 0x000E,
    0x0002, 0xFFFB, 0xFFEE, 0xFFF6, 0x001E, 0xFFF0, 0xFFF5, 0xFFF1,
    0x0002, 0xFFF4, 0xFFF4, 0xFFE4, 0xFFFC, 0x000A, 0x0009, 0xFFFF,
    0x000C, 0x0017, 0x0009, 0xFFF0, 0xFFDF, 0xFFEE, 0xFFED, 0xFFF7,
    0x0014, 0x0015, 0xFFF8, 0x0006, 0xFFFC, 0x001C, 0xFFEC, 0x0006,
    0x000E, 0xFFFF, 0xFFFF, 0xFFF7, 0x0004, 0xFFFB, 0xFFFF, 0x0010,
    0xFFFF, 0xFFDB, 0x001D, 0x0011, 0xFFF9, 0x000B, 0x0004, 0x0001,
    0xFFEC, 0xFFFC, 0xFFE9, 0xFFFB, 0xFFF2, 0x0002, 0x0001, 0x0006,
    0x0010, 0xFFF3, 0x0006, 0xFFF0, 0xFFF1, 0xFFD8, 0xFFF4, 0x0009,
    0xFFEF, 0xFFE4, 0xFFFD, 0xFFFF, 0xFFF5, 0xFFFD, 0x0013, 0x000E,
    0xFFE4, 0xFFFB, 0xFFED, 0x0024, 0xFFF2, 0xFFF4, 0x0004, 0x0018,
    0xFFF7, 0xFFEA, 0x0001, 0x0005, 0x0011, 0x000C, 0x0008, 0xFFED,
    0x0014, 0x000E, 0xFFFC, 0xFFFA, 0x0000, 0xFFF9, 0x0016, 0x0021,
    0xFFF0, 0x0014, 0xFFEB, 0x000C, 0xFFF3, 0xFFFA, 0x0014, 0xFFFA,
    0x0004, 0x001D, 0x000F, 0x0024, 0x0009, 0xFFFF, 0x002A, 0x000C,
    0x0021, 0x0007, 0x0006, 0x0018, 0x0008, 0xFFEF, 0xFFF5, 0x000B,
    0x0009, 0xFFFF, 0xFFE7, 0xFFF7, 0xFFFB, 0xFFFD, 0x0023, 0x0014,
    0x000B, 0x0011, 0xFFF9, 0x0018, 0xFFFC, 0x000E, 0x001F, 0x002B,
    0x0008, 0x0005, 0xFFF6, 0xFFE6, 0xFFE8, 0xFFF3, 0xFFFF, 0x0005,
    0xFFF6, 0xFFEB, 0xFFF7, 0xFFFE, 0xFFFC, 0xFFFD, 0x001F, 0xFFF1,
    0xFFFF, 0x0006, 0x001A, 0xFFEC, 0xFFE8, 0x0004, 0xFFE4, 0xFFEF,
    0x0010, 0x0016, 0x0005, 0xFFF3, 0xFFFE, 0xFFF3, 0x000F, 0xFFED,
    0xFFE8, 0x0006, 0x0001, 0x000D, 0xFFF1, 0x0007, 0x0001, 0xFFEA,
    0x000D, 0x0007, 0x0007, 0xFFF3, 0xFFF7, 0x000E, 0x000D, 0xFFF8,
    0xFFE2, 0x0012, 0xFFEB, 0xFFE3, 0x0006, 0x000C, 0x000E, 0xFFF1,
    0x000C, 0xFFF6, 0xFFF0, 0xFFF8, 0x0004, 0x000F, 0x0016, 0xFFF7,
    0x0008, 0x0006, 0x000F, 0xFFF7, 0xFFF3, 0xFFFE, 0x000E, 0x0025,
    0x000B, 0xFFF2, 0xFFF2, 0xFFFF, 0xFFE4, 0xFFF7, 0xFFFA, 0xFFE6,
    0xFFFF, 0xFFF5, 0x0004, 0x001C, 0x0006, 0x000B, 0xFFF5, 0xFFEF,
    0xFFFA, 0xFFF5, 0xFFEC, 0x000F, 0xFFFE, 0x0019, 0x0005, 0x0001,
    0x0000, 0x0006, 0x0013, 0x0020, 0x0009, 0xFFDD, 0xFFFA, 0xFFF8,
    0x0006, 0xFFFB, 0xFFF4, 0xFFE8, 0xFFE2, 0x0014, 0xFFFA, 0xFFFB,
    0x0016, 0x000B, 0x0005, 0xFFEF, 0x0005, 0xFFFD, 0x0011, 0xFFEB,
    0x0016, 0x000D, 0xFFE7, 0x001F, 0x0000, 0xFFDF, 0x0000, 0x0015,
    0x001B, 0x0014, 0x002C, 0x0009, 0x0013, 0xFFE5, 0x001E, 0x0015,
    0x0008, 0x0001, 0xFFFB, 0x0000, 0xFFF7, 0x0016, 0xFFE3, 0x0007,
    0x0000, 0x000F, 0x000D, 0x0001, 0xFFDF, 0x0001, 0xFFD7, 0x0011,
    0xFFF2, 0xFFC8, 0xFFF1, 0xFFFF, 0x0013, 0x0014, 0x0017, 0x0008,
    0xFFE3, 0xFFF5, 0x0015, 0x0006, 0x000C, 0xFFFE, 0xFFF1, 0x0001,
    0x0011, 0x0003, 0xFFFB, 0xFFFB, 0x0027, 0xFFE8, 0xFFFF, 0x0009,
    0xFFF1, 0xFFF5, 0x0014, 0xFFE9, 0x0009, 0x0013, 0x0014, 0xFFFF,
    0x0008, 0x000D, 0x0004, 0xFFE7, 0x000A, 0xFFF6, 0x0014, 0x001F,
    0xFFFE, 0x000B, 0xFFFB, 0xFFF8, 0x0008, 0x0002, 0x000F, 0xFFF3,
    0xFFEE, 0x0010, 0xFFE0, 0x0027, 0x0006, 0xFFF6, 0x0008, 0xFFF4,
    0x0010, 0xFFEA, 0xFFD6, 0x000A, 0xFFE9, 0xFFFA, 0xFFE9, 0x0000,
    0x0003, 0xFFDF, 0xFFFB, 0xFFF2, 0x0024, 0x0001, 0xFFF9, 0xFFE2,
    0x0004, 0x0006, 0x0005, 0x0018, 0xFFF8, 0xFFFD, 0x0003, 0x000E,
    0xFFF0, 0x001B, 0x0006, 0x000F, 0xFFFE, 0xFFF1, 0xFFF3, 0xFFF8,
    0xFFF2, 0xFFE1, 0x0003, 0x0016, 0x000A, 0x001A, 0x0010, 0x0005,
    0xFFE8, 0x000F, 0x0005, 0x0022, 0xFFFD, 0xFFF4, 0x0012, 0xFFD7,
    0xFFF4, 0xFFF4, 0x001C, 0x001F, 0xFFFA, 0x0004, 0x0012, 0xFFE5,
    0xFFF8, 0xFFEF, 0x0000, 0x0002, 0xFFFB, 0x000D, 0x0005, 0xFFF2,
    0xFFF4, 0x000A, 0x0000, 0xFFF3, 0xFFE8, 0xFFE7, 0xFFEE, 0x001B,
    0x0009, 0x0017, 0x0003, 0xFFF9, 0xFFE4, 0xFFFF, 0xFFFD, 0xFFE7,
    0x002F, 0x0009, 0xFFEC, 0x000A, 0x001E, 0xFFF0, 0xFFFB, 0x0018,
    0x0019, 0x000C, 0x000D, 0x0018, 0x003C, 0xFFE5, 0xFFFE, 0xFFF6,
    0x0004, 0xFFF3, 0x0007, 0x000F, 0xFFF3, 0xFFEF, 0x0018, 0xFFFD,
    0x000D, 0x0012, 0xFFF0, 0x0002, 0xFFFB, 0xFFF4, 0xFFF8, 0xFFFE,
    0x0010, 0x000D, 0x000D, 0x0009, 0x0008, 0xFFDB, 0x0001, 0x000D,
    0x000C, 0xFFF1, 0xFFEA, 0x0012, 0x0008, 0x0001, 0x0016, 0x000C,
    0x0025, 0x0010, 0x0003, 0x0025, 0xFFF5, 0x0001, 0xFFFF, 0x0006,
    0x0024, 0xFFF4, 0xFFF7, 0x0004, 0x0012, 0xFFF9, 0xFFF2, 0xFFEF,
    0x0013, 0xFFFC, 0xFFF7, 0xFFFF, 0xFFE9, 0xFFFE, 0x0010, 0x0009,
    0xFFFD, 0xFFF8, 0x0010, 0x0018, 0xFFED, 0xFFF5, 0xFFF3, 0xFFFB,
    0x0011, 0xFFF5, 0x0005, 0xFFE9, 0xFFE5, 0xFFE8, 0xFFE0, 0x001B,
    0xFFF0, 0x001D, 0xFFFC, 0x0006, 0x0005, 0xFFF5, 0xFFFD, 0xFFF4,
    0x0010, 0x0010, 0xFFFC, 0x000A, 0x0010, 0x001B, 0x001B, 0xFFF4,
    0xFFDD, 0xFFF9, 0xFFF2, 0xFFCE, 0x001B, 0xFFFD, 0x0023, 0x0018,
    0x0000, 0x0010, 0x000B, 0x0016, 0x0000, 0xFFFB, 0x0016, 0xFFFB,
    0xFFFB, 0x0003, 0xFFE8, 0xFFF8, 0x0007, 0xFFF4, 0x0020, 0xFFFD,
    0xFFEE, 0x0005, 0x000E, 0xFFFB, 0x0004, 0xFFFA, 0xFFFA, 0xFFF7,
    0xFFF9, 0xFFDC, 0x0013, 0x0010, 0xFFF7, 0xFFFA, 0x0008, 0xFFF0,
    0xFFFF, 0xFFFA, 0xFFE5, 0x000D, 0x0002, 0x001E, 0x0020, 0x0005,
    0x0007, 0xFFE8, 0xFFF2, 0xFFE5, 0xFFEF, 0x000B, 0xFFE3, 0xFFEE,
    0x001E, 0x0003, 0xFFFC, 0xFFF8, 0x002E, 0xFFFA, 0xFFF6, 0xFFFC,
    0x0002, 0xFFF5, 0xFFE8, 0xFFFC, 0x001D, 0xFFF4, 0xFFE3, 0xFFEF,
    0xFFE1, 0x0002, 0xFFEB, 0x000D, 0x000F, 0xFFF8, 0xFFF5, 0xFFEE,
    0x000D, 0x0000, 0xFFFF, 0xFFED, 0xFFF9, 0xFFED, 0x000E, 0xFFE7,
    0x0006, 0x000D, 0x0012, 0x0036, 0x000D, 0x0010, 0x0003, 0xFFFB,
    0xFFF0, 0xFFF0, 0x0008, 0xFFFC, 0x000A, 0xFFF5, 0x0003, 0x0013,
    0xFFFA, 0xFFF6, 0xFFF8, 0x002A, 0xFFFC, 0x0002, 0x000B, 0x0000,
    0x0003, 0x0010, 0xFFF1, 0x0006, 0xFFFC, 0x0015, 0x0005, 0x0003,
    0x000B, 0xFFEB, 0x000E, 0xFFF7, 0xFFF7, 0xFFF3, 0x0009, 0x0001,
    0xFFF2, 0x000F, 0xFFE8, 0xFFEB, 0x0014, 0x0023, 0xFFEE, 0x0017,
    0x0007, 0xFFDE, 0xFFF2, 0xFFF6, 0x0000, 0xFFEF, 0x000F, 0x000B,
    0x0006, 0x0020, 0xFFF1, 0x0014, 0x003E, 0x0002, 0x0008, 0x0003,
    0xFFE2, 0xFFF1, 0x001A, 0x000F, 0x0001, 0x0009, 0x0009, 0x000D,
    0x0006, 0xFFFB, 0x0006, 0x000F, 0x0006, 0x000F, 0xFFEA, 0xFFE8,
    0xFFFC, 0xFFE2, 0xFFF0, 0x0021, 0xFFF0, 0xFFEA, 0xFFE8, 0x0007,
    0x0001, 0xFFFB, 0xFFEB, 0xFFF7, 0xFFEE, 0xFFF9, 0xFFF1, 0xFFE2,
    0xFFE2, 0x0015, 0xFFFD, 0x0001, 0xFFF7, 0x0004, 0x0007, 0x0002,
    0x0006, 0xFFFA, 0xFFE9, 0xFFF6, 0x000C, 0x001B, 0xFFF1, 0xFFEA,
    0xFFFA, 0xFFE9, 0x0002, 0xFFEE, 0xFFF3, 0xFFFC, 0x001A, 0xFFFF,
    0x0001, 0x0017, 0x000B, 0x0011, 0x0014, 0xFFEB, 0x0004, 0x0003,
    0xFFF8, 0xFFE5, 0x0010, 0xFFEF, 0x000A, 0x0012, 0xFFD8, 0x0008,
    0x0025, 0xFFF8, 0xFFFE, 0xFFFB, 0x0014, 0xFFEE, 0x0008, 0x000D,
    0x0020, 0x0038, 0x0002, 0x0004, 0xFFF0, 0x0010, 0x0026, 0xFFEB,
    0xFFE8, 0xFFE9, 0xFFFA, 0xFFF6, 0x000A, 0xFFFF, 0xFFDE, 0x0002,
    0x0012, 0xFFE8, 0x0018, 0x0001, 0x0022, 0x0000, 0x0000, 0xFFFB,
    0x0005, 0xFFE1, 0xFFE2, 0xFFF5, 0xFFE1, 0x0032, 0x0004, 0x0002,
    0xFFFE, 0xFFF7, 0xFFEC, 0xFFFF, 0xFFEA, 0xFFFE, 0xFFE3, 0x000D,
    0xFFF1, 0x0012, 0x0016, 0x000E, 0x000B, 0xFFDF, 0x0002, 0x000C,
    0x0001, 0xFFF9, 0xFFF3, 0xFFEB, 0xFFFF, 0x001A, 0xFFF1, 0x0010,
    0x0012, 0x0001, 0xFFFB, 0x000F, 0xFFF2, 0xFFE2, 0x000B, 0xFFFD,
    0xFFF5, 0x0004, 0xFFED, 0xFFF4, 0xFFDF, 0xFFF7, 0xFFEA, 0x0024,
    0x0000, 0x0016, 0xFFFD, 0x001D, 0xFFF3, 0x0006, 0x0019, 0x0010,
    0xFFDD, 0xFFE2, 0x0003, 0xFFF5, 0xFFFF, 0xFFF3, 0xFFEA, 0x0001,
    0x000D, 0x0014, 0xFFF7, 0x0009, 0x0005, 0x000F, 0xFFEE, 0xFFF5,
    0xFFFD, 0x000C, 0xFFEB, 0xFFFA, 0x0007, 0x0002, 0xFFF7, 0x0014,
    0xFFFD, 0x000C, 0x000A, 0xFFED, 0xFFF6, 0xFFE0, 0x000E, 0xFFFC,
    0x0002, 0x0018, 0xFFE9, 0xFFFD, 0xFFF1, 0xFFFC, 0xFFF9, 0x0010,
    0xFFF8, 0x000C, 0xFFF1, 0xFFF2, 0xFFF5, 0x0011, 0x0005, 0xFFEB,
    0xFFEC, 0xFFEA, 0xFFDC, 0x000D, 0xFFFE, 0x0026, 0xFFF7, 0xFFF5,
    0xFFF7, 0xFFF6, 0x0007, 0xFFF0, 0x000C, 0xFFFA, 0x0011, 0xFFF0,
    0x0006, 0xFFF5, 0x001A, 0x0019, 0x0007, 0x0000, 0x000C, 0xFFED,
    0xFFF4, 0xFFF7, 0xFFE9, 0xFFF7, 0x0001, 0x000C, 0xFFCF, 0x000A,
    0xFFEF, 0x0008, 0x000F, 0xFFF6, 0xFFF6, 0xFFF7, 0xFFFA, 0x0008,
    0x000C, 0x0011, 0x0006, 0x0011, 0x0008, 0x0020, 0xFFF2, 0xFFF1,
    0xFFFC, 0x000E, 0xFFFD, 0x000C, 0xFFFB, 0x0002, 0x0005, 0x0008,
    0xFFFC, 0xFFF7, 0xFFF8, 0x0000, 0x0016, 0xFFEC, 0x0037, 0x0000,
    0xFFEB, 0xFFE5, 0x0008, 0xFFF8, 0x000B, 0xFFF0, 0xFFED, 0xFFF8,
    0x001F, 0xFFF9, 0xFFFA, 0xFFF7, 0xFFED, 0x0001, 0xFFFC, 0xFFF2,
    0xFFE6, 0x001B, 0xFFFB, 0xFFFA, 0x0003, 0x0007, 0x000A, 0x000B,
    0x0026, 0x0015, 0xFFFB, 0xFFFF, 0x0002, 0xFFF5, 0x0001, 0x0003,
    0xFFFA, 0xFFFF, 0xFFF1, 0xFFF6, 0xFFF6, 0xFFED, 0x0010, 0xFFFB,
    0xFFFF, 0xFFF4, 0x0017, 0xFFFF, 0x0010, 0x0023, 0xFFE5, 0xFFF2,
    0xFFDF, 0xFFE6, 0x002E, 0xFFFB, 0xFFDC, 0x0004, 0xFFF8, 0x0014,
    0xFFED, 0xFFEE, 0x0021, 0x0004, 0xFFFE, 0x0010, 0x001C, 0xFFF0,
    0x0000, 0xFFF1, 0x0009, 0x0001, 0x0003, 0x0001, 0x0009, 0x0010,
    0x0020, 0xFFEB, 0x0012, 0xFFEB, 0x000B, 0xFFDF, 0xFFFB, 0x0015,
    0x0007, 0x0015, 0x0021, 0xFFFC, 0x0025, 0x0000, 0x000E, 0x0015,
    0x0015, 0x0005, 0xFFF1, 0xFFC3, 0xFFFE, 0xFFFB, 0xFFCB, 0xFFE4,
    0xFFFC, 0xFFE7, 0xFFF0, 0x0022, 0xFFFF, 0xFFE4, 0xFFFF, 0xFFE3,
    0xFFEC, 0x0008, 0x000D, 0x000D, 0x0007, 0xFFF4, 0xFFFC, 0xFFFA,
    0xFFE5, 0x0025, 0xFFE0, 0xFFF8, 0x002E, 0x0000, 0x0017, 0x0003,
    0x0010, 0x0004, 0xFFDF, 0x001C, 0xFFED, 0x0006, 0x0015, 0x0011,
    0xFFF8, 0x0004, 0x0024, 0xFFF1, 0xFFEB, 0x001F, 0x0005, 0xFFF9,
    0x002D, 0xFFF8, 0x0012, 0x0021, 0x0001, 0x0007, 0x000F, 0xFFF2,
    0x0011, 0x000E, 0x001D, 0xFFEE, 0x000D, 0xFFF4, 0xFFF7, 0xFFF6,
    0xFFEF, 0xFFEF, 0xFFF9, 0x0009, 0xFFF4, 0xFFF9, 0xFFE3, 0xFFE6,
    0xFFFC, 0x0002, 0xFFFF, 0x0008, 0x000E, 0xFFED, 0x0025, 0x0014,
    0x001C, 0x0015, 0xFFF0, 0xFFF5, 0x0001, 0x0003, 0xFFF7, 0x0000,
    0x0010, 0x0011, 0xFFFB, 0x0018, 0x0008, 0xFFFC, 0x0020, 0x0010,
    0x0019, 0x0000, 0x0006, 0x000F, 0xFFF7, 0xFFF7, 0xFFE0, 0xFFF1,
    0x0003, 0x0001, 0xFFFA, 0xFFF4, 0xFFE2, 0x0016, 0xFFE7, 0x0009,
    0x0000, 0x0010, 0x0009, 0xFFE4, 0xFFF5, 0xFFF8, 0x001E, 0x0008,
    0x0020, 0x0012, 0x000A, 0xFFF0, 0xFFF4, 0x0008, 0x0002, 0x0015,
    0x000E, 0x0002, 0xFFF8, 0xFFFD, 0xFFF5, 0x000D, 0xFFED, 0x000D,
    0xFFF5, 0x0022, 0x0017, 0xFFF7, 0xFFFC, 0xFFF7, 0x0002, 0x0000,
    0x0031, 0x0006, 0xFFF8, 0x001E, 0xFFFD, 0xFFEB, 0xFFFC, 0xFFF6,
    0xFFF9, 0xFFF5, 0x0008, 0x0002, 0x0001, 0x000D, 0xFFEF, 0x0011,
    0xFFFE, 0x000A, 0xFFEC, 0xFFF5, 0xFFFE, 0xFFFB, 0x000C, 0x000A,
    0x0011, 0x0018, 0x0002, 0x001E, 0xFFFE, 0x0007, 0x000A, 0x0001,
    0x0001, 0xFFF2, 0xFFFD, 0xFFF9, 0x0015, 0xFFF3, 0xFFF0, 0x000A,
    0x0000, 0x0005, 0xFFEF, 0xFFD4, 0xFFE4, 0x0001, 0x0006, 0xFFE4,
    0xFFF9, 0xFFDF, 0xFFE9, 0x000F, 0x001F, 0x0000, 0x000F, 0x0000,
    0x0002, 0xFFEF, 0x0002, 0xFFFE, 0xFFF3, 0x0000, 0xFFE8, 0x0003,
    0x0005, 0xFFF9, 0x0015, 0x0008, 0xFFFD, 0x000C, 0x002C, 0x000C,
    0xFFEF, 0xFFFB, 0xFFF5, 0xFFF3, 0xFFFF, 0xFFF7, 0xFFEA, 0x0002,
    0x000F, 0xFFF0, 0x0005, 0xFFE8, 0xFFF8, 0xFFF4, 0x0022, 0xFFFB,
    0xFFF4, 0xFFF5, 0x0012, 0xFFF3, 0xFFFB, 0x0021, 0xFFF2, 0xFFFB,
    0x0007, 0xFFF1, 0xFFFC, 0xFFE3, 0x0001, 0xFFF9, 0x000C, 0x001A,
    0x0008, 0x0020, 0x0006, 0x000C, 0xFFFF, 0x0023, 0x001E, 0xFFFA,
    0x0006, 0x000A, 0x0016, 0xFFFD, 0x0014, 0x000E, 0x000D, 0xFFF0,
    0x0003, 0x0025, 0xFFE6, 0x0006, 0x000C, 0x0014, 0x000E, 0x0008,
    0x0005, 0x0016, 0x0013, 0xFFFD, 0xFFFE, 0xFFF7, 0x0001, 0xFFFB,
    0xFFEC, 0x0014, 0xFFF7, 0x000C, 0xFFE7, 0xFFF0, 0xFFF8, 0xFFEA,
    0xFFF5, 0x001E, 0xFFE6, 0xFFEC, 0x0011, 0xFFF8, 0x0008, 0xFFFC,
    0xFFFA, 0xFFE7, 0xFFEB, 0xFFFA, 0xFFF9, 0x0019, 0xFFDD, 0x000C,
    0xFFF8, 0x0003, 0x002A, 0x0005, 0xFFFB, 0xFFF2, 0xFFEA, 0x001F,
    0x0000, 0xFFF8, 0x0001, 0xFFFA, 0xFFEB, 0xFFE3, 0xFFEE, 0x0002,
    0x0003, 0x0023, 0xFFFB, 0x000B, 0xFFF7, 0x000D, 0x0001, 0xFFED,
    0x0000, 0xFFFD, 0xFFED, 0xFFF5, 0xFFF9, 0x0011, 0xFFEB, 0x0005,
    0xFFF6, 0xFFFA, 0xFFFB, 0xFFF4, 0xFFFA, 0x0003, 0xFFFD, 0x0019,
    0xFFFE, 0x0001, 0xFFF3, 0xFFFA, 0xFFE1, 0x001E, 0xFFF2, 0xFFDC,
    0x0004, 0xFFF2, 0x0000, 0x0017, 0x0018, 0xFFF8, 0x0003, 0xFFF3,
    0xFFFA, 0xFFFF, 0x0003, 0xFFE2, 0xFFE6, 0x000C, 0xFFF7, 0x000A,
    0xFFF4, 0xFFD6, 0x0009, 0x000D, 0x0009, 0xFFF8, 0xFFF5, 0x0012,
    0xFFE9, 0x0000, 0xFFE2, 0xFFFD, 0xFFF4, 0x0004, 0x0008, 0xFFEB,
    0xFFFF, 0x0012, 0x0005, 0x0010, 0xFFEB, 0xFFFF, 0x000D, 0x0007,
    0xFFF8, 0xFFF7, 0xFFF0, 0x000A, 0xFFDB, 0xFFF2, 0xFFFF, 0x0010,
    0xFFFD, 0xFFEE, 0xFFEB, 0x0009, 0x0007, 0x0019, 0x001F, 0xFFE8,
    0x000B, 0x0010, 0x0021, 0x0024, 0xFFFC, 0x0011, 0x000D, 0x002D,
    0x001C, 0x000E, 0x000F, 0xFFED, 0xFFED, 0xFFFA, 0x0014, 0x0017,
    0xFFE9, 0x0004, 0xFFFA, 0xFFF7, 0x0007, 0x0005, 0x0010, 0xFFDF,
    0x000B, 0xFFF2, 0x0002, 0x0011, 0xFFEC, 0x0009, 0x0002, 0x0023,
    0x0000, 0xFFEA, 0x000F, 0xFFE9, 0xFFF9, 0xFFFA, 0x0000, 0xFFEE,
    0xFFD9, 0x0009, 0xFFE9, 0xFFFB, 0x0009, 0xFFF1, 0xFFE6, 0x0005,
    0x0003, 0x000A, 0x0015, 0x0016, 0x0007, 0x0012, 0x002D, 0xFFF6,
    0x0004, 0x000A, 0x001D, 0xFFFD, 0x0006, 0x0005, 0x0016, 0x0012,
    0xFFE5, 0xFFEA, 0x0005, 0xFFF2, 0xFFF3, 0xFFE5, 0xFFF2, 0xFFEF,
    0x0021, 0xFFF1, 0x000A, 0x0013, 0x000F, 0xFFE5, 0x0008, 0xFFFA,
    0xFFF0, 0xFFFA, 0x0012, 0xFFFE, 0x0010, 0x0024, 0xFFEA, 0x0004,
    0x0009, 0xFFFA, 0xFFFB, 0xFFFF, 0xFFF8, 0x0010, 0xFFF0, 0xFFF3,
    0x000E, 0xFFEF, 0xFFEE, 0x0016, 0x000A, 0xFFEF, 0xFFFD, 0xFFEB,
    0x0013, 0x0007, 0xFFFF, 0xFFDD, 0xFFFF, 0xFFF5, 0xFFDF, 0xFFF3,
    0xFFEE, 0xFFF2, 0xFFF6, 0x001B, 0xFFED, 0x000A, 0xFFF3, 0x0014,
    0x0013, 0xFFEA, 0xFFFA, 0x0015, 0x0007, 0x0019, 0xFFE5, 0xFFF6,
    0x0007, 0x0013, 0xFFE6, 0x001B, 0xFFEE, 0xFFFF, 0x0008, 0x0001,
    0xFFFD, 0x0013, 0x0007, 0x0005, 0x001B, 0x0002, 0xFFE7, 0x0013,
    0x0010, 0xFFEC, 0x0006, 0x001F, 0x0004, 0x0007, 0xFFF1, 0x0003,
    0x0005, 0xFFF5, 0xFFF6, 0x001D, 0xFFE2, 0xFFEC, 0x0006, 0x0002,
    0x0005, 0xFFE5, 0xFFF6, 0xFFF9, 0xFFEA, 0xFFEE, 0xFFEA, 0x000F,
    0x0015, 0xFFFA, 0x0002, 0xFFE8, 0x000F, 0x0006, 0x0023, 0xFFFA,
    0xFFFE, 0x0008, 0xFFD6, 0xFFF3, 0x0013, 0xFFEB, 0x000A, 0x000F,
    0xFFFE, 0x0015, 0xFFEF, 0xFFDD, 0xFFFD, 0x0005, 0x0029, 0x001F,
    0x0018, 0xFFF4, 0xFFDB, 0xFFED, 0x000D, 0x0006, 0x0012, 0x0010,
    0x0003, 0x0023, 0x0016, 0x001C, 0x000F, 0xFFEE, 0xFFE6, 0x0012,
    0x001C, 0xFFE7, 0xFFDB, 0x000F, 0xFFFF, 0xFFFB, 0x0005, 0x0013,
    0x0003, 0x000F, 0xFFF2, 0xFFF8, 0xFFD9, 0xFFF7, 0x000C, 0x0004,
    0x0000, 0x0000, 0xFFF8, 0xFFF0, 0x0024, 0xFFEC, 0x0001, 0xFFF8,
    0x000E, 0xFFFE, 0x000B, 0x000C, 0xFFF1, 0xFFF8, 0xFFF6, 0xFFF8,
    0xFFFF, 0xFFFF, 0xFFFA, 0x0000, 0x0004, 0xFFF7, 0x0002, 0x001B,
    0xFFFB, 0xFFE7, 0x0000, 0x0018, 0x0006, 0x0013, 0xFFFB, 0xFFEA,
    0x002E, 0x0004, 0x0009, 0xFFF3, 0xFFF0, 0x0007, 0xFFFB, 0xFFF4,
    0xFFF6, 0xFFF7, 0xFFF8, 0xFFF1, 0x0006, 0x000D, 0xFFEA, 0x0002,
    0xFFF3, 0xFFE4, 0x0014, 0xFFFE, 0xFFFB, 0x000A, 0x0004, 0xFFFC,
    0xFFFD, 0x000C, 0xFFFE, 0x0002, 0x0008, 0x0014, 0xFFEE, 0x0002,
    0xFFE6, 0x0002, 0x0004, 0x0004, 0x000F, 0x0004, 0x0012, 0xFFE7,
    0xFFEC, 0xFFF8, 0x0010, 0xFFDB, 0x000D, 0x000A, 0xFFF6, 0xFFDB,
    0xFFFF, 0xFFF2, 0xFFE2, 0xFFEA, 0x0007, 0xFFC6, 0x0008, 0x001B,
    0x001D, 0x0004, 0xFFEF, 0x0003, 0x000D, 0xFFE9, 0xFFEB, 0x0008,
    0x000E, 0x000F, 0x0010, 0xFFD9, 0xFFEF, 0x0002, 0x000A, 0x0001,
    0xFFF8, 0x000A, 0xFFD5, 0xFFE2, 0xFFD3, 0x0011, 0x0007, 0x0001,
    0xFFFD, 0x0002, 0x000B, 0x0007, 0x001D, 0xFFED, 0xFFD3, 0xFFEE,
    0xFFF4, 0xFFED, 0x0019, 0xFFDE, 0xFFEF, 0x0015, 0xFFFF, 0x0019,
    0xFFED, 0x0011, 0x0001, 0xFFFD, 0x0004, 0x000A, 0xFFD8, 0x0000,
    0x0004, 0xFFE8, 0x0018, 0xFFE8, 0x000B, 0x0005, 0xFFE9, 0x0004,
    0x000A, 0xFFFD, 0x0015, 0xFFFF, 0x000E, 0x0014, 0xFFF6, 0x0008,
    0x001F, 0xFFF4, 0x0014, 0x0010, 0xFFF5, 0x000C, 0xFFF6, 0x0000,
    0xFFF2, 0x0013, 0xFFFC, 0xFFCD, 0xFFF9, 0xFFEF, 0xFFF3, 0x0012,
    0xFFE5, 0x0001, 0xFFF7, 0x0013, 0x0005, 0xFFDE, 0xFFFF, 0x0011,
    0xFFEC, 0xFFFC, 0xFFEE, 0xFFF6, 0xFFFC, 0xFFFD, 0xFFF6, 0x0033,
    0xFFF6, 0x0023, 0xFFEF, 0xFFF7, 0xFFF0, 0x0026, 0x0005, 0xFFE7,
    0x0001, 0x0003, 0x001A, 0xFFFA, 0x0000, 0xFFF1, 0x0016, 0xFFD7,
    0x0018, 0xFFFE, 0xFFE8, 0x0001, 0xFFFF, 0x0007, 0xFFEB, 0xFFFD,
    0xFFFA, 0x0001, 0xFFF8, 0xFFED, 0x0007, 0x0001, 0xFFED, 0xFFEB,
    0x000C, 0xFFDB, 0xFFF7, 0x000D, 0x0007, 0x0017, 0xFFED, 0x0005,
    0xFFFD, 0x0002, 0xFFF3, 0xFFE2, 0xFFF2, 0x001D, 0x0005, 0x0004,
    0xFFF3, 0x0009, 0xFFED, 0xFFFF, 0xFFFC, 0xFFE2, 0xFFFB, 0x0023,
    0x000E, 0xFFEF, 0xFFE8, 0x0012, 0xFFFE, 0x0001, 0xFFF9, 0x0019,
    0xFFF8, 0xFFF0, 0xFFE7, 0x000D, 0x001B, 0xFFEB, 0x0008, 0x0026,
    0xFFD3, 0xFFE5, 0xFFFB, 0x0009, 0xFFF4, 0xFFDA, 0x0004, 0xFFDD,
    0xFFFF, 0x000B, 0xFFF1, 0xFFFE, 0x0002, 0x0012, 0x000B, 0x0006,
    0x0000, 0xFFED, 0x0005, 0x0002, 0xFFE9, 0xFFF3, 0x0012, 0x0016,
    0x0003, 0x0014, 0xFFDD, 0x0018, 0x0008, 0x0001, 0x0007, 0x000E,
    0xFFFF, 0xFFFA, 0xFFF6, 0x0023, 0x000E, 0x0003, 0x0002, 0xFFFB,
    0xFFE7, 0x000D, 0xFFEA, 0x001B, 0xFFE4, 0x0006, 0x000A, 0xFFFC,
    0xFFF6, 0xFFFF, 0xFFFE, 0x0019, 0x0025, 0x0000, 0xFFFC, 0x0009,
    0x0007, 0xFFF0, 0x000F, 0xFFF1, 0x0020, 0xFFFD, 0xFFF9, 0x0009,
    0xFFF7, 0xFFFD, 0xFFF0, 0x000A, 0x0021, 0x0009, 0xFFF9, 0xFFF3,
    0xFFED, 0xFFF9, 0xFFED, 0x0017, 0xFFFF, 0x0008, 0x000B, 0x0006,
    0x000B, 0x000B, 0xFFF7, 0x0002, 0x001B, 0xFFF6, 0x0002, 0xFFFB,
    0xFFEE, 0x0001, 0x0003, 0xFFF9, 0xFFF8, 0x0005, 0x0012, 0x0003,
    0xFFE8, 0xFFF1, 0x0001, 0x000A, 0xFFFC, 0xFFF6, 0x000B, 0xFFF1,
    0xFFF7, 0x0003, 0x0016, 0x0015, 0xFFF3, 0x001E, 0xFFF5, 0x000A,
    0x000C, 0x001B, 0xFFEE, 0x000F, 0xFFE9, 0xFFF1, 0xFFF3, 0x000C,
    0x0008, 0xFFF1, 0x0017, 0x0013, 0xFFEA, 0x0021, 0x0004, 0x0000,
    0xFFFA, 0x0019, 0xFFFD, 0xFFDB, 0xFFEC, 0x0008, 0x0000, 0x0004,
    0xFFF2, 0xFFF8, 0x0004, 0x000A, 0x0015, 0xFFFB, 0x0004, 0xFFEC,
    0x0005, 0xFFED, 0xFFF9, 0xFFF7, 0x0011, 0xFFF4, 0x0016, 0xFFF8,
    0xFFF2, 0xFFF0, 0xFFF6, 0xFFF8, 0xFFF8, 0x000D, 0x000F, 0x0002,
    0x000C, 0x000E, 0x0019, 0x0015, 0x0008, 0x0015, 0xFFE1, 0x0018,
    0xFFF9, 0xFFFA, 0x0011, 0x0014, 0xFFFD, 0x000B, 0xFFFC, 0xFFF9,
    0x0015, 0x001D, 0xFFFC, 0xFFFF, 0xFFFF, 0x000E, 0x0007, 0x0007,
    0xFFF6, 0xFFF5, 0xFFD5, 0xFFEC, 0x0015, 0xFFFB, 0xFFDD, 0x0006,
    0xFFF8, 0xFFF4, 0xFFED, 0x0008, 0xFFFC, 0x001B, 0xFFE6, 0xFFF9,
    0x0008, 0x0020, 0xFFFE, 0x0007, 0x000D, 0x0004, 0x000F, 0x001E,
    0xFFF9, 0x0014, 0xFFE8, 0x0013, 0xFFF1, 0x0002, 0x0007, 0xFFE2,
    0xFFE1, 0x001C, 0xFFFA, 0x002C, 0xFFF9, 0x0014, 0x0002, 0x0007,
    0x0017, 0x0006, 0x0009, 0xFFFE, 0x0012, 0x0009, 0xFFF9, 0x002A,
    0xFFEE, 0xFFFC, 0xFFF3, 0x0000, 0x0022, 0x0019, 0xFFF0, 0xFFE1,
    0xFFF3, 0x0010, 0xFFF5, 0x000C, 0xFFFC, 0xFFD5, 0x0027, 0x0002,
    0xFFEC, 0xFFF9, 0xFFFF, 0x0007, 0x0012, 0xFFF5, 0x0011, 0x000F,
    0x0016, 0xFFFC, 0x0005, 0x0005, 0x0006, 0xFFEC, 0xFFFC, 0xFFEC,
    0x0031, 0xFFFA, 0x0019, 0x000E, 0xFFEF, 0x0000, 0x0008, 0xFFFF,
    0x0004, 0x001F, 0xFFE8, 0xFFF5, 0x000A, 0xFFDB, 0xFFEC, 0xFFF0,
    0xFFFA, 0x0000, 0xFFF6, 0x0002, 0xFFF8, 0x0009, 0x0018, 0xFFE1,
    0xFFEF, 0x001E, 0xFFEE, 0x0029, 0xFFF9, 0xFFE5, 0xFFFA, 0xFFE7,
    0xFFED, 0xFFF0, 0x0001, 0xFFED, 0xFFDD, 0xFFF2, 0x0002, 0xFFF4,
    0xFFE5, 0xFFEE, 0x0010, 0x0018, 0xFFF0, 0x0002, 0x0021, 0x0006,
    0xFFFC, 0xFFF8, 0xFFF8, 0x000C, 0x002C, 0x0002, 0x0011, 0xFFFA,
    0xFFFA, 0xFFED, 0x0001, 0xFFE8, 0xFFF3, 0xFFFD, 0xFFEF, 0xFFD3,
    0xFFC9, 0xFFFC, 0x0023, 0x0016, 0xFFF7, 0xFFEA, 0x0010, 0xFFE5,
    0x0018, 0xFFF1, 0x000A, 0x0004, 0xFFDA, 0xFFFB, 0x0000, 0xFFF3,
    0x0008, 0xFFED, 0xFFF0, 0x0004, 0xFFD9, 0xFFF8, 0x0005, 0xFFF5,
    0x0012, 0x0017, 0x001E, 0x000A, 0x002C, 0xFFF6, 0xFFF5, 0x001B,
    0xFFE5, 0x0008, 0xFFED, 0xFFFB, 0x0008, 0x0014, 0x0022, 0xFFF4,
    0x0000, 0xFFFE, 0x0001, 0xFFF8, 0xFFEF, 0xFFEA, 0xFFEE, 0x0011,
    0x0003, 0xFFF1, 0xFFF4, 0xFFF2, 0xFFFC, 0xFFE8, 0xFFE3, 0x0007,
    0x0015, 0x0017, 0xFFF7, 0xFFEA, 0x0027, 0x0005, 0x0012, 0x0011,
    0x001A, 0xFFED, 0xFFDE, 0xFFF6, 0xFFF6, 0x0003, 0xFFF9, 0xFFFA,
    0xFFF9, 0xFFEA, 0xFFEB, 0x0022, 0xFFF2, 0xFFF5, 0xFFF4, 0x0008,
    0x0010, 0xFFEB, 0x0003, 0x0025, 0xFFFF, 0x000A, 0xFFE5, 0xFFF5,
    0x0015, 0xFFF9, 0x0000, 0xFFF8, 0xFFE5, 0xFFF5, 0x0001, 0x000F,
    0x0005, 0xFFEE, 0x0011, 0x0015, 0xFFFA, 0x000D, 0xFFF3, 0xFFEF,
    0x0006, 0xFFEC, 0xFFE2, 0xFFFC, 0xFFF5, 0x0001, 0xFFFA, 0xFFFA,
    0xFFFE, 0x0005, 0xFFE2, 0x0004, 0x0000, 0xFFEC, 0x001E, 0xFFE0,
    0x0005, 0x0002, 0xFFEE, 0xFFFC, 0x0008, 0xFFEE, 0xFFCF, 0x0020,
    0xFFEE, 0x0002, 0xFFFC, 0xFFF0, 0xFFF8, 0xFFFF, 0x0025, 0xFFF5,
    0xFFFF, 0x000D, 0x0001, 0x000D, 0xFFFE, 0xFFFB, 0xFFF3, 0x0012,
    0x0005, 0x000C, 0x0007, 0xFFDD, 0xFFED, 0xFFFE, 0x0007, 0x000C,
    0x0004, 0x0000, 0xFFED, 0xFFFF, 0x001A, 0xFFF4, 0xFFFF, 0x0008,
    0xFFE5, 0xFFFB, 0x0017, 0xFFEB, 0x0026, 0xFFF2, 0x0018, 0xFFF4,
    0x0008, 0xFFFA, 0xFFEE, 0xFFF7, 0xFFF2, 0x0010, 0xFFF4, 0xFFE6,
    0xFFE8, 0x0026, 0x000B, 0xFFF1, 0xFFF8, 0xFFFB, 0x0000, 0xFFFC,
    0x0018, 0x0008, 0x0019, 0xFFFB, 0xFFF7, 0xFFF8, 0xFFEB, 0x001E,
    0x0011, 0x0010, 0xFFF7, 0xFFF9, 0x0024, 0x001C, 0xFFFE, 0xFFFA,
    0x0010, 0x000A, 0x000D, 0xFFFF, 0x0005, 0xFFFD, 0x0008, 0xFFE3,
    0xFFFB, 0xFFEF, 0x001C, 0x001B, 0x0019, 0xFFF1, 0x0008, 0x0012,
    0x0019, 0x000C, 0x0025, 0xFFF8, 0xFFFA, 0xFFE2, 0xFFDC, 0xFFFA,
    0x0005, 0x0022, 0x0001, 0x0010, 0xFFFB, 0xFFF7, 0xFFF2, 0xFFEB,
    0xFFED, 0x0009, 0x0002, 0x0012, 0x000C, 0x0021, 0xFFEB, 0x0035,
    0x000C, 0xFFD7, 0xFFE7, 0xFFE5, 0xFFEA, 0x001C, 0x0013, 0x001D,
    0xFFE2, 0xFFF6, 0xFFF4, 0xFFE1, 0xFFF1, 0xFFFA, 0xFFFC, 0x000C,
    0xFFEE, 0x0011, 0xFFFE, 0x0007, 0x002A, 0x0013, 0xFFEC, 0xFFEB,
    0xFFED, 0x0008, 0x0011, 0x0019, 0x0026, 0x0010, 0x001E, 0xFFF3,
    0x001A, 0xFFE5, 0xFFFB, 0x0016, 0x0023, 0xFFF8, 0xFFFD, 0x0011,
    0x0014, 0x001E, 0xFFE9, 0x0025, 0xFFFD, 0x000D, 0xFFFE, 0x0021,
    0x0003, 0xFFEB, 0xFFF9, 0xFFF1, 0x000B, 0xFFEE, 0xFFD7, 0xFFED,
    0xFFF0, 0xFFFA, 0xFFF0, 0x0008, 0xFFDC, 0x0002, 0xFFF9, 0x0017,
    0xFFFF, 0x0009, 0xFFEE, 0x0011, 0xFFF2, 0xFFE6, 0x0007, 0xFFEF,
    0x0017, 0x0004, 0x0010, 0xFFFC, 0x000D, 0x0004, 0xFFF9, 0x0010,
    0xFFFD, 0xFFF6, 0xFFF8, 0x0010, 0xFFF7, 0xFFF2, 0x000F, 0x000A,
    0x002E, 0xFFFC, 0xFFEC, 0xFFF0, 0xFFF5, 0xFFF7, 0x000F, 0x0002,
    0xFFE8, 0x001D, 0xFFF3, 0xFFFE, 0x001A, 0xFFF4, 0x001C, 0x002C,
    0xFFEB, 0x000C, 0xFFFF, 0x0021, 0x0013, 0x000E, 0x000C, 0xFFFC,
    0xFFF0, 0xFFED, 0x0005, 0x0003, 0x0002, 0xFFF4, 0xFFE9, 0x000A,
    0x000B, 0x0001, 0xFFE4, 0x000A, 0x0013, 0xFFED, 0xFFFE, 0xFFF5,
    0xFFE8, 0x0016, 0x0029, 0x0003, 0xFFFF, 0x001B, 0xFFFB, 0xFFFE,
    0x0011, 0xFFE0, 0xFFFF, 0x0005, 0x000E, 0xFFFC, 0xFFFF, 0x0013,
    0xFFFA, 0x0000, 0xFFF4, 0xFFFA, 0x001C, 0xFFF5, 0x0006, 0x0002,
    0xFFFF, 0xFFF0, 0xFFF8, 0xFFF5, 0xFFFD, 0xFFF1, 0x000D, 0xFFF5,
    0x0005, 0x0018, 0xFFE6, 0x0007, 0x000D, 0xFFF5, 0xFFF6, 0x0021,
    0x0019, 0xFFFC, 0x0008, 0xFFF4, 0x0007, 0xFFFF, 0xFFE3, 0xFFFB,
    0x000F, 0x0013, 0xFFE4, 0x0033, 0x0009, 0x0010, 0xFFF8, 0x001E,
    0x0002, 0x000D, 0x0002, 0x0013, 0xFFEA, 0xFFFA, 0x0007, 0xFFE8,
    0xFFE0, 0xFFF7, 0x000E, 0x001B, 0x0004, 0xFFFA, 0x0006, 0x000B,
    0x0006, 0xFFF1, 0xFFEE, 0x0006, 0xFFEE, 0xFFF9, 0xFFF1, 0x0008,
    0x0015, 0x0014, 0x0000, 0xFFFF, 0xFFF8, 0x0004, 0x0008, 0xFFED,
    0x0008, 0x0011, 0xFFF9, 0x0003, 0xFFEE, 0xFFEA, 0x000B, 0xFFEB,
    0x0026, 0xFFE8, 0x000C, 0xFFF0, 0xFFFF, 0x000C, 0xFFE8, 0x0007,
    0xFFFF, 0x0011, 0x0015, 0x0022, 0x0001, 0x0010, 0x0004, 0xFFFF,
    0x000D, 0xFFCF, 0x000F, 0xFFFD, 0xFFF9, 0xFFF2, 0x0003, 0xFFF4,
    0x0011, 0xFFF9, 0xFFE2, 0xFFFB, 0xFFEB, 0xFFE6, 0xFFEB, 0x0003,
    0xFFF8, 0xFFF5, 0x0006, 0xFFD7, 0xFFE8, 0x000B, 0x0008, 0x0004,
    0x0018, 0x0000, 0x0008, 0xFFFC, 0xFFE8, 0xFFF5, 0x0006, 0x0029,
    0xFFF8, 0x000B, 0xFFEB, 0xFFFD, 0xFFEB, 0x001A, 0xFFE2, 0x0005,
    0x0011, 0x0007, 0x0003, 0x000C, 0xFFF9, 0x000E, 0x000F, 0x0003,
    0x000D, 0x0031, 0x0004, 0x0001, 0x0001, 0xFFF0, 0x0015, 0xFFDE,
    0xFFFF, 0xFFEF, 0xFFE8, 0xFFF9, 0xFFFF, 0xFFF4, 0x000C, 0x0010,
    0x0026, 0x0018, 0x000B, 0x0015, 0xFFEE, 0x0016, 0xFFF9, 0xFFFD,
    0x0008, 0xFFEF, 0x0008, 0x0013, 0xFFF8, 0xFFFC, 0x0000, 0x0001,
    0x0015, 0xFFEC, 0xFFF1, 0xFFF8, 0xFFEE, 0x0007, 0xFFEE, 0xFFFA,
    0x0006, 0x000F, 0x0006, 0xFFF5, 0x0004, 0x0006, 0x000E, 0xFFE5,
    0xFFE0, 0x0009, 0x0007, 0x0018, 0xFFEA, 0x0006, 0x0002, 0xFFED,
    0x0002, 0xFFF3, 0xFFF8, 0xFFE2, 0x0009, 0xFFF0, 0xFFE4, 0xFFCD,
    0x000F, 0xFFED, 0xFFE3, 0x0005, 0x0007, 0x0001, 0x0008, 0x000C,
    0x0019, 0x0004, 0xFFF6, 0xFFDF, 0x000D, 0x000B, 0xFFE6, 0xFFF9,
    0x0005, 0xFFE8, 0x000D, 0x000B, 0xFFFD, 0x000F, 0xFFF8, 0x000B,
    0xFFFF, 0x0010, 0x0006, 0xFFFE, 0x001C, 0x000B, 0xFFF4, 0x0006,
    0xFFFA, 0x0000, 0xFFFF, 0xFFED, 0x000E, 0x0004, 0xFFFF, 0xFFFB,
    0x0011, 0x0020, 0xFFFB, 0x0002, 0xFFFF, 0xFFE5, 0x0029, 0xFFFD,
    0xFFE8, 0xFFEA, 0xFFFE, 0x000B, 0x0013, 0x0013, 0xFFE4, 0xFFF6,
    0x000B, 0xFFFF, 0xFFE9, 0xFFF6, 0x0002, 0x000C, 0x0005, 0xFFFD,
    0xFFF0, 0x0013, 0x000C, 0x0004, 0x0013, 0xFFF2, 0xFFFF, 0xFFDF,
    0xFFEB, 0xFFF4, 0x001C, 0xFFD4, 0x001A, 0x000C, 0xFFF3, 0x0002,
    0xFFE8, 0xFFE3, 0x000F, 0xFFFE, 0xFFF5, 0x0009, 0xFFEC, 0x0010,
    0x002E, 0x0004, 0x000F, 0xFFF6, 0xFFF7, 0x000E, 0xFFF8, 0xFFF0,
    0xFFFD, 0x000A, 0xFFF9, 0xFFF0, 0x000D, 0xFFFC, 0x0010, 0x0004,
    0x0017, 0xFFFC, 0x0007, 0x0011, 0xFFF2, 0x001A, 0xFFEE, 0xFFEF,
    0xFFFF, 0xFFF7, 0xFFF9, 0xFFE9, 0xFFDC, 0xFFFE, 0xFFF0, 0xFFF8,
    0xFFF0, 0x0006, 0xFFD7, 0x0013, 0x000B, 0x0012, 0xFFF9, 0x000F,
    0x0003, 0x0015, 0xFFFE, 0xFFDF, 0xFFFD, 0xFFF3, 0xFFE9, 0xFFDB,
    0x0014, 0xFFE2, 0xFFFD, 0xFFEF, 0x0023, 0x0008, 0xFFFB, 0xFFEA,
    0x001A, 0x001B, 0x001E, 0x000D, 0x0026, 0xFFF0, 0x0011, 0xFFE7,
    0xFFED, 0xFFF8, 0xFFEC, 0x0015, 0x002A, 0xFFED, 0xFFFE, 0xFFF9,
    0xFFEE, 0xFFEF, 0xFFFC, 0xFFF4, 0xFFF1, 0x0006, 0xFFF4, 0x001F,
    0xFFE2, 0x000A, 0x0013, 0xFFE3, 0xFFEA, 0xFFE4, 0xFFE7, 0x001B,
    0x000C, 0x0029, 0xFFEB, 0xFFCB, 0x000C, 0xFFDF, 0x0002, 0xFFEE,
    0xFFED, 0xFFF7, 0xFFF2, 0x0015, 0xFFFB, 0x0009, 0x0001, 0xFFF0,
    0x0005, 0xFFDE, 0xFFDC, 0x0006, 0xFFFA, 0x001E, 0x0025, 0x0008,
    0x0019, 0xFFF4, 0x0008, 0xFFEE, 0x0019, 0x000F, 0x001C, 0xFFE5,
    0xFFFB, 0x0011, 0x0008, 0x001D, 0x0005, 0x0003, 0x000D, 0x0001,
    0x0010, 0xFFF6, 0xFFFE, 0x0006, 0x0024, 0xFFE4, 0xFFF7, 0x0007,
    0x0011, 0xFFF0, 0xFFEB, 0xFFE2, 0xFFF7, 0x0008, 0x0019, 0x0005,
    0x0018, 0xFFF8, 0x0000, 0x0004, 0xFFF8, 0x0005, 0x000B, 0x000F,
    0xFFE8, 0xFFDA, 0xFFF4, 0x001A, 0xFFF2, 0xFFF0, 0xFFEE, 0x0009,
    0x0008, 0x0006, 0x0018, 0x000C, 0x0026, 0x000E, 0x0017, 0x0015,
    0xFFE5, 0x0005, 0xFFFF, 0xFFF8, 0x001A, 0x000C, 0xFFED, 0x0001,
    0x0004, 0x0000, 0x0007, 0xFFF4, 0xFFED, 0x0002, 0x0007, 0x0023,
    0x0005, 0xFFF4, 0xFFF3, 0xFFEE, 0xFFFE, 0x0005, 0x0001, 0xFFF3,
    0xFFFF, 0xFFF3, 0x0025, 0x000B, 0xFFF8, 0x0001, 0xFFFC, 0x0010,
    0xFFEE, 0xFFFE, 0xFFCF, 0xFFE0, 0x0008, 0x0012, 0xFFEE, 0x0004,
    0x0005, 0xFFFE, 0x001E, 0x0020, 0x0000, 0x0014, 0xFFE2, 0xFFFC,
    0xFFFE, 0xFFFB, 0xFFFA, 0x0006, 0xFFF5, 0xFFFF, 0xFFE2, 0x0004,
    0x0006, 0x0014, 0xFFF3, 0x0011, 0xFFFA, 0xFFF3, 0x0011, 0xFFEB,
    0x0005, 0x0012, 0x0001, 0xFFF1, 0xFFE5, 0x000B, 0x0000, 0x0008,
    0x0015, 0x0007, 0xFFE5, 0x000B, 0xFFFF, 0xFFF6, 0x0003, 0xFFDB,
    0x0010, 0x0015, 0xFFF4, 0xFFF8, 0xFFF2, 0x000B, 0xFFEB, 0xFFDE,
    0xFFF9, 0x0016, 0xFFF9, 0x0006, 0xFFF6, 0xFFFD, 0xFFDE, 0x000A,
    0x001A, 0x0013, 0x0012, 0xFFEF, 0x0027, 0xFFFB, 0xFFF7, 0x0016,
    0x0015, 0xFFE9, 0xFFE3, 0xFFF9, 0xFFFC, 0x0018, 0xFFF4, 0x000E,
    0x0003, 0x000F, 0xFFEE, 0xFFEF, 0xFFEF, 0x0016, 0x0001, 0x0008,
    0x0000, 0x0002, 0x0022, 0x000C, 0x0008, 0xFFEC, 0xFFED, 0x0005,
    0xFFE5, 0xFFF8, 0xFFF5, 0xFFE5, 0x002C, 0x000A, 0x001E, 0xFFF6,
    0x0012, 0xFFE9, 0x0005, 0x000B, 0xFFD9, 0x0008, 0xFFF0, 0xFFFC,
    0x0008, 0x0013, 0x0000, 0x000D, 0xFFDA, 0x0005, 0x000A, 0xFFFC,
    0x0018, 0x000F, 0x0010, 0x001B, 0xFFF7, 0x0016, 0x0023, 0xFFEA,
    0xFFC9, 0x0004, 0xFFEF, 0x002D, 0xFFF3, 0x0003, 0x0001, 0x0018,
    0xFFFA, 0x0013, 0x0011, 0x0006, 0x002C, 0xFFFE, 0xFFF8, 0xFFF4,
    0xFFFC, 0x0008, 0x0021, 0xFFFA, 0xFFF0, 0xFFFE, 0x0010, 0xFFE8,
    0xFFE5, 0x0012, 0x0002, 0x000C, 0xFFDD, 0x000E, 0x0001, 0x0013,
    0xFFED, 0x0010, 0xFFFA, 0x0019, 0xFFF9, 0x001B, 0xFFEE, 0xFFD7,
    0xFFEF, 0xFFE2, 0x0018, 0x001F, 0xFFF8, 0xFFF7, 0xFFF6, 0xFFFE,
    0xFFFA, 0x0000, 0xFFEC, 0x0010, 0x000A, 0x0025, 0xFFE8, 0x000B,
    0x0004, 0xFFE1, 0x0008, 0x0001, 0xFFEF, 0x0000, 0x0019, 0xFFF2,
    0x0031, 0x0006, 0xFFFC, 0x0014, 0x0006, 0x0014, 0x0005, 0xFFFB,
    0x0016, 0x0004, 0x0011, 0xFFF1, 0x0012, 0x000B, 0xFFFF, 0xFFF9,
    0xFFEC, 0x0007, 0x0027, 0xFFFE, 0xFFFC, 0x002B, 0xFFF5, 0xFFF4,
    0xFFF3, 0xFFF0, 0xFFF0, 0x001F, 0x0022, 0xFFE7, 0xFFF3, 0x0000,
    0xFFEE, 0x0004, 0xFFF9, 0xFFD6, 0x0012, 0xFFF7, 0x0009, 0x0002,
    0x0017, 0xFFFA, 0x0002, 0xFFF9, 0xFFF9, 0xFFEC, 0xFFFA, 0xFFD4,
    0xFFE1, 0xFFE4, 0x0007, 0x001E, 0xFFF1, 0xFFFE, 0xFFE8, 0xFFED,
    0xFFF9, 0xFFEC, 0x000F, 0xFFE2, 0x000D, 0xFFFC, 0xFFFE, 0xFFF9,
    0x0008, 0xFFE0, 0xFFE6, 0x0007, 0xFFFC, 0xFFE5, 0xFFED, 0xFFF8,
    0xFFF8, 0x000C, 0xFFDD, 0xFFFA, 0x0015, 0x0005, 0xFFD5, 0x0014,
    0xFFF6, 0x000B, 0x0007, 0xFFF9, 0xFFFF, 0xFFF2, 0xFFFC, 0x0001,
    0x0015, 0xFFE3, 0xFFFC, 0x0007, 0xFFFD, 0xFFF5, 0x0011, 0xFFEC,
    0xFFF9, 0x0006, 0xFFE1, 0xFFE8, 0x0008, 0xFFEB, 0x0019, 0xFFEB,
    0x000C, 0xFFF2, 0x000F, 0xFFFE, 0xFFF8, 0xFFF3, 0xFFF6, 0x0008,
    0xFFF2, 0x0010, 0x0016, 0x0008, 0x0011, 0x000C, 0xFFF9, 0x0009,
    0x0005, 0x0013, 0x0004, 0x0014, 0x0015, 0x0005, 0x0004, 0xFFF6,
    0xFFF2, 0x0008, 0x0000, 0xFFFC, 0xFFEC, 0xFFF8, 0xFFFD, 0x0025,
    0xFFFA, 0xFFE7, 0x0004, 0x0000, 0xFFEA, 0xFFDF, 0x0017, 0xFFED,
    0x0008, 0x000F, 0xFFF3, 0xFFF4, 0xFFE9, 0x000F, 0xFFEE, 0xFFF1,
    0x000C, 0xFFE5, 0xFFF5, 0xFFF6, 0xFFF3, 0xFFE2, 0x0016, 0xFFEB,
    0xFFF7, 0xFFFD, 0x000B, 0x000F, 0xFFFC, 0x000A, 0x0001, 0xFFF6,
    0xFFE8, 0x000F, 0x0012, 0xFFFD, 0xFFF8, 0xFFFB, 0x0003, 0x0007,
    0xFFEE, 0xFFFF, 0x0002, 0x0005, 0x001B, 0x000A, 0xFFF7, 0xFFFE,
    0x000B, 0xFFF5, 0x000B, 0xFFFA, 0xFFFF, 0xFFF8, 0xFFED, 0xFFE9,
    0xFFED, 0x0007, 0xFFF9, 0x000D, 0x0021, 0xFFF7, 0xFFF0, 0xFFF6,
    0xFFF7, 0x0003, 0xFFF9, 0xFFF7, 0x0020, 0x0003, 0x000F, 0x000F,
    0x0007, 0x0010, 0xFFFC, 0xFFF7, 0x0025, 0x0000, 0xFFFE, 0xFFE7,
    0xFFF6, 0x0001, 0x000A, 0x0004, 0xFFE4, 0xFFFA, 0xFFEA, 0xFFE5,
    0xFFE7, 0xFFF3, 0x0002, 0x0005, 0x000E, 0xFFFD, 0xFFF6, 0xFFDD,
    0xFFFF, 0x0006, 0x0007, 0xFFF2, 0x0008, 0xFFFF, 0xFFDD, 0xFFE8,
    0x0003, 0xFFEC, 0x0012, 0xFFEA, 0xFFE9, 0x000D, 0x0005, 0xFFFE,
    0x0000, 0x0013, 0x000B, 0xFFFA, 0x0002, 0xFFEE, 0xFFF1, 0x0002,
    0xFFFF, 0xFFF5, 0x0004, 0x0023, 0xFFF4, 0x0026, 0xFFFB, 0xFFF7,
    0xFFD3, 0x001B, 0x0008, 0xFFDA, 0x001B, 0x0015, 0xFFE7, 0xFFF3,
    0xFFF8, 0x0010, 0xFFF9, 0xFFE7, 0xFFFE, 0xFFFF, 0xFFE8, 0xFFEE,
    0x000E, 0x0011, 0xFFFB, 0xFFDD, 0xFFFC, 0x001E, 0xFFED, 0x0001,
    0xFFF3, 0xFFF7, 0x0005, 0xFFFC, 0xFFF2, 0xFFE3, 0xFFF3, 0x001E,
    0xFFFD, 0xFFFE, 0xFFED, 0xFFFB, 0x0007, 0xFFE9, 0xFFF7, 0xFFF3,
    0x000C, 0x0025, 0xFFED, 0x0015, 0x0007, 0xFFFF, 0xFFF8, 0x0013,
    0xFFFA, 0xFFFF, 0xFFEB, 0x0003, 0xFFFF, 0xFFF9, 0xFFE8, 0xFFFF,
    0x0018, 0x0002, 0x0016, 0x0029, 0x0000, 0x000F, 0x001A, 0x0006,
    0x0001, 0xFFFD, 0x0005, 0x0019, 0xFFF0, 0xFFDA, 0xFFEF, 0x0009,
    0xFFF6, 0xFFDD, 0xFFF6, 0xFFCD, 0xFFFC, 0x0003, 0xFFEE, 0x000A,
    0xFFEC, 0x0004, 0xFFFF, 0xFFEF, 0x0005, 0x0022, 0xFFF7, 0xFFED,
    0xFFE5, 0xFFFF, 0xFFF3, 0xFFEE, 0xFFF9, 0x0011, 0xFFFC, 0x0033,
    0xFFF2, 0xFFED, 0xFFF6, 0x0000, 0xFFF5, 0xFFF4, 0x0014, 0xFFF0,
    0x001F, 0x000C, 0xFFF6, 0xFFF8, 0x000E, 0xFFEC, 0x0015, 0x0001,
    0x000A, 0x0003, 0xFFE9, 0xFFFC, 0x000B, 0xFFFB, 0x0018, 0x0018,
    0x0004, 0x0018, 0xFFD8, 0x0000, 0x0004, 0xFFF6, 0x0001, 0x0003,
    0xFFED, 0xFFEF, 0xFFFF, 0xFFE7, 0xFFEF, 0xFFEB, 0x0019, 0x0022,
    0xFFF4, 0x0013, 0xFFD3, 0x0012, 0x001D, 0x0013, 0x000B, 0xFFF9,
    0xFFFD, 0xFFFE, 0x0007, 0xFFFF, 0xFFD3, 0xFFEF, 0xFFD5, 0x001E,
    0xFFF8, 0xFFF6, 0x000A, 0xFFFF, 0xFFEF, 0xFFFE, 0x0010, 0x0027,
    0x000E, 0xFFF1, 0xFFEB, 0xFFF8, 0x000D, 0x0017, 0xFFEF, 0xFFFD,
    0x001D, 0xFFFC, 0x0008, 0xFFE5, 0x0007, 0x003A, 0xFFE2, 0x0016,
    0xFFFF, 0x000E, 0xFFF6, 0x0025, 0x000D, 0xFFF6, 0x0010, 0x0025,
    0xFFEC, 0x0008, 0x0012, 0x0019, 0x000F, 0xFFFC, 0x0004, 0xFFFC,
    0xFFE6, 0xFFFE, 0xFFEE, 0xFFFE, 0x0008, 0xFFEC, 0xFFFE, 0xFFFE,
    0xFFFD, 0xFFF4, 0x0004, 0x0004, 0xFFFB, 0xFFF6, 0x0014, 0x0002,
    0xFFF3, 0x001C, 0xFFEA, 0xFFFE, 0x0006, 0xFFF3, 0xFFF8, 0x000F,
    0xFFF6, 0x0009, 0xFFFB, 0x000C, 0xFFF0, 0xFFF9, 0x0009, 0x000D,
    0x002E, 0xFFFC, 0xFFFB, 0x0016, 0x0006, 0xFFED, 0x0000, 0xFFE8,
    0xFFFB, 0x0019, 0x0002, 0xFFE5, 0x0004, 0x0009, 0xFFFA, 0x0000,
    0xFFFF, 0x0001, 0xFFF6, 0x0008, 0xFFF1, 0x0008, 0x000B, 0xFFF4,
    0x000E, 0x0002, 0x0001, 0x0008, 0x0024, 0x0014, 0xFFF8, 0x0010,
    0x0000, 0x0000, 0x000C, 0xFFFC, 0xFFD9, 0x0009, 0xFFF2, 0x0008,
    0x0003, 0xFFF1, 0x0005, 0xFFED, 0xFFFF, 0x0005, 0xFFDB, 0xFFF1,
    0x001C, 0x0019, 0xFFE6, 0xFFEE, 0x000F, 0x0012, 0x0016, 0xFFE4,
    0x0003, 0xFFDD, 0x0012, 0xFFF0, 0x000D, 0xFFFA, 0xFFDB, 0x0013,
    0x0018, 0x000C, 0x0029, 0xFFE1, 0xFFFD, 0xFFFB, 0xFFEF, 0x0023,
    0xFFFE, 0xFFEB, 0x000A, 0xFFF1, 0x0013, 0x0015, 0xFFD6, 0x000D,
    0xFFFE, 0xFFF8, 0x0023, 0x0006, 0x000F, 0xFFFA, 0x0002, 0x0018,
    0x0015, 0x0006, 0xFFEA, 0xFFF1, 0xFFEA, 0x0012, 0xFFF6, 0x0007,
    0x0005, 0x001B, 0x0006, 0xFFFE, 0xFFE2, 0x0014, 0xFFF6, 0xFFE3,
    0x0005, 0x000B, 0xFFF1, 0xFFFD, 0x0004, 0xFFF9, 0x0006, 0xFFE1,
    0x0010, 0x0014, 0xFFE7, 0xFFED, 0x001B, 0xFFFE, 0x0007, 0xFFFB,
    0xFFFD, 0xFFED, 0x0008, 0xFFFF, 0xFFEE, 0x0001, 0xFFE6, 0xFFE5,
    0x0007, 0xFFED, 0xFFE5, 0x000A, 0x0007, 0xFFE7, 0xFFFA, 0xFFEB,
    0x0013, 0x0016, 0xFFF3, 0xFFEC, 0xFFED, 0xFFF6, 0xFFF6, 0xFFE5,
    0xFFEE, 0x000E, 0xFFDF, 0x000D, 0xFFFF, 0x000B, 0xFFFF, 0x0023,
    0x0013, 0xFFF9, 0xFFFD, 0x0015, 0x000A, 0x0011, 0xFFEE, 0xFFEA,
    0x000E, 0x0011, 0xFFF0, 0x000D, 0xFFF8, 0xFFF0, 0xFFFB, 0x0001,
    0x0009, 0x0006, 0xFFEA, 0xFFFC, 0x0010, 0xFFDC, 0x0012, 0x0002,
    0xFFF0, 0x0006, 0x0008, 0x0006, 0x000F, 0x001B, 0x000A, 0xFFED,
    0x0021, 0x000F, 0xFFF2, 0x0011, 0xFFF3, 0x001B, 0x0005, 0x000E,
    0xFFE5, 0x0016, 0x0016, 0xFFEE, 0x0006, 0xFFFB, 0x001D, 0x0003,
    0x0004, 0xFFF6, 0x002D, 0x000A, 0x0007, 0xFFEE, 0x0015, 0xFFEA,
    0x0003, 0xFFF6, 0xFFE6, 0xFFFB, 0x0009, 0x000F, 0xFFE9, 0x0005,
    0xFFD9, 0xFFF7, 0x0000, 0x0012, 0xFFF9, 0x0006, 0x000F, 0x0017,
    0x0000, 0x0016, 0x0002, 0xFFDD, 0xFFEC, 0xFFF7, 0x0002, 0xFFEF,
    0x000B, 0x000E, 0x0010, 0x0021, 0x0007, 0xFFFB, 0xFFFA, 0x0009,
    0xFFE9, 0xFFFC, 0x0014, 0xFFE9, 0xFFED, 0x0006, 0x000F, 0x0013,
    0x001C, 0xFFF2, 0x000D, 0xFFD3, 0xFFFC, 0xFFEF, 0x0021, 0xFFDC,
    0x000B, 0xFFF0, 0x001F, 0x0018, 0x0007, 0xFFE7, 0xFFEB, 0xFFF7,
    0xFFFD, 0x0012, 0xFFFF, 0xFFF0, 0xFFDB, 0x000E, 0xFFF0, 0xFFF6,
    0xFFF8, 0x0009, 0x000D, 0xFFF9, 0xFFEB, 0x0001, 0x0005, 0xFFF0,
    0xFFFF, 0xFFEE, 0x0008, 0x0015, 0xFFF4, 0xFFFC, 0xFFE2, 0x0003,
    0xFFE9, 0x0000, 0xFFF5, 0xFFEE, 0x0009, 0x0008, 0x0009, 0xFFF3,
    0xFFF4, 0x002A, 0xFFF7, 0xFFF6, 0xFFE6, 0xFFF4, 0x0003, 0x001E,
    0xFFFA, 0x0001, 0x0003, 0x000D, 0x0018, 0x0008, 0x0000, 0xFFE9,
    0x0004, 0x000E, 0xFFF2, 0x0024, 0xFFE1, 0xFFE2, 0xFFF3, 0x0006,
    0xFFFE, 0xFFFF, 0xFFFD, 0xFFE7, 0xFFFA, 0xFFFD, 0xFFFB, 0x000C,
    0xFFF6, 0x0006, 0xFFEB, 0xFFFB, 0xFFF9, 0xFFEF, 0xFFED, 0x000B,
    0x0000, 0x0003, 0x0001, 0x0013, 0xFFF7, 0xFFF3, 0xFFFB, 0xFFF5,
    0x0003, 0xFFDD, 0xFFEE, 0xFFFE, 0xFFEB, 0x001D, 0x0001, 0x0006,
    0x0000, 0x0008, 0xFFEA, 0xFFE1, 0xFFFB, 0x000E, 0x002A, 0xFFFB,
    0xFFF8, 0xFFFD, 0xFFDD, 0xFFF4, 0xFFF9, 0xFFE7, 0xFFEB, 0x0006,
    0xFFFA, 0x0019, 0x0008, 0x0004, 0x0011, 0x0008, 0xFFE6, 0x0014,
    0xFFF5, 0xFFE2, 0xFFF8, 0x0016, 0xFFE7, 0x0010, 0xFFF7, 0xFFF4,
    0xFFEC, 0xFFEC, 0x0001, 0x0005, 0xFFFE, 0x0009, 0x0013, 0x0003,
    0x0005, 0xFFEA, 0x000E, 0xFFF8, 0x000C, 0xFFEC, 0xFFE6, 0xFFFA,
    0x0003, 0xFFDB, 0x000D, 0x0010, 0x0014, 0xFFF2, 0x0016, 0x0003,
    0x0006, 0xFFF6, 0x001E, 0x0006, 0xFFFF, 0xFFDD, 0x0006, 0xFFF4,
    0x0008, 0xFFE0, 0x000C, 0xFFE6, 0x0001, 0x0007, 0xFFFC, 0x001D,
    0x0007, 0x000F, 0xFFF2, 0x0005, 0xFFFB, 0xFFDF, 0x0012, 0x000D,
    0xFFF4, 0x000B, 0x0022, 0x0005, 0xFFF8, 0x000C, 0x0005, 0x0018,
    0x000F, 0x0010, 0xFFEA, 0xFFFE, 0xFFFF, 0x0009, 0xFFF5, 0x000D,
    0xFFEF, 0x0005, 0x002C, 0xFFF4, 0xFFFD, 0xFFF4, 0x0015, 0xFFF8,
    0x0005, 0x0007, 0xFFE8, 0xFFFD, 0xFFF3, 0x0000, 0x0002, 0x0002,
    0x0002, 0x0011, 0x000F, 0x0000, 0x001F, 0x0000, 0xFFE9, 0xFFF1,
    0xFFF9, 0x0021, 0x0006, 0x001C, 0xFFE4, 0xFFFF, 0xFFEF, 0x002C,
    0x0000, 0xFFFB, 0xFFF0, 0xFFF6, 0x0015, 0x000D, 0xFFFD, 0x0007,
    0x0001, 0x000E, 0x000A, 0xFFFF, 0xFFFE, 0xFFF9, 0x0002, 0xFFE2,
    0x0011, 0xFFE8, 0x000C, 0xFFF6, 0xFFFE, 0x0005, 0xFFEC, 0x000B,
    0xFFFE, 0xFFF6, 0xFFEF, 0xFFEF, 0x0001, 0xFFF3, 0x0008, 0xFFFE,
    0xFFF9, 0x000B, 0xFFFC, 0x000A, 0xFFFD, 0x0015, 0xFFF8, 0xFFE2,
    0x0031, 0xFFFA, 0x0002, 0x0000, 0xFFFC, 0x0009, 0x0017, 0x0009,
    0xFFF5, 0xFFDE, 0xFFED, 0xFFF3, 0xFFF5, 0xFFF3, 0xFFF8, 0x0003,
    0x000E, 0xFFFE, 0x0002, 0xFFEB, 0xFFF4, 0xFFF8, 0x000A, 0x0010,
    0x0020, 0xFFEE, 0x001E, 0xFFF8, 0xFFF5, 0x0008, 0x0009, 0x001C,
    0x0000, 0xFFF0, 0xFFE7, 0xFFF7, 0xFFE2, 0xFFEA, 0xFFFA, 0x000C,
    0x0003, 0xFFFF, 0xFFE0, 0x000F, 0xFFF7, 0x0009, 0x0006, 0xFFF1,
    0x0019, 0x0000, 0x0020, 0xFFF0, 0x0008, 0x0004, 0xFFFB, 0xFFE8,
    0x0010, 0xFFEF, 0xFFF7, 0x0000, 0x0001, 0xFFFD, 0xFFF0, 0x000B,
    0x001C, 0xFFEB, 0x0025, 0xFFEC, 0x000E, 0x0013, 0xFFFF, 0xFFF8,
    0xFFFC, 0xFFFE, 0xFFE3, 0x001A, 0xFFF4, 0x0007, 0xFFF9, 0xFFF7,
    0xFFEF, 0x0011, 0xFFF7, 0x000A, 0x000D, 0x000C, 0x001D, 0x0012,
    0x0011, 0xFFF2, 0x000F, 0x000E, 0x0001, 0xFFF9, 0x0012, 0xFFDF,
    0x002D, 0x0008, 0x0005, 0x0007, 0xFFEB, 0xFFE1, 0x0024, 0x000F,
    0xFFF8, 0xFFFC, 0x0015, 0xFFEF, 0xFFED, 0xFFFA, 0xFFDF, 0xFFE4,
    0x0010, 0xFFFC, 0x0017, 0xFFFD, 0x002E, 0x0000, 0xFFE0, 0x0008,
    0xFFE5, 0xFFDB, 0xFFFC, 0x0006, 0x0007, 0x000C, 0x000D, 0xFFF3,
    0xFFEC, 0xFFF8, 0xFFFF, 0x001D, 0xFFFF, 0x001C, 0xFFF0, 0xFFDE,
    0xFFFC, 0x0019, 0xFFCB, 0x001C, 0xFFFE, 0x0005, 0xFFF1, 0x003D,
    0x0015, 0xFFFB, 0x000E, 0xFFEB, 0x0025, 0x0000, 0x0021, 0x0004,
    0x0007, 0xFFEB, 0xFFFB, 0xFFEB, 0x000B, 0x0021, 0x0012, 0x0015,
    0x0020, 0x0015, 0x0009, 0xFFF0, 0x0003, 0xFFFF, 0x0009, 0xFFFF,
    0x0000, 0x000F, 0x001C, 0x0010, 0xFFFE, 0xFFF0, 0x0021, 0xFFFC,
    0xFFED, 0x0012, 0xFFF8, 0xFFEC, 0xFFDC, 0xFFFC, 0x002E, 0x0005,
    0xFFDF, 0x001A, 0xFFE5, 0x000E, 0x0010, 0xFFDD, 0x0017, 0x0001,
    0xFFFF, 0x000C, 0x0010, 0x0005, 0xFFF6, 0x0013, 0xFFF1, 0x000A,
    0xFFFA, 0x0001, 0x0001, 0xFFFD, 0x0002, 0x000B, 0xFFFB, 0x0001,
    0x0026, 0xFFEB, 0x000A, 0xFFF5, 0x0003, 0xFFF9, 0xFFFB, 0x0006,
    0xFFE6, 0xFFE5, 0xFFFC, 0x000E, 0xFFED, 0xFFFF, 0xFFFA, 0x0009,
    0x001F, 0x0007, 0xFFED, 0x0008, 0x000B, 0x0010, 0x0008, 0x0008,
    0xFFEB, 0x001B, 0x0037, 0x0000, 0x0016, 0x0014, 0xFFF8, 0x0000,
    0xFFFC, 0x0009, 0x0005, 0xFFF8, 0xFFFB, 0xFFFE, 0xFFFD, 0xFFF4,
    0xFFFC, 0xFFF2, 0xFFF2, 0x000F, 0x0008, 0xFFE0, 0x0006, 0xFFEF,
    0x000C, 0xFFEF, 0xFFFA, 0xFFF8, 0xFFF6, 0x0009, 0x000F, 0x000A,
    0xFFEF, 0xFFF8, 0xFFCF, 0xFFF6, 0x0001, 0xFFF4, 0xFFE9, 0x0009,
    0xFFF4, 0x0009, 0x000C, 0x0013, 0x0007, 0x0000, 0x001A, 0xFFE7,
    0x0006, 0x000B, 0x0011, 0x0010, 0x000C, 0x0006, 0x0007, 0x0010,
    0xFFF7, 0x000A, 0xFFF7, 0x000B, 0xFFFE, 0xFFDA, 0xFFDC, 0xFFF3,
    0xFFEC, 0x0016, 0x0005, 0x0015, 0xFFF5, 0xFFEF, 0xFFF1, 0x000E,
    0xFFF8, 0xFFF4, 0xFFF9, 0xFFF0, 0xFFF1, 0x0004, 0xFFE9, 0x0003,
    0x0002, 0xFFE8, 0x000E, 0x0004, 0xFFF6, 0x0020, 0x000A, 0x0013,
    0xFFFD, 0xFFF4, 0xFFF7, 0xFFEC, 0x0007, 0xFFFE, 0xFFEB, 0x0006,
    0xFFFD, 0xFFF4, 0xFFEE, 0x000B, 0x0005, 0xFFF1, 0xFFF7, 0xFFF7,
    0x000D, 0xFFEC, 0xFFEA, 0xFFFF, 0xFFFF, 0x000D, 0x0003, 0x000B,
    0xFFDD, 0x001E, 0x0019, 0xFFF0, 0xFFF3, 0xFFFA, 0xFFFD, 0xFFE3,
    0x0000, 0xFFEA, 0xFFEA, 0xFFDC, 0xFFDF, 0x0009, 0xFFED, 0x000C,
    0xFFF5, 0xFFFC, 0x000B, 0x0003, 0xFFF2, 0x001E, 0xFFFB, 0xFFF1,
    0x0012, 0xFFFF, 0xFFF1, 0xFFF0, 0xFFFF, 0xFFE6, 0xFFF3, 0x0015,
    0x0001, 0x0007, 0x0002, 0xFFF4, 0x000B, 0x0021, 0x0016, 0xFFF2,
    0xFFF1, 0xFFEE, 0xFFE3, 0xFFF3, 0xFFEA, 0x0002, 0xFFEC, 0x0001,
    0xFFFE, 0x0009, 0x0004, 0xFFFE, 0xFFE1, 0xFFCE, 0xFFE2, 0x000B,
    0x0005, 0x001F, 0x0000, 0x0005, 0x0022, 0x0000, 0x0018, 0xFFFF,
    0x0012, 0x0018, 0xFFDE, 0xFFFE, 0x000A, 0x0001, 0xFFFA, 0x000A,
    0xFFE8, 0x0017, 0x0026, 0x0015, 0xFFF0, 0xFFF0, 0x0002, 0xFFFC,
    0x0020, 0xFFC8, 0x0008, 0xFFF3, 0x0014, 0x0012, 0xFFFE, 0x0005,
    0x0025, 0x0008, 0xFFD8, 0xFFF8, 0x000A, 0xFFEE, 0x0010, 0x0011,
    0xFFF8, 0x001B, 0x0004, 0xFFFD, 0x0014, 0x0015, 0x000B, 0xFFEF,
    0x0001, 0xFFE9, 0x001A, 0x0001, 0xFFF3, 0x0004, 0x0002, 0x0012,
    0xFFFA, 0x0017, 0xFFF1, 0x0016, 0x000C, 0xFFE5, 0xFFE9, 0x000A,
    0x0006, 0x0006, 0x0007, 0xFFFE, 0xFFF7, 0xFFFC, 0xFFFD, 0xFFFF,
    0xFFE2, 0xFFEB, 0xFFF1, 0x001E, 0xFFEE, 0x0007, 0xFFEB, 0x0009,
    0x0001, 0x0005, 0xFFE8, 0xFFF9, 0xFFF0, 0x0016, 0xFFF0, 0xFFDF,
    0xFFFC, 0x001E, 0xFFEA, 0x0018, 0x0006, 0xFFF1, 0x0006, 0xFFF1,
    0x0006, 0x0005, 0x0009, 0xFFF3, 0x0001, 0xFFF7, 0x001A, 0xFFF1,
    0xFFE2, 0x000F, 0x0008, 0xFFFD, 0x003E, 0xFFFE, 0xFFF1, 0xFFEC,
    0x0006, 0xFFE0, 0x000F, 0xFFF5, 0x0000, 0x0011, 0xFFF2, 0x000A,
    0x0007, 0x0022, 0xFFEE, 0xFFE9, 0x0014, 0xFFDD, 0xFFE8, 0x0015,
    0xFFF2, 0xFFF1, 0x0009, 0xFFFF, 0xFFF7, 0x000D, 0x000E, 0x0009,
    0x000B, 0x0015, 0x0005, 0xFFFD, 0xFFFC, 0xFFEB, 0xFFF1, 0xFFFA,
    0x0003, 0xFFF0, 0x000B, 0x0000, 0xFFFC, 0xFFFE, 0xFFF8, 0xFFD6,
    0xFFFA, 0x000A, 0x0003, 0xFFED, 0x000A, 0x000B, 0x0008, 0x0004,
    0xFFF0, 0x0010, 0x0003, 0x0005, 0x000D, 0xFFF0, 0x0012, 0xFFCA,
    0x0006, 0xFFF3, 0x000E, 0x0019, 0xFFF9, 0x0013, 0xFFFF, 0x0013,
    0x000D, 0x0000, 0xFFF5, 0x0012, 0x000F, 0x0008, 0xFFEB, 0xFFF3,
    0xFFE1, 0xFFFE, 0xFFE3, 0x0011, 0x001D, 0x000C, 0xFFE8, 0x0004,
    0x0002, 0x000B, 0xFFF6, 0x0004, 0x002E, 0x0006, 0xFFFC, 0x0008,
    0x001E, 0xFFFD, 0xFFE3, 0x0012, 0xFFEF, 0xFFF5, 0xFFF2, 0x001B,
    0x0007, 0x0018, 0x0020, 0xFFFB, 0x0002, 0xFFE2, 0xFFE5, 0xFFF3,
    0xFFFF, 0x0006, 0x0008, 0x0010, 0xFFF7, 0x0006, 0x0013, 0xFFF0,
    0xFFF9, 0x0024, 0xFFFA, 0x0009, 0x0004, 0x0006, 0x000E, 0x0005,
    0xFFEE, 0xFFFB, 0x0020, 0x0003, 0x0007, 0x000C, 0xFFE8, 0x0008,
    0xFFFB, 0xFFFD, 0x0016, 0x0005, 0x0000, 0x0005, 0x000B, 0xFFEA,
    0x0000, 0xFFF0, 0x0023, 0xFFE8, 0x001B, 0x0003, 0xFFF2, 0x0032,
    0xFFDD, 0x0007, 0x001B, 0x000C, 0x0010, 0xFFE5, 0xFFFC, 0xFFF6,
    0x0010, 0xFFF0, 0xFFFD, 0x000C, 0x0005, 0x000B, 0xFFFC, 0xFFFA,
    0xFFF0, 0xFFE3, 0xFFE0, 0xFFE5, 0xFFE5, 0x0018, 0x0005, 0x0017,
    0x0011, 0x000B, 0xFFF3, 0x0005, 0xFFED, 0x000B, 0x0010, 0xFFE8,
    0xFFFD, 0x0008, 0x0010, 0xFFF7, 0xFFE9, 0x0002, 0xFFF7, 0x0001,
    0x0013, 0x0004, 0xFFF2, 0x0011, 0x0012, 0x0007, 0xFFF7, 0xFFFC,
    0x0024, 0x000C, 0xFFFF, 0xFFFA, 0xFFF5, 0xFFFF, 0x0003, 0xFFDB,
    0x0025, 0xFFF0, 0x0016, 0xFFF4, 0x0008, 0xFFFF, 0xFFEA, 0xFFEE,
    0x000C, 0x000F, 0x0001, 0xFFF3, 0x0008, 0x0025, 0x000D, 0xFFF7,
    0x0010, 0xFFF3, 0xFFF8, 0x0002, 0xFFFB, 0x000C, 0xFFF0, 0xFFFE,
    0x000D, 0xFFEE, 0x0018, 0x0003, 0xFFF3, 0x0011, 0x0007, 0xFFF1,
    0x0004, 0x000D, 0xFFFE, 0x000A, 0x003C, 0x001B, 0x000D, 0xFFE8,
    0x0019, 0xFFF4, 0xFFFB, 0xFFE8, 0x001E, 0x0010, 0xFFEC, 0xFFF6,
    0x002F, 0xFFF7, 0xFFFD, 0x0019, 0xFFE4, 0x0001, 0x0003, 0x0007,
    0x0009, 0xFFE9, 0xFFEE, 0xFFE5, 0xFFE8, 0x0019, 0x0000, 0x000D,
    0xFFF4, 0xFFF6, 0x0005, 0x000E, 0xFFFB, 0xFFF3, 0x0000, 0xFFFE,
    0xFFF8, 0x0011, 0x0012, 0x001B, 0xFFFA, 0xFFFC, 0x001C, 0xFFE1,
    0xFFF4, 0x000C, 0x0012, 0x0029, 0xFFFD, 0x000C, 0x0005, 0xFFDE,
    0xFFE8, 0xFFF1, 0x0010, 0xFFFB, 0x000A, 0xFFE6, 0x0003, 0xFFEA,
    0xFFF2, 0x001F, 0xFFF3, 0x0008, 0xFFFE, 0x000F, 0x0006, 0xFFF1,
    0xFFF0, 0xFFE5, 0x0003, 0xFFF2, 0xFFF8, 0x0003, 0x0005, 0xFFE8,
    0x0004, 0xFFFA, 0xFFF9, 0x001E, 0x0024, 0xFFFF, 0xFFFB, 0x000E,
    0x0003, 0x0021, 0xFFE9, 0x0000, 0xFFE9, 0x0006, 0xFFD6, 0xFFF6,
    0x0010, 0x0016, 0x0008, 0x000C, 0x0006, 0x000A, 0xFFE0, 0xFFD9,
    0xFFEE, 0xFFF0, 0x000F, 0x000D, 0x0008, 0xFFFE, 0xFFFB, 0x0008,
    0xFFFE, 0xFFF5, 0x0014, 0xFFE1, 0x000A, 0x000A, 0x0004, 0x0019,
    0x0008, 0xFFF3, 0x0014, 0x0001, 0x0009, 0xFFED, 0x0014, 0x0017,
    0xFFF1, 0x000B, 0xFFFF, 0xFFF7, 0x0027, 0x0018, 0xFFFB, 0x0005,
    0x0011, 0xFFFD, 0xFFF1, 0xFFFF, 0x000C, 0x0002, 0x0015, 0xFFFA,
    0xFFE3, 0x000B, 0x0017, 0xFFF8, 0x0013, 0xFFEC, 0xFFF1, 0x0001,
    0xFFF2, 0x0038, 0xFFD7, 0xFFEF, 0xFFDF, 0xFFFF, 0x000D, 0xFFFF,
    0x0000, 0xFFF1, 0xFFE3, 0xFFF9, 0xFFF7, 0xFFEA, 0xFFFB, 0x0000,
    0x0008, 0xFFFF, 0x001E, 0xFFEB, 0x0013, 0x001B, 0x002C, 0xFFF7,
    0x001B, 0xFFEC, 0x0000, 0xFFEB, 0x0000, 0x0021, 0xFFE7, 0xFFE1,
    0x0016, 0xFFF3, 0x0011, 0x0015, 0x0005, 0x0003, 0x0005, 0x0011,
    0x0016, 0xFFF5, 0xFFFA, 0x0005, 0xFFE2, 0xFFEC, 0xFFF4, 0x0018,
    0x0006, 0x0005, 0xFFFA, 0x0008, 0x0009, 0x0023, 0x0013, 0xFFE0,
    0x0000, 0xFFFA, 0x0005, 0xFFFF, 0xFFFE, 0xFFE7, 0xFFEC, 0xFFF1,
    0xFFFA, 0x000B, 0xFFF5, 0x0011, 0x0006, 0xFFF5, 0x0004, 0xFFE4,
    0xFFFF, 0x000B, 0xFFFA, 0x001A, 0xFFE4, 0x0009, 0xFFF2, 0x0001,
    0x000B, 0x000E, 0x000E, 0xFFDB, 0xFFF3, 0x0002, 0x000F, 0x0009,
    0x0008, 0xFFFA, 0x0016, 0x0009, 0x0004, 0xFFF1, 0xFFF0, 0x0008,
    0x000C, 0x000A, 0x000E, 0x000F, 0x0006, 0xFFF4, 0xFFEB, 0x001D,
    0xFFE2, 0xFFEE, 0x000D, 0x0008, 0xFFF7, 0xFFF2, 0x0007, 0x000D,
    0x000D, 0xFFF9, 0x0001, 0x0016, 0xFFF1, 0xFFF9, 0x0001, 0xFFF3,
    0xFFE8, 0xFFFA, 0x000F, 0x0013, 0xFFFE, 0x000D, 0x0005, 0x000D,
    0x0010, 0xFFEA, 0xFFE4, 0x0011, 0xFFE8, 0xFFFC, 0x001A, 0x0014,
    0xFFFF, 0xFFFA, 0x001F, 0x000F, 0xFFFC, 0x0003, 0xFFF7, 0x0002,
    0xFFF6, 0x0015, 0xFFFF, 0xFFFB, 0xFFE8, 0x000D, 0xFFF6, 0x001A,
    0x0008, 0xFFFB, 0x001F, 0xFFD5, 0xFFFC, 0xFFF2, 0xFFF9, 0xFFE8,
    0x000B, 0xFFEF, 0x0023, 0xFFEC, 0xFFFB, 0x0003, 0xFFE7, 0x0009,
    0x0009, 0x0001, 0xFFF5, 0xFFF5, 0x0008, 0x0011, 0x0006, 0xFFE8,
    0x0021, 0xFFF9, 0x002A, 0xFFF4, 0x0009, 0x0001, 0x000F, 0xFFDC,
    0x0004, 0xFFE3, 0x0014, 0x0006, 0xFFF3, 0x0006, 0xFFEB, 0xFFF4,
    0xFFF0, 0xFFEC, 0x0016, 0xFFDF, 0x0000, 0x0007, 0xFFFC, 0x0006,
    0x0014, 0xFFF2, 0x0008, 0x0013, 0x0011, 0xFFF4, 0x0001, 0xFFFB,
    0xFFF7, 0x0016, 0x0004, 0xFFE8, 0xFFF2, 0x000C, 0xFFED, 0xFFDC,
    0xFFE4, 0x0005, 0x0013, 0xFFF2, 0xFFF5, 0x0003, 0xFFFD, 0x0001,
    0xFFEF, 0x001C, 0xFFF4, 0xFFF7, 0xFFF1, 0x0028, 0x0006, 0x0010,
    0x0010, 0x000D, 0x0001, 0xFFFA, 0xFFF2, 0xFFFE, 0xFFE9, 0x0005,
    0xFFEC, 0x0004, 0x0004, 0xFFFF, 0xFFF9, 0xFFF5, 0x001D, 0xFFEF,
    0xFFFF, 0x0025, 0xFFFF, 0xFFF0, 0x0004, 0x0005, 0xFFFF, 0x0009,
    0x000E, 0x0001, 0xFFEC, 0xFFFA, 0xFFFC, 0xFFE4, 0xFFF8, 0xFFFA,
    0x0014, 0xFFEB, 0xFFED, 0x0009, 0xFFDF, 0x0012, 0x0009, 0x0010,
    0x000C, 0xFFE9, 0x0009, 0x0001, 0xFFFC, 0xFFF6, 0xFFF4, 0x001C,
    0x0002, 0x000C, 0xFFF5, 0x000F, 0x001E, 0x0010, 0xFFEE, 0x000A,
    0x0002, 0x0005, 0xFFF1, 0xFFF2, 0x0015, 0x0009, 0xFFFC, 0xFFF8,
    0x000E, 0xFFF4, 0x0000, 0x001B, 0x0006, 0xFFE2, 0x0017, 0xFFF7,
    0x0009, 0x000E, 0xFFF7, 0xFFEF, 0x0004, 0x0008, 0x0012, 0x000C,
    0xFFDC, 0x0008, 0xFFE5, 0x0020, 0x0002, 0xFFE8, 0xFFF0, 0x0006,
    0xFFF8, 0xFFE8, 0xFFFB, 0xFFFC, 0x0006, 0xFFDE, 0xFFEE, 0x0005,
    0x0005, 0xFFF3, 0xFFF2, 0x0016, 0x001A, 0xFFF8, 0x000A, 0xFFFC,
    0x0011, 0x0001, 0x0002, 0x0001, 0xFFEB, 0xFFE7, 0x000A, 0x001C,
    0x0024, 0xFFE9, 0x000B, 0x0002, 0x0012, 0xFFFA, 0xFFEC, 0xFFF8,
    0x0027, 0x0012, 0x0001, 0xFFE8, 0x0004, 0x0002, 0x001C, 0x0009,
    0x0016, 0x0008, 0xFFF5, 0xFFFD, 0x000E, 0xFFFC, 0x0009, 0xFFF4,
    0x0004, 0xFFF4, 0xFFFB, 0xFFFA, 0xFFEE, 0x0001, 0x000E, 0xFFFE,
    0x000F, 0x001A, 0x0012, 0x000E, 0x0011, 0xFFEF, 0xFFF9, 0x0005,
    0xFFFB, 0xFFF1, 0x001B, 0x0003, 0x0005, 0xFFF7, 0x0001, 0x0012,
    0x0003, 0x0003, 0xFFFA, 0xFFE8, 0x0002, 0x0022, 0x000B, 0xFFC8,
    0x0012, 0x0013, 0x0002, 0x0011, 0xFFF4, 0x001A, 0xFFF5, 0x000C,
    0x0007, 0xFFF0, 0x0015, 0x0000, 0x0021, 0xFFEC, 0x0015, 0xFFFB,
    0x000C, 0xFFF4, 0xFFE8, 0x0000, 0x0002, 0xFFFB, 0x0009, 0xFFFA,
    0x0001, 0x000B, 0x000A, 0xFFE9, 0xFFF4, 0xFFF6, 0xFFE2, 0x0015,
    0x0027, 0xFFFF, 0x000F, 0x000C, 0xFFF5, 0xFFEF, 0xFFED, 0xFFF1,
    0x0013, 0xFFF1, 0xFFE4, 0xFFF5, 0x001E, 0xFFE7, 0xFFEA, 0x0011,
    0xFFEA, 0xFFFB, 0x001D, 0x001A, 0xFFFD, 0xFFEE, 0x0008, 0x0006,
    0x000C, 0x0009, 0x0013, 0x000A, 0xFFEB, 0x001C, 0xFFEF, 0x000D,
    0x0000, 0xFFDE, 0xFFF4, 0x000C, 0x0000, 0x0006, 0xFFFF, 0x000D,
    0x001C, 0x0001, 0xFFF7, 0x000F, 0xFFEC, 0x0013, 0xFFEA, 0xFFFD,
    0x000E, 0xFFF3, 0xFFFD, 0x0002, 0x000C, 0x0028, 0x001B, 0x0002,
    0xFFE1, 0x0039, 0xFFEA, 0xFFF6, 0xFFFE, 0x0011, 0x0010, 0x0005,
    0xFFF7, 0xFFF6, 0xFFF8, 0xFFED, 0xFFF4, 0x0004, 0xFFFB, 0x002C,
    0xFFFE, 0xFFF0, 0x0006, 0xFFFD, 0xFFDD, 0x000A, 0xFFFD, 0xFFEF,
    0x0005, 0xFFF5, 0xFFEA, 0xFFDE, 0xFFED, 0x0006, 0xFFFB, 0xFFFF,
    0x001D, 0xFFF0, 0xFFFA, 0xFFF9, 0xFFEB, 0xFFF2, 0x000D, 0x0013,
    0xFFF4, 0xFFCC, 0x0003, 0xFFFF, 0x000E, 0xFFF7, 0xFFFF, 0x0035,
    0xFFEA, 0xFFF8, 0x0008, 0x0005, 0xFFFF, 0x0005, 0x002B, 0x0009,
    0x000E, 0x0009, 0xFFFC, 0x0002, 0xFFEC, 0xFFFC, 0xFFFE, 0xFFEC,
    0xFFF9, 0x0021, 0xFFF5, 0x0007, 0x0002, 0xFFF4, 0xFFFD, 0xFFFD,
    0xFFFC, 0x0014, 0xFFFD, 0x0016, 0xFFE8, 0x0000, 0xFFFF, 0xFFF8,
    0x0011, 0x0005, 0x0005, 0x001F, 0xFFDE, 0xFFD5, 0xFFDF, 0xFFFC,
    0xFFFD, 0xFFF6, 0xFFE5, 0x0005, 0xFFE3, 0x0004, 0x0001, 0x0013,
    0x0002, 0x0003, 0x000C, 0x0011, 0x0002, 0x000B, 0xFFF2, 0xFFE3,
    0x0029, 0xFFFE, 0x0033, 0xFFFC, 0xFFF4, 0xFFDE, 0xFFFF, 0xFFEB,
    0xFFCE, 0x2CC4, 0xFFF5, 0x0015, 0x0000, 0xFFF2, 0x000C, 0x000C,
    0xFFF9, 0x000B, 0x0003, 0xFFFF, 0x000A, 0x0014, 0xFFE8, 0xFFEC,
    0xFFFF, 0x0010, 0xFFF0, 0x0008, 0xFFF3, 0x0022, 0x0013, 0x0005,
    0x001A, 0x000E, 0xFFEB, 0xFFFC, 0xFFED, 0xFFF5, 0xFFFD, 0x000B,
    0xFFE8, 0xFFF3, 0x0021, 0xFFDF, 0x0004, 0x0008, 0x0011, 0xFFEC,
    0x000A, 0xFFFB, 0x0015, 0x0006, 0xFFF2, 0x000A, 0xFFF2, 0x0003,
    0x0009, 0xFFEF, 0x0008, 0x000B, 0xFFEE, 0xFFFB, 0xFFF8, 0xFFFA,
    0x0015, 0x000F, 0x0006, 0xFFFD, 0xFFEF, 0x0008, 0xFFF3, 0xFFE0,
    0xFFEC, 0xFFF9, 0x0001, 0xFFFC, 0xFFF1, 0x000D, 0x0002, 0xFFFA,
    0x0015, 0xFFF1, 0xFFF9, 0x0012, 0xFFE6, 0xFFEE, 0xFFE3, 0xFFF8,
    0x0011, 0x000A, 0x000A, 0xFFF6, 0xFFE1, 0x0014, 0xFFEC, 0x0002,
    0x0018, 0xFFE9, 0x0013, 0xFFF5, 0xFFEC, 0x000E, 0xFFEF, 0x0005,
    0x0010, 0xFFF8, 0xFFEC, 0x0009, 0xFFEB, 0x002E, 0x0001, 0xFFF4,
    0xFFF3, 0x000C, 0xFFEA, 0xFFFC, 0x001F, 0x000A, 0x0012, 0x0024,
    0x0022, 0xFFE6, 0xFFF4, 0x000B, 0x0024, 0xFFFA, 0x0008, 0x001C,
    0x0017, 0x0018, 0xFFFD, 0x0001, 0xFFE8, 0x0030, 0x0003, 0xFFDF,
    0x000C, 0xFFFD, 0x0012, 0xFFED, 0x001F, 0xFFF6, 0x0001, 0x0000,
    0x0012, 0xFFFA, 0xFFF4, 0x0002, 0x0027, 0x0008, 0xFFEA, 0xFFEE,
    0x001D, 0x0006, 0x0010, 0xFFF7, 0x0002, 0xFFF7, 0x0009, 0x001B,
    0xFFE8, 0x0014, 0x002D, 0x0002, 0x0004, 0xFFF1, 0x0014, 0xFFFB,
    0x0008, 0x000F, 0x0017, 0xFFDE, 0xFFFD, 0x001F, 0xFFFF, 0xFFFE,
    0x0000, 0x0006, 0xFFFB, 0x0005, 0x002A, 0xFFE7, 0xFFDD, 0x000F,
    0x0030, 0xFFFE, 0x0026, 0x0002, 0x0003, 0x0031, 0xFFEC, 0x0022,
    0x0001, 0xFFFE, 0xFFF6, 0x0001, 0x0018, 0xFFF6, 0xFFF3, 0x000D,
    0xFFE3, 0x0015, 0x0008, 0xFFFE, 0xFFFB, 0x0003, 0x001F, 0xFFFF,
    0xFFD9, 0xFFF0, 0x0003, 0xFFFF, 0x0008, 0xFFEC, 0xFFEB, 0x0026,
    0xFFF8, 0xFFF5, 0xFFF7, 0x0010, 0xFFE5, 0xFFF1, 0x0016, 0x0003,
    0x0011, 0x003C, 0x0007, 0xFFF5, 0xFFFD, 0x0028, 0xFFFD, 0x0020,
    0x000E, 0xFFDA, 0x0016, 0xFFEA, 0x0009, 0x0001, 0x0014, 0x001F,
    0x0013, 0x001B, 0xFFFF, 0xFFEF, 0xFFF0, 0xFFF2, 0xFFFD, 0x0003,
    0x002A, 0x0019, 0x0013, 0x0006, 0x0006, 0xFFED, 0x0000, 0x0011,
    0xFFFB, 0xFFF1, 0xFFD8, 0x001F, 0xFFE5, 0x001B, 0xFFE8, 0xFFEF,
    0xFFFC, 0x0008, 0xFFF0, 0x0018, 0xFFF7, 0x0007, 0x001D, 0xFFFE,
    0xFFE6, 0xFFDE, 0xFFEF, 0xFFF5, 0xFFE5, 0xFFEB, 0x000A, 0x0009,
    0xFFC4, 0x0013, 0x0009, 0xFFEE, 0x0008, 0x000C, 0xFFF1, 0x0010,
    0xFFF8, 0x0018, 0x000C, 0xFFFA, 0x0004, 0x001E, 0xFFF6, 0x0009,
    0xFFFB, 0x0004, 0xFFF2, 0x000B, 0x0005, 0x0002, 0x0017, 0x0008,
    0xFFFB, 0x000A, 0x0023, 0xFFFB, 0xFFFC, 0x000B, 0x0000, 0x000D,
    0xFFF3, 0xFFF4, 0x000B, 0x0009, 0x0005, 0x0002, 0x0014, 0x000B,
    0xFFFE, 0xFFF7, 0xFFEB, 0xFFFE, 0x0012, 0x0019, 0x0007, 0x0005,
    0x002A, 0x0014, 0xFFFB, 0x0008, 0x000B, 0xFFEC, 0x000D, 0xFFEF,
    0xFFF5, 0x001D, 0x0015, 0x000B, 0xFFFF, 0x0009, 0xFFFD, 0xFFEB,
    0xFFFA, 0xFFE3, 0x000E, 0x0004, 0xFFC6, 0x002D, 0xFFEA, 0xFFEA,
    0xFFEC, 0xFFF5, 0xFFF9, 0xFFFF, 0xFFEA, 0xFFF7, 0xFFF2, 0x001F,
    0x000E, 0x0007, 0xFFF2, 0xFFF6, 0xFFFB, 0xFFFF, 0x001F, 0x0017,
    0x0007, 0xFFF9, 0x0001, 0x001D, 0x0008, 0xFFEC, 0xFFF4, 0x0023,
    0xFFEC, 0xFFF9, 0x0008, 0x0008, 0xFFEB, 0x0013, 0xFFF7, 0xFFF8,
    0xFFF0, 0xFFC7, 0xFFE9, 0xFFEF, 0x000B, 0xFFD3, 0x0008, 0x002D,
    0x000C, 0x0007, 0xFFF4, 0x0009, 0xFFFD, 0x0012, 0xFFE7, 0x0004,
    0xFFDA, 0x000F, 0x000F, 0x0003, 0x0011, 0xFFE6, 0x0012, 0x0018,
    0xFFE7, 0xFFF8, 0x0017, 0xFFEE, 0x0025, 0x0002, 0xFFF5, 0xFFF4,
    0xFFF6, 0x0011, 0x000E, 0x0002, 0x0009, 0x000C, 0xFFEC, 0xFFF9,
    0x0008, 0x0009, 0x0003, 0x0012, 0x0012, 0xFFF7, 0x000A, 0x0008,
    0x0005, 0x0003, 0xFFFF, 0x0003, 0xFFF8, 0xFFE4, 0xFFFE, 0x0006,
    0x000A, 0x0002, 0xFFE9, 0x000F, 0xFFFF, 0xFFF0, 0x0009, 0xFFFD,
    0xFFD7, 0x001E, 0xFFFC, 0x000C, 0x0014, 0x0017, 0xFFFC, 0xFFFC,
    0x0019, 0xFFF5, 0x0010, 0xFFFF, 0xFFF6, 0x001D, 0xFFE0, 0xFFE3,
    0x0002, 0x0018, 0xFFDF, 0x0002, 0xFFFF, 0x000E, 0xFFF4, 0xFFFA,
    0x0009, 0x0003, 0xFFFB, 0xFFE1, 0xFFEC, 0xFFEC, 0x0010, 0x000A,
    0xFFF4, 0xFFF3, 0x0003, 0x001A, 0x0001, 0xFFFA, 0x0006, 0xFFF4,
    0x0002, 0x0006, 0x000F, 0xFFEC, 0x001E, 0xFFE3, 0x000B, 0xFFF6,
    0xFFE1, 0xFFF3, 0xFFCE, 0x0003, 0x0001, 0xFFF3, 0x0008, 0xFFFC,
    0xFFF7, 0x0010, 0xFFFD, 0xFFDF, 0xFFFB, 0xFFF5, 0x000D, 0xFFE2,
    0x0003, 0x001F, 0x001A, 0x0018, 0x001F, 0xFFF8, 0x0023, 0xFFF9,
    0x0006, 0x000A, 0x001A, 0xFFFA, 0x0016, 0x0004, 0xFFF1, 0x0016,
    0x001A, 0xFFF3, 0x0003, 0xFFF7, 0xFFF5, 0x0003, 0x0009, 0x0028,
    0xFFE5, 0xFFF7, 0xFFFD, 0xFFFD, 0x0010, 0xFFED, 0xFFE8, 0x000F,
    0x0008, 0xFFF3, 0x0023, 0xFFEF, 0x0014, 0xFFF1, 0x0029, 0xFFFD,
    0x0018, 0x0009, 0x000E, 0x0015, 0xFFFE, 0x0020, 0xFFE9, 0x000A,
    0xFFED, 0xFFF0, 0x0000, 0x0005, 0xFFED, 0xFFF1, 0x0001, 0xFFF5,
    0xFFEF, 0xFFFC, 0x0007, 0xFFFF, 0x0003, 0x000D, 0xFFFD, 0xFFFC,
    0x0013, 0x0000, 0x0004, 0x0004, 0x000D, 0xFFF2, 0x0005, 0xFFF1,
    0xFFEB, 0xFFF3, 0xFFFC, 0x0011, 0xFFEB, 0x000B, 0x000A, 0xFFE6,
    0x0004, 0xFFF9, 0x0002, 0x001E, 0x0005, 0xFFFF, 0x0005, 0xFFF6,
    0x000B, 0xFFF3, 0x0011, 0xFFDE, 0x0002, 0xFFF8, 0x0000, 0x000B,
    0xFFDA, 0x0001, 0xFFEB, 0xFFF3, 0xFFFE, 0x001C, 0x0004, 0xFFEF,
    0xFFF0, 0x0000, 0xFFEF, 0xFFF3, 0xFFE8, 0xFFF0, 0xFFF6, 0xFFFC,
    0xFFE5, 0x0003, 0x000B, 0xFFFD, 0x0007, 0xFFFA, 0x000D, 0xFFEA,
    0x000C, 0xFFE6, 0x0011, 0x0023, 0x0000, 0x0015, 0x0000, 0xFFFC,
    0xFFFA, 0x0014, 0xFFE2, 0xFFEE, 0x0002, 0x0010, 0x0019, 0x0003,
    0xFFE5, 0xFFE4, 0xFFEA, 0xFFEF, 0xFFEE, 0x0009, 0x000D, 0xFFEC,
    0x0017, 0xFFEC, 0xFFF3, 0x0000, 0xFFFE, 0xFFF0, 0xFFFB, 0x0006,
    0x0013, 0xFFEF, 0x000C, 0x001B, 0xFFF6, 0xFFD3, 0xFFF8, 0x0000,
    0x001D, 0xFFEF, 0x0009, 0xFFF2, 0xFFFF, 0xFFDD, 0x0005, 0x0012,
    0xFFF1, 0xFFF5, 0xFFF6, 0xFFF9, 0xFFE6, 0x0014, 0x0003, 0x0011,
    0x000A, 0x000F, 0x0000, 0x0008, 0x0000, 0xFFE6, 0xFFE5, 0x0000,
    0x000A, 0x000B, 0x0009, 0xFFEF, 0xFFF6, 0x0006, 0xFFEC, 0x0008,
    0xFFFE, 0x0004, 0x0030, 0x0003, 0xFFF0, 0xFFF2, 0x0009, 0x001C,
    0x000F, 0xFFFC, 0xFFF5, 0xFFF0, 0xFFF5, 0x0009, 0x0018, 0x0012,
    0x0006, 0x000C, 0xFFFF, 0xFFF9, 0xFFE4, 0xFFEB, 0x0004, 0xFFFF,
    0xFFF7, 0xFFFC, 0x001F, 0x0009, 0xFFFF, 0xFFED, 0x0007, 0x000D,
    0x0005, 0x0003, 0x0000, 0x0007, 0x0007, 0xFFF4, 0x0008, 0xFFFE,
    0xFFFE, 0xFFF4, 0x0011, 0x0001, 0x000B, 0xFFFF, 0xFFF8, 0x000B,
    0x0002, 0x0015, 0x001F, 0x000B, 0xFFDE, 0x002C, 0xFFFA, 0xFFEC,
    0x0027, 0x0014, 0xFFF6, 0x0008, 0xFFF6, 0xFFEB, 0x0019, 0x0012,
    0xFFDD, 0xFFFD, 0x0005, 0x0016, 0x0001, 0x000A, 0x000B, 0x0001,
    0x0007, 0x0020, 0xFFEF, 0x0006, 0xFFFC, 0xFFF0, 0xFFF2, 0xFFDA,
    0x0001, 0xFFF8, 0xFFFE, 0xFFFC, 0xFFFC, 0xFFED, 0xFFF6, 0xFFE3,
    0xFFE1, 0x0005, 0x0005, 0x0005, 0x000F, 0x001F, 0xFFEC, 0xFFE0,
    0xFFEE, 0x0008, 0xFFEE, 0xFFE7, 0xFFF1, 0xFFFB, 0x0010, 0xFFD4,
    0xFFFC, 0xFFF0, 0x0018, 0x0001, 0x000C, 0x001B, 0xFFE2, 0xFFEE,
    0xFFEC, 0xFFFA, 0xFFF2, 0xFFFC, 0xFFE9, 0xFFC9, 0x000E, 0x002F,
    0xFFFE, 0x0009, 0xFFE6, 0xFFE7, 0x000B, 0xFFEF, 0xFFE9, 0xFFEF,
    0xFFE9, 0x0002, 0xFFFC, 0xFFFE, 0xFFEF, 0x000D, 0x000F, 0xFFF1,
    0x0001, 0x0009, 0xFFF6, 0xFFF0, 0xFFEA, 0xFFF3, 0x0002, 0x0010,
    0x0019, 0x000B, 0xFFF0, 0xFFD4, 0x0007, 0xFFE8, 0x0001, 0xFFE1,
    0x0009, 0xFFFE, 0xFFF4, 0xFFFB, 0xFFF6, 0x0015, 0x0008, 0xFFFD,
    0xFFEE, 0xFFED, 0x0019, 0xFFED, 0xFFD8, 0x0022, 0x000D, 0xFFE8,
    0x000C, 0xFFF5, 0xFFFA, 0xFFEA, 0xFFEC, 0x0004, 0x0008, 0x0007,
    0x0001, 0x0013, 0x0013, 0xFFEA, 0x0005, 0x000E, 0x000C, 0xFFFB,
    0x0004, 0x0019, 0xFFE3, 0xFFFD, 0x001E, 0x0000, 0xFFF3, 0xFFFE,
    0xFFD0, 0x000B, 0x0015, 0xFFE7, 0xFFF1, 0xFFF8, 0xFFF9, 0x0008,
    0x001B, 0x0001, 0xFFEB, 0x0002, 0x0011, 0x0012, 0xFFF5, 0x000E,
    0xFFF9, 0xFFEF, 0xFFEA, 0xFFFB, 0x000F, 0x001E, 0x0007, 0xFFFA,
    0xFFFC, 0x0009, 0xFFF7, 0xFFF7, 0xFFEA, 0x0001, 0x0024, 0xFFFE,
    0x001B, 0xFFF8, 0x0001, 0x0005, 0x0009, 0xFFF3, 0xFFF6, 0xFFFF,
    0xFFFE, 0xFFFB, 0xFFEB, 0xFFE9, 0xFFE5, 0x0003, 0xFFEA, 0xFFFE,
    0x0000, 0xFFEA, 0x0007, 0x0006, 0x0003, 0x000D, 0xFFFD, 0xFFFD,
    0xFFF0, 0xFFF4, 0x0001, 0xFFF9, 0x0017, 0x000F, 0x0002, 0xFFFE,
    0xFFFA, 0x000A, 0xFFFC, 0x0015, 0x000F, 0xFFE5, 0xFFEA, 0xFFEA,
    0x0006, 0xFFF0, 0x000A, 0x0008, 0xFFFE, 0x0003, 0x000A, 0x0015,
    0x000F, 0x0012, 0xFFFA, 0x000F, 0x0020, 0xFFF9, 0x001D, 0x0020,
    0x0011, 0xFFED, 0xFFF7, 0x0016, 0x0010, 0x0001, 0x0007, 0xFFFA,
    0x0010, 0xFFEB, 0xFFF9, 0x0016, 0x0005, 0xFFF6, 0xFFF7, 0xFFF8,
    0xFFEE, 0x0006, 0x0002, 0xFFE5, 0xFFDB, 0xFFFA, 0x0009, 0xFFFF,
    0x001B, 0x0022, 0x0015, 0xFFE6, 0xFFF9, 0x0007, 0xFFE2, 0x0003,
    0x000C, 0x0014, 0xFFFC, 0x0007, 0xFFEB, 0xFFFE, 0xFFF5, 0x000D,
    0xFFE8, 0x0015, 0x000D, 0x0007, 0xFFFC, 0x000A, 0xFFE9, 0xFFE4
    };

static const q15_t in_cfft_step_16[32] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000
    };

static const q15_t in_cifft_step_16[32] = {
    0x399A, 0x0000, 0xF8CD, 0x2432, 0x0000, 0x0000, 0xF8CD, 0x0AC7,
    0x0000, 0x0000, 0xF8CD, 0x04D0, 0x0000, 0x0000, 0xF8CD, 0x016F,
    0x0000, 0x0000, 0xF8CD, 0xFE91, 0x0000, 0x0000, 0xF8CD, 0xFB30,
    0x0000, 0x0000, 0xF8CD, 0xF539, 0x0000, 0x0000, 0xF8CD, 0xDBCE
    };

static const q15_t ref_cfft_step_16[32] = {
    0x399A, 0x0000, 0xF8CD, 0x2432, 0x0000, 0x0000, 0xF8CD, 0x0AC7,
    0x0000, 0x0000, 0xF8CD, 0x04D0, 0x0000, 0x0000, 0xF8CD, 0x016F,
    0x0000, 0x0000, 0xF8CD, 0xFE91, 0x0000, 0x0000, 0xF8CD, 0xFB30,
    0x0000, 0x0000, 0xF8CD, 0xF539, 0x0000, 0x0000, 0xF8CD, 0xDBCE
    };

static const q15_t in_cfft_step_32[64] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000
    };

static const q15_t in_cifft_step_32[64] = {
    0x399A, 0x0000, 0xFC66, 0x248D, 0x0000, 0x0000, 0xFC66, 0x0BDE,
    0x0000, 0x0000, 0xFC66, 0x06BC, 0x0000, 0x0000, 0xFC66, 0x0463,
    0x0000, 0x0000, 0xFC66, 0x02F4, 0x0000, 0x0000, 0xFC66, 0x01ED,
    0x0000, 0x0000, 0xFC66, 0x0118, 0x0000, 0x0000, 0xFC66, 0x005B,
    0x0000, 0x0000, 0xFC66, 0xFFA5, 0x0000, 0x0000, 0xFC66, 0xFEE8,
    0x0000, 0x0000, 0xFC66, 0xFE13, 0x0000, 0x0000, 0xFC66, 0xFD0C,
    0x0000, 0x0000, 0xFC66, 0xFB9D, 0x0000, 0x0000, 0xFC66, 0xF944,
    0x0000, 0x0000, 0xFC66, 0xF422, 0x0000, 0x0000, 0xFC66, 0xDB73
    };

static const q15_t ref_cfft_step_32[64] = {
    0x399A, 0x0000, 0xFC66, 0x248D, 0x0000, 0x0000, 0xFC66, 0x0BDE,
    0x0000, 0x0000, 0xFC66, 0x06BC, 0x0000, 0x0000, 0xFC66, 0x0463,
    0x0000, 0x0000, 0xFC66, 0x02F4, 0x0000, 0x0000, 0xFC66, 0x01ED,
    0x0000, 0x0000, 0xFC66, 0x0118, 0x0000, 0x0000, 0xFC66, 0x005B,
    0x0000, 0x0000, 0xFC66, 0xFFA5, 0x0000, 0x0000, 0xFC66, 0xFEE8,
    0x0000, 0x0000, 0xFC66, 0xFE13, 0x0000, 0x0000, 0xFC66, 0xFD0C,
    0x0000, 0x0000, 0xFC66, 0xFB9D, 0x0000, 0x0000, 0xFC66, 0xF944,
    0x0000, 0x0000, 0xFC66, 0xF422, 0x0000, 0x0000, 0xFC66, 0xDB73
    };

static const q15_t in_cfft_step_64[128] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000
    };

static const q15_t in_cifft_step_64[128] = {
    0x399A, 0x0000, 0xFE33, 0x24A4, 0x0000, 0x0000, 0xFE33, 0x0C22,
    0x0000, 0x0000, 0xFE33, 0x0730, 0x0000, 0x0000, 0xFE33, 0x0508,
    0x0000, 0x0000, 0xFE33, 0x03CE, 0x0000, 0x0000, 0xFE33, 0x0301,
    0x0000, 0x0000, 0xFE33, 0x026D, 0x0000, 0x0000, 0xFE33, 0x01FC,
    0x0000, 0x0000, 0xFE33, 0x01A2, 0x0000, 0x0000, 0xFE33, 0x0156,
    0x0000, 0x0000, 0xFE33, 0x0114, 0x0000, 0x0000, 0xFE33, 0x00DA,
    0x0000, 0x0000, 0xFE33, 0x00A5, 0x0000, 0x0000, 0xFE33, 0x0073,
    0x0000, 0x0000, 0xFE33, 0x0044, 0x0000, 0x0000, 0xFE33, 0x0017,
    0x0000, 0x0000, 0xFE33, 0xFFE9, 0x0000, 0x0000, 0xFE33, 0xFFBC,
    0x0000, 0x0000, 0xFE33, 0xFF8D, 0x0000, 0x0000, 0xFE33, 0xFF5B,
    0x0000, 0x0000, 0xFE33, 0xFF26, 0x0000, 0x0000, 0xFE33, 0xFEEC,
    0x0000, 0x0000, 0xFE33, 0xFEAA, 0x0000, 0x0000, 0xFE33, 0xFE5E,
    0x0000, 0x0000, 0xFE33, 0xFE04, 0x0000, 0x0000, 0xFE33, 0xFD93,
    0x0000, 0x0000, 0xFE33, 0xFCFF, 0x0000, 0x0000, 0xFE33, 0xFC32,
    0x0000, 0x0000, 0xFE33, 0xFAF8, 0x0000, 0x0000, 0xFE33, 0xF8D0,
    0x0000, 0x0000, 0xFE33, 0xF3DE, 0x0000, 0x0000, 0xFE33, 0xDB5C
    };

static const q15_t ref_cfft_step_64[128] = {
    0x399A, 0x0000, 0xFE33, 0x24A4, 0x0000, 0x0000, 0xFE33, 0x0C22,
    0x0000, 0x0000, 0xFE33, 0x0730, 0x0000, 0x0000, 0xFE33, 0x0508,
    0x0000, 0x0000, 0xFE33, 0x03CE, 0x0000, 0x0000, 0xFE33, 0x0301,
    0x0000, 0x0000, 0xFE33, 0x026D, 0x0000, 0x0000, 0xFE33, 0x01FC,
    0x0000, 0x0000, 0xFE33, 0x01A2, 0x0000, 0x0000, 0xFE33, 0x0156,
    0x0000, 0x0000, 0xFE33, 0x0114, 0x0000, 0x0000, 0xFE33, 0x00DA,
    0x0000, 0x0000, 0xFE33, 0x00A5, 0x0000, 0x0000, 0xFE33, 0x0073,
    0x0000, 0x0000, 0xFE33, 0x0044, 0x0000, 0x0000, 0xFE33, 0x0017,
    0x0000, 0x0000, 0xFE33, 0xFFE9, 0x0000, 0x0000, 0xFE33, 0xFFBC,
    0x0000, 0x0000, 0xFE33, 0xFF8D, 0x0000, 0x0000, 0xFE33, 0xFF5B,
    0x0000, 0x0000, 0xFE33, 0xFF26, 0x0000, 0x0000, 0xFE33, 0xFEEC,
    0x0000, 0x0000, 0xFE33, 0xFEAA, 0x0000, 0x0000, 0xFE33, 0xFE5E,
    0x0000, 0x0000, 0xFE33, 0xFE04, 0x0000, 0x0000, 0xFE33, 0xFD93,
    0x0000, 0x0000, 0xFE33, 0xFCFF, 0x0000, 0x0000, 0xFE33, 0xFC32,
    0x0000, 0x0000, 0xFE33, 0xFAF8, 0x0000, 0x0000, 0xFE33, 0xF8D0,
    0x0000, 0x0000, 0xFE33, 0xF3DE, 0x0000, 0x0000, 0xFE33, 0xDB5C
    };

static const q15_t in_cfft_step_128[256] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000
    };

static const q15_t in_cifft_step_128[256] = {
    0x399A, 0x0000, 0xFF1A, 0x24A9, 0x0000, 0x0000, 0xFF1A, 0x0C33,
    0x0000, 0x0000, 0xFF1A, 0x074C, 0x0000, 0x0000, 0xFF1A, 0x0530,
    0x0000, 0x0000, 0xFF1A, 0x0402, 0x0000, 0x0000, 0xFF1A, 0x0341,
    0x0000, 0x0000, 0xFF1A, 0x02B9, 0x0000, 0x0000, 0xFF1A, 0x0255,
    0x0000, 0x0000, 0xFF1A, 0x0208, 0x0000, 0x0000, 0xFF1A, 0x01CA,
    0x0000, 0x0000, 0xFF1A, 0x0197, 0x0000, 0x0000, 0xFF1A, 0x016C,
    0x0000, 0x0000, 0xFF1A, 0x0147, 0x0000, 0x0000, 0xFF1A, 0x0127,
    0x0000, 0x0000, 0xFF1A, 0x010B, 0x0000, 0x0000, 0xFF1A, 0x00F2,
    0x0000, 0x0000, 0xFF1A, 0x00DB, 0x0000, 0x0000, 0xFF1A, 0x00C7,
    0x0000, 0x0000, 0xFF1A, 0x00B4, 0x0000, 0x0000, 0xFF1A, 0x00A2,
    0x0000, 0x0000, 0xFF1A, 0x0092, 0x0000, 0x0000, 0xFF1A, 0x0083,
    0x0000, 0x0000, 0xFF1A, 0x0074, 0x0000, 0x0000, 0xFF1A, 0x0066,
    0x0000, 0x0000, 0xFF1A, 0x0059, 0x0000, 0x0000, 0xFF1A, 0x004C,
    0x0000, 0x0000, 0xFF1A, 0x0040, 0x0000, 0x0000, 0xFF1A, 0x0034,
    0x0000, 0x0000, 0xFF1A, 0x0028, 0x0000, 0x0000, 0xFF1A, 0x001C,
    0x0000, 0x0000, 0xFF1A, 0x0011, 0x0000, 0x0000, 0xFF1A, 0x0006,
    0x0000, 0x0000, 0xFF1A, 0xFFFA, 0x0000, 0x0000, 0xFF1A, 0xFFEF,
    0x0000, 0x0000, 0xFF1A, 0xFFE4, 0x0000, 0x0000, 0xFF1A, 0xFFD8,
    0x0000, 0x0000, 0xFF1A, 0xFFCC, 0x0000, 0x0000, 0xFF1A, 0xFFC0,
    0x0000, 0x0000, 0xFF1A, 0xFFB4, 0x0000, 0x0000, 0xFF1A, 0xFFA7,
    0x0000, 0x0000, 0xFF1A, 0xFF9A, 0x0000, 0x0000, 0xFF1A, 0xFF8C,
    0x0000, 0x0000, 0xFF1A, 0xFF7D, 0x0000, 0x0000, 0xFF1A, 0xFF6E,
    0x0000, 0x0000, 0xFF1A, 0xFF5E, 0x0000, 0x0000, 0xFF1A, 0xFF4C,
    0x0000, 0x0000, 0xFF1A, 0xFF39, 0x0000, 0x0000, 0xFF1A, 0xFF25,
    0x0000, 0x0000, 0xFF1A, 0xFF0E, 0x0000, 0x0000, 0xFF1A, 0xFEF5,
    0x0000, 0x0000, 0xFF1A, 0xFED9, 0x0000, 0x0000, 0xFF1A, 0xFEB9,
    0x0000, 0x0000, 0xFF1A, 0xFE94, 0x0000, 0x0000, 0xFF1A, 0xFE69,
    0x0000, 0x0000, 0xFF1A, 0xFE36, 0x0000, 0x0000, 0xFF1A, 0xFDF8,
    0x0000, 0x0000, 0xFF1A, 0xFDAB, 0x0000, 0x0000, 0xFF1A, 0xFD47,
    0x0000, 0x0000, 0xFF1A, 0xFCBF, 0x0000, 0x0000, 0xFF1A, 0xFBFE,
    0x0000, 0x0000, 0xFF1A, 0xFAD0, 0x0000, 0x0000, 0xFF1A, 0xF8B4,
    0x0000, 0x0000, 0xFF1A, 0xF3CD, 0x0000, 0x0000, 0xFF1A, 0xDB57
    };

static const q15_t ref_cfft_step_128[256] = {
    0x399A, 0x0000, 0xFF1A, 0x24A9, 0x0000, 0x0000, 0xFF1A, 0x0C33,
    0x0000, 0x0000, 0xFF1A, 0x074C, 0x0000, 0x0000, 0xFF1A, 0x0530,
    0x0000, 0x0000, 0xFF1A, 0x0402, 0x0000, 0x0000, 0xFF1A, 0x0341,
    0x0000, 0x0000, 0xFF1A, 0x02B9, 0x0000, 0x0000, 0xFF1A, 0x0255,
    0x0000, 0x0000, 0xFF1A, 0x0208, 0x0000, 0x0000, 0xFF1A, 0x01CA,
    0x0000, 0x0000, 0xFF1A, 0x0197, 0x0000, 0x0000, 0xFF1A, 0x016C,
    0x0000, 0x0000, 0xFF1A, 0x0147, 0x0000, 0x0000, 0xFF1A, 0x0127,
    0x0000, 0x0000, 0xFF1A, 0x010B, 0x0000, 0x0000, 0xFF1A, 0x00F2,
    0x0000, 0x0000, 0xFF1A, 0x00DB, 0x0000, 0x0000, 0xFF1A, 0x00C7,
    0x0000, 0x0000, 0xFF1A, 0x00B4, 0x0000, 0x0000, 0xFF1A, 0x00A2,
    0x0000, 0x0000, 0xFF1A, 0x0092, 0x0000, 0x0000, 0xFF1A, 0x0083,
    0x0000, 0x0000, 0xFF1A, 0x0074, 0x0000, 0x0000, 0xFF1A, 0x0066,
    0x0000, 0x0000, 0xFF1A, 0x0059, 0x0000, 0x0000, 0xFF1A, 0x004C,
    0x0000, 0x0000, 0xFF1A, 0x0040, 0x0000, 0x0000, 0xFF1A, 0x0034,
    0x0000, 0x0000, 0xFF1A, 0x0028, 0x0000, 0x0000, 0xFF1A, 0x001C,
    0x0000, 0x0000, 0xFF1A, 0x0011, 0x0000, 0x0000, 0xFF1A, 0x0006,
    0x0000, 0x0000, 0xFF1A, 0xFFFA, 0x0000, 0x0000, 0xFF1A, 0xFFEF,
    0x0000, 0x0000, 0xFF1A, 0xFFE4, 0x0000, 0x0000, 0xFF1A, 0xFFD8,
    0x0000, 0x0000, 0xFF1A, 0xFFCC, 0x0000, 0x0000, 0xFF1A, 0xFFC0,
    0x0000, 0x0000, 0xFF1A, 0xFFB4, 0x0000, 0x0000, 0xFF1A, 0xFFA7,
    0x0000, 0x0000, 0xFF1A, 0xFF9A, 0x0000, 0x0000, 0xFF1A, 0xFF8C,
    0x0000, 0x0000, 0xFF1A, 0xFF7D, 0x0000, 0x0000, 0xFF1A, 0xFF6E,
    0x0000, 0x0000, 0xFF1A, 0xFF5E, 0x0000, 0x0000, 0xFF1A, 0xFF4C,
    0x0000, 0x0000, 0xFF1A, 0xFF39, 0x0000, 0x0000, 0xFF1A, 0xFF25,
    0x0000, 0x0000, 0xFF1A, 0xFF0E, 0x0000, 0x0000, 0xFF1A, 0xFEF5,
    0x0000, 0x0000, 0xFF1A, 0xFED9, 0x0000, 0x0000, 0xFF1A, 0xFEB9,
    0x0000, 0x0000, 0xFF1A, 0xFE94, 0x0000, 0x0000, 0xFF1A, 0xFE69,
    0x0000, 0x0000, 0xFF1A, 0xFE36, 0x0000, 0x0000, 0xFF1A, 0xFDF8,
    0x0000, 0x0000, 0xFF1A, 0xFDAB, 0x0000, 0x0000, 0xFF1A, 0xFD47,
    0x0000, 0x0000, 0xFF1A, 0xFCBF, 0x0000, 0x0000, 0xFF1A, 0xFBFE,
    0x0000, 0x0000, 0xFF1A, 0xFAD0, 0x0000, 0x0000, 0xFF1A, 0xF8B4,
    0x0000, 0x0000, 0xFF1A, 0xF3CD, 0x0000, 0x0000, 0xFF1A, 0xDB57
    };

static const q15_t in_cfft_step_256[512] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000
    };

static const q15_t in_cifft_step_256[512] = {
    0x399A, 0x0000, 0xFF8D, 0x24AB, 0x0000, 0x0000, 0xFF8D, 0x0C38,
    0x0000, 0x0000, 0xFF8D, 0x0753, 0x0000, 0x0000, 0xFF8D, 0x053A,
    0x0000, 0x0000, 0xFF8D, 0x040F, 0x0000, 0x0000, 0xFF8D, 0x0350,
    0x0000, 0x0000, 0xFF8D, 0x02CC, 0x0000, 0x0000, 0xFF8D, 0x026B,
    0x0000, 0x0000, 0xFF8D, 0x0220, 0x0000, 0x0000, 0xFF8D, 0x01E5,
    0x0000, 0x0000, 0xFF8D, 0x01B5, 0x0000, 0x0000, 0xFF8D, 0x018D,
    0x0000, 0x0000, 0xFF8D, 0x016C, 0x0000, 0x0000, 0xFF8D, 0x014F,
    0x0000, 0x0000, 0xFF8D, 0x0136, 0x0000, 0x0000, 0xFF8D, 0x0120,
    0x0000, 0x0000, 0xFF8D, 0x010D, 0x0000, 0x0000, 0xFF8D, 0x00FC,
    0x0000, 0x0000, 0xFF8D, 0x00EC, 0x0000, 0x0000, 0xFF8D, 0x00DE,
    0x0000, 0x0000, 0xFF8D, 0x00D1, 0x0000, 0x0000, 0xFF8D, 0x00C6,
    0x0000, 0x0000, 0xFF8D, 0x00BB, 0x0000, 0x0000, 0xFF8D, 0x00B1,
    0x0000, 0x0000, 0xFF8D, 0x00A8, 0x0000, 0x0000, 0xFF8D, 0x009F,
    0x0000, 0x0000, 0xFF8D, 0x0097, 0x0000, 0x0000, 0xFF8D, 0x0090,
    0x0000, 0x0000, 0xFF8D, 0x0089, 0x0000, 0x0000, 0xFF8D, 0x0082,
    0x0000, 0x0000, 0xFF8D, 0x007C, 0x0000, 0x0000, 0xFF8D, 0x0076,
    0x0000, 0x0000, 0xFF8D, 0x0070, 0x0000, 0x0000, 0xFF8D, 0x006B,
    0x0000, 0x0000, 0xFF8D, 0x0066, 0x0000, 0x0000, 0xFF8D, 0x0061,
    0x0000, 0x0000, 0xFF8D, 0x005C, 0x0000, 0x0000, 0xFF8D, 0x0058,
    0x0000, 0x0000, 0xFF8D, 0x0053, 0x0000, 0x0000, 0xFF8D, 0x004F,
    0x0000, 0x0000, 0xFF8D, 0x004B, 0x0000, 0x0000, 0xFF8D, 0x0047,
    0x0000, 0x0000, 0xFF8D, 0x0043, 0x0000, 0x0000, 0xFF8D, 0x003F,
    0x0000, 0x0000, 0xFF8D, 0x003C, 0x0000, 0x0000, 0xFF8D, 0x0038,
    0x0000, 0x0000, 0xFF8D, 0x0035, 0x0000, 0x0000, 0xFF8D, 0x0031,
    0x0000, 0x0000, 0xFF8D, 0x002E, 0x0000, 0x0000, 0xFF8D, 0x002B,
    0x0000, 0x0000, 0xFF8D, 0x0028, 0x0000, 0x0000, 0xFF8D, 0x0024,
    0x0000, 0x0000, 0xFF8D, 0x0021, 0x0000, 0x0000, 0xFF8D, 0x001E,
    0x0000, 0x0000, 0xFF8D, 0x001B, 0x0000, 0x0000, 0xFF8D, 0x0018,
    0x0000, 0x0000, 0xFF8D, 0x0015, 0x0000, 0x0000, 0xFF8D, 0x0013,
    0x0000, 0x0000, 0xFF8D, 0x0010, 0x0000, 0x0000, 0xFF8D, 0x000D,
    0x0000, 0x0000, 0xFF8D, 0x000A, 0x0000, 0x0000, 0xFF8D, 0x0007,
    0x0000, 0x0000, 0xFF8D, 0x0004, 0x0000, 0x0000, 0xFF8D, 0x0001,
    0x0000, 0x0000, 0xFF8D, 0xFFFF, 0x0000, 0x0000, 0xFF8D, 0xFFFC,
    0x0000, 0x0000, 0xFF8D, 0xFFF9, 0x0000, 0x0000, 0xFF8D, 0xFFF6,
    0x0000, 0x0000, 0xFF8D, 0xFFF3, 0x0000, 0x0000, 0xFF8D, 0xFFF0,
    0x0000, 0x0000, 0xFF8D, 0xFFED, 0x0000, 0x0000, 0xFF8D, 0xFFEB,
    0x0000, 0x0000, 0xFF8D, 0xFFE8, 0x0000, 0x0000, 0xFF8D, 0xFFE5,
    0x0000, 0x0000, 0xFF8D, 0xFFE2, 0x0000, 0x0000, 0xFF8D, 0xFFDF,
    0x0000, 0x0000, 0xFF8D, 0xFFDC, 0x0000, 0x0000, 0xFF8D, 0xFFD8,
    0x0000, 0x0000, 0xFF8D, 0xFFD5, 0x0000, 0x0000, 0xFF8D, 0xFFD2,
    0x0000, 0x0000, 0xFF8D, 0xFFCF, 0x0000, 0x0000, 0xFF8D, 0xFFCB,
    0x0000, 0x0000, 0xFF8D, 0xFFC8, 0x0000, 0x0000, 0xFF8D, 0xFFC4,
    0x0000, 0x0000, 0xFF8D, 0xFFC1, 0x0000, 0x0000, 0xFF8D, 0xFFBD,
    0x0000, 0x0000, 0xFF8D, 0xFFB9, 0x0000, 0x0000, 0xFF8D, 0xFFB5,
    0x0000, 0x0000, 0xFF8D, 0xFFB1, 0x0000, 0x0000, 0xFF8D, 0xFFAD,
    0x0000, 0x0000, 0xFF8D, 0xFFA8, 0x0000, 0x0000, 0xFF8D, 0xFFA4,
    0x0000, 0x0000, 0xFF8D, 0xFF9F, 0x0000, 0x0000, 0xFF8D, 0xFF9A,
    0x0000, 0x0000, 0xFF8D, 0xFF95, 0x0000, 0x0000, 0xFF8D, 0xFF90,
    0x0000, 0x0000, 0xFF8D, 0xFF8A, 0x0000, 0x0000, 0xFF8D, 0xFF84,
    0x0000, 0x0000, 0xFF8D, 0xFF7E, 0x0000, 0x0000, 0xFF8D, 0xFF77,
    0x0000, 0x0000, 0xFF8D, 0xFF70, 0x0000, 0x0000, 0xFF8D, 0xFF69,
    0x0000, 0x0000, 0xFF8D, 0xFF61, 0x0000, 0x0000, 0xFF8D, 0xFF58,
    0x0000, 0x0000, 0xFF8D, 0xFF4F, 0x0000, 0x0000, 0xFF8D, 0xFF45,
    0x0000, 0x0000, 0xFF8D, 0xFF3A, 0x0000, 0x0000, 0xFF8D, 0xFF2F,
    0x0000, 0x0000, 0xFF8D, 0xFF22, 0x0000, 0x0000, 0xFF8D, 0xFF14,
    0x0000, 0x0000, 0xFF8D, 0xFF04, 0x0000, 0x0000, 0xFF8D, 0xFEF3,
    0x0000, 0x0000, 0xFF8D, 0xFEE0, 0x0000, 0x0000, 0xFF8D, 0xFECA,
    0x0000, 0x0000, 0xFF8D, 0xFEB1, 0x0000, 0x0000, 0xFF8D, 0xFE94,
    0x0000, 0x0000, 0xFF8D, 0xFE73, 0x0000, 0x0000, 0xFF8D, 0xFE4B,
    0x0000, 0x0000, 0xFF8D, 0xFE1B, 0x0000, 0x0000, 0xFF8D, 0xFDE0,
    0x0000, 0x0000, 0xFF8D, 0xFD95, 0x0000, 0x0000, 0xFF8D, 0xFD34,
    0x0000, 0x0000, 0xFF8D, 0xFCB0, 0x0000, 0x0000, 0xFF8D, 0xFBF1,
    0x0000, 0x0000, 0xFF8D, 0xFAC6, 0x0000, 0x0000, 0xFF8D, 0xF8AD,
    0x0000, 0x0000, 0xFF8D, 0xF3C8, 0x0000, 0x0000, 0xFF8D, 0xDB55
    };

static const q15_t ref_cfft_step_256[512] = {
    0x399A, 0x0000, 0xFF8D, 0x24AB, 0x0000, 0x0000, 0xFF8D, 0x0C38,
    0x0000, 0x0000, 0xFF8D, 0x0753, 0x0000, 0x0000, 0xFF8D, 0x053A,
    0x0000, 0x0000, 0xFF8D, 0x040F, 0x0000, 0x0000, 0xFF8D, 0x0350,
    0x0000, 0x0000, 0xFF8D, 0x02CC, 0x0000, 0x0000, 0xFF8D, 0x026B,
    0x0000, 0x0000, 0xFF8D, 0x0220, 0x0000, 0x0000, 0xFF8D, 0x01E5,
    0x0000, 0x0000, 0xFF8D, 0x01B5, 0x0000, 0x0000, 0xFF8D, 0x018D,
    0x0000, 0x0000, 0xFF8D, 0x016C, 0x0000, 0x0000, 0xFF8D, 0x014F,
    0x0000, 0x0000, 0xFF8D, 0x0136, 0x0000, 0x0000, 0xFF8D, 0x0120,
    0x0000, 0x0000, 0xFF8D, 0x010D, 0x0000, 0x0000, 0xFF8D, 0x00FC,
    0x0000, 0x0000, 0xFF8D, 0x00EC, 0x0000, 0x0000, 0xFF8D, 0x00DE,
    0x0000, 0x0000, 0xFF8D, 0x00D1, 0x0000, 0x0000, 0xFF8D, 0x00C6,
    0x0000, 0x0000, 0xFF8D, 0x00BB, 0x0000, 0x0000, 0xFF8D, 0x00B1,
    0x0000, 0x0000, 0xFF8D, 0x00A8, 0x0000, 0x0000, 0xFF8D, 0x009F,
    0x0000, 0x0000, 0xFF8D, 0x0097, 0x0000, 0x0000, 0xFF8D, 0x0090,
    0x0000, 0x0000, 0xFF8D, 0x0089, 0x0000, 0x0000, 0xFF8D, 0x0082,
    0x0000, 0x0000, 0xFF8D, 0x007C, 0x0000, 0x0000, 0xFF8D, 0x0076,
    0x0000, 0x0000, 0xFF8D, 0x0070, 0x0000, 0x0000, 0xFF8D, 0x006B,
    0x0000, 0x0000, 0xFF8D, 0x0066, 0x0000, 0x0000, 0xFF8D, 0x0061,
    0x0000, 0x0000, 0xFF8D, 0x005C, 0x0000, 0x0000, 0xFF8D, 0x0058,
    0x0000, 0x0000, 0xFF8D, 0x0053, 0x0000, 0x0000, 0xFF8D, 0x004F,
    0x0000, 0x0000, 0xFF8D, 0x004B, 0x0000, 0x0000, 0xFF8D, 0x0047,
    0x0000, 0x0000, 0xFF8D, 0x0043, 0x0000, 0x0000, 0xFF8D, 0x003F,
    0x0000, 0x0000, 0xFF8D, 0x003C, 0x0000, 0x0000, 0xFF8D, 0x0038,
    0x0000, 0x0000, 0xFF8D, 0x0035, 0x0000, 0x0000, 0xFF8D, 0x0031,
    0x0000, 0x0000, 0xFF8D, 0x002E, 0x0000, 0x0000, 0xFF8D, 0x002B,
    0x0000, 0x0000, 0xFF8D, 0x0028, 0x0000, 0x0000, 0xFF8D, 0x0024,
    0x0000, 0x0000, 0xFF8D, 0x0021, 0x0000, 0x0000, 0xFF8D, 0x001E,
    0x0000, 0x0000, 0xFF8D, 0x001B, 0x0000, 0x0000, 0xFF8D, 0x0018,
    0x0000, 0x0000, 0xFF8D, 0x0015, 0x0000, 0x0000, 0xFF8D, 0x0013,
    0x0000, 0x0000, 0xFF8D, 0x0010, 0x0000, 0x0000, 0xFF8D, 0x000D,
    0x0000, 0x0000, 0xFF8D, 0x000A, 0x0000, 0x0000, 0xFF8D, 0x0007,
    0x0000, 0x0000, 0xFF8D, 0x0004, 0x0000, 0x0000, 0xFF8D, 0x0001,
    0x0000, 0x0000, 0xFF8D, 0xFFFF, 0x0000, 0x0000, 0xFF8D, 0xFFFC,
    0x0000, 0x0000, 0xFF8D, 0xFFF9, 0x0000, 0x0000, 0xFF8D, 0xFFF6,
    0x0000, 0x0000, 0xFF8D, 0xFFF3, 0x0000, 0x0000, 0xFF8D, 0xFFF0,
    0x0000, 0x0000, 0xFF8D, 0xFFED, 0x0000, 0x0000, 0xFF8D, 0xFFEB,
    0x0000, 0x0000, 0xFF8D, 0xFFE8, 0x0000, 0x0000, 0xFF8D, 0xFFE5,
    0x0000, 0x0000, 0xFF8D, 0xFFE2, 0x0000, 0x0000, 0xFF8D, 0xFFDF,
    0x0000, 0x0000, 0xFF8D, 0xFFDC, 0x0000, 0x0000, 0xFF8D, 0xFFD8,
    0x0000, 0x0000, 0xFF8D, 0xFFD5, 0x0000, 0x0000, 0xFF8D, 0xFFD2,
    0x0000, 0x0000, 0xFF8D, 0xFFCF, 0x0000, 0x0000, 0xFF8D, 0xFFCB,
    0x0000, 0x0000, 0xFF8D, 0xFFC8, 0x0000, 0x0000, 0xFF8D, 0xFFC4,
    0x0000, 0x0000, 0xFF8D, 0xFFC1, 0x0000, 0x0000, 0xFF8D, 0xFFBD,
    0x0000, 0x0000, 0xFF8D, 0xFFB9, 0x0000, 0x0000, 0xFF8D, 0xFFB5,
    0x0000, 0x0000, 0xFF8D, 0xFFB1, 0x0000, 0x0000, 0xFF8D, 0xFFAD,
    0x0000, 0x0000, 0xFF8D, 0xFFA8, 0x0000, 0x0000, 0xFF8D, 0xFFA4,
    0x0000, 0x0000, 0xFF8D, 0xFF9F, 0x0000, 0x0000, 0xFF8D, 0xFF9A,
    0x0000, 0x0000, 0xFF8D, 0xFF95, 0x0000, 0x0000, 0xFF8D, 0xFF90,
    0x0000, 0x0000, 0xFF8D, 0xFF8A, 0x0000, 0x0000, 0xFF8D, 0xFF84,
    0x0000, 0x0000, 0xFF8D, 0xFF7E, 0x0000, 0x0000, 0xFF8D, 0xFF77,
    0x0000, 0x0000, 0xFF8D, 0xFF70, 0x0000, 0x0000, 0xFF8D, 0xFF69,
    0x0000, 0x0000, 0xFF8D, 0xFF61, 0x0000, 0x0000, 0xFF8D, 0xFF58,
    0x0000, 0x0000, 0xFF8D, 0xFF4F, 0x0000, 0x0000, 0xFF8D, 0xFF45,
    0x0000, 0x0000, 0xFF8D, 0xFF3A, 0x0000, 0x0000, 0xFF8D, 0xFF2F,
    0x0000, 0x0000, 0xFF8D, 0xFF22, 0x0000, 0x0000, 0xFF8D, 0xFF14,
    0x0000, 0x0000, 0xFF8D, 0xFF04, 0x0000, 0x0000, 0xFF8D, 0xFEF3,
    0x0000, 0x0000, 0xFF8D, 0xFEE0, 0x0000, 0x0000, 0xFF8D, 0xFECA,
    0x0000, 0x0000, 0xFF8D, 0xFEB1, 0x0000, 0x0000, 0xFF8D, 0xFE94,
    0x0000, 0x0000, 0xFF8D, 0xFE73, 0x0000, 0x0000, 0xFF8D, 0xFE4B,
    0x0000, 0x0000, 0xFF8D, 0xFE1B, 0x0000, 0x0000, 0xFF8D, 0xFDE0,
    0x0000, 0x0000, 0xFF8D, 0xFD95, 0x0000, 0x0000, 0xFF8D, 0xFD34,
    0x0000, 0x0000, 0xFF8D, 0xFCB0, 0x0000, 0x0000, 0xFF8D, 0xFBF1,
    0x0000, 0x0000, 0xFF8D, 0xFAC6, 0x0000, 0x0000, 0xFF8D, 0xF8AD,
    0x0000, 0x0000, 0xFF8D, 0xF3C8, 0x0000, 0x0000, 0xFF8D, 0xDB55
    };

static const q15_t in_cfft_step_512[1024] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000
    };

static const q15_t in_cifft_step_512[1024] = {
    0x399A, 0x0000, 0xFFC6, 0x24AB, 0x0000, 0x0000, 0xFFC6, 0x0C39,
    0x0000, 0x0000, 0xFFC6, 0x0755, 0x0000, 0x0000, 0xFFC6, 0x053C,
    0x0000, 0x0000, 0xFFC6, 0x0412, 0x0000, 0x0000, 0xFFC6, 0x0354,
    0x0000, 0x0000, 0xFFC6, 0x02D1, 0x0000, 0x0000, 0xFFC6, 0x0270,
    0x0000, 0x0000, 0xFFC6, 0x0226, 0x0000, 0x0000, 0xFFC6, 0x01EC,
    0x0000, 0x0000, 0xFFC6, 0x01BD, 0x0000, 0x0000, 0xFFC6, 0x0195,
    0x0000, 0x0000, 0xFFC6, 0x0175, 0x0000, 0x0000, 0xFFC6, 0x0158,
    0x0000, 0x0000, 0xFFC6, 0x0140, 0x0000, 0x0000, 0xFFC6, 0x012B,
    0x0000, 0x0000, 0xFFC6, 0x0119, 0x0000, 0x0000, 0xFFC6, 0x0108,
    0x0000, 0x0000, 0xFFC6, 0x00F9, 0x0000, 0x0000, 0xFFC6, 0x00EC,
    0x0000, 0x0000, 0xFFC6, 0x00E0, 0x0000, 0x0000, 0xFFC6, 0x00D5,
    0x0000, 0x0000, 0xFFC6, 0x00CB, 0x0000, 0x0000, 0xFFC6, 0x00C2,
    0x0000, 0x0000, 0xFFC6, 0x00BA, 0x0000, 0x0000, 0xFFC6, 0x00B2,
    0x0000, 0x0000, 0xFFC6, 0x00AB, 0x0000, 0x0000, 0xFFC6, 0x00A4,
    0x0000, 0x0000, 0xFFC6, 0x009E, 0x0000, 0x0000, 0xFFC6, 0x0098,
    0x0000, 0x0000, 0xFFC6, 0x0093, 0x0000, 0x0000, 0xFFC6, 0x008E,
    0x0000, 0x0000, 0xFFC6, 0x0089, 0x0000, 0x0000, 0xFFC6, 0x0084,
    0x0000, 0x0000, 0xFFC6, 0x0080, 0x0000, 0x0000, 0xFFC6, 0x007C,
    0x0000, 0x0000, 0xFFC6, 0x0078, 0x0000, 0x0000, 0xFFC6, 0x0074,
    0x0000, 0x0000, 0xFFC6, 0x0071, 0x0000, 0x0000, 0xFFC6, 0x006D,
    0x0000, 0x0000, 0xFFC6, 0x006A, 0x0000, 0x0000, 0xFFC6, 0x0067,
    0x0000, 0x0000, 0xFFC6, 0x0064, 0x0000, 0x0000, 0xFFC6, 0x0061,
    0x0000, 0x0000, 0xFFC6, 0x005F, 0x0000, 0x0000, 0xFFC6, 0x005C,
    0x0000, 0x0000, 0xFFC6, 0x005A, 0x0000, 0x0000, 0xFFC6, 0x0057,
    0x0000, 0x0000, 0xFFC6, 0x0055, 0x0000, 0x0000, 0xFFC6, 0x0053,
    0x0000, 0x0000, 0xFFC6, 0x0051, 0x0000, 0x0000, 0xFFC6, 0x004F,
    0x0000, 0x0000, 0xFFC6, 0x004D, 0x0000, 0x0000, 0xFFC6, 0x004B,
    0x0000, 0x0000, 0xFFC6, 0x0049, 0x0000, 0x0000, 0xFFC6, 0x0047,
    0x0000, 0x0000, 0xFFC6, 0x0045, 0x0000, 0x0000, 0xFFC6, 0x0044,
    0x0000, 0x0000, 0xFFC6, 0x0042, 0x0000, 0x0000, 0xFFC6, 0x0040,
    0x0000, 0x0000, 0xFFC6, 0x003F, 0x0000, 0x0000, 0xFFC6, 0x003D,
    0x0000, 0x0000, 0xFFC6, 0x003C, 0x0000, 0x0000, 0xFFC6, 0x003A,
    0x0000, 0x0000, 0xFFC6, 0x0039, 0x0000, 0x0000, 0xFFC6, 0x0038,
    0x0000, 0x0000, 0xFFC6, 0x0036, 0x0000, 0x0000, 0xFFC6, 0x0035,
    0x0000, 0x0000, 0xFFC6, 0x0034, 0x0000, 0x0000, 0xFFC6, 0x0032,
    0x0000, 0x0000, 0xFFC6, 0x0031, 0x0000, 0x0000, 0xFFC6, 0x0030,
    0x0000, 0x0000, 0xFFC6, 0x002F, 0x0000, 0x0000, 0xFFC6, 0x002E,
    0x0000, 0x0000, 0xFFC6, 0x002C, 0x0000, 0x0000, 0xFFC6, 0x002B,
    0x0000, 0x0000, 0xFFC6, 0x002A, 0x0000, 0x0000, 0xFFC6, 0x0029,
    0x0000, 0x0000, 0xFFC6, 0x0028, 0x0000, 0x0000, 0xFFC6, 0x0027,
    0x0000, 0x0000, 0xFFC6, 0x0026, 0x0000, 0x0000, 0xFFC6, 0x0025,
    0x0000, 0x0000, 0xFFC6, 0x0024, 0x0000, 0x0000, 0xFFC6, 0x0023,
    0x0000, 0x0000, 0xFFC6, 0x0022, 0x0000, 0x0000, 0xFFC6, 0x0021,
    0x0000, 0x0000, 0xFFC6, 0x0020, 0x0000, 0x0000, 0xFFC6, 0x001F,
    0x0000, 0x0000, 0xFFC6, 0x001E, 0x0000, 0x0000, 0xFFC6, 0x001D,
    0x0000, 0x0000, 0xFFC6, 0x001D, 0x0000, 0x0000, 0xFFC6, 0x001C,
    0x0000, 0x0000, 0xFFC6, 0x001B, 0x0000, 0x0000, 0xFFC6, 0x001A,
    0x0000, 0x0000, 0xFFC6, 0x0019, 0x0000, 0x0000, 0xFFC6, 0x0018,
    0x0000, 0x0000, 0xFFC6, 0x0017, 0x0000, 0x0000, 0xFFC6, 0x0017,
    0x0000, 0x0000, 0xFFC6, 0x0016, 0x0000, 0x0000, 0xFFC6, 0x0015,
    0x0000, 0x0000, 0xFFC6, 0x0014, 0x0000, 0x0000, 0xFFC6, 0x0013,
    0x0000, 0x0000, 0xFFC6, 0x0013, 0x0000, 0x0000, 0xFFC6, 0x0012,
    0x0000, 0x0000, 0xFFC6, 0x0011, 0x0000, 0x0000, 0xFFC6, 0x0010,
    0x0000, 0x0000, 0xFFC6, 0x0010, 0x0000, 0x0000, 0xFFC6, 0x000F,
    0x0000, 0x0000, 0xFFC6, 0x000E, 0x0000, 0x0000, 0xFFC6, 0x000D,
    0x0000, 0x0000, 0xFFC6, 0x000D, 0x0000, 0x0000, 0xFFC6, 0x000C,
    0x0000, 0x0000, 0xFFC6, 0x000B, 0x0000, 0x0000, 0xFFC6, 0x000A,
    0x0000, 0x0000, 0xFFC6, 0x000A, 0x0000, 0x0000, 0xFFC6, 0x0009,
    0x0000, 0x0000, 0xFFC6, 0x0008, 0x0000, 0x0000, 0xFFC6, 0x0007,
    0x0000, 0x0000, 0xFFC6, 0x0007, 0x0000, 0x0000, 0xFFC6, 0x0006,
    0x0000, 0x0000, 0xFFC6, 0x0005, 0x0000, 0x0000, 0xFFC6, 0x0005,
    0x0000, 0x0000, 0xFFC6, 0x0004, 0x0000, 0x0000, 0xFFC6, 0x0003,
    0x0000, 0x0000, 0xFFC6, 0x0002, 0x0000, 0x0000, 0xFFC6, 0x0002,
    0x0000, 0x0000, 0xFFC6, 0x0001, 0x0000, 0x0000, 0xFFC6, 0x0000,
    0x0000, 0x0000, 0xFFC6, 0x0000, 0x0000, 0x0000, 0xFFC6, 0xFFFF,
    0x0000, 0x0000, 0xFFC6, 0xFFFE, 0x0000, 0x0000, 0xFFC6, 0xFFFE,
    0x0000, 0x0000, 0xFFC6, 0xFFFD, 0x0000, 0x0000, 0xFFC6, 0xFFFC,
    0x0000, 0x0000, 0xFFC6, 0xFFFB, 0x0000, 0x0000, 0xFFC6, 0xFFFB,
    0x0000, 0x0000, 0xFFC6, 0xFFFA, 0x0000, 0x0000, 0xFFC6, 0xFFF9,
    0x0000, 0x0000, 0xFFC6, 0xFFF9, 0x0000, 0x0000, 0xFFC6, 0xFFF8,
    0x0000, 0x0000, 0xFFC6, 0xFFF7, 0x0000, 0x0000, 0xFFC6, 0xFFF6,
    0x0000, 0x0000, 0xFFC6, 0xFFF6, 0x0000, 0x0000, 0xFFC6, 0xFFF5,
    0x0000, 0x0000, 0xFFC6, 0xFFF4, 0x0000, 0x0000, 0xFFC6, 0xFFF3,
    0x0000, 0x0000, 0xFFC6, 0xFFF3, 0x0000, 0x0000, 0xFFC6, 0xFFF2,
    0x0000, 0x0000, 0xFFC6, 0xFFF1, 0x0000, 0x0000, 0xFFC6, 0xFFF0,
    0x0000, 0x0000, 0xFFC6, 0xFFF0, 0x0000, 0x0000, 0xFFC6, 0xFFEF,
    0x0000, 0x0000, 0xFFC6, 0xFFEE, 0x0000, 0x0000, 0xFFC6, 0xFFED,
    0x0000, 0x0000, 0xFFC6, 0xFFED, 0x0000, 0x0000, 0xFFC6, 0xFFEC,
    0x0000, 0x0000, 0xFFC6, 0xFFEB, 0x0000, 0x0000, 0xFFC6, 0xFFEA,
    0x0000, 0x0000, 0xFFC6, 0xFFE9, 0x0000, 0x0000, 0xFFC6, 0xFFE9,
    0x0000, 0x0000, 0xFFC6, 0xFFE8, 0x0000, 0x0000, 0xFFC6, 0xFFE7,
    0x0000, 0x0000, 0xFFC6, 0xFFE6, 0x0000, 0x0000, 0xFFC6, 0xFFE5,
    0x0000, 0x0000, 0xFFC6, 0xFFE4, 0x0000, 0x0000, 0xFFC6, 0xFFE3,
    0x0000, 0x0000, 0xFFC6, 0xFFE3, 0x0000, 0x0000, 0xFFC6, 0xFFE2,
    0x0000, 0x0000, 0xFFC6, 0xFFE1, 0x0000, 0x0000, 0xFFC6, 0xFFE0,
    0x0000, 0x0000, 0xFFC6, 0xFFDF, 0x0000, 0x0000, 0xFFC6, 0xFFDE,
    0x0000, 0x0000, 0xFFC6, 0xFFDD, 0x0000, 0x0000, 0xFFC6, 0xFFDC,
    0x0000, 0x0000, 0xFFC6, 0xFFDB, 0x0000, 0x0000, 0xFFC6, 0xFFDA,
    0x0000, 0x0000, 0xFFC6, 0xFFD9, 0x0000, 0x0000, 0xFFC6, 0xFFD8,
    0x0000, 0x0000, 0xFFC6, 0xFFD7, 0x0000, 0x0000, 0xFFC6, 0xFFD6,
    0x0000, 0x0000, 0xFFC6, 0xFFD5, 0x0000, 0x0000, 0xFFC6, 0xFFD4,
    0x0000, 0x0000, 0xFFC6, 0xFFD2, 0x0000, 0x0000, 0xFFC6, 0xFFD1,
    0x0000, 0x0000, 0xFFC6, 0xFFD0, 0x0000, 0x0000, 0xFFC6, 0xFFCF,
    0x0000, 0x0000, 0xFFC6, 0xFFCE, 0x0000, 0x0000, 0xFFC6, 0xFFCC,
    0x0000, 0x0000, 0xFFC6, 0xFFCB, 0x0000, 0x0000, 0xFFC6, 0xFFCA,
    0x0000, 0x0000, 0xFFC6, 0xFFC8, 0x0000, 0x0000, 0xFFC6, 0xFFC7,
    0x0000, 0x0000, 0xFFC6, 0xFFC6, 0x0000, 0x0000, 0xFFC6, 0xFFC4,
    0x0000, 0x0000, 0xFFC6, 0xFFC3, 0x0000, 0x0000, 0xFFC6, 0xFFC1,
    0x0000, 0x0000, 0xFFC6, 0xFFC0, 0x0000, 0x0000, 0xFFC6, 0xFFBE,
    0x0000, 0x0000, 0xFFC6, 0xFFBC, 0x0000, 0x0000, 0xFFC6, 0xFFBB,
    0x0000, 0x0000, 0xFFC6, 0xFFB9, 0x0000, 0x0000, 0xFFC6, 0xFFB7,
    0x0000, 0x0000, 0xFFC6, 0xFFB5, 0x0000, 0x0000, 0xFFC6, 0xFFB3,
    0x0000, 0x0000, 0xFFC6, 0xFFB1, 0x0000, 0x0000, 0xFFC6, 0xFFAF,
    0x0000, 0x0000, 0xFFC6, 0xFFAD, 0x0000, 0x0000, 0xFFC6, 0xFFAB,
    0x0000, 0x0000, 0xFFC6, 0xFFA9, 0x0000, 0x0000, 0xFFC6, 0xFFA6,
    0x0000, 0x0000, 0xFFC6, 0xFFA4, 0x0000, 0x0000, 0xFFC6, 0xFFA1,
    0x0000, 0x0000, 0xFFC6, 0xFF9F, 0x0000, 0x0000, 0xFFC6, 0xFF9C,
    0x0000, 0x0000, 0xFFC6, 0xFF99, 0x0000, 0x0000, 0xFFC6, 0xFF96,
    0x0000, 0x0000, 0xFFC6, 0xFF93, 0x0000, 0x0000, 0xFFC6, 0xFF8F,
    0x0000, 0x0000, 0xFFC6, 0xFF8C, 0x0000, 0x0000, 0xFFC6, 0xFF88,
    0x0000, 0x0000, 0xFFC6, 0xFF84, 0x0000, 0x0000, 0xFFC6, 0xFF80,
    0x0000, 0x0000, 0xFFC6, 0xFF7C, 0x0000, 0x0000, 0xFFC6, 0xFF77,
    0x0000, 0x0000, 0xFFC6, 0xFF72, 0x0000, 0x0000, 0xFFC6, 0xFF6D,
    0x0000, 0x0000, 0xFFC6, 0xFF68, 0x0000, 0x0000, 0xFFC6, 0xFF62,
    0x0000, 0x0000, 0xFFC6, 0xFF5C, 0x0000, 0x0000, 0xFFC6, 0xFF55,
    0x0000, 0x0000, 0xFFC6, 0xFF4E, 0x0000, 0x0000, 0xFFC6, 0xFF46,
    0x0000, 0x0000, 0xFFC6, 0xFF3E, 0x0000, 0x0000, 0xFFC6, 0xFF35,
    0x0000, 0x0000, 0xFFC6, 0xFF2B, 0x0000, 0x0000, 0xFFC6, 0xFF20,
    0x0000, 0x0000, 0xFFC6, 0xFF14, 0x0000, 0x0000, 0xFFC6, 0xFF07,
    0x0000, 0x0000, 0xFFC6, 0xFEF8, 0x0000, 0x0000, 0xFFC6, 0xFEE7,
    0x0000, 0x0000, 0xFFC6, 0xFED5, 0x0000, 0x0000, 0xFFC6, 0xFEC0,
    0x0000, 0x0000, 0xFFC6, 0xFEA8, 0x0000, 0x0000, 0xFFC6, 0xFE8B,
    0x0000, 0x0000, 0xFFC6, 0xFE6B, 0x0000, 0x0000, 0xFFC6, 0xFE43,
    0x0000, 0x0000, 0xFFC6, 0xFE14, 0x0000, 0x0000, 0xFFC6, 0xFDDA,
    0x0000, 0x0000, 0xFFC6, 0xFD90, 0x0000, 0x0000, 0xFFC6, 0xFD2F,
    0x0000, 0x0000, 0xFFC6, 0xFCAC, 0x0000, 0x0000, 0xFFC6, 0xFBEE,
    0x0000, 0x0000, 0xFFC6, 0xFAC4, 0x0000, 0x0000, 0xFFC6, 0xF8AB,
    0x0000, 0x0000, 0xFFC6, 0xF3C7, 0x0000, 0x0000, 0xFFC6, 0xDB55
    };

static const q15_t ref_cfft_step_512[1024] = {
    0x399A, 0x0000, 0xFFC6, 0x24AB, 0x0000, 0x0000, 0xFFC6, 0x0C39,
    0x0000, 0x0000, 0xFFC6, 0x0755, 0x0000, 0x0000, 0xFFC6, 0x053C,
    0x0000, 0x0000, 0xFFC6, 0x0412, 0x0000, 0x0000, 0xFFC6, 0x0354,
    0x0000, 0x0000, 0xFFC6, 0x02D1, 0x0000, 0x0000, 0xFFC6, 0x0270,
    0x0000, 0x0000, 0xFFC6, 0x0226, 0x0000, 0x0000, 0xFFC6, 0x01EC,
    0x0000, 0x0000, 0xFFC6, 0x01BD, 0x0000, 0x0000, 0xFFC6, 0x0195,
    0x0000, 0x0000, 0xFFC6, 0x0175, 0x0000, 0x0000, 0xFFC6, 0x0158,
    0x0000, 0x0000, 0xFFC6, 0x0140, 0x0000, 0x0000, 0xFFC6, 0x012B,
    0x0000, 0x0000, 0xFFC6, 0x0119, 0x0000, 0x0000, 0xFFC6, 0x0108,
    0x0000, 0x0000, 0xFFC6, 0x00F9, 0x0000, 0x0000, 0xFFC6, 0x00EC,
    0x0000, 0x0000, 0xFFC6, 0x00E0, 0x0000, 0x0000, 0xFFC6, 0x00D5,
    0x0000, 0x0000, 0xFFC6, 0x00CB, 0x0000, 0x0000, 0xFFC6, 0x00C2,
    0x0000, 0x0000, 0xFFC6, 0x00BA, 0x0000, 0x0000, 0xFFC6, 0x00B2,
    0x0000, 0x0000, 0xFFC6, 0x00AB, 0x0000, 0x0000, 0xFFC6, 0x00A4,
    0x0000, 0x0000, 0xFFC6, 0x009E, 0x0000, 0x0000, 0xFFC6, 0x0098,
    0x0000, 0x0000, 0xFFC6, 0x0093, 0x0000, 0x0000, 0xFFC6, 0x008E,
    0x0000, 0x0000, 0xFFC6, 0x0089, 0x0000, 0x0000, 0xFFC6, 0x0084,
    0x0000, 0x0000, 0xFFC6, 0x0080, 0x0000, 0x0000, 0xFFC6, 0x007C,
    0x0000, 0x0000, 0xFFC6, 0x0078, 0x0000, 0x0000, 0xFFC6, 0x0074,
    0x0000, 0x0000, 0xFFC6, 0x0071, 0x0000, 0x0000, 0xFFC6, 0x006D,
    0x0000, 0x0000, 0xFFC6, 0x006A, 0x0000, 0x0000, 0xFFC6, 0x0067,
    0x0000, 0x0000, 0xFFC6, 0x0064, 0x0000, 0x0000, 0xFFC6, 0x0061,
    0x0000, 0x0000, 0xFFC6, 0x005F, 0x0000, 0x0000, 0xFFC6, 0x005C,
    0x0000, 0x0000, 0xFFC6, 0x005A, 0x0000, 0x0000, 0xFFC6, 0x0057,
    0x0000, 0x0000, 0xFFC6, 0x0055, 0x0000, 0x0000, 0xFFC6, 0x0053,
    0x0000, 0x0000, 0xFFC6, 0x0051, 0x0000, 0x0000, 0xFFC6, 0x004F,
    0x0000, 0x0000, 0xFFC6, 0x004D, 0x0000, 0x0000, 0xFFC6, 0x004B,
    0x0000, 0x0000, 0xFFC6, 0x0049, 0x0000, 0x0000, 0xFFC6, 0x0047,
    0x0000, 0x0000, 0xFFC6, 0x0045, 0x0000, 0x0000, 0xFFC6, 0x0044,
    0x0000, 0x0000, 0xFFC6, 0x0042, 0x0000, 0x0000, 0xFFC6, 0x0040,
    0x0000, 0x0000, 0xFFC6, 0x003F, 0x0000, 0x0000, 0xFFC6, 0x003D,
    0x0000, 0x0000, 0xFFC6, 0x003C, 0x0000, 0x0000, 0xFFC6, 0x003A,
    0x0000, 0x0000, 0xFFC6, 0x0039, 0x0000, 0x0000, 0xFFC6, 0x0038,
    0x0000, 0x0000, 0xFFC6, 0x0036, 0x0000, 0x0000, 0xFFC6, 0x0035,
    0x0000, 0x0000, 0xFFC6, 0x0034, 0x0000, 0x0000, 0xFFC6, 0x0032,
    0x0000, 0x0000, 0xFFC6, 0x0031, 0x0000, 0x0000, 0xFFC6, 0x0030,
    0x0000, 0x0000, 0xFFC6, 0x002F, 0x0000, 0x0000, 0xFFC6, 0x002E,
    0x0000, 0x0000, 0xFFC6, 0x002C, 0x0000, 0x0000, 0xFFC6, 0x002B,
    0x0000, 0x0000, 0xFFC6, 0x002A, 0x0000, 0x0000, 0xFFC6, 0x0029,
    0x0000, 0x0000, 0xFFC6, 0x0028, 0x0000, 0x0000, 0xFFC6, 0x0027,
    0x0000, 0x0000, 0xFFC6, 0x0026, 0x0000, 0x0000, 0xFFC6, 0x0025,
    0x0000, 0x0000, 0xFFC6, 0x0024, 0x0000, 0x0000, 0xFFC6, 0x0023,
    0x0000, 0x0000, 0xFFC6, 0x0022, 0x0000, 0x0000, 0xFFC6, 0x0021,
    0x0000, 0x0000, 0xFFC6, 0x0020, 0x0000, 0x0000, 0xFFC6, 0x001F,
    0x0000, 0x0000, 0xFFC6, 0x001E, 0x0000, 0x0000, 0xFFC6, 0x001D,
    0x0000, 0x0000, 0xFFC6, 0x001D, 0x0000, 0x0000, 0xFFC6, 0x001C,
    0x0000, 0x0000, 0xFFC6, 0x001B, 0x0000, 0x0000, 0xFFC6, 0x001A,
    0x0000, 0x0000, 0xFFC6, 0x0019, 0x0000, 0x0000, 0xFFC6, 0x0018,
    0x0000, 0x0000, 0xFFC6, 0x0017, 0x0000, 0x0000, 0xFFC6, 0x0017,
    0x0000, 0x0000, 0xFFC6, 0x0016, 0x0000, 0x0000, 0xFFC6, 0x0015,
    0x0000, 0x0000, 0xFFC6, 0x0014, 0x0000, 0x0000, 0xFFC6, 0x0013,
    0x0000, 0x0000, 0xFFC6, 0x0013, 0x0000, 0x0000, 0xFFC6, 0x0012,
    0x0000, 0x0000, 0xFFC6, 0x0011, 0x0000, 0x0000, 0xFFC6, 0x0010,
    0x0000, 0x0000, 0xFFC6, 0x0010, 0x0000, 0x0000, 0xFFC6, 0x000F,
    0x0000, 0x0000, 0xFFC6, 0x000E, 0x0000, 0x0000, 0xFFC6, 0x000D,
    0x0000, 0x0000, 0xFFC6, 0x000D, 0x0000, 0x0000, 0xFFC6, 0x000C,
    0x0000, 0x0000, 0xFFC6, 0x000B, 0x0000, 0x0000, 0xFFC6, 0x000A,
    0x0000, 0x0000, 0xFFC6, 0x000A, 0x0000, 0x0000, 0xFFC6, 0x0009,
    0x0000, 0x0000, 0xFFC6, 0x0008, 0x0000, 0x0000, 0xFFC6, 0x0007,
    0x0000, 0x0000, 0xFFC6, 0x0007, 0x0000, 0x0000, 0xFFC6, 0x0006,
    0x0000, 0x0000, 0xFFC6, 0x0005, 0x0000, 0x0000, 0xFFC6, 0x0005,
    0x0000, 0x0000, 0xFFC6, 0x0004, 0x0000, 0x0000, 0xFFC6, 0x0003,
    0x0000, 0x0000, 0xFFC6, 0x0002, 0x0000, 0x0000, 0xFFC6, 0x0002,
    0x0000, 0x0000, 0xFFC6, 0x0001, 0x0000, 0x0000, 0xFFC6, 0x0000,
    0x0000, 0x0000, 0xFFC6, 0x0000, 0x0000, 0x0000, 0xFFC6, 0xFFFF,
    0x0000, 0x0000, 0xFFC6, 0xFFFE, 0x0000, 0x0000, 0xFFC6, 0xFFFE,
    0x0000, 0x0000, 0xFFC6, 0xFFFD, 0x0000, 0x0000, 0xFFC6, 0xFFFC,
    0x0000, 0x0000, 0xFFC6, 0xFFFB, 0x0000, 0x0000, 0xFFC6, 0xFFFB,
    0x0000, 0x0000, 0xFFC6, 0xFFFA, 0x0000, 0x0000, 0xFFC6, 0xFFF9,
    0x0000, 0x0000, 0xFFC6, 0xFFF9, 0x0000, 0x0000, 0xFFC6, 0xFFF8,
    0x0000, 0x0000, 0xFFC6, 0xFFF7, 0x0000, 0x0000, 0xFFC6, 0xFFF6,
    0x0000, 0x0000, 0xFFC6, 0xFFF6, 0x0000, 0x0000, 0xFFC6, 0xFFF5,
    0x0000, 0x0000, 0xFFC6, 0xFFF4, 0x0000, 0x0000, 0xFFC6, 0xFFF3,
    0x0000, 0x0000, 0xFFC6, 0xFFF3, 0x0000, 0x0000, 0xFFC6, 0xFFF2,
    0x0000, 0x0000, 0xFFC6, 0xFFF1, 0x0000, 0x0000, 0xFFC6, 0xFFF0,
    0x0000, 0x0000, 0xFFC6, 0xFFF0, 0x0000, 0x0000, 0xFFC6, 0xFFEF,
    0x0000, 0x0000, 0xFFC6, 0xFFEE, 0x0000, 0x0000, 0xFFC6, 0xFFED,
    0x0000, 0x0000, 0xFFC6, 0xFFED, 0x0000, 0x0000, 0xFFC6, 0xFFEC,
    0x0000, 0x0000, 0xFFC6, 0xFFEB, 0x0000, 0x0000, 0xFFC6, 0xFFEA,
    0x0000, 0x0000, 0xFFC6, 0xFFE9, 0x0000, 0x0000, 0xFFC6, 0xFFE9,
    0x0000, 0x0000, 0xFFC6, 0xFFE8, 0x0000, 0x0000, 0xFFC6, 0xFFE7,
    0x0000, 0x0000, 0xFFC6, 0xFFE6, 0x0000, 0x0000, 0xFFC6, 0xFFE5,
    0x0000, 0x0000, 0xFFC6, 0xFFE4, 0x0000, 0x0000, 0xFFC6, 0xFFE3,
    0x0000, 0x0000, 0xFFC6, 0xFFE3, 0x0000, 0x0000, 0xFFC6, 0xFFE2,
    0x0000, 0x0000, 0xFFC6, 0xFFE1, 0x0000, 0x0000, 0xFFC6, 0xFFE0,
    0x0000, 0x0000, 0xFFC6, 0xFFDF, 0x0000, 0x0000, 0xFFC6, 0xFFDE,
    0x0000, 0x0000, 0xFFC6, 0xFFDD, 0x0000, 0x0000, 0xFFC6, 0xFFDC,
    0x0000, 0x0000, 0xFFC6, 0xFFDB, 0x0000, 0x0000, 0xFFC6, 0xFFDA,
    0x0000, 0x0000, 0xFFC6, 0xFFD9, 0x0000, 0x0000, 0xFFC6, 0xFFD8,
    0x0000, 0x0000, 0xFFC6, 0xFFD7, 0x0000, 0x0000, 0xFFC6, 0xFFD6,
    0x0000, 0x0000, 0xFFC6, 0xFFD5, 0x0000, 0x0000, 0xFFC6, 0xFFD4,
    0x0000, 0x0000, 0xFFC6, 0xFFD2, 0x0000, 0x0000, 0xFFC6, 0xFFD1,
    0x0000, 0x0000, 0xFFC6, 0xFFD0, 0x0000, 0x0000, 0xFFC6, 0xFFCF,
    0x0000, 0x0000, 0xFFC6, 0xFFCE, 0x0000, 0x0000, 0xFFC6, 0xFFCC,
    0x0000, 0x0000, 0xFFC6, 0xFFCB, 0x0000, 0x0000, 0xFFC6, 0xFFCA,
    0x0000, 0x0000, 0xFFC6, 0xFFC8, 0x0000, 0x0000, 0xFFC6, 0xFFC7,
    0x0000, 0x0000, 0xFFC6, 0xFFC6, 0x0000, 0x0000, 0xFFC6, 0xFFC4,
    0x0000, 0x0000, 0xFFC6, 0xFFC3, 0x0000, 0x0000, 0xFFC6, 0xFFC1,
    0x0000, 0x0000, 0xFFC6, 0xFFC0, 0x0000, 0x0000, 0xFFC6, 0xFFBE,
    0x0000, 0x0000, 0xFFC6, 0xFFBC, 0x0000, 0x0000, 0xFFC6, 0xFFBB,
    0x0000, 0x0000, 0xFFC6, 0xFFB9, 0x0000, 0x0000, 0xFFC6, 0xFFB7,
    0x0000, 0x0000, 0xFFC6, 0xFFB5, 0x0000, 0x0000, 0xFFC6, 0xFFB3,
    0x0000, 0x0000, 0xFFC6, 0xFFB1, 0x0000, 0x0000, 0xFFC6, 0xFFAF,
    0x0000, 0x0000, 0xFFC6, 0xFFAD, 0x0000, 0x0000, 0xFFC6, 0xFFAB,
    0x0000, 0x0000, 0xFFC6, 0xFFA9, 0x0000, 0x0000, 0xFFC6, 0xFFA6,
    0x0000, 0x0000, 0xFFC6, 0xFFA4, 0x0000, 0x0000, 0xFFC6, 0xFFA1,
    0x0000, 0x0000, 0xFFC6, 0xFF9F, 0x0000, 0x0000, 0xFFC6, 0xFF9C,
    0x0000, 0x0000, 0xFFC6, 0xFF99, 0x0000, 0x0000, 0xFFC6, 0xFF96,
    0x0000, 0x0000, 0xFFC6, 0xFF93, 0x0000, 0x0000, 0xFFC6, 0xFF8F,
    0x0000, 0x0000, 0xFFC6, 0xFF8C, 0x0000, 0x0000, 0xFFC6, 0xFF88,
    0x0000, 0x0000, 0xFFC6, 0xFF84, 0x0000, 0x0000, 0xFFC6, 0xFF80,
    0x0000, 0x0000, 0xFFC6, 0xFF7C, 0x0000, 0x0000, 0xFFC6, 0xFF77,
    0x0000, 0x0000, 0xFFC6, 0xFF72, 0x0000, 0x0000, 0xFFC6, 0xFF6D,
    0x0000, 0x0000, 0xFFC6, 0xFF68, 0x0000, 0x0000, 0xFFC6, 0xFF62,
    0x0000, 0x0000, 0xFFC6, 0xFF5C, 0x0000, 0x0000, 0xFFC6, 0xFF55,
    0x0000, 0x0000, 0xFFC6, 0xFF4E, 0x0000, 0x0000, 0xFFC6, 0xFF46,
    0x0000, 0x0000, 0xFFC6, 0xFF3E, 0x0000, 0x0000, 0xFFC6, 0xFF35,
    0x0000, 0x0000, 0xFFC6, 0xFF2B, 0x0000, 0x0000, 0xFFC6, 0xFF20,
    0x0000, 0x0000, 0xFFC6, 0xFF14, 0x0000, 0x0000, 0xFFC6, 0xFF07,
    0x0000, 0x0000, 0xFFC6, 0xFEF8, 0x0000, 0x0000, 0xFFC6, 0xFEE7,
    0x0000, 0x0000, 0xFFC6, 0xFED5, 0x0000, 0x0000, 0xFFC6, 0xFEC0,
    0x0000, 0x0000, 0xFFC6, 0xFEA8, 0x0000, 0x0000, 0xFFC6, 0xFE8B,
    0x0000, 0x0000, 0xFFC6, 0xFE6B, 0x0000, 0x0000, 0xFFC6, 0xFE43,
    0x0000, 0x0000, 0xFFC6, 0xFE14, 0x0000, 0x0000, 0xFFC6, 0xFDDA,
    0x0000, 0x0000, 0xFFC6, 0xFD90, 0x0000, 0x0000, 0xFFC6, 0xFD2F,
    0x0000, 0x0000, 0xFFC6, 0xFCAC, 0x0000, 0x0000, 0xFFC6, 0xFBEE,
    0x0000, 0x0000, 0xFFC6, 0xFAC4, 0x0000, 0x0000, 0xFFC6, 0xF8AB,
    0x0000, 0x0000, 0xFFC6, 0xF3C7, 0x0000, 0x0000, 0xFFC6, 0xDB55
    };

static const q15_t in_cfft_step_1024[2048] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000
    };

static const q15_t in_cifft_step_1024[2048] = {
    0x399A, 0x0000, 0xFFE3, 0x24AB, 0x0000, 0x0000, 0xFFE3, 0x0C39,
    0x0000, 0x0000, 0xFFE3, 0x0755, 0x0000, 0x0000, 0xFFE3, 0x053D,
    0x0000, 0x0000, 0xFFE3, 0x0413, 0x0000, 0x0000, 0xFFE3, 0x0355,
    0x0000, 0x0000, 0xFFE3, 0x02D2, 0x0000, 0x0000, 0xFFE3, 0x0271,
    0x0000, 0x0000, 0xFFE3, 0x0228, 0x0000, 0x0000, 0xFFE3, 0x01EE,
    0x0000, 0x0000, 0xFFE3, 0x01BE, 0x0000, 0x0000, 0xFFE3, 0x0197,
    0x0000, 0x0000, 0xFFE3, 0x0177, 0x0000, 0x0000, 0xFFE3, 0x015B,
    0x0000, 0x0000, 0xFFE3, 0x0143, 0x0000, 0x0000, 0xFFE3, 0x012E,
    0x0000, 0x0000, 0xFFE3, 0x011B, 0x0000, 0x0000, 0xFFE3, 0x010B,
    0x0000, 0x0000, 0xFFE3, 0x00FD, 0x0000, 0x0000, 0xFFE3, 0x00F0,
    0x0000, 0x0000, 0xFFE3, 0x00E4, 0x0000, 0x0000, 0xFFE3, 0x00D9,
    0x0000, 0x0000, 0xFFE3, 0x00CF, 0x0000, 0x0000, 0xFFE3, 0x00C6,
    0x0000, 0x0000, 0xFFE3, 0x00BE, 0x0000, 0x0000, 0xFFE3, 0x00B7,
    0x0000, 0x0000, 0xFFE3, 0x00B0, 0x0000, 0x0000, 0xFFE3, 0x00A9,
    0x0000, 0x0000, 0xFFE3, 0x00A3, 0x0000, 0x0000, 0xFFE3, 0x009D,
    0x0000, 0x0000, 0xFFE3, 0x0098, 0x0000, 0x0000, 0xFFE3, 0x0093,
    0x0000, 0x0000, 0xFFE3, 0x008F, 0x0000, 0x0000, 0xFFE3, 0x008A,
    0x0000, 0x0000, 0xFFE3, 0x0086, 0x0000, 0x0000, 0xFFE3, 0x0082,
    0x0000, 0x0000, 0xFFE3, 0x007E, 0x0000, 0x0000, 0xFFE3, 0x007B,
    0x0000, 0x0000, 0xFFE3, 0x0078, 0x0000, 0x0000, 0xFFE3, 0x0074,
    0x0000, 0x0000, 0xFFE3, 0x0071, 0x0000, 0x0000, 0xFFE3, 0x006F,
    0x0000, 0x0000, 0xFFE3, 0x006C, 0x0000, 0x0000, 0xFFE3, 0x0069,
    0x0000, 0x0000, 0xFFE3, 0x0067, 0x0000, 0x0000, 0xFFE3, 0x0064,
    0x0000, 0x0000, 0xFFE3, 0x0062, 0x0000, 0x0000, 0xFFE3, 0x0060,
    0x0000, 0x0000, 0xFFE3, 0x005E, 0x0000, 0x0000, 0xFFE3, 0x005C,
    0x0000, 0x0000, 0xFFE3, 0x005A, 0x0000, 0x0000, 0xFFE3, 0x0058,
    0x0000, 0x0000, 0xFFE3, 0x0056, 0x0000, 0x0000, 0xFFE3, 0x0055,
    0x0000, 0x0000, 0xFFE3, 0x0053, 0x0000, 0x0000, 0xFFE3, 0x0051,
    0x0000, 0x0000, 0xFFE3, 0x0050, 0x0000, 0x0000, 0xFFE3, 0x004E,
    0x0000, 0x0000, 0xFFE3, 0x004D, 0x0000, 0x0000, 0xFFE3, 0x004B,
    0x0000, 0x0000, 0xFFE3, 0x004A, 0x0000, 0x0000, 0xFFE3, 0x0049,
    0x0000, 0x0000, 0xFFE3, 0x0047, 0x0000, 0x0000, 0xFFE3, 0x0046,
    0x0000, 0x0000, 0xFFE3, 0x0045, 0x0000, 0x0000, 0xFFE3, 0x0044,
    0x0000, 0x0000, 0xFFE3, 0x0043, 0x0000, 0x0000, 0xFFE3, 0x0042,
    0x0000, 0x0000, 0xFFE3, 0x0040, 0x0000, 0x0000, 0xFFE3, 0x003F,
    0x0000, 0x0000, 0xFFE3, 0x003E, 0x0000, 0x0000, 0xFFE3, 0x003D,
    0x0000, 0x0000, 0xFFE3, 0x003C, 0x0000, 0x0000, 0xFFE3, 0x003B,
    0x0000, 0x0000, 0xFFE3, 0x003B, 0x0000, 0x0000, 0xFFE3, 0x003A,
    0x0000, 0x0000, 0xFFE3, 0x0039, 0x0000, 0x0000, 0xFFE3, 0x0038,
    0x0000, 0x0000, 0xFFE3, 0x0037, 0x0000, 0x0000, 0xFFE3, 0x0036,
    0x0000, 0x0000, 0xFFE3, 0x0035, 0x0000, 0x0000, 0xFFE3, 0x0035,
    0x0000, 0x0000, 0xFFE3, 0x0034, 0x0000, 0x0000, 0xFFE3, 0x0033,
    0x0000, 0x0000, 0xFFE3, 0x0032, 0x0000, 0x0000, 0xFFE3, 0x0032,
    0x0000, 0x0000, 0xFFE3, 0x0031, 0x0000, 0x0000, 0xFFE3, 0x0030,
    0x0000, 0x0000, 0xFFE3, 0x0030, 0x0000, 0x0000, 0xFFE3, 0x002F,
    0x0000, 0x0000, 0xFFE3, 0x002E, 0x0000, 0x0000, 0xFFE3, 0x002E,
    0x0000, 0x0000, 0xFFE3, 0x002D, 0x0000, 0x0000, 0xFFE3, 0x002D,
    0x0000, 0x0000, 0xFFE3, 0x002C, 0x0000, 0x0000, 0xFFE3, 0x002B,
    0x0000, 0x0000, 0xFFE3, 0x002B, 0x0000, 0x0000, 0xFFE3, 0x002A,
    0x0000, 0x0000, 0xFFE3, 0x002A, 0x0000, 0x0000, 0xFFE3, 0x0029,
    0x0000, 0x0000, 0xFFE3, 0x0029, 0x0000, 0x0000, 0xFFE3, 0x0028,
    0x0000, 0x0000, 0xFFE3, 0x0028, 0x0000, 0x0000, 0xFFE3, 0x0027,
    0x0000, 0x0000, 0xFFE3, 0x0027, 0x0000, 0x0000, 0xFFE3, 0x0026,
    0x0000, 0x0000, 0xFFE3, 0x0026, 0x0000, 0x0000, 0xFFE3, 0x0025,
    0x0000, 0x0000, 0xFFE3, 0x0025, 0x0000, 0x0000, 0xFFE3, 0x0024,
    0x0000, 0x0000, 0xFFE3, 0x0024, 0x0000, 0x0000, 0xFFE3, 0x0023,
    0x0000, 0x0000, 0xFFE3, 0x0023, 0x0000, 0x0000, 0xFFE3, 0x0022,
    0x0000, 0x0000, 0xFFE3, 0x0022, 0x0000, 0x0000, 0xFFE3, 0x0022,
    0x0000, 0x0000, 0xFFE3, 0x0021, 0x0000, 0x0000, 0xFFE3, 0x0021,
    0x0000, 0x0000, 0xFFE3, 0x0020, 0x0000, 0x0000, 0xFFE3, 0x0020,
    0x0000, 0x0000, 0xFFE3, 0x0020, 0x0000, 0x0000, 0xFFE3, 0x001F,
    0x0000, 0x0000, 0xFFE3, 0x001F, 0x0000, 0x0000, 0xFFE3, 0x001E,
    0x0000, 0x0000, 0xFFE3, 0x001E, 0x0000, 0x0000, 0xFFE3, 0x001E,
    0x0000, 0x0000, 0xFFE3, 0x001D, 0x0000, 0x0000, 0xFFE3, 0x001D,
    0x0000, 0x0000, 0xFFE3, 0x001D, 0x0000, 0x0000, 0xFFE3, 0x001C,
    0x0000, 0x0000, 0xFFE3, 0x001C, 0x0000, 0x0000, 0xFFE3, 0x001C,
    0x0000, 0x0000, 0xFFE3, 0x001B, 0x0000, 0x0000, 0xFFE3, 0x001B,
    0x0000, 0x0000, 0xFFE3, 0x001B, 0x0000, 0x0000, 0xFFE3, 0x001A,
    0x0000, 0x0000, 0xFFE3, 0x001A, 0x0000, 0x0000, 0xFFE3, 0x001A,
    0x0000, 0x0000, 0xFFE3, 0x0019, 0x0000, 0x0000, 0xFFE3, 0x0019,
    0x0000, 0x0000, 0xFFE3, 0x0019, 0x0000, 0x0000, 0xFFE3, 0x0018,
    0x0000, 0x0000, 0xFFE3, 0x0018, 0x0000, 0x0000, 0xFFE3, 0x0018,
    0x0000, 0x0000, 0xFFE3, 0x0017, 0x0000, 0x0000, 0xFFE3, 0x0017,
    0x0000, 0x0000, 0xFFE3, 0x0017, 0x0000, 0x0000, 0xFFE3, 0x0017,
    0x0000, 0x0000, 0xFFE3, 0x0016, 0x0000, 0x0000, 0xFFE3, 0x0016,
    0x0000, 0x0000, 0xFFE3, 0x0016, 0x0000, 0x0000, 0xFFE3, 0x0015,
    0x0000, 0x0000, 0xFFE3, 0x0015, 0x0000, 0x0000, 0xFFE3, 0x0015,
    0x0000, 0x0000, 0xFFE3, 0x0015, 0x0000, 0x0000, 0xFFE3, 0x0014,
    0x0000, 0x0000, 0xFFE3, 0x0014, 0x0000, 0x0000, 0xFFE3, 0x0014,
    0x0000, 0x0000, 0xFFE3, 0x0014, 0x0000, 0x0000, 0xFFE3, 0x0013,
    0x0000, 0x0000, 0xFFE3, 0x0013, 0x0000, 0x0000, 0xFFE3, 0x0013,
    0x0000, 0x0000, 0xFFE3, 0x0013, 0x0000, 0x0000, 0xFFE3, 0x0012,
    0x0000, 0x0000, 0xFFE3, 0x0012, 0x0000, 0x0000, 0xFFE3, 0x0012,
    0x0000, 0x0000, 0xFFE3, 0x0012, 0x0000, 0x0000, 0xFFE3, 0x0011,
    0x0000, 0x0000, 0xFFE3, 0x0011, 0x0000, 0x0000, 0xFFE3, 0x0011,
    0x0000, 0x0000, 0xFFE3, 0x0011, 0x0000, 0x0000, 0xFFE3, 0x0010,
    0x0000, 0x0000, 0xFFE3, 0x0010, 0x0000, 0x0000, 0xFFE3, 0x0010,
    0x0000, 0x0000, 0xFFE3, 0x0010, 0x0000, 0x0000, 0xFFE3, 0x0010,
    0x0000, 0x0000, 0xFFE3, 0x000F, 0x0000, 0x0000, 0xFFE3, 0x000F,
    0x0000, 0x0000, 0xFFE3, 0x000F, 0x0000, 0x0000, 0xFFE3, 0x000F,
    0x0000, 0x0000, 0xFFE3, 0x000E, 0x0000, 0x0000, 0xFFE3, 0x000E,
    0x0000, 0x0000, 0xFFE3, 0x000E, 0x0000, 0x0000, 0xFFE3, 0x000E,
    0x0000, 0x0000, 0xFFE3, 0x000E, 0x0000, 0x0000, 0xFFE3, 0x000D,
    0x0000, 0x0000, 0xFFE3, 0x000D, 0x0000, 0x0000, 0xFFE3, 0x000D,
    0x0000, 0x0000, 0xFFE3, 0x000D, 0x0000, 0x0000, 0xFFE3, 0x000C,
    0x0000, 0x0000, 0xFFE3, 0x000C, 0x0000, 0x0000, 0xFFE3, 0x000C,
    0x0000, 0x0000, 0xFFE3, 0x000C, 0x0000, 0x0000, 0xFFE3, 0x000C,
    0x0000, 0x0000, 0xFFE3, 0x000B, 0x0000, 0x0000, 0xFFE3, 0x000B,
    0x0000, 0x0000, 0xFFE3, 0x000B, 0x0000, 0x0000, 0xFFE3, 0x000B,
    0x0000, 0x0000, 0xFFE3, 0x000B, 0x0000, 0x0000, 0xFFE3, 0x000A,
    0x0000, 0x0000, 0xFFE3, 0x000A, 0x0000, 0x0000, 0xFFE3, 0x000A,
    0x0000, 0x0000, 0xFFE3, 0x000A, 0x0000, 0x0000, 0xFFE3, 0x000A,
    0x0000, 0x0000, 0xFFE3, 0x0009, 0x0000, 0x0000, 0xFFE3, 0x0009,
    0x0000, 0x0000, 0xFFE3, 0x0009, 0x0000, 0x0000, 0xFFE3, 0x0009,
    0x0000, 0x0000, 0xFFE3, 0x0009, 0x0000, 0x0000, 0xFFE3, 0x0008,
    0x0000, 0x0000, 0xFFE3, 0x0008, 0x0000, 0x0000, 0xFFE3, 0x0008,
    0x0000, 0x0000, 0xFFE3, 0x0008, 0x0000, 0x0000, 0xFFE3, 0x0008,
    0x0000, 0x0000, 0xFFE3, 0x0007, 0x0000, 0x0000, 0xFFE3, 0x0007,
    0x0000, 0x0000, 0xFFE3, 0x0007, 0x0000, 0x0000, 0xFFE3, 0x0007,
    0x0000, 0x0000, 0xFFE3, 0x0007, 0x0000, 0x0000, 0xFFE3, 0x0007,
    0x0000, 0x0000, 0xFFE3, 0x0006, 0x0000, 0x0000, 0xFFE3, 0x0006,
    0x0000, 0x0000, 0xFFE3, 0x0006, 0x0000, 0x0000, 0xFFE3, 0x0006,
    0x0000, 0x0000, 0xFFE3, 0x0006, 0x0000, 0x0000, 0xFFE3, 0x0005,
    0x0000, 0x0000, 0xFFE3, 0x0005, 0x0000, 0x0000, 0xFFE3, 0x0005,
    0x0000, 0x0000, 0xFFE3, 0x0005, 0x0000, 0x0000, 0xFFE3, 0x0005,
    0x0000, 0x0000, 0xFFE3, 0x0005, 0x0000, 0x0000, 0xFFE3, 0x0004,
    0x0000, 0x0000, 0xFFE3, 0x0004, 0x0000, 0x0000, 0xFFE3, 0x0004,
    0x0000, 0x0000, 0xFFE3, 0x0004, 0x0000, 0x0000, 0xFFE3, 0x0004,
    0x0000, 0x0000, 0xFFE3, 0x0003, 0x0000, 0x0000, 0xFFE3, 0x0003,
    0x0000, 0x0000, 0xFFE3, 0x0003, 0x0000, 0x0000, 0xFFE3, 0x0003,
    0x0000, 0x0000, 0xFFE3, 0x0003, 0x0000, 0x0000, 0xFFE3, 0x0003,
    0x0000, 0x0000, 0xFFE3, 0x0002, 0x0000, 0x0000, 0xFFE3, 0x0002,
    0x0000, 0x0000, 0xFFE3, 0x0002, 0x0000, 0x0000, 0xFFE3, 0x0002,
    0x0000, 0x0000, 0xFFE3, 0x0002, 0x0000, 0x0000, 0xFFE3, 0x0002,
    0x0000, 0x0000, 0xFFE3, 0x0001, 0x0000, 0x0000, 0xFFE3, 0x0001,
    0x0000, 0x0000, 0xFFE3, 0x0001, 0x0000, 0x0000, 0xFFE3, 0x0001,
    0x0000, 0x0000, 0xFFE3, 0x0001, 0x0000, 0x0000, 0xFFE3, 0x0000,
    0x0000, 0x0000, 0xFFE3, 0x0000, 0x0000, 0x0000, 0xFFE3, 0x0000,
    0x0000, 0x0000, 0xFFE3, 0x0000, 0x0000, 0x0000, 0xFFE3, 0x0000,
    0x0000, 0x0000, 0xFFE3, 0x0000, 0x0000, 0x0000, 0xFFE3, 0xFFFF,
    0x0000, 0x0000, 0xFFE3, 0xFFFF, 0x0000, 0x0000, 0xFFE3, 0xFFFF,
    0x0000, 0x0000, 0xFFE3, 0xFFFF, 0x0000, 0x0000, 0xFFE3, 0xFFFF,
    0x0000, 0x0000, 0xFFE3, 0xFFFE, 0x0000, 0x0000, 0xFFE3, 0xFFFE,
    0x0000, 0x0000, 0xFFE3, 0xFFFE, 0x0000, 0x0000, 0xFFE3, 0xFFFE,
    0x0000, 0x0000, 0xFFE3, 0xFFFE, 0x0000, 0x0000, 0xFFE3, 0xFFFE,
    0x0000, 0x0000, 0xFFE3, 0xFFFD, 0x0000, 0x0000, 0xFFE3, 0xFFFD,
    0x0000, 0x0000, 0xFFE3, 0xFFFD, 0x0000, 0x0000, 0xFFE3, 0xFFFD,
    0x0000, 0x0000, 0xFFE3, 0xFFFD, 0x0000, 0x0000, 0xFFE3, 0xFFFD,
    0x0000, 0x0000, 0xFFE3, 0xFFFC, 0x0000, 0x0000, 0xFFE3, 0xFFFC,
    0x0000, 0x0000, 0xFFE3, 0xFFFC, 0x0000, 0x0000, 0xFFE3, 0xFFFC,
    0x0000, 0x0000, 0xFFE3, 0xFFFC, 0x0000, 0x0000, 0xFFE3, 0xFFFB,
    0x0000, 0x0000, 0xFFE3, 0xFFFB, 0x0000, 0x0000, 0xFFE3, 0xFFFB,
    0x0000, 0x0000, 0xFFE3, 0xFFFB, 0x0000, 0x0000, 0xFFE3, 0xFFFB,
    0x0000, 0x0000, 0xFFE3, 0xFFFB, 0x0000, 0x0000, 0xFFE3, 0xFFFA,
    0x0000, 0x0000, 0xFFE3, 0xFFFA, 0x0000, 0x0000, 0xFFE3, 0xFFFA,
    0x0000, 0x0000, 0xFFE3, 0xFFFA, 0x0000, 0x0000, 0xFFE3, 0xFFFA,
    0x0000, 0x0000, 0xFFE3, 0xFFF9, 0x0000, 0x0000, 0xFFE3, 0xFFF9,
    0x0000, 0x0000, 0xFFE3, 0xFFF9, 0x0000, 0x0000, 0xFFE3, 0xFFF9,
    0x0000, 0x0000, 0xFFE3, 0xFFF9, 0x0000, 0x0000, 0xFFE3, 0xFFF9,
    0x0000, 0x0000, 0xFFE3, 0xFFF8, 0x0000, 0x0000, 0xFFE3, 0xFFF8,
    0x0000, 0x0000, 0xFFE3, 0xFFF8, 0x0000, 0x0000, 0xFFE3, 0xFFF8,
    0x0000, 0x0000, 0xFFE3, 0xFFF8, 0x0000, 0x0000, 0xFFE3, 0xFFF7,
    0x0000, 0x0000, 0xFFE3, 0xFFF7, 0x0000, 0x0000, 0xFFE3, 0xFFF7,
    0x0000, 0x0000, 0xFFE3, 0xFFF7, 0x0000, 0x0000, 0xFFE3, 0xFFF7,
    0x0000, 0x0000, 0xFFE3, 0xFFF6, 0x0000, 0x0000, 0xFFE3, 0xFFF6,
    0x0000, 0x0000, 0xFFE3, 0xFFF6, 0x0000, 0x0000, 0xFFE3, 0xFFF6,
    0x0000, 0x0000, 0xFFE3, 0xFFF6, 0x0000, 0x0000, 0xFFE3, 0xFFF5,
    0x0000, 0x0000, 0xFFE3, 0xFFF5, 0x0000, 0x0000, 0xFFE3, 0xFFF5,
    0x0000, 0x0000, 0xFFE3, 0xFFF5, 0x0000, 0x0000, 0xFFE3, 0xFFF5,
    0x0000, 0x0000, 0xFFE3, 0xFFF4, 0x0000, 0x0000, 0xFFE3, 0xFFF4,
    0x0000, 0x0000, 0xFFE3, 0xFFF4, 0x0000, 0x0000, 0xFFE3, 0xFFF4,
    0x0000, 0x0000, 0xFFE3, 0xFFF4, 0x0000, 0x0000, 0xFFE3, 0xFFF3,
    0x0000, 0x0000, 0xFFE3, 0xFFF3, 0x0000, 0x0000, 0xFFE3, 0xFFF3,
    0x0000, 0x0000, 0xFFE3, 0xFFF3, 0x0000, 0x0000, 0xFFE3, 0xFFF2,
    0x0000, 0x0000, 0xFFE3, 0xFFF2, 0x0000, 0x0000, 0xFFE3, 0xFFF2,
    0x0000, 0x0000, 0xFFE3, 0xFFF2, 0x0000, 0x0000, 0xFFE3, 0xFFF2,
    0x0000, 0x0000, 0xFFE3, 0xFFF1, 0x0000, 0x0000, 0xFFE3, 0xFFF1,
    0x0000, 0x0000, 0xFFE3, 0xFFF1, 0x0000, 0x0000, 0xFFE3, 0xFFF1,
    0x0000, 0x0000, 0xFFE3, 0xFFF0, 0x0000, 0x0000, 0xFFE3, 0xFFF0,
    0x0000, 0x0000, 0xFFE3, 0xFFF0, 0x0000, 0x0000, 0xFFE3, 0xFFF0,
    0x0000, 0x0000, 0xFFE3, 0xFFF0, 0x0000, 0x0000, 0xFFE3, 0xFFEF,
    0x0000, 0x0000, 0xFFE3, 0xFFEF, 0x0000, 0x0000, 0xFFE3, 0xFFEF,
    0x0000, 0x0000, 0xFFE3, 0xFFEF, 0x0000, 0x0000, 0xFFE3, 0xFFEE,
    0x0000, 0x0000, 0xFFE3, 0xFFEE, 0x0000, 0x0000, 0xFFE3, 0xFFEE,
    0x0000, 0x0000, 0xFFE3, 0xFFEE, 0x0000, 0x0000, 0xFFE3, 0xFFED,
    0x0000, 0x0000, 0xFFE3, 0xFFED, 0x0000, 0x0000, 0xFFE3, 0xFFED,
    0x0000, 0x0000, 0xFFE3, 0xFFED, 0x0000, 0x0000, 0xFFE3, 0xFFEC,
    0x0000, 0x0000, 0xFFE3, 0xFFEC, 0x0000, 0x0000, 0xFFE3, 0xFFEC,
    0x0000, 0x0000, 0xFFE3, 0xFFEC, 0x0000, 0x0000, 0xFFE3, 0xFFEB,
    0x0000, 0x0000, 0xFFE3, 0xFFEB, 0x0000, 0x0000, 0xFFE3, 0xFFEB,
    0x0000, 0x0000, 0xFFE3, 0xFFEB, 0x0000, 0x0000, 0xFFE3, 0xFFEA,
    0x0000, 0x0000, 0xFFE3, 0xFFEA, 0x0000, 0x0000, 0xFFE3, 0xFFEA,
    0x0000, 0x0000, 0xFFE3, 0xFFE9, 0x0000, 0x0000, 0xFFE3, 0xFFE9,
    0x0000, 0x0000, 0xFFE3, 0xFFE9, 0x0000, 0x0000, 0xFFE3, 0xFFE9,
    0x0000, 0x0000, 0xFFE3, 0xFFE8, 0x0000, 0x0000, 0xFFE3, 0xFFE8,
    0x0000, 0x0000, 0xFFE3, 0xFFE8, 0x0000, 0x0000, 0xFFE3, 0xFFE7,
    0x0000, 0x0000, 0xFFE3, 0xFFE7, 0x0000, 0x0000, 0xFFE3, 0xFFE7,
    0x0000, 0x0000, 0xFFE3, 0xFFE6, 0x0000, 0x0000, 0xFFE3, 0xFFE6,
    0x0000, 0x0000, 0xFFE3, 0xFFE6, 0x0000, 0x0000, 0xFFE3, 0xFFE5,
    0x0000, 0x0000, 0xFFE3, 0xFFE5, 0x0000, 0x0000, 0xFFE3, 0xFFE5,
    0x0000, 0x0000, 0xFFE3, 0xFFE4, 0x0000, 0x0000, 0xFFE3, 0xFFE4,
    0x0000, 0x0000, 0xFFE3, 0xFFE4, 0x0000, 0x0000, 0xFFE3, 0xFFE3,
    0x0000, 0x0000, 0xFFE3, 0xFFE3, 0x0000, 0x0000, 0xFFE3, 0xFFE3,
    0x0000, 0x0000, 0xFFE3, 0xFFE2, 0x0000, 0x0000, 0xFFE3, 0xFFE2,
    0x0000, 0x0000, 0xFFE3, 0xFFE2, 0x0000, 0x0000, 0xFFE3, 0xFFE1,
    0x0000, 0x0000, 0xFFE3, 0xFFE1, 0x0000, 0x0000, 0xFFE3, 0xFFE0,
    0x0000, 0x0000, 0xFFE3, 0xFFE0, 0x0000, 0x0000, 0xFFE3, 0xFFE0,
    0x0000, 0x0000, 0xFFE3, 0xFFDF, 0x0000, 0x0000, 0xFFE3, 0xFFDF,
    0x0000, 0x0000, 0xFFE3, 0xFFDE, 0x0000, 0x0000, 0xFFE3, 0xFFDE,
    0x0000, 0x0000, 0xFFE3, 0xFFDE, 0x0000, 0x0000, 0xFFE3, 0xFFDD,
    0x0000, 0x0000, 0xFFE3, 0xFFDD, 0x0000, 0x0000, 0xFFE3, 0xFFDC,
    0x0000, 0x0000, 0xFFE3, 0xFFDC, 0x0000, 0x0000, 0xFFE3, 0xFFDB,
    0x0000, 0x0000, 0xFFE3, 0xFFDB, 0x0000, 0x0000, 0xFFE3, 0xFFDA,
    0x0000, 0x0000, 0xFFE3, 0xFFDA, 0x0000, 0x0000, 0xFFE3, 0xFFD9,
    0x0000, 0x0000, 0xFFE3, 0xFFD9, 0x0000, 0x0000, 0xFFE3, 0xFFD8,
    0x0000, 0x0000, 0xFFE3, 0xFFD8, 0x0000, 0x0000, 0xFFE3, 0xFFD7,
    0x0000, 0x0000, 0xFFE3, 0xFFD7, 0x0000, 0x0000, 0xFFE3, 0xFFD6,
    0x0000, 0x0000, 0xFFE3, 0xFFD6, 0x0000, 0x0000, 0xFFE3, 0xFFD5,
    0x0000, 0x0000, 0xFFE3, 0xFFD5, 0x0000, 0x0000, 0xFFE3, 0xFFD4,
    0x0000, 0x0000, 0xFFE3, 0xFFD3, 0x0000, 0x0000, 0xFFE3, 0xFFD3,
    0x0000, 0x0000, 0xFFE3, 0xFFD2, 0x0000, 0x0000, 0xFFE3, 0xFFD2,
    0x0000, 0x0000, 0xFFE3, 0xFFD1, 0x0000, 0x0000, 0xFFE3, 0xFFD0,
    0x0000, 0x0000, 0xFFE3, 0xFFD0, 0x0000, 0x0000, 0xFFE3, 0xFFCF,
    0x0000, 0x0000, 0xFFE3, 0xFFCE, 0x0000, 0x0000, 0xFFE3, 0xFFCE,
    0x0000, 0x0000, 0xFFE3, 0xFFCD, 0x0000, 0x0000, 0xFFE3, 0xFFCC,
    0x0000, 0x0000, 0xFFE3, 0xFFCB, 0x0000, 0x0000, 0xFFE3, 0xFFCB,
    0x0000, 0x0000, 0xFFE3, 0xFFCA, 0x0000, 0x0000, 0xFFE3, 0xFFC9,
    0x0000, 0x0000, 0xFFE3, 0xFFC8, 0x0000, 0x0000, 0xFFE3, 0xFFC7,
    0x0000, 0x0000, 0xFFE3, 0xFFC6, 0x0000, 0x0000, 0xFFE3, 0xFFC5,
    0x0000, 0x0000, 0xFFE3, 0xFFC5, 0x0000, 0x0000, 0xFFE3, 0xFFC4,
    0x0000, 0x0000, 0xFFE3, 0xFFC3, 0x0000, 0x0000, 0xFFE3, 0xFFC2,
    0x0000, 0x0000, 0xFFE3, 0xFFC1, 0x0000, 0x0000, 0xFFE3, 0xFFC0,
    0x0000, 0x0000, 0xFFE3, 0xFFBE, 0x0000, 0x0000, 0xFFE3, 0xFFBD,
    0x0000, 0x0000, 0xFFE3, 0xFFBC, 0x0000, 0x0000, 0xFFE3, 0xFFBB,
    0x0000, 0x0000, 0xFFE3, 0xFFBA, 0x0000, 0x0000, 0xFFE3, 0xFFB9,
    0x0000, 0x0000, 0xFFE3, 0xFFB7, 0x0000, 0x0000, 0xFFE3, 0xFFB6,
    0x0000, 0x0000, 0xFFE3, 0xFFB5, 0x0000, 0x0000, 0xFFE3, 0xFFB3,
    0x0000, 0x0000, 0xFFE3, 0xFFB2, 0x0000, 0x0000, 0xFFE3, 0xFFB0,
    0x0000, 0x0000, 0xFFE3, 0xFFAF, 0x0000, 0x0000, 0xFFE3, 0xFFAD,
    0x0000, 0x0000, 0xFFE3, 0xFFAB, 0x0000, 0x0000, 0xFFE3, 0xFFAA,
    0x0000, 0x0000, 0xFFE3, 0xFFA8, 0x0000, 0x0000, 0xFFE3, 0xFFA6,
    0x0000, 0x0000, 0xFFE3, 0xFFA4, 0x0000, 0x0000, 0xFFE3, 0xFFA2,
    0x0000, 0x0000, 0xFFE3, 0xFFA0, 0x0000, 0x0000, 0xFFE3, 0xFF9E,
    0x0000, 0x0000, 0xFFE3, 0xFF9C, 0x0000, 0x0000, 0xFFE3, 0xFF99,
    0x0000, 0x0000, 0xFFE3, 0xFF97, 0x0000, 0x0000, 0xFFE3, 0xFF94,
    0x0000, 0x0000, 0xFFE3, 0xFF91, 0x0000, 0x0000, 0xFFE3, 0xFF8F,
    0x0000, 0x0000, 0xFFE3, 0xFF8C, 0x0000, 0x0000, 0xFFE3, 0xFF88,
    0x0000, 0x0000, 0xFFE3, 0xFF85, 0x0000, 0x0000, 0xFFE3, 0xFF82,
    0x0000, 0x0000, 0xFFE3, 0xFF7E, 0x0000, 0x0000, 0xFFE3, 0xFF7A,
    0x0000, 0x0000, 0xFFE3, 0xFF76, 0x0000, 0x0000, 0xFFE3, 0xFF71,
    0x0000, 0x0000, 0xFFE3, 0xFF6D, 0x0000, 0x0000, 0xFFE3, 0xFF68,
    0x0000, 0x0000, 0xFFE3, 0xFF63, 0x0000, 0x0000, 0xFFE3, 0xFF5D,
    0x0000, 0x0000, 0xFFE3, 0xFF57, 0x0000, 0x0000, 0xFFE3, 0xFF50,
    0x0000, 0x0000, 0xFFE3, 0xFF49, 0x0000, 0x0000, 0xFFE3, 0xFF42,
    0x0000, 0x0000, 0xFFE3, 0xFF3A, 0x0000, 0x0000, 0xFFE3, 0xFF31,
    0x0000, 0x0000, 0xFFE3, 0xFF27, 0x0000, 0x0000, 0xFFE3, 0xFF1C,
    0x0000, 0x0000, 0xFFE3, 0xFF10, 0x0000, 0x0000, 0xFFE3, 0xFF03,
    0x0000, 0x0000, 0xFFE3, 0xFEF5, 0x0000, 0x0000, 0xFFE3, 0xFEE5,
    0x0000, 0x0000, 0xFFE3, 0xFED2, 0x0000, 0x0000, 0xFFE3, 0xFEBD,
    0x0000, 0x0000, 0xFFE3, 0xFEA5, 0x0000, 0x0000, 0xFFE3, 0xFE89,
    0x0000, 0x0000, 0xFFE3, 0xFE69, 0x0000, 0x0000, 0xFFE3, 0xFE42,
    0x0000, 0x0000, 0xFFE3, 0xFE12, 0x0000, 0x0000, 0xFFE3, 0xFDD8,
    0x0000, 0x0000, 0xFFE3, 0xFD8F, 0x0000, 0x0000, 0xFFE3, 0xFD2E,
    0x0000, 0x0000, 0xFFE3, 0xFCAB, 0x0000, 0x0000, 0xFFE3, 0xFBED,
    0x0000, 0x0000, 0xFFE3, 0xFAC3, 0x0000, 0x0000, 0xFFE3, 0xF8AB,
    0x0000, 0x0000, 0xFFE3, 0xF3C7, 0x0000, 0x0000, 0xFFE3, 0xDB55
    };

static const q15_t ref_cfft_step_1024[2048] = {
    0x399A, 0x0000, 0xFFE3, 0x24AB, 0x0000, 0x0000, 0xFFE3, 0x0C39,
    0x0000, 0x0000, 0xFFE3, 0x0755, 0x0000, 0x0000, 0xFFE3, 0x053D,
    0x0000, 0x0000, 0xFFE3, 0x0413, 0x0000, 0x0000, 0xFFE3, 0x0355,
    0x0000, 0x0000, 0xFFE3, 0x02D2, 0x0000, 0x0000, 0xFFE3, 0x0271,
    0x0000, 0x0000, 0xFFE3, 0x0228, 0x0000, 0x0000, 0xFFE3, 0x01EE,
    0x0000, 0x0000, 0xFFE3, 0x01BE, 0x0000, 0x0000, 0xFFE3, 0x0197,
    0x0000, 0x0000, 0xFFE3, 0x0177, 0x0000, 0x0000, 0xFFE3, 0x015B,
    0x0000, 0x0000, 0xFFE3, 0x0143, 0x0000, 0x0000, 0xFFE3, 0x012E,
    0x0000, 0x0000, 0xFFE3, 0x011B, 0x0000, 0x0000, 0xFFE3, 0x010B,
    0x0000, 0x0000, 0xFFE3, 0x00FD, 0x0000, 0x0000, 0xFFE3, 0x00F0,
    0x0000, 0x0000, 0xFFE3, 0x00E4, 0x0000, 0x0000, 0xFFE3, 0x00D9,
    0x0000, 0x0000, 0xFFE3, 0x00CF, 0x0000, 0x0000, 0xFFE3, 0x00C6,
    0x0000, 0x0000, 0xFFE3, 0x00BE, 0x0000, 0x0000, 0xFFE3, 0x00B7,
    0x0000, 0x0000, 0xFFE3, 0x00B0, 0x0000, 0x0000, 0xFFE3, 0x00A9,
    0x0000, 0x0000, 0xFFE3, 0x00A3, 0x0000, 0x0000, 0xFFE3, 0x009D,
    0x0000, 0x0000, 0xFFE3, 0x0098, 0x0000, 0x0000, 0xFFE3, 0x0093,
    0x0000, 0x0000, 0xFFE3, 0x008F, 0x0000, 0x0000, 0xFFE3, 0x008A,
    0x0000, 0x0000, 0xFFE3, 0x0086, 0x0000, 0x0000, 0xFFE3, 0x0082,
    0x0000, 0x0000, 0xFFE3, 0x007E, 0x0000, 0x0000, 0xFFE3, 0x007B,
    0x0000, 0x0000, 0xFFE3, 0x0078, 0x0000, 0x0000, 0xFFE3, 0x0074,
    0x0000, 0x0000, 0xFFE3, 0x0071, 0x0000, 0x0000, 0xFFE3, 0x006F,
    0x0000, 0x0000, 0xFFE3, 0x006C, 0x0000, 0x0000, 0xFFE3, 0x0069,
    0x0000, 0x0000, 0xFFE3, 0x0067, 0x0000, 0x0000, 0xFFE3, 0x0064,
    0x0000, 0x0000, 0xFFE3, 0x0062, 0x0000, 0x0000, 0xFFE3, 0x0060,
    0x0000, 0x0000, 0xFFE3, 0x005E, 0x0000, 0x0000, 0xFFE3, 0x005C,
    0x0000, 0x0000, 0xFFE3, 0x005A, 0x0000, 0x0000, 0xFFE3, 0x0058,
    0x0000, 0x0000, 0xFFE3, 0x0056, 0x0000, 0x0000, 0xFFE3, 0x0055,
    0x0000, 0x0000, 0xFFE3, 0x0053, 0x0000, 0x0000, 0xFFE3, 0x0051,
    0x0000, 0x0000, 0xFFE3, 0x0050, 0x0000, 0x0000, 0xFFE3, 0x004E,
    0x0000, 0x0000, 0xFFE3, 0x004D, 0x0000, 0x0000, 0xFFE3, 0x004B,
    0x0000, 0x0000, 0xFFE3, 0x004A, 0x0000, 0x0000, 0xFFE3, 0x0049,
    0x0000, 0x0000, 0xFFE3, 0x0047, 0x0000, 0x0000, 0xFFE3, 0x0046,
    0x0000, 0x0000, 0xFFE3, 0x0045, 0x0000, 0x0000, 0xFFE3, 0x0044,
    0x0000, 0x0000, 0xFFE3, 0x0043, 0x0000, 0x0000, 0xFFE3, 0x0042,
    0x0000, 0x0000, 0xFFE3, 0x0040, 0x0000, 0x0000, 0xFFE3, 0x003F,
    0x0000, 0x0000, 0xFFE3, 0x003E, 0x0000, 0x0000, 0xFFE3, 0x003D,
    0x0000, 0x0000, 0xFFE3, 0x003C, 0x0000, 0x0000, 0xFFE3, 0x003B,
    0x0000, 0x0000, 0xFFE3, 0x003B, 0x0000, 0x0000, 0xFFE3, 0x003A,
    0x0000, 0x0000, 0xFFE3, 0x0039, 0x0000, 0x0000, 0xFFE3, 0x0038,
    0x0000, 0x0000, 0xFFE3, 0x0037, 0x0000, 0x0000, 0xFFE3, 0x0036,
    0x0000, 0x0000, 0xFFE3, 0x0035, 0x0000, 0x0000, 0xFFE3, 0x0035,
    0x0000, 0x0000, 0xFFE3, 0x0034, 0x0000, 0x0000, 0xFFE3, 0x0033,
    0x0000, 0x0000, 0xFFE3, 0x0032, 0x0000, 0x0000, 0xFFE3, 0x0032,
    0x0000, 0x0000, 0xFFE3, 0x0031, 0x0000, 0x0000, 0xFFE3, 0x0030,
    0x0000, 0x0000, 0xFFE3, 0x0030, 0x0000, 0x0000, 0xFFE3, 0x002F,
    0x0000, 0x0000, 0xFFE3, 0x002E, 0x0000, 0x0000, 0xFFE3, 0x002E,
    0x0000, 0x0000, 0xFFE3, 0x002D, 0x0000, 0x0000, 0xFFE3, 0x002D,
    0x0000, 0x0000, 0xFFE3, 0x002C, 0x0000, 0x0000, 0xFFE3, 0x002B,
    0x0000, 0x0000, 0xFFE3, 0x002B, 0x0000, 0x0000, 0xFFE3, 0x002A,
    0x0000, 0x0000, 0xFFE3, 0x002A, 0x0000, 0x0000, 0xFFE3, 0x0029,
    0x0000, 0x0000, 0xFFE3, 0x0029, 0x0000, 0x0000, 0xFFE3, 0x0028,
    0x0000, 0x0000, 0xFFE3, 0x0028, 0x0000, 0x0000, 0xFFE3, 0x0027,
    0x0000, 0x0000, 0xFFE3, 0x0027, 0x0000, 0x0000, 0xFFE3, 0x0026,
    0x0000, 0x0000, 0xFFE3, 0x0026, 0x0000, 0x0000, 0xFFE3, 0x0025,
    0x0000, 0x0000, 0xFFE3, 0x0025, 0x0000, 0x0000, 0xFFE3, 0x0024,
    0x0000, 0x0000, 0xFFE3, 0x0024, 0x0000, 0x0000, 0xFFE3, 0x0023,
    0x0000, 0x0000, 0xFFE3, 0x0023, 0x0000, 0x0000, 0xFFE3, 0x0022,
    0x0000, 0x0000, 0xFFE3, 0x0022, 0x0000, 0x0000, 0xFFE3, 0x0022,
    0x0000, 0x0000, 0xFFE3, 0x0021, 0x0000, 0x0000, 0xFFE3, 0x0021,
    0x0000, 0x0000, 0xFFE3, 0x0020, 0x0000, 0x0000, 0xFFE3, 0x0020,
    0x0000, 0x0000, 0xFFE3, 0x0020, 0x0000, 0x0000, 0xFFE3, 0x001F,
    0x0000, 0x0000, 0xFFE3, 0x001F, 0x0000, 0x0000, 0xFFE3, 0x001E,
    0x0000, 0x0000, 0xFFE3, 0x001E, 0x0000, 0x0000, 0xFFE3, 0x001E,
    0x0000, 0x0000, 0xFFE3, 0x001D, 0x0000, 0x0000, 0xFFE3, 0x001D,
    0x0000, 0x0000, 0xFFE3, 0x001D, 0x0000, 0x0000, 0xFFE3, 0x001C,
    0x0000, 0x0000, 0xFFE3, 0x001C, 0x0000, 0x0000, 0xFFE3, 0x001C,
    0x0000, 0x0000, 0xFFE3, 0x001B, 0x0000, 0x0000, 0xFFE3, 0x001B,
    0x0000, 0x0000, 0xFFE3, 0x001B, 0x0000, 0x0000, 0xFFE3, 0x001A,
    0x0000, 0x0000, 0xFFE3, 0x001A, 0x0000, 0x0000, 0xFFE3, 0x001A,
    0x0000, 0x0000, 0xFFE3, 0x0019, 0x0000, 0x0000, 0xFFE3, 0x0019,
    0x0000, 0x0000, 0xFFE3, 0x0019, 0x0000, 0x0000, 0xFFE3, 0x0018,
    0x0000, 0x0000, 0xFFE3, 0x0018, 0x0000, 0x0000, 0xFFE3, 0x0018,
    0x0000, 0x0000, 0xFFE3, 0x0017, 0x0000, 0x0000, 0xFFE3, 0x0017,
    0x0000, 0x0000, 0xFFE3, 0x0017, 0x0000, 0x0000, 0xFFE3, 0x0017,
    0x0000, 0x0000, 0xFFE3, 0x0016, 0x0000, 0x0000, 0xFFE3, 0x0016,
    0x0000, 0x0000, 0xFFE3, 0x0016, 0x0000, 0x0000, 0xFFE3, 0x0015,
    0x0000, 0x0000, 0xFFE3, 0x0015, 0x0000, 0x0000, 0xFFE3, 0x0015,
    0x0000, 0x0000, 0xFFE3, 0x0015, 0x0000, 0x0000, 0xFFE3, 0x0014,
    0x0000, 0x0000, 0xFFE3, 0x0014, 0x0000, 0x0000, 0xFFE3, 0x0014,
    0x0000, 0x0000, 0xFFE3, 0x0014, 0x0000, 0x0000, 0xFFE3, 0x0013,
    0x0000, 0x0000, 0xFFE3, 0x0013, 0x0000, 0x0000, 0xFFE3, 0x0013,
    0x0000, 0x0000, 0xFFE3, 0x0013, 0x0000, 0x0000, 0xFFE3, 0x0012,
    0x0000, 0x0000, 0xFFE3, 0x0012, 0x0000, 0x0000, 0xFFE3, 0x0012,
    0x0000, 0x0000, 0xFFE3, 0x0012, 0x0000, 0x0000, 0xFFE3, 0x0011,
    0x0000, 0x0000, 0xFFE3, 0x0011, 0x0000, 0x0000, 0xFFE3, 0x0011,
    0x0000, 0x0000, 0xFFE3, 0x0011, 0x0000, 0x0000, 0xFFE3, 0x0010,
    0x0000, 0x0000, 0xFFE3, 0x0010, 0x0000, 0x0000, 0xFFE3, 0x0010,
    0x0000, 0x0000, 0xFFE3, 0x0010, 0x0000, 0x0000, 0xFFE3, 0x0010,
    0x0000, 0x0000, 0xFFE3, 0x000F, 0x0000, 0x0000, 0xFFE3, 0x000F,
    0x0000, 0x0000, 0xFFE3, 0x000F, 0x0000, 0x0000, 0xFFE3, 0x000F,
    0x0000, 0x0000, 0xFFE3, 0x000E, 0x0000, 0x0000, 0xFFE3, 0x000E,
    0x0000, 0x0000, 0xFFE3, 0x000E, 0x0000, 0x0000, 0xFFE3, 0x000E,
    0x0000, 0x0000, 0xFFE3, 0x000E, 0x0000, 0x0000, 0xFFE3, 0x000D,
    0x0000, 0x0000, 0xFFE3, 0x000D, 0x0000, 0x0000, 0xFFE3, 0x000D,
    0x0000, 0x0000, 0xFFE3, 0x000D, 0x0000, 0x0000, 0xFFE3, 0x000C,
    0x0000, 0x0000, 0xFFE3, 0x000C, 0x0000, 0x0000, 0xFFE3, 0x000C,
    0x0000, 0x0000, 0xFFE3, 0x000C, 0x0000, 0x0000, 0xFFE3, 0x000C,
    0x0000, 0x0000, 0xFFE3, 0x000B, 0x0000, 0x0000, 0xFFE3, 0x000B,
    0x0000, 0x0000, 0xFFE3, 0x000B, 0x0000, 0x0000, 0xFFE3, 0x000B,
    0x0000, 0x0000, 0xFFE3, 0x000B, 0x0000, 0x0000, 0xFFE3, 0x000A,
    0x0000, 0x0000, 0xFFE3, 0x000A, 0x0000, 0x0000, 0xFFE3, 0x000A,
    0x0000, 0x0000, 0xFFE3, 0x000A, 0x0000, 0x0000, 0xFFE3, 0x000A,
    0x0000, 0x0000, 0xFFE3, 0x0009, 0x0000, 0x0000, 0xFFE3, 0x0009,
    0x0000, 0x0000, 0xFFE3, 0x0009, 0x0000, 0x0000, 0xFFE3, 0x0009,
    0x0000, 0x0000, 0xFFE3, 0x0009, 0x0000, 0x0000, 0xFFE3, 0x0008,
    0x0000, 0x0000, 0xFFE3, 0x0008, 0x0000, 0x0000, 0xFFE3, 0x0008,
    0x0000, 0x0000, 0xFFE3, 0x0008, 0x0000, 0x0000, 0xFFE3, 0x0008,
    0x0000, 0x0000, 0xFFE3, 0x0007, 0x0000, 0x0000, 0xFFE3, 0x0007,
    0x0000, 0x0000, 0xFFE3, 0x0007, 0x0000, 0x0000, 0xFFE3, 0x0007,
    0x0000, 0x0000, 0xFFE3, 0x0007, 0x0000, 0x0000, 0xFFE3, 0x0007,
    0x0000, 0x0000, 0xFFE3, 0x0006, 0x0000, 0x0000, 0xFFE3, 0x0006,
    0x0000, 0x0000, 0xFFE3, 0x0006, 0x0000, 0x0000, 0xFFE3, 0x0006,
    0x0000, 0x0000, 0xFFE3, 0x0006, 0x0000, 0x0000, 0xFFE3, 0x0005,
    0x0000, 0x0000, 0xFFE3, 0x0005, 0x0000, 0x0000, 0xFFE3, 0x0005,
    0x0000, 0x0000, 0xFFE3, 0x0005, 0x0000, 0x0000, 0xFFE3, 0x0005,
    0x0000, 0x0000, 0xFFE3, 0x0005, 0x0000, 0x0000, 0xFFE3, 0x0004,
    0x0000, 0x0000, 0xFFE3, 0x0004, 0x0000, 0x0000, 0xFFE3, 0x0004,
    0x0000, 0x0000, 0xFFE3, 0x0004, 0x0000, 0x0000, 0xFFE3, 0x0004,
    0x0000, 0x0000, 0xFFE3, 0x0003, 0x0000, 0x0000, 0xFFE3, 0x0003,
    0x0000, 0x0000, 0xFFE3, 0x0003, 0x0000, 0x0000, 0xFFE3, 0x0003,
    0x0000, 0x0000, 0xFFE3, 0x0003, 0x0000, 0x0000, 0xFFE3, 0x0003,
    0x0000, 0x0000, 0xFFE3, 0x0002, 0x0000, 0x0000, 0xFFE3, 0x0002,
    0x0000, 0x0000, 0xFFE3, 0x0002, 0x0000, 0x0000, 0xFFE3, 0x0002,
    0x0000, 0x0000, 0xFFE3, 0x0002, 0x0000, 0x0000, 0xFFE3, 0x0002,
    0x0000, 0x0000, 0xFFE3, 0x0001, 0x0000, 0x0000, 0xFFE3, 0x0001,
    0x0000, 0x0000, 0xFFE3, 0x0001, 0x0000, 0x0000, 0xFFE3, 0x0001,
    0x0000, 0x0000, 0xFFE3, 0x0001, 0x0000, 0x0000, 0xFFE3, 0x0000,
    0x0000, 0x0000, 0xFFE3, 0x0000, 0x0000, 0x0000, 0xFFE3, 0x0000,
    0x0000, 0x0000, 0xFFE3, 0x0000, 0x0000, 0x0000, 0xFFE3, 0x0000,
    0x0000, 0x0000, 0xFFE3, 0x0000, 0x0000, 0x0000, 0xFFE3, 0xFFFF,
    0x0000, 0x0000, 0xFFE3, 0xFFFF, 0x0000, 0x0000, 0xFFE3, 0xFFFF,
    0x0000, 0x0000, 0xFFE3, 0xFFFF, 0x0000, 0x0000, 0xFFE3, 0xFFFF,
    0x0000, 0x0000, 0xFFE3, 0xFFFE, 0x0000, 0x0000, 0xFFE3, 0xFFFE,
    0x0000, 0x0000, 0xFFE3, 0xFFFE, 0x0000, 0x0000, 0xFFE3, 0xFFFE,
    0x0000, 0x0000, 0xFFE3, 0xFFFE, 0x0000, 0x0000, 0xFFE3, 0xFFFE,
    0x0000, 0x0000, 0xFFE3, 0xFFFD, 0x0000, 0x0000, 0xFFE3, 0xFFFD,
    0x0000, 0x0000, 0xFFE3, 0xFFFD, 0x0000, 0x0000, 0xFFE3, 0xFFFD,
    0x0000, 0x0000, 0xFFE3, 0xFFFD, 0x0000, 0x0000, 0xFFE3, 0xFFFD,
    0x0000, 0x0000, 0xFFE3, 0xFFFC, 0x0000, 0x0000, 0xFFE3, 0xFFFC,
    0x0000, 0x0000, 0xFFE3, 0xFFFC, 0x0000, 0x0000, 0xFFE3, 0xFFFC,
    0x0000, 0x0000, 0xFFE3, 0xFFFC, 0x0000, 0x0000, 0xFFE3, 0xFFFB,
    0x0000, 0x0000, 0xFFE3, 0xFFFB, 0x0000, 0x0000, 0xFFE3, 0xFFFB,
    0x0000, 0x0000, 0xFFE3, 0xFFFB, 0x0000, 0x0000, 0xFFE3, 0xFFFB,
    0x0000, 0x0000, 0xFFE3, 0xFFFB, 0x0000, 0x0000, 0xFFE3, 0xFFFA,
    0x0000, 0x0000, 0xFFE3, 0xFFFA, 0x0000, 0x0000, 0xFFE3, 0xFFFA,
    0x0000, 0x0000, 0xFFE3, 0xFFFA, 0x0000, 0x0000, 0xFFE3, 0xFFFA,
    0x0000, 0x0000, 0xFFE3, 0xFFF9, 0x0000, 0x0000, 0xFFE3, 0xFFF9,
    0x0000, 0x0000, 0xFFE3, 0xFFF9, 0x0000, 0x0000, 0xFFE3, 0xFFF9,
    0x0000, 0x0000, 0xFFE3, 0xFFF9, 0x0000, 0x0000, 0xFFE3, 0xFFF9,
    0x0000, 0x0000, 0xFFE3, 0xFFF8, 0x0000, 0x0000, 0xFFE3, 0xFFF8,
    0x0000, 0x0000, 0xFFE3, 0xFFF8, 0x0000, 0x0000, 0xFFE3, 0xFFF8,
    0x0000, 0x0000, 0xFFE3, 0xFFF8, 0x0000, 0x0000, 0xFFE3, 0xFFF7,
    0x0000, 0x0000, 0xFFE3, 0xFFF7, 0x0000, 0x0000, 0xFFE3, 0xFFF7,
    0x0000, 0x0000, 0xFFE3, 0xFFF7, 0x0000, 0x0000, 0xFFE3, 0xFFF7,
    0x0000, 0x0000, 0xFFE3, 0xFFF6, 0x0000, 0x0000, 0xFFE3, 0xFFF6,
    0x0000, 0x0000, 0xFFE3, 0xFFF6, 0x0000, 0x0000, 0xFFE3, 0xFFF6,
    0x0000, 0x0000, 0xFFE3, 0xFFF6, 0x0000, 0x0000, 0xFFE3, 0xFFF5,
    0x0000, 0x0000, 0xFFE3, 0xFFF5, 0x0000, 0x0000, 0xFFE3, 0xFFF5,
    0x0000, 0x0000, 0xFFE3, 0xFFF5, 0x0000, 0x0000, 0xFFE3, 0xFFF5,
    0x0000, 0x0000, 0xFFE3, 0xFFF4, 0x0000, 0x0000, 0xFFE3, 0xFFF4,
    0x0000, 0x0000, 0xFFE3, 0xFFF4, 0x0000, 0x0000, 0xFFE3, 0xFFF4,
    0x0000, 0x0000, 0xFFE3, 0xFFF4, 0x0000, 0x0000, 0xFFE3, 0xFFF3,
    0x0000, 0x0000, 0xFFE3, 0xFFF3, 0x0000, 0x0000, 0xFFE3, 0xFFF3,
    0x0000, 0x0000, 0xFFE3, 0xFFF3, 0x0000, 0x0000, 0xFFE3, 0xFFF2,
    0x0000, 0x0000, 0xFFE3, 0xFFF2, 0x0000, 0x0000, 0xFFE3, 0xFFF2,
    0x0000, 0x0000, 0xFFE3, 0xFFF2, 0x0000, 0x0000, 0xFFE3, 0xFFF2,
    0x0000, 0x0000, 0xFFE3, 0xFFF1, 0x0000, 0x0000, 0xFFE3, 0xFFF1,
    0x0000, 0x0000, 0xFFE3, 0xFFF1, 0x0000, 0x0000, 0xFFE3, 0xFFF1,
    0x0000, 0x0000, 0xFFE3, 0xFFF0, 0x0000, 0x0000, 0xFFE3, 0xFFF0,
    0x0000, 0x0000, 0xFFE3, 0xFFF0, 0x0000, 0x0000, 0xFFE3, 0xFFF0,
    0x0000, 0x0000, 0xFFE3, 0xFFF0, 0x0000, 0x0000, 0xFFE3, 0xFFEF,
    0x0000, 0x0000, 0xFFE3, 0xFFEF, 0x0000, 0x0000, 0xFFE3, 0xFFEF,
    0x0000, 0x0000, 0xFFE3, 0xFFEF, 0x0000, 0x0000, 0xFFE3, 0xFFEE,
    0x0000, 0x0000, 0xFFE3, 0xFFEE, 0x0000, 0x0000, 0xFFE3, 0xFFEE,
    0x0000, 0x0000, 0xFFE3, 0xFFEE, 0x0000, 0x0000, 0xFFE3, 0xFFED,
    0x0000, 0x0000, 0xFFE3, 0xFFED, 0x0000, 0x0000, 0xFFE3, 0xFFED,
    0x0000, 0x0000, 0xFFE3, 0xFFED, 0x0000, 0x0000, 0xFFE3, 0xFFEC,
    0x0000, 0x0000, 0xFFE3, 0xFFEC, 0x0000, 0x0000, 0xFFE3, 0xFFEC,
    0x0000, 0x0000, 0xFFE3, 0xFFEC, 0x0000, 0x0000, 0xFFE3, 0xFFEB,
    0x0000, 0x0000, 0xFFE3, 0xFFEB, 0x0000, 0x0000, 0xFFE3, 0xFFEB,
    0x0000, 0x0000, 0xFFE3, 0xFFEB, 0x0000, 0x0000, 0xFFE3, 0xFFEA,
    0x0000, 0x0000, 0xFFE3, 0xFFEA, 0x0000, 0x0000, 0xFFE3, 0xFFEA,
    0x0000, 0x0000, 0xFFE3, 0xFFE9, 0x0000, 0x0000, 0xFFE3, 0xFFE9,
    0x0000, 0x0000, 0xFFE3, 0xFFE9, 0x0000, 0x0000, 0xFFE3, 0xFFE9,
    0x0000, 0x0000, 0xFFE3, 0xFFE8, 0x0000, 0x0000, 0xFFE3, 0xFFE8,
    0x0000, 0x0000, 0xFFE3, 0xFFE8, 0x0000, 0x0000, 0xFFE3, 0xFFE7,
    0x0000, 0x0000, 0xFFE3, 0xFFE7, 0x0000, 0x0000, 0xFFE3, 0xFFE7,
    0x0000, 0x0000, 0xFFE3, 0xFFE6, 0x0000, 0x0000, 0xFFE3, 0xFFE6,
    0x0000, 0x0000, 0xFFE3, 0xFFE6, 0x0000, 0x0000, 0xFFE3, 0xFFE5,
    0x0000, 0x0000, 0xFFE3, 0xFFE5, 0x0000, 0x0000, 0xFFE3, 0xFFE5,
    0x0000, 0x0000, 0xFFE3, 0xFFE4, 0x0000, 0x0000, 0xFFE3, 0xFFE4,
    0x0000, 0x0000, 0xFFE3, 0xFFE4, 0x0000, 0x0000, 0xFFE3, 0xFFE3,
    0x0000, 0x0000, 0xFFE3, 0xFFE3, 0x0000, 0x0000, 0xFFE3, 0xFFE3,
    0x0000, 0x0000, 0xFFE3, 0xFFE2, 0x0000, 0x0000, 0xFFE3, 0xFFE2,
    0x0000, 0x0000, 0xFFE3, 0xFFE2, 0x0000, 0x0000, 0xFFE3, 0xFFE1,
    0x0000, 0x0000, 0xFFE3, 0xFFE1, 0x0000, 0x0000, 0xFFE3, 0xFFE0,
    0x0000, 0x0000, 0xFFE3, 0xFFE0, 0x0000, 0x0000, 0xFFE3, 0xFFE0,
    0x0000, 0x0000, 0xFFE3, 0xFFDF, 0x0000, 0x0000, 0xFFE3, 0xFFDF,
    0x0000, 0x0000, 0xFFE3, 0xFFDE, 0x0000, 0x0000, 0xFFE3, 0xFFDE,
    0x0000, 0x0000, 0xFFE3, 0xFFDE, 0x0000, 0x0000, 0xFFE3, 0xFFDD,
    0x0000, 0x0000, 0xFFE3, 0xFFDD, 0x0000, 0x0000, 0xFFE3, 0xFFDC,
    0x0000, 0x0000, 0xFFE3, 0xFFDC, 0x0000, 0x0000, 0xFFE3, 0xFFDB,
    0x0000, 0x0000, 0xFFE3, 0xFFDB, 0x0000, 0x0000, 0xFFE3, 0xFFDA,
    0x0000, 0x0000, 0xFFE3, 0xFFDA, 0x0000, 0x0000, 0xFFE3, 0xFFD9,
    0x0000, 0x0000, 0xFFE3, 0xFFD9, 0x0000, 0x0000, 0xFFE3, 0xFFD8,
    0x0000, 0x0000, 0xFFE3, 0xFFD8, 0x0000, 0x0000, 0xFFE3, 0xFFD7,
    0x0000, 0x0000, 0xFFE3, 0xFFD7, 0x0000, 0x0000, 0xFFE3, 0xFFD6,
    0x0000, 0x0000, 0xFFE3, 0xFFD6, 0x0000, 0x0000, 0xFFE3, 0xFFD5,
    0x0000, 0x0000, 0xFFE3, 0xFFD5, 0x0000, 0x0000, 0xFFE3, 0xFFD4,
    0x0000, 0x0000, 0xFFE3, 0xFFD3, 0x0000, 0x0000, 0xFFE3, 0xFFD3,
    0x0000, 0x0000, 0xFFE3, 0xFFD2, 0x0000, 0x0000, 0xFFE3, 0xFFD2,
    0x0000, 0x0000, 0xFFE3, 0xFFD1, 0x0000, 0x0000, 0xFFE3, 0xFFD0,
    0x0000, 0x0000, 0xFFE3, 0xFFD0, 0x0000, 0x0000, 0xFFE3, 0xFFCF,
    0x0000, 0x0000, 0xFFE3, 0xFFCE, 0x0000, 0x0000, 0xFFE3, 0xFFCE,
    0x0000, 0x0000, 0xFFE3, 0xFFCD, 0x0000, 0x0000, 0xFFE3, 0xFFCC,
    0x0000, 0x0000, 0xFFE3, 0xFFCB, 0x0000, 0x0000, 0xFFE3, 0xFFCB,
    0x0000, 0x0000, 0xFFE3, 0xFFCA, 0x0000, 0x0000, 0xFFE3, 0xFFC9,
    0x0000, 0x0000, 0xFFE3, 0xFFC8, 0x0000, 0x0000, 0xFFE3, 0xFFC7,
    0x0000, 0x0000, 0xFFE3, 0xFFC6, 0x0000, 0x0000, 0xFFE3, 0xFFC5,
    0x0000, 0x0000, 0xFFE3, 0xFFC5, 0x0000, 0x0000, 0xFFE3, 0xFFC4,
    0x0000, 0x0000, 0xFFE3, 0xFFC3, 0x0000, 0x0000, 0xFFE3, 0xFFC2,
    0x0000, 0x0000, 0xFFE3, 0xFFC1, 0x0000, 0x0000, 0xFFE3, 0xFFC0,
    0x0000, 0x0000, 0xFFE3, 0xFFBE, 0x0000, 0x0000, 0xFFE3, 0xFFBD,
    0x0000, 0x0000, 0xFFE3, 0xFFBC, 0x0000, 0x0000, 0xFFE3, 0xFFBB,
    0x0000, 0x0000, 0xFFE3, 0xFFBA, 0x0000, 0x0000, 0xFFE3, 0xFFB9,
    0x0000, 0x0000, 0xFFE3, 0xFFB7, 0x0000, 0x0000, 0xFFE3, 0xFFB6,
    0x0000, 0x0000, 0xFFE3, 0xFFB5, 0x0000, 0x0000, 0xFFE3, 0xFFB3,
    0x0000, 0x0000, 0xFFE3, 0xFFB2, 0x0000, 0x0000, 0xFFE3, 0xFFB0,
    0x0000, 0x0000, 0xFFE3, 0xFFAF, 0x0000, 0x0000, 0xFFE3, 0xFFAD,
    0x0000, 0x0000, 0xFFE3, 0xFFAB, 0x0000, 0x0000, 0xFFE3, 0xFFAA,
    0x0000, 0x0000, 0xFFE3, 0xFFA8, 0x0000, 0x0000, 0xFFE3, 0xFFA6,
    0x0000, 0x0000, 0xFFE3, 0xFFA4, 0x0000, 0x0000, 0xFFE3, 0xFFA2,
    0x0000, 0x0000, 0xFFE3, 0xFFA0, 0x0000, 0x0000, 0xFFE3, 0xFF9E,
    0x0000, 0x0000, 0xFFE3, 0xFF9C, 0x0000, 0x0000, 0xFFE3, 0xFF99,
    0x0000, 0x0000, 0xFFE3, 0xFF97, 0x0000, 0x0000, 0xFFE3, 0xFF94,
    0x0000, 0x0000, 0xFFE3, 0xFF91, 0x0000, 0x0000, 0xFFE3, 0xFF8F,
    0x0000, 0x0000, 0xFFE3, 0xFF8C, 0x0000, 0x0000, 0xFFE3, 0xFF88,
    0x0000, 0x0000, 0xFFE3, 0xFF85, 0x0000, 0x0000, 0xFFE3, 0xFF82,
    0x0000, 0x0000, 0xFFE3, 0xFF7E, 0x0000, 0x0000, 0xFFE3, 0xFF7A,
    0x0000, 0x0000, 0xFFE3, 0xFF76, 0x0000, 0x0000, 0xFFE3, 0xFF71,
    0x0000, 0x0000, 0xFFE3, 0xFF6D, 0x0000, 0x0000, 0xFFE3, 0xFF68,
    0x0000, 0x0000, 0xFFE3, 0xFF63, 0x0000, 0x0000, 0xFFE3, 0xFF5D,
    0x0000, 0x0000, 0xFFE3, 0xFF57, 0x0000, 0x0000, 0xFFE3, 0xFF50,
    0x0000, 0x0000, 0xFFE3, 0xFF49, 0x0000, 0x0000, 0xFFE3, 0xFF42,
    0x0000, 0x0000, 0xFFE3, 0xFF3A, 0x0000, 0x0000, 0xFFE3, 0xFF31,
    0x0000, 0x0000, 0xFFE3, 0xFF27, 0x0000, 0x0000, 0xFFE3, 0xFF1C,
    0x0000, 0x0000, 0xFFE3, 0xFF10, 0x0000, 0x0000, 0xFFE3, 0xFF03,
    0x0000, 0x0000, 0xFFE3, 0xFEF5, 0x0000, 0x0000, 0xFFE3, 0xFEE5,
    0x0000, 0x0000, 0xFFE3, 0xFED2, 0x0000, 0x0000, 0xFFE3, 0xFEBD,
    0x0000, 0x0000, 0xFFE3, 0xFEA5, 0x0000, 0x0000, 0xFFE3, 0xFE89,
    0x0000, 0x0000, 0xFFE3, 0xFE69, 0x0000, 0x0000, 0xFFE3, 0xFE42,
    0x0000, 0x0000, 0xFFE3, 0xFE12, 0x0000, 0x0000, 0xFFE3, 0xFDD8,
    0x0000, 0x0000, 0xFFE3, 0xFD8F, 0x0000, 0x0000, 0xFFE3, 0xFD2E,
    0x0000, 0x0000, 0xFFE3, 0xFCAB, 0x0000, 0x0000, 0xFFE3, 0xFBED,
    0x0000, 0x0000, 0xFFE3, 0xFAC3, 0x0000, 0x0000, 0xFFE3, 0xF8AB,
    0x0000, 0x0000, 0xFFE3, 0xF3C7, 0x0000, 0x0000, 0xFFE3, 0xDB55
    };

static const q15_t in_cfft_step_2048[4096] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000
    };

static const q15_t in_cifft_step_2048[4096] = {
    0x399A, 0x0000, 0xFFF2, 0x24AB, 0x0000, 0x0000, 0xFFF2, 0x0C39,
    0x0000, 0x0000, 0xFFF2, 0x0755, 0x0000, 0x0000, 0xFFF2, 0x053D,
    0x0000, 0x0000, 0xFFF2, 0x0413, 0x0000, 0x0000, 0xFFF2, 0x0355,
    0x0000, 0x0000, 0xFFF2, 0x02D2, 0x0000, 0x0000, 0xFFF2, 0x0272,
    0x0000, 0x0000, 0xFFF2, 0x0228, 0x0000, 0x0000, 0xFFF2, 0x01EE,
    0x0000, 0x0000, 0xFFF2, 0x01BF, 0x0000, 0x0000, 0xFFF2, 0x0198,
    0x0000, 0x0000, 0xFFF2, 0x0177, 0x0000, 0x0000, 0xFFF2, 0x015B,
    0x0000, 0x0000, 0xFFF2, 0x0143, 0x0000, 0x0000, 0xFFF2, 0x012F,
    0x0000, 0x0000, 0xFFF2, 0x011C, 0x0000, 0x0000, 0xFFF2, 0x010C,
    0x0000, 0x0000, 0xFFF2, 0x00FD, 0x0000, 0x0000, 0xFFF2, 0x00F0,
    0x0000, 0x0000, 0xFFF2, 0x00E5, 0x0000, 0x0000, 0xFFF2, 0x00DA,
    0x0000, 0x0000, 0xFFF2, 0x00D0, 0x0000, 0x0000, 0xFFF2, 0x00C7,
    0x0000, 0x0000, 0xFFF2, 0x00BF, 0x0000, 0x0000, 0xFFF2, 0x00B8,
    0x0000, 0x0000, 0xFFF2, 0x00B1, 0x0000, 0x0000, 0xFFF2, 0x00AA,
    0x0000, 0x0000, 0xFFF2, 0x00A4, 0x0000, 0x0000, 0xFFF2, 0x009F,
    0x0000, 0x0000, 0xFFF2, 0x0099, 0x0000, 0x0000, 0xFFF2, 0x0095,
    0x0000, 0x0000, 0xFFF2, 0x0090, 0x0000, 0x0000, 0xFFF2, 0x008C,
    0x0000, 0x0000, 0xFFF2, 0x0088, 0x0000, 0x0000, 0xFFF2, 0x0084,
    0x0000, 0x0000, 0xFFF2, 0x0080, 0x0000, 0x0000, 0xFFF2, 0x007D,
    0x0000, 0x0000, 0xFFF2, 0x0079, 0x0000, 0x0000, 0xFFF2, 0x0076,
    0x0000, 0x0000, 0xFFF2, 0x0073, 0x0000, 0x0000, 0xFFF2, 0x0070,
    0x0000, 0x0000, 0xFFF2, 0x006E, 0x0000, 0x0000, 0xFFF2, 0x006B,
    0x0000, 0x0000, 0xFFF2, 0x0069, 0x0000, 0x0000, 0xFFF2, 0x0066,
    0x0000, 0x0000, 0xFFF2, 0x0064, 0x0000, 0x0000, 0xFFF2, 0x0062,
    0x0000, 0x0000, 0xFFF2, 0x0060, 0x0000, 0x0000, 0xFFF2, 0x005E,
    0x0000, 0x0000, 0xFFF2, 0x005C, 0x0000, 0x0000, 0xFFF2, 0x005A,
    0x0000, 0x0000, 0xFFF2, 0x0059, 0x0000, 0x0000, 0xFFF2, 0x0057,
    0x0000, 0x0000, 0xFFF2, 0x0055, 0x0000, 0x0000, 0xFFF2, 0x0054,
    0x0000, 0x0000, 0xFFF2, 0x0052, 0x0000, 0x0000, 0xFFF2, 0x0051,
    0x0000, 0x0000, 0xFFF2, 0x004F, 0x0000, 0x0000, 0xFFF2, 0x004E,
    0x0000, 0x0000, 0xFFF2, 0x004D, 0x0000, 0x0000, 0xFFF2, 0x004B,
    0x0000, 0x0000, 0xFFF2, 0x004A, 0x0000, 0x0000, 0xFFF2, 0x0049,
    0x0000, 0x0000, 0xFFF2, 0x0048, 0x0000, 0x0000, 0xFFF2, 0x0047,
    0x0000, 0x0000, 0xFFF2, 0x0046, 0x0000, 0x0000, 0xFFF2, 0x0045,
    0x0000, 0x0000, 0xFFF2, 0x0044, 0x0000, 0x0000, 0xFFF2, 0x0043,
    0x0000, 0x0000, 0xFFF2, 0x0042, 0x0000, 0x0000, 0xFFF2, 0x0041,
    0x0000, 0x0000, 0xFFF2, 0x0040, 0x0000, 0x0000, 0xFFF2, 0x003F,
    0x0000, 0x0000, 0xFFF2, 0x003E, 0x0000, 0x0000, 0xFFF2, 0x003D,
    0x0000, 0x0000, 0xFFF2, 0x003C, 0x0000, 0x0000, 0xFFF2, 0x003B,
    0x0000, 0x0000, 0xFFF2, 0x003B, 0x0000, 0x0000, 0xFFF2, 0x003A,
    0x0000, 0x0000, 0xFFF2, 0x0039, 0x0000, 0x0000, 0xFFF2, 0x0038,
    0x0000, 0x0000, 0xFFF2, 0x0038, 0x0000, 0x0000, 0xFFF2, 0x0037,
    0x0000, 0x0000, 0xFFF2, 0x0036, 0x0000, 0x0000, 0xFFF2, 0x0036,
    0x0000, 0x0000, 0xFFF2, 0x0035, 0x0000, 0x0000, 0xFFF2, 0x0034,
    0x0000, 0x0000, 0xFFF2, 0x0034, 0x0000, 0x0000, 0xFFF2, 0x0033,
    0x0000, 0x0000, 0xFFF2, 0x0033, 0x0000, 0x0000, 0xFFF2, 0x0032,
    0x0000, 0x0000, 0xFFF2, 0x0031, 0x0000, 0x0000, 0xFFF2, 0x0031,
    0x0000, 0x0000, 0xFFF2, 0x0030, 0x0000, 0x0000, 0xFFF2, 0x0030,
    0x0000, 0x0000, 0xFFF2, 0x002F, 0x0000, 0x0000, 0xFFF2, 0x002F,
    0x0000, 0x0000, 0xFFF2, 0x002E, 0x0000, 0x0000, 0xFFF2, 0x002E,
    0x0000, 0x0000, 0xFFF2, 0x002D, 0x0000, 0x0000, 0xFFF2, 0x002D,
    0x0000, 0x0000, 0xFFF2, 0x002C, 0x0000, 0x0000, 0xFFF2, 0x002C,
    0x0000, 0x0000, 0xFFF2, 0x002B, 0x0000, 0x0000, 0xFFF2, 0x002B,
    0x0000, 0x0000, 0xFFF2, 0x002A, 0x0000, 0x0000, 0xFFF2, 0x002A,
    0x0000, 0x0000, 0xFFF2, 0x002A, 0x0000, 0x0000, 0xFFF2, 0x0029,
    0x0000, 0x0000, 0xFFF2, 0x0029, 0x0000, 0x0000, 0xFFF2, 0x0028,
    0x0000, 0x0000, 0xFFF2, 0x0028, 0x0000, 0x0000, 0xFFF2, 0x0028,
    0x0000, 0x0000, 0xFFF2, 0x0027, 0x0000, 0x0000, 0xFFF2, 0x0027,
    0x0000, 0x0000, 0xFFF2, 0x0027, 0x0000, 0x0000, 0xFFF2, 0x0026,
    0x0000, 0x0000, 0xFFF2, 0x0026, 0x0000, 0x0000, 0xFFF2, 0x0026,
    0x0000, 0x0000, 0xFFF2, 0x0025, 0x0000, 0x0000, 0xFFF2, 0x0025,
    0x0000, 0x0000, 0xFFF2, 0x0024, 0x0000, 0x0000, 0xFFF2, 0x0024,
    0x0000, 0x0000, 0xFFF2, 0x0024, 0x0000, 0x0000, 0xFFF2, 0x0024,
    0x0000, 0x0000, 0xFFF2, 0x0023, 0x0000, 0x0000, 0xFFF2, 0x0023,
    0x0000, 0x0000, 0xFFF2, 0x0023, 0x0000, 0x0000, 0xFFF2, 0x0022,
    0x0000, 0x0000, 0xFFF2, 0x0022, 0x0000, 0x0000, 0xFFF2, 0x0022,
    0x0000, 0x0000, 0xFFF2, 0x0021, 0x0000, 0x0000, 0xFFF2, 0x0021,
    0x0000, 0x0000, 0xFFF2, 0x0021, 0x0000, 0x0000, 0xFFF2, 0x0021,
    0x0000, 0x0000, 0xFFF2, 0x0020, 0x0000, 0x0000, 0xFFF2, 0x0020,
    0x0000, 0x0000, 0xFFF2, 0x0020, 0x0000, 0x0000, 0xFFF2, 0x0020,
    0x0000, 0x0000, 0xFFF2, 0x001F, 0x0000, 0x0000, 0xFFF2, 0x001F,
    0x0000, 0x0000, 0xFFF2, 0x001F, 0x0000, 0x0000, 0xFFF2, 0x001F,
    0x0000, 0x0000, 0xFFF2, 0x001E, 0x0000, 0x0000, 0xFFF2, 0x001E,
    0x0000, 0x0000, 0xFFF2, 0x001E, 0x0000, 0x0000, 0xFFF2, 0x001E,
    0x0000, 0x0000, 0xFFF2, 0x001D, 0x0000, 0x0000, 0xFFF2, 0x001D,
    0x0000, 0x0000, 0xFFF2, 0x001D, 0x0000, 0x0000, 0xFFF2, 0x001D,
    0x0000, 0x0000, 0xFFF2, 0x001C, 0x0000, 0x0000, 0xFFF2, 0x001C,
    0x0000, 0x0000, 0xFFF2, 0x001C, 0x0000, 0x0000, 0xFFF2, 0x001C,
    0x0000, 0x0000, 0xFFF2, 0x001C, 0x0000, 0x0000, 0xFFF2, 0x001B,
    0x0000, 0x0000, 0xFFF2, 0x001B, 0x0000, 0x0000, 0xFFF2, 0x001B,
    0x0000, 0x0000, 0xFFF2, 0x001B, 0x0000, 0x0000, 0xFFF2, 0x001B,
    0x0000, 0x0000, 0xFFF2, 0x001A, 0x0000, 0x0000, 0xFFF2, 0x001A,
    0x0000, 0x0000, 0xFFF2, 0x001A, 0x0000, 0x0000, 0xFFF2, 0x001A,
    0x0000, 0x0000, 0xFFF2, 0x001A, 0x0000, 0x0000, 0xFFF2, 0x001A,
    0x0000, 0x0000, 0xFFF2, 0x0019, 0x0000, 0x0000, 0xFFF2, 0x0019,
    0x0000, 0x0000, 0xFFF2, 0x0019, 0x0000, 0x0000, 0xFFF2, 0x0019,
    0x0000, 0x0000, 0xFFF2, 0x0019, 0x0000, 0x0000, 0xFFF2, 0x0018,
    0x0000, 0x0000, 0xFFF2, 0x0018, 0x0000, 0x0000, 0xFFF2, 0x0018,
    0x0000, 0x0000, 0xFFF2, 0x0018, 0x0000, 0x0000, 0xFFF2, 0x0018,
    0x0000, 0x0000, 0xFFF2, 0x0018, 0x0000, 0x0000, 0xFFF2, 0x0017,
    0x0000, 0x0000, 0xFFF2, 0x0017, 0x0000, 0x0000, 0xFFF2, 0x0017,
    0x0000, 0x0000, 0xFFF2, 0x0017, 0x0000, 0x0000, 0xFFF2, 0x0017,
    0x0000, 0x0000, 0xFFF2, 0x0017, 0x0000, 0x0000, 0xFFF2, 0x0017,
    0x0000, 0x0000, 0xFFF2, 0x0016, 0x0000, 0x0000, 0xFFF2, 0x0016,
    0x0000, 0x0000, 0xFFF2, 0x0016, 0x0000, 0x0000, 0xFFF2, 0x0016,
    0x0000, 0x0000, 0xFFF2, 0x0016, 0x0000, 0x0000, 0xFFF2, 0x0016,
    0x0000, 0x0000, 0xFFF2, 0x0015, 0x0000, 0x0000, 0xFFF2, 0x0015,
    0x0000, 0x0000, 0xFFF2, 0x0015, 0x0000, 0x0000, 0xFFF2, 0x0015,
    0x0000, 0x0000, 0xFFF2, 0x0015, 0x0000, 0x0000, 0xFFF2, 0x0015,
    0x0000, 0x0000, 0xFFF2, 0x0015, 0x0000, 0x0000, 0xFFF2, 0x0015,
    0x0000, 0x0000, 0xFFF2, 0x0014, 0x0000, 0x0000, 0xFFF2, 0x0014,
    0x0000, 0x0000, 0xFFF2, 0x0014, 0x0000, 0x0000, 0xFFF2, 0x0014,
    0x0000, 0x0000, 0xFFF2, 0x0014, 0x0000, 0x0000, 0xFFF2, 0x0014,
    0x0000, 0x0000, 0xFFF2, 0x0014, 0x0000, 0x0000, 0xFFF2, 0x0013,
    0x0000, 0x0000, 0xFFF2, 0x0013, 0x0000, 0x0000, 0xFFF2, 0x0013,
    0x0000, 0x0000, 0xFFF2, 0x0013, 0x0000, 0x0000, 0xFFF2, 0x0013,
    0x0000, 0x0000, 0xFFF2, 0x0013, 0x0000, 0x0000, 0xFFF2, 0x0013,
    0x0000, 0x0000, 0xFFF2, 0x0013, 0x0000, 0x0000, 0xFFF2, 0x0013,
    0x0000, 0x0000, 0xFFF2, 0x0012, 0x0000, 0x0000, 0xFFF2, 0x0012,
    0x0000, 0x0000, 0xFFF2, 0x0012, 0x0000, 0x0000, 0xFFF2, 0x0012,
    0x0000, 0x0000, 0xFFF2, 0x0012, 0x0000, 0x0000, 0xFFF2, 0x0012,
    0x0000, 0x0000, 0xFFF2, 0x0012, 0x0000, 0x0000, 0xFFF2, 0x0012,
    0x0000, 0x0000, 0xFFF2, 0x0011, 0x0000, 0x0000, 0xFFF2, 0x0011,
    0x0000, 0x0000, 0xFFF2, 0x0011, 0x0000, 0x0000, 0xFFF2, 0x0011,
    0x0000, 0x0000, 0xFFF2, 0x0011, 0x0000, 0x0000, 0xFFF2, 0x0011,
    0x0000, 0x0000, 0xFFF2, 0x0011, 0x0000, 0x0000, 0xFFF2, 0x0011,
    0x0000, 0x0000, 0xFFF2, 0x0011, 0x0000, 0x0000, 0xFFF2, 0x0011,
    0x0000, 0x0000, 0xFFF2, 0x0010, 0x0000, 0x0000, 0xFFF2, 0x0010,
    0x0000, 0x0000, 0xFFF2, 0x0010, 0x0000, 0x0000, 0xFFF2, 0x0010,
    0x0000, 0x0000, 0xFFF2, 0x0010, 0x0000, 0x0000, 0xFFF2, 0x0010,
    0x0000, 0x0000, 0xFFF2, 0x0010, 0x0000, 0x0000, 0xFFF2, 0x0010,
    0x0000, 0x0000, 0xFFF2, 0x0010, 0x0000, 0x0000, 0xFFF2, 0x0010,
    0x0000, 0x0000, 0xFFF2, 0x000F, 0x0000, 0x0000, 0xFFF2, 0x000F,
    0x0000, 0x0000, 0xFFF2, 0x000F, 0x0000, 0x0000, 0xFFF2, 0x000F,
    0x0000, 0x0000, 0xFFF2, 0x000F, 0x0000, 0x0000, 0xFFF2, 0x000F,
    0x0000, 0x0000, 0xFFF2, 0x000F, 0x0000, 0x0000, 0xFFF2, 0x000F,
    0x0000, 0x0000, 0xFFF2, 0x000F, 0x0000, 0x0000, 0xFFF2, 0x000F,
    0x0000, 0x0000, 0xFFF2, 0x000F, 0x0000, 0x0000, 0xFFF2, 0x000E,
    0x0000, 0x0000, 0xFFF2, 0x000E, 0x0000, 0x0000, 0xFFF2, 0x000E,
    0x0000, 0x0000, 0xFFF2, 0x000E, 0x0000, 0x0000, 0xFFF2, 0x000E,
    0x0000, 0x0000, 0xFFF2, 0x000E, 0x0000, 0x0000, 0xFFF2, 0x000E,
    0x0000, 0x0000, 0xFFF2, 0x000E, 0x0000, 0x0000, 0xFFF2, 0x000E,
    0x0000, 0x0000, 0xFFF2, 0x000E, 0x0000, 0x0000, 0xFFF2, 0x000E,
    0x0000, 0x0000, 0xFFF2, 0x000E, 0x0000, 0x0000, 0xFFF2, 0x000D,
    0x0000, 0x0000, 0xFFF2, 0x000D, 0x0000, 0x0000, 0xFFF2, 0x000D,
    0x0000, 0x0000, 0xFFF2, 0x000D, 0x0000, 0x0000, 0xFFF2, 0x000D,
    0x0000, 0x0000, 0xFFF2, 0x000D, 0x0000, 0x0000, 0xFFF2, 0x000D,
    0x0000, 0x0000, 0xFFF2, 0x000D, 0x0000, 0x0000, 0xFFF2, 0x000D,
    0x0000, 0x0000, 0xFFF2, 0x000D, 0x0000, 0x0000, 0xFFF2, 0x000D,
    0x0000, 0x0000, 0xFFF2, 0x000D, 0x0000, 0x0000, 0xFFF2, 0x000C,
    0x0000, 0x0000, 0xFFF2, 0x000C, 0x0000, 0x0000, 0xFFF2, 0x000C,
    0x0000, 0x0000, 0xFFF2, 0x000C, 0x0000, 0x0000, 0xFFF2, 0x000C,
    0x0000, 0x0000, 0xFFF2, 0x000C, 0x0000, 0x0000, 0xFFF2, 0x000C,
    0x0000, 0x0000, 0xFFF2, 0x000C, 0x0000, 0x0000, 0xFFF2, 0x000C,
    0x0000, 0x0000, 0xFFF2, 0x000C, 0x0000, 0x0000, 0xFFF2, 0x000C,
    0x0000, 0x0000, 0xFFF2, 0x000C, 0x0000, 0x0000, 0xFFF2, 0x000C,
    0x0000, 0x0000, 0xFFF2, 0x000B, 0x0000, 0x0000, 0xFFF2, 0x000B,
    0x0000, 0x0000, 0xFFF2, 0x000B, 0x0000, 0x0000, 0xFFF2, 0x000B,
    0x0000, 0x0000, 0xFFF2, 0x000B, 0x0000, 0x0000, 0xFFF2, 0x000B,
    0x0000, 0x0000, 0xFFF2, 0x000B, 0x0000, 0x0000, 0xFFF2, 0x000B,
    0x0000, 0x0000, 0xFFF2, 0x000B, 0x0000, 0x0000, 0xFFF2, 0x000B,
    0x0000, 0x0000, 0xFFF2, 0x000B, 0x0000, 0x0000, 0xFFF2, 0x000B,
    0x0000, 0x0000, 0xFFF2, 0x000B, 0x0000, 0x0000, 0xFFF2, 0x000B,
    0x0000, 0x0000, 0xFFF2, 0x000B, 0x0000, 0x0000, 0xFFF2, 0x000A,
    0x0000, 0x0000, 0xFFF2, 0x000A, 0x0000, 0x0000, 0xFFF2, 0x000A,
    0x0000, 0x0000, 0xFFF2, 0x000A, 0x0000, 0x0000, 0xFFF2, 0x000A,
    0x0000, 0x0000, 0xFFF2, 0x000A, 0x0000, 0x0000, 0xFFF2, 0x000A,
    0x0000, 0x0000, 0xFFF2, 0x000A, 0x0000, 0x0000, 0xFFF2, 0x000A,
    0x0000, 0x0000, 0xFFF2, 0x000A, 0x0000, 0x0000, 0xFFF2, 0x000A,
    0x0000, 0x0000, 0xFFF2, 0x000A, 0x0000, 0x0000, 0xFFF2, 0x000A,
    0x0000, 0x0000, 0xFFF2, 0x000A, 0x0000, 0x0000, 0xFFF2, 0x000A,
    0x0000, 0x0000, 0xFFF2, 0x0009, 0x0000, 0x0000, 0xFFF2, 0x0009,
    0x0000, 0x0000, 0xFFF2, 0x0009, 0x0000, 0x0000, 0xFFF2, 0x0009,
    0x0000, 0x0000, 0xFFF2, 0x0009, 0x0000, 0x0000, 0xFFF2, 0x0009,
    0x0000, 0x0000, 0xFFF2, 0x0009, 0x0000, 0x0000, 0xFFF2, 0x0009,
    0x0000, 0x0000, 0xFFF2, 0x0009, 0x0000, 0x0000, 0xFFF2, 0x0009,
    0x0000, 0x0000, 0xFFF2, 0x0009, 0x0000, 0x0000, 0xFFF2, 0x0009,
    0x0000, 0x0000, 0xFFF2, 0x0009, 0x0000, 0x0000, 0xFFF2, 0x0009,
    0x0000, 0x0000, 0xFFF2, 0x0009, 0x0000, 0x0000, 0xFFF2, 0x0009,
    0x0000, 0x0000, 0xFFF2, 0x0008, 0x0000, 0x0000, 0xFFF2, 0x0008,
    0x0000, 0x0000, 0xFFF2, 0x0008, 0x0000, 0x0000, 0xFFF2, 0x0008,
    0x0000, 0x0000, 0xFFF2, 0x0008, 0x0000, 0x0000, 0xFFF2, 0x0008,
    0x0000, 0x0000, 0xFFF2, 0x0008, 0x0000, 0x0000, 0xFFF2, 0x0008,
    0x0000, 0x0000, 0xFFF2, 0x0008, 0x0000, 0x0000, 0xFFF2, 0x0008,
    0x0000, 0x0000, 0xFFF2, 0x0008, 0x0000, 0x0000, 0xFFF2, 0x0008,
    0x0000, 0x0000, 0xFFF2, 0x0008, 0x0000, 0x0000, 0xFFF2, 0x0008,
    0x0000, 0x0000, 0xFFF2, 0x0008, 0x0000, 0x0000, 0xFFF2, 0x0008,
    0x0000, 0x0000, 0xFFF2, 0x0008, 0x0000, 0x0000, 0xFFF2, 0x0007,
    0x0000, 0x0000, 0xFFF2, 0x0007, 0x0000, 0x0000, 0xFFF2, 0x0007,
    0x0000, 0x0000, 0xFFF2, 0x0007, 0x0000, 0x0000, 0xFFF2, 0x0007,
    0x0000, 0x0000, 0xFFF2, 0x0007, 0x0000, 0x0000, 0xFFF2, 0x0007,
    0x0000, 0x0000, 0xFFF2, 0x0007, 0x0000, 0x0000, 0xFFF2, 0x0007,
    0x0000, 0x0000, 0xFFF2, 0x0007, 0x0000, 0x0000, 0xFFF2, 0x0007,
    0x0000, 0x0000, 0xFFF2, 0x0007, 0x0000, 0x0000, 0xFFF2, 0x0007,
    0x0000, 0x0000, 0xFFF2, 0x0007, 0x0000, 0x0000, 0xFFF2, 0x0007,
    0x0000, 0x0000, 0xFFF2, 0x0007, 0x0000, 0x0000, 0xFFF2, 0x0007,
    0x0000, 0x0000, 0xFFF2, 0x0007, 0x0000, 0x0000, 0xFFF2, 0x0007,
    0x0000, 0x0000, 0xFFF2, 0x0006, 0x0000, 0x0000, 0xFFF2, 0x0006,
    0x0000, 0x0000, 0xFFF2, 0x0006, 0x0000, 0x0000, 0xFFF2, 0x0006,
    0x0000, 0x0000, 0xFFF2, 0x0006, 0x0000, 0x0000, 0xFFF2, 0x0006,
    0x0000, 0x0000, 0xFFF2, 0x0006, 0x0000, 0x0000, 0xFFF2, 0x0006,
    0x0000, 0x0000, 0xFFF2, 0x0006, 0x0000, 0x0000, 0xFFF2, 0x0006,
    0x0000, 0x0000, 0xFFF2, 0x0006, 0x0000, 0x0000, 0xFFF2, 0x0006,
    0x0000, 0x0000, 0xFFF2, 0x0006, 0x0000, 0x0000, 0xFFF2, 0x0006,
    0x0000, 0x0000, 0xFFF2, 0x0006, 0x0000, 0x0000, 0xFFF2, 0x0006,
    0x0000, 0x0000, 0xFFF2, 0x0006, 0x0000, 0x0000, 0xFFF2, 0x0006,
    0x0000, 0x0000, 0xFFF2, 0x0006, 0x0000, 0x0000, 0xFFF2, 0x0005,
    0x0000, 0x0000, 0xFFF2, 0x0005, 0x0000, 0x0000, 0xFFF2, 0x0005,
    0x0000, 0x0000, 0xFFF2, 0x0005, 0x0000, 0x0000, 0xFFF2, 0x0005,
    0x0000, 0x0000, 0xFFF2, 0x0005, 0x0000, 0x0000, 0xFFF2, 0x0005,
    0x0000, 0x0000, 0xFFF2, 0x0005, 0x0000, 0x0000, 0xFFF2, 0x0005,
    0x0000, 0x0000, 0xFFF2, 0x0005, 0x0000, 0x0000, 0xFFF2, 0x0005,
    0x0000, 0x0000, 0xFFF2, 0x0005, 0x0000, 0x0000, 0xFFF2, 0x0005,
    0x0000, 0x0000, 0xFFF2, 0x0005, 0x0000, 0x0000, 0xFFF2, 0x0005,
    0x0000, 0x0000, 0xFFF2, 0x0005, 0x0000, 0x0000, 0xFFF2, 0x0005,
    0x0000, 0x0000, 0xFFF2, 0x0005, 0x0000, 0x0000, 0xFFF2, 0x0005,
    0x0000, 0x0000, 0xFFF2, 0x0005, 0x0000, 0x0000, 0xFFF2, 0x0004,
    0x0000, 0x0000, 0xFFF2, 0x0004, 0x0000, 0x0000, 0xFFF2, 0x0004,
    0x0000, 0x0000, 0xFFF2, 0x0004, 0x0000, 0x0000, 0xFFF2, 0x0004,
    0x0000, 0x0000, 0xFFF2, 0x0004, 0x0000, 0x0000, 0xFFF2, 0x0004,
    0x0000, 0x0000, 0xFFF2, 0x0004, 0x0000, 0x0000, 0xFFF2, 0x0004,
    0x0000, 0x0000, 0xFFF2, 0x0004, 0x0000, 0x0000, 0xFFF2, 0x0004,
    0x0000, 0x0000, 0xFFF2, 0x0004, 0x0000, 0x0000, 0xFFF2, 0x0004,
    0x0000, 0x0000, 0xFFF2, 0x0004, 0x0000, 0x0000, 0xFFF2, 0x0004,
    0x0000, 0x0000, 0xFFF2, 0x0004, 0x0000, 0x0000, 0xFFF2, 0x0004,
    0x0000, 0x0000, 0xFFF2, 0x0004, 0x0000, 0x0000, 0xFFF2, 0x0004,
    0x0000, 0x0000, 0xFFF2, 0x0004, 0x0000, 0x0000, 0xFFF2, 0x0004,
    0x0000, 0x0000, 0xFFF2, 0x0003, 0x0000, 0x0000, 0xFFF2, 0x0003,
    0x0000, 0x0000, 0xFFF2, 0x0003, 0x0000, 0x0000, 0xFFF2, 0x0003,
    0x0000, 0x0000, 0xFFF2, 0x0003, 0x0000, 0x0000, 0xFFF2, 0x0003,
    0x0000, 0x0000, 0xFFF2, 0x0003, 0x0000, 0x0000, 0xFFF2, 0x0003,
    0x0000, 0x0000, 0xFFF2, 0x0003, 0x0000, 0x0000, 0xFFF2, 0x0003,
    0x0000, 0x0000, 0xFFF2, 0x0003, 0x0000, 0x0000, 0xFFF2, 0x0003,
    0x0000, 0x0000, 0xFFF2, 0x0003, 0x0000, 0x0000, 0xFFF2, 0x0003,
    0x0000, 0x0000, 0xFFF2, 0x0003, 0x0000, 0x0000, 0xFFF2, 0x0003,
    0x0000, 0x0000, 0xFFF2, 0x0003, 0x0000, 0x0000, 0xFFF2, 0x0003,
    0x0000, 0x0000, 0xFFF2, 0x0003, 0x0000, 0x0000, 0xFFF2, 0x0003,
    0x0000, 0x0000, 0xFFF2, 0x0003, 0x0000, 0x0000, 0xFFF2, 0x0003,
    0x0000, 0x0000, 0xFFF2, 0x0002, 0x0000, 0x0000, 0xFFF2, 0x0002,
    0x0000, 0x0000, 0xFFF2, 0x0002, 0x0000, 0x0000, 0xFFF2, 0x0002,
    0x0000, 0x0000, 0xFFF2, 0x0002, 0x0000, 0x0000, 0xFFF2, 0x0002,
    0x0000, 0x0000, 0xFFF2, 0x0002, 0x0000, 0x0000, 0xFFF2, 0x0002,
    0x0000, 0x0000, 0xFFF2, 0x0002, 0x0000, 0x0000, 0xFFF2, 0x0002,
    0x0000, 0x0000, 0xFFF2, 0x0002, 0x0000, 0x0000, 0xFFF2, 0x0002,
    0x0000, 0x0000, 0xFFF2, 0x0002, 0x0000, 0x0000, 0xFFF2, 0x0002,
    0x0000, 0x0000, 0xFFF2, 0x0002, 0x0000, 0x0000, 0xFFF2, 0x0002,
    0x0000, 0x0000, 0xFFF2, 0x0002, 0x0000, 0x0000, 0xFFF2, 0x0002,
    0x0000, 0x0000, 0xFFF2, 0x0002, 0x0000, 0x0000, 0xFFF2, 0x0002,
    0x0000, 0x0000, 0xFFF2, 0x0002, 0x0000, 0x0000, 0xFFF2, 0x0002,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0001,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0001,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0001,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0001,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0001,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0001,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0001,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0001,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0001,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0001,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0001,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0000,
    0x0000, 0x0000, 0xFFF2, 0x0000, 0x0000, 0x0000, 0xFFF2, 0x0000,
    0x0000, 0x0000, 0xFFF2, 0x0000, 0x0000, 0x0000, 0xFFF2, 0x0000,
    0x0000, 0x0000, 0xFFF2, 0x0000, 0x0000, 0x0000, 0xFFF2, 0x0000,
    0x0000, 0x0000, 0xFFF2, 0x0000, 0x0000, 0x0000, 0xFFF2, 0x0000,
    0x0000, 0x0000, 0xFFF2, 0x0000, 0x0000, 0x0000, 0xFFF2, 0x0000,
    0x0000, 0x0000, 0xFFF2, 0x0000, 0x0000, 0x0000, 0xFFF2, 0x0000,
    0x0000, 0x0000, 0xFFF2, 0x0000, 0x0000, 0x0000, 0xFFF2, 0x0000,
    0x0000, 0x0000, 0xFFF2, 0x0000, 0x0000, 0x0000, 0xFFF2, 0x0000,
    0x0000, 0x0000, 0xFFF2, 0x0000, 0x0000, 0x0000, 0xFFF2, 0x0000,
    0x0000, 0x0000, 0xFFF2, 0x0000, 0x0000, 0x0000, 0xFFF2, 0x0000,
    0x0000, 0x0000, 0xFFF2, 0x0000, 0x0000, 0x0000, 0xFFF2, 0xFFFF,
    0x0000, 0x0000, 0xFFF2, 0xFFFF, 0x0000, 0x0000, 0xFFF2, 0xFFFF,
    0x0000, 0x0000, 0xFFF2, 0xFFFF, 0x0000, 0x0000, 0xFFF2, 0xFFFF,
    0x0000, 0x0000, 0xFFF2, 0xFFFF, 0x0000, 0x0000, 0xFFF2, 0xFFFF,
    0x0000, 0x0000, 0xFFF2, 0xFFFF, 0x0000, 0x0000, 0xFFF2, 0xFFFF,
    0x0000, 0x0000, 0xFFF2, 0xFFFF, 0x0000, 0x0000, 0xFFF2, 0xFFFF,
    0x0000, 0x0000, 0xFFF2, 0xFFFF, 0x0000, 0x0000, 0xFFF2, 0xFFFF,
    0x0000, 0x0000, 0xFFF2, 0xFFFF, 0x0000, 0x0000, 0xFFF2, 0xFFFF,
    0x0000, 0x0000, 0xFFF2, 0xFFFF, 0x0000, 0x0000, 0xFFF2, 0xFFFF,
    0x0000, 0x0000, 0xFFF2, 0xFFFF, 0x0000, 0x0000, 0xFFF2, 0xFFFF,
    0x0000, 0x0000, 0xFFF2, 0xFFFF, 0x0000, 0x0000, 0xFFF2, 0xFFFF,
    0x0000, 0x0000, 0xFFF2, 0xFFFF, 0x0000, 0x0000, 0xFFF2, 0xFFFF,
    0x0000, 0x0000, 0xFFF2, 0xFFFE, 0x0000, 0x0000, 0xFFF2, 0xFFFE,
    0x0000, 0x0000, 0xFFF2, 0xFFFE, 0x0000, 0x0000, 0xFFF2, 0xFFFE,
    0x0000, 0x0000, 0xFFF2, 0xFFFE, 0x0000, 0x0000, 0xFFF2, 0xFFFE,
    0x0000, 0x0000, 0xFFF2, 0xFFFE, 0x0000, 0x0000, 0xFFF2, 0xFFFE,
    0x0000, 0x0000, 0xFFF2, 0xFFFE, 0x0000, 0x0000, 0xFFF2, 0xFFFE,
    0x0000, 0x0000, 0xFFF2, 0xFFFE, 0x0000, 0x0000, 0xFFF2, 0xFFFE,
    0x0000, 0x0000, 0xFFF2, 0xFFFE, 0x0000, 0x0000, 0xFFF2, 0xFFFE,
    0x0000, 0x0000, 0xFFF2, 0xFFFE, 0x0000, 0x0000, 0xFFF2, 0xFFFE,
    0x0000, 0x0000, 0xFFF2, 0xFFFE, 0x0000, 0x0000, 0xFFF2, 0xFFFE,
    0x0000, 0x0000, 0xFFF2, 0xFFFE, 0x0000, 0x0000, 0xFFF2, 0xFFFE,
    0x0000, 0x0000, 0xFFF2, 0xFFFE, 0x0000, 0x0000, 0xFFF2, 0xFFFE,
    0x0000, 0x0000, 0xFFF2, 0xFFFD, 0x0000, 0x0000, 0xFFF2, 0xFFFD,
    0x0000, 0x0000, 0xFFF2, 0xFFFD, 0x0000, 0x0000, 0xFFF2, 0xFFFD,
    0x0000, 0x0000, 0xFFF2, 0xFFFD, 0x0000, 0x0000, 0xFFF2, 0xFFFD,
    0x0000, 0x0000, 0xFFF2, 0xFFFD, 0x0000, 0x0000, 0xFFF2, 0xFFFD,
    0x0000, 0x0000, 0xFFF2, 0xFFFD, 0x0000, 0x0000, 0xFFF2, 0xFFFD,
    0x0000, 0x0000, 0xFFF2, 0xFFFD, 0x0000, 0x0000, 0xFFF2, 0xFFFD,
    0x0000, 0x0000, 0xFFF2, 0xFFFD, 0x0000, 0x0000, 0xFFF2, 0xFFFD,
    0x0000, 0x0000, 0xFFF2, 0xFFFD, 0x0000, 0x0000, 0xFFF2, 0xFFFD,
    0x0000, 0x0000, 0xFFF2, 0xFFFD, 0x0000, 0x0000, 0xFFF2, 0xFFFD,
    0x0000, 0x0000, 0xFFF2, 0xFFFD, 0x0000, 0x0000, 0xFFF2, 0xFFFD,
    0x0000, 0x0000, 0xFFF2, 0xFFFD, 0x0000, 0x0000, 0xFFF2, 0xFFFD,
    0x0000, 0x0000, 0xFFF2, 0xFFFC, 0x0000, 0x0000, 0xFFF2, 0xFFFC,
    0x0000, 0x0000, 0xFFF2, 0xFFFC, 0x0000, 0x0000, 0xFFF2, 0xFFFC,
    0x0000, 0x0000, 0xFFF2, 0xFFFC, 0x0000, 0x0000, 0xFFF2, 0xFFFC,
    0x0000, 0x0000, 0xFFF2, 0xFFFC, 0x0000, 0x0000, 0xFFF2, 0xFFFC,
    0x0000, 0x0000, 0xFFF2, 0xFFFC, 0x0000, 0x0000, 0xFFF2, 0xFFFC,
    0x0000, 0x0000, 0xFFF2, 0xFFFC, 0x0000, 0x0000, 0xFFF2, 0xFFFC,
    0x0000, 0x0000, 0xFFF2, 0xFFFC, 0x0000, 0x0000, 0xFFF2, 0xFFFC,
    0x0000, 0x0000, 0xFFF2, 0xFFFC, 0x0000, 0x0000, 0xFFF2, 0xFFFC,
    0x0000, 0x0000, 0xFFF2, 0xFFFC, 0x0000, 0x0000, 0xFFF2, 0xFFFC,
    0x0000, 0x0000, 0xFFF2, 0xFFFC, 0x0000, 0x0000, 0xFFF2, 0xFFFC,
    0x0000, 0x0000, 0xFFF2, 0xFFFC, 0x0000, 0x0000, 0xFFF2, 0xFFFB,
    0x0000, 0x0000, 0xFFF2, 0xFFFB, 0x0000, 0x0000, 0xFFF2, 0xFFFB,
    0x0000, 0x0000, 0xFFF2, 0xFFFB, 0x0000, 0x0000, 0xFFF2, 0xFFFB,
    0x0000, 0x0000, 0xFFF2, 0xFFFB, 0x0000, 0x0000, 0xFFF2, 0xFFFB,
    0x0000, 0x0000, 0xFFF2, 0xFFFB, 0x0000, 0x0000, 0xFFF2, 0xFFFB,
    0x0000, 0x0000, 0xFFF2, 0xFFFB, 0x0000, 0x0000, 0xFFF2, 0xFFFB,
    0x0000, 0x0000, 0xFFF2, 0xFFFB, 0x0000, 0x0000, 0xFFF2, 0xFFFB,
    0x0000, 0x0000, 0xFFF2, 0xFFFB, 0x0000, 0x0000, 0xFFF2, 0xFFFB,
    0x0000, 0x0000, 0xFFF2, 0xFFFB, 0x0000, 0x0000, 0xFFF2, 0xFFFB,
    0x0000, 0x0000, 0xFFF2, 0xFFFB, 0x0000, 0x0000, 0xFFF2, 0xFFFB,
    0x0000, 0x0000, 0xFFF2, 0xFFFB, 0x0000, 0x0000, 0xFFF2, 0xFFFA,
    0x0000, 0x0000, 0xFFF2, 0xFFFA, 0x0000, 0x0000, 0xFFF2, 0xFFFA,
    0x0000, 0x0000, 0xFFF2, 0xFFFA, 0x0000, 0x0000, 0xFFF2, 0xFFFA,
    0x0000, 0x0000, 0xFFF2, 0xFFFA, 0x0000, 0x0000, 0xFFF2, 0xFFFA,
    0x0000, 0x0000, 0xFFF2, 0xFFFA, 0x0000, 0x0000, 0xFFF2, 0xFFFA,
    0x0000, 0x0000, 0xFFF2, 0xFFFA, 0x0000, 0x0000, 0xFFF2, 0xFFFA,
    0x0000, 0x0000, 0xFFF2, 0xFFFA, 0x0000, 0x0000, 0xFFF2, 0xFFFA,
    0x0000, 0x0000, 0xFFF2, 0xFFFA, 0x0000, 0x0000, 0xFFF2, 0xFFFA,
    0x0000, 0x0000, 0xFFF2, 0xFFFA, 0x0000, 0x0000, 0xFFF2, 0xFFFA,
    0x0000, 0x0000, 0xFFF2, 0xFFFA, 0x0000, 0x0000, 0xFFF2, 0xFFFA,
    0x0000, 0x0000, 0xFFF2, 0xFFF9, 0x0000, 0x0000, 0xFFF2, 0xFFF9,
    0x0000, 0x0000, 0xFFF2, 0xFFF9, 0x0000, 0x0000, 0xFFF2, 0xFFF9,
    0x0000, 0x0000, 0xFFF2, 0xFFF9, 0x0000, 0x0000, 0xFFF2, 0xFFF9,
    0x0000, 0x0000, 0xFFF2, 0xFFF9, 0x0000, 0x0000, 0xFFF2, 0xFFF9,
    0x0000, 0x0000, 0xFFF2, 0xFFF9, 0x0000, 0x0000, 0xFFF2, 0xFFF9,
    0x0000, 0x0000, 0xFFF2, 0xFFF9, 0x0000, 0x0000, 0xFFF2, 0xFFF9,
    0x0000, 0x0000, 0xFFF2, 0xFFF9, 0x0000, 0x0000, 0xFFF2, 0xFFF9,
    0x0000, 0x0000, 0xFFF2, 0xFFF9, 0x0000, 0x0000, 0xFFF2, 0xFFF9,
    0x0000, 0x0000, 0xFFF2, 0xFFF9, 0x0000, 0x0000, 0xFFF2, 0xFFF9,
    0x0000, 0x0000, 0xFFF2, 0xFFF9, 0x0000, 0x0000, 0xFFF2, 0xFFF8,
    0x0000, 0x0000, 0xFFF2, 0xFFF8, 0x0000, 0x0000, 0xFFF2, 0xFFF8,
    0x0000, 0x0000, 0xFFF2, 0xFFF8, 0x0000, 0x0000, 0xFFF2, 0xFFF8,
    0x0000, 0x0000, 0xFFF2, 0xFFF8, 0x0000, 0x0000, 0xFFF2, 0xFFF8,
    0x0000, 0x0000, 0xFFF2, 0xFFF8, 0x0000, 0x0000, 0xFFF2, 0xFFF8,
    0x0000, 0x0000, 0xFFF2, 0xFFF8, 0x0000, 0x0000, 0xFFF2, 0xFFF8,
    0x0000, 0x0000, 0xFFF2, 0xFFF8, 0x0000, 0x0000, 0xFFF2, 0xFFF8,
    0x0000, 0x0000, 0xFFF2, 0xFFF8, 0x0000, 0x0000, 0xFFF2, 0xFFF8,
    0x0000, 0x0000, 0xFFF2, 0xFFF8, 0x0000, 0x0000, 0xFFF2, 0xFFF8,
    0x0000, 0x0000, 0xFFF2, 0xFFF7, 0x0000, 0x0000, 0xFFF2, 0xFFF7,
    0x0000, 0x0000, 0xFFF2, 0xFFF7, 0x0000, 0x0000, 0xFFF2, 0xFFF7,
    0x0000, 0x0000, 0xFFF2, 0xFFF7, 0x0000, 0x0000, 0xFFF2, 0xFFF7,
    0x0000, 0x0000, 0xFFF2, 0xFFF7, 0x0000, 0x0000, 0xFFF2, 0xFFF7,
    0x0000, 0x0000, 0xFFF2, 0xFFF7, 0x0000, 0x0000, 0xFFF2, 0xFFF7,
    0x0000, 0x0000, 0xFFF2, 0xFFF7, 0x0000, 0x0000, 0xFFF2, 0xFFF7,
    0x0000, 0x0000, 0xFFF2, 0xFFF7, 0x0000, 0x0000, 0xFFF2, 0xFFF7,
    0x0000, 0x0000, 0xFFF2, 0xFFF7, 0x0000, 0x0000, 0xFFF2, 0xFFF7,
    0x0000, 0x0000, 0xFFF2, 0xFFF6, 0x0000, 0x0000, 0xFFF2, 0xFFF6,
    0x0000, 0x0000, 0xFFF2, 0xFFF6, 0x0000, 0x0000, 0xFFF2, 0xFFF6,
    0x0000, 0x0000, 0xFFF2, 0xFFF6, 0x0000, 0x0000, 0xFFF2, 0xFFF6,
    0x0000, 0x0000, 0xFFF2, 0xFFF6, 0x0000, 0x0000, 0xFFF2, 0xFFF6,
    0x0000, 0x0000, 0xFFF2, 0xFFF6, 0x0000, 0x0000, 0xFFF2, 0xFFF6,
    0x0000, 0x0000, 0xFFF2, 0xFFF6, 0x0000, 0x0000, 0xFFF2, 0xFFF6,
    0x0000, 0x0000, 0xFFF2, 0xFFF6, 0x0000, 0x0000, 0xFFF2, 0xFFF6,
    0x0000, 0x0000, 0xFFF2, 0xFFF6, 0x0000, 0x0000, 0xFFF2, 0xFFF5,
    0x0000, 0x0000, 0xFFF2, 0xFFF5, 0x0000, 0x0000, 0xFFF2, 0xFFF5,
    0x0000, 0x0000, 0xFFF2, 0xFFF5, 0x0000, 0x0000, 0xFFF2, 0xFFF5,
    0x0000, 0x0000, 0xFFF2, 0xFFF5, 0x0000, 0x0000, 0xFFF2, 0xFFF5,
    0x0000, 0x0000, 0xFFF2, 0xFFF5, 0x0000, 0x0000, 0xFFF2, 0xFFF5,
    0x0000, 0x0000, 0xFFF2, 0xFFF5, 0x0000, 0x0000, 0xFFF2, 0xFFF5,
    0x0000, 0x0000, 0xFFF2, 0xFFF5, 0x0000, 0x0000, 0xFFF2, 0xFFF5,
    0x0000, 0x0000, 0xFFF2, 0xFFF5, 0x0000, 0x0000, 0xFFF2, 0xFFF5,
    0x0000, 0x0000, 0xFFF2, 0xFFF4, 0x0000, 0x0000, 0xFFF2, 0xFFF4,
    0x0000, 0x0000, 0xFFF2, 0xFFF4, 0x0000, 0x0000, 0xFFF2, 0xFFF4,
    0x0000, 0x0000, 0xFFF2, 0xFFF4, 0x0000, 0x0000, 0xFFF2, 0xFFF4,
    0x0000, 0x0000, 0xFFF2, 0xFFF4, 0x0000, 0x0000, 0xFFF2, 0xFFF4,
    0x0000, 0x0000, 0xFFF2, 0xFFF4, 0x0000, 0x0000, 0xFFF2, 0xFFF4,
    0x0000, 0x0000, 0xFFF2, 0xFFF4, 0x0000, 0x0000, 0xFFF2, 0xFFF4,
    0x0000, 0x0000, 0xFFF2, 0xFFF4, 0x0000, 0x0000, 0xFFF2, 0xFFF3,
    0x0000, 0x0000, 0xFFF2, 0xFFF3, 0x0000, 0x0000, 0xFFF2, 0xFFF3,
    0x0000, 0x0000, 0xFFF2, 0xFFF3, 0x0000, 0x0000, 0xFFF2, 0xFFF3,
    0x0000, 0x0000, 0xFFF2, 0xFFF3, 0x0000, 0x0000, 0xFFF2, 0xFFF3,
    0x0000, 0x0000, 0xFFF2, 0xFFF3, 0x0000, 0x0000, 0xFFF2, 0xFFF3,
    0x0000, 0x0000, 0xFFF2, 0xFFF3, 0x0000, 0x0000, 0xFFF2, 0xFFF3,
    0x0000, 0x0000, 0xFFF2, 0xFFF3, 0x0000, 0x0000, 0xFFF2, 0xFFF2,
    0x0000, 0x0000, 0xFFF2, 0xFFF2, 0x0000, 0x0000, 0xFFF2, 0xFFF2,
    0x0000, 0x0000, 0xFFF2, 0xFFF2, 0x0000, 0x0000, 0xFFF2, 0xFFF2,
    0x0000, 0x0000, 0xFFF2, 0xFFF2, 0x0000, 0x0000, 0xFFF2, 0xFFF2,
    0x0000, 0x0000, 0xFFF2, 0xFFF2, 0x0000, 0x0000, 0xFFF2, 0xFFF2,
    0x0000, 0x0000, 0xFFF2, 0xFFF2, 0x0000, 0x0000, 0xFFF2, 0xFFF2,
    0x0000, 0x0000, 0xFFF2, 0xFFF2, 0x0000, 0x0000, 0xFFF2, 0xFFF1,
    0x0000, 0x0000, 0xFFF2, 0xFFF1, 0x0000, 0x0000, 0xFFF2, 0xFFF1,
    0x0000, 0x0000, 0xFFF2, 0xFFF1, 0x0000, 0x0000, 0xFFF2, 0xFFF1,
    0x0000, 0x0000, 0xFFF2, 0xFFF1, 0x0000, 0x0000, 0xFFF2, 0xFFF1,
    0x0000, 0x0000, 0xFFF2, 0xFFF1, 0x0000, 0x0000, 0xFFF2, 0xFFF1,
    0x0000, 0x0000, 0xFFF2, 0xFFF1, 0x0000, 0x0000, 0xFFF2, 0xFFF1,
    0x0000, 0x0000, 0xFFF2, 0xFFF0, 0x0000, 0x0000, 0xFFF2, 0xFFF0,
    0x0000, 0x0000, 0xFFF2, 0xFFF0, 0x0000, 0x0000, 0xFFF2, 0xFFF0,
    0x0000, 0x0000, 0xFFF2, 0xFFF0, 0x0000, 0x0000, 0xFFF2, 0xFFF0,
    0x0000, 0x0000, 0xFFF2, 0xFFF0, 0x0000, 0x0000, 0xFFF2, 0xFFF0,
    0x0000, 0x0000, 0xFFF2, 0xFFF0, 0x0000, 0x0000, 0xFFF2, 0xFFF0,
    0x0000, 0x0000, 0xFFF2, 0xFFEF, 0x0000, 0x0000, 0xFFF2, 0xFFEF,
    0x0000, 0x0000, 0xFFF2, 0xFFEF, 0x0000, 0x0000, 0xFFF2, 0xFFEF,
    0x0000, 0x0000, 0xFFF2, 0xFFEF, 0x0000, 0x0000, 0xFFF2, 0xFFEF,
    0x0000, 0x0000, 0xFFF2, 0xFFEF, 0x0000, 0x0000, 0xFFF2, 0xFFEF,
    0x0000, 0x0000, 0xFFF2, 0xFFEF, 0x0000, 0x0000, 0xFFF2, 0xFFEF,
    0x0000, 0x0000, 0xFFF2, 0xFFEE, 0x0000, 0x0000, 0xFFF2, 0xFFEE,
    0x0000, 0x0000, 0xFFF2, 0xFFEE, 0x0000, 0x0000, 0xFFF2, 0xFFEE,
    0x0000, 0x0000, 0xFFF2, 0xFFEE, 0x0000, 0x0000, 0xFFF2, 0xFFEE,
    0x0000, 0x0000, 0xFFF2, 0xFFEE, 0x0000, 0x0000, 0xFFF2, 0xFFEE,
    0x0000, 0x0000, 0xFFF2, 0xFFED, 0x0000, 0x0000, 0xFFF2, 0xFFED,
    0x0000, 0x0000, 0xFFF2, 0xFFED, 0x0000, 0x0000, 0xFFF2, 0xFFED,
    0x0000, 0x0000, 0xFFF2, 0xFFED, 0x0000, 0x0000, 0xFFF2, 0xFFED,
    0x0000, 0x0000, 0xFFF2, 0xFFED, 0x0000, 0x0000, 0xFFF2, 0xFFED,
    0x0000, 0x0000, 0xFFF2, 0xFFED, 0x0000, 0x0000, 0xFFF2, 0xFFEC,
    0x0000, 0x0000, 0xFFF2, 0xFFEC, 0x0000, 0x0000, 0xFFF2, 0xFFEC,
    0x0000, 0x0000, 0xFFF2, 0xFFEC, 0x0000, 0x0000, 0xFFF2, 0xFFEC,
    0x0000, 0x0000, 0xFFF2, 0xFFEC, 0x0000, 0x0000, 0xFFF2, 0xFFEC,
    0x0000, 0x0000, 0xFFF2, 0xFFEB, 0x0000, 0x0000, 0xFFF2, 0xFFEB,
    0x0000, 0x0000, 0xFFF2, 0xFFEB, 0x0000, 0x0000, 0xFFF2, 0xFFEB,
    0x0000, 0x0000, 0xFFF2, 0xFFEB, 0x0000, 0x0000, 0xFFF2, 0xFFEB,
    0x0000, 0x0000, 0xFFF2, 0xFFEB, 0x0000, 0x0000, 0xFFF2, 0xFFEB,
    0x0000, 0x0000, 0xFFF2, 0xFFEA, 0x0000, 0x0000, 0xFFF2, 0xFFEA,
    0x0000, 0x0000, 0xFFF2, 0xFFEA, 0x0000, 0x0000, 0xFFF2, 0xFFEA,
    0x0000, 0x0000, 0xFFF2, 0xFFEA, 0x0000, 0x0000, 0xFFF2, 0xFFEA,
    0x0000, 0x0000, 0xFFF2, 0xFFE9, 0x0000, 0x0000, 0xFFF2, 0xFFE9,
    0x0000, 0x0000, 0xFFF2, 0xFFE9, 0x0000, 0x0000, 0xFFF2, 0xFFE9,
    0x0000, 0x0000, 0xFFF2, 0xFFE9, 0x0000, 0x0000, 0xFFF2, 0xFFE9,
    0x0000, 0x0000, 0xFFF2, 0xFFE9, 0x0000, 0x0000, 0xFFF2, 0xFFE8,
    0x0000, 0x0000, 0xFFF2, 0xFFE8, 0x0000, 0x0000, 0xFFF2, 0xFFE8,
    0x0000, 0x0000, 0xFFF2, 0xFFE8, 0x0000, 0x0000, 0xFFF2, 0xFFE8,
    0x0000, 0x0000, 0xFFF2, 0xFFE8, 0x0000, 0x0000, 0xFFF2, 0xFFE7,
    0x0000, 0x0000, 0xFFF2, 0xFFE7, 0x0000, 0x0000, 0xFFF2, 0xFFE7,
    0x0000, 0x0000, 0xFFF2, 0xFFE7, 0x0000, 0x0000, 0xFFF2, 0xFFE7,
    0x0000, 0x0000, 0xFFF2, 0xFFE6, 0x0000, 0x0000, 0xFFF2, 0xFFE6,
    0x0000, 0x0000, 0xFFF2, 0xFFE6, 0x0000, 0x0000, 0xFFF2, 0xFFE6,
    0x0000, 0x0000, 0xFFF2, 0xFFE6, 0x0000, 0x0000, 0xFFF2, 0xFFE6,
    0x0000, 0x0000, 0xFFF2, 0xFFE5, 0x0000, 0x0000, 0xFFF2, 0xFFE5,
    0x0000, 0x0000, 0xFFF2, 0xFFE5, 0x0000, 0x0000, 0xFFF2, 0xFFE5,
    0x0000, 0x0000, 0xFFF2, 0xFFE5, 0x0000, 0x0000, 0xFFF2, 0xFFE4,
    0x0000, 0x0000, 0xFFF2, 0xFFE4, 0x0000, 0x0000, 0xFFF2, 0xFFE4,
    0x0000, 0x0000, 0xFFF2, 0xFFE4, 0x0000, 0x0000, 0xFFF2, 0xFFE4,
    0x0000, 0x0000, 0xFFF2, 0xFFE3, 0x0000, 0x0000, 0xFFF2, 0xFFE3,
    0x0000, 0x0000, 0xFFF2, 0xFFE3, 0x0000, 0x0000, 0xFFF2, 0xFFE3,
    0x0000, 0x0000, 0xFFF2, 0xFFE2, 0x0000, 0x0000, 0xFFF2, 0xFFE2,
    0x0000, 0x0000, 0xFFF2, 0xFFE2, 0x0000, 0x0000, 0xFFF2, 0xFFE2,
    0x0000, 0x0000, 0xFFF2, 0xFFE1, 0x0000, 0x0000, 0xFFF2, 0xFFE1,
    0x0000, 0x0000, 0xFFF2, 0xFFE1, 0x0000, 0x0000, 0xFFF2, 0xFFE1,
    0x0000, 0x0000, 0xFFF2, 0xFFE0, 0x0000, 0x0000, 0xFFF2, 0xFFE0,
    0x0000, 0x0000, 0xFFF2, 0xFFE0, 0x0000, 0x0000, 0xFFF2, 0xFFE0,
    0x0000, 0x0000, 0xFFF2, 0xFFDF, 0x0000, 0x0000, 0xFFF2, 0xFFDF,
    0x0000, 0x0000, 0xFFF2, 0xFFDF, 0x0000, 0x0000, 0xFFF2, 0xFFDF,
    0x0000, 0x0000, 0xFFF2, 0xFFDE, 0x0000, 0x0000, 0xFFF2, 0xFFDE,
    0x0000, 0x0000, 0xFFF2, 0xFFDE, 0x0000, 0x0000, 0xFFF2, 0xFFDD,
    0x0000, 0x0000, 0xFFF2, 0xFFDD, 0x0000, 0x0000, 0xFFF2, 0xFFDD,
    0x0000, 0x0000, 0xFFF2, 0xFFDC, 0x0000, 0x0000, 0xFFF2, 0xFFDC,
    0x0000, 0x0000, 0xFFF2, 0xFFDC, 0x0000, 0x0000, 0xFFF2, 0xFFDC,
    0x0000, 0x0000, 0xFFF2, 0xFFDB, 0x0000, 0x0000, 0xFFF2, 0xFFDB,
    0x0000, 0x0000, 0xFFF2, 0xFFDA, 0x0000, 0x0000, 0xFFF2, 0xFFDA,
    0x0000, 0x0000, 0xFFF2, 0xFFDA, 0x0000, 0x0000, 0xFFF2, 0xFFD9,
    0x0000, 0x0000, 0xFFF2, 0xFFD9, 0x0000, 0x0000, 0xFFF2, 0xFFD9,
    0x0000, 0x0000, 0xFFF2, 0xFFD8, 0x0000, 0x0000, 0xFFF2, 0xFFD8,
    0x0000, 0x0000, 0xFFF2, 0xFFD8, 0x0000, 0x0000, 0xFFF2, 0xFFD7,
    0x0000, 0x0000, 0xFFF2, 0xFFD7, 0x0000, 0x0000, 0xFFF2, 0xFFD6,
    0x0000, 0x0000, 0xFFF2, 0xFFD6, 0x0000, 0x0000, 0xFFF2, 0xFFD6,
    0x0000, 0x0000, 0xFFF2, 0xFFD5, 0x0000, 0x0000, 0xFFF2, 0xFFD5,
    0x0000, 0x0000, 0xFFF2, 0xFFD4, 0x0000, 0x0000, 0xFFF2, 0xFFD4,
    0x0000, 0x0000, 0xFFF2, 0xFFD3, 0x0000, 0x0000, 0xFFF2, 0xFFD3,
    0x0000, 0x0000, 0xFFF2, 0xFFD2, 0x0000, 0x0000, 0xFFF2, 0xFFD2,
    0x0000, 0x0000, 0xFFF2, 0xFFD1, 0x0000, 0x0000, 0xFFF2, 0xFFD1,
    0x0000, 0x0000, 0xFFF2, 0xFFD0, 0x0000, 0x0000, 0xFFF2, 0xFFD0,
    0x0000, 0x0000, 0xFFF2, 0xFFCF, 0x0000, 0x0000, 0xFFF2, 0xFFCF,
    0x0000, 0x0000, 0xFFF2, 0xFFCE, 0x0000, 0x0000, 0xFFF2, 0xFFCD,
    0x0000, 0x0000, 0xFFF2, 0xFFCD, 0x0000, 0x0000, 0xFFF2, 0xFFCC,
    0x0000, 0x0000, 0xFFF2, 0xFFCC, 0x0000, 0x0000, 0xFFF2, 0xFFCB,
    0x0000, 0x0000, 0xFFF2, 0xFFCA, 0x0000, 0x0000, 0xFFF2, 0xFFCA,
    0x0000, 0x0000, 0xFFF2, 0xFFC9, 0x0000, 0x0000, 0xFFF2, 0xFFC8,
    0x0000, 0x0000, 0xFFF2, 0xFFC8, 0x0000, 0x0000, 0xFFF2, 0xFFC7,
    0x0000, 0x0000, 0xFFF2, 0xFFC6, 0x0000, 0x0000, 0xFFF2, 0xFFC5,
    0x0000, 0x0000, 0xFFF2, 0xFFC5, 0x0000, 0x0000, 0xFFF2, 0xFFC4,
    0x0000, 0x0000, 0xFFF2, 0xFFC3, 0x0000, 0x0000, 0xFFF2, 0xFFC2,
    0x0000, 0x0000, 0xFFF2, 0xFFC1, 0x0000, 0x0000, 0xFFF2, 0xFFC0,
    0x0000, 0x0000, 0xFFF2, 0xFFBF, 0x0000, 0x0000, 0xFFF2, 0xFFBE,
    0x0000, 0x0000, 0xFFF2, 0xFFBD, 0x0000, 0x0000, 0xFFF2, 0xFFBC,
    0x0000, 0x0000, 0xFFF2, 0xFFBB, 0x0000, 0x0000, 0xFFF2, 0xFFBA,
    0x0000, 0x0000, 0xFFF2, 0xFFB9, 0x0000, 0x0000, 0xFFF2, 0xFFB8,
    0x0000, 0x0000, 0xFFF2, 0xFFB7, 0x0000, 0x0000, 0xFFF2, 0xFFB6,
    0x0000, 0x0000, 0xFFF2, 0xFFB5, 0x0000, 0x0000, 0xFFF2, 0xFFB3,
    0x0000, 0x0000, 0xFFF2, 0xFFB2, 0x0000, 0x0000, 0xFFF2, 0xFFB1,
    0x0000, 0x0000, 0xFFF2, 0xFFAF, 0x0000, 0x0000, 0xFFF2, 0xFFAE,
    0x0000, 0x0000, 0xFFF2, 0xFFAC, 0x0000, 0x0000, 0xFFF2, 0xFFAB,
    0x0000, 0x0000, 0xFFF2, 0xFFA9, 0x0000, 0x0000, 0xFFF2, 0xFFA7,
    0x0000, 0x0000, 0xFFF2, 0xFFA6, 0x0000, 0x0000, 0xFFF2, 0xFFA4,
    0x0000, 0x0000, 0xFFF2, 0xFFA2, 0x0000, 0x0000, 0xFFF2, 0xFFA0,
    0x0000, 0x0000, 0xFFF2, 0xFF9E, 0x0000, 0x0000, 0xFFF2, 0xFF9C,
    0x0000, 0x0000, 0xFFF2, 0xFF9A, 0x0000, 0x0000, 0xFFF2, 0xFF97,
    0x0000, 0x0000, 0xFFF2, 0xFF95, 0x0000, 0x0000, 0xFFF2, 0xFF92,
    0x0000, 0x0000, 0xFFF2, 0xFF90, 0x0000, 0x0000, 0xFFF2, 0xFF8D,
    0x0000, 0x0000, 0xFFF2, 0xFF8A, 0x0000, 0x0000, 0xFFF2, 0xFF87,
    0x0000, 0x0000, 0xFFF2, 0xFF83, 0x0000, 0x0000, 0xFFF2, 0xFF80,
    0x0000, 0x0000, 0xFFF2, 0xFF7C, 0x0000, 0x0000, 0xFFF2, 0xFF78,
    0x0000, 0x0000, 0xFFF2, 0xFF74, 0x0000, 0x0000, 0xFFF2, 0xFF70,
    0x0000, 0x0000, 0xFFF2, 0xFF6B, 0x0000, 0x0000, 0xFFF2, 0xFF67,
    0x0000, 0x0000, 0xFFF2, 0xFF61, 0x0000, 0x0000, 0xFFF2, 0xFF5C,
    0x0000, 0x0000, 0xFFF2, 0xFF56, 0x0000, 0x0000, 0xFFF2, 0xFF4F,
    0x0000, 0x0000, 0xFFF2, 0xFF48, 0x0000, 0x0000, 0xFFF2, 0xFF41,
    0x0000, 0x0000, 0xFFF2, 0xFF39, 0x0000, 0x0000, 0xFFF2, 0xFF30,
    0x0000, 0x0000, 0xFFF2, 0xFF26, 0x0000, 0x0000, 0xFFF2, 0xFF1B,
    0x0000, 0x0000, 0xFFF2, 0xFF10, 0x0000, 0x0000, 0xFFF2, 0xFF03,
    0x0000, 0x0000, 0xFFF2, 0xFEF4, 0x0000, 0x0000, 0xFFF2, 0xFEE4,
    0x0000, 0x0000, 0xFFF2, 0xFED1, 0x0000, 0x0000, 0xFFF2, 0xFEBD,
    0x0000, 0x0000, 0xFFF2, 0xFEA5, 0x0000, 0x0000, 0xFFF2, 0xFE89,
    0x0000, 0x0000, 0xFFF2, 0xFE68, 0x0000, 0x0000, 0xFFF2, 0xFE41,
    0x0000, 0x0000, 0xFFF2, 0xFE12, 0x0000, 0x0000, 0xFFF2, 0xFDD8,
    0x0000, 0x0000, 0xFFF2, 0xFD8E, 0x0000, 0x0000, 0xFFF2, 0xFD2E,
    0x0000, 0x0000, 0xFFF2, 0xFCAB, 0x0000, 0x0000, 0xFFF2, 0xFBED,
    0x0000, 0x0000, 0xFFF2, 0xFAC3, 0x0000, 0x0000, 0xFFF2, 0xF8AB,
    0x0000, 0x0000, 0xFFF2, 0xF3C7, 0x0000, 0x0000, 0xFFF2, 0xDB55
    };

static const q15_t ref_cfft_step_2048[4096] = {
    0x399A, 0x0000, 0xFFF2, 0x24AB, 0x0000, 0x0000, 0xFFF2, 0x0C39,
    0x0000, 0x0000, 0xFFF2, 0x0755, 0x0000, 0x0000, 0xFFF2, 0x053D,
    0x0000, 0x0000, 0xFFF2, 0x0413, 0x0000, 0x0000, 0xFFF2, 0x0355,
    0x0000, 0x0000, 0xFFF2, 0x02D2, 0x0000, 0x0000, 0xFFF2, 0x0272,
    0x0000, 0x0000, 0xFFF2, 0x0228, 0x0000, 0x0000, 0xFFF2, 0x01EE,
    0x0000, 0x0000, 0xFFF2, 0x01BF, 0x0000, 0x0000, 0xFFF2, 0x0198,
    0x0000, 0x0000, 0xFFF2, 0x0177, 0x0000, 0x0000, 0xFFF2, 0x015B,
    0x0000, 0x0000, 0xFFF2, 0x0143, 0x0000, 0x0000, 0xFFF2, 0x012F,
    0x0000, 0x0000, 0xFFF2, 0x011C, 0x0000, 0x0000, 0xFFF2, 0x010C,
    0x0000, 0x0000, 0xFFF2, 0x00FD, 0x0000, 0x0000, 0xFFF2, 0x00F0,
    0x0000, 0x0000, 0xFFF2, 0x00E5, 0x0000, 0x0000, 0xFFF2, 0x00DA,
    0x0000, 0x0000, 0xFFF2, 0x00D0, 0x0000, 0x0000, 0xFFF2, 0x00C7,
    0x0000, 0x0000, 0xFFF2, 0x00BF, 0x0000, 0x0000, 0xFFF2, 0x00B8,
    0x0000, 0x0000, 0xFFF2, 0x00B1, 0x0000, 0x0000, 0xFFF2, 0x00AA,
    0x0000, 0x0000, 0xFFF2, 0x00A4, 0x0000, 0x0000, 0xFFF2, 0x009F,
    0x0000, 0x0000, 0xFFF2, 0x0099, 0x0000, 0x0000, 0xFFF2, 0x0095,
    0x0000, 0x0000, 0xFFF2, 0x0090, 0x0000, 0x0000, 0xFFF2, 0x008C,
    0x0000, 0x0000, 0xFFF2, 0x0088, 0x0000, 0x0000, 0xFFF2, 0x0084,
    0x0000, 0x0000, 0xFFF2, 0x0080, 0x0000, 0x0000, 0xFFF2, 0x007D,
    0x0000, 0x0000, 0xFFF2, 0x0079, 0x0000, 0x0000, 0xFFF2, 0x0076,
    0x0000, 0x0000, 0xFFF2, 0x0073, 0x0000, 0x0000, 0xFFF2, 0x0070,
    0x0000, 0x0000, 0xFFF2, 0x006E, 0x0000, 0x0000, 0xFFF2, 0x006B,
    0x0000, 0x0000, 0xFFF2, 0x0069, 0x0000, 0x0000, 0xFFF2, 0x0066,
    0x0000, 0x0000, 0xFFF2, 0x0064, 0x0000, 0x0000, 0xFFF2, 0x0062,
    0x0000, 0x0000, 0xFFF2, 0x0060, 0x0000, 0x0000, 0xFFF2, 0x005E,
    0x0000, 0x0000, 0xFFF2, 0x005C, 0x0000, 0x0000, 0xFFF2, 0x005A,
    0x0000, 0x0000, 0xFFF2, 0x0059, 0x0000, 0x0000, 0xFFF2, 0x0057,
    0x0000, 0x0000, 0xFFF2, 0x0055, 0x0000, 0x0000, 0xFFF2, 0x0054,
    0x0000, 0x0000, 0xFFF2, 0x0052, 0x0000, 0x0000, 0xFFF2, 0x0051,
    0x0000, 0x0000, 0xFFF2, 0x004F, 0x0000, 0x0000, 0xFFF2, 0x004E,
    0x0000, 0x0000, 0xFFF2, 0x004D, 0x0000, 0x0000, 0xFFF2, 0x004B,
    0x0000, 0x0000, 0xFFF2, 0x004A, 0x0000, 0x0000, 0xFFF2, 0x0049,
    0x0000, 0x0000, 0xFFF2, 0x0048, 0x0000, 0x0000, 0xFFF2, 0x0047,
    0x0000, 0x0000, 0xFFF2, 0x0046, 0x0000, 0x0000, 0xFFF2, 0x0045,
    0x0000, 0x0000, 0xFFF2, 0x0044, 0x0000, 0x0000, 0xFFF2, 0x0043,
    0x0000, 0x0000, 0xFFF2, 0x0042, 0x0000, 0x0000, 0xFFF2, 0x0041,
    0x0000, 0x0000, 0xFFF2, 0x0040, 0x0000, 0x0000, 0xFFF2, 0x003F,
    0x0000, 0x0000, 0xFFF2, 0x003E, 0x0000, 0x0000, 0xFFF2, 0x003D,
    0x0000, 0x0000, 0xFFF2, 0x003C, 0x0000, 0x0000, 0xFFF2, 0x003B,
    0x0000, 0x0000, 0xFFF2, 0x003B, 0x0000, 0x0000, 0xFFF2, 0x003A,
    0x0000, 0x0000, 0xFFF2, 0x0039, 0x0000, 0x0000, 0xFFF2, 0x0038,
    0x0000, 0x0000, 0xFFF2, 0x0038, 0x0000, 0x0000, 0xFFF2, 0x0037,
    0x0000, 0x0000, 0xFFF2, 0x0036, 0x0000, 0x0000, 0xFFF2, 0x0036,
    0x0000, 0x0000, 0xFFF2, 0x0035, 0x0000, 0x0000, 0xFFF2, 0x0034,
    0x0000, 0x0000, 0xFFF2, 0x0034, 0x0000, 0x0000, 0xFFF2, 0x0033,
    0x0000, 0x0000, 0xFFF2, 0x0033, 0x0000, 0x0000, 0xFFF2, 0x0032,
    0x0000, 0x0000, 0xFFF2, 0x0031, 0x0000, 0x0000, 0xFFF2, 0x0031,
    0x0000, 0x0000, 0xFFF2, 0x0030, 0x0000, 0x0000, 0xFFF2, 0x0030,
    0x0000, 0x0000, 0xFFF2, 0x002F, 0x0000, 0x0000, 0xFFF2, 0x002F,
    0x0000, 0x0000, 0xFFF2, 0x002E, 0x0000, 0x0000, 0xFFF2, 0x002E,
    0x0000, 0x0000, 0xFFF2, 0x002D, 0x0000, 0x0000, 0xFFF2, 0x002D,
    0x0000, 0x0000, 0xFFF2, 0x002C, 0x0000, 0x0000, 0xFFF2, 0x002C,
    0x0000, 0x0000, 0xFFF2, 0x002B, 0x0000, 0x0000, 0xFFF2, 0x002B,
    0x0000, 0x0000, 0xFFF2, 0x002A, 0x0000, 0x0000, 0xFFF2, 0x002A,
    0x0000, 0x0000, 0xFFF2, 0x002A, 0x0000, 0x0000, 0xFFF2, 0x0029,
    0x0000, 0x0000, 0xFFF2, 0x0029, 0x0000, 0x0000, 0xFFF2, 0x0028,
    0x0000, 0x0000, 0xFFF2, 0x0028, 0x0000, 0x0000, 0xFFF2, 0x0028,
    0x0000, 0x0000, 0xFFF2, 0x0027, 0x0000, 0x0000, 0xFFF2, 0x0027,
    0x0000, 0x0000, 0xFFF2, 0x0027, 0x0000, 0x0000, 0xFFF2, 0x0026,
    0x0000, 0x0000, 0xFFF2, 0x0026, 0x0000, 0x0000, 0xFFF2, 0x0026,
    0x0000, 0x0000, 0xFFF2, 0x0025, 0x0000, 0x0000, 0xFFF2, 0x0025,
    0x0000, 0x0000, 0xFFF2, 0x0024, 0x0000, 0x0000, 0xFFF2, 0x0024,
    0x0000, 0x0000, 0xFFF2, 0x0024, 0x0000, 0x0000, 0xFFF2, 0x0024,
    0x0000, 0x0000, 0xFFF2, 0x0023, 0x0000, 0x0000, 0xFFF2, 0x0023,
    0x0000, 0x0000, 0xFFF2, 0x0023, 0x0000, 0x0000, 0xFFF2, 0x0022,
    0x0000, 0x0000, 0xFFF2, 0x0022, 0x0000, 0x0000, 0xFFF2, 0x0022,
    0x0000, 0x0000, 0xFFF2, 0x0021, 0x0000, 0x0000, 0xFFF2, 0x0021,
    0x0000, 0x0000, 0xFFF2, 0x0021, 0x0000, 0x0000, 0xFFF2, 0x0021,
    0x0000, 0x0000, 0xFFF2, 0x0020, 0x0000, 0x0000, 0xFFF2, 0x0020,
    0x0000, 0x0000, 0xFFF2, 0x0020, 0x0000, 0x0000, 0xFFF2, 0x0020,
    0x0000, 0x0000, 0xFFF2, 0x001F, 0x0000, 0x0000, 0xFFF2, 0x001F,
    0x0000, 0x0000, 0xFFF2, 0x001F, 0x0000, 0x0000, 0xFFF2, 0x001F,
    0x0000, 0x0000, 0xFFF2, 0x001E, 0x0000, 0x0000, 0xFFF2, 0x001E,
    0x0000, 0x0000, 0xFFF2, 0x001E, 0x0000, 0x0000, 0xFFF2, 0x001E,
    0x0000, 0x0000, 0xFFF2, 0x001D, 0x0000, 0x0000, 0xFFF2, 0x001D,
    0x0000, 0x0000, 0xFFF2, 0x001D, 0x0000, 0x0000, 0xFFF2, 0x001D,
    0x0000, 0x0000, 0xFFF2, 0x001C, 0x0000, 0x0000, 0xFFF2, 0x001C,
    0x0000, 0x0000, 0xFFF2, 0x001C, 0x0000, 0x0000, 0xFFF2, 0x001C,
    0x0000, 0x0000, 0xFFF2, 0x001C, 0x0000, 0x0000, 0xFFF2, 0x001B,
    0x0000, 0x0000, 0xFFF2, 0x001B, 0x0000, 0x0000, 0xFFF2, 0x001B,
    0x0000, 0x0000, 0xFFF2, 0x001B, 0x0000, 0x0000, 0xFFF2, 0x001B,
    0x0000, 0x0000, 0xFFF2, 0x001A, 0x0000, 0x0000, 0xFFF2, 0x001A,
    0x0000, 0x0000, 0xFFF2, 0x001A, 0x0000, 0x0000, 0xFFF2, 0x001A,
    0x0000, 0x0000, 0xFFF2, 0x001A, 0x0000, 0x0000, 0xFFF2, 0x001A,
    0x0000, 0x0000, 0xFFF2, 0x0019, 0x0000, 0x0000, 0xFFF2, 0x0019,
    0x0000, 0x0000, 0xFFF2, 0x0019, 0x0000, 0x0000, 0xFFF2, 0x0019,
    0x0000, 0x0000, 0xFFF2, 0x0019, 0x0000, 0x0000, 0xFFF2, 0x0018,
    0x0000, 0x0000, 0xFFF2, 0x0018, 0x0000, 0x0000, 0xFFF2, 0x0018,
    0x0000, 0x0000, 0xFFF2, 0x0018, 0x0000, 0x0000, 0xFFF2, 0x0018,
    0x0000, 0x0000, 0xFFF2, 0x0018, 0x0000, 0x0000, 0xFFF2, 0x0017,
    0x0000, 0x0000, 0xFFF2, 0x0017, 0x0000, 0x0000, 0xFFF2, 0x0017,
    0x0000, 0x0000, 0xFFF2, 0x0017, 0x0000, 0x0000, 0xFFF2, 0x0017,
    0x0000, 0x0000, 0xFFF2, 0x0017, 0x0000, 0x0000, 0xFFF2, 0x0017,
    0x0000, 0x0000, 0xFFF2, 0x0016, 0x0000, 0x0000, 0xFFF2, 0x0016,
    0x0000, 0x0000, 0xFFF2, 0x0016, 0x0000, 0x0000, 0xFFF2, 0x0016,
    0x0000, 0x0000, 0xFFF2, 0x0016, 0x0000, 0x0000, 0xFFF2, 0x0016,
    0x0000, 0x0000, 0xFFF2, 0x0015, 0x0000, 0x0000, 0xFFF2, 0x0015,
    0x0000, 0x0000, 0xFFF2, 0x0015, 0x0000, 0x0000, 0xFFF2, 0x0015,
    0x0000, 0x0000, 0xFFF2, 0x0015, 0x0000, 0x0000, 0xFFF2, 0x0015,
    0x0000, 0x0000, 0xFFF2, 0x0015, 0x0000, 0x0000, 0xFFF2, 0x0015,
    0x0000, 0x0000, 0xFFF2, 0x0014, 0x0000, 0x0000, 0xFFF2, 0x0014,
    0x0000, 0x0000, 0xFFF2, 0x0014, 0x0000, 0x0000, 0xFFF2, 0x0014,
    0x0000, 0x0000, 0xFFF2, 0x0014, 0x0000, 0x0000, 0xFFF2, 0x0014,
    0x0000, 0x0000, 0xFFF2, 0x0014, 0x0000, 0x0000, 0xFFF2, 0x0013,
    0x0000, 0x0000, 0xFFF2, 0x0013, 0x0000, 0x0000, 0xFFF2, 0x0013,
    0x0000, 0x0000, 0xFFF2, 0x0013, 0x0000, 0x0000, 0xFFF2, 0x0013,
    0x0000, 0x0000, 0xFFF2, 0x0013, 0x0000, 0x0000, 0xFFF2, 0x0013,
    0x0000, 0x0000, 0xFFF2, 0x0013, 0x0000, 0x0000, 0xFFF2, 0x0013,
    0x0000, 0x0000, 0xFFF2, 0x0012, 0x0000, 0x0000, 0xFFF2, 0x0012,
    0x0000, 0x0000, 0xFFF2, 0x0012, 0x0000, 0x0000, 0xFFF2, 0x0012,
    0x0000, 0x0000, 0xFFF2, 0x0012, 0x0000, 0x0000, 0xFFF2, 0x0012,
    0x0000, 0x0000, 0xFFF2, 0x0012, 0x0000, 0x0000, 0xFFF2, 0x0012,
    0x0000, 0x0000, 0xFFF2, 0x0011, 0x0000, 0x0000, 0xFFF2, 0x0011,
    0x0000, 0x0000, 0xFFF2, 0x0011, 0x0000, 0x0000, 0xFFF2, 0x0011,
    0x0000, 0x0000, 0xFFF2, 0x0011, 0x0000, 0x0000, 0xFFF2, 0x0011,
    0x0000, 0x0000, 0xFFF2, 0x0011, 0x0000, 0x0000, 0xFFF2, 0x0011,
    0x0000, 0x0000, 0xFFF2, 0x0011, 0x0000, 0x0000, 0xFFF2, 0x0011,
    0x0000, 0x0000, 0xFFF2, 0x0010, 0x0000, 0x0000, 0xFFF2, 0x0010,
    0x0000, 0x0000, 0xFFF2, 0x0010, 0x0000, 0x0000, 0xFFF2, 0x0010,
    0x0000, 0x0000, 0xFFF2, 0x0010, 0x0000, 0x0000, 0xFFF2, 0x0010,
    0x0000, 0x0000, 0xFFF2, 0x0010, 0x0000, 0x0000, 0xFFF2, 0x0010,
    0x0000, 0x0000, 0xFFF2, 0x0010, 0x0000, 0x0000, 0xFFF2, 0x0010,
    0x0000, 0x0000, 0xFFF2, 0x000F, 0x0000, 0x0000, 0xFFF2, 0x000F,
    0x0000, 0x0000, 0xFFF2, 0x000F, 0x0000, 0x0000, 0xFFF2, 0x000F,
    0x0000, 0x0000, 0xFFF2, 0x000F, 0x0000, 0x0000, 0xFFF2, 0x000F,
    0x0000, 0x0000, 0xFFF2, 0x000F, 0x0000, 0x0000, 0xFFF2, 0x000F,
    0x0000, 0x0000, 0xFFF2, 0x000F, 0x0000, 0x0000, 0xFFF2, 0x000F,
    0x0000, 0x0000, 0xFFF2, 0x000F, 0x0000, 0x0000, 0xFFF2, 0x000E,
    0x0000, 0x0000, 0xFFF2, 0x000E, 0x0000, 0x0000, 0xFFF2, 0x000E,
    0x0000, 0x0000, 0xFFF2, 0x000E, 0x0000, 0x0000, 0xFFF2, 0x000E,
    0x0000, 0x0000, 0xFFF2, 0x000E, 0x0000, 0x0000, 0xFFF2, 0x000E,
    0x0000, 0x0000, 0xFFF2, 0x000E, 0x0000, 0x0000, 0xFFF2, 0x000E,
    0x0000, 0x0000, 0xFFF2, 0x000E, 0x0000, 0x0000, 0xFFF2, 0x000E,
    0x0000, 0x0000, 0xFFF2, 0x000E, 0x0000, 0x0000, 0xFFF2, 0x000D,
    0x0000, 0x0000, 0xFFF2, 0x000D, 0x0000, 0x0000, 0xFFF2, 0x000D,
    0x0000, 0x0000, 0xFFF2, 0x000D, 0x0000, 0x0000, 0xFFF2, 0x000D,
    0x0000, 0x0000, 0xFFF2, 0x000D, 0x0000, 0x0000, 0xFFF2, 0x000D,
    0x0000, 0x0000, 0xFFF2, 0x000D, 0x0000, 0x0000, 0xFFF2, 0x000D,
    0x0000, 0x0000, 0xFFF2, 0x000D, 0x0000, 0x0000, 0xFFF2, 0x000D,
    0x0000, 0x0000, 0xFFF2, 0x000D, 0x0000, 0x0000, 0xFFF2, 0x000C,
    0x0000, 0x0000, 0xFFF2, 0x000C, 0x0000, 0x0000, 0xFFF2, 0x000C,
    0x0000, 0x0000, 0xFFF2, 0x000C, 0x0000, 0x0000, 0xFFF2, 0x000C,
    0x0000, 0x0000, 0xFFF2, 0x000C, 0x0000, 0x0000, 0xFFF2, 0x000C,
    0x0000, 0x0000, 0xFFF2, 0x000C, 0x0000, 0x0000, 0xFFF2, 0x000C,
    0x0000, 0x0000, 0xFFF2, 0x000C, 0x0000, 0x0000, 0xFFF2, 0x000C,
    0x0000, 0x0000, 0xFFF2, 0x000C, 0x0000, 0x0000, 0xFFF2, 0x000C,
    0x0000, 0x0000, 0xFFF2, 0x000B, 0x0000, 0x0000, 0xFFF2, 0x000B,
    0x0000, 0x0000, 0xFFF2, 0x000B, 0x0000, 0x0000, 0xFFF2, 0x000B,
    0x0000, 0x0000, 0xFFF2, 0x000B, 0x0000, 0x0000, 0xFFF2, 0x000B,
    0x0000, 0x0000, 0xFFF2, 0x000B, 0x0000, 0x0000, 0xFFF2, 0x000B,
    0x0000, 0x0000, 0xFFF2, 0x000B, 0x0000, 0x0000, 0xFFF2, 0x000B,
    0x0000, 0x0000, 0xFFF2, 0x000B, 0x0000, 0x0000, 0xFFF2, 0x000B,
    0x0000, 0x0000, 0xFFF2, 0x000B, 0x0000, 0x0000, 0xFFF2, 0x000B,
    0x0000, 0x0000, 0xFFF2, 0x000B, 0x0000, 0x0000, 0xFFF2, 0x000A,
    0x0000, 0x0000, 0xFFF2, 0x000A, 0x0000, 0x0000, 0xFFF2, 0x000A,
    0x0000, 0x0000, 0xFFF2, 0x000A, 0x0000, 0x0000, 0xFFF2, 0x000A,
    0x0000, 0x0000, 0xFFF2, 0x000A, 0x0000, 0x0000, 0xFFF2, 0x000A,
    0x0000, 0x0000, 0xFFF2, 0x000A, 0x0000, 0x0000, 0xFFF2, 0x000A,
    0x0000, 0x0000, 0xFFF2, 0x000A, 0x0000, 0x0000, 0xFFF2, 0x000A,
    0x0000, 0x0000, 0xFFF2, 0x000A, 0x0000, 0x0000, 0xFFF2, 0x000A,
    0x0000, 0x0000, 0xFFF2, 0x000A, 0x0000, 0x0000, 0xFFF2, 0x000A,
    0x0000, 0x0000, 0xFFF2, 0x0009, 0x0000, 0x0000, 0xFFF2, 0x0009,
    0x0000, 0x0000, 0xFFF2, 0x0009, 0x0000, 0x0000, 0xFFF2, 0x0009,
    0x0000, 0x0000, 0xFFF2, 0x0009, 0x0000, 0x0000, 0xFFF2, 0x0009,
    0x0000, 0x0000, 0xFFF2, 0x0009, 0x0000, 0x0000, 0xFFF2, 0x0009,
    0x0000, 0x0000, 0xFFF2, 0x0009, 0x0000, 0x0000, 0xFFF2, 0x0009,
    0x0000, 0x0000, 0xFFF2, 0x0009, 0x0000, 0x0000, 0xFFF2, 0x0009,
    0x0000, 0x0000, 0xFFF2, 0x0009, 0x0000, 0x0000, 0xFFF2, 0x0009,
    0x0000, 0x0000, 0xFFF2, 0x0009, 0x0000, 0x0000, 0xFFF2, 0x0009,
    0x0000, 0x0000, 0xFFF2, 0x0008, 0x0000, 0x0000, 0xFFF2, 0x0008,
    0x0000, 0x0000, 0xFFF2, 0x0008, 0x0000, 0x0000, 0xFFF2, 0x0008,
    0x0000, 0x0000, 0xFFF2, 0x0008, 0x0000, 0x0000, 0xFFF2, 0x0008,
    0x0000, 0x0000, 0xFFF2, 0x0008, 0x0000, 0x0000, 0xFFF2, 0x0008,
    0x0000, 0x0000, 0xFFF2, 0x0008, 0x0000, 0x0000, 0xFFF2, 0x0008,
    0x0000, 0x0000, 0xFFF2, 0x0008, 0x0000, 0x0000, 0xFFF2, 0x0008,
    0x0000, 0x0000, 0xFFF2, 0x0008, 0x0000, 0x0000, 0xFFF2, 0x0008,
    0x0000, 0x0000, 0xFFF2, 0x0008, 0x0000, 0x0000, 0xFFF2, 0x0008,
    0x0000, 0x0000, 0xFFF2, 0x0008, 0x0000, 0x0000, 0xFFF2, 0x0007,
    0x0000, 0x0000, 0xFFF2, 0x0007, 0x0000, 0x0000, 0xFFF2, 0x0007,
    0x0000, 0x0000, 0xFFF2, 0x0007, 0x0000, 0x0000, 0xFFF2, 0x0007,
    0x0000, 0x0000, 0xFFF2, 0x0007, 0x0000, 0x0000, 0xFFF2, 0x0007,
    0x0000, 0x0000, 0xFFF2, 0x0007, 0x0000, 0x0000, 0xFFF2, 0x0007,
    0x0000, 0x0000, 0xFFF2, 0x0007, 0x0000, 0x0000, 0xFFF2, 0x0007,
    0x0000, 0x0000, 0xFFF2, 0x0007, 0x0000, 0x0000, 0xFFF2, 0x0007,
    0x0000, 0x0000, 0xFFF2, 0x0007, 0x0000, 0x0000, 0xFFF2, 0x0007,
    0x0000, 0x0000, 0xFFF2, 0x0007, 0x0000, 0x0000, 0xFFF2, 0x0007,
    0x0000, 0x0000, 0xFFF2, 0x0007, 0x0000, 0x0000, 0xFFF2, 0x0007,
    0x0000, 0x0000, 0xFFF2, 0x0006, 0x0000, 0x0000, 0xFFF2, 0x0006,
    0x0000, 0x0000, 0xFFF2, 0x0006, 0x0000, 0x0000, 0xFFF2, 0x0006,
    0x0000, 0x0000, 0xFFF2, 0x0006, 0x0000, 0x0000, 0xFFF2, 0x0006,
    0x0000, 0x0000, 0xFFF2, 0x0006, 0x0000, 0x0000, 0xFFF2, 0x0006,
    0x0000, 0x0000, 0xFFF2, 0x0006, 0x0000, 0x0000, 0xFFF2, 0x0006,
    0x0000, 0x0000, 0xFFF2, 0x0006, 0x0000, 0x0000, 0xFFF2, 0x0006,
    0x0000, 0x0000, 0xFFF2, 0x0006, 0x0000, 0x0000, 0xFFF2, 0x0006,
    0x0000, 0x0000, 0xFFF2, 0x0006, 0x0000, 0x0000, 0xFFF2, 0x0006,
    0x0000, 0x0000, 0xFFF2, 0x0006, 0x0000, 0x0000, 0xFFF2, 0x0006,
    0x0000, 0x0000, 0xFFF2, 0x0006, 0x0000, 0x0000, 0xFFF2, 0x0005,
    0x0000, 0x0000, 0xFFF2, 0x0005, 0x0000, 0x0000, 0xFFF2, 0x0005,
    0x0000, 0x0000, 0xFFF2, 0x0005, 0x0000, 0x0000, 0xFFF2, 0x0005,
    0x0000, 0x0000, 0xFFF2, 0x0005, 0x0000, 0x0000, 0xFFF2, 0x0005,
    0x0000, 0x0000, 0xFFF2, 0x0005, 0x0000, 0x0000, 0xFFF2, 0x0005,
    0x0000, 0x0000, 0xFFF2, 0x0005, 0x0000, 0x0000, 0xFFF2, 0x0005,
    0x0000, 0x0000, 0xFFF2, 0x0005, 0x0000, 0x0000, 0xFFF2, 0x0005,
    0x0000, 0x0000, 0xFFF2, 0x0005, 0x0000, 0x0000, 0xFFF2, 0x0005,
    0x0000, 0x0000, 0xFFF2, 0x0005, 0x0000, 0x0000, 0xFFF2, 0x0005,
    0x0000, 0x0000, 0xFFF2, 0x0005, 0x0000, 0x0000, 0xFFF2, 0x0005,
    0x0000, 0x0000, 0xFFF2, 0x0005, 0x0000, 0x0000, 0xFFF2, 0x0004,
    0x0000, 0x0000, 0xFFF2, 0x0004, 0x0000, 0x0000, 0xFFF2, 0x0004,
    0x0000, 0x0000, 0xFFF2, 0x0004, 0x0000, 0x0000, 0xFFF2, 0x0004,
    0x0000, 0x0000, 0xFFF2, 0x0004, 0x0000, 0x0000, 0xFFF2, 0x0004,
    0x0000, 0x0000, 0xFFF2, 0x0004, 0x0000, 0x0000, 0xFFF2, 0x0004,
    0x0000, 0x0000, 0xFFF2, 0x0004, 0x0000, 0x0000, 0xFFF2, 0x0004,
    0x0000, 0x0000, 0xFFF2, 0x0004, 0x0000, 0x0000, 0xFFF2, 0x0004,
    0x0000, 0x0000, 0xFFF2, 0x0004, 0x0000, 0x0000, 0xFFF2, 0x0004,
    0x0000, 0x0000, 0xFFF2, 0x0004, 0x0000, 0x0000, 0xFFF2, 0x0004,
    0x0000, 0x0000, 0xFFF2, 0x0004, 0x0000, 0x0000, 0xFFF2, 0x0004,
    0x0000, 0x0000, 0xFFF2, 0x0004, 0x0000, 0x0000, 0xFFF2, 0x0004,
    0x0000, 0x0000, 0xFFF2, 0x0003, 0x0000, 0x0000, 0xFFF2, 0x0003,
    0x0000, 0x0000, 0xFFF2, 0x0003, 0x0000, 0x0000, 0xFFF2, 0x0003,
    0x0000, 0x0000, 0xFFF2, 0x0003, 0x0000, 0x0000, 0xFFF2, 0x0003,
    0x0000, 0x0000, 0xFFF2, 0x0003, 0x0000, 0x0000, 0xFFF2, 0x0003,
    0x0000, 0x0000, 0xFFF2, 0x0003, 0x0000, 0x0000, 0xFFF2, 0x0003,
    0x0000, 0x0000, 0xFFF2, 0x0003, 0x0000, 0x0000, 0xFFF2, 0x0003,
    0x0000, 0x0000, 0xFFF2, 0x0003, 0x0000, 0x0000, 0xFFF2, 0x0003,
    0x0000, 0x0000, 0xFFF2, 0x0003, 0x0000, 0x0000, 0xFFF2, 0x0003,
    0x0000, 0x0000, 0xFFF2, 0x0003, 0x0000, 0x0000, 0xFFF2, 0x0003,
    0x0000, 0x0000, 0xFFF2, 0x0003, 0x0000, 0x0000, 0xFFF2, 0x0003,
    0x0000, 0x0000, 0xFFF2, 0x0003, 0x0000, 0x0000, 0xFFF2, 0x0003,
    0x0000, 0x0000, 0xFFF2, 0x0002, 0x0000, 0x0000, 0xFFF2, 0x0002,
    0x0000, 0x0000, 0xFFF2, 0x0002, 0x0000, 0x0000, 0xFFF2, 0x0002,
    0x0000, 0x0000, 0xFFF2, 0x0002, 0x0000, 0x0000, 0xFFF2, 0x0002,
    0x0000, 0x0000, 0xFFF2, 0x0002, 0x0000, 0x0000, 0xFFF2, 0x0002,
    0x0000, 0x0000, 0xFFF2, 0x0002, 0x0000, 0x0000, 0xFFF2, 0x0002,
    0x0000, 0x0000, 0xFFF2, 0x0002, 0x0000, 0x0000, 0xFFF2, 0x0002,
    0x0000, 0x0000, 0xFFF2, 0x0002, 0x0000, 0x0000, 0xFFF2, 0x0002,
    0x0000, 0x0000, 0xFFF2, 0x0002, 0x0000, 0x0000, 0xFFF2, 0x0002,
    0x0000, 0x0000, 0xFFF2, 0x0002, 0x0000, 0x0000, 0xFFF2, 0x0002,
    0x0000, 0x0000, 0xFFF2, 0x0002, 0x0000, 0x0000, 0xFFF2, 0x0002,
    0x0000, 0x0000, 0xFFF2, 0x0002, 0x0000, 0x0000, 0xFFF2, 0x0002,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0001,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0001,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0001,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0001,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0001,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0001,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0001,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0001,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0001,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0001,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0001,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0000,
    0x0000, 0x0000, 0xFFF2, 0x0000, 0x0000, 0x0000, 0xFFF2, 0x0000,
    0x0000, 0x0000, 0xFFF2, 0x0000, 0x0000, 0x0000, 0xFFF2, 0x0000,
    0x0000, 0x0000, 0xFFF2, 0x0000, 0x0000, 0x0000, 0xFFF2, 0x0000,
    0x0000, 0x0000, 0xFFF2, 0x0000, 0x0000, 0x0000, 0xFFF2, 0x0000,
    0x0000, 0x0000, 0xFFF2, 0x0000, 0x0000, 0x0000, 0xFFF2, 0x0000,
    0x0000, 0x0000, 0xFFF2, 0x0000, 0x0000, 0x0000, 0xFFF2, 0x0000,
    0x0000, 0x0000, 0xFFF2, 0x0000, 0x0000, 0x0000, 0xFFF2, 0x0000,
    0x0000, 0x0000, 0xFFF2, 0x0000, 0x0000, 0x0000, 0xFFF2, 0x0000,
    0x0000, 0x0000, 0xFFF2, 0x0000, 0x0000, 0x0000, 0xFFF2, 0x0000,
    0x0000, 0x0000, 0xFFF2, 0x0000, 0x0000, 0x0000, 0xFFF2, 0x0000,
    0x0000, 0x0000, 0xFFF2, 0x0000, 0x0000, 0x0000, 0xFFF2, 0xFFFF,
    0x0000, 0x0000, 0xFFF2, 0xFFFF, 0x0000, 0x0000, 0xFFF2, 0xFFFF,
    0x0000, 0x0000, 0xFFF2, 0xFFFF, 0x0000, 0x0000, 0xFFF2, 0xFFFF,
    0x0000, 0x0000, 0xFFF2, 0xFFFF, 0x0000, 0x0000, 0xFFF2, 0xFFFF,
    0x0000, 0x0000, 0xFFF2, 0xFFFF, 0x0000, 0x0000, 0xFFF2, 0xFFFF,
    0x0000, 0x0000, 0xFFF2, 0xFFFF, 0x0000, 0x0000, 0xFFF2, 0xFFFF,
    0x0000, 0x0000, 0xFFF2, 0xFFFF, 0x0000, 0x0000, 0xFFF2, 0xFFFF,
    0x0000, 0x0000, 0xFFF2, 0xFFFF, 0x0000, 0x0000, 0xFFF2, 0xFFFF,
    0x0000, 0x0000, 0xFFF2, 0xFFFF, 0x0000, 0x0000, 0xFFF2, 0xFFFF,
    0x0000, 0x0000, 0xFFF2, 0xFFFF, 0x0000, 0x0000, 0xFFF2, 0xFFFF,
    0x0000, 0x0000, 0xFFF2, 0xFFFF, 0x0000, 0x0000, 0xFFF2, 0xFFFF,
    0x0000, 0x0000, 0xFFF2, 0xFFFF, 0x0000, 0x0000, 0xFFF2, 0xFFFF,
    0x0000, 0x0000, 0xFFF2, 0xFFFE, 0x0000, 0x0000, 0xFFF2, 0xFFFE,
    0x0000, 0x0000, 0xFFF2, 0xFFFE, 0x0000, 0x0000, 0xFFF2, 0xFFFE,
    0x0000, 0x0000, 0xFFF2, 0xFFFE, 0x0000, 0x0000, 0xFFF2, 0xFFFE,
    0x0000, 0x0000, 0xFFF2, 0xFFFE, 0x0000, 0x0000, 0xFFF2, 0xFFFE,
    0x0000, 0x0000, 0xFFF2, 0xFFFE, 0x0000, 0x0000, 0xFFF2, 0xFFFE,
    0x0000, 0x0000, 0xFFF2, 0xFFFE, 0x0000, 0x0000, 0xFFF2, 0xFFFE,
    0x0000, 0x0000, 0xFFF2, 0xFFFE, 0x0000, 0x0000, 0xFFF2, 0xFFFE,
    0x0000, 0x0000, 0xFFF2, 0xFFFE, 0x0000, 0x0000, 0xFFF2, 0xFFFE,
    0x0000, 0x0000, 0xFFF2, 0xFFFE, 0x0000, 0x0000, 0xFFF2, 0xFFFE,
    0x0000, 0x0000, 0xFFF2, 0xFFFE, 0x0000, 0x0000, 0xFFF2, 0xFFFE,
    0x0000, 0x0000, 0xFFF2, 0xFFFE, 0x0000, 0x0000, 0xFFF2, 0xFFFE,
    0x0000, 0x0000, 0xFFF2, 0xFFFD, 0x0000, 0x0000, 0xFFF2, 0xFFFD,
    0x0000, 0x0000, 0xFFF2, 0xFFFD, 0x0000, 0x0000, 0xFFF2, 0xFFFD,
    0x0000, 0x0000, 0xFFF2, 0xFFFD, 0x0000, 0x0000, 0xFFF2, 0xFFFD,
    0x0000, 0x0000, 0xFFF2, 0xFFFD, 0x0000, 0x0000, 0xFFF2, 0xFFFD,
    0x0000, 0x0000, 0xFFF2, 0xFFFD, 0x0000, 0x0000, 0xFFF2, 0xFFFD,
    0x0000, 0x0000, 0xFFF2, 0xFFFD, 0x0000, 0x0000, 0xFFF2, 0xFFFD,
    0x0000, 0x0000, 0xFFF2, 0xFFFD, 0x0000, 0x0000, 0xFFF2, 0xFFFD,
    0x0000, 0x0000, 0xFFF2, 0xFFFD, 0x0000, 0x0000, 0xFFF2, 0xFFFD,
    0x0000, 0x0000, 0xFFF2, 0xFFFD, 0x0000, 0x0000, 0xFFF2, 0xFFFD,
    0x0000, 0x0000, 0xFFF2, 0xFFFD, 0x0000, 0x0000, 0xFFF2, 0xFFFD,
    0x0000, 0x0000, 0xFFF2, 0xFFFD, 0x0000, 0x0000, 0xFFF2, 0xFFFD,
    0x0000, 0x0000, 0xFFF2, 0xFFFC, 0x0000, 0x0000, 0xFFF2, 0xFFFC,
    0x0000, 0x0000, 0xFFF2, 0xFFFC, 0x0000, 0x0000, 0xFFF2, 0xFFFC,
    0x0000, 0x0000, 0xFFF2, 0xFFFC, 0x0000, 0x0000, 0xFFF2, 0xFFFC,
    0x0000, 0x0000, 0xFFF2, 0xFFFC, 0x0000, 0x0000, 0xFFF2, 0xFFFC,
    0x0000, 0x0000, 0xFFF2, 0xFFFC, 0x0000, 0x0000, 0xFFF2, 0xFFFC,
    0x0000, 0x0000, 0xFFF2, 0xFFFC, 0x0000, 0x0000, 0xFFF2, 0xFFFC,
    0x0000, 0x0000, 0xFFF2, 0xFFFC, 0x0000, 0x0000, 0xFFF2, 0xFFFC,
    0x0000, 0x0000, 0xFFF2, 0xFFFC, 0x0000, 0x0000, 0xFFF2, 0xFFFC,
    0x0000, 0x0000, 0xFFF2, 0xFFFC, 0x0000, 0x0000, 0xFFF2, 0xFFFC,
    0x0000, 0x0000, 0xFFF2, 0xFFFC, 0x0000, 0x0000, 0xFFF2, 0xFFFC,
    0x0000, 0x0000, 0xFFF2, 0xFFFC, 0x0000, 0x0000, 0xFFF2, 0xFFFB,
    0x0000, 0x0000, 0xFFF2, 0xFFFB, 0x0000, 0x0000, 0xFFF2, 0xFFFB,
    0x0000, 0x0000, 0xFFF2, 0xFFFB, 0x0000, 0x0000, 0xFFF2, 0xFFFB,
    0x0000, 0x0000, 0xFFF2, 0xFFFB, 0x0000, 0x0000, 0xFFF2, 0xFFFB,
    0x0000, 0x0000, 0xFFF2, 0xFFFB, 0x0000, 0x0000, 0xFFF2, 0xFFFB,
    0x0000, 0x0000, 0xFFF2, 0xFFFB, 0x0000, 0x0000, 0xFFF2, 0xFFFB,
    0x0000, 0x0000, 0xFFF2, 0xFFFB, 0x0000, 0x0000, 0xFFF2, 0xFFFB,
    0x0000, 0x0000, 0xFFF2, 0xFFFB, 0x0000, 0x0000, 0xFFF2, 0xFFFB,
    0x0000, 0x0000, 0xFFF2, 0xFFFB, 0x0000, 0x0000, 0xFFF2, 0xFFFB,
    0x0000, 0x0000, 0xFFF2, 0xFFFB, 0x0000, 0x0000, 0xFFF2, 0xFFFB,
    0x0000, 0x0000, 0xFFF2, 0xFFFB, 0x0000, 0x0000, 0xFFF2, 0xFFFA,
    0x0000, 0x0000, 0xFFF2, 0xFFFA, 0x0000, 0x0000, 0xFFF2, 0xFFFA,
    0x0000, 0x0000, 0xFFF2, 0xFFFA, 0x0000, 0x0000, 0xFFF2, 0xFFFA,
    0x0000, 0x0000, 0xFFF2, 0xFFFA, 0x0000, 0x0000, 0xFFF2, 0xFFFA,
    0x0000, 0x0000, 0xFFF2, 0xFFFA, 0x0000, 0x0000, 0xFFF2, 0xFFFA,
    0x0000, 0x0000, 0xFFF2, 0xFFFA, 0x0000, 0x0000, 0xFFF2, 0xFFFA,
    0x0000, 0x0000, 0xFFF2, 0xFFFA, 0x0000, 0x0000, 0xFFF2, 0xFFFA,
    0x0000, 0x0000, 0xFFF2, 0xFFFA, 0x0000, 0x0000, 0xFFF2, 0xFFFA,
    0x0000, 0x0000, 0xFFF2, 0xFFFA, 0x0000, 0x0000, 0xFFF2, 0xFFFA,
    0x0000, 0x0000, 0xFFF2, 0xFFFA, 0x0000, 0x0000, 0xFFF2, 0xFFFA,
    0x0000, 0x0000, 0xFFF2, 0xFFF9, 0x0000, 0x0000, 0xFFF2, 0xFFF9,
    0x0000, 0x0000, 0xFFF2, 0xFFF9, 0x0000, 0x0000, 0xFFF2, 0xFFF9,
    0x0000, 0x0000, 0xFFF2, 0xFFF9, 0x0000, 0x0000, 0xFFF2, 0xFFF9,
    0x0000, 0x0000, 0xFFF2, 0xFFF9, 0x0000, 0x0000, 0xFFF2, 0xFFF9,
    0x0000, 0x0000, 0xFFF2, 0xFFF9, 0x0000, 0x0000, 0xFFF2, 0xFFF9,
    0x0000, 0x0000, 0xFFF2, 0xFFF9, 0x0000, 0x0000, 0xFFF2, 0xFFF9,
    0x0000, 0x0000, 0xFFF2, 0xFFF9, 0x0000, 0x0000, 0xFFF2, 0xFFF9,
    0x0000, 0x0000, 0xFFF2, 0xFFF9, 0x0000, 0x0000, 0xFFF2, 0xFFF9,
    0x0000, 0x0000, 0xFFF2, 0xFFF9, 0x0000, 0x0000, 0xFFF2, 0xFFF9,
    0x0000, 0x0000, 0xFFF2, 0xFFF9, 0x0000, 0x0000, 0xFFF2, 0xFFF8,
    0x0000, 0x0000, 0xFFF2, 0xFFF8, 0x0000, 0x0000, 0xFFF2, 0xFFF8,
    0x0000, 0x0000, 0xFFF2, 0xFFF8, 0x0000, 0x0000, 0xFFF2, 0xFFF8,
    0x0000, 0x0000, 0xFFF2, 0xFFF8, 0x0000, 0x0000, 0xFFF2, 0xFFF8,
    0x0000, 0x0000, 0xFFF2, 0xFFF8, 0x0000, 0x0000, 0xFFF2, 0xFFF8,
    0x0000, 0x0000, 0xFFF2, 0xFFF8, 0x0000, 0x0000, 0xFFF2, 0xFFF8,
    0x0000, 0x0000, 0xFFF2, 0xFFF8, 0x0000, 0x0000, 0xFFF2, 0xFFF8,
    0x0000, 0x0000, 0xFFF2, 0xFFF8, 0x0000, 0x0000, 0xFFF2, 0xFFF8,
    0x0000, 0x0000, 0xFFF2, 0xFFF8, 0x0000, 0x0000, 0xFFF2, 0xFFF8,
    0x0000, 0x0000, 0xFFF2, 0xFFF7, 0x0000, 0x0000, 0xFFF2, 0xFFF7,
    0x0000, 0x0000, 0xFFF2, 0xFFF7, 0x0000, 0x0000, 0xFFF2, 0xFFF7,
    0x0000, 0x0000, 0xFFF2, 0xFFF7, 0x0000, 0x0000, 0xFFF2, 0xFFF7,
    0x0000, 0x0000, 0xFFF2, 0xFFF7, 0x0000, 0x0000, 0xFFF2, 0xFFF7,
    0x0000, 0x0000, 0xFFF2, 0xFFF7, 0x0000, 0x0000, 0xFFF2, 0xFFF7,
    0x0000, 0x0000, 0xFFF2, 0xFFF7, 0x0000, 0x0000, 0xFFF2, 0xFFF7,
    0x0000, 0x0000, 0xFFF2, 0xFFF7, 0x0000, 0x0000, 0xFFF2, 0xFFF7,
    0x0000, 0x0000, 0xFFF2, 0xFFF7, 0x0000, 0x0000, 0xFFF2, 0xFFF7,
    0x0000, 0x0000, 0xFFF2, 0xFFF6, 0x0000, 0x0000, 0xFFF2, 0xFFF6,
    0x0000, 0x0000, 0xFFF2, 0xFFF6, 0x0000, 0x0000, 0xFFF2, 0xFFF6,
    0x0000, 0x0000, 0xFFF2, 0xFFF6, 0x0000, 0x0000, 0xFFF2, 0xFFF6,
    0x0000, 0x0000, 0xFFF2, 0xFFF6, 0x0000, 0x0000, 0xFFF2, 0xFFF6,
    0x0000, 0x0000, 0xFFF2, 0xFFF6, 0x0000, 0x0000, 0xFFF2, 0xFFF6,
    0x0000, 0x0000, 0xFFF2, 0xFFF6, 0x0000, 0x0000, 0xFFF2, 0xFFF6,
    0x0000, 0x0000, 0xFFF2, 0xFFF6, 0x0000, 0x0000, 0xFFF2, 0xFFF6,
    0x0000, 0x0000, 0xFFF2, 0xFFF6, 0x0000, 0x0000, 0xFFF2, 0xFFF5,
    0x0000, 0x0000, 0xFFF2, 0xFFF5, 0x0000, 0x0000, 0xFFF2, 0xFFF5,
    0x0000, 0x0000, 0xFFF2, 0xFFF5, 0x0000, 0x0000, 0xFFF2, 0xFFF5,
    0x0000, 0x0000, 0xFFF2, 0xFFF5, 0x0000, 0x0000, 0xFFF2, 0xFFF5,
    0x0000, 0x0000, 0xFFF2, 0xFFF5, 0x0000, 0x0000, 0xFFF2, 0xFFF5,
    0x0000, 0x0000, 0xFFF2, 0xFFF5, 0x0000, 0x0000, 0xFFF2, 0xFFF5,
    0x0000, 0x0000, 0xFFF2, 0xFFF5, 0x0000, 0x0000, 0xFFF2, 0xFFF5,
    0x0000, 0x0000, 0xFFF2, 0xFFF5, 0x0000, 0x0000, 0xFFF2, 0xFFF5,
    0x0000, 0x0000, 0xFFF2, 0xFFF4, 0x0000, 0x0000, 0xFFF2, 0xFFF4,
    0x0000, 0x0000, 0xFFF2, 0xFFF4, 0x0000, 0x0000, 0xFFF2, 0xFFF4,
    0x0000, 0x0000, 0xFFF2, 0xFFF4, 0x0000, 0x0000, 0xFFF2, 0xFFF4,
    0x0000, 0x0000, 0xFFF2, 0xFFF4, 0x0000, 0x0000, 0xFFF2, 0xFFF4,
    0x0000, 0x0000, 0xFFF2, 0xFFF4, 0x0000, 0x0000, 0xFFF2, 0xFFF4,
    0x0000, 0x0000, 0xFFF2, 0xFFF4, 0x0000, 0x0000, 0xFFF2, 0xFFF4,
    0x0000, 0x0000, 0xFFF2, 0xFFF4, 0x0000, 0x0000, 0xFFF2, 0xFFF3,
    0x0000, 0x0000, 0xFFF2, 0xFFF3, 0x0000, 0x0000, 0xFFF2, 0xFFF3,
    0x0000, 0x0000, 0xFFF2, 0xFFF3, 0x0000, 0x0000, 0xFFF2, 0xFFF3,
    0x0000, 0x0000, 0xFFF2, 0xFFF3, 0x0000, 0x0000, 0xFFF2, 0xFFF3,
    0x0000, 0x0000, 0xFFF2, 0xFFF3, 0x0000, 0x0000, 0xFFF2, 0xFFF3,
    0x0000, 0x0000, 0xFFF2, 0xFFF3, 0x0000, 0x0000, 0xFFF2, 0xFFF3,
    0x0000, 0x0000, 0xFFF2, 0xFFF3, 0x0000, 0x0000, 0xFFF2, 0xFFF2,
    0x0000, 0x0000, 0xFFF2, 0xFFF2, 0x0000, 0x0000, 0xFFF2, 0xFFF2,
    0x0000, 0x0000, 0xFFF2, 0xFFF2, 0x0000, 0x0000, 0xFFF2, 0xFFF2,
    0x0000, 0x0000, 0xFFF2, 0xFFF2, 0x0000, 0x0000, 0xFFF2, 0xFFF2,
    0x0000, 0x0000, 0xFFF2, 0xFFF2, 0x0000, 0x0000, 0xFFF2, 0xFFF2,
    0x0000, 0x0000, 0xFFF2, 0xFFF2, 0x0000, 0x0000, 0xFFF2, 0xFFF2,
    0x0000, 0x0000, 0xFFF2, 0xFFF2, 0x0000, 0x0000, 0xFFF2, 0xFFF1,
    0x0000, 0x0000, 0xFFF2, 0xFFF1, 0x0000, 0x0000, 0xFFF2, 0xFFF1,
    0x0000, 0x0000, 0xFFF2, 0xFFF1, 0x0000, 0x0000, 0xFFF2, 0xFFF1,
    0x0000, 0x0000, 0xFFF2, 0xFFF1, 0x0000, 0x0000, 0xFFF2, 0xFFF1,
    0x0000, 0x0000, 0xFFF2, 0xFFF1, 0x0000, 0x0000, 0xFFF2, 0xFFF1,
    0x0000, 0x0000, 0xFFF2, 0xFFF1, 0x0000, 0x0000, 0xFFF2, 0xFFF1,
    0x0000, 0x0000, 0xFFF2, 0xFFF0, 0x0000, 0x0000, 0xFFF2, 0xFFF0,
    0x0000, 0x0000, 0xFFF2, 0xFFF0, 0x0000, 0x0000, 0xFFF2, 0xFFF0,
    0x0000, 0x0000, 0xFFF2, 0xFFF0, 0x0000, 0x0000, 0xFFF2, 0xFFF0,
    0x0000, 0x0000, 0xFFF2, 0xFFF0, 0x0000, 0x0000, 0xFFF2, 0xFFF0,
    0x0000, 0x0000, 0xFFF2, 0xFFF0, 0x0000, 0x0000, 0xFFF2, 0xFFF0,
    0x0000, 0x0000, 0xFFF2, 0xFFEF, 0x0000, 0x0000, 0xFFF2, 0xFFEF,
    0x0000, 0x0000, 0xFFF2, 0xFFEF, 0x0000, 0x0000, 0xFFF2, 0xFFEF,
    0x0000, 0x0000, 0xFFF2, 0xFFEF, 0x0000, 0x0000, 0xFFF2, 0xFFEF,
    0x0000, 0x0000, 0xFFF2, 0xFFEF, 0x0000, 0x0000, 0xFFF2, 0xFFEF,
    0x0000, 0x0000, 0xFFF2, 0xFFEF, 0x0000, 0x0000, 0xFFF2, 0xFFEF,
    0x0000, 0x0000, 0xFFF2, 0xFFEE, 0x0000, 0x0000, 0xFFF2, 0xFFEE,
    0x0000, 0x0000, 0xFFF2, 0xFFEE, 0x0000, 0x0000, 0xFFF2, 0xFFEE,
    0x0000, 0x0000, 0xFFF2, 0xFFEE, 0x0000, 0x0000, 0xFFF2, 0xFFEE,
    0x0000, 0x0000, 0xFFF2, 0xFFEE, 0x0000, 0x0000, 0xFFF2, 0xFFEE,
    0x0000, 0x0000, 0xFFF2, 0xFFED, 0x0000, 0x0000, 0xFFF2, 0xFFED,
    0x0000, 0x0000, 0xFFF2, 0xFFED, 0x0000, 0x0000, 0xFFF2, 0xFFED,
    0x0000, 0x0000, 0xFFF2, 0xFFED, 0x0000, 0x0000, 0xFFF2, 0xFFED,
    0x0000, 0x0000, 0xFFF2, 0xFFED, 0x0000, 0x0000, 0xFFF2, 0xFFED,
    0x0000, 0x0000, 0xFFF2, 0xFFED, 0x0000, 0x0000, 0xFFF2, 0xFFEC,
    0x0000, 0x0000, 0xFFF2, 0xFFEC, 0x0000, 0x0000, 0xFFF2, 0xFFEC,
    0x0000, 0x0000, 0xFFF2, 0xFFEC, 0x0000, 0x0000, 0xFFF2, 0xFFEC,
    0x0000, 0x0000, 0xFFF2, 0xFFEC, 0x0000, 0x0000, 0xFFF2, 0xFFEC,
    0x0000, 0x0000, 0xFFF2, 0xFFEB, 0x0000, 0x0000, 0xFFF2, 0xFFEB,
    0x0000, 0x0000, 0xFFF2, 0xFFEB, 0x0000, 0x0000, 0xFFF2, 0xFFEB,
    0x0000, 0x0000, 0xFFF2, 0xFFEB, 0x0000, 0x0000, 0xFFF2, 0xFFEB,
    0x0000, 0x0000, 0xFFF2, 0xFFEB, 0x0000, 0x0000, 0xFFF2, 0xFFEB,
    0x0000, 0x0000, 0xFFF2, 0xFFEA, 0x0000, 0x0000, 0xFFF2, 0xFFEA,
    0x0000, 0x0000, 0xFFF2, 0xFFEA, 0x0000, 0x0000, 0xFFF2, 0xFFEA,
    0x0000, 0x0000, 0xFFF2, 0xFFEA, 0x0000, 0x0000, 0xFFF2, 0xFFEA,
    0x0000, 0x0000, 0xFFF2, 0xFFE9, 0x0000, 0x0000, 0xFFF2, 0xFFE9,
    0x0000, 0x0000, 0xFFF2, 0xFFE9, 0x0000, 0x0000, 0xFFF2, 0xFFE9,
    0x0000, 0x0000, 0xFFF2, 0xFFE9, 0x0000, 0x0000, 0xFFF2, 0xFFE9,
    0x0000, 0x0000, 0xFFF2, 0xFFE9, 0x0000, 0x0000, 0xFFF2, 0xFFE8,
    0x0000, 0x0000, 0xFFF2, 0xFFE8, 0x0000, 0x0000, 0xFFF2, 0xFFE8,
    0x0000, 0x0000, 0xFFF2, 0xFFE8, 0x0000, 0x0000, 0xFFF2, 0xFFE8,
    0x0000, 0x0000, 0xFFF2, 0xFFE8, 0x0000, 0x0000, 0xFFF2, 0xFFE7,
    0x0000, 0x0000, 0xFFF2, 0xFFE7, 0x0000, 0x0000, 0xFFF2, 0xFFE7,
    0x0000, 0x0000, 0xFFF2, 0xFFE7, 0x0000, 0x0000, 0xFFF2, 0xFFE7,
    0x0000, 0x0000, 0xFFF2, 0xFFE6, 0x0000, 0x0000, 0xFFF2, 0xFFE6,
    0x0000, 0x0000, 0xFFF2, 0xFFE6, 0x0000, 0x0000, 0xFFF2, 0xFFE6,
    0x0000, 0x0000, 0xFFF2, 0xFFE6, 0x0000, 0x0000, 0xFFF2, 0xFFE6,
    0x0000, 0x0000, 0xFFF2, 0xFFE5, 0x0000, 0x0000, 0xFFF2, 0xFFE5,
    0x0000, 0x0000, 0xFFF2, 0xFFE5, 0x0000, 0x0000, 0xFFF2, 0xFFE5,
    0x0000, 0x0000, 0xFFF2, 0xFFE5, 0x0000, 0x0000, 0xFFF2, 0xFFE4,
    0x0000, 0x0000, 0xFFF2, 0xFFE4, 0x0000, 0x0000, 0xFFF2, 0xFFE4,
    0x0000, 0x0000, 0xFFF2, 0xFFE4, 0x0000, 0x0000, 0xFFF2, 0xFFE4,
    0x0000, 0x0000, 0xFFF2, 0xFFE3, 0x0000, 0x0000, 0xFFF2, 0xFFE3,
    0x0000, 0x0000, 0xFFF2, 0xFFE3, 0x0000, 0x0000, 0xFFF2, 0xFFE3,
    0x0000, 0x0000, 0xFFF2, 0xFFE2, 0x0000, 0x0000, 0xFFF2, 0xFFE2,
    0x0000, 0x0000, 0xFFF2, 0xFFE2, 0x0000, 0x0000, 0xFFF2, 0xFFE2,
    0x0000, 0x0000, 0xFFF2, 0xFFE1, 0x0000, 0x0000, 0xFFF2, 0xFFE1,
    0x0000, 0x0000, 0xFFF2, 0xFFE1, 0x0000, 0x0000, 0xFFF2, 0xFFE1,
    0x0000, 0x0000, 0xFFF2, 0xFFE0, 0x0000, 0x0000, 0xFFF2, 0xFFE0,
    0x0000, 0x0000, 0xFFF2, 0xFFE0, 0x0000, 0x0000, 0xFFF2, 0xFFE0,
    0x0000, 0x0000, 0xFFF2, 0xFFDF, 0x0000, 0x0000, 0xFFF2, 0xFFDF,
    0x0000, 0x0000, 0xFFF2, 0xFFDF, 0x0000, 0x0000, 0xFFF2, 0xFFDF,
    0x0000, 0x0000, 0xFFF2, 0xFFDE, 0x0000, 0x0000, 0xFFF2, 0xFFDE,
    0x0000, 0x0000, 0xFFF2, 0xFFDE, 0x0000, 0x0000, 0xFFF2, 0xFFDD,
    0x0000, 0x0000, 0xFFF2, 0xFFDD, 0x0000, 0x0000, 0xFFF2, 0xFFDD,
    0x0000, 0x0000, 0xFFF2, 0xFFDC, 0x0000, 0x0000, 0xFFF2, 0xFFDC,
    0x0000, 0x0000, 0xFFF2, 0xFFDC, 0x0000, 0x0000, 0xFFF2, 0xFFDC,
    0x0000, 0x0000, 0xFFF2, 0xFFDB, 0x0000, 0x0000, 0xFFF2, 0xFFDB,
    0x0000, 0x0000, 0xFFF2, 0xFFDA, 0x0000, 0x0000, 0xFFF2, 0xFFDA,
    0x0000, 0x0000, 0xFFF2, 0xFFDA, 0x0000, 0x0000, 0xFFF2, 0xFFD9,
    0x0000, 0x0000, 0xFFF2, 0xFFD9, 0x0000, 0x0000, 0xFFF2, 0xFFD9,
    0x0000, 0x0000, 0xFFF2, 0xFFD8, 0x0000, 0x0000, 0xFFF2, 0xFFD8,
    0x0000, 0x0000, 0xFFF2, 0xFFD8, 0x0000, 0x0000, 0xFFF2, 0xFFD7,
    0x0000, 0x0000, 0xFFF2, 0xFFD7, 0x0000, 0x0000, 0xFFF2, 0xFFD6,
    0x0000, 0x0000, 0xFFF2, 0xFFD6, 0x0000, 0x0000, 0xFFF2, 0xFFD6,
    0x0000, 0x0000, 0xFFF2, 0xFFD5, 0x0000, 0x0000, 0xFFF2, 0xFFD5,
    0x0000, 0x0000, 0xFFF2, 0xFFD4, 0x0000, 0x0000, 0xFFF2, 0xFFD4,
    0x0000, 0x0000, 0xFFF2, 0xFFD3, 0x0000, 0x0000, 0xFFF2, 0xFFD3,
    0x0000, 0x0000, 0xFFF2, 0xFFD2, 0x0000, 0x0000, 0xFFF2, 0xFFD2,
    0x0000, 0x0000, 0xFFF2, 0xFFD1, 0x0000, 0x0000, 0xFFF2, 0xFFD1,
    0x0000, 0x0000, 0xFFF2, 0xFFD0, 0x0000, 0x0000, 0xFFF2, 0xFFD0,
    0x0000, 0x0000, 0xFFF2, 0xFFCF, 0x0000, 0x0000, 0xFFF2, 0xFFCF,
    0x0000, 0x0000, 0xFFF2, 0xFFCE, 0x0000, 0x0000, 0xFFF2, 0xFFCD,
    0x0000, 0x0000, 0xFFF2, 0xFFCD, 0x0000, 0x0000, 0xFFF2, 0xFFCC,
    0x0000, 0x0000, 0xFFF2, 0xFFCC, 0x0000, 0x0000, 0xFFF2, 0xFFCB,
    0x0000, 0x0000, 0xFFF2, 0xFFCA, 0x0000, 0x0000, 0xFFF2, 0xFFCA,
    0x0000, 0x0000, 0xFFF2, 0xFFC9, 0x0000, 0x0000, 0xFFF2, 0xFFC8,
    0x0000, 0x0000, 0xFFF2, 0xFFC8, 0x0000, 0x0000, 0xFFF2, 0xFFC7,
    0x0000, 0x0000, 0xFFF2, 0xFFC6, 0x0000, 0x0000, 0xFFF2, 0xFFC5,
    0x0000, 0x0000, 0xFFF2, 0xFFC5, 0x0000, 0x0000, 0xFFF2, 0xFFC4,
    0x0000, 0x0000, 0xFFF2, 0xFFC3, 0x0000, 0x0000, 0xFFF2, 0xFFC2,
    0x0000, 0x0000, 0xFFF2, 0xFFC1, 0x0000, 0x0000, 0xFFF2, 0xFFC0,
    0x0000, 0x0000, 0xFFF2, 0xFFBF, 0x0000, 0x0000, 0xFFF2, 0xFFBE,
    0x0000, 0x0000, 0xFFF2, 0xFFBD, 0x0000, 0x0000, 0xFFF2, 0xFFBC,
    0x0000, 0x0000, 0xFFF2, 0xFFBB, 0x0000, 0x0000, 0xFFF2, 0xFFBA,
    0x0000, 0x0000, 0xFFF2, 0xFFB9, 0x0000, 0x0000, 0xFFF2, 0xFFB8,
    0x0000, 0x0000, 0xFFF2, 0xFFB7, 0x0000, 0x0000, 0xFFF2, 0xFFB6,
    0x0000, 0x0000, 0xFFF2, 0xFFB5, 0x0000, 0x0000, 0xFFF2, 0xFFB3,
    0x0000, 0x0000, 0xFFF2, 0xFFB2, 0x0000, 0x0000, 0xFFF2, 0xFFB1,
    0x0000, 0x0000, 0xFFF2, 0xFFAF, 0x0000, 0x0000, 0xFFF2, 0xFFAE,
    0x0000, 0x0000, 0xFFF2, 0xFFAC, 0x0000, 0x0000, 0xFFF2, 0xFFAB,
    0x0000, 0x0000, 0xFFF2, 0xFFA9, 0x0000, 0x0000, 0xFFF2, 0xFFA7,
    0x0000, 0x0000, 0xFFF2, 0xFFA6, 0x0000, 0x0000, 0xFFF2, 0xFFA4,
    0x0000, 0x0000, 0xFFF2, 0xFFA2, 0x0000, 0x0000, 0xFFF2, 0xFFA0,
    0x0000, 0x0000, 0xFFF2, 0xFF9E, 0x0000, 0x0000, 0xFFF2, 0xFF9C,
    0x0000, 0x0000, 0xFFF2, 0xFF9A, 0x0000, 0x0000, 0xFFF2, 0xFF97,
    0x0000, 0x0000, 0xFFF2, 0xFF95, 0x0000, 0x0000, 0xFFF2, 0xFF92,
    0x0000, 0x0000, 0xFFF2, 0xFF90, 0x0000, 0x0000, 0xFFF2, 0xFF8D,
    0x0000, 0x0000, 0xFFF2, 0xFF8A, 0x0000, 0x0000, 0xFFF2, 0xFF87,
    0x0000, 0x0000, 0xFFF2, 0xFF83, 0x0000, 0x0000, 0xFFF2, 0xFF80,
    0x0000, 0x0000, 0xFFF2, 0xFF7C, 0x0000, 0x0000, 0xFFF2, 0xFF78,
    0x0000, 0x0000, 0xFFF2, 0xFF74, 0x0000, 0x0000, 0xFFF2, 0xFF70,
    0x0000, 0x0000, 0xFFF2, 0xFF6B, 0x0000, 0x0000, 0xFFF2, 0xFF67,
    0x0000, 0x0000, 0xFFF2, 0xFF61, 0x0000, 0x0000, 0xFFF2, 0xFF5C,
    0x0000, 0x0000, 0xFFF2, 0xFF56, 0x0000, 0x0000, 0xFFF2, 0xFF4F,
    0x0000, 0x0000, 0xFFF2, 0xFF48, 0x0000, 0x0000, 0xFFF2, 0xFF41,
    0x0000, 0x0000, 0xFFF2, 0xFF39, 0x0000, 0x0000, 0xFFF2, 0xFF30,
    0x0000, 0x0000, 0xFFF2, 0xFF26, 0x0000, 0x0000, 0xFFF2, 0xFF1B,
    0x0000, 0x0000, 0xFFF2, 0xFF10, 0x0000, 0x0000, 0xFFF2, 0xFF03,
    0x0000, 0x0000, 0xFFF2, 0xFEF4, 0x0000, 0x0000, 0xFFF2, 0xFEE4,
    0x0000, 0x0000, 0xFFF2, 0xFED1, 0x0000, 0x0000, 0xFFF2, 0xFEBD,
    0x0000, 0x0000, 0xFFF2, 0xFEA5, 0x0000, 0x0000, 0xFFF2, 0xFE89,
    0x0000, 0x0000, 0xFFF2, 0xFE68, 0x0000, 0x0000, 0xFFF2, 0xFE41,
    0x0000, 0x0000, 0xFFF2, 0xFE12, 0x0000, 0x0000, 0xFFF2, 0xFDD8,
    0x0000, 0x0000, 0xFFF2, 0xFD8E, 0x0000, 0x0000, 0xFFF2, 0xFD2E,
    0x0000, 0x0000, 0xFFF2, 0xFCAB, 0x0000, 0x0000, 0xFFF2, 0xFBED,
    0x0000, 0x0000, 0xFFF2, 0xFAC3, 0x0000, 0x0000, 0xFFF2, 0xF8AB,
    0x0000, 0x0000, 0xFFF2, 0xF3C7, 0x0000, 0x0000, 0xFFF2, 0xDB55
    };

static const q15_t in_cfft_step_4096[8192] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000
    };

static const q15_t in_cifft_step_4096[8192] = {
    0x399A, 0x0000, 0xFFF9, 0x24AB, 0x0000, 0x0000, 0xFFF9, 0x0C39,
    0x0000, 0x0000, 0xFFF9, 0x0755, 0x0000, 0x0000, 0xFFF9, 0x053D,
    0x0000, 0x0000, 0xFFF9, 0x0413, 0x0000, 0x0000, 0xFFF9, 0x0355,
    0x0000, 0x0000, 0xFFF9, 0x02D2, 0x0000, 0x0000, 0xFFF9, 0x0272,
    0x0000, 0x0000, 0xFFF9, 0x0228, 0x0000, 0x0000, 0xFFF9, 0x01EE,
    0x0000, 0x0000, 0xFFF9, 0x01BF, 0x0000, 0x0000, 0xFFF9, 0x0198,
    0x0000, 0x0000, 0xFFF9, 0x0177, 0x0000, 0x0000, 0xFFF9, 0x015C,
    0x0000, 0x0000, 0xFFF9, 0x0144, 0x0000, 0x0000, 0xFFF9, 0x012F,
    0x0000, 0x0000, 0xFFF9, 0x011C, 0x0000, 0x0000, 0xFFF9, 0x010C,
    0x0000, 0x0000, 0xFFF9, 0x00FE, 0x0000, 0x0000, 0xFFF9, 0x00F1,
    0x0000, 0x0000, 0xFFF9, 0x00E5, 0x0000, 0x0000, 0xFFF9, 0x00DA,
    0x0000, 0x0000, 0xFFF9, 0x00D1, 0x0000, 0x0000, 0xFFF9, 0x00C8,
    0x0000, 0x0000, 0xFFF9, 0x00BF, 0x0000, 0x0000, 0xFFF9, 0x00B8,
    0x0000, 0x0000, 0xFFF9, 0x00B1, 0x0000, 0x0000, 0xFFF9, 0x00AB,
    0x0000, 0x0000, 0xFFF9, 0x00A5, 0x0000, 0x0000, 0xFFF9, 0x009F,
    0x0000, 0x0000, 0xFFF9, 0x009A, 0x0000, 0x0000, 0xFFF9, 0x0095,
    0x0000, 0x0000, 0xFFF9, 0x0090, 0x0000, 0x0000, 0xFFF9, 0x008C,
    0x0000, 0x0000, 0xFFF9, 0x0088, 0x0000, 0x0000, 0xFFF9, 0x0084,
    0x0000, 0x0000, 0xFFF9, 0x0080, 0x0000, 0x0000, 0xFFF9, 0x007D,
    0x0000, 0x0000, 0xFFF9, 0x007A, 0x0000, 0x0000, 0xFFF9, 0x0077,
    0x0000, 0x0000, 0xFFF9, 0x0074, 0x0000, 0x0000, 0xFFF9, 0x0071,
    0x0000, 0x0000, 0xFFF9, 0x006E, 0x0000, 0x0000, 0xFFF9, 0x006C,
    0x0000, 0x0000, 0xFFF9, 0x0069, 0x0000, 0x0000, 0xFFF9, 0x0067,
    0x0000, 0x0000, 0xFFF9, 0x0065, 0x0000, 0x0000, 0xFFF9, 0x0063,
    0x0000, 0x0000, 0xFFF9, 0x0061, 0x0000, 0x0000, 0xFFF9, 0x005F,
    0x0000, 0x0000, 0xFFF9, 0x005D, 0x0000, 0x0000, 0xFFF9, 0x005B,
    0x0000, 0x0000, 0xFFF9, 0x0059, 0x0000, 0x0000, 0xFFF9, 0x0058,
    0x0000, 0x0000, 0xFFF9, 0x0056, 0x0000, 0x0000, 0xFFF9, 0x0054,
    0x0000, 0x0000, 0xFFF9, 0x0053, 0x0000, 0x0000, 0xFFF9, 0x0051,
    0x0000, 0x0000, 0xFFF9, 0x0050, 0x0000, 0x0000, 0xFFF9, 0x004F,
    0x0000, 0x0000, 0xFFF9, 0x004D, 0x0000, 0x0000, 0xFFF9, 0x004C,
    0x0000, 0x0000, 0xFFF9, 0x004B, 0x0000, 0x0000, 0xFFF9, 0x004A,
    0x0000, 0x0000, 0xFFF9, 0x0049, 0x0000, 0x0000, 0xFFF9, 0x0047,
    0x0000, 0x0000, 0xFFF9, 0x0046, 0x0000, 0x0000, 0xFFF9, 0x0045,
    0x0000, 0x0000, 0xFFF9, 0x0044, 0x0000, 0x0000, 0xFFF9, 0x0043,
    0x0000, 0x0000, 0xFFF9, 0x0042, 0x0000, 0x0000, 0xFFF9, 0x0041,
    0x0000, 0x0000, 0xFFF9, 0x0040, 0x0000, 0x0000, 0xFFF9, 0x0040,
    0x0000, 0x0000, 0xFFF9, 0x003F, 0x0000, 0x0000, 0xFFF9, 0x003E,
    0x0000, 0x0000, 0xFFF9, 0x003D, 0x0000, 0x0000, 0xFFF9, 0x003C,
    0x0000, 0x0000, 0xFFF9, 0x003C, 0x0000, 0x0000, 0xFFF9, 0x003B,
    0x0000, 0x0000, 0xFFF9, 0x003A, 0x0000, 0x0000, 0xFFF9, 0x0039,
    0x0000, 0x0000, 0xFFF9, 0x0039, 0x0000, 0x0000, 0xFFF9, 0x0038,
    0x0000, 0x0000, 0xFFF9, 0x0037, 0x0000, 0x0000, 0xFFF9, 0x0037,
    0x0000, 0x0000, 0xFFF9, 0x0036, 0x0000, 0x0000, 0xFFF9, 0x0035,
    0x0000, 0x0000, 0xFFF9, 0x0035, 0x0000, 0x0000, 0xFFF9, 0x0034,
    0x0000, 0x0000, 0xFFF9, 0x0034, 0x0000, 0x0000, 0xFFF9, 0x0033,
    0x0000, 0x0000, 0xFFF9, 0x0032, 0x0000, 0x0000, 0xFFF9, 0x0032,
    0x0000, 0x0000, 0xFFF9, 0x0031, 0x0000, 0x0000, 0xFFF9, 0x0031,
    0x0000, 0x0000, 0xFFF9, 0x0030, 0x0000, 0x0000, 0xFFF9, 0x0030,
    0x0000, 0x0000, 0xFFF9, 0x002F, 0x0000, 0x0000, 0xFFF9, 0x002F,
    0x0000, 0x0000, 0xFFF9, 0x002E, 0x0000, 0x0000, 0xFFF9, 0x002E,
    0x0000, 0x0000, 0xFFF9, 0x002D, 0x0000, 0x0000, 0xFFF9, 0x002D,
    0x0000, 0x0000, 0xFFF9, 0x002D, 0x0000, 0x0000, 0xFFF9, 0x002C,
    0x0000, 0x0000, 0xFFF9, 0x002C, 0x0000, 0x0000, 0xFFF9, 0x002B,
    0x0000, 0x0000, 0xFFF9, 0x002B, 0x0000, 0x0000, 0xFFF9, 0x002A,
    0x0000, 0x0000, 0xFFF9, 0x002A, 0x0000, 0x0000, 0xFFF9, 0x002A,
    0x0000, 0x0000, 0xFFF9, 0x0029, 0x0000, 0x0000, 0xFFF9, 0x0029,
    0x0000, 0x0000, 0xFFF9, 0x0029, 0x0000, 0x0000, 0xFFF9, 0x0028,
    0x0000, 0x0000, 0xFFF9, 0x0028, 0x0000, 0x0000, 0xFFF9, 0x0028,
    0x0000, 0x0000, 0xFFF9, 0x0027, 0x0000, 0x0000, 0xFFF9, 0x0027,
    0x0000, 0x0000, 0xFFF9, 0x0027, 0x0000, 0x0000, 0xFFF9, 0x0026,
    0x0000, 0x0000, 0xFFF9, 0x0026, 0x0000, 0x0000, 0xFFF9, 0x0026,
    0x0000, 0x0000, 0xFFF9, 0x0025, 0x0000, 0x0000, 0xFFF9, 0x0025,
    0x0000, 0x0000, 0xFFF9, 0x0025, 0x0000, 0x0000, 0xFFF9, 0x0024,
    0x0000, 0x0000, 0xFFF9, 0x0024, 0x0000, 0x0000, 0xFFF9, 0x0024,
    0x0000, 0x0000, 0xFFF9, 0x0023, 0x0000, 0x0000, 0xFFF9, 0x0023,
    0x0000, 0x0000, 0xFFF9, 0x0023, 0x0000, 0x0000, 0xFFF9, 0x0023,
    0x0000, 0x0000, 0xFFF9, 0x0022, 0x0000, 0x0000, 0xFFF9, 0x0022,
    0x0000, 0x0000, 0xFFF9, 0x0022, 0x0000, 0x0000, 0xFFF9, 0x0022,
    0x0000, 0x0000, 0xFFF9, 0x0021, 0x0000, 0x0000, 0xFFF9, 0x0021,
    0x0000, 0x0000, 0xFFF9, 0x0021, 0x0000, 0x0000, 0xFFF9, 0x0021,
    0x0000, 0x0000, 0xFFF9, 0x0020, 0x0000, 0x0000, 0xFFF9, 0x0020,
    0x0000, 0x0000, 0xFFF9, 0x0020, 0x0000, 0x0000, 0xFFF9, 0x0020,
    0x0000, 0x0000, 0xFFF9, 0x001F, 0x0000, 0x0000, 0xFFF9, 0x001F,
    0x0000, 0x0000, 0xFFF9, 0x001F, 0x0000, 0x0000, 0xFFF9, 0x001F,
    0x0000, 0x0000, 0xFFF9, 0x001F, 0x0000, 0x0000, 0xFFF9, 0x001E,
    0x0000, 0x0000, 0xFFF9, 0x001E, 0x0000, 0x0000, 0xFFF9, 0x001E,
    0x0000, 0x0000, 0xFFF9, 0x001E, 0x0000, 0x0000, 0xFFF9, 0x001E,
    0x0000, 0x0000, 0xFFF9, 0x001D, 0x0000, 0x0000, 0xFFF9, 0x001D,
    0x0000, 0x0000, 0xFFF9, 0x001D, 0x0000, 0x0000, 0xFFF9, 0x001D,
    0x0000, 0x0000, 0xFFF9, 0x001D, 0x0000, 0x0000, 0xFFF9, 0x001C,
    0x0000, 0x0000, 0xFFF9, 0x001C, 0x0000, 0x0000, 0xFFF9, 0x001C,
    0x0000, 0x0000, 0xFFF9, 0x001C, 0x0000, 0x0000, 0xFFF9, 0x001C,
    0x0000, 0x0000, 0xFFF9, 0x001C, 0x0000, 0x0000, 0xFFF9, 0x001B,
    0x0000, 0x0000, 0xFFF9, 0x001B, 0x0000, 0x0000, 0xFFF9, 0x001B,
    0x0000, 0x0000, 0xFFF9, 0x001B, 0x0000, 0x0000, 0xFFF9, 0x001B,
    0x0000, 0x0000, 0xFFF9, 0x001B, 0x0000, 0x0000, 0xFFF9, 0x001A,
    0x0000, 0x0000, 0xFFF9, 0x001A, 0x0000, 0x0000, 0xFFF9, 0x001A,
    0x0000, 0x0000, 0xFFF9, 0x001A, 0x0000, 0x0000, 0xFFF9, 0x001A,
    0x0000, 0x0000, 0xFFF9, 0x001A, 0x0000, 0x0000, 0xFFF9, 0x0019,
    0x0000, 0x0000, 0xFFF9, 0x0019, 0x0000, 0x0000, 0xFFF9, 0x0019,
    0x0000, 0x0000, 0xFFF9, 0x0019, 0x0000, 0x0000, 0xFFF9, 0x0019,
    0x0000, 0x0000, 0xFFF9, 0x0019, 0x0000, 0x0000, 0xFFF9, 0x0019,
    0x0000, 0x0000, 0xFFF9, 0x0018, 0x0000, 0x0000, 0xFFF9, 0x0018,
    0x0000, 0x0000, 0xFFF9, 0x0018, 0x0000, 0x0000, 0xFFF9, 0x0018,
    0x0000, 0x0000, 0xFFF9, 0x0018, 0x0000, 0x0000, 0xFFF9, 0x0018,
    0x0000, 0x0000, 0xFFF9, 0x0018, 0x0000, 0x0000, 0xFFF9, 0x0018,
    0x0000, 0x0000, 0xFFF9, 0x0017, 0x0000, 0x0000, 0xFFF9, 0x0017,
    0x0000, 0x0000, 0xFFF9, 0x0017, 0x0000, 0x0000, 0xFFF9, 0x0017,
    0x0000, 0x0000, 0xFFF9, 0x0017, 0x0000, 0x0000, 0xFFF9, 0x0017,
    0x0000, 0x0000, 0xFFF9, 0x0017, 0x0000, 0x0000, 0xFFF9, 0x0017,
    0x0000, 0x0000, 0xFFF9, 0x0016, 0x0000, 0x0000, 0xFFF9, 0x0016,
    0x0000, 0x0000, 0xFFF9, 0x0016, 0x0000, 0x0000, 0xFFF9, 0x0016,
    0x0000, 0x0000, 0xFFF9, 0x0016, 0x0000, 0x0000, 0xFFF9, 0x0016,
    0x0000, 0x0000, 0xFFF9, 0x0016, 0x0000, 0x0000, 0xFFF9, 0x0016,
    0x0000, 0x0000, 0xFFF9, 0x0016, 0x0000, 0x0000, 0xFFF9, 0x0015,
    0x0000, 0x0000, 0xFFF9, 0x0015, 0x0000, 0x0000, 0xFFF9, 0x0015,
    0x0000, 0x0000, 0xFFF9, 0x0015, 0x0000, 0x0000, 0xFFF9, 0x0015,
    0x0000, 0x0000, 0xFFF9, 0x0015, 0x0000, 0x0000, 0xFFF9, 0x0015,
    0x0000, 0x0000, 0xFFF9, 0x0015, 0x0000, 0x0000, 0xFFF9, 0x0015,
    0x0000, 0x0000, 0xFFF9, 0x0014, 0x0000, 0x0000, 0xFFF9, 0x0014,
    0x0000, 0x0000, 0xFFF9, 0x0014, 0x0000, 0x0000, 0xFFF9, 0x0014,
    0x0000, 0x0000, 0xFFF9, 0x0014, 0x0000, 0x0000, 0xFFF9, 0x0014,
    0x0000, 0x0000, 0xFFF9, 0x0014, 0x0000, 0x0000, 0xFFF9, 0x0014,
    0x0000, 0x0000, 0xFFF9, 0x0014, 0x0000, 0x0000, 0xFFF9, 0x0014,
    0x0000, 0x0000, 0xFFF9, 0x0014, 0x0000, 0x0000, 0xFFF9, 0x0013,
    0x0000, 0x0000, 0xFFF9, 0x0013, 0x0000, 0x0000, 0xFFF9, 0x0013,
    0x0000, 0x0000, 0xFFF9, 0x0013, 0x0000, 0x0000, 0xFFF9, 0x0013,
    0x0000, 0x0000, 0xFFF9, 0x0013, 0x0000, 0x0000, 0xFFF9, 0x0013,
    0x0000, 0x0000, 0xFFF9, 0x0013, 0x0000, 0x0000, 0xFFF9, 0x0013,
    0x0000, 0x0000, 0xFFF9, 0x0013, 0x0000, 0x0000, 0xFFF9, 0x0013,
    0x0000, 0x0000, 0xFFF9, 0x0012, 0x0000, 0x0000, 0xFFF9, 0x0012,
    0x0000, 0x0000, 0xFFF9, 0x0012, 0x0000, 0x0000, 0xFFF9, 0x0012,
    0x0000, 0x0000, 0xFFF9, 0x0012, 0x0000, 0x0000, 0xFFF9, 0x0012,
    0x0000, 0x0000, 0xFFF9, 0x0012, 0x0000, 0x0000, 0xFFF9, 0x0012,
    0x0000, 0x0000, 0xFFF9, 0x0012, 0x0000, 0x0000, 0xFFF9, 0x0012,
    0x0000, 0x0000, 0xFFF9, 0x0012, 0x0000, 0x0000, 0xFFF9, 0x0012,
    0x0000, 0x0000, 0xFFF9, 0x0011, 0x0000, 0x0000, 0xFFF9, 0x0011,
    0x0000, 0x0000, 0xFFF9, 0x0011, 0x0000, 0x0000, 0xFFF9, 0x0011,
    0x0000, 0x0000, 0xFFF9, 0x0011, 0x0000, 0x0000, 0xFFF9, 0x0011,
    0x0000, 0x0000, 0xFFF9, 0x0011, 0x0000, 0x0000, 0xFFF9, 0x0011,
    0x0000, 0x0000, 0xFFF9, 0x0011, 0x0000, 0x0000, 0xFFF9, 0x0011,
    0x0000, 0x0000, 0xFFF9, 0x0011, 0x0000, 0x0000, 0xFFF9, 0x0011,
    0x0000, 0x0000, 0xFFF9, 0x0011, 0x0000, 0x0000, 0xFFF9, 0x0011,
    0x0000, 0x0000, 0xFFF9, 0x0010, 0x0000, 0x0000, 0xFFF9, 0x0010,
    0x0000, 0x0000, 0xFFF9, 0x0010, 0x0000, 0x0000, 0xFFF9, 0x0010,
    0x0000, 0x0000, 0xFFF9, 0x0010, 0x0000, 0x0000, 0xFFF9, 0x0010,
    0x0000, 0x0000, 0xFFF9, 0x0010, 0x0000, 0x0000, 0xFFF9, 0x0010,
    0x0000, 0x0000, 0xFFF9, 0x0010, 0x0000, 0x0000, 0xFFF9, 0x0010,
    0x0000, 0x0000, 0xFFF9, 0x0010, 0x0000, 0x0000, 0xFFF9, 0x0010,
    0x0000, 0x0000, 0xFFF9, 0x0010, 0x0000, 0x0000, 0xFFF9, 0x0010,
    0x0000, 0x0000, 0xFFF9, 0x0010, 0x0000, 0x0000, 0xFFF9, 0x000F,
    0x0000, 0x0000, 0xFFF9, 0x000F, 0x0000, 0x0000, 0xFFF9, 0x000F,
    0x0000, 0x0000, 0xFFF9, 0x000F, 0x0000, 0x0000, 0xFFF9, 0x000F,
    0x0000, 0x0000, 0xFFF9, 0x000F, 0x0000, 0x0000, 0xFFF9, 0x000F,
    0x0000, 0x0000, 0xFFF9, 0x000F, 0x0000, 0x0000, 0xFFF9, 0x000F,
    0x0000, 0x0000, 0xFFF9, 0x000F, 0x0000, 0x0000, 0xFFF9, 0x000F,
    0x0000, 0x0000, 0xFFF9, 0x000F, 0x0000, 0x0000, 0xFFF9, 0x000F,
    0x0000, 0x0000, 0xFFF9, 0x000F, 0x0000, 0x0000, 0xFFF9, 0x000F,
    0x0000, 0x0000, 0xFFF9, 0x000F, 0x0000, 0x0000, 0xFFF9, 0x000F,
    0x0000, 0x0000, 0xFFF9, 0x000E, 0x0000, 0x0000, 0xFFF9, 0x000E,
    0x0000, 0x0000, 0xFFF9, 0x000E, 0x0000, 0x0000, 0xFFF9, 0x000E,
    0x0000, 0x0000, 0xFFF9, 0x000E, 0x0000, 0x0000, 0xFFF9, 0x000E,
    0x0000, 0x0000, 0xFFF9, 0x000E, 0x0000, 0x0000, 0xFFF9, 0x000E,
    0x0000, 0x0000, 0xFFF9, 0x000E, 0x0000, 0x0000, 0xFFF9, 0x000E,
    0x0000, 0x0000, 0xFFF9, 0x000E, 0x0000, 0x0000, 0xFFF9, 0x000E,
    0x0000, 0x0000, 0xFFF9, 0x000E, 0x0000, 0x0000, 0xFFF9, 0x000E,
    0x0000, 0x0000, 0xFFF9, 0x000E, 0x0000, 0x0000, 0xFFF9, 0x000E,
    0x0000, 0x0000, 0xFFF9, 0x000E, 0x0000, 0x0000, 0xFFF9, 0x000E,
    0x0000, 0x0000, 0xFFF9, 0x000E, 0x0000, 0x0000, 0xFFF9, 0x000D,
    0x0000, 0x0000, 0xFFF9, 0x000D, 0x0000, 0x0000, 0xFFF9, 0x000D,
    0x0000, 0x0000, 0xFFF9, 0x000D, 0x0000, 0x0000, 0xFFF9, 0x000D,
    0x0000, 0x0000, 0xFFF9, 0x000D, 0x0000, 0x0000, 0xFFF9, 0x000D,
    0x0000, 0x0000, 0xFFF9, 0x000D, 0x0000, 0x0000, 0xFFF9, 0x000D,
    0x0000, 0x0000, 0xFFF9, 0x000D, 0x0000, 0x0000, 0xFFF9, 0x000D,
    0x0000, 0x0000, 0xFFF9, 0x000D, 0x0000, 0x0000, 0xFFF9, 0x000D,
    0x0000, 0x0000, 0xFFF9, 0x000D, 0x0000, 0x0000, 0xFFF9, 0x000D,
    0x0000, 0x0000, 0xFFF9, 0x000D, 0x0000, 0x0000, 0xFFF9, 0x000D,
    0x0000, 0x0000, 0xFFF9, 0x000D, 0x0000, 0x0000, 0xFFF9, 0x000D,
    0x0000, 0x0000, 0xFFF9, 0x000D, 0x0000, 0x0000, 0xFFF9, 0x000D,
    0x0000, 0x0000, 0xFFF9, 0x000D, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF5, 0x0000, 0x0000, 0xFFF9, 0xFFF5,
    0x0000, 0x0000, 0xFFF9, 0xFFF5, 0x0000, 0x0000, 0xFFF9, 0xFFF5,
    0x0000, 0x0000, 0xFFF9, 0xFFF5, 0x0000, 0x0000, 0xFFF9, 0xFFF5,
    0x0000, 0x0000, 0xFFF9, 0xFFF5, 0x0000, 0x0000, 0xFFF9, 0xFFF5,
    0x0000, 0x0000, 0xFFF9, 0xFFF5, 0x0000, 0x0000, 0xFFF9, 0xFFF5,
    0x0000, 0x0000, 0xFFF9, 0xFFF5, 0x0000, 0x0000, 0xFFF9, 0xFFF5,
    0x0000, 0x0000, 0xFFF9, 0xFFF5, 0x0000, 0x0000, 0xFFF9, 0xFFF5,
    0x0000, 0x0000, 0xFFF9, 0xFFF5, 0x0000, 0x0000, 0xFFF9, 0xFFF5,
    0x0000, 0x0000, 0xFFF9, 0xFFF5, 0x0000, 0x0000, 0xFFF9, 0xFFF5,
    0x0000, 0x0000, 0xFFF9, 0xFFF5, 0x0000, 0x0000, 0xFFF9, 0xFFF5,
    0x0000, 0x0000, 0xFFF9, 0xFFF5, 0x0000, 0x0000, 0xFFF9, 0xFFF5,
    0x0000, 0x0000, 0xFFF9, 0xFFF5, 0x0000, 0x0000, 0xFFF9, 0xFFF5,
    0x0000, 0x0000, 0xFFF9, 0xFFF5, 0x0000, 0x0000, 0xFFF9, 0xFFF5,
    0x0000, 0x0000, 0xFFF9, 0xFFF5, 0x0000, 0x0000, 0xFFF9, 0xFFF4,
    0x0000, 0x0000, 0xFFF9, 0xFFF4, 0x0000, 0x0000, 0xFFF9, 0xFFF4,
    0x0000, 0x0000, 0xFFF9, 0xFFF4, 0x0000, 0x0000, 0xFFF9, 0xFFF4,
    0x0000, 0x0000, 0xFFF9, 0xFFF4, 0x0000, 0x0000, 0xFFF9, 0xFFF4,
    0x0000, 0x0000, 0xFFF9, 0xFFF4, 0x0000, 0x0000, 0xFFF9, 0xFFF4,
    0x0000, 0x0000, 0xFFF9, 0xFFF4, 0x0000, 0x0000, 0xFFF9, 0xFFF4,
    0x0000, 0x0000, 0xFFF9, 0xFFF4, 0x0000, 0x0000, 0xFFF9, 0xFFF4,
    0x0000, 0x0000, 0xFFF9, 0xFFF4, 0x0000, 0x0000, 0xFFF9, 0xFFF4,
    0x0000, 0x0000, 0xFFF9, 0xFFF4, 0x0000, 0x0000, 0xFFF9, 0xFFF4,
    0x0000, 0x0000, 0xFFF9, 0xFFF4, 0x0000, 0x0000, 0xFFF9, 0xFFF4,
    0x0000, 0x0000, 0xFFF9, 0xFFF4, 0x0000, 0x0000, 0xFFF9, 0xFFF4,
    0x0000, 0x0000, 0xFFF9, 0xFFF4, 0x0000, 0x0000, 0xFFF9, 0xFFF4,
    0x0000, 0x0000, 0xFFF9, 0xFFF4, 0x0000, 0x0000, 0xFFF9, 0xFFF3,
    0x0000, 0x0000, 0xFFF9, 0xFFF3, 0x0000, 0x0000, 0xFFF9, 0xFFF3,
    0x0000, 0x0000, 0xFFF9, 0xFFF3, 0x0000, 0x0000, 0xFFF9, 0xFFF3,
    0x0000, 0x0000, 0xFFF9, 0xFFF3, 0x0000, 0x0000, 0xFFF9, 0xFFF3,
    0x0000, 0x0000, 0xFFF9, 0xFFF3, 0x0000, 0x0000, 0xFFF9, 0xFFF3,
    0x0000, 0x0000, 0xFFF9, 0xFFF3, 0x0000, 0x0000, 0xFFF9, 0xFFF3,
    0x0000, 0x0000, 0xFFF9, 0xFFF3, 0x0000, 0x0000, 0xFFF9, 0xFFF3,
    0x0000, 0x0000, 0xFFF9, 0xFFF3, 0x0000, 0x0000, 0xFFF9, 0xFFF3,
    0x0000, 0x0000, 0xFFF9, 0xFFF3, 0x0000, 0x0000, 0xFFF9, 0xFFF3,
    0x0000, 0x0000, 0xFFF9, 0xFFF3, 0x0000, 0x0000, 0xFFF9, 0xFFF3,
    0x0000, 0x0000, 0xFFF9, 0xFFF3, 0x0000, 0x0000, 0xFFF9, 0xFFF3,
    0x0000, 0x0000, 0xFFF9, 0xFFF3, 0x0000, 0x0000, 0xFFF9, 0xFFF2,
    0x0000, 0x0000, 0xFFF9, 0xFFF2, 0x0000, 0x0000, 0xFFF9, 0xFFF2,
    0x0000, 0x0000, 0xFFF9, 0xFFF2, 0x0000, 0x0000, 0xFFF9, 0xFFF2,
    0x0000, 0x0000, 0xFFF9, 0xFFF2, 0x0000, 0x0000, 0xFFF9, 0xFFF2,
    0x0000, 0x0000, 0xFFF9, 0xFFF2, 0x0000, 0x0000, 0xFFF9, 0xFFF2,
    0x0000, 0x0000, 0xFFF9, 0xFFF2, 0x0000, 0x0000, 0xFFF9, 0xFFF2,
    0x0000, 0x0000, 0xFFF9, 0xFFF2, 0x0000, 0x0000, 0xFFF9, 0xFFF2,
    0x0000, 0x0000, 0xFFF9, 0xFFF2, 0x0000, 0x0000, 0xFFF9, 0xFFF2,
    0x0000, 0x0000, 0xFFF9, 0xFFF2, 0x0000, 0x0000, 0xFFF9, 0xFFF2,
    0x0000, 0x0000, 0xFFF9, 0xFFF2, 0x0000, 0x0000, 0xFFF9, 0xFFF2,
    0x0000, 0x0000, 0xFFF9, 0xFFF1, 0x0000, 0x0000, 0xFFF9, 0xFFF1,
    0x0000, 0x0000, 0xFFF9, 0xFFF1, 0x0000, 0x0000, 0xFFF9, 0xFFF1,
    0x0000, 0x0000, 0xFFF9, 0xFFF1, 0x0000, 0x0000, 0xFFF9, 0xFFF1,
    0x0000, 0x0000, 0xFFF9, 0xFFF1, 0x0000, 0x0000, 0xFFF9, 0xFFF1,
    0x0000, 0x0000, 0xFFF9, 0xFFF1, 0x0000, 0x0000, 0xFFF9, 0xFFF1,
    0x0000, 0x0000, 0xFFF9, 0xFFF1, 0x0000, 0x0000, 0xFFF9, 0xFFF1,
    0x0000, 0x0000, 0xFFF9, 0xFFF1, 0x0000, 0x0000, 0xFFF9, 0xFFF1,
    0x0000, 0x0000, 0xFFF9, 0xFFF1, 0x0000, 0x0000, 0xFFF9, 0xFFF1,
    0x0000, 0x0000, 0xFFF9, 0xFFF1, 0x0000, 0x0000, 0xFFF9, 0xFFF0,
    0x0000, 0x0000, 0xFFF9, 0xFFF0, 0x0000, 0x0000, 0xFFF9, 0xFFF0,
    0x0000, 0x0000, 0xFFF9, 0xFFF0, 0x0000, 0x0000, 0xFFF9, 0xFFF0,
    0x0000, 0x0000, 0xFFF9, 0xFFF0, 0x0000, 0x0000, 0xFFF9, 0xFFF0,
    0x0000, 0x0000, 0xFFF9, 0xFFF0, 0x0000, 0x0000, 0xFFF9, 0xFFF0,
    0x0000, 0x0000, 0xFFF9, 0xFFF0, 0x0000, 0x0000, 0xFFF9, 0xFFF0,
    0x0000, 0x0000, 0xFFF9, 0xFFF0, 0x0000, 0x0000, 0xFFF9, 0xFFF0,
    0x0000, 0x0000, 0xFFF9, 0xFFF0, 0x0000, 0x0000, 0xFFF9, 0xFFF0,
    0x0000, 0x0000, 0xFFF9, 0xFFEF, 0x0000, 0x0000, 0xFFF9, 0xFFEF,
    0x0000, 0x0000, 0xFFF9, 0xFFEF, 0x0000, 0x0000, 0xFFF9, 0xFFEF,
    0x0000, 0x0000, 0xFFF9, 0xFFEF, 0x0000, 0x0000, 0xFFF9, 0xFFEF,
    0x0000, 0x0000, 0xFFF9, 0xFFEF, 0x0000, 0x0000, 0xFFF9, 0xFFEF,
    0x0000, 0x0000, 0xFFF9, 0xFFEF, 0x0000, 0x0000, 0xFFF9, 0xFFEF,
    0x0000, 0x0000, 0xFFF9, 0xFFEF, 0x0000, 0x0000, 0xFFF9, 0xFFEF,
    0x0000, 0x0000, 0xFFF9, 0xFFEF, 0x0000, 0x0000, 0xFFF9, 0xFFEF,
    0x0000, 0x0000, 0xFFF9, 0xFFEE, 0x0000, 0x0000, 0xFFF9, 0xFFEE,
    0x0000, 0x0000, 0xFFF9, 0xFFEE, 0x0000, 0x0000, 0xFFF9, 0xFFEE,
    0x0000, 0x0000, 0xFFF9, 0xFFEE, 0x0000, 0x0000, 0xFFF9, 0xFFEE,
    0x0000, 0x0000, 0xFFF9, 0xFFEE, 0x0000, 0x0000, 0xFFF9, 0xFFEE,
    0x0000, 0x0000, 0xFFF9, 0xFFEE, 0x0000, 0x0000, 0xFFF9, 0xFFEE,
    0x0000, 0x0000, 0xFFF9, 0xFFEE, 0x0000, 0x0000, 0xFFF9, 0xFFEE,
    0x0000, 0x0000, 0xFFF9, 0xFFED, 0x0000, 0x0000, 0xFFF9, 0xFFED,
    0x0000, 0x0000, 0xFFF9, 0xFFED, 0x0000, 0x0000, 0xFFF9, 0xFFED,
    0x0000, 0x0000, 0xFFF9, 0xFFED, 0x0000, 0x0000, 0xFFF9, 0xFFED,
    0x0000, 0x0000, 0xFFF9, 0xFFED, 0x0000, 0x0000, 0xFFF9, 0xFFED,
    0x0000, 0x0000, 0xFFF9, 0xFFED, 0x0000, 0x0000, 0xFFF9, 0xFFED,
    0x0000, 0x0000, 0xFFF9, 0xFFED, 0x0000, 0x0000, 0xFFF9, 0xFFEC,
    0x0000, 0x0000, 0xFFF9, 0xFFEC, 0x0000, 0x0000, 0xFFF9, 0xFFEC,
    0x0000, 0x0000, 0xFFF9, 0xFFEC, 0x0000, 0x0000, 0xFFF9, 0xFFEC,
    0x0000, 0x0000, 0xFFF9, 0xFFEC, 0x0000, 0x0000, 0xFFF9, 0xFFEC,
    0x0000, 0x0000, 0xFFF9, 0xFFEC, 0x0000, 0x0000, 0xFFF9, 0xFFEC,
    0x0000, 0x0000, 0xFFF9, 0xFFEC, 0x0000, 0x0000, 0xFFF9, 0xFFEC,
    0x0000, 0x0000, 0xFFF9, 0xFFEB, 0x0000, 0x0000, 0xFFF9, 0xFFEB,
    0x0000, 0x0000, 0xFFF9, 0xFFEB, 0x0000, 0x0000, 0xFFF9, 0xFFEB,
    0x0000, 0x0000, 0xFFF9, 0xFFEB, 0x0000, 0x0000, 0xFFF9, 0xFFEB,
    0x0000, 0x0000, 0xFFF9, 0xFFEB, 0x0000, 0x0000, 0xFFF9, 0xFFEB,
    0x0000, 0x0000, 0xFFF9, 0xFFEB, 0x0000, 0x0000, 0xFFF9, 0xFFEA,
    0x0000, 0x0000, 0xFFF9, 0xFFEA, 0x0000, 0x0000, 0xFFF9, 0xFFEA,
    0x0000, 0x0000, 0xFFF9, 0xFFEA, 0x0000, 0x0000, 0xFFF9, 0xFFEA,
    0x0000, 0x0000, 0xFFF9, 0xFFEA, 0x0000, 0x0000, 0xFFF9, 0xFFEA,
    0x0000, 0x0000, 0xFFF9, 0xFFEA, 0x0000, 0x0000, 0xFFF9, 0xFFEA,
    0x0000, 0x0000, 0xFFF9, 0xFFE9, 0x0000, 0x0000, 0xFFF9, 0xFFE9,
    0x0000, 0x0000, 0xFFF9, 0xFFE9, 0x0000, 0x0000, 0xFFF9, 0xFFE9,
    0x0000, 0x0000, 0xFFF9, 0xFFE9, 0x0000, 0x0000, 0xFFF9, 0xFFE9,
    0x0000, 0x0000, 0xFFF9, 0xFFE9, 0x0000, 0x0000, 0xFFF9, 0xFFE9,
    0x0000, 0x0000, 0xFFF9, 0xFFE8, 0x0000, 0x0000, 0xFFF9, 0xFFE8,
    0x0000, 0x0000, 0xFFF9, 0xFFE8, 0x0000, 0x0000, 0xFFF9, 0xFFE8,
    0x0000, 0x0000, 0xFFF9, 0xFFE8, 0x0000, 0x0000, 0xFFF9, 0xFFE8,
    0x0000, 0x0000, 0xFFF9, 0xFFE8, 0x0000, 0x0000, 0xFFF9, 0xFFE8,
    0x0000, 0x0000, 0xFFF9, 0xFFE7, 0x0000, 0x0000, 0xFFF9, 0xFFE7,
    0x0000, 0x0000, 0xFFF9, 0xFFE7, 0x0000, 0x0000, 0xFFF9, 0xFFE7,
    0x0000, 0x0000, 0xFFF9, 0xFFE7, 0x0000, 0x0000, 0xFFF9, 0xFFE7,
    0x0000, 0x0000, 0xFFF9, 0xFFE7, 0x0000, 0x0000, 0xFFF9, 0xFFE6,
    0x0000, 0x0000, 0xFFF9, 0xFFE6, 0x0000, 0x0000, 0xFFF9, 0xFFE6,
    0x0000, 0x0000, 0xFFF9, 0xFFE6, 0x0000, 0x0000, 0xFFF9, 0xFFE6,
    0x0000, 0x0000, 0xFFF9, 0xFFE6, 0x0000, 0x0000, 0xFFF9, 0xFFE5,
    0x0000, 0x0000, 0xFFF9, 0xFFE5, 0x0000, 0x0000, 0xFFF9, 0xFFE5,
    0x0000, 0x0000, 0xFFF9, 0xFFE5, 0x0000, 0x0000, 0xFFF9, 0xFFE5,
    0x0000, 0x0000, 0xFFF9, 0xFFE5, 0x0000, 0x0000, 0xFFF9, 0xFFE4,
    0x0000, 0x0000, 0xFFF9, 0xFFE4, 0x0000, 0x0000, 0xFFF9, 0xFFE4,
    0x0000, 0x0000, 0xFFF9, 0xFFE4, 0x0000, 0x0000, 0xFFF9, 0xFFE4,
    0x0000, 0x0000, 0xFFF9, 0xFFE4, 0x0000, 0x0000, 0xFFF9, 0xFFE3,
    0x0000, 0x0000, 0xFFF9, 0xFFE3, 0x0000, 0x0000, 0xFFF9, 0xFFE3,
    0x0000, 0x0000, 0xFFF9, 0xFFE3, 0x0000, 0x0000, 0xFFF9, 0xFFE3,
    0x0000, 0x0000, 0xFFF9, 0xFFE2, 0x0000, 0x0000, 0xFFF9, 0xFFE2,
    0x0000, 0x0000, 0xFFF9, 0xFFE2, 0x0000, 0x0000, 0xFFF9, 0xFFE2,
    0x0000, 0x0000, 0xFFF9, 0xFFE2, 0x0000, 0x0000, 0xFFF9, 0xFFE1,
    0x0000, 0x0000, 0xFFF9, 0xFFE1, 0x0000, 0x0000, 0xFFF9, 0xFFE1,
    0x0000, 0x0000, 0xFFF9, 0xFFE1, 0x0000, 0x0000, 0xFFF9, 0xFFE1,
    0x0000, 0x0000, 0xFFF9, 0xFFE0, 0x0000, 0x0000, 0xFFF9, 0xFFE0,
    0x0000, 0x0000, 0xFFF9, 0xFFE0, 0x0000, 0x0000, 0xFFF9, 0xFFE0,
    0x0000, 0x0000, 0xFFF9, 0xFFDF, 0x0000, 0x0000, 0xFFF9, 0xFFDF,
    0x0000, 0x0000, 0xFFF9, 0xFFDF, 0x0000, 0x0000, 0xFFF9, 0xFFDF,
    0x0000, 0x0000, 0xFFF9, 0xFFDE, 0x0000, 0x0000, 0xFFF9, 0xFFDE,
    0x0000, 0x0000, 0xFFF9, 0xFFDE, 0x0000, 0x0000, 0xFFF9, 0xFFDE,
    0x0000, 0x0000, 0xFFF9, 0xFFDD, 0x0000, 0x0000, 0xFFF9, 0xFFDD,
    0x0000, 0x0000, 0xFFF9, 0xFFDD, 0x0000, 0x0000, 0xFFF9, 0xFFDD,
    0x0000, 0x0000, 0xFFF9, 0xFFDC, 0x0000, 0x0000, 0xFFF9, 0xFFDC,
    0x0000, 0x0000, 0xFFF9, 0xFFDC, 0x0000, 0x0000, 0xFFF9, 0xFFDB,
    0x0000, 0x0000, 0xFFF9, 0xFFDB, 0x0000, 0x0000, 0xFFF9, 0xFFDB,
    0x0000, 0x0000, 0xFFF9, 0xFFDA, 0x0000, 0x0000, 0xFFF9, 0xFFDA,
    0x0000, 0x0000, 0xFFF9, 0xFFDA, 0x0000, 0x0000, 0xFFF9, 0xFFD9,
    0x0000, 0x0000, 0xFFF9, 0xFFD9, 0x0000, 0x0000, 0xFFF9, 0xFFD9,
    0x0000, 0x0000, 0xFFF9, 0xFFD8, 0x0000, 0x0000, 0xFFF9, 0xFFD8,
    0x0000, 0x0000, 0xFFF9, 0xFFD8, 0x0000, 0x0000, 0xFFF9, 0xFFD7,
    0x0000, 0x0000, 0xFFF9, 0xFFD7, 0x0000, 0x0000, 0xFFF9, 0xFFD7,
    0x0000, 0x0000, 0xFFF9, 0xFFD6, 0x0000, 0x0000, 0xFFF9, 0xFFD6,
    0x0000, 0x0000, 0xFFF9, 0xFFD6, 0x0000, 0x0000, 0xFFF9, 0xFFD5,
    0x0000, 0x0000, 0xFFF9, 0xFFD5, 0x0000, 0x0000, 0xFFF9, 0xFFD4,
    0x0000, 0x0000, 0xFFF9, 0xFFD4, 0x0000, 0x0000, 0xFFF9, 0xFFD3,
    0x0000, 0x0000, 0xFFF9, 0xFFD3, 0x0000, 0x0000, 0xFFF9, 0xFFD3,
    0x0000, 0x0000, 0xFFF9, 0xFFD2, 0x0000, 0x0000, 0xFFF9, 0xFFD2,
    0x0000, 0x0000, 0xFFF9, 0xFFD1, 0x0000, 0x0000, 0xFFF9, 0xFFD1,
    0x0000, 0x0000, 0xFFF9, 0xFFD0, 0x0000, 0x0000, 0xFFF9, 0xFFD0,
    0x0000, 0x0000, 0xFFF9, 0xFFCF, 0x0000, 0x0000, 0xFFF9, 0xFFCF,
    0x0000, 0x0000, 0xFFF9, 0xFFCE, 0x0000, 0x0000, 0xFFF9, 0xFFCE,
    0x0000, 0x0000, 0xFFF9, 0xFFCD, 0x0000, 0x0000, 0xFFF9, 0xFFCC,
    0x0000, 0x0000, 0xFFF9, 0xFFCC, 0x0000, 0x0000, 0xFFF9, 0xFFCB,
    0x0000, 0x0000, 0xFFF9, 0xFFCB, 0x0000, 0x0000, 0xFFF9, 0xFFCA,
    0x0000, 0x0000, 0xFFF9, 0xFFC9, 0x0000, 0x0000, 0xFFF9, 0xFFC9,
    0x0000, 0x0000, 0xFFF9, 0xFFC8, 0x0000, 0x0000, 0xFFF9, 0xFFC7,
    0x0000, 0x0000, 0xFFF9, 0xFFC7, 0x0000, 0x0000, 0xFFF9, 0xFFC6,
    0x0000, 0x0000, 0xFFF9, 0xFFC5, 0x0000, 0x0000, 0xFFF9, 0xFFC4,
    0x0000, 0x0000, 0xFFF9, 0xFFC4, 0x0000, 0x0000, 0xFFF9, 0xFFC3,
    0x0000, 0x0000, 0xFFF9, 0xFFC2, 0x0000, 0x0000, 0xFFF9, 0xFFC1,
    0x0000, 0x0000, 0xFFF9, 0xFFC0, 0x0000, 0x0000, 0xFFF9, 0xFFC0,
    0x0000, 0x0000, 0xFFF9, 0xFFBF, 0x0000, 0x0000, 0xFFF9, 0xFFBE,
    0x0000, 0x0000, 0xFFF9, 0xFFBD, 0x0000, 0x0000, 0xFFF9, 0xFFBC,
    0x0000, 0x0000, 0xFFF9, 0xFFBB, 0x0000, 0x0000, 0xFFF9, 0xFFBA,
    0x0000, 0x0000, 0xFFF9, 0xFFB9, 0x0000, 0x0000, 0xFFF9, 0xFFB7,
    0x0000, 0x0000, 0xFFF9, 0xFFB6, 0x0000, 0x0000, 0xFFF9, 0xFFB5,
    0x0000, 0x0000, 0xFFF9, 0xFFB4, 0x0000, 0x0000, 0xFFF9, 0xFFB3,
    0x0000, 0x0000, 0xFFF9, 0xFFB1, 0x0000, 0x0000, 0xFFF9, 0xFFB0,
    0x0000, 0x0000, 0xFFF9, 0xFFAF, 0x0000, 0x0000, 0xFFF9, 0xFFAD,
    0x0000, 0x0000, 0xFFF9, 0xFFAC, 0x0000, 0x0000, 0xFFF9, 0xFFAA,
    0x0000, 0x0000, 0xFFF9, 0xFFA8, 0x0000, 0x0000, 0xFFF9, 0xFFA7,
    0x0000, 0x0000, 0xFFF9, 0xFFA5, 0x0000, 0x0000, 0xFFF9, 0xFFA3,
    0x0000, 0x0000, 0xFFF9, 0xFFA1, 0x0000, 0x0000, 0xFFF9, 0xFF9F,
    0x0000, 0x0000, 0xFFF9, 0xFF9D, 0x0000, 0x0000, 0xFFF9, 0xFF9B,
    0x0000, 0x0000, 0xFFF9, 0xFF99, 0x0000, 0x0000, 0xFFF9, 0xFF97,
    0x0000, 0x0000, 0xFFF9, 0xFF94, 0x0000, 0x0000, 0xFFF9, 0xFF92,
    0x0000, 0x0000, 0xFFF9, 0xFF8F, 0x0000, 0x0000, 0xFFF9, 0xFF8C,
    0x0000, 0x0000, 0xFFF9, 0xFF89, 0x0000, 0x0000, 0xFFF9, 0xFF86,
    0x0000, 0x0000, 0xFFF9, 0xFF83, 0x0000, 0x0000, 0xFFF9, 0xFF80,
    0x0000, 0x0000, 0xFFF9, 0xFF7C, 0x0000, 0x0000, 0xFFF9, 0xFF78,
    0x0000, 0x0000, 0xFFF9, 0xFF74, 0x0000, 0x0000, 0xFFF9, 0xFF70,
    0x0000, 0x0000, 0xFFF9, 0xFF6B, 0x0000, 0x0000, 0xFFF9, 0xFF66,
    0x0000, 0x0000, 0xFFF9, 0xFF61, 0x0000, 0x0000, 0xFFF9, 0xFF5B,
    0x0000, 0x0000, 0xFFF9, 0xFF55, 0x0000, 0x0000, 0xFFF9, 0xFF4F,
    0x0000, 0x0000, 0xFFF9, 0xFF48, 0x0000, 0x0000, 0xFFF9, 0xFF41,
    0x0000, 0x0000, 0xFFF9, 0xFF38, 0x0000, 0x0000, 0xFFF9, 0xFF2F,
    0x0000, 0x0000, 0xFFF9, 0xFF26, 0x0000, 0x0000, 0xFFF9, 0xFF1B,
    0x0000, 0x0000, 0xFFF9, 0xFF0F, 0x0000, 0x0000, 0xFFF9, 0xFF02,
    0x0000, 0x0000, 0xFFF9, 0xFEF4, 0x0000, 0x0000, 0xFFF9, 0xFEE4,
    0x0000, 0x0000, 0xFFF9, 0xFED1, 0x0000, 0x0000, 0xFFF9, 0xFEBC,
    0x0000, 0x0000, 0xFFF9, 0xFEA4, 0x0000, 0x0000, 0xFFF9, 0xFE89,
    0x0000, 0x0000, 0xFFF9, 0xFE68, 0x0000, 0x0000, 0xFFF9, 0xFE41,
    0x0000, 0x0000, 0xFFF9, 0xFE12, 0x0000, 0x0000, 0xFFF9, 0xFDD8,
    0x0000, 0x0000, 0xFFF9, 0xFD8E, 0x0000, 0x0000, 0xFFF9, 0xFD2E,
    0x0000, 0x0000, 0xFFF9, 0xFCAB, 0x0000, 0x0000, 0xFFF9, 0xFBED,
    0x0000, 0x0000, 0xFFF9, 0xFAC3, 0x0000, 0x0000, 0xFFF9, 0xF8AB,
    0x0000, 0x0000, 0xFFF9, 0xF3C7, 0x0000, 0x0000, 0xFFF9, 0xDB55
    };

static const q15_t ref_cfft_step_4096[8192] = {
    0x399A, 0x0000, 0xFFF9, 0x24AB, 0x0000, 0x0000, 0xFFF9, 0x0C39,
    0x0000, 0x0000, 0xFFF9, 0x0755, 0x0000, 0x0000, 0xFFF9, 0x053D,
    0x0000, 0x0000, 0xFFF9, 0x0413, 0x0000, 0x0000, 0xFFF9, 0x0355,
    0x0000, 0x0000, 0xFFF9, 0x02D2, 0x0000, 0x0000, 0xFFF9, 0x0272,
    0x0000, 0x0000, 0xFFF9, 0x0228, 0x0000, 0x0000, 0xFFF9, 0x01EE,
    0x0000, 0x0000, 0xFFF9, 0x01BF, 0x0000, 0x0000, 0xFFF9, 0x0198,
    0x0000, 0x0000, 0xFFF9, 0x0177, 0x0000, 0x0000, 0xFFF9, 0x015C,
    0x0000, 0x0000, 0xFFF9, 0x0144, 0x0000, 0x0000, 0xFFF9, 0x012F,
    0x0000, 0x0000, 0xFFF9, 0x011C, 0x0000, 0x0000, 0xFFF9, 0x010C,
    0x0000, 0x0000, 0xFFF9, 0x00FE, 0x0000, 0x0000, 0xFFF9, 0x00F1,
    0x0000, 0x0000, 0xFFF9, 0x00E5, 0x0000, 0x0000, 0xFFF9, 0x00DA,
    0x0000, 0x0000, 0xFFF9, 0x00D1, 0x0000, 0x0000, 0xFFF9, 0x00C8,
    0x0000, 0x0000, 0xFFF9, 0x00BF, 0x0000, 0x0000, 0xFFF9, 0x00B8,
    0x0000, 0x0000, 0xFFF9, 0x00B1, 0x0000, 0x0000, 0xFFF9, 0x00AB,
    0x0000, 0x0000, 0xFFF9, 0x00A5, 0x0000, 0x0000, 0xFFF9, 0x009F,
    0x0000, 0x0000, 0xFFF9, 0x009A, 0x0000, 0x0000, 0xFFF9, 0x0095,
    0x0000, 0x0000, 0xFFF9, 0x0090, 0x0000, 0x0000, 0xFFF9, 0x008C,
    0x0000, 0x0000, 0xFFF9, 0x0088, 0x0000, 0x0000, 0xFFF9, 0x0084,
    0x0000, 0x0000, 0xFFF9, 0x0080, 0x0000, 0x0000, 0xFFF9, 0x007D,
    0x0000, 0x0000, 0xFFF9, 0x007A, 0x0000, 0x0000, 0xFFF9, 0x0077,
    0x0000, 0x0000, 0xFFF9, 0x0074, 0x0000, 0x0000, 0xFFF9, 0x0071,
    0x0000, 0x0000, 0xFFF9, 0x006E, 0x0000, 0x0000, 0xFFF9, 0x006C,
    0x0000, 0x0000, 0xFFF9, 0x0069, 0x0000, 0x0000, 0xFFF9, 0x0067,
    0x0000, 0x0000, 0xFFF9, 0x0065, 0x0000, 0x0000, 0xFFF9, 0x0063,
    0x0000, 0x0000, 0xFFF9, 0x0061, 0x0000, 0x0000, 0xFFF9, 0x005F,
    0x0000, 0x0000, 0xFFF9, 0x005D, 0x0000, 0x0000, 0xFFF9, 0x005B,
    0x0000, 0x0000, 0xFFF9, 0x0059, 0x0000, 0x0000, 0xFFF9, 0x0058,
    0x0000, 0x0000, 0xFFF9, 0x0056, 0x0000, 0x0000, 0xFFF9, 0x0054,
    0x0000, 0x0000, 0xFFF9, 0x0053, 0x0000, 0x0000, 0xFFF9, 0x0051,
    0x0000, 0x0000, 0xFFF9, 0x0050, 0x0000, 0x0000, 0xFFF9, 0x004F,
    0x0000, 0x0000, 0xFFF9, 0x004D, 0x0000, 0x0000, 0xFFF9, 0x004C,
    0x0000, 0x0000, 0xFFF9, 0x004B, 0x0000, 0x0000, 0xFFF9, 0x004A,
    0x0000, 0x0000, 0xFFF9, 0x0049, 0x0000, 0x0000, 0xFFF9, 0x0047,
    0x0000, 0x0000, 0xFFF9, 0x0046, 0x0000, 0x0000, 0xFFF9, 0x0045,
    0x0000, 0x0000, 0xFFF9, 0x0044, 0x0000, 0x0000, 0xFFF9, 0x0043,
    0x0000, 0x0000, 0xFFF9, 0x0042, 0x0000, 0x0000, 0xFFF9, 0x0041,
    0x0000, 0x0000, 0xFFF9, 0x0040, 0x0000, 0x0000, 0xFFF9, 0x0040,
    0x0000, 0x0000, 0xFFF9, 0x003F, 0x0000, 0x0000, 0xFFF9, 0x003E,
    0x0000, 0x0000, 0xFFF9, 0x003D, 0x0000, 0x0000, 0xFFF9, 0x003C,
    0x0000, 0x0000, 0xFFF9, 0x003C, 0x0000, 0x0000, 0xFFF9, 0x003B,
    0x0000, 0x0000, 0xFFF9, 0x003A, 0x0000, 0x0000, 0xFFF9, 0x0039,
    0x0000, 0x0000, 0xFFF9, 0x0039, 0x0000, 0x0000, 0xFFF9, 0x0038,
    0x0000, 0x0000, 0xFFF9, 0x0037, 0x0000, 0x0000, 0xFFF9, 0x0037,
    0x0000, 0x0000, 0xFFF9, 0x0036, 0x0000, 0x0000, 0xFFF9, 0x0035,
    0x0000, 0x0000, 0xFFF9, 0x0035, 0x0000, 0x0000, 0xFFF9, 0x0034,
    0x0000, 0x0000, 0xFFF9, 0x0034, 0x0000, 0x0000, 0xFFF9, 0x0033,
    0x0000, 0x0000, 0xFFF9, 0x0032, 0x0000, 0x0000, 0xFFF9, 0x0032,
    0x0000, 0x0000, 0xFFF9, 0x0031, 0x0000, 0x0000, 0xFFF9, 0x0031,
    0x0000, 0x0000, 0xFFF9, 0x0030, 0x0000, 0x0000, 0xFFF9, 0x0030,
    0x0000, 0x0000, 0xFFF9, 0x002F, 0x0000, 0x0000, 0xFFF9, 0x002F,
    0x0000, 0x0000, 0xFFF9, 0x002E, 0x0000, 0x0000, 0xFFF9, 0x002E,
    0x0000, 0x0000, 0xFFF9, 0x002D, 0x0000, 0x0000, 0xFFF9, 0x002D,
    0x0000, 0x0000, 0xFFF9, 0x002D, 0x0000, 0x0000, 0xFFF9, 0x002C,
    0x0000, 0x0000, 0xFFF9, 0x002C, 0x0000, 0x0000, 0xFFF9, 0x002B,
    0x0000, 0x0000, 0xFFF9, 0x002B, 0x0000, 0x0000, 0xFFF9, 0x002A,
    0x0000, 0x0000, 0xFFF9, 0x002A, 0x0000, 0x0000, 0xFFF9, 0x002A,
    0x0000, 0x0000, 0xFFF9, 0x0029, 0x0000, 0x0000, 0xFFF9, 0x0029,
    0x0000, 0x0000, 0xFFF9, 0x0029, 0x0000, 0x0000, 0xFFF9, 0x0028,
    0x0000, 0x0000, 0xFFF9, 0x0028, 0x0000, 0x0000, 0xFFF9, 0x0028,
    0x0000, 0x0000, 0xFFF9, 0x0027, 0x0000, 0x0000, 0xFFF9, 0x0027,
    0x0000, 0x0000, 0xFFF9, 0x0027, 0x0000, 0x0000, 0xFFF9, 0x0026,
    0x0000, 0x0000, 0xFFF9, 0x0026, 0x0000, 0x0000, 0xFFF9, 0x0026,
    0x0000, 0x0000, 0xFFF9, 0x0025, 0x0000, 0x0000, 0xFFF9, 0x0025,
    0x0000, 0x0000, 0xFFF9, 0x0025, 0x0000, 0x0000, 0xFFF9, 0x0024,
    0x0000, 0x0000, 0xFFF9, 0x0024, 0x0000, 0x0000, 0xFFF9, 0x0024,
    0x0000, 0x0000, 0xFFF9, 0x0023, 0x0000, 0x0000, 0xFFF9, 0x0023,
    0x0000, 0x0000, 0xFFF9, 0x0023, 0x0000, 0x0000, 0xFFF9, 0x0023,
    0x0000, 0x0000, 0xFFF9, 0x0022, 0x0000, 0x0000, 0xFFF9, 0x0022,
    0x0000, 0x0000, 0xFFF9, 0x0022, 0x0000, 0x0000, 0xFFF9, 0x0022,
    0x0000, 0x0000, 0xFFF9, 0x0021, 0x0000, 0x0000, 0xFFF9, 0x0021,
    0x0000, 0x0000, 0xFFF9, 0x0021, 0x0000, 0x0000, 0xFFF9, 0x0021,
    0x0000, 0x0000, 0xFFF9, 0x0020, 0x0000, 0x0000, 0xFFF9, 0x0020,
    0x0000, 0x0000, 0xFFF9, 0x0020, 0x0000, 0x0000, 0xFFF9, 0x0020,
    0x0000, 0x0000, 0xFFF9, 0x001F, 0x0000, 0x0000, 0xFFF9, 0x001F,
    0x0000, 0x0000, 0xFFF9, 0x001F, 0x0000, 0x0000, 0xFFF9, 0x001F,
    0x0000, 0x0000, 0xFFF9, 0x001F, 0x0000, 0x0000, 0xFFF9, 0x001E,
    0x0000, 0x0000, 0xFFF9, 0x001E, 0x0000, 0x0000, 0xFFF9, 0x001E,
    0x0000, 0x0000, 0xFFF9, 0x001E, 0x0000, 0x0000, 0xFFF9, 0x001E,
    0x0000, 0x0000, 0xFFF9, 0x001D, 0x0000, 0x0000, 0xFFF9, 0x001D,
    0x0000, 0x0000, 0xFFF9, 0x001D, 0x0000, 0x0000, 0xFFF9, 0x001D,
    0x0000, 0x0000, 0xFFF9, 0x001D, 0x0000, 0x0000, 0xFFF9, 0x001C,
    0x0000, 0x0000, 0xFFF9, 0x001C, 0x0000, 0x0000, 0xFFF9, 0x001C,
    0x0000, 0x0000, 0xFFF9, 0x001C, 0x0000, 0x0000, 0xFFF9, 0x001C,
    0x0000, 0x0000, 0xFFF9, 0x001C, 0x0000, 0x0000, 0xFFF9, 0x001B,
    0x0000, 0x0000, 0xFFF9, 0x001B, 0x0000, 0x0000, 0xFFF9, 0x001B,
    0x0000, 0x0000, 0xFFF9, 0x001B, 0x0000, 0x0000, 0xFFF9, 0x001B,
    0x0000, 0x0000, 0xFFF9, 0x001B, 0x0000, 0x0000, 0xFFF9, 0x001A,
    0x0000, 0x0000, 0xFFF9, 0x001A, 0x0000, 0x0000, 0xFFF9, 0x001A,
    0x0000, 0x0000, 0xFFF9, 0x001A, 0x0000, 0x0000, 0xFFF9, 0x001A,
    0x0000, 0x0000, 0xFFF9, 0x001A, 0x0000, 0x0000, 0xFFF9, 0x0019,
    0x0000, 0x0000, 0xFFF9, 0x0019, 0x0000, 0x0000, 0xFFF9, 0x0019,
    0x0000, 0x0000, 0xFFF9, 0x0019, 0x0000, 0x0000, 0xFFF9, 0x0019,
    0x0000, 0x0000, 0xFFF9, 0x0019, 0x0000, 0x0000, 0xFFF9, 0x0019,
    0x0000, 0x0000, 0xFFF9, 0x0018, 0x0000, 0x0000, 0xFFF9, 0x0018,
    0x0000, 0x0000, 0xFFF9, 0x0018, 0x0000, 0x0000, 0xFFF9, 0x0018,
    0x0000, 0x0000, 0xFFF9, 0x0018, 0x0000, 0x0000, 0xFFF9, 0x0018,
    0x0000, 0x0000, 0xFFF9, 0x0018, 0x0000, 0x0000, 0xFFF9, 0x0018,
    0x0000, 0x0000, 0xFFF9, 0x0017, 0x0000, 0x0000, 0xFFF9, 0x0017,
    0x0000, 0x0000, 0xFFF9, 0x0017, 0x0000, 0x0000, 0xFFF9, 0x0017,
    0x0000, 0x0000, 0xFFF9, 0x0017, 0x0000, 0x0000, 0xFFF9, 0x0017,
    0x0000, 0x0000, 0xFFF9, 0x0017, 0x0000, 0x0000, 0xFFF9, 0x0017,
    0x0000, 0x0000, 0xFFF9, 0x0016, 0x0000, 0x0000, 0xFFF9, 0x0016,
    0x0000, 0x0000, 0xFFF9, 0x0016, 0x0000, 0x0000, 0xFFF9, 0x0016,
    0x0000, 0x0000, 0xFFF9, 0x0016, 0x0000, 0x0000, 0xFFF9, 0x0016,
    0x0000, 0x0000, 0xFFF9, 0x0016, 0x0000, 0x0000, 0xFFF9, 0x0016,
    0x0000, 0x0000, 0xFFF9, 0x0016, 0x0000, 0x0000, 0xFFF9, 0x0015,
    0x0000, 0x0000, 0xFFF9, 0x0015, 0x0000, 0x0000, 0xFFF9, 0x0015,
    0x0000, 0x0000, 0xFFF9, 0x0015, 0x0000, 0x0000, 0xFFF9, 0x0015,
    0x0000, 0x0000, 0xFFF9, 0x0015, 0x0000, 0x0000, 0xFFF9, 0x0015,
    0x0000, 0x0000, 0xFFF9, 0x0015, 0x0000, 0x0000, 0xFFF9, 0x0015,
    0x0000, 0x0000, 0xFFF9, 0x0014, 0x0000, 0x0000, 0xFFF9, 0x0014,
    0x0000, 0x0000, 0xFFF9, 0x0014, 0x0000, 0x0000, 0xFFF9, 0x0014,
    0x0000, 0x0000, 0xFFF9, 0x0014, 0x0000, 0x0000, 0xFFF9, 0x0014,
    0x0000, 0x0000, 0xFFF9, 0x0014, 0x0000, 0x0000, 0xFFF9, 0x0014,
    0x0000, 0x0000, 0xFFF9, 0x0014, 0x0000, 0x0000, 0xFFF9, 0x0014,
    0x0000, 0x0000, 0xFFF9, 0x0014, 0x0000, 0x0000, 0xFFF9, 0x0013,
    0x0000, 0x0000, 0xFFF9, 0x0013, 0x0000, 0x0000, 0xFFF9, 0x0013,
    0x0000, 0x0000, 0xFFF9, 0x0013, 0x0000, 0x0000, 0xFFF9, 0x0013,
    0x0000, 0x0000, 0xFFF9, 0x0013, 0x0000, 0x0000, 0xFFF9, 0x0013,
    0x0000, 0x0000, 0xFFF9, 0x0013, 0x0000, 0x0000, 0xFFF9, 0x0013,
    0x0000, 0x0000, 0xFFF9, 0x0013, 0x0000, 0x0000, 0xFFF9, 0x0013,
    0x0000, 0x0000, 0xFFF9, 0x0012, 0x0000, 0x0000, 0xFFF9, 0x0012,
    0x0000, 0x0000, 0xFFF9, 0x0012, 0x0000, 0x0000, 0xFFF9, 0x0012,
    0x0000, 0x0000, 0xFFF9, 0x0012, 0x0000, 0x0000, 0xFFF9, 0x0012,
    0x0000, 0x0000, 0xFFF9, 0x0012, 0x0000, 0x0000, 0xFFF9, 0x0012,
    0x0000, 0x0000, 0xFFF9, 0x0012, 0x0000, 0x0000, 0xFFF9, 0x0012,
    0x0000, 0x0000, 0xFFF9, 0x0012, 0x0000, 0x0000, 0xFFF9, 0x0012,
    0x0000, 0x0000, 0xFFF9, 0x0011, 0x0000, 0x0000, 0xFFF9, 0x0011,
    0x0000, 0x0000, 0xFFF9, 0x0011, 0x0000, 0x0000, 0xFFF9, 0x0011,
    0x0000, 0x0000, 0xFFF9, 0x0011, 0x0000, 0x0000, 0xFFF9, 0x0011,
    0x0000, 0x0000, 0xFFF9, 0x0011, 0x0000, 0x0000, 0xFFF9, 0x0011,
    0x0000, 0x0000, 0xFFF9, 0x0011, 0x0000, 0x0000, 0xFFF9, 0x0011,
    0x0000, 0x0000, 0xFFF9, 0x0011, 0x0000, 0x0000, 0xFFF9, 0x0011,
    0x0000, 0x0000, 0xFFF9, 0x0011, 0x0000, 0x0000, 0xFFF9, 0x0011,
    0x0000, 0x0000, 0xFFF9, 0x0010, 0x0000, 0x0000, 0xFFF9, 0x0010,
    0x0000, 0x0000, 0xFFF9, 0x0010, 0x0000, 0x0000, 0xFFF9, 0x0010,
    0x0000, 0x0000, 0xFFF9, 0x0010, 0x0000, 0x0000, 0xFFF9, 0x0010,
    0x0000, 0x0000, 0xFFF9, 0x0010, 0x0000, 0x0000, 0xFFF9, 0x0010,
    0x0000, 0x0000, 0xFFF9, 0x0010, 0x0000, 0x0000, 0xFFF9, 0x0010,
    0x0000, 0x0000, 0xFFF9, 0x0010, 0x0000, 0x0000, 0xFFF9, 0x0010,
    0x0000, 0x0000, 0xFFF9, 0x0010, 0x0000, 0x0000, 0xFFF9, 0x0010,
    0x0000, 0x0000, 0xFFF9, 0x0010, 0x0000, 0x0000, 0xFFF9, 0x000F,
    0x0000, 0x0000, 0xFFF9, 0x000F, 0x0000, 0x0000, 0xFFF9, 0x000F,
    0x0000, 0x0000, 0xFFF9, 0x000F, 0x0000, 0x0000, 0xFFF9, 0x000F,
    0x0000, 0x0000, 0xFFF9, 0x000F, 0x0000, 0x0000, 0xFFF9, 0x000F,
    0x0000, 0x0000, 0xFFF9, 0x000F, 0x0000, 0x0000, 0xFFF9, 0x000F,
    0x0000, 0x0000, 0xFFF9, 0x000F, 0x0000, 0x0000, 0xFFF9, 0x000F,
    0x0000, 0x0000, 0xFFF9, 0x000F, 0x0000, 0x0000, 0xFFF9, 0x000F,
    0x0000, 0x0000, 0xFFF9, 0x000F, 0x0000, 0x0000, 0xFFF9, 0x000F,
    0x0000, 0x0000, 0xFFF9, 0x000F, 0x0000, 0x0000, 0xFFF9, 0x000F,
    0x0000, 0x0000, 0xFFF9, 0x000E, 0x0000, 0x0000, 0xFFF9, 0x000E,
    0x0000, 0x0000, 0xFFF9, 0x000E, 0x0000, 0x0000, 0xFFF9, 0x000E,
    0x0000, 0x0000, 0xFFF9, 0x000E, 0x0000, 0x0000, 0xFFF9, 0x000E,
    0x0000, 0x0000, 0xFFF9, 0x000E, 0x0000, 0x0000, 0xFFF9, 0x000E,
    0x0000, 0x0000, 0xFFF9, 0x000E, 0x0000, 0x0000, 0xFFF9, 0x000E,
    0x0000, 0x0000, 0xFFF9, 0x000E, 0x0000, 0x0000, 0xFFF9, 0x000E,
    0x0000, 0x0000, 0xFFF9, 0x000E, 0x0000, 0x0000, 0xFFF9, 0x000E,
    0x0000, 0x0000, 0xFFF9, 0x000E, 0x0000, 0x0000, 0xFFF9, 0x000E,
    0x0000, 0x0000, 0xFFF9, 0x000E, 0x0000, 0x0000, 0xFFF9, 0x000E,
    0x0000, 0x0000, 0xFFF9, 0x000E, 0x0000, 0x0000, 0xFFF9, 0x000D,
    0x0000, 0x0000, 0xFFF9, 0x000D, 0x0000, 0x0000, 0xFFF9, 0x000D,
    0x0000, 0x0000, 0xFFF9, 0x000D, 0x0000, 0x0000, 0xFFF9, 0x000D,
    0x0000, 0x0000, 0xFFF9, 0x000D, 0x0000, 0x0000, 0xFFF9, 0x000D,
    0x0000, 0x0000, 0xFFF9, 0x000D, 0x0000, 0x0000, 0xFFF9, 0x000D,
    0x0000, 0x0000, 0xFFF9, 0x000D, 0x0000, 0x0000, 0xFFF9, 0x000D,
    0x0000, 0x0000, 0xFFF9, 0x000D, 0x0000, 0x0000, 0xFFF9, 0x000D,
    0x0000, 0x0000, 0xFFF9, 0x000D, 0x0000, 0x0000, 0xFFF9, 0x000D,
    0x0000, 0x0000, 0xFFF9, 0x000D, 0x0000, 0x0000, 0xFFF9, 0x000D,
    0x0000, 0x0000, 0xFFF9, 0x000D, 0x0000, 0x0000, 0xFFF9, 0x000D,
    0x0000, 0x0000, 0xFFF9, 0x000D, 0x0000, 0x0000, 0xFFF9, 0x000D,
    0x0000, 0x0000, 0xFFF9, 0x000D, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF5, 0x0000, 0x0000, 0xFFF9, 0xFFF5,
    0x0000, 0x0000, 0xFFF9, 0xFFF5, 0x0000, 0x0000, 0xFFF9, 0xFFF5,
    0x0000, 0x0000, 0xFFF9, 0xFFF5, 0x0000, 0x0000, 0xFFF9, 0xFFF5,
    0x0000, 0x0000, 0xFFF9, 0xFFF5, 0x0000, 0x0000, 0xFFF9, 0xFFF5,
    0x0000, 0x0000, 0xFFF9, 0xFFF5, 0x0000, 0x0000, 0xFFF9, 0xFFF5,
    0x0000, 0x0000, 0xFFF9, 0xFFF5, 0x0000, 0x0000, 0xFFF9, 0xFFF5,
    0x0000, 0x0000, 0xFFF9, 0xFFF5, 0x0000, 0x0000, 0xFFF9, 0xFFF5,
    0x0000, 0x0000, 0xFFF9, 0xFFF5, 0x0000, 0x0000, 0xFFF9, 0xFFF5,
    0x0000, 0x0000, 0xFFF9, 0xFFF5, 0x0000, 0x0000, 0xFFF9, 0xFFF5,
    0x0000, 0x0000, 0xFFF9, 0xFFF5, 0x0000, 0x0000, 0xFFF9, 0xFFF5,
    0x0000, 0x0000, 0xFFF9, 0xFFF5, 0x0000, 0x0000, 0xFFF9, 0xFFF5,
    0x0000, 0x0000, 0xFFF9, 0xFFF5, 0x0000, 0x0000, 0xFFF9, 0xFFF5,
    0x0000, 0x0000, 0xFFF9, 0xFFF5, 0x0000, 0x0000, 0xFFF9, 0xFFF5,
    0x0000, 0x0000, 0xFFF9, 0xFFF5, 0x0000, 0x0000, 0xFFF9, 0xFFF4,
    0x0000, 0x0000, 0xFFF9, 0xFFF4, 0x0000, 0x0000, 0xFFF9, 0xFFF4,
    0x0000, 0x0000, 0xFFF9, 0xFFF4, 0x0000, 0x0000, 0xFFF9, 0xFFF4,
    0x0000, 0x0000, 0xFFF9, 0xFFF4, 0x0000, 0x0000, 0xFFF9, 0xFFF4,
    0x0000, 0x0000, 0xFFF9, 0xFFF4, 0x0000, 0x0000, 0xFFF9, 0xFFF4,
    0x0000, 0x0000, 0xFFF9, 0xFFF4, 0x0000, 0x0000, 0xFFF9, 0xFFF4,
    0x0000, 0x0000, 0xFFF9, 0xFFF4, 0x0000, 0x0000, 0xFFF9, 0xFFF4,
    0x0000, 0x0000, 0xFFF9, 0xFFF4, 0x0000, 0x0000, 0xFFF9, 0xFFF4,
    0x0000, 0x0000, 0xFFF9, 0xFFF4, 0x0000, 0x0000, 0xFFF9, 0xFFF4,
    0x0000, 0x0000, 0xFFF9, 0xFFF4, 0x0000, 0x0000, 0xFFF9, 0xFFF4,
    0x0000, 0x0000, 0xFFF9, 0xFFF4, 0x0000, 0x0000, 0xFFF9, 0xFFF4,
    0x0000, 0x0000, 0xFFF9, 0xFFF4, 0x0000, 0x0000, 0xFFF9, 0xFFF4,
    0x0000, 0x0000, 0xFFF9, 0xFFF4, 0x0000, 0x0000, 0xFFF9, 0xFFF3,
    0x0000, 0x0000, 0xFFF9, 0xFFF3, 0x0000, 0x0000, 0xFFF9, 0xFFF3,
    0x0000, 0x0000, 0xFFF9, 0xFFF3, 0x0000, 0x0000, 0xFFF9, 0xFFF3,
    0x0000, 0x0000, 0xFFF9, 0xFFF3, 0x0000, 0x0000, 0xFFF9, 0xFFF3,
    0x0000, 0x0000, 0xFFF9, 0xFFF3, 0x0000, 0x0000, 0xFFF9, 0xFFF3,
    0x0000, 0x0000, 0xFFF9, 0xFFF3, 0x0000, 0x0000, 0xFFF9, 0xFFF3,
    0x0000, 0x0000, 0xFFF9, 0xFFF3, 0x0000, 0x0000, 0xFFF9, 0xFFF3,
    0x0000, 0x0000, 0xFFF9, 0xFFF3, 0x0000, 0x0000, 0xFFF9, 0xFFF3,
    0x0000, 0x0000, 0xFFF9, 0xFFF3, 0x0000, 0x0000, 0xFFF9, 0xFFF3,
    0x0000, 0x0000, 0xFFF9, 0xFFF3, 0x0000, 0x0000, 0xFFF9, 0xFFF3,
    0x0000, 0x0000, 0xFFF9, 0xFFF3, 0x0000, 0x0000, 0xFFF9, 0xFFF3,
    0x0000, 0x0000, 0xFFF9, 0xFFF3, 0x0000, 0x0000, 0xFFF9, 0xFFF2,
    0x0000, 0x0000, 0xFFF9, 0xFFF2, 0x0000, 0x0000, 0xFFF9, 0xFFF2,
    0x0000, 0x0000, 0xFFF9, 0xFFF2, 0x0000, 0x0000, 0xFFF9, 0xFFF2,
    0x0000, 0x0000, 0xFFF9, 0xFFF2, 0x0000, 0x0000, 0xFFF9, 0xFFF2,
    0x0000, 0x0000, 0xFFF9, 0xFFF2, 0x0000, 0x0000, 0xFFF9, 0xFFF2,
    0x0000, 0x0000, 0xFFF9, 0xFFF2, 0x0000, 0x0000, 0xFFF9, 0xFFF2,
    0x0000, 0x0000, 0xFFF9, 0xFFF2, 0x0000, 0x0000, 0xFFF9, 0xFFF2,
    0x0000, 0x0000, 0xFFF9, 0xFFF2, 0x0000, 0x0000, 0xFFF9, 0xFFF2,
    0x0000, 0x0000, 0xFFF9, 0xFFF2, 0x0000, 0x0000, 0xFFF9, 0xFFF2,
    0x0000, 0x0000, 0xFFF9, 0xFFF2, 0x0000, 0x0000, 0xFFF9, 0xFFF2,
    0x0000, 0x0000, 0xFFF9, 0xFFF1, 0x0000, 0x0000, 0xFFF9, 0xFFF1,
    0x0000, 0x0000, 0xFFF9, 0xFFF1, 0x0000, 0x0000, 0xFFF9, 0xFFF1,
    0x0000, 0x0000, 0xFFF9, 0xFFF1, 0x0000, 0x0000, 0xFFF9, 0xFFF1,
    0x0000, 0x0000, 0xFFF9, 0xFFF1, 0x0000, 0x0000, 0xFFF9, 0xFFF1,
    0x0000, 0x0000, 0xFFF9, 0xFFF1, 0x0000, 0x0000, 0xFFF9, 0xFFF1,
    0x0000, 0x0000, 0xFFF9, 0xFFF1, 0x0000, 0x0000, 0xFFF9, 0xFFF1,
    0x0000, 0x0000, 0xFFF9, 0xFFF1, 0x0000, 0x0000, 0xFFF9, 0xFFF1,
    0x0000, 0x0000, 0xFFF9, 0xFFF1, 0x0000, 0x0000, 0xFFF9, 0xFFF1,
    0x0000, 0x0000, 0xFFF9, 0xFFF1, 0x0000, 0x0000, 0xFFF9, 0xFFF0,
    0x0000, 0x0000, 0xFFF9, 0xFFF0, 0x0000, 0x0000, 0xFFF9, 0xFFF0,
    0x0000, 0x0000, 0xFFF9, 0xFFF0, 0x0000, 0x0000, 0xFFF9, 0xFFF0,
    0x0000, 0x0000, 0xFFF9, 0xFFF0, 0x0000, 0x0000, 0xFFF9, 0xFFF0,
    0x0000, 0x0000, 0xFFF9, 0xFFF0, 0x0000, 0x0000, 0xFFF9, 0xFFF0,
    0x0000, 0x0000, 0xFFF9, 0xFFF0, 0x0000, 0x0000, 0xFFF9, 0xFFF0,
    0x0000, 0x0000, 0xFFF9, 0xFFF0, 0x0000, 0x0000, 0xFFF9, 0xFFF0,
    0x0000, 0x0000, 0xFFF9, 0xFFF0, 0x0000, 0x0000, 0xFFF9, 0xFFF0,
    0x0000, 0x0000, 0xFFF9, 0xFFEF, 0x0000, 0x0000, 0xFFF9, 0xFFEF,
    0x0000, 0x0000, 0xFFF9, 0xFFEF, 0x0000, 0x0000, 0xFFF9, 0xFFEF,
    0x0000, 0x0000, 0xFFF9, 0xFFEF, 0x0000, 0x0000, 0xFFF9, 0xFFEF,
    0x0000, 0x0000, 0xFFF9, 0xFFEF, 0x0000, 0x0000, 0xFFF9, 0xFFEF,
    0x0000, 0x0000, 0xFFF9, 0xFFEF, 0x0000, 0x0000, 0xFFF9, 0xFFEF,
    0x0000, 0x0000, 0xFFF9, 0xFFEF, 0x0000, 0x0000, 0xFFF9, 0xFFEF,
    0x0000, 0x0000, 0xFFF9, 0xFFEF, 0x0000, 0x0000, 0xFFF9, 0xFFEF,
    0x0000, 0x0000, 0xFFF9, 0xFFEE, 0x0000, 0x0000, 0xFFF9, 0xFFEE,
    0x0000, 0x0000, 0xFFF9, 0xFFEE, 0x0000, 0x0000, 0xFFF9, 0xFFEE,
    0x0000, 0x0000, 0xFFF9, 0xFFEE, 0x0000, 0x0000, 0xFFF9, 0xFFEE,
    0x0000, 0x0000, 0xFFF9, 0xFFEE, 0x0000, 0x0000, 0xFFF9, 0xFFEE,
    0x0000, 0x0000, 0xFFF9, 0xFFEE, 0x0000, 0x0000, 0xFFF9, 0xFFEE,
    0x0000, 0x0000, 0xFFF9, 0xFFEE, 0x0000, 0x0000, 0xFFF9, 0xFFEE,
    0x0000, 0x0000, 0xFFF9, 0xFFED, 0x0000, 0x0000, 0xFFF9, 0xFFED,
    0x0000, 0x0000, 0xFFF9, 0xFFED, 0x0000, 0x0000, 0xFFF9, 0xFFED,
    0x0000, 0x0000, 0xFFF9, 0xFFED, 0x0000, 0x0000, 0xFFF9, 0xFFED,
    0x0000, 0x0000, 0xFFF9, 0xFFED, 0x0000, 0x0000, 0xFFF9, 0xFFED,
    0x0000, 0x0000, 0xFFF9, 0xFFED, 0x0000, 0x0000, 0xFFF9, 0xFFED,
    0x0000, 0x0000, 0xFFF9, 0xFFED, 0x0000, 0x0000, 0xFFF9, 0xFFEC,
    0x0000, 0x0000, 0xFFF9, 0xFFEC, 0x0000, 0x0000, 0xFFF9, 0xFFEC,
    0x0000, 0x0000, 0xFFF9, 0xFFEC, 0x0000, 0x0000, 0xFFF9, 0xFFEC,
    0x0000, 0x0000, 0xFFF9, 0xFFEC, 0x0000, 0x0000, 0xFFF9, 0xFFEC,
    0x0000, 0x0000, 0xFFF9, 0xFFEC, 0x0000, 0x0000, 0xFFF9, 0xFFEC,
    0x0000, 0x0000, 0xFFF9, 0xFFEC, 0x0000, 0x0000, 0xFFF9, 0xFFEC,
    0x0000, 0x0000, 0xFFF9, 0xFFEB, 0x0000, 0x0000, 0xFFF9, 0xFFEB,
    0x0000, 0x0000, 0xFFF9, 0xFFEB, 0x0000, 0x0000, 0xFFF9, 0xFFEB,
    0x0000, 0x0000, 0xFFF9, 0xFFEB, 0x0000, 0x0000, 0xFFF9, 0xFFEB,
    0x0000, 0x0000, 0xFFF9, 0xFFEB, 0x0000, 0x0000, 0xFFF9, 0xFFEB,
    0x0000, 0x0000, 0xFFF9, 0xFFEB, 0x0000, 0x0000, 0xFFF9, 0xFFEA,
    0x0000, 0x0000, 0xFFF9, 0xFFEA, 0x0000, 0x0000, 0xFFF9, 0xFFEA,
    0x0000, 0x0000, 0xFFF9, 0xFFEA, 0x0000, 0x0000, 0xFFF9, 0xFFEA,
    0x0000, 0x0000, 0xFFF9, 0xFFEA, 0x0000, 0x0000, 0xFFF9, 0xFFEA,
    0x0000, 0x0000, 0xFFF9, 0xFFEA, 0x0000, 0x0000, 0xFFF9, 0xFFEA,
    0x0000, 0x0000, 0xFFF9, 0xFFE9, 0x0000, 0x0000, 0xFFF9, 0xFFE9,
    0x0000, 0x0000, 0xFFF9, 0xFFE9, 0x0000, 0x0000, 0xFFF9, 0xFFE9,
    0x0000, 0x0000, 0xFFF9, 0xFFE9, 0x0000, 0x0000, 0xFFF9, 0xFFE9,
    0x0000, 0x0000, 0xFFF9, 0xFFE9, 0x0000, 0x0000, 0xFFF9, 0xFFE9,
    0x0000, 0x0000, 0xFFF9, 0xFFE8, 0x0000, 0x0000, 0xFFF9, 0xFFE8,
    0x0000, 0x0000, 0xFFF9, 0xFFE8, 0x0000, 0x0000, 0xFFF9, 0xFFE8,
    0x0000, 0x0000, 0xFFF9, 0xFFE8, 0x0000, 0x0000, 0xFFF9, 0xFFE8,
    0x0000, 0x0000, 0xFFF9, 0xFFE8, 0x0000, 0x0000, 0xFFF9, 0xFFE8,
    0x0000, 0x0000, 0xFFF9, 0xFFE7, 0x0000, 0x0000, 0xFFF9, 0xFFE7,
    0x0000, 0x0000, 0xFFF9, 0xFFE7, 0x0000, 0x0000, 0xFFF9, 0xFFE7,
    0x0000, 0x0000, 0xFFF9, 0xFFE7, 0x0000, 0x0000, 0xFFF9, 0xFFE7,
    0x0000, 0x0000, 0xFFF9, 0xFFE7, 0x0000, 0x0000, 0xFFF9, 0xFFE6,
    0x0000, 0x0000, 0xFFF9, 0xFFE6, 0x0000, 0x0000, 0xFFF9, 0xFFE6,
    0x0000, 0x0000, 0xFFF9, 0xFFE6, 0x0000, 0x0000, 0xFFF9, 0xFFE6,
    0x0000, 0x0000, 0xFFF9, 0xFFE6, 0x0000, 0x0000, 0xFFF9, 0xFFE5,
    0x0000, 0x0000, 0xFFF9, 0xFFE5, 0x0000, 0x0000, 0xFFF9, 0xFFE5,
    0x0000, 0x0000, 0xFFF9, 0xFFE5, 0x0000, 0x0000, 0xFFF9, 0xFFE5,
    0x0000, 0x0000, 0xFFF9, 0xFFE5, 0x0000, 0x0000, 0xFFF9, 0xFFE4,
    0x0000, 0x0000, 0xFFF9, 0xFFE4, 0x0000, 0x0000, 0xFFF9, 0xFFE4,
    0x0000, 0x0000, 0xFFF9, 0xFFE4, 0x0000, 0x0000, 0xFFF9, 0xFFE4,
    0x0000, 0x0000, 0xFFF9, 0xFFE4, 0x0000, 0x0000, 0xFFF9, 0xFFE3,
    0x0000, 0x0000, 0xFFF9, 0xFFE3, 0x0000, 0x0000, 0xFFF9, 0xFFE3,
    0x0000, 0x0000, 0xFFF9, 0xFFE3, 0x0000, 0x0000, 0xFFF9, 0xFFE3,
    0x0000, 0x0000, 0xFFF9, 0xFFE2, 0x0000, 0x0000, 0xFFF9, 0xFFE2,
    0x0000, 0x0000, 0xFFF9, 0xFFE2, 0x0000, 0x0000, 0xFFF9, 0xFFE2,
    0x0000, 0x0000, 0xFFF9, 0xFFE2, 0x0000, 0x0000, 0xFFF9, 0xFFE1,
    0x0000, 0x0000, 0xFFF9, 0xFFE1, 0x0000, 0x0000, 0xFFF9, 0xFFE1,
    0x0000, 0x0000, 0xFFF9, 0xFFE1, 0x0000, 0x0000, 0xFFF9, 0xFFE1,
    0x0000, 0x0000, 0xFFF9, 0xFFE0, 0x0000, 0x0000, 0xFFF9, 0xFFE0,
    0x0000, 0x0000, 0xFFF9, 0xFFE0, 0x0000, 0x0000, 0xFFF9, 0xFFE0,
    0x0000, 0x0000, 0xFFF9, 0xFFDF, 0x0000, 0x0000, 0xFFF9, 0xFFDF,
    0x0000, 0x0000, 0xFFF9, 0xFFDF, 0x0000, 0x0000, 0xFFF9, 0xFFDF,
    0x0000, 0x0000, 0xFFF9, 0xFFDE, 0x0000, 0x0000, 0xFFF9, 0xFFDE,
    0x0000, 0x0000, 0xFFF9, 0xFFDE, 0x0000, 0x0000, 0xFFF9, 0xFFDE,
    0x0000, 0x0000, 0xFFF9, 0xFFDD, 0x0000, 0x0000, 0xFFF9, 0xFFDD,
    0x0000, 0x0000, 0xFFF9, 0xFFDD, 0x0000, 0x0000, 0xFFF9, 0xFFDD,
    0x0000, 0x0000, 0xFFF9, 0xFFDC, 0x0000, 0x0000, 0xFFF9, 0xFFDC,
    0x0000, 0x0000, 0xFFF9, 0xFFDC, 0x0000, 0x0000, 0xFFF9, 0xFFDB,
    0x0000, 0x0000, 0xFFF9, 0xFFDB, 0x0000, 0x0000, 0xFFF9, 0xFFDB,
    0x0000, 0x0000, 0xFFF9, 0xFFDA, 0x0000, 0x0000, 0xFFF9, 0xFFDA,
    0x0000, 0x0000, 0xFFF9, 0xFFDA, 0x0000, 0x0000, 0xFFF9, 0xFFD9,
    0x0000, 0x0000, 0xFFF9, 0xFFD9, 0x0000, 0x0000, 0xFFF9, 0xFFD9,
    0x0000, 0x0000, 0xFFF9, 0xFFD8, 0x0000, 0x0000, 0xFFF9, 0xFFD8,
    0x0000, 0x0000, 0xFFF9, 0xFFD8, 0x0000, 0x0000, 0xFFF9, 0xFFD7,
    0x0000, 0x0000, 0xFFF9, 0xFFD7, 0x0000, 0x0000, 0xFFF9, 0xFFD7,
    0x0000, 0x0000, 0xFFF9, 0xFFD6, 0x0000, 0x0000, 0xFFF9, 0xFFD6,
    0x0000, 0x0000, 0xFFF9, 0xFFD6, 0x0000, 0x0000, 0xFFF9, 0xFFD5,
    0x0000, 0x0000, 0xFFF9, 0xFFD5, 0x0000, 0x0000, 0xFFF9, 0xFFD4,
    0x0000, 0x0000, 0xFFF9, 0xFFD4, 0x0000, 0x0000, 0xFFF9, 0xFFD3,
    0x0000, 0x0000, 0xFFF9, 0xFFD3, 0x0000, 0x0000, 0xFFF9, 0xFFD3,
    0x0000, 0x0000, 0xFFF9, 0xFFD2, 0x0000, 0x0000, 0xFFF9, 0xFFD2,
    0x0000, 0x0000, 0xFFF9, 0xFFD1, 0x0000, 0x0000, 0xFFF9, 0xFFD1,
    0x0000, 0x0000, 0xFFF9, 0xFFD0, 0x0000, 0x0000, 0xFFF9, 0xFFD0,
    0x0000, 0x0000, 0xFFF9, 0xFFCF, 0x0000, 0x0000, 0xFFF9, 0xFFCF,
    0x0000, 0x0000, 0xFFF9, 0xFFCE, 0x0000, 0x0000, 0xFFF9, 0xFFCE,
    0x0000, 0x0000, 0xFFF9, 0xFFCD, 0x0000, 0x0000, 0xFFF9, 0xFFCC,
    0x0000, 0x0000, 0xFFF9, 0xFFCC, 0x0000, 0x0000, 0xFFF9, 0xFFCB,
    0x0000, 0x0000, 0xFFF9, 0xFFCB, 0x0000, 0x0000, 0xFFF9, 0xFFCA,
    0x0000, 0x0000, 0xFFF9, 0xFFC9, 0x0000, 0x0000, 0xFFF9, 0xFFC9,
    0x0000, 0x0000, 0xFFF9, 0xFFC8, 0x0000, 0x0000, 0xFFF9, 0xFFC7,
    0x0000, 0x0000, 0xFFF9, 0xFFC7, 0x0000, 0x0000, 0xFFF9, 0xFFC6,
    0x0000, 0x0000, 0xFFF9, 0xFFC5, 0x0000, 0x0000, 0xFFF9, 0xFFC4,
    0x0000, 0x0000, 0xFFF9, 0xFFC4, 0x0000, 0x0000, 0xFFF9, 0xFFC3,
    0x0000, 0x0000, 0xFFF9, 0xFFC2, 0x0000, 0x0000, 0xFFF9, 0xFFC1,
    0x0000, 0x0000, 0xFFF9, 0xFFC0, 0x0000, 0x0000, 0xFFF9, 0xFFC0,
    0x0000, 0x0000, 0xFFF9, 0xFFBF, 0x0000, 0x0000, 0xFFF9, 0xFFBE,
    0x0000, 0x0000, 0xFFF9, 0xFFBD, 0x0000, 0x0000, 0xFFF9, 0xFFBC,
    0x0000, 0x0000, 0xFFF9, 0xFFBB, 0x0000, 0x0000, 0xFFF9, 0xFFBA,
    0x0000, 0x0000, 0xFFF9, 0xFFB9, 0x0000, 0x0000, 0xFFF9, 0xFFB7,
    0x0000, 0x0000, 0xFFF9, 0xFFB6, 0x0000, 0x0000, 0xFFF9, 0xFFB5,
    0x0000, 0x0000, 0xFFF9, 0xFFB4, 0x0000, 0x0000, 0xFFF9, 0xFFB3,
    0x0000, 0x0000, 0xFFF9, 0xFFB1, 0x0000, 0x0000, 0xFFF9, 0xFFB0,
    0x0000, 0x0000, 0xFFF9, 0xFFAF, 0x0000, 0x0000, 0xFFF9, 0xFFAD,
    0x0000, 0x0000, 0xFFF9, 0xFFAC, 0x0000, 0x0000, 0xFFF9, 0xFFAA,
    0x0000, 0x0000, 0xFFF9, 0xFFA8, 0x0000, 0x0000, 0xFFF9, 0xFFA7,
    0x0000, 0x0000, 0xFFF9, 0xFFA5, 0x0000, 0x0000, 0xFFF9, 0xFFA3,
    0x0000, 0x0000, 0xFFF9, 0xFFA1, 0x0000, 0x0000, 0xFFF9, 0xFF9F,
    0x0000, 0x0000, 0xFFF9, 0xFF9D, 0x0000, 0x0000, 0xFFF9, 0xFF9B,
    0x0000, 0x0000, 0xFFF9, 0xFF99, 0x0000, 0x0000, 0xFFF9, 0xFF97,
    0x0000, 0x0000, 0xFFF9, 0xFF94, 0x0000, 0x0000, 0xFFF9, 0xFF92,
    0x0000, 0x0000, 0xFFF9, 0xFF8F, 0x0000, 0x0000, 0xFFF9, 0xFF8C,
    0x0000, 0x0000, 0xFFF9, 0xFF89, 0x0000, 0x0000, 0xFFF9, 0xFF86,
    0x0000, 0x0000, 0xFFF9, 0xFF83, 0x0000, 0x0000, 0xFFF9, 0xFF80,
    0x0000, 0x0000, 0xFFF9, 0xFF7C, 0x0000, 0x0000, 0xFFF9, 0xFF78,
    0x0000, 0x0000, 0xFFF9, 0xFF74, 0x0000, 0x0000, 0xFFF9, 0xFF70,
    0x0000, 0x0000, 0xFFF9, 0xFF6B, 0x0000, 0x0000, 0xFFF9, 0xFF66,
    0x0000, 0x0000, 0xFFF9, 0xFF61, 0x0000, 0x0000, 0xFFF9, 0xFF5B,
    0x0000, 0x0000, 0xFFF9, 0xFF55, 0x0000, 0x0000, 0xFFF9, 0xFF4F,
    0x0000, 0x0000, 0xFFF9, 0xFF48, 0x0000, 0x0000, 0xFFF9, 0xFF41,
    0x0000, 0x0000, 0xFFF9, 0xFF38, 0x0000, 0x0000, 0xFFF9, 0xFF2F,
    0x0000, 0x0000, 0xFFF9, 0xFF26, 0x0000, 0x0000, 0xFFF9, 0xFF1B,
    0x0000, 0x0000, 0xFFF9, 0xFF0F, 0x0000, 0x0000, 0xFFF9, 0xFF02,
    0x0000, 0x0000, 0xFFF9, 0xFEF4, 0x0000, 0x0000, 0xFFF9, 0xFEE4,
    0x0000, 0x0000, 0xFFF9, 0xFED1, 0x0000, 0x0000, 0xFFF9, 0xFEBC,
    0x0000, 0x0000, 0xFFF9, 0xFEA4, 0x0000, 0x0000, 0xFFF9, 0xFE89,
    0x0000, 0x0000, 0xFFF9, 0xFE68, 0x0000, 0x0000, 0xFFF9, 0xFE41,
    0x0000, 0x0000, 0xFFF9, 0xFE12, 0x0000, 0x0000, 0xFFF9, 0xFDD8,
    0x0000, 0x0000, 0xFFF9, 0xFD8E, 0x0000, 0x0000, 0xFFF9, 0xFD2E,
    0x0000, 0x0000, 0xFFF9, 0xFCAB, 0x0000, 0x0000, 0xFFF9, 0xFBED,
    0x0000, 0x0000, 0xFFF9, 0xFAC3, 0x0000, 0x0000, 0xFFF9, 0xF8AB,
    0x0000, 0x0000, 0xFFF9, 0xF3C7, 0x0000, 0x0000, 0xFFF9, 0xDB55
    };

