static const uint32_t in_rfft_noisy_32[32] = {
    0xbdbb93e5, 0x3ef216c0, 0x3f32be02, 0x3ee80ce4,
    0xbd61d984, 0xbef9599b, 0xbf3942a0, 0xbf07ecef,
    0xbd0660ae, 0x3ef6fee0, 0x3f169765, 0x3ef242da,
    0xbc7910e0, 0xbf16c7dc, 0xbf1c3306, 0xbf0635c9,
    0xbd983790, 0x3f0d9858, 0x3f2671c9, 0x3ef938e9,
    0x3d21f329, 0xbef4fa46, 0xbf26fab3, 0xbf076d88,
    0xbbe89669, 0x3f06c631, 0x3f39a0ab, 0x3ef63c0f,
    0xbb209c32, 0xbefca0f6, 0xbf3cd907, 0xbf0f57fb
    };

static const uint32_t in_rifft_noisy_32[33] = {
    0xbf10743e, 0xbd1b6a26, 0xbe363b3a, 0x3ebb6385,
    0xbe0d71f7, 0xbdf120c4, 0xbe39b82d, 0xbd9a3af0,
    0xbe108632, 0xc1320bd8, 0x3d288c83, 0xbe619d9e,
    0xbd565c3f, 0xbad7bc4e, 0xbe00d908, 0xbd23b8c7,
    0xbe35499d, 0xbe72b3cd, 0x3d93ec7e, 0xbdb2587f,
    0xbe93f28c, 0x3b84f0a3, 0x3e634941, 0x3eba5dde,
    0xbe50e4d6, 0xbeb6b61a, 0x3da5b7ff, 0x3e9db21b,
    0xbcc9aa8c, 0xbdd4a387, 0xbd8dc70b, 0xbdb3d4e2,
    0x0
    };

static const uint32_t ref_rfft_noisy_32[33] = {
    0xbf10743e, 0xbd1b6a26, 0xbe363b3a, 0x3ebb6385,
    0xbe0d71f7, 0xbdf120c4, 0xbe39b82d, 0xbd9a3af0,
    0xbe108632, 0xc1320bd8, 0x3d288c83, 0xbe619d9e,
    0xbd565c3f, 0xbad7bc4e, 0xbe00d908, 0xbd23b8c7,
    0xbe35499d, 0xbe72b3cd, 0x3d93ec7e, 0xbdb2587f,
    0xbe93f28c, 0x3b84f0a3, 0x3e634941, 0x3eba5dde,
    0xbe50e4d6, 0xbeb6b61a, 0x3da5b7ff, 0x3e9db21b,
    0xbcc9aa8c, 0xbdd4a387, 0xbd8dc70b, 0xbdb3d4e2,
    0x0
    };

static const uint32_t in_rfft_noisy_64[64] = {
    0xbd45d394, 0x3ef743dd, 0x3f3898a8, 0x3efa49a5,
    0xbd15f87e, 0xbece9de7, 0xbf292ac1, 0xbf116af8,
    0xbb0e473f, 0x3f0e0fbf, 0x3f417941, 0x3ee912a0,
    0x3b46ae05, 0xbeebc773, 0xbf4927af, 0xbee9253b,
    0xbd21591c, 0x3f0bea40, 0x3f3e8523, 0x3f059343,
    0x3d393980, 0xbf03a55e, 0xbf2b032c, 0xbf1025cd,
    0xbc5975ff, 0x3effc7cf, 0x3f18c1d7, 0x3f1df474,
    0x3d4cb8fb, 0xbef75f75, 0xbf3178b7, 0xbecd0888,
    0x3b4ada26, 0x3ede8b90, 0x3f2bf997, 0x3ee20fcc,
    0x3bfbdc81, 0xbef79fe5, 0xbf22dfc6, 0xbf095a19,
    0x3d173f0e, 0x3f11a999, 0x3f385483, 0x3ed40d71,
    0xbad6376e, 0xbf0a1571, 0xbf320ddd, 0xbece45c2,
    0x3bda75cc, 0x3ef359c0, 0x3f41581d, 0x3f0cefc8,
    0xbc87d4d8, 0xbef5c864, 0xbf3cb2cb, 0xbf020996,
    0xbd6fa284, 0x3ee69825, 0x3f2bf927, 0x3ef2091e,
    0xbc8d9843, 0xbf00388d, 0xbf1c000e, 0xbf04ef9d
    };

static const uint32_t in_rifft_noisy_64[65] = {
    0x3e66f34e, 0xbdb1ad1f, 0xbe35dc07, 0xbe00a954,
    0xbe037941, 0xbe31a122, 0x3ca89f57, 0xbe93b8ff,
    0x3e680b11, 0xbd733954, 0x3dd1b7dd, 0xbdcf499e,
    0xbe46631f, 0x3f5efbdf, 0x3dbea50b, 0xbeaf132a,
    0xbe32e4a3, 0xc1b2537d, 0xbe932b34, 0x3e143b83,
    0xbe42d05e, 0x3dbca650, 0x3d6c793d, 0x3de414ef,
    0x3d89e2b4, 0x3eb37c07, 0xbeb5ed40, 0xbe000f1a,
    0x3ee85dd0, 0xbe0cd1ac, 0xbe35e247, 0xbe1abd6a,
    0xbe6d3d2c, 0xbe0f0d1b, 0xbf124d7f, 0xbeb69994,
    0xbf12b836, 0x3e0ee42b, 0x3d168af0, 0xbe77cbd7,
    0xbe78b950, 0x3f3e8b58, 0x3d0ca480, 0xbe46860b,
    0xbd13b3f9, 0xbeace23d, 0x3e60caf6, 0x3e32f961,
    0xbdfb849c, 0xbd3a184f, 0x3cf9cb38, 0x3e0b00d0,
    0x3ee38cd8, 0xbe71e59a, 0xbe4ebd8c, 0xbf1ffa83,
    0xbe5bce06, 0x3e499325, 0x3ebe1b62, 0xbe62096f,
    0x3dfcdc50, 0x3e8e863e, 0xbc8c4e2a, 0xbe5e7b1d,
    0x0
    };

static const uint32_t ref_rfft_noisy_64[65] = {
    0x3e66f34e, 0xbdb1ad1f, 0xbe35dc07, 0xbe00a954,
    0xbe037941, 0xbe31a122, 0x3ca89f57, 0xbe93b8ff,
    0x3e680b11, 0xbd733954, 0x3dd1b7dd, 0xbdcf499e,
    0xbe46631f, 0x3f5efbdf, 0x3dbea50b, 0xbeaf132a,
    0xbe32e4a3, 0xc1b2537d, 0xbe932b34, 0x3e143b83,
    0xbe42d05e, 0x3dbca650, 0x3d6c793d, 0x3de414ef,
    0x3d89e2b4, 0x3eb37c07, 0xbeb5ed40, 0xbe000f1a,
    0x3ee85dd0, 0xbe0cd1ac, 0xbe35e247, 0xbe1abd6a,
    0xbe6d3d2c, 0xbe0f0d1b, 0xbf124d7f, 0xbeb69994,
    0xbf12b836, 0x3e0ee42b, 0x3d168af0, 0xbe77cbd7,
    0xbe78b950, 0x3f3e8b58, 0x3d0ca480, 0xbe46860b,
    0xbd13b3f9, 0xbeace23d, 0x3e60caf6, 0x3e32f961,
    0xbdfb849c, 0xbd3a184f, 0x3cf9cb38, 0x3e0b00d0,
    0x3ee38cd8, 0xbe71e59a, 0xbe4ebd8c, 0xbf1ffa83,
    0xbe5bce06, 0x3e499325, 0x3ebe1b62, 0xbe62096f,
    0x3dfcdc50, 0x3e8e863e, 0xbc8c4e2a, 0xbe5e7b1d,
    0x0
    };

static const uint32_t in_rfft_noisy_128[128] = {
    0xbdbd368f, 0x3eebf106, 0x3f2b741d, 0x3efc7b9f,
    0x3c51d234, 0xbf0b44ab, 0xbf3a97bc, 0xbf05c339,
    0xbc328410, 0x3f05d6bf, 0x3f20bf6b, 0x3f04b884,
    0xbcf53688, 0xbee282c8, 0xbf2bde70, 0xbf0d5087,
    0xbcb04179, 0x3f0ce964, 0x3f356493, 0x3ee4bea0,
    0x3d868b61, 0xbedc47fd, 0xbf39248b, 0xbf05abbf,
    0x3c2ee797, 0x3f03bd93, 0x3f336fde, 0x3ee862a7,
    0x3d226842, 0xbef3f140, 0xbf22aee5, 0xbeff9a2e,
    0x3d8a2816, 0x3ed8574e, 0x3f2f6bb0, 0x3ede3ce9,
    0xbc06e5f0, 0xbef57165, 0xbf17bcbd, 0xbefc6bc8,
    0x3d337e26, 0x3f004c05, 0x3f21c62c, 0x3eefa7e6,
    0x3bf9f8af, 0xbf09eaae, 0xbf20c4f2, 0xbee400e5,
    0xbd02780d, 0x3f0c6613, 0x3f37aa91, 0x3f065369,
    0xbc5f44f9, 0xbf0cbbab, 0xbf24fcff, 0xbf0251c7,
    0x3d145e92, 0x3ed11df9, 0x3f4089f7, 0x3ee0f6c6,
    0xbd1c66cf, 0xbed7a801, 0xbf49cb71, 0xbf12c21d,
    0xbd9cc727, 0x3f0bb03a, 0x3f36c171, 0x3eeb9dc1,
    0x3b5b11e9, 0xbef57a8a, 0xbf50f6b9, 0xbeee1030,
    0xbc3e2b39, 0x3eef99a3, 0x3f2a0c2f, 0x3efb90ca,
    0xbc85e600, 0xbeed9abb, 0xbf449d6f, 0xbf15c821,
    0x3db2c19d, 0x3ee08edd, 0x3f4e2d87, 0x3ef0f665,
    0xbcf3e53f, 0xbf001dbf, 0xbf1ea430, 0xbf080db5,
    0x3d52e413, 0x3f10495e, 0x3f405c6b, 0x3f06c607,
    0xba8e4c70, 0xbf01b03e, 0xbf3b8c1c, 0xbef8810c,
    0xbd219771, 0x3ee1812d, 0x3f2d06fe, 0x3f0f0ccc,
    0x3ce86ad8, 0xbf076316, 0xbf2a9713, 0xbf098644,
    0xbd287f02, 0x3f017068, 0x3f386594, 0x3ef79f92,
    0x3d882298, 0xbed4ebee, 0xbf2dad35, 0xbf074941,
    0x3d3e735a, 0x3f082389, 0x3f482a8d, 0x3f0bca51,
    0xbcfd072a, 0xbef1d083, 0xbf391604, 0xbeec3057,
    0xbbd3b56e, 0x3edce8d3, 0x3f2e6780, 0x3f013371,
    0x3d717ced, 0xbefd69e2, 0xbf346f00, 0xbf0a81df
    };

static const uint32_t in_rifft_noisy_128[129] = {
    0xbce9a4e9, 0x3f1d5031, 0x3e4d1101, 0x3d83920f,
    0xbf57c91d, 0x3eb5fc75, 0xbd45ffc6, 0x3e174ec3,
    0xbf4b8e2e, 0x3eedf93b, 0xbeb3e34f, 0xbe376b39,
    0x3def7961, 0xbed105bf, 0x3e35f057, 0x3ebbe645,
    0xbd882be2, 0xbd9f5e32, 0x3db80ae1, 0x3e029eca,
    0x3e0c94f0, 0x3e3f7d71, 0xbeb2e186, 0x3e43928a,
    0xbf0b6875, 0x3dbe691f, 0x3f07ac58, 0x3e193b83,
    0x3d1492ff, 0xbec062e9, 0xbf8b2b54, 0x3ebc1519,
    0xbedff826, 0xc23337b0, 0x3e7916ae, 0xbe14a579,
    0xbefd827f, 0xbeb898c3, 0x3e327ee1, 0x3e9664e0,
    0xbdcfc43a, 0x3e63ecd4, 0xbe9c7bf2, 0xbe1fd753,
    0xbf0da7fe, 0xbed67b0a, 0xbe7b9834, 0x3e213412,
    0xbf092cbf, 0xbf07a077, 0x3d7f1a94, 0x3df9852f,
    0xbe3aff3c, 0xbf22fe7d, 0x3edd0545, 0x3e0a9dfc,
    0x3de980e0, 0x3f02acc3, 0xbe971cf7, 0x3e87bc3e,
    0x3f08d015, 0x3e81edb4, 0x3e9d99ea, 0x3da00c96,
    0xbd2449ef, 0xbf0a78f9, 0xbdc7706a, 0xbcff0482,
    0xbeb00b6d, 0xbea6d5e4, 0xbd38c17c, 0x3f5a1e2c,
    0x3e175999, 0xbcb02905, 0xbdc589bd, 0x3f211e1a,
    0xbd5d37eb, 0xbf471bdf, 0x3dec355d, 0xbec116d1,
    0x3da17ec2, 0x3d2c88de, 0xbea41f73, 0x3ee1678e,
    0xbea398c0, 0xbef9c8e7, 0xbe907b3d, 0x3f09723f,
    0x3defa0d8, 0xbd3dd1e4, 0x3f1187a0, 0xbf3c6749,
    0xbe6f84d3, 0x3f0e2c77, 0x3d9cb4cc, 0xbf09a434,
    0x3e6c70fb, 0x3c78031b, 0xbee5a428, 0xbd9a28b9,
    0x3e05180a, 0x3e414faa, 0xbee6d1c4, 0xbe39d0b1,
    0xbf128bce, 0x3e9e1d03, 0xbe345c5d, 0xbf16ca5a,
    0xbf191dfa, 0x3ed41e0f, 0x3ea040f7, 0xbe4bada6,
    0xbbe6911e, 0x3e8331f4, 0x3e51514a, 0xbda139d6,
    0x3e507201, 0xbf1f0b49, 0x3ebf7349, 0x3f70ffe8,
    0xbe0b3f86, 0xbef3e206, 0x3ed397c4, 0xbe971871,
    0xbf2fad6a, 0xbe00c5ed, 0xbe416cd3, 0x3e2472ea,
    0x0
    };

static const uint32_t ref_rfft_noisy_128[129] = {
    0xbce9a4e9, 0x3f1d5031, 0x3e4d1101, 0x3d83920f,
    0xbf57c91d, 0x3eb5fc75, 0xbd45ffc6, 0x3e174ec3,
    0xbf4b8e2e, 0x3eedf93b, 0xbeb3e34f, 0xbe376b39,
    0x3def7961, 0xbed105bf, 0x3e35f057, 0x3ebbe645,
    0xbd882be2, 0xbd9f5e32, 0x3db80ae1, 0x3e029eca,
    0x3e0c94f0, 0x3e3f7d71, 0xbeb2e186, 0x3e43928a,
    0xbf0b6875, 0x3dbe691f, 0x3f07ac58, 0x3e193b83,
    0x3d1492ff, 0xbec062e9, 0xbf8b2b54, 0x3ebc1519,
    0xbedff826, 0xc23337b0, 0x3e7916ae, 0xbe14a579,
    0xbefd827f, 0xbeb898c3, 0x3e327ee1, 0x3e9664e0,
    0xbdcfc43a, 0x3e63ecd4, 0xbe9c7bf2, 0xbe1fd753,
    0xbf0da7fe, 0xbed67b0a, 0xbe7b9834, 0x3e213412,
    0xbf092cbf, 0xbf07a077, 0x3d7f1a94, 0x3df9852f,
    0xbe3aff3c, 0xbf22fe7d, 0x3edd0545, 0x3e0a9dfc,
    0x3de980e0, 0x3f02acc3, 0xbe971cf7, 0x3e87bc3e,
    0x3f08d015, 0x3e81edb4, 0x3e9d99ea, 0x3da00c96,
    0xbd2449ef, 0xbf0a78f9, 0xbdc7706a, 0xbcff0482,
    0xbeb00b6d, 0xbea6d5e4, 0xbd38c17c, 0x3f5a1e2c,
    0x3e175999, 0xbcb02905, 0xbdc589bd, 0x3f211e1a,
    0xbd5d37eb, 0xbf471bdf, 0x3dec355d, 0xbec116d1,
    0x3da17ec2, 0x3d2c88de, 0xbea41f73, 0x3ee1678e,
    0xbea398c0, 0xbef9c8e7, 0xbe907b3d, 0x3f09723f,
    0x3defa0d8, 0xbd3dd1e4, 0x3f1187a0, 0xbf3c6749,
    0xbe6f84d3, 0x3f0e2c77, 0x3d9cb4cc, 0xbf09a434,
    0x3e6c70fb, 0x3c78031b, 0xbee5a428, 0xbd9a28b9,
    0x3e05180a, 0x3e414faa, 0xbee6d1c4, 0xbe39d0b1,
    0xbf128bce, 0x3e9e1d03, 0xbe345c5d, 0xbf16ca5a,
    0xbf191dfa, 0x3ed41e0f, 0x3ea040f7, 0xbe4bada6,
    0xbbe6911e, 0x3e8331f4, 0x3e51514a, 0xbda139d6,
    0x3e507201, 0xbf1f0b49, 0x3ebf7349, 0x3f70ffe8,
    0xbe0b3f86, 0xbef3e206, 0x3ed397c4, 0xbe971871,
    0xbf2fad6a, 0xbe00c5ed, 0xbe416cd3, 0x3e2472ea,
    0x0
    };

static const uint32_t in_rfft_noisy_256[256] = {
    0x3d906447, 0x3eb24ce8, 0x3f2b3b4d, 0x3ef5f70c,
    0xbd3e9dca, 0xbf0e4749, 0xbf3cc461, 0xbee176bf,
    0x3c70095b, 0x3ed7916b, 0x3f3e5a03, 0x3ed78a39,
    0xbd15b090, 0xbed937b0, 0xbf448538, 0xbeef332d,
    0x3d5a7254, 0x3ef1e2db, 0x3f20367b, 0x3ecef0cf,
    0x3caecc9c, 0xbf01f63e, 0xbf32328f, 0xbef24eed,
    0x3d43b4b4, 0x3ef46fdd, 0x3f274722, 0x3ef39284,
    0xbc9b1f46, 0xbee590fc, 0xbf30799f, 0xbf03f42b,
    0xbcb72eea, 0x3ef2f0a9, 0x3f2f30d5, 0x3ef0a5a2,
    0x3cd89d4f, 0xbf0a233d, 0xbf2bd6bf, 0xbee36a3a,
    0x3cf29a83, 0x3ee99947, 0x3f2b61ab, 0x3edb3722,
    0xbcb6d806, 0xbf0da710, 0xbf32bcfc, 0xbef86e6b,
    0xbcee20c5, 0x3ef95f1f, 0x3f1f66e2, 0x3f06ba54,
    0xbcb202de, 0xbefef77d, 0xbf314ff3, 0xbeee5875,
    0x3d85b084, 0x3ecada6b, 0x3f31ae60, 0x3eec5280,
    0xbd4ef0c6, 0xbededf08, 0xbf148967, 0xbefe1f8e,
    0xbb39484b, 0x3ee17d74, 0x3f34c3aa, 0x3f0534cc,
    0x3d3c04cc, 0xbf0aa45a, 0xbf2b6026, 0xbed62a39,
    0xbd0d03ce, 0x3eea115b, 0x3f321ce5, 0x3f04a46d,
    0x3d6eee17, 0xbefc3595, 0xbf335d82, 0xbef422e8,
    0x3d54a596, 0x3f06002d, 0x3f47c32b, 0x3edfa0b0,
    0xbc8f19c0, 0xbef08299, 0xbf2ff7c6, 0xbefe4b6d,
    0xbd66444e, 0x3f0f4355, 0x3f3a0a22, 0x3f151c8f,
    0x3db9474d, 0xbf0daeef, 0xbf3b5c15, 0xbed429e5,
    0x3d6c09e8, 0x3f0d2cdb, 0x3f0e028f, 0x3f058f81,
    0xbd963d83, 0xbf0c60f6, 0xbf455a8a, 0xbeecdcc9,
    0x3d32ef73, 0x3eeb249b, 0x3f406bbe, 0x3f056767,
    0x3b618be9, 0xbef043cc, 0xbf317c0e, 0xbf05f1f8,
    0xbd7406d5, 0x3edad46b, 0x3f280209, 0x3f17d255,
    0x3d0f01a7, 0xbef5abe7, 0xbf39cdba, 0xbeee59d5,
    0xbbcda07e, 0x3f06cf22, 0x3f3167d2, 0x3efa323b,
    0xbc25b306, 0xbf09d37b, 0xbf3c27e0, 0xbf088367,
    0xbccaa871, 0x3edf1652, 0x3f265ee2, 0x3f006248,
    0xbd8c15e4, 0xbf0a4276, 0xbf1fdc87, 0xbf03e4e7,
    0xbd516bf9, 0x3f063ff8, 0x3f29b0b0, 0x3ee2d71e,
    0xbc3cb1dd, 0xbef80e28, 0xbf3a2a07, 0xbf122944,
    0x3b33427d, 0x3ed26671, 0x3f414de4, 0x3eeacaff,
    0xbdb1bcff, 0xbed241fe, 0xbf390fe9, 0xbef61366,
    0xbca47df2, 0x3f009db7, 0x3f2ebcfd, 0x3efb359b,
    0xbd48fde6, 0xbf0e0553, 0xbf4cdd50, 0xbf078de0,
    0xbdafd840, 0x3eec205d, 0x3f365aaf, 0x3ef5fb87,
    0xbd3b8884, 0xbf033ed5, 0xbf308feb, 0xbf112481,
    0x3d635de1, 0x3f022715, 0x3f2faca7, 0x3ef5ee0e,
    0xbbca3aff, 0xbeed6baa, 0xbf2c7493, 0xbeb7efd3,
    0x3cec3445, 0x3f07964f, 0x3f3742eb, 0x3ef04cb2,
    0xbd6b39d9, 0xbf0e64fc, 0xbf40d51f, 0xbf0efd52,
    0xbd375b07, 0x3f0b8a47, 0x3f31dee3, 0x3ee23846,
    0x3d0cd6ad, 0xbef6c27c, 0xbf3c0f68, 0xbee67d2d,
    0xbce25107, 0x3f005079, 0x3f362f4b, 0x3ef73748,
    0x3d37fb9e, 0xbf12b80a, 0xbf2b1ea3, 0xbef71c80,
    0xbc884553, 0x3f0c4097, 0x3f2759c2, 0x3ee622a8,
    0x3c7bc2b0, 0xbed88850, 0xbf4060fa, 0xbf0197e5,
    0x3d9d24bf, 0x3f050d31, 0x3f251809, 0x3ef5ea62,
    0x3d809130, 0xbf10ef53, 0xbf2af1ee, 0xbf00ab76,
    0x3d438c46, 0x3ef3c727, 0x3f49debc, 0x3f0b81af,
    0xba729362, 0xbf10d0c3, 0xbf2d0b74, 0xbf0d7543,
    0x3cfffbc0, 0x3eef56c1, 0x3f2a2238, 0x3ef79ab9,
    0xbb5bcf8b, 0xbefb0f42, 0xbf30e4f1, 0xbedf723a,
    0x3cc27f13, 0x3ed958d2, 0x3f34f6eb, 0x3ee9ab70,
    0x3d91e846, 0xbf02c70a, 0xbf326d04, 0xbf1a5c52,
    0xbd8297ff, 0x3eeef9b9, 0x3f4b693e, 0x3ef8deac,
    0x3d98a8b5, 0xbefccb98, 0xbf33d030, 0xbef0b048,
    0xbd58e92e, 0x3f07d13b, 0x3f2fd1e0, 0x3f053c98,
    0xbcea081e, 0xbee3e195, 0xbf2d84ef, 0xbed1eb86
    };

static const uint32_t in_rifft_noisy_256[257] = {
    0xbf97ea11, 0x3f03f43f, 0x3eb7bbe5, 0xbed8fd87,
    0xbf660d00, 0x3fa46a25, 0x3f0e628f, 0xbe1330c7,
    0x3d47a0a2, 0xbda08186, 0xbea7e95f, 0xbd9f5881,
    0x3eaed987, 0x3edded38, 0x3e67595c, 0x3f266614,
    0xbed6db3b, 0x3ee671e3, 0x3f62ba4b, 0xbe933b39,
    0xbf1452fa, 0x3f34bd43, 0xbec2fef6, 0xbe034f03,
    0x3edb0244, 0xbda9778e, 0x3d1a7b51, 0x3f91c9eb,
    0xbedd8350, 0xbd4724d9, 0x3e02d67e, 0xbe0026c2,
    0xbf0cdaf9, 0x3f132b2e, 0x3e3373f4, 0xbd6d61f1,
    0xbf995d79, 0xbe5160bb, 0x3fc6135d, 0x3ecdf090,
    0x3f26b300, 0x3d09039c, 0xbd3a6881, 0x3e595b30,
    0x3f8f917c, 0xbd4d2d5c, 0xbee17687, 0x3f564444,
    0xbea68f9a, 0x3eb33292, 0x3ea4f3fd, 0xbe36cdb2,
    0x3eb569b5, 0x3f299f28, 0xbdfe0fb9, 0x3e49245f,
    0xbe9c48b4, 0x3f5afa19, 0x3e8e738a, 0x3e90fecb,
    0xbf7fd0d6, 0x3efd1c74, 0xbf1601a3, 0x3f21631b,
    0x3edda115, 0xc2b1bf02, 0x3f4eecbe, 0x3f3e4bc4,
    0x3e89d476, 0xbeec1099, 0x3e0f7912, 0xbf55c2d7,
    0xbe2ab505, 0x3e5c6311, 0x3ef7a250, 0xbd67ead7,
    0x3f569d4e, 0xbf8787e1, 0xbed0ebd3, 0x3d8f4d22,
    0x3f31ca03, 0xbe383023, 0x3d88d320, 0x3f2115ee,
    0x3f03d70d, 0x3f7c39b6, 0xbf1dbbe5, 0x3e2ff6d5,
    0xbe5bc7cc, 0x3f93ef28, 0xbd64209f, 0x3e315045,
    0xbe0e926c, 0xbed32b0d, 0xbe180fd1, 0xbc214f86,
    0xbebc9bef, 0xbe22626e, 0xbeac3999, 0xbd1aaab9,
    0x3e21cb3b, 0x3f18a4a8, 0x3f5dc136, 0xbbe9f471,
    0xbf959dde, 0xbedb3ad4, 0x3eea6b1c, 0x3f1d4159,
    0x3f649f9a, 0xbe817e85, 0xbeb733b0, 0x3d8fe5d5,
    0xbef63927, 0x3f6da036, 0xbf0c724b, 0x3ef730e8,
    0xbe49200d, 0x3ebd7ef4, 0xbe8edba1, 0x3f0ca731,
    0x3dbc65e1, 0x3eab1dde, 0xbd82efc2, 0x3f6cbb4a,
    0x3eb6e040, 0xbe63945d, 0xbe921367, 0x3e3aa857,
    0x3ecbc46e, 0x3f3e67fd, 0x3f7d706b, 0x3d5960e9,
    0xbf0b5863, 0x3edec7ea, 0xbe28ba95, 0xbf4d0328,
    0xbf4fd6f0, 0xbd6e7ebc, 0x3f45c304, 0x3e43217a,
    0x3e788595, 0x3e53645d, 0xbe5f3701, 0x3f132a25,
    0x3e354f4d, 0x3f2f41ee, 0xbe6e64f2, 0xbeb2de02,
    0x3e464a1b, 0x3f444e55, 0x3f8bb60b, 0xbdc9ac81,
    0x3f197829, 0x3f43262d, 0xbeafd6ec, 0x3f9720ea,
    0xbe7eb6ae, 0xbe08d280, 0x3f5deb6b, 0xbf76e764,
    0x3f7705d1, 0x3ce0d29e, 0xbee5f98d, 0xbf45532f,
    0x3f32fce7, 0x3ebc867a, 0xbebf6b42, 0x3d844feb,
    0x3f6afe68, 0xbea23793, 0xbf0e74ec, 0xbe94698b,
    0x3e154099, 0x3ec9de0c, 0x3ea88b53, 0x3dc11c42,
    0xbd3c5425, 0xbf233843, 0xbe9f40a7, 0x3e08d249,
    0xbde4eeb5, 0x3d1b4300, 0x3ea6da5f, 0x3f8183b9,
    0xbecd24fc, 0x3e87a568, 0xbe0387db, 0x3eac2bd1,
    0x3e1c88cd, 0x3f4086f5, 0xbd2cacca, 0x3f291f09,
    0xbdad7653, 0x3ed36538, 0xbdc3e4be, 0x3e80de52,
    0x3f795649, 0x3d93ed81, 0xbe7fba5b, 0x3f8f357f,
    0x3e0e3809, 0x3e1b6810, 0x3f2739f1, 0xbf313e28,
    0xbdb10059, 0xbf658cc8, 0x3f56851f, 0x3f21ef5b,
    0x3da80b44, 0xbf045df4, 0x3f8de524, 0x3d99a319,
    0x3f3bfe78, 0xbe57d7f1, 0xbdfad457, 0xbf50ea8c,
    0xbe82ead5, 0x3f77480b, 0xbd8d2d9f, 0xbee6ede3,
    0x3de31ed8, 0xbefe39d4, 0x3edcabaa, 0x3efd2cb2,
    0xb78c7854, 0x3e2aa492, 0xbeefc020, 0x3ed92cca,
    0x3f7a8031, 0x3e01bc46, 0x3eea40cb, 0x3f7c8302,
    0x3f80c6c3, 0x3c83b023, 0xbeaff232, 0x3f0ee880,
    0xbf78a362, 0x3f536067, 0x3d1b6451, 0xbe53710a,
    0xbe5002b6, 0x3ef242dc, 0x3e26d550, 0xbdab7943,
    0xbacff9d9, 0x3c0dda90, 0xbf2868c9, 0x3e894f5b,
    0xbb7762ee, 0x3e58e210, 0xbf0eb899, 0xbf5d41a3,
    0xbe6ed67a, 0xbe984170, 0x3f8a5110, 0xbe23d93a,
    0x0
    };

static const uint32_t ref_rfft_noisy_256[257] = {
    0xbf97ea11, 0x3f03f43f, 0x3eb7bbe5, 0xbed8fd87,
    0xbf660d00, 0x3fa46a25, 0x3f0e628f, 0xbe1330c7,
    0x3d47a0a2, 0xbda08186, 0xbea7e95f, 0xbd9f5881,
    0x3eaed987, 0x3edded38, 0x3e67595c, 0x3f266614,
    0xbed6db3b, 0x3ee671e3, 0x3f62ba4b, 0xbe933b39,
    0xbf1452fa, 0x3f34bd43, 0xbec2fef6, 0xbe034f03,
    0x3edb0244, 0xbda9778e, 0x3d1a7b51, 0x3f91c9eb,
    0xbedd8350, 0xbd4724d9, 0x3e02d67e, 0xbe0026c2,
    0xbf0cdaf9, 0x3f132b2e, 0x3e3373f4, 0xbd6d61f1,
    0xbf995d79, 0xbe5160bb, 0x3fc6135d, 0x3ecdf090,
    0x3f26b300, 0x3d09039c, 0xbd3a6881, 0x3e595b30,
    0x3f8f917c, 0xbd4d2d5c, 0xbee17687, 0x3f564444,
    0xbea68f9a, 0x3eb33292, 0x3ea4f3fd, 0xbe36cdb2,
    0x3eb569b5, 0x3f299f28, 0xbdfe0fb9, 0x3e49245f,
    0xbe9c48b4, 0x3f5afa19, 0x3e8e738a, 0x3e90fecb,
    0xbf7fd0d6, 0x3efd1c74, 0xbf1601a3, 0x3f21631b,
    0x3edda115, 0xc2b1bf02, 0x3f4eecbe, 0x3f3e4bc4,
    0x3e89d476, 0xbeec1099, 0x3e0f7912, 0xbf55c2d7,
    0xbe2ab505, 0x3e5c6311, 0x3ef7a250, 0xbd67ead7,
    0x3f569d4e, 0xbf8787e1, 0xbed0ebd3, 0x3d8f4d22,
    0x3f31ca03, 0xbe383023, 0x3d88d320, 0x3f2115ee,
    0x3f03d70d, 0x3f7c39b6, 0xbf1dbbe5, 0x3e2ff6d5,
    0xbe5bc7cc, 0x3f93ef28, 0xbd64209f, 0x3e315045,
    0xbe0e926c, 0xbed32b0d, 0xbe180fd1, 0xbc214f86,
    0xbebc9bef, 0xbe22626e, 0xbeac3999, 0xbd1aaab9,
    0x3e21cb3b, 0x3f18a4a8, 0x3f5dc136, 0xbbe9f471,
    0xbf959dde, 0xbedb3ad4, 0x3eea6b1c, 0x3f1d4159,
    0x3f649f9a, 0xbe817e85, 0xbeb733b0, 0x3d8fe5d5,
    0xbef63927, 0x3f6da036, 0xbf0c724b, 0x3ef730e8,
    0xbe49200d, 0x3ebd7ef4, 0xbe8edba1, 0x3f0ca731,
    0x3dbc65e1, 0x3eab1dde, 0xbd82efc2, 0x3f6cbb4a,
    0x3eb6e040, 0xbe63945d, 0xbe921367, 0x3e3aa857,
    0x3ecbc46e, 0x3f3e67fd, 0x3f7d706b, 0x3d5960e9,
    0xbf0b5863, 0x3edec7ea, 0xbe28ba95, 0xbf4d0328,
    0xbf4fd6f0, 0xbd6e7ebc, 0x3f45c304, 0x3e43217a,
    0x3e788595, 0x3e53645d, 0xbe5f3701, 0x3f132a25,
    0x3e354f4d, 0x3f2f41ee, 0xbe6e64f2, 0xbeb2de02,
    0x3e464a1b, 0x3f444e55, 0x3f8bb60b, 0xbdc9ac81,
    0x3f197829, 0x3f43262d, 0xbeafd6ec, 0x3f9720ea,
    0xbe7eb6ae, 0xbe08d280, 0x3f5deb6b, 0xbf76e764,
    0x3f7705d1, 0x3ce0d29e, 0xbee5f98d, 0xbf45532f,
    0x3f32fce7, 0x3ebc867a, 0xbebf6b42, 0x3d844feb,
    0x3f6afe68, 0xbea23793, 0xbf0e74ec, 0xbe94698b,
    0x3e154099, 0x3ec9de0c, 0x3ea88b53, 0x3dc11c42,
    0xbd3c5425, 0xbf233843, 0xbe9f40a7, 0x3e08d249,
    0xbde4eeb5, 0x3d1b4300, 0x3ea6da5f, 0x3f8183b9,
    0xbecd24fc, 0x3e87a568, 0xbe0387db, 0x3eac2bd1,
    0x3e1c88cd, 0x3f4086f5, 0xbd2cacca, 0x3f291f09,
    0xbdad7653, 0x3ed36538, 0xbdc3e4be, 0x3e80de52,
    0x3f795649, 0x3d93ed81, 0xbe7fba5b, 0x3f8f357f,
    0x3e0e3809, 0x3e1b6810, 0x3f2739f1, 0xbf313e28,
    0xbdb10059, 0xbf658cc8, 0x3f56851f, 0x3f21ef5b,
    0x3da80b44, 0xbf045df4, 0x3f8de524, 0x3d99a319,
    0x3f3bfe78, 0xbe57d7f1, 0xbdfad457, 0xbf50ea8c,
    0xbe82ead5, 0x3f77480b, 0xbd8d2d9f, 0xbee6ede3,
    0x3de31ed8, 0xbefe39d4, 0x3edcabaa, 0x3efd2cb2,
    0xb78c7854, 0x3e2aa492, 0xbeefc020, 0x3ed92cca,
    0x3f7a8031, 0x3e01bc46, 0x3eea40cb, 0x3f7c8302,
    0x3f80c6c3, 0x3c83b023, 0xbeaff232, 0x3f0ee880,
    0xbf78a362, 0x3f536067, 0x3d1b6451, 0xbe53710a,
    0xbe5002b6, 0x3ef242dc, 0x3e26d550, 0xbdab7943,
    0xbacff9d9, 0x3c0dda90, 0xbf2868c9, 0x3e894f5b,
    0xbb7762ee, 0x3e58e210, 0xbf0eb899, 0xbf5d41a3,
    0xbe6ed67a, 0xbe984170, 0x3f8a5110, 0xbe23d93a,
    0x0
    };

static const uint32_t in_rfft_noisy_512[512] = {
    0xbb42d535, 0x3ef2a3a1, 0x3f31b8f2, 0x3ee219e2,
    0x3d77a1b4, 0xbef239da, 0xbf3dd5c2, 0xbf03a824,
    0xbc838497, 0x3f16f1db, 0x3f4cc874, 0x3eda04ce,
    0x3db1b793, 0xbecae3bc, 0xbf3c4efe, 0xbee99ce6,
    0xbd5b00ef, 0x3ef94749, 0x3f366ac1, 0x3ef6ee12,
    0x3c8e4f84, 0xbf07ad34, 0xbf4813d8, 0xbee8676c,
    0xbb3a956e, 0x3ed8f854, 0x3f37c187, 0x3ef3ccc4,
    0x3d5f666d, 0xbef0eb74, 0xbf41dc5f, 0xbeb90fba,
    0xbc4e15b1, 0x3f0634ab, 0x3f4b0a67, 0x3ef271ec,
    0x3d1bf2c5, 0xbf023d4c, 0xbf378f10, 0xbef75f13,
    0xbd91bfa5, 0x3ee1234b, 0x3f425d0a, 0x3ee5e93b,
    0xbd1cbebc, 0xbee626ec, 0xbf26cd92, 0xbf06a84b,
    0x3c99d94b, 0x3f15f18a, 0x3f3749cf, 0x3ec97a83,
    0xbd3c1e2c, 0xbefc91ad, 0xbf2b354e, 0xbef9aa74,
    0x3b8cb171, 0x3f00a409, 0x3f2a5a29, 0x3f014780,
    0xbc2f819f, 0xbf0e14ad, 0xbf27139e, 0xbec9d0c6,
    0x3d27e3e5, 0x3eff2716, 0x3f35651b, 0x3f061aa9,
    0x3c54905f, 0xbee45040, 0xbf3c9e63, 0xbef58b5f,
    0xbd36ab46, 0x3ee5f8ae, 0x3f36c3be, 0x3eff090c,
    0x3c9388e8, 0xbefeb334, 0xbf2cb297, 0xbf045ebe,
    0x3cf9a9ee, 0x3f07581e, 0x3f30f740, 0x3f134f19,
    0x3d475399, 0xbeebd5f1, 0xbf329821, 0xbeff9d38,
    0x3d8d8969, 0x3f06f08a, 0x3f2b3769, 0x3efe2e4d,
    0xbd8524cb, 0xbf0ccb5b, 0xbf3014ed, 0xbef4e924,
    0x3d413e78, 0x3ef63be0, 0x3f31b6a3, 0x3ef81d7c,
    0x3bd08078, 0xbef1f2be, 0xbf4365b3, 0xbf038ace,
    0xbc8f2bad, 0x3ef8659c, 0x3f366bca, 0x3edb8609,
    0xbcece626, 0xbf00fabe, 0xbf348ab0, 0xbef3d57e,
    0x3d0ce76d, 0x3f03570f, 0x3f399a88, 0x3ee5a663,
    0x3d17c909, 0xbedaafa0, 0xbf36eeb9, 0xbf103b7a,
    0x3c024c4c, 0x3f0a2231, 0x3f3a212c, 0x3ee580ff,
    0xbd536427, 0xbef956e0, 0xbf1aba35, 0xbf061716,
    0xbc075c91, 0x3f101921, 0x3f2a4494, 0x3eeff761,
    0x3b43c80c, 0xbf045c49, 0xbf241554, 0xbf0ea6b1,
    0xbd8d21ac, 0x3f111029, 0x3f314054, 0x3f0a1ba5,
    0x3c195e22, 0xbed4ca3c, 0xbf373744, 0xbee91a9f,
    0x3c769b19, 0x3eefb621, 0x3f33f4f5, 0x3f02bccb,
    0x3bd8b85e, 0xbf04764d, 0xbf4581b1, 0xbf157a9d,
    0xbc355618, 0x3ef34ace, 0x3f32e0fa, 0x3eecc5c2,
    0x3d96851d, 0xbee11178, 0xbf4273d9, 0xbefbc957,
    0x3d8cfd25, 0x3f04f9ab, 0x3f2ad0a6, 0x3eddf451,
    0xbcd1f67e, 0xbf1b9454, 0xbf2619e9, 0xbefcd0b0,
    0x3d1064aa, 0x3ef4ae79, 0x3f337cb6, 0x3f01b5b1,
    0xbd33c1dc, 0xbef2c9d0, 0xbf28f480, 0xbf084e44,
    0xbd02682d, 0x3efcd676, 0x3f3dad8d, 0x3f017586,
    0xbdb28ac5, 0xbee29e46, 0xbf235ad2, 0xbf03d936,
    0x3c4d93bf, 0x3f075c98, 0x3f4a4bd0, 0x3f0588cf,
    0x3a86adc5, 0xbf036205, 0xbf27403b, 0xbef9434e,
    0x3c7867e9, 0x3f118292, 0x3f3bc2e6, 0x3f03cdc3,
    0x3bf6039a, 0xbecff731, 0xbf3acdf1, 0xbeeff31b,
    0x3d36219b, 0x3f1300ef, 0x3f2f7be9, 0x3efdf021,
    0x3cc19632, 0xbf0bb70c, 0xbf41fc38, 0xbf1235a7,
    0xbcb66e3e, 0x3ede5dd0, 0x3f224b73, 0x3ef472c0,
    0x3d3c2332, 0xbef385d5, 0xbf3083f6, 0xbee0e4e0,
    0x3c7ce6be, 0x3f0359af, 0x3f38cdd7, 0x3f23f870,
    0x3c0056e1, 0xbeca27bc, 0xbf25ff8f, 0xbf0839f5,
    0x3d72516b, 0x3ef9c0c8, 0x3f47583a, 0x3f018185,
    0xbac79972, 0xbeeebdc6, 0xbf42413b, 0xbf07ac2e,
    0x3d14a170, 0x3f07515a, 0x3f4862d3, 0x3f02284a,
    0x3d9d62f3, 0xbee83934, 0xbf3710bd, 0xbed006e7,
    0xbd192e5e, 0x3f073b85, 0x3f452fc0, 0x3eeabc18,
    0x3ce05dc0, 0xbef97626, 0xbf302b3f, 0xbf02064b,
    0xbc8dbe30, 0x3f0438a8, 0x3f32c18b, 0x3efa98a8,
    0x3c3f3863, 0xbef10582, 0xbf2821f1, 0xbef61150,
    0xbd256e60, 0x3f004258, 0x3f404025, 0x3f0084de,
    0xbcd7bd9f, 0xbf08f9cb, 0xbf2d4bb3, 0xbf0cdbc0,
    0x3daf7a0b, 0x3ef9d39a, 0x3f2cf37e, 0x3ee92214,
    0x3cae20b8, 0xbee336eb, 0xbf3e19b9, 0xbf01ffc8,
    0x3c76e470, 0x3ecae61b, 0x3f151573, 0x3f016a46,
    0xbda5d390, 0xbee2af82, 0xbf2b20e5, 0xbefc14de,
    0x3d832e96, 0x3ef391c0, 0x3f16fa45, 0x3f09bf61,
    0x3a87872f, 0xbeed0738, 0xbf25a48d, 0xbee5135c,
    0xbced6599, 0x3ef7f761, 0x3f375b48, 0x3ef0dd6e,
    0xbc2bd65c, 0xbf05c14f, 0xbf2cd1ea, 0xbee33ed4,
    0xbbdbb7e7, 0x3ee79d16, 0x3f23ccc2, 0x3f09d276,
    0xbcf3411f, 0xbf08baf7, 0xbf409cb2, 0xbee22d58,
    0xbb952899, 0x3f1c7111, 0x3f444e69, 0x3efcb33a,
    0x3d28b254, 0xbf068b57, 0xbf28c43b, 0xbf01361b,
    0x3d346d6c, 0x3ee6be37, 0x3f2b68a4, 0x3edb0c78,
    0x3d06b270, 0xbed4dc00, 0xbf3a21df, 0xbf06e85b,
    0xbd997b7d, 0x3ef9cc23, 0x3f18e039, 0x3ef88fc3,
    0x3dcc2531, 0xbeea51e4, 0xbf376910, 0xbee89856,
    0x3c2781ec, 0x3eee5fa7, 0x3f164501, 0x3f059fa6,
    0x3d270d97, 0xbf027d4e, 0xbf316bb8, 0xbf14f461,
    0x3d8a006f, 0x3eda3d50, 0x3f43c41c, 0x3ee34a20,
    0x3c65b103, 0xbef78385, 0xbf3e1bbc, 0xbf116ac0,
    0x3e06b12d, 0x3f00e53f, 0x3f309e75, 0x3eca1c3a,
    0x3d1863b6, 0xbed479d2, 0xbf48c09b, 0xbef6922a,
    0xbd9c3d85, 0x3ef747fc, 0x3f3785ea, 0x3f1e11f0,
    0x3d33ee02, 0xbf0bcf07, 0xbf502955, 0xbf07bbbe,
    0x3d90bb5e, 0x3eddaf38, 0x3f4c1af4, 0x3edce7cf,
    0xbca36894, 0xbf0e78d6, 0xbf33650d, 0xbf12c0e6,
    0xbc74acc2, 0x3ef3ffef, 0x3f34efdc, 0x3f08876c,
    0x3d20445c, 0xbee57b49, 0xbf33a904, 0xbeeaf9c1,
    0xbc7540cf, 0x3f0b4ddc, 0x3f3fdd2d, 0x3eef9cc8,
    0x3d81686f, 0xbf0be1a8, 0xbf3ae386, 0xbf155a5c,
    0x3d0fe444, 0x3ef4dbf3, 0x3f259a45, 0x3f04a7a1,
    0xbdb5e904, 0xbef7d985, 0xbf3bab4b, 0xbeedaa45,
    0x3c103357, 0x3edeeab0, 0x3f37cddd, 0x3eef4fed,
    0xb979f579, 0xbf041eb0, 0xbf323371, 0xbee6c00e,
    0x3a211120, 0x3f015698, 0x3f34e04e, 0x3ec56afa,
    0xbd6de566, 0xbf0ab760, 0xbf2c009e, 0xbf02785b,
    0xbd191622, 0x3f18e1fc, 0x3f32223d, 0x3f142d16,
    0xbd4d551b, 0xbef86073, 0xbf342ff4, 0xbf00dafe,
    0xbc5effa7, 0x3f008d42, 0x3f1f025f, 0x3f001305,
    0x3d296d54, 0xbeebda36, 0xbf4681a2, 0xbf0122be,
    0xbd90cd8a, 0x3ed1f98d, 0x3f2431a7, 0x3ecf6be6,
    0xbc578093, 0xbf0ad644, 0xbf3735a6, 0xbf0c6cdf,
    0xbd272201, 0x3ed6a14a, 0x3f2ad935, 0x3ef30542,
    0xbbe20849, 0xbf08b721, 0xbf2419a4, 0xbedfffbf,
    0x3d208736, 0x3ee7b809, 0x3f2da9dc, 0x3f17504e,
    0x3cb0cfbe, 0xbf00558a, 0xbf3d0a42, 0xbedccaf9,
    0xbb8f1b95, 0x3ef23fde, 0x3f35e007, 0x3eef49ee,
    0x3bd7a7f5, 0xbeebc91c, 0xbf22bfbf, 0xbee77540,
    0x3d704adc, 0x3f03ca2b, 0x3f2c6c00, 0x3ee57e43,
    0x3c4d5a9f, 0xbf0727e8, 0xbf350be2, 0xbf0b74f9,
    0x3c1756e3, 0x3f0b5214, 0x3f390992, 0x3f0c9895,
    0x3da434cf, 0xbececc11, 0xbf1cf27b, 0xbf079984,
    0xbc5e066e, 0x3efc5c67, 0x3f359702, 0x3f05b8d8,
    0xbd348527, 0xbf01661b, 0xbf390f52, 0xbeff1d6d,
    0x3cfe0fdf, 0x3eff4421, 0x3f3d3346, 0x3ef58e24,
    0xbdc387ca, 0xbeec9f3c, 0xbf2ed30e, 0xbf0c593c,
    0xbde615db, 0x3efd8edb, 0x3f272341, 0x3f1d02d4,
    0xbcd58955, 0xbed1f3c9, 0xbf2bd91d, 0xbed43134,
    0x3d9092e8, 0x3f13f109, 0x3f41cded, 0x3efe31e4,
    0xbdde6406, 0xbef830d6, 0xbf460c89, 0xbee1d14e,
    0xbccf23c8, 0x3f04ecee, 0x3f2833ae, 0x3ef2dad4,
    0x3d3f89a2, 0xbf0613ff, 0xbf27ed6b, 0xbee9947a
    };

static const uint32_t in_rifft_noisy_512[513] = {
    0x3f8dc305, 0xbd48b4b0, 0xbe1c11f2, 0xbfba97ee,
    0x3fdd93b5, 0x3f03fe1f, 0x3e8dc09b, 0xbeecb820,
    0xbedc2c41, 0x3fc00e5f, 0xbdbeb30c, 0x3d6a4608,
    0xbf6bad8e, 0x3e34a23e, 0x3eada1a6, 0xbf84a349,
    0x3f3de3f7, 0xbdc4fc04, 0x3f0bc20c, 0xbfb159b7,
    0xbeab4119, 0x3f8e8e2c, 0x3eff2a87, 0x3f6bcd4d,
    0xbf0e3b0b, 0x3e4f4db9, 0xbf113482, 0x3ed9009e,
    0x3ed03b38, 0xbfb1894b, 0xbd6e2b26, 0x3d94eac4,
    0x3f19898c, 0x3f993fd3, 0xbfa83f04, 0xbe464a71,
    0xbe971726, 0xbcda8980, 0xbf08f356, 0xbffbb670,
    0xbfa79866, 0xbfb3458a, 0xbed2b324, 0xbeebbf96,
    0x3e938b26, 0xbfcb9a3b, 0x3eb31f58, 0x3fa80f34,
    0xbf8fa6ef, 0xbfb219de, 0x3d40b805, 0x3d96c8ce,
    0x3f87fd84, 0xbf78d9cf, 0xbf1b6e09, 0x3da7d3bb,
    0xbeafed65, 0x3feb4f21, 0xbeda04a0, 0xbd9ebf3b,
    0x3f8b763e, 0x3fc69d1e, 0x3ee2ceea, 0x3f42b252,
    0x3f04ea71, 0x3e9f17cf, 0x3fe3ba41, 0xbf9fc7fb,
    0xbe3af148, 0xbea76bd9, 0x3f591b64, 0x3f88b0d5,
    0x3fd0d75e, 0x3f9f8ea9, 0x3da1031d, 0x3e194cf6,
    0xbf7d336b, 0x3ff60ff7, 0xbf26f824, 0x3f28b4cd,
    0xbf19d740, 0x3f609c35, 0xbf682eb4, 0x3f09860d,
    0xbed889ec, 0x3eca8f40, 0xbf4cdaf1, 0xbefdde10,
    0x3e8d9270, 0xbf540eeb, 0x3f2150b8, 0x3f36f6c0,
    0x3f49aeb2, 0x3c811075, 0xbea3efe3, 0x3eb01bde,
    0x3e69f478, 0xbe7c267c, 0xbd2252df, 0xbfc2b43b,
    0x3e929901, 0x3e543927, 0xbf854f7f, 0x3e5c9a40,
    0x3eac619c, 0x3e50b43e, 0xbf2ae2b9, 0x3dedee32,
    0x3e251582, 0xbfd3dfc7, 0x4007c271, 0x3ef89be6,
    0xbe411c22, 0xbdc7abb7, 0xbd803d94, 0xbe8e7de0,
    0xbcf014d0, 0x3e57fbd4, 0x3e9b7f9b, 0xbf4c17bc,
    0xbf7b349c, 0xbdd2d58a, 0x3f3adbe1, 0xbf506641,
    0xbf073a8e, 0x3f1e6ece, 0x3f2c0239, 0x3f00714f,
    0xbd4d101d, 0xc3330849, 0x3e0c6069, 0xbec5c58b,
    0x3e1def7f, 0x3ed2fa2d, 0xbfb37dcf, 0xbf4d7d16,
    0x3f97dd74, 0xbf88384f, 0x3e2c3834, 0x3fa0be6f,
    0xbdf4e02c, 0x3d0dfbb6, 0xbf7b663c, 0xbddd80f9,
    0x3f17bf92, 0x3fa67395, 0x3dd4142a, 0x3f759ed4,
    0x3f9315e5, 0x3ec8e829, 0xbf06d49d, 0x3ee797b8,
    0xbe4da7f2, 0xbe0be54b, 0x3eb54f72, 0xbe307e2d,
    0xbfeb34b4, 0xbeff4c03, 0x3f206f8c, 0x3fab8017,
    0xbe8b2600, 0x3f0103b6, 0x3f08b5f3, 0xbd2d8dd9,
    0x3f0d22d5, 0x3f6378a7, 0xbf05c2a1, 0x3f3e1255,
    0xbe8f31da, 0xbf2821f9, 0x3d7b2b01, 0x3fb40a62,
    0xbf6e2798, 0x3f21b83d, 0xbf82e25c, 0xbedcbf3e,
    0xbe684972, 0xbe90bab5, 0x3cd01d2a, 0x3d045f66,
    0xbfe0a4e6, 0xbebe25f6, 0x3d327a90, 0xbee6b730,
    0x3f0c4a52, 0x3f6e030d, 0xbf5f9b5a, 0xbf050b21,
    0xbec2ddff, 0xbfdd7e68, 0x3ea0436e, 0x3f4e148b,
    0xbdb78bfa, 0xbe2f1e70, 0x3fe099cd, 0xbe80bbcd,
    0x3e52082a, 0x3dee9e9c, 0xbeb84150, 0xbe4a3a1c,
    0xbf9223b3, 0x3f0f9527, 0x3f65f925, 0x3f881d02,
    0xbf0bb147, 0x3fa4e4de, 0xbf5b1132, 0x3e73c34c,
    0x3f1c6006, 0x3ea57557, 0x3f833ab6, 0x3c82f683,
    0x3e898be5, 0x3f057624, 0x3ec2e3e6, 0x3ee2e99b,
    0xbe817731, 0x3c50940b, 0xbee34b8f, 0x3e143a9c,
    0x3efac3b2, 0xbee93080, 0x3fa4857b, 0x3ec90f4d,
    0x3d85e26d, 0x3f1c6dd2, 0x3f5e5483, 0x3dd93e25,
    0x3ea58539, 0x3f48b94f, 0x3f585e31, 0xbf9f8ace,
    0xbe857350, 0xbfaa0d71, 0x3de866b8, 0xbea6c61b,
    0x3f819869, 0xb9827cb9, 0x3ee62a45, 0xbfbda1a0,
    0xbdf1f4ab, 0x3f85ee06, 0x3f05138c, 0x3fb78d88,
    0x3efd53b4, 0x3f0b9e9f, 0x3f41daa0, 0x3f4428c3,
    0xbf600719, 0xbf827172, 0x3d2d67c1, 0xbf5d8d40,
    0xbee9459c, 0x3f9a2560, 0x3dd447e5, 0xbf149720,
    0x3f16fe90, 0xbf8f7b4b, 0xbfb13cd7, 0x3f69b5f4,
    0xbe874a42, 0xbefaac4c, 0x3f090d5a, 0xbed95cca,
    0x3dc1c784, 0xbea78fc7, 0xbea37f8e, 0xbf6247d4,
    0x3f8aae86, 0xbdb9f630, 0x3fae7696, 0x3f442c4c,
    0xbed95433, 0xc0068c61, 0xbf306621, 0x3f5376e2,
    0x3b135e3f, 0xbf9fef40, 0xbe8100ef, 0xbfcafd32,
    0xbf03d542, 0x3e833494, 0x3f2ce8d3, 0x3e032822,
    0xc0138b06, 0x3f88a3f3, 0xbf371edf, 0x3f090349,
    0x3ebafcb6, 0x3f0a096e, 0x3dc5ef1a, 0x3ff68fd7,
    0xbf234fba, 0xbe95b0fb, 0x3f8dfbca, 0xbe5ec57e,
    0xbdc4214c, 0xbe813af4, 0xbf255019, 0xbf088b05,
    0x3f5412f1, 0x3f291e12, 0xbf2cb977, 0xbc9444dd,
    0xbf521cab, 0x3f21ec4e, 0x3ecef9b1, 0x3e8b9e24,
    0xbd9b66e5, 0x3ef75a7f, 0xbd848a39, 0xbef1b973,
    0x3f2105ad, 0x3f73e4b2, 0x3f846081, 0x3e40d170,
    0xbe6f0e73, 0x3ec2d3e4, 0x3e8f433f, 0xbdefe538,
    0xbf2f7040, 0x3ea469c7, 0x3e0a3489, 0xbe434071,
    0xbf7e7cbe, 0x3f55f74b, 0xbd943a2d, 0xbd98db57,
    0x3f163c35, 0x3e79526e, 0xbf5f7daf, 0xbf1034ff,
    0x3e08637d, 0x3efd27aa, 0x3e2786cd, 0xbf080979,
    0x3ed3e410, 0xbe701e7d, 0xbf10cb50, 0x3f2b4b0b,
    0xbf2222a1, 0xbf860357, 0x3f3e3079, 0xbdee5448,
    0x3f1bdc55, 0xbf910950, 0xbe4514dd, 0x3c3eb427,
    0xbe3aea6f, 0xbeea2f0b, 0x3e11c48f, 0x3ea5bb2d,
    0xbf4a10fe, 0xbf1d4f3d, 0xbf65b785, 0x3ea86325,
    0x3cc14cdb, 0x3f3f7657, 0x3f6dde0c, 0x3ec25263,
    0xbddb8476, 0xbdbcbdd2, 0xbee9102c, 0xbf9c9e29,
    0xbf30962b, 0x3eccc7d7, 0x3eaa780d, 0xbf5d6d4c,
    0xbef615d8, 0xbe6da525, 0xbf6568b9, 0xbf6849fc,
    0xbed54c07, 0x3ee2fa23, 0xbfcad954, 0xbfac5884,
    0xbe72a47a, 0xbeb18ece, 0xbfb57ec1, 0x3e4793b3,
    0xbf7ff47c, 0x3e33b29a, 0xbf352e64, 0x3f00e007,
    0x3e03311c, 0x3f5f85af, 0xbf69f602, 0x3f177b61,
    0x3e9bbe59, 0x3f8deeff, 0x3f6a5ca0, 0x3f917c6c,
    0xbe93b532, 0x3fbdcf91, 0x3f262858, 0x3f7b0e44,
    0x3f4ba87a, 0x3e3b698e, 0x3f246c75, 0x3f534dbc,
    0xbf920a5f, 0xbf8e593e, 0x3edc1678, 0x3f7ee675,
    0xbfb221fe, 0xbe031cab, 0x3f200298, 0xbe8920ea,
    0x3d715f61, 0xbff723e1, 0xbfbb3dd6, 0x3fa20455,
    0xbd52d4f2, 0xbe1e73b7, 0x3c68fead, 0xbdd36c4e,
    0x3eb0887f, 0x3dd298b3, 0x3e860cd6, 0x3efbf74e,
    0x3eac016c, 0x3f5d10db, 0xc018a7ed, 0xbf6b3d7b,
    0x3df8a29a, 0xbf82d7c2, 0x3fa0de6c, 0xbda75444,
    0xbdb72e3f, 0x3ecdccfc, 0x3efa55a9, 0xbf322eb4,
    0x3e008b8a, 0xbf3d783c, 0x3e6f3190, 0xbf7e0787,
    0x3f35884b, 0xbf44a515, 0x3d987c11, 0xbee3f19e,
    0xbf21d1db, 0xbf867a7d, 0x3f632011, 0x3e657be9,
    0x3e5d435c, 0x3dbe3411, 0x3e847328, 0xbe1bd8a6,
    0xbe57068c, 0x3dc0c9ce, 0x3f4036f2, 0xbefb7b8c,
    0xbe8b51e9, 0x3f9ff609, 0xbfac0bd1, 0xbeeb61c5,
    0x3f24b7b9, 0x3ee1c439, 0x3ff83159, 0x3ea65bfa,
    0xbf904dcb, 0x3edb0089, 0x3e2bd0ed, 0x3ee7227c,
    0x3ed967c2, 0xbf928ec7, 0x3ec981f8, 0x3f984ec2,
    0xbf91f735, 0x3dc359d1, 0x3eeb8d17, 0xbfbbc398,
    0x3f5eb764, 0x3f801b73, 0xbe82489a, 0xbfa5233b,
    0x3fa7b553, 0x3df29e94, 0x3e14493b, 0x3f9d6bb7,
    0xbf366c08, 0x3b61a4e1, 0x3db3853f, 0xbf8e38e5,
    0x3f2b4c7c, 0x3f3eba88, 0x3f6d9f5b, 0xbc9e1010,
    0x3faf8b19, 0x3e8dc4d4, 0xbb9d40ae, 0x3ee496d7,
    0x3edf18f3, 0x3f42ef8e, 0x3f409247, 0xbdb09474,
    0x3ec49a34, 0xbd1e4557, 0xbebc33b5, 0x3f7fd326,
    0x3edc7476, 0x3f6c5d7a, 0xbfafb4b7, 0x3f59a2e9,
    0xbe7a1521, 0xbeb2ec74, 0x3e60d4a1, 0x3ee34a41,
    0xbf8041fd, 0x3ef3e5fe, 0xbf26c0c2, 0xbda6fe7b,
    0x0
    };

static const uint32_t ref_rfft_noisy_512[513] = {
    0x3f8dc305, 0xbd48b4b0, 0xbe1c11f2, 0xbfba97ee,
    0x3fdd93b5, 0x3f03fe1f, 0x3e8dc09b, 0xbeecb820,
    0xbedc2c41, 0x3fc00e5f, 0xbdbeb30c, 0x3d6a4608,
    0xbf6bad8e, 0x3e34a23e, 0x3eada1a6, 0xbf84a349,
    0x3f3de3f7, 0xbdc4fc04, 0x3f0bc20c, 0xbfb159b7,
    0xbeab4119, 0x3f8e8e2c, 0x3eff2a87, 0x3f6bcd4d,
    0xbf0e3b0b, 0x3e4f4db9, 0xbf113482, 0x3ed9009e,
    0x3ed03b38, 0xbfb1894b, 0xbd6e2b26, 0x3d94eac4,
    0x3f19898c, 0x3f993fd3, 0xbfa83f04, 0xbe464a71,
    0xbe971726, 0xbcda8980, 0xbf08f356, 0xbffbb670,
    0xbfa79866, 0xbfb3458a, 0xbed2b324, 0xbeebbf96,
    0x3e938b26, 0xbfcb9a3b, 0x3eb31f58, 0x3fa80f34,
    0xbf8fa6ef, 0xbfb219de, 0x3d40b805, 0x3d96c8ce,
    0x3f87fd84, 0xbf78d9cf, 0xbf1b6e09, 0x3da7d3bb,
    0xbeafed65, 0x3feb4f21, 0xbeda04a0, 0xbd9ebf3b,
    0x3f8b763e, 0x3fc69d1e, 0x3ee2ceea, 0x3f42b252,
    0x3f04ea71, 0x3e9f17cf, 0x3fe3ba41, 0xbf9fc7fb,
    0xbe3af148, 0xbea76bd9, 0x3f591b64, 0x3f88b0d5,
    0x3fd0d75e, 0x3f9f8ea9, 0x3da1031d, 0x3e194cf6,
    0xbf7d336b, 0x3ff60ff7, 0xbf26f824, 0x3f28b4cd,
    0xbf19d740, 0x3f609c35, 0xbf682eb4, 0x3f09860d,
    0xbed889ec, 0x3eca8f40, 0xbf4cdaf1, 0xbefdde10,
    0x3e8d9270, 0xbf540eeb, 0x3f2150b8, 0x3f36f6c0,
    0x3f49aeb2, 0x3c811075, 0xbea3efe3, 0x3eb01bde,
    0x3e69f478, 0xbe7c267c, 0xbd2252df, 0xbfc2b43b,
    0x3e929901, 0x3e543927, 0xbf854f7f, 0x3e5c9a40,
    0x3eac619c, 0x3e50b43e, 0xbf2ae2b9, 0x3dedee32,
    0x3e251582, 0xbfd3dfc7, 0x4007c271, 0x3ef89be6,
    0xbe411c22, 0xbdc7abb7, 0xbd803d94, 0xbe8e7de0,
    0xbcf014d0, 0x3e57fbd4, 0x3e9b7f9b, 0xbf4c17bc,
    0xbf7b349c, 0xbdd2d58a, 0x3f3adbe1, 0xbf506641,
    0xbf073a8e, 0x3f1e6ece, 0x3f2c0239, 0x3f00714f,
    0xbd4d101d, 0xc3330849, 0x3e0c6069, 0xbec5c58b,
    0x3e1def7f, 0x3ed2fa2d, 0xbfb37dcf, 0xbf4d7d16,
    0x3f97dd74, 0xbf88384f, 0x3e2c3834, 0x3fa0be6f,
    0xbdf4e02c, 0x3d0dfbb6, 0xbf7b663c, 0xbddd80f9,
    0x3f17bf92, 0x3fa67395, 0x3dd4142a, 0x3f759ed4,
    0x3f9315e5, 0x3ec8e829, 0xbf06d49d, 0x3ee797b8,
    0xbe4da7f2, 0xbe0be54b, 0x3eb54f72, 0xbe307e2d,
    0xbfeb34b4, 0xbeff4c03, 0x3f206f8c, 0x3fab8017,
    0xbe8b2600, 0x3f0103b6, 0x3f08b5f3, 0xbd2d8dd9,
    0x3f0d22d5, 0x3f6378a7, 0xbf05c2a1, 0x3f3e1255,
    0xbe8f31da, 0xbf2821f9, 0x3d7b2b01, 0x3fb40a62,
    0xbf6e2798, 0x3f21b83d, 0xbf82e25c, 0xbedcbf3e,
    0xbe684972, 0xbe90bab5, 0x3cd01d2a, 0x3d045f66,
    0xbfe0a4e6, 0xbebe25f6, 0x3d327a90, 0xbee6b730,
    0x3f0c4a52, 0x3f6e030d, 0xbf5f9b5a, 0xbf050b21,
    0xbec2ddff, 0xbfdd7e68, 0x3ea0436e, 0x3f4e148b,
    0xbdb78bfa, 0xbe2f1e70, 0x3fe099cd, 0xbe80bbcd,
    0x3e52082a, 0x3dee9e9c, 0xbeb84150, 0xbe4a3a1c,
    0xbf9223b3, 0x3f0f9527, 0x3f65f925, 0x3f881d02,
    0xbf0bb147, 0x3fa4e4de, 0xbf5b1132, 0x3e73c34c,
    0x3f1c6006, 0x3ea57557, 0x3f833ab6, 0x3c82f683,
    0x3e898be5, 0x3f057624, 0x3ec2e3e6, 0x3ee2e99b,
    0xbe817731, 0x3c50940b, 0xbee34b8f, 0x3e143a9c,
    0x3efac3b2, 0xbee93080, 0x3fa4857b, 0x3ec90f4d,
    0x3d85e26d, 0x3f1c6dd2, 0x3f5e5483, 0x3dd93e25,
    0x3ea58539, 0x3f48b94f, 0x3f585e31, 0xbf9f8ace,
    0xbe857350, 0xbfaa0d71, 0x3de866b8, 0xbea6c61b,
    0x3f819869, 0xb9827cb9, 0x3ee62a45, 0xbfbda1a0,
    0xbdf1f4ab, 0x3f85ee06, 0x3f05138c, 0x3fb78d88,
    0x3efd53b4, 0x3f0b9e9f, 0x3f41daa0, 0x3f4428c3,
    0xbf600719, 0xbf827172, 0x3d2d67c1, 0xbf5d8d40,
    0xbee9459c, 0x3f9a2560, 0x3dd447e5, 0xbf149720,
    0x3f16fe90, 0xbf8f7b4b, 0xbfb13cd7, 0x3f69b5f4,
    0xbe874a42, 0xbefaac4c, 0x3f090d5a, 0xbed95cca,
    0x3dc1c784, 0xbea78fc7, 0xbea37f8e, 0xbf6247d4,
    0x3f8aae86, 0xbdb9f630, 0x3fae7696, 0x3f442c4c,
    0xbed95433, 0xc0068c61, 0xbf306621, 0x3f5376e2,
    0x3b135e3f, 0xbf9fef40, 0xbe8100ef, 0xbfcafd32,
    0xbf03d542, 0x3e833494, 0x3f2ce8d3, 0x3e032822,
    0xc0138b06, 0x3f88a3f3, 0xbf371edf, 0x3f090349,
    0x3ebafcb6, 0x3f0a096e, 0x3dc5ef1a, 0x3ff68fd7,
    0xbf234fba, 0xbe95b0fb, 0x3f8dfbca, 0xbe5ec57e,
    0xbdc4214c, 0xbe813af4, 0xbf255019, 0xbf088b05,
    0x3f5412f1, 0x3f291e12, 0xbf2cb977, 0xbc9444dd,
    0xbf521cab, 0x3f21ec4e, 0x3ecef9b1, 0x3e8b9e24,
    0xbd9b66e5, 0x3ef75a7f, 0xbd848a39, 0xbef1b973,
    0x3f2105ad, 0x3f73e4b2, 0x3f846081, 0x3e40d170,
    0xbe6f0e73, 0x3ec2d3e4, 0x3e8f433f, 0xbdefe538,
    0xbf2f7040, 0x3ea469c7, 0x3e0a3489, 0xbe434071,
    0xbf7e7cbe, 0x3f55f74b, 0xbd943a2d, 0xbd98db57,
    0x3f163c35, 0x3e79526e, 0xbf5f7daf, 0xbf1034ff,
    0x3e08637d, 0x3efd27aa, 0x3e2786cd, 0xbf080979,
    0x3ed3e410, 0xbe701e7d, 0xbf10cb50, 0x3f2b4b0b,
    0xbf2222a1, 0xbf860357, 0x3f3e3079, 0xbdee5448,
    0x3f1bdc55, 0xbf910950, 0xbe4514dd, 0x3c3eb427,
    0xbe3aea6f, 0xbeea2f0b, 0x3e11c48f, 0x3ea5bb2d,
    0xbf4a10fe, 0xbf1d4f3d, 0xbf65b785, 0x3ea86325,
    0x3cc14cdb, 0x3f3f7657, 0x3f6dde0c, 0x3ec25263,
    0xbddb8476, 0xbdbcbdd2, 0xbee9102c, 0xbf9c9e29,
    0xbf30962b, 0x3eccc7d7, 0x3eaa780d, 0xbf5d6d4c,
    0xbef615d8, 0xbe6da525, 0xbf6568b9, 0xbf6849fc,
    0xbed54c07, 0x3ee2fa23, 0xbfcad954, 0xbfac5884,
    0xbe72a47a, 0xbeb18ece, 0xbfb57ec1, 0x3e4793b3,
    0xbf7ff47c, 0x3e33b29a, 0xbf352e64, 0x3f00e007,
    0x3e03311c, 0x3f5f85af, 0xbf69f602, 0x3f177b61,
    0x3e9bbe59, 0x3f8deeff, 0x3f6a5ca0, 0x3f917c6c,
    0xbe93b532, 0x3fbdcf91, 0x3f262858, 0x3f7b0e44,
    0x3f4ba87a, 0x3e3b698e, 0x3f246c75, 0x3f534dbc,
    0xbf920a5f, 0xbf8e593e, 0x3edc1678, 0x3f7ee675,
    0xbfb221fe, 0xbe031cab, 0x3f200298, 0xbe8920ea,
    0x3d715f61, 0xbff723e1, 0xbfbb3dd6, 0x3fa20455,
    0xbd52d4f2, 0xbe1e73b7, 0x3c68fead, 0xbdd36c4e,
    0x3eb0887f, 0x3dd298b3, 0x3e860cd6, 0x3efbf74e,
    0x3eac016c, 0x3f5d10db, 0xc018a7ed, 0xbf6b3d7b,
    0x3df8a29a, 0xbf82d7c2, 0x3fa0de6c, 0xbda75444,
    0xbdb72e3f, 0x3ecdccfc, 0x3efa55a9, 0xbf322eb4,
    0x3e008b8a, 0xbf3d783c, 0x3e6f3190, 0xbf7e0787,
    0x3f35884b, 0xbf44a515, 0x3d987c11, 0xbee3f19e,
    0xbf21d1db, 0xbf867a7d, 0x3f632011, 0x3e657be9,
    0x3e5d435c, 0x3dbe3411, 0x3e847328, 0xbe1bd8a6,
    0xbe57068c, 0x3dc0c9ce, 0x3f4036f2, 0xbefb7b8c,
    0xbe8b51e9, 0x3f9ff609, 0xbfac0bd1, 0xbeeb61c5,
    0x3f24b7b9, 0x3ee1c439, 0x3ff83159, 0x3ea65bfa,
    0xbf904dcb, 0x3edb0089, 0x3e2bd0ed, 0x3ee7227c,
    0x3ed967c2, 0xbf928ec7, 0x3ec981f8, 0x3f984ec2,
    0xbf91f735, 0x3dc359d1, 0x3eeb8d17, 0xbfbbc398,
    0x3f5eb764, 0x3f801b73, 0xbe82489a, 0xbfa5233b,
    0x3fa7b553, 0x3df29e94, 0x3e14493b, 0x3f9d6bb7,
    0xbf366c08, 0x3b61a4e1, 0x3db3853f, 0xbf8e38e5,
    0x3f2b4c7c, 0x3f3eba88, 0x3f6d9f5b, 0xbc9e1010,
    0x3faf8b19, 0x3e8dc4d4, 0xbb9d40ae, 0x3ee496d7,
    0x3edf18f3, 0x3f42ef8e, 0x3f409247, 0xbdb09474,
    0x3ec49a34, 0xbd1e4557, 0xbebc33b5, 0x3f7fd326,
    0x3edc7476, 0x3f6c5d7a, 0xbfafb4b7, 0x3f59a2e9,
    0xbe7a1521, 0xbeb2ec74, 0x3e60d4a1, 0x3ee34a41,
    0xbf8041fd, 0x3ef3e5fe, 0xbf26c0c2, 0xbda6fe7b,
    0x0
    };

static const uint32_t in_rfft_noisy_1024[1024] = {
    0xba68b5bb, 0x3f1351e5, 0x3f344253, 0x3ed83fb6,
    0x3da90b16, 0xbf169cc8, 0xbf27a510, 0xbee1f71f,
    0xbbf276ea, 0x3ef8f33b, 0x3f3acffe, 0x3f01949a,
    0xbc6477c3, 0xbee7686e, 0xbf3a0362, 0xbef0d1f5,
    0x3d1e3d75, 0x3ee0cd2e, 0x3f4401ae, 0x3ee274c5,
    0xbd01008d, 0xbefda745, 0xbf4127e6, 0xbed0d0b4,
    0x3c713989, 0x3ed65f17, 0x3f21e328, 0x3f027598,
    0xbc005a63, 0xbf020cfe, 0xbf474dbf, 0xbefc8ea3,
    0x3cac8361, 0x3eff2006, 0x3f2857eb, 0x3f111c43,
    0x3da19944, 0xbf0ba545, 0xbf30908f, 0xbefa524b,
    0x3d536d51, 0x3f0de323, 0x3f3a9acc, 0x3ef66b91,
    0x3d91769b, 0xbf144ef0, 0xbf31b9c6, 0xbef70c7a,
    0xbd05e8da, 0x3ef9f784, 0x3f230b45, 0x3ee8c265,
    0xbc7af8a4, 0xbf163443, 0xbf37c316, 0xbeeef281,
    0x3beebf2c, 0x3f0152c5, 0x3f3d0e85, 0x3edd409d,
    0xbd2f537d, 0xbefbe868, 0xbf31656b, 0xbf028832,
    0xbd824665, 0x3f03df52, 0x3f2b6167, 0x3ef8aaeb,
    0xbcd570cc, 0xbf07f330, 0xbf2920bc, 0xbeeea7fe,
    0xbcfa8d62, 0x3f10de15, 0x3f4898da, 0x3f0c8047,
    0xbca27c11, 0xbf008da1, 0xbf39c8e5, 0xbebecae6,
    0x3d9ccd0b, 0x3f0b7867, 0x3f2ff7fe, 0x3ef62bb2,
    0x3dc028b7, 0xbf0ddd81, 0xbf273563, 0xbf10cbe6,
    0x3d45900e, 0x3efe3518, 0x3f2aca70, 0x3f0251b6,
    0xbd119eb6, 0xbf0aecfe, 0xbf3e0ac4, 0xbf21966d,
    0xbc5b2b63, 0x3ef2b12c, 0x3f2e4ad3, 0x3ee93852,
    0xbd65237c, 0xbf037f89, 0xbf41c302, 0xbf05565b,
    0x3b635988, 0x3eef7af3, 0x3f36cd63, 0x3f0c0758,
    0x3c56ecf7, 0xbf083ff4, 0xbf4f1627, 0xbf06309d,
    0xbd89bdef, 0x3ef1c98f, 0x3f26d035, 0x3ef97808,
    0x3d6b71c7, 0xbef1785f, 0xbf2e2d96, 0xbf0ed7ff,
    0x3c1ccdcc, 0x3f0827e8, 0x3f454e22, 0x3f04e1b7,
    0x3d423694, 0xbf034cbc, 0xbf2d7657, 0xbee53adf,
    0xbd8dc1ac, 0x3f05d49d, 0x3f3377fc, 0x3efcf842,
    0xbdd1779c, 0xbf080c0c, 0xbf20ae4b, 0xbf04656c,
    0xbd1fe960, 0x3f0b9aba, 0x3f4b45b3, 0x3ed6f7d0,
    0x3d8155fa, 0xbeef49b1, 0xbf351eb8, 0xbef924d9,
    0xbd57b1bc, 0x3ef96332, 0x3f423ccb, 0x3efd1eca,
    0xbced3640, 0xbeeae41b, 0xbf34d367, 0xbef5b811,
    0x3ceabf03, 0x3f045d0c, 0x3f499fc0, 0x3ed04bd3,
    0x3d4fc947, 0xbeed2945, 0xbf3bc21e, 0xbf05c632,
    0xbd4c1caf, 0x3f09e1e9, 0x3f368688, 0x3edb2e5d,
    0x3d1efd4a, 0xbf08efa2, 0xbf32859f, 0xbeedabe8,
    0xbda2a599, 0x3f0cf596, 0x3f3d8c3a, 0x3f0c07b9,
    0xbd2a130b, 0xbf213ed5, 0xbf2872a0, 0xbf177d57,
    0x3d46040d, 0x3edba561, 0x3f4d4ab0, 0x3f0f1b76,
    0x3ba316d6, 0xbed64c0a, 0xbf3913f7, 0xbed13350,
    0x3d9aced5, 0x3f0e4ed4, 0x3f3f4a0f, 0x3ef1846f,
    0xbca9b1f4, 0xbf027e57, 0xbf469683, 0xbf19eb8d,
    0x3d2678c0, 0x3f00bb53, 0x3f479441, 0x3ee9abe6,
    0xbc0530c2, 0xbf07dce8, 0xbf3b2778, 0xbf07addc,
    0x3c5de93c, 0x3f0e960b, 0x3f2b3eae, 0x3ee7ae72,
    0xbcbe5235, 0xbf0df605, 0xbf38ace4, 0xbef7e237,
    0x3d46bdf4, 0x3f03782a, 0x3f3ca0a4, 0x3f1d7611,
    0xbb43862e, 0xbf05c5f3, 0xbf371d8a, 0xbef17216,
    0xbc90ab46, 0x3f049fd7, 0x3f30281f, 0x3f009930,
    0xbbe8a205, 0xbef2497c, 0xbf2e8c9b, 0xbf02257d,
    0x3d7d6045, 0x3ee6423a, 0x3f3f4f20, 0x3f016c48,
    0x3d192ee4, 0xbef4bdef, 0xbf39edba, 0xbeebab0c,
    0x3a82f95e, 0x3eeeb720, 0x3f3b1dab, 0x3f08b664,
    0xbbe992e1, 0xbf0bd932, 0xbf395fca, 0xbef0e883,
    0x3dcda879, 0x3eb63511, 0x3f4ae086, 0x3f0957de,
    0xbd5cb9f2, 0xbf0d199c, 0xbf2f88b7, 0xbed9acec,
    0x3abfadfc, 0x3f049f3c, 0x3f18d88c, 0x3f16f353,
    0xbd3c5bdd, 0xbedd8d93, 0xbf36a506, 0xbef123cf,
    0x3d96ff38, 0x3f121177, 0x3f42efb5, 0x3ee99185,
    0x3d327557, 0xbee8c916, 0xbf293ea3, 0xbf029f2b,
    0x3b7807bd, 0x3eef620a, 0x3f137f20, 0x3edf451e,
    0x3b80b37e, 0xbee29566, 0xbf2e2874, 0xbf030149,
    0x3cb52f49, 0x3f103cd4, 0x3f3605e8, 0x3ec50a7d,
    0x3d9d70a2, 0xbf02dab6, 0xbf1ee78d, 0xbf04d228,
    0xbd6192b9, 0x3efb2579, 0x3f390ea9, 0x3ee2e470,
    0xbd0678db, 0xbf1572d7, 0xbf200a44, 0xbec01e3f,
    0xbcc8f31f, 0x3edf45cd, 0x3f2fc5b7, 0x3f061424,
    0x396be087, 0xbef2d59b, 0xbf3afb47, 0xbf01611b,
    0x3db4a47c, 0x3ef8eaa5, 0x3f46bed3, 0x3edc8637,
    0x3dab6c28, 0xbee2269a, 0xbf1938da, 0xbf054a68,
    0xbda9da9a, 0x3f02a620, 0x3f24ebae, 0x3f0c33af,
    0xbcf53815, 0xbee1a0bb, 0xbf3dd1f5, 0xbf0daf46,
    0x3c91a58a, 0x3f07e2ca, 0x3f2f4da9, 0x3ef7aa0c,
    0xbca47a42, 0xbf008e4f, 0xbf3b2b26, 0xbf09cc0e,
    0xbd4ce358, 0x3ef9a675, 0x3f34499e, 0x3f03da97,
    0xbc81ddeb, 0xbf09f16c, 0xbf29d7fd, 0xbf10f6ed,
    0xbd99859a, 0x3ed4959a, 0x3f48ca5c, 0x3eddedb3,
    0xbba5a40d, 0xbf0da909, 0xbf3bcce0, 0xbeec1466,
    0x3ca41bf1, 0x3ef348cd, 0x3f273ef6, 0x3f08c3ae,
    0x3cbd6a46, 0xbef521fa, 0xbf2dd3cc, 0xbf045fdd,
    0x3d66a91c, 0x3f0e03f4, 0x3f31804f, 0x3ed3bbe3,
    0x3cdd5391, 0xbeede95c, 0xbf391667, 0xbed7ca41,
    0xba8d9365, 0x3eee4cbb, 0x3f3e1eb7, 0x3eef83da,
    0x3d4aa740, 0xbf159729, 0xbf304543, 0xbf0b3b9b,
    0xbd361214, 0x3ef270a7, 0x3f32b301, 0x3f01911b,
    0x3d565106, 0xbef36057, 0xbf3c57d0, 0xbec5a0ff,
    0xbd6f5ce6, 0x3f053782, 0x3f23e6e6, 0x3f0de936,
    0x3ca58df1, 0xbef118f0, 0xbf39578d, 0xbf2035f7,
    0xbd91e31c, 0x3efc70e3, 0x3f39c92d, 0x3f007d20,
    0xbcdf28d9, 0xbf1029f9, 0xbf372832, 0xbf0f598b,
    0x3bdbfd27, 0x3f06522d, 0x3f4eacac, 0x3eff191e,
    0x3b2429ef, 0xbf00e2b3, 0xbf2ffe23, 0xbee9cb94,
    0xbc6028c3, 0x3ef2ae76, 0x3f384b54, 0x3f0913e4,
    0x3ccc5f51, 0xbf061771, 0xbf321fbc, 0xbf023185,
    0x3d41f938, 0x3ee51859, 0x3f200a9a, 0x3f010f4a,
    0x3cdfbae0, 0xbef826a9, 0xbf2c59a1, 0xbed70a78,
    0x3d97fda6, 0x3ef9f986, 0x3f4796d0, 0x3f0adef0,
    0xbd8fb7db, 0xbee20294, 0xbf4188ae, 0xbef48b75,
    0x3b47446e, 0x3f16b315, 0x3f3b8069, 0x3eff8995,
    0x3c90456c, 0xbf06f38c, 0xbf2f83eb, 0xbeec5afd,
    0x3d71517f, 0x3f06706b, 0x3f176ed1, 0x3f10e38f,
    0x3d43d64c, 0xbeed249f, 0xbf3f5f97, 0xbf0a1eb9,
    0xbce6f697, 0x3f0017ec, 0x3f3f16e9, 0x3ed9dea1,
    0xbcb3a3f0, 0xbf161fa5, 0xbf2df173, 0xbef18a35,
    0xbc96eaf9, 0x3ed7383b, 0x3f356a6d, 0x3f0484a4,
    0xbd6d8e55, 0xbf06f08b, 0xbf234f51, 0xbeefd8b3,
    0xbc96171d, 0x3eff811c, 0x3f2cbfc9, 0x3edfbeaa,
    0xbc029fdd, 0xbf082be1, 0xbf217e6c, 0xbefe8285,
    0xbde21751, 0x3f00c1a7, 0x3f3d9745, 0x3f139f9f,
    0xbd4c6a2e, 0xbf15e9fd, 0xbf361d8e, 0xbee20737,
    0xbd1b610a, 0x3ef4f987, 0x3f3ce604, 0x3ee257d4,
    0x3d651bad, 0xbef89fd9, 0xbf36843d, 0xbf031ce6,
    0xbd987196, 0x3ee60a74, 0x3f2a2ce1, 0x3f0744fd,
    0x3d4eabfd, 0xbf1740ab, 0xbf327ddc, 0xbf06927c,
    0x3dd2cef3, 0x3ef47577, 0x3f28f0a7, 0x3f192d9d,
    0x3cd44629, 0xbef43dbc, 0xbf122b77, 0xbef6e6b1,
    0xbc797a8c, 0x3f111efa, 0x3f3ffb95, 0x3f09ac7a,
    0xbc35b0f3, 0xbefc3260, 0xbf28726d, 0xbeebfee0,
    0xbd86a76f, 0x3efc8a20, 0x3f29bcbb, 0x3f02f32a,
    0x3dc3e077, 0xbee62b70, 0xbf48d562, 0xbed86ace,
    0x3c115ca0, 0x3f1a5b87, 0x3f37918c, 0x3f07a3de,
    0xbc1715c7, 0xbed8c14f, 0xbf288077, 0xbef48f95,
    0xbcc9c43b, 0x3ef7eaad, 0x3f2ee4a0, 0x3f1cd1e9,
    0x3d143c0b, 0xbef9da06, 0xbf44b7c7, 0xbf0553cb,
    0x3bab3d21, 0x3f18fcf2, 0x3f445393, 0x3f1cb5ea,
    0x3d2210c2, 0xbf0770e7, 0xbf32c760, 0xbf1b4349,
    0xbd933102, 0x3eddd400, 0x3f1d8d12, 0x3f0100a0,
    0x3c000c1c, 0xbf00f826, 0xbf41f1ea, 0xbf058d3e,
    0x3c84add2, 0x3ef47472, 0x3f362fcd, 0x3ee8b8b7,
    0x3e02608a, 0xbf042962, 0xbf46ab15, 0xbf10dd34,
    0x3c845ac2, 0x3ee75a9f, 0x3f386603, 0x3eed8a5d,
    0x3c9b27e0, 0xbf08d2dd, 0xbf35c523, 0xbef4eafe,
    0xbd726240, 0x3f0a7103, 0x3f3934ab, 0x3ec94e09,
    0x3d28b99a, 0xbf02452c, 0xbf3ee249, 0xbeb6104d,
    0xbd594a4b, 0x3ed8bd5d, 0x3f2f82a9, 0x3f087b32,
    0xbc579682, 0xbf0f615d, 0xbf2e6e31, 0xbed1ad40,
    0x3da21824, 0x3efd62e6, 0x3f2823b8, 0x3f094303,
    0xbc39d3d1, 0xbf0a1992, 0xbf2b2df7, 0xbf0c6287,
    0xbd469106, 0x3f0cd91e, 0x3f3eb4a9, 0x3ebf1985,
    0x3dcff377, 0xbee95d55, 0xbf41384c, 0xbf0550e3,
    0x3cc72823, 0x3ee7fc2f, 0x3f223341, 0x3eeb4183,
    0xbd962a0e, 0xbeef43d8, 0xbf37b638, 0xbedb0060,
    0xbca8cbe9, 0x3ee4a30d, 0x3f2ad89e, 0x3ee837ae,
    0xbd521c68, 0xbf044c15, 0xbf3bf16a, 0xbef693fd,
    0xbd4454df, 0x3f00cc8e, 0x3f37636a, 0x3f0a9a7c,
    0x3d0fac3f, 0xbf045e4e, 0xbf40a176, 0xbf08571d,
    0x3c136bdb, 0x3eea626e, 0x3f390898, 0x3eedcbd9,
    0xbcd257bc, 0xbee25c79, 0xbf1ce077, 0xbed06fe7,
    0xbc46a927, 0x3f03ea3f, 0x3f26619e, 0x3ef8596b,
    0xbd3906c6, 0xbf05abc8, 0xbf49132f, 0xbee01d9f,
    0xbda57346, 0x3ee9ef45, 0x3f2d4daf, 0x3ee47650,
    0xbcd536f3, 0xbee913ff, 0xbf303400, 0xbedd918a,
    0x3d9583ee, 0x3f088b49, 0x3f37aa20, 0x3f0fb284,
    0xbd082f40, 0xbed35b57, 0xbf45079a, 0xbeea9bf5,
    0xbcae4e26, 0x3f003969, 0x3f392429, 0x3ef2afc9,
    0xbd8cc57b, 0xbedbb409, 0xbf2591a7, 0xbef7fff1,
    0xbde0eef7, 0x3effdea7, 0x3f35a478, 0x3ee2a135,
    0x3d552b9d, 0xbf08ddd8, 0xbf2fb089, 0xbecedebc,
    0xbccf1883, 0x3f07f592, 0x3f2c83ae, 0x3ee2e092,
    0xbd40923c, 0xbeeb2bf7, 0xbf2b4fe5, 0xbee9d35c,
    0xbba1aac2, 0x3f007eab, 0x3f33129f, 0x3f008d07,
    0x3d18c3c3, 0xbee8979c, 0xbf354f7f, 0xbf064dc5,
    0x3d9f6232, 0x3f07218b, 0x3f29c71d, 0x3f057121,
    0x3b1104b1, 0xbf023318, 0xbf2db7b3, 0xbef59a9d,
    0xbd507554, 0x3f148452, 0x3f2e9e2b, 0x3f0f4487,
    0x3d93c084, 0xbf08da72, 0xbf2d22c8, 0xbee4d048,
    0x3b72da36, 0x3f06308e, 0x3f3534fe, 0x3f011559,
    0x3c4b8fcf, 0xbedb2f50, 0xbf325484, 0xbf004afe,
    0x3cba44d0, 0x3f00f6c5, 0x3f3da8c2, 0x3ecd3784,
    0x3cc25cab, 0xbee88fec, 0xbf2f9c0e, 0xbefe1a71,
    0x3ca416df, 0x3f154908, 0x3f386c8e, 0x3f151748,
    0xb980a755, 0xbef3cbea, 0xbf2d62a2, 0xbee4ae17,
    0xbd3a1047, 0x3eecad4c, 0x3f36e88e, 0x3ee6b58b,
    0x3d961a13, 0xbf045736, 0xbf50563d, 0xbefc55ee,
    0x37c27210, 0x3f07ddeb, 0x3f1b63f2, 0x3f0ce3ff,
    0x3d90590f, 0xbf00dab7, 0xbf3d09fa, 0xbeef4112,
    0xbd8a2d4a, 0x3f03f780, 0x3f49428a, 0x3f03d837,
    0x3aea7547, 0xbf0ad2f8, 0xbf28b220, 0xbebd9724,
    0x3cf399d5, 0x3f0b6eba, 0x3f2eaba1, 0x3efc7b6a,
    0xbd401ed8, 0xbeebbd03, 0xbf2b50aa, 0xbef52947,
    0x3d7bcd74, 0x3f0e168f, 0x3f21cfa6, 0x3f0976fc,
    0xbd97ce39, 0xbee1702b, 0xbf3a4802, 0xbf089136,
    0x3bcc4b81, 0x3f0642ba, 0x3f34044f, 0x3efe187d,
    0x3d90cf2d, 0xbf095f47, 0xbf3775d7, 0xbef246c4,
    0xbd39ce2e, 0x3f059d72, 0x3f3da28a, 0x3f019bba,
    0xba202b13, 0xbeee6c0e, 0xbf29faf2, 0xbf018164,
    0xbb941e0d, 0x3efd3273, 0x3f311604, 0x3efc4a65,
    0x3cbe5bce, 0xbeed5b1c, 0xbf33aea8, 0xbebe9453,
    0x3d08fb31, 0x3f13e29e, 0x3f264cbe, 0x3eff2d1d,
    0x3d332d9e, 0xbf054572, 0xbf318a7c, 0xbebd5e8e,
    0xbd8dfcb8, 0x3ef145d1, 0x3f3836ec, 0x3f0fd4be,
    0xbda6bc4e, 0xbef676b7, 0xbf337108, 0xbeff9eab,
    0x3c6a4219, 0x3ee8686e, 0x3f294b31, 0x3f06a8de,
    0x3d856643, 0xbf05077c, 0xbf3e8bf0, 0xbed82277,
    0xbb0f0f03, 0x3f12e5be, 0x3f45ce7d, 0x3ed8077a,
    0xbd09de17, 0xbefd0dc7, 0xbf42f250, 0xbef41975,
    0x3d292460, 0x3f066b21, 0x3f2f7385, 0x3eef6ef0,
    0x3b517746, 0xbf04e8fb, 0xbf45fc22, 0xbf1c3cdf,
    0x3d4a6371, 0x3efc4dee, 0x3f476263, 0x3f012676,
    0xbc8d92a6, 0xbf18ae16, 0xbf33973d, 0xbedfec3a,
    0x3c9b023f, 0x3ee84336, 0x3f2ac3c5, 0x3f0bfc41,
    0x3dccbbb0, 0xbf139c2d, 0xbf38ce78, 0xbefbadfe,
    0x3c47d28d, 0x3ecebc6a, 0x3f38ec8b, 0x3f08336d,
    0xbd4cb0bb, 0xbee9365d, 0xbf46a689, 0xbeff3ff1,
    0x3dbbbf2c, 0x3edcca32, 0x3f2f3196, 0x3f03ca89,
    0xbc0db481, 0xbefd0d32, 0xbf323cf9, 0xbef25a85,
    0x3d42a1f3, 0x3f05956b, 0x3f48e6df, 0x3f045a81,
    0xbb9296aa, 0xbed05814, 0xbf18722e, 0xbf04df19,
    0xbc00c12a, 0x3ed84c27, 0x3f38909b, 0x3efc7546,
    0x3cf43eb5, 0xbee5dff4, 0xbf29b330, 0xbee6acf2,
    0x3cc8a22f, 0x3f008863, 0x3f3f0697, 0x3f020199,
    0xbd1b8ed5, 0xbf0cce6b, 0xbf31c8c4, 0xbed97419,
    0x3d57dd8f, 0x3f012a78, 0x3f37de06, 0x3ec6ceb6,
    0x3c8850cd, 0xbf0b9cee, 0xbf2b513a, 0xbef3b6ce,
    0xbaad681b, 0x3f01658d, 0x3f2abf73, 0x3efcbbcc,
    0xbcace347, 0xbef60562, 0xbf2f3491, 0xbf02d8dc,
    0x3cb6cd21, 0x3ef4b0de, 0x3f38bae8, 0x3f06ee4a,
    0x3d0805e1, 0xbef0294c, 0xbf31a2b6, 0xbec2d43d,
    0x3cf3ecaf, 0x3f10d622, 0x3f3c6df7, 0x3ece5fbf,
    0xbd1af2f0, 0xbedc9b6e, 0xbf3bb119, 0xbef224d1,
    0xbd02729a, 0x3ee63692, 0x3f286665, 0x3f06c4d3,
    0xbd2a1f64, 0xbf02efcd, 0xbf3a03e3, 0xbf13cabf,
    0x3c9df117, 0x3ef56993, 0x3f337624, 0x3efbfea1,
    0x3c0b0cae, 0xbf02ae42, 0xbf33add4, 0xbee0f581,
    0xbd870a0a, 0x3f000d2c, 0x3f2da528, 0x3ef64b31,
    0xbd96eeb2, 0xbef2226e, 0xbf337a52, 0xbf0b8b01,
    0x3cf4f452, 0x3f02743f, 0x3f3a9c58, 0x3ed191af,
    0xbd998da9, 0xbf085a35, 0xbf2f459d, 0xbedb6816,
    0xbca18b37, 0x3f012812, 0x3f2b7faa, 0x3f202248,
    0x3cdad88c, 0xbf1afa11, 0xbf3e19a4, 0xbef18597,
    0x3ccf144e, 0x3f043d09, 0x3f325f58, 0x3efb6678,
    0x3cf30984, 0xbefbf89b, 0xbf2ff11b, 0xbeefede7,
    0x3d4e9ff1, 0x3f00fa81, 0x3f2be5ac, 0x3f014733,
    0x3b7af7c2, 0xbf0ff1b1, 0xbf31edbd, 0xbefcede3,
    0xbd09100d, 0x3ef03109, 0x3f36169e, 0x3ed01fc9,
    0x3c860de9, 0xbee6ece5, 0xbf306d31, 0xbf06996e,
    0x3bf080a0, 0x3f03fec4, 0x3f29dc04, 0x3ee0a363,
    0x3d34b9fb, 0xbec50a8f, 0xbf411e8e, 0xbf1ad9cf,
    0xbd9a883e, 0x3ebff461, 0x3f2e1586, 0x3eec39f9,
    0xbd0c1409, 0xbf069314, 0xbf3e8b29, 0xbee75944,
    0xbd530f36, 0x3f126f1d, 0x3f36b7c3, 0x3ee75704,
    0x3d226d22, 0xbf1847fc, 0xbf2dd80b, 0xbf1a7444,
    0xbd57a3bd, 0x3ee3f0d4, 0x3f42d88c, 0x3f0bbcbd,
    0x3d854693, 0xbeff0f9d, 0xbf3ff765, 0xbee580cb,
    0xbc58980b, 0x3efe6e38, 0x3f35590d, 0x3f078ab2,
    0x3d2beb31, 0xbf144e66, 0xbf212f36, 0xbeece118,
    0x3d41b195, 0x3ef1a60a, 0x3f31f2f8, 0x3eca4a58,
    0xbcfd833e, 0xbee2d01c, 0xbf28b6bd, 0xbeec96bc,
    0x3d8fff77, 0x3efc2939, 0x3f35e68d, 0x3eff2a51,
    0xbd0d5f06, 0xbf0b9276, 0xbf1c0129, 0xbf07a35b
    };

static const uint32_t in_rifft_noisy_1024[1025] = {
    0x3fc96f3f, 0x3eb33f93, 0xbf5417f7, 0x3f78fa3c,
    0xc006d776, 0xbea17d19, 0xbec78d4b, 0xbf89d57e,
    0x3f94b736, 0x3fccd6fe, 0x3b229a76, 0xbfebc036,
    0x3fde1e34, 0xbf5a4745, 0x3ddbd85e, 0x3e9e75da,
    0x400cc70f, 0xbe06d4c1, 0xbfb63513, 0xbe5d22da,
    0x3c2fdabb, 0x3f4fd828, 0xbf3f2793, 0xbfc5f1a4,
    0x40056a68, 0x3fb6ca33, 0x3fb9639f, 0xbe0e1366,
    0x3f8e857e, 0x4019d786, 0x3fa45c9d, 0xbfa3d41f,
    0x3e74fad4, 0x3f811529, 0x3ee560b2, 0xbe6bced0,
    0x3f428fae, 0xbeeb337f, 0xc046a1c6, 0x3f57e3fe,
    0xbf8f312b, 0x3f72ee86, 0xbfcfa534, 0xbe951873,
    0xbf599785, 0x3f705325, 0x3e4e54ad, 0x3fa011ed,
    0x4002a4dc, 0xbef49de5, 0x3f8d96e0, 0x3e9b1dd5,
    0xbeb04ba9, 0x3f963fce, 0x3f8651da, 0x3ef31883,
    0x3f4163e3, 0xc0202034, 0x3f84f819, 0xbfd52859,
    0xbf17d12b, 0xbfd53608, 0xbfa754a1, 0xbf90aee6,
    0x3f9e7094, 0x3d072e25, 0xbfa48be4, 0x3fcae5de,
    0x3ed1d85a, 0xbf951938, 0xbf95e398, 0xbf01644d,
    0x3e98a6dd, 0xbf94c26c, 0xbeeefe07, 0xbcdc31ba,
    0xbed0798c, 0x3eb2f5f3, 0x3f533d40, 0x3e9b0576,
    0x3f917f94, 0x3cd89f29, 0xbf281b05, 0xbdeee507,
    0x3f6772a8, 0x3e09d7bd, 0xc0373f22, 0x3fdf9a16,
    0xbfb16c81, 0x3e1abd2b, 0x3f60a301, 0xbfca01ce,
    0xbfb80843, 0xbeafd27b, 0xbe44f987, 0x3fccc985,
    0x3ee8188f, 0x3fbe5966, 0x3dc39982, 0x3db998fb,
    0x3f498553, 0x3fbb64ea, 0x3f71d416, 0xbf3cb2e2,
    0x3ec445a3, 0xbe15aa60, 0x3f9c699c, 0xbf78d1e3,
    0xbfedc4bb, 0xbf7df1e5, 0x4026d11d, 0x3f9ce890,
    0xbf291361, 0x3ec3fce6, 0x3f557eb0, 0xbeff8613,
    0x3f51080e, 0x3f913927, 0x3e09e95a, 0x3f4191e3,
    0xbf1af2c1, 0x3d3d0af8, 0xbd86f792, 0x3c1d2ebd,
    0xc01c05a1, 0xbef846c4, 0xbb88875c, 0x3d590590,
    0xc01738a1, 0xbecfaef9, 0xbf24741f, 0xbe315c8c,
    0xc00c0fc3, 0x40214964, 0x3f87c317, 0x3e144a7b,
    0x3f613b5a, 0xbf0e2c1e, 0xbeaff194, 0xc024ab1b,
    0xbef9f7cf, 0xbf972613, 0x3d491911, 0x3e54b8de,
    0x3f43bf2e, 0x3f9eea0f, 0x3f85e526, 0xbf5ddc21,
    0xbe8f51d2, 0x3e1ec03c, 0x3f4f2a69, 0xbf5e24c7,
    0xbe2d726e, 0xbec09a03, 0xbf8d2c57, 0xbf02d7d1,
    0x4005eaea, 0x40064874, 0xbe74a8d7, 0xba30b879,
    0xbe8093bb, 0xbf9fadda, 0xbea443c9, 0x3e6397c7,
    0xbeaee8c3, 0x3f37b9e7, 0x3f7da9db, 0x3e88ef9d,
    0xbf5b7963, 0x3f575b28, 0xbe694f59, 0x3ecc4dec,
    0xbeb3237c, 0x3f000e3b, 0xbebc2050, 0x3e3dfb0a,
    0x3f3cb628, 0x3f92dca5, 0xbfaa0168, 0xbecf9cfc,
    0x3f63889c, 0xbe6f54b2, 0xc0071014, 0xbf5a7d04,
    0x3d4fea6c, 0xbf63bcda, 0xbfb7743d, 0xbfbb0291,
    0x3f09e052, 0xc023367b, 0x3fc7425e, 0x3f9df304,
    0x3f92a19e, 0xbf1701da, 0xbf456fdd, 0x3e4858b8,
    0xbe29d8ed, 0xbf14496b, 0x3f689d6f, 0xc0379876,
    0xbea86cda, 0x3f434723, 0xbf44af22, 0xbf7ec643,
    0x3f8a336c, 0xbf368e25, 0x3f720387, 0x3eed6fd6,
    0xbe82f943, 0xbf946f78, 0x3f3dbbfc, 0x3db9c793,
    0x3fd561c0, 0xbea5f157, 0x3dfeaf4a, 0x3f1309f1,
    0x3f68a787, 0xbf50aef7, 0xbf98aace, 0x3e09f0d5,
    0x3f925037, 0x3f864825, 0xbf3f6f66, 0x3f932a06,
    0xbf44d473, 0xbf0f4076, 0x3f1cf692, 0x3e07722a,
    0x40136965, 0xbf56c39e, 0x3ef96d59, 0x3fae69ed,
    0x3f5bff3e, 0x3d092561, 0x3e247245, 0xbe8d6b9f,
    0xbd13b31f, 0xbff81cfc, 0x3eb5ea7d, 0xbe303655,
    0xbe2a6e0c, 0x3fda37ed, 0x3ebaf538, 0x402e632c,
    0xbedd2b69, 0x3cb72207, 0x3d61ab35, 0x3f8ae8c5,
    0xbf6c896a, 0x3e3bcc4f, 0x3fda1abd, 0x3faf3877,
    0xbe284f2b, 0x3e8d4b96, 0x40289383, 0xbf89d294,
    0x3f99d6d0, 0xc3b3ebc3, 0x3e4674db, 0x3d980102,
    0xbfa188ae, 0xbe9d16e4, 0xbfc38cf9, 0x3fd3c21b,
    0x3eed66f9, 0x3c3faa60, 0x403bb62c, 0xbf879f1c,
    0xc00178be, 0xc000c751, 0x3f6be2f2, 0x3f445d85,
    0xbebd81e3, 0x3e98cc06, 0x3f1e3347, 0x3eb5dee5,
    0xbbe1e67a, 0xbfb48267, 0x3fa1b973, 0x3f1d3da1,
    0x3f4fe2fd, 0x3f7adc2d, 0x3f43a473, 0xbf040b4e,
    0xbe28d932, 0x3ff3b9f8, 0x4037f851, 0x3fa68f07,
    0x3f33c182, 0x3f61d541, 0xbf2fd1db, 0x3ebb6353,
    0xbe29b273, 0x3f780906, 0xbf50c327, 0xbe830e5c,
    0xbf4fcd09, 0x3f93d5fc, 0x3fac9cbe, 0x3ba5f90d,
    0xbf490f5b, 0xbde75d85, 0xbf93d203, 0x3f64b956,
    0x3d9f0816, 0xbf8a6996, 0x3ee22ce6, 0xbe1545e3,
    0xbf73e53f, 0xbe8d1ba1, 0xbfaf5f84, 0xbfd1b870,
    0x3f059cf2, 0xbec25102, 0x3f0cf78e, 0x3ebf9dd0,
    0xbf8a2458, 0xbf045e3a, 0xbf89913e, 0x3e592932,
    0x3ec5ba46, 0xbf6a6cf9, 0x3c6b5fc8, 0x3f05cf6f,
    0xbf7d7852, 0x3f5b2606, 0x3d658008, 0x3e767e05,
    0xbfce95e1, 0x3fc3a72b, 0xbed09d09, 0x3ecc028b,
    0xbff61ec9, 0x3df06988, 0x3fb33fd0, 0xbf3beefc,
    0x3fa85eeb, 0xbf2eab3e, 0xbe486117, 0xbdfe4af1,
    0x3fc5f8cb, 0x3e54a248, 0xbfcab984, 0xbefb01ba,
    0xbfe79fd3, 0xbe93850a, 0xbea07076, 0xbfbbbf30,
    0x3f16d631, 0x3e924661, 0x3fd7a8f3, 0xbf5a97eb,
    0xbdcf9d98, 0x3f909a22, 0x3eb01107, 0xc00a75e6,
    0x3e178372, 0x3fcd44c0, 0x4002cb48, 0xbe71a12b,
    0x3ecefc77, 0xbf07ba8f, 0x3f7b6cd6, 0xbf405cb1,
    0x3f8af504, 0xbf0d72ad, 0x3fb8562e, 0x3c67dc6f,
    0x4006dd81, 0xbf20a39b, 0xbf41174e, 0x3ebbf7dc,
    0xbf825f8a, 0x3f6b028c, 0x3e1bcea9, 0xbf3a9611,
    0xc008558f, 0x3db1ce83, 0x3eb4ed43, 0x3f74e6cd,
    0x3c1f2404, 0x3f027473, 0xc001cc7d, 0xbfb64c7f,
    0x3f83b6d2, 0xbf750489, 0x3f8c7039, 0xbf2c3bdc,
    0x3f6dac0d, 0x3ec3f8fa, 0x3f57edd0, 0xbd816d33,
    0xbf86035d, 0x40086ecb, 0xbfae0631, 0xc062b14c,
    0xbec6eb42, 0x3fcc60f9, 0x3f512fef, 0xbf5867c8,
    0xbf8aab64, 0x3f5e0a92, 0x3e7ced30, 0xc003a489,
    0xbf55421a, 0xbe332985, 0x403887ee, 0x3ee25d0c,
    0xbea6c676, 0xbf0b8905, 0x3e27519c, 0xbee94ab3,
    0xbeae24e4, 0x3eac38b3, 0x3f87ff71, 0x3fc377d0,
    0xbee32805, 0xbf4862a2, 0xbf066b03, 0x3f5db695,
    0x3ead1de4, 0x4035e9af, 0x3e2b6923, 0xbfa95fff,
    0xc000e63d, 0xbf4ccf6d, 0xbf81059e, 0x3efb8dd8,
    0xbfbbff52, 0x3f03ca17, 0x3ed42b34, 0xbfcc4c1c,
    0xbf3cb75e, 0x3fb04c9b, 0x3fd1ef70, 0x401d7034,
    0x3f27c1ce, 0xbf7afd1b, 0x3f4b2b6e, 0x3f080ffc,
    0x3fa4bb3d, 0x4001df44, 0xc006eeb8, 0xbeb5f656,
    0x3fdd6d4e, 0xbf318209, 0x3eb18bc6, 0x3c1a933e,
    0xbf4edc3f, 0xc0079e02, 0xbf9374f7, 0x3faad32e,
    0xbfed2c03, 0xbfce4995, 0xbfaccfb1, 0x3fcbf4d5,
    0x400411a6, 0x3ebd86de, 0x4028a8fb, 0xbe0c80f8,
    0xbfa820e7, 0x3de0c31c, 0xbf9be72a, 0x3fbac945,
    0xbee6b81f, 0xbf4c6f10, 0x3f20dee2, 0xbff9fbbb,
    0xbf8f3f79, 0x3e154c8e, 0x3f1436e6, 0xbece8e10,
    0xbe8cd73f, 0xbeee2d06, 0xc001d6ce, 0xc090f1eb,
    0xbf257ebc, 0xbecdcb8e, 0x3fac2368, 0xbf3c53f6,
    0xbe95e55c, 0xbfb633aa, 0x3f323615, 0xbedd0ccd,
    0xbf6a2a76, 0xbc214ca0, 0xbf3eb333, 0x402bc329,
    0x3f2d48a3, 0x3ef594d2, 0xbec0a308, 0x3f2b82fc,
    0xbd6bda4e, 0x3ef23381, 0xbf3226e4, 0x3f9bdcaa,
    0x3d21306e, 0xbdfe2010, 0xbfcc730e, 0xbfcc9830,
    0xbf64f5c6, 0x3f58dc86, 0xbf536f4e, 0x3f8e0a67,
    0x3f7c4468, 0x3fe2d4a1, 0xbf032eb0, 0xbf0ac8a2,
    0x3f7f7f48, 0x3f0c0bf7, 0x3e93bc02, 0xbf84745a,
    0x3e169937, 0x3fd1c116, 0xbed910fc, 0x3ee88b8a,
    0xbf453e5d, 0x3f121321, 0x3f5ac053, 0xbf0f782e,
    0x3fca1ced, 0x3e924492, 0x3f6df8ae, 0x3fc61920,
    0x3f13363c, 0xc001c76a, 0xbf82044d, 0x3ee8fe7e,
    0xbf8cd2ef, 0xbf2a80da, 0x3f6b98d1, 0x3f0cbd5d,
    0x3feaad29, 0xbda08d09, 0xbe7bf3c0, 0x3d34a5e5,
    0xbe16082b, 0xbf6d9319, 0xbfae6da0, 0xbf09a4a9,
    0xbf5e97fc, 0xbf63f7a3, 0x3e176554, 0xbf9da7bc,
    0xc00473ec, 0xbf133a45, 0xbf4cac18, 0x3fc51521,
    0xbff65ebb, 0x3f368314, 0x3f4b9bdb, 0xbfcb534d,
    0x3f9017d6, 0xbfaa07f2, 0x3d8c7cfc, 0x3f18b6cf,
    0xbf8f6c65, 0xbe3e6423, 0x3e0604a1, 0xbf9d988a,
    0x3f5766e1, 0x3ebae61a, 0xbf8aa46c, 0x3f8ad9fa,
    0x408317a3, 0x3f8d65ef, 0xbf11a44b, 0xbf759b48,
    0xbf42ef98, 0x3e162c34, 0xbf12f206, 0xbd5ff8e2,
    0x3f15d4ab, 0x3f277859, 0xbec102bb, 0x3c331cbb,
    0xbf98156c, 0xbf966a6e, 0x3e4488dd, 0xbf813999,
    0xbc4aee8e, 0x3e7af9b2, 0x3edafe8c, 0x3de91f48,
    0x3f08c637, 0x3b3cff06, 0x3f03c6d2, 0xc00d7562,
    0x3f03eb52, 0x400b5967, 0x3e17a3e0, 0xbf38015b,
    0xbd715ccf, 0x3ea3010b, 0x3f78035e, 0xbf5b7a4d,
    0x3cc43d8c, 0x3f6a7754, 0xbe28abe2, 0xbda750e0,
    0x40028d6f, 0xbfe681ef, 0x3faf2fc5, 0x3fca046d,
    0xbf0e06ca, 0xbebf6b3a, 0xbf6462d9, 0x400367d5,
    0xbf9a8555, 0x3ea1bd77, 0x3f3d1ccf, 0x3f7dbdf6,
    0xbe791f2e, 0xbf0352ae, 0x3f3fe335, 0x3eb4a23e,
    0xbfe206fc, 0xbfe73329, 0xbf638d76, 0xbf9ca7da,
    0xbf8ea27e, 0xbf0accb8, 0xbf266b29, 0x3ef97d9d,
    0x3e42cafb, 0xbf0e4c84, 0xbec1fdf0, 0xbf975184,
    0x40132851, 0x3ff98371, 0xbef6a048, 0x3eca8226,
    0xbf70667c, 0xbfa7a266, 0x3f96e483, 0x3ea3a437,
    0xbf52896a, 0xbec37122, 0xbe1a09d2, 0x3ed1b03d,
    0xbe97becb, 0x3f8db7f5, 0xbf34ec70, 0xbf936596,
    0x3b8f73d4, 0xc0186d67, 0xbe19a3e2, 0xbf76dc5d,
    0x3f327909, 0xbe4d82d2, 0xbfd31b2b, 0x3d013d81,
    0xbd890238, 0xbf21152e, 0xbf8cec24, 0xbfbfb6ea,
    0xbf2e692e, 0x3e8efd93, 0xbe5b6779, 0x3efb08cc,
    0x3ec39e28, 0xc008aa1a, 0xbf7dc4c2, 0xbe554950,
    0x3eeedbe5, 0xbf6cc5bb, 0xba7f6375, 0x3f1ea675,
    0xbfc4d3d6, 0xbe886ad7, 0x3f82cc09, 0x3d9bc6ed,
    0xbf9a8380, 0xbfe2ce54, 0x3f469c78, 0x3dae5af1,
    0xbfcb68ef, 0xbfcc0ce1, 0x3ebcc367, 0xc0740061,
    0x3f96b16c, 0xbec2ec7d, 0x3f4cb3e4, 0x3f46d093,
    0xbe2dc747, 0x3fd8bdb6, 0xbf923bd4, 0xc002c88b,
    0x3f3b3583, 0x3eefff4f, 0xbef55876, 0x3f3cba07,
    0x3f0123b9, 0xbf8dd488, 0xbf10b516, 0x3f168da0,
    0xbe8ab1d8, 0xbfd53359, 0x3f0931dd, 0x3e5df4fc,
    0x40119bce, 0xbea67efa, 0xbf3e8183, 0xbe3fb0fd,
    0x3f37ccf7, 0xbfb821fb, 0xbff8b2b7, 0x3e33a1f9,
    0xbea038c5, 0xc02b5170, 0x3da41f8f, 0xbffce604,
    0xbe743cbf, 0x3fbd8044, 0xbf596fc0, 0xc03efb4f,
    0x3f5562bf, 0xbf20786f, 0xbf39a7ac, 0xbfdf4c51,
    0x3de45f80, 0xbf721d05, 0xbf88cce1, 0xbfe75119,
    0xbea6ebbf, 0x3f5b8eb3, 0xbf1adecd, 0xbec70ad3,
    0x3e408fc1, 0xbf3c6c71, 0xbf6eb941, 0xbfeeb65e,
    0xbf08db07, 0x3fa8714f, 0x3e7953b8, 0x3f39054c,
    0xbf1bc967, 0xbd60cea7, 0xc004ed2a, 0xbf0575b8,
    0xbfb203bb, 0x3fa3ecf2, 0xbf3519bb, 0x3f87ba3b,
    0x3f32e5d7, 0xbfc048c0, 0x3f2eb09b, 0x3e01b4bd,
    0x3fade302, 0x3f2becdc, 0xbf1f3f18, 0xbe41a198,
    0xbe245386, 0xbf1c0c0d, 0xbf234934, 0x3e2b8ff7,
    0xbedc280b, 0x3f1cee9c, 0x3fdebecf, 0x4017bca7,
    0xbf84a0a3, 0xbf39ff45, 0x3d519603, 0xbf839f22,
    0xbfbf3b56, 0xbfc7dc6e, 0x3f80f48e, 0x3f293d4e,
    0xc041b6ef, 0x3f604201, 0xbe93a488, 0xbc92b2dc,
    0xbf2b25cb, 0x3e231584, 0xc0016888, 0x3e879f2a,
    0x3ec683b0, 0xbf5afe53, 0x3ea57d61, 0x3ee2b2e1,
    0xbddcba99, 0xbd5e0bba, 0xbf2059df, 0x3f8390dd,
    0x3eb8eaec, 0x3f80cb46, 0xbd4ff1b0, 0x3e5fc2cd,
    0x40273388, 0xbf87e36d, 0xbf190d80, 0xbfc2053c,
    0x3fb94c3e, 0xbc1825ba, 0x3f0eb3af, 0x3e3e5752,
    0xbfa0f7c6, 0xbfdd09d1, 0x3f0e8167, 0xbe803b0d,
    0x3fa1b519, 0xbcbeb0f1, 0x3e9df2bb, 0x3d2a038e,
    0x3f68a8c9, 0xbf1185ea, 0x3f286eb5, 0x3f89ada7,
    0xc008bfbe, 0x3e9a7c22, 0x3fbd27bf, 0x3e1a6523,
    0x3ec25130, 0xbeb54c9a, 0x3ffe099b, 0xbea7c92b,
    0xbfccc5c3, 0xbf73cffc, 0xbfcbe0e9, 0xbfd7b5c3,
    0xc01b9bd4, 0x3e33e110, 0xbf1232cc, 0x3fcb71b7,
    0xbefb1750, 0x3d46bc6a, 0x3f6276d1, 0xbf1fe149,
    0xbe170545, 0xbf4961cc, 0xbf593234, 0xbec67f19,
    0xbd08e66e, 0x3f74bc12, 0xbed10349, 0x3dd4211f,
    0xbee8d6e5, 0xbf62eb5d, 0xbddb0a6a, 0x3f0c6a2d,
    0xbedf75f9, 0xc05255c7, 0xbfb85b90, 0xbda989c9,
    0x3d90beef, 0x3f90d151, 0xbf229be5, 0x3e56de76,
    0x3fdfd47b, 0x3fe56dd6, 0xbf87ce76, 0x3f3bc5d9,
    0xbe891d6a, 0xbe68908c, 0x3ef151a8, 0xbfbd5924,
    0xbec52596, 0x3ec73d04, 0x3f16d604, 0x3ff2e25c,
    0xbf62e74e, 0x3fa7d893, 0xbfe6dd91, 0xbf5e6fc1,
    0xbedaef5b, 0xbc5ffcf5, 0xbfd68bbe, 0x3defbe04,
    0xc006d499, 0x3ff49d82, 0xc0054bf6, 0xbf79c20c,
    0x3f4a1022, 0x3f8c4ed4, 0x3fb9791a, 0x3f5b52d1,
    0xbe8414b7, 0xbfb4804e, 0xbf233c4b, 0x3f4de955,
    0x3f31f9f1, 0x3f25dcca, 0xbfc05337, 0xbc915099,
    0xbf3adcff, 0xc03be7cc, 0x3f81bc4e, 0x3f9d1438,
    0x3ff63137, 0xc01b45a2, 0xbf9e7adb, 0xbfe65c37,
    0x3f5ace4c, 0x3f516d4c, 0x3cecc626, 0xbf2547a9,
    0x3f9b1490, 0x3e84e792, 0x3fd0d9e1, 0x3d17277e,
    0x3e3dd817, 0x3f70802d, 0xbfbdd1d5, 0x3ff599cd,
    0x3fd6f12e, 0x401f47da, 0x401ca67e, 0x3fb4c90c,
    0x3e350125, 0xc04573ee, 0xbf269092, 0xbed9da8d,
    0xbebd0026, 0x3f0c12df, 0x3f6b6755, 0x3f2d988e,
    0x3f8d006b, 0x3ed4e903, 0x3da62dfe, 0x3fd9b621,
    0x3fa9d06d, 0x404a6608, 0x3f518ed6, 0xbf24d431,
    0xbfae0669, 0xbfe5f1e3, 0x3cc0451b, 0x3fbce0a5,
    0xbf080c30, 0x3f6178c5, 0x3f65e855, 0xbf492367,
    0x3f4d9571, 0x3e050211, 0xbf84d585, 0xbf6e6d26,
    0x3e8e8002, 0x3e1029cf, 0x3eb10188, 0xbd78815a,
    0xbf6207cc, 0xbf1e8b4d, 0x3e9d085e, 0x3ea275cc,
    0xbf240c2a, 0xbf910b0b, 0xbfb89295, 0xbcf658d5,
    0xbeceb221, 0x3fbacb79, 0x3e6cfcb7, 0xbfbd3c25,
    0xbf0590f0, 0x3f027e62, 0x3ff87dd1, 0x3ef23adb,
    0x3fa26bd8, 0xbe5e2e4a, 0xc016c2eb, 0xbf0baf41,
    0x3f790ed0, 0xbe2b8014, 0x3eae7ea6, 0x3e3a2ed1,
    0x3ec0b760, 0xbf02fac7, 0xbf8da000, 0x3f57d668,
    0x3ebaccb2, 0x3e25a158, 0xbca8273f, 0x400ecf78,
    0x3ef0c781, 0x3f3ddcd5, 0x3f04bfde, 0xbe7a91f4,
    0xbf252157, 0x3fb9ecca, 0x3f9a474c, 0xbd47d94a,
    0x3cd2c61b, 0x3f508154, 0x3fea85ee, 0xc007aa64,
    0xbf57af81, 0xbfd407c8, 0x3fae71d8, 0x3fb0727c,
    0xbd92976f, 0xbc900973, 0xbea638bd, 0xbfe64745,
    0xbf6348ac, 0xbb7b8c20, 0x3fc305c5, 0xbf3eb595,
    0xbe96b55c, 0x3f428e6a, 0x3f133d1a, 0xbf0a992d,
    0xbe0ae9e2, 0x3e648133, 0x3fbedf92, 0xbe1abf78,
    0xbf680e48, 0xbee7c65b, 0x3f3ae644, 0xbd9fc847,
    0xbff7d5bf, 0x3d4d0f2c, 0x3fa3d30a, 0xbfed4faf,
    0x3fe4405c, 0xbec3d313, 0x3f7a1948, 0xbe95e086,
    0x3ef39ca2, 0x3f56a245, 0xbf077c97, 0xbec793f5,
    0x3efbce35, 0xbfa17290, 0x400f50d7, 0x401e94c8,
    0x0
    };

static const uint32_t ref_rfft_noisy_1024[1025] = {
    0x3fc96f3f, 0x3eb33f93, 0xbf5417f7, 0x3f78fa3c,
    0xc006d776, 0xbea17d19, 0xbec78d4b, 0xbf89d57e,
    0x3f94b736, 0x3fccd6fe, 0x3b229a76, 0xbfebc036,
    0x3fde1e34, 0xbf5a4745, 0x3ddbd85e, 0x3e9e75da,
    0x400cc70f, 0xbe06d4c1, 0xbfb63513, 0xbe5d22da,
    0x3c2fdabb, 0x3f4fd828, 0xbf3f2793, 0xbfc5f1a4,
    0x40056a68, 0x3fb6ca33, 0x3fb9639f, 0xbe0e1366,
    0x3f8e857e, 0x4019d786, 0x3fa45c9d, 0xbfa3d41f,
    0x3e74fad4, 0x3f811529, 0x3ee560b2, 0xbe6bced0,
    0x3f428fae, 0xbeeb337f, 0xc046a1c6, 0x3f57e3fe,
    0xbf8f312b, 0x3f72ee86, 0xbfcfa534, 0xbe951873,
    0xbf599785, 0x3f705325, 0x3e4e54ad, 0x3fa011ed,
    0x4002a4dc, 0xbef49de5, 0x3f8d96e0, 0x3e9b1dd5,
    0xbeb04ba9, 0x3f963fce, 0x3f8651da, 0x3ef31883,
    0x3f4163e3, 0xc0202034, 0x3f84f819, 0xbfd52859,
    0xbf17d12b, 0xbfd53608, 0xbfa754a1, 0xbf90aee6,
    0x3f9e7094, 0x3d072e25, 0xbfa48be4, 0x3fcae5de,
    0x3ed1d85a, 0xbf951938, 0xbf95e398, 0xbf01644d,
    0x3e98a6dd, 0xbf94c26c, 0xbeeefe07, 0xbcdc31ba,
    0xbed0798c, 0x3eb2f5f3, 0x3f533d40, 0x3e9b0576,
    0x3f917f94, 0x3cd89f29, 0xbf281b05, 0xbdeee507,
    0x3f6772a8, 0x3e09d7bd, 0xc0373f22, 0x3fdf9a16,
    0xbfb16c81, 0x3e1abd2b, 0x3f60a301, 0xbfca01ce,
    0xbfb80843, 0xbeafd27b, 0xbe44f987, 0x3fccc985,
    0x3ee8188f, 0x3fbe5966, 0x3dc39982, 0x3db998fb,
    0x3f498553, 0x3fbb64ea, 0x3f71d416, 0xbf3cb2e2,
    0x3ec445a3, 0xbe15aa60, 0x3f9c699c, 0xbf78d1e3,
    0xbfedc4bb, 0xbf7df1e5, 0x4026d11d, 0x3f9ce890,
    0xbf291361, 0x3ec3fce6, 0x3f557eb0, 0xbeff8613,
    0x3f51080e, 0x3f913927, 0x3e09e95a, 0x3f4191e3,
    0xbf1af2c1, 0x3d3d0af8, 0xbd86f792, 0x3c1d2ebd,
    0xc01c05a1, 0xbef846c4, 0xbb88875c, 0x3d590590,
    0xc01738a1, 0xbecfaef9, 0xbf24741f, 0xbe315c8c,
    0xc00c0fc3, 0x40214964, 0x3f87c317, 0x3e144a7b,
    0x3f613b5a, 0xbf0e2c1e, 0xbeaff194, 0xc024ab1b,
    0xbef9f7cf, 0xbf972613, 0x3d491911, 0x3e54b8de,
    0x3f43bf2e, 0x3f9eea0f, 0x3f85e526, 0xbf5ddc21,
    0xbe8f51d2, 0x3e1ec03c, 0x3f4f2a69, 0xbf5e24c7,
    0xbe2d726e, 0xbec09a03, 0xbf8d2c57, 0xbf02d7d1,
    0x4005eaea, 0x40064874, 0xbe74a8d7, 0xba30b879,
    0xbe8093bb, 0xbf9fadda, 0xbea443c9, 0x3e6397c7,
    0xbeaee8c3, 0x3f37b9e7, 0x3f7da9db, 0x3e88ef9d,
    0xbf5b7963, 0x3f575b28, 0xbe694f59, 0x3ecc4dec,
    0xbeb3237c, 0x3f000e3b, 0xbebc2050, 0x3e3dfb0a,
    0x3f3cb628, 0x3f92dca5, 0xbfaa0168, 0xbecf9cfc,
    0x3f63889c, 0xbe6f54b2, 0xc0071014, 0xbf5a7d04,
    0x3d4fea6c, 0xbf63bcda, 0xbfb7743d, 0xbfbb0291,
    0x3f09e052, 0xc023367b, 0x3fc7425e, 0x3f9df304,
    0x3f92a19e, 0xbf1701da, 0xbf456fdd, 0x3e4858b8,
    0xbe29d8ed, 0xbf14496b, 0x3f689d6f, 0xc0379876,
    0xbea86cda, 0x3f434723, 0xbf44af22, 0xbf7ec643,
    0x3f8a336c, 0xbf368e25, 0x3f720387, 0x3eed6fd6,
    0xbe82f943, 0xbf946f78, 0x3f3dbbfc, 0x3db9c793,
    0x3fd561c0, 0xbea5f157, 0x3dfeaf4a, 0x3f1309f1,
    0x3f68a787, 0xbf50aef7, 0xbf98aace, 0x3e09f0d5,
    0x3f925037, 0x3f864825, 0xbf3f6f66, 0x3f932a06,
    0xbf44d473, 0xbf0f4076, 0x3f1cf692, 0x3e07722a,
    0x40136965, 0xbf56c39e, 0x3ef96d59, 0x3fae69ed,
    0x3f5bff3e, 0x3d092561, 0x3e247245, 0xbe8d6b9f,
    0xbd13b31f, 0xbff81cfc, 0x3eb5ea7d, 0xbe303655,
    0xbe2a6e0c, 0x3fda37ed, 0x3ebaf538, 0x402e632c,
    0xbedd2b69, 0x3cb72207, 0x3d61ab35, 0x3f8ae8c5,
    0xbf6c896a, 0x3e3bcc4f, 0x3fda1abd, 0x3faf3877,
    0xbe284f2b, 0x3e8d4b96, 0x40289383, 0xbf89d294,
    0x3f99d6d0, 0xc3b3ebc3, 0x3e4674db, 0x3d980102,
    0xbfa188ae, 0xbe9d16e4, 0xbfc38cf9, 0x3fd3c21b,
    0x3eed66f9, 0x3c3faa60, 0x403bb62c, 0xbf879f1c,
    0xc00178be, 0xc000c751, 0x3f6be2f2, 0x3f445d85,
    0xbebd81e3, 0x3e98cc06, 0x3f1e3347, 0x3eb5dee5,
    0xbbe1e67a, 0xbfb48267, 0x3fa1b973, 0x3f1d3da1,
    0x3f4fe2fd, 0x3f7adc2d, 0x3f43a473, 0xbf040b4e,
    0xbe28d932, 0x3ff3b9f8, 0x4037f851, 0x3fa68f07,
    0x3f33c182, 0x3f61d541, 0xbf2fd1db, 0x3ebb6353,
    0xbe29b273, 0x3f780906, 0xbf50c327, 0xbe830e5c,
    0xbf4fcd09, 0x3f93d5fc, 0x3fac9cbe, 0x3ba5f90d,
    0xbf490f5b, 0xbde75d85, 0xbf93d203, 0x3f64b956,
    0x3d9f0816, 0xbf8a6996, 0x3ee22ce6, 0xbe1545e3,
    0xbf73e53f, 0xbe8d1ba1, 0xbfaf5f84, 0xbfd1b870,
    0x3f059cf2, 0xbec25102, 0x3f0cf78e, 0x3ebf9dd0,
    0xbf8a2458, 0xbf045e3a, 0xbf89913e, 0x3e592932,
    0x3ec5ba46, 0xbf6a6cf9, 0x3c6b5fc8, 0x3f05cf6f,
    0xbf7d7852, 0x3f5b2606, 0x3d658008, 0x3e767e05,
    0xbfce95e1, 0x3fc3a72b, 0xbed09d09, 0x3ecc028b,
    0xbff61ec9, 0x3df06988, 0x3fb33fd0, 0xbf3beefc,
    0x3fa85eeb, 0xbf2eab3e, 0xbe486117, 0xbdfe4af1,
    0x3fc5f8cb, 0x3e54a248, 0xbfcab984, 0xbefb01ba,
    0xbfe79fd3, 0xbe93850a, 0xbea07076, 0xbfbbbf30,
    0x3f16d631, 0x3e924661, 0x3fd7a8f3, 0xbf5a97eb,
    0xbdcf9d98, 0x3f909a22, 0x3eb01107, 0xc00a75e6,
    0x3e178372, 0x3fcd44c0, 0x4002cb48, 0xbe71a12b,
    0x3ecefc77, 0xbf07ba8f, 0x3f7b6cd6, 0xbf405cb1,
    0x3f8af504, 0xbf0d72ad, 0x3fb8562e, 0x3c67dc6f,
    0x4006dd81, 0xbf20a39b, 0xbf41174e, 0x3ebbf7dc,
    0xbf825f8a, 0x3f6b028c, 0x3e1bcea9, 0xbf3a9611,
    0xc008558f, 0x3db1ce83, 0x3eb4ed43, 0x3f74e6cd,
    0x3c1f2404, 0x3f027473, 0xc001cc7d, 0xbfb64c7f,
    0x3f83b6d2, 0xbf750489, 0x3f8c7039, 0xbf2c3bdc,
    0x3f6dac0d, 0x3ec3f8fa, 0x3f57edd0, 0xbd816d33,
    0xbf86035d, 0x40086ecb, 0xbfae0631, 0xc062b14c,
    0xbec6eb42, 0x3fcc60f9, 0x3f512fef, 0xbf5867c8,
    0xbf8aab64, 0x3f5e0a92, 0x3e7ced30, 0xc003a489,
    0xbf55421a, 0xbe332985, 0x403887ee, 0x3ee25d0c,
    0xbea6c676, 0xbf0b8905, 0x3e27519c, 0xbee94ab3,
    0xbeae24e4, 0x3eac38b3, 0x3f87ff71, 0x3fc377d0,
    0xbee32805, 0xbf4862a2, 0xbf066b03, 0x3f5db695,
    0x3ead1de4, 0x4035e9af, 0x3e2b6923, 0xbfa95fff,
    0xc000e63d, 0xbf4ccf6d, 0xbf81059e, 0x3efb8dd8,
    0xbfbbff52, 0x3f03ca17, 0x3ed42b34, 0xbfcc4c1c,
    0xbf3cb75e, 0x3fb04c9b, 0x3fd1ef70, 0x401d7034,
    0x3f27c1ce, 0xbf7afd1b, 0x3f4b2b6e, 0x3f080ffc,
    0x3fa4bb3d, 0x4001df44, 0xc006eeb8, 0xbeb5f656,
    0x3fdd6d4e, 0xbf318209, 0x3eb18bc6, 0x3c1a933e,
    0xbf4edc3f, 0xc0079e02, 0xbf9374f7, 0x3faad32e,
    0xbfed2c03, 0xbfce4995, 0xbfaccfb1, 0x3fcbf4d5,
    0x400411a6, 0x3ebd86de, 0x4028a8fb, 0xbe0c80f8,
    0xbfa820e7, 0x3de0c31c, 0xbf9be72a, 0x3fbac945,
    0xbee6b81f, 0xbf4c6f10, 0x3f20dee2, 0xbff9fbbb,
    0xbf8f3f79, 0x3e154c8e, 0x3f1436e6, 0xbece8e10,
    0xbe8cd73f, 0xbeee2d06, 0xc001d6ce, 0xc090f1eb,
    0xbf257ebc, 0xbecdcb8e, 0x3fac2368, 0xbf3c53f6,
    0xbe95e55c, 0xbfb633aa, 0x3f323615, 0xbedd0ccd,
    0xbf6a2a76, 0xbc214ca0, 0xbf3eb333, 0x402bc329,
    0x3f2d48a3, 0x3ef594d2, 0xbec0a308, 0x3f2b82fc,
    0xbd6bda4e, 0x3ef23381, 0xbf3226e4, 0x3f9bdcaa,
    0x3d21306e, 0xbdfe2010, 0xbfcc730e, 0xbfcc9830,
    0xbf64f5c6, 0x3f58dc86, 0xbf536f4e, 0x3f8e0a67,
    0x3f7c4468, 0x3fe2d4a1, 0xbf032eb0, 0xbf0ac8a2,
    0x3f7f7f48, 0x3f0c0bf7, 0x3e93bc02, 0xbf84745a,
    0x3e169937, 0x3fd1c116, 0xbed910fc, 0x3ee88b8a,
    0xbf453e5d, 0x3f121321, 0x3f5ac053, 0xbf0f782e,
    0x3fca1ced, 0x3e924492, 0x3f6df8ae, 0x3fc61920,
    0x3f13363c, 0xc001c76a, 0xbf82044d, 0x3ee8fe7e,
    0xbf8cd2ef, 0xbf2a80da, 0x3f6b98d1, 0x3f0cbd5d,
    0x3feaad29, 0xbda08d09, 0xbe7bf3c0, 0x3d34a5e5,
    0xbe16082b, 0xbf6d9319, 0xbfae6da0, 0xbf09a4a9,
    0xbf5e97fc, 0xbf63f7a3, 0x3e176554, 0xbf9da7bc,
    0xc00473ec, 0xbf133a45, 0xbf4cac18, 0x3fc51521,
    0xbff65ebb, 0x3f368314, 0x3f4b9bdb, 0xbfcb534d,
    0x3f9017d6, 0xbfaa07f2, 0x3d8c7cfc, 0x3f18b6cf,
    0xbf8f6c65, 0xbe3e6423, 0x3e0604a1, 0xbf9d988a,
    0x3f5766e1, 0x3ebae61a, 0xbf8aa46c, 0x3f8ad9fa,
    0x408317a3, 0x3f8d65ef, 0xbf11a44b, 0xbf759b48,
    0xbf42ef98, 0x3e162c34, 0xbf12f206, 0xbd5ff8e2,
    0x3f15d4ab, 0x3f277859, 0xbec102bb, 0x3c331cbb,
    0xbf98156c, 0xbf966a6e, 0x3e4488dd, 0xbf813999,
    0xbc4aee8e, 0x3e7af9b2, 0x3edafe8c, 0x3de91f48,
    0x3f08c637, 0x3b3cff06, 0x3f03c6d2, 0xc00d7562,
    0x3f03eb52, 0x400b5967, 0x3e17a3e0, 0xbf38015b,
    0xbd715ccf, 0x3ea3010b, 0x3f78035e, 0xbf5b7a4d,
    0x3cc43d8c, 0x3f6a7754, 0xbe28abe2, 0xbda750e0,
    0x40028d6f, 0xbfe681ef, 0x3faf2fc5, 0x3fca046d,
    0xbf0e06ca, 0xbebf6b3a, 0xbf6462d9, 0x400367d5,
    0xbf9a8555, 0x3ea1bd77, 0x3f3d1ccf, 0x3f7dbdf6,
    0xbe791f2e, 0xbf0352ae, 0x3f3fe335, 0x3eb4a23e,
    0xbfe206fc, 0xbfe73329, 0xbf638d76, 0xbf9ca7da,
    0xbf8ea27e, 0xbf0accb8, 0xbf266b29, 0x3ef97d9d,
    0x3e42cafb, 0xbf0e4c84, 0xbec1fdf0, 0xbf975184,
    0x40132851, 0x3ff98371, 0xbef6a048, 0x3eca8226,
    0xbf70667c, 0xbfa7a266, 0x3f96e483, 0x3ea3a437,
    0xbf52896a, 0xbec37122, 0xbe1a09d2, 0x3ed1b03d,
    0xbe97becb, 0x3f8db7f5, 0xbf34ec70, 0xbf936596,
    0x3b8f73d4, 0xc0186d67, 0xbe19a3e2, 0xbf76dc5d,
    0x3f327909, 0xbe4d82d2, 0xbfd31b2b, 0x3d013d81,
    0xbd890238, 0xbf21152e, 0xbf8cec24, 0xbfbfb6ea,
    0xbf2e692e, 0x3e8efd93, 0xbe5b6779, 0x3efb08cc,
    0x3ec39e28, 0xc008aa1a, 0xbf7dc4c2, 0xbe554950,
    0x3eeedbe5, 0xbf6cc5bb, 0xba7f6375, 0x3f1ea675,
    0xbfc4d3d6, 0xbe886ad7, 0x3f82cc09, 0x3d9bc6ed,
    0xbf9a8380, 0xbfe2ce54, 0x3f469c78, 0x3dae5af1,
    0xbfcb68ef, 0xbfcc0ce1, 0x3ebcc367, 0xc0740061,
    0x3f96b16c, 0xbec2ec7d, 0x3f4cb3e4, 0x3f46d093,
    0xbe2dc747, 0x3fd8bdb6, 0xbf923bd4, 0xc002c88b,
    0x3f3b3583, 0x3eefff4f, 0xbef55876, 0x3f3cba07,
    0x3f0123b9, 0xbf8dd488, 0xbf10b516, 0x3f168da0,
    0xbe8ab1d8, 0xbfd53359, 0x3f0931dd, 0x3e5df4fc,
    0x40119bce, 0xbea67efa, 0xbf3e8183, 0xbe3fb0fd,
    0x3f37ccf7, 0xbfb821fb, 0xbff8b2b7, 0x3e33a1f9,
    0xbea038c5, 0xc02b5170, 0x3da41f8f, 0xbffce604,
    0xbe743cbf, 0x3fbd8044, 0xbf596fc0, 0xc03efb4f,
    0x3f5562bf, 0xbf20786f, 0xbf39a7ac, 0xbfdf4c51,
    0x3de45f80, 0xbf721d05, 0xbf88cce1, 0xbfe75119,
    0xbea6ebbf, 0x3f5b8eb3, 0xbf1adecd, 0xbec70ad3,
    0x3e408fc1, 0xbf3c6c71, 0xbf6eb941, 0xbfeeb65e,
    0xbf08db07, 0x3fa8714f, 0x3e7953b8, 0x3f39054c,
    0xbf1bc967, 0xbd60cea7, 0xc004ed2a, 0xbf0575b8,
    0xbfb203bb, 0x3fa3ecf2, 0xbf3519bb, 0x3f87ba3b,
    0x3f32e5d7, 0xbfc048c0, 0x3f2eb09b, 0x3e01b4bd,
    0x3fade302, 0x3f2becdc, 0xbf1f3f18, 0xbe41a198,
    0xbe245386, 0xbf1c0c0d, 0xbf234934, 0x3e2b8ff7,
    0xbedc280b, 0x3f1cee9c, 0x3fdebecf, 0x4017bca7,
    0xbf84a0a3, 0xbf39ff45, 0x3d519603, 0xbf839f22,
    0xbfbf3b56, 0xbfc7dc6e, 0x3f80f48e, 0x3f293d4e,
    0xc041b6ef, 0x3f604201, 0xbe93a488, 0xbc92b2dc,
    0xbf2b25cb, 0x3e231584, 0xc0016888, 0x3e879f2a,
    0x3ec683b0, 0xbf5afe53, 0x3ea57d61, 0x3ee2b2e1,
    0xbddcba99, 0xbd5e0bba, 0xbf2059df, 0x3f8390dd,
    0x3eb8eaec, 0x3f80cb46, 0xbd4ff1b0, 0x3e5fc2cd,
    0x40273388, 0xbf87e36d, 0xbf190d80, 0xbfc2053c,
    0x3fb94c3e, 0xbc1825ba, 0x3f0eb3af, 0x3e3e5752,
    0xbfa0f7c6, 0xbfdd09d1, 0x3f0e8167, 0xbe803b0d,
    0x3fa1b519, 0xbcbeb0f1, 0x3e9df2bb, 0x3d2a038e,
    0x3f68a8c9, 0xbf1185ea, 0x3f286eb5, 0x3f89ada7,
    0xc008bfbe, 0x3e9a7c22, 0x3fbd27bf, 0x3e1a6523,
    0x3ec25130, 0xbeb54c9a, 0x3ffe099b, 0xbea7c92b,
    0xbfccc5c3, 0xbf73cffc, 0xbfcbe0e9, 0xbfd7b5c3,
    0xc01b9bd4, 0x3e33e110, 0xbf1232cc, 0x3fcb71b7,
    0xbefb1750, 0x3d46bc6a, 0x3f6276d1, 0xbf1fe149,
    0xbe170545, 0xbf4961cc, 0xbf593234, 0xbec67f19,
    0xbd08e66e, 0x3f74bc12, 0xbed10349, 0x3dd4211f,
    0xbee8d6e5, 0xbf62eb5d, 0xbddb0a6a, 0x3f0c6a2d,
    0xbedf75f9, 0xc05255c7, 0xbfb85b90, 0xbda989c9,
    0x3d90beef, 0x3f90d151, 0xbf229be5, 0x3e56de76,
    0x3fdfd47b, 0x3fe56dd6, 0xbf87ce76, 0x3f3bc5d9,
    0xbe891d6a, 0xbe68908c, 0x3ef151a8, 0xbfbd5924,
    0xbec52596, 0x3ec73d04, 0x3f16d604, 0x3ff2e25c,
    0xbf62e74e, 0x3fa7d893, 0xbfe6dd91, 0xbf5e6fc1,
    0xbedaef5b, 0xbc5ffcf5, 0xbfd68bbe, 0x3defbe04,
    0xc006d499, 0x3ff49d82, 0xc0054bf6, 0xbf79c20c,
    0x3f4a1022, 0x3f8c4ed4, 0x3fb9791a, 0x3f5b52d1,
    0xbe8414b7, 0xbfb4804e, 0xbf233c4b, 0x3f4de955,
    0x3f31f9f1, 0x3f25dcca, 0xbfc05337, 0xbc915099,
    0xbf3adcff, 0xc03be7cc, 0x3f81bc4e, 0x3f9d1438,
    0x3ff63137, 0xc01b45a2, 0xbf9e7adb, 0xbfe65c37,
    0x3f5ace4c, 0x3f516d4c, 0x3cecc626, 0xbf2547a9,
    0x3f9b1490, 0x3e84e792, 0x3fd0d9e1, 0x3d17277e,
    0x3e3dd817, 0x3f70802d, 0xbfbdd1d5, 0x3ff599cd,
    0x3fd6f12e, 0x401f47da, 0x401ca67e, 0x3fb4c90c,
    0x3e350125, 0xc04573ee, 0xbf269092, 0xbed9da8d,
    0xbebd0026, 0x3f0c12df, 0x3f6b6755, 0x3f2d988e,
    0x3f8d006b, 0x3ed4e903, 0x3da62dfe, 0x3fd9b621,
    0x3fa9d06d, 0x404a6608, 0x3f518ed6, 0xbf24d431,
    0xbfae0669, 0xbfe5f1e3, 0x3cc0451b, 0x3fbce0a5,
    0xbf080c30, 0x3f6178c5, 0x3f65e855, 0xbf492367,
    0x3f4d9571, 0x3e050211, 0xbf84d585, 0xbf6e6d26,
    0x3e8e8002, 0x3e1029cf, 0x3eb10188, 0xbd78815a,
    0xbf6207cc, 0xbf1e8b4d, 0x3e9d085e, 0x3ea275cc,
    0xbf240c2a, 0xbf910b0b, 0xbfb89295, 0xbcf658d5,
    0xbeceb221, 0x3fbacb79, 0x3e6cfcb7, 0xbfbd3c25,
    0xbf0590f0, 0x3f027e62, 0x3ff87dd1, 0x3ef23adb,
    0x3fa26bd8, 0xbe5e2e4a, 0xc016c2eb, 0xbf0baf41,
    0x3f790ed0, 0xbe2b8014, 0x3eae7ea6, 0x3e3a2ed1,
    0x3ec0b760, 0xbf02fac7, 0xbf8da000, 0x3f57d668,
    0x3ebaccb2, 0x3e25a158, 0xbca8273f, 0x400ecf78,
    0x3ef0c781, 0x3f3ddcd5, 0x3f04bfde, 0xbe7a91f4,
    0xbf252157, 0x3fb9ecca, 0x3f9a474c, 0xbd47d94a,
    0x3cd2c61b, 0x3f508154, 0x3fea85ee, 0xc007aa64,
    0xbf57af81, 0xbfd407c8, 0x3fae71d8, 0x3fb0727c,
    0xbd92976f, 0xbc900973, 0xbea638bd, 0xbfe64745,
    0xbf6348ac, 0xbb7b8c20, 0x3fc305c5, 0xbf3eb595,
    0xbe96b55c, 0x3f428e6a, 0x3f133d1a, 0xbf0a992d,
    0xbe0ae9e2, 0x3e648133, 0x3fbedf92, 0xbe1abf78,
    0xbf680e48, 0xbee7c65b, 0x3f3ae644, 0xbd9fc847,
    0xbff7d5bf, 0x3d4d0f2c, 0x3fa3d30a, 0xbfed4faf,
    0x3fe4405c, 0xbec3d313, 0x3f7a1948, 0xbe95e086,
    0x3ef39ca2, 0x3f56a245, 0xbf077c97, 0xbec793f5,
    0x3efbce35, 0xbfa17290, 0x400f50d7, 0x401e94c8,
    0x0
    };

static const uint32_t in_rfft_noisy_2048[2048] = {
    0xbd13c656, 0x3f04a3fe, 0x3f33f5a6, 0x3eefd0b3,
    0xbd9cd015, 0xbeea5940, 0xbf38a805, 0xbee71bb9,
    0xbcac8ab9, 0x3f1db1b5, 0x3f2fc69b, 0x3eef5b97,
    0x3d11c394, 0xbef094f3, 0xbf356fc5, 0xbf00f4a4,
    0xbd543efd, 0x3ec11652, 0x3f2d24f4, 0x3efacf30,
    0x3d314d54, 0xbf016058, 0xbf380932, 0xbf013048,
    0xbe045730, 0x3f0a370a, 0x3f4bff39, 0x3f0099ea,
    0x3d7c30d1, 0xbef4a727, 0xbf2c1998, 0xbeec3370,
    0x3c98ebb0, 0x3eeec5d3, 0x3efb4140, 0x3f09ceb9,
    0x3cd514e5, 0xbeca288a, 0xbf37fddd, 0xbefdc09e,
    0xbd68c6cf, 0x3f04fd1d, 0x3f1679b0, 0x3ef2cd48,
    0x3d4e2385, 0xbeef6433, 0xbf3b92c0, 0xbee85b83,
    0xbd557e40, 0x3f0a9df3, 0x3f346b3a, 0x3eeabf89,
    0xbcf6cae4, 0xbf0d728e, 0xbf2a01ae, 0xbf0524cd,
    0x3d1ad4c2, 0x3f0342a2, 0x3f3a3506, 0x3eeb1010,
    0xbcc33ffd, 0xbf0e92ce, 0xbf2c838e, 0xbeff1de6,
    0x3d4bdb5b, 0x3f0d6e35, 0x3f2844f7, 0x3f0a3fe1,
    0xbd6bb4fa, 0xbf0d9b1c, 0xbf37b1ad, 0xbedfba1f,
    0x3d580f9e, 0x3ed183aa, 0x3f2bf373, 0x3f019583,
    0xbaa66d77, 0xbef4d643, 0xbf3904d3, 0xbed847d5,
    0xbd105ea1, 0x3f039a0e, 0x3f2a077a, 0x3ee7751e,
    0xbce787d3, 0xbf0e4d4c, 0xbf38faac, 0xbefd9b8a,
    0xbcd6c266, 0x3f157096, 0x3f322d75, 0x3eeb5e9f,
    0x3d9fcf89, 0xbf0923c2, 0xbf39a0eb, 0xbf055e83,
    0x3ca2a56b, 0x3efd2a20, 0x3f25fad0, 0x3edc04e1,
    0xbd27a1ae, 0xbefd1827, 0xbf3d0897, 0xbef76d16,
    0xbd911676, 0x3ee50839, 0x3f2f3d4a, 0x3f0e805c,
    0xbcd5cbee, 0xbee0c408, 0xbf2bd37d, 0xbf00cb69,
    0x3bbee49c, 0x3ee04ba0, 0x3f3d0d3f, 0x3f113c40,
    0xbcc0db31, 0xbf060a6a, 0xbf56828a, 0xbf0f902c,
    0x3d87a29c, 0x3f0fa3ae, 0x3f176512, 0x3eea82fb,
    0x3d0109fd, 0xbee9f481, 0xbf47ce14, 0xbf140911,
    0xbd1e6c56, 0x3f0db5f2, 0x3f3d7b1d, 0x3f0a6e5b,
    0xbc2e7f62, 0xbf0df7ec, 0xbf3b861b, 0xbf0a6a07,
    0x3d53cb65, 0x3efc617f, 0x3f3fc188, 0x3f006612,
    0x3d14dc0a, 0xbef90b52, 0xbf34b802, 0xbefebbe1,
    0x3cb83b7c, 0x3f06dd2d, 0x3f4a1332, 0x3ef2ec65,
    0xbc16a63f, 0xbf137913, 0xbf47b900, 0xbed5d5ac,
    0xbcbed18e, 0x3ed4703a, 0x3f3b1ce7, 0x3f14a1fe,
    0x3e08bcf6, 0xbf0a9505, 0xbf44552f, 0xbf09b850,
    0x3da7cfc6, 0x3ee73114, 0x3f3ea2fd, 0x3f120058,
    0x3caf03c1, 0xbefeec3a, 0xbf35c524, 0xbef9549b,
    0x3cb6bb57, 0x3f0462ae, 0x3f31e829, 0x3ee16348,
    0xbd50a999, 0xbf07e1e3, 0xbf34e605, 0xbf0d1f95,
    0xbcf58dca, 0x3ef91fff, 0x3f4689f7, 0x3ee1ce82,
    0x3d1fe69c, 0xbee67918, 0xbf27991e, 0xbf1031eb,
    0xbb5ca90a, 0x3efdb7b5, 0x3f42155d, 0x3ee2781d,
    0xbd41e3ef, 0xbf12c5a6, 0xbf30a72f, 0xbeff600f,
    0xbb6fb66b, 0x3f031d44, 0x3f3628a8, 0x3efad917,
    0xbc847544, 0xbf087052, 0xbf2540db, 0xbef8ce25,
    0x3ca38639, 0x3f08a7d2, 0x3f28d7e0, 0x3f087f9a,
    0x3d81944e, 0xbf062436, 0xbf277d4d, 0xbee47591,
    0x3d538945, 0x3f083a5a, 0x3f3ec161, 0x3f0bd989,
    0x3d281c9e, 0xbef09a9a, 0xbf26637c, 0xbf06163e,
    0x3d0c500a, 0x3ef1b525, 0x3f2520ac, 0x3efd00e9,
    0xbd1b620b, 0xbef571d9, 0xbf4fe2ba, 0xbeea6be8,
    0x3b404698, 0x3ef8dfe4, 0x3f3638e3, 0x3ee49523,
    0xbce9af20, 0xbecf2340, 0xbf2b0d5b, 0xbf015d78,
    0xbd355e4d, 0x3f0b6bef, 0x3f2308e9, 0x3eed867c,
    0xbba7c040, 0xbed018b5, 0xbf293384, 0xbf1585ba,
    0xbb9d138c, 0x3f096737, 0x3f294d0f, 0x3f083751,
    0xbca854c1, 0xbee42338, 0xbf360c6e, 0xbf10186b,
    0x3cd679bb, 0x3ef8c386, 0x3f317a9b, 0x3f110a33,
    0x3d081d2b, 0xbee514bf, 0xbf39cbcd, 0xbef1fa68,
    0x3c27d9b4, 0x3ef9d0f2, 0x3f3b48b2, 0x3f068b04,
    0x3baba9f6, 0xbee400e1, 0xbf2e79b3, 0xbefa9de9,
    0x3c3ca5fe, 0x3edca7ab, 0x3f1ecfc1, 0x3f027012,
    0x3c4b382b, 0xbef67b5c, 0xbf1ddc01, 0xbeec92b7,
    0xbd1a1461, 0x3efd7e96, 0x3f499ed2, 0x3f0d470b,
    0xbd558c6e, 0xbeeeafcd, 0xbf3481ba, 0xbef13fce,
    0x3cf924ae, 0x3f02b0f7, 0x3f40638f, 0x3efdebc8,
    0xbdd83d9d, 0xbeef3681, 0xbf31257d, 0xbf0a5d5d,
    0x3cc3d4fa, 0x3ef3de26, 0x3f1cbda3, 0x3f04abb2,
    0x3ca5ee2b, 0xbf0109a4, 0xbf31ab91, 0xbf006761,
    0xbd8c9b22, 0x3ee68152, 0x3f26eb14, 0x3f02fad7,
    0xbcb0915c, 0xbf16df40, 0xbf2e4543, 0xbee1142f,
    0x3d6d61e9, 0x3eef699b, 0x3f342550, 0x3ebf363d,
    0x3d9db8b6, 0xbed84800, 0xbf383858, 0xbeffdc42,
    0xbd37e7e1, 0x3f0453de, 0x3f3fb58c, 0x3f09fd1e,
    0xbd8192ce, 0xbf0a69f2, 0xbf30619c, 0xbef1aeac,
    0x3d55871e, 0x3ef10c43, 0x3f32c559, 0x3f0aca46,
    0x3d357cb2, 0xbf024195, 0xbf36edb0, 0xbefea75b,
    0x3d852b70, 0x3ee7d8fb, 0x3f34e6fd, 0x3f150086,
    0x3c0077b9, 0xbf140516, 0xbf2c39f9, 0xbed13360,
    0xbd6a6a5a, 0x3ef5be22, 0x3f22c97d, 0x3f0db7d9,
    0xbd927999, 0xbf02c40f, 0xbf318508, 0xbf06f806,
    0xbd2178be, 0x3f076bf9, 0x3f1d6a08, 0x3f071bf5,
    0x39c877f3, 0xbf0619ca, 0xbf1f9ef8, 0xbefce02d,
    0x3d1ce9e2, 0x3ee843d7, 0x3f2321a6, 0x3f172bce,
    0x3cac5623, 0xbf07fa98, 0xbf3761a9, 0xbf175f59,
    0x3c32b667, 0x3f0cdc82, 0x3f29d2f6, 0x3ee94f2c,
    0xbd420181, 0xbf014eb5, 0xbf4931b2, 0xbefd2a77,
    0x3cb83793, 0x3effd587, 0x3f3708ab, 0x3f0e15af,
    0x3df5dd10, 0xbf0abd4a, 0xbf30cca8, 0xbf14377b,
    0x3c90b116, 0x3eee98b5, 0x3f42466b, 0x3efc3606,
    0xbd29d65e, 0xbef17e65, 0xbf32dcd2, 0xbeeebecd,
    0x3d6c718a, 0x3eea1367, 0x3f397125, 0x3efd29ca,
    0x3d0d116f, 0xbedcefcc, 0xbf2ef274, 0xbec7a3db,
    0x3c8f5919, 0x3edfb648, 0x3f2100d6, 0x3ef92149,
    0xbbce6109, 0xbeeba788, 0xbf341dd3, 0xbf1e6cb1,
    0x3c158a6e, 0x3f001359, 0x3f4c892d, 0x3f0c5415,
    0x3d633fa2, 0xbf06d8a4, 0xbf469f72, 0xbf11e58f,
    0x3d7bd610, 0x3eec69fb, 0x3f3b6df3, 0x3f016948,
    0xbd58aa6a, 0xbee0c8ad, 0xbf2c2b92, 0xbf1048ac,
    0x3c812b0c, 0x3ee7e4df, 0x3f350a18, 0x3f13294b,
    0xbd15bde4, 0xbef164dc, 0xbf43b49e, 0xbf189791,
    0xbda5d80e, 0x3f002dba, 0x3f2b53b7, 0x3f04c08f,
    0x3b342351, 0xbf04dcb8, 0xbf3990a0, 0xbed94f1b,
    0x3d98248c, 0x3f182061, 0x3f2b4b88, 0x3f0c5285,
    0x3df7a1c1, 0xbefadf72, 0xbf50005f, 0xbf0c6746,
    0x3c3113fc, 0x3f1d23ea, 0x3f269a00, 0x3f006ff0,
    0x3ce0d47d, 0xbf02d5b9, 0xbf2fc887, 0xbf11ae5c,
    0xbd883641, 0x3ef05108, 0x3f2e75e5, 0x3f00e648,
    0x3de2b718, 0xbefea392, 0xbf2fb823, 0xbec24c21,
    0x3c9dfb8c, 0x3f0ef11f, 0x3f28580b, 0x3f05831c,
    0xbc12b322, 0xbf093b3a, 0xbf30bd43, 0xbf0f4242,
    0x3dadf63e, 0x3f125759, 0x3f38ebc7, 0x3f0c2cd6,
    0x3d8b9e6e, 0xbefbcd0a, 0xbf35f3ed, 0xbf10b781,
    0x3cb2f134, 0x3eeebe4f, 0x3f22858f, 0x3f08b8c7,
    0xbce6a2fd, 0xbed6af1e, 0xbf371f75, 0xbee8566a,
    0xbc437233, 0x3ee50ca2, 0x3f376c5d, 0x3eda1fd7,
    0x3ce160d9, 0xbed87131, 0xbf266710, 0xbf02b1b6,
    0x3d8c5b9f, 0x3ee28832, 0x3f4abd21, 0x3f03cdb3,
    0x3cbdf13d, 0xbf04af1e, 0xbf3f607d, 0xbf174909,
    0xbd5bcfb5, 0x3edfa334, 0x3f4554fd, 0x3f03e64b,
    0xbd2f61ca, 0xbeed5a18, 0xbf28e3ab, 0xbf13b7d1,
    0x3c637eec, 0x3f16da1f, 0x3f2a5111, 0x3f0b817a,
    0xbd65e62b, 0xbed2a4e5, 0xbf331671, 0xbf122962,
    0xbcf6ccd6, 0x3edd15ce, 0x3f211520, 0x3ee7d053,
    0xbd15dada, 0xbf006bc0, 0xbf376c11, 0xbed5775b,
    0x3c72f01f, 0x3f057063, 0x3f364f7c, 0x3f073b84,
    0xbcede755, 0xbf057b6e, 0xbf3b3a24, 0xbefcd641,
    0x3d4e10fd, 0x3f00c8e9, 0x3f2bd726, 0x3ec29ee9,
    0x3d2a7e84, 0xbef0dec8, 0xbf343019, 0xbef4488e,
    0xbc8a097e, 0x3ec5bdd9, 0x3f375351, 0x3f0d266d,
    0xbc3b54aa, 0xbeddc6b4, 0xbf3a2d55, 0xbf0e4238,
    0xbc256099, 0x3f014d3f, 0x3f20016d, 0x3f067604,
    0xbdb05f77, 0xbf084a30, 0xbf1c07fc, 0xbf04df63,
    0xbd7a6e9c, 0x3f0b4237, 0x3f2afb44, 0x3f134936,
    0xbc1cd12f, 0xbf0b7ebe, 0xbf3be0d4, 0xbf044c89,
    0xbcc4eaee, 0x3f0a0b1f, 0x3f1d9da3, 0x3efc3098,
    0xbc833a1c, 0xbede7d98, 0xbf3d6a17, 0xbf0dbcf3,
    0xbbe85611, 0x3f03188b, 0x3f381a98, 0x3eef4a92,
    0xbd186f59, 0xbee7efc4, 0xbf35a79b, 0xbee9dea5,
    0xbc9ba85f, 0x3f09f60a, 0x3f3dac58, 0x3f057c94,
    0xbd3e359e, 0xbf009c8d, 0xbf456448, 0xbf0540f9,
    0xbb8533e0, 0x3f060c48, 0x3f1f685b, 0x3f098f36,
    0xbcb63cfb, 0xbf043c5a, 0xbf3159ee, 0xbef766b1,
    0xbd966829, 0x3f0e0ae5, 0x3f1ca376, 0x3f080ec6,
    0xbd9f4ad8, 0xbf00a692, 0xbf31aede, 0xbefcc331,
    0x3ce277c3, 0x3f0ffbc0, 0x3f321620, 0x3f023c01,
    0x3c71fdda, 0xbf0801b5, 0xbf3c1464, 0xbf0f8ea7,
    0xbd0a11f2, 0x3efd0b84, 0x3f425c08, 0x3f0b9129,
    0xbc7e931a, 0xbef13c83, 0xbf304cfc, 0xbefb4dbb,
    0x3c20c662, 0x3f0da988, 0x3f2bd772, 0x3efda325,
    0x3de7b63f, 0xbeea098c, 0xbf2f0524, 0xbf094c43,
    0xbd8847de, 0x3f1de340, 0x3f335af9, 0x3ead14bb,
    0x3d5a0e0a, 0xbf021d73, 0xbf22ab0e, 0xbee28d6c,
    0xbcc50e57, 0x3edf004b, 0x3f418f19, 0x3f09cac6,
    0x3d2257ab, 0xbef6768d, 0xbf2b7a76, 0xbefd3959,
    0xbc24c825, 0x3eb48972, 0x3f1f906e, 0x3f066650,
    0x3c8b8b82, 0xbeec77b9, 0xbf296835, 0xbf047aba,
    0x3dd675c2, 0x3ef204ac, 0x3f48885e, 0x3eeada21,
    0xbc42f4cd, 0xbefa004c, 0xbf32f44b, 0xbf082b35,
    0xbb91ea85, 0x3f0b9306, 0x3f232cad, 0x3ee8d126,
    0x3c6965bb, 0xbefffe66, 0xbf43c5c7, 0xbee5d036,
    0xbd7073ba, 0x3eeeea4c, 0x3f38d937, 0x3f0b64df,
    0x39dddd7e, 0xbef377ae, 0xbf3468e1, 0xbf090773,
    0xbd3e333e, 0x3efe8511, 0x3f40ff63, 0x3f14ea44,
    0xbdbad094, 0xbef48725, 0xbf1cb0c4, 0xbf13539f,
    0x3d08bb40, 0x3efff373, 0x3f386238, 0x3ee8f44b,
    0x3c894c1d, 0xbedcdebc, 0xbf2b59b0, 0xbf019ca2,
    0x3d77b908, 0x3ee47091, 0x3f26bcd0, 0x3efec916,
    0x3dc6f74c, 0xbf0576c6, 0xbf2a78a4, 0xbf0a000a,
    0x3d9ce4bb, 0x3ef9b0d4, 0x3f3683b5, 0x3ed0d048,
    0xbcc0ebb6, 0xbef87966, 0xbf3ec900, 0xbef9d2b7,
    0x3dcd08eb, 0x3ef4bfb9, 0x3f334d01, 0x3f076a6c,
    0x3d1c8802, 0xbef0c258, 0xbf3c70d6, 0xbee2425c,
    0x3d14900b, 0x3f016db7, 0x3f435869, 0x3f034bb9,
    0xbc879a2d, 0xbf039ee3, 0xbf313b5a, 0xbef6b993,
    0xbc52c539, 0x3ef5d726, 0x3f3581ac, 0x3efa27ea,
    0xbd232b6e, 0xbece2074, 0xbf438021, 0xbf0b3ff2,
    0xbb826a56, 0x3f0afe7a, 0x3f328e09, 0x3ef32aab,
    0xbbce8126, 0xbef83294, 0xbf30ce1d, 0xbef10d1b,
    0x3c549756, 0x3f04ab24, 0x3f2dad59, 0x3ee481b4,
    0x3d86dfb7, 0xbf0691d8, 0xbf21b1ac, 0xbf05360f,
    0x3c63f778, 0x3ef45ee2, 0x3f2c5cf2, 0x3ee147e5,
    0xbc6c9c27, 0xbed6705a, 0xbf24d893, 0xbeef00dd,
    0xbd7a1951, 0x3efd8774, 0x3f3b2974, 0x3efd6bb4,
    0x3b8a1551, 0xbec8edc6, 0xbf265dd3, 0xbed33976,
    0xbd592375, 0x3eefa92d, 0x3f3e0a1c, 0x3ee99228,
    0xbcc88ea8, 0xbf10ef68, 0xbf38b486, 0xbf0efa3f,
    0xbbfb1a13, 0x3f0e5a8d, 0x3f2c9a43, 0x3ef83d90,
    0xbd9cefb9, 0xbef68f35, 0xbf38e20f, 0xbebabd01,
    0xbcaa576f, 0x3f0cfc83, 0x3f18933f, 0x3f061218,
    0xbd0594e2, 0xbeeeab8e, 0xbf3890ce, 0xbf05e89e,
    0xbc885302, 0x3f0ecb02, 0x3f213390, 0x3efc1fd5,
    0xbce1087c, 0xbf00fa20, 0xbf4b8460, 0xbefecef7,
    0xbbc2dffc, 0x3ef5ddb2, 0x3f355d5c, 0x3ee8db1c,
    0x3d95980b, 0xbeee4149, 0xbf2358e4, 0xbf034835,
    0xbdd204b5, 0x3ed4b5c1, 0x3f2d4040, 0x3efa9764,
    0x3d845eb4, 0xbf05fc89, 0xbf2b9202, 0xbeed5e1a,
    0xbd967cf3, 0x3efd14e0, 0x3f35a862, 0x3efe2641,
    0xbdd37d15, 0xbefb1cbc, 0xbf4ada5e, 0xbf1989e3,
    0x3d68ba24, 0x3ede486c, 0x3f1eef77, 0x3f08b7c1,
    0x3cfd1ce9, 0xbf014d8e, 0xbf2a99d5, 0xbf0712ab,
    0x3d577ca3, 0x3f1f077a, 0x3f2b2567, 0x3edefc50,
    0xbc05dca0, 0xbee4f653, 0xbf2f0e7b, 0xbef186ca,
    0xbdc55c72, 0x3ed43e61, 0x3f39c68f, 0x3ee2ffc2,
    0xbc359b79, 0xbeea9772, 0xbf2948cd, 0xbee5387a,
    0xbc4c1ded, 0x3f019ca0, 0x3f2c95dc, 0x3ee56bef,
    0xbd32ec2c, 0xbf0b0bda, 0xbf2c8773, 0xbf01cfb7,
    0xbd3b8c2c, 0x3f012e79, 0x3f2fce9f, 0x3ef5a7ef,
    0xbc682bab, 0xbf024045, 0xbf3bc310, 0xbeeacbab,
    0xbc91e0ed, 0x3f0c1816, 0x3f3cfc6f, 0x3ef0e042,
    0x3da68ea8, 0xbef2a33d, 0xbf3beb54, 0xbf12233b,
    0x3d1a08ac, 0x3ef765e6, 0x3f329834, 0x3f11c64b,
    0xbc117da5, 0xbede3a94, 0xbf1978f4, 0xbeee76c9,
    0x3d228105, 0x3f26cf58, 0x3f1c4c3e, 0x3f077714,
    0x3d8cc49a, 0xbef9c3fc, 0xbf2e441f, 0xbf0abfe0,
    0x3d407c3e, 0x3ef0d99d, 0x3f43fc01, 0x3f0cd752,
    0xbd885c22, 0xbf092b2b, 0xbf29e738, 0xbef3e219,
    0x3cebe0d6, 0x3f088b69, 0x3f1f484e, 0x3eefa76d,
    0x3d55b382, 0xbf0a9e48, 0xbf3029f8, 0xbeda5bf1,
    0xb981d58f, 0x3ef836e3, 0x3f2efb3f, 0x3f147de1,
    0xbd105b32, 0xbf0cb4b4, 0xbf44aef0, 0xbefc7317,
    0x3c6f4bb5, 0x3f045ebb, 0x3f2247dd, 0x3f170b35,
    0xbb80222d, 0xbf12e602, 0xbf3fee70, 0xbef29886,
    0xbdefea7b, 0x3f0d9ecc, 0x3f3d522d, 0x3f14b5f8,
    0xbdb12e61, 0xbf062f47, 0xbf3ff3a3, 0xbef05fad,
    0xbdfb4147, 0x3ee74f88, 0x3f4942a9, 0x3f05d6b1,
    0x3da2c440, 0xbf071aa1, 0xbf3b4e82, 0xbeefac81,
    0x3d41cab7, 0x3f1047b0, 0x3f40801b, 0x3efc7269,
    0xbdc2768b, 0xbef3b9ce, 0xbf3b3f0a, 0xbf0501b4,
    0xbccaeada, 0x3ee6988f, 0x3f2f73bd, 0x3ef9ef09,
    0x3db993a4, 0xbf057c22, 0xbf395b73, 0xbefdaa54,
    0xbd146c27, 0x3f0ab823, 0x3f37f716, 0x3eea41a6,
    0x3c09eee8, 0xbef2c535, 0xbf363431, 0xbf023f95,
    0x3c804d2c, 0x3eebd33d, 0x3f21a40d, 0x3f079ada,
    0x3cb973af, 0xbf129fe9, 0xbf4fd99f, 0xbef14ac7,
    0x3d2015a5, 0x3ef72082, 0x3f412255, 0x3f0329fb,
    0x3d932356, 0xbeecbc3f, 0xbf3b9731, 0xbef4500e,
    0x3bff93fc, 0x3f009315, 0x3f3d538e, 0x3ef63faf,
    0x3d4b3c71, 0xbeebc81b, 0xbf308364, 0xbedf249e,
    0x3e013c93, 0x3ef83fd8, 0x3f2e70b7, 0x3f014bd6,
    0xbcfe5ece, 0xbf13ada0, 0xbf2271d1, 0xbedd5e10,
    0x3d55519a, 0x3efb9bd2, 0x3f303b3a, 0x3f0d70aa,
    0xbbf4b93d, 0xbf02718e, 0xbf379766, 0xbef30d17,
    0xbbce75e8, 0x3efabb91, 0x3f2bdf1f, 0x3ed977bb,
    0xbda1c670, 0xbeeb8961, 0xbf2ec7aa, 0xbf04c437,
    0x3d3d1593, 0x3eb58831, 0x3f27fa25, 0x3f00f36a,
    0x3d7c95ee, 0xbf102fc5, 0xbf23c09a, 0xbf0211cf,
    0xbd4578b8, 0x3f0fb3bb, 0x3f2f4a88, 0x3f09dc53,
    0xbc067f18, 0xbedc27d2, 0xbf4ad23b, 0xbf04368f,
    0xbd41eccb, 0x3f04915d, 0x3f2d4e51, 0x3ef9e09b,
    0x3d97a3b3, 0xbf017ed7, 0xbf3bafb6, 0xbeedde66,
    0x3c6d86b2, 0x3ede922a, 0x3f2dab48, 0x3f1c0b74,
    0xbd192c72, 0xbf05452b, 0xbf3614ad, 0xbf00acd4,
    0xbd174889, 0x3eeebec5, 0x3f27b823, 0x3f052315,
    0xbcb8a8fd, 0xbef87162, 0xbf2d1dea, 0xbf0ad4aa,
    0xba954c5b, 0x3f142d19, 0x3f36a40c, 0x3f06ee06,
    0xbd07ba64, 0xbeee3466, 0xbf2d828c, 0xbed2ecad,
    0x3e0833e6, 0x3efc7632, 0x3f2d89cb, 0x3f100f12,
    0x3bcee03b, 0xbefe2187, 0xbf1fb0e4, 0xbed1209c,
    0x3c821f66, 0x3eeff519, 0x3f2f4348, 0x3edf5f37,
    0xbd2f2df4, 0xbef65df3, 0xbf22950c, 0xbf0b0452,
    0x3b4d5bf5, 0x3f07219d, 0x3f38d541, 0x3f0970dc,
    0x3cd3d338, 0xbef78f13, 0xbf26d454, 0xbf047057,
    0xbd33bbe1, 0x3f0d18df, 0x3f4e7ef8, 0x3f0ffa05,
    0x3d5da755, 0xbef13eb5, 0xbf315fd8, 0xbefa958d,
    0x3b7bf475, 0x3ee43799, 0x3f3cabf5, 0x3edd1d79,
    0xbd6340e1, 0xbee3689e, 0xbf361c69, 0xbf153fda,
    0x3beb5d81, 0x3ef79771, 0x3f35c023, 0x3f0d1107,
    0x3d496d82, 0xbf05692c, 0xbf41d7a5, 0xbef63552,
    0x3c68feb7, 0x3ee2d194, 0x3f3003d2, 0x3efa63fd,
    0x3da268cd, 0xbf010799, 0xbf2dbee9, 0xbf098584,
    0x3d079e3c, 0x3eefad38, 0x3f273275, 0x3ee238e6,
    0x3c03e25e, 0xbf0c6609, 0xbf43e13a, 0xbefd9ea2,
    0x3d288458, 0x3f1a70e8, 0x3f3533e8, 0x3eeb72cb,
    0xbc9ecd52, 0xbf11144d, 0xbf2b72f9, 0xbf06eb6d,
    0xbc6bfb0d, 0x3ed41f9d, 0x3f2e7142, 0x3ee01773,
    0xbd339070, 0xbef49d13, 0xbf2a3d13, 0xbf0cb9bb,
    0xbd24090a, 0x3f0ce9f1, 0x3f36f0c9, 0x3ef56922,
    0xbd1924e5, 0xbf0082cd, 0xbf27264f, 0xbf05bef5,
    0xbd247658, 0x3f130553, 0x3f49433f, 0x3ef8873e,
    0x3cab5fde, 0xbf0440da, 0xbf368377, 0xbeefdb99,
    0x3c95227b, 0x3edc57eb, 0x3f2fe40b, 0x3efc54ba,
    0x3cef158e, 0xbf097504, 0xbf3d11c8, 0xbf060269,
    0xbbe66a72, 0x3f01f37b, 0x3f305203, 0x3f00903d,
    0x3d1f316b, 0xbf0ca8f1, 0xbf34a262, 0xbf0c6cda,
    0xbd85e9fa, 0x3f0553a9, 0x3f457494, 0x3ecc32c1,
    0x3d1a8086, 0xbef862c7, 0xbf235e05, 0xbf0e5201,
    0xbcb86237, 0x3ee8eff3, 0x3f307ce6, 0x3ef5c775,
    0x3ceb9658, 0xbf094a38, 0xbf3e62a5, 0xbf12be33,
    0xbd8cd1b6, 0x3f14fc30, 0x3f35ed72, 0x3f077528,
    0x3bb8e406, 0xbf078ea4, 0xbf34ede4, 0xbee78bb3,
    0x3cc0e5c5, 0x3ee85cd0, 0x3f2cb823, 0x3ed50e2a,
    0xbcfe942d, 0xbf085878, 0xbf3d8b8f, 0xbef5d82c,
    0x3d2aac55, 0x3f0d67e9, 0x3f2552d2, 0x3ed7bc4b,
    0x3d864467, 0xbf0c4941, 0xbf47302b, 0xbf1478fd,
    0xbc012ceb, 0x3f06edbd, 0x3f1efa01, 0x3edf2abd,
    0x3b5da37c, 0xbef34e22, 0xbf43c952, 0xbf1252f9,
    0xbc9056f3, 0x3ee4b43a, 0x3f1e321c, 0x3f093cd0,
    0xbc909b21, 0xbf09d86b, 0xbf32d539, 0xbf1afd51,
    0x3d394dd4, 0x3eede50b, 0x3f1f2d6f, 0x3ee73016,
    0xbdde7189, 0xbf0073a7, 0xbf333f5f, 0xbed99c39,
    0x3d5fa5d4, 0x3efb3e38, 0x3f3642af, 0x3ef29222,
    0x3c259bad, 0xbef0faec, 0xbf32f685, 0xbf0a6c4f,
    0x3b08a25f, 0x3f0407fe, 0x3f3b57ee, 0x3ee260bd,
    0xbc463ebf, 0xbef23bc6, 0xbf3caaa0, 0xbedf642e,
    0xbc950fd0, 0x3efb914f, 0x3f41510d, 0x3f04d30b,
    0xbd5ba0cd, 0xbec3cf2f, 0xbf2c4884, 0xbee5b55a,
    0xbbc2078c, 0x3eefb757, 0x3f3a7c5e, 0x3f298117,
    0x3dab8b56, 0xbefcd9e7, 0xbf28f4fb, 0xbefb3cd5,
    0xbd1891fb, 0x3efbbc90, 0x3f330f50, 0x3f0d645d,
    0xbcec8d4a, 0xbf039838, 0xbf2519c5, 0xbee9a906,
    0xbd0a3ffc, 0x3f08cde2, 0x3f397d05, 0x3eeabbe0,
    0xbd2032d6, 0xbf1a54ae, 0xbf1de6f0, 0xbee22308,
    0xbc4f9cf5, 0x3f087623, 0x3f3eea75, 0x3ef1ae61,
    0x3dd52650, 0xbf07547b, 0xbf381b9c, 0xbefaba00,
    0xbcb45a91, 0x3ef5eef6, 0x3f3bad91, 0x3efa061c,
    0xbaceea24, 0xbed3168d, 0xbf2b83d5, 0xbeb209ce,
    0xbd1c123c, 0x3efb2f46, 0x3f20cccd, 0x3ed3f3c1,
    0x3c016b87, 0xbee6dc1c, 0xbf21e583, 0xbef6dfe2,
    0xbd3b1888, 0x3ee815d6, 0x3f153781, 0x3eef1717,
    0xbdd38c81, 0xbefbc5a9, 0xbf2683a9, 0xbf08a424,
    0xbd23daa7, 0x3ef14275, 0x3f2c9c11, 0x3f112bf0,
    0xbd84fd70, 0xbef99bf3, 0xbf365c3e, 0xbeee25f0,
    0x3ca51458, 0x3ec94f86, 0x3f2c2aa8, 0x3f0e4664,
    0x3cd7911f, 0xbf049609, 0xbf38a082, 0xbef5438e,
    0xbd9b3218, 0x3f0227b9, 0x3f2de60d, 0x3edd87f6,
    0xbbf095b9, 0xbeec4a65, 0xbf35f8d8, 0xbf07d0f8,
    0x3d07dc14, 0x3f072ab0, 0x3f3fedb0, 0x3f118a8d,
    0xbdace51c, 0xbf11d6d0, 0xbf32524e, 0xbef34975,
    0xbbff6c3c, 0x3f07f9de, 0x3f461a96, 0x3eeca941,
    0x3d16ebe6, 0xbf0be883, 0xbf22b5fe, 0xbed7366b,
    0x3da2b394, 0x3eb8261e, 0x3f35fabe, 0x3ef7af57,
    0x3db46f1f, 0xbf088e3a, 0xbf400f13, 0xbef73542,
    0xbe00c746, 0x3ee47a2c, 0x3f36e9f8, 0x3f08a02e,
    0xbd56ae78, 0xbf02a07c, 0xbf2a60e2, 0xbeffb4e2,
    0x3d8acdf9, 0x3ece2419, 0x3f3578ec, 0x3f0b468f,
    0xba731516, 0xbedf9b63, 0xbf318246, 0xbf0ee447,
    0x3c970870, 0x3ef56ce4, 0x3f260132, 0x3f0a64be,
    0x3b05843b, 0xbf02d1f8, 0xbf240f81, 0xbef15adf,
    0x3c24f24b, 0x3ec7747e, 0x3f401601, 0x3ef75bf0,
    0xba83e397, 0xbf00df7c, 0xbf26d1a7, 0xbeed267e,
    0x3c2ca1ec, 0x3ee5494b, 0x3f38f927, 0x3f17cbc6,
    0xbc66ff1a, 0xbefa2e35, 0xbf2ecd80, 0xbee9b187,
    0x3cd602d2, 0x3f0cdfed, 0x3f460308, 0x3ee04436,
    0xbd507620, 0xbefe648a, 0xbf4702c1, 0xbf069561,
    0x3d61803a, 0x3f0364d5, 0x3f275576, 0x3ef7e5ca,
    0xbc171852, 0xbeda4a8c, 0xbf405c03, 0xbef6329b,
    0xbc467e01, 0x3ef52b0c, 0x3f18f4b7, 0x3f016858,
    0x3bf96c69, 0xbee9837f, 0xbf21a4e3, 0xbec25e02,
    0x3c3e0e95, 0x3f05a719, 0x3f201bde, 0x3ee75d36,
    0x3d0dcf83, 0xbf06aac1, 0xbf27bc36, 0xbede45f1,
    0x3d136d6f, 0x3f05ddf1, 0x3f3a3b3f, 0x3edce2e5,
    0xba87cffe, 0xbf0583e0, 0xbf2f9a41, 0xbef51386,
    0x3d44a0a7, 0x3f081b16, 0x3f211770, 0x3eec06cd,
    0xbd1d13e9, 0xbefb4e3a, 0xbf2a6b81, 0xbf08acb4,
    0x3c2aa7d8, 0x3ef07847, 0x3f3287a4, 0x3ec4c5e7,
    0x3d741e60, 0xbee10d48, 0xbf30a3cb, 0xbf0436d9,
    0xbce11abb, 0x3edecf44, 0x3f2ef421, 0x3ef4d6c1,
    0xbc59f9be, 0xbf0f31f0, 0xbf30bf86, 0xbf003648,
    0xbd32db5c, 0x3edfb7ef, 0x3f35e9ba, 0x3ef668e0,
    0x3d93e2ae, 0xbee676af, 0xbf376b25, 0xbeef0d90,
    0x3cb1a703, 0x3f1771ca, 0x3f2b20e7, 0x3f0ba777,
    0x3b44c413, 0xbeed7328, 0xbf3bc2b6, 0xbf04f956,
    0x3c6f2012, 0x3efb08d7, 0x3f39990e, 0x3f0c9cb4,
    0x3e073cf8, 0xbeff18e9, 0xbf2a9321, 0xbeea7254,
    0x3cabfea9, 0x3f04cf4b, 0x3f5223e9, 0x3efbdd67,
    0x3bbd0384, 0xbf020e06, 0xbf2628bd, 0xbf01c264,
    0x3d22e71d, 0x3f0020c5, 0x3f225ced, 0x3eee643c,
    0xbd5cd70e, 0xbefcae57, 0xbf1b5ed7, 0xbefa72cd,
    0x3da5b94c, 0x3f01cd5d, 0x3f2f2ade, 0x3edf822d,
    0xbb86baf9, 0xbee2f146, 0xbf25466d, 0xbefc8462,
    0xbd13abc1, 0x3f0c08de, 0x3f326533, 0x3f021a1b,
    0x3c086433, 0xbeeb7540, 0xbf24d918, 0xbef25d7d,
    0xbd7001e9, 0x3ef3f12a, 0x3f2b8862, 0x3f24227d,
    0xbb99a79f, 0xbf069c16, 0xbf3724a5, 0xbf058aee,
    0x3cbc4b53, 0x3eebd805, 0x3f3a59f8, 0x3f009a80,
    0xbd585b9b, 0xbee01213, 0xbf35e2ec, 0xbefa397d,
    0xbd867221, 0x3eef6232, 0x3f37ebd1, 0x3ef3806d,
    0xbd2701fb, 0xbee2a35e, 0xbf3afc3b, 0xbf16d15c,
    0xbcb200fd, 0x3f0722ba, 0x3f2074bb, 0x3efb6ee6,
    0x3d728af6, 0xbeeda249, 0xbf245b75, 0xbf063c00,
    0x3dde344c, 0x3f0285ec, 0x3f35aace, 0x3f033936,
    0x3c84a846, 0xbf00ebb6, 0xbf38a99a, 0xbeeff2c3,
    0xbda5a904, 0x3f01f710, 0x3f209c3b, 0x3ef59837,
    0xbaedda84, 0xbef68b6b, 0xbf304c2c, 0xbf0b680a,
    0xbd0dc4f4, 0x3f086280, 0x3f2cf69b, 0x3ee5e41e,
    0xbd6e2414, 0xbee1f2ee, 0xbf38eb55, 0xbefbad30,
    0xbd4ef19c, 0x3ef673fe, 0x3f350364, 0x3eeff7bf,
    0x3d6c94d1, 0xbf0456a8, 0xbf2aae3a, 0xbf0c7a1f,
    0xbd3529c2, 0x3efd4e1d, 0x3f297bce, 0x3f0db59f,
    0x3d60b0dc, 0xbf00a647, 0xbf2ba996, 0xbf183fc1,
    0x3c76d548, 0x3f032880, 0x3f1a2e80, 0x3ef9b9d6,
    0x3d39d4fe, 0xbf041832, 0xbf4368d7, 0xbf138fae,
    0xbdbbac3f, 0x3f0cf370, 0x3f445726, 0x3f0b25b6,
    0x3c80b145, 0xbef89b3b, 0xbf2940c1, 0xbf10f649,
    0xbcf101cf, 0x3ef9b53d, 0x3f349734, 0x3efab9d8,
    0xbd209787, 0xbf03b694, 0xbf3586ce, 0xbef563c8,
    0x3c3d07dc, 0x3f0ba9a3, 0x3f2a0f1d, 0x3f060921,
    0xbb710f42, 0xbf0a8c56, 0xbf30f107, 0xbefaf891,
    0x3d21932c, 0x3f04df96, 0x3f3c4bd0, 0x3effe8cb,
    0xbc7b9087, 0xbef9781d, 0xbf3c15a3, 0xbeece937,
    0xbd335103, 0x3f05ec94, 0x3f1d5ded, 0x3f0ecc4a,
    0xbd196f13, 0xbef37e59, 0xbf18ef4b, 0xbf02cbfd,
    0xbd536641, 0x3ef63ffd, 0x3f380cb9, 0x3f06cfe9,
    0x3dbcf00a, 0xbec23ceb, 0xbf2926a0, 0xbef2177b,
    0x3b0aa7a1, 0x3f0b9025, 0x3f2de741, 0x3eefafb6,
    0xbc906615, 0xbee91bd9, 0xbf2842cf, 0xbf0dc9de,
    0xbd270859, 0x3f00c8c3, 0x3f313c35, 0x3f0052ce,
    0x3dabaa9c, 0xbefc5427, 0xbf2dd24e, 0xbf063da0,
    0x3a8d8714, 0x3f19d8b1, 0x3f2b7e7f, 0x3ef4496a,
    0x3d861103, 0xbf044391, 0xbf3607df, 0xbf07415e,
    0xbc7d4a59, 0x3f034d6f, 0x3f224a3b, 0x3ee16dff,
    0xbda172d7, 0xbef205f7, 0xbf327456, 0xbed440ef,
    0x3dd4f6e3, 0x3effe788, 0x3f40b264, 0x3edfc41c,
    0xbbc816d0, 0xbeeebfa0, 0xbf2eac27, 0xbee9f07e,
    0x3b966ab1, 0x3eec9fd0, 0x3f235794, 0x3f03405b,
    0x3cb71c5f, 0xbf1347f2, 0xbf251a0b, 0xbee2224b,
    0xbd71f418, 0x3ef68b57, 0x3f2cce0a, 0x3ef6454d,
    0x3db54fff, 0xbf13389e, 0xbf280a95, 0xbef161c5,
    0xbdea85bc, 0x3eeb348d, 0x3f240fcd, 0x3ef4b436,
    0x3ce0486f, 0xbf139626, 0xbf348eea, 0xbf160ee7,
    0xbd9dc6eb, 0x3f0e85bf, 0x3f34d5f8, 0x3f0686c2,
    0x3d8e4dad, 0xbee2cd7b, 0xbf37e742, 0xbee813c0,
    0xbd37fe53, 0x3ed60a96, 0x3f379f62, 0x3f07adb3,
    0x3cbb1a66, 0xbf02fb8b, 0xbf35c38f, 0xbf1887fe,
    0x3cafc758, 0x3f028a1c, 0x3f355aae, 0x3eba59bc,
    0xbd817c59, 0xbedf3976, 0xbf3935c9, 0xbf065a21,
    0xbdf82183, 0x3f04bbbc, 0x3f4168a1, 0x3ef7aa35,
    0xbdcff803, 0xbed8f2e2, 0xbf0e380b, 0xbf03ad4e,
    0x3d500342, 0x3f00bf6b, 0x3f3ab549, 0x3ef9b091,
    0xbd64e70b, 0xbeee6eed, 0xbf3ba6f2, 0xbeff125c,
    0xbcf68adc, 0x3f018ca6, 0x3f3dfdd5, 0x3f0d213f,
    0x3d0e49e0, 0xbf06f7b0, 0xbf4c7b1c, 0xbef742a1,
    0xbc866efa, 0x3f028c46, 0x3f2ab3d3, 0x3ef9454b,
    0xbd5f6fd1, 0xbf14a51b, 0xbf1bc3db, 0xbf07f543,
    0x3db14513, 0x3ef2a6ab, 0x3f1f534b, 0x3f04a666,
    0x3d31c14d, 0xbf14432b, 0xbf2afff5, 0xbf012b02,
    0x3cedd3d8, 0x3f065c2f, 0x3f1e7446, 0x3f11871c,
    0x3d08f374, 0xbf072130, 0xbf258ef4, 0xbee4c245,
    0x3d1f8cc8, 0x3edd1c48, 0x3f1b5b57, 0x3f113865,
    0xbca9425e, 0xbee6599f, 0xbf43000f, 0xbefe671a,
    0x3c85b312, 0x3ef82ec1, 0x3f15f538, 0x3f0b73a5,
    0xbbe3f0c4, 0xbf028ecb, 0xbf390a9e, 0xbf03ae96,
    0xbcd5f5ef, 0x3ee58c24, 0x3f2866ac, 0x3f02eb30,
    0xbd0c5bcd, 0xbed5e6e3, 0xbf3781a1, 0xbefdb5cc,
    0x3c3346a9, 0x3ef7efc3, 0x3f241b77, 0x3f127208,
    0x3d421847, 0xbf0fbd7a, 0xbf384c03, 0xbeea1a97,
    0x3d031797, 0x3f056de5, 0x3f2b07df, 0x3f0433ef,
    0x3cea62ff, 0xbf0507ad, 0xbf3ad6eb, 0xbeedd04e,
    0x3d5f9751, 0x3f138a81, 0x3f32abdb, 0x3f15eb2a,
    0x3df5bb0f, 0xbf0c5ee9, 0xbf40a41b, 0xbf02e48f,
    0x3c97f183, 0x3f15e6e3, 0x3f378c81, 0x3ee78ffb,
    0xbd283d63, 0xbf09430c, 0xbf24b01b, 0xbf036e0d,
    0x3d37bde7, 0x3f048243, 0x3f298eaf, 0x3f1afcaa,
    0xbd1d07f5, 0xbf037ccf, 0xbf366dd2, 0xbeef2db6,
    0xbc5d5a58, 0x3f1b9a03, 0x3f3a9813, 0x3ef01938,
    0x3d1d2a4c, 0xbeec236c, 0xbf507d30, 0xbee40b12,
    0x3db058fe, 0x3f07be8a, 0x3f332718, 0x3ef2badd,
    0xbd8a2f1e, 0xbef866d0, 0xbf3d086a, 0xbef993ea,
    0x3dde93b4, 0x3ee2f164, 0x3f3e68c4, 0x3edfb2d5,
    0x3c83ea26, 0xbed15c6b, 0xbf34baa4, 0xbef075d8,
    0x3d879b81, 0x3f0de919, 0x3f3182ef, 0x3ee973ed,
    0xbcb1740c, 0xbef2a4bc, 0xbf31e296, 0xbeee6fe0,
    0x3c245b09, 0x3eeaa144, 0x3f3a2850, 0x3ef644dd,
    0x3bafc02b, 0xbef1f7e6, 0xbf32a054, 0xbedc7ee5,
    0x3c8c98e0, 0x3f061e63, 0x3f2f5cac, 0x3f046540,
    0x3d0934e5, 0xbf05152f, 0xbf1f3ee5, 0xbf0b9940,
    0xbcdb8f49, 0x3f018d38, 0x3f389446, 0x3eefbb9d,
    0xbcd042ad, 0xbf0cde1f, 0xbf34d4df, 0xbefb3a85,
    0x3d972526, 0x3f10b7e0, 0x3f31078e, 0x3ee91ffd,
    0x3c41f25d, 0xbf0c5f30, 0xbf233756, 0xbef1f84c,
    0xbdcea527, 0x3eecc606, 0x3f3575df, 0x3f01d72a,
    0xbd16d884, 0xbed11a19, 0xbf355220, 0xbede6588,
    0x3c700046, 0x3f026c58, 0x3f317c3c, 0x3eec9d9c,
    0xbbcbbe93, 0xbef2dc82, 0xbf31a79c, 0xbf07dd7f,
    0xbdab7987, 0x3eebace3, 0x3f49ef65, 0x3eecc272,
    0x3d5db068, 0xbf0a1f88, 0xbf27511b, 0xbeed816d,
    0xbcc35383, 0x3ed41b11, 0x3f47aa1a, 0x3f0ae45d,
    0xbd0d3055, 0xbeff4a35, 0xbf25da30, 0xbf00db5f,
    0xbd99f127, 0x3eda6e0b, 0x3f33a977, 0x3ede67e1,
    0x3db5d8e9, 0xbf03b87d, 0xbf2b9285, 0xbf0fb6ba,
    0x3d8f0dc4, 0x3efb5e38, 0x3f2a59cf, 0x3ef0405d,
    0xba8dcc0b, 0xbee95959, 0xbf2a2a50, 0xbf011b8c,
    0xbdf2078e, 0x3f05690e, 0x3f2f2fd7, 0x3ede8b7e,
    0x3d6aca59, 0xbed611d3, 0xbf20d379, 0xbf02408c,
    0xbd4a9c15, 0x3efb0bac, 0x3f358ba5, 0x3f022caf,
    0x3cd7fa15, 0xbeffe21b, 0xbf2d63f9, 0xbf1067b0,
    0xbcfcaa56, 0x3ef007fd, 0x3f388c17, 0x3efff32b,
    0xbe0b853a, 0xbf0721fc, 0xbf1baa49, 0xbf1e5168,
    0x3dd901db, 0x3ed8b187, 0x3f2e7f27, 0x3f0357ba,
    0xbd4854a0, 0xbee415f7, 0xbf2d3436, 0xbef9d62c,
    0x3e017c87, 0x3f0236db, 0x3f339d8c, 0x3ef7c7db,
    0xbcf585fa, 0xbefaf536, 0xbf33338b, 0xbeef956e,
    0x3d25cf03, 0x3f020ab3, 0x3f3e7ca6, 0x3ef6bf74,
    0x3d419513, 0xbf0f4b34, 0xbf2cb080, 0xbf0274f6,
    0x3c6a4564, 0x3ef08d0f, 0x3f1f7614, 0x3f015cb9,
    0x3acd246d, 0xbef864cc, 0xbf39309e, 0xbec1d0da,
    0xbcfbdf12, 0x3ee0ae73, 0x3f278809, 0x3ede1db9,
    0x3d9925bf, 0xbf01a574, 0xbf36a5f0, 0xbf09210b,
    0x3cb47cac, 0x3efec371, 0x3f3c6ca5, 0x3f16bd48,
    0x3c35223b, 0xbf0cb1d9, 0xbf3daccf, 0xbef46845,
    0xbd83f5fa, 0x3efb2889, 0x3f2e8e65, 0x3ee208ba,
    0x3b8328aa, 0xbf085130, 0xbf401dd4, 0xbeeca1a7,
    0xbc4ef92d, 0x3edf85e4, 0x3f35d77a, 0x3f06f357,
    0x3c73ee62, 0xbef2569b, 0xbf243a56, 0xbed4e3e4,
    0xbc67162f, 0x3ee42479, 0x3f446a1e, 0x3ef3ff26,
    0x3cc820d0, 0xbf09d913, 0xbf407ffe, 0xbef5baa1
    };

static const uint32_t in_rifft_noisy_2048[2049] = {
    0x3d58333f, 0xbfb8fabf, 0x3e8d0f1f, 0x3db8eeda,
    0xbf7d51c4, 0x3f2cc7e2, 0xbf3f342c, 0xbf43e5ce,
    0xbeb9ac86, 0x40213a8a, 0xc04fe2de, 0x3f47a99b,
    0x3f55583c, 0x3ea99ef9, 0xc0105697, 0xbf3fa22d,
    0x3f314f1c, 0x3f784b4b, 0x3fd6876d, 0x3efbf498,
    0x40309e0d, 0xc0790e02, 0x3f9c855f, 0x404c0de2,
    0xbf5cd727, 0x3d589b52, 0xbf191cfa, 0x3f8ef2c0,
    0x3d0e003e, 0xbfad97af, 0x3eadb42b, 0xbfdda8e0,
    0xbd5a2aa8, 0x405fd3a8, 0xbfc7c9b0, 0xbfba5189,
    0xbe39a538, 0xc02f60e2, 0x3f383028, 0x3fa6c3f1,
    0xbffd89a5, 0xc0161a43, 0x4012a363, 0x401d04af,
    0xc021b118, 0xbf159a1e, 0x3fae5f63, 0x3fa02ea3,
    0xc02fe962, 0xbfaebf45, 0x3f1fb1d2, 0xbe92c81f,
    0x3fe66da4, 0x3f8e447e, 0xbe9125f7, 0xbdaff45e,
    0x3e0cc086, 0xbfdcf49f, 0x3f6f62bb, 0x3ff0c299,
    0x3d6cda4d, 0x3f5123a2, 0x3f5e9ad6, 0xbf4fb48e,
    0x3f41ce76, 0xbfaa711b, 0x3fbe0506, 0xc0156cb9,
    0xc0149bd2, 0xbfad2dde, 0xbee6a4a9, 0x3f3cee9c,
    0x3ed7fc59, 0x3f57f34a, 0x3e072678, 0x401f9306,
    0x3fd99952, 0x3ea1f7ed, 0x3c0521d6, 0x3ed3eca7,
    0x40184e85, 0xbf334125, 0xc008d7a6, 0x3f63e5f9,
    0x3e951648, 0xbfb5e58e, 0x3f9803fa, 0xbf477223,
    0xbf255f60, 0x3f590fe8, 0xbd3a6829, 0xbfd5a996,
    0x3f83d562, 0x405ee07d, 0xbf5a2719, 0x3ebdd2f8,
    0xbff7bba3, 0x3f382c40, 0x3f731713, 0x3d4d014e,
    0x3e7dbe2a, 0x3fce83b7, 0xbef4bdb5, 0x3d980e8f,
    0x3f3c522d, 0xbe8253fd, 0x3d910923, 0xbf331bcd,
    0xbd502b63, 0x3fbccbe2, 0xbfe899b3, 0xbf88ba2c,
    0xbfe7b147, 0x3fc3ec4e, 0x3fb1d8fe, 0x3f9a2ce0,
    0xbf9aaf06, 0xbf74ad87, 0x3ff0e103, 0xbf8b120a,
    0x3f89a183, 0xbf9a995a, 0x403013a0, 0xbed226b4,
    0xbf5aa833, 0x3fd104ae, 0xbfb272ee, 0xbee07d2c,
    0xbf36e253, 0xbfe506c5, 0x3f683c8a, 0xbe8f5b25,
    0x3f7b95cf, 0x3fb7d91a, 0x3fe7a92b, 0xbf74efdb,
    0xbf5fa351, 0x3fd3ca00, 0x3fe16d75, 0x3ce8ed7a,
    0x3d343438, 0x40323f72, 0x3e10b9c6, 0xbfea1907,
    0x40108642, 0x3c9ba99b, 0xbed8cbcf, 0x3f2d3207,
    0x3edc617c, 0x3fe591db, 0x3f8029d2, 0x3ffbff58,
    0xbf652679, 0xbd68c6a9, 0xbf753d01, 0xc0133887,
    0x3f0f51b1, 0x3f58a0dd, 0xbf5a411e, 0x3f873d6c,
    0x3f857e64, 0xbec8b31f, 0xbe57f044, 0x3d44b61e,
    0xbf92e59f, 0xbfa38586, 0xc08e6d73, 0xbff5ebf3,
    0xbf0120dd, 0x3f9dfb41, 0xbf9d4ba7, 0xbe66a7f9,
    0xbdff320b, 0x3fad289e, 0xbd946607, 0x3e0872a9,
    0xbf3b3186, 0x3fc4614f, 0x4022e160, 0xbf0b7efb,
    0x405043fd, 0xc02c7386, 0xc0282f98, 0x3f4722f0,
    0xbdb79496, 0xbf1dd1d7, 0xbfdcffa7, 0x3ea650e0,
    0xbe74fb59, 0xbfb171cf, 0xbee4c019, 0x3e9069fd,
    0xc056506c, 0xc045db83, 0x3ed0713e, 0x3f4dd59c,
    0x3f394021, 0xbfaff7d6, 0x3e1dffb2, 0x3fd2887e,
    0x3ea01b47, 0xbe1bcae7, 0xbff38847, 0xbe548970,
    0xc02be581, 0xbf2261b2, 0xc000529a, 0x3f819eef,
    0xbea428df, 0xbfc47eab, 0x3f38e095, 0x3fa2d30b,
    0xbfb1de31, 0x3f86298d, 0xc07258ca, 0xc027123e,
    0xbf80e2cc, 0xbf94fde2, 0xbef25085, 0x3f790330,
    0x3fef92f7, 0x3fd8b2a0, 0xc01a30ef, 0xbe6f8188,
    0xc0278aab, 0x3f728fda, 0x3e44f860, 0xbf944a02,
    0x3f6309cc, 0xbfd7f91e, 0xbf4d0816, 0xc0200ebe,
    0xbf9fae6b, 0x3fa78de4, 0xbe386e1a, 0xbf4390d5,
    0xbf2ab3e8, 0xc05ca6df, 0x3e8e71ca, 0xbf5947a0,
    0xc00e040b, 0xbf85ef69, 0xc0122838, 0x3ff7187e,
    0x404f433f, 0x3e13c497, 0xc000e9c3, 0x3f8d29b3,
    0xc0224ad5, 0x3e6c0951, 0xbf58e9d9, 0x3fe56786,
    0x3fb0e78d, 0x4074564c, 0x3f85c24a, 0x3ec3eb6c,
    0xc05288cc, 0xbdc1f45b, 0xbf97c9df, 0xbfa8b5a8,
    0x3f49b5cf, 0xc0095370, 0xc0257e03, 0x3e71377d,
    0x3fc9c060, 0x3fb61879, 0x3f5a0020, 0xbf804384,
    0x3fd85598, 0x3ca60bd8, 0xbe6b7512, 0xbf366ae0,
    0x3f9c3747, 0xbd9ea62a, 0x401bdd5c, 0xbd221560,
    0xbfd95123, 0x3f7d2fa1, 0x3f039331, 0xbfedaa35,
    0xc0099fcc, 0xbf1493c0, 0xbfca33d9, 0x3fb5f5a6,
    0x3f91edb0, 0xbe3ef122, 0xbe66eedc, 0x3e965a13,
    0x3da54f0c, 0x3f03ace6, 0xbf381e0b, 0x3f851031,
    0x3f5e6a1f, 0x3f2caafa, 0xbf81da40, 0x3bcaaafc,
    0x3e06d995, 0xbfa73d0c, 0x4025d0a8, 0xbfa3d67d,
    0xbe642074, 0xbeb2b542, 0x3ec9b412, 0x3f52d4f5,
    0xbf1ab1ec, 0x40200694, 0x3dffefcc, 0xbec5122c,
    0x3fb56a01, 0x3f867148, 0xbf0ac8fc, 0xbf0fa9b4,
    0x3e706945, 0x3fc84a25, 0x3ebe2630, 0x3f9c3280,
    0x4019c9f1, 0xbefa59d1, 0xbc7b0223, 0x3fc006e1,
    0x3e2429a3, 0xbf992003, 0xbfe8fa53, 0x3d54a17a,
    0x40826a57, 0xbff0ff79, 0x3e6bceb0, 0x3f1588c6,
    0x3f0aeee0, 0xbea1a97d, 0xbfdbe367, 0x40074b94,
    0xc023f20d, 0x3f4cbe95, 0x3fa31fd3, 0x3f4d00f8,
    0xbf3e02b6, 0xbfff677f, 0xc0094e62, 0x3ef259ae,
    0xbe95cb9a, 0x3ff490a0, 0x3f9fa20b, 0xbf006a9f,
    0xbc23698d, 0x3f179c88, 0xc03568e8, 0xbfd25f23,
    0xbdcaecb2, 0xbf88702a, 0x3f6cf062, 0xbfe5dd34,
    0xbfedef65, 0x3e595273, 0x3fecd528, 0xbfec0909,
    0xbfdf25c1, 0x3eef9bf0, 0xbf247ee5, 0xbfe0dbeb,
    0x3f1df52e, 0x40852397, 0x40217c52, 0xbfb45ed0,
    0xbf921ea7, 0x3e80e46b, 0xbf8f0a70, 0x3f7a89a2,
    0x3f41c39b, 0xbfe78a43, 0x403a7bdc, 0xbf281454,
    0xbf664481, 0xc0065c8a, 0xbfc7084e, 0x3f106386,
    0x3fcbd96d, 0x3f8adbf3, 0x3f8ceebc, 0xc0073bf6,
    0x4005663b, 0xc0504a37, 0xbd48f287, 0xbe16b39f,
    0xc07bedcf, 0x3f8a21d9, 0x3fdd9168, 0x3c111a33,
    0x3f6fb5ef, 0x3e71c34c, 0xbf929fae, 0xbf604ec8,
    0x3f768c62, 0xbe042c70, 0x3eca6d07, 0x407744a7,
    0x3facbf44, 0xbf0d74e4, 0xbf0ef9d4, 0xbe02115c,
    0xbe744c27, 0x3f299e2d, 0x3e1fcf20, 0x3fa197e6,
    0xc028e66b, 0x401280f6, 0x3fecca0c, 0xbf7ebcf9,
    0x40426206, 0x3fd9dbc6, 0xbf1b0526, 0x3f9c782a,
    0x3fd95603, 0xc00d4b9f, 0xc01652e4, 0x3ff31b21,
    0xbf0c7041, 0x3fc07943, 0x3f45a60e, 0x3f576677,
    0x3fe9fd6d, 0x3e28c3d6, 0x3f61e809, 0x3f13fe77,
    0x3db9031b, 0x3f08c5a6, 0x3f875238, 0xbfa3d960,
    0xbefa7a4a, 0x3f9fb4d2, 0x3fcee13f, 0x3e5a58cd,
    0x3ec4840f, 0xbf96eb15, 0x3c2bbf89, 0x3f72c8f5,
    0x3ee52bad, 0xbf1791f0, 0x3ff7693c, 0x3f07d4d4,
    0xbfef0d13, 0x3f23dd62, 0x3ff44a43, 0x3f562507,
    0x401db550, 0xc085b6af, 0x3f8bc836, 0x3fc98c38,
    0x3f4c3549, 0x3fe85073, 0x3fe15964, 0xc00a8d2c,
    0xbf41c729, 0x3f30b209, 0x4003fb42, 0xc0138f9b,
    0x3da792c5, 0xbfc6fecb, 0x40379ec6, 0xbf6cbf0a,
    0x3c4780d8, 0x3e542e55, 0x3f4be074, 0x3eef1ebd,
    0xbfe30076, 0x3f152fcd, 0xbe964387, 0xbfbc1351,
    0x3e432f6f, 0x4007ef0c, 0xbe5c8abd, 0xbd876970,
    0xbf039ac1, 0xbfcacc22, 0xbf065d5f, 0x3fbd8fb1,
    0xbfb35cb0, 0xc064cb24, 0xbf1aff10, 0xbfbbb4dc,
    0xbf89792c, 0xbd7ae0f1, 0xc01d6a88, 0xbee29f8d,
    0xbeb163ab, 0xc0138a36, 0xc02edff2, 0xbfb5ccb1,
    0xbecd5955, 0xbebcc2d7, 0x3ecb5ab1, 0xc01ca135,
    0xbfbf38f3, 0x3ce92ed9, 0xbff45374, 0xbde30e29,
    0xbf0f3a6c, 0x4043d9d1, 0x402b0ced, 0x3f985027,
    0x3f3107bf, 0x40591db5, 0xbd330cbc, 0x3f63bc85,
    0xbeecc5d6, 0xbfb22c98, 0x3ed7bd77, 0x40097341,
    0x400efff1, 0xbf918293, 0x3ff05aed, 0xbf369b53,
    0xbffe7233, 0xc43310e5, 0xc01bbcb0, 0x3e868235,
    0x3f946a09, 0xbf08e977, 0x3f5ed8c0, 0x4035f0e5,
    0xc0215f81, 0xbf064f11, 0xc042bbbb, 0xbf026bf9,
    0xbfac9350, 0x3fa152c4, 0xbfa6c0da, 0xbe2ec8f7,
    0xbc742d8b, 0x3ff23978, 0x3fad4e01, 0xc06d8ebe,
    0x4034d5a9, 0x3f90e466, 0x3fde52bb, 0x3edab100,
    0x3f3daa39, 0x3e5c3957, 0x3fd823e9, 0x3ea9a689,
    0xbeff97ee, 0xbefb71fd, 0xbf5659fe, 0xbf95293b,
    0xc0415fe3, 0x403b0a27, 0xc01f1564, 0x3fb566ac,
    0xc053fa78, 0xc0025485, 0x3f233f10, 0xbcfbf9b1,
    0x3f602510, 0x3f1abd9d, 0x3f4c8642, 0x3e81dff9,
    0x3fbdbaf3, 0x3f8ff08a, 0x3f7868a7, 0x401f121d,
    0xbf0bd6e0, 0xbf3b0d6d, 0xc024a114, 0xbd980380,
    0x3ef21804, 0xbfcd19fb, 0x4019bd66, 0x3fffe4b4,
    0x3fe9c4ed, 0xc08bc9d8, 0x409db7e1, 0x3f714366,
    0xbf8f72a1, 0x3fd9808f, 0x3d99a2ff, 0xbf5b09c4,
    0x405f8851, 0xc068ba41, 0x4018d426, 0x3f9d1f23,
    0xbfcbe49b, 0xbdb8c010, 0xbe99d17d, 0x3fca1d3c,
    0xbfd355a3, 0xc0228c1a, 0x40864f3e, 0xbfa392b5,
    0x3e0f5f04, 0x3f75629f, 0x3e32c164, 0x401b20e2,
    0x3f490d50, 0xc0379e28, 0xc04f1036, 0x401eebd6,
    0x3f83fd1f, 0xbf030f42, 0x402abfe2, 0x3f316236,
    0x3fc6686b, 0x3fea31f7, 0xbf49a8d6, 0x3e9dac71,
    0xc07092ca, 0x3fa96702, 0xbf23825e, 0xbdc6aa04,
    0x3ecdbf1f, 0xbdcd22e7, 0xbfd4ffc4, 0xbf73c687,
    0xbd0a1445, 0xc0027f86, 0xbfc6e501, 0xbf9a9032,
    0xbf9b17c8, 0x3f975ba7, 0xbf1b674f, 0xbf1a0a28,
    0xbfad9f4c, 0xbf4abfe7, 0x40358177, 0x3faed0c1,
    0xbf0f258f, 0xbd81664b, 0x3f6a7d29, 0x3d9c239d,
    0xbf73efa5, 0x4010ef99, 0xbcce96c0, 0x3e5dadd8,
    0x3f49fbf4, 0x3ffeae5a, 0xbfae5254, 0xbeb07b23,
    0x3e9d855c, 0x3e01c2a4, 0x3fe3068e, 0xbf8c4df7,
    0x4008165e, 0x3ff602bf, 0xbe82e42b, 0xbfd44ebe,
    0x402f8531, 0xbfad8522, 0xbfd625c8, 0xbf9fe696,
    0xc04dc55c, 0x3e7deae5, 0x3f95750e, 0xbf776e5a,
    0x402df246, 0xbf5e6a5c, 0xbfbd3cb6, 0xbf091a3a,
    0x3fb115fd, 0xbe863233, 0xbe3f0572, 0xbfebab2a,
    0x3f8be083, 0xbf1b3df0, 0x3d5a65ed, 0xc07bd355,
    0xbf619a73, 0xc04baec2, 0xbfd171f0, 0xbf2d6787,
    0x3f25a712, 0xbf8423a7, 0xbfa70b18, 0x3e5092ec,
    0x3ceedc45, 0xbff0d9c2, 0x4039864d, 0xbfb2a1e8,
    0x3f0662e6, 0xbf627e52, 0x3f08c67c, 0xc00e3213,
    0x3fdf8862, 0x40514731, 0x4018a848, 0xbe84c1c2,
    0x4035021b, 0xbfd0de78, 0xbfa91141, 0x3f4389f7,
    0x3db2de8a, 0xc0022a68, 0xbf9f4669, 0xbf8ec732,
    0x3fdece4e, 0xbf68b30a, 0xbf428d1e, 0xc0993694,
    0xbf892016, 0xba6408a3, 0xbfed34f3, 0x3f9f06f5,
    0x3eecbfd2, 0x3d4fff23, 0x3f3f8c75, 0x3eff6b7a,
    0xbf4d7910, 0xbf808506, 0x3ffdcd3c, 0xbf5c3887,
    0xc06f223d, 0x3c21231b, 0xbf879068, 0x3f4005fa,
    0xc013ed95, 0x3f55aee8, 0x405b9bb1, 0xbfe7e4a4,
    0x3e4421e1, 0xbf4a4b56, 0xbf8b48e4, 0xbfabe309,
    0x3e707bb6, 0xbe8af3cc, 0xbffb8d94, 0x3fe75077,
    0x40098e61, 0x3edb011c, 0xbfaa88fe, 0x3fc99168,
    0xbfe8bf9b, 0x4007182b, 0x3fbc90dd, 0xc008deac,
    0x3d83e9f7, 0x3c5ef161, 0xbda40557, 0x3f2da8dd,
    0xbfc11535, 0xbf9ea5e8, 0xbfc9833f, 0x3ff209bb,
    0xbfcf3de7, 0x405bc182, 0xc0335c0f, 0x3f68f306,
    0x3e135533, 0x3f66b060, 0xbefcd094, 0xbdc2a492,
    0xbfa402d2, 0xc047cc3a, 0x3f8fbc78, 0x4012f502,
    0x3faf7483, 0xbf35a27c, 0x3ffbbe72, 0x3fbc772a,
    0xbfbfb0bb, 0x3f6b138e, 0x3f0ce6f5, 0x3fd45871,
    0x3fb76138, 0xbfd273d7, 0x3f80812e, 0xbf23476b,
    0xbfcf34c8, 0xbfc6c1c5, 0x3e966e22, 0x3fb6425e,
    0xbfe514fa, 0x3e7faf57, 0xbf1c1215, 0x3f2bfa91,
    0xbe57630c, 0xc05bfaf4, 0xbea8ce3b, 0xbf8570d6,
    0x3ee454e6, 0xbf803735, 0xc04f2410, 0x40058310,
    0x400d7c27, 0x4054b582, 0x3f84f9b7, 0xbfb5619c,
    0x407dad93, 0xbebbd1d0, 0x3fb7a5ab, 0xbfa68606,
    0xbd06510f, 0x3fa9857d, 0x3fc173c5, 0x3e946d4f,
    0x3f3ebc36, 0x40105b5a, 0x3fcaaf18, 0xbf59b133,
    0xbfb5a032, 0x3e97a519, 0x3e52a0ed, 0xbf0f9f72,
    0xbf907ee6, 0xc0891a76, 0xbfbe510b, 0x3f1c6d7b,
    0xbf03d1cb, 0x3ff82a81, 0x3fb4fd10, 0xbe1087e8,
    0x401693a3, 0xbe421928, 0x3e8cd9b4, 0x3fa014ff,
    0x3f1dbd9c, 0x3dff1a70, 0x3ff99f4b, 0x3e8235ad,
    0xbc2ade1f, 0x3e398fbc, 0x3c85c55a, 0x3fd25b11,
    0x3fd03dc7, 0xc02ebf03, 0x3f2b2317, 0xc0a26797,
    0x3f8ec2c6, 0x3f4061fc, 0x3fa6ae1e, 0xc0044e7b,
    0x3f200585, 0xbfde2ca2, 0xc03679a9, 0xbfbb260d,
    0xbfe0bbee, 0x3f480b6a, 0x3f2abf03, 0x3f9427d9,
    0xbeb93ecf, 0xbf5cae26, 0x404825ad, 0x3e538698,
    0xbfecd612, 0x3ff762d4, 0xbf1587d9, 0x3e4888c1,
    0xbe48694e, 0x3fe750fb, 0x401ce597, 0xbdf47683,
    0x3ee9e857, 0x3d986587, 0x3faf0426, 0x3e9447da,
    0xbf867bb3, 0x40206a28, 0x3d86d953, 0xc02b920c,
    0xbf9c8e5b, 0x3fe33770, 0xbfb269ed, 0xbf233d49,
    0xbfa73022, 0xbfd1e5cd, 0xbebf0963, 0x3d65fae9,
    0x4007824a, 0x3dc8bc98, 0xbeeeb512, 0xc02b492e,
    0xc010200e, 0x3f38cd4c, 0xbf775caf, 0x3f97a834,
    0xbf2109bb, 0xbf2f1c5a, 0x3fca3989, 0x3f0cb928,
    0xbe9da979, 0x3fd9b062, 0x3fab6b2a, 0x3fcef579,
    0xc00a4606, 0xbedd31ac, 0xbfc5b979, 0x3eb79572,
    0x406603f7, 0x3e1b0266, 0xbf0fdd26, 0x3fb4dcb7,
    0xbfe1577b, 0x3d748957, 0x3f1ab54b, 0x3f8ec4e0,
    0x3f9ce556, 0x3f703f00, 0xbfc3a7aa, 0xc040bdad,
    0xbfc9a9a3, 0xbec2bd89, 0x3fb40ff2, 0xbfde0fec,
    0x40b702dc, 0xbf2c8b39, 0x3e5fe650, 0x3eadd94e,
    0x3f1373f4, 0xbf9b61fe, 0xbf7d89a4, 0x3f20e225,
    0xbfe3702d, 0x401d2a1f, 0x3fe002db, 0xbea204cd,
    0x3eac864e, 0x3fb6ef6e, 0x3f8e3364, 0x3f8f8ac7,
    0x3d3a3bce, 0x3f07ab08, 0x40771aac, 0x3ff87ca0,
    0x3f634cd6, 0x3ff9194c, 0x3e22c6fe, 0x3f62f633,
    0x407a1f65, 0xbd51bd0e, 0xc0342ed0, 0xbfa0bdf9,
    0x40531c61, 0x3f24edea, 0x4004d8c5, 0xbfec736e,
    0xc017cdc0, 0xc0991e42, 0xbf7255d1, 0xc01ed721,
    0xbfad3271, 0xc07a8f81, 0x3f036ddc, 0x3e290c9b,
    0xbf6bbe16, 0xbedf0288, 0x3f5686b3, 0x3ff85e07,
    0xbea21d00, 0xbef092b1, 0x3f909e1d, 0x3f955b94,
    0xbed504f5, 0x3f90840e, 0x4006720d, 0xc00d8722,
    0x3fc832a1, 0x3f04c1d6, 0x3fa5a03d, 0x3f39071a,
    0xbf825bbe, 0x3f8781f8, 0xc05a5a83, 0xc0086a81,
    0xbff8db85, 0x3dfee0e7, 0xbf89d8b3, 0x3e98e012,
    0xbf287909, 0x3f277cca, 0x3f322041, 0x401466c4,
    0xbd0cd689, 0x40140c60, 0xc00b349a, 0xbeb85cc6,
    0x3e0651c4, 0xbfa4d9b0, 0xbfb054e5, 0xc043314d,
    0x3fcfba95, 0x3f697391, 0x3ced10e7, 0x3f5dc3bd,
    0x3efdd90a, 0xbfc14385, 0xbf737ad9, 0x3fdccdf2,
    0xbf11102d, 0xbf9fd09f, 0x3f83644e, 0x3f261615,
    0x3f9ca8bc, 0x3cae38da, 0x4038b6de, 0xc035fd5e,
    0xbeb13cb0, 0x3f7e0261, 0x3c94afeb, 0x3fb8ac7b,
    0xc000af77, 0x3dd3ede4, 0xbfae0cc1, 0xbeba78fa,
    0x3ebef6b3, 0xbf21cc6d, 0x3ef31e84, 0xbf261531,
    0x40539c93, 0xc05a5497, 0x403a4aae, 0x3f215acc,
    0xbf6b7234, 0xbdc36e08, 0xbf993935, 0x402c959b,
    0x3f48ba44, 0x40c24707, 0xc03e59b5, 0x3f3d26b7,
    0x4040661d, 0xbfa51de7, 0xbfbf03f9, 0xbece59a3,
    0xbf8e466e, 0x3ffb3b72, 0x3fa3e776, 0x3f87b9b5,
    0x3fddd434, 0xbf0a0e2c, 0x3e6e2bc8, 0xbf82f1b3,
    0x3fb8a09f, 0x3fef7128, 0xbfb2e370, 0xbf035f46,
    0xc00321d5, 0xbf4443d5, 0x40097e59, 0xc00685bc,
    0xbf83439e, 0x3e56be38, 0x3ff5fd85, 0xc00cbaa9,
    0x3ec72455, 0x3fac1284, 0x3f6e8184, 0xbf906eb2,
    0x3f4420e1, 0x3f4db982, 0xc0271e28, 0x3fdefc54,
    0xbfa8f811, 0x4003a603, 0xbfa09dd4, 0x3f9e9f08,
    0x3fa2bd7f, 0x3f485a12, 0x3e310931, 0x3f175fa9,
    0xbfbc3cca, 0x3ede2d1f, 0x3f96dd42, 0xbbdb2396,
    0xc0405196, 0x4040fccd, 0xc0168fae, 0xc0729d5b,
    0xc014f51a, 0xbff904da, 0xbf87cace, 0xc03bc533,
    0xbf732010, 0x3eb7c410, 0x3d6cbf56, 0x403aeac3,
    0xc013a283, 0xbfba694b, 0xc06768bd, 0x3fe46044,
    0x3f978d1e, 0xbf9d8a3e, 0xbf11c455, 0x3ed4fc9f,
    0x4009868c, 0xbf1b322f, 0xc011042f, 0x3f1325d4,
    0xbf3df305, 0x3f17f63e, 0xc00c1c7d, 0x3f05fc7c,
    0x4090765f, 0xbf46d179, 0xbe308822, 0xbffc10bb,
    0xbe913faa, 0xbe73135d, 0xbf179a98, 0xbf8b7144,
    0xbf8cea5f, 0xbf1cd217, 0xc0332836, 0x3f8608b0,
    0xbe9f4bcc, 0x400185ef, 0x3fac6c61, 0x3fc8f3ad,
    0xc009929a, 0xbfe1491b, 0x4020f1db, 0xbf49dc7c,
    0x3f9415dc, 0xbef30a07, 0x3f8e8829, 0xbf09d467,
    0x3d17768f, 0xbe183508, 0xbeb01549, 0xbfc9d5bd,
    0xbfa2efcc, 0x401a1f62, 0xbedf1368, 0xbf3bed54,
    0xbe369dd6, 0xbf93cd70, 0x3d605ebd, 0x402370b5,
    0x3f3b27ba, 0x3f7b7144, 0xbfb718b2, 0xc0173cb8,
    0x3f695359, 0x3f31b936, 0xbf97558f, 0xc028c8ea,
    0xbfe2517b, 0x4002fb60, 0xbf6a6df9, 0x3fe4f5a0,
    0x3f80191a, 0xbf4bb672, 0x3f377725, 0xbfd2cc38,
    0xbf84c238, 0x3f50a6c2, 0xbfbbc5e8, 0xbfada23f,
    0xbf949543, 0xc04325ec, 0x404c8000, 0x3fc4ecf3,
    0xbec0bddb, 0x402b06da, 0xbf5271fc, 0xc013df15,
    0x400d7e51, 0x3fd3fd8d, 0x3f5652e2, 0xc008084c,
    0x3efa736b, 0xbfd91db0, 0xbc8ff393, 0xbf553dfd,
    0x3faa5ed0, 0x3eaaee07, 0xbf3f1c28, 0xbfb8f1d6,
    0xbeb2832d, 0xbf22e56a, 0xbfeeeb39, 0xbfb2236a,
    0xbe58a28f, 0xc008280b, 0xc008b0af, 0xbf632868,
    0xc036e869, 0x3fde3b54, 0xbec83130, 0x3eb6178a,
    0xc0091ca2, 0xbe1055f9, 0xbe8bbf00, 0x3d91b3e6,
    0xbeb9696a, 0xbf716fd4, 0xc00b400c, 0xbf9a8418,
    0x3f7e9888, 0x3fbc6a26, 0xbf0735dc, 0xbf1e71a8,
    0x3ebb4389, 0x3fea2951, 0xbffd9702, 0x3fe76eae,
    0x40322ef7, 0xbc6db642, 0xbf9bdd56, 0xbfa15cc0,
    0xbf3ead09, 0x402d4d00, 0xc0567f81, 0xbfa23ac6,
    0x3f29e049, 0xbf9b097d, 0xc00e3031, 0xbf788dda,
    0x3f537413, 0x3f5873b5, 0xc0244f53, 0xbfb403a8,
    0x401a06bc, 0x3f0c7242, 0x3ee57aad, 0xbff7c5d1,
    0x3da5c133, 0x3f372ee0, 0x3e08b962, 0xbe56e706,
    0x400c781e, 0xbf014985, 0xc04867e5, 0x3f329421,
    0xbf14f3c0, 0x4014278e, 0x3da0b092, 0x3f3628e3,
    0x3fb125a5, 0x3fbf1ba1, 0x3fbf2989, 0xbfaed28d,
    0x3e24e796, 0xbf5546fa, 0xbfda5123, 0x4011d4e1,
    0xc02ac6a4, 0x40140554, 0x3f6dbc5a, 0xbf221bee,
    0xbf9a8602, 0xbedcb2c0, 0xbf40f6f4, 0xbd134bd7,
    0xbf1f806f, 0xbf15e939, 0xbf5be0f2, 0x3ee55aa5,
    0xbf9ef010, 0x3e8c8346, 0x3f9ddb7d, 0x3fd926d4,
    0x3eda6185, 0x3f7ad272, 0x3ede481c, 0xc04704df,
    0x3e332288, 0xbf837f34, 0xbf142272, 0x3c7bc4a1,
    0x3f842ef6, 0x3f481ff8, 0x3fb29b25, 0x3fbfdd40,
    0xbf41420e, 0x3f0cce3a, 0x3f4177d2, 0xbf4bf7fb,
    0x3f801b30, 0xbf3bec44, 0x3f47b87f, 0x3fb55b59,
    0x402713f5, 0x3f230ad2, 0x3f805d68, 0x3ec5d6f5,
    0x3f0a1a09, 0x3ed930b7, 0x3f5e3ecb, 0x3ed9fadd,
    0x3ed0242d, 0x4033c554, 0xbf4c96dc, 0x3eeec255,
    0xbf91546d, 0x3facc979, 0xbf9161c2, 0xbe578f3f,
    0xbf0d91d4, 0x3f84d1a2, 0x4061ae75, 0xbfc58353,
    0xbf7ace23, 0xc00418e6, 0x40c7e4c9, 0xbf86c18e,
    0x3dfc41bc, 0x3f01d4fb, 0x3eeb385c, 0x3fcc4e94,
    0x3f193ebe, 0xbefe356f, 0xbee84a76, 0x4051a7f3,
    0xbe645715, 0xbf92783c, 0x3fda81ad, 0x3ea4fe6d,
    0x4022be79, 0x40080b9d, 0xbef8330d, 0xc0039543,
    0xbf026e44, 0x4024db26, 0x3fb17ec4, 0xbf7de301,
    0xbfba8372, 0xbede4fc2, 0xbf1d5099, 0x3fb97e7b,
    0x3f91e57f, 0x3fc580f5, 0xbef5ec2e, 0xbe92ff9b,
    0xbfce89c8, 0xbf4ac7ae, 0x3fb14982, 0xbefefcd6,
    0x3f8fa225, 0xbf8c57ce, 0x4014ee49, 0x3eb57db3,
    0xbf0df043, 0x40266d28, 0xbf3cf5ff, 0xbdd41081,
    0x3ff6970d, 0x3f96056c, 0xc0598c0c, 0xbead5d7b,
    0x3f81cb69, 0xbfcd6106, 0xbfc51a6f, 0x3f1b631a,
    0x3f06ba9c, 0xbdb14b59, 0xbfdcba1e, 0xbf9d4f99,
    0xbfff137c, 0xbf764fb3, 0xbe06a107, 0x403d05e2,
    0xbff130f7, 0xbfb6cb8c, 0x3f91c90e, 0xbe08ae50,
    0xbddfc697, 0xc021251d, 0xbf99c3f1, 0x40763ea6,
    0xbe979e48, 0xbf23907f, 0xc04b79d0, 0x3d31ed7a,
    0x3f5f3516, 0x3f106acf, 0xbf345229, 0xc013f891,
    0x3f9e345d, 0x3f6039f9, 0xbfcf176e, 0xbfa7a6df,
    0x3f285f37, 0x3ea350c0, 0x3f7851f1, 0xbe578f7f,
    0xbfef8b42, 0x3f3d79ef, 0xc04c3864, 0x3fe8ec8b,
    0x3f1e50d7, 0x3fe7d3b8, 0xbee3b86d, 0xbe35877f,
    0x3fea3bb5, 0xbfc1a31c, 0x3febb762, 0xbfbb33de,
    0x3fca6f4e, 0x40310355, 0x3e225358, 0xbfe6d2f5,
    0x3e2517e8, 0x3fc341c1, 0x4011453b, 0xbdc1c585,
    0xbeb7f6d9, 0x3f0ee7e2, 0x3f596701, 0x3fdce33f,
    0x3f86fb69, 0xbf0caa90, 0xc029f275, 0xbfe3f9e7,
    0xbf39f15f, 0x3f9e7338, 0xbf9fabd9, 0xbff61b48,
    0x3fb939b7, 0x3ef84a93, 0xbf29f595, 0x3ee478b3,
    0x4059c08b, 0x3f714e8d, 0x3f5ebc27, 0xc04f37d5,
    0xbf9098af, 0x3df29492, 0x3e8e67ed, 0x3edc3786,
    0x3f91ca3f, 0xbf8296a8, 0xbf9a506a, 0x3f644730,
    0xbfa615f3, 0x3f164758, 0x4070fcce, 0xc02efc32,
    0x3fbc68b4, 0xbf8bbc64, 0xbea581a8, 0x3fbb606c,
    0x40051c37, 0x40037890, 0x3eca4267, 0x3fb9d950,
    0xbe2a41ba, 0xc050bedb, 0x40032e8c, 0x3fbc59cd,
    0xbd7dcfc9, 0xbe237401, 0x3ee73214, 0xbfafc4d6,
    0x3e888c51, 0xbf34c93a, 0xc06d3bea, 0xbf51eff1,
    0xbff3d690, 0x406cdcc0, 0x3f4fbc0a, 0xbfa53ed0,
    0x3e524757, 0xbf3b479b, 0xbfdaeef7, 0x402e027a,
    0xbfc2f57d, 0xbf190141, 0xbf456a12, 0xbf6d7046,
    0xc01d4f11, 0xbde2e549, 0xbebb770a, 0xbf7d47ba,
    0x3fa4eeb8, 0x40888b8a, 0xbce15e0d, 0xc0240f86,
    0x3f562989, 0xbf18b87e, 0x4014f6ba, 0xbf6aa261,
    0x3fdb1817, 0xc023040c, 0x401c797a, 0xbf9725e6,
    0xbee28e10, 0x401af3c0, 0x3f6783ed, 0x3f455d94,
    0x3e0e8541, 0x3d489f43, 0xc016e43c, 0xbfb87f0c,
    0x3e140968, 0xbfef33b8, 0xc0033d09, 0x3ef5dfd3,
    0x3d8a1b50, 0x4011cc09, 0x405bc474, 0x3ec1d1dd,
    0x3fc01bd8, 0xbd23b1b0, 0xbf8b343a, 0xbfe4dd8a,
    0x3d486c7b, 0x3fe101a9, 0x3fd4eb60, 0x40028658,
    0x3f303070, 0x3fc73b83, 0x3f257b76, 0x401719cb,
    0xc00a8955, 0x3e684ed6, 0xc027fa5b, 0x400a05e9,
    0xbfa0cc1d, 0xbf5d3cb5, 0x40530b0c, 0x3ed86918,
    0x3d8391d6, 0xbfad99c5, 0xbfdd2ea0, 0x3fa2fc25,
    0x3ff2bd2d, 0x400a20ba, 0xc02524fe, 0x3e851c71,
    0xbfddfbfc, 0xbf8b2bfb, 0xbfa283a6, 0xbf68f536,
    0x403a3b8b, 0xbf636932, 0xbf3eff83, 0xbfbdcc4c,
    0x3e248f26, 0x3f3e34eb, 0xbfeed832, 0xbf949e82,
    0x3e489120, 0xbfdf41a2, 0xbf64b53e, 0x3fb793c6,
    0xc0186157, 0x403c0e1d, 0xbe85355f, 0x3fcfc89d,
    0x3e5a67e9, 0xc0856e2d, 0x3f5166ef, 0xbfff653e,
    0xbf78cc3d, 0x3edde79d, 0xbf811425, 0x404c7bed,
    0xbf8a2b85, 0x3f61a15a, 0xc00a6b1f, 0xbeb95f6d,
    0x3f1869b2, 0x3ef8e886, 0xbfc0d362, 0xbfb33333,
    0x3e490740, 0x3e6d0cd4, 0x3fddd45f, 0x3fbf52b7,
    0xbf57c28e, 0x3f3c480c, 0xbff05c7d, 0x403c4f0a,
    0x3af6f3f4, 0x3ecd65e5, 0xc06554a3, 0x40253ee7,
    0xc04db356, 0x3dc0aa66, 0x3faf57e4, 0x405f40f9,
    0xbe999ccf, 0x3fadf631, 0x3e8ef3c3, 0xbf09feee,
    0xbea7dbc2, 0xc025fa88, 0xc02fc4de, 0xbff98db7,
    0x3e9c33ed, 0x40239d79, 0xbf269f93, 0x3cb82094,
    0xbea6cd4c, 0xbfe2563c, 0xbe98fead, 0xbead77fa,
    0xbfc9c891, 0xbf32977f, 0x3fc8c827, 0x3fd6a127,
    0xc00170ec, 0xbea4757d, 0x3fb8dd9b, 0xbf8af5f7,
    0x3e716ca9, 0x3f9940fc, 0x3f062100, 0xbed4f779,
    0x406526f2, 0xc0157e1e, 0x40305d73, 0x3e6b0479,
    0x4004ae34, 0x4043c04b, 0x3f75fc64, 0x401f4cca,
    0xbea8f404, 0x406e7be1, 0xbeefb721, 0x3f1c9167,
    0xbfa6ce74, 0xc01addd2, 0x3eeeaa68, 0xbe92d6ef,
    0x3e956b77, 0x3f49a851, 0x3fb9828f, 0x3f385b44,
    0x3f97c66f, 0xbd05a5e3, 0xbfeb3446, 0xbf886581,
    0xbfbc16be, 0xbf8ed40e, 0xc000accd, 0x40019cee,
    0x3ee15459, 0xbe2bf4c3, 0xbf2d1d08, 0xbdf94212,
    0xc096d3c9, 0x3e9f8eb0, 0x3ff186cc, 0x3fedf60a,
    0xbf8dcdc2, 0xbf9036aa, 0xbea60251, 0xbf9a87db,
    0xbec81215, 0x3f1ac1f8, 0xbdf6a0d0, 0x3e537081,
    0xbf89633a, 0xc03a0657, 0xbfdccf47, 0xbf801ad6,
    0x3fd68559, 0x3f121efa, 0x3fcd19ff, 0x40001a1e,
    0xbf8e2f54, 0x3f971681, 0x400f807f, 0x3f51e323,
    0x4041722c, 0xc00d2b4b, 0x3f8f2822, 0xbee3c52c,
    0x406017e7, 0x3f12cef5, 0x3f593716, 0xbfb065b8,
    0xc0021d67, 0x3f878ff3, 0xbee8cede, 0xbf57e420,
    0x3f1fa154, 0x3f9549be, 0xbd8864f3, 0xbfd8db91,
    0x3f8900e1, 0xc00ccfef, 0xbf916c7b, 0x402241ac,
    0xbfd23342, 0x3d8d433c, 0xbf332653, 0xbf7b4365,
    0xbf622f68, 0xbed57ade, 0xc027a710, 0xbffb6e0e,
    0xc00e8f19, 0x402102a4, 0xbf97445a, 0xbe9bb6a8,
    0x3ee67ba5, 0xbe1a92e4, 0x3f377e7b, 0x3ee0b932,
    0xbf5d240d, 0xbee472a8, 0x3dba968a, 0xc05f2dc9,
    0xbfe84b6d, 0x3e487963, 0xbfb17b13, 0xbd47d617,
    0xbf54576d, 0xbf9ac4b5, 0x3ec9ef79, 0x400b715a,
    0xbf610aac, 0x3f005c63, 0xbf6d31f7, 0xbe7ed767,
    0xbeb0a00a, 0xbf8506a3, 0x3fb30e94, 0xbf0f4b95,
    0x3fa5694d, 0x3fb03e33, 0xbf111516, 0x3fb90641,
    0x3ffa0924, 0xbf9b9cb2, 0xbdc2fe09, 0x3f122e54,
    0xbeedd5dc, 0x3ffb655f, 0x3e69e916, 0xbea873cc,
    0x3ea4ad2c, 0xbf43deab, 0x3ffffe1a, 0x3e2c25b0,
    0xbf396ed7, 0x3f4ddcfc, 0xc0481516, 0x3fb47ee3,
    0x3f8719da, 0xbe490e2c, 0x3f095630, 0xbef5210b,
    0xbffc1fe5, 0x3fcc7fd1, 0xbf85d61f, 0x3f31fcfa,
    0xbffde10c, 0x3fc3ac27, 0x3fb9043a, 0x3f8b01dd,
    0x3f04942b, 0x3f6caf73, 0xbf232d80, 0xbe8a1845,
    0x3f898832, 0xbf9c0a9a, 0x3edce729, 0x3f49236d,
    0x3e400954, 0x3ef82b0f, 0x3f62e286, 0x404c9446,
    0xbeafb2a5, 0x3fddc3df, 0x3f0f6216, 0x3fcc1fb3,
    0xc02e7254, 0xbf8a1b35, 0xbfc04846, 0x3fc93688,
    0xbf418125, 0xc01608b5, 0x3fc7e0f2, 0xbf99b1e1,
    0x406861ec, 0xbf7e94d6, 0xbf5b76f5, 0x3ee6cbec,
    0xbf707aba, 0xbf7cf602, 0xbda93906, 0xc0129df6,
    0x3fa51f98, 0xbfa753ee, 0x3fc9a73b, 0x3eb996c3,
    0xbe76a45f, 0x3fa082b9, 0x3f36669f, 0xbfdd4eaa,
    0xc00449d2, 0xbf1f1020, 0x3fb0217b, 0x3dcb91e3,
    0xbd804398, 0xbff80933, 0x3f00f852, 0xbf0b5233,
    0xbf6747da, 0xbfdb2cfe, 0xbe9e7aa8, 0xbe1c2ea2,
    0x4048ccd9, 0xbf603f68, 0xbf81dbeb, 0x400796bf,
    0x3f64c472, 0xc082ceec, 0xbee159e0, 0xbeec0ff8,
    0xc011e01b, 0x3f542fc3, 0x3f5b74c3, 0xbfa8b87d,
    0xbeb43cc8, 0xc01cda3d, 0xbfcfbe1c, 0x3d1b88a2,
    0xbe4ccd08, 0xc00cf8c0, 0x4016485d, 0xbf410525,
    0x3fc23553, 0x3e8f53ea, 0xbd65d82b, 0x3eca5eb5,
    0x3e592373, 0x3faf3ef3, 0x3fbf1d0a, 0x3e451310,
    0x400bfdce, 0xc00cb32a, 0x4012f0e1, 0x3f738861,
    0xbde9639c, 0x3f0f7ccc, 0x3f25073d, 0x3f69ca90,
    0x3f24f7d8, 0x3fdd907d, 0xbf1d6360, 0x3f86735c,
    0x3f96ede4, 0x3f66c45d, 0xbf4d14c9, 0x3f95851e,
    0xbf5e56c4, 0xbfbda20d, 0x3faa93ed, 0x3f185c06,
    0x400309ef, 0xbff3a421, 0xc08769c0, 0x400824ef,
    0xbf4b3c1d, 0xc00f705b, 0xbf66369d, 0xbf19d290,
    0x40088956, 0xbf9fad14, 0xc0282719, 0xc013e70b,
    0x3ec9fa59, 0x3db9ab50, 0xbfbc682f, 0x3fa27c34,
    0xc00b1857, 0xbfb4d675, 0xbdc65ea7, 0x3f551328,
    0xbf3e8672, 0xbe996f3c, 0x3ff98e6e, 0x3f791a5c,
    0x3ea81e84, 0x403884ef, 0xbf525b41, 0xbfb04d48,
    0xbff0a9d7, 0xbedf1d34, 0xbfe5de0b, 0x4001d3ee,
    0x402fa5c0, 0xbf537d4b, 0xbf7823af, 0xc05f3cb7,
    0x3fb60c5b, 0xbfd8b54c, 0xbec4b30c, 0xc004ad71,
    0xbfba43be, 0xbc56d073, 0xbf9daa1c, 0xbf011f6a,
    0x3fe0cdaf, 0xbf83f4c2, 0x3e8cc539, 0x3f261aa0,
    0x3f407e8d, 0xbf8b6660, 0x3e0e0b38, 0xbfb9fdd1,
    0x3f6b599b, 0x40083260, 0xbca80e6d, 0xbf5502e9,
    0x3f915f24, 0x3f8f5c89, 0x4007dfa6, 0xbf795ee3,
    0x3eb97be0, 0xc0010eb9, 0xbfd11657, 0xbf842935,
    0x3f81257d, 0x400eaf03, 0xbf9c27ba, 0x3d9d73d7,
    0x3ee0242a, 0xbe016dea, 0x3fb9f528, 0xbff85305,
    0xbfdb5808, 0xbe88f6ce, 0x3f53115c, 0xbfb083ba,
    0x3f607781, 0xc02af620, 0x3fa02738, 0xbf9fa114,
    0x3f253090, 0xbe058398, 0xbfcd8f8d, 0xbf26d046,
    0xbe61def3, 0x3f06e701, 0xbe8d2404, 0xbfb3d203,
    0xbfd2b542, 0x3f4d982f, 0xbff92a84, 0xc02f96e0,
    0x3ddea2e1, 0xbfdca468, 0xbd4c6c5f, 0xbfbe355b,
    0xbf4e406a, 0xc0090139, 0x3f5a27ba, 0x3f7ed262,
    0xbf7ed408, 0xbe8ad668, 0xbe94c35b, 0xc065948b,
    0xc00465e6, 0x3f4ce770, 0x3f38e2d4, 0x402c73b0,
    0x3f2e7328, 0x3f1d8cd8, 0xbfea0310, 0x3f8c76f3,
    0xc01c96d7, 0x3f0ac15e, 0xbfa5ec2f, 0x4030d675,
    0xbe864b35, 0x3ec2f122, 0xbfa4c0ef, 0xbf515d6f,
    0x3faeeea3, 0xbf2e4c6d, 0xbfa9e185, 0x3ecf55d0,
    0xbf7f1959, 0x40081e87, 0x3f5816ed, 0xbfd33e53,
    0xbe86d523, 0xbee826fd, 0x3e0d1565, 0x40014215,
    0xbf672c16, 0xc0891b70, 0x3f9c9239, 0xc0293483,
    0x3eaf1baf, 0x4023ddc0, 0x3fec8008, 0xbf3d803f,
    0xbf4ce14d, 0x4004463d, 0x4000072c, 0x400ab979,
    0x3e9b195a, 0xbf903f30, 0xbf85493d, 0x3fa94687,
    0x3fcd489c, 0xbf916139, 0xbe6a64f6, 0xbed6efa1,
    0xbf854038, 0xbd76a044, 0x3f9e624f, 0x3ef0b75d,
    0x4008ad39, 0x3f647e17, 0xbf3c2259, 0xbfd13d26,
    0xbf9bee5f, 0xbf7164bd, 0x3f961e15, 0x3f6c2de8,
    0xbd0c291b, 0xbfa25f68, 0x402ba370, 0xbf108dbc,
    0xbecccc11, 0x3eeb1a16, 0xbfaae4e2, 0xc04841fe,
    0xc02392fe, 0xbf082802, 0x3f72b216, 0x403be905,
    0xc0204b71, 0x3d48e1af, 0x3f16189b, 0xbcde420c,
    0xbf96bd31, 0xbe95b0ee, 0x3f3b6d6c, 0x403768dc,
    0x402d3ba3, 0xc0030741, 0xbee75570, 0xbf06426f,
    0xbfefafcf, 0x3e7eb591, 0x3f12bf52, 0xbfcc27f2,
    0xc090e178, 0xc06067dd, 0xc00220a0, 0xc009e4a6,
    0x3f18a3e5, 0x3f240853, 0xbf8c9f0b, 0xc0513262,
    0x3db83906, 0x3d8ec114, 0x3e981b14, 0xbfb2308b,
    0x3f859e91, 0x3fd96ac8, 0x3e03fdd1, 0xbf9ceb26,
    0x0
    };

static const uint32_t ref_rfft_noisy_2048[2049] = {
    0x3d58333f, 0xbfb8fabf, 0x3e8d0f1f, 0x3db8eeda,
    0xbf7d51c4, 0x3f2cc7e2, 0xbf3f342c, 0xbf43e5ce,
    0xbeb9ac86, 0x40213a8a, 0xc04fe2de, 0x3f47a99b,
    0x3f55583c, 0x3ea99ef9, 0xc0105697, 0xbf3fa22d,
    0x3f314f1c, 0x3f784b4b, 0x3fd6876d, 0x3efbf498,
    0x40309e0d, 0xc0790e02, 0x3f9c855f, 0x404c0de2,
    0xbf5cd727, 0x3d589b52, 0xbf191cfa, 0x3f8ef2c0,
    0x3d0e003e, 0xbfad97af, 0x3eadb42b, 0xbfdda8e0,
    0xbd5a2aa8, 0x405fd3a8, 0xbfc7c9b0, 0xbfba5189,
    0xbe39a538, 0xc02f60e2, 0x3f383028, 0x3fa6c3f1,
    0xbffd89a5, 0xc0161a43, 0x4012a363, 0x401d04af,
    0xc021b118, 0xbf159a1e, 0x3fae5f63, 0x3fa02ea3,
    0xc02fe962, 0xbfaebf45, 0x3f1fb1d2, 0xbe92c81f,
    0x3fe66da4, 0x3f8e447e, 0xbe9125f7, 0xbdaff45e,
    0x3e0cc086, 0xbfdcf49f, 0x3f6f62bb, 0x3ff0c299,
    0x3d6cda4d, 0x3f5123a2, 0x3f5e9ad6, 0xbf4fb48e,
    0x3f41ce76, 0xbfaa711b, 0x3fbe0506, 0xc0156cb9,
    0xc0149bd2, 0xbfad2dde, 0xbee6a4a9, 0x3f3cee9c,
    0x3ed7fc59, 0x3f57f34a, 0x3e072678, 0x401f9306,
    0x3fd99952, 0x3ea1f7ed, 0x3c0521d6, 0x3ed3eca7,
    0x40184e85, 0xbf334125, 0xc008d7a6, 0x3f63e5f9,
    0x3e951648, 0xbfb5e58e, 0x3f9803fa, 0xbf477223,
    0xbf255f60, 0x3f590fe8, 0xbd3a6829, 0xbfd5a996,
    0x3f83d562, 0x405ee07d, 0xbf5a2719, 0x3ebdd2f8,
    0xbff7bba3, 0x3f382c40, 0x3f731713, 0x3d4d014e,
    0x3e7dbe2a, 0x3fce83b7, 0xbef4bdb5, 0x3d980e8f,
    0x3f3c522d, 0xbe8253fd, 0x3d910923, 0xbf331bcd,
    0xbd502b63, 0x3fbccbe2, 0xbfe899b3, 0xbf88ba2c,
    0xbfe7b147, 0x3fc3ec4e, 0x3fb1d8fe, 0x3f9a2ce0,
    0xbf9aaf06, 0xbf74ad87, 0x3ff0e103, 0xbf8b120a,
    0x3f89a183, 0xbf9a995a, 0x403013a0, 0xbed226b4,
    0xbf5aa833, 0x3fd104ae, 0xbfb272ee, 0xbee07d2c,
    0xbf36e253, 0xbfe506c5, 0x3f683c8a, 0xbe8f5b25,
    0x3f7b95cf, 0x3fb7d91a, 0x3fe7a92b, 0xbf74efdb,
    0xbf5fa351, 0x3fd3ca00, 0x3fe16d75, 0x3ce8ed7a,
    0x3d343438, 0x40323f72, 0x3e10b9c6, 0xbfea1907,
    0x40108642, 0x3c9ba99b, 0xbed8cbcf, 0x3f2d3207,
    0x3edc617c, 0x3fe591db, 0x3f8029d2, 0x3ffbff58,
    0xbf652679, 0xbd68c6a9, 0xbf753d01, 0xc0133887,
    0x3f0f51b1, 0x3f58a0dd, 0xbf5a411e, 0x3f873d6c,
    0x3f857e64, 0xbec8b31f, 0xbe57f044, 0x3d44b61e,
    0xbf92e59f, 0xbfa38586, 0xc08e6d73, 0xbff5ebf3,
    0xbf0120dd, 0x3f9dfb41, 0xbf9d4ba7, 0xbe66a7f9,
    0xbdff320b, 0x3fad289e, 0xbd946607, 0x3e0872a9,
    0xbf3b3186, 0x3fc4614f, 0x4022e160, 0xbf0b7efb,
    0x405043fd, 0xc02c7386, 0xc0282f98, 0x3f4722f0,
    0xbdb79496, 0xbf1dd1d7, 0xbfdcffa7, 0x3ea650e0,
    0xbe74fb59, 0xbfb171cf, 0xbee4c019, 0x3e9069fd,
    0xc056506c, 0xc045db83, 0x3ed0713e, 0x3f4dd59c,
    0x3f394021, 0xbfaff7d6, 0x3e1dffb2, 0x3fd2887e,
    0x3ea01b47, 0xbe1bcae7, 0xbff38847, 0xbe548970,
    0xc02be581, 0xbf2261b2, 0xc000529a, 0x3f819eef,
    0xbea428df, 0xbfc47eab, 0x3f38e095, 0x3fa2d30b,
    0xbfb1de31, 0x3f86298d, 0xc07258ca, 0xc027123e,
    0xbf80e2cc, 0xbf94fde2, 0xbef25085, 0x3f790330,
    0x3fef92f7, 0x3fd8b2a0, 0xc01a30ef, 0xbe6f8188,
    0xc0278aab, 0x3f728fda, 0x3e44f860, 0xbf944a02,
    0x3f6309cc, 0xbfd7f91e, 0xbf4d0816, 0xc0200ebe,
    0xbf9fae6b, 0x3fa78de4, 0xbe386e1a, 0xbf4390d5,
    0xbf2ab3e8, 0xc05ca6df, 0x3e8e71ca, 0xbf5947a0,
    0xc00e040b, 0xbf85ef69, 0xc0122838, 0x3ff7187e,
    0x404f433f, 0x3e13c497, 0xc000e9c3, 0x3f8d29b3,
    0xc0224ad5, 0x3e6c0951, 0xbf58e9d9, 0x3fe56786,
    0x3fb0e78d, 0x4074564c, 0x3f85c24a, 0x3ec3eb6c,
    0xc05288cc, 0xbdc1f45b, 0xbf97c9df, 0xbfa8b5a8,
    0x3f49b5cf, 0xc0095370, 0xc0257e03, 0x3e71377d,
    0x3fc9c060, 0x3fb61879, 0x3f5a0020, 0xbf804384,
    0x3fd85598, 0x3ca60bd8, 0xbe6b7512, 0xbf366ae0,
    0x3f9c3747, 0xbd9ea62a, 0x401bdd5c, 0xbd221560,
    0xbfd95123, 0x3f7d2fa1, 0x3f039331, 0xbfedaa35,
    0xc0099fcc, 0xbf1493c0, 0xbfca33d9, 0x3fb5f5a6,
    0x3f91edb0, 0xbe3ef122, 0xbe66eedc, 0x3e965a13,
    0x3da54f0c, 0x3f03ace6, 0xbf381e0b, 0x3f851031,
    0x3f5e6a1f, 0x3f2caafa, 0xbf81da40, 0x3bcaaafc,
    0x3e06d995, 0xbfa73d0c, 0x4025d0a8, 0xbfa3d67d,
    0xbe642074, 0xbeb2b542, 0x3ec9b412, 0x3f52d4f5,
    0xbf1ab1ec, 0x40200694, 0x3dffefcc, 0xbec5122c,
    0x3fb56a01, 0x3f867148, 0xbf0ac8fc, 0xbf0fa9b4,
    0x3e706945, 0x3fc84a25, 0x3ebe2630, 0x3f9c3280,
    0x4019c9f1, 0xbefa59d1, 0xbc7b0223, 0x3fc006e1,
    0x3e2429a3, 0xbf992003, 0xbfe8fa53, 0x3d54a17a,
    0x40826a57, 0xbff0ff79, 0x3e6bceb0, 0x3f1588c6,
    0x3f0aeee0, 0xbea1a97d, 0xbfdbe367, 0x40074b94,
    0xc023f20d, 0x3f4cbe95, 0x3fa31fd3, 0x3f4d00f8,
    0xbf3e02b6, 0xbfff677f, 0xc0094e62, 0x3ef259ae,
    0xbe95cb9a, 0x3ff490a0, 0x3f9fa20b, 0xbf006a9f,
    0xbc23698d, 0x3f179c88, 0xc03568e8, 0xbfd25f23,
    0xbdcaecb2, 0xbf88702a, 0x3f6cf062, 0xbfe5dd34,
    0xbfedef65, 0x3e595273, 0x3fecd528, 0xbfec0909,
    0xbfdf25c1, 0x3eef9bf0, 0xbf247ee5, 0xbfe0dbeb,
    0x3f1df52e, 0x40852397, 0x40217c52, 0xbfb45ed0,
    0xbf921ea7, 0x3e80e46b, 0xbf8f0a70, 0x3f7a89a2,
    0x3f41c39b, 0xbfe78a43, 0x403a7bdc, 0xbf281454,
    0xbf664481, 0xc0065c8a, 0xbfc7084e, 0x3f106386,
    0x3fcbd96d, 0x3f8adbf3, 0x3f8ceebc, 0xc0073bf6,
    0x4005663b, 0xc0504a37, 0xbd48f287, 0xbe16b39f,
    0xc07bedcf, 0x3f8a21d9, 0x3fdd9168, 0x3c111a33,
    0x3f6fb5ef, 0x3e71c34c, 0xbf929fae, 0xbf604ec8,
    0x3f768c62, 0xbe042c70, 0x3eca6d07, 0x407744a7,
    0x3facbf44, 0xbf0d74e4, 0xbf0ef9d4, 0xbe02115c,
    0xbe744c27, 0x3f299e2d, 0x3e1fcf20, 0x3fa197e6,
    0xc028e66b, 0x401280f6, 0x3fecca0c, 0xbf7ebcf9,
    0x40426206, 0x3fd9dbc6, 0xbf1b0526, 0x3f9c782a,
    0x3fd95603, 0xc00d4b9f, 0xc01652e4, 0x3ff31b21,
    0xbf0c7041, 0x3fc07943, 0x3f45a60e, 0x3f576677,
    0x3fe9fd6d, 0x3e28c3d6, 0x3f61e809, 0x3f13fe77,
    0x3db9031b, 0x3f08c5a6, 0x3f875238, 0xbfa3d960,
    0xbefa7a4a, 0x3f9fb4d2, 0x3fcee13f, 0x3e5a58cd,
    0x3ec4840f, 0xbf96eb15, 0x3c2bbf89, 0x3f72c8f5,
    0x3ee52bad, 0xbf1791f0, 0x3ff7693c, 0x3f07d4d4,
    0xbfef0d13, 0x3f23dd62, 0x3ff44a43, 0x3f562507,
    0x401db550, 0xc085b6af, 0x3f8bc836, 0x3fc98c38,
    0x3f4c3549, 0x3fe85073, 0x3fe15964, 0xc00a8d2c,
    0xbf41c729, 0x3f30b209, 0x4003fb42, 0xc0138f9b,
    0x3da792c5, 0xbfc6fecb, 0x40379ec6, 0xbf6cbf0a,
    0x3c4780d8, 0x3e542e55, 0x3f4be074, 0x3eef1ebd,
    0xbfe30076, 0x3f152fcd, 0xbe964387, 0xbfbc1351,
    0x3e432f6f, 0x4007ef0c, 0xbe5c8abd, 0xbd876970,
    0xbf039ac1, 0xbfcacc22, 0xbf065d5f, 0x3fbd8fb1,
    0xbfb35cb0, 0xc064cb24, 0xbf1aff10, 0xbfbbb4dc,
    0xbf89792c, 0xbd7ae0f1, 0xc01d6a88, 0xbee29f8d,
    0xbeb163ab, 0xc0138a36, 0xc02edff2, 0xbfb5ccb1,
    0xbecd5955, 0xbebcc2d7, 0x3ecb5ab1, 0xc01ca135,
    0xbfbf38f3, 0x3ce92ed9, 0xbff45374, 0xbde30e29,
    0xbf0f3a6c, 0x4043d9d1, 0x402b0ced, 0x3f985027,
    0x3f3107bf, 0x40591db5, 0xbd330cbc, 0x3f63bc85,
    0xbeecc5d6, 0xbfb22c98, 0x3ed7bd77, 0x40097341,
    0x400efff1, 0xbf918293, 0x3ff05aed, 0xbf369b53,
    0xbffe7233, 0xc43310e5, 0xc01bbcb0, 0x3e868235,
    0x3f946a09, 0xbf08e977, 0x3f5ed8c0, 0x4035f0e5,
    0xc0215f81, 0xbf064f11, 0xc042bbbb, 0xbf026bf9,
    0xbfac9350, 0x3fa152c4, 0xbfa6c0da, 0xbe2ec8f7,
    0xbc742d8b, 0x3ff23978, 0x3fad4e01, 0xc06d8ebe,
    0x4034d5a9, 0x3f90e466, 0x3fde52bb, 0x3edab100,
    0x3f3daa39, 0x3e5c3957, 0x3fd823e9, 0x3ea9a689,
    0xbeff97ee, 0xbefb71fd, 0xbf5659fe, 0xbf95293b,
    0xc0415fe3, 0x403b0a27, 0xc01f1564, 0x3fb566ac,
    0xc053fa78, 0xc0025485, 0x3f233f10, 0xbcfbf9b1,
    0x3f602510, 0x3f1abd9d, 0x3f4c8642, 0x3e81dff9,
    0x3fbdbaf3, 0x3f8ff08a, 0x3f7868a7, 0x401f121d,
    0xbf0bd6e0, 0xbf3b0d6d, 0xc024a114, 0xbd980380,
    0x3ef21804, 0xbfcd19fb, 0x4019bd66, 0x3fffe4b4,
    0x3fe9c4ed, 0xc08bc9d8, 0x409db7e1, 0x3f714366,
    0xbf8f72a1, 0x3fd9808f, 0x3d99a2ff, 0xbf5b09c4,
    0x405f8851, 0xc068ba41, 0x4018d426, 0x3f9d1f23,
    0xbfcbe49b, 0xbdb8c010, 0xbe99d17d, 0x3fca1d3c,
    0xbfd355a3, 0xc0228c1a, 0x40864f3e, 0xbfa392b5,
    0x3e0f5f04, 0x3f75629f, 0x3e32c164, 0x401b20e2,
    0x3f490d50, 0xc0379e28, 0xc04f1036, 0x401eebd6,
    0x3f83fd1f, 0xbf030f42, 0x402abfe2, 0x3f316236,
    0x3fc6686b, 0x3fea31f7, 0xbf49a8d6, 0x3e9dac71,
    0xc07092ca, 0x3fa96702, 0xbf23825e, 0xbdc6aa04,
    0x3ecdbf1f, 0xbdcd22e7, 0xbfd4ffc4, 0xbf73c687,
    0xbd0a1445, 0xc0027f86, 0xbfc6e501, 0xbf9a9032,
    0xbf9b17c8, 0x3f975ba7, 0xbf1b674f, 0xbf1a0a28,
    0xbfad9f4c, 0xbf4abfe7, 0x40358177, 0x3faed0c1,
    0xbf0f258f, 0xbd81664b, 0x3f6a7d29, 0x3d9c239d,
    0xbf73efa5, 0x4010ef99, 0xbcce96c0, 0x3e5dadd8,
    0x3f49fbf4, 0x3ffeae5a, 0xbfae5254, 0xbeb07b23,
    0x3e9d855c, 0x3e01c2a4, 0x3fe3068e, 0xbf8c4df7,
    0x4008165e, 0x3ff602bf, 0xbe82e42b, 0xbfd44ebe,
    0x402f8531, 0xbfad8522, 0xbfd625c8, 0xbf9fe696,
    0xc04dc55c, 0x3e7deae5, 0x3f95750e, 0xbf776e5a,
    0x402df246, 0xbf5e6a5c, 0xbfbd3cb6, 0xbf091a3a,
    0x3fb115fd, 0xbe863233, 0xbe3f0572, 0xbfebab2a,
    0x3f8be083, 0xbf1b3df0, 0x3d5a65ed, 0xc07bd355,
    0xbf619a73, 0xc04baec2, 0xbfd171f0, 0xbf2d6787,
    0x3f25a712, 0xbf8423a7, 0xbfa70b18, 0x3e5092ec,
    0x3ceedc45, 0xbff0d9c2, 0x4039864d, 0xbfb2a1e8,
    0x3f0662e6, 0xbf627e52, 0x3f08c67c, 0xc00e3213,
    0x3fdf8862, 0x40514731, 0x4018a848, 0xbe84c1c2,
    0x4035021b, 0xbfd0de78, 0xbfa91141, 0x3f4389f7,
    0x3db2de8a, 0xc0022a68, 0xbf9f4669, 0xbf8ec732,
    0x3fdece4e, 0xbf68b30a, 0xbf428d1e, 0xc0993694,
    0xbf892016, 0xba6408a3, 0xbfed34f3, 0x3f9f06f5,
    0x3eecbfd2, 0x3d4fff23, 0x3f3f8c75, 0x3eff6b7a,
    0xbf4d7910, 0xbf808506, 0x3ffdcd3c, 0xbf5c3887,
    0xc06f223d, 0x3c21231b, 0xbf879068, 0x3f4005fa,
    0xc013ed95, 0x3f55aee8, 0x405b9bb1, 0xbfe7e4a4,
    0x3e4421e1, 0xbf4a4b56, 0xbf8b48e4, 0xbfabe309,
    0x3e707bb6, 0xbe8af3cc, 0xbffb8d94, 0x3fe75077,
    0x40098e61, 0x3edb011c, 0xbfaa88fe, 0x3fc99168,
    0xbfe8bf9b, 0x4007182b, 0x3fbc90dd, 0xc008deac,
    0x3d83e9f7, 0x3c5ef161, 0xbda40557, 0x3f2da8dd,
    0xbfc11535, 0xbf9ea5e8, 0xbfc9833f, 0x3ff209bb,
    0xbfcf3de7, 0x405bc182, 0xc0335c0f, 0x3f68f306,
    0x3e135533, 0x3f66b060, 0xbefcd094, 0xbdc2a492,
    0xbfa402d2, 0xc047cc3a, 0x3f8fbc78, 0x4012f502,
    0x3faf7483, 0xbf35a27c, 0x3ffbbe72, 0x3fbc772a,
    0xbfbfb0bb, 0x3f6b138e, 0x3f0ce6f5, 0x3fd45871,
    0x3fb76138, 0xbfd273d7, 0x3f80812e, 0xbf23476b,
    0xbfcf34c8, 0xbfc6c1c5, 0x3e966e22, 0x3fb6425e,
    0xbfe514fa, 0x3e7faf57, 0xbf1c1215, 0x3f2bfa91,
    0xbe57630c, 0xc05bfaf4, 0xbea8ce3b, 0xbf8570d6,
    0x3ee454e6, 0xbf803735, 0xc04f2410, 0x40058310,
    0x400d7c27, 0x4054b582, 0x3f84f9b7, 0xbfb5619c,
    0x407dad93, 0xbebbd1d0, 0x3fb7a5ab, 0xbfa68606,
    0xbd06510f, 0x3fa9857d, 0x3fc173c5, 0x3e946d4f,
    0x3f3ebc36, 0x40105b5a, 0x3fcaaf18, 0xbf59b133,
    0xbfb5a032, 0x3e97a519, 0x3e52a0ed, 0xbf0f9f72,
    0xbf907ee6, 0xc0891a76, 0xbfbe510b, 0x3f1c6d7b,
    0xbf03d1cb, 0x3ff82a81, 0x3fb4fd10, 0xbe1087e8,
    0x401693a3, 0xbe421928, 0x3e8cd9b4, 0x3fa014ff,
    0x3f1dbd9c, 0x3dff1a70, 0x3ff99f4b, 0x3e8235ad,
    0xbc2ade1f, 0x3e398fbc, 0x3c85c55a, 0x3fd25b11,
    0x3fd03dc7, 0xc02ebf03, 0x3f2b2317, 0xc0a26797,
    0x3f8ec2c6, 0x3f4061fc, 0x3fa6ae1e, 0xc0044e7b,
    0x3f200585, 0xbfde2ca2, 0xc03679a9, 0xbfbb260d,
    0xbfe0bbee, 0x3f480b6a, 0x3f2abf03, 0x3f9427d9,
    0xbeb93ecf, 0xbf5cae26, 0x404825ad, 0x3e538698,
    0xbfecd612, 0x3ff762d4, 0xbf1587d9, 0x3e4888c1,
    0xbe48694e, 0x3fe750fb, 0x401ce597, 0xbdf47683,
    0x3ee9e857, 0x3d986587, 0x3faf0426, 0x3e9447da,
    0xbf867bb3, 0x40206a28, 0x3d86d953, 0xc02b920c,
    0xbf9c8e5b, 0x3fe33770, 0xbfb269ed, 0xbf233d49,
    0xbfa73022, 0xbfd1e5cd, 0xbebf0963, 0x3d65fae9,
    0x4007824a, 0x3dc8bc98, 0xbeeeb512, 0xc02b492e,
    0xc010200e, 0x3f38cd4c, 0xbf775caf, 0x3f97a834,
    0xbf2109bb, 0xbf2f1c5a, 0x3fca3989, 0x3f0cb928,
    0xbe9da979, 0x3fd9b062, 0x3fab6b2a, 0x3fcef579,
    0xc00a4606, 0xbedd31ac, 0xbfc5b979, 0x3eb79572,
    0x406603f7, 0x3e1b0266, 0xbf0fdd26, 0x3fb4dcb7,
    0xbfe1577b, 0x3d748957, 0x3f1ab54b, 0x3f8ec4e0,
    0x3f9ce556, 0x3f703f00, 0xbfc3a7aa, 0xc040bdad,
    0xbfc9a9a3, 0xbec2bd89, 0x3fb40ff2, 0xbfde0fec,
    0x40b702dc, 0xbf2c8b39, 0x3e5fe650, 0x3eadd94e,
    0x3f1373f4, 0xbf9b61fe, 0xbf7d89a4, 0x3f20e225,
    0xbfe3702d, 0x401d2a1f, 0x3fe002db, 0xbea204cd,
    0x3eac864e, 0x3fb6ef6e, 0x3f8e3364, 0x3f8f8ac7,
    0x3d3a3bce, 0x3f07ab08, 0x40771aac, 0x3ff87ca0,
    0x3f634cd6, 0x3ff9194c, 0x3e22c6fe, 0x3f62f633,
    0x407a1f65, 0xbd51bd0e, 0xc0342ed0, 0xbfa0bdf9,
    0x40531c61, 0x3f24edea, 0x4004d8c5, 0xbfec736e,
    0xc017cdc0, 0xc0991e42, 0xbf7255d1, 0xc01ed721,
    0xbfad3271, 0xc07a8f81, 0x3f036ddc, 0x3e290c9b,
    0xbf6bbe16, 0xbedf0288, 0x3f5686b3, 0x3ff85e07,
    0xbea21d00, 0xbef092b1, 0x3f909e1d, 0x3f955b94,
    0xbed504f5, 0x3f90840e, 0x4006720d, 0xc00d8722,
    0x3fc832a1, 0x3f04c1d6, 0x3fa5a03d, 0x3f39071a,
    0xbf825bbe, 0x3f8781f8, 0xc05a5a83, 0xc0086a81,
    0xbff8db85, 0x3dfee0e7, 0xbf89d8b3, 0x3e98e012,
    0xbf287909, 0x3f277cca, 0x3f322041, 0x401466c4,
    0xbd0cd689, 0x40140c60, 0xc00b349a, 0xbeb85cc6,
    0x3e0651c4, 0xbfa4d9b0, 0xbfb054e5, 0xc043314d,
    0x3fcfba95, 0x3f697391, 0x3ced10e7, 0x3f5dc3bd,
    0x3efdd90a, 0xbfc14385, 0xbf737ad9, 0x3fdccdf2,
    0xbf11102d, 0xbf9fd09f, 0x3f83644e, 0x3f261615,
    0x3f9ca8bc, 0x3cae38da, 0x4038b6de, 0xc035fd5e,
    0xbeb13cb0, 0x3f7e0261, 0x3c94afeb, 0x3fb8ac7b,
    0xc000af77, 0x3dd3ede4, 0xbfae0cc1, 0xbeba78fa,
    0x3ebef6b3, 0xbf21cc6d, 0x3ef31e84, 0xbf261531,
    0x40539c93, 0xc05a5497, 0x403a4aae, 0x3f215acc,
    0xbf6b7234, 0xbdc36e08, 0xbf993935, 0x402c959b,
    0x3f48ba44, 0x40c24707, 0xc03e59b5, 0x3f3d26b7,
    0x4040661d, 0xbfa51de7, 0xbfbf03f9, 0xbece59a3,
    0xbf8e466e, 0x3ffb3b72, 0x3fa3e776, 0x3f87b9b5,
    0x3fddd434, 0xbf0a0e2c, 0x3e6e2bc8, 0xbf82f1b3,
    0x3fb8a09f, 0x3fef7128, 0xbfb2e370, 0xbf035f46,
    0xc00321d5, 0xbf4443d5, 0x40097e59, 0xc00685bc,
    0xbf83439e, 0x3e56be38, 0x3ff5fd85, 0xc00cbaa9,
    0x3ec72455, 0x3fac1284, 0x3f6e8184, 0xbf906eb2,
    0x3f4420e1, 0x3f4db982, 0xc0271e28, 0x3fdefc54,
    0xbfa8f811, 0x4003a603, 0xbfa09dd4, 0x3f9e9f08,
    0x3fa2bd7f, 0x3f485a12, 0x3e310931, 0x3f175fa9,
    0xbfbc3cca, 0x3ede2d1f, 0x3f96dd42, 0xbbdb2396,
    0xc0405196, 0x4040fccd, 0xc0168fae, 0xc0729d5b,
    0xc014f51a, 0xbff904da, 0xbf87cace, 0xc03bc533,
    0xbf732010, 0x3eb7c410, 0x3d6cbf56, 0x403aeac3,
    0xc013a283, 0xbfba694b, 0xc06768bd, 0x3fe46044,
    0x3f978d1e, 0xbf9d8a3e, 0xbf11c455, 0x3ed4fc9f,
    0x4009868c, 0xbf1b322f, 0xc011042f, 0x3f1325d4,
    0xbf3df305, 0x3f17f63e, 0xc00c1c7d, 0x3f05fc7c,
    0x4090765f, 0xbf46d179, 0xbe308822, 0xbffc10bb,
    0xbe913faa, 0xbe73135d, 0xbf179a98, 0xbf8b7144,
    0xbf8cea5f, 0xbf1cd217, 0xc0332836, 0x3f8608b0,
    0xbe9f4bcc, 0x400185ef, 0x3fac6c61, 0x3fc8f3ad,
    0xc009929a, 0xbfe1491b, 0x4020f1db, 0xbf49dc7c,
    0x3f9415dc, 0xbef30a07, 0x3f8e8829, 0xbf09d467,
    0x3d17768f, 0xbe183508, 0xbeb01549, 0xbfc9d5bd,
    0xbfa2efcc, 0x401a1f62, 0xbedf1368, 0xbf3bed54,
    0xbe369dd6, 0xbf93cd70, 0x3d605ebd, 0x402370b5,
    0x3f3b27ba, 0x3f7b7144, 0xbfb718b2, 0xc0173cb8,
    0x3f695359, 0x3f31b936, 0xbf97558f, 0xc028c8ea,
    0xbfe2517b, 0x4002fb60, 0xbf6a6df9, 0x3fe4f5a0,
    0x3f80191a, 0xbf4bb672, 0x3f377725, 0xbfd2cc38,
    0xbf84c238, 0x3f50a6c2, 0xbfbbc5e8, 0xbfada23f,
    0xbf949543, 0xc04325ec, 0x404c8000, 0x3fc4ecf3,
    0xbec0bddb, 0x402b06da, 0xbf5271fc, 0xc013df15,
    0x400d7e51, 0x3fd3fd8d, 0x3f5652e2, 0xc008084c,
    0x3efa736b, 0xbfd91db0, 0xbc8ff393, 0xbf553dfd,
    0x3faa5ed0, 0x3eaaee07, 0xbf3f1c28, 0xbfb8f1d6,
    0xbeb2832d, 0xbf22e56a, 0xbfeeeb39, 0xbfb2236a,
    0xbe58a28f, 0xc008280b, 0xc008b0af, 0xbf632868,
    0xc036e869, 0x3fde3b54, 0xbec83130, 0x3eb6178a,
    0xc0091ca2, 0xbe1055f9, 0xbe8bbf00, 0x3d91b3e6,
    0xbeb9696a, 0xbf716fd4, 0xc00b400c, 0xbf9a8418,
    0x3f7e9888, 0x3fbc6a26, 0xbf0735dc, 0xbf1e71a8,
    0x3ebb4389, 0x3fea2951, 0xbffd9702, 0x3fe76eae,
    0x40322ef7, 0xbc6db642, 0xbf9bdd56, 0xbfa15cc0,
    0xbf3ead09, 0x402d4d00, 0xc0567f81, 0xbfa23ac6,
    0x3f29e049, 0xbf9b097d, 0xc00e3031, 0xbf788dda,
    0x3f537413, 0x3f5873b5, 0xc0244f53, 0xbfb403a8,
    0x401a06bc, 0x3f0c7242, 0x3ee57aad, 0xbff7c5d1,
    0x3da5c133, 0x3f372ee0, 0x3e08b962, 0xbe56e706,
    0x400c781e, 0xbf014985, 0xc04867e5, 0x3f329421,
    0xbf14f3c0, 0x4014278e, 0x3da0b092, 0x3f3628e3,
    0x3fb125a5, 0x3fbf1ba1, 0x3fbf2989, 0xbfaed28d,
    0x3e24e796, 0xbf5546fa, 0xbfda5123, 0x4011d4e1,
    0xc02ac6a4, 0x40140554, 0x3f6dbc5a, 0xbf221bee,
    0xbf9a8602, 0xbedcb2c0, 0xbf40f6f4, 0xbd134bd7,
    0xbf1f806f, 0xbf15e939, 0xbf5be0f2, 0x3ee55aa5,
    0xbf9ef010, 0x3e8c8346, 0x3f9ddb7d, 0x3fd926d4,
    0x3eda6185, 0x3f7ad272, 0x3ede481c, 0xc04704df,
    0x3e332288, 0xbf837f34, 0xbf142272, 0x3c7bc4a1,
    0x3f842ef6, 0x3f481ff8, 0x3fb29b25, 0x3fbfdd40,
    0xbf41420e, 0x3f0cce3a, 0x3f4177d2, 0xbf4bf7fb,
    0x3f801b30, 0xbf3bec44, 0x3f47b87f, 0x3fb55b59,
    0x402713f5, 0x3f230ad2, 0x3f805d68, 0x3ec5d6f5,
    0x3f0a1a09, 0x3ed930b7, 0x3f5e3ecb, 0x3ed9fadd,
    0x3ed0242d, 0x4033c554, 0xbf4c96dc, 0x3eeec255,
    0xbf91546d, 0x3facc979, 0xbf9161c2, 0xbe578f3f,
    0xbf0d91d4, 0x3f84d1a2, 0x4061ae75, 0xbfc58353,
    0xbf7ace23, 0xc00418e6, 0x40c7e4c9, 0xbf86c18e,
    0x3dfc41bc, 0x3f01d4fb, 0x3eeb385c, 0x3fcc4e94,
    0x3f193ebe, 0xbefe356f, 0xbee84a76, 0x4051a7f3,
    0xbe645715, 0xbf92783c, 0x3fda81ad, 0x3ea4fe6d,
    0x4022be79, 0x40080b9d, 0xbef8330d, 0xc0039543,
    0xbf026e44, 0x4024db26, 0x3fb17ec4, 0xbf7de301,
    0xbfba8372, 0xbede4fc2, 0xbf1d5099, 0x3fb97e7b,
    0x3f91e57f, 0x3fc580f5, 0xbef5ec2e, 0xbe92ff9b,
    0xbfce89c8, 0xbf4ac7ae, 0x3fb14982, 0xbefefcd6,
    0x3f8fa225, 0xbf8c57ce, 0x4014ee49, 0x3eb57db3,
    0xbf0df043, 0x40266d28, 0xbf3cf5ff, 0xbdd41081,
    0x3ff6970d, 0x3f96056c, 0xc0598c0c, 0xbead5d7b,
    0x3f81cb69, 0xbfcd6106, 0xbfc51a6f, 0x3f1b631a,
    0x3f06ba9c, 0xbdb14b59, 0xbfdcba1e, 0xbf9d4f99,
    0xbfff137c, 0xbf764fb3, 0xbe06a107, 0x403d05e2,
    0xbff130f7, 0xbfb6cb8c, 0x3f91c90e, 0xbe08ae50,
    0xbddfc697, 0xc021251d, 0xbf99c3f1, 0x40763ea6,
    0xbe979e48, 0xbf23907f, 0xc04b79d0, 0x3d31ed7a,
    0x3f5f3516, 0x3f106acf, 0xbf345229, 0xc013f891,
    0x3f9e345d, 0x3f6039f9, 0xbfcf176e, 0xbfa7a6df,
    0x3f285f37, 0x3ea350c0, 0x3f7851f1, 0xbe578f7f,
    0xbfef8b42, 0x3f3d79ef, 0xc04c3864, 0x3fe8ec8b,
    0x3f1e50d7, 0x3fe7d3b8, 0xbee3b86d, 0xbe35877f,
    0x3fea3bb5, 0xbfc1a31c, 0x3febb762, 0xbfbb33de,
    0x3fca6f4e, 0x40310355, 0x3e225358, 0xbfe6d2f5,
    0x3e2517e8, 0x3fc341c1, 0x4011453b, 0xbdc1c585,
    0xbeb7f6d9, 0x3f0ee7e2, 0x3f596701, 0x3fdce33f,
    0x3f86fb69, 0xbf0caa90, 0xc029f275, 0xbfe3f9e7,
    0xbf39f15f, 0x3f9e7338, 0xbf9fabd9, 0xbff61b48,
    0x3fb939b7, 0x3ef84a93, 0xbf29f595, 0x3ee478b3,
    0x4059c08b, 0x3f714e8d, 0x3f5ebc27, 0xc04f37d5,
    0xbf9098af, 0x3df29492, 0x3e8e67ed, 0x3edc3786,
    0x3f91ca3f, 0xbf8296a8, 0xbf9a506a, 0x3f644730,
    0xbfa615f3, 0x3f164758, 0x4070fcce, 0xc02efc32,
    0x3fbc68b4, 0xbf8bbc64, 0xbea581a8, 0x3fbb606c,
    0x40051c37, 0x40037890, 0x3eca4267, 0x3fb9d950,
    0xbe2a41ba, 0xc050bedb, 0x40032e8c, 0x3fbc59cd,
    0xbd7dcfc9, 0xbe237401, 0x3ee73214, 0xbfafc4d6,
    0x3e888c51, 0xbf34c93a, 0xc06d3bea, 0xbf51eff1,
    0xbff3d690, 0x406cdcc0, 0x3f4fbc0a, 0xbfa53ed0,
    0x3e524757, 0xbf3b479b, 0xbfdaeef7, 0x402e027a,
    0xbfc2f57d, 0xbf190141, 0xbf456a12, 0xbf6d7046,
    0xc01d4f11, 0xbde2e549, 0xbebb770a, 0xbf7d47ba,
    0x3fa4eeb8, 0x40888b8a, 0xbce15e0d, 0xc0240f86,
    0x3f562989, 0xbf18b87e, 0x4014f6ba, 0xbf6aa261,
    0x3fdb1817, 0xc023040c, 0x401c797a, 0xbf9725e6,
    0xbee28e10, 0x401af3c0, 0x3f6783ed, 0x3f455d94,
    0x3e0e8541, 0x3d489f43, 0xc016e43c, 0xbfb87f0c,
    0x3e140968, 0xbfef33b8, 0xc0033d09, 0x3ef5dfd3,
    0x3d8a1b50, 0x4011cc09, 0x405bc474, 0x3ec1d1dd,
    0x3fc01bd8, 0xbd23b1b0, 0xbf8b343a, 0xbfe4dd8a,
    0x3d486c7b, 0x3fe101a9, 0x3fd4eb60, 0x40028658,
    0x3f303070, 0x3fc73b83, 0x3f257b76, 0x401719cb,
    0xc00a8955, 0x3e684ed6, 0xc027fa5b, 0x400a05e9,
    0xbfa0cc1d, 0xbf5d3cb5, 0x40530b0c, 0x3ed86918,
    0x3d8391d6, 0xbfad99c5, 0xbfdd2ea0, 0x3fa2fc25,
    0x3ff2bd2d, 0x400a20ba, 0xc02524fe, 0x3e851c71,
    0xbfddfbfc, 0xbf8b2bfb, 0xbfa283a6, 0xbf68f536,
    0x403a3b8b, 0xbf636932, 0xbf3eff83, 0xbfbdcc4c,
    0x3e248f26, 0x3f3e34eb, 0xbfeed832, 0xbf949e82,
    0x3e489120, 0xbfdf41a2, 0xbf64b53e, 0x3fb793c6,
    0xc0186157, 0x403c0e1d, 0xbe85355f, 0x3fcfc89d,
    0x3e5a67e9, 0xc0856e2d, 0x3f5166ef, 0xbfff653e,
    0xbf78cc3d, 0x3edde79d, 0xbf811425, 0x404c7bed,
    0xbf8a2b85, 0x3f61a15a, 0xc00a6b1f, 0xbeb95f6d,
    0x3f1869b2, 0x3ef8e886, 0xbfc0d362, 0xbfb33333,
    0x3e490740, 0x3e6d0cd4, 0x3fddd45f, 0x3fbf52b7,
    0xbf57c28e, 0x3f3c480c, 0xbff05c7d, 0x403c4f0a,
    0x3af6f3f4, 0x3ecd65e5, 0xc06554a3, 0x40253ee7,
    0xc04db356, 0x3dc0aa66, 0x3faf57e4, 0x405f40f9,
    0xbe999ccf, 0x3fadf631, 0x3e8ef3c3, 0xbf09feee,
    0xbea7dbc2, 0xc025fa88, 0xc02fc4de, 0xbff98db7,
    0x3e9c33ed, 0x40239d79, 0xbf269f93, 0x3cb82094,
    0xbea6cd4c, 0xbfe2563c, 0xbe98fead, 0xbead77fa,
    0xbfc9c891, 0xbf32977f, 0x3fc8c827, 0x3fd6a127,
    0xc00170ec, 0xbea4757d, 0x3fb8dd9b, 0xbf8af5f7,
    0x3e716ca9, 0x3f9940fc, 0x3f062100, 0xbed4f779,
    0x406526f2, 0xc0157e1e, 0x40305d73, 0x3e6b0479,
    0x4004ae34, 0x4043c04b, 0x3f75fc64, 0x401f4cca,
    0xbea8f404, 0x406e7be1, 0xbeefb721, 0x3f1c9167,
    0xbfa6ce74, 0xc01addd2, 0x3eeeaa68, 0xbe92d6ef,
    0x3e956b77, 0x3f49a851, 0x3fb9828f, 0x3f385b44,
    0x3f97c66f, 0xbd05a5e3, 0xbfeb3446, 0xbf886581,
    0xbfbc16be, 0xbf8ed40e, 0xc000accd, 0x40019cee,
    0x3ee15459, 0xbe2bf4c3, 0xbf2d1d08, 0xbdf94212,
    0xc096d3c9, 0x3e9f8eb0, 0x3ff186cc, 0x3fedf60a,
    0xbf8dcdc2, 0xbf9036aa, 0xbea60251, 0xbf9a87db,
    0xbec81215, 0x3f1ac1f8, 0xbdf6a0d0, 0x3e537081,
    0xbf89633a, 0xc03a0657, 0xbfdccf47, 0xbf801ad6,
    0x3fd68559, 0x3f121efa, 0x3fcd19ff, 0x40001a1e,
    0xbf8e2f54, 0x3f971681, 0x400f807f, 0x3f51e323,
    0x4041722c, 0xc00d2b4b, 0x3f8f2822, 0xbee3c52c,
    0x406017e7, 0x3f12cef5, 0x3f593716, 0xbfb065b8,
    0xc0021d67, 0x3f878ff3, 0xbee8cede, 0xbf57e420,
    0x3f1fa154, 0x3f9549be, 0xbd8864f3, 0xbfd8db91,
    0x3f8900e1, 0xc00ccfef, 0xbf916c7b, 0x402241ac,
    0xbfd23342, 0x3d8d433c, 0xbf332653, 0xbf7b4365,
    0xbf622f68, 0xbed57ade, 0xc027a710, 0xbffb6e0e,
    0xc00e8f19, 0x402102a4, 0xbf97445a, 0xbe9bb6a8,
    0x3ee67ba5, 0xbe1a92e4, 0x3f377e7b, 0x3ee0b932,
    0xbf5d240d, 0xbee472a8, 0x3dba968a, 0xc05f2dc9,
    0xbfe84b6d, 0x3e487963, 0xbfb17b13, 0xbd47d617,
    0xbf54576d, 0xbf9ac4b5, 0x3ec9ef79, 0x400b715a,
    0xbf610aac, 0x3f005c63, 0xbf6d31f7, 0xbe7ed767,
    0xbeb0a00a, 0xbf8506a3, 0x3fb30e94, 0xbf0f4b95,
    0x3fa5694d, 0x3fb03e33, 0xbf111516, 0x3fb90641,
    0x3ffa0924, 0xbf9b9cb2, 0xbdc2fe09, 0x3f122e54,
    0xbeedd5dc, 0x3ffb655f, 0x3e69e916, 0xbea873cc,
    0x3ea4ad2c, 0xbf43deab, 0x3ffffe1a, 0x3e2c25b0,
    0xbf396ed7, 0x3f4ddcfc, 0xc0481516, 0x3fb47ee3,
    0x3f8719da, 0xbe490e2c, 0x3f095630, 0xbef5210b,
    0xbffc1fe5, 0x3fcc7fd1, 0xbf85d61f, 0x3f31fcfa,
    0xbffde10c, 0x3fc3ac27, 0x3fb9043a, 0x3f8b01dd,
    0x3f04942b, 0x3f6caf73, 0xbf232d80, 0xbe8a1845,
    0x3f898832, 0xbf9c0a9a, 0x3edce729, 0x3f49236d,
    0x3e400954, 0x3ef82b0f, 0x3f62e286, 0x404c9446,
    0xbeafb2a5, 0x3fddc3df, 0x3f0f6216, 0x3fcc1fb3,
    0xc02e7254, 0xbf8a1b35, 0xbfc04846, 0x3fc93688,
    0xbf418125, 0xc01608b5, 0x3fc7e0f2, 0xbf99b1e1,
    0x406861ec, 0xbf7e94d6, 0xbf5b76f5, 0x3ee6cbec,
    0xbf707aba, 0xbf7cf602, 0xbda93906, 0xc0129df6,
    0x3fa51f98, 0xbfa753ee, 0x3fc9a73b, 0x3eb996c3,
    0xbe76a45f, 0x3fa082b9, 0x3f36669f, 0xbfdd4eaa,
    0xc00449d2, 0xbf1f1020, 0x3fb0217b, 0x3dcb91e3,
    0xbd804398, 0xbff80933, 0x3f00f852, 0xbf0b5233,
    0xbf6747da, 0xbfdb2cfe, 0xbe9e7aa8, 0xbe1c2ea2,
    0x4048ccd9, 0xbf603f68, 0xbf81dbeb, 0x400796bf,
    0x3f64c472, 0xc082ceec, 0xbee159e0, 0xbeec0ff8,
    0xc011e01b, 0x3f542fc3, 0x3f5b74c3, 0xbfa8b87d,
    0xbeb43cc8, 0xc01cda3d, 0xbfcfbe1c, 0x3d1b88a2,
    0xbe4ccd08, 0xc00cf8c0, 0x4016485d, 0xbf410525,
    0x3fc23553, 0x3e8f53ea, 0xbd65d82b, 0x3eca5eb5,
    0x3e592373, 0x3faf3ef3, 0x3fbf1d0a, 0x3e451310,
    0x400bfdce, 0xc00cb32a, 0x4012f0e1, 0x3f738861,
    0xbde9639c, 0x3f0f7ccc, 0x3f25073d, 0x3f69ca90,
    0x3f24f7d8, 0x3fdd907d, 0xbf1d6360, 0x3f86735c,
    0x3f96ede4, 0x3f66c45d, 0xbf4d14c9, 0x3f95851e,
    0xbf5e56c4, 0xbfbda20d, 0x3faa93ed, 0x3f185c06,
    0x400309ef, 0xbff3a421, 0xc08769c0, 0x400824ef,
    0xbf4b3c1d, 0xc00f705b, 0xbf66369d, 0xbf19d290,
    0x40088956, 0xbf9fad14, 0xc0282719, 0xc013e70b,
    0x3ec9fa59, 0x3db9ab50, 0xbfbc682f, 0x3fa27c34,
    0xc00b1857, 0xbfb4d675, 0xbdc65ea7, 0x3f551328,
    0xbf3e8672, 0xbe996f3c, 0x3ff98e6e, 0x3f791a5c,
    0x3ea81e84, 0x403884ef, 0xbf525b41, 0xbfb04d48,
    0xbff0a9d7, 0xbedf1d34, 0xbfe5de0b, 0x4001d3ee,
    0x402fa5c0, 0xbf537d4b, 0xbf7823af, 0xc05f3cb7,
    0x3fb60c5b, 0xbfd8b54c, 0xbec4b30c, 0xc004ad71,
    0xbfba43be, 0xbc56d073, 0xbf9daa1c, 0xbf011f6a,
    0x3fe0cdaf, 0xbf83f4c2, 0x3e8cc539, 0x3f261aa0,
    0x3f407e8d, 0xbf8b6660, 0x3e0e0b38, 0xbfb9fdd1,
    0x3f6b599b, 0x40083260, 0xbca80e6d, 0xbf5502e9,
    0x3f915f24, 0x3f8f5c89, 0x4007dfa6, 0xbf795ee3,
    0x3eb97be0, 0xc0010eb9, 0xbfd11657, 0xbf842935,
    0x3f81257d, 0x400eaf03, 0xbf9c27ba, 0x3d9d73d7,
    0x3ee0242a, 0xbe016dea, 0x3fb9f528, 0xbff85305,
    0xbfdb5808, 0xbe88f6ce, 0x3f53115c, 0xbfb083ba,
    0x3f607781, 0xc02af620, 0x3fa02738, 0xbf9fa114,
    0x3f253090, 0xbe058398, 0xbfcd8f8d, 0xbf26d046,
    0xbe61def3, 0x3f06e701, 0xbe8d2404, 0xbfb3d203,
    0xbfd2b542, 0x3f4d982f, 0xbff92a84, 0xc02f96e0,
    0x3ddea2e1, 0xbfdca468, 0xbd4c6c5f, 0xbfbe355b,
    0xbf4e406a, 0xc0090139, 0x3f5a27ba, 0x3f7ed262,
    0xbf7ed408, 0xbe8ad668, 0xbe94c35b, 0xc065948b,
    0xc00465e6, 0x3f4ce770, 0x3f38e2d4, 0x402c73b0,
    0x3f2e7328, 0x3f1d8cd8, 0xbfea0310, 0x3f8c76f3,
    0xc01c96d7, 0x3f0ac15e, 0xbfa5ec2f, 0x4030d675,
    0xbe864b35, 0x3ec2f122, 0xbfa4c0ef, 0xbf515d6f,
    0x3faeeea3, 0xbf2e4c6d, 0xbfa9e185, 0x3ecf55d0,
    0xbf7f1959, 0x40081e87, 0x3f5816ed, 0xbfd33e53,
    0xbe86d523, 0xbee826fd, 0x3e0d1565, 0x40014215,
    0xbf672c16, 0xc0891b70, 0x3f9c9239, 0xc0293483,
    0x3eaf1baf, 0x4023ddc0, 0x3fec8008, 0xbf3d803f,
    0xbf4ce14d, 0x4004463d, 0x4000072c, 0x400ab979,
    0x3e9b195a, 0xbf903f30, 0xbf85493d, 0x3fa94687,
    0x3fcd489c, 0xbf916139, 0xbe6a64f6, 0xbed6efa1,
    0xbf854038, 0xbd76a044, 0x3f9e624f, 0x3ef0b75d,
    0x4008ad39, 0x3f647e17, 0xbf3c2259, 0xbfd13d26,
    0xbf9bee5f, 0xbf7164bd, 0x3f961e15, 0x3f6c2de8,
    0xbd0c291b, 0xbfa25f68, 0x402ba370, 0xbf108dbc,
    0xbecccc11, 0x3eeb1a16, 0xbfaae4e2, 0xc04841fe,
    0xc02392fe, 0xbf082802, 0x3f72b216, 0x403be905,
    0xc0204b71, 0x3d48e1af, 0x3f16189b, 0xbcde420c,
    0xbf96bd31, 0xbe95b0ee, 0x3f3b6d6c, 0x403768dc,
    0x402d3ba3, 0xc0030741, 0xbee75570, 0xbf06426f,
    0xbfefafcf, 0x3e7eb591, 0x3f12bf52, 0xbfcc27f2,
    0xc090e178, 0xc06067dd, 0xc00220a0, 0xc009e4a6,
    0x3f18a3e5, 0x3f240853, 0xbf8c9f0b, 0xc0513262,
    0x3db83906, 0x3d8ec114, 0x3e981b14, 0xbfb2308b,
    0x3f859e91, 0x3fd96ac8, 0x3e03fdd1, 0xbf9ceb26,
    0x0
    };

static const uint32_t in_rfft_noisy_4096[4096] = {
    0xbd0b39be, 0x3f06b08e, 0x3f31bcf5, 0x3ee679eb,
    0x3cd60b71, 0xbf0a63c9, 0xbf35db68, 0xbf16696a,
    0xbdc54390, 0x3efa3536, 0x3f32f580, 0x3efbc424,
    0x3c3a5d6a, 0xbf024cc5, 0xbf148b36, 0xbf182ea7,
    0x3c170fb4, 0x3f09403b, 0x3f2e2ae7, 0x3f0fe1d4,
    0xbc6b8aaa, 0xbeec22a1, 0xbf38f7d9, 0xbf067b14,
    0xbd1ba9dc, 0x3efb6ab7, 0x3f39c881, 0x3f06d4f5,
    0x3d469061, 0xbef91fa6, 0xbf349cc0, 0xbf005638,
    0x3dea9426, 0x3f020c65, 0x3f267814, 0x3f0fcacb,
    0xbd1a295a, 0xbef96f25, 0xbf316da7, 0xbeeda27b,
    0x3ab6a82f, 0x3eeb701e, 0x3f167583, 0x3ed82ada,
    0x3d07c465, 0xbf09dfed, 0xbf27a70e, 0xbefe51be,
    0xbda71bb5, 0x3f09bd37, 0x3f2deb16, 0x3efc21e9,
    0xbc0a95af, 0xbf0f299e, 0xbf37767b, 0xbef4787b,
    0x3da62e17, 0x3ef52271, 0x3f362e97, 0x3ef9ae3e,
    0xbcf0502b, 0xbedebf58, 0xbf3f1002, 0xbf053756,
    0xbc687f63, 0x3f06eed1, 0x3f38bf0c, 0x3f125472,
    0xbd282b6d, 0xbf047a67, 0xbf319b4b, 0xbf0ba01b,
    0x3c2539d5, 0x3f00607a, 0x3f3f179b, 0x3ef610cd,
    0xbe1c4f74, 0xbf0505e1, 0xbf3b15e8, 0xbefc3ba4,
    0xbd0d1058, 0x3f076b89, 0x3f392657, 0x3f0811a3,
    0x3cc1f548, 0xbf098677, 0xbf3c11e4, 0xbef7b556,
    0xbdf485c6, 0x3f02e02d, 0x3f346e64, 0x3f189fd2,
    0xbd9d225c, 0xbee6905e, 0xbf2c0204, 0xbf0265b2,
    0xbd607b21, 0x3ee79488, 0x3f230e78, 0x3ee36e62,
    0xbc4ce142, 0xbed3a6b4, 0xbf34f094, 0xbeee8200,
    0xbc8e909d, 0x3ef9b02f, 0x3f2f5a4a, 0x3edc9e54,
    0x3ce8dbc8, 0xbefa9ea8, 0xbf4155a8, 0xbf09584d,
    0x3c8457e7, 0x3ecf4472, 0x3f4120ac, 0x3f08591f,
    0xbddeeb28, 0xbeedef3d, 0xbf2a69cf, 0xbf0ee330,
    0xbdbe65cf, 0x3eede03a, 0x3f2685c3, 0x3f0bd26f,
    0xbcb71d6d, 0xbeda9319, 0xbf2ca719, 0xbf066053,
    0x3cd96389, 0x3f11fe39, 0x3f31111e, 0x3ef9edc0,
    0xbc3f6589, 0xbee7944d, 0xbf3386d6, 0xbecda266,
    0x3d559af9, 0x3ee040ff, 0x3f43fd8a, 0x3ed10443,
    0xbc84ca32, 0xbf12520c, 0xbf322559, 0xbef28899,
    0xba17d655, 0x3f016062, 0x3f3d10c6, 0x3ef6e917,
    0x3d461ded, 0xbebf4f42, 0xbf417738, 0xbef82c23,
    0xbd5425f4, 0x3f196895, 0x3f2db5d4, 0x3f0957a6,
    0xbc588613, 0xbf04e399, 0xbf2d4a23, 0xbee5f630,
    0xbd3a02c3, 0x3f08de7f, 0x3f47f253, 0x3ef29192,
    0xbc9a6838, 0xbef2b8f5, 0xbf24f960, 0xbed5c3e8,
    0xbd932e75, 0x3eead2bb, 0x3f283af3, 0x3f09797d,
    0xbc5020f2, 0xbed89d6b, 0xbf2c78f0, 0xbf042da9,
    0x3e13fdbd, 0x3eea0ad9, 0x3f1700d6, 0x3f145c2c,
    0xbb3f63da, 0xbf05e83f, 0xbf3fbe8d, 0xbed6f68d,
    0x3d028719, 0x3ee60846, 0x3f3d04cc, 0x3f01d5fc,
    0xbd0b21c5, 0xbef909b1, 0xbf19bb13, 0xbefa560a,
    0xbda1eded, 0x3eeb3a9c, 0x3f2b727a, 0x3f023902,
    0xbd29888b, 0xbef5d0b8, 0xbf2f35dc, 0xbeca7b07,
    0xbd83003f, 0x3ecf39a6, 0x3f3bc699, 0x3eee826a,
    0xbd2f97c6, 0xbed0ac2a, 0xbf41bf31, 0xbf018cb7,
    0x3d6423c1, 0x3ef8308d, 0x3f41de8d, 0x3ee0c96c,
    0x3c709ed6, 0xbef1bc30, 0xbf2fe0d8, 0xbeef7967,
    0x3c516816, 0x3ed83157, 0x3f3306c4, 0x3f06dae8,
    0x3b862223, 0xbf04523f, 0xbf18cf78, 0xbee1168c,
    0x3d3f67a4, 0x3f0d5a47, 0x3f4420ba, 0x3f093d8a,
    0xbcfd24d5, 0xbf01f8eb, 0xbf38977c, 0xbeedf7b0,
    0xbdd9b133, 0x3f01ba03, 0x3f2fe3e2, 0x3f04c546,
    0xb9b40b4e, 0xbedf8907, 0xbf36ee20, 0xbf00414d,
    0xbc84d8d9, 0x3ee73771, 0x3f21b7a4, 0x3ef0cc3c,
    0x3bda1daf, 0xbedd0de7, 0xbf2f91e2, 0xbef8c060,
    0xbc484d24, 0x3ef74fb0, 0x3f2bc931, 0x3ef21689,
    0xbd3a9c82, 0xbf008028, 0xbf3da278, 0xbef3af46,
    0x3deb4254, 0x3ee5b11f, 0x3f21f120, 0x3efe06e9,
    0x3d00baca, 0xbf03078a, 0xbf3ca1a9, 0xbf1390b2,
    0xbb840407, 0x3ee49791, 0x3f2cd1fa, 0x3f0257d8,
    0xbd8ecbde, 0xbedc12b0, 0xbf2b344d, 0xbef20bfc,
    0x3d620682, 0x3ee736fa, 0x3f28d27e, 0x3ec82436,
    0x3cbd9d19, 0xbef9a09f, 0xbf4cbc95, 0xbef4d5cc,
    0xbdab0e75, 0x3ed4ea48, 0x3f32e5b4, 0x3f09c73b,
    0xbcd3a106, 0xbf0037c7, 0xbf206d53, 0xbef637fb,
    0x3b8c2148, 0x3f0a1b1f, 0x3f30d8ab, 0x3f009798,
    0xbdeddd8e, 0xbef011d4, 0xbf3106e7, 0xbf0c0182,
    0x3cbde115, 0x3ef74cbf, 0x3f291276, 0x3ef93458,
    0x3d1cff51, 0xbefcdc28, 0xbf211f76, 0xbef2cc25,
    0x3b521c27, 0x3f0362b6, 0x3f309a87, 0x3ee9d16a,
    0x3b0a108a, 0xbf054c83, 0xbf30d18c, 0xbef99b5b,
    0x3dda9ccd, 0x3ecfa4b5, 0x3f3d197d, 0x3ee937da,
    0x3d75390b, 0xbef058d4, 0xbf1109d3, 0xbf0978ad,
    0xbd3d056d, 0x3f01d83a, 0x3f2b0d3e, 0x3f12da43,
    0x3d27784a, 0xbee5896b, 0xbf36d40a, 0xbf039641,
    0xbb946702, 0x3ef8c5a1, 0x3f3d2624, 0x3ef4af6f,
    0x3d72a359, 0xbf0c8373, 0xbf26c282, 0xbeef99e5,
    0x398118be, 0x3ed19ec4, 0x3f461d45, 0x3ef5ea66,
    0x3dbd8974, 0xbedfd752, 0xbf3bee9c, 0xbef32045,
    0x3bef4d72, 0x3eddbd67, 0x3f314b6e, 0x3ef278d9,
    0x3d2dc445, 0xbf1196c4, 0xbf370b42, 0xbee92957,
    0x3d4b79b6, 0x3ed84daf, 0x3f2e759a, 0x3f10db5e,
    0x3d04874f, 0xbec7d652, 0xbf1f427b, 0xbf017727,
    0xbdbabe95, 0x3f017a4a, 0x3f36fdfc, 0x3ef2427b,
    0x3d97d762, 0xbef67a8b, 0xbf2745ae, 0xbf0665a4,
    0xbd50e0df, 0x3ee5bc35, 0x3f368b15, 0x3ee0a214,
    0xbd262ab4, 0xbf0b7ab4, 0xbf46c8f3, 0xbefc258b,
    0x3cb6431e, 0x3ee1b3aa, 0x3f47d8c8, 0x3eeca8dd,
    0x3e0318a7, 0xbf0beea3, 0xbf46c4a2, 0xbef95708,
    0x3d4c7b89, 0x3ef81dd3, 0x3f304133, 0x3f166963,
    0x3c891025, 0xbeec08d1, 0xbf3c0485, 0xbef5f547,
    0xbd113384, 0x3f014f9c, 0x3f428e48, 0x3f0fa0b4,
    0x3bbb72dd, 0xbec740dd, 0xbf38cf1a, 0xbef38554,
    0xbdbd7954, 0x3f007e3e, 0x3f376147, 0x3ee21c6d,
    0x3c1b73e0, 0xbf0accc4, 0xbf2f339c, 0xbed3cff9,
    0x3ac6d29e, 0x3ed85a63, 0x3f406181, 0x3efec2a0,
    0x3d0e9d0c, 0xbf144dd2, 0xbf23b279, 0xbefd5dc6,
    0xbe16b58f, 0x3f03a234, 0x3f488d83, 0x3ef41593,
    0x3cc0af8b, 0xbf00f680, 0xbf3bb195, 0xbf130c18,
    0x39317ad4, 0x3eef4bc7, 0x3f36b424, 0x3eeaecd6,
    0x3d9eedea, 0xbf0a08b4, 0xbf163d3d, 0xbf10d405,
    0xbdb53096, 0x3f1000e0, 0x3f2a3bd0, 0x3f0bbcb0,
    0xbdc24802, 0xbeeadba9, 0xbf395e30, 0xbeeb554a,
    0xbc421bfe, 0x3f00f8ff, 0x3f37194a, 0x3ee8b2f5,
    0xbdcabc55, 0xbf03934c, 0xbf310a15, 0xbf01dc70,
    0x3c3534d4, 0x3f137805, 0x3f30ddad, 0x3f13d723,
    0x3d32f620, 0xbee264e9, 0xbf26b27a, 0xbee99231,
    0xbc53b2f2, 0x3ee8e9d8, 0x3f2ccfda, 0x3ef07667,
    0x3d06a702, 0xbf05ff6a, 0xbf3ff0a9, 0xbf0a1361,
    0x3d1437bb, 0x3f02755d, 0x3f214246, 0x3f096622,
    0x3c49f94b, 0xbeeed476, 0xbf4103c5, 0xbed4565e,
    0xbd8d9a93, 0x3f06e9bd, 0x3f2eacbf, 0x3f090eb2,
    0x3c2c30ed, 0xbedb3848, 0xbf5531ed, 0xbf00e281,
    0x3d8c3b7f, 0x3ef9ef95, 0x3f45dd65, 0x3f010e06,
    0x3d0eea2a, 0xbeca2281, 0xbf2ffed8, 0xbf187a99,
    0xbd199d21, 0x3ef1a9a9, 0x3f3d67f4, 0x3f0ed86f,
    0xbd448fad, 0xbefe5813, 0xbf28f341, 0xbf05a95e,
    0xbd523039, 0x3efc4d52, 0x3f374b26, 0x3ef89e95,
    0x3cd82314, 0xbef291a8, 0xbf30bf2e, 0xbf1313be,
    0xbc58c3bb, 0x3eede082, 0x3f38bc0b, 0x3f12448d,
    0xbc9d249f, 0xbf0a8b0a, 0xbf1f36ef, 0xbf14097a,
    0x3b36a69e, 0x3f01aac3, 0x3f446e0b, 0x3ee2f250,
    0xbd58269e, 0xbef2a9b7, 0xbf4e655a, 0xbf0563a0,
    0xbdbcebb3, 0x3f010676, 0x3f30b329, 0x3edcc589,
    0x3d39248e, 0xbeef95b2, 0xbf33f611, 0xbee4e47f,
    0x3dc20e25, 0x3ed3a106, 0x3f1cfdf2, 0x3ef5256e,
    0x3d3ee60b, 0xbf0f8409, 0xbf469c64, 0xbf0be875,
    0xbd910fde, 0x3efb728c, 0x3f3114e9, 0x3ef5241a,
    0xbcce2c34, 0xbee46c08, 0xbf3bb508, 0xbef730ab,
    0xbd91eef1, 0x3f015a22, 0x3f3a532d, 0x3f08d4aa,
    0xbb01be99, 0xbf01aa69, 0xbf44397f, 0xbeeaac35,
    0x3b296c31, 0x3f0ab935, 0x3f2cbb10, 0x3ee41fca,
    0xbd1350af, 0xbedd8088, 0xbf16f869, 0xbefa7d70,
    0xbde70b13, 0x3ed87697, 0x3f33bfa9, 0x3ee3882b,
    0xbd91213a, 0xbf04b649, 0xbf1a6588, 0xbf0042ce,
    0xbd6b48c2, 0x3f011084, 0x3f484335, 0x3ecef038,
    0xbcc1beea, 0xbec5ab1b, 0xbf2f054b, 0xbf0dc580,
    0xbc21507f, 0x3efaaf8b, 0x3f314573, 0x3efceba3,
    0xbd08a7ac, 0xbf071736, 0xbf2e3ef1, 0xbf006674,
    0xbcd33d48, 0x3f0abcfc, 0x3f296b5a, 0x3f0290de,
    0x3d0015e9, 0xbf03cf03, 0xbf17a7eb, 0xbf123924,
    0x3cc2d928, 0x3f0449e4, 0x3f39bc0f, 0x3f09111f,
    0x3d13e73f, 0xbf13e938, 0xbf30ee49, 0xbf06ef85,
    0x38ec17c4, 0x3f0120f7, 0x3f332c89, 0x3eed5d76,
    0x3d84b45e, 0xbf01c155, 0xbf285d69, 0xbee86c91,
    0xbcc87079, 0x3eb7e88e, 0x3f318cc7, 0x3f02ae55,
    0x3c669054, 0xbf0a9474, 0xbf2d6b1e, 0xbf0f0060,
    0xbca4a7cf, 0x3eeda17e, 0x3f2196ed, 0x3ee795b6,
    0x3d851ffc, 0xbf049d18, 0xbf3f67a8, 0xbefd1777,
    0x3da3c037, 0x3eecf8c0, 0x3f1f9483, 0x3efe0cc9,
    0x3ddca632, 0xbee479a2, 0xbf2335bb, 0xbef2e025,
    0xbc943898, 0x3ed26a40, 0x3f3ecc6d, 0x3f06fd5d,
    0x3ca052c5, 0xbf1171c3, 0xbf39aeed, 0xbecd6bf9,
    0x3c1f5672, 0x3ed6820f, 0x3f36cb83, 0x3f0ab48a,
    0x3b6a3158, 0xbf0d7f8d, 0xbf3a1ede, 0xbefe2be9,
    0xbc21ba38, 0x3ee41cf8, 0x3f27528b, 0x3efb6692,
    0x3dc42820, 0xbee85ba0, 0xbf2b1b20, 0xbefb2371,
    0xbd28fb0b, 0x3ed8393c, 0x3f184a49, 0x3eff405e,
    0xbd0419ba, 0xbef64224, 0xbf3604f7, 0xbed224ea,
    0xbbc2473c, 0x3f0657e8, 0x3f32aa53, 0x3f18f13e,
    0x3c691646, 0xbee5de86, 0xbf386713, 0xbf02567b,
    0x3cb8c946, 0x3eeb3153, 0x3f3b816f, 0x3f014cb5,
    0xbe04a3f1, 0xbed3a05a, 0xbf2d2dad, 0xbefa6ce3,
    0xbd0682c5, 0x3ef82c78, 0x3f3b6beb, 0x3f024e08,
    0x3d284cf9, 0xbf05b47a, 0xbf334a85, 0xbf0e9a2e,
    0xbcadfcb9, 0x3ef50b00, 0x3f440172, 0x3ef39073,
    0xbe20a389, 0xbef6f17c, 0xbf3a9e63, 0xbee0966e,
    0xbd22caff, 0x3ef27850, 0x3f431269, 0x3ef4f931,
    0xba18bda7, 0xbf07d7d1, 0xbf35c855, 0xbf03fb0a,
    0x3dba9787, 0x3ef8b5d2, 0x3f27bd3d, 0x3ee8f1df,
    0x3db59e0b, 0xbef2aafc, 0xbf33c610, 0xbedd09da,
    0x3c8bb649, 0x3f1cad96, 0x3f1cf976, 0x3f06d3dd,
    0x3cdfa5a2, 0xbeebe28e, 0xbf3c970f, 0xbef36aa1,
    0xbd2a747f, 0x3f09499c, 0x3f3f790c, 0x3effbffe,
    0x3b28c1ff, 0xbee9381e, 0xbf47760c, 0xbeea7eab,
    0xbd75417a, 0x3f022f87, 0x3f3cfc4b, 0x3f009365,
    0xbc4f5a80, 0xbefaf9ec, 0xbf28aa9e, 0xbf08badc,
    0xbc801986, 0x3ee93c5b, 0x3f350a69, 0x3ecc4549,
    0x3bdcdf1f, 0xbf1ba488, 0xbf21252a, 0xbed6d8f3,
    0xbc9a7cff, 0x3efced11, 0x3f38b809, 0x3efa7bb8,
    0xbd3cfc88, 0xbf02437e, 0xbf5035e3, 0xbf0f40d0,
    0xbce11bb9, 0x3ef4ba0f, 0x3f42022a, 0x3f05677b,
    0xbb64721f, 0xbed6350b, 0xbf35f7f1, 0xbee3d8b4,
    0xbd08ab32, 0x3f009b85, 0x3f4bed92, 0x3f1b683e,
    0xbb9eba19, 0xbef9e96d, 0xbf2bc599, 0xbf019d80,
    0x3d181dcc, 0x3eb9403d, 0x3f4933cf, 0x3f0103d3,
    0xbd6bba6b, 0xbf1115d9, 0xbf2c2842, 0xbf0e9f45,
    0xbb912a18, 0x3f0b5eb6, 0x3f1d9938, 0x3f0014ff,
    0x3b4b289f, 0xbef182be, 0xbf3437b5, 0xbef00dcb,
    0xbddf1de1, 0x3f0b9e91, 0x3f1e32d3, 0x3ef5d21c,
    0xbb8d77b1, 0xbedd7221, 0xbf32bf14, 0xbf0a3d69,
    0x3d507ce1, 0x3ee1ee27, 0x3f47c5e4, 0x3eee04ef,
    0x3cb31ee8, 0xbf042785, 0xbf384bc2, 0xbf0f6b08,
    0xbd5d22ee, 0x3f05613d, 0x3f2fa868, 0x3ed2a5f5,
    0x3d943232, 0xbef0b9bd, 0xbf18a209, 0xbee7e4fb,
    0xbcc6715d, 0x3f0085ba, 0x3f2f281d, 0x3f0ea414,
    0xbd68e11e, 0xbefc1b8c, 0xbf455a3a, 0xbefb660c,
    0xbdc7adc7, 0x3f104160, 0x3f341fa0, 0x3f0d2cef,
    0xbca7fbc0, 0xbf12fea9, 0xbf450ecf, 0xbf06aa9b,
    0xbc62d8d9, 0x3ee02f10, 0x3f2effb0, 0x3f0a181e,
    0x3d58a6f5, 0xbf14bcc7, 0xbf3bc565, 0xbedf3afb,
    0x3d394270, 0x3ed4b1cd, 0x3f30fa6e, 0x3ef4aaa3,
    0xbca4ae1e, 0xbf062a79, 0xbf3a6f55, 0xbf13c16e,
    0x3c024f53, 0x3f078c43, 0x3f3545b6, 0x3edf1074,
    0xbcc217fd, 0xbf042513, 0xbf3ef074, 0xbef0a9af,
    0xbce14ddc, 0x3efdcd3f, 0x3f3c98bf, 0x3efd85de,
    0x3ba6e4a1, 0xbf0a09d8, 0xbf3313fa, 0xbf064dc3,
    0xbdfa77ec, 0x3edbacfa, 0x3f368017, 0x3f0dba3b,
    0x3d81916c, 0xbf096429, 0xbf324357, 0xbf0d97d0,
    0x3d077729, 0x3eec91cc, 0x3f38f10a, 0x3ee4ec47,
    0x3de489c1, 0xbefa40a1, 0xbf283a11, 0xbef316d0,
    0xbc90a26b, 0x3ee02718, 0x3f428894, 0x3f0e116e,
    0xbd1f85fe, 0xbf1b549c, 0xbf38edb2, 0xbef194b7,
    0xbcd6b1f0, 0x3ee319c6, 0x3f2edd49, 0x3ee37563,
    0xbd884ed9, 0xbf01cc5c, 0xbf3bd3f3, 0xbf14ae7e,
    0xbd8f1910, 0x3f091438, 0x3f35f472, 0x3ed18a4a,
    0x3d947834, 0xbf004ae0, 0xbf460365, 0xbf0b678a,
    0xbb5f3145, 0x3eda8e92, 0x3f26e82a, 0x3edf208b,
    0xbcc15201, 0xbf0700fd, 0xbf3399cf, 0xbef4fc04,
    0xbe04e9dd, 0x3ee70ac7, 0x3f2c636c, 0x3f0312c1,
    0x3d4b1f79, 0xbef84ddc, 0xbf36e47d, 0xbf0e4d7d,
    0x3c2dadbe, 0x3f10cf9a, 0x3f28fa3b, 0x3ee3133c,
    0xbc9ca878, 0xbef8839f, 0xbf4f8987, 0xbf12e4b7,
    0xbc962b34, 0x3f092785, 0x3f42cdd4, 0x3ee9c011,
    0xbcd69665, 0xbefe9f84, 0xbf2be19c, 0xbf09e330,
    0xbd88262e, 0x3f06d227, 0x3f3c254e, 0x3ef7d057,
    0xbd281037, 0xbee75bdf, 0xbf23a5b0, 0xbef323c8,
    0x3d47b36d, 0x3eda84f7, 0x3f2d8f77, 0x3f01080c,
    0x3d467254, 0xbef3831c, 0xbf2669d6, 0xbf0b2eb7,
    0xbd0c18ec, 0x3eeb99e4, 0x3f2a01b1, 0x3ef6afdd,
    0x3d127f5b, 0xbf0659fc, 0xbf2eaea5, 0xbee7eabc,
    0x3cafca5e, 0x3edf7fc5, 0x3f2b6c6b, 0x3eef3bee,
    0x3ca2cd53, 0xbf0422b9, 0xbf2c6541, 0xbefd5d1e,
    0xbda0ce3b, 0x3f0bd81c, 0x3f2a9a2b, 0x3f05d558,
    0x3cc6fb44, 0xbf04da5a, 0xbf3f9f9e, 0xbf128339,
    0xbcc625f2, 0x3eec7d2e, 0x3f2492c9, 0x3f143887,
    0x3d9a663a, 0xbf05a70b, 0xbf14d430, 0xbef5abcc,
    0xbd09f1b7, 0x3f0e023b, 0x3f533421, 0x3f044d64,
    0x3d2a4d86, 0xbf052c64, 0xbf366dbd, 0xbf0cc696,
    0xbd09675e, 0x3ee7c89e, 0x3f38db37, 0x3ef1104e,
    0xbb972d04, 0xbf09212d, 0xbf4af958, 0xbf0db2e3,
    0xbd4569b8, 0x3f0385dc, 0x3f24df68, 0x3f00fc71,
    0xb9ef5ba5, 0xbedc4e72, 0xbf2666df, 0xbf0a3efd,
    0x3daae99f, 0x3f00eede, 0x3f4b1a4c, 0x3efc2b33,
    0x3cdc7efe, 0xbef2c511, 0xbf358a2f, 0xbf09d12b,
    0x3d673c8a, 0x3ef2a6fa, 0x3f2d8532, 0x3ee69139,
    0xbd6094cd, 0xbed9e8c1, 0xbf31cf84, 0xbf022f04,
    0x3d2aedd4, 0x3f090347, 0x3f426bf6, 0x3edfec52,
    0xbd4c6874, 0xbefdc79a, 0xbf344c41, 0xbefafe58,
    0x3d53b347, 0x3f125532, 0x3f310650, 0x3f03db06,
    0xbd8b5b5e, 0xbf0f2109, 0xbf134c9e, 0xbefc14fe,
    0x3d3e7581, 0x3ef1dd2c, 0x3f387d55, 0x3ef680d6,
    0xbd05a93b, 0xbee4291a, 0xbf478130, 0xbf0dc674,
    0x3b62fdad, 0x3ee28c62, 0x3f3a7df3, 0x3ef41c67,
    0x3b8dbe8e, 0xbf073c89, 0xbf2a03e5, 0xbee8f50f,
    0xbd99f962, 0x3ec7952f, 0x3f3bdfc9, 0x3efd2c42,
    0xb9bf5333, 0xbf0cde7b, 0xbf2be97f, 0xbeeb1bf1,
    0xbcef1d42, 0x3efd916b, 0x3f363795, 0x3ef61494,
    0x3e185c3b, 0xbf23af07, 0xbf3f919c, 0xbf01ca30,
    0xbce81e9f, 0x3f0d08cc, 0x3f3e0051, 0x3ef9a1f3,
    0xbb80b9a1, 0xbedddc9d, 0xbf335480, 0xbf100d25,
    0x3a81486b, 0x3f172909, 0x3f5036c1, 0x3f104d47,
    0x3d6996d6, 0xbeeefd33, 0xbf2b3b13, 0xbef8af5d,
    0x3c91594e, 0x3ee1bfc6, 0x3f428e4b, 0x3f020e7b,
    0x3d986a4a, 0xbefa3958, 0xbf3ec378, 0xbf0038df,
    0xbd5032ee, 0x3efdd76b, 0x3f2fc8d3, 0x3ef2c24a,
    0xbdbadc10, 0xbf04d091, 0xbf22543e, 0xbedd2513,
    0x3d235a97, 0x3efb2bfd, 0x3f2d8c06, 0x3efe2972,
    0xbd13dea4, 0xbf04f528, 0xbf292446, 0xbecf6880,
    0xbd0c5424, 0x3ef507ab, 0x3f4163f3, 0x3f0ab27b,
    0x3cb8295d, 0xbeecbd26, 0xbf2443f5, 0xbf045b60,
    0x3d8b3467, 0x3ee81bd8, 0x3f3f8ae3, 0x3ee162cc,
    0x3c82bc4b, 0xbf191509, 0xbf2eaa6d, 0xbef5b19c,
    0x3ca235d3, 0x3f1ba433, 0x3f2f915a, 0x3eeb8de5,
    0xba5c6e90, 0xbf02fdd0, 0xbf34f8c4, 0xbed1aaa8,
    0xbce78365, 0x3ef41ad4, 0x3f2682b5, 0x3efc9b1c,
    0xbd42a94c, 0xbf07708e, 0xbf54d24c, 0xbeec291c,
    0xbc2009cd, 0x3f097e2f, 0x3f30ff9d, 0x3ef62617,
    0x3d08d67d, 0xbf06dfe8, 0xbf331dbe, 0xbefd10db,
    0xbd4e2ad1, 0x3ef42891, 0x3f41cf3f, 0x3f0388c3,
    0x3db5bc0e, 0xbef3a624, 0xbf2cec66, 0xbf08ae88,
    0x3ca9d350, 0x3ef62efa, 0x3f2a69d4, 0x3ee00730,
    0x3d4fa40c, 0xbed4ee70, 0xbf22e419, 0xbef1b992,
    0xbca7c07a, 0x3efde97e, 0x3f2a510c, 0x3ee2ff0b,
    0x3c7d72a3, 0xbee7df3e, 0xbf38572d, 0xbf0cb0da,
    0xbc83a1bc, 0x3f1338ff, 0x3f2c3838, 0x3f06258f,
    0x3dd055ce, 0xbef462d3, 0xbf310265, 0xbf0c0b5b,
    0x3d42b4a3, 0x3eeace6a, 0x3f2f6148, 0x3f05da8a,
    0x3d4bc884, 0xbf086385, 0xbf33d078, 0xbef80f66,
    0x3cc63272, 0x3edccaba, 0x3f2f3c68, 0x3f0cac1f,
    0x3d80db87, 0xbf14f4f8, 0xbf41dda0, 0xbecc17f2,
    0xbd90d88d, 0x3f09b0d8, 0x3f2220eb, 0x3ee3e122,
    0x3bde61db, 0xbee5acdb, 0xbf34c769, 0xbf0a7055,
    0xbc9e614e, 0x3f0e3274, 0x3f3cbcef, 0x3eef5cd1,
    0x3d6626be, 0xbf058294, 0xbf1ba022, 0xbf191548,
    0x3d73284c, 0x3edf3463, 0x3f41f34f, 0x3ef3a499,
    0x3cfd19d1, 0xbf14bd2e, 0xbf35ab10, 0xbef33326,
    0x3c86aeaf, 0x3f14b01e, 0x3f1e7d54, 0x3ef9b1d3,
    0xbd9d0d49, 0xbef082f3, 0xbf3b9b36, 0xbf0f4fb5,
    0x3cdab8df, 0x3eeaae49, 0x3f3834ee, 0x3ef76895,
    0x3c93842b, 0xbf02c81b, 0xbf2dffe3, 0xbee79900,
    0xbd002772, 0x3eee922f, 0x3f2c7bd5, 0x3f0abeb2,
    0xbbedfa64, 0xbef5b8e4, 0xbf3cadb4, 0xbf17183c,
    0xbd8ccb0a, 0x3eeabd43, 0x3f32b629, 0x3ef245d6,
    0xbd17e7d5, 0xbf13e90f, 0xbf44fc59, 0xbf0a6eef,
    0xbd06358b, 0x3eed3cf2, 0x3f17a3f0, 0x3f10f5ee,
    0xbb34920e, 0xbef7c84f, 0xbf3798e8, 0xbf06c963,
    0xbb8ece42, 0x3ef1fa9c, 0x3f4cbcfe, 0x3ef7bc9a,
    0xbdafae86, 0xbf0592d5, 0xbf3d85d4, 0xbf0d2436,
    0x3c7046aa, 0x3ed3c454, 0x3f245309, 0x3f069eff,
    0xbab5e0f8, 0xbf0148c6, 0xbf36c603, 0xbefdc5e1,
    0x3b974965, 0x3ef78018, 0x3f250294, 0x3ef2574a,
    0x3d786b55, 0xbeeb8357, 0xbf28567d, 0xbef530f4,
    0xbbb0411f, 0x3eec21f4, 0x3f2cd284, 0x3f03d1f3,
    0x3b0a864f, 0xbf142422, 0xbf23131d, 0xbeef3f6f,
    0x3d077f81, 0x3efc5c9d, 0x3f38ebd8, 0x3ef639e2,
    0xbd95a557, 0xbee8f8a1, 0xbf329063, 0xbee655bc,
    0x3d11147c, 0x3f0892d9, 0x3f43e911, 0x3f10cd53,
    0x3d06aed5, 0xbf031a73, 0xbf304498, 0xbef6fec7,
    0x3d0e182f, 0x3ee90469, 0x3f38e792, 0x3ef98220,
    0xbc18fd18, 0xbf0ede70, 0xbf36bc65, 0xbef49e5e,
    0xbd38530e, 0x3ef1cdb1, 0x3f3acdc2, 0x3eefdad5,
    0xbcc8aa91, 0xbeecfc0e, 0xbf3f4a83, 0xbf010c76,
    0x3a31566b, 0x3ef9b315, 0x3f3d595a, 0x3edc9e10,
    0xbba55c98, 0xbefbe37e, 0xbf38a49b, 0xbed05dfb,
    0xbc4f7118, 0x3f105dd6, 0x3f329678, 0x3f09c4aa,
    0x3d000b4e, 0xbf06ffa0, 0xbf2afb0b, 0xbee366e5,
    0xbb01eac4, 0x3ee8e82f, 0x3f40b587, 0x3ec6a67b,
    0x3ca5bdd6, 0xbecdf513, 0xbf3b008d, 0xbefe4c5f,
    0x3c957c94, 0x3efcf5fd, 0x3f44fc8a, 0x3f0cd1b3,
    0xbc3d5626, 0xbee9e0a0, 0xbf2f4069, 0xbf0b9845,
    0x3d960caa, 0x3f0914ab, 0x3f2189fb, 0x3f053988,
    0x3d02f7ad, 0xbf04a522, 0xbf449d42, 0xbf08c010,
    0x3c8c9b36, 0x3effb25b, 0x3f297cae, 0x3ee346d8,
    0x3d37acdb, 0xbefa0694, 0xbf36b586, 0xbf0286c4,
    0x3d0db9be, 0x3f0d3cce, 0x3f2141b2, 0x3edfcc13,
    0xbd4abe53, 0xbf07450b, 0xbf2c8df6, 0xbf080f64,
    0x3d3bd796, 0x3ef3f5e6, 0x3f21300b, 0x3f195832,
    0x3b90196b, 0xbefebcad, 0xbf2f5709, 0xbeca86c4,
    0xbd4e9e45, 0x3f0107de, 0x3f26c5af, 0x3ef32945,
    0x3d989144, 0xbf0ccfff, 0xbf258b46, 0xbef830e6,
    0x3c212f11, 0x3eea1ec5, 0x3f2c2fa1, 0x3ef1675a,
    0xbcebc19d, 0xbf0ba81a, 0xbf2d4451, 0xbf048113,
    0xbdc7a75c, 0x3f034415, 0x3f4d75cd, 0x3f0a2357,
    0xbc970192, 0xbf0d20bc, 0xbf4013d9, 0xbeee75c7,
    0x3d8bc004, 0x3f065731, 0x3f2e3764, 0x3f14f136,
    0x3d2cb86c, 0xbef5c2e3, 0xbf1fda4a, 0xbf04edae,
    0xbafb9618, 0x3f132c9f, 0x3f36d4b6, 0x3eea3ae5,
    0xbc5c312d, 0xbf05f6ff, 0xbf2dc819, 0xbedbd373,
    0x3d3dfb34, 0x3ede2cf3, 0x3f20dcc9, 0x3ef96bfc,
    0xbd76498f, 0xbef6cf63, 0xbf276e15, 0xbf0f8015,
    0xbba90ec8, 0x3f042177, 0x3f3a7062, 0x3ed07b1d,
    0xbe0f6e2b, 0xbef37d52, 0xbf2b02ce, 0xbf18c2f6,
    0x3dc32ef2, 0x3ee246db, 0x3f29043b, 0x3f01b6a3,
    0xbd2f0c0b, 0xbef3946d, 0xbf36f6e3, 0xbf00a44a,
    0xbcc92752, 0x3f14192f, 0x3f1eb78a, 0x3f09d7aa,
    0x3ca6b683, 0xbef99a99, 0xbf31685d, 0xbf044626,
    0xbd75f528, 0x3ecf65d4, 0x3f4d3bd8, 0x3ee01ab8,
    0x3c2813a7, 0xbef6d343, 0xbf26dfa2, 0xbecec6e0,
    0x3d3f2667, 0x3f0904c3, 0x3f3989c1, 0x3ef5a986,
    0x3c50a30c, 0xbf01ead7, 0xbf2a9c9c, 0xbf03aad7,
    0xbd995474, 0x3ef62522, 0x3f238eb7, 0x3ef742d1,
    0xbcc48ddd, 0xbeebfcdc, 0xbf2811ef, 0xbede065e,
    0xbd476f3a, 0x3efa8b7f, 0x3f44c659, 0x3ed529b3,
    0x3d863f64, 0xbef7d21e, 0xbf406a48, 0xbeed679a,
    0x3c948e8c, 0x3efca43d, 0x3f3b952f, 0x3eef026b,
    0xbd7a5a37, 0xbef192e9, 0xbf4e7a60, 0xbed3eff8,
    0xbd0cf98b, 0x3f0808c3, 0x3f25799f, 0x3ef7bc55,
    0xbbdea9a1, 0xbf05ee8c, 0xbf36e3fa, 0xbefa3bc3,
    0xbdde00e6, 0x3ece5a93, 0x3f30f4ff, 0x3ef925a5,
    0x3cad963b, 0xbec69fc2, 0xbf34dc0a, 0xbf057923,
    0x3ca2b9bf, 0x3ed8b695, 0x3f29b667, 0x3efd5e0f,
    0xbd3f2cea, 0xbeeb3fde, 0xbf3cf51b, 0xbf03d65c,
    0xbd107c9f, 0x3efe46b8, 0x3f3faff0, 0x3f04139f,
    0x3d286816, 0xbf00dcdb, 0xbf2dc1d4, 0xbef66112,
    0x3d8108b0, 0x3f05314f, 0x3f35ff6f, 0x3efa9a9f,
    0xbd99f6d0, 0xbf03b187, 0xbf1aed34, 0xbec75a17,
    0xbd2c6314, 0x3ef15100, 0x3f43e91c, 0x3f10c898,
    0x3c3cf0af, 0xbf10f750, 0xbf328690, 0xbf198c0f,
    0xbcd26903, 0x3f0abd2b, 0x3f37782d, 0x3ee68eec,
    0x3db8ead5, 0xbef163e5, 0xbf37cd1d, 0xbf010ba0,
    0xbcebf8fe, 0x3eef74da, 0x3f2d25ea, 0x3f0800d0,
    0xbcb4e0c4, 0xbf083ed2, 0xbf32e12f, 0xbec88e94,
    0xbd16c815, 0x3f077bef, 0x3f31a723, 0x3f0f56b6,
    0xbc9d6461, 0xbeee2a1f, 0xbf29b200, 0xbecfe7b7,
    0xbdc401b4, 0x3ef58eac, 0x3f2c2ed7, 0x3f1367c7,
    0xbce9f8ff, 0xbf0b24b5, 0xbf1a01cd, 0xbeed5822,
    0x3d0723fd, 0x3ed1b3d9, 0x3f33727c, 0x3ef537d7,
    0x3cd3c7e9, 0xbf0697be, 0xbf3a8643, 0xbf084e1c,
    0x3d17a39f, 0x3ef9c1c5, 0x3f4f136d, 0x3eff4e3c,
    0xbc8debf4, 0xbf0205ab, 0xbf3bad95, 0xbf010d12,
    0xbd5afbdf, 0x3edaf4e2, 0x3f377e22, 0x3f051eda,
    0xbb965e83, 0xbede6868, 0xbf2de4eb, 0xbef5a17f,
    0xbd31d348, 0x3ed55e04, 0x3f37842b, 0x3f0de939,
    0xbd03463f, 0xbee8912d, 0xbf406788, 0xbefba3ca,
    0xbd392832, 0x3f02fd27, 0x3f2db1e9, 0x3f013c43,
    0x3c853ae4, 0xbede7808, 0xbf1fc92e, 0xbeec7469,
    0x3d38e80d, 0x3ee22488, 0x3f1aa4cb, 0x3eda60d7,
    0x3b93521d, 0xbf17fca0, 0xbf2d9167, 0xbf0b458b,
    0xbd58e19d, 0x3f0dfe9b, 0x3f3de92d, 0x3eec47e2,
    0xbd8741d6, 0xbef2f3ef, 0xbf3b3f23, 0xbeff0459,
    0x3dd7384e, 0x3efc8a2e, 0x3f4ffd31, 0x3f08d7ed,
    0x3c6d01aa, 0xbef211e5, 0xbf277b9b, 0xbf0a9092,
    0x3bd7b89b, 0x3f00397e, 0x3f3c076a, 0x3f0fd714,
    0x3d28a4e6, 0xbf01ce69, 0xbf3aa425, 0xbefeca31,
    0x3bbf460b, 0x3eebd445, 0x3f4549c4, 0x3efb1646,
    0x3d893409, 0xbf190f21, 0xbf2ee942, 0xbef5fe3b,
    0xbce542a7, 0x3f1112d1, 0x3f2c1e43, 0x3f0a95ab,
    0x3c469f21, 0xbef66b89, 0xbf27667d, 0xbf06b9a3,
    0xbcc71295, 0x3f0617ae, 0x3f220838, 0x3ef9a63c,
    0x3c7cd26a, 0xbf003e12, 0xbf27c2a1, 0xbf136898,
    0xbe726446, 0x3f0ef954, 0x3f1df6cd, 0x3f08f11a,
    0x3dfddd37, 0xbf09169c, 0xbf1ffcc8, 0xbf0d783d,
    0xbc2bb8b0, 0x3ed78f43, 0x3f2e99c8, 0x3ef1c35b,
    0xbcc7d928, 0xbee8dc3e, 0xbf3d2b83, 0xbeda02c2,
    0x3d6feeb5, 0x3f11c879, 0x3f292a31, 0x3f0405b8,
    0xbdb8232a, 0xbef257e0, 0xbf315a9e, 0xbeaf1d2c,
    0xbcacd630, 0x3ee24906, 0x3f2d0644, 0x3eedc30f,
    0xbb495402, 0xbf01f5e6, 0xbf28dbaf, 0xbeffe0a8,
    0x3d348256, 0x3ef76731, 0x3f2d14c3, 0x3f06e639,
    0xbbb44852, 0xbeff053a, 0xbf35cb1c, 0xbef40bef,
    0xbd053782, 0x3ef1687e, 0x3f37748a, 0x3f117b37,
    0xbc9c61ae, 0xbef2af20, 0xbf2c1531, 0xbf070451,
    0xbcfe6533, 0x3efddf04, 0x3f229305, 0x3f06f5dd,
    0xbb951b97, 0xbef6b53b, 0xbf33b3b8, 0xbec9b85c,
    0xbd496f69, 0x3efa6a3f, 0x3f3de674, 0x3f03b942,
    0xbc1e550e, 0xbef002a3, 0xbf2e7e55, 0xbef4d1ae,
    0xbd709849, 0x3ef6e966, 0x3f3fa3a6, 0x3eeb2166,
    0xbdedc3d5, 0xbed180ca, 0xbf33d984, 0xbf000613,
    0xbd779615, 0x3ee1d75b, 0x3f16766a, 0x3f0bf5d4,
    0xbdc2cb66, 0xbf0d2e2f, 0xbf3635a8, 0xbf149571,
    0xbd4d58b8, 0x3ee8b8c1, 0x3f2713e2, 0x3ef8d881,
    0x3ac36ed3, 0xbef7a2cb, 0xbf267779, 0xbf07f740,
    0x3d664b24, 0x3ee1d1bf, 0x3f4eaff0, 0x3ee7ce2e,
    0xbcca1111, 0xbeece877, 0xbf32c337, 0xbf00278c,
    0xbcacb545, 0x3f0e2f5a, 0x3f3e9d08, 0x3f04e865,
    0xbd32bda7, 0xbefa4b4f, 0xbf2c38f4, 0xbf125cea,
    0x3d73355f, 0x3f085f01, 0x3f55a6fd, 0x3ee8aa2b,
    0xbd529a0c, 0xbeefb3e3, 0xbf33a2e1, 0xbee7775b,
    0x3d29fe03, 0x3eeea49a, 0x3f371ecd, 0x3ee7d12e,
    0xbd2d5220, 0xbede15bf, 0xbf2fd8dd, 0xbf06f43d,
    0xbd247e7e, 0x3ee17ca0, 0x3f3a4177, 0x3f067b54,
    0x3c930e88, 0xbedcca1e, 0xbf4789fa, 0xbedffd4b,
    0xbdd68200, 0x3ef828e0, 0x3f1fdaf0, 0x3ef8c04c,
    0x3da42989, 0xbebcf646, 0xbf38f80c, 0xbf02bd42,
    0xbd0392af, 0x3edee628, 0x3f1fe93a, 0x3ed70cc6,
    0x3d2146dc, 0xbef321a7, 0xbf2f375e, 0xbee58ca5,
    0x3d9d6816, 0x3f0436cc, 0x3f28e72d, 0x3f131399,
    0x3cbf3d70, 0xbef5db99, 0xbf37cb51, 0xbeeaeff5,
    0xbc2ab594, 0x3ed36b4e, 0x3f275ded, 0x3f13ecd3,
    0x3cdfa367, 0xbf02362c, 0xbf334107, 0xbf1683f1,
    0xbd5165b6, 0x3ede73e4, 0x3f3bc055, 0x3f15fa53,
    0xbca77ec9, 0xbed1e5ea, 0xbf4bd8a9, 0xbee7beee,
    0x3d4f672c, 0x3ee25bce, 0x3f3017e5, 0x3ef8e808,
    0x3d2813af, 0xbed278d2, 0xbf3f20ca, 0xbee742c2,
    0x3d31adc2, 0x3f13fab5, 0x3f2bc772, 0x3f0b17f6,
    0xbd0913cb, 0xbede5cd8, 0xbf2c5e76, 0xbf081140,
    0xbc3b7ebe, 0x3ef9fadc, 0x3f34cfca, 0x3eeeaf6b,
    0x3bf7527f, 0xbf0e3c0e, 0xbf25be71, 0xbed359ec,
    0x3cb977df, 0x3eff0f2c, 0x3f2418e1, 0x3eecb342,
    0x3d0731f6, 0xbf0a1f9d, 0xbf37e557, 0xbf02e2ff,
    0xbd121c2d, 0x3ee75b90, 0x3f390c39, 0x3f041e6f,
    0x3dc00684, 0xbef976b2, 0xbf3493e2, 0xbeed4af3,
    0xbc449320, 0x3f05e2d0, 0x3f41f325, 0x3f0788e0,
    0x3d70e394, 0xbeff9db1, 0xbf3458a6, 0xbf07d714,
    0xbc656daa, 0x3ee41e2f, 0x3f2bb20a, 0x3eed03fb,
    0xbb25fd91, 0xbf0711c3, 0xbf38f246, 0xbee30e84,
    0xbc1217f8, 0x3ee7c064, 0x3f2da25e, 0x3eeb3511,
    0xbc2dc247, 0xbf1ddb28, 0xbf2f3b75, 0xbee4753c,
    0xbd5b253c, 0x3ee4d0c5, 0x3f371287, 0x3f06515c,
    0x3d86b971, 0xbeffb626, 0xbf348c13, 0xbeec7336,
    0x3ca5d990, 0x3f102560, 0x3f28dacc, 0x3ef298f5,
    0xbd836b69, 0xbf0438ed, 0xbf38071f, 0xbf0258a5,
    0x3de012a9, 0x3f0747da, 0x3f319845, 0x3efc48d9,
    0xbceaa16e, 0xbf06826e, 0xbf3c2499, 0xbef07d54,
    0x3ceb278d, 0x3eeb379a, 0x3f21d3ed, 0x3ef2c183,
    0x3dcac4cc, 0xbef7a9c7, 0xbf30c7c8, 0xbf06c92e,
    0xbd8d1cda, 0x3ef51ffd, 0x3f2bcf24, 0x3ee47e0a,
    0xbdba30ce, 0xbf073425, 0xbf33a23c, 0xbf09b937,
    0xbd3f96b4, 0x3f07b776, 0x3f2cecba, 0x3ecc4b40,
    0x3caa6dc1, 0xbf077a61, 0xbf3858f5, 0xbee197e4,
    0xbd3d94c4, 0x3ee0e0b0, 0x3f347ed5, 0x3f107142,
    0x3a92a612, 0xbf0011e6, 0xbf23883e, 0xbef04580,
    0xbce3ec5a, 0x3ed6b1ad, 0x3f395d27, 0x3efca6c6,
    0xbce4640b, 0xbf013be8, 0xbf31b26b, 0xbf0839ab,
    0xbd634a46, 0x3f064ba1, 0x3f31ece6, 0x3ef3d020,
    0x3c2bd425, 0xbf165b27, 0xbf37f809, 0xbf034086,
    0x3da17921, 0x3f00ba28, 0x3f2f5009, 0x3f0571d2,
    0xbb47bf40, 0xbf00180a, 0xbf427167, 0xbf038583,
    0x3d4123a2, 0x3f04bd1e, 0x3f306df6, 0x3ed83eb5,
    0xbd7283de, 0xbf0a86b7, 0xbf4288c7, 0xbef1a9bc,
    0x3d14efcd, 0x3f0d2529, 0x3f3eb990, 0x3ee5d76c,
    0xbc80178c, 0xbee2d5d4, 0xbf37a5f0, 0xbefbc8e2,
    0xbdaab3d5, 0x3ee89b94, 0x3f26525e, 0x3f1062b2,
    0x3d2e0580, 0xbf0c2ab9, 0xbf316de9, 0xbf00e3e7,
    0x3db9ebb1, 0x3efc48f0, 0x3f363cd3, 0x3f005a84,
    0xbcc5b2ed, 0xbeff5ec3, 0xbf34e3ea, 0xbee07039,
    0xbc9966bf, 0x3f0b5f03, 0x3f2ec011, 0x3f07f763,
    0x3cdbb617, 0xbec8e702, 0xbf283300, 0xbef3426d,
    0xbb810240, 0x3ed34cff, 0x3f3c9b69, 0x3ec2ba74,
    0x3c35dd5d, 0xbee224e4, 0xbf416194, 0xbef5884e,
    0x3d075eaa, 0x3edb20ec, 0x3f3b3831, 0x3f08fd1f,
    0xbd3c22f9, 0xbf07ea5c, 0xbf3abb4d, 0xbf0934a0,
    0x3de6e61e, 0x3ef69d74, 0x3f2b2aa4, 0x3ef17726,
    0x3d6cb61e, 0xbf0950a6, 0xbf2fe39f, 0xbf15f419,
    0x3d5269ce, 0x3ee84064, 0x3f2a39c4, 0x3eefa262,
    0xbd0b8e43, 0xbee27f1c, 0xbf297dae, 0xbeff45f9,
    0x3d1caef2, 0x3f073f19, 0x3f377e6a, 0x3f0fa6e5,
    0x3d0bf36c, 0xbec8580a, 0xbf32bda9, 0xbeec46f1,
    0xbd08e7d4, 0x3f05a4cb, 0x3f39a160, 0x3f1830bc,
    0x3d9fffa1, 0xbef14da6, 0xbf4f7498, 0xbf02b3cc,
    0xbd8833bf, 0x3f06fcef, 0x3f35fd03, 0x3ee36bd0,
    0x3cca13dc, 0xbf0cc25b, 0xbf32a854, 0xbef6abff,
    0xbe0943e0, 0x3eed7b97, 0x3f1ee3da, 0x3eda9aa4,
    0x3dcb23b2, 0xbef567a2, 0xbf37ac4c, 0xbf149571,
    0xbd037d66, 0x3edc7d57, 0x3f44cabb, 0x3f0ed06f,
    0xbe07612a, 0xbee427ba, 0xbf35043f, 0xbed1b915,
    0xbbbfe74a, 0x3efda297, 0x3f27c497, 0x3efe43f8,
    0xbd962548, 0xbf1a05d5, 0xbf302396, 0xbf0014d2,
    0xbd5e3e55, 0x3ec7a799, 0x3f36611e, 0x3f029b9b,
    0xbab436a6, 0xbee57b3b, 0xbf353a5a, 0xbee71d86,
    0xbba46bfa, 0x3f03ccf7, 0x3f2acad8, 0x3ef191cd,
    0x3dc13c68, 0xbeddf68b, 0xbf38a6e0, 0xbf0107b9,
    0xbc0e4d78, 0x3f04cfb7, 0x3f54a60f, 0x3ed20953,
    0x3cd9eebf, 0xbf0915a8, 0xbf320880, 0xbf00ae11,
    0xbc8ecc24, 0x3f04c9c2, 0x3f3716fa, 0x3f0735f9,
    0x3cf21de1, 0xbf036ed2, 0xbf2d144a, 0xbf032575,
    0x3c497601, 0x3f024485, 0x3f2e9756, 0x3ee90d7c,
    0xbd8b8393, 0xbee8390c, 0xbf3dd778, 0xbf0c7ff3,
    0x3d92590d, 0x3f081e6b, 0x3f2b35f6, 0x3efcee4a,
    0xbe0f9340, 0xbee229e4, 0xbf20c5bc, 0xbef9678f,
    0xbc060246, 0x3ed011dd, 0x3f404abd, 0x3f0ed691,
    0x3cd96c4f, 0xbf01138b, 0xbf2bf820, 0xbee9e548,
    0xbac51d1e, 0x3efcff30, 0x3f406767, 0x3f0098b4,
    0x3beb6f04, 0xbecc38e6, 0xbf33c96a, 0xbee9e7df,
    0xbdb06ffb, 0x3ef81791, 0x3f2725bd, 0x3f14dbe5,
    0x3d3b4063, 0xbee6cdb4, 0xbf2e8d5a, 0xbecd1ee5,
    0xbd5f2c1f, 0x3eec7c68, 0x3f400077, 0x3f0d21e9,
    0x3c927743, 0xbf04b318, 0xbf2957a8, 0xbecd0629,
    0xbc4ea729, 0x3f0782a5, 0x3f3061d7, 0x3eee655b,
    0x3b8bc933, 0xbf068068, 0xbf4884f1, 0xbf0114da,
    0x3cd60a65, 0x3f1340b7, 0x3f3d2774, 0x3f09c70b,
    0x3dae3d7e, 0xbee2fcd7, 0xbf3349da, 0xbf0f8487,
    0xbd441a01, 0x3ef018e1, 0x3f3b7533, 0x3efd0764,
    0x3ca2b569, 0xbedc4d83, 0xbf444926, 0xbee136ce,
    0xbd241dcb, 0x3ee9b4d8, 0x3f3c8c4c, 0x3f077e43,
    0x3acbe754, 0xbf0526af, 0xbf354f0f, 0xbf0a9f7a,
    0xbd0ebedd, 0x3ee8fc47, 0x3f306c62, 0x3eff0abd,
    0xbc06550b, 0xbefbfc5d, 0xbf2fcf46, 0xbeeb9b9f,
    0x3dbce93e, 0x3f08978c, 0x3f3c8d28, 0x3eff0036,
    0x3d42ee36, 0xbf07eb32, 0xbf33e00a, 0xbf0db28f,
    0x3c81019f, 0x3ef45cce, 0x3f3bc518, 0x3f095c40,
    0x3c64dea4, 0xbf0f930e, 0xbf2fd84e, 0xbef923b6,
    0x3c5839e1, 0x3ef1c7cf, 0x3f39ed60, 0x3f045e00,
    0xbc6915da, 0xbf0007f8, 0xbf4b716a, 0xbee85c1a,
    0xbd975e04, 0x3f0e4743, 0x3f3d3b91, 0x3ed15cfa,
    0x3cbd1b6c, 0xbf09e248, 0xbf39c2e0, 0xbf1145f9,
    0xbd569374, 0x3f008467, 0x3f2c1e6a, 0x3ec7efe5,
    0x3c118a5a, 0xbf00f8c8, 0xbf256b1b, 0xbef7d408,
    0x3770592f, 0x3f05c415, 0x3f2398d4, 0x3ef35856,
    0x3d1d14b3, 0xbed1d3bf, 0xbf248de4, 0xbee5a021,
    0xbc7251a4, 0x3eee2c8a, 0x3f1b14d5, 0x3ef4bf1b,
    0xbd5d58cc, 0xbeeee787, 0xbf28525d, 0xbeeecdca,
    0x3c32e900, 0x3f06b73d, 0x3f301952, 0x3ef1a590,
    0xbd1e30bd, 0xbf14117e, 0xbf40413f, 0xbeff6d2a,
    0xbc697b3b, 0x3f0471db, 0x3f4d5daa, 0x3ef306c6,
    0xbcf560c5, 0xbf0005de, 0xbf300703, 0xbedf12f1,
    0xbd8eff87, 0x3ecfeb08, 0x3f22e6ca, 0x3eecebd3,
    0x3cd1b610, 0xbf122084, 0xbf3b6e8a, 0xbef06b03,
    0xbd9d7ede, 0x3f03a6d1, 0x3f428286, 0x3ef05b5b,
    0x3d3efaa8, 0xbf0686f5, 0xbf335eef, 0xbeee259f,
    0xbd834405, 0x3eec9f69, 0x3f2d1b6a, 0x3f0169d0,
    0x3d9b128d, 0xbec06796, 0xbf1dc1de, 0xbf146a39,
    0xbd578eea, 0x3ed3094e, 0x3f30f9f2, 0x3ef0cb89,
    0x3da3402f, 0xbef1f393, 0xbf245aa8, 0xbef7ed07,
    0xbdb9af5c, 0x3ec796c1, 0x3f334479, 0x3f014f11,
    0xbc338485, 0xbf10461b, 0xbf426495, 0xbefd1258,
    0x3cff33c0, 0x3f11754d, 0x3f2a4c78, 0x3eff5944,
    0xbd9d2d21, 0xbeff30e3, 0xbf2b64fa, 0xbf06ead6,
    0x3bb09d1c, 0x3ef05607, 0x3f2b8055, 0x3f08c16d,
    0xbd22e62c, 0xbf17d373, 0xbf2f0dbb, 0xbef5a8a5,
    0xbc53956f, 0x3efa5532, 0x3f45bdcc, 0x3f05344d,
    0xbdd1db7c, 0xbf03854a, 0xbf202f68, 0xbf01cd22,
    0xbd4988ee, 0x3f041924, 0x3f19e803, 0x3f064553,
    0xbb3ec50b, 0xbf098128, 0xbf2b29ae, 0xbeed8d8a,
    0x3cfefcd8, 0x3eeb1cb6, 0x3f221bc1, 0x3f0caf40,
    0x39b4532f, 0xbee60db1, 0xbf32d487, 0xbf0159a9,
    0x3c577861, 0x3efc6811, 0x3f3ea4e9, 0x3eed47ad,
    0xbd104b76, 0xbee6dbc4, 0xbf17280b, 0xbede2372,
    0xbca0dfbd, 0x3efae2aa, 0x3f372406, 0x3ef9e2ce,
    0xbc0e7124, 0xbee7d5b6, 0xbf2a5483, 0xbf05f8b0,
    0x3d58e6f3, 0x3ef8b996, 0x3f155df7, 0x3f044a09,
    0xbb3213ad, 0xbf06f129, 0xbf2211f2, 0xbef70256,
    0xbd84a69f, 0x3eec817b, 0x3f3c833d, 0x3f012339,
    0x3cbcfe2e, 0xbeed68a2, 0xbf37ac90, 0xbef1e4ee,
    0xbc1d73de, 0x3f126693, 0x3f3b5d94, 0x3ef8b4e1,
    0x3c27d7a2, 0xbee51237, 0xbf2f474e, 0xbefd22d8,
    0x3d34f773, 0x3ef76024, 0x3f27695f, 0x3f03d1ef,
    0xbd81bc1e, 0xbf0ade3c, 0xbf359320, 0xbee23fb7,
    0x3d94b115, 0x3ef2fcef, 0x3f37cfc3, 0x3f01786d,
    0xbda98f43, 0xbefc082a, 0xbf276ad0, 0xbf0d32e7,
    0xbcf17b9a, 0x3f10f88d, 0x3f2aabba, 0x3edc7399,
    0x3d36f21c, 0xbef2e0bc, 0xbf29d68f, 0xbf0af382,
    0x3d279524, 0x3f033016, 0x3f3fa68b, 0x3f0a521f,
    0x3dab17ae, 0xbefe3fa6, 0xbf40bf05, 0xbf01bef8,
    0x3e16713b, 0x3edb01a3, 0x3f2e445b, 0x3f014e4d,
    0xbd8a837b, 0xbf05c2ee, 0xbf399c76, 0xbf02ba62,
    0x3d0ab0a2, 0x3f007694, 0x3f35909e, 0x3f04a3f2,
    0x3c4f277e, 0xbefbc3ee, 0xbf336e25, 0xbeedb806,
    0x3b47d060, 0x3f03ce13, 0x3f2ec999, 0x3f216f90,
    0x3d129a5b, 0xbef1524d, 0xbf2fb0ac, 0xbedc21f8,
    0xbddc8a5b, 0x3eff3fa6, 0x3f2f1c9d, 0x3efb981c,
    0x3c9f39c6, 0xbeef54a8, 0xbf0fd456, 0xbf03ba95,
    0x3c4d2701, 0x3ed92312, 0x3f0e1ba9, 0x3f082a7f,
    0xbca2a239, 0xbf091c32, 0xbf337904, 0xbee5626d,
    0xbc96a35f, 0x3edfeb1b, 0x3f3b50c5, 0x3f071b26,
    0xbc02315e, 0xbf0decd5, 0xbf38334e, 0xbf014217,
    0xba485f61, 0x3f14c847, 0x3f4aabc5, 0x3f158d15,
    0x3b7c482b, 0xbef3aacd, 0xbf1f5464, 0xbeed46ef,
    0x3d93518b, 0x3f017089, 0x3f3fc832, 0x3f118e85,
    0x3dd2cd94, 0xbefbf291, 0xbf4061c7, 0xbf0682ba,
    0xbb10abed, 0x3f104196, 0x3f342035, 0x3f0d4277,
    0x3d93f3a7, 0xbf033e93, 0xbf1c400b, 0xbf0dab8d,
    0x3d087cde, 0x3f023873, 0x3f1a460e, 0x3efe69a4,
    0xbd12111c, 0xbf0a60f1, 0xbf3045a1, 0xbf049f9d,
    0x3d8ca58a, 0x3f05b6fa, 0x3f385645, 0x3f01ed6d,
    0x3d377053, 0xbedb9cc0, 0xbf454b3f, 0xbef8e373,
    0x3dae3699, 0x3ef7bc60, 0x3f38f030, 0x3ed7fdd0,
    0xbb2c241c, 0xbeed6b9c, 0xbf398cd2, 0xbf05c2f8,
    0xbd03d76b, 0x3eb0f88a, 0x3f444c29, 0x3ef604ba,
    0x3d1f19ca, 0xbee882d9, 0xbf398947, 0xbf0845c4,
    0x3d192840, 0x3ef67a72, 0x3f1d2de3, 0x3f0d424c,
    0x3cc558eb, 0xbef31c9e, 0xbf28bb15, 0xbf09c83f,
    0x3a8b4753, 0x3ef1532e, 0x3f423665, 0x3ec4f566,
    0x3cf656cb, 0xbee73214, 0xbf2cfb5d, 0xbef74651,
    0x3d803cdf, 0x3f1b4876, 0x3f3abef3, 0x3f07b0ea,
    0xbd22beb3, 0xbee86dd4, 0xbf2fee08, 0xbf0cbec1,
    0xbc5d17ba, 0x3f0a3dfa, 0x3f37a208, 0x3efcac7d,
    0xbd43e009, 0xbee0eb5e, 0xbf2a883d, 0xbf0921f2,
    0x3c134a33, 0x3eebf597, 0x3f2a6ffb, 0x3ed9e4e7,
    0xbd723b87, 0xbef10a3b, 0xbf33dcc1, 0xbf049db2,
    0xbdc397b9, 0x3f05f028, 0x3f272b08, 0x3eed0fb7,
    0x3d345417, 0xbedc2d4b, 0xbf2af325, 0xbf153f93,
    0xbcd904d4, 0x3f047d81, 0x3f3231c6, 0x3ef96554,
    0xb9646ddb, 0xbf0f1947, 0xbf18e726, 0xbf10f7b4,
    0xb90f2e00, 0x3edad112, 0x3f2cc6ba, 0x3eef2ef5,
    0xbbccb4f8, 0xbef74bf4, 0xbf2ee784, 0xbeec8711,
    0x3e315a36, 0x3f0c7af2, 0x3f4a81ef, 0x3f1bcb99,
    0xbc7d870d, 0xbf128f7a, 0xbf1cca24, 0xbeef3061,
    0xbc0c388e, 0x3eebaf10, 0x3f35f151, 0x3f0ad0f2,
    0x3d18fcfb, 0xbf0b26bb, 0xbf20cb55, 0xbf085db6,
    0xbc98d92a, 0x3ef2929b, 0x3f3dbcc0, 0x3eb827ce,
    0xbd2f133b, 0xbf076a22, 0xbf3c1a3b, 0xbeeebeb4,
    0x3d84b97e, 0x3f0a1b53, 0x3f23b4a7, 0x3f080ecf,
    0xbc599c1b, 0xbee4a3be, 0xbf3d9e36, 0xbef34d10,
    0xbc5151d3, 0x3eed5ed6, 0x3f31d4fd, 0x3f02e995,
    0x3c05f83a, 0xbed375e7, 0xbf32651a, 0xbf106cab,
    0x3d63c911, 0x3f0d883f, 0x3f346a02, 0x3f065129,
    0x3c96a526, 0xbf01235c, 0xbf3299b6, 0xbee81c34,
    0xbd19f6e2, 0x3efbabfa, 0x3f3460e3, 0x3f0428cc,
    0xbc69543a, 0xbf1cc0ff, 0xbf2b11c4, 0xbeee2178,
    0xbc9f6850, 0x3f019301, 0x3f18bbc7, 0x3ef26efe,
    0x3d8f0f0f, 0xbf072f65, 0xbf3ff35c, 0xbef22e12,
    0x3dc38cd9, 0x3f117c42, 0x3f3aec34, 0x3ee6350a,
    0x3e2f839c, 0xbf00f9e7, 0xbf2f7b77, 0xbee44d58,
    0x3c83cc80, 0x3ee62947, 0x3f33108c, 0x3f0ba33f,
    0x3cc5f842, 0xbef60e6b, 0xbf374e4f, 0xbf1180b8,
    0x3db35432, 0x3eee7f2b, 0x3f5021da, 0x3ef1e664,
    0x3ddd5d50, 0xbef630f9, 0xbf480937, 0xbf0f2f9c,
    0xbd899db3, 0x3f04d9a8, 0x3f233f61, 0x3ee73ac9,
    0x3cf20c97, 0xbf00081a, 0xbf3e4063, 0xbee15226,
    0x3d2c58dd, 0x3ed73813, 0x3f4f618d, 0x3efcdc7c,
    0xbd63849d, 0xbef78359, 0xbf40e199, 0xbecff12f,
    0x3b57fb87, 0x3efb90e2, 0x3f3ae373, 0x3ee7fc1c,
    0xbb2aec3c, 0xbf15657c, 0xbf407588, 0xbee06c16,
    0xbb99187f, 0x3eed859c, 0x3f2bb3ed, 0x3f0586f4,
    0xbd80ddb7, 0xbf024233, 0xbf4b31b0, 0xbf0958cd,
    0x3c99a9d6, 0x3f0cc0e0, 0x3f37ea3b, 0x3efd01b1,
    0x3dfd232d, 0xbf0a5ed7, 0xbf332ac3, 0xbefa9f28,
    0xbc5ec8c2, 0x3f09a7cc, 0x3f373719, 0x3edd3f59,
    0x3cc7e9e1, 0xbf15f64f, 0xbf34acd5, 0xbf092921,
    0xbcdcd530, 0x3ee9dd39, 0x3f41ddd8, 0x3ed8daea,
    0xbcb356e9, 0xbf01bb5b, 0xbf3a08ae, 0xbf0540d2,
    0x3cb8814b, 0x3efeaee5, 0x3f4a95f6, 0x3f0f2ccd,
    0xbd39f433, 0xbf0111cd, 0xbf568e8b, 0xbf034b14,
    0x3ccae9cf, 0x3f130741, 0x3f5010ca, 0x3f16a224,
    0xbca09710, 0xbef14352, 0xbf37589b, 0xbefdd91f,
    0xbd41755a, 0x3f01d56a, 0x3f389cea, 0x3f0816f6,
    0xbca6cab9, 0xbf0b08fb, 0xbf1cdf67, 0xbef2a49e,
    0x3ca7a3b0, 0x3edf23a9, 0x3f348f88, 0x3eeeba12,
    0xbb686995, 0xbf19b3db, 0xbf327c01, 0xbf071cb6,
    0xbd3a30d6, 0x3efab0e4, 0x3f3bd03c, 0x3efe0a89,
    0xbca63b39, 0xbf138355, 0xbf1dfa1e, 0xbf041610,
    0xbd89a930, 0x3f07d18e, 0x3f489fdc, 0x3edd27bf,
    0xbc08c559, 0xbed337f7, 0xbf295344, 0xbed9727a,
    0xbce5e903, 0x3efe7a78, 0x3f3ff2b2, 0x3f0573cd,
    0xbd6938ca, 0xbee2c6a9, 0xbf356d3f, 0xbed6961f,
    0xbd0d33da, 0x3f08acf4, 0x3f32c98f, 0x3f143919,
    0xbd91b055, 0xbf0d1fcb, 0xbf28b3d6, 0xbf1a2251,
    0x3ce8f505, 0x3f016681, 0x3f3c1140, 0x3ef5c441,
    0xbc689006, 0xbec186c1, 0xbf3819ec, 0xbeccd917,
    0xbd8b996e, 0x3edb03bc, 0x3f288add, 0x3ef9f5d5,
    0xbc5f7156, 0xbeff4d4e, 0xbf32c3c8, 0xbf0c517d,
    0xbd785c53, 0x3f0a5431, 0x3f3a09a0, 0x3ef57321,
    0x3d8c8723, 0xbeebade7, 0xbf3dba98, 0xbf08d999,
    0xbd81a911, 0x3f0b0c87, 0x3f39e76a, 0x3effadf1,
    0x3dad4dd3, 0xbeecaa11, 0xbf41178c, 0xbef15d38,
    0x3d95f808, 0x3f005778, 0x3f2f93a2, 0x3f172231,
    0xba511ce8, 0xbf0b202b, 0xbf36a39e, 0xbef82788,
    0xbcc92f9d, 0x3f051d4a, 0x3f41da76, 0x3f17e11d,
    0xbc34f19e, 0xbef11993, 0xbf18b6c2, 0xbefce462,
    0x3ab22ad4, 0x3ee9276c, 0x3f2493a5, 0x3ee4a86d,
    0xbdbfc571, 0xbefe7531, 0xbf3af8e9, 0xbf060e69,
    0x3d285f90, 0x3f0a9737, 0x3f1805c6, 0x3f0b16a2,
    0xbd659ae0, 0xbf0c0ca4, 0xbf2a82dd, 0xbeebf6a7,
    0x3cfc36b5, 0x3ec8e345, 0x3f301761, 0x3f037c5f,
    0x3b2d905c, 0xbefdc1c9, 0xbf2df077, 0xbee98022,
    0xbc887115, 0x3f004672, 0x3f2ed930, 0x3ed5afa4,
    0xbca20915, 0xbf030538, 0xbf39de8e, 0xbf009c07,
    0xbc15442e, 0x3ef7e24c, 0x3f21a8cf, 0x3f002830,
    0x3cb3ff93, 0xbf10512e, 0xbf39d433, 0xbed1e9a9,
    0xbb3fc393, 0x3f087f8e, 0x3f339284, 0x3f0b42b6,
    0xbc380563, 0xbee4a379, 0xbf3d0efb, 0xbedd8733,
    0xbd161b26, 0x3efd1346, 0x3f441718, 0x3f0c52d6,
    0x3da4073d, 0xbeecacd1, 0xbf2aecb0, 0xbeefb065,
    0xbd8cffba, 0x3ef2dbf2, 0x3f3e2ebc, 0x3ef18506,
    0xbb3a865d, 0xbf114b61, 0xbf3c8884, 0xbeec69d5,
    0x3d5457a8, 0x3ef622f4, 0x3f3b3a03, 0x3ee71e41,
    0xbd3a8f29, 0xbf0e9822, 0xbf2a9b1b, 0xbf00fcb4,
    0x3cb7bbf8, 0x3f03a473, 0x3f26ae9d, 0x3f0dbdfc,
    0x3c6fc3a5, 0xbf0cc3a3, 0xbf2ee500, 0xbef8910c,
    0x3d6cda32, 0x3ef8d821, 0x3f2cfbeb, 0x3eeeb2a6,
    0x3bc71840, 0xbf01d9cc, 0xbf289f07, 0xbf0a7a82,
    0xbc55f771, 0x3f03a5a0, 0x3f1f75a4, 0x3f18e444,
    0x3b1f90c1, 0xbee357bf, 0xbf37e168, 0xbf0254f8,
    0x3dcd3b1b, 0x3efe34ad, 0x3f28bbe3, 0x3ee716d0,
    0x3bd0dbdc, 0xbf06d9a0, 0xbf36a3c8, 0xbef02855,
    0xbd640d92, 0x3f040818, 0x3f36e0c0, 0x3f178ddb,
    0xbd76af25, 0xbef661a1, 0xbf34cf41, 0xbf015acf,
    0x3d2eccf3, 0x3effd7e0, 0x3f3d54d0, 0x3efc3b16,
    0x3dae0431, 0xbf07ec4c, 0xbf3a65d7, 0xbf145ee0,
    0x3d84c17a, 0x3ecf21cd, 0x3f2ea838, 0x3ee39f42,
    0xbc0a90e4, 0xbeefdd0f, 0xbf45d468, 0xbeec08ad,
    0x3d985c21, 0x3f0b151f, 0x3f3346b4, 0x3f0c2208,
    0xbb01797d, 0xbf06293c, 0xbf535085, 0xbf078a00,
    0xbcfc62cb, 0x3ef74f87, 0x3f455ffa, 0x3f006812,
    0xbc810eb7, 0xbedb719f, 0xbf33fa8f, 0xbefa860a,
    0x3c209c94, 0x3ee50a5b, 0x3f3283f7, 0x3f11c253,
    0xbda891bc, 0xbee18824, 0xbf3fd06b, 0xbf191044,
    0xbc929880, 0x3f0180a3, 0x3f305673, 0x3efb21e4,
    0xbcb94387, 0xbefed7be, 0xbf1aad1c, 0xbefce2cf,
    0x3c971fcd, 0x3ee25523, 0x3f3dad5d, 0x3ef9a80c,
    0x3da6bdd2, 0xbf0c32eb, 0xbf2e334f, 0xbef1e470,
    0xbd3006f5, 0x3f02fc8d, 0x3f365883, 0x3ef02257,
    0x3da218c5, 0xbef43cec, 0xbf30ef39, 0xbefb07b7,
    0x3d291041, 0x3f1f9be9, 0x3f2d8e40, 0x3ed73dc4,
    0x3d00a94d, 0xbeffcf1a, 0xbf2e2e7c, 0xbef21921,
    0xbc8c9fe8, 0x3ee18868, 0x3f3f9778, 0x3ed462bb,
    0xbca66ec4, 0xbf05871b, 0xbf2fa5e9, 0xbef4b151,
    0xbd38a1ca, 0x3f058612, 0x3f3b5855, 0x3f0300fb,
    0xbd2a5c7f, 0xbf082045, 0xbf334754, 0xbedfd6f1,
    0x3d43e99f, 0x3eea6a6f, 0x3f28f3ff, 0x3ee1bcba,
    0x3d8442d3, 0xbefd4623, 0xbf2087ea, 0xbef0d886,
    0x3ccbc4ee, 0x3f14da23, 0x3f271a90, 0x3ed0a19d,
    0xbd362f97, 0xbf103523, 0xbf2217aa, 0xbf05e570,
    0x3dbedb25, 0x3efdceb6, 0x3f38ad50, 0x3ede9399,
    0x3c1e224f, 0xbf071c2b, 0xbf24fed4, 0xbf0339f2,
    0x3c432b30, 0x3f02ae21, 0x3f3eb69b, 0x3f12a80e,
    0xbd9595e1, 0xbf10c0b5, 0xbf3f1e22, 0xbf1061e8,
    0x3e25dfc0, 0x3f186866, 0x3f3c8d06, 0x3ef1c413,
    0xbcb7c909, 0xbeef1ff5, 0xbf4517cd, 0xbefeeeb5,
    0xbbf8bc2b, 0x3efd90f7, 0x3f2ec032, 0x3f0d557a,
    0xbba10788, 0xbf0abd92, 0xbf211376, 0xbefa20b8,
    0x3caff37b, 0x3f0210a7, 0x3f268a84, 0x3f0298e4,
    0xbc5bfe5f, 0xbf03decd, 0xbf2dc788, 0xbef24069,
    0xbb594465, 0x3f049273, 0x3f320665, 0x3ef0b95c,
    0x3d0d46ca, 0xbf014eef, 0xbf2e463d, 0xbed4744e,
    0xbd26c603, 0x3efbdaef, 0x3f17db59, 0x3f16fb98,
    0x3c9599ba, 0xbf04642b, 0xbf40329c, 0xbeb95cf9,
    0xbcdfad29, 0x3f0ff35b, 0x3f31df74, 0x3eb55daf,
    0xb98cf225, 0xbeea3e59, 0xbf31125d, 0xbf0aed13,
    0xbe011de2, 0x3ef296ec, 0x3f4496c8, 0x3ee7dd79,
    0x3da887a1, 0xbecc8e02, 0xbf31d0a3, 0xbed4a886,
    0xbdaf294d, 0x3f00dbc9, 0x3f20b0b2, 0x3efa8e13,
    0x3df8f108, 0xbf059816, 0xbf2c0fea, 0xbeae9ca2,
    0x3c8efad3, 0x3f0d2d32, 0x3f23ad95, 0x3efa9457,
    0xbc1a03fc, 0xbf0bece4, 0xbf1f1d30, 0xbef6ea14,
    0xbd4ce95a, 0x3efddac7, 0x3f23eca2, 0x3f028561,
    0x3bfab545, 0xbeebec11, 0xbf39322e, 0xbf13b058,
    0x3d9fe66e, 0x3eff6804, 0x3f25416a, 0x3ed45fe8,
    0xbc2a8ec8, 0xbef192fc, 0xbf33c6e4, 0xbf23b85e,
    0xbd236550, 0x3efa4562, 0x3f23cefa, 0x3eeaf3f5,
    0xbd92a1e3, 0xbeed41a8, 0xbf2a7078, 0xbee22aef,
    0xbdb1de22, 0x3f080774, 0x3f2a5156, 0x3ef95432,
    0x3dab1bf2, 0xbef0b618, 0xbf401c7b, 0xbf12ca25,
    0xbceb24ed, 0x3f031b0e, 0x3f3720a8, 0x3f163a47,
    0xbc1a653e, 0xbedb0e25, 0xbf31a5bd, 0xbedbdba1,
    0xbd558e74, 0x3f003b05, 0x3f3716cf, 0x3eff464f,
    0x3d725298, 0xbf11d013, 0xbf4774c3, 0xbf00b003,
    0xbd17b151, 0x3f008558, 0x3f2cf28f, 0x3efeab90,
    0x3d9c67b0, 0xbf0a9828, 0xbf38b75b, 0xbef6fed8,
    0xbd6990a1, 0x3eeb198a, 0x3f394401, 0x3f1934d5,
    0xbcdb2f71, 0xbef47fd3, 0xbf2cfc0a, 0xbf0f99f2,
    0xbc511df2, 0x3f0715e7, 0x3f4619a5, 0x3ee3aa37,
    0x3d8d0ee8, 0xbf05f46e, 0xbf2a2417, 0xbf03c587,
    0x3d99671a, 0x3ee3906e, 0x3f30f693, 0x3f00378f,
    0x3c143408, 0xbef7c386, 0xbf2771bf, 0xbf0b8e3c,
    0x3ca09a16, 0x3ee235f0, 0x3f425eba, 0x3ef76578,
    0xbdb9bdad, 0xbedc5547, 0xbf2b8dab, 0xbee04650,
    0x3ce51186, 0x3f07b2eb, 0x3f23b885, 0x3ee96f3b,
    0xbd96f20e, 0xbf183e73, 0xbf2799e1, 0xbeedfc3c,
    0x3db9fa63, 0x3eff6097, 0x3f359eeb, 0x3f060e6d,
    0x3c318102, 0xbf01174d, 0xbf3a1590, 0xbf06c511,
    0xbda2bbd6, 0x3ef72520, 0x3f3f30c9, 0x3ef75735,
    0xbb2ef0de, 0xbf09c1a2, 0xbf31d8f0, 0xbf0a9932,
    0xbd39dfd1, 0x3eca746f, 0x3f320001, 0x3f03cf4a,
    0xbd141a82, 0xbedb263d, 0xbf2ac54d, 0xbecc7ec7,
    0xbc291270, 0x3f00258b, 0x3f322d5f, 0x3eead1bd,
    0x3d0a32e0, 0xbf13ffc3, 0xbf35fdec, 0xbf163670,
    0xbd8e27be, 0x3ef26312, 0x3f3777b5, 0x3f042553,
    0x3c8e17f2, 0xbee7ff03, 0xbf354a9b, 0xbee24495,
    0x3db05cbe, 0x3ee91f4d, 0x3f3dbedc, 0x3f0c1864,
    0x3d22991c, 0xbeeec33e, 0xbf3b73d5, 0xbefe4f13,
    0x3d0e6200, 0x3efd2ef3, 0x3f2cd371, 0x3ee6542b,
    0x3d279d59, 0xbf02781c, 0xbf2ab456, 0xbef5e929,
    0xbd232c9b, 0x3efca70a, 0x3f2d4494, 0x3ef051d6,
    0x3d515b4a, 0xbeb4968a, 0xbf3b050b, 0xbf058103,
    0x3ca6c5e4, 0x3f0445b2, 0x3f27c47f, 0x3ef9361c,
    0x3ceb38e3, 0xbf0083ee, 0xbf27f704, 0xbf0de76a,
    0xbc5afb8f, 0x3f06cbce, 0x3f2dcfa0, 0x3f068c17,
    0xbde68369, 0xbf04f5db, 0xbf40f9bc, 0xbf08a0e3,
    0xbd1dbd88, 0x3efccb01, 0x3f33bdd5, 0x3f0f278b,
    0xbcfa3ac7, 0xbed3d759, 0xbf3cda22, 0xbf0c38af,
    0x3cd680e8, 0x3f184ac7, 0x3f1f0004, 0x3edd9812,
    0x3c8c3348, 0xbeffc363, 0xbf2eebb2, 0xbed3fed1,
    0x3d2c388b, 0x3ee66995, 0x3f3384e4, 0x3f01a858,
    0x3ccfa2db, 0xbf1483e3, 0xbf333294, 0xbf045804,
    0xbd10ba5e, 0x3ebb8c3d, 0x3f329221, 0x3f029288,
    0xbaf39106, 0xbef631fe, 0xbf4f0bb7, 0xbf0796f1,
    0x3c857e4b, 0x3f02ac2e, 0x3f198b21, 0x3f11d62b,
    0xbd92f189, 0xbf0aa9f9, 0xbf1d667a, 0xbf0b2522,
    0x3c00633f, 0x3f058878, 0x3f3d23f4, 0x3f006e8a,
    0x3aab6600, 0xbef6dcfb, 0xbf2b5c70, 0xbed49683,
    0x3d3a1995, 0x3ee626b1, 0x3f2ecc4e, 0x3f050683,
    0xbc613309, 0xbf071999, 0xbf2c6281, 0xbedef5e2,
    0x3db78507, 0x3ef07df5, 0x3f26566f, 0x3eeb0777,
    0xbc3e5326, 0xbef206a8, 0xbf44cfdd, 0xbef386eb,
    0x3cd76efb, 0x3eee70cf, 0x3f25bdcb, 0x3f0d6d71,
    0xbbcf2975, 0xbefff703, 0xbf39cc6b, 0xbf011d57,
    0xbe007f4b, 0x3f02da36, 0x3f3061c6, 0x3f07691f,
    0x3d4aaefe, 0xbefb0600, 0xbf1ab00f, 0xbeffd2f7,
    0xbcbc37ac, 0x3eeff880, 0x3f35b03a, 0x3f05a6bf,
    0x3dc09f5a, 0xbee0984b, 0xbf3731b0, 0xbefe1b67,
    0xbc4b64e3, 0x3eded135, 0x3f545db3, 0x3f18bbd9,
    0xbd9238de, 0xbed96bb2, 0xbf20fcfb, 0xbef2f546,
    0x3daceb22, 0x3ed50ec2, 0x3f29ebd5, 0x3efe7c2b,
    0x3cf30a13, 0xbf011863, 0xbf47cbca, 0xbef83517,
    0xbc3fe699, 0x3efebd2b, 0x3f52ce4b, 0x3ef68513,
    0x3a97a074, 0xbeecfab6, 0xbf273c84, 0xbefbffbf,
    0xbdd02bc6, 0x3f0fa57f, 0x3f3dd7b9, 0x3f0ce6f6,
    0x3b563aff, 0xbed53b24, 0xbf35165e, 0xbef6601d,
    0xbd1fa5ef, 0x3f01ec14, 0x3f3caf3e, 0x3eec6276,
    0xbd113730, 0xbf063bed, 0xbf24f891, 0xbed79d80,
    0xbc569e8f, 0x3f031597, 0x3f2ae169, 0x3ee7fd65,
    0x3d1b872b, 0xbf1186d3, 0xbf3db57b, 0xbed105e7,
    0x3cc3add9, 0x3edfbd29, 0x3f32f6fb, 0x3ee71778,
    0xbd1f7fbe, 0xbf13734a, 0xbf434456, 0xbf09d017,
    0xbc8358ee, 0x3ee81901, 0x3f45314d, 0x3ef9c30e,
    0x3e191ada, 0xbefff73f, 0xbf459d0e, 0xbf0a91c8,
    0xbe04d9ae, 0x3f0b0555, 0x3f30f1b7, 0x3f0ba270,
    0x3d8100eb, 0xbf054fb0, 0xbf43769a, 0xbf0c3e2a,
    0xbd3374cc, 0x3f066002, 0x3f32be93, 0x3ef601d2,
    0xbd4f2913, 0xbef871bf, 0xbf27efce, 0xbf01966e,
    0x3c72960d, 0x3f0c0bb6, 0x3f3886f5, 0x3f005692,
    0xbd3c8b66, 0xbee51c82, 0xbf419838, 0xbeebb062,
    0xbc16b0fd, 0x3f092934, 0x3f2674e5, 0x3edf060a,
    0xbc0c5617, 0xbf026b18, 0xbf315a76, 0xbefdd0e3,
    0x3d82218c, 0x3efdd70d, 0x3f32c24b, 0x3f012601,
    0xbc721a3b, 0xbef60b4f, 0xbf2a0f87, 0xbf0703cb,
    0x3d04df5e, 0x3ef628ef, 0x3f2fbc08, 0x3f0aac97,
    0x3d995e31, 0xbecc5abc, 0xbf33ab87, 0xbf0134e7,
    0xbd25a393, 0x3f00eed3, 0x3f315ee5, 0x3f0e5c7e,
    0xbd24c211, 0xbeffa19d, 0xbf30ad47, 0xbf106254,
    0xbd9320b6, 0x3efd4107, 0x3f3b8b38, 0x3ed42326,
    0xbc2e7c0f, 0xbed9a78d, 0xbf3ca1df, 0xbf0c2763,
    0xbd4adc18, 0x3ee5597a, 0x3f2128dc, 0x3f1814c1,
    0xbbe43b2c, 0xbf01e466, 0xbf2f0618, 0xbef801d5,
    0xbe016379, 0x3efc8bbc, 0x3f25a0ba, 0x3f02f01e,
    0x3db5359f, 0xbf0215ca, 0xbf341c29, 0xbeea6fa2,
    0x3d5015d6, 0x3f0598b3, 0x3f3e7207, 0x3ed7a5d2,
    0x3d40c7cc, 0xbef9f5c5, 0xbf2ed0ac, 0xbf0d147d,
    0x3c1a0388, 0x3f12d2cc, 0x3f19f097, 0x3f014c77,
    0xbd23c414, 0xbf06836f, 0xbf34774e, 0xbefa9dec,
    0xbc28a3ef, 0x3f028f6a, 0x3f3b7934, 0x3efae19e,
    0xbd3297e2, 0xbf024386, 0xbf3a6ccc, 0xbf0acf9e,
    0xbc73e786, 0x3f072e6e, 0x3f2e7fd3, 0x3ef81ff8,
    0x3be0034e, 0xbf02aa3a, 0xbf27ce51, 0xbf01bd8c,
    0xbd86cdf8, 0x3ed723cb, 0x3f335189, 0x3eda4921,
    0x3bd84f74, 0xbef83b5b, 0xbf159192, 0xbee3bb13,
    0xba6fc032, 0x3f01fe5d, 0x3f2fe15a, 0x3ef8d789,
    0x3c885a1c, 0xbf0f893d, 0xbf39efa2, 0xbf01771f,
    0x3d3ad9c0, 0x3ecf240e, 0x3f47bc60, 0x3ec9233b,
    0x3df4345f, 0xbef0c738, 0xbf2b03c2, 0xbefd3f57,
    0xbd8e30b6, 0x3f012811, 0x3f317292, 0x3f0b8eea,
    0xbdb818b0, 0xbf1b0a08, 0xbf2a4496, 0xbf0b2764,
    0xbcaa5d20, 0x3efd98d7, 0x3f37e734, 0x3eecc2ed,
    0x3c0fba22, 0xbef8f8b9, 0xbf22b170, 0xbf000c30,
    0x3d300ff3, 0x3f0541b2, 0x3f38f727, 0x3f000f43,
    0xbc1293f5, 0xbf001753, 0xbf312374, 0xbf017da0,
    0x3d8d5b53, 0x3efab3ee, 0x3f36bc65, 0x3eeea262,
    0xbcbf3e67, 0xbf07c225, 0xbf2bba90, 0xbf08423a,
    0x3d869253, 0x3eee0c76, 0x3f2f3780, 0x3f04a28d,
    0xbcc241f7, 0xbf0d5150, 0xbf4252bc, 0xbf0802aa,
    0x3c3192db, 0x3f03a932, 0x3f2c90e6, 0x3f023986,
    0x3c4b5877, 0xbee72097, 0xbf4224a6, 0xbed680a3,
    0x3dc15b43, 0x3f0f54cd, 0x3f3dc9c5, 0x3f026ea3,
    0x3d84ef43, 0xbf049a6c, 0xbf372b25, 0xbf064edc,
    0xbd8e1522, 0x3ef2ae87, 0x3f3ae618, 0x3f0b99f0,
    0x3d15653f, 0xbef4b1ec, 0xbf287168, 0xbf0fae6d,
    0x3d82534c, 0x3f09524c, 0x3f37ce2a, 0x3eb06f9f,
    0x3cbd079b, 0xbedeb900, 0xbf207aea, 0xbf0c728d,
    0xbc085979, 0x3f05e106, 0x3f2383a2, 0x3ef9633b,
    0x3d9d3507, 0xbf015ba1, 0xbf30b3e8, 0xbef2232e,
    0xbc363e6e, 0x3f0518ca, 0x3f36ba01, 0x3f0b9416,
    0x3cd2438e, 0xbedfde68, 0xbf32b5cd, 0xbee10c79,
    0x3dab64a4, 0x3f0e0d96, 0x3f25869f, 0x3ece432b,
    0x3b936767, 0xbf0f1720, 0xbf333815, 0xbf138429,
    0xbcbf11a5, 0x3ee5dac8, 0x3f52797b, 0x3eef7c6d,
    0xbc0d94d1, 0xbf0662fe, 0xbf4d66a6, 0xbee6ea23,
    0xbd063eeb, 0x3ee65f63, 0x3f2ba052, 0x3ed794f1,
    0x3ce0adce, 0xbefb33aa, 0xbf41224e, 0xbef51a1a,
    0x3b7f5bf8, 0x3ef5e3f4, 0x3f32d7f8, 0x3f1b880d,
    0x3d611b65, 0xbf1d053e, 0xbf361615, 0xbf042966,
    0xbcf0657e, 0x3f0aa904, 0x3f27ed57, 0x3f0cba1a,
    0x3d3de815, 0xbf09aa90, 0xbf2eedaa, 0xbedfacfd,
    0x3bef3137, 0x3f07a0dc, 0x3f31dda9, 0x3f09f62f,
    0x3cd63814, 0xbeeeff29, 0xbf2d8e1f, 0xbeca25e6,
    0xbd547267, 0x3f033408, 0x3f327f35, 0x3eff6be3,
    0xbb08a1e7, 0xbedc0895, 0xbf32208f, 0xbf267114,
    0xbc92d825, 0x3ee8d10f, 0x3f366d29, 0x3f0b9bd4,
    0x3c40da30, 0xbee20a09, 0xbf24de50, 0xbed1ba14,
    0x3c8f2a2b, 0x3f095e47, 0x3f2e1d40, 0x3f02e1b5,
    0xbc679de3, 0xbf05e1ee, 0xbf368038, 0xbefcc1b6,
    0xbd36f266, 0x3ece10c0, 0x3f35d66a, 0x3ef7c210,
    0xbb29b087, 0xbee07c22, 0xbf393513, 0xbef4c769,
    0xbcdb0531, 0x3ede9a21, 0x3f568c01, 0x3f08b95d,
    0xbcf6df96, 0xbeefbdb6, 0xbf2ff711, 0xbeff2687,
    0x3d592a9e, 0x3edfa39a, 0x3f2e1d59, 0x3ef39776,
    0xbdb686fc, 0xbf0675c5, 0xbf3cd282, 0xbef91689,
    0x3d33b3d1, 0x3f0d00d3, 0x3f43ff0e, 0x3f0430a2,
    0x3c956f42, 0xbedb78f5, 0xbf356229, 0xbf0dfc7f,
    0xbd1dde0b, 0x3efad913, 0x3f1ea777, 0x3ee3b683,
    0x3db987e7, 0xbf05db98, 0xbf3d200f, 0xbf0366b0,
    0x3d3684e0, 0x3eee8964, 0x3f36f287, 0x3ee6906d,
    0x3db76abf, 0xbef30987, 0xbf2e347a, 0xbf038573,
    0xbd96e882, 0x3eec991d, 0x3f372c86, 0x3ed36afd,
    0xbc52524e, 0xbf0d237d, 0xbf21e5fa, 0xbef687eb,
    0x3d019d69, 0x3eebc41a, 0x3f24b260, 0x3ee0a7e3,
    0x3d7c38a3, 0xbf04ce1a, 0xbf4bc817, 0xbf03133e,
    0x3ceb92b2, 0x3ef87426, 0x3f3109be, 0x3f00e36f,
    0xbd924f4d, 0xbefe79a4, 0xbf34e738, 0xbef1b20e,
    0x3cb11029, 0x3f126b4b, 0x3f3e6cce, 0x3eeb8ea4,
    0x3d11914b, 0xbf06c557, 0xbf349772, 0xbf008a93,
    0xbd311d08, 0x3edecefc, 0x3f255a10, 0x3ed772f1,
    0xbd1041a0, 0xbf084a61, 0xbf363baa, 0xbecf71cb,
    0x3c1aef49, 0x3f01b970, 0x3f379c6e, 0x3ee683fe,
    0x3d810b3b, 0xbf005bdf, 0xbf35f1c5, 0xbf056b6c,
    0x3cd88db2, 0x3eed2912, 0x3f312800, 0x3f06f597,
    0xbda7ca34, 0xbf09cb25, 0xbf3789e2, 0xbefa6dd0,
    0xbd78cfe1, 0x3ee6801f, 0x3f34eb9d, 0x3ee51cbe,
    0xbca85204, 0xbeeefe24, 0xbf3558e2, 0xbee9f82a,
    0x3d2246ac, 0x3ef1f25e, 0x3f342127, 0x3ed619f9,
    0x3d5a121d, 0xbf030e27, 0xbf3f1396, 0xbf027404,
    0xbcde6fdc, 0x3f03646d, 0x3f496744, 0x3ed97a45,
    0x3d01dc76, 0xbf1162f4, 0xbf2ae446, 0xbf162710,
    0x3d7df525, 0x3ef9a2f2, 0x3f28d3d1, 0x3f055f5c,
    0xbc7dc93b, 0xbedf8878, 0xbf484bf5, 0xbf08ce4f,
    0x3bb28a57, 0x3f0e6e9f, 0x3f346dbe, 0x3ee2deb3,
    0xbcf14b9e, 0xbf008be1, 0xbf32ef0d, 0xbed211f2,
    0xbd5bc4bc, 0x3eec4a3a, 0x3f3d7182, 0x3f0b2c71,
    0xbd35ff77, 0xbf08ba21, 0xbf232a26, 0xbf0fa109,
    0x3daf850e, 0x3f136bff, 0x3f3f0241, 0x3ee66e3f,
    0x3c9112ef, 0xbf0845d2, 0xbf2bb057, 0xbf09f22c,
    0xbd271877, 0x3f15c113, 0x3f44cc25, 0x3ee7b18b,
    0xbc31977a, 0xbf1da1d6, 0xbf309651, 0xbf0112f0,
    0xbd78c913, 0x3f107ea9, 0x3f196672, 0x3f09259c,
    0xbcf72789, 0xbef92d86, 0xbf326c3b, 0xbee5b471,
    0xbd9dc16c, 0x3f0bcb08, 0x3f2b7b04, 0x3ef460c3,
    0xbd96618a, 0xbee2ba91, 0xbf1e1aa0, 0xbed0044a,
    0x3bc2f765, 0x3ef21551, 0x3f3e58bb, 0x3eff31ee,
    0xbd4bd2d4, 0xbefe6a3d, 0xbf3697fe, 0xbef2a911,
    0x3c117c60, 0x3f02917d, 0x3f312108, 0x3ed06c4c,
    0xbd1a9116, 0xbf13135c, 0xbf29c07d, 0xbee54bea,
    0xbc6669d7, 0x3eeaead9, 0x3f3137e6, 0x3efff40d,
    0x3be75c53, 0xbec409d7, 0xbf36e87a, 0xbf0fdfb6,
    0xbd2b0f5a, 0x3eccd5a0, 0x3f31ff98, 0x3ee49999,
    0x3c9399d2, 0xbef08321, 0xbf2bc49c, 0xbf017934,
    0xbc7ffc16, 0x3f04cfb3, 0x3f36e07f, 0x3ee93093,
    0xbd5a5a6b, 0xbf08bf92, 0xbf34c196, 0xbf1b0d23,
    0xbd4f7f39, 0x3ed4ff48, 0x3f2d2b41, 0x3f031508,
    0xbb33359c, 0xbf0a6479, 0xbf2b5ae4, 0xbefbd4fa,
    0xbd699e0a, 0x3f0876b9, 0x3f31ee42, 0x3ec581ff,
    0xbccb4412, 0xbf0128fb, 0xbf351399, 0xbf02fd98,
    0xbaa66593, 0x3efcee6f, 0x3f3eeda5, 0x3ef33dc4,
    0x3d042650, 0xbeffeaf6, 0xbf13e442, 0xbf0df6af,
    0x3a81d85d, 0x3f1df646, 0x3f45525f, 0x3ef386ec,
    0xbd708259, 0xbf090fdd, 0xbf4b3f6c, 0xbeed7d94,
    0xbd8750a5, 0x3eecdc38, 0x3f2b3aea, 0x3ef219ec,
    0xbd905b7b, 0xbf00683c, 0xbf2ca93c, 0xbf117dd5,
    0xbbf6ed95, 0x3efd26f7, 0x3f244a4f, 0x3eff07d3,
    0x3d644e50, 0xbee761d1, 0xbf307344, 0xbf06fb26,
    0xbc89ba02, 0x3ed8f6cc, 0x3f2b2aa1, 0x3f00967a,
    0x3def5449, 0xbee2af97, 0xbf2d4f39, 0xbece4dcc,
    0xbd6f311e, 0x3eefbf19, 0x3f271325, 0x3f13d2f6,
    0xbda21f64, 0xbeff7fb9, 0xbf27a693, 0xbef07a09,
    0x3c704ec1, 0x3f0c00ab, 0x3f4044ca, 0x3efae08b,
    0x3ba16a67, 0xbf0d0c8f, 0xbf44a83f, 0xbeedda2c
    };

static const uint32_t in_rifft_noisy_4096[4097] = {
    0xc056d02f, 0x4042dd84, 0xc0350c82, 0x405c80e5,
    0xbf054250, 0xbf9ac1b0, 0x3fd551bf, 0xbf68278f,
    0xc03f8ef1, 0xc025a11d, 0xbfb54c92, 0xbfcbe5b6,
    0xc0292ffc, 0x3e84b95a, 0xbef00cf4, 0xbf5f3f13,
    0x3fc374b7, 0xc023784c, 0xc073775e, 0xbeadaaff,
    0xbf5dc8cf, 0xbf50f6b2, 0x402a7a66, 0x40515df5,
    0x4058d816, 0xc086820e, 0x3f8dbcfa, 0x3d9c8f80,
    0xc093bbf8, 0x3f36337f, 0x3e9e1a63, 0x4059ff1d,
    0xc0110dc7, 0xbf35492c, 0xbf90b197, 0x3f864e0b,
    0x3f1dca36, 0x3fa58d93, 0xbf542981, 0xc02c1d13,
    0x3ffa6e3e, 0x402ad9dc, 0x3f59127a, 0x3f37ef53,
    0x3ffb6007, 0xbe263cb9, 0xbf92f273, 0xc0326c79,
    0x400be107, 0x4018a3dc, 0x40648f3b, 0xc0802221,
    0x4080b32e, 0x3f6c4281, 0xbf442502, 0xbff59ead,
    0x3fec3e5d, 0xc011c987, 0x3f98e2a7, 0xc02ad9a4,
    0xbe5fca79, 0xbebeaeca, 0x3fa09337, 0xbf74f1f7,
    0x3f39eab8, 0x3ffabe48, 0xc03280bf, 0x402fb65e,
    0x3ff712d1, 0x4056692d, 0xbf00ecac, 0xc025bf00,
    0xbf30e497, 0xbf9a4548, 0x3e93d8ca, 0x3e47f311,
    0x4038a4cd, 0xbff42a3d, 0x3daaf7bc, 0x3f627179,
    0xc001fadf, 0x3fc509be, 0xbedbcbff, 0x3edc5102,
    0x3ea4a7c3, 0xbfd23b9a, 0x3f50cf77, 0xbf44f0e8,
    0xbd154a70, 0x402c2fb2, 0xc02d324f, 0x3e8555c7,
    0xc057ca66, 0xbed75ec5, 0xc02aca85, 0x4036760f,
    0xbe9dd588, 0x3f2c1af8, 0xbfa3f39e, 0x3da22852,
    0x3f914cc5, 0x3fd39a49, 0x3e0cff6c, 0xbf183571,
    0x40583644, 0x3f80fc1b, 0x40909329, 0x3e802311,
    0xc0326849, 0xbe3ba4c9, 0xbf9342ac, 0x3f95ec55,
    0xbef09232, 0xbf90d6bd, 0x3f56fbe1, 0x3f33734b,
    0x3fe80b60, 0xc06d1f30, 0xc02fccdb, 0x3f1a6e14,
    0xbf53434d, 0x40061e64, 0xbfaa0002, 0xbfda435f,
    0x4006a063, 0xc013a26c, 0xc02414b5, 0xbe563636,
    0x4055030e, 0xbdfce737, 0xbf627c54, 0xbf8037a8,
    0xbff10922, 0x3f739cf7, 0x40267e5f, 0x4044436d,
    0xc0c0b84a, 0xbfa88e8f, 0xbfc8e8f4, 0x3e77f538,
    0x40721056, 0x3d778b13, 0xc065d174, 0x3eb3f834,
    0x3f06215d, 0xc0447543, 0x3fc29a06, 0x3f27f0ec,
    0x3f24d9f5, 0xbfdbc70a, 0x4019453c, 0x402c2dab,
    0x3e24ae59, 0xc015323d, 0x3f70df8a, 0xbf59bb52,
    0xc01fd63d, 0xbf064723, 0xbf3ff08b, 0x402f03fc,
    0x3fbd4cbc, 0x3fab3535, 0x3fd6054c, 0x403efeb6,
    0xc09eaafe, 0xc088627d, 0x4048d84e, 0x40162632,
    0xc0130edd, 0x4016c4bf, 0x3f75b2f6, 0x3ec99ff7,
    0xbfa325bf, 0xc024e6c5, 0xbfbb3a0c, 0x3f2993c8,
    0x3f8b3aa4, 0x3e4a6fb5, 0x3da24f3f, 0x4074584f,
    0x3f573f96, 0x403cd667, 0xbff9eabe, 0x40aea7d9,
    0x4044c500, 0xbfb06725, 0x3e54aceb, 0xbffa5e87,
    0xc02ddec5, 0x3fc83548, 0xbf9971a7, 0x40028db3,
    0x3e1c56d6, 0xbf94fbe9, 0x3fea14e4, 0x3fe9b4e9,
    0xc008cd37, 0xbfccf02a, 0xbf056527, 0x3e54f648,
    0xc0379e28, 0xbe9e9b07, 0xc03ac58b, 0x400bb7d3,
    0x3fab17e1, 0x4009cc4c, 0xc04e9564, 0x40474243,
    0xbe865537, 0xbf90cd07, 0x3fe3cc58, 0xc0bdad7c,
    0xc03a70b0, 0x40dbd854, 0xbfdd78d1, 0x3effb11b,
    0xc01cd17f, 0x3f4821e0, 0xc0738f1d, 0x400fa1bc,
    0x3fb8849b, 0xc05bef53, 0x403e9784, 0xbe2513ff,
    0xbf0fd0f5, 0x400342ee, 0x3fff4cb8, 0x40af0be0,
    0xbff0b1b1, 0x3f2d7251, 0xc00dbd9c, 0x404446cb,
    0xc011cc9e, 0xbf862970, 0xc021d6aa, 0x40811a51,
    0x3ff5514e, 0xc07a2438, 0x3f16eb5a, 0xbf138e59,
    0xc07afd98, 0xbf1a0ecf, 0xbfa35914, 0x406877a0,
    0xbf00a0a5, 0x401758b4, 0xbe4c6307, 0x3ee10d1b,
    0x3db07e77, 0x3f70afe2, 0xbfe54dee, 0x40982225,
    0xbf0ad83c, 0x3ffe2a9a, 0xc008e0aa, 0xbf47e23a,
    0x3f6237de, 0xc07cb9cd, 0x3fab49c9, 0xbdbaa8d9,
    0x3d856b36, 0xbf9a62d2, 0x3f2a6947, 0xc02d9d74,
    0xc08b83e5, 0x3ed35cbc, 0x4044e81a, 0xc00d077f,
    0xbf9a1510, 0x4025096c, 0xbf9a651a, 0xbf812a1c,
    0x409a5103, 0xc0227173, 0xbf39b363, 0x401ea773,
    0xc086d2a7, 0xc0aea7f4, 0x40759065, 0xbfabd8a5,
    0x3e6f2441, 0xc02be3a4, 0xbf84eb15, 0xbfb30aef,
    0x3fabe4e6, 0x3e221740, 0x40059978, 0xbd92f882,
    0xbe6e44dc, 0x3fc585f4, 0x3f7923f9, 0x3e9ddc69,
    0x3f6561dd, 0x3fc6b3dc, 0x3cbd5aba, 0xbf62e997,
    0x3f2e9598, 0xbea9d385, 0x3f6cc875, 0xbfd30070,
    0xbe28869c, 0x401b426c, 0x40771b94, 0xbf8ab9e2,
    0xbf96a90e, 0x3f04aeeb, 0x3f08aa11, 0x3e31f743,
    0xc062793f, 0x4028c874, 0xbde8fc9d, 0x3f51499d,
    0x3f38f29c, 0xbfc71458, 0x40432e7e, 0xc010970b,
    0xbfabffd3, 0xbf9650f0, 0xbfa87078, 0x3ff9637c,
    0x3ff6ae76, 0x3eff2c8c, 0x3f8ebfd0, 0xc05fad03,
    0xbfffbb4d, 0x3fe73cf9, 0x40be8e9e, 0xbeb42b18,
    0xbe46b28b, 0xbf0612c7, 0xc01eac80, 0xbf845596,
    0xbfa1e347, 0xbf4f670b, 0x3f89b117, 0x4006c566,
    0x3fa33a5b, 0xbfb19853, 0xc05a2f6d, 0x3c28994c,
    0xbd338b19, 0x404d2bc9, 0x3d0641f8, 0xbf7f40ea,
    0x3fa46fb0, 0xbff3f3cc, 0x3eded51f, 0xc00aaa04,
    0xc04efca4, 0xc01f0c97, 0xbfa2da56, 0x3f5653f7,
    0xbfeca147, 0x3fb6cca9, 0x3f118e6f, 0xc00e6f71,
    0xbdf1263e, 0x408a1cb8, 0x3f8aaf7d, 0x3fe5cf5b,
    0x406914e9, 0x400496eb, 0xbf825923, 0x3b44a0dc,
    0xbfa642b2, 0x40b2ff8f, 0x3fc55db9, 0xc05b5e7f,
    0x401ae0db, 0x4009c0ff, 0xbf18e911, 0xbf3a65bc,
    0xbe6106a7, 0x3ffb60d2, 0xbfcbffa6, 0x3d165d0e,
    0x403acabe, 0x4022368c, 0x3fd26817, 0x4021e673,
    0xc0129b7d, 0xbf89c92f, 0xc0326231, 0x4005f21e,
    0xc054daf3, 0x405ecf80, 0x4047574e, 0xbeb2f705,
    0x3e9a168d, 0xbff890c1, 0xc06de2df, 0x400f93d4,
    0xbf48c35a, 0xc02290fa, 0xbcfb2af9, 0x3ee14170,
    0x3d794bd3, 0xc02a3303, 0x40048a7c, 0xc08c4907,
    0x3fc18afc, 0x404c8071, 0x3fd14fd6, 0x403000a6,
    0x3f680482, 0x3f37bbee, 0x3fac153f, 0x3ecbf557,
    0xc056b16e, 0xbea12fa7, 0xbfa1014f, 0x3ef91316,
    0xc03c721d, 0x3ff9c513, 0xc00a6dec, 0x3fd36aef,
    0xbffac84a, 0x3d285e24, 0x3f042c38, 0x40046617,
    0xbe8b8411, 0xc060722f, 0xc02a0b58, 0x3fc9c6b6,
    0xc098966b, 0xbe32b30a, 0x3d487e3b, 0xbfb7316e,
    0x3e8bdcc1, 0x3f79114d, 0x4009f2c6, 0x40865d56,
    0x3fb6929b, 0x3fcd26b7, 0x3f1235c2, 0x3f9ec6a1,
    0x3f2e394a, 0x3dae7519, 0x3e505ace, 0xc070b00b,
    0x3eed5933, 0x3f505547, 0x3f9949e0, 0x404d5715,
    0xc02a2558, 0xbfae75ef, 0xbee8458a, 0xc0060768,
    0xc026d32f, 0x3fd10500, 0x3f26494e, 0x3ff1c502,
    0x3fd5f703, 0x3fdd83b9, 0x3f0cf88b, 0xbf065e1f,
    0x401bc0a6, 0x3ac49e77, 0xbeb60914, 0x3f0855ac,
    0x3ebad7f1, 0xbfd615ce, 0x3f54571c, 0x3e38c5c3,
    0xc005c662, 0x3f0165e4, 0x3dcb1ee3, 0x3fa8776c,
    0xc019fb94, 0x3fefa04b, 0xbc2b56bb, 0xbf17f737,
    0xc017706a, 0x3ffa0a49, 0xc0373e88, 0xbf9f22e8,
    0xbe71cbd1, 0xc07c4ebc, 0x3fdef31c, 0xc029a9b7,
    0x4043634e, 0xbf93c0af, 0x40a5ea06, 0x3ebc3fb6,
    0x401c1431, 0x3ff2d945, 0x408ba098, 0x4009c434,
    0x3f876d76, 0x3fce9b88, 0xc03c1b92, 0xbff10016,
    0x4003a12e, 0x4017a83b, 0xbea7e910, 0x3ea81009,
    0xc0547c09, 0x3f9047ff, 0x3f92f14d, 0xc09f4feb,
    0xbfad48aa, 0xbed170ec, 0x3ed10288, 0x3f966b81,
    0x4051f488, 0x3fcb75d2, 0xbff777af, 0xc02d176f,
    0x4030396f, 0xbf0e1230, 0x404c3eb6, 0x3f3e63af,
    0x3f3196a8, 0xbf9f6e93, 0x408ae203, 0x3f6a9710,
    0x407b1d63, 0x3f7ecccb, 0x4052b329, 0xc03c28e2,
    0x3ead8bfe, 0xc076875f, 0x3fd54555, 0x406dcb5a,
    0xbf21eb09, 0x3faec074, 0xbeda6c66, 0x40825bc5,
    0xbf969bb0, 0xc000d6ea, 0x3f7415c9, 0x3eec1965,
    0x3d841f68, 0x3fce255d, 0xc0c995fd, 0xbeb30d3c,
    0xc0770aa5, 0x3fcfd616, 0x3fb0b8a3, 0x3fa4bba7,
    0x4071330e, 0x406bd02e, 0x3ff7e81c, 0x401e436d,
    0x3e89a8a0, 0xbf48fa88, 0x3f40ab05, 0x3fc4132b,
    0x3d8a2d61, 0x3f30cd83, 0x3ed7ed33, 0xc04c0859,
    0xbfc7dcc0, 0x3fd21981, 0x3ffb1bf0, 0xbf9e43eb,
    0xc0230108, 0x40219fc0, 0xbf2fd0a9, 0x4076e25a,
    0x3f890815, 0xbebda4a1, 0xbfc5ccaa, 0x3f339140,
    0xbe00c71b, 0xbfdd7667, 0xc0840250, 0xbe65fba6,
    0x3e9c032a, 0xc03d7c20, 0xc07e752d, 0x40649f3b,
    0xbfa18786, 0xc065346b, 0x3fff66f9, 0x3dea2df7,
    0x4044ffd8, 0x3fb38eb6, 0xbf061864, 0x3ee26cb4,
    0x401fb619, 0xc03a13b4, 0xbef55ac8, 0xbfc57a5c,
    0xc0a348be, 0xc06dde8c, 0x3f8fcdd6, 0x3edf60e2,
    0xbe3ca984, 0x4003d4d3, 0xc0374bf4, 0xbff1ea88,
    0x3fa6eeda, 0xbe4c5b49, 0xbe84b621, 0xbf39b106,
    0xbf841f5d, 0x405d6f9b, 0xbd82572a, 0xbeb0bf61,
    0x3f29d46c, 0xbed140df, 0x3f9f1560, 0xbf836706,
    0x400cfdf3, 0x3f90c032, 0x3eb5722c, 0xc00fc7ca,
    0x3f74b3e4, 0xbf92ec36, 0xc022ede0, 0x3f69c010,
    0x3f8b0e22, 0xbfbb8f12, 0x3fdab924, 0xbe5733a4,
    0xbf9fb0ae, 0xc00badad, 0xbfb3954d, 0x3fc6160f,
    0x4094b838, 0xbe763b34, 0x403636aa, 0x400cf79f,
    0xc04a47f2, 0x3f70a880, 0x400d5637, 0xc03e8c37,
    0x400b1e1d, 0x4052fb92, 0x3ff033f0, 0xbeab69c0,
    0xc0990806, 0xbff5e21a, 0xc0460528, 0xbef392b6,
    0xbeb99a1c, 0xc011fe8a, 0xbfbb45eb, 0xbf8ce957,
    0x3fbae5a2, 0xbf58715d, 0x3f80c9d1, 0xc0b2fa5b,
    0x3fad77fb, 0x40b365f8, 0xc0346c2d, 0x40094c14,
    0xbff98a2c, 0x40e21fb3, 0xbf93758e, 0x3f7b73de,
    0xc02510f5, 0xc016030e, 0x3f820024, 0xbf7d405a,
    0xc01d1e04, 0x3f6087f6, 0xbfbca09e, 0xc08c673b,
    0x3f836ac3, 0x40233e36, 0x3de541c6, 0xc06a1bf1,
    0x3f6fbb8a, 0x3f66c486, 0x407574c8, 0xc03bef4e,
    0xbf2cfe6f, 0x3e32d632, 0xbfe7a4fa, 0x3fa576e4,
    0x3fe57017, 0xbf598cdf, 0xbfdb2ca3, 0xc07a90c7,
    0xc02c2d70, 0x3f8cb142, 0xbf5f8887, 0x3dc3a75b,
    0xc0230ac1, 0x3faae295, 0xc02d7ebc, 0x4032b4f8,
    0xc0e64c19, 0xc0b45c3f, 0x3fe59b85, 0xbf0813c4,
    0xbf3d0ef0, 0x4064d005, 0xbecb07d8, 0x402bcd45,
    0xbde183d1, 0xbf919b14, 0x4027d25c, 0xbfaf6e4d,
    0xbfa884c3, 0xc06a2bdc, 0x3fd07e29, 0x40067b8c,
    0x3fae46f8, 0x40221e7e, 0xbf153f67, 0xbf75e5f9,
    0x40a8938c, 0xc01d8a16, 0x3f529324, 0xbf1241d8,
    0x400c1be2, 0xc0493415, 0xc02653d7, 0x3e64668b,
    0xbe62ea26, 0x3f8dc435, 0x4022d10f, 0xbfb08a78,
    0x3f25dbb2, 0xbe4f83e5, 0x3fa9c6a6, 0xbf880774,
    0xbfd21e92, 0x3fb88261, 0xbd7491b1, 0xbfce34a9,
    0xbeedfc7f, 0xbfa86640, 0x408c7acb, 0x3f2b08a8,
    0xbf153773, 0xbfa7d918, 0x403793b5, 0xbf7c819a,
    0x3f2125d8, 0xbe73dd75, 0xbfd83355, 0xbfad556b,
    0xbf2febf2, 0xbf05210d, 0xbf9e61dd, 0xbf920972,
    0x3f0ef1d3, 0xc06eef9e, 0x3fbc3d9b, 0x3f307500,
    0xbf73d534, 0xc03f0093, 0xbff6ba6d, 0xbffc7fed,
    0x3f7ab23f, 0xbfbbd771, 0x3f90b3ab, 0x400cd4ca,
    0xc0f0434f, 0xc01b29c6, 0x3fa66066, 0xbf88fa66,
    0xc05b3c6c, 0x4026db84, 0xc005b3b3, 0x3fae784e,
    0xc04ce308, 0x408970fb, 0x4065a15b, 0x3e6f87f6,
    0xbf93ab17, 0xbf52121a, 0xbff83bdf, 0xc0423033,
    0xbf012ac6, 0xbf825d7d, 0xc040b7b9, 0x40052035,
    0xc05ab4db, 0xc05594ac, 0xc09ec332, 0xc07a4fbc,
    0xbf169cd6, 0x3ff2c3ca, 0xbd402e19, 0xc006033c,
    0x3f389367, 0x4015b109, 0x40153dd1, 0xbf42324a,
    0x40a98267, 0xc047e615, 0xbea80677, 0xbec78ab4,
    0xbff9292c, 0x3fe065ff, 0xbe187d61, 0x40099c98,
    0x401a8d02, 0xc0577339, 0x401ea9fb, 0xc0780888,
    0x3f97ad8b, 0xbd8273d4, 0x402f7f0c, 0x40312f1d,
    0x3fe4016c, 0x4098faa4, 0xbeba2dd5, 0xc07d5756,
    0xbea2252c, 0xc0a087b5, 0x3f5fd2d1, 0x3fad48bf,
    0x40052085, 0xc0f0ad05, 0x40302285, 0xbed3acff,
    0xc0576326, 0x3fe8edc3, 0xbf932fae, 0xbff8f3a1,
    0xbf82e4c6, 0x3fb667a9, 0xc027afe4, 0xc0982de6,
    0x3f72a183, 0x401dd5f4, 0x3ea60c11, 0x3d8c2686,
    0xc09ce95f, 0x4003c691, 0x4078d399, 0x3e04a47c,
    0xbf2b2138, 0xbec972a5, 0x3f8522cd, 0x3e830124,
    0xc0665007, 0xc02b85e3, 0xbfcc35ff, 0xbfcc2177,
    0x403c3d90, 0x3f9d8d8b, 0xbf9cecb6, 0xbdafb716,
    0x3d905e63, 0x3e7379f7, 0xc01daaa0, 0xc087ac81,
    0x3ed2879a, 0xc0c5dd60, 0x4096d2b3, 0xbe498080,
    0x40c1c7aa, 0x3e6bc8eb, 0xc08b442e, 0xbfedf675,
    0x40a98e5c, 0x40492c29, 0xbf23a411, 0xbf1e1d41,
    0xbd479169, 0xbf3b722a, 0xbdab5538, 0x3e5ffb5e,
    0xbecd82e8, 0xc0767089, 0x40389f43, 0x40873eb8,
    0x3f705059, 0xbfec3139, 0x401c1598, 0x3f1848f9,
    0x3f0f73c6, 0x3fed5930, 0x40b5c242, 0xbe9cc021,
    0xc03d4467, 0xc01dfed8, 0x3f8a4881, 0xc0582ed1,
    0x3e994f4d, 0x3f90dbdf, 0x40027eb0, 0x3f8f074a,
    0x406744b2, 0xbf3cedb0, 0xc02c9c37, 0x400cb96b,
    0x409dd298, 0xbf7873a6, 0xbfb8b976, 0xbe8c2748,
    0x40111de2, 0x3f3d5eec, 0x3ddb9573, 0xbd2d2334,
    0x40763ed0, 0x3fa05d61, 0x4010b1e1, 0x40149970,
    0x3fbd5261, 0x3eca7682, 0x3ea46522, 0x4082b4e7,
    0xc03ed753, 0xc0bf1760, 0xbea9f6e4, 0xbdaa1ca5,
    0x403a9079, 0xc043ab9c, 0x3f75e57e, 0xc060f2c1,
    0x40907596, 0x3f405b17, 0xbfbab52e, 0xbfb3b8ae,
    0x4088a714, 0x404f6e29, 0x4011068d, 0xc08f55ca,
    0x407bfb5a, 0xbf9f1fa6, 0xc02d8f5b, 0x3efa5688,
    0xbfd721d0, 0xbfbbe59d, 0x3e2c1d19, 0x3fb94fee,
    0xc0246536, 0xc0b6bc42, 0xc01c010a, 0xbf8e220a,
    0x3ffa61d4, 0x3f75eeba, 0xc00b9e27, 0xbf21b52d,
    0xc02113a4, 0xbfe0c1c5, 0x40181d7c, 0x3fb1f3ab,
    0x40431e29, 0x403544bb, 0xc01fdf47, 0xbe8fde93,
    0xc0759888, 0xc02278dd, 0x3f989070, 0x3f9893f7,
    0x40050a7f, 0xbf9d68e8, 0xc06bf2d5, 0x3f708d32,
    0xc04cb581, 0x400c398e, 0xbf541145, 0xc00c3f35,
    0x40276146, 0x3fe9a299, 0x3e65c168, 0x3f4f13ac,
    0xbff326bb, 0xbfd14321, 0x3e3b15cc, 0x3f0c2f96,
    0xc01ee24c, 0x3f687afb, 0xbfd437d7, 0x40819d85,
    0xc004a05a, 0xbf7c702c, 0x3f322118, 0x3eb9dda6,
    0x4029b5da, 0xbfe9adfc, 0xbf87ba21, 0x3f4ced5e,
    0xc0107c38, 0x3f1198ed, 0x3f717dbc, 0xbfb604db,
    0x3f922cad, 0x40080cad, 0xbfd8c644, 0xbec9e984,
    0xbfe04e45, 0xbfa44c07, 0x40251378, 0xbf36d944,
    0x3fa49df5, 0x3f2ce6dc, 0x400462e6, 0x40210af5,
    0x3ee95522, 0xbf769c0a, 0x4085585b, 0x4084168f,
    0xc03cfd7b, 0x3fd48ed5, 0xbeb3be3a, 0xbfb12361,
    0xc016584a, 0x3fb7ea04, 0xc027dc70, 0x3f021b74,
    0x4051f2f1, 0xbfd9354e, 0x401aa7c8, 0xbf1ed9f9,
    0xbfcd5b8d, 0xc0897ea5, 0xbff90f94, 0xbf87358d,
    0xbd9862f5, 0xbff8573a, 0xc03e9cad, 0x4023fc57,
    0x3f9e7064, 0xc01c1263, 0x3ea195c4, 0x3dc67d1c,
    0xbf579737, 0xbfb17268, 0x3fc162e8, 0xbfbba15d,
    0xbcb83107, 0x3fe660ad, 0xbfb33e09, 0xc0296d0c,
    0xc0c8cf56, 0xc4b30fd9, 0xbdbd9ed5, 0x4029d141,
    0xbfc162e4, 0x4086cc3c, 0x40cdd125, 0x3ef046be,
    0x40a4855a, 0x3e7c1d1c, 0xbfd9d757, 0x4068813a,
    0x3e7abc2d, 0xbfb2f4ea, 0x3fc52126, 0xc00a3a5a,
    0x3e808b7d, 0xbebf20c9, 0x3d8b04e6, 0xc0175f04,
    0xc068f385, 0xbf011bab, 0xc054a8f3, 0xbf2deb50,
    0xbeb13ae0, 0x3f987bd0, 0xc082e4f2, 0x3f0a00ed,
    0xc0865524, 0x40ab7675, 0x3f1cd3d3, 0xc0765753,
    0x4004eb69, 0xbf1a5d53, 0xbdf2459d, 0x3f7ddd20,
    0xc042cfa2, 0xbd4bb0f1, 0xbec0f300, 0xc0331852,
    0xbf041b87, 0xc01cac51, 0xbec0d6a1, 0x3ea447af,
    0x3e843697, 0x3fc5e6ad, 0xbfb0127d, 0xbf570a6d,
    0xbf6e5d8b, 0xc08481c3, 0xbe65c9d5, 0x4023f79f,
    0xc023f180, 0x3f06fa5c, 0xbf0f404e, 0xbe590609,
    0x3fd97c95, 0xbf92ad3e, 0x40ad3be1, 0xbf8d2408,
    0xbdee09e3, 0xbf13f4c3, 0x3f72bde8, 0xbf1ad9ce,
    0xc02c0cc6, 0x3f80de2e, 0xbd8d6ae0, 0xc0d32dda,
    0x3fe72c74, 0x3f96da54, 0x3eddd516, 0x3da4e1d0,
    0xbfc5f3d0, 0x40d19e5e, 0x3fc9bbdf, 0xc01a755f,
    0xc02a1507, 0x3fe75588, 0xbf411bcb, 0x3f58a996,
    0x4066ce7a, 0x3ffea1d7, 0xbf2cbe9c, 0x3e3e35c4,
    0xc016f513, 0xbf4f9949, 0xc0327052, 0x4089cdd7,
    0x3f232586, 0x3fa957d8, 0xbed7a478, 0x40043e95,
    0xc08befdb, 0xbfa05865, 0x3f37f831, 0x3edc4318,
    0xbe7401c4, 0x40011f25, 0xbf101599, 0xc0ae22d1,
    0xbfbc8ba4, 0xbef44326, 0xbf843011, 0x4019d5a0,
    0xbf8ef602, 0x3fa7d3f0, 0x3ffedc01, 0xbf23f4fa,
    0xbe945d6b, 0xc00b4d8c, 0xc0326106, 0x3f988535,
    0xc0756651, 0xc0e59fbb, 0x405691e8, 0xbe960792,
    0x3fc4ffd2, 0xc09e8b5b, 0xbec9ce1b, 0xbe804f37,
    0x3fdbc7ea, 0x3fcd2d90, 0xc033b6cf, 0x3ea14dfa,
    0xc01e0cd9, 0xc015346c, 0xbf970be8, 0xbff3165c,
    0x405c28dc, 0xbe1a37af, 0xbda4bf2f, 0xbfd584ed,
    0xbd03957e, 0xbf41048b, 0xbfbc0470, 0xbfba4927,
    0xbd58569b, 0x40884d9a, 0xc00817de, 0xbfcab44c,
    0xc02ad4b3, 0xc0637724, 0x40169fda, 0xbf9c6928,
    0x3fbdbf83, 0xbf8cb64e, 0x3f86da4a, 0xbf33b0e7,
    0xbebbf2a1, 0x40137990, 0x4069204d, 0xc050fe97,
    0xc02e89a8, 0x3f131609, 0xc02ec9db, 0xc00891b6,
    0x40707c3b, 0x40467a37, 0xc0626ef1, 0x3fb3b3dd,
    0x401a32ca, 0x3fe8f61f, 0xc016620e, 0x3fef6e24,
    0xbfa8905a, 0x400b6bcb, 0x3fed30e1, 0xbfbd0c35,
    0x409cecee, 0x3ddc594c, 0xc0722547, 0xc02af521,
    0xbfc13e13, 0x3fa53c78, 0x3fa5cf96, 0x40382a5d,
    0x3e1d8256, 0xbfa953fa, 0x3f8e352d, 0x3f4b9938,
    0x3e87e8c1, 0x3f1f2e6e, 0xc04314bd, 0x3cc5f9ca,
    0x3fc616f5, 0x3fc138b4, 0x402641ce, 0x3f133bb9,
    0x40824fd6, 0x4023934b, 0x402882c4, 0xbd04a4d3,
    0x3f66a17c, 0x3ff8ea83, 0xbfac98cc, 0xbfc16996,
    0xbfbb1653, 0xc04c835b, 0x3e6aa904, 0xc0063914,
    0x400e68ac, 0xc01a4d4d, 0x3fb01acb, 0x40e07f58,
    0x3e585012, 0xc088cf48, 0xbf3d06f5, 0x4040e7d5,
    0x3eb1439f, 0xbea6b5f3, 0x3d8ef1d0, 0xc00cd2c7,
    0x3f221532, 0x3f8d8e6c, 0x40571700, 0xbea6dbde,
    0xbf2f1e11, 0x3ff19d58, 0xbf58acbd, 0xbf171666,
    0x400763ea, 0x4004584a, 0x40101f4e, 0xbfe5ab7f,
    0x3fed72fc, 0xc0516405, 0x3fde1818, 0x3e5e3fed,
    0xc0136e21, 0xbe1c554e, 0xbf128363, 0x3f4737f8,
    0x3ef1f43d, 0x3fc49cce, 0x3f91d58c, 0x3fbcb73e,
    0x3fdd0237, 0x3eef6ba9, 0xbfb3f56b, 0x3eb21331,
    0x40314fb8, 0xbf8484b3, 0x4061646f, 0xbf905e75,
    0x3f06eb0a, 0xbe804276, 0x3e1afb7c, 0x40428c3f,
    0x409b58c0, 0xc010e28b, 0xc01cc1e4, 0x3f8224ba,
    0x400e8914, 0x3f4fd1cb, 0x3fb24976, 0xbe462fd5,
    0x408e868c, 0x40399d7d, 0x3f9fbbae, 0xc05d3205,
    0xc0259855, 0x4046edd8, 0x3e7a63a8, 0xbdcfcb02,
    0x4007eb5a, 0xbd8baaac, 0x3fa12fb9, 0x3ef32ca3,
    0x404d52bb, 0x3f7eccde, 0xbfe4e1be, 0xc02d083d,
    0x3f1efa03, 0x3fcccf29, 0xc00da719, 0xbf158cee,
    0x3f450925, 0x408837f8, 0xbf2bd01a, 0x3f00fbdc,
    0xbf833c01, 0x403e8b3e, 0xc00001f5, 0xbf403202,
    0x3e428f26, 0x404144a4, 0xc05aac6a, 0xc080332e,
    0xc0903c41, 0xbf73bd0d, 0x400f624b, 0xbfb9a60a,
    0x3f02e6cd, 0xbf7f5c14, 0xbf8b1d37, 0x400b3e6a,
    0x3f91162c, 0xbfe263f8, 0x40340b58, 0x3f89588d,
    0x3f476869, 0x406ce475, 0xbd177c94, 0xc0560930,
    0x3fe0487f, 0x3fbc4038, 0xbf00ef7e, 0x3f82e981,
    0x40243250, 0xbf8b3a7a, 0xbfe94e8d, 0x3fdbde53,
    0x3e758996, 0xbf24a564, 0xc00ffc32, 0xbf9c64e4,
    0x4072999f, 0xc0014549, 0xbfb0f580, 0xbfec4621,
    0x3e6a9dda, 0xbfc0cd2a, 0xbfc79ec5, 0xc05ea6df,
    0xbee95468, 0x3f98deb3, 0x3f9536a9, 0xbe0be287,
    0x3fc70841, 0x403a4472, 0x3f973f6f, 0xbfff86db,
    0xc0837ea1, 0xc01272db, 0xc01ae76b, 0xbf95583d,
    0x401c4e8d, 0x4024cbf8, 0xbf835d75, 0x3f4d613d,
    0xbf094a1f, 0x405f1cf8, 0xc01d8632, 0x3f336c29,
    0x3fdb5a5c, 0xbdafb51b, 0xbe1a9401, 0xbf88b730,
    0x3f00290e, 0xbf1a046f, 0xbe35a7e4, 0x40019762,
    0xbe0bc372, 0xc094dc45, 0x40657413, 0x400477c9,
    0xbf614bc7, 0x3fafb7c1, 0x3f02e638, 0x3da8f9df,
    0xc0237434, 0xbee7599a, 0xc03b6789, 0xbf161a5c,
    0xbfe5a874, 0x3e5fafee, 0x3e22f969, 0x3f464569,
    0x4003779d, 0xbfd6a8e3, 0x3f38e3e6, 0xc000c82f,
    0xbff28293, 0xc09f9630, 0xbfc0f23e, 0x3f96e6b9,
    0xc004ab59, 0xc0638f75, 0xbebc8463, 0xbe028f83,
    0xbfa9ed57, 0xbeafec3f, 0x4014f6f3, 0x3fe5b6e7,
    0xc0636c37, 0xbf1571db, 0xc01bedb3, 0x40907ec8,
    0xbfd8b792, 0xbfbde766, 0x3eebb4aa, 0x4040a0ff,
    0xbf8e7aa5, 0xc032f170, 0x3e10feb9, 0x3f106cbf,
    0x400beca9, 0x3fc3cc14, 0x3f86e25a, 0xc019955e,
    0x401d1892, 0x3fdb2a30, 0xbf08d38a, 0xbf46d790,
    0x3c8a90ee, 0xbf6fdd08, 0x4033652e, 0x4082d337,
    0xc001dd26, 0x401cd19f, 0xc0264006, 0x3fbbebb0,
    0xbfd23f5a, 0xbf4b6d98, 0x401dcfeb, 0xbf4dcf40,
    0x3f017fbc, 0x4069318f, 0x3fef079f, 0x408e7d23,
    0x3f9768df, 0xbe21adda, 0x40a66d89, 0x3fc77915,
    0x4084e46a, 0x3f68a206, 0x3f404ba1, 0x403e0470,
    0x3f817cbe, 0xc008622e, 0xbfac6aa1, 0x3fa85e36,
    0x3f9464ed, 0xbdffba7f, 0xc049fa78, 0xbf95471d,
    0xbf22b9ba, 0xbebb8520, 0x408dd806, 0x4020c091,
    0x3faeebfa, 0x40048916, 0xbf536185, 0x403cea75,
    0xbeeb3add, 0x3fdf3752, 0x40760f8e, 0x40aaab08,
    0x3f82ec6e, 0x3f165739, 0xbf9e5279, 0xc04d2f7c,
    0xc04279f7, 0xbfd29d4b, 0xbe327bdd, 0x3f131f9d,
    0xbf9dd32f, 0xc02b677a, 0xbf8b0498, 0xbe58675a,
    0xbeee21ff, 0xbecdd055, 0x407b09ac, 0xbfe8a45c,
    0xbe09f573, 0x3f39f1ea, 0x405195e1, 0xc01e7ee4,
    0xc0419359, 0x3eefecca, 0xc063ef93, 0xc0049e55,
    0x3ffc2ceb, 0x40334b4e, 0x3f158633, 0xbfcb5395,
    0xbe9a3e9a, 0xbfc91535, 0x3ff084de, 0xc018c6a4,
    0xc043260e, 0x3f406c52, 0x3e1c0ef4, 0x3fce5461,
    0xbfeaf8d7, 0x3f6bc3d2, 0x3dd3b4d5, 0xc03202c9,
    0x3fd17d44, 0x3f5019c4, 0x3f5f9eb0, 0xbfd46372,
    0xbf8aacbe, 0x3fdac9b1, 0x3fce9778, 0xbf7e6e35,
    0xc06f8411, 0x40129e16, 0xc0278d77, 0xc06b484c,
    0x3f384abd, 0x3fb9817e, 0x3fdfd326, 0xbfe9a0ff,
    0x3fc2887d, 0xbfa35c9e, 0xc0028599, 0xbf84a678,
    0x3f0f0b91, 0x3fea9143, 0x4033e790, 0xbf90616e,
    0x3f80e447, 0x3f4cc360, 0x3febb732, 0xbf932214,
    0xbfc8698b, 0xbe6b1930, 0x3fe609f8, 0x40935a70,
    0x3fb0f6d9, 0xbfe4a180, 0xbfe28c80, 0xbdd40146,
    0xc05de5eb, 0xbf8ec8f3, 0xbf39b36a, 0xc04d8742,
    0xbe1e2072, 0xbfab491e, 0x3f009694, 0x4061bbd9,
    0x3f34437d, 0x3fb7fca2, 0xbfb68a1d, 0xc006aba0,
    0xbf3fee55, 0xbfae91ba, 0xc023a4f4, 0x3fe82057,
    0xbe7299ee, 0x4046617f, 0x3f2f088c, 0x3e21c447,
    0x3d6c481c, 0x3f3241f9, 0x4016fa9e, 0x4080c1e8,
    0x3f9497f9, 0xc08d7c4f, 0xbf3bbbd0, 0xbf79ba80,
    0x3f42045b, 0xbf2a27b7, 0xbfbe5d66, 0xc040e55f,
    0xc07200dd, 0x401c9e52, 0xbf34759b, 0xbf174fee,
    0x402d5119, 0x3fb048ee, 0x3f2d14c6, 0xc00bb8fb,
    0x3f205689, 0xbeb92d38, 0x40084ac8, 0xc02711a6,
    0x40312621, 0x3fc961c6, 0xc04b5215, 0x407a7d99,
    0xbd10502a, 0xc0838f01, 0x3c866282, 0x4028a878,
    0x4055056b, 0x40227b07, 0x40b1d028, 0x3f93c8aa,
    0x401755ed, 0xc058d4d4, 0x40722268, 0x402779fd,
    0x3f82617b, 0x3dc23458, 0xbf149b8f, 0x3cc178f7,
    0xbf900ab4, 0x402c91a7, 0xc0689b17, 0x3f6dbbdb,
    0xbd39abe3, 0x3ff46842, 0x3fd465b1, 0x3e2f78fd,
    0xc082e896, 0x3ddcdfd4, 0xc0a38bbb, 0x400bb352,
    0xbfe2f15c, 0xc0e1e4a1, 0xbfe80aaf, 0xbe12d31d,
    0x4014d662, 0x40239a34, 0x403b116a, 0x3f7b81a2,
    0xc069ba43, 0xbfb4c299, 0x402b4b17, 0x3f493371,
    0x3fc602cb, 0xbe61f95a, 0xbfeba919, 0x3dae0fb4,
    0x400ad2bb, 0x3ec6710b, 0xbf2d42f9, 0xbf1db91c,
    0x409a0c01, 0xc03ffa11, 0xbde699c8, 0x3f8e0e31,
    0xbff36f62, 0xbfad7bde, 0x401d1a7c, 0xc037de2a,
    0x3f8a466a, 0x40141b05, 0x4022aa46, 0xbe17f7be,
    0x3f77d2c9, 0x3fd7ce9d, 0x3effa063, 0xc0476a17,
    0x3f9a51d2, 0xbfa61617, 0x4023ae9d, 0x407b9316,
    0xbe68da70, 0x3fa96a83, 0xbf1ef9f9, 0xbf74979d,
    0x3f7dd112, 0x3e66257e, 0x3ff069fe, 0xbfd05317,
    0xc00c36ed, 0x40038d75, 0xc07dc8ad, 0x409a4109,
    0x3f4f452e, 0xbf9b350b, 0x3f80e64e, 0xbfc4596f,
    0x40025cc6, 0xc02e6b67, 0xc0a83e64, 0x3f99ef98,
    0xc03aec37, 0xbf48ef6b, 0xc03771c8, 0xbd2e36bb,
    0x3ec42b15, 0xc0852c80, 0xbf269ff0, 0xbfd81477,
    0x409112d3, 0x3e3ccc61, 0xbf57c767, 0xc0701335,
    0x3eecaeec, 0x3f4d53d6, 0x3f2391dd, 0x40430a5e,
    0xbf85a5c5, 0xbed5c104, 0x3ea01922, 0x3fdd0562,
    0xc00324dc, 0x4055087f, 0x3f479c10, 0x3fea92f0,
    0xbe53c978, 0xbfef9ab0, 0xbfcf8a0b, 0xbf7dba89,
    0xbfd927fa, 0xc0753356, 0x3ecc3f9d, 0x4032e21f,
    0x3fa7e322, 0x40525d60, 0x3fff7cc7, 0x3f1d90e4,
    0xc03f1bed, 0x3fe88d78, 0x3f2fcfb4, 0x40890bc7,
    0xbea242ba, 0xbfbdec33, 0x400f18e5, 0xc0a59b10,
    0xbfbd26d8, 0xbfbb4929, 0x405f91ca, 0x407b9486,
    0xbf422c2c, 0x3ee8f031, 0x40101f4c, 0xc05b51da,
    0xbf7b2b1a, 0xc00a8295, 0x3b930012, 0x3e93ecc0,
    0xbf15d48f, 0x3fcc8906, 0x3f21d6a8, 0xbfe35f0e,
    0xbfc2ab10, 0x3f9b6f0d, 0x3d7104d2, 0xbfd20431,
    0xc03c3bdd, 0xc048ef77, 0xc011e948, 0x40553f10,
    0x3f97ba28, 0x4039eb3b, 0x3ebf14ac, 0xbf50138b,
    0xc05c74b7, 0xbe033f23, 0xbec78da2, 0xc04469d9,
    0x40bb3af0, 0x3f96395e, 0xc01df3b2, 0x3f9aae5e,
    0x4070d052, 0xbffc7df3, 0xbf100185, 0x403db3f2,
    0x40478303, 0x3fc0ee60, 0x3fd799fb, 0x403f18a7,
    0x40f1e548, 0xc058c0f4, 0xbe66a0b8, 0xbfa28069,
    0x3efcdc03, 0xbfd29464, 0x3f50d9e8, 0x3ff15d55,
    0xbfcbc9bb, 0xc007c61a, 0x40424443, 0xbebd930c,
    0x3fcb5304, 0x4013034b, 0xbffb00a7, 0x3e8b7857,
    0xbf115518, 0xbfbbd704, 0xbf80904c, 0xbe82a5df,
    0x3ffa24bc, 0x3fd11ec0, 0x3fcabd04, 0x3f918b6b,
    0x3f84bc51, 0xc0933eb9, 0x3dcb6f99, 0x3fcbfb68,
    0x3fbd7ea7, 0xbfec1d8c, 0xc02c4902, 0x400d252f,
    0x3f70f273, 0x3dd9fc9c, 0x402ed07e, 0x3fb8057f,
    0x4093dc10, 0x4000c89e, 0x3eb9d696, 0x409427fc,
    0xbfabb745, 0x3e333409, 0xbdd09b25, 0x3f3a03fc,
    0x408edec5, 0xbfbf10fc, 0xbf8f7999, 0x3eff71c3,
    0x40135379, 0xbf6c8a89, 0xbfe0a9f8, 0xc00aa5c7,
    0x40170eb6, 0xbee2e45b, 0xbf8bc3d4, 0xbe20c8dd,
    0xc03b48e0, 0xbe5a2b00, 0x3ffb5b40, 0x3f942ff6,
    0xbebbd206, 0xbf7e6c6d, 0x4001c2dc, 0x403fb5b4,
    0xc017dee2, 0xbfb3c516, 0xbfcf1c96, 0xbf25b0b9,
    0x40065ac9, 0xbfab1922, 0x3f1c3304, 0xc0370ca5,
    0xc057f27c, 0xc03ee19b, 0xc08048f8, 0x405b0a63,
    0xc00219e5, 0x406b5097, 0xbf0033c1, 0x3f313245,
    0x3f2dc442, 0xbfab222c, 0xbebaafe5, 0xbfbdc308,
    0x3ffc7048, 0x3ff8c0d8, 0xbee9ec9b, 0x3f9affc4,
    0x3ffc2bc9, 0x405b5fb3, 0x4055e464, 0xbfbe8fc4,
    0xc08a5f1d, 0xbf6a2118, 0xbfdd2e49, 0xc0c63643,
    0x4057ed12, 0xbeb47e18, 0x408c0817, 0x40410d26,
    0x3d0ca0f0, 0x4000a675, 0x3fb483a6, 0x402fe149,
    0x3c2aa5fb, 0xbf145e0b, 0x402fa6b0, 0xbf2f7024,
    0xbf14abbf, 0x3eb5356b, 0xc03e64af, 0xbf71ab90,
    0x3f5fbed4, 0xbfbf9876, 0x407d64a0, 0xbeccbe13,
    0xc00ebb28, 0x3f17fc4b, 0x3fe60d32, 0xbf21ca04,
    0x3eeab06f, 0xbf4707c9, 0xbf4c649e, 0xbf8b57df,
    0xbf54d65f, 0xc091db29, 0x40159a8f, 0x4001bdc3,
    0xbf9305c6, 0xbf496483, 0x3f75df8f, 0xc003afdc,
    0xbe342f83, 0xbf411cb3, 0xc05b0174, 0x3fd1af74,
    0x3e821120, 0x40702915, 0x407e105c, 0x3f1669f0,
    0x3f5d554e, 0xc03fa7d0, 0xbfd877fb, 0xc054f079,
    0xc0097cc5, 0x3faf6ad6, 0xc0682f8e, 0xc00dd53c,
    0x406f8220, 0x3ec213de, 0xbee604a0, 0xbf769910,
    0x40b63719, 0xbf4451df, 0xbfa7eeb3, 0xbf0d8d62,
    0x3e681043, 0xbfb627a0, 0xc03d1989, 0xbf0db368,
    0x4069d8bc, 0xbfbe6138, 0xc0677856, 0xc008da9e,
    0xc0768111, 0x3e41af33, 0xc0296d31, 0x3fca5a43,
    0x3ff7d597, 0xbf86f739, 0xbfa817a5, 0xc010406a,
    0x3fc971ea, 0x3bb043f5, 0xbdd70f4f, 0xc01623b6,
    0xbf5629d0, 0xc0184c98, 0x3fe10c50, 0xc04b7d56,
    0x3f37d653, 0x3fd69e09, 0x400e25f9, 0x40d8e5c9,
    0x3fd518a4, 0x4002e824, 0x3ed6150e, 0xbf143b67,
    0xbffef71c, 0xbffd7922, 0x3f7625f3, 0xbf015694,
    0x3fa7ac9d, 0xbfabb8ba, 0x3ea98fec, 0x40169b1a,
    0xbf4910b8, 0xbf99c501, 0xbf77c9a3, 0x40a7f327,
    0xbeedad91, 0x3e7e49a5, 0x3fade1a3, 0x3d5d0fe6,
    0x3ecb9a8b, 0x3ffa0b78, 0xbfee9ad0, 0x3f4afc8c,
    0xbeffa8ee, 0x4027dec6, 0x3f2ba198, 0x3ec1f9be,
    0x3fa8497e, 0xc025ff33, 0x3fe201ce, 0xbf8ca07a,
    0xbf8a7f32, 0xbfd3ec73, 0x3f960c65, 0x3e1798ad,
    0xbfd94673, 0x3ff6b5d0, 0xc03e6126, 0xc02bb54e,
    0x401ece13, 0x408d7e93, 0xc010592a, 0x40340c03,
    0x3f62d405, 0xc08944e6, 0xbfdf9168, 0xbf99cc0b,
    0x3bc46258, 0xc0072157, 0x3fea0520, 0x3fac7327,
    0x3f3c41af, 0x407c0153, 0xbfee4c88, 0x40239271,
    0x40f89f0d, 0x3e9b2b1a, 0x3f83ca81, 0x3eca4795,
    0xc070c176, 0xbff4191a, 0x404cc049, 0x3ff2379f,
    0x3dbe6abc, 0x3f97f721, 0x3f88519c, 0x3fd375f8,
    0x3f356a3e, 0xbf14be1e, 0x3f37eee2, 0x3feb51bf,
    0x3f3a4a3a, 0x3fe92d1f, 0xc0333beb, 0xc03d7b30,
    0xbef466b9, 0xc0713dd7, 0xbffa614a, 0x4085900a,
    0xc002822e, 0xc030775c, 0xc03fe02c, 0x3f545f8b,
    0x3e145b0a, 0xbf1c78fb, 0xc02a9c05, 0xbf884afa,
    0xc01061d2, 0xbf62894e, 0xbfedaab3, 0xc07107d4,
    0xc06ea85e, 0x402beb63, 0xbed93f9a, 0x3d817ac2,
    0xbf947949, 0x3ef68907, 0x3f59444a, 0x3e92d8d0,
    0x3f3a1de6, 0xbf4119f2, 0xc03705ac, 0xbfa14568,
    0x3fc5aa53, 0x405639a4, 0xbff7daba, 0xc02ea228,
    0xbf49a559, 0xc039d80c, 0x3e9b1de3, 0xc0105235,
    0xbfd4a932, 0xbefd9e24, 0x4051ba13, 0xbe00a46a,
    0x3dfc4812, 0x40365966, 0x3fb0d5e3, 0x40054a2d,
    0x4021a364, 0xc026a8f3, 0x3f01f5d0, 0x3edfd181,
    0xbf784e00, 0xc059a5e2, 0x400383bc, 0xc00420de,
    0x3f9de07d, 0x400eef30, 0xc0a01e60, 0x3f81eef3,
    0x40940e1c, 0xbf843641, 0xbe53fbf8, 0xbf1d22c1,
    0x401d433e, 0xc01152f9, 0x3f83995f, 0x3fc8ff97,
    0x4081ceef, 0x40df20b4, 0x3e5a3d0f, 0x3ee88666,
    0xc0013034, 0x3ffe73db, 0x409925ef, 0xc025ebfc,
    0xc03c7e15, 0xc03ba0ee, 0xbf4cef35, 0xbf9f32db,
    0x3f9b8730, 0xbe03f37a, 0xc0863709, 0x3e5a9a70,
    0x400ecf80, 0xc042c91b, 0x4042eb06, 0x3dece0b1,
    0x4087a3c3, 0x3d04c2ef, 0x3c9b5e49, 0xbf182103,
    0x3f113b8f, 0xc074d7dd, 0xc06fa9e9, 0xbfa8d87d,
    0xc0773c2e, 0x40c9c1af, 0x3efb172c, 0x3e433ceb,
    0xbe5d1ead, 0xbf911952, 0xc022ce9f, 0xbde41ffd,
    0xc02f7245, 0xbe4aba29, 0xc06581ec, 0x3fd79178,
    0xbff7f1e8, 0x4013e608, 0x40322c79, 0x3fdfdbb0,
    0x3fb64837, 0xc08345f7, 0x3e60f091, 0x3fc3efbd,
    0x3e1cade0, 0xbf6a59e6, 0xbfd67331, 0xc0268a5e,
    0xbdb76c02, 0x404d6213, 0xbfebca40, 0x4001322d,
    0x40105fcc, 0x3dbbb9a4, 0xbf168fff, 0x3ff40857,
    0xbfe510bc, 0xc06c72ff, 0x3fad8651, 0xbecc1451,
    0xbfb20d0b, 0x3ee28b52, 0xc01a1d4e, 0xbfc7528a,
    0xc083e7ea, 0xbf97cc7b, 0xc02db41f, 0x408e3ace,
    0x3c32284b, 0x402d9d20, 0xbeda2c01, 0x40695e64,
    0xbfcb24b6, 0x3f4678d4, 0x40481047, 0x40014a6f,
    0xc08db5d0, 0xc070ea9c, 0x3eda0adc, 0xbfb03006,
    0xbe32bbeb, 0xbfcaf56c, 0xc02c3dd9, 0x3e3aeb10,
    0x3fca618f, 0x4020696d, 0xbf93f1ae, 0x3f95388d,
    0x3f2e3fd8, 0x3ff1ec03, 0xc01018ab, 0xbfa9ef7d,
    0xbec36e94, 0x3fb8f78e, 0xc02aa7ad, 0xbf453109,
    0x3f5c85f6, 0x3e6c1f89, 0xbf953adf, 0x401d5a45,
    0xbebae2c9, 0x3fbca0fb, 0x3f9ce2a3, 0xc01b171c,
    0xbf998f63, 0xc0806075, 0x3fe6a1b5, 0xbf02c8bf,
    0x3e9f0d65, 0x403c6274, 0xc03a46b9, 0xbea3d370,
    0xbff0b072, 0xbf0275f0, 0xbf553ae9, 0x4000af21,
    0xbf7194bb, 0x3fc5f464, 0xbff1a0da, 0xbfdeb95a,
    0xbfaadac0, 0x400598f7, 0x3f22f793, 0xc024dff4,
    0xc01e908d, 0xc02c8834, 0xc08f2356, 0x3fcd98e6,
    0xbe52be65, 0x40993f01, 0xbf8d24fe, 0xbfa8c691,
    0xbf8fca94, 0xbfa0bb19, 0x3f558cd5, 0xbff9ec0f,
    0x3fbc50aa, 0xbf49a73b, 0x40046b80, 0xc0014275,
    0x3f392fc5, 0xbfb7a1a7, 0x40535b4a, 0x4045b32c,
    0x3f5b81da, 0x3c8be26a, 0x3fc23dac, 0xc018fb8f,
    0xbfb8ee1e, 0xbf8b64ea, 0xc034b473, 0xbf965afc,
    0x3e3db21d, 0x3fb9a913, 0xc0c2080e, 0x3fa779d2,
    0xc00b97fd, 0x3f844a4f, 0x3ff5d748, 0xbf985f7e,
    0xbfa54ba9, 0xbf952d27, 0xbf44c87e, 0x3f8742fb,
    0x3fc11d28, 0x400ae86a, 0x3f420852, 0x400550d1,
    0x3f7666d7, 0x407e10d9, 0xbfdef514, 0xbff02e94,
    0xbefb7245, 0x3fe4ae87, 0xbedaf5ad, 0x3fb9d5fb,
    0xbf1c81e3, 0x3e535ecc, 0x3f2039e9, 0x3f8677b4,
    0xbf084810, 0xbf97505c, 0xbf71c2cd, 0xbccc25fc,
    0x402c4938, 0xc0200f3d, 0x40dcc7af, 0xbd5d73b0,
    0xc02b65b5, 0xc055cab9, 0x3f7e1807, 0xbf814ccc,
    0x3fb490fa, 0xc000e4fa, 0xc01bf5dd, 0xbf793fb7,
    0x407a0f8f, 0xbf6a1203, 0xbf3cc1c6, 0xbf8c60d0,
    0xc0142c72, 0x3de321e8, 0xbf0024d9, 0xbfd8e1c3,
    0xc04f3936, 0x405be84b, 0xbf2b003c, 0xbf3bfa08,
    0x3ead703c, 0x3f620efe, 0x3f9b4a4f, 0x3fae52d9,
    0x40996a56, 0x40282169, 0xbf1b9715, 0xbd9e196a,
    0x3e9030e8, 0xbfb009ee, 0x3e233152, 0x3ed44577,
    0xbf4ba9b3, 0xbe2c0626, 0xbff0b409, 0xbf9e9b84,
    0xbf997e15, 0xc0176ed5, 0x40039307, 0xbf1fde3e,
    0xbdc716d3, 0xbfbb3532, 0x40377b05, 0xbe2a032a,
    0x4001ae24, 0x408ca9e6, 0xc059fd98, 0xbfdd8ac7,
    0xc08536fc, 0xc04d6b20, 0x40b79bde, 0xbf1ecb52,
    0xc08f02c6, 0x3f05e9f7, 0xbf795b80, 0x401e9da9,
    0xc0181f08, 0xc00fc724, 0x4084e8c0, 0x3f051274,
    0xbe6a7ae2, 0x3ffba088, 0x405da616, 0xc002eb82,
    0x3a03e6a7, 0xbfe8c232, 0x3f8e368d, 0x3d8f9658,
    0x3ed7be1e, 0x3e1b2445, 0x3f8e61a7, 0x3ffa820d,
    0x407c72d8, 0xc0275bb5, 0x4012b659, 0xc0283cf3,
    0x3fb3fd04, 0xc085cd5e, 0xbf2a6a83, 0x402870ea,
    0x3f670a05, 0x4026e86b, 0x4084eb49, 0xbf0f362c,
    0x40946c88, 0x3d0dbcaf, 0x3fdb5863, 0x40292f2b,
    0x4028a915, 0x3f215d69, 0xbff4a725, 0xc0f42dbd,
    0xbe92a005, 0xbf13dc55, 0xc0d2554c, 0xc05d5155,
    0xbefe83dc, 0xc04a4875, 0xbffd7d1f, 0x4088d10d,
    0xbdd3e86d, 0xc05f9306, 0xbe0dd6bc, 0xc066c9fc,
    0xc01c6c35, 0x3f86d6dc, 0x3fccba10, 0x3fd36d11,
    0x3f68cf6b, 0xbfc21170, 0xbee2c5e2, 0xbf4f1886,
    0xc05a5f16, 0x409240a6, 0xc07ccce0, 0xbf73a793,
    0x40b8e89c, 0xbb489358, 0x4037eb5c, 0x3eccba9f,
    0x3ffe8d80, 0x3ef3b0f8, 0xc085ad90, 0x40603610,
    0xc01591e6, 0x3f41c2bc, 0x4024d8d8, 0x40061a79,
    0xbf7f7de0, 0x3efe5413, 0x40902699, 0xbff34310,
    0xc02b6a97, 0x4075f7bd, 0x3f2ee9d7, 0xbf5aec42,
    0x40b5d74a, 0xbf73be1d, 0x4013e9c2, 0x4083d213,
    0x3df8de66, 0x3f54e63a, 0x3ff08dc8, 0xbfe32042,
    0x400bce6a, 0x3fdb6068, 0x4066dfad, 0xc00cc841,
    0x3fd34600, 0xbfbe48ad, 0xbf8a1a4d, 0xbf996b35,
    0xc0069772, 0xc007269a, 0xbf5ce1a0, 0x3f93fd0d,
    0xbfbf8b0e, 0xbf5caae1, 0xc06af9b2, 0xc052f641,
    0xbf0434c4, 0x3e6eee3c, 0xbe3d6716, 0x3f7db6d0,
    0x3fe0d2dc, 0xc015222e, 0x40938233, 0x401c23a6,
    0x4063dbd4, 0x4028da80, 0xc0012e02, 0xbfaa6be8,
    0x3db4e9de, 0x3ec4ebdb, 0xbf96976a, 0xbc6672f1,
    0x400380dc, 0x40091571, 0xbf15ccff, 0x403d33fd,
    0x3f71b241, 0xbf00c176, 0x408116e3, 0x3ffe141c,
    0x404bbcb4, 0xbcbb217c, 0x3f333102, 0x3fea947d,
    0xbf899acf, 0xbf8af2e9, 0xc07d5e9c, 0xbfef8d7c,
    0x3ebef07c, 0x3df1992e, 0xbf4432b0, 0xbfba34cf,
    0xc06d09cc, 0x402ddc91, 0xc04be71a, 0x3f8ecc45,
    0xbd04cc0f, 0x3ffa40d8, 0x3f91bf02, 0xc06178ee,
    0xbfaa8818, 0xbf837943, 0x4070e5db, 0x3f826f41,
    0x408047ad, 0x4012b2e3, 0x3fa66545, 0xbffe71a8,
    0xbfc38abb, 0x3f73d27c, 0x3e9ad015, 0x4029ee4a,
    0x3fd99ebd, 0x3e9dad45, 0xbf85575b, 0xbebca624,
    0xbfb75e19, 0x3fcc52e4, 0xc0143026, 0x3fd508b7,
    0xbfab122e, 0x4087730f, 0x40398ad0, 0xbf888d69,
    0xbf0f6e35, 0xbf972b61, 0x3e836078, 0x3c96bb12,
    0x40c31f71, 0x3f4b9aa1, 0xbf784b9e, 0x4072c451,
    0xbea92195, 0xc0267786, 0xbf05aca2, 0xbf998d31,
    0xbf6bbe99, 0xbfa80325, 0x3f723ea4, 0x3e826fbb,
    0x3d9435d8, 0x3fd64cef, 0xc008e383, 0x400bea30,
    0xbe9220b7, 0x3f9c0a6d, 0xc0206248, 0xbfac6e9f,
    0xbe76ab6e, 0xbf2829f3, 0x3fb9a07d, 0x3f9c5c4d,
    0x400b005f, 0x40429a85, 0x3e8c463e, 0x407317cb,
    0xbe8962c2, 0x3f6b5eae, 0x3fa63e83, 0x3d91f67b,
    0x3e1e8b4d, 0xbfe48766, 0xbed45a90, 0xbf5a69c7,
    0x402a8137, 0xbfd50eb1, 0xc002b0c4, 0x3f9ead8e,
    0x3a1d4a90, 0x3f216b09, 0xc0085c63, 0xc0aeaec2,
    0xc05e3042, 0x3dfea28a, 0x3f38ee6f, 0xc063a0b2,
    0xbf590278, 0xc0851865, 0xc03bdf9d, 0x3ff3e975,
    0x407bcc0a, 0xbd026421, 0x3feab86d, 0x3bd0694b,
    0x3e71a95d, 0xc004920f, 0x3e8de8ec, 0xbe943aca,
    0xbfcc6639, 0x39cc25e6, 0xc03d2585, 0x3ebea36c,
    0x3f1f3e06, 0xbf516f1f, 0x4028a32e, 0x3f7e046d,
    0xbeb57dc9, 0x3fc2f999, 0x40af91fa, 0x3fc058b3,
    0xc006d8aa, 0xbf2055e0, 0xbfab39b4, 0xbfcf6fcf,
    0xbdd744e0, 0xbf89a705, 0xc032e1e6, 0x3e54591d,
    0x3ff55434, 0xc001a142, 0x3f12a9e3, 0xc040cee8,
    0xbf771128, 0xbfc3461d, 0x4086e9fa, 0xbf22a1b7,
    0xbfbf30b6, 0xbfa8f514, 0x400fabc9, 0xbfd1c174,
    0xbf2b81ed, 0x4082a51d, 0xbfe360eb, 0xbf19c2b3,
    0x3f6babd8, 0xbff1d860, 0xbef3df9d, 0xc0682885,
    0x3e10eed8, 0xbf6d73fd, 0x3fc4566d, 0x4052f0f5,
    0x3f7a146e, 0x407eda76, 0x3f3556f3, 0x3fc483cc,
    0xbe0b5477, 0x408d7eef, 0x4072e18c, 0xbf39fcc1,
    0x3f4108c3, 0x3f9a53ca, 0x402f554c, 0xbeaabfa5,
    0x40221199, 0x3fe78e7f, 0x3fcb887a, 0xbffabf19,
    0x3ea85396, 0x40948927, 0xc04f31c9, 0x3f4092d3,
    0x3fbac73c, 0x402268c1, 0x3fd982c7, 0x3f7ed1b1,
    0x3f2b610a, 0x402f495f, 0x401a87bf, 0xbec50537,
    0xbe843047, 0xbf93b42f, 0x3deab844, 0xbf151e31,
    0xc02089a6, 0x4021cb7d, 0xbf8fdd01, 0x3fbfc27e,
    0xc04958d7, 0xbffdc498, 0xbf843df4, 0xc03196c3,
    0xbfabe53d, 0x406dfeb2, 0xc04ce374, 0xc01f9307,
    0x400787d0, 0xbf873871, 0x3f8293b1, 0xbef660fc,
    0xbf4dce54, 0xc047bd58, 0xc024022d, 0xbf4135e6,
    0xbf57d3e5, 0x404a5148, 0xc08d39da, 0x3fbcb740,
    0xbf82bd8f, 0x3ebc043c, 0x40a9eca1, 0x3f197b81,
    0xbf1b9cce, 0xbfdd24a0, 0xc032043d, 0x407a53d4,
    0xbd54912e, 0xbf86d2fe, 0x3d989ae1, 0xbf440800,
    0xc02b75b6, 0xc067bedd, 0xc00ec78b, 0x3e50fd77,
    0x3eac7162, 0x408b8c20, 0xbf256351, 0x3fb75094,
    0xbf91b63b, 0x3fcb1621, 0x3e2f6b95, 0xc0160f2f,
    0x3c0ed05a, 0xbea6dc67, 0xc014a42a, 0xbfa8b5fa,
    0xbf6d23c4, 0x40097f70, 0xc027f366, 0x3f187a94,
    0xbfa073aa, 0xbf473d80, 0xbf1af1e5, 0xbfbdea6e,
    0xbf3e874d, 0x3ea8e75c, 0xbea61940, 0x40492324,
    0xbe9c17e4, 0x3d89cbc3, 0xbfd4352b, 0xbf362406,
    0xc07989ec, 0x406fbbd0, 0xbfe717d8, 0xc08e7fe5,
    0x3ee8d9a5, 0xbfd8e926, 0x3bfe51f0, 0x403b413a,
    0x403c3d12, 0xbf86c315, 0x3eb5625a, 0xbfcb9c16,
    0xbf458dd6, 0xbe2381be, 0x3ed4b6e9, 0xc072ace7,
    0xc04c6027, 0x3fbcab04, 0xbf907755, 0x3fa3cec3,
    0xbfbfd894, 0xc0a77b74, 0x3f978e4c, 0x3fd262de,
    0x3f95c2c9, 0xbf7a8ff4, 0xbfada8ac, 0x400ee8fa,
    0xc0340134, 0x3d3089c9, 0xc06e86fd, 0xbebcb76c,
    0xbfc39a58, 0x3f040750, 0x3f74a1c6, 0xc0264664,
    0xbdb44ef7, 0x400e0c2c, 0x3f17ea46, 0x40014773,
    0xc0285ce6, 0xbdb72b74, 0x3fcb29f2, 0x3f6a866a,
    0xbf834284, 0xbf8cbfcd, 0xbffa43ca, 0x3fa3d0f0,
    0xc0954877, 0xbfe378d3, 0xbe1bcde2, 0x40032995,
    0xbec060ed, 0xc00c3ff9, 0xc02a2039, 0x3f901c93,
    0x3f523ba8, 0x40479c16, 0x407919d5, 0xc0407085,
    0x3fb04af7, 0x40000b5e, 0x4085997e, 0x408f3630,
    0xbf0e1e66, 0x400b54da, 0x3fd4c3cc, 0x40b4fe76,
    0x405f1e1d, 0x3fd81fb7, 0x3fe9d790, 0xc018adde,
    0xc01a74e8, 0xbf4d00a2, 0x401e4597, 0x403558c6,
    0xc038fa7c, 0x3eeea68f, 0xbf412fc8, 0xbf8d7c6e,
    0x3f633d32, 0x3f2b85fc, 0x40027fe3, 0xc08539a5,
    0x3fac8aa1, 0xbfe7c62f, 0x3e719295, 0x4005306a,
    0xc01f49d8, 0x3f91ca18, 0x3e8cd8b4, 0x408da4e2,
    0x3d4f1a5b, 0xc033dbda, 0x3fed26fd, 0xc034f6ee,
    0xbf60b39e, 0xbf3bcbbf, 0xbc31a81d, 0xc00ded23,
    0xc09c2d7c, 0x3f94bf06, 0xc0390477, 0xbf2ca624,
    0x3f8b107d, 0xbfed3eba, 0xc04ee823, 0x3f1fbf04,
    0x3ecb32c2, 0x3f991d5b, 0x402bd69c, 0x4031324e,
    0x3f652a5e, 0x400ce541, 0x40b20b75, 0xbf9b4c85,
    0x3f08c2b5, 0x3f99aa06, 0x40642f70, 0xbed70881,
    0x3f409bc8, 0x3f11fcf7, 0x40319405, 0x401199fd,
    0xc05a5512, 0xc032a8c7, 0x3f2481d7, 0xbfe63120,
    0xbfcb5d0f, 0xc054c9b0, 0xbfe10885, 0xc00ba52c,
    0x40825ec4, 0xbff21ed5, 0x3fa04c0e, 0x4018a45b,
    0x3ff152f4, 0xc056f77b, 0x3f84fa21, 0xbf36d4c5,
    0xc0036ea3, 0xbf35c237, 0x400c4df4, 0xbe578263,
    0x3ffa989b, 0x408e1899, 0xc0324895, 0x3ef222f9,
    0x3f9681b7, 0xbf46e8a6, 0xbf163960, 0xbdb98c0b,
    0xbf72b6fe, 0x3ffa1ec8, 0xbffd35bb, 0xbfd05797,
    0x3fe74312, 0xc0045818, 0xc01251a4, 0x4032e947,
    0x3f9aa786, 0xc00489d8, 0xbeb655f4, 0xc02aab8d,
    0x401a8b69, 0x3f6bce9d, 0xbddacfdb, 0xc08acfe6,
    0xbdf302fa, 0xbfa84569, 0xc084b7f6, 0xbfd533e8,
    0xc0137a46, 0xbfe5433c, 0xbfa760b0, 0x4054fa28,
    0xc015fc52, 0x3f9ae720, 0xbfcd52ad, 0x40225c6a,
    0x4015772d, 0xc033888a, 0xbf4ec3eb, 0x40273b0f,
    0x3f610f3c, 0x4047d985, 0xc057485c, 0xbfa2127a,
    0x3f5f8776, 0x401b985d, 0xc04cfe43, 0x405bd588,
    0xc010d2a7, 0xbdb29d63, 0x3f71c0bd, 0x3dcd8936,
    0xbec345e5, 0x40165a58, 0x3f632196, 0x3f2823b0,
    0x4058298a, 0x3e704f43, 0xc04b631d, 0x401a7d9b,
    0x40008b51, 0xc021b4a4, 0x3f33f14e, 0x407b0f07,
    0x3ef49bc2, 0x3f6fadf2, 0xbfe8d01e, 0x3ea1368c,
    0x3f16bd6b, 0xbfa8214c, 0xbf9cbdcb, 0x40685116,
    0xc0711ae4, 0xc01c1f17, 0x3f4ff601, 0x3e7b47df,
    0x3f260c2b, 0xc05a991e, 0xbf9a36cc, 0xbf6b306b,
    0xc0322a18, 0xc00f8530, 0xc02e2781, 0x3feea86a,
    0x402ab5e3, 0xbf305831, 0x3e95fa9e, 0xc03e78b9,
    0x3ff1594b, 0x3f426d14, 0x408c7756, 0xbf4c1729,
    0xbe948f75, 0x3f7cd9c9, 0xc0a78ced, 0xbfca7253,
    0x401a3b07, 0xc02745b6, 0x3f9a2f83, 0x3ff1dde3,
    0xbe922373, 0x40278781, 0xc007303d, 0xc08d2faa,
    0xbec1a5c3, 0x3f129df2, 0x40a3e3fd, 0x407ada76,
    0x40437b57, 0xbfc18640, 0xc0930804, 0xc019da5b,
    0x3fc801d8, 0x3f310fef, 0x400c17ad, 0x3fff3dd5,
    0x3ecf64be, 0x408d906a, 0x4033c997, 0x4063c08b,
    0x3feef5ca, 0xc00f8c63, 0xc04df3d5, 0x400eec87,
    0x405cc6d4, 0xc044dd03, 0xc095396a, 0x3fed4f6f,
    0xbdafffde, 0xbf2359e4, 0x3f24e4bd, 0x401820a8,
    0x3ed7402a, 0x3feae0f0, 0xbfe5674f, 0xbf70e02f,
    0xc09d7e03, 0xbf899f1b, 0x3fb93c53, 0x3f0033a1,
    0x3d57e102, 0xbd00403f, 0xbf7023e4, 0xc001444c,
    0x408e7c5e, 0xc0205314, 0x3da07e63, 0xbf77914d,
    0x3fd91e62, 0xbe976e08, 0x3faafba0, 0x3fb8318a,
    0xbfeecadc, 0xbf85fc33, 0xbf9afffc, 0xbf8695b0,
    0xbe3cc4db, 0xbe1c14a8, 0xbf3b83b8, 0x3d00611b,
    0x3f0e4248, 0xbf924fd8, 0x3e8552f9, 0x4058f502,
    0xbf234057, 0xc0483fca, 0xbd297dfa, 0x403ce727,
    0x3f3c0724, 0x40167cc4, 0xbf1255f0, 0xc0317f35,
    0x40b76e9e, 0x3f009727, 0x3f8ff09d, 0xbfd228ec,
    0xc003950f, 0x3f62d804, 0xbf1f4459, 0xbfc0fc53,
    0xbfa74014, 0xbf8e763d, 0xbf825035, 0xbff4400e,
    0x3f4a0ac8, 0x3fca4fc8, 0xc02f0949, 0x3e740a12,
    0xbfd693a7, 0xc0620ac8, 0x401fea5e, 0xbe426ba8,
    0xbf211da8, 0x3fa3b418, 0x3f00642a, 0xbee5eda3,
    0xbead61d8, 0x3fc3337c, 0xbe935f0f, 0x3e72eddb,
    0x3f876d56, 0x4020ca20, 0xc01359ec, 0x3e867fd2,
    0xc04d7019, 0x3e7baf5e, 0x3f0ae256, 0x3f0ea8cb,
    0x3fea7af2, 0x3f0baa65, 0x4011ce3b, 0xc047b2b2,
    0xc0204f8d, 0xbf742eb4, 0x3ffa895a, 0xc09456c6,
    0x3fd68c6a, 0x3fa05556, 0xbfa6280f, 0xc092f514,
    0xbd99d9bb, 0xbfe1a5f0, 0xc073c9d2, 0xc030f4f8,
    0x3f61dd63, 0xc0e9a7a1, 0x3f7042cb, 0x405b67de,
    0x40679bac, 0x3ef375a7, 0xc00addc0, 0x3ea47085,
    0x3fc96628, 0xc0395820, 0xc0251cb6, 0x3f7db6a0,
    0x3fe5b017, 0x3fed96c7, 0x400292f9, 0xc09de68b,
    0xc00bdad7, 0x3e7c2b62, 0x3fa3380c, 0x3dccc1fc,
    0xbf7188fd, 0x3fa1612f, 0xc0aa23d0, 0xc06d26ba,
    0xc0b54397, 0x4009868c, 0x3f6229ad, 0x3e2ff2f3,
    0xbead8764, 0x3e84cdf0, 0x3facdb38, 0x3f625e69,
    0x406905ae, 0xc0159c99, 0xc0b491ca, 0xc0104480,
    0xbfc7c6d5, 0xc0180a21, 0x404b1519, 0xc087647a,
    0xc009414e, 0x4026ed58, 0xbe04bcac, 0x4044c97b,
    0xc01beec5, 0x4005a373, 0x3e288357, 0xbeb3d563,
    0x3ef44ff2, 0x3f9c4d84, 0xc09ff609, 0x3cd1a088,
    0x3f066839, 0xc043077d, 0x403e1c97, 0xc04161f0,
    0x3fa85f4b, 0x3f115456, 0xc0397636, 0x3ef2e117,
    0x3f9d38c4, 0xbec3578e, 0x4026b14f, 0xbda08750,
    0x3fe7a6af, 0x402369e8, 0xbfa16d9b, 0x3f730d48,
    0x40764e63, 0xbfc2cb86, 0x40209425, 0x4000bb3d,
    0xbfb5c10b, 0x3fc5c71f, 0xbf9fe6fc, 0xbb2d9bfe,
    0xbfd99c6e, 0x40192b72, 0xbefc4eac, 0xc0cdc76b,
    0xbf55bd0f, 0xc0076a3b, 0xbfd1753f, 0x400ede6d,
    0xc059c031, 0x3de1a827, 0xbf8be779, 0x4017ca84,
    0x3f2c928e, 0xc088e77f, 0xbe35cbbe, 0x400906a6,
    0xc01cdb38, 0xbee76dfd, 0xc00ccdac, 0xbf9d95a9,
    0xbf0675d5, 0xbeda59c2, 0xbf9debcc, 0x40ca4146,
    0xbf9b2ed6, 0x408a66a0, 0xc0078f19, 0xbf8a7755,
    0xbffbb79b, 0x40981643, 0x3f2f7dfe, 0xc04be464,
    0x3e07f4f0, 0x3ea1cb3e, 0x4052aa21, 0xbf3b0cad,
    0x3d7eaafd, 0xbff35983, 0x402c1fb9, 0xc0a432e2,
    0x4042a051, 0xbe5506ff, 0xc03f860f, 0x3dd81c97,
    0xbdca3eed, 0x3f55a215, 0xc0263881, 0xbecc789e,
    0xbf4fdadf, 0x3d8f0624, 0xbf81da89, 0xc01924ce,
    0x3f5d5200, 0x3e2df88c, 0xc018174b, 0xc02be0e9,
    0x3fc757e8, 0xc0947321, 0xbf93a61c, 0x3fcf394f,
    0x3f553ebd, 0x403b5c41, 0xc0146c79, 0x3f2d6227,
    0xbec1f81b, 0x3e574545, 0xbfce65ba, 0xc07277b4,
    0xbfdb52f6, 0x4065d259, 0x3f1b7164, 0x3ef0ffb2,
    0xbfd0e053, 0x3f89f77a, 0xc01b278c, 0xbdd08856,
    0xbf0a45f1, 0xc06e8b4a, 0xbf11b9b1, 0x408c6fb9,
    0x3fdb5695, 0xc008cae0, 0xc0407b9e, 0x40124e56,
    0xbe662a3a, 0x3e24de2e, 0xbf668f65, 0x40458440,
    0xbf7bf2db, 0xbffbd00c, 0xc048e73f, 0x3fd176ba,
    0x405bb741, 0xc02a488a, 0x3f7b0f9c, 0x4098475a,
    0xc0b31d64, 0xc055cb52, 0xbf1703cb, 0x3f92e9c4,
    0xbfc664cb, 0xc09990b9, 0x3ee148ec, 0xc08a11d9,
    0xbe204b76, 0x3fa9cf4a, 0xbff34ce4, 0xbe814fdb,
    0x3e6cb846, 0x400e1571, 0x3fb16203, 0x3f3a24fc,
    0xbd26b16a, 0xc01a86c6, 0x3f1e4377, 0x3e4a5327,
    0xc035f43e, 0xbfca586c, 0x4010534e, 0x402d6d4a,
    0x3eb2b254, 0x40239452, 0xc08cd619, 0x403c818b,
    0x3f814386, 0x3e213cc5, 0x3f550325, 0x3fd8fdde,
    0xbe2083bf, 0xbf448367, 0xbf9af01d, 0x408c7c19,
    0x3fd9b185, 0x3eaf8419, 0x3e955857, 0xbf23f00b,
    0xc047ba3b, 0x3fcacf89, 0xc033fca8, 0x405b3469,
    0xc05eadeb, 0x3f32ecfe, 0x3fa48ab3, 0xbf0f8a8e,
    0xbf9d49cd, 0xbd8e0ef0, 0xbe42741d, 0x40492b38,
    0x40929c74, 0xbbb72b82, 0xbf0282a1, 0x3f9643e4,
    0x3f594fd2, 0xbff8a361, 0x3fee8ef2, 0xbff36c15,
    0x407df677, 0xbead5149, 0xbf5e865c, 0x3f8d3b88,
    0xbf90f3b9, 0xbed2b9cb, 0xbffa410f, 0x3fa2fa14,
    0x40831c26, 0x3f8e4990, 0xbf5e4c49, 0xbfc9ddfb,
    0xc0178195, 0xbf63019d, 0xc01b0bc9, 0x403b7a80,
    0xbd86cb8d, 0x3f87497e, 0x3fb60c5a, 0x3f450711,
    0x3fb3632d, 0x3fabc305, 0xbf92f6e5, 0x3e58e9eb,
    0x405ac17e, 0xbfa5c0da, 0x3e9ea182, 0xbf2ce64a,
    0xc0118a7b, 0x3dfc83b8, 0x3eccc644, 0xbf65fb59,
    0xbf7abefd, 0x3f2d9166, 0x400d191f, 0x3eb40338,
    0xc03d2067, 0xbff04710, 0x3df672da, 0x3f9b20ea,
    0xbf0d5dff, 0xbf9f44b8, 0x3fab3318, 0xbfeac7a4,
    0xbf8d9223, 0x3eb02b12, 0x402f7124, 0x402870d3,
    0xbfd0de84, 0x407131fc, 0xbfb32e32, 0x3fa63abf,
    0x3fc7f511, 0x405425ae, 0xc00c1d02, 0x3fef561f,
    0xc0349398, 0xbfec8d3a, 0xbfcce61d, 0x3fc31937,
    0x3f7cd7ee, 0xbff1a9a8, 0x40341716, 0x401b4377,
    0xc0334d3b, 0x4085f8b5, 0x3f0073bb, 0xbcc3c150,
    0xbf4d97ba, 0x404bb7cb, 0xbed3abd7, 0xc094a05d,
    0xc01daf1e, 0x3f856656, 0xbd65fe0c, 0x3ef07f02,
    0xbfd92958, 0xbf7445c9, 0x3f083ada, 0x3fa4774e,
    0x4029699f, 0xbf131365, 0x3efc4c98, 0xc01ed5f4,
    0x3f166d42, 0xc0199416, 0xbf5ede52, 0xbf8c394e,
    0x40044494, 0xbfc4264b, 0x402d6b8a, 0xbf7e84b8,
    0xbfd8887a, 0xc002acbc, 0xbfa265fc, 0xbf706c6e,
    0xbf7bcd9d, 0x3fd5fc8f, 0x3ff60187, 0x3e86cdba,
    0x3fbb04cc, 0x3fdfc2a3, 0x4047cd0f, 0x4025fe80,
    0x3f809835, 0x40258e06, 0xc0747e6f, 0x404031d4,
    0xbf52d444, 0xbf46c913, 0x400b6d6c, 0x401e5cc0,
    0xbed476a3, 0x3fb6dc90, 0xbf0ca0d5, 0xbf5e00ad,
    0x4025c22d, 0x40649616, 0xbf0eebcd, 0xbde0ed29,
    0xbe279d04, 0x3fdfadaa, 0x3f61debb, 0x3f699ce0,
    0xbf9a5bb7, 0xbfaa9285, 0xc0aa7386, 0xc02124ca,
    0x40252577, 0xbf2e3af2, 0xc08aefc3, 0x3f30893a,
    0xbf8308ea, 0xbfbd1c19, 0xc017e4a0, 0x3f732048,
    0xbf02c9ee, 0x4056dec5, 0xc052c087, 0xbf55da02,
    0x3f8534b3, 0x407c8101, 0xbe9e4c52, 0x3f6d3a1a,
    0x3fc807c9, 0x3f0a1d50, 0x3fedb165, 0x40701817,
    0xbf6ccec0, 0x401ded4e, 0xc041afec, 0x40197e0c,
    0xbff27a88, 0x3e858b1a, 0x3f5112e9, 0xc06fbb1d,
    0xc07be350, 0x40630423, 0xbf382058, 0x40af6680,
    0xbf6aa638, 0x401d61af, 0x3e9c19fd, 0x3f66fa5b,
    0x40345996, 0x3f4c55b7, 0x3f8fda48, 0xbe48786e,
    0x4013cdf9, 0x3f8a5a2a, 0xbf6d65fa, 0x40a9cc5c,
    0xc01145ce, 0xbeff7ff8, 0xbfd33dc7, 0xbd39651a,
    0x4089b350, 0x4045504d, 0xc001317b, 0xc0789f4c,
    0xbfcf0d46, 0x3ffcc643, 0xbfab94a0, 0x3fc150e5,
    0xbf01c961, 0xc0ab148b, 0x409b4f0a, 0x3e4ccd30,
    0xc01cda3e, 0xbf6c1416, 0xbd946126, 0x3f6d6281,
    0x40119c09, 0xbfabfc1d, 0x4006ddce, 0x3feb7201,
    0x4032f3a8, 0xbee6aae4, 0x3f2e5362, 0x3f277b32,
    0x3f390e29, 0xc02216d9, 0xbf06ef68, 0xc01f5d30,
    0x40c4e1d3, 0xbf46e778, 0x4047cde1, 0x3fdca6be,
    0xc00770be, 0x3ced9e01, 0x3f848546, 0xbd8555a2,
    0x3f0d52f4, 0x4076bc90, 0xc03ced90, 0xbfaf136d,
    0x3fa25bd4, 0xc09463a0, 0xc01cfc1a, 0xbffa4f53,
    0xbf39a2c8, 0xbd4dbfbb, 0xbfa602ad, 0x3e88ebf5,
    0xbf839bd0, 0x3f9592c8, 0x403e2913, 0xc076ec7a,
    0xc00ab56e, 0x4071f5a3, 0xc0124c96, 0x40a26ea8,
    0xbf6ccd7b, 0xc0584e98, 0xbf34cdd5, 0xc049cb96,
    0xc0179199, 0xc003a744, 0x3dae2346, 0xc01780cb,
    0xc08d1985, 0xbfe1108a, 0x3e916218, 0xbfc47c5e,
    0xc059e6a7, 0xc011cd0a, 0x3ff9f36a, 0x4042dc64,
    0xbfff590a, 0x3e5384ea, 0x4084e76f, 0x3f31c633,
    0xbefe172a, 0xbf7c9501, 0xbf87891c, 0x3fbca53b,
    0x40b13284, 0x3e622f61, 0x40079d0b, 0xbf4ffaae,
    0xbf43fab0, 0xc016d98d, 0x3e0c9ec1, 0xc03c423c,
    0xbfcc992c, 0xbea59a7b, 0xc008dbec, 0xc0b5d891,
    0xc0da949a, 0xbf024661, 0x408b34c8, 0x4032e398,
    0xbf921c3c, 0xc02d5203, 0x3fffeca3, 0xc054478b,
    0x403f2486, 0xbfec1041, 0x3f9b871b, 0x3f015faf,
    0xc098f8e4, 0xbf28dd13, 0xbd21c7e6, 0xbfccf8d4,
    0x3f80c981, 0xc01a7484, 0xc0003aa9, 0x3f0f276c,
    0xc09b6b25, 0xbf7f5d14, 0x3f21a86a, 0xbfb5c60d,
    0x401145b1, 0x40347872, 0x406cd320, 0x3f9f519f,
    0x40b0573c, 0xbfa7858a, 0xbfad14df, 0x40594a6a,
    0xc05b3464, 0x3f80681c, 0xc0157dbd, 0xbf1dc9c5,
    0x3f76611e, 0x401d31ce, 0x40866e93, 0xbfc1f316,
    0x3d1757cf, 0xbe9a67d3, 0x3db31cab, 0xbf71b395,
    0xc00b1c2f, 0xc02e1ba8, 0xc00e3c7d, 0x400918fc,
    0x3ed53e2e, 0xbfecefdf, 0xbfbd7622, 0xbfdbd38b,
    0xbef58296, 0xc040f430, 0xc069b8c8, 0x3f5025ce,
    0x402b115a, 0x403962af, 0xbf946d3a, 0xc0312849,
    0x409c2329, 0x3f2862b9, 0x4013d3bd, 0x40053087,
    0x404c3516, 0xc019f18b, 0xc08903e3, 0xbf9e6203,
    0xbf9a0f7f, 0x3eb29a91, 0xbf685ec8, 0xbf49a557,
    0xbf6b695f, 0xc02d7484, 0xc027980d, 0x4088471b,
    0xbfdcde60, 0xbfb2525f, 0xbfbe4e73, 0x3f7ab8a7,
    0x40022d4b, 0xc02b8f15, 0x3ea21d4d, 0x40957c26,
    0xbe124696, 0x3f9e1936, 0xc056770b, 0xbfb02f18,
    0x4027ba65, 0xbf64acab, 0x3bd943da, 0xbf83bf46,
    0xc055b1c3, 0xbfa984df, 0x3e19eb89, 0x3ff2876f,
    0x3f204d0c, 0xc011a5aa, 0x40084217, 0x4026be9f,
    0xbf3b3462, 0x3fd6f11d, 0xbfc8f20a, 0xc00be08d,
    0x3f3bc68d, 0xc01dab3f, 0xc071dbdc, 0xbef3878a,
    0xbfafbae2, 0x3e3c372d, 0xbf4af429, 0xbf34821c,
    0xbe80560a, 0x3f2df3a9, 0xc06e2172, 0x3eedd6ed,
    0x3d0b7ff7, 0xc021372f, 0x4073c150, 0xc08146b5,
    0x3f2c0c12, 0x3e9c26d3, 0xc00d816b, 0xbef0acc0,
    0x3f7987c2, 0xc00d7b77, 0xc0c290ff, 0x4080a6f1,
    0xc00c3851, 0x3e92d8b4, 0xbf06fce7, 0xbff85ea0,
    0xbf734137, 0xbd812f00, 0x40958126, 0xbfa9b782,
    0xbe24fe5b, 0x3fd42631, 0x3df938da, 0x3fd70536,
    0xbe63efaa, 0xbf26d404, 0xbfc9420b, 0x4011f2e3,
    0x3f17b021, 0x3fc4310c, 0x3f61e528, 0xc08ae0f3,
    0xc0154e62, 0xbe83e3e3, 0x3f5d5f9e, 0x3fbefbbd,
    0x3f03ec81, 0xbc05d1a1, 0xc0195abf, 0xbe2d38a8,
    0x4053640e, 0xbfc151a9, 0xbe0dcb16, 0x3f78fc64,
    0xc05a113e, 0xbf1fa8a3, 0x40379547, 0xc0270d99,
    0x4096bf55, 0xbfe31e46, 0x40404e6a, 0xbfc475fc,
    0x3f83ff4a, 0xbf48baf4, 0xc010e3e1, 0xbf8b686a,
    0xbfd8c10f, 0x4003a4de, 0xbfb9bd7f, 0xc04ed784,
    0xc03fc751, 0x409620c0, 0x3fab8c9d, 0xbfec01aa,
    0xbf7dc87c, 0xbf22212e, 0xbc265bc7, 0xbee426f2,
    0x40422fd0, 0x3f71745c, 0x404ac121, 0xbf1dc1d4,
    0xbf8c8616, 0xbf750d15, 0xc02abf7c, 0x4073e73c,
    0x400a511c, 0x4001ba69, 0xbf94f31f, 0xbf6996b8,
    0x4091fb4b, 0x405c3f45, 0xbe73029a, 0xbf438543,
    0x3fffff31, 0x3f9cafb2, 0x3fcb842a, 0xbdd9cd59,
    0x3f13f851, 0xbec0c5fd, 0x3f77f354, 0xc067150b,
    0xbf1d1ab5, 0xc0061468, 0x40625b33, 0x40599dda,
    0x4046867d, 0xbfebd723, 0x3f86bca1, 0x400d4193,
    0x4048bbad, 0x3fbb7485, 0x4092505b, 0xbf7a9734,
    0xbf452ea4, 0xc070c77a, 0xc09091d6, 0xbf385e11,
    0x3f219c27, 0x40895bdf, 0x3e305ae1, 0x40008670,
    0xbf1625e3, 0xbf914bf5, 0xbfdc15a8, 0xc02437dd,
    0xc016d360, 0x3f89e1b7, 0x3e79950d, 0x400e13bc,
    0x3fc55870, 0x40836196, 0xc02bd4b5, 0x40d4af98,
    0x3fc3a4d4, 0xc0a2f332, 0xc0479727, 0xc05a05fa,
    0xc033b2f8, 0x40622181, 0x401828bb, 0x406ac8c2,
    0xc071868b, 0xbf9e2e5b, 0xbfba32c9, 0xc07bd6fc,
    0xbfe9f899, 0xbf3811cb, 0xbeebf279, 0x3fc50413,
    0xc010dfdb, 0x4007b7c0, 0xbe9235c4, 0x3f5760c6,
    0x40a78296, 0x40190789, 0xc01deac1, 0xc0292a72,
    0xc018fe51, 0x3f8734b7, 0x4004449b, 0x404422ef,
    0x40983f7f, 0x3fffe6ac, 0x40706ea4, 0xbfd2010a,
    0x404cf2df, 0xc0557f1e, 0xbf212680, 0x402c6605,
    0x408b5792, 0xbf795ce2, 0xbeb785e6, 0x400752ce,
    0x401e36d1, 0x40721512, 0xc03b8b17, 0x4093f57f,
    0xbecb2975, 0x3fcf60a4, 0xbe84e113, 0x408286de,
    0x3eba5a73, 0xc02415e7, 0xbf6b1f3b, 0xbff52c44,
    0x3fab20a2, 0xc0136128, 0xc0a5eff5, 0xc01bf55f,
    0xc000d429, 0xbf4fe51a, 0xc002ce1d, 0x3f75d6ff,
    0xc090ff9e, 0x3e4629d0, 0xbf57f9fe, 0x403621df,
    0xbe1553d1, 0x3f8b8a9b, 0xc01364cd, 0x400bc1d6,
    0xbfdb0122, 0xc04c72f4, 0x3f574d36, 0xc004f51d,
    0x403642a9, 0x3efc44db, 0x40028109, 0xbf0cb500,
    0x3fce14b2, 0x3ee21d66, 0xbf6e9b33, 0x3fff5aea,
    0xbed1536a, 0xbf9bb908, 0xbf77f53e, 0x40020d9c,
    0xbf9164b3, 0xbfd92620, 0x3ff48d5a, 0x3f9dfc94,
    0x40b94b3f, 0xbee50985, 0xc01e87b6, 0xc0001be2,
    0xbfb77449, 0xbf8a3575, 0x3fef8fb7, 0x3e95ea30,
    0xc0421ef7, 0x40659246, 0xbfd12976, 0xbe7db1b9,
    0x4053e5ee, 0xbfc6634b, 0x406155d9, 0x40b067d8,
    0xc0241ab6, 0x3fc4f3bb, 0xbda1fdbd, 0x4083053a,
    0x401aeb67, 0x3fe0723d, 0x3fc5b6bd, 0xbf0e601c,
    0xc0032a88, 0xc01a22f9, 0x3f1646f5, 0x3ea027a3,
    0x3e99a660, 0xbfb94e8e, 0xc038b714, 0x3f998535,
    0x3fadb473, 0x3e17200d, 0xc062afca, 0x3f9fa37c,
    0x401b8ce7, 0xc0148262, 0xbe47a25e, 0xbfa96051,
    0xc041c47d, 0x4031d788, 0x40a35e62, 0x3ea5565b,
    0xbda670db, 0x405a7ea2, 0xbf19feeb, 0xbe579f89,
    0x400958c8, 0xc081ef96, 0xbdfbd6cf, 0x3f2c9a56,
    0x3fdd3b94, 0xbf0736a0, 0xbdda01a3, 0x40142d73,
    0xbf4ea369, 0xbd377026, 0xbfbc0c3a, 0xbf400df2,
    0x40605ad4, 0xbfae08ea, 0x3f3b9b19, 0x3e6b3cd8,
    0xbe3a62fc, 0xbffb09a1, 0xbf752d10, 0xbfa9f510,
    0xbeaf3d01, 0xbff72bd0, 0x3fd701d5, 0xbfb128b0,
    0x3f1ec635, 0x403fd0cc, 0xc04d7376, 0x3f566b91,
    0x3fc820d8, 0xbfa81477, 0xbfa7b536, 0x4082da33,
    0x4044b9b8, 0xbf017509, 0x3f783d5f, 0xbfc441e5,
    0x3f50fc1a, 0xbe10bde1, 0xc06718a0, 0xbf16161d,
    0x3fed6649, 0x4015ce38, 0xc05dc96e, 0x40ca394b,
    0x3f917370, 0x4003d921, 0xbf85d09f, 0x4071efab,
    0x3e8a6df7, 0x3fd35a6c, 0x3e91a5d9, 0x40158376,
    0xc02d2170, 0xbf4b78a2, 0x3f5746a9, 0xc03cfdc6,
    0xc07e81f7, 0xbf8c964c, 0x3fe3a204, 0x4056abe7,
    0x3ee628f6, 0xbf326545, 0x3f33aac5, 0x3fa9bc4c,
    0x3f393146, 0xbff007ed, 0xc012da3b, 0x3f37fe7a,
    0xc0104371, 0xbf62df92, 0xbfede309, 0x3f8296d6,
    0x402493fb, 0x40218122, 0xbd22748a, 0xbe03362b,
    0xbf85ced9, 0x3ee12c54, 0x3f85097f, 0xc0144359,
    0x3f72b2e2, 0x40046074, 0xbf50b687, 0x3ea1aa7a,
    0xc012f8b3, 0xc02f7753, 0x3fabbcd4, 0xc028d2e3,
    0x40999e12, 0xc043ae0e, 0x3fb845b5, 0xbffd66ff,
    0xbe0d4203, 0x3fbbabb8, 0xc043a51a, 0x3f572703,
    0xbe27fc72, 0x400920c8, 0x40263926, 0x4087829c,
    0x3d8fcd41, 0x3ffe07db, 0x3f03e2c3, 0xbe0cd87d,
    0x3fd36ead, 0xc0c3f3b4, 0x3fedf5d0, 0xbece9b15,
    0xbf56d6bb, 0xbfe645f7, 0x3eb858b7, 0xbfc12728,
    0x400a167a, 0xbf696882, 0xc06d94dd, 0xbf27999c,
    0xc02bdb0b, 0xc04feef3, 0xc0299820, 0x3ecd801c,
    0xbf752afb, 0xbfb02d90, 0x3f320b80, 0xc0a2138f,
    0xc03c34c5, 0x3fa8ac39, 0x3f81e545, 0x3ee052fb,
    0x0
    };

static const uint32_t ref_rfft_noisy_4096[4097] = {
    0xc056d02f, 0x4042dd84, 0xc0350c82, 0x405c80e5,
    0xbf054250, 0xbf9ac1b0, 0x3fd551bf, 0xbf68278f,
    0xc03f8ef1, 0xc025a11d, 0xbfb54c92, 0xbfcbe5b6,
    0xc0292ffc, 0x3e84b95a, 0xbef00cf4, 0xbf5f3f13,
    0x3fc374b7, 0xc023784c, 0xc073775e, 0xbeadaaff,
    0xbf5dc8cf, 0xbf50f6b2, 0x402a7a66, 0x40515df5,
    0x4058d816, 0xc086820e, 0x3f8dbcfa, 0x3d9c8f80,
    0xc093bbf8, 0x3f36337f, 0x3e9e1a63, 0x4059ff1d,
    0xc0110dc7, 0xbf35492c, 0xbf90b197, 0x3f864e0b,
    0x3f1dca36, 0x3fa58d93, 0xbf542981, 0xc02c1d13,
    0x3ffa6e3e, 0x402ad9dc, 0x3f59127a, 0x3f37ef53,
    0x3ffb6007, 0xbe263cb9, 0xbf92f273, 0xc0326c79,
    0x400be107, 0x4018a3dc, 0x40648f3b, 0xc0802221,
    0x4080b32e, 0x3f6c4281, 0xbf442502, 0xbff59ead,
    0x3fec3e5d, 0xc011c987, 0x3f98e2a7, 0xc02ad9a4,
    0xbe5fca79, 0xbebeaeca, 0x3fa09337, 0xbf74f1f7,
    0x3f39eab8, 0x3ffabe48, 0xc03280bf, 0x402fb65e,
    0x3ff712d1, 0x4056692d, 0xbf00ecac, 0xc025bf00,
    0xbf30e497, 0xbf9a4548, 0x3e93d8ca, 0x3e47f311,
    0x4038a4cd, 0xbff42a3d, 0x3daaf7bc, 0x3f627179,
    0xc001fadf, 0x3fc509be, 0xbedbcbff, 0x3edc5102,
    0x3ea4a7c3, 0xbfd23b9a, 0x3f50cf77, 0xbf44f0e8,
    0xbd154a70, 0x402c2fb2, 0xc02d324f, 0x3e8555c7,
    0xc057ca66, 0xbed75ec5, 0xc02aca85, 0x4036760f,
    0xbe9dd588, 0x3f2c1af8, 0xbfa3f39e, 0x3da22852,
    0x3f914cc5, 0x3fd39a49, 0x3e0cff6c, 0xbf183571,
    0x40583644, 0x3f80fc1b, 0x40909329, 0x3e802311,
    0xc0326849, 0xbe3ba4c9, 0xbf9342ac, 0x3f95ec55,
    0xbef09232, 0xbf90d6bd, 0x3f56fbe1, 0x3f33734b,
    0x3fe80b60, 0xc06d1f30, 0xc02fccdb, 0x3f1a6e14,
    0xbf53434d, 0x40061e64, 0xbfaa0002, 0xbfda435f,
    0x4006a063, 0xc013a26c, 0xc02414b5, 0xbe563636,
    0x4055030e, 0xbdfce737, 0xbf627c54, 0xbf8037a8,
    0xbff10922, 0x3f739cf7, 0x40267e5f, 0x4044436d,
    0xc0c0b84a, 0xbfa88e8f, 0xbfc8e8f4, 0x3e77f538,
    0x40721056, 0x3d778b13, 0xc065d174, 0x3eb3f834,
    0x3f06215d, 0xc0447543, 0x3fc29a06, 0x3f27f0ec,
    0x3f24d9f5, 0xbfdbc70a, 0x4019453c, 0x402c2dab,
    0x3e24ae59, 0xc015323d, 0x3f70df8a, 0xbf59bb52,
    0xc01fd63d, 0xbf064723, 0xbf3ff08b, 0x402f03fc,
    0x3fbd4cbc, 0x3fab3535, 0x3fd6054c, 0x403efeb6,
    0xc09eaafe, 0xc088627d, 0x4048d84e, 0x40162632,
    0xc0130edd, 0x4016c4bf, 0x3f75b2f6, 0x3ec99ff7,
    0xbfa325bf, 0xc024e6c5, 0xbfbb3a0c, 0x3f2993c8,
    0x3f8b3aa4, 0x3e4a6fb5, 0x3da24f3f, 0x4074584f,
    0x3f573f96, 0x403cd667, 0xbff9eabe, 0x40aea7d9,
    0x4044c500, 0xbfb06725, 0x3e54aceb, 0xbffa5e87,
    0xc02ddec5, 0x3fc83548, 0xbf9971a7, 0x40028db3,
    0x3e1c56d6, 0xbf94fbe9, 0x3fea14e4, 0x3fe9b4e9,
    0xc008cd37, 0xbfccf02a, 0xbf056527, 0x3e54f648,
    0xc0379e28, 0xbe9e9b07, 0xc03ac58b, 0x400bb7d3,
    0x3fab17e1, 0x4009cc4c, 0xc04e9564, 0x40474243,
    0xbe865537, 0xbf90cd07, 0x3fe3cc58, 0xc0bdad7c,
    0xc03a70b0, 0x40dbd854, 0xbfdd78d1, 0x3effb11b,
    0xc01cd17f, 0x3f4821e0, 0xc0738f1d, 0x400fa1bc,
    0x3fb8849b, 0xc05bef53, 0x403e9784, 0xbe2513ff,
    0xbf0fd0f5, 0x400342ee, 0x3fff4cb8, 0x40af0be0,
    0xbff0b1b1, 0x3f2d7251, 0xc00dbd9c, 0x404446cb,
    0xc011cc9e, 0xbf862970, 0xc021d6aa, 0x40811a51,
    0x3ff5514e, 0xc07a2438, 0x3f16eb5a, 0xbf138e59,
    0xc07afd98, 0xbf1a0ecf, 0xbfa35914, 0x406877a0,
    0xbf00a0a5, 0x401758b4, 0xbe4c6307, 0x3ee10d1b,
    0x3db07e77, 0x3f70afe2, 0xbfe54dee, 0x40982225,
    0xbf0ad83c, 0x3ffe2a9a, 0xc008e0aa, 0xbf47e23a,
    0x3f6237de, 0xc07cb9cd, 0x3fab49c9, 0xbdbaa8d9,
    0x3d856b36, 0xbf9a62d2, 0x3f2a6947, 0xc02d9d74,
    0xc08b83e5, 0x3ed35cbc, 0x4044e81a, 0xc00d077f,
    0xbf9a1510, 0x4025096c, 0xbf9a651a, 0xbf812a1c,
    0x409a5103, 0xc0227173, 0xbf39b363, 0x401ea773,
    0xc086d2a7, 0xc0aea7f4, 0x40759065, 0xbfabd8a5,
    0x3e6f2441, 0xc02be3a4, 0xbf84eb15, 0xbfb30aef,
    0x3fabe4e6, 0x3e221740, 0x40059978, 0xbd92f882,
    0xbe6e44dc, 0x3fc585f4, 0x3f7923f9, 0x3e9ddc69,
    0x3f6561dd, 0x3fc6b3dc, 0x3cbd5aba, 0xbf62e997,
    0x3f2e9598, 0xbea9d385, 0x3f6cc875, 0xbfd30070,
    0xbe28869c, 0x401b426c, 0x40771b94, 0xbf8ab9e2,
    0xbf96a90e, 0x3f04aeeb, 0x3f08aa11, 0x3e31f743,
    0xc062793f, 0x4028c874, 0xbde8fc9d, 0x3f51499d,
    0x3f38f29c, 0xbfc71458, 0x40432e7e, 0xc010970b,
    0xbfabffd3, 0xbf9650f0, 0xbfa87078, 0x3ff9637c,
    0x3ff6ae76, 0x3eff2c8c, 0x3f8ebfd0, 0xc05fad03,
    0xbfffbb4d, 0x3fe73cf9, 0x40be8e9e, 0xbeb42b18,
    0xbe46b28b, 0xbf0612c7, 0xc01eac80, 0xbf845596,
    0xbfa1e347, 0xbf4f670b, 0x3f89b117, 0x4006c566,
    0x3fa33a5b, 0xbfb19853, 0xc05a2f6d, 0x3c28994c,
    0xbd338b19, 0x404d2bc9, 0x3d0641f8, 0xbf7f40ea,
    0x3fa46fb0, 0xbff3f3cc, 0x3eded51f, 0xc00aaa04,
    0xc04efca4, 0xc01f0c97, 0xbfa2da56, 0x3f5653f7,
    0xbfeca147, 0x3fb6cca9, 0x3f118e6f, 0xc00e6f71,
    0xbdf1263e, 0x408a1cb8, 0x3f8aaf7d, 0x3fe5cf5b,
    0x406914e9, 0x400496eb, 0xbf825923, 0x3b44a0dc,
    0xbfa642b2, 0x40b2ff8f, 0x3fc55db9, 0xc05b5e7f,
    0x401ae0db, 0x4009c0ff, 0xbf18e911, 0xbf3a65bc,
    0xbe6106a7, 0x3ffb60d2, 0xbfcbffa6, 0x3d165d0e,
    0x403acabe, 0x4022368c, 0x3fd26817, 0x4021e673,
    0xc0129b7d, 0xbf89c92f, 0xc0326231, 0x4005f21e,
    0xc054daf3, 0x405ecf80, 0x4047574e, 0xbeb2f705,
    0x3e9a168d, 0xbff890c1, 0xc06de2df, 0x400f93d4,
    0xbf48c35a, 0xc02290fa, 0xbcfb2af9, 0x3ee14170,
    0x3d794bd3, 0xc02a3303, 0x40048a7c, 0xc08c4907,
    0x3fc18afc, 0x404c8071, 0x3fd14fd6, 0x403000a6,
    0x3f680482, 0x3f37bbee, 0x3fac153f, 0x3ecbf557,
    0xc056b16e, 0xbea12fa7, 0xbfa1014f, 0x3ef91316,
    0xc03c721d, 0x3ff9c513, 0xc00a6dec, 0x3fd36aef,
    0xbffac84a, 0x3d285e24, 0x3f042c38, 0x40046617,
    0xbe8b8411, 0xc060722f, 0xc02a0b58, 0x3fc9c6b6,
    0xc098966b, 0xbe32b30a, 0x3d487e3b, 0xbfb7316e,
    0x3e8bdcc1, 0x3f79114d, 0x4009f2c6, 0x40865d56,
    0x3fb6929b, 0x3fcd26b7, 0x3f1235c2, 0x3f9ec6a1,
    0x3f2e394a, 0x3dae7519, 0x3e505ace, 0xc070b00b,
    0x3eed5933, 0x3f505547, 0x3f9949e0, 0x404d5715,
    0xc02a2558, 0xbfae75ef, 0xbee8458a, 0xc0060768,
    0xc026d32f, 0x3fd10500, 0x3f26494e, 0x3ff1c502,
    0x3fd5f703, 0x3fdd83b9, 0x3f0cf88b, 0xbf065e1f,
    0x401bc0a6, 0x3ac49e77, 0xbeb60914, 0x3f0855ac,
    0x3ebad7f1, 0xbfd615ce, 0x3f54571c, 0x3e38c5c3,
    0xc005c662, 0x3f0165e4, 0x3dcb1ee3, 0x3fa8776c,
    0xc019fb94, 0x3fefa04b, 0xbc2b56bb, 0xbf17f737,
    0xc017706a, 0x3ffa0a49, 0xc0373e88, 0xbf9f22e8,
    0xbe71cbd1, 0xc07c4ebc, 0x3fdef31c, 0xc029a9b7,
    0x4043634e, 0xbf93c0af, 0x40a5ea06, 0x3ebc3fb6,
    0x401c1431, 0x3ff2d945, 0x408ba098, 0x4009c434,
    0x3f876d76, 0x3fce9b88, 0xc03c1b92, 0xbff10016,
    0x4003a12e, 0x4017a83b, 0xbea7e910, 0x3ea81009,
    0xc0547c09, 0x3f9047ff, 0x3f92f14d, 0xc09f4feb,
    0xbfad48aa, 0xbed170ec, 0x3ed10288, 0x3f966b81,
    0x4051f488, 0x3fcb75d2, 0xbff777af, 0xc02d176f,
    0x4030396f, 0xbf0e1230, 0x404c3eb6, 0x3f3e63af,
    0x3f3196a8, 0xbf9f6e93, 0x408ae203, 0x3f6a9710,
    0x407b1d63, 0x3f7ecccb, 0x4052b329, 0xc03c28e2,
    0x3ead8bfe, 0xc076875f, 0x3fd54555, 0x406dcb5a,
    0xbf21eb09, 0x3faec074, 0xbeda6c66, 0x40825bc5,
    0xbf969bb0, 0xc000d6ea, 0x3f7415c9, 0x3eec1965,
    0x3d841f68, 0x3fce255d, 0xc0c995fd, 0xbeb30d3c,
    0xc0770aa5, 0x3fcfd616, 0x3fb0b8a3, 0x3fa4bba7,
    0x4071330e, 0x406bd02e, 0x3ff7e81c, 0x401e436d,
    0x3e89a8a0, 0xbf48fa88, 0x3f40ab05, 0x3fc4132b,
    0x3d8a2d61, 0x3f30cd83, 0x3ed7ed33, 0xc04c0859,
    0xbfc7dcc0, 0x3fd21981, 0x3ffb1bf0, 0xbf9e43eb,
    0xc0230108, 0x40219fc0, 0xbf2fd0a9, 0x4076e25a,
    0x3f890815, 0xbebda4a1, 0xbfc5ccaa, 0x3f339140,
    0xbe00c71b, 0xbfdd7667, 0xc0840250, 0xbe65fba6,
    0x3e9c032a, 0xc03d7c20, 0xc07e752d, 0x40649f3b,
    0xbfa18786, 0xc065346b, 0x3fff66f9, 0x3dea2df7,
    0x4044ffd8, 0x3fb38eb6, 0xbf061864, 0x3ee26cb4,
    0x401fb619, 0xc03a13b4, 0xbef55ac8, 0xbfc57a5c,
    0xc0a348be, 0xc06dde8c, 0x3f8fcdd6, 0x3edf60e2,
    0xbe3ca984, 0x4003d4d3, 0xc0374bf4, 0xbff1ea88,
    0x3fa6eeda, 0xbe4c5b49, 0xbe84b621, 0xbf39b106,
    0xbf841f5d, 0x405d6f9b, 0xbd82572a, 0xbeb0bf61,
    0x3f29d46c, 0xbed140df, 0x3f9f1560, 0xbf836706,
    0x400cfdf3, 0x3f90c032, 0x3eb5722c, 0xc00fc7ca,
    0x3f74b3e4, 0xbf92ec36, 0xc022ede0, 0x3f69c010,
    0x3f8b0e22, 0xbfbb8f12, 0x3fdab924, 0xbe5733a4,
    0xbf9fb0ae, 0xc00badad, 0xbfb3954d, 0x3fc6160f,
    0x4094b838, 0xbe763b34, 0x403636aa, 0x400cf79f,
    0xc04a47f2, 0x3f70a880, 0x400d5637, 0xc03e8c37,
    0x400b1e1d, 0x4052fb92, 0x3ff033f0, 0xbeab69c0,
    0xc0990806, 0xbff5e21a, 0xc0460528, 0xbef392b6,
    0xbeb99a1c, 0xc011fe8a, 0xbfbb45eb, 0xbf8ce957,
    0x3fbae5a2, 0xbf58715d, 0x3f80c9d1, 0xc0b2fa5b,
    0x3fad77fb, 0x40b365f8, 0xc0346c2d, 0x40094c14,
    0xbff98a2c, 0x40e21fb3, 0xbf93758e, 0x3f7b73de,
    0xc02510f5, 0xc016030e, 0x3f820024, 0xbf7d405a,
    0xc01d1e04, 0x3f6087f6, 0xbfbca09e, 0xc08c673b,
    0x3f836ac3, 0x40233e36, 0x3de541c6, 0xc06a1bf1,
    0x3f6fbb8a, 0x3f66c486, 0x407574c8, 0xc03bef4e,
    0xbf2cfe6f, 0x3e32d632, 0xbfe7a4fa, 0x3fa576e4,
    0x3fe57017, 0xbf598cdf, 0xbfdb2ca3, 0xc07a90c7,
    0xc02c2d70, 0x3f8cb142, 0xbf5f8887, 0x3dc3a75b,
    0xc0230ac1, 0x3faae295, 0xc02d7ebc, 0x4032b4f8,
    0xc0e64c19, 0xc0b45c3f, 0x3fe59b85, 0xbf0813c4,
    0xbf3d0ef0, 0x4064d005, 0xbecb07d8, 0x402bcd45,
    0xbde183d1, 0xbf919b14, 0x4027d25c, 0xbfaf6e4d,
    0xbfa884c3, 0xc06a2bdc, 0x3fd07e29, 0x40067b8c,
    0x3fae46f8, 0x40221e7e, 0xbf153f67, 0xbf75e5f9,
    0x40a8938c, 0xc01d8a16, 0x3f529324, 0xbf1241d8,
    0x400c1be2, 0xc0493415, 0xc02653d7, 0x3e64668b,
    0xbe62ea26, 0x3f8dc435, 0x4022d10f, 0xbfb08a78,
    0x3f25dbb2, 0xbe4f83e5, 0x3fa9c6a6, 0xbf880774,
    0xbfd21e92, 0x3fb88261, 0xbd7491b1, 0xbfce34a9,
    0xbeedfc7f, 0xbfa86640, 0x408c7acb, 0x3f2b08a8,
    0xbf153773, 0xbfa7d918, 0x403793b5, 0xbf7c819a,
    0x3f2125d8, 0xbe73dd75, 0xbfd83355, 0xbfad556b,
    0xbf2febf2, 0xbf05210d, 0xbf9e61dd, 0xbf920972,
    0x3f0ef1d3, 0xc06eef9e, 0x3fbc3d9b, 0x3f307500,
    0xbf73d534, 0xc03f0093, 0xbff6ba6d, 0xbffc7fed,
    0x3f7ab23f, 0xbfbbd771, 0x3f90b3ab, 0x400cd4ca,
    0xc0f0434f, 0xc01b29c6, 0x3fa66066, 0xbf88fa66,
    0xc05b3c6c, 0x4026db84, 0xc005b3b3, 0x3fae784e,
    0xc04ce308, 0x408970fb, 0x4065a15b, 0x3e6f87f6,
    0xbf93ab17, 0xbf52121a, 0xbff83bdf, 0xc0423033,
    0xbf012ac6, 0xbf825d7d, 0xc040b7b9, 0x40052035,
    0xc05ab4db, 0xc05594ac, 0xc09ec332, 0xc07a4fbc,
    0xbf169cd6, 0x3ff2c3ca, 0xbd402e19, 0xc006033c,
    0x3f389367, 0x4015b109, 0x40153dd1, 0xbf42324a,
    0x40a98267, 0xc047e615, 0xbea80677, 0xbec78ab4,
    0xbff9292c, 0x3fe065ff, 0xbe187d61, 0x40099c98,
    0x401a8d02, 0xc0577339, 0x401ea9fb, 0xc0780888,
    0x3f97ad8b, 0xbd8273d4, 0x402f7f0c, 0x40312f1d,
    0x3fe4016c, 0x4098faa4, 0xbeba2dd5, 0xc07d5756,
    0xbea2252c, 0xc0a087b5, 0x3f5fd2d1, 0x3fad48bf,
    0x40052085, 0xc0f0ad05, 0x40302285, 0xbed3acff,
    0xc0576326, 0x3fe8edc3, 0xbf932fae, 0xbff8f3a1,
    0xbf82e4c6, 0x3fb667a9, 0xc027afe4, 0xc0982de6,
    0x3f72a183, 0x401dd5f4, 0x3ea60c11, 0x3d8c2686,
    0xc09ce95f, 0x4003c691, 0x4078d399, 0x3e04a47c,
    0xbf2b2138, 0xbec972a5, 0x3f8522cd, 0x3e830124,
    0xc0665007, 0xc02b85e3, 0xbfcc35ff, 0xbfcc2177,
    0x403c3d90, 0x3f9d8d8b, 0xbf9cecb6, 0xbdafb716,
    0x3d905e63, 0x3e7379f7, 0xc01daaa0, 0xc087ac81,
    0x3ed2879a, 0xc0c5dd60, 0x4096d2b3, 0xbe498080,
    0x40c1c7aa, 0x3e6bc8eb, 0xc08b442e, 0xbfedf675,
    0x40a98e5c, 0x40492c29, 0xbf23a411, 0xbf1e1d41,
    0xbd479169, 0xbf3b722a, 0xbdab5538, 0x3e5ffb5e,
    0xbecd82e8, 0xc0767089, 0x40389f43, 0x40873eb8,
    0x3f705059, 0xbfec3139, 0x401c1598, 0x3f1848f9,
    0x3f0f73c6, 0x3fed5930, 0x40b5c242, 0xbe9cc021,
    0xc03d4467, 0xc01dfed8, 0x3f8a4881, 0xc0582ed1,
    0x3e994f4d, 0x3f90dbdf, 0x40027eb0, 0x3f8f074a,
    0x406744b2, 0xbf3cedb0, 0xc02c9c37, 0x400cb96b,
    0x409dd298, 0xbf7873a6, 0xbfb8b976, 0xbe8c2748,
    0x40111de2, 0x3f3d5eec, 0x3ddb9573, 0xbd2d2334,
    0x40763ed0, 0x3fa05d61, 0x4010b1e1, 0x40149970,
    0x3fbd5261, 0x3eca7682, 0x3ea46522, 0x4082b4e7,
    0xc03ed753, 0xc0bf1760, 0xbea9f6e4, 0xbdaa1ca5,
    0x403a9079, 0xc043ab9c, 0x3f75e57e, 0xc060f2c1,
    0x40907596, 0x3f405b17, 0xbfbab52e, 0xbfb3b8ae,
    0x4088a714, 0x404f6e29, 0x4011068d, 0xc08f55ca,
    0x407bfb5a, 0xbf9f1fa6, 0xc02d8f5b, 0x3efa5688,
    0xbfd721d0, 0xbfbbe59d, 0x3e2c1d19, 0x3fb94fee,
    0xc0246536, 0xc0b6bc42, 0xc01c010a, 0xbf8e220a,
    0x3ffa61d4, 0x3f75eeba, 0xc00b9e27, 0xbf21b52d,
    0xc02113a4, 0xbfe0c1c5, 0x40181d7c, 0x3fb1f3ab,
    0x40431e29, 0x403544bb, 0xc01fdf47, 0xbe8fde93,
    0xc0759888, 0xc02278dd, 0x3f989070, 0x3f9893f7,
    0x40050a7f, 0xbf9d68e8, 0xc06bf2d5, 0x3f708d32,
    0xc04cb581, 0x400c398e, 0xbf541145, 0xc00c3f35,
    0x40276146, 0x3fe9a299, 0x3e65c168, 0x3f4f13ac,
    0xbff326bb, 0xbfd14321, 0x3e3b15cc, 0x3f0c2f96,
    0xc01ee24c, 0x3f687afb, 0xbfd437d7, 0x40819d85,
    0xc004a05a, 0xbf7c702c, 0x3f322118, 0x3eb9dda6,
    0x4029b5da, 0xbfe9adfc, 0xbf87ba21, 0x3f4ced5e,
    0xc0107c38, 0x3f1198ed, 0x3f717dbc, 0xbfb604db,
    0x3f922cad, 0x40080cad, 0xbfd8c644, 0xbec9e984,
    0xbfe04e45, 0xbfa44c07, 0x40251378, 0xbf36d944,
    0x3fa49df5, 0x3f2ce6dc, 0x400462e6, 0x40210af5,
    0x3ee95522, 0xbf769c0a, 0x4085585b, 0x4084168f,
    0xc03cfd7b, 0x3fd48ed5, 0xbeb3be3a, 0xbfb12361,
    0xc016584a, 0x3fb7ea04, 0xc027dc70, 0x3f021b74,
    0x4051f2f1, 0xbfd9354e, 0x401aa7c8, 0xbf1ed9f9,
    0xbfcd5b8d, 0xc0897ea5, 0xbff90f94, 0xbf87358d,
    0xbd9862f5, 0xbff8573a, 0xc03e9cad, 0x4023fc57,
    0x3f9e7064, 0xc01c1263, 0x3ea195c4, 0x3dc67d1c,
    0xbf579737, 0xbfb17268, 0x3fc162e8, 0xbfbba15d,
    0xbcb83107, 0x3fe660ad, 0xbfb33e09, 0xc0296d0c,
    0xc0c8cf56, 0xc4b30fd9, 0xbdbd9ed5, 0x4029d141,
    0xbfc162e4, 0x4086cc3c, 0x40cdd125, 0x3ef046be,
    0x40a4855a, 0x3e7c1d1c, 0xbfd9d757, 0x4068813a,
    0x3e7abc2d, 0xbfb2f4ea, 0x3fc52126, 0xc00a3a5a,
    0x3e808b7d, 0xbebf20c9, 0x3d8b04e6, 0xc0175f04,
    0xc068f385, 0xbf011bab, 0xc054a8f3, 0xbf2deb50,
    0xbeb13ae0, 0x3f987bd0, 0xc082e4f2, 0x3f0a00ed,
    0xc0865524, 0x40ab7675, 0x3f1cd3d3, 0xc0765753,
    0x4004eb69, 0xbf1a5d53, 0xbdf2459d, 0x3f7ddd20,
    0xc042cfa2, 0xbd4bb0f1, 0xbec0f300, 0xc0331852,
    0xbf041b87, 0xc01cac51, 0xbec0d6a1, 0x3ea447af,
    0x3e843697, 0x3fc5e6ad, 0xbfb0127d, 0xbf570a6d,
    0xbf6e5d8b, 0xc08481c3, 0xbe65c9d5, 0x4023f79f,
    0xc023f180, 0x3f06fa5c, 0xbf0f404e, 0xbe590609,
    0x3fd97c95, 0xbf92ad3e, 0x40ad3be1, 0xbf8d2408,
    0xbdee09e3, 0xbf13f4c3, 0x3f72bde8, 0xbf1ad9ce,
    0xc02c0cc6, 0x3f80de2e, 0xbd8d6ae0, 0xc0d32dda,
    0x3fe72c74, 0x3f96da54, 0x3eddd516, 0x3da4e1d0,
    0xbfc5f3d0, 0x40d19e5e, 0x3fc9bbdf, 0xc01a755f,
    0xc02a1507, 0x3fe75588, 0xbf411bcb, 0x3f58a996,
    0x4066ce7a, 0x3ffea1d7, 0xbf2cbe9c, 0x3e3e35c4,
    0xc016f513, 0xbf4f9949, 0xc0327052, 0x4089cdd7,
    0x3f232586, 0x3fa957d8, 0xbed7a478, 0x40043e95,
    0xc08befdb, 0xbfa05865, 0x3f37f831, 0x3edc4318,
    0xbe7401c4, 0x40011f25, 0xbf101599, 0xc0ae22d1,
    0xbfbc8ba4, 0xbef44326, 0xbf843011, 0x4019d5a0,
    0xbf8ef602, 0x3fa7d3f0, 0x3ffedc01, 0xbf23f4fa,
    0xbe945d6b, 0xc00b4d8c, 0xc0326106, 0x3f988535,
    0xc0756651, 0xc0e59fbb, 0x405691e8, 0xbe960792,
    0x3fc4ffd2, 0xc09e8b5b, 0xbec9ce1b, 0xbe804f37,
    0x3fdbc7ea, 0x3fcd2d90, 0xc033b6cf, 0x3ea14dfa,
    0xc01e0cd9, 0xc015346c, 0xbf970be8, 0xbff3165c,
    0x405c28dc, 0xbe1a37af, 0xbda4bf2f, 0xbfd584ed,
    0xbd03957e, 0xbf41048b, 0xbfbc0470, 0xbfba4927,
    0xbd58569b, 0x40884d9a, 0xc00817de, 0xbfcab44c,
    0xc02ad4b3, 0xc0637724, 0x40169fda, 0xbf9c6928,
    0x3fbdbf83, 0xbf8cb64e, 0x3f86da4a, 0xbf33b0e7,
    0xbebbf2a1, 0x40137990, 0x4069204d, 0xc050fe97,
    0xc02e89a8, 0x3f131609, 0xc02ec9db, 0xc00891b6,
    0x40707c3b, 0x40467a37, 0xc0626ef1, 0x3fb3b3dd,
    0x401a32ca, 0x3fe8f61f, 0xc016620e, 0x3fef6e24,
    0xbfa8905a, 0x400b6bcb, 0x3fed30e1, 0xbfbd0c35,
    0x409cecee, 0x3ddc594c, 0xc0722547, 0xc02af521,
    0xbfc13e13, 0x3fa53c78, 0x3fa5cf96, 0x40382a5d,
    0x3e1d8256, 0xbfa953fa, 0x3f8e352d, 0x3f4b9938,
    0x3e87e8c1, 0x3f1f2e6e, 0xc04314bd, 0x3cc5f9ca,
    0x3fc616f5, 0x3fc138b4, 0x402641ce, 0x3f133bb9,
    0x40824fd6, 0x4023934b, 0x402882c4, 0xbd04a4d3,
    0x3f66a17c, 0x3ff8ea83, 0xbfac98cc, 0xbfc16996,
    0xbfbb1653, 0xc04c835b, 0x3e6aa904, 0xc0063914,
    0x400e68ac, 0xc01a4d4d, 0x3fb01acb, 0x40e07f58,
    0x3e585012, 0xc088cf48, 0xbf3d06f5, 0x4040e7d5,
    0x3eb1439f, 0xbea6b5f3, 0x3d8ef1d0, 0xc00cd2c7,
    0x3f221532, 0x3f8d8e6c, 0x40571700, 0xbea6dbde,
    0xbf2f1e11, 0x3ff19d58, 0xbf58acbd, 0xbf171666,
    0x400763ea, 0x4004584a, 0x40101f4e, 0xbfe5ab7f,
    0x3fed72fc, 0xc0516405, 0x3fde1818, 0x3e5e3fed,
    0xc0136e21, 0xbe1c554e, 0xbf128363, 0x3f4737f8,
    0x3ef1f43d, 0x3fc49cce, 0x3f91d58c, 0x3fbcb73e,
    0x3fdd0237, 0x3eef6ba9, 0xbfb3f56b, 0x3eb21331,
    0x40314fb8, 0xbf8484b3, 0x4061646f, 0xbf905e75,
    0x3f06eb0a, 0xbe804276, 0x3e1afb7c, 0x40428c3f,
    0x409b58c0, 0xc010e28b, 0xc01cc1e4, 0x3f8224ba,
    0x400e8914, 0x3f4fd1cb, 0x3fb24976, 0xbe462fd5,
    0x408e868c, 0x40399d7d, 0x3f9fbbae, 0xc05d3205,
    0xc0259855, 0x4046edd8, 0x3e7a63a8, 0xbdcfcb02,
    0x4007eb5a, 0xbd8baaac, 0x3fa12fb9, 0x3ef32ca3,
    0x404d52bb, 0x3f7eccde, 0xbfe4e1be, 0xc02d083d,
    0x3f1efa03, 0x3fcccf29, 0xc00da719, 0xbf158cee,
    0x3f450925, 0x408837f8, 0xbf2bd01a, 0x3f00fbdc,
    0xbf833c01, 0x403e8b3e, 0xc00001f5, 0xbf403202,
    0x3e428f26, 0x404144a4, 0xc05aac6a, 0xc080332e,
    0xc0903c41, 0xbf73bd0d, 0x400f624b, 0xbfb9a60a,
    0x3f02e6cd, 0xbf7f5c14, 0xbf8b1d37, 0x400b3e6a,
    0x3f91162c, 0xbfe263f8, 0x40340b58, 0x3f89588d,
    0x3f476869, 0x406ce475, 0xbd177c94, 0xc0560930,
    0x3fe0487f, 0x3fbc4038, 0xbf00ef7e, 0x3f82e981,
    0x40243250, 0xbf8b3a7a, 0xbfe94e8d, 0x3fdbde53,
    0x3e758996, 0xbf24a564, 0xc00ffc32, 0xbf9c64e4,
    0x4072999f, 0xc0014549, 0xbfb0f580, 0xbfec4621,
    0x3e6a9dda, 0xbfc0cd2a, 0xbfc79ec5, 0xc05ea6df,
    0xbee95468, 0x3f98deb3, 0x3f9536a9, 0xbe0be287,
    0x3fc70841, 0x403a4472, 0x3f973f6f, 0xbfff86db,
    0xc0837ea1, 0xc01272db, 0xc01ae76b, 0xbf95583d,
    0x401c4e8d, 0x4024cbf8, 0xbf835d75, 0x3f4d613d,
    0xbf094a1f, 0x405f1cf8, 0xc01d8632, 0x3f336c29,
    0x3fdb5a5c, 0xbdafb51b, 0xbe1a9401, 0xbf88b730,
    0x3f00290e, 0xbf1a046f, 0xbe35a7e4, 0x40019762,
    0xbe0bc372, 0xc094dc45, 0x40657413, 0x400477c9,
    0xbf614bc7, 0x3fafb7c1, 0x3f02e638, 0x3da8f9df,
    0xc0237434, 0xbee7599a, 0xc03b6789, 0xbf161a5c,
    0xbfe5a874, 0x3e5fafee, 0x3e22f969, 0x3f464569,
    0x4003779d, 0xbfd6a8e3, 0x3f38e3e6, 0xc000c82f,
    0xbff28293, 0xc09f9630, 0xbfc0f23e, 0x3f96e6b9,
    0xc004ab59, 0xc0638f75, 0xbebc8463, 0xbe028f83,
    0xbfa9ed57, 0xbeafec3f, 0x4014f6f3, 0x3fe5b6e7,
    0xc0636c37, 0xbf1571db, 0xc01bedb3, 0x40907ec8,
    0xbfd8b792, 0xbfbde766, 0x3eebb4aa, 0x4040a0ff,
    0xbf8e7aa5, 0xc032f170, 0x3e10feb9, 0x3f106cbf,
    0x400beca9, 0x3fc3cc14, 0x3f86e25a, 0xc019955e,
    0x401d1892, 0x3fdb2a30, 0xbf08d38a, 0xbf46d790,
    0x3c8a90ee, 0xbf6fdd08, 0x4033652e, 0x4082d337,
    0xc001dd26, 0x401cd19f, 0xc0264006, 0x3fbbebb0,
    0xbfd23f5a, 0xbf4b6d98, 0x401dcfeb, 0xbf4dcf40,
    0x3f017fbc, 0x4069318f, 0x3fef079f, 0x408e7d23,
    0x3f9768df, 0xbe21adda, 0x40a66d89, 0x3fc77915,
    0x4084e46a, 0x3f68a206, 0x3f404ba1, 0x403e0470,
    0x3f817cbe, 0xc008622e, 0xbfac6aa1, 0x3fa85e36,
    0x3f9464ed, 0xbdffba7f, 0xc049fa78, 0xbf95471d,
    0xbf22b9ba, 0xbebb8520, 0x408dd806, 0x4020c091,
    0x3faeebfa, 0x40048916, 0xbf536185, 0x403cea75,
    0xbeeb3add, 0x3fdf3752, 0x40760f8e, 0x40aaab08,
    0x3f82ec6e, 0x3f165739, 0xbf9e5279, 0xc04d2f7c,
    0xc04279f7, 0xbfd29d4b, 0xbe327bdd, 0x3f131f9d,
    0xbf9dd32f, 0xc02b677a, 0xbf8b0498, 0xbe58675a,
    0xbeee21ff, 0xbecdd055, 0x407b09ac, 0xbfe8a45c,
    0xbe09f573, 0x3f39f1ea, 0x405195e1, 0xc01e7ee4,
    0xc0419359, 0x3eefecca, 0xc063ef93, 0xc0049e55,
    0x3ffc2ceb, 0x40334b4e, 0x3f158633, 0xbfcb5395,
    0xbe9a3e9a, 0xbfc91535, 0x3ff084de, 0xc018c6a4,
    0xc043260e, 0x3f406c52, 0x3e1c0ef4, 0x3fce5461,
    0xbfeaf8d7, 0x3f6bc3d2, 0x3dd3b4d5, 0xc03202c9,
    0x3fd17d44, 0x3f5019c4, 0x3f5f9eb0, 0xbfd46372,
    0xbf8aacbe, 0x3fdac9b1, 0x3fce9778, 0xbf7e6e35,
    0xc06f8411, 0x40129e16, 0xc0278d77, 0xc06b484c,
    0x3f384abd, 0x3fb9817e, 0x3fdfd326, 0xbfe9a0ff,
    0x3fc2887d, 0xbfa35c9e, 0xc0028599, 0xbf84a678,
    0x3f0f0b91, 0x3fea9143, 0x4033e790, 0xbf90616e,
    0x3f80e447, 0x3f4cc360, 0x3febb732, 0xbf932214,
    0xbfc8698b, 0xbe6b1930, 0x3fe609f8, 0x40935a70,
    0x3fb0f6d9, 0xbfe4a180, 0xbfe28c80, 0xbdd40146,
    0xc05de5eb, 0xbf8ec8f3, 0xbf39b36a, 0xc04d8742,
    0xbe1e2072, 0xbfab491e, 0x3f009694, 0x4061bbd9,
    0x3f34437d, 0x3fb7fca2, 0xbfb68a1d, 0xc006aba0,
    0xbf3fee55, 0xbfae91ba, 0xc023a4f4, 0x3fe82057,
    0xbe7299ee, 0x4046617f, 0x3f2f088c, 0x3e21c447,
    0x3d6c481c, 0x3f3241f9, 0x4016fa9e, 0x4080c1e8,
    0x3f9497f9, 0xc08d7c4f, 0xbf3bbbd0, 0xbf79ba80,
    0x3f42045b, 0xbf2a27b7, 0xbfbe5d66, 0xc040e55f,
    0xc07200dd, 0x401c9e52, 0xbf34759b, 0xbf174fee,
    0x402d5119, 0x3fb048ee, 0x3f2d14c6, 0xc00bb8fb,
    0x3f205689, 0xbeb92d38, 0x40084ac8, 0xc02711a6,
    0x40312621, 0x3fc961c6, 0xc04b5215, 0x407a7d99,
    0xbd10502a, 0xc0838f01, 0x3c866282, 0x4028a878,
    0x4055056b, 0x40227b07, 0x40b1d028, 0x3f93c8aa,
    0x401755ed, 0xc058d4d4, 0x40722268, 0x402779fd,
    0x3f82617b, 0x3dc23458, 0xbf149b8f, 0x3cc178f7,
    0xbf900ab4, 0x402c91a7, 0xc0689b17, 0x3f6dbbdb,
    0xbd39abe3, 0x3ff46842, 0x3fd465b1, 0x3e2f78fd,
    0xc082e896, 0x3ddcdfd4, 0xc0a38bbb, 0x400bb352,
    0xbfe2f15c, 0xc0e1e4a1, 0xbfe80aaf, 0xbe12d31d,
    0x4014d662, 0x40239a34, 0x403b116a, 0x3f7b81a2,
    0xc069ba43, 0xbfb4c299, 0x402b4b17, 0x3f493371,
    0x3fc602cb, 0xbe61f95a, 0xbfeba919, 0x3dae0fb4,
    0x400ad2bb, 0x3ec6710b, 0xbf2d42f9, 0xbf1db91c,
    0x409a0c01, 0xc03ffa11, 0xbde699c8, 0x3f8e0e31,
    0xbff36f62, 0xbfad7bde, 0x401d1a7c, 0xc037de2a,
    0x3f8a466a, 0x40141b05, 0x4022aa46, 0xbe17f7be,
    0x3f77d2c9, 0x3fd7ce9d, 0x3effa063, 0xc0476a17,
    0x3f9a51d2, 0xbfa61617, 0x4023ae9d, 0x407b9316,
    0xbe68da70, 0x3fa96a83, 0xbf1ef9f9, 0xbf74979d,
    0x3f7dd112, 0x3e66257e, 0x3ff069fe, 0xbfd05317,
    0xc00c36ed, 0x40038d75, 0xc07dc8ad, 0x409a4109,
    0x3f4f452e, 0xbf9b350b, 0x3f80e64e, 0xbfc4596f,
    0x40025cc6, 0xc02e6b67, 0xc0a83e64, 0x3f99ef98,
    0xc03aec37, 0xbf48ef6b, 0xc03771c8, 0xbd2e36bb,
    0x3ec42b15, 0xc0852c80, 0xbf269ff0, 0xbfd81477,
    0x409112d3, 0x3e3ccc61, 0xbf57c767, 0xc0701335,
    0x3eecaeec, 0x3f4d53d6, 0x3f2391dd, 0x40430a5e,
    0xbf85a5c5, 0xbed5c104, 0x3ea01922, 0x3fdd0562,
    0xc00324dc, 0x4055087f, 0x3f479c10, 0x3fea92f0,
    0xbe53c978, 0xbfef9ab0, 0xbfcf8a0b, 0xbf7dba89,
    0xbfd927fa, 0xc0753356, 0x3ecc3f9d, 0x4032e21f,
    0x3fa7e322, 0x40525d60, 0x3fff7cc7, 0x3f1d90e4,
    0xc03f1bed, 0x3fe88d78, 0x3f2fcfb4, 0x40890bc7,
    0xbea242ba, 0xbfbdec33, 0x400f18e5, 0xc0a59b10,
    0xbfbd26d8, 0xbfbb4929, 0x405f91ca, 0x407b9486,
    0xbf422c2c, 0x3ee8f031, 0x40101f4c, 0xc05b51da,
    0xbf7b2b1a, 0xc00a8295, 0x3b930012, 0x3e93ecc0,
    0xbf15d48f, 0x3fcc8906, 0x3f21d6a8, 0xbfe35f0e,
    0xbfc2ab10, 0x3f9b6f0d, 0x3d7104d2, 0xbfd20431,
    0xc03c3bdd, 0xc048ef77, 0xc011e948, 0x40553f10,
    0x3f97ba28, 0x4039eb3b, 0x3ebf14ac, 0xbf50138b,
    0xc05c74b7, 0xbe033f23, 0xbec78da2, 0xc04469d9,
    0x40bb3af0, 0x3f96395e, 0xc01df3b2, 0x3f9aae5e,
    0x4070d052, 0xbffc7df3, 0xbf100185, 0x403db3f2,
    0x40478303, 0x3fc0ee60, 0x3fd799fb, 0x403f18a7,
    0x40f1e548, 0xc058c0f4, 0xbe66a0b8, 0xbfa28069,
    0x3efcdc03, 0xbfd29464, 0x3f50d9e8, 0x3ff15d55,
    0xbfcbc9bb, 0xc007c61a, 0x40424443, 0xbebd930c,
    0x3fcb5304, 0x4013034b, 0xbffb00a7, 0x3e8b7857,
    0xbf115518, 0xbfbbd704, 0xbf80904c, 0xbe82a5df,
    0x3ffa24bc, 0x3fd11ec0, 0x3fcabd04, 0x3f918b6b,
    0x3f84bc51, 0xc0933eb9, 0x3dcb6f99, 0x3fcbfb68,
    0x3fbd7ea7, 0xbfec1d8c, 0xc02c4902, 0x400d252f,
    0x3f70f273, 0x3dd9fc9c, 0x402ed07e, 0x3fb8057f,
    0x4093dc10, 0x4000c89e, 0x3eb9d696, 0x409427fc,
    0xbfabb745, 0x3e333409, 0xbdd09b25, 0x3f3a03fc,
    0x408edec5, 0xbfbf10fc, 0xbf8f7999, 0x3eff71c3,
    0x40135379, 0xbf6c8a89, 0xbfe0a9f8, 0xc00aa5c7,
    0x40170eb6, 0xbee2e45b, 0xbf8bc3d4, 0xbe20c8dd,
    0xc03b48e0, 0xbe5a2b00, 0x3ffb5b40, 0x3f942ff6,
    0xbebbd206, 0xbf7e6c6d, 0x4001c2dc, 0x403fb5b4,
    0xc017dee2, 0xbfb3c516, 0xbfcf1c96, 0xbf25b0b9,
    0x40065ac9, 0xbfab1922, 0x3f1c3304, 0xc0370ca5,
    0xc057f27c, 0xc03ee19b, 0xc08048f8, 0x405b0a63,
    0xc00219e5, 0x406b5097, 0xbf0033c1, 0x3f313245,
    0x3f2dc442, 0xbfab222c, 0xbebaafe5, 0xbfbdc308,
    0x3ffc7048, 0x3ff8c0d8, 0xbee9ec9b, 0x3f9affc4,
    0x3ffc2bc9, 0x405b5fb3, 0x4055e464, 0xbfbe8fc4,
    0xc08a5f1d, 0xbf6a2118, 0xbfdd2e49, 0xc0c63643,
    0x4057ed12, 0xbeb47e18, 0x408c0817, 0x40410d26,
    0x3d0ca0f0, 0x4000a675, 0x3fb483a6, 0x402fe149,
    0x3c2aa5fb, 0xbf145e0b, 0x402fa6b0, 0xbf2f7024,
    0xbf14abbf, 0x3eb5356b, 0xc03e64af, 0xbf71ab90,
    0x3f5fbed4, 0xbfbf9876, 0x407d64a0, 0xbeccbe13,
    0xc00ebb28, 0x3f17fc4b, 0x3fe60d32, 0xbf21ca04,
    0x3eeab06f, 0xbf4707c9, 0xbf4c649e, 0xbf8b57df,
    0xbf54d65f, 0xc091db29, 0x40159a8f, 0x4001bdc3,
    0xbf9305c6, 0xbf496483, 0x3f75df8f, 0xc003afdc,
    0xbe342f83, 0xbf411cb3, 0xc05b0174, 0x3fd1af74,
    0x3e821120, 0x40702915, 0x407e105c, 0x3f1669f0,
    0x3f5d554e, 0xc03fa7d0, 0xbfd877fb, 0xc054f079,
    0xc0097cc5, 0x3faf6ad6, 0xc0682f8e, 0xc00dd53c,
    0x406f8220, 0x3ec213de, 0xbee604a0, 0xbf769910,
    0x40b63719, 0xbf4451df, 0xbfa7eeb3, 0xbf0d8d62,
    0x3e681043, 0xbfb627a0, 0xc03d1989, 0xbf0db368,
    0x4069d8bc, 0xbfbe6138, 0xc0677856, 0xc008da9e,
    0xc0768111, 0x3e41af33, 0xc0296d31, 0x3fca5a43,
    0x3ff7d597, 0xbf86f739, 0xbfa817a5, 0xc010406a,
    0x3fc971ea, 0x3bb043f5, 0xbdd70f4f, 0xc01623b6,
    0xbf5629d0, 0xc0184c98, 0x3fe10c50, 0xc04b7d56,
    0x3f37d653, 0x3fd69e09, 0x400e25f9, 0x40d8e5c9,
    0x3fd518a4, 0x4002e824, 0x3ed6150e, 0xbf143b67,
    0xbffef71c, 0xbffd7922, 0x3f7625f3, 0xbf015694,
    0x3fa7ac9d, 0xbfabb8ba, 0x3ea98fec, 0x40169b1a,
    0xbf4910b8, 0xbf99c501, 0xbf77c9a3, 0x40a7f327,
    0xbeedad91, 0x3e7e49a5, 0x3fade1a3, 0x3d5d0fe6,
    0x3ecb9a8b, 0x3ffa0b78, 0xbfee9ad0, 0x3f4afc8c,
    0xbeffa8ee, 0x4027dec6, 0x3f2ba198, 0x3ec1f9be,
    0x3fa8497e, 0xc025ff33, 0x3fe201ce, 0xbf8ca07a,
    0xbf8a7f32, 0xbfd3ec73, 0x3f960c65, 0x3e1798ad,
    0xbfd94673, 0x3ff6b5d0, 0xc03e6126, 0xc02bb54e,
    0x401ece13, 0x408d7e93, 0xc010592a, 0x40340c03,
    0x3f62d405, 0xc08944e6, 0xbfdf9168, 0xbf99cc0b,
    0x3bc46258, 0xc0072157, 0x3fea0520, 0x3fac7327,
    0x3f3c41af, 0x407c0153, 0xbfee4c88, 0x40239271,
    0x40f89f0d, 0x3e9b2b1a, 0x3f83ca81, 0x3eca4795,
    0xc070c176, 0xbff4191a, 0x404cc049, 0x3ff2379f,
    0x3dbe6abc, 0x3f97f721, 0x3f88519c, 0x3fd375f8,
    0x3f356a3e, 0xbf14be1e, 0x3f37eee2, 0x3feb51bf,
    0x3f3a4a3a, 0x3fe92d1f, 0xc0333beb, 0xc03d7b30,
    0xbef466b9, 0xc0713dd7, 0xbffa614a, 0x4085900a,
    0xc002822e, 0xc030775c, 0xc03fe02c, 0x3f545f8b,
    0x3e145b0a, 0xbf1c78fb, 0xc02a9c05, 0xbf884afa,
    0xc01061d2, 0xbf62894e, 0xbfedaab3, 0xc07107d4,
    0xc06ea85e, 0x402beb63, 0xbed93f9a, 0x3d817ac2,
    0xbf947949, 0x3ef68907, 0x3f59444a, 0x3e92d8d0,
    0x3f3a1de6, 0xbf4119f2, 0xc03705ac, 0xbfa14568,
    0x3fc5aa53, 0x405639a4, 0xbff7daba, 0xc02ea228,
    0xbf49a559, 0xc039d80c, 0x3e9b1de3, 0xc0105235,
    0xbfd4a932, 0xbefd9e24, 0x4051ba13, 0xbe00a46a,
    0x3dfc4812, 0x40365966, 0x3fb0d5e3, 0x40054a2d,
    0x4021a364, 0xc026a8f3, 0x3f01f5d0, 0x3edfd181,
    0xbf784e00, 0xc059a5e2, 0x400383bc, 0xc00420de,
    0x3f9de07d, 0x400eef30, 0xc0a01e60, 0x3f81eef3,
    0x40940e1c, 0xbf843641, 0xbe53fbf8, 0xbf1d22c1,
    0x401d433e, 0xc01152f9, 0x3f83995f, 0x3fc8ff97,
    0x4081ceef, 0x40df20b4, 0x3e5a3d0f, 0x3ee88666,
    0xc0013034, 0x3ffe73db, 0x409925ef, 0xc025ebfc,
    0xc03c7e15, 0xc03ba0ee, 0xbf4cef35, 0xbf9f32db,
    0x3f9b8730, 0xbe03f37a, 0xc0863709, 0x3e5a9a70,
    0x400ecf80, 0xc042c91b, 0x4042eb06, 0x3dece0b1,
    0x4087a3c3, 0x3d04c2ef, 0x3c9b5e49, 0xbf182103,
    0x3f113b8f, 0xc074d7dd, 0xc06fa9e9, 0xbfa8d87d,
    0xc0773c2e, 0x40c9c1af, 0x3efb172c, 0x3e433ceb,
    0xbe5d1ead, 0xbf911952, 0xc022ce9f, 0xbde41ffd,
    0xc02f7245, 0xbe4aba29, 0xc06581ec, 0x3fd79178,
    0xbff7f1e8, 0x4013e608, 0x40322c79, 0x3fdfdbb0,
    0x3fb64837, 0xc08345f7, 0x3e60f091, 0x3fc3efbd,
    0x3e1cade0, 0xbf6a59e6, 0xbfd67331, 0xc0268a5e,
    0xbdb76c02, 0x404d6213, 0xbfebca40, 0x4001322d,
    0x40105fcc, 0x3dbbb9a4, 0xbf168fff, 0x3ff40857,
    0xbfe510bc, 0xc06c72ff, 0x3fad8651, 0xbecc1451,
    0xbfb20d0b, 0x3ee28b52, 0xc01a1d4e, 0xbfc7528a,
    0xc083e7ea, 0xbf97cc7b, 0xc02db41f, 0x408e3ace,
    0x3c32284b, 0x402d9d20, 0xbeda2c01, 0x40695e64,
    0xbfcb24b6, 0x3f4678d4, 0x40481047, 0x40014a6f,
    0xc08db5d0, 0xc070ea9c, 0x3eda0adc, 0xbfb03006,
    0xbe32bbeb, 0xbfcaf56c, 0xc02c3dd9, 0x3e3aeb10,
    0x3fca618f, 0x4020696d, 0xbf93f1ae, 0x3f95388d,
    0x3f2e3fd8, 0x3ff1ec03, 0xc01018ab, 0xbfa9ef7d,
    0xbec36e94, 0x3fb8f78e, 0xc02aa7ad, 0xbf453109,
    0x3f5c85f6, 0x3e6c1f89, 0xbf953adf, 0x401d5a45,
    0xbebae2c9, 0x3fbca0fb, 0x3f9ce2a3, 0xc01b171c,
    0xbf998f63, 0xc0806075, 0x3fe6a1b5, 0xbf02c8bf,
    0x3e9f0d65, 0x403c6274, 0xc03a46b9, 0xbea3d370,
    0xbff0b072, 0xbf0275f0, 0xbf553ae9, 0x4000af21,
    0xbf7194bb, 0x3fc5f464, 0xbff1a0da, 0xbfdeb95a,
    0xbfaadac0, 0x400598f7, 0x3f22f793, 0xc024dff4,
    0xc01e908d, 0xc02c8834, 0xc08f2356, 0x3fcd98e6,
    0xbe52be65, 0x40993f01, 0xbf8d24fe, 0xbfa8c691,
    0xbf8fca94, 0xbfa0bb19, 0x3f558cd5, 0xbff9ec0f,
    0x3fbc50aa, 0xbf49a73b, 0x40046b80, 0xc0014275,
    0x3f392fc5, 0xbfb7a1a7, 0x40535b4a, 0x4045b32c,
    0x3f5b81da, 0x3c8be26a, 0x3fc23dac, 0xc018fb8f,
    0xbfb8ee1e, 0xbf8b64ea, 0xc034b473, 0xbf965afc,
    0x3e3db21d, 0x3fb9a913, 0xc0c2080e, 0x3fa779d2,
    0xc00b97fd, 0x3f844a4f, 0x3ff5d748, 0xbf985f7e,
    0xbfa54ba9, 0xbf952d27, 0xbf44c87e, 0x3f8742fb,
    0x3fc11d28, 0x400ae86a, 0x3f420852, 0x400550d1,
    0x3f7666d7, 0x407e10d9, 0xbfdef514, 0xbff02e94,
    0xbefb7245, 0x3fe4ae87, 0xbedaf5ad, 0x3fb9d5fb,
    0xbf1c81e3, 0x3e535ecc, 0x3f2039e9, 0x3f8677b4,
    0xbf084810, 0xbf97505c, 0xbf71c2cd, 0xbccc25fc,
    0x402c4938, 0xc0200f3d, 0x40dcc7af, 0xbd5d73b0,
    0xc02b65b5, 0xc055cab9, 0x3f7e1807, 0xbf814ccc,
    0x3fb490fa, 0xc000e4fa, 0xc01bf5dd, 0xbf793fb7,
    0x407a0f8f, 0xbf6a1203, 0xbf3cc1c6, 0xbf8c60d0,
    0xc0142c72, 0x3de321e8, 0xbf0024d9, 0xbfd8e1c3,
    0xc04f3936, 0x405be84b, 0xbf2b003c, 0xbf3bfa08,
    0x3ead703c, 0x3f620efe, 0x3f9b4a4f, 0x3fae52d9,
    0x40996a56, 0x40282169, 0xbf1b9715, 0xbd9e196a,
    0x3e9030e8, 0xbfb009ee, 0x3e233152, 0x3ed44577,
    0xbf4ba9b3, 0xbe2c0626, 0xbff0b409, 0xbf9e9b84,
    0xbf997e15, 0xc0176ed5, 0x40039307, 0xbf1fde3e,
    0xbdc716d3, 0xbfbb3532, 0x40377b05, 0xbe2a032a,
    0x4001ae24, 0x408ca9e6, 0xc059fd98, 0xbfdd8ac7,
    0xc08536fc, 0xc04d6b20, 0x40b79bde, 0xbf1ecb52,
    0xc08f02c6, 0x3f05e9f7, 0xbf795b80, 0x401e9da9,
    0xc0181f08, 0xc00fc724, 0x4084e8c0, 0x3f051274,
    0xbe6a7ae2, 0x3ffba088, 0x405da616, 0xc002eb82,
    0x3a03e6a7, 0xbfe8c232, 0x3f8e368d, 0x3d8f9658,
    0x3ed7be1e, 0x3e1b2445, 0x3f8e61a7, 0x3ffa820d,
    0x407c72d8, 0xc0275bb5, 0x4012b659, 0xc0283cf3,
    0x3fb3fd04, 0xc085cd5e, 0xbf2a6a83, 0x402870ea,
    0x3f670a05, 0x4026e86b, 0x4084eb49, 0xbf0f362c,
    0x40946c88, 0x3d0dbcaf, 0x3fdb5863, 0x40292f2b,
    0x4028a915, 0x3f215d69, 0xbff4a725, 0xc0f42dbd,
    0xbe92a005, 0xbf13dc55, 0xc0d2554c, 0xc05d5155,
    0xbefe83dc, 0xc04a4875, 0xbffd7d1f, 0x4088d10d,
    0xbdd3e86d, 0xc05f9306, 0xbe0dd6bc, 0xc066c9fc,
    0xc01c6c35, 0x3f86d6dc, 0x3fccba10, 0x3fd36d11,
    0x3f68cf6b, 0xbfc21170, 0xbee2c5e2, 0xbf4f1886,
    0xc05a5f16, 0x409240a6, 0xc07ccce0, 0xbf73a793,
    0x40b8e89c, 0xbb489358, 0x4037eb5c, 0x3eccba9f,
    0x3ffe8d80, 0x3ef3b0f8, 0xc085ad90, 0x40603610,
    0xc01591e6, 0x3f41c2bc, 0x4024d8d8, 0x40061a79,
    0xbf7f7de0, 0x3efe5413, 0x40902699, 0xbff34310,
    0xc02b6a97, 0x4075f7bd, 0x3f2ee9d7, 0xbf5aec42,
    0x40b5d74a, 0xbf73be1d, 0x4013e9c2, 0x4083d213,
    0x3df8de66, 0x3f54e63a, 0x3ff08dc8, 0xbfe32042,
    0x400bce6a, 0x3fdb6068, 0x4066dfad, 0xc00cc841,
    0x3fd34600, 0xbfbe48ad, 0xbf8a1a4d, 0xbf996b35,
    0xc0069772, 0xc007269a, 0xbf5ce1a0, 0x3f93fd0d,
    0xbfbf8b0e, 0xbf5caae1, 0xc06af9b2, 0xc052f641,
    0xbf0434c4, 0x3e6eee3c, 0xbe3d6716, 0x3f7db6d0,
    0x3fe0d2dc, 0xc015222e, 0x40938233, 0x401c23a6,
    0x4063dbd4, 0x4028da80, 0xc0012e02, 0xbfaa6be8,
    0x3db4e9de, 0x3ec4ebdb, 0xbf96976a, 0xbc6672f1,
    0x400380dc, 0x40091571, 0xbf15ccff, 0x403d33fd,
    0x3f71b241, 0xbf00c176, 0x408116e3, 0x3ffe141c,
    0x404bbcb4, 0xbcbb217c, 0x3f333102, 0x3fea947d,
    0xbf899acf, 0xbf8af2e9, 0xc07d5e9c, 0xbfef8d7c,
    0x3ebef07c, 0x3df1992e, 0xbf4432b0, 0xbfba34cf,
    0xc06d09cc, 0x402ddc91, 0xc04be71a, 0x3f8ecc45,
    0xbd04cc0f, 0x3ffa40d8, 0x3f91bf02, 0xc06178ee,
    0xbfaa8818, 0xbf837943, 0x4070e5db, 0x3f826f41,
    0x408047ad, 0x4012b2e3, 0x3fa66545, 0xbffe71a8,
    0xbfc38abb, 0x3f73d27c, 0x3e9ad015, 0x4029ee4a,
    0x3fd99ebd, 0x3e9dad45, 0xbf85575b, 0xbebca624,
    0xbfb75e19, 0x3fcc52e4, 0xc0143026, 0x3fd508b7,
    0xbfab122e, 0x4087730f, 0x40398ad0, 0xbf888d69,
    0xbf0f6e35, 0xbf972b61, 0x3e836078, 0x3c96bb12,
    0x40c31f71, 0x3f4b9aa1, 0xbf784b9e, 0x4072c451,
    0xbea92195, 0xc0267786, 0xbf05aca2, 0xbf998d31,
    0xbf6bbe99, 0xbfa80325, 0x3f723ea4, 0x3e826fbb,
    0x3d9435d8, 0x3fd64cef, 0xc008e383, 0x400bea30,
    0xbe9220b7, 0x3f9c0a6d, 0xc0206248, 0xbfac6e9f,
    0xbe76ab6e, 0xbf2829f3, 0x3fb9a07d, 0x3f9c5c4d,
    0x400b005f, 0x40429a85, 0x3e8c463e, 0x407317cb,
    0xbe8962c2, 0x3f6b5eae, 0x3fa63e83, 0x3d91f67b,
    0x3e1e8b4d, 0xbfe48766, 0xbed45a90, 0xbf5a69c7,
    0x402a8137, 0xbfd50eb1, 0xc002b0c4, 0x3f9ead8e,
    0x3a1d4a90, 0x3f216b09, 0xc0085c63, 0xc0aeaec2,
    0xc05e3042, 0x3dfea28a, 0x3f38ee6f, 0xc063a0b2,
    0xbf590278, 0xc0851865, 0xc03bdf9d, 0x3ff3e975,
    0x407bcc0a, 0xbd026421, 0x3feab86d, 0x3bd0694b,
    0x3e71a95d, 0xc004920f, 0x3e8de8ec, 0xbe943aca,
    0xbfcc6639, 0x39cc25e6, 0xc03d2585, 0x3ebea36c,
    0x3f1f3e06, 0xbf516f1f, 0x4028a32e, 0x3f7e046d,
    0xbeb57dc9, 0x3fc2f999, 0x40af91fa, 0x3fc058b3,
    0xc006d8aa, 0xbf2055e0, 0xbfab39b4, 0xbfcf6fcf,
    0xbdd744e0, 0xbf89a705, 0xc032e1e6, 0x3e54591d,
    0x3ff55434, 0xc001a142, 0x3f12a9e3, 0xc040cee8,
    0xbf771128, 0xbfc3461d, 0x4086e9fa, 0xbf22a1b7,
    0xbfbf30b6, 0xbfa8f514, 0x400fabc9, 0xbfd1c174,
    0xbf2b81ed, 0x4082a51d, 0xbfe360eb, 0xbf19c2b3,
    0x3f6babd8, 0xbff1d860, 0xbef3df9d, 0xc0682885,
    0x3e10eed8, 0xbf6d73fd, 0x3fc4566d, 0x4052f0f5,
    0x3f7a146e, 0x407eda76, 0x3f3556f3, 0x3fc483cc,
    0xbe0b5477, 0x408d7eef, 0x4072e18c, 0xbf39fcc1,
    0x3f4108c3, 0x3f9a53ca, 0x402f554c, 0xbeaabfa5,
    0x40221199, 0x3fe78e7f, 0x3fcb887a, 0xbffabf19,
    0x3ea85396, 0x40948927, 0xc04f31c9, 0x3f4092d3,
    0x3fbac73c, 0x402268c1, 0x3fd982c7, 0x3f7ed1b1,
    0x3f2b610a, 0x402f495f, 0x401a87bf, 0xbec50537,
    0xbe843047, 0xbf93b42f, 0x3deab844, 0xbf151e31,
    0xc02089a6, 0x4021cb7d, 0xbf8fdd01, 0x3fbfc27e,
    0xc04958d7, 0xbffdc498, 0xbf843df4, 0xc03196c3,
    0xbfabe53d, 0x406dfeb2, 0xc04ce374, 0xc01f9307,
    0x400787d0, 0xbf873871, 0x3f8293b1, 0xbef660fc,
    0xbf4dce54, 0xc047bd58, 0xc024022d, 0xbf4135e6,
    0xbf57d3e5, 0x404a5148, 0xc08d39da, 0x3fbcb740,
    0xbf82bd8f, 0x3ebc043c, 0x40a9eca1, 0x3f197b81,
    0xbf1b9cce, 0xbfdd24a0, 0xc032043d, 0x407a53d4,
    0xbd54912e, 0xbf86d2fe, 0x3d989ae1, 0xbf440800,
    0xc02b75b6, 0xc067bedd, 0xc00ec78b, 0x3e50fd77,
    0x3eac7162, 0x408b8c20, 0xbf256351, 0x3fb75094,
    0xbf91b63b, 0x3fcb1621, 0x3e2f6b95, 0xc0160f2f,
    0x3c0ed05a, 0xbea6dc67, 0xc014a42a, 0xbfa8b5fa,
    0xbf6d23c4, 0x40097f70, 0xc027f366, 0x3f187a94,
    0xbfa073aa, 0xbf473d80, 0xbf1af1e5, 0xbfbdea6e,
    0xbf3e874d, 0x3ea8e75c, 0xbea61940, 0x40492324,
    0xbe9c17e4, 0x3d89cbc3, 0xbfd4352b, 0xbf362406,
    0xc07989ec, 0x406fbbd0, 0xbfe717d8, 0xc08e7fe5,
    0x3ee8d9a5, 0xbfd8e926, 0x3bfe51f0, 0x403b413a,
    0x403c3d12, 0xbf86c315, 0x3eb5625a, 0xbfcb9c16,
    0xbf458dd6, 0xbe2381be, 0x3ed4b6e9, 0xc072ace7,
    0xc04c6027, 0x3fbcab04, 0xbf907755, 0x3fa3cec3,
    0xbfbfd894, 0xc0a77b74, 0x3f978e4c, 0x3fd262de,
    0x3f95c2c9, 0xbf7a8ff4, 0xbfada8ac, 0x400ee8fa,
    0xc0340134, 0x3d3089c9, 0xc06e86fd, 0xbebcb76c,
    0xbfc39a58, 0x3f040750, 0x3f74a1c6, 0xc0264664,
    0xbdb44ef7, 0x400e0c2c, 0x3f17ea46, 0x40014773,
    0xc0285ce6, 0xbdb72b74, 0x3fcb29f2, 0x3f6a866a,
    0xbf834284, 0xbf8cbfcd, 0xbffa43ca, 0x3fa3d0f0,
    0xc0954877, 0xbfe378d3, 0xbe1bcde2, 0x40032995,
    0xbec060ed, 0xc00c3ff9, 0xc02a2039, 0x3f901c93,
    0x3f523ba8, 0x40479c16, 0x407919d5, 0xc0407085,
    0x3fb04af7, 0x40000b5e, 0x4085997e, 0x408f3630,
    0xbf0e1e66, 0x400b54da, 0x3fd4c3cc, 0x40b4fe76,
    0x405f1e1d, 0x3fd81fb7, 0x3fe9d790, 0xc018adde,
    0xc01a74e8, 0xbf4d00a2, 0x401e4597, 0x403558c6,
    0xc038fa7c, 0x3eeea68f, 0xbf412fc8, 0xbf8d7c6e,
    0x3f633d32, 0x3f2b85fc, 0x40027fe3, 0xc08539a5,
    0x3fac8aa1, 0xbfe7c62f, 0x3e719295, 0x4005306a,
    0xc01f49d8, 0x3f91ca18, 0x3e8cd8b4, 0x408da4e2,
    0x3d4f1a5b, 0xc033dbda, 0x3fed26fd, 0xc034f6ee,
    0xbf60b39e, 0xbf3bcbbf, 0xbc31a81d, 0xc00ded23,
    0xc09c2d7c, 0x3f94bf06, 0xc0390477, 0xbf2ca624,
    0x3f8b107d, 0xbfed3eba, 0xc04ee823, 0x3f1fbf04,
    0x3ecb32c2, 0x3f991d5b, 0x402bd69c, 0x4031324e,
    0x3f652a5e, 0x400ce541, 0x40b20b75, 0xbf9b4c85,
    0x3f08c2b5, 0x3f99aa06, 0x40642f70, 0xbed70881,
    0x3f409bc8, 0x3f11fcf7, 0x40319405, 0x401199fd,
    0xc05a5512, 0xc032a8c7, 0x3f2481d7, 0xbfe63120,
    0xbfcb5d0f, 0xc054c9b0, 0xbfe10885, 0xc00ba52c,
    0x40825ec4, 0xbff21ed5, 0x3fa04c0e, 0x4018a45b,
    0x3ff152f4, 0xc056f77b, 0x3f84fa21, 0xbf36d4c5,
    0xc0036ea3, 0xbf35c237, 0x400c4df4, 0xbe578263,
    0x3ffa989b, 0x408e1899, 0xc0324895, 0x3ef222f9,
    0x3f9681b7, 0xbf46e8a6, 0xbf163960, 0xbdb98c0b,
    0xbf72b6fe, 0x3ffa1ec8, 0xbffd35bb, 0xbfd05797,
    0x3fe74312, 0xc0045818, 0xc01251a4, 0x4032e947,
    0x3f9aa786, 0xc00489d8, 0xbeb655f4, 0xc02aab8d,
    0x401a8b69, 0x3f6bce9d, 0xbddacfdb, 0xc08acfe6,
    0xbdf302fa, 0xbfa84569, 0xc084b7f6, 0xbfd533e8,
    0xc0137a46, 0xbfe5433c, 0xbfa760b0, 0x4054fa28,
    0xc015fc52, 0x3f9ae720, 0xbfcd52ad, 0x40225c6a,
    0x4015772d, 0xc033888a, 0xbf4ec3eb, 0x40273b0f,
    0x3f610f3c, 0x4047d985, 0xc057485c, 0xbfa2127a,
    0x3f5f8776, 0x401b985d, 0xc04cfe43, 0x405bd588,
    0xc010d2a7, 0xbdb29d63, 0x3f71c0bd, 0x3dcd8936,
    0xbec345e5, 0x40165a58, 0x3f632196, 0x3f2823b0,
    0x4058298a, 0x3e704f43, 0xc04b631d, 0x401a7d9b,
    0x40008b51, 0xc021b4a4, 0x3f33f14e, 0x407b0f07,
    0x3ef49bc2, 0x3f6fadf2, 0xbfe8d01e, 0x3ea1368c,
    0x3f16bd6b, 0xbfa8214c, 0xbf9cbdcb, 0x40685116,
    0xc0711ae4, 0xc01c1f17, 0x3f4ff601, 0x3e7b47df,
    0x3f260c2b, 0xc05a991e, 0xbf9a36cc, 0xbf6b306b,
    0xc0322a18, 0xc00f8530, 0xc02e2781, 0x3feea86a,
    0x402ab5e3, 0xbf305831, 0x3e95fa9e, 0xc03e78b9,
    0x3ff1594b, 0x3f426d14, 0x408c7756, 0xbf4c1729,
    0xbe948f75, 0x3f7cd9c9, 0xc0a78ced, 0xbfca7253,
    0x401a3b07, 0xc02745b6, 0x3f9a2f83, 0x3ff1dde3,
    0xbe922373, 0x40278781, 0xc007303d, 0xc08d2faa,
    0xbec1a5c3, 0x3f129df2, 0x40a3e3fd, 0x407ada76,
    0x40437b57, 0xbfc18640, 0xc0930804, 0xc019da5b,
    0x3fc801d8, 0x3f310fef, 0x400c17ad, 0x3fff3dd5,
    0x3ecf64be, 0x408d906a, 0x4033c997, 0x4063c08b,
    0x3feef5ca, 0xc00f8c63, 0xc04df3d5, 0x400eec87,
    0x405cc6d4, 0xc044dd03, 0xc095396a, 0x3fed4f6f,
    0xbdafffde, 0xbf2359e4, 0x3f24e4bd, 0x401820a8,
    0x3ed7402a, 0x3feae0f0, 0xbfe5674f, 0xbf70e02f,
    0xc09d7e03, 0xbf899f1b, 0x3fb93c53, 0x3f0033a1,
    0x3d57e102, 0xbd00403f, 0xbf7023e4, 0xc001444c,
    0x408e7c5e, 0xc0205314, 0x3da07e63, 0xbf77914d,
    0x3fd91e62, 0xbe976e08, 0x3faafba0, 0x3fb8318a,
    0xbfeecadc, 0xbf85fc33, 0xbf9afffc, 0xbf8695b0,
    0xbe3cc4db, 0xbe1c14a8, 0xbf3b83b8, 0x3d00611b,
    0x3f0e4248, 0xbf924fd8, 0x3e8552f9, 0x4058f502,
    0xbf234057, 0xc0483fca, 0xbd297dfa, 0x403ce727,
    0x3f3c0724, 0x40167cc4, 0xbf1255f0, 0xc0317f35,
    0x40b76e9e, 0x3f009727, 0x3f8ff09d, 0xbfd228ec,
    0xc003950f, 0x3f62d804, 0xbf1f4459, 0xbfc0fc53,
    0xbfa74014, 0xbf8e763d, 0xbf825035, 0xbff4400e,
    0x3f4a0ac8, 0x3fca4fc8, 0xc02f0949, 0x3e740a12,
    0xbfd693a7, 0xc0620ac8, 0x401fea5e, 0xbe426ba8,
    0xbf211da8, 0x3fa3b418, 0x3f00642a, 0xbee5eda3,
    0xbead61d8, 0x3fc3337c, 0xbe935f0f, 0x3e72eddb,
    0x3f876d56, 0x4020ca20, 0xc01359ec, 0x3e867fd2,
    0xc04d7019, 0x3e7baf5e, 0x3f0ae256, 0x3f0ea8cb,
    0x3fea7af2, 0x3f0baa65, 0x4011ce3b, 0xc047b2b2,
    0xc0204f8d, 0xbf742eb4, 0x3ffa895a, 0xc09456c6,
    0x3fd68c6a, 0x3fa05556, 0xbfa6280f, 0xc092f514,
    0xbd99d9bb, 0xbfe1a5f0, 0xc073c9d2, 0xc030f4f8,
    0x3f61dd63, 0xc0e9a7a1, 0x3f7042cb, 0x405b67de,
    0x40679bac, 0x3ef375a7, 0xc00addc0, 0x3ea47085,
    0x3fc96628, 0xc0395820, 0xc0251cb6, 0x3f7db6a0,
    0x3fe5b017, 0x3fed96c7, 0x400292f9, 0xc09de68b,
    0xc00bdad7, 0x3e7c2b62, 0x3fa3380c, 0x3dccc1fc,
    0xbf7188fd, 0x3fa1612f, 0xc0aa23d0, 0xc06d26ba,
    0xc0b54397, 0x4009868c, 0x3f6229ad, 0x3e2ff2f3,
    0xbead8764, 0x3e84cdf0, 0x3facdb38, 0x3f625e69,
    0x406905ae, 0xc0159c99, 0xc0b491ca, 0xc0104480,
    0xbfc7c6d5, 0xc0180a21, 0x404b1519, 0xc087647a,
    0xc009414e, 0x4026ed58, 0xbe04bcac, 0x4044c97b,
    0xc01beec5, 0x4005a373, 0x3e288357, 0xbeb3d563,
    0x3ef44ff2, 0x3f9c4d84, 0xc09ff609, 0x3cd1a088,
    0x3f066839, 0xc043077d, 0x403e1c97, 0xc04161f0,
    0x3fa85f4b, 0x3f115456, 0xc0397636, 0x3ef2e117,
    0x3f9d38c4, 0xbec3578e, 0x4026b14f, 0xbda08750,
    0x3fe7a6af, 0x402369e8, 0xbfa16d9b, 0x3f730d48,
    0x40764e63, 0xbfc2cb86, 0x40209425, 0x4000bb3d,
    0xbfb5c10b, 0x3fc5c71f, 0xbf9fe6fc, 0xbb2d9bfe,
    0xbfd99c6e, 0x40192b72, 0xbefc4eac, 0xc0cdc76b,
    0xbf55bd0f, 0xc0076a3b, 0xbfd1753f, 0x400ede6d,
    0xc059c031, 0x3de1a827, 0xbf8be779, 0x4017ca84,
    0x3f2c928e, 0xc088e77f, 0xbe35cbbe, 0x400906a6,
    0xc01cdb38, 0xbee76dfd, 0xc00ccdac, 0xbf9d95a9,
    0xbf0675d5, 0xbeda59c2, 0xbf9debcc, 0x40ca4146,
    0xbf9b2ed6, 0x408a66a0, 0xc0078f19, 0xbf8a7755,
    0xbffbb79b, 0x40981643, 0x3f2f7dfe, 0xc04be464,
    0x3e07f4f0, 0x3ea1cb3e, 0x4052aa21, 0xbf3b0cad,
    0x3d7eaafd, 0xbff35983, 0x402c1fb9, 0xc0a432e2,
    0x4042a051, 0xbe5506ff, 0xc03f860f, 0x3dd81c97,
    0xbdca3eed, 0x3f55a215, 0xc0263881, 0xbecc789e,
    0xbf4fdadf, 0x3d8f0624, 0xbf81da89, 0xc01924ce,
    0x3f5d5200, 0x3e2df88c, 0xc018174b, 0xc02be0e9,
    0x3fc757e8, 0xc0947321, 0xbf93a61c, 0x3fcf394f,
    0x3f553ebd, 0x403b5c41, 0xc0146c79, 0x3f2d6227,
    0xbec1f81b, 0x3e574545, 0xbfce65ba, 0xc07277b4,
    0xbfdb52f6, 0x4065d259, 0x3f1b7164, 0x3ef0ffb2,
    0xbfd0e053, 0x3f89f77a, 0xc01b278c, 0xbdd08856,
    0xbf0a45f1, 0xc06e8b4a, 0xbf11b9b1, 0x408c6fb9,
    0x3fdb5695, 0xc008cae0, 0xc0407b9e, 0x40124e56,
    0xbe662a3a, 0x3e24de2e, 0xbf668f65, 0x40458440,
    0xbf7bf2db, 0xbffbd00c, 0xc048e73f, 0x3fd176ba,
    0x405bb741, 0xc02a488a, 0x3f7b0f9c, 0x4098475a,
    0xc0b31d64, 0xc055cb52, 0xbf1703cb, 0x3f92e9c4,
    0xbfc664cb, 0xc09990b9, 0x3ee148ec, 0xc08a11d9,
    0xbe204b76, 0x3fa9cf4a, 0xbff34ce4, 0xbe814fdb,
    0x3e6cb846, 0x400e1571, 0x3fb16203, 0x3f3a24fc,
    0xbd26b16a, 0xc01a86c6, 0x3f1e4377, 0x3e4a5327,
    0xc035f43e, 0xbfca586c, 0x4010534e, 0x402d6d4a,
    0x3eb2b254, 0x40239452, 0xc08cd619, 0x403c818b,
    0x3f814386, 0x3e213cc5, 0x3f550325, 0x3fd8fdde,
    0xbe2083bf, 0xbf448367, 0xbf9af01d, 0x408c7c19,
    0x3fd9b185, 0x3eaf8419, 0x3e955857, 0xbf23f00b,
    0xc047ba3b, 0x3fcacf89, 0xc033fca8, 0x405b3469,
    0xc05eadeb, 0x3f32ecfe, 0x3fa48ab3, 0xbf0f8a8e,
    0xbf9d49cd, 0xbd8e0ef0, 0xbe42741d, 0x40492b38,
    0x40929c74, 0xbbb72b82, 0xbf0282a1, 0x3f9643e4,
    0x3f594fd2, 0xbff8a361, 0x3fee8ef2, 0xbff36c15,
    0x407df677, 0xbead5149, 0xbf5e865c, 0x3f8d3b88,
    0xbf90f3b9, 0xbed2b9cb, 0xbffa410f, 0x3fa2fa14,
    0x40831c26, 0x3f8e4990, 0xbf5e4c49, 0xbfc9ddfb,
    0xc0178195, 0xbf63019d, 0xc01b0bc9, 0x403b7a80,
    0xbd86cb8d, 0x3f87497e, 0x3fb60c5a, 0x3f450711,
    0x3fb3632d, 0x3fabc305, 0xbf92f6e5, 0x3e58e9eb,
    0x405ac17e, 0xbfa5c0da, 0x3e9ea182, 0xbf2ce64a,
    0xc0118a7b, 0x3dfc83b8, 0x3eccc644, 0xbf65fb59,
    0xbf7abefd, 0x3f2d9166, 0x400d191f, 0x3eb40338,
    0xc03d2067, 0xbff04710, 0x3df672da, 0x3f9b20ea,
    0xbf0d5dff, 0xbf9f44b8, 0x3fab3318, 0xbfeac7a4,
    0xbf8d9223, 0x3eb02b12, 0x402f7124, 0x402870d3,
    0xbfd0de84, 0x407131fc, 0xbfb32e32, 0x3fa63abf,
    0x3fc7f511, 0x405425ae, 0xc00c1d02, 0x3fef561f,
    0xc0349398, 0xbfec8d3a, 0xbfcce61d, 0x3fc31937,
    0x3f7cd7ee, 0xbff1a9a8, 0x40341716, 0x401b4377,
    0xc0334d3b, 0x4085f8b5, 0x3f0073bb, 0xbcc3c150,
    0xbf4d97ba, 0x404bb7cb, 0xbed3abd7, 0xc094a05d,
    0xc01daf1e, 0x3f856656, 0xbd65fe0c, 0x3ef07f02,
    0xbfd92958, 0xbf7445c9, 0x3f083ada, 0x3fa4774e,
    0x4029699f, 0xbf131365, 0x3efc4c98, 0xc01ed5f4,
    0x3f166d42, 0xc0199416, 0xbf5ede52, 0xbf8c394e,
    0x40044494, 0xbfc4264b, 0x402d6b8a, 0xbf7e84b8,
    0xbfd8887a, 0xc002acbc, 0xbfa265fc, 0xbf706c6e,
    0xbf7bcd9d, 0x3fd5fc8f, 0x3ff60187, 0x3e86cdba,
    0x3fbb04cc, 0x3fdfc2a3, 0x4047cd0f, 0x4025fe80,
    0x3f809835, 0x40258e06, 0xc0747e6f, 0x404031d4,
    0xbf52d444, 0xbf46c913, 0x400b6d6c, 0x401e5cc0,
    0xbed476a3, 0x3fb6dc90, 0xbf0ca0d5, 0xbf5e00ad,
    0x4025c22d, 0x40649616, 0xbf0eebcd, 0xbde0ed29,
    0xbe279d04, 0x3fdfadaa, 0x3f61debb, 0x3f699ce0,
    0xbf9a5bb7, 0xbfaa9285, 0xc0aa7386, 0xc02124ca,
    0x40252577, 0xbf2e3af2, 0xc08aefc3, 0x3f30893a,
    0xbf8308ea, 0xbfbd1c19, 0xc017e4a0, 0x3f732048,
    0xbf02c9ee, 0x4056dec5, 0xc052c087, 0xbf55da02,
    0x3f8534b3, 0x407c8101, 0xbe9e4c52, 0x3f6d3a1a,
    0x3fc807c9, 0x3f0a1d50, 0x3fedb165, 0x40701817,
    0xbf6ccec0, 0x401ded4e, 0xc041afec, 0x40197e0c,
    0xbff27a88, 0x3e858b1a, 0x3f5112e9, 0xc06fbb1d,
    0xc07be350, 0x40630423, 0xbf382058, 0x40af6680,
    0xbf6aa638, 0x401d61af, 0x3e9c19fd, 0x3f66fa5b,
    0x40345996, 0x3f4c55b7, 0x3f8fda48, 0xbe48786e,
    0x4013cdf9, 0x3f8a5a2a, 0xbf6d65fa, 0x40a9cc5c,
    0xc01145ce, 0xbeff7ff8, 0xbfd33dc7, 0xbd39651a,
    0x4089b350, 0x4045504d, 0xc001317b, 0xc0789f4c,
    0xbfcf0d46, 0x3ffcc643, 0xbfab94a0, 0x3fc150e5,
    0xbf01c961, 0xc0ab148b, 0x409b4f0a, 0x3e4ccd30,
    0xc01cda3e, 0xbf6c1416, 0xbd946126, 0x3f6d6281,
    0x40119c09, 0xbfabfc1d, 0x4006ddce, 0x3feb7201,
    0x4032f3a8, 0xbee6aae4, 0x3f2e5362, 0x3f277b32,
    0x3f390e29, 0xc02216d9, 0xbf06ef68, 0xc01f5d30,
    0x40c4e1d3, 0xbf46e778, 0x4047cde1, 0x3fdca6be,
    0xc00770be, 0x3ced9e01, 0x3f848546, 0xbd8555a2,
    0x3f0d52f4, 0x4076bc90, 0xc03ced90, 0xbfaf136d,
    0x3fa25bd4, 0xc09463a0, 0xc01cfc1a, 0xbffa4f53,
    0xbf39a2c8, 0xbd4dbfbb, 0xbfa602ad, 0x3e88ebf5,
    0xbf839bd0, 0x3f9592c8, 0x403e2913, 0xc076ec7a,
    0xc00ab56e, 0x4071f5a3, 0xc0124c96, 0x40a26ea8,
    0xbf6ccd7b, 0xc0584e98, 0xbf34cdd5, 0xc049cb96,
    0xc0179199, 0xc003a744, 0x3dae2346, 0xc01780cb,
    0xc08d1985, 0xbfe1108a, 0x3e916218, 0xbfc47c5e,
    0xc059e6a7, 0xc011cd0a, 0x3ff9f36a, 0x4042dc64,
    0xbfff590a, 0x3e5384ea, 0x4084e76f, 0x3f31c633,
    0xbefe172a, 0xbf7c9501, 0xbf87891c, 0x3fbca53b,
    0x40b13284, 0x3e622f61, 0x40079d0b, 0xbf4ffaae,
    0xbf43fab0, 0xc016d98d, 0x3e0c9ec1, 0xc03c423c,
    0xbfcc992c, 0xbea59a7b, 0xc008dbec, 0xc0b5d891,
    0xc0da949a, 0xbf024661, 0x408b34c8, 0x4032e398,
    0xbf921c3c, 0xc02d5203, 0x3fffeca3, 0xc054478b,
    0x403f2486, 0xbfec1041, 0x3f9b871b, 0x3f015faf,
    0xc098f8e4, 0xbf28dd13, 0xbd21c7e6, 0xbfccf8d4,
    0x3f80c981, 0xc01a7484, 0xc0003aa9, 0x3f0f276c,
    0xc09b6b25, 0xbf7f5d14, 0x3f21a86a, 0xbfb5c60d,
    0x401145b1, 0x40347872, 0x406cd320, 0x3f9f519f,
    0x40b0573c, 0xbfa7858a, 0xbfad14df, 0x40594a6a,
    0xc05b3464, 0x3f80681c, 0xc0157dbd, 0xbf1dc9c5,
    0x3f76611e, 0x401d31ce, 0x40866e93, 0xbfc1f316,
    0x3d1757cf, 0xbe9a67d3, 0x3db31cab, 0xbf71b395,
    0xc00b1c2f, 0xc02e1ba8, 0xc00e3c7d, 0x400918fc,
    0x3ed53e2e, 0xbfecefdf, 0xbfbd7622, 0xbfdbd38b,
    0xbef58296, 0xc040f430, 0xc069b8c8, 0x3f5025ce,
    0x402b115a, 0x403962af, 0xbf946d3a, 0xc0312849,
    0x409c2329, 0x3f2862b9, 0x4013d3bd, 0x40053087,
    0x404c3516, 0xc019f18b, 0xc08903e3, 0xbf9e6203,
    0xbf9a0f7f, 0x3eb29a91, 0xbf685ec8, 0xbf49a557,
    0xbf6b695f, 0xc02d7484, 0xc027980d, 0x4088471b,
    0xbfdcde60, 0xbfb2525f, 0xbfbe4e73, 0x3f7ab8a7,
    0x40022d4b, 0xc02b8f15, 0x3ea21d4d, 0x40957c26,
    0xbe124696, 0x3f9e1936, 0xc056770b, 0xbfb02f18,
    0x4027ba65, 0xbf64acab, 0x3bd943da, 0xbf83bf46,
    0xc055b1c3, 0xbfa984df, 0x3e19eb89, 0x3ff2876f,
    0x3f204d0c, 0xc011a5aa, 0x40084217, 0x4026be9f,
    0xbf3b3462, 0x3fd6f11d, 0xbfc8f20a, 0xc00be08d,
    0x3f3bc68d, 0xc01dab3f, 0xc071dbdc, 0xbef3878a,
    0xbfafbae2, 0x3e3c372d, 0xbf4af429, 0xbf34821c,
    0xbe80560a, 0x3f2df3a9, 0xc06e2172, 0x3eedd6ed,
    0x3d0b7ff7, 0xc021372f, 0x4073c150, 0xc08146b5,
    0x3f2c0c12, 0x3e9c26d3, 0xc00d816b, 0xbef0acc0,
    0x3f7987c2, 0xc00d7b77, 0xc0c290ff, 0x4080a6f1,
    0xc00c3851, 0x3e92d8b4, 0xbf06fce7, 0xbff85ea0,
    0xbf734137, 0xbd812f00, 0x40958126, 0xbfa9b782,
    0xbe24fe5b, 0x3fd42631, 0x3df938da, 0x3fd70536,
    0xbe63efaa, 0xbf26d404, 0xbfc9420b, 0x4011f2e3,
    0x3f17b021, 0x3fc4310c, 0x3f61e528, 0xc08ae0f3,
    0xc0154e62, 0xbe83e3e3, 0x3f5d5f9e, 0x3fbefbbd,
    0x3f03ec81, 0xbc05d1a1, 0xc0195abf, 0xbe2d38a8,
    0x4053640e, 0xbfc151a9, 0xbe0dcb16, 0x3f78fc64,
    0xc05a113e, 0xbf1fa8a3, 0x40379547, 0xc0270d99,
    0x4096bf55, 0xbfe31e46, 0x40404e6a, 0xbfc475fc,
    0x3f83ff4a, 0xbf48baf4, 0xc010e3e1, 0xbf8b686a,
    0xbfd8c10f, 0x4003a4de, 0xbfb9bd7f, 0xc04ed784,
    0xc03fc751, 0x409620c0, 0x3fab8c9d, 0xbfec01aa,
    0xbf7dc87c, 0xbf22212e, 0xbc265bc7, 0xbee426f2,
    0x40422fd0, 0x3f71745c, 0x404ac121, 0xbf1dc1d4,
    0xbf8c8616, 0xbf750d15, 0xc02abf7c, 0x4073e73c,
    0x400a511c, 0x4001ba69, 0xbf94f31f, 0xbf6996b8,
    0x4091fb4b, 0x405c3f45, 0xbe73029a, 0xbf438543,
    0x3fffff31, 0x3f9cafb2, 0x3fcb842a, 0xbdd9cd59,
    0x3f13f851, 0xbec0c5fd, 0x3f77f354, 0xc067150b,
    0xbf1d1ab5, 0xc0061468, 0x40625b33, 0x40599dda,
    0x4046867d, 0xbfebd723, 0x3f86bca1, 0x400d4193,
    0x4048bbad, 0x3fbb7485, 0x4092505b, 0xbf7a9734,
    0xbf452ea4, 0xc070c77a, 0xc09091d6, 0xbf385e11,
    0x3f219c27, 0x40895bdf, 0x3e305ae1, 0x40008670,
    0xbf1625e3, 0xbf914bf5, 0xbfdc15a8, 0xc02437dd,
    0xc016d360, 0x3f89e1b7, 0x3e79950d, 0x400e13bc,
    0x3fc55870, 0x40836196, 0xc02bd4b5, 0x40d4af98,
    0x3fc3a4d4, 0xc0a2f332, 0xc0479727, 0xc05a05fa,
    0xc033b2f8, 0x40622181, 0x401828bb, 0x406ac8c2,
    0xc071868b, 0xbf9e2e5b, 0xbfba32c9, 0xc07bd6fc,
    0xbfe9f899, 0xbf3811cb, 0xbeebf279, 0x3fc50413,
    0xc010dfdb, 0x4007b7c0, 0xbe9235c4, 0x3f5760c6,
    0x40a78296, 0x40190789, 0xc01deac1, 0xc0292a72,
    0xc018fe51, 0x3f8734b7, 0x4004449b, 0x404422ef,
    0x40983f7f, 0x3fffe6ac, 0x40706ea4, 0xbfd2010a,
    0x404cf2df, 0xc0557f1e, 0xbf212680, 0x402c6605,
    0x408b5792, 0xbf795ce2, 0xbeb785e6, 0x400752ce,
    0x401e36d1, 0x40721512, 0xc03b8b17, 0x4093f57f,
    0xbecb2975, 0x3fcf60a4, 0xbe84e113, 0x408286de,
    0x3eba5a73, 0xc02415e7, 0xbf6b1f3b, 0xbff52c44,
    0x3fab20a2, 0xc0136128, 0xc0a5eff5, 0xc01bf55f,
    0xc000d429, 0xbf4fe51a, 0xc002ce1d, 0x3f75d6ff,
    0xc090ff9e, 0x3e4629d0, 0xbf57f9fe, 0x403621df,
    0xbe1553d1, 0x3f8b8a9b, 0xc01364cd, 0x400bc1d6,
    0xbfdb0122, 0xc04c72f4, 0x3f574d36, 0xc004f51d,
    0x403642a9, 0x3efc44db, 0x40028109, 0xbf0cb500,
    0x3fce14b2, 0x3ee21d66, 0xbf6e9b33, 0x3fff5aea,
    0xbed1536a, 0xbf9bb908, 0xbf77f53e, 0x40020d9c,
    0xbf9164b3, 0xbfd92620, 0x3ff48d5a, 0x3f9dfc94,
    0x40b94b3f, 0xbee50985, 0xc01e87b6, 0xc0001be2,
    0xbfb77449, 0xbf8a3575, 0x3fef8fb7, 0x3e95ea30,
    0xc0421ef7, 0x40659246, 0xbfd12976, 0xbe7db1b9,
    0x4053e5ee, 0xbfc6634b, 0x406155d9, 0x40b067d8,
    0xc0241ab6, 0x3fc4f3bb, 0xbda1fdbd, 0x4083053a,
    0x401aeb67, 0x3fe0723d, 0x3fc5b6bd, 0xbf0e601c,
    0xc0032a88, 0xc01a22f9, 0x3f1646f5, 0x3ea027a3,
    0x3e99a660, 0xbfb94e8e, 0xc038b714, 0x3f998535,
    0x3fadb473, 0x3e17200d, 0xc062afca, 0x3f9fa37c,
    0x401b8ce7, 0xc0148262, 0xbe47a25e, 0xbfa96051,
    0xc041c47d, 0x4031d788, 0x40a35e62, 0x3ea5565b,
    0xbda670db, 0x405a7ea2, 0xbf19feeb, 0xbe579f89,
    0x400958c8, 0xc081ef96, 0xbdfbd6cf, 0x3f2c9a56,
    0x3fdd3b94, 0xbf0736a0, 0xbdda01a3, 0x40142d73,
    0xbf4ea369, 0xbd377026, 0xbfbc0c3a, 0xbf400df2,
    0x40605ad4, 0xbfae08ea, 0x3f3b9b19, 0x3e6b3cd8,
    0xbe3a62fc, 0xbffb09a1, 0xbf752d10, 0xbfa9f510,
    0xbeaf3d01, 0xbff72bd0, 0x3fd701d5, 0xbfb128b0,
    0x3f1ec635, 0x403fd0cc, 0xc04d7376, 0x3f566b91,
    0x3fc820d8, 0xbfa81477, 0xbfa7b536, 0x4082da33,
    0x4044b9b8, 0xbf017509, 0x3f783d5f, 0xbfc441e5,
    0x3f50fc1a, 0xbe10bde1, 0xc06718a0, 0xbf16161d,
    0x3fed6649, 0x4015ce38, 0xc05dc96e, 0x40ca394b,
    0x3f917370, 0x4003d921, 0xbf85d09f, 0x4071efab,
    0x3e8a6df7, 0x3fd35a6c, 0x3e91a5d9, 0x40158376,
    0xc02d2170, 0xbf4b78a2, 0x3f5746a9, 0xc03cfdc6,
    0xc07e81f7, 0xbf8c964c, 0x3fe3a204, 0x4056abe7,
    0x3ee628f6, 0xbf326545, 0x3f33aac5, 0x3fa9bc4c,
    0x3f393146, 0xbff007ed, 0xc012da3b, 0x3f37fe7a,
    0xc0104371, 0xbf62df92, 0xbfede309, 0x3f8296d6,
    0x402493fb, 0x40218122, 0xbd22748a, 0xbe03362b,
    0xbf85ced9, 0x3ee12c54, 0x3f85097f, 0xc0144359,
    0x3f72b2e2, 0x40046074, 0xbf50b687, 0x3ea1aa7a,
    0xc012f8b3, 0xc02f7753, 0x3fabbcd4, 0xc028d2e3,
    0x40999e12, 0xc043ae0e, 0x3fb845b5, 0xbffd66ff,
    0xbe0d4203, 0x3fbbabb8, 0xc043a51a, 0x3f572703,
    0xbe27fc72, 0x400920c8, 0x40263926, 0x4087829c,
    0x3d8fcd41, 0x3ffe07db, 0x3f03e2c3, 0xbe0cd87d,
    0x3fd36ead, 0xc0c3f3b4, 0x3fedf5d0, 0xbece9b15,
    0xbf56d6bb, 0xbfe645f7, 0x3eb858b7, 0xbfc12728,
    0x400a167a, 0xbf696882, 0xc06d94dd, 0xbf27999c,
    0xc02bdb0b, 0xc04feef3, 0xc0299820, 0x3ecd801c,
    0xbf752afb, 0xbfb02d90, 0x3f320b80, 0xc0a2138f,
    0xc03c34c5, 0x3fa8ac39, 0x3f81e545, 0x3ee052fb,
    0x0
    };

static const uint32_t in_rfft_step_32[32] = {
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666
    };

static const uint32_t in_rifft_step_32[33] = {
    0x41666666, 0x0, 0xbf666666, 0x411234a6,
    0x0, 0x80000000, 0xbf666666, 0x403de1bb,
    0x0, 0x0, 0xbf666666, 0x3fd78628,
    0x0, 0x0, 0xbf666666, 0x3f8c5f22,
    0x0, 0x80000000, 0xbf666666, 0x3f3d159b,
    0x0, 0x0, 0xbf666666, 0x3ef64d80,
    0x0, 0x0, 0xbf666666, 0x3e8bc83b,
    0x0, 0x0, 0xbf666666, 0x3db58a13,
    0x0
    };

static const uint32_t ref_rfft_step_32[33] = {
    0x41666666, 0x0, 0xbf666666, 0x411234a6,
    0x0, 0x80000000, 0xbf666666, 0x403de1bb,
    0x0, 0x0, 0xbf666666, 0x3fd78628,
    0x0, 0x0, 0xbf666666, 0x3f8c5f22,
    0x0, 0x80000000, 0xbf666666, 0x3f3d159b,
    0x0, 0x0, 0xbf666666, 0x3ef64d80,
    0x0, 0x0, 0xbf666666, 0x3e8bc83b,
    0x0, 0x0, 0xbf666666, 0x3db58a13,
    0x0
    };

static const uint32_t in_rfft_step_64[64] = {
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666
    };

static const uint32_t in_rifft_step_64[65] = {
    0x41e66666, 0x0, 0xbf666666, 0x41928f33,
    0x0, 0x80000000, 0xbf666666, 0x40c22761,
    0x0, 0x0, 0xbf666666, 0x4065f3bc,
    0x0, 0x0, 0xbf666666, 0x4020fb31,
    0x0, 0x80000000, 0xbf666666, 0x3ff391e7,
    0x0, 0x0, 0xbf666666, 0x3fc03318,
    0x0, 0x0, 0xbf666666, 0x3f9b5448,
    0x0, 0x0, 0xbf666666, 0x3f7e350d,
    0x0, 0x0, 0xbf666666, 0x3f50d288,
    0x0, 0x0, 0xbf666666, 0x3f2ae054,
    0x0, 0x0, 0xbf666666, 0x3f0a18b1,
    0x0, 0x0, 0xbf666666, 0x3ed9f132,
    0x0, 0x0, 0xbf666666, 0x3ea4e07b,
    0x0, 0x0, 0xbf666666, 0x3e66d94a,
    0x0, 0x0, 0xbf666666, 0x3e08b4da,
    0x0, 0x0, 0xbf666666, 0x3d3519e9,
    0x0
    };

static const uint32_t ref_rfft_step_64[65] = {
    0x41e66666, 0x0, 0xbf666666, 0x41928f33,
    0x0, 0x80000000, 0xbf666666, 0x40c22761,
    0x0, 0x0, 0xbf666666, 0x4065f3bc,
    0x0, 0x0, 0xbf666666, 0x4020fb31,
    0x0, 0x80000000, 0xbf666666, 0x3ff391e7,
    0x0, 0x0, 0xbf666666, 0x3fc03318,
    0x0, 0x0, 0xbf666666, 0x3f9b5448,
    0x0, 0x0, 0xbf666666, 0x3f7e350d,
    0x0, 0x0, 0xbf666666, 0x3f50d288,
    0x0, 0x0, 0xbf666666, 0x3f2ae054,
    0x0, 0x0, 0xbf666666, 0x3f0a18b1,
    0x0, 0x0, 0xbf666666, 0x3ed9f132,
    0x0, 0x0, 0xbf666666, 0x3ea4e07b,
    0x0, 0x0, 0xbf666666, 0x3e66d94a,
    0x0, 0x0, 0xbf666666, 0x3e08b4da,
    0x0, 0x0, 0xbf666666, 0x3d3519e9,
    0x0
    };

static const uint32_t in_rfft_step_128[128] = {
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666
    };

static const uint32_t in_rifft_step_128[129] = {
    0x42666666, 0x0, 0xbf666666, 0x4212a5d2,
    0x0, 0x80000000, 0xbf666666, 0x4143374e,
    0x0, 0x0, 0xbf666666, 0x40e98115,
    0x0, 0x0, 0xbf666666, 0x40a5fa7e,
    0x0, 0x80000000, 0xbf666666, 0x40804092,
    0x0, 0x0, 0xbf666666, 0x405023c0,
    0x0, 0x0, 0xbf666666, 0x402e5b91,
    0x0, 0x0, 0xbf666666, 0x40155288,
    0x0, 0x0, 0xbf666666, 0x4001f18a,
    0x0, 0x0, 0xbf666666, 0x3fe4dcf4,
    0x0, 0x0, 0xbf666666, 0x3fcb5b40,
    0x0, 0x0, 0xbf666666, 0x3fb5ebb2,
    0x0, 0x0, 0xbf666666, 0x3fa39249,
    0x0, 0x0, 0xbf666666, 0x3f939d7b,
    0x0, 0x0, 0xbf666666, 0x3f858c7f,
    0x0, 0x0, 0xbf666666, 0x3f71ff27,
    0x0, 0x80000000, 0xbf666666, 0x3f5b5bea,
    0x0, 0x0, 0xbf666666, 0x3f46be91,
    0x0, 0x0, 0xbf666666, 0x3f33ce51,
    0x0, 0x0, 0xbf666666, 0x3f224418,
    0x0, 0x0, 0xbf666666, 0x3f11e631,
    0x0, 0x0, 0xbf666666, 0x3f02851e,
    0x0, 0x0, 0xbf666666, 0x3ee7f27e,
    0x0, 0x0, 0xbf666666, 0x3ecc4233,
    0x0, 0x0, 0xbf666666, 0x3eb1c00b,
    0x0, 0x0, 0xbf666666, 0x3e983a4e,
    0x0, 0x0, 0xbf666666, 0x3e7f0a83,
    0x0, 0x0, 0xbf666666, 0x3e4ef3c3,
    0x0, 0x0, 0xbf666666, 0x3e1fe9ab,
    0x0, 0x0, 0xbf666666, 0x3de35648,
    0x0, 0x0, 0xbf666666, 0x3d87f66d,
    0x0, 0x0, 0xbf666666, 0x3cb4fdf9,
    0x0
    };

static const uint32_t ref_rfft_step_128[129] = {
    0x42666666, 0x0, 0xbf666666, 0x4212a5d2,
    0x0, 0x80000000, 0xbf666666, 0x4143374e,
    0x0, 0x0, 0xbf666666, 0x40e98115,
    0x0, 0x0, 0xbf666666, 0x40a5fa7e,
    0x0, 0x80000000, 0xbf666666, 0x40804092,
    0x0, 0x0, 0xbf666666, 0x405023c0,
    0x0, 0x0, 0xbf666666, 0x402e5b91,
    0x0, 0x0, 0xbf666666, 0x40155288,
    0x0, 0x0, 0xbf666666, 0x4001f18a,
    0x0, 0x0, 0xbf666666, 0x3fe4dcf4,
    0x0, 0x0, 0xbf666666, 0x3fcb5b40,
    0x0, 0x0, 0xbf666666, 0x3fb5ebb2,
    0x0, 0x0, 0xbf666666, 0x3fa39249,
    0x0, 0x0, 0xbf666666, 0x3f939d7b,
    0x0, 0x0, 0xbf666666, 0x3f858c7f,
    0x0, 0x0, 0xbf666666, 0x3f71ff27,
    0x0, 0x80000000, 0xbf666666, 0x3f5b5bea,
    0x0, 0x0, 0xbf666666, 0x3f46be91,
    0x0, 0x0, 0xbf666666, 0x3f33ce51,
    0x0, 0x0, 0xbf666666, 0x3f224418,
    0x0, 0x0, 0xbf666666, 0x3f11e631,
    0x0, 0x0, 0xbf666666, 0x3f02851e,
    0x0, 0x0, 0xbf666666, 0x3ee7f27e,
    0x0, 0x0, 0xbf666666, 0x3ecc4233,
    0x0, 0x0, 0xbf666666, 0x3eb1c00b,
    0x0, 0x0, 0xbf666666, 0x3e983a4e,
    0x0, 0x0, 0xbf666666, 0x3e7f0a83,
    0x0, 0x0, 0xbf666666, 0x3e4ef3c3,
    0x0, 0x0, 0xbf666666, 0x3e1fe9ab,
    0x0, 0x0, 0xbf666666, 0x3de35648,
    0x0, 0x0, 0xbf666666, 0x3d87f66d,
    0x0, 0x0, 0xbf666666, 0x3cb4fdf9,
    0x0
    };

static const uint32_t in_rfft_step_256[256] = {
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666
    };

static const uint32_t in_rifft_step_256[257] = {
    0x42e66666, 0x0, 0xbf666666, 0x4292ab7a,
    0x0, 0x80000000, 0xbf666666, 0x41c37b32,
    0x0, 0x0, 0xbf666666, 0x416a6390,
    0x0, 0x0, 0xbf666666, 0x412737f2,
    0x0, 0x80000000, 0xbf666666, 0x4101d962,
    0x0, 0x0, 0xbf666666, 0x40d40d19,
    0x0, 0x0, 0xbf666666, 0x40b2fddd,
    0x0, 0x0, 0xbf666666, 0x409aaf3d,
    0x0, 0x0, 0xbf666666, 0x40880a60,
    0x0, 0x0, 0xbf666666, 0x40728acd,
    0x0, 0x0, 0xbf666666, 0x405a89be,
    0x0, 0x0, 0xbf666666, 0x40469fd7,
    0x0, 0x0, 0xbf666666, 0x4035d1ac,
    0x0, 0x0, 0xbf666666, 0x40276e4d,
    0x0, 0x0, 0xbf666666, 0x401af597,
    0x0, 0x0, 0xbf666666, 0x40100876,
    0x0, 0x80000000, 0xbf666666, 0x40065ee1,
    0x0, 0x0, 0xbf666666, 0x3ffb8288,
    0x0, 0x0, 0xbf666666, 0x3fec0818,
    0x0, 0x0, 0xbf666666, 0x3fde092b,
    0x0, 0x0, 0xbf666666, 0x3fd14df9,
    0x0, 0x0, 0xbf666666, 0x3fc5a91a,
    0x0, 0x0, 0xbf666666, 0x3fbaf531,
    0x0, 0x0, 0xbf666666, 0x3fb1133b,
    0x0, 0x0, 0xbf666666, 0x3fa7e942,
    0x0, 0x0, 0xbf666666, 0x3f9f615f,
    0x0, 0x0, 0xbf666666, 0x3f9768f4,
    0x0, 0x0, 0xbf666666, 0x3f8ff017,
    0x0, 0x0, 0xbf666666, 0x3f88e914,
    0x0, 0x0, 0xbf666666, 0x3f824810,
    0x0, 0x0, 0xbf666666, 0x3f780574,
    0x0, 0x0, 0xbf666666, 0x3f6c201b,
    0x0, 0x0, 0xbf666666, 0x3f60d03c,
    0x0, 0x0, 0xbf666666, 0x3f5607d9,
    0x0, 0x0, 0xbf666666, 0x3f4bba8d,
    0x0, 0x0, 0xbf666666, 0x3f41dd51,
    0x0, 0x0, 0xbf666666, 0x3f38664c,
    0x0, 0x0, 0xbf666666, 0x3f2f4ca6,
    0x0, 0x0, 0xbf666666, 0x3f26886f,
    0x0, 0x0, 0xbf666666, 0x3f1e1279,
    0x0, 0x0, 0xbf666666, 0x3f15e443,
    0x0, 0x0, 0xbf666666, 0x3f0df7e4,
    0x0, 0x0, 0xbf666666, 0x3f0647f8,
    0x0, 0x0, 0xbf666666, 0x3efd9f20,
    0x0, 0x0, 0xbf666666, 0x3eef144b,
    0x0, 0x0, 0xbf666666, 0x3ee0e71b,
    0x0, 0x0, 0xbf666666, 0x3ed30fda,
    0x0, 0x0, 0xbf666666, 0x3ec58765,
    0x0, 0x0, 0xbf666666, 0x3eb84717,
    0x0, 0x0, 0xbf666666, 0x3eab48bf,
    0x0, 0x0, 0xbf666666, 0x3e9e868f,
    0x0, 0x0, 0xbf666666, 0x3e91fb13,
    0x0, 0x0, 0xbf666666, 0x3e85a128,
    0x0, 0x0, 0xbf666666, 0x3e72e7e2,
    0x0, 0x0, 0xbf666666, 0x3e5add9c,
    0x0, 0x0, 0xbf666666, 0x3e431aae,
    0x0, 0x0, 0xbf666666, 0x3e2b96a6,
    0x0, 0x0, 0xbf666666, 0x3e144965,
    0x0, 0x0, 0xbf666666, 0x3dfa5629,
    0x0, 0x0, 0xbf666666, 0x3dcc6833,
    0x0, 0x0, 0xbf666666, 0x3d9eba16,
    0x0, 0x0, 0xbf666666, 0x3d627a9e,
    0x0, 0x0, 0xbf666666, 0x3d07c735,
    0x0, 0x0, 0xbf666666, 0x3c34f6ff,
    0x0
    };

static const uint32_t ref_rfft_step_256[257] = {
    0x42e66666, 0x0, 0xbf666666, 0x4292ab7a,
    0x0, 0x80000000, 0xbf666666, 0x41c37b32,
    0x0, 0x0, 0xbf666666, 0x416a6390,
    0x0, 0x0, 0xbf666666, 0x412737f2,
    0x0, 0x80000000, 0xbf666666, 0x4101d962,
    0x0, 0x0, 0xbf666666, 0x40d40d19,
    0x0, 0x0, 0xbf666666, 0x40b2fddd,
    0x0, 0x0, 0xbf666666, 0x409aaf3d,
    0x0, 0x0, 0xbf666666, 0x40880a60,
    0x0, 0x0, 0xbf666666, 0x40728acd,
    0x0, 0x0, 0xbf666666, 0x405a89be,
    0x0, 0x0, 0xbf666666, 0x40469fd7,
    0x0, 0x0, 0xbf666666, 0x4035d1ac,
    0x0, 0x0, 0xbf666666, 0x40276e4d,
    0x0, 0x0, 0xbf666666, 0x401af597,
    0x0, 0x0, 0xbf666666, 0x40100876,
    0x0, 0x80000000, 0xbf666666, 0x40065ee1,
    0x0, 0x0, 0xbf666666, 0x3ffb8288,
    0x0, 0x0, 0xbf666666, 0x3fec0818,
    0x0, 0x0, 0xbf666666, 0x3fde092b,
    0x0, 0x0, 0xbf666666, 0x3fd14df9,
    0x0, 0x0, 0xbf666666, 0x3fc5a91a,
    0x0, 0x0, 0xbf666666, 0x3fbaf531,
    0x0, 0x0, 0xbf666666, 0x3fb1133b,
    0x0, 0x0, 0xbf666666, 0x3fa7e942,
    0x0, 0x0, 0xbf666666, 0x3f9f615f,
    0x0, 0x0, 0xbf666666, 0x3f9768f4,
    0x0, 0x0, 0xbf666666, 0x3f8ff017,
    0x0, 0x0, 0xbf666666, 0x3f88e914,
    0x0, 0x0, 0xbf666666, 0x3f824810,
    0x0, 0x0, 0xbf666666, 0x3f780574,
    0x0, 0x0, 0xbf666666, 0x3f6c201b,
    0x0, 0x0, 0xbf666666, 0x3f60d03c,
    0x0, 0x0, 0xbf666666, 0x3f5607d9,
    0x0, 0x0, 0xbf666666, 0x3f4bba8d,
    0x0, 0x0, 0xbf666666, 0x3f41dd51,
    0x0, 0x0, 0xbf666666, 0x3f38664c,
    0x0, 0x0, 0xbf666666, 0x3f2f4ca6,
    0x0, 0x0, 0xbf666666, 0x3f26886f,
    0x0, 0x0, 0xbf666666, 0x3f1e1279,
    0x0, 0x0, 0xbf666666, 0x3f15e443,
    0x0, 0x0, 0xbf666666, 0x3f0df7e4,
    0x0, 0x0, 0xbf666666, 0x3f0647f8,
    0x0, 0x0, 0xbf666666, 0x3efd9f20,
    0x0, 0x0, 0xbf666666, 0x3eef144b,
    0x0, 0x0, 0xbf666666, 0x3ee0e71b,
    0x0, 0x0, 0xbf666666, 0x3ed30fda,
    0x0, 0x0, 0xbf666666, 0x3ec58765,
    0x0, 0x0, 0xbf666666, 0x3eb84717,
    0x0, 0x0, 0xbf666666, 0x3eab48bf,
    0x0, 0x0, 0xbf666666, 0x3e9e868f,
    0x0, 0x0, 0xbf666666, 0x3e91fb13,
    0x0, 0x0, 0xbf666666, 0x3e85a128,
    0x0, 0x0, 0xbf666666, 0x3e72e7e2,
    0x0, 0x0, 0xbf666666, 0x3e5add9c,
    0x0, 0x0, 0xbf666666, 0x3e431aae,
    0x0, 0x0, 0xbf666666, 0x3e2b96a6,
    0x0, 0x0, 0xbf666666, 0x3e144965,
    0x0, 0x0, 0xbf666666, 0x3dfa5629,
    0x0, 0x0, 0xbf666666, 0x3dcc6833,
    0x0, 0x0, 0xbf666666, 0x3d9eba16,
    0x0, 0x0, 0xbf666666, 0x3d627a9e,
    0x0, 0x0, 0xbf666666, 0x3d07c735,
    0x0, 0x0, 0xbf666666, 0x3c34f6ff,
    0x0
    };

static const uint32_t in_rfft_step_512[512] = {
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666
    };

static const uint32_t in_rifft_step_512[513] = {
    0x43666666, 0x0, 0xbf666666, 0x4312ace4,
    0x0, 0x80000000, 0xbf666666, 0x42438c29,
    0x0, 0x0, 0xbf666666, 0x41ea9c21,
    0x0, 0x0, 0xbf666666, 0x41a7872a,
    0x0, 0x80000000, 0xbf666666, 0x41823f46,
    0x0, 0x0, 0xbf666666, 0x4155064a,
    0x0, 0x0, 0xbf666666, 0x4134248a,
    0x0, 0x0, 0xbf666666, 0x411c037e,
    0x0, 0x0, 0xbf666666, 0x41098c4e,
    0x0, 0x0, 0xbf666666, 0x40f5ea42,
    0x0, 0x0, 0xbf666666, 0x40de450d,
    0x0, 0x0, 0xbf666666, 0x40cab74c,
    0x0, 0x0, 0xbf666666, 0x40ba4599,
    0x0, 0x0, 0xbf666666, 0x40ac3f0d,
    0x0, 0x0, 0xbf666666, 0x40a0238b,
    0x0, 0x0, 0xbf666666, 0x40959408,
    0x0, 0x80000000, 0xbf666666, 0x408c4882,
    0x0, 0x0, 0xbf666666, 0x4084096e,
    0x0, 0x0, 0xbf666666, 0x40795680,
    0x0, 0x0, 0xbf666666, 0x406c16bd,
    0x0, 0x0, 0xbf666666, 0x40601bdc,
    0x0, 0x0, 0xbf666666, 0x40553884,
    0x0, 0x0, 0xbf666666, 0x404b476c,
    0x0, 0x0, 0xbf666666, 0x404229a3,
    0x0, 0x0, 0xbf666666, 0x4039c547,
    0x0, 0x0, 0xbf666666, 0x40320482,
    0x0, 0x0, 0xbf666666, 0x402ad4cd,
    0x0, 0x0, 0xbf666666, 0x4024264f,
    0x0, 0x0, 0xbf666666, 0x401deb6c,
    0x0, 0x0, 0xbf666666, 0x4018185f,
    0x0, 0x0, 0xbf666666, 0x4012a2ec,
    0x0, 0x0, 0xbf666666, 0x400d8226,
    0x0, 0x0, 0xbf666666, 0x4008ae38,
    0x0, 0x0, 0xbf666666, 0x4004203c,
    0x0, 0x0, 0xbf666666, 0x3fffa435,
    0x0, 0x0, 0xbf666666, 0x3ff77cd2,
    0x0, 0x0, 0xbf666666, 0x3fefc0ad,
    0x0, 0x0, 0xbf666666, 0x3fe8672a,
    0x0, 0x0, 0xbf666666, 0x3fe16891,
    0x0, 0x0, 0xbf666666, 0x3fdabdf3,
    0x0, 0x0, 0xbf666666, 0x3fd4610f,
    0x0, 0x0, 0xbf666666, 0x3fce4c3f,
    0x0, 0x0, 0xbf666666, 0x3fc87a64,
    0x0, 0x0, 0xbf666666, 0x3fc2e6d7,
    0x0, 0x0, 0xbf666666, 0x3fbd8d5e,
    0x0, 0x0, 0xbf666666, 0x3fb86a1c,
    0x0, 0x0, 0xbf666666, 0x3fb37988,
    0x0, 0x0, 0xbf666666, 0x3faeb868,
    0x0, 0x0, 0xbf666666, 0x3faa23c3,
    0x0, 0x0, 0xbf666666, 0x3fa5b8df,
    0x0, 0x0, 0xbf666666, 0x3fa17537,
    0x0, 0x0, 0xbf666666, 0x3f9d567b,
    0x0, 0x0, 0xbf666666, 0x3f995a85,
    0x0, 0x0, 0xbf666666, 0x3f957f59,
    0x0, 0x0, 0xbf666666, 0x3f91c321,
    0x0, 0x0, 0xbf666666, 0x3f8e2427,
    0x0, 0x0, 0xbf666666, 0x3f8aa0d5,
    0x0, 0x0, 0xbf666666, 0x3f8737b0,
    0x0, 0x0, 0xbf666666, 0x3f83e757,
    0x0, 0x0, 0xbf666666, 0x3f80ae81,
    0x0, 0x0, 0xbf666666, 0x3f7b17f5,
    0x0, 0x0, 0xbf666666, 0x3f74fd45,
    0x0, 0x0, 0xbf666666, 0x3f6f0ad8,
    0x0, 0x0, 0xbf666666, 0x3f693eb3,
    0x0, 0x80000000, 0xbf666666, 0x3f6396fb,
    0x0, 0x0, 0xbf666666, 0x3f5e11f2,
    0x0, 0x0, 0xbf666666, 0x3f58adf2,
    0x0, 0x0, 0xbf666666, 0x3f53696f,
    0x0, 0x0, 0xbf666666, 0x3f4e42f6,
    0x0, 0x0, 0xbf666666, 0x3f493924,
    0x0, 0x0, 0xbf666666, 0x3f444aae,
    0x0, 0x0, 0xbf666666, 0x3f3f7657,
    0x0, 0x0, 0xbf666666, 0x3f3abaf8,
    0x0, 0x0, 0xbf666666, 0x3f361774,
    0x0, 0x0, 0xbf666666, 0x3f318ac2,
    0x0, 0x0, 0xbf666666, 0x3f2d13e1,
    0x0, 0x0, 0xbf666666, 0x3f28b1e2,
    0x0, 0x0, 0xbf666666, 0x3f2463df,
    0x0, 0x0, 0xbf666666, 0x3f2028fe,
    0x0, 0x0, 0xbf666666, 0x3f1c006f,
    0x0, 0x0, 0xbf666666, 0x3f17e96b,
    0x0, 0x0, 0xbf666666, 0x3f13e337,
    0x0, 0x0, 0xbf666666, 0x3f0fed1d,
    0x0, 0x0, 0xbf666666, 0x3f0c0671,
    0x0, 0x0, 0xbf666666, 0x3f082e8f,
    0x0, 0x0, 0xbf666666, 0x3f0464d8,
    0x0, 0x0, 0xbf666666, 0x3f00a8b6,
    0x0, 0x0, 0xbf666666, 0x3ef9f332,
    0x0, 0x0, 0xbf666666, 0x3ef2ade9,
    0x0, 0x0, 0xbf666666, 0x3eeb8088,
    0x0, 0x0, 0xbf666666, 0x3ee46a0e,
    0x0, 0x0, 0xbf666666, 0x3edd6986,
    0x0, 0x0, 0xbf666666, 0x3ed67e02,
    0x0, 0x0, 0xbf666666, 0x3ecfa69e,
    0x0, 0x0, 0xbf666666, 0x3ec8e27e,
    0x0, 0x0, 0xbf666666, 0x3ec230ce,
    0x0, 0x0, 0xbf666666, 0x3ebb90bf,
    0x0, 0x0, 0xbf666666, 0x3eb5018e,
    0x0, 0x0, 0xbf666666, 0x3eae8279,
    0x0, 0x0, 0xbf666666, 0x3ea812c7,
    0x0, 0x0, 0xbf666666, 0x3ea1b1c5,
    0x0, 0x0, 0xbf666666, 0x3e9b5ec4,
    0x0, 0x0, 0xbf666666, 0x3e95191a,
    0x0, 0x0, 0xbf666666, 0x3e8ee025,
    0x0, 0x0, 0xbf666666, 0x3e88b343,
    0x0, 0x0, 0xbf666666, 0x3e8291d9,
    0x0, 0x0, 0xbf666666, 0x3e78f6a0,
    0x0, 0x0, 0xbf666666, 0x3e6cde27,
    0x0, 0x0, 0xbf666666, 0x3e60d927,
    0x0, 0x0, 0xbf666666, 0x3e54e687,
    0x0, 0x0, 0xbf666666, 0x3e490531,
    0x0, 0x0, 0xbf666666, 0x3e3d3419,
    0x0, 0x0, 0xbf666666, 0x3e317235,
    0x0, 0x0, 0xbf666666, 0x3e25be82,
    0x0, 0x0, 0xbf666666, 0x3e1a1801,
    0x0, 0x0, 0xbf666666, 0x3e0e7db7,
    0x0, 0x0, 0xbf666666, 0x3e02eeae,
    0x0, 0x0, 0xbf666666, 0x3deed3e1,
    0x0, 0x0, 0xbf666666, 0x3dd7dd22,
    0x0, 0x0, 0xbf666666, 0x3dc0f742,
    0x0, 0x0, 0xbf666666, 0x3daa206d,
    0x0, 0x0, 0xbf666666, 0x3d9356d3,
    0x0, 0x0, 0xbf666666, 0x3d793152,
    0x0, 0x0, 0xbf666666, 0x3d4bc84b,
    0x0, 0x0, 0xbf666666, 0x3d1e6f08,
    0x0, 0x0, 0xbf666666, 0x3ce24403,
    0x0, 0x0, 0xbf666666, 0x3c87bb6d,
    0x0, 0x0, 0xbf666666, 0x3bb4f540,
    0x0
    };

static const uint32_t ref_rfft_step_512[513] = {
    0x43666666, 0x0, 0xbf666666, 0x4312ace4,
    0x0, 0x80000000, 0xbf666666, 0x42438c29,
    0x0, 0x0, 0xbf666666, 0x41ea9c21,
    0x0, 0x0, 0xbf666666, 0x41a7872a,
    0x0, 0x80000000, 0xbf666666, 0x41823f46,
    0x0, 0x0, 0xbf666666, 0x4155064a,
    0x0, 0x0, 0xbf666666, 0x4134248a,
    0x0, 0x0, 0xbf666666, 0x411c037e,
    0x0, 0x0, 0xbf666666, 0x41098c4e,
    0x0, 0x0, 0xbf666666, 0x40f5ea42,
    0x0, 0x0, 0xbf666666, 0x40de450d,
    0x0, 0x0, 0xbf666666, 0x40cab74c,
    0x0, 0x0, 0xbf666666, 0x40ba4599,
    0x0, 0x0, 0xbf666666, 0x40ac3f0d,
    0x0, 0x0, 0xbf666666, 0x40a0238b,
    0x0, 0x0, 0xbf666666, 0x40959408,
    0x0, 0x80000000, 0xbf666666, 0x408c4882,
    0x0, 0x0, 0xbf666666, 0x4084096e,
    0x0, 0x0, 0xbf666666, 0x40795680,
    0x0, 0x0, 0xbf666666, 0x406c16bd,
    0x0, 0x0, 0xbf666666, 0x40601bdc,
    0x0, 0x0, 0xbf666666, 0x40553884,
    0x0, 0x0, 0xbf666666, 0x404b476c,
    0x0, 0x0, 0xbf666666, 0x404229a3,
    0x0, 0x0, 0xbf666666, 0x4039c547,
    0x0, 0x0, 0xbf666666, 0x40320482,
    0x0, 0x0, 0xbf666666, 0x402ad4cd,
    0x0, 0x0, 0xbf666666, 0x4024264f,
    0x0, 0x0, 0xbf666666, 0x401deb6c,
    0x0, 0x0, 0xbf666666, 0x4018185f,
    0x0, 0x0, 0xbf666666, 0x4012a2ec,
    0x0, 0x0, 0xbf666666, 0x400d8226,
    0x0, 0x0, 0xbf666666, 0x4008ae38,
    0x0, 0x0, 0xbf666666, 0x4004203c,
    0x0, 0x0, 0xbf666666, 0x3fffa435,
    0x0, 0x0, 0xbf666666, 0x3ff77cd2,
    0x0, 0x0, 0xbf666666, 0x3fefc0ad,
    0x0, 0x0, 0xbf666666, 0x3fe8672a,
    0x0, 0x0, 0xbf666666, 0x3fe16891,
    0x0, 0x0, 0xbf666666, 0x3fdabdf3,
    0x0, 0x0, 0xbf666666, 0x3fd4610f,
    0x0, 0x0, 0xbf666666, 0x3fce4c3f,
    0x0, 0x0, 0xbf666666, 0x3fc87a64,
    0x0, 0x0, 0xbf666666, 0x3fc2e6d7,
    0x0, 0x0, 0xbf666666, 0x3fbd8d5e,
    0x0, 0x0, 0xbf666666, 0x3fb86a1c,
    0x0, 0x0, 0xbf666666, 0x3fb37988,
    0x0, 0x0, 0xbf666666, 0x3faeb868,
    0x0, 0x0, 0xbf666666, 0x3faa23c3,
    0x0, 0x0, 0xbf666666, 0x3fa5b8df,
    0x0, 0x0, 0xbf666666, 0x3fa17537,
    0x0, 0x0, 0xbf666666, 0x3f9d567b,
    0x0, 0x0, 0xbf666666, 0x3f995a85,
    0x0, 0x0, 0xbf666666, 0x3f957f59,
    0x0, 0x0, 0xbf666666, 0x3f91c321,
    0x0, 0x0, 0xbf666666, 0x3f8e2427,
    0x0, 0x0, 0xbf666666, 0x3f8aa0d5,
    0x0, 0x0, 0xbf666666, 0x3f8737b0,
    0x0, 0x0, 0xbf666666, 0x3f83e757,
    0x0, 0x0, 0xbf666666, 0x3f80ae81,
    0x0, 0x0, 0xbf666666, 0x3f7b17f5,
    0x0, 0x0, 0xbf666666, 0x3f74fd45,
    0x0, 0x0, 0xbf666666, 0x3f6f0ad8,
    0x0, 0x0, 0xbf666666, 0x3f693eb3,
    0x0, 0x80000000, 0xbf666666, 0x3f6396fb,
    0x0, 0x0, 0xbf666666, 0x3f5e11f2,
    0x0, 0x0, 0xbf666666, 0x3f58adf2,
    0x0, 0x0, 0xbf666666, 0x3f53696f,
    0x0, 0x0, 0xbf666666, 0x3f4e42f6,
    0x0, 0x0, 0xbf666666, 0x3f493924,
    0x0, 0x0, 0xbf666666, 0x3f444aae,
    0x0, 0x0, 0xbf666666, 0x3f3f7657,
    0x0, 0x0, 0xbf666666, 0x3f3abaf8,
    0x0, 0x0, 0xbf666666, 0x3f361774,
    0x0, 0x0, 0xbf666666, 0x3f318ac2,
    0x0, 0x0, 0xbf666666, 0x3f2d13e1,
    0x0, 0x0, 0xbf666666, 0x3f28b1e2,
    0x0, 0x0, 0xbf666666, 0x3f2463df,
    0x0, 0x0, 0xbf666666, 0x3f2028fe,
    0x0, 0x0, 0xbf666666, 0x3f1c006f,
    0x0, 0x0, 0xbf666666, 0x3f17e96b,
    0x0, 0x0, 0xbf666666, 0x3f13e337,
    0x0, 0x0, 0xbf666666, 0x3f0fed1d,
    0x0, 0x0, 0xbf666666, 0x3f0c0671,
    0x0, 0x0, 0xbf666666, 0x3f082e8f,
    0x0, 0x0, 0xbf666666, 0x3f0464d8,
    0x0, 0x0, 0xbf666666, 0x3f00a8b6,
    0x0, 0x0, 0xbf666666, 0x3ef9f332,
    0x0, 0x0, 0xbf666666, 0x3ef2ade9,
    0x0, 0x0, 0xbf666666, 0x3eeb8088,
    0x0, 0x0, 0xbf666666, 0x3ee46a0e,
    0x0, 0x0, 0xbf666666, 0x3edd6986,
    0x0, 0x0, 0xbf666666, 0x3ed67e02,
    0x0, 0x0, 0xbf666666, 0x3ecfa69e,
    0x0, 0x0, 0xbf666666, 0x3ec8e27e,
    0x0, 0x0, 0xbf666666, 0x3ec230ce,
    0x0, 0x0, 0xbf666666, 0x3ebb90bf,
    0x0, 0x0, 0xbf666666, 0x3eb5018e,
    0x0, 0x0, 0xbf666666, 0x3eae8279,
    0x0, 0x0, 0xbf666666, 0x3ea812c7,
    0x0, 0x0, 0xbf666666, 0x3ea1b1c5,
    0x0, 0x0, 0xbf666666, 0x3e9b5ec4,
    0x0, 0x0, 0xbf666666, 0x3e95191a,
    0x0, 0x0, 0xbf666666, 0x3e8ee025,
    0x0, 0x0, 0xbf666666, 0x3e88b343,
    0x0, 0x0, 0xbf666666, 0x3e8291d9,
    0x0, 0x0, 0xbf666666, 0x3e78f6a0,
    0x0, 0x0, 0xbf666666, 0x3e6cde27,
    0x0, 0x0, 0xbf666666, 0x3e60d927,
    0x0, 0x0, 0xbf666666, 0x3e54e687,
    0x0, 0x0, 0xbf666666, 0x3e490531,
    0x0, 0x0, 0xbf666666, 0x3e3d3419,
    0x0, 0x0, 0xbf666666, 0x3e317235,
    0x0, 0x0, 0xbf666666, 0x3e25be82,
    0x0, 0x0, 0xbf666666, 0x3e1a1801,
    0x0, 0x0, 0xbf666666, 0x3e0e7db7,
    0x0, 0x0, 0xbf666666, 0x3e02eeae,
    0x0, 0x0, 0xbf666666, 0x3deed3e1,
    0x0, 0x0, 0xbf666666, 0x3dd7dd22,
    0x0, 0x0, 0xbf666666, 0x3dc0f742,
    0x0, 0x0, 0xbf666666, 0x3daa206d,
    0x0, 0x0, 0xbf666666, 0x3d9356d3,
    0x0, 0x0, 0xbf666666, 0x3d793152,
    0x0, 0x0, 0xbf666666, 0x3d4bc84b,
    0x0, 0x0, 0xbf666666, 0x3d1e6f08,
    0x0, 0x0, 0xbf666666, 0x3ce24403,
    0x0, 0x0, 0xbf666666, 0x3c87bb6d,
    0x0, 0x0, 0xbf666666, 0x3bb4f540,
    0x0
    };

static const uint32_t in_rfft_step_1024[1024] = {
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666
    };

static const uint32_t in_rifft_step_1024[1025] = {
    0x43e66666, 0x0, 0xbf666666, 0x4392ad3f,
    0x0, 0x80000000, 0xbf666666, 0x42c39067,
    0x0, 0x0, 0xbf666666, 0x426aaa44,
    0x0, 0x0, 0xbf666666, 0x42279af6,
    0x0, 0x80000000, 0xbf666666, 0x420258ba,
    0x0, 0x0, 0xbf666666, 0x41d54485,
    0x0, 0x0, 0xbf666666, 0x41b46e18,
    0x0, 0x0, 0xbf666666, 0x419c5860,
    0x0, 0x0, 0xbf666666, 0x4189ec87,
    0x0, 0x0, 0xbf666666, 0x4176c163,
    0x0, 0x0, 0xbf666666, 0x415f32e3,
    0x0, 0x0, 0xbf666666, 0x414bbbdb,
    0x0, 0x0, 0xbf666666, 0x413b60e6,
    0x0, 0x0, 0xbf666666, 0x412d711d,
    0x0, 0x0, 0xbf666666, 0x41216c65,
    0x0, 0x0, 0xbf666666, 0x4116f3b2,
    0x0, 0x80000000, 0xbf666666, 0x410dbf03,
    0x0, 0x0, 0xbf666666, 0x410596cc,
    0x0, 0x0, 0xbf666666, 0x40fc9f09,
    0x0, 0x0, 0xbf666666, 0x40ef8d22,
    0x0, 0x0, 0xbf666666, 0x40e3c02e,
    0x0, 0x0, 0xbf666666, 0x40d90ad5,
    0x0, 0x0, 0xbf666666, 0x40cf47d0,
    0x0, 0x0, 0xbf666666, 0x40c6582f,
    0x0, 0x0, 0xbf666666, 0x40be220e,
    0x0, 0x0, 0xbf666666, 0x40b68f9c,
    0x0, 0x0, 0xbf666666, 0x40af8e4f,
    0x0, 0x0, 0xbf666666, 0x40a90e53,
    0x0, 0x0, 0xbf666666, 0x40a3020a,
    0x0, 0x0, 0xbf666666, 0x409d5db0,
    0x0, 0x0, 0xbf666666, 0x4098170c,
    0x0, 0x0, 0xbf666666, 0x40932530,
    0x0, 0x0, 0xbf666666, 0x408e8049,
    0x0, 0x0, 0xbf666666, 0x408a2173,
    0x0, 0x0, 0xbf666666, 0x40860296,
    0x0, 0x0, 0xbf666666, 0x40821e49,
    0x0, 0x0, 0xbf666666, 0x407cdf77,
    0x0, 0x0, 0xbf666666, 0x4075e542,
    0x0, 0x0, 0xbf666666, 0x406f463e,
    0x0, 0x0, 0xbf666666, 0x4068fb7d,
    0x0, 0x0, 0xbf666666, 0x4062fec1,
    0x0, 0x0, 0xbf666666, 0x405d4a65,
    0x0, 0x0, 0xbf666666, 0x4057d94e,
    0x0, 0x0, 0xbf666666, 0x4052a6d6,
    0x0, 0x0, 0xbf666666, 0x404daec5,
    0x0, 0x0, 0xbf666666, 0x4048ed41,
    0x0, 0x0, 0xbf666666, 0x40445ec4,
    0x0, 0x0, 0xbf666666, 0x40400014,
    0x0, 0x0, 0xbf666666, 0x403bce3d,
    0x0, 0x0, 0xbf666666, 0x4037c686,
    0x0, 0x0, 0xbf666666, 0x4033e66d,
    0x0, 0x0, 0xbf666666, 0x40302ba4,
    0x0, 0x0, 0xbf666666, 0x402c9409,
    0x0, 0x0, 0xbf666666, 0x40291da1,
    0x0, 0x0, 0xbf666666, 0x4025c699,
    0x0, 0x0, 0xbf666666, 0x40228d3d,
    0x0, 0x0, 0xbf666666, 0x401f6ffb,
    0x0, 0x0, 0xbf666666, 0x401c6d59,
    0x0, 0x0, 0xbf666666, 0x401983fb,
    0x0, 0x0, 0xbf666666, 0x4016b29a,
    0x0, 0x0, 0xbf666666, 0x4013f804,
    0x0, 0x0, 0xbf666666, 0x4011531d,
    0x0, 0x0, 0xbf666666, 0x400ec2d9,
    0x0, 0x0, 0xbf666666, 0x400c463f,
    0x0, 0x80000000, 0xbf666666, 0x4009dc63,
    0x0, 0x0, 0xbf666666, 0x4007846a,
    0x0, 0x0, 0xbf666666, 0x40053d85,
    0x0, 0x0, 0xbf666666, 0x400306f0,
    0x0, 0x0, 0xbf666666, 0x4000dff5,
    0x0, 0x0, 0xbf666666, 0x3ffd8fcc,
    0x0, 0x0, 0xbf666666, 0x3ff97c41,
    0x0, 0x0, 0xbf666666, 0x3ff58415,
    0x0, 0x0, 0xbf666666, 0x3ff1a625,
    0x0, 0x0, 0xbf666666, 0x3fede15e,
    0x0, 0x0, 0xbf666666, 0x3fea34bb,
    0x0, 0x0, 0xbf666666, 0x3fe69f46,
    0x0, 0x0, 0xbf666666, 0x3fe32016,
    0x0, 0x0, 0xbf666666, 0x3fdfb64b,
    0x0, 0x0, 0xbf666666, 0x3fdc6115,
    0x0, 0x0, 0xbf666666, 0x3fd91fac,
    0x0, 0x0, 0xbf666666, 0x3fd5f150,
    0x0, 0x0, 0xbf666666, 0x3fd2d54f,
    0x0, 0x0, 0xbf666666, 0x3fcfcafb,
    0x0, 0x0, 0xbf666666, 0x3fccd1b1,
    0x0, 0x0, 0xbf666666, 0x3fc9e8d6,
    0x0, 0x0, 0xbf666666, 0x3fc70fd5,
    0x0, 0x0, 0xbf666666, 0x3fc44620,
    0x0, 0x0, 0xbf666666, 0x3fc18b2f,
    0x0, 0x0, 0xbf666666, 0x3fbede82,
    0x0, 0x0, 0xbf666666, 0x3fbc3f9d,
    0x0, 0x0, 0xbf666666, 0x3fb9ae0a,
    0x0, 0x0, 0xbf666666, 0x3fb72958,
    0x0, 0x0, 0xbf666666, 0x3fb4b11b,
    0x0, 0x0, 0xbf666666, 0x3fb244ec,
    0x0, 0x0, 0xbf666666, 0x3fafe468,
    0x0, 0x0, 0xbf666666, 0x3fad8f30,
    0x0, 0x0, 0xbf666666, 0x3fab44e8,
    0x0, 0x0, 0xbf666666, 0x3fa9053a,
    0x0, 0x0, 0xbf666666, 0x3fa6cfd2,
    0x0, 0x0, 0xbf666666, 0x3fa4a45f,
    0x0, 0x0, 0xbf666666, 0x3fa28294,
    0x0, 0x0, 0xbf666666, 0x3fa06a28,
    0x0, 0x0, 0xbf666666, 0x3f9e5ad3,
    0x0, 0x0, 0xbf666666, 0x3f9c544f,
    0x0, 0x0, 0xbf666666, 0x3f9a565c,
    0x0, 0x0, 0xbf666666, 0x3f9860ba,
    0x0, 0x0, 0xbf666666, 0x3f96732c,
    0x0, 0x0, 0xbf666666, 0x3f948d76,
    0x0, 0x0, 0xbf666666, 0x3f92af61,
    0x0, 0x0, 0xbf666666, 0x3f90d8b5,
    0x0, 0x0, 0xbf666666, 0x3f8f093f,
    0x0, 0x0, 0xbf666666, 0x3f8d40ca,
    0x0, 0x0, 0xbf666666, 0x3f8b7f27,
    0x0, 0x0, 0xbf666666, 0x3f89c426,
    0x0, 0x0, 0xbf666666, 0x3f880f99,
    0x0, 0x0, 0xbf666666, 0x3f866154,
    0x0, 0x0, 0xbf666666, 0x3f84b92d,
    0x0, 0x0, 0xbf666666, 0x3f8316fa,
    0x0, 0x0, 0xbf666666, 0x3f817a94,
    0x0, 0x0, 0xbf666666, 0x3f7fc7a7,
    0x0, 0x0, 0xbf666666, 0x3f7ca52a,
    0x0, 0x0, 0xbf666666, 0x3f798d66,
    0x0, 0x0, 0xbf666666, 0x3f768017,
    0x0, 0x0, 0xbf666666, 0x3f737cf8,
    0x0, 0x0, 0xbf666666, 0x3f7083ca,
    0x0, 0x0, 0xbf666666, 0x3f6d944b,
    0x0, 0x0, 0xbf666666, 0x3f6aae40,
    0x0, 0x0, 0xbf666666, 0x3f67d16d,
    0x0, 0x0, 0xbf666666, 0x3f64fd98,
    0x0, 0x0, 0xbf666666, 0x3f62328a,
    0x0, 0x0, 0xbf666666, 0x3f5f700b,
    0x0, 0x0, 0xbf666666, 0x3f5cb5e9,
    0x0, 0x0, 0xbf666666, 0x3f5a03ef,
    0x0, 0x0, 0xbf666666, 0x3f5759ec,
    0x0, 0x0, 0xbf666666, 0x3f54b7b1,
    0x0, 0x0, 0xbf666666, 0x3f521d0e,
    0x0, 0x0, 0xbf666666, 0x3f4f89d7,
    0x0, 0x0, 0xbf666666, 0x3f4cfddf,
    0x0, 0x0, 0xbf666666, 0x3f4a78fb,
    0x0, 0x0, 0xbf666666, 0x3f47fb02,
    0x0, 0x0, 0xbf666666, 0x3f4583cc,
    0x0, 0x0, 0xbf666666, 0x3f431331,
    0x0, 0x0, 0xbf666666, 0x3f40a90a,
    0x0, 0x0, 0xbf666666, 0x3f3e4534,
    0x0, 0x0, 0xbf666666, 0x3f3be788,
    0x0, 0x0, 0xbf666666, 0x3f398fe5,
    0x0, 0x0, 0xbf666666, 0x3f373e27,
    0x0, 0x0, 0xbf666666, 0x3f34f22e,
    0x0, 0x0, 0xbf666666, 0x3f32abd9,
    0x0, 0x0, 0xbf666666, 0x3f306b07,
    0x0, 0x0, 0xbf666666, 0x3f2e2f9b,
    0x0, 0x0, 0xbf666666, 0x3f2bf976,
    0x0, 0x0, 0xbf666666, 0x3f29c87a,
    0x0, 0x0, 0xbf666666, 0x3f279c8b,
    0x0, 0x0, 0xbf666666, 0x3f25758d,
    0x0, 0x0, 0xbf666666, 0x3f235364,
    0x0, 0x0, 0xbf666666, 0x3f2135f7,
    0x0, 0x0, 0xbf666666, 0x3f1f1d2b,
    0x0, 0x0, 0xbf666666, 0x3f1d08e6,
    0x0, 0x0, 0xbf666666, 0x3f1af910,
    0x0, 0x0, 0xbf666666, 0x3f18ed92,
    0x0, 0x0, 0xbf666666, 0x3f16e652,
    0x0, 0x0, 0xbf666666, 0x3f14e33a,
    0x0, 0x0, 0xbf666666, 0x3f12e435,
    0x0, 0x0, 0xbf666666, 0x3f10e92a,
    0x0, 0x0, 0xbf666666, 0x3f0ef206,
    0x0, 0x0, 0xbf666666, 0x3f0cfeb3,
    0x0, 0x0, 0xbf666666, 0x3f0b0f1c,
    0x0, 0x0, 0xbf666666, 0x3f09232d,
    0x0, 0x0, 0xbf666666, 0x3f073ad3,
    0x0, 0x0, 0xbf666666, 0x3f0555fa,
    0x0, 0x0, 0xbf666666, 0x3f037490,
    0x0, 0x0, 0xbf666666, 0x3f019681,
    0x0, 0x0, 0xbf666666, 0x3eff7778,
    0x0, 0x0, 0xbf666666, 0x3efbc85f,
    0x0, 0x0, 0xbf666666, 0x3ef81f93,
    0x0, 0x0, 0xbf666666, 0x3ef47cf3,
    0x0, 0x0, 0xbf666666, 0x3ef0e05d,
    0x0, 0x0, 0xbf666666, 0x3eed49b0,
    0x0, 0x0, 0xbf666666, 0x3ee9b8cd,
    0x0, 0x0, 0xbf666666, 0x3ee62d94,
    0x0, 0x0, 0xbf666666, 0x3ee2a7e7,
    0x0, 0x0, 0xbf666666, 0x3edf27a7,
    0x0, 0x0, 0xbf666666, 0x3edbacb6,
    0x0, 0x0, 0xbf666666, 0x3ed836f7,
    0x0, 0x0, 0xbf666666, 0x3ed4c64f,
    0x0, 0x0, 0xbf666666, 0x3ed15aa0,
    0x0, 0x0, 0xbf666666, 0x3ecdf3d0,
    0x0, 0x0, 0xbf666666, 0x3eca91c3,
    0x0, 0x0, 0xbf666666, 0x3ec73460,
    0x0, 0x0, 0xbf666666, 0x3ec3db8b,
    0x0, 0x0, 0xbf666666, 0x3ec0872b,
    0x0, 0x0, 0xbf666666, 0x3ebd3727,
    0x0, 0x0, 0xbf666666, 0x3eb9eb66,
    0x0, 0x0, 0xbf666666, 0x3eb6a3d0,
    0x0, 0x0, 0xbf666666, 0x3eb3604d,
    0x0, 0x0, 0xbf666666, 0x3eb020c6,
    0x0, 0x0, 0xbf666666, 0x3eace522,
    0x0, 0x0, 0xbf666666, 0x3ea9ad4c,
    0x0, 0x0, 0xbf666666, 0x3ea6792d,
    0x0, 0x0, 0xbf666666, 0x3ea348ae,
    0x0, 0x0, 0xbf666666, 0x3ea01bbb,
    0x0, 0x0, 0xbf666666, 0x3e9cf23d,
    0x0, 0x0, 0xbf666666, 0x3e99cc20,
    0x0, 0x0, 0xbf666666, 0x3e96a94d,
    0x0, 0x0, 0xbf666666, 0x3e9389b2,
    0x0, 0x0, 0xbf666666, 0x3e906d3a,
    0x0, 0x0, 0xbf666666, 0x3e8d53d1,
    0x0, 0x0, 0xbf666666, 0x3e8a3d62,
    0x0, 0x0, 0xbf666666, 0x3e8729db,
    0x0, 0x0, 0xbf666666, 0x3e841929,
    0x0, 0x0, 0xbf666666, 0x3e810b38,
    0x0, 0x0, 0xbf666666, 0x3e7bffeb,
    0x0, 0x0, 0xbf666666, 0x3e75ee9f,
    0x0, 0x0, 0xbf666666, 0x3e6fe267,
    0x0, 0x0, 0xbf666666, 0x3e69db1f,
    0x0, 0x0, 0xbf666666, 0x3e63d8a3,
    0x0, 0x0, 0xbf666666, 0x3e5ddad1,
    0x0, 0x0, 0xbf666666, 0x3e57e185,
    0x0, 0x0, 0xbf666666, 0x3e51ec9d,
    0x0, 0x0, 0xbf666666, 0x3e4bfbf6,
    0x0, 0x0, 0xbf666666, 0x3e460f70,
    0x0, 0x0, 0xbf666666, 0x3e4026e8,
    0x0, 0x0, 0xbf666666, 0x3e3a423d,
    0x0, 0x0, 0xbf666666, 0x3e34614f,
    0x0, 0x0, 0xbf666666, 0x3e2e83fe,
    0x0, 0x0, 0xbf666666, 0x3e28aa28,
    0x0, 0x0, 0xbf666666, 0x3e22d3af,
    0x0, 0x0, 0xbf666666, 0x3e1d0073,
    0x0, 0x0, 0xbf666666, 0x3e173053,
    0x0, 0x0, 0xbf666666, 0x3e116332,
    0x0, 0x0, 0xbf666666, 0x3e0b98f0,
    0x0, 0x0, 0xbf666666, 0x3e05d16f,
    0x0, 0x0, 0xbf666666, 0x3e000c91,
    0x0, 0x0, 0xbf666666, 0x3df4946c,
    0x0, 0x0, 0xbf666666, 0x3de91483,
    0x0, 0x0, 0xbf666666, 0x3ddd992a,
    0x0, 0x0, 0xbf666666, 0x3dd22227,
    0x0, 0x0, 0xbf666666, 0x3dc6af3e,
    0x0, 0x0, 0xbf666666, 0x3dbb4036,
    0x0, 0x0, 0xbf666666, 0x3dafd4d3,
    0x0, 0x0, 0xbf666666, 0x3da46cdb,
    0x0, 0x0, 0xbf666666, 0x3d990816,
    0x0, 0x0, 0xbf666666, 0x3d8da648,
    0x0, 0x0, 0xbf666666, 0x3d82473a,
    0x0, 0x0, 0xbf666666, 0x3d6dd565,
    0x0, 0x0, 0xbf666666, 0x3d5720ef,
    0x0, 0x0, 0xbf666666, 0x3d4070a3,
    0x0, 0x0, 0xbf666666, 0x3d29c410,
    0x0, 0x0, 0xbf666666, 0x3d131ac3,
    0x0, 0x0, 0xbf666666, 0x3cf8e89d,
    0x0, 0x0, 0xbf666666, 0x3ccba080,
    0x0, 0x0, 0xbf666666, 0x3c9e5c51,
    0x0, 0x0, 0xbf666666, 0x3c623661,
    0x0, 0x0, 0xbf666666, 0x3c07b87c,
    0x0, 0x0, 0xbf666666, 0x3b34f4d0,
    0x0
    };

static const uint32_t ref_rfft_step_1024[1025] = {
    0x43e66666, 0x0, 0xbf666666, 0x4392ad3f,
    0x0, 0x80000000, 0xbf666666, 0x42c39067,
    0x0, 0x0, 0xbf666666, 0x426aaa44,
    0x0, 0x0, 0xbf666666, 0x42279af6,
    0x0, 0x80000000, 0xbf666666, 0x420258ba,
    0x0, 0x0, 0xbf666666, 0x41d54485,
    0x0, 0x0, 0xbf666666, 0x41b46e18,
    0x0, 0x0, 0xbf666666, 0x419c5860,
    0x0, 0x0, 0xbf666666, 0x4189ec87,
    0x0, 0x0, 0xbf666666, 0x4176c163,
    0x0, 0x0, 0xbf666666, 0x415f32e3,
    0x0, 0x0, 0xbf666666, 0x414bbbdb,
    0x0, 0x0, 0xbf666666, 0x413b60e6,
    0x0, 0x0, 0xbf666666, 0x412d711d,
    0x0, 0x0, 0xbf666666, 0x41216c65,
    0x0, 0x0, 0xbf666666, 0x4116f3b2,
    0x0, 0x80000000, 0xbf666666, 0x410dbf03,
    0x0, 0x0, 0xbf666666, 0x410596cc,
    0x0, 0x0, 0xbf666666, 0x40fc9f09,
    0x0, 0x0, 0xbf666666, 0x40ef8d22,
    0x0, 0x0, 0xbf666666, 0x40e3c02e,
    0x0, 0x0, 0xbf666666, 0x40d90ad5,
    0x0, 0x0, 0xbf666666, 0x40cf47d0,
    0x0, 0x0, 0xbf666666, 0x40c6582f,
    0x0, 0x0, 0xbf666666, 0x40be220e,
    0x0, 0x0, 0xbf666666, 0x40b68f9c,
    0x0, 0x0, 0xbf666666, 0x40af8e4f,
    0x0, 0x0, 0xbf666666, 0x40a90e53,
    0x0, 0x0, 0xbf666666, 0x40a3020a,
    0x0, 0x0, 0xbf666666, 0x409d5db0,
    0x0, 0x0, 0xbf666666, 0x4098170c,
    0x0, 0x0, 0xbf666666, 0x40932530,
    0x0, 0x0, 0xbf666666, 0x408e8049,
    0x0, 0x0, 0xbf666666, 0x408a2173,
    0x0, 0x0, 0xbf666666, 0x40860296,
    0x0, 0x0, 0xbf666666, 0x40821e49,
    0x0, 0x0, 0xbf666666, 0x407cdf77,
    0x0, 0x0, 0xbf666666, 0x4075e542,
    0x0, 0x0, 0xbf666666, 0x406f463e,
    0x0, 0x0, 0xbf666666, 0x4068fb7d,
    0x0, 0x0, 0xbf666666, 0x4062fec1,
    0x0, 0x0, 0xbf666666, 0x405d4a65,
    0x0, 0x0, 0xbf666666, 0x4057d94e,
    0x0, 0x0, 0xbf666666, 0x4052a6d6,
    0x0, 0x0, 0xbf666666, 0x404daec5,
    0x0, 0x0, 0xbf666666, 0x4048ed41,
    0x0, 0x0, 0xbf666666, 0x40445ec4,
    0x0, 0x0, 0xbf666666, 0x40400014,
    0x0, 0x0, 0xbf666666, 0x403bce3d,
    0x0, 0x0, 0xbf666666, 0x4037c686,
    0x0, 0x0, 0xbf666666, 0x4033e66d,
    0x0, 0x0, 0xbf666666, 0x40302ba4,
    0x0, 0x0, 0xbf666666, 0x402c9409,
    0x0, 0x0, 0xbf666666, 0x40291da1,
    0x0, 0x0, 0xbf666666, 0x4025c699,
    0x0, 0x0, 0xbf666666, 0x40228d3d,
    0x0, 0x0, 0xbf666666, 0x401f6ffb,
    0x0, 0x0, 0xbf666666, 0x401c6d59,
    0x0, 0x0, 0xbf666666, 0x401983fb,
    0x0, 0x0, 0xbf666666, 0x4016b29a,
    0x0, 0x0, 0xbf666666, 0x4013f804,
    0x0, 0x0, 0xbf666666, 0x4011531d,
    0x0, 0x0, 0xbf666666, 0x400ec2d9,
    0x0, 0x0, 0xbf666666, 0x400c463f,
    0x0, 0x80000000, 0xbf666666, 0x4009dc63,
    0x0, 0x0, 0xbf666666, 0x4007846a,
    0x0, 0x0, 0xbf666666, 0x40053d85,
    0x0, 0x0, 0xbf666666, 0x400306f0,
    0x0, 0x0, 0xbf666666, 0x4000dff5,
    0x0, 0x0, 0xbf666666, 0x3ffd8fcc,
    0x0, 0x0, 0xbf666666, 0x3ff97c41,
    0x0, 0x0, 0xbf666666, 0x3ff58415,
    0x0, 0x0, 0xbf666666, 0x3ff1a625,
    0x0, 0x0, 0xbf666666, 0x3fede15e,
    0x0, 0x0, 0xbf666666, 0x3fea34bb,
    0x0, 0x0, 0xbf666666, 0x3fe69f46,
    0x0, 0x0, 0xbf666666, 0x3fe32016,
    0x0, 0x0, 0xbf666666, 0x3fdfb64b,
    0x0, 0x0, 0xbf666666, 0x3fdc6115,
    0x0, 0x0, 0xbf666666, 0x3fd91fac,
    0x0, 0x0, 0xbf666666, 0x3fd5f150,
    0x0, 0x0, 0xbf666666, 0x3fd2d54f,
    0x0, 0x0, 0xbf666666, 0x3fcfcafb,
    0x0, 0x0, 0xbf666666, 0x3fccd1b1,
    0x0, 0x0, 0xbf666666, 0x3fc9e8d6,
    0x0, 0x0, 0xbf666666, 0x3fc70fd5,
    0x0, 0x0, 0xbf666666, 0x3fc44620,
    0x0, 0x0, 0xbf666666, 0x3fc18b2f,
    0x0, 0x0, 0xbf666666, 0x3fbede82,
    0x0, 0x0, 0xbf666666, 0x3fbc3f9d,
    0x0, 0x0, 0xbf666666, 0x3fb9ae0a,
    0x0, 0x0, 0xbf666666, 0x3fb72958,
    0x0, 0x0, 0xbf666666, 0x3fb4b11b,
    0x0, 0x0, 0xbf666666, 0x3fb244ec,
    0x0, 0x0, 0xbf666666, 0x3fafe468,
    0x0, 0x0, 0xbf666666, 0x3fad8f30,
    0x0, 0x0, 0xbf666666, 0x3fab44e8,
    0x0, 0x0, 0xbf666666, 0x3fa9053a,
    0x0, 0x0, 0xbf666666, 0x3fa6cfd2,
    0x0, 0x0, 0xbf666666, 0x3fa4a45f,
    0x0, 0x0, 0xbf666666, 0x3fa28294,
    0x0, 0x0, 0xbf666666, 0x3fa06a28,
    0x0, 0x0, 0xbf666666, 0x3f9e5ad3,
    0x0, 0x0, 0xbf666666, 0x3f9c544f,
    0x0, 0x0, 0xbf666666, 0x3f9a565c,
    0x0, 0x0, 0xbf666666, 0x3f9860ba,
    0x0, 0x0, 0xbf666666, 0x3f96732c,
    0x0, 0x0, 0xbf666666, 0x3f948d76,
    0x0, 0x0, 0xbf666666, 0x3f92af61,
    0x0, 0x0, 0xbf666666, 0x3f90d8b5,
    0x0, 0x0, 0xbf666666, 0x3f8f093f,
    0x0, 0x0, 0xbf666666, 0x3f8d40ca,
    0x0, 0x0, 0xbf666666, 0x3f8b7f27,
    0x0, 0x0, 0xbf666666, 0x3f89c426,
    0x0, 0x0, 0xbf666666, 0x3f880f99,
    0x0, 0x0, 0xbf666666, 0x3f866154,
    0x0, 0x0, 0xbf666666, 0x3f84b92d,
    0x0, 0x0, 0xbf666666, 0x3f8316fa,
    0x0, 0x0, 0xbf666666, 0x3f817a94,
    0x0, 0x0, 0xbf666666, 0x3f7fc7a7,
    0x0, 0x0, 0xbf666666, 0x3f7ca52a,
    0x0, 0x0, 0xbf666666, 0x3f798d66,
    0x0, 0x0, 0xbf666666, 0x3f768017,
    0x0, 0x0, 0xbf666666, 0x3f737cf8,
    0x0, 0x0, 0xbf666666, 0x3f7083ca,
    0x0, 0x0, 0xbf666666, 0x3f6d944b,
    0x0, 0x0, 0xbf666666, 0x3f6aae40,
    0x0, 0x0, 0xbf666666, 0x3f67d16d,
    0x0, 0x0, 0xbf666666, 0x3f64fd98,
    0x0, 0x0, 0xbf666666, 0x3f62328a,
    0x0, 0x0, 0xbf666666, 0x3f5f700b,
    0x0, 0x0, 0xbf666666, 0x3f5cb5e9,
    0x0, 0x0, 0xbf666666, 0x3f5a03ef,
    0x0, 0x0, 0xbf666666, 0x3f5759ec,
    0x0, 0x0, 0xbf666666, 0x3f54b7b1,
    0x0, 0x0, 0xbf666666, 0x3f521d0e,
    0x0, 0x0, 0xbf666666, 0x3f4f89d7,
    0x0, 0x0, 0xbf666666, 0x3f4cfddf,
    0x0, 0x0, 0xbf666666, 0x3f4a78fb,
    0x0, 0x0, 0xbf666666, 0x3f47fb02,
    0x0, 0x0, 0xbf666666, 0x3f4583cc,
    0x0, 0x0, 0xbf666666, 0x3f431331,
    0x0, 0x0, 0xbf666666, 0x3f40a90a,
    0x0, 0x0, 0xbf666666, 0x3f3e4534,
    0x0, 0x0, 0xbf666666, 0x3f3be788,
    0x0, 0x0, 0xbf666666, 0x3f398fe5,
    0x0, 0x0, 0xbf666666, 0x3f373e27,
    0x0, 0x0, 0xbf666666, 0x3f34f22e,
    0x0, 0x0, 0xbf666666, 0x3f32abd9,
    0x0, 0x0, 0xbf666666, 0x3f306b07,
    0x0, 0x0, 0xbf666666, 0x3f2e2f9b,
    0x0, 0x0, 0xbf666666, 0x3f2bf976,
    0x0, 0x0, 0xbf666666, 0x3f29c87a,
    0x0, 0x0, 0xbf666666, 0x3f279c8b,
    0x0, 0x0, 0xbf666666, 0x3f25758d,
    0x0, 0x0, 0xbf666666, 0x3f235364,
    0x0, 0x0, 0xbf666666, 0x3f2135f7,
    0x0, 0x0, 0xbf666666, 0x3f1f1d2b,
    0x0, 0x0, 0xbf666666, 0x3f1d08e6,
    0x0, 0x0, 0xbf666666, 0x3f1af910,
    0x0, 0x0, 0xbf666666, 0x3f18ed92,
    0x0, 0x0, 0xbf666666, 0x3f16e652,
    0x0, 0x0, 0xbf666666, 0x3f14e33a,
    0x0, 0x0, 0xbf666666, 0x3f12e435,
    0x0, 0x0, 0xbf666666, 0x3f10e92a,
    0x0, 0x0, 0xbf666666, 0x3f0ef206,
    0x0, 0x0, 0xbf666666, 0x3f0cfeb3,
    0x0, 0x0, 0xbf666666, 0x3f0b0f1c,
    0x0, 0x0, 0xbf666666, 0x3f09232d,
    0x0, 0x0, 0xbf666666, 0x3f073ad3,
    0x0, 0x0, 0xbf666666, 0x3f0555fa,
    0x0, 0x0, 0xbf666666, 0x3f037490,
    0x0, 0x0, 0xbf666666, 0x3f019681,
    0x0, 0x0, 0xbf666666, 0x3eff7778,
    0x0, 0x0, 0xbf666666, 0x3efbc85f,
    0x0, 0x0, 0xbf666666, 0x3ef81f93,
    0x0, 0x0, 0xbf666666, 0x3ef47cf3,
    0x0, 0x0, 0xbf666666, 0x3ef0e05d,
    0x0, 0x0, 0xbf666666, 0x3eed49b0,
    0x0, 0x0, 0xbf666666, 0x3ee9b8cd,
    0x0, 0x0, 0xbf666666, 0x3ee62d94,
    0x0, 0x0, 0xbf666666, 0x3ee2a7e7,
    0x0, 0x0, 0xbf666666, 0x3edf27a7,
    0x0, 0x0, 0xbf666666, 0x3edbacb6,
    0x0, 0x0, 0xbf666666, 0x3ed836f7,
    0x0, 0x0, 0xbf666666, 0x3ed4c64f,
    0x0, 0x0, 0xbf666666, 0x3ed15aa0,
    0x0, 0x0, 0xbf666666, 0x3ecdf3d0,
    0x0, 0x0, 0xbf666666, 0x3eca91c3,
    0x0, 0x0, 0xbf666666, 0x3ec73460,
    0x0, 0x0, 0xbf666666, 0x3ec3db8b,
    0x0, 0x0, 0xbf666666, 0x3ec0872b,
    0x0, 0x0, 0xbf666666, 0x3ebd3727,
    0x0, 0x0, 0xbf666666, 0x3eb9eb66,
    0x0, 0x0, 0xbf666666, 0x3eb6a3d0,
    0x0, 0x0, 0xbf666666, 0x3eb3604d,
    0x0, 0x0, 0xbf666666, 0x3eb020c6,
    0x0, 0x0, 0xbf666666, 0x3eace522,
    0x0, 0x0, 0xbf666666, 0x3ea9ad4c,
    0x0, 0x0, 0xbf666666, 0x3ea6792d,
    0x0, 0x0, 0xbf666666, 0x3ea348ae,
    0x0, 0x0, 0xbf666666, 0x3ea01bbb,
    0x0, 0x0, 0xbf666666, 0x3e9cf23d,
    0x0, 0x0, 0xbf666666, 0x3e99cc20,
    0x0, 0x0, 0xbf666666, 0x3e96a94d,
    0x0, 0x0, 0xbf666666, 0x3e9389b2,
    0x0, 0x0, 0xbf666666, 0x3e906d3a,
    0x0, 0x0, 0xbf666666, 0x3e8d53d1,
    0x0, 0x0, 0xbf666666, 0x3e8a3d62,
    0x0, 0x0, 0xbf666666, 0x3e8729db,
    0x0, 0x0, 0xbf666666, 0x3e841929,
    0x0, 0x0, 0xbf666666, 0x3e810b38,
    0x0, 0x0, 0xbf666666, 0x3e7bffeb,
    0x0, 0x0, 0xbf666666, 0x3e75ee9f,
    0x0, 0x0, 0xbf666666, 0x3e6fe267,
    0x0, 0x0, 0xbf666666, 0x3e69db1f,
    0x0, 0x0, 0xbf666666, 0x3e63d8a3,
    0x0, 0x0, 0xbf666666, 0x3e5ddad1,
    0x0, 0x0, 0xbf666666, 0x3e57e185,
    0x0, 0x0, 0xbf666666, 0x3e51ec9d,
    0x0, 0x0, 0xbf666666, 0x3e4bfbf6,
    0x0, 0x0, 0xbf666666, 0x3e460f70,
    0x0, 0x0, 0xbf666666, 0x3e4026e8,
    0x0, 0x0, 0xbf666666, 0x3e3a423d,
    0x0, 0x0, 0xbf666666, 0x3e34614f,
    0x0, 0x0, 0xbf666666, 0x3e2e83fe,
    0x0, 0x0, 0xbf666666, 0x3e28aa28,
    0x0, 0x0, 0xbf666666, 0x3e22d3af,
    0x0, 0x0, 0xbf666666, 0x3e1d0073,
    0x0, 0x0, 0xbf666666, 0x3e173053,
    0x0, 0x0, 0xbf666666, 0x3e116332,
    0x0, 0x0, 0xbf666666, 0x3e0b98f0,
    0x0, 0x0, 0xbf666666, 0x3e05d16f,
    0x0, 0x0, 0xbf666666, 0x3e000c91,
    0x0, 0x0, 0xbf666666, 0x3df4946c,
    0x0, 0x0, 0xbf666666, 0x3de91483,
    0x0, 0x0, 0xbf666666, 0x3ddd992a,
    0x0, 0x0, 0xbf666666, 0x3dd22227,
    0x0, 0x0, 0xbf666666, 0x3dc6af3e,
    0x0, 0x0, 0xbf666666, 0x3dbb4036,
    0x0, 0x0, 0xbf666666, 0x3dafd4d3,
    0x0, 0x0, 0xbf666666, 0x3da46cdb,
    0x0, 0x0, 0xbf666666, 0x3d990816,
    0x0, 0x0, 0xbf666666, 0x3d8da648,
    0x0, 0x0, 0xbf666666, 0x3d82473a,
    0x0, 0x0, 0xbf666666, 0x3d6dd565,
    0x0, 0x0, 0xbf666666, 0x3d5720ef,
    0x0, 0x0, 0xbf666666, 0x3d4070a3,
    0x0, 0x0, 0xbf666666, 0x3d29c410,
    0x0, 0x0, 0xbf666666, 0x3d131ac3,
    0x0, 0x0, 0xbf666666, 0x3cf8e89d,
    0x0, 0x0, 0xbf666666, 0x3ccba080,
    0x0, 0x0, 0xbf666666, 0x3c9e5c51,
    0x0, 0x0, 0xbf666666, 0x3c623661,
    0x0, 0x0, 0xbf666666, 0x3c07b87c,
    0x0, 0x0, 0xbf666666, 0x3b34f4d0,
    0x0
    };

static const uint32_t in_rfft_step_2048[2048] = {
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666
    };

static const uint32_t in_rifft_step_2048[2049] = {
    0x44666666, 0x0, 0xbf666666, 0x4412ad55,
    0x0, 0x80000000, 0xbf666666, 0x43439176,
    0x0, 0x0, 0xbf666666, 0x42eaadcd,
    0x0, 0x0, 0xbf666666, 0x42a79fe8,
    0x0, 0x80000000, 0xbf666666, 0x42825f17,
    0x0, 0x0, 0xbf666666, 0x42555412,
    0x0, 0x0, 0xbf666666, 0x42348079,
    0x0, 0x0, 0xbf666666, 0x421c6d96,
    0x0, 0x0, 0xbf666666, 0x420a0491,
    0x0, 0x0, 0xbf666666, 0x41f6f71f,
    0x0, 0x0, 0xbf666666, 0x41df6e48,
    0x0, 0x0, 0xbf666666, 0x41cbfce9,
    0x0, 0x0, 0xbf666666, 0x41bba79f,
    0x0, 0x0, 0xbf666666, 0x41adbd7f,
    0x0, 0x0, 0xbf666666, 0x41a1be72,
    0x0, 0x0, 0xbf666666, 0x41974b69,
    0x0, 0x80000000, 0xbf666666, 0x418e1c65,
    0x0, 0x0, 0xbf666666, 0x4185f9da,
    0x0, 0x0, 0xbf666666, 0x417d707d,
    0x0, 0x0, 0xbf666666, 0x417069ef,
    0x0, 0x0, 0xbf666666, 0x4164a856,
    0x0, 0x0, 0xbf666666, 0x4159fe59,
    0x0, 0x0, 0xbf666666, 0x415046b0,
    0x0, 0x0, 0xbf666666, 0x4147626c,
    0x0, 0x0, 0xbf666666, 0x413f37ab,
    0x0, 0x0, 0xbf666666, 0x4137b099,
    0x0, 0x0, 0xbf666666, 0x4130baae,
    0x0, 0x0, 0xbf666666, 0x412a4615,
    0x0, 0x0, 0xbf666666, 0x41244531,
    0x0, 0x0, 0xbf666666, 0x411eac3d,
    0x0, 0x0, 0xbf666666, 0x41197101,
    0x0, 0x0, 0xbf666666, 0x41148a8f,
    0x0, 0x0, 0xbf666666, 0x410ff113,
    0x0, 0x0, 0xbf666666, 0x410b9dab,
    0x0, 0x0, 0xbf666666, 0x41078a3c,
    0x0, 0x0, 0xbf666666, 0x4103b160,
    0x0, 0x0, 0xbf666666, 0x41000e46,
    0x0, 0x0, 0xbf666666, 0x40f93940,
    0x0, 0x0, 0xbf666666, 0x40f2b12a,
    0x0, 0x0, 0xbf666666, 0x40ec7d5c,
    0x0, 0x0, 0xbf666666, 0x40e69796,
    0x0, 0x0, 0xbf666666, 0x40e0fa35,
    0x0, 0x0, 0xbf666666, 0x40dba01e,
    0x0, 0x0, 0xbf666666, 0x40d684ab,
    0x0, 0x0, 0xbf666666, 0x40d1a3a3,
    0x0, 0x0, 0xbf666666, 0x40ccf92d,
    0x0, 0x0, 0xbf666666, 0x40c881c4,
    0x0, 0x0, 0xbf666666, 0x40c43a2d,
    0x0, 0x0, 0xbf666666, 0x40c01f74,
    0x0, 0x0, 0xbf666666, 0x40bc2ee0,
    0x0, 0x0, 0xbf666666, 0x40b865f0,
    0x0, 0x0, 0xbf666666, 0x40b4c256,
    0x0, 0x0, 0xbf666666, 0x40b141ef,
    0x0, 0x0, 0xbf666666, 0x40ade2c2,
    0x0, 0x0, 0xbf666666, 0x40aaa2fa,
    0x0, 0x0, 0xbf666666, 0x40a780e5,
    0x0, 0x0, 0xbf666666, 0x40a47aef,
    0x0, 0x0, 0xbf666666, 0x40a18fa1,
    0x0, 0x0, 0xbf666666, 0x409ebd9d,
    0x0, 0x0, 0xbf666666, 0x409c039c,
    0x0, 0x0, 0xbf666666, 0x4099606e,
    0x0, 0x0, 0xbf666666, 0x4096d2f5,
    0x0, 0x0, 0xbf666666, 0x40945a26,
    0x0, 0x0, 0xbf666666, 0x4091f508,
    0x0, 0x80000000, 0xbf666666, 0x408fa2b0,
    0x0, 0x0, 0xbf666666, 0x408d6243,
    0x0, 0x0, 0xbf666666, 0x408b32f0,
    0x0, 0x0, 0xbf666666, 0x408913f6,
    0x0, 0x0, 0xbf666666, 0x4087049c,
    0x0, 0x0, 0xbf666666, 0x40850438,
    0x0, 0x0, 0xbf666666, 0x40831224,
    0x0, 0x0, 0xbf666666, 0x40812dc8,
    0x0, 0x0, 0xbf666666, 0x407ead26,
    0x0, 0x0, 0xbf666666, 0x407b17f5,
    0x0, 0x0, 0xbf666666, 0x40779af9,
    0x0, 0x0, 0xbf666666, 0x4074353d,
    0x0, 0x0, 0xbf666666, 0x4070e5d7,
    0x0, 0x0, 0xbf666666, 0x406dabe9,
    0x0, 0x0, 0xbf666666, 0x406a86a1,
    0x0, 0x0, 0xbf666666, 0x40677539,
    0x0, 0x0, 0xbf666666, 0x406476f1,
    0x0, 0x0, 0xbf666666, 0x40618b16,
    0x0, 0x0, 0xbf666666, 0x405eb0fd,
    0x0, 0x0, 0xbf666666, 0x405be801,
    0x0, 0x0, 0xbf666666, 0x40592f88,
    0x0, 0x0, 0xbf666666, 0x405686fd,
    0x0, 0x0, 0xbf666666, 0x4053edd2,
    0x0, 0x0, 0xbf666666, 0x40516380,
    0x0, 0x0, 0xbf666666, 0x404ee787,
    0x0, 0x0, 0xbf666666, 0x404c796b,
    0x0, 0x0, 0xbf666666, 0x404a18b7,
    0x0, 0x0, 0xbf666666, 0x4047c4fa,
    0x0, 0x0, 0xbf666666, 0x40457dc9,
    0x0, 0x0, 0xbf666666, 0x404342bb,
    0x0, 0x0, 0xbf666666, 0x4041136f,
    0x0, 0x0, 0xbf666666, 0x403eef86,
    0x0, 0x0, 0xbf666666, 0x403cd6a6,
    0x0, 0x0, 0xbf666666, 0x403ac876,
    0x0, 0x0, 0xbf666666, 0x4038c4a5,
    0x0, 0x0, 0xbf666666, 0x4036cae1,
    0x0, 0x0, 0xbf666666, 0x4034dade,
    0x0, 0x0, 0xbf666666, 0x4032f452,
    0x0, 0x0, 0xbf666666, 0x403116f6,
    0x0, 0x0, 0xbf666666, 0x402f4286,
    0x0, 0x0, 0xbf666666, 0x402d76c0,
    0x0, 0x0, 0xbf666666, 0x402bb365,
    0x0, 0x0, 0xbf666666, 0x4029f838,
    0x0, 0x0, 0xbf666666, 0x40284500,
    0x0, 0x0, 0xbf666666, 0x40269982,
    0x0, 0x0, 0xbf666666, 0x4024f58a,
    0x0, 0x0, 0xbf666666, 0x402358e2,
    0x0, 0x0, 0xbf666666, 0x4021c359,
    0x0, 0x0, 0xbf666666, 0x402034be,
    0x0, 0x0, 0xbf666666, 0x401eace1,
    0x0, 0x0, 0xbf666666, 0x401d2b96,
    0x0, 0x0, 0xbf666666, 0x401bb0b1,
    0x0, 0x0, 0xbf666666, 0x401a3c07,
    0x0, 0x0, 0xbf666666, 0x4018cd70,
    0x0, 0x0, 0xbf666666, 0x401764c4,
    0x0, 0x0, 0xbf666666, 0x401601dd,
    0x0, 0x0, 0xbf666666, 0x4014a496,
    0x0, 0x0, 0xbf666666, 0x40134ccd,
    0x0, 0x0, 0xbf666666, 0x4011fa5d,
    0x0, 0x0, 0xbf666666, 0x4010ad26,
    0x0, 0x0, 0xbf666666, 0x400f6508,
    0x0, 0x0, 0xbf666666, 0x400e21e4,
    0x0, 0x0, 0xbf666666, 0x400ce39a,
    0x0, 0x0, 0xbf666666, 0x400baa0f,
    0x0, 0x0, 0xbf666666, 0x400a7524,
    0x0, 0x0, 0xbf666666, 0x400944c0,
    0x0, 0x0, 0xbf666666, 0x400818c7,
    0x0, 0x0, 0xbf666666, 0x4006f11f,
    0x0, 0x0, 0xbf666666, 0x4005cdaf,
    0x0, 0x0, 0xbf666666, 0x4004ae5f,
    0x0, 0x0, 0xbf666666, 0x40039318,
    0x0, 0x0, 0xbf666666, 0x40027bc2,
    0x0, 0x0, 0xbf666666, 0x40016847,
    0x0, 0x0, 0xbf666666, 0x40005892,
    0x0, 0x0, 0xbf666666, 0x3ffe9919,
    0x0, 0x0, 0xbf666666, 0x3ffc8848,
    0x0, 0x0, 0xbf666666, 0x3ffa7e87,
    0x0, 0x0, 0xbf666666, 0x3ff87bb1,
    0x0, 0x0, 0xbf666666, 0x3ff67fa0,
    0x0, 0x0, 0xbf666666, 0x3ff48a2f,
    0x0, 0x0, 0xbf666666, 0x3ff29b3b,
    0x0, 0x0, 0xbf666666, 0x3ff0b2a2,
    0x0, 0x0, 0xbf666666, 0x3feed042,
    0x0, 0x0, 0xbf666666, 0x3fecf3fc,
    0x0, 0x0, 0xbf666666, 0x3feb1dae,
    0x0, 0x0, 0xbf666666, 0x3fe94d3b,
    0x0, 0x0, 0xbf666666, 0x3fe78284,
    0x0, 0x0, 0xbf666666, 0x3fe5bd6d,
    0x0, 0x0, 0xbf666666, 0x3fe3fdd8,
    0x0, 0x0, 0xbf666666, 0x3fe243aa,
    0x0, 0x0, 0xbf666666, 0x3fe08ec8,
    0x0, 0x0, 0xbf666666, 0x3fdedf18,
    0x0, 0x0, 0xbf666666, 0x3fdd3480,
    0x0, 0x0, 0xbf666666, 0x3fdb8ee7,
    0x0, 0x0, 0xbf666666, 0x3fd9ee35,
    0x0, 0x0, 0xbf666666, 0x3fd85253,
    0x0, 0x0, 0xbf666666, 0x3fd6bb28,
    0x0, 0x0, 0xbf666666, 0x3fd5289e,
    0x0, 0x0, 0xbf666666, 0x3fd39aa0,
    0x0, 0x0, 0xbf666666, 0x3fd21118,
    0x0, 0x0, 0xbf666666, 0x3fd08bf1,
    0x0, 0x0, 0xbf666666, 0x3fcf0b16,
    0x0, 0x0, 0xbf666666, 0x3fcd8e73,
    0x0, 0x0, 0xbf666666, 0x3fcc15f6,
    0x0, 0x0, 0xbf666666, 0x3fcaa18b,
    0x0, 0x0, 0xbf666666, 0x3fc9311f,
    0x0, 0x0, 0xbf666666, 0x3fc7c4a1,
    0x0, 0x0, 0xbf666666, 0x3fc65bfe,
    0x0, 0x0, 0xbf666666, 0x3fc4f726,
    0x0, 0x0, 0xbf666666, 0x3fc39607,
    0x0, 0x0, 0xbf666666, 0x3fc23890,
    0x0, 0x0, 0xbf666666, 0x3fc0deb3,
    0x0, 0x0, 0xbf666666, 0x3fbf885e,
    0x0, 0x0, 0xbf666666, 0x3fbe3583,
    0x0, 0x0, 0xbf666666, 0x3fbce612,
    0x0, 0x0, 0xbf666666, 0x3fbb99fd,
    0x0, 0x0, 0xbf666666, 0x3fba5135,
    0x0, 0x0, 0xbf666666, 0x3fb90bad,
    0x0, 0x0, 0xbf666666, 0x3fb7c956,
    0x0, 0x0, 0xbf666666, 0x3fb68a22,
    0x0, 0x0, 0xbf666666, 0x3fb54e05,
    0x0, 0x0, 0xbf666666, 0x3fb414f2,
    0x0, 0x0, 0xbf666666, 0x3fb2dedc,
    0x0, 0x0, 0xbf666666, 0x3fb1abb7,
    0x0, 0x0, 0xbf666666, 0x3fb07b76,
    0x0, 0x0, 0xbf666666, 0x3faf4e0e,
    0x0, 0x0, 0xbf666666, 0x3fae2374,
    0x0, 0x0, 0xbf666666, 0x3facfb9b,
    0x0, 0x0, 0xbf666666, 0x3fabd678,
    0x0, 0x0, 0xbf666666, 0x3faab401,
    0x0, 0x0, 0xbf666666, 0x3fa9942c,
    0x0, 0x0, 0xbf666666, 0x3fa876ec,
    0x0, 0x0, 0xbf666666, 0x3fa75c3a,
    0x0, 0x0, 0xbf666666, 0x3fa64409,
    0x0, 0x0, 0xbf666666, 0x3fa52e51,
    0x0, 0x0, 0xbf666666, 0x3fa41b07,
    0x0, 0x0, 0xbf666666, 0x3fa30a23,
    0x0, 0x0, 0xbf666666, 0x3fa1fb9b,
    0x0, 0x0, 0xbf666666, 0x3fa0ef66,
    0x0, 0x0, 0xbf666666, 0x3f9fe57b,
    0x0, 0x0, 0xbf666666, 0x3f9eddd2,
    0x0, 0x0, 0xbf666666, 0x3f9dd861,
    0x0, 0x0, 0xbf666666, 0x3f9cd520,
    0x0, 0x0, 0xbf666666, 0x3f9bd407,
    0x0, 0x0, 0xbf666666, 0x3f9ad50f,
    0x0, 0x0, 0xbf666666, 0x3f99d82f,
    0x0, 0x0, 0xbf666666, 0x3f98dd5e,
    0x0, 0x0, 0xbf666666, 0x3f97e497,
    0x0, 0x0, 0xbf666666, 0x3f96edd1,
    0x0, 0x0, 0xbf666666, 0x3f95f904,
    0x0, 0x0, 0xbf666666, 0x3f95062a,
    0x0, 0x0, 0xbf666666, 0x3f94153c,
    0x0, 0x0, 0xbf666666, 0x3f932632,
    0x0, 0x0, 0xbf666666, 0x3f923906,
    0x0, 0x0, 0xbf666666, 0x3f914db1,
    0x0, 0x0, 0xbf666666, 0x3f90642d,
    0x0, 0x0, 0xbf666666, 0x3f8f7c72,
    0x0, 0x0, 0xbf666666, 0x3f8e967b,
    0x0, 0x0, 0xbf666666, 0x3f8db242,
    0x0, 0x0, 0xbf666666, 0x3f8ccfc0,
    0x0, 0x0, 0xbf666666, 0x3f8beeef,
    0x0, 0x0, 0xbf666666, 0x3f8b0fc9,
    0x0, 0x0, 0xbf666666, 0x3f8a3249,
    0x0, 0x0, 0xbf666666, 0x3f895669,
    0x0, 0x0, 0xbf666666, 0x3f887c24,
    0x0, 0x0, 0xbf666666, 0x3f87a372,
    0x0, 0x0, 0xbf666666, 0x3f86cc51,
    0x0, 0x0, 0xbf666666, 0x3f85f6b9,
    0x0, 0x0, 0xbf666666, 0x3f8522a6,
    0x0, 0x0, 0xbf666666, 0x3f845013,
    0x0, 0x0, 0xbf666666, 0x3f837efa,
    0x0, 0x0, 0xbf666666, 0x3f82af57,
    0x0, 0x0, 0xbf666666, 0x3f81e124,
    0x0, 0x0, 0xbf666666, 0x3f81145e,
    0x0, 0x0, 0xbf666666, 0x3f8048fe,
    0x0, 0x0, 0xbf666666, 0x3f7efe03,
    0x0, 0x0, 0xbf666666, 0x3f7d6cc5,
    0x0, 0x0, 0xbf666666, 0x3f7bde3a,
    0x0, 0x0, 0xbf666666, 0x3f7a5259,
    0x0, 0x0, 0xbf666666, 0x3f78c91a,
    0x0, 0x0, 0xbf666666, 0x3f774273,
    0x0, 0x0, 0xbf666666, 0x3f75be5d,
    0x0, 0x0, 0xbf666666, 0x3f743ccf,
    0x0, 0x0, 0xbf666666, 0x3f72bdc1,
    0x0, 0x0, 0xbf666666, 0x3f71412a,
    0x0, 0x0, 0xbf666666, 0x3f6fc704,
    0x0, 0x0, 0xbf666666, 0x3f6e4f46,
    0x0, 0x0, 0xbf666666, 0x3f6cd9e8,
    0x0, 0x0, 0xbf666666, 0x3f6b66e4,
    0x0, 0x0, 0xbf666666, 0x3f69f631,
    0x0, 0x0, 0xbf666666, 0x3f6887c8,
    0x0, 0x0, 0xbf666666, 0x3f671ba2,
    0x0, 0x80000000, 0xbf666666, 0x3f65b1b9,
    0x0, 0x0, 0xbf666666, 0x3f644a04,
    0x0, 0x0, 0xbf666666, 0x3f62e47e,
    0x0, 0x0, 0xbf666666, 0x3f61811f,
    0x0, 0x0, 0xbf666666, 0x3f601fe0,
    0x0, 0x0, 0xbf666666, 0x3f5ec0bc,
    0x0, 0x0, 0xbf666666, 0x3f5d63ab,
    0x0, 0x0, 0xbf666666, 0x3f5c08a8,
    0x0, 0x0, 0xbf666666, 0x3f5aafac,
    0x0, 0x0, 0xbf666666, 0x3f5958b1,
    0x0, 0x0, 0xbf666666, 0x3f5803b0,
    0x0, 0x0, 0xbf666666, 0x3f56b0a5,
    0x0, 0x0, 0xbf666666, 0x3f555f88,
    0x0, 0x0, 0xbf666666, 0x3f541054,
    0x0, 0x0, 0xbf666666, 0x3f52c303,
    0x0, 0x0, 0xbf666666, 0x3f517790,
    0x0, 0x0, 0xbf666666, 0x3f502df5,
    0x0, 0x0, 0xbf666666, 0x3f4ee62d,
    0x0, 0x0, 0xbf666666, 0x3f4da031,
    0x0, 0x0, 0xbf666666, 0x3f4c5bfe,
    0x0, 0x0, 0xbf666666, 0x3f4b198c,
    0x0, 0x0, 0xbf666666, 0x3f49d8d9,
    0x0, 0x0, 0xbf666666, 0x3f4899dd,
    0x0, 0x0, 0xbf666666, 0x3f475c94,
    0x0, 0x0, 0xbf666666, 0x3f4620fa,
    0x0, 0x0, 0xbf666666, 0x3f44e708,
    0x0, 0x0, 0xbf666666, 0x3f43aebb,
    0x0, 0x0, 0xbf666666, 0x3f42780e,
    0x0, 0x0, 0xbf666666, 0x3f4142fb,
    0x0, 0x0, 0xbf666666, 0x3f400f7f,
    0x0, 0x0, 0xbf666666, 0x3f3edd94,
    0x0, 0x0, 0xbf666666, 0x3f3dad36,
    0x0, 0x0, 0xbf666666, 0x3f3c7e61,
    0x0, 0x0, 0xbf666666, 0x3f3b5110,
    0x0, 0x0, 0xbf666666, 0x3f3a253f,
    0x0, 0x0, 0xbf666666, 0x3f38fae9,
    0x0, 0x0, 0xbf666666, 0x3f37d20b,
    0x0, 0x0, 0xbf666666, 0x3f36aaa0,
    0x0, 0x0, 0xbf666666, 0x3f3584a4,
    0x0, 0x0, 0xbf666666, 0x3f346013,
    0x0, 0x0, 0xbf666666, 0x3f333ce9,
    0x0, 0x0, 0xbf666666, 0x3f321b21,
    0x0, 0x0, 0xbf666666, 0x3f30fab9,
    0x0, 0x0, 0xbf666666, 0x3f2fdbac,
    0x0, 0x0, 0xbf666666, 0x3f2ebdf6,
    0x0, 0x0, 0xbf666666, 0x3f2da194,
    0x0, 0x0, 0xbf666666, 0x3f2c8682,
    0x0, 0x0, 0xbf666666, 0x3f2b6cbc,
    0x0, 0x0, 0xbf666666, 0x3f2a543e,
    0x0, 0x0, 0xbf666666, 0x3f293d06,
    0x0, 0x0, 0xbf666666, 0x3f28270f,
    0x0, 0x0, 0xbf666666, 0x3f271256,
    0x0, 0x0, 0xbf666666, 0x3f25fed7,
    0x0, 0x0, 0xbf666666, 0x3f24ec90,
    0x0, 0x0, 0xbf666666, 0x3f23db7c,
    0x0, 0x0, 0xbf666666, 0x3f22cb98,
    0x0, 0x0, 0xbf666666, 0x3f21bce2,
    0x0, 0x0, 0xbf666666, 0x3f20af56,
    0x0, 0x0, 0xbf666666, 0x3f1fa2f0,
    0x0, 0x0, 0xbf666666, 0x3f1e97ae,
    0x0, 0x0, 0xbf666666, 0x3f1d8d8c,
    0x0, 0x0, 0xbf666666, 0x3f1c8487,
    0x0, 0x0, 0xbf666666, 0x3f1b7c9d,
    0x0, 0x0, 0xbf666666, 0x3f1a75c9,
    0x0, 0x0, 0xbf666666, 0x3f19700a,
    0x0, 0x0, 0xbf666666, 0x3f186b5d,
    0x0, 0x0, 0xbf666666, 0x3f1767bd,
    0x0, 0x0, 0xbf666666, 0x3f166529,
    0x0, 0x0, 0xbf666666, 0x3f15639e,
    0x0, 0x0, 0xbf666666, 0x3f146318,
    0x0, 0x0, 0xbf666666, 0x3f136396,
    0x0, 0x0, 0xbf666666, 0x3f126513,
    0x0, 0x0, 0xbf666666, 0x3f11678e,
    0x0, 0x0, 0xbf666666, 0x3f106b05,
    0x0, 0x0, 0xbf666666, 0x3f0f6f73,
    0x0, 0x0, 0xbf666666, 0x3f0e74d6,
    0x0, 0x0, 0xbf666666, 0x3f0d7b2d,
    0x0, 0x0, 0xbf666666, 0x3f0c8274,
    0x0, 0x0, 0xbf666666, 0x3f0b8aa9,
    0x0, 0x0, 0xbf666666, 0x3f0a93c9,
    0x0, 0x0, 0xbf666666, 0x3f099dd2,
    0x0, 0x0, 0xbf666666, 0x3f08a8c1,
    0x0, 0x0, 0xbf666666, 0x3f07b495,
    0x0, 0x0, 0xbf666666, 0x3f06c149,
    0x0, 0x0, 0xbf666666, 0x3f05cedd,
    0x0, 0x0, 0xbf666666, 0x3f04dd4e,
    0x0, 0x0, 0xbf666666, 0x3f03ec99,
    0x0, 0x0, 0xbf666666, 0x3f02fcbc,
    0x0, 0x0, 0xbf666666, 0x3f020db5,
    0x0, 0x0, 0xbf666666, 0x3f011f82,
    0x0, 0x0, 0xbf666666, 0x3f00321f,
    0x0, 0x0, 0xbf666666, 0x3efe8b19,
    0x0, 0x0, 0xbf666666, 0x3efcb38d,
    0x0, 0x0, 0xbf666666, 0x3efadd96,
    0x0, 0x0, 0xbf666666, 0x3ef90931,
    0x0, 0x0, 0xbf666666, 0x3ef73658,
    0x0, 0x0, 0xbf666666, 0x3ef56509,
    0x0, 0x0, 0xbf666666, 0x3ef3953e,
    0x0, 0x0, 0xbf666666, 0x3ef1c6f3,
    0x0, 0x0, 0xbf666666, 0x3eeffa25,
    0x0, 0x0, 0xbf666666, 0x3eee2ecf,
    0x0, 0x0, 0xbf666666, 0x3eec64ee,
    0x0, 0x0, 0xbf666666, 0x3eea9c7d,
    0x0, 0x0, 0xbf666666, 0x3ee8d578,
    0x0, 0x0, 0xbf666666, 0x3ee70fdc,
    0x0, 0x0, 0xbf666666, 0x3ee54ba5,
    0x0, 0x0, 0xbf666666, 0x3ee388cf,
    0x0, 0x0, 0xbf666666, 0x3ee1c756,
    0x0, 0x0, 0xbf666666, 0x3ee00736,
    0x0, 0x0, 0xbf666666, 0x3ede486c,
    0x0, 0x0, 0xbf666666, 0x3edc8af4,
    0x0, 0x0, 0xbf666666, 0x3edaceca,
    0x0, 0x0, 0xbf666666, 0x3ed913ec,
    0x0, 0x0, 0xbf666666, 0x3ed75a54,
    0x0, 0x0, 0xbf666666, 0x3ed5a200,
    0x0, 0x0, 0xbf666666, 0x3ed3eaed,
    0x0, 0x0, 0xbf666666, 0x3ed23516,
    0x0, 0x0, 0xbf666666, 0x3ed08079,
    0x0, 0x0, 0xbf666666, 0x3ececd11,
    0x0, 0x0, 0xbf666666, 0x3ecd1adc,
    0x0, 0x0, 0xbf666666, 0x3ecb69d6,
    0x0, 0x0, 0xbf666666, 0x3ec9b9fc,
    0x0, 0x0, 0xbf666666, 0x3ec80b4a,
    0x0, 0x0, 0xbf666666, 0x3ec65dbe,
    0x0, 0x0, 0xbf666666, 0x3ec4b154,
    0x0, 0x0, 0xbf666666, 0x3ec30609,
    0x0, 0x0, 0xbf666666, 0x3ec15bd9,
    0x0, 0x0, 0xbf666666, 0x3ebfb2c2,
    0x0, 0x0, 0xbf666666, 0x3ebe0ac0,
    0x0, 0x0, 0xbf666666, 0x3ebc63d1,
    0x0, 0x0, 0xbf666666, 0x3ebabdf1,
    0x0, 0x0, 0xbf666666, 0x3eb9191d,
    0x0, 0x0, 0xbf666666, 0x3eb77553,
    0x0, 0x0, 0xbf666666, 0x3eb5d28f,
    0x0, 0x0, 0xbf666666, 0x3eb430cd,
    0x0, 0x0, 0xbf666666, 0x3eb2900d,
    0x0, 0x0, 0xbf666666, 0x3eb0f049,
    0x0, 0x0, 0xbf666666, 0x3eaf5180,
    0x0, 0x0, 0xbf666666, 0x3eadb3af,
    0x0, 0x0, 0xbf666666, 0x3eac16d2,
    0x0, 0x0, 0xbf666666, 0x3eaa7ae8,
    0x0, 0x0, 0xbf666666, 0x3ea8dfec,
    0x0, 0x0, 0xbf666666, 0x3ea745dd,
    0x0, 0x0, 0xbf666666, 0x3ea5acb7,
    0x0, 0x0, 0xbf666666, 0x3ea41478,
    0x0, 0x0, 0xbf666666, 0x3ea27d1d,
    0x0, 0x0, 0xbf666666, 0x3ea0e6a4,
    0x0, 0x0, 0xbf666666, 0x3e9f5109,
    0x0, 0x0, 0xbf666666, 0x3e9dbc4b,
    0x0, 0x0, 0xbf666666, 0x3e9c2865,
    0x0, 0x0, 0xbf666666, 0x3e9a9557,
    0x0, 0x0, 0xbf666666, 0x3e99031d,
    0x0, 0x0, 0xbf666666, 0x3e9771b4,
    0x0, 0x0, 0xbf666666, 0x3e95e11a,
    0x0, 0x0, 0xbf666666, 0x3e94514d,
    0x0, 0x0, 0xbf666666, 0x3e92c24a,
    0x0, 0x0, 0xbf666666, 0x3e91340e,
    0x0, 0x0, 0xbf666666, 0x3e8fa697,
    0x0, 0x0, 0xbf666666, 0x3e8e19e3,
    0x0, 0x0, 0xbf666666, 0x3e8c8dee,
    0x0, 0x0, 0xbf666666, 0x3e8b02b7,
    0x0, 0x0, 0xbf666666, 0x3e89783b,
    0x0, 0x0, 0xbf666666, 0x3e87ee78,
    0x0, 0x0, 0xbf666666, 0x3e86656b,
    0x0, 0x0, 0xbf666666, 0x3e84dd12,
    0x0, 0x0, 0xbf666666, 0x3e83556b,
    0x0, 0x0, 0xbf666666, 0x3e81ce73,
    0x0, 0x0, 0xbf666666, 0x3e804827,
    0x0, 0x0, 0xbf666666, 0x3e7d850d,
    0x0, 0x0, 0xbf666666, 0x3e7a7b1c,
    0x0, 0x0, 0xbf666666, 0x3e777276,
    0x0, 0x0, 0xbf666666, 0x3e746b18,
    0x0, 0x0, 0xbf666666, 0x3e7164fd,
    0x0, 0x0, 0xbf666666, 0x3e6e6020,
    0x0, 0x0, 0xbf666666, 0x3e6b5c7c,
    0x0, 0x0, 0xbf666666, 0x3e685a0e,
    0x0, 0x0, 0xbf666666, 0x3e6558d1,
    0x0, 0x0, 0xbf666666, 0x3e6258c0,
    0x0, 0x0, 0xbf666666, 0x3e5f59d8,
    0x0, 0x0, 0xbf666666, 0x3e5c5c13,
    0x0, 0x0, 0xbf666666, 0x3e595f6d,
    0x0, 0x0, 0xbf666666, 0x3e5663e3,
    0x0, 0x0, 0xbf666666, 0x3e53696f,
    0x0, 0x0, 0xbf666666, 0x3e50700e,
    0x0, 0x0, 0xbf666666, 0x3e4d77bc,
    0x0, 0x0, 0xbf666666, 0x3e4a8073,
    0x0, 0x0, 0xbf666666, 0x3e478a30,
    0x0, 0x0, 0xbf666666, 0x3e4494ef,
    0x0, 0x0, 0xbf666666, 0x3e41a0ac,
    0x0, 0x0, 0xbf666666, 0x3e3ead62,
    0x0, 0x0, 0xbf666666, 0x3e3bbb0d,
    0x0, 0x0, 0xbf666666, 0x3e38c9a9,
    0x0, 0x0, 0xbf666666, 0x3e35d933,
    0x0, 0x0, 0xbf666666, 0x3e32e9a6,
    0x0, 0x0, 0xbf666666, 0x3e2ffafd,
    0x0, 0x0, 0xbf666666, 0x3e2d0d36,
    0x0, 0x0, 0xbf666666, 0x3e2a204c,
    0x0, 0x0, 0xbf666666, 0x3e27343b,
    0x0, 0x0, 0xbf666666, 0x3e2448ff,
    0x0, 0x0, 0xbf666666, 0x3e215e94,
    0x0, 0x0, 0xbf666666, 0x3e1e74f6,
    0x0, 0x0, 0xbf666666, 0x3e1b8c21,
    0x0, 0x0, 0xbf666666, 0x3e18a412,
    0x0, 0x0, 0xbf666666, 0x3e15bcc4,
    0x0, 0x0, 0xbf666666, 0x3e12d634,
    0x0, 0x0, 0xbf666666, 0x3e0ff05e,
    0x0, 0x0, 0xbf666666, 0x3e0d0b3e,
    0x0, 0x0, 0xbf666666, 0x3e0a26cf,
    0x0, 0x0, 0xbf666666, 0x3e07430f,
    0x0, 0x0, 0xbf666666, 0x3e045ffa,
    0x0, 0x0, 0xbf666666, 0x3e017d8b,
    0x0, 0x0, 0xbf666666, 0x3dfd377d,
    0x0, 0x0, 0xbf666666, 0x3df77524,
    0x0, 0x0, 0xbf666666, 0x3df1b401,
    0x0, 0x0, 0xbf666666, 0x3debf40d,
    0x0, 0x0, 0xbf666666, 0x3de63541,
    0x0, 0x0, 0xbf666666, 0x3de07796,
    0x0, 0x0, 0xbf666666, 0x3ddabb04,
    0x0, 0x0, 0xbf666666, 0x3dd4ff83,
    0x0, 0x0, 0xbf666666, 0x3dcf450d,
    0x0, 0x0, 0xbf666666, 0x3dc98b99,
    0x0, 0x0, 0xbf666666, 0x3dc3d322,
    0x0, 0x0, 0xbf666666, 0x3dbe1b9e,
    0x0, 0x0, 0xbf666666, 0x3db86508,
    0x0, 0x0, 0xbf666666, 0x3db2af57,
    0x0, 0x0, 0xbf666666, 0x3dacfa85,
    0x0, 0x0, 0xbf666666, 0x3da7468a,
    0x0, 0x0, 0xbf666666, 0x3da1935f,
    0x0, 0x0, 0xbf666666, 0x3d9be0fd,
    0x0, 0x0, 0xbf666666, 0x3d962f5d,
    0x0, 0x0, 0xbf666666, 0x3d907e77,
    0x0, 0x0, 0xbf666666, 0x3d8ace45,
    0x0, 0x0, 0xbf666666, 0x3d851ebf,
    0x0, 0x0, 0xbf666666, 0x3d7edfbc,
    0x0, 0x0, 0xbf666666, 0x3d738336,
    0x0, 0x0, 0xbf666666, 0x3d6827dd,
    0x0, 0x0, 0xbf666666, 0x3d5ccda4,
    0x0, 0x0, 0xbf666666, 0x3d51747d,
    0x0, 0x0, 0xbf666666, 0x3d461c59,
    0x0, 0x0, 0xbf666666, 0x3d3ac52a,
    0x0, 0x0, 0xbf666666, 0x3d2f6ee1,
    0x0, 0x0, 0xbf666666, 0x3d241972,
    0x0, 0x0, 0xbf666666, 0x3d18c4ce,
    0x0, 0x0, 0xbf666666, 0x3d0d70e6,
    0x0, 0x0, 0xbf666666, 0x3d021dae,
    0x0, 0x0, 0xbf666666, 0x3ced962b,
    0x0, 0x0, 0xbf666666, 0x3cd6f220,
    0x0, 0x0, 0xbf666666, 0x3cc04f1f,
    0x0, 0x0, 0xbf666666, 0x3ca9ad0b,
    0x0, 0x0, 0xbf666666, 0x3c930bc9,
    0x0, 0x0, 0xbf666666, 0x3c78d677,
    0x0, 0x0, 0xbf666666, 0x3c4b9690,
    0x0, 0x0, 0xbf666666, 0x3c1e57a5,
    0x0, 0x0, 0xbf666666, 0x3be232f9,
    0x0, 0x0, 0xbf666666, 0x3b87b7bf,
    0x0, 0x0, 0xbf666666, 0x3ab4f4b4,
    0x0
    };

static const uint32_t ref_rfft_step_2048[2049] = {
    0x44666666, 0x0, 0xbf666666, 0x4412ad55,
    0x0, 0x80000000, 0xbf666666, 0x43439176,
    0x0, 0x0, 0xbf666666, 0x42eaadcd,
    0x0, 0x0, 0xbf666666, 0x42a79fe8,
    0x0, 0x80000000, 0xbf666666, 0x42825f17,
    0x0, 0x0, 0xbf666666, 0x42555412,
    0x0, 0x0, 0xbf666666, 0x42348079,
    0x0, 0x0, 0xbf666666, 0x421c6d96,
    0x0, 0x0, 0xbf666666, 0x420a0491,
    0x0, 0x0, 0xbf666666, 0x41f6f71f,
    0x0, 0x0, 0xbf666666, 0x41df6e48,
    0x0, 0x0, 0xbf666666, 0x41cbfce9,
    0x0, 0x0, 0xbf666666, 0x41bba79f,
    0x0, 0x0, 0xbf666666, 0x41adbd7f,
    0x0, 0x0, 0xbf666666, 0x41a1be72,
    0x0, 0x0, 0xbf666666, 0x41974b69,
    0x0, 0x80000000, 0xbf666666, 0x418e1c65,
    0x0, 0x0, 0xbf666666, 0x4185f9da,
    0x0, 0x0, 0xbf666666, 0x417d707d,
    0x0, 0x0, 0xbf666666, 0x417069ef,
    0x0, 0x0, 0xbf666666, 0x4164a856,
    0x0, 0x0, 0xbf666666, 0x4159fe59,
    0x0, 0x0, 0xbf666666, 0x415046b0,
    0x0, 0x0, 0xbf666666, 0x4147626c,
    0x0, 0x0, 0xbf666666, 0x413f37ab,
    0x0, 0x0, 0xbf666666, 0x4137b099,
    0x0, 0x0, 0xbf666666, 0x4130baae,
    0x0, 0x0, 0xbf666666, 0x412a4615,
    0x0, 0x0, 0xbf666666, 0x41244531,
    0x0, 0x0, 0xbf666666, 0x411eac3d,
    0x0, 0x0, 0xbf666666, 0x41197101,
    0x0, 0x0, 0xbf666666, 0x41148a8f,
    0x0, 0x0, 0xbf666666, 0x410ff113,
    0x0, 0x0, 0xbf666666, 0x410b9dab,
    0x0, 0x0, 0xbf666666, 0x41078a3c,
    0x0, 0x0, 0xbf666666, 0x4103b160,
    0x0, 0x0, 0xbf666666, 0x41000e46,
    0x0, 0x0, 0xbf666666, 0x40f93940,
    0x0, 0x0, 0xbf666666, 0x40f2b12a,
    0x0, 0x0, 0xbf666666, 0x40ec7d5c,
    0x0, 0x0, 0xbf666666, 0x40e69796,
    0x0, 0x0, 0xbf666666, 0x40e0fa35,
    0x0, 0x0, 0xbf666666, 0x40dba01e,
    0x0, 0x0, 0xbf666666, 0x40d684ab,
    0x0, 0x0, 0xbf666666, 0x40d1a3a3,
    0x0, 0x0, 0xbf666666, 0x40ccf92d,
    0x0, 0x0, 0xbf666666, 0x40c881c4,
    0x0, 0x0, 0xbf666666, 0x40c43a2d,
    0x0, 0x0, 0xbf666666, 0x40c01f74,
    0x0, 0x0, 0xbf666666, 0x40bc2ee0,
    0x0, 0x0, 0xbf666666, 0x40b865f0,
    0x0, 0x0, 0xbf666666, 0x40b4c256,
    0x0, 0x0, 0xbf666666, 0x40b141ef,
    0x0, 0x0, 0xbf666666, 0x40ade2c2,
    0x0, 0x0, 0xbf666666, 0x40aaa2fa,
    0x0, 0x0, 0xbf666666, 0x40a780e5,
    0x0, 0x0, 0xbf666666, 0x40a47aef,
    0x0, 0x0, 0xbf666666, 0x40a18fa1,
    0x0, 0x0, 0xbf666666, 0x409ebd9d,
    0x0, 0x0, 0xbf666666, 0x409c039c,
    0x0, 0x0, 0xbf666666, 0x4099606e,
    0x0, 0x0, 0xbf666666, 0x4096d2f5,
    0x0, 0x0, 0xbf666666, 0x40945a26,
    0x0, 0x0, 0xbf666666, 0x4091f508,
    0x0, 0x80000000, 0xbf666666, 0x408fa2b0,
    0x0, 0x0, 0xbf666666, 0x408d6243,
    0x0, 0x0, 0xbf666666, 0x408b32f0,
    0x0, 0x0, 0xbf666666, 0x408913f6,
    0x0, 0x0, 0xbf666666, 0x4087049c,
    0x0, 0x0, 0xbf666666, 0x40850438,
    0x0, 0x0, 0xbf666666, 0x40831224,
    0x0, 0x0, 0xbf666666, 0x40812dc8,
    0x0, 0x0, 0xbf666666, 0x407ead26,
    0x0, 0x0, 0xbf666666, 0x407b17f5,
    0x0, 0x0, 0xbf666666, 0x40779af9,
    0x0, 0x0, 0xbf666666, 0x4074353d,
    0x0, 0x0, 0xbf666666, 0x4070e5d7,
    0x0, 0x0, 0xbf666666, 0x406dabe9,
    0x0, 0x0, 0xbf666666, 0x406a86a1,
    0x0, 0x0, 0xbf666666, 0x40677539,
    0x0, 0x0, 0xbf666666, 0x406476f1,
    0x0, 0x0, 0xbf666666, 0x40618b16,
    0x0, 0x0, 0xbf666666, 0x405eb0fd,
    0x0, 0x0, 0xbf666666, 0x405be801,
    0x0, 0x0, 0xbf666666, 0x40592f88,
    0x0, 0x0, 0xbf666666, 0x405686fd,
    0x0, 0x0, 0xbf666666, 0x4053edd2,
    0x0, 0x0, 0xbf666666, 0x40516380,
    0x0, 0x0, 0xbf666666, 0x404ee787,
    0x0, 0x0, 0xbf666666, 0x404c796b,
    0x0, 0x0, 0xbf666666, 0x404a18b7,
    0x0, 0x0, 0xbf666666, 0x4047c4fa,
    0x0, 0x0, 0xbf666666, 0x40457dc9,
    0x0, 0x0, 0xbf666666, 0x404342bb,
    0x0, 0x0, 0xbf666666, 0x4041136f,
    0x0, 0x0, 0xbf666666, 0x403eef86,
    0x0, 0x0, 0xbf666666, 0x403cd6a6,
    0x0, 0x0, 0xbf666666, 0x403ac876,
    0x0, 0x0, 0xbf666666, 0x4038c4a5,
    0x0, 0x0, 0xbf666666, 0x4036cae1,
    0x0, 0x0, 0xbf666666, 0x4034dade,
    0x0, 0x0, 0xbf666666, 0x4032f452,
    0x0, 0x0, 0xbf666666, 0x403116f6,
    0x0, 0x0, 0xbf666666, 0x402f4286,
    0x0, 0x0, 0xbf666666, 0x402d76c0,
    0x0, 0x0, 0xbf666666, 0x402bb365,
    0x0, 0x0, 0xbf666666, 0x4029f838,
    0x0, 0x0, 0xbf666666, 0x40284500,
    0x0, 0x0, 0xbf666666, 0x40269982,
    0x0, 0x0, 0xbf666666, 0x4024f58a,
    0x0, 0x0, 0xbf666666, 0x402358e2,
    0x0, 0x0, 0xbf666666, 0x4021c359,
    0x0, 0x0, 0xbf666666, 0x402034be,
    0x0, 0x0, 0xbf666666, 0x401eace1,
    0x0, 0x0, 0xbf666666, 0x401d2b96,
    0x0, 0x0, 0xbf666666, 0x401bb0b1,
    0x0, 0x0, 0xbf666666, 0x401a3c07,
    0x0, 0x0, 0xbf666666, 0x4018cd70,
    0x0, 0x0, 0xbf666666, 0x401764c4,
    0x0, 0x0, 0xbf666666, 0x401601dd,
    0x0, 0x0, 0xbf666666, 0x4014a496,
    0x0, 0x0, 0xbf666666, 0x40134ccd,
    0x0, 0x0, 0xbf666666, 0x4011fa5d,
    0x0, 0x0, 0xbf666666, 0x4010ad26,
    0x0, 0x0, 0xbf666666, 0x400f6508,
    0x0, 0x0, 0xbf666666, 0x400e21e4,
    0x0, 0x0, 0xbf666666, 0x400ce39a,
    0x0, 0x0, 0xbf666666, 0x400baa0f,
    0x0, 0x0, 0xbf666666, 0x400a7524,
    0x0, 0x0, 0xbf666666, 0x400944c0,
    0x0, 0x0, 0xbf666666, 0x400818c7,
    0x0, 0x0, 0xbf666666, 0x4006f11f,
    0x0, 0x0, 0xbf666666, 0x4005cdaf,
    0x0, 0x0, 0xbf666666, 0x4004ae5f,
    0x0, 0x0, 0xbf666666, 0x40039318,
    0x0, 0x0, 0xbf666666, 0x40027bc2,
    0x0, 0x0, 0xbf666666, 0x40016847,
    0x0, 0x0, 0xbf666666, 0x40005892,
    0x0, 0x0, 0xbf666666, 0x3ffe9919,
    0x0, 0x0, 0xbf666666, 0x3ffc8848,
    0x0, 0x0, 0xbf666666, 0x3ffa7e87,
    0x0, 0x0, 0xbf666666, 0x3ff87bb1,
    0x0, 0x0, 0xbf666666, 0x3ff67fa0,
    0x0, 0x0, 0xbf666666, 0x3ff48a2f,
    0x0, 0x0, 0xbf666666, 0x3ff29b3b,
    0x0, 0x0, 0xbf666666, 0x3ff0b2a2,
    0x0, 0x0, 0xbf666666, 0x3feed042,
    0x0, 0x0, 0xbf666666, 0x3fecf3fc,
    0x0, 0x0, 0xbf666666, 0x3feb1dae,
    0x0, 0x0, 0xbf666666, 0x3fe94d3b,
    0x0, 0x0, 0xbf666666, 0x3fe78284,
    0x0, 0x0, 0xbf666666, 0x3fe5bd6d,
    0x0, 0x0, 0xbf666666, 0x3fe3fdd8,
    0x0, 0x0, 0xbf666666, 0x3fe243aa,
    0x0, 0x0, 0xbf666666, 0x3fe08ec8,
    0x0, 0x0, 0xbf666666, 0x3fdedf18,
    0x0, 0x0, 0xbf666666, 0x3fdd3480,
    0x0, 0x0, 0xbf666666, 0x3fdb8ee7,
    0x0, 0x0, 0xbf666666, 0x3fd9ee35,
    0x0, 0x0, 0xbf666666, 0x3fd85253,
    0x0, 0x0, 0xbf666666, 0x3fd6bb28,
    0x0, 0x0, 0xbf666666, 0x3fd5289e,
    0x0, 0x0, 0xbf666666, 0x3fd39aa0,
    0x0, 0x0, 0xbf666666, 0x3fd21118,
    0x0, 0x0, 0xbf666666, 0x3fd08bf1,
    0x0, 0x0, 0xbf666666, 0x3fcf0b16,
    0x0, 0x0, 0xbf666666, 0x3fcd8e73,
    0x0, 0x0, 0xbf666666, 0x3fcc15f6,
    0x0, 0x0, 0xbf666666, 0x3fcaa18b,
    0x0, 0x0, 0xbf666666, 0x3fc9311f,
    0x0, 0x0, 0xbf666666, 0x3fc7c4a1,
    0x0, 0x0, 0xbf666666, 0x3fc65bfe,
    0x0, 0x0, 0xbf666666, 0x3fc4f726,
    0x0, 0x0, 0xbf666666, 0x3fc39607,
    0x0, 0x0, 0xbf666666, 0x3fc23890,
    0x0, 0x0, 0xbf666666, 0x3fc0deb3,
    0x0, 0x0, 0xbf666666, 0x3fbf885e,
    0x0, 0x0, 0xbf666666, 0x3fbe3583,
    0x0, 0x0, 0xbf666666, 0x3fbce612,
    0x0, 0x0, 0xbf666666, 0x3fbb99fd,
    0x0, 0x0, 0xbf666666, 0x3fba5135,
    0x0, 0x0, 0xbf666666, 0x3fb90bad,
    0x0, 0x0, 0xbf666666, 0x3fb7c956,
    0x0, 0x0, 0xbf666666, 0x3fb68a22,
    0x0, 0x0, 0xbf666666, 0x3fb54e05,
    0x0, 0x0, 0xbf666666, 0x3fb414f2,
    0x0, 0x0, 0xbf666666, 0x3fb2dedc,
    0x0, 0x0, 0xbf666666, 0x3fb1abb7,
    0x0, 0x0, 0xbf666666, 0x3fb07b76,
    0x0, 0x0, 0xbf666666, 0x3faf4e0e,
    0x0, 0x0, 0xbf666666, 0x3fae2374,
    0x0, 0x0, 0xbf666666, 0x3facfb9b,
    0x0, 0x0, 0xbf666666, 0x3fabd678,
    0x0, 0x0, 0xbf666666, 0x3faab401,
    0x0, 0x0, 0xbf666666, 0x3fa9942c,
    0x0, 0x0, 0xbf666666, 0x3fa876ec,
    0x0, 0x0, 0xbf666666, 0x3fa75c3a,
    0x0, 0x0, 0xbf666666, 0x3fa64409,
    0x0, 0x0, 0xbf666666, 0x3fa52e51,
    0x0, 0x0, 0xbf666666, 0x3fa41b07,
    0x0, 0x0, 0xbf666666, 0x3fa30a23,
    0x0, 0x0, 0xbf666666, 0x3fa1fb9b,
    0x0, 0x0, 0xbf666666, 0x3fa0ef66,
    0x0, 0x0, 0xbf666666, 0x3f9fe57b,
    0x0, 0x0, 0xbf666666, 0x3f9eddd2,
    0x0, 0x0, 0xbf666666, 0x3f9dd861,
    0x0, 0x0, 0xbf666666, 0x3f9cd520,
    0x0, 0x0, 0xbf666666, 0x3f9bd407,
    0x0, 0x0, 0xbf666666, 0x3f9ad50f,
    0x0, 0x0, 0xbf666666, 0x3f99d82f,
    0x0, 0x0, 0xbf666666, 0x3f98dd5e,
    0x0, 0x0, 0xbf666666, 0x3f97e497,
    0x0, 0x0, 0xbf666666, 0x3f96edd1,
    0x0, 0x0, 0xbf666666, 0x3f95f904,
    0x0, 0x0, 0xbf666666, 0x3f95062a,
    0x0, 0x0, 0xbf666666, 0x3f94153c,
    0x0, 0x0, 0xbf666666, 0x3f932632,
    0x0, 0x0, 0xbf666666, 0x3f923906,
    0x0, 0x0, 0xbf666666, 0x3f914db1,
    0x0, 0x0, 0xbf666666, 0x3f90642d,
    0x0, 0x0, 0xbf666666, 0x3f8f7c72,
    0x0, 0x0, 0xbf666666, 0x3f8e967b,
    0x0, 0x0, 0xbf666666, 0x3f8db242,
    0x0, 0x0, 0xbf666666, 0x3f8ccfc0,
    0x0, 0x0, 0xbf666666, 0x3f8beeef,
    0x0, 0x0, 0xbf666666, 0x3f8b0fc9,
    0x0, 0x0, 0xbf666666, 0x3f8a3249,
    0x0, 0x0, 0xbf666666, 0x3f895669,
    0x0, 0x0, 0xbf666666, 0x3f887c24,
    0x0, 0x0, 0xbf666666, 0x3f87a372,
    0x0, 0x0, 0xbf666666, 0x3f86cc51,
    0x0, 0x0, 0xbf666666, 0x3f85f6b9,
    0x0, 0x0, 0xbf666666, 0x3f8522a6,
    0x0, 0x0, 0xbf666666, 0x3f845013,
    0x0, 0x0, 0xbf666666, 0x3f837efa,
    0x0, 0x0, 0xbf666666, 0x3f82af57,
    0x0, 0x0, 0xbf666666, 0x3f81e124,
    0x0, 0x0, 0xbf666666, 0x3f81145e,
    0x0, 0x0, 0xbf666666, 0x3f8048fe,
    0x0, 0x0, 0xbf666666, 0x3f7efe03,
    0x0, 0x0, 0xbf666666, 0x3f7d6cc5,
    0x0, 0x0, 0xbf666666, 0x3f7bde3a,
    0x0, 0x0, 0xbf666666, 0x3f7a5259,
    0x0, 0x0, 0xbf666666, 0x3f78c91a,
    0x0, 0x0, 0xbf666666, 0x3f774273,
    0x0, 0x0, 0xbf666666, 0x3f75be5d,
    0x0, 0x0, 0xbf666666, 0x3f743ccf,
    0x0, 0x0, 0xbf666666, 0x3f72bdc1,
    0x0, 0x0, 0xbf666666, 0x3f71412a,
    0x0, 0x0, 0xbf666666, 0x3f6fc704,
    0x0, 0x0, 0xbf666666, 0x3f6e4f46,
    0x0, 0x0, 0xbf666666, 0x3f6cd9e8,
    0x0, 0x0, 0xbf666666, 0x3f6b66e4,
    0x0, 0x0, 0xbf666666, 0x3f69f631,
    0x0, 0x0, 0xbf666666, 0x3f6887c8,
    0x0, 0x0, 0xbf666666, 0x3f671ba2,
    0x0, 0x80000000, 0xbf666666, 0x3f65b1b9,
    0x0, 0x0, 0xbf666666, 0x3f644a04,
    0x0, 0x0, 0xbf666666, 0x3f62e47e,
    0x0, 0x0, 0xbf666666, 0x3f61811f,
    0x0, 0x0, 0xbf666666, 0x3f601fe0,
    0x0, 0x0, 0xbf666666, 0x3f5ec0bc,
    0x0, 0x0, 0xbf666666, 0x3f5d63ab,
    0x0, 0x0, 0xbf666666, 0x3f5c08a8,
    0x0, 0x0, 0xbf666666, 0x3f5aafac,
    0x0, 0x0, 0xbf666666, 0x3f5958b1,
    0x0, 0x0, 0xbf666666, 0x3f5803b0,
    0x0, 0x0, 0xbf666666, 0x3f56b0a5,
    0x0, 0x0, 0xbf666666, 0x3f555f88,
    0x0, 0x0, 0xbf666666, 0x3f541054,
    0x0, 0x0, 0xbf666666, 0x3f52c303,
    0x0, 0x0, 0xbf666666, 0x3f517790,
    0x0, 0x0, 0xbf666666, 0x3f502df5,
    0x0, 0x0, 0xbf666666, 0x3f4ee62d,
    0x0, 0x0, 0xbf666666, 0x3f4da031,
    0x0, 0x0, 0xbf666666, 0x3f4c5bfe,
    0x0, 0x0, 0xbf666666, 0x3f4b198c,
    0x0, 0x0, 0xbf666666, 0x3f49d8d9,
    0x0, 0x0, 0xbf666666, 0x3f4899dd,
    0x0, 0x0, 0xbf666666, 0x3f475c94,
    0x0, 0x0, 0xbf666666, 0x3f4620fa,
    0x0, 0x0, 0xbf666666, 0x3f44e708,
    0x0, 0x0, 0xbf666666, 0x3f43aebb,
    0x0, 0x0, 0xbf666666, 0x3f42780e,
    0x0, 0x0, 0xbf666666, 0x3f4142fb,
    0x0, 0x0, 0xbf666666, 0x3f400f7f,
    0x0, 0x0, 0xbf666666, 0x3f3edd94,
    0x0, 0x0, 0xbf666666, 0x3f3dad36,
    0x0, 0x0, 0xbf666666, 0x3f3c7e61,
    0x0, 0x0, 0xbf666666, 0x3f3b5110,
    0x0, 0x0, 0xbf666666, 0x3f3a253f,
    0x0, 0x0, 0xbf666666, 0x3f38fae9,
    0x0, 0x0, 0xbf666666, 0x3f37d20b,
    0x0, 0x0, 0xbf666666, 0x3f36aaa0,
    0x0, 0x0, 0xbf666666, 0x3f3584a4,
    0x0, 0x0, 0xbf666666, 0x3f346013,
    0x0, 0x0, 0xbf666666, 0x3f333ce9,
    0x0, 0x0, 0xbf666666, 0x3f321b21,
    0x0, 0x0, 0xbf666666, 0x3f30fab9,
    0x0, 0x0, 0xbf666666, 0x3f2fdbac,
    0x0, 0x0, 0xbf666666, 0x3f2ebdf6,
    0x0, 0x0, 0xbf666666, 0x3f2da194,
    0x0, 0x0, 0xbf666666, 0x3f2c8682,
    0x0, 0x0, 0xbf666666, 0x3f2b6cbc,
    0x0, 0x0, 0xbf666666, 0x3f2a543e,
    0x0, 0x0, 0xbf666666, 0x3f293d06,
    0x0, 0x0, 0xbf666666, 0x3f28270f,
    0x0, 0x0, 0xbf666666, 0x3f271256,
    0x0, 0x0, 0xbf666666, 0x3f25fed7,
    0x0, 0x0, 0xbf666666, 0x3f24ec90,
    0x0, 0x0, 0xbf666666, 0x3f23db7c,
    0x0, 0x0, 0xbf666666, 0x3f22cb98,
    0x0, 0x0, 0xbf666666, 0x3f21bce2,
    0x0, 0x0, 0xbf666666, 0x3f20af56,
    0x0, 0x0, 0xbf666666, 0x3f1fa2f0,
    0x0, 0x0, 0xbf666666, 0x3f1e97ae,
    0x0, 0x0, 0xbf666666, 0x3f1d8d8c,
    0x0, 0x0, 0xbf666666, 0x3f1c8487,
    0x0, 0x0, 0xbf666666, 0x3f1b7c9d,
    0x0, 0x0, 0xbf666666, 0x3f1a75c9,
    0x0, 0x0, 0xbf666666, 0x3f19700a,
    0x0, 0x0, 0xbf666666, 0x3f186b5d,
    0x0, 0x0, 0xbf666666, 0x3f1767bd,
    0x0, 0x0, 0xbf666666, 0x3f166529,
    0x0, 0x0, 0xbf666666, 0x3f15639e,
    0x0, 0x0, 0xbf666666, 0x3f146318,
    0x0, 0x0, 0xbf666666, 0x3f136396,
    0x0, 0x0, 0xbf666666, 0x3f126513,
    0x0, 0x0, 0xbf666666, 0x3f11678e,
    0x0, 0x0, 0xbf666666, 0x3f106b05,
    0x0, 0x0, 0xbf666666, 0x3f0f6f73,
    0x0, 0x0, 0xbf666666, 0x3f0e74d6,
    0x0, 0x0, 0xbf666666, 0x3f0d7b2d,
    0x0, 0x0, 0xbf666666, 0x3f0c8274,
    0x0, 0x0, 0xbf666666, 0x3f0b8aa9,
    0x0, 0x0, 0xbf666666, 0x3f0a93c9,
    0x0, 0x0, 0xbf666666, 0x3f099dd2,
    0x0, 0x0, 0xbf666666, 0x3f08a8c1,
    0x0, 0x0, 0xbf666666, 0x3f07b495,
    0x0, 0x0, 0xbf666666, 0x3f06c149,
    0x0, 0x0, 0xbf666666, 0x3f05cedd,
    0x0, 0x0, 0xbf666666, 0x3f04dd4e,
    0x0, 0x0, 0xbf666666, 0x3f03ec99,
    0x0, 0x0, 0xbf666666, 0x3f02fcbc,
    0x0, 0x0, 0xbf666666, 0x3f020db5,
    0x0, 0x0, 0xbf666666, 0x3f011f82,
    0x0, 0x0, 0xbf666666, 0x3f00321f,
    0x0, 0x0, 0xbf666666, 0x3efe8b19,
    0x0, 0x0, 0xbf666666, 0x3efcb38d,
    0x0, 0x0, 0xbf666666, 0x3efadd96,
    0x0, 0x0, 0xbf666666, 0x3ef90931,
    0x0, 0x0, 0xbf666666, 0x3ef73658,
    0x0, 0x0, 0xbf666666, 0x3ef56509,
    0x0, 0x0, 0xbf666666, 0x3ef3953e,
    0x0, 0x0, 0xbf666666, 0x3ef1c6f3,
    0x0, 0x0, 0xbf666666, 0x3eeffa25,
    0x0, 0x0, 0xbf666666, 0x3eee2ecf,
    0x0, 0x0, 0xbf666666, 0x3eec64ee,
    0x0, 0x0, 0xbf666666, 0x3eea9c7d,
    0x0, 0x0, 0xbf666666, 0x3ee8d578,
    0x0, 0x0, 0xbf666666, 0x3ee70fdc,
    0x0, 0x0, 0xbf666666, 0x3ee54ba5,
    0x0, 0x0, 0xbf666666, 0x3ee388cf,
    0x0, 0x0, 0xbf666666, 0x3ee1c756,
    0x0, 0x0, 0xbf666666, 0x3ee00736,
    0x0, 0x0, 0xbf666666, 0x3ede486c,
    0x0, 0x0, 0xbf666666, 0x3edc8af4,
    0x0, 0x0, 0xbf666666, 0x3edaceca,
    0x0, 0x0, 0xbf666666, 0x3ed913ec,
    0x0, 0x0, 0xbf666666, 0x3ed75a54,
    0x0, 0x0, 0xbf666666, 0x3ed5a200,
    0x0, 0x0, 0xbf666666, 0x3ed3eaed,
    0x0, 0x0, 0xbf666666, 0x3ed23516,
    0x0, 0x0, 0xbf666666, 0x3ed08079,
    0x0, 0x0, 0xbf666666, 0x3ececd11,
    0x0, 0x0, 0xbf666666, 0x3ecd1adc,
    0x0, 0x0, 0xbf666666, 0x3ecb69d6,
    0x0, 0x0, 0xbf666666, 0x3ec9b9fc,
    0x0, 0x0, 0xbf666666, 0x3ec80b4a,
    0x0, 0x0, 0xbf666666, 0x3ec65dbe,
    0x0, 0x0, 0xbf666666, 0x3ec4b154,
    0x0, 0x0, 0xbf666666, 0x3ec30609,
    0x0, 0x0, 0xbf666666, 0x3ec15bd9,
    0x0, 0x0, 0xbf666666, 0x3ebfb2c2,
    0x0, 0x0, 0xbf666666, 0x3ebe0ac0,
    0x0, 0x0, 0xbf666666, 0x3ebc63d1,
    0x0, 0x0, 0xbf666666, 0x3ebabdf1,
    0x0, 0x0, 0xbf666666, 0x3eb9191d,
    0x0, 0x0, 0xbf666666, 0x3eb77553,
    0x0, 0x0, 0xbf666666, 0x3eb5d28f,
    0x0, 0x0, 0xbf666666, 0x3eb430cd,
    0x0, 0x0, 0xbf666666, 0x3eb2900d,
    0x0, 0x0, 0xbf666666, 0x3eb0f049,
    0x0, 0x0, 0xbf666666, 0x3eaf5180,
    0x0, 0x0, 0xbf666666, 0x3eadb3af,
    0x0, 0x0, 0xbf666666, 0x3eac16d2,
    0x0, 0x0, 0xbf666666, 0x3eaa7ae8,
    0x0, 0x0, 0xbf666666, 0x3ea8dfec,
    0x0, 0x0, 0xbf666666, 0x3ea745dd,
    0x0, 0x0, 0xbf666666, 0x3ea5acb7,
    0x0, 0x0, 0xbf666666, 0x3ea41478,
    0x0, 0x0, 0xbf666666, 0x3ea27d1d,
    0x0, 0x0, 0xbf666666, 0x3ea0e6a4,
    0x0, 0x0, 0xbf666666, 0x3e9f5109,
    0x0, 0x0, 0xbf666666, 0x3e9dbc4b,
    0x0, 0x0, 0xbf666666, 0x3e9c2865,
    0x0, 0x0, 0xbf666666, 0x3e9a9557,
    0x0, 0x0, 0xbf666666, 0x3e99031d,
    0x0, 0x0, 0xbf666666, 0x3e9771b4,
    0x0, 0x0, 0xbf666666, 0x3e95e11a,
    0x0, 0x0, 0xbf666666, 0x3e94514d,
    0x0, 0x0, 0xbf666666, 0x3e92c24a,
    0x0, 0x0, 0xbf666666, 0x3e91340e,
    0x0, 0x0, 0xbf666666, 0x3e8fa697,
    0x0, 0x0, 0xbf666666, 0x3e8e19e3,
    0x0, 0x0, 0xbf666666, 0x3e8c8dee,
    0x0, 0x0, 0xbf666666, 0x3e8b02b7,
    0x0, 0x0, 0xbf666666, 0x3e89783b,
    0x0, 0x0, 0xbf666666, 0x3e87ee78,
    0x0, 0x0, 0xbf666666, 0x3e86656b,
    0x0, 0x0, 0xbf666666, 0x3e84dd12,
    0x0, 0x0, 0xbf666666, 0x3e83556b,
    0x0, 0x0, 0xbf666666, 0x3e81ce73,
    0x0, 0x0, 0xbf666666, 0x3e804827,
    0x0, 0x0, 0xbf666666, 0x3e7d850d,
    0x0, 0x0, 0xbf666666, 0x3e7a7b1c,
    0x0, 0x0, 0xbf666666, 0x3e777276,
    0x0, 0x0, 0xbf666666, 0x3e746b18,
    0x0, 0x0, 0xbf666666, 0x3e7164fd,
    0x0, 0x0, 0xbf666666, 0x3e6e6020,
    0x0, 0x0, 0xbf666666, 0x3e6b5c7c,
    0x0, 0x0, 0xbf666666, 0x3e685a0e,
    0x0, 0x0, 0xbf666666, 0x3e6558d1,
    0x0, 0x0, 0xbf666666, 0x3e6258c0,
    0x0, 0x0, 0xbf666666, 0x3e5f59d8,
    0x0, 0x0, 0xbf666666, 0x3e5c5c13,
    0x0, 0x0, 0xbf666666, 0x3e595f6d,
    0x0, 0x0, 0xbf666666, 0x3e5663e3,
    0x0, 0x0, 0xbf666666, 0x3e53696f,
    0x0, 0x0, 0xbf666666, 0x3e50700e,
    0x0, 0x0, 0xbf666666, 0x3e4d77bc,
    0x0, 0x0, 0xbf666666, 0x3e4a8073,
    0x0, 0x0, 0xbf666666, 0x3e478a30,
    0x0, 0x0, 0xbf666666, 0x3e4494ef,
    0x0, 0x0, 0xbf666666, 0x3e41a0ac,
    0x0, 0x0, 0xbf666666, 0x3e3ead62,
    0x0, 0x0, 0xbf666666, 0x3e3bbb0d,
    0x0, 0x0, 0xbf666666, 0x3e38c9a9,
    0x0, 0x0, 0xbf666666, 0x3e35d933,
    0x0, 0x0, 0xbf666666, 0x3e32e9a6,
    0x0, 0x0, 0xbf666666, 0x3e2ffafd,
    0x0, 0x0, 0xbf666666, 0x3e2d0d36,
    0x0, 0x0, 0xbf666666, 0x3e2a204c,
    0x0, 0x0, 0xbf666666, 0x3e27343b,
    0x0, 0x0, 0xbf666666, 0x3e2448ff,
    0x0, 0x0, 0xbf666666, 0x3e215e94,
    0x0, 0x0, 0xbf666666, 0x3e1e74f6,
    0x0, 0x0, 0xbf666666, 0x3e1b8c21,
    0x0, 0x0, 0xbf666666, 0x3e18a412,
    0x0, 0x0, 0xbf666666, 0x3e15bcc4,
    0x0, 0x0, 0xbf666666, 0x3e12d634,
    0x0, 0x0, 0xbf666666, 0x3e0ff05e,
    0x0, 0x0, 0xbf666666, 0x3e0d0b3e,
    0x0, 0x0, 0xbf666666, 0x3e0a26cf,
    0x0, 0x0, 0xbf666666, 0x3e07430f,
    0x0, 0x0, 0xbf666666, 0x3e045ffa,
    0x0, 0x0, 0xbf666666, 0x3e017d8b,
    0x0, 0x0, 0xbf666666, 0x3dfd377d,
    0x0, 0x0, 0xbf666666, 0x3df77524,
    0x0, 0x0, 0xbf666666, 0x3df1b401,
    0x0, 0x0, 0xbf666666, 0x3debf40d,
    0x0, 0x0, 0xbf666666, 0x3de63541,
    0x0, 0x0, 0xbf666666, 0x3de07796,
    0x0, 0x0, 0xbf666666, 0x3ddabb04,
    0x0, 0x0, 0xbf666666, 0x3dd4ff83,
    0x0, 0x0, 0xbf666666, 0x3dcf450d,
    0x0, 0x0, 0xbf666666, 0x3dc98b99,
    0x0, 0x0, 0xbf666666, 0x3dc3d322,
    0x0, 0x0, 0xbf666666, 0x3dbe1b9e,
    0x0, 0x0, 0xbf666666, 0x3db86508,
    0x0, 0x0, 0xbf666666, 0x3db2af57,
    0x0, 0x0, 0xbf666666, 0x3dacfa85,
    0x0, 0x0, 0xbf666666, 0x3da7468a,
    0x0, 0x0, 0xbf666666, 0x3da1935f,
    0x0, 0x0, 0xbf666666, 0x3d9be0fd,
    0x0, 0x0, 0xbf666666, 0x3d962f5d,
    0x0, 0x0, 0xbf666666, 0x3d907e77,
    0x0, 0x0, 0xbf666666, 0x3d8ace45,
    0x0, 0x0, 0xbf666666, 0x3d851ebf,
    0x0, 0x0, 0xbf666666, 0x3d7edfbc,
    0x0, 0x0, 0xbf666666, 0x3d738336,
    0x0, 0x0, 0xbf666666, 0x3d6827dd,
    0x0, 0x0, 0xbf666666, 0x3d5ccda4,
    0x0, 0x0, 0xbf666666, 0x3d51747d,
    0x0, 0x0, 0xbf666666, 0x3d461c59,
    0x0, 0x0, 0xbf666666, 0x3d3ac52a,
    0x0, 0x0, 0xbf666666, 0x3d2f6ee1,
    0x0, 0x0, 0xbf666666, 0x3d241972,
    0x0, 0x0, 0xbf666666, 0x3d18c4ce,
    0x0, 0x0, 0xbf666666, 0x3d0d70e6,
    0x0, 0x0, 0xbf666666, 0x3d021dae,
    0x0, 0x0, 0xbf666666, 0x3ced962b,
    0x0, 0x0, 0xbf666666, 0x3cd6f220,
    0x0, 0x0, 0xbf666666, 0x3cc04f1f,
    0x0, 0x0, 0xbf666666, 0x3ca9ad0b,
    0x0, 0x0, 0xbf666666, 0x3c930bc9,
    0x0, 0x0, 0xbf666666, 0x3c78d677,
    0x0, 0x0, 0xbf666666, 0x3c4b9690,
    0x0, 0x0, 0xbf666666, 0x3c1e57a5,
    0x0, 0x0, 0xbf666666, 0x3be232f9,
    0x0, 0x0, 0xbf666666, 0x3b87b7bf,
    0x0, 0x0, 0xbf666666, 0x3ab4f4b4,
    0x0
    };

static const uint32_t in_rfft_step_4096[4096] = {
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666,
    0x3f666666, 0x3f666666, 0x3f666666, 0x3f666666
    };

static const uint32_t in_rifft_step_4096[4097] = {
    0x44e66666, 0x0, 0xbf666666, 0x4492ad5b,
    0x0, 0x80000000, 0xbf666666, 0x43c391ba,
    0x0, 0x0, 0xbf666666, 0x436aaeaf,
    0x0, 0x0, 0xbf666666, 0x4327a125,
    0x0, 0x80000000, 0xbf666666, 0x430260ae,
    0x0, 0x0, 0xbf666666, 0x42d557f5,
    0x0, 0x0, 0xbf666666, 0x42b48511,
    0x0, 0x0, 0xbf666666, 0x429c72e3,
    0x0, 0x0, 0xbf666666, 0x428a0a93,
    0x0, 0x0, 0xbf666666, 0x4277048e,
    0x0, 0x0, 0xbf666666, 0x425f7d21,
    0x0, 0x0, 0xbf666666, 0x424c0d2c,
    0x0, 0x0, 0xbf666666, 0x423bb94b,
    0x0, 0x0, 0xbf666666, 0x422dd096,
    0x0, 0x0, 0xbf666666, 0x4221d2f2,
    0x0, 0x0, 0xbf666666, 0x42176154,
    0x0, 0x80000000, 0xbf666666, 0x420e33ba,
    0x0, 0x0, 0xbf666666, 0x42061299,
    0x0, 0x0, 0xbf666666, 0x41fda4d0,
    0x0, 0x0, 0xbf666666, 0x41f0a116,
    0x0, 0x0, 0xbf666666, 0x41e4e251,
    0x0, 0x0, 0xbf666666, 0x41da3b28,
    0x0, 0x0, 0xbf666666, 0x41d08654,
    0x0, 0x0, 0xbf666666, 0x41c7a4e5,
    0x0, 0x0, 0xbf666666, 0x41bf7cf9,
    0x0, 0x0, 0xbf666666, 0x41b7f8bc,
    0x0, 0x0, 0xbf666666, 0x41b105a6,
    0x0, 0x0, 0xbf666666, 0x41aa93e2,
    0x0, 0x0, 0xbf666666, 0x41a495d3,
    0x0, 0x0, 0xbf666666, 0x419effb4,
    0x0, 0x0, 0xbf666666, 0x4199c74d,
    0x0, 0x0, 0xbf666666, 0x4194e3b1,
    0x0, 0x0, 0xbf666666, 0x41904d0b,
    0x0, 0x0, 0xbf666666, 0x418bfc78,
    0x0, 0x0, 0xbf666666, 0x4187ebdf,
    0x0, 0x0, 0xbf666666, 0x418415d9,
    0x0, 0x0, 0xbf666666, 0x41807595,
    0x0, 0x0, 0xbf666666, 0x417a0d8b,
    0x0, 0x0, 0xbf666666, 0x41738b22,
    0x0, 0x0, 0xbf666666, 0x416d5d00,
    0x0, 0x0, 0xbf666666, 0x41677ce7,
    0x0, 0x0, 0xbf666666, 0x4161e534,
    0x0, 0x0, 0xbf666666, 0x415c90ca,
    0x0, 0x0, 0xbf666666, 0x41577b05,
    0x0, 0x0, 0xbf666666, 0x41529fac,
    0x0, 0x0, 0xbf666666, 0x414dfae4,
    0x0, 0x0, 0xbf666666, 0x4149892a,
    0x0, 0x0, 0xbf666666, 0x41454742,
    0x0, 0x0, 0xbf666666, 0x41413238,
    0x0, 0x0, 0xbf666666, 0x413d4754,
    0x0, 0x0, 0xbf666666, 0x41398415,
    0x0, 0x0, 0xbf666666, 0x4135e62b,
    0x0, 0x0, 0xbf666666, 0x41326b75,
    0x0, 0x0, 0xbf666666, 0x412f11f9,
    0x0, 0x0, 0xbf666666, 0x412bd7e3,
    0x0, 0x0, 0xbf666666, 0x4128bb80,
    0x0, 0x0, 0xbf666666, 0x4125bb3d,
    0x0, 0x0, 0xbf666666, 0x4122d5a2,
    0x0, 0x0, 0xbf666666, 0x41200951,
    0x0, 0x0, 0xbf666666, 0x411d5503,
    0x0, 0x0, 0xbf666666, 0x411ab789,
    0x0, 0x0, 0xbf666666, 0x41182fc4,
    0x0, 0x0, 0xbf666666, 0x4115bcaa,
    0x0, 0x0, 0xbf666666, 0x41135d42,
    0x0, 0x80000000, 0xbf666666, 0x4111109f,
    0x0, 0x0, 0xbf666666, 0x410ed5e8,
    0x0, 0x0, 0xbf666666, 0x410cac4c,
    0x0, 0x0, 0xbf666666, 0x410a9308,
    0x0, 0x0, 0xbf666666, 0x41088967,
    0x0, 0x0, 0xbf666666, 0x41068eba,
    0x0, 0x0, 0xbf666666, 0x4104a25f,
    0x0, 0x0, 0xbf666666, 0x4102c3bc,
    0x0, 0x0, 0xbf666666, 0x4100f240,
    0x0, 0x0, 0xbf666666, 0x40fe5ac3,
    0x0, 0x0, 0xbf666666, 0x40fae93d,
    0x0, 0x0, 0xbf666666, 0x40f78ef6,
    0x0, 0x0, 0xbf666666, 0x40f44b07,
    0x0, 0x0, 0xbf666666, 0x40f11c91,
    0x0, 0x0, 0xbf666666, 0x40ee02c3,
    0x0, 0x0, 0xbf666666, 0x40eafcd4,
    0x0, 0x0, 0xbf666666, 0x40e80a08,
    0x0, 0x0, 0xbf666666, 0x40e529aa,
    0x0, 0x0, 0xbf666666, 0x40e25b0e,
    0x0, 0x0, 0xbf666666, 0x40df9d91,
    0x0, 0x0, 0xbf666666, 0x40dcf098,
    0x0, 0x0, 0xbf666666, 0x40da538d,
    0x0, 0x0, 0xbf666666, 0x40d7c5e5,
    0x0, 0x0, 0xbf666666, 0x40d54717,
    0x0, 0x0, 0xbf666666, 0x40d2d6a2,
    0x0, 0x0, 0xbf666666, 0x40d0740d,
    0x0, 0x0, 0xbf666666, 0x40ce1ee0,
    0x0, 0x0, 0xbf666666, 0x40cbd6ab,
    0x0, 0x0, 0xbf666666, 0x40c99b03,
    0x0, 0x0, 0xbf666666, 0x40c76b81,
    0x0, 0x0, 0xbf666666, 0x40c547c1,
    0x0, 0x0, 0xbf666666, 0x40c32f66,
    0x0, 0x0, 0xbf666666, 0x40c12214,
    0x0, 0x0, 0xbf666666, 0x40bf1f75,
    0x0, 0x0, 0xbf666666, 0x40bd2735,
    0x0, 0x0, 0xbf666666, 0x40bb3904,
    0x0, 0x0, 0xbf666666, 0x40b95496,
    0x0, 0x0, 0xbf666666, 0x40b779a0,
    0x0, 0x0, 0xbf666666, 0x40b5a7db,
    0x0, 0x0, 0xbf666666, 0x40b3df04,
    0x0, 0x0, 0xbf666666, 0x40b21ed8,
    0x0, 0x0, 0xbf666666, 0x40b06719,
    0x0, 0x0, 0xbf666666, 0x40aeb78a,
    0x0, 0x0, 0xbf666666, 0x40ad0ff0,
    0x0, 0x0, 0xbf666666, 0x40ab7012,
    0x0, 0x0, 0xbf666666, 0x40a9d7bc,
    0x0, 0x0, 0xbf666666, 0x40a846b8,
    0x0, 0x0, 0xbf666666, 0x40a6bcd4,
    0x0, 0x0, 0xbf666666, 0x40a539df,
    0x0, 0x0, 0xbf666666, 0x40a3bdaa,
    0x0, 0x0, 0xbf666666, 0x40a24809,
    0x0, 0x0, 0xbf666666, 0x40a0d8cf,
    0x0, 0x0, 0xbf666666, 0x409f6fd2,
    0x0, 0x0, 0xbf666666, 0x409e0ce9,
    0x0, 0x0, 0xbf666666, 0x409cafed,
    0x0, 0x0, 0xbf666666, 0x409b58b8,
    0x0, 0x0, 0xbf666666, 0x409a0726,
    0x0, 0x0, 0xbf666666, 0x4098bb11,
    0x0, 0x0, 0xbf666666, 0x40977459,
    0x0, 0x0, 0xbf666666, 0x409632db,
    0x0, 0x0, 0xbf666666, 0x4094f678,
    0x0, 0x0, 0xbf666666, 0x4093bf0f,
    0x0, 0x0, 0xbf666666, 0x40928c84,
    0x0, 0x0, 0xbf666666, 0x40915eb8,
    0x0, 0x0, 0xbf666666, 0x40903590,
    0x0, 0x0, 0xbf666666, 0x408f10ef,
    0x0, 0x0, 0xbf666666, 0x408df0bc,
    0x0, 0x0, 0xbf666666, 0x408cd4db,
    0x0, 0x0, 0xbf666666, 0x408bbd35,
    0x0, 0x0, 0xbf666666, 0x408aa9b0,
    0x0, 0x0, 0xbf666666, 0x40899a36,
    0x0, 0x0, 0xbf666666, 0x40888eaf,
    0x0, 0x0, 0xbf666666, 0x40878705,
    0x0, 0x0, 0xbf666666, 0x40868323,
    0x0, 0x0, 0xbf666666, 0x408582f3,
    0x0, 0x0, 0xbf666666, 0x40848661,
    0x0, 0x0, 0xbf666666, 0x40838d5a,
    0x0, 0x0, 0xbf666666, 0x408297ca,
    0x0, 0x0, 0xbf666666, 0x4081a59e,
    0x0, 0x0, 0xbf666666, 0x4080b6c5,
    0x0, 0x0, 0xbf666666, 0x407f9659,
    0x0, 0x0, 0xbf666666, 0x407dc587,
    0x0, 0x0, 0xbf666666, 0x407bfaf2,
    0x0, 0x0, 0xbf666666, 0x407a367b,
    0x0, 0x0, 0xbf666666, 0x40787801,
    0x0, 0x0, 0xbf666666, 0x4076bf66,
    0x0, 0x0, 0xbf666666, 0x40750c8b,
    0x0, 0x0, 0xbf666666, 0x40735f54,
    0x0, 0x0, 0xbf666666, 0x4071b7a5,
    0x0, 0x0, 0xbf666666, 0x40701560,
    0x0, 0x0, 0xbf666666, 0x406e786d,
    0x0, 0x0, 0xbf666666, 0x406ce0af,
    0x0, 0x0, 0xbf666666, 0x406b4e0f,
    0x0, 0x0, 0xbf666666, 0x4069c072,
    0x0, 0x0, 0xbf666666, 0x406837c0,
    0x0, 0x0, 0xbf666666, 0x4066b3e3,
    0x0, 0x0, 0xbf666666, 0x406534c2,
    0x0, 0x0, 0xbf666666, 0x4063ba47,
    0x0, 0x0, 0xbf666666, 0x4062445c,
    0x0, 0x0, 0xbf666666, 0x4060d2ec,
    0x0, 0x0, 0xbf666666, 0x405f65e2,
    0x0, 0x0, 0xbf666666, 0x405dfd29,
    0x0, 0x0, 0xbf666666, 0x405c98ae,
    0x0, 0x0, 0xbf666666, 0x405b385d,
    0x0, 0x0, 0xbf666666, 0x4059dc22,
    0x0, 0x0, 0xbf666666, 0x405883ec,
    0x0, 0x0, 0xbf666666, 0x40572fa9,
    0x0, 0x0, 0xbf666666, 0x4055df46,
    0x0, 0x0, 0xbf666666, 0x405492b3,
    0x0, 0x0, 0xbf666666, 0x405349de,
    0x0, 0x0, 0xbf666666, 0x405204b7,
    0x0, 0x0, 0xbf666666, 0x4050c32f,
    0x0, 0x0, 0xbf666666, 0x404f8534,
    0x0, 0x0, 0xbf666666, 0x404e4ab8,
    0x0, 0x0, 0xbf666666, 0x404d13ac,
    0x0, 0x0, 0xbf666666, 0x404be001,
    0x0, 0x0, 0xbf666666, 0x404aafa9,
    0x0, 0x0, 0xbf666666, 0x40498295,
    0x0, 0x0, 0xbf666666, 0x404858b8,
    0x0, 0x0, 0xbf666666, 0x40473205,
    0x0, 0x0, 0xbf666666, 0x40460e6e,
    0x0, 0x0, 0xbf666666, 0x4044ede6,
    0x0, 0x0, 0xbf666666, 0x4043d061,
    0x0, 0x0, 0xbf666666, 0x4042b5d2,
    0x0, 0x0, 0xbf666666, 0x40419e2e,
    0x0, 0x0, 0xbf666666, 0x40408968,
    0x0, 0x0, 0xbf666666, 0x403f7774,
    0x0, 0x0, 0xbf666666, 0x403e6849,
    0x0, 0x0, 0xbf666666, 0x403d5bda,
    0x0, 0x0, 0xbf666666, 0x403c521d,
    0x0, 0x0, 0xbf666666, 0x403b4b06,
    0x0, 0x0, 0xbf666666, 0x403a468c,
    0x0, 0x0, 0xbf666666, 0x403944a5,
    0x0, 0x0, 0xbf666666, 0x40384545,
    0x0, 0x0, 0xbf666666, 0x40374865,
    0x0, 0x0, 0xbf666666, 0x40364df9,
    0x0, 0x0, 0xbf666666, 0x403555f8,
    0x0, 0x0, 0xbf666666, 0x4034605a,
    0x0, 0x0, 0xbf666666, 0x40336d15,
    0x0, 0x0, 0xbf666666, 0x40327c21,
    0x0, 0x0, 0xbf666666, 0x40318d74,
    0x0, 0x0, 0xbf666666, 0x4030a106,
    0x0, 0x0, 0xbf666666, 0x402fb6cf,
    0x0, 0x0, 0xbf666666, 0x402ecec7,
    0x0, 0x0, 0xbf666666, 0x402de8e5,
    0x0, 0x0, 0xbf666666, 0x402d0521,
    0x0, 0x0, 0xbf666666, 0x402c2375,
    0x0, 0x0, 0xbf666666, 0x402b43d8,
    0x0, 0x0, 0xbf666666, 0x402a6642,
    0x0, 0x0, 0xbf666666, 0x40298aae,
    0x0, 0x0, 0xbf666666, 0x4028b112,
    0x0, 0x0, 0xbf666666, 0x4027d969,
    0x0, 0x0, 0xbf666666, 0x402703ab,
    0x0, 0x0, 0xbf666666, 0x40262fd2,
    0x0, 0x0, 0xbf666666, 0x40255dd6,
    0x0, 0x0, 0xbf666666, 0x40248db2,
    0x0, 0x0, 0xbf666666, 0x4023bf60,
    0x0, 0x0, 0xbf666666, 0x4022f2d7,
    0x0, 0x0, 0xbf666666, 0x40222813,
    0x0, 0x0, 0xbf666666, 0x40215f0e,
    0x0, 0x0, 0xbf666666, 0x402097c1,
    0x0, 0x0, 0xbf666666, 0x401fd227,
    0x0, 0x0, 0xbf666666, 0x401f0e39,
    0x0, 0x0, 0xbf666666, 0x401e4bf3,
    0x0, 0x0, 0xbf666666, 0x401d8b4e,
    0x0, 0x0, 0xbf666666, 0x401ccc45,
    0x0, 0x0, 0xbf666666, 0x401c0ed3,
    0x0, 0x0, 0xbf666666, 0x401b52f2,
    0x0, 0x0, 0xbf666666, 0x401a989e,
    0x0, 0x0, 0xbf666666, 0x4019dfd1,
    0x0, 0x0, 0xbf666666, 0x40192886,
    0x0, 0x0, 0xbf666666, 0x401872b8,
    0x0, 0x0, 0xbf666666, 0x4017be63,
    0x0, 0x0, 0xbf666666, 0x40170b81,
    0x0, 0x0, 0xbf666666, 0x40165a0e,
    0x0, 0x0, 0xbf666666, 0x4015aa06,
    0x0, 0x0, 0xbf666666, 0x4014fb63,
    0x0, 0x0, 0xbf666666, 0x40144e22,
    0x0, 0x0, 0xbf666666, 0x4013a23d,
    0x0, 0x0, 0xbf666666, 0x4012f7b2,
    0x0, 0x0, 0xbf666666, 0x40124e7a,
    0x0, 0x0, 0xbf666666, 0x4011a693,
    0x0, 0x0, 0xbf666666, 0x4010fff9,
    0x0, 0x0, 0xbf666666, 0x40105aa6,
    0x0, 0x0, 0xbf666666, 0x400fb697,
    0x0, 0x0, 0xbf666666, 0x400f13c9,
    0x0, 0x0, 0xbf666666, 0x400e7237,
    0x0, 0x0, 0xbf666666, 0x400dd1de,
    0x0, 0x0, 0xbf666666, 0x400d32ba,
    0x0, 0x0, 0xbf666666, 0x400c94c7,
    0x0, 0x0, 0xbf666666, 0x400bf801,
    0x0, 0x0, 0xbf666666, 0x400b5c66,
    0x0, 0x80000000, 0xbf666666, 0x400ac1f1,
    0x0, 0x0, 0xbf666666, 0x400a28a0,
    0x0, 0x0, 0xbf666666, 0x4009906e,
    0x0, 0x0, 0xbf666666, 0x4008f959,
    0x0, 0x0, 0xbf666666, 0x4008635c,
    0x0, 0x0, 0xbf666666, 0x4007ce76,
    0x0, 0x0, 0xbf666666, 0x40073aa3,
    0x0, 0x0, 0xbf666666, 0x4006a7df,
    0x0, 0x0, 0xbf666666, 0x40061627,
    0x0, 0x0, 0xbf666666, 0x40058579,
    0x0, 0x0, 0xbf666666, 0x4004f5d2,
    0x0, 0x0, 0xbf666666, 0x4004672e,
    0x0, 0x0, 0xbf666666, 0x4003d98a,
    0x0, 0x0, 0xbf666666, 0x40034ce5,
    0x0, 0x0, 0xbf666666, 0x4002c13a,
    0x0, 0x0, 0xbf666666, 0x40023687,
    0x0, 0x0, 0xbf666666, 0x4001acca,
    0x0, 0x0, 0xbf666666, 0x40012400,
    0x0, 0x0, 0xbf666666, 0x40009c26,
    0x0, 0x0, 0xbf666666, 0x40001539,
    0x0, 0x0, 0xbf666666, 0x3fff1e6d,
    0x0, 0x0, 0xbf666666, 0x3ffe1439,
    0x0, 0x0, 0xbf666666, 0x3ffd0bd1,
    0x0, 0x0, 0xbf666666, 0x3ffc0530,
    0x0, 0x0, 0xbf666666, 0x3ffb0050,
    0x0, 0x0, 0xbf666666, 0x3ff9fd2d,
    0x0, 0x0, 0xbf666666, 0x3ff8fbc3,
    0x0, 0x0, 0xbf666666, 0x3ff7fc0c,
    0x0, 0x0, 0xbf666666, 0x3ff6fe03,
    0x0, 0x0, 0xbf666666, 0x3ff601a6,
    0x0, 0x0, 0xbf666666, 0x3ff506ee,
    0x0, 0x0, 0xbf666666, 0x3ff40dd7,
    0x0, 0x0, 0xbf666666, 0x3ff3165e,
    0x0, 0x0, 0xbf666666, 0x3ff2207d,
    0x0, 0x0, 0xbf666666, 0x3ff12c32,
    0x0, 0x0, 0xbf666666, 0x3ff03976,
    0x0, 0x0, 0xbf666666, 0x3fef4847,
    0x0, 0x0, 0xbf666666, 0x3fee58a0,
    0x0, 0x0, 0xbf666666, 0x3fed6a7d,
    0x0, 0x0, 0xbf666666, 0x3fec7dda,
    0x0, 0x0, 0xbf666666, 0x3feb92b4,
    0x0, 0x0, 0xbf666666, 0x3feaa906,
    0x0, 0x0, 0xbf666666, 0x3fe9c0cd,
    0x0, 0x0, 0xbf666666, 0x3fe8da05,
    0x0, 0x0, 0xbf666666, 0x3fe7f4aa,
    0x0, 0x0, 0xbf666666, 0x3fe710b9,
    0x0, 0x0, 0xbf666666, 0x3fe62e2d,
    0x0, 0x0, 0xbf666666, 0x3fe54d04,
    0x0, 0x0, 0xbf666666, 0x3fe46d3a,
    0x0, 0x0, 0xbf666666, 0x3fe38ecc,
    0x0, 0x0, 0xbf666666, 0x3fe2b1b5,
    0x0, 0x0, 0xbf666666, 0x3fe1d5f3,
    0x0, 0x0, 0xbf666666, 0x3fe0fb83,
    0x0, 0x0, 0xbf666666, 0x3fe02260,
    0x0, 0x0, 0xbf666666, 0x3fdf4a89,
    0x0, 0x0, 0xbf666666, 0x3fde73f9,
    0x0, 0x0, 0xbf666666, 0x3fdd9ead,
    0x0, 0x0, 0xbf666666, 0x3fdccaa3,
    0x0, 0x0, 0xbf666666, 0x3fdbf7d7,
    0x0, 0x0, 0xbf666666, 0x3fdb2646,
    0x0, 0x0, 0xbf666666, 0x3fda55ee,
    0x0, 0x0, 0xbf666666, 0x3fd986ca,
    0x0, 0x0, 0xbf666666, 0x3fd8b8d9,
    0x0, 0x0, 0xbf666666, 0x3fd7ec17,
    0x0, 0x0, 0xbf666666, 0x3fd72082,
    0x0, 0x0, 0xbf666666, 0x3fd65617,
    0x0, 0x0, 0xbf666666, 0x3fd58cd3,
    0x0, 0x0, 0xbf666666, 0x3fd4c4b2,
    0x0, 0x0, 0xbf666666, 0x3fd3fdb4,
    0x0, 0x0, 0xbf666666, 0x3fd337d4,
    0x0, 0x0, 0xbf666666, 0x3fd27310,
    0x0, 0x0, 0xbf666666, 0x3fd1af66,
    0x0, 0x0, 0xbf666666, 0x3fd0ecd2,
    0x0, 0x0, 0xbf666666, 0x3fd02b53,
    0x0, 0x0, 0xbf666666, 0x3fcf6ae6,
    0x0, 0x0, 0xbf666666, 0x3fceab89,
    0x0, 0x0, 0xbf666666, 0x3fcded38,
    0x0, 0x0, 0xbf666666, 0x3fcd2ff1,
    0x0, 0x0, 0xbf666666, 0x3fcc73b3,
    0x0, 0x0, 0xbf666666, 0x3fcbb87b,
    0x0, 0x0, 0xbf666666, 0x3fcafe45,
    0x0, 0x0, 0xbf666666, 0x3fca4511,
    0x0, 0x0, 0xbf666666, 0x3fc98cdb,
    0x0, 0x0, 0xbf666666, 0x3fc8d5a2,
    0x0, 0x0, 0xbf666666, 0x3fc81f63,
    0x0, 0x0, 0xbf666666, 0x3fc76a1c,
    0x0, 0x0, 0xbf666666, 0x3fc6b5cb,
    0x0, 0x0, 0xbf666666, 0x3fc6026e,
    0x0, 0x0, 0xbf666666, 0x3fc55002,
    0x0, 0x0, 0xbf666666, 0x3fc49e85,
    0x0, 0x0, 0xbf666666, 0x3fc3edf6,
    0x0, 0x0, 0xbf666666, 0x3fc33e52,
    0x0, 0x0, 0xbf666666, 0x3fc28f97,
    0x0, 0x0, 0xbf666666, 0x3fc1e1c3,
    0x0, 0x0, 0xbf666666, 0x3fc134d5,
    0x0, 0x0, 0xbf666666, 0x3fc088c9,
    0x0, 0x0, 0xbf666666, 0x3fbfdd9f,
    0x0, 0x0, 0xbf666666, 0x3fbf3354,
    0x0, 0x0, 0xbf666666, 0x3fbe89e7,
    0x0, 0x0, 0xbf666666, 0x3fbde155,
    0x0, 0x0, 0xbf666666, 0x3fbd399d,
    0x0, 0x0, 0xbf666666, 0x3fbc92bd,
    0x0, 0x0, 0xbf666666, 0x3fbbecb3,
    0x0, 0x0, 0xbf666666, 0x3fbb477d,
    0x0, 0x0, 0xbf666666, 0x3fbaa319,
    0x0, 0x0, 0xbf666666, 0x3fb9ff86,
    0x0, 0x0, 0xbf666666, 0x3fb95cc2,
    0x0, 0x0, 0xbf666666, 0x3fb8bacb,
    0x0, 0x0, 0xbf666666, 0x3fb8199f,
    0x0, 0x0, 0xbf666666, 0x3fb7793e,
    0x0, 0x0, 0xbf666666, 0x3fb6d9a4,
    0x0, 0x0, 0xbf666666, 0x3fb63ad1,
    0x0, 0x0, 0xbf666666, 0x3fb59cc3,
    0x0, 0x0, 0xbf666666, 0x3fb4ff78,
    0x0, 0x0, 0xbf666666, 0x3fb462ef,
    0x0, 0x0, 0xbf666666, 0x3fb3c726,
    0x0, 0x0, 0xbf666666, 0x3fb32c1b,
    0x0, 0x0, 0xbf666666, 0x3fb291cd,
    0x0, 0x0, 0xbf666666, 0x3fb1f83a,
    0x0, 0x0, 0xbf666666, 0x3fb15f62,
    0x0, 0x0, 0xbf666666, 0x3fb0c742,
    0x0, 0x0, 0xbf666666, 0x3fb02fd9,
    0x0, 0x0, 0xbf666666, 0x3faf9925,
    0x0, 0x0, 0xbf666666, 0x3faf0325,
    0x0, 0x0, 0xbf666666, 0x3fae6dd8,
    0x0, 0x0, 0xbf666666, 0x3fadd93c,
    0x0, 0x0, 0xbf666666, 0x3fad454f,
    0x0, 0x0, 0xbf666666, 0x3facb211,
    0x0, 0x0, 0xbf666666, 0x3fac1f80,
    0x0, 0x0, 0xbf666666, 0x3fab8d9b,
    0x0, 0x0, 0xbf666666, 0x3faafc60,
    0x0, 0x0, 0xbf666666, 0x3faa6bcd,
    0x0, 0x0, 0xbf666666, 0x3fa9dbe3,
    0x0, 0x0, 0xbf666666, 0x3fa94c9e,
    0x0, 0x0, 0xbf666666, 0x3fa8bdff,
    0x0, 0x0, 0xbf666666, 0x3fa83003,
    0x0, 0x0, 0xbf666666, 0x3fa7a2aa,
    0x0, 0x0, 0xbf666666, 0x3fa715f2,
    0x0, 0x0, 0xbf666666, 0x3fa689da,
    0x0, 0x0, 0xbf666666, 0x3fa5fe60,
    0x0, 0x0, 0xbf666666, 0x3fa57384,
    0x0, 0x0, 0xbf666666, 0x3fa4e945,
    0x0, 0x0, 0xbf666666, 0x3fa45fa0,
    0x0, 0x0, 0xbf666666, 0x3fa3d695,
    0x0, 0x0, 0xbf666666, 0x3fa34e23,
    0x0, 0x0, 0xbf666666, 0x3fa2c649,
    0x0, 0x0, 0xbf666666, 0x3fa23f05,
    0x0, 0x0, 0xbf666666, 0x3fa1b857,
    0x0, 0x0, 0xbf666666, 0x3fa1323c,
    0x0, 0x0, 0xbf666666, 0x3fa0acb5,
    0x0, 0x0, 0xbf666666, 0x3fa027c0,
    0x0, 0x0, 0xbf666666, 0x3f9fa35b,
    0x0, 0x0, 0xbf666666, 0x3f9f1f86,
    0x0, 0x0, 0xbf666666, 0x3f9e9c40,
    0x0, 0x0, 0xbf666666, 0x3f9e1988,
    0x0, 0x0, 0xbf666666, 0x3f9d975c,
    0x0, 0x0, 0xbf666666, 0x3f9d15bc,
    0x0, 0x0, 0xbf666666, 0x3f9c94a6,
    0x0, 0x0, 0xbf666666, 0x3f9c141a,
    0x0, 0x0, 0xbf666666, 0x3f9b9417,
    0x0, 0x0, 0xbf666666, 0x3f9b149a,
    0x0, 0x0, 0xbf666666, 0x3f9a95a5,
    0x0, 0x0, 0xbf666666, 0x3f9a1735,
    0x0, 0x0, 0xbf666666, 0x3f999949,
    0x0, 0x0, 0xbf666666, 0x3f991be1,
    0x0, 0x0, 0xbf666666, 0x3f989efc,
    0x0, 0x0, 0xbf666666, 0x3f982298,
    0x0, 0x0, 0xbf666666, 0x3f97a6b6,
    0x0, 0x0, 0xbf666666, 0x3f972b53,
    0x0, 0x0, 0xbf666666, 0x3f96b06e,
    0x0, 0x0, 0xbf666666, 0x3f963608,
    0x0, 0x0, 0xbf666666, 0x3f95bc1f,
    0x0, 0x0, 0xbf666666, 0x3f9542b2,
    0x0, 0x0, 0xbf666666, 0x3f94c9c1,
    0x0, 0x0, 0xbf666666, 0x3f94514a,
    0x0, 0x0, 0xbf666666, 0x3f93d94c,
    0x0, 0x0, 0xbf666666, 0x3f9361c8,
    0x0, 0x0, 0xbf666666, 0x3f92eabb,
    0x0, 0x0, 0xbf666666, 0x3f927425,
    0x0, 0x0, 0xbf666666, 0x3f91fe05,
    0x0, 0x0, 0xbf666666, 0x3f91885b,
    0x0, 0x0, 0xbf666666, 0x3f911325,
    0x0, 0x0, 0xbf666666, 0x3f909e63,
    0x0, 0x0, 0xbf666666, 0x3f902a13,
    0x0, 0x0, 0xbf666666, 0x3f8fb636,
    0x0, 0x0, 0xbf666666, 0x3f8f42ca,
    0x0, 0x0, 0xbf666666, 0x3f8ecfcf,
    0x0, 0x0, 0xbf666666, 0x3f8e5d44,
    0x0, 0x0, 0xbf666666, 0x3f8deb27,
    0x0, 0x0, 0xbf666666, 0x3f8d7978,
    0x0, 0x0, 0xbf666666, 0x3f8d0837,
    0x0, 0x0, 0xbf666666, 0x3f8c9763,
    0x0, 0x0, 0xbf666666, 0x3f8c26fb,
    0x0, 0x0, 0xbf666666, 0x3f8bb6fe,
    0x0, 0x0, 0xbf666666, 0x3f8b476b,
    0x0, 0x0, 0xbf666666, 0x3f8ad842,
    0x0, 0x0, 0xbf666666, 0x3f8a6982,
    0x0, 0x0, 0xbf666666, 0x3f89fb2b,
    0x0, 0x0, 0xbf666666, 0x3f898d3b,
    0x0, 0x0, 0xbf666666, 0x3f891fb2,
    0x0, 0x0, 0xbf666666, 0x3f88b28f,
    0x0, 0x0, 0xbf666666, 0x3f8845d2,
    0x0, 0x0, 0xbf666666, 0x3f87d979,
    0x0, 0x0, 0xbf666666, 0x3f876d85,
    0x0, 0x0, 0xbf666666, 0x3f8701f4,
    0x0, 0x0, 0xbf666666, 0x3f8696c6,
    0x0, 0x0, 0xbf666666, 0x3f862bfa,
    0x0, 0x0, 0xbf666666, 0x3f85c190,
    0x0, 0x0, 0xbf666666, 0x3f855786,
    0x0, 0x0, 0xbf666666, 0x3f84eddd,
    0x0, 0x0, 0xbf666666, 0x3f848494,
    0x0, 0x0, 0xbf666666, 0x3f841ba9,
    0x0, 0x0, 0xbf666666, 0x3f83b31d,
    0x0, 0x0, 0xbf666666, 0x3f834aee,
    0x0, 0x0, 0xbf666666, 0x3f82e31d,
    0x0, 0x0, 0xbf666666, 0x3f827ba8,
    0x0, 0x0, 0xbf666666, 0x3f82148e,
    0x0, 0x0, 0xbf666666, 0x3f81add1,
    0x0, 0x0, 0xbf666666, 0x3f81476d,
    0x0, 0x0, 0xbf666666, 0x3f80e164,
    0x0, 0x0, 0xbf666666, 0x3f807bb5,
    0x0, 0x0, 0xbf666666, 0x3f80165e,
    0x0, 0x0, 0xbf666666, 0x3f7f62bf,
    0x0, 0x0, 0xbf666666, 0x3f7e9972,
    0x0, 0x0, 0xbf666666, 0x3f7dd0d3,
    0x0, 0x0, 0xbf666666, 0x3f7d08e2,
    0x0, 0x0, 0xbf666666, 0x3f7c419c,
    0x0, 0x0, 0xbf666666, 0x3f7b7b02,
    0x0, 0x0, 0xbf666666, 0x3f7ab512,
    0x0, 0x0, 0xbf666666, 0x3f79efcb,
    0x0, 0x0, 0xbf666666, 0x3f792b2b,
    0x0, 0x0, 0xbf666666, 0x3f786732,
    0x0, 0x0, 0xbf666666, 0x3f77a3df,
    0x0, 0x0, 0xbf666666, 0x3f76e130,
    0x0, 0x0, 0xbf666666, 0x3f761f25,
    0x0, 0x0, 0xbf666666, 0x3f755dbd,
    0x0, 0x0, 0xbf666666, 0x3f749cf6,
    0x0, 0x0, 0xbf666666, 0x3f73dcd0,
    0x0, 0x0, 0xbf666666, 0x3f731d49,
    0x0, 0x0, 0xbf666666, 0x3f725e60,
    0x0, 0x0, 0xbf666666, 0x3f71a015,
    0x0, 0x0, 0xbf666666, 0x3f70e266,
    0x0, 0x0, 0xbf666666, 0x3f702553,
    0x0, 0x0, 0xbf666666, 0x3f6f68db,
    0x0, 0x0, 0xbf666666, 0x3f6eacfc,
    0x0, 0x0, 0xbf666666, 0x3f6df1b6,
    0x0, 0x0, 0xbf666666, 0x3f6d3707,
    0x0, 0x0, 0xbf666666, 0x3f6c7cef,
    0x0, 0x0, 0xbf666666, 0x3f6bc36d,
    0x0, 0x0, 0xbf666666, 0x3f6b0a7f,
    0x0, 0x0, 0xbf666666, 0x3f6a5226,
    0x0, 0x0, 0xbf666666, 0x3f699a60,
    0x0, 0x0, 0xbf666666, 0x3f68e32c,
    0x0, 0x0, 0xbf666666, 0x3f682c88,
    0x0, 0x0, 0xbf666666, 0x3f677676,
    0x0, 0x0, 0xbf666666, 0x3f66c0f3,
    0x0, 0x0, 0xbf666666, 0x3f660bfe,
    0x0, 0x0, 0xbf666666, 0x3f655797,
    0x0, 0x0, 0xbf666666, 0x3f64a3bd,
    0x0, 0x0, 0xbf666666, 0x3f63f06e,
    0x0, 0x0, 0xbf666666, 0x3f633dab,
    0x0, 0x0, 0xbf666666, 0x3f628b72,
    0x0, 0x0, 0xbf666666, 0x3f61d9c3,
    0x0, 0x0, 0xbf666666, 0x3f61289c,
    0x0, 0x0, 0xbf666666, 0x3f6077fd,
    0x0, 0x0, 0xbf666666, 0x3f5fc7e5,
    0x0, 0x0, 0xbf666666, 0x3f5f1853,
    0x0, 0x0, 0xbf666666, 0x3f5e6946,
    0x0, 0x0, 0xbf666666, 0x3f5dbabe,
    0x0, 0x0, 0xbf666666, 0x3f5d0cba,
    0x0, 0x0, 0xbf666666, 0x3f5c5f38,
    0x0, 0x0, 0xbf666666, 0x3f5bb239,
    0x0, 0x0, 0xbf666666, 0x3f5b05bb,
    0x0, 0x0, 0xbf666666, 0x3f5a59be,
    0x0, 0x0, 0xbf666666, 0x3f59ae40,
    0x0, 0x0, 0xbf666666, 0x3f590341,
    0x0, 0x0, 0xbf666666, 0x3f5858c1,
    0x0, 0x0, 0xbf666666, 0x3f57aebf,
    0x0, 0x0, 0xbf666666, 0x3f570539,
    0x0, 0x0, 0xbf666666, 0x3f565c2f,
    0x0, 0x0, 0xbf666666, 0x3f55b3a1,
    0x0, 0x0, 0xbf666666, 0x3f550b8d,
    0x0, 0x0, 0xbf666666, 0x3f5463f3,
    0x0, 0x0, 0xbf666666, 0x3f53bcd3,
    0x0, 0x0, 0xbf666666, 0x3f53162a,
    0x0, 0x0, 0xbf666666, 0x3f526ffa,
    0x0, 0x0, 0xbf666666, 0x3f51ca40,
    0x0, 0x0, 0xbf666666, 0x3f5124fd,
    0x0, 0x0, 0xbf666666, 0x3f508030,
    0x0, 0x0, 0xbf666666, 0x3f4fdbd8,
    0x0, 0x0, 0xbf666666, 0x3f4f37f3,
    0x0, 0x0, 0xbf666666, 0x3f4e9483,
    0x0, 0x0, 0xbf666666, 0x3f4df185,
    0x0, 0x0, 0xbf666666, 0x3f4d4efa,
    0x0, 0x0, 0xbf666666, 0x3f4cace0,
    0x0, 0x0, 0xbf666666, 0x3f4c0b37,
    0x0, 0x0, 0xbf666666, 0x3f4b69ff,
    0x0, 0x0, 0xbf666666, 0x3f4ac936,
    0x0, 0x0, 0xbf666666, 0x3f4a28dc,
    0x0, 0x0, 0xbf666666, 0x3f4988f1,
    0x0, 0x0, 0xbf666666, 0x3f48e973,
    0x0, 0x0, 0xbf666666, 0x3f484a62,
    0x0, 0x0, 0xbf666666, 0x3f47abbe,
    0x0, 0x0, 0xbf666666, 0x3f470d85,
    0x0, 0x0, 0xbf666666, 0x3f466fb8,
    0x0, 0x0, 0xbf666666, 0x3f45d256,
    0x0, 0x0, 0xbf666666, 0x3f45355d,
    0x0, 0x0, 0xbf666666, 0x3f4498ce,
    0x0, 0x0, 0xbf666666, 0x3f43fca7,
    0x0, 0x0, 0xbf666666, 0x3f4360e9,
    0x0, 0x0, 0xbf666666, 0x3f42c592,
    0x0, 0x0, 0xbf666666, 0x3f422aa3,
    0x0, 0x0, 0xbf666666, 0x3f41901a,
    0x0, 0x0, 0xbf666666, 0x3f40f5f6,
    0x0, 0x0, 0xbf666666, 0x3f405c38,
    0x0, 0x0, 0xbf666666, 0x3f3fc2df,
    0x0, 0x0, 0xbf666666, 0x3f3f29e9,
    0x0, 0x0, 0xbf666666, 0x3f3e9157,
    0x0, 0x0, 0xbf666666, 0x3f3df929,
    0x0, 0x0, 0xbf666666, 0x3f3d615c,
    0x0, 0x0, 0xbf666666, 0x3f3cc9f2,
    0x0, 0x0, 0xbf666666, 0x3f3c32e9,
    0x0, 0x0, 0xbf666666, 0x3f3b9c40,
    0x0, 0x0, 0xbf666666, 0x3f3b05f8,
    0x0, 0x0, 0xbf666666, 0x3f3a700f,
    0x0, 0x0, 0xbf666666, 0x3f39da86,
    0x0, 0x0, 0xbf666666, 0x3f39455b,
    0x0, 0x0, 0xbf666666, 0x3f38b08f,
    0x0, 0x0, 0xbf666666, 0x3f381c20,
    0x0, 0x0, 0xbf666666, 0x3f37880e,
    0x0, 0x0, 0xbf666666, 0x3f36f458,
    0x0, 0x0, 0xbf666666, 0x3f3660ff,
    0x0, 0x0, 0xbf666666, 0x3f35ce01,
    0x0, 0x0, 0xbf666666, 0x3f353b5e,
    0x0, 0x0, 0xbf666666, 0x3f34a915,
    0x0, 0x0, 0xbf666666, 0x3f341727,
    0x0, 0x0, 0xbf666666, 0x3f338592,
    0x0, 0x0, 0xbf666666, 0x3f32f456,
    0x0, 0x0, 0xbf666666, 0x3f326372,
    0x0, 0x0, 0xbf666666, 0x3f31d2e6,
    0x0, 0x0, 0xbf666666, 0x3f3142b2,
    0x0, 0x0, 0xbf666666, 0x3f30b2d5,
    0x0, 0x0, 0xbf666666, 0x3f30234f,
    0x0, 0x0, 0xbf666666, 0x3f2f941f,
    0x0, 0x0, 0xbf666666, 0x3f2f0544,
    0x0, 0x0, 0xbf666666, 0x3f2e76be,
    0x0, 0x0, 0xbf666666, 0x3f2de88d,
    0x0, 0x0, 0xbf666666, 0x3f2d5ab0,
    0x0, 0x0, 0xbf666666, 0x3f2ccd27,
    0x0, 0x0, 0xbf666666, 0x3f2c3ff1,
    0x0, 0x0, 0xbf666666, 0x3f2bb30e,
    0x0, 0x0, 0xbf666666, 0x3f2b267e,
    0x0, 0x0, 0xbf666666, 0x3f2a9a3f,
    0x0, 0x0, 0xbf666666, 0x3f2a0e52,
    0x0, 0x0, 0xbf666666, 0x3f2982b6,
    0x0, 0x0, 0xbf666666, 0x3f28f76a,
    0x0, 0x0, 0xbf666666, 0x3f286c6f,
    0x0, 0x0, 0xbf666666, 0x3f27e1c3,
    0x0, 0x0, 0xbf666666, 0x3f275766,
    0x0, 0x0, 0xbf666666, 0x3f26cd59,
    0x0, 0x0, 0xbf666666, 0x3f264399,
    0x0, 0x0, 0xbf666666, 0x3f25ba28,
    0x0, 0x0, 0xbf666666, 0x3f253104,
    0x0, 0x0, 0xbf666666, 0x3f24a82e,
    0x0, 0x0, 0xbf666666, 0x3f241fa4,
    0x0, 0x0, 0xbf666666, 0x3f239766,
    0x0, 0x0, 0xbf666666, 0x3f230f75,
    0x0, 0x0, 0xbf666666, 0x3f2287cf,
    0x0, 0x0, 0xbf666666, 0x3f220074,
    0x0, 0x0, 0xbf666666, 0x3f217963,
    0x0, 0x0, 0xbf666666, 0x3f20f29d,
    0x0, 0x0, 0xbf666666, 0x3f206c21,
    0x0, 0x0, 0xbf666666, 0x3f1fe5ee,
    0x0, 0x0, 0xbf666666, 0x3f1f6004,
    0x0, 0x0, 0xbf666666, 0x3f1eda63,
    0x0, 0x0, 0xbf666666, 0x3f1e550a,
    0x0, 0x0, 0xbf666666, 0x3f1dcff9,
    0x0, 0x0, 0xbf666666, 0x3f1d4b30,
    0x0, 0x0, 0xbf666666, 0x3f1cc6ae,
    0x0, 0x0, 0xbf666666, 0x3f1c4272,
    0x0, 0x0, 0xbf666666, 0x3f1bbe7d,
    0x0, 0x0, 0xbf666666, 0x3f1b3ace,
    0x0, 0x0, 0xbf666666, 0x3f1ab764,
    0x0, 0x0, 0xbf666666, 0x3f1a3440,
    0x0, 0x0, 0xbf666666, 0x3f19b160,
    0x0, 0x0, 0xbf666666, 0x3f192ec5,
    0x0, 0x0, 0xbf666666, 0x3f18ac6f,
    0x0, 0x0, 0xbf666666, 0x3f182a5c,
    0x0, 0x0, 0xbf666666, 0x3f17a88c,
    0x0, 0x0, 0xbf666666, 0x3f1726ff,
    0x0, 0x0, 0xbf666666, 0x3f16a5b5,
    0x0, 0x0, 0xbf666666, 0x3f1624ae,
    0x0, 0x0, 0xbf666666, 0x3f15a3e8,
    0x0, 0x0, 0xbf666666, 0x3f152364,
    0x0, 0x0, 0xbf666666, 0x3f14a321,
    0x0, 0x0, 0xbf666666, 0x3f14231f,
    0x0, 0x0, 0xbf666666, 0x3f13a35e,
    0x0, 0x0, 0xbf666666, 0x3f1323dd,
    0x0, 0x0, 0xbf666666, 0x3f12a49c,
    0x0, 0x0, 0xbf666666, 0x3f12259a,
    0x0, 0x0, 0xbf666666, 0x3f11a6d8,
    0x0, 0x0, 0xbf666666, 0x3f112855,
    0x0, 0x0, 0xbf666666, 0x3f10aa10,
    0x0, 0x0, 0xbf666666, 0x3f102c09,
    0x0, 0x0, 0xbf666666, 0x3f0fae40,
    0x0, 0x0, 0xbf666666, 0x3f0f30b5,
    0x0, 0x0, 0xbf666666, 0x3f0eb367,
    0x0, 0x0, 0xbf666666, 0x3f0e3655,
    0x0, 0x0, 0xbf666666, 0x3f0db981,
    0x0, 0x0, 0xbf666666, 0x3f0d3ce8,
    0x0, 0x0, 0xbf666666, 0x3f0cc08c,
    0x0, 0x0, 0xbf666666, 0x3f0c446b,
    0x0, 0x0, 0xbf666666, 0x3f0bc886,
    0x0, 0x0, 0xbf666666, 0x3f0b4cdb,
    0x0, 0x0, 0xbf666666, 0x3f0ad16b,
    0x0, 0x0, 0xbf666666, 0x3f0a5636,
    0x0, 0x0, 0xbf666666, 0x3f09db3a,
    0x0, 0x0, 0xbf666666, 0x3f096078,
    0x0, 0x0, 0xbf666666, 0x3f08e5f0,
    0x0, 0x0, 0xbf666666, 0x3f086ba1,
    0x0, 0x0, 0xbf666666, 0x3f07f18b,
    0x0, 0x0, 0xbf666666, 0x3f0777ad,
    0x0, 0x0, 0xbf666666, 0x3f06fe07,
    0x0, 0x0, 0xbf666666, 0x3f068499,
    0x0, 0x0, 0xbf666666, 0x3f060b63,
    0x0, 0x0, 0xbf666666, 0x3f059265,
    0x0, 0x0, 0xbf666666, 0x3f05199d,
    0x0, 0x0, 0xbf666666, 0x3f04a10c,
    0x0, 0x0, 0xbf666666, 0x3f0428b2,
    0x0, 0x0, 0xbf666666, 0x3f03b08d,
    0x0, 0x0, 0xbf666666, 0x3f03389f,
    0x0, 0x0, 0xbf666666, 0x3f02c0e6,
    0x0, 0x0, 0xbf666666, 0x3f024963,
    0x0, 0x0, 0xbf666666, 0x3f01d214,
    0x0, 0x0, 0xbf666666, 0x3f015afb,
    0x0, 0x0, 0xbf666666, 0x3f00e415,
    0x0, 0x0, 0xbf666666, 0x3f006d64,
    0x0, 0x0, 0xbf666666, 0x3effedcf,
    0x0, 0x0, 0xbf666666, 0x3eff013c,
    0x0, 0x0, 0xbf666666, 0x3efe1510,
    0x0, 0x0, 0xbf666666, 0x3efd294a,
    0x0, 0x0, 0xbf666666, 0x3efc3de9,
    0x0, 0x0, 0xbf666666, 0x3efb52ee,
    0x0, 0x0, 0xbf666666, 0x3efa6857,
    0x0, 0x0, 0xbf666666, 0x3ef97e25,
    0x0, 0x0, 0xbf666666, 0x3ef89456,
    0x0, 0x0, 0xbf666666, 0x3ef7aaea,
    0x0, 0x0, 0xbf666666, 0x3ef6c1e0,
    0x0, 0x0, 0xbf666666, 0x3ef5d938,
    0x0, 0x0, 0xbf666666, 0x3ef4f0f2,
    0x0, 0x0, 0xbf666666, 0x3ef4090c,
    0x0, 0x0, 0xbf666666, 0x3ef32187,
    0x0, 0x0, 0xbf666666, 0x3ef23a62,
    0x0, 0x0, 0xbf666666, 0x3ef1539c,
    0x0, 0x0, 0xbf666666, 0x3ef06d35,
    0x0, 0x0, 0xbf666666, 0x3eef872d,
    0x0, 0x0, 0xbf666666, 0x3eeea182,
    0x0, 0x0, 0xbf666666, 0x3eedbc34,
    0x0, 0x0, 0xbf666666, 0x3eecd744,
    0x0, 0x0, 0xbf666666, 0x3eebf2af,
    0x0, 0x0, 0xbf666666, 0x3eeb0e77,
    0x0, 0x0, 0xbf666666, 0x3eea2a9a,
    0x0, 0x0, 0xbf666666, 0x3ee94718,
    0x0, 0x0, 0xbf666666, 0x3ee863f0,
    0x0, 0x0, 0xbf666666, 0x3ee78122,
    0x0, 0x0, 0xbf666666, 0x3ee69ead,
    0x0, 0x0, 0xbf666666, 0x3ee5bc92,
    0x0, 0x0, 0xbf666666, 0x3ee4dacf,
    0x0, 0x0, 0xbf666666, 0x3ee3f964,
    0x0, 0x0, 0xbf666666, 0x3ee31850,
    0x0, 0x0, 0xbf666666, 0x3ee23793,
    0x0, 0x0, 0xbf666666, 0x3ee1572e,
    0x0, 0x0, 0xbf666666, 0x3ee0771e,
    0x0, 0x0, 0xbf666666, 0x3edf9764,
    0x0, 0x0, 0xbf666666, 0x3edeb7ff,
    0x0, 0x0, 0xbf666666, 0x3eddd8ee,
    0x0, 0x0, 0xbf666666, 0x3edcfa33,
    0x0, 0x0, 0xbf666666, 0x3edc1bca,
    0x0, 0x0, 0xbf666666, 0x3edb3db6,
    0x0, 0x0, 0xbf666666, 0x3eda5ff4,
    0x0, 0x0, 0xbf666666, 0x3ed98285,
    0x0, 0x0, 0xbf666666, 0x3ed8a567,
    0x0, 0x0, 0xbf666666, 0x3ed7c89c,
    0x0, 0x0, 0xbf666666, 0x3ed6ec21,
    0x0, 0x0, 0xbf666666, 0x3ed60ff7,
    0x0, 0x0, 0xbf666666, 0x3ed5341e,
    0x0, 0x0, 0xbf666666, 0x3ed45894,
    0x0, 0x0, 0xbf666666, 0x3ed37d5a,
    0x0, 0x0, 0xbf666666, 0x3ed2a26e,
    0x0, 0x0, 0xbf666666, 0x3ed1c7d1,
    0x0, 0x0, 0xbf666666, 0x3ed0ed83,
    0x0, 0x0, 0xbf666666, 0x3ed01382,
    0x0, 0x0, 0xbf666666, 0x3ecf39ce,
    0x0, 0x0, 0xbf666666, 0x3ece6067,
    0x0, 0x0, 0xbf666666, 0x3ecd874c,
    0x0, 0x0, 0xbf666666, 0x3eccae7e,
    0x0, 0x0, 0xbf666666, 0x3ecbd5fb,
    0x0, 0x0, 0xbf666666, 0x3ecafdc3,
    0x0, 0x0, 0xbf666666, 0x3eca25d6,
    0x0, 0x0, 0xbf666666, 0x3ec94e34,
    0x0, 0x0, 0xbf666666, 0x3ec876db,
    0x0, 0x0, 0xbf666666, 0x3ec79fcc,
    0x0, 0x0, 0xbf666666, 0x3ec6c906,
    0x0, 0x0, 0xbf666666, 0x3ec5f288,
    0x0, 0x0, 0xbf666666, 0x3ec51c53,
    0x0, 0x0, 0xbf666666, 0x3ec44666,
    0x0, 0x0, 0xbf666666, 0x3ec370c1,
    0x0, 0x0, 0xbf666666, 0x3ec29b62,
    0x0, 0x0, 0xbf666666, 0x3ec1c64a,
    0x0, 0x0, 0xbf666666, 0x3ec0f179,
    0x0, 0x0, 0xbf666666, 0x3ec01cee,
    0x0, 0x0, 0xbf666666, 0x3ebf48a8,
    0x0, 0x0, 0xbf666666, 0x3ebe74a7,
    0x0, 0x0, 0xbf666666, 0x3ebda0eb,
    0x0, 0x0, 0xbf666666, 0x3ebccd73,
    0x0, 0x0, 0xbf666666, 0x3ebbfa40,
    0x0, 0x0, 0xbf666666, 0x3ebb2750,
    0x0, 0x0, 0xbf666666, 0x3eba54a3,
    0x0, 0x0, 0xbf666666, 0x3eb98239,
    0x0, 0x0, 0xbf666666, 0x3eb8b012,
    0x0, 0x0, 0xbf666666, 0x3eb7de2d,
    0x0, 0x0, 0xbf666666, 0x3eb70c89,
    0x0, 0x0, 0xbf666666, 0x3eb63b27,
    0x0, 0x0, 0xbf666666, 0x3eb56a06,
    0x0, 0x0, 0xbf666666, 0x3eb49926,
    0x0, 0x0, 0xbf666666, 0x3eb3c885,
    0x0, 0x0, 0xbf666666, 0x3eb2f825,
    0x0, 0x0, 0xbf666666, 0x3eb22804,
    0x0, 0x0, 0xbf666666, 0x3eb15822,
    0x0, 0x0, 0xbf666666, 0x3eb08880,
    0x0, 0x0, 0xbf666666, 0x3eafb91b,
    0x0, 0x0, 0xbf666666, 0x3eaee9f5,
    0x0, 0x0, 0xbf666666, 0x3eae1b0c,
    0x0, 0x0, 0xbf666666, 0x3ead4c61,
    0x0, 0x0, 0xbf666666, 0x3eac7df3,
    0x0, 0x0, 0xbf666666, 0x3eabafc1,
    0x0, 0x0, 0xbf666666, 0x3eaae1cc,
    0x0, 0x0, 0xbf666666, 0x3eaa1412,
    0x0, 0x0, 0xbf666666, 0x3ea94695,
    0x0, 0x0, 0xbf666666, 0x3ea87952,
    0x0, 0x0, 0xbf666666, 0x3ea7ac4b,
    0x0, 0x0, 0xbf666666, 0x3ea6df7e,
    0x0, 0x0, 0xbf666666, 0x3ea612eb,
    0x0, 0x0, 0xbf666666, 0x3ea54692,
    0x0, 0x0, 0xbf666666, 0x3ea47a72,
    0x0, 0x0, 0xbf666666, 0x3ea3ae8c,
    0x0, 0x0, 0xbf666666, 0x3ea2e2df,
    0x0, 0x0, 0xbf666666, 0x3ea2176a,
    0x0, 0x0, 0xbf666666, 0x3ea14c2d,
    0x0, 0x0, 0xbf666666, 0x3ea08129,
    0x0, 0x0, 0xbf666666, 0x3e9fb65b,
    0x0, 0x0, 0xbf666666, 0x3e9eebc5,
    0x0, 0x0, 0xbf666666, 0x3e9e2166,
    0x0, 0x0, 0xbf666666, 0x3e9d573d,
    0x0, 0x0, 0xbf666666, 0x3e9c8d4b,
    0x0, 0x0, 0xbf666666, 0x3e9bc38e,
    0x0, 0x0, 0xbf666666, 0x3e9afa07,
    0x0, 0x0, 0xbf666666, 0x3e9a30b5,
    0x0, 0x0, 0xbf666666, 0x3e996798,
    0x0, 0x0, 0xbf666666, 0x3e989eaf,
    0x0, 0x0, 0xbf666666, 0x3e97d5fb,
    0x0, 0x0, 0xbf666666, 0x3e970d7a,
    0x0, 0x0, 0xbf666666, 0x3e96452d,
    0x0, 0x0, 0xbf666666, 0x3e957d14,
    0x0, 0x0, 0xbf666666, 0x3e94b52d,
    0x0, 0x0, 0xbf666666, 0x3e93ed79,
    0x0, 0x0, 0xbf666666, 0x3e9325f8,
    0x0, 0x0, 0xbf666666, 0x3e925ea8,
    0x0, 0x0, 0xbf666666, 0x3e91978a,
    0x0, 0x0, 0xbf666666, 0x3e90d09e,
    0x0, 0x0, 0xbf666666, 0x3e9009e2,
    0x0, 0x0, 0xbf666666, 0x3e8f4358,
    0x0, 0x0, 0xbf666666, 0x3e8e7cfe,
    0x0, 0x0, 0xbf666666, 0x3e8db6d4,
    0x0, 0x0, 0xbf666666, 0x3e8cf0d9,
    0x0, 0x0, 0xbf666666, 0x3e8c2b0f,
    0x0, 0x0, 0xbf666666, 0x3e8b6573,
    0x0, 0x0, 0xbf666666, 0x3e8aa007,
    0x0, 0x0, 0xbf666666, 0x3e89dac9,
    0x0, 0x0, 0xbf666666, 0x3e8915b9,
    0x0, 0x0, 0xbf666666, 0x3e8850d8,
    0x0, 0x0, 0xbf666666, 0x3e878c24,
    0x0, 0x0, 0xbf666666, 0x3e86c79e,
    0x0, 0x0, 0xbf666666, 0x3e860344,
    0x0, 0x0, 0xbf666666, 0x3e853f18,
    0x0, 0x0, 0xbf666666, 0x3e847b18,
    0x0, 0x0, 0xbf666666, 0x3e83b744,
    0x0, 0x0, 0xbf666666, 0x3e82f39d,
    0x0, 0x0, 0xbf666666, 0x3e823020,
    0x0, 0x0, 0xbf666666, 0x3e816cd0,
    0x0, 0x0, 0xbf666666, 0x3e80a9aa,
    0x0, 0x0, 0xbf666666, 0x3e7fcd5e,
    0x0, 0x0, 0xbf666666, 0x3e7e47be,
    0x0, 0x0, 0xbf666666, 0x3e7cc271,
    0x0, 0x0, 0xbf666666, 0x3e7b3d79,
    0x0, 0x0, 0xbf666666, 0x3e79b8d3,
    0x0, 0x0, 0xbf666666, 0x3e783481,
    0x0, 0x0, 0xbf666666, 0x3e76b080,
    0x0, 0x0, 0xbf666666, 0x3e752cd1,
    0x0, 0x0, 0xbf666666, 0x3e73a973,
    0x0, 0x0, 0xbf666666, 0x3e722666,
    0x0, 0x0, 0xbf666666, 0x3e70a3a8,
    0x0, 0x0, 0xbf666666, 0x3e6f2139,
    0x0, 0x0, 0xbf666666, 0x3e6d9f1a,
    0x0, 0x0, 0xbf666666, 0x3e6c1d48,
    0x0, 0x0, 0xbf666666, 0x3e6a9bc4,
    0x0, 0x0, 0xbf666666, 0x3e691a8d,
    0x0, 0x0, 0xbf666666, 0x3e6799a3,
    0x0, 0x0, 0xbf666666, 0x3e661904,
    0x0, 0x0, 0xbf666666, 0x3e6498b1,
    0x0, 0x0, 0xbf666666, 0x3e6318a9,
    0x0, 0x0, 0xbf666666, 0x3e6198eb,
    0x0, 0x0, 0xbf666666, 0x3e601976,
    0x0, 0x0, 0xbf666666, 0x3e5e9a4b,
    0x0, 0x0, 0xbf666666, 0x3e5d1b69,
    0x0, 0x0, 0xbf666666, 0x3e5b9ccf,
    0x0, 0x0, 0xbf666666, 0x3e5a1e7c,
    0x0, 0x0, 0xbf666666, 0x3e58a070,
    0x0, 0x0, 0xbf666666, 0x3e5722ab,
    0x0, 0x0, 0xbf666666, 0x3e55a52c,
    0x0, 0x0, 0xbf666666, 0x3e5427f2,
    0x0, 0x0, 0xbf666666, 0x3e52aafe,
    0x0, 0x0, 0xbf666666, 0x3e512e4d,
    0x0, 0x0, 0xbf666666, 0x3e4fb1e0,
    0x0, 0x0, 0xbf666666, 0x3e4e35b7,
    0x0, 0x0, 0xbf666666, 0x3e4cb9d1,
    0x0, 0x0, 0xbf666666, 0x3e4b3e2c,
    0x0, 0x0, 0xbf666666, 0x3e49c2ca,
    0x0, 0x0, 0xbf666666, 0x3e4847a9,
    0x0, 0x0, 0xbf666666, 0x3e46ccc8,
    0x0, 0x0, 0xbf666666, 0x3e455227,
    0x0, 0x0, 0xbf666666, 0x3e43d7c7,
    0x0, 0x0, 0xbf666666, 0x3e425da5,
    0x0, 0x0, 0xbf666666, 0x3e40e3c2,
    0x0, 0x0, 0xbf666666, 0x3e3f6a1d,
    0x0, 0x0, 0xbf666666, 0x3e3df0b6,
    0x0, 0x0, 0xbf666666, 0x3e3c778b,
    0x0, 0x0, 0xbf666666, 0x3e3afe9d,
    0x0, 0x0, 0xbf666666, 0x3e3985ec,
    0x0, 0x0, 0xbf666666, 0x3e380d76,
    0x0, 0x0, 0xbf666666, 0x3e36953a,
    0x0, 0x0, 0xbf666666, 0x3e351d3a,
    0x0, 0x0, 0xbf666666, 0x3e33a573,
    0x0, 0x0, 0xbf666666, 0x3e322de6,
    0x0, 0x0, 0xbf666666, 0x3e30b692,
    0x0, 0x0, 0xbf666666, 0x3e2f3f77,
    0x0, 0x0, 0xbf666666, 0x3e2dc893,
    0x0, 0x0, 0xbf666666, 0x3e2c51e7,
    0x0, 0x0, 0xbf666666, 0x3e2adb72,
    0x0, 0x0, 0xbf666666, 0x3e296533,
    0x0, 0x0, 0xbf666666, 0x3e27ef2b,
    0x0, 0x0, 0xbf666666, 0x3e267958,
    0x0, 0x0, 0xbf666666, 0x3e2503ba,
    0x0, 0x0, 0xbf666666, 0x3e238e50,
    0x0, 0x0, 0xbf666666, 0x3e22191b,
    0x0, 0x0, 0xbf666666, 0x3e20a419,
    0x0, 0x0, 0xbf666666, 0x3e1f2f4a,
    0x0, 0x0, 0xbf666666, 0x3e1dbaae,
    0x0, 0x0, 0xbf666666, 0x3e1c4644,
    0x0, 0x0, 0xbf666666, 0x3e1ad20b,
    0x0, 0x0, 0xbf666666, 0x3e195e04,
    0x0, 0x0, 0xbf666666, 0x3e17ea2d,
    0x0, 0x0, 0xbf666666, 0x3e167686,
    0x0, 0x0, 0xbf666666, 0x3e15030f,
    0x0, 0x0, 0xbf666666, 0x3e138fc7,
    0x0, 0x0, 0xbf666666, 0x3e121cad,
    0x0, 0x0, 0xbf666666, 0x3e10a9c2,
    0x0, 0x0, 0xbf666666, 0x3e0f3705,
    0x0, 0x0, 0xbf666666, 0x3e0dc475,
    0x0, 0x0, 0xbf666666, 0x3e0c5211,
    0x0, 0x0, 0xbf666666, 0x3e0adfda,
    0x0, 0x0, 0xbf666666, 0x3e096dcf,
    0x0, 0x0, 0xbf666666, 0x3e07fbef,
    0x0, 0x0, 0xbf666666, 0x3e068a3a,
    0x0, 0x0, 0xbf666666, 0x3e0518af,
    0x0, 0x0, 0xbf666666, 0x3e03a74e,
    0x0, 0x0, 0xbf666666, 0x3e023617,
    0x0, 0x0, 0xbf666666, 0x3e00c509,
    0x0, 0x0, 0xbf666666, 0x3dfea845,
    0x0, 0x0, 0xbf666666, 0x3dfbc6c9,
    0x0, 0x0, 0xbf666666, 0x3df8e59d,
    0x0, 0x0, 0xbf666666, 0x3df604be,
    0x0, 0x0, 0xbf666666, 0x3df3242d,
    0x0, 0x0, 0xbf666666, 0x3df043e8,
    0x0, 0x0, 0xbf666666, 0x3ded63ee,
    0x0, 0x0, 0xbf666666, 0x3dea843f,
    0x0, 0x0, 0xbf666666, 0x3de7a4d9,
    0x0, 0x0, 0xbf666666, 0x3de4c5bc,
    0x0, 0x0, 0xbf666666, 0x3de1e6e6,
    0x0, 0x0, 0xbf666666, 0x3ddf0857,
    0x0, 0x0, 0xbf666666, 0x3ddc2a0e,
    0x0, 0x0, 0xbf666666, 0x3dd94c0a,
    0x0, 0x0, 0xbf666666, 0x3dd66e4a,
    0x0, 0x0, 0xbf666666, 0x3dd390cd,
    0x0, 0x0, 0xbf666666, 0x3dd0b392,
    0x0, 0x0, 0xbf666666, 0x3dcdd698,
    0x0, 0x0, 0xbf666666, 0x3dcaf9de,
    0x0, 0x0, 0xbf666666, 0x3dc81d64,
    0x0, 0x0, 0xbf666666, 0x3dc54128,
    0x0, 0x0, 0xbf666666, 0x3dc2652a,
    0x0, 0x0, 0xbf666666, 0x3dbf8969,
    0x0, 0x0, 0xbf666666, 0x3dbcade3,
    0x0, 0x0, 0xbf666666, 0x3db9d298,
    0x0, 0x0, 0xbf666666, 0x3db6f786,
    0x0, 0x0, 0xbf666666, 0x3db41cae,
    0x0, 0x0, 0xbf666666, 0x3db1420e,
    0x0, 0x0, 0xbf666666, 0x3dae67a5,
    0x0, 0x0, 0xbf666666, 0x3dab8d72,
    0x0, 0x0, 0xbf666666, 0x3da8b375,
    0x0, 0x0, 0xbf666666, 0x3da5d9ac,
    0x0, 0x0, 0xbf666666, 0x3da30017,
    0x0, 0x0, 0xbf666666, 0x3da026b4,
    0x0, 0x0, 0xbf666666, 0x3d9d4d83,
    0x0, 0x0, 0xbf666666, 0x3d9a7483,
    0x0, 0x0, 0xbf666666, 0x3d979bb3,
    0x0, 0x0, 0xbf666666, 0x3d94c313,
    0x0, 0x0, 0xbf666666, 0x3d91eaa0,
    0x0, 0x0, 0xbf666666, 0x3d8f125a,
    0x0, 0x0, 0xbf666666, 0x3d8c3a41,
    0x0, 0x0, 0xbf666666, 0x3d896254,
    0x0, 0x0, 0xbf666666, 0x3d868a91,
    0x0, 0x0, 0xbf666666, 0x3d83b2f8,
    0x0, 0x0, 0xbf666666, 0x3d80db87,
    0x0, 0x0, 0xbf666666, 0x3d7c087d,
    0x0, 0x0, 0xbf666666, 0x3d765a3a,
    0x0, 0x0, 0xbf666666, 0x3d70ac44,
    0x0, 0x0, 0xbf666666, 0x3d6afe98,
    0x0, 0x0, 0xbf666666, 0x3d655135,
    0x0, 0x0, 0xbf666666, 0x3d5fa418,
    0x0, 0x0, 0xbf666666, 0x3d59f741,
    0x0, 0x0, 0xbf666666, 0x3d544aae,
    0x0, 0x0, 0xbf666666, 0x3d4e9e5c,
    0x0, 0x0, 0xbf666666, 0x3d48f24a,
    0x0, 0x0, 0xbf666666, 0x3d434676,
    0x0, 0x0, 0xbf666666, 0x3d3d9adf,
    0x0, 0x0, 0xbf666666, 0x3d37ef82,
    0x0, 0x0, 0xbf666666, 0x3d32445f,
    0x0, 0x0, 0xbf666666, 0x3d2c9972,
    0x0, 0x0, 0xbf666666, 0x3d26eeba,
    0x0, 0x0, 0xbf666666, 0x3d214437,
    0x0, 0x0, 0xbf666666, 0x3d1b99e5,
    0x0, 0x0, 0xbf666666, 0x3d15efc3,
    0x0, 0x0, 0xbf666666, 0x3d1045cf,
    0x0, 0x0, 0xbf666666, 0x3d0a9c08,
    0x0, 0x0, 0xbf666666, 0x3d04f26c,
    0x0, 0x0, 0xbf666666, 0x3cfe91f2,
    0x0, 0x0, 0xbf666666, 0x3cf33f5a,
    0x0, 0x0, 0xbf666666, 0x3ce7ed0e,
    0x0, 0x0, 0xbf666666, 0x3cdc9b09,
    0x0, 0x0, 0xbf666666, 0x3cd14948,
    0x0, 0x0, 0xbf666666, 0x3cc5f7c8,
    0x0, 0x0, 0xbf666666, 0x3cbaa685,
    0x0, 0x0, 0xbf666666, 0x3caf557b,
    0x0, 0x0, 0xbf666666, 0x3ca404a8,
    0x0, 0x0, 0xbf666666, 0x3c98b407,
    0x0, 0x0, 0xbf666666, 0x3c8d6395,
    0x0, 0x0, 0xbf666666, 0x3c82134f,
    0x0, 0x0, 0xbf666666, 0x3c6d8663,
    0x0, 0x0, 0xbf666666, 0x3c56e670,
    0x0, 0x0, 0xbf666666, 0x3c4046c0,
    0x0, 0x0, 0xbf666666, 0x3c29a74b,
    0x0, 0x0, 0xbf666666, 0x3c13080a,
    0x0, 0x0, 0xbf666666, 0x3bf8d1ee,
    0x0, 0x0, 0xbf666666, 0x3bcb9414,
    0x0, 0x0, 0xbf666666, 0x3b9e5679,
    0x0, 0x0, 0xbf666666, 0x3b62321f,
    0x0, 0x0, 0xbf666666, 0x3b07b790,
    0x0, 0x0, 0xbf666666, 0x3a34f4ad,
    0x0
    };

static const uint32_t ref_rfft_step_4096[4097] = {
    0x44e66666, 0x0, 0xbf666666, 0x4492ad5b,
    0x0, 0x80000000, 0xbf666666, 0x43c391ba,
    0x0, 0x0, 0xbf666666, 0x436aaeaf,
    0x0, 0x0, 0xbf666666, 0x4327a125,
    0x0, 0x80000000, 0xbf666666, 0x430260ae,
    0x0, 0x0, 0xbf666666, 0x42d557f5,
    0x0, 0x0, 0xbf666666, 0x42b48511,
    0x0, 0x0, 0xbf666666, 0x429c72e3,
    0x0, 0x0, 0xbf666666, 0x428a0a93,
    0x0, 0x0, 0xbf666666, 0x4277048e,
    0x0, 0x0, 0xbf666666, 0x425f7d21,
    0x0, 0x0, 0xbf666666, 0x424c0d2c,
    0x0, 0x0, 0xbf666666, 0x423bb94b,
    0x0, 0x0, 0xbf666666, 0x422dd096,
    0x0, 0x0, 0xbf666666, 0x4221d2f2,
    0x0, 0x0, 0xbf666666, 0x42176154,
    0x0, 0x80000000, 0xbf666666, 0x420e33ba,
    0x0, 0x0, 0xbf666666, 0x42061299,
    0x0, 0x0, 0xbf666666, 0x41fda4d0,
    0x0, 0x0, 0xbf666666, 0x41f0a116,
    0x0, 0x0, 0xbf666666, 0x41e4e251,
    0x0, 0x0, 0xbf666666, 0x41da3b28,
    0x0, 0x0, 0xbf666666, 0x41d08654,
    0x0, 0x0, 0xbf666666, 0x41c7a4e5,
    0x0, 0x0, 0xbf666666, 0x41bf7cf9,
    0x0, 0x0, 0xbf666666, 0x41b7f8bc,
    0x0, 0x0, 0xbf666666, 0x41b105a6,
    0x0, 0x0, 0xbf666666, 0x41aa93e2,
    0x0, 0x0, 0xbf666666, 0x41a495d3,
    0x0, 0x0, 0xbf666666, 0x419effb4,
    0x0, 0x0, 0xbf666666, 0x4199c74d,
    0x0, 0x0, 0xbf666666, 0x4194e3b1,
    0x0, 0x0, 0xbf666666, 0x41904d0b,
    0x0, 0x0, 0xbf666666, 0x418bfc78,
    0x0, 0x0, 0xbf666666, 0x4187ebdf,
    0x0, 0x0, 0xbf666666, 0x418415d9,
    0x0, 0x0, 0xbf666666, 0x41807595,
    0x0, 0x0, 0xbf666666, 0x417a0d8b,
    0x0, 0x0, 0xbf666666, 0x41738b22,
    0x0, 0x0, 0xbf666666, 0x416d5d00,
    0x0, 0x0, 0xbf666666, 0x41677ce7,
    0x0, 0x0, 0xbf666666, 0x4161e534,
    0x0, 0x0, 0xbf666666, 0x415c90ca,
    0x0, 0x0, 0xbf666666, 0x41577b05,
    0x0, 0x0, 0xbf666666, 0x41529fac,
    0x0, 0x0, 0xbf666666, 0x414dfae4,
    0x0, 0x0, 0xbf666666, 0x4149892a,
    0x0, 0x0, 0xbf666666, 0x41454742,
    0x0, 0x0, 0xbf666666, 0x41413238,
    0x0, 0x0, 0xbf666666, 0x413d4754,
    0x0, 0x0, 0xbf666666, 0x41398415,
    0x0, 0x0, 0xbf666666, 0x4135e62b,
    0x0, 0x0, 0xbf666666, 0x41326b75,
    0x0, 0x0, 0xbf666666, 0x412f11f9,
    0x0, 0x0, 0xbf666666, 0x412bd7e3,
    0x0, 0x0, 0xbf666666, 0x4128bb80,
    0x0, 0x0, 0xbf666666, 0x4125bb3d,
    0x0, 0x0, 0xbf666666, 0x4122d5a2,
    0x0, 0x0, 0xbf666666, 0x41200951,
    0x0, 0x0, 0xbf666666, 0x411d5503,
    0x0, 0x0, 0xbf666666, 0x411ab789,
    0x0, 0x0, 0xbf666666, 0x41182fc4,
    0x0, 0x0, 0xbf666666, 0x4115bcaa,
    0x0, 0x0, 0xbf666666, 0x41135d42,
    0x0, 0x80000000, 0xbf666666, 0x4111109f,
    0x0, 0x0, 0xbf666666, 0x410ed5e8,
    0x0, 0x0, 0xbf666666, 0x410cac4c,
    0x0, 0x0, 0xbf666666, 0x410a9308,
    0x0, 0x0, 0xbf666666, 0x41088967,
    0x0, 0x0, 0xbf666666, 0x41068eba,
    0x0, 0x0, 0xbf666666, 0x4104a25f,
    0x0, 0x0, 0xbf666666, 0x4102c3bc,
    0x0, 0x0, 0xbf666666, 0x4100f240,
    0x0, 0x0, 0xbf666666, 0x40fe5ac3,
    0x0, 0x0, 0xbf666666, 0x40fae93d,
    0x0, 0x0, 0xbf666666, 0x40f78ef6,
    0x0, 0x0, 0xbf666666, 0x40f44b07,
    0x0, 0x0, 0xbf666666, 0x40f11c91,
    0x0, 0x0, 0xbf666666, 0x40ee02c3,
    0x0, 0x0, 0xbf666666, 0x40eafcd4,
    0x0, 0x0, 0xbf666666, 0x40e80a08,
    0x0, 0x0, 0xbf666666, 0x40e529aa,
    0x0, 0x0, 0xbf666666, 0x40e25b0e,
    0x0, 0x0, 0xbf666666, 0x40df9d91,
    0x0, 0x0, 0xbf666666, 0x40dcf098,
    0x0, 0x0, 0xbf666666, 0x40da538d,
    0x0, 0x0, 0xbf666666, 0x40d7c5e5,
    0x0, 0x0, 0xbf666666, 0x40d54717,
    0x0, 0x0, 0xbf666666, 0x40d2d6a2,
    0x0, 0x0, 0xbf666666, 0x40d0740d,
    0x0, 0x0, 0xbf666666, 0x40ce1ee0,
    0x0, 0x0, 0xbf666666, 0x40cbd6ab,
    0x0, 0x0, 0xbf666666, 0x40c99b03,
    0x0, 0x0, 0xbf666666, 0x40c76b81,
    0x0, 0x0, 0xbf666666, 0x40c547c1,
    0x0, 0x0, 0xbf666666, 0x40c32f66,
    0x0, 0x0, 0xbf666666, 0x40c12214,
    0x0, 0x0, 0xbf666666, 0x40bf1f75,
    0x0, 0x0, 0xbf666666, 0x40bd2735,
    0x0, 0x0, 0xbf666666, 0x40bb3904,
    0x0, 0x0, 0xbf666666, 0x40b95496,
    0x0, 0x0, 0xbf666666, 0x40b779a0,
    0x0, 0x0, 0xbf666666, 0x40b5a7db,
    0x0, 0x0, 0xbf666666, 0x40b3df04,
    0x0, 0x0, 0xbf666666, 0x40b21ed8,
    0x0, 0x0, 0xbf666666, 0x40b06719,
    0x0, 0x0, 0xbf666666, 0x40aeb78a,
    0x0, 0x0, 0xbf666666, 0x40ad0ff0,
    0x0, 0x0, 0xbf666666, 0x40ab7012,
    0x0, 0x0, 0xbf666666, 0x40a9d7bc,
    0x0, 0x0, 0xbf666666, 0x40a846b8,
    0x0, 0x0, 0xbf666666, 0x40a6bcd4,
    0x0, 0x0, 0xbf666666, 0x40a539df,
    0x0, 0x0, 0xbf666666, 0x40a3bdaa,
    0x0, 0x0, 0xbf666666, 0x40a24809,
    0x0, 0x0, 0xbf666666, 0x40a0d8cf,
    0x0, 0x0, 0xbf666666, 0x409f6fd2,
    0x0, 0x0, 0xbf666666, 0x409e0ce9,
    0x0, 0x0, 0xbf666666, 0x409cafed,
    0x0, 0x0, 0xbf666666, 0x409b58b8,
    0x0, 0x0, 0xbf666666, 0x409a0726,
    0x0, 0x0, 0xbf666666, 0x4098bb11,
    0x0, 0x0, 0xbf666666, 0x40977459,
    0x0, 0x0, 0xbf666666, 0x409632db,
    0x0, 0x0, 0xbf666666, 0x4094f678,
    0x0, 0x0, 0xbf666666, 0x4093bf0f,
    0x0, 0x0, 0xbf666666, 0x40928c84,
    0x0, 0x0, 0xbf666666, 0x40915eb8,
    0x0, 0x0, 0xbf666666, 0x40903590,
    0x0, 0x0, 0xbf666666, 0x408f10ef,
    0x0, 0x0, 0xbf666666, 0x408df0bc,
    0x0, 0x0, 0xbf666666, 0x408cd4db,
    0x0, 0x0, 0xbf666666, 0x408bbd35,
    0x0, 0x0, 0xbf666666, 0x408aa9b0,
    0x0, 0x0, 0xbf666666, 0x40899a36,
    0x0, 0x0, 0xbf666666, 0x40888eaf,
    0x0, 0x0, 0xbf666666, 0x40878705,
    0x0, 0x0, 0xbf666666, 0x40868323,
    0x0, 0x0, 0xbf666666, 0x408582f3,
    0x0, 0x0, 0xbf666666, 0x40848661,
    0x0, 0x0, 0xbf666666, 0x40838d5a,
    0x0, 0x0, 0xbf666666, 0x408297ca,
    0x0, 0x0, 0xbf666666, 0x4081a59e,
    0x0, 0x0, 0xbf666666, 0x4080b6c5,
    0x0, 0x0, 0xbf666666, 0x407f9659,
    0x0, 0x0, 0xbf666666, 0x407dc587,
    0x0, 0x0, 0xbf666666, 0x407bfaf2,
    0x0, 0x0, 0xbf666666, 0x407a367b,
    0x0, 0x0, 0xbf666666, 0x40787801,
    0x0, 0x0, 0xbf666666, 0x4076bf66,
    0x0, 0x0, 0xbf666666, 0x40750c8b,
    0x0, 0x0, 0xbf666666, 0x40735f54,
    0x0, 0x0, 0xbf666666, 0x4071b7a5,
    0x0, 0x0, 0xbf666666, 0x40701560,
    0x0, 0x0, 0xbf666666, 0x406e786d,
    0x0, 0x0, 0xbf666666, 0x406ce0af,
    0x0, 0x0, 0xbf666666, 0x406b4e0f,
    0x0, 0x0, 0xbf666666, 0x4069c072,
    0x0, 0x0, 0xbf666666, 0x406837c0,
    0x0, 0x0, 0xbf666666, 0x4066b3e3,
    0x0, 0x0, 0xbf666666, 0x406534c2,
    0x0, 0x0, 0xbf666666, 0x4063ba47,
    0x0, 0x0, 0xbf666666, 0x4062445c,
    0x0, 0x0, 0xbf666666, 0x4060d2ec,
    0x0, 0x0, 0xbf666666, 0x405f65e2,
    0x0, 0x0, 0xbf666666, 0x405dfd29,
    0x0, 0x0, 0xbf666666, 0x405c98ae,
    0x0, 0x0, 0xbf666666, 0x405b385d,
    0x0, 0x0, 0xbf666666, 0x4059dc22,
    0x0, 0x0, 0xbf666666, 0x405883ec,
    0x0, 0x0, 0xbf666666, 0x40572fa9,
    0x0, 0x0, 0xbf666666, 0x4055df46,
    0x0, 0x0, 0xbf666666, 0x405492b3,
    0x0, 0x0, 0xbf666666, 0x405349de,
    0x0, 0x0, 0xbf666666, 0x405204b7,
    0x0, 0x0, 0xbf666666, 0x4050c32f,
    0x0, 0x0, 0xbf666666, 0x404f8534,
    0x0, 0x0, 0xbf666666, 0x404e4ab8,
    0x0, 0x0, 0xbf666666, 0x404d13ac,
    0x0, 0x0, 0xbf666666, 0x404be001,
    0x0, 0x0, 0xbf666666, 0x404aafa9,
    0x0, 0x0, 0xbf666666, 0x40498295,
    0x0, 0x0, 0xbf666666, 0x404858b8,
    0x0, 0x0, 0xbf666666, 0x40473205,
    0x0, 0x0, 0xbf666666, 0x40460e6e,
    0x0, 0x0, 0xbf666666, 0x4044ede6,
    0x0, 0x0, 0xbf666666, 0x4043d061,
    0x0, 0x0, 0xbf666666, 0x4042b5d2,
    0x0, 0x0, 0xbf666666, 0x40419e2e,
    0x0, 0x0, 0xbf666666, 0x40408968,
    0x0, 0x0, 0xbf666666, 0x403f7774,
    0x0, 0x0, 0xbf666666, 0x403e6849,
    0x0, 0x0, 0xbf666666, 0x403d5bda,
    0x0, 0x0, 0xbf666666, 0x403c521d,
    0x0, 0x0, 0xbf666666, 0x403b4b06,
    0x0, 0x0, 0xbf666666, 0x403a468c,
    0x0, 0x0, 0xbf666666, 0x403944a5,
    0x0, 0x0, 0xbf666666, 0x40384545,
    0x0, 0x0, 0xbf666666, 0x40374865,
    0x0, 0x0, 0xbf666666, 0x40364df9,
    0x0, 0x0, 0xbf666666, 0x403555f8,
    0x0, 0x0, 0xbf666666, 0x4034605a,
    0x0, 0x0, 0xbf666666, 0x40336d15,
    0x0, 0x0, 0xbf666666, 0x40327c21,
    0x0, 0x0, 0xbf666666, 0x40318d74,
    0x0, 0x0, 0xbf666666, 0x4030a106,
    0x0, 0x0, 0xbf666666, 0x402fb6cf,
    0x0, 0x0, 0xbf666666, 0x402ecec7,
    0x0, 0x0, 0xbf666666, 0x402de8e5,
    0x0, 0x0, 0xbf666666, 0x402d0521,
    0x0, 0x0, 0xbf666666, 0x402c2375,
    0x0, 0x0, 0xbf666666, 0x402b43d8,
    0x0, 0x0, 0xbf666666, 0x402a6642,
    0x0, 0x0, 0xbf666666, 0x40298aae,
    0x0, 0x0, 0xbf666666, 0x4028b112,
    0x0, 0x0, 0xbf666666, 0x4027d969,
    0x0, 0x0, 0xbf666666, 0x402703ab,
    0x0, 0x0, 0xbf666666, 0x40262fd2,
    0x0, 0x0, 0xbf666666, 0x40255dd6,
    0x0, 0x0, 0xbf666666, 0x40248db2,
    0x0, 0x0, 0xbf666666, 0x4023bf60,
    0x0, 0x0, 0xbf666666, 0x4022f2d7,
    0x0, 0x0, 0xbf666666, 0x40222813,
    0x0, 0x0, 0xbf666666, 0x40215f0e,
    0x0, 0x0, 0xbf666666, 0x402097c1,
    0x0, 0x0, 0xbf666666, 0x401fd227,
    0x0, 0x0, 0xbf666666, 0x401f0e39,
    0x0, 0x0, 0xbf666666, 0x401e4bf3,
    0x0, 0x0, 0xbf666666, 0x401d8b4e,
    0x0, 0x0, 0xbf666666, 0x401ccc45,
    0x0, 0x0, 0xbf666666, 0x401c0ed3,
    0x0, 0x0, 0xbf666666, 0x401b52f2,
    0x0, 0x0, 0xbf666666, 0x401a989e,
    0x0, 0x0, 0xbf666666, 0x4019dfd1,
    0x0, 0x0, 0xbf666666, 0x40192886,
    0x0, 0x0, 0xbf666666, 0x401872b8,
    0x0, 0x0, 0xbf666666, 0x4017be63,
    0x0, 0x0, 0xbf666666, 0x40170b81,
    0x0, 0x0, 0xbf666666, 0x40165a0e,
    0x0, 0x0, 0xbf666666, 0x4015aa06,
    0x0, 0x0, 0xbf666666, 0x4014fb63,
    0x0, 0x0, 0xbf666666, 0x40144e22,
    0x0, 0x0, 0xbf666666, 0x4013a23d,
    0x0, 0x0, 0xbf666666, 0x4012f7b2,
    0x0, 0x0, 0xbf666666, 0x40124e7a,
    0x0, 0x0, 0xbf666666, 0x4011a693,
    0x0, 0x0, 0xbf666666, 0x4010fff9,
    0x0, 0x0, 0xbf666666, 0x40105aa6,
    0x0, 0x0, 0xbf666666, 0x400fb697,
    0x0, 0x0, 0xbf666666, 0x400f13c9,
    0x0, 0x0, 0xbf666666, 0x400e7237,
    0x0, 0x0, 0xbf666666, 0x400dd1de,
    0x0, 0x0, 0xbf666666, 0x400d32ba,
    0x0, 0x0, 0xbf666666, 0x400c94c7,
    0x0, 0x0, 0xbf666666, 0x400bf801,
    0x0, 0x0, 0xbf666666, 0x400b5c66,
    0x0, 0x80000000, 0xbf666666, 0x400ac1f1,
    0x0, 0x0, 0xbf666666, 0x400a28a0,
    0x0, 0x0, 0xbf666666, 0x4009906e,
    0x0, 0x0, 0xbf666666, 0x4008f959,
    0x0, 0x0, 0xbf666666, 0x4008635c,
    0x0, 0x0, 0xbf666666, 0x4007ce76,
    0x0, 0x0, 0xbf666666, 0x40073aa3,
    0x0, 0x0, 0xbf666666, 0x4006a7df,
    0x0, 0x0, 0xbf666666, 0x40061627,
    0x0, 0x0, 0xbf666666, 0x40058579,
    0x0, 0x0, 0xbf666666, 0x4004f5d2,
    0x0, 0x0, 0xbf666666, 0x4004672e,
    0x0, 0x0, 0xbf666666, 0x4003d98a,
    0x0, 0x0, 0xbf666666, 0x40034ce5,
    0x0, 0x0, 0xbf666666, 0x4002c13a,
    0x0, 0x0, 0xbf666666, 0x40023687,
    0x0, 0x0, 0xbf666666, 0x4001acca,
    0x0, 0x0, 0xbf666666, 0x40012400,
    0x0, 0x0, 0xbf666666, 0x40009c26,
    0x0, 0x0, 0xbf666666, 0x40001539,
    0x0, 0x0, 0xbf666666, 0x3fff1e6d,
    0x0, 0x0, 0xbf666666, 0x3ffe1439,
    0x0, 0x0, 0xbf666666, 0x3ffd0bd1,
    0x0, 0x0, 0xbf666666, 0x3ffc0530,
    0x0, 0x0, 0xbf666666, 0x3ffb0050,
    0x0, 0x0, 0xbf666666, 0x3ff9fd2d,
    0x0, 0x0, 0xbf666666, 0x3ff8fbc3,
    0x0, 0x0, 0xbf666666, 0x3ff7fc0c,
    0x0, 0x0, 0xbf666666, 0x3ff6fe03,
    0x0, 0x0, 0xbf666666, 0x3ff601a6,
    0x0, 0x0, 0xbf666666, 0x3ff506ee,
    0x0, 0x0, 0xbf666666, 0x3ff40dd7,
    0x0, 0x0, 0xbf666666, 0x3ff3165e,
    0x0, 0x0, 0xbf666666, 0x3ff2207d,
    0x0, 0x0, 0xbf666666, 0x3ff12c32,
    0x0, 0x0, 0xbf666666, 0x3ff03976,
    0x0, 0x0, 0xbf666666, 0x3fef4847,
    0x0, 0x0, 0xbf666666, 0x3fee58a0,
    0x0, 0x0, 0xbf666666, 0x3fed6a7d,
    0x0, 0x0, 0xbf666666, 0x3fec7dda,
    0x0, 0x0, 0xbf666666, 0x3feb92b4,
    0x0, 0x0, 0xbf666666, 0x3feaa906,
    0x0, 0x0, 0xbf666666, 0x3fe9c0cd,
    0x0, 0x0, 0xbf666666, 0x3fe8da05,
    0x0, 0x0, 0xbf666666, 0x3fe7f4aa,
    0x0, 0x0, 0xbf666666, 0x3fe710b9,
    0x0, 0x0, 0xbf666666, 0x3fe62e2d,
    0x0, 0x0, 0xbf666666, 0x3fe54d04,
    0x0, 0x0, 0xbf666666, 0x3fe46d3a,
    0x0, 0x0, 0xbf666666, 0x3fe38ecc,
    0x0, 0x0, 0xbf666666, 0x3fe2b1b5,
    0x0, 0x0, 0xbf666666, 0x3fe1d5f3,
    0x0, 0x0, 0xbf666666, 0x3fe0fb83,
    0x0, 0x0, 0xbf666666, 0x3fe02260,
    0x0, 0x0, 0xbf666666, 0x3fdf4a89,
    0x0, 0x0, 0xbf666666, 0x3fde73f9,
    0x0, 0x0, 0xbf666666, 0x3fdd9ead,
    0x0, 0x0, 0xbf666666, 0x3fdccaa3,
    0x0, 0x0, 0xbf666666, 0x3fdbf7d7,
    0x0, 0x0, 0xbf666666, 0x3fdb2646,
    0x0, 0x0, 0xbf666666, 0x3fda55ee,
    0x0, 0x0, 0xbf666666, 0x3fd986ca,
    0x0, 0x0, 0xbf666666, 0x3fd8b8d9,
    0x0, 0x0, 0xbf666666, 0x3fd7ec17,
    0x0, 0x0, 0xbf666666, 0x3fd72082,
    0x0, 0x0, 0xbf666666, 0x3fd65617,
    0x0, 0x0, 0xbf666666, 0x3fd58cd3,
    0x0, 0x0, 0xbf666666, 0x3fd4c4b2,
    0x0, 0x0, 0xbf666666, 0x3fd3fdb4,
    0x0, 0x0, 0xbf666666, 0x3fd337d4,
    0x0, 0x0, 0xbf666666, 0x3fd27310,
    0x0, 0x0, 0xbf666666, 0x3fd1af66,
    0x0, 0x0, 0xbf666666, 0x3fd0ecd2,
    0x0, 0x0, 0xbf666666, 0x3fd02b53,
    0x0, 0x0, 0xbf666666, 0x3fcf6ae6,
    0x0, 0x0, 0xbf666666, 0x3fceab89,
    0x0, 0x0, 0xbf666666, 0x3fcded38,
    0x0, 0x0, 0xbf666666, 0x3fcd2ff1,
    0x0, 0x0, 0xbf666666, 0x3fcc73b3,
    0x0, 0x0, 0xbf666666, 0x3fcbb87b,
    0x0, 0x0, 0xbf666666, 0x3fcafe45,
    0x0, 0x0, 0xbf666666, 0x3fca4511,
    0x0, 0x0, 0xbf666666, 0x3fc98cdb,
    0x0, 0x0, 0xbf666666, 0x3fc8d5a2,
    0x0, 0x0, 0xbf666666, 0x3fc81f63,
    0x0, 0x0, 0xbf666666, 0x3fc76a1c,
    0x0, 0x0, 0xbf666666, 0x3fc6b5cb,
    0x0, 0x0, 0xbf666666, 0x3fc6026e,
    0x0, 0x0, 0xbf666666, 0x3fc55002,
    0x0, 0x0, 0xbf666666, 0x3fc49e85,
    0x0, 0x0, 0xbf666666, 0x3fc3edf6,
    0x0, 0x0, 0xbf666666, 0x3fc33e52,
    0x0, 0x0, 0xbf666666, 0x3fc28f97,
    0x0, 0x0, 0xbf666666, 0x3fc1e1c3,
    0x0, 0x0, 0xbf666666, 0x3fc134d5,
    0x0, 0x0, 0xbf666666, 0x3fc088c9,
    0x0, 0x0, 0xbf666666, 0x3fbfdd9f,
    0x0, 0x0, 0xbf666666, 0x3fbf3354,
    0x0, 0x0, 0xbf666666, 0x3fbe89e7,
    0x0, 0x0, 0xbf666666, 0x3fbde155,
    0x0, 0x0, 0xbf666666, 0x3fbd399d,
    0x0, 0x0, 0xbf666666, 0x3fbc92bd,
    0x0, 0x0, 0xbf666666, 0x3fbbecb3,
    0x0, 0x0, 0xbf666666, 0x3fbb477d,
    0x0, 0x0, 0xbf666666, 0x3fbaa319,
    0x0, 0x0, 0xbf666666, 0x3fb9ff86,
    0x0, 0x0, 0xbf666666, 0x3fb95cc2,
    0x0, 0x0, 0xbf666666, 0x3fb8bacb,
    0x0, 0x0, 0xbf666666, 0x3fb8199f,
    0x0, 0x0, 0xbf666666, 0x3fb7793e,
    0x0, 0x0, 0xbf666666, 0x3fb6d9a4,
    0x0, 0x0, 0xbf666666, 0x3fb63ad1,
    0x0, 0x0, 0xbf666666, 0x3fb59cc3,
    0x0, 0x0, 0xbf666666, 0x3fb4ff78,
    0x0, 0x0, 0xbf666666, 0x3fb462ef,
    0x0, 0x0, 0xbf666666, 0x3fb3c726,
    0x0, 0x0, 0xbf666666, 0x3fb32c1b,
    0x0, 0x0, 0xbf666666, 0x3fb291cd,
    0x0, 0x0, 0xbf666666, 0x3fb1f83a,
    0x0, 0x0, 0xbf666666, 0x3fb15f62,
    0x0, 0x0, 0xbf666666, 0x3fb0c742,
    0x0, 0x0, 0xbf666666, 0x3fb02fd9,
    0x0, 0x0, 0xbf666666, 0x3faf9925,
    0x0, 0x0, 0xbf666666, 0x3faf0325,
    0x0, 0x0, 0xbf666666, 0x3fae6dd8,
    0x0, 0x0, 0xbf666666, 0x3fadd93c,
    0x0, 0x0, 0xbf666666, 0x3fad454f,
    0x0, 0x0, 0xbf666666, 0x3facb211,
    0x0, 0x0, 0xbf666666, 0x3fac1f80,
    0x0, 0x0, 0xbf666666, 0x3fab8d9b,
    0x0, 0x0, 0xbf666666, 0x3faafc60,
    0x0, 0x0, 0xbf666666, 0x3faa6bcd,
    0x0, 0x0, 0xbf666666, 0x3fa9dbe3,
    0x0, 0x0, 0xbf666666, 0x3fa94c9e,
    0x0, 0x0, 0xbf666666, 0x3fa8bdff,
    0x0, 0x0, 0xbf666666, 0x3fa83003,
    0x0, 0x0, 0xbf666666, 0x3fa7a2aa,
    0x0, 0x0, 0xbf666666, 0x3fa715f2,
    0x0, 0x0, 0xbf666666, 0x3fa689da,
    0x0, 0x0, 0xbf666666, 0x3fa5fe60,
    0x0, 0x0, 0xbf666666, 0x3fa57384,
    0x0, 0x0, 0xbf666666, 0x3fa4e945,
    0x0, 0x0, 0xbf666666, 0x3fa45fa0,
    0x0, 0x0, 0xbf666666, 0x3fa3d695,
    0x0, 0x0, 0xbf666666, 0x3fa34e23,
    0x0, 0x0, 0xbf666666, 0x3fa2c649,
    0x0, 0x0, 0xbf666666, 0x3fa23f05,
    0x0, 0x0, 0xbf666666, 0x3fa1b857,
    0x0, 0x0, 0xbf666666, 0x3fa1323c,
    0x0, 0x0, 0xbf666666, 0x3fa0acb5,
    0x0, 0x0, 0xbf666666, 0x3fa027c0,
    0x0, 0x0, 0xbf666666, 0x3f9fa35b,
    0x0, 0x0, 0xbf666666, 0x3f9f1f86,
    0x0, 0x0, 0xbf666666, 0x3f9e9c40,
    0x0, 0x0, 0xbf666666, 0x3f9e1988,
    0x0, 0x0, 0xbf666666, 0x3f9d975c,
    0x0, 0x0, 0xbf666666, 0x3f9d15bc,
    0x0, 0x0, 0xbf666666, 0x3f9c94a6,
    0x0, 0x0, 0xbf666666, 0x3f9c141a,
    0x0, 0x0, 0xbf666666, 0x3f9b9417,
    0x0, 0x0, 0xbf666666, 0x3f9b149a,
    0x0, 0x0, 0xbf666666, 0x3f9a95a5,
    0x0, 0x0, 0xbf666666, 0x3f9a1735,
    0x0, 0x0, 0xbf666666, 0x3f999949,
    0x0, 0x0, 0xbf666666, 0x3f991be1,
    0x0, 0x0, 0xbf666666, 0x3f989efc,
    0x0, 0x0, 0xbf666666, 0x3f982298,
    0x0, 0x0, 0xbf666666, 0x3f97a6b6,
    0x0, 0x0, 0xbf666666, 0x3f972b53,
    0x0, 0x0, 0xbf666666, 0x3f96b06e,
    0x0, 0x0, 0xbf666666, 0x3f963608,
    0x0, 0x0, 0xbf666666, 0x3f95bc1f,
    0x0, 0x0, 0xbf666666, 0x3f9542b2,
    0x0, 0x0, 0xbf666666, 0x3f94c9c1,
    0x0, 0x0, 0xbf666666, 0x3f94514a,
    0x0, 0x0, 0xbf666666, 0x3f93d94c,
    0x0, 0x0, 0xbf666666, 0x3f9361c8,
    0x0, 0x0, 0xbf666666, 0x3f92eabb,
    0x0, 0x0, 0xbf666666, 0x3f927425,
    0x0, 0x0, 0xbf666666, 0x3f91fe05,
    0x0, 0x0, 0xbf666666, 0x3f91885b,
    0x0, 0x0, 0xbf666666, 0x3f911325,
    0x0, 0x0, 0xbf666666, 0x3f909e63,
    0x0, 0x0, 0xbf666666, 0x3f902a13,
    0x0, 0x0, 0xbf666666, 0x3f8fb636,
    0x0, 0x0, 0xbf666666, 0x3f8f42ca,
    0x0, 0x0, 0xbf666666, 0x3f8ecfcf,
    0x0, 0x0, 0xbf666666, 0x3f8e5d44,
    0x0, 0x0, 0xbf666666, 0x3f8deb27,
    0x0, 0x0, 0xbf666666, 0x3f8d7978,
    0x0, 0x0, 0xbf666666, 0x3f8d0837,
    0x0, 0x0, 0xbf666666, 0x3f8c9763,
    0x0, 0x0, 0xbf666666, 0x3f8c26fb,
    0x0, 0x0, 0xbf666666, 0x3f8bb6fe,
    0x0, 0x0, 0xbf666666, 0x3f8b476b,
    0x0, 0x0, 0xbf666666, 0x3f8ad842,
    0x0, 0x0, 0xbf666666, 0x3f8a6982,
    0x0, 0x0, 0xbf666666, 0x3f89fb2b,
    0x0, 0x0, 0xbf666666, 0x3f898d3b,
    0x0, 0x0, 0xbf666666, 0x3f891fb2,
    0x0, 0x0, 0xbf666666, 0x3f88b28f,
    0x0, 0x0, 0xbf666666, 0x3f8845d2,
    0x0, 0x0, 0xbf666666, 0x3f87d979,
    0x0, 0x0, 0xbf666666, 0x3f876d85,
    0x0, 0x0, 0xbf666666, 0x3f8701f4,
    0x0, 0x0, 0xbf666666, 0x3f8696c6,
    0x0, 0x0, 0xbf666666, 0x3f862bfa,
    0x0, 0x0, 0xbf666666, 0x3f85c190,
    0x0, 0x0, 0xbf666666, 0x3f855786,
    0x0, 0x0, 0xbf666666, 0x3f84eddd,
    0x0, 0x0, 0xbf666666, 0x3f848494,
    0x0, 0x0, 0xbf666666, 0x3f841ba9,
    0x0, 0x0, 0xbf666666, 0x3f83b31d,
    0x0, 0x0, 0xbf666666, 0x3f834aee,
    0x0, 0x0, 0xbf666666, 0x3f82e31d,
    0x0, 0x0, 0xbf666666, 0x3f827ba8,
    0x0, 0x0, 0xbf666666, 0x3f82148e,
    0x0, 0x0, 0xbf666666, 0x3f81add1,
    0x0, 0x0, 0xbf666666, 0x3f81476d,
    0x0, 0x0, 0xbf666666, 0x3f80e164,
    0x0, 0x0, 0xbf666666, 0x3f807bb5,
    0x0, 0x0, 0xbf666666, 0x3f80165e,
    0x0, 0x0, 0xbf666666, 0x3f7f62bf,
    0x0, 0x0, 0xbf666666, 0x3f7e9972,
    0x0, 0x0, 0xbf666666, 0x3f7dd0d3,
    0x0, 0x0, 0xbf666666, 0x3f7d08e2,
    0x0, 0x0, 0xbf666666, 0x3f7c419c,
    0x0, 0x0, 0xbf666666, 0x3f7b7b02,
    0x0, 0x0, 0xbf666666, 0x3f7ab512,
    0x0, 0x0, 0xbf666666, 0x3f79efcb,
    0x0, 0x0, 0xbf666666, 0x3f792b2b,
    0x0, 0x0, 0xbf666666, 0x3f786732,
    0x0, 0x0, 0xbf666666, 0x3f77a3df,
    0x0, 0x0, 0xbf666666, 0x3f76e130,
    0x0, 0x0, 0xbf666666, 0x3f761f25,
    0x0, 0x0, 0xbf666666, 0x3f755dbd,
    0x0, 0x0, 0xbf666666, 0x3f749cf6,
    0x0, 0x0, 0xbf666666, 0x3f73dcd0,
    0x0, 0x0, 0xbf666666, 0x3f731d49,
    0x0, 0x0, 0xbf666666, 0x3f725e60,
    0x0, 0x0, 0xbf666666, 0x3f71a015,
    0x0, 0x0, 0xbf666666, 0x3f70e266,
    0x0, 0x0, 0xbf666666, 0x3f702553,
    0x0, 0x0, 0xbf666666, 0x3f6f68db,
    0x0, 0x0, 0xbf666666, 0x3f6eacfc,
    0x0, 0x0, 0xbf666666, 0x3f6df1b6,
    0x0, 0x0, 0xbf666666, 0x3f6d3707,
    0x0, 0x0, 0xbf666666, 0x3f6c7cef,
    0x0, 0x0, 0xbf666666, 0x3f6bc36d,
    0x0, 0x0, 0xbf666666, 0x3f6b0a7f,
    0x0, 0x0, 0xbf666666, 0x3f6a5226,
    0x0, 0x0, 0xbf666666, 0x3f699a60,
    0x0, 0x0, 0xbf666666, 0x3f68e32c,
    0x0, 0x0, 0xbf666666, 0x3f682c88,
    0x0, 0x0, 0xbf666666, 0x3f677676,
    0x0, 0x0, 0xbf666666, 0x3f66c0f3,
    0x0, 0x0, 0xbf666666, 0x3f660bfe,
    0x0, 0x0, 0xbf666666, 0x3f655797,
    0x0, 0x0, 0xbf666666, 0x3f64a3bd,
    0x0, 0x0, 0xbf666666, 0x3f63f06e,
    0x0, 0x0, 0xbf666666, 0x3f633dab,
    0x0, 0x0, 0xbf666666, 0x3f628b72,
    0x0, 0x0, 0xbf666666, 0x3f61d9c3,
    0x0, 0x0, 0xbf666666, 0x3f61289c,
    0x0, 0x0, 0xbf666666, 0x3f6077fd,
    0x0, 0x0, 0xbf666666, 0x3f5fc7e5,
    0x0, 0x0, 0xbf666666, 0x3f5f1853,
    0x0, 0x0, 0xbf666666, 0x3f5e6946,
    0x0, 0x0, 0xbf666666, 0x3f5dbabe,
    0x0, 0x0, 0xbf666666, 0x3f5d0cba,
    0x0, 0x0, 0xbf666666, 0x3f5c5f38,
    0x0, 0x0, 0xbf666666, 0x3f5bb239,
    0x0, 0x0, 0xbf666666, 0x3f5b05bb,
    0x0, 0x0, 0xbf666666, 0x3f5a59be,
    0x0, 0x0, 0xbf666666, 0x3f59ae40,
    0x0, 0x0, 0xbf666666, 0x3f590341,
    0x0, 0x0, 0xbf666666, 0x3f5858c1,
    0x0, 0x0, 0xbf666666, 0x3f57aebf,
    0x0, 0x0, 0xbf666666, 0x3f570539,
    0x0, 0x0, 0xbf666666, 0x3f565c2f,
    0x0, 0x0, 0xbf666666, 0x3f55b3a1,
    0x0, 0x0, 0xbf666666, 0x3f550b8d,
    0x0, 0x0, 0xbf666666, 0x3f5463f3,
    0x0, 0x0, 0xbf666666, 0x3f53bcd3,
    0x0, 0x0, 0xbf666666, 0x3f53162a,
    0x0, 0x0, 0xbf666666, 0x3f526ffa,
    0x0, 0x0, 0xbf666666, 0x3f51ca40,
    0x0, 0x0, 0xbf666666, 0x3f5124fd,
    0x0, 0x0, 0xbf666666, 0x3f508030,
    0x0, 0x0, 0xbf666666, 0x3f4fdbd8,
    0x0, 0x0, 0xbf666666, 0x3f4f37f3,
    0x0, 0x0, 0xbf666666, 0x3f4e9483,
    0x0, 0x0, 0xbf666666, 0x3f4df185,
    0x0, 0x0, 0xbf666666, 0x3f4d4efa,
    0x0, 0x0, 0xbf666666, 0x3f4cace0,
    0x0, 0x0, 0xbf666666, 0x3f4c0b37,
    0x0, 0x0, 0xbf666666, 0x3f4b69ff,
    0x0, 0x0, 0xbf666666, 0x3f4ac936,
    0x0, 0x0, 0xbf666666, 0x3f4a28dc,
    0x0, 0x0, 0xbf666666, 0x3f4988f1,
    0x0, 0x0, 0xbf666666, 0x3f48e973,
    0x0, 0x0, 0xbf666666, 0x3f484a62,
    0x0, 0x0, 0xbf666666, 0x3f47abbe,
    0x0, 0x0, 0xbf666666, 0x3f470d85,
    0x0, 0x0, 0xbf666666, 0x3f466fb8,
    0x0, 0x0, 0xbf666666, 0x3f45d256,
    0x0, 0x0, 0xbf666666, 0x3f45355d,
    0x0, 0x0, 0xbf666666, 0x3f4498ce,
    0x0, 0x0, 0xbf666666, 0x3f43fca7,
    0x0, 0x0, 0xbf666666, 0x3f4360e9,
    0x0, 0x0, 0xbf666666, 0x3f42c592,
    0x0, 0x0, 0xbf666666, 0x3f422aa3,
    0x0, 0x0, 0xbf666666, 0x3f41901a,
    0x0, 0x0, 0xbf666666, 0x3f40f5f6,
    0x0, 0x0, 0xbf666666, 0x3f405c38,
    0x0, 0x0, 0xbf666666, 0x3f3fc2df,
    0x0, 0x0, 0xbf666666, 0x3f3f29e9,
    0x0, 0x0, 0xbf666666, 0x3f3e9157,
    0x0, 0x0, 0xbf666666, 0x3f3df929,
    0x0, 0x0, 0xbf666666, 0x3f3d615c,
    0x0, 0x0, 0xbf666666, 0x3f3cc9f2,
    0x0, 0x0, 0xbf666666, 0x3f3c32e9,
    0x0, 0x0, 0xbf666666, 0x3f3b9c40,
    0x0, 0x0, 0xbf666666, 0x3f3b05f8,
    0x0, 0x0, 0xbf666666, 0x3f3a700f,
    0x0, 0x0, 0xbf666666, 0x3f39da86,
    0x0, 0x0, 0xbf666666, 0x3f39455b,
    0x0, 0x0, 0xbf666666, 0x3f38b08f,
    0x0, 0x0, 0xbf666666, 0x3f381c20,
    0x0, 0x0, 0xbf666666, 0x3f37880e,
    0x0, 0x0, 0xbf666666, 0x3f36f458,
    0x0, 0x0, 0xbf666666, 0x3f3660ff,
    0x0, 0x0, 0xbf666666, 0x3f35ce01,
    0x0, 0x0, 0xbf666666, 0x3f353b5e,
    0x0, 0x0, 0xbf666666, 0x3f34a915,
    0x0, 0x0, 0xbf666666, 0x3f341727,
    0x0, 0x0, 0xbf666666, 0x3f338592,
    0x0, 0x0, 0xbf666666, 0x3f32f456,
    0x0, 0x0, 0xbf666666, 0x3f326372,
    0x0, 0x0, 0xbf666666, 0x3f31d2e6,
    0x0, 0x0, 0xbf666666, 0x3f3142b2,
    0x0, 0x0, 0xbf666666, 0x3f30b2d5,
    0x0, 0x0, 0xbf666666, 0x3f30234f,
    0x0, 0x0, 0xbf666666, 0x3f2f941f,
    0x0, 0x0, 0xbf666666, 0x3f2f0544,
    0x0, 0x0, 0xbf666666, 0x3f2e76be,
    0x0, 0x0, 0xbf666666, 0x3f2de88d,
    0x0, 0x0, 0xbf666666, 0x3f2d5ab0,
    0x0, 0x0, 0xbf666666, 0x3f2ccd27,
    0x0, 0x0, 0xbf666666, 0x3f2c3ff1,
    0x0, 0x0, 0xbf666666, 0x3f2bb30e,
    0x0, 0x0, 0xbf666666, 0x3f2b267e,
    0x0, 0x0, 0xbf666666, 0x3f2a9a3f,
    0x0, 0x0, 0xbf666666, 0x3f2a0e52,
    0x0, 0x0, 0xbf666666, 0x3f2982b6,
    0x0, 0x0, 0xbf666666, 0x3f28f76a,
    0x0, 0x0, 0xbf666666, 0x3f286c6f,
    0x0, 0x0, 0xbf666666, 0x3f27e1c3,
    0x0, 0x0, 0xbf666666, 0x3f275766,
    0x0, 0x0, 0xbf666666, 0x3f26cd59,
    0x0, 0x0, 0xbf666666, 0x3f264399,
    0x0, 0x0, 0xbf666666, 0x3f25ba28,
    0x0, 0x0, 0xbf666666, 0x3f253104,
    0x0, 0x0, 0xbf666666, 0x3f24a82e,
    0x0, 0x0, 0xbf666666, 0x3f241fa4,
    0x0, 0x0, 0xbf666666, 0x3f239766,
    0x0, 0x0, 0xbf666666, 0x3f230f75,
    0x0, 0x0, 0xbf666666, 0x3f2287cf,
    0x0, 0x0, 0xbf666666, 0x3f220074,
    0x0, 0x0, 0xbf666666, 0x3f217963,
    0x0, 0x0, 0xbf666666, 0x3f20f29d,
    0x0, 0x0, 0xbf666666, 0x3f206c21,
    0x0, 0x0, 0xbf666666, 0x3f1fe5ee,
    0x0, 0x0, 0xbf666666, 0x3f1f6004,
    0x0, 0x0, 0xbf666666, 0x3f1eda63,
    0x0, 0x0, 0xbf666666, 0x3f1e550a,
    0x0, 0x0, 0xbf666666, 0x3f1dcff9,
    0x0, 0x0, 0xbf666666, 0x3f1d4b30,
    0x0, 0x0, 0xbf666666, 0x3f1cc6ae,
    0x0, 0x0, 0xbf666666, 0x3f1c4272,
    0x0, 0x0, 0xbf666666, 0x3f1bbe7d,
    0x0, 0x0, 0xbf666666, 0x3f1b3ace,
    0x0, 0x0, 0xbf666666, 0x3f1ab764,
    0x0, 0x0, 0xbf666666, 0x3f1a3440,
    0x0, 0x0, 0xbf666666, 0x3f19b160,
    0x0, 0x0, 0xbf666666, 0x3f192ec5,
    0x0, 0x0, 0xbf666666, 0x3f18ac6f,
    0x0, 0x0, 0xbf666666, 0x3f182a5c,
    0x0, 0x0, 0xbf666666, 0x3f17a88c,
    0x0, 0x0, 0xbf666666, 0x3f1726ff,
    0x0, 0x0, 0xbf666666, 0x3f16a5b5,
    0x0, 0x0, 0xbf666666, 0x3f1624ae,
    0x0, 0x0, 0xbf666666, 0x3f15a3e8,
    0x0, 0x0, 0xbf666666, 0x3f152364,
    0x0, 0x0, 0xbf666666, 0x3f14a321,
    0x0, 0x0, 0xbf666666, 0x3f14231f,
    0x0, 0x0, 0xbf666666, 0x3f13a35e,
    0x0, 0x0, 0xbf666666, 0x3f1323dd,
    0x0, 0x0, 0xbf666666, 0x3f12a49c,
    0x0, 0x0, 0xbf666666, 0x3f12259a,
    0x0, 0x0, 0xbf666666, 0x3f11a6d8,
    0x0, 0x0, 0xbf666666, 0x3f112855,
    0x0, 0x0, 0xbf666666, 0x3f10aa10,
    0x0, 0x0, 0xbf666666, 0x3f102c09,
    0x0, 0x0, 0xbf666666, 0x3f0fae40,
    0x0, 0x0, 0xbf666666, 0x3f0f30b5,
    0x0, 0x0, 0xbf666666, 0x3f0eb367,
    0x0, 0x0, 0xbf666666, 0x3f0e3655,
    0x0, 0x0, 0xbf666666, 0x3f0db981,
    0x0, 0x0, 0xbf666666, 0x3f0d3ce8,
    0x0, 0x0, 0xbf666666, 0x3f0cc08c,
    0x0, 0x0, 0xbf666666, 0x3f0c446b,
    0x0, 0x0, 0xbf666666, 0x3f0bc886,
    0x0, 0x0, 0xbf666666, 0x3f0b4cdb,
    0x0, 0x0, 0xbf666666, 0x3f0ad16b,
    0x0, 0x0, 0xbf666666, 0x3f0a5636,
    0x0, 0x0, 0xbf666666, 0x3f09db3a,
    0x0, 0x0, 0xbf666666, 0x3f096078,
    0x0, 0x0, 0xbf666666, 0x3f08e5f0,
    0x0, 0x0, 0xbf666666, 0x3f086ba1,
    0x0, 0x0, 0xbf666666, 0x3f07f18b,
    0x0, 0x0, 0xbf666666, 0x3f0777ad,
    0x0, 0x0, 0xbf666666, 0x3f06fe07,
    0x0, 0x0, 0xbf666666, 0x3f068499,
    0x0, 0x0, 0xbf666666, 0x3f060b63,
    0x0, 0x0, 0xbf666666, 0x3f059265,
    0x0, 0x0, 0xbf666666, 0x3f05199d,
    0x0, 0x0, 0xbf666666, 0x3f04a10c,
    0x0, 0x0, 0xbf666666, 0x3f0428b2,
    0x0, 0x0, 0xbf666666, 0x3f03b08d,
    0x0, 0x0, 0xbf666666, 0x3f03389f,
    0x0, 0x0, 0xbf666666, 0x3f02c0e6,
    0x0, 0x0, 0xbf666666, 0x3f024963,
    0x0, 0x0, 0xbf666666, 0x3f01d214,
    0x0, 0x0, 0xbf666666, 0x3f015afb,
    0x0, 0x0, 0xbf666666, 0x3f00e415,
    0x0, 0x0, 0xbf666666, 0x3f006d64,
    0x0, 0x0, 0xbf666666, 0x3effedcf,
    0x0, 0x0, 0xbf666666, 0x3eff013c,
    0x0, 0x0, 0xbf666666, 0x3efe1510,
    0x0, 0x0, 0xbf666666, 0x3efd294a,
    0x0, 0x0, 0xbf666666, 0x3efc3de9,
    0x0, 0x0, 0xbf666666, 0x3efb52ee,
    0x0, 0x0, 0xbf666666, 0x3efa6857,
    0x0, 0x0, 0xbf666666, 0x3ef97e25,
    0x0, 0x0, 0xbf666666, 0x3ef89456,
    0x0, 0x0, 0xbf666666, 0x3ef7aaea,
    0x0, 0x0, 0xbf666666, 0x3ef6c1e0,
    0x0, 0x0, 0xbf666666, 0x3ef5d938,
    0x0, 0x0, 0xbf666666, 0x3ef4f0f2,
    0x0, 0x0, 0xbf666666, 0x3ef4090c,
    0x0, 0x0, 0xbf666666, 0x3ef32187,
    0x0, 0x0, 0xbf666666, 0x3ef23a62,
    0x0, 0x0, 0xbf666666, 0x3ef1539c,
    0x0, 0x0, 0xbf666666, 0x3ef06d35,
    0x0, 0x0, 0xbf666666, 0x3eef872d,
    0x0, 0x0, 0xbf666666, 0x3eeea182,
    0x0, 0x0, 0xbf666666, 0x3eedbc34,
    0x0, 0x0, 0xbf666666, 0x3eecd744,
    0x0, 0x0, 0xbf666666, 0x3eebf2af,
    0x0, 0x0, 0xbf666666, 0x3eeb0e77,
    0x0, 0x0, 0xbf666666, 0x3eea2a9a,
    0x0, 0x0, 0xbf666666, 0x3ee94718,
    0x0, 0x0, 0xbf666666, 0x3ee863f0,
    0x0, 0x0, 0xbf666666, 0x3ee78122,
    0x0, 0x0, 0xbf666666, 0x3ee69ead,
    0x0, 0x0, 0xbf666666, 0x3ee5bc92,
    0x0, 0x0, 0xbf666666, 0x3ee4dacf,
    0x0, 0x0, 0xbf666666, 0x3ee3f964,
    0x0, 0x0, 0xbf666666, 0x3ee31850,
    0x0, 0x0, 0xbf666666, 0x3ee23793,
    0x0, 0x0, 0xbf666666, 0x3ee1572e,
    0x0, 0x0, 0xbf666666, 0x3ee0771e,
    0x0, 0x0, 0xbf666666, 0x3edf9764,
    0x0, 0x0, 0xbf666666, 0x3edeb7ff,
    0x0, 0x0, 0xbf666666, 0x3eddd8ee,
    0x0, 0x0, 0xbf666666, 0x3edcfa33,
    0x0, 0x0, 0xbf666666, 0x3edc1bca,
    0x0, 0x0, 0xbf666666, 0x3edb3db6,
    0x0, 0x0, 0xbf666666, 0x3eda5ff4,
    0x0, 0x0, 0xbf666666, 0x3ed98285,
    0x0, 0x0, 0xbf666666, 0x3ed8a567,
    0x0, 0x0, 0xbf666666, 0x3ed7c89c,
    0x0, 0x0, 0xbf666666, 0x3ed6ec21,
    0x0, 0x0, 0xbf666666, 0x3ed60ff7,
    0x0, 0x0, 0xbf666666, 0x3ed5341e,
    0x0, 0x0, 0xbf666666, 0x3ed45894,
    0x0, 0x0, 0xbf666666, 0x3ed37d5a,
    0x0, 0x0, 0xbf666666, 0x3ed2a26e,
    0x0, 0x0, 0xbf666666, 0x3ed1c7d1,
    0x0, 0x0, 0xbf666666, 0x3ed0ed83,
    0x0, 0x0, 0xbf666666, 0x3ed01382,
    0x0, 0x0, 0xbf666666, 0x3ecf39ce,
    0x0, 0x0, 0xbf666666, 0x3ece6067,
    0x0, 0x0, 0xbf666666, 0x3ecd874c,
    0x0, 0x0, 0xbf666666, 0x3eccae7e,
    0x0, 0x0, 0xbf666666, 0x3ecbd5fb,
    0x0, 0x0, 0xbf666666, 0x3ecafdc3,
    0x0, 0x0, 0xbf666666, 0x3eca25d6,
    0x0, 0x0, 0xbf666666, 0x3ec94e34,
    0x0, 0x0, 0xbf666666, 0x3ec876db,
    0x0, 0x0, 0xbf666666, 0x3ec79fcc,
    0x0, 0x0, 0xbf666666, 0x3ec6c906,
    0x0, 0x0, 0xbf666666, 0x3ec5f288,
    0x0, 0x0, 0xbf666666, 0x3ec51c53,
    0x0, 0x0, 0xbf666666, 0x3ec44666,
    0x0, 0x0, 0xbf666666, 0x3ec370c1,
    0x0, 0x0, 0xbf666666, 0x3ec29b62,
    0x0, 0x0, 0xbf666666, 0x3ec1c64a,
    0x0, 0x0, 0xbf666666, 0x3ec0f179,
    0x0, 0x0, 0xbf666666, 0x3ec01cee,
    0x0, 0x0, 0xbf666666, 0x3ebf48a8,
    0x0, 0x0, 0xbf666666, 0x3ebe74a7,
    0x0, 0x0, 0xbf666666, 0x3ebda0eb,
    0x0, 0x0, 0xbf666666, 0x3ebccd73,
    0x0, 0x0, 0xbf666666, 0x3ebbfa40,
    0x0, 0x0, 0xbf666666, 0x3ebb2750,
    0x0, 0x0, 0xbf666666, 0x3eba54a3,
    0x0, 0x0, 0xbf666666, 0x3eb98239,
    0x0, 0x0, 0xbf666666, 0x3eb8b012,
    0x0, 0x0, 0xbf666666, 0x3eb7de2d,
    0x0, 0x0, 0xbf666666, 0x3eb70c89,
    0x0, 0x0, 0xbf666666, 0x3eb63b27,
    0x0, 0x0, 0xbf666666, 0x3eb56a06,
    0x0, 0x0, 0xbf666666, 0x3eb49926,
    0x0, 0x0, 0xbf666666, 0x3eb3c885,
    0x0, 0x0, 0xbf666666, 0x3eb2f825,
    0x0, 0x0, 0xbf666666, 0x3eb22804,
    0x0, 0x0, 0xbf666666, 0x3eb15822,
    0x0, 0x0, 0xbf666666, 0x3eb08880,
    0x0, 0x0, 0xbf666666, 0x3eafb91b,
    0x0, 0x0, 0xbf666666, 0x3eaee9f5,
    0x0, 0x0, 0xbf666666, 0x3eae1b0c,
    0x0, 0x0, 0xbf666666, 0x3ead4c61,
    0x0, 0x0, 0xbf666666, 0x3eac7df3,
    0x0, 0x0, 0xbf666666, 0x3eabafc1,
    0x0, 0x0, 0xbf666666, 0x3eaae1cc,
    0x0, 0x0, 0xbf666666, 0x3eaa1412,
    0x0, 0x0, 0xbf666666, 0x3ea94695,
    0x0, 0x0, 0xbf666666, 0x3ea87952,
    0x0, 0x0, 0xbf666666, 0x3ea7ac4b,
    0x0, 0x0, 0xbf666666, 0x3ea6df7e,
    0x0, 0x0, 0xbf666666, 0x3ea612eb,
    0x0, 0x0, 0xbf666666, 0x3ea54692,
    0x0, 0x0, 0xbf666666, 0x3ea47a72,
    0x0, 0x0, 0xbf666666, 0x3ea3ae8c,
    0x0, 0x0, 0xbf666666, 0x3ea2e2df,
    0x0, 0x0, 0xbf666666, 0x3ea2176a,
    0x0, 0x0, 0xbf666666, 0x3ea14c2d,
    0x0, 0x0, 0xbf666666, 0x3ea08129,
    0x0, 0x0, 0xbf666666, 0x3e9fb65b,
    0x0, 0x0, 0xbf666666, 0x3e9eebc5,
    0x0, 0x0, 0xbf666666, 0x3e9e2166,
    0x0, 0x0, 0xbf666666, 0x3e9d573d,
    0x0, 0x0, 0xbf666666, 0x3e9c8d4b,
    0x0, 0x0, 0xbf666666, 0x3e9bc38e,
    0x0, 0x0, 0xbf666666, 0x3e9afa07,
    0x0, 0x0, 0xbf666666, 0x3e9a30b5,
    0x0, 0x0, 0xbf666666, 0x3e996798,
    0x0, 0x0, 0xbf666666, 0x3e989eaf,
    0x0, 0x0, 0xbf666666, 0x3e97d5fb,
    0x0, 0x0, 0xbf666666, 0x3e970d7a,
    0x0, 0x0, 0xbf666666, 0x3e96452d,
    0x0, 0x0, 0xbf666666, 0x3e957d14,
    0x0, 0x0, 0xbf666666, 0x3e94b52d,
    0x0, 0x0, 0xbf666666, 0x3e93ed79,
    0x0, 0x0, 0xbf666666, 0x3e9325f8,
    0x0, 0x0, 0xbf666666, 0x3e925ea8,
    0x0, 0x0, 0xbf666666, 0x3e91978a,
    0x0, 0x0, 0xbf666666, 0x3e90d09e,
    0x0, 0x0, 0xbf666666, 0x3e9009e2,
    0x0, 0x0, 0xbf666666, 0x3e8f4358,
    0x0, 0x0, 0xbf666666, 0x3e8e7cfe,
    0x0, 0x0, 0xbf666666, 0x3e8db6d4,
    0x0, 0x0, 0xbf666666, 0x3e8cf0d9,
    0x0, 0x0, 0xbf666666, 0x3e8c2b0f,
    0x0, 0x0, 0xbf666666, 0x3e8b6573,
    0x0, 0x0, 0xbf666666, 0x3e8aa007,
    0x0, 0x0, 0xbf666666, 0x3e89dac9,
    0x0, 0x0, 0xbf666666, 0x3e8915b9,
    0x0, 0x0, 0xbf666666, 0x3e8850d8,
    0x0, 0x0, 0xbf666666, 0x3e878c24,
    0x0, 0x0, 0xbf666666, 0x3e86c79e,
    0x0, 0x0, 0xbf666666, 0x3e860344,
    0x0, 0x0, 0xbf666666, 0x3e853f18,
    0x0, 0x0, 0xbf666666, 0x3e847b18,
    0x0, 0x0, 0xbf666666, 0x3e83b744,
    0x0, 0x0, 0xbf666666, 0x3e82f39d,
    0x0, 0x0, 0xbf666666, 0x3e823020,
    0x0, 0x0, 0xbf666666, 0x3e816cd0,
    0x0, 0x0, 0xbf666666, 0x3e80a9aa,
    0x0, 0x0, 0xbf666666, 0x3e7fcd5e,
    0x0, 0x0, 0xbf666666, 0x3e7e47be,
    0x0, 0x0, 0xbf666666, 0x3e7cc271,
    0x0, 0x0, 0xbf666666, 0x3e7b3d79,
    0x0, 0x0, 0xbf666666, 0x3e79b8d3,
    0x0, 0x0, 0xbf666666, 0x3e783481,
    0x0, 0x0, 0xbf666666, 0x3e76b080,
    0x0, 0x0, 0xbf666666, 0x3e752cd1,
    0x0, 0x0, 0xbf666666, 0x3e73a973,
    0x0, 0x0, 0xbf666666, 0x3e722666,
    0x0, 0x0, 0xbf666666, 0x3e70a3a8,
    0x0, 0x0, 0xbf666666, 0x3e6f2139,
    0x0, 0x0, 0xbf666666, 0x3e6d9f1a,
    0x0, 0x0, 0xbf666666, 0x3e6c1d48,
    0x0, 0x0, 0xbf666666, 0x3e6a9bc4,
    0x0, 0x0, 0xbf666666, 0x3e691a8d,
    0x0, 0x0, 0xbf666666, 0x3e6799a3,
    0x0, 0x0, 0xbf666666, 0x3e661904,
    0x0, 0x0, 0xbf666666, 0x3e6498b1,
    0x0, 0x0, 0xbf666666, 0x3e6318a9,
    0x0, 0x0, 0xbf666666, 0x3e6198eb,
    0x0, 0x0, 0xbf666666, 0x3e601976,
    0x0, 0x0, 0xbf666666, 0x3e5e9a4b,
    0x0, 0x0, 0xbf666666, 0x3e5d1b69,
    0x0, 0x0, 0xbf666666, 0x3e5b9ccf,
    0x0, 0x0, 0xbf666666, 0x3e5a1e7c,
    0x0, 0x0, 0xbf666666, 0x3e58a070,
    0x0, 0x0, 0xbf666666, 0x3e5722ab,
    0x0, 0x0, 0xbf666666, 0x3e55a52c,
    0x0, 0x0, 0xbf666666, 0x3e5427f2,
    0x0, 0x0, 0xbf666666, 0x3e52aafe,
    0x0, 0x0, 0xbf666666, 0x3e512e4d,
    0x0, 0x0, 0xbf666666, 0x3e4fb1e0,
    0x0, 0x0, 0xbf666666, 0x3e4e35b7,
    0x0, 0x0, 0xbf666666, 0x3e4cb9d1,
    0x0, 0x0, 0xbf666666, 0x3e4b3e2c,
    0x0, 0x0, 0xbf666666, 0x3e49c2ca,
    0x0, 0x0, 0xbf666666, 0x3e4847a9,
    0x0, 0x0, 0xbf666666, 0x3e46ccc8,
    0x0, 0x0, 0xbf666666, 0x3e455227,
    0x0, 0x0, 0xbf666666, 0x3e43d7c7,
    0x0, 0x0, 0xbf666666, 0x3e425da5,
    0x0, 0x0, 0xbf666666, 0x3e40e3c2,
    0x0, 0x0, 0xbf666666, 0x3e3f6a1d,
    0x0, 0x0, 0xbf666666, 0x3e3df0b6,
    0x0, 0x0, 0xbf666666, 0x3e3c778b,
    0x0, 0x0, 0xbf666666, 0x3e3afe9d,
    0x0, 0x0, 0xbf666666, 0x3e3985ec,
    0x0, 0x0, 0xbf666666, 0x3e380d76,
    0x0, 0x0, 0xbf666666, 0x3e36953a,
    0x0, 0x0, 0xbf666666, 0x3e351d3a,
    0x0, 0x0, 0xbf666666, 0x3e33a573,
    0x0, 0x0, 0xbf666666, 0x3e322de6,
    0x0, 0x0, 0xbf666666, 0x3e30b692,
    0x0, 0x0, 0xbf666666, 0x3e2f3f77,
    0x0, 0x0, 0xbf666666, 0x3e2dc893,
    0x0, 0x0, 0xbf666666, 0x3e2c51e7,
    0x0, 0x0, 0xbf666666, 0x3e2adb72,
    0x0, 0x0, 0xbf666666, 0x3e296533,
    0x0, 0x0, 0xbf666666, 0x3e27ef2b,
    0x0, 0x0, 0xbf666666, 0x3e267958,
    0x0, 0x0, 0xbf666666, 0x3e2503ba,
    0x0, 0x0, 0xbf666666, 0x3e238e50,
    0x0, 0x0, 0xbf666666, 0x3e22191b,
    0x0, 0x0, 0xbf666666, 0x3e20a419,
    0x0, 0x0, 0xbf666666, 0x3e1f2f4a,
    0x0, 0x0, 0xbf666666, 0x3e1dbaae,
    0x0, 0x0, 0xbf666666, 0x3e1c4644,
    0x0, 0x0, 0xbf666666, 0x3e1ad20b,
    0x0, 0x0, 0xbf666666, 0x3e195e04,
    0x0, 0x0, 0xbf666666, 0x3e17ea2d,
    0x0, 0x0, 0xbf666666, 0x3e167686,
    0x0, 0x0, 0xbf666666, 0x3e15030f,
    0x0, 0x0, 0xbf666666, 0x3e138fc7,
    0x0, 0x0, 0xbf666666, 0x3e121cad,
    0x0, 0x0, 0xbf666666, 0x3e10a9c2,
    0x0, 0x0, 0xbf666666, 0x3e0f3705,
    0x0, 0x0, 0xbf666666, 0x3e0dc475,
    0x0, 0x0, 0xbf666666, 0x3e0c5211,
    0x0, 0x0, 0xbf666666, 0x3e0adfda,
    0x0, 0x0, 0xbf666666, 0x3e096dcf,
    0x0, 0x0, 0xbf666666, 0x3e07fbef,
    0x0, 0x0, 0xbf666666, 0x3e068a3a,
    0x0, 0x0, 0xbf666666, 0x3e0518af,
    0x0, 0x0, 0xbf666666, 0x3e03a74e,
    0x0, 0x0, 0xbf666666, 0x3e023617,
    0x0, 0x0, 0xbf666666, 0x3e00c509,
    0x0, 0x0, 0xbf666666, 0x3dfea845,
    0x0, 0x0, 0xbf666666, 0x3dfbc6c9,
    0x0, 0x0, 0xbf666666, 0x3df8e59d,
    0x0, 0x0, 0xbf666666, 0x3df604be,
    0x0, 0x0, 0xbf666666, 0x3df3242d,
    0x0, 0x0, 0xbf666666, 0x3df043e8,
    0x0, 0x0, 0xbf666666, 0x3ded63ee,
    0x0, 0x0, 0xbf666666, 0x3dea843f,
    0x0, 0x0, 0xbf666666, 0x3de7a4d9,
    0x0, 0x0, 0xbf666666, 0x3de4c5bc,
    0x0, 0x0, 0xbf666666, 0x3de1e6e6,
    0x0, 0x0, 0xbf666666, 0x3ddf0857,
    0x0, 0x0, 0xbf666666, 0x3ddc2a0e,
    0x0, 0x0, 0xbf666666, 0x3dd94c0a,
    0x0, 0x0, 0xbf666666, 0x3dd66e4a,
    0x0, 0x0, 0xbf666666, 0x3dd390cd,
    0x0, 0x0, 0xbf666666, 0x3dd0b392,
    0x0, 0x0, 0xbf666666, 0x3dcdd698,
    0x0, 0x0, 0xbf666666, 0x3dcaf9de,
    0x0, 0x0, 0xbf666666, 0x3dc81d64,
    0x0, 0x0, 0xbf666666, 0x3dc54128,
    0x0, 0x0, 0xbf666666, 0x3dc2652a,
    0x0, 0x0, 0xbf666666, 0x3dbf8969,
    0x0, 0x0, 0xbf666666, 0x3dbcade3,
    0x0, 0x0, 0xbf666666, 0x3db9d298,
    0x0, 0x0, 0xbf666666, 0x3db6f786,
    0x0, 0x0, 0xbf666666, 0x3db41cae,
    0x0, 0x0, 0xbf666666, 0x3db1420e,
    0x0, 0x0, 0xbf666666, 0x3dae67a5,
    0x0, 0x0, 0xbf666666, 0x3dab8d72,
    0x0, 0x0, 0xbf666666, 0x3da8b375,
    0x0, 0x0, 0xbf666666, 0x3da5d9ac,
    0x0, 0x0, 0xbf666666, 0x3da30017,
    0x0, 0x0, 0xbf666666, 0x3da026b4,
    0x0, 0x0, 0xbf666666, 0x3d9d4d83,
    0x0, 0x0, 0xbf666666, 0x3d9a7483,
    0x0, 0x0, 0xbf666666, 0x3d979bb3,
    0x0, 0x0, 0xbf666666, 0x3d94c313,
    0x0, 0x0, 0xbf666666, 0x3d91eaa0,
    0x0, 0x0, 0xbf666666, 0x3d8f125a,
    0x0, 0x0, 0xbf666666, 0x3d8c3a41,
    0x0, 0x0, 0xbf666666, 0x3d896254,
    0x0, 0x0, 0xbf666666, 0x3d868a91,
    0x0, 0x0, 0xbf666666, 0x3d83b2f8,
    0x0, 0x0, 0xbf666666, 0x3d80db87,
    0x0, 0x0, 0xbf666666, 0x3d7c087d,
    0x0, 0x0, 0xbf666666, 0x3d765a3a,
    0x0, 0x0, 0xbf666666, 0x3d70ac44,
    0x0, 0x0, 0xbf666666, 0x3d6afe98,
    0x0, 0x0, 0xbf666666, 0x3d655135,
    0x0, 0x0, 0xbf666666, 0x3d5fa418,
    0x0, 0x0, 0xbf666666, 0x3d59f741,
    0x0, 0x0, 0xbf666666, 0x3d544aae,
    0x0, 0x0, 0xbf666666, 0x3d4e9e5c,
    0x0, 0x0, 0xbf666666, 0x3d48f24a,
    0x0, 0x0, 0xbf666666, 0x3d434676,
    0x0, 0x0, 0xbf666666, 0x3d3d9adf,
    0x0, 0x0, 0xbf666666, 0x3d37ef82,
    0x0, 0x0, 0xbf666666, 0x3d32445f,
    0x0, 0x0, 0xbf666666, 0x3d2c9972,
    0x0, 0x0, 0xbf666666, 0x3d26eeba,
    0x0, 0x0, 0xbf666666, 0x3d214437,
    0x0, 0x0, 0xbf666666, 0x3d1b99e5,
    0x0, 0x0, 0xbf666666, 0x3d15efc3,
    0x0, 0x0, 0xbf666666, 0x3d1045cf,
    0x0, 0x0, 0xbf666666, 0x3d0a9c08,
    0x0, 0x0, 0xbf666666, 0x3d04f26c,
    0x0, 0x0, 0xbf666666, 0x3cfe91f2,
    0x0, 0x0, 0xbf666666, 0x3cf33f5a,
    0x0, 0x0, 0xbf666666, 0x3ce7ed0e,
    0x0, 0x0, 0xbf666666, 0x3cdc9b09,
    0x0, 0x0, 0xbf666666, 0x3cd14948,
    0x0, 0x0, 0xbf666666, 0x3cc5f7c8,
    0x0, 0x0, 0xbf666666, 0x3cbaa685,
    0x0, 0x0, 0xbf666666, 0x3caf557b,
    0x0, 0x0, 0xbf666666, 0x3ca404a8,
    0x0, 0x0, 0xbf666666, 0x3c98b407,
    0x0, 0x0, 0xbf666666, 0x3c8d6395,
    0x0, 0x0, 0xbf666666, 0x3c82134f,
    0x0, 0x0, 0xbf666666, 0x3c6d8663,
    0x0, 0x0, 0xbf666666, 0x3c56e670,
    0x0, 0x0, 0xbf666666, 0x3c4046c0,
    0x0, 0x0, 0xbf666666, 0x3c29a74b,
    0x0, 0x0, 0xbf666666, 0x3c13080a,
    0x0, 0x0, 0xbf666666, 0x3bf8d1ee,
    0x0, 0x0, 0xbf666666, 0x3bcb9414,
    0x0, 0x0, 0xbf666666, 0x3b9e5679,
    0x0, 0x0, 0xbf666666, 0x3b62321f,
    0x0, 0x0, 0xbf666666, 0x3b07b790,
    0x0, 0x0, 0xbf666666, 0x3a34f4ad,
    0x0
    };

