static const uint64_t in_rfft_noisy_32[32] = {
    0xbfb7727caba4a4e2, 0x3fde42d807df6889,
    0x3fe657c04a4cad07, 0x3fdd019c822018ec,
    0xbfac3b3073488e80, 0xbfdf2b33554e47f6,
    0xbfe72853fd707711, 0xbfe0fd9dde8a95e8,
    0xbfa0cc15be30b476, 0x3fdedfdc08fe061d,
    0x3fe2d2eca96d84b4, 0x3fde485b3925d608,
    0xbf8f221bf61eca51, 0xbfe2d8fb7e6754d9,
    0xbfe38660bf43c549, 0xbfe0c6b92cd23b3b,
    0xbfb306f202efa7e5, 0x3fe1b30b0bcd973d,
    0x3fe4ce3920fa45d0, 0x3fdf271d28240f4c,
    0x3fa43e6523ebbac6, 0xbfde9f48b2c03aac,
    0xbfe4df565ec71471, 0xbfe0edb107dd04b5,
    0xbf7d12cd2e975cae, 0x3fe0d8c627735bbc,
    0x3fe73415587f4cd1, 0x3fdec781ebe7721d,
    0xbf641386411e31b8, 0xbfdf941ec561b8e6,
    0xbfe79b20de7447c0, 0xbfe1eaff635413f6
    };

static const uint64_t in_rifft_noisy_32[33] = {
    0xbfe20e87bc32f84a, 0xbfa36d44b89046e8,
    0xbfc6c7673fc0df29, 0x3fd76c70a6eea913,
    0xbfc1ae3eec2aed5f, 0xbfbe241878f594fa,
    0xbfc73705af2ed48c, 0xbfb3475e00775846,
    0xbfc210c649ec0dbc, 0xc026417b075c8541,
    0x3fa5119061e1e5e0, 0xbfcc33b3c41c2bf9,
    0xbfaacb87d462ae78, 0xbf5af789c544145c,
    0xbfc01b210fbd8488, 0xbfa47718d1031710,
    0xbfc6a933a9995812, 0xbfce567995d5a538,
    0x3fb27d8fbb415eb9, 0xbfb64b0fe40d2d34,
    0xbfd27e51738cee03, 0x3f709e1469d83627,
    0x3fcc69282eb96290, 0x3fd74bbbc7acd810,
    0xbfca1c9abe2eda5c, 0xbfd6d6c34f0334a0,
    0x3fb4b6ffd5287379, 0x3fd3b643684dbdb0,
    0xbf993551863c2408, 0xbfba9470e6c97d5a,
    0xbfb1b8e1671b01ae, 0xbfb67a9c46858a08,
    0x0
    };

static const uint64_t ref_rfft_noisy_32[33] = {
    0xbfe20e87bc32f84a, 0xbfa36d44b89046e8,
    0xbfc6c7673fc0df29, 0x3fd76c70a6eea913,
    0xbfc1ae3eec2aed5f, 0xbfbe241878f594fa,
    0xbfc73705af2ed48c, 0xbfb3475e00775846,
    0xbfc210c649ec0dbc, 0xc026417b075c8541,
    0x3fa5119061e1e5e0, 0xbfcc33b3c41c2bf9,
    0xbfaacb87d462ae78, 0xbf5af789c544145c,
    0xbfc01b210fbd8488, 0xbfa47718d1031710,
    0xbfc6a933a9995812, 0xbfce567995d5a538,
    0x3fb27d8fbb415eb9, 0xbfb64b0fe40d2d34,
    0xbfd27e51738cee03, 0x3f709e1469d83627,
    0x3fcc69282eb96290, 0x3fd74bbbc7acd810,
    0xbfca1c9abe2eda5c, 0xbfd6d6c34f0334a0,
    0x3fb4b6ffd5287379, 0x3fd3b643684dbdb0,
    0xbf993551863c2408, 0xbfba9470e6c97d5a,
    0xbfb1b8e1671b01ae, 0xbfb67a9c46858a08,
    0x0
    };

static const uint64_t in_rfft_noisy_64[64] = {
    0xbfa8ba72755e557c, 0x3fdee87baa40e59e,
    0x3fe71315059a5aa9, 0x3fdf4934a5b6a7c5,
    0xbfa2bf0fcdc4d8f5, 0xbfd9d3bcdff218b1,
    0xbfe525581eaf3527, 0xbfe22d5f0ca19349,
    0xbf61c8e7d342963b, 0x3fe1c1f7d4bd7c6a,
    0x3fe82f2816794859, 0x3fdd22540ed274aa,
    0x3f68d5c09b189382, 0xbfdd78ee59d59b2e,
    0xbfe924f5e4a7bb78, 0xbfdd24a761f26335,
    0xbfa42b238ae1eeb4, 0x3fe17d4801eb7a23,
    0x3fe7d0a452c91a59, 0x3fe0b26856663651,
    0x3fa72730062eeb26, 0xbfe074abb87f2852,
    0xbfe560657c274525, 0xbfe204b9a73dd4c2,
    0xbf8b2ebfdcd8f2ab, 0x3fdff8f9e776fc0f,
    0x3fe3183ae974aa02, 0x3fe3be8e835ab680,
    0x3fa9971f6c8c1510, 0xbfdeebeea2a465e6,
    0xbfe62f16d988ece5, 0xbfd9a11107421454,
    0x3f695b44b19ca54f, 0x3fdbd1720c896a74,
    0x3fe57f32d73f0dff, 0x3fdc41f98489c45e,
    0x3f7f7b902963b93c, 0xbfdef3fc9c85852b,
    0xbfe45bf8c87dabfa, 0xbfe12b4326211ae6,
    0x3fa2e7e1c0f30827, 0x3fe2353321e2cfa7,
    0x3fe70a906b646d7b, 0x3fda81ae298a945a,
    0xbf5ac6edcf3fb3bb, 0xbfe142ae190fc689,
    0xbfe641bba87dd9e0, 0xbfd9c8b8357eb704,
    0x3f7b4eb98e8159e0, 0x3fde6b37f7f85bd4,
    0x3fe82b039c7062bb, 0x3fe19df8f4223c57,
    0xbf90fa9b0a8636db, 0xbfdeb90c70e30198,
    0xbfe7965956717c2e, 0xbfe04132c9dd08a6,
    0xbfadf45074aaa972, 0x3fdcd304a008fc3a,
    0x3fe57f24e3129b91, 0x3fde4123be8c64dd,
    0xbf91b3085459ba48, 0xbfe00711a80c9ab5,
    0xbfe38001cd7c80ac, 0xbfe09df39b2d24d1
    };

static const uint64_t in_rifft_noisy_64[65] = {
    0x3fccde69c1a5998e, 0xbfb635a3d0659ba4,
    0xbfc6bb80e4fb2c4e, 0xbfc0152a8abea29e,
    0xbfc06f281f601d1f, 0xbfc6342442da1f00,
    0x3f9513eae68e4100, 0xbfd2771fdf771142,
    0x3fcd0162253a93fb, 0xbfae672a7b9db87a,
    0x3fba36fb94a4ced7, 0xbfb9e933c90e3fc8,
    0xbfc8cc63dd5a135e, 0x3febdf7bd815ddac,
    0x3fb7d4a15e7a8db1, 0xbfd5e265431774f8,
    0xbfc65c946556783c, 0xc0364a6fa5752cfc,
    0xbfd265667fbcb452, 0x3fc287706e88bc00,
    0xbfc85a0bc5c0508b, 0x3fb794ca00997110,
    0x3fad8f27a8008d6e, 0x3fbc829dddf12d5b,
    0x3fb13c567e9b8966, 0x3fd66f80d7610186,
    0xbfd6bda7f8db3a86, 0xbfc001e3333b767d,
    0x3fdd0bb9f1ae7fb2, 0xbfc19a3570a2c360,
    0xbfc6bc48dd178a3f, 0xbfc357ad3a6f31b6,
    0xbfcda7a577807822, 0xbfc1e1a3544dbff0,
    0xbfe249afe4163f20, 0xbfd6d3328b2c76a1,
    0xbfe25706bd357fd9, 0x3fc1dc8565fd0ed2,
    0x3fa2d15df8b4ed4c, 0xbfcef97adf86b791,
    0xbfcf172a0ad11549, 0x3fe7d16b06a181e3,
    0x3fa194900a666346, 0xbfc8d0c15be2b0d8,
    0xbfa2767f22cf95ec, 0xbfd59c479523e0b5,
    0x3fcc195ece678aaf, 0x3fc65f2c197d13f4,
    0xbfbf709376b596f1, 0xbfa74309dd492800,
    0x3f9f3966fed7d28c, 0x3fc1601a0ea5d7e8,
    0x3fdc719afebd52f9, 0xbfce3cb34b965c52,
    0xbfc9d7b18fc5bc10, 0xbfe3ff505ba9c00b,
    0xbfcb79c0b4eb8aad, 0x3fc93264a79940c8,
    0x3fd7c36c44c35b59, 0xbfcc412dde1a730b,
    0x3fbf9b89f98e6267, 0x3fd1d0c7b8d5f1f3,
    0xbf9189c53b86e030, 0xbfcbcf63a32cd2b8,
    0x0
    };

static const uint64_t ref_rfft_noisy_64[65] = {
    0x3fccde69c1a5998e, 0xbfb635a3d0659ba4,
    0xbfc6bb80e4fb2c4e, 0xbfc0152a8abea29e,
    0xbfc06f281f601d1f, 0xbfc6342442da1f00,
    0x3f9513eae68e4100, 0xbfd2771fdf771142,
    0x3fcd0162253a93fb, 0xbfae672a7b9db87a,
    0x3fba36fb94a4ced7, 0xbfb9e933c90e3fc8,
    0xbfc8cc63dd5a135e, 0x3febdf7bd815ddac,
    0x3fb7d4a15e7a8db1, 0xbfd5e265431774f8,
    0xbfc65c946556783c, 0xc0364a6fa5752cfc,
    0xbfd265667fbcb452, 0x3fc287706e88bc00,
    0xbfc85a0bc5c0508b, 0x3fb794ca00997110,
    0x3fad8f27a8008d6e, 0x3fbc829dddf12d5b,
    0x3fb13c567e9b8966, 0x3fd66f80d7610186,
    0xbfd6bda7f8db3a86, 0xbfc001e3333b767d,
    0x3fdd0bb9f1ae7fb2, 0xbfc19a3570a2c360,
    0xbfc6bc48dd178a3f, 0xbfc357ad3a6f31b6,
    0xbfcda7a577807822, 0xbfc1e1a3544dbff0,
    0xbfe249afe4163f20, 0xbfd6d3328b2c76a1,
    0xbfe25706bd357fd9, 0x3fc1dc8565fd0ed2,
    0x3fa2d15df8b4ed4c, 0xbfcef97adf86b791,
    0xbfcf172a0ad11549, 0x3fe7d16b06a181e3,
    0x3fa194900a666346, 0xbfc8d0c15be2b0d8,
    0xbfa2767f22cf95ec, 0xbfd59c479523e0b5,
    0x3fcc195ece678aaf, 0x3fc65f2c197d13f4,
    0xbfbf709376b596f1, 0xbfa74309dd492800,
    0x3f9f3966fed7d28c, 0x3fc1601a0ea5d7e8,
    0x3fdc719afebd52f9, 0xbfce3cb34b965c52,
    0xbfc9d7b18fc5bc10, 0xbfe3ff505ba9c00b,
    0xbfcb79c0b4eb8aad, 0x3fc93264a79940c8,
    0x3fd7c36c44c35b59, 0xbfcc412dde1a730b,
    0x3fbf9b89f98e6267, 0x3fd1d0c7b8d5f1f3,
    0xbf9189c53b86e030, 0xbfcbcf63a32cd2b8,
    0x0
    };

static const uint64_t in_rfft_noisy_128[128] = {
    0xbfb7a6d1e151be34, 0x3fdd7e20bcba99f8,
    0x3fe56e83948e3796, 0x3fdf8f73d6ec562b,
    0x3f8a3a468293e7b1, 0xbfe168955bd5b74c,
    0xbfe752f7871cd1fb, 0xbfe0b8671545bcf1,
    0xbf865081f5e61cac, 0x3fe0bad7dbe6b151,
    0x3fe417ed6410785e, 0x3fe097108d806fb0,
    0xbf9ea6d0f714614d, 0xbfdc5059072560c7,
    0xbfe57bcdf2d61259, 0xbfe1aa10e7a0e37b,
    0xbf96082f251e2f9e, 0x3fe19d2c7400da94,
    0x3fe6ac925eae8823, 0x3fdc97d40d4cdd48,
    0x3fb0d16c1645c890, 0xbfdb88ff9b043bc9,
    0xbfe72491664c67b6, 0xbfe0b577e42f393f,
    0x3f85dcf2e5054c51, 0x3fe077b26867bd1f,
    0x3fe66dfbc6b53701, 0x3fdd0c54efee10ad,
    0x3fa44d0832febdc7, 0xbfde7e27f3ee7224,
    0xbfe455dcad9eff5a, 0xbfdff345bfe68c99,
    0x3fb14502cb7a613c, 0x3fdb0ae9cb702a72,
    0x3fe5ed75f2cac982, 0x3fdbc79d28ad8d16,
    0xbf80dcbe055f559a, 0xbfdeae2c9837d06c,
    0xbfe2f79794571c5e, 0xbfdf8d79061697ce,
    0x3fa66fc4bd54b916, 0x3fe00980a637e4fe,
    0x3fe438c583b45ba1, 0x3fddf4fcbf2fe95c,
    0x3f7f3f15db386582, 0xbfe13d55cbbc849a,
    0xbfe4189e4e16315a, 0xbfdc801c9514b4d8,
    0xbfa04f01a7fe148b, 0x3fe18cc256c47c64,
    0x3fe6f5521e3fef7f, 0x3fe0ca6d2b9f107a,
    0xbf8be89f184436cb, 0xbfe1977555a4ef8c,
    0xbfe49f9fe4897b0e, 0xbfe04a38dc79a5a4,
    0x3fa28bd24a3037aa, 0x3fda23bf2b13c96c,
    0x3fe8113ed31d40a2, 0x3fdc1ed8c03246c2,
    0xbfa38cd9e859c2eb, 0xbfdaf500114cb352,
    0xbfe9396e13a7fd38, 0xbfe258439bb202ed,
    0xbfb398e4e2b48c2b, 0x3fe176074e05ba1a,
    0x3fe6d82e18a1b70c, 0x3fdd73b814534ad2,
    0x3f6b623d26c1a581, 0xbfdeaf5139392593,
    0xbfea1ed71fa794bb, 0xbfddc20609145e23,
    0xbf87c5672665d219, 0x3fddf33456250fe3,
    0x3fe54185e78a629c, 0x3fdf72193875994a,
    0xbf90bcbff0a5fe83, 0xbfddb3575e930143,
    0xbfe893add732ff5e, 0xbfe2b90423c7b1c8,
    0x3fb65833981832e0, 0x3fdc11dbad0e9c90,
    0x3fe9c5b0ea075a47, 0x3fde1ecca6a1afe2,
    0xbf9e7ca7d860c2e3, 0xbfe003b7d62d7450,
    0xbfe3d4860aa6502f, 0xbfe101b6a9c7fc37,
    0x3faa5c8262d04773, 0x3fe2092bb5689178,
    0x3fe80b8d52de64b7, 0x3fe0d8c0ec395053,
    0xbf51c98df4875378, 0xbfe03607be9cf79d,
    0xbfe771837e281819, 0xbfdf102183dca452,
    0xbfa432ee1e64b874, 0x3fdc302596aceb04,
    0x3fe5a0dfb0835bd4, 0x3fe1e19977d23895,
    0x3f9d0d5b00b8f4e4, 0xbfe0ec62b9dcd312,
    0xbfe552e26ac88e7a, 0xbfe130c888ceacc4,
    0xbfa50fe04a6e7e93, 0x3fe02e0d09a236a1,
    0x3fe70cb27ad8c1f1, 0x3fdef3f2392a2573,
    0x3fb104530e6abd69, 0xbfda9d7dc9604ae2,
    0xbfe5b5a6938e94e9, 0xbfe0e9281756ca3a,
    0x3fa7ce6b3ac26d49, 0x3fe1047116792f2d,
    0x3fe90551a7318f6a, 0x3fe1794a2bf9bc3e,
    0xbf9fa0e536a6a2bd, 0xbfde3a106edefdd7,
    0xbfe722c07ce7bc6a, 0xbfdd860ad301f750,
    0xbf7a76adb309305b, 0x3fdb9d1a64aa99c3,
    0x3fe5ccf008a8d934, 0x3fe0266e1519950a,
    0x3fae2f9d9b205d3f, 0xbfdfad3c362e4cd9,
    0xbfe68ddffa47a57f, 0xbfe1503bdccb2493
    };

static const uint64_t in_rifft_noisy_128[129] = {
    0xbf9d349d16447120, 0x3fe3aa062eac84c7,
    0x3fc9a22026eaf7bb, 0x3fb07241ee7015c5,
    0xbfeaf9239e29e73e, 0x3fd6bf8ea5b5fdd0,
    0xbfa8bff8cf979568, 0x3fc2e9d866bc2504,
    0xbfe971c5ba02edf9, 0x3fddbf276ca2ee2e,
    0xbfd67c69d5a3baab, 0xbfc6ed672bede974,
    0x3fbdef2c1e3600f3, 0xbfda20b7e2d83b7e,
    0x3fc6be0add21b297, 0x3fd77cc8ac409fde,
    0xbfb1057c47852a20, 0xbfb3ebc634d9e0ed,
    0x3fb7015c269c488a, 0x3fc053d941d128f3,
    0x3fc1929dfbcdf076, 0x3fc7efae2f3b7def,
    0xbfd65c30b716bcfc, 0x3fc8725134b9a017,
    0xbfe16d0eaf86064d, 0x3fb7cd23e199919d,
    0x3fe0f58b0340a0d1, 0x3fc327706c81e93b,
    0x3fa2925febe2236c, 0xbfd80c5d16654bec,
    0xbff1656a89d53613, 0x3fd782a31eb7f284,
    0xbfdbff04b89db4e3, 0xc04666f601a95e0f,
    0x3fcf22d5b7fa5f40, 0xbfc294af1c1489ae,
    0xbfdfb04fd04258d4, 0xbfd71318558ba59e,
    0x3fc64fdc263a0872, 0x3fd2cc9bf53b521b,
    0xbfb9f88733d7581c, 0x3fcc7d9a7e5a7320,
    0xbfd38f7e30a8f0a4, 0xbfc3faea5737f3fc,
    0xbfe1b4ffcf30bc50, 0xbfdacf6138a28203,
    0xbfcf730689a29dd8, 0x3fc4268240d958d6,
    0xbfe12597e4471ca6, 0xbfe0f40eef24fdf1,
    0x3fafe3527eeb1fc3, 0x3fbf30a5d369f166,
    0xbfc75fe780ee60cb, 0xbfe45fcfa3829eec,
    0x3fdba0a8989a6fb3, 0x3fc153bf75f6ec70,
    0x3fbd301bf9563b4e, 0x3fe05598651b8a10,
    0xbfd2e39eecd7138c, 0x3fd0f787c3e7dbce,
    0x3fe11a029511f5de, 0x3fd03db67718e678,
    0x3fd3b33d33f5cc7c, 0x3fb40192c5ebdb2c,
    0xbfa4893ddf7efe10, 0xbfe14f1f1190a708,
    0xbfb8ee0d31a01df2, 0xbf9fe0903a9a2bbe,
    0xbfd6016d999c0331, 0xbfd4dabc85035a3a,
    0xbfa7182f7bfd94b0, 0x3feb43c57c651b8b,
    0x3fc2eb33253ba249, 0xbf960520aee52fa8,
    0xbfb8b137a1d9a6e4, 0x3fe423c34b0283ec,
    0xbfaba6fd6649d21c, 0xbfe8e37be1079cd4,
    0x3fbd86aba43addac, 0xbfd822da12bd4532,
    0x3fb42fd830cc5eb8, 0x3fa5911bbc61e61c,
    0xbfd483ee60fad8f0, 0x3fdc2cf1bd594855,
    0xbfd47317fd073130, 0xbfdf391ce547fa6d,
    0xbfd20f679fae7054, 0x3fe12e47e6afb6b4,
    0x3fbdf41b09d3710c, 0xbfa7ba3c74b06560,
    0x3fe230f3f25c95cc, 0xbfe78ce91f5db422,
    0xbfcdf09a679cb518, 0x3fe1c58edf791d3b,
    0x3fb39699852bd0d7, 0xbfe134867bc5066e,
    0x3fcd8e1f59c36dba, 0x3f8f006353fa5000,
    0xbfdcb484ff322f43, 0xbfb345171e144fc6,
    0x3fc0a3013eef7da3, 0x3fc829f54e71150f,
    0xbfdcda3882d6c48e, 0xbfc73a161f91ca6d,
    0xbfe25179c97f6f85, 0x3fd3c3a052784fdb,
    0xbfc68b8b950f6918, 0xbfe2d94b314da253,
    0xbfe323bf4cbbbd4a, 0x3fda83c1d4331490,
    0x3fd4081ed8d63d8a, 0xbfc975b4b511a73d,
    0xbf7cd223ca3ed768, 0x3fd0663e83e5cad5,
    0x3fca2a29492c4639, 0xbfb4273ab25e6cae,
    0x3fca0e402671a56c, 0xbfe3e169137ccfb7,
    0x3fd7ee69210861f3, 0x3fee1ffd0e2d7cff,
    0xbfc167f0c087a00c, 0xbfde7c40c4bab490,
    0x3fda72f8752f884f, 0xbfd2e30e1e1c065e,
    0xbfe5f5ad326eb1cc, 0xbfc018bd93bd3084,
    0xbfc82d9a66d70855, 0x3fc48e5d4970eb90,
    0x0
    };

static const uint64_t ref_rfft_noisy_128[129] = {
    0xbf9d349d16447120, 0x3fe3aa062eac84c7,
    0x3fc9a22026eaf7bb, 0x3fb07241ee7015c5,
    0xbfeaf9239e29e73e, 0x3fd6bf8ea5b5fdd0,
    0xbfa8bff8cf979568, 0x3fc2e9d866bc2504,
    0xbfe971c5ba02edf9, 0x3fddbf276ca2ee2e,
    0xbfd67c69d5a3baab, 0xbfc6ed672bede974,
    0x3fbdef2c1e3600f3, 0xbfda20b7e2d83b7e,
    0x3fc6be0add21b297, 0x3fd77cc8ac409fde,
    0xbfb1057c47852a20, 0xbfb3ebc634d9e0ed,
    0x3fb7015c269c488a, 0x3fc053d941d128f3,
    0x3fc1929dfbcdf076, 0x3fc7efae2f3b7def,
    0xbfd65c30b716bcfc, 0x3fc8725134b9a017,
    0xbfe16d0eaf86064d, 0x3fb7cd23e199919d,
    0x3fe0f58b0340a0d1, 0x3fc327706c81e93b,
    0x3fa2925febe2236c, 0xbfd80c5d16654bec,
    0xbff1656a89d53613, 0x3fd782a31eb7f284,
    0xbfdbff04b89db4e3, 0xc04666f601a95e0f,
    0x3fcf22d5b7fa5f40, 0xbfc294af1c1489ae,
    0xbfdfb04fd04258d4, 0xbfd71318558ba59e,
    0x3fc64fdc263a0872, 0x3fd2cc9bf53b521b,
    0xbfb9f88733d7581c, 0x3fcc7d9a7e5a7320,
    0xbfd38f7e30a8f0a4, 0xbfc3faea5737f3fc,
    0xbfe1b4ffcf30bc50, 0xbfdacf6138a28203,
    0xbfcf730689a29dd8, 0x3fc4268240d958d6,
    0xbfe12597e4471ca6, 0xbfe0f40eef24fdf1,
    0x3fafe3527eeb1fc3, 0x3fbf30a5d369f166,
    0xbfc75fe780ee60cb, 0xbfe45fcfa3829eec,
    0x3fdba0a8989a6fb3, 0x3fc153bf75f6ec70,
    0x3fbd301bf9563b4e, 0x3fe05598651b8a10,
    0xbfd2e39eecd7138c, 0x3fd0f787c3e7dbce,
    0x3fe11a029511f5de, 0x3fd03db67718e678,
    0x3fd3b33d33f5cc7c, 0x3fb40192c5ebdb2c,
    0xbfa4893ddf7efe10, 0xbfe14f1f1190a708,
    0xbfb8ee0d31a01df2, 0xbf9fe0903a9a2bbe,
    0xbfd6016d999c0331, 0xbfd4dabc85035a3a,
    0xbfa7182f7bfd94b0, 0x3feb43c57c651b8b,
    0x3fc2eb33253ba249, 0xbf960520aee52fa8,
    0xbfb8b137a1d9a6e4, 0x3fe423c34b0283ec,
    0xbfaba6fd6649d21c, 0xbfe8e37be1079cd4,
    0x3fbd86aba43addac, 0xbfd822da12bd4532,
    0x3fb42fd830cc5eb8, 0x3fa5911bbc61e61c,
    0xbfd483ee60fad8f0, 0x3fdc2cf1bd594855,
    0xbfd47317fd073130, 0xbfdf391ce547fa6d,
    0xbfd20f679fae7054, 0x3fe12e47e6afb6b4,
    0x3fbdf41b09d3710c, 0xbfa7ba3c74b06560,
    0x3fe230f3f25c95cc, 0xbfe78ce91f5db422,
    0xbfcdf09a679cb518, 0x3fe1c58edf791d3b,
    0x3fb39699852bd0d7, 0xbfe134867bc5066e,
    0x3fcd8e1f59c36dba, 0x3f8f006353fa5000,
    0xbfdcb484ff322f43, 0xbfb345171e144fc6,
    0x3fc0a3013eef7da3, 0x3fc829f54e71150f,
    0xbfdcda3882d6c48e, 0xbfc73a161f91ca6d,
    0xbfe25179c97f6f85, 0x3fd3c3a052784fdb,
    0xbfc68b8b950f6918, 0xbfe2d94b314da253,
    0xbfe323bf4cbbbd4a, 0x3fda83c1d4331490,
    0x3fd4081ed8d63d8a, 0xbfc975b4b511a73d,
    0xbf7cd223ca3ed768, 0x3fd0663e83e5cad5,
    0x3fca2a29492c4639, 0xbfb4273ab25e6cae,
    0x3fca0e402671a56c, 0xbfe3e169137ccfb7,
    0x3fd7ee69210861f3, 0x3fee1ffd0e2d7cff,
    0xbfc167f0c087a00c, 0xbfde7c40c4bab490,
    0x3fda72f8752f884f, 0xbfd2e30e1e1c065e,
    0xbfe5f5ad326eb1cc, 0xbfc018bd93bd3084,
    0xbfc82d9a66d70855, 0x3fc48e5d4970eb90,
    0x0
    };

static const uint64_t in_rfft_noisy_256[256] = {
    0x3fb20c88d3a95653, 0x3fd6499d0369b35e,
    0x3fe56769a8876e32, 0x3fdebee175eecb43,
    0xbfa7d3b943d6ea7e, 0xbfe1c8e92a93017c,
    0xbfe7988c23bee6e0, 0xbfdc2ed7d901528b,
    0x3f8e012b553f0cd2, 0x3fdaf22d5bb38d8b,
    0x3fe7cb4065392837, 0x3fdaf14720f13766,
    0xbfa2b611fa2e9a3a, 0xbfdb26f60e52fdb7,
    0xbfe890a70d45222d, 0xbfdde665a1c574b3,
    0x3fab4e4a75675026, 0x3fde3c5b5d43e750,
    0x3fe406cf587f919a, 0x3fd9de19d334ae10,
    0x3f95d9938f794fb3, 0xbfe03ec7c6ccfcf9,
    0xbfe64651de4128ba, 0xbfde49dda97fd9b6,
    0x3fa876968e848986, 0x3fde8dfba87aeb2a,
    0x3fe4e8e4387b5041, 0x3fde72508d545b96,
    0xbf9363e8bf4ed215, 0xbfdcb21f84f6b54e,
    0xbfe60f33d5aa5ee7, 0xbfe07e8563589fa6,
    0xbf96e5dd3fb2e8a2, 0x3fde5e152ce149d7,
    0x3fe5e61a94644b3c, 0x3fde14b43f3799ed,
    0x3f9b13a9eb3080c2, 0xbfe14467a1a95565,
    0xbfe57ad7dc235145, 0xbfdc6d474a92909a,
    0x3f9e535069423d00, 0x3fdd3328eab5c48a,
    0x3fe56c3568537a0d, 0x3fdb66e43758e924,
    0xbf96db00bccf805f, 0xbfe1b4e1fe74c8d6,
    0xbfe6579f718e58c7, 0xbfdf0dcd6183f65b,
    0xbf9dc418ae0a26f6, 0x3fdf2be3e5789689,
    0x3fe3ecdc3e0244c2, 0x3fe0d74a7b9bd279,
    0xbf96405bbf30bbd0, 0xbfdfdeefa82fd3d1,
    0xbfe629fe5bca6b4d, 0xbfddcb0eaf3cb3c0,
    0x3fb0b61088b2beee, 0x3fd95b4d5fc95dc0,
    0x3fe635cc0d46ef89, 0x3fdd8a500cf56090,
    0xbfa9de18bce9012a, 0xbfdbdbe103d7bbb0,
    0xbfe2912ce1047c41, 0xbfdfc3f1c496ccf5,
    0xbf67290958800463, 0x3fdc2fae7cc00448,
    0x3fe698754c74209a, 0x3fe0a6997122545d,
    0x3fa7809987c94ffd, 0xbfe1548b48a16503,
    0xbfe56c04ba9c3532, 0xbfdac54724fdb925,
    0xbfa1a079c9c45d5c, 0x3fdd422b5e442a52,
    0x3fe6439c94846f76, 0x3fe0948da48dd4ea,
    0x3fadddc2efc76d49, 0xbfdf86b2a4e85ae8,
    0xbfe66bb031e3bed9, 0xbfde845cf6c57f6e,
    0x3faa94b2c3aec756, 0x3fe0c005a598175f,
    0x3fe8f86550f38269, 0x3fdbf415fb0f93f0,
    0xbf91e33800791891, 0xbfde10532a17c3fa,
    0xbfe5fef8bd828d98, 0xbfdfc96d91e86ad4,
    0xbfacc889c05ce48f, 0x3fe1e86aacc385f2,
    0x3fe74144334d9116, 0x3fe2a391d35a7581,
    0x3fb728e9a65f71c9, 0xbfe1b5ddd5e7a7c4,
    0xbfe76b8293f9f4b5, 0xbfda853ca8200902,
    0x3fad813cf0fc577b, 0x3fe1a59b5b8e22a3,
    0x3fe1c051e3d5a1b2, 0x3fe0b1f01c2ad693,
    0xbfb2c7b05f5da949, 0xbfe18c1ecd540f04,
    0xbfe8ab514e04945b, 0xbfdd9b99184b82b5,
    0x3fa65dee589a5430, 0x3fdd64936ca9cd19,
    0x3fe80d77b3191ea1, 0x3fe0acecebcb2c55,
    0x3f6c317d11eab6af, 0xbfde08798dfff1b9,
    0xbfe62f81c40c6fd4, 0xbfe0be3efb6cacc9,
    0xbfae80da9f3c4fdc, 0x3fdb5a8d662a0f97,
    0x3fe5004116468638, 0x3fe2fa4a9322239f,
    0x3fa1e034ef9d7e54, 0xbfdeb57ce4003193,
    0xbfe739b74bda979e, 0xbfddcb3aa6028b21,
    0xbf79b40fbc2ad835, 0x3fe0d9e436bd9cda,
    0x3fe62cfa45d1c251, 0x3fdf4647609802dc,
    0xbf84b660bdd838ee, 0xbfe13a6f61ac6ba3,
    0xbfe784fbf16c08d0, 0xbfe1106cef2cb3bf,
    0xbf99550e2256c7a3, 0x3fdbe2ca3c3be5fd,
    0x3fe4cbdc34754093, 0x3fe00c48f5feda6a,
    0xbfb182bc84aacf56, 0xbfe1484eb7b021fb,
    0xbfe3fb90e29b76ed, 0xbfe07c9cda010d0f,
    0xbfaa2d7f2605d4b1, 0x3fe0c7fef19d57f3,
    0x3fe53615f260e516, 0x3fdc5ae3c734c0ca,
    0xbf87963bad604932, 0xbfdf01c504d7faa8,
    0xbfe74540e3c63c21, 0xbfe245287bef73c2,
    0x3f66684f9e6f9018, 0x3fda4cce135d65a8,
    0x3fe829bc88a5b669, 0x3fdd595fdfbeebfa,
    0xbfb6379fd6710d7a, 0xbfda483fce500957,
    0xbfe721fd261a7949, 0xbfdec26ccfa3e151,
    0xbf948fbe40c8ce3f, 0x3fe013b6eee4036b,
    0x3fe5d79f91a432e2, 0x3fdf66b35d36c181,
    0xbfa91fbcc2126f6b, 0xbfe1c0aa63edc2f4,
    0xbfe99ba9f8f52a27, 0xbfe0f1bbf93242fa,
    0xbfb5fb0801e2df23, 0x3fdd840babaa20ee,
    0x3fe6cb55e65a8bf5, 0x3fdebf70e4c3187f,
    0xbfa771107659316c, 0xbfe067daa95d852f,
    0xbfe611fd570db505, 0xbfe224901c76326e,
    0x3fac6bbc17a91048, 0x3fe044e2921c46f5,
    0x3fe5f594d6aeba56, 0x3fdebdc1b60f4985,
    0xbf79475fdc501987, 0xbfddad7545d1d7ff,
    0xbfe58e926895298d, 0xbfd6fdfa5c932d32,
    0x3f9d86889d6f9eed, 0x3fe0f2c9db34bcb0,
    0x3fe6e85d56cb9075, 0x3fde09964764de43,
    0xbfad673b256f6552, 0xbfe1cc9f79038224,
    0xbfe81aa3d25ca635, 0xbfe1dfaa37a3acc0,
    0xbfa6eb60e8dc5115, 0x3fe17148d961b73d,
    0x3fe63bdc6f5fbccc, 0x3fdc4708b1c69730,
    0x3fa19ad5997cb251, 0xbfded84f80238870,
    0xbfe781ecf3a9cef6, 0xbfdccfa59dc36e7a,
    0xbf9c4a20d477fb29, 0x3fe00a0f1bb1b5b0,
    0x3fe6c5e964a3f584, 0x3fdee6e9027ee6e0,
    0x3fa6ff73b2b4c1dd, 0xbfe2570145e76f42,
    0xbfe563d4651b51b3, 0xbfdee3900adc8842,
    0xbf9108aa5726d339, 0x3fe18812edb15ef0,
    0x3fe4eb3830e633c6, 0x3fdcc454f1b61fc4,
    0x3f8f7855f074d476, 0xbfdb1109f11ca19f,
    0xbfe80c1f43d665d7, 0xbfe032fca0f15715,
    0x3fb3a497db255bd4, 0x3fe0a1a624d76858,
    0x3fe4a30126f8fd35, 0x3fdebd4c3380e788,
    0x3fb0122609a843a7, 0xbfe21dea583f1efb,
    0xbfe55e3dcd665753, 0xbfe0156ec2e61296,
    0x3fa87188b79d0966, 0x3fde78e4ee6ab9cc,
    0x3fe93bd776fd933d, 0x3fe17035d3affb64,
    0xbf4e526c397d220d, 0xbfe21a1867acecd0,
    0xbfe5a16e8433a1b2, 0xbfe1aea85ef98c7f,
    0x3f9fff77f9d0ac4a, 0x3fddead82717794a,
    0x3fe544470a5f0950, 0x3fdef3572a39d8c5,
    0xbf6b79f15765d21c, 0xbfdf61e84ed3d168,
    0xbfe61c9e25aadd6e, 0xbfdbee4747b4ed30,
    0x3f984fe25124c140, 0x3fdb2b1a3029723c,
    0x3fe69edd6073a601, 0x3fdd356df6fe21be,
    0x3fb23d08c94af649, 0xbfe058e147d72bfb,
    0xbfe64da073e41169, 0xbfe34b8a491789b9,
    0xbfb052ffdc9cb2c5, 0x3fdddf371a02af4e,
    0x3fe96d27b1b3115c, 0x3fdf1bd57c094678,
    0x3fb31516a7d6a57b, 0xbfdf9972f2c56778,
    0xbfe67a0601b54ae4, 0xbfde16090eb3f8f3,
    0xbfab1d25cc66200d, 0x3fe0fa27652fb164,
    0x3fe5fa3c02a349a4, 0x3fe0a79308b30440,
    0xbf9d4103cbe96909, 0xbfdc7c32a4ffcc50,
    0xbfe5b09de3865497, 0xbfda3d70cb88cc82
    };

static const uint64_t in_rifft_noisy_256[257] = {
    0xbff2fd4224ea388e, 0x3fe07e87e4f2e9e4,
    0x3fd6f77caa1b7c62, 0xbfdb1fb0d9807dfe,
    0xbfecc1a003bc1914, 0x3ff48d449371aa02,
    0x3fe1cc51db8c5b30, 0xbfc26618d480b620,
    0x3fa8f414424ef20a, 0xbfb41030c322eb5c,
    0xbfd4fd2be918b302, 0xbfb3eb101903e338,
    0x3fd5db30e197c7ff, 0x3fdbbda70b0028f4,
    0x3fcceb2b78e51082, 0x3fe4ccc28adaa430,
    0xbfdadb675a1f5ad4, 0x3fdcce3c61f24766,
    0x3fec574952bda1c2, 0xbfd2676726936072,
    0xbfe28a5f3ecce9cb, 0x3fe697a852bfa98c,
    0xbfd85fdec1bc1221, 0xbfc069e06d772f2c,
    0x3fdb604881067ff3, 0xbfb52ef1c51400c4,
    0x3fa34f6a2cae23c0, 0x3ff2393d6d82f358,
    0xbfdbb06a0e0e06c8, 0xbfa8e49b2471969a,
    0x3fc05acfc63aaf76, 0xbfc004d831737502,
    0xbfe19b5f19db4f7d, 0x3fe26565b4dd4d7d,
    0x3fc66e7e736c07bf, 0xbfadac3e2d0ab070,
    0xbff32baf152a7c9d, 0xbfca2c175e3084ea,
    0x3ff8c26ba2f2de82, 0x3fd9be120335d4c0,
    0x3fe4d66001545a46, 0x3fa12073709099a8,
    0xbfa74d1027cdcfbc, 0x3fcb2b6600a7e63e,
    0x3ff1f22f778098fa, 0xbfa9a5ab8bcdeb98,
    0xbfdc2ed0d957f239, 0x3feac88872330663,
    0xbfd4d1f33c481da4, 0x3fd6665249b5874e,
    0x3fd49e7fa87978b9, 0xbfc6d9b6343d43f2,
    0x3fd6ad369ed31c70, 0x3fe533e50f611c8e,
    0xbfbfc1f71ec785f0, 0x3fc9248bd1cc83b3,
    0xbfd38916828ab700, 0x3feb5f432b312eb2,
    0x3fd1ce714f6bcbc7, 0x3fd21fd95c7ad5b6,
    0xbfeffa1ac0e2c287, 0x3fdfa38e8243567d,
    0xbfe2c03464ba5846, 0x3fe42c635faefcde,
    0x3fdbb42292582962, 0xc05637e03de1200e,
    0x3fe9dd97b7f22042, 0x3fe7c97880e84c65,
    0x3fd13a8ec47f59ca, 0xbfdd821324334ebd,
    0x3fc1ef224331cfcc, 0xbfeab85adb9b1fca,
    0xbfc556a094c3415b, 0x3fcb8c6215d7e509,
    0x3fdef44a0d5c261c, 0xbfacfd5aee99a3e0,
    0x3fead3a9ca5d5960, 0xbff0f0fc2ffd8096,
    0xbfda1d7a532754ef, 0x3fb1e9a43d56431c,
    0x3fe639406eb82138, 0xbfc7060451628478,
    0x3fb11a64041dfa2c, 0x3fe422bdb36600f7,
    0x3fe07ae1aa9e6626, 0x3fef8736c6118f2a,
    0xbfe3b77ca0ce4ca0, 0x3fc5feda91f37f22,
    0xbfcb78f982b755bc, 0x3ff27de4f4119e37,
    0xbfac8413ecf2f5b8, 0x3fc62a0894c3eeb0,
    0xbfc1d24d80a4a54e, 0xbfda6561ac0f6b7a,
    0xbfc301fa2d048902, 0xbf8429f0c4af7700,
    0xbfd7937dd8b75180, 0xbfc44c4dcf139a61,
    0xbfd58733186871c5, 0xbfa355572f0d39b0,
    0x3fc439675c1be17c, 0x3fe31494fc55a6b7,
    0x3febb826bc389dbc, 0xbf7d3e8e29929f80,
    0xbff2b3bbc5b38762, 0xbfdb675a8e77df4f,
    0x3fdd4d637fe0582c, 0x3fe3a82b2774074e,
    0x3fec93f333492e98, 0xbfd02fd096b5c547,
    0xbfd6e67605c0cd84, 0x3fb1fcba90db2994,
    0xbfdec724e4c2b1e4, 0x3fedb406c1f451b4,
    0xbfe18e4950e2c94c, 0x3fdee61cfce072a7,
    0xbfc924019890f156, 0x3fd7afde7bca7f66,
    0xbfd1db742605735d, 0x3fe194e62c97d24b,
    0x3fb78cbc110b35f8, 0x3fd563bbb14ee4f8,
    0xbfb05df8339c1460, 0x3fed976938425b12,
    0x3fd6dc07fa8cd492, 0xbfcc728ba056a5fc,
    0xbfd2426cd25cb2e7, 0x3fc7550ae47544f6,
    0x3fd9788dc804fec7, 0x3fe7ccffa6192c00,
    0x3fefae0d56dc5a3e, 0x3fab2c1d1b43c062,
    0xbfe16b0c569c0cbd, 0x3fdbd8fd4bc4ae20,
    0xbfc51752a8dcff84, 0xbfe9a0650da469c6,
    0xbfe9fade0b771d13, 0xbfadcfd788d9c5e4,
    0x3fe8b86084c89e02, 0x3fc8642f3ecc9528,
    0x3fcf10b2a256c1a6, 0x3fca6c8b94fe318f,
    0xbfcbe6e011faf21e, 0x3fe26544971178a4,
    0x3fc6a9e991fbad89, 0x3fe5e83dc7f1919a,
    0xbfcdcc9e39bb0bd0, 0xbfd65bc04b9d1827,
    0x3fc8c9435f25b500, 0x3fe889caa508c1f0,
    0x3ff176c16d9cfc7d, 0xbfb93590220bde94,
    0x3fe32f0521f2c9e1, 0x3fe864c5a2379114,
    0xbfd5fadd82ab0bff, 0x3ff2e41d38ff4320,
    0xbfcfd6d5b468016c, 0xbfc11a5000695bd8,
    0x3febbd6d5ab8f4ca, 0xbfeedcec720565bd,
    0x3feee0ba2a3da8ba, 0x3f9c1a53bc1aa9c8,
    0xbfdcbf319c1229cd, 0xbfe8aa65da9a854a,
    0x3fe65f9ce11e8368, 0x3fd790cf385aceec,
    0xbfd7ed684efe7fbb, 0x3fb089fd58f941f0,
    0x3fed5fccf5aef45b, 0xbfd446f25492238b,
    0xbfe1ce9d873dcf6a, 0xbfd28d3161135879,
    0x3fc2a813200976a1, 0x3fd93bc18c88f5d0,
    0x3fd5116a51aa5893, 0x3fb8238842bddfe8,
    0xbfa78a84a7f398c0, 0xbfe467086234e5d1,
    0xbfd3e814e85a9201, 0x3fc11a491264baaa,
    0xbfbc9dd692c43e04, 0x3fa3685ffd3df650,
    0x3fd4db4be78c28e8, 0x3ff030771c8e4921,
    0xbfd9a49f7841a056, 0x3fd0f4ad037d64d6,
    0xbfc070fb6d69d344, 0x3fd5857a137e8318,
    0x3fc39119adc26300, 0x3fe810dea087d5b6,
    0xbfa59599438793c8, 0x3fe523e12e1e4527,
    0xbfb5aeca60c55218, 0x3fda6ca6fba29e80,
    0xbfb87c97b23f9c9c, 0x3fd01bca4b2519a2,
    0x3fef2ac914d00331, 0x3fb27db01004d22c,
    0xbfcff74b68c9f242, 0x3ff1e6afd36b54da,
    0x3fc1c701125cc39a, 0x3fc36d020d5f1cb6,
    0x3fe4e73e100e93be, 0xbfe627c4f88355fb,
    0xbfb6200b1a60cee2, 0xbfecb198fdae313c,
    0x3fead0a3ef866286, 0x3fe43deb63c15852,
    0x3fb50168783c8a86, 0xbfe08bbe81bbbe2e,
    0x3ff1bca47c42ec52, 0x3fb3346328c02168,
    0x3fe77fcf076fa063, 0xbfcafafe2b6fabc8,
    0xbfbf5a8ad465d612, 0xbfea1d517ca44c80,
    0xbfd05d5a93cf459b, 0x3feee901535bdb66,
    0xbfb1a5b3e9f60d18, 0xbfdcddbc661243bc,
    0x3fbc63db03e52030, 0xbfdfc73a8906752b,
    0x3fdb957538101c82, 0x3fdfa5963e821526,
    0xbef18f0a86288000, 0x3fc554924933cc03,
    0xbfddf803fe06680f, 0x3fdb259948418f2b,
    0x3fef500628745edc, 0x3fc03788c8c7c94e,
    0x3fdd48195123401a, 0x3fef906038075dc7,
    0x3ff018d854ce23ff, 0x3f9076046f824210,
    0xbfd5fe4649eda6bf, 0x3fe1dd10015efa8f,
    0xbfef146c3c694dc1, 0x3fea6c0cdb6125a4,
    0x3fa36c8a2a8fdd88, 0xbfca6e214b459f54,
    0xbfca0056b8614e38, 0x3fde485b79e35f22,
    0x3fc4daa9f343532e, 0xbfb56f2851f25e84,
    0xbf59ff3b2e6d9500, 0x3f81bb5206dfefb0,
    0xbfe50d191089c788, 0x3fd129eb5ee15df8,
    0xbf6eec5dcab73520, 0x3fcb1c4200ec9820,
    0xbfe1d7131105d2fc, 0xbfeba8346eb6879c,
    0xbfcddacf378bddf0, 0xbfd3082e049478f6,
    0x3ff14a2203f25234, 0xbfc47b274c9d9a1d,
    0x0
    };

static const uint64_t ref_rfft_noisy_256[257] = {
    0xbff2fd4224ea388e, 0x3fe07e87e4f2e9e4,
    0x3fd6f77caa1b7c62, 0xbfdb1fb0d9807dfe,
    0xbfecc1a003bc1914, 0x3ff48d449371aa02,
    0x3fe1cc51db8c5b30, 0xbfc26618d480b620,
    0x3fa8f414424ef20a, 0xbfb41030c322eb5c,
    0xbfd4fd2be918b302, 0xbfb3eb101903e338,
    0x3fd5db30e197c7ff, 0x3fdbbda70b0028f4,
    0x3fcceb2b78e51082, 0x3fe4ccc28adaa430,
    0xbfdadb675a1f5ad4, 0x3fdcce3c61f24766,
    0x3fec574952bda1c2, 0xbfd2676726936072,
    0xbfe28a5f3ecce9cb, 0x3fe697a852bfa98c,
    0xbfd85fdec1bc1221, 0xbfc069e06d772f2c,
    0x3fdb604881067ff3, 0xbfb52ef1c51400c4,
    0x3fa34f6a2cae23c0, 0x3ff2393d6d82f358,
    0xbfdbb06a0e0e06c8, 0xbfa8e49b2471969a,
    0x3fc05acfc63aaf76, 0xbfc004d831737502,
    0xbfe19b5f19db4f7d, 0x3fe26565b4dd4d7d,
    0x3fc66e7e736c07bf, 0xbfadac3e2d0ab070,
    0xbff32baf152a7c9d, 0xbfca2c175e3084ea,
    0x3ff8c26ba2f2de82, 0x3fd9be120335d4c0,
    0x3fe4d66001545a46, 0x3fa12073709099a8,
    0xbfa74d1027cdcfbc, 0x3fcb2b6600a7e63e,
    0x3ff1f22f778098fa, 0xbfa9a5ab8bcdeb98,
    0xbfdc2ed0d957f239, 0x3feac88872330663,
    0xbfd4d1f33c481da4, 0x3fd6665249b5874e,
    0x3fd49e7fa87978b9, 0xbfc6d9b6343d43f2,
    0x3fd6ad369ed31c70, 0x3fe533e50f611c8e,
    0xbfbfc1f71ec785f0, 0x3fc9248bd1cc83b3,
    0xbfd38916828ab700, 0x3feb5f432b312eb2,
    0x3fd1ce714f6bcbc7, 0x3fd21fd95c7ad5b6,
    0xbfeffa1ac0e2c287, 0x3fdfa38e8243567d,
    0xbfe2c03464ba5846, 0x3fe42c635faefcde,
    0x3fdbb42292582962, 0xc05637e03de1200e,
    0x3fe9dd97b7f22042, 0x3fe7c97880e84c65,
    0x3fd13a8ec47f59ca, 0xbfdd821324334ebd,
    0x3fc1ef224331cfcc, 0xbfeab85adb9b1fca,
    0xbfc556a094c3415b, 0x3fcb8c6215d7e509,
    0x3fdef44a0d5c261c, 0xbfacfd5aee99a3e0,
    0x3fead3a9ca5d5960, 0xbff0f0fc2ffd8096,
    0xbfda1d7a532754ef, 0x3fb1e9a43d56431c,
    0x3fe639406eb82138, 0xbfc7060451628478,
    0x3fb11a64041dfa2c, 0x3fe422bdb36600f7,
    0x3fe07ae1aa9e6626, 0x3fef8736c6118f2a,
    0xbfe3b77ca0ce4ca0, 0x3fc5feda91f37f22,
    0xbfcb78f982b755bc, 0x3ff27de4f4119e37,
    0xbfac8413ecf2f5b8, 0x3fc62a0894c3eeb0,
    0xbfc1d24d80a4a54e, 0xbfda6561ac0f6b7a,
    0xbfc301fa2d048902, 0xbf8429f0c4af7700,
    0xbfd7937dd8b75180, 0xbfc44c4dcf139a61,
    0xbfd58733186871c5, 0xbfa355572f0d39b0,
    0x3fc439675c1be17c, 0x3fe31494fc55a6b7,
    0x3febb826bc389dbc, 0xbf7d3e8e29929f80,
    0xbff2b3bbc5b38762, 0xbfdb675a8e77df4f,
    0x3fdd4d637fe0582c, 0x3fe3a82b2774074e,
    0x3fec93f333492e98, 0xbfd02fd096b5c547,
    0xbfd6e67605c0cd84, 0x3fb1fcba90db2994,
    0xbfdec724e4c2b1e4, 0x3fedb406c1f451b4,
    0xbfe18e4950e2c94c, 0x3fdee61cfce072a7,
    0xbfc924019890f156, 0x3fd7afde7bca7f66,
    0xbfd1db742605735d, 0x3fe194e62c97d24b,
    0x3fb78cbc110b35f8, 0x3fd563bbb14ee4f8,
    0xbfb05df8339c1460, 0x3fed976938425b12,
    0x3fd6dc07fa8cd492, 0xbfcc728ba056a5fc,
    0xbfd2426cd25cb2e7, 0x3fc7550ae47544f6,
    0x3fd9788dc804fec7, 0x3fe7ccffa6192c00,
    0x3fefae0d56dc5a3e, 0x3fab2c1d1b43c062,
    0xbfe16b0c569c0cbd, 0x3fdbd8fd4bc4ae20,
    0xbfc51752a8dcff84, 0xbfe9a0650da469c6,
    0xbfe9fade0b771d13, 0xbfadcfd788d9c5e4,
    0x3fe8b86084c89e02, 0x3fc8642f3ecc9528,
    0x3fcf10b2a256c1a6, 0x3fca6c8b94fe318f,
    0xbfcbe6e011faf21e, 0x3fe26544971178a4,
    0x3fc6a9e991fbad89, 0x3fe5e83dc7f1919a,
    0xbfcdcc9e39bb0bd0, 0xbfd65bc04b9d1827,
    0x3fc8c9435f25b500, 0x3fe889caa508c1f0,
    0x3ff176c16d9cfc7d, 0xbfb93590220bde94,
    0x3fe32f0521f2c9e1, 0x3fe864c5a2379114,
    0xbfd5fadd82ab0bff, 0x3ff2e41d38ff4320,
    0xbfcfd6d5b468016c, 0xbfc11a5000695bd8,
    0x3febbd6d5ab8f4ca, 0xbfeedcec720565bd,
    0x3feee0ba2a3da8ba, 0x3f9c1a53bc1aa9c8,
    0xbfdcbf319c1229cd, 0xbfe8aa65da9a854a,
    0x3fe65f9ce11e8368, 0x3fd790cf385aceec,
    0xbfd7ed684efe7fbb, 0x3fb089fd58f941f0,
    0x3fed5fccf5aef45b, 0xbfd446f25492238b,
    0xbfe1ce9d873dcf6a, 0xbfd28d3161135879,
    0x3fc2a813200976a1, 0x3fd93bc18c88f5d0,
    0x3fd5116a51aa5893, 0x3fb8238842bddfe8,
    0xbfa78a84a7f398c0, 0xbfe467086234e5d1,
    0xbfd3e814e85a9201, 0x3fc11a491264baaa,
    0xbfbc9dd692c43e04, 0x3fa3685ffd3df650,
    0x3fd4db4be78c28e8, 0x3ff030771c8e4921,
    0xbfd9a49f7841a056, 0x3fd0f4ad037d64d6,
    0xbfc070fb6d69d344, 0x3fd5857a137e8318,
    0x3fc39119adc26300, 0x3fe810dea087d5b6,
    0xbfa59599438793c8, 0x3fe523e12e1e4527,
    0xbfb5aeca60c55218, 0x3fda6ca6fba29e80,
    0xbfb87c97b23f9c9c, 0x3fd01bca4b2519a2,
    0x3fef2ac914d00331, 0x3fb27db01004d22c,
    0xbfcff74b68c9f242, 0x3ff1e6afd36b54da,
    0x3fc1c701125cc39a, 0x3fc36d020d5f1cb6,
    0x3fe4e73e100e93be, 0xbfe627c4f88355fb,
    0xbfb6200b1a60cee2, 0xbfecb198fdae313c,
    0x3fead0a3ef866286, 0x3fe43deb63c15852,
    0x3fb50168783c8a86, 0xbfe08bbe81bbbe2e,
    0x3ff1bca47c42ec52, 0x3fb3346328c02168,
    0x3fe77fcf076fa063, 0xbfcafafe2b6fabc8,
    0xbfbf5a8ad465d612, 0xbfea1d517ca44c80,
    0xbfd05d5a93cf459b, 0x3feee901535bdb66,
    0xbfb1a5b3e9f60d18, 0xbfdcddbc661243bc,
    0x3fbc63db03e52030, 0xbfdfc73a8906752b,
    0x3fdb957538101c82, 0x3fdfa5963e821526,
    0xbef18f0a86288000, 0x3fc554924933cc03,
    0xbfddf803fe06680f, 0x3fdb259948418f2b,
    0x3fef500628745edc, 0x3fc03788c8c7c94e,
    0x3fdd48195123401a, 0x3fef906038075dc7,
    0x3ff018d854ce23ff, 0x3f9076046f824210,
    0xbfd5fe4649eda6bf, 0x3fe1dd10015efa8f,
    0xbfef146c3c694dc1, 0x3fea6c0cdb6125a4,
    0x3fa36c8a2a8fdd88, 0xbfca6e214b459f54,
    0xbfca0056b8614e38, 0x3fde485b79e35f22,
    0x3fc4daa9f343532e, 0xbfb56f2851f25e84,
    0xbf59ff3b2e6d9500, 0x3f81bb5206dfefb0,
    0xbfe50d191089c788, 0x3fd129eb5ee15df8,
    0xbf6eec5dcab73520, 0x3fcb1c4200ec9820,
    0xbfe1d7131105d2fc, 0xbfeba8346eb6879c,
    0xbfcddacf378bddf0, 0xbfd3082e049478f6,
    0x3ff14a2203f25234, 0xbfc47b274c9d9a1d,
    0x0
    };

static const uint64_t in_rfft_noisy_512[512] = {
    0xbf685aa6997e7a65, 0x3fde54741ce71783,
    0x3fe6371e397b46fd, 0x3fdc433c34caf034,
    0x3faef43688c073db, 0xbfde473b41178f15,
    0xbfe7bab83634f071, 0xbfe07504803e5bbc,
    0xbf907092dd10161a, 0x3fe2de3b526190f6,
    0x3fe9990e8f7ec58a, 0x3fdb4099c4baab31,
    0x3fb636f26fd7b9b2, 0xbfd95c7777ddae98,
    0xbfe789dfc550c175, 0xbfdd339cb1f2b87b,
    0xbfab601de7b98d60, 0x3fdf28e92d84dcf2,
    0x3fe6cd581caf7237, 0x3fdeddc233c567f6,
    0x3f91c9f088d41c80, 0xbfe0f5a67b0dd6a4,
    0xbfe9027af3a5ae06, 0xbfdd0ced8226cf00,
    0xbf6752adb69b0572, 0x3fdb1f0a796bb3ae,
    0x3fe6f830d98015b3, 0x3fde79988753ce15,
    0x3fabeccd938c06da, 0xbfde1d6e8a6a54db,
    0xbfe83b8bed9e7d14, 0xbfd721f736b48f76,
    0xbf89c2b612630578, 0x3fe0c6955c5821a3,
    0x3fe9614ce1d7f50f, 0x3fde4e3d7b09bcd8,
    0x3fa37e5892dbc9a3, 0xbfe047a97e80ad57,
    0xbfe6f1e1fa299f81, 0xbfdeebe264e0a3ea,
    0xbfb237f4a43b2725, 0x3fdc24695aa946e2,
    0x3fe84ba13ff8d71b, 0x3fdcbd27528ac8cb,
    0xbfa397d7755c2c5e, 0xbfdcc4dd7636baae,
    0xbfe4d9b2388b2fac, 0xbfe0d5095260fd2e,
    0x3f933b295e116b4c, 0x3fe2be31442d1d08,
    0x3fe6e939db00c19e, 0x3fd92f505c5e869e,
    0xbfa783c5724ff34c, 0xbfdf92359b74a868,
    0xbfe566a9cb0d2deb, 0xbfdf354e8a13e89d,
    0x3f71962e1ae8596a, 0x3fe014811c4718af,
    0x3fe54b45118250f2, 0x3fe028f0020cc7e0,
    0xbf85f033d04de3d1, 0xbfe1c2959c38aba8,
    0xbfe4e273bbdd23d5, 0xbfd93a18b0d75ff7,
    0x3fa4fc7c91379ca6, 0x3fdfe4e2bb72b333,
    0x3fe6aca35779ce3f, 0x3fe0c35516273501,
    0x3f8a920bd891f180, 0xbfdc8a080bfa7c03,
    0xbfe793cc54a64250, 0xbfdeb16bd450f817,
    0xbfa6d568c5272229, 0x3fdcbf15cc88e0f0,
    0x3fe6d877b8c9c793, 0x3fdfe12170168400,
    0x3f92711cfda31101, 0xbfdfd6667871c6ce,
    0xbfe59652ee463b3b, 0xbfe08bd7b450d714,
    0x3f9f353dc7437b6e, 0x3fe0eb03cdcd68ce,
    0x3fe61ee7fa2b1ecd, 0x3fe269e32fa7c7d2,
    0x3fa8ea731beb7275, 0xbfdd7abe12b3f816,
    0xbfe653042085cef0, 0xbfdff3a6fa875930,
    0x3fb1b12d2577d1e8, 0x3fe0de114e47b447,
    0x3fe566ed208bfce8, 0x3fdfc5c99a266550,
    0xbfb0a4995e6a7f63, 0xbfe1996b66649b18,
    0xbfe6029da0e337de, 0xbfde9d24771603fb,
    0x3fa827cf0c4e6833, 0x3fdec77bf9fea3d0,
    0x3fe636d4540394b0, 0x3fdf03af736ff0dd,
    0x3f7a100f0ee64dcc, 0xbfde3e57b499eb99,
    0xbfe86cb65f146013, 0xbfe07159cbe60430,
    0xbf91e575a0c6cb7a, 0x3fdf0cb371bd9f58,
    0x3fe6cd793080891e, 0x3fdb70c1218d2471,
    0xbf9d9cc4ba7b949f, 0xbfe01f57bbe6d753,
    0xbfe69155fceb4fc9, 0xbfde7aafbc56fcdf,
    0x3fa19ced9c8ab0a8, 0x3fe06ae1def0586d,
    0x3fe7335104cc62ae, 0x3fdcb4cc63bc2ebc,
    0x3fa2f9212b657dc5, 0xbfdb55f3f0c98cdd,
    0xbfe6ddd729533708, 0xbfe2076f4e5f3b5c,
    0x3f8049898327d1ad, 0x3fe1444627643bf2,
    0x3fe74425861a7bda, 0x3fdcb01fd7577516,
    0xbfaa6c84e3f4e41d, 0xbfdf2adbf20c600c,
    0xbfe35746a6978ec2, 0xbfe0c2e2c1393078,
    0xbf80eb921792ec0c, 0x3fe203242c67e76f,
    0x3fe5489288a9d3c4, 0x3fddfeec20f02af2,
    0x3f6879017b8297cd, 0xbfe08b892b572016,
    0xbfe482aa7ff85ba8, 0xbfe1d4d6138dce30,
    0xbfb1a4358edccdc3, 0x3fe222051b425be2,
    0x3fe6280a79f2b7fc, 0x3fe143749afd069d,
    0x3f832bc43417f057, 0xbfda994777144d54,
    0xbfe6e6e876328d4b, 0xbfdd2353de23599b,
    0x3f8ed36318583bb9, 0x3fddf6c4228cb042,
    0x3fe67e9e91763085, 0x3fe057995f5591c0,
    0x3f7b170bb50c5966, 0xbfe08ec9abddc811,
    0xbfe8b036152e5110, 0xbfe2af539ba7a8a7,
    0xbf86aac302f53b2d, 0x3fde6959b487803b,
    0x3fe65c1f40693774, 0x3fdd98b84de0ba99,
    0x3fb2d0a3928db5e6, 0xbfdc222f08abacf6,
    0xbfe84e7b275e5893, 0xbfdf792ae2f9252b,
    0x3fb19fa49f518298, 0x3fe09f3556a060f9,
    0x3fe55a14b6f1a3f3, 0x3fdbbe8a2af4d87c,
    0xbf9a3ecfc659a2b2, 0xbfe3728a70f2446c,
    0xbfe4c33d28f98411, 0xbfdf9a1600f0b373,
    0x3fa20c9537fa909b, 0x3fde95cf138d994a,
    0x3fe66f96ca8ced52, 0x3fe036b6111bd69e,
    0xbfa6783b8cd6dc4f, 0xbfde593a0c94d800,
    0xbfe51e8ffcfae262, 0xbfe109c8788dcd6f,
    0xbfa04d0590c79b71, 0x3fdf9acec867e6a0,
    0x3fe7b5b1aced93ba, 0x3fe02eb0bba837b9,
    0xbfb65158a49d95a8, 0xbfdc53c8c4ce12ca,
    0xbfe46b5a3df2a63d, 0xbfe07b26cd7c42d3,
    0x3f89b277e3ff5d70, 0x3fe0eb930463933b,
    0x3fe9497a0156ac76, 0x3fe0b119e8636181,
    0x3f50d5b8a43d16ad, 0xbfe06c409409f4d8,
    0xbfe4e8076c424100, 0xbfdf2869bbe74bb9,
    0x3f8f0cfd1f6a0628, 0x3fe2305241126aea,
    0x3fe7785cba18d39a, 0x3fe079b8640d401e,
    0x3f7ec0733c0dd438, 0xbfd9fee61b984c8f,
    0xbfe759be158ebb9e, 0xbfddfe635eee5b82,
    0x3fa6c43352d88556, 0x3fe2601dd4da2506,
    0x3fe5ef7d28e50813, 0x3fdfbe04269aab21,
    0x3f9832c6403aabf5, 0xbfe176e17b1e2540,
    0xbfe83f8704b32d6e, 0xbfe246b4d13eb0ac,
    0xbf96cdc7bb3a049e, 0x3fdbcbba0943d1a2,
    0x3fe4496e60e29353, 0x3fde8e580354bcad,
    0x3fa78466476fe88e, 0xbfde70baae57cb01,
    0xbfe6107ec4caf4d5, 0xbfdc1c9c0d94cf33,
    0x3f8f9cd7cd588482, 0x3fe06b35daf1775a,
    0x3fe719badc1e58ae, 0x3fe47f0df1446704,
    0x3f800adc2e5006ca, 0xbfd944f77c97aa72,
    0xbfe4bff1e88fb3a8, 0xbfe1073e9d8b9f7f,
    0x3fae4a2d67c0b400, 0x3fdf3818f2e3cc1d,
    0x3fe8eb0738061d6a, 0x3fe03030af2f5883,
    0xbf58f32e3407bc38, 0xbfddd7b8cb558fdf,
    0xbfe848275a3c589c, 0xbfe0f585c61fc4fa,
    0x3fa2942e092ed21e, 0x3fe0ea2b47a56acd,
    0x3fe90c5a67849c2e, 0x3fe045093d14478d,
    0x3fb3ac5e6d14a5d2, 0xbfdd0726842c00e4,
    0xbfe6e21791d5e93c, 0xbfda00dce6da7bbd,
    0xbfa325cbc5d5e08a, 0x3fe0e770a79944c9,
    0x3fe8a5f80a589d67, 0x3fdd578302e313e0,
    0x3f9c0bb7f65385d8, 0xbfdf2ec4bfcbc632,
    0xbfe60567eb07b34a, 0xbfe040c9568bee95,
    0xbf91b7c60d4faf7f, 0x3fe08715030c19d3,
    0x3fe65831699a5b7a, 0x3fdf5314f233f121,
    0x3f87e70c62609e0c, 0xbfde20b038f9348a,
    0xbfe5043e25c58dfd, 0xbfdec22a03cb3eb2,
    0xbfa4adcbf9f4d562, 0x3fe0084af44f3911,
    0x3fe8080490336b34, 0x3fe0109bce434ce5,
    0xbf9af7b3d2412426, 0xbfe11f396d5de52b,
    0xbfe5a9765170d441, 0xbfe19b77f6520264,
    0x3fb5ef4164209aaf, 0x3fdf3a7335780ef4,
    0x3fe59e6fb5061b2c, 0x3fdd244276610316,
    0x3f95c417059f5f70, 0xbfdc66dd5517cbca,
    0xbfe7c3372a735f04, 0xbfe03ff8f3d61247,
    0x3f8edc8e0c89a350, 0x3fd95cc3673a4ea8,
    0x3fe2a2ae5d22b682, 0x3fe02d48c73a1c9c,
    0xbfb4ba71f5e51eaf, 0xbfdc55f04f96e1c5,
    0xbfe5641c921f086c, 0xbfdf829bccaef327,
    0x3fb065d2b190d883, 0x3fde72380bfef030,
    0x3fe2df48a2427c7a, 0x3fe137ec2a46f55d,
    0x3f50f0e5e05a5268, 0xbfdda0e6f8527474,
    0xbfe4b491adda31fe, 0xbfdca26b7cd50d02,
    0xbf9dacb327ebd607, 0x3fdefeec2534e804,
    0x3fe6eb68fa545dbb, 0x3fde1badcc424cc0,
    0xbf857acb72fc9637, 0xbfe0b829d9c0366b,
    0xbfe59a3d4c6db38a, 0xbfdc67da7b81df13,
    0xbf7b76fcdbe3a92d, 0x3fdcf3a2bfa52939,
    0x3fe4799843e478b0, 0x3fe13a4ebc82c63b,
    0xbf9e6823e15322c2, 0xbfe1175ee7dd1587,
    0xbfe813964723f3ec, 0xbfdc45aaf17756ee,
    0xbf72a5131f660583, 0x3fe38e222e1a5123,
    0x3fe889cd12338469, 0x3fdf9667385509aa,
    0x3fa5164a89221939, 0xbfe0d16ae6b417c3,
    0xbfe51887676f0f29, 0xbfe026c35e8481c6,
    0x3fa68dad72e3a276, 0x3fdcd7c6e01b7815,
    0x3fe56d147855e2a3, 0x3fdb618efa7b5680,
    0x3fa0d64df40c3b60, 0xbfda9b80077f9163,
    0xbfe7443be8dc88a0, 0xbfe0dd0b5864dfa3,
    0xbfb32f6f94cbe1e1, 0x3fdf39846c7ef77f,
    0x3fe31c071cf83d92, 0x3fdf11f85520419f,
    0x3fb984a614b0a8e1, 0xbfdd4a3c7a169583,
    0xbfe6ed21f8e2c150, 0xbfdd130ab22d1780,
    0x3f84f03d7ff18eba, 0x3fddcbf4da9a19e4,
    0x3fe2c8a013f40085, 0x3fe0b3f4cdf71cff,
    0x3fa4e1b2d41eda28, 0xbfe04fa9cdb21388,
    0xbfe62d76f1cf503b, 0xbfe29e8c16ca9fc3,
    0x3fb1400de6557d50, 0x3fdb47a9fed0a59e,
    0x3fe87883853ad291, 0x3fdc6943fb1b5002,
    0x3f8cb620550afe77, 0xbfdef070a5b6a990,
    0xbfe7c3777e422b54, 0xbfe22d58025d27f6,
    0x3fc0d625a8b7f714, 0x3fe01ca7ecf14111,
    0x3fe613ce9e5cc1f7, 0x3fd9438737730b95,
    0x3fa30c76bdd2bc42, 0xbfda8f3a3050c56b,
    0xbfe918135c5050df, 0xbfded245403f272b,
    0xbfb387b0994d5659, 0x3fdee8ff779f5308,
    0x3fe6f0bd47f692b3, 0x3fe3c23dfcd9939a,
    0x3fa67dc0320e5824, 0xbfe179e0edb6a617,
    0xbfea052aae741374, 0xbfe0f777be8c74e4,
    0x3fb2176bc3007415, 0x3fdbb5e6fd73bbc0,
    0x3fe9835e7621d56a, 0x3fdb9cf9d9ecf065,
    0xbf946d127e367d20, 0xbfe1cf1ac53b55c9,
    0xbfe66ca1945acce9, 0xbfe2581cc3a04f18,
    0xbf8e9598461cb363, 0x3fde7ffdd1181ef9,
    0x3fe69dfb75716f5f, 0x3fe110ed8416e05d,
    0x3fa4088b7854cf92, 0xbfdcaf69162b7895,
    0xbfe675208e111c77, 0xbfdd5f382642fe53,
    0xbf8ea819d6040081, 0x3fe169bb749803d0,
    0x3fe7fba59792ef7c, 0x3fddf3990cc9289c,
    0x3fb02d0ddffdec84, 0xbfe17c3505b71a35,
    0xbfe75c70c51fab01, 0xbfe2ab4b7fa698ca,
    0x3fa1fc888420b74c, 0x3fde9b7e57377b13,
    0x3fe4b34893878f85, 0x3fe094f42b3edefb,
    0xbfb6bd208dbe8bc7, 0xbfdefb3090b964b3,
    0xbfe77569652f0918, 0xbfddb548927f2635,
    0x3f82066ad8224010, 0x3fdbdd5608c4deaa,
    0x3fe6f9bb9536b000, 0x3fdde9fda760f8ae,
    0xbf2f3eaf2398aba1, 0xbfe083d5f19ddd5a,
    0xbfe6466e192d1965, 0xbfdcd801be00e2ca,
    0x3f44222404e04149, 0x3fe02ad2f329e5da,
    0x3fe69c09cd86fb18, 0x3fd8ad5f4e56fa34,
    0xbfadbcacce599137, 0xbfe156ebfb373223,
    0xbfe58013cd3217f3, 0xbfe04f0b68427379,
    0xbfa322c43da99716, 0x3fe31c3f763ebcc8,
    0x3fe64447a50eaebb, 0x3fe285a2c86f39e9,
    0xbfa9aaa358cfcf68, 0xbfdf0c0e57920d67,
    0xbfe685fe799c57bd, 0xbfe01b5fc0c29567,
    0xbf8bdff4d72a58ee, 0x3fe011a83bb3b8e2,
    0x3fe3e04bde4b342c, 0x3fe00260ae4c8a08,
    0x3fa52daa7b67a34e, 0xbfdd7b46b9f4c575,
    0xbfe8d0343ab770cd, 0xbfe02457b853a19e,
    0xbfb219b141776de6, 0x3fda3f31901abfa5,
    0x3fe48634e6390fa8, 0x3fd9ed7cb98f4a98,
    0xbf8af01264ced1a3, 0xbfe15ac888a8a96a,
    0xbfe6e6b4c6cc8502, 0xbfe18d9bdebf918f,
    0xbfa4e4402cedc71a, 0x3fdad429465d56ca,
    0x3fe55b2697545d35, 0x3fde60a8405d8c4c,
    0xbf7c41091ffbd525, 0xbfe116e42f3c8b1d,
    0xbfe483347651b7cc, 0xbfdbfff7d664d090,
    0x3fa410e6b462f324, 0x3fdcf701218c4394,
    0x3fe5b53b87df9aed, 0x3fe2ea09c08af485,
    0x3f9619f7bce621c8, 0xbfe00ab13658f018,
    0xbfe7a1483c6bca34, 0xbfdb995f16639698,
    0xbf71e372af001307, 0x3fde47fbcc97155d,
    0x3fe6bc00dc7ec929, 0x3fdde93dc1601c11,
    0x3f7af4fe989ae421, 0xbfdd79238d5a1925,
    0xbfe457f7eec3f566, 0xbfdceea7f196e675,
    0x3fae095b77f23ee0, 0x3fe0794568750c7d,
    0x3fe58d7ff0558d2a, 0x3fdcafc862f3946a,
    0x3f89ab53eb627798, 0xbfe0e4fcfbdba56f,
    0xbfe6a17c30892cb2, 0xbfe16e9f244f6404,
    0x3f82eadc52fc3bac, 0x3fe16a428a12ea95,
    0x3fe721323acc7d6f, 0x3fe1931290c4359f,
    0x3fb48699e7082cef, 0xbfd9d982148b5d36,
    0xbfe39e4f5005e7e9, 0xbfe0f33089da639f,
    0xbf8bc0cdbc8b3bea, 0x3fdf8b8cdbad66a0,
    0x3fe6b2e042f4699c, 0x3fe0b71b0c19e0de,
    0xbfa690a4ebdd378d, 0xbfe02cc35d00250f,
    0xbfe721ea333e412a, 0xbfdfe3ada1e2fedd,
    0x3f9fc1fbea73e82f, 0x3fdfe8842d0da6b5,
    0x3fe7a668ccbf40a2, 0x3fdeb1c470c3649e,
    0xbfb870f9480b2021, 0xbfdd93e77f4bc32b,
    0xbfe5da61b1871cbe, 0xbfe18b2781314882,
    0xbfbcc2bb581a4962, 0x3fdfb1db593ca861,
    0x3fe4e468151cc34a, 0x3fe3a05a7ae95797,
    0xbf9ab12a9d8d7cd8, 0xbfda3e7921dc8114,
    0xbfe57b23a01eafe2, 0xbfda8626780f5995,
    0x3fb2125cf286ddea, 0x3fe27e211ed7a26b,
    0x3fe839bd9a4b6c69, 0x3fdfc63c7e53a760,
    0xbfbbcc80b7809bfc, 0xbfdf061ab7a52dff,
    0xbfe8c1912e1659b7, 0xbfdc3a29c8c4feab,
    0xbf99e47908a532ee, 0x3fe09d9dc4b1c426,
    0x3fe50675c789cd07, 0x3fde5b5a71e1dbf3,
    0x3fa7f1343872c2fe, 0xbfe0c27fedd87eef,
    0xbfe4fdad5d8a9282, 0xbfdd328f3b00fd97
    };

static const uint64_t in_rifft_noisy_512[513] = {
    0x3ff1b860aa8827bc, 0xbfa9169604c2ec90,
    0xbfc3823e39686e28, 0xbff752fdc523ec68,
    0x3ffbb276927f5c8a, 0x3fe07fc3eab9f759,
    0x3fd1b8135a598062, 0xbfdd9703f343934a,
    0xbfdb8588232544a2, 0x3ff801cbe79bb7b6,
    0xbfb7d6617bca3d18, 0x3fad48c10fc5be70,
    0xbfed75b1ba8ed3e2, 0x3fc69447c8191c4c,
    0x3fd5b434b8e42aba, 0xbff0946929057113,
    0x3fe7bc7ed88d819b, 0xbfb89f807992bb51,
    0x3fe178418b0d6622, 0xbff62b36d7c66238,
    0xbfd5682316cc9b15, 0x3ff1d1c57ce9fe93,
    0x3fdfe550eb249ac3, 0x3fed79a99cfdbd74,
    0xbfe1c7615c10140a, 0x3fc9e9b7239132cb,
    0xbfe2269038e5dd5e, 0x3fdb2013bbe679b2,
    0x3fda076703e23c5e, 0xbff631296000b8fb,
    0xbfadc564c26850f1, 0x3fb29d587e3109d0,
    0x3fe33131889a74ef, 0x3ff327fa514b359c,
    0xbff507e071a4d878, 0xbfc8c94e1b07e578,
    0xbfd2e2e4bd1804b6, 0xbf9b512ffe5fb848,
    0xbfe11e6ab2e5206c, 0xbfff76ce00c63089,
    0xbff4f30ccd7e9bb7, 0xbff668b141ef2311,
    0xbfda56648b1fd0f5, 0xbfdd77f2ba60d5d0,
    0x3fd27164c528f5fd, 0xbff973475ddf531f,
    0x3fd663eafa94bd8f, 0x3ff501e67a24771f,
    0xbff1f4dde7ebaefa, 0xbff6433bc49a8e04,
    0x3fa817009c212266, 0x3fb2d919b56c6cd8,
    0x3ff0ffb089020383, 0xbfef1b39dd139ff9,
    0xbfe36dc12d97c5af, 0x3fb4fa776aa8ed0e,
    0xbfd5fdaca2565c88, 0x3ffd69e4263e1906,
    0xbfdb4093fe0f9144, 0xbfb3d7e762f4abb8,
    0x3ff16ec7b314045c, 0x3ff8d3a3b9334ee4,
    0x3fdc59dd47731f2a, 0x3fe8564a31f8bc64,
    0x3fe09d4e2f8c0939, 0x3fd3e2f9d060869e,
    0x3ffc77482ef8c747, 0xbff3f8ff6df6f4c9,
    0xbfc75e28f3acba51, 0xbfd4ed7b13348dd6,
    0x3feb236c87ce0a46, 0x3ff1161aa0bc21f0,
    0x3ffa1aebbe322de6, 0x3ff3f1d51c145853,
    0x3fb42063a7d70e1c, 0x3fc3299ebbd4ffa9,
    0xbfefa66d6e426c46, 0x3ffec1fee329557f,
    0xbfe4df048d731cbe, 0x3fe51699a4e6afa7,
    0xbfe33ae7fc783090, 0x3fec1386af95b68e,
    0xbfed05d6770358f3, 0x3fe130c19e50605a,
    0xbfdb113d7cf2712c, 0x3fd951e7f7db4530,
    0xbfe99b5e145aa7c1, 0xbfdfbbc1f2b91992,
    0x3fd1b24df355d27c, 0xbfea81dd6ed0ce12,
    0x3fe42a16f44ce7ae, 0x3fe6ded7f0f973d7,
    0x3fe935d647a800ac, 0x3f90220eaa85a830,
    0xbfd47dfc68baf355, 0x3fd6037bb2f3e04d,
    0x3fcd3e8ef422e1e9, 0xbfcf84cf7638799e,
    0xbfa44a5bdc2042a6, 0xbff856876ed4d54a,
    0x3fd253201a030bcf, 0x3fca8724e3678e18,
    0xbff0a9efe61af907, 0x3fcb9347fad85098,
    0x3fd58c33805e128a, 0x3fca1687c3f00ce8,
    0xbfe55c572d5437ee, 0x3fbdbdc63826fe5c,
    0x3fc4a2b042b25628, 0xbffa7bf8d2218188,
    0x4000f84e2cb79d6a, 0x3fdf137ccd6a556a,
    0xbfc82384392bc04c, 0xbfb8f576ee8b5260,
    0xbfb007b28b8029f8, 0xbfd1cfbbffdff40c,
    0xbf9e029a05b71960, 0x3fcaff7a82066afe,
    0x3fd36ff369aa95ca, 0xbfe982f78b215a86,
    0xbfef66938554e532, 0xbfba5ab149ea0678,
    0x3fe75b7c2b246893, 0xbfea0cc81f27cdbe,
    0xbfe0e751c795f39e, 0x3fe3cdd9be73bd11,
    0x3fe580472ee9fefb, 0x3fe00e29d53bcc88,
    0xbfa9a203a1c7eec0, 0xc06661091e0bde98,
    0x3fc18c0d2507489c, 0xbfd8b8b16a61412f,
    0x3fc3bdefd041e346, 0x3fda5f45afb9410e,
    0xbff66fb9dfade9d0, 0xbfe9afa2b47907e8,
    0x3ff2fbae791674fa, 0xbff10709d00e3078,
    0x3fc5870671b873f8, 0x3ff417cdd0d45e39,
    0xbfbe9c057dfc2b66, 0x3fa1bf76b350affc,
    0xbfef6cc78a68ce6c, 0xbfbbb01f198ab9dc,
    0x3fe2f7f24c0685f5, 0x3ff4ce72a0fbeb04,
    0x3fba82853f62b485, 0x3feeb3da8c0b31ca,
    0x3ff262bcaf44df11, 0x3fd91d052b8a2e2e,
    0xbfe0da939f1c7f35, 0x3fdcf2f70335ebb4,
    0xbfc9b4fe49bca8e1, 0xbfc17ca95ace9860,
    0x3fd6a9ee427a5c35, 0xbfc60fc5a6df42c4,
    0xbffd66967ef288f8, 0xbfdfe98063bfaf9b,
    0x3fe40df1750c83d8, 0x3ff57002dcc25792,
    0xbfd164bffd7e467d, 0x3fe02076b0e85c5a,
    0x3fe116be552bab56, 0xbfa5b1bb27bd2df4,
    0x3fe1a45a9579b3ca, 0x3fec6f14ea1f2278,
    0xbfe0b8541dd07d28, 0x3fe7c24aae595800,
    0xbfd1e63b4a08e46e, 0xbfe5043f2ae436ce,
    0x3faf65601d7885b0, 0x3ff6814c43ce50e4,
    0xbfedc4f30036d4de, 0x3fe43707a2072c98,
    0xbff05c4b7e915d22, 0xbfdb97e7b3cafb08,
    0xbfcd092e4f6db924, 0xbfd21756954ae3e4,
    0x3f9a03a530ea8db4, 0x3fa08becbb475220,
    0xbffc149cc1de0948, 0xbfd7c4bebb090d21,
    0x3fa64f51f3c32c40, 0xbfdcd6e5f6d32a40,
    0x3fe1894a3335b3f9, 0x3fedc061927a8849,
    0xbfebf36b3edadc26, 0xbfe0a1642fa4f378,
    0xbfd85bbfe16806bf, 0xbffbafcd089d52b6,
    0x3fd4086dbe2e08a5, 0x3fe9c291516ea8c6,
    0xbfb6f17f32c42308, 0xbfc5e3ce06e4568e,
    0x3ffc1339a5851493, 0xbfd01779943ace93,
    0x3fca4105380ca07f, 0x3fbdd3d38b81026a,
    0xbfd70829f35b42fa, 0xbfc9474379b45757,
    0xbff2447662b1c214, 0x3fe1f2a4e59aeb12,
    0x3fecbf24a672c6e4, 0x3ff103a04d0fe9e8,
    0xbfe17628dff397dc, 0x3ff49c9bb7bede48,
    0xbfeb622638bd108c, 0x3fce786988191396,
    0x3fe38c00b322a8d5, 0x3fd4aeaae88f10d3,
    0x3ff06756bdd3dca4, 0x3f905ed0633d4b38,
    0x3fd1317cadf5b62e, 0x3fe0aec488eb4a10,
    0x3fd85c7cbc2a45e7, 0x3fdc5d335ff9e179,
    0xbfd02ee622a79783, 0x3f8a128152944bb8,
    0xbfdc6971eeeadc0f, 0x3fc287537103fc4f,
    0x3fdf587641ba18b8, 0xbfdd260ff99466a8,
    0x3ff490af510a2932, 0x3fd921e996b7defa,
    0x3fb0bc4da20c3a38, 0x3fe38dba3954bcfe,
    0x3febca9053abf582, 0x3fbb27c49f367e00,
    0x3fd4b0a711a5c384, 0x3fe91729d5156695,
    0x3feb0bc61870314c, 0xbff3f159baa751f9,
    0xbfd0ae69feeac8b7, 0xbff541ae2a866067,
    0x3fbd0cd700fbf96b, 0xbfd4d8c354011b8c,
    0x3ff0330d1ab1efc0, 0xbf304f9717329800,
    0x3fdcc548ad85be89, 0xbff7b434084fdc28,
    0xbfbe3e95555b4020, 0x3ff0bdc0badddaaa,
    0x3fe0a27186140df1, 0x3ff6f1b0fdea5564,
    0x3fdfaa767796159d, 0x3fe173d3d6ea1fff,
    0x3fe83b54043b3358, 0x3fe885185d7bd174,
    0xbfec00e32ee04362, 0xbff04e2e4d5bc218,
    0x3fa5acf82c84ec70, 0xbfebb1a7f3598727,
    0xbfdd28b3726aaa76, 0x3ff344abf9ee80f4,
    0x3fba88fcab1aec38, 0xbfe292e406de49d9,
    0x3fe2dfd20b0eaa57, 0xbff1ef69573a1370,
    0xbff6279adbbff800, 0x3fed36be70668543,
    0xbfd0e9484edd0d56, 0xbfdf55897050ea81,
    0x3fe121ab46b63b7d, 0xbfdb2b994ea118b2,
    0x3fb838f07447ddf4, 0xbfd4f1f8d69ce29a,
    0xbfd46ff1b01f6c5b, 0xbfec48fa826f3a64,
    0x3ff155d0b319b07f, 0xbfb73ec5f5841e3a,
    0x3ff5ced2b7b1c4b6, 0x3fe885897319a89f,
    0xbfdb2a865141102e, 0xc000d18c237c9237,
    0xbfe60cc41da4b314, 0x3fea6edc49ea4ee3,
    0x3f626bc7dfc83300, 0xbff3fde80da1215c,
    0xbfd0201de7ed6710, 0xbff95fa639f05489,
    0xbfe07aa8406cd8fe, 0x3fd066928cc1c638,
    0x3fe59d1a63d4c978, 0x3fc0650438c96488,
    0xc0027160b5989242, 0x3ff1147e5ed80e2e,
    0xbfe6e3dbe13289f8, 0x3fe1206917987f18,
    0x3fd75f96c8cc2c3d, 0x3fe1412db0bcbc3c,
    0x3fb8bde3481859a8, 0x3ffed1fad6d84f8e,
    0xbfe469f746344e6e, 0xbfd2b61f6bf22db0,
    0x3ff1bf7942a016d5, 0xbfcbd8afce572cc3,
    0xbfb8842981c2dacc, 0xbfd0275e852d3c7a,
    0xbfe4aa03166a2a18, 0xbfe111609ef52be4,
    0x3fea825e1fa755a9, 0x3fe523c23937d13a,
    0xbfe5972ed85bd4ff, 0xbf92889ba9230498,
    0xbfea43955ac8c90d, 0x3fe43d89bf3f761a,
    0x3fd9df3621a34645, 0x3fd173c47486f83d,
    0xbfb36cdc999df2d0, 0x3fdeeb4fe49da327,
    0xbfb091471f0a7050, 0xbfde372e5a536d72,
    0x3fe420b599a7e523, 0x3fee7c9636dffe92,
    0x3ff08c101086778a, 0x3fc81a2e0876850d,
    0xbfcde1ce5480d675, 0x3fd85a7c7ee2096e,
    0x3fd1e867deabfb5c, 0xbfbdfca7078756d4,
    0xbfe5ee07f957e6d8, 0x3fd48d38e93863e3,
    0x3fc146912cd64fde, 0xbfc8680e1ebc1298,
    0xbfefcf97c89df700, 0x3feabee965c44ae5,
    0xbfb28745afb846dc, 0xbfb31b6ae3262aa0,
    0x3fe2c786a3838c65, 0x3fcf2a4db11e8b84,
    0xbfebefb5e2a9584e, 0xbfe2069fd201910e,
    0x3fc10c6f997bc954, 0x3fdfa4f54ef4230f,
    0x3fc4f0d9a4327064, 0xbfe1012f20ad7599,
    0x3fda7c81f917f30c, 0xbfce03cf9b6ae5e8,
    0xbfe2196a00fb6f9d, 0x3fe569616f1f67be,
    0xbfe444542b12e842, 0xbff0c06ae183da8c,
    0x3fe7c60f277f734b, 0xbfbdca890986d388,
    0x3fe37b8a99fa1f47, 0xbff2212a04637c4b,
    0xbfc8a29ba6e68d22, 0x3f87d684daf11560,
    0xbfc75d4dedbfa5e1, 0xbfdd45e16ad90a9b,
    0x3fc23891e7d88108, 0x3fd4b765a5f298f8,
    0xbfe9421fc62d3548, 0xbfe3a9e7ac15ea8c,
    0xbfecb6f0ac782770, 0x3fd50c64ae030eba,
    0x3f98299b57da7b20, 0x3fe7eecad7d860bc,
    0x3fedbbc18bbb8f92, 0x3fd84a4c63c7ad08,
    0xbfbb708ebbf6fb3e, 0xbfb797ba419013d0,
    0xbfdd2205790b9674, 0xbff393c519a0ef44,
    0xbfe612c5542e2e02, 0x3fd998fadb5c069a,
    0x3fd54f01a57af3ab, 0xbfebada98e2d0426,
    0xbfdec2baf629b032, 0xbfcdb4a4a7377274,
    0xbfecad171caa2d72, 0xbfed093f7d983c38,
    0xbfdaa980e01b8bea, 0x3fdc5f4466df07ae,
    0xbff95b2a8d213844, 0xbff58b1070f52f13,
    0xbfce548f33043364, 0xbfd631d9cf700514,
    0xbff6afd81c09081c, 0x3fc8f27652a7d99e,
    0xbfeffe8f7cf6d3ee, 0x3fc676534a1ec6e0,
    0xbfe6a5cc7c913ff9, 0x3fe01c00e6c15e0c,
    0x3fc066237532b050, 0x3febf0b5ec984380,
    0xbfed3ec04841f047, 0x3fe2ef6c1a412074,
    0x3fd377cb131fef2f, 0x3ff1bddfd8823f60,
    0x3fed4b93fbf1cbc7, 0x3ff22f8d80d084bd,
    0xbfd276a64cbb41c1, 0x3ff7b9f21313748c,
    0x3fe4c50b0000ce21, 0x3fef61c88cda6302,
    0x3fe9750f30628a25, 0x3fc76d31c5a5cf3c,
    0x3fe48d8e9ccdada1, 0x3fea69b78c887cca,
    0xbff2414bd6333ee6, 0xbff1cb27bd1f5e3e,
    0x3fdb82cef078d994, 0x3fefdccea8008c29,
    0xbff6443fbf0c01c5, 0xbfc0639565e8cff4,
    0x3fe400530c4c9934, 0xbfd1241d366f4e8d,
    0x3fae2bec299ee360, 0xbffee47c2f7256eb,
    0xbff767bac525a599, 0x3ff4408aaacf714d,
    0xbfaa5a9e35830e98, 0xbfc3ce76daa8d6d0,
    0x3f8d1fd5a258d868, 0xbfba6d89b593d210,
    0x3fd6110fde4f5e90, 0x3fba53165c940da4,
    0x3fd0c19ace07acad, 0x3fdf7ee9bec6e11b,
    0x3fd5802d7e480023, 0x3feba21b6d781b14,
    0xc00314fd96bc90a6, 0xbfed67af5beab503,
    0x3fbf145345280660, 0xbff05af846960715,
    0x3ff41bcd84610ba4, 0xbfb4ea888c0136f8,
    0xbfb6e5c7d9ca8c4a, 0x3fd9b99f7cb61df8,
    0x3fdf4ab52b744afa, 0xbfe645d687ecb178,
    0x3fc0117147ff331c, 0xbfe7af077627ce6e,
    0x3fcde631f14f4249, 0xbfefc0f0eb4c7f7d,
    0x3fe6b109563ec9b0, 0xbfe894a29985a836,
    0x3fb30f8229534750, 0xbfdc7e33c46c2c88,
    0xbfe43a3b56b8b557, 0xbff0cf4fa47da409,
    0x3fec64021c884250, 0x3fccaf7d1f12e4cc,
    0x3fcba86b745544cd, 0x3fb7c6821cb5e158,
    0x3fd08e65020fcc24, 0xbfc37b14b072ab08,
    0xbfcae0d18a2858a8, 0x3fb81939c07213ff,
    0x3fe806de48909987, 0xbfdf6f717dc60bd0,
    0xbfd16a3d202991b6, 0x3ff3fec11e6f0658,
    0xbff5817a2e626838, 0xbfdd6c38a957cad4,
    0x3fe496f710b52656, 0x3fdc388727917560,
    0x3fff062b1e76699c, 0x3fd4cb7f3d4c71ca,
    0xbff209b95a36afdd, 0x3fdb60111b18c40e,
    0x3fc57a1d9471cb9a, 0x3fdce44f78a3ebc0,
    0x3fdb2cf84bf55182, 0xbff251d8e971e140,
    0x3fd9303ef7cae0a1, 0x3ff309d83353e1d9,
    0xbff23ee695c7f28d, 0x3fb86b3a231349d0,
    0x3fdd71a2ef5f976f, 0xbff77872f09a97be,
    0x3febd6ec83b86b82, 0x3ff0036e604251dd,
    0xbfd04913349de0be, 0xbff4a46758e5e0f9,
    0x3ff4f6aa5dfe5c10, 0x3fbe53d2743c9a0a,
    0x3fc289275af354a8, 0x3ff3ad76dee031cc,
    0xbfe6cd810336d3c1, 0x3f6c349c26c92900,
    0x3fb670a7da315562, 0xbff1c71caa232064,
    0x3fe5698f71fd8c01, 0x3fe7d750ff556b4e,
    0x3fedb3eb6218083c, 0xbf93c20209d898e0,
    0x3ff5f1631c02f83e, 0x3fd1b89a7f55cb32,
    0xbf73a815c424a5c0, 0x3fdc92dad69a7903,
    0x3fdbe31e64429a87, 0x3fe85df1b9f6005a,
    0x3fe81248ef9734b6, 0xbfb6128e74c7fcc8,
    0x3fd893468a349b3a, 0xbfa3c8aad470d002,
    0xbfd78676a040439c, 0x3feffa64b3c55e1a,
    0x3fdb8e8ec44daf24, 0x3fed8baf4fa87363,
    0xbff5f696da8d395a, 0x3feb345d1ac9e91f,
    0xbfcf42a424f03e3d, 0xbfd65d8e7262f378,
    0x3fcc1a941064698d, 0x3fdc6948288d36d2,
    0xbff0083fa46b9598, 0x3fde7cbfc825fd6c,
    0xbfe4d818446e28b6, 0xbfb4dfcf6b379998,
    0x0
    };

static const uint64_t ref_rfft_noisy_512[513] = {
    0x3ff1b860aa8827bc, 0xbfa9169604c2ec90,
    0xbfc3823e39686e28, 0xbff752fdc523ec68,
    0x3ffbb276927f5c8a, 0x3fe07fc3eab9f759,
    0x3fd1b8135a598062, 0xbfdd9703f343934a,
    0xbfdb8588232544a2, 0x3ff801cbe79bb7b6,
    0xbfb7d6617bca3d18, 0x3fad48c10fc5be70,
    0xbfed75b1ba8ed3e2, 0x3fc69447c8191c4c,
    0x3fd5b434b8e42aba, 0xbff0946929057113,
    0x3fe7bc7ed88d819b, 0xbfb89f807992bb51,
    0x3fe178418b0d6622, 0xbff62b36d7c66238,
    0xbfd5682316cc9b15, 0x3ff1d1c57ce9fe93,
    0x3fdfe550eb249ac3, 0x3fed79a99cfdbd74,
    0xbfe1c7615c10140a, 0x3fc9e9b7239132cb,
    0xbfe2269038e5dd5e, 0x3fdb2013bbe679b2,
    0x3fda076703e23c5e, 0xbff631296000b8fb,
    0xbfadc564c26850f1, 0x3fb29d587e3109d0,
    0x3fe33131889a74ef, 0x3ff327fa514b359c,
    0xbff507e071a4d878, 0xbfc8c94e1b07e578,
    0xbfd2e2e4bd1804b6, 0xbf9b512ffe5fb848,
    0xbfe11e6ab2e5206c, 0xbfff76ce00c63089,
    0xbff4f30ccd7e9bb7, 0xbff668b141ef2311,
    0xbfda56648b1fd0f5, 0xbfdd77f2ba60d5d0,
    0x3fd27164c528f5fd, 0xbff973475ddf531f,
    0x3fd663eafa94bd8f, 0x3ff501e67a24771f,
    0xbff1f4dde7ebaefa, 0xbff6433bc49a8e04,
    0x3fa817009c212266, 0x3fb2d919b56c6cd8,
    0x3ff0ffb089020383, 0xbfef1b39dd139ff9,
    0xbfe36dc12d97c5af, 0x3fb4fa776aa8ed0e,
    0xbfd5fdaca2565c88, 0x3ffd69e4263e1906,
    0xbfdb4093fe0f9144, 0xbfb3d7e762f4abb8,
    0x3ff16ec7b314045c, 0x3ff8d3a3b9334ee4,
    0x3fdc59dd47731f2a, 0x3fe8564a31f8bc64,
    0x3fe09d4e2f8c0939, 0x3fd3e2f9d060869e,
    0x3ffc77482ef8c747, 0xbff3f8ff6df6f4c9,
    0xbfc75e28f3acba51, 0xbfd4ed7b13348dd6,
    0x3feb236c87ce0a46, 0x3ff1161aa0bc21f0,
    0x3ffa1aebbe322de6, 0x3ff3f1d51c145853,
    0x3fb42063a7d70e1c, 0x3fc3299ebbd4ffa9,
    0xbfefa66d6e426c46, 0x3ffec1fee329557f,
    0xbfe4df048d731cbe, 0x3fe51699a4e6afa7,
    0xbfe33ae7fc783090, 0x3fec1386af95b68e,
    0xbfed05d6770358f3, 0x3fe130c19e50605a,
    0xbfdb113d7cf2712c, 0x3fd951e7f7db4530,
    0xbfe99b5e145aa7c1, 0xbfdfbbc1f2b91992,
    0x3fd1b24df355d27c, 0xbfea81dd6ed0ce12,
    0x3fe42a16f44ce7ae, 0x3fe6ded7f0f973d7,
    0x3fe935d647a800ac, 0x3f90220eaa85a830,
    0xbfd47dfc68baf355, 0x3fd6037bb2f3e04d,
    0x3fcd3e8ef422e1e9, 0xbfcf84cf7638799e,
    0xbfa44a5bdc2042a6, 0xbff856876ed4d54a,
    0x3fd253201a030bcf, 0x3fca8724e3678e18,
    0xbff0a9efe61af907, 0x3fcb9347fad85098,
    0x3fd58c33805e128a, 0x3fca1687c3f00ce8,
    0xbfe55c572d5437ee, 0x3fbdbdc63826fe5c,
    0x3fc4a2b042b25628, 0xbffa7bf8d2218188,
    0x4000f84e2cb79d6a, 0x3fdf137ccd6a556a,
    0xbfc82384392bc04c, 0xbfb8f576ee8b5260,
    0xbfb007b28b8029f8, 0xbfd1cfbbffdff40c,
    0xbf9e029a05b71960, 0x3fcaff7a82066afe,
    0x3fd36ff369aa95ca, 0xbfe982f78b215a86,
    0xbfef66938554e532, 0xbfba5ab149ea0678,
    0x3fe75b7c2b246893, 0xbfea0cc81f27cdbe,
    0xbfe0e751c795f39e, 0x3fe3cdd9be73bd11,
    0x3fe580472ee9fefb, 0x3fe00e29d53bcc88,
    0xbfa9a203a1c7eec0, 0xc06661091e0bde98,
    0x3fc18c0d2507489c, 0xbfd8b8b16a61412f,
    0x3fc3bdefd041e346, 0x3fda5f45afb9410e,
    0xbff66fb9dfade9d0, 0xbfe9afa2b47907e8,
    0x3ff2fbae791674fa, 0xbff10709d00e3078,
    0x3fc5870671b873f8, 0x3ff417cdd0d45e39,
    0xbfbe9c057dfc2b66, 0x3fa1bf76b350affc,
    0xbfef6cc78a68ce6c, 0xbfbbb01f198ab9dc,
    0x3fe2f7f24c0685f5, 0x3ff4ce72a0fbeb04,
    0x3fba82853f62b485, 0x3feeb3da8c0b31ca,
    0x3ff262bcaf44df11, 0x3fd91d052b8a2e2e,
    0xbfe0da939f1c7f35, 0x3fdcf2f70335ebb4,
    0xbfc9b4fe49bca8e1, 0xbfc17ca95ace9860,
    0x3fd6a9ee427a5c35, 0xbfc60fc5a6df42c4,
    0xbffd66967ef288f8, 0xbfdfe98063bfaf9b,
    0x3fe40df1750c83d8, 0x3ff57002dcc25792,
    0xbfd164bffd7e467d, 0x3fe02076b0e85c5a,
    0x3fe116be552bab56, 0xbfa5b1bb27bd2df4,
    0x3fe1a45a9579b3ca, 0x3fec6f14ea1f2278,
    0xbfe0b8541dd07d28, 0x3fe7c24aae595800,
    0xbfd1e63b4a08e46e, 0xbfe5043f2ae436ce,
    0x3faf65601d7885b0, 0x3ff6814c43ce50e4,
    0xbfedc4f30036d4de, 0x3fe43707a2072c98,
    0xbff05c4b7e915d22, 0xbfdb97e7b3cafb08,
    0xbfcd092e4f6db924, 0xbfd21756954ae3e4,
    0x3f9a03a530ea8db4, 0x3fa08becbb475220,
    0xbffc149cc1de0948, 0xbfd7c4bebb090d21,
    0x3fa64f51f3c32c40, 0xbfdcd6e5f6d32a40,
    0x3fe1894a3335b3f9, 0x3fedc061927a8849,
    0xbfebf36b3edadc26, 0xbfe0a1642fa4f378,
    0xbfd85bbfe16806bf, 0xbffbafcd089d52b6,
    0x3fd4086dbe2e08a5, 0x3fe9c291516ea8c6,
    0xbfb6f17f32c42308, 0xbfc5e3ce06e4568e,
    0x3ffc1339a5851493, 0xbfd01779943ace93,
    0x3fca4105380ca07f, 0x3fbdd3d38b81026a,
    0xbfd70829f35b42fa, 0xbfc9474379b45757,
    0xbff2447662b1c214, 0x3fe1f2a4e59aeb12,
    0x3fecbf24a672c6e4, 0x3ff103a04d0fe9e8,
    0xbfe17628dff397dc, 0x3ff49c9bb7bede48,
    0xbfeb622638bd108c, 0x3fce786988191396,
    0x3fe38c00b322a8d5, 0x3fd4aeaae88f10d3,
    0x3ff06756bdd3dca4, 0x3f905ed0633d4b38,
    0x3fd1317cadf5b62e, 0x3fe0aec488eb4a10,
    0x3fd85c7cbc2a45e7, 0x3fdc5d335ff9e179,
    0xbfd02ee622a79783, 0x3f8a128152944bb8,
    0xbfdc6971eeeadc0f, 0x3fc287537103fc4f,
    0x3fdf587641ba18b8, 0xbfdd260ff99466a8,
    0x3ff490af510a2932, 0x3fd921e996b7defa,
    0x3fb0bc4da20c3a38, 0x3fe38dba3954bcfe,
    0x3febca9053abf582, 0x3fbb27c49f367e00,
    0x3fd4b0a711a5c384, 0x3fe91729d5156695,
    0x3feb0bc61870314c, 0xbff3f159baa751f9,
    0xbfd0ae69feeac8b7, 0xbff541ae2a866067,
    0x3fbd0cd700fbf96b, 0xbfd4d8c354011b8c,
    0x3ff0330d1ab1efc0, 0xbf304f9717329800,
    0x3fdcc548ad85be89, 0xbff7b434084fdc28,
    0xbfbe3e95555b4020, 0x3ff0bdc0badddaaa,
    0x3fe0a27186140df1, 0x3ff6f1b0fdea5564,
    0x3fdfaa767796159d, 0x3fe173d3d6ea1fff,
    0x3fe83b54043b3358, 0x3fe885185d7bd174,
    0xbfec00e32ee04362, 0xbff04e2e4d5bc218,
    0x3fa5acf82c84ec70, 0xbfebb1a7f3598727,
    0xbfdd28b3726aaa76, 0x3ff344abf9ee80f4,
    0x3fba88fcab1aec38, 0xbfe292e406de49d9,
    0x3fe2dfd20b0eaa57, 0xbff1ef69573a1370,
    0xbff6279adbbff800, 0x3fed36be70668543,
    0xbfd0e9484edd0d56, 0xbfdf55897050ea81,
    0x3fe121ab46b63b7d, 0xbfdb2b994ea118b2,
    0x3fb838f07447ddf4, 0xbfd4f1f8d69ce29a,
    0xbfd46ff1b01f6c5b, 0xbfec48fa826f3a64,
    0x3ff155d0b319b07f, 0xbfb73ec5f5841e3a,
    0x3ff5ced2b7b1c4b6, 0x3fe885897319a89f,
    0xbfdb2a865141102e, 0xc000d18c237c9237,
    0xbfe60cc41da4b314, 0x3fea6edc49ea4ee3,
    0x3f626bc7dfc83300, 0xbff3fde80da1215c,
    0xbfd0201de7ed6710, 0xbff95fa639f05489,
    0xbfe07aa8406cd8fe, 0x3fd066928cc1c638,
    0x3fe59d1a63d4c978, 0x3fc0650438c96488,
    0xc0027160b5989242, 0x3ff1147e5ed80e2e,
    0xbfe6e3dbe13289f8, 0x3fe1206917987f18,
    0x3fd75f96c8cc2c3d, 0x3fe1412db0bcbc3c,
    0x3fb8bde3481859a8, 0x3ffed1fad6d84f8e,
    0xbfe469f746344e6e, 0xbfd2b61f6bf22db0,
    0x3ff1bf7942a016d5, 0xbfcbd8afce572cc3,
    0xbfb8842981c2dacc, 0xbfd0275e852d3c7a,
    0xbfe4aa03166a2a18, 0xbfe111609ef52be4,
    0x3fea825e1fa755a9, 0x3fe523c23937d13a,
    0xbfe5972ed85bd4ff, 0xbf92889ba9230498,
    0xbfea43955ac8c90d, 0x3fe43d89bf3f761a,
    0x3fd9df3621a34645, 0x3fd173c47486f83d,
    0xbfb36cdc999df2d0, 0x3fdeeb4fe49da327,
    0xbfb091471f0a7050, 0xbfde372e5a536d72,
    0x3fe420b599a7e523, 0x3fee7c9636dffe92,
    0x3ff08c101086778a, 0x3fc81a2e0876850d,
    0xbfcde1ce5480d675, 0x3fd85a7c7ee2096e,
    0x3fd1e867deabfb5c, 0xbfbdfca7078756d4,
    0xbfe5ee07f957e6d8, 0x3fd48d38e93863e3,
    0x3fc146912cd64fde, 0xbfc8680e1ebc1298,
    0xbfefcf97c89df700, 0x3feabee965c44ae5,
    0xbfb28745afb846dc, 0xbfb31b6ae3262aa0,
    0x3fe2c786a3838c65, 0x3fcf2a4db11e8b84,
    0xbfebefb5e2a9584e, 0xbfe2069fd201910e,
    0x3fc10c6f997bc954, 0x3fdfa4f54ef4230f,
    0x3fc4f0d9a4327064, 0xbfe1012f20ad7599,
    0x3fda7c81f917f30c, 0xbfce03cf9b6ae5e8,
    0xbfe2196a00fb6f9d, 0x3fe569616f1f67be,
    0xbfe444542b12e842, 0xbff0c06ae183da8c,
    0x3fe7c60f277f734b, 0xbfbdca890986d388,
    0x3fe37b8a99fa1f47, 0xbff2212a04637c4b,
    0xbfc8a29ba6e68d22, 0x3f87d684daf11560,
    0xbfc75d4dedbfa5e1, 0xbfdd45e16ad90a9b,
    0x3fc23891e7d88108, 0x3fd4b765a5f298f8,
    0xbfe9421fc62d3548, 0xbfe3a9e7ac15ea8c,
    0xbfecb6f0ac782770, 0x3fd50c64ae030eba,
    0x3f98299b57da7b20, 0x3fe7eecad7d860bc,
    0x3fedbbc18bbb8f92, 0x3fd84a4c63c7ad08,
    0xbfbb708ebbf6fb3e, 0xbfb797ba419013d0,
    0xbfdd2205790b9674, 0xbff393c519a0ef44,
    0xbfe612c5542e2e02, 0x3fd998fadb5c069a,
    0x3fd54f01a57af3ab, 0xbfebada98e2d0426,
    0xbfdec2baf629b032, 0xbfcdb4a4a7377274,
    0xbfecad171caa2d72, 0xbfed093f7d983c38,
    0xbfdaa980e01b8bea, 0x3fdc5f4466df07ae,
    0xbff95b2a8d213844, 0xbff58b1070f52f13,
    0xbfce548f33043364, 0xbfd631d9cf700514,
    0xbff6afd81c09081c, 0x3fc8f27652a7d99e,
    0xbfeffe8f7cf6d3ee, 0x3fc676534a1ec6e0,
    0xbfe6a5cc7c913ff9, 0x3fe01c00e6c15e0c,
    0x3fc066237532b050, 0x3febf0b5ec984380,
    0xbfed3ec04841f047, 0x3fe2ef6c1a412074,
    0x3fd377cb131fef2f, 0x3ff1bddfd8823f60,
    0x3fed4b93fbf1cbc7, 0x3ff22f8d80d084bd,
    0xbfd276a64cbb41c1, 0x3ff7b9f21313748c,
    0x3fe4c50b0000ce21, 0x3fef61c88cda6302,
    0x3fe9750f30628a25, 0x3fc76d31c5a5cf3c,
    0x3fe48d8e9ccdada1, 0x3fea69b78c887cca,
    0xbff2414bd6333ee6, 0xbff1cb27bd1f5e3e,
    0x3fdb82cef078d994, 0x3fefdccea8008c29,
    0xbff6443fbf0c01c5, 0xbfc0639565e8cff4,
    0x3fe400530c4c9934, 0xbfd1241d366f4e8d,
    0x3fae2bec299ee360, 0xbffee47c2f7256eb,
    0xbff767bac525a599, 0x3ff4408aaacf714d,
    0xbfaa5a9e35830e98, 0xbfc3ce76daa8d6d0,
    0x3f8d1fd5a258d868, 0xbfba6d89b593d210,
    0x3fd6110fde4f5e90, 0x3fba53165c940da4,
    0x3fd0c19ace07acad, 0x3fdf7ee9bec6e11b,
    0x3fd5802d7e480023, 0x3feba21b6d781b14,
    0xc00314fd96bc90a6, 0xbfed67af5beab503,
    0x3fbf145345280660, 0xbff05af846960715,
    0x3ff41bcd84610ba4, 0xbfb4ea888c0136f8,
    0xbfb6e5c7d9ca8c4a, 0x3fd9b99f7cb61df8,
    0x3fdf4ab52b744afa, 0xbfe645d687ecb178,
    0x3fc0117147ff331c, 0xbfe7af077627ce6e,
    0x3fcde631f14f4249, 0xbfefc0f0eb4c7f7d,
    0x3fe6b109563ec9b0, 0xbfe894a29985a836,
    0x3fb30f8229534750, 0xbfdc7e33c46c2c88,
    0xbfe43a3b56b8b557, 0xbff0cf4fa47da409,
    0x3fec64021c884250, 0x3fccaf7d1f12e4cc,
    0x3fcba86b745544cd, 0x3fb7c6821cb5e158,
    0x3fd08e65020fcc24, 0xbfc37b14b072ab08,
    0xbfcae0d18a2858a8, 0x3fb81939c07213ff,
    0x3fe806de48909987, 0xbfdf6f717dc60bd0,
    0xbfd16a3d202991b6, 0x3ff3fec11e6f0658,
    0xbff5817a2e626838, 0xbfdd6c38a957cad4,
    0x3fe496f710b52656, 0x3fdc388727917560,
    0x3fff062b1e76699c, 0x3fd4cb7f3d4c71ca,
    0xbff209b95a36afdd, 0x3fdb60111b18c40e,
    0x3fc57a1d9471cb9a, 0x3fdce44f78a3ebc0,
    0x3fdb2cf84bf55182, 0xbff251d8e971e140,
    0x3fd9303ef7cae0a1, 0x3ff309d83353e1d9,
    0xbff23ee695c7f28d, 0x3fb86b3a231349d0,
    0x3fdd71a2ef5f976f, 0xbff77872f09a97be,
    0x3febd6ec83b86b82, 0x3ff0036e604251dd,
    0xbfd04913349de0be, 0xbff4a46758e5e0f9,
    0x3ff4f6aa5dfe5c10, 0x3fbe53d2743c9a0a,
    0x3fc289275af354a8, 0x3ff3ad76dee031cc,
    0xbfe6cd810336d3c1, 0x3f6c349c26c92900,
    0x3fb670a7da315562, 0xbff1c71caa232064,
    0x3fe5698f71fd8c01, 0x3fe7d750ff556b4e,
    0x3fedb3eb6218083c, 0xbf93c20209d898e0,
    0x3ff5f1631c02f83e, 0x3fd1b89a7f55cb32,
    0xbf73a815c424a5c0, 0x3fdc92dad69a7903,
    0x3fdbe31e64429a87, 0x3fe85df1b9f6005a,
    0x3fe81248ef9734b6, 0xbfb6128e74c7fcc8,
    0x3fd893468a349b3a, 0xbfa3c8aad470d002,
    0xbfd78676a040439c, 0x3feffa64b3c55e1a,
    0x3fdb8e8ec44daf24, 0x3fed8baf4fa87363,
    0xbff5f696da8d395a, 0x3feb345d1ac9e91f,
    0xbfcf42a424f03e3d, 0xbfd65d8e7262f378,
    0x3fcc1a941064698d, 0x3fdc6948288d36d2,
    0xbff0083fa46b9598, 0x3fde7cbfc825fd6c,
    0xbfe4d818446e28b6, 0xbfb4dfcf6b379998,
    0x0
    };

static const uint64_t in_rfft_noisy_1024[1024] = {
    0xbf4d16b75e40129c, 0x3fe26a3c9634f4b3,
    0x3fe6884a5c47b005, 0x3fdb07f6b37fd63d,
    0x3fb52162c4a2cd04, 0xbfe2d398f05aa2f1,
    0xbfe4f4a1f554c552, 0xbfdc3ee3e4778302,
    0xbf7e4edd42318a66, 0x3fdf1e67639efa63,
    0x3fe759ffce1770a5, 0x3fe0329345625139,
    0xbf8c8ef86c402f93, 0xbfdced0dc2627fbc,
    0xbfe7406c4489359c, 0xbfde1a3e90eadfc5,
    0x3fa3c7aeaea8fc32, 0x3fdc19a5bfff2035,
    0x3fe88035bfa61b9e, 0x3fdc4e989468da72,
    0xbfa020119426f6cd, 0xbfdfb4e89fc1989c,
    0xbfe824fcb85899e0, 0xbfda1a16736b9879,
    0x3f8e2731286f881e, 0x3fdacbe2e20f1d4c,
    0x3fe43c64fd3722cc, 0x3fe04eb307b335de,
    0xbf800b4c61caf077, 0xbfe0419fba962089,
    0xbfe8e9b7e7d1a9d1, 0xbfdf91d4606a5ce0,
    0x3f95906c17afbc1a, 0x3fdfe400c1fe9581,
    0x3fe50afd608033f2, 0x3fe2238861c2df9a,
    0x3fb43328712b94d4, 0xbfe174a8971937a1,
    0xbfe61211eeafadd0, 0xbfdf4a4953e9ac99,
    0x3faa6daa13e5a374, 0x3fe1bc6460bca4c0,
    0x3fe7535979f5f959, 0x3fdecd72181d9611,
    0x3fb22ed36f968b1a, 0xbfe289ddf54d6aad,
    0xbfe63738b6d97463, 0xbfdee18f340430ea,
    0xbfa0bd1b432d6dda, 0x3fdf3ef0773b84cb,
    0x3fe46168a3f64183, 0x3fdd184cabafbf57,
    0xbf8f5f148b743174, 0xbfe2c6885cb530a1,
    0xbfe6f862c543d19a, 0xbfddde5023b16133,
    0x3f7dd7e58732765a, 0x3fe02a58a96b26b7,
    0x3fe7a1d0a85ada0f, 0x3fdba813a70d1158,
    0xbfa5ea6f9e07dfbc, 0xbfdf7d0d07b30d87,
    0xbfe62cad66d8948d, 0xbfe051064ae243bb,
    0xbfb048cca122404e, 0x3fe07bea4d67317e,
    0x3fe56c2ce261117d, 0x3fdf155d565fa2a2,
    0xbf9aae197039aa31, 0xbfe0fe65fac65303,
    0xbfe524177f45b9e4, 0xbfddd4ffceabc5cf,
    0xbf9f51ac3ce41a5d, 0x3fe21bc2a4cc9d5d,
    0x3fe9131b4f697a29, 0x3fe19008d7f69301,
    0xbf944f82210704dc, 0xbfe011b4119cd94b,
    0xbfe7391caf21013d, 0xbfd7d95cc14a7685,
    0x3fb399a16738b698, 0x3fe16f0cd6254e54,
    0x3fe5feffbbf0b3e8, 0x3fdec5764a1ef11d,
    0x3fb80516e8d984b1, 0xbfe1bbb024c9191f,
    0xbfe4e6ac57b8ee27, 0xbfe2197cc0038e5b,
    0x3fa8b201bf83f633, 0x3fdfc6a30c4457a5,
    0x3fe5594e0f0d5560, 0x3fe04a36bd358ee3,
    0xbfa233d6c69c1bb7, 0xbfe15d9fcd5b71d9,
    0xbfe7c1587551a22c, 0xbfe432cd9a5ee95f,
    0xbf8b656c5d64299f, 0x3fde56258d7549fd,
    0x3fe5c95a5df7d1a1, 0x3fdd270a32322bfb,
    0xbfaca46f77817bfe, 0xbfe06ff116d31c9d,
    0xbfe838603281eea6, 0xbfe0aacb6375b593,
    0x3f6c6b30fb33d9f1, 0x3fddef5e58d3e33e,
    0x3fe6d9ac67764c0f, 0x3fe180eafc2e3e4a,
    0x3f8add9eeeabbca2, 0xbfe107fe7fabab19,
    0xbfe9e2c4ec560c55, 0xbfe0c6139325fbbb,
    0xbfb137bdd3b6c582, 0x3fde3931e3ecee9d,
    0x3fe4da06a4aa83f3, 0x3fdf2f00f94f16b2,
    0x3fad6e38e6b2f8dd, 0xbfde2f0bdd3eec76,
    0xbfe5c5b2b32a65be, 0xbfe1daffece34e95,
    0x3f8399b97e578982, 0x3fe104fd018ca081,
    0x3fe8a9c44f5a641a, 0x3fe09c36e6f53f8e,
    0x3fa846d28ce82981, 0xbfe069978fe0dab0,
    0xbfe5aecae6524c2b, 0xbfdca75bed8a5ac8,
    0xbfb1b83579107400, 0x3fe0ba93a0cba4ca,
    0x3fe66eff71a61782, 0x3fdf9f08427e45fc,
    0xbfba2ef385c501fc, 0xbfe1018170c7964c,
    0xbfe415c95087c0f2, 0xbfe08cad83b6ff81,
    0xbfa3fd2c0fe718fb, 0x3fe17357364e2761,
    0x3fe968b65002af85, 0x3fdadef9f7c33aeb,
    0x3fb02abf39106849, 0xbfdde9362660db81,
    0xbfe6a3d70e50386c, 0xbfdf249b2340fb2e,
    0xbfaaf637811a0eea, 0x3fdf2c66380f0f21,
    0x3fe84799621d5322, 0x3fdfa3d93cda85e5,
    0xbf9da6c7ff218e2f, 0xbfdd5c8364a2dc09,
    0xbfe69a6ce5f0ca98, 0xbfdeb7022a2c92f6,
    0x3f9d57e05cc44765, 0x3fe08ba175e6ccb8,
    0x3fe933f80a63631c, 0x3fda097a6bb5ab76,
    0x3fa9f928df1c37e5, 0xbfdda528a85372c9,
    0xbfe77843b9aa8179, 0xbfe0b8c634bb908a,
    0xbfa98395d7e814d6, 0x3fe13c3d291ff988,
    0x3fe6d0d0f940dd7b, 0x3fdb65cb95b7a04b,
    0x3fa3dfa940e2cbdf, 0xbfe11df432ec8902,
    0xbfe650b3d9874799, 0xbfddb57d0d54e9ec,
    0xbfb454b31c8feaba, 0x3fe19eb2b058507b,
    0x3fe7b1874e590880, 0x3fe180f727e154b3,
    0xbfa542616ef404fb, 0xbfe427daac878c3e,
    0xbfe50e540bc7cb16, 0xbfe2efaada2185af,
    0x3fa8c081ad10f62d, 0x3fdb74ac13a82236,
    0x3fe9a9560126e8cd, 0x3fe1e36eba9d8504,
    0x3f7462dac1d55514, 0xbfdac9813600805c,
    0xbfe7227ed82d43b9, 0xbfda2669ff0c96c8,
    0x3fb359da9bd82514, 0x3fe1c9da8fea5323,
    0x3fe7e941d035ed85, 0x3fde308dd72e3972,
    0xbf95363e7f2fd638, 0xbfe04fcaee9ac980,
    0xbfe8d2d06fe828d0, 0xbfe33d71a151aac8,
    0x3fa4cf17ffcfef4f, 0x3fe0176a68c24663,
    0x3fe8f2882d793568, 0x3fdd357cbc74210f,
    0xbf80a61847830dd7, 0xbfe0fb9cfb57bc76,
    0xbfe764eef2878ec5, 0xbfe0f5bb86e2e369,
    0x3f8bbd2772f3542b, 0x3fe1d2c152d3d60e,
    0x3fe567d5b8179eaf, 0x3fdcf5ce32fbb397,
    0xbf97ca4692b0ec5b, 0xbfe1bec0acc0725a,
    0xbfe7159c89919802, 0xbfdefc46d85232a9,
    0x3fa8d7be7cc637d8, 0x3fe06f054d946adc,
    0x3fe79414814bf500, 0x3fe3aec212f1abc4,
    0xbf6870c5ce42f553, 0xbfe0b8be528726bc,
    0xbfe6e3b142d38178, 0xbfde2e42bd5b87e0,
    0xbf921568c9964c06, 0x3fe093fad1f2b8df,
    0x3fe60503d6dce607, 0x3fe0132606c2a474,
    0xbf7d1440ae0c2692, 0xbfde492f8c984a1c,
    0xbfe5d19363eefcbb, 0xbfe044af9ca0c145,
    0x3fafac08ac98f28e, 0x3fdcc84749d29379,
    0x3fe7e9e3f9ac963f, 0x3fe02d88f269c3fe,
    0x3fa325dc869dcee4, 0xbfde97bddf666236,
    0xbfe73db73622de04, 0xbfdd75618143c6b2,
    0x3f505f2bb18f02a6, 0x3fddd6e40685b8e8,
    0x3fe763b558f71ba7, 0x3fe116cc8f96646d,
    0xbf7d325c2b6fb6d3, 0xbfe17b26358007f6,
    0xbfe72bf93f605dfa, 0xbfde1d1069b06da2,
    0x3fb9b50f268efa9b, 0x3fd6c6a21a14237c,
    0x3fe95c10cf136e88, 0x3fe12afbcf0f7bd8,
    0xbfab973e319ae429, 0xbfe1a333848dab83,
    0xbfe5f116d4cd4d9a, 0xbfdb359d87338049,
    0x3f57f5bf8d688240, 0x3fe093e78e00cee1,
    0x3fe31b117dae8c48, 0x3fe2de6a5b064c24,
    0xbfa78b7baa5cb6fa, 0xbfdbb1b25049d619,
    0xbfe6d4a0c49ca0f2, 0xbfde2479e536307d,
    0x3fb2dfe70c5bfd3b, 0x3fe2422ed74703ea,
    0x3fe85df69c43533d, 0x3fdd3230a0d001f6,
    0x3fa64eaadf8f1ade, 0xbfdd1922bad14c3e,
    0xbfe527d46c26ccb6, 0xbfe053e56df7d149,
    0x3f6f00f7af7bd184, 0x3fddec413b2c70f1,
    0x3fe26fe3f2d85570, 0x3fdbe8a3ba3a160c,
    0x3f70166fbcbbc8ae, 0xbfdc52acb64ccdda,
    0xbfe5c50e822e7783, 0xbfe0602915cc493b,
    0x3f96a5e9227d8c5d, 0x3fe2079a70a7646e,
    0x3fe6c0bcf955400a, 0x3fd8a14f932d1e8c,
    0x3fb3ae1432e5385a, 0xbfe05b56b1ab00b1,
    0xbfe3dcf19203a81e, 0xbfe09a450666be19,
    0xbfac325726894023, 0x3fdf64af19d5bb05,
    0x3fe721d52ffdbe02, 0x3fdc5c8e0c174500,
    0xbfa0cf1b60f55604, 0xbfe2ae5ad63c7fce,
    0xbfe4014886ea3cd9, 0xbfd803c7ecc1e611,
    0xbf991e63ebe1dfa3, 0x3fdbe8b99f75528a,
    0x3fe5f8b6d0b6c664, 0x3fe0c2847bc02c18,
    0x3f2d7c10d8b09129, 0xbfde5ab3578f41ac,
    0xbfe75f68d34645cf, 0xbfe02c2369f207f7,
    0x3fb6948f8ac60871, 0x3fdf1d54ad443b73,
    0x3fe8d7da500dcab8, 0x3fdb90c6ec7b4f7a,
    0x3fb56d8509e12a00, 0xbfdc44d3432c9f4a,
    0xbfe3271b3cec1c59, 0xbfe0a94d0378f585,
    0xbfb53b533badec74, 0x3fe054c3f5adc459,
    0x3fe49d75cb0a690f, 0x3fe18675dc3bf88c,
    0xbf9ea702aa4f523b, 0xbfdc34176208fbda,
    0xbfe7ba3e9bdcb588, 0xbfe1b5e8bebaecd3,
    0x3f9234b14053d0f6, 0x3fe0fc5931e72c1c,
    0x3fe5e9b5111516fc, 0x3fdef54187cf00f8,
    0xbf948f484f99cabc, 0xbfe011c9d02af8c0,
    0xbfe76564ca3f69d8, 0xbfe13981c03119fc,
    0xbfa99c6b09d5c833, 0x3fdf34ce9abf1c3c,
    0x3fe68933b6f57092, 0x3fe07b52d4b16e01,
    0xbf903bbd57c7b0a0, 0xbfe13e2d72d2868d,
    0xbfe53aff9f1b640d, 0xbfe21eddaf45ef19,
    0xbfb330b34e13359a, 0x3fda92b340b431a8,
    0x3fe9194b82cd7b1c, 0x3fdbbdb6644bb4e8,
    0xbf74b4819b9a2e17, 0xbfe1b5211ca5b5b4,
    0xbfe7799c00d74be5, 0xbfdd828cc00d9598,
    0x3f94837e1ea15a48, 0x3fde6919acded804,
    0x3fe4e7deb8d298f7, 0x3fe11875ca68ac65,
    0x3f97ad48ce2279c8, 0xbfdea43f4bcefc6c,
    0xbfe5ba79872b4c46, 0xbfe08bfb91352009,
    0x3facd523867cfb94, 0x3fe1c07e8c71707f,
    0x3fe63009e6271ca1, 0x3fda777c51107314,
    0x3f9baa72187e9892, 0xbfddbd2b71b7ba2e,
    0xbfe722ccecbeddea, 0xbfdaf94818116a87,
    0xbf51b26c9394d27a, 0x3fddc99760ef5760,
    0x3fe7c3d6e493b6fa, 0x3fddf07b3958ab48,
    0x3fa954e7f3e67015, 0xbfe2b2e52700aa40,
    0xbfe608a861fb22a0, 0xbfe1677352dd4c15,
    0xbfa6c2427c13a3e7, 0x3fde4e14e1e3f17c,
    0x3fe6566015b5cc26, 0x3fe032235f9b67ca,
    0x3faaca20b64dcd65, 0xbfde6c0ad41d08a9,
    0xbfe78af9fe36c752, 0xbfd8b41fd6e8b258,
    0xbfadeb9cc8765eaf, 0x3fe0a6f039d231ff,
    0x3fe47cdccd260fce, 0x3fe1bd26bb31be58,
    0x3f94b1be10c60426, 0xbfde231dfb186290,
    0xbfe72af19867ca62, 0xbfe406bedcdcbb52,
    0xbfb23c638dcc1598, 0x3fdf8e1c65c5787f,
    0x3fe7392590f8f8d8, 0x3fe00fa40ec61bab,
    0xbf9be51b18b16737, 0xbfe2053f1629f40b,
    0xbfe6e5064ec8fb67, 0xbfe1eb316b097708,
    0x3f7b7fa4d8a637af, 0x3fe0ca45a00f5f03,
    0x3fe9d59575c3d1f2, 0x3fdfe323b2bf61cf,
    0x3f64853de2a9fced, 0xbfe01c5663461995,
    0xbfe5ffc4685c9b3d, 0xbfdd3972799b0482,
    0xbf8c05185feb11e3, 0x3fde55ceba48718f,
    0x3fe7096a798d7aa4, 0x3fe1227c712ab48d,
    0x3f998bea15aadd2a, 0xbfe0c2ee24fe7c72,
    0xbfe643f78107fef4, 0xbfe04630a077e257,
    0x3fa83f27046de456, 0x3fdca30b2a28ae1a,
    0x3fe40153446d4c36, 0x3fe021e9498e3425,
    0x3f9bf75bfd49e682, 0xbfdf04d5173f734b,
    0xbfe58b34101617c5, 0xbfdae14f08a3d288,
    0x3fb2ffb4cb263b17, 0x3fdf3f30b706a84b,
    0x3fe8f2d9fdd6935e, 0x3fe15bde00b4c61f,
    0xbfb1f6fb50fe939f, 0xbfdc405279bdac10,
    0xbfe83115bd3c1626, 0xbfde916e91649242,
    0x3f68e88dccfe21da, 0x3fe2d6629efa5449,
    0x3fe7700d2add5fd6, 0x3fdff1329348224d,
    0x3f9208ad75a3158c, 0xbfe0de717b91a65c,
    0xbfe5f07d68f18dce, 0xbfdd8b5f917e2522,
    0x3fae2a2fef00a5df, 0x3fe0ce0d6ad18ca7,
    0x3fe2edda20dc63f4, 0x3fe21c71e51a5a02,
    0x3fa87ac98047dbfc, 0xbfdda493e06c8325,
    0xbfe7ebf2ef10910f, 0xbfe143d715d5a80a,
    0xbf9cded2d0b2b770, 0x3fe002fd7bdced9d,
    0x3fe7e2dd2fd19515, 0x3fdb3bd42be959a7,
    0xbf96747df6285baa, 0xbfe2c3f491e6c4ba,
    0xbfe5be2e5fcfe6db, 0xbfde3146a34f82dc,
    0xbf92dd5f1a7bb338, 0x3fdae70763d6f06f,
    0x3fe6ad4d9975291c, 0x3fe0909472904bd8,
    0xbfadb1ca9c30d02d, 0xbfe0de116ab210a6,
    0xbfe469ea2da6c3ac, 0xbfddfb16523cb15e,
    0xbf92c2e3a80660a6, 0x3fdff0237aef9f02,
    0x3fe597f91cb48879, 0x3fdbf7d530ac42da,
    0xbf8053fba5df00ea, 0xbfe1057c2e882945,
    0xbfe42fcd867d220e, 0xbfdfd05099e40b94,
    0xbfbc42ea2580016b, 0x3fe01834dae14063,
    0x3fe7b2e8a778ad8a, 0x3fe273f3d2de7c8a,
    0xbfa98d45c5156394, 0xbfe2bd3f934dafb0,
    0xbfe6c3b1c3ddd0e6, 0xbfdc40e6eba2d5bf,
    0xbfa36c21456ebd98, 0x3fde9f30d6d92e0e,
    0x3fe79cc082381e33, 0x3fdc4afa84f07b8a,
    0x3faca37598b3b934, 0xbfdf13fb2cbe5cc6,
    0xbfe6d087aca61475, 0xbfe0639cb2313520,
    0xbfb30e32b762dce8, 0x3fdcc14e8241a33f,
    0x3fe5459c208587f5, 0x3fe0e89facefa6aa,
    0x3fa9d57fa673235d, 0xbfe2e8156aa13af5,
    0xbfe64fbb84679e87, 0xbfe0d24f7799a240,
    0x3fba59de62772b51, 0x3fde8eaedb1348c7,
    0x3fe51e14dc8b39a8, 0x3fe325b3a4d0d1ff,
    0x3f9a88c51053111a, 0xbfde87b77a33f0a5,
    0xbfe2456ed2985be0, 0xbfdedcd621ca78db,
    0xbf8f2f51744e25d4, 0x3fe223df35ead1b7,
    0x3fe7ff72a41c6b64, 0x3fe1358f3dd249fb,
    0xbf86b61e60a95fa8, 0xbfdf864bf0385820,
    0xbfe50e4dafc65f29, 0xbfdd7fdc0ea13790,
    0xbfb0d4ede2c4ed4b, 0x3fdf9143f7ce8e08,
    0x3fe537975f2d1648, 0x3fe05e653d48b2d6,
    0x3fb87c0ee1acc137, 0xbfdcc56df3ac658f,
    0xbfe91aac47c746be, 0xbfdb0d59b5a2ce61,
    0x3f822b94070b18e6, 0x3fe34b70d3b87d55,
    0x3fe6f2317ba67925, 0x3fe0f47bc74564bc,
    0xbf82e2b8db98adf7, 0xbfdb1829db92460f,
    0xbfe5100edbb75688, 0xbfde91f29be11dda,
    0xbf99388764b9a522, 0x3fdefd55a52644a6,
    0x3fe5dc940781d450, 0x3fe39a3d1eaee16e,
    0x3fa28781547123fc, 0xbfdf3b40b53df2e7,
    0xbfe896f8d36d9784, 0xbfe0aa795ede4913,
    0x3f7567a4259cb4f7, 0x3fe31f9e48169cbe,
    0x3fe88a72553ebab7, 0x3fe396bd496aabe5,
    0x3fa44218418a957e, 0xbfe0ee1cd0883165,
    0xbfe658ec00e14af7, 0xbfe3686914286ab1,
    0xbfb266203afa7236, 0x3fdbba7ff5f0f85c,
    0x3fe3b1a24425a4aa, 0x3fe02013f15d37a3,
    0x3f8001838609ede9, 0xbfe01f04baef2bc7,
    0xbfe83e3d32b6f2b2, 0xbfe0b1a7bd5437dc,
    0x3f9095ba46ed3b3c, 0x3fde8e8e31bc0712,
    0x3fe6c5f994482aec, 0x3fdd1716e60be7eb,
    0x3fc04c113c4e64cf, 0xbfe0852c395483a9,
    0xbfe8d5629737f6b1, 0xbfe21ba68f33fb9e,
    0x3f908b58493074b8, 0x3fdceb53e29cd994,
    0x3fe70cc06582f1cb, 0x3fddb14b9be9764a,
    0x3f9364fc05191415, 0xbfe11a5b977ab8a3,
    0xbfe6b8a46777b020, 0xbfde9d5fcb21149a,
    0xbfae4c480fc15f0b, 0x3fe14e206368ad49,
    0x3fe72695633572fd, 0x3fd929c11c5b704f,
    0x3fa517334276e8d6, 0xbfe048a57d0b33bd,
    0xbfe7dc49122d8ab7, 0xbfd6c209a5d7315e,
    0xbfab294961348a97, 0x3fdb17ab97818da6,
    0x3fe5f0551eb75244, 0x3fe10f66455160fc,
    0xbf8af2d04c1f5724, 0xbfe1ec2b93d5a5d2,
    0xbfe5cdc617ff54d1, 0xbfda35a80224241a,
    0x3fb443048da28185, 0x3fdfac5cbb44e8e1,
    0x3fe504770680df90, 0x3fe12860541905f3,
    0xbf873a7a17477956, 0xbfe143324630b0c5,
    0xbfe565bee9e65c0f, 0xbfe18c50df671272,
    0xbfa8d220b9570378, 0x3fe19b23c67927f4,
    0x3fe7d69521cbf593, 0x3fd7e330987e2368,
    0x3fb9fe6eeb9897b0, 0xbfdd2baaa5ed5901,
    0xbfe827098c64ffc3, 0xbfe0aa1c59f25278,
    0x3f98e50465516a2c, 0x3fdcff85e145fdbc,
    0x3fe4466810f4c4c3, 0x3fdd683062bfea0c,
    0xbfb2c541c8ec038c, 0xbfdde87af9e419df,
    0xbfe6f6c707a6b32e, 0xbfdb600c0520e8f1,
    0xbf95197d1ca825f6, 0x3fdc9461a273c20a,
    0x3fe55b13b55f1fa1, 0x3fdd06f5c70abc9a,
    0xbfaa438d0ac7f9c0, 0xbfe0898299e1e412,
    0xbfe77e2d38bbe6cd, 0xbfded27f9b1b2a39,
    0xbfa88a9bea9b9544, 0x3fe01991c1fdf5d6,
    0x3fe6ec6d4320f7d2, 0x3fe1534f71463807,
    0x3fa1f587e72bf6c4, 0xbfe08bc9b926aaf6,
    0xbfe8142ececc99fb, 0xbfe10ae3a32d2b97,
    0x3f826d7b5e480b56, 0x3fdd4c4dc442a6b4,
    0x3fe721130e5fec69, 0x3fddb97b245f1fa0,
    0xbf9a4af782177dd3, 0xbfdc4b8f1b8ad3f7,
    0xbfe39c0ee9f4c91f, 0xbfda0dfcde490aa7,
    0xbf88d524ee7e3d80, 0x3fe07d47e0b69a38,
    0x3fe4cc33b5982da4, 0x3fdf0b2d50906145,
    0xbfa720d8b8d570e6, 0xbfe0b5790e6e67af,
    0xbfe92265d3497fb2, 0xbfdc03b3d543cb20,
    0xbfb4ae68ca94fb6e, 0x3fdd3de8a4014b2c,
    0x3fe5a9b5ded542df, 0x3fdc8eca0c597dd8,
    0xbf9aa6de691f5b7e, 0xbfdd227fd51c474c,
    0xbfe6067ff0f68fbc, 0xbfdbb2313422df48,
    0x3fb2b07dbed4635a, 0x3fe111692d8f174d,
    0x3fe6f544008804ba, 0x3fe1f65078f73f04,
    0xbfa105e801365d84, 0xbfda6b6ae3e2419e,
    0xbfe8a0f33d0830ff, 0xbfdd537e998ab2b0,
    0xbf95c9c4c6e5ebbe, 0x3fe0072d1c438e91,
    0x3fe724852ae2a204, 0x3fde55f9237a7e13,
    0xbfb198af55e3dfb7, 0xbfdb768124357ba0,
    0xbfe4b234de36e7e3, 0xbfdefffe2a2c9ac6,
    0xbfbc1ddee43d4780, 0x3fdffbd4de79f634,
    0x3fe6b48f09838ea5, 0x3fdc54269d0343b2,
    0x3faaa573aa630ab3, 0xbfe11bbb03637930,
    0xbfe5f6111b1d5ca5, 0xbfd9dbd77d7559bf,
    0xbf99e310527d8315, 0x3fe0feb23b740ef9,
    0x3fe59075b6fe5a56, 0x3fdc5c1234fd5e3c,
    0xbfa8124780ddb079, 0xbfdd657edf1244f5,
    0xbfe569fca030974c, 0xbfdd3a6b8e97d05b,
    0xbf743558331b86f0, 0x3fe00fd56c15c1ad,
    0x3fe66253dadf0ed4, 0x3fe011a0d76d154e,
    0x3fa318786dea957d, 0xbfdd12f38865560b,
    0xbfe6a9efeee8a7b4, 0xbfe0c9b892956e55,
    0x3fb3ec4636f21841, 0x3fe0e43159f9bd6d,
    0x3fe538e3a9dbb791, 0x3fe0ae242f500835,
    0x3f6220962ab66193, 0xbfe0466305821df7,
    0xbfe5b6f65f8da252, 0xbfdeb353a770d468,
    0xbfaa0eaa834c54a9, 0x3fe2908a31f01523,
    0x3fe5d3c56a785b48, 0x3fe1e890d2956a4b,
    0x3fb278108abbb14c, 0xbfe11b4e3ef56102,
    0xbfe5a458f8e459d9, 0xbfdc9a08f8d58caf,
    0x3f6e5b46b346c9a7, 0x3fe0c611c3c8629b,
    0x3fe6a69fc44e017f, 0x3fe022ab229f27d9,
    0x3f8971f9ed4b6a93, 0xbfdb65e9f89e2651,
    0xbfe64a9072f22a55, 0xbfe0095fb1f424a0,
    0x3f97489a0ede40b2, 0x3fe01ed8a82f2e0b,
    0x3fe7b51836be056f, 0x3fd9a6f08add6ae5,
    0x3f984b9557aac70c, 0xbfdd11fd76d2e018,
    0xbfe5f381b0f2525f, 0xbfdfc34e1df80d13,
    0x3f9482dbecc3c5cb, 0x3fe2a92107d2413f,
    0x3fe70d91b5f758ad, 0x3fe2a2e8f19cb95c,
    0xbf3014ea9d314059, 0xbfde797d36298cb9,
    0xbfe5ac544ef59e4e, 0xbfdc95c2e04c5450,
    0xbfa74208d4780316, 0x3fdd95a98d29fbc6,
    0x3fe6dd11b8395075, 0x3fdcd6b15dbb0a5c,
    0x3fb2c34266f06791, 0xbfe08ae6c20b2368,
    0xbfea0ac79ea4c43b, 0xbfdf8abdb5b96e59,
    0x3ef84e420a38816f, 0x3fe0fbbd538ba1bf,
    0x3fe36c7e4bf7fff2, 0x3fe19c7feb6e6284,
    0x3fb20b21dda592fd, 0xbfe01b56df1b7d79,
    0xbfe7a13f4dd9a4e9, 0xbfdde8224ce069d0,
    0xbfb145a94c4e48b7, 0x3fe07ef007a78225,
    0x3fe928514a3262b4, 0x3fe07b06de3a664c,
    0x3f5d4ea8d95dc013, 0xbfe15a5f07b455f3,
    0xbfe51644094666f9, 0xbfd7b2e47e30a32c,
    0x3f9e733a9a45c6d1, 0x3fe16dd73157df96,
    0x3fe5d5741394c0c8, 0x3fdf8f6d472061a0,
    0xbfa803daf60a4fea, 0xbfdd77a05a229f81,
    0xbfe56a153dc2eacd, 0xbfdea528e1cb06fc,
    0x3faf79ae7012d129, 0x3fe1c2d1d9f64e5e,
    0x3fe439f4c5514406, 0x3fe12edf89485f8b,
    0xbfb2f9c7264ebfaa, 0xbfdc2e056fd245e8,
    0xbfe7490045524e1a, 0xbfe11226b69aebb2,
    0x3f798970218e6ef2, 0x3fe0c8574357ff4a,
    0x3fe68089d2e00fb6, 0x3fdfc30f9bc7f1a1,
    0x3fb219e591c27dcb, 0xbfe12be8e26e9f19,
    0xbfe6eebad2938ab8, 0xbfde48d88eda45b0,
    0xbfa739c5b45a3dda, 0x3fe0b3ae3016e15f,
    0x3fe7b4514e497c08, 0x3fe0337736858315,
    0xbf4405625cc92446, 0xbfddcd81b0547a66,
    0xbfe53f5e4611d924, 0xbfe0302c80c95943,
    0xbf7283c197d4f6db, 0x3fdfa64e61be5183,
    0x3fe622c07b5b4d08, 0x3fdf894c96f11e5c,
    0x3f97cb79b38bf50c, 0xbfddab6372867c3e,
    0xbfe675d4f317e606, 0xbfd7d28a5311585c,
    0x3fa11f662c5a7f3b, 0x3fe27c53cb07b3c2,
    0x3fe4c997c6ee2dfc, 0x3fdfe5a3a65ceefa,
    0x3fa665b3cccd4603, 0xbfe0a8ae4f8ea501,
    0xbfe6314f753de9a3, 0xbfd7abd1b4d90bdf,
    0xbfb1bf96fbc0b3b4, 0x3fde28ba2cb74944,
    0x3fe706dd8592e804, 0x3fe1fa97ccf9e48e,
    0xbfb4d789b3a287b1, 0xbfdeced6d23f6274,
    0xbfe66e210ba0bb5c, 0xbfdff3d56ca1a7df,
    0x3f8d48432efe3f88, 0x3fdd0d0db54da131,
    0x3fe529662f5755b5, 0x3fe0d51bc630c03e,
    0x3fb0acc8690ae44d, 0xbfe0a0ef841b89d9,
    0xbfe7d17e077b90dc, 0xbfdb044ed2f74d2b,
    0xbf61e1e05785f809, 0x3fe25cb7cf9cae6c,
    0x3fe8b9cfab9a24b1, 0x3fdb00ef44ada81e,
    0xbfa13bc2e01f8da8, 0xbfdfa1b8e9bfa1fc,
    0xbfe85e49f95ce040, 0xbfde832e95f638cd,
    0x3fa5248c004f10dd, 0x3fe0cd641d2e0c0a,
    0x3fe5ee709c4741de, 0x3fddedde06e607b6,
    0x3f6a2ee8ce078959, 0xbfe09d1f5631aa9c,
    0xbfe8bf843f5fa70f, 0xbfe3879bd4f3aa67,
    0x3fa94c6e259be410, 0x3fdf89bdcf00ab72,
    0x3fe8ec4c6a96f599, 0x3fe024cec8ec20d6,
    0xbf91b254cfb529de, 0xbfe315c2ba9bb374,
    0xbfe672e795042182, 0xbfdbfd8740f48b1f,
    0x3f936047d368c24a, 0x3fdd0866c18a562e,
    0x3fe55878af90c7be, 0x3fe17f881c0ec448,
    0x3fb997760fe37362, 0xbfe27385a9fc516a,
    0xbfe719cf0701bb72, 0xbfdf75bfce6ca3aa,
    0x3f88fa5199dabab0, 0x3fd9d78d31f932b8,
    0x3fe71d91527e2850, 0x3fe1066d9e7334e4,
    0xbfa996175da6c6c9, 0xbfdd26cb97656389,
    0xbfe8d4d116b02aff, 0xbfdfe7fe1b1a2bbd,
    0x3fb777e574b1f5f4, 0x3fdb99463d9db273,
    0x3fe5e632bf9355dc, 0x3fe0795111d6754b,
    0xbf81b6902d7ccfab, 0xbfdfa1a6495856d1,
    0xbfe6479f2a3696ed, 0xbfde4b50ab3e2871,
    0x3fa8543e5bd46830, 0x3fe0b2ad5ec40ee5,
    0x3fe91cdbe1365a20, 0x3fe08b502defea44,
    0xbf7252d540e831e2, 0xbfda0b027acb09b5,
    0xbfe30e45b7a11598, 0xbfe09be3159f6020,
    0xbf801825308e08bf, 0x3fdb0984dd9de203,
    0x3fe7121358b54a94, 0x3fdf8ea8bd3160af,
    0x3f9e87d6a776e295, 0xbfdcbbfe898095f7,
    0xbfe53666014c848e, 0xbfdcd59e4b3865b8,
    0x3f991445d0475264, 0x3fe0110c58e72481,
    0x3fe7e0d2d58009ba, 0x3fe04033276f8214,
    0xbfa371daa86a773c, 0xbfe199cd60c01ba6,
    0xbfe639187f9c0982, 0xbfdb2e831f53d4f4,
    0x3faafbb1d3487f13, 0x3fe0254ef94647de,
    0x3fe6fbc0c9638cb2, 0x3fd8d9d6c66d7e59,
    0x3f910a19998828aa, 0xbfe1739dbd0ec881,
    0xbfe56a273318f00f, 0xbfde76d9b98e8901,
    0xbf55ad0357729df2, 0x3fe02cb19669ea77,
    0x3fe557ee6d0b1257, 0x3fdf977977fec4fc,
    0xbf959c68e7d49f35, 0xbfdec0ac44edc916,
    0xbfe5e6921aab0f4d, 0xbfe05b1b8aaf2f15,
    0x3f96d9a416561e1c, 0x3fde961bc3428099,
    0x3fe7175cf3cbc1b6, 0x3fe0ddc9430f35bc,
    0x3fa100bc1180b015, 0xbfde05298872a402,
    0xbfe63456bba628a7, 0xbfd85a8795026fc6,
    0x3f9e7d95dc4d9851, 0x3fe21ac4328b7fc6,
    0x3fe78dbee2b80abc, 0x3fd9cbf7e6177160,
    0xbfa35e5df993afdd, 0xbfdb936dc7be23fd,
    0xbfe776232c1e4180, 0xbfde449a1302f884,
    0xbfa04e53474adec5, 0x3fdcc6d2369ec90f,
    0x3fe50ccca73c6d66, 0x3fe0d89a625a367e,
    0xbfa543ec7e8cac15, 0xbfe05df99ec2d5ef,
    0xbfe7407c635ee076, 0xbfe27957e03bd787,
    0x3f93be22ddd5a2e4, 0x3fdead325f81bf37,
    0x3fe66ec4747b206d, 0x3fdf7fd42e0b6bd9,
    0x3f816195cee80a9a, 0xbfe055c8343e1bbd,
    0xbfe675ba74a57057, 0xbfdc1eb013e70960,
    0xbfb0e1413a44be97, 0x3fe001a58b8e1251,
    0x3fe5b4a50b4ea143, 0x3fdec96614d52ff5,
    0xbfb2ddd6410621be, 0xbfde444dc1f2a39a,
    0xbfe66f4a49c414ab, 0xbfe1716010c20163,
    0x3f9e9e8a3566d001, 0x3fe04e87d845a8a3,
    0x3fe7538aff1b2b88, 0x3fda3235e80a10df,
    0xbfb331b529dd94ac, 0xbfe10b46a31e1700,
    0xbfe5e8b3a7a365ee, 0xbfdb6d02c92bc369,
    0xbf943166e34a4023, 0x3fe0250249f04549,
    0x3fe56ff538a3349f, 0x3fe40448f714a260,
    0x3f9b5b117777b192, 0xbfe35f4217e3f238,
    0xbfe7c3348318cf60, 0xbfde30b2e7b86374,
    0x3f99e289b2bc0b85, 0x3fe087a114016dc2,
    0x3fe64beaf027549c, 0x3fdf6ccefbbb63c6,
    0x3f9e61308cd8ac72, 0xbfdf7f136c86265b,
    0xbfe5fe2359221d31, 0xbfddfdbcda5f7f4d,
    0x3fa9d3fe119a92c0, 0x3fe01f502f95cde4,
    0x3fe57cb58643dbbf, 0x3fe028e66259a0c6,
    0x3f6f5ef84363940b, 0xbfe1fe3627c07ade,
    0xbfe63db79a730f41, 0xbfdf9dbc5fe1af86,
    0xbfa12201af0704e6, 0x3fde06211ce6d2c9,
    0x3fe6c2d3b438026b, 0x3fda03f9209c7969,
    0x3f90c1bd1fc40ec8, 0xbfdcdd9ca7ea3462,
    0xbfe60da6178f82d7, 0xbfe0d32dcb7b1f9b,
    0x3f7e1013fb9f4ec7, 0x3fe07fd8829bc41c,
    0x3fe53b808c4ef455, 0x3fdc146c69d6b0e5,
    0x3fa6973f6cab6f44, 0xbfd8a151d6dfc528,
    0xbfe823d1b5aafed2, 0xbfe35b39d9e2e1a1,
    0xbfb35107c2fab5a6, 0x3fd7fe8c29678d1d,
    0x3fe5c2b0b92e9ded, 0x3fdd873f2c5dac94,
    0xbfa182811524b12f, 0xbfe0d262871116e8,
    0xbfe7d1651c3f136d, 0xbfdceb288855e11f,
    0xbfaa61e6bb28e158, 0x3fe24de39afb0fcd,
    0x3fe6d6f860d1fb0c, 0x3fdceae08aecce00,
    0x3fa44da4350c9d8f, 0xbfe308ff74d6b471,
    0xbfe5bb01673d3a36, 0xbfe34e8875be0e88,
    0xbfaaf477a4376eda, 0x3fdc7e1a736b0814,
    0x3fe85b117b11bce2, 0x3fe177979b259001,
    0x3fb0a8d2524fc506, 0xbfdfe1f3a44fb2be,
    0xbfe7feeca9454403, 0xbfdcb0195f1c0b7a,
    0xbf8b13015005b5d6, 0x3fdfcdc6f4e0ecf7,
    0x3fe6ab21909eb668, 0x3fe0f156397b5448,
    0x3fa57d6616cc49b1, 0xbfe289ccc5112afd,
    0xbfe425e6b8b470b4, 0xbfdd9c22f4e8b7ac,
    0x3fa83632aee9e3d8, 0x3fde34c14a789a5d,
    0x3fe63e5f08c431ad, 0x3fd9494afb512c45,
    0xbf9fb067b841863c, 0xbfdc5a037d80f90e,
    0xbfe516d7af4ef816, 0xbfdd92d77efe85d1,
    0x3fb1ffeee0942270, 0x3fdf85271895df4a,
    0x3fe6bcd199091d95, 0x3fdfe54a24b302f7,
    0xbfa1abe0bc9dfec3, 0xbfe1724ec43fd472,
    0xbfe3802525676da8, 0xbfe0f46b59fa593b
    };

static const uint64_t in_rifft_noisy_1024[1025] = {
    0x3ff92de7e36d859e, 0x3fd667f259db3e78,
    0xbfea82fed3716bb0, 0x3fef1f478d66866f,
    0xc000daeec11c5e50, 0xbfd42fa31eb0a384,
    0xbfd8f1a95ee05820, 0xbff13aafca665fb6,
    0x3ff296e6bb6e1f37, 0x3ff99adfcacc65e3,
    0x3f64534ec8384800, 0xbffd7806ca4ff692,
    0x3ffbc3c6708e4498, 0xbfeb48e891660b99,
    0x3fbb7b0bc7a133b0, 0x3fd3cebb3a1d45a0,
    0x400198e1e38e1b3e, 0xbfc0da9818fe4a80,
    0xbff6c6a25c494352, 0xbfcba45b3a1d0de7,
    0x3f85fb57509c3920, 0x3fe9fb05092d9da6,
    0xbfe7e4f261dcb926, 0xbff8be348d0f49aa,
    0x4000ad4d03ec1a6c, 0x3ff6d94661d936e7,
    0x3ff72c73ed072471, 0xbfc1c26cbf1b1dd0,
    0x3ff1d0afb2a30dea, 0x40033af0b208c025,
    0x3ff48b93a633d038, 0xbff47a83ee98a9ac,
    0x3fce9f5a7c6873b2, 0x3ff022a528419f6e,
    0x3fdcac163f7d7f6a, 0xbfcd79da06ed5330,
    0x3fe851f5b38903d4, 0xbfdd666fe3d2a232,
    0xc008d438ce350005, 0x3feafc7fb910a905,
    0xbff1e6255e2a24b7, 0x3fee5dd0b535fd62,
    0xbff9f4a68e97065c, 0xbfd2a30e5c427e4c,
    0xbfeb32f0a6a6555e, 0x3fee0a64aa2e9feb,
    0x3fc9ca9593f1f1dc, 0x3ff4023da20bd6b9,
    0x4000549b72e2502e, 0xbfde93bc9faa8bf0,
    0x3ff1b2dc01b216e6, 0x3fd363baa62eaf89,
    0xbfd609751e00fe34, 0x3ff2c7f9bf68a2f4,
    0x3ff0ca3b447ba090, 0x3fde631068add914,
    0x3fe82c7c6f16cef0, 0xc00404067f8d405f,
    0x3ff09f0327769f4f, 0xbffaa50b1bfb09e8,
    0xbfe2fa25558e5bb4, 0xbffaa6c0fd3825c3,
    0xbff4ea94117508c0, 0xbff215dcc732ecab,
    0x3ff3ce1282a84731, 0x3fa0e5c4ab0fb32c,
    0xbff4917c7e36883d, 0x3ff95cbbc12332cf,
    0x3fda3b0b39616f02, 0xbff2a3270f7ecf99,
    0xbff2bc72fa47c5b2, 0xbfe02c89ae6d6482,
    0x3fd314db927e8cb9, 0xbff2984d780c599a,
    0xbfdddfc0d61dec78, 0xbf9b8637316b4220,
    0xbfda0f318755a62a, 0x3fd65ebe5c7e2d8e,
    0x3fea67a7f0bcebc1, 0x3fd360aec40b3a7b,
    0x3ff22ff2867f7d1e, 0x3f9b13e5257caea0,
    0xbfe503609f2e05ab, 0xbfbddca0e824cc0e,
    0x3fecee54f46534e2, 0x3fc13af7977ac6de,
    0xc006e7e43640505e, 0x3ffbf342c20e43e8,
    0xbff62d9010869304, 0x3fc357a55c4ebc81,
    0x3fec1460273207b5, 0xbff94039c2f5f406,
    0xbff7010866f6f3e9, 0xbfd5fa4f61a60764,
    0xbfc89f30dea6240e, 0x3ff99930af692476,
    0x3fdd0311e242989f, 0x3ff7cb2cc02c3bff,
    0x3fb8733046da7cd8, 0x3fb7331f6b359358,
    0x3fe930aa5c30eb58, 0x3ff76c9d3f9e0220,
    0x3fee3a82ce8f3ff5, 0xbfe7965c3ea1fd5a,
    0x3fd888b45d8527ec, 0xbfc2b54bfc4e7750,
    0x3ff38d3375226bc7, 0xbfef1a3c6568a40c,
    0xbffdb89764f7d73a, 0xbfefbe3c952a8cb8,
    0x4004da2396d78df4, 0x3ff39d1207bb6f1d,
    0xbfe5226c22544010, 0x3fd87f9cc81e2bc4,
    0x3feaafd60cde35cf, 0xbfdff0c252efa5ef,
    0x3fea2101ba55c4d0, 0x3ff22724da5c9efa,
    0x3fc13d2b485281c0, 0x3fe8323c66265767,
    0xbfe35e582c2dfe5e, 0x3fa7a15ef9a1a860,
    0xbfb0def23c8cff20, 0x3f83a5d7a7155780,
    0xc00380b42ceeeb58, 0xbfdf08d884173ae8,
    0xbf7110eb74a7c400, 0x3fab20b20ab6dfa0,
    0xc002e71424472b04, 0xbfd9f5df250fd1d8,
    0xbfe48e83eec865ee, 0xbfc62b9185bd5fd1,
    0xc00181f86d7ae060, 0x4004292c76dd0239,
    0x3ff0f862d3f477ae, 0x3fc2894f5350fa18,
    0x3fec276b3cedae80, 0xbfe1c583c98aeb04,
    0xbfd5fe3283eb2fe3, 0xc00495636ff0a759,
    0xbfdf3ef9e321a376, 0xbff2e4c25e8aa776,
    0x3fa9232217d16600, 0x3fca971bb0d64796,
    0x3fe877e5b959a43d, 0x3ff3dd41ed561b70,
    0x3ff0bca4c7cad4a5, 0xbfebbb8425f17f72,
    0xbfd1ea3a3c6391a4, 0x3fc3d8077be08b0c,
    0x3fe9e54d2f2f0eeb, 0xbfebc498dd09fedd,
    0xbfc5ae4dcbc2340a, 0xbfd8134058a643e4,
    0xbff1a58ae0119216, 0xbfe05afa2cd6111d,
    0x4000bd5d354c96d3, 0x4000c90e71892833,
    0xbfce951adb8de184, 0xbf46170f234cc000,
    0xbfd012776ed4966a, 0xbff3f5bb44bbcb7f,
    0xbfd4887911432c12, 0x3fcc72f8d9d98518,
    0xbfd5dd186f3e4f27, 0x3fe6f73cdc87663e,
    0x3fefb53b6d480d2a, 0x3fd11df3993b91a6,
    0xbfeb6f2c5feceb8a, 0x3feaeb650133a68a,
    0xbfcd29eb16f6315a, 0x3fd989bd79dc90f6,
    0xbfd6646f7ef145dd, 0x3fe001c753623524,
    0xbfd78409f101d942, 0x3fc7bf6132ffb5aa,
    0x3fe796c4fd9300ce, 0x3ff25b94aa7d2080,
    0xbff5402d0054a25a, 0xbfd9f39f81b9354f,
    0x3fec711372d3f8d1, 0xbfcdea963e33261e,
    0xc000e20283102fa0, 0xbfeb4fa0735d90bf,
    0x3fa9fd4d8b5a5074, 0xbfec779b317fa40e,
    0xbff6ee879d959286, 0xbff7605212767ca2,
    0x3fe13c0a403114c0, 0xc00466cf67997891,
    0x3ff8e84bb082e39d, 0x3ff3be6087a01b31,
    0x3ff25433b44a9e7a, 0xbfe2e03b4bf69e27,
    0xbfe8adfb9b930017, 0x3fc90b16fd5d57bf,
    0xbfc53b1dadc0a5c0, 0xbfe2892d50e668fe,
    0x3fed13aded83d06e, 0xc006f30eb5646aeb,
    0xbfd50d9b3eba348c, 0x3fe868e4535a7d42,
    0xbfe895e438c36f5c, 0xbfefd8c85566f2ba,
    0x3ff1466d78ad6ba0, 0xbfe6d1c4a1c1bba6,
    0x3fee4070ea72462b, 0x3fddadfabec7950c,
    0xbfd05f285fcbb68c, 0xbff28deef375731f,
    0x3fe7b77f7595850a, 0x3fb738f255b5fea8,
    0x3ffaac38007e3698, 0xbfd4be2addffb63d,
    0x3fbfd5e940620fa0, 0x3fe2613e25badc56,
    0x3fed14f0e9bfef40, 0xbfea15deea65a163,
    0xbff31559b29ae768, 0x3fc13e1aa43a14cc,
    0x3ff24a06e1ca4264, 0x3ff0c904a4f0729c,
    0xbfe7edecc8318122, 0x3ff26540c213dd96,
    0xbfe89a8e6b23e9c8, 0xbfe1e80ec74c1afb,
    0x3fe39ed239e44c93, 0x3fc0ee454ebe5950,
    0x40026d2c9f0b2d93, 0xbfead873b4b21bd4,
    0x3fdf2dab2c51c6f6, 0x3ff5cd3d971e929c,
    0x3feb7fe7bd028023, 0x3fa124ac1e5eeece,
    0x3fc48e48985ff92e, 0xbfd1ad73eda6c430,
    0xbfa27663da35abc0, 0xbfff039f828347e4,
    0x3fd6bd4f965af771, 0xbfc606caa14315d8,
    0xbfc54dc188baea17, 0x3ffb46fd9f263648,
    0x3fd75ea6f6918de8, 0x4005cc65752ac38d,
    0xbfdba56d11aea2db, 0x3f96e440d7fecf20,
    0x3fac356693c57160, 0x3ff15d18a9518f69,
    0xbfed912d46eb837e, 0x3fc77989e1ddc540,
    0x3ffb4357a302117e, 0x3ff5e70ee145586a,
    0xbfc509e56b476722, 0x3fd1a972c42e02e6,
    0x40051270612dc0cc, 0xbff13a528ac89160,
    0x3ff33ada0eeb6da2, 0xc0767d785499e3b0,
    0x3fc8ce9b511529b0, 0x3fb3002040002d24,
    0xbff43115bc4fca02, 0xbfd3a2dc8a6b34b6,
    0xbff8719f1e9c0248, 0x3ffa7843653f6e78,
    0x3fddacdf1d586992, 0x3f87f54c078bc6a0,
    0x400776c5825cb4c4, 0xbff0f3e389e45e96,
    0xc0002f17c79d55fa, 0xc00018ea1b890b97,
    0x3fed7c5e3e6c936a, 0x3fe88bb0abdf2b20,
    0xbfd7b03c5ad3cc58, 0x3fd31980c3a3d0a0,
    0x3fe3c668eb184e78, 0x3fd6bbdca8476122,
    0xbf7c3ccf49c46080, 0xbff6904cd8d89d8f,
    0x3ff4372e50f4f47d, 0x3fe3a7b4175e0d96,
    0x3fe9fc5f94728f3c, 0x3fef5b8590bdd2f5,
    0x3fe8748e596c4c45, 0xbfe08169c9e33c86,
    0xbfc51b263e469a9c, 0x3ffe773efc63b112,
    0x4006ff0a2e4bdc7f, 0x3ff4d1e0ec7340f8,
    0x3fe678303013f9f3, 0x3fec3aa826baee08,
    0xbfe5fa3b699a0ef3, 0x3fd76c6a5a422de2,
    0xbfc5364e65769a84, 0x3fef0120b96776d1,
    0xbfea1864e3acbbc8, 0xbfd061cb70d552a0,
    0xbfe9f9a1203ed890, 0x3ff27abf7afbba88,
    0x3ff59397b828d7db, 0x3f74bf21a971b7a0,
    0xbfe921eb6d4e4038, 0xbfbcebb0a5f517e8,
    0xbff27a405155344f, 0x3fec972ac7b50cb2,
    0x3fb3e102cd581bac, 0xbff14d32b1c83fd0,
    0x3fdc459cbe5c2ec7, 0xbfc2a8bc5f3c0768,
    0xbfee7ca7d6194ad2, 0xbfd1a374139f53d6,
    0xbff5ebf084a69975, 0xbffa370e07eddaa4,
    0x3fe0b39e4d5c9530, 0xbfd84a2036d6fa08,
    0x3fe19ef1bd921174, 0x3fd7f3ba0239eed0,
    0xbff1448afc38448f, 0xbfe08bc7411c1f1e,
    0xbff13227cd94b466, 0x3fcb25263383b3f7,
    0x3fd8b748baeadf16, 0xbfed4d9f2ba4ed60,
    0x3f8d6bf8f359cb40, 0x3fe0b9edd9b8c4ec,
    0xbfefaf0a3e9a1ae6, 0x3feb64c0b7071749,
    0x3facb000f8353e84, 0x3fcecfc0a4b50114,
    0xbff9d2bc2462bee6, 0x3ff874e553da40c7,
    0xbfda13a11088a4b0, 0x3fd980516a840042,
    0xbffec3d92e146884, 0x3fbe0d30fbd95c50,
    0x3ff667fa0a12ed8b, 0xbfe77ddf7fb953b6,
    0x3ff50bdd51138f24, 0xbfe5d567cfe67cef,
    0xbfc90c22ef0d09a0, 0xbfbfc95e20304680,
    0x3ff8bf195a74cb77, 0x3fca9448fd4f4654,
    0xbff957307fe90272, 0xbfdf603742226d9c,
    0xbffcf3fa5674fb43, 0xbfd270a14343f6ae,
    0xbfd40e0eb9f5e672, 0xbff777e5fe283910,
    0x3fe2dac611fdc6cb, 0x3fd248cc16aaaac4,
    0x3ffaf51e5174ce74, 0xbfeb52fd57b048ea,
    0xbfb9f3b2fa8168b8, 0x3ff2134443829df8,
    0x3fd60220ef68e558, 0xc0014ebcc09637b4,
    0x3fc2f06e3c05910c, 0x3ff9a898035c0b5c,
    0x40005968f2ae1840, 0xbfce34256992fcc0,
    0x3fd9df8ed55d2941, 0xbfe0f751d269078f,
    0x3fef6d9ac74e6801, 0xbfe80b961e316eb7,
    0x3ff15ea08709b8a6, 0xbfe1ae55a340ea80,
    0x3ff70ac5c6b06878, 0x3f8cfb8de6e972e0,
    0x4000dbb02d84c5ec, 0xbfe414736f39fbb0,
    0xbfe822e9c83269d7, 0x3fd77efb71220c0a,
    0xbff04bf13b854a1a, 0x3fed6051817e2d67,
    0x3fc379d5198dfd04, 0xbfe752c22ea142ce,
    0xc0010ab1ea14998d, 0x3fb639d06bfb5304,
    0x3fd69da853e80c5d, 0x3fee9cd995d12da3,
    0x3f83e48087bd95e0, 0x3fe04e8e6ebe917e,
    0xc000398fae5c5dec, 0xbff6c98fdddc83ce,
    0x3ff076da4a0f9e85, 0xbfeea09126bf2a75,
    0x3ff18e0715b659cc, 0xbfe5877b802c9828,
    0x3fedb58195bf484e, 0x3fd87f1f357d476d,
    0x3feafdb9f92a7ece, 0xbfb02da65d9e7938,
    0xbff0c06bab034231, 0x40010dd9625b7a55,
    0xbff5c0c624da9947, 0xc00c56298231f2b9,
    0xbfd8dd6845a81fd8, 0x3ff98c1f1c208d5e,
    0x3fea25fdda3dbefe, 0xbfeb0cf8f7574e22,
    0xbff1556c7a0f6ed4, 0x3febc15246a967f7,
    0x3fcf9da5feb073ec, 0xc00074912b58daee,
    0xbfeaa8433c5b656c, 0xbfc665309df3f050,
    0x400710fdc783c374, 0x3fdc4ba182f0b45a,
    0xbfd4d8ceca5265f4, 0xbfe17120ad44586a,
    0x3fc4ea3371470556, 0xbfdd295650555327,
    0xbfd5c49c8a7a1c76, 0x3fd587166c70141c,
    0x3ff0ffee1ede08fe, 0x3ff86efa061b8134,
    0xbfdc650091f30ec8, 0xbfe90c54439c03a8,
    0xbfe0cd6056997543, 0x3febb6d2abbc1896,
    0x3fd5a3bc71afd2d8, 0x4006bd35de480b83,
    0x3fc56d245f2a589c, 0xbff52bffd6d98fc6,
    0xc0001cc7a2dcb946, 0xbfe999eda065e3a3,
    0xbff020b3ceaa393c, 0x3fdf71baf89279ce,
    0xbff77fea4b068052, 0x3fe07942e86a23ee,
    0x3fda856675e9921e, 0xbff9898379dba677,
    0xbfe796ebc3021fc6, 0x3ff609936c2a122c,
    0x3ffa3dedf8244af0, 0x4003ae0681204361,
    0x3fe4f839cb6c930f, 0xbfef5fa361245576,
    0x3fe9656dc4e1a17e, 0x3fe101ff8f3dd6ae,
    0x3ff49767a701f757, 0x40003be88a6f55f0,
    0xc000ddd6fb574c16, 0xbfd6becabaa2a1bc,
    0x3ffbada9b411ce2a, 0xbfe630412cbfa778,
    0x3fd63178bcb2112c, 0x3f835267b284dc00,
    0xbfe9db87d0055722, 0xc000f3c0437d8c18,
    0xbff26e9eea5680f6, 0x3ff55a65b3de1a76,
    0xbffda580632ef6ee, 0xbff9c9329046afca,
    0xbff599f615f35421, 0x3ff97e9aa57350ba,
    0x40008234c7b27038, 0x3fd7b0dbbfa84496,
    0x4005151f518ca118, 0xbfc1901f08325370,
    0xbff5041cea1c10e2, 0x3fbc18637dce6380,
    0xbff37ce549663dec, 0x3ff7592892d6f7f7,
    0xbfdcd703d18be467, 0xbfe98de1f7714758,
    0x3fe41bdc3e4fd0c8, 0xbfff3f775cd8c0da,
    0xbff1e7ef1d6aa05c, 0x3fc2a991b8c3b4e6,
    0x3fe286dcc43b7f58, 0xbfd9d1c20564b213,
    0xbfd19ae7df5a0f45, 0xbfddc5a0be516011,
    0xc0003ad9cf8c3ed6, 0xc0121e3d52499abc,
    0xbfe4afd77e6c8ba3, 0xbfd9b971c652fafb,
    0x3ff5846d0ba43fbb, 0xbfe78a7ec5f4ef0e,
    0xbfd2bcab7fa7de48, 0xbff6c6753fb883a0,
    0x3fe646c2aa637af3, 0xbfdba199ad7178f7,
    0xbfed454ebc111e83, 0xbf8429940996b880,
    0xbfe7d66661fc10ad, 0x4005786512fc8c72,
    0x3fe5a9145999e145, 0x3fdeb29a30f5c9f2,
    0xbfd8146107dcde68, 0x3fe5705f7f03e995,
    0xbfad7b49bebb0fc0, 0x3fde46702bfcf958,
    0xbfe644dc70c74405, 0x3ff37b954a09a76e,
    0x3fa4260dc82b2c30, 0xbfbfc401ffdf07e4,
    0xbff98e61befae3cf, 0xbff99305f87698ea,
    0xbfec9eb8bac3ad89, 0x3feb1b90c7a8de79,
    0xbfea6de9cc3a7670, 0x3ff1c14cef402e1e,
    0x3fef888cfb4ae0e7, 0x3ffc5a941c422a06,
    0xbfe065d5f10d3f4c, 0xbfe15914446eb349,
    0x3fefefe90fe96f9d, 0x3fe1817ed26109e3,
    0x3fd2778048cb8ac6, 0xbff08e8b3b2e6060,
    0x3fc2d326d1b620f0, 0x3ffa3822ba432c00,
    0xbfdb221f8ef17022, 0x3fdd11714c381e9c,
    0xbfe8a7cba09564f5, 0x3fe2426420e464d1,
    0x3feb580a6d63f3de, 0xbfe1ef05b4d210f3,
    0x3ff9439daeb84bc6, 0x3fd24892391e6d78,
    0x3fedbf15c5530eac, 0x3ff8c323f5332454,
    0x3fe266c78f6e7c1d, 0xc00038ed3a84ac18,
    0xbff04089a83361b5, 0x3fdd1fcfb589ddda,
    0xbff19a5dd7b173c0, 0xbfe5501b3481f52e,
    0x3fed731a2452fef1, 0x3fe197ab9651498b,
    0x3ffd55a5158f40ec, 0xbfb411a1228efea0,
    0xbfcf7e780a15b088, 0x3fa694bc91bb6d50,
    0xbfc2c105566186e8, 0xbfedb2631bd0bddf,
    0xbff5cdb403a4200e, 0xbfe134952b4a7e3e,
    0xbfebd2ff76b35367, 0xbfec7ef46d53f8e0,
    0x3fc2ecaa8b3cfce8, 0xbff3b4f77067b7b0,
    0xc0008e7d7f3cae4d, 0xbfe26748970a1279,
    0xbfe9958308bec7fe, 0x3ff8a2a42b6101ef,
    0xbffecbd751ae1a8a, 0x3fe6d06275744366,
    0x3fe9737b59a999de, 0xbff96a69a1b91832,
    0x3ff202fab9cbb9d3, 0xbff540fe4a12f916,
    0x3fb18f9f73ef4cdc, 0x3fe316d9d99da3da,
    0xbff1ed8cacb8fa00, 0xbfc7cc846522415c,
    0x3fc0c094298cabc9, 0xbff3b31142a50ab0,
    0x3feaecdc22172c6e, 0x3fd75cc34d1ae274,
    0xbff1548d8b42d19c, 0x3ff15b3f4f5d3fb9,
    0x401062f4500a96fe, 0x3ff1acbddc9132db,
    0xbfe2348952cff898, 0xbfeeb3690c103494,
    0xbfe85df2f9ed3d33, 0x3fc2c5867d99987c,
    0xbfe25e40bce4bc5e, 0xbfabff1c3c69cee0,
    0x3fe2ba9556b83208, 0x3fe4ef0b276302a4,
    0xbfd820575273d86a, 0x3f8663976dc12940,
    0xbff302ad81fc1ab0, 0xbff2cd4db0ef745d,
    0x3fc8911ba96f8ca8, 0xbff0273325f2748e,
    0xbf895dd1c08f8b00, 0x3fcf5f364fd73c02,
    0x3fdb5fd17b16084e, 0x3fbd23e8fab44850,
    0x3fe118c6dd4c949e, 0x3f679fe0b6ecb000,
    0x3fe078da3afa786a, 0xc001aeac440cb9de,
    0x3fe07d6a3100d473, 0x40016b2cdc06fa76,
    0x3fc2f47bfc51b9c4, 0xbfe7002b61232a15,
    0xbfae2b99ea18a2d8, 0x3fd46021565b3b8c,
    0x3fef006bb5649b2d, 0xbfeb6f49a4ded926,
    0x3f9887b18f416920, 0x3fed4eea8019a0e6,
    0xbfc5157c3a23246c, 0xbfb4ea1bfc320aa8,
    0x400051adea3da9ce, 0xbffcd03de8d2cf6c,
    0x3ff5e5f895441e4c, 0x3ff9408d9f799b4a,
    0xbfe1c0d934bbf75c, 0xbfd7ed673c48f668,
    0xbfec8c5b16814d41, 0x40006cfa902b9c4c,
    0xbff350aaab5e714e, 0x3fd437aee97c849c,
    0x3fe7a399d7747d2b, 0x3fefb7beba9dce94,
    0xbfcf23e5bf8d8220, 0xbfe06a55cb0dc20e,
    0x3fe7fc66a77edae6, 0x3fd69447b09fb391,
    0xbffc40df88c2d02d, 0xbffce6651bec3195,
    0xbfec71aec38b4b93, 0xbff394fb410b4b88,
    0xbff1d44fbdd8f568, 0xbfe1599702dd560c,
    0xbfe4cd6510565bd1, 0x3fdf2fb3930e34a4,
    0x3fc8595f523b2ecc, 0xbfe1c9908dd49155,
    0xbfd83fbe064cae44, 0xbff2ea308efaee41,
    0x4002650a138e0d87, 0x3fff306e1ed32086,
    0xbfded408f7cfa355, 0x3fd95044b637d838,
    0xbfee0ccf8b14b01a, 0xbff4f44cb71229d2,
    0x3ff2dc905b50c477, 0x3fd47486d2cb9a54,
    0xbfea512d3c24382a, 0xbfd86e2438858d05,
    0xbfc3413a48964750, 0x3fda36079aa150ad,
    0xbfd2f7d963717ad5, 0x3ff1b6fe9114c818,
    0xbfe69d8e0eda5236, 0xbff26cb2b602c6f4,
    0x3f71ee7a786fa3c0, 0xc0030dacef1f1e0c,
    0xbfc3347c44c23176, 0xbfeedb8b9b8e1f8d,
    0x3fe64f212b02a4f3, 0xbfc9b05a3bc3e31e,
    0xbffa636557826452, 0x3fa027b01c5cfeb8,
    0xbfb1204701362b68, 0xbfe422a5b38a209b,
    0xbff19d84838c4fa4, 0xbff7f6dd420b2cb2,
    0xbfe5cd25c1861f50, 0x3fd1dfb26534d71e,
    0xbfcb6cef17d6ca3c, 0x3fdf611971ab0f79,
    0x3fd873c4f1e9723e, 0xc00115434cfafae7,
    0xbfefb898458fe78f, 0xbfcaa929fc2ac924,
    0x3fdddb7ca844978f, 0xbfed98b7501b8d4d,
    0xbf4fec6ea0f99800, 0x3fe3d4ceaccd531c,
    0xbff89a7abc99776e, 0xbfd10d5aea595c70,
    0x3ff05981198aad14, 0x3fb378dd9f1265f0,
    0xbff3506ffcc8c4c0, 0xbffc59ca770b0300,
    0x3fe8d38ef5bfce08, 0x3fb5cb5e2ca0fae0,
    0xbff96d1de7431dc4, 0xbff9819c2668cce3,
    0x3fd7986ce5558184, 0xc00e800c1d4772b0,
    0x3ff2d62d8661215b, 0xbfd85d8fab8a0238,
    0x3fe9967c83011ae4, 0x3fe8da125cd7a33e,
    0xbfc5b8e8e9956478, 0x3ffb17b6b9973900,
    0xbff2477a7394ae0e, 0xc000591169176b5a,
    0x3fe766b051661f9d, 0x3fddffe9e699f242,
    0xbfdeab0ebafa0b8c, 0x3fe79740e075593c,
    0x3fe0247727aeea17, 0xbff1ba9105486732,
    0xbfe216a2c930b2f0, 0x3fe2d1b3f4780c5b,
    0xbfd1563af85f1f58, 0xbffaa66b12b5fd3f,
    0x3fe1263bac85ecfc, 0x3fcbbe9f7ea6480c,
    0x40023379c6145244, 0xbfd4cfdf41d24012,
    0xbfe7d030612008f3, 0xbfc7f61f9f141322,
    0x3fe6f99eeef32ae7, 0xbff7043f51b6af9c,
    0xbfff1656d1339e52, 0x3fc6743f15ea1c47,
    0xbfd40718ac78e630, 0xc0056a2e06ec0298,
    0x3fb483f1e0e16d10, 0xbfff9cc086093b14,
    0xbfce8797d3efd1a0, 0x3ff7b00876dfdb1c,
    0xbfeb2df803d6724a, 0xc007df69ef8d5bea,
    0x3feaac57eeb454c6, 0xbfe40f0ddbae42b5,
    0xbfe734f58ed90290, 0xbffbe98a193ec598,
    0x3fbc8beff785399c, 0xbfee43a0a5c2f2bb,
    0xbff1199c2f53c323, 0xbffcea2311b0568b,
    0xbfd4dd77e4130a2f, 0x3feb71d65712893d,
    0xbfe35bd9a46d018c, 0xbfd8e15a56f477a4,
    0x3fc811f81b668b86, 0xbfe78d8e1f6e1eaf,
    0xbfedd72821012120, 0xbffdd6cbb8c43408,
    0xbfe11b60e4c4ff63, 0x3ff50e29d080e1a6,
    0x3fcf2a76fc1c6e6c, 0x3fe720a98692c1ab,
    0xbfe3792cd5c18e35, 0xbfac19d4d9ca03e0,
    0xc0009da539a11eef, 0xbfe0aeb704497bcc,
    0xbff6407760a19526, 0x3ff47d9e498cc81a,
    0xbfe6a3376c86a015, 0x3ff0f7475f3de700,
    0x3fe65cbadc5b927c, 0xbff80918046f2bb6,
    0x3fe5d6136ea2d32a, 0x3fc03697931b33c3,
    0x3ff5bc60386054ca, 0x3fe57d9b83d1cb42,
    0xbfe3e7e30a060284, 0xbfc8343307617b94,
    0xbfc48a70ba8b3da0, 0xbfe381819028e6fe,
    0xbfe4692675d531a0, 0x3fc571fed2938b6e,
    0xbfdb85015a46dea4, 0x3fe39dd3748bf96b,
    0x3ffbd7d9e79308e8, 0x4002f794d9b08b11,
    0xbff09414578cc3c8, 0xbfe73fe89261778a,
    0x3faa32c0661bc990, 0xbff073e43b735b30,
    0xbff7e76ac2ac68d4, 0xbff8fb8dc3c3e824,
    0x3ff01e91b094a970, 0x3fe527a9cad66b2a,
    0xc00836ddd00f7f03, 0x3fec0840111fbf00,
    0xbfd2749104a8f70c, 0xbf92565b70ee3460,
    0xbfe564b95917c336, 0x3fc462b08a8e5558,
    0xc0002d10fee2db6b, 0x3fd0f3e53c19cb0e,
    0x3fd8d076094cbeec, 0xbfeb5fca6c094090,
    0x3fd4afac2f5398bc, 0x3fdc565c18b42bc4,
    0xbfbb975315222ebc, 0xbfabc17732990ad0,
    0xbfe40b3bd787523d, 0x3ff0721bab1b79e6,
    0x3fd71d5d74a065f0, 0x3ff01968c756ac7c,
    0xbfa9fe36067a1e58, 0x3fcbf8599e78906c,
    0x4004e670f1231a12, 0xbff0fc6d992514d8,
    0xbfe321b0056d58b0, 0xbff840a789b8efe0,
    0x3ff72987b227d8b0, 0xbf8304b73123c548,
    0x3fe1d675d0784ae1, 0x3fc7caea4ac45758,
    0xbff41ef8bbc8ab7e, 0xbffba13a1eaf35ec,
    0x3fe1d02cef38064f, 0xbfd00761ab5bdcb8,
    0x3ff436a3296ba8d4, 0xbf97d61e22985a20,
    0x3fd3be5751246a84, 0x3fa54071b89e0be0,
    0x3fed15192bde42ac, 0xbfe230bd499cac80,
    0x3fe50dd696c34fe8, 0x3ff135b4ebb4d8e8,
    0xc00117f7c5b65111, 0x3fd34f84474b9c0e,
    0x3ff7a4f7e9cc71c1, 0x3fc34ca45890553e,
    0x3fd84a25f032f598, 0xbfd6a9934c937719,
    0x3fffc13351ad3f8d, 0xbfd4f92558e1a05a,
    0xbff998b86e8524f7, 0xbfee79ff764eee5a,
    0xbff97c1d1339e8cc, 0xbffaf6b85657881d,
    0xc003737a7de4798c, 0x3fc67c22001d62fe,
    0xbfe246598e71e50c, 0x3ff96e36e98367c1,
    0xbfdf62e9fd4a495c, 0x3fa8d78d373cafc8,
    0x3fec4eda1ef17738, 0xbfe3fc292e95eb3c,
    0xbfc2e0a8aa42b6c8, 0xbfe92c397c1255e4,
    0xbfeb2646836b47b7, 0xbfd8cfe321aeb274,
    0xbfa11ccdc31c1b30, 0x3fee978236c306c5,
    0xbfda206917e4302c, 0x3fba8423d4e30c30,
    0xbfdd1adca61df177, 0xbfec5d6baf2671a5,
    0xbfbb614d3b9705c8, 0x3fe18d4599d23eac,
    0xbfdbeebf14342ee0, 0xc00a4ab8e7e191ba,
    0xbff70b720fe8c43b, 0xbfb5313910015d68,
    0x3fb217dde46064e8, 0x3ff21a2a14ab2e23,
    0xbfe4537c93b60a7b, 0x3fcadbcebbccebba,
    0x3ffbfa8f5e1e5bd3, 0x3ffcadbac923a434,
    0xbff0f9ceb72c7bb6, 0x3fe778bb2aa365ca,
    0xbfd123ad43133013, 0xbfcd12118e619346,
    0x3fde2a350c994d4f, 0xbff7ab248ce4a004,
    0xbfd8a4b2ba555cc5, 0x3fd8e7a074ab1044,
    0x3fe2dac085382bda, 0x3ffe5c4b80ad3c8c,
    0xbfec5ce9bf2cb8fa, 0x3ff4fb1258a398bf,
    0xbffcdbb219093cfc, 0xbfebcdf819b86600,
    0xbfdb5deb57dc0178, 0xbf8bff9e9f87a000,
    0xbffad177c1639cde, 0x3fbdf7c071a312b0,
    0xc000da9320f9c547, 0x3ffe93b0457f430a,
    0xc000a97ebec5da84, 0xbfef3841835285f5,
    0x3fe9420443890276, 0x3ff189da7c95a834,
    0x3ff72f23366c7b76, 0x3feb6a5a17036af5,
    0xbfd08296d455e7b4, 0xbff69009b7b6c286,
    0xbfe467895b77756d, 0x3fe9bd2aa86ff4ee,
    0x3fe63f3e10507007, 0x3fe4bb994d01a528,
    0xbff80a66eb5de231, 0xbf922a132c8b7a30,
    0xbfe75b9fd5586b9b, 0xc0077cf97a58b681,
    0x3ff03789c09027c7, 0x3ff3a287077b9656,
    0x3ffec626e21aa5e8, 0xc00368b447ec522b,
    0xbff3cf5b603bf05a, 0xbffccb86d82b14d9,
    0x3feb59c98217c3c2, 0x3fea2da988cb94d5,
    0x3f9d98c4b94ccc30, 0xbfe4a8f526f68da0,
    0x3ff362920c9c6715, 0x3fd09cf2466a47e0,
    0x3ffa1b3c18843656, 0x3fa2e4efba2c54c0,
    0x3fc7bb02eff20e10, 0x3fee1005ad2d1480,
    0xbff7ba3aaa6bc814, 0x3ffeb3399c2a8bf7,
    0x3ffade25b724c055, 0x4003e8fb3d0a0f18,
    0x400394cfb50ac2fa, 0x3ff6992170612626,
    0x3fc6a02490d0f320, 0xc008ae7dc0b53617,
    0xbfe4d21240f68cd5, 0xbfdb3b51a3f539fb,
    0xbfd7a004ccd67f50, 0x3fe1825bd1604991,
    0x3fed6cea988ca82e, 0x3fe5b311c21930c2,
    0x3ff1a00d5dae891e, 0x3fda9d20533d5664,
    0x3fb4c5bfb59ec120, 0x3ffb36c423bd529c,
    0x3ff53a0d90a3c7f5, 0x40094cc10d9d28eb,
    0x3fea31dab63abae7, 0xbfe49a8614d2be2a,
    0xbff5c0cd24abad6a, 0xbffcbe3c6ea25672,
    0x3f9808a3535088e0, 0x3ff79c14af25b006,
    0xbfe1018604356b6a, 0x3fec2f18a2f73002,
    0x3fecbd0a999f96da, 0xbfe9246cdca78fb4,
    0x3fe9b2ae2a16a466, 0x3fc0a04215f64b98,
    0xbff09ab0aefc0df8, 0xbfedcda4bad325e0,
    0x3fd1d00044d29df6, 0x3fc20539d6a2c32f,
    0x3fd62030f49bc43c, 0xbfaf102b377ab2d0,
    0xbfec40f98f6a692a, 0xbfe3d16991b4d856,
    0x3fd3a10bc7b2c1bc, 0x3fd44eb9768ef446,
    0xbfe481854f13cef1, 0xbff221616d401c88,
    0xbff71252a4ee6e7a, 0xbf9ecb1a907f07d0,
    0xbfd9d6442dc00108, 0x3ff7596f1261e3d8,
    0x3fcd9f96eafcb29c, 0xbff7a784a5ad2502,
    0xbfe0b21e065493fc, 0x3fe04fcc420366c6,
    0x3fff0fba11750eb8, 0x3fde475b557ec58c,
    0x3ff44d7af3f533e0, 0xbfcbc5c9398511ca,
    0xc002d85d6a8ecb70, 0xbfe175e82187dc46,
    0x3fef21d9fde8af0e, 0xbfc570028c5baf07,
    0x3fd5cfd4c792b5c9, 0x3fc745da1d656e70,
    0x3fd816ebf0b8e031, 0xbfe05f58d1963c16,
    0xbff1b400072bb3f1, 0x3feafacd01e2e96c,
    0x3fd759964aaca1cc, 0x3fc4b42b09d4f980,
    0xbf9504e7ea4ce8e0, 0x4001d9eef1ce2ea6,
    0x3fde18f02ced7b20, 0x3fe7bb9a9367830a,
    0x3fe097fbbf465d71, 0xbfcf523e8f0b5371,
    0xbfe4a42aeb7f18da, 0x3ff73d9942e7cdc3,
    0x3ff348e98694e6ea, 0xbfa8fb29462976c0,
    0x3f9a58c363b24040, 0x3fea102a7ec49597,
    0x3ffd50bdc2230774, 0xc000f54c71114626,
    0xbfeaf5f0167d145e, 0xbffa80f8f663a673,
    0x3ff5ce3afa344666, 0x3ff60e4f75be62c8,
    0xbfb252ede037e534, 0xbf92012e533f4a88,
    0xbfd4c717a063fcc8, 0xbffcc8e8aa8bff2c,
    0xbfec6915785166dc, 0xbf6f71840e833d00,
    0x3ff860b89610693e, 0xbfe7d6b2980a32b8,
    0xbfd2d6ab872db364, 0x3fe851cd309c72b5,
    0x3fe267a335f7716e, 0xbfe153259154cc08,
    0xbfc15d3c3d2879e0, 0x3fcc90266c960f58,
    0x3ff7dbf236701fc1, 0xbfc357eef65ebbe4,
    0xbfed01c90f3282d2, 0xbfdcf8cb6952b563,
    0x3fe75cc88a4c120b, 0xbfb3f908ed0f47a2,
    0xbffefab7e89dac0c, 0x3fa9a1e57020e362,
    0x3ff47a614421e29e, 0xbffda9f5da2eb810,
    0x3ffc880b739e63cc, 0xbfd87a625649a322,
    0x3fef432908b77fc4, 0xbfd2bc10ceeaff78,
    0x3fde73944069cd40, 0x3fead44899f3e10a,
    0xbfe0ef92d1c40ccb, 0xbfd8f27ea8c6398e,
    0x3fdf79c69a00de9c, 0xbff42e51fc959ce6,
    0x4001ea1adebf4d42, 0x4003d2990218bb4b,
    0x0
    };

static const uint64_t ref_rfft_noisy_1024[1025] = {
    0x3ff92de7e36d859e, 0x3fd667f259db3e78,
    0xbfea82fed3716bb0, 0x3fef1f478d66866f,
    0xc000daeec11c5e50, 0xbfd42fa31eb0a384,
    0xbfd8f1a95ee05820, 0xbff13aafca665fb6,
    0x3ff296e6bb6e1f37, 0x3ff99adfcacc65e3,
    0x3f64534ec8384800, 0xbffd7806ca4ff692,
    0x3ffbc3c6708e4498, 0xbfeb48e891660b99,
    0x3fbb7b0bc7a133b0, 0x3fd3cebb3a1d45a0,
    0x400198e1e38e1b3e, 0xbfc0da9818fe4a80,
    0xbff6c6a25c494352, 0xbfcba45b3a1d0de7,
    0x3f85fb57509c3920, 0x3fe9fb05092d9da6,
    0xbfe7e4f261dcb926, 0xbff8be348d0f49aa,
    0x4000ad4d03ec1a6c, 0x3ff6d94661d936e7,
    0x3ff72c73ed072471, 0xbfc1c26cbf1b1dd0,
    0x3ff1d0afb2a30dea, 0x40033af0b208c025,
    0x3ff48b93a633d038, 0xbff47a83ee98a9ac,
    0x3fce9f5a7c6873b2, 0x3ff022a528419f6e,
    0x3fdcac163f7d7f6a, 0xbfcd79da06ed5330,
    0x3fe851f5b38903d4, 0xbfdd666fe3d2a232,
    0xc008d438ce350005, 0x3feafc7fb910a905,
    0xbff1e6255e2a24b7, 0x3fee5dd0b535fd62,
    0xbff9f4a68e97065c, 0xbfd2a30e5c427e4c,
    0xbfeb32f0a6a6555e, 0x3fee0a64aa2e9feb,
    0x3fc9ca9593f1f1dc, 0x3ff4023da20bd6b9,
    0x4000549b72e2502e, 0xbfde93bc9faa8bf0,
    0x3ff1b2dc01b216e6, 0x3fd363baa62eaf89,
    0xbfd609751e00fe34, 0x3ff2c7f9bf68a2f4,
    0x3ff0ca3b447ba090, 0x3fde631068add914,
    0x3fe82c7c6f16cef0, 0xc00404067f8d405f,
    0x3ff09f0327769f4f, 0xbffaa50b1bfb09e8,
    0xbfe2fa25558e5bb4, 0xbffaa6c0fd3825c3,
    0xbff4ea94117508c0, 0xbff215dcc732ecab,
    0x3ff3ce1282a84731, 0x3fa0e5c4ab0fb32c,
    0xbff4917c7e36883d, 0x3ff95cbbc12332cf,
    0x3fda3b0b39616f02, 0xbff2a3270f7ecf99,
    0xbff2bc72fa47c5b2, 0xbfe02c89ae6d6482,
    0x3fd314db927e8cb9, 0xbff2984d780c599a,
    0xbfdddfc0d61dec78, 0xbf9b8637316b4220,
    0xbfda0f318755a62a, 0x3fd65ebe5c7e2d8e,
    0x3fea67a7f0bcebc1, 0x3fd360aec40b3a7b,
    0x3ff22ff2867f7d1e, 0x3f9b13e5257caea0,
    0xbfe503609f2e05ab, 0xbfbddca0e824cc0e,
    0x3fecee54f46534e2, 0x3fc13af7977ac6de,
    0xc006e7e43640505e, 0x3ffbf342c20e43e8,
    0xbff62d9010869304, 0x3fc357a55c4ebc81,
    0x3fec1460273207b5, 0xbff94039c2f5f406,
    0xbff7010866f6f3e9, 0xbfd5fa4f61a60764,
    0xbfc89f30dea6240e, 0x3ff99930af692476,
    0x3fdd0311e242989f, 0x3ff7cb2cc02c3bff,
    0x3fb8733046da7cd8, 0x3fb7331f6b359358,
    0x3fe930aa5c30eb58, 0x3ff76c9d3f9e0220,
    0x3fee3a82ce8f3ff5, 0xbfe7965c3ea1fd5a,
    0x3fd888b45d8527ec, 0xbfc2b54bfc4e7750,
    0x3ff38d3375226bc7, 0xbfef1a3c6568a40c,
    0xbffdb89764f7d73a, 0xbfefbe3c952a8cb8,
    0x4004da2396d78df4, 0x3ff39d1207bb6f1d,
    0xbfe5226c22544010, 0x3fd87f9cc81e2bc4,
    0x3feaafd60cde35cf, 0xbfdff0c252efa5ef,
    0x3fea2101ba55c4d0, 0x3ff22724da5c9efa,
    0x3fc13d2b485281c0, 0x3fe8323c66265767,
    0xbfe35e582c2dfe5e, 0x3fa7a15ef9a1a860,
    0xbfb0def23c8cff20, 0x3f83a5d7a7155780,
    0xc00380b42ceeeb58, 0xbfdf08d884173ae8,
    0xbf7110eb74a7c400, 0x3fab20b20ab6dfa0,
    0xc002e71424472b04, 0xbfd9f5df250fd1d8,
    0xbfe48e83eec865ee, 0xbfc62b9185bd5fd1,
    0xc00181f86d7ae060, 0x4004292c76dd0239,
    0x3ff0f862d3f477ae, 0x3fc2894f5350fa18,
    0x3fec276b3cedae80, 0xbfe1c583c98aeb04,
    0xbfd5fe3283eb2fe3, 0xc00495636ff0a759,
    0xbfdf3ef9e321a376, 0xbff2e4c25e8aa776,
    0x3fa9232217d16600, 0x3fca971bb0d64796,
    0x3fe877e5b959a43d, 0x3ff3dd41ed561b70,
    0x3ff0bca4c7cad4a5, 0xbfebbb8425f17f72,
    0xbfd1ea3a3c6391a4, 0x3fc3d8077be08b0c,
    0x3fe9e54d2f2f0eeb, 0xbfebc498dd09fedd,
    0xbfc5ae4dcbc2340a, 0xbfd8134058a643e4,
    0xbff1a58ae0119216, 0xbfe05afa2cd6111d,
    0x4000bd5d354c96d3, 0x4000c90e71892833,
    0xbfce951adb8de184, 0xbf46170f234cc000,
    0xbfd012776ed4966a, 0xbff3f5bb44bbcb7f,
    0xbfd4887911432c12, 0x3fcc72f8d9d98518,
    0xbfd5dd186f3e4f27, 0x3fe6f73cdc87663e,
    0x3fefb53b6d480d2a, 0x3fd11df3993b91a6,
    0xbfeb6f2c5feceb8a, 0x3feaeb650133a68a,
    0xbfcd29eb16f6315a, 0x3fd989bd79dc90f6,
    0xbfd6646f7ef145dd, 0x3fe001c753623524,
    0xbfd78409f101d942, 0x3fc7bf6132ffb5aa,
    0x3fe796c4fd9300ce, 0x3ff25b94aa7d2080,
    0xbff5402d0054a25a, 0xbfd9f39f81b9354f,
    0x3fec711372d3f8d1, 0xbfcdea963e33261e,
    0xc000e20283102fa0, 0xbfeb4fa0735d90bf,
    0x3fa9fd4d8b5a5074, 0xbfec779b317fa40e,
    0xbff6ee879d959286, 0xbff7605212767ca2,
    0x3fe13c0a403114c0, 0xc00466cf67997891,
    0x3ff8e84bb082e39d, 0x3ff3be6087a01b31,
    0x3ff25433b44a9e7a, 0xbfe2e03b4bf69e27,
    0xbfe8adfb9b930017, 0x3fc90b16fd5d57bf,
    0xbfc53b1dadc0a5c0, 0xbfe2892d50e668fe,
    0x3fed13aded83d06e, 0xc006f30eb5646aeb,
    0xbfd50d9b3eba348c, 0x3fe868e4535a7d42,
    0xbfe895e438c36f5c, 0xbfefd8c85566f2ba,
    0x3ff1466d78ad6ba0, 0xbfe6d1c4a1c1bba6,
    0x3fee4070ea72462b, 0x3fddadfabec7950c,
    0xbfd05f285fcbb68c, 0xbff28deef375731f,
    0x3fe7b77f7595850a, 0x3fb738f255b5fea8,
    0x3ffaac38007e3698, 0xbfd4be2addffb63d,
    0x3fbfd5e940620fa0, 0x3fe2613e25badc56,
    0x3fed14f0e9bfef40, 0xbfea15deea65a163,
    0xbff31559b29ae768, 0x3fc13e1aa43a14cc,
    0x3ff24a06e1ca4264, 0x3ff0c904a4f0729c,
    0xbfe7edecc8318122, 0x3ff26540c213dd96,
    0xbfe89a8e6b23e9c8, 0xbfe1e80ec74c1afb,
    0x3fe39ed239e44c93, 0x3fc0ee454ebe5950,
    0x40026d2c9f0b2d93, 0xbfead873b4b21bd4,
    0x3fdf2dab2c51c6f6, 0x3ff5cd3d971e929c,
    0x3feb7fe7bd028023, 0x3fa124ac1e5eeece,
    0x3fc48e48985ff92e, 0xbfd1ad73eda6c430,
    0xbfa27663da35abc0, 0xbfff039f828347e4,
    0x3fd6bd4f965af771, 0xbfc606caa14315d8,
    0xbfc54dc188baea17, 0x3ffb46fd9f263648,
    0x3fd75ea6f6918de8, 0x4005cc65752ac38d,
    0xbfdba56d11aea2db, 0x3f96e440d7fecf20,
    0x3fac356693c57160, 0x3ff15d18a9518f69,
    0xbfed912d46eb837e, 0x3fc77989e1ddc540,
    0x3ffb4357a302117e, 0x3ff5e70ee145586a,
    0xbfc509e56b476722, 0x3fd1a972c42e02e6,
    0x40051270612dc0cc, 0xbff13a528ac89160,
    0x3ff33ada0eeb6da2, 0xc0767d785499e3b0,
    0x3fc8ce9b511529b0, 0x3fb3002040002d24,
    0xbff43115bc4fca02, 0xbfd3a2dc8a6b34b6,
    0xbff8719f1e9c0248, 0x3ffa7843653f6e78,
    0x3fddacdf1d586992, 0x3f87f54c078bc6a0,
    0x400776c5825cb4c4, 0xbff0f3e389e45e96,
    0xc0002f17c79d55fa, 0xc00018ea1b890b97,
    0x3fed7c5e3e6c936a, 0x3fe88bb0abdf2b20,
    0xbfd7b03c5ad3cc58, 0x3fd31980c3a3d0a0,
    0x3fe3c668eb184e78, 0x3fd6bbdca8476122,
    0xbf7c3ccf49c46080, 0xbff6904cd8d89d8f,
    0x3ff4372e50f4f47d, 0x3fe3a7b4175e0d96,
    0x3fe9fc5f94728f3c, 0x3fef5b8590bdd2f5,
    0x3fe8748e596c4c45, 0xbfe08169c9e33c86,
    0xbfc51b263e469a9c, 0x3ffe773efc63b112,
    0x4006ff0a2e4bdc7f, 0x3ff4d1e0ec7340f8,
    0x3fe678303013f9f3, 0x3fec3aa826baee08,
    0xbfe5fa3b699a0ef3, 0x3fd76c6a5a422de2,
    0xbfc5364e65769a84, 0x3fef0120b96776d1,
    0xbfea1864e3acbbc8, 0xbfd061cb70d552a0,
    0xbfe9f9a1203ed890, 0x3ff27abf7afbba88,
    0x3ff59397b828d7db, 0x3f74bf21a971b7a0,
    0xbfe921eb6d4e4038, 0xbfbcebb0a5f517e8,
    0xbff27a405155344f, 0x3fec972ac7b50cb2,
    0x3fb3e102cd581bac, 0xbff14d32b1c83fd0,
    0x3fdc459cbe5c2ec7, 0xbfc2a8bc5f3c0768,
    0xbfee7ca7d6194ad2, 0xbfd1a374139f53d6,
    0xbff5ebf084a69975, 0xbffa370e07eddaa4,
    0x3fe0b39e4d5c9530, 0xbfd84a2036d6fa08,
    0x3fe19ef1bd921174, 0x3fd7f3ba0239eed0,
    0xbff1448afc38448f, 0xbfe08bc7411c1f1e,
    0xbff13227cd94b466, 0x3fcb25263383b3f7,
    0x3fd8b748baeadf16, 0xbfed4d9f2ba4ed60,
    0x3f8d6bf8f359cb40, 0x3fe0b9edd9b8c4ec,
    0xbfefaf0a3e9a1ae6, 0x3feb64c0b7071749,
    0x3facb000f8353e84, 0x3fcecfc0a4b50114,
    0xbff9d2bc2462bee6, 0x3ff874e553da40c7,
    0xbfda13a11088a4b0, 0x3fd980516a840042,
    0xbffec3d92e146884, 0x3fbe0d30fbd95c50,
    0x3ff667fa0a12ed8b, 0xbfe77ddf7fb953b6,
    0x3ff50bdd51138f24, 0xbfe5d567cfe67cef,
    0xbfc90c22ef0d09a0, 0xbfbfc95e20304680,
    0x3ff8bf195a74cb77, 0x3fca9448fd4f4654,
    0xbff957307fe90272, 0xbfdf603742226d9c,
    0xbffcf3fa5674fb43, 0xbfd270a14343f6ae,
    0xbfd40e0eb9f5e672, 0xbff777e5fe283910,
    0x3fe2dac611fdc6cb, 0x3fd248cc16aaaac4,
    0x3ffaf51e5174ce74, 0xbfeb52fd57b048ea,
    0xbfb9f3b2fa8168b8, 0x3ff2134443829df8,
    0x3fd60220ef68e558, 0xc0014ebcc09637b4,
    0x3fc2f06e3c05910c, 0x3ff9a898035c0b5c,
    0x40005968f2ae1840, 0xbfce34256992fcc0,
    0x3fd9df8ed55d2941, 0xbfe0f751d269078f,
    0x3fef6d9ac74e6801, 0xbfe80b961e316eb7,
    0x3ff15ea08709b8a6, 0xbfe1ae55a340ea80,
    0x3ff70ac5c6b06878, 0x3f8cfb8de6e972e0,
    0x4000dbb02d84c5ec, 0xbfe414736f39fbb0,
    0xbfe822e9c83269d7, 0x3fd77efb71220c0a,
    0xbff04bf13b854a1a, 0x3fed6051817e2d67,
    0x3fc379d5198dfd04, 0xbfe752c22ea142ce,
    0xc0010ab1ea14998d, 0x3fb639d06bfb5304,
    0x3fd69da853e80c5d, 0x3fee9cd995d12da3,
    0x3f83e48087bd95e0, 0x3fe04e8e6ebe917e,
    0xc000398fae5c5dec, 0xbff6c98fdddc83ce,
    0x3ff076da4a0f9e85, 0xbfeea09126bf2a75,
    0x3ff18e0715b659cc, 0xbfe5877b802c9828,
    0x3fedb58195bf484e, 0x3fd87f1f357d476d,
    0x3feafdb9f92a7ece, 0xbfb02da65d9e7938,
    0xbff0c06bab034231, 0x40010dd9625b7a55,
    0xbff5c0c624da9947, 0xc00c56298231f2b9,
    0xbfd8dd6845a81fd8, 0x3ff98c1f1c208d5e,
    0x3fea25fdda3dbefe, 0xbfeb0cf8f7574e22,
    0xbff1556c7a0f6ed4, 0x3febc15246a967f7,
    0x3fcf9da5feb073ec, 0xc00074912b58daee,
    0xbfeaa8433c5b656c, 0xbfc665309df3f050,
    0x400710fdc783c374, 0x3fdc4ba182f0b45a,
    0xbfd4d8ceca5265f4, 0xbfe17120ad44586a,
    0x3fc4ea3371470556, 0xbfdd295650555327,
    0xbfd5c49c8a7a1c76, 0x3fd587166c70141c,
    0x3ff0ffee1ede08fe, 0x3ff86efa061b8134,
    0xbfdc650091f30ec8, 0xbfe90c54439c03a8,
    0xbfe0cd6056997543, 0x3febb6d2abbc1896,
    0x3fd5a3bc71afd2d8, 0x4006bd35de480b83,
    0x3fc56d245f2a589c, 0xbff52bffd6d98fc6,
    0xc0001cc7a2dcb946, 0xbfe999eda065e3a3,
    0xbff020b3ceaa393c, 0x3fdf71baf89279ce,
    0xbff77fea4b068052, 0x3fe07942e86a23ee,
    0x3fda856675e9921e, 0xbff9898379dba677,
    0xbfe796ebc3021fc6, 0x3ff609936c2a122c,
    0x3ffa3dedf8244af0, 0x4003ae0681204361,
    0x3fe4f839cb6c930f, 0xbfef5fa361245576,
    0x3fe9656dc4e1a17e, 0x3fe101ff8f3dd6ae,
    0x3ff49767a701f757, 0x40003be88a6f55f0,
    0xc000ddd6fb574c16, 0xbfd6becabaa2a1bc,
    0x3ffbada9b411ce2a, 0xbfe630412cbfa778,
    0x3fd63178bcb2112c, 0x3f835267b284dc00,
    0xbfe9db87d0055722, 0xc000f3c0437d8c18,
    0xbff26e9eea5680f6, 0x3ff55a65b3de1a76,
    0xbffda580632ef6ee, 0xbff9c9329046afca,
    0xbff599f615f35421, 0x3ff97e9aa57350ba,
    0x40008234c7b27038, 0x3fd7b0dbbfa84496,
    0x4005151f518ca118, 0xbfc1901f08325370,
    0xbff5041cea1c10e2, 0x3fbc18637dce6380,
    0xbff37ce549663dec, 0x3ff7592892d6f7f7,
    0xbfdcd703d18be467, 0xbfe98de1f7714758,
    0x3fe41bdc3e4fd0c8, 0xbfff3f775cd8c0da,
    0xbff1e7ef1d6aa05c, 0x3fc2a991b8c3b4e6,
    0x3fe286dcc43b7f58, 0xbfd9d1c20564b213,
    0xbfd19ae7df5a0f45, 0xbfddc5a0be516011,
    0xc0003ad9cf8c3ed6, 0xc0121e3d52499abc,
    0xbfe4afd77e6c8ba3, 0xbfd9b971c652fafb,
    0x3ff5846d0ba43fbb, 0xbfe78a7ec5f4ef0e,
    0xbfd2bcab7fa7de48, 0xbff6c6753fb883a0,
    0x3fe646c2aa637af3, 0xbfdba199ad7178f7,
    0xbfed454ebc111e83, 0xbf8429940996b880,
    0xbfe7d66661fc10ad, 0x4005786512fc8c72,
    0x3fe5a9145999e145, 0x3fdeb29a30f5c9f2,
    0xbfd8146107dcde68, 0x3fe5705f7f03e995,
    0xbfad7b49bebb0fc0, 0x3fde46702bfcf958,
    0xbfe644dc70c74405, 0x3ff37b954a09a76e,
    0x3fa4260dc82b2c30, 0xbfbfc401ffdf07e4,
    0xbff98e61befae3cf, 0xbff99305f87698ea,
    0xbfec9eb8bac3ad89, 0x3feb1b90c7a8de79,
    0xbfea6de9cc3a7670, 0x3ff1c14cef402e1e,
    0x3fef888cfb4ae0e7, 0x3ffc5a941c422a06,
    0xbfe065d5f10d3f4c, 0xbfe15914446eb349,
    0x3fefefe90fe96f9d, 0x3fe1817ed26109e3,
    0x3fd2778048cb8ac6, 0xbff08e8b3b2e6060,
    0x3fc2d326d1b620f0, 0x3ffa3822ba432c00,
    0xbfdb221f8ef17022, 0x3fdd11714c381e9c,
    0xbfe8a7cba09564f5, 0x3fe2426420e464d1,
    0x3feb580a6d63f3de, 0xbfe1ef05b4d210f3,
    0x3ff9439daeb84bc6, 0x3fd24892391e6d78,
    0x3fedbf15c5530eac, 0x3ff8c323f5332454,
    0x3fe266c78f6e7c1d, 0xc00038ed3a84ac18,
    0xbff04089a83361b5, 0x3fdd1fcfb589ddda,
    0xbff19a5dd7b173c0, 0xbfe5501b3481f52e,
    0x3fed731a2452fef1, 0x3fe197ab9651498b,
    0x3ffd55a5158f40ec, 0xbfb411a1228efea0,
    0xbfcf7e780a15b088, 0x3fa694bc91bb6d50,
    0xbfc2c105566186e8, 0xbfedb2631bd0bddf,
    0xbff5cdb403a4200e, 0xbfe134952b4a7e3e,
    0xbfebd2ff76b35367, 0xbfec7ef46d53f8e0,
    0x3fc2ecaa8b3cfce8, 0xbff3b4f77067b7b0,
    0xc0008e7d7f3cae4d, 0xbfe26748970a1279,
    0xbfe9958308bec7fe, 0x3ff8a2a42b6101ef,
    0xbffecbd751ae1a8a, 0x3fe6d06275744366,
    0x3fe9737b59a999de, 0xbff96a69a1b91832,
    0x3ff202fab9cbb9d3, 0xbff540fe4a12f916,
    0x3fb18f9f73ef4cdc, 0x3fe316d9d99da3da,
    0xbff1ed8cacb8fa00, 0xbfc7cc846522415c,
    0x3fc0c094298cabc9, 0xbff3b31142a50ab0,
    0x3feaecdc22172c6e, 0x3fd75cc34d1ae274,
    0xbff1548d8b42d19c, 0x3ff15b3f4f5d3fb9,
    0x401062f4500a96fe, 0x3ff1acbddc9132db,
    0xbfe2348952cff898, 0xbfeeb3690c103494,
    0xbfe85df2f9ed3d33, 0x3fc2c5867d99987c,
    0xbfe25e40bce4bc5e, 0xbfabff1c3c69cee0,
    0x3fe2ba9556b83208, 0x3fe4ef0b276302a4,
    0xbfd820575273d86a, 0x3f8663976dc12940,
    0xbff302ad81fc1ab0, 0xbff2cd4db0ef745d,
    0x3fc8911ba96f8ca8, 0xbff0273325f2748e,
    0xbf895dd1c08f8b00, 0x3fcf5f364fd73c02,
    0x3fdb5fd17b16084e, 0x3fbd23e8fab44850,
    0x3fe118c6dd4c949e, 0x3f679fe0b6ecb000,
    0x3fe078da3afa786a, 0xc001aeac440cb9de,
    0x3fe07d6a3100d473, 0x40016b2cdc06fa76,
    0x3fc2f47bfc51b9c4, 0xbfe7002b61232a15,
    0xbfae2b99ea18a2d8, 0x3fd46021565b3b8c,
    0x3fef006bb5649b2d, 0xbfeb6f49a4ded926,
    0x3f9887b18f416920, 0x3fed4eea8019a0e6,
    0xbfc5157c3a23246c, 0xbfb4ea1bfc320aa8,
    0x400051adea3da9ce, 0xbffcd03de8d2cf6c,
    0x3ff5e5f895441e4c, 0x3ff9408d9f799b4a,
    0xbfe1c0d934bbf75c, 0xbfd7ed673c48f668,
    0xbfec8c5b16814d41, 0x40006cfa902b9c4c,
    0xbff350aaab5e714e, 0x3fd437aee97c849c,
    0x3fe7a399d7747d2b, 0x3fefb7beba9dce94,
    0xbfcf23e5bf8d8220, 0xbfe06a55cb0dc20e,
    0x3fe7fc66a77edae6, 0x3fd69447b09fb391,
    0xbffc40df88c2d02d, 0xbffce6651bec3195,
    0xbfec71aec38b4b93, 0xbff394fb410b4b88,
    0xbff1d44fbdd8f568, 0xbfe1599702dd560c,
    0xbfe4cd6510565bd1, 0x3fdf2fb3930e34a4,
    0x3fc8595f523b2ecc, 0xbfe1c9908dd49155,
    0xbfd83fbe064cae44, 0xbff2ea308efaee41,
    0x4002650a138e0d87, 0x3fff306e1ed32086,
    0xbfded408f7cfa355, 0x3fd95044b637d838,
    0xbfee0ccf8b14b01a, 0xbff4f44cb71229d2,
    0x3ff2dc905b50c477, 0x3fd47486d2cb9a54,
    0xbfea512d3c24382a, 0xbfd86e2438858d05,
    0xbfc3413a48964750, 0x3fda36079aa150ad,
    0xbfd2f7d963717ad5, 0x3ff1b6fe9114c818,
    0xbfe69d8e0eda5236, 0xbff26cb2b602c6f4,
    0x3f71ee7a786fa3c0, 0xc0030dacef1f1e0c,
    0xbfc3347c44c23176, 0xbfeedb8b9b8e1f8d,
    0x3fe64f212b02a4f3, 0xbfc9b05a3bc3e31e,
    0xbffa636557826452, 0x3fa027b01c5cfeb8,
    0xbfb1204701362b68, 0xbfe422a5b38a209b,
    0xbff19d84838c4fa4, 0xbff7f6dd420b2cb2,
    0xbfe5cd25c1861f50, 0x3fd1dfb26534d71e,
    0xbfcb6cef17d6ca3c, 0x3fdf611971ab0f79,
    0x3fd873c4f1e9723e, 0xc00115434cfafae7,
    0xbfefb898458fe78f, 0xbfcaa929fc2ac924,
    0x3fdddb7ca844978f, 0xbfed98b7501b8d4d,
    0xbf4fec6ea0f99800, 0x3fe3d4ceaccd531c,
    0xbff89a7abc99776e, 0xbfd10d5aea595c70,
    0x3ff05981198aad14, 0x3fb378dd9f1265f0,
    0xbff3506ffcc8c4c0, 0xbffc59ca770b0300,
    0x3fe8d38ef5bfce08, 0x3fb5cb5e2ca0fae0,
    0xbff96d1de7431dc4, 0xbff9819c2668cce3,
    0x3fd7986ce5558184, 0xc00e800c1d4772b0,
    0x3ff2d62d8661215b, 0xbfd85d8fab8a0238,
    0x3fe9967c83011ae4, 0x3fe8da125cd7a33e,
    0xbfc5b8e8e9956478, 0x3ffb17b6b9973900,
    0xbff2477a7394ae0e, 0xc000591169176b5a,
    0x3fe766b051661f9d, 0x3fddffe9e699f242,
    0xbfdeab0ebafa0b8c, 0x3fe79740e075593c,
    0x3fe0247727aeea17, 0xbff1ba9105486732,
    0xbfe216a2c930b2f0, 0x3fe2d1b3f4780c5b,
    0xbfd1563af85f1f58, 0xbffaa66b12b5fd3f,
    0x3fe1263bac85ecfc, 0x3fcbbe9f7ea6480c,
    0x40023379c6145244, 0xbfd4cfdf41d24012,
    0xbfe7d030612008f3, 0xbfc7f61f9f141322,
    0x3fe6f99eeef32ae7, 0xbff7043f51b6af9c,
    0xbfff1656d1339e52, 0x3fc6743f15ea1c47,
    0xbfd40718ac78e630, 0xc0056a2e06ec0298,
    0x3fb483f1e0e16d10, 0xbfff9cc086093b14,
    0xbfce8797d3efd1a0, 0x3ff7b00876dfdb1c,
    0xbfeb2df803d6724a, 0xc007df69ef8d5bea,
    0x3feaac57eeb454c6, 0xbfe40f0ddbae42b5,
    0xbfe734f58ed90290, 0xbffbe98a193ec598,
    0x3fbc8beff785399c, 0xbfee43a0a5c2f2bb,
    0xbff1199c2f53c323, 0xbffcea2311b0568b,
    0xbfd4dd77e4130a2f, 0x3feb71d65712893d,
    0xbfe35bd9a46d018c, 0xbfd8e15a56f477a4,
    0x3fc811f81b668b86, 0xbfe78d8e1f6e1eaf,
    0xbfedd72821012120, 0xbffdd6cbb8c43408,
    0xbfe11b60e4c4ff63, 0x3ff50e29d080e1a6,
    0x3fcf2a76fc1c6e6c, 0x3fe720a98692c1ab,
    0xbfe3792cd5c18e35, 0xbfac19d4d9ca03e0,
    0xc0009da539a11eef, 0xbfe0aeb704497bcc,
    0xbff6407760a19526, 0x3ff47d9e498cc81a,
    0xbfe6a3376c86a015, 0x3ff0f7475f3de700,
    0x3fe65cbadc5b927c, 0xbff80918046f2bb6,
    0x3fe5d6136ea2d32a, 0x3fc03697931b33c3,
    0x3ff5bc60386054ca, 0x3fe57d9b83d1cb42,
    0xbfe3e7e30a060284, 0xbfc8343307617b94,
    0xbfc48a70ba8b3da0, 0xbfe381819028e6fe,
    0xbfe4692675d531a0, 0x3fc571fed2938b6e,
    0xbfdb85015a46dea4, 0x3fe39dd3748bf96b,
    0x3ffbd7d9e79308e8, 0x4002f794d9b08b11,
    0xbff09414578cc3c8, 0xbfe73fe89261778a,
    0x3faa32c0661bc990, 0xbff073e43b735b30,
    0xbff7e76ac2ac68d4, 0xbff8fb8dc3c3e824,
    0x3ff01e91b094a970, 0x3fe527a9cad66b2a,
    0xc00836ddd00f7f03, 0x3fec0840111fbf00,
    0xbfd2749104a8f70c, 0xbf92565b70ee3460,
    0xbfe564b95917c336, 0x3fc462b08a8e5558,
    0xc0002d10fee2db6b, 0x3fd0f3e53c19cb0e,
    0x3fd8d076094cbeec, 0xbfeb5fca6c094090,
    0x3fd4afac2f5398bc, 0x3fdc565c18b42bc4,
    0xbfbb975315222ebc, 0xbfabc17732990ad0,
    0xbfe40b3bd787523d, 0x3ff0721bab1b79e6,
    0x3fd71d5d74a065f0, 0x3ff01968c756ac7c,
    0xbfa9fe36067a1e58, 0x3fcbf8599e78906c,
    0x4004e670f1231a12, 0xbff0fc6d992514d8,
    0xbfe321b0056d58b0, 0xbff840a789b8efe0,
    0x3ff72987b227d8b0, 0xbf8304b73123c548,
    0x3fe1d675d0784ae1, 0x3fc7caea4ac45758,
    0xbff41ef8bbc8ab7e, 0xbffba13a1eaf35ec,
    0x3fe1d02cef38064f, 0xbfd00761ab5bdcb8,
    0x3ff436a3296ba8d4, 0xbf97d61e22985a20,
    0x3fd3be5751246a84, 0x3fa54071b89e0be0,
    0x3fed15192bde42ac, 0xbfe230bd499cac80,
    0x3fe50dd696c34fe8, 0x3ff135b4ebb4d8e8,
    0xc00117f7c5b65111, 0x3fd34f84474b9c0e,
    0x3ff7a4f7e9cc71c1, 0x3fc34ca45890553e,
    0x3fd84a25f032f598, 0xbfd6a9934c937719,
    0x3fffc13351ad3f8d, 0xbfd4f92558e1a05a,
    0xbff998b86e8524f7, 0xbfee79ff764eee5a,
    0xbff97c1d1339e8cc, 0xbffaf6b85657881d,
    0xc003737a7de4798c, 0x3fc67c22001d62fe,
    0xbfe246598e71e50c, 0x3ff96e36e98367c1,
    0xbfdf62e9fd4a495c, 0x3fa8d78d373cafc8,
    0x3fec4eda1ef17738, 0xbfe3fc292e95eb3c,
    0xbfc2e0a8aa42b6c8, 0xbfe92c397c1255e4,
    0xbfeb2646836b47b7, 0xbfd8cfe321aeb274,
    0xbfa11ccdc31c1b30, 0x3fee978236c306c5,
    0xbfda206917e4302c, 0x3fba8423d4e30c30,
    0xbfdd1adca61df177, 0xbfec5d6baf2671a5,
    0xbfbb614d3b9705c8, 0x3fe18d4599d23eac,
    0xbfdbeebf14342ee0, 0xc00a4ab8e7e191ba,
    0xbff70b720fe8c43b, 0xbfb5313910015d68,
    0x3fb217dde46064e8, 0x3ff21a2a14ab2e23,
    0xbfe4537c93b60a7b, 0x3fcadbcebbccebba,
    0x3ffbfa8f5e1e5bd3, 0x3ffcadbac923a434,
    0xbff0f9ceb72c7bb6, 0x3fe778bb2aa365ca,
    0xbfd123ad43133013, 0xbfcd12118e619346,
    0x3fde2a350c994d4f, 0xbff7ab248ce4a004,
    0xbfd8a4b2ba555cc5, 0x3fd8e7a074ab1044,
    0x3fe2dac085382bda, 0x3ffe5c4b80ad3c8c,
    0xbfec5ce9bf2cb8fa, 0x3ff4fb1258a398bf,
    0xbffcdbb219093cfc, 0xbfebcdf819b86600,
    0xbfdb5deb57dc0178, 0xbf8bff9e9f87a000,
    0xbffad177c1639cde, 0x3fbdf7c071a312b0,
    0xc000da9320f9c547, 0x3ffe93b0457f430a,
    0xc000a97ebec5da84, 0xbfef3841835285f5,
    0x3fe9420443890276, 0x3ff189da7c95a834,
    0x3ff72f23366c7b76, 0x3feb6a5a17036af5,
    0xbfd08296d455e7b4, 0xbff69009b7b6c286,
    0xbfe467895b77756d, 0x3fe9bd2aa86ff4ee,
    0x3fe63f3e10507007, 0x3fe4bb994d01a528,
    0xbff80a66eb5de231, 0xbf922a132c8b7a30,
    0xbfe75b9fd5586b9b, 0xc0077cf97a58b681,
    0x3ff03789c09027c7, 0x3ff3a287077b9656,
    0x3ffec626e21aa5e8, 0xc00368b447ec522b,
    0xbff3cf5b603bf05a, 0xbffccb86d82b14d9,
    0x3feb59c98217c3c2, 0x3fea2da988cb94d5,
    0x3f9d98c4b94ccc30, 0xbfe4a8f526f68da0,
    0x3ff362920c9c6715, 0x3fd09cf2466a47e0,
    0x3ffa1b3c18843656, 0x3fa2e4efba2c54c0,
    0x3fc7bb02eff20e10, 0x3fee1005ad2d1480,
    0xbff7ba3aaa6bc814, 0x3ffeb3399c2a8bf7,
    0x3ffade25b724c055, 0x4003e8fb3d0a0f18,
    0x400394cfb50ac2fa, 0x3ff6992170612626,
    0x3fc6a02490d0f320, 0xc008ae7dc0b53617,
    0xbfe4d21240f68cd5, 0xbfdb3b51a3f539fb,
    0xbfd7a004ccd67f50, 0x3fe1825bd1604991,
    0x3fed6cea988ca82e, 0x3fe5b311c21930c2,
    0x3ff1a00d5dae891e, 0x3fda9d20533d5664,
    0x3fb4c5bfb59ec120, 0x3ffb36c423bd529c,
    0x3ff53a0d90a3c7f5, 0x40094cc10d9d28eb,
    0x3fea31dab63abae7, 0xbfe49a8614d2be2a,
    0xbff5c0cd24abad6a, 0xbffcbe3c6ea25672,
    0x3f9808a3535088e0, 0x3ff79c14af25b006,
    0xbfe1018604356b6a, 0x3fec2f18a2f73002,
    0x3fecbd0a999f96da, 0xbfe9246cdca78fb4,
    0x3fe9b2ae2a16a466, 0x3fc0a04215f64b98,
    0xbff09ab0aefc0df8, 0xbfedcda4bad325e0,
    0x3fd1d00044d29df6, 0x3fc20539d6a2c32f,
    0x3fd62030f49bc43c, 0xbfaf102b377ab2d0,
    0xbfec40f98f6a692a, 0xbfe3d16991b4d856,
    0x3fd3a10bc7b2c1bc, 0x3fd44eb9768ef446,
    0xbfe481854f13cef1, 0xbff221616d401c88,
    0xbff71252a4ee6e7a, 0xbf9ecb1a907f07d0,
    0xbfd9d6442dc00108, 0x3ff7596f1261e3d8,
    0x3fcd9f96eafcb29c, 0xbff7a784a5ad2502,
    0xbfe0b21e065493fc, 0x3fe04fcc420366c6,
    0x3fff0fba11750eb8, 0x3fde475b557ec58c,
    0x3ff44d7af3f533e0, 0xbfcbc5c9398511ca,
    0xc002d85d6a8ecb70, 0xbfe175e82187dc46,
    0x3fef21d9fde8af0e, 0xbfc570028c5baf07,
    0x3fd5cfd4c792b5c9, 0x3fc745da1d656e70,
    0x3fd816ebf0b8e031, 0xbfe05f58d1963c16,
    0xbff1b400072bb3f1, 0x3feafacd01e2e96c,
    0x3fd759964aaca1cc, 0x3fc4b42b09d4f980,
    0xbf9504e7ea4ce8e0, 0x4001d9eef1ce2ea6,
    0x3fde18f02ced7b20, 0x3fe7bb9a9367830a,
    0x3fe097fbbf465d71, 0xbfcf523e8f0b5371,
    0xbfe4a42aeb7f18da, 0x3ff73d9942e7cdc3,
    0x3ff348e98694e6ea, 0xbfa8fb29462976c0,
    0x3f9a58c363b24040, 0x3fea102a7ec49597,
    0x3ffd50bdc2230774, 0xc000f54c71114626,
    0xbfeaf5f0167d145e, 0xbffa80f8f663a673,
    0x3ff5ce3afa344666, 0x3ff60e4f75be62c8,
    0xbfb252ede037e534, 0xbf92012e533f4a88,
    0xbfd4c717a063fcc8, 0xbffcc8e8aa8bff2c,
    0xbfec6915785166dc, 0xbf6f71840e833d00,
    0x3ff860b89610693e, 0xbfe7d6b2980a32b8,
    0xbfd2d6ab872db364, 0x3fe851cd309c72b5,
    0x3fe267a335f7716e, 0xbfe153259154cc08,
    0xbfc15d3c3d2879e0, 0x3fcc90266c960f58,
    0x3ff7dbf236701fc1, 0xbfc357eef65ebbe4,
    0xbfed01c90f3282d2, 0xbfdcf8cb6952b563,
    0x3fe75cc88a4c120b, 0xbfb3f908ed0f47a2,
    0xbffefab7e89dac0c, 0x3fa9a1e57020e362,
    0x3ff47a614421e29e, 0xbffda9f5da2eb810,
    0x3ffc880b739e63cc, 0xbfd87a625649a322,
    0x3fef432908b77fc4, 0xbfd2bc10ceeaff78,
    0x3fde73944069cd40, 0x3fead44899f3e10a,
    0xbfe0ef92d1c40ccb, 0xbfd8f27ea8c6398e,
    0x3fdf79c69a00de9c, 0xbff42e51fc959ce6,
    0x4001ea1adebf4d42, 0x4003d2990218bb4b,
    0x0
    };

static const uint64_t in_rfft_noisy_2048[2048] = {
    0xbfa278cab7fab10f, 0x3fe0947fb524e79a,
    0x3fe67eb4b4883cf2, 0x3fddfa1669a503bb,
    0xbfb39a02aa8458f2, 0xbfdd4b27fe7bbe1e,
    0xbfe71500997fa070, 0xbfdce377126b4094,
    0xbf9591571a65c747, 0x3fe3b636996f0644,
    0x3fe5f8d360a4dd68, 0x3fddeb72d9aa3413,
    0x3fa23872742032ea, 0xbfde129e5472d752,
    0xbfe6adf8afaff824, 0xbfe01e947a739aa9,
    0xbfaa87df9acf7890, 0x3fd822ca46315b5e,
    0x3fe5a49e7faac35f, 0x3fdf59e5f967d7e9,
    0x3fa629aa854a14c3, 0xbfe02c0af7e91018,
    0xbfe701263e5fc16b, 0xbfe02608fa157812,
    0xbfc08ae6006362d2, 0x3fe146e138d0093e,
    0x3fe97fe72c6290cc, 0x3fe0133d44fb66e9,
    0x3faf861a260a1375, 0xbfde94e4d6f8ddb8,
    0xbfe58332f5add071, 0xbfdd866e02847b85,
    0x3f931d76023ba2e4, 0x3fddd8ba6eef2a73,
    0x3fdf6827fa68c3e2, 0x3fe139d71107f047,
    0x3f9aa29c933fdf10, 0xbfd945114eb30018,
    0xbfe6ffbbaddfdb1d, 0xbfdfb813b08b3683,
    0xbfad18d9d45f7794, 0x3fe09fa39bd27a31,
    0x3fe2cf360f16a4e3, 0x3fde59a90ee8e99f,
    0x3fa9c470a5e88d7b, 0xbfddec86591e4843,
    0xbfe77257ff1632ea, 0xbfdd0b70670c65eb,
    0xbfaaafc7fbc40e68, 0x3fe153be663ffc30,
    0x3fe68d673ead4913, 0x3fdd57f1177a116f,
    0xbf9ed95c722bfa41, 0xbfe1ae51bd6731d4,
    0xbfe54035c99cf061, 0xbfe0a4999fcd5c4e,
    0x3fa35a9836d92c38, 0x3fe06854333e6311,
    0x3fe746a0c4d8ebd5, 0x3fdd62020cbb70b2,
    0xbf9867ffaa34a2e7, 0xbfe1d259c9096b09,
    0xbfe59071cd465394, 0xbfdfe3bcc47e6e04,
    0x3fa97b6b61524b5b, 0x3fe1adc698e97bda,
    0x3fe5089eeffae22c, 0x3fe147fc18d00295,
    0xbfad769f4f305c09, 0xbfe1b3638cb89422,
    0xbfe6f635a68c91a4, 0xbfdbf743e62f3444,
    0x3fab01f3b2fa0bec, 0x3fda30753da5fc72,
    0x3fe57e6e6a2415bc, 0x3fe032b052d86f92,
    0xbf54cdaeef576357, 0xbfde9ac85e870c87,
    0xbfe7209a5900ca22, 0xbfdb08fa9af978d6,
    0xbfa20bd423f4bcf0, 0x3fe07341c94e3032,
    0x3fe540ef4d6c42ce, 0x3fdceea3bd28bfbe,
    0xbf9cf0fa547a78f3, 0xbfe1c9a9819d36ab,
    0xbfe71f558f66e3dc, 0xbfdfb37140e184ae,
    0xbf9ad84cc43f06f3, 0x3fe2ae12b72b00d0,
    0x3fe645ae9a0faa55, 0x3fdd6bd3e3f64575,
    0x3fb3f9f12d9b7a88, 0xbfe1247833f50cbf,
    0xbfe7341d52f24dac, 0xbfe0abd05756b3d5,
    0x3f9454ad57ad3a3c, 0x3fdfa5440ca84514,
    0x3fe4bf5a01d5e42b, 0x3fdb809c14745aac,
    0xbfa4f435b394d67c, 0xbfdfa304d7dd7e0d,
    0xbfe7a112dedb8716, 0xbfdeeda2bc4ab481,
    0xbfb222cec659cff7, 0x3fdca1072a3edb0b,
    0x3fe5e7a94555899b, 0x3fe1d00b7379ec59,
    0xbf9ab97db8bd7c0d, 0xbfdc1881023b5334,
    0xbfe57a6f99733268, 0xbfe0196d17a7bb3c,
    0x3f77dc937b3f94fe, 0x3fdc0973f67321b0,
    0x3fe7a1a7d1e2a81a, 0x3fe22787f0d2b33c,
    0xbf981b6623e89f1c, 0xbfe0c14d40b25bc9,
    0xbfead051403a43c3, 0xbfe1f20573e0af42,
    0x3fb0f45385e032a7, 0x3fe1f475c04c7614,
    0x3fe2eca23e45e123, 0x3fdd505f6b66b9b1,
    0x3fa0213faea2c8cc, 0xbfdd3e9015aa1f69,
    0xbfe8f9c27c5d36f9, 0xbfe281221a22a94b,
    0xbfa3cd8ab5d7b8a7, 0x3fe1b6be4da5c434,
    0x3fe7af63915ebace, 0x3fe14dcb65ad65a2,
    0xbf85cfec3dbffaa9, 0xbfe1befd71f94d6e,
    0xbfe770c36b11b73f, 0xbfe14d40d2ee4042,
    0x3faa796c992895c6, 0x3fdf8c2fd6544da7,
    0x3fe7f8310a5e5607, 0x3fe00cc24e1d94cf,
    0x3fa29b813a258c2c, 0xbfdf216a4bf30b80,
    0xbfe6970040e2217a, 0xbfdfd77c2e07253c,
    0x3f97076f7e5de7e8, 0x3fe0dba592217e2f,
    0x3fe942664efcab1d, 0x3fde5d8c9c8052a3,
    0xbf82d4c7efce62c5, 0xbfe26f22640845f8,
    0xbfe8f71ff1ef1ea9, 0xbfdabab5808cd5e5,
    0xbf97da31b927c7b3, 0x3fda8e074aad2aaf,
    0x3fe7639cd57d7f9d, 0x3fe2943fb99ab0b7,
    0x3fc1179eb39e5512, 0xbfe152a0a38cee1c,
    0xbfe88aa5d38d9553, 0xbfe13709f1e1e3c8,
    0x3fb4f9f8c340a1c0, 0x3fdce62282ecaeab,
    0x3fe7d45f9714368e, 0x3fe2400aff178575,
    0x3f95e0782f6213d7, 0xbfdfdd874cc7585d,
    0xbfe6b8a47a9647b0, 0xbfdf2a936486c732,
    0x3f96d76adee46018, 0x3fe08c55c1386eeb,
    0x3fe63d051249f5e5, 0x3fdc2c690be46461,
    0xbfaa15332922e522, 0xbfe0fc3c56800546,
    0xbfe69cc094c2a5e5, 0xbfe1a3f2a82a1ee2,
    0xbf9eb1b934b609a6, 0x3fdf23ffdb2b1404,
    0x3fe8d13ee9867f94, 0x3fdc39d031d54274,
    0x3fa3fcd38e6b8402, 0xbfdccf22f9b471a6,
    0xbfe4f323be56ec0c, 0xbfe2063d69d65210,
    0xbf6b95213dc4b93a, 0x3fdfb6f6addbc84d,
    0x3fe842ab96bc5eca, 0x3fdc4f039647d6b2,
    0xbfa83c7dea866bca, 0xbfe258b4bd089fb7,
    0xbfe614e5e8676b04, 0xbfdfec01e4f45f2b,
    0xbf6df6cd534e7aff, 0x3fe063a88e2fb9c9,
    0x3fe6c5150a246d48, 0x3fdf5b22db835c5c,
    0xbf908ea889cf8afa, 0xbfe10e0a4797e94f,
    0xbfe4a81b535d72bd, 0xbfdf19c4977fd309,
    0x3f9470c71d663b32, 0x3fe114fa3d531726,
    0x3fe51afbfc233d2c, 0x3fe10ff3409d91ad,
    0x3fb03289b575229f, 0xbfe0c486b870cbff,
    0xbfe4efa996d1cb08, 0xbfdc8eb22921b2e7,
    0x3faa7128aa4cdc2f, 0x3fe1074b30bf91b9,
    0x3fe7d82c2b9f6017, 0x3fe17b3127e231d6,
    0x3fa50393c0810b0c, 0xbfde13534590aa0c,
    0xbfe4cc6f7db710af, 0xbfe0c2c7b9eca2c7,
    0x3fa18a013a688c6e, 0x3fde36a4a526d6a4,
    0x3fe4a4158aa6776e, 0x3fdfa01d223f41bc,
    0xbfa36c4152de2e0e, 0xbfdeae3b2dafcb3b,
    0xbfe9fc5732bf3146, 0xbfdd4d7cf1d22115,
    0x3f6808d30547cccf, 0x3fdf1bfc8083b4da,
    0x3fe6c71c608cf173, 0x3fdc92a4581a4091,
    0xbf9d35e40bdfa0e9, 0xbfd9e4680620afc3,
    0xbfe561ab6cfff9ed, 0xbfe02baf080505c9,
    0xbfa6abc995a0d9cd, 0x3fe16d7dd5dd9bbd,
    0x3fe4611d24f8a2ef, 0x3fddb0cf7f3a7807,
    0xbf74f807ffe6e4a5, 0xbfda0316947fd97d,
    0xbfe5267074e99ca9, 0xbfe2b0b74d99d62e,
    0xbf73a27189e7cb3b, 0x3fe12ce6ea3642b3,
    0x3fe529a1eb032910, 0x3fe106ea1106e874,
    0xbf950a98199530df, 0xbfdc8466f47b005a,
    0xbfe6c18dcc478822, 0xbfe2030d5bf557e1,
    0x3f9acf3763f624d9, 0x3fdf1870b34aefaf,
    0x3fe62f53619f7a78, 0x3fe2214661b93983,
    0x3fa103a5663c6e78, 0xbfdca297e4c8f4e8,
    0xbfe739799853ad3d, 0xbfde3f4cf86c7054,
    0x3f84fb367a71c014, 0x3fdf3a1e34d04f87,
    0x3fe769164e6d1d07, 0x3fe0d160753f3a29,
    0x3f75753ec1896eba, 0xbfdc801c249f6ca0,
    0xbfe5cf365a2354ea, 0xbfdf53bd16718bb8,
    0x3f8794bfc3fe97cf, 0x3fdb94f55902349f,
    0x3fe3d9f8165c0588, 0x3fe04e02312da6e4,
    0x3f89670569a3c84a, 0xbfdecf6b8553f737,
    0xbfe3bb8020527718, 0xbfdd9256d3ce458e,
    0xbfa3428c27b2779e, 0x3fdfafd2bf806bc7,
    0x3fe933da40d3d6c2, 0x3fe1a8e15706a8a4,
    0xbfaab18dbc128704, 0xbfddd5f9a85a71a3,
    0xbfe6903737b18910, 0xbfde27f9cde8c1d6,
    0x3f9f2495b1493717, 0x3fe0561ee2854915,
    0x3fe80c71d13ba668, 0x3fdfbd78fafa5041,
    0xbfbb07b392d79b63, 0xbfdde6d01dfdd7ad,
    0xbfe624af9656005d, 0xbfe14bab9499afb8,
    0x3f987a9f4394bf7c, 0x3fde7bc4c65261e9,
    0x3fe397b4515883d8, 0x3fe095763390b89e,
    0x3f94bdc563b87d4e, 0xbfe021348d527258,
    0xbfe635722f012db3, 0xbfe00cec23f4083e,
    0xbfb193643d462452, 0x3fdcd02a37458b94,
    0x3fe4dd627d3a56cc, 0x3fe05f5ad91b2e44,
    0xbf96122b8ebe6094, 0xbfe2dbe7f1928e88,
    0xbfe5c8a8608257ef, 0xbfdc2285d026580e,
    0x3fadac3d13a61e43, 0x3fdded3358cba2ef,
    0x3fe684aa03d0d218, 0x3fd7e6c7aa580ada,
    0x3fb3b716b3a355e2, 0xbfdb090008a3d6de,
    0xbfe7070b07612da2, 0xbfdffb884bbcd7f4,
    0xbfa6fcfc2d3be016, 0x3fe08a7bb5a80b3d,
    0x3fe7f6b1792847b9, 0x3fe13fa3cc550bf6,
    0xbfb03259b2490111, 0xbfe14d3e33b489df,
    0xbfe60c3373be978f, 0xbfde35d57bce0412,
    0x3faab0e3cc57a286, 0x3fde21886cae7e74,
    0x3fe658ab1c479458, 0x3fe15948bd4552c4,
    0x3fa6af964f18ab9e, 0xbfe04832aefd3449,
    0xbfe6ddb6032c0570, 0xbfdfd4eb603d1a7d,
    0x3fb0a56dfc432f5f, 0x3fdcfb1f5ce1619b,
    0x3fe69cdfa7ec8319, 0x3fe2a010ca6474e1,
    0x3f800ef72e5c2c37, 0xbfe280a2bab20853,
    0xbfe5873f158ee352, 0xbfda266c0d8e7bf1,
    0xbfad4d4b43889a0c, 0x3fdeb7c44f3c40d2,
    0x3fe4592f960a3c03, 0x3fe1b6fb1ac61934,
    0xbfb24f33160a6491, 0xbfe05881d8c4bb2e,
    0xbfe630a1098aca70, 0xbfe0df00b3c95b21,
    0xbfa42f17b7292b34, 0x3fe0ed7f20ee4bd6,
    0x3fe3ad40f8c7a10e, 0x3fe0e37e951e1897,
    0x3f390efe51dd4301, 0xbfe0c33945567aa9,
    0xbfe3f3df042fa3d0, 0xbfdf9c059c79f8c0,
    0x3fa39d3c3322640e, 0x3fdd087ae29977da,
    0x3fe46434b2b4acfc, 0x3fe2e579c011577a,
    0x3f958ac45d9e3dcd, 0xbfe0ff52fe7a559d,
    0xbfe6ec35195064b5, 0xbfe2ebeb1d082613,
    0x3f8656ccdbec0489, 0x3fe19b9035d5a9b9,
    0x3fe53a5ec0d624bb, 0x3fdd29e5889b2bee,
    0xbfa8403023ab01ce, 0xbfe029d6acd585e1,
    0xbfe9263633f6a186, 0xbfdfa54ee4d6f8e9,
    0x3f9706f2522d94bc, 0x3fdffab0d505f95a,
    0x3fe6e1155ac82851, 0x3fe1c2b5df65b2b5,
    0x3fbebba2091db21c, 0xbfe157a930bdb948,
    0xbfe619950d4d92d6, 0xbfe286ef67e32200,
    0x3f921622b7b43985, 0x3fddd316aa0c8887,
    0x3fe848cd6d27ada6, 0x3fdf86c0c539a173,
    0xbfa53acbcd01d042, 0xbfde2fcca28d4b30,
    0xbfe65b9a3f9c4e57, 0xbfddd7d991381c9d,
    0x3fad8e3135ab6052, 0x3fdd426cdf42c022,
    0x3fe72e249c178914, 0x3fdfa5393719d8dc,
    0x3fa1a22dd65d2d55, 0xbfdb9df989253901,
    0xbfe5de4e8aac56d6, 0xbfd8f47b6c7a1f38,
    0x3f91eb232f436773, 0x3fdbf6c902abebac,
    0x3fe4201ac84ff324, 0x3fdf24292baf4840,
    0xbf79cc212ee965e5, 0xbfdd74f0f5f1019e,
    0xbfe683ba5aebdf58, 0xbfe3cd961f7bab87,
    0x3f82b14dcb15b657, 0x3fe0026b1ac9c86b,
    0x3fe991259443170c, 0x3fe18a82a58f4149,
    0x3fac67f43763d9f8, 0xbfe0db14761eebcf,
    0xbfe8d3ee364665bd, 0xbfe23cb1e36b5f53,
    0x3faf7ac207b4d103, 0x3fdd8d3f6e97af83,
    0x3fe76dbe641f2ca0, 0x3fe02d2902948767,
    0xbfab154d4a84de58, 0xbfdc1915a7d0eeab,
    0xbfe5857234dc770e, 0xbfe209158b35a5e6,
    0x3f902561743037d8, 0x3fdcfc9bdea8b150,
    0x3fe6a1430e3626a0, 0x3fe265295d5039c6,
    0xbfa2b7bc8faab6da, 0xbfde2c9b7d612337,
    0xbfe87693c7b9e787, 0xbfe312f22b0233e4,
    0xbfb4bb01c2ae3d04, 0x3fe005b73a5b633d,
    0x3fe56a76e868840e, 0x3fe09811d0b27aae,
    0x3f66846a255d427d, 0xbfe09b970bb6fd6b,
    0xbfe73214054d7dc3, 0xbfdb29e36c7f66b1,
    0x3fb3049180c6cf75, 0x3fe3040c1caab15f,
    0x3fe56970f8cb9642, 0x3fe18a50a3a8d61c,
    0x3fbef4381b55e57d, 0xbfdf5bee3528bf9f,
    0xbfea000bd867078c, 0xbfe18ce8b027a408,
    0x3f86227f7fa9d44f, 0x3fe3a47d4dffe8e8,
    0x3fe4d34008b70319, 0x3fe00dfe031cb462,
    0x3f9c1a8f94bf034c, 0xbfe05ab71171b2e7,
    0xbfe5f910e924e373, 0xbfe235cb83a7bd19,
    0xbfb106c819b5f1ac, 0x3fde0a210fa33996,
    0x3fe5cebc9be06065, 0x3fe01cc8f83a4d32,
    0x3fbc56e2f67f562e, 0xbfdfd4723f0c4a96,
    0xbfe5f7046c39eb39, 0xbfd849842fc535a8,
    0x3f93bf717fed5c19, 0x3fe1de23ee89f8e6,
    0x3fe50b015d4a133e, 0x3fe0b0638d43cd43,
    0xbf82566436fc54a1, 0xbfe127673f2ce23d,
    0xbfe617a8622009b5, 0xbfe1e84843374d6d,
    0x3fb5bec7ba1f264a, 0x3fe24aeb15b025ce,
    0x3fe71d78e663d4e3, 0x3fe1859acf67ebea,
    0x3fb173cdb6c63b5f, 0xbfdf79a14caa444e,
    0xbfe6be7d91fca631, 0xbfe216f01ac0e3fe,
    0x3f965e2676de3a80, 0x3fddd7c9e2ae83c2,
    0x3fe450b1d19a4483, 0x3fe11718d7dd366a,
    0xbf9cd45f9d4aea14, 0xbfdad5e3c226263f,
    0xbfe6e3ee9c42d7b7, 0xbfdd0acd48cb85b6,
    0xbf886e466a8f3a1e, 0x3fdca1943854883a,
    0x3fe6ed8b903526a7, 0x3fdb43fae5f76fd7,
    0x3f9c2c1b152d3f76, 0xbfdb0e262e8ef517,
    0xbfe4cce1f88e902b, 0xbfe05636c4145c6e,
    0x3fb18b73eba9b64d, 0x3fdc5106378e4b87,
    0x3fe957a4260bedf6, 0x3fe079b66f415df8,
    0x3f97be279e7fd31e, 0xbfe095e3c11c29d7,
    0xbfe7ec0f947864fb, 0xbfe2e92116b8d611,
    0xbfab79f6985d0308, 0x3fdbf4667c8d188e,
    0x3fe8aa9fa7d72f51, 0x3fe07cc955eaa9f9,
    0xbfa5ec3932012e6b, 0xbfddab43084f5834,
    0xbfe51c75664dd10b, 0xbfe276fa18b302dd,
    0x3f8c6fdd7cadd187, 0x3fe2db43eb11313b,
    0x3fe54a22271e8dbd, 0x3fe1702f35c968df,
    0xbfacbcc557487ad4, 0xbfda549caeceffa2,
    0xbfe662ce2c2570db, 0xbfe2452c499f98b2,
    0xbf9ed99ac308cd35, 0x3fdba2b9cbf096a2,
    0x3fe422a4044d8b7f, 0x3fdcfa0a52829446,
    0xbfa2bb5b3d7213cd, 0xbfe00d7800278494,
    0xbfe6ed821fde990c, 0xbfdaaeeb641fa1d9,
    0x3f8e5e03e1b626a8, 0x3fe0ae0c680521ed,
    0x3fe6c9ef7f83c887, 0x3fe0e7708b0dfe89,
    0xbf9dbceaa14d3ffc, 0xbfe0af6db996c66d,
    0xbfe767448ff0f1d2, 0xbfdf9ac818d293aa,
    0x3fa9c21f9b2f42f3, 0x3fe0191d26f4cc53,
    0x3fe57ae4bb84ab26, 0x3fd853dd18080f4d,
    0x3fa54fd075e16867, 0xbfde1bd90a135f3c,
    0xbfe6860311abec2d, 0xbfde8911b3165278,
    0xbf91412fc3a4723c, 0x3fd8b7bb2df90dba,
    0x3fe6ea6a25d6e6c7, 0x3fe1a4cda37d720b,
    0xbf876a9542366115, 0xbfdbb8d6705e7058,
    0xbfe745aa9db8f69d, 0xbfe1c846fae14ff3,
    0xbf84ac13231b096c, 0x3fe029a7e54fe1ec,
    0x3fe4002da7035130, 0x3fe0cec0884700d5,
    0xbfb60beeec1132d2, 0xbfe1094606ef5a7e,
    0xbfe380ff721b57ad, 0xbfe09bec6387e936,
    0xbfaf4dd38e2326bc, 0x3fe16846d9f6babb,
    0x3fe55f688f14b9c0, 0x3fe26926cb92d330,
    0xbf839a25d1d9cdf1, 0xbfe16fd7c52cf460,
    0xbfe77c1a7ed64480, 0xbfe0899123ff33fc,
    0xbf989d5dc7f597c4, 0x3fe14163dc9887ee,
    0x3fe3b3b460054566, 0x3fdf8612fc2461b2,
    0xbf90674386efab73, 0xbfdbcfb30d35501d,
    0xbfe7ad42e194f721, 0xbfe1b79e534cd68c,
    0xbf7d0ac22972753c, 0x3fe06311649f9800,
    0x3fe70352f2223be4, 0x3fdde95233630905,
    0xbfa30deb1ce1a454, 0xbfdcfdf88ab7cd29,
    0xbfe6b4f3652618c1, 0xbfdd3bd4af1f2a80,
    0xbf93750bdda4e302, 0x3fe13ec13cd3afed,
    0x3fe7b58b0e678f79, 0x3fe0af927939de94,
    0xbfa7c6b3cd207485, 0xbfe01391af894dad,
    0xbfe8ac890824558c, 0xbfe0a81f2559aba8,
    0xbf70a67c032011b0, 0x3fe0c1890b4664c9,
    0x3fe3ed0b615f5365, 0x3fe131e6bc28373e,
    0xbf96c79f646bdcd7, 0xbfe0878b4c941f9f,
    0xbfe62b3dbcf57163, 0xbfdeecd6148084e3,
    0xbfb2cd052802f413, 0x3fe1c15c9fe7a42e,
    0x3fe3946ec37576ea, 0x3fe101d8c4944bec,
    0xbfb3e95b0ad8f89e, 0xbfe014d241c54c82,
    0xbfe635dbcf4726c2, 0xbfdf986621c403c5,
    0x3f9c4ef86bc9aeb1, 0x3fe1ff77f2735044,
    0x3fe642c3f6368e26, 0x3fe0478010333baf,
    0x3f8e3fbb463f5fc3, 0xbfe10036920b1cdf,
    0xbfe7828c7e7f05f6, 0xbfe1f1d4d1b8716b,
    0xbfa1423e4eb2254c, 0x3fdfa1707af39519,
    0x3fe84b80f85717e2, 0x3fe1722525d16aab,
    0xbf8fd26349ea530b, 0xbfde27905e3b2f21,
    0xbfe6099f759f272f, 0xbfdf69b769badf4e,
    0x3f8418cc30b8199f, 0x3fe1b530f0a5798e,
    0x3fe57aee45dcf8bc, 0x3fdfb4649d9b10cc,
    0x3fbcf6c7e91f9845, 0xbfdd413188167a10,
    0xbfe5e0a48889bb54, 0xbfe129885fb2868a,
    0xbfb108fbbbc09c11, 0x3fe3bc680e586ec6,
    0x3fe66b5f28f46cd5, 0x3fd5a297607b5f9e,
    0x3fab41c13f815074, 0xbfe043ae63476838,
    0xbfe45561cfb7c6f6, 0xbfdc51ad801c5897,
    0xbf98a1cad061cbf6, 0x3fdbe00954ae5fe2,
    0x3fe831e317c6c177, 0x3fe13958c09196b9,
    0x3fa44af55eab6967, 0xbfdeced19fbe1378,
    0xbfe56f4eb27556cf, 0xbfdfa72b2b261982,
    0xbf849904904a9d53, 0x3fd6912e3c558fb8,
    0x3fe3f20dc67487e5, 0x3fe0ccca04302d26,
    0x3f91717033693c16, 0xbfdd8ef72c11a2f6,
    0xbfe52d069a855658, 0xbfe08f574c7261bc,
    0x3fbaceb836cb393c, 0x3fde40958141e245,
    0x3fe9110bc0d1bc26, 0x3fdd5b441e38c345,
    0xbf885e999f90983a, 0xbfdf40098f35fe63,
    0xbfe65e896b6a8bba, 0xbfe10566ab239f25,
    0xbf723d50aa2b8512, 0x3fe17260cf0720e8,
    0x3fe46595958ddea5, 0x3fdd1a24b2fd9f94,
    0x3f8d2cb7592726c6, 0xbfdfffccc5e26bc0,
    0xbfe878b8e2dee7bf, 0xbfdcba06bbb716d2,
    0xbfae0e774038df73, 0x3fdddd4984358f7f,
    0x3fe71b26e57a7a53, 0x3fe16c9bd3154a8a,
    0x3f3bbbafc4666c8b, 0xbfde6ef5b537c52f,
    0xbfe68d1c25d4c3f4, 0xbfe120ee5bc5e2ad,
    0xbfa7c667bcead7ad, 0x3fdfd0a224d93223,
    0x3fe81fec5e51bcaa, 0x3fe29d488f6bc2e3,
    0xbfb75a128e3ae9e5, 0xbfde90e4a0097464,
    0xbfe3961870e9e3a2, 0xbfe26a73e73e5b86,
    0x3fa117680cc8df7c, 0x3fdffe6e6124fef3,
    0x3fe70c470cf51155, 0x3fdd1e89576cf54a,
    0x3f912983a025eb51, 0xbfdb9bd775b64bdb,
    0xbfe56b35f9135fa5, 0xbfe033943511d3c2,
    0x3faef720f26be9db, 0x3fdc8e1213f42502,
    0x3fe4d79a05f98018, 0x3fdfd922c7365fb7,
    0x3fb8dee977e4b181, 0xbfe0aed8c09178b5,
    0xbfe54f14766f4cd5, 0xbfe1400136d09eb4,
    0x3fb39c97688a0889, 0x3fdf361a71cc3346,
    0x3fe6d076a8cbf329, 0x3fda1a090fa9763b,
    0xbf981d76c68b9de5, 0xbfdf0f2cc7f991c0,
    0xbfe7d9200e5b6bd2, 0xbfdf3a56d47e15b0,
    0x3fb9a11d608fb255, 0x3fde97f71dabbf1e,
    0x3fe669a018341c1c, 0x3fe0ed4d818b2078,
    0x3fa39100316f7a80, 0xbfde184aff57fd15,
    0xbfe78e1ab8f64565, 0xbfdc484b8ebc37df,
    0x3fa292015a3a9cbc, 0x3fe02db6e07629f1,
    0x3fe86b0d1cf5cf13, 0x3fe069772eac6faf,
    0xbf90f34592c6c798, 0xbfe073dc5eb8dfc3,
    0xbfe6276b49728001, 0xbfded732643b0914,
    0xbf8a58a712489fb8, 0x3fdebae4ba1533ec,
    0x3fe6b0358e40c8de, 0x3fdf44fd3838af51,
    0xbfa4656db074e7b2, 0xbfd9c40e7bd750ee,
    0xbfe87004170f6c0f, 0xbfe167fe3974356b,
    0xbf704d4ac174b073, 0x3fe15fcf3da475fd,
    0x3fe651c123d51a93, 0x3fde65556ecf79dd,
    0xbf79d024ce8bcdbd, 0xbfdf06527ddaa29b,
    0xbfe619c393f08a85, 0xbfde21a355bd1202,
    0x3f8a92eac27aba92, 0x3fe0956480bdfcca,
    0x3fe5b5ab2f53098b, 0x3fdc903672eca5c3,
    0x3fb0dbf6d61ac19a, 0xbfe0d23af3611836,
    0xbfe4363589c08fad, 0xbfe0a6c1e215eb7d,
    0x3f8c7eef07dbe181, 0x3fde8bdc4452102f,
    0x3fe58b9e38e15342, 0x3fdc28fc9ccd1bb4,
    0xbf8d9384ebd1a7f4, 0xbfdace0b446dd604,
    0xbfe49b12623c0026, 0xbfdde01ba28a8423,
    0xbfaf432a2d9e73da, 0x3fdfb0ee813876a4,
    0x3fe7652e76260c3c, 0x3fdfad767ef2a062,
    0x3f7142aa2ae55ccf, 0xbfd91db8beca8bcd,
    0xbfe4cbba6e0c6d16, 0xbfda672ebc7cbb44,
    0xbfab246eacfa0a72, 0x3fddf525aab5a67c,
    0x3fe7c143757514a4, 0x3fdd3245083db447,
    0xbf9911d4f4fcefe9, 0xbfe21ded07b1cbac,
    0xbfe71690b779a91c, 0xbfe1df47e26f1468,
    0xbf7f63426d3176cc, 0x3fe1cb5198c6d8f4,
    0x3fe5934868a8cacc, 0x3fdf07b1fa7a8c6b,
    0xbfb39df7265223a3, 0xbfded1e69357e807,
    0xbfe71c41ee82b18a, 0xbfd757a0299aa08e,
    0xbf954aeddea94e36, 0x3fe19f9065bb3f42,
    0x3fe31267ebba56d8, 0x3fe0c2430bfa624a,
    0xbfa0b29c4d4a99a3, 0xbfddd571b6a11bce,
    0xbfe71219c2ed3d39, 0xbfe0bd13b77c6c22,
    0xbf910a60496470bf, 0x3fe1d960462e4cd0,
    0x3fe42671fe8ef3fa, 0x3fdf83faa4702014,
    0xbf9c210f70ea64f6, 0xbfe01f44022bf4ef,
    0xbfe9708bfb81b13b, 0xbfdfd9deebc18694,
    0xbf785bff887a75dd, 0x3fdebbb648444480,
    0x3fe6abab83780be1, 0x3fdd1b6381c2502b,
    0x3fb2b3016977eb3d, 0xbfddc8292b447200,
    0xbfe46b1c7fe9fb41, 0xbfe0690690e8d40a,
    0xbfba409691d6dc9c, 0x3fda96b81539cf53,
    0x3fe5a8080f2bba2b, 0x3fdf52ec8ef5a9ec,
    0x3fb08bd68af7f9f4, 0xbfe0bf912c4cf2d1,
    0xbfe572404bf980f6, 0xbfddabc34e42912d,
    0xbfb2cf9e59eddc44, 0x3fdfa29bf0646bde,
    0x3fe6b50c3e117bde, 0x3fdfc4c82a855e3d,
    0xbfba6fa2afeeef74, 0xbfdf639781d31d8c,
    0xbfe95b4bc522c57f, 0xbfe3313c64f89f12,
    0x3fad17447d30690d, 0x3fdbc90d79b26f88,
    0x3fe3ddeed72e6d6c, 0x3fe116f82f5ae2be,
    0x3f9fa39d1edc3b57, 0xbfe029b1cab48ed8,
    0xbfe5533aa7d326f0, 0xbfe0e25559229555,
    0x3faaef945a8ea7e4, 0x3fe3e0ef474d9062,
    0x3fe564acd78feca3, 0x3fdbdf8a0bdecbf4,
    0xbf80bb9405d89986, 0xbfdc9eca6618df3e,
    0xbfe5e1cf651d0f05, 0xbfde30d94e5e991b,
    0xbfb8ab8e47664664, 0x3fda87cc13638a6d,
    0x3fe738d1e784a28c, 0x3fdc5ff83450ff9b,
    0xbf86b36f24145e25, 0xbfdd52ee389b94d6,
    0xbfe52919af1fddf5, 0xbfdca70f3b4ebd28,
    0xbf8983bda578a97c, 0x3fe03393f0a30bb3,
    0x3fe592bb87992f32, 0x3fdcad7de0297c4b,
    0xbfa65d8580753602, 0xbfe1617b406e9216,
    0xbfe590ee5073e594, 0xbfe039f6d68b0222,
    0xbfa771857847e2ba, 0x3fe025cf1f25f16d,
    0x3fe5f9d3d0cbfcfa, 0x3fdeb4fded9feadb,
    0xbf8d0575551d8959, 0xbfe04808954fc114,
    0xbfe77861faec4687, 0xbfdd5975671c3868,
    0xbf923c1d990e4f23, 0x3fe18302bef523eb,
    0x3fe79f8dee6f52fc, 0x3fde1c0849ad0830,
    0x3fb4d1d5080e8222, 0xbfde5467a9bde13e,
    0xbfe77d6a86ee55df, 0xbfe2446754eb4715,
    0x3fa341158e568174, 0x3fdeecbcb83f44c1,
    0x3fe65306897224bb, 0x3fe238c957924232,
    0xbf822fb4922aa215, 0xbfdbc7527093ae9e,
    0xbfe32f1e700c2e2f, 0xbfddced91ecd715b,
    0x3fa45020a7838fb5, 0x3fe4d9eafb3992b4,
    0x3fe38987b790c7cb, 0x3fe0eee279e0cc14,
    0x3fb1989341e936ec, 0xbfdf387f732c2e1b,
    0xbfe5c883d4b35602, 0xbfe157fc08994da1,
    0x3fa80f87c5072fd7, 0x3fde1b33ab2d136f,
    0x3fe87f802dbd5c4f, 0x3fe19aea3ba27ea0,
    0xbfb10b8436cadba7, 0xbfe12565608b9214,
    0xbfe53ce707c00273, 0xbfde7c432e0c1526,
    0x3f9d7c1ac58fe749, 0x3fe1116d1e43fbab,
    0x3fe3e909beb9f30c, 0x3fddf4ed9922fd1a,
    0x3faab670433087f8, 0xbfe153c8ffb2027a,
    0xbfe6053ef7893986, 0xbfdb4b7e2a1a63c0,
    0xbf303ab1e1b901f1, 0x3fdf06dc5f021114,
    0x3fe5df67d6a01f08, 0x3fe28fbc13dd2418,
    0xbfa20b6646c7fcb3, 0xbfe19696815a63b6,
    0xbfe895ddfc413ab7, 0xbfdf8e62e26d0fef,
    0x3f8de97696103962, 0x3fe08bd76034c4e2,
    0x3fe448fbab05720a, 0x3fe2e166931b0e9f,
    0xbf70044598e2f80f, 0xbfe25cc0302d3953,
    0xbfe7fdcdf065d4f8, 0xbfde5310c4004443,
    0xbfbdfd4f611efa17, 0x3fe1b3d98557c047,
    0x3fe7aa45a6910248, 0x3fe296befa4e64b3,
    0xbfb625cc1988a850, 0xbfe0c5e8e3d3b5a4,
    0xbfe7fe746ae1e04e, 0xbfde0bf5aebf7fb6,
    0xbfbf6828d040bd9c, 0x3fdce9f0fc5a8a73,
    0x3fe928551d068073, 0x3fe0bad612c2cce3,
    0x3fb4588800ebf815, 0xbfe0e35426007554,
    0xbfe769d04ed0db0a, 0xbfddf59013e1ad90,
    0x3fa83956efe680ad, 0x3fe208f606e76840,
    0x3fe810036f697028, 0x3fdf8e4d150af4b3,
    0xbfb84ed152d11e1a, 0xbfde7739b5580e50,
    0xbfe767e14f6fd074, 0xbfe0a03674be5a79,
    0xbf995d5b365c5382, 0x3fdcd311de8cdc0a,
    0x3fe5ee77a0c794c3, 0x3fdf3de117c2bf4e,
    0x3fb732748b1b1ac8, 0xbfe0af8441db0ec6,
    0xbfe72b6e50229d76, 0xbfdfb54a864bd961,
    0xbfa28d84df7f2808, 0x3fe1570462846331,
    0x3fe6fee2c74cb7d9, 0x3fdd4834b6b60cae,
    0x3f813ddd08ca9b1a, 0xbfde58a69095fc9b,
    0xbfe6c68629cc0468, 0xbfe047f2a4f3b83e,
    0x3f9009a588bc7558, 0x3fdd7a67ab9252d2,
    0x3fe43481aa6c7b58, 0x3fe0f35b4391e841,
    0x3f972e75d7a71e8c, 0xbfe253fd24b55541,
    0xbfe9fb33eee466d2, 0xbfde2958ea17c5cf,
    0x3fa402b4a2dc64c4, 0x3fdee410406f3bd1,
    0x3fe8244a909622f5, 0x3fe0653f6e97ed1a,
    0x3fb2646ac37425da, 0xbfdd9787dcdc204b,
    0xbfe772e6251d3807, 0xbfde8a01ba8b6d41,
    0x3f7ff27f8ca8f192, 0x3fe012629667704d,
    0x3fe7aa71bb89c7ca, 0x3fdec7f5e1fbcc38,
    0x3fa9678e1bd12422, 0xbfdd79035fd50993,
    0xbfe6106c8ec8e127, 0xbfdbe493b455ebfc,
    0x3fc027926db9856f, 0x3fdf07fb0d19bb16,
    0x3fe5ce16d49e123c, 0x3fe0297aba3e93e7,
    0xbf9fcbd9b9c085d9, 0xbfe275b40e65069d,
    0xbfe44e3a1b54c182, 0xbfdbabc1f6f9b4f6,
    0x3faaaa3338bfd089, 0x3fdf737a4da56039,
    0x3fe607674eec744c, 0x3fe1ae1536f83a22,
    0xbf7e97279c43e678, 0xbfe04e31bfdda73c,
    0xbfe6f2ecb5aa61e5, 0xbfde61a2dad3864f,
    0xbf79cebd00ee61be, 0x3fdf57722976daab,
    0x3fe57be3d9291e21, 0x3fdb2ef76db18f87,
    0xbfb438cdf04fa1c5, 0xbfdd712c27149114,
    0xbfe5d8f547b9c838, 0xbfe09886d404ac49,
    0x3fa7a2b261b39d1f, 0x3fd6b106179aa530,
    0x3fe4ff44a4236382, 0x3fe01e6d344fc7a1,
    0x3faf92bdcdadada4, 0xbfe205f8ae39092c,
    0xbfe4781347ae7899, 0xbfe04239d33c17d9,
    0xbfa8af17090db73a, 0x3fe1f677604136cd,
    0x3fe5e9510a1d7184, 0x3fe13b8a639ce3c6,
    0xbf80cfe2fdb29094, 0xbfdb84fa4be88a6d,
    0xbfe95a475fdc3751, 0xbfe086d1d79d49aa,
    0xbfa83d99547374c5, 0x3fe0922ba4cd77c3,
    0x3fe5a9ca2b95eb3a, 0x3fdf3c135be533df,
    0x3fb2f47663b5d80a, 0xbfe02fdadac23753,
    0xbfe775f6b511f0ad, 0xbfddbbccb781ec64,
    0x3f8db0d63303952a, 0x3fdbd2454d2fe5c6,
    0x3fe5b568fcdbbbcb, 0x3fe3816e7b699fe2,
    0xbfa3258e4456b1ce, 0xbfe0a8a55f68da3b,
    0xbfe6c2959c4994aa, 0xbfe0159a86f59575,
    0xbfa2e91112d26b6d, 0x3fddd7d8980478ea,
    0x3fe4f70467a8e134, 0x3fe0a462a585a12f,
    0xbf97151fa78a35cd, 0xbfdf0e2c4e1af151,
    0xbfe5a3bd4167d478, 0xbfe15a95306079b4,
    0xbf52a98b56ce0dc0, 0x3fe285a31e49af99,
    0x3fe6d48171bcbf15, 0x3fe0ddc0b3420bae,
    0xbfa0f74c8342d532, 0xbfddc68cc0c950a1,
    0xbfe5b0517bbedb88, 0xbfda5d959e70d698,
    0x3fc1067cc5a313d0, 0x3fdf8ec63436565e,
    0x3fe5b139543d68c9, 0x3fe201e24eaa10f4,
    0x3f79dc07558a6ea2, 0xbfdfc430d7e27c69,
    0xbfe3f61c8fd3d54b, 0xbfda24138a11c80f,
    0x3f9043ecbdeaa692, 0x3fddfea32a8e4ce5,
    0x3fe5e8690b94e6f1, 0x3fdbebe6d2d51856,
    0xbfa5e5be8b8a3b4a, 0xbfdecbbe5059d7b6,
    0xbfe452a18bf4501d, 0xbfe1608a4e34888b,
    0x3f69ab7e9b79ef88, 0x3fe0e433a025ed2c,
    0x3fe71aa81d87b1ff, 0x3fe12e1b75684717,
    0x3f9a7a67077a0987, 0xbfdef1e26b998a6b,
    0xbfe4da8a84161645, 0xbfe08e0ad94fd0c9,
    0xbfa6777c1b9a4c25, 0x3fe1a31bd58d4964,
    0x3fe9cfdef6e67509, 0x3fe1ff40912f5942,
    0x3fabb4eaa300ce67, 0xbfde27d6971b9514,
    0xbfe62bfb0375521d, 0xbfdf52b1ae61ff7b,
    0x3f6f7e8e9897d6aa, 0x3fdc86f32a4886ba,
    0x3fe7957eaedd6f92, 0x3fdba3af1bfc1987,
    0xbfac681c272af1e8, 0xbfdc6d13c6e4117e,
    0xbfe6c38d204f0d57, 0xbfe2a7fb48c93301,
    0x3f7d6bb02b9af27d, 0x3fdef2ee2192cd19,
    0x3fe6b804594cb672, 0x3fe1a220de95a00d,
    0x3fa92db041f805ec, 0xbfe0ad257f734730,
    0xbfe83af4a030f61a, 0xbfdec6aa3bb979ff,
    0x3f8d1fd6dac676c3, 0x3fdc5a3274622873,
    0x3fe6007a450b3aa9, 0x3fdf4c7f9b98efca,
    0x3fb44d19a0ff4145, 0xbfe020f314c8f65a,
    0xbfe5b7dd2e1026e2, 0xbfe130b08efda231,
    0x3fa0f3c771572567, 0x3fddf5a6f4d564ae,
    0x3fe4e64eab7b3ea3, 0x3fdc471cc4a3f333,
    0x3f807c4bb9878b85, 0xbfe18cc11ac9e5be,
    0xbfe87c274134b0a3, 0xbfdfb3d447577f9c,
    0x3fa5108afa0d47c3, 0x3fe34e1cf0bd473a,
    0x3fe6a67d08b41dad, 0x3fdd6e596bd4baca,
    0xbf93d9aa34b37f41, 0xbfe22289afa5f555,
    0xbfe56e5f2823501d, 0xbfe0dd6dac396fc6,
    0xbf8d7f61908c2c04, 0x3fda83f3ae60f923,
    0x3fe5ce2833b7040e, 0x3fdc02ee5ae53d71,
    0xbfa6720e0fcf8101, 0xbfde93a26bc1854a,
    0xbfe547a25ffd8c42, 0xbfe197375b2eb3f7,
    0xbfa481213bb31b8f, 0x3fe19d3e2c055892,
    0x3fe6de191538f42c, 0x3fdead243812447e,
    0xbfa3249cade6c2f4, 0xbfe01059aa4e45b6,
    0xbfe4e4c9ed751ef9, 0xbfe0b7de94853bd4,
    0xbfa48ecb0972af8b, 0x3fe260aa5dc528b8,
    0x3fe92867e9c8c306, 0x3fdf10e7cfd4e211,
    0x3f956bfbc9867860, 0xbfe0881b4c089067,
    0xbfe6d06eecca2f78, 0xbfddfb732b8392cc,
    0x3f92a44f527ba825, 0x3fdb8afd51787e8a,
    0x3fe5fc815fb399ed, 0x3fdf8a973e538504,
    0x3f9de2b1ce5e5c27, 0xbfe12ea071f9acda,
    0xbfe7a2390f3bcbaa, 0xbfe0c04d20e1d1be,
    0xbf7ccd4e43410e0f, 0x3fe03e6f6fab544c,
    0x3fe60a4053aeda3c, 0x3fe01207aab8c0df,
    0x3fa3e62d6470bce2, 0xbfe1951e1bf5d4fa,
    0xbfe6944c3243115a, 0xbfe18d9b4ff2764a,
    0xbfb0bd3f48174832, 0x3fe0aa751e35059d,
    0x3fe8ae928454360f, 0x3fd9865825f11b08,
    0x3fa35010c717fafe, 0xbfdf0c58d96e919c,
    0xbfe46bc0ab7c80ce, 0xbfe1ca401587c958,
    0xbf970c46e347ce15, 0x3fdd1dfe538eb734,
    0x3fe60f9cb1afcfa7, 0x3fdeb8ee9674849f,
    0x3f9d72caf7c2ba60, 0xbfe12946fdf39655,
    0xbfe7cc549fc0f0f9, 0xbfe257c66b999f05,
    0xbfb19a36cf14c7de, 0x3fe29f860655a303,
    0x3fe6bdae3da43b2a, 0x3fe0eea50c00fca4,
    0x3f771c80bdb0d725, 0xbfe0f1d47f829e57,
    0xbfe69dbc78855245, 0xbfdcf17655938c15,
    0x3f981cb8959b6f8a, 0x3fdd0b9a07ab14b4,
    0x3fe5970461d1f201, 0x3fdaa1c54e782e13,
    0xbf9fd285a2fcb416, 0xbfe10b0f02ec1b92,
    0xbfe7b171d81968e4, 0xbfdebb057c23e827,
    0x3fa5558aaa7660da, 0x3fe1acfd2a7d4812,
    0x3fe4aa5a47fee8fd, 0x3fdaf78961cf7afe,
    0x3fb0c88cd18879a2, 0xbfe189282094098a,
    0xbfe8e6055f7d5b29, 0xbfe28f1f9ed4f9fa,
    0xbf80259d6d6b41b1, 0x3fe0ddb7994ba59b,
    0x3fe3df401c4f8998, 0x3fdbe557933e5ae9,
    0x3f6bb46f7d06841f, 0xbfde69c44331de25,
    0xbfe8792a34a9a4d0, 0xbfe24a5f2b7de792,
    0xbf920ade5da052e9, 0x3fdc968748332d84,
    0x3fe3c6438b2e1f86, 0x3fe12799febda964,
    0xbf9213641ff872cc, 0xbfe13b0d654f6895,
    0xbfe65aa721d555a0, 0xbfe35faa1770a754,
    0x3fa729ba837e4f3f, 0x3fddbca153f17404,
    0x3fe3e5add7f9a6eb, 0x3fdce602b903ecb4,
    0xbfbbce311b65f2ae, 0xbfe00e74ed6f39e5,
    0xbfe667ebe7674819, 0xbfdb338726352383,
    0x3fabf4ba84142a7c, 0x3fdf67c6f7a609d3,
    0x3fe6c855dc8c59ca, 0x3fde52444808d7be,
    0x3f84b375960e60a4, 0xbfde1f5d8eee4bf9,
    0xbfe65ed0929a5f4a, 0xbfe14d89e145298e,
    0x3f61144bdedd8ac9, 0x3fe080ffc239d72c,
    0x3fe76afdcf9a333b, 0x3fdc4c179032ed89,
    0xbf88c7d7d4c46d04, 0xbfde4778bced8879,
    0xbfe79553fcb91ffc, 0xbfdbec85ce1f94c2,
    0xbf92a1f9fe9f8a45, 0x3fdf7229dd045f72,
    0x3fe82a21a19c0713, 0x3fe09a615d4159b3,
    0xbfab74199e3346b5, 0xbfd879e5dd9c0a76,
    0xbfe58910846ea1f4, 0xbfdcb6ab3b0fe8fe,
    0xbf7840f187d380d5, 0x3fddf6eae2340539,
    0x3fe74f8bbf6e30cf, 0x3fe53022ea945b75,
    0x3fb5716ac3932495, 0xbfdf9b3ce25c2e5f,
    0xbfe51e9f6b9ab79d, 0xbfdf679aac511e6a,
    0xbfa3123f6e314b64, 0x3fdf7792060000d8,
    0x3fe661e9f358827d, 0x3fe1ac8ba9f558cc,
    0xbf9d91a93b7cb5b3, 0xbfe07307048f0bac,
    0xbfe4a338a9b28ad3, 0xbfdd3520c2dc5bd2,
    0xbfa147ff83599e8d, 0x3fe119bc3022875b,
    0x3fe72fa0a50fc284, 0x3fdd577c0a913cc9,
    0xbfa4065aca038c27, 0xbfe34a95b41621c8,
    0xbfe3bcddf822ebb0, 0xbfdc44610f805f55,
    0xbf89f39eaa48c46d, 0x3fe10ec469348037,
    0x3fe7dd4ea9731cfe, 0x3fde35cc2e17ba9a,
    0x3fbaa4c9f358f243, 0xbfe0ea8f6a184e8b,
    0xbfe7037379bb30ed, 0xbfdf573ffaa18ac4,
    0xbf968b522c925bca, 0x3fdebddeb9c94a5e,
    0x3fe775b213238685, 0x3fdf40c387c0bb65,
    0xbf59dd447f66d08c, 0xbfda62d1913bb11d,
    0xbfe5707aad94ce68, 0xbfd64139c6434f28,
    0xbfa3824773e9fe04, 0x3fdf65e8c86816c5,
    0x3fe4199991e6acb4, 0x3fda7e7821959386,
    0x3f802d70e302796b, 0xbfdcdb838e18136c,
    0xbfe43cb069526420, 0xbfdedbfc417d56bd,
    0xbfa76310fab420e0, 0x3fdd02baba588df8,
    0x3fe2a6f01f075de4, 0x3fdde2e2d8d2f003,
    0xbfba719028e111f0, 0xbfdf78b519ae002a,
    0xbfe4d0751e6e617b, 0xbfe1148486cb96f4,
    0xbfa47b54e92327ef, 0x3fde284ea56a41cf,
    0x3fe593821101aae3, 0x3fe2257dfda7e4b5,
    0xbfb09fae04f18682, 0xbfdf337e5747f814,
    0xbfe6cb87c3d685b4, 0xbfddc4bdf9aedaf5,
    0x3f94a28b005e8a00, 0x3fd929f0c01edc89,
    0x3fe585550081243b, 0x3fe1c8cc88ec8010,
    0x3f9af223ef38cbe0, 0xbfe092c115285830,
    0xbfe714103fcfdee3, 0xbfdea871b2bc6c47,
    0xbfb366430ebef1a5, 0x3fe044f71c97226f,
    0x3fe5bcc1a59f6fd1, 0x3fdbb0feca6e80c6,
    0xbf7e12b728c5f658, 0xbfdd894c9f9ce159,
    0xbfe6bf1af85846a7, 0xbfe0fa1ef8a7683c,
    0x3fa0fb8274595b93, 0x3fe0e555f9f17c91,
    0x3fe7fdb5f69c8399, 0x3fe231519b05eaba,
    0xbfb59ca376011d7c, 0xbfe23ada0455212a,
    0xbfe64a49bfaade23, 0xbfde692e9d6e36cf,
    0xbf7fed87796921e3, 0x3fe0ff3bb184f714,
    0x3fe8c352bcfe072c, 0x3fdd952828609bbc,
    0x3fa2dd7cb4527e80, 0xbfe17d106bc7823a,
    0xbfe456bfc49ce79d, 0xbfdae6cd6d4618c9,
    0x3fb456727678f45d, 0x3fd704c3c2a8ac3e,
    0x3fe6bf57c45cb0f3, 0x3fdef5ead501c00c,
    0x3fb68de3e146a58a, 0xbfe111c740c6653a,
    0xbfe801e265695377, 0xbfdee6a8381f51ee,
    0xbfc018e8cca08c5a, 0x3fdc8f457b3dd718,
    0x3fe6dd3f06949282, 0x3fe11405b7dd6630,
    0xbfaad5cf08daea2c, 0xbfe0540f803f2016,
    0xbfe54c1c4d466ca1, 0xbfdff69c42fd523d,
    0x3fb159bf1018b927, 0x3fd9c48313651254,
    0x3fe6af1d708d38ed, 0x3fe168d1e70d2253,
    0xbf4e62a2c83bc8f4, 0xbfdbf36c5fe1923d,
    0xbfe63048bb9c1ba6, 0xbfe1dc88d06cd46f,
    0x3f92e10e01c158fe, 0x3fdead9c874283c6,
    0x3fe4c02642eb5bc6, 0x3fe14c97b0ddfe8d,
    0x3f60b08755c9a279, 0xbfe05a3ef9e76fd5,
    0xbfe481f01ace015f, 0xbfde2b5be59070f1,
    0x3f849e49561e9079, 0x3fd8ee8fc2129358,
    0x3fe802c01cd1db75, 0x3fdeeb7dfd320864,
    0xbf507c72dc5ba5ec, 0xbfe01bef8ecc4e05,
    0xbfe4da34ed91d454, 0xbfdda4cfc9d2e5d1,
    0x3f85943d7bc4b017, 0x3fdca9296ebc0505,
    0x3fe71f24d97ec2f6, 0x3fe2f978b663ddff,
    0xbf8cdfe3372fe5e9, 0xbfdf45c6957ed226,
    0xbfe5d9aff0c5b6ec, 0xbfdd3630ddf86ff4,
    0x3f9ac05a3f606c2e, 0x3fe19bfda8a5b3bf,
    0x3fe8c060f6bd4a7a, 0x3fdc0886b343f724,
    0xbfaa0ec409065ede, 0xbfdfcc9148f18343,
    0xbfe8e058118bf56c, 0xbfe0d2ac149153fe,
    0x3fac300738e729e6, 0x3fe06c9a9c8cf0d3,
    0x3fe4eaaec8cf2772, 0x3fdefcb931276e65,
    0xbf82e30a4678b5ab, 0xbfdb49518ac0439e,
    0xbfe80b806d56ac13, 0xbfdec653516919b4,
    0xbf88cfc011163d8d, 0x3fdea561899fe951,
    0x3fe31e96deada192, 0x3fe02d0b0061f565,
    0x3f7f2d8d2864d04a, 0xbfdd306fdf43391c,
    0xbfe4349c5044adce, 0xbfd84bc0315582f0,
    0x3f87c1d2a08feed0, 0x3fe0b4e32bcf720b,
    0x3fe4037bb14387e3, 0x3fdceba6b23f7f1d,
    0x3fa1b9f05ecb8585, 0xbfe0d5582aaaf723,
    0xbfe4f786c184663a, 0xbfdbc8be2aafc501,
    0x3fa26dadd8cfe846, 0x3fe0bbbe17d76095,
    0x3fe74767d206aab9, 0x3fdb9c5cae4da2b5,
    0xbf50f9ffce94ab1b, 0xbfe0b07c00538512,
    0xbfe5f348273204c7, 0xbfdea270bd054363,
    0x3fa89414e0f8722f, 0x3fe10362c83900fa,
    0x3fe422ee06dc81d2, 0x3fdd80d9af6fc0e0,
    0xbfa3a27d12e013f8, 0xbfdf69c74164ba07,
    0xbfe54d7028e9b7a2, 0xbfe1159685b9b91c,
    0x3f8554faf3dd99f1, 0x3fde0f08eab7e595,
    0x3fe650f483251c46, 0x3fd898bcdf587455,
    0x3fae83cbf8f3b131, 0xbfdc21a8f88fa584,
    0xbfe6147950ce60cc, 0xbfe086db2930e602,
    0xbf9c235765eb8387, 0x3fdbd9e8798382a9,
    0x3fe5de841cb05895, 0x3fde9ad82d6fff53,
    0xbf8b3f37c6d2d727, 0xbfe1e63e0e2ec0ec,
    0xbfe617f0b43bac2a, 0xbfe006c90e35753c,
    0xbfa65b6b8f2cf8ca, 0x3fdbf6fdefcb129d,
    0x3fe6bd3747571edd, 0x3fdecd1c03eb79c9,
    0x3fb27c55bdd7f7e0, 0xbfdcced5dc863d23,
    0xbfe6ed649c5311be, 0xbfdde1b1f61cbefe,
    0x3f9634e0654e7927, 0x3fe2ee39424985d5,
    0x3fe5641ceac7b5ca, 0x3fe174eee40eb367,
    0x3f68988269a72c71, 0xbfddae650d96ce2a,
    0xbfe77856bbc530e3, 0xbfe09f2aba4695eb,
    0x3f8de402399ac501, 0x3fdf611aefb6da34,
    0x3fe73321ce1017d9, 0x3fe1939688c13847,
    0x3fc0e79efb5691aa, 0xbfdfe31d2c3264ce,
    0xbfe5526423b85dca, 0xbfdd4e4a8dcb82eb,
    0x3f957fd516e0cc68, 0x3fe099e961bd2835,
    0x3fea447d17d482c8, 0x3fdf7bacd331e19a,
    0x3f77a070803ef951, 0xbfe041c0cb4c4667,
    0xbfe4c51794343e46, 0xbfe0384c8bf18da9,
    0x3fa45ce3a73a1eeb, 0x3fe00418a0b89f71,
    0x3fe44b9d9eac53a7, 0x3fddcc8771a9e6a0,
    0xbfab9ae1c6bf5c72, 0xbfdf95cae6d47e17,
    0xbfe36bdad9629565, 0xbfdf4e599dea10ee,
    0x3fb4b72975f6d5d0, 0x3fe039ab9faa9330,
    0x3fe5e55bb44483d0, 0x3fdbf045aa008be5,
    0xbf70d75f2466b4aa, 0xbfdc5e28bf4cbded,
    0xbfe4a8cdab45714d, 0xbfdf908c302eab91,
    0xbfa27578241ab5db, 0x3fe1811bb2f04be8,
    0x3fe64ca654b579e4, 0x3fe043435b396cc6,
    0x3f810c8658688d77, 0xbfdd6ea80ed73eb2,
    0xbfe49b230b49e167, 0xbfde4bafaa990224,
    0xbfae003d2561d6e7, 0x3fde7e2537de349a,
    0x3fe5710c38ba6720, 0x3fe4844f91135ad9,
    0xbf7334f3d2b03a64, 0xbfe0d382c0830681,
    0xbfe6e49498c70cb0, 0xbfe0b15dbec7389d,
    0x3f97896a54694f99, 0x3fdd7b009690fa27,
    0x3fe74b3ef69ae6bf, 0x3fe0134ff9d779d4,
    0xbfab0b7362e91b5f, 0xbfdc02426416d0bc,
    0xbfe6bc5d7a47e037, 0xbfdf472f95faa78b,
    0xbfb0ce442af852a7, 0x3fddec4636736a5a,
    0x3fe6fd7a236940d8, 0x3fde700daf1c33ce,
    0xbfa4e03f531fbcff, 0xbfdc546bce521014,
    0xbfe75f876bdd6919, 0xbfe2da2b7268157f,
    0xbf96401faac210b3, 0x3fe0e457442c893d,
    0x3fe40e9751a47ee8, 0x3fdf6ddcb8201ecc,
    0x3fae515ebbe5da50, 0xbfddb4492e423515,
    0xbfe48b6e961ba73e, 0xbfe0c7800240ae21,
    0x3fbbc68972976549, 0x3fe050bd8a678378,
    0x3fe6b559ce7dcdf8, 0x3fe06726baa70b14,
    0x3f909508c64ca1cf, 0xbfe01d76c8b25e52,
    0xbfe715333939639f, 0xbfddfe585025a2ff,
    0xbfb4b5207bb21097, 0x3fe03ee206c6d38c,
    0x3fe41387675a9140, 0x3fdeb306d8235c1b,
    0xbf5dbb5074ce6e1f, 0xbfded16d5277b482,
    0xbfe609858aef1ba7, 0xbfe16d01449bfdc2,
    0xbfa1b89e729baba9, 0x3fe10c4ffb267efb,
    0x3fe59ed366f1eea4, 0x3fdcbc83bf151de9,
    0xbfadc4827127cfff, 0xbfdc3e5dcbdf532b,
    0xbfe71d6aae03f721, 0xbfdf75a5f9122812,
    0xbfa9de338638d3b1, 0x3fdece7fc924afa0,
    0x3fe6a06c8f3cf444, 0x3fddfef7d898d346,
    0x3fad929a2bbdbccc, 0xbfe08ad4f84638f7,
    0xbfe555c73d97ed04, 0xbfe18f43de09f990,
    0xbfa6a5384215a5af, 0x3fdfa9c39ace162c,
    0x3fe52f79b2e5f675, 0x3fe1b6b3ea11c9ac,
    0x3fac161b8a0d7f1a, 0xbfe014c8e48e6d09,
    0xbfe57532c45e283e, 0xbfe307f82779e218,
    0x3f8edaa8fbc5c104, 0x3fe065100b4c45cb,
    0x3fe345d00d0b6d31, 0x3fdf373ac39ceffe,
    0x3fa73a9fb6f9f049, 0xbfe0830649d15ce7,
    0xbfe86d1add34b012, 0xbfe271f5ba0fec12,
    0xbfb77587dd703888, 0x3fe19e6e09a07fcc,
    0x3fe88ae4c747e398, 0x3fe164b6cfb70aa0,
    0x3f901628afb39163, 0xbfdf13676bdc516d,
    0xbfe528182a0fb6e1, 0xbfe21ec918f8317f,
    0xbf9e2039e5e879c1, 0x3fdf36a7aea65d71,
    0x3fe692e67d802f24, 0x3fdf573af484df24,
    0xbfa412f0dc72c609, 0xbfe076d2722838b1,
    0xbfe6b0d9ca75f576, 0xbfdeac7903d2150d,
    0x3f87a0fb8ad4ca2a, 0x3fe175345761eb25,
    0x3fe541e3ae5ff16e, 0x3fe0c124296001ed,
    0xbf6e21e83e7b39a5, 0xbfe1518abd7e8e66,
    0xbfe61e20e8577f6d, 0xbfdf5f1228816a52,
    0x3fa4326589aeb63c, 0x3fe09bf2cf3c668a,
    0x3fe78979f5903393, 0x3fdffd195ba47156,
    0xbf8f7210d626d390, 0xbfdf2f03ad8f5897,
    0xbfe782b4688012dc, 0xbfdd9d26e57ec552,
    0xbfa66a2057d8ac93, 0x3fe0bd92771e4269,
    0x3fe3abbdaf57460f, 0x3fe1d989373dab17,
    0xbfa32de2679fb4a4, 0xbfde6fcb26eda819,
    0xbfe31de951b52396, 0xbfe0597fa579dfeb,
    0xbfaa6cc8129902ab, 0x3fdec7ffaa7329f4,
    0x3fe701971064dd10, 0x3fe0d9fd152ccb25,
    0x3fb79e0149eb74c6, 0xbfd8479d61952bdb,
    0xbfe524d3f75e87d4, 0xbfde42ef675fa0d6,
    0x3f6154f418f21245, 0x3fe172049dcd139e,
    0x3fe5bce823f34999, 0x3fddf5f6c8e6fcba,
    0xbf920cc2979e3f05, 0xbfdd237b1e33eddd,
    0xbfe50859eb789517, 0xbfe1b93bc8502969,
    0xbfa4e10b176806c6, 0x3fe01918513010bc,
    0x3fe6278696f0b2ec, 0x3fe00a59c41823f9,
    0x3fb5755385211182, 0xbfdf8a84d901407f,
    0xbfe5ba49c7e66a2a, 0xbfe0c7b4034dac1e,
    0x3f51b0e28cb52abf, 0x3fe33b1621c516e0,
    0x3fe56fcfe7c8be02, 0x3fde892d36c6117d,
    0x3fb0c2206d662be4, 0xbfe088722b172245,
    0xbfe6c0fbdad327f9, 0xbfe0e82bbbc5d95d,
    0xbf8fa94b166e1294, 0x3fe069add8341fc0,
    0x3fe4494765d5c3a6, 0x3fdc2dbfd9818c1d,
    0xbfb42e5adcf61994, 0xbfde40bed8c93b0f,
    0xbfe64e8abd1dea86, 0xbfda881dd4ed74b9,
    0x3fba9edc52b9c875, 0x3fdffcf100410341,
    0x3fe8164c82b94d60, 0x3fdbf883816e66ef,
    0xbf7902d9fdebb77e, 0xbfddd7f3f3cfbaee,
    0xbfe5d584d560f1a5, 0xbfdd3e0fb7fc1e47,
    0x3f72cd5618ef7d4d, 0x3fdd93fa0fbf6930,
    0x3fe46af28151517c, 0x3fe0680b65d5ad5d,
    0x3f96e38bd2aca2a5, 0xbfe268fe3f4fd51e,
    0xbfe4a34162c9ba6b, 0xbfdc44495d4df47c,
    0xbfae3e830ecf2f63, 0x3fded16ad0ac2461,
    0x3fe599c13f56a416, 0x3fdec8a99d304cf5,
    0x3fb6a9ffe61c2d0f, 0xbfe26713c4094e8c,
    0xbfe50152a3ed00a3, 0xbfde2c38aec41df4,
    0xbfbd50b78d9aef3f, 0x3fdd6691ab2a2427,
    0x3fe481f99b2ae528, 0x3fde9686c513ed25,
    0x3f9c090dde509a7c, 0xbfe272c4c9124766,
    0xbfe691dd4df13b7a, 0xbfe2c1dcd8b962b5,
    0xbfb3b8dd5ac2fc59, 0x3fe1d0b7eefbff6a,
    0x3fe69abf0afaca5f, 0x3fe0d0d83bdd0043,
    0x3fb1c9b59ebf053f, 0xbfdc59af584bc4de,
    0xbfe6fce840e147cb, 0xbfdd027800308b88,
    0xbfa6ffca695d02c5, 0x3fdac152c64890bc,
    0x3fe6f3ec4f57b9ad, 0x3fe0f5b66c348cfb,
    0x3f97634cb6f5bb90, 0xbfe05f716e085511,
    0xbfe6b871d845c792, 0xbfe310ffcae7326a,
    0x3f95f8eb037ec103, 0x3fe0514387649ce8,
    0x3fe6ab55c7a0765d, 0x3fd74b378faa9b6c,
    0xbfb02f8b15a4ce79, 0xbfdbe72eb0a70301,
    0xbfe726b92e361790, 0xbfe0cb442c91c487,
    0xbfbf0430597724e8, 0x3fe09777785c9f6f,
    0x3fe82d14205f12df, 0x3fdef546a4e623ff,
    0xbfb9ff006f7ddddf, 0xbfdb1e5c34fcedf7,
    0xbfe1c7016f8b45f3, 0xbfe075a9b3623836,
    0x3faa00684d09e920, 0x3fe017ed58f3595b,
    0x3fe756a91470e5d2, 0x3fdf361229a60c5d,
    0xbfac9ce16168172e, 0xbfddcdddab495cf8,
    0xbfe774de3488e352, 0xbfdfe24b7b5af1c6,
    0xbf9ed15b7213656a, 0x3fe03194be37234a,
    0x3fe7bfbaab58b562, 0x3fe1a427eddd5fbf,
    0x3fa1c93bf0aadba5, 0xbfe0def60f903fc4,
    0xbfe98f63836354fe, 0xbfdee854271663a9,
    0xbf90cddf4c2c7f54, 0x3fe05188c3d3f32d,
    0x3fe5567a67e2958e, 0x3fdf28a957fac5a4,
    0xbfabedfa1568f2a4, 0xbfe294a36d2334e9,
    0xbfe3787b524bcee7, 0xbfe0fea86780f3b0,
    0x3fb628a26bac07bc, 0x3fde54d569d43e11,
    0x3fe3ea695ddbb048, 0x3fe094ccba139eb9,
    0x3fa63829a4dca7ab, 0xbfe288656efe8f81,
    0xbfe55ffe9452192c, 0xbfe025604627106c,
    0x3f9dba7af3a593d2, 0x3fe0cb85dd66ed81,
    0x3fe3ce88b4a6d12c, 0x3fe230e387790bfa,
    0x3fa11e6e819e1740, 0xbfe0e425f89c5519,
    0xbfe4b1de87c2fdb2, 0xbfdc9848aeb6fced,
    0x3fa3f19901de750c, 0x3fdba388f517b33a,
    0x3fe36b6ae8272dc9, 0x3fe2270ca63e785e,
    0xbf95284bc4e0a9e9, 0xbfdccb33ee97afec,
    0xbfe86001e0618877, 0xbfdfcce349382103,
    0x3f90b6624aea4d7f, 0x3fdf05d81a37342c,
    0x3fe2bea708f9211b, 0x3fe16e74a09d00ff,
    0xbf7c7e1878907fa0, 0xbfe051d950c060a4,
    0xbfe72153b2168fdd, 0xbfe075d2bc182cb8,
    0xbf9abebde7c017a2, 0x3fdcb184849114f6,
    0x3fe50cd57387b209, 0x3fe05d660c9a0d7f,
    0xbfa18b79a7e1fa5d, 0xbfdabcdc6e7a914a,
    0xbfe6f03428b94ca5, 0xbfdfb6b9763a6f3b,
    0x3f8668d516319cad, 0x3fdefdf862bdb8f1,
    0x3fe4836ee5e2918f, 0x3fe24e40fc538c50,
    0x3fa84308da570c0f, 0xbfe1f7af4b50f07d,
    0xbfe709806eabf9fe, 0xbfdd4352e1d2ecaa,
    0x3fa062f2ec1b85be, 0x3fe0adbca31c1117,
    0x3fe560fbd7c2b481, 0x3fe0867dea0969df,
    0x3f9d4c5fe44e951c, 0xbfe0a0f59a04bd62,
    0xbfe75add66ecfeba, 0xbfddba09bcbce1c0,
    0x3fabf2ea2e5c0926, 0x3fe27150163b82b4,
    0x3fe6557b59acfcaa, 0x3fe2bd653f47ac5e,
    0x3fbeb761e21127fc, 0xbfe18bdd13a20157,
    0xbfe8148359670d09, 0xbfe05c91d4cc1dc6,
    0x3f92fe3061d58547, 0x3fe2bcdc6f36dd9a,
    0x3fe6f1901c722bb8, 0x3fdcf1ff67e163a3,
    0xbfa507ac61d0a147, 0xbfe12861818e8509,
    0xbfe496035604bb50, 0xbfe06dc1a93a4260,
    0x3fa6f7bcd0c0afba, 0x3fe09048650ffbef,
    0x3fe531d5dce6aed2, 0x3fe35f95392d8802,
    0xbfa3a0fe924e7385, 0xbfe06f99dd9b2f7d,
    0xbfe6cdba36c3b4b6, 0xbfdde5b6b87b7fdc,
    0xbf8bab4af8a01693, 0x3fe37340689e13e2,
    0x3fe7530257b2aa42, 0x3fde0326f35d10d6,
    0x3fa3a5498373c5ab, 0xbfdd846d87487b2e,
    0xbfea0fa607090084, 0xbfdc816238086fca,
    0x3fb60b1fb95a1931, 0x3fe0f7d138da3e6f,
    0x3fe664e2f66339ac, 0x3fde575b97da2586,
    0xbfb145e3bfaa3099, 0xbfdf0cda0fe35bb7,
    0xbfe7a10d4fbd8865, 0xbfdf327d3c1671d5,
    0x3fbbd2767c83e381, 0x3fdc5e2c8513f135,
    0x3fe7cd1877250970, 0x3fdbf65a91c174f4,
    0x3f907d44bdae82c4, 0xbfda2b8d61c1acef,
    0xbfe69754744db2b3, 0xbfde0ebaf65e6dd9,
    0x3fb0f3701bb5cd80, 0x3fe1bd232933c8c5,
    0x3fe6305ded9e958b, 0x3fdd2e7d9d0a934f,
    0xbf962e817ec0b6ea, 0xbfde549789355941,
    0xbfe63c52c9dcd574, 0xbfddcdfbff4837ca,
    0x3f848b612013ec5b, 0x3fdd5428851ca0fd,
    0x3fe7450a097ca1c5, 0x3fdec89b93652b07,
    0x3f75f8056a177977, 0xbfde3efcc58184e0,
    0xbfe6540a8e3ff74e, 0xbfdb8fdcafe3887e,
    0x3f91931c0012a7f9, 0x3fe0c3cc5a7a1639,
    0x3fe5eb958339dbe9, 0x3fe08ca7f894d64b,
    0x3fa1269ca524d73b, 0xbfe0a2a5eaafb6c5,
    0xbfe3e7dc9a186586, 0xbfe17327f3d5f894,
    0xbf9b71e92f2ced52, 0x3fe031a6f740252e,
    0x3fe71288b8e2e775, 0x3fddf773a9adda22,
    0xbf9a085598e1b765, 0xbfe19bc3ec6660c3,
    0xbfe69a9bebaf98d9, 0xbfdf675095206e77,
    0x3fb2e4a4bc1925f6, 0x3fe216fbfafa7355,
    0x3fe620f1cf34cffe, 0x3fdd23ff94e35bd0,
    0x3f883e4b99a6c24e, 0xbfe18be607b98d17,
    0xbfe466eab672b57f, 0xbfde3f0974db48c6,
    0xbfb9d4a4dd8e99d9, 0x3fdd98c0baa29ca1,
    0x3fe6aebbd0633f6a, 0x3fe03ae5399d648f,
    0xbfa2db108bd2ec7b, 0xbfda234324e9f0f3,
    0xbfe6aa440aa2b8ba, 0xbfdbccb10170bc68,
    0x3f8e0008c0122a60, 0x3fe04d8b0a8ed6b9,
    0x3fe62f878add0928, 0x3fdd93b3782aa7af,
    0xbf7977d26f167534, 0xbfde5b9039d3bce1,
    0xbfe634f38f4ef1a1, 0xbfe0fbafdbcec1e4,
    0xbfb56f30ec074f5b, 0x3fdd759c5037e42e,
    0x3fe93decaae9a649, 0x3fdd984e48989804,
    0x3fabb60d082beba1, 0xbfe143f10112762b,
    0xbfe4ea23520a706d, 0xbfddb02da69ae1d5,
    0xbf986a7054ec0ac6, 0x3fda83622f711c2d,
    0x3fe8f5433f2788e6, 0x3fe15c8b99a607ad,
    0xbfa1a60a97894d96, 0xbfdfe946a564f35b,
    0xbfe4bb460818c814, 0xbfe01b6bd1f1d772,
    0xbfb33e24de929c3f, 0x3fdb4dc16b7742eb,
    0x3fe6752ee8a72a98, 0x3fdbccfc1dcee6fa,
    0x3fb6bb1d2afcbb28, 0xbfe0770f9ca336c1,
    0xbfe572509423bad3, 0xbfe1f6d736b1bc27,
    0x3fb1e1b88e30010a, 0x3fdf6bc70bffd780,
    0x3fe54b39e724d5bd, 0x3fde080ba54ee111,
    0xbf51b98166acd81e, 0xbfdd2b2b1176e990,
    0xbfe54549feae13a4, 0xbfe0237171286717,
    0xbfbe40f1bb903804, 0x3fe0ad21b922ca06,
    0x3fe5e5fae976061b, 0x3fdbd16fca6b6238,
    0x3fad594b103dd722, 0xbfdac23a659e0f27,
    0xbfe41a6f1c28aba6, 0xbfe048117072bae9,
    0xbfa95382971e278e, 0x3fdf617577b39231,
    0x3fe6b174a62f9f58, 0x3fe04595e97d8fa2,
    0x3f9aff4294dd7b1f, 0xbfdffc436dd20785,
    0xbfe5ac7f10003c4c, 0xbfe20cf601955210,
    0xbf9f954ab5ae7dcc, 0x3fde00ff9020b2f5,
    0x3fe71182e95d659b, 0x3fdffe65665fe7b7,
    0xbfc170a74772eb10, 0xbfe0e43f740ff4d7,
    0xbfe3754917d1cc21, 0xbfe3ca2d0e5bb299,
    0x3fbb203b6036de2c, 0x3fdb1630e8f4fe12,
    0x3fe5cfe4e99ad102, 0x3fe06af741e74ed6,
    0xbfa90a93fd0d8d1d, 0xbfdc82beef87c482,
    0xbfe5a686b70c0bc4, 0xbfdf3ac58036e57e,
    0x3fc02f90d31911d9, 0x3fe046db64d84d2e,
    0x3fe673b178fae8be, 0x3fdef8fb6d9736d0,
    0xbf9eb0bf395b8a92, 0xbfdf5ea6c8c74192,
    0xbfe666716f4f8447, 0xbfddf2adbdd1551e,
    0x3fa4b9e063793a9b, 0x3fe041565bd9e26c,
    0x3fe7cf94beeefd36, 0x3fded7ee86cd6508,
    0x3fa832a26c006b40, 0xbfe1e96686279685,
    0xbfe5960ff3f76c2a, 0xbfe04e9eb7803240,
    0x3f8d48ac7717afb3, 0x3fde11a1e0cafe2c,
    0x3fe3eec274111a7b, 0x3fe02b97121762e9,
    0x3f59a48da3a1e5eb, 0xbfdf0c9984f54559,
    0xbfe72613b9dc6466, 0xbfd83a1b49aa3894,
    0xbf9f7be23b008604, 0x3fdc15ce530e968f,
    0x3fe4f10117f20626, 0x3fdbc3b71bc6cc2a,
    0x3fb324b7e9f8a633, 0xbfe034ae70e65459,
    0xbfe6d4bdf09273c7, 0xbfe124216d96c397,
    0x3f968f957d63ac1b, 0x3fdfd86e1c62ec9c,
    0x3fe78d94a9184f75, 0x3fe2d7a90f7782b2,
    0x3f86a447581b509d, 0xbfe1963b2b2e504b,
    0xbfe7b599e4ebe1b9, 0xbfde8d08a75852d0,
    0xbfb07ebf46cd3743, 0x3fdf651117d3f4d2,
    0x3fe5d1ccac84acaa, 0x3fdc4117410f74ef,
    0x3f70651543fbb362, 0xbfe10a26032c1ea4,
    0xbfe803ba7a14d320, 0xbfdd9434dcbccf71,
    0xbf89df25a79f4a01, 0x3fdbf0bc8836900a,
    0x3fe6baef4e118d53, 0x3fe0de6ae9fae812,
    0x3f8e7dcc32973bf8, 0xbfde4ad355ddb689,
    0xbfe4874ac6f5b996, 0xbfda9c7c8611ec4b,
    0xbf8ce2c5ee81512e, 0x3fdc848f1cbfffee,
    0x3fe88d43bf382ad0, 0x3fde7fe4c51f0572,
    0x3f99041a09b7d26e, 0xbfe13b226cba06c5,
    0xbfe80fffcab3c82c, 0xbfdeb7542ff761d7
    };

static const uint64_t in_rifft_noisy_2048[2049] = {
    0x3fab0667ea63d9a0, 0xbff71f57e2184a33,
    0x3fd1a1e3e4be0fec, 0x3fb71ddb3c79e190,
    0xbfefaa3877d737d6, 0x3fe598fc4ba3c24a,
    0xbfe7e6857b0d9968, 0xbfe87cb9b7ca31c8,
    0xbfd73590c05d3320, 0x400427513e5ef838,
    0xc009fc5bc8cb6ed4, 0x3fe8f5336e6e1d5e,
    0x3feaab07751eec78, 0x3fd533df19f6efeb,
    0xc0020ad2d063117d, 0xbfe7f44595a35674,
    0x3fe629e38f190220, 0x3fef0969585a66c6,
    0x3ffad0eda14837a6, 0x3fdf7e92fc4015ba,
    0x400613c19ee02914, 0xc00f21c030f929f6,
    0x3ff390abe9290e7c, 0x400981bc36445062,
    0xbfeb9ae4edb826d8, 0x3fab136a46ab71a0,
    0xbfe3239f4201afaa, 0x3ff1de57ffa14496,
    0x3fa1c007ccc25fe0, 0xbff5b2f5e5069eea,
    0x3fd5b6855050a7fe, 0xbffbb51bff7732f6,
    0xbfab455502c69200, 0x400bfa74f904fbd1,
    0xbff8f935ff080dc2, 0xbff74a3124482db0,
    0xbfc734a6f14a3638, 0xc005ec1c346671fa,
    0x3fe70605098af7bf, 0x3ff4d87e13924b08,
    0xbfffb134ac8a1b48, 0xc002c348637c230e,
    0x4002546c566895c1, 0x4003a095ec899fe4,
    0xc004362302515ed4, 0xbfe2b343ca7af20a,
    0x3ff5cbec53ded73f, 0x3ff405d45594aa6e,
    0xc005fd2c3157892c, 0xbff5d7e8a1063172,
    0x3fe3f63a38e3ad48, 0xbfd25903e6ea1fb8,
    0x3ffccdb481f780d0, 0x3ff1c88fcb293800,
    0xbfd224bee7df1cef, 0xbfb5fe8bcfaba720,
    0x3fc19810c1fa7fe2, 0xbffb9e93deb2cac4,
    0x3fedec5758a295ed, 0x3ffe1853295d6557,
    0x3fad9b49a8e91250, 0x3fea247433657a74,
    0x3febd35ab23f65c7, 0xbfe9f691be2032e4,
    0x3fe839cec18adc16, 0xbff54e236f330b9c,
    0x3ff7c0a0b343941b, 0xc002ad9721dc769e,
    0xc002937a3e89e99f, 0xbff5a5bbb07b002d,
    0xbfdcd4951085cb60, 0x3fe79dd387dc3843,
    0x3fdaff8b21232b3e, 0x3feafe69312f076a,
    0x3fc0e4cf0f1a4db0, 0x4003f260cdc08a02,
    0x3ffb332a33646f9f, 0x3fd43efda14d9a2c,
    0x3f80a43ac76c8ef0, 0x3fda7d94e91edcd0,
    0x400309d0ae39c9a3, 0xbfe668249462f128,
    0xc0011af4c7efde72, 0x3fec7cbf1c22dc3a,
    0x3fd2a2c8fabc315b, 0xbff6bcb1cbf737f8,
    0x3ff3007f4c6392c6, 0xbfe8ee44567e463a,
    0xbfe4abec04b9acd3, 0x3feb21fd0c5ecfab,
    0xbfa74d051fa42110, 0xbffab532c9e3e56b,
    0x3ff07aac3a8ec39a, 0x400bdc0fa9e02c7b,
    0xbfeb44e313591f1d, 0x3fd7ba5ef648b16c,
    0xbffef7746bf1646e, 0x3fe70587f0a08a48,
    0x3fee62e257314cee, 0x3fa9a029bbf369f0,
    0x3fcfb7c54e2ef75b, 0x3ff9d076e7aedaa6,
    0xbfde97b6a990c069, 0x3fb301d1d1321a10,
    0x3fe78a4592911e14, 0xbfd04a7f93baac14,
    0x3fb221246b2dc414, 0xbfe6637991ff0eb4,
    0xbfaa056c68491040, 0x3ff7997c377567d2,
    0xbffd1336570d1f71, 0xbff117457a47b934,
    0xbffcf628e1987197, 0x3ff87d89bdffbbca,
    0x3ff63b1fb9ccf31d, 0x3ff3459bf4ab309b,
    0xbff355e0c2ca12fa, 0xbfee95b0e50bc52d,
    0x3ffe1c205496763e, 0xbff16241400ce10c,
    0x3ff13430695c3773, 0xbff3532b30c70ee6,
    0x400602740152b75e, 0xbfda44d68ac65d84,
    0xbfeb5506558e6ed4, 0x3ffa2095cf4bb622,
    0xbff64e5dc707944a, 0xbfdc0fa57dc258f6,
    0xbfe6dc4a5ab95df0, 0xbffca0d8a9b193fd,
    0x3fed079149ef8a32, 0xbfd1eb64a0b58427,
    0x3fef72b9e48c852c, 0x3ff6fb233462ca28,
    0x3ffcf52564179637, 0xbfee9dfb69294187,
    0xbfebf46a28ba0fe3, 0x3ffa793ff22a8c36,
    0x3ffc2daea60678a4, 0x3f9d1daf4fac38c0,
    0x3fa6868705e5a5c8, 0x400647ee3b8e0764,
    0x3fc21738b5b8a714, 0xbffd4320edc71cb6,
    0x400210c83f1f62e1, 0x3f93753362cf11c0,
    0xbfdb1979d829d554, 0x3fe5a640e34360e2,
    0x3fdb8c2f79db80c2, 0x3ffcb23b538a05fb,
    0x3ff0053a3eeb0d92, 0x3fff7feaf5e0d185,
    0xbfeca4cf15ba45fe, 0xbfad18d529a02c90,
    0xbfeea7a01f647977, 0xc0026710d01462a0,
    0x3fe1ea3621bb7d48, 0x3feb141ba4b93561,
    0xbfeb4823cf3179b5, 0x3ff0e7ad8ab45e42,
    0x3ff0afcc77d0d398, 0xbfd91663d9997809,
    0xbfcafe088bbea8fd, 0x3fa896c3b66364b8,
    0xbff25cb3d1c7872d, 0xbff470b0c1f2a236,
    0xc011cdae691ee317, 0xbffebd7e503bf006,
    0xbfe0241ba149f48c, 0x3ff3bf68270034a2,
    0xbff3a974ee2f6a4c, 0xbfccd4ff2f86d7e4,
    0xbfbfe6416ead3380, 0x3ff5a513bab042d2,
    0xbfb28cc0d36a2a10, 0x3fc10e55202a5fb8,
    0xbfe76630bd1d4a26, 0x3ff88c29d4e63e54,
    0x40045c2c0cd00bb7, 0xbfe16fdf624a3016,
    0x400a087f923deb1c, 0xc0058e70c237bd95,
    0xc00505f301ee5aef, 0x3fe8e45dfd6a988b,
    0xbfb6f292b765594c, 0xbfe3ba3ad00a68aa,
    0xbffb9ff4e88027b6, 0x3fd4ca1c0fbaa962,
    0xbfce9f6b2c0437fe, 0xbff62e39e342ce40,
    0xbfdc98032bf4de9c, 0x3fd20d3fafe10417,
    0xc00aca0d80570f3e, 0xc008bb7050a541a0,
    0x3fda0e27b9ee5686, 0x3fe9bab37b7feb63,
    0x3fe728042b64fb94, 0xbff5fefab832dd44,
    0x3fc3bff64bdb6318, 0x3ffa510fc8a12924,
    0x3fd40368d4dfd97c, 0xbfc3795cdfec1ae4,
    0xbffe7108edcab12a, 0xbfca912df09b4808,
    0xc0057cb01d728d00, 0xbfe44c364cfab8e2,
    0xc0000a534a18018f, 0x3ff033ddd6289515,
    0xbfd4851bdf2ec2d2, 0xbff88fd56c029602,
    0x3fe71c12a56822cc, 0x3ff45a6169c45d60,
    0xbff63bc625d56448, 0x3ff0c5319c16f3be,
    0xc00e4b194e5008fa, 0xc004e247b6473134,
    0xbff01c598c7faae1, 0xbff29fbc40c7521a,
    0xbfde4a10adb0bb72, 0x3fef2065f7efd61b,
    0x3ffdf25ed88f7ea7, 0x3ffb165402eb70ec,
    0xc003461de256e346, 0xbfcdf031078e1d74,
    0xc004f15568c73a2a, 0x3fee51fb363c7b00,
    0x3fc89f0bf231f1b8, 0xbff289403170e952,
    0x3fec613988b5e02a, 0xbffaff23c0d6c285,
    0xbfe9a102c9001bf7, 0xc00401d7c6f2ab36,
    0xbff3f5cd6c33a781, 0x3ff4f1bc7b399360,
    0xbfc70dc336a7546b, 0xbfe8721a9745bf22,
    0xbfe5567d02d1279f, 0xc00b94dbdb6a8301,
    0x3fd1ce394bf58450, 0xbfeb28f40930ac7c,
    0xc001c081644b467a, 0xbff0bded14d0ba12,
    0xc00245070f87526b, 0x3ffee30fbb8d45ac,
    0x4009e867dc593320, 0x3fc27892d70137a8,
    0xc0001d38534a32b4, 0x3ff1a53669dd47c0,
    0xc004495aa3e38364, 0x3fcd812a15d35c70,
    0xbfeb1d3b2ace8832, 0x3ffcacf0c2045b40,
    0x3ff61cf1a60228d9, 0x400e8ac97c1b9d86,
    0x3ff0b8494dda2540, 0x3fd87d6d817b9dbe,
    0xc00a51198dae5a79, 0xbfb83e8b5034520c,
    0xbff2f93bd90782f9, 0xbff516b50b48c390,
    0x3fe936b9d8ca33f8, 0xc0012a6e064adcd0,
    0xc004afc05faec745, 0x3fce26efaae86400,
    0x3ff9380bfcd71964, 0x3ff6c30f1b84090c,
    0x3feb4003f67edd86, 0xbff0087085aa1174,
    0x3ffb0ab2f9197d36, 0x3f94c17af06bfb70,
    0xbfcd6ea23968719e, 0xbfe6cd5bf5d91f2d,
    0x3ff386e8eef53ad6, 0xbfb3d4c543f70968,
    0x40037bab81fce327, 0xbfa442ac08005a28,
    0xbffb2a246eb03460, 0x3fefa5f417ffb6e0,
    0x3fe07266263c056e, 0xbffdb5469e21d0e8,
    0xc00133f971cc443b, 0xbfe29278029f87e2,
    0xbff9467b12e9f772, 0x3ff6beb4c5ffda16,
    0x3ff23db602edeeae, 0xbfc7de24430462a0,
    0xbfccdddb7f111320, 0x3fd2cb426f1f9bce,
    0x3fb4a9e1723fe9f8, 0x3fe0759ccec36070,
    0xbfe703c159c8aebd, 0x3ff0a20624d18af6,
    0x3febcd43d77e37e4, 0x3fe5955f49312256,
    0xbff03b4805860b01, 0x3f79555f8c563b80,
    0x3fc0db329ebf6522, 0xbff4e7a17653b251,
    0x4004ba150c515f91, 0xbff47acf9766b558,
    0xbfcc840e835fc96a, 0xbfd656a844f6f164,
    0x3fd936823feb8309, 0x3fea5a9ead5640db,
    0xbfe3563d8819c57b, 0x400400d28df6aca2,
    0x3fbffdf985bd79cc, 0xbfd8a2457883a56f,
    0x3ff6ad40188280c7, 0x3ff0ce28ff1004ed,
    0xbfe1591f88eee6c9, 0xbfe1f5368db5abb3,
    0x3fce0d28a2313664, 0x3ff90944a5d50e68,
    0x3fd7c4c60583e4bc, 0x3ff3864fffc7f02e,
    0x4003393e1147695e, 0xbfdf4b3a175ef3b2,
    0xbf8f60445994b160, 0x3ff800dc2c1c0fb2,
    0x3fc485345f071e02, 0xbff3240067240cf4,
    0xbffd1f4a6753c878, 0x3faa942f396eeb70,
    0x40104d4ad8774026, 0xbffe1fef24e81990,
    0x3fcd79d5fbf2f1c8, 0x3fe2b118c3bf625c,
    0x3fe15ddc0f1cdd01, 0xbfd4352fa1b340c0,
    0xbffb7c6cebbf861c, 0x4000e97288291f18,
    0xc0047e419f0a2423, 0x3fe997d2a93d26f6,
    0x3ff463fa5e323ab9, 0x3fe9a01f0aa8cff0,
    0xbfe7c056b67471fe, 0xbfffecefe14bb75a,
    0xc00129cc4111906c, 0x3fde4b35c84ac0d0,
    0xbfd2b973346c1108, 0x3ffe9213f73f861c,
    0x3ff3f4416d184470, 0xbfe00d53e22e3aa0,
    0xbf846d3194905ac0, 0x3fe2f390fa98c8d2,
    0xc006ad1d01e7223c, 0xbffa4be46d0af6ec,
    0xbfb95d96496c5fbc, 0xbff10e053ff64239,
    0x3fed9e0c3c4c8a9b, 0xbffcbba670d7ebd0,
    0xbffdbdecabf7a533, 0x3fcb2a4e69036df2,
    0x3ffd9aa4ffafc0e7, 0xbffd8121246479a0,
    0xbffbe4b82c536f89, 0x3fddf37dfd98c8bd,
    0xbfe48fdca90cbd0c, 0xbffc1b7d58a5c563,
    0x3fe3bea5bcff86f6, 0x4010a472dbb92297,
    0x40042f8a4da3bb0a, 0xbff68bda0aaa9d23,
    0xbff243d4da38e2d8, 0x3fd01c8d5f8f88c1,
    0xbff1e14dfe9fbcb2, 0x3fef513443c10e73,
    0x3fe838735c6fbe36, 0xbffcf1486c6aed43,
    0x40074f7b75c7bfb7, 0xbfe5028a7931477c,
    0xbfecc890111a813f, 0xc000cb914ebc5068,
    0xbff8e109c24d23ae, 0x3fe20c70bb2c27d0,
    0x3ff97b2dab0417d0, 0x3ff15b7e6dfd18a8,
    0x3ff19dd78fe14ba4, 0xc000e77ebdaaba68,
    0x4000acc75125dfb5, 0xc00a0946ea11a4db,
    0xbfa91e50dd521318, 0xbfc2d673d0f9a724,
    0xc00f7db9db26c24e, 0x3ff1443b2bb146b7,
    0x3ffbb22d036d6490, 0x3f8223465f676140,
    0x3fedf6bdd4010cd8, 0x3fce38697fc2a45c,
    0xbff253f5b1e7c8ac, 0xbfec09d8f5c6529f,
    0x3feed18c4ab3c39e, 0xbfc0858e06bd0332,
    0x3fd94da0d40764a2, 0x400ee894d3ab53bc,
    0x3ff597e88d97213e, 0xbfe1ae9c8ca19e44,
    0xbfe1df3a8bfc540a, 0xbfc0422b7dc147da,
    0xbfce8984d023c3b0, 0x3fe533c599f5af21,
    0x3fc3f9e3fa1b9bf8, 0x3ff432fcb5dff03c,
    0xc0051ccd5fc9db47, 0x4002501eb3016954,
    0x3ffd9941789ae999, 0xbfefd79f29facfb4,
    0x40084c40c8f6b451, 0x3ffb3b78bc6646f3,
    0xbfe360a4c340e778, 0x3ff38f053d64bcae,
    0x3ffb2ac066c23edb, 0xc001a973d60d1e6e,
    0xc002ca5c8f72c5e0, 0x3ffe63642ba866c8,
    0xbfe18e081cf810bb, 0x3ff80f2861b8bd38,
    0x3fe8b4c1c3894f4c, 0x3feaeccee41e8baa,
    0x3ffd3fada454a136, 0x3fc5187ab3a72190,
    0x3fec3d011facd0cc, 0x3fe27fceeb62cf84,
    0x3fb7206362ba0798, 0x3fe118b4bbf5516f,
    0x3ff0ea46f1da6f16, 0xbff47b2bf9ae6c50,
    0xbfdf4f493e22ef2f, 0x3ff3f69a47e2fb47,
    0x3ff9dc27e4266b54, 0x3fcb4b199b117140,
    0x3fd89081d55f6301, 0xbff2dd62a22a4eb8,
    0x3f8577f11abaa740, 0x3fee591e9dc10481,
    0x3fdca5759f4fa373, 0xbfe2f23e0b7ccdfc,
    0x3ffeed27851cd340, 0x3fe0fa9a8152846a,
    0xbffde1a26a1add7d, 0x3fe47bac3a5d286a,
    0x3ffe8948605b3368, 0x3feac4a0d0d7c596,
    0x4003b6aa097c96e2, 0xc010b6d5e65c2878,
    0x3ff17906b5cba5bc, 0x3ff93186f852e752,
    0x3fe986a9138bfa17, 0x3ffd0a0e5bf0ed01,
    0x3ffc2b2c7b92db86, 0xc00151a578c0e829,
    0xbfe838e529e37344, 0x3fe6164120def89e,
    0x40007f6831d81ab6, 0xc00271f35facb3c8,
    0x3fb4f258920201d4, 0xbff8dfd9646f55de,
    0x4006f3d8b3627e46, 0xbfed97e13053dcfd,
    0x3f88f01af0989a80, 0x3fca85ca9c32897a,
    0x3fe97c0e8661ce68, 0x3fdde3d7aa92ef4c,
    0xbffc600ec6844a21, 0x3fe2a5f99021ca2f,
    0xbfd2c870de880dd5, 0xbff7826a23cb0d38,
    0x3fc865ede0e9c1e2, 0x4000fde17c24d0d7,
    0xbfcb915790f1b630, 0xbfb0ed2df566d35c,
    0xbfe073582b16b680, 0xbff959844fb176ae,
    0xbfe0cbabeb6c4470, 0x3ff7b1f615afa2d0,
    0xbff66b95f9cbf558, 0xc00c996483216158,
    0xbfe35fe1ff2ce456, 0xbff7769b8269da88,
    0xbff12f2589adeb20, 0xbfaf5c1e22e8e780,
    0xc003ad51007a736c, 0xbfdc53f1afc2dcdc,
    0xbfd62c756c442c2c, 0xc0027146c6295a3c,
    0xc005dbfe4783c5b2, 0xbff6b9961274a786,
    0xbfd9ab2aa494c7b7, 0xbfd7985ae4bc9003,
    0x3fd96b5618c90ecc, 0xc003942694973510,
    0xbff7e71e6c24f0b5, 0x3f9d25db2bc8afe0,
    0xbffe8a6e7b1d151c, 0xbfbc61c5167118c0,
    0xbfe1e74d7733358f, 0x40087b3a19c0165b,
    0x4005619dad723b59, 0x3ff30a04d646eb10,
    0x3fe620f7d0fc13fc, 0x400b23b69a42408e,
    0xbfa661978edd76c0, 0x3fec7790abf20782,
    0xbfdd98bac67b6b7a, 0xbff645930f0bbeb5,
    0x3fdaf7aee5862a53, 0x40012e68151a5f60,
    0x4001dffe1c59d124, 0xbff2305251c9ecbc,
    0x3ffe0b5daab47d6d, 0xbfe6d36a603fd804,
    0xbfffce465c8de6be, 0xc086621cae230b0c,
    0xc0037795f9b41d27, 0x3fd0d046a8a8d7de,
    0x3ff28d411e6d45c2, 0xbfe11d2ed6a5cc30,
    0x3febdb18039a3cee, 0x4006be1c9e04e8e8,
    0xc0042bf02d4d3904, 0xbfe0c9e2258e3696,
    0xc00857776ae9ea0c, 0xbfe04d7f1ac64b7e,
    0xbff59269fe687cb8, 0x3ff42a588150bf91,
    0xbff4d81b3e3859b3, 0xbfc5d91ed4e1dbcc,
    0xbf8e85b15555e100, 0x3ffe472f06ae94d0,
    0x3ff5a9c01a3c7aab, 0xc00db1d7ba1a5795,
    0x40069ab52a27ec16, 0x3ff21c8cc14acabd,
    0x3ffbca576de963de, 0x3fdb5620013aa17e,
    0x3fe7b5472a6b229c, 0x3fcb872aee0d88b4,
    0x3ffb047d29fcddb6, 0x3fd534d11505cdb6,
    0xbfdff2fdc04d0402, 0xbfdf6e3fa65813a4,
    0xbfeacb3fcf8aa104, 0xbff2a5275c3d18c6,
    0xc0082bfc51d24795, 0x40076144e7e59ab4,
    0xc003e2ac85392f15, 0x3ff6acd585349948,
    0xc00a7f4f09771834, 0xc0004a90943d9a88,
    0x3fe467e1fd288629, 0xbf9f7f3628d6a540,
    0x3fec04a2059f41c4, 0x3fe357b3912b2540,
    0x3fe990c8497caaa8, 0x3fd03bff2242f14c,
    0x3ff7b75e6c044dd4, 0x3ff1fe1147ca6289,
    0x3fef0d14e994e6f0, 0x4003e2439e701508,
    0xbfe17adbf18a2262, 0xbfe761ad9f75fda0,
    0xc004942284f6deda, 0xbfb3006ffd27c7d0,
    0x3fde4300811466eb, 0xbff9a33f62b7faaa,
    0x400337acb3aec66c, 0x3ffffc9680700146,
    0x3ffd389dac704686, 0xc011793afe53305a,
    0x4013b6fc15c4479e, 0x3fee286cbf9c2246,
    0xbff1ee541f8767af, 0x3ffb3011ee3b2cb9,
    0x3fb3345fef43d024, 0xbfeb61388bcd3ed4,
    0x400bf10a2ba0ad0d, 0xc00d17481c7e8b00,
    0x40031a84b5f992c3, 0x3ff3a3e46a63233a,
    0xbff97c936aefde8e, 0xbfb718020fde5910,
    0xbfd33a2f95721c18, 0x3ff943a78b7a8116,
    0xbffa6ab45a1bac2c, 0xc0045183301f2de0,
    0x4010c9e7b229f01a, 0xbff472569ba8865c,
    0x3fc1ebe080c0c7ec, 0x3feeac53e5d67516,
    0x3fc6582c70baabb8, 0x4003641c4040b8f0,
    0x3fe921aa030acdbe, 0xc006f3c5080f6730,
    0xc009e206bfb8aa78, 0x4003dd7aca3a9932,
    0x3ff07fa3e0039d17, 0xbfe061e84bd179c0,
    0x400557fc3183a12e, 0x3fe62c46c611ff38,
    0x3ff8cd0d5d165d7a, 0x3ffd463edfd0901f,
    0xbfe9351abd5427e1, 0x3fd3b58e16287261,
    0xc00e125934a59888, 0x3ff52ce03c3dcdb7,
    0xbfe4704bcf0c5a38, 0xbfb8d54081c9443c,
    0x3fd9b7e3e25d8ec6, 0xbfb9a45ce4dbbdf4,
    0xbffa9ff8701e2d98, 0xbfee78d0e6c3d8f7,
    0xbfa14288a51a5570, 0xc0004ff0b604e357,
    0xbff8dca0151e4577, 0xbff3520648731ada,
    0xbff362f8fc302a68, 0x3ff2eb74e95ccbb2,
    0xbfe36ce9d3468b0c, 0xbfe34144fbdeb82c,
    0xbff5b3e98cb29aac, 0xbfe957fced062f36,
    0x4006b02ee2babb22, 0x3ff5da182ec26ce5,
    0xbfe1e4b1e5e12632, 0xbfb02cc96a702e08,
    0x3fed4fa5211c9ca0, 0x3fb38473a0d81ba0,
    0xbfee7df494405d10, 0x40021df316b881d4,
    0xbf99d2d7f2d009e0, 0x3fcbb5bb080de0fc,
    0x3fe93f7e8d7f57a1, 0x3fffd5cb45bc95dc,
    0xbff5ca4a71bf60fe, 0xbfd60f646633a35a,
    0x3fd3b0ab7cf27400, 0x3fc03854840b2020,
    0x3ffc60d1b968ae28, 0xbff189bed5f8f87e,
    0x400102cbb5454045, 0x3ffec057e6945f44,
    0xbfd05c8569ff6672, 0xbffa89d7b0a2b4ef,
    0x4005f0a610869850, 0xbff5b0a44c842290,
    0xbffac4b8faf3700b, 0xbff3fcd2b4920238,
    0xc009b8ab885cacfe, 0x3fcfbd5c96986f1a,
    0x3ff2aea1c007e933, 0xbfeeedcb36e9839f,
    0x4005be48b8122143, 0xbfebcd4b733025d2,
    0xbff7a796b0b511cd, 0xbfe123473b423d0d,
    0x3ff622bf9db44524, 0xbfd0c646647d5f43,
    0xbfc7e0ae4f92a4f0, 0xbffd75654ec75842,
    0x3ff17c1061215fdb, 0xbfe367be0de2a418,
    0x3fab4cbd947e8140, 0xc00f7a6aacec0302,
    0xbfec334e62ce243c, 0xc00975d84cdab7d2,
    0xbffa2e3e0df79729, 0xbfe5acf0debf8d30,
    0x3fe4b4e244c8f603, 0xbff08474e21864c4,
    0xbff4e162fc24f756, 0x3fca125d759c7593,
    0x3f9ddb88acfc3810, 0xbffe1b384eb72ef4,
    0x400730c9a6a381b1, 0xbff6543d09063293,
    0x3fe0cc5cb18a029f, 0xbfec4fca35449486,
    0x3fe118cf8d4490ae, 0xc001c6425cb669c2,
    0x3ffbf10c3073f432, 0x400a28e6259f5b3c,
    0x40031508fe4987d3, 0xbfd0983845e149f0,
    0x4006a043663d210d, 0xbffa1bcef2bd4256,
    0xbff522281326ed85, 0x3fe8713ee900103d,
    0x3fb65bd145d26c1c, 0xc000454d08f767f0,
    0xbff3e8cd1fbf7a82, 0xbff1d8e64eedfb12,
    0x3ffbd9c9b65596fe, 0xbfed16614af1c788,
    0xbfe851a3b5f9ad75, 0xc01326d27b15cd6e,
    0xbff12402b824169e, 0xbf4c811460150800,
    0xbffda69e66fa0fd8, 0x3ff3e0de98e4cad2,
    0x3fdd97fa4d78dbf8, 0x3fa9ffe4595390b0,
    0x3fe7f18e9a3dfa60, 0x3fdfed6f46b8e674,
    0xbfe9af21fcdbfbf3, 0xbff010a0b86c221e,
    0x3fffb9a7810fef42, 0xbfeb8710d042c2ba,
    0xc00de447908fb19e, 0x3f8424635955f760,
    0xbff0f20cfa89a35f, 0x3fe800bf37564d21,
    0xc0027db2a9fdb81a, 0x3feab5dd036143cd,
    0x400b73762cccf973, 0xbffcfc9489605866,
    0x3fc8843c1714e2a8, 0xbfe9496ab4198ac4,
    0xbff1691c8063a8ec, 0xbff57c612011c12e,
    0x3fce0f76b39d871f, 0xbfd15e797ece57c0,
    0xbfff71b28db77263, 0x3ffcea0eee2f689c,
    0x400131cc1804a6b3, 0x3fdb602382619cb1,
    0xbff5511fb65726fc, 0x3ff9322d0ad673ea,
    0xbffd17f3606fa633, 0x4000e30556c47161,
    0x3ff7921b99c8e2d7, 0xc0011bd586e5dc8f,
    0x3fb07d3ee57fe410, 0x3f8bde2c253b8540,
    0xbfb480aade3a5a94, 0x3fe5b51baeed96fd,
    0xbff822a69c7130e5, 0xbff3d4bd0540d797,
    0xbff93067daae886c, 0x3ffe4137567f9e7a,
    0xbff9e7bcd722239a, 0x400b78303725e7fe,
    0xc0066b81d0a7ebd6, 0x3fed1e60b4f7bfb3,
    0x3fc26aa661e18b08, 0x3fecd60bfa274cd8,
    0xbfdf9a12815ae89c, 0xbfb854924840e534,
    0xbff4805a4fade0ce, 0xc008f9873458b172,
    0x3ff1f78ef78132ca, 0x40025ea046d424d8,
    0x3ff5ee906e8f0698, 0xbfe6b44f7a01623f,
    0x3fff77ce3352b431, 0x3ff78ee54a56f4be,
    0xbff7f61761337520, 0x3fed6271caee426d,
    0x3fe19cdea924f258, 0x3ffa8b0e2570519c,
    0x3ff6ec2705709d9a, 0xbffa4e7adfa2049b,
    0x3ff01025bb5eade7, 0xbfe468ed593b05f6,
    0xbff9e698fcaef56c, 0xbff8d83891065d3d,
    0x3fd2cdc43eef2078, 0x3ff6c84bcd9e2b19,
    0xbffca29f3b7b51ac, 0x3fcff5eadb03d700,
    0xbfe382429b5fffb4, 0x3fe57f52204e0d7e,
    0xbfcaec617e957002, 0xc00b7f5e7dbb66ad,
    0xbfd519c76ac6d1be, 0xbff0ae1ac76595a8,
    0x3fdc8a9cb6edcf44, 0xbff006e6a4af7870,
    0xc009e482052bfff4, 0x4000b061f4f95de4,
    0x4001af84e3344ab6, 0x400a96b0363e700c,
    0x3ff09f36e51128e8, 0xbff6ac338a4c7c90,
    0x400fb5b25aae477a, 0xbfd77a3a0ce26b18,
    0x3ff6f4b55e89115e, 0xbff4d0c0cebf047c,
    0xbfa0ca21ed51a8e8, 0x3ff530afa24f6d95,
    0x3ff82e7898247d9c, 0x3fd28da9db480ff2,
    0x3fe7d786c108eddc, 0x40020b6b45f759a2,
    0x3ff955e30928f4f0, 0xbfeb36265fc57d43,
    0xbff6b4063fb21848, 0x3fd2f4a32764c7c2,
    0x3fca541da11c9408, 0xbfe1f3ee3e6591e2,
    0xbff20fdcb69aa5a0, 0xc011234ec3a7af1f,
    0xbff7ca2157a8a7c5, 0x3fe38daf6dbb0f81,
    0xbfe07a3952a9a779, 0x3fff05502ec0d671,
    0x3ff69fa2017f02d6, 0xbfc210fcf7c89ee8,
    0x4002d2746595384d, 0xbfc843250895cd84,
    0x3fd19b367546ff1c, 0x3ff4029fe777122d,
    0x3fe3b7b37b493d74, 0x3fbfe34e0d241544,
    0x3fff33e955cedcf2, 0x3fd046b5a2570708,
    0xbf855bc3d02a7c80, 0x3fc731f773b6ba28,
    0x3f90b8ab37909080, 0x3ffa4b622a818ecc,
    0x3ffa07b8e7ddb6ec, 0xc005d7e06f60ffdf,
    0x3fe56462d3ef1913, 0xc0144cf2d5f65335,
    0x3ff1d858b38b2116, 0x3fe80c3f7ad48a14,
    0x3ff4d5c3b594ca22, 0xc00089cf559bd651,
    0x3fe400b0a22ac754, 0xbffbc59446ce08a4,
    0xc006cf3510a23aea, 0xbff764c1912d4c93,
    0xbffc177dbef329ca, 0x3fe9016d48be7c12,
    0x3fe557e0686cae10, 0x3ff284fb1500b4ee,
    0xbfd727d9e7c6f3d6, 0xbfeb95c4c3cf5ff2,
    0x400904b59774bbb5, 0x3fca70d30e0861b0,
    0xbffd9ac24aed808e, 0x3ffeec5a83d44f82,
    0xbfe2b0fb1346d271, 0x3fc911181bdede70,
    0xbfc90d29b0ea0678, 0x3ffcea1f5083a02c,
    0x40039cb2e688ed9a, 0xbfbe8ed06935d0e0,
    0x3fdd3d0aeb4a27da, 0x3fb30cb0d4009208,
    0x3ff5e084c83be076, 0x3fd288fb3b21b41a,
    0xbff0cf7662b74d66, 0x40040d44fadf01ae,
    0x3fb0db2a567dadd0, 0xc00572417b907b3e,
    0xbff391cb65e3a31a, 0x3ffc66ee080d8086,
    0xbff64d3daf149b10, 0xbfe467a91ef2d0be,
    0xbff4e60445c2a798, 0xbffa3cb99c16330d,
    0xbfd7e12c6c38e657, 0x3facbf5d2b102360,
    0x4000f0493b02e0bd, 0x3fb917930bbb0210,
    0xbfddd6a23f85554c, 0xc0056925c09f768f,
    0xc0020401cc7d1d79, 0x3fe719a98875051a,
    0xbfeeeb95e0bb177c, 0x3ff2f5068e19c6e8,
    0xbfe421375c045627, 0xbfe5e38b30866f66,
    0x3ff9473127ef152c, 0x3fe1972501c88691,
    0xbfd3b52f1a3c7288, 0x3ffb360c421d3c56,
    0x3ff56d653e3810d8, 0x3ff9deaf1d2f989f,
    0xc00148c0bc82b3e0, 0xbfdba6357c5c22f0,
    0xbff8b72f27a36a3d, 0x3fd6f2ae4f251324,
    0x400cc07edb6db229, 0x3fc3604ccf8c2002,
    0xbfe1fba4bc78e3c3, 0x3ff69b96e7ebce7a,
    0xbffc2aef6341228b, 0x3fae912ae2dcefa8,
    0x3fe356a95f5f643c, 0x3ff1d89c086ab041,
    0x3ff39caabe11f421, 0x3fee07dff0af6032,
    0xbff874f5311e1897, 0xc00817b5a2642c42,
    0xbff93534632d3305, 0xbfd857b12ed21ed8,
    0x3ff681fe383054a2, 0xbffbc1fd7809dffe,
    0x4016e05b76882a48, 0xbfe5916719f59e6c,
    0x3fcbfcc9f52ad518, 0x3fd5bb29cdcce130,
    0x3fe26e7e8073a2fb, 0xbff36c3fc06bd44e,
    0xbfefb134826ad564, 0x3fe41c44930f8f72,
    0xbffc6e05ab11c8d0, 0x4003a543dfad928d,
    0x3ffc005b53314878, 0xbfd4409994e8bc76,
    0x3fd590c9b08e28c6, 0x3ff6ddedc49df1a0,
    0x3ff1c66c8e30ea4b, 0x3ff1f158ef2f170d,
    0x3fa74779cb080270, 0x3fe0f5610babef86,
    0x400ee355707a6d81, 0x3fff0f93fd3db7af,
    0x3fec699ac69bd6e8, 0x3fff23298da49595,
    0x3fc458dfbdde99d8, 0x3fec5ec65307fbde,
    0x400f43ec91accde6, 0xbfaa37a1b7800ee0,
    0xc00685d9f76af322, 0xbff417bf1b9631f4,
    0x400a638c1b461dde, 0x3fe49dbd345a4510,
    0x40009b18a9b32fcd, 0xbffd8e6dc32c98c8,
    0xc002f9b80e3aec10, 0xc01323c83e589ed6,
    0xbfee4aba1764a514, 0xc003dae423e715f7,
    0xbff5a64e2ac6e608, 0xc00f51f01a7746c4,
    0x3fe06dbb7d27a35c, 0x3fc52193502955ea,
    0xbfed77c2bcfad2e4, 0xbfdbe050f9e0ca63,
    0x3fead0d65a4f5d3f, 0x3fff0bc0e62195b6,
    0xbfd4439ffccc0278, 0xbfde1256237f7318,
    0x3ff213c3924a0695, 0x3ff2ab72846d0a93,
    0xbfdaa09e917d7df8, 0x3ff21081caed5b65,
    0x4000ce41a764a659, 0xc001b0e43319a676,
    0x3ff90654293300c1, 0x3fe0983acc0e1242,
    0x3ff4b4079583ed52, 0x3fe720e332f43d83,
    0xbff04b77c353ac99, 0x3ff0f03f087a417b,
    0xc00b4b5053fa9862, 0xc0010d5015b78da5,
    0xbfff1b70a78689c8, 0x3fbfdc1ce9a2fe6c,
    0xbff13b166a74c7f2, 0x3fd31c0248164e71,
    0xbfe50f212952adae, 0x3fe4ef9940529cbd,
    0x3fe644081f9c2ce6, 0x40028cd881d3e409,
    0xbfa19ad11524bfe0, 0x4002818c0348182a,
    0xc001669348aba293, 0xbfd70b98c1ae365a,
    0x3fc0ca38807cbce8, 0xbff49b36013977d1,
    0xbff60a9cae40c6fa, 0xc0086629975a90fa,
    0x3ff9f752933f1c31, 0x3fed2e72287ebe04,
    0x3f9da21ce57b29b0, 0x3febb877969b1722,
    0x3fdfbb214057f7fe, 0xbff8287094b1e3ee,
    0xbfee6f5b20c6eff0, 0x3ffb99be46fd9ba2,
    0xbfe22205ae10697c, 0xbff3fa13daa6f53a,
    0x3ff06c89c6cb11b0, 0x3fe4c2c2ab0f2c80,
    0x3ff395178eeba088, 0x3f95c71b41483b80,
    0x400716dbbaea0d77, 0xc006bfabb229b9d8,
    0xbfd62796039ad354, 0x3fefc04c2f9d5f41,
    0x3f9295fd551cd600, 0x3ff7158f66ba897d,
    0xc00015eedff1a4d8, 0x3fba7dbc7ef84afc,
    0xbff5c19814d499e3, 0xbfd74f1f355cd9b3,
    0x3fd7ded66915af15, 0xbfe4398da7f88d7b,
    0x3fde63d07f2f0bcc, 0xbfe4c2a61b35d874,
    0x400a739255b5447e, 0xc00b4a92e58f94e9,
    0x40074955c5a2d908, 0x3fe42b5989c7620e,
    0xbfed6e4671a2f144, 0xbfb86dc107ca3168,
    0xbff32726ae7007ec, 0x400592b352746e93,
    0x3fe917488e83f0ac, 0x401848e0eb1e0ab4,
    0xc007cb369a7c89f2, 0x3fe7a4d6d61547af,
    0x40080cc39df58e2d, 0xbff4a3bcd736beac,
    0xbff7e07f1104e8ee, 0xbfd9cb34686e7031,
    0xbff1c8cdc462ce0c, 0x3fff676e307bb5bb,
    0x3ff47ceecb9eb1ca, 0x3ff0f736a9122aba,
    0x3ffbba867d318c4d, 0xbfe141c581257d00,
    0x3fcdc579074c086c, 0xbff05e3663f8816a,
    0x3ff71413ee3d0a90, 0x3ffdee24ff153f21,
    0xbff65c6dfedf8b14, 0xbfe06be8b14b8dc6,
    0xc000643aa263ba39, 0xbfe8887aac7e1fe5,
    0x40012fcb1ef5a93e, 0xc000d0b78e1c3dd1,
    0xbff06873b80dfa0f, 0x3fcad7c6feba0820,
    0x3ffebfb092aa7e2e, 0xc001975516f75c67,
    0x3fd8e48a97602fd8, 0x3ff58250826eed98,
    0x3fedd030831fa9e8, 0xbff20dd6469ba44f,
    0x3fe8841c1eab89e8, 0x3fe9b73042827f84,
    0xc004e3c5032f3bf0, 0x3ffbdf8a8a20196a,
    0xbff51f021e03530b, 0x400074c06860c9bb,
    0xbff413ba8a13d4b3, 0x3ff3d3e10b00d0f9,
    0x3ff457afede5f6cb, 0x3fe90b4249ec7662,
    0x3fc621261484ae30, 0x3fe2ebf525a3f9fa,
    0xbff78799387eb0df, 0x3fdbc5a3e9239cfa,
    0x3ff2dba833cb998a, 0xbf7b6472bffc6f00,
    0xc0080a32baa5fe40, 0x40081f99a5a15969,
    0xc002d1f5cb12bf24, 0xc00e53ab6ee66d28,
    0xc0029ea33295ee29, 0xbfff209b3eba836a,
    0xbff0f959c3f430bc, 0xc00778a656117bcd,
    0xbfee6401ffed48af, 0x3fd6f88204902db8,
    0x3fad97eac98c2a08, 0x40075d585eb4cbea,
    0xc002745059924520, 0xbff74d295ec34046,
    0xc00ced17a3158c83, 0x3ffc8c088cfcc79c,
    0x3ff2f1a3bc48dcec, 0xbff3b147c35fc32b,
    0xbfe2388aa3df92f1, 0x3fda9f93df3941c0,
    0x400130d18119f55a, 0xbfe36645dbfea348,
    0xc0022085ef34d2a2, 0x3fe264ba76b48537,
    0xbfe7be60afd25ad8, 0x3fe2fec7c036f093,
    0xc001838faaa602ba, 0x3fe0bf8f72e80fa4,
    0x40120ecbe5987581, 0xbfe8da2f128ef040,
    0xbfc6110443722f80, 0xbfff82175ddba2de,
    0xbfd227f5443fb33b, 0xbfce626ba69d2898,
    0xbfe2f352f1f01703, 0xbff16e288d6db0ba,
    0xbff19d4bdf0505e5, 0xbfe39a42dd1bc652,
    0xc0066506bcb5cec5, 0x3ff0c116036ed752,
    0xbfd3e97982837432, 0x400030bdd4144e9a,
    0x3ff58d8c2228a8d3, 0x3ff91e75aba3d507,
    0xc00132534fe5c919, 0xbffc29235efc08e0,
    0x40041e3b6aaf5784, 0xbfe93b8f75110df3,
    0x3ff282bb85865896, 0xbfde6140e8c15e2f,
    0x3ff1d10512660146, 0xbfe13a8cd43c438a,
    0x3fa2eed1ecf40c70, 0xbfc306a105985c60,
    0xbfd602a92d9b7c21, 0xbff93ab7a63e3806,
    0xbff45df97ca853f6, 0x400343ec4129c5d5,
    0xbfdbe26cf91ee4e8, 0xbfe77daa8d3af5a8,
    0xbfc6d3baccc251d8, 0xbff279ae06b9bd59,
    0x3fac0bd7954c89a0, 0x40046e16a1820cba,
    0x3fe764f738c53ba8, 0x3fef6e28714b8cca,
    0xbff6e31646128c65, 0xc002e796fc792c6c,
    0x3fed2a6b1d0f4b24, 0x3fe63726b7d195f2,
    0xbff2eab1e787e2c2, 0xc005191d3a464e84,
    0xbffc4a2f6268350c, 0x40005f6bf094e020,
    0xbfed4dbf18936aca, 0x3ffc9eb3ff071843,
    0x3ff003233d0dcd42, 0xbfe976ce3968e2bf,
    0x3fe6eee4a7e7d678, 0xbffa59870075a81a,
    0xbff09847036b3084, 0x3fea14d83499614d,
    0xbff778bcf01abd7c, 0xbff5b447e7d619ec,
    0xbff292a86c1b400e, 0xc00864bd8d9782d1,
    0x4009900008b28966, 0x3ff89d9e5b410042,
    0xbfd817bb6a919798, 0x400560db3473b223,
    0xbfea4e3f7a790ab5, 0xc0027be296b5caf5,
    0x4001afca18092fb2, 0x3ffa7fb1ad2e1f20,
    0x3feaca5c34d0f10a, 0xc00101097841cad6,
    0x3fdf4e6d57c69800, 0xbffb23b5f7dd20d3,
    0xbf91fe7266714380, 0xbfeaa7bfa0808390,
    0x3ff54bda0258fccd, 0x3fd55dc0d5573ca5,
    0xbfe7e38503b5b669, 0xbff71e3abef49e32,
    0xbfd65065a7d038e8, 0xbfe45cad42ad0ed6,
    0xbffddd67142cd48f, 0xbff6446d3b7481fb,
    0xbfcb1451e7c301f0, 0xc0010501525e1e08,
    0xc0011615e1839964, 0xbfec650d02aebf7e,
    0xc006dd0d158320c5, 0x3ffbc76a788ff87c,
    0xbfd90625f1fa600e, 0x3fd6c2f13f7696a2,
    0xc0012394436dc7b9, 0xbfc20abf1d5fd680,
    0xbfd177dfff040fb5, 0x3fb2367cc8d7d940,
    0xbfd72d2d49bb18fe, 0xbfee2dfa8f6943c4,
    0xc00168017bc3b068, 0xbff3508306d2cd6c,
    0x3fefd310fac86f0c, 0x3ff78d44c86bffd5,
    0xbfe0e6bb8659c27a, 0xbfe3ce34f6d969af,
    0x3fd768711b1b1ead, 0x3ffd452a165f2a9f,
    0xbfffb2e04509dfb2, 0x3ffcedd5b696fa93,
    0x400645dedff4ca09, 0xbf8db6c832064300,
    0xbff37baaba0e2169, 0xbff42b97f40b0984,
    0xbfe7d5a11310e4cf, 0x4005a9a00ebe60f8,
    0xc00acff017db9a89, 0xbff44758b85cae4a,
    0x3fe53c0928f9b1e1, 0xbff3612f9955847c,
    0xc001c60612e86064, 0xbfef11bb43dae116,
    0x3fea6e82530e6522, 0x3feb0e769e0c1753,
    0xc00489ea5031e3c8, 0xbff6807502d8324c,
    0x400340d7795f6719, 0x3fe18e484d697d13,
    0x3fdcaf55ab015a90, 0xbffef8ba165dc75e,
    0x3fb4b8265c425786, 0x3fe6e5dc0273940e,
    0x3fc1172c335fe1fa, 0xbfcadce0c684ee0c,
    0x40018f03bee2fbb8, 0xbfe029309414949a,
    0xc0090cfca0766502, 0x3fe6528428520a7a,
    0xbfe29e7806506dc8, 0x400284f1b84788ce,
    0x3fb416123098c7f8, 0x3fe6c51c6b6e81f3,
    0x3ff624b4a654168e, 0x3ff7e37412568a90,
    0x3ff7e5312385a366, 0xbff5da51ad3b6453,
    0x3fc49cf2c080cb60, 0xbfeaa8df341af3f4,
    0xbffb4a2456d8fd26, 0x40023a9c19d8d169,
    0xc00558d477403c28, 0x400280aa7f8d4362,
    0x3fedb78b3f7d97dc, 0xbfe4437dbf88b8c0,
    0xbff350c0481ed79c, 0xbfdb9657f972eca3,
    0xbfe81ede88103ffe, 0xbfa2697ae6f532a0,
    0xbfe3f00dd20341ec, 0xbfe2bd271373b549,
    0xbfeb7c1e45d51b09, 0x3fdcab54a48d7b70,
    0xbff3de0201e7ec56, 0x3fd19068b8931fdc,
    0x3ff3bb6f9d8e4a17, 0x3ffb24da8f3efa38,
    0x3fdb4c309c22fe00, 0x3fef5a4e4c2ac2ae,
    0x3fdbc9038ff75f40, 0xc008e09bd90cc3ae,
    0x3fc66450fe61aec8, 0xbff06fe6762d63cc,
    0xbfe2844e401db337, 0x3f8f7894205b22c0,
    0x3ff085decdc95dcf, 0x3fe903fef786ceda,
    0x3ff65364a5714ee0, 0x3ff7fba8022e4cfa,
    0xbfe82841bafbba68, 0x3fe199c73d233d8a,
    0x3fe82efa47c8e63c, 0xbfe97eff5c471e38,
    0x3ff00365fda4123f, 0xbfe77d887391904e,
    0x3fe8f70fdc9237c2, 0x3ff6ab6b2d155aec,
    0x4004e27ea760397e, 0x3fe4615a4f021198,
    0x3ff00bad0c78959f, 0x3fd8bade9778cacc,
    0x3fe1434125f44f2a, 0x3fdb2616eb88051a,
    0x3febc7d95ded9249, 0x3fdb3f5ba296d2d2,
    0x3fda0485a1c1d4c9, 0x400678aa84ec00ed,
    0xbfe992db85fd7930, 0x3fddd84a930029e0,
    0xbff22a8d9ada5adc, 0x3ff5992f27098c9b,
    0xbff22c3849416abd, 0xbfcaf1e7ebb311a8,
    0xbfe1b23a8f5ed25d, 0x3ff09a3448cc5065,
    0x400c35ce985e9aa6, 0xbff8b06a53c7de35,
    0xbfef59c465543a43, 0xc000831cce427932,
    0x4018fc992c24b60d, 0xbff0d831b088be40,
    0x3fbf88377e83cdd8, 0x3fe03a9f64da63e3,
    0x3fdd670b8453b0cc, 0x3ff989d28d1fe2e8,
    0x3fe327d7c0288374, 0xbfdfc6ade66add32,
    0xbfdd094ec9ee3d62, 0x400a34fe501db974,
    0xbfcc8ae2a162cb4c, 0xbff24f078c0f5653,
    0x3ffb5035a717a0af, 0x3fd49fcda2893773,
    0x400457cf161b39e4, 0x400101739dd03758,
    0xbfdf0661a28b2d50, 0xc00072a8523028a5,
    0xbfe04dc88a0706fd, 0x40049b64b8b89f34,
    0x3ff62fd8717c653c, 0xbfefbc6027dd9c99,
    0xbff7506e3744d587, 0xbfdbc9f830b07d84,
    0xbfe3aa1312d706ea, 0x3ff72fcf68585aa2,
    0x3ff23cafe65aec49, 0x3ff8b01ead8dd306,
    0xbfdebd85c13398fb, 0xbfd25ff35db8dab2,
    0xbff9d1390d2cb2b5, 0xbfe958f5ca82f3c7,
    0x3ff629303816406e, 0xbfdfdf9ac252cfb8,
    0x3ff1f4449b10e05a, 0xbff18af9bea39494,
    0x40029dc92d5894c2, 0x3fd6afb6572c60f0,
    0xbfe1be085a3cf7e0, 0x4004cda50694f192,
    0xbfe79ebfe2f9ecf5, 0xbfba82102cfb7818,
    0x3ffed2e19dc73271, 0x3ff2c0ad8e589526,
    0xc00b318186f4a83f, 0xbfd5abaf6bf73090,
    0x3ff0396d23db3a06, 0xbff9ac20c576f6fe,
    0xbff8a34dd41125d9, 0x3fe36c634f53df71,
    0x3fe0d7538c56aa86, 0xbfb6296b22414cfc,
    0xbffb9743be70b050, 0xbff3a9f32f6f0b8f,
    0xbfffe26f77c307ae, 0xbfeec9f65e633ddb,
    0xbfc0d420e2044ef0, 0x4007a0bc40474a18,
    0xbffe261eec2ff142, 0xbff6d9717d54988a,
    0x3ff23921b8e0bb6a, 0xbfc115ca0f828b64,
    0xbfbbf8d2eca0cdb0, 0xc00424a3a9c4f1e8,
    0xbff3387e10dd6322, 0x400ec7d4c74ba0f4,
    0xbfd2f3c90f5c3ba0, 0xbfe4720fdfb91dfc,
    0xc0096f39f7abdf7d, 0x3fa63daf33dbc840,
    0x3febe6a2bd0e6c38, 0x3fe20d59e330a3b8,
    0xbfe68a452bcb113e, 0xc0027f121aef25ca,
    0x3ff3c68b92f35536, 0x3fec073f2420f353,
    0xbff9e2edb55866ae, 0xbff4f4dbea7cd2c4,
    0x3fe50be6efa661d8, 0x3fd46a180bb11450,
    0x3fef0a3e1414490e, 0xbfcaf1efd6e016b8,
    0xbffdf16849c9c9a8, 0x3fe7af3ddf7d3066,
    0xc009870c704b1147, 0x3ffd1d9167b2d0b5,
    0x3fe3ca1aec9ef9cc, 0x3ffcfa77009a7dac,
    0xbfdc770da16937b8, 0xbfc6b0efdc45f2fd,
    0x3ffd477697435198, 0xbff8346379ca28a8,
    0x3ffd76ec340b17fd, 0xbff7667bbb6e86dc,
    0x3ff94de9bee5b8c4, 0x4006206aa6d9052a,
    0x3fc44a6b003e6180, 0xbffcda5eafe75584,
    0x3fc4a2fcf882f940, 0x3ff8683819e36686,
    0x400228a750cdbcb1, 0xbfb838b09a609218,
    0xbfd6fedb2fd77508, 0x3fe1dcfc4ce0b512,
    0x3feb2ce0252249ce, 0x3ffb9c67d166146c,
    0x3ff0df6d222413c6, 0xbfe195520515a56c,
    0xc0053e4e9f99981a, 0xbffc7f3cd63c6934,
    0xbfe73e2be1c8c758, 0x3ff3ce66f2b148d3,
    0xbff3f57b2cf60fcb, 0xbffec368ff307f66,
    0x3ff72736e3e84e70, 0x3fdf09526675bd40,
    0xbfe53eb2a4aa9bb6, 0x3fdc8f166d556944,
    0x400b38116e5d5a63, 0x3fee29d19b609e63,
    0x3febd784eb6181bf, 0xc009e6fa9ddf98ad,
    0xbff21315d656cc3c, 0x3fbe52923fa71ef0,
    0x3fd1ccfd9601f3ee, 0x3fdb86f0c0013182,
    0x3ff23947d39d018b, 0xbff052d500760b9c,
    0xbff34a0d320c4088, 0x3fec88e60a81cf5b,
    0xbff4c2be5057b01e, 0x3fe2c8eb0d821ce6,
    0x400e1f99b9329570, 0xc005df8634e941f9,
    0x3ff78d1670995ecb, 0xbff1778c8d5c9270,
    0xbfd4b034fce982c4, 0x3ff76c0d739c1f3f,
    0x4000a386e819caf2, 0x40006f11f8aaa904,
    0x3fd9484ce812cf31, 0x3ff73b29fac4efe2,
    0xbfc5483735bd4404, 0xc00a17db6cf3f7a1,
    0x400065d17fe358b9, 0x3ff78b39acd60a1e,
    0xbfafb9f92df29350, 0xbfc46e802f9e4f50,
    0x3fdce64283b95286, 0xbff5f89aca4d14ac,
    0x3fd1118a26dd88fa, 0xbfe6992741b405c8,
    0xc00da77d3aa1cc4a, 0xbfea3dfe2bd73c6a,
    0xbffe7ad202b9ddec, 0x400d9b980aee39d4,
    0x3fe9f78135859011, 0xbff4a7da064aeb96,
    0x3fca48eaeb46d934, 0xbfe768f362315692,
    0xbffb5ddeee8d847b, 0x4005c04f44d208b6,
    0xbff85eaf992c8269, 0xbfe320282b97e5cc,
    0xbfe8ad4236fa1398, 0xbfedae08b72a79a8,
    0xc003a9e22ea28e6e, 0xbfbc5ca912b26a30,
    0xbfd76ee1316ed9d4, 0xbfefa8f731733d54,
    0x3ff49dd6fbe700b0, 0x401111713a51ba08,
    0xbf9c2bc1a4781400, 0xc00481f0c673dec6,
    0x3feac531122a55ab, 0xbfe3170fb1f352d0,
    0x40029ed73c954e9f, 0xbfed544c1ff656e5,
    0x3ffb6302d1386d02, 0xc00460818ced3070,
    0x40038f2f3e946ba9, 0xbff2e4bccf47cb22,
    0xbfdc51c20e1387f8, 0x40035e7800a694cc,
    0x3fecf07da35646c8, 0x3fe8abb28aa84f80,
    0x3fc1d0a823669c58, 0x3fa913e86730af80,
    0xc002dc87781fb673, 0xbff70fe189e5a55b,
    0x3fc2812cfa4f61a0, 0xbffde6770e3b852a,
    0xc00067a126d4f92c, 0x3fdebbfa5e439818,
    0x3fb1436a076cb1c4, 0x40023981175af679,
    0x400b788e80f8c9bc, 0x3fd83a3b99f5b00c,
    0x3ff8037afda9ffb3, 0xbfa476360015a728,
    0xbff16687475aed68, 0xbffc9bb13360bf0b,
    0x3fa90d8f5cd61600, 0x3ffc20351c46de3f,
    0x3ffa9d6c00024736, 0x400050cb090c3e50,
    0x3fe6060e054c1858, 0x3ff8e7706510773c,
    0x3fe4af6ec58dec11, 0x4002e33952270480,
    0xc001512aa8e8552c, 0x3fcd09dac3987b4c,
    0xc004ff4b53e193ff, 0x400140bd2243cdf3,
    0xbff419839d429d62, 0xbfeba7969e3db096,
    0x400a616177c704bd, 0x3fdb0d22f97426f8,
    0x3fb0723acebf8288, 0xbff5b338ad583d33,
    0xbffba5d3fe69d5fa, 0x3ff45f84a433f398,
    0x3ffe57a5a388c7d6, 0x400144173570830c,
    0xc004a49fc4e01009, 0x3fd0a38e1e435aae,
    0xbffbbf7f7c7104d8, 0xbff1657f57023b67,
    0xbff45074bf7a9481, 0xbfed1ea6c2ca65ac,
    0x400747716a156ba5, 0xbfec6d2645ef1288,
    0xbfe7dff06e383e2a, 0xbff7b989894b70d4,
    0x3fc491e4c2522ba0, 0x3fe7c69d5eddb65a,
    0xbffddb0646d01908, 0xbff293d034a74f35,
    0x3fc91223fbc0ef18, 0xbffbe8343a41ca85,
    0xbfec96a7bbe75d14, 0x3ff6f278b5efa05f,
    0xc0030c2aecd8e3f7, 0x400781c3a859ee30,
    0xbfd0a6abdba2a1c8, 0x3ff9f913a140d57c,
    0x3fcb4cfd263ee210, 0xc010adc59b3a7c40,
    0x3fea2cdde8391676, 0xbfffeca7c8fe3864,
    0xbfef198795806dc1, 0x3fdbbcf3981f95de,
    0xbff0228495366954, 0x40098f7da8eee7da,
    0xbff14570920d1e58, 0x3fec342b3a0b14e6,
    0xc0014d63d0fffba4, 0xbfd72bed967534a3,
    0x3fe30d364cd7a234, 0x3fdf1d10cb2c5950,
    0xbff81a6c48b4c45e, 0xbff6666651de4efe,
    0x3fc920e7f0b74d94, 0x3fcda19a8a6cbbb0,
    0x3ffbba8bd62f6e48, 0x3ff7ea56e9a6e53d,
    0xbfeaf851b46f6eee, 0x3fe7890183564b7d,
    0xbffe0b8f954dbf49, 0x400789e13d562ec0,
    0x3f5ede7e7bf82700, 0x3fd9acbca0e68cc9,
    0xc00caa9459fc8f90, 0x4004a7dce9ac8221,
    0xc009b66ab24264aa, 0x3fb8154cb84d3ff0,
    0x3ff5eafc70923f83, 0x400be81f2221d004,
    0xbfd33399e8b3c912, 0x3ff5bec62c8baac4,
    0x3fd1de786e138fcb, 0xbfe13fddce7d72b4,
    0xbfd4fb783b9a60be, 0xc004bf50f0c9fc5c,
    0xc005f89bc7d1a152, 0xbfff31b6eb740c28,
    0x3fd3867d9ef54d89, 0x400473af2eecdc6f,
    0xbfe4d3f256e003c7, 0x3f97041271df1370,
    0xbfd4d9a978d3946f, 0xbffc4ac77b56d5d1,
    0xbfd31fd5a62c1765, 0xbfd5aeff3c61dade,
    0xbff939122599af85, 0xbfe652efdbaa681d,
    0x3ff91904e4093350, 0x3ffad424e654ad67,
    0xc0002e1d8d6e64ac, 0xbfd48eaf92f2bc07,
    0x3ff71bb363b1ba33, 0xbff15ebee223a728,
    0x3fce2d9528f8a9ea, 0x3ff3281f7a9082a6,
    0x3fe0c4200b8c138f, 0xbfda9eef2889eb3c,
    0x400ca4de41f7bc33, 0xc002afc3bb06908a,
    0x40060bae5f02ea1d, 0x3fcd608f2ac94da0,
    0x400095c67e25bfdc, 0x400878096c4074b0,
    0x3feebf8c746576b3, 0x4003e999332dc393,
    0xbfd51e8072a0e7f0, 0x400dcf7c22b2c640,
    0xbfddf6e428c2893e, 0x3fe3922cd98b394e,
    0xbff4d9ce7b988a3b, 0xc0035bba4a0bb8fa,
    0x3fddd54d017e7e70, 0xbfd25addd9bea468,
    0x3fd2ad6ee510b083, 0x3fe9350a1d4f0970,
    0x3ff73051d454cf34, 0x3fe70b687d60955d,
    0x3ff2f8cdec2cc272, 0xbfa0b4bc6bb17cc0,
    0xbffd6688c90fe7ca, 0xbff10cb01b2f4201,
    0xbff782d7b7b62e14, 0xbff1da81c8f4cf57,
    0xc000159995adbdd8, 0x4000339dc3c5e210,
    0x3fdc2a8b10b5748e, 0xbfc57e986a8b2d88,
    0xbfe5a3a0f0251b26, 0xbfbf28424759e7d8,
    0xc012da791a910386, 0x3fd3f1d5f388b010,
    0x3ffe30d97ff65e0c, 0x3ffdbec1361c072f,
    0xbff1b9b830e9c3a2, 0xbff206d538b3ea70,
    0xbfd4c04a28f61dc4, 0xbff350fb5ce19d10,
    0xbfd90242a386bfe4, 0x3fe3583ef4e5a39f,
    0xbfbed419ffa153b4, 0x3fca6e101b24c32c,
    0xbff12c6736448e32, 0xc00740cadcdd8f38,
    0xbffb99e8efb667e7, 0xbff0035acfe3d908,
    0x3ffad0ab205e2e3f, 0x3fe243df4257443c,
    0x3ff9a33fe9a3c0ab, 0x40000343b2be15a4,
    0xbff1c5ea8f08e1be, 0x3ff2e2d02e3ad890,
    0x4001f00fd777d30e, 0x3fea3c64510961e2,
    0x40082e457b525475, 0xc001a569573954d7,
    0x3ff1e5044e7703a8, 0xbfdc78a583f78600,
    0x400c02fcde5228a6, 0x3fe259de9438547e,
    0x3feb26e2b678b223, 0xbff60cb709d2471a,
    0xc00043ace589ba17, 0x3ff0f1fe6e27f7a6,
    0xbfdd19dbc9acf6f8, 0xbfeafc83f1309c93,
    0x3fe3f42a7e5e48a2, 0x3ff2a937b76490d5,
    0xbfb10c9e6b3db14c, 0xbffb1b7217e85488,
    0x3ff1201c2d3ee102, 0xc00199fdd604f2bd,
    0xbff22d8f5ff45f94, 0x400448358e83f814,
    0xbffa4668420523e0, 0x3fb1a8678e6975d8,
    0xbfe664ca5f20b148, 0xbfef686c984eae42,
    0xbfec45ecfa5a7021, 0xbfdaaf5bb1a99f1a,
    0xc004f4e1fa369d59, 0xbfff6dc1ba1d93fe,
    0xc001d1e31f834d10, 0x4004205471f1ee82,
    0xbff2e88b40afd36e, 0xbfd376d4f05ba616,
    0x3fdccf74a6e89740, 0xbfc3525c8bc6281a,
    0x3fe6efcf5f17e0b5, 0x3fdc17264eb58574,
    0xbfeba48195b5aab6, 0xbfdc8e550ab648b0,
    0x3fb752d14cb7d7fc, 0xc00be5b91b7c9802,
    0xbffd096da95a4a4d, 0x3fc90f2c619eb02a,
    0xbff62f6264222897, 0xbfa8fac2ef72e400,
    0xbfea8aeda7ce85be, 0xbff358969c1a135f,
    0x3fd93def1aa7a6a2, 0x40016e2b37b3574c,
    0xbfec2155728f91ae, 0x3fe00b8c6d581a02,
    0xbfeda63ed8737354, 0xbfcfdaece77b748c,
    0xbfd614014a5c5362, 0xbff0a0d452ae833b,
    0x3ff661d27f2d3990, 0xbfe1e972a964f414,
    0x3ff4ad29a19f562c, 0x3ff607c65095c2ac,
    0xbfe222a2c4ec7da7, 0x3ff720c81d9c6a1a,
    0x3fff412478d185eb, 0xbff373964a2048ea,
    0xbfb85fc12966c950, 0x3fe245ca81373880,
    0xbfddbabb87678310, 0x3fff6cabd84fd1b1,
    0x3fcd3d22b1aa451c, 0xbfd50e797f8a04bc,
    0x3fd495a57e82b8a2, 0xbfe87bd55cac597c,
    0x3fffffc3343f16d7, 0x3fc584b60769eca6,
    0xbfe72ddae1be8774, 0x3fe9bb9f77012229,
    0xc00902a2c504ef88, 0x3ff68fdc55637330,
    0x3ff0e33b3cdc7347, 0xbfc921c5874f69e0,
    0x3fe12ac60848a938, 0xbfdea4216223064e,
    0xbfff83fca9ccd919, 0x3ff98ffa10d4376c,
    0xbff0bac3e47f737f, 0x3fe63f9f3a1e0251,
    0xbfffbc217f295d12, 0x3ff87584e97a16bc,
    0x3ff720873f89a588, 0x3ff1603b982eb49c,
    0x3fe092855133a076, 0x3fed95ee61aeb66e,
    0xbfe465aff93aef46, 0xbfd14308a8a808d5,
    0x3ff131064ca4590d, 0xbff381534f8f20c8,
    0x3fdb9ce52ad6e3ef, 0x3fe9246d94f8f447,
    0x3fc8012a84ba2c42, 0x3fdf0561d16d9c3c,
    0x3fec5c50cbd44ea8, 0x40099288b39a4902,
    0xbfd5f654a794fe3d, 0x3ffbb87bd2f9d619,
    0x3fe1ec42be5d6a28, 0x3ff983f667728752,
    0xc005ce4a80f1f042, 0xbff14366a1a2b33d,
    0xbff80908beccee40, 0x3ff926d0f3f72964,
    0xbfe83024a398be51, 0xc002c1169b7a04c5,
    0x3ff8fc1e39242d5e, 0xbff3363c2acf888e,
    0x400d0c3d87af11f5, 0xbfefd29ab3ecf3c4,
    0xbfeb6ede9db3d7a3, 0x3fdcd97d72e748e2,
    0xbfee0f5737ebd290, 0xbfef9ec04a52adc2,
    0xbfb52720bb9b0a52, 0xc00253beb2677702,
    0x3ff4a3f30138d95c, 0xbff4ea7dcb281b4e,
    0x3ff934e75f107502, 0x3fd732d86193e981,
    0xbfced48bde8e3490, 0x3ff410572ab1739c,
    0x3fe6ccd3dbe97944, 0xbffba9d5395f1cb8,
    0xc000893a4a1a9f1f, 0xbfe3e203ff0c81fe,
    0x3ff6042f5cbe19e3, 0x3fb9723c629410c8,
    0xbfb008730fd06958, 0xbfff01265beb072c,
    0x3fe01f0a4c504e8c, 0xbfe16a465af0dba4,
    0xbfece8fb41a2441c, 0xbffb659fbf8c5dbf,
    0xbfd3cf54f0726d6f, 0xbfc385d44218c834,
    0x4009199b2ebb0143, 0xbfec07ed05cfebde,
    0xbff03b7d5c4cb884, 0x4000f2d7e5dd6168,
    0x3fec988e46c70fda, 0xc01059dd7af06ea0,
    0xbfdc2b3c04541a41, 0xbfdd81ff0511a68e,
    0xc0023c03576c4208, 0x3fea85f86c519338,
    0x3feb6e985545707a, 0xbff5170f9b9b65f6,
    0xbfd68798fe7c5430, 0xc0039b47a501a8c4,
    0xbff9f7c3871c14b1, 0x3fa371143a22e930,
    0xbfc999a1047ce838, 0xc0019f180aeb33c3,
    0x4002c90b97e4cd26, 0xbfe820a4982c5a42,
    0x3ff846aa6e6e45f8, 0x3fd1ea7d34c080d8,
    0xbfacbb0556ee16f5, 0x3fd94bd690e114c4,
    0x3fcb246e51658d90, 0x3ff5e7de60b825ee,
    0x3ff7e3a137991a8a, 0x3fc8a261f0e98d80,
    0x40017fb9b184e93a, 0xc001966541bfbd0c,
    0x40025e1c21dff324, 0x3fee710c28cf96c5,
    0xbfbd2c738991fb10, 0x3fe1ef997cd99188,
    0x3fe4a0e795fcdf74, 0x3fed39520dafae69,
    0x3fe49efaf720c09e, 0x3ffbb20f96acec92,
    0xbfe3ac6bf3bc1ef3, 0x3ff0ce6b86dd7372,
    0x3ff2ddbc8061f34b, 0x3fecd88ba137a764,
    0xbfe9a2992454ff46, 0x3ff2b0a3b40dde5b,
    0xbfebcad88f15a0f4, 0xbff7b441a64963ee,
    0x3ff5527da941b556, 0x3fe30b80bcdeec58,
    0x4000613dd2758a84, 0xbffe74841bde6b7c,
    0xc010ed37fe57d8c0, 0x4001049dd08c088a,
    0xbfe96783a7db12c0, 0xc001ee0b623bf51c,
    0xbfecc6d39e21bfac, 0xbfe33a51fd30a7ee,
    0x4001112ac99bab1e, 0xbff3f5a2809fbc6e,
    0xc00504e32490d7aa, 0xc0027ce15222d9d4,
    0x3fd93f4b20e83bac, 0x3fb7356a03921df0,
    0xbff78d05d76164a6, 0x3ff44f8677921056,
    0xc001630adb28447e, 0xbff69ace97c8a799,
    0xbfb8cbd4dfdc3bc2, 0x3feaa264fa53a080,
    0xbfe7d0ce3ce19356, 0xbfd32de78db39530,
    0x3fff31cdc6642f04, 0x3fef234b77a3252f,
    0x3fd503d07bd45f57, 0x4007109dde33d582,
    0xbfea4b682b4250fc, 0xbff609a90bb5bb10,
    0xbffe153ae83733f3, 0xbfdbe3a68bfbeef8,
    0xbffcbbc158c9ebaa, 0x40003a7dc4168316,
    0x4005f4b7fc1f0ddc, 0xbfea6fa965a7c310,
    0xbfef0475e37532ea, 0xc00be796e8886f24,
    0x3ff6c18b6c85d7e3, 0xbffb16a9765f38fe,
    0xbfd89661842028e1, 0xc00095ae2a4dad4b,
    0xbff74877c91dd18d, 0xbf8ada0e5105b2c0,
    0xbff3b54388012243, 0xbfe023ed3dfbd03c,
    0x3ffc19b5e330c839, 0xbff07e983f6955b6,
    0x3fd198a715a7f514, 0x3fe4c353f593fe72,
    0x3fe80fd1a8be6787, 0xbff16ccbfecec8f3,
    0x3fc1c1670d16cadc, 0xbff73fba28638046,
    0x3fed6b3350856194, 0x4001064bfbc72c0d,
    0xbf9501cda6016be0, 0xbfeaa05d17d4501a,
    0x3ff22be48ed9d14d, 0x3ff1eb9110ed9b4a,
    0x4000fbf4c88632d7, 0xbfef2bdc5822764e,
    0x3fd72f7c0985e46e, 0xc00021d7163ec974,
    0xbffa22cae77adc03, 0xbff085269546da2d,
    0x3ff024afa4cefa80, 0x4001d5e05ccebd9c,
    0xbff384f7325a089e, 0x3fb3ae7aef0a0900,
    0x3fdc04854dcd9d97, 0xbfc02dbd44b59978,
    0x3ff73ea50c959586, 0xbfff0a60a8a5b911,
    0xbffb6b010567fe30, 0xbfd11ed9cccd17a2,
    0x3fea622b846c85be, 0xbff610773d263ee8,
    0x3fec0ef01b2a61fa, 0xc0055ec40a3eacae,
    0x3ff404e6f1b87609, 0xbff3f4227e6f4151,
    0x3fe4a611f8dc66fa, 0xbfc0b072f4afcf08,
    0xbff9b1f1ac6143e2, 0xbfe4da08b4f0eed9,
    0xbfcc3bde5e393a30, 0x3fe0dce0235be74d,
    0xbfd1a48080c5bfec, 0xbff67a406bf67721,
    0xbffa56a84217a7d1, 0x3fe9b305ef35d62c,
    0xbfff25507a46afc8, 0xc005f2dbf8151058,
    0x3fbbd45c15a00e48, 0xbffb948d0f00b498,
    0xbfa98d8be451b040, 0xbff7c6ab6ce7f3e5,
    0xbfe9c80d3850628a, 0xc00120272f85af37,
    0x3feb44f74fa57046, 0x3fefda4c372a94c1,
    0xbfefda810fa56c44, 0xbfd15acd0f005756,
    0xbfd2986b5eb70ff9, 0xc00cb29156877ab1,
    0xc0008cbcc6e9b3e6, 0x3fe99cedf4756c0a,
    0x3fe71c5a73d511f2, 0x40058e75f4da0382,
    0x3fe5ce650bdd3c35, 0x3fe3b19afa7a8d74,
    0xbffd406209ff5dc1, 0x3ff18ede66174abe,
    0xc00392dad643b643, 0x3fe1582bc7a1dbf2,
    0xbff4bd85ed05079e, 0x40061acea82ef2fe,
    0xbfd0c96697904940, 0x3fd85e24381b6018,
    0xbff4981dde8c0066, 0xbfea2bade50f9e62,
    0x3ff5ddd46598808c, 0xbfe5c98d9b8a4d2d,
    0xbff53c3094ef0ee0, 0x3fd9eab9fbb4438c,
    0xbfefe32b15bdff52, 0x400103d0d4c4c632,
    0x3feb02dda79b5a7a, 0xbffa67ca670c3553,
    0xbfd0daa4593d7f58, 0xbfdd04dfa9ed2c21,
    0x3fc1a2acaa3c71f9, 0x40002842a7d1e544,
    0xbfece582c2093902, 0xc011236e0721a4b7,
    0x3ff39247125752f9, 0xc00526905ed6677a,
    0x3fd5e375d024b8f4, 0x40047bb805627b60,
    0x3ffd9000f9f1a1b8, 0xbfe7b007dd05acbd,
    0xbfe99c29a05a6aa4, 0x400088c791d3451c,
    0x400000e5874461ec, 0x4001572f2a70e98a,
    0x3fd3632b47502829, 0xbff207e60480255a,
    0xbff0a9279b6d8426, 0x3ff528d0dd0a51d4,
    0x3ff9a91383c8d8ca, 0xbff22c271887d24d,
    0xbfcd4c9ebecce7f4, 0xbfdaddf4110ea2d4,
    0xbff0a806f71098d2, 0xbfaed4088fa4cd90,
    0x3ff3cc49e3b0d4fa, 0x3fde16ebab7ad25e,
    0x400115a71bf25160, 0x3fec8fc2ee45c88c,
    0xbfe7844b12ffb018, 0xbffa27a4c35fc10a,
    0xbff37dcbe77714cd, 0xbfee2c979504a24c,
    0x3ff2c3c293a7d97d, 0x3fed85bd0a4ff1dc,
    0xbfa185235c38a000, 0xbff44becfb72a4a7,
    0x4005746dfab8050d, 0xbfe211b787b9e66c,
    0xbfd999821844ac10, 0x3fdd6342b176c4ae,
    0xbff55c9c34ba63de, 0xc009083fc8896a7c,
    0xc004725fb3901364, 0xbfe1050032b66040,
    0x3fee5642ca66b9cb, 0x40077d20a2187e7c,
    0xc004096e2759a8ea, 0x3fa91c35e7f98780,
    0x3fe2c31350894365, 0xbf9bc8418424f880,
    0xbff2d7a625aa5f0f, 0xbfd2b61db3a5585e,
    0x3fe76dad87f3d8c6, 0x4006ed1b8a54edcc,
    0x4005a7746c0bf4df, 0xc00060e81e8b8590,
    0xbfdceaae0b119e73, 0xbfe0c84ded28056a,
    0xbffdf5f9ef799d85, 0x3fcfd6b22f7de548,
    0x3fe257ea482744ab, 0xbff984fe4de35b5c,
    0xc0121c2f0c8e44ca, 0xc00c0cfba9fa6c3a,
    0xc00044140f6875f7, 0xc0013c94b56de841,
    0x3fe3147ca3bd3bee, 0x3fe4810a6df20de6,
    0xbff193e16ec38ca1, 0xc00a264c3886cde0,
    0x3fb70720cab518de, 0x3fb1d82287218750,
    0x3fd30362846eaa68, 0xbff64611553bdd0c,
    0x3ff0b3d2230c77cb, 0x3ffb2d58fc730b0d,
    0x3fc07fba2a01b3a0, 0xbff39d64bdb81504,
    0x0
    };

static const uint64_t ref_rfft_noisy_2048[2049] = {
    0x3fab0667ea63d9a0, 0xbff71f57e2184a33,
    0x3fd1a1e3e4be0fec, 0x3fb71ddb3c79e190,
    0xbfefaa3877d737d6, 0x3fe598fc4ba3c24a,
    0xbfe7e6857b0d9968, 0xbfe87cb9b7ca31c8,
    0xbfd73590c05d3320, 0x400427513e5ef838,
    0xc009fc5bc8cb6ed4, 0x3fe8f5336e6e1d5e,
    0x3feaab07751eec78, 0x3fd533df19f6efeb,
    0xc0020ad2d063117d, 0xbfe7f44595a35674,
    0x3fe629e38f190220, 0x3fef0969585a66c6,
    0x3ffad0eda14837a6, 0x3fdf7e92fc4015ba,
    0x400613c19ee02914, 0xc00f21c030f929f6,
    0x3ff390abe9290e7c, 0x400981bc36445062,
    0xbfeb9ae4edb826d8, 0x3fab136a46ab71a0,
    0xbfe3239f4201afaa, 0x3ff1de57ffa14496,
    0x3fa1c007ccc25fe0, 0xbff5b2f5e5069eea,
    0x3fd5b6855050a7fe, 0xbffbb51bff7732f6,
    0xbfab455502c69200, 0x400bfa74f904fbd1,
    0xbff8f935ff080dc2, 0xbff74a3124482db0,
    0xbfc734a6f14a3638, 0xc005ec1c346671fa,
    0x3fe70605098af7bf, 0x3ff4d87e13924b08,
    0xbfffb134ac8a1b48, 0xc002c348637c230e,
    0x4002546c566895c1, 0x4003a095ec899fe4,
    0xc004362302515ed4, 0xbfe2b343ca7af20a,
    0x3ff5cbec53ded73f, 0x3ff405d45594aa6e,
    0xc005fd2c3157892c, 0xbff5d7e8a1063172,
    0x3fe3f63a38e3ad48, 0xbfd25903e6ea1fb8,
    0x3ffccdb481f780d0, 0x3ff1c88fcb293800,
    0xbfd224bee7df1cef, 0xbfb5fe8bcfaba720,
    0x3fc19810c1fa7fe2, 0xbffb9e93deb2cac4,
    0x3fedec5758a295ed, 0x3ffe1853295d6557,
    0x3fad9b49a8e91250, 0x3fea247433657a74,
    0x3febd35ab23f65c7, 0xbfe9f691be2032e4,
    0x3fe839cec18adc16, 0xbff54e236f330b9c,
    0x3ff7c0a0b343941b, 0xc002ad9721dc769e,
    0xc002937a3e89e99f, 0xbff5a5bbb07b002d,
    0xbfdcd4951085cb60, 0x3fe79dd387dc3843,
    0x3fdaff8b21232b3e, 0x3feafe69312f076a,
    0x3fc0e4cf0f1a4db0, 0x4003f260cdc08a02,
    0x3ffb332a33646f9f, 0x3fd43efda14d9a2c,
    0x3f80a43ac76c8ef0, 0x3fda7d94e91edcd0,
    0x400309d0ae39c9a3, 0xbfe668249462f128,
    0xc0011af4c7efde72, 0x3fec7cbf1c22dc3a,
    0x3fd2a2c8fabc315b, 0xbff6bcb1cbf737f8,
    0x3ff3007f4c6392c6, 0xbfe8ee44567e463a,
    0xbfe4abec04b9acd3, 0x3feb21fd0c5ecfab,
    0xbfa74d051fa42110, 0xbffab532c9e3e56b,
    0x3ff07aac3a8ec39a, 0x400bdc0fa9e02c7b,
    0xbfeb44e313591f1d, 0x3fd7ba5ef648b16c,
    0xbffef7746bf1646e, 0x3fe70587f0a08a48,
    0x3fee62e257314cee, 0x3fa9a029bbf369f0,
    0x3fcfb7c54e2ef75b, 0x3ff9d076e7aedaa6,
    0xbfde97b6a990c069, 0x3fb301d1d1321a10,
    0x3fe78a4592911e14, 0xbfd04a7f93baac14,
    0x3fb221246b2dc414, 0xbfe6637991ff0eb4,
    0xbfaa056c68491040, 0x3ff7997c377567d2,
    0xbffd1336570d1f71, 0xbff117457a47b934,
    0xbffcf628e1987197, 0x3ff87d89bdffbbca,
    0x3ff63b1fb9ccf31d, 0x3ff3459bf4ab309b,
    0xbff355e0c2ca12fa, 0xbfee95b0e50bc52d,
    0x3ffe1c205496763e, 0xbff16241400ce10c,
    0x3ff13430695c3773, 0xbff3532b30c70ee6,
    0x400602740152b75e, 0xbfda44d68ac65d84,
    0xbfeb5506558e6ed4, 0x3ffa2095cf4bb622,
    0xbff64e5dc707944a, 0xbfdc0fa57dc258f6,
    0xbfe6dc4a5ab95df0, 0xbffca0d8a9b193fd,
    0x3fed079149ef8a32, 0xbfd1eb64a0b58427,
    0x3fef72b9e48c852c, 0x3ff6fb233462ca28,
    0x3ffcf52564179637, 0xbfee9dfb69294187,
    0xbfebf46a28ba0fe3, 0x3ffa793ff22a8c36,
    0x3ffc2daea60678a4, 0x3f9d1daf4fac38c0,
    0x3fa6868705e5a5c8, 0x400647ee3b8e0764,
    0x3fc21738b5b8a714, 0xbffd4320edc71cb6,
    0x400210c83f1f62e1, 0x3f93753362cf11c0,
    0xbfdb1979d829d554, 0x3fe5a640e34360e2,
    0x3fdb8c2f79db80c2, 0x3ffcb23b538a05fb,
    0x3ff0053a3eeb0d92, 0x3fff7feaf5e0d185,
    0xbfeca4cf15ba45fe, 0xbfad18d529a02c90,
    0xbfeea7a01f647977, 0xc0026710d01462a0,
    0x3fe1ea3621bb7d48, 0x3feb141ba4b93561,
    0xbfeb4823cf3179b5, 0x3ff0e7ad8ab45e42,
    0x3ff0afcc77d0d398, 0xbfd91663d9997809,
    0xbfcafe088bbea8fd, 0x3fa896c3b66364b8,
    0xbff25cb3d1c7872d, 0xbff470b0c1f2a236,
    0xc011cdae691ee317, 0xbffebd7e503bf006,
    0xbfe0241ba149f48c, 0x3ff3bf68270034a2,
    0xbff3a974ee2f6a4c, 0xbfccd4ff2f86d7e4,
    0xbfbfe6416ead3380, 0x3ff5a513bab042d2,
    0xbfb28cc0d36a2a10, 0x3fc10e55202a5fb8,
    0xbfe76630bd1d4a26, 0x3ff88c29d4e63e54,
    0x40045c2c0cd00bb7, 0xbfe16fdf624a3016,
    0x400a087f923deb1c, 0xc0058e70c237bd95,
    0xc00505f301ee5aef, 0x3fe8e45dfd6a988b,
    0xbfb6f292b765594c, 0xbfe3ba3ad00a68aa,
    0xbffb9ff4e88027b6, 0x3fd4ca1c0fbaa962,
    0xbfce9f6b2c0437fe, 0xbff62e39e342ce40,
    0xbfdc98032bf4de9c, 0x3fd20d3fafe10417,
    0xc00aca0d80570f3e, 0xc008bb7050a541a0,
    0x3fda0e27b9ee5686, 0x3fe9bab37b7feb63,
    0x3fe728042b64fb94, 0xbff5fefab832dd44,
    0x3fc3bff64bdb6318, 0x3ffa510fc8a12924,
    0x3fd40368d4dfd97c, 0xbfc3795cdfec1ae4,
    0xbffe7108edcab12a, 0xbfca912df09b4808,
    0xc0057cb01d728d00, 0xbfe44c364cfab8e2,
    0xc0000a534a18018f, 0x3ff033ddd6289515,
    0xbfd4851bdf2ec2d2, 0xbff88fd56c029602,
    0x3fe71c12a56822cc, 0x3ff45a6169c45d60,
    0xbff63bc625d56448, 0x3ff0c5319c16f3be,
    0xc00e4b194e5008fa, 0xc004e247b6473134,
    0xbff01c598c7faae1, 0xbff29fbc40c7521a,
    0xbfde4a10adb0bb72, 0x3fef2065f7efd61b,
    0x3ffdf25ed88f7ea7, 0x3ffb165402eb70ec,
    0xc003461de256e346, 0xbfcdf031078e1d74,
    0xc004f15568c73a2a, 0x3fee51fb363c7b00,
    0x3fc89f0bf231f1b8, 0xbff289403170e952,
    0x3fec613988b5e02a, 0xbffaff23c0d6c285,
    0xbfe9a102c9001bf7, 0xc00401d7c6f2ab36,
    0xbff3f5cd6c33a781, 0x3ff4f1bc7b399360,
    0xbfc70dc336a7546b, 0xbfe8721a9745bf22,
    0xbfe5567d02d1279f, 0xc00b94dbdb6a8301,
    0x3fd1ce394bf58450, 0xbfeb28f40930ac7c,
    0xc001c081644b467a, 0xbff0bded14d0ba12,
    0xc00245070f87526b, 0x3ffee30fbb8d45ac,
    0x4009e867dc593320, 0x3fc27892d70137a8,
    0xc0001d38534a32b4, 0x3ff1a53669dd47c0,
    0xc004495aa3e38364, 0x3fcd812a15d35c70,
    0xbfeb1d3b2ace8832, 0x3ffcacf0c2045b40,
    0x3ff61cf1a60228d9, 0x400e8ac97c1b9d86,
    0x3ff0b8494dda2540, 0x3fd87d6d817b9dbe,
    0xc00a51198dae5a79, 0xbfb83e8b5034520c,
    0xbff2f93bd90782f9, 0xbff516b50b48c390,
    0x3fe936b9d8ca33f8, 0xc0012a6e064adcd0,
    0xc004afc05faec745, 0x3fce26efaae86400,
    0x3ff9380bfcd71964, 0x3ff6c30f1b84090c,
    0x3feb4003f67edd86, 0xbff0087085aa1174,
    0x3ffb0ab2f9197d36, 0x3f94c17af06bfb70,
    0xbfcd6ea23968719e, 0xbfe6cd5bf5d91f2d,
    0x3ff386e8eef53ad6, 0xbfb3d4c543f70968,
    0x40037bab81fce327, 0xbfa442ac08005a28,
    0xbffb2a246eb03460, 0x3fefa5f417ffb6e0,
    0x3fe07266263c056e, 0xbffdb5469e21d0e8,
    0xc00133f971cc443b, 0xbfe29278029f87e2,
    0xbff9467b12e9f772, 0x3ff6beb4c5ffda16,
    0x3ff23db602edeeae, 0xbfc7de24430462a0,
    0xbfccdddb7f111320, 0x3fd2cb426f1f9bce,
    0x3fb4a9e1723fe9f8, 0x3fe0759ccec36070,
    0xbfe703c159c8aebd, 0x3ff0a20624d18af6,
    0x3febcd43d77e37e4, 0x3fe5955f49312256,
    0xbff03b4805860b01, 0x3f79555f8c563b80,
    0x3fc0db329ebf6522, 0xbff4e7a17653b251,
    0x4004ba150c515f91, 0xbff47acf9766b558,
    0xbfcc840e835fc96a, 0xbfd656a844f6f164,
    0x3fd936823feb8309, 0x3fea5a9ead5640db,
    0xbfe3563d8819c57b, 0x400400d28df6aca2,
    0x3fbffdf985bd79cc, 0xbfd8a2457883a56f,
    0x3ff6ad40188280c7, 0x3ff0ce28ff1004ed,
    0xbfe1591f88eee6c9, 0xbfe1f5368db5abb3,
    0x3fce0d28a2313664, 0x3ff90944a5d50e68,
    0x3fd7c4c60583e4bc, 0x3ff3864fffc7f02e,
    0x4003393e1147695e, 0xbfdf4b3a175ef3b2,
    0xbf8f60445994b160, 0x3ff800dc2c1c0fb2,
    0x3fc485345f071e02, 0xbff3240067240cf4,
    0xbffd1f4a6753c878, 0x3faa942f396eeb70,
    0x40104d4ad8774026, 0xbffe1fef24e81990,
    0x3fcd79d5fbf2f1c8, 0x3fe2b118c3bf625c,
    0x3fe15ddc0f1cdd01, 0xbfd4352fa1b340c0,
    0xbffb7c6cebbf861c, 0x4000e97288291f18,
    0xc0047e419f0a2423, 0x3fe997d2a93d26f6,
    0x3ff463fa5e323ab9, 0x3fe9a01f0aa8cff0,
    0xbfe7c056b67471fe, 0xbfffecefe14bb75a,
    0xc00129cc4111906c, 0x3fde4b35c84ac0d0,
    0xbfd2b973346c1108, 0x3ffe9213f73f861c,
    0x3ff3f4416d184470, 0xbfe00d53e22e3aa0,
    0xbf846d3194905ac0, 0x3fe2f390fa98c8d2,
    0xc006ad1d01e7223c, 0xbffa4be46d0af6ec,
    0xbfb95d96496c5fbc, 0xbff10e053ff64239,
    0x3fed9e0c3c4c8a9b, 0xbffcbba670d7ebd0,
    0xbffdbdecabf7a533, 0x3fcb2a4e69036df2,
    0x3ffd9aa4ffafc0e7, 0xbffd8121246479a0,
    0xbffbe4b82c536f89, 0x3fddf37dfd98c8bd,
    0xbfe48fdca90cbd0c, 0xbffc1b7d58a5c563,
    0x3fe3bea5bcff86f6, 0x4010a472dbb92297,
    0x40042f8a4da3bb0a, 0xbff68bda0aaa9d23,
    0xbff243d4da38e2d8, 0x3fd01c8d5f8f88c1,
    0xbff1e14dfe9fbcb2, 0x3fef513443c10e73,
    0x3fe838735c6fbe36, 0xbffcf1486c6aed43,
    0x40074f7b75c7bfb7, 0xbfe5028a7931477c,
    0xbfecc890111a813f, 0xc000cb914ebc5068,
    0xbff8e109c24d23ae, 0x3fe20c70bb2c27d0,
    0x3ff97b2dab0417d0, 0x3ff15b7e6dfd18a8,
    0x3ff19dd78fe14ba4, 0xc000e77ebdaaba68,
    0x4000acc75125dfb5, 0xc00a0946ea11a4db,
    0xbfa91e50dd521318, 0xbfc2d673d0f9a724,
    0xc00f7db9db26c24e, 0x3ff1443b2bb146b7,
    0x3ffbb22d036d6490, 0x3f8223465f676140,
    0x3fedf6bdd4010cd8, 0x3fce38697fc2a45c,
    0xbff253f5b1e7c8ac, 0xbfec09d8f5c6529f,
    0x3feed18c4ab3c39e, 0xbfc0858e06bd0332,
    0x3fd94da0d40764a2, 0x400ee894d3ab53bc,
    0x3ff597e88d97213e, 0xbfe1ae9c8ca19e44,
    0xbfe1df3a8bfc540a, 0xbfc0422b7dc147da,
    0xbfce8984d023c3b0, 0x3fe533c599f5af21,
    0x3fc3f9e3fa1b9bf8, 0x3ff432fcb5dff03c,
    0xc0051ccd5fc9db47, 0x4002501eb3016954,
    0x3ffd9941789ae999, 0xbfefd79f29facfb4,
    0x40084c40c8f6b451, 0x3ffb3b78bc6646f3,
    0xbfe360a4c340e778, 0x3ff38f053d64bcae,
    0x3ffb2ac066c23edb, 0xc001a973d60d1e6e,
    0xc002ca5c8f72c5e0, 0x3ffe63642ba866c8,
    0xbfe18e081cf810bb, 0x3ff80f2861b8bd38,
    0x3fe8b4c1c3894f4c, 0x3feaeccee41e8baa,
    0x3ffd3fada454a136, 0x3fc5187ab3a72190,
    0x3fec3d011facd0cc, 0x3fe27fceeb62cf84,
    0x3fb7206362ba0798, 0x3fe118b4bbf5516f,
    0x3ff0ea46f1da6f16, 0xbff47b2bf9ae6c50,
    0xbfdf4f493e22ef2f, 0x3ff3f69a47e2fb47,
    0x3ff9dc27e4266b54, 0x3fcb4b199b117140,
    0x3fd89081d55f6301, 0xbff2dd62a22a4eb8,
    0x3f8577f11abaa740, 0x3fee591e9dc10481,
    0x3fdca5759f4fa373, 0xbfe2f23e0b7ccdfc,
    0x3ffeed27851cd340, 0x3fe0fa9a8152846a,
    0xbffde1a26a1add7d, 0x3fe47bac3a5d286a,
    0x3ffe8948605b3368, 0x3feac4a0d0d7c596,
    0x4003b6aa097c96e2, 0xc010b6d5e65c2878,
    0x3ff17906b5cba5bc, 0x3ff93186f852e752,
    0x3fe986a9138bfa17, 0x3ffd0a0e5bf0ed01,
    0x3ffc2b2c7b92db86, 0xc00151a578c0e829,
    0xbfe838e529e37344, 0x3fe6164120def89e,
    0x40007f6831d81ab6, 0xc00271f35facb3c8,
    0x3fb4f258920201d4, 0xbff8dfd9646f55de,
    0x4006f3d8b3627e46, 0xbfed97e13053dcfd,
    0x3f88f01af0989a80, 0x3fca85ca9c32897a,
    0x3fe97c0e8661ce68, 0x3fdde3d7aa92ef4c,
    0xbffc600ec6844a21, 0x3fe2a5f99021ca2f,
    0xbfd2c870de880dd5, 0xbff7826a23cb0d38,
    0x3fc865ede0e9c1e2, 0x4000fde17c24d0d7,
    0xbfcb915790f1b630, 0xbfb0ed2df566d35c,
    0xbfe073582b16b680, 0xbff959844fb176ae,
    0xbfe0cbabeb6c4470, 0x3ff7b1f615afa2d0,
    0xbff66b95f9cbf558, 0xc00c996483216158,
    0xbfe35fe1ff2ce456, 0xbff7769b8269da88,
    0xbff12f2589adeb20, 0xbfaf5c1e22e8e780,
    0xc003ad51007a736c, 0xbfdc53f1afc2dcdc,
    0xbfd62c756c442c2c, 0xc0027146c6295a3c,
    0xc005dbfe4783c5b2, 0xbff6b9961274a786,
    0xbfd9ab2aa494c7b7, 0xbfd7985ae4bc9003,
    0x3fd96b5618c90ecc, 0xc003942694973510,
    0xbff7e71e6c24f0b5, 0x3f9d25db2bc8afe0,
    0xbffe8a6e7b1d151c, 0xbfbc61c5167118c0,
    0xbfe1e74d7733358f, 0x40087b3a19c0165b,
    0x4005619dad723b59, 0x3ff30a04d646eb10,
    0x3fe620f7d0fc13fc, 0x400b23b69a42408e,
    0xbfa661978edd76c0, 0x3fec7790abf20782,
    0xbfdd98bac67b6b7a, 0xbff645930f0bbeb5,
    0x3fdaf7aee5862a53, 0x40012e68151a5f60,
    0x4001dffe1c59d124, 0xbff2305251c9ecbc,
    0x3ffe0b5daab47d6d, 0xbfe6d36a603fd804,
    0xbfffce465c8de6be, 0xc086621cae230b0c,
    0xc0037795f9b41d27, 0x3fd0d046a8a8d7de,
    0x3ff28d411e6d45c2, 0xbfe11d2ed6a5cc30,
    0x3febdb18039a3cee, 0x4006be1c9e04e8e8,
    0xc0042bf02d4d3904, 0xbfe0c9e2258e3696,
    0xc00857776ae9ea0c, 0xbfe04d7f1ac64b7e,
    0xbff59269fe687cb8, 0x3ff42a588150bf91,
    0xbff4d81b3e3859b3, 0xbfc5d91ed4e1dbcc,
    0xbf8e85b15555e100, 0x3ffe472f06ae94d0,
    0x3ff5a9c01a3c7aab, 0xc00db1d7ba1a5795,
    0x40069ab52a27ec16, 0x3ff21c8cc14acabd,
    0x3ffbca576de963de, 0x3fdb5620013aa17e,
    0x3fe7b5472a6b229c, 0x3fcb872aee0d88b4,
    0x3ffb047d29fcddb6, 0x3fd534d11505cdb6,
    0xbfdff2fdc04d0402, 0xbfdf6e3fa65813a4,
    0xbfeacb3fcf8aa104, 0xbff2a5275c3d18c6,
    0xc0082bfc51d24795, 0x40076144e7e59ab4,
    0xc003e2ac85392f15, 0x3ff6acd585349948,
    0xc00a7f4f09771834, 0xc0004a90943d9a88,
    0x3fe467e1fd288629, 0xbf9f7f3628d6a540,
    0x3fec04a2059f41c4, 0x3fe357b3912b2540,
    0x3fe990c8497caaa8, 0x3fd03bff2242f14c,
    0x3ff7b75e6c044dd4, 0x3ff1fe1147ca6289,
    0x3fef0d14e994e6f0, 0x4003e2439e701508,
    0xbfe17adbf18a2262, 0xbfe761ad9f75fda0,
    0xc004942284f6deda, 0xbfb3006ffd27c7d0,
    0x3fde4300811466eb, 0xbff9a33f62b7faaa,
    0x400337acb3aec66c, 0x3ffffc9680700146,
    0x3ffd389dac704686, 0xc011793afe53305a,
    0x4013b6fc15c4479e, 0x3fee286cbf9c2246,
    0xbff1ee541f8767af, 0x3ffb3011ee3b2cb9,
    0x3fb3345fef43d024, 0xbfeb61388bcd3ed4,
    0x400bf10a2ba0ad0d, 0xc00d17481c7e8b00,
    0x40031a84b5f992c3, 0x3ff3a3e46a63233a,
    0xbff97c936aefde8e, 0xbfb718020fde5910,
    0xbfd33a2f95721c18, 0x3ff943a78b7a8116,
    0xbffa6ab45a1bac2c, 0xc0045183301f2de0,
    0x4010c9e7b229f01a, 0xbff472569ba8865c,
    0x3fc1ebe080c0c7ec, 0x3feeac53e5d67516,
    0x3fc6582c70baabb8, 0x4003641c4040b8f0,
    0x3fe921aa030acdbe, 0xc006f3c5080f6730,
    0xc009e206bfb8aa78, 0x4003dd7aca3a9932,
    0x3ff07fa3e0039d17, 0xbfe061e84bd179c0,
    0x400557fc3183a12e, 0x3fe62c46c611ff38,
    0x3ff8cd0d5d165d7a, 0x3ffd463edfd0901f,
    0xbfe9351abd5427e1, 0x3fd3b58e16287261,
    0xc00e125934a59888, 0x3ff52ce03c3dcdb7,
    0xbfe4704bcf0c5a38, 0xbfb8d54081c9443c,
    0x3fd9b7e3e25d8ec6, 0xbfb9a45ce4dbbdf4,
    0xbffa9ff8701e2d98, 0xbfee78d0e6c3d8f7,
    0xbfa14288a51a5570, 0xc0004ff0b604e357,
    0xbff8dca0151e4577, 0xbff3520648731ada,
    0xbff362f8fc302a68, 0x3ff2eb74e95ccbb2,
    0xbfe36ce9d3468b0c, 0xbfe34144fbdeb82c,
    0xbff5b3e98cb29aac, 0xbfe957fced062f36,
    0x4006b02ee2babb22, 0x3ff5da182ec26ce5,
    0xbfe1e4b1e5e12632, 0xbfb02cc96a702e08,
    0x3fed4fa5211c9ca0, 0x3fb38473a0d81ba0,
    0xbfee7df494405d10, 0x40021df316b881d4,
    0xbf99d2d7f2d009e0, 0x3fcbb5bb080de0fc,
    0x3fe93f7e8d7f57a1, 0x3fffd5cb45bc95dc,
    0xbff5ca4a71bf60fe, 0xbfd60f646633a35a,
    0x3fd3b0ab7cf27400, 0x3fc03854840b2020,
    0x3ffc60d1b968ae28, 0xbff189bed5f8f87e,
    0x400102cbb5454045, 0x3ffec057e6945f44,
    0xbfd05c8569ff6672, 0xbffa89d7b0a2b4ef,
    0x4005f0a610869850, 0xbff5b0a44c842290,
    0xbffac4b8faf3700b, 0xbff3fcd2b4920238,
    0xc009b8ab885cacfe, 0x3fcfbd5c96986f1a,
    0x3ff2aea1c007e933, 0xbfeeedcb36e9839f,
    0x4005be48b8122143, 0xbfebcd4b733025d2,
    0xbff7a796b0b511cd, 0xbfe123473b423d0d,
    0x3ff622bf9db44524, 0xbfd0c646647d5f43,
    0xbfc7e0ae4f92a4f0, 0xbffd75654ec75842,
    0x3ff17c1061215fdb, 0xbfe367be0de2a418,
    0x3fab4cbd947e8140, 0xc00f7a6aacec0302,
    0xbfec334e62ce243c, 0xc00975d84cdab7d2,
    0xbffa2e3e0df79729, 0xbfe5acf0debf8d30,
    0x3fe4b4e244c8f603, 0xbff08474e21864c4,
    0xbff4e162fc24f756, 0x3fca125d759c7593,
    0x3f9ddb88acfc3810, 0xbffe1b384eb72ef4,
    0x400730c9a6a381b1, 0xbff6543d09063293,
    0x3fe0cc5cb18a029f, 0xbfec4fca35449486,
    0x3fe118cf8d4490ae, 0xc001c6425cb669c2,
    0x3ffbf10c3073f432, 0x400a28e6259f5b3c,
    0x40031508fe4987d3, 0xbfd0983845e149f0,
    0x4006a043663d210d, 0xbffa1bcef2bd4256,
    0xbff522281326ed85, 0x3fe8713ee900103d,
    0x3fb65bd145d26c1c, 0xc000454d08f767f0,
    0xbff3e8cd1fbf7a82, 0xbff1d8e64eedfb12,
    0x3ffbd9c9b65596fe, 0xbfed16614af1c788,
    0xbfe851a3b5f9ad75, 0xc01326d27b15cd6e,
    0xbff12402b824169e, 0xbf4c811460150800,
    0xbffda69e66fa0fd8, 0x3ff3e0de98e4cad2,
    0x3fdd97fa4d78dbf8, 0x3fa9ffe4595390b0,
    0x3fe7f18e9a3dfa60, 0x3fdfed6f46b8e674,
    0xbfe9af21fcdbfbf3, 0xbff010a0b86c221e,
    0x3fffb9a7810fef42, 0xbfeb8710d042c2ba,
    0xc00de447908fb19e, 0x3f8424635955f760,
    0xbff0f20cfa89a35f, 0x3fe800bf37564d21,
    0xc0027db2a9fdb81a, 0x3feab5dd036143cd,
    0x400b73762cccf973, 0xbffcfc9489605866,
    0x3fc8843c1714e2a8, 0xbfe9496ab4198ac4,
    0xbff1691c8063a8ec, 0xbff57c612011c12e,
    0x3fce0f76b39d871f, 0xbfd15e797ece57c0,
    0xbfff71b28db77263, 0x3ffcea0eee2f689c,
    0x400131cc1804a6b3, 0x3fdb602382619cb1,
    0xbff5511fb65726fc, 0x3ff9322d0ad673ea,
    0xbffd17f3606fa633, 0x4000e30556c47161,
    0x3ff7921b99c8e2d7, 0xc0011bd586e5dc8f,
    0x3fb07d3ee57fe410, 0x3f8bde2c253b8540,
    0xbfb480aade3a5a94, 0x3fe5b51baeed96fd,
    0xbff822a69c7130e5, 0xbff3d4bd0540d797,
    0xbff93067daae886c, 0x3ffe4137567f9e7a,
    0xbff9e7bcd722239a, 0x400b78303725e7fe,
    0xc0066b81d0a7ebd6, 0x3fed1e60b4f7bfb3,
    0x3fc26aa661e18b08, 0x3fecd60bfa274cd8,
    0xbfdf9a12815ae89c, 0xbfb854924840e534,
    0xbff4805a4fade0ce, 0xc008f9873458b172,
    0x3ff1f78ef78132ca, 0x40025ea046d424d8,
    0x3ff5ee906e8f0698, 0xbfe6b44f7a01623f,
    0x3fff77ce3352b431, 0x3ff78ee54a56f4be,
    0xbff7f61761337520, 0x3fed6271caee426d,
    0x3fe19cdea924f258, 0x3ffa8b0e2570519c,
    0x3ff6ec2705709d9a, 0xbffa4e7adfa2049b,
    0x3ff01025bb5eade7, 0xbfe468ed593b05f6,
    0xbff9e698fcaef56c, 0xbff8d83891065d3d,
    0x3fd2cdc43eef2078, 0x3ff6c84bcd9e2b19,
    0xbffca29f3b7b51ac, 0x3fcff5eadb03d700,
    0xbfe382429b5fffb4, 0x3fe57f52204e0d7e,
    0xbfcaec617e957002, 0xc00b7f5e7dbb66ad,
    0xbfd519c76ac6d1be, 0xbff0ae1ac76595a8,
    0x3fdc8a9cb6edcf44, 0xbff006e6a4af7870,
    0xc009e482052bfff4, 0x4000b061f4f95de4,
    0x4001af84e3344ab6, 0x400a96b0363e700c,
    0x3ff09f36e51128e8, 0xbff6ac338a4c7c90,
    0x400fb5b25aae477a, 0xbfd77a3a0ce26b18,
    0x3ff6f4b55e89115e, 0xbff4d0c0cebf047c,
    0xbfa0ca21ed51a8e8, 0x3ff530afa24f6d95,
    0x3ff82e7898247d9c, 0x3fd28da9db480ff2,
    0x3fe7d786c108eddc, 0x40020b6b45f759a2,
    0x3ff955e30928f4f0, 0xbfeb36265fc57d43,
    0xbff6b4063fb21848, 0x3fd2f4a32764c7c2,
    0x3fca541da11c9408, 0xbfe1f3ee3e6591e2,
    0xbff20fdcb69aa5a0, 0xc011234ec3a7af1f,
    0xbff7ca2157a8a7c5, 0x3fe38daf6dbb0f81,
    0xbfe07a3952a9a779, 0x3fff05502ec0d671,
    0x3ff69fa2017f02d6, 0xbfc210fcf7c89ee8,
    0x4002d2746595384d, 0xbfc843250895cd84,
    0x3fd19b367546ff1c, 0x3ff4029fe777122d,
    0x3fe3b7b37b493d74, 0x3fbfe34e0d241544,
    0x3fff33e955cedcf2, 0x3fd046b5a2570708,
    0xbf855bc3d02a7c80, 0x3fc731f773b6ba28,
    0x3f90b8ab37909080, 0x3ffa4b622a818ecc,
    0x3ffa07b8e7ddb6ec, 0xc005d7e06f60ffdf,
    0x3fe56462d3ef1913, 0xc0144cf2d5f65335,
    0x3ff1d858b38b2116, 0x3fe80c3f7ad48a14,
    0x3ff4d5c3b594ca22, 0xc00089cf559bd651,
    0x3fe400b0a22ac754, 0xbffbc59446ce08a4,
    0xc006cf3510a23aea, 0xbff764c1912d4c93,
    0xbffc177dbef329ca, 0x3fe9016d48be7c12,
    0x3fe557e0686cae10, 0x3ff284fb1500b4ee,
    0xbfd727d9e7c6f3d6, 0xbfeb95c4c3cf5ff2,
    0x400904b59774bbb5, 0x3fca70d30e0861b0,
    0xbffd9ac24aed808e, 0x3ffeec5a83d44f82,
    0xbfe2b0fb1346d271, 0x3fc911181bdede70,
    0xbfc90d29b0ea0678, 0x3ffcea1f5083a02c,
    0x40039cb2e688ed9a, 0xbfbe8ed06935d0e0,
    0x3fdd3d0aeb4a27da, 0x3fb30cb0d4009208,
    0x3ff5e084c83be076, 0x3fd288fb3b21b41a,
    0xbff0cf7662b74d66, 0x40040d44fadf01ae,
    0x3fb0db2a567dadd0, 0xc00572417b907b3e,
    0xbff391cb65e3a31a, 0x3ffc66ee080d8086,
    0xbff64d3daf149b10, 0xbfe467a91ef2d0be,
    0xbff4e60445c2a798, 0xbffa3cb99c16330d,
    0xbfd7e12c6c38e657, 0x3facbf5d2b102360,
    0x4000f0493b02e0bd, 0x3fb917930bbb0210,
    0xbfddd6a23f85554c, 0xc0056925c09f768f,
    0xc0020401cc7d1d79, 0x3fe719a98875051a,
    0xbfeeeb95e0bb177c, 0x3ff2f5068e19c6e8,
    0xbfe421375c045627, 0xbfe5e38b30866f66,
    0x3ff9473127ef152c, 0x3fe1972501c88691,
    0xbfd3b52f1a3c7288, 0x3ffb360c421d3c56,
    0x3ff56d653e3810d8, 0x3ff9deaf1d2f989f,
    0xc00148c0bc82b3e0, 0xbfdba6357c5c22f0,
    0xbff8b72f27a36a3d, 0x3fd6f2ae4f251324,
    0x400cc07edb6db229, 0x3fc3604ccf8c2002,
    0xbfe1fba4bc78e3c3, 0x3ff69b96e7ebce7a,
    0xbffc2aef6341228b, 0x3fae912ae2dcefa8,
    0x3fe356a95f5f643c, 0x3ff1d89c086ab041,
    0x3ff39caabe11f421, 0x3fee07dff0af6032,
    0xbff874f5311e1897, 0xc00817b5a2642c42,
    0xbff93534632d3305, 0xbfd857b12ed21ed8,
    0x3ff681fe383054a2, 0xbffbc1fd7809dffe,
    0x4016e05b76882a48, 0xbfe5916719f59e6c,
    0x3fcbfcc9f52ad518, 0x3fd5bb29cdcce130,
    0x3fe26e7e8073a2fb, 0xbff36c3fc06bd44e,
    0xbfefb134826ad564, 0x3fe41c44930f8f72,
    0xbffc6e05ab11c8d0, 0x4003a543dfad928d,
    0x3ffc005b53314878, 0xbfd4409994e8bc76,
    0x3fd590c9b08e28c6, 0x3ff6ddedc49df1a0,
    0x3ff1c66c8e30ea4b, 0x3ff1f158ef2f170d,
    0x3fa74779cb080270, 0x3fe0f5610babef86,
    0x400ee355707a6d81, 0x3fff0f93fd3db7af,
    0x3fec699ac69bd6e8, 0x3fff23298da49595,
    0x3fc458dfbdde99d8, 0x3fec5ec65307fbde,
    0x400f43ec91accde6, 0xbfaa37a1b7800ee0,
    0xc00685d9f76af322, 0xbff417bf1b9631f4,
    0x400a638c1b461dde, 0x3fe49dbd345a4510,
    0x40009b18a9b32fcd, 0xbffd8e6dc32c98c8,
    0xc002f9b80e3aec10, 0xc01323c83e589ed6,
    0xbfee4aba1764a514, 0xc003dae423e715f7,
    0xbff5a64e2ac6e608, 0xc00f51f01a7746c4,
    0x3fe06dbb7d27a35c, 0x3fc52193502955ea,
    0xbfed77c2bcfad2e4, 0xbfdbe050f9e0ca63,
    0x3fead0d65a4f5d3f, 0x3fff0bc0e62195b6,
    0xbfd4439ffccc0278, 0xbfde1256237f7318,
    0x3ff213c3924a0695, 0x3ff2ab72846d0a93,
    0xbfdaa09e917d7df8, 0x3ff21081caed5b65,
    0x4000ce41a764a659, 0xc001b0e43319a676,
    0x3ff90654293300c1, 0x3fe0983acc0e1242,
    0x3ff4b4079583ed52, 0x3fe720e332f43d83,
    0xbff04b77c353ac99, 0x3ff0f03f087a417b,
    0xc00b4b5053fa9862, 0xc0010d5015b78da5,
    0xbfff1b70a78689c8, 0x3fbfdc1ce9a2fe6c,
    0xbff13b166a74c7f2, 0x3fd31c0248164e71,
    0xbfe50f212952adae, 0x3fe4ef9940529cbd,
    0x3fe644081f9c2ce6, 0x40028cd881d3e409,
    0xbfa19ad11524bfe0, 0x4002818c0348182a,
    0xc001669348aba293, 0xbfd70b98c1ae365a,
    0x3fc0ca38807cbce8, 0xbff49b36013977d1,
    0xbff60a9cae40c6fa, 0xc0086629975a90fa,
    0x3ff9f752933f1c31, 0x3fed2e72287ebe04,
    0x3f9da21ce57b29b0, 0x3febb877969b1722,
    0x3fdfbb214057f7fe, 0xbff8287094b1e3ee,
    0xbfee6f5b20c6eff0, 0x3ffb99be46fd9ba2,
    0xbfe22205ae10697c, 0xbff3fa13daa6f53a,
    0x3ff06c89c6cb11b0, 0x3fe4c2c2ab0f2c80,
    0x3ff395178eeba088, 0x3f95c71b41483b80,
    0x400716dbbaea0d77, 0xc006bfabb229b9d8,
    0xbfd62796039ad354, 0x3fefc04c2f9d5f41,
    0x3f9295fd551cd600, 0x3ff7158f66ba897d,
    0xc00015eedff1a4d8, 0x3fba7dbc7ef84afc,
    0xbff5c19814d499e3, 0xbfd74f1f355cd9b3,
    0x3fd7ded66915af15, 0xbfe4398da7f88d7b,
    0x3fde63d07f2f0bcc, 0xbfe4c2a61b35d874,
    0x400a739255b5447e, 0xc00b4a92e58f94e9,
    0x40074955c5a2d908, 0x3fe42b5989c7620e,
    0xbfed6e4671a2f144, 0xbfb86dc107ca3168,
    0xbff32726ae7007ec, 0x400592b352746e93,
    0x3fe917488e83f0ac, 0x401848e0eb1e0ab4,
    0xc007cb369a7c89f2, 0x3fe7a4d6d61547af,
    0x40080cc39df58e2d, 0xbff4a3bcd736beac,
    0xbff7e07f1104e8ee, 0xbfd9cb34686e7031,
    0xbff1c8cdc462ce0c, 0x3fff676e307bb5bb,
    0x3ff47ceecb9eb1ca, 0x3ff0f736a9122aba,
    0x3ffbba867d318c4d, 0xbfe141c581257d00,
    0x3fcdc579074c086c, 0xbff05e3663f8816a,
    0x3ff71413ee3d0a90, 0x3ffdee24ff153f21,
    0xbff65c6dfedf8b14, 0xbfe06be8b14b8dc6,
    0xc000643aa263ba39, 0xbfe8887aac7e1fe5,
    0x40012fcb1ef5a93e, 0xc000d0b78e1c3dd1,
    0xbff06873b80dfa0f, 0x3fcad7c6feba0820,
    0x3ffebfb092aa7e2e, 0xc001975516f75c67,
    0x3fd8e48a97602fd8, 0x3ff58250826eed98,
    0x3fedd030831fa9e8, 0xbff20dd6469ba44f,
    0x3fe8841c1eab89e8, 0x3fe9b73042827f84,
    0xc004e3c5032f3bf0, 0x3ffbdf8a8a20196a,
    0xbff51f021e03530b, 0x400074c06860c9bb,
    0xbff413ba8a13d4b3, 0x3ff3d3e10b00d0f9,
    0x3ff457afede5f6cb, 0x3fe90b4249ec7662,
    0x3fc621261484ae30, 0x3fe2ebf525a3f9fa,
    0xbff78799387eb0df, 0x3fdbc5a3e9239cfa,
    0x3ff2dba833cb998a, 0xbf7b6472bffc6f00,
    0xc0080a32baa5fe40, 0x40081f99a5a15969,
    0xc002d1f5cb12bf24, 0xc00e53ab6ee66d28,
    0xc0029ea33295ee29, 0xbfff209b3eba836a,
    0xbff0f959c3f430bc, 0xc00778a656117bcd,
    0xbfee6401ffed48af, 0x3fd6f88204902db8,
    0x3fad97eac98c2a08, 0x40075d585eb4cbea,
    0xc002745059924520, 0xbff74d295ec34046,
    0xc00ced17a3158c83, 0x3ffc8c088cfcc79c,
    0x3ff2f1a3bc48dcec, 0xbff3b147c35fc32b,
    0xbfe2388aa3df92f1, 0x3fda9f93df3941c0,
    0x400130d18119f55a, 0xbfe36645dbfea348,
    0xc0022085ef34d2a2, 0x3fe264ba76b48537,
    0xbfe7be60afd25ad8, 0x3fe2fec7c036f093,
    0xc001838faaa602ba, 0x3fe0bf8f72e80fa4,
    0x40120ecbe5987581, 0xbfe8da2f128ef040,
    0xbfc6110443722f80, 0xbfff82175ddba2de,
    0xbfd227f5443fb33b, 0xbfce626ba69d2898,
    0xbfe2f352f1f01703, 0xbff16e288d6db0ba,
    0xbff19d4bdf0505e5, 0xbfe39a42dd1bc652,
    0xc0066506bcb5cec5, 0x3ff0c116036ed752,
    0xbfd3e97982837432, 0x400030bdd4144e9a,
    0x3ff58d8c2228a8d3, 0x3ff91e75aba3d507,
    0xc00132534fe5c919, 0xbffc29235efc08e0,
    0x40041e3b6aaf5784, 0xbfe93b8f75110df3,
    0x3ff282bb85865896, 0xbfde6140e8c15e2f,
    0x3ff1d10512660146, 0xbfe13a8cd43c438a,
    0x3fa2eed1ecf40c70, 0xbfc306a105985c60,
    0xbfd602a92d9b7c21, 0xbff93ab7a63e3806,
    0xbff45df97ca853f6, 0x400343ec4129c5d5,
    0xbfdbe26cf91ee4e8, 0xbfe77daa8d3af5a8,
    0xbfc6d3baccc251d8, 0xbff279ae06b9bd59,
    0x3fac0bd7954c89a0, 0x40046e16a1820cba,
    0x3fe764f738c53ba8, 0x3fef6e28714b8cca,
    0xbff6e31646128c65, 0xc002e796fc792c6c,
    0x3fed2a6b1d0f4b24, 0x3fe63726b7d195f2,
    0xbff2eab1e787e2c2, 0xc005191d3a464e84,
    0xbffc4a2f6268350c, 0x40005f6bf094e020,
    0xbfed4dbf18936aca, 0x3ffc9eb3ff071843,
    0x3ff003233d0dcd42, 0xbfe976ce3968e2bf,
    0x3fe6eee4a7e7d678, 0xbffa59870075a81a,
    0xbff09847036b3084, 0x3fea14d83499614d,
    0xbff778bcf01abd7c, 0xbff5b447e7d619ec,
    0xbff292a86c1b400e, 0xc00864bd8d9782d1,
    0x4009900008b28966, 0x3ff89d9e5b410042,
    0xbfd817bb6a919798, 0x400560db3473b223,
    0xbfea4e3f7a790ab5, 0xc0027be296b5caf5,
    0x4001afca18092fb2, 0x3ffa7fb1ad2e1f20,
    0x3feaca5c34d0f10a, 0xc00101097841cad6,
    0x3fdf4e6d57c69800, 0xbffb23b5f7dd20d3,
    0xbf91fe7266714380, 0xbfeaa7bfa0808390,
    0x3ff54bda0258fccd, 0x3fd55dc0d5573ca5,
    0xbfe7e38503b5b669, 0xbff71e3abef49e32,
    0xbfd65065a7d038e8, 0xbfe45cad42ad0ed6,
    0xbffddd67142cd48f, 0xbff6446d3b7481fb,
    0xbfcb1451e7c301f0, 0xc0010501525e1e08,
    0xc0011615e1839964, 0xbfec650d02aebf7e,
    0xc006dd0d158320c5, 0x3ffbc76a788ff87c,
    0xbfd90625f1fa600e, 0x3fd6c2f13f7696a2,
    0xc0012394436dc7b9, 0xbfc20abf1d5fd680,
    0xbfd177dfff040fb5, 0x3fb2367cc8d7d940,
    0xbfd72d2d49bb18fe, 0xbfee2dfa8f6943c4,
    0xc00168017bc3b068, 0xbff3508306d2cd6c,
    0x3fefd310fac86f0c, 0x3ff78d44c86bffd5,
    0xbfe0e6bb8659c27a, 0xbfe3ce34f6d969af,
    0x3fd768711b1b1ead, 0x3ffd452a165f2a9f,
    0xbfffb2e04509dfb2, 0x3ffcedd5b696fa93,
    0x400645dedff4ca09, 0xbf8db6c832064300,
    0xbff37baaba0e2169, 0xbff42b97f40b0984,
    0xbfe7d5a11310e4cf, 0x4005a9a00ebe60f8,
    0xc00acff017db9a89, 0xbff44758b85cae4a,
    0x3fe53c0928f9b1e1, 0xbff3612f9955847c,
    0xc001c60612e86064, 0xbfef11bb43dae116,
    0x3fea6e82530e6522, 0x3feb0e769e0c1753,
    0xc00489ea5031e3c8, 0xbff6807502d8324c,
    0x400340d7795f6719, 0x3fe18e484d697d13,
    0x3fdcaf55ab015a90, 0xbffef8ba165dc75e,
    0x3fb4b8265c425786, 0x3fe6e5dc0273940e,
    0x3fc1172c335fe1fa, 0xbfcadce0c684ee0c,
    0x40018f03bee2fbb8, 0xbfe029309414949a,
    0xc0090cfca0766502, 0x3fe6528428520a7a,
    0xbfe29e7806506dc8, 0x400284f1b84788ce,
    0x3fb416123098c7f8, 0x3fe6c51c6b6e81f3,
    0x3ff624b4a654168e, 0x3ff7e37412568a90,
    0x3ff7e5312385a366, 0xbff5da51ad3b6453,
    0x3fc49cf2c080cb60, 0xbfeaa8df341af3f4,
    0xbffb4a2456d8fd26, 0x40023a9c19d8d169,
    0xc00558d477403c28, 0x400280aa7f8d4362,
    0x3fedb78b3f7d97dc, 0xbfe4437dbf88b8c0,
    0xbff350c0481ed79c, 0xbfdb9657f972eca3,
    0xbfe81ede88103ffe, 0xbfa2697ae6f532a0,
    0xbfe3f00dd20341ec, 0xbfe2bd271373b549,
    0xbfeb7c1e45d51b09, 0x3fdcab54a48d7b70,
    0xbff3de0201e7ec56, 0x3fd19068b8931fdc,
    0x3ff3bb6f9d8e4a17, 0x3ffb24da8f3efa38,
    0x3fdb4c309c22fe00, 0x3fef5a4e4c2ac2ae,
    0x3fdbc9038ff75f40, 0xc008e09bd90cc3ae,
    0x3fc66450fe61aec8, 0xbff06fe6762d63cc,
    0xbfe2844e401db337, 0x3f8f7894205b22c0,
    0x3ff085decdc95dcf, 0x3fe903fef786ceda,
    0x3ff65364a5714ee0, 0x3ff7fba8022e4cfa,
    0xbfe82841bafbba68, 0x3fe199c73d233d8a,
    0x3fe82efa47c8e63c, 0xbfe97eff5c471e38,
    0x3ff00365fda4123f, 0xbfe77d887391904e,
    0x3fe8f70fdc9237c2, 0x3ff6ab6b2d155aec,
    0x4004e27ea760397e, 0x3fe4615a4f021198,
    0x3ff00bad0c78959f, 0x3fd8bade9778cacc,
    0x3fe1434125f44f2a, 0x3fdb2616eb88051a,
    0x3febc7d95ded9249, 0x3fdb3f5ba296d2d2,
    0x3fda0485a1c1d4c9, 0x400678aa84ec00ed,
    0xbfe992db85fd7930, 0x3fddd84a930029e0,
    0xbff22a8d9ada5adc, 0x3ff5992f27098c9b,
    0xbff22c3849416abd, 0xbfcaf1e7ebb311a8,
    0xbfe1b23a8f5ed25d, 0x3ff09a3448cc5065,
    0x400c35ce985e9aa6, 0xbff8b06a53c7de35,
    0xbfef59c465543a43, 0xc000831cce427932,
    0x4018fc992c24b60d, 0xbff0d831b088be40,
    0x3fbf88377e83cdd8, 0x3fe03a9f64da63e3,
    0x3fdd670b8453b0cc, 0x3ff989d28d1fe2e8,
    0x3fe327d7c0288374, 0xbfdfc6ade66add32,
    0xbfdd094ec9ee3d62, 0x400a34fe501db974,
    0xbfcc8ae2a162cb4c, 0xbff24f078c0f5653,
    0x3ffb5035a717a0af, 0x3fd49fcda2893773,
    0x400457cf161b39e4, 0x400101739dd03758,
    0xbfdf0661a28b2d50, 0xc00072a8523028a5,
    0xbfe04dc88a0706fd, 0x40049b64b8b89f34,
    0x3ff62fd8717c653c, 0xbfefbc6027dd9c99,
    0xbff7506e3744d587, 0xbfdbc9f830b07d84,
    0xbfe3aa1312d706ea, 0x3ff72fcf68585aa2,
    0x3ff23cafe65aec49, 0x3ff8b01ead8dd306,
    0xbfdebd85c13398fb, 0xbfd25ff35db8dab2,
    0xbff9d1390d2cb2b5, 0xbfe958f5ca82f3c7,
    0x3ff629303816406e, 0xbfdfdf9ac252cfb8,
    0x3ff1f4449b10e05a, 0xbff18af9bea39494,
    0x40029dc92d5894c2, 0x3fd6afb6572c60f0,
    0xbfe1be085a3cf7e0, 0x4004cda50694f192,
    0xbfe79ebfe2f9ecf5, 0xbfba82102cfb7818,
    0x3ffed2e19dc73271, 0x3ff2c0ad8e589526,
    0xc00b318186f4a83f, 0xbfd5abaf6bf73090,
    0x3ff0396d23db3a06, 0xbff9ac20c576f6fe,
    0xbff8a34dd41125d9, 0x3fe36c634f53df71,
    0x3fe0d7538c56aa86, 0xbfb6296b22414cfc,
    0xbffb9743be70b050, 0xbff3a9f32f6f0b8f,
    0xbfffe26f77c307ae, 0xbfeec9f65e633ddb,
    0xbfc0d420e2044ef0, 0x4007a0bc40474a18,
    0xbffe261eec2ff142, 0xbff6d9717d54988a,
    0x3ff23921b8e0bb6a, 0xbfc115ca0f828b64,
    0xbfbbf8d2eca0cdb0, 0xc00424a3a9c4f1e8,
    0xbff3387e10dd6322, 0x400ec7d4c74ba0f4,
    0xbfd2f3c90f5c3ba0, 0xbfe4720fdfb91dfc,
    0xc0096f39f7abdf7d, 0x3fa63daf33dbc840,
    0x3febe6a2bd0e6c38, 0x3fe20d59e330a3b8,
    0xbfe68a452bcb113e, 0xc0027f121aef25ca,
    0x3ff3c68b92f35536, 0x3fec073f2420f353,
    0xbff9e2edb55866ae, 0xbff4f4dbea7cd2c4,
    0x3fe50be6efa661d8, 0x3fd46a180bb11450,
    0x3fef0a3e1414490e, 0xbfcaf1efd6e016b8,
    0xbffdf16849c9c9a8, 0x3fe7af3ddf7d3066,
    0xc009870c704b1147, 0x3ffd1d9167b2d0b5,
    0x3fe3ca1aec9ef9cc, 0x3ffcfa77009a7dac,
    0xbfdc770da16937b8, 0xbfc6b0efdc45f2fd,
    0x3ffd477697435198, 0xbff8346379ca28a8,
    0x3ffd76ec340b17fd, 0xbff7667bbb6e86dc,
    0x3ff94de9bee5b8c4, 0x4006206aa6d9052a,
    0x3fc44a6b003e6180, 0xbffcda5eafe75584,
    0x3fc4a2fcf882f940, 0x3ff8683819e36686,
    0x400228a750cdbcb1, 0xbfb838b09a609218,
    0xbfd6fedb2fd77508, 0x3fe1dcfc4ce0b512,
    0x3feb2ce0252249ce, 0x3ffb9c67d166146c,
    0x3ff0df6d222413c6, 0xbfe195520515a56c,
    0xc0053e4e9f99981a, 0xbffc7f3cd63c6934,
    0xbfe73e2be1c8c758, 0x3ff3ce66f2b148d3,
    0xbff3f57b2cf60fcb, 0xbffec368ff307f66,
    0x3ff72736e3e84e70, 0x3fdf09526675bd40,
    0xbfe53eb2a4aa9bb6, 0x3fdc8f166d556944,
    0x400b38116e5d5a63, 0x3fee29d19b609e63,
    0x3febd784eb6181bf, 0xc009e6fa9ddf98ad,
    0xbff21315d656cc3c, 0x3fbe52923fa71ef0,
    0x3fd1ccfd9601f3ee, 0x3fdb86f0c0013182,
    0x3ff23947d39d018b, 0xbff052d500760b9c,
    0xbff34a0d320c4088, 0x3fec88e60a81cf5b,
    0xbff4c2be5057b01e, 0x3fe2c8eb0d821ce6,
    0x400e1f99b9329570, 0xc005df8634e941f9,
    0x3ff78d1670995ecb, 0xbff1778c8d5c9270,
    0xbfd4b034fce982c4, 0x3ff76c0d739c1f3f,
    0x4000a386e819caf2, 0x40006f11f8aaa904,
    0x3fd9484ce812cf31, 0x3ff73b29fac4efe2,
    0xbfc5483735bd4404, 0xc00a17db6cf3f7a1,
    0x400065d17fe358b9, 0x3ff78b39acd60a1e,
    0xbfafb9f92df29350, 0xbfc46e802f9e4f50,
    0x3fdce64283b95286, 0xbff5f89aca4d14ac,
    0x3fd1118a26dd88fa, 0xbfe6992741b405c8,
    0xc00da77d3aa1cc4a, 0xbfea3dfe2bd73c6a,
    0xbffe7ad202b9ddec, 0x400d9b980aee39d4,
    0x3fe9f78135859011, 0xbff4a7da064aeb96,
    0x3fca48eaeb46d934, 0xbfe768f362315692,
    0xbffb5ddeee8d847b, 0x4005c04f44d208b6,
    0xbff85eaf992c8269, 0xbfe320282b97e5cc,
    0xbfe8ad4236fa1398, 0xbfedae08b72a79a8,
    0xc003a9e22ea28e6e, 0xbfbc5ca912b26a30,
    0xbfd76ee1316ed9d4, 0xbfefa8f731733d54,
    0x3ff49dd6fbe700b0, 0x401111713a51ba08,
    0xbf9c2bc1a4781400, 0xc00481f0c673dec6,
    0x3feac531122a55ab, 0xbfe3170fb1f352d0,
    0x40029ed73c954e9f, 0xbfed544c1ff656e5,
    0x3ffb6302d1386d02, 0xc00460818ced3070,
    0x40038f2f3e946ba9, 0xbff2e4bccf47cb22,
    0xbfdc51c20e1387f8, 0x40035e7800a694cc,
    0x3fecf07da35646c8, 0x3fe8abb28aa84f80,
    0x3fc1d0a823669c58, 0x3fa913e86730af80,
    0xc002dc87781fb673, 0xbff70fe189e5a55b,
    0x3fc2812cfa4f61a0, 0xbffde6770e3b852a,
    0xc00067a126d4f92c, 0x3fdebbfa5e439818,
    0x3fb1436a076cb1c4, 0x40023981175af679,
    0x400b788e80f8c9bc, 0x3fd83a3b99f5b00c,
    0x3ff8037afda9ffb3, 0xbfa476360015a728,
    0xbff16687475aed68, 0xbffc9bb13360bf0b,
    0x3fa90d8f5cd61600, 0x3ffc20351c46de3f,
    0x3ffa9d6c00024736, 0x400050cb090c3e50,
    0x3fe6060e054c1858, 0x3ff8e7706510773c,
    0x3fe4af6ec58dec11, 0x4002e33952270480,
    0xc001512aa8e8552c, 0x3fcd09dac3987b4c,
    0xc004ff4b53e193ff, 0x400140bd2243cdf3,
    0xbff419839d429d62, 0xbfeba7969e3db096,
    0x400a616177c704bd, 0x3fdb0d22f97426f8,
    0x3fb0723acebf8288, 0xbff5b338ad583d33,
    0xbffba5d3fe69d5fa, 0x3ff45f84a433f398,
    0x3ffe57a5a388c7d6, 0x400144173570830c,
    0xc004a49fc4e01009, 0x3fd0a38e1e435aae,
    0xbffbbf7f7c7104d8, 0xbff1657f57023b67,
    0xbff45074bf7a9481, 0xbfed1ea6c2ca65ac,
    0x400747716a156ba5, 0xbfec6d2645ef1288,
    0xbfe7dff06e383e2a, 0xbff7b989894b70d4,
    0x3fc491e4c2522ba0, 0x3fe7c69d5eddb65a,
    0xbffddb0646d01908, 0xbff293d034a74f35,
    0x3fc91223fbc0ef18, 0xbffbe8343a41ca85,
    0xbfec96a7bbe75d14, 0x3ff6f278b5efa05f,
    0xc0030c2aecd8e3f7, 0x400781c3a859ee30,
    0xbfd0a6abdba2a1c8, 0x3ff9f913a140d57c,
    0x3fcb4cfd263ee210, 0xc010adc59b3a7c40,
    0x3fea2cdde8391676, 0xbfffeca7c8fe3864,
    0xbfef198795806dc1, 0x3fdbbcf3981f95de,
    0xbff0228495366954, 0x40098f7da8eee7da,
    0xbff14570920d1e58, 0x3fec342b3a0b14e6,
    0xc0014d63d0fffba4, 0xbfd72bed967534a3,
    0x3fe30d364cd7a234, 0x3fdf1d10cb2c5950,
    0xbff81a6c48b4c45e, 0xbff6666651de4efe,
    0x3fc920e7f0b74d94, 0x3fcda19a8a6cbbb0,
    0x3ffbba8bd62f6e48, 0x3ff7ea56e9a6e53d,
    0xbfeaf851b46f6eee, 0x3fe7890183564b7d,
    0xbffe0b8f954dbf49, 0x400789e13d562ec0,
    0x3f5ede7e7bf82700, 0x3fd9acbca0e68cc9,
    0xc00caa9459fc8f90, 0x4004a7dce9ac8221,
    0xc009b66ab24264aa, 0x3fb8154cb84d3ff0,
    0x3ff5eafc70923f83, 0x400be81f2221d004,
    0xbfd33399e8b3c912, 0x3ff5bec62c8baac4,
    0x3fd1de786e138fcb, 0xbfe13fddce7d72b4,
    0xbfd4fb783b9a60be, 0xc004bf50f0c9fc5c,
    0xc005f89bc7d1a152, 0xbfff31b6eb740c28,
    0x3fd3867d9ef54d89, 0x400473af2eecdc6f,
    0xbfe4d3f256e003c7, 0x3f97041271df1370,
    0xbfd4d9a978d3946f, 0xbffc4ac77b56d5d1,
    0xbfd31fd5a62c1765, 0xbfd5aeff3c61dade,
    0xbff939122599af85, 0xbfe652efdbaa681d,
    0x3ff91904e4093350, 0x3ffad424e654ad67,
    0xc0002e1d8d6e64ac, 0xbfd48eaf92f2bc07,
    0x3ff71bb363b1ba33, 0xbff15ebee223a728,
    0x3fce2d9528f8a9ea, 0x3ff3281f7a9082a6,
    0x3fe0c4200b8c138f, 0xbfda9eef2889eb3c,
    0x400ca4de41f7bc33, 0xc002afc3bb06908a,
    0x40060bae5f02ea1d, 0x3fcd608f2ac94da0,
    0x400095c67e25bfdc, 0x400878096c4074b0,
    0x3feebf8c746576b3, 0x4003e999332dc393,
    0xbfd51e8072a0e7f0, 0x400dcf7c22b2c640,
    0xbfddf6e428c2893e, 0x3fe3922cd98b394e,
    0xbff4d9ce7b988a3b, 0xc0035bba4a0bb8fa,
    0x3fddd54d017e7e70, 0xbfd25addd9bea468,
    0x3fd2ad6ee510b083, 0x3fe9350a1d4f0970,
    0x3ff73051d454cf34, 0x3fe70b687d60955d,
    0x3ff2f8cdec2cc272, 0xbfa0b4bc6bb17cc0,
    0xbffd6688c90fe7ca, 0xbff10cb01b2f4201,
    0xbff782d7b7b62e14, 0xbff1da81c8f4cf57,
    0xc000159995adbdd8, 0x4000339dc3c5e210,
    0x3fdc2a8b10b5748e, 0xbfc57e986a8b2d88,
    0xbfe5a3a0f0251b26, 0xbfbf28424759e7d8,
    0xc012da791a910386, 0x3fd3f1d5f388b010,
    0x3ffe30d97ff65e0c, 0x3ffdbec1361c072f,
    0xbff1b9b830e9c3a2, 0xbff206d538b3ea70,
    0xbfd4c04a28f61dc4, 0xbff350fb5ce19d10,
    0xbfd90242a386bfe4, 0x3fe3583ef4e5a39f,
    0xbfbed419ffa153b4, 0x3fca6e101b24c32c,
    0xbff12c6736448e32, 0xc00740cadcdd8f38,
    0xbffb99e8efb667e7, 0xbff0035acfe3d908,
    0x3ffad0ab205e2e3f, 0x3fe243df4257443c,
    0x3ff9a33fe9a3c0ab, 0x40000343b2be15a4,
    0xbff1c5ea8f08e1be, 0x3ff2e2d02e3ad890,
    0x4001f00fd777d30e, 0x3fea3c64510961e2,
    0x40082e457b525475, 0xc001a569573954d7,
    0x3ff1e5044e7703a8, 0xbfdc78a583f78600,
    0x400c02fcde5228a6, 0x3fe259de9438547e,
    0x3feb26e2b678b223, 0xbff60cb709d2471a,
    0xc00043ace589ba17, 0x3ff0f1fe6e27f7a6,
    0xbfdd19dbc9acf6f8, 0xbfeafc83f1309c93,
    0x3fe3f42a7e5e48a2, 0x3ff2a937b76490d5,
    0xbfb10c9e6b3db14c, 0xbffb1b7217e85488,
    0x3ff1201c2d3ee102, 0xc00199fdd604f2bd,
    0xbff22d8f5ff45f94, 0x400448358e83f814,
    0xbffa4668420523e0, 0x3fb1a8678e6975d8,
    0xbfe664ca5f20b148, 0xbfef686c984eae42,
    0xbfec45ecfa5a7021, 0xbfdaaf5bb1a99f1a,
    0xc004f4e1fa369d59, 0xbfff6dc1ba1d93fe,
    0xc001d1e31f834d10, 0x4004205471f1ee82,
    0xbff2e88b40afd36e, 0xbfd376d4f05ba616,
    0x3fdccf74a6e89740, 0xbfc3525c8bc6281a,
    0x3fe6efcf5f17e0b5, 0x3fdc17264eb58574,
    0xbfeba48195b5aab6, 0xbfdc8e550ab648b0,
    0x3fb752d14cb7d7fc, 0xc00be5b91b7c9802,
    0xbffd096da95a4a4d, 0x3fc90f2c619eb02a,
    0xbff62f6264222897, 0xbfa8fac2ef72e400,
    0xbfea8aeda7ce85be, 0xbff358969c1a135f,
    0x3fd93def1aa7a6a2, 0x40016e2b37b3574c,
    0xbfec2155728f91ae, 0x3fe00b8c6d581a02,
    0xbfeda63ed8737354, 0xbfcfdaece77b748c,
    0xbfd614014a5c5362, 0xbff0a0d452ae833b,
    0x3ff661d27f2d3990, 0xbfe1e972a964f414,
    0x3ff4ad29a19f562c, 0x3ff607c65095c2ac,
    0xbfe222a2c4ec7da7, 0x3ff720c81d9c6a1a,
    0x3fff412478d185eb, 0xbff373964a2048ea,
    0xbfb85fc12966c950, 0x3fe245ca81373880,
    0xbfddbabb87678310, 0x3fff6cabd84fd1b1,
    0x3fcd3d22b1aa451c, 0xbfd50e797f8a04bc,
    0x3fd495a57e82b8a2, 0xbfe87bd55cac597c,
    0x3fffffc3343f16d7, 0x3fc584b60769eca6,
    0xbfe72ddae1be8774, 0x3fe9bb9f77012229,
    0xc00902a2c504ef88, 0x3ff68fdc55637330,
    0x3ff0e33b3cdc7347, 0xbfc921c5874f69e0,
    0x3fe12ac60848a938, 0xbfdea4216223064e,
    0xbfff83fca9ccd919, 0x3ff98ffa10d4376c,
    0xbff0bac3e47f737f, 0x3fe63f9f3a1e0251,
    0xbfffbc217f295d12, 0x3ff87584e97a16bc,
    0x3ff720873f89a588, 0x3ff1603b982eb49c,
    0x3fe092855133a076, 0x3fed95ee61aeb66e,
    0xbfe465aff93aef46, 0xbfd14308a8a808d5,
    0x3ff131064ca4590d, 0xbff381534f8f20c8,
    0x3fdb9ce52ad6e3ef, 0x3fe9246d94f8f447,
    0x3fc8012a84ba2c42, 0x3fdf0561d16d9c3c,
    0x3fec5c50cbd44ea8, 0x40099288b39a4902,
    0xbfd5f654a794fe3d, 0x3ffbb87bd2f9d619,
    0x3fe1ec42be5d6a28, 0x3ff983f667728752,
    0xc005ce4a80f1f042, 0xbff14366a1a2b33d,
    0xbff80908beccee40, 0x3ff926d0f3f72964,
    0xbfe83024a398be51, 0xc002c1169b7a04c5,
    0x3ff8fc1e39242d5e, 0xbff3363c2acf888e,
    0x400d0c3d87af11f5, 0xbfefd29ab3ecf3c4,
    0xbfeb6ede9db3d7a3, 0x3fdcd97d72e748e2,
    0xbfee0f5737ebd290, 0xbfef9ec04a52adc2,
    0xbfb52720bb9b0a52, 0xc00253beb2677702,
    0x3ff4a3f30138d95c, 0xbff4ea7dcb281b4e,
    0x3ff934e75f107502, 0x3fd732d86193e981,
    0xbfced48bde8e3490, 0x3ff410572ab1739c,
    0x3fe6ccd3dbe97944, 0xbffba9d5395f1cb8,
    0xc000893a4a1a9f1f, 0xbfe3e203ff0c81fe,
    0x3ff6042f5cbe19e3, 0x3fb9723c629410c8,
    0xbfb008730fd06958, 0xbfff01265beb072c,
    0x3fe01f0a4c504e8c, 0xbfe16a465af0dba4,
    0xbfece8fb41a2441c, 0xbffb659fbf8c5dbf,
    0xbfd3cf54f0726d6f, 0xbfc385d44218c834,
    0x4009199b2ebb0143, 0xbfec07ed05cfebde,
    0xbff03b7d5c4cb884, 0x4000f2d7e5dd6168,
    0x3fec988e46c70fda, 0xc01059dd7af06ea0,
    0xbfdc2b3c04541a41, 0xbfdd81ff0511a68e,
    0xc0023c03576c4208, 0x3fea85f86c519338,
    0x3feb6e985545707a, 0xbff5170f9b9b65f6,
    0xbfd68798fe7c5430, 0xc0039b47a501a8c4,
    0xbff9f7c3871c14b1, 0x3fa371143a22e930,
    0xbfc999a1047ce838, 0xc0019f180aeb33c3,
    0x4002c90b97e4cd26, 0xbfe820a4982c5a42,
    0x3ff846aa6e6e45f8, 0x3fd1ea7d34c080d8,
    0xbfacbb0556ee16f5, 0x3fd94bd690e114c4,
    0x3fcb246e51658d90, 0x3ff5e7de60b825ee,
    0x3ff7e3a137991a8a, 0x3fc8a261f0e98d80,
    0x40017fb9b184e93a, 0xc001966541bfbd0c,
    0x40025e1c21dff324, 0x3fee710c28cf96c5,
    0xbfbd2c738991fb10, 0x3fe1ef997cd99188,
    0x3fe4a0e795fcdf74, 0x3fed39520dafae69,
    0x3fe49efaf720c09e, 0x3ffbb20f96acec92,
    0xbfe3ac6bf3bc1ef3, 0x3ff0ce6b86dd7372,
    0x3ff2ddbc8061f34b, 0x3fecd88ba137a764,
    0xbfe9a2992454ff46, 0x3ff2b0a3b40dde5b,
    0xbfebcad88f15a0f4, 0xbff7b441a64963ee,
    0x3ff5527da941b556, 0x3fe30b80bcdeec58,
    0x4000613dd2758a84, 0xbffe74841bde6b7c,
    0xc010ed37fe57d8c0, 0x4001049dd08c088a,
    0xbfe96783a7db12c0, 0xc001ee0b623bf51c,
    0xbfecc6d39e21bfac, 0xbfe33a51fd30a7ee,
    0x4001112ac99bab1e, 0xbff3f5a2809fbc6e,
    0xc00504e32490d7aa, 0xc0027ce15222d9d4,
    0x3fd93f4b20e83bac, 0x3fb7356a03921df0,
    0xbff78d05d76164a6, 0x3ff44f8677921056,
    0xc001630adb28447e, 0xbff69ace97c8a799,
    0xbfb8cbd4dfdc3bc2, 0x3feaa264fa53a080,
    0xbfe7d0ce3ce19356, 0xbfd32de78db39530,
    0x3fff31cdc6642f04, 0x3fef234b77a3252f,
    0x3fd503d07bd45f57, 0x4007109dde33d582,
    0xbfea4b682b4250fc, 0xbff609a90bb5bb10,
    0xbffe153ae83733f3, 0xbfdbe3a68bfbeef8,
    0xbffcbbc158c9ebaa, 0x40003a7dc4168316,
    0x4005f4b7fc1f0ddc, 0xbfea6fa965a7c310,
    0xbfef0475e37532ea, 0xc00be796e8886f24,
    0x3ff6c18b6c85d7e3, 0xbffb16a9765f38fe,
    0xbfd89661842028e1, 0xc00095ae2a4dad4b,
    0xbff74877c91dd18d, 0xbf8ada0e5105b2c0,
    0xbff3b54388012243, 0xbfe023ed3dfbd03c,
    0x3ffc19b5e330c839, 0xbff07e983f6955b6,
    0x3fd198a715a7f514, 0x3fe4c353f593fe72,
    0x3fe80fd1a8be6787, 0xbff16ccbfecec8f3,
    0x3fc1c1670d16cadc, 0xbff73fba28638046,
    0x3fed6b3350856194, 0x4001064bfbc72c0d,
    0xbf9501cda6016be0, 0xbfeaa05d17d4501a,
    0x3ff22be48ed9d14d, 0x3ff1eb9110ed9b4a,
    0x4000fbf4c88632d7, 0xbfef2bdc5822764e,
    0x3fd72f7c0985e46e, 0xc00021d7163ec974,
    0xbffa22cae77adc03, 0xbff085269546da2d,
    0x3ff024afa4cefa80, 0x4001d5e05ccebd9c,
    0xbff384f7325a089e, 0x3fb3ae7aef0a0900,
    0x3fdc04854dcd9d97, 0xbfc02dbd44b59978,
    0x3ff73ea50c959586, 0xbfff0a60a8a5b911,
    0xbffb6b010567fe30, 0xbfd11ed9cccd17a2,
    0x3fea622b846c85be, 0xbff610773d263ee8,
    0x3fec0ef01b2a61fa, 0xc0055ec40a3eacae,
    0x3ff404e6f1b87609, 0xbff3f4227e6f4151,
    0x3fe4a611f8dc66fa, 0xbfc0b072f4afcf08,
    0xbff9b1f1ac6143e2, 0xbfe4da08b4f0eed9,
    0xbfcc3bde5e393a30, 0x3fe0dce0235be74d,
    0xbfd1a48080c5bfec, 0xbff67a406bf67721,
    0xbffa56a84217a7d1, 0x3fe9b305ef35d62c,
    0xbfff25507a46afc8, 0xc005f2dbf8151058,
    0x3fbbd45c15a00e48, 0xbffb948d0f00b498,
    0xbfa98d8be451b040, 0xbff7c6ab6ce7f3e5,
    0xbfe9c80d3850628a, 0xc00120272f85af37,
    0x3feb44f74fa57046, 0x3fefda4c372a94c1,
    0xbfefda810fa56c44, 0xbfd15acd0f005756,
    0xbfd2986b5eb70ff9, 0xc00cb29156877ab1,
    0xc0008cbcc6e9b3e6, 0x3fe99cedf4756c0a,
    0x3fe71c5a73d511f2, 0x40058e75f4da0382,
    0x3fe5ce650bdd3c35, 0x3fe3b19afa7a8d74,
    0xbffd406209ff5dc1, 0x3ff18ede66174abe,
    0xc00392dad643b643, 0x3fe1582bc7a1dbf2,
    0xbff4bd85ed05079e, 0x40061acea82ef2fe,
    0xbfd0c96697904940, 0x3fd85e24381b6018,
    0xbff4981dde8c0066, 0xbfea2bade50f9e62,
    0x3ff5ddd46598808c, 0xbfe5c98d9b8a4d2d,
    0xbff53c3094ef0ee0, 0x3fd9eab9fbb4438c,
    0xbfefe32b15bdff52, 0x400103d0d4c4c632,
    0x3feb02dda79b5a7a, 0xbffa67ca670c3553,
    0xbfd0daa4593d7f58, 0xbfdd04dfa9ed2c21,
    0x3fc1a2acaa3c71f9, 0x40002842a7d1e544,
    0xbfece582c2093902, 0xc011236e0721a4b7,
    0x3ff39247125752f9, 0xc00526905ed6677a,
    0x3fd5e375d024b8f4, 0x40047bb805627b60,
    0x3ffd9000f9f1a1b8, 0xbfe7b007dd05acbd,
    0xbfe99c29a05a6aa4, 0x400088c791d3451c,
    0x400000e5874461ec, 0x4001572f2a70e98a,
    0x3fd3632b47502829, 0xbff207e60480255a,
    0xbff0a9279b6d8426, 0x3ff528d0dd0a51d4,
    0x3ff9a91383c8d8ca, 0xbff22c271887d24d,
    0xbfcd4c9ebecce7f4, 0xbfdaddf4110ea2d4,
    0xbff0a806f71098d2, 0xbfaed4088fa4cd90,
    0x3ff3cc49e3b0d4fa, 0x3fde16ebab7ad25e,
    0x400115a71bf25160, 0x3fec8fc2ee45c88c,
    0xbfe7844b12ffb018, 0xbffa27a4c35fc10a,
    0xbff37dcbe77714cd, 0xbfee2c979504a24c,
    0x3ff2c3c293a7d97d, 0x3fed85bd0a4ff1dc,
    0xbfa185235c38a000, 0xbff44becfb72a4a7,
    0x4005746dfab8050d, 0xbfe211b787b9e66c,
    0xbfd999821844ac10, 0x3fdd6342b176c4ae,
    0xbff55c9c34ba63de, 0xc009083fc8896a7c,
    0xc004725fb3901364, 0xbfe1050032b66040,
    0x3fee5642ca66b9cb, 0x40077d20a2187e7c,
    0xc004096e2759a8ea, 0x3fa91c35e7f98780,
    0x3fe2c31350894365, 0xbf9bc8418424f880,
    0xbff2d7a625aa5f0f, 0xbfd2b61db3a5585e,
    0x3fe76dad87f3d8c6, 0x4006ed1b8a54edcc,
    0x4005a7746c0bf4df, 0xc00060e81e8b8590,
    0xbfdceaae0b119e73, 0xbfe0c84ded28056a,
    0xbffdf5f9ef799d85, 0x3fcfd6b22f7de548,
    0x3fe257ea482744ab, 0xbff984fe4de35b5c,
    0xc0121c2f0c8e44ca, 0xc00c0cfba9fa6c3a,
    0xc00044140f6875f7, 0xc0013c94b56de841,
    0x3fe3147ca3bd3bee, 0x3fe4810a6df20de6,
    0xbff193e16ec38ca1, 0xc00a264c3886cde0,
    0x3fb70720cab518de, 0x3fb1d82287218750,
    0x3fd30362846eaa68, 0xbff64611553bdd0c,
    0x3ff0b3d2230c77cb, 0x3ffb2d58fc730b0d,
    0x3fc07fba2a01b3a0, 0xbff39d64bdb81504,
    0x0
    };

static const uint64_t in_rfft_noisy_4096[4096] = {
    0xbfa16737c10e70f9, 0x3fe0d611cf699e7f,
    0x3fe6379e9581f3ea, 0x3fdccf3d6f8a8a53,
    0x3f9ac16e24dbab85, 0xbfe14c792b03107e,
    0xbfe6bb6cf964a41d, 0xbfe2cd2d308d8c75,
    0xbfb8a871f217bf95, 0x3fdf46a6ca033221,
    0x3fe65eb00e261bc0, 0x3fdf788482e37f49,
    0x3f874bad312e42f2, 0xbfe049989a969713,
    0xbfe29166bafd4591, 0xbfe305d4e441dd06,
    0x3f82e1f680efde33, 0x3fe12807667f16fc,
    0x3fe5c55ce03458b3, 0x3fe1fc3a75d19512,
    0xbf8d715549287078, 0xbfdd8454287e38ca,
    0xbfe71efb1d0425fc, 0xbfe0cf6289f18fec,
    0xbfa3753b73fa7fb2, 0x3fdf6d56d96eb9d1,
    0x3fe73910287a83de, 0x3fe0da9ea6fce1a4,
    0x3fa8d20c170de3f2, 0xbfdf23f4ba82535f,
    0xbfe69397f72c814f, 0xbfe00ac70d3546a9,
    0x3fbd5284b6654f2c, 0x3fe0418cab237906,
    0x3fe4cf0281fe8a22, 0x3fe1f959506270fb,
    0xbfa3452b36d78351, 0xbfdf2de49b5d9253,
    0xbfe62db4d8eeb203, 0xbfddb44f6507ceb9,
    0x3f56d505d5861eda, 0x3fdd6e03b497afde,
    0x3fe2ceb067d0cd38, 0x3fdb055b3ce79d0b,
    0x3fa0f88c9585ce9c, 0xbfe13bfdab02d0cc,
    0xbfe4f4e1ce857f7a, 0xbfdfca37bbe5375f,
    0xbfb4e376a7ef5009, 0x3fe137a6dae12e94,
    0x3fe5bd62cf89e753, 0x3fdf843d19e57ace,
    0xbf8152b5e6c9dd62, 0xbfe1e533c72f1604,
    0xbfe6eecf69baac0c, 0xbfde8f0f67baa1e6,
    0x3fb4c5c2e49df786, 0x3fdea44e25ab470d,
    0x3fe6c5d2da3ce073, 0x3fdf35c7cf76116b,
    0xbf9e0a055aa721d3, 0xbfdbd7eb00c3c8b0,
    0xbfe7e200390d898c, 0xbfe0a6eab2b55b27,
    0xbf8d0fec5a11f994, 0x3fe0ddda2083798d,
    0x3fe717e18e8f1bb4, 0x3fe24a8e30121fb0,
    0xbfa5056d966f474f, 0xbfe08f4cdbd4f466,
    0xbfe633696aa435d7, 0xbfe174036e3927db,
    0x3f84a73aa1588e13, 0x3fe00c0f3919c992,
    0x3fe7e2f35d7d24ec, 0x3fdec219a71bf34d,
    0xbfc389ee711ffb30, 0xbfe0a0bc2a910325,
    0xbfe762bd06d41509, 0xbfdf8774811e8960,
    0xbfa1a20b00a47316, 0x3fe0ed712652258f,
    0x3fe724cae2a58766, 0x3fe102346b32fef4,
    0x3f983ea8f4d9bfea, 0xbfe130cee15f447d,
    0xbfe7823c76caacea, 0xbfdef6aacba8f177,
    0xbfbe90b8ca9d345d, 0x3fe05c05957b549e,
    0x3fe68dcc8599f3f3, 0x3fe313fa37e35fa0,
    0xbfb3a44b80ee5097, 0xbfdcd20bcf7a4a86,
    0xbfe5804080dfcbfe, 0xbfe04cb64a37cf19,
    0xbfac0f642899e1c3, 0x3fdcf2910ac83cc6,
    0x3fe461cf08601ed0, 0x3fdc6dcc4ea5ca00,
    0xbf899c28467f1900, 0xbfda74d671f9c113,
    0xbfe69e1272bf737c, 0xbfddd03ff6295e80,
    0xbf91d2139ac45374, 0x3fdf3605ebe8b19a,
    0x3fe5eb4938db11d3, 0x3fdb93ca87c05b34,
    0x3f9d1b78f344383d, 0xbfdf53d50dc455aa,
    0xbfe82ab4f5f7f8ea, 0xbfe12b099879055d,
    0x3f908afcea6ea543, 0x3fd9e88e33ea9118,
    0x3fe824158f20e658, 0x3fe10b23e09173e2,
    0xbfbbdd64f712bbdd, 0xbfddbde798c07d82,
    0xbfe54d39d1d63977, 0xbfe1dc65fda40dd5,
    0xbfb7ccb9e63d7251, 0x3fddbc07482dbe39,
    0x3fe4d0b852be5500, 0x3fe17a4dd80dab9f,
    0xbf96e3adab036f2a, 0xbfdb5263182b1075,
    0xbfe594e328cd8131, 0xbfe0cc0a6bd48314,
    0x3f9b2c712237aa4e, 0x3fe23fc72f1a5c94,
    0x3fe62223b7a62c2a, 0x3fdf3db7fe04911e,
    0xbf87ecb1159980c7, 0xbfdcf2899ab92420,
    0xbfe670dabcdf5e0b, 0xbfd9b44cbf0b4d04,
    0x3faab35f1de68d15, 0x3fdc081fe06e6f65,
    0x3fe87fb1498c0fcc, 0x3fda20885253d277,
    0xbf9099464012022a, 0xbfe24a4188c0cbe0,
    0xbfe644ab2e11c07a, 0xbfde5113117ff73b,
    0xbf42facaaf9fd993, 0x3fe02c0c3a52f549,
    0x3fe7a218c4783911, 0x3fdedd22dacdaab1,
    0x3fa8c3bda0deb8fa, 0xbfd7e9e8350b0d52,
    0xbfe82ee6f43af112, 0xbfdf0584524af66c,
    0xbfaa84be8b4eea77, 0x3fe32d12a3d09177,
    0x3fe5b6ba7f8e3c59, 0x3fe12af4caae6468,
    0xbf8b10c25f554fe4, 0xbfe09c731dd128bf,
    0xbfe5a94461bdeae6, 0xbfdcbec5f9112625,
    0xbfa7405855d16a26, 0x3fe11bcfd0240e97,
    0x3fe8fe4a63a5b181, 0x3fde52324424f745,
    0xbf934d070da6149b, 0xbfde571ea932df6f,
    0xbfe49f2c0f2593c7, 0xbfdab87cfac69ab6,
    0xbfb265ceaa4e216f, 0x3fdd5a575d14ec83,
    0x3fe5075e67266328, 0x3fe12f2f96d917f6,
    0xbf8a041e35a939a5, 0xbfdb13ad6b326360,
    0xbfe58f1dfb70311f, 0xbfe085b5211d1400,
    0x3fc27fb7a55132a5, 0x3fdd415b1e8657ab,
    0x3fe2e01ab5be5438, 0x3fe28b8576de18ef,
    0xbf67ec7b3bdc0ab2, 0xbfe0bd07ef8f3282,
    0xbfe7f7d1997380b9, 0xbfdaded193278f2b,
    0x3fa050e3126990ea, 0x3fdcc108b32c9c37,
    0x3fe7a0997379d45c, 0x3fe03abf8ce34416,
    0xbfa164389af39232, 0xbfdf213610009fc8,
    0xbfe3376262820415, 0xbfdf4ac14895ecee,
    0xbfb43dbd98055040, 0x3fdd67537c50d71c,
    0x3fe56e4f422f2361, 0x3fe047203b7f73f9,
    0xbfa531116671bd43, 0xbfdeba16f830c7f2,
    0xbfe5e6bb75a2ed16, 0xbfd94f60d8574ebc,
    0xbfb06007ec3023f3, 0x3fd9e734b2cb0a33,
    0x3fe778d32b50fd4d, 0x3fddd04d33a6f092,
    0xbfa5f2f8cabecef7, 0xbfda158531501a10,
    0xbfe837e61ddc6e74, 0xbfe03196ee4109ef,
    0x3fac84781d3e09f9, 0x3fdf0611ac1a1e49,
    0x3fe83bd1a97f0d5a, 0x3fdc192d75fd3ea4,
    0x3f8e13dacdc2524e, 0xbfde3785f52fbc40,
    0xbfe5fc1af5634ac6, 0xbfddef2ceec324c2,
    0x3f8a2d02c418a08f, 0x3fdb062ad555192f,
    0x3fe660d88df3466a, 0x3fe0db5d0696e266,
    0x3f70c4445b0645d5, 0xbfe08a47d7fab377,
    0xbfe319ef0de393ea, 0xbfdc22d18b78b4c2,
    0x3fa7ecf4784eab85, 0x3fe1ab48d1bc269d,
    0x3fe884173a52bb51, 0x3fe127b13ea36d78,
    0xbf9fa49a91bae5c6, 0xbfe03f1d501c4c6c,
    0xbfe712ef7228f95b, 0xbfddbef5f6770bde,
    0xbfbb362651911e7f, 0x3fe03740548b8f6d,
    0x3fe5fc7c39d53242, 0x3fe098a8ba695bbd,
    0xbf368169cc76f367, 0xbfdbf120efc48679,
    0xbfe6ddc3f2369f02, 0xbfe00829a31f309b,
    0xbf909b1b1b178f00, 0x3fdce6ee21e33229,
    0x3fe436f47bbe487f, 0x3fde19878859b3a5,
    0x3f7b43b5ed26f087, 0xbfdba1bcd59ca5f9,
    0xbfe5f23c306b4645, 0xbfdf180bf8ff64ac,
    0xbf8909a47bb5a5d8, 0x3fdee9f5fd2b4921,
    0x3fe579262de0834b, 0x3fde42d117a25cf0,
    0xbfa75390339f2dda, 0xbfe01004f401549a,
    0xbfe7b44eff9c514d, 0xbfde75e8c6af61d7,
    0x3fbd684a837526f7, 0x3fdcb623e213949b,
    0x3fe43e23f575c7ac, 0x3fdfc0dd2615e3e0,
    0x3fa017593c55cbd9, 0xbfe060f130b85359,
    0xbfe794352e571814, 0xbfe27216333c5711,
    0xbf708080d23baade, 0x3fdc92f212101726,
    0x3fe59a3f3e8bd536, 0x3fe04afb0cf9c5e7,
    0xbfb1d97bbe5fde4a, 0xbfdb8255fd8484c1,
    0xbfe56689aa9ba3c5, 0xbfde417f8e58e809,
    0x3fac40d04e70d272, 0x3fdce6df3d6dad07,
    0x3fe51a4fb51bff73, 0x3fd90486c13ecc98,
    0x3f97b3a314b209e9, 0xbfdf3413d5e4ed23,
    0xbfe997929abd6f3f, 0xbfde9ab9881a8a68,
    0xbfb561cea10c6e9b, 0x3fda9d48fe8bb0db,
    0x3fe65cb679453a4b, 0x3fe138e759644be1,
    0xbf9a7420b70b6df6, 0xbfe006f8d103f423,
    0xbfe40daa62931cb3, 0xbfdec6ff6e7a6db4,
    0x3f718428fbc8b19a, 0x3fe14363d04e62ae,
    0x3fe61b1561541370, 0x3fe012f2f6a4b76b,
    0xbfbdbbb1c0bc6aef, 0xbfde023a71865f47,
    0xbfe620dce6ee4910, 0xbfe180304a16e924,
    0x3f97bc22a2f19f77, 0x3fdee997e156f2f2,
    0x3fe5224eb3b9e608, 0x3fdf268afb42f05c,
    0x3fa39fea175b2b9a, 0xbfdf9b850b8fe527,
    0xbfe423eecf9177ee, 0xbfde5984a44e1a39,
    0x3f6a4384da837e35, 0x3fe06c56cf67281b,
    0x3fe61350e2fc3b64, 0x3fdd3a2d367015bf,
    0x3f6142113ee08b84, 0xbfe0a99063b98633,
    0xbfe61a317bd6414e, 0xbfdf336b5d401ec1,
    0x3fbb539998afc55c, 0x3fd9f496a8e7086f,
    0x3fe7a32fa825f030, 0x3fdd26fb30f4b5a1,
    0x3faea72157fecc1f, 0xbfde0b1a889963b8,
    0xbfe2213a63f48e02, 0xbfe12f15ac8aa3d2,
    0xbfa7a0ada8379602, 0x3fe03b073fb36ba2,
    0x3fe561a7ccd8802a, 0x3fe25b486d253feb,
    0x3fa4ef0944eef748, 0xbfdcb12d58395e60,
    0xbfe6da8132868b08, 0xbfe072c81521b656,
    0xbf728ce04e3b0888, 0x3fdf18b42308e165,
    0x3fe7a4c4806921f2, 0x3fde95eddd6eade3,
    0x3fae546b2b5f6dac, 0xbfe1906e63b9ccee,
    0xbfe4d8504dbfc439, 0xbfddf33c95c51a8c,
    0x3f302317b761ca45, 0x3fda33d8755f1bd5,
    0x3fe8c3a8a336bc8f, 0x3fdebd4cb74a2bb0,
    0x3fb7b12e75724ec6, 0xbfdbfaea3f6dfd2c,
    0xbfe77dd3732cbdec, 0xbfde6408a9ef3f8a,
    0x3f7de9ae4207f8bd, 0x3fdbb7acde80b989,
    0x3fe6296dcff9afca, 0x3fde4f1b25d613e7,
    0x3fa5b888a7ecec4b, 0xbfe232d882b4404d,
    0xbfe6e1684130439f, 0xbfdd252ae133d965,
    0x3fa96f36b4f54e7f, 0x3fdb09b5e7961bf0,
    0x3fe5ceb34931fcc1, 0x3fe21b6bcb4abd0c,
    0x3fa090e9d967f887, 0xbfd8faca46541fa9,
    0xbfe3e84f6cff8b98, 0xbfe02ee4ede70990,
    0xbfb757d29297db9d, 0x3fe02f4930d56961,
    0x3fe6dfbf8bbcffff, 0x3fde484f5d04c3a6,
    0x3fb2faec310a9a1f, 0xbfdecf516a106239,
    0xbfe4e8b5c175ee16, 0xbfe0ccb47e6cc5bd,
    0xbfaa1c1be74cf62f, 0x3fdcb786ab60b6aa,
    0x3fe6d1629bebe98c, 0x3fdc144270280e3e,
    0xbfa4c5567e0e5106, 0xbfe16f5679f94a89,
    0xbfe8d91e5ade0d56, 0xbfdf84b16e219aa1,
    0x3f96c863cb84e8d2, 0x3fdc36754dd8dea2,
    0x3fe8fb190bcac256, 0x3fdd951bac791d9f,
    0x3fc06314ddd06ff0, 0xbfe17dd465ecf9a3,
    0xbfe8d8943f601f32, 0xbfdf2ae100d06528,
    0x3fa98f7121549ef6, 0x3fdf03ba6ed69d4a,
    0x3fe608266cc360fd, 0x3fe2cd2c6057cd1e,
    0x3f9122049e4f3ea6, 0xbfdd811a10a6565e,
    0xbfe7809099287c4b, 0xbfdebea8df815499,
    0xbfa226707b559b58, 0x3fe029f382c9538b,
    0x3fe851c90990c0f4, 0x3fe1f4168e032235,
    0x3f776e5b9191c472, 0xbfd8e81b9711f12b,
    0xbfe719e336e143f4, 0xbfde70aa71402e9b,
    0xbfb7af2a8b9b7bdb, 0x3fe00fc7c9c666ef,
    0x3fe6ec28d66d37fe, 0x3fdc438d9e80ba44,
    0x3f836e7c0d2d503b, 0xbfe159987d7910dd,
    0xbfe5e67375b4af57, 0xbfda79ff29be6516,
    0x3f58da53c2f2b7e0, 0x3fdb0b4c5dc00a26,
    0x3fe80c302d2a1a25, 0x3fdfd8540b464fb2,
    0x3fa1d3a17200ffdb, 0xbfe289ba3d184a05,
    0xbfe4764f2828a335, 0xbfdfabb8bedb373c,
    0xbfc2d6b1edd2b15f, 0x3fe0744687b6aa96,
    0x3fe911b056ed49df, 0x3fde82b26f837567,
    0x3f9815f16a876982, 0xbfe01ecff0ea896c,
    0xbfe77632a2080bda, 0xbfe26182f987d158,
    0x3f262f5a83624df0, 0x3fdde978e817420e,
    0x3fe6d68479059b60, 0x3fdd5d9ac03944fa,
    0x3fb3ddbd3cc428ab, 0xbfe141167096350e,
    0xbfe2c7a79aff2a32, 0xbfe21a80aa3545e9,
    0xbfb6a612c1c66f40, 0x3fe2001bf78140f6,
    0x3fe5477a07af6084, 0x3fe17795fd634639,
    0xbfb849004ddf9b4c, 0xbfdd5b7525fb48ee,
    0xbfe72bc5f975a015, 0xbfdd6aa93399451e,
    0xbf88437fc174a602, 0x3fe01f1fe288751a,
    0x3fe6e3294ddfeeca, 0x3fdd165e9878306b,
    0xbfb9578a97808912, 0xbfe0726975a9c50b,
    0xbfe621429d2ab12c, 0xbfe03b8e0c11e407,
    0x3f86a69a8e8309f4, 0x3fe26f00acce26c8,
    0x3fe61bb5a5cab8b6, 0x3fe27ae45ba19e0e,
    0x3fa65ec404afad0f, 0xbfdc4c9d18f8c56f,
    0xbfe4d64f49c9ad30, 0xbfdd324629991eb6,
    0xbf8a765e34ea5cfd, 0x3fdd1d3b0239bbab,
    0x3fe599fb3a054893, 0x3fde0ecce7dea0fa,
    0x3fa0d4e03269d18b, 0xbfe0bfed31875d9c,
    0xbfe7fe152ec6615b, 0xbfe1426c18955123,
    0x3fa286f76d01cfb3, 0x3fe04eab934896a7,
    0x3fe42848c654d71c, 0x3fe12cc44ad6cb45,
    0x3f893f296e4a4f43, 0xbfddda8ec41a20d2,
    0xbfe820789caf68d4, 0xbfda8acbb40fbaf3,
    0xbfb1b3526bda6386, 0x3fe0dd37a96d1816,
    0x3fe5d597d6096c22, 0x3fe121d647c346c7,
    0x3f85861d9f1229bb, 0xbfdb67090b5ba651,
    0xbfeaa63d90165c80, 0xbfe01c5015c49246,
    0x3fb1876fd18593ed, 0x3fdf3df29442212c,
    0x3fe8bbac9e721175, 0x3fe021c0bbce46db,
    0x3fa1dd4539969273, 0xbfd944502b707dce,
    0xbfe5ffdb04cc551e, 0xbfe30f53154fa91f,
    0xbfa333a41420709e, 0x3fde3535120128d3,
    0x3fe7acfe7dc2ef2e, 0x3fe1db0ddc4e7653,
    0xbfa891f59d3a901b, 0xbfdfcb0268569113,
    0xbfe51e6814ae3101, 0xbfe0b52bc5f50f64,
    0xbfaa46072be61b8e, 0x3fdf89aa4db04b1b,
    0x3fe6e964cb14ee6f, 0x3fdf13d2a84f7389,
    0x3f9b0462770248da, 0xbfde523506eb08c2,
    0xbfe617e5b8f0d680, 0xbfe26277b868dd52,
    0xbf8b18775dd1f763, 0x3fddbc103495d1f0,
    0x3fe71781608e4b4c, 0x3fe24891acbba81a,
    0xbf93a493d5e6ca2e, 0xbfe1516135447cdb,
    0xbfe3e6ddd3853bdb, 0xbfe2812f4a51d2aa,
    0x3f66d4d3b9cf9f3a, 0x3fe035585107db4f,
    0x3fe88dc151ac43fa, 0x3fdc5e49fdf66c32,
    0xbfab04d3caf51765, 0xbfde5536dfd51305,
    0xbfe9ccab46fad727, 0xbfe0ac73feb321f9,
    0xbfb79d7653d9aa4e, 0x3fe020ceccc7b336,
    0x3fe6166522a340d9, 0x3fdb98b127587350,
    0x3fa72491b5651f98, 0xbfddf2b63a395f4d,
    0xbfe67ec222a40f93, 0xbfdc9c8fe4410b50,
    0x3fb841c4a62be45d, 0x3fda7420c017472a,
    0x3fe39fbe4559ee23, 0x3fdea4adb552fd7a,
    0x3fa7dcc152d3c189, 0xbfe1f0812410a94c,
    0xbfe8d38c7b95a0b0, 0xbfe17d0ea371fb25,
    0xbfb221fbc3483dd1, 0x3fdf6e51756687da,
    0x3fe6229d15ebf775, 0x3fdea4833b6a7a68,
    0xbf99c5868f60e2f5, 0xbfdc8d810f4071c1,
    0xbfe776a1005c9079, 0xbfdee6155adc48e3,
    0xbfb23dde1363cecf, 0x3fe02b444b9b540a,
    0x3fe74a65919eed9d, 0x3fe11a9536ed2446,
    0xbf6037d319b50ff9, 0xbfe0354d2a1c9292,
    0xbfe8872fd209ff97, 0xbfdd5586a87fcbc1,
    0x3f652d861af05f9e, 0x3fe157269a62d704,
    0x3fe597620d5f9b19, 0x3fdc83f9429a6776,
    0xbfa26a15e6d2682d, 0xbfdbb010f2c4ca16,
    0xbfe2df0d2186d1ac, 0xbfdf4fae092d3e86,
    0xbfbce1625de0c400, 0x3fdb0ed2efe627f1,
    0x3fe677f529af5402, 0x3fdc710563f66486,
    0xbfb224273858d176, 0xbfe096c927fad375,
    0xbfe34cb0fdb489b0, 0xbfe00859c379b547,
    0xbfad69183dde875b, 0x3fe0221086206aa6,
    0x3fe908669065ec1e, 0x3fd9de0709d8cbfa,
    0xbf9837dd3a9b0ecd, 0xbfd8b56363b6990f,
    0xbfe5e0a952da4609, 0xbfe1b8aff207901f,
    0xbf842a0fdf25787e, 0x3fdf55f155648fbd,
    0x3fe628ae56bdb3da, 0x3fdf9d746eb81cd2,
    0xbfa114f58d9b3dc0, 0xbfe0e2e6cf2742c2,
    0xbfe5c7de2e7294af, 0xbfe00cce75f4e58c,
    0xbf9a67a8f9bac441, 0x3fe1579f77472c09,
    0x3fe52d6b41a25a74, 0x3fe0521bcd3afbf0,
    0x3fa002bd11c6d4b5, 0xbfe079e06e13be75,
    0xbfe2f4fd593dc971, 0xbfe247247f6569a6,
    0x3f985b250236d2d0, 0x3fe0893c8aec3016,
    0x3fe73781ee7fe036, 0x3fe12223ec0655b8,
    0x3fa27ce7d6de17f4, 0xbfe27d2700021496,
    0xbfe61dc927d24c9c, 0xbfe0ddf0963101ce,
    0x3f1d82f8763e1e5b, 0x3fe0241eef11f125,
    0x3fe665911d8bb452, 0x3fddabaec8e8d429,
    0x3fb0968bbb316cbb, 0xbfe0382aac99bf55,
    0xbfe50bad1fc4aef4, 0xbfdd0d92191e8ba6,
    0xbf990e0f2d062d57, 0x3fd6fd11caa887f8,
    0x3fe63198d516fb4f, 0x3fe055ca91bb25ed,
    0x3f8cd20a850b1d88, 0xbfe1528e8b66ea13,
    0xbfe5ad63c6f0dc81, 0xbfe1e00bfe938632,
    0xbf9494f9eddfe0a5, 0x3fddb42fb7de50fa,
    0x3fe432dd95772ffe, 0x3fdcf2b6c54d4e7a,
    0x3fb0a3ff72a9ce10, 0xbfe093a2f5fe5ef8,
    0xbfe7ecf4f79ab2c5, 0xbfdfa2eedf3bad4b,
    0x3fb47806d0b79824, 0x3fdd9f1809a4bde9,
    0x3fe3f29069f21648, 0x3fdfc1992d332457,
    0x3fbb94c643aabd9c, 0xbfdc8f3436f53f4d,
    0xbfe466b76fc3cdb7, 0xbfde5c049c1030e2,
    0xbf928712f05f26c3, 0x3fda4d480a736575,
    0x3fe7d98da1d34792, 0x3fe0dfab9c2a2765,
    0x3f940a589537b1a3, 0xbfe22e3850d3a6dc,
    0xbfe735dda7df289e, 0xbfd9ad7f1340c2cc,
    0x3f83eace3b74b22c, 0x3fdad041d5b46dea,
    0x3fe6d9705da18874, 0x3fe1569144fe08fd,
    0x3f6d462b05438d66, 0xbfe1aff1a962e125,
    0xbfe743dbcf59cf60, 0xbfdfc57d12629b8f,
    0xbf843746fcede86b, 0x3fdc839efad57fba,
    0x3fe4ea51593325cb, 0x3fdf6cd24de1ac1b,
    0x3fb88503f99ff789, 0xbfdd0b73f0713c7a,
    0xbfe56364066b741f, 0xbfdf646e22ab5c8c,
    0xbfa51f616f29152e, 0x3fdb07278907a646,
    0x3fe3094928566d26, 0x3fdfe80bbb1bfe91,
    0xbfa083374c2e089d, 0xbfdec8448a2d7a88,
    0xbfe6c09ede440ee1, 0xbfda449d34ec936f,
    0xbf7848e781b203e7, 0x3fe0cafd041b060f,
    0x3fe6554a5b2b724e, 0x3fe31e27c73651d6,
    0x3f8d22c8b549b31b, 0xbfdcbbd0b4c28cca,
    0xbfe70ce252ecdae2, 0xbfe04acf6587c71a,
    0x3f971928bfff93b2, 0x3fdd662a66a8124c,
    0x3fe7702ddc76b3aa, 0x3fe02996a91db3ba,
    0xbfc0947e232df48f, 0xbfda740b386c7c55,
    0xbfe5a5b5ad7df89d, 0xbfdf4d9c574d5ac8,
    0xbfa0d05897f00baa, 0x3fdf058ef51c0083,
    0x3fe76d7d6d2e53db, 0x3fe049c0f50975db,
    0x3fa5099f1755456b, 0xbfe0b68f4b0c9aa2,
    0xbfe66950a2b8f170, 0xbfe1d345c923e0a5,
    0xbf95bf9721f249be, 0x3fdea160006756aa,
    0x3fe8802e3c6b00e2, 0x3fde720e6b4d4fc6,
    0xbfc414712cb7612a, 0xbfdede2f8a296185,
    0xbfe753cc68cdc783, 0xbfdc12cdccf1159c,
    0xbfa4595fd6f2d804, 0x3fde4f0a01186614,
    0x3fe8624d1ff6decd, 0x3fde9f2623dc0616,
    0xbf4317b4de0dc850, 0xbfe0fafa104827cb,
    0xbfe6b90aae324ca1, 0xbfe07f614ebf2dc7,
    0x3fb752f0d0b78173, 0x3fdf16ba4dcfe5c2,
    0x3fe4f7a798347a70, 0x3fdd1e3bd3d604dd,
    0x3fb6b3c1675060e4, 0xbfde555f73e11aa5,
    0xbfe678c2064590bf, 0xbfdba13b308575cf,
    0x3f9176c91d0d8d07, 0x3fe395b2bd676a24,
    0x3fe39f2ecf25cf40, 0x3fe0da7b9e493998,
    0x3f9bf4b43ba22ed5, 0xbfdd7c51b9fa0740,
    0xbfe792e1e5905a9f, 0xbfde6d542afa5049,
    0xbfa54e8fd5b7a0d6, 0x3fe129337f76bd0a,
    0x3fe7ef218f419137, 0x3fdff7ffc1ec4536,
    0x3f65183fe4c83b40, 0xbfdd2703bf239412,
    0xbfe8eec18ec17d44, 0xbfdd4fd559a9599f,
    0xbfaea82f4891573c, 0x3fe045f0efd0d31f,
    0x3fe79f895a42ec83, 0x3fe0126cab0992d0,
    0xbf89eb500ab44414, 0xbfdf5f3d75c27b8f,
    0xbfe51553cc5d2c45, 0xbfe1175b8880f933,
    0xbf900330b52bef21, 0x3fdd278b618bcd66,
    0x3fe6a14d2ab25baf, 0x3fd988a91d81797b,
    0x3f7b9be3e8487442, 0xbfe3749107c3b4ea,
    0xbfe424a544ff3a66, 0xbfdadb1e6efa3b60,
    0xbf934f9fd1006e92, 0x3fdf9da228dea357,
    0x3fe7170117f54a63, 0x3fdf4f770e04dba3,
    0xbfa79f9106e40962, 0xbfe0486fb83f034a,
    0xbfea06bc6d776db7, 0xbfe1e81a0744aa7e,
    0xbf9c2377272d45d6, 0x3fde9741d83a97da,
    0x3fe8404531293965, 0x3fe0acef5dd1fc9b,
    0xbf6c8e43de5564b7, 0xbfdac6a15f4c8056,
    0xbfe6befe26475b0a, 0xbfdc7b168e0fb2ec,
    0xbfa115664860e29d, 0x3fe01370992250e7,
    0x3fe97db232d97377, 0x3fe36d07c85881e8,
    0xbf73d7431c81e405, 0xbfdf3d2d91772e1c,
    0xbfe578b3238fe622, 0xbfe033b00c417b43,
    0x3fa303b97dc950e8, 0x3fd7280799192c12,
    0x3fe92679ed952920, 0x3fe0207a65897b34,
    0xbfad774d54d4ef44, 0xbfe222bb17be2674,
    0xbfe585084a8e4096, 0xbfe1d3e892aca584,
    0xbf7225430c746d5f, 0x3fe16bd6ba93cf3f,
    0x3fe3b327052490da, 0x3fe0029fd69b1e48,
    0x3f696513e6cdcded, 0xbfde3057bb7d55b4,
    0xbfe686f6904d60e4, 0xbfde01b95b30da49,
    0xbfbbe3bc298b43cd, 0x3fe173d21abd9fa7,
    0x3fe3c65a601e27d4, 0x3fdeba438337c51b,
    0xbf71aef6209a9c69, 0xbfdbae441ef72240,
    0xbfe657e2798abbc7, 0xbfe147ad225c5afd,
    0x3faa0f9c25dab760, 0x3fdc3dc4e6a29ce6,
    0x3fe8f8bc7e43152c, 0x3fddc09de790b892,
    0x3f9663dd05f285b0, 0xbfe084f0ac2d2834,
    0xbfe7097839c4ab62, 0xbfe1ed60fb34792b,
    0xbfaba45db9737e88, 0x3fe0ac279cb1c18c,
    0x3fe5f50d0ec9cffb, 0x3fda54be9cc04b97,
    0x3fb28646485520b6, 0xbfde1737a0a41f3a,
    0xbfe31441121515a2, 0xbfdcfc9f57c0eca1,
    0xbf98ce2ba664aaec, 0x3fe010b74ccee22a,
    0x3fe5e503a0c8e08a, 0x3fe1d4828ee94706,
    0xbfad1c23c71cdc76, 0xbfdf837173bb130e,
    0xbfe8ab473c074580, 0xbfdf6cc174a61c1e,
    0xbfb8f5b8dc32512e, 0x3fe2082c022eadf6,
    0x3fe683f408a569e4, 0x3fe1a59de71ff304,
    0xbf94ff77f2a9381d, 0xbfe25fd5147424ed,
    0xbfe8a1d9ecdd5639, 0xbfe0d5536becffba,
    0xbf8c5b1b2e4f3d8b, 0x3fdc05e1f5136b40,
    0x3fe5dff5fe9aa2af, 0x3fe14303b9bb7606,
    0x3fab14dea1be74b9, 0xbfe29798de27caf4,
    0xbfe778aca5a7dfe1, 0xbfdbe75f6b3c4043,
    0x3fa7284dfcd450b5, 0x3fda96399eee0970,
    0x3fe61f4dbd5ad461, 0x3fde955452b73d58,
    0xbf9495c3b8ce330a, 0xbfe0c54f28d2f388,
    0xbfe74dea9caa8738, 0xbfe2782dcbd26572,
    0x3f8049ea67525871, 0x3fe0f188688d0c6c,
    0x3fe6a8b6c5a6cfc7, 0x3fdbe20e88aad1f8,
    0xbf9842ffa0ac7cec, 0xbfe084a26f298c43,
    0xbfe7de0e8a02bb6e, 0xbfde1535d04f50cc,
    0xbf9c29bb819c2d3f, 0x3fdfb9a7d22c095b,
    0x3fe79317e27c5a74, 0x3fdfb0bbb7277ab9,
    0x3f74dc9410b1a57c, 0xbfe1413b0eb76a51,
    0xbfe6627f44c6d102, 0xbfe0c9b85f653164,
    0xbfbf4efd73d7ec82, 0x3fdb759f34a6ca78,
    0x3fe6d002dbb9c35f, 0x3fe1b747601745ae,
    0x3fb0322d8ef7e6aa, 0xbfe12c851260814b,
    0xbfe6486ad0929159, 0xbfe1b2f9ff390091,
    0x3fa0eee51c1d4ce7, 0x3fdd923984364f2f,
    0x3fe71e21374728f2, 0x3fdc9d88ef96d85a,
    0x3fbc913813f85da4, 0xbfdf481419ec70d6,
    0xbfe507422655ae28, 0xbfde62da05372e48,
    0xbf92144d59b80cbd, 0x3fdc04e2f0f33ed2,
    0x3fe85112776c410d, 0x3fe1c22dbb1c305e,
    0xbfa3f0bfb967d042, 0xbfe36a937afb4aaf,
    0xbfe71db636c7f9aa, 0xbfde3296ddb85be1,
    0xbf9ad63e04cf0f1f, 0x3fdc6338c3f32a49,
    0x3fe5dba91b8205fe, 0x3fdc6eac691286ff,
    0xbfb109db10bd8d77, 0xbfe0398b8244810e,
    0xbfe77a7e68703c3e, 0xbfe295cfca70f876,
    0xbfb1e321f37158cb, 0x3fe12286f2b0433c,
    0x3fe6be8e332685c2, 0x3fda31493312fa76,
    0x3fb28f0689d7dd1d, 0xbfe0095c0e041605,
    0xbfe8c06ca53259e1, 0xbfe16cf14d3b79a7,
    0xbf6be6289c915d7d, 0x3fdb51d24442a950,
    0x3fe4dd0548139e7d, 0x3fdbe4116bb621ee,
    0xbf982a4024420449, 0xbfe0e01f97346990,
    0xbfe67339e01e3b07, 0xbfde9f8086f47a4b,
    0xbfc09d3b99f3371c, 0x3fdce158d933dc50,
    0x3fe58c6d756c4339, 0x3fe0625811cd84ba,
    0x3fa963ef189bbc85, 0xbfdf09bb88b19171,
    0xbfe6dc8f930d1e8e, 0xbfe1c9af994847e0,
    0x3f85b5b7bf999000, 0x3fe219f34f00ced0,
    0x3fe51f475da89e7a, 0x3fdc62678d0e0cc8,
    0xbf93950f04a9e556, 0xbfdf1073d38df21c,
    0xbfe9f130e92c31e0, 0xbfe25c96ee711f16,
    0xbf92c5667c1aaad4, 0x3fe124f09cf1a619,
    0x3fe859ba7e9bd76a, 0x3fdd380217101416,
    0xbf9ad2cca773fdcb, 0xbfdfd3f08b65f3b5,
    0xbfe57c33841ebee4, 0xbfe13c65f7e0ba5c,
    0xbfb104c5b143399d, 0x3fe0da44d4a2a3f7,
    0x3fe784a9b532864a, 0x3fdefa0aeb246c83,
    0xbfa50206d1580782, 0xbfdceb7bd1d1fa70,
    0xbfe474b5fe24d034, 0xbfde64790895449c,
    0x3fa8f66d9d154455, 0x3fdb509eec7972d2,
    0x3fe5b1eed5b8a984, 0x3fe021017294a7a7,
    0x3fa8ce4a8d6c2725, 0xbfde70637a830ea5,
    0xbfe4cd3ac5798a80, 0xbfe165d6d4574434,
    0xbfa1831d89c14ede, 0x3fdd733c75b034c0,
    0x3fe540361db47fdb, 0x3fded5fbac88c7c0,
    0x3fa24feb66565bc1, 0xbfe0cb3f7397069f,
    0xbfe5d5d492c89b0a, 0xbfdcfd577668b700,
    0x3f95f94bb879ac67, 0x3fdbeff897cf1d18,
    0x3fe56d8d51d194c6, 0x3fdde77dc004b9de,
    0x3f9459aa6221d4c8, 0xbfe0845714d7360a,
    0xbfe58ca82144c8f5, 0xbfdfaba3c51ae250,
    0xbfb419c76d7bdb72, 0x3fe17b037d98f74e,
    0x3fe553455a71277d, 0x3fe0baaaf5c29137,
    0x3f98df68703b6dd9, 0xbfe09b4b3bfd12cf,
    0xbfe7f3f3ca294dd0, 0xbfe250671a9319ec,
    0xbf98c4be4d47eae7, 0x3fdd8fa5cdef261e,
    0x3fe49259265b2248, 0x3fe28710e1897245,
    0x3fb34cc74ba6c8ab, 0xbfe0b4e152669d6a,
    0xbfe29a85f4fdf373, 0xbfdeb57978773023,
    0xbfa13e36e8a309c8, 0x3fe1c0476f38c23e,
    0x3fea668417576ccc, 0x3fe089ac7a924ba5,
    0x3fa549b0b31a1e40, 0xbfe0a58c8c9e9e11,
    0xbfe6cdb7af712d32, 0xbfe198d2bcab5912,
    0xbfa12cebb03af149, 0x3fdcf913cd8fd66c,
    0x3fe71b66d86e1a43, 0x3fde2209cf3ec507,
    0xbf72e5a07275a810, 0xbfe12425a1236268,
    0xbfe95f2afe4258ee, 0xbfe1b65c6a54b470,
    0xbfa8ad370367ae9f, 0x3fe070bb8ac95f57,
    0x3fe49becff0032cf, 0x3fe01f8e1e40168a,
    0xbf3deb74937ea945, 0xbfdb89ce3e1ef4f0,
    0xbfe4ccdbd503d416, 0xbfe147dfa376e13f,
    0x3fb55d33e7ba6987, 0x3fe01ddbc766dd73,
    0x3fe9634981ff02b0, 0x3fdf85665864200e,
    0x3f9b8fdfcb4908e1, 0xbfde58a216662fc7,
    0xbfe6b145d9951ff5, 0xbfe13a255855875e,
    0x3face7913457a693, 0x3fde54df346e4a16,
    0x3fe5b0a63b9f82db, 0x3fdcd227269739a1,
    0xbfac1299a6595c36, 0xbfdb3d1815bad253,
    0xbfe639f089718c79, 0xbfe045e078bffddb,
    0x3fa55dba7bd694e0, 0x3fe12068eb59b452,
    0x3fe84d7eb57df73a, 0x3fdbfd8a4300e926,
    0xbfa98d0e8d5d0ea3, 0xbfdfb8f33475d6d0,
    0xbfe689881a5c4174, 0xbfdf5fcb02db5e3e,
    0x3faa7668d227c84d, 0x3fe24aa63aff4a6c,
    0x3fe620c9f20118a6, 0x3fe07b60b6ad2cfb,
    0xbfb16b6bce6ef111, 0xbfe1e42113dda396,
    0xbfe26993cdfd4f26, 0xbfdf829fc419047b,
    0x3fa7ceb02c8beee9, 0x3fde3ba577bbd07a,
    0x3fe70faa91f78872, 0x3fded01acc60a185,
    0xbfa0b52769b9d320, 0xbfdc8523340f1326,
    0xbfe8f0260ca18a78, 0xbfe1b8ce718f109c,
    0x3f6c5fb59a44b991, 0x3fdc518c308f2693,
    0x3fe74fbe6da210a4, 0x3fde838ce4fc6cb6,
    0x3f71b7d1b78135bf, 0xbfe0e791258e5cf1,
    0xbfe5407c921c75f0, 0xbfdd1ea1e91b4562,
    0xbfb33f2c371b0b6a, 0x3fd8f2a5de9ee2ea,
    0x3fe77bf9184c2539, 0x3fdfa58839893863,
    0xbf37ea6656ab3be6, 0xbfe19bcf53a7d674,
    0xbfe57d2fea956436, 0xbfdd637e178d659e,
    0xbf9de3a84dafb225, 0x3fdfb22d6155c819,
    0x3fe6c6f29e5d2879, 0x3fdec29270462b57,
    0x3fc30b876e43ded5, 0xbfe475e0d33f399b,
    0xbfe7f233828649f9, 0xbfe0394602fdbbcd,
    0xbf9d03d3dbe73de7, 0x3fe1a11975fc91e3,
    0x3fe7c00a1199de37, 0x3fdf343e6ada2653,
    0xbf7017342f98955b, 0xbfdbbb939b9e9100,
    0xbfe66a9006bffae2, 0xbfe201a492c414d7,
    0x3f50290d68eaec95, 0x3fe2e5211cbaead3,
    0x3fea06d810db322c, 0x3fe209a8ecafb9c3,
    0x3fad32dac70f12a7, 0xbfdddfa669df1530,
    0xbfe56762558382a9, 0xbfdf15eba44081ea,
    0x3f922b29cfb81cea, 0x3fdc37f8c01ba4f2,
    0x3fe851c963ae3bdb, 0x3fe041cf63e2741a,
    0x3fb30d493ff1b14c, 0xbfdf472af4823c7c,
    0xbfe7d86ef52dc104, 0xbfe0071bec66121e,
    0xbfaa065dcb3a00ac, 0x3fdfbaed681d9e96,
    0x3fe5f91a5d21d4e4, 0x3fde58493c4ec719,
    0xbfb75b81f7b94041, 0xbfe09a122402b82f,
    0xbfe44a87c2b0270d, 0xbfdba4a2512dba8a,
    0x3fa46b52d07c2256, 0x3fdf657fa0eb7bff,
    0x3fe5b180c3ce16e2, 0x3fdfc52e4e827774,
    0xbfa27bd481f00646, 0xbfe09ea500f58ab7,
    0xbfe52488cb838bd3, 0xbfd9ed100a10d3a6,
    0xbfa18a848e4c40b7, 0x3fdea0f56bd8d920,
    0x3fe82c7e6d4e8c8f, 0x3fe1564f5eb45592,
    0x3f97052b99cfc704, 0xbfdd97a4b345b111,
    0xbfe4887eac561617, 0xbfe08b6c0a790f3e,
    0x3fb1668cea3f8718, 0x3fdd037afdeed608,
    0x3fe7f15c52c02741, 0x3fdc2c5976989b4f,
    0x3f905789527a8c8c, 0xbfe322a1226b8422,
    0xbfe5d54d9b7dae56, 0xbfdeb63377fd9e42,
    0x3f9446ba6b61e190, 0x3fe3748661c97a5c,
    0x3fe5f22b314e3c01, 0x3fdd71bc96e99321,
    0xbf4b8dd206c81d34, 0xbfe05fb9fbd7d374,
    0xbfe69f1872d2db26, 0xbfda3554f7491ec7,
    0xbf9cf06cae71210b, 0x3fde835a8fe9bb14,
    0x3fe4d05695d1261a, 0x3fdf93638c5e6f75,
    0xbfa8552988b369c8, 0xbfe0ee11cb02b200,
    0xbfea9a4987706dbe, 0xbfdd85238d7f41b3,
    0xbf840139a2a7bb51, 0x3fe12fc5e0c7167e,
    0x3fe61ff3a825107a, 0x3fdec4c2da2bcf4b,
    0x3fa11acfaa4b5987, 0xbfe0dbfcfe656de5,
    0xbfe663b7b21f1c7e, 0xbfdfa21b6b70e492,
    0xbfa9c55a229cd521, 0x3fde851212eeb951,
    0x3fe839e7ecab6e72, 0x3fe07118611840d6,
    0x3fb6b781c1c48830, 0xbfde74c481d612bf,
    0xbfe59d8cc236fba0, 0xbfe115d10a79711c,
    0x3f953a69fa0f1503, 0x3fdec5df40e66aa3,
    0x3fe54d3a7a5aeebd, 0x3fdc00e5f8f0ca49,
    0x3fa9f48188f732bb, 0xbfda9dce05e8dcfb,
    0xbfe45c831ce396f4, 0xbfde37323390892d,
    0xbf94f80f4cdf41e1, 0x3fdfbd2fc6579949,
    0x3fe54a218a145293, 0x3fdc5fe1548ac378,
    0x3f8fae5462167cb2, 0xbfdcfbe7b1335a81,
    0xbfe70ae5a0a3ce47, 0xbfe1961b4d70861c,
    0xbf9074377707670c, 0x3fe2671fe4d0108e,
    0x3fe5870704ce754f, 0x3fe0c4b1dbf5dce6,
    0x3fba0ab9ba47fdaf, 0xbfde8c5a5823d638,
    0xbfe6204ca73d7458, 0xbfe1816b6c2482f0,
    0x3fa856945a7c428d, 0x3fdd59cd485c92c9,
    0x3fe5ec28f9c078b4, 0x3fe0bb513c89fb3a,
    0x3fa979108f26d4db, 0xbfe10c70ad53067b,
    0xbfe67a0efbb613e6, 0xbfdf01ecb49c5e60,
    0x3f98c64e45c42d89, 0x3fdb995744ed6d66,
    0x3fe5e78cffe79ab7, 0x3fe19583eab1e15d,
    0x3fb01b70e59a856a, 0xbfe29e9f0a69a81a,
    0xbfe83bb3f95232c4, 0xbfd982fe310eb353,
    0xbfb21b11aa6713c3, 0x3fe1361afe10f721,
    0x3fe4441d5bcb9847, 0x3fdc7c244355acb1,
    0x3f7bcc3b6ae3a57a, 0xbfdcb59b6394de88,
    0xbfe698ed148d57a4, 0xbfe14e0a986c58f0,
    0xbf93cc29ca94fd4a, 0x3fe1c64e8beabee8,
    0x3fe7979dd58389bb, 0x3fddeb9a21045a0a,
    0x3facc4d7bb698a08, 0xbfe0b052712e3023,
    0xbfe374043fbbfc04, 0xbfe322a90638a346,
    0x3fae6509719e720c, 0x3fdbe68c514b4fd1,
    0x3fe83e69d3f4ea51, 0x3fde7493287792ec,
    0x3f9fa33a1e839c35, 0xbfe297a5b1672f51,
    0xbfe6b561f94763f7, 0xbfde6664c30d57b1,
    0x3f90d5d5d48830b7, 0x3fe29603b9d59ae7,
    0x3fe3cfaa72779420, 0x3fdf363a5332e35a,
    0xbfb3a1a922ae1612, 0xbfde105e646c277d,
    0xbfe77366b2e31eaa, 0xbfe1e9f6af62bc64,
    0x3f9b571bdd0fe549, 0x3fdd55c915ac4eb4,
    0x3fe7069dc9437c1e, 0x3fdeed129b63b6d3,
    0x3f927085670ae943, 0xbfe059036fbad7f4,
    0xbfe5bffc6448b29b, 0xbfdcf31ff3034d62,
    0xbfa004ee426710b4, 0x3fddd245d8bc10e1,
    0x3fe58f7aa45588f5, 0x3fe157d64cdf2764,
    0xbf7dbf4c7d5eda4f, 0xbfdeb71c85974ef5,
    0xbfe795b676d9d511, 0xbfe2e307890d98d3,
    0xbfb199613786121b, 0x3fdd57a862f46564,
    0x3fe656c5236474e7, 0x3fde48babb5256df,
    0xbfa2fcfaa3a65a7e, 0xbfe27d21e5f9b95d,
    0xbfe89f8b16f1ade6, 0xbfe14ddde115da1f,
    0xbfa0c6b15b3c33c3, 0x3fdda79e3ae73d77,
    0x3fe2f47e02fa0a9a, 0x3fe21ebdb04b5733,
    0xbf669241b841b52d, 0xbfdef909ebe5e888,
    0xbfe6f31d05effdf9, 0xbfe0d92c5e3f2315,
    0xbf71d9c84e7a5d0f, 0x3fde3f53842b9b40,
    0x3fe9979fc42733be, 0x3fdef7933dd37b7e,
    0xbfb5f5d0b2d7dad3, 0xbfe0b25a92c0ca6d,
    0xbfe7b0ba847b7add, 0xbfe1a486ced581f7,
    0x3f8e08d53bacc7fb, 0x3fda788a88f50f92,
    0x3fe48a612d09d55b, 0x3fe0d3dfe3326ef5,
    0xbf56bc1efb8a0a90, 0xbfe02918b6daff24,
    0xbfe6d8c06502cb8b, 0xbfdfb8bc1cce644c,
    0x3f72e92c943098b5, 0x3fdef00307744674,
    0x3fe4a0527b0c76bb, 0x3fde4ae938351562,
    0x3faf0d6a9af88c12, 0xbfdd706aebe0e80b,
    0xbfe50acf9ad8c0eb, 0xbfdea61e850c1e71,
    0xbf760823ed791544, 0x3fdd843e85a19de2,
    0x3fe59a508a2c2e8a, 0x3fe07a3e69f66b3c,
    0x3f6150c9e15cb28f, 0xbfe284843f0509c0,
    0xbfe46263947349ca, 0xbfdde7eddbcf4195,
    0x3fa0eff0102278e1, 0x3fdf8b93a17a94db,
    0x3fe71d7af9345524, 0x3fdec73c4900c1e3,
    0xbfb2b4aadc250016, 0xbfdd1f1429094d2d,
    0xbfe6520c5e4b671b, 0xbfdccab787cd4b8f,
    0x3fa2228f89b59627, 0x3fe1125b1fd7bc1a,
    0x3fe87d2212644da8, 0x3fe219aa54363057,
    0x3fa0d5daa32bdeb0, 0xbfe0634e63320105,
    0xbfe608930bee236e, 0xbfdedfd8e8989969,
    0x3fa1c305e669503d, 0x3fdd208d281022c0,
    0x3fe71cf230634722, 0x3fdf30440a2fe252,
    0xbf831fa3047f7a56, 0xbfe1dbce06f371de,
    0xbfe6d78cac260d92, 0xbfde93cbb859e327,
    0xbfa70a61ca184e52, 0x3fde39b61a491471,
    0x3fe759b84e79ade3, 0x3fddfb5aa65a6f60,
    0xbf99155211523441, 0xbfdd9f81b28f5b98,
    0xbfe7e9505c16fbc6, 0xbfe0218ece8609b9,
    0x3f462acd687fa36d, 0x3fdf3662a1e90b4e,
    0x3fe7ab2b4bc7572f, 0x3fdb93c1f6bd3dbe,
    0xbf74ab930eb69a3f, 0xbfdf7c6fcc94f6c3,
    0xbfe714935204ddf9, 0xbfda0bbf516cf7ad,
    0xbf89ee22f70cac44, 0x3fe20bbac661d9d3,
    0x3fe652cef25f3522, 0x3fe1389540893aa1,
    0x3fa00169c9e3c1ec, 0xbfe0dff408cd4616,
    0xbfe55f615d3db495, 0xbfdc6cdca85d7bbc,
    0xbf603d587fe7bed9, 0x3fdd1d05dfb3cb63,
    0x3fe816b0d65565a2, 0x3fd8d4cf5c51b9ba,
    0x3f94b7bac323ab64, 0xbfd9bea251eeb025,
    0xbfe76011900f344c, 0xbfdfc98bd7056e4a,
    0x3f92af92736a4311, 0x3fdf9ebfac1afad3,
    0x3fe89f91350c145f, 0x3fe19a36675197ea,
    0xbf87aac4c474a0da, 0xbfdd3c13f9be81d0,
    0xbfe5e80d17902c82, 0xbfe17308ae1c64d7,
    0x3fb2c1953c24ec8d, 0x3fe122955c700530,
    0x3fe4313f58cdf843, 0x3fe0a731013f91d9,
    0x3fa05ef5a503d7cb, 0xbfe094a438a25084,
    0xbfe893a83956ea96, 0xbfe11802056acedf,
    0x3f919366b23b855d, 0x3fdff64b53a9a5f3,
    0x3fe52f95b4352bc5, 0x3fdc68dafd52f336,
    0x3fa6f59b5d06fdd4, 0xbfdf40d27e6bc01b,
    0xbfe6d6b0c1c55db4, 0xbfe050d88f2adcf1,
    0x3fa1b737c15ad869, 0x3fe1a799b5a8f756,
    0x3fe428363a7be976, 0x3fdbf9826ba6edc1,
    0xbfa957ca622f9001, 0xbfe0e8a16b1f6abf,
    0xbfe591bec8c5a0b4, 0xbfe101ec8459c2d6,
    0x3fa77af2b3313da7, 0x3fde7ebcc5f16c76,
    0x3fe4260155cde1ca, 0x3fe32b063a1ef20b,
    0x3f72032d5a3634d8, 0xbfdfd795a4fa8060,
    0xbfe5eae1116e4702, 0xbfd950d882a36f90,
    0xbfa9d3c8acda0838, 0x3fe020fbc55f02c9,
    0x3fe4d8b5eae22bff, 0x3fde65289be55c0f,
    0x3fb312288ffdb8ea, 0xbfe199ffe18c5503,
    0xbfe4b168cd14eeb7, 0xbfdf061cbfcea7b2,
    0x3f8425e225da56f6, 0x3fdd43d8a66ce730,
    0x3fe585f4211a30f9, 0x3fde2ceb334eb202,
    0xbf9d7833af3ee569, 0xbfe175034d984d0d,
    0xbfe5a88a162ab9d2, 0xbfe0902251e7585f,
    0xbfb8f4eb733cd931, 0x3fe06882985dc471,
    0x3fe9aeb9ab2360a9, 0x3fe1446ae316eb83,
    0xbf92e03234ceb67d, 0xbfe1a4178ee36bf9,
    0xbfe8027b1d17d48f, 0xbfddceb8d85bf9c2,
    0x3fb178008d6a73f5, 0x3fe0cae626244dfa,
    0x3fe5c6ec786587b7, 0x3fe29e26bfed974f,
    0x3fa5970d7f97c734, 0xbfdeb85c635cad44,
    0xbfe3fb4944d4bab7, 0xbfe09db5ba5aafc0,
    0xbf5f72c2f496e70d, 0x3fe26593e3317ec8,
    0x3fe6da96bf00333c, 0x3fdd475ca80f8ad6,
    0xbf8b862590a085be, 0xbfe0bedfd7b9baad,
    0xbfe5b9031b61fb61, 0xbfdb7a6e5df6c6db,
    0x3fa7bf667cebdcb2, 0x3fdbc59e6b1d63c2,
    0x3fe41b9924cf4325, 0x3fdf2d7f8ac42d5c,
    0xbfaec931d081ae2e, 0xbfded9ec56cf44c7,
    0xbfe4edc29853dcdd, 0xbfe1f002a51d8f66,
    0xbf7521d8fc1579ca, 0x3fe0842ee9f01552,
    0x3fe74e0c39c02f32, 0x3fda0f63acbf498f,
    0xbfc1edc5658c087f, 0xbfde6faa4ecab249,
    0xbfe56059c567dfd8, 0xbfe3185eb47e5471,
    0x3fb865de49c63869, 0x3fdc48db62f3daba,
    0x3fe5208755683d26, 0x3fe036d464010c61,
    0xbfa5e1815768eebb, 0xbfde728daeabf33b,
    0xbfe6dedc6f596042, 0xbfe014893f6432f2,
    0xbf9924ea3abd0973, 0x3fe28325e75aa18b,
    0x3fe3d6f1495cad03, 0x3fe13af5385dd151,
    0x3f94d6d06e8cf268, 0xbfdf33531bf199c2,
    0xbfe62d0badfe117f, 0xbfe088c4be8c4458,
    0xbfaebea506c3626f, 0x3fd9ecba80b0e546,
    0x3fe9a77b04d86e02, 0x3fdc0356fb628f12,
    0x3f850274da572b51, 0xbfdeda6850c092e8,
    0xbfe4dbf449f1f1a9, 0xbfd9d8dbf0b4d231,
    0x3fa7e4ccd106fc31, 0x3fe12098667e7562,
    0x3fe731381c4ad573, 0x3fdeb530b71513e4,
    0x3f8a146186a28dc9, 0xbfe03d5ae02e1133,
    0xbfe55393869b46f2, 0xbfe0755ae9483371,
    0xbfb32a8e864658b7, 0x3fdec4a448aa6e58,
    0x3fe471d6e4d00f9c, 0x3fdee85a250f6ab2,
    0xbf9891bb9775fd50, 0xbfdd7f9b881af11a,
    0xbfe5023dd8489a4c, 0xbfdbc0cbcd4f2d58,
    0xbfa8ede74f6588a7, 0x3fdf516fe00aed4b,
    0x3fe898cb1a9fcd4c, 0x3fdaa53658a2670e,
    0x3fb0c7ec80cb2b44, 0xbfdefa43b6dad98a,
    0xbfe80d49069642d5, 0xbfddacf33311c50f,
    0x3f9291d185940cf9, 0x3fdf94879965a8cc,
    0x3fe772a5d6c95180, 0x3fdde04d5d27be90,
    0xbfaf4b46e987a44a, 0xbfde325d1c93b3b9,
    0xbfe9cf4bf8740ee1, 0xbfda7dfef14aa4fd,
    0xbfa19f31602bc6d8, 0x3fe10118653332e3,
    0x3fe4af33d84b22c5, 0x3fdef78aa031aeee,
    0xbf7bd53425c0b290, 0xbfe0bdd18ca64b84,
    0xbfe6dc7f4cfd0154, 0xbfdf4778673b649d,
    0xbfbbc01cb6258dda, 0x3fd9cb52632ce919,
    0x3fe61e9fe01520b0, 0x3fdf24b49c0c3167,
    0x3f95b2c75e6cb5aa, 0xbfd8d3f849d90fbb,
    0xbfe69b81466dfe8c, 0xbfe0af2467245c3f,
    0x3f945737d7337831, 0x3fdb16d2a4c17e8a,
    0x3fe536ccdf5fe5a8, 0x3fdfabc1d214b94f,
    0xbfa7e59d44afa641, 0xbfdd67fbb3bd2dae,
    0xbfe79ea363d9b982, 0xbfe07acb7c61e791,
    0xbfa20f93ea4033d9, 0x3fdfc8d7058d4ecd,
    0x3fe7f5fdf4ecb226, 0x3fe08273e7f70999,
    0x3fa50d02badd77a9, 0xbfe01b9b6556071e,
    0xbfe5b83a81cdb81a, 0xbfdecc22363b0726,
    0x3fb02115fb3ca1e7, 0x3fe0a629d9e0abb5,
    0x3fe6bfedd032f668, 0x3fdf5353db70c726,
    0xbfb33eda0aa4a509, 0xbfe07630e441d68d,
    0xbfe35da675feea9e, 0xbfd8eb42e59688c0,
    0xbfa58c62801123b7, 0x3fde2a1fff6f3752,
    0x3fe87d237570c02f, 0x3fe219130e6d549f,
    0x3f879e15e700b681, 0xbfe21ee9fede0b0a,
    0xbfe650d1fdd84f25, 0xbfe33181d50f13f8,
    0xbf9a4d20675904ee, 0x3fe157a55120e931,
    0x3fe6ef05ac2fe947, 0x3fdcd1dd84c5b850,
    0x3fb71d5aac4c8695, 0xbfde2c7cad7aca6a,
    0xbfe6f9a3a33044bd, 0xbfe0217407ece6ed,
    0xbf9d7f1fc2ba231f, 0x3fddee9b3a61e90a,
    0x3fe5a4bd39caf55b, 0x3fe1001a0a587b06,
    0xbf969c188f577478, 0xbfe107da3d12e6d2,
    0xbfe65c25d1a2f2da, 0xbfd911d28d74637c,
    0xbfa2d902911eee13, 0x3fe0ef7deacc5575,
    0x3fe634e457e42c5b, 0x3fe1ead6c130a23a,
    0xbf93ac8c2abf4375, 0xbfddc543e3b08e28,
    0xbfe536400460aae6, 0xbfd9fcf6d4555f3a,
    0xbfb880367b237896, 0x3fdeb1d58e2543d9,
    0x3fe585daedac55fb, 0x3fe26cf8def9eeb4,
    0xbf9d3f1fd97a47e9, 0xbfe16496a3763ebe,
    0xbfe3403996a63a6b, 0xbfddab04375ed486,
    0x3fa0e47fa9a87b2f, 0x3fda367b26177564,
    0x3fe66e4f8b339fee, 0x3fdea6fad741b708,
    0x3f9a78fd24411409, 0xbfe0d2f7b1170216,
    0xbfe750c85ea4fd81, 0xbfe109c373e813a9,
    0x3fa2f473dbc42f4d, 0x3fdf383895ef396c,
    0x3fe9e26dab5d0cd5, 0x3fdfe9c78819fac6,
    0xbf91bd7e81aaec46, 0xbfe040b56969bf7e,
    0xbfe775b29428d55c, 0xbfe021a249ad3dac,
    0xbfab5f7be9ad5d34, 0x3fdb5e9c40c2e5e9,
    0x3fe6efc4453eee21, 0x3fe0a3db456fba91,
    0xbf72cbd051acc6ba, 0xbfdbcd0cfc85a52b,
    0xbfe5bc9d6bd64454, 0xbfdeb42fecbb7316,
    0xbfa63a6902110475, 0x3fdaabc08e679caa,
    0x3fe6f0856ba0e143, 0x3fe1bd2724cc4dd7,
    0xbfa068c7deb2975f, 0xbfdd1225aec87f43,
    0xbfe80cf1097384ad, 0xbfdf7479403e9d9d,
    0xbfa725063f194652, 0x3fe05fa4d6ba76f1,
    0x3fe5b63d24382024, 0x3fe027885ca9538f,
    0x3f90a75c8968a6f9, 0xbfdbcf0105be8954,
    0xbfe3f925b79943d1, 0xbfdd8e8d2d6627e8,
    0x3fa71d01a27e5778, 0x3fdc4491019f5986,
    0x3fe3549950eb4546, 0x3fdb4c1ad0447e47,
    0x3f726a43abb9d446, 0xbfe2ff93f0ce0450,
    0xbfe5b22cd59ed2ca, 0xbfe168b150680d9f,
    0xbfab1c3398c11a0f, 0x3fe1bfd3677fd988,
    0x3fe7bd25ab05a832, 0x3fdd88fc49accd12,
    0xbfb0e83ab6c8e4ee, 0xbfde5e7de5f257af,
    0xbfe767e45e900026, 0xbfdfe08b1b7249d2,
    0x3fbae709cab71793, 0x3fdf9145b75f2e40,
    0x3fe9ffa61c8c437c, 0x3fe11afd94ace3fc,
    0x3f8da035441638a4, 0xbfde423ca5b0418d,
    0xbfe4ef736047e393, 0xbfe15212445d6068,
    0x3f7af71363658945, 0x3fe0072fc28548b4,
    0x3fe780ed399af7da, 0x3fe1fae286b0dae6,
    0x3fa5149cc68ac50b, 0xbfe039cd20963442,
    0xbfe75484aee0a154, 0xbfdfd9462511d60d,
    0x3f77e8c16e336905, 0x3fdd7a8891238176,
    0x3fe8a93878c4d7ab, 0x3fdf62c8cbc413db,
    0x3fb126812ea01a05, 0xbfe321e42218820f,
    0xbfe5dd284c225304, 0xbfdebfc7514489ff,
    0xbf9ca854dbdd83d4, 0x3fe2225a1f5c3bfe,
    0x3fe583c8655f34f7, 0x3fe152b55ae13599,
    0x3f88d3e4108e47a4, 0xbfdecd711cca9cb3,
    0xbfe4eccf91df0997, 0xbfe0d73466ecc660,
    0xbf98e252926eea2d, 0x3fe0c2f5b0c0ea14,
    0x3fe44106f393e1d6, 0x3fdf34c775c1e9da,
    0x3f8f9a4d4c628110, 0xbfe007c2301ebacb,
    0xbfe4f85425ff6544, 0xbfe26d12fd431919,
    0xbfce4c88c4a2f605, 0x3fe1df2a81afbaf8,
    0x3fe3bed9af6180d6, 0x3fe11e233dd3990f,
    0x3fbfbba6ec39a679, 0xbfe122d38e253ae8,
    0xbfe3ff99089e1079, 0xbfe1af079b6ed57c,
    0xbf857716094fcc12, 0x3fdaf1e8600ad428,
    0x3fe5d3390ff3154d, 0x3fde386b55b2d692,
    0xbf98fb250aaace25, 0xbfdd1b87c024fb87,
    0xbfe7a57057170d09, 0xbfdb4058301c00ac,
    0x3fadfdd6afce4106, 0x3fe2390f1ef7144e,
    0x3fe525462931c37d, 0x3fe080b6fe8e9db1,
    0xbfb704653eb7875e, 0xbfde4afc02738f17,
    0xbfe62b53ce379928, 0xbfd5e3a58fc7b3b8,
    0xbf959ac5f3700bd6, 0x3fdc4920c97fae94,
    0x3fe5a0c88d4b2363, 0x3fddb861e371f145,
    0xbf692a80415c4195, 0xbfe03ebcb42c499f,
    0xbfe51b75d0bb73c1, 0xbfdffc150399695a,
    0x3fa6904ab531d5b5, 0x3fdeece62b043e9b,
    0x3fe5a29865a0b958, 0x3fe0dcc71983409a,
    0xbf76890a405d5437, 0xbfdfe0a74881384e,
    0xbfe6b9638bbc9a30, 0xbfde817de74f3e09,
    0xbfa0a6f04f3db7e3, 0x3fde2d0fb3c19d38,
    0x3fe6ee91339ce6fe, 0x3fe22f66d135a4a7,
    0xbf938c35cb50fd5b, 0xbfde55e3f6341951,
    0xbfe582a61854a192, 0xbfe0e08a2666e803,
    0xbf9fcca6525323a8, 0x3fdfbbe08758e6e9,
    0x3fe45260a21f1dbf, 0x3fe0debb9c2e42a7,
    0xbf72a372d4f8d71a, 0xbfded6a758ca8afb,
    0xbfe67676f9ed8f2b, 0xbfd9370b72ca232a,
    0xbfa92ded20533cb7, 0x3fdf4d47e2e98621,
    0x3fe7bcce888bdc64, 0x3fe077283e1bc6ff,
    0xbf83caa1cb347800, 0xbfde00546b32d7a3,
    0xbfe5cfca9f67a2d0, 0xbfde9a35cc65949f,
    0xbfae13092aa3ac43, 0x3fdedd2cb6180d5f,
    0x3fe7f474bd961a3a, 0x3fdd642ccde2714c,
    0xbfbdb87aae197d66, 0xbfda3019327e4cfc,
    0xbfe67b308f27a3eb, 0xbfe000c2662e10fd,
    0xbfaef2c29dc9b95e, 0x3fdc3aeb6625ef4d,
    0x3fe2cecd4504737f, 0x3fe17eba890fce64,
    0xbfb8596cb475c4f9, 0xbfe1a5c5de199cad,
    0xbfe6c6b50de712ed, 0xbfe292ae2d6226e5,
    0xbfa9ab16f5b338c7, 0x3fdd17181d048de5,
    0x3fe4e27c4f5c414e, 0x3fdf1b10164c18a5,
    0x3f586dda62d18ccd, 0xbfdef459617264c7,
    0xbfe4ceef1c38c6a3, 0xbfe0fee7fa38880d,
    0x3facc9648a746a08, 0x3fdc3a37d6a82a1e,
    0x3fe9d5fdfae4af9e, 0x3fdcf9c5cf6d9b05,
    0xbf9942222c223cef, 0xbfdd9d0ed883884f,
    0xbfe65866ddaec2db, 0xbfe004f187b554ab,
    0xbf9596a8942d33dd, 0x3fe1c5eb3b003b68,
    0x3fe7d3a10a1c8e70, 0x3fe09d0c923a2e99,
    0xbfa657b4e582152a, 0xbfdf4969d747a994,
    0xbfe5871e84fb277b, 0xbfe24b9d4f70d5ed,
    0x3fae66abee4490ec, 0x3fe10be021dbe2d1,
    0x3feab4df943a28bc, 0x3fdd1545632f1dda,
    0xbfaa53418e47dc4f, 0xbfddf67c6a55d12a,
    0xbfe6745c1ae04a24, 0xbfdceeeb5927777a,
    0x3fa53fc066834a71, 0x3fddd4934f9684b2,
    0x3fe6e3d99285d34b, 0x3fdcfa25c08b7826,
    0xbfa5aa440055e34c, 0xbfdbc2b7d5c10c4f,
    0xbfe5fb1b9271d308, 0xbfe0de8791be6c71,
    0xbfa48fcfb1f2a834, 0x3fdc2f93f81d9182,
    0x3fe7482edc0bdfe4, 0x3fe0cf6a87ce5994,
    0x3f9261d10e86e2f6, 0xbfdb9943cfb0a2d2,
    0xbfe8f13f394a23b6, 0xbfdbffa957532ca6,
    0xbfbad03ff21b8f4f, 0x3fdf051c072a4d55,
    0x3fe3fb5e0f3580cc, 0x3fdf18098f243588,
    0x3fb4853117f11978, 0xbfd79ec8ca42bdaa,
    0xbfe71f0183477e14, 0xbfe057a8441476de,
    0xbfa07255e6c500ee, 0x3fdbdcc4ff8320af,
    0x3fe3fd2732333d25, 0x3fdae198b36e43f6,
    0x3fa428db7a8be1c2, 0xbfde6434d3874c75,
    0xbfe5e6ebbbdf1332, 0xbfdcb1949fe79a5c,
    0x3fb3ad02b5b8158f, 0x3fe086d98d4a729f,
    0x3fe51ce5912d484e, 0x3fe262731ee5d5a2,
    0x3f97e7adf939896b, 0xbfdebb73118fe91c,
    0xbfe6f96a2b148233, 0xbfdd5dfe9f0c0512,
    0xbf8556b28cb7b56f, 0x3fda6d69cda2d712,
    0x3fe4ebbdaa67ff4b, 0x3fe27d9a620e1e73,
    0x3f9bf46ce1f0bad8, 0xbfe046c58b90dca0,
    0xbfe66820e3097ca1, 0xbfe2d07e27f5ebbd,
    0xbfaa2cb6b7d7ef69, 0x3fdbce7c837259b6,
    0x3fe7780a9c3a2149, 0x3fe2bf4a6fb17c7e,
    0xbf94efd9115b389a, 0xbfda3cbd3648c87e,
    0xbfe97b1527eb4579, 0xbfdcf7ddbf829cb2,
    0x3fa9ece58622aac7, 0x3fdc4b79c81b0777,
    0x3fe602fca2e17a31, 0x3fdf1d00f1ea3185,
    0x3fa50275d3c87c13, 0xbfda4f1a361140da,
    0xbfe7e4193ca0fbe9, 0xbfdce85830a676f6,
    0x3fa635b830aa6219, 0x3fe27f56afd73fd5,
    0x3fe578ee378ca328, 0x3fe162fecdfa480d,
    0xbfa12279663a7900, 0xbfdbcb9afe0c21da,
    0xbfe58bceb5bafe2a, 0xbfe102280ae324e3,
    0xbf876fd7cb682a04, 0x3fdf3f5b8978e54c,
    0x3fe699f94748c672, 0x3fddd5ed574a1fce,
    0x3f7eea4fe59858cb, 0xbfe1c781ba57a6ef,
    0xbfe4b7ce215fdbd4, 0xbfda6b3d86378228,
    0x3f972efbdd4a5c48, 0x3fdfe1e58582c2a3,
    0x3fe4831c23086c64, 0x3fdd966846649d45,
    0x3fa0e63ec1f354fb, 0xbfe143f3aac4e3a2,
    0xbfe6fcaad02a09b5, 0xbfe05c5fe61970d6,
    0xbfa243859993bc05, 0x3fdceb71f40644b4,
    0x3fe7218721075ccb, 0x3fe083cdd2d5e3d6,
    0x3fb800d07a9dffc0, 0xbfdf2ed64ea40348,
    0xbfe6927c4f089136, 0xbfdda95e6c2272b4,
    0xbf889263fc0d6910, 0x3fe0bc5a0751c03d,
    0x3fe83e64a56236cc, 0x3fe0f11c0ec97679,
    0x3fae1c727f7fb90a, 0xbfdff3b614a1f273,
    0xbfe68b14c19715af, 0xbfe0fae272083723,
    0xbf8cadb542541ace, 0x3fdc83c5e526f740,
    0x3fe5764132886b76, 0x3fdda07f5cebf7e7,
    0xbf64bfb212404e1d, 0xbfe0e2385f2d54e2,
    0xbfe71e48bf4e710b, 0xbfdc61d08d7cd088,
    0xbf8242fefe3966eb, 0x3fdcf80c88c8c16a,
    0x3fe5b44bbdb8090f, 0x3fdd66a22e734b96,
    0xbf85b848ed0514cf, 0xbfe3bb64f8b28066,
    0xbfe5e76ea4a152f2, 0xbfdc8ea77d8758f8,
    0xbfab64a77327a3ee, 0x3fdc9a18a1662229,
    0x3fe6e250e6ae1419, 0x3fe0ca2b8397cb08,
    0x3fb0d72e2a8b0d35, 0xbfdff6c4bbb95412,
    0xbfe691826ca627d1, 0xbfdd8e66bcac5a65,
    0x3f94bb31ffa76b71, 0x3fe204ac0caf51ed,
    0x3fe51b5972268609, 0x3fde531e9568be10,
    0xbfb06d6d20f93ba6, 0xbfe0871dac6dae14,
    0xbfe700e3e0cb81ba, 0xbfe04b14920372bf,
    0x3fbc02551bf48985, 0x3fe0e8fb4160b69d,
    0x3fe633089ce154ae, 0x3fdf891b2ce98a3c,
    0xbf9d542dca66717f, 0xbfe0d04db03891c0,
    0xbfe7849310a629c8, 0xbfde0faa8f18f6af,
    0x3f9d64f19ca3916f, 0x3fdd66f34795fdca,
    0x3fe43a7d9419af8e, 0x3fde583062aa0b5b,
    0x3fb9589986d2ab7c, 0xbfdef538d14d289a,
    0xbfe618f8fdc3052b, 0xbfe0d925b04e7414,
    0xbfb1a39b46c5ade5, 0x3fdea3ff9555f427,
    0x3fe579e47fdeee50, 0x3fdc8fc131d1a1cd,
    0xbfb74619bd326cf4, 0xbfe0e684a9e51bdc,
    0xbfe674478ca05802, 0xbfe13726ea5ad5cb,
    0xbfa7f2d67bd33d5e, 0x3fe0f6eebc16449a,
    0x3fe59d973fe8ad91, 0x3fd98967faed4875,
    0x3f954db819fad44f, 0xbfe0ef4c1bf72b10,
    0xbfe70b1ea5a66a90, 0xbfdc32fc84304f66,
    0xbfa7b2987553783a, 0x3fdc1c160acd1f3f,
    0x3fe68fdaa87fd174, 0x3fe20e283ad1ed2f,
    0x3f5254c240d2af50, 0xbfe0023cb0d48128,
    0xbfe47107c9bbc58e, 0xbfde08b004c6d3f0,
    0xbf9c7d8b3b1a7fef, 0x3fdad6359264fba4,
    0x3fe72ba4e787ef3e, 0x3fdf94d8ccd990a6,
    0xbf9c8c8159fb4a41, 0xbfe0277d07289676,
    0xbfe6364d5339e5c1, 0xbfe107356fd4f7ed,
    0xbfac6948c546d02a, 0x3fe0c97419a398b6,
    0x3fe63d9cba92ed94, 0x3fde7a03f8bb1ec5,
    0x3f857a84950d6491, 0xbfe2cb64dddb2a30,
    0xbfe6ff011cd02dc5, 0xbfe06810b3170699,
    0x3fb42f241f5435e8, 0x3fe01744f45a8943,
    0x3fe5ea012bfd98b8, 0x3fe0ae3a329310b8,
    0xbf68f7e7fdf21eea, 0xbfe003014beae16b,
    0xbfe84e2ce57c8db3, 0xbfe070b061da08a7,
    0x3fa824744c4f4a9a, 0x3fe097a3b0c8bc8e,
    0x3fe60dbebb90ba3c, 0x3fdb07d6a9e15e01,
    0xbfae507bc484ce4b, 0xbfe150d6e4f76982,
    0xbfe85118eb8f0723, 0xbfde35377ff7e4c6,
    0x3fa29df9a39f4757, 0x3fe1a4a522aef22e,
    0x3fe7d731f6a47091, 0x3fdcbaed7c2ec7d1,
    0xbf9002f1770cd3f8, 0xbfdc5aba76817440,
    0xbfe6f4be0a6d15cf, 0xbfdf791c4cd69542,
    0xbfb5567a9fc36e3a, 0x3fdd13727a5a24b0,
    0x3fe4ca4bb55bb535, 0x3fe20c56376283a8,
    0x3fa5c0aff8f4f45c, 0xbfe1855712e5af35,
    0xbfe62dbd2be3b2bc, 0xbfe01c7ced8624ac,
    0x3fb73d7614edd09c, 0x3fdf891e0fea2223,
    0x3fe6c79a5ecbe911, 0x3fe00b508cc03b04,
    0xbf98b65daa21ee54, 0xbfdfebd86e29001a,
    0xbfe69c7d30981c9d, 0xbfdc0e0719cf4903,
    0xbf932cd7da067b02, 0x3fe16be053960913,
    0x3fe5d8021a84dd36, 0x3fe0feec656366d0,
    0x3f9b76c2d7d2d96b, 0xbfd91ce03b0fbb44,
    0xbfe506600fd25f73, 0xbfde684da6f5941d,
    0xbf7020480ffd4bdc, 0x3fda699fd2655041,
    0x3fe7936d153a70ff, 0x3fd8574e86b94aaa,
    0x3f86bbab95449959, 0xbfdc449c8d36051c,
    0xbfe82c3289215b4a, 0xbfdeb109c07ed1bc,
    0x3fa0ebd53d8e35cc, 0x3fdb641d870484e0,
    0x3fe76706251a8019, 0x3fe11fa3ef6c4d70,
    0xbfa7845f1e05ee6c, 0xbfe0fd4b8fba6cc1,
    0xbfe75769a3e6f120, 0xbfe1269401c524cb,
    0x3fbcdcc3c96c9835, 0x3fded3ae8953f2c1,
    0x3fe5655482e6de28, 0x3fde2ee4bd93dcb4,
    0x3fad96c3cfd1c748, 0xbfe12a14c5dbcc1f,
    0xbfe5fc73dbd64941, 0xbfe2be83200f2a68,
    0x3faa4d39c66e53a5, 0x3fdd080c8f3e885c,
    0x3fe547388fcfe564, 0x3fddf44c4d76062d,
    0xbfa171c86ee2776e, 0xbfdc4fe374661949,
    0xbfe52fb5c635bf9f, 0xbfdfe8bf1031e7b9,
    0x3fa395de386168e1, 0x3fe0e7e31f467bf7,
    0x3fe6efcd381198c7, 0x3fe1f4dc9d9b1568,
    0x3fa17e6d81e326a7, 0xbfd90b0140096d02,
    0xbfe657b5250ab18b, 0xbfdd88de1540dd8b,
    0xbfa11cfa7b4a0477, 0x3fe0b4995ec4426e,
    0x3fe7342bfec875bc, 0x3fe306178cbe29da,
    0x3fb3fff41c9ed8d9, 0xbfde29b4c81f682f,
    0xbfe9ee930aa352e3, 0xbfe056798239e09f,
    0xbfb10677eae359d5, 0x3fe0df9de79ae222,
    0x3fe6bfa05ffb9bbe, 0x3fdc6d7a0ae5a008,
    0x3f99427b82f560df, 0xbfe1984b6c9e2ba2,
    0xbfe6550a8c63e762, 0xbfded57fe04809d8,
    0xbfc1287bff631e96, 0x3fddaf72d142df87,
    0x3fe3dc7b4343cfd4, 0x3fdb5354718d695a,
    0x3fb964763f07f16c, 0xbfdeacf4304c1690,
    0xbfe6f5897bfbb1df, 0xbfe292ae25a9de77,
    0xbfa06faccca5de53, 0x3fdb8faad356dab6,
    0x3fe899575308d2cc, 0x3fe1da0de87cf24f,
    0xbfc0ec2535a85ac7, 0xbfdc84f749bddd75,
    0xbfe6a087d69dce6d, 0xbfda3722a5d476b6,
    0xbf77fce9413be5b6, 0x3fdfb452d90ab30b,
    0x3fe4f892dfede68f, 0x3fdfc87ef644426d,
    0xbfb2c4a8fb176c58, 0xbfe340baa571398e,
    0xbfe60472cdc19247, 0xbfe0029a468b68e5,
    0xbfabc7ca929cf33b, 0x3fd8f4f310a4c9c2,
    0x3fe6cc23b5a8b3a8, 0x3fe053736c7f7492,
    0xbf5686d4c1e196be, 0xbfdcaf6753a2930d,
    0xbfe6a74b3a9d88e4, 0xbfdce3b0c018cb41,
    0xbf748d7f31a9f520, 0x3fe0799ed9bc8592,
    0x3fe5595b09ad48fc, 0x3fde323998c7831d,
    0x3fb8278d0b8dcd77, 0xbfdbbed161caee86,
    0xbfe714dc000cfeba, 0xbfe020f72584bdcc,
    0xbf81c9aef984774b, 0x3fe099f6d72073d1,
    0x3fea94c1d44e7702, 0x3fda412a6bb2994e,
    0x3f9b3dd7df83a7aa, 0xbfe122b50da78909,
    0xbfe6410fffc5cea0, 0xbfe015c228e527f6,
    0xbf91d98476cf8c0b, 0x3fe099383d34d202,
    0x3fe6e2df4f224d1a, 0x3fe0e6bf1cfc0624,
    0x3f9e43bc1476db23, 0xbfe06dda4ac06f18,
    0xbfe5a2894117f0bc, 0xbfe064ae95680042,
    0x3f892ec010527bac, 0x3fe04890941fbe20,
    0x3fe5d2eabc275e41, 0x3fdd21af883cd122,
    0xbfb17072663aac13, 0xbfdd07217f8e0b83,
    0xbfe7baef0844337f, 0xbfe18ffe5a00f19d,
    0x3fb24b21957cbbd2, 0x3fe103cd5f4ae707,
    0x3fe566bebe2e67cf, 0x3fdf9dc943ccf6d7,
    0xbfc1f26804a3af66, 0xbfdc453c78118b47,
    0xbfe418b7821fd165, 0xbfdf2cf1e3ea436a,
    0xbf80c048b330ed90, 0x3fda023ba36c2da8,
    0x3fe8095791ec5607, 0x3fe1dad2192ba9f8,
    0x3f9b2d89ece9e288, 0xbfe0227167b363fc,
    0xbfe57f03f3001127, 0xbfdd3ca8f1ce644e,
    0xbf58a3a3bb832a1e, 0x3fdf9fe60587675c,
    0x3fe80cecd749a688, 0x3fe013168ba2b376,
    0x3f7d6de07272775d, 0xbfd9871cb7e14bbe,
    0xbfe6792d4869e059, 0xbfdd3cfbe79ecfd8,
    0xbfb60dff6b0c156e, 0x3fdf02f2175d8853,
    0x3fe4e4b7aabd4840, 0x3fe29b7c9e5537ba,
    0x3fa7680c57a62561, 0xbfdcd9b673f59428,
    0xbfe5d1ab43313fb1, 0xbfd9a3dcad9f8cdb,
    0xbfabe583e5fffb59, 0x3fdd8f8d00677b80,
    0x3fe8000ed8788483, 0x3fe1a43d177ee3c0,
    0x3f924ee856aea06e, 0xbfe096630cbae0e0,
    0xbfe52af50f545b24, 0xbfd9a0c521d88b18,
    0xbf89d4e52b16fac0, 0x3fe0f054993518f0,
    0x3fe60c3ae14a36ac, 0x3fddccab5c0d00c2,
    0x3f71792666d6019a, 0xbfe0d00d070b7189,
    0xbfe9109e1745ff39, 0xbfe0229b40a492e8,
    0x3f9ac14cae186c7b, 0x3fe26816d69d5dc8,
    0x3fe7a4ee7067e634, 0x3fe138e16b5a31b5,
    0x3fb5c7afc62f7373, 0xbfdc5f9ae6d4ae22,
    0xbfe6693b3400160a, 0xbfe1f090e59cde59,
    0xbfa8834026848d31, 0x3fde031c17328561,
    0x3fe76ea66a2d01c7, 0x3fdfa0ec70d91943,
    0x3f9456ad18f738b6, 0xbfdb89b056ccff34,
    0xbfe88924cf2974f6, 0xbfdc26d9c82cf487,
    0xbfa483b95b0d301f, 0x3fdd369afaf46891,
    0x3fe791897f445e4b, 0x3fe0efc8534d8cdb,
    0x3f597cea8a381e9e, 0xbfe0a4d5edff321d,
    0xbfe6a9e1ded9f60f, 0xbfe153ef4032e832,
    0xbfa1d7db939b3332, 0x3fdd1f88d49d7244,
    0x3fe60d8c357693a1, 0x3fdfe1579da8bac0,
    0xbf80caa169d3a29d, 0xbfdf7f8bab82e619,
    0xbfe5f9e8be73f89e, 0xbfdd7373ef0c1720,
    0x3fb79d27b512dc98, 0x3fe112f1893fd331,
    0x3fe791a4fa5dfaf9, 0x3fdfe006cd662b42,
    0x3fa85dc6b9b246b9, 0xbfe0fd663c7da000,
    0xbfe67c0139714c0e, 0xbfe1b651d509b1d5,
    0x3f902033d1a4b15b, 0x3fde8b99c107cc47,
    0x3fe778a2f93fa572, 0x3fe12b87fadb40b3,
    0x3f8c9bd47bf205f4, 0xbfe1f261b2df8f21,
    0xbfe5fb09b7e57f3f, 0xbfdf2476c200ce3b,
    0x3f8b073c14b943a7, 0x3fde38f9ee45591e,
    0x3fe73dac005c02c0, 0x3fe08bbffc7f2844,
    0xbf8d22bb3fe8d4c9, 0xbfe000fefc58c0df,
    0xbfe96e2d37c77049, 0xbfdd0b83309ff309,
    0xbfb2ebc08a7fbe99, 0x3fe1c8e85a60ae30,
    0x3fe7a772295d2e7f, 0x3fda2b9f41eca7d2,
    0x3f97a36d89771819, 0xbfe13c4902472095,
    0xbfe7385c0407bd6a, 0xbfe228bf190f4f25,
    0xbfaad26e825e413b, 0x3fe0108cda683597,
    0x3fe583cd4b56ce2e, 0x3fd8fdfc9c97012a,
    0x3f82314b4a95e847, 0xbfe01f18ff3f2999,
    0xbfe4ad636b513e63, 0xbfdefa80fca441bb,
    0x3eee0b25dd4fb049, 0x3fe0b88293dc2dde,
    0x3fe4731a71402a91, 0x3fde6b0ab6cf97c9,
    0x3fa3a29666cb09b5, 0xbfda3a77dd9e0ac1,
    0xbfe491bc828d3fd5, 0xbfdcb404100cd730,
    0xbf8e4a347b0195fb, 0x3fddc5913ef4fbde,
    0x3fe3629aaf0741b1, 0x3fde97e3647e4793,
    0xbfabab198bb30686, 0xbfdddcf0e2422978,
    0xbfe50a4b9471e5b2, 0xbfddd9b9414f8b53,
    0x3f865d200b3fdf5f, 0x3fe0d6e79edf6674,
    0x3fe6032a3d072ceb, 0x3fde34b208701cf2,
    0xbfa3c61794988c8a, 0xbfe2822fc889e895,
    0xbfe80827ec5e16bc, 0xbfdfeda548b94712,
    0xbf8d2f6760da0ac7, 0x3fe08e3b54cf09f5,
    0x3fe9abb539354f23, 0x3fde60d8c6bd5a62,
    0xbf9eac18924f0db6, 0xbfe000bbb5f080c2,
    0xbfe600e05cc65080, 0xbfdbe25e20dc9a86,
    0xbfb1dff0d49d5913, 0x3fd9fd6107b2b842,
    0x3fe45cd94640add3, 0x3fdd9d7a54e64687,
    0x3f9a36c1f0bec9a8, 0xbfe244107ea70efc,
    0xbfe76dd13cce9450, 0xbfde0d605825fe5f,
    0xbfb3afdbb69d8c65, 0x3fe074da2b296e5c,
    0x3fe85050c08863c7, 0x3fde0b6b5cd707bd,
    0x3fa7df54fe8bc16b, 0xbfe0d0dea3123a78,
    0xbfe66bdded3eacd4, 0xbfddc4b3d4e0a0bb,
    0xbfb0688093024e44, 0x3fdd93ed1533da13,
    0x3fe5a36d3a361da0, 0x3fe02d39f32fc344,
    0x3fb362519791c3d2, 0xbfd80cf2b81e8fdc,
    0xbfe3b83bcd4da228, 0xbfe28d4727fb0099,
    0xbfaaf1dd47ca2b36, 0x3fda6129c282eb78,
    0x3fe61f3e30e948ff, 0x3fde19712fd3d42a,
    0x3fb46805ec11403d, 0xbfde3e726648f772,
    0xbfe48b550d1bc857, 0xbfdefda0eeaa5387,
    0xbfb735eb7f7a41ad, 0x3fd8f2d818bfd92f,
    0x3fe6688f22e65492, 0x3fe029e221cd455f,
    0xbf867090a84977b9, 0xbfe208c3522acf8d,
    0xbfe84c929be59e66, 0xbfdfa24af2ef1534,
    0x3f9fe677f1ad0cb7, 0x3fe22ea99a0761c1,
    0x3fe5498ef10c0b13, 0x3fdfeb2872a69795,
    0xbfb3a5a41ef0ed31, 0xbfdfe61c5ab2571c,
    0xbfe56c9f3a0a7cc7, 0xbfe0dd5ab36eef35,
    0x3f7613a372354327, 0x3fde0ac0e7224832,
    0x3fe5700aa5c8632f, 0x3fe1182da1985aab,
    0xbfa45cc57b77bc33, 0xbfe2fa6e5deb8e3e,
    0xbfe5e1b7563e436c, 0xbfdeb514a891afc9,
    0xbf8a72adee709c65, 0x3fdf4aa6469da892,
    0x3fe8b7b989024759, 0x3fe0a689a5d4072c,
    0xbfba3b6f896609a5, 0xbfe070a93c4869b6,
    0xbfe405ecf3293fa4, 0xbfe039a44a1224c5,
    0xbfa9311dc3d74f40, 0x3fe08324784e3c05,
    0x3fe33d005f86fb3d, 0x3fe0c8aa5a916a90,
    0xbf67d8a1696afd99, 0xbfe13024f04e62ce,
    0xbfe56535b0216a94, 0xbfddb1b133a69be9,
    0x3f9fdf9b010b1c56, 0x3fdd6396c2c7e158,
    0x3fe4437813413ba8, 0x3fe195e80b40dacb,
    0x3f368a65d9499a71, 0xbfdcc1b610e90522,
    0xbfe65a90d020392b, 0xbfe02b35123ffb4c,
    0x3f8aef0c138fc3eb, 0x3fdf8d0212914b35,
    0x3fe7d49d1abafea1, 0x3fdda8f599802d49,
    0xbfa2096ebc98cb91, 0xbfdcdb788c414de7,
    0xbfe2e50163c6b7dc, 0xbfdbc46e3bc76e5b,
    0xbf941bf7af039712, 0x3fdf5c5533554c48,
    0x3fe6e480cc35f5f6, 0x3fdf3c59c00c951b,
    0xbf81ce247ee5d422, 0xbfdcfab6bc7f559b,
    0xbfe54a906e81cd95, 0xbfe0bf15fecf3548,
    0x3fab1cde640ca664, 0x3fdf1732bd0187e1,
    0x3fe2abbed3549bd8, 0x3fe089412fb1b32b,
    0xbf664275a20e24bc, 0xbfe0de252c0a5a74,
    0xbfe4423e3d3102ff, 0xbfdee04ab9b2e102,
    0xbfb094d3e1a4ca92, 0x3fdd902f5aeb6905,
    0x3fe790679e41000d, 0x3fe0246717c89656,
    0x3f979fc5ba025102, 0xbfddad144f560e3f,
    0xbfe6f591f8762dcf, 0xbfde3c9db3c045b3,
    0xbf83ae7bc8aaf8fd, 0x3fe24cd2681a922f,
    0x3fe76bb276d6697a, 0x3fdf169c1c93aa24,
    0x3f84faf439bf0e91, 0xbfdca246d78914f7,
    0xbfe5e8e9cd86f9cc, 0xbfdfa45af2e3be84,
    0x3fa69eee6715d452, 0x3fdeec04778f9ea1,
    0x3fe4ed2bdba0bba4, 0x3fe07a3de8cf345f,
    0xbfb03783bb0aad0b, 0xbfe15bc786d647d7,
    0xbfe6b2640823b801, 0xbfdc47f6da046796,
    0x3fb29622958c8e2e, 0x3fde5f9dda288800,
    0x3fe6f9f85c4c4e54, 0x3fe02f0d9ab2e2d1,
    0xbfb531e856bfb8dd, 0xbfdf8105397d56fe,
    0xbfe4ed59f8f48b2a, 0xbfe1a65ce609df0a,
    0xbf9e2f733cd9d355, 0x3fe21f11a70d978c,
    0x3fe555773f29d975, 0x3fdb8e732cf9a772,
    0x3fa6de43740ee3b7, 0xbfde5c178fe2c0b3,
    0xbfe53ad1ed5837d0, 0xbfe15e7046ef594e,
    0x3fa4f2a480878f3e, 0x3fe06602bfc2fedc,
    0x3fe7f4d15b5d1bf7, 0x3fe14a43d9cc54f8,
    0x3fb562f5bedc905a, 0xbfdfc7f4c4f435ff,
    0xbfe817e0ab760ab7, 0xbfe037defc61443a,
    0x3fc2ce276c57920f, 0x3fdb6034632bc682,
    0x3fe5c88b6d98c48d, 0x3fe029c99b2c08a9,
    0xbfb1506f5a044847, 0xbfe0b85dcbb28e09,
    0xbfe7338eb9d8b146, 0xbfe0574c3ed5762f,
    0x3fa156143e459403, 0x3fe00ed288f5556b,
    0x3fe6b213c3b090d7, 0x3fe0947e4e4bfa75,
    0x3f89e4efb5ce4076, 0xbfdf787db7340cb6,
    0xbfe66dc4ab2a4cb8, 0xbfddb700b0e96534,
    0x3f68fa0c0958c83f, 0x3fe079c25e16d44c,
    0x3fe5d9332e143ebb, 0x3fe42df1f9d372d5,
    0x3fa2534b5ff101d5, 0xbfde2a499624dcd8,
    0xbfe5f61578939aaf, 0xbfdb843f07583c9d,
    0xbfbb914b6f4b5348, 0x3fdfe7f4b3f35d43,
    0x3fe5e393ae4a29a5, 0x3fdf730384f4c7d1,
    0x3f93e738b4dbb9ca, 0xbfddea9509c6a887,
    0xbfe1fa8ab98323ef, 0xbfe07752941694d3,
    0x3f89a4e01f7c0a5a, 0x3fdb24623b21857d,
    0x3fe1c3752030b252, 0x3fe1054fe13f0ece,
    0xbf9454472aa5ecc6, 0xbfe1238630de6588,
    0xbfe66f2081385a96, 0xbfdcac4d9d3e3080,
    0xbf92d46bd743ac14, 0x3fdbfd636936d01c,
    0x3fe76a18a3ee0371, 0x3fe0e364bb0337a3,
    0xbf80462bb7bfc36a, 0xbfe1bd9a91845aea,
    0xbfe70669b3957adb, 0xbfe02842ee73178e,
    0xbf490bec25e1b295, 0x3fe29908eeebf9c4,
    0x3fe95578a7106e3c, 0x3fe2b1a29d09219f,
    0x3f6f8905631bbce1, 0xbfde755991d2fc0a,
    0xbfe3ea8c74ff41c0, 0xbfdda8dde1a9fba2,
    0x3fb26a3153a53ec7, 0x3fe02e112ba60cba,
    0x3fe7f9063e444d23, 0x3fe231d0ac5478cf,
    0x3fba59b28d15de43, 0xbfdf7e52190c9285,
    0xbfe80c38ec2ab7e6, 0xbfe0d0573c20c609,
    0xbf62157d9a7bfbb9, 0x3fe20832b6948cd6,
    0x3fe684069116d05d, 0x3fe1a84eeaf8b36e,
    0x3fb27e74e145aaef, 0xbfe067d26e8ef231,
    0xbfe3880162c89f74, 0xbfe1b57190683077,
    0x3fa10f9bc69c1300, 0x3fe0470e6c0efc49,
    0x3fe348c1ca1c4c97, 0x3fdfcd347f2e586e,
    0xbfa242237ee93f9f, 0xbfe14c1e22579059,
    0xbfe608b423b507c4, 0xbfe093f3a537cd17,
    0x3fb194b134a2a854, 0x3fe0b6df3df45a6a,
    0x3fe70ac8a442ba67, 0x3fe03dad96b066c9,
    0x3fa6ee0a5bfe9685, 0xbfdb73980491769b,
    0xbfe8a967e7b577af, 0xbfdf1c6e5f550570,
    0x3fb5c6d32c202650, 0x3fdef78c02f7d951,
    0x3fe71e05f15a501e, 0x3fdaffba0f97278b,
    0xbf6584837dc36ae1, 0xbfddad738dcbeaeb,
    0xbfe7319a3bcd1950, 0xbfe0b85f0fa60e9d,
    0xbfa07aed6a73c32c, 0x3fd61f11427a2262,
    0x3fe8898522fe99a8, 0x3fdec0974a414eb3,
    0x3fa3e3393c9c81bc, 0xbfdd105b2c69c96e,
    0xbfe73128ee094e0c, 0xbfe108b885106a27,
    0x3fa32507f59339d9, 0x3fdecf4e305b76e9,
    0x3fe3a5bc589911ee, 0x3fe1a84988ae94a6,
    0x3f98ab1d575cbe32, 0xbfde6393b077a85c,
    0xbfe517629cee09c5, 0xbfe13907e0348c98,
    0x3f5168ea6372a23b, 0x3fde2a65b558e1af,
    0x3fe846cca9da2783, 0x3fd89eacc49dcb7a,
    0x3f9ecad963756ed0, 0xbfdce6428370be93,
    0xbfe59f6b93099782, 0xbfdee8ca2d449d92,
    0x3fb0079bed7df5bf, 0x3fe3690eb01278a7,
    0x3fe757de549c0eb8, 0x3fe0f61d3475d97a,
    0xbfa457d668ee6c66, 0xbfdd0dba8069b9b8,
    0xbfe5fdc0f0c7ddbc, 0xbfe197d81b239f2b,
    0xbf8ba2f73223790c, 0x3fe147bf4d82a818,
    0x3fe6f44109438898, 0x3fdf958f96be7683,
    0xbfa87c01253a1475, 0xbfdc1d6bb2364cec,
    0xbfe5510790dbf971, 0xbfe1243e3f00478f,
    0x3f8269465cb79606, 0x3fdd7eb2dba792ba,
    0x3fe54dff591d7054, 0x3fdb3c9ce276c590,
    0xbfae4770ee1d27fd, 0xbfde214768e47315,
    0xbfe67b982089a009, 0xbfe093b63428bb0c,
    0xbfb872f72026bca6, 0x3fe0be04fc8ae49d,
    0x3fe4e560f14b8b93, 0x3fdda1f6dba73f0e,
    0x3fa68a82e35ea511, 0xbfdb85a960e54c08,
    0xbfe55e649f2d8c3a, 0xbfe2a7f263da69c9,
    0xbf9b209a7ff475cd, 0x3fe08fb017bbd7c1,
    0x3fe64638c1762361, 0x3fdf2caa83f44304,
    0xbf2c8dbb5cf095fb, 0xbfe1e328de956958,
    0xbfe31ce4b4fb68f2, 0xbfe21ef678627e52,
    0xbf21e5bff25bf7e7, 0x3fdb5a223a27ce6f,
    0x3fe598d7347029b7, 0x3fdde5dea2234e2d,
    0xbf79969f0e42b7e8, 0xbfdee97e80d74332,
    0xbfe5dcf081b38b29, 0xbfdd90e21b3045a4,
    0x3fc62b46cc8ccdaf, 0x3fe18f5e4c43d628,
    0x3fe9503ddb72c05d, 0x3fe37973234e5f8a,
    0xbf8fb0e1a783beed, 0xbfe251ef393c7bee,
    0xbfe3994484415bc9, 0xbfdde60c1435ac47,
    0xbf818711c9056576, 0x3fdd75e1fc8557e9,
    0x3fe6be2a269f640e, 0x3fe15a1e3566bda7,
    0x3fa31f9f65fac4a4, 0xbfe164d7546ce0d1,
    0xbfe4196a91b1314f, 0xbfe10bb6ccc44b98,
    0xbf931b2543d5bc96, 0x3fde5253522ffe34,
    0x3fe7b797f4a067e9, 0x3fd704f9c9d4c262,
    0xbfa5e267650abe01, 0xbfe0ed4435ac78b5,
    0xbfe78347683436bc, 0xbfddd7d683346c7c,
    0x3fb0972fb5fcdbaa, 0x3fe1436a59cc186b,
    0x3fe47694ee9f64a5, 0x3fe101d9dd3c3c1d,
    0xbf8b338366c6e714, 0xbfdc9477be3e6e86,
    0xbfe7b3c6c35d9f84, 0xbfde69a1ff64d990,
    0xbf8a2a3a56d4e637, 0x3fddabdac40e289a,
    0x3fe63a9f9a5e8b73, 0x3fe05d32944dae6f,
    0x3f80bf073c8220b2, 0xbfda6ebce33fb2bd,
    0xbfe64ca34a89b2bc, 0xbfe20d95622831c5,
    0x3fac79222046541a, 0x3fe1b107d923a1bf,
    0x3fe68d404e231b41, 0x3fe0ca2517d19276,
    0x3f92d4a4cba17931, 0xbfe0246b8543ab26,
    0xbfe65336c36bb569, 0xbfdd038680a21494,
    0xbfa33edc3b698e0f, 0x3fdf757f36e682cc,
    0x3fe68c1c6e3191a3, 0x3fe085197cba1521,
    0xbf8d2a87461210c5, 0xbfe3981fe6f2bc2a,
    0xbfe56238808f3242, 0xbfddc42efb7138db,
    0xbf93ed09ffd0839c, 0x3fe0326013906bd7,
    0x3fe31778d0e68156, 0x3fde4ddfca86f8dd,
    0x3fb1e1e1de3e9363, 0xbfe0e5ec9814fad7,
    0xbfe7fe6b846bf0b7, 0xbfde45c24756dc0b,
    0x3fb8719b184f6cc4, 0x3fe22f883dd4ade6,
    0x3fe75d8682ac66f6, 0x3fdcc6a13d33ee0f,
    0x3fc5f0738baddcc4, 0xbfe01f3ce86a6307,
    0xbfe5ef6ee92478e7, 0xbfdc89ab0d77d73c,
    0x3f90798ff48ab724, 0x3fdcc528ddae8b7f,
    0x3fe662118f31802a, 0x3fe17467e801b194,
    0x3f98bf084dfc39c7, 0xbfdec1cd501834da,
    0xbfe6e9c9dfc90273, 0xbfe2301703751b92,
    0x3fb66a863aa7c47b, 0x3fddcfe55e7f0253,
    0x3fea043b47a3be6e, 0x3fde3ccc897a5068,
    0x3fbbabaa0afdfd16, 0xbfdec61f117a4990,
    0xbfe90126d514c73f, 0xbfe1e5f3833d2d17,
    0xbfb133b6568dca73, 0x3fe09b34f3993a95,
    0x3fe467ec13cc1a76, 0x3fdce7591e022947,
    0x3f9e4192df9af570, 0xbfe0010348ee9878,
    0xbfe7c80c6be8407a, 0xbfdc2a44c697c3cb,
    0x3fa58b1ba297e8f1, 0x3fdae7026e00e4f1,
    0x3fe9ec31a9a7045a, 0x3fdf9b8f72c7f466,
    0xbfac7093ae2de204, 0xbfdef06b2e068090,
    0xbfe81c331ea8fac9, 0xbfd9fe25e7d0e4f6,
    0x3f6aff70d92b98b4, 0x3fdf721c4b0c6ddb,
    0x3fe75c6e68d6d9c3, 0x3fdcff8380ab35ab,
    0xbf655d87723879cc, 0xbfe2acaf82c2d596,
    0xbfe80eb1049ec09e, 0xbfdc0d82ce1ed3c0,
    0xbf73230fecd83a84, 0x3fddb0b37506fc2d,
    0x3fe5767d95f0a262, 0x3fe0b0de878e7010,
    0xbfb01bb6d538e933, 0xbfe048466a1e6d21,
    0xbfe96636095feade, 0xbfe12b1996b1f400,
    0x3f93353ac391fa2f, 0x3fe1981bf4f5e70a,
    0x3fe6fd475b449064, 0x3fdfa0362d94627c,
    0x3fbfa465a5e2897c, 0xbfe14bdadaf28547,
    0xbfe665585b5267be, 0xbfdf53e4fae38839,
    0xbf8bd9183a15b8d5, 0x3fe134f98720e55f,
    0x3fe6e6e312e61f47, 0x3fdba7eb1434ed64,
    0x3f98fd3c25e7b535, 0xbfe2bec9dc2417fb,
    0xbfe6959aa9e35706, 0xbfe125241c2ce80f,
    0xbf9b9aa609411753, 0x3fdd3ba718ef1eb4,
    0x3fe83bbaf8da17ac, 0x3fdb1b5d46507bc1,
    0xbf966add151ffc95, 0xbfe0376b6b7625f7,
    0xbfe74115c5b1e9e0, 0xbfe0a81a491c7967,
    0x3f971029665b0e0c, 0x3fdfd5dc91d01af9,
    0x3fe952bec923ee8a, 0x3fe1e599a7218538,
    0xbfa73e865ddebd2d, 0xbfe02239ad8159dc,
    0xbfead1d1655a061b, 0xbfe06962847e9b96,
    0x3f995d39e0bf934a, 0x3fe260e8239b9ca8,
    0x3fea021944c392ee, 0x3fe2d4447b9f75f2,
    0xbf9412e1fe36ff74, 0xbfde286a3fa9b266,
    0xbfe6eb135c104ccc, 0xbfdfbb23ebe1ef80,
    0xbfa82eab467bdd16, 0x3fe03aad42ebf896,
    0x3fe7139d4eb0ad97, 0x3fe102debee64f21,
    0xbf94d95720630852, 0xbfe1611f5720a75d,
    0xbfe39bece5fb75de, 0xbfde5493cc91ede7,
    0x3f94f475f5c49009, 0x3fdbe475269c0880,
    0x3fe691f10c9668b2, 0x3fddd7423c67b489,
    0xbf6d0d32a4684bbe, 0xbfe3367b58309d4b,
    0xbfe64f801b843d70, 0xbfe0e396c9761294,
    0xbfa7461ab40d2a04, 0x3fdf561c75321afb,
    0x3fe77a077bef6e40, 0x3fdfc1512a71cf61,
    0xbf94c76712f54bc5, 0xbfe2706a9726a134,
    0xbfe3bf43bd4f3804, 0xbfe082c1fa7d6430,
    0xbfb1352601c6ef1d, 0x3fe0fa31c53a7ef4,
    0x3fe913fb7768fc15, 0x3fdba4f7d732ae16,
    0xbf8118ab24584d3d, 0xbfda66feea695abe,
    0xbfe52a688a9693d9, 0xbfdb2e4f4725c029,
    0xbf9cbd2068e9cad5, 0x3fdfcf4ef912f14b,
    0x3fe7fe564153bc3c, 0x3fe0ae79abdedc09,
    0xbfad27194f7d80e1, 0xbfdc58d51de01ed6,
    0xbfe6ada7dcc2af65, 0xbfdad2c3da0662e4,
    0xbfa1a67b4987f372, 0x3fe1159e833b8458,
    0x3fe65931daa7f517, 0x3fe287231fae06f5,
    0xbfb2360aa43bb0fe, 0xbfe1a3f96ad842c6,
    0xbfe5167ab85a6561, 0xbfe3444a208e62d9,
    0x3f9d1ea0ab4f664c, 0x3fe02cd02c3f7656,
    0x3fe782280d4b5eac, 0x3fdeb88826f42f0f,
    0xbf8d1200c1979ed3, 0xbfd830d825506106,
    0xbfe7033d791e748e, 0xbfd99b22e0cf2cbc,
    0xbfb1732dcfae3bae, 0x3fdb60777a76d3fa,
    0x3fe5115b995b2f41, 0x3fdf3eba97293227,
    0xbf8bee2ab24504fd, 0xbfdfe9a9bad4216a,
    0xbfe65878fa2b8c3b, 0xbfe18a2fa5876478,
    0xbfaf0b8a59253ac6, 0x3fe14a861ebc411d,
    0x3fe74133f46da52d, 0x3fdeae6414f2d1ab,
    0x3fb190e45f6d9f10, 0xbfdd75bcdb2b7233,
    0xbfe7b752f8100d8b, 0xbfe11b332235d176,
    0xbfb0352229206184, 0x3fe16190db9b61c2,
    0x3fe73ced43804bb9, 0x3fdff5be196bdf04,
    0x3fb5a9ba665c1d94, 0xbfdd95422daee0ca,
    0xbfe822f187efe403, 0xbfde2ba6f135b242,
    0x3fb2bf0105ebc27f, 0x3fe00aef02f5e542,
    0x3fe5f27438816da2, 0x3fe2e4462b66c82e,
    0xbf4a239cf5a0218e, 0xbfe1640561fdda3c,
    0xbfe6d473c736837a, 0xbfdf04f0f54f4739,
    0xbf9925f3911327cd, 0x3fe0a3a93b56061e,
    0x3fe83b4ebc50f765, 0x3fe2fc23a481bcbf,
    0xbf869e33cd6e0784, 0xbfde233253a8af32,
    0xbfe316d84f4be107, 0xbfdf9c8c4e2bfe50,
    0x3f56455a8d72a972, 0x3fdd24ed716b865a,
    0x3fe4927493dead20, 0x3fdc950d96b8531c,
    0xbfb7f8ae2aaa95a9, 0xbfdfcea625d09555,
    0xbfe75f1d1a67d191, 0xbfe0c1cd20a388e4,
    0x3fa50bf206c7d72b, 0x3fe152e6d3d8e814,
    0x3fe300b8b105e5d4, 0x3fe162d434ad7b6d,
    0xbfacb35c01fb6e72, 0xbfe1819472eafd1e,
    0xbfe5505b9e2ee144, 0xbfdd7ed4ef7e2d7e,
    0x3f9f86d69f2f22e7, 0x3fd91c6896692321,
    0x3fe602ec2ecbc9ff, 0x3fe06f8bdc5574d8,
    0x3f65b20b8eb4e9f8, 0xbfdfb83915097d81,
    0xbfe5be0edde3ba0a, 0xbfdd30044cfaba85,
    0xbf910e2295e0b56d, 0x3fe008ce42652493,
    0x3fe5db260fb4079f, 0x3fdab5f47c673d35,
    0xbf944122a788ff20, 0xbfe060a706dc15bc,
    0xbfe73bd1bde91762, 0xbfe01380e2d6e698,
    0xbf82a885ce95950f, 0x3fdefc498d26e425,
    0x3fe43519e9952b92, 0x3fe005060f59339f,
    0x3f967ff265c5b387, 0xbfe20a25bc8be789,
    0xbfe73a866433c159, 0xbfda3d3516dded8c,
    0xbf67f872695fa15a, 0x3fe10ff1b8080398,
    0x3fe6725071497dc9, 0x3fe16856bc64360a,
    0xbf8700ac6216c8a3, 0xbfdc946f2fa59c8e,
    0xbfe7a1df5fade41e, 0xbfdbb0e65db47ce3,
    0xbfa2c364bda3d973, 0x3fdfa268c870cfe3,
    0x3fe882e305d83a82, 0x3fe18a5acebb18cf,
    0x3fb480e79c6c3454, 0xbfdd959a2fdc498c,
    0xbfe55d96015526b0, 0xbfddf60c9d8fbd5f,
    0xbfb19ff745727325, 0x3fde5b7e497f5597,
    0x3fe7c5d77831e8b8, 0x3fde30a0bb9c678c,
    0xbf6750cb93c7e13f, 0xbfe2296c1d9c2796,
    0xbfe7911077a3539a, 0xbfdd8d3aae771118,
    0x3faa8af4f71c6fd9, 0x3fdec45e715a74f6,
    0x3fe767405ae9b20e, 0x3fdce3c815804b2e,
    0xbfa751e52b14da1b, 0xbfe1d3044c71c35d,
    0xbfe553636ded0c40, 0xbfe01f9678385c02,
    0x3f96f77ef7da27c7, 0x3fe0748e612b7013,
    0x3fe4d5d393d7b4ee, 0x3fe1b7bf7259c8cb,
    0x3f8df87496770eaf, 0xbfe198746909046f,
    0xbfe5dc9ff2db9b36, 0xbfdf12218acee594,
    0x3fad9b4633535365, 0x3fdf1b042b2dc8c1,
    0x3fe59f7d541a2856, 0x3fddd654c5d6d382,
    0x3f78e3080d3cae31, 0xbfe03b398ee2e518,
    0xbfe513e0ef346a6c, 0xbfe14f504d2778e7,
    0xbf8abeee1a48833c, 0x3fe074b3fb3de229,
    0x3fe3eeb47fcafeb0, 0x3fe31c888475c4a5,
    0x3f63f21829f70e05, 0xbfdc6af7d54ea2dd,
    0xbfe6fc2d0ab87be1, 0xbfe04a9ef252c400,
    0x3fb9a7635b87daec, 0x3fdfc695a03b4f03,
    0x3fe5177c50ca13fd, 0x3fdce2da0bb7f064,
    0x3f7a1b7b7f6b5e7a, 0xbfe0db340d5ac15f,
    0xbfe6d478fe41745a, 0xbfde050aab1406a1,
    0xbfac81b24a0cef0a, 0x3fe08102f282dcd0,
    0x3fe6dc180408f2cb, 0x3fe2f1bb65f73047,
    0xbfaed5e4a3c87971, 0xbfdecc3413b13461,
    0xbfe699e81ee47f20, 0xbfe02b59d808a7eb,
    0x3fa5d99e5380b50f, 0x3fdffafc0c8c185a,
    0x3fe7aa9a0401acc2, 0x3fdf8762b001069c,
    0x3fb5c08629f70e59, 0xbfe0fd89704b9ce0,
    0xbfe74cbaef5f3c04, 0xbfe28bdc022074ac,
    0x3fb0982f3ca8a516, 0x3fd9e43999e8c670,
    0x3fe5d50700c7f516, 0x3fdc73e839456999,
    0xbf81521c8fcc10ac, 0xbfddfba1da5ddef0,
    0xbfe8ba8cf14a3eb5, 0xbfdd81159c81c689,
    0x3fb30b841c81f94e, 0x3fe162a3d85b9f8a,
    0x3fe668d67296dffd, 0x3fe18440f7c4dd72,
    0xbf602f2facef054e, 0xbfe0c5278aa2bfbc,
    0xbfea6a10a223301d, 0xbfe0f13ffa935d75,
    0xbf9f8c596b27bac3, 0x3fdee9f0e2817e6b,
    0x3fe8abff3cfd12b3, 0x3fe00d0234269e7d,
    0xbf9021d6e90ef730, 0xbfdb6e33dde5dd08,
    0xbfe67f51e07b32eb, 0xbfdf50c138118e78,
    0x3f8413928f319b15, 0x3fdca14b608de6be,
    0x3fe6507ee13ed5e0, 0x3fe2384a63f8a615,
    0xbfb51237706e6347, 0xbfdc31047843733c,
    0xbfe7fa0d53c6f2fe, 0xbfe32208743bfe48,
    0xbf92530ff90bf958, 0x3fe030145e0e7337,
    0x3fe60ace621f9ea8, 0x3fdf643c7701575e,
    0xbf972870d3944e02, 0xbfdfdaf7b5b10b7c,
    0xbfe355a38d21b005, 0xbfdf9c59e5d48857,
    0x3f92e3f9aa337046, 0x3fdc4aa45ab5570b,
    0x3fe7b5ab9e26024d, 0x3fdf35017ff00d6d,
    0x3fb4d7ba4b595e8b, 0xbfe1865d625390d7,
    0xbfe5c669daeeb480, 0xbfde3c8e093072b2,
    0xbfa600dea29a7ff9, 0x3fe05f919ba0b689,
    0x3fe6cb10656e8d0c, 0x3fde044ae3c7b53c,
    0x3fb44318ac787920, 0xbfde879d89dbda1c,
    0xbfe61de7262b0df3, 0xbfdf60f6d7bc1905,
    0x3fa522081b246cb6, 0x3fe3f37d21110c0c,
    0x3fe5b1c7ff63c572, 0x3fdae7b870d9a790,
    0x3fa01529abea4ede, 0xbfdff9e33445e4a0,
    0xbfe5c5cf8a804e70, 0xbfde432420bd412a,
    0xbf9193fd0767028b, 0x3fdc310d04b9d5e7,
    0x3fe7f2eefb331f87, 0x3fda8c57568c4be1,
    0xbf94cdd88259b1d9, 0xbfe0b0e35637e56d,
    0xbfe5f4bd20811e6f, 0xbfde962a2ae6193d,
    0xbfa7143941d9552d, 0x3fe0b0c24bbc4aac,
    0x3fe76b0a9e30dae4, 0x3fe0601f6d00ec5f,
    0xbfa54b8fd534ba52, 0xbfe104089a07d153,
    0xbfe668ea738ca652, 0xbfdbfade183652a0,
    0x3fa87d33dbb098b4, 0x3fdd4d4dd3298b64,
    0x3fe51e7fde630be2, 0x3fdc3797310c783d,
    0x3fb0885a5f11b836, 0xbfdfa8c46f38575d,
    0xbfe410fd477b6c33, 0xbfde1b10b1338829,
    0x3f99789dc5aac98c, 0x3fe29b4464e12259,
    0x3fe4e351f0660cf4, 0x3fda1433a21cb511,
    0xbfa6c5f2e626f9fc, 0xbfe206a4686d603f,
    0xbfe442f538d19bc1, 0xbfe0bcadff7c5931,
    0x3fb7db649151d492, 0x3fdfb9d6be8acc90,
    0x3fe715aa01bcf8b7, 0x3fdbd27318b6668c,
    0x3f83c449df72a06f, 0xbfe0e3855debbd3e,
    0xbfe49fda7e92df21, 0xbfe0673e49217310,
    0x3f8865660c605fbc, 0x3fe055c423e491de,
    0x3fe7d6d36211d71b, 0x3fe25501b652546c,
    0xbfb2b2bc2196bd16, 0xbfe218169a6a7f5c,
    0xbfe7e3c43563cd5f, 0xbfe20c3cfef97d5c,
    0x3fc4bbf7f5ff5c7b, 0x3fe30d0ccdf6de62,
    0x3fe791a0b5bf63b8, 0x3fde3882550b3d46,
    0xbf96f9212cb69612, 0xbfdde3fe90f9f7ef,
    0xbfe8a2f993c89836, 0xbfdfddd6a176256a,
    0xbf7f178564c73c00, 0x3fdfb21eebdf73a7,
    0x3fe5d806432a4ba6, 0x3fe1aaaf36224c2f,
    0xbf7420f0f488cc9c, 0xbfe157b2399c52ec,
    0xbfe4226ebf896a3e, 0xbfdf4416fb0af197,
    0x3f95fe6f68be67ae, 0x3fe04214d5ceba71,
    0x3fe4d1507644fd86, 0x3fe0531c78dd4996,
    0xbf8b7fcbe498977d, 0xbfe07bd99cf5f219,
    0xbfe5b8f0fe85ac71, 0xbfde480d14b41910,
    0xbf6b288c9fbaf8e8, 0x3fe0924e62ed240f,
    0x3fe640ccaeae54c9, 0x3fde172b870c4e99,
    0x3fa1a8d93e30cb98, 0xbfe029dde3676e69,
    0xbfe5c8c7919b2393, 0xbfda8e89cb6eb1f4,
    0xbfa4d8c067a84715, 0x3fdf7b5de16f6dcc,
    0x3fe2fb6b2b63afa4, 0x3fe2df7300609a05,
    0x3f92b33732022497, 0xbfe08c855669a13d,
    0xbfe8065376b04035, 0xbfd72b9f13ac6c3a,
    0xbf9bf5a521c831da, 0x3fe1fe6b5134447a,
    0x3fe63bee7f08a7ad, 0x3fd6abb5d4a88fad,
    0xbf319e44a4c3483b, 0xbfdd47cb22b8b9e2,
    0xbfe6224baf006055, 0xbfe15da26a8eec51,
    0xbfc023bc4eaf3d39, 0x3fde52dd7ae109e5,
    0x3fe892d8fba7a3f7, 0x3fdcfbaf1e8fafae,
    0x3fb510f426ceb833, 0xbfd991c03f263b48,
    0xbfe63a145faf1a40, 0xbfda9510c64543bb,
    0xbfb5e529ae267ea3, 0x3fe01b79266fdf21,
    0x3fe4161645ab447c, 0x3fdf51c250a17aea,
    0x3fbf1e2104e63cc7, 0xbfe0b302bc9f4a10,
    0xbfe581fd3aff5429, 0xbfd5d394370bb8bc,
    0x3f91df5a508d32fc, 0x3fe1a5a64998f490,
    0x3fe475b29b1abe4e, 0x3fdf528aee3795f7,
    0xbf83407f8cf4a536, 0xbfe17d9c71736ea9,
    0xbfe3e3a603d42bc6, 0xbfdedd42851c0975,
    0xbfa99d2b40c4ccfb, 0x3fdfbb58ebe20d3d,
    0x3fe47d943897fcd5, 0x3fe050ac1e022858,
    0x3f7f56a8ac97d216, 0xbfdd7d8213ebcb9a,
    0xbfe72645c8251964, 0xbfe2760b0d3ea44a,
    0x3fb3fccdbacaafc0, 0x3fdfed007621430a,
    0x3fe4a82d484e3be1, 0x3fda8bfd0c9ba9c8,
    0xbf8551d8f38fc533, 0xbfde325f7d6687ab,
    0xbfe678dc890b3300, 0xbfe4770bb5a11c58,
    0xbfa46ca9f0adaf63, 0x3fdf48ac34bc11ee,
    0x3fe479df31d2c32c, 0x3fdd5e7ea44cf1cc,
    0xbfb2543c64ffcac6, 0xbfdda8350f1852e9,
    0xbfe54e0f007fc602, 0xbfdc455ddb37ef4b,
    0xbfb63bc443be2663, 0x3fe100ee7e6cc273,
    0x3fe54a2ac4f3cb6c, 0x3fdf2a8644d4de85,
    0x3fb5637e3b4c47ca, 0xbfde16c2fdafe758,
    0xbfe8038f66e74330, 0xbfe2594492864a19,
    0xbf9d649da6f3d799, 0x3fe06361b84612a3,
    0x3fe6e414f511fa20, 0x3fe2c748e8ba919f,
    0xbf834ca7bd7e8175, 0xbfdb61c4afaa1130,
    0xbfe634b797c5b4e7, 0xbfdb7b7418c55716,
    0xbfaab1ce7277362f, 0x3fe0076094c7d0a1,
    0x3fe6e2d9d90a37f2, 0x3fdfe8c9d752380e,
    0x3fae4a530b9ec45e, 0xbfe23a0256d20a06,
    0xbfe8ee986e0749f8, 0xbfe0160069f3a6cc,
    0xbfa2f62a183f921d, 0x3fe010ab0fd0bd70,
    0x3fe59e51d5bf4fa2, 0x3fdfd57209aa1ff0,
    0x3fb38cf60a1f86e3, 0xbfe153050cbcd101,
    0xbfe716eb6fe0ad08, 0xbfdedfdafb03834b,
    0xbfad321424b61592, 0x3fdd63313399979a,
    0x3fe7288024758077, 0x3fe3269aafae4a50,
    0xbf9b65ee18e2b3b5, 0xbfde8ffa54f4540f,
    0xbfe59f8143c882fe, 0xbfe1f33e37eae157,
    0xbf8a23be4cffe76b, 0x3fe0e2bce0967243,
    0x3fe8c3349f97aa39, 0x3fdc7546d1ebfdba,
    0x3fb1a1dd0896aa75, 0xbfe0be8db3e47d0f,
    0xbfe54482efe89edf, 0xbfe078b0e5ac5c80,
    0x3fb32ce34beacb2e, 0x3fdc720db6e6e4ea,
    0x3fe61ed2669c151b, 0x3fe006f1d4f10aec,
    0x3f828680f2a53202, 0xbfdef870b4c85533,
    0xbfe4ee37ebd3be9e, 0xbfe171c785a65943,
    0x3f941342c1d822d1, 0x3fdc46bdff61fc00,
    0x3fe84bd73044e9f4, 0x3fdeecaf00961cb3,
    0xbfb737b5a3d3755c, 0xbfdb8aa8e1df49ae,
    0xbfe571b564ae0c8c, 0xbfdc08c9fbf4759f,
    0x3f9ca230b5122b26, 0x3fe0f65d56333e44,
    0x3fe47710ab108dce, 0x3fdd2de762e97ee4,
    0xbfb2de41c9f27834, 0xbfe307ce63dd017c,
    0xbfe4f33c1194127b, 0xbfddbf878b2f4e4a,
    0x3fb73f4c5594f39b, 0x3fdfec12d10fdd91,
    0x3fe6b3dd6f497dea, 0x3fe0c1cd92ddc102,
    0x3f86302033b94d59, 0xbfe022e9985af08d,
    0xbfe742b20e166194, 0xbfe0d8a223fe3634,
    0xbfb4577ac6d1b41d, 0x3fdee4a3fc9f7458,
    0x3fe7e6192af6d50e, 0x3fdeeae6986c880a,
    0xbf65de1bbf1d3b19, 0xbfe138344a9f4e87,
    0xbfe63b1e0de81e03, 0xbfe1532630969d8f,
    0xbfa73bfa22d5394f, 0x3fd94e8dda30d496,
    0x3fe640002fa0c0c1, 0x3fe079e93a40af98,
    0xbfa283504a4bd3e1, 0xbfdb64c7951ac0e4,
    0xbfe558a991bd17cc, 0xbfd98fd8ecc9f858,
    0xbf85224e05503dd3, 0x3fe004b16482261e,
    0x3fe645abd5b685ed, 0x3fdd5a37aff79a0d,
    0x3fa1465c089c63f2, 0xbfe27ff86eb93722,
    0xbfe6bfbd7ed9b41d, 0xbfe2c6cdff3331b9,
    0xbfb1c4f7c7c21c85, 0x3fde4c623633a69f,
    0x3fe6eef6a9f946c3, 0x3fe084aa5c3b485e,
    0x3f91c2fe339a1cb3, 0xbfdcffe06561ac5c,
    0xbfe6a953555299c2, 0xbfdc48929083c3f0,
    0x3fb60b97c102b0fc, 0x3fdd23e995596abf,
    0x3fe7b7db8362e8da, 0x3fe1830c81dd2f4d,
    0x3fa45323799c6fe3, 0xbfddd867bd635b39,
    0xbfe76e7a95333943, 0xbfdfc9e265c3e372,
    0x3fa1cc3ffad8ba24, 0x3fdfa5de5c96ff55,
    0x3fe59a6e18c6a1ea, 0x3fdcca8568a7875a,
    0x3fa4f3ab2396ad70, 0xbfe04f0385442118,
    0xbfe5568accf83194, 0xbfdebd252e235384,
    0xbfa465936cbc7605, 0x3fdf94e138581790,
    0x3fe5a892875e2808, 0x3fde0a3ab995b8a0,
    0x3faa2b6931316c91, 0xbfd692d13b0345bc,
    0xbfe760a1672c81be, 0xbfe0b0205a708856,
    0x3f94d8bc757f22a3, 0x3fe088b637a09d81,
    0x3fe4f88fdc0edbd2, 0x3fdf26c370f97ca0,
    0x3f9d671c5e0a50ba, 0xbfe0107db3234527,
    0xbfe4fee0820ec588, 0xbfe1bced31d5a3c3,
    0xbf8b5f71d9920aad, 0x3fe0d979b5f342cf,
    0x3fe5b9f3fd6b5cf6, 0x3fe0d182da0612fe,
    0xbfbcd06d28f96e86, 0xbfe09ebb5a276bfd,
    0xbfe81f37739a7146, 0xbfe1141c6da1d169,
    0xbfa3b7b0f9c02a90, 0x3fdf9960278c06af,
    0x3fe677ba9e7d87db, 0x3fe1e4f16b154edd,
    0xbf9f4758d63d5b03, 0xbfda7aeb2a1516aa,
    0xbfe79b44332281d4, 0xbfe18715eea2e346,
    0x3f9ad01cfbb94697, 0x3fe30958e9ab0bc0,
    0x3fe3e00088ae5dbe, 0x3fdbb302381b837d,
    0x3f918668fcbec56d, 0xbfdff86c5d7121d1,
    0xbfe5dd764aa288cf, 0xbfda7fda198e8769,
    0x3fa587115417c6de, 0x3fdccd329c0eb9f0,
    0x3fe6709c82334e6d, 0x3fe0350b078b846c,
    0x3f99f45b64b67613, 0xbfe2907c6a25fa34,
    0xbfe66652875a9a59, 0xbfe08b0078744b5c,
    0xbfa2174bcfcdcab7, 0x3fd77187957c44e9,
    0x3fe65244194f7533, 0x3fe05250f0a315f2,
    0xbf5e7220cc440dd1, 0xbfdec63fc0916405,
    0xbfe9e176e8e9b83e, 0xbfe0f2de12f1bb8d,
    0x3f90afc9528a5bce, 0x3fe05585c168016e,
    0x3fe331641f07671d, 0x3fe23ac557d5df3e,
    0xbfb25e312778f548, 0xbfe1553f233a088e,
    0xbfe3accf35c8de36, 0xbfe164a438f3fc7a,
    0x3f800c67dee194e6, 0x3fe0b10f0ac2d871,
    0x3fe7a47e79d57fbd, 0x3fe00dd1406415f5,
    0x3f556cbffa811d87, 0xbfdedb9f58721957,
    0xbfe56b8e0f81a909, 0xbfda92d0566072f7,
    0x3fa743329f4bbe8a, 0x3fdcc4d6268eac0a,
    0x3fe5d989b006779c, 0x3fe0a0d057b7911d,
    0xbf8c26611f09e948, 0xbfe0e3331b9b86ba,
    0xbfe58c502b1c1483, 0xbfdbdebc446cb8f5,
    0x3fb6f0a0d8ef8f8d, 0x3fde0fbe9703bc3c,
    0x3fe4cacddb23b9a7, 0x3fdd60eedddda658,
    0xbf87ca64c286d598, 0xbfde40d50e023ce5,
    0xbfe899fba6224c03, 0xbfde70dd63d5a8eb,
    0x3f9aeddf518fb57c, 0x3fddce19d7df32b3,
    0x3fe4b7b952f56d79, 0x3fe1adae2101db8b,
    0xbf79e52e90d11cdb, 0xbfdffee06f1faa9f,
    0xbfe7398d53f91a8c, 0xbfe023aaefe389d5,
    0xbfc00fe960ef2634, 0x3fe05b46b1fa4cdd,
    0x3fe60c38bba896b5, 0x3fe0ed23d1ae680d,
    0x3fa955dfcb61ced3, 0xbfdf60bffc2e3327,
    0xbfe35601df8faf29, 0xbfdffa5ed651e5eb,
    0xbf9786f57ab45a36, 0x3fddff0ff9b920aa,
    0x3fe6b60743b60499, 0x3fe0b4d7dec58ac9,
    0x3fb813eb4c9c3d3d, 0xbfdc130962d15115,
    0xbfe6e63600cead9e, 0xbfdfc36ce23bc72f,
    0xbf896c9c687e3eb7, 0x3fdbda26aa7c20e1,
    0x3fea8bb658b8da26, 0x3fe3177b26e68ed0,
    0xbfb2471bb609db91, 0xbfdb2d7638ab3018,
    0xbfe41f9f64a796d1, 0xbfde5ea8cffc0d72,
    0x3fb59d644caf1cc6, 0x3fdaa1d837b51aa4,
    0x3fe53d7a98202275, 0x3fdfcf855e5af1f3,
    0x3f9e614258b5cc47, 0xbfe0230c6d0ed7e1,
    0xbfe8f97945c87637, 0xbfdf06a2d6d4ce78,
    0xbf87fcd32321fc5e, 0x3fdfd7a56e91dafa,
    0x3fea59c95b5787fd, 0x3fded0a25ec25e26,
    0x3f52f40e73c2b476, 0xbfdd9f56c744cd74,
    0xbfe4e7907718af71, 0xbfdf7ff7df4ce6e5,
    0xbfba0578be0e517f, 0x3fe1f4afe90fc382,
    0x3fe7baf717182b8d, 0x3fe19cdeb8949a0d,
    0x3f6ac75febe4d5a7, 0xbfdaa76478e5df53,
    0xbfe6a2cbb2e2ebec, 0xbfdecc03954a8ab4,
    0xbfa3f4bde6ee1e9c, 0x3fe03d82729d7afb,
    0x3fe795e7cad9b583, 0x3fdd8c4ecaecf08a,
    0xbfa226e5f6d3f891, 0xbfe0c77d9a2d39e5,
    0xbfe49f12234d284c, 0xbfdaf3b00bf31ea5,
    0xbf8ad3d1e7dd1360, 0x3fe062b2eea39aac,
    0x3fe55c2d1f898761, 0x3fdcffac90eeb98b,
    0x3fa370e5586b9bc5, 0xbfe230da6391b4f5,
    0xbfe7b6af588c95f5, 0xbfda20bce951f198,
    0x3f9875bb178201b6, 0x3fdbf7a51161dcd9,
    0x3fe65edf663e76cd, 0x3fdce2ef007dbbc6,
    0xbfa3eff7bbfe6028, 0xbfe26e693b7075b0,
    0xbfe8688ab8ba3b3c, 0xbfe13a02d5e7c93b,
    0xbf906b1dbafdde8d, 0x3fdd032025382d74,
    0x3fe8a62994af90e0, 0x3fdf3861b4863680,
    0x3fc3235b4ecd8932, 0xbfdffee7ec13ec32,
    0xbfe8b3a1b472b1fa, 0xbfe152390e229dad,
    0xbfc09b35c0e14e0d, 0x3fe160aaa5e06f4b,
    0x3fe61e36d5fc5ea8, 0x3fe1744e0c8e3ce6,
    0x3fb0201d6c44266c, 0xbfe0a9f6040341fa,
    0xbfe86ed34b2a02d2, 0xbfe187c531041a28,
    0xbfa66e9982792855, 0x3fe0cc00365f75b8,
    0x3fe657d25105101f, 0x3fdec03a48681912,
    0xbfa9e5226fc95cf1, 0xbfdf0e37eb1b22fc,
    0xbfe4fdf9cf84cd5a, 0xbfe032cdc2b0ae6d,
    0x3f8e52c1922d50f0, 0x3fe18176b1bedfb8,
    0x3fe710de9e76c9c0, 0x3fe00ad24b70a5d9,
    0xbfa7916cbcf6237f, 0xbfdca3904a8aecaf,
    0xbfe8330706df71b0, 0xbfdd760c455e0671,
    0xbf82d61fa3402e43, 0x3fe1252689830b00,
    0x3fe4ce9c9743f217, 0x3fdbe0c144f60856,
    0xbf818ac2d03333cc, 0xbfe04d6301000b52,
    0xbfe62b4eb6788779, 0xbfdfba1c5e00890b,
    0x3fb044317f1d1e11, 0x3fdfbae19e1e13f9,
    0x3fe6584962a491c6, 0x3fe024c0174a2ebd,
    0xbf8e43476924cd43, 0xbfdec169d1083b10,
    0xbfe541f0eb828b2e, 0xbfe0e0795032e938,
    0x3fa09bebb5205e91, 0x3fdec51dd7f9e0c2,
    0x3fe5f780fe00ff0e, 0x3fe15592ee548a2e,
    0x3fb32bc61fbc13aa, 0xbfd98b577a541529,
    0xbfe67570d6af9c72, 0xbfe0269ce679c988,
    0xbfa4b47268260c32, 0x3fe01dda6387fb57,
    0x3fe62bdc985e465f, 0x3fe1cb8fbb2457c3,
    0xbfa4984214af0013, 0xbfdff433969a3f26,
    0xbfe615a8ee089950, 0xbfe20c4a79b14371,
    0xbfb26416c68afc83, 0x3fdfa820d2be0174,
    0x3fe771670f81316e, 0x3fda8464bdf1f2ee,
    0xbf85cf81e0c1647c, 0xbfdb34f19fc3ca71,
    0xbfe7943bede6f42e, 0xbfe184ec6f8b2388,
    0xbfa95b830b5a96cc, 0x3fdcab2f36523eaa,
    0x3fe4251b80bbe14e, 0x3fe302981fa9cd79,
    0xbf7c876589c278af, 0xbfe03c8cc502febc,
    0xbfe5e0c30fd08381, 0xbfdf003aa30939e5,
    0xbfc02c6f27cfa3c1, 0x3fdf91778ebdf4f4,
    0x3fe4b41743322506, 0x3fe05e03bea4279f,
    0x3fb6a6b3ef8c8094, 0xbfe042b93d9574b7,
    0xbfe68385295683d1, 0xbfdd4df4410c3e2a,
    0x3faa02bab236491b, 0x3fe0b31664ecb137,
    0x3fe7ce40ec85bbe1, 0x3fdaf4ba4a62a4e8,
    0x3fa818f97913ec46, 0xbfdf3eb89bd5fa99,
    0xbfe5da158eda479d, 0xbfe1a28f9caccec1,
    0x3f834071041dde65, 0x3fe25a597b07c48e,
    0x3fe33e12d94676fa, 0x3fe0298ed48aa0fb,
    0xbfa4788280c74521, 0xbfe0d06dee82c094,
    0xbfe68ee9b59d0999, 0xbfdf53bd71986df1,
    0xbf85147de910d6b1, 0x3fe051ed3c314c60,
    0x3fe76f2671a8a9b0, 0x3fdf5c33bfa1bda5,
    0xbfa652fc4fd69346, 0xbfe04870c882b031,
    0xbfe74d998c6f466a, 0xbfe159f3b0460c2d,
    0xbf8e7cf0c33c109c, 0x3fe0e5cdb9f8e2e7,
    0x3fe5cffa6a2e20a9, 0x3fdf03ff0f973927,
    0x3f7c0069bf4243fb, 0xbfe055474aabb303,
    0xbfe4f9ca2afd006e, 0xbfe037b172e4f789,
    0xbfb0d9bf05f6ca27, 0x3fdae47957dd1328,
    0x3fe66a311e4896f2, 0x3fdb492411b15abf,
    0x3f7b09ee8556313e, 0xbfdf076b5406fe5e,
    0xbfe2b2323dfcc556, 0xbfdc7762583f124a,
    0xbf4df80634687e92, 0x3fe03fcb956f038a,
    0x3fe5fc2b321bfd66, 0x3fdf1af12ea9a3c9,
    0x3f910b438713e50d, 0xbfe1f127a669d630,
    0xbfe73df448785f8a, 0xbfe02ee3d7dc3fd7,
    0x3fa75b380267aab2, 0x3fd9e481be2e5739,
    0x3fe8f78bfa261004, 0x3fd9246761e8e504,
    0x3fbe868be0e85c31, 0xbfde18e70e3d6ff2,
    0xbfe560784a4d8230, 0xbfdfa7eaee82467b,
    0xbfb1c616c14dab96, 0x3fe0250216db22a9,
    0x3fe62e523f40dac4, 0x3fe171dd3eff0b06,
    0xbfb70315fe4db497, 0xbfe36140ffd6beb4,
    0xbfe54892cc0f168e, 0xbfe164ec8402163d,
    0xbf954ba4003ddd81, 0x3fdfb31ae75abf11,
    0x3fe6fce676b58676, 0x3fdd985da0e11024,
    0x3f81f744357667f7, 0xbfdf1f172070e813,
    0xbfe4562e0f9b4974, 0xbfe00185f8c000c1,
    0x3fa601fe5b54346a, 0x3fe0a83637679323,
    0x3fe71ee4db787b86, 0x3fe001e85fe9c9c1,
    0xbf82527e9dfa2246, 0xbfe002ea5e7c8996,
    0xbfe6246e7eee28ee, 0xbfe02fb4028f59c1,
    0x3fb1ab6a61238c46, 0x3fdf567dcf2c0f0a,
    0x3fe6d78c9a1eacab, 0x3fddd44c40343f1a,
    0xbf97e7ccd35115bb, 0xbfe0f844ad7292c2,
    0xbfe5775201907ac7, 0xbfe1084735ece8db,
    0x3fb0d24a55ea7409, 0x3fddc18ec4ceb49e,
    0x3fe5e6eff780a9d5, 0x3fe09451903f8066,
    0xbf98483ed5cfbf2f, 0xbfe1aa29f7633bf4,
    0xbfe84a577e11beae, 0xbfe10055393989a7,
    0x3f86325b5bbbb003, 0x3fe075264bee4d0e,
    0x3fe5921cba455b89, 0x3fe04730b42f8d14,
    0x3f896b0ee76d5560, 0xbfdce412e6d97e80,
    0xbfe84494c1862ed8, 0xbfdad0145eaa5c31,
    0x3fb82b686db734e0, 0x3fe1ea99aceaa44c,
    0x3fe7b938ad474cc9, 0x3fe04dd4528e01ea,
    0x3fb09de86d83c748, 0xbfe0934d865b08a2,
    0xbfe6e564a09a0260, 0xbfe0c9db753911b6,
    0xbfb1c2a43e9b89e3, 0x3fde55d0d4fae3c2,
    0x3fe75cc3025ec688, 0x3fe1733dfb8c859d,
    0x3fa2aca7d290cfdb, 0xbfde963d8a73ac44,
    0xbfe50e2cf36a54cf, 0xbfe1f5cda1e3a104,
    0x3fb04a698254c4b8, 0x3fe12a49835578da,
    0x3fe6f9c5451f2948, 0x3fd60df3ee686980,
    0x3f97a0f3630b3b76, 0xbfdbd71ffbb17044,
    0xbfe40f5d3cc82ee9, 0xbfe18e51a4e606bd,
    0xbf810b2f1585f660, 0x3fe0bc20cc6d897a,
    0x3fe470744b38d003, 0x3fdf2c67528a71c3,
    0x3fb3a6a0d79d55ba, 0xbfe02b7429596d53,
    0xbfe6167d0ee85b6e, 0xbfde4465be261796,
    0xbf86c7cdb1ebd303, 0x3fe0a31941df5363,
    0x3fe6d7401e4209b5, 0x3fe17282bb616b12,
    0x3f9a4871b5e8bea8, 0xbfdbfbcd0ccc544a,
    0xbfe656b9af6ec970, 0xbfdc218f1c622243,
    0x3fb56c9475a1c0b9, 0x3fe1c1b2be6d396a,
    0x3fe4b0d3e04f44e6, 0x3fd9c8656e19f859,
    0x3f726cecd2fdc895, 0xbfe1e2e4058a759b,
    0xbfe66702a4ef799d, 0xbfe270852f67bf9e,
    0xbf97e2349fc1d52e, 0x3fdcbb58fb08e79f,
    0x3fea4f2f5a82b92b, 0x3fddef8d9ab57829,
    0xbf81b29a10fea340, 0xbfe0cc5fc65b4e4a,
    0xbfe9acd4ce7b8f6f, 0xbfdcdd4455ce8453,
    0xbfa0c7dd53b36048, 0x3fdccbec616d71cd,
    0x3fe5740a386f6450, 0x3fdaf29e26327454,
    0x3f9c15b9c43326d2, 0xbfdf66753ff99ab2,
    0xbfe82449b1fd47c8, 0xbfdea3433d086734,
    0x3f6feb7f04717c4d, 0x3fdebc7e86539ef2,
    0x3fe65afef22f0d02, 0x3fe37101a1f3d7b5,
    0x3fac236ca522ba7f, 0xbfe3a0a7cf8aaad2,
    0xbfe6c2c2932c8f13, 0xbfe0852cb8c09b5b,
    0xbf9e0cafbd99fafa, 0x3fe155207a7cb1ae,
    0x3fe4fdaae289a298, 0x3fe197434fca9a9f,
    0x3fa7bd029c5a2538, 0xbfe135520c6bccdd,
    0xbfe5ddb53d0cb0d3, 0xbfdbf59f976e7e60,
    0x3f7de626d124f77f, 0x3fe0f41b898fe644,
    0x3fe63bb524ae93b2, 0x3fe13ec5d51370ec,
    0x3f9ac70288cadb73, 0xbfdddfe5113b894b,
    0xbfe5b1c3e3c8734f, 0xbfd944bcc8d7baf9,
    0xbfaa8e4cdd3593ff, 0x3fe06680f91ae556,
    0x3fe64fe6a6a90510, 0x3fdfed7c64ffbb94,
    0xbf61143ce7d02494, 0xbfdb8112aa6b40d0,
    0xbfe64411ee32b144, 0xbfe4ce2278d826db,
    0xbf925b049cec44d8, 0x3fdd1a21d24e8708,
    0x3fe6cda51d1ae9e9, 0x3fe1737a8a852bb3,
    0x3f881b45f5bd042c, 0xbfdc414124d005de,
    0xbfe49bca050bb1c4, 0xbfda37427367f6a0,
    0x3f91e54552b6f5a9, 0x3fe12bc8eac7e5aa,
    0x3fe5c3a7f1f3eb24, 0x3fe05c3694f34415,
    0xbf8cf3bc5f92e9bf, 0xbfe0bc3dca0e6881,
    0xbfe6d00702d78529, 0xbfdf9836c8980a81,
    0xbfa6de4cce433031, 0x3fd9c217fb7a47ae,
    0x3fe6bacd399c5319, 0x3fdef84201fdc0be,
    0xbf653610e81d439a, 0xbfdc0f8439dc9140,
    0xbfe726a26c758a58, 0xbfde98ed255746ac,
    0xbf9b60a6258bbdbd, 0x3fdbd3442c7c650d,
    0x3fead1801c1b03a5, 0x3fe1172b9b5e2d02,
    0xbf9edbf2ce113865, 0xbfddf7b6b6c9310e,
    0xbfe5fee221f39470, 0xbfdfe4d0db43d1c5,
    0x3fab2553b21dac93, 0x3fdbf47336a43160,
    0x3fe5c3ab2ed5b111, 0x3fde72eebd155293,
    0xbfb6d0df7f6081ff, 0xbfe0ceb8abfad8e4,
    0xbfe79a503a259aac, 0xbfdf22d12c055f36,
    0x3fa6767a12aeab6e, 0x3fe1a01a6f439b7f,
    0x3fe87fe1c9d63cc6, 0x3fe086144caa0285,
    0x3f92ade830a3b094, 0xbfdb6f1ea5f87822,
    0xbfe6ac4516e2d545, 0xbfe1bf8fe76c358c,
    0xbfa3bbc15e3b9e38, 0x3fdf5b226a3cc62f,
    0x3fe3d4eed36e2c96, 0x3fdc76d05895cfe3,
    0x3fb730fce35d89de, 0xbfe0bb730c04f669,
    0xbfe7a401e481eea4, 0xbfe06cd60799b09d,
    0x3fa6d09bfadd776d, 0x3fddd12c7a677ee1,
    0x3fe6de50e1d77be1, 0x3fdcd20d9546e045,
    0x3fb6ed57e74668db, 0xbfde6130d12e9340,
    0xbfe5c68f352d7922, 0xbfe070ae5b85b1ec,
    0xbfb2dd1032361c05, 0x3fdd9323a528cb28,
    0x3fe6e590cdf3ae40, 0x3fda6d5fa3d0f600,
    0xbf8a4a49b2e45682, 0xbfe1a46f96f25c57,
    0xbfe43cbf4510e5be, 0xbfded0fd51e5eb0c,
    0x3fa033ad21aa5c92, 0x3fdd78833e572325,
    0x3fe4964bfef2ba98, 0x3fdc14fc56791707,
    0x3faf87146501efe4, 0xbfe099c33aeb92d4,
    0xbfe97902dc56cceb, 0xbfe06267b66aca74,
    0x3f9d72563d4b0fec, 0x3fdf0e84c7a1cbc2,
    0x3fe62137b502b559, 0x3fe01c6dd4c15433,
    0xbfb249e99d6adf3a, 0xbfdfcf347c314bc7,
    0xbfe69ce6f7088920, 0xbfde3641c1937807,
    0x3f96220513774e99, 0x3fe24d69560d7acc,
    0x3fe7cd99b71be115, 0x3fdd71d47ff73761,
    0x3fa23229681fc4a9, 0xbfe0d8aada04ce23,
    0xbfe692ee387dd8a8, 0xbfe011525d0aa126,
    0xbfa623a0fdaf0105, 0x3fdbd9df7e934bf6,
    0x3fe4ab420c7d3b9f, 0x3fdaee5e1611772d,
    0xbfa2083403eeb94c, 0xbfe1094c17a31ae2,
    0xbfe6c7753693d4c1, 0xbfd9ee39605c45ec,
    0x3f835de9107b1a57, 0x3fe0372df688638b,
    0x3fe6f38dc76ad3c0, 0x3fdcd07fc44abac6,
    0x3fb0216757de8521, 0xbfe00b7be82e4e6c,
    0xbfe6be38a9da7fdb, 0xbfe0ad6d706d546f,
    0x3f9b11b64ef758a1, 0x3fdda5223f22212b,
    0x3fe625000f35da6c, 0x3fe0deb2e36b7b13,
    0xbfb4f9468211c3ee, 0xbfe13964ac887975,
    0xbfe6f13c37813884, 0xbfdf4db9feedb31b,
    0xbfaf19fc2d4e8097, 0x3fdcd003d0eb6e0e,
    0x3fe69d739c5b3605, 0x3fdca397b971c98e,
    0xbf950a407eccdd7b, 0xbfdddfc4885fcfdb,
    0xbfe6ab1c35230821, 0xbfdd3f0546049184,
    0x3fa448d580842145, 0x3fde3e4bb2cc2e32,
    0x3fe68424dc301893, 0x3fdac33f2803cf21,
    0x3fab4243ab65f9ac, 0xbfe061c4e0e779a2,
    0xbfe7e272b33558b8, 0xbfe04e807c27e94a,
    0xbf9bcdfb7c899e82, 0x3fe06c8da371fd94,
    0x3fe92ce888585596, 0x3fdb2f48a1fe58e5,
    0x3fa03b8eb27d4584, 0xbfe22c5e79e2f2d2,
    0xbfe55c88c7c3a0d2, 0xbfe2c4e20639e186,
    0x3fafbea490ee29bd, 0x3fdf345e3aeaa527,
    0x3fe51a7a29010228, 0x3fe0abeb8323118f,
    0xbf8fb9276168791f, 0xbfdbf10ef405d75b,
    0xbfe9097e9e08bfde, 0xbfe119c9d1114ea9,
    0x3f76514ae5d853e1, 0x3fe1cdd3d48e6cdd,
    0x3fe68db7bdc0a179, 0x3fdc5bd663dd0e52,
    0xbf9e2973bb7e4aec, 0xbfe0117c12752dce,
    0xbfe65de1977cf835, 0xbfda423e411677f2,
    0xbfab78978edeb3fc, 0x3fdd89473fd927f9,
    0x3fe7ae304b09a43b, 0x3fe1658e245eb232,
    0xbfa6bfeee58b865a, 0xbfe117442e4f70cc,
    0xbfe46544bd26f8e4, 0xbfe1f4211189d732,
    0x3fb5f0a1bf531a33, 0x3fe26d7fd99af811,
    0x3fe7e0482af2e001, 0x3fdccdc7e83e8329,
    0x3f92225de0761f4c, 0xbfe108ba46185e62,
    0xbfe5760aed583922, 0xbfe13e458f511e61,
    0xbfa4e30edaa498dd, 0x3fe2b8226e2511c4,
    0x3fe899849eb0b1c7, 0x3fdcf6316cbf3910,
    0xbf8632ef4e72f996, 0xbfe3b43ab88ceeb2,
    0xbfe612ca1e2e730e, 0xbfe0225df066ee5a,
    0xbfaf1922619c16e3, 0x3fe20fd525752327,
    0x3fe32cce31c2c620, 0x3fe124b373b41d22,
    0xbf9ee4f117da4b44, 0xbfdf25b0be716c63,
    0xbfe64d8763fe6633, 0xbfdcb68e152df8b6,
    0xbfb3b82d768dd035, 0x3fe179610c5fb989,
    0x3fe56f608b0740f5, 0x3fde8c1863f78455,
    0xbfb2cc3135725ff4, 0xbfdc575228cb6d1e,
    0xbfe3c3540bd2f92e, 0xbfda008943db8271,
    0x3f785eec956f75f6, 0x3fde42aa1e059f1e,
    0x3fe7cb175c5af4b8, 0x3fdfe63db25a1034,
    0xbfa97a5a756cf564, 0xbfdfcd47918af3a9,
    0xbfe6d2ffc746241b, 0xbfde55221c208d85,
    0x3f822f8bfb816b2d, 0x3fe0522f9edec64b,
    0x3fe62420fc2a1205, 0x3fda0d898bc46bfb,
    0xbfa35222c091561c, 0xbfe2626b80223414,
    0xbfe5380fa6699f0d, 0xbfdca97d371165f4,
    0xbf8ccd3ae6c8bb6d, 0x3fdd5d5b1deda31c,
    0x3fe626fcb5169832, 0x3fdffe81a042b7c5,
    0x3f7ceb8a62c408e4, 0xbfd8813ad4ec5539,
    0xbfe6dd0f347d85b5, 0xbfe1fbf6b1e6f943,
    0xbfa561eb4a59577a, 0x3fd99ab3ffe190b5,
    0x3fe63ff30d0f881a, 0x3fdc93332b3af1b5,
    0x3f92733a3b3b8c4f, 0xbfde1064267e9562,
    0xbfe5789382d3332d, 0xbfe02f26758c7ecb,
    0xbf8fff82bdb4afff, 0x3fe099f658abb7d3,
    0x3fe6dc0fef840fc0, 0x3fdd261253a0d662,
    0xbfab4b4d6151ac5d, 0xbfe117f2455ae306,
    0xbfe69832ce241e00, 0xbfe361a46975f191,
    0xbfa9efe7262bbdae, 0x3fda9fe8f6702785,
    0x3fe5a568111b75b6, 0x3fe062a101757a64,
    0xbf6666b383614090, 0xbfe14c8f20132b38,
    0xbfe56b5c8e044922, 0xbfdf7a9f48cd36fa,
    0xbfad33c13be1651e, 0x3fe10ed720ce28fe,
    0x3fe63dc84025d691, 0x3fd8b03fe21bcb7a,
    0xbf99688243881214, 0xbfe0251f6edc5efa,
    0xbfe6a2731bbb5dac, 0xbfe05fb2f9ba3809,
    0xbf54ccb2543c949e, 0x3fdf9dcdeed5be1a,
    0x3fe7ddb4a0207fd0, 0x3fde67b87717eadc,
    0x3fa084ca0793759a, 0xbfdffd5ebb9aca78,
    0xbfe27c8838eb446f, 0xbfe1bed5eb591bae,
    0x3f503b0ba9406be8, 0x3fe3bec8c75e66aa,
    0x3fe8aa4bd011035c, 0x3fde70dd85d9b3b0,
    0xbfae104b19160f8d, 0xbfe121fb906fd7e6,
    0xbfe967ed75c5b795, 0xbfddafb27b326246,
    0xbfb0ea14938b2c6a, 0x3fdd9b86fd22df02,
    0x3fe5675d41e70141, 0x3fde433d8652614a,
    0xbfb20b6f5cf77a5e, 0xbfe00d0777071366,
    0xbfe595278e390fe1, 0xbfe22fbaacbe0ec3,
    0xbf7eddb2a931a037, 0x3fdfa4dee003460b,
    0x3fe48949d49bf595, 0x3fdfe0fa5d92cb19,
    0x3fac89ca0278f8fb, 0xbfdcec3a100a88b1,
    0xbfe60e68830be277, 0xbfe0df64c2a0f651,
    0xbf9137403ba1d6ed, 0x3fdb1ed97e5e34a5,
    0x3fe565541b7d70c5, 0x3fe012cf388c7666,
    0x3fbdea891dc7ec0a, 0xbfdc55f2ec69abcd,
    0xbfe5a9e729f9c61d, 0xbfd9c9b97aea1621,
    0xbfade623c6432c1d, 0x3fddf7e31be564e6,
    0x3fe4e264a7872cde, 0x3fe27a5ebb9db93a,
    0xbfb443ec796f21b1, 0xbfdfeff7134a6046,
    0xbfe4f4d26c70fc52, 0xbfde0f41298553ff,
    0x3f8e09d828265d4f, 0x3fe180156350c948,
    0x3fe808994a3f0f23, 0x3fdf5c1166eff8bf,
    0x3f742d4ce6366252, 0xbfe1a191e6fa610b,
    0xbfe89507d94db855, 0xbfddbb4576d57c52
    };

static const uint64_t in_rifft_noisy_4096[4097] = {
    0xc00ada05db8ecc9e, 0x40085bb07d074562,
    0xc006a1903c67d7c2, 0x400b901cafc705fe,
    0xbfe0a84a0db6bb0a, 0xbff358360c005e30,
    0x3ffaaa37eb686be2, 0xbfed04f1d3dc3e48,
    0xc007f1de29fb936a, 0xc004b423a087d058,
    0xbff6a9923068a898, 0xbff97cb6c2ff438e,
    0xc00525ff8ec1db1f, 0x3fd0972b464b1ca8,
    0xbfde019e83458cf4, 0xbfebe7e26cd694e0,
    0x3ff86e96d1b9de25, 0xc0046f09757d79ae,
    0xc00e6eebb57f15b2, 0xbfd5b55fd0ad6386,
    0xbfebb919e5f42b8e, 0xbfea1ed645854b99,
    0x40054f4cb2ee20cc, 0x400a2bbe9ca4d955,
    0x400b1b02c8987464, 0xc010d041c874d5aa,
    0x3ff1b79f361f42aa, 0x3fb391effef54f19,
    0xc012777ef521054e, 0x3fe6c66fd53ce579,
    0x3fd3c34c67c31f84, 0x400b3fe39a93f250,
    0xc00221b8ef5e3a80, 0xbfe6a925742f8da5,
    0xbff21632dd8dc070, 0x3ff0c9c1680dde04,
    0x3fe3b946b6763081, 0x3ff4b1b25d3bab17,
    0xbfea85301f7619de, 0xc00583a260efce53,
    0x3fff4dc7c348efea, 0x40055b3b77c6dbd8,
    0x3feb224f45ba1833, 0x3fe6fdea5caa6e61,
    0x3fff6c00e2a18026, 0xbfc4c7972061c068,
    0xbff25e4e5f33450f, 0xc0064d8f2552c9cc,
    0x40017c20d9f03d66, 0x4003147b7e83e8bc,
    0x400c91e76575ea27, 0xc01004442d8284e6,
    0x40101665cab474ca, 0x3fed88502f726aa4,
    0xbfe884a035c45bf7, 0xbffeb3d5a846aeaf,
    0x3ffd87cb94ce14da, 0xc0023930d9fe687d,
    0x3ff31c54e4d50b70, 0xc0055b34833cb5f5,
    0xbfcbf94f28da5600, 0xbfd7d5d94a468aac,
    0x3ff41266dd35052a, 0xbfee9e3eeae43203,
    0x3fe73d56f1c24014, 0x3fff57c9050c920a,
    0xc0065017e8448b23, 0x4005f6cbb9364168,
    0x3ffee25a10af4042, 0x400acd2596a0f27f,
    0xbfe01d9588a4ed47, 0xc004b7dff1219644,
    0xbfe61c92debedc3e, 0xbff348a8f2a93a52,
    0x3fd27b194896da82, 0x3fc8fe622d479bb8,
    0x400714999595f502, 0xbffe85479039919c,
    0x3fb55ef77f7fd3c8, 0x3fec4e2f1e343e62,
    0xc0003f5be65a8f12, 0x3ff8a137ce3f59e9,
    0xbfdb797fd2bd0749, 0x3fdb8a2049509f58,
    0x3fd494f85d2e6d45, 0xbffa477344657a76,
    0x3fea19eed58c1e50, 0xbfe89e1cfbe35b80,
    0xbfa2a94df0c658f0, 0x400585f64e41fe1e,
    0xc005a649dc88b323, 0x3fd0aab8e0423d2b,
    0xc00af94cb8c9689f, 0xbfdaebd89dbabde6,
    0xc0055950a6325ce1, 0x4006cec1d22cebb8,
    0xbfd3bab104e637d8, 0x3fe5835efedfbe8c,
    0xbff47e73c5dc46e7, 0x3fb4450a30070580,
    0x3ff22998a35366ee, 0x3ffa734923ecf652,
    0x3fc19fed702dd5e0, 0xbfe306ae2bed9909,
    0x400b06c87be07f50, 0x3ff01f8364d8b723,
    0x401212651ab79ec2, 0x3fd0046224943df8,
    0xc0064d092737435f, 0xbfc774991f1ed6b0,
    0xbff268558ce83e39, 0x3ff2bd8aa081be1a,
    0xbfde12463e5da00a, 0xbff21ad7a75c3899,
    0x3feadf7c1e850ea6, 0x3fe66e695ac5db3d,
    0x3ffd016bf066f5aa, 0xc00da3e5faed69cc,
    0xc005f99b6a69bbd9, 0x3fe34dc28d46f581,
    0xbfea6869a1d48994, 0x4000c3cc7e25e282,
    0xbff5400031be02ce, 0xbffb486bdb12a173,
    0x4000d40c65697d8e, 0xc002744d80601e40,
    0xc0048296915c02f0, 0xbfcac6c6cde7bc8c,
    0x400aa061c9c32346, 0xbfbf9ce6ed0ae760,
    0xbfec4f8a72f1d87b, 0xbff006f4f1cd0b5b,
    0xbffe21244ce7391a, 0x3fee739ed63f904a,
    0x4004cfcbd7bc2484, 0x4008886d979b7144,
    0xc018170930d5f952, 0xbff511d1e4b4b17c,
    0xbff91d1e890078dc, 0x3fcefea70c7a8584,
    0x400e420acc04d88c, 0x3faef16261c18f60,
    0xc00cba2e8a70fe99, 0x3fd67f068ecd1faa,
    0x3fe0c42b9df6d8a5, 0xc0088ea854cff52f,
    0x3ff85340bc330f7e, 0x3fe4fe1d840ea18e,
    0x3fe49b3e9f49221c, 0xbffb78e133ef69b3,
    0x400328a776b8bcf2, 0x400585b56f9d4580,
    0x3fc495cb241c7618, 0xc002a64793942d96,
    0x3fee1bf14e774069, 0xbfeb376a4b1be88a,
    0xc003fac79b59ba8c, 0xbfe0c8e461cbad54,
    0xbfe7fe11567070ea, 0x4005e07f7f427c81,
    0x3ff7a99774428806, 0x3ff566a6a6c62105,
    0x3ffac0a970d14d18, 0x4007dfd6cee7f4a2,
    0xc013d55fbf93efd6, 0xc0110c4fa3d35ac2,
    0x40091b09c1ed98c7, 0x4002c4c63a2b3c7e,
    0xc00261dbaa3f608b, 0x4002d897d3334a1b,
    0x3feeb65ec522d85d, 0x3fd933feda9bf31d,
    0xbff464b7ef25389e, 0xc0049cd89364dfee,
    0xbff76741785b8838, 0x3fe53278fb7a8563,
    0x3ff1675489940138, 0x3fc94df69b62adc0,
    0x3fb449e7dc53d458, 0x400e8b09e49fd89b,
    0x3feae7f2cb24d39d, 0x40079acce85984b9,
    0xbfff3d57c3bc623a, 0x4015d4fb17677b12,
    0x400898a007850720, 0xbff60ce4a63304f0,
    0x3fca959d60f06e34, 0xbfff4bd0d58db400,
    0xc005bbd8950da918, 0x3ff906a905312300,
    0xbff32e34ef2e2a27, 0x400051b65ca6bce6,
    0x3fc38adac9644490, 0xbff29f7d17b52113,
    0x3ffd429c8e81d2b4, 0x3ffd369d16b8dd96,
    0xc00119a6db0b987b, 0xbff99e0539a9fc04,
    0xbfe0aca4d8a16bde, 0x3fca9ec8f24cf688,
    0xc006f3c509a2bdec, 0xbfd3d360eba2a0a1,
    0xc00758b15fd94a24, 0x400176fa55cfe73e,
    0x3ff562fc2ead1299, 0x400139898086f3c3,
    0xc009d2ac85c7beea, 0x4008e8486d47d15b,
    0xbfd0caa6d1553fd0, 0xbff219a0e58a4ab0,
    0x3ffc798b080e904a, 0xc017b5af7f4add3a,
    0xc0074e15fc1070b7, 0x401b7b0a84169049,
    0xbffbaf1a18b82e6d, 0x3fdff6235a1c9cfc,
    0xc0039a2fef64c234, 0x3fe9043bf7584c47,
    0xc00e71e3ab1ac6f1, 0x4001f4377581ce3c,
    0x3ff710936ee41b0c, 0xc00b7dea643edb3e,
    0x4007d2f07d73c642, 0xbfc4a27fe8bef0b0,
    0xbfe1fa1ea69f0fd8, 0x4000685dc1913f74,
    0x3fffe9970df9bfed, 0x4015e17bfcbee669,
    0xbffe163614251f2f, 0x3fe5ae4a262c2e23,
    0xc001b7b377c6d93a, 0x400888d95736025f,
    0xc0023993c60fd50c, 0xbff0c52e01d1927e,
    0xc0043ad540cb7247, 0x4010234a1db10abc,
    0x3ffeaa29cdf081b6, 0xc00f4486fa56a8de,
    0x3fe2dd6b39f9c997, 0xbfe271cb29968b44,
    0xc00f5fb2f5d48b98, 0xbfe341d9d480ce69,
    0xbff46b2273b05c9a, 0x400d0ef40d5712f6,
    0xbfe01414a89a9358, 0x4002eb16781f0b6a,
    0xbfc98c60e1083904, 0x3fdc21a362805e2e,
    0x3fb60fcee2b74460, 0x3fee15fc32908ed8,
    0xbffca9bdc1949538, 0x40130444a0e411b0,
    0xbfe15b0776c90bee, 0x3fffc55346697a65,
    0xc0011c153e610280, 0xbfe8fc4737cce8dc,
    0x3fec46fbc7c6eebc, 0xc00f9739a51fcf98,
    0x3ff569391917bed1, 0xbfb7551b1aa95ca0,
    0x3fb0ad66baca8910, 0xbff34c5a3c17239f,
    0x3fe54d28ed25ede4, 0xc005b3ae7892062a,
    0xc011707ca2566f16, 0x3fda6b9773609820,
    0x40089d0334444432, 0xc001a0efe9a27bd7,
    0xbff342a20a4d799a, 0x4004a12d79c04088,
    0xbff34ca3372619eb, 0xbff0254389815218,
    0x40134a206c381510, 0xc0044e2e5df3597e,
    0xbfe7366c6d947db5, 0x4003d4ee617a1980,
    0xc010da54ee8c093b, 0xc015d4fe86cc583e,
    0x400eb20c90427f29, 0xbff57b14a1abe217,
    0x3fcde4882a539b6b, 0xc0057c7470cbd97e,
    0xbff09d6290e6f2da, 0xbff6615dd5248f7a,
    0x3ff57c9cb36dc934, 0x3fc442e80ca3f530,
    0x4000b32ef97af6ee, 0xbfb25f1038a4e768,
    0xbfcdc89b7a4f3cb8, 0x3ff8b0be8f24f365,
    0x3fef247f10d3fcc0, 0x3fd3bb8d209db42c,
    0x3fecac3b97363f02, 0x3ff8d67b8283db02,
    0x3f97ab573a2d18c0, 0xbfec5d32e5a6be00,
    0x3fe5d2b2f1bfa6f4, 0xbfd53a709faa0b9e,
    0x3fed990e9cb274c0, 0xbffa600dfc18c753,
    0xbfc510d37533d5e0, 0x4003684d7743b028,
    0x400ee37288fea35c, 0xbff1573c40aa8ad1,
    0xbff2d521c0e6bcc7, 0x3fe095dd52a80477,
    0x3fe1154226cd1ef6, 0x3fc63ee85d50d820,
    0xc00c4f27dd02ee35, 0x4005190e75a6b931,
    0xbfbd1f93907c2d50, 0x3fea293398d7c54c,
    0x3fe71e5389b562ac, 0xbff8e28b06290f32,
    0x400865cfcd9f1b60, 0xc00212e16f70eb9f,
    0xbff57ffa50a2644c, 0xbff2ca1dfe7d7fc1,
    0xbff50e0efafba13c, 0x3fff2c6f8d10873d,
    0x3ffed5cec9a041ef, 0x3fdfe59187d51e04,
    0x3ff1d7f9f4d073ee, 0xc00bf5a065c7da88,
    0xbffff76994602c49, 0x3ffce79f21d1c275,
    0x4017d1d3c9da926f, 0xbfd68562fc8a6c98,
    0xbfc8d651586d1650, 0xbfe0c258e4918534,
    0xc003d58ffb8a1d53, 0xbff08ab2ccb9d7fc,
    0xbff43c68d741e699, 0xbfe9ece15a072a75,
    0x3ff13622e83cd2ee, 0x4000d8acb828c446,
    0x3ff4674b595e74fe, 0xbff6330a65e82816,
    0xc00b45ed9535b8fa, 0x3f8513297e9536c0,
    0xbfa6716316c23380, 0x4009a57928524f00,
    0x3fa0c83f077dc380, 0xbfefe81d4bd171b3,
    0x3ff48df5f20e4395, 0xbffe7e7988b987a6,
    0x3fdbdaa3db77a5a4, 0xc00155408e75ff0c,
    0xc009df948c2274c1, 0xc003e192ef6d3e84,
    0xbff45b4ab46f2968, 0x3feaca7eed9712b3,
    0xbffd9428d27106b6, 0x3ff6d995228a2905,
    0x3fe231cdee7967ec, 0xc001cdee2953eeb6,
    0xbfbe24c7b4cd2c10, 0x401143970dc6155c,
    0x3ff155efa90a7bed, 0x3ffcb9eb52102dcb,
    0x400d229d295945b8, 0x400092dd570b3712,
    0xbff04b24605c7ba6, 0x3f68941b8e789c00,
    0xbff4c85643a39e64, 0x40165ff1ef852648,
    0x3ff8abb723b784ca, 0xc00b6bcfdfe28961,
    0x40035c1b6a2727d7, 0x4001381fd583d024,
    0xbfe31d221cb95190, 0xbfe74cb78cce5b5b,
    0xbfcc20d4efcc83f4, 0x3fff6c1a3ddce4e0,
    0xbff97ff4b9268f11, 0x3fa2cba1c9768b00,
    0x40075957b79a24d6, 0x400446d17f8a4ee8,
    0x3ffa4d02df810288, 0x40043cce6b000f29,
    0xc002536f9cb5e0de, 0xbff13925d0cd126a,
    0xc0064c461c4ade88, 0x4000be43b0968e47,
    0xc00a9b5e6a523c63, 0x400bd9eff45fc757,
    0x4008eae9b8d90e58, 0xbfd65ee0a22ef8bc,
    0x3fd342d1a3b85698, 0xbfff12182425dc00,
    0xc00dbc5bdd6456b8, 0x4001f27a8b39b6a5,
    0xbfe9186b45e8f3da, 0xc004521f33a27d12,
    0xbf9f655f1f162610, 0x3fdc282df2c9cb46,
    0x3faf297a5d9aae30, 0xc005466054e3332c,
    0x4000914f865da3f7, 0xc0118920eb7f416e,
    0x3ff8315f8c838e50, 0x4009900e232011bc,
    0x3ffa29fab7c953f6, 0x40060014b45f1bd6,
    0x3fed00903aef4bd5, 0x3fe6f77dc0efddb2,
    0x3ff582a7d9904ef0, 0x3fd97eaae0dfe148,
    0xc00ad62dc706c3a8, 0xbfd425f4e9a51e22,
    0xbff42029dd34ef23, 0x3fdf2262b7e342ac,
    0xc0078e43a65d70ee, 0x3fff38a25b01b86a,
    0xc0014dbd72faa609, 0x3ffa6d5dd1cb503a,
    0xbfff5909432fbc5d, 0x3fa50bc485c20ac0,
    0x3fe08586f78cd690, 0x40008cc2daf75919,
    0xbfd170821accdf8e, 0xc00c0e45dd45aa04,
    0xc005416af26099fc, 0x3ff938d6c8bf60b6,
    0xc01312cd5fb42d1a, 0xbfc656614f41fef8,
    0x3fa90fc7514eb530, 0xbff6e62dbf0c6575,
    0x3fd17b981a1389fa, 0x3fef2229a5f9f977,
    0x40013e58b3ea190a, 0x4010cbaac646a558,
    0x3ff6d2535dc3167b, 0x3ff9a4d6e6186377,
    0x3fe246b844588a64, 0x3ff3d8d420f6014f,
    0x3fe5c7293815dd20, 0x3fb5cea3210e7594,
    0x3fca0b59bdc1f510, 0xc00e16016cab8bec,
    0x3fddab266bc783e4, 0x3fea0aa8eb68371e,
    0x3ff3293bf5c19acc, 0x4009aae2a5d8d0c2,
    0xc00544aaff5bb36b, 0xbff5cebde63e2166,
    0xbfdd08b14c046e06, 0xc000c0ed043fda46,
    0xc004da65d3cd012c, 0x3ffa20a00bd9db98,
    0x3fe4c929b2eb9788, 0x3ffe38a037126a64,
    0x3ffabee05eb778dc, 0x3ffbb07717abc281,
    0x3fe19f115878b36c, 0xbfe0cbc3e4e767e5,
    0x40037814ba734e6c, 0x3f5893cede09ea00,
    0xbfd6c1227868081c, 0x3fe10ab582f6a86f,
    0x3fd75afe261531da, 0xbffac2b9bdb6e850,
    0x3fea8ae38da8b637, 0x3fc718b86d2b6a90,
    0xc000b8cc4eb47fac, 0x3fe02cbc8de8fdd5,
    0x3fb963dc507e7c80, 0x3ff50eed791014e0,
    0xc0033f727d14b9c0, 0x3ffdf4096c7dc9b7,
    0xbf856ad75baa9580, 0xbfe2fee6d2306982,
    0xc002ee0d305ae73b, 0x3fff41491d5324ba,
    0xc006e7d0fe40bcf3, 0xbff3e45d04e0c9f0,
    0xbfce397a1d7a70c0, 0xc00f89d780cf8566,
    0x3ffbde638a8f5bf8, 0xc0053536ed13a03e,
    0x40086c69cb14220c, 0xbff27815d25eead2,
    0x4014bd40ca6634fa, 0x3fd787f6cfbc6f6c,
    0x400382861797880e, 0x3ffe5b28af20ef85,
    0x401174130a2e1de2, 0x40013886729a856d,
    0x3ff0edaec9868248, 0x3ff9d370f36cc2ba,
    0xc007837237b32ec0, 0xbffe2002c5ae3392,
    0x40007425bff897a9, 0x4002f50756c04e0d,
    0xbfd4fd21f182da52, 0x3fd5020125a91a09,
    0xc00a8f81204da6ed, 0x3ff208ffd2cd1840,
    0x3ff25e2994f87084, 0xc013e9fd65d749c7,
    0xbff5a91534307d1e, 0xbfda2e1d8e4a33d8,
    0x3fda205108265170, 0x3ff2cd7010816bff,
    0x400a3e90f776265f, 0x3ff96eba3e881bed,
    0xbffeeef5d0d7dbf8, 0xc005a2edefa883c1,
    0x4006072dd3d9f63a, 0xbfe1c2460698e3b1,
    0x400987d6b33ec3ce, 0x3fe7cc75dd5a5ede,
    0x3fe632d4fc7b3b08, 0xbff3edd26227f674,
    0x40115c4058d0a323, 0x3fed52e1fbb837f2,
    0x400f63ac68726f0c, 0x3fefd9996bd00fae,
    0x400a5665149c3966, 0xc007851c3d1fe800,
    0x3fd5b17fbd2f8c5c, 0xc00ed0ebe9a8ef53,
    0x3ffaa8aaa94adcbc, 0x400db96b387fa902,
    0xbfe43d612952f19c, 0x3ff5d80e7a93b2cc,
    0xbfdb4d8cced35de0, 0x40104b78a050e872,
    0xbff2d375fec62d50, 0xc0001add489cccc4,
    0x3fee82b92a063f8c, 0x3fdd832c97b91caa,
    0x3fb083ecff18f580, 0x3ff9c4ab9f0b24d2,
    0xc01932bfae2afdb5, 0xbfd661a770529588,
    0xc00ee154a1a426e4, 0x3ff9fac2c1af3874,
    0x3ff61714630353fa, 0x3ff49774e2810cac,
    0x400e2661b4ee0ef6, 0x400d7a05c44c198d,
    0x3ffefd038fb80c9e, 0x4003c86d9ae79a13,
    0x3fd13513fd36bece, 0xbfe91f50fbd67c4a,
    0x3fe81560acbb8dd6, 0x3ff88265534a9966,
    0x3fb145ac2d7a4e2c, 0x3fe619b06d4105c9,
    0x3fdafda654104736, 0xc009810b27f2beb7,
    0xbff8fb97f14a95db, 0x3ffa43301fa7ece1,
    0x3fff637e0f5f0d1a, 0xbff3c87d638250c4,
    0xc00460210516627e, 0x400433f7f8497961,
    0xbfe5fa152ffd0ce2, 0x400edc4b4423e58a,
    0x3ff1210290983662, 0xbfd7b49413c6f5a8,
    0xbff8b9953841a651, 0x3fe6722805c4a95a,
    0xbfc018e36fdad8b0, 0xbffbaecce77a2846,
    0xc010804a05b8322a, 0xbfccbf74b51894d8,
    0x3fd3806540b6f440, 0xc007af8403ebebd0,
    0xc00fcea59ee8477e, 0x400c93e75315157a,
    0xbff430f0ccc1b643, 0xc00ca68d5afcaf67,
    0x3fffecdf1891c9bf, 0x3fbd45beecac7698,
    0x40089ffaf0d82914, 0x3ff671d6b7dbc454,
    0xbfe0c30c7e2e90c2, 0x3fdc4d968b068550,
    0x4003f6c32f3f4815, 0xc0074276711e5ca0,
    0xbfdeab590407defa, 0xbff8af4b853a05d9,
    0xc0146917bed300a2, 0xc00dbbd176e9b422,
    0x3ff1f9babd06bf21, 0x3fdbec1c338d1e98,
    0xbfc7953077b01bb0, 0x40007a9a6bf77c2a,
    0xc006e97e7627bb42, 0xbffe3d510570ec27,
    0x3ff4dddb45053f63, 0xbfc98b6915cddf88,
    0xbfd096c4106b0e32, 0xbfe73620c85e73d8,
    0xbff083eba55bdfc7, 0x400badf35fccfd0c,
    0xbfb04ae53a485dc8, 0xbfd617ec1810995a,
    0x3fe53a8d8b54571e, 0xbfda281be61e6d3b,
    0x3ff3e2ac063a147e, 0xbff06ce0c929d07a,
    0x40019fbe5a27d97a, 0x3ff21806386e160a,
    0x3fd6ae4574fd37fc, 0xc001f8f933b6f42f,
    0x3fee967c7b736290, 0xbff25d86bd513d8f,
    0xc0045dbbf1118b16, 0x3fed3801f7c2fccd,
    0x3ff161c4429f0b7d, 0xbff771e24cf01821,
    0x3ffb572488ec83e2, 0xbfcae67480d2e8a0,
    0xbff3f615b41eee3a, 0xc00175b59029193a,
    0xbff672a9979abc06, 0x3ff8c2c1e4920a6c,
    0x4012970709eaf495, 0xbfcec7668947bd68,
    0x4006c6d541ea241e, 0x40019ef3ee33a74c,
    0xc00948fe4ac992f0, 0x3fee150ffd53fcac,
    0x4001aac6d88f5422, 0xc007d186e42e8e19,
    0x400163c392fc2106, 0x400a5f7234e25064,
    0x3ffe067df256cd32, 0xbfd56d3807e83894,
    0xc0132100c2fc1474, 0xbffebc43439a4b86,
    0xc008c0a500d5d956, 0xbfde7256bc35bc38,
    0xbfd7334389913261, 0xc0023fd1402c8475,
    0xbff768bd50902f22, 0xbff19d2adb1e73bf,
    0x3ff75cb43afed7bc, 0xbfeb0e2b9b2b1628,
    0x3ff0193a2a1f8b1e, 0xc0165f4b53e5dade,
    0x3ff5aeff64aeabbe, 0x40166cbef49a8288,
    0xc0068d8592e06dc2, 0x4001298279c76876,
    0xbfff314570f6e35f, 0x401c43f667cb5032,
    0xbff26eb1b435ae24, 0x3fef6e7bbeef97ab,
    0xc004a21e9c6228e3, 0xc002c061c8463c99,
    0x3ff040048edb5b91, 0xbfefa80b38f76cc4,
    0xc003a3c08eaca311, 0x3fec10febc7b8d74,
    0xbff79413bd969c1b, 0xc0118ce764e98de1,
    0x3ff06d5854182de6, 0x400467c6bbe21983,
    0x3fbca838cbbbacd0, 0xc00d437e15f5fed2,
    0x3fedf771399ae08e, 0x3fecd890c79f3ee6,
    0x400eae9903517f20, 0xc0077de9b802e612,
    0xbfe59fcdeb84e92e, 0x3fc65ac63dd9d180,
    0xbffcf49f3acb8ed6, 0x3ff4aedc898f0a75,
    0x3ffcae02e0a319c5, 0xbfeb319bd368c197,
    0xbffb65945b7d0312, 0xc00f5218ef536081,
    0xc00585ae0fda358a, 0x3ff196284dc0db6e,
    0xbfebf110d405b676, 0x3fb874eb51d93a78,
    0xc00461582c324158, 0x3ff55c529976534a,
    0xc005afd77186fb64, 0x4006569ef49e7db8,
    0xc01cc983103bef82, 0xc0168b87e27645e4,
    0x3ffcb3709c7442f9, 0xbfe1027889a4020a,
    0xbfe7a1de064b8762, 0x400c9a00a486b9d1,
    0xbfd960fb093f9a52, 0x400579a8936af0c0,
    0xbfbc307a1c5c3280, 0xbff233628887f630,
    0x4004fa4b8b8603e0, 0xbff5edc9af040e48,
    0xbff510985b91afbe, 0xc00d457b73ec156b,
    0x3ffa0fc5111db999, 0x4000cf717ee37f5a,
    0x3ff5c8def951af16, 0x400443cfb41c5d4c,
    0xbfe2a7ece143ff45, 0xbfeebcbf1ba848cc,
    0x401512718f65c33e, 0xc003b142cd53da4c,
    0x3fea5264739d20ba, 0xbfe2483b01cedae7,
    0x4001837c3635044c, 0xc009268290ff8f59,
    0xc004ca7ae5e1a741, 0x3fcc8cd169be09b0,
    0xbfcc5d44b630612c, 0x3ff1b886a9994dd3,
    0x40045a21edd91475, 0xbff6114ef81a26f1,
    0x3fe4bb764baf9130, 0xbfc9f07caaca8bd0,
    0x3ff538d4c7c7cec6, 0xbff100ee79ec1536,
    0xbffa43d237aba7d9, 0x3ff7104c2095e5be,
    0xbfae923612b4b590, 0xbff9c6951ff16005,
    0xbfddbf8fda2e7eac, 0xbff50cc80f81a665,
    0x40118f59528c76fa, 0x3fe56114f5027134,
    0xbfe2a6ee626bc0e2, 0xbff4fb2300401556,
    0x4006f2769779ba1c, 0xbfef90333dcaa030,
    0x3fe424baf72ba55c, 0xbfce7bae9c682180,
    0xbffb066a9371c22e, 0xbff5aaad6bf45e33,
    0xbfe5fd7e4e9bac38, 0xbfe0a421afe8f70c,
    0xbff3cc3b9dbd026a, 0xbff2412e4903a50c,
    0x3fe1de3a61f62cfc, 0xc00dddf3c644cc07,
    0x3ff787b3659ee5f1, 0x3fe60ea0010adffd,
    0xbfee7aa68385a9ff, 0xc007e012500c9410,
    0xbffed74d9efdbaa2, 0xbfff8ffdadf187d4,
    0x3fef5647ed6da750, 0xbff77aee1cc0eda8,
    0x3ff216755b966800, 0x40019a9932435ef0,
    0xc01e0869e000ace2, 0xc0036538bf8f7259,
    0x3ff4cc0ccf104322, 0xbff11f4ccb29c6cd,
    0xc00b678d88a0b55d, 0x4004db708accaed4,
    0xc000b676501e6301, 0x3ff5cf09bc5899cd,
    0xc0099c610cf85cb7, 0x40112e1f53912813,
    0x400cb42b52eb98da, 0x3fcdf0feba3225cc,
    0xbff27562e3422df5, 0xbfea4243310610f8,
    0xbfff077bdf40ec9f, 0xc00846065bc22819,
    0xbfe02558c9d6d65c, 0xbff04bafa49bbddd,
    0xc00816f72bf3cc44, 0x4000a40692ca09bd,
    0xc00b569b53235505, 0xc00ab2958d3717c4,
    0xc013d86639f5d05d, 0xc00f49f78e37a23a,
    0xbfe2d39ac8d9d81b, 0x3ffe58793b62e59c,
    0xbfa805c31bfb3a60, 0xc000c06786ed0bc0,
    0x3fe7126ce18bf2f4, 0x4002b621114be156,
    0x4002a7ba133df790, 0xbfe8464943a38770,
    0x4015304ce2378334, 0xc008fcc2a3ca008a,
    0xbfd500ced242f368, 0xbfd8f15678719d8e,
    0xbfff2525854a84a9, 0x3ffc0cbfeb72382a,
    0xbfc30fac231e81e0, 0x40013392ffd3a752,
    0x400351a03f409252, 0xc00aee6729daa78a,
    0x4003d53f51f04bea, 0xc00f01110f270cb1,
    0x3ff2f5b15cc53d10, 0xbfb04e7a70b2aa00,
    0x4005efe18d21816f, 0x400625e3ab091010,
    0x3ffc802d75a4a2e3, 0x40131f547679732a,
    0xbfd745baac75db04, 0xc00faaeab7342ff4,
    0xbfd444a58350c628, 0xc01410f6a460f750,
    0x3febfa5a2db11d24, 0x3ff5a917d9f69098,
    0x4000a410987099ad, 0xc01e15a0a5eb8024,
    0x40060450a350950c, 0xbfda759feea4ac64,
    0xc00aec64c1f04fba, 0x3ffd1db85af74fc3,
    0xbff265f5cec8b316, 0xbfff1e74141b45fa,
    0xbff05c98c207de14, 0x3ff6ccf51a5416b6,
    0xc004f5fc71d49038, 0xc01305bcba58ae96,
    0x3fee543059b8e7de, 0x4003babe8d4026d2,
    0x3fd4c18221cf259c, 0x3fb184d0c821e358,
    0xc0139d2bd1d00bf0, 0x400078d228b9a0fe,
    0x400f1a732fd96708, 0x3fc0948f8908f650,
    0xbfe564270f4575bb, 0xbfd92e54a9eb2c38,
    0x3ff0a45992346476, 0x3fd0602474e0aae8,
    0xc00cca00ec70cf09, 0xc00570bc5b5e1ff4,
    0xbff986bfd16be2ac, 0xbff9842ee0869abd,
    0x400787b200071c24, 0x3ff3b1b1653f464e,
    0xbff39d96cb473942, 0xbfb5f6e2c39128f0,
    0x3fb20bcc6346a020, 0x3fce6f3ed18afaa8,
    0xc003b554018fc652, 0xc010f5902c34ed1b,
    0x3fda50f337e6df14, 0xc018bbac0b652bfe,
    0x4012da56652b1350, 0xbfc9301004fb9a70,
    0x401838f5395db66c, 0x3fcd791d54e40e40,
    0xc0116885c305654e, 0xbffdbecea85b07fd,
    0x401531cb819f042e, 0x40092585225d6b16,
    0xbfe4748210e3ed68, 0xbfe3c3a8260a6f13,
    0xbfa8f22d26cc89f0, 0xbfe76e454bc3e7e6,
    0xbfb56aa70c9cb6b0, 0x3fcbff6bb9050f00,
    0xbfd9b05d0731704c, 0xc00ece112f035cb9,
    0x400713e860e403b0, 0x4010e7d6fd4fcf1f,
    0x3fee0a0b1d55160f, 0xbffd86272c649f7a,
    0x400382b2f78fb890, 0x3fe3091f1975198e,
    0x3fe1ee78b1002005, 0x3ffdab260a0093d5,
    0x4016b848363f8596, 0xbfd398041fb2b804,
    0xc007a88cddead8f6, 0xc003bfdb0e32966b,
    0x3ff149101ab58232, 0xc00b05da19002d0d,
    0x3fd329e99c1c310f, 0x3ff21b7bd784e8ef,
    0x40004fd6014307b4, 0x3ff1e0e94d91e12e,
    0x400ce896356c6e28, 0xbfe79db60206891d,
    0xc0059386ee3e5178, 0x4001972d598050a2,
    0x4013ba52f2759e8e, 0xbfef0e74b61b5d09,
    0xbff7172eb4c1b863, 0xbfd184e8f10e0a0a,
    0x400223bc4eced592, 0x3fe7abdd8bab8418,
    0x3fbb72ae50176920, 0xbfa5a4668b08ce40,
    0x400ec7d9f4a58af0, 0x3ff40bac22fc8bf4,
    0x4002163c1d0ba58a, 0x4002932df46a1fe6,
    0x3ff7aa4c2dacdcc1, 0x3fd94ed03c7674c0,
    0x3fd48ca43836cdd4, 0x4010569cd8519a50,
    0xc007daea678c94d5, 0xc017e2ec0b579ef4,
    0xbfd53edc8a4f964e, 0xbfb543949c284a28,
    0x4007520f20063037, 0xc00875738e1f4a5c,
    0x3feebcafcfac4c1e, 0xc00c1e5827fcfc7d,
    0x40120eb2b60b84a4, 0x3fe80b62efd8485d,
    0xbff756a5c9f56716, 0xbff67715be989c9a,
    0x401114e2729f5bcb, 0x4009edc52e62e88a,
    0x400220d1a7597092, 0xc011eab947799dc0,
    0x400f7f6b404d2e0a, 0xbff3e3f4b43bc5a6,
    0xc005b1eb592e1168, 0x3fdf4ad0f5b304fe,
    0xbffae439faa4f37a, 0xbff77cb39389f190,
    0x3fc583a312b170cc, 0x3ff729fdc6551fa1,
    0xc0048ca6c03d9646, 0xc016d788452946db,
    0xc003802135422f5a, 0xbff1c4414098ebfe,
    0x3fff4c3a7853b904, 0x3feebdd73fa3e823,
    0xc00173c4d2b78842, 0xbfe436a5ab95ca7a,
    0xc00422748020565c, 0xbffc1838a8e58b38,
    0x400303af85ac93ae, 0x3ff63e7557c84a24,
    0x400863c522b50147, 0x4006a89753df3574,
    0xc003fbe8eb5bf5f0, 0xbfd1fbd2532e25d0,
    0xc00eb310f6e863ec, 0xc0044f1ba8212c71,
    0x3ff3120df4787b38, 0x3ff3127edd538bc9,
    0x4000a14fe8853fcb, 0xbff3ad1cfeb98c50,
    0xc00d7e5aa3bedf9c, 0x3fee11a637a7ac08,
    0xc00996b0110daf9d, 0x40018731c34539f2,
    0xbfea8228afc0b5c4, 0xc00187e6a2e8dfae,
    0x4004ec28b5ee2fbe, 0x3ffd34531b004328,
    0x3fccb82d0115ac80, 0x3fe9e2758aca3f0f,
    0xbffe64d75ed937d6, 0xbffa28642743d317,
    0x3fc762b984bf7fd8, 0x3fe185f2bf5ce1c1,
    0xc003dc498b4236bc, 0x3fed0f5f6dc2eb94,
    0xbffa86fadf12eae0, 0x401033b0902e2ea6,
    0xc000940b3ce262e8, 0xbfef8e0581a87aec,
    0x3fe6442302706fe8, 0x3fd73bb4b02b2b58,
    0x400536bb4ef8d328, 0xbffd35bf733ee597,
    0xbff0f7442566040c, 0x3fe99dabb46a9f72,
    0xc0020f86fb73ca31, 0x3fe2331dab1ab141,
    0x3fee2fb7884d88be, 0xbff6c09b61468565,
    0x3ff245959d6eb9a0, 0x4001019598c15288,
    0xbffb18c878e34ce8, 0xbfd93d3082f97076,
    0xbffc09c8a9509319, 0xbff48980e18786aa,
    0x4004a26ef1ecc99e, 0xbfe6db287c73e4da,
    0x3ff493be9fae43af, 0x3fe59cdb71a3a38e,
    0x40008c5cb7ee9892, 0x4004215e91b4351d,
    0x3fdd2aa433b3110c, 0xbfeed3813acdd240,
    0x4010ab0b641a2dac, 0x401082d1d7136abb,
    0xc0079faf6b004890, 0x3ffa91da96c45f1e,
    0xbfd677c74515b300, 0xbff6246c1e19771d,
    0xc002cb094baccc26, 0x3ff6fd408326549b,
    0xc004fb8dff907b03, 0x3fe0436e8ca190b4,
    0x400a3e5e2f08ed0e, 0xbffb26a9b1206c94,
    0x400354f90c57b27a, 0xbfe3db3f1b5dd68a,
    0xbff9ab71aa7d5226, 0xc0112fd495366a82,
    0xbfff21f27d4286d6, 0xbff0e6b1944b97d9,
    0xbfb30c5ea6ecfae0, 0xbfff0ae7344def0a,
    0xc007d39597144be6, 0x40047f8aed5d8d34,
    0x3ff3ce0c8c5603af, 0xc003824c5a0df245,
    0x3fd432b88e428f16, 0x3fb8cfa376b60720,
    0xbfeaf2e6e18c647f, 0xbff62e4cf62c5e3e,
    0x3ff82c5cf1ea2eca, 0xbff7742baf0389a4,
    0xbf970620ebe334a0, 0x3ffccc15a301499c,
    0xbff667c113066ca5, 0xc0052da18cbbc66c,
    0xc01919eab419af00, 0xc09661fb2a20188e,
    0xbfb7b3da970dd900, 0x40053a28139331e8,
    0xbff82c5c80063058, 0x4010d98778d5a7f5,
    0x4019ba2497b495d6, 0x3fde08d7b8f7c710,
    0x401490ab34dce536, 0x3fcf83a37414f858,
    0xbffb3aead398314e, 0x400d10274783c08e,
    0x3fcf578594d94b30, 0xbff65e9d3bca9bbc,
    0x3ff8a424cabb2b0a, 0xc001474b4a174435,
    0x3fd0116fa94e6554, 0xbfd7e41921cd13d4,
    0x3fb1609cc3621c40, 0xc002ebe086c20e82,
    0xc00d1e70a94247d3, 0xbfe0237564a10bbd,
    0xc00a951e599655aa, 0xbfe5bd69f9af8666,
    0xbfd6275bf0fddef2, 0x3ff30f79fbdcf4c1,
    0xc0105c9e3012824e, 0x3fe1401da0e6065f,
    0xc010caa47d741ab3, 0x40156ece9d480f12,
    0x3fe39a7a5e10f21e, 0xc00ecaea6c795df0,
    0x40009d6d1e11b09e, 0xbfe34baa62461281,
    0xbfbe48b3a52d5fac, 0x3fefbba3fd1361c2,
    0xc00859f443c1c598, 0xbfa9761e152e4120,
    0xbfd81e60032befe2, 0xc006630a4660c58e,
    0xbfe08370d1977840, 0xc003958a28460bb1,
    0xbfd81ad424841d98, 0x3fd488f5d214f0e0,
    0x3fd086d2dacdf67e, 0x3ff8bcd59f0e44c5,
    0xbff6024fa203b874, 0xbfeae14d9e4bddd4,
    0xbfedcbb16b5913fc, 0xc010903859f42b2c,
    0xbfccb93a9fe5180e, 0x40047ef3d3b92001,
    0xc0047e30072bad8d, 0x3fe0df4b86f92eb8,
    0xbfe1e809b11a6d4e, 0xbfcb20c12c6811d4,
    0x3ffb2f929ac4fb07, 0xbff255a7bd691904,
    0x4015a77c2f4de324, 0xbff1a480f359c413,
    0xbfbdc13c66a28000, 0xbfe27e9866d049eb,
    0x3fee57bcf42efd68, 0xbfe35b39c6833db2,
    0xc0058198b429af75, 0x3ff01bc5b5fe1362,
    0xbfb1ad5c032fa6e8, 0xc01a65bb4bc37df4,
    0x3ffce58e739df18a, 0x3ff2db4a74840f6b,
    0x3fdbbaa2be458734, 0x3fb49c3a0a852970,
    0xbff8be7a0fb06690, 0x401a33cbb284aa54,
    0x3ff9377be59688c0, 0xc0034eabd15c7517,
    0xc00542a0d64b4782, 0x3ffceab106dc55ec,
    0xbfe82379553e5a0c, 0x3feb1532cee7a291,
    0x400cd9cf4a1af2ad, 0x3fffd43aede8f657,
    0xbfe597d376ab287a, 0x3fc7c6b87f4ae748,
    0xc002dea269d9546c, 0xbfe9f329105eaebf,
    0xc0064e0a31e58aba, 0x401139baecb9760a,
    0x3fe464b0b4abf044, 0x3ff52afafe8a3010,
    0xbfdaf48f04f9b0d8, 0x400087d2a23ec694,
    0xc0117dfb68c7ad5c, 0xbff40b0c968a12b6,
    0x3fe6ff0618bd5b2e, 0x3fdb886301e9c6bc,
    0xbfce803889e6bd68, 0x400023e4a5a68246,
    0xbfe202b31792c968, 0xc015c45a1234bfc8,
    0xbff7917477aa6428, 0xbfde8864be906076,
    0xbff0860213141d3e, 0x40033ab3f37f2696,
    0xbff1dec04d653a35, 0x3ff4fa7e0464d7f9,
    0x3fffdb802a878e7a, 0xbfe47e9f456718c2,
    0xbfd28bad68b3eb38, 0xc00169b18a5f1f6b,
    0xc0064c20b4eb2915, 0x3ff310a69a4b9924,
    0xc00eacca18b1f942, 0xc01cb3f76653546c,
    0x400ad23d0da8e9a1, 0xbfd2c0f24de2998c,
    0x3ff89ffa4c606ddc, 0xc013d16b6713d48c,
    0xbfd939c35ece0f1b, 0xbfd009e6eae38a7c,
    0x3ffb78fd4fd05d1e, 0x3ff9a5b1fcb87af8,
    0xc00676d9d4808bb0, 0x3fd429bf434c12f4,
    0xc003c19b256268ef, 0xc002a68d84faa5ed,
    0xbff2e17d051a1f64, 0xbffe62cb769316b9,
    0x400b851b8e03a9a9, 0xbfc346f5e7517ba0,
    0xbfb497e5d56a4c44, 0xbffab09d92be774c,
    0xbfa072afc3310760, 0xbfe82091616dac53,
    0xbff7808e0b27128e, 0xbff74924e2850aaa,
    0xbfab0ad357fe2a18, 0x401109b336d3cea9,
    0xc00102fbb3dc7ef1, 0xbff956897c2eb7d8,
    0xc0055a966aa8994f, 0xc00c6ee47ac4be1a,
    0x4002d3fb410b5310, 0xbff38d250906350e,
    0x3ff7b7f05fbe55f8, 0xbff196c9c60c0ac2,
    0x3ff0db4947efb29d, 0xbfe6761cd52536a2,
    0xbfd77e5414c6ec98, 0x40026f31f0e6b73a,
    0x400d2409afeee852, 0xc00a1fd2d4f45085,
    0xc005d134fd85d4d0, 0x3fe262c11105bd21,
    0xc005d93b595e0027, 0xc0011236c61cb786,
    0x400e0f87663b7e21, 0x4008cf46d487bbec,
    0xc00c4dde13192e1e, 0x3ff6767b9af4792e,
    0x40034659308c3b38, 0x3ffd1ec3d07f32e8,
    0xc002cc41cfd288f8, 0x3ffdedc47c776011,
    0xbff5120b3771982f, 0x40016d7966af0ae0,
    0x3ffda61c26da16e0, 0xbff7a186901cfdc1,
    0x40139d9db6fdac2c, 0x3fbb8b29700adf90,
    0xc00e44a8d51efb40, 0xc0055ea42df96198,
    0xbff827c2531ad154, 0x3ff4a78f0ac8e494,
    0x3ff4b9f2b0dd8a62, 0x4007054b9bda16ac,
    0x3fc3b04ab3783518, 0xbff52a7f41e5f030,
    0x3ff1c6a5aa96a4fc, 0x3fe973270d2e9c3a,
    0x3fd0fd182bee47ee, 0x3fe3e5cdb5045f32,
    0xc00862979db84e4d, 0x3f98bf393e98c200,
    0x3ff8c2de9ee370bb, 0x3ff8271673eb44c6,
    0x4004c839c9b59c9e, 0x3fe2677715c07438,
    0x401049facb9376fd, 0x400472696ef65a7d,
    0x40051058768fe01d, 0xbfa0949a665c5180,
    0x3fecd42f7d72d704, 0x3fff1d50657b3db2,
    0xbff5931979854946, 0xbff82d32c1d9a8cc,
    0xbff762ca65a370c9, 0xc009906b61aa341d,
    0x3fcd5520740794b0, 0xc000c722821ff2f8,
    0x4001cd1577374718, 0xc00349a9a4593261,
    0x3ff6035956b1048a, 0x401c0feaf4116c78,
    0x3fcb0a024d0070b0, 0xc01119e8fbdb51b0,
    0xbfe7a0de9a1d8d9e, 0x40081cfaa76d42b3,
    0x3fd62873dcf92064, 0xbfd4d6be6cd91b78,
    0x3fb1de3a0ec7c538, 0xc0019a58e285c3c6,
    0x3fe442a633217079, 0x3ff1b1cd8eebe636,
    0x400ae2e006e0ed56, 0xbfd4db7bcf74da54,
    0xbfe5e3c216dd74c0, 0x3ffe33ab06c3ff0c,
    0xbfeb159791d5b965, 0xbfe2e2ccbf12aa7d,
    0x4000ec7d34d33ecf, 0x40008b0945c1b944,
    0x400203e9b78bc464, 0xbffcb56fe3a2c08e,
    0x3ffdae5f809541d5, 0xc00a2c80a270b938,
    0x3ffbc302f40718d8, 0x3fcbc7fda98b0540,
    0xc0026dc4175ecb26, 0xbfc38aa9b08757ad,
    0xbfe2506c6dd1c8ea, 0x3fe8e6ff003d8429,
    0x3fde3e87aff26c56, 0x3ff89399cd17614e,
    0x3ff23ab1716c00e2, 0x3ff796e7c92ca788,
    0x3ffba046dbbd5dfa, 0x3fdded7512b5748a,
    0xbff67ead6423be1c, 0x3fd6426624816898,
    0x400629f709693a12, 0xbff090966fd5eb91,
    0x400c2c8debe3e849, 0xbff20bce91e84d73,
    0x3fe0dd6139234148, 0xbfd0084eccf2f894,
    0x3fc35f6f869d79b0, 0x40085187d1c455d7,
    0x40136b17faa6bde8, 0xc0021c5152c0e688,
    0xc003983c809fc8e1, 0x3ff044974ab72da6,
    0x4001d122743f6692, 0x3fe9fa395c0309a1,
    0x3ff6492eb5306838, 0xbfc8c5faa8a85a40,
    0x4011d0d17a60d1dd, 0x400733af9e92051f,
    0x3ff3f775b6c55b80, 0xc00ba640aaa54f77,
    0xc004b30aa456d6a8, 0x4008ddbaf7325f4d,
    0x3fcf4c74fd86f270, 0xbfb9f960496e2940,
    0x4000fd6b353199b2, 0xbfb175557d5b6ba0,
    0x3ff425f7229d228c, 0x3fde659463802f50,
    0x4009aa5763466636, 0x3fefd99bc70170ea,
    0xbffc9c37b5485f08, 0xc005a107949e13e8,
    0x3fe3df4066f7a182, 0x3ff999e51e2ad40d,
    0xc001b4e31d0d7bf2, 0xbfe2b19db127bf14,
    0x3fe8a124903b90ee, 0x401106fef3776c68,
    0xbfe57a034c9a89a7, 0x3fe01f7b8461713c,
    0xbff06780104a54e0, 0x4007d167b60dfc4a,
    0xc000003e90a48554, 0xbfe8064042af8678,
    0x3fc851e4c324b8fe, 0x40082894841b6895,
    0xc00b558d43462d86, 0xc0100665b20ccba2,
    0xc012078810f0c20d, 0xbfee77a1aae63f63,
    0x4001ec4959cdacaa, 0xbff734c14c07d421,
    0x3fe05cd9a6bfa96c, 0xbfefeb8270cf5a52,
    0xbff163a6d9840080, 0x400167cd34058338,
    0x3ff222c585d0ff12, 0xbffc4c7f0aba403c,
    0x4006816af5793e84, 0x3ff12b11af621057,
    0x3fe8ed0d2b33272c, 0x400d9c8ea07c7099,
    0xbfa2ef928de430d0, 0xc00ac12608231380,
    0x3ffc090fdc2af9b4, 0x3ff7880703df86c4,
    0xbfe01defba4f733a, 0x3ff05d3026f424f4,
    0x40048649fbc7384a, 0xbff1674f4f1b3778,
    0xbffd29d1934c282c, 0x3ffb7bca61b26e48,
    0x3fceb132bd9a0161, 0xbfe494ac7c1faadf,
    0xc001ff86435e32de, 0xbff38c9c835dbbde,
    0x400e5333e19b73d8, 0xc00028a91e073dc9,
    0xbff61eb000207dac, 0xbffd88c416ca5c85,
    0x3fcd53bb45796170, 0xbff819a53b18f41e,
    0xbff8f3d896b20309, 0xc00bd4dbeb24ae0e,
    0xbfdd2a8d07cc9286, 0x3ff31bd663bc4023,
    0x3ff2a6d52e5de224, 0xbfc17c50d593a1bc,
    0x3ff8e1082bd4eecf, 0x4007488e336b376e,
    0x3ff2e7edd59c407a, 0xbffff0db58eed508,
    0xc0106fd42fcc827b, 0xc0024e5b577d7cda,
    0xc0035ced523a3704, 0xbff2ab07901370ce,
    0x400389d1a6c0c9e8, 0x4004997ef046dc1e,
    0xbff06baea649da1e, 0x3fe9ac27ae194322,
    0xbfe12943e71dca38, 0x400be39f077b3b39,
    0xc003b0c63797eaf5, 0x3fe66d85213eea1c,
    0x3ffb6b4b7b5f8664, 0xbfb5f6a357fe1da8,
    0xbfc3528018a72a84, 0xbff116e601cdd060,
    0x3fe00521c881c444, 0xbfe3408dd4af7756,
    0xbfc6b4fc8ed199a0, 0x400032ec4d0679c0,
    0xbfc1786e3ff72020, 0xc0129b88afd4dc34,
    0x400cae825b38cbd2, 0x40008ef9166f3be0,
    0xbfec2978ded05403, 0x3ff5f6f82863f7a2,
    0x3fe05cc6f4601178, 0x3fb51f3bd06515d0,
    0xc0046e868990efe9, 0xbfdceb333ea1d28c,
    0xc0076cf12f1e68ce, 0xbfe2c34b8519a210,
    0xbffcb50e7e8f8bfb, 0x3fcbf5fdc706c1cc,
    0x3fc45f2d18114ec8, 0x3fe8c8ad1ce0dc42,
    0x40006ef39be31b13, 0xbffad51c51265128,
    0x3fe71c7cc31b5878, 0xc0001905ddc14446,
    0xbffe5052573daeab, 0xc013f2c60f844754,
    0xbff81e47c076c8ba, 0x3ff2dcd7287dbf94,
    0xc000956b2655409b, 0xc00c71ee9672f8ec,
    0xbfd7908c5103e1c2, 0xbfc051f0506282b8,
    0xbff53daad39f0dcd, 0xbfd5fd87d687d650,
    0x40029ede5f9fd71e, 0x3ffcb6dcd43567d7,
    0xc00c6d86e8e5476c, 0xbfe2ae3b54977780,
    0xc0037db65d1feb7b, 0x40120fd8f227d99d,
    0xbffb16f24d5ab8bc, 0xbff7bcecb604aa06,
    0x3fdd769535bf5278, 0x4008141fd25555f4,
    0xbff1cf54a8a31039, 0xc0065e2df08a33e7,
    0x3fc21fd71e749ef0, 0x3fe20d97e26ad5ae,
    0x40017d95204005b3, 0x3ff8798283ba3f71,
    0x3ff0dc4b3cf58770, 0xc00332abb5bbc0ac,
    0x4003a31242f72007, 0x3ffb65460cbe7939,
    0xbfe11a7148d8ed3e, 0xbfe8daf1fab7f8e2,
    0x3f91521dbd2c6a80, 0xbfedfba0fb516980,
    0x40066ca5b97487bb, 0x40105a66d48c1519,
    0xc0003ba4ce933588, 0x40039a33e71ec4f0,
    0xc004c800baf37c3c, 0x3ff77d7601b82ee4,
    0xbffa47eb41c1c665, 0xbfe96db2f0015be3,
    0x4003b9fd6a831b28, 0xbfe9b9e806dc8580,
    0x3fe02ff77a630dbc, 0x400d2631dd40867c,
    0x3ffde0f3ee34fb79, 0x4011cfa450b31aef,
    0x3ff2ed1bd97005b3, 0xbfc435bb40752504,
    0x4014cdb110b0dc34, 0x3ff8ef22a3a604bc,
    0x40109c8d4501d043, 0x3fed1440b654189c,
    0x3fe809741b37e5a8, 0x4007c08e045732e8,
    0x3ff02f97b6472ab7, 0xc0010c45b112b6c8,
    0xbff58d5410203b47, 0x3ff50bc6c1fd4272,
    0x3ff28c9da84b3e76, 0xbfbff74feff8df20,
    0xc0093f4f0095409b, 0xbff2a8e3ac86138a,
    0xbfe4573739f507f6, 0xbfd770a40baff4e4,
    0x4011bb00c5a3ada3, 0x40041812136f5028,
    0x3ff5dd7f32b22c7e, 0x40009122b503cc44,
    0xbfea6c30a16fc56a, 0x40079d4ea2291696,
    0xbfdd675b9b4bce32, 0x3ffbe6ea427847f7,
    0x400ec1f1c1199dd8, 0x40155561010f0c69,
    0x3ff05d8dbb4ca41d, 0x3fe2cae7208d559a,
    0xbff3ca4f18a87ae5, 0xc009a5ef746e1611,
    0xc0084f3ee0b09ad4, 0xbffa53a954885afa,
    0xbfc64f7ba9d2d2e6, 0x3fe263f3a80ce882,
    0xbff3ba65e84dd374, 0xc0056cef34109cd1,
    0xbff160930206399c, 0xbfcb0ceb39ab1eee,
    0xbfddc43fdb8a4bee, 0xbfd9ba0a92def8e0,
    0x400f61357aab6e2c, 0xbffd148b8eda28bd,
    0xbfc13eae5158c764, 0x3fe73e3d4bc70c5c,
    0x400a32bc1ce65e65, 0xc003cfdc88da7668,
    0xc008326b24711173, 0x3fddfd993e435cb8,
    0xc00c7df25a3453bb, 0xc00093caade9c8f8,
    0x3fff859d62fce354, 0x40066969b7da1585,
    0x3fe2b0c65c81927e, 0xbff96a72ace9ce34,
    0xbfd347d339ed92b1, 0xbff922a69b2da59d,
    0x3ffe109bcc31c4e7, 0xc00318d488321274,
    0xc00864c1ca7c0d04, 0x3fe80d8a4ef7a6d6,
    0x3fc381de83efdf70, 0x3ff9ca8c2cc87334,
    0xbffd5f1aeaf83ff6, 0x3fed787a36c22e06,
    0x3fba769aaddba380, 0xc00640592ad70d9c,
    0x3ffa2fa886423bb2, 0x3fea033888bd49b6,
    0x3febf3d60da11842, 0xbffa8c6e4fbeb1f4,
    0xbff15597b19d6560, 0x3ffb59361b101582,
    0x3ff9d2ef0108cdf4, 0xbfefcdc6924b869f,
    0xc00df08213f46556, 0x400253c2c7489111,
    0xc004f1aed3f8d050, 0xc00d6909843837e0,
    0x3fe70957ab445cb8, 0x3ff7302fc584756e,
    0x3ffbfa64cb76f908, 0xbffd341fe862cde1,
    0x3ff8510f99466a4e, 0xbff46b93b07783a4,
    0xc00050b31d10b3c0, 0xbff094cf003a1e1f,
    0x3fe1e172206b4662, 0x3ffd5228508a7109,
    0x40067cf1f1e32896, 0xbff20c2db7bbe9ee,
    0x3ff01c88ecbd92db, 0x3fe9986c033d0dc4,
    0x3ffd76e646b8e902, 0xbff26442755f3c79,
    0xbff90d31621d4c99, 0xbfcd6325f7120960,
    0x3ffcc13efad69d6b, 0x40126b4dfcc95c80,
    0x3ff61edb216983be, 0xbffc94300fb5ff1f,
    0xbffc518ffd956f43, 0xbfba8028bd407adc,
    0xc00bbcbd522e42d4, 0xbff1d91e6a45c0d2,
    0xbfe7366d31ad7492, 0xc009b0e83e882953,
    0xbfc3c40e426313a0, 0xbff56923c41ba450,
    0x3fe012d2820b8d7c, 0x400c377b28141f3a,
    0x3fe6886f9786690a, 0x3ff6ff944aecb99b,
    0xbff6d1439c00d69e, 0xc000d573ff2986f3,
    0xbfe7fdca9b1d9228, 0xbff5d2374825b8b0,
    0xc004749e8f26675e, 0x3ffd040addb814c0,
    0xbfce533db6e46d4c, 0x4008cc2fea798126,
    0x3fe5e11177a950d8, 0x3fc43888d3c42114,
    0x3fad890381f01d08, 0x3fe6483f245625e1,
    0x4002df53bbb167ae, 0x4010183d06f5327e,
    0x3ff292ff1f4dc5b0, 0xc011af89e04072de,
    0xbfe7777a04fce1d2, 0xbfef374ffa4e8170,
    0x3fe8408b5a205850, 0xbfe544f6da169f26,
    0xbff7cbacc1a5f210, 0xc0081cabd3e3a8a9,
    0xc00e401ba4b22f8b, 0x400393ca4841a417,
    0xbfe68eb361a0e1d6, 0xbfe2e9fdcb21eec1,
    0x4005aa2315311535, 0x3ff6091dbfaecaea,
    0x3fe5a298cbf9b09c, 0xc001771f570cec2e,
    0x3fe40ad11f898803, 0xbfd725a6f2f83c4e,
    0x400109590d366822, 0xc004e234cfeaa7b7,
    0x400624c4127e2c74, 0x3ff92c38cfd7e38a,
    0xc0096a4296ba3efa, 0x400f4fb316eea182,
    0xbfa20a0540ff8930, 0xc01071e0185378b6,
    0x3f90cc503bb7f800, 0x4005150f03aeab2f,
    0x400aa0ad5b455b44, 0x40044f60d8c17255,
    0x40163a04f3fb7a16, 0x3ff2791549296010,
    0x4002eabd95a409ac, 0xc00b1a9a8acc9e54,
    0x400e444d02873ee5, 0x4004ef3fa8a9520a,
    0x3ff04c2f65466c5d, 0x3fb8468af544bc30,
    0xbfe29371d796c47e, 0x3f982f1ee104d9e0,
    0xbff201568eef3b99, 0x40059234d4568b2a,
    0xc00d1362d2836bce, 0x3fedb77b6166526e,
    0xbfa7357c61f0cc58, 0x3ffe8d08364f5a52,
    0x3ffa8cb61d105a7d, 0x3fc5ef1fa6617eb8,
    0xc0105d12c3834b7c, 0x3fbb9bfa747a0600,
    0xc014717763d3c931, 0x4001766a354d2524,
    0xbffc5e2b8146d2c0, 0xc01c3c94174b66b0,
    0xbffd0155e4e75781, 0xbfc25a63a9473ff0,
    0x40029acc4c9d14aa, 0x400473467551505d,
    0x4007622d4f90b93c, 0x3fef70344e3983a2,
    0xc00d374867a2a712, 0xbff6985312de3a0c,
    0x40056962d8b8d2e8, 0x3fe9266e16361332,
    0x3ff8c05964f04686, 0xbfcc3f2b4f61df22,
    0xbffd75232d2965e2, 0x3fb5c1f68e182ad8,
    0x40015a576d398cee, 0x3fd8ce21554ca7a8,
    0xbfe5a85f22b06420, 0xbfe3b72376efd6da,
    0x40134180144d6c00, 0xc007ff42182d8a8a,
    0xbfbcd33903d5d81a, 0x3ff1c1c61d5254f0,
    0xbffe6dec3ff8f5b0, 0xbff5af7bc1021b34,
    0x4003a34f767816ec, 0xc006fbc531abc882,
    0x3ff148cd39dbf040, 0x40028360973ff25a,
    0x40045548cf3600a4, 0xbfc2fef7cae267d8,
    0x3feefa591696c6f7, 0x3ffaf9d395094396,
    0x3fdff40c6e57e388, 0xc008ed42d152939c,
    0x3ff34a3a4d66292d, 0xbff4c2c2e3c3cf2f,
    0x400475d3afc551ff, 0x400f7262c3296a0c,
    0xbfcd1b4e0f6e3610, 0x3ff52d506ce4eb32,
    0xbfe3df3f13b486c1, 0xbfee92f398e2d395,
    0x3fefba223b6f5d1d, 0x3fccc4afcce18188,
    0x3ffe0d3fb49f4f6a, 0xbffa0a62d546d3a4,
    0xc00186ddabe9b36a, 0x400071aea6cda1b6,
    0xc00fb9159a2caf86, 0x401348211fe19ac7,
    0x3fe9e8a5b422d82a, 0xbff366a1693577e6,
    0x3ff01cc9b3dc8d54, 0xbff88b2dd040f8dc,
    0x40004b98bd1ffa4f, 0xc005cd6cde41b18d,
    0xc01507cc8527f929, 0x3ff33df3075d90b3,
    0xc0075d86ecbb6244, 0xbfe91ded5b1280bb,
    0xc006ee390b59d521, 0xbfa5c6d766d6e280,
    0x3fd885629256e438, 0xc010a5900cd45cce,
    0xbfe4d3fdfeba4d58, 0xbffb028eecee4770,
    0x4012225a6c04b88c, 0x3fc7998c227b2638,
    0xbfeaf8ece18e578a, 0xc00e0266aa03126d,
    0x3fdd95dd87de8f00, 0x3fe9aa7abdc85a9a,
    0x3fe4723bafd0e94e, 0x4008614bbe86a144,
    0xbff0b4b8a8421538, 0xbfdab82072934e48,
    0x3fd4032447ba2202, 0x3ffba0ac4342a827,
    0xc000649b847b9dc8, 0x400aa10fd73fe228,
    0x3fe8f382020f54fe, 0x3ffd525e02170526,
    0xbfca792efd966516, 0xbffdf35607f24dcd,
    0xbff9f1415f8ad3e5, 0xbfefb751292e98c2,
    0xbffb24ff332c2686, 0xc00ea66ab74581ba,
    0x3fd987f39a043998, 0x40065c43d038756e,
    0x3ff4fc644c2a96ea, 0x400a4bac0fdc4efe,
    0x3fffef98d3420312, 0x3fe3b21c72fb0f04,
    0xc007e37d9ea66604, 0x3ffd11aef9d2d184,
    0x3fe5f9f672c180d3, 0x40112178eab97f92,
    0xbfd44857435ab520, 0xbff7bd866c04ea8c,
    0x4001e31cab7299c6, 0xc014b361f0c44046,
    0xbff7a4db0540d58d, 0xbff769252e32d99b,
    0x400bf23939069f0e, 0x400f7290b638813c,
    0xbfe845857ddb72c2, 0x3fdd1e0623005698,
    0x400203e989388e90, 0xc00b6a3b30e9fc2d,
    0xbfef656341f8205c, 0xc0015052ab68591a,
    0x3f72600241071f80, 0x3fd27d97f9470ed0,
    0xbfe2ba91d19aae8f, 0x3ff99120b5c628a3,
    0x3fe43ad4f5e80811, 0xbffc6be1c57bb04a,
    0xbff85561f61447ef, 0x3ff36de1970d55d6,
    0x3fae209a319d1480, 0xbffa40862eeb06fc,
    0xc007877b9aaf9a36, 0xc0091deeeebaa83a,
    0xc0023d28f777d93b, 0x400aa7e206b9ee06,
    0x3ff2f745002df0d3, 0x40073d67565ed2b5,
    0x3fd7e2957ddda672, 0xbfea027152e61c04,
    0xc00b8e96d5357cce, 0xbfc067e4555b7420,
    0xbfd8f1b4368093e8, 0xc0088d3b2d803f7b,
    0x4017675df9a0c917, 0x3ff2c72bb04f91f5,
    0xc003be764c9fe73e, 0x3ff355cbbdd38498,
    0x400e1a0a4d7b8c0e, 0xbfff8fbe52a68ec7,
    0xbfe20030908b157e, 0x4007b67e4b0a093f,
    0x4008f0605bd46a6e, 0x3ff81dcc0a1e1859,
    0x3ffaf33f5024e0bc, 0x4007e314ea682b5c,
    0x401e3ca8f6833bdb, 0xc00b181e84f5672b,
    0xbfccd416f179bfc4, 0xbff4500d27997242,
    0x3fdf9b806ed4cff4, 0xbffa528c85a9e214,
    0x3fea1b3d0f8acab6, 0x3ffe2baaa302496c,
    0xbff9793762c3d80e, 0xc000f8c34878b960,
    0x400848886e7b4af2, 0xbfd7b26180a20488,
    0x3ff96a608ea89e86, 0x40026069677219d6,
    0xbfff6014e97859ab, 0x3fd16f0ad26ee1c2,
    0xbfe22aa307bd6ebe, 0xbff77ae080deb96c,
    0xbff012098ce4ae94, 0xbfd054bbdfbe1c3a,
    0x3fff449775e01656, 0x3ffa23d808125120,
    0x3ff957a085989498, 0x3ff2316d54a67083,
    0x3ff0978a15016d32, 0xc01267d7100c3d7e,
    0x3fb96df32a2417a4, 0x3ff97f6cfb435fb2,
    0x3ff7afd4ef8666e1, 0xbffd83b170e44c03,
    0xc005892039e6fe8a, 0x4001a4a5eca54056,
    0x3fee1e4e5d9a06b8, 0x3fbb3f938a5ad148,
    0x4005da0fbb8d722b, 0x3ff700afe20c3fb2,
    0x40127b81fbe6fe79, 0x40001913b8f9fc7c,
    0x3fd73ad2c860dfc0, 0x401284ff7e3545ee,
    0xbff576e892ce72b6, 0x3fc666811fe158f0,
    0xbfba13649181ced4, 0x3fe7407f7f5c832e,
    0x4011dbd8953a6654, 0xbff7e21f825683b2,
    0xbff1ef3328b94bb2, 0x3fdfee3862f912cc,
    0x40026a6f1058a4fe, 0xbfed91511e9d8afb,
    0xbffc153f0c304212, 0xc00154b8db8a376d,
    0x4002e1d6c12f2c2e, 0xbfdc5c8b54c7974a,
    0xbff1787a84478a29, 0xbfc4191ba49b2acc,
    0xc007691c05f64657, 0xbfcb455ff93234d0,
    0x3fff6b68072ae8a4, 0x3ff285feb8c8a300,
    0xbfd77a40cf9bb57a, 0xbfefcd8d9854e388,
    0x4000385b85b2e59e, 0x4007f6b672210bac,
    0xc002fbdc4a14be44, 0xbff678a2b772f130,
    0xbff9e392cb6b4cf8, 0xbfe4b61716fb2fea,
    0x4000cb592c6f6d2e, 0xbff5632432d20f6e,
    0x3fe3866075e2e28c, 0xc006e194af86213e,
    0xc00afe4f830e1bae, 0xc007dc3368ba0fea,
    0xc010091ef26fa9b8, 0x400b614c6d1a7ec0,
    0xc000433ca4f8e3c2, 0x400d6a12e25c8fe6,
    0xbfe00678260aff7b, 0x3fe62648ae3342b4,
    0x3fe5b88837f48930, 0xbff564457664fd16,
    0xbfd755fca92b9140, 0xbff7b860fd1b5574,
    0x3fff8e08f67f401f, 0x3fff181b0cafc88e,
    0xbfdd3d9367e10604, 0x3ff35ff88f7e22d9,
    0x3fff857926200301, 0x400b6bf6694075d6,
    0x400abc8c85789f42, 0xbff7d1f88d357480,
    0xc0114be3a6f53769, 0xbfed442305bd6e9f,
    0xbffba5c9159125ce, 0xc018c6c860b7d07a,
    0x400afda24dcfc7ab, 0xbfd68fc2ff4c9b70,
    0x40118102d4e86ef1, 0x400821a4cfac8496,
    0x3fa1941e074a97c0, 0x400014cea4c92500,
    0x3ff69074b5c71c44, 0x4005fc29286e6cb2,
    0x3f8554bf50345fc0, 0xbfe28bc163123f25,
    0x4005f4d5f76a6d8a, 0xbfe5ee0487aa4384,
    0xbfe29577e21bcd83, 0x3fd6a6ad64d47234,
    0xc007cc95eb28333e, 0xbfee3572096e6d6c,
    0x3febf7da7a995a59, 0xbff7f30ebcbb7340,
    0x400fac93f627f3b4, 0xbfd997c2570d0632,
    0xc001d7650b986c7b, 0x3fe2ff8957cc3d0e,
    0x3ffcc1a63da74583, 0xbfe439408273b6ce,
    0x3fdd560ddf5e6b7e, 0xbfe8e0f9192be27e,
    0xbfe98c93b4319db5, 0xbff16afbe3f6604d,
    0xbfea9acbeb6028aa, 0xc0123b65225cea34,
    0x4002b351e995ac94, 0x400037b86763f615,
    0xbff260b8b40f526b, 0xbfe92c9067315425,
    0x3feebbf1eee59756, 0xc00075fb7ff1a7b8,
    0xbfc685f05a3b5b84, 0xbfe82396674ce06e,
    0xc00b602e8f867184, 0x3ffa35ee78b63c48,
    0x3fd04223fcff6776, 0x400e0522a6bed3e6,
    0x400fc20b81dd46fe, 0x3fe2cd3e059b8237,
    0x3febaaa9b821b411, 0xc007f4fa0da33260,
    0xbffb0eff52923a45, 0xc00a9e0f1f9fae30,
    0xc0012f9896f5c228, 0x3ff5ed5abf2bab72,
    0xc00d05f1b6e8ecae, 0xc001baa770d64e9b,
    0x400df043fb2de9b3, 0x3fd8427bc4eb3dd4,
    0xbfdcc093ff6ecfd4, 0xbfeed321f2a656a8,
    0x4016c6e31c5fec49, 0xbfe88a3bddce98bb,
    0xbff4fdd66d2c0068, 0xbfe1b1ac3c32ab54,
    0x3fcd020868d316e8, 0xbff6c4f3ff2af410,
    0xc007a33126222c55, 0xbfe1b66d01165698,
    0x400d3b1775a8060c, 0xbff7cc2709ec3ad0,
    0xc00cef0ac7e5ab38, 0xc0011b53baaa2e55,
    0xc00ed0221ef5bc28, 0x3fc835e650e066db,
    0xc0052da62290baad, 0x3ff94b4864dac0d1,
    0x3ffefab2dd9b9a80, 0xbff0dee7227b6165,
    0xbff502f4a4efe1db, 0xc002080d33c1c928,
    0x3ff92e3d478845a4, 0x3f76087e998f4440,
    0xbfbae1e9d6dd9d40, 0xc002c476bdaf87e6,
    0xbfeac539f8c4a2ad, 0xc0030992fe9f0a08,
    0x3ffc218a0cf98ea2, 0xc0096faacb761bf4,
    0x3fe6faca6b7c9d66, 0x3ffad3c12dae3d14,
    0x4001c4bf2265df00, 0x401b1cb919f4341f,
    0x3ffaa3148a688069, 0x40005d048d30cdf0,
    0x3fdac2a1ccad6630, 0xbfe2876ce8c439c3,
    0xbfffdee37812df66, 0xbfffaf2431558a04,
    0x3feec4be66c8949c, 0xbfe02ad28fb57030,
    0x3ff4f593a5c69244, 0xbff5771731d2aca7,
    0x3fd531fd7503ca80, 0x4002d36335166f6a,
    0xbfe9221701ab4817, 0xbff338a01938ab95,
    0xbfeef934507cbc99, 0x4014fe64d2b9c233,
    0xbfddb5b2277d67c8, 0x3fcfc9349ec82bf0,
    0x3ff5bc34515f181c, 0x3faba1fcb31934a0,
    0x3fd9735153bd0b94, 0x3fff416ef60fe20b,
    0xbffdd359f2acc9ac, 0x3fe95f917d332051,
    0xbfdff51db7db9a58, 0x4004fbd8c0d39eac,
    0x3fe57433002dc2cc, 0x3fd83f37b9062b70,
    0x3ff5092fb1d9a584, 0xc004bfe652895936,
    0x3ffc4039c1a5530c, 0xbff1940f36cfac98,
    0xbff14fe638890f44, 0xbffa7d8e69f6c390,
    0x3ff2c18c9da33b53, 0x3fc2f315925d33ec,
    0xbffb28ce6a2e237e, 0x3ffed6ba01d0adc4,
    0xc007cc24b74ec56e, 0xc00576a9c8bb3b0a,
    0x4003d9c263e772c2, 0x4011afd26ae77628,
    0xc0020b2539d008b2, 0x40068180538fdf24,
    0x3fec5a809993146a, 0xc011289cc564b5a0,
    0xbffbf22cf5843da6, 0xbff3398156b81cae,
    0x3f788c4afe61ff00, 0xc000e42ad114c5ee,
    0x3ffd40a3f6cc2b5c, 0x3ff58e64e4c05dd4,
    0x3fe78835eb9327c8, 0x400f802a53f15890,
    0xbffdc991022e3948, 0x4004724e2ccb40ac,
    0x401f13e197e2e0d6, 0x3fd3656337494550,
    0x3ff079502cf0b244, 0x3fd948f29d525174,
    0xc00e182ecf6da4fd, 0xbffe83233bc23082,
    0x400998092d69deb2, 0x3ffe46f3d1c8cd4c,
    0x3fb7cd577c4790b0, 0x3ff2fee42b9c8774,
    0x3ff10a337b538f17, 0x3ffa6ebeffc33a96,
    0x3fe6ad47c3666e2a, 0xbfe297c3b25f8868,
    0x3fe6fddc420371b4, 0x3ffd6a37e5a6e702,
    0x3fe749474078d268, 0x3ffd25a3d2abe212,
    0xc006677d6b8a1944, 0xc007af660e661a40,
    0xbfde8cd71cbd7452, 0xc00e27badae73365,
    0xbfff4c294962ae74, 0x4010b2013f690458,
    0xc0005045bdc376f5, 0xc0060eeb8cd51b0f,
    0xc007fc0584c2704a, 0x3fea8bf163fe9d7e,
    0x3fc28b6132a37f64, 0xbfe38f1f6c6382da,
    0xc0055380a7bb29bf, 0xbff1095f301fda84,
    0xc0020c3a4285d6dc, 0xbfec5129c0f4b7ca,
    0xbffdb556521540c8, 0xc00e20fa73639cdc,
    0xc00dd50bc095a99e, 0x40057d6c5c840680,
    0xbfdb27f342ec0f48, 0x3fb02f584ee85330,
    0xbff28f292e53cb03, 0x3fded120e237a02c,
    0x3feb28894331876c, 0x3fd25b1a0215766e,
    0x3fe743bcb12ef627, 0xbfe8233e46392f36,
    0xc006e0b578144686, 0xbff428ad07eb030b,
    0x3ff8b54a56794ce8, 0x400ac7348503ba41,
    0xbffefb57395bf7f0, 0xc005d444f3c240ee,
    0xbfe934ab14b1e1d1, 0xc0073b0171ab9a23,
    0x3fd363bc53c54b74, 0xc0020a46ac47b25e,
    0xbffa9526347d5b9a, 0xbfdfb3c48d72e736,
    0x400a374261311ea4, 0xbfc0148d33ce951c,
    0x3fbf89023ec82c10, 0x4006cb2cc55b1e7a,
    0x3ff61abc649b9fdf, 0x4000a945aad05355,
    0x4004346c7fbf8906, 0xc004d51e5ba0dbf8,
    0x3fe03eba07974500, 0x3fdbfa3018e493a6,
    0xbfef09bff6da8ee4, 0xc00b34bc476abc8f,
    0x40007077730fa08c, 0xc000841bc7af8e68,
    0x3ff3bc0f983a0058, 0x4001dde601101814,
    0xc01403cbfcfb2112, 0x3ff03dde57d5d7e3,
    0x401281c37ee62717, 0xbff086c8248fc9c4,
    0xbfca7f7ef96fdb10, 0xbfe3a458257f73f9,
    0x4003a867bc3fbc5a, 0xc0022a5f20875c26,
    0x3ff0732be35733ae, 0x3ff91ff2e9f8116c,
    0x401039dde8ebec29, 0x401be4168ff0c23e,
    0x3fcb47a1d642c1e8, 0x3fdd10ccb5df3204,
    0xc000260679c878be, 0x3fffce7b6afcf99d,
    0x401324bdefb9fa6c, 0xc004bd7f74203d12,
    0xc0078fc291c8b2c5, 0xc007741db040dbaa,
    0xbfe99de69c170516, 0xbff3e65b519eee1c,
    0x3ff370e5f5e98528, 0xbfc07e6f3910c4b4,
    0xc010c6e1259834d2, 0x3fcb534e0a530b88,
    0x4001d9f00aad31a5, 0xc00859235ecb9f5a,
    0x40085d60c34e93b3, 0x3fbd9c16172d9630,
    0x4010f4785d04db50, 0x3fa0985dd8299ca0,
    0x3f936bc91f4bfe60, 0xbfe304206cef3253,
    0x3fe22771e304cc3a, 0xc00e9afbaa037906,
    0xc00df53d237ee116, 0xbff51b0f9e0dfcb8,
    0xc00ee785b67c8b93, 0x40193835ec5c2b62,
    0x3fdf62e5779b1c46, 0x3fc8679d6043e5a0,
    0xbfcba3d5986a6de4, 0xbff2232a4e839dbd,
    0xc00459d3e4bfe4cd, 0xbfbc83ffa0664870,
    0xc005ee489fea39c0, 0xbfc9574515fa22e8,
    0xc00cb03d8b812375, 0x3ffaf22ef538184e,
    0xbffefe3cfeb559fa, 0x40027cc108693ef8,
    0x4006458f28dfcc02, 0x3ffbfb75fa02d8da,
    0x3ff6c906ea0ce737, 0xc01068bed4256110,
    0x3fcc1e1224e1b5b8, 0x3ff87df794582ad4,
    0x3fc395bbf108ecbe, 0xbfed4b3cc3d91b67,
    0xbfface6628297b86, 0xc004d14bc803d5d8,
    0xbfb6ed8048a6f2c8, 0x4009ac4261504470,
    0xbffd7948004f9e08, 0x400026459c214abe,
    0x40020bf97fee8a6b, 0x3fb7773478f4dc4c,
    0xbfe2d1ffe7d2ff12, 0x3ffe810ae590c8ff,
    0xbffca2178b8662aa, 0xc00d8e5fe05a4ef8,
    0x3ff5b0ca1fd9e87a, 0xbfd9828a20a68d24,
    0xbff641a1504fc870, 0x3fdc516a3272f596,
    0xc00343a9bfc20ee4, 0xbff8ea5137e1d1a6,
    0xc0107cfd3988959b, 0xbff2f98f5f9f96c8,
    0xc005b683d2b29b6f, 0x4011c759ca69a95e,
    0x3f86450959fc0180, 0x4005b3a4049817e4,
    0xbfdb458018abe8de, 0x400d2bcc81dd83fb,
    0xbff96496cf523bd8, 0x3fe8cf1a8a64f7bd,
    0x40090208e2a22044, 0x4000294dda7754b8,
    0xc011b6ba0d6e395a, 0xc00e1d5372100690,
    0x3fdb415b805ab50c, 0xbff60600c90b9c7a,
    0xbfc6577d5d6fa7e8, 0xbff95ead8c3379e8,
    0xc00587bb1644bee6, 0x3fc75d61fa049908,
    0x3ff94c31d8c68058, 0x40040d2daa8cac5e,
    0xbff27e35c7bc5c44, 0x3ff2a711a78842b0,
    0x3fe5c7fb03f309b9, 0x3ffe3d8063a08f7b,
    0xc00203156b393e24, 0xbff53def958b4ed4,
    0xbfd86dd287fc455e, 0x3ff71ef1c49c9fe1,
    0xc00554f596c456f8, 0xbfe8a6211e2900f8,
    0x3feb90beb626072e, 0x3fcd83f11696287c,
    0xbff2a75bebddbccf, 0x4003ab48acb6f96f,
    0xbfd75c5926cd7764, 0x3ff7941f6fb35634,
    0x3ff39c54680fb9c4, 0xc00362e38727ff32,
    0xbff331ec56694806, 0xc0100c0ea9b6b7aa,
    0x3ffcd43697af1345, 0xbfe05917e3fc425c,
    0x3fd3e1acab215626, 0x40078c4e7799fba0,
    0xc00748d71e01c650, 0xbfd47a6df718651a,
    0xbffe160e3022998c, 0xbfe04ebdf4251c4d,
    0xbfeaa75d1ff7fca0, 0x400015e416c51d83,
    0xbfee329760cbdaf3, 0x3ff8be8c72b59a98,
    0xbffe341b4d750085, 0xbffbd72b4510de42,
    0xbff55b57f71ca6d2, 0x4000b31edbebd3b9,
    0x3fe45ef25d342c3f, 0xc0049bfe78065380,
    0xc003d211a74304f6, 0xc00591067fe04b78,
    0xc011e46ac7e225ab, 0x3ff9b31cb4df9f60,
    0xbfca57cca8a81030, 0x401327e02fe0a125,
    0xbff1a49fccde9228, 0xbff518d21f4c9d38,
    0xbff1f9527c41795d, 0xbff4176327fb56f7,
    0x3feab19aaaff2648, 0xbfff3d81de3a3434,
    0x3ff78a15383edd29, 0xbfe934e75595610e,
    0x40008d7004bfac26, 0xc000284eaefeb6d8,
    0x3fe725f89674138e, 0xbff6f434de1a8a60,
    0x400a6b694a4218a0, 0x4008b6658150a930,
    0x3feb703b4198fb74, 0x3f917c4d47349320,
    0x3ff847b57d737382, 0xc0031f71d9f9abea,
    0xbff71dc3c526d608, 0xbff16c9d43cbf8d5,
    0xc006968e527655d8, 0xbff2cb5f89e10b18,
    0x3fc7b643a42eb308, 0x3ff735226c9067fc,
    0xc0184101b90b1a7c, 0x3ff4ef3a371f3d8c,
    0xc00172ff91bc06b4, 0x3ff08949d500b916,
    0x3ffebae8f91c64a2, 0xbff30befb0e07063,
    0xbff4a97511ad4a73, 0xbff2a5a4ef3ac070,
    0xbfe8990fc59db178, 0x3ff0e85f6afd4739,
    0x3ff823a501828562, 0x40015d0d43cde7fd,
    0x3fe8410a43ebf250, 0x4000aa1a1a3e2f56,
    0x3feeccdae0e9d3e9, 0x400fc21b1a41550d,
    0xbffbdea27221db2b, 0xbffe05d285130036,
    0xbfdf6e4890621070, 0x3ffc95d0d954930c,
    0xbfdb5eb5a0912dc8, 0x3ff73abf5102efab,
    0xbfe3903c659dd8e6, 0x3fca6bd9842f123c,
    0x3fe4073d105b7421, 0x3ff0cef6863e037b,
    0xbfe10902081ed6a4, 0xbff2ea0b79d87752,
    0xbfee38599593b006, 0xbf9984bf868c34c0,
    0x40058926f4d5e50d, 0xc00401e7aff403c5,
    0x401b98f5dffbed9a, 0xbfabae75fa7c7cc0,
    0xc0056cb69ce7b0ee, 0xc00ab95713331d52,
    0x3fefc300e685bfc1, 0xbff0299987f1972c,
    0x3ff6921f41980434, 0xc0001c9f340544f1,
    0xc0037ebb9b4a9c42, 0xbfef27f6e27e79ad,
    0x400f41f1dc702578, 0xbfed42406dca07ea,
    0xbfe79838b05ec6d8, 0xbff18c19fa4c0292,
    0xc002858e4ddfeae4, 0x3fbc643d0e3c30e0,
    0xbfe0049b1ee8cd74, 0xbffb1c3851fbff09,
    0xc009e726b7515f39, 0x400b7d096a0fbb88,
    0xbfe560078b5246ac, 0xbfe77f410dab0433,
    0x3fd5ae078a6483dc, 0x3fec41dfb6d73464,
    0x3ff36949da7ab245, 0x3ff5ca5b12f2e2c6,
    0x40132d4abb038b76, 0x4005042d1f7442ea,
    0xbfe372e2acf980e2, 0xbfb3c32d4a70c3e0,
    0x3fd2061cf1775f50, 0xbff6013dbf2ad292,
    0x3fc4662a3337628a, 0x3fda88aeef6cecca,
    0xbfe975366cb3e9e2, 0xbfc580c4ca6c70ac,
    0xbffe16811f9a44ac, 0xbff3d370899bd5c2,
    0xbff32fc29c9a0544, 0xc002edda96e451c5,
    0x40007260d482579f, 0xbfe3fbc7ba9d528e,
    0xbfb8e2da64d82b30, 0xbff766a6497d3eb7,
    0x4006ef609c44f3c0, 0xbfc5406547e44c50,
    0x400035c47b9806ca, 0x4011953cc72b1528,
    0xc00b3fb30cda30d8, 0xbffbb158e21caffc,
    0xc010a6df89d9103b, 0xc009ad63fec2e732,
    0x4016f37bccb56d6c, 0xbfe3d96a321a6884,
    0xc011e058bb464181, 0x3fe0bd3edd774b6c,
    0xbfef2b7005a5c48d, 0x4003d3b5245d2155,
    0xc00303e0f06b31c8, 0xc001f8e48ca347ff,
    0x40109d17ff9f816a, 0x3fe0a24e86a0f1b6,
    0xbfcd4f5c3eace3a8, 0x3fff7410fc227638,
    0x400bb4c2b4be802c, 0xc0005d7041836800,
    0x3f407cd4dcc37800, 0xbffd18464f324c72,
    0x3ff1c6d1921d759a, 0x3fb1f2cb0b10ae28,
    0x3fdaf7c3c3074cca, 0x3fc36488aea7e628,
    0x3ff1cc34e55d471a, 0x3fff50419c3f104c,
    0x400f8e5afda708a9, 0xc004eb76a1220f4a,
    0x400256cb16ac2fa6, 0xc005079e514a90b5,
    0x3ff67fa07d60b8bd, 0xc010b9abc8f45592,
    0xbfe54d506723c9b8, 0x40050e1d3abec084,
    0x3fece140a0dac396, 0x4004dd0d6db71ddc,
    0x40109d6925a8e757, 0xbfe1e6c5856a7760,
    0x40128d90fa8395ae, 0x3fa1b795e7795c30,
    0x3ffb6b0c55f4d6e6, 0x400525e5551eb691,
    0x40051522aeaaad60, 0x3fe42bad28785480,
    0xbffe94e496022c7c, 0xc01e85b7aa50fb12,
    0xbfd25400a421ba56, 0xbfe27b8a9be2ea5a,
    0xc01a4aa98a00f0f0, 0xc00baa2aad4690c8,
    0xbfdfd07b8c39f1d2, 0xc009490e9bb4785a,
    0xbfffafa3ebfd66a3, 0x40111a21a0391b18,
    0xbfba7d0da9a83ff4, 0xc00bf260c342b25a,
    0xbfc1bad7837b8518, 0xc00cd93f720d4ca7,
    0xc0038d86ad15e33c, 0x3ff0dadb78c5e2f0,
    0x3ff99742045f1600, 0x3ffa6da21e33e875,
    0x3fed19ed596af1e8, 0xbff8422e0416c982,
    0xbfdc58bc32f42320, 0xbfe9e310b67d93c6,
    0xc00b4be2bb8789d0, 0x40124814c3b39e59,
    0xc00f999c01d0eef6, 0xbfee74f2537efcd4,
    0x40171d13879cf17c, 0xbf69126af3754a00,
    0x4006fd6b8a8dd763, 0x3fd99753d02c3390,
    0x3fffd1affcbc5566, 0x3fde761ef5122f98,
    0xc010b5b200999272, 0x400c06c2050c077c,
    0xc002b23cbeeea10e, 0x3fe838578b22930d,
    0x40049b1b07fef22c, 0x4000c34f22edd950,
    0xbfefefbc08fe5ea4, 0x3fdfca826f016310,
    0x401204d32bfb490c, 0xbffe68620846ffb8,
    0xc0056d52e28c193e, 0x400ebef7aaf33c61,
    0x3fe5dd3ad999c670, 0xbfeb5d883fa6a872,
    0x4016bae93896cb75, 0xbfee77c3aa559324,
    0x40027d383d669873, 0x40107a42690d0f39,
    0x3fbf1bcccff79d58, 0x3fea9cc7356bca9e,
    0x3ffe11b90072109c, 0xbffc640832f3064e,
    0x400179cd376d3e40, 0x3ffb6c0d0fadfb24,
    0x400cdbf59ed30e55, 0xc00199082a4b14d8,
    0x3ffa68bff8afa685, 0xbff7c9159b4cdd2d,
    0xbff1434998771d78, 0xbff32d66947246e8,
    0xc000d2ee4b8cba1e, 0xc000e4d341e8c0f5,
    0xbfeb9c34080d64fe, 0x3ff27fa19b96d86c,
    0xbff7f161bc758f02, 0xbfeb955c266392d6,
    0xc00d5f3644af70ae, 0xc00a5ec82641f96c,
    0xbfe08698706e1a39, 0x3fcdddc7744400e0,
    0xbfc7ace2c632e67b, 0x3fefb6da00a70b38,
    0x3ffc1a5b74c9530e, 0xc002a445b11411b6,
    0x401270465ce6a3cb, 0x40038474cd7e2f80,
    0x400c7b7a7f66fafe, 0x40051b4ffbdff80f,
    0xc00025c04d7bbea3, 0xbff54d7cfd3ad0ac,
    0x3fb69d3bce563e28, 0x3fd89d7b5e31a88b,
    0xbff2d2ed3f92a060, 0xbf8cce5e1bb60600,
    0x4000701b875bb366, 0x400122ae28cc8e30,
    0xbfe2b99fe3ed5bce, 0x4007a67fa5e0a520,
    0x3fee364829922259, 0xbfe0182ecf899dd4,
    0x401022dc652c9966, 0x3fffc28370dd7736,
    0x4009779683aa1582, 0xbf97642f8eeb0800,
    0x3fe66620319d0f38, 0x3ffd528fa49d01f4,
    0xbff13359ea666330, 0xbff15e5d259dd0ce,
    0xc00fabd376ba7766, 0xbffdf1af849a294b,
    0x3fd7de0f8773f4ab, 0x3fbe3325b92364e0,
    0xbfe886560efb6352, 0xbff74699d9e554c7,
    0xc00da1398261e3fc, 0x4005bb9227543b1e,
    0xc0097ce33189bfaa, 0x3ff1d9889c6d47ea,
    0xbfa09981e8d95be0, 0x3fff481af71a9a61,
    0x3ff237e03e299126, 0xc00c2f1db46ce5e2,
    0xbff55102f8e031aa, 0xbff06f285f8ce82d,
    0x400e1cbb56f9a4f5, 0x3ff04de816a39ed4,
    0x401008f5a5cc7ac2, 0x4002565c6b9a9047,
    0x3ff4cca8a48f7600, 0xbfffce350ae245e2,
    0xbff871576c39af7e, 0x3fee7a4f705e2904,
    0x3fd35a02a53ed3f4, 0x40053dc93b031fea,
    0x3ffb33d7a727b38d, 0x3fd3b5a8aea8c4fa,
    0xbff0aaeb52c4d9fc, 0xbfd794c487d27ba8,
    0xbff6ebc32ebe8d4a, 0x3ff98a5c831ff580,
    0xc0028604b69adef8, 0x3ffaa116d2b15c6b,
    0xbff56245b2cfe376, 0x4010ee61d3786822,
    0x4007315a0bdba7a0, 0xbff111ad1a699262,
    0xbfe1edc6a22506a4, 0xbff2e56c25232418,
    0x3fd06c0ef83c9888, 0x3f92d76243739a80,
    0x401863ee28b1960c, 0x3fe9735422517560,
    0xbfef0973b4181248, 0x400e588a16afa234,
    0xbfd52432a007a540, 0xc004cef0c703d725,
    0xbfe0b59432a25fad, 0xbff331a61c7c82aa,
    0xbfed77d31715cfc0, 0xbff50064a2486eac,
    0x3fee47d48fd10bb8, 0x3fd04df76fe6c72e,
    0x3fb286bb053a4ca8, 0x3ffac99ddc0d4195,
    0xc0011c7069b4eada, 0x40017d45f3a34f33,
    0xbfd24416ee7fa315, 0x3ff3814d9a2bf348,
    0xc0040c490784c9de, 0xbff58dd3ed65c136,
    0xbfced56dc8e093e2, 0xbfe5053e572b4e76,
    0x3ff7340fa2fb4d15, 0x3ff38b899fa74b18,
    0x4001600bdc70c824, 0x40085350a730ab50,
    0x3fd188c7ca16578c, 0x400e62f96795035d,
    0xbfd12c584f221e3c, 0x3fed6bd5c1831e00,
    0x3ff4c7d058fd67fd, 0x3fb23ecf6baa195c,
    0x3fc3d169ab12bb44, 0xbffc90ecb1147bfb,
    0xbfda8b520bf7f41c, 0xbfeb4d38db8d3408,
    0x40055026e7ca1bda, 0xbffaa1d6116a0e11,
    0xc000561882b4f704, 0x3ff3d5b1bbbd820b,
    0x3f43a951f44eb800, 0x3fe42d611bdc90c6,
    0xc0010b8c5a1cd712, 0xc015d5d83629f498,
    0xc00bc60837985e88, 0x3fbfd45139f85630,
    0x3fe71dcddd901dd1, 0xc00c74164bf07104,
    0xbfeb204f009f44f0, 0xc010a30c925d27a6,
    0xc0077bf3a12362fc, 0x3ffe7d2e9f5c5aa5,
    0x400f798149641af8, 0xbfa04c841d6b7b40,
    0x3ffd570da311030c, 0x3f7a0d2950357100,
    0x3fce352ba58f1008, 0xc0009241d45fe3d7,
    0x3fd1bd1d8494ad30, 0xbfd287594aadf95a,
    0xbff98cc71d8252ac, 0x3f3984bccb7f5800,
    0xc007a4b0aa23202c, 0x3fd7d46d7dc8a4f0,
    0x3fe3e7c0ccfb5d84, 0xbfea2de3e80b9bbe,
    0x40051465b338a38a, 0x3fefc08da6a25b20,
    0xbfd6afb92514df76, 0x3ff85f3320cf47e1,
    0x4015f23f4687dbd6, 0x3ff80b165a6185a2,
    0xc000db153165b15c, 0xbfe40abc0ce396c6,
    0xbff567367a659285, 0xbff9edf9dc3bb1cf,
    0xbfbae89bf8077714, 0xbff134e099aebe79,
    0xc0065c3cb6bdab16, 0x3fca8b23a049ea50,
    0x3ffeaa86770479f8, 0xc000342834868ad9,
    0x3fe2553c68be8464, 0xc00819dd0f4351d4,
    0xbfeee225060720d4, 0xbff868c3905eac96,
    0x4010dd3f346bd9d0, 0xbfe45436ea24b752,
    0xbff7e616bc22eb40, 0xbff51ea2723f8aae,
    0x4001f57922f19cfc, 0xbffa382e81a9e75d,
    0xbfe5703d91865f39, 0x401054a3a4117ddc,
    0xbffc6c1d682571cc, 0xbfe338565583e570,
    0x3fed757b0d2e68d8, 0xbffe3b0bfc2865c6,
    0xbfde7bf394d503d5, 0xc00d0510ae87e1b4,
    0x3fc21ddaf4786580, 0xbfedae7fa37c6725,
    0x3ff88acd99961fd3, 0x400a5e1ea1be1c97,
    0x3fef428dc33a5def, 0x400fdb4eb768ae60,
    0x3fe6aade5f06c398, 0x3ff890797795db7c,
    0xbfc16a8eec92a44c, 0x4011afdde79ae64f,
    0x400e5c31795557d4, 0xbfe73f98236ac09a,
    0x3fe821185dd53d6c, 0x3ff34a793d20c3e6,
    0x4005eaa97c4830ce, 0xbfd557f4a95748ec,
    0x4004423311e2265c, 0x3ffcf1cfe82e95e5,
    0x3ff9710f3ab9db6e, 0xbfff57e32353d6f4,
    0x3fd50a72b9e724c8, 0x40129124e7a024a4,
    0xc009e6392954aba2, 0x3fe8125a57d636b5,
    0x3ff758e775370cc3, 0x40044d1825620e94,
    0x3ffb3058e9353e64, 0x3fefda361c4bee3e,
    0x3fe56c21398870a0, 0x4005e92be9e56a10,
    0x400350f7ecd171f1, 0xbfd8a0a6e6e137fe,
    0xbfd08608eb7ec774, 0xbff27685eb922282,
    0x3fbd570884c4bd50, 0xbfe2a3c6228cf97e,
    0xc0041134bcc904bc, 0x4004396f90603e44,
    0xbff1fba016d6429b, 0x3ff7f84fb5c70340,
    0xc0092b1ad03a07ea, 0xbfffb892f780514e,
    0xbff087be716081e8, 0xc00632d85318f5f0,
    0xbff57ca7a556ae27, 0x400dbfd63f369762,
    0xc0099c6e775b38d7, 0xc003f260d0c306cc,
    0x4000f0fa0f578b4d, 0xbff0e70e2310521e,
    0x3ff052761367abeb, 0xbfdecc1f7b54512b,
    0xbfe9b9ca8dbe9e1d, 0xc008f7ab0df21f82,
    0xc0048045a7a0a388, 0xbfe826bcbc5fb990,
    0xbfeafa7c96bc410c, 0x40094a28f77ee668,
    0xc011a73b4e9dd636, 0x3ff796e7f5cdcfe1,
    0xbff057b1d4448c4f, 0x3fd78087768c8400,
    0x40153d9416e1adde, 0x3fe32f70104405c6,
    0xbfe37399bb718359, 0xbffba493ff981d6a,
    0xc00640879a49eae5, 0x400f4a7a7f68f1aa,
    0xbfaa9225b52f22e0, 0xbff0da5fcc51edd0,
    0x3fb3135c26b32150, 0xbfe8810006414ee2,
    0xc0056eb6bdcdead8, 0xc00cf7db999bde3a,
    0xc001d8f168f38c1a, 0x3fca1faeee0b42c8,
    0x3fd58e2c33f1b9a6, 0x40117183f84f1402,
    0xbfe4ac6a1e7d05ec, 0x3ff6ea12832ba972,
    0xbff236c75388ffb5, 0x3ff962c41fee5748,
    0x3fc5ed72aa0bf2a6, 0xc002c1e5d8150d6a,
    0x3f81da0b3ff4b700, 0xbfd4db8ce60a7860,
    0xc0029485307d307a, 0xbff516bf4a41f133,
    0xbfeda4787ca86b8a, 0x40012fedfe5a2e90,
    0xc004fe6cc603481a, 0x3fe30f5270a9c250,
    0xbff40e75386dda6a, 0xbfe8e7aff416f55c,
    0xbfe35e3c939ee458, 0xbff7bd4dc5930c0b,
    0xbfe7d0e9a30ed821, 0x3fd51ceb87f8ab6e,
    0xbfd4c327fcc93e04, 0x4009246480cdaff2,
    0xbfd382fc8dac4e98, 0x3fb1397854d66660,
    0xbffa86a56795e28b, 0xbfe6c480bacb3968,
    0xc00f313d7fbcc753, 0x400df779f8f9ea66,
    0xbffce2fafa1b2360, 0xc011cffcaa933650,
    0x3fdd1b34a0222750, 0xbffb1d24b594839a,
    0x3f7fca3df0ae2200, 0x4007682732f2d111,
    0x400787a2405660c4, 0xbff0d862abf7292e,
    0x3fd6ac4b47818cc1, 0xbff97382cfebeb5d,
    0xbfe8b1bac6140d89, 0xbfc47037bce94718,
    0x3fda96dd1ff2f0dc, 0xc00e559cd66eb355,
    0xc0098c04d35743dc, 0x3ff795608bd2be98,
    0xbff20eea9e8ec7b6, 0x3ff479d855b26368,
    0xbff7fb12839e33a1, 0xc014ef6e70923d49,
    0x3ff2f1c97e055e9c, 0x3ffa4c5bc499281c,
    0x3ff2b8592286655a, 0xbfef51fe72a2d79a,
    0xbff5b5157954c06d, 0x4001dd1f45321724,
    0xc0068026798a071b, 0x3fa611392c7f3680,
    0xc00dd0df9d20459a, 0xbfd796ed7fa84a34,
    0xbff8734b072d7d47, 0x3fe080e9f4b63624,
    0x3fee9438b8f59d22, 0xc004c8cc8b305518,
    0xbfb689dee3c83626, 0x4001c1857ac542ab,
    0x3fe2fd48bab5138d, 0x400028ee50b5a79a,
    0xc0050b9cc16acbc6, 0xbfb6e56e88e75d14,
    0x3ff9653e3907558f, 0x3fed50cd3685dcb9,
    0xbff06850788444b8, 0xbff197f9984acb9c,
    0xbfff487940d555ac, 0x3ff47a1e0d133717,
    0xc012a90ed8f70bec, 0xbffc6f1a69074266,
    0xbfc379bc49e63a18, 0x4000653291346456,
    0xbfd80c1da3036677, 0xc00187ff2fe67619,
    0xc005440726bbddda, 0x3ff20392587711c5,
    0x3fea477502a22990, 0x4008f382be4244d4,
    0x400f233aaecbd84a, 0xc0080e10999fc7da,
    0x3ff6095ee03e8608, 0x4000016bbd8334b3,
    0x4010b32fcc60f532, 0x4011e6c605336afe,
    0xbfe1c3ccbfe7429c, 0x40016a9b4c1997e3,
    0x3ffa98798dde57b4, 0x40169fcec0f3298b,
    0x400be3c3943853c0, 0x3ffb03f6ec0e846b,
    0x3ffd3af208da0328, 0xc00315bbc933ad2f,
    0xc0034e9cf16c8a26, 0xbfe9a0144505182c,
    0x4003c8b2d43aeb6c, 0x4006ab18c55ce4a6,
    0xc0071f4f877724f6, 0x3fddd4d1e011f63c,
    0xbfe825f90e3ce04c, 0xbff1af8dcb2ba466,
    0x3fec67a64e50ddba, 0x3fe570bf89a32208,
    0x40004ffc57da198a, 0xc010a7349a792409,
    0x3ff5915414f73f78, 0xbffcf8c5d97478fa,
    0x3fce3252ab4fd910, 0x4000a60d3476a931,
    0xc003e93af0d044bc, 0x3ff23942f5e538ea,
    0x3fd19b168a569da0, 0x4011b49c4391168c,
    0x3fa9e34b55579f80, 0xc0067b7b4f5b1963,
    0x3ffda4df9dcab512, 0xc0069eddc0a4c518,
    0xbfec1673be86928c, 0xbfe77977d2a66145,
    0xbf86350394ed4800, 0xc001bda467922fd1,
    0xc01385af8eeaa2b4, 0x3ff297e0beef605c,
    0xc007208eddd4a8c7, 0xbfe594c4761aef7c,
    0x3ff1620f9cc0b319, 0xbffda7d747a328a3,
    0xc009dd04526115fb, 0x3fe3f7e07b3b30be,
    0x3fd9665833824518, 0x3ff323ab5187701d,
    0x40057ad38f84c8be, 0x40062649b9de54cd,
    0x3feca54bc81c8928, 0x40019ca8229c0a7a,
    0x4016416e9f08eda6, 0xbff36990ad6ebc9a,
    0x3fe11856aa651ac5, 0x3ff33540c8ae46e4,
    0x400c85edfd3869e6, 0xbfdae110248e31ae,
    0x3fe81378f684c1be, 0x3fe23f9ed24aa37f,
    0x4006328090b9d468, 0x4002333fa5a5aa78,
    0xc00b4aa24aed85b2, 0xc0065518e1573ff2,
    0x3fe4903ae918a65a, 0xbffcc6240e5f4018,
    0xbff96ba1de1eefc4, 0xc00a9936062d130e,
    0xbffc2110abd9333e, 0xc00174a5792a89e5,
    0x40104bd88c2c9304, 0xbffe43daac6ac4da,
    0x3ff40981b9895ee8, 0x4003148b63f6bafa,
    0x3ffe2a5e83063160, 0xc00adeef63f2b01d,
    0x3ff09f442f96d0fe, 0xbfe6da989b22fbf6,
    0xc0006dd46b13d056, 0xbfe6b846ed3583e4,
    0x400189be7a3d2e16, 0xbfcaf04c59f2b7b0,
    0x3fff53136c33dc42, 0x4011c3132d2095ac,
    0xc00649129688e97d, 0x3fde445f2569ee40,
    0x3ff2d036d31e15eb, 0xbfe8dd14c7819134,
    0xbfe2c72c0f4fdd9c, 0xbfb731816ff1c870,
    0xbfee56dfc7283d66, 0x3fff43d8fd7dd202,
    0xbfffa6b76347fa3a, 0xbffa0af2d51ad342,
    0x3ffce8624b7af6f2, 0xc0008b02f444466b,
    0xc0024a347e86aad3, 0x40065d28ed2ae240,
    0x3ff354f0b3020d48, 0xc000913b05ca0c19,
    0xbfd6cabe7d7bf164, 0xc00555719614eef6,
    0x4003516d1a78f62a, 0x3fed79d3a829df89,
    0xbfbb59fb50c9fd00, 0xc01159fcb37b72b0,
    0xbfbe605f4e375208, 0xbff508ad23e1e557,
    0xc01096feb060054f, 0xbffaa67d040a9c19,
    0xc0026f48b434bec8, 0xbffca86772c17a68,
    0xbff4ec15feb6d4e4, 0x400a9f44f548e03a,
    0xc002bf8a4f996f70, 0x3ff35ce3f95643c8,
    0xbff9aa55af1671f8, 0x40044b8d35db394c,
    0x4002aee5a936f125, 0xc00671114acd58fe,
    0xbfe9d87d565432c0, 0x4004e761ecaeb9b4,
    0x3fec21e77f0601ce, 0x4008fb30aae622ac,
    0xc00ae90b7d2cb140, 0xbff4424f33662365,
    0x3febf0eec91f32ee, 0x4003730ba21406b6,
    0xc0099fc8538b65be, 0x400b7ab1060757b1,
    0xc0021a54d94c8eaf, 0xbfb653ac6b3bc020,
    0x3fee3817ad3a6bf4, 0x3fb9b126c86b76d0,
    0xbfd868bc907c8d5c, 0x4002cb4b04452bd2,
    0x3fec6432c090cb5e, 0x3fe50475fa1d7dc4,
    0x400b05314332b5b3, 0x3fce09e86efc5ce0,
    0xc0096c63a3ec35e2, 0x40034fb36aebffd6,
    0x4000116a1364f988, 0xc00436948b9c5221,
    0x3fe67e29c48d5776, 0x400f61e0e055f00d,
    0x3fde9378431e51d8, 0x3fedf5be3104d4ba,
    0xbffd1a03bd26e30f, 0x3fd426d177417858,
    0x3fe2d7ad6d7847a6, 0xbff5042986354fef,
    0xbff397b95cc52102, 0x400d0a22c3259e3b,
    0xc00e235c8d9d0fcc, 0xc00383e2d6a2eead,
    0x3fe9fec01b017eac, 0x3fcf68fbdb90cff8,
    0x3fe4c1855eddd5ac, 0xc00b5323c8a1054a,
    0xbff346d970bd875c, 0xbfed660d6633565a,
    0xc00645430162e7d1, 0xc001f0a608a7a883,
    0xc005c4f02cef4d02, 0x3ffdd50d4b33624f,
    0x400556bc67bf6fbf, 0xbfe60b061b9f3e03,
    0x3fd2bf53c48b4909, 0xc007cf172cb6870e,
    0x3ffe2b2952e85fbe, 0x3fe84da28f77ff74,
    0x40118eeab284a0f1, 0xbfe982e510388b36,
    0xbfd291eeafe7b72c, 0x3fef9b391cbb202c,
    0xc014f19d93ef83ca, 0xbff94e4a57564904,
    0x40034760e918286f, 0xc004e8b6b824bcb1,
    0x3ff345f066094666, 0x3ffe3bbc53993f33,
    0xbfd2446e61defd85, 0x4004f0f029589c1a,
    0xc000e607ae23dcd3, 0xc011a5f545865851,
    0xbfd834b85a9afb2e, 0x3fe253be4a03aabb,
    0x40147c7fadcf00dd, 0x400f5b4ec03686b8,
    0x40086f6ad65bd1bc, 0xbff830c7fcc08abc,
    0xc012610077e41eaa, 0xc0033b4b5ba20788,
    0x3ff9003af5a456c2, 0x3fe621fdde738253,
    0x400182f59a6546d3, 0x3fffe7ba9b01be31,
    0x3fd9ec97cc10a20f, 0x4011b20d464ad093,
    0x40067932de90b8f2, 0x400c781154998283,
    0x3ffddeb93806ed98, 0xc001f18c66aefd2a,
    0xc009be7aaa2c45a8, 0x4001dd90e0f3ebc6,
    0x400b98da7eb5d54b, 0xc0089ba06b296224,
    0xc012a72d33b5a0e0, 0x3ffda9eddd8ff538,
    0xbfb5fffbb9f04600, 0xbfe46b3c871e93c9,
    0x3fe49c97a2e6b940, 0x4003041501a6038d,
    0x3fdae80531eb7100, 0x3ffd5c1dfaf3a958,
    0xbffcace9db85321f, 0xbfee1c05dd5bba2a,
    0xc013afc050d7c082, 0xbff133e3679775cd,
    0x3ff7278a6769d6d2, 0x3fe0067411b62c54,
    0x3faafc20482933c0, 0xbfa00807e5548548,
    0xbfee047c714f5df8, 0xc00028898cea4804,
    0x4011cf8bc01cb294, 0xc0040a628a369d4b,
    0x3fb40fcc534915a0, 0xbfeef2299a467df6,
    0x3ffb23cc4db70be1, 0xbfd2edc10d20e826,
    0x3ff55f74083c2cad, 0x3ff706313e29113c,
    0xbffdd95b8c03eb82, 0xbff0bf866422ded2,
    0xbff35fff8fe66942, 0xbff0d2b6073f0906,
    0xbfc7989b67b392e0, 0xbfc38294fa56a360,
    0xbfe7707706a2ff8f, 0x3fa00c2362806140,
    0x3fe1c848f0a6be71, 0xbff249faf556ea43,
    0x3fd0aa5f1f5a4628, 0x400b1ea04e964547,
    0xbfe4680ae09c9874, 0xc00907f935b020c5,
    0xbfa52fbf33fcc750, 0x40079ce4d1c3f092,
    0x3fe780e487567f1e, 0x4002cf9883494674,
    0xbfe24abe0d1a7d12, 0xc0062fe6a2dc7786,
    0x4016edd3c582a0db, 0x3fe012e4ddc3df11,
    0x3ff1fe13a3566c7c, 0xbffa451d72e90b1c,
    0xc00072a1dc681782, 0x3fec5b0087481ebc,
    0xbfe3e88b122e8284, 0xbff81f8a5ee78f58,
    0xbff4e80277a04e1e, 0xbff1cec799999695,
    0xbff04a06ab33ae59, 0xbffe8801cde850ef,
    0x3fe94158f26a4114, 0x3ff949f8fb4cf3ee,
    0xc005e1291117affc, 0x3fce8142364b1ad0,
    0xbffad274d98d7cb1, 0xc00c415906c178d2,
    0x4003fd4bb9b86adf, 0xbfc84d74fc8b0d20,
    0xbfe423b50e3c2b5e, 0x3ff4768306c7a9d2,
    0x3fe00c854b33cefd, 0xbfdcbdb468ec8640,
    0xbfd5ac3b02d129c0, 0x3ff8666f83395b00,
    0xbfd26be1ee94fb58, 0x3fce5dbb5e22c644,
    0x3ff0edaab568588e, 0x40041943faf05056,
    0xc0026b3d768f855d, 0x3fd0cffa30c6bdb4,
    0xc009ae03265a0814, 0x3fcf75ebb569a000,
    0x3fe15c4abe80e4ba, 0x3fe1d51954bc0096,
    0x3ffd4f5e436ee14e, 0x3fe1754c995cc69c,
    0x400239c76513ee03, 0xc008f65634cbdb10,
    0xc00409f1a5a6957c, 0xbfee85d67c14109d,
    0x3fff512b3db492f2, 0xc0128ad8b1399a8c,
    0x3ffad18d3691adb5, 0x3ff40aaacefce8b4,
    0xbff4c501d99fcec5, 0xc0125ea28f2d790e,
    0xbfb33b3756153ec0, 0xbffc34be0d21b684,
    0xc00e793a396a2287, 0xc0061e9f049320ee,
    0x3fec3bac548bf53b, 0xc01d34f4167fe8a6,
    0x3fee08595bc7f402, 0x400b6cfbb2640c38,
    0x400cf375883db8be, 0x3fde6eb4ec61e05a,
    0xc0015bb7feec0929, 0x3fd48e1095c3291d,
    0x3ff92cc5072fbe41, 0xc0072b03fe3870ca,
    0xc004a396b4dd31a6, 0x3fefb6d402994fde,
    0x3ffcb602e30bdaf0, 0x3ffdb2d8d22eacfe,
    0x4000525f1bb5c53f, 0xc013bcd16604b3e5,
    0xc0017b5ae20b238c, 0x3fcf856c3a77c0c0,
    0x3ff46701859a8055, 0x3fb9983f852354c0,
    0xbfee311faf1c641a, 0x3ff42c25d41a3117,
    0xc0154479f4f9dc0d, 0xc00da4d749cd5fa8,
    0xc016a872d0000c88, 0x400130d178f48473,
    0x3fec4535aed08d79, 0x3fc5fe5e6b4ce734,
    0xbfd5b0ec83e734c3, 0x3fd099bdfaee80b4,
    0x3ff59b67060d68e3, 0x3fec4bcd106b474e,
    0x400d20b5b52005bf, 0xc002b3932ddfb661,
    0xc016923930b2f251, 0xc002089008357820,
    0xbff8f8daaa597e68, 0xc00301442950b870,
    0x400962a31d8e060d, 0xc010ec8f4496b538,
    0xc0012829cddba3b8, 0x4004ddab03455e99,
    0xbfc09795726fbbc8, 0x4008992f5dc37088,
    0xc0037dd8a8c07250, 0x4000b46e64c391d3,
    0x3fc5106ae4f7c338, 0xbfd67aac69f2d746,
    0x3fde89fe46c05502, 0x3ff389b08d8b4465,
    0xc013fec12ebe8ae4, 0x3f9a341100e54ee0,
    0x3fe0cd072973b228, 0xc00860ef93947be8,
    0x4007c392dceb99f7, 0xc0082c3df5f03e9a,
    0x3ff50be95968a9c2, 0x3fe22a8ab7f38ba1,
    0xc0072ec6b70b4800, 0x3fde5c22d70148a4,
    0x3ff3a7188f9664c2, 0xbfd86af1b42735f8,
    0x4004d629daf82492, 0xbfb410e9f697fb70,
    0x3ffcf4d5e43fa604, 0x40046d3cf9dbaa89,
    0xbff42db362c2c84c, 0x3fee61a90d14feb4,
    0x400ec9cc543cfba1, 0xbff85970bbe9a0a9,
    0x40041284ab1cbaca, 0x40001767998c98a8,
    0xbff6b8216a2477d0, 0x3ff8b8e3dd2702c4,
    0xbff3fcdf7ffa98e9, 0xbf65b37fcb19ea00,
    0xbffb338dc6813640, 0x4003256e35224c78,
    0xbfdf89d589340004, 0xc019b8ed558181fa,
    0xbfeab7a1d49df78a, 0xc000ed4765a110a8,
    0xbffa2ea7ec6938e4, 0x4001dbcda70118b4,
    0xc00b38061040a2ff, 0x3fbc3504e73a92a0,
    0xbff17cef14a9f0ad, 0x4002f9508b20975e,
    0x3fe59251bc58a178, 0xc0111cefe1f4250e,
    0xbfc6b977b05399f8, 0x400120d4cfc9b91f,
    0xc0039b670d8fb3eb, 0xbfdcedbfae01e718,
    0xc00199b577de8c23, 0xbff3b2b523817e36,
    0xbfe0cebaa5ad3156, 0xbfdb4b383d259916,
    0xbff3bd79783fcaeb, 0x40194828cd241b5e,
    0xbff365dacd4dbb0a, 0x40114cd3fe6454e4,
    0xc000f1e32db8ee08, 0xbff14eeaa9f8b01c,
    0xbfff76f3537366ee, 0x401302c853288748,
    0x3fe5efbfc02e2e56, 0xc0097c8c7660cda2,
    0x3fc0fe9df36b6ac8, 0x3fd43967c6f2a78c,
    0x400a554416c6d926, 0xbfe76195942fff1a,
    0x3fafd55fafe11ca0, 0xbffe6b3064abee80,
    0x400583f7155db6c7, 0xc014865c4a7437dc,
    0x4008540a1e4825b6, 0xbfcaa0dfe984371e,
    0xc007f0c1ed5da1de, 0x3fbb0392e4dd8bb0,
    0xbfb947ddaad03e20, 0x3feab442a90090d3,
    0xc004c710138f91ce, 0xbfd98f13c5a962d0,
    0xbfe9fb5bed9a8e08, 0x3fb1e0c473a14638,
    0xbff03b512fc20dfd, 0xc0032499c88fe683,
    0x3febaa40044d3108, 0x3fc5bf1178ca8940,
    0xc00302e96fa1f92d, 0xc0057c1d2f7c6a57,
    0x3ff8eafcfdc9610f, 0xc0128e6421306a88,
    0xbff274c37327d46a, 0x3ff9e729efd0e1e8,
    0x3feaa7d7a532e4e1, 0x40076b881e6ce596,
    0xc0028d8f1dfae50c, 0x3fe5ac44dcb5affe,
    0xbfd83f036dcb71ee, 0x3fcae8a8973cb2c0,
    0xbff9ccb747e0ed88, 0xc00e4ef6801f29c2,
    0xbffb6a5eca1d28bd, 0x400cba4b219be8ab,
    0x3fe36e2c8c88de12, 0x3fde1ff632d8a950,
    0xbffa1c0a61704328, 0x3ff13eef433a3e8f,
    0xc00364f178e3f0c6, 0xbfba110ac40664f8,
    0xbfe148be195b47f8, 0xc00dd16939f0be8c,
    0xbfe23736292d9f0c, 0x40118df716bed3aa,
    0x3ffb6ad2ac82df22, 0xc001195bf0523284,
    0xc0080f73c4403ab5, 0x400249cabdc1122c,
    0xbfccc54732dd90c8, 0x3fc49bc5ca821390,
    0xbfecd1eca8ec1b35, 0x4008b088050c3a62,
    0xbfef7e5b50577878, 0xbfff7a018f42f31b,
    0xc0091ce7db16014b, 0x3ffa2ed7466ac4d1,
    0x400b76e812e1bd6e, 0xc005491131477ce7,
    0x3fef61f37ba9cc80, 0x401308eb3886395c,
    0xc01663ac7671c48c, 0xc00ab96a4437f4b8,
    0xbfe2e079605a5337, 0x3ff25d3875779935,
    0xbff8cc996260aeea, 0xc013321718b33e00,
    0x3fdc291d7b5210d4, 0xc011423b29306886,
    0xbfc4096ebf9346c0, 0x3ff539e9313a1d3c,
    0xbffe699c88f687b7, 0xbfd029fb541c36ca,
    0x3fcd9708be56ec20, 0x4001c2ae1c2dde5c,
    0x3ff62c406670d569, 0x3fe7449f8e1f48d8,
    0xbfa4d62d37e62ac0, 0xc00350d8b4cc9001,
    0x3fe3c86ed2d125f2, 0x3fc94a64dda20504,
    0xc006be87b07a5a00, 0xbff94b0d7f877513,
    0x40020a69cc204e22, 0x4005ada939cdd08a,
    0x3fd6564a7f0b6c98, 0x4004728a3df749e8,
    0xc0119ac3220c869c, 0x4007903163130788,
    0x3ff02870cfefd875, 0x3fc42798a9680070,
    0x3feaa064afd59e22, 0x3ffb1fbbc5929817,
    0xbfc41077dc518088, 0xbfe8906ce6d2ecac,
    0xbff35e0397456802, 0x40118f831e46302c,
    0x3ffb36309d5b1042, 0x3fd5f083177d9960,
    0x3fd2ab0ad2b01dac, 0xbfe47e015940037c,
    0xc008f7476e5cedfa, 0x3ff959f122a4ba84,
    0xc0067f950e6c27e6, 0x400b668d290501c8,
    0xc00bd5bd64e016ac, 0x3fe65d9fc4758487,
    0x3ff491565515be57, 0xbfe1f151cccfbfe7,
    0xbff3a9399bc7b1b4, 0xbfb1c1ddf974e960,
    0xbfc84e8393021160, 0x4009256706da46e5,
    0x4012538e7282abf8, 0xbf76e570437e5600,
    0xbfe050541564a348, 0x3ff2c87c83bb5bbc,
    0x3feb29fa3db7185d, 0xbfff146c1b03e5fc,
    0x3ffdd1de4f387ad7, 0xbffe6d8294dacf74,
    0x400fbeceef5cba4f, 0xbfd5aa291de703dc,
    0xbfebd0cb888ad62e, 0x3ff1a770f08a09bb,
    0xbff21e7722499bc2, 0xbfda57395b8ffd24,
    0xbfff4821ef837639, 0x3ff45f428bb8b5fe,
    0x40106384bce3cfde, 0x3ff1c931f3dd3154,
    0xbfebc9891b0a8f5a, 0xbff93bbf638f4c0a,
    0xc002f03291fc783b, 0xbfec6033971fa298,
    0xc0036179200b02c7, 0x40076f500e85cf70,
    0xbfb0d971963434e0, 0x3ff0e92fcc59a855,
    0x3ff6c18b3f567aa8, 0x3fe8a0e216346c90,
    0x3ff66c65aaceb6e6, 0x3ff57860aa175c18,
    0xbff25edc931af12a, 0x3fcb1d3d6c46f878,
    0x400b582fced506f4, 0xbff4b81b3eb465ac,
    0x3fd3d43031513e26, 0xbfe59cc945dabf19,
    0xc002314f53d26aac, 0x3fbf9076f2910070,
    0x3fd998c872137b24, 0xbfecbf6b2876bf53,
    0xbfef57df9e5dc4ee, 0x3fe5b22cb88318f4,
    0x4001a323e2ed38f1, 0x3fd680670b1daaa0,
    0xc007a40cd69d4d5e, 0xbffe08e1f8ca1d4e,
    0x3fbece5b4853efa0, 0x3ff3641d37ba5657,
    0xbfe1abbfd1574db8, 0xbff3e89706076fc2,
    0x3ff56662fe805cef, 0xbffd58f471c68a70,
    0xbff1b244646cd1c3, 0x3fd605623ef7b8d2,
    0x4005ee2488eb1c86, 0x40050e1a5a8ba012,
    0xbffa1bd08305693d, 0x400e263f7906ffc2,
    0xbff665c640da2384, 0x3ff4c757ee49a525,
    0x3ff8fea2164b84b7, 0x400a84b5c635d01b,
    0xc00183a045b087d5, 0x3ffdeac3e22299de,
    0xc00692730ffcecac, 0xbffd91a738022f32,
    0xbff99cc3a5b44192, 0x3ff86326d01194eb,
    0x3fef9afdbf741db7, 0xbffe3534f6a3bf93,
    0x400682e2bd76c47b, 0x4003686ed5f9cba5,
    0xc00669a76e767798, 0x4010bf16ab24bee8,
    0x3fe00e7760e3c806, 0xbf987829f10dd260,
    0xbfe9b2f7366feb80, 0x400976f96f8881f4,
    0xbfda757adffe6b9e, 0xc012940b9b1ad366,
    0xc003b5e3c7c0e582, 0x3ff0accaba8fcdb1,
    0xbfacbfc1818b8520, 0x3fde0fe045ae980e,
    0xbffb252b028fe5a0, 0xbfee88b92323ffb4,
    0x3fe1075b45a83ed8, 0x3ff48ee9bdf4db84,
    0x40052d33e4c78d2a, 0xbfe2626c97113a2f,
    0x3fdf89930ee56f16, 0xc003dabe85a5733e,
    0x3fe2cda845cbbff4, 0xc0033282c7b229e3,
    0xbfebdbca4e58795a, 0xbff18729b9f8e939,
    0x400088928017d533, 0xbff884c966c7b43e,
    0x4005ad713fadda04, 0xbfefd096fd217417,
    0xbffb110f33f7759c, 0xc00055977cd98d5d,
    0xbff44cbf7e327925, 0xbfee0d8db5a2ba19,
    0xbfef79b393d03362, 0x3ffabf91e4f6bece,
    0x3ffec030e9bf8ff2, 0x3fd0d9b7384cd448,
    0x3ff760997c62de51, 0x3ffbf85450aa0226,
    0x4008f9a1e3435707, 0x4004bfd001fd822c,
    0x3ff01306ac028925, 0x4004b1c0c0c360fc,
    0xc00e8fcdd72e3fcc, 0x4008063a70be00ec,
    0xbfea5a8876314a90, 0xbfe8d9226d590608,
    0x40016dad81f71194, 0x4003cb97f7c1e920,
    0xbfda8ed457dad202, 0x3ff6db91f501ad38,
    0xbfe1941aaf785c7a, 0xbfebc01597941718,
    0x4004b845ae564fb1, 0x400c92c2b5a21b71,
    0xbfe1dd79a5a4569c, 0xbfbc1da528a84020,
    0xbfc4f3a08d6a4290, 0x3ffbf5b53787bfc6,
    0x3fec3bd75946c8bb, 0x3fed339bfc383b59,
    0xbff34b76e61f1b8d, 0xbff5525093f62c38,
    0xc0154e70bb9ec917, 0xc004249941ba4096,
    0x4004a4aed094606d, 0xbfe5c75e332c7d60,
    0xc0115df863daceae, 0x3fe6112735d53bc0,
    0xbff0611d3fce968c, 0xbff7a383139ed7a6,
    0xc002fc9402d47b04, 0x3fee6408f7318e57,
    0xbfe0593db251fc62, 0x400adbd8973ae521,
    0xc00a5810d43fc066, 0xbfeabb403744d92a,
    0x3ff0a696527d0186, 0x400f9020244e4291,
    0xbfd3c98a3d896df8, 0x3feda7434bec4d2a,
    0x3ff900f913ffe67d, 0x3fe143a9f806eb3a,
    0x3ffdb62c951a4ab1, 0x400e0302e367ec5f,
    0xbfed99d8063c9bd2, 0x4003bda9b5031acd,
    0xc00835fd879fa8bc, 0x40032fc180f4f78c,
    0xbffe4f50faa31f8c, 0x3fd0b163499cd974,
    0x3fea225d27dbe99c, 0xc00df763a6a90d98,
    0xc00f7c69f700a157, 0x400c60845cc01566,
    0xbfe7040b04710a94, 0x4015ecd0082189e6,
    0xbfed54c6fd829786, 0x4003ac35eb970728,
    0x3fd3833f929a685c, 0x3fecdf4b501516d7,
    0x40068b32b4b7ebcd, 0x3fe98ab6e9649412,
    0x3ff1fb48ffaee7c5, 0xbfc90f0db4ea5770,
    0x400279bf1313b866, 0x3ff14b454b7c2bfa,
    0xbfedacbf4a1fa7bc, 0x4015398b7d45396c,
    0xc00228b9c9e19b16, 0xbfdfefff05fb0eb5,
    0xbffa67b8df715694, 0xbfa72ca34ee1a4a4,
    0x4011366a03400772, 0x4008aa09979a35e2,
    0xc000262f5ea147d4, 0xc00f13e97ec767ea,
    0xbff9e1a8c259566d, 0x3fff98c86a9bba2b,
    0xbff57293fd9fe991, 0x3ff82a1ca3551737,
    0xbfe0392c1cdfb214, 0xc01562915231c795,
    0x401369e132b311e8, 0x3fc999a5f2b64ce8,
    0xc0039b47c41b4266, 0xbfed8282cc9695c8,
    0xbfb28c24c6aa7df8, 0x3fedac5022e75aca,
    0x400233812847934b, 0xbff57f839b84bb9d,
    0x4000dbb9b6979186, 0x3ffd6e40244957cc,
    0x40065e750bba813e, 0xbfdcd55c74a2e7d8,
    0x3fe5ca6c4852de16, 0x3fe4ef664d5d06ef,
    0x3fe721c516074112, 0xc00442db2330ce85,
    0xbfe0ddecfdf292ea, 0xc003eba5ff8537ae,
    0x40189c3a6f38d874, 0xbfe8dcef0db7b472,
    0x4008f9bc1bcb3fe4, 0x3ffb94d7c3dcbd13,
    0xc000ee17ba50e8eb, 0x3f9db3c01d52e4c0,
    0x3ff090a8b20c7eb1, 0xbfb0aab43efb6e50,
    0x3fe1aa5e8ee490a2, 0x400ed791f84eec93,
    0xc0079db1fca3e094, 0xbff5e26d9f5f9ef3,
    0x3ff44b7a764c3f30, 0xc0128c7407bf4f2a,
    0xc0039f8336e79613, 0xbfff49ea600e46da,
    0xbfe734590e568682, 0xbfa9b7f767e80e00,
    0xbff4c05590fec0fc, 0x3fd11d7e9df76610,
    0xbff0737a00a6a78f, 0x3ff2b258fe0cfe94,
    0x4007c52257452d76, 0xc00edd8f4686cf21,
    0xc00156adc8a30c06, 0x400e3eb459c73ff6,
    0xc0024992cf909189, 0x40144dd5006c26cc,
    0xbfed99af6a5b50b0, 0xc00b09d2f3c5a4cf,
    0xbfe699ba9dc6d87b, 0xc0093972cd5bce72,
    0xc002f2331d601f96, 0xc00074e87b11b06f,
    0x3fb5c468b2031e40, 0xc002f01954f2e251,
    0xc011a330acb295bf, 0xbffc2211402e7056,
    0x3fd22c430b23c551, 0xbff88f8bb3137eaa,
    0xc00b3cd4dbf43522, 0xc00239a13a1347b4,
    0x3fff3e6d4be4162c, 0x40085b8c8af8274a,
    0xbfffeb214fd71b36, 0x3fca709d46c66f44,
    0x40109ceddf5faf30, 0x3fe638c66c00e856,
    0xbfdfc2e53e979664, 0xbfef92a02f8ccdf4,
    0xbff0f12380ae376c, 0x3ff794a75b730208,
    0x401626507030330e, 0x3fcc45ec154c1eea,
    0x4000f3a16ff7d9e2, 0xbfe9ff55b754cf66,
    0xbfe87f55f57b2176, 0xc002db31a6f8d3e4,
    0x3fc193d82dfd0df0, 0xc00788478e8dac6a,
    0xbff99325796eed89, 0xbfd4b34f5faaa5f2,
    0xc0011b7d836cbd34, 0xc016bb121bff6bf8,
    0xc01b52934c2a2988, 0xbfe048cc172bb2be,
    0x401166990e4be567, 0x40065c72f397e678,
    0xbff24387778bd452, 0xc005aa4053bc47bc,
    0x3ffffd946354054c, 0xc00a88f161694cfa,
    0x4007e490b1e12def, 0xbffd8208120ac55e,
    0x3ff370e35aaf2150, 0x3fe02bf5eac367f8,
    0xc0131f1c8713a18c, 0xbfe51ba2517a6470,
    0xbfa438fccdd695e0, 0xbff99f1a757be5c4,
    0x3ff01930101e5500, 0xc0034e907d2388a3,
    0xc00007551d1cedc4, 0x3fe1e4ed709db0e5,
    0xc0136d64af90aced, 0xbfefeba281b46e4a,
    0x3fe4350d4bc50150, 0xbff6b8c19065d0a6,
    0x400228b61a8e97dc, 0x40068f0e4edecba1,
    0x400d9a640e9f4c06, 0x3ff3ea33d85f10c9,
    0x40160ae771c3b0c8, 0xbff4f0b1398baa98,
    0xbff5a29be7181592, 0x400b294d470bde60,
    0xc00b668c745b95dd, 0x3ff00d0383e4cf46,
    0xc002afb79d838ee0, 0xbfe3b938ad95f07a,
    0x3feecc23b7c3556e, 0x4003a639ccad5e7c,
    0x4010cdd25cbfa64e, 0xbff83e62b8268bd0,
    0x3fa2eaf9e4dd8680, 0xbfd34cfa5f838ae2,
    0x3fb6639565738908, 0xbfee3672a58c34b0,
    0xc0016385e92806c1, 0xc005c375026f5fbc,
    0xc001c78f9c646110, 0x4001231f741614fc,
    0x3fdaa7c5c704ce10, 0xbffd9dfbec7abd4a,
    0xbff7aec436b0333a, 0xbffb7a716ac6aea6,
    0xbfdeb052b4979e3e, 0xc0081e86069f14fc,
    0xc00d37190c2c847a, 0x3fea04b9c6f062e4,
    0x4005622b42e72474, 0x40072c55df7bff7c,
    0xbff28da735dd637a, 0xc00625091ba53d62,
    0x401384651851050e, 0x3fe50c5727af09e0,
    0x40027a7796641913, 0x4000a610d362d5f2,
    0x400986a2ca113ef4, 0xc0033e3169bceab8,
    0xc011207c539ba022, 0xbff3cc405cde62f8,
    0xbff341efd043fb38, 0x3fd653522e249683,
    0xbfed0bd8fdf385e4, 0xbfe934aaea87ece6,
    0xbfed6d2be7138262, 0xc005ae9075c48b50,
    0xc004f3019c82da20, 0x401108e3667aeeb4,
    0xbffb9bcbfb56552c, 0xbff64a4bd12bd88e,
    0xbff7c9ce5aa47498, 0x3fef5714d4c88e4e,
    0x400045a952c66379, 0xc00571e29ccc9974,
    0x3fd443a99e61143c, 0x4012af84cd093324,
    0xbfc248d2c586c864, 0x3ff3c326c2347f43,
    0xc00acee1557870cc, 0xbff605e2f26b5864,
    0x4004f74c9ba364d6, 0xbfec9595649f5efc,
    0x3f7b287b363e9e00, 0xbff077e8ccbfad16,
    0xc00ab638541a6752, 0xbff5309bd768a702,
    0x3fc33d712465ccd0, 0x3ffe50ede2fb82f5,
    0x3fe409a17529a6da, 0xc00234b5389828fb,
    0x40010842eb853aca, 0x4004d7d3ed120351,
    0xbfe7668c3224d56d, 0x3ffade23a106d113,
    0xbff91e4130ed4e4a, 0xc0017c11a8e52c48,
    0x3fe778d1a2efae98, 0xc003b567d3f2e348,
    0xc00e3b7b8ec5e947, 0xbfde70f1407e608c,
    0xbff5f75c399cbcec, 0x3fc786e5a46226f8,
    0xbfe95e8517e7eb72, 0xbfe690438fc7f9ff,
    0xbfd00ac144659938, 0x3fe5be7513044ee0,
    0xc00dc42e3be4803c, 0x3fddbaddaa13ad60,
    0x3fa16ffed7e302c0, 0xc00426e5dfc6244c,
    0x400e7829f2258b90, 0xc01028d6a1d3a986,
    0x3fe5818239784930, 0x3fd384da675a76a0,
    0xc001b02d5fd84c0a, 0xbfde15980e684868,
    0x3fef30f84da2cd72, 0xc001af6ee8a6fcbd,
    0xc018521fd133791a, 0x401014de2c47b196,
    0xc001870a1e8951b6, 0x3fd25b167711d984,
    0xbfe0df9ce9aeb2e6, 0xbfff0bd40cb25ad4,
    0xbfee6826de7da3b7, 0xbfb025dffb3d0e80,
    0x4012b024c2a270c1, 0xbff536f031f732f2,
    0xbfc49fcb6c7587e0, 0x3ffa84c6150e27a7,
    0x3fbf271b4e579878, 0x3ffae0a6b014288e,
    0xbfcc7df5493324f8, 0xbfe4da80701597b8,
    0xbff928415b8d406e, 0x40023e5c501b6265,
    0x3fe2f6042f6eef90, 0x3ff8862182043f2c,
    0x3fec3ca4fec1e5ea, 0xc0115c1e5385f1e8,
    0xc002a9cc37996826, 0xbfd07c7c64c44a50,
    0x3febabf3b18f012c, 0x3ff7df77a3e7fd23,
    0x3fe07d9020dd9095, 0xbf80ba3423210080,
    0xc0032b57ef2810a8, 0xbfc5a714f2a96594,
    0x400a6c81b232e68d, 0xbff82a351c51f603,
    0xbfc1b962bb2a8570, 0x3fef1f8c7001efb2,
    0xc00b4227b003ca22, 0xbfe3f5146e1b82ec,
    0x4006f2a8efced860, 0xc004e1b32b9743ce,
    0x4012d7ea92e4b155, 0xbffc63c8b91b7e60,
    0x400809cd4c5d7732, 0xbff88ebf753c42e2,
    0x3ff07fe94c50e5f0, 0xbfe9175e771b99dd,
    0xc0021c7c15679878, 0xbff16d0d4bc1c6b0,
    0xbffb1821ec4d047b, 0x4000749bcd3a2d80,
    0xbff737afe107f4d2, 0xc009daf0775320ee,
    0xc007f8ea2dbfca0b, 0x4012c4180d400f2a,
    0x3ff57193ad2e37dc, 0xbffd80354636e47e,
    0xbfefb90f7d624c3e, 0xbfe44425c7ea98c6,
    0xbf84cb78d93e7600, 0xbfdc84de3b94527c,
    0x400845f9fd556bc8, 0x3fee2e8b88cbfafc,
    0x400958242d4996e6, 0xbfe3b83a809c59f6,
    0xbff190c2be4a71c0, 0xbfeea1a2a609874a,
    0xc00557ef76a26de6, 0x400e7ce78d9fe955,
    0x40014a2382ef4bfb, 0x4000374d2f480751,
    0xbff29e63df104a50, 0xbfed32d70b612ab4,
    0x40123f695f4f30d5, 0x400b87e8a5913983,
    0xbfce60534b0a4848, 0xbfe870a869b85e2e,
    0x3fffffe62b62c121, 0x3ff395f631e588a2,
    0x3ff9708549126b3c, 0xbfbb39ab2f1788b0,
    0x3fe27f0a283831d2, 0xbfd818bfab35dafc,
    0x3feefe6a77742b3e, 0xc00ce2a166e27a54,
    0xbfe3a356961dd8ce, 0xc000c28d0792f1b2,
    0x400c4b6668104700, 0x400b33bb41877ed4,
    0x4008d0cf96d7c0f2, 0xbffd7ae45526ffe4,
    0x3ff0d794105ace78, 0x4001a83256a238d6,
    0x40091775926f5466, 0x3ff76e9092a55b8b,
    0x40124a0b5df3b8d6, 0xbfef52e67a7bea45,
    0xbfe8a5d4717c1d1c, 0xc00e18ef38f21e0a,
    0xc012123ac9e46ec4, 0xbfe70bc2232643f8,
    0x3fe43384d6d70421, 0x40112b7be63434e5,
    0x3fc60b5c1a867850, 0x400010cdf9af31e0,
    0xbfe2c4bc52a79ff6, 0xbff2297ea0979e7e,
    0xbffb82b506dea39a, 0xc00486fba854e980,
    0xc002da6c066e8c34, 0x3ff13c36dafe3e95,
    0x3fcf32a1a1af593a, 0x4001c27780d46104,
    0x3ff8ab0e0d91f3b0, 0x40106c32ce0c0b48,
    0xc0057a96a8e31ebc, 0x401a95f3011787e8,
    0x3ff8749a72d8bd7e, 0xc0145e664a17322a,
    0xc008f2e4ec8ce1c3, 0xc00b40bf3f6b2b66,
    0xc006765f0d462fce, 0x400c443013f32e28,
    0x400305176a8e8a4c, 0x400d591849c3167b,
    0xc00e30d159a3bf65, 0xbff3c5cb51535608,
    0xbff7465927f5777e, 0xc00f7adf88b967b9,
    0xbffd3f13230e5f41, 0xbfe70239541fa5e6,
    0xbfdd7e4f1e8a6cd0, 0x3ff8a08250b65c62,
    0xc0021bfb5c15d637, 0x4000f6f7f3671c0b,
    0xbfd246b887dbcc1e, 0x3feaec18bf9d9693,
    0x4014f052ced95b6e, 0x400320f12e6e6250,
    0xc003bd582aac168a, 0xc005254e457d3552,
    0xc0031fca2c61cf84, 0x3ff0e696de8e2312,
    0x4000889358fe6225, 0x4008845deadfc1b1,
    0x401307efd1a1fb26, 0x3ffffcd5841e79c5,
    0x400e0dd48adddafb, 0xbffa40213df2a12f,
    0x40099e5bd4243d2a, 0xc00aafe3b1187f89,
    0xbfe424d00bcf892e, 0x40058cc093250f11,
    0x40116af2458b780a, 0xbfef2b9c4141d713,
    0xbfd6f0bcc062f9b4, 0x4000ea59bb7e838a,
    0x4003c6da1e2c3cc4, 0x400e42a242c587e4,
    0xc0077162e3a8a092, 0x40127eafdfaa5638,
    0xbfd9652e99d016b2, 0x3ff9ec14705a2877,
    0xbfd09c2258953908, 0x401050dbc5fd7a13,
    0x3fd74b4e63ab76b8, 0xc00482bcdf828b1b,
    0xbfed63e7535b0b6e, 0xbffea5888cf8d0af,
    0x3ff5641440ed704a, 0xc0026c2507dcbf2e,
    0xc014bdfeaf31ec58, 0xc0037eabd73aec4c,
    0xc0001a852f8dfe06, 0xbfe9fca33803de5f,
    0xc00059c396389156, 0x3feebadfe450d6bc,
    0xc0121ff3b98f190d, 0x3fc8c53a07d99a74,
    0xbfeaff3fc5cf8db2, 0x4006c43bed7d4666,
    0xbfc2aa7a1f214778, 0x3ff1715351f6f74f,
    0xc0026c99aede8fa2, 0x4001783ac0c5f4b6,
    0xbffb60244d18e288, 0xc0098e5e81e8fac2,
    0x3feae9a6be6c2778, 0xc0009ea392c9490b,
    0x4006c8552eaaab1c, 0x3fdf889b5ce69b2c,
    0x40005021120036a2, 0xbfe1969ff2e67ff6,
    0x3ff9c2963bc1e249, 0x3fdc43acb03199fa,
    0xbfedd366657ff889, 0x3fffeb5d31fa991c,
    0xbfda2a6d3c5a9598, 0xbff3772107aa368a,
    0xbfeefea7c4bc58f0, 0x400041b37070b7c8,
    0xbff22c965a3f99fe, 0xbffb24c3fc2396a6,
    0x3ffe91ab47dbac22, 0x3ff3bf927c10baae,
    0x40172967e3697102, 0xbfdca130ac65a9a0,
    0xc003d0f6b5e0a2e2, 0xc000037c339fd621,
    0xbff6ee892037eb08, 0xbff146ae9535b3e4,
    0x3ffdf1f6df06c9ac, 0x3fd2bd45f5fe1c6b,
    0xc00843ded63269d7, 0x400cb248cfe78f57,
    0xbffa252ec08346aa, 0xbfcfb63716cec860,
    0x400a7cbdb96c247c, 0xbff8cc6950ab810e,
    0x400c2abb115405f0, 0x40160cfaff8c05df,
    0xc0048356c99334b7, 0x3ff89e776e95f2ab,
    0xbfb43fb7a2d06104, 0x401060a732c528f2,
    0x40035d6cd41e3880, 0x3ffc0e47a2d944c4,
    0x3ff8b6d7ae57de98, 0xbfe1cc0384e04612,
    0xc0006550f714c1f0, 0xc003445f1af7f128,
    0x3fe2c8deaa77864e, 0x3fd404f46d4cf3e8,
    0x3fd334cbf2b512de, 0xbff729d1c38d07af,
    0xc00716e27dd31437, 0x3ff330a6a2c44189,
    0x3ff5b68e6f06e67a, 0x3fc2e401ab364ff0,
    0xc00c55f94632094b, 0x3ff3f46f80f77bee,
    0x4003719cdd565f58, 0xc002904c4dd2ee20,
    0xbfc8f44bc113ce94, 0xbff52c0a21c48b3a,
    0xc008388f9e90668c, 0x40063af1088b44cc,
    0x40146bcc3ac1bc12, 0x3fd4aacb696338d4,
    0xbfb4ce1b6169cf68, 0x400b4fd44cacf7ba,
    0xbfe33fdd500dc471, 0xbfcaf3f11be69dd8,
    0x40012b190fccbf74, 0xc0103df2ca0d365e,
    0xbfbf7ad9e3fdbc50, 0x3fe5934ac29988bb,
    0x3ffba77275f00341, 0xbfe0e6d40165b978,
    0xbfbb40345cade198, 0x400285ae67bd0016,
    0xbfe9d46d2373e940, 0xbfa6ee04c472cdc0,
    0xbff7818743d89176, 0xbfe801be42364957,
    0x400c0b5a8636ce23, 0xbff5c11d4e1081ec,
    0x3fe773631cd60baa, 0x3fcd679afe241e18,
    0xbfc74c5f8a81171c, 0xbfff61341f4bdaa7,
    0xbfeea5a1f89055d6, 0xbff53ea1f7bf9df8,
    0xbfd5e7a01a9324e8, 0xbffee57a05d96f28,
    0x3ffae03a9c6bbbe3, 0xbff62516062bc432,
    0x3fe3d8c69c943b2e, 0x4007fa1974b1b3fe,
    0xc009ae6eb66f6734, 0x3feacd7210f618ad,
    0x3ff9041aff41e57a, 0xbff5028edffcb8fc,
    0xbff4f6a6be1a590f, 0x40105b466f8932f8,
    0x4008973707590ff5, 0xbfe02ea11d6f4634,
    0x3fef07abdef22add, 0xbff8883c954883ef,
    0x3fea1f833ec5be94, 0xbfc217bc2da0906c,
    0xc00ce314079aa5dd, 0xbfe2c2c394c75274,
    0x3ffdacc92fe6f1e8, 0x4002b9c6f42f81c6,
    0xc00bb92db9a5eca0, 0x401947296b1ff73a,
    0x3ff22e6e0965ce52, 0x40007b242fb2ffda,
    0xbff0ba13da78bd40, 0x400e3df55c3bba31,
    0x3fd14dbed74e6794, 0x3ffa6b4d8806026b,
    0x3fd234bb20c0c8fa, 0x4002b06ec1188d0c,
    0xc005a42e069a7240, 0xbfe96f14308b21d8,
    0x3feae8d525b77925, 0xc0079fb8c8ecf6f2,
    0xc00fd03ee8ab9a48, 0xbff192c976750ec2,
    0x3ffc74407bad6a0c, 0x400ad57cdff0d364,
    0x3fdcc51eb3766de6, 0xbfe64ca8a9c94924,
    0x3fe675589db0895c, 0x3ff537897c048794,
    0x3fe72628b0d7bd28, 0xbffe00fd964fd7dc,
    0xc0025b476ec324af, 0x3fe6ffcf44948913,
    0xc002086e2818eb1c, 0xbfec5bf23b1f3942,
    0xbffdbc611d107c10, 0x3ff052dabfad0d10,
    0x4004927f660b82cb, 0x400430244bddcd87,
    0xbfa44e9135dd8430, 0xbfc066c556b20c28,
    0xbff0b9db1e13f292, 0x3fdc258a71c0d227,
    0x3ff0a12fe888214a, 0xc002886b13ef9b54,
    0x3fee565c41581e1c, 0x40008c0e7d66609c,
    0xbfea16d0e43adb38, 0x3fd4354f3d1449e4,
    0xc0025f165b35bc7d, 0xc005eeea575d8572,
    0x3ff5779a77f52675, 0xc0051a5c57e0d35c,
    0x401333c231460930, 0xc00875c1c607604a,
    0x3ff708b69ad35899, 0xbfffacdfd90a053b,
    0xbfc1a84058aa4744, 0x3ff77577019fd9af,
    0xc00874a34d184ba2, 0x3feae4e06944a797,
    0xbfc4ff8e31ccebe0, 0x40012418fd738bf9,
    0x4004c724c899fb62, 0x4010f0537291d8af,
    0x3fb1f9a829c2a160, 0x3fffc0fb5776d908,
    0x3fe07c5851f88cef, 0xbfc19b0fa493614e,
    0x3ffa6dd59f15d4d8, 0xc0187e76819bf17a,
    0x3ffdbeb9f7d25e44, 0xbfd9d362a3d80de0,
    0xbfeadad75da286da, 0xbffcc8bee2a0f4b6,
    0x3fd70b16ec3fbf3c, 0xbff824e4f8aa0d1e,
    0x400142cf34a34904, 0xbfed2d103cc25c4c,
    0xc00db29ba1eb152c, 0xbfe4f3338db950a8,
    0xc0057b616ce61331, 0xc009fdde5c1c8232,
    0xc0053303fd3f09f8, 0x3fd9b0037e655742,
    0xbfeea55f6079b436, 0xbff605b201f002b7,
    0x3fe6416ffa84ff15, 0xc0144271e1832bac,
    0xc00786989b2e7b98, 0x3ff515871cdbb7b4,
    0x3ff03ca89610e337, 0x3fdc0a5f6d815ab8,
    0x0
    };

static const uint64_t ref_rfft_noisy_4096[4097] = {
    0xc00ada05db8ecc9e, 0x40085bb07d074562,
    0xc006a1903c67d7c2, 0x400b901cafc705fe,
    0xbfe0a84a0db6bb0a, 0xbff358360c005e30,
    0x3ffaaa37eb686be2, 0xbfed04f1d3dc3e48,
    0xc007f1de29fb936a, 0xc004b423a087d058,
    0xbff6a9923068a898, 0xbff97cb6c2ff438e,
    0xc00525ff8ec1db1f, 0x3fd0972b464b1ca8,
    0xbfde019e83458cf4, 0xbfebe7e26cd694e0,
    0x3ff86e96d1b9de25, 0xc0046f09757d79ae,
    0xc00e6eebb57f15b2, 0xbfd5b55fd0ad6386,
    0xbfebb919e5f42b8e, 0xbfea1ed645854b99,
    0x40054f4cb2ee20cc, 0x400a2bbe9ca4d955,
    0x400b1b02c8987464, 0xc010d041c874d5aa,
    0x3ff1b79f361f42aa, 0x3fb391effef54f19,
    0xc012777ef521054e, 0x3fe6c66fd53ce579,
    0x3fd3c34c67c31f84, 0x400b3fe39a93f250,
    0xc00221b8ef5e3a80, 0xbfe6a925742f8da5,
    0xbff21632dd8dc070, 0x3ff0c9c1680dde04,
    0x3fe3b946b6763081, 0x3ff4b1b25d3bab17,
    0xbfea85301f7619de, 0xc00583a260efce53,
    0x3fff4dc7c348efea, 0x40055b3b77c6dbd8,
    0x3feb224f45ba1833, 0x3fe6fdea5caa6e61,
    0x3fff6c00e2a18026, 0xbfc4c7972061c068,
    0xbff25e4e5f33450f, 0xc0064d8f2552c9cc,
    0x40017c20d9f03d66, 0x4003147b7e83e8bc,
    0x400c91e76575ea27, 0xc01004442d8284e6,
    0x40101665cab474ca, 0x3fed88502f726aa4,
    0xbfe884a035c45bf7, 0xbffeb3d5a846aeaf,
    0x3ffd87cb94ce14da, 0xc0023930d9fe687d,
    0x3ff31c54e4d50b70, 0xc0055b34833cb5f5,
    0xbfcbf94f28da5600, 0xbfd7d5d94a468aac,
    0x3ff41266dd35052a, 0xbfee9e3eeae43203,
    0x3fe73d56f1c24014, 0x3fff57c9050c920a,
    0xc0065017e8448b23, 0x4005f6cbb9364168,
    0x3ffee25a10af4042, 0x400acd2596a0f27f,
    0xbfe01d9588a4ed47, 0xc004b7dff1219644,
    0xbfe61c92debedc3e, 0xbff348a8f2a93a52,
    0x3fd27b194896da82, 0x3fc8fe622d479bb8,
    0x400714999595f502, 0xbffe85479039919c,
    0x3fb55ef77f7fd3c8, 0x3fec4e2f1e343e62,
    0xc0003f5be65a8f12, 0x3ff8a137ce3f59e9,
    0xbfdb797fd2bd0749, 0x3fdb8a2049509f58,
    0x3fd494f85d2e6d45, 0xbffa477344657a76,
    0x3fea19eed58c1e50, 0xbfe89e1cfbe35b80,
    0xbfa2a94df0c658f0, 0x400585f64e41fe1e,
    0xc005a649dc88b323, 0x3fd0aab8e0423d2b,
    0xc00af94cb8c9689f, 0xbfdaebd89dbabde6,
    0xc0055950a6325ce1, 0x4006cec1d22cebb8,
    0xbfd3bab104e637d8, 0x3fe5835efedfbe8c,
    0xbff47e73c5dc46e7, 0x3fb4450a30070580,
    0x3ff22998a35366ee, 0x3ffa734923ecf652,
    0x3fc19fed702dd5e0, 0xbfe306ae2bed9909,
    0x400b06c87be07f50, 0x3ff01f8364d8b723,
    0x401212651ab79ec2, 0x3fd0046224943df8,
    0xc0064d092737435f, 0xbfc774991f1ed6b0,
    0xbff268558ce83e39, 0x3ff2bd8aa081be1a,
    0xbfde12463e5da00a, 0xbff21ad7a75c3899,
    0x3feadf7c1e850ea6, 0x3fe66e695ac5db3d,
    0x3ffd016bf066f5aa, 0xc00da3e5faed69cc,
    0xc005f99b6a69bbd9, 0x3fe34dc28d46f581,
    0xbfea6869a1d48994, 0x4000c3cc7e25e282,
    0xbff5400031be02ce, 0xbffb486bdb12a173,
    0x4000d40c65697d8e, 0xc002744d80601e40,
    0xc0048296915c02f0, 0xbfcac6c6cde7bc8c,
    0x400aa061c9c32346, 0xbfbf9ce6ed0ae760,
    0xbfec4f8a72f1d87b, 0xbff006f4f1cd0b5b,
    0xbffe21244ce7391a, 0x3fee739ed63f904a,
    0x4004cfcbd7bc2484, 0x4008886d979b7144,
    0xc018170930d5f952, 0xbff511d1e4b4b17c,
    0xbff91d1e890078dc, 0x3fcefea70c7a8584,
    0x400e420acc04d88c, 0x3faef16261c18f60,
    0xc00cba2e8a70fe99, 0x3fd67f068ecd1faa,
    0x3fe0c42b9df6d8a5, 0xc0088ea854cff52f,
    0x3ff85340bc330f7e, 0x3fe4fe1d840ea18e,
    0x3fe49b3e9f49221c, 0xbffb78e133ef69b3,
    0x400328a776b8bcf2, 0x400585b56f9d4580,
    0x3fc495cb241c7618, 0xc002a64793942d96,
    0x3fee1bf14e774069, 0xbfeb376a4b1be88a,
    0xc003fac79b59ba8c, 0xbfe0c8e461cbad54,
    0xbfe7fe11567070ea, 0x4005e07f7f427c81,
    0x3ff7a99774428806, 0x3ff566a6a6c62105,
    0x3ffac0a970d14d18, 0x4007dfd6cee7f4a2,
    0xc013d55fbf93efd6, 0xc0110c4fa3d35ac2,
    0x40091b09c1ed98c7, 0x4002c4c63a2b3c7e,
    0xc00261dbaa3f608b, 0x4002d897d3334a1b,
    0x3feeb65ec522d85d, 0x3fd933feda9bf31d,
    0xbff464b7ef25389e, 0xc0049cd89364dfee,
    0xbff76741785b8838, 0x3fe53278fb7a8563,
    0x3ff1675489940138, 0x3fc94df69b62adc0,
    0x3fb449e7dc53d458, 0x400e8b09e49fd89b,
    0x3feae7f2cb24d39d, 0x40079acce85984b9,
    0xbfff3d57c3bc623a, 0x4015d4fb17677b12,
    0x400898a007850720, 0xbff60ce4a63304f0,
    0x3fca959d60f06e34, 0xbfff4bd0d58db400,
    0xc005bbd8950da918, 0x3ff906a905312300,
    0xbff32e34ef2e2a27, 0x400051b65ca6bce6,
    0x3fc38adac9644490, 0xbff29f7d17b52113,
    0x3ffd429c8e81d2b4, 0x3ffd369d16b8dd96,
    0xc00119a6db0b987b, 0xbff99e0539a9fc04,
    0xbfe0aca4d8a16bde, 0x3fca9ec8f24cf688,
    0xc006f3c509a2bdec, 0xbfd3d360eba2a0a1,
    0xc00758b15fd94a24, 0x400176fa55cfe73e,
    0x3ff562fc2ead1299, 0x400139898086f3c3,
    0xc009d2ac85c7beea, 0x4008e8486d47d15b,
    0xbfd0caa6d1553fd0, 0xbff219a0e58a4ab0,
    0x3ffc798b080e904a, 0xc017b5af7f4add3a,
    0xc0074e15fc1070b7, 0x401b7b0a84169049,
    0xbffbaf1a18b82e6d, 0x3fdff6235a1c9cfc,
    0xc0039a2fef64c234, 0x3fe9043bf7584c47,
    0xc00e71e3ab1ac6f1, 0x4001f4377581ce3c,
    0x3ff710936ee41b0c, 0xc00b7dea643edb3e,
    0x4007d2f07d73c642, 0xbfc4a27fe8bef0b0,
    0xbfe1fa1ea69f0fd8, 0x4000685dc1913f74,
    0x3fffe9970df9bfed, 0x4015e17bfcbee669,
    0xbffe163614251f2f, 0x3fe5ae4a262c2e23,
    0xc001b7b377c6d93a, 0x400888d95736025f,
    0xc0023993c60fd50c, 0xbff0c52e01d1927e,
    0xc0043ad540cb7247, 0x4010234a1db10abc,
    0x3ffeaa29cdf081b6, 0xc00f4486fa56a8de,
    0x3fe2dd6b39f9c997, 0xbfe271cb29968b44,
    0xc00f5fb2f5d48b98, 0xbfe341d9d480ce69,
    0xbff46b2273b05c9a, 0x400d0ef40d5712f6,
    0xbfe01414a89a9358, 0x4002eb16781f0b6a,
    0xbfc98c60e1083904, 0x3fdc21a362805e2e,
    0x3fb60fcee2b74460, 0x3fee15fc32908ed8,
    0xbffca9bdc1949538, 0x40130444a0e411b0,
    0xbfe15b0776c90bee, 0x3fffc55346697a65,
    0xc0011c153e610280, 0xbfe8fc4737cce8dc,
    0x3fec46fbc7c6eebc, 0xc00f9739a51fcf98,
    0x3ff569391917bed1, 0xbfb7551b1aa95ca0,
    0x3fb0ad66baca8910, 0xbff34c5a3c17239f,
    0x3fe54d28ed25ede4, 0xc005b3ae7892062a,
    0xc011707ca2566f16, 0x3fda6b9773609820,
    0x40089d0334444432, 0xc001a0efe9a27bd7,
    0xbff342a20a4d799a, 0x4004a12d79c04088,
    0xbff34ca3372619eb, 0xbff0254389815218,
    0x40134a206c381510, 0xc0044e2e5df3597e,
    0xbfe7366c6d947db5, 0x4003d4ee617a1980,
    0xc010da54ee8c093b, 0xc015d4fe86cc583e,
    0x400eb20c90427f29, 0xbff57b14a1abe217,
    0x3fcde4882a539b6b, 0xc0057c7470cbd97e,
    0xbff09d6290e6f2da, 0xbff6615dd5248f7a,
    0x3ff57c9cb36dc934, 0x3fc442e80ca3f530,
    0x4000b32ef97af6ee, 0xbfb25f1038a4e768,
    0xbfcdc89b7a4f3cb8, 0x3ff8b0be8f24f365,
    0x3fef247f10d3fcc0, 0x3fd3bb8d209db42c,
    0x3fecac3b97363f02, 0x3ff8d67b8283db02,
    0x3f97ab573a2d18c0, 0xbfec5d32e5a6be00,
    0x3fe5d2b2f1bfa6f4, 0xbfd53a709faa0b9e,
    0x3fed990e9cb274c0, 0xbffa600dfc18c753,
    0xbfc510d37533d5e0, 0x4003684d7743b028,
    0x400ee37288fea35c, 0xbff1573c40aa8ad1,
    0xbff2d521c0e6bcc7, 0x3fe095dd52a80477,
    0x3fe1154226cd1ef6, 0x3fc63ee85d50d820,
    0xc00c4f27dd02ee35, 0x4005190e75a6b931,
    0xbfbd1f93907c2d50, 0x3fea293398d7c54c,
    0x3fe71e5389b562ac, 0xbff8e28b06290f32,
    0x400865cfcd9f1b60, 0xc00212e16f70eb9f,
    0xbff57ffa50a2644c, 0xbff2ca1dfe7d7fc1,
    0xbff50e0efafba13c, 0x3fff2c6f8d10873d,
    0x3ffed5cec9a041ef, 0x3fdfe59187d51e04,
    0x3ff1d7f9f4d073ee, 0xc00bf5a065c7da88,
    0xbffff76994602c49, 0x3ffce79f21d1c275,
    0x4017d1d3c9da926f, 0xbfd68562fc8a6c98,
    0xbfc8d651586d1650, 0xbfe0c258e4918534,
    0xc003d58ffb8a1d53, 0xbff08ab2ccb9d7fc,
    0xbff43c68d741e699, 0xbfe9ece15a072a75,
    0x3ff13622e83cd2ee, 0x4000d8acb828c446,
    0x3ff4674b595e74fe, 0xbff6330a65e82816,
    0xc00b45ed9535b8fa, 0x3f8513297e9536c0,
    0xbfa6716316c23380, 0x4009a57928524f00,
    0x3fa0c83f077dc380, 0xbfefe81d4bd171b3,
    0x3ff48df5f20e4395, 0xbffe7e7988b987a6,
    0x3fdbdaa3db77a5a4, 0xc00155408e75ff0c,
    0xc009df948c2274c1, 0xc003e192ef6d3e84,
    0xbff45b4ab46f2968, 0x3feaca7eed9712b3,
    0xbffd9428d27106b6, 0x3ff6d995228a2905,
    0x3fe231cdee7967ec, 0xc001cdee2953eeb6,
    0xbfbe24c7b4cd2c10, 0x401143970dc6155c,
    0x3ff155efa90a7bed, 0x3ffcb9eb52102dcb,
    0x400d229d295945b8, 0x400092dd570b3712,
    0xbff04b24605c7ba6, 0x3f68941b8e789c00,
    0xbff4c85643a39e64, 0x40165ff1ef852648,
    0x3ff8abb723b784ca, 0xc00b6bcfdfe28961,
    0x40035c1b6a2727d7, 0x4001381fd583d024,
    0xbfe31d221cb95190, 0xbfe74cb78cce5b5b,
    0xbfcc20d4efcc83f4, 0x3fff6c1a3ddce4e0,
    0xbff97ff4b9268f11, 0x3fa2cba1c9768b00,
    0x40075957b79a24d6, 0x400446d17f8a4ee8,
    0x3ffa4d02df810288, 0x40043cce6b000f29,
    0xc002536f9cb5e0de, 0xbff13925d0cd126a,
    0xc0064c461c4ade88, 0x4000be43b0968e47,
    0xc00a9b5e6a523c63, 0x400bd9eff45fc757,
    0x4008eae9b8d90e58, 0xbfd65ee0a22ef8bc,
    0x3fd342d1a3b85698, 0xbfff12182425dc00,
    0xc00dbc5bdd6456b8, 0x4001f27a8b39b6a5,
    0xbfe9186b45e8f3da, 0xc004521f33a27d12,
    0xbf9f655f1f162610, 0x3fdc282df2c9cb46,
    0x3faf297a5d9aae30, 0xc005466054e3332c,
    0x4000914f865da3f7, 0xc0118920eb7f416e,
    0x3ff8315f8c838e50, 0x4009900e232011bc,
    0x3ffa29fab7c953f6, 0x40060014b45f1bd6,
    0x3fed00903aef4bd5, 0x3fe6f77dc0efddb2,
    0x3ff582a7d9904ef0, 0x3fd97eaae0dfe148,
    0xc00ad62dc706c3a8, 0xbfd425f4e9a51e22,
    0xbff42029dd34ef23, 0x3fdf2262b7e342ac,
    0xc0078e43a65d70ee, 0x3fff38a25b01b86a,
    0xc0014dbd72faa609, 0x3ffa6d5dd1cb503a,
    0xbfff5909432fbc5d, 0x3fa50bc485c20ac0,
    0x3fe08586f78cd690, 0x40008cc2daf75919,
    0xbfd170821accdf8e, 0xc00c0e45dd45aa04,
    0xc005416af26099fc, 0x3ff938d6c8bf60b6,
    0xc01312cd5fb42d1a, 0xbfc656614f41fef8,
    0x3fa90fc7514eb530, 0xbff6e62dbf0c6575,
    0x3fd17b981a1389fa, 0x3fef2229a5f9f977,
    0x40013e58b3ea190a, 0x4010cbaac646a558,
    0x3ff6d2535dc3167b, 0x3ff9a4d6e6186377,
    0x3fe246b844588a64, 0x3ff3d8d420f6014f,
    0x3fe5c7293815dd20, 0x3fb5cea3210e7594,
    0x3fca0b59bdc1f510, 0xc00e16016cab8bec,
    0x3fddab266bc783e4, 0x3fea0aa8eb68371e,
    0x3ff3293bf5c19acc, 0x4009aae2a5d8d0c2,
    0xc00544aaff5bb36b, 0xbff5cebde63e2166,
    0xbfdd08b14c046e06, 0xc000c0ed043fda46,
    0xc004da65d3cd012c, 0x3ffa20a00bd9db98,
    0x3fe4c929b2eb9788, 0x3ffe38a037126a64,
    0x3ffabee05eb778dc, 0x3ffbb07717abc281,
    0x3fe19f115878b36c, 0xbfe0cbc3e4e767e5,
    0x40037814ba734e6c, 0x3f5893cede09ea00,
    0xbfd6c1227868081c, 0x3fe10ab582f6a86f,
    0x3fd75afe261531da, 0xbffac2b9bdb6e850,
    0x3fea8ae38da8b637, 0x3fc718b86d2b6a90,
    0xc000b8cc4eb47fac, 0x3fe02cbc8de8fdd5,
    0x3fb963dc507e7c80, 0x3ff50eed791014e0,
    0xc0033f727d14b9c0, 0x3ffdf4096c7dc9b7,
    0xbf856ad75baa9580, 0xbfe2fee6d2306982,
    0xc002ee0d305ae73b, 0x3fff41491d5324ba,
    0xc006e7d0fe40bcf3, 0xbff3e45d04e0c9f0,
    0xbfce397a1d7a70c0, 0xc00f89d780cf8566,
    0x3ffbde638a8f5bf8, 0xc0053536ed13a03e,
    0x40086c69cb14220c, 0xbff27815d25eead2,
    0x4014bd40ca6634fa, 0x3fd787f6cfbc6f6c,
    0x400382861797880e, 0x3ffe5b28af20ef85,
    0x401174130a2e1de2, 0x40013886729a856d,
    0x3ff0edaec9868248, 0x3ff9d370f36cc2ba,
    0xc007837237b32ec0, 0xbffe2002c5ae3392,
    0x40007425bff897a9, 0x4002f50756c04e0d,
    0xbfd4fd21f182da52, 0x3fd5020125a91a09,
    0xc00a8f81204da6ed, 0x3ff208ffd2cd1840,
    0x3ff25e2994f87084, 0xc013e9fd65d749c7,
    0xbff5a91534307d1e, 0xbfda2e1d8e4a33d8,
    0x3fda205108265170, 0x3ff2cd7010816bff,
    0x400a3e90f776265f, 0x3ff96eba3e881bed,
    0xbffeeef5d0d7dbf8, 0xc005a2edefa883c1,
    0x4006072dd3d9f63a, 0xbfe1c2460698e3b1,
    0x400987d6b33ec3ce, 0x3fe7cc75dd5a5ede,
    0x3fe632d4fc7b3b08, 0xbff3edd26227f674,
    0x40115c4058d0a323, 0x3fed52e1fbb837f2,
    0x400f63ac68726f0c, 0x3fefd9996bd00fae,
    0x400a5665149c3966, 0xc007851c3d1fe800,
    0x3fd5b17fbd2f8c5c, 0xc00ed0ebe9a8ef53,
    0x3ffaa8aaa94adcbc, 0x400db96b387fa902,
    0xbfe43d612952f19c, 0x3ff5d80e7a93b2cc,
    0xbfdb4d8cced35de0, 0x40104b78a050e872,
    0xbff2d375fec62d50, 0xc0001add489cccc4,
    0x3fee82b92a063f8c, 0x3fdd832c97b91caa,
    0x3fb083ecff18f580, 0x3ff9c4ab9f0b24d2,
    0xc01932bfae2afdb5, 0xbfd661a770529588,
    0xc00ee154a1a426e4, 0x3ff9fac2c1af3874,
    0x3ff61714630353fa, 0x3ff49774e2810cac,
    0x400e2661b4ee0ef6, 0x400d7a05c44c198d,
    0x3ffefd038fb80c9e, 0x4003c86d9ae79a13,
    0x3fd13513fd36bece, 0xbfe91f50fbd67c4a,
    0x3fe81560acbb8dd6, 0x3ff88265534a9966,
    0x3fb145ac2d7a4e2c, 0x3fe619b06d4105c9,
    0x3fdafda654104736, 0xc009810b27f2beb7,
    0xbff8fb97f14a95db, 0x3ffa43301fa7ece1,
    0x3fff637e0f5f0d1a, 0xbff3c87d638250c4,
    0xc00460210516627e, 0x400433f7f8497961,
    0xbfe5fa152ffd0ce2, 0x400edc4b4423e58a,
    0x3ff1210290983662, 0xbfd7b49413c6f5a8,
    0xbff8b9953841a651, 0x3fe6722805c4a95a,
    0xbfc018e36fdad8b0, 0xbffbaecce77a2846,
    0xc010804a05b8322a, 0xbfccbf74b51894d8,
    0x3fd3806540b6f440, 0xc007af8403ebebd0,
    0xc00fcea59ee8477e, 0x400c93e75315157a,
    0xbff430f0ccc1b643, 0xc00ca68d5afcaf67,
    0x3fffecdf1891c9bf, 0x3fbd45beecac7698,
    0x40089ffaf0d82914, 0x3ff671d6b7dbc454,
    0xbfe0c30c7e2e90c2, 0x3fdc4d968b068550,
    0x4003f6c32f3f4815, 0xc0074276711e5ca0,
    0xbfdeab590407defa, 0xbff8af4b853a05d9,
    0xc0146917bed300a2, 0xc00dbbd176e9b422,
    0x3ff1f9babd06bf21, 0x3fdbec1c338d1e98,
    0xbfc7953077b01bb0, 0x40007a9a6bf77c2a,
    0xc006e97e7627bb42, 0xbffe3d510570ec27,
    0x3ff4dddb45053f63, 0xbfc98b6915cddf88,
    0xbfd096c4106b0e32, 0xbfe73620c85e73d8,
    0xbff083eba55bdfc7, 0x400badf35fccfd0c,
    0xbfb04ae53a485dc8, 0xbfd617ec1810995a,
    0x3fe53a8d8b54571e, 0xbfda281be61e6d3b,
    0x3ff3e2ac063a147e, 0xbff06ce0c929d07a,
    0x40019fbe5a27d97a, 0x3ff21806386e160a,
    0x3fd6ae4574fd37fc, 0xc001f8f933b6f42f,
    0x3fee967c7b736290, 0xbff25d86bd513d8f,
    0xc0045dbbf1118b16, 0x3fed3801f7c2fccd,
    0x3ff161c4429f0b7d, 0xbff771e24cf01821,
    0x3ffb572488ec83e2, 0xbfcae67480d2e8a0,
    0xbff3f615b41eee3a, 0xc00175b59029193a,
    0xbff672a9979abc06, 0x3ff8c2c1e4920a6c,
    0x4012970709eaf495, 0xbfcec7668947bd68,
    0x4006c6d541ea241e, 0x40019ef3ee33a74c,
    0xc00948fe4ac992f0, 0x3fee150ffd53fcac,
    0x4001aac6d88f5422, 0xc007d186e42e8e19,
    0x400163c392fc2106, 0x400a5f7234e25064,
    0x3ffe067df256cd32, 0xbfd56d3807e83894,
    0xc0132100c2fc1474, 0xbffebc43439a4b86,
    0xc008c0a500d5d956, 0xbfde7256bc35bc38,
    0xbfd7334389913261, 0xc0023fd1402c8475,
    0xbff768bd50902f22, 0xbff19d2adb1e73bf,
    0x3ff75cb43afed7bc, 0xbfeb0e2b9b2b1628,
    0x3ff0193a2a1f8b1e, 0xc0165f4b53e5dade,
    0x3ff5aeff64aeabbe, 0x40166cbef49a8288,
    0xc0068d8592e06dc2, 0x4001298279c76876,
    0xbfff314570f6e35f, 0x401c43f667cb5032,
    0xbff26eb1b435ae24, 0x3fef6e7bbeef97ab,
    0xc004a21e9c6228e3, 0xc002c061c8463c99,
    0x3ff040048edb5b91, 0xbfefa80b38f76cc4,
    0xc003a3c08eaca311, 0x3fec10febc7b8d74,
    0xbff79413bd969c1b, 0xc0118ce764e98de1,
    0x3ff06d5854182de6, 0x400467c6bbe21983,
    0x3fbca838cbbbacd0, 0xc00d437e15f5fed2,
    0x3fedf771399ae08e, 0x3fecd890c79f3ee6,
    0x400eae9903517f20, 0xc0077de9b802e612,
    0xbfe59fcdeb84e92e, 0x3fc65ac63dd9d180,
    0xbffcf49f3acb8ed6, 0x3ff4aedc898f0a75,
    0x3ffcae02e0a319c5, 0xbfeb319bd368c197,
    0xbffb65945b7d0312, 0xc00f5218ef536081,
    0xc00585ae0fda358a, 0x3ff196284dc0db6e,
    0xbfebf110d405b676, 0x3fb874eb51d93a78,
    0xc00461582c324158, 0x3ff55c529976534a,
    0xc005afd77186fb64, 0x4006569ef49e7db8,
    0xc01cc983103bef82, 0xc0168b87e27645e4,
    0x3ffcb3709c7442f9, 0xbfe1027889a4020a,
    0xbfe7a1de064b8762, 0x400c9a00a486b9d1,
    0xbfd960fb093f9a52, 0x400579a8936af0c0,
    0xbfbc307a1c5c3280, 0xbff233628887f630,
    0x4004fa4b8b8603e0, 0xbff5edc9af040e48,
    0xbff510985b91afbe, 0xc00d457b73ec156b,
    0x3ffa0fc5111db999, 0x4000cf717ee37f5a,
    0x3ff5c8def951af16, 0x400443cfb41c5d4c,
    0xbfe2a7ece143ff45, 0xbfeebcbf1ba848cc,
    0x401512718f65c33e, 0xc003b142cd53da4c,
    0x3fea5264739d20ba, 0xbfe2483b01cedae7,
    0x4001837c3635044c, 0xc009268290ff8f59,
    0xc004ca7ae5e1a741, 0x3fcc8cd169be09b0,
    0xbfcc5d44b630612c, 0x3ff1b886a9994dd3,
    0x40045a21edd91475, 0xbff6114ef81a26f1,
    0x3fe4bb764baf9130, 0xbfc9f07caaca8bd0,
    0x3ff538d4c7c7cec6, 0xbff100ee79ec1536,
    0xbffa43d237aba7d9, 0x3ff7104c2095e5be,
    0xbfae923612b4b590, 0xbff9c6951ff16005,
    0xbfddbf8fda2e7eac, 0xbff50cc80f81a665,
    0x40118f59528c76fa, 0x3fe56114f5027134,
    0xbfe2a6ee626bc0e2, 0xbff4fb2300401556,
    0x4006f2769779ba1c, 0xbfef90333dcaa030,
    0x3fe424baf72ba55c, 0xbfce7bae9c682180,
    0xbffb066a9371c22e, 0xbff5aaad6bf45e33,
    0xbfe5fd7e4e9bac38, 0xbfe0a421afe8f70c,
    0xbff3cc3b9dbd026a, 0xbff2412e4903a50c,
    0x3fe1de3a61f62cfc, 0xc00dddf3c644cc07,
    0x3ff787b3659ee5f1, 0x3fe60ea0010adffd,
    0xbfee7aa68385a9ff, 0xc007e012500c9410,
    0xbffed74d9efdbaa2, 0xbfff8ffdadf187d4,
    0x3fef5647ed6da750, 0xbff77aee1cc0eda8,
    0x3ff216755b966800, 0x40019a9932435ef0,
    0xc01e0869e000ace2, 0xc0036538bf8f7259,
    0x3ff4cc0ccf104322, 0xbff11f4ccb29c6cd,
    0xc00b678d88a0b55d, 0x4004db708accaed4,
    0xc000b676501e6301, 0x3ff5cf09bc5899cd,
    0xc0099c610cf85cb7, 0x40112e1f53912813,
    0x400cb42b52eb98da, 0x3fcdf0feba3225cc,
    0xbff27562e3422df5, 0xbfea4243310610f8,
    0xbfff077bdf40ec9f, 0xc00846065bc22819,
    0xbfe02558c9d6d65c, 0xbff04bafa49bbddd,
    0xc00816f72bf3cc44, 0x4000a40692ca09bd,
    0xc00b569b53235505, 0xc00ab2958d3717c4,
    0xc013d86639f5d05d, 0xc00f49f78e37a23a,
    0xbfe2d39ac8d9d81b, 0x3ffe58793b62e59c,
    0xbfa805c31bfb3a60, 0xc000c06786ed0bc0,
    0x3fe7126ce18bf2f4, 0x4002b621114be156,
    0x4002a7ba133df790, 0xbfe8464943a38770,
    0x4015304ce2378334, 0xc008fcc2a3ca008a,
    0xbfd500ced242f368, 0xbfd8f15678719d8e,
    0xbfff2525854a84a9, 0x3ffc0cbfeb72382a,
    0xbfc30fac231e81e0, 0x40013392ffd3a752,
    0x400351a03f409252, 0xc00aee6729daa78a,
    0x4003d53f51f04bea, 0xc00f01110f270cb1,
    0x3ff2f5b15cc53d10, 0xbfb04e7a70b2aa00,
    0x4005efe18d21816f, 0x400625e3ab091010,
    0x3ffc802d75a4a2e3, 0x40131f547679732a,
    0xbfd745baac75db04, 0xc00faaeab7342ff4,
    0xbfd444a58350c628, 0xc01410f6a460f750,
    0x3febfa5a2db11d24, 0x3ff5a917d9f69098,
    0x4000a410987099ad, 0xc01e15a0a5eb8024,
    0x40060450a350950c, 0xbfda759feea4ac64,
    0xc00aec64c1f04fba, 0x3ffd1db85af74fc3,
    0xbff265f5cec8b316, 0xbfff1e74141b45fa,
    0xbff05c98c207de14, 0x3ff6ccf51a5416b6,
    0xc004f5fc71d49038, 0xc01305bcba58ae96,
    0x3fee543059b8e7de, 0x4003babe8d4026d2,
    0x3fd4c18221cf259c, 0x3fb184d0c821e358,
    0xc0139d2bd1d00bf0, 0x400078d228b9a0fe,
    0x400f1a732fd96708, 0x3fc0948f8908f650,
    0xbfe564270f4575bb, 0xbfd92e54a9eb2c38,
    0x3ff0a45992346476, 0x3fd0602474e0aae8,
    0xc00cca00ec70cf09, 0xc00570bc5b5e1ff4,
    0xbff986bfd16be2ac, 0xbff9842ee0869abd,
    0x400787b200071c24, 0x3ff3b1b1653f464e,
    0xbff39d96cb473942, 0xbfb5f6e2c39128f0,
    0x3fb20bcc6346a020, 0x3fce6f3ed18afaa8,
    0xc003b554018fc652, 0xc010f5902c34ed1b,
    0x3fda50f337e6df14, 0xc018bbac0b652bfe,
    0x4012da56652b1350, 0xbfc9301004fb9a70,
    0x401838f5395db66c, 0x3fcd791d54e40e40,
    0xc0116885c305654e, 0xbffdbecea85b07fd,
    0x401531cb819f042e, 0x40092585225d6b16,
    0xbfe4748210e3ed68, 0xbfe3c3a8260a6f13,
    0xbfa8f22d26cc89f0, 0xbfe76e454bc3e7e6,
    0xbfb56aa70c9cb6b0, 0x3fcbff6bb9050f00,
    0xbfd9b05d0731704c, 0xc00ece112f035cb9,
    0x400713e860e403b0, 0x4010e7d6fd4fcf1f,
    0x3fee0a0b1d55160f, 0xbffd86272c649f7a,
    0x400382b2f78fb890, 0x3fe3091f1975198e,
    0x3fe1ee78b1002005, 0x3ffdab260a0093d5,
    0x4016b848363f8596, 0xbfd398041fb2b804,
    0xc007a88cddead8f6, 0xc003bfdb0e32966b,
    0x3ff149101ab58232, 0xc00b05da19002d0d,
    0x3fd329e99c1c310f, 0x3ff21b7bd784e8ef,
    0x40004fd6014307b4, 0x3ff1e0e94d91e12e,
    0x400ce896356c6e28, 0xbfe79db60206891d,
    0xc0059386ee3e5178, 0x4001972d598050a2,
    0x4013ba52f2759e8e, 0xbfef0e74b61b5d09,
    0xbff7172eb4c1b863, 0xbfd184e8f10e0a0a,
    0x400223bc4eced592, 0x3fe7abdd8bab8418,
    0x3fbb72ae50176920, 0xbfa5a4668b08ce40,
    0x400ec7d9f4a58af0, 0x3ff40bac22fc8bf4,
    0x4002163c1d0ba58a, 0x4002932df46a1fe6,
    0x3ff7aa4c2dacdcc1, 0x3fd94ed03c7674c0,
    0x3fd48ca43836cdd4, 0x4010569cd8519a50,
    0xc007daea678c94d5, 0xc017e2ec0b579ef4,
    0xbfd53edc8a4f964e, 0xbfb543949c284a28,
    0x4007520f20063037, 0xc00875738e1f4a5c,
    0x3feebcafcfac4c1e, 0xc00c1e5827fcfc7d,
    0x40120eb2b60b84a4, 0x3fe80b62efd8485d,
    0xbff756a5c9f56716, 0xbff67715be989c9a,
    0x401114e2729f5bcb, 0x4009edc52e62e88a,
    0x400220d1a7597092, 0xc011eab947799dc0,
    0x400f7f6b404d2e0a, 0xbff3e3f4b43bc5a6,
    0xc005b1eb592e1168, 0x3fdf4ad0f5b304fe,
    0xbffae439faa4f37a, 0xbff77cb39389f190,
    0x3fc583a312b170cc, 0x3ff729fdc6551fa1,
    0xc0048ca6c03d9646, 0xc016d788452946db,
    0xc003802135422f5a, 0xbff1c4414098ebfe,
    0x3fff4c3a7853b904, 0x3feebdd73fa3e823,
    0xc00173c4d2b78842, 0xbfe436a5ab95ca7a,
    0xc00422748020565c, 0xbffc1838a8e58b38,
    0x400303af85ac93ae, 0x3ff63e7557c84a24,
    0x400863c522b50147, 0x4006a89753df3574,
    0xc003fbe8eb5bf5f0, 0xbfd1fbd2532e25d0,
    0xc00eb310f6e863ec, 0xc0044f1ba8212c71,
    0x3ff3120df4787b38, 0x3ff3127edd538bc9,
    0x4000a14fe8853fcb, 0xbff3ad1cfeb98c50,
    0xc00d7e5aa3bedf9c, 0x3fee11a637a7ac08,
    0xc00996b0110daf9d, 0x40018731c34539f2,
    0xbfea8228afc0b5c4, 0xc00187e6a2e8dfae,
    0x4004ec28b5ee2fbe, 0x3ffd34531b004328,
    0x3fccb82d0115ac80, 0x3fe9e2758aca3f0f,
    0xbffe64d75ed937d6, 0xbffa28642743d317,
    0x3fc762b984bf7fd8, 0x3fe185f2bf5ce1c1,
    0xc003dc498b4236bc, 0x3fed0f5f6dc2eb94,
    0xbffa86fadf12eae0, 0x401033b0902e2ea6,
    0xc000940b3ce262e8, 0xbfef8e0581a87aec,
    0x3fe6442302706fe8, 0x3fd73bb4b02b2b58,
    0x400536bb4ef8d328, 0xbffd35bf733ee597,
    0xbff0f7442566040c, 0x3fe99dabb46a9f72,
    0xc0020f86fb73ca31, 0x3fe2331dab1ab141,
    0x3fee2fb7884d88be, 0xbff6c09b61468565,
    0x3ff245959d6eb9a0, 0x4001019598c15288,
    0xbffb18c878e34ce8, 0xbfd93d3082f97076,
    0xbffc09c8a9509319, 0xbff48980e18786aa,
    0x4004a26ef1ecc99e, 0xbfe6db287c73e4da,
    0x3ff493be9fae43af, 0x3fe59cdb71a3a38e,
    0x40008c5cb7ee9892, 0x4004215e91b4351d,
    0x3fdd2aa433b3110c, 0xbfeed3813acdd240,
    0x4010ab0b641a2dac, 0x401082d1d7136abb,
    0xc0079faf6b004890, 0x3ffa91da96c45f1e,
    0xbfd677c74515b300, 0xbff6246c1e19771d,
    0xc002cb094baccc26, 0x3ff6fd408326549b,
    0xc004fb8dff907b03, 0x3fe0436e8ca190b4,
    0x400a3e5e2f08ed0e, 0xbffb26a9b1206c94,
    0x400354f90c57b27a, 0xbfe3db3f1b5dd68a,
    0xbff9ab71aa7d5226, 0xc0112fd495366a82,
    0xbfff21f27d4286d6, 0xbff0e6b1944b97d9,
    0xbfb30c5ea6ecfae0, 0xbfff0ae7344def0a,
    0xc007d39597144be6, 0x40047f8aed5d8d34,
    0x3ff3ce0c8c5603af, 0xc003824c5a0df245,
    0x3fd432b88e428f16, 0x3fb8cfa376b60720,
    0xbfeaf2e6e18c647f, 0xbff62e4cf62c5e3e,
    0x3ff82c5cf1ea2eca, 0xbff7742baf0389a4,
    0xbf970620ebe334a0, 0x3ffccc15a301499c,
    0xbff667c113066ca5, 0xc0052da18cbbc66c,
    0xc01919eab419af00, 0xc09661fb2a20188e,
    0xbfb7b3da970dd900, 0x40053a28139331e8,
    0xbff82c5c80063058, 0x4010d98778d5a7f5,
    0x4019ba2497b495d6, 0x3fde08d7b8f7c710,
    0x401490ab34dce536, 0x3fcf83a37414f858,
    0xbffb3aead398314e, 0x400d10274783c08e,
    0x3fcf578594d94b30, 0xbff65e9d3bca9bbc,
    0x3ff8a424cabb2b0a, 0xc001474b4a174435,
    0x3fd0116fa94e6554, 0xbfd7e41921cd13d4,
    0x3fb1609cc3621c40, 0xc002ebe086c20e82,
    0xc00d1e70a94247d3, 0xbfe0237564a10bbd,
    0xc00a951e599655aa, 0xbfe5bd69f9af8666,
    0xbfd6275bf0fddef2, 0x3ff30f79fbdcf4c1,
    0xc0105c9e3012824e, 0x3fe1401da0e6065f,
    0xc010caa47d741ab3, 0x40156ece9d480f12,
    0x3fe39a7a5e10f21e, 0xc00ecaea6c795df0,
    0x40009d6d1e11b09e, 0xbfe34baa62461281,
    0xbfbe48b3a52d5fac, 0x3fefbba3fd1361c2,
    0xc00859f443c1c598, 0xbfa9761e152e4120,
    0xbfd81e60032befe2, 0xc006630a4660c58e,
    0xbfe08370d1977840, 0xc003958a28460bb1,
    0xbfd81ad424841d98, 0x3fd488f5d214f0e0,
    0x3fd086d2dacdf67e, 0x3ff8bcd59f0e44c5,
    0xbff6024fa203b874, 0xbfeae14d9e4bddd4,
    0xbfedcbb16b5913fc, 0xc010903859f42b2c,
    0xbfccb93a9fe5180e, 0x40047ef3d3b92001,
    0xc0047e30072bad8d, 0x3fe0df4b86f92eb8,
    0xbfe1e809b11a6d4e, 0xbfcb20c12c6811d4,
    0x3ffb2f929ac4fb07, 0xbff255a7bd691904,
    0x4015a77c2f4de324, 0xbff1a480f359c413,
    0xbfbdc13c66a28000, 0xbfe27e9866d049eb,
    0x3fee57bcf42efd68, 0xbfe35b39c6833db2,
    0xc0058198b429af75, 0x3ff01bc5b5fe1362,
    0xbfb1ad5c032fa6e8, 0xc01a65bb4bc37df4,
    0x3ffce58e739df18a, 0x3ff2db4a74840f6b,
    0x3fdbbaa2be458734, 0x3fb49c3a0a852970,
    0xbff8be7a0fb06690, 0x401a33cbb284aa54,
    0x3ff9377be59688c0, 0xc0034eabd15c7517,
    0xc00542a0d64b4782, 0x3ffceab106dc55ec,
    0xbfe82379553e5a0c, 0x3feb1532cee7a291,
    0x400cd9cf4a1af2ad, 0x3fffd43aede8f657,
    0xbfe597d376ab287a, 0x3fc7c6b87f4ae748,
    0xc002dea269d9546c, 0xbfe9f329105eaebf,
    0xc0064e0a31e58aba, 0x401139baecb9760a,
    0x3fe464b0b4abf044, 0x3ff52afafe8a3010,
    0xbfdaf48f04f9b0d8, 0x400087d2a23ec694,
    0xc0117dfb68c7ad5c, 0xbff40b0c968a12b6,
    0x3fe6ff0618bd5b2e, 0x3fdb886301e9c6bc,
    0xbfce803889e6bd68, 0x400023e4a5a68246,
    0xbfe202b31792c968, 0xc015c45a1234bfc8,
    0xbff7917477aa6428, 0xbfde8864be906076,
    0xbff0860213141d3e, 0x40033ab3f37f2696,
    0xbff1dec04d653a35, 0x3ff4fa7e0464d7f9,
    0x3fffdb802a878e7a, 0xbfe47e9f456718c2,
    0xbfd28bad68b3eb38, 0xc00169b18a5f1f6b,
    0xc0064c20b4eb2915, 0x3ff310a69a4b9924,
    0xc00eacca18b1f942, 0xc01cb3f76653546c,
    0x400ad23d0da8e9a1, 0xbfd2c0f24de2998c,
    0x3ff89ffa4c606ddc, 0xc013d16b6713d48c,
    0xbfd939c35ece0f1b, 0xbfd009e6eae38a7c,
    0x3ffb78fd4fd05d1e, 0x3ff9a5b1fcb87af8,
    0xc00676d9d4808bb0, 0x3fd429bf434c12f4,
    0xc003c19b256268ef, 0xc002a68d84faa5ed,
    0xbff2e17d051a1f64, 0xbffe62cb769316b9,
    0x400b851b8e03a9a9, 0xbfc346f5e7517ba0,
    0xbfb497e5d56a4c44, 0xbffab09d92be774c,
    0xbfa072afc3310760, 0xbfe82091616dac53,
    0xbff7808e0b27128e, 0xbff74924e2850aaa,
    0xbfab0ad357fe2a18, 0x401109b336d3cea9,
    0xc00102fbb3dc7ef1, 0xbff956897c2eb7d8,
    0xc0055a966aa8994f, 0xc00c6ee47ac4be1a,
    0x4002d3fb410b5310, 0xbff38d250906350e,
    0x3ff7b7f05fbe55f8, 0xbff196c9c60c0ac2,
    0x3ff0db4947efb29d, 0xbfe6761cd52536a2,
    0xbfd77e5414c6ec98, 0x40026f31f0e6b73a,
    0x400d2409afeee852, 0xc00a1fd2d4f45085,
    0xc005d134fd85d4d0, 0x3fe262c11105bd21,
    0xc005d93b595e0027, 0xc0011236c61cb786,
    0x400e0f87663b7e21, 0x4008cf46d487bbec,
    0xc00c4dde13192e1e, 0x3ff6767b9af4792e,
    0x40034659308c3b38, 0x3ffd1ec3d07f32e8,
    0xc002cc41cfd288f8, 0x3ffdedc47c776011,
    0xbff5120b3771982f, 0x40016d7966af0ae0,
    0x3ffda61c26da16e0, 0xbff7a186901cfdc1,
    0x40139d9db6fdac2c, 0x3fbb8b29700adf90,
    0xc00e44a8d51efb40, 0xc0055ea42df96198,
    0xbff827c2531ad154, 0x3ff4a78f0ac8e494,
    0x3ff4b9f2b0dd8a62, 0x4007054b9bda16ac,
    0x3fc3b04ab3783518, 0xbff52a7f41e5f030,
    0x3ff1c6a5aa96a4fc, 0x3fe973270d2e9c3a,
    0x3fd0fd182bee47ee, 0x3fe3e5cdb5045f32,
    0xc00862979db84e4d, 0x3f98bf393e98c200,
    0x3ff8c2de9ee370bb, 0x3ff8271673eb44c6,
    0x4004c839c9b59c9e, 0x3fe2677715c07438,
    0x401049facb9376fd, 0x400472696ef65a7d,
    0x40051058768fe01d, 0xbfa0949a665c5180,
    0x3fecd42f7d72d704, 0x3fff1d50657b3db2,
    0xbff5931979854946, 0xbff82d32c1d9a8cc,
    0xbff762ca65a370c9, 0xc009906b61aa341d,
    0x3fcd5520740794b0, 0xc000c722821ff2f8,
    0x4001cd1577374718, 0xc00349a9a4593261,
    0x3ff6035956b1048a, 0x401c0feaf4116c78,
    0x3fcb0a024d0070b0, 0xc01119e8fbdb51b0,
    0xbfe7a0de9a1d8d9e, 0x40081cfaa76d42b3,
    0x3fd62873dcf92064, 0xbfd4d6be6cd91b78,
    0x3fb1de3a0ec7c538, 0xc0019a58e285c3c6,
    0x3fe442a633217079, 0x3ff1b1cd8eebe636,
    0x400ae2e006e0ed56, 0xbfd4db7bcf74da54,
    0xbfe5e3c216dd74c0, 0x3ffe33ab06c3ff0c,
    0xbfeb159791d5b965, 0xbfe2e2ccbf12aa7d,
    0x4000ec7d34d33ecf, 0x40008b0945c1b944,
    0x400203e9b78bc464, 0xbffcb56fe3a2c08e,
    0x3ffdae5f809541d5, 0xc00a2c80a270b938,
    0x3ffbc302f40718d8, 0x3fcbc7fda98b0540,
    0xc0026dc4175ecb26, 0xbfc38aa9b08757ad,
    0xbfe2506c6dd1c8ea, 0x3fe8e6ff003d8429,
    0x3fde3e87aff26c56, 0x3ff89399cd17614e,
    0x3ff23ab1716c00e2, 0x3ff796e7c92ca788,
    0x3ffba046dbbd5dfa, 0x3fdded7512b5748a,
    0xbff67ead6423be1c, 0x3fd6426624816898,
    0x400629f709693a12, 0xbff090966fd5eb91,
    0x400c2c8debe3e849, 0xbff20bce91e84d73,
    0x3fe0dd6139234148, 0xbfd0084eccf2f894,
    0x3fc35f6f869d79b0, 0x40085187d1c455d7,
    0x40136b17faa6bde8, 0xc0021c5152c0e688,
    0xc003983c809fc8e1, 0x3ff044974ab72da6,
    0x4001d122743f6692, 0x3fe9fa395c0309a1,
    0x3ff6492eb5306838, 0xbfc8c5faa8a85a40,
    0x4011d0d17a60d1dd, 0x400733af9e92051f,
    0x3ff3f775b6c55b80, 0xc00ba640aaa54f77,
    0xc004b30aa456d6a8, 0x4008ddbaf7325f4d,
    0x3fcf4c74fd86f270, 0xbfb9f960496e2940,
    0x4000fd6b353199b2, 0xbfb175557d5b6ba0,
    0x3ff425f7229d228c, 0x3fde659463802f50,
    0x4009aa5763466636, 0x3fefd99bc70170ea,
    0xbffc9c37b5485f08, 0xc005a107949e13e8,
    0x3fe3df4066f7a182, 0x3ff999e51e2ad40d,
    0xc001b4e31d0d7bf2, 0xbfe2b19db127bf14,
    0x3fe8a124903b90ee, 0x401106fef3776c68,
    0xbfe57a034c9a89a7, 0x3fe01f7b8461713c,
    0xbff06780104a54e0, 0x4007d167b60dfc4a,
    0xc000003e90a48554, 0xbfe8064042af8678,
    0x3fc851e4c324b8fe, 0x40082894841b6895,
    0xc00b558d43462d86, 0xc0100665b20ccba2,
    0xc012078810f0c20d, 0xbfee77a1aae63f63,
    0x4001ec4959cdacaa, 0xbff734c14c07d421,
    0x3fe05cd9a6bfa96c, 0xbfefeb8270cf5a52,
    0xbff163a6d9840080, 0x400167cd34058338,
    0x3ff222c585d0ff12, 0xbffc4c7f0aba403c,
    0x4006816af5793e84, 0x3ff12b11af621057,
    0x3fe8ed0d2b33272c, 0x400d9c8ea07c7099,
    0xbfa2ef928de430d0, 0xc00ac12608231380,
    0x3ffc090fdc2af9b4, 0x3ff7880703df86c4,
    0xbfe01defba4f733a, 0x3ff05d3026f424f4,
    0x40048649fbc7384a, 0xbff1674f4f1b3778,
    0xbffd29d1934c282c, 0x3ffb7bca61b26e48,
    0x3fceb132bd9a0161, 0xbfe494ac7c1faadf,
    0xc001ff86435e32de, 0xbff38c9c835dbbde,
    0x400e5333e19b73d8, 0xc00028a91e073dc9,
    0xbff61eb000207dac, 0xbffd88c416ca5c85,
    0x3fcd53bb45796170, 0xbff819a53b18f41e,
    0xbff8f3d896b20309, 0xc00bd4dbeb24ae0e,
    0xbfdd2a8d07cc9286, 0x3ff31bd663bc4023,
    0x3ff2a6d52e5de224, 0xbfc17c50d593a1bc,
    0x3ff8e1082bd4eecf, 0x4007488e336b376e,
    0x3ff2e7edd59c407a, 0xbffff0db58eed508,
    0xc0106fd42fcc827b, 0xc0024e5b577d7cda,
    0xc0035ced523a3704, 0xbff2ab07901370ce,
    0x400389d1a6c0c9e8, 0x4004997ef046dc1e,
    0xbff06baea649da1e, 0x3fe9ac27ae194322,
    0xbfe12943e71dca38, 0x400be39f077b3b39,
    0xc003b0c63797eaf5, 0x3fe66d85213eea1c,
    0x3ffb6b4b7b5f8664, 0xbfb5f6a357fe1da8,
    0xbfc3528018a72a84, 0xbff116e601cdd060,
    0x3fe00521c881c444, 0xbfe3408dd4af7756,
    0xbfc6b4fc8ed199a0, 0x400032ec4d0679c0,
    0xbfc1786e3ff72020, 0xc0129b88afd4dc34,
    0x400cae825b38cbd2, 0x40008ef9166f3be0,
    0xbfec2978ded05403, 0x3ff5f6f82863f7a2,
    0x3fe05cc6f4601178, 0x3fb51f3bd06515d0,
    0xc0046e868990efe9, 0xbfdceb333ea1d28c,
    0xc0076cf12f1e68ce, 0xbfe2c34b8519a210,
    0xbffcb50e7e8f8bfb, 0x3fcbf5fdc706c1cc,
    0x3fc45f2d18114ec8, 0x3fe8c8ad1ce0dc42,
    0x40006ef39be31b13, 0xbffad51c51265128,
    0x3fe71c7cc31b5878, 0xc0001905ddc14446,
    0xbffe5052573daeab, 0xc013f2c60f844754,
    0xbff81e47c076c8ba, 0x3ff2dcd7287dbf94,
    0xc000956b2655409b, 0xc00c71ee9672f8ec,
    0xbfd7908c5103e1c2, 0xbfc051f0506282b8,
    0xbff53daad39f0dcd, 0xbfd5fd87d687d650,
    0x40029ede5f9fd71e, 0x3ffcb6dcd43567d7,
    0xc00c6d86e8e5476c, 0xbfe2ae3b54977780,
    0xc0037db65d1feb7b, 0x40120fd8f227d99d,
    0xbffb16f24d5ab8bc, 0xbff7bcecb604aa06,
    0x3fdd769535bf5278, 0x4008141fd25555f4,
    0xbff1cf54a8a31039, 0xc0065e2df08a33e7,
    0x3fc21fd71e749ef0, 0x3fe20d97e26ad5ae,
    0x40017d95204005b3, 0x3ff8798283ba3f71,
    0x3ff0dc4b3cf58770, 0xc00332abb5bbc0ac,
    0x4003a31242f72007, 0x3ffb65460cbe7939,
    0xbfe11a7148d8ed3e, 0xbfe8daf1fab7f8e2,
    0x3f91521dbd2c6a80, 0xbfedfba0fb516980,
    0x40066ca5b97487bb, 0x40105a66d48c1519,
    0xc0003ba4ce933588, 0x40039a33e71ec4f0,
    0xc004c800baf37c3c, 0x3ff77d7601b82ee4,
    0xbffa47eb41c1c665, 0xbfe96db2f0015be3,
    0x4003b9fd6a831b28, 0xbfe9b9e806dc8580,
    0x3fe02ff77a630dbc, 0x400d2631dd40867c,
    0x3ffde0f3ee34fb79, 0x4011cfa450b31aef,
    0x3ff2ed1bd97005b3, 0xbfc435bb40752504,
    0x4014cdb110b0dc34, 0x3ff8ef22a3a604bc,
    0x40109c8d4501d043, 0x3fed1440b654189c,
    0x3fe809741b37e5a8, 0x4007c08e045732e8,
    0x3ff02f97b6472ab7, 0xc0010c45b112b6c8,
    0xbff58d5410203b47, 0x3ff50bc6c1fd4272,
    0x3ff28c9da84b3e76, 0xbfbff74feff8df20,
    0xc0093f4f0095409b, 0xbff2a8e3ac86138a,
    0xbfe4573739f507f6, 0xbfd770a40baff4e4,
    0x4011bb00c5a3ada3, 0x40041812136f5028,
    0x3ff5dd7f32b22c7e, 0x40009122b503cc44,
    0xbfea6c30a16fc56a, 0x40079d4ea2291696,
    0xbfdd675b9b4bce32, 0x3ffbe6ea427847f7,
    0x400ec1f1c1199dd8, 0x40155561010f0c69,
    0x3ff05d8dbb4ca41d, 0x3fe2cae7208d559a,
    0xbff3ca4f18a87ae5, 0xc009a5ef746e1611,
    0xc0084f3ee0b09ad4, 0xbffa53a954885afa,
    0xbfc64f7ba9d2d2e6, 0x3fe263f3a80ce882,
    0xbff3ba65e84dd374, 0xc0056cef34109cd1,
    0xbff160930206399c, 0xbfcb0ceb39ab1eee,
    0xbfddc43fdb8a4bee, 0xbfd9ba0a92def8e0,
    0x400f61357aab6e2c, 0xbffd148b8eda28bd,
    0xbfc13eae5158c764, 0x3fe73e3d4bc70c5c,
    0x400a32bc1ce65e65, 0xc003cfdc88da7668,
    0xc008326b24711173, 0x3fddfd993e435cb8,
    0xc00c7df25a3453bb, 0xc00093caade9c8f8,
    0x3fff859d62fce354, 0x40066969b7da1585,
    0x3fe2b0c65c81927e, 0xbff96a72ace9ce34,
    0xbfd347d339ed92b1, 0xbff922a69b2da59d,
    0x3ffe109bcc31c4e7, 0xc00318d488321274,
    0xc00864c1ca7c0d04, 0x3fe80d8a4ef7a6d6,
    0x3fc381de83efdf70, 0x3ff9ca8c2cc87334,
    0xbffd5f1aeaf83ff6, 0x3fed787a36c22e06,
    0x3fba769aaddba380, 0xc00640592ad70d9c,
    0x3ffa2fa886423bb2, 0x3fea033888bd49b6,
    0x3febf3d60da11842, 0xbffa8c6e4fbeb1f4,
    0xbff15597b19d6560, 0x3ffb59361b101582,
    0x3ff9d2ef0108cdf4, 0xbfefcdc6924b869f,
    0xc00df08213f46556, 0x400253c2c7489111,
    0xc004f1aed3f8d050, 0xc00d6909843837e0,
    0x3fe70957ab445cb8, 0x3ff7302fc584756e,
    0x3ffbfa64cb76f908, 0xbffd341fe862cde1,
    0x3ff8510f99466a4e, 0xbff46b93b07783a4,
    0xc00050b31d10b3c0, 0xbff094cf003a1e1f,
    0x3fe1e172206b4662, 0x3ffd5228508a7109,
    0x40067cf1f1e32896, 0xbff20c2db7bbe9ee,
    0x3ff01c88ecbd92db, 0x3fe9986c033d0dc4,
    0x3ffd76e646b8e902, 0xbff26442755f3c79,
    0xbff90d31621d4c99, 0xbfcd6325f7120960,
    0x3ffcc13efad69d6b, 0x40126b4dfcc95c80,
    0x3ff61edb216983be, 0xbffc94300fb5ff1f,
    0xbffc518ffd956f43, 0xbfba8028bd407adc,
    0xc00bbcbd522e42d4, 0xbff1d91e6a45c0d2,
    0xbfe7366d31ad7492, 0xc009b0e83e882953,
    0xbfc3c40e426313a0, 0xbff56923c41ba450,
    0x3fe012d2820b8d7c, 0x400c377b28141f3a,
    0x3fe6886f9786690a, 0x3ff6ff944aecb99b,
    0xbff6d1439c00d69e, 0xc000d573ff2986f3,
    0xbfe7fdca9b1d9228, 0xbff5d2374825b8b0,
    0xc004749e8f26675e, 0x3ffd040addb814c0,
    0xbfce533db6e46d4c, 0x4008cc2fea798126,
    0x3fe5e11177a950d8, 0x3fc43888d3c42114,
    0x3fad890381f01d08, 0x3fe6483f245625e1,
    0x4002df53bbb167ae, 0x4010183d06f5327e,
    0x3ff292ff1f4dc5b0, 0xc011af89e04072de,
    0xbfe7777a04fce1d2, 0xbfef374ffa4e8170,
    0x3fe8408b5a205850, 0xbfe544f6da169f26,
    0xbff7cbacc1a5f210, 0xc0081cabd3e3a8a9,
    0xc00e401ba4b22f8b, 0x400393ca4841a417,
    0xbfe68eb361a0e1d6, 0xbfe2e9fdcb21eec1,
    0x4005aa2315311535, 0x3ff6091dbfaecaea,
    0x3fe5a298cbf9b09c, 0xc001771f570cec2e,
    0x3fe40ad11f898803, 0xbfd725a6f2f83c4e,
    0x400109590d366822, 0xc004e234cfeaa7b7,
    0x400624c4127e2c74, 0x3ff92c38cfd7e38a,
    0xc0096a4296ba3efa, 0x400f4fb316eea182,
    0xbfa20a0540ff8930, 0xc01071e0185378b6,
    0x3f90cc503bb7f800, 0x4005150f03aeab2f,
    0x400aa0ad5b455b44, 0x40044f60d8c17255,
    0x40163a04f3fb7a16, 0x3ff2791549296010,
    0x4002eabd95a409ac, 0xc00b1a9a8acc9e54,
    0x400e444d02873ee5, 0x4004ef3fa8a9520a,
    0x3ff04c2f65466c5d, 0x3fb8468af544bc30,
    0xbfe29371d796c47e, 0x3f982f1ee104d9e0,
    0xbff201568eef3b99, 0x40059234d4568b2a,
    0xc00d1362d2836bce, 0x3fedb77b6166526e,
    0xbfa7357c61f0cc58, 0x3ffe8d08364f5a52,
    0x3ffa8cb61d105a7d, 0x3fc5ef1fa6617eb8,
    0xc0105d12c3834b7c, 0x3fbb9bfa747a0600,
    0xc014717763d3c931, 0x4001766a354d2524,
    0xbffc5e2b8146d2c0, 0xc01c3c94174b66b0,
    0xbffd0155e4e75781, 0xbfc25a63a9473ff0,
    0x40029acc4c9d14aa, 0x400473467551505d,
    0x4007622d4f90b93c, 0x3fef70344e3983a2,
    0xc00d374867a2a712, 0xbff6985312de3a0c,
    0x40056962d8b8d2e8, 0x3fe9266e16361332,
    0x3ff8c05964f04686, 0xbfcc3f2b4f61df22,
    0xbffd75232d2965e2, 0x3fb5c1f68e182ad8,
    0x40015a576d398cee, 0x3fd8ce21554ca7a8,
    0xbfe5a85f22b06420, 0xbfe3b72376efd6da,
    0x40134180144d6c00, 0xc007ff42182d8a8a,
    0xbfbcd33903d5d81a, 0x3ff1c1c61d5254f0,
    0xbffe6dec3ff8f5b0, 0xbff5af7bc1021b34,
    0x4003a34f767816ec, 0xc006fbc531abc882,
    0x3ff148cd39dbf040, 0x40028360973ff25a,
    0x40045548cf3600a4, 0xbfc2fef7cae267d8,
    0x3feefa591696c6f7, 0x3ffaf9d395094396,
    0x3fdff40c6e57e388, 0xc008ed42d152939c,
    0x3ff34a3a4d66292d, 0xbff4c2c2e3c3cf2f,
    0x400475d3afc551ff, 0x400f7262c3296a0c,
    0xbfcd1b4e0f6e3610, 0x3ff52d506ce4eb32,
    0xbfe3df3f13b486c1, 0xbfee92f398e2d395,
    0x3fefba223b6f5d1d, 0x3fccc4afcce18188,
    0x3ffe0d3fb49f4f6a, 0xbffa0a62d546d3a4,
    0xc00186ddabe9b36a, 0x400071aea6cda1b6,
    0xc00fb9159a2caf86, 0x401348211fe19ac7,
    0x3fe9e8a5b422d82a, 0xbff366a1693577e6,
    0x3ff01cc9b3dc8d54, 0xbff88b2dd040f8dc,
    0x40004b98bd1ffa4f, 0xc005cd6cde41b18d,
    0xc01507cc8527f929, 0x3ff33df3075d90b3,
    0xc0075d86ecbb6244, 0xbfe91ded5b1280bb,
    0xc006ee390b59d521, 0xbfa5c6d766d6e280,
    0x3fd885629256e438, 0xc010a5900cd45cce,
    0xbfe4d3fdfeba4d58, 0xbffb028eecee4770,
    0x4012225a6c04b88c, 0x3fc7998c227b2638,
    0xbfeaf8ece18e578a, 0xc00e0266aa03126d,
    0x3fdd95dd87de8f00, 0x3fe9aa7abdc85a9a,
    0x3fe4723bafd0e94e, 0x4008614bbe86a144,
    0xbff0b4b8a8421538, 0xbfdab82072934e48,
    0x3fd4032447ba2202, 0x3ffba0ac4342a827,
    0xc000649b847b9dc8, 0x400aa10fd73fe228,
    0x3fe8f382020f54fe, 0x3ffd525e02170526,
    0xbfca792efd966516, 0xbffdf35607f24dcd,
    0xbff9f1415f8ad3e5, 0xbfefb751292e98c2,
    0xbffb24ff332c2686, 0xc00ea66ab74581ba,
    0x3fd987f39a043998, 0x40065c43d038756e,
    0x3ff4fc644c2a96ea, 0x400a4bac0fdc4efe,
    0x3fffef98d3420312, 0x3fe3b21c72fb0f04,
    0xc007e37d9ea66604, 0x3ffd11aef9d2d184,
    0x3fe5f9f672c180d3, 0x40112178eab97f92,
    0xbfd44857435ab520, 0xbff7bd866c04ea8c,
    0x4001e31cab7299c6, 0xc014b361f0c44046,
    0xbff7a4db0540d58d, 0xbff769252e32d99b,
    0x400bf23939069f0e, 0x400f7290b638813c,
    0xbfe845857ddb72c2, 0x3fdd1e0623005698,
    0x400203e989388e90, 0xc00b6a3b30e9fc2d,
    0xbfef656341f8205c, 0xc0015052ab68591a,
    0x3f72600241071f80, 0x3fd27d97f9470ed0,
    0xbfe2ba91d19aae8f, 0x3ff99120b5c628a3,
    0x3fe43ad4f5e80811, 0xbffc6be1c57bb04a,
    0xbff85561f61447ef, 0x3ff36de1970d55d6,
    0x3fae209a319d1480, 0xbffa40862eeb06fc,
    0xc007877b9aaf9a36, 0xc0091deeeebaa83a,
    0xc0023d28f777d93b, 0x400aa7e206b9ee06,
    0x3ff2f745002df0d3, 0x40073d67565ed2b5,
    0x3fd7e2957ddda672, 0xbfea027152e61c04,
    0xc00b8e96d5357cce, 0xbfc067e4555b7420,
    0xbfd8f1b4368093e8, 0xc0088d3b2d803f7b,
    0x4017675df9a0c917, 0x3ff2c72bb04f91f5,
    0xc003be764c9fe73e, 0x3ff355cbbdd38498,
    0x400e1a0a4d7b8c0e, 0xbfff8fbe52a68ec7,
    0xbfe20030908b157e, 0x4007b67e4b0a093f,
    0x4008f0605bd46a6e, 0x3ff81dcc0a1e1859,
    0x3ffaf33f5024e0bc, 0x4007e314ea682b5c,
    0x401e3ca8f6833bdb, 0xc00b181e84f5672b,
    0xbfccd416f179bfc4, 0xbff4500d27997242,
    0x3fdf9b806ed4cff4, 0xbffa528c85a9e214,
    0x3fea1b3d0f8acab6, 0x3ffe2baaa302496c,
    0xbff9793762c3d80e, 0xc000f8c34878b960,
    0x400848886e7b4af2, 0xbfd7b26180a20488,
    0x3ff96a608ea89e86, 0x40026069677219d6,
    0xbfff6014e97859ab, 0x3fd16f0ad26ee1c2,
    0xbfe22aa307bd6ebe, 0xbff77ae080deb96c,
    0xbff012098ce4ae94, 0xbfd054bbdfbe1c3a,
    0x3fff449775e01656, 0x3ffa23d808125120,
    0x3ff957a085989498, 0x3ff2316d54a67083,
    0x3ff0978a15016d32, 0xc01267d7100c3d7e,
    0x3fb96df32a2417a4, 0x3ff97f6cfb435fb2,
    0x3ff7afd4ef8666e1, 0xbffd83b170e44c03,
    0xc005892039e6fe8a, 0x4001a4a5eca54056,
    0x3fee1e4e5d9a06b8, 0x3fbb3f938a5ad148,
    0x4005da0fbb8d722b, 0x3ff700afe20c3fb2,
    0x40127b81fbe6fe79, 0x40001913b8f9fc7c,
    0x3fd73ad2c860dfc0, 0x401284ff7e3545ee,
    0xbff576e892ce72b6, 0x3fc666811fe158f0,
    0xbfba13649181ced4, 0x3fe7407f7f5c832e,
    0x4011dbd8953a6654, 0xbff7e21f825683b2,
    0xbff1ef3328b94bb2, 0x3fdfee3862f912cc,
    0x40026a6f1058a4fe, 0xbfed91511e9d8afb,
    0xbffc153f0c304212, 0xc00154b8db8a376d,
    0x4002e1d6c12f2c2e, 0xbfdc5c8b54c7974a,
    0xbff1787a84478a29, 0xbfc4191ba49b2acc,
    0xc007691c05f64657, 0xbfcb455ff93234d0,
    0x3fff6b68072ae8a4, 0x3ff285feb8c8a300,
    0xbfd77a40cf9bb57a, 0xbfefcd8d9854e388,
    0x4000385b85b2e59e, 0x4007f6b672210bac,
    0xc002fbdc4a14be44, 0xbff678a2b772f130,
    0xbff9e392cb6b4cf8, 0xbfe4b61716fb2fea,
    0x4000cb592c6f6d2e, 0xbff5632432d20f6e,
    0x3fe3866075e2e28c, 0xc006e194af86213e,
    0xc00afe4f830e1bae, 0xc007dc3368ba0fea,
    0xc010091ef26fa9b8, 0x400b614c6d1a7ec0,
    0xc000433ca4f8e3c2, 0x400d6a12e25c8fe6,
    0xbfe00678260aff7b, 0x3fe62648ae3342b4,
    0x3fe5b88837f48930, 0xbff564457664fd16,
    0xbfd755fca92b9140, 0xbff7b860fd1b5574,
    0x3fff8e08f67f401f, 0x3fff181b0cafc88e,
    0xbfdd3d9367e10604, 0x3ff35ff88f7e22d9,
    0x3fff857926200301, 0x400b6bf6694075d6,
    0x400abc8c85789f42, 0xbff7d1f88d357480,
    0xc0114be3a6f53769, 0xbfed442305bd6e9f,
    0xbffba5c9159125ce, 0xc018c6c860b7d07a,
    0x400afda24dcfc7ab, 0xbfd68fc2ff4c9b70,
    0x40118102d4e86ef1, 0x400821a4cfac8496,
    0x3fa1941e074a97c0, 0x400014cea4c92500,
    0x3ff69074b5c71c44, 0x4005fc29286e6cb2,
    0x3f8554bf50345fc0, 0xbfe28bc163123f25,
    0x4005f4d5f76a6d8a, 0xbfe5ee0487aa4384,
    0xbfe29577e21bcd83, 0x3fd6a6ad64d47234,
    0xc007cc95eb28333e, 0xbfee3572096e6d6c,
    0x3febf7da7a995a59, 0xbff7f30ebcbb7340,
    0x400fac93f627f3b4, 0xbfd997c2570d0632,
    0xc001d7650b986c7b, 0x3fe2ff8957cc3d0e,
    0x3ffcc1a63da74583, 0xbfe439408273b6ce,
    0x3fdd560ddf5e6b7e, 0xbfe8e0f9192be27e,
    0xbfe98c93b4319db5, 0xbff16afbe3f6604d,
    0xbfea9acbeb6028aa, 0xc0123b65225cea34,
    0x4002b351e995ac94, 0x400037b86763f615,
    0xbff260b8b40f526b, 0xbfe92c9067315425,
    0x3feebbf1eee59756, 0xc00075fb7ff1a7b8,
    0xbfc685f05a3b5b84, 0xbfe82396674ce06e,
    0xc00b602e8f867184, 0x3ffa35ee78b63c48,
    0x3fd04223fcff6776, 0x400e0522a6bed3e6,
    0x400fc20b81dd46fe, 0x3fe2cd3e059b8237,
    0x3febaaa9b821b411, 0xc007f4fa0da33260,
    0xbffb0eff52923a45, 0xc00a9e0f1f9fae30,
    0xc0012f9896f5c228, 0x3ff5ed5abf2bab72,
    0xc00d05f1b6e8ecae, 0xc001baa770d64e9b,
    0x400df043fb2de9b3, 0x3fd8427bc4eb3dd4,
    0xbfdcc093ff6ecfd4, 0xbfeed321f2a656a8,
    0x4016c6e31c5fec49, 0xbfe88a3bddce98bb,
    0xbff4fdd66d2c0068, 0xbfe1b1ac3c32ab54,
    0x3fcd020868d316e8, 0xbff6c4f3ff2af410,
    0xc007a33126222c55, 0xbfe1b66d01165698,
    0x400d3b1775a8060c, 0xbff7cc2709ec3ad0,
    0xc00cef0ac7e5ab38, 0xc0011b53baaa2e55,
    0xc00ed0221ef5bc28, 0x3fc835e650e066db,
    0xc0052da62290baad, 0x3ff94b4864dac0d1,
    0x3ffefab2dd9b9a80, 0xbff0dee7227b6165,
    0xbff502f4a4efe1db, 0xc002080d33c1c928,
    0x3ff92e3d478845a4, 0x3f76087e998f4440,
    0xbfbae1e9d6dd9d40, 0xc002c476bdaf87e6,
    0xbfeac539f8c4a2ad, 0xc0030992fe9f0a08,
    0x3ffc218a0cf98ea2, 0xc0096faacb761bf4,
    0x3fe6faca6b7c9d66, 0x3ffad3c12dae3d14,
    0x4001c4bf2265df00, 0x401b1cb919f4341f,
    0x3ffaa3148a688069, 0x40005d048d30cdf0,
    0x3fdac2a1ccad6630, 0xbfe2876ce8c439c3,
    0xbfffdee37812df66, 0xbfffaf2431558a04,
    0x3feec4be66c8949c, 0xbfe02ad28fb57030,
    0x3ff4f593a5c69244, 0xbff5771731d2aca7,
    0x3fd531fd7503ca80, 0x4002d36335166f6a,
    0xbfe9221701ab4817, 0xbff338a01938ab95,
    0xbfeef934507cbc99, 0x4014fe64d2b9c233,
    0xbfddb5b2277d67c8, 0x3fcfc9349ec82bf0,
    0x3ff5bc34515f181c, 0x3faba1fcb31934a0,
    0x3fd9735153bd0b94, 0x3fff416ef60fe20b,
    0xbffdd359f2acc9ac, 0x3fe95f917d332051,
    0xbfdff51db7db9a58, 0x4004fbd8c0d39eac,
    0x3fe57433002dc2cc, 0x3fd83f37b9062b70,
    0x3ff5092fb1d9a584, 0xc004bfe652895936,
    0x3ffc4039c1a5530c, 0xbff1940f36cfac98,
    0xbff14fe638890f44, 0xbffa7d8e69f6c390,
    0x3ff2c18c9da33b53, 0x3fc2f315925d33ec,
    0xbffb28ce6a2e237e, 0x3ffed6ba01d0adc4,
    0xc007cc24b74ec56e, 0xc00576a9c8bb3b0a,
    0x4003d9c263e772c2, 0x4011afd26ae77628,
    0xc0020b2539d008b2, 0x40068180538fdf24,
    0x3fec5a809993146a, 0xc011289cc564b5a0,
    0xbffbf22cf5843da6, 0xbff3398156b81cae,
    0x3f788c4afe61ff00, 0xc000e42ad114c5ee,
    0x3ffd40a3f6cc2b5c, 0x3ff58e64e4c05dd4,
    0x3fe78835eb9327c8, 0x400f802a53f15890,
    0xbffdc991022e3948, 0x4004724e2ccb40ac,
    0x401f13e197e2e0d6, 0x3fd3656337494550,
    0x3ff079502cf0b244, 0x3fd948f29d525174,
    0xc00e182ecf6da4fd, 0xbffe83233bc23082,
    0x400998092d69deb2, 0x3ffe46f3d1c8cd4c,
    0x3fb7cd577c4790b0, 0x3ff2fee42b9c8774,
    0x3ff10a337b538f17, 0x3ffa6ebeffc33a96,
    0x3fe6ad47c3666e2a, 0xbfe297c3b25f8868,
    0x3fe6fddc420371b4, 0x3ffd6a37e5a6e702,
    0x3fe749474078d268, 0x3ffd25a3d2abe212,
    0xc006677d6b8a1944, 0xc007af660e661a40,
    0xbfde8cd71cbd7452, 0xc00e27badae73365,
    0xbfff4c294962ae74, 0x4010b2013f690458,
    0xc0005045bdc376f5, 0xc0060eeb8cd51b0f,
    0xc007fc0584c2704a, 0x3fea8bf163fe9d7e,
    0x3fc28b6132a37f64, 0xbfe38f1f6c6382da,
    0xc0055380a7bb29bf, 0xbff1095f301fda84,
    0xc0020c3a4285d6dc, 0xbfec5129c0f4b7ca,
    0xbffdb556521540c8, 0xc00e20fa73639cdc,
    0xc00dd50bc095a99e, 0x40057d6c5c840680,
    0xbfdb27f342ec0f48, 0x3fb02f584ee85330,
    0xbff28f292e53cb03, 0x3fded120e237a02c,
    0x3feb28894331876c, 0x3fd25b1a0215766e,
    0x3fe743bcb12ef627, 0xbfe8233e46392f36,
    0xc006e0b578144686, 0xbff428ad07eb030b,
    0x3ff8b54a56794ce8, 0x400ac7348503ba41,
    0xbffefb57395bf7f0, 0xc005d444f3c240ee,
    0xbfe934ab14b1e1d1, 0xc0073b0171ab9a23,
    0x3fd363bc53c54b74, 0xc0020a46ac47b25e,
    0xbffa9526347d5b9a, 0xbfdfb3c48d72e736,
    0x400a374261311ea4, 0xbfc0148d33ce951c,
    0x3fbf89023ec82c10, 0x4006cb2cc55b1e7a,
    0x3ff61abc649b9fdf, 0x4000a945aad05355,
    0x4004346c7fbf8906, 0xc004d51e5ba0dbf8,
    0x3fe03eba07974500, 0x3fdbfa3018e493a6,
    0xbfef09bff6da8ee4, 0xc00b34bc476abc8f,
    0x40007077730fa08c, 0xc000841bc7af8e68,
    0x3ff3bc0f983a0058, 0x4001dde601101814,
    0xc01403cbfcfb2112, 0x3ff03dde57d5d7e3,
    0x401281c37ee62717, 0xbff086c8248fc9c4,
    0xbfca7f7ef96fdb10, 0xbfe3a458257f73f9,
    0x4003a867bc3fbc5a, 0xc0022a5f20875c26,
    0x3ff0732be35733ae, 0x3ff91ff2e9f8116c,
    0x401039dde8ebec29, 0x401be4168ff0c23e,
    0x3fcb47a1d642c1e8, 0x3fdd10ccb5df3204,
    0xc000260679c878be, 0x3fffce7b6afcf99d,
    0x401324bdefb9fa6c, 0xc004bd7f74203d12,
    0xc0078fc291c8b2c5, 0xc007741db040dbaa,
    0xbfe99de69c170516, 0xbff3e65b519eee1c,
    0x3ff370e5f5e98528, 0xbfc07e6f3910c4b4,
    0xc010c6e1259834d2, 0x3fcb534e0a530b88,
    0x4001d9f00aad31a5, 0xc00859235ecb9f5a,
    0x40085d60c34e93b3, 0x3fbd9c16172d9630,
    0x4010f4785d04db50, 0x3fa0985dd8299ca0,
    0x3f936bc91f4bfe60, 0xbfe304206cef3253,
    0x3fe22771e304cc3a, 0xc00e9afbaa037906,
    0xc00df53d237ee116, 0xbff51b0f9e0dfcb8,
    0xc00ee785b67c8b93, 0x40193835ec5c2b62,
    0x3fdf62e5779b1c46, 0x3fc8679d6043e5a0,
    0xbfcba3d5986a6de4, 0xbff2232a4e839dbd,
    0xc00459d3e4bfe4cd, 0xbfbc83ffa0664870,
    0xc005ee489fea39c0, 0xbfc9574515fa22e8,
    0xc00cb03d8b812375, 0x3ffaf22ef538184e,
    0xbffefe3cfeb559fa, 0x40027cc108693ef8,
    0x4006458f28dfcc02, 0x3ffbfb75fa02d8da,
    0x3ff6c906ea0ce737, 0xc01068bed4256110,
    0x3fcc1e1224e1b5b8, 0x3ff87df794582ad4,
    0x3fc395bbf108ecbe, 0xbfed4b3cc3d91b67,
    0xbfface6628297b86, 0xc004d14bc803d5d8,
    0xbfb6ed8048a6f2c8, 0x4009ac4261504470,
    0xbffd7948004f9e08, 0x400026459c214abe,
    0x40020bf97fee8a6b, 0x3fb7773478f4dc4c,
    0xbfe2d1ffe7d2ff12, 0x3ffe810ae590c8ff,
    0xbffca2178b8662aa, 0xc00d8e5fe05a4ef8,
    0x3ff5b0ca1fd9e87a, 0xbfd9828a20a68d24,
    0xbff641a1504fc870, 0x3fdc516a3272f596,
    0xc00343a9bfc20ee4, 0xbff8ea5137e1d1a6,
    0xc0107cfd3988959b, 0xbff2f98f5f9f96c8,
    0xc005b683d2b29b6f, 0x4011c759ca69a95e,
    0x3f86450959fc0180, 0x4005b3a4049817e4,
    0xbfdb458018abe8de, 0x400d2bcc81dd83fb,
    0xbff96496cf523bd8, 0x3fe8cf1a8a64f7bd,
    0x40090208e2a22044, 0x4000294dda7754b8,
    0xc011b6ba0d6e395a, 0xc00e1d5372100690,
    0x3fdb415b805ab50c, 0xbff60600c90b9c7a,
    0xbfc6577d5d6fa7e8, 0xbff95ead8c3379e8,
    0xc00587bb1644bee6, 0x3fc75d61fa049908,
    0x3ff94c31d8c68058, 0x40040d2daa8cac5e,
    0xbff27e35c7bc5c44, 0x3ff2a711a78842b0,
    0x3fe5c7fb03f309b9, 0x3ffe3d8063a08f7b,
    0xc00203156b393e24, 0xbff53def958b4ed4,
    0xbfd86dd287fc455e, 0x3ff71ef1c49c9fe1,
    0xc00554f596c456f8, 0xbfe8a6211e2900f8,
    0x3feb90beb626072e, 0x3fcd83f11696287c,
    0xbff2a75bebddbccf, 0x4003ab48acb6f96f,
    0xbfd75c5926cd7764, 0x3ff7941f6fb35634,
    0x3ff39c54680fb9c4, 0xc00362e38727ff32,
    0xbff331ec56694806, 0xc0100c0ea9b6b7aa,
    0x3ffcd43697af1345, 0xbfe05917e3fc425c,
    0x3fd3e1acab215626, 0x40078c4e7799fba0,
    0xc00748d71e01c650, 0xbfd47a6df718651a,
    0xbffe160e3022998c, 0xbfe04ebdf4251c4d,
    0xbfeaa75d1ff7fca0, 0x400015e416c51d83,
    0xbfee329760cbdaf3, 0x3ff8be8c72b59a98,
    0xbffe341b4d750085, 0xbffbd72b4510de42,
    0xbff55b57f71ca6d2, 0x4000b31edbebd3b9,
    0x3fe45ef25d342c3f, 0xc0049bfe78065380,
    0xc003d211a74304f6, 0xc00591067fe04b78,
    0xc011e46ac7e225ab, 0x3ff9b31cb4df9f60,
    0xbfca57cca8a81030, 0x401327e02fe0a125,
    0xbff1a49fccde9228, 0xbff518d21f4c9d38,
    0xbff1f9527c41795d, 0xbff4176327fb56f7,
    0x3feab19aaaff2648, 0xbfff3d81de3a3434,
    0x3ff78a15383edd29, 0xbfe934e75595610e,
    0x40008d7004bfac26, 0xc000284eaefeb6d8,
    0x3fe725f89674138e, 0xbff6f434de1a8a60,
    0x400a6b694a4218a0, 0x4008b6658150a930,
    0x3feb703b4198fb74, 0x3f917c4d47349320,
    0x3ff847b57d737382, 0xc0031f71d9f9abea,
    0xbff71dc3c526d608, 0xbff16c9d43cbf8d5,
    0xc006968e527655d8, 0xbff2cb5f89e10b18,
    0x3fc7b643a42eb308, 0x3ff735226c9067fc,
    0xc0184101b90b1a7c, 0x3ff4ef3a371f3d8c,
    0xc00172ff91bc06b4, 0x3ff08949d500b916,
    0x3ffebae8f91c64a2, 0xbff30befb0e07063,
    0xbff4a97511ad4a73, 0xbff2a5a4ef3ac070,
    0xbfe8990fc59db178, 0x3ff0e85f6afd4739,
    0x3ff823a501828562, 0x40015d0d43cde7fd,
    0x3fe8410a43ebf250, 0x4000aa1a1a3e2f56,
    0x3feeccdae0e9d3e9, 0x400fc21b1a41550d,
    0xbffbdea27221db2b, 0xbffe05d285130036,
    0xbfdf6e4890621070, 0x3ffc95d0d954930c,
    0xbfdb5eb5a0912dc8, 0x3ff73abf5102efab,
    0xbfe3903c659dd8e6, 0x3fca6bd9842f123c,
    0x3fe4073d105b7421, 0x3ff0cef6863e037b,
    0xbfe10902081ed6a4, 0xbff2ea0b79d87752,
    0xbfee38599593b006, 0xbf9984bf868c34c0,
    0x40058926f4d5e50d, 0xc00401e7aff403c5,
    0x401b98f5dffbed9a, 0xbfabae75fa7c7cc0,
    0xc0056cb69ce7b0ee, 0xc00ab95713331d52,
    0x3fefc300e685bfc1, 0xbff0299987f1972c,
    0x3ff6921f41980434, 0xc0001c9f340544f1,
    0xc0037ebb9b4a9c42, 0xbfef27f6e27e79ad,
    0x400f41f1dc702578, 0xbfed42406dca07ea,
    0xbfe79838b05ec6d8, 0xbff18c19fa4c0292,
    0xc002858e4ddfeae4, 0x3fbc643d0e3c30e0,
    0xbfe0049b1ee8cd74, 0xbffb1c3851fbff09,
    0xc009e726b7515f39, 0x400b7d096a0fbb88,
    0xbfe560078b5246ac, 0xbfe77f410dab0433,
    0x3fd5ae078a6483dc, 0x3fec41dfb6d73464,
    0x3ff36949da7ab245, 0x3ff5ca5b12f2e2c6,
    0x40132d4abb038b76, 0x4005042d1f7442ea,
    0xbfe372e2acf980e2, 0xbfb3c32d4a70c3e0,
    0x3fd2061cf1775f50, 0xbff6013dbf2ad292,
    0x3fc4662a3337628a, 0x3fda88aeef6cecca,
    0xbfe975366cb3e9e2, 0xbfc580c4ca6c70ac,
    0xbffe16811f9a44ac, 0xbff3d370899bd5c2,
    0xbff32fc29c9a0544, 0xc002edda96e451c5,
    0x40007260d482579f, 0xbfe3fbc7ba9d528e,
    0xbfb8e2da64d82b30, 0xbff766a6497d3eb7,
    0x4006ef609c44f3c0, 0xbfc5406547e44c50,
    0x400035c47b9806ca, 0x4011953cc72b1528,
    0xc00b3fb30cda30d8, 0xbffbb158e21caffc,
    0xc010a6df89d9103b, 0xc009ad63fec2e732,
    0x4016f37bccb56d6c, 0xbfe3d96a321a6884,
    0xc011e058bb464181, 0x3fe0bd3edd774b6c,
    0xbfef2b7005a5c48d, 0x4003d3b5245d2155,
    0xc00303e0f06b31c8, 0xc001f8e48ca347ff,
    0x40109d17ff9f816a, 0x3fe0a24e86a0f1b6,
    0xbfcd4f5c3eace3a8, 0x3fff7410fc227638,
    0x400bb4c2b4be802c, 0xc0005d7041836800,
    0x3f407cd4dcc37800, 0xbffd18464f324c72,
    0x3ff1c6d1921d759a, 0x3fb1f2cb0b10ae28,
    0x3fdaf7c3c3074cca, 0x3fc36488aea7e628,
    0x3ff1cc34e55d471a, 0x3fff50419c3f104c,
    0x400f8e5afda708a9, 0xc004eb76a1220f4a,
    0x400256cb16ac2fa6, 0xc005079e514a90b5,
    0x3ff67fa07d60b8bd, 0xc010b9abc8f45592,
    0xbfe54d506723c9b8, 0x40050e1d3abec084,
    0x3fece140a0dac396, 0x4004dd0d6db71ddc,
    0x40109d6925a8e757, 0xbfe1e6c5856a7760,
    0x40128d90fa8395ae, 0x3fa1b795e7795c30,
    0x3ffb6b0c55f4d6e6, 0x400525e5551eb691,
    0x40051522aeaaad60, 0x3fe42bad28785480,
    0xbffe94e496022c7c, 0xc01e85b7aa50fb12,
    0xbfd25400a421ba56, 0xbfe27b8a9be2ea5a,
    0xc01a4aa98a00f0f0, 0xc00baa2aad4690c8,
    0xbfdfd07b8c39f1d2, 0xc009490e9bb4785a,
    0xbfffafa3ebfd66a3, 0x40111a21a0391b18,
    0xbfba7d0da9a83ff4, 0xc00bf260c342b25a,
    0xbfc1bad7837b8518, 0xc00cd93f720d4ca7,
    0xc0038d86ad15e33c, 0x3ff0dadb78c5e2f0,
    0x3ff99742045f1600, 0x3ffa6da21e33e875,
    0x3fed19ed596af1e8, 0xbff8422e0416c982,
    0xbfdc58bc32f42320, 0xbfe9e310b67d93c6,
    0xc00b4be2bb8789d0, 0x40124814c3b39e59,
    0xc00f999c01d0eef6, 0xbfee74f2537efcd4,
    0x40171d13879cf17c, 0xbf69126af3754a00,
    0x4006fd6b8a8dd763, 0x3fd99753d02c3390,
    0x3fffd1affcbc5566, 0x3fde761ef5122f98,
    0xc010b5b200999272, 0x400c06c2050c077c,
    0xc002b23cbeeea10e, 0x3fe838578b22930d,
    0x40049b1b07fef22c, 0x4000c34f22edd950,
    0xbfefefbc08fe5ea4, 0x3fdfca826f016310,
    0x401204d32bfb490c, 0xbffe68620846ffb8,
    0xc0056d52e28c193e, 0x400ebef7aaf33c61,
    0x3fe5dd3ad999c670, 0xbfeb5d883fa6a872,
    0x4016bae93896cb75, 0xbfee77c3aa559324,
    0x40027d383d669873, 0x40107a42690d0f39,
    0x3fbf1bcccff79d58, 0x3fea9cc7356bca9e,
    0x3ffe11b90072109c, 0xbffc640832f3064e,
    0x400179cd376d3e40, 0x3ffb6c0d0fadfb24,
    0x400cdbf59ed30e55, 0xc00199082a4b14d8,
    0x3ffa68bff8afa685, 0xbff7c9159b4cdd2d,
    0xbff1434998771d78, 0xbff32d66947246e8,
    0xc000d2ee4b8cba1e, 0xc000e4d341e8c0f5,
    0xbfeb9c34080d64fe, 0x3ff27fa19b96d86c,
    0xbff7f161bc758f02, 0xbfeb955c266392d6,
    0xc00d5f3644af70ae, 0xc00a5ec82641f96c,
    0xbfe08698706e1a39, 0x3fcdddc7744400e0,
    0xbfc7ace2c632e67b, 0x3fefb6da00a70b38,
    0x3ffc1a5b74c9530e, 0xc002a445b11411b6,
    0x401270465ce6a3cb, 0x40038474cd7e2f80,
    0x400c7b7a7f66fafe, 0x40051b4ffbdff80f,
    0xc00025c04d7bbea3, 0xbff54d7cfd3ad0ac,
    0x3fb69d3bce563e28, 0x3fd89d7b5e31a88b,
    0xbff2d2ed3f92a060, 0xbf8cce5e1bb60600,
    0x4000701b875bb366, 0x400122ae28cc8e30,
    0xbfe2b99fe3ed5bce, 0x4007a67fa5e0a520,
    0x3fee364829922259, 0xbfe0182ecf899dd4,
    0x401022dc652c9966, 0x3fffc28370dd7736,
    0x4009779683aa1582, 0xbf97642f8eeb0800,
    0x3fe66620319d0f38, 0x3ffd528fa49d01f4,
    0xbff13359ea666330, 0xbff15e5d259dd0ce,
    0xc00fabd376ba7766, 0xbffdf1af849a294b,
    0x3fd7de0f8773f4ab, 0x3fbe3325b92364e0,
    0xbfe886560efb6352, 0xbff74699d9e554c7,
    0xc00da1398261e3fc, 0x4005bb9227543b1e,
    0xc0097ce33189bfaa, 0x3ff1d9889c6d47ea,
    0xbfa09981e8d95be0, 0x3fff481af71a9a61,
    0x3ff237e03e299126, 0xc00c2f1db46ce5e2,
    0xbff55102f8e031aa, 0xbff06f285f8ce82d,
    0x400e1cbb56f9a4f5, 0x3ff04de816a39ed4,
    0x401008f5a5cc7ac2, 0x4002565c6b9a9047,
    0x3ff4cca8a48f7600, 0xbfffce350ae245e2,
    0xbff871576c39af7e, 0x3fee7a4f705e2904,
    0x3fd35a02a53ed3f4, 0x40053dc93b031fea,
    0x3ffb33d7a727b38d, 0x3fd3b5a8aea8c4fa,
    0xbff0aaeb52c4d9fc, 0xbfd794c487d27ba8,
    0xbff6ebc32ebe8d4a, 0x3ff98a5c831ff580,
    0xc0028604b69adef8, 0x3ffaa116d2b15c6b,
    0xbff56245b2cfe376, 0x4010ee61d3786822,
    0x4007315a0bdba7a0, 0xbff111ad1a699262,
    0xbfe1edc6a22506a4, 0xbff2e56c25232418,
    0x3fd06c0ef83c9888, 0x3f92d76243739a80,
    0x401863ee28b1960c, 0x3fe9735422517560,
    0xbfef0973b4181248, 0x400e588a16afa234,
    0xbfd52432a007a540, 0xc004cef0c703d725,
    0xbfe0b59432a25fad, 0xbff331a61c7c82aa,
    0xbfed77d31715cfc0, 0xbff50064a2486eac,
    0x3fee47d48fd10bb8, 0x3fd04df76fe6c72e,
    0x3fb286bb053a4ca8, 0x3ffac99ddc0d4195,
    0xc0011c7069b4eada, 0x40017d45f3a34f33,
    0xbfd24416ee7fa315, 0x3ff3814d9a2bf348,
    0xc0040c490784c9de, 0xbff58dd3ed65c136,
    0xbfced56dc8e093e2, 0xbfe5053e572b4e76,
    0x3ff7340fa2fb4d15, 0x3ff38b899fa74b18,
    0x4001600bdc70c824, 0x40085350a730ab50,
    0x3fd188c7ca16578c, 0x400e62f96795035d,
    0xbfd12c584f221e3c, 0x3fed6bd5c1831e00,
    0x3ff4c7d058fd67fd, 0x3fb23ecf6baa195c,
    0x3fc3d169ab12bb44, 0xbffc90ecb1147bfb,
    0xbfda8b520bf7f41c, 0xbfeb4d38db8d3408,
    0x40055026e7ca1bda, 0xbffaa1d6116a0e11,
    0xc000561882b4f704, 0x3ff3d5b1bbbd820b,
    0x3f43a951f44eb800, 0x3fe42d611bdc90c6,
    0xc0010b8c5a1cd712, 0xc015d5d83629f498,
    0xc00bc60837985e88, 0x3fbfd45139f85630,
    0x3fe71dcddd901dd1, 0xc00c74164bf07104,
    0xbfeb204f009f44f0, 0xc010a30c925d27a6,
    0xc0077bf3a12362fc, 0x3ffe7d2e9f5c5aa5,
    0x400f798149641af8, 0xbfa04c841d6b7b40,
    0x3ffd570da311030c, 0x3f7a0d2950357100,
    0x3fce352ba58f1008, 0xc0009241d45fe3d7,
    0x3fd1bd1d8494ad30, 0xbfd287594aadf95a,
    0xbff98cc71d8252ac, 0x3f3984bccb7f5800,
    0xc007a4b0aa23202c, 0x3fd7d46d7dc8a4f0,
    0x3fe3e7c0ccfb5d84, 0xbfea2de3e80b9bbe,
    0x40051465b338a38a, 0x3fefc08da6a25b20,
    0xbfd6afb92514df76, 0x3ff85f3320cf47e1,
    0x4015f23f4687dbd6, 0x3ff80b165a6185a2,
    0xc000db153165b15c, 0xbfe40abc0ce396c6,
    0xbff567367a659285, 0xbff9edf9dc3bb1cf,
    0xbfbae89bf8077714, 0xbff134e099aebe79,
    0xc0065c3cb6bdab16, 0x3fca8b23a049ea50,
    0x3ffeaa86770479f8, 0xc000342834868ad9,
    0x3fe2553c68be8464, 0xc00819dd0f4351d4,
    0xbfeee225060720d4, 0xbff868c3905eac96,
    0x4010dd3f346bd9d0, 0xbfe45436ea24b752,
    0xbff7e616bc22eb40, 0xbff51ea2723f8aae,
    0x4001f57922f19cfc, 0xbffa382e81a9e75d,
    0xbfe5703d91865f39, 0x401054a3a4117ddc,
    0xbffc6c1d682571cc, 0xbfe338565583e570,
    0x3fed757b0d2e68d8, 0xbffe3b0bfc2865c6,
    0xbfde7bf394d503d5, 0xc00d0510ae87e1b4,
    0x3fc21ddaf4786580, 0xbfedae7fa37c6725,
    0x3ff88acd99961fd3, 0x400a5e1ea1be1c97,
    0x3fef428dc33a5def, 0x400fdb4eb768ae60,
    0x3fe6aade5f06c398, 0x3ff890797795db7c,
    0xbfc16a8eec92a44c, 0x4011afdde79ae64f,
    0x400e5c31795557d4, 0xbfe73f98236ac09a,
    0x3fe821185dd53d6c, 0x3ff34a793d20c3e6,
    0x4005eaa97c4830ce, 0xbfd557f4a95748ec,
    0x4004423311e2265c, 0x3ffcf1cfe82e95e5,
    0x3ff9710f3ab9db6e, 0xbfff57e32353d6f4,
    0x3fd50a72b9e724c8, 0x40129124e7a024a4,
    0xc009e6392954aba2, 0x3fe8125a57d636b5,
    0x3ff758e775370cc3, 0x40044d1825620e94,
    0x3ffb3058e9353e64, 0x3fefda361c4bee3e,
    0x3fe56c21398870a0, 0x4005e92be9e56a10,
    0x400350f7ecd171f1, 0xbfd8a0a6e6e137fe,
    0xbfd08608eb7ec774, 0xbff27685eb922282,
    0x3fbd570884c4bd50, 0xbfe2a3c6228cf97e,
    0xc0041134bcc904bc, 0x4004396f90603e44,
    0xbff1fba016d6429b, 0x3ff7f84fb5c70340,
    0xc0092b1ad03a07ea, 0xbfffb892f780514e,
    0xbff087be716081e8, 0xc00632d85318f5f0,
    0xbff57ca7a556ae27, 0x400dbfd63f369762,
    0xc0099c6e775b38d7, 0xc003f260d0c306cc,
    0x4000f0fa0f578b4d, 0xbff0e70e2310521e,
    0x3ff052761367abeb, 0xbfdecc1f7b54512b,
    0xbfe9b9ca8dbe9e1d, 0xc008f7ab0df21f82,
    0xc0048045a7a0a388, 0xbfe826bcbc5fb990,
    0xbfeafa7c96bc410c, 0x40094a28f77ee668,
    0xc011a73b4e9dd636, 0x3ff796e7f5cdcfe1,
    0xbff057b1d4448c4f, 0x3fd78087768c8400,
    0x40153d9416e1adde, 0x3fe32f70104405c6,
    0xbfe37399bb718359, 0xbffba493ff981d6a,
    0xc00640879a49eae5, 0x400f4a7a7f68f1aa,
    0xbfaa9225b52f22e0, 0xbff0da5fcc51edd0,
    0x3fb3135c26b32150, 0xbfe8810006414ee2,
    0xc0056eb6bdcdead8, 0xc00cf7db999bde3a,
    0xc001d8f168f38c1a, 0x3fca1faeee0b42c8,
    0x3fd58e2c33f1b9a6, 0x40117183f84f1402,
    0xbfe4ac6a1e7d05ec, 0x3ff6ea12832ba972,
    0xbff236c75388ffb5, 0x3ff962c41fee5748,
    0x3fc5ed72aa0bf2a6, 0xc002c1e5d8150d6a,
    0x3f81da0b3ff4b700, 0xbfd4db8ce60a7860,
    0xc0029485307d307a, 0xbff516bf4a41f133,
    0xbfeda4787ca86b8a, 0x40012fedfe5a2e90,
    0xc004fe6cc603481a, 0x3fe30f5270a9c250,
    0xbff40e75386dda6a, 0xbfe8e7aff416f55c,
    0xbfe35e3c939ee458, 0xbff7bd4dc5930c0b,
    0xbfe7d0e9a30ed821, 0x3fd51ceb87f8ab6e,
    0xbfd4c327fcc93e04, 0x4009246480cdaff2,
    0xbfd382fc8dac4e98, 0x3fb1397854d66660,
    0xbffa86a56795e28b, 0xbfe6c480bacb3968,
    0xc00f313d7fbcc753, 0x400df779f8f9ea66,
    0xbffce2fafa1b2360, 0xc011cffcaa933650,
    0x3fdd1b34a0222750, 0xbffb1d24b594839a,
    0x3f7fca3df0ae2200, 0x4007682732f2d111,
    0x400787a2405660c4, 0xbff0d862abf7292e,
    0x3fd6ac4b47818cc1, 0xbff97382cfebeb5d,
    0xbfe8b1bac6140d89, 0xbfc47037bce94718,
    0x3fda96dd1ff2f0dc, 0xc00e559cd66eb355,
    0xc0098c04d35743dc, 0x3ff795608bd2be98,
    0xbff20eea9e8ec7b6, 0x3ff479d855b26368,
    0xbff7fb12839e33a1, 0xc014ef6e70923d49,
    0x3ff2f1c97e055e9c, 0x3ffa4c5bc499281c,
    0x3ff2b8592286655a, 0xbfef51fe72a2d79a,
    0xbff5b5157954c06d, 0x4001dd1f45321724,
    0xc0068026798a071b, 0x3fa611392c7f3680,
    0xc00dd0df9d20459a, 0xbfd796ed7fa84a34,
    0xbff8734b072d7d47, 0x3fe080e9f4b63624,
    0x3fee9438b8f59d22, 0xc004c8cc8b305518,
    0xbfb689dee3c83626, 0x4001c1857ac542ab,
    0x3fe2fd48bab5138d, 0x400028ee50b5a79a,
    0xc0050b9cc16acbc6, 0xbfb6e56e88e75d14,
    0x3ff9653e3907558f, 0x3fed50cd3685dcb9,
    0xbff06850788444b8, 0xbff197f9984acb9c,
    0xbfff487940d555ac, 0x3ff47a1e0d133717,
    0xc012a90ed8f70bec, 0xbffc6f1a69074266,
    0xbfc379bc49e63a18, 0x4000653291346456,
    0xbfd80c1da3036677, 0xc00187ff2fe67619,
    0xc005440726bbddda, 0x3ff20392587711c5,
    0x3fea477502a22990, 0x4008f382be4244d4,
    0x400f233aaecbd84a, 0xc0080e10999fc7da,
    0x3ff6095ee03e8608, 0x4000016bbd8334b3,
    0x4010b32fcc60f532, 0x4011e6c605336afe,
    0xbfe1c3ccbfe7429c, 0x40016a9b4c1997e3,
    0x3ffa98798dde57b4, 0x40169fcec0f3298b,
    0x400be3c3943853c0, 0x3ffb03f6ec0e846b,
    0x3ffd3af208da0328, 0xc00315bbc933ad2f,
    0xc0034e9cf16c8a26, 0xbfe9a0144505182c,
    0x4003c8b2d43aeb6c, 0x4006ab18c55ce4a6,
    0xc0071f4f877724f6, 0x3fddd4d1e011f63c,
    0xbfe825f90e3ce04c, 0xbff1af8dcb2ba466,
    0x3fec67a64e50ddba, 0x3fe570bf89a32208,
    0x40004ffc57da198a, 0xc010a7349a792409,
    0x3ff5915414f73f78, 0xbffcf8c5d97478fa,
    0x3fce3252ab4fd910, 0x4000a60d3476a931,
    0xc003e93af0d044bc, 0x3ff23942f5e538ea,
    0x3fd19b168a569da0, 0x4011b49c4391168c,
    0x3fa9e34b55579f80, 0xc0067b7b4f5b1963,
    0x3ffda4df9dcab512, 0xc0069eddc0a4c518,
    0xbfec1673be86928c, 0xbfe77977d2a66145,
    0xbf86350394ed4800, 0xc001bda467922fd1,
    0xc01385af8eeaa2b4, 0x3ff297e0beef605c,
    0xc007208eddd4a8c7, 0xbfe594c4761aef7c,
    0x3ff1620f9cc0b319, 0xbffda7d747a328a3,
    0xc009dd04526115fb, 0x3fe3f7e07b3b30be,
    0x3fd9665833824518, 0x3ff323ab5187701d,
    0x40057ad38f84c8be, 0x40062649b9de54cd,
    0x3feca54bc81c8928, 0x40019ca8229c0a7a,
    0x4016416e9f08eda6, 0xbff36990ad6ebc9a,
    0x3fe11856aa651ac5, 0x3ff33540c8ae46e4,
    0x400c85edfd3869e6, 0xbfdae110248e31ae,
    0x3fe81378f684c1be, 0x3fe23f9ed24aa37f,
    0x4006328090b9d468, 0x4002333fa5a5aa78,
    0xc00b4aa24aed85b2, 0xc0065518e1573ff2,
    0x3fe4903ae918a65a, 0xbffcc6240e5f4018,
    0xbff96ba1de1eefc4, 0xc00a9936062d130e,
    0xbffc2110abd9333e, 0xc00174a5792a89e5,
    0x40104bd88c2c9304, 0xbffe43daac6ac4da,
    0x3ff40981b9895ee8, 0x4003148b63f6bafa,
    0x3ffe2a5e83063160, 0xc00adeef63f2b01d,
    0x3ff09f442f96d0fe, 0xbfe6da989b22fbf6,
    0xc0006dd46b13d056, 0xbfe6b846ed3583e4,
    0x400189be7a3d2e16, 0xbfcaf04c59f2b7b0,
    0x3fff53136c33dc42, 0x4011c3132d2095ac,
    0xc00649129688e97d, 0x3fde445f2569ee40,
    0x3ff2d036d31e15eb, 0xbfe8dd14c7819134,
    0xbfe2c72c0f4fdd9c, 0xbfb731816ff1c870,
    0xbfee56dfc7283d66, 0x3fff43d8fd7dd202,
    0xbfffa6b76347fa3a, 0xbffa0af2d51ad342,
    0x3ffce8624b7af6f2, 0xc0008b02f444466b,
    0xc0024a347e86aad3, 0x40065d28ed2ae240,
    0x3ff354f0b3020d48, 0xc000913b05ca0c19,
    0xbfd6cabe7d7bf164, 0xc00555719614eef6,
    0x4003516d1a78f62a, 0x3fed79d3a829df89,
    0xbfbb59fb50c9fd00, 0xc01159fcb37b72b0,
    0xbfbe605f4e375208, 0xbff508ad23e1e557,
    0xc01096feb060054f, 0xbffaa67d040a9c19,
    0xc0026f48b434bec8, 0xbffca86772c17a68,
    0xbff4ec15feb6d4e4, 0x400a9f44f548e03a,
    0xc002bf8a4f996f70, 0x3ff35ce3f95643c8,
    0xbff9aa55af1671f8, 0x40044b8d35db394c,
    0x4002aee5a936f125, 0xc00671114acd58fe,
    0xbfe9d87d565432c0, 0x4004e761ecaeb9b4,
    0x3fec21e77f0601ce, 0x4008fb30aae622ac,
    0xc00ae90b7d2cb140, 0xbff4424f33662365,
    0x3febf0eec91f32ee, 0x4003730ba21406b6,
    0xc0099fc8538b65be, 0x400b7ab1060757b1,
    0xc0021a54d94c8eaf, 0xbfb653ac6b3bc020,
    0x3fee3817ad3a6bf4, 0x3fb9b126c86b76d0,
    0xbfd868bc907c8d5c, 0x4002cb4b04452bd2,
    0x3fec6432c090cb5e, 0x3fe50475fa1d7dc4,
    0x400b05314332b5b3, 0x3fce09e86efc5ce0,
    0xc0096c63a3ec35e2, 0x40034fb36aebffd6,
    0x4000116a1364f988, 0xc00436948b9c5221,
    0x3fe67e29c48d5776, 0x400f61e0e055f00d,
    0x3fde9378431e51d8, 0x3fedf5be3104d4ba,
    0xbffd1a03bd26e30f, 0x3fd426d177417858,
    0x3fe2d7ad6d7847a6, 0xbff5042986354fef,
    0xbff397b95cc52102, 0x400d0a22c3259e3b,
    0xc00e235c8d9d0fcc, 0xc00383e2d6a2eead,
    0x3fe9fec01b017eac, 0x3fcf68fbdb90cff8,
    0x3fe4c1855eddd5ac, 0xc00b5323c8a1054a,
    0xbff346d970bd875c, 0xbfed660d6633565a,
    0xc00645430162e7d1, 0xc001f0a608a7a883,
    0xc005c4f02cef4d02, 0x3ffdd50d4b33624f,
    0x400556bc67bf6fbf, 0xbfe60b061b9f3e03,
    0x3fd2bf53c48b4909, 0xc007cf172cb6870e,
    0x3ffe2b2952e85fbe, 0x3fe84da28f77ff74,
    0x40118eeab284a0f1, 0xbfe982e510388b36,
    0xbfd291eeafe7b72c, 0x3fef9b391cbb202c,
    0xc014f19d93ef83ca, 0xbff94e4a57564904,
    0x40034760e918286f, 0xc004e8b6b824bcb1,
    0x3ff345f066094666, 0x3ffe3bbc53993f33,
    0xbfd2446e61defd85, 0x4004f0f029589c1a,
    0xc000e607ae23dcd3, 0xc011a5f545865851,
    0xbfd834b85a9afb2e, 0x3fe253be4a03aabb,
    0x40147c7fadcf00dd, 0x400f5b4ec03686b8,
    0x40086f6ad65bd1bc, 0xbff830c7fcc08abc,
    0xc012610077e41eaa, 0xc0033b4b5ba20788,
    0x3ff9003af5a456c2, 0x3fe621fdde738253,
    0x400182f59a6546d3, 0x3fffe7ba9b01be31,
    0x3fd9ec97cc10a20f, 0x4011b20d464ad093,
    0x40067932de90b8f2, 0x400c781154998283,
    0x3ffddeb93806ed98, 0xc001f18c66aefd2a,
    0xc009be7aaa2c45a8, 0x4001dd90e0f3ebc6,
    0x400b98da7eb5d54b, 0xc0089ba06b296224,
    0xc012a72d33b5a0e0, 0x3ffda9eddd8ff538,
    0xbfb5fffbb9f04600, 0xbfe46b3c871e93c9,
    0x3fe49c97a2e6b940, 0x4003041501a6038d,
    0x3fdae80531eb7100, 0x3ffd5c1dfaf3a958,
    0xbffcace9db85321f, 0xbfee1c05dd5bba2a,
    0xc013afc050d7c082, 0xbff133e3679775cd,
    0x3ff7278a6769d6d2, 0x3fe0067411b62c54,
    0x3faafc20482933c0, 0xbfa00807e5548548,
    0xbfee047c714f5df8, 0xc00028898cea4804,
    0x4011cf8bc01cb294, 0xc0040a628a369d4b,
    0x3fb40fcc534915a0, 0xbfeef2299a467df6,
    0x3ffb23cc4db70be1, 0xbfd2edc10d20e826,
    0x3ff55f74083c2cad, 0x3ff706313e29113c,
    0xbffdd95b8c03eb82, 0xbff0bf866422ded2,
    0xbff35fff8fe66942, 0xbff0d2b6073f0906,
    0xbfc7989b67b392e0, 0xbfc38294fa56a360,
    0xbfe7707706a2ff8f, 0x3fa00c2362806140,
    0x3fe1c848f0a6be71, 0xbff249faf556ea43,
    0x3fd0aa5f1f5a4628, 0x400b1ea04e964547,
    0xbfe4680ae09c9874, 0xc00907f935b020c5,
    0xbfa52fbf33fcc750, 0x40079ce4d1c3f092,
    0x3fe780e487567f1e, 0x4002cf9883494674,
    0xbfe24abe0d1a7d12, 0xc0062fe6a2dc7786,
    0x4016edd3c582a0db, 0x3fe012e4ddc3df11,
    0x3ff1fe13a3566c7c, 0xbffa451d72e90b1c,
    0xc00072a1dc681782, 0x3fec5b0087481ebc,
    0xbfe3e88b122e8284, 0xbff81f8a5ee78f58,
    0xbff4e80277a04e1e, 0xbff1cec799999695,
    0xbff04a06ab33ae59, 0xbffe8801cde850ef,
    0x3fe94158f26a4114, 0x3ff949f8fb4cf3ee,
    0xc005e1291117affc, 0x3fce8142364b1ad0,
    0xbffad274d98d7cb1, 0xc00c415906c178d2,
    0x4003fd4bb9b86adf, 0xbfc84d74fc8b0d20,
    0xbfe423b50e3c2b5e, 0x3ff4768306c7a9d2,
    0x3fe00c854b33cefd, 0xbfdcbdb468ec8640,
    0xbfd5ac3b02d129c0, 0x3ff8666f83395b00,
    0xbfd26be1ee94fb58, 0x3fce5dbb5e22c644,
    0x3ff0edaab568588e, 0x40041943faf05056,
    0xc0026b3d768f855d, 0x3fd0cffa30c6bdb4,
    0xc009ae03265a0814, 0x3fcf75ebb569a000,
    0x3fe15c4abe80e4ba, 0x3fe1d51954bc0096,
    0x3ffd4f5e436ee14e, 0x3fe1754c995cc69c,
    0x400239c76513ee03, 0xc008f65634cbdb10,
    0xc00409f1a5a6957c, 0xbfee85d67c14109d,
    0x3fff512b3db492f2, 0xc0128ad8b1399a8c,
    0x3ffad18d3691adb5, 0x3ff40aaacefce8b4,
    0xbff4c501d99fcec5, 0xc0125ea28f2d790e,
    0xbfb33b3756153ec0, 0xbffc34be0d21b684,
    0xc00e793a396a2287, 0xc0061e9f049320ee,
    0x3fec3bac548bf53b, 0xc01d34f4167fe8a6,
    0x3fee08595bc7f402, 0x400b6cfbb2640c38,
    0x400cf375883db8be, 0x3fde6eb4ec61e05a,
    0xc0015bb7feec0929, 0x3fd48e1095c3291d,
    0x3ff92cc5072fbe41, 0xc0072b03fe3870ca,
    0xc004a396b4dd31a6, 0x3fefb6d402994fde,
    0x3ffcb602e30bdaf0, 0x3ffdb2d8d22eacfe,
    0x4000525f1bb5c53f, 0xc013bcd16604b3e5,
    0xc0017b5ae20b238c, 0x3fcf856c3a77c0c0,
    0x3ff46701859a8055, 0x3fb9983f852354c0,
    0xbfee311faf1c641a, 0x3ff42c25d41a3117,
    0xc0154479f4f9dc0d, 0xc00da4d749cd5fa8,
    0xc016a872d0000c88, 0x400130d178f48473,
    0x3fec4535aed08d79, 0x3fc5fe5e6b4ce734,
    0xbfd5b0ec83e734c3, 0x3fd099bdfaee80b4,
    0x3ff59b67060d68e3, 0x3fec4bcd106b474e,
    0x400d20b5b52005bf, 0xc002b3932ddfb661,
    0xc016923930b2f251, 0xc002089008357820,
    0xbff8f8daaa597e68, 0xc00301442950b870,
    0x400962a31d8e060d, 0xc010ec8f4496b538,
    0xc0012829cddba3b8, 0x4004ddab03455e99,
    0xbfc09795726fbbc8, 0x4008992f5dc37088,
    0xc0037dd8a8c07250, 0x4000b46e64c391d3,
    0x3fc5106ae4f7c338, 0xbfd67aac69f2d746,
    0x3fde89fe46c05502, 0x3ff389b08d8b4465,
    0xc013fec12ebe8ae4, 0x3f9a341100e54ee0,
    0x3fe0cd072973b228, 0xc00860ef93947be8,
    0x4007c392dceb99f7, 0xc0082c3df5f03e9a,
    0x3ff50be95968a9c2, 0x3fe22a8ab7f38ba1,
    0xc0072ec6b70b4800, 0x3fde5c22d70148a4,
    0x3ff3a7188f9664c2, 0xbfd86af1b42735f8,
    0x4004d629daf82492, 0xbfb410e9f697fb70,
    0x3ffcf4d5e43fa604, 0x40046d3cf9dbaa89,
    0xbff42db362c2c84c, 0x3fee61a90d14feb4,
    0x400ec9cc543cfba1, 0xbff85970bbe9a0a9,
    0x40041284ab1cbaca, 0x40001767998c98a8,
    0xbff6b8216a2477d0, 0x3ff8b8e3dd2702c4,
    0xbff3fcdf7ffa98e9, 0xbf65b37fcb19ea00,
    0xbffb338dc6813640, 0x4003256e35224c78,
    0xbfdf89d589340004, 0xc019b8ed558181fa,
    0xbfeab7a1d49df78a, 0xc000ed4765a110a8,
    0xbffa2ea7ec6938e4, 0x4001dbcda70118b4,
    0xc00b38061040a2ff, 0x3fbc3504e73a92a0,
    0xbff17cef14a9f0ad, 0x4002f9508b20975e,
    0x3fe59251bc58a178, 0xc0111cefe1f4250e,
    0xbfc6b977b05399f8, 0x400120d4cfc9b91f,
    0xc0039b670d8fb3eb, 0xbfdcedbfae01e718,
    0xc00199b577de8c23, 0xbff3b2b523817e36,
    0xbfe0cebaa5ad3156, 0xbfdb4b383d259916,
    0xbff3bd79783fcaeb, 0x40194828cd241b5e,
    0xbff365dacd4dbb0a, 0x40114cd3fe6454e4,
    0xc000f1e32db8ee08, 0xbff14eeaa9f8b01c,
    0xbfff76f3537366ee, 0x401302c853288748,
    0x3fe5efbfc02e2e56, 0xc0097c8c7660cda2,
    0x3fc0fe9df36b6ac8, 0x3fd43967c6f2a78c,
    0x400a554416c6d926, 0xbfe76195942fff1a,
    0x3fafd55fafe11ca0, 0xbffe6b3064abee80,
    0x400583f7155db6c7, 0xc014865c4a7437dc,
    0x4008540a1e4825b6, 0xbfcaa0dfe984371e,
    0xc007f0c1ed5da1de, 0x3fbb0392e4dd8bb0,
    0xbfb947ddaad03e20, 0x3feab442a90090d3,
    0xc004c710138f91ce, 0xbfd98f13c5a962d0,
    0xbfe9fb5bed9a8e08, 0x3fb1e0c473a14638,
    0xbff03b512fc20dfd, 0xc0032499c88fe683,
    0x3febaa40044d3108, 0x3fc5bf1178ca8940,
    0xc00302e96fa1f92d, 0xc0057c1d2f7c6a57,
    0x3ff8eafcfdc9610f, 0xc0128e6421306a88,
    0xbff274c37327d46a, 0x3ff9e729efd0e1e8,
    0x3feaa7d7a532e4e1, 0x40076b881e6ce596,
    0xc0028d8f1dfae50c, 0x3fe5ac44dcb5affe,
    0xbfd83f036dcb71ee, 0x3fcae8a8973cb2c0,
    0xbff9ccb747e0ed88, 0xc00e4ef6801f29c2,
    0xbffb6a5eca1d28bd, 0x400cba4b219be8ab,
    0x3fe36e2c8c88de12, 0x3fde1ff632d8a950,
    0xbffa1c0a61704328, 0x3ff13eef433a3e8f,
    0xc00364f178e3f0c6, 0xbfba110ac40664f8,
    0xbfe148be195b47f8, 0xc00dd16939f0be8c,
    0xbfe23736292d9f0c, 0x40118df716bed3aa,
    0x3ffb6ad2ac82df22, 0xc001195bf0523284,
    0xc0080f73c4403ab5, 0x400249cabdc1122c,
    0xbfccc54732dd90c8, 0x3fc49bc5ca821390,
    0xbfecd1eca8ec1b35, 0x4008b088050c3a62,
    0xbfef7e5b50577878, 0xbfff7a018f42f31b,
    0xc0091ce7db16014b, 0x3ffa2ed7466ac4d1,
    0x400b76e812e1bd6e, 0xc005491131477ce7,
    0x3fef61f37ba9cc80, 0x401308eb3886395c,
    0xc01663ac7671c48c, 0xc00ab96a4437f4b8,
    0xbfe2e079605a5337, 0x3ff25d3875779935,
    0xbff8cc996260aeea, 0xc013321718b33e00,
    0x3fdc291d7b5210d4, 0xc011423b29306886,
    0xbfc4096ebf9346c0, 0x3ff539e9313a1d3c,
    0xbffe699c88f687b7, 0xbfd029fb541c36ca,
    0x3fcd9708be56ec20, 0x4001c2ae1c2dde5c,
    0x3ff62c406670d569, 0x3fe7449f8e1f48d8,
    0xbfa4d62d37e62ac0, 0xc00350d8b4cc9001,
    0x3fe3c86ed2d125f2, 0x3fc94a64dda20504,
    0xc006be87b07a5a00, 0xbff94b0d7f877513,
    0x40020a69cc204e22, 0x4005ada939cdd08a,
    0x3fd6564a7f0b6c98, 0x4004728a3df749e8,
    0xc0119ac3220c869c, 0x4007903163130788,
    0x3ff02870cfefd875, 0x3fc42798a9680070,
    0x3feaa064afd59e22, 0x3ffb1fbbc5929817,
    0xbfc41077dc518088, 0xbfe8906ce6d2ecac,
    0xbff35e0397456802, 0x40118f831e46302c,
    0x3ffb36309d5b1042, 0x3fd5f083177d9960,
    0x3fd2ab0ad2b01dac, 0xbfe47e015940037c,
    0xc008f7476e5cedfa, 0x3ff959f122a4ba84,
    0xc0067f950e6c27e6, 0x400b668d290501c8,
    0xc00bd5bd64e016ac, 0x3fe65d9fc4758487,
    0x3ff491565515be57, 0xbfe1f151cccfbfe7,
    0xbff3a9399bc7b1b4, 0xbfb1c1ddf974e960,
    0xbfc84e8393021160, 0x4009256706da46e5,
    0x4012538e7282abf8, 0xbf76e570437e5600,
    0xbfe050541564a348, 0x3ff2c87c83bb5bbc,
    0x3feb29fa3db7185d, 0xbfff146c1b03e5fc,
    0x3ffdd1de4f387ad7, 0xbffe6d8294dacf74,
    0x400fbeceef5cba4f, 0xbfd5aa291de703dc,
    0xbfebd0cb888ad62e, 0x3ff1a770f08a09bb,
    0xbff21e7722499bc2, 0xbfda57395b8ffd24,
    0xbfff4821ef837639, 0x3ff45f428bb8b5fe,
    0x40106384bce3cfde, 0x3ff1c931f3dd3154,
    0xbfebc9891b0a8f5a, 0xbff93bbf638f4c0a,
    0xc002f03291fc783b, 0xbfec6033971fa298,
    0xc0036179200b02c7, 0x40076f500e85cf70,
    0xbfb0d971963434e0, 0x3ff0e92fcc59a855,
    0x3ff6c18b3f567aa8, 0x3fe8a0e216346c90,
    0x3ff66c65aaceb6e6, 0x3ff57860aa175c18,
    0xbff25edc931af12a, 0x3fcb1d3d6c46f878,
    0x400b582fced506f4, 0xbff4b81b3eb465ac,
    0x3fd3d43031513e26, 0xbfe59cc945dabf19,
    0xc002314f53d26aac, 0x3fbf9076f2910070,
    0x3fd998c872137b24, 0xbfecbf6b2876bf53,
    0xbfef57df9e5dc4ee, 0x3fe5b22cb88318f4,
    0x4001a323e2ed38f1, 0x3fd680670b1daaa0,
    0xc007a40cd69d4d5e, 0xbffe08e1f8ca1d4e,
    0x3fbece5b4853efa0, 0x3ff3641d37ba5657,
    0xbfe1abbfd1574db8, 0xbff3e89706076fc2,
    0x3ff56662fe805cef, 0xbffd58f471c68a70,
    0xbff1b244646cd1c3, 0x3fd605623ef7b8d2,
    0x4005ee2488eb1c86, 0x40050e1a5a8ba012,
    0xbffa1bd08305693d, 0x400e263f7906ffc2,
    0xbff665c640da2384, 0x3ff4c757ee49a525,
    0x3ff8fea2164b84b7, 0x400a84b5c635d01b,
    0xc00183a045b087d5, 0x3ffdeac3e22299de,
    0xc00692730ffcecac, 0xbffd91a738022f32,
    0xbff99cc3a5b44192, 0x3ff86326d01194eb,
    0x3fef9afdbf741db7, 0xbffe3534f6a3bf93,
    0x400682e2bd76c47b, 0x4003686ed5f9cba5,
    0xc00669a76e767798, 0x4010bf16ab24bee8,
    0x3fe00e7760e3c806, 0xbf987829f10dd260,
    0xbfe9b2f7366feb80, 0x400976f96f8881f4,
    0xbfda757adffe6b9e, 0xc012940b9b1ad366,
    0xc003b5e3c7c0e582, 0x3ff0accaba8fcdb1,
    0xbfacbfc1818b8520, 0x3fde0fe045ae980e,
    0xbffb252b028fe5a0, 0xbfee88b92323ffb4,
    0x3fe1075b45a83ed8, 0x3ff48ee9bdf4db84,
    0x40052d33e4c78d2a, 0xbfe2626c97113a2f,
    0x3fdf89930ee56f16, 0xc003dabe85a5733e,
    0x3fe2cda845cbbff4, 0xc0033282c7b229e3,
    0xbfebdbca4e58795a, 0xbff18729b9f8e939,
    0x400088928017d533, 0xbff884c966c7b43e,
    0x4005ad713fadda04, 0xbfefd096fd217417,
    0xbffb110f33f7759c, 0xc00055977cd98d5d,
    0xbff44cbf7e327925, 0xbfee0d8db5a2ba19,
    0xbfef79b393d03362, 0x3ffabf91e4f6bece,
    0x3ffec030e9bf8ff2, 0x3fd0d9b7384cd448,
    0x3ff760997c62de51, 0x3ffbf85450aa0226,
    0x4008f9a1e3435707, 0x4004bfd001fd822c,
    0x3ff01306ac028925, 0x4004b1c0c0c360fc,
    0xc00e8fcdd72e3fcc, 0x4008063a70be00ec,
    0xbfea5a8876314a90, 0xbfe8d9226d590608,
    0x40016dad81f71194, 0x4003cb97f7c1e920,
    0xbfda8ed457dad202, 0x3ff6db91f501ad38,
    0xbfe1941aaf785c7a, 0xbfebc01597941718,
    0x4004b845ae564fb1, 0x400c92c2b5a21b71,
    0xbfe1dd79a5a4569c, 0xbfbc1da528a84020,
    0xbfc4f3a08d6a4290, 0x3ffbf5b53787bfc6,
    0x3fec3bd75946c8bb, 0x3fed339bfc383b59,
    0xbff34b76e61f1b8d, 0xbff5525093f62c38,
    0xc0154e70bb9ec917, 0xc004249941ba4096,
    0x4004a4aed094606d, 0xbfe5c75e332c7d60,
    0xc0115df863daceae, 0x3fe6112735d53bc0,
    0xbff0611d3fce968c, 0xbff7a383139ed7a6,
    0xc002fc9402d47b04, 0x3fee6408f7318e57,
    0xbfe0593db251fc62, 0x400adbd8973ae521,
    0xc00a5810d43fc066, 0xbfeabb403744d92a,
    0x3ff0a696527d0186, 0x400f9020244e4291,
    0xbfd3c98a3d896df8, 0x3feda7434bec4d2a,
    0x3ff900f913ffe67d, 0x3fe143a9f806eb3a,
    0x3ffdb62c951a4ab1, 0x400e0302e367ec5f,
    0xbfed99d8063c9bd2, 0x4003bda9b5031acd,
    0xc00835fd879fa8bc, 0x40032fc180f4f78c,
    0xbffe4f50faa31f8c, 0x3fd0b163499cd974,
    0x3fea225d27dbe99c, 0xc00df763a6a90d98,
    0xc00f7c69f700a157, 0x400c60845cc01566,
    0xbfe7040b04710a94, 0x4015ecd0082189e6,
    0xbfed54c6fd829786, 0x4003ac35eb970728,
    0x3fd3833f929a685c, 0x3fecdf4b501516d7,
    0x40068b32b4b7ebcd, 0x3fe98ab6e9649412,
    0x3ff1fb48ffaee7c5, 0xbfc90f0db4ea5770,
    0x400279bf1313b866, 0x3ff14b454b7c2bfa,
    0xbfedacbf4a1fa7bc, 0x4015398b7d45396c,
    0xc00228b9c9e19b16, 0xbfdfefff05fb0eb5,
    0xbffa67b8df715694, 0xbfa72ca34ee1a4a4,
    0x4011366a03400772, 0x4008aa09979a35e2,
    0xc000262f5ea147d4, 0xc00f13e97ec767ea,
    0xbff9e1a8c259566d, 0x3fff98c86a9bba2b,
    0xbff57293fd9fe991, 0x3ff82a1ca3551737,
    0xbfe0392c1cdfb214, 0xc01562915231c795,
    0x401369e132b311e8, 0x3fc999a5f2b64ce8,
    0xc0039b47c41b4266, 0xbfed8282cc9695c8,
    0xbfb28c24c6aa7df8, 0x3fedac5022e75aca,
    0x400233812847934b, 0xbff57f839b84bb9d,
    0x4000dbb9b6979186, 0x3ffd6e40244957cc,
    0x40065e750bba813e, 0xbfdcd55c74a2e7d8,
    0x3fe5ca6c4852de16, 0x3fe4ef664d5d06ef,
    0x3fe721c516074112, 0xc00442db2330ce85,
    0xbfe0ddecfdf292ea, 0xc003eba5ff8537ae,
    0x40189c3a6f38d874, 0xbfe8dcef0db7b472,
    0x4008f9bc1bcb3fe4, 0x3ffb94d7c3dcbd13,
    0xc000ee17ba50e8eb, 0x3f9db3c01d52e4c0,
    0x3ff090a8b20c7eb1, 0xbfb0aab43efb6e50,
    0x3fe1aa5e8ee490a2, 0x400ed791f84eec93,
    0xc0079db1fca3e094, 0xbff5e26d9f5f9ef3,
    0x3ff44b7a764c3f30, 0xc0128c7407bf4f2a,
    0xc0039f8336e79613, 0xbfff49ea600e46da,
    0xbfe734590e568682, 0xbfa9b7f767e80e00,
    0xbff4c05590fec0fc, 0x3fd11d7e9df76610,
    0xbff0737a00a6a78f, 0x3ff2b258fe0cfe94,
    0x4007c52257452d76, 0xc00edd8f4686cf21,
    0xc00156adc8a30c06, 0x400e3eb459c73ff6,
    0xc0024992cf909189, 0x40144dd5006c26cc,
    0xbfed99af6a5b50b0, 0xc00b09d2f3c5a4cf,
    0xbfe699ba9dc6d87b, 0xc0093972cd5bce72,
    0xc002f2331d601f96, 0xc00074e87b11b06f,
    0x3fb5c468b2031e40, 0xc002f01954f2e251,
    0xc011a330acb295bf, 0xbffc2211402e7056,
    0x3fd22c430b23c551, 0xbff88f8bb3137eaa,
    0xc00b3cd4dbf43522, 0xc00239a13a1347b4,
    0x3fff3e6d4be4162c, 0x40085b8c8af8274a,
    0xbfffeb214fd71b36, 0x3fca709d46c66f44,
    0x40109ceddf5faf30, 0x3fe638c66c00e856,
    0xbfdfc2e53e979664, 0xbfef92a02f8ccdf4,
    0xbff0f12380ae376c, 0x3ff794a75b730208,
    0x401626507030330e, 0x3fcc45ec154c1eea,
    0x4000f3a16ff7d9e2, 0xbfe9ff55b754cf66,
    0xbfe87f55f57b2176, 0xc002db31a6f8d3e4,
    0x3fc193d82dfd0df0, 0xc00788478e8dac6a,
    0xbff99325796eed89, 0xbfd4b34f5faaa5f2,
    0xc0011b7d836cbd34, 0xc016bb121bff6bf8,
    0xc01b52934c2a2988, 0xbfe048cc172bb2be,
    0x401166990e4be567, 0x40065c72f397e678,
    0xbff24387778bd452, 0xc005aa4053bc47bc,
    0x3ffffd946354054c, 0xc00a88f161694cfa,
    0x4007e490b1e12def, 0xbffd8208120ac55e,
    0x3ff370e35aaf2150, 0x3fe02bf5eac367f8,
    0xc0131f1c8713a18c, 0xbfe51ba2517a6470,
    0xbfa438fccdd695e0, 0xbff99f1a757be5c4,
    0x3ff01930101e5500, 0xc0034e907d2388a3,
    0xc00007551d1cedc4, 0x3fe1e4ed709db0e5,
    0xc0136d64af90aced, 0xbfefeba281b46e4a,
    0x3fe4350d4bc50150, 0xbff6b8c19065d0a6,
    0x400228b61a8e97dc, 0x40068f0e4edecba1,
    0x400d9a640e9f4c06, 0x3ff3ea33d85f10c9,
    0x40160ae771c3b0c8, 0xbff4f0b1398baa98,
    0xbff5a29be7181592, 0x400b294d470bde60,
    0xc00b668c745b95dd, 0x3ff00d0383e4cf46,
    0xc002afb79d838ee0, 0xbfe3b938ad95f07a,
    0x3feecc23b7c3556e, 0x4003a639ccad5e7c,
    0x4010cdd25cbfa64e, 0xbff83e62b8268bd0,
    0x3fa2eaf9e4dd8680, 0xbfd34cfa5f838ae2,
    0x3fb6639565738908, 0xbfee3672a58c34b0,
    0xc0016385e92806c1, 0xc005c375026f5fbc,
    0xc001c78f9c646110, 0x4001231f741614fc,
    0x3fdaa7c5c704ce10, 0xbffd9dfbec7abd4a,
    0xbff7aec436b0333a, 0xbffb7a716ac6aea6,
    0xbfdeb052b4979e3e, 0xc0081e86069f14fc,
    0xc00d37190c2c847a, 0x3fea04b9c6f062e4,
    0x4005622b42e72474, 0x40072c55df7bff7c,
    0xbff28da735dd637a, 0xc00625091ba53d62,
    0x401384651851050e, 0x3fe50c5727af09e0,
    0x40027a7796641913, 0x4000a610d362d5f2,
    0x400986a2ca113ef4, 0xc0033e3169bceab8,
    0xc011207c539ba022, 0xbff3cc405cde62f8,
    0xbff341efd043fb38, 0x3fd653522e249683,
    0xbfed0bd8fdf385e4, 0xbfe934aaea87ece6,
    0xbfed6d2be7138262, 0xc005ae9075c48b50,
    0xc004f3019c82da20, 0x401108e3667aeeb4,
    0xbffb9bcbfb56552c, 0xbff64a4bd12bd88e,
    0xbff7c9ce5aa47498, 0x3fef5714d4c88e4e,
    0x400045a952c66379, 0xc00571e29ccc9974,
    0x3fd443a99e61143c, 0x4012af84cd093324,
    0xbfc248d2c586c864, 0x3ff3c326c2347f43,
    0xc00acee1557870cc, 0xbff605e2f26b5864,
    0x4004f74c9ba364d6, 0xbfec9595649f5efc,
    0x3f7b287b363e9e00, 0xbff077e8ccbfad16,
    0xc00ab638541a6752, 0xbff5309bd768a702,
    0x3fc33d712465ccd0, 0x3ffe50ede2fb82f5,
    0x3fe409a17529a6da, 0xc00234b5389828fb,
    0x40010842eb853aca, 0x4004d7d3ed120351,
    0xbfe7668c3224d56d, 0x3ffade23a106d113,
    0xbff91e4130ed4e4a, 0xc0017c11a8e52c48,
    0x3fe778d1a2efae98, 0xc003b567d3f2e348,
    0xc00e3b7b8ec5e947, 0xbfde70f1407e608c,
    0xbff5f75c399cbcec, 0x3fc786e5a46226f8,
    0xbfe95e8517e7eb72, 0xbfe690438fc7f9ff,
    0xbfd00ac144659938, 0x3fe5be7513044ee0,
    0xc00dc42e3be4803c, 0x3fddbaddaa13ad60,
    0x3fa16ffed7e302c0, 0xc00426e5dfc6244c,
    0x400e7829f2258b90, 0xc01028d6a1d3a986,
    0x3fe5818239784930, 0x3fd384da675a76a0,
    0xc001b02d5fd84c0a, 0xbfde15980e684868,
    0x3fef30f84da2cd72, 0xc001af6ee8a6fcbd,
    0xc018521fd133791a, 0x401014de2c47b196,
    0xc001870a1e8951b6, 0x3fd25b167711d984,
    0xbfe0df9ce9aeb2e6, 0xbfff0bd40cb25ad4,
    0xbfee6826de7da3b7, 0xbfb025dffb3d0e80,
    0x4012b024c2a270c1, 0xbff536f031f732f2,
    0xbfc49fcb6c7587e0, 0x3ffa84c6150e27a7,
    0x3fbf271b4e579878, 0x3ffae0a6b014288e,
    0xbfcc7df5493324f8, 0xbfe4da80701597b8,
    0xbff928415b8d406e, 0x40023e5c501b6265,
    0x3fe2f6042f6eef90, 0x3ff8862182043f2c,
    0x3fec3ca4fec1e5ea, 0xc0115c1e5385f1e8,
    0xc002a9cc37996826, 0xbfd07c7c64c44a50,
    0x3febabf3b18f012c, 0x3ff7df77a3e7fd23,
    0x3fe07d9020dd9095, 0xbf80ba3423210080,
    0xc0032b57ef2810a8, 0xbfc5a714f2a96594,
    0x400a6c81b232e68d, 0xbff82a351c51f603,
    0xbfc1b962bb2a8570, 0x3fef1f8c7001efb2,
    0xc00b4227b003ca22, 0xbfe3f5146e1b82ec,
    0x4006f2a8efced860, 0xc004e1b32b9743ce,
    0x4012d7ea92e4b155, 0xbffc63c8b91b7e60,
    0x400809cd4c5d7732, 0xbff88ebf753c42e2,
    0x3ff07fe94c50e5f0, 0xbfe9175e771b99dd,
    0xc0021c7c15679878, 0xbff16d0d4bc1c6b0,
    0xbffb1821ec4d047b, 0x4000749bcd3a2d80,
    0xbff737afe107f4d2, 0xc009daf0775320ee,
    0xc007f8ea2dbfca0b, 0x4012c4180d400f2a,
    0x3ff57193ad2e37dc, 0xbffd80354636e47e,
    0xbfefb90f7d624c3e, 0xbfe44425c7ea98c6,
    0xbf84cb78d93e7600, 0xbfdc84de3b94527c,
    0x400845f9fd556bc8, 0x3fee2e8b88cbfafc,
    0x400958242d4996e6, 0xbfe3b83a809c59f6,
    0xbff190c2be4a71c0, 0xbfeea1a2a609874a,
    0xc00557ef76a26de6, 0x400e7ce78d9fe955,
    0x40014a2382ef4bfb, 0x4000374d2f480751,
    0xbff29e63df104a50, 0xbfed32d70b612ab4,
    0x40123f695f4f30d5, 0x400b87e8a5913983,
    0xbfce60534b0a4848, 0xbfe870a869b85e2e,
    0x3fffffe62b62c121, 0x3ff395f631e588a2,
    0x3ff9708549126b3c, 0xbfbb39ab2f1788b0,
    0x3fe27f0a283831d2, 0xbfd818bfab35dafc,
    0x3feefe6a77742b3e, 0xc00ce2a166e27a54,
    0xbfe3a356961dd8ce, 0xc000c28d0792f1b2,
    0x400c4b6668104700, 0x400b33bb41877ed4,
    0x4008d0cf96d7c0f2, 0xbffd7ae45526ffe4,
    0x3ff0d794105ace78, 0x4001a83256a238d6,
    0x40091775926f5466, 0x3ff76e9092a55b8b,
    0x40124a0b5df3b8d6, 0xbfef52e67a7bea45,
    0xbfe8a5d4717c1d1c, 0xc00e18ef38f21e0a,
    0xc012123ac9e46ec4, 0xbfe70bc2232643f8,
    0x3fe43384d6d70421, 0x40112b7be63434e5,
    0x3fc60b5c1a867850, 0x400010cdf9af31e0,
    0xbfe2c4bc52a79ff6, 0xbff2297ea0979e7e,
    0xbffb82b506dea39a, 0xc00486fba854e980,
    0xc002da6c066e8c34, 0x3ff13c36dafe3e95,
    0x3fcf32a1a1af593a, 0x4001c27780d46104,
    0x3ff8ab0e0d91f3b0, 0x40106c32ce0c0b48,
    0xc0057a96a8e31ebc, 0x401a95f3011787e8,
    0x3ff8749a72d8bd7e, 0xc0145e664a17322a,
    0xc008f2e4ec8ce1c3, 0xc00b40bf3f6b2b66,
    0xc006765f0d462fce, 0x400c443013f32e28,
    0x400305176a8e8a4c, 0x400d591849c3167b,
    0xc00e30d159a3bf65, 0xbff3c5cb51535608,
    0xbff7465927f5777e, 0xc00f7adf88b967b9,
    0xbffd3f13230e5f41, 0xbfe70239541fa5e6,
    0xbfdd7e4f1e8a6cd0, 0x3ff8a08250b65c62,
    0xc0021bfb5c15d637, 0x4000f6f7f3671c0b,
    0xbfd246b887dbcc1e, 0x3feaec18bf9d9693,
    0x4014f052ced95b6e, 0x400320f12e6e6250,
    0xc003bd582aac168a, 0xc005254e457d3552,
    0xc0031fca2c61cf84, 0x3ff0e696de8e2312,
    0x4000889358fe6225, 0x4008845deadfc1b1,
    0x401307efd1a1fb26, 0x3ffffcd5841e79c5,
    0x400e0dd48adddafb, 0xbffa40213df2a12f,
    0x40099e5bd4243d2a, 0xc00aafe3b1187f89,
    0xbfe424d00bcf892e, 0x40058cc093250f11,
    0x40116af2458b780a, 0xbfef2b9c4141d713,
    0xbfd6f0bcc062f9b4, 0x4000ea59bb7e838a,
    0x4003c6da1e2c3cc4, 0x400e42a242c587e4,
    0xc0077162e3a8a092, 0x40127eafdfaa5638,
    0xbfd9652e99d016b2, 0x3ff9ec14705a2877,
    0xbfd09c2258953908, 0x401050dbc5fd7a13,
    0x3fd74b4e63ab76b8, 0xc00482bcdf828b1b,
    0xbfed63e7535b0b6e, 0xbffea5888cf8d0af,
    0x3ff5641440ed704a, 0xc0026c2507dcbf2e,
    0xc014bdfeaf31ec58, 0xc0037eabd73aec4c,
    0xc0001a852f8dfe06, 0xbfe9fca33803de5f,
    0xc00059c396389156, 0x3feebadfe450d6bc,
    0xc0121ff3b98f190d, 0x3fc8c53a07d99a74,
    0xbfeaff3fc5cf8db2, 0x4006c43bed7d4666,
    0xbfc2aa7a1f214778, 0x3ff1715351f6f74f,
    0xc0026c99aede8fa2, 0x4001783ac0c5f4b6,
    0xbffb60244d18e288, 0xc0098e5e81e8fac2,
    0x3feae9a6be6c2778, 0xc0009ea392c9490b,
    0x4006c8552eaaab1c, 0x3fdf889b5ce69b2c,
    0x40005021120036a2, 0xbfe1969ff2e67ff6,
    0x3ff9c2963bc1e249, 0x3fdc43acb03199fa,
    0xbfedd366657ff889, 0x3fffeb5d31fa991c,
    0xbfda2a6d3c5a9598, 0xbff3772107aa368a,
    0xbfeefea7c4bc58f0, 0x400041b37070b7c8,
    0xbff22c965a3f99fe, 0xbffb24c3fc2396a6,
    0x3ffe91ab47dbac22, 0x3ff3bf927c10baae,
    0x40172967e3697102, 0xbfdca130ac65a9a0,
    0xc003d0f6b5e0a2e2, 0xc000037c339fd621,
    0xbff6ee892037eb08, 0xbff146ae9535b3e4,
    0x3ffdf1f6df06c9ac, 0x3fd2bd45f5fe1c6b,
    0xc00843ded63269d7, 0x400cb248cfe78f57,
    0xbffa252ec08346aa, 0xbfcfb63716cec860,
    0x400a7cbdb96c247c, 0xbff8cc6950ab810e,
    0x400c2abb115405f0, 0x40160cfaff8c05df,
    0xc0048356c99334b7, 0x3ff89e776e95f2ab,
    0xbfb43fb7a2d06104, 0x401060a732c528f2,
    0x40035d6cd41e3880, 0x3ffc0e47a2d944c4,
    0x3ff8b6d7ae57de98, 0xbfe1cc0384e04612,
    0xc0006550f714c1f0, 0xc003445f1af7f128,
    0x3fe2c8deaa77864e, 0x3fd404f46d4cf3e8,
    0x3fd334cbf2b512de, 0xbff729d1c38d07af,
    0xc00716e27dd31437, 0x3ff330a6a2c44189,
    0x3ff5b68e6f06e67a, 0x3fc2e401ab364ff0,
    0xc00c55f94632094b, 0x3ff3f46f80f77bee,
    0x4003719cdd565f58, 0xc002904c4dd2ee20,
    0xbfc8f44bc113ce94, 0xbff52c0a21c48b3a,
    0xc008388f9e90668c, 0x40063af1088b44cc,
    0x40146bcc3ac1bc12, 0x3fd4aacb696338d4,
    0xbfb4ce1b6169cf68, 0x400b4fd44cacf7ba,
    0xbfe33fdd500dc471, 0xbfcaf3f11be69dd8,
    0x40012b190fccbf74, 0xc0103df2ca0d365e,
    0xbfbf7ad9e3fdbc50, 0x3fe5934ac29988bb,
    0x3ffba77275f00341, 0xbfe0e6d40165b978,
    0xbfbb40345cade198, 0x400285ae67bd0016,
    0xbfe9d46d2373e940, 0xbfa6ee04c472cdc0,
    0xbff7818743d89176, 0xbfe801be42364957,
    0x400c0b5a8636ce23, 0xbff5c11d4e1081ec,
    0x3fe773631cd60baa, 0x3fcd679afe241e18,
    0xbfc74c5f8a81171c, 0xbfff61341f4bdaa7,
    0xbfeea5a1f89055d6, 0xbff53ea1f7bf9df8,
    0xbfd5e7a01a9324e8, 0xbffee57a05d96f28,
    0x3ffae03a9c6bbbe3, 0xbff62516062bc432,
    0x3fe3d8c69c943b2e, 0x4007fa1974b1b3fe,
    0xc009ae6eb66f6734, 0x3feacd7210f618ad,
    0x3ff9041aff41e57a, 0xbff5028edffcb8fc,
    0xbff4f6a6be1a590f, 0x40105b466f8932f8,
    0x4008973707590ff5, 0xbfe02ea11d6f4634,
    0x3fef07abdef22add, 0xbff8883c954883ef,
    0x3fea1f833ec5be94, 0xbfc217bc2da0906c,
    0xc00ce314079aa5dd, 0xbfe2c2c394c75274,
    0x3ffdacc92fe6f1e8, 0x4002b9c6f42f81c6,
    0xc00bb92db9a5eca0, 0x401947296b1ff73a,
    0x3ff22e6e0965ce52, 0x40007b242fb2ffda,
    0xbff0ba13da78bd40, 0x400e3df55c3bba31,
    0x3fd14dbed74e6794, 0x3ffa6b4d8806026b,
    0x3fd234bb20c0c8fa, 0x4002b06ec1188d0c,
    0xc005a42e069a7240, 0xbfe96f14308b21d8,
    0x3feae8d525b77925, 0xc0079fb8c8ecf6f2,
    0xc00fd03ee8ab9a48, 0xbff192c976750ec2,
    0x3ffc74407bad6a0c, 0x400ad57cdff0d364,
    0x3fdcc51eb3766de6, 0xbfe64ca8a9c94924,
    0x3fe675589db0895c, 0x3ff537897c048794,
    0x3fe72628b0d7bd28, 0xbffe00fd964fd7dc,
    0xc0025b476ec324af, 0x3fe6ffcf44948913,
    0xc002086e2818eb1c, 0xbfec5bf23b1f3942,
    0xbffdbc611d107c10, 0x3ff052dabfad0d10,
    0x4004927f660b82cb, 0x400430244bddcd87,
    0xbfa44e9135dd8430, 0xbfc066c556b20c28,
    0xbff0b9db1e13f292, 0x3fdc258a71c0d227,
    0x3ff0a12fe888214a, 0xc002886b13ef9b54,
    0x3fee565c41581e1c, 0x40008c0e7d66609c,
    0xbfea16d0e43adb38, 0x3fd4354f3d1449e4,
    0xc0025f165b35bc7d, 0xc005eeea575d8572,
    0x3ff5779a77f52675, 0xc0051a5c57e0d35c,
    0x401333c231460930, 0xc00875c1c607604a,
    0x3ff708b69ad35899, 0xbfffacdfd90a053b,
    0xbfc1a84058aa4744, 0x3ff77577019fd9af,
    0xc00874a34d184ba2, 0x3feae4e06944a797,
    0xbfc4ff8e31ccebe0, 0x40012418fd738bf9,
    0x4004c724c899fb62, 0x4010f0537291d8af,
    0x3fb1f9a829c2a160, 0x3fffc0fb5776d908,
    0x3fe07c5851f88cef, 0xbfc19b0fa493614e,
    0x3ffa6dd59f15d4d8, 0xc0187e76819bf17a,
    0x3ffdbeb9f7d25e44, 0xbfd9d362a3d80de0,
    0xbfeadad75da286da, 0xbffcc8bee2a0f4b6,
    0x3fd70b16ec3fbf3c, 0xbff824e4f8aa0d1e,
    0x400142cf34a34904, 0xbfed2d103cc25c4c,
    0xc00db29ba1eb152c, 0xbfe4f3338db950a8,
    0xc0057b616ce61331, 0xc009fdde5c1c8232,
    0xc0053303fd3f09f8, 0x3fd9b0037e655742,
    0xbfeea55f6079b436, 0xbff605b201f002b7,
    0x3fe6416ffa84ff15, 0xc0144271e1832bac,
    0xc00786989b2e7b98, 0x3ff515871cdbb7b4,
    0x3ff03ca89610e337, 0x3fdc0a5f6d815ab8,
    0x0
    };

static const uint64_t in_rfft_step_32[32] = {
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd
    };

static const uint64_t in_rifft_step_32[33] = {
    0x402ccccccccccccd, 0x0,
    0xbfeccccccccccccf, 0x40224694b6d1e46c,
    0x0, 0x8000000000000000,
    0xbfeccccccccccccc, 0x4007bc3751b89a60,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ffaf0c4f1b61202,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff18be432937072,
    0x0, 0x8000000000000000,
    0xbfecccccccccccce, 0x3fe7a2b359cd577c,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fdec9aff9db9276,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd1790763398d10,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fb6b14264b87600,
    0x0
    };

static const uint64_t ref_rfft_step_32[33] = {
    0x402ccccccccccccd, 0x0,
    0xbfeccccccccccccf, 0x40224694b6d1e46c,
    0x0, 0x8000000000000000,
    0xbfeccccccccccccc, 0x4007bc3751b89a60,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ffaf0c4f1b61202,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff18be432937072,
    0x0, 0x8000000000000000,
    0xbfecccccccccccce, 0x3fe7a2b359cd577c,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fdec9aff9db9276,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd1790763398d10,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fb6b14264b87600,
    0x0
    };

static const uint64_t in_rfft_step_64[64] = {
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd
    };

static const uint64_t in_rifft_step_64[65] = {
    0x403ccccccccccccd, 0x0,
    0xbfecccccccccccd0, 0x403251e65569b234,
    0x0, 0x8000000000000000,
    0xbfeccccccccccccc, 0x401844ec2b5fac26,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x400cbe7785552990,
    0x0, 0x0,
    0xbfecccccccccccce, 0x40041f661e754927,
    0x0, 0x8000000000000000,
    0xbfecccccccccccce, 0x3ffe723ce98fc58c,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ff80663076302d2,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff36a88f5ef7ae6,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fefc6a199472fc0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fea1a5100191240,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe55c0a88a568bc,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe1431614ea732d,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fdb3e263f09b840,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fd49c0f5f0ec5a8,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fccdb2939f178e0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc1169b34e238d0,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fa6a33d2f9b8f00,
    0x0
    };

static const uint64_t ref_rfft_step_64[65] = {
    0x403ccccccccccccd, 0x0,
    0xbfecccccccccccd0, 0x403251e65569b234,
    0x0, 0x8000000000000000,
    0xbfeccccccccccccc, 0x401844ec2b5fac26,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x400cbe7785552990,
    0x0, 0x0,
    0xbfecccccccccccce, 0x40041f661e754927,
    0x0, 0x8000000000000000,
    0xbfecccccccccccce, 0x3ffe723ce98fc58c,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ff80663076302d2,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff36a88f5ef7ae6,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fefc6a199472fc0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fea1a5100191240,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe55c0a88a568bc,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe1431614ea732d,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fdb3e263f09b840,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fd49c0f5f0ec5a8,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fccdb2939f178e0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc1169b34e238d0,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fa6a33d2f9b8f00,
    0x0
    };

static const uint64_t in_rfft_step_128[128] = {
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd
    };

static const uint64_t in_rifft_step_128[129] = {
    0x404ccccccccccccd, 0x0,
    0xbfecccccccccccd1, 0x404254ba4d4dccca,
    0x0, 0x8000000000000000,
    0xbfeccccccccccccd, 0x402866e9c69d778b,
    0x0, 0x0,
    0xbfeccccccccccce0, 0x401d3022a95b27c7,
    0x0, 0x0,
    0xbfecccccccccccce, 0x4014bf4fc9bb14ba,
    0x0, 0x8000000000000000,
    0xbfecccccccccccce, 0x401008123832cdbd,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x400a04780e45d71c,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x4005cb722f4c178c,
    0x0, 0x0,
    0xbfecccccccccccca, 0x4002aa50fa649f4a,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x40003e314c63f4cb,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ffc9b9e74f4875e,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff96b67f3ac760c,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff6bd76358b76c2,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff472492bef49cd,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x3ff273af5fdf55b8,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff0b18fe45133ee,
    0x0, 0x0,
    0xbfecccccccccccd9, 0x3fee3fe4ddc206a4,
    0x0, 0x8000000000000000,
    0xbfecccccccccccc3, 0x3feb6b7d37ce94c4,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe8d7d22e314b74,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe679ca22c5eeff,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe44882f8cfcdf2,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe23cc62c0d3545,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe050a3bd8405bd,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fdcfe4fb13c7a88,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd9884662bb5d58,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fd638016e083b50,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd30749cae4e530,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fcfe1506e2d4498,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fc9de786d5d5ee0,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fc3fd3568b97250,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fbc6ac9017f8dc0,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fb0fecd9ee5b280,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3f969fbf20d4b400,
    0x0
    };

static const uint64_t ref_rfft_step_128[129] = {
    0x404ccccccccccccd, 0x0,
    0xbfecccccccccccd1, 0x404254ba4d4dccca,
    0x0, 0x8000000000000000,
    0xbfeccccccccccccd, 0x402866e9c69d778b,
    0x0, 0x0,
    0xbfeccccccccccce0, 0x401d3022a95b27c7,
    0x0, 0x0,
    0xbfecccccccccccce, 0x4014bf4fc9bb14ba,
    0x0, 0x8000000000000000,
    0xbfecccccccccccce, 0x401008123832cdbd,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x400a04780e45d71c,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x4005cb722f4c178c,
    0x0, 0x0,
    0xbfecccccccccccca, 0x4002aa50fa649f4a,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x40003e314c63f4cb,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ffc9b9e74f4875e,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff96b67f3ac760c,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff6bd76358b76c2,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff472492bef49cd,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x3ff273af5fdf55b8,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff0b18fe45133ee,
    0x0, 0x0,
    0xbfecccccccccccd9, 0x3fee3fe4ddc206a4,
    0x0, 0x8000000000000000,
    0xbfecccccccccccc3, 0x3feb6b7d37ce94c4,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe8d7d22e314b74,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe679ca22c5eeff,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe44882f8cfcdf2,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe23cc62c0d3545,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe050a3bd8405bd,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fdcfe4fb13c7a88,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd9884662bb5d58,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fd638016e083b50,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd30749cae4e530,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fcfe1506e2d4498,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fc9de786d5d5ee0,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fc3fd3568b97250,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fbc6ac9017f8dc0,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fb0fecd9ee5b280,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3f969fbf20d4b400,
    0x0
    };

static const uint64_t in_rfft_step_256[256] = {
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd
    };

static const uint64_t in_rifft_step_256[257] = {
    0x405ccccccccccccd, 0x0,
    0xbfecccccccccccd3, 0x4052556f444c538a,
    0x0, 0x8000000000000000,
    0xbfecccccccccccce, 0x40386f6639ecffb6,
    0x0, 0x0,
    0xbfecccccccccccf6, 0x402d4c71fd1460ac,
    0x0, 0x0,
    0xbfecccccccccccce, 0x4024e6fe4f285983,
    0x0, 0x8000000000000000,
    0xbfeccccccccccccf, 0x40203b2c44fd1a25,
    0x0, 0x0,
    0xbfecccccccccccc0, 0x401a81a322d4ff2a,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x40165fbb942eb8f3,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x401355e79ffbb100,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x4011014bfa560d27,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x400e5159adcb89eb,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x400b5137b880c650,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x4008d3fad768aefa,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x4006ba35789a9a04,
    0x0, 0x0,
    0xbfecccccccccccbd, 0x4004edc99aa463cc,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x40035eb2dfdfdf47,
    0x0, 0x0,
    0xbfecccccccccccea, 0x4002010ecbb5f913,
    0x0, 0x8000000000000000,
    0xbfecccccccccccb3, 0x4000cbdc2f4a60fd,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fff7050fec91ed9,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ffd8102fa1da66e,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ffbc1255464e0bb,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3ffa29bf2b66d23c,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ff8b5233638a612,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff75ea6114c1dfe,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3ff622675b951988,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3ff4fd2844722499,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff3ec2bd9ce6eae,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff2ed1e8317f1ff,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff1fe02d5773620,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff11d2270f55b1f,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff04901f171b530,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x3fef00ae7d26260e,
    0x0, 0x0,
    0xbfecccccccccccef, 0x3fed8403679a1b74,
    0x0, 0x0,
    0xbfecccccccccccaf, 0x3fec1a07758cd034,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3feac0fb156cb96e,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe97751a28386f0,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fe83baa2d8dfd16,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe70cc9743fbcd1,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe5e994cf1941b2,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe4d10de8b7f82d,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe3c24f1adc0de2,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe2bc88546ed5b8,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe1befc715bc174,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe0c8fef16940ab,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fdfb3e3fd6673de,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fdde2896e544b24,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fdc1ce35d5eddbe,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fda61fb425f4d94,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3fd8b0ec9b18b4d8,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fd708e2e6a7ae08,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd56917dc755ac8,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fd3d0d1d62870a0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd23f62655a81b8,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fd0b4250ee9c1c0,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fce5cfc4d450438,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fcb5bb38d7028d0,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fc86355be430b80,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fc572d4b2e236d0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fc2892c9c542ce0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fbf4ac523ca0380,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fb98d0665263400,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fb3d742b6a26480,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fac4f53b938e580,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fa0f8e69f105500,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3f869edfd0d80000,
    0x0
    };

static const uint64_t ref_rfft_step_256[257] = {
    0x405ccccccccccccd, 0x0,
    0xbfecccccccccccd3, 0x4052556f444c538a,
    0x0, 0x8000000000000000,
    0xbfecccccccccccce, 0x40386f6639ecffb6,
    0x0, 0x0,
    0xbfecccccccccccf6, 0x402d4c71fd1460ac,
    0x0, 0x0,
    0xbfecccccccccccce, 0x4024e6fe4f285983,
    0x0, 0x8000000000000000,
    0xbfeccccccccccccf, 0x40203b2c44fd1a25,
    0x0, 0x0,
    0xbfecccccccccccc0, 0x401a81a322d4ff2a,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x40165fbb942eb8f3,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x401355e79ffbb100,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x4011014bfa560d27,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x400e5159adcb89eb,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x400b5137b880c650,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x4008d3fad768aefa,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x4006ba35789a9a04,
    0x0, 0x0,
    0xbfecccccccccccbd, 0x4004edc99aa463cc,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x40035eb2dfdfdf47,
    0x0, 0x0,
    0xbfecccccccccccea, 0x4002010ecbb5f913,
    0x0, 0x8000000000000000,
    0xbfecccccccccccb3, 0x4000cbdc2f4a60fd,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fff7050fec91ed9,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ffd8102fa1da66e,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ffbc1255464e0bb,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3ffa29bf2b66d23c,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ff8b5233638a612,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff75ea6114c1dfe,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3ff622675b951988,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3ff4fd2844722499,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff3ec2bd9ce6eae,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff2ed1e8317f1ff,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff1fe02d5773620,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff11d2270f55b1f,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff04901f171b530,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x3fef00ae7d26260e,
    0x0, 0x0,
    0xbfecccccccccccef, 0x3fed8403679a1b74,
    0x0, 0x0,
    0xbfecccccccccccaf, 0x3fec1a07758cd034,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3feac0fb156cb96e,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe97751a28386f0,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fe83baa2d8dfd16,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe70cc9743fbcd1,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe5e994cf1941b2,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe4d10de8b7f82d,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe3c24f1adc0de2,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe2bc88546ed5b8,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe1befc715bc174,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe0c8fef16940ab,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fdfb3e3fd6673de,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fdde2896e544b24,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fdc1ce35d5eddbe,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fda61fb425f4d94,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3fd8b0ec9b18b4d8,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fd708e2e6a7ae08,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd56917dc755ac8,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fd3d0d1d62870a0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd23f62655a81b8,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fd0b4250ee9c1c0,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fce5cfc4d450438,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fcb5bb38d7028d0,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fc86355be430b80,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fc572d4b2e236d0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fc2892c9c542ce0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fbf4ac523ca0380,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fb98d0665263400,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fb3d742b6a26480,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fac4f53b938e580,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fa0f8e69f105500,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3f869edfd0d80000,
    0x0
    };

static const uint64_t in_rfft_step_512[512] = {
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd
    };

static const uint64_t in_rifft_step_512[513] = {
    0x406ccccccccccccd, 0x0,
    0xbfecccccccccccd9, 0x4062559c819c53b0,
    0x0, 0x8000000000000000,
    0xbfecccccccccccd0, 0x4048718527a1778f,
    0x0, 0x0,
    0xbfeccccccccccd21, 0x403d53841d299f94,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x4034f0e53fa19836,
    0x0, 0x8000000000000000,
    0xbfeccccccccccccf, 0x403047e8c9b183ef,
    0x0, 0x0,
    0xbfecccccccccccb6, 0x402aa0c94d1aa2aa,
    0x0, 0x0,
    0xbfecccccccccccca, 0x40268491490c1ed4,
    0x0, 0x0,
    0xbfecccccccccccb9, 0x4023806fbb4028f0,
    0x0, 0x0,
    0xbfecccccccccccde, 0x40213189cac93696,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x401ebd483ea04e07,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x401bc8a1a932b51c,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x401956e984ec49a8,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x401748b32fe05150,
    0x0, 0x0,
    0xbfecccccccccccb1, 0x401587e19bdecd0a,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x40140471621c330a,
    0x0, 0x0,
    0xbfeccccccccccd08, 0x4012b28100c9542e,
    0x0, 0x8000000000000000,
    0xbfeccccccccccc97, 0x4011891048168074,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x4010812db07702de,
    0x0, 0x0,
    0xbfecccccccccccd9, 0x400f2ad0073bcf47,
    0x0, 0x0,
    0xbfecccccccccccce, 0x400d82d7a2f6c007,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x400c037b797b57fe,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x400aa71075cc7f10,
    0x0, 0x0,
    0xbfecccccccccccce, 0x400968ed757ea68c,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x4008453466c2d153,
    0x0, 0x0,
    0xbfecccccccccccda, 0x400738a8d73f3de4,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x40064090432cec7a,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x40055a999155b142,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x400484c9e8613776,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x4003bd6d8d1eae96,
    0x0, 0x0,
    0xbfecccccccccccca, 0x4003030bd4ad8a02,
    0x0, 0x0,
    0xbfecccccccccccbf, 0x4002545d75b2a3da,
    0x0, 0x0,
    0xbfeccccccccccd13, 0x4001b044b1b37115,
    0x0, 0x0,
    0xbfeccccccccccc8a, 0x400115c6f0e5b665,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x40008407830b2570,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ffff48693c6e286,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3ffeef9a3e4b2e7b,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3ffdf815a412f9b8,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ffd0ce5402e49b3,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ffc2d1225a37294,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3ffb57be60bd7a21,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3ffa8c21e1a3194e,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff9c987d90e53ce,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ff90f4c745878c6,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff85cdae9836074,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff7b1abc6aabb0b,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x3ff70d437a7ea214,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3ff66f310d3159dc,
    0x0, 0x0,
    0xbfecccccccccccde, 0x3ff5d70d02b46478,
    0x0, 0x0,
    0xbfecccccccccccbd, 0x3ff54478604e88ac,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ff4b71bd08b1d58,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ff42ea6e14da3fe,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff3aacf587c0674,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3ff32b509c3c6a32,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff2afeb2c36d7ff,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3ff2386429ab36c7,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3ff1c484ec7cbfb8,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3ff1541aa397ddc6,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ff0e6f5ff509b7e,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ff07ceae4882558,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff015d02790f969,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fef62fe9bd8a589,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3fee9fa8ac326ed6,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x3fede15b098e369f,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fed27d66da7f07d,
    0x0, 0x8000000000000000,
    0xbfecccccccccccd7, 0x3fec72df6f21307d,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x3febc23e35ac2bff,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3feb15be350b5226,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fea6d2dee300c69,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe9c85eb5d865d2,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fe92724801dc9cf,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe88955b077208c,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe7eecaedbea024,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe7575ef9d7f9af,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fe6c2ee8c9e5926,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe6315831cb2de2,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe5a27c298f12a4,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe5163c4b9d8b30,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x3fe48c7bec72d75c,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe4051fc4a0dfe7,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3fe3800dd9f56350,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fe2fd2d6a501418,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe27c66d8036624,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fe1fda3979e666b,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe180ce1f012af2,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe105d1d5a04d09,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fe08c9b05de7037,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe01516cf6524b4,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fdf3e6634d10e58,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fde55bd1785b0fc,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fdd7010f3ade99e,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fdc8d41c4542004,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fdbad30bf4cf39e,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fdacfc042f4c594,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fd9f4d3c50d6e58,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fd91c4fc2a645cc,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3fd84619b0fa7258,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd77217ef331ad8,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fd6a031b8fc8694,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd5d04f19dea690,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fd50258e14a9bb4,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd4363897500ab0,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fd36bd871edfa14,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd2a3234af3ee5c,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fd1dc049668ca54,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd11668596dbe58,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd0523b21944470,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fcf1ed3f93d8fd8,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fcd9bc4e1485c28,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fcc1b24e91df4c0,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fca9cd0d1e28d90,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fc920a6224e6e38,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fc7a6831983eed0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc62e46a26b6370,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc4b7d0478a7870,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fc34300274d27c0,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fc1cfb6e8b6e970,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fc05dd5b07355d0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fbdda7c2c7bb2e0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fbafba435310700,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fb81ee83994b780,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fb5440da23bf840,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fb26ada6eb2f040,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3faf262a45a38000,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fa9790968d39400,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fa3cde0f27d6700,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3f9c488054fb9e00,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3f90f76da3bec800,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3f769ea800134000,
    0x0
    };

static const uint64_t ref_rfft_step_512[513] = {
    0x406ccccccccccccd, 0x0,
    0xbfecccccccccccd9, 0x4062559c819c53b0,
    0x0, 0x8000000000000000,
    0xbfecccccccccccd0, 0x4048718527a1778f,
    0x0, 0x0,
    0xbfeccccccccccd21, 0x403d53841d299f94,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x4034f0e53fa19836,
    0x0, 0x8000000000000000,
    0xbfeccccccccccccf, 0x403047e8c9b183ef,
    0x0, 0x0,
    0xbfecccccccccccb6, 0x402aa0c94d1aa2aa,
    0x0, 0x0,
    0xbfecccccccccccca, 0x40268491490c1ed4,
    0x0, 0x0,
    0xbfecccccccccccb9, 0x4023806fbb4028f0,
    0x0, 0x0,
    0xbfecccccccccccde, 0x40213189cac93696,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x401ebd483ea04e07,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x401bc8a1a932b51c,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x401956e984ec49a8,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x401748b32fe05150,
    0x0, 0x0,
    0xbfecccccccccccb1, 0x401587e19bdecd0a,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x40140471621c330a,
    0x0, 0x0,
    0xbfeccccccccccd08, 0x4012b28100c9542e,
    0x0, 0x8000000000000000,
    0xbfeccccccccccc97, 0x4011891048168074,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x4010812db07702de,
    0x0, 0x0,
    0xbfecccccccccccd9, 0x400f2ad0073bcf47,
    0x0, 0x0,
    0xbfecccccccccccce, 0x400d82d7a2f6c007,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x400c037b797b57fe,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x400aa71075cc7f10,
    0x0, 0x0,
    0xbfecccccccccccce, 0x400968ed757ea68c,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x4008453466c2d153,
    0x0, 0x0,
    0xbfecccccccccccda, 0x400738a8d73f3de4,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x40064090432cec7a,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x40055a999155b142,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x400484c9e8613776,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x4003bd6d8d1eae96,
    0x0, 0x0,
    0xbfecccccccccccca, 0x4003030bd4ad8a02,
    0x0, 0x0,
    0xbfecccccccccccbf, 0x4002545d75b2a3da,
    0x0, 0x0,
    0xbfeccccccccccd13, 0x4001b044b1b37115,
    0x0, 0x0,
    0xbfeccccccccccc8a, 0x400115c6f0e5b665,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x40008407830b2570,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ffff48693c6e286,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3ffeef9a3e4b2e7b,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3ffdf815a412f9b8,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ffd0ce5402e49b3,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ffc2d1225a37294,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3ffb57be60bd7a21,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3ffa8c21e1a3194e,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff9c987d90e53ce,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ff90f4c745878c6,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff85cdae9836074,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff7b1abc6aabb0b,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x3ff70d437a7ea214,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3ff66f310d3159dc,
    0x0, 0x0,
    0xbfecccccccccccde, 0x3ff5d70d02b46478,
    0x0, 0x0,
    0xbfecccccccccccbd, 0x3ff54478604e88ac,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ff4b71bd08b1d58,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ff42ea6e14da3fe,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff3aacf587c0674,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3ff32b509c3c6a32,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff2afeb2c36d7ff,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3ff2386429ab36c7,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3ff1c484ec7cbfb8,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3ff1541aa397ddc6,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ff0e6f5ff509b7e,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ff07ceae4882558,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff015d02790f969,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fef62fe9bd8a589,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3fee9fa8ac326ed6,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x3fede15b098e369f,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fed27d66da7f07d,
    0x0, 0x8000000000000000,
    0xbfecccccccccccd7, 0x3fec72df6f21307d,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x3febc23e35ac2bff,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3feb15be350b5226,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fea6d2dee300c69,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe9c85eb5d865d2,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fe92724801dc9cf,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe88955b077208c,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe7eecaedbea024,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe7575ef9d7f9af,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fe6c2ee8c9e5926,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe6315831cb2de2,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe5a27c298f12a4,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe5163c4b9d8b30,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x3fe48c7bec72d75c,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe4051fc4a0dfe7,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3fe3800dd9f56350,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fe2fd2d6a501418,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe27c66d8036624,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fe1fda3979e666b,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe180ce1f012af2,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe105d1d5a04d09,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fe08c9b05de7037,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe01516cf6524b4,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fdf3e6634d10e58,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fde55bd1785b0fc,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fdd7010f3ade99e,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fdc8d41c4542004,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fdbad30bf4cf39e,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fdacfc042f4c594,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fd9f4d3c50d6e58,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fd91c4fc2a645cc,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3fd84619b0fa7258,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd77217ef331ad8,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fd6a031b8fc8694,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd5d04f19dea690,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fd50258e14a9bb4,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd4363897500ab0,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fd36bd871edfa14,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd2a3234af3ee5c,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fd1dc049668ca54,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd11668596dbe58,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd0523b21944470,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fcf1ed3f93d8fd8,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fcd9bc4e1485c28,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fcc1b24e91df4c0,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fca9cd0d1e28d90,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fc920a6224e6e38,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fc7a6831983eed0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc62e46a26b6370,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc4b7d0478a7870,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fc34300274d27c0,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fc1cfb6e8b6e970,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fc05dd5b07355d0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fbdda7c2c7bb2e0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fbafba435310700,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fb81ee83994b780,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fb5440da23bf840,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fb26ada6eb2f040,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3faf262a45a38000,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fa9790968d39400,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fa3cde0f27d6700,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3f9c488054fb9e00,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3f90f76da3bec800,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3f769ea800134000,
    0x0
    };

static const uint64_t in_rfft_step_1024[1024] = {
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd
    };

static const uint64_t in_rifft_step_1024[1025] = {
    0x407ccccccccccccd, 0x0,
    0xbfeccccccccccce6, 0x407255a7d0e959bb,
    0x0, 0x8000000000000000,
    0xbfecccccccccccd4, 0x4058720ce01d00fe,
    0x0, 0x0,
    0xbfeccccccccccd79, 0x404d554889eb3cec,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x4044f35eb0e6f56e,
    0x0, 0x8000000000000000,
    0xbfecccccccccccd1, 0x40404b174bb2101e,
    0x0, 0x0,
    0xbfeccccccccccca0, 0x403aa89091ff4d36,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x40368dc2f54252f8,
    0x0, 0x0,
    0xbfeccccccccccca4, 0x40338b0bfc399931,
    0x0, 0x0,
    0xbfecccccccccccf2, 0x40313d90d4fed3cc,
    0x0, 0x0,
    0xbfecccccccccccbc, 0x402ed82c5c8c5f06,
    0x0, 0x0,
    0xbfeccccccccccce6, 0x402be65c55c7ebbb,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x4029777b537d1968,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x40276c1cc1f4c08f,
    0x0, 0x0,
    0xbfeccccccccccc9b, 0x4025ae23a14101b0,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x40242d8c98e61f80,
    0x0, 0x0,
    0xbfeccccccccccd44, 0x4022de76357386f0,
    0x0, 0x8000000000000000,
    0xbfeccccccccccc5f, 0x4021b7e0558818a8,
    0x0, 0x0,
    0xbfecccccccccccbd, 0x4020b2d98016ccb1,
    0x0, 0x0,
    0xbfecccccccccccec, 0x401f93e11ac94638,
    0x0, 0x0,
    0xbfecccccccccccce, 0x401df1a4380e6b0c,
    0x0, 0x0,
    0xbfecccccccccccdd, 0x401c7805bacda35e,
    0x0, 0x0,
    0xbfecccccccccccbe, 0x401b215aaba9a5fc,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x4019e8fa0604d6ae,
    0x0, 0x0,
    0xbfecccccccccccbc, 0x4018cb05d60ec634,
    0x0, 0x0,
    0xbfeccccccccccce4, 0x4017c441c79f5c7e,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x4016d1f37556e795,
    0x0, 0x0,
    0xbfecccccccccccce, 0x4015f1c9e49ebfda,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x401521ca5af8e6c5,
    0x0, 0x0,
    0xbfecccccccccccbe, 0x401460413c4c59d6,
    0x0, 0x0,
    0xbfecccccccccccca, 0x4013abb5fd1082a7,
    0x0, 0x0,
    0xbfecccccccccccb7, 0x401302e173851538,
    0x0, 0x0,
    0xbfeccccccccccd56, 0x401264a601100b48,
    0x0, 0x0,
    0xbfeccccccccccc47, 0x4011d0092e102c72,
    0x0, 0x0,
    0xbfeccccccccccce0, 0x4011442e6abb8bba,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x4010c052b994891d,
    0x0, 0x0,
    0xbfecccccccccccdb, 0x401043c9156615ff,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x400f9beedda0b93c,
    0x0, 0x0,
    0xbfecccccccccccca, 0x400ebca84a361c40,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x400de8c7c7c72a86,
    0x0, 0x0,
    0xbfecccccccccccc0, 0x400d1f6fa78f01b0,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x400c5fd81f669d38,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x400ba94ca68325a1,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x400afb29b188cdd4,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x400a54dabe9b13d3,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x4009b5d8a4d53aa4,
    0x0, 0x0,
    0xbfecccccccccccbd, 0x40091da81ccc303e,
    0x0, 0x0,
    0xbfecccccccccccd9, 0x40088bd87983cedd,
    0x0, 0x0,
    0xbfecccccccccccf0, 0x400800028ab39c96,
    0x0, 0x0,
    0xbfecccccccccccab, 0x400779c7a264ada8,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x4006f8d0b8e8fbc0,
    0x0, 0x0,
    0xbfecccccccccccdc, 0x40067ccdaaf73e7c,
    0x0, 0x0,
    0xbfecccccccccccce, 0x400605748e5d9b9c,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x400592811a48230d,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x400523b4208b5798,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x4004b8d315c34578,
    0x0, 0x0,
    0xbfecccccccccccc0, 0x400451a7a6684edd,
    0x0, 0x0,
    0xbfecccccccccccdd, 0x4003edff573ea31c,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x40038dab2fbe8598,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x4003307f6d43ed6e,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x4002d6533dfd190d,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x40027f0082b2a6f6,
    0x0, 0x0,
    0xbfecccccccccccbd, 0x40022a6396a19d48,
    0x0, 0x0,
    0xbfecccccccccccb4, 0x4001d85b1cb9558a,
    0x0, 0x0,
    0xbfecccccccccccbc, 0x400188c7d1a52f91,
    0x0, 0x8000000000000000,
    0xbfeccccccccccce2, 0x40013b8c621ccc44,
    0x0, 0x0,
    0xbfeccccccccccce4, 0x4000f08d4505d71c,
    0x0, 0x0,
    0xbfecccccccccccd7, 0x4000a7b0990077ac,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x400060de0503b6db,
    0x0, 0x0,
    0xbfecccccccccccca, 0x40001bfe9bb9baea,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3fffb1f982a9ed58,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fff2f88273ee5b7,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3ffeb082a818c2f7,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3ffe34c4a734a66c,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3ffdbc2bc0b39d65,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ffd469768e19377,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ffcd3e8ccef68ea,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ffc6402b620ee2d,
    0x0, 0x0,
    0xbfecccccccccccba, 0x3ffbf6c96f360ebb,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ffb8c22abdc3b9a,
    0x0, 0x0,
    0xbfeccccccccccce1, 0x3ffb23f571fa46e0,
    0x0, 0x0,
    0xbfecccccccccccbb, 0x3ffabe2a04ad6ee9,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3ffa5aa9d0d26390,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff9f95f5af8adb4,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff99a362ea21643,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff93d1aceb28cde,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3ff8e1faa6f7a03a,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff888c3feb0e7aa,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff83165ec04d02f,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3ff7dbd0484f1a29,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff787f3a5380128,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff735c14284881f,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ff6e52b0491c03a,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff696236b6e19bc,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x3ff6489d8a84e9f8,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff5fc8d00d151ec,
    0x0, 0x0,
    0xbfecccccccccccf0, 0x3ff5b1e5f18e987e,
    0x0, 0x0,
    0xbfecccccccccccaf, 0x3ff5689cfd5ce042,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3ff520a73bd1db08,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff4d9fa356dd34c,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3ff4948bddedf6b4,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ff450528ef56780,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3ff40d4503071618,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff3cb5a50cadf58,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff38a89e698d807,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff34acb86461215,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff30c17412e839a,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ff2ce6574780a48,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff291aec58ad3fa,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff255ec1ebbb9c1,
    0x0, 0x0,
    0xbfecccccccccccc1, 0x3ff21b16ac255c78,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ff1e127d8ad0c30,
    0x0, 0x0,
    0xbfecccccccccccdb, 0x3ff1a8194b30ba98,
    0x0, 0x0,
    0xbfecccccccccccbc, 0x3ff16fe4e3db6ae4,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ff13884b99dbe9d,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff101f317c86b54,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff0cc2a7bc6899e,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff0972592f5d444,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ff062df389b0ee1,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff02f5273f0e9c0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3feff8f4ec9fabd6,
    0x0, 0x0,
    0xbfecccccccccccd7, 0x3fef94a532daace5,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fef31acbb62e84f,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3feed002d14220c8,
    0x0, 0x0,
    0xbfecccccccccccbf, 0x3fee6f9f06b7ceaa,
    0x0, 0x0,
    0xbfecccccccccccdf, 0x3fee1079325a4d86,
    0x0, 0x0,
    0xbfecccccccccccbb, 0x3fedb2896c5b1f9c,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fed55c80bec565e,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fecfa2da4c54c40,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fec9fb304c4ff40,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fec465131b069de,
    0x0, 0x0,
    0xbfecccccccccccdb, 0x3febee01670b65bc,
    0x0, 0x0,
    0xbfecccccccccccbf, 0x3feb96bd140aa0a6,
    0x0, 0x0,
    0xbfecccccccccccdf, 0x3feb407dd99d5c2a,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3feaeb3d888db0c8,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fea96f61fb62c3f,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fea43a1ca4baed5,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe9f13ade3a7df6,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe99fbbda9591c1,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fe94f1f6617310a,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe8ff604db1fda0,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe8b07983319e84,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3fe862661bea42c8,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fe815214f764102,
    0x0, 0x0,
    0xbfecccccccccccdc, 0x3fe7c8a676812410,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x3fe77cf1099f7dc8,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe731fca032e144,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe6e7c4ef597229,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe69e45c8e87922,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fe6557b1a7179e1,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fe60d60ec514ca5,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe5c5f360c8c2c4,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fe57f2eb31e65d2,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fe5390f36c8e5ba,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe4f39156a1d055,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe4aeb19420321c,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe46a6c869ac44f,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe426beda9151b4,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe3e3a550fd0008,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3fe3a11cbea72f7d,
    0x0, 0x0,
    0xbfeccccccccccce7, 0x3fe35f220b86a5ad,
    0x0, 0x0,
    0xbfecccccccccccb8, 0x3fe31db23222bea5,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fe2dcca3efc5e0c,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe29c674ffc6597,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fe25c8693e76de5,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe21d2549d68cd7,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe1de40c0b4f03a,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fe19fd656c218b1,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe161e379188356,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe12465a3389206,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe0e75a5e9785ec,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe0aabf42326007,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe06e91f2247fa9,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe032d01f41d6a2,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3fdfeeef0d691d22,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fdf790be33bf5b0,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3fdf03f269756b44,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3fde8f9e60138e40,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fde1c0b9ced6eca,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fdda9360b0cdd7c,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fdd3719aa0d8bf4,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fdcc5b28d815918,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fdc54fcdc599654,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fdbe4f4d05510fc,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fdb7596b572b2f2,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fdb06dee9688b4c,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fda98c9db1f14ac,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fda2b540a308e22,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fd9be7a066c4008,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fd952386f5d8532,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fd8e68bf3d674cc,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fd87b71517e08e6,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd810e55461a02e,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fd7a6e4d689ba96,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fd73d6cbf91d1d6,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd6d47a04432ee4,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fd66c09a632a18e,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd60418b360fd20,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd59ca445de40b4,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd535a9836f50d0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd4cf259d362ab4,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd46915cf5c7928,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd4037760c07588,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fd39e47a2a3fcc4,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fd33983f05dc6d8,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fd2d529af0ca944,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x3fd271364d4cd3f0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd20da742eef344,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fd1aa7a10b127e4,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd147ac3ff9c0f0,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd0e53b6293a808,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fd08325126c7154,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd02166f153fcc4,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fcf7ffd517b35f0,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fcebdd3d30550e0,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fcdfc4cd74d1d30,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fcd3b63dc383ea8,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fcc7b146d1878f8,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fcbbb5a223b7f20,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fcafc30a07d28c8,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fca3d9398dbf840,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fc97f7ec80fd828,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fc8c1edf622fb40,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fc804dcf60cc940,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fc74847a54ec1a0,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fc68c29eb934660,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fc5d07fba4e2bc0,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fc515450c5f14a0,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fc45a75e5b56810,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fc3a00e52f5e9e0,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fc2e60a6921d310,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fc22c66453f6360,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fc1731e0c03d350,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fc0ba2de97e9c30,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fc0019210c60440,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fbe928d7749bae0,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fbd22905492d800,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fbbb32545eac160,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fba4444e35dbc20,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fb8d5e7cfe4e980,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fb76806b8cc1a00,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fb5fa9a551960c0,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fb48d9b64f63b00,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fb32102b11a5300,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fb1b4c90a379f80,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fb048e74867dfc0,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fadbaac95369f00,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3faae41dec10fe80,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fa80e146b3a6b00,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fa53881f2e08200,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fa263586c684900,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3f9f1d1392aa2e00,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3f99741004617400,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3f93cb8a2ae9c000,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3f8c46cc19d58000,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3f80f70f712dd000,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3f669e9a0c160000,
    0x0
    };

static const uint64_t ref_rfft_step_1024[1025] = {
    0x407ccccccccccccd, 0x0,
    0xbfeccccccccccce6, 0x407255a7d0e959bb,
    0x0, 0x8000000000000000,
    0xbfecccccccccccd4, 0x4058720ce01d00fe,
    0x0, 0x0,
    0xbfeccccccccccd79, 0x404d554889eb3cec,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x4044f35eb0e6f56e,
    0x0, 0x8000000000000000,
    0xbfecccccccccccd1, 0x40404b174bb2101e,
    0x0, 0x0,
    0xbfeccccccccccca0, 0x403aa89091ff4d36,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x40368dc2f54252f8,
    0x0, 0x0,
    0xbfeccccccccccca4, 0x40338b0bfc399931,
    0x0, 0x0,
    0xbfecccccccccccf2, 0x40313d90d4fed3cc,
    0x0, 0x0,
    0xbfecccccccccccbc, 0x402ed82c5c8c5f06,
    0x0, 0x0,
    0xbfeccccccccccce6, 0x402be65c55c7ebbb,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x4029777b537d1968,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x40276c1cc1f4c08f,
    0x0, 0x0,
    0xbfeccccccccccc9b, 0x4025ae23a14101b0,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x40242d8c98e61f80,
    0x0, 0x0,
    0xbfeccccccccccd44, 0x4022de76357386f0,
    0x0, 0x8000000000000000,
    0xbfeccccccccccc5f, 0x4021b7e0558818a8,
    0x0, 0x0,
    0xbfecccccccccccbd, 0x4020b2d98016ccb1,
    0x0, 0x0,
    0xbfecccccccccccec, 0x401f93e11ac94638,
    0x0, 0x0,
    0xbfecccccccccccce, 0x401df1a4380e6b0c,
    0x0, 0x0,
    0xbfecccccccccccdd, 0x401c7805bacda35e,
    0x0, 0x0,
    0xbfecccccccccccbe, 0x401b215aaba9a5fc,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x4019e8fa0604d6ae,
    0x0, 0x0,
    0xbfecccccccccccbc, 0x4018cb05d60ec634,
    0x0, 0x0,
    0xbfeccccccccccce4, 0x4017c441c79f5c7e,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x4016d1f37556e795,
    0x0, 0x0,
    0xbfecccccccccccce, 0x4015f1c9e49ebfda,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x401521ca5af8e6c5,
    0x0, 0x0,
    0xbfecccccccccccbe, 0x401460413c4c59d6,
    0x0, 0x0,
    0xbfecccccccccccca, 0x4013abb5fd1082a7,
    0x0, 0x0,
    0xbfecccccccccccb7, 0x401302e173851538,
    0x0, 0x0,
    0xbfeccccccccccd56, 0x401264a601100b48,
    0x0, 0x0,
    0xbfeccccccccccc47, 0x4011d0092e102c72,
    0x0, 0x0,
    0xbfeccccccccccce0, 0x4011442e6abb8bba,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x4010c052b994891d,
    0x0, 0x0,
    0xbfecccccccccccdb, 0x401043c9156615ff,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x400f9beedda0b93c,
    0x0, 0x0,
    0xbfecccccccccccca, 0x400ebca84a361c40,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x400de8c7c7c72a86,
    0x0, 0x0,
    0xbfecccccccccccc0, 0x400d1f6fa78f01b0,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x400c5fd81f669d38,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x400ba94ca68325a1,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x400afb29b188cdd4,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x400a54dabe9b13d3,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x4009b5d8a4d53aa4,
    0x0, 0x0,
    0xbfecccccccccccbd, 0x40091da81ccc303e,
    0x0, 0x0,
    0xbfecccccccccccd9, 0x40088bd87983cedd,
    0x0, 0x0,
    0xbfecccccccccccf0, 0x400800028ab39c96,
    0x0, 0x0,
    0xbfecccccccccccab, 0x400779c7a264ada8,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x4006f8d0b8e8fbc0,
    0x0, 0x0,
    0xbfecccccccccccdc, 0x40067ccdaaf73e7c,
    0x0, 0x0,
    0xbfecccccccccccce, 0x400605748e5d9b9c,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x400592811a48230d,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x400523b4208b5798,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x4004b8d315c34578,
    0x0, 0x0,
    0xbfecccccccccccc0, 0x400451a7a6684edd,
    0x0, 0x0,
    0xbfecccccccccccdd, 0x4003edff573ea31c,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x40038dab2fbe8598,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x4003307f6d43ed6e,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x4002d6533dfd190d,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x40027f0082b2a6f6,
    0x0, 0x0,
    0xbfecccccccccccbd, 0x40022a6396a19d48,
    0x0, 0x0,
    0xbfecccccccccccb4, 0x4001d85b1cb9558a,
    0x0, 0x0,
    0xbfecccccccccccbc, 0x400188c7d1a52f91,
    0x0, 0x8000000000000000,
    0xbfeccccccccccce2, 0x40013b8c621ccc44,
    0x0, 0x0,
    0xbfeccccccccccce4, 0x4000f08d4505d71c,
    0x0, 0x0,
    0xbfecccccccccccd7, 0x4000a7b0990077ac,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x400060de0503b6db,
    0x0, 0x0,
    0xbfecccccccccccca, 0x40001bfe9bb9baea,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3fffb1f982a9ed58,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fff2f88273ee5b7,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3ffeb082a818c2f7,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3ffe34c4a734a66c,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3ffdbc2bc0b39d65,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ffd469768e19377,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ffcd3e8ccef68ea,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ffc6402b620ee2d,
    0x0, 0x0,
    0xbfecccccccccccba, 0x3ffbf6c96f360ebb,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ffb8c22abdc3b9a,
    0x0, 0x0,
    0xbfeccccccccccce1, 0x3ffb23f571fa46e0,
    0x0, 0x0,
    0xbfecccccccccccbb, 0x3ffabe2a04ad6ee9,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3ffa5aa9d0d26390,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff9f95f5af8adb4,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff99a362ea21643,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff93d1aceb28cde,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3ff8e1faa6f7a03a,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff888c3feb0e7aa,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff83165ec04d02f,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3ff7dbd0484f1a29,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff787f3a5380128,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff735c14284881f,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ff6e52b0491c03a,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff696236b6e19bc,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x3ff6489d8a84e9f8,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff5fc8d00d151ec,
    0x0, 0x0,
    0xbfecccccccccccf0, 0x3ff5b1e5f18e987e,
    0x0, 0x0,
    0xbfecccccccccccaf, 0x3ff5689cfd5ce042,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3ff520a73bd1db08,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff4d9fa356dd34c,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3ff4948bddedf6b4,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ff450528ef56780,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3ff40d4503071618,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff3cb5a50cadf58,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff38a89e698d807,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff34acb86461215,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff30c17412e839a,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ff2ce6574780a48,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff291aec58ad3fa,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff255ec1ebbb9c1,
    0x0, 0x0,
    0xbfecccccccccccc1, 0x3ff21b16ac255c78,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ff1e127d8ad0c30,
    0x0, 0x0,
    0xbfecccccccccccdb, 0x3ff1a8194b30ba98,
    0x0, 0x0,
    0xbfecccccccccccbc, 0x3ff16fe4e3db6ae4,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ff13884b99dbe9d,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff101f317c86b54,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff0cc2a7bc6899e,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff0972592f5d444,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ff062df389b0ee1,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff02f5273f0e9c0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3feff8f4ec9fabd6,
    0x0, 0x0,
    0xbfecccccccccccd7, 0x3fef94a532daace5,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fef31acbb62e84f,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3feed002d14220c8,
    0x0, 0x0,
    0xbfecccccccccccbf, 0x3fee6f9f06b7ceaa,
    0x0, 0x0,
    0xbfecccccccccccdf, 0x3fee1079325a4d86,
    0x0, 0x0,
    0xbfecccccccccccbb, 0x3fedb2896c5b1f9c,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fed55c80bec565e,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fecfa2da4c54c40,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fec9fb304c4ff40,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fec465131b069de,
    0x0, 0x0,
    0xbfecccccccccccdb, 0x3febee01670b65bc,
    0x0, 0x0,
    0xbfecccccccccccbf, 0x3feb96bd140aa0a6,
    0x0, 0x0,
    0xbfecccccccccccdf, 0x3feb407dd99d5c2a,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3feaeb3d888db0c8,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fea96f61fb62c3f,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fea43a1ca4baed5,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe9f13ade3a7df6,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe99fbbda9591c1,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fe94f1f6617310a,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe8ff604db1fda0,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe8b07983319e84,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3fe862661bea42c8,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fe815214f764102,
    0x0, 0x0,
    0xbfecccccccccccdc, 0x3fe7c8a676812410,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x3fe77cf1099f7dc8,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe731fca032e144,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe6e7c4ef597229,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe69e45c8e87922,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fe6557b1a7179e1,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fe60d60ec514ca5,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe5c5f360c8c2c4,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fe57f2eb31e65d2,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fe5390f36c8e5ba,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe4f39156a1d055,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe4aeb19420321c,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe46a6c869ac44f,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe426beda9151b4,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe3e3a550fd0008,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3fe3a11cbea72f7d,
    0x0, 0x0,
    0xbfeccccccccccce7, 0x3fe35f220b86a5ad,
    0x0, 0x0,
    0xbfecccccccccccb8, 0x3fe31db23222bea5,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fe2dcca3efc5e0c,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe29c674ffc6597,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fe25c8693e76de5,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe21d2549d68cd7,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe1de40c0b4f03a,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fe19fd656c218b1,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe161e379188356,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe12465a3389206,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe0e75a5e9785ec,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe0aabf42326007,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe06e91f2247fa9,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe032d01f41d6a2,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3fdfeeef0d691d22,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fdf790be33bf5b0,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3fdf03f269756b44,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3fde8f9e60138e40,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fde1c0b9ced6eca,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fdda9360b0cdd7c,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fdd3719aa0d8bf4,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fdcc5b28d815918,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fdc54fcdc599654,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fdbe4f4d05510fc,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fdb7596b572b2f2,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fdb06dee9688b4c,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fda98c9db1f14ac,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fda2b540a308e22,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fd9be7a066c4008,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fd952386f5d8532,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fd8e68bf3d674cc,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fd87b71517e08e6,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd810e55461a02e,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fd7a6e4d689ba96,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fd73d6cbf91d1d6,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd6d47a04432ee4,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fd66c09a632a18e,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd60418b360fd20,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd59ca445de40b4,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd535a9836f50d0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd4cf259d362ab4,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd46915cf5c7928,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd4037760c07588,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fd39e47a2a3fcc4,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fd33983f05dc6d8,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fd2d529af0ca944,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x3fd271364d4cd3f0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd20da742eef344,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fd1aa7a10b127e4,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd147ac3ff9c0f0,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd0e53b6293a808,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fd08325126c7154,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd02166f153fcc4,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fcf7ffd517b35f0,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fcebdd3d30550e0,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fcdfc4cd74d1d30,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fcd3b63dc383ea8,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fcc7b146d1878f8,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fcbbb5a223b7f20,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fcafc30a07d28c8,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fca3d9398dbf840,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fc97f7ec80fd828,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fc8c1edf622fb40,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fc804dcf60cc940,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fc74847a54ec1a0,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fc68c29eb934660,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fc5d07fba4e2bc0,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fc515450c5f14a0,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fc45a75e5b56810,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fc3a00e52f5e9e0,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fc2e60a6921d310,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fc22c66453f6360,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fc1731e0c03d350,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fc0ba2de97e9c30,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fc0019210c60440,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fbe928d7749bae0,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fbd22905492d800,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fbbb32545eac160,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fba4444e35dbc20,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fb8d5e7cfe4e980,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fb76806b8cc1a00,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fb5fa9a551960c0,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fb48d9b64f63b00,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fb32102b11a5300,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fb1b4c90a379f80,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fb048e74867dfc0,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fadbaac95369f00,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3faae41dec10fe80,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fa80e146b3a6b00,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fa53881f2e08200,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fa263586c684900,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3f9f1d1392aa2e00,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3f99741004617400,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3f93cb8a2ae9c000,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3f8c46cc19d58000,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3f80f70f712dd000,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3f669e9a0c160000,
    0x0
    };

static const uint64_t in_rfft_step_2048[2048] = {
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd
    };

static const uint64_t in_rifft_step_2048[2049] = {
    0x408ccccccccccccd, 0x0,
    0xbfeccccccccccd00, 0x408255aaa4bc2b9e,
    0x0, 0x8000000000000000,
    0xbfecccccccccccda, 0x4068722ece0ccb9a,
    0x0, 0x0,
    0xbfecccccccccce28, 0x405d55b9a3679087,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x4054f3fd088b91af,
    0x0, 0x8000000000000000,
    0xbfecccccccccccd2, 0x40504be2e24253f2,
    0x0, 0x0,
    0xbfeccccccccccc75, 0x404aaa823eed92bd,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x4046900f24647fa6,
    0x0, 0x0,
    0xbfeccccccccccc7a, 0x40438db2b0659cb6,
    0x0, 0x0,
    0xbfeccccccccccd18, 0x40414092117a723e,
    0x0, 0x0,
    0xbfecccccccccccab, 0x403edee3ed8e2317,
    0x0, 0x0,
    0xbfecccccccccccff, 0x403bedc9071f7613,
    0x0, 0x0,
    0xbfecccccccccccba, 0x40397f9d2e55bfe7,
    0x0, 0x0,
    0xbfecccccccccccda, 0x403774f3d05a1d2c,
    0x0, 0x0,
    0xbfeccccccccccc6d, 0x4035b7afee1f2421,
    0x0, 0x0,
    0xbfecccccccccccdf, 0x403437ce3009c342,
    0x0, 0x0,
    0xbfeccccccccccdbb, 0x4032e96d238a4da9,
    0x0, 0x8000000000000000,
    0xbfeccccccccccbf1, 0x4031c38ca820c8e2,
    0x0, 0x0,
    0xbfecccccccccccaf, 0x4030bf3b45a19504,
    0x0, 0x0,
    0xbfeccccccccccd11, 0x402fae0faa66c35a,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x402e0d3dec9b87f2,
    0x0, 0x0,
    0xbfeccccccccccced, 0x402c950ab676ab00,
    0x0, 0x0,
    0xbfecccccccccccb0, 0x402b3fcb12602487,
    0x0, 0x0,
    0xbfecccccccccccd9, 0x402a08d5fd804bfc,
    0x0, 0x0,
    0xbfecccccccccccad, 0x4028ec4d85cd611c,
    0x0, 0x0,
    0xbfecccccccccccf8, 0x4027e6f558e6bf26,
    0x0, 0x0,
    0xbfecccccccccccde, 0x4026f6131334f4b2,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x40261755bbea70f8,
    0x0, 0x0,
    0xbfecccccccccccd9, 0x402548c29a532b98,
    0x0, 0x0,
    0xbfecccccccccccaf, 0x402488a6142100a0,
    0x0, 0x0,
    0xbfecccccccccccca, 0x4023d5879f9729bf,
    0x0, 0x0,
    0xbfeccccccccccca8, 0x40232e2014c225b4,
    0x0, 0x0,
    0xbfeccccccccccdd9, 0x40229151d6d5bcdf,
    0x0, 0x0,
    0xbfeccccccccccbc4, 0x4021fe226fff928e,
    0x0, 0x0,
    0xbfecccccccccccf1, 0x402173b55245abf2,
    0x0, 0x0,
    0xbfecccccccccccde, 0x4020f14781fb7ad7,
    0x0, 0x0,
    0xbfeccccccccccce4, 0x4020762bfbbe2b9a,
    0x0, 0x0,
    0xbfecccccccccccdc, 0x402001c8b20155ef,
    0x0, 0x0,
    0xbfecccccccccccca, 0x401f27280bc2a8ef,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x401e562549a301df,
    0x0, 0x0,
    0xbfecccccccccccb2, 0x401d8fab728d5087,
    0x0, 0x0,
    0xbfeccccccccccce5, 0x401cd2f2c00bbe12,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x401c1f46ad07658f,
    0x0, 0x0,
    0xbfeccccccccccce0, 0x401b7403b1db44d2,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x401ad095506490c7,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x401a3474637b4313,
    0x0, 0x0,
    0xbfecccccccccccb3, 0x40199f25a77413ea,
    0x0, 0x0,
    0xbfeccccccccccce6, 0x401910387315cf60,
    0x0, 0x0,
    0xbfeccccccccccd15, 0x4018874599de291c,
    0x0, 0x0,
    0xbfeccccccccccc88, 0x401803ee719fb2f0,
    0x0, 0x0,
    0xbfecccccccccccba, 0x401785dbf6794895,
    0x0, 0x0,
    0xbfecccccccccccf3, 0x40170cbe08f1fca6,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x4016984ac2abdd94,
    0x0, 0x0,
    0xbfecccccccccccde, 0x4016283ddeaa8694,
    0x0, 0x0,
    0xbfecccccccccccca, 0x4015bc58329dbd42,
    0x0, 0x0,
    0xbfecccccccccccdf, 0x4015545f37009d72,
    0x0, 0x0,
    0xbfecccccccccccb4, 0x4014f01c9c2e7b02,
    0x0, 0x0,
    0xbfecccccccccccec, 0x40148f5dead26e95,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x401431f42e4fb21e,
    0x0, 0x0,
    0xbfecccccccccccdc, 0x4013d7b3a7f15676,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x4013807389d8ecf2,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x40132c0db8c6b661,
    0x0, 0x0,
    0xbfecccccccccccaf, 0x4012da5e93f3c100,
    0x0, 0x0,
    0xbfeccccccccccc9a, 0x40128b44c24feae0,
    0x0, 0x0,
    0xbfeccccccccccca8, 0x40123ea1048bab95,
    0x0, 0x8000000000000000,
    0xbfecccccccccccf8, 0x4011f4560b6865fe,
    0x0, 0x0,
    0xbfecccccccccccff, 0x4011ac4851da48ee,
    0x0, 0x0,
    0xbfeccccccccccce7, 0x4011665dfa94d834,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x4011227eb0a76964,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x4010e0938ad977c0,
    0x0, 0x0,
    0xbfecccccccccccbf, 0x4010a086f17feb7c,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x40106244868c7b67,
    0x0, 0x0,
    0xbfecccccccccccbb, 0x401025b90f9f58d1,
    0x0, 0x0,
    0xbfecccccccccccdb, 0x400fd5a4c3d2fb6a,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x400f62fe9f66ba16,
    0x0, 0x0,
    0xbfecccccccccccca, 0x400ef35f2ec0ea7a,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x400e86a7a798e9ae,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x400e1cbadbc4a426,
    0x0, 0x0,
    0xbfecccccccccccad, 0x400db57d1ea1f498,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x400d50d42c88432e,
    0x0, 0x0,
    0xbfecccccccccccfa, 0x400ceea714149626,
    0x0, 0x0,
    0xbfeccccccccccca5, 0x400c8ede2126d2c4,
    0x0, 0x0,
    0xbfecccccccccccbe, 0x400c3162c96af8f6,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x400bd61f9a4cc192,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x400b7d0028373cf3,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x400b25f0ff04f1b8,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x400ad0df93878dca,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x400a7dba3610894e,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x400a2c7005e62d9e,
    0x0, 0x0,
    0xbfecccccccccccde, 0x4009dcf0e5924dac,
    0x0, 0x0,
    0xbfecccccccccccca, 0x40098f2d6ff9a913,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x40094316ee2c7458,
    0x0, 0x0,
    0xbfecccccccccccca, 0x4008f89f4de1dc5b,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x4008afb9189194a6,
    0x0, 0x0,
    0xbfecccccccccccbf, 0x400868576b1f9b7c,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x4008226dee0f5f4e,
    0x0, 0x0,
    0xbfeccccccccccd21, 0x4007ddf0ce345894,
    0x0, 0x0,
    0xbfeccccccccccc81, 0x40079ad4b5d6ffcd,
    0x0, 0x0,
    0xbfecccccccccccce, 0x4007590ec645c28e,
    0x0, 0x0,
    0xbfecccccccccccca, 0x4007189491ca4e60,
    0x0, 0x0,
    0xbfecccccccccccd7, 0x4006d95c15fc1e5f,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x40069b5bb669d00e,
    0x0, 0x0,
    0xbfecccccccccccc1, 0x40065e8a3793415b,
    0x0, 0x0,
    0xbfecccccccccccca, 0x400622deba2ef42a,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x4005e850b6b59fec,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x4005aed7f92f3de6,
    0x0, 0x0,
    0xbfecccccccccccce, 0x4005766c9d3d3821,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x40053f070a5db5b0,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x4005089ff0644d0e,
    0x0, 0x0,
    0xbfecccccccccccce, 0x4004d3304424a9f0,
    0x0, 0x0,
    0xbfecccccccccccba, 0x40049eb13c4bf587,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x40046b1c4e660ab9,
    0x0, 0x0,
    0xbfecccccccccccee, 0x4004386b2c0bb634,
    0x0, 0x0,
    0xbfeccccccccccca9, 0x40040697c037751a,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x4003d59c2cbe51cc,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x4003a572c7eaaa48,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x400376161a36d14b,
    0x0, 0x0,
    0xbfecccccccccccce, 0x40034780dc25a09a,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x400319adf43733d0,
    0x0, 0x0,
    0xbfecccccccccccce, 0x4002ec9874f821b6,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x4002c03b9b29a6d5,
    0x0, 0x0,
    0xbfecccccccccccdc, 0x40029492cc014e94,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x40026999937ebfeb,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x40023f4ba2d66a7b,
    0x0, 0x0,
    0xbfecccccccccccb3, 0x400215a4ceefe450,
    0x0, 0x0,
    0xbfeccccccccccce9, 0x4001eca10ef6dd94,
    0x0, 0x0,
    0xbfecccccccccccb7, 0x4001c43c7afda045,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x40019c734ab02438,
    0x0, 0x0,
    0xbfeccccccccccceb, 0x40017541d416cca4,
    0x0, 0x0,
    0xbfecccccccccccb2, 0x40014ea48a67f7ba,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x40012897fce78efa,
    0x0, 0x0,
    0xbfecccccccccccdf, 0x40010318d5d3dd67,
    0x0, 0x0,
    0xbfecccccccccccb6, 0x4000de23d95ef0d8,
    0x0, 0x0,
    0xbfeccccccccccced, 0x4000b9b5e4b3e1ec,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x400095cbed075f1c,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x40007262feb2e766,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x40004f783c5a2592,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x40002d08de19e816,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x40000b1230c037f3,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3fffd3232a1a3125,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fff9108fdf702de,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3fff4fd0ea245116,
    0x0, 0x0,
    0xbfecccccccccccc0, 0x3fff0f761f7775e1,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3ffecff3f14c4ad7,
    0x0, 0x0,
    0xbfecccccccccccee, 0x3ffe9145d4512b4d,
    0x0, 0x0,
    0xbfecccccccccccb3, 0x3ffe53675d5fc077,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ffe16544061f948,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3ffdda084f429a86,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ffd9e7f78e8d8d6,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3ffd63b5c83e7824,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x3ffd29a7633ff2a6,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ffcf0508a162f64,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ffcb7ad96395779,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3ffc7fbaf99c5f06,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ffc48753de0dbdc,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3ffc11d90392ca34,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3ffbdbe3016be346,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3ffba690039e2f86,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ffb71dceb25826e,
    0x0, 0x0,
    0xbfecccccccccccc1, 0x3ffb3dc6ad1f9136,
    0x0, 0x0,
    0xbfeccccccccccd07, 0x3ffb0a4a522a5a6a,
    0x0, 0x0,
    0xbfeccccccccccc98, 0x3ffad764f5c89828,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x3ffaa513c5cbf948,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ffa735401c4e2f8,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3ffa4222fa777c8e,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ffa117e1155cd0e,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ff9e162b7feb368,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ff9b1ce6fc184a2,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff982bec9261ed5,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3ff95431637940e5,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ff92623ec5cfad6,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3ff8f8941f5d0a70,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff8cb7fc586fc66,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ff89ee4b505e9da,
    0x0, 0x0,
    0xbfecccccccccccc0, 0x3ff872c0d0c1adc6,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3ff8471208016e27,
    0x0, 0x0,
    0xbfeccccccccccce2, 0x3ff81bd656115703,
    0x0, 0x0,
    0xbfecccccccccccb8, 0x3ff7f10bc1eb6727,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff7c6b05de32f10,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3ff79cc247546540,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ff7733fa65432e4,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3ff74a26ad651def,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ff72175992d77a4,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff6f92ab03035ac,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x3ff6d14442881eec,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3ff6a9c0a9a53540,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ff6829e480c466d,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3ff65bdb89188fc6,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ff63576e0bf6089,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff60f6ecb55a7fe,
    0x0, 0x0,
    0xbfecccccccccccc1, 0x3ff5e9c1cd575d62,
    0x0, 0x0,
    0xbfecccccccccccbe, 0x3ff5c46e7330affe,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3ff59f735108eeb8,
    0x0, 0x0,
    0xbfecccccccccccdc, 0x3ff57acf028f175d,
    0x0, 0x0,
    0xbfecccccccccccda, 0x3ff556802ac7fe37,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3ff5328573ddfeec,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ff50edd8ef22921,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff4eb8733eedae2,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff4c881215bbc38,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff4a5ca1c330f0d,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3ff48360efb847cb,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ff461446d4fe2f8,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff43f736c586d3c,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff41decca04b250,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ff3fcaf69370a06,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff3dbba325db82d,
    0x0, 0x0,
    0xbfecccccccccccbe, 0x3ff3bb0c13505744,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ff39aa3ff2e43e8,
    0x0, 0x0,
    0xbfecccccccccccd9, 0x3ff37a80ee3e00ee,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x3ff35aa1ddcd8bba,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3ff33b05d0139853,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff31babcc11ae7d,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff2fc92dd771f54,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ff2ddba1484ccad,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3ff2bf2085f1bbe8,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ff2a0c54ad06c88,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3ff282a78074ed1e,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3ff264c6485ba7ce,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ff24720c810e0dc,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3ff229b62918e13f,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ff20c8598d8c80e,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ff1ef8e487ffd3c,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3ff1d2cf6cf240ab,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff1b6483eb250be,
    0x0, 0x0,
    0xbfeccccccccccce8, 0x3ff199f7f9cd231a,
    0x0, 0x0,
    0xbfecccccccccccb6, 0x3ff17dddddc5ac8a,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff161f92d813096,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ff146492f341946,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3ff12acd2c4f4d6c,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3ff10f84716e0626,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ff0f46e4e441cf5,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff0d98a158cd037,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ff0bed71cf9f95a,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ff0a454bd23b234,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff08a02517865fb,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3ff06fdf382d4a0b,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff055ead22f3c60,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3ff03c24831403d3,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x3ff0228bb10bf008,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3ff0091fc4d3d590,
    0x0, 0x0,
    0xbfeccccccccccce4, 0x3fefdfc0534ec79a,
    0x0, 0x0,
    0xbfecccccccccccc0, 0x3fefad989a67a527,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fef7bc73f15c6a8,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fef4a4b262c6bb1,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fef19233915d7a6,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3feee84e65bb34ad,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3feeb7cb9e6d0d5f,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fee8799d9cc58dd,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fee57b812b414fc,
    0x0, 0x0,
    0xbfecccccccccccc1, 0x3fee282548236aed,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x3fedf8e07d2859bf,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fedc9e8b8cae4ca,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3fed9b3d05f8bf1d,
    0x0, 0x0,
    0xbfecccccccccccac, 0x3fed6cdc73717441,
    0x0, 0x0,
    0xbfeccccccccccce0, 0x3fed3ec613b30773,
    0x0, 0x0,
    0xbfecccccccccccdc, 0x3fed10f8fce709f5,
    0x0, 0x0,
    0xbfeccccccccccc9c, 0x3fece37448d01fa4,
    0x0, 0x8000000000000000,
    0xbfecccccccccccfc, 0x3fecb63714b7f3a4,
    0x0, 0x0,
    0xbfecccccccccccbc, 0x3fec8940815d9b75,
    0x0, 0x0,
    0xbfecccccccccccb2, 0x3fec5c8fb2e45b73,
    0x0, 0x0,
    0xbfecccccccccccf0, 0x3fec3023d0c2d841,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3fec03fc05b2a7dd,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3febd8177fa041ea,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x3febac756f9b509f,
    0x0, 0x0,
    0xbfecccccccccccdb, 0x3feb811509c75aad,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3feb55f5854cc79c,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3feb2b161c4a390d,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3feb00760bc6397f,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fead61493a13cbd,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3feaabf0f687efc6,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3fea820a79e5d6f1,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fea586065d837e8,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x3fea2ef205214cf7,
    0x0, 0x0,
    0xbfecccccccccccba, 0x3fea05bea51bc11a,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fe9dcc595ae70bf,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fe9b40629407109,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe98b7fb4ad574e,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fe963318f39c2c1,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x3fe93b1b1288255e,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fe9133b9a8dc9d6,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3fe8eb928588164f,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fe8c41f33f2090b,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe89ce10879eebe,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3fe875d767f75062,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fe84f01b961175b,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fe8285f65c3e6d0,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fe801efd838a83c,
    0x0, 0x0,
    0xbfecccccccccccc1, 0x3fe7dbb27ddb4b4c,
    0x0, 0x0,
    0xbfecccccccccccea, 0x3fe7b5a6c5c1b5e4,
    0x0, 0x0,
    0xbfecccccccccccb2, 0x3fe78fcc20f2e564,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3fe76a22025e3cdc,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fe744a7ded303b6,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3fe71f5d2cf80e64,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fe6fa41654393fc,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe6d55401f32e1a,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe6b0947f040228,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe68c025a2b1321,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe6679d12cdbae9,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe6436429fa4a79,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe61f572260cf60,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fe5fb75804bfe62,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe5d7bec99a41e3,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x3fe5b43285b6eba6,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fe590d03d93889e,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3fe56d977ba15683,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3fe54a87cbcad9f9,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe527a0bb6d948d,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe504e1d953da98,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe4e24ab5aec716,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3fe4bfdae2104d35,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fe49d91f16567dd,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe47b6f77f064ef,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x3fe459730b434cc7,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fe4379c423a64e2,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe415eab4f6cd4a,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe3f45dfcd937bd,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe3d2f5b47cb8a4,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe3b1b177b1b0b4,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fe39090e378cef3,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fe36f9395fe2a98,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fe34eb92e947424,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fe32e014db03d41,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fe30d6b94e35715,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe2ecf7a6d845f7,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe2cca5274dcacb,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe2ac73bb12810a,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fe28c630800916a,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe26c72b4f9782e,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe24ca269e1df34,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe22cf1cf9d8ae7,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe20d60900b5a5b,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe1edee560158f4,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe1ce9acd48e2c6,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe1af65a29ad9d4,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x3fe1904e839bed04,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe171551ed8ef57,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fe1527923c3400e,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fe133ba42ad42c2,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe115182cc6e69e,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe0f692941a3e69,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe0d8292b882670,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe0b9dba6c4f979,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fe09ba9ba5554d1,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe07d931b8ae9d4,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe05f9780815dbe,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fe041b6a01b36fe,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fe023f031fed7e3,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe00643ee93865c,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fdfd1631dfd00da,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fdf96719a403aa6,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fdf5bb2c721f582,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fdf21261b3e6cf0,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x3fdee6cb0e97660e,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fdeaca11a8ed2f2,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fde72a7b9e186e2,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fde38de68a20998,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fddff44a4337748,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fddc5d9eb447bda,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fdd8c9dbdca6060,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fdd538f9cfc2e1e,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fdd1aaf0b4de530,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fdce1fb8c6bc69c,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fdca974a535b280,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fdc7119dbba9802,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fdc38eab733f90e,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fdc00e6c0017ed0,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fdbc90d7fa4a172,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fdb915e80bc6010,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3fdb59d94f010abc,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fdb227d77401cf4,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fdaeb4a87582754,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fdab4400e34cc64,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fda7d5d9bcaca48,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fda46a2c11414f8,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fda100f100c006c,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd9d9a21bab7896,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd9a35b77e548d8,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd96d3ab9a2713a,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fd9373f76be8a32,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fd90169460435c0,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fd8cbb7bf299eb4,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fd8962a7acd0424,
    0x0, 0x0,
    0xbfecccccccccccd7, 0x3fd860c112715448,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x3fd82b7b207ad058,
    0x0, 0x0,
    0xbfeccccccccccce8, 0x3fd7f658402bc0d0,
    0x0, 0x0,
    0xbfecccccccccccaf, 0x3fd7c1580da1341c,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3fd78c7a25cfc844,
    0x0, 0x0,
    0xbfecccccccccccbf, 0x3fd757be268083b8,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3fd72323ae4db688,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd6eeaa5c9fe7dc,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd6ba51d1aad0b8,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd68619ae6a5e1a,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fd65201949fc10a,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fd61e0926ce8750,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd5ea300839bfb0,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd5b675dce1277c,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fd582da497e62b0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd54f5cf3823d68,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fd51bfd8111f79c,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd4e8bb99049978,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fd4b596e2e051b4,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fd4828f06d7dce0,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd44fa3adc7f448,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fd41cd48134c878,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fd3ea212b478174,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fd3b78956cbc8a4,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd3850caf2d5b40,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd352aae075a438,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd3206397495e8c,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fd2ee3680e63f24,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd2bc234b20a690,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fd28a29a4615a18,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd258493ba34470,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd22681c0713d58,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd1f4d2e2e3d8a0,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x3fd1c33c539f3c2c,
    0x0, 0x0,
    0xbfecccccccccccdd, 0x3fd191bdc3d0fc58,
    0x0, 0x0,
    0xbfecccccccccccbf, 0x3fd16056e52e00b0,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fd12f0769f06b10,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fd0fdcf04d58c20,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fd0ccad691bd754,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd09ba24a80e108,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fd06aad5d3f61c4,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd039ce560d3f58,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd00904ea199c14,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fcfb0a19e15d6e8,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fcf4f6375fa1a40,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fceee4ec8fed908,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fce8d6305264da0,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fce2c9f99526b00,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fcdcc03f5413de0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fcd6b8f89895668,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fcd0b41c7963db0,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fccab1a21a4f460,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fcc4b180ac07948,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fcbeb3af6be5dd0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fcb8b825a3b5f90,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fcb2bedaa980c40,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fcacc7c5df57028,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fca6d2deb31cb08,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fca0e01c9e54fe0,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fc9aef7725eeaa8,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc9500e5da11168,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fc8f146055e9a00,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fc8929de3f79ac0,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fc8341574765130,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fc7d5ac328c1110,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fc777619a8e3a50,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc7193529733730,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fc6bb265ccf8080,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fc65d34b2d2aad0,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fc5ff5faa447700,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fc5a1a6c281ed60,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fc544097b7a7ca0,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fc4e68755ad2100,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fc4891fd22590c0,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fc42bd272796f20,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc3ce9eb8c584b0,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fc3718427aaff50,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc31482424cb540,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fc2b7988c4c70e0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc25ac689c83f10,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3fc1fe0bbf57c530,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc1a167b2099aa0,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fc144d9e760a900,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fc0e861e55190d0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc08bff32401060,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fc02fb154fc7580,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fbfa6efa9821bc0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fbeeea4725f3d00,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fbe3680149dbfa0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fbd7e81a10ffb80,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fbcc6a8294836a0,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fbc0ef2bf93b5c0,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fbb576076f5d640,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fba9ff063232bc0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fb9e8a1987ca880,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fb931732c0acd40,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fb87a643378dd00,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fb7c373c5101bc0,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fb70ca0f7b30e40,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3fb655eae2d8cb80,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fb59f509e883e00,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fb4e8d143538c00,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fb4326bea536500,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fb37c1fad226940,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fb2c5eba5d88f00,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fb20fceef068ec0,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fb159c8a3b15440,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fb0a3d7df4d7440,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fafdbf77b754d80,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fae7066b67e8b00,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fad04fba907a180,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fab99b48d1ce600,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3faa2e8f9d7d2180,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fa8c38b1590a500,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fa758a531607500,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fa5eddc2d8d7200,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fa4832e47478500,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fa31899bc44e200,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fa1ae1ccab93900,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fa043b5b14cfe00,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3f9db2c55e296000,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3f9ade4407104400,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3f9809e3dcf39400,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3f9535a1601c2400,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3f92617911657000,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3f8f1acee4587000,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3f8972d2087a8000,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3f83caf493882000,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3f7c465f14e6c000,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3f70f6f7e54dc000,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3f569e968f180000,
    0x0
    };

static const uint64_t ref_rfft_step_2048[2049] = {
    0x408ccccccccccccd, 0x0,
    0xbfeccccccccccd00, 0x408255aaa4bc2b9e,
    0x0, 0x8000000000000000,
    0xbfecccccccccccda, 0x4068722ece0ccb9a,
    0x0, 0x0,
    0xbfecccccccccce28, 0x405d55b9a3679087,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x4054f3fd088b91af,
    0x0, 0x8000000000000000,
    0xbfecccccccccccd2, 0x40504be2e24253f2,
    0x0, 0x0,
    0xbfeccccccccccc75, 0x404aaa823eed92bd,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x4046900f24647fa6,
    0x0, 0x0,
    0xbfeccccccccccc7a, 0x40438db2b0659cb6,
    0x0, 0x0,
    0xbfeccccccccccd18, 0x40414092117a723e,
    0x0, 0x0,
    0xbfecccccccccccab, 0x403edee3ed8e2317,
    0x0, 0x0,
    0xbfecccccccccccff, 0x403bedc9071f7613,
    0x0, 0x0,
    0xbfecccccccccccba, 0x40397f9d2e55bfe7,
    0x0, 0x0,
    0xbfecccccccccccda, 0x403774f3d05a1d2c,
    0x0, 0x0,
    0xbfeccccccccccc6d, 0x4035b7afee1f2421,
    0x0, 0x0,
    0xbfecccccccccccdf, 0x403437ce3009c342,
    0x0, 0x0,
    0xbfeccccccccccdbb, 0x4032e96d238a4da9,
    0x0, 0x8000000000000000,
    0xbfeccccccccccbf1, 0x4031c38ca820c8e2,
    0x0, 0x0,
    0xbfecccccccccccaf, 0x4030bf3b45a19504,
    0x0, 0x0,
    0xbfeccccccccccd11, 0x402fae0faa66c35a,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x402e0d3dec9b87f2,
    0x0, 0x0,
    0xbfeccccccccccced, 0x402c950ab676ab00,
    0x0, 0x0,
    0xbfecccccccccccb0, 0x402b3fcb12602487,
    0x0, 0x0,
    0xbfecccccccccccd9, 0x402a08d5fd804bfc,
    0x0, 0x0,
    0xbfecccccccccccad, 0x4028ec4d85cd611c,
    0x0, 0x0,
    0xbfecccccccccccf8, 0x4027e6f558e6bf26,
    0x0, 0x0,
    0xbfecccccccccccde, 0x4026f6131334f4b2,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x40261755bbea70f8,
    0x0, 0x0,
    0xbfecccccccccccd9, 0x402548c29a532b98,
    0x0, 0x0,
    0xbfecccccccccccaf, 0x402488a6142100a0,
    0x0, 0x0,
    0xbfecccccccccccca, 0x4023d5879f9729bf,
    0x0, 0x0,
    0xbfeccccccccccca8, 0x40232e2014c225b4,
    0x0, 0x0,
    0xbfeccccccccccdd9, 0x40229151d6d5bcdf,
    0x0, 0x0,
    0xbfeccccccccccbc4, 0x4021fe226fff928e,
    0x0, 0x0,
    0xbfecccccccccccf1, 0x402173b55245abf2,
    0x0, 0x0,
    0xbfecccccccccccde, 0x4020f14781fb7ad7,
    0x0, 0x0,
    0xbfeccccccccccce4, 0x4020762bfbbe2b9a,
    0x0, 0x0,
    0xbfecccccccccccdc, 0x402001c8b20155ef,
    0x0, 0x0,
    0xbfecccccccccccca, 0x401f27280bc2a8ef,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x401e562549a301df,
    0x0, 0x0,
    0xbfecccccccccccb2, 0x401d8fab728d5087,
    0x0, 0x0,
    0xbfeccccccccccce5, 0x401cd2f2c00bbe12,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x401c1f46ad07658f,
    0x0, 0x0,
    0xbfeccccccccccce0, 0x401b7403b1db44d2,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x401ad095506490c7,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x401a3474637b4313,
    0x0, 0x0,
    0xbfecccccccccccb3, 0x40199f25a77413ea,
    0x0, 0x0,
    0xbfeccccccccccce6, 0x401910387315cf60,
    0x0, 0x0,
    0xbfeccccccccccd15, 0x4018874599de291c,
    0x0, 0x0,
    0xbfeccccccccccc88, 0x401803ee719fb2f0,
    0x0, 0x0,
    0xbfecccccccccccba, 0x401785dbf6794895,
    0x0, 0x0,
    0xbfecccccccccccf3, 0x40170cbe08f1fca6,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x4016984ac2abdd94,
    0x0, 0x0,
    0xbfecccccccccccde, 0x4016283ddeaa8694,
    0x0, 0x0,
    0xbfecccccccccccca, 0x4015bc58329dbd42,
    0x0, 0x0,
    0xbfecccccccccccdf, 0x4015545f37009d72,
    0x0, 0x0,
    0xbfecccccccccccb4, 0x4014f01c9c2e7b02,
    0x0, 0x0,
    0xbfecccccccccccec, 0x40148f5dead26e95,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x401431f42e4fb21e,
    0x0, 0x0,
    0xbfecccccccccccdc, 0x4013d7b3a7f15676,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x4013807389d8ecf2,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x40132c0db8c6b661,
    0x0, 0x0,
    0xbfecccccccccccaf, 0x4012da5e93f3c100,
    0x0, 0x0,
    0xbfeccccccccccc9a, 0x40128b44c24feae0,
    0x0, 0x0,
    0xbfeccccccccccca8, 0x40123ea1048bab95,
    0x0, 0x8000000000000000,
    0xbfecccccccccccf8, 0x4011f4560b6865fe,
    0x0, 0x0,
    0xbfecccccccccccff, 0x4011ac4851da48ee,
    0x0, 0x0,
    0xbfeccccccccccce7, 0x4011665dfa94d834,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x4011227eb0a76964,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x4010e0938ad977c0,
    0x0, 0x0,
    0xbfecccccccccccbf, 0x4010a086f17feb7c,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x40106244868c7b67,
    0x0, 0x0,
    0xbfecccccccccccbb, 0x401025b90f9f58d1,
    0x0, 0x0,
    0xbfecccccccccccdb, 0x400fd5a4c3d2fb6a,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x400f62fe9f66ba16,
    0x0, 0x0,
    0xbfecccccccccccca, 0x400ef35f2ec0ea7a,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x400e86a7a798e9ae,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x400e1cbadbc4a426,
    0x0, 0x0,
    0xbfecccccccccccad, 0x400db57d1ea1f498,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x400d50d42c88432e,
    0x0, 0x0,
    0xbfecccccccccccfa, 0x400ceea714149626,
    0x0, 0x0,
    0xbfeccccccccccca5, 0x400c8ede2126d2c4,
    0x0, 0x0,
    0xbfecccccccccccbe, 0x400c3162c96af8f6,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x400bd61f9a4cc192,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x400b7d0028373cf3,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x400b25f0ff04f1b8,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x400ad0df93878dca,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x400a7dba3610894e,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x400a2c7005e62d9e,
    0x0, 0x0,
    0xbfecccccccccccde, 0x4009dcf0e5924dac,
    0x0, 0x0,
    0xbfecccccccccccca, 0x40098f2d6ff9a913,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x40094316ee2c7458,
    0x0, 0x0,
    0xbfecccccccccccca, 0x4008f89f4de1dc5b,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x4008afb9189194a6,
    0x0, 0x0,
    0xbfecccccccccccbf, 0x400868576b1f9b7c,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x4008226dee0f5f4e,
    0x0, 0x0,
    0xbfeccccccccccd21, 0x4007ddf0ce345894,
    0x0, 0x0,
    0xbfeccccccccccc81, 0x40079ad4b5d6ffcd,
    0x0, 0x0,
    0xbfecccccccccccce, 0x4007590ec645c28e,
    0x0, 0x0,
    0xbfecccccccccccca, 0x4007189491ca4e60,
    0x0, 0x0,
    0xbfecccccccccccd7, 0x4006d95c15fc1e5f,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x40069b5bb669d00e,
    0x0, 0x0,
    0xbfecccccccccccc1, 0x40065e8a3793415b,
    0x0, 0x0,
    0xbfecccccccccccca, 0x400622deba2ef42a,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x4005e850b6b59fec,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x4005aed7f92f3de6,
    0x0, 0x0,
    0xbfecccccccccccce, 0x4005766c9d3d3821,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x40053f070a5db5b0,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x4005089ff0644d0e,
    0x0, 0x0,
    0xbfecccccccccccce, 0x4004d3304424a9f0,
    0x0, 0x0,
    0xbfecccccccccccba, 0x40049eb13c4bf587,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x40046b1c4e660ab9,
    0x0, 0x0,
    0xbfecccccccccccee, 0x4004386b2c0bb634,
    0x0, 0x0,
    0xbfeccccccccccca9, 0x40040697c037751a,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x4003d59c2cbe51cc,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x4003a572c7eaaa48,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x400376161a36d14b,
    0x0, 0x0,
    0xbfecccccccccccce, 0x40034780dc25a09a,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x400319adf43733d0,
    0x0, 0x0,
    0xbfecccccccccccce, 0x4002ec9874f821b6,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x4002c03b9b29a6d5,
    0x0, 0x0,
    0xbfecccccccccccdc, 0x40029492cc014e94,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x40026999937ebfeb,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x40023f4ba2d66a7b,
    0x0, 0x0,
    0xbfecccccccccccb3, 0x400215a4ceefe450,
    0x0, 0x0,
    0xbfeccccccccccce9, 0x4001eca10ef6dd94,
    0x0, 0x0,
    0xbfecccccccccccb7, 0x4001c43c7afda045,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x40019c734ab02438,
    0x0, 0x0,
    0xbfeccccccccccceb, 0x40017541d416cca4,
    0x0, 0x0,
    0xbfecccccccccccb2, 0x40014ea48a67f7ba,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x40012897fce78efa,
    0x0, 0x0,
    0xbfecccccccccccdf, 0x40010318d5d3dd67,
    0x0, 0x0,
    0xbfecccccccccccb6, 0x4000de23d95ef0d8,
    0x0, 0x0,
    0xbfeccccccccccced, 0x4000b9b5e4b3e1ec,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x400095cbed075f1c,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x40007262feb2e766,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x40004f783c5a2592,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x40002d08de19e816,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x40000b1230c037f3,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3fffd3232a1a3125,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fff9108fdf702de,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3fff4fd0ea245116,
    0x0, 0x0,
    0xbfecccccccccccc0, 0x3fff0f761f7775e1,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3ffecff3f14c4ad7,
    0x0, 0x0,
    0xbfecccccccccccee, 0x3ffe9145d4512b4d,
    0x0, 0x0,
    0xbfecccccccccccb3, 0x3ffe53675d5fc077,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ffe16544061f948,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3ffdda084f429a86,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ffd9e7f78e8d8d6,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3ffd63b5c83e7824,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x3ffd29a7633ff2a6,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ffcf0508a162f64,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ffcb7ad96395779,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3ffc7fbaf99c5f06,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ffc48753de0dbdc,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3ffc11d90392ca34,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3ffbdbe3016be346,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3ffba690039e2f86,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ffb71dceb25826e,
    0x0, 0x0,
    0xbfecccccccccccc1, 0x3ffb3dc6ad1f9136,
    0x0, 0x0,
    0xbfeccccccccccd07, 0x3ffb0a4a522a5a6a,
    0x0, 0x0,
    0xbfeccccccccccc98, 0x3ffad764f5c89828,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x3ffaa513c5cbf948,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ffa735401c4e2f8,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3ffa4222fa777c8e,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ffa117e1155cd0e,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ff9e162b7feb368,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ff9b1ce6fc184a2,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff982bec9261ed5,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3ff95431637940e5,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ff92623ec5cfad6,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3ff8f8941f5d0a70,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff8cb7fc586fc66,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ff89ee4b505e9da,
    0x0, 0x0,
    0xbfecccccccccccc0, 0x3ff872c0d0c1adc6,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3ff8471208016e27,
    0x0, 0x0,
    0xbfeccccccccccce2, 0x3ff81bd656115703,
    0x0, 0x0,
    0xbfecccccccccccb8, 0x3ff7f10bc1eb6727,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff7c6b05de32f10,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3ff79cc247546540,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ff7733fa65432e4,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3ff74a26ad651def,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ff72175992d77a4,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff6f92ab03035ac,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x3ff6d14442881eec,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3ff6a9c0a9a53540,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ff6829e480c466d,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3ff65bdb89188fc6,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ff63576e0bf6089,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff60f6ecb55a7fe,
    0x0, 0x0,
    0xbfecccccccccccc1, 0x3ff5e9c1cd575d62,
    0x0, 0x0,
    0xbfecccccccccccbe, 0x3ff5c46e7330affe,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3ff59f735108eeb8,
    0x0, 0x0,
    0xbfecccccccccccdc, 0x3ff57acf028f175d,
    0x0, 0x0,
    0xbfecccccccccccda, 0x3ff556802ac7fe37,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3ff5328573ddfeec,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ff50edd8ef22921,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff4eb8733eedae2,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff4c881215bbc38,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff4a5ca1c330f0d,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3ff48360efb847cb,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ff461446d4fe2f8,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff43f736c586d3c,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff41decca04b250,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ff3fcaf69370a06,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff3dbba325db82d,
    0x0, 0x0,
    0xbfecccccccccccbe, 0x3ff3bb0c13505744,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ff39aa3ff2e43e8,
    0x0, 0x0,
    0xbfecccccccccccd9, 0x3ff37a80ee3e00ee,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x3ff35aa1ddcd8bba,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3ff33b05d0139853,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff31babcc11ae7d,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff2fc92dd771f54,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ff2ddba1484ccad,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3ff2bf2085f1bbe8,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ff2a0c54ad06c88,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3ff282a78074ed1e,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3ff264c6485ba7ce,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ff24720c810e0dc,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3ff229b62918e13f,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ff20c8598d8c80e,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ff1ef8e487ffd3c,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3ff1d2cf6cf240ab,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff1b6483eb250be,
    0x0, 0x0,
    0xbfeccccccccccce8, 0x3ff199f7f9cd231a,
    0x0, 0x0,
    0xbfecccccccccccb6, 0x3ff17dddddc5ac8a,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff161f92d813096,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ff146492f341946,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3ff12acd2c4f4d6c,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3ff10f84716e0626,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ff0f46e4e441cf5,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff0d98a158cd037,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ff0bed71cf9f95a,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ff0a454bd23b234,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff08a02517865fb,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3ff06fdf382d4a0b,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff055ead22f3c60,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3ff03c24831403d3,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x3ff0228bb10bf008,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3ff0091fc4d3d590,
    0x0, 0x0,
    0xbfeccccccccccce4, 0x3fefdfc0534ec79a,
    0x0, 0x0,
    0xbfecccccccccccc0, 0x3fefad989a67a527,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fef7bc73f15c6a8,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fef4a4b262c6bb1,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fef19233915d7a6,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3feee84e65bb34ad,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3feeb7cb9e6d0d5f,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fee8799d9cc58dd,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fee57b812b414fc,
    0x0, 0x0,
    0xbfecccccccccccc1, 0x3fee282548236aed,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x3fedf8e07d2859bf,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fedc9e8b8cae4ca,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3fed9b3d05f8bf1d,
    0x0, 0x0,
    0xbfecccccccccccac, 0x3fed6cdc73717441,
    0x0, 0x0,
    0xbfeccccccccccce0, 0x3fed3ec613b30773,
    0x0, 0x0,
    0xbfecccccccccccdc, 0x3fed10f8fce709f5,
    0x0, 0x0,
    0xbfeccccccccccc9c, 0x3fece37448d01fa4,
    0x0, 0x8000000000000000,
    0xbfecccccccccccfc, 0x3fecb63714b7f3a4,
    0x0, 0x0,
    0xbfecccccccccccbc, 0x3fec8940815d9b75,
    0x0, 0x0,
    0xbfecccccccccccb2, 0x3fec5c8fb2e45b73,
    0x0, 0x0,
    0xbfecccccccccccf0, 0x3fec3023d0c2d841,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3fec03fc05b2a7dd,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3febd8177fa041ea,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x3febac756f9b509f,
    0x0, 0x0,
    0xbfecccccccccccdb, 0x3feb811509c75aad,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3feb55f5854cc79c,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3feb2b161c4a390d,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3feb00760bc6397f,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fead61493a13cbd,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3feaabf0f687efc6,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3fea820a79e5d6f1,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fea586065d837e8,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x3fea2ef205214cf7,
    0x0, 0x0,
    0xbfecccccccccccba, 0x3fea05bea51bc11a,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fe9dcc595ae70bf,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fe9b40629407109,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe98b7fb4ad574e,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fe963318f39c2c1,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x3fe93b1b1288255e,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fe9133b9a8dc9d6,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3fe8eb928588164f,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fe8c41f33f2090b,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe89ce10879eebe,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3fe875d767f75062,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fe84f01b961175b,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fe8285f65c3e6d0,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fe801efd838a83c,
    0x0, 0x0,
    0xbfecccccccccccc1, 0x3fe7dbb27ddb4b4c,
    0x0, 0x0,
    0xbfecccccccccccea, 0x3fe7b5a6c5c1b5e4,
    0x0, 0x0,
    0xbfecccccccccccb2, 0x3fe78fcc20f2e564,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3fe76a22025e3cdc,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fe744a7ded303b6,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3fe71f5d2cf80e64,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fe6fa41654393fc,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe6d55401f32e1a,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe6b0947f040228,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe68c025a2b1321,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe6679d12cdbae9,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe6436429fa4a79,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe61f572260cf60,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fe5fb75804bfe62,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe5d7bec99a41e3,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x3fe5b43285b6eba6,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fe590d03d93889e,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3fe56d977ba15683,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3fe54a87cbcad9f9,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe527a0bb6d948d,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe504e1d953da98,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe4e24ab5aec716,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3fe4bfdae2104d35,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fe49d91f16567dd,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe47b6f77f064ef,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x3fe459730b434cc7,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fe4379c423a64e2,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe415eab4f6cd4a,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe3f45dfcd937bd,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe3d2f5b47cb8a4,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe3b1b177b1b0b4,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fe39090e378cef3,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fe36f9395fe2a98,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fe34eb92e947424,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fe32e014db03d41,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fe30d6b94e35715,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe2ecf7a6d845f7,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe2cca5274dcacb,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe2ac73bb12810a,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fe28c630800916a,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe26c72b4f9782e,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe24ca269e1df34,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe22cf1cf9d8ae7,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe20d60900b5a5b,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe1edee560158f4,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe1ce9acd48e2c6,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe1af65a29ad9d4,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x3fe1904e839bed04,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe171551ed8ef57,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fe1527923c3400e,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fe133ba42ad42c2,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe115182cc6e69e,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe0f692941a3e69,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe0d8292b882670,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe0b9dba6c4f979,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fe09ba9ba5554d1,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe07d931b8ae9d4,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe05f9780815dbe,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fe041b6a01b36fe,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fe023f031fed7e3,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe00643ee93865c,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fdfd1631dfd00da,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fdf96719a403aa6,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fdf5bb2c721f582,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fdf21261b3e6cf0,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x3fdee6cb0e97660e,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fdeaca11a8ed2f2,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fde72a7b9e186e2,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fde38de68a20998,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fddff44a4337748,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fddc5d9eb447bda,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fdd8c9dbdca6060,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fdd538f9cfc2e1e,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fdd1aaf0b4de530,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fdce1fb8c6bc69c,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fdca974a535b280,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fdc7119dbba9802,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fdc38eab733f90e,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fdc00e6c0017ed0,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fdbc90d7fa4a172,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fdb915e80bc6010,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3fdb59d94f010abc,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fdb227d77401cf4,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fdaeb4a87582754,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fdab4400e34cc64,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fda7d5d9bcaca48,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fda46a2c11414f8,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fda100f100c006c,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd9d9a21bab7896,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd9a35b77e548d8,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd96d3ab9a2713a,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fd9373f76be8a32,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fd90169460435c0,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fd8cbb7bf299eb4,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fd8962a7acd0424,
    0x0, 0x0,
    0xbfecccccccccccd7, 0x3fd860c112715448,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x3fd82b7b207ad058,
    0x0, 0x0,
    0xbfeccccccccccce8, 0x3fd7f658402bc0d0,
    0x0, 0x0,
    0xbfecccccccccccaf, 0x3fd7c1580da1341c,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3fd78c7a25cfc844,
    0x0, 0x0,
    0xbfecccccccccccbf, 0x3fd757be268083b8,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3fd72323ae4db688,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd6eeaa5c9fe7dc,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd6ba51d1aad0b8,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd68619ae6a5e1a,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fd65201949fc10a,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fd61e0926ce8750,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd5ea300839bfb0,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd5b675dce1277c,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fd582da497e62b0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd54f5cf3823d68,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fd51bfd8111f79c,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd4e8bb99049978,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fd4b596e2e051b4,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fd4828f06d7dce0,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd44fa3adc7f448,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fd41cd48134c878,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fd3ea212b478174,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fd3b78956cbc8a4,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd3850caf2d5b40,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd352aae075a438,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd3206397495e8c,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fd2ee3680e63f24,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd2bc234b20a690,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fd28a29a4615a18,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd258493ba34470,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd22681c0713d58,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd1f4d2e2e3d8a0,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x3fd1c33c539f3c2c,
    0x0, 0x0,
    0xbfecccccccccccdd, 0x3fd191bdc3d0fc58,
    0x0, 0x0,
    0xbfecccccccccccbf, 0x3fd16056e52e00b0,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fd12f0769f06b10,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fd0fdcf04d58c20,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fd0ccad691bd754,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd09ba24a80e108,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fd06aad5d3f61c4,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd039ce560d3f58,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd00904ea199c14,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fcfb0a19e15d6e8,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fcf4f6375fa1a40,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fceee4ec8fed908,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fce8d6305264da0,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fce2c9f99526b00,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fcdcc03f5413de0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fcd6b8f89895668,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fcd0b41c7963db0,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fccab1a21a4f460,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fcc4b180ac07948,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fcbeb3af6be5dd0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fcb8b825a3b5f90,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fcb2bedaa980c40,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fcacc7c5df57028,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fca6d2deb31cb08,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fca0e01c9e54fe0,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fc9aef7725eeaa8,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc9500e5da11168,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fc8f146055e9a00,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fc8929de3f79ac0,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fc8341574765130,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fc7d5ac328c1110,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fc777619a8e3a50,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc7193529733730,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fc6bb265ccf8080,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fc65d34b2d2aad0,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fc5ff5faa447700,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fc5a1a6c281ed60,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fc544097b7a7ca0,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fc4e68755ad2100,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fc4891fd22590c0,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fc42bd272796f20,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc3ce9eb8c584b0,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fc3718427aaff50,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc31482424cb540,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fc2b7988c4c70e0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc25ac689c83f10,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3fc1fe0bbf57c530,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc1a167b2099aa0,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fc144d9e760a900,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fc0e861e55190d0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc08bff32401060,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fc02fb154fc7580,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fbfa6efa9821bc0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fbeeea4725f3d00,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fbe3680149dbfa0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fbd7e81a10ffb80,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fbcc6a8294836a0,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fbc0ef2bf93b5c0,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fbb576076f5d640,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fba9ff063232bc0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fb9e8a1987ca880,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fb931732c0acd40,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fb87a643378dd00,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fb7c373c5101bc0,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fb70ca0f7b30e40,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3fb655eae2d8cb80,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fb59f509e883e00,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fb4e8d143538c00,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fb4326bea536500,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fb37c1fad226940,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fb2c5eba5d88f00,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fb20fceef068ec0,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fb159c8a3b15440,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fb0a3d7df4d7440,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fafdbf77b754d80,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fae7066b67e8b00,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fad04fba907a180,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fab99b48d1ce600,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3faa2e8f9d7d2180,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fa8c38b1590a500,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fa758a531607500,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fa5eddc2d8d7200,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fa4832e47478500,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fa31899bc44e200,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fa1ae1ccab93900,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fa043b5b14cfe00,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3f9db2c55e296000,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3f9ade4407104400,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3f9809e3dcf39400,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3f9535a1601c2400,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3f92617911657000,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3f8f1acee4587000,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3f8972d2087a8000,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3f83caf493882000,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3f7c465f14e6c000,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3f70f6f7e54dc000,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3f569e968f180000,
    0x0
    };

static const uint64_t in_rfft_step_4096[4096] = {
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd
    };

static const uint64_t in_rifft_step_4096[4097] = {
    0x409ccccccccccccd, 0x0,
    0xbfeccccccccccd34, 0x409255ab59b0d91d,
    0x0, 0x8000000000000000,
    0xbfeccccccccccce7, 0x407872374985cccb,
    0x0, 0x0,
    0xbfeccccccccccf89, 0x406d55d5e9ab64d0,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x4064f4249e29f05e,
    0x0, 0x8000000000000000,
    0xbfecccccccccccd2, 0x40604c15c7477297,
    0x0, 0x0,
    0xbfeccccccccccc1d, 0x405aaafea7e4b54b,
    0x0, 0x0,
    0xbfecccccccccccba, 0x405690a22c6ee735,
    0x0, 0x0,
    0xbfeccccccccccc24, 0x40538e5c57b0a394,
    0x0, 0x0,
    0xbfeccccccccccd64, 0x40514152583a6d84,
    0x0, 0x0,
    0xbfeccccccccccc89, 0x404ee091ba6ea2bb,
    0x0, 0x0,
    0xbfeccccccccccd32, 0x404befa413e515be,
    0x0, 0x0,
    0xbfeccccccccccca4, 0x404981a57b930dd2,
    0x0, 0x0,
    0xbfeccccccccccce6, 0x404777295eaf9f91,
    0x0, 0x0,
    0xbfeccccccccccc12, 0x4045ba12be3b5a02,
    0x0, 0x0,
    0xbfecccccccccccf3, 0x40443a5e42a9253e,
    0x0, 0x0,
    0xbfecccccccccceaa, 0x4042ec2a79774ee4,
    0x0, 0x8000000000000000,
    0xbfeccccccccccb14, 0x4041c6774233d803,
    0x0, 0x0,
    0xbfeccccccccccc92, 0x4040c25324c11d3b,
    0x0, 0x0,
    0xbfeccccccccccd5c, 0x403fb499f4a797aa,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x403e1422c4e2ef83,
    0x0, 0x0,
    0xbfeccccccccccd0c, 0x403c9c4a1ee5755a,
    0x0, 0x0,
    0xbfeccccccccccc97, 0x403b47650d332402,
    0x0, 0x0,
    0xbfeccccccccccce7, 0x403a10ca8d10587c,
    0x0, 0x0,
    0xbfeccccccccccc91, 0x4038f49cac8f5afc,
    0x0, 0x0,
    0xbfeccccccccccd22, 0x4037ef9f196b9240,
    0x0, 0x0,
    0xbfecccccccccccef, 0x4036ff1770299b8a,
    0x0, 0x0,
    0xbfeccccccccccce2, 0x403620b4b817f80c,
    0x0, 0x0,
    0xbfeccccccccccce6, 0x4035527c389eb4d4,
    0x0, 0x0,
    0xbfeccccccccccc92, 0x403492ba578bc6ee,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x4033dff68b3e84c2,
    0x0, 0x0,
    0xbfeccccccccccc8a, 0x403338e9abdf8da0,
    0x0, 0x0,
    0xbfeccccccccccede, 0x40329c761cbece7a,
    0x0, 0x0,
    0xbfeccccccccccabf, 0x403209a16826134a,
    0x0, 0x0,
    0xbfeccccccccccd10, 0x40317f8f00378e3a,
    0x0, 0x0,
    0xbfecccccccccccf4, 0x4030fd7be962e270,
    0x0, 0x0,
    0xbfecccccccccccf8, 0x403082bb2061722a,
    0x0, 0x0,
    0xbfecccccccccccea, 0x40300eb297c30fb2,
    0x0, 0x0,
    0xbfecccccccccccca, 0x402f41b16180aa16,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x402e716431d1c08e,
    0x0, 0x0,
    0xbfeccccccccccc97, 0x402dab9ff59b8f80,
    0x0, 0x0,
    0xbfecccccccccccfe, 0x402cef9ce6a0dd68,
    0x0, 0x0,
    0xbfecccccccccccce, 0x402c3ca680036d60,
    0x0, 0x0,
    0xbfecccccccccccf4, 0x402b92193a56f04d,
    0x0, 0x0,
    0xbfecccccccccccba, 0x402aef6097b15976,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x402a53f573236c6a,
    0x0, 0x0,
    0xbfeccccccccccc9f, 0x4029bf5c893ab725,
    0x0, 0x0,
    0xbfecccccccccccff, 0x4029312530f6e7a0,
    0x0, 0x0,
    0xbfeccccccccccd5a, 0x4028a8e83e0e9fd0,
    0x0, 0x0,
    0xbfeccccccccccc44, 0x40282647068d6c84,
    0x0, 0x0,
    0xbfeccccccccccca6, 0x4027a8ea86cb3170,
    0x0, 0x0,
    0xbfeccccccccccd20, 0x402730829f881664,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x4026bcc56a9f4c92,
    0x0, 0x0,
    0xbfecccccccccccec, 0x40264d6ea34d9fbd,
    0x0, 0x0,
    0xbfecccccccccccca, 0x4025e23f1f7c142d,
    0x0, 0x0,
    0xbfecccccccccccf1, 0x40257afc57df12c2,
    0x0, 0x0,
    0xbfeccccccccccc9e, 0x4025176ffd0b4b0e,
    0x0, 0x0,
    0xbfeccccccccccd0c, 0x4024b76797e54061,
    0x0, 0x0,
    0xbfecccccccccccde, 0x40245ab43409a693,
    0x0, 0x0,
    0xbfecccccccccccec, 0x4024012a12fd17eb,
    0x0, 0x0,
    0xbfecccccccccccda, 0x4023aaa0671abefa,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x402356f1155c85e4,
    0x0, 0x0,
    0xbfeccccccccccc91, 0x402305f87d35349f,
    0x0, 0x0,
    0xbfeccccccccccc68, 0x4022b79545ce73a0,
    0x0, 0x0,
    0xbfeccccccccccc83, 0x40226ba8301295d8,
    0x0, 0x8000000000000000,
    0xbfeccccccccccd22, 0x40222213ecfceac2,
    0x0, 0x0,
    0xbfeccccccccccd32, 0x4021dabcf7bb9f58,
    0x0, 0x0,
    0xbfeccccccccccd05, 0x40219589733c4768,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x402152610ac85aa3,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x4021112cd56188d9,
    0x0, 0x0,
    0xbfecccccccccccaf, 0x4020d1d73b97017e,
    0x0, 0x0,
    0xbfecccccccccccbc, 0x4020944bdf94d5a8,
    0x0, 0x0,
    0xbfeccccccccccca8, 0x402058778735a438,
    0x0, 0x0,
    0xbfeccccccccccceb, 0x40201e4807e4e856,
    0x0, 0x0,
    0xbfecccccccccccb7, 0x401fcb58684b5416,
    0x0, 0x0,
    0xbfecccccccccccca, 0x401f5d27952c2210,
    0x0, 0x0,
    0xbfecccccccccccb4, 0x401ef1decc991338,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x401e8960e0ddb91d,
    0x0, 0x0,
    0xbfeccccccccccc94, 0x401e239225cdbdc2,
    0x0, 0x0,
    0xbfecccccccccccde, 0x401dc0585836836a,
    0x0, 0x0,
    0xbfeccccccccccd2a, 0x401d5f9a872b35ce,
    0x0, 0x0,
    0xbfeccccccccccc7a, 0x401d0140ff020ba8,
    0x0, 0x0,
    0xbfecccccccccccb3, 0x401ca53535dd8306,
    0x0, 0x0,
    0xbfecccccccccccdf, 0x401c4b61b9a0000a,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x401bf3b21f2b6c30,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x401b9e12f2d155aa,
    0x0, 0x0,
    0xbfecccccccccccb8, 0x401b4a71a9daa104,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x401af8bc95102cb1,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x401aa8e2d42fd8a2,
    0x0, 0x0,
    0xbfecccccccccccf0, 0x401a5ad44a3b3f4e,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x401a0e81928f195a,
    0x0, 0x0,
    0xbfecccccccccccce, 0x4019c3dbf6b3c67e,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x40197ad564d8d19c,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x4019336066ee7fa5,
    0x0, 0x0,
    0xbfecccccccccccb4, 0x4018ed701a519451,
    0x0, 0x0,
    0xbfecccccccccccb8, 0x4018a8f827fe7836,
    0x0, 0x0,
    0xbfeccccccccccd80, 0x401865ecbd41d346,
    0x0, 0x0,
    0xbfeccccccccccc2a, 0x4018244284dd835c,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x4017e3eea0999224,
    0x0, 0x0,
    0xbfecccccccccccca, 0x4017a4e6a3398058,
    0x0, 0x0,
    0xbfeccccccccccce1, 0x401767208aced43c,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x40172a92bb626efb,
    0x0, 0x0,
    0xbfecccccccccccbc, 0x4016ef33f9eeab5c,
    0x0, 0x0,
    0xbfecccccccccccca, 0x4016b4fb67a4c1ef,
    0x0, 0x0,
    0xbfecccccccccccba, 0x40167be07d785b4e,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x401643db07ec9d0e,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x40160ce3231e5950,
    0x0, 0x0,
    0xbfecccccccccccdc, 0x4015d6f137075bbc,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x4015a1fdf3f71c7f,
    0x0, 0x0,
    0xbfecccccccccccce, 0x40156e024f3d66cb,
    0x0, 0x0,
    0xbfecccccccccccae, 0x40153af78003c1c8,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x401508d6fc52a574,
    0x0, 0x0,
    0xbfeccccccccccd10, 0x4014d79a763fbb68,
    0x0, 0x0,
    0xbfeccccccccccc84, 0x4014a73bd9429e23,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x401477b547adb6a2,
    0x0, 0x0,
    0xbfeccccccccccce2, 0x4014490118490348,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x40141b19d40cb9c8,
    0x0, 0x0,
    0xbfecccccccccccce, 0x4013edfa33f9da15,
    0x0, 0x0,
    0xbfecccccccccccbe, 0x4013c19d1f0ee9e6,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x401395fda8572ebc,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x40136b170d12d924,
    0x0, 0x0,
    0xbfeccccccccccce2, 0x401340e4b2f6ae90,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x401317622681d6b6,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x4012ee8b19688964,
    0x0, 0x0,
    0xbfeccccccccccc9b, 0x4012c65b61126cf4,
    0x0, 0x0,
    0xbfecccccccccccfe, 0x40129ecef52b8ab4,
    0x0, 0x0,
    0xbfecccccccccccb2, 0x401277e1ee46cf50,
    0x0, 0x0,
    0xbfecccccccccccb4, 0x4012519084911f9c,
    0x0, 0x0,
    0xbfeccccccccccd22, 0x40122bd70e9416ca,
    0x0, 0x0,
    0xbfeccccccccccc80, 0x401206b2000796b2,
    0x0, 0x0,
    0xbfecccccccccccea, 0x4011e21de8b15908,
    0x0, 0x0,
    0xbfeccccccccccce7, 0x4011be177351c61c,
    0x0, 0x0,
    0xbfeccccccccccca8, 0x40119a9b649d5703,
    0x0, 0x0,
    0xbfeccccccccccd08, 0x401177a69a41de4c,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x4011553609f713b6,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x40113346c099cfb9,
    0x0, 0x0,
    0xbfecccccccccccc0, 0x401111d5e151676f,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x4010f0e0a4bea54f,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x4010d0645833e0bb,
    0x0, 0x0,
    0xbfeccccccccccce0, 0x4010b05e5cf5beaa,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x401090cc27842c0e,
    0x0, 0x0,
    0xbfecccccccccccdb, 0x401071ab3eeb2916,
    0x0, 0x0,
    0xbfecccccccccccb6, 0x401052f93c1b0268,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x401034b3c9479aaf,
    0x0, 0x0,
    0xbfeccccccccccd12, 0x401016d8a14e6c73,
    0x0, 0x0,
    0xbfeccccccccccc94, 0x400ff2cb1e45e1e6,
    0x0, 0x0,
    0xbfecccccccccccc0, 0x400fb8b0da8239df,
    0x0, 0x0,
    0xbfeccccccccccce2, 0x400f7f5e4a4b52cb,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x400f46cf5d97c2d8,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x400f0f0020616572,
    0x0, 0x0,
    0xbfecccccccccccbf, 0x400ed7ecb9b583cb,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x400ea1916ace8d12,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x400e6bea8e36ed42,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x400e36f496f497c5,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x400e02ac0fbcdfb2,
    0x0, 0x0,
    0xbfecccccccccccde, 0x400dcf0d9a303e38,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x400d9c15ee1daad2,
    0x0, 0x0,
    0xbfecccccccccccbf, 0x400d69c1d8cd2f32,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x400d380e3c5164ba,
    0x0, 0x0,
    0xbfecccccccccccbc, 0x400d06f80edf8cd4,
    0x0, 0x0,
    0xbfeccccccccccd40, 0x400cd67c5a2dfa54,
    0x0, 0x0,
    0xbfeccccccccccc61, 0x400ca6983ad8852a,
    0x0, 0x0,
    0xbfecccccccccccdd, 0x400c7748dfcac5b3,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x400c488b89afd780,
    0x0, 0x0,
    0xbfecccccccccccdb, 0x400c1a5d8a676748,
    0x0, 0x0,
    0xbfecccccccccccca, 0x400becbc447fd1fc,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x400bbfa52ab51ed6,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x400b9315bf749f37,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x400b670b9465036b,
    0x0, 0x0,
    0xbfecccccccccccd9, 0x400b3b8449f2b42e,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x400b107d8ee044b8,
    0x0, 0x0,
    0xbfecccccccccccd7, 0x400ae5f51fdad145,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x400abbe8c71221f0,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x400a92565bd46a15,
    0x0, 0x0,
    0xbfecccccccccccb8, 0x400a693bc22d7f8a,
    0x0, 0x0,
    0xbfecccccccccccdd, 0x400a4096ea8965a2,
    0x0, 0x0,
    0xbfecccccccccccf8, 0x400a1865d15a0a00,
    0x0, 0x0,
    0xbfeccccccccccca1, 0x4009f0a67ec01331,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x4009c9570636a192,
    0x0, 0x0,
    0xbfecccccccccccdd, 0x4009a2758641e54c,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x40097c0028206d08,
    0x0, 0x0,
    0xbfecccccccccccda, 0x400955f51f7f11e8,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x40093052aa2f67e6,
    0x0, 0x0,
    0xbfecccccccccccce, 0x40090b170fe098f0,
    0x0, 0x0,
    0xbfecccccccccccbe, 0x4008e640a1da9398,
    0x0, 0x0,
    0xbfecccccccccccdc, 0x4008c1cdbabb76cb,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x40089dbcbe3724aa,
    0x0, 0x0,
    0xbfecccccccccccd9, 0x40087a0c18d8e836,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x400856ba3fc7199c,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x400833c5b088ae55,
    0x0, 0x0,
    0xbfecccccccccccb7, 0x4008112cf0cca30d,
    0x0, 0x0,
    0xbfecccccccccccac, 0x4007eeee8e332dc3,
    0x0, 0x0,
    0xbfecccccccccccbb, 0x4007cd091e18a75c,
    0x0, 0x0,
    0xbfeccccccccccced, 0x4007ab7b3d621cf4,
    0x0, 0x0,
    0xbfecccccccccccec, 0x40078a43904b797e,
    0x0, 0x0,
    0xbfeccccccccccce0, 0x40076960c23738bc,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x400748d1857f95f2,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x4007289493492862,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x400708a8ab56e0f6,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x4006e90c93df5c48,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x4006c9bf19637d5a,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x4006aabf0e864564,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x40068c0b4be5dde5,
    0x0, 0x0,
    0xbfecccccccccccca, 0x40066da2aff5c9e0,
    0x0, 0x0,
    0xbfecccccccccccc0, 0x40064f841eda34ef,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x400631ae82445572,
    0x0, 0x0,
    0xbfecccccccccccb4, 0x40061420c94fd965,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x4005f6d9e8615417,
    0x0, 0x0,
    0xbfeccccccccccceb, 0x4005d9d8d905a46b,
    0x0, 0x0,
    0xbfecccccccccccb7, 0x4005bd1c99d24b78,
    0x0, 0x0,
    0xbfecccccccccccbe, 0x4005a0a42e46aaf6,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x4005846e9eae2478,
    0x0, 0x0,
    0xbfecccccccccccce, 0x4005687af8031163,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x40054cc84bd28cac,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x40053155b02107e0,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x400516223f4fa42e,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x4004fb2d18024994,
    0x0, 0x0,
    0xbfecccccccccccd9, 0x4004e0755d0675d4,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x4004c5fa353abd50,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x4004abbacb76f818,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x400491b64e7515b9,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x400477ebf0ba925a,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x40045e5ae8828850,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x400445026fa85927,
    0x0, 0x0,
    0xbfeccccccccccd10, 0x40042be1c392e8d7,
    0x0, 0x0,
    0xbfeccccccccccc8e, 0x400412f82520680c,
    0x0, 0x0,
    0xbfecccccccccccd7, 0x4003fa44d892a698,
    0x0, 0x0,
    0xbfecccccccccccce, 0x4003e1c7257bed45,
    0x0, 0x0,
    0xbfecccccccccccdf, 0x4003c97e56ac5706,
    0x0, 0x0,
    0xbfecccccccccccbf, 0x4003b169ba1fa8d9,
    0x0, 0x0,
    0xbfecccccccccccce, 0x40039988a0eba298,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x400381da5f2ec5e0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x40036a5e4bff8f03,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x40035313c15c1cf8,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x40033bfa1c1a44f0,
    0x0, 0x0,
    0xbfecccccccccccdf, 0x40032510bbd80ddc,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x40030e5702ec917b,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x4002f7cc56593f6a,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x4002e1701dbb7fb2,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x4002cb41c33eb1b8,
    0x0, 0x0,
    0xbfeccccccccccd04, 0x4002b540b38e84e6,
    0x0, 0x0,
    0xbfecccccccccccaf, 0x40029f6c5dc9a8ee,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x400289c43374d211,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x40027447a86e1057,
    0x0, 0x0,
    0xbfecccccccccccd9, 0x40025ef632e0762a,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x400249cf4b380c96,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x400234d26c161314,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x40021fff12458867,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x40020b54bcaffaa8,
    0x0, 0x0,
    0xbfecccccccccccb0, 0x4001f6d2ec529c8c,
    0x0, 0x0,
    0xbfeccccccccccce9, 0x4001e27924339da5,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x4001ce46e957c46a,
    0x0, 0x0,
    0xbfecccccccccccb8, 0x4001ba3bc2b8472f,
    0x0, 0x0,
    0xbfeccccccccccc7b, 0x4001a6573938e355,
    0x0, 0x0,
    0xbfeccccccccccd01, 0x40019298d79e302f,
    0x0, 0x0,
    0xbfecccccccccccf2, 0x40017f002a842cd9,
    0x0, 0x0,
    0xbfeccccccccccc58, 0x40016b8cc05505fe,
    0x0, 0x8000000000000000,
    0xbfeccccccccccd41, 0x4001583e29401360,
    0x0, 0x0,
    0xbfeccccccccccca5, 0x40014513f7310bc4,
    0x0, 0x0,
    0xbfeccccccccccc91, 0x4001320dbdc76b6b,
    0x0, 0x0,
    0xbfeccccccccccd21, 0x40011f2b124e0f40,
    0x0, 0x0,
    0xbfeccccccccccce1, 0x40010c6b8bb30097,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x4000f9cec27f7106,
    0x0, 0x0,
    0xbfecccccccccccb1, 0x4000e75450cfe5ab,
    0x0, 0x0,
    0xbfecccccccccccec, 0x4000d4fbd24c8fa9,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x4000c2c4e421d169,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x4000b0af24f8eecf,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x40009eba34f0e7cb,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x40008ce5b5977bfb,
    0x0, 0x0,
    0xbfecccccccccccbf, 0x40007b3149e2560b,
    0x0, 0x0,
    0xbfecccccccccccc1, 0x4000699c96285e33,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x40005827401b32a4,
    0x0, 0x0,
    0xbfeccccccccccce8, 0x400046d0eec0c4a8,
    0x0, 0x0,
    0xbfeccccccccccc9e, 0x400035994a6d1a29,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x4000247ffcbc31bf,
    0x0, 0x0,
    0xbfecccccccccccca, 0x40001384b08c0990,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x400002a711f6c6f8,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fffe3cd9c99fd92,
    0x0, 0x0,
    0xbfecccccccccccbb, 0x3fffc28728203add,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fffa17a25d9db3e,
    0x0, 0x0,
    0xbfecccccccccccbf, 0x3fff80a5f76c7aa4,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fff600a00bf3fca,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fff3fa5a7f099e7,
    0x0, 0x0,
    0xbfecccccccccccc1, 0x3fff1f78554c362f,
    0x0, 0x0,
    0xbfecccccccccccd7, 0x3ffeff8173412b8a,
    0x0, 0x0,
    0xbfecccccccccccbd, 0x3ffedfc06e585b7f,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3ffec034b52b06c2,
    0x0, 0x0,
    0xbfecccccccccccb7, 0x3ffea0ddb859948f,
    0x0, 0x0,
    0xbfeccccccccccd0b, 0x3ffe81baea828ae2,
    0x0, 0x0,
    0xbfeccccccccccc91, 0x3ffe62cbc039b708,
    0x0, 0x0,
    0xbfecccccccccccd9, 0x3ffe440fafff84e0,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3ffe25863238844b,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x3ffe072ec1251aee,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x3ffde908d8d96176,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3ffdcb13f7352be1,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ffdad4f9bdc3b0f,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3ffd8fbb482e96d8,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3ffd72567f410fda,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3ffd5520c5d5e810,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ffd3819a255a0fa,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x3ffd1b409cc7eecf,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ffcfe953ecccf9c,
    0x0, 0x0,
    0xbfecccccccccccbd, 0x3ffce2171395c5c1,
    0x0, 0x0,
    0xbfecccccccccccd7, 0x3ffcc5c5a7df34b1,
    0x0, 0x0,
    0xbfecccccccccccde, 0x3ffca9a089e9df3c,
    0x0, 0x0,
    0xbfecccccccccccb8, 0x3ffc8da7497486da,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3ffc71d977b5aac2,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3ffc5636a75566b1,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ffc3abe6c67701d,
    0x0, 0x0,
    0xbfecccccccccccda, 0x3ffc1f705c65310a,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ffc044c0e2800ce,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3ffbe95119e378e2,
    0x0, 0x0,
    0xbfecccccccccccbe, 0x3ffbce7f191fe5b2,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3ffbb3d5a6b4d313,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ffb99545ec3b30f,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ffb7efadeb29f00,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ffb64c8c527323f,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ffb4abdb2017da2,
    0x0, 0x0,
    0xbfecccccccccccbe, 0x3ffb30d946571384,
    0x0, 0x0,
    0xbfecccccccccccb9, 0x3ffb171b246e2bb5,
    0x0, 0x0,
    0xbfecccccccccccbe, 0x3ffafd82efb8deb0,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x3ffae4104cd077ac,
    0x0, 0x0,
    0xbfecccccccccccdd, 0x3ffacac2e170dd3c,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3ffab19a54740f74,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ffa98964dcdbbc0,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ffa7fb67686e56e,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3ffa66fa78b9a2fe,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ffa4e61ff8cef3b,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3ffa35ecb7308e0a,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ffa1d9a4cd9045e,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ffa056a6ebba33e,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff9ed5ccc0aa4a0,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3ff9d57114f15ae6,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff9bda6fa907173,
    0x0, 0x0,
    0xbfecccccccccccba, 0x3ff9a5fe2efa3ef8,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ff98e76652f2848,
    0x0, 0x0,
    0xbfeccccccccccce0, 0x3ff9770f511a13d3,
    0x0, 0x0,
    0xbfecccccccccccba, 0x3ff95fc8a78ced96,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3ff948a21e3d3a41,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ff9319b6bc0baca,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff91ab4478a1e8c,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff903ec69e5c44c,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x3ff8ed438bf68a62,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ff8d6b967b2aca2,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3ff8c04db7e0b07d,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3ff8aa0038145ee9,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3ff893d0a4abcb94,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ff87dbebacc697c,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff867ca38602c12,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff851f2dc12b572,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x3ff83c38654e909e,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3ff8269a943a783c,
    0x0, 0x0,
    0xbfecccccccccccf6, 0x3ff8111929b6a8ba,
    0x0, 0x0,
    0xbfecccccccccccaa, 0x3ff7fbb3e75a3f0a,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff7e66a8f70a106,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff7d13ce4f6f3b9,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3ff7bc2aab9999e2,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ff7a733a7b1bf16,
    0x0, 0x0,
    0xbfecccccccccccc0, 0x3ff792579e42eca4,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff77d9654f8a92c,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ff768ef9224221a,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ff754631cb9df37,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3ff73ff0bc4f8024,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff72b9839198308,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff717595be9151e,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff70333ee29ebe4,
    0x0, 0x0,
    0xbfecccccccccccc0, 0x3ff6ef27b9e027fc,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3ff6db3489a64065,
    0x0, 0x0,
    0xbfeccccccccccce1, 0x3ff6c75a28aaf699,
    0x0, 0x0,
    0xbfecccccccccccba, 0x3ff6b39862af5353,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff69fef0404ab2f,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff68c5dd98aac61,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3ff678e4b0ad73b3,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3ff665835763a994,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3ff652399c2ca73d,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ff63f074e0ea31c,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff62bec3c94e4e0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff618e837ce00c0,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3ff605fb104a1a14,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3ff5f32497192ccf,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3ff5e0649dc95e2d,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff5cdbaf66553a8,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3ff5bb27737291b4,
    0x0, 0x0,
    0xbfecccccccccccba, 0x3ff5a8a9e7efdf40,
    0x0, 0x0,
    0xbfecccccccccccfe, 0x3ff596422753b1bb,
    0x0, 0x0,
    0xbfeccccccccccc99, 0x3ff583f0058a9d95,
    0x0, 0x0,
    0xbfecccccccccccda, 0x3ff571b356f5ce60,
    0x0, 0x0,
    0xbfecccccccccccc1, 0x3ff55f8bf06983d4,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff54d79a72b961a,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3ff53b7c50f1fe48,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff52993c3e166bf,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff517bfd68bbf1c,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff506005feed73a,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3ff4f4553772fec8,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff4e2be34e9aae7,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ff4d13b308c206d,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff4bfcc02fa23ce,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff4ae708538add4,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x3ff49d2890b0a58a,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff48bf3ff2d9ee8,
    0x0, 0x0,
    0xbfecccccccccccdd, 0x3ff47ad2aadc9e62,
    0x0, 0x0,
    0xbfecccccccccccbc, 0x3ff469c46e4ae14c,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff458c92464aa82,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff447e0a874145e,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff4370ad61fe67c,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3ff42647896a7014,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3ff415969eb066ff,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ff404f7f2a7caa6,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff3f46b625ecb42,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3ff3e3f0cb3ab53e,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff3d3880af6e09d,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff3c330ffa3a470,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff3b2eb87a54e23,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3ff3a2b781b31c92,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff39294ccd63f15,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x3ff382834868d82c,
    0x0, 0x0,
    0xbfecccccccccccfb, 0x3ff37282d41503ca,
    0x0, 0x0,
    0xbfeccccccccccca3, 0x3ff362934fd3e158,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3ff352b49beca0d2,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3ff342e698f39448,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3ff3332927c943d5,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff3237c2999854f,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3ff313df7fda9788,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff304530c4c406a,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ff2f4d6b0f6ee79,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff2e56a502add67,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ff2d60dcc7f3ddc,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff2c6c108d16022,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff2b783e843e1ee,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ff2a8564e3ddefd,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x3ff299381e6a24bb,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ff28a293cb668a4,
    0x0, 0x0,
    0xbfecccccccccccdf, 0x3ff27b298d52817e,
    0x0, 0x0,
    0xbfecccccccccccbc, 0x3ff26c38f4afa361,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3ff25d57577f9e3e,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff24e849ab41f76,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff23fc0a37df5c2,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ff2310b574c5798,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3ff222649bcc2c88,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff213cc56e758b6,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3ff205426ec40af1,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3ff1f6c6c9c40d2d,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ff1e8594e84177d,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ff1d9f9e3db2528,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff1cba870d9cc4b,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3ff1bd64dcc997a2,
    0x0, 0x0,
    0xbfecccccccccccbf, 0x3ff1af2f0f2c628e,
    0x0, 0x0,
    0xbfecccccccccccbd, 0x3ff1a106efbbb75c,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x3ff192ec66682fa3,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x3ff184df5b58d6ce,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x3ff176dfb6ea8eef,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ff168ed61af7731,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff15b08446e54c7,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3ff14d304821fd90,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3ff13f6555f8c4ea,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3ff131a75753ea5a,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3ff123f635c70a19,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff11651db178f7e,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ff108ba313c297f,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ff0fb2f225c4095,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff0edb098cf6ef3,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff0e03e7f1cfa05,
    0x0, 0x0,
    0xbfecccccccccccbd, 0x3ff0d2d8bffb4e0b,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff0c57f464f7b39,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x3ff0b831fd2cb494,
    0x0, 0x0,
    0xbfecccccccccccbf, 0x3ff0aaf0cfd3d09c,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ff09dbba9b2cb20,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3ff0909276644987,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff0837521af1ff0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff076639785d80e,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3ff0695dc40639e0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff05c639378d5a4,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ff04f74f2508f53,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3ff04291cd2a2ba8,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff035ba10cbdeae,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff028edaa24db80,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x3ff01c2c864ce5a6,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3ff00f769283e3d8,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ff002cbbc3173ef,
    0x0, 0x0,
    0xbfecccccccccccbf, 0x3fefec57e1c90122,
    0x0, 0x0,
    0xbfecccccccccccda, 0x3fefd32e3ca5aef9,
    0x0, 0x0,
    0xbfecccccccccccbb, 0x3fefba1a64b184d0,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fefa11c35f13e34,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fef88338cb4f730,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fef6f60459761a2,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3fef56a23d7d0094,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fef3df9519364c8,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fef25655f506bd5,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fef0ce644718184,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3feef47bdefae3c8,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x3feedc260d36e8e0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3feec3e4adb5478b,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3feeabb79f4a61f7,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3fee939ec10e9220,
    0x0, 0x0,
    0xbfecccccccccccbf, 0x3fee7b99f25d797a,
    0x0, 0x0,
    0xbfecccccccccccdb, 0x3fee63a912d5518f,
    0x0, 0x0,
    0xbfecccccccccccdd, 0x3fee4bcc02563f7a,
    0x0, 0x0,
    0xbfecccccccccccbd, 0x3fee3402a101a961,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fee1c4ccf398d6c,
    0x0, 0x0,
    0xbfecccccccccccb9, 0x3fee04aa6d9fdbf5,
    0x0, 0x0,
    0xbfecccccccccccbe, 0x3feded1b5d15d248,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fedd59f7ebb5846,
    0x0, 0x0,
    0xbfecccccccccccbd, 0x3fedbe36b3ee5ff0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3feda6e0de4a467c,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fed8f9ddfa7376a,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fed786d9a199186,
    0x0, 0x0,
    0xbfecccccccccccac, 0x3fed614feff14e2c,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fed4a44c3b9698e,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fed334bf8374d12,
    0x0, 0x0,
    0xbfeccccccccccd0f, 0x3fed1c65706a3bd9,
    0x0, 0x0,
    0xbfeccccccccccc8a, 0x3fed05910f8ac07d,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3feceeceb90a1cff,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fecd81e5091ba6a,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fecc17fba02a26a,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fecaaf2d974e5ff,
    0x0, 0x0,
    0xbfeccccccccccd0a, 0x3fec94779337257d,
    0x0, 0x0,
    0xbfeccccccccccc8f, 0x3fec7e0dcbcdfad9,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fec67b567f37912,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fec516e4c96a60e,
    0x0, 0x0,
    0xbfecccccccccccec, 0x3fec3b385edaf72c,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fec25138417cf46,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fec0effa1d7fe2a,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3febf8fc9dd9423c,
    0x0, 0x0,
    0xbfecccccccccccdd, 0x3febe30a5e0bc9f0,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3febcd28c891b886,
    0x0, 0x0,
    0xbfecccccccccccde, 0x3febb757c3beab28,
    0x0, 0x0,
    0xbfecccccccccccd9, 0x3feba19736173fb5,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3feb8be706509ccc,
    0x0, 0x0,
    0xbfecccccccccccdd, 0x3feb76471b4ffb21,
    0x0, 0x0,
    0xbfecccccccccccbd, 0x3feb60b75c2a30da,
    0x0, 0x0,
    0xbfecccccccccccbb, 0x3feb4b37b0233cef,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3feb35c7feadd54a,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3feb20682f6af560,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3feb0b182a296dc7,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3feaf5d7d6e5762b,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3feae0a71dc83f30,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x3feacb85e72786b8,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x3feab6741b852c74,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3feaa171a38ec825,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fea8c7e681d4108,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3fea779a52346644,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fea62c54b028862,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fea4dff3be01430,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fea39480e4f2eb4,
    0x0, 0x0,
    0xbfeccccccccccceb, 0x3fea249fabfb51f0,
    0x0, 0x0,
    0xbfecccccccccccba, 0x3fea1005feb8eb69,
    0x0, 0x0,
    0xbfecccccccccccdf, 0x3fe9fb7af084fa32,
    0x0, 0x0,
    0xbfecccccccccccc0, 0x3fe9e6fe6b84b09e,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fe9d2905a051460,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3fe9be30a67aa12c,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fe9a9df3b80ec10,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe9959c03da47cc,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe98166ea6f69e1,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe96d3fda4f10fe,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe95926beadac68,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe9451b82e503d8,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe9311e1273e0dc,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe91d2e58fdb8f0,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fe9094c424a584e,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fe8f577ba458e0f,
    0x0, 0x0,
    0xbfecccccccccccd7, 0x3fe8e1b0acfed8cf,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fe8cdf706a914a8,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe8ba4ab39a2922,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe8a6aba04ab97e,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe89319b955d482,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fe87f94eb78a576,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fe86c1d2392268a,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe858b24ea2d356,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe8455459cc5ca4,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x3fe8320332515ca2,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fe81ebec5950c54,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe80b87011af954,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe7f85bd286bcd0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe7e53d279bb2de,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fe7d22aee3cb2e2,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fe7bf25146bc876,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fe7ac2b8849ed5b,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3fe7993e3816c3ae,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3fe7865d12305190,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe773880512bc94,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe760beff5806ab,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe74e01efb7cb36,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fe73b50c506fd50,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fe728ab6e37a646,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe71611da58a506,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fe70383f8956df2,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe6f101b835cbe7,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe6de8b089da0fc,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe6cc1fd94ca910,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe6b9c019de3bbb,
    0x0, 0x0,
    0xbfecccccccccccc1, 0x3fe6a76bba091003,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fe69522a99effd8,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3fe682e4d88ccc92,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x3fe670b236d9e424,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fe65e8ab4a82613,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe64c6e4233aa86,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe63a5ccfd2887a,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe628564df49d0c,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fe6165aad2353c0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe60469de016e98,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe5f283d14acf5a,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fe5e0a877d440de,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe5ced7c28b417b,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fe5bd11a275cd4c,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe5ab5608b22996,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe599a4e676b056,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3fe587fe2d119c70,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe57661cde8d694,
    0x0, 0x0,
    0xbfecccccccccccdb, 0x3fe564cfba79c200,
    0x0, 0x0,
    0xbfecccccccccccbf, 0x3fe55347e4590b3d,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fe541ca3d32742c,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe53056b6c8a58a,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fe51eed42f4fbcc,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe50d8dd3a757d6,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3fe4fc385ae5eec9,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe4eaeccacd1aaa,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe4d9ab158f2b59,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe4c8732d7437f8,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe4b74504d9f114,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe4a6208e3372be,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe49505bc091784,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe483f480f84b84,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x3fe472eccfb36044,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe461ee9b0160bb,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3fe450f9d5bde5b8,
    0x0, 0x0,
    0xbfecccccccccccc1, 0x3fe4400e72d8eb10,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe42f2c6556a457,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe41e53a04f5378,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe40d8416ef1e40,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fe3fcbdbc75e4ec,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fe3ec008437195e,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe3db4c6199961e,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe3caa148177640,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x3fe3b9ff2b3ded6b,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe3a965fead201f,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fe398d5b617fcc6,
    0x0, 0x0,
    0xbfecccccccccccc1, 0x3fe3884e454414b5,
    0x0, 0x0,
    0xbfecccccccccccdd, 0x3fe377cfa00975ad,
    0x0, 0x0,
    0xbfecccccccccccbd, 0x3fe36759ba5283f0,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe356ec881bd47c,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3fe34687fd74070e,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fe3362c0e7ba2a6,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe325d8af64ee28,
    0x0, 0x0,
    0xbfecccccccccccd9, 0x3fe3158dd473cf21,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x3fe3054b71fda32d,
    0x0, 0x0,
    0xbfecccccccccccdd, 0x3fe2f5117c691da6,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fe2e4dfe82e23de,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fe2d4b6a9d5a9f7,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fe2c495b5f99047,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe2b47d014480e8,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe2a46c8071cda3,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe29464284d4e0e,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe28463edb33e30,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe2746bc5901d1e,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fe2647ba4e08c5e,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fe2549380b12f0a,
    0x0, 0x0,
    0xbfecccccccccccda, 0x3fe244b34e1e89b2,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3fe234db0254e276,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe2250a929020ba,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe21541f41bae85,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe205811c5258f8,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fe1f5c8009e312d,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fe1e61696786e0f,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe1d66cd3694dc8,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fe1c6caad07f7d2,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3fe1b73018fa5f04,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe1a79d0cf5243b,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe198117ebb78e8,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe1888d641f0253,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe17910b2ffbc7c,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe1699b614bddda,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fe15a2d64ffbb2b,
    0x0, 0x0,
    0xbfeccccccccccce4, 0x3fe14ac6b425ab23,
    0x0, 0x0,
    0xbfecccccccccccba, 0x3fe13b6744d5eb65,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3fe12c0f0d368388,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fe11cbe037b2bb9,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fe10d741de5303d,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe0fe3152c3574b,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fe0eef59871c640,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fe0dfc0e559e763,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe0d0932ff24fd6,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe0c16c6ebea57e,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe0b24c984f859c,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe0a333a3426b21,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fe09421864195a5,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe085163803f038,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3fe07611af4cf8c1,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe06713e2eca746,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x3fe0581cc9bf55a8,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x3fe0492c5aada78a,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe03a428cac71e1,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe02b5f56bca3e8,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe01c82afeb2f3e,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe00dac8f50f040,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fdffdb9d8252eb0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fdfe0277ac1238a,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fdfc2a1f4ede5da,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fdfa529353abb58,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fdf87bd2a4ddc34,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fdf6a5dc2e44650,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fdf4d0aedd19190,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fdf2fc499ffc3d2,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3fdf128ab66f25f6,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fdef55d3236189a,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fded83bfc80e9ae,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fdebb270491aa30,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3fde9e1e39c00474,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fde81218b791242,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fde6430e93f33b8,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fde474c42a9e66c,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fde2a7387659d0e,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fde0da6a7339714,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fddf0e591e9b8c4,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fddd430377263aa,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fddb78687cc4fca,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fdd9ae8730a63c6,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fdd7e55e9538f56,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fdd61cedae2a41c,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x3fdd455338063064,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fdd28e2f12058d6,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fdd0c7df6a6b382,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fdcf024392222e2,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fdcd3d5a92eb04c,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fdcb792377b686c,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fdc9b59d4ca36e6,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fdc7f2c71efc1b4,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fdc6309ffd34668,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fdc46f26f6e765e,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fdc2ae5b1cd53c6,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fdc0ee3b80e0ede,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fdbf2ec7360e39c,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fdbd6ffd507f71c,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fdbbb1dce5735e8,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fdb9f4650b43228,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fdb83794d960254,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fdb67b6b6852010,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3fdb4bfe7d1b4690,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fdb3050930353f8,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fdb14ace9f9250c,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fdaf91373c97a18,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fdadd842251d2bc,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fdac1fee78050ba,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fdaa683b5539734,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fda8b127ddaaca4,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fda6fab3334dafe,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fda544dc7919152,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fda38fa2d3045a0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fda1db0566055fc,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fda02703580eb42,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fd9e739bd00da84,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fd9cc0cdf5e885e,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd9b0e98f27cafa,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x3fd995cfbef9cce0,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fd97abf6180f162,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd95fb86978b57c,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fd944bac9ab95d2,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fd929c674f2f140,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd90edb5e36ece6,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fd8f3f9786e585a,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fd8d920b69e9242,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd8be510bdb6cd8,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd8a38a6b471296,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3fd888ccc811eada,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd86e18157a8084,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fd8536c46cd6546,
    0x0, 0x0,
    0xbfecccccccccccbf, 0x3fd838c94f6518fe,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3fd81e2f22a9ed8a,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3fd8039db411f04e,
    0x0, 0x0,
    0xbfecccccccccccb7, 0x3fd7e914f720cc74,
    0x0, 0x0,
    0xbfeccccccccccce0, 0x3fd7ce94df67b160,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fd7b41d60853ef6,
    0x0, 0x0,
    0xbfecccccccccccbf, 0x3fd799ae6e2563aa,
    0x0, 0x0,
    0xbfecccccccccccdd, 0x3fd77f47fc0149a6,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fd764e9fddf3d02,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd74a946792902c,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fd730472cfb862a,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fd71602420738ae,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd6fbc59aaf8150,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd6e1912afadfc6,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd6c764e6fc6322,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd6ad40c2d391fe,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fd69324b2ac52b4,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3fd67910aabed3f2,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fd65f049f4f75e8,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fd6450084aeb2d2,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x3fd62b044f3908c8,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fd6110ff356e140,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fd5f723657c7d4c,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd5dd3e9a29dcb4,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fd5c36185eaa8d8,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fd5a98c1d561e84,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd58fbe550ef7ac,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fd575f821c3561c,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fd55c39782cad48,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd542824d0fad44,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fd528d2953c2d14,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd50f2a458d1598,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd4f58952e84ccc,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fd4dbefb23e9ff8,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x3fd4c25d588bb014,
    0x0, 0x0,
    0xbfecccccccccccde, 0x3fd4a8d23ad5dc10,
    0x0, 0x0,
    0xbfecccccccccccc0, 0x3fd48f4e4e2e2de8,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3fd475d187b04348,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fd45c5bdc823d2c,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fd442ed41d4a8f0,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fd42985ace26d58,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd4102512f0b6cc,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd3f6cb694ee39c,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd3dd78a5567030,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd3c42cbc6ae3b4,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd3aae7a3f9bd30,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd391a9517a5fc4,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd37871ba6dfff4,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fd35f40d45f9078,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fd3461694e3afd4,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fd32cf2f1989514,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fd313d5e025fdf4,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fd2fabf563d1be8,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd2e1af49988178,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fd2c8a5affc1108,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd2afa27f34ea2c,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fd296a5ad195748,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd27daf2f88bc7c,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fd264befc6b8548,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fd24bd509b3135c,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fd232f14d59ac7c,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fd21a13bd6269d4,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd2013c4fd925f0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd1e86afad26c04,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fd1cf9fb46b668c,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fd1b6da72c9ce7c,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fd19e1b2c1bda34,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd18561d6982cb8,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fd16cae687dc51c,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fd15400d813ee28,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd13b591baa2d58,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fd122b7299832b8,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fd10a1af83dc898,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fd0f1847e02c380,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd0d8f3b156f1e4,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fd0c06888b20c58,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd0a7e2fa93a564,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd08f62fd831a24,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fd076e8880f8210,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fd05e7390cf9fc4,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd046040e61d120,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fd02d99f76c0060,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd01535429b940c,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fcff9abcd4ac0a0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fcfc8f7b48b2fd0,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fcf984e287f77b8,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fcf67af16bd1c40,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fcf371a6ce803b0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fcf069018b25898,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fced61007dc6d50,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fcea59a28349e20,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fce752e67973488,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fce44ccb3ee4960,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fce1474fb31a950,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fcde4272b66b6e0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fcdb3e332a04ee0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fcd83a8fefeaba0,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fcd53787eaf4880,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fcd23519fecc6b0,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fccf33450fed018,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fccc3208039fea0,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fcc93161bffb9e0,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fcc631512be24c0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fcc331d52effac0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fcc032ecb1c78b8,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fcbd34969d74040,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fcba36d1dc03d68,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fcb7399d5838bf0,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fcb43cf7fd95c98,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fcb140e0b85dae0,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fcae45567591250,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fcab4a5822ed4e0,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fca84fe4aeea020,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fca555fb08b8450,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fca25c9a2040970,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fc9f63c0e6216e8,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fc9c6b6e4bad998,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fc9973a142ea868,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fc967c58be8eef8,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fc938593b201170,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fc908f5111553f0,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fc8d998fd14c2f8,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fc8aa44ee751900,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fc87af8d497a720,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fc84bb49ee83ba0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc81c783cdd0a60,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fc7ed439df69350,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fc7be16b1bf8c10,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x3fc78ef167ccc560,
    0x0, 0x0,
    0xbfecccccccccccd7, 0x3fc75fd3afbd1690,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x3fc730bd793941d0,
    0x0, 0x0,
    0xbfeccccccccccce4, 0x3fc701aeb3f3df00,
    0x0, 0x0,
    0xbfecccccccccccb4, 0x3fc6d2a74fa944c0,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3fc6a3a73c1f6c80,
    0x0, 0x0,
    0xbfecccccccccccbc, 0x3fc674ae6925e170,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3fc645bcc695a400,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fc616d244511480,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc5e7eed243dd30,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc5b9126062d960,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x3fc58a3cdeabff70,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fc55b6e3d2649d0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc52ca66be1a0c0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc4fde55af6c2d0,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fc4cf2afa872f60,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc4a0773abd0fa0,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fc471ca0bcb2000,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fc443235dec9ac0,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fc4148321652120,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc3e5e94680a670,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fc3b755bd935770,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fc388c876f98820,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fc35a4163179b60,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fc32bc07259ee20,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc2fd459534c190,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc2ced0bc2425f0,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fc2a061d7abe500,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fc271f8d8576c30,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fc24395aeb9b8a0,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fc215384b6d4020,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fc1e6e09f13dda0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fc1b88e9a56bbb0,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fc18a422de63f00,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x3fc15bfb4a79f2c0,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x3fc12db9e0d071f0,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x3fc0ff7de1af5650,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fc0d1473de31d10,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fc0a315e63f1aa0,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fc074e9cb9d5fe0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc046c2dedea830,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fc018a110ea44d0,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fbfd508a55c11a0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fbf78d92a3c68a0,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fbf1cb3926ac100,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fbec097bfe8d8c0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fbe648594c4ce80,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fbe087cf318fc80,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fbdac7dbd0bcf20,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fbd5087d4cf9e20,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fbcf49b1ca28420,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fbc98b776ce3900,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fbc3cdcc5a7e9e0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fbbe10aeb900f00,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fbb8541caf24a80,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fbb298146453dc0,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fbacdc9400a6280,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fba72199acde5a0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fba167239268000,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fb9bad2fdb55040,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fb95f3bcb25b340,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fb903ac842d2040,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fb8a8250b8b0100,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fb84ca544088c80,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fb7f12d10789f80,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fb795bc53b799c0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fb73a52f0ab3500,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fb6def0ca426200,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fb68395c37521c0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fb62841bf446040,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fb5ccf4a0b9cf80,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fb571ae4ae7c1c0,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fb5166ea0e90400,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fb4bb3585e0ba80,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fb46002dcfa3a80,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fb404d68968e600,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fb3a9b06e680600,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fb34e906f3aa7c0,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fb2f3766f2b7580,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fb29862518c9480,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fb23d53f9b77ec0,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fb1e24b4b0cdf00,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fb1874828f46d80,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fb12c4a76dcca00,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fb0d152183b5a00,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fb0765ef08c2000,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fb01b70e3519d80,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3faf810fa8295780,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3faecb474cc8ae80,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fae15887bab7b00,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fad5fd2fc07d080,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3facaa26951f5580,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fabf4830e3ef880,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fab3ee82ebeaf80,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3faa8955be012780,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fa9d3cb83738700,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fa91e49468d2100,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fa868cececf3100,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fa7b35be3c49100,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fa6fdf04d017900,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3fa6488bd2233700,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fa5932e3acfd900,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fa4ddd74eb60600,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fa42886d58c9d00,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fa3733c97127800,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fa2bdf85b0e2900,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fa208b9e94db000,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fa1538109a63400,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fa09e4d83f3c000,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3f9fd23e40320000,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3f9e67eb4bfdec00,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3f9cfda1bb296a00,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3f9b93611d9e4400,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3f9a292903514000,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3f98bef8fc41b800,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3f9754d098790800,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3f95eaaf6809dc00,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3f948094fb0fe000,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3f931680e1af0400,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3f91ac72ac132800,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3f904269ea6f5400,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3f8db0cc59faa800,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3f8adcce07fa4000,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3f8808d7ff68d000,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3f8534e960dbb000,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3f8261014cf1e000,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3f7f1a3dc8a38000,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3f7972828f528000,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3f73cacf2f57c000,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3f6c4643d4488000,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3f60f6f202620000,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3f469e95afe00000,
    0x0
    };

static const uint64_t ref_rfft_step_4096[4097] = {
    0x409ccccccccccccd, 0x0,
    0xbfeccccccccccd34, 0x409255ab59b0d91d,
    0x0, 0x8000000000000000,
    0xbfeccccccccccce7, 0x407872374985cccb,
    0x0, 0x0,
    0xbfeccccccccccf89, 0x406d55d5e9ab64d0,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x4064f4249e29f05e,
    0x0, 0x8000000000000000,
    0xbfecccccccccccd2, 0x40604c15c7477297,
    0x0, 0x0,
    0xbfeccccccccccc1d, 0x405aaafea7e4b54b,
    0x0, 0x0,
    0xbfecccccccccccba, 0x405690a22c6ee735,
    0x0, 0x0,
    0xbfeccccccccccc24, 0x40538e5c57b0a394,
    0x0, 0x0,
    0xbfeccccccccccd64, 0x40514152583a6d84,
    0x0, 0x0,
    0xbfeccccccccccc89, 0x404ee091ba6ea2bb,
    0x0, 0x0,
    0xbfeccccccccccd32, 0x404befa413e515be,
    0x0, 0x0,
    0xbfeccccccccccca4, 0x404981a57b930dd2,
    0x0, 0x0,
    0xbfeccccccccccce6, 0x404777295eaf9f91,
    0x0, 0x0,
    0xbfeccccccccccc12, 0x4045ba12be3b5a02,
    0x0, 0x0,
    0xbfecccccccccccf3, 0x40443a5e42a9253e,
    0x0, 0x0,
    0xbfecccccccccceaa, 0x4042ec2a79774ee4,
    0x0, 0x8000000000000000,
    0xbfeccccccccccb14, 0x4041c6774233d803,
    0x0, 0x0,
    0xbfeccccccccccc92, 0x4040c25324c11d3b,
    0x0, 0x0,
    0xbfeccccccccccd5c, 0x403fb499f4a797aa,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x403e1422c4e2ef83,
    0x0, 0x0,
    0xbfeccccccccccd0c, 0x403c9c4a1ee5755a,
    0x0, 0x0,
    0xbfeccccccccccc97, 0x403b47650d332402,
    0x0, 0x0,
    0xbfeccccccccccce7, 0x403a10ca8d10587c,
    0x0, 0x0,
    0xbfeccccccccccc91, 0x4038f49cac8f5afc,
    0x0, 0x0,
    0xbfeccccccccccd22, 0x4037ef9f196b9240,
    0x0, 0x0,
    0xbfecccccccccccef, 0x4036ff1770299b8a,
    0x0, 0x0,
    0xbfeccccccccccce2, 0x403620b4b817f80c,
    0x0, 0x0,
    0xbfeccccccccccce6, 0x4035527c389eb4d4,
    0x0, 0x0,
    0xbfeccccccccccc92, 0x403492ba578bc6ee,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x4033dff68b3e84c2,
    0x0, 0x0,
    0xbfeccccccccccc8a, 0x403338e9abdf8da0,
    0x0, 0x0,
    0xbfeccccccccccede, 0x40329c761cbece7a,
    0x0, 0x0,
    0xbfeccccccccccabf, 0x403209a16826134a,
    0x0, 0x0,
    0xbfeccccccccccd10, 0x40317f8f00378e3a,
    0x0, 0x0,
    0xbfecccccccccccf4, 0x4030fd7be962e270,
    0x0, 0x0,
    0xbfecccccccccccf8, 0x403082bb2061722a,
    0x0, 0x0,
    0xbfecccccccccccea, 0x40300eb297c30fb2,
    0x0, 0x0,
    0xbfecccccccccccca, 0x402f41b16180aa16,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x402e716431d1c08e,
    0x0, 0x0,
    0xbfeccccccccccc97, 0x402dab9ff59b8f80,
    0x0, 0x0,
    0xbfecccccccccccfe, 0x402cef9ce6a0dd68,
    0x0, 0x0,
    0xbfecccccccccccce, 0x402c3ca680036d60,
    0x0, 0x0,
    0xbfecccccccccccf4, 0x402b92193a56f04d,
    0x0, 0x0,
    0xbfecccccccccccba, 0x402aef6097b15976,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x402a53f573236c6a,
    0x0, 0x0,
    0xbfeccccccccccc9f, 0x4029bf5c893ab725,
    0x0, 0x0,
    0xbfecccccccccccff, 0x4029312530f6e7a0,
    0x0, 0x0,
    0xbfeccccccccccd5a, 0x4028a8e83e0e9fd0,
    0x0, 0x0,
    0xbfeccccccccccc44, 0x40282647068d6c84,
    0x0, 0x0,
    0xbfeccccccccccca6, 0x4027a8ea86cb3170,
    0x0, 0x0,
    0xbfeccccccccccd20, 0x402730829f881664,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x4026bcc56a9f4c92,
    0x0, 0x0,
    0xbfecccccccccccec, 0x40264d6ea34d9fbd,
    0x0, 0x0,
    0xbfecccccccccccca, 0x4025e23f1f7c142d,
    0x0, 0x0,
    0xbfecccccccccccf1, 0x40257afc57df12c2,
    0x0, 0x0,
    0xbfeccccccccccc9e, 0x4025176ffd0b4b0e,
    0x0, 0x0,
    0xbfeccccccccccd0c, 0x4024b76797e54061,
    0x0, 0x0,
    0xbfecccccccccccde, 0x40245ab43409a693,
    0x0, 0x0,
    0xbfecccccccccccec, 0x4024012a12fd17eb,
    0x0, 0x0,
    0xbfecccccccccccda, 0x4023aaa0671abefa,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x402356f1155c85e4,
    0x0, 0x0,
    0xbfeccccccccccc91, 0x402305f87d35349f,
    0x0, 0x0,
    0xbfeccccccccccc68, 0x4022b79545ce73a0,
    0x0, 0x0,
    0xbfeccccccccccc83, 0x40226ba8301295d8,
    0x0, 0x8000000000000000,
    0xbfeccccccccccd22, 0x40222213ecfceac2,
    0x0, 0x0,
    0xbfeccccccccccd32, 0x4021dabcf7bb9f58,
    0x0, 0x0,
    0xbfeccccccccccd05, 0x40219589733c4768,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x402152610ac85aa3,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x4021112cd56188d9,
    0x0, 0x0,
    0xbfecccccccccccaf, 0x4020d1d73b97017e,
    0x0, 0x0,
    0xbfecccccccccccbc, 0x4020944bdf94d5a8,
    0x0, 0x0,
    0xbfeccccccccccca8, 0x402058778735a438,
    0x0, 0x0,
    0xbfeccccccccccceb, 0x40201e4807e4e856,
    0x0, 0x0,
    0xbfecccccccccccb7, 0x401fcb58684b5416,
    0x0, 0x0,
    0xbfecccccccccccca, 0x401f5d27952c2210,
    0x0, 0x0,
    0xbfecccccccccccb4, 0x401ef1decc991338,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x401e8960e0ddb91d,
    0x0, 0x0,
    0xbfeccccccccccc94, 0x401e239225cdbdc2,
    0x0, 0x0,
    0xbfecccccccccccde, 0x401dc0585836836a,
    0x0, 0x0,
    0xbfeccccccccccd2a, 0x401d5f9a872b35ce,
    0x0, 0x0,
    0xbfeccccccccccc7a, 0x401d0140ff020ba8,
    0x0, 0x0,
    0xbfecccccccccccb3, 0x401ca53535dd8306,
    0x0, 0x0,
    0xbfecccccccccccdf, 0x401c4b61b9a0000a,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x401bf3b21f2b6c30,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x401b9e12f2d155aa,
    0x0, 0x0,
    0xbfecccccccccccb8, 0x401b4a71a9daa104,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x401af8bc95102cb1,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x401aa8e2d42fd8a2,
    0x0, 0x0,
    0xbfecccccccccccf0, 0x401a5ad44a3b3f4e,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x401a0e81928f195a,
    0x0, 0x0,
    0xbfecccccccccccce, 0x4019c3dbf6b3c67e,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x40197ad564d8d19c,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x4019336066ee7fa5,
    0x0, 0x0,
    0xbfecccccccccccb4, 0x4018ed701a519451,
    0x0, 0x0,
    0xbfecccccccccccb8, 0x4018a8f827fe7836,
    0x0, 0x0,
    0xbfeccccccccccd80, 0x401865ecbd41d346,
    0x0, 0x0,
    0xbfeccccccccccc2a, 0x4018244284dd835c,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x4017e3eea0999224,
    0x0, 0x0,
    0xbfecccccccccccca, 0x4017a4e6a3398058,
    0x0, 0x0,
    0xbfeccccccccccce1, 0x401767208aced43c,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x40172a92bb626efb,
    0x0, 0x0,
    0xbfecccccccccccbc, 0x4016ef33f9eeab5c,
    0x0, 0x0,
    0xbfecccccccccccca, 0x4016b4fb67a4c1ef,
    0x0, 0x0,
    0xbfecccccccccccba, 0x40167be07d785b4e,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x401643db07ec9d0e,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x40160ce3231e5950,
    0x0, 0x0,
    0xbfecccccccccccdc, 0x4015d6f137075bbc,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x4015a1fdf3f71c7f,
    0x0, 0x0,
    0xbfecccccccccccce, 0x40156e024f3d66cb,
    0x0, 0x0,
    0xbfecccccccccccae, 0x40153af78003c1c8,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x401508d6fc52a574,
    0x0, 0x0,
    0xbfeccccccccccd10, 0x4014d79a763fbb68,
    0x0, 0x0,
    0xbfeccccccccccc84, 0x4014a73bd9429e23,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x401477b547adb6a2,
    0x0, 0x0,
    0xbfeccccccccccce2, 0x4014490118490348,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x40141b19d40cb9c8,
    0x0, 0x0,
    0xbfecccccccccccce, 0x4013edfa33f9da15,
    0x0, 0x0,
    0xbfecccccccccccbe, 0x4013c19d1f0ee9e6,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x401395fda8572ebc,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x40136b170d12d924,
    0x0, 0x0,
    0xbfeccccccccccce2, 0x401340e4b2f6ae90,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x401317622681d6b6,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x4012ee8b19688964,
    0x0, 0x0,
    0xbfeccccccccccc9b, 0x4012c65b61126cf4,
    0x0, 0x0,
    0xbfecccccccccccfe, 0x40129ecef52b8ab4,
    0x0, 0x0,
    0xbfecccccccccccb2, 0x401277e1ee46cf50,
    0x0, 0x0,
    0xbfecccccccccccb4, 0x4012519084911f9c,
    0x0, 0x0,
    0xbfeccccccccccd22, 0x40122bd70e9416ca,
    0x0, 0x0,
    0xbfeccccccccccc80, 0x401206b2000796b2,
    0x0, 0x0,
    0xbfecccccccccccea, 0x4011e21de8b15908,
    0x0, 0x0,
    0xbfeccccccccccce7, 0x4011be177351c61c,
    0x0, 0x0,
    0xbfeccccccccccca8, 0x40119a9b649d5703,
    0x0, 0x0,
    0xbfeccccccccccd08, 0x401177a69a41de4c,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x4011553609f713b6,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x40113346c099cfb9,
    0x0, 0x0,
    0xbfecccccccccccc0, 0x401111d5e151676f,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x4010f0e0a4bea54f,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x4010d0645833e0bb,
    0x0, 0x0,
    0xbfeccccccccccce0, 0x4010b05e5cf5beaa,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x401090cc27842c0e,
    0x0, 0x0,
    0xbfecccccccccccdb, 0x401071ab3eeb2916,
    0x0, 0x0,
    0xbfecccccccccccb6, 0x401052f93c1b0268,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x401034b3c9479aaf,
    0x0, 0x0,
    0xbfeccccccccccd12, 0x401016d8a14e6c73,
    0x0, 0x0,
    0xbfeccccccccccc94, 0x400ff2cb1e45e1e6,
    0x0, 0x0,
    0xbfecccccccccccc0, 0x400fb8b0da8239df,
    0x0, 0x0,
    0xbfeccccccccccce2, 0x400f7f5e4a4b52cb,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x400f46cf5d97c2d8,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x400f0f0020616572,
    0x0, 0x0,
    0xbfecccccccccccbf, 0x400ed7ecb9b583cb,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x400ea1916ace8d12,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x400e6bea8e36ed42,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x400e36f496f497c5,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x400e02ac0fbcdfb2,
    0x0, 0x0,
    0xbfecccccccccccde, 0x400dcf0d9a303e38,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x400d9c15ee1daad2,
    0x0, 0x0,
    0xbfecccccccccccbf, 0x400d69c1d8cd2f32,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x400d380e3c5164ba,
    0x0, 0x0,
    0xbfecccccccccccbc, 0x400d06f80edf8cd4,
    0x0, 0x0,
    0xbfeccccccccccd40, 0x400cd67c5a2dfa54,
    0x0, 0x0,
    0xbfeccccccccccc61, 0x400ca6983ad8852a,
    0x0, 0x0,
    0xbfecccccccccccdd, 0x400c7748dfcac5b3,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x400c488b89afd780,
    0x0, 0x0,
    0xbfecccccccccccdb, 0x400c1a5d8a676748,
    0x0, 0x0,
    0xbfecccccccccccca, 0x400becbc447fd1fc,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x400bbfa52ab51ed6,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x400b9315bf749f37,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x400b670b9465036b,
    0x0, 0x0,
    0xbfecccccccccccd9, 0x400b3b8449f2b42e,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x400b107d8ee044b8,
    0x0, 0x0,
    0xbfecccccccccccd7, 0x400ae5f51fdad145,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x400abbe8c71221f0,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x400a92565bd46a15,
    0x0, 0x0,
    0xbfecccccccccccb8, 0x400a693bc22d7f8a,
    0x0, 0x0,
    0xbfecccccccccccdd, 0x400a4096ea8965a2,
    0x0, 0x0,
    0xbfecccccccccccf8, 0x400a1865d15a0a00,
    0x0, 0x0,
    0xbfeccccccccccca1, 0x4009f0a67ec01331,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x4009c9570636a192,
    0x0, 0x0,
    0xbfecccccccccccdd, 0x4009a2758641e54c,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x40097c0028206d08,
    0x0, 0x0,
    0xbfecccccccccccda, 0x400955f51f7f11e8,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x40093052aa2f67e6,
    0x0, 0x0,
    0xbfecccccccccccce, 0x40090b170fe098f0,
    0x0, 0x0,
    0xbfecccccccccccbe, 0x4008e640a1da9398,
    0x0, 0x0,
    0xbfecccccccccccdc, 0x4008c1cdbabb76cb,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x40089dbcbe3724aa,
    0x0, 0x0,
    0xbfecccccccccccd9, 0x40087a0c18d8e836,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x400856ba3fc7199c,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x400833c5b088ae55,
    0x0, 0x0,
    0xbfecccccccccccb7, 0x4008112cf0cca30d,
    0x0, 0x0,
    0xbfecccccccccccac, 0x4007eeee8e332dc3,
    0x0, 0x0,
    0xbfecccccccccccbb, 0x4007cd091e18a75c,
    0x0, 0x0,
    0xbfeccccccccccced, 0x4007ab7b3d621cf4,
    0x0, 0x0,
    0xbfecccccccccccec, 0x40078a43904b797e,
    0x0, 0x0,
    0xbfeccccccccccce0, 0x40076960c23738bc,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x400748d1857f95f2,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x4007289493492862,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x400708a8ab56e0f6,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x4006e90c93df5c48,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x4006c9bf19637d5a,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x4006aabf0e864564,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x40068c0b4be5dde5,
    0x0, 0x0,
    0xbfecccccccccccca, 0x40066da2aff5c9e0,
    0x0, 0x0,
    0xbfecccccccccccc0, 0x40064f841eda34ef,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x400631ae82445572,
    0x0, 0x0,
    0xbfecccccccccccb4, 0x40061420c94fd965,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x4005f6d9e8615417,
    0x0, 0x0,
    0xbfeccccccccccceb, 0x4005d9d8d905a46b,
    0x0, 0x0,
    0xbfecccccccccccb7, 0x4005bd1c99d24b78,
    0x0, 0x0,
    0xbfecccccccccccbe, 0x4005a0a42e46aaf6,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x4005846e9eae2478,
    0x0, 0x0,
    0xbfecccccccccccce, 0x4005687af8031163,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x40054cc84bd28cac,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x40053155b02107e0,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x400516223f4fa42e,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x4004fb2d18024994,
    0x0, 0x0,
    0xbfecccccccccccd9, 0x4004e0755d0675d4,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x4004c5fa353abd50,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x4004abbacb76f818,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x400491b64e7515b9,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x400477ebf0ba925a,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x40045e5ae8828850,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x400445026fa85927,
    0x0, 0x0,
    0xbfeccccccccccd10, 0x40042be1c392e8d7,
    0x0, 0x0,
    0xbfeccccccccccc8e, 0x400412f82520680c,
    0x0, 0x0,
    0xbfecccccccccccd7, 0x4003fa44d892a698,
    0x0, 0x0,
    0xbfecccccccccccce, 0x4003e1c7257bed45,
    0x0, 0x0,
    0xbfecccccccccccdf, 0x4003c97e56ac5706,
    0x0, 0x0,
    0xbfecccccccccccbf, 0x4003b169ba1fa8d9,
    0x0, 0x0,
    0xbfecccccccccccce, 0x40039988a0eba298,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x400381da5f2ec5e0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x40036a5e4bff8f03,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x40035313c15c1cf8,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x40033bfa1c1a44f0,
    0x0, 0x0,
    0xbfecccccccccccdf, 0x40032510bbd80ddc,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x40030e5702ec917b,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x4002f7cc56593f6a,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x4002e1701dbb7fb2,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x4002cb41c33eb1b8,
    0x0, 0x0,
    0xbfeccccccccccd04, 0x4002b540b38e84e6,
    0x0, 0x0,
    0xbfecccccccccccaf, 0x40029f6c5dc9a8ee,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x400289c43374d211,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x40027447a86e1057,
    0x0, 0x0,
    0xbfecccccccccccd9, 0x40025ef632e0762a,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x400249cf4b380c96,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x400234d26c161314,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x40021fff12458867,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x40020b54bcaffaa8,
    0x0, 0x0,
    0xbfecccccccccccb0, 0x4001f6d2ec529c8c,
    0x0, 0x0,
    0xbfeccccccccccce9, 0x4001e27924339da5,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x4001ce46e957c46a,
    0x0, 0x0,
    0xbfecccccccccccb8, 0x4001ba3bc2b8472f,
    0x0, 0x0,
    0xbfeccccccccccc7b, 0x4001a6573938e355,
    0x0, 0x0,
    0xbfeccccccccccd01, 0x40019298d79e302f,
    0x0, 0x0,
    0xbfecccccccccccf2, 0x40017f002a842cd9,
    0x0, 0x0,
    0xbfeccccccccccc58, 0x40016b8cc05505fe,
    0x0, 0x8000000000000000,
    0xbfeccccccccccd41, 0x4001583e29401360,
    0x0, 0x0,
    0xbfeccccccccccca5, 0x40014513f7310bc4,
    0x0, 0x0,
    0xbfeccccccccccc91, 0x4001320dbdc76b6b,
    0x0, 0x0,
    0xbfeccccccccccd21, 0x40011f2b124e0f40,
    0x0, 0x0,
    0xbfeccccccccccce1, 0x40010c6b8bb30097,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x4000f9cec27f7106,
    0x0, 0x0,
    0xbfecccccccccccb1, 0x4000e75450cfe5ab,
    0x0, 0x0,
    0xbfecccccccccccec, 0x4000d4fbd24c8fa9,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x4000c2c4e421d169,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x4000b0af24f8eecf,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x40009eba34f0e7cb,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x40008ce5b5977bfb,
    0x0, 0x0,
    0xbfecccccccccccbf, 0x40007b3149e2560b,
    0x0, 0x0,
    0xbfecccccccccccc1, 0x4000699c96285e33,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x40005827401b32a4,
    0x0, 0x0,
    0xbfeccccccccccce8, 0x400046d0eec0c4a8,
    0x0, 0x0,
    0xbfeccccccccccc9e, 0x400035994a6d1a29,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x4000247ffcbc31bf,
    0x0, 0x0,
    0xbfecccccccccccca, 0x40001384b08c0990,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x400002a711f6c6f8,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fffe3cd9c99fd92,
    0x0, 0x0,
    0xbfecccccccccccbb, 0x3fffc28728203add,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fffa17a25d9db3e,
    0x0, 0x0,
    0xbfecccccccccccbf, 0x3fff80a5f76c7aa4,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fff600a00bf3fca,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fff3fa5a7f099e7,
    0x0, 0x0,
    0xbfecccccccccccc1, 0x3fff1f78554c362f,
    0x0, 0x0,
    0xbfecccccccccccd7, 0x3ffeff8173412b8a,
    0x0, 0x0,
    0xbfecccccccccccbd, 0x3ffedfc06e585b7f,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3ffec034b52b06c2,
    0x0, 0x0,
    0xbfecccccccccccb7, 0x3ffea0ddb859948f,
    0x0, 0x0,
    0xbfeccccccccccd0b, 0x3ffe81baea828ae2,
    0x0, 0x0,
    0xbfeccccccccccc91, 0x3ffe62cbc039b708,
    0x0, 0x0,
    0xbfecccccccccccd9, 0x3ffe440fafff84e0,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3ffe25863238844b,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x3ffe072ec1251aee,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x3ffde908d8d96176,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3ffdcb13f7352be1,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ffdad4f9bdc3b0f,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3ffd8fbb482e96d8,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3ffd72567f410fda,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3ffd5520c5d5e810,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ffd3819a255a0fa,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x3ffd1b409cc7eecf,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ffcfe953ecccf9c,
    0x0, 0x0,
    0xbfecccccccccccbd, 0x3ffce2171395c5c1,
    0x0, 0x0,
    0xbfecccccccccccd7, 0x3ffcc5c5a7df34b1,
    0x0, 0x0,
    0xbfecccccccccccde, 0x3ffca9a089e9df3c,
    0x0, 0x0,
    0xbfecccccccccccb8, 0x3ffc8da7497486da,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3ffc71d977b5aac2,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3ffc5636a75566b1,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ffc3abe6c67701d,
    0x0, 0x0,
    0xbfecccccccccccda, 0x3ffc1f705c65310a,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ffc044c0e2800ce,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3ffbe95119e378e2,
    0x0, 0x0,
    0xbfecccccccccccbe, 0x3ffbce7f191fe5b2,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3ffbb3d5a6b4d313,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ffb99545ec3b30f,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ffb7efadeb29f00,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ffb64c8c527323f,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ffb4abdb2017da2,
    0x0, 0x0,
    0xbfecccccccccccbe, 0x3ffb30d946571384,
    0x0, 0x0,
    0xbfecccccccccccb9, 0x3ffb171b246e2bb5,
    0x0, 0x0,
    0xbfecccccccccccbe, 0x3ffafd82efb8deb0,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x3ffae4104cd077ac,
    0x0, 0x0,
    0xbfecccccccccccdd, 0x3ffacac2e170dd3c,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3ffab19a54740f74,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ffa98964dcdbbc0,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ffa7fb67686e56e,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3ffa66fa78b9a2fe,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ffa4e61ff8cef3b,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3ffa35ecb7308e0a,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ffa1d9a4cd9045e,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ffa056a6ebba33e,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff9ed5ccc0aa4a0,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3ff9d57114f15ae6,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff9bda6fa907173,
    0x0, 0x0,
    0xbfecccccccccccba, 0x3ff9a5fe2efa3ef8,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ff98e76652f2848,
    0x0, 0x0,
    0xbfeccccccccccce0, 0x3ff9770f511a13d3,
    0x0, 0x0,
    0xbfecccccccccccba, 0x3ff95fc8a78ced96,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3ff948a21e3d3a41,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ff9319b6bc0baca,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff91ab4478a1e8c,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff903ec69e5c44c,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x3ff8ed438bf68a62,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ff8d6b967b2aca2,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3ff8c04db7e0b07d,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3ff8aa0038145ee9,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3ff893d0a4abcb94,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ff87dbebacc697c,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff867ca38602c12,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff851f2dc12b572,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x3ff83c38654e909e,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3ff8269a943a783c,
    0x0, 0x0,
    0xbfecccccccccccf6, 0x3ff8111929b6a8ba,
    0x0, 0x0,
    0xbfecccccccccccaa, 0x3ff7fbb3e75a3f0a,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff7e66a8f70a106,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff7d13ce4f6f3b9,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3ff7bc2aab9999e2,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ff7a733a7b1bf16,
    0x0, 0x0,
    0xbfecccccccccccc0, 0x3ff792579e42eca4,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff77d9654f8a92c,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ff768ef9224221a,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ff754631cb9df37,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3ff73ff0bc4f8024,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff72b9839198308,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff717595be9151e,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff70333ee29ebe4,
    0x0, 0x0,
    0xbfecccccccccccc0, 0x3ff6ef27b9e027fc,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3ff6db3489a64065,
    0x0, 0x0,
    0xbfeccccccccccce1, 0x3ff6c75a28aaf699,
    0x0, 0x0,
    0xbfecccccccccccba, 0x3ff6b39862af5353,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff69fef0404ab2f,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff68c5dd98aac61,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3ff678e4b0ad73b3,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3ff665835763a994,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3ff652399c2ca73d,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ff63f074e0ea31c,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff62bec3c94e4e0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff618e837ce00c0,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3ff605fb104a1a14,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3ff5f32497192ccf,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3ff5e0649dc95e2d,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff5cdbaf66553a8,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3ff5bb27737291b4,
    0x0, 0x0,
    0xbfecccccccccccba, 0x3ff5a8a9e7efdf40,
    0x0, 0x0,
    0xbfecccccccccccfe, 0x3ff596422753b1bb,
    0x0, 0x0,
    0xbfeccccccccccc99, 0x3ff583f0058a9d95,
    0x0, 0x0,
    0xbfecccccccccccda, 0x3ff571b356f5ce60,
    0x0, 0x0,
    0xbfecccccccccccc1, 0x3ff55f8bf06983d4,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff54d79a72b961a,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3ff53b7c50f1fe48,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff52993c3e166bf,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff517bfd68bbf1c,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff506005feed73a,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3ff4f4553772fec8,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff4e2be34e9aae7,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ff4d13b308c206d,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff4bfcc02fa23ce,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff4ae708538add4,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x3ff49d2890b0a58a,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff48bf3ff2d9ee8,
    0x0, 0x0,
    0xbfecccccccccccdd, 0x3ff47ad2aadc9e62,
    0x0, 0x0,
    0xbfecccccccccccbc, 0x3ff469c46e4ae14c,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff458c92464aa82,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff447e0a874145e,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff4370ad61fe67c,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3ff42647896a7014,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3ff415969eb066ff,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ff404f7f2a7caa6,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff3f46b625ecb42,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3ff3e3f0cb3ab53e,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff3d3880af6e09d,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff3c330ffa3a470,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff3b2eb87a54e23,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3ff3a2b781b31c92,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff39294ccd63f15,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x3ff382834868d82c,
    0x0, 0x0,
    0xbfecccccccccccfb, 0x3ff37282d41503ca,
    0x0, 0x0,
    0xbfeccccccccccca3, 0x3ff362934fd3e158,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3ff352b49beca0d2,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3ff342e698f39448,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3ff3332927c943d5,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff3237c2999854f,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3ff313df7fda9788,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff304530c4c406a,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ff2f4d6b0f6ee79,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff2e56a502add67,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ff2d60dcc7f3ddc,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff2c6c108d16022,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff2b783e843e1ee,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ff2a8564e3ddefd,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x3ff299381e6a24bb,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ff28a293cb668a4,
    0x0, 0x0,
    0xbfecccccccccccdf, 0x3ff27b298d52817e,
    0x0, 0x0,
    0xbfecccccccccccbc, 0x3ff26c38f4afa361,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3ff25d57577f9e3e,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff24e849ab41f76,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff23fc0a37df5c2,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ff2310b574c5798,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3ff222649bcc2c88,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff213cc56e758b6,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3ff205426ec40af1,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3ff1f6c6c9c40d2d,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ff1e8594e84177d,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ff1d9f9e3db2528,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff1cba870d9cc4b,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3ff1bd64dcc997a2,
    0x0, 0x0,
    0xbfecccccccccccbf, 0x3ff1af2f0f2c628e,
    0x0, 0x0,
    0xbfecccccccccccbd, 0x3ff1a106efbbb75c,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x3ff192ec66682fa3,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x3ff184df5b58d6ce,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x3ff176dfb6ea8eef,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ff168ed61af7731,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff15b08446e54c7,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3ff14d304821fd90,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3ff13f6555f8c4ea,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3ff131a75753ea5a,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3ff123f635c70a19,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff11651db178f7e,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ff108ba313c297f,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ff0fb2f225c4095,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff0edb098cf6ef3,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff0e03e7f1cfa05,
    0x0, 0x0,
    0xbfecccccccccccbd, 0x3ff0d2d8bffb4e0b,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff0c57f464f7b39,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x3ff0b831fd2cb494,
    0x0, 0x0,
    0xbfecccccccccccbf, 0x3ff0aaf0cfd3d09c,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ff09dbba9b2cb20,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3ff0909276644987,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff0837521af1ff0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff076639785d80e,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3ff0695dc40639e0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff05c639378d5a4,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ff04f74f2508f53,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3ff04291cd2a2ba8,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff035ba10cbdeae,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff028edaa24db80,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x3ff01c2c864ce5a6,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3ff00f769283e3d8,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ff002cbbc3173ef,
    0x0, 0x0,
    0xbfecccccccccccbf, 0x3fefec57e1c90122,
    0x0, 0x0,
    0xbfecccccccccccda, 0x3fefd32e3ca5aef9,
    0x0, 0x0,
    0xbfecccccccccccbb, 0x3fefba1a64b184d0,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fefa11c35f13e34,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fef88338cb4f730,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fef6f60459761a2,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3fef56a23d7d0094,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fef3df9519364c8,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fef25655f506bd5,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fef0ce644718184,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3feef47bdefae3c8,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x3feedc260d36e8e0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3feec3e4adb5478b,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3feeabb79f4a61f7,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3fee939ec10e9220,
    0x0, 0x0,
    0xbfecccccccccccbf, 0x3fee7b99f25d797a,
    0x0, 0x0,
    0xbfecccccccccccdb, 0x3fee63a912d5518f,
    0x0, 0x0,
    0xbfecccccccccccdd, 0x3fee4bcc02563f7a,
    0x0, 0x0,
    0xbfecccccccccccbd, 0x3fee3402a101a961,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fee1c4ccf398d6c,
    0x0, 0x0,
    0xbfecccccccccccb9, 0x3fee04aa6d9fdbf5,
    0x0, 0x0,
    0xbfecccccccccccbe, 0x3feded1b5d15d248,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fedd59f7ebb5846,
    0x0, 0x0,
    0xbfecccccccccccbd, 0x3fedbe36b3ee5ff0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3feda6e0de4a467c,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fed8f9ddfa7376a,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fed786d9a199186,
    0x0, 0x0,
    0xbfecccccccccccac, 0x3fed614feff14e2c,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fed4a44c3b9698e,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fed334bf8374d12,
    0x0, 0x0,
    0xbfeccccccccccd0f, 0x3fed1c65706a3bd9,
    0x0, 0x0,
    0xbfeccccccccccc8a, 0x3fed05910f8ac07d,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3feceeceb90a1cff,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fecd81e5091ba6a,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fecc17fba02a26a,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fecaaf2d974e5ff,
    0x0, 0x0,
    0xbfeccccccccccd0a, 0x3fec94779337257d,
    0x0, 0x0,
    0xbfeccccccccccc8f, 0x3fec7e0dcbcdfad9,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fec67b567f37912,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fec516e4c96a60e,
    0x0, 0x0,
    0xbfecccccccccccec, 0x3fec3b385edaf72c,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fec25138417cf46,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fec0effa1d7fe2a,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3febf8fc9dd9423c,
    0x0, 0x0,
    0xbfecccccccccccdd, 0x3febe30a5e0bc9f0,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3febcd28c891b886,
    0x0, 0x0,
    0xbfecccccccccccde, 0x3febb757c3beab28,
    0x0, 0x0,
    0xbfecccccccccccd9, 0x3feba19736173fb5,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3feb8be706509ccc,
    0x0, 0x0,
    0xbfecccccccccccdd, 0x3feb76471b4ffb21,
    0x0, 0x0,
    0xbfecccccccccccbd, 0x3feb60b75c2a30da,
    0x0, 0x0,
    0xbfecccccccccccbb, 0x3feb4b37b0233cef,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3feb35c7feadd54a,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3feb20682f6af560,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3feb0b182a296dc7,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3feaf5d7d6e5762b,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3feae0a71dc83f30,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x3feacb85e72786b8,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x3feab6741b852c74,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3feaa171a38ec825,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fea8c7e681d4108,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3fea779a52346644,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fea62c54b028862,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fea4dff3be01430,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fea39480e4f2eb4,
    0x0, 0x0,
    0xbfeccccccccccceb, 0x3fea249fabfb51f0,
    0x0, 0x0,
    0xbfecccccccccccba, 0x3fea1005feb8eb69,
    0x0, 0x0,
    0xbfecccccccccccdf, 0x3fe9fb7af084fa32,
    0x0, 0x0,
    0xbfecccccccccccc0, 0x3fe9e6fe6b84b09e,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fe9d2905a051460,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3fe9be30a67aa12c,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fe9a9df3b80ec10,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe9959c03da47cc,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe98166ea6f69e1,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe96d3fda4f10fe,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe95926beadac68,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe9451b82e503d8,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe9311e1273e0dc,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe91d2e58fdb8f0,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fe9094c424a584e,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fe8f577ba458e0f,
    0x0, 0x0,
    0xbfecccccccccccd7, 0x3fe8e1b0acfed8cf,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fe8cdf706a914a8,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe8ba4ab39a2922,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe8a6aba04ab97e,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe89319b955d482,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fe87f94eb78a576,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fe86c1d2392268a,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe858b24ea2d356,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe8455459cc5ca4,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x3fe8320332515ca2,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fe81ebec5950c54,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe80b87011af954,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe7f85bd286bcd0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe7e53d279bb2de,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fe7d22aee3cb2e2,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fe7bf25146bc876,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fe7ac2b8849ed5b,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3fe7993e3816c3ae,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3fe7865d12305190,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe773880512bc94,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe760beff5806ab,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe74e01efb7cb36,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fe73b50c506fd50,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fe728ab6e37a646,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe71611da58a506,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fe70383f8956df2,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe6f101b835cbe7,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe6de8b089da0fc,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe6cc1fd94ca910,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe6b9c019de3bbb,
    0x0, 0x0,
    0xbfecccccccccccc1, 0x3fe6a76bba091003,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fe69522a99effd8,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3fe682e4d88ccc92,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x3fe670b236d9e424,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fe65e8ab4a82613,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe64c6e4233aa86,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe63a5ccfd2887a,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe628564df49d0c,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fe6165aad2353c0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe60469de016e98,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe5f283d14acf5a,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fe5e0a877d440de,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe5ced7c28b417b,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fe5bd11a275cd4c,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe5ab5608b22996,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe599a4e676b056,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3fe587fe2d119c70,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe57661cde8d694,
    0x0, 0x0,
    0xbfecccccccccccdb, 0x3fe564cfba79c200,
    0x0, 0x0,
    0xbfecccccccccccbf, 0x3fe55347e4590b3d,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fe541ca3d32742c,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe53056b6c8a58a,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fe51eed42f4fbcc,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe50d8dd3a757d6,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3fe4fc385ae5eec9,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe4eaeccacd1aaa,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe4d9ab158f2b59,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe4c8732d7437f8,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe4b74504d9f114,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe4a6208e3372be,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe49505bc091784,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe483f480f84b84,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x3fe472eccfb36044,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe461ee9b0160bb,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3fe450f9d5bde5b8,
    0x0, 0x0,
    0xbfecccccccccccc1, 0x3fe4400e72d8eb10,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe42f2c6556a457,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe41e53a04f5378,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe40d8416ef1e40,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fe3fcbdbc75e4ec,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fe3ec008437195e,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe3db4c6199961e,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe3caa148177640,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x3fe3b9ff2b3ded6b,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe3a965fead201f,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fe398d5b617fcc6,
    0x0, 0x0,
    0xbfecccccccccccc1, 0x3fe3884e454414b5,
    0x0, 0x0,
    0xbfecccccccccccdd, 0x3fe377cfa00975ad,
    0x0, 0x0,
    0xbfecccccccccccbd, 0x3fe36759ba5283f0,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe356ec881bd47c,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3fe34687fd74070e,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fe3362c0e7ba2a6,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe325d8af64ee28,
    0x0, 0x0,
    0xbfecccccccccccd9, 0x3fe3158dd473cf21,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x3fe3054b71fda32d,
    0x0, 0x0,
    0xbfecccccccccccdd, 0x3fe2f5117c691da6,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fe2e4dfe82e23de,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fe2d4b6a9d5a9f7,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fe2c495b5f99047,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe2b47d014480e8,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe2a46c8071cda3,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe29464284d4e0e,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe28463edb33e30,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe2746bc5901d1e,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fe2647ba4e08c5e,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fe2549380b12f0a,
    0x0, 0x0,
    0xbfecccccccccccda, 0x3fe244b34e1e89b2,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3fe234db0254e276,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe2250a929020ba,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe21541f41bae85,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe205811c5258f8,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fe1f5c8009e312d,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fe1e61696786e0f,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe1d66cd3694dc8,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fe1c6caad07f7d2,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3fe1b73018fa5f04,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe1a79d0cf5243b,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe198117ebb78e8,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe1888d641f0253,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe17910b2ffbc7c,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe1699b614bddda,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fe15a2d64ffbb2b,
    0x0, 0x0,
    0xbfeccccccccccce4, 0x3fe14ac6b425ab23,
    0x0, 0x0,
    0xbfecccccccccccba, 0x3fe13b6744d5eb65,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3fe12c0f0d368388,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fe11cbe037b2bb9,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fe10d741de5303d,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe0fe3152c3574b,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fe0eef59871c640,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fe0dfc0e559e763,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe0d0932ff24fd6,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe0c16c6ebea57e,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe0b24c984f859c,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe0a333a3426b21,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fe09421864195a5,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe085163803f038,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3fe07611af4cf8c1,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe06713e2eca746,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x3fe0581cc9bf55a8,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x3fe0492c5aada78a,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe03a428cac71e1,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe02b5f56bca3e8,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe01c82afeb2f3e,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe00dac8f50f040,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fdffdb9d8252eb0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fdfe0277ac1238a,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fdfc2a1f4ede5da,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fdfa529353abb58,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fdf87bd2a4ddc34,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fdf6a5dc2e44650,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fdf4d0aedd19190,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fdf2fc499ffc3d2,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3fdf128ab66f25f6,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fdef55d3236189a,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fded83bfc80e9ae,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fdebb270491aa30,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3fde9e1e39c00474,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fde81218b791242,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fde6430e93f33b8,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fde474c42a9e66c,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fde2a7387659d0e,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fde0da6a7339714,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fddf0e591e9b8c4,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fddd430377263aa,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fddb78687cc4fca,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fdd9ae8730a63c6,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fdd7e55e9538f56,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fdd61cedae2a41c,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x3fdd455338063064,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fdd28e2f12058d6,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fdd0c7df6a6b382,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fdcf024392222e2,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fdcd3d5a92eb04c,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fdcb792377b686c,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fdc9b59d4ca36e6,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fdc7f2c71efc1b4,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fdc6309ffd34668,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fdc46f26f6e765e,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fdc2ae5b1cd53c6,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fdc0ee3b80e0ede,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fdbf2ec7360e39c,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fdbd6ffd507f71c,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fdbbb1dce5735e8,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fdb9f4650b43228,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fdb83794d960254,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fdb67b6b6852010,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3fdb4bfe7d1b4690,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fdb3050930353f8,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fdb14ace9f9250c,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fdaf91373c97a18,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fdadd842251d2bc,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fdac1fee78050ba,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fdaa683b5539734,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fda8b127ddaaca4,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fda6fab3334dafe,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fda544dc7919152,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fda38fa2d3045a0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fda1db0566055fc,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fda02703580eb42,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fd9e739bd00da84,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fd9cc0cdf5e885e,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd9b0e98f27cafa,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x3fd995cfbef9cce0,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fd97abf6180f162,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd95fb86978b57c,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fd944bac9ab95d2,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fd929c674f2f140,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd90edb5e36ece6,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fd8f3f9786e585a,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fd8d920b69e9242,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd8be510bdb6cd8,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd8a38a6b471296,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3fd888ccc811eada,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd86e18157a8084,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fd8536c46cd6546,
    0x0, 0x0,
    0xbfecccccccccccbf, 0x3fd838c94f6518fe,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3fd81e2f22a9ed8a,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3fd8039db411f04e,
    0x0, 0x0,
    0xbfecccccccccccb7, 0x3fd7e914f720cc74,
    0x0, 0x0,
    0xbfeccccccccccce0, 0x3fd7ce94df67b160,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fd7b41d60853ef6,
    0x0, 0x0,
    0xbfecccccccccccbf, 0x3fd799ae6e2563aa,
    0x0, 0x0,
    0xbfecccccccccccdd, 0x3fd77f47fc0149a6,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fd764e9fddf3d02,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd74a946792902c,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fd730472cfb862a,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fd71602420738ae,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd6fbc59aaf8150,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd6e1912afadfc6,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd6c764e6fc6322,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd6ad40c2d391fe,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fd69324b2ac52b4,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3fd67910aabed3f2,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fd65f049f4f75e8,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fd6450084aeb2d2,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x3fd62b044f3908c8,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fd6110ff356e140,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fd5f723657c7d4c,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd5dd3e9a29dcb4,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fd5c36185eaa8d8,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fd5a98c1d561e84,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd58fbe550ef7ac,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fd575f821c3561c,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fd55c39782cad48,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd542824d0fad44,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fd528d2953c2d14,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd50f2a458d1598,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd4f58952e84ccc,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fd4dbefb23e9ff8,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x3fd4c25d588bb014,
    0x0, 0x0,
    0xbfecccccccccccde, 0x3fd4a8d23ad5dc10,
    0x0, 0x0,
    0xbfecccccccccccc0, 0x3fd48f4e4e2e2de8,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3fd475d187b04348,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fd45c5bdc823d2c,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fd442ed41d4a8f0,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fd42985ace26d58,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd4102512f0b6cc,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd3f6cb694ee39c,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd3dd78a5567030,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd3c42cbc6ae3b4,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd3aae7a3f9bd30,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd391a9517a5fc4,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd37871ba6dfff4,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fd35f40d45f9078,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fd3461694e3afd4,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fd32cf2f1989514,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fd313d5e025fdf4,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fd2fabf563d1be8,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd2e1af49988178,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fd2c8a5affc1108,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd2afa27f34ea2c,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fd296a5ad195748,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd27daf2f88bc7c,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fd264befc6b8548,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fd24bd509b3135c,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fd232f14d59ac7c,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fd21a13bd6269d4,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd2013c4fd925f0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd1e86afad26c04,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fd1cf9fb46b668c,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fd1b6da72c9ce7c,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fd19e1b2c1bda34,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd18561d6982cb8,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fd16cae687dc51c,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fd15400d813ee28,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd13b591baa2d58,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fd122b7299832b8,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fd10a1af83dc898,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fd0f1847e02c380,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd0d8f3b156f1e4,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fd0c06888b20c58,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd0a7e2fa93a564,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd08f62fd831a24,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fd076e8880f8210,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fd05e7390cf9fc4,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd046040e61d120,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fd02d99f76c0060,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd01535429b940c,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fcff9abcd4ac0a0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fcfc8f7b48b2fd0,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fcf984e287f77b8,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fcf67af16bd1c40,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fcf371a6ce803b0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fcf069018b25898,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fced61007dc6d50,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fcea59a28349e20,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fce752e67973488,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fce44ccb3ee4960,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fce1474fb31a950,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fcde4272b66b6e0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fcdb3e332a04ee0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fcd83a8fefeaba0,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fcd53787eaf4880,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fcd23519fecc6b0,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fccf33450fed018,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fccc3208039fea0,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fcc93161bffb9e0,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fcc631512be24c0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fcc331d52effac0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fcc032ecb1c78b8,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fcbd34969d74040,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fcba36d1dc03d68,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fcb7399d5838bf0,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fcb43cf7fd95c98,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fcb140e0b85dae0,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fcae45567591250,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fcab4a5822ed4e0,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fca84fe4aeea020,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fca555fb08b8450,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fca25c9a2040970,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fc9f63c0e6216e8,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fc9c6b6e4bad998,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fc9973a142ea868,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fc967c58be8eef8,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fc938593b201170,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fc908f5111553f0,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fc8d998fd14c2f8,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fc8aa44ee751900,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fc87af8d497a720,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fc84bb49ee83ba0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc81c783cdd0a60,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fc7ed439df69350,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fc7be16b1bf8c10,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x3fc78ef167ccc560,
    0x0, 0x0,
    0xbfecccccccccccd7, 0x3fc75fd3afbd1690,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x3fc730bd793941d0,
    0x0, 0x0,
    0xbfeccccccccccce4, 0x3fc701aeb3f3df00,
    0x0, 0x0,
    0xbfecccccccccccb4, 0x3fc6d2a74fa944c0,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3fc6a3a73c1f6c80,
    0x0, 0x0,
    0xbfecccccccccccbc, 0x3fc674ae6925e170,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3fc645bcc695a400,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fc616d244511480,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc5e7eed243dd30,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc5b9126062d960,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x3fc58a3cdeabff70,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fc55b6e3d2649d0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc52ca66be1a0c0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc4fde55af6c2d0,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fc4cf2afa872f60,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc4a0773abd0fa0,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fc471ca0bcb2000,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fc443235dec9ac0,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fc4148321652120,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc3e5e94680a670,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fc3b755bd935770,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fc388c876f98820,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fc35a4163179b60,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fc32bc07259ee20,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc2fd459534c190,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc2ced0bc2425f0,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fc2a061d7abe500,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fc271f8d8576c30,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fc24395aeb9b8a0,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fc215384b6d4020,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fc1e6e09f13dda0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fc1b88e9a56bbb0,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fc18a422de63f00,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x3fc15bfb4a79f2c0,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x3fc12db9e0d071f0,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x3fc0ff7de1af5650,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fc0d1473de31d10,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fc0a315e63f1aa0,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fc074e9cb9d5fe0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc046c2dedea830,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fc018a110ea44d0,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fbfd508a55c11a0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fbf78d92a3c68a0,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fbf1cb3926ac100,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fbec097bfe8d8c0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fbe648594c4ce80,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fbe087cf318fc80,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fbdac7dbd0bcf20,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fbd5087d4cf9e20,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fbcf49b1ca28420,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fbc98b776ce3900,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fbc3cdcc5a7e9e0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fbbe10aeb900f00,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fbb8541caf24a80,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fbb298146453dc0,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fbacdc9400a6280,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fba72199acde5a0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fba167239268000,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fb9bad2fdb55040,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fb95f3bcb25b340,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fb903ac842d2040,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fb8a8250b8b0100,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fb84ca544088c80,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fb7f12d10789f80,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fb795bc53b799c0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fb73a52f0ab3500,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fb6def0ca426200,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fb68395c37521c0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fb62841bf446040,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fb5ccf4a0b9cf80,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fb571ae4ae7c1c0,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fb5166ea0e90400,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fb4bb3585e0ba80,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fb46002dcfa3a80,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fb404d68968e600,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fb3a9b06e680600,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fb34e906f3aa7c0,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fb2f3766f2b7580,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fb29862518c9480,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fb23d53f9b77ec0,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fb1e24b4b0cdf00,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fb1874828f46d80,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fb12c4a76dcca00,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fb0d152183b5a00,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fb0765ef08c2000,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fb01b70e3519d80,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3faf810fa8295780,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3faecb474cc8ae80,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fae15887bab7b00,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fad5fd2fc07d080,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3facaa26951f5580,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fabf4830e3ef880,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fab3ee82ebeaf80,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3faa8955be012780,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fa9d3cb83738700,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fa91e49468d2100,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fa868cececf3100,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fa7b35be3c49100,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fa6fdf04d017900,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3fa6488bd2233700,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fa5932e3acfd900,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fa4ddd74eb60600,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fa42886d58c9d00,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fa3733c97127800,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fa2bdf85b0e2900,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fa208b9e94db000,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fa1538109a63400,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fa09e4d83f3c000,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3f9fd23e40320000,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3f9e67eb4bfdec00,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3f9cfda1bb296a00,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3f9b93611d9e4400,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3f9a292903514000,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3f98bef8fc41b800,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3f9754d098790800,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3f95eaaf6809dc00,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3f948094fb0fe000,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3f931680e1af0400,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3f91ac72ac132800,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3f904269ea6f5400,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3f8db0cc59faa800,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3f8adcce07fa4000,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3f8808d7ff68d000,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3f8534e960dbb000,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3f8261014cf1e000,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3f7f1a3dc8a38000,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3f7972828f528000,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3f73cacf2f57c000,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3f6c4643d4488000,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3f60f6f202620000,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3f469e95afe00000,
    0x0
    };

